/**
 * @file iot_ethernet_kit.h
 * @brief IoT Ethernet Kit
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _IOT_ETHERNET_KIT_H
#define _IOT_ETHERNET_KIT_H

//Dependencies
#include <p32xxxx.h>

//LED1 (RB13)
#define LED1_MASK (1 << 13)
//LED2 (RB12)
#define LED2_MASK (1 << 12)
//LED3 (RF1)
#define LED3_MASK (1 << 1)
//LED4 (RC15)
#define LED4_MASK (1 << 15)

//SW1 (RB10)
#define SW1_MASK (1 << 10)
//SW2 (RB8)
#define SW2_MASK (1 << 8)
//SW3 (RF0)
#define SW3_MASK (1 << 0)
//SW4 (RD5)
#define SW4_MASK (1 << 5)

#endif
