/**
 * @file pic32mz_ec_starter_kit.h
 * @brief PIC32MZ EC Starter Kit
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _PIC32MZ_EC_STARTER_KIT_H
#define _PIC32MZ_EC_STARTER_KIT_H

//Dependencies
#include <p32xxxx.h>

//LEDs
#define LED1_MASK (1 << 0)
#define LED2_MASK (1 << 1)
#define LED3_MASK (1 << 2)

//Push buttons
#define SW1_MASK (1 << 12)
#define SW2_MASK (1 << 13)
#define SW3_MASK (1 << 14)

//MEB-II LEDs
#define MEB2_LED1_MASK (1 << 0)
#define MEB2_LED2_MASK (1 << 2)
#define MEB2_LED3_MASK (1 << 1)
#define MEB2_LED4_MASK (1 << 6)
#define MEB2_LED5_MASK (1 << 11)

//MEB-II push button
#define MEB2_S1_MASK (1 << 0)

#endif
