/**
 * @file lpcxpresso_1769.h
 * @brief LPCXpresso1769 evaluation board
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _LPCXPRESSO_1769_H
#define _LPCXPRESSO_1769_H

//Dependencies
#include "lpc17xx.h"

//Red LED
#define LED_R_MASK      (1 << 22)
#define LED_R_FIODIR    LPC_GPIO0->FIODIR
#define LED_R_FIOSET    LPC_GPIO0->FIOSET
#define LED_R_FIOCLR    LPC_GPIO0->FIOCLR

//Green LED
#define LED_G_MASK      (1 << 25)
#define LED_G_FIODIR    LPC_GPIO3->FIODIR
#define LED_G_FIOSET    LPC_GPIO3->FIOSET
#define LED_G_FIOCLR    LPC_GPIO3->FIOCLR

//Blue LED
#define LED_B_MASK      (1 << 26)
#define LED_B_FIODIR    LPC_GPIO3->FIODIR
#define LED_B_FIOSET    LPC_GPIO3->FIOSET
#define LED_B_FIOCLR    LPC_GPIO3->FIOCLR

//SW2
#define SW2_MASK        (1 << 10)
#define SW2_FIODIR      LPC_GPIO2->FIODIR
#define SW2_FIOPIN      LPC_GPIO2->FIOPIN

#endif
