/**
 * @file lpcxpresso_54608.h
 * @brief LPCXpresso54608 evaluation board
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _LPCXPRESSO_54608_H
#define _LPCXPRESSO_54608_H

//Dependencies
#include "fsl_device_registers.h"

//LED1
#define LED1_PORT  3
#define LED1_PIN   14
#define LED1_MASK  (1 << LED1_PIN)

//LED2
#define LED2_PORT  3
#define LED2_PIN   3
#define LED2_MASK  (1 << LED2_PIN)

//LED3
#define LED3_PORT  2
#define LED3_PIN   2
#define LED3_MASK  (1 << LED3_PIN)

//SW2 button
#define SW2_PORT  0
#define SW2_PIN   6
#define SW2_MASK  (1 << SW2_PIN)

//SW3 button
#define SW3_PORT  0
#define SW3_PIN   5
#define SW3_MASK  (1 << SW3_PIN)

//SW4 button
#define SW4_PORT  0
#define SW4_PIN   4
#define SW4_MASK  (1 << SW4_PIN)

//SW5 button
#define SW5_PORT  1
#define SW5_PIN   1
#define SW5_MASK  (1 << SW5_PIN)

#endif
