/**
 * @file sam7_ex256.h
 * @brief SAM7-EX256 demonstration board
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _SAM7_EX256_H
#define _SAM7_EX256_H

//Dependencies
#include "at91sam7x256.h"

//Master clock
#define AT91B_MCK (18432000 * 73 / 14 / 2)

//Push buttons
#define SW1_MASK           AT91C_PIO_PB24
#define SW2_MASK           AT91C_PIO_PB25
#define SW_BASE_PIO        AT91C_BASE_PIOB
#define SW_ID_PIO          AT91C_ID_PIOB

//LCD backlight
#define LCD_BL_MASK        AT91C_PIO_PB20
#define LCD_BL_BASE_PIO    AT91C_BASE_PIOB
#define LCD_BL_ID_PIO      AT91C_ID_PIOB

//LCD reset
#define LCD_RST_MASK       AT91C_PIO_PA2
#define LCD_RST_BASE_PIO   AT91C_BASE_PIOA
#define LCD_RST_ID_PIO     AT91C_ID_PIOA

//LCD CS
#define LCD_CS_MASK        AT91C_PIO_PA12
#define LCD_CS_BASE_PIO    AT91C_BASE_PIOA
#define LCD_CS_ID_PIO      AT91C_ID_PIOA

#endif
