/**
 * @file stm32_p407.h
 * @brief STM32-P407 demonstration board
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _STM32_P407_H
#define _STM32_P407_H

//Dependencies
#include "stm32f4xx.h"

//LED1
#define LED1_PIN  GPIO_PIN_6
#define LED1_GPIO GPIOF

//LED2
#define LED2_PIN  GPIO_PIN_7
#define LED2_GPIO GPIOF

//LED3
#define LED3_PIN  GPIO_PIN_8
#define LED3_GPIO GPIOF

//LED4
#define LED4_PIN  GPIO_PIN_9
#define LED4_GPIO GPIOF

//WKUP button
#define WKUP_PIN  GPIO_PIN_0
#define WKUP_GPIO GPIOA

//TAMPER button
#define TAMPER_PIN  GPIO_PIN_13
#define TAMPER_GPIO GPIOC

//Joystick
#define JOYSTICK_LEFT_PIN  GPIO_PIN_11
#define JOYSTICK_RIGHT_PIN GPIO_PIN_6
#define JOYSTICK_UP_PIN    GPIO_PIN_7
#define JOYSTICK_DOWN_PIN  GPIO_PIN_8
#define JOYSTICK_CENT_PIN  GPIO_PIN_15
#define JOYSTICK_GPIO      GPIOG

//LCD backlight
#define LCD_BL_PIN  GPIO_PIN_0
#define LCD_BL_GPIO GPIOB

//LCD RST
#define LCD_RST_PIN  GPIO_PIN_3
#define LCD_RST_GPIO GPIOD

//LCD CS
#define LCD_CS_PIN  GPIO_PIN_6
#define LCD_CS_GPIO GPIOD

//LCD SCK
#define LCD_SCK_PIN  GPIO_PIN_5
#define LCD_SCK_GPIO GPIOA

//LCD MOSI
#define LCD_MOSI_PIN  GPIO_PIN_3
#define LCD_MOSI_GPIO GPIOC

//LCD MISO
#define LCD_MISO_PIN  GPIO_PIN_4
#define LCD_MISO_GPIO GPIOB

#endif
