/**
 * @file pk_s5d9.h
 * @brief PK-S5D9 Promotion Kit
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _PK_S5D9_H
#define _PK_S5D9_H

//Dependencies
#include "bsp_irq_cfg.h"
#include "s5d9.h"

//Green LED (LED1)
#define LED1_MASK (1 << 0)
#define LED1_IOPORT R_IOPORT6
#define LED1_PFS_b P600PFS_b

//Red LED (LED2)
#define LED2_MASK (1 << 1)
#define LED2_IOPORT R_IOPORT6
#define LED2_PFS_b P601PFS_b

//Yellow LED (LED3)
#define LED3_MASK (1 << 2)
#define LED3_IOPORT R_IOPORT6
#define LED3_PFS_b P602PFS_b

//Push button (S4)
#define S4_MASK (1 << 6)
#define S4_IOPORT R_IOPORT0
#define S4_PFS_b P006PFS_b

//Push button (S5)
#define S5_MASK (1 << 5)
#define S5_IOPORT R_IOPORT0
#define S5_PFS_b P005PFS_b

//PHY reset pin
#define PHY_RST_MASK (1 << 6)
#define PHY_RST_IOPORT R_IOPORT8
#define PHY_RST_PFS_b P806PFS_b

//PHY IRQ pin
#define PHY_IRQ_MASK (1 << 10)
#define PHY_IRQ_IOPORT R_IOPORT0
#define PHY_IRQ_PFS_b P010PFS_b

#endif
