
/****************************************************************************************************//**
 * @file     S7G2.h
 *
 * @brief    CMSIS Cortex-M4 Peripheral Access Layer Header File for
 *           S7G2 from Renesas.
 *
 * @version  V1.2
 * @date     18. November 2014
 *
 * @note     Generated with SVDConv V2.85b 
 *           from CMSIS SVD File 'S7G2.svd' Version 1.2,
 *******************************************************************************************************/



/** @addtogroup Renesas
  * @{
  */

/** @addtogroup S7G2
  * @{
  */

#ifndef R7FS7G2X_H
#define R7FS7G2X_H

#ifdef __cplusplus
extern "C" {
#endif

/* -------------------------  Interrupt Number Definition  ------------------------ */

typedef enum {
/* -------------------  Cortex-M4 Processor Exceptions Numbers  ------------------- */
  Reset_IRQn                    = -15,              /*!<   1  Reset Vector, invoked on Power up and warm reset                 */
  NonMaskableInt_IRQn           = -14,              /*!<   2  Non maskable Interrupt, cannot be stopped or preempted           */
  HardFault_IRQn                = -13,              /*!<   3  Hard Fault, all classes of Fault                                 */
  MemoryManagement_IRQn         = -12,              /*!<   4  Memory Management, MPU mismatch, including Access Violation
                                                         and No Match                                                          */
  BusFault_IRQn                 = -11,              /*!<   5  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                         related Fault                                                         */
  UsageFault_IRQn               = -10,              /*!<   6  Usage Fault, i.e. Undef Instruction, Illegal State Transition    */
  SVCall_IRQn                   =  -5,              /*!<  11  System Service Call via SVC instruction                          */
  DebugMonitor_IRQn             =  -4,              /*!<  12  Debug Monitor                                                    */
  PendSV_IRQn                   =  -2,              /*!<  14  Pendable request for system service                              */
  SysTick_IRQn                  =  -1,              /*!<  15  System Tick Timer                                                */
/* ---------------------  S7G2 Specific Interrupt Numbers  -------------------- */
#if (BSP_IRQ_CFG_PORT_IRQ0 != BSP_IRQ_DISABLED)
  PORT_IRQ0_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ1 != BSP_IRQ_DISABLED)
  PORT_IRQ1_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ2 != BSP_IRQ_DISABLED)
  PORT_IRQ2_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ3 != BSP_IRQ_DISABLED)
  PORT_IRQ3_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ4 != BSP_IRQ_DISABLED)
  PORT_IRQ4_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ5 != BSP_IRQ_DISABLED)
  PORT_IRQ5_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ6 != BSP_IRQ_DISABLED)
  PORT_IRQ6_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ7 != BSP_IRQ_DISABLED)
  PORT_IRQ7_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ8 != BSP_IRQ_DISABLED)
  PORT_IRQ8_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ9 != BSP_IRQ_DISABLED)
  PORT_IRQ9_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ10 != BSP_IRQ_DISABLED)
  PORT_IRQ10_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ11 != BSP_IRQ_DISABLED)
  PORT_IRQ11_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ12 != BSP_IRQ_DISABLED)
  PORT_IRQ12_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ13 != BSP_IRQ_DISABLED)
  PORT_IRQ13_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ14 != BSP_IRQ_DISABLED)
  PORT_IRQ14_IRQn,
#endif
#if (BSP_IRQ_CFG_PORT_IRQ15 != BSP_IRQ_DISABLED)
  PORT_IRQ15_IRQn,
#endif
#if (BSP_IRQ_CFG_DMAC0_INT != BSP_IRQ_DISABLED)
  DMAC0_INT_IRQn,
#endif
#if (BSP_IRQ_CFG_DMAC1_INT != BSP_IRQ_DISABLED)
  DMAC1_INT_IRQn,
#endif
#if (BSP_IRQ_CFG_DMAC2_INT != BSP_IRQ_DISABLED)
  DMAC2_INT_IRQn,
#endif
#if (BSP_IRQ_CFG_DMAC3_INT != BSP_IRQ_DISABLED)
  DMAC3_INT_IRQn,
#endif
#if (BSP_IRQ_CFG_DMAC4_INT != BSP_IRQ_DISABLED)
  DMAC4_INT_IRQn,
#endif
#if (BSP_IRQ_CFG_DMAC5_INT != BSP_IRQ_DISABLED)
  DMAC5_INT_IRQn,
#endif
#if (BSP_IRQ_CFG_DMAC6_INT != BSP_IRQ_DISABLED)
  DMAC6_INT_IRQn,
#endif
#if (BSP_IRQ_CFG_DMAC7_INT != BSP_IRQ_DISABLED)
  DMAC7_INT_IRQn,
#endif
#if (BSP_IRQ_CFG_DTC_COMPLETE != BSP_IRQ_DISABLED)
  DTC_COMPLETE_IRQn,
#endif
#if (BSP_IRQ_CFG_ICU_SNZCANCEL != BSP_IRQ_DISABLED)
  ICU_SNZCANCEL_IRQn,
#endif
#if (BSP_IRQ_CFG_FCU_FIFERR != BSP_IRQ_DISABLED)
  FCU_FIFERR_IRQn,
#endif
#if (BSP_IRQ_CFG_FCU_FRDYI != BSP_IRQ_DISABLED)
  FCU_FRDYI_IRQn,
#endif
#if (BSP_IRQ_CFG_LVD_LVD1 != BSP_IRQ_DISABLED)
  LVD_LVD1_IRQn,
#endif
#if (BSP_IRQ_CFG_LVD_LVD2 != BSP_IRQ_DISABLED)
  LVD_LVD2_IRQn,
#endif
#if (BSP_IRQ_CFG_MOSC_STOP != BSP_IRQ_DISABLED)
  MOSC_STOP_IRQn,
#endif
#if (BSP_IRQ_CFG_SYSTEM_SNZREQ != BSP_IRQ_DISABLED)
  SYSTEM_SNZREQ_IRQn,
#endif
#if (BSP_IRQ_CFG_AGT0_AGTI != BSP_IRQ_DISABLED)
  AGT0_AGTI_IRQn,
#endif
#if (BSP_IRQ_CFG_AGT0_AGTCMAI != BSP_IRQ_DISABLED)
  AGT0_AGTCMAI_IRQn,
#endif
#if (BSP_IRQ_CFG_AGT0_AGTCMBI != BSP_IRQ_DISABLED)
  AGT0_AGTCMBI_IRQn,
#endif
#if (BSP_IRQ_CFG_AGT1_AGTI != BSP_IRQ_DISABLED)
  AGT1_AGTI_IRQn,
#endif
#if (BSP_IRQ_CFG_AGT1_AGTCMAI != BSP_IRQ_DISABLED)
  AGT1_AGTCMAI_IRQn,
#endif
#if (BSP_IRQ_CFG_AGT1_AGTCMBI != BSP_IRQ_DISABLED)
  AGT1_AGTCMBI_IRQn,
#endif
#if (BSP_IRQ_CFG_IWDT_NMIUNDF != BSP_IRQ_DISABLED)
  IWDT_NMIUNDF_IRQn,
#endif
#if (BSP_IRQ_CFG_WDT_NMIUNDF != BSP_IRQ_DISABLED)
  WDT_NMIUNDF_IRQn,
#endif
#if (BSP_IRQ_CFG_RTC_ALM != BSP_IRQ_DISABLED)
  RTC_ALM_IRQn,
#endif
#if (BSP_IRQ_CFG_RTC_PRD != BSP_IRQ_DISABLED)
  RTC_PRD_IRQn,
#endif
#if (BSP_IRQ_CFG_RTC_CUP != BSP_IRQ_DISABLED)
  RTC_CUP_IRQn,
#endif
#if (BSP_IRQ_CFG_ADC120_ADI != BSP_IRQ_DISABLED)
  ADC120_ADI_IRQn,
#endif
#if (BSP_IRQ_CFG_ADC120_GBADI != BSP_IRQ_DISABLED)
  ADC120_GBADI_IRQn,
#endif
#if (BSP_IRQ_CFG_ADC120_CMPAI != BSP_IRQ_DISABLED)
  ADC120_CMPAI_IRQn,
#endif
#if (BSP_IRQ_CFG_ADC120_CMPBI != BSP_IRQ_DISABLED)
  ADC120_CMPBI_IRQn,
#endif
#if (BSP_IRQ_CFG_ADC120_WCMPM != BSP_IRQ_DISABLED)
  ADC120_WCMPM_IRQn,
#endif
#if (BSP_IRQ_CFG_ADC120_WCMPUM != BSP_IRQ_DISABLED)
  ADC120_WCMPUM_IRQn,
#endif
#if (BSP_IRQ_CFG_ADC121_ADI != BSP_IRQ_DISABLED)
  ADC121_ADI_IRQn,
#endif
#if (BSP_IRQ_CFG_ADC121_GBADI != BSP_IRQ_DISABLED)
  ADC121_GBADI_IRQn,
#endif
#if (BSP_IRQ_CFG_ADC121_CMPAI != BSP_IRQ_DISABLED)
  ADC121_CMPAI_IRQn,
#endif
#if (BSP_IRQ_CFG_ADC121_CMPBI != BSP_IRQ_DISABLED)
  ADC121_CMPBI_IRQn,
#endif
#if (BSP_IRQ_CFG_ADC121_WCMPM != BSP_IRQ_DISABLED)
  ADC121_WCMPM_IRQn,
#endif
#if (BSP_IRQ_CFG_ADC121_WCMPUM != BSP_IRQ_DISABLED)
  ADC121_WCMPUM_IRQn,
#endif
#if (BSP_IRQ_CFG_ACMP_HS0 != BSP_IRQ_DISABLED)
  ACMP_HS0_IRQn,
#endif
#if (BSP_IRQ_CFG_ACMP_HS1 != BSP_IRQ_DISABLED)
  ACMP_HS1_IRQn,
#endif
#if (BSP_IRQ_CFG_ACMP_HS2 != BSP_IRQ_DISABLED)
  ACMP_HS2_IRQn,
#endif
#if (BSP_IRQ_CFG_ACMP_HS3 != BSP_IRQ_DISABLED)
  ACMP_HS3_IRQn,
#endif
#if (BSP_IRQ_CFG_ACMP_HS4 != BSP_IRQ_DISABLED)
  ACMP_HS4_IRQn,
#endif
#if (BSP_IRQ_CFG_ACMP_HS5 != BSP_IRQ_DISABLED)
  ACMP_HS5_IRQn,
#endif
#if (BSP_IRQ_CFG_USBFS_D0FIFO != BSP_IRQ_DISABLED)
  USBFS_D0FIFO_IRQn,
#endif
#if (BSP_IRQ_CFG_USBFS_D1FIFO != BSP_IRQ_DISABLED)
  USBFS_D1FIFO_IRQn,
#endif
#if (BSP_IRQ_CFG_USBFS_USBI != BSP_IRQ_DISABLED)
  USBFS_USBI_IRQn,
#endif
#if (BSP_IRQ_CFG_USBFS_USBR != BSP_IRQ_DISABLED)
  USBFS_USBR_IRQn,
#endif
#if (BSP_IRQ_CFG_IIC0_RXI != BSP_IRQ_DISABLED)
  IIC0_RXI_IRQn,
#endif
#if (BSP_IRQ_CFG_IIC0_TXI != BSP_IRQ_DISABLED)
  IIC0_TXI_IRQn,
#endif
#if (BSP_IRQ_CFG_IIC0_TEI != BSP_IRQ_DISABLED)
  IIC0_TEI_IRQn,
#endif
#if (BSP_IRQ_CFG_IIC0_EEI != BSP_IRQ_DISABLED)
  IIC0_EEI_IRQn,
#endif
#if (BSP_IRQ_CFG_IIC0_WUI != BSP_IRQ_DISABLED)
  IIC0_WUI_IRQn,
#endif
#if (BSP_IRQ_CFG_IIC1_RXI != BSP_IRQ_DISABLED)
  IIC1_RXI_IRQn,
#endif
#if (BSP_IRQ_CFG_IIC1_TXI != BSP_IRQ_DISABLED)
  IIC1_TXI_IRQn,
#endif
#if (BSP_IRQ_CFG_IIC1_TEI != BSP_IRQ_DISABLED)
  IIC1_TEI_IRQn,
#endif
#if (BSP_IRQ_CFG_IIC1_EEI != BSP_IRQ_DISABLED)
  IIC1_EEI_IRQn,
#endif
#if (BSP_IRQ_CFG_IIC2_RXI != BSP_IRQ_DISABLED)
  IIC2_RXI_IRQn,
#endif
#if (BSP_IRQ_CFG_IIC2_TXI != BSP_IRQ_DISABLED)
  IIC2_TXI_IRQn,
#endif
#if (BSP_IRQ_CFG_IIC2_TEI != BSP_IRQ_DISABLED)
  IIC2_TEI_IRQn,
#endif
#if (BSP_IRQ_CFG_IIC2_EEI != BSP_IRQ_DISABLED)
  IIC2_EEI_IRQn,
#endif
#if (BSP_IRQ_CFG_SSI0_SSITXI != BSP_IRQ_DISABLED)
  SSI0_SSITXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SSI0_SSIRXI != BSP_IRQ_DISABLED)
  SSI0_SSIRXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SSI0_SSIF != BSP_IRQ_DISABLED)
  SSI0_SSIF_IRQn,
#endif
#if (BSP_IRQ_CFG_SSI1_SSIRT != BSP_IRQ_DISABLED)
  SSI1_SSIRT_IRQn,
#endif
#if (BSP_IRQ_CFG_SSI1_SSIF != BSP_IRQ_DISABLED)
  SSI1_SSIF_IRQn,
#endif
#if (BSP_IRQ_CFG_SRC_IDEI != BSP_IRQ_DISABLED)
  SRC_IDEI_IRQn,
#endif
#if (BSP_IRQ_CFG_SRC_ODFI != BSP_IRQ_DISABLED)
  SRC_ODFI_IRQn,
#endif
#if (BSP_IRQ_CFG_SRC_OVFI != BSP_IRQ_DISABLED)
  SRC_OVFI_IRQn,
#endif
#if (BSP_IRQ_CFG_SRC_UDFI != BSP_IRQ_DISABLED)
  SRC_UDFI_IRQn,
#endif
#if (BSP_IRQ_CFG_SRC_CEFI != BSP_IRQ_DISABLED)
  SRC_CEFI_IRQn,
#endif
#if (BSP_IRQ_CFG_PDC_PCDFI != BSP_IRQ_DISABLED)
  PDC_PCDFI_IRQn,
#endif
#if (BSP_IRQ_CFG_PDC_PCFEI != BSP_IRQ_DISABLED)
  PDC_PCFEI_IRQn,
#endif
#if (BSP_IRQ_CFG_PDC_PCERI != BSP_IRQ_DISABLED)
  PDC_PCERI_IRQn,
#endif
#if (BSP_IRQ_CFG_CTSU_CTSUWR != BSP_IRQ_DISABLED)
  CTSU_CTSUWR_IRQn,
#endif
#if (BSP_IRQ_CFG_CTSU_CTSURD != BSP_IRQ_DISABLED)
  CTSU_CTSURD_IRQn,
#endif
#if (BSP_IRQ_CFG_CTSU_CTSUFN != BSP_IRQ_DISABLED)
  CTSU_CTSUFN_IRQn,
#endif
#if (BSP_IRQ_CFG_KEY_INTKR != BSP_IRQ_DISABLED)
  KEY_INTKR_IRQn,
#endif
#if (BSP_IRQ_CFG_DOC_DOPCI != BSP_IRQ_DISABLED)
  DOC_DOPCI_IRQn,
#endif
#if (BSP_IRQ_CFG_CAC_FERRI != BSP_IRQ_DISABLED)
  CAC_FERRI_IRQn,
#endif
#if (BSP_IRQ_CFG_CAC_MENDI != BSP_IRQ_DISABLED)
  CAC_MENDI_IRQn,
#endif
#if (BSP_IRQ_CFG_CAC_OVFI != BSP_IRQ_DISABLED)
  CAC_OVFI_IRQn,
#endif
#if (BSP_IRQ_CFG_CAN0_ERS != BSP_IRQ_DISABLED)
  CAN0_ERS_IRQn,
#endif
#if (BSP_IRQ_CFG_CAN0_RXF != BSP_IRQ_DISABLED)
  CAN0_RXF_IRQn,
#endif
#if (BSP_IRQ_CFG_CAN0_TXF != BSP_IRQ_DISABLED)
  CAN0_TXF_IRQn,
#endif
#if (BSP_IRQ_CFG_CAN0_RXM != BSP_IRQ_DISABLED)
  CAN0_RXM_IRQn,
#endif
#if (BSP_IRQ_CFG_CAN0_TXM != BSP_IRQ_DISABLED)
  CAN0_TXM_IRQn,
#endif
#if (BSP_IRQ_CFG_CAN1_ERS != BSP_IRQ_DISABLED)
  CAN1_ERS_IRQn,
#endif
#if (BSP_IRQ_CFG_CAN1_RXF != BSP_IRQ_DISABLED)
  CAN1_RXF_IRQn,
#endif
#if (BSP_IRQ_CFG_CAN1_TXF != BSP_IRQ_DISABLED)
  CAN1_TXF_IRQn,
#endif
#if (BSP_IRQ_CFG_CAN1_RXM != BSP_IRQ_DISABLED)
  CAN1_RXM_IRQn,
#endif
#if (BSP_IRQ_CFG_CAN1_TXM != BSP_IRQ_DISABLED)
  CAN1_TXM_IRQn,
#endif
#if (BSP_IRQ_CFG_IOPORT_GROUP1 != BSP_IRQ_DISABLED)
  IOPORT_GROUP1_IRQn,
#endif
#if (BSP_IRQ_CFG_IOPORT_GROUP2 != BSP_IRQ_DISABLED)
  IOPORT_GROUP2_IRQn,
#endif
#if (BSP_IRQ_CFG_IOPORT_GROUP3 != BSP_IRQ_DISABLED)
  IOPORT_GROUP3_IRQn,
#endif
#if (BSP_IRQ_CFG_IOPORT_GROUP4 != BSP_IRQ_DISABLED)
  IOPORT_GROUP4_IRQn,
#endif
#if (BSP_IRQ_CFG_ELC_SWEVT0 != BSP_IRQ_DISABLED)
  ELC_SWEVT0_IRQn,
#endif
#if (BSP_IRQ_CFG_ELC_SWEVT1 != BSP_IRQ_DISABLED)
  ELC_SWEVT1_IRQn,
#endif
#if (BSP_IRQ_CFG_POEG_GROUP0 != BSP_IRQ_DISABLED)
  POEG_GROUP0_IRQn,
#endif
#if (BSP_IRQ_CFG_POEG_GROUP1 != BSP_IRQ_DISABLED)
  POEG_GROUP1_IRQn,
#endif
#if (BSP_IRQ_CFG_POEG_GROUP2 != BSP_IRQ_DISABLED)
  POEG_GROUP2_IRQn,
#endif
#if (BSP_IRQ_CFG_POEG_GROUP3 != BSP_IRQ_DISABLED)
  POEG_GROUP3_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT0_CCMPA != BSP_IRQ_DISABLED)
  GPT0_CCMPA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT0_CCMPB != BSP_IRQ_DISABLED)
  GPT0_CCMPB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT0_CMPC != BSP_IRQ_DISABLED)
  GPT0_CMPC_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT0_CMPD != BSP_IRQ_DISABLED)
  GPT0_CMPD_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT0_CMPE != BSP_IRQ_DISABLED)
  GPT0_CMPE_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT0_CMPF != BSP_IRQ_DISABLED)
  GPT0_CMPF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT0_OVF != BSP_IRQ_DISABLED)
  GPT0_OVF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT0_UDF != BSP_IRQ_DISABLED)
  GPT0_UDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT0_ADTRGA != BSP_IRQ_DISABLED)
  GPT0_ADTRGA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT0_ADTRGB != BSP_IRQ_DISABLED)
  GPT0_ADTRGB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT1_CCMPA != BSP_IRQ_DISABLED)
  GPT1_CCMPA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT1_CCMPB != BSP_IRQ_DISABLED)
  GPT1_CCMPB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT1_CMPC != BSP_IRQ_DISABLED)
  GPT1_CMPC_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT1_CMPD != BSP_IRQ_DISABLED)
  GPT1_CMPD_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT1_CMPE != BSP_IRQ_DISABLED)
  GPT1_CMPE_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT1_CMPF != BSP_IRQ_DISABLED)
  GPT1_CMPF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT1_OVF != BSP_IRQ_DISABLED)
  GPT1_OVF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT1_UDF != BSP_IRQ_DISABLED)
  GPT1_UDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT1_ADTRGA != BSP_IRQ_DISABLED)
  GPT1_ADTRGA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT1_ADTRGB != BSP_IRQ_DISABLED)
  GPT1_ADTRGB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT2_CCMPA != BSP_IRQ_DISABLED)
  GPT2_CCMPA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT2_CCMPB != BSP_IRQ_DISABLED)
  GPT2_CCMPB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT2_CMPC != BSP_IRQ_DISABLED)
  GPT2_CMPC_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT2_CMPD != BSP_IRQ_DISABLED)
  GPT2_CMPD_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT2_CMPE != BSP_IRQ_DISABLED)
  GPT2_CMPE_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT2_CMPF != BSP_IRQ_DISABLED)
  GPT2_CMPF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT2_OVF != BSP_IRQ_DISABLED)
  GPT2_OVF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT2_UDF != BSP_IRQ_DISABLED)
  GPT2_UDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT2_ADTRGA != BSP_IRQ_DISABLED)
  GPT2_ADTRGA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT2_ADTRGB != BSP_IRQ_DISABLED)
  GPT2_ADTRGB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT3_CCMPA != BSP_IRQ_DISABLED)
  GPT3_CCMPA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT3_CCMPB != BSP_IRQ_DISABLED)
  GPT3_CCMPB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT3_CMPC != BSP_IRQ_DISABLED)
  GPT3_CMPC_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT3_CMPD != BSP_IRQ_DISABLED)
  GPT3_CMPD_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT3_CMPE != BSP_IRQ_DISABLED)
  GPT3_CMPE_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT3_CMPF != BSP_IRQ_DISABLED)
  GPT3_CMPF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT3_OVF != BSP_IRQ_DISABLED)
  GPT3_OVF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT3_UDF != BSP_IRQ_DISABLED)
  GPT3_UDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT3_ADTRGA != BSP_IRQ_DISABLED)
  GPT3_ADTRGA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT3_ADTRGB != BSP_IRQ_DISABLED)
  GPT3_ADTRGB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT4_CCMPA != BSP_IRQ_DISABLED)
  GPT4_CCMPA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT4_CCMPB != BSP_IRQ_DISABLED)
  GPT4_CCMPB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT4_CMPC != BSP_IRQ_DISABLED)
  GPT4_CMPC_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT4_CMPD != BSP_IRQ_DISABLED)
  GPT4_CMPD_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT4_CMPE != BSP_IRQ_DISABLED)
  GPT4_CMPE_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT4_CMPF != BSP_IRQ_DISABLED)
  GPT4_CMPF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT4_OVF != BSP_IRQ_DISABLED)
  GPT4_OVF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT4_UDF != BSP_IRQ_DISABLED)
  GPT4_UDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT4_ADTRGA != BSP_IRQ_DISABLED)
  GPT4_ADTRGA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT4_ADTRGB != BSP_IRQ_DISABLED)
  GPT4_ADTRGB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT5_CCMPA != BSP_IRQ_DISABLED)
  GPT5_CCMPA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT5_CCMPB != BSP_IRQ_DISABLED)
  GPT5_CCMPB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT5_CMPC != BSP_IRQ_DISABLED)
  GPT5_CMPC_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT5_CMPD != BSP_IRQ_DISABLED)
  GPT5_CMPD_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT5_CMPE != BSP_IRQ_DISABLED)
  GPT5_CMPE_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT5_CMPF != BSP_IRQ_DISABLED)
  GPT5_CMPF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT5_OVF != BSP_IRQ_DISABLED)
  GPT5_OVF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT5_UDF != BSP_IRQ_DISABLED)
  GPT5_UDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT5_ADTRGA != BSP_IRQ_DISABLED)
  GPT5_ADTRGA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT5_ADTRGB != BSP_IRQ_DISABLED)
  GPT5_ADTRGB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT6_CCMPA != BSP_IRQ_DISABLED)
  GPT6_CCMPA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT6_CCMPB != BSP_IRQ_DISABLED)
  GPT6_CCMPB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT6_CMPC != BSP_IRQ_DISABLED)
  GPT6_CMPC_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT6_CMPD != BSP_IRQ_DISABLED)
  GPT6_CMPD_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT6_CMPE != BSP_IRQ_DISABLED)
  GPT6_CMPE_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT6_CMPF != BSP_IRQ_DISABLED)
  GPT6_CMPF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT6_OVF != BSP_IRQ_DISABLED)
  GPT6_OVF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT6_UDF != BSP_IRQ_DISABLED)
  GPT6_UDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT6_ADTRGA != BSP_IRQ_DISABLED)
  GPT6_ADTRGA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT6_ADTRGB != BSP_IRQ_DISABLED)
  GPT6_ADTRGB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT7_CCMPA != BSP_IRQ_DISABLED)
  GPT7_CCMPA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT7_CCMPB != BSP_IRQ_DISABLED)
  GPT7_CCMPB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT7_CMPC != BSP_IRQ_DISABLED)
  GPT7_CMPC_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT7_CMPD != BSP_IRQ_DISABLED)
  GPT7_CMPD_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT7_CMPE != BSP_IRQ_DISABLED)
  GPT7_CMPE_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT7_CMPF != BSP_IRQ_DISABLED)
  GPT7_CMPF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT7_OVF != BSP_IRQ_DISABLED)
  GPT7_OVF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT7_UDF != BSP_IRQ_DISABLED)
  GPT7_UDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT7_ADTRGA != BSP_IRQ_DISABLED)
  GPT7_ADTRGA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT7_ADTRGB != BSP_IRQ_DISABLED)
  GPT7_ADTRGB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT8_CCMPA != BSP_IRQ_DISABLED)
  GPT8_CCMPA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT8_CCMPB != BSP_IRQ_DISABLED)
  GPT8_CCMPB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT8_CMPC != BSP_IRQ_DISABLED)
  GPT8_CMPC_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT8_CMPD != BSP_IRQ_DISABLED)
  GPT8_CMPD_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT8_CMPE != BSP_IRQ_DISABLED)
  GPT8_CMPE_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT8_CMPF != BSP_IRQ_DISABLED)
  GPT8_CMPF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT8_OVF != BSP_IRQ_DISABLED)
  GPT8_OVF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT8_UDF != BSP_IRQ_DISABLED)
  GPT8_UDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT9_CCMPA != BSP_IRQ_DISABLED)
  GPT9_CCMPA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT9_CCMPB != BSP_IRQ_DISABLED)
  GPT9_CCMPB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT9_CMPC != BSP_IRQ_DISABLED)
  GPT9_CMPC_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT9_CMPD != BSP_IRQ_DISABLED)
  GPT9_CMPD_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT9_CMPE != BSP_IRQ_DISABLED)
  GPT9_CMPE_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT9_CMPF != BSP_IRQ_DISABLED)
  GPT9_CMPF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT9_OVF != BSP_IRQ_DISABLED)
  GPT9_OVF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT9_UDF != BSP_IRQ_DISABLED)
  GPT9_UDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT10_CCMPA != BSP_IRQ_DISABLED)
  GPT10_CCMPA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT10_CCMPB != BSP_IRQ_DISABLED)
  GPT10_CCMPB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT10_CMPC != BSP_IRQ_DISABLED)
  GPT10_CMPC_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT10_CMPD != BSP_IRQ_DISABLED)
  GPT10_CMPD_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT10_CMPE != BSP_IRQ_DISABLED)
  GPT10_CMPE_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT10_CMPF != BSP_IRQ_DISABLED)
  GPT10_CMPF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT10_OVF != BSP_IRQ_DISABLED)
  GPT10_OVF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT10_UDF != BSP_IRQ_DISABLED)
  GPT10_UDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT11_CCMPA != BSP_IRQ_DISABLED)
  GPT11_CCMPA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT11_CCMPB != BSP_IRQ_DISABLED)
  GPT11_CCMPB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT11_CMPC != BSP_IRQ_DISABLED)
  GPT11_CMPC_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT11_CMPD != BSP_IRQ_DISABLED)
  GPT11_CMPD_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT11_CMPE != BSP_IRQ_DISABLED)
  GPT11_CMPE_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT11_CMPF != BSP_IRQ_DISABLED)
  GPT11_CMPF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT11_OVF != BSP_IRQ_DISABLED)
  GPT11_OVF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT11_UDF != BSP_IRQ_DISABLED)
  GPT11_UDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT12_CCMPA != BSP_IRQ_DISABLED)
  GPT12_CCMPA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT12_CCMPB != BSP_IRQ_DISABLED)
  GPT12_CCMPB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT12_CMPC != BSP_IRQ_DISABLED)
  GPT12_CMPC_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT12_CMPD != BSP_IRQ_DISABLED)
  GPT12_CMPD_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT12_CMPE != BSP_IRQ_DISABLED)
  GPT12_CMPE_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT12_CMPF != BSP_IRQ_DISABLED)
  GPT12_CMPF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT12_OVF != BSP_IRQ_DISABLED)
  GPT12_OVF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT12_UDF != BSP_IRQ_DISABLED)
  GPT12_UDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT13_CCMPA != BSP_IRQ_DISABLED)
  GPT13_CCMPA_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT13_CCMPB != BSP_IRQ_DISABLED)
  GPT13_CCMPB_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT13_CMPC != BSP_IRQ_DISABLED)
  GPT13_CMPC_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT13_CMPD != BSP_IRQ_DISABLED)
  GPT13_CMPD_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT13_CMPE != BSP_IRQ_DISABLED)
  GPT13_CMPE_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT13_CMPF != BSP_IRQ_DISABLED)
  GPT13_CMPF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT13_OVF != BSP_IRQ_DISABLED)
  GPT13_OVF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT13_UDF != BSP_IRQ_DISABLED)
  GPT13_UDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GPT_UVWEDGE != BSP_IRQ_DISABLED)
  GPT_UVWEDGE_IRQn,
#endif
#if (BSP_IRQ_CFG_ETHER_IPLS != BSP_IRQ_DISABLED)
  ETHER_IPLS_IRQn,
#endif
#if (BSP_IRQ_CFG_ETHER_MINT != BSP_IRQ_DISABLED)
  ETHER_MINT_IRQn,
#endif
#if (BSP_IRQ_CFG_ETHER_PINT != BSP_IRQ_DISABLED)
  ETHER_PINT_IRQn,
#endif
#if (BSP_IRQ_CFG_ETHER_EINT0 != BSP_IRQ_DISABLED)
  ETHER_EINT0_IRQn,
#endif
#if (BSP_IRQ_CFG_ETHER_EINT1 != BSP_IRQ_DISABLED)
  ETHER_EINT1_IRQn,
#endif
#if (BSP_IRQ_CFG_USBHS_D0FIFO != BSP_IRQ_DISABLED)
  USBHS_D0FIFO_IRQn,
#endif
#if (BSP_IRQ_CFG_USBHS_D1FIFO != BSP_IRQ_DISABLED)
  USBHS_D1FIFO_IRQn,
#endif
#if (BSP_IRQ_CFG_USBHS_USBIR != BSP_IRQ_DISABLED)
  USBHS_USBIR_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI0_RXI != BSP_IRQ_DISABLED)
  SCI0_RXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI0_TXI != BSP_IRQ_DISABLED)
  SCI0_TXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI0_TEI != BSP_IRQ_DISABLED)
  SCI0_TEI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI0_ERI != BSP_IRQ_DISABLED)
  SCI0_ERI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI0_AM != BSP_IRQ_DISABLED)
  SCI0_AM_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI0_RXI_OR_ERI != BSP_IRQ_DISABLED)
  SCI0_RXI_OR_ERI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI1_RXI != BSP_IRQ_DISABLED)
  SCI1_RXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI1_TXI != BSP_IRQ_DISABLED)
  SCI1_TXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI1_TEI != BSP_IRQ_DISABLED)
  SCI1_TEI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI1_ERI != BSP_IRQ_DISABLED)
  SCI1_ERI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI1_AM != BSP_IRQ_DISABLED)
  SCI1_AM_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI2_RXI != BSP_IRQ_DISABLED)
  SCI2_RXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI2_TXI != BSP_IRQ_DISABLED)
  SCI2_TXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI2_TEI != BSP_IRQ_DISABLED)
  SCI2_TEI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI2_ERI != BSP_IRQ_DISABLED)
  SCI2_ERI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI2_AM != BSP_IRQ_DISABLED)
  SCI2_AM_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI3_RXI != BSP_IRQ_DISABLED)
  SCI3_RXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI3_TXI != BSP_IRQ_DISABLED)
  SCI3_TXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI3_TEI != BSP_IRQ_DISABLED)
  SCI3_TEI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI3_ERI != BSP_IRQ_DISABLED)
  SCI3_ERI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI3_AM != BSP_IRQ_DISABLED)
  SCI3_AM_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI4_RXI != BSP_IRQ_DISABLED)
  SCI4_RXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI4_TXI != BSP_IRQ_DISABLED)
  SCI4_TXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI4_TEI != BSP_IRQ_DISABLED)
  SCI4_TEI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI4_ERI != BSP_IRQ_DISABLED)
  SCI4_ERI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI4_AM != BSP_IRQ_DISABLED)
  SCI4_AM_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI5_RXI != BSP_IRQ_DISABLED)
  SCI5_RXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI5_TXI != BSP_IRQ_DISABLED)
  SCI5_TXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI5_TEI != BSP_IRQ_DISABLED)
  SCI5_TEI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI5_ERI != BSP_IRQ_DISABLED)
  SCI5_ERI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI5_AM != BSP_IRQ_DISABLED)
  SCI5_AM_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI6_RXI != BSP_IRQ_DISABLED)
  SCI6_RXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI6_TXI != BSP_IRQ_DISABLED)
  SCI6_TXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI6_TEI != BSP_IRQ_DISABLED)
  SCI6_TEI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI6_ERI != BSP_IRQ_DISABLED)
  SCI6_ERI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI6_AM != BSP_IRQ_DISABLED)
  SCI6_AM_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI7_RXI != BSP_IRQ_DISABLED)
  SCI7_RXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI7_TXI != BSP_IRQ_DISABLED)
  SCI7_TXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI7_TEI != BSP_IRQ_DISABLED)
  SCI7_TEI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI7_ERI != BSP_IRQ_DISABLED)
  SCI7_ERI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI7_AM != BSP_IRQ_DISABLED)
  SCI7_AM_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI8_RXI != BSP_IRQ_DISABLED)
  SCI8_RXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI8_TXI != BSP_IRQ_DISABLED)
  SCI8_TXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI8_TEI != BSP_IRQ_DISABLED)
  SCI8_TEI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI8_ERI != BSP_IRQ_DISABLED)
  SCI8_ERI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI8_AM != BSP_IRQ_DISABLED)
  SCI8_AM_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI9_RXI != BSP_IRQ_DISABLED)
  SCI9_RXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI9_TXI != BSP_IRQ_DISABLED)
  SCI9_TXI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI9_TEI != BSP_IRQ_DISABLED)
  SCI9_TEI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI9_ERI != BSP_IRQ_DISABLED)
  SCI9_ERI_IRQn,
#endif
#if (BSP_IRQ_CFG_SCI9_AM != BSP_IRQ_DISABLED)
  SCI9_AM_IRQn,
#endif
#if (BSP_IRQ_CFG_SPI0_SPRI != BSP_IRQ_DISABLED)
  SPI0_SPRI_IRQn,
#endif
#if (BSP_IRQ_CFG_SPI0_SPTI != BSP_IRQ_DISABLED)
  SPI0_SPTI_IRQn,
#endif
#if (BSP_IRQ_CFG_SPI0_SPII != BSP_IRQ_DISABLED)
  SPI0_SPII_IRQn,
#endif
#if (BSP_IRQ_CFG_SPI0_SPEI != BSP_IRQ_DISABLED)
  SPI0_SPEI_IRQn,
#endif
#if (BSP_IRQ_CFG_SPI0_SPTEND != BSP_IRQ_DISABLED)
  SPI0_SPTEND_IRQn,
#endif
#if (BSP_IRQ_CFG_SPI1_SPRI != BSP_IRQ_DISABLED)
  SPI1_SPRI_IRQn,
#endif
#if (BSP_IRQ_CFG_SPI1_SPTI != BSP_IRQ_DISABLED)
  SPI1_SPTI_IRQn,
#endif
#if (BSP_IRQ_CFG_SPI1_SPII != BSP_IRQ_DISABLED)
  SPI1_SPII_IRQn,
#endif
#if (BSP_IRQ_CFG_SPI1_SPEI != BSP_IRQ_DISABLED)
  SPI1_SPEI_IRQn,
#endif
#if (BSP_IRQ_CFG_SPI1_SPTEND != BSP_IRQ_DISABLED)
  SPI1_SPTEND_IRQn,
#endif
#if (BSP_IRQ_CFG_QSPI_INTR != BSP_IRQ_DISABLED)
  QSPI_INTR_IRQn,
#endif
#if (BSP_IRQ_CFG_SDHI_MMC0_ACCS != BSP_IRQ_DISABLED)
  SDHI_MMC0_ACCS_IRQn,
#endif
#if (BSP_IRQ_CFG_SDHI_MMC0_SDIO != BSP_IRQ_DISABLED)
  SDHI_MMC0_SDIO_IRQn,
#endif
#if (BSP_IRQ_CFG_SDHI_MMC0_CARD != BSP_IRQ_DISABLED)
  SDHI_MMC0_CARD_IRQn,
#endif
#if (BSP_IRQ_CFG_SDHI_MMC0_ODMSDBREQ != BSP_IRQ_DISABLED)
  SDHI_MMC0_ODMSDBREQ_IRQn,
#endif
#if (BSP_IRQ_CFG_SDHI_MMC1_ACCS != BSP_IRQ_DISABLED)
  SDHI_MMC1_ACCS_IRQn,
#endif
#if (BSP_IRQ_CFG_SDHI_MMC1_SDIO != BSP_IRQ_DISABLED)
  SDHI_MMC1_SDIO_IRQn,
#endif
#if (BSP_IRQ_CFG_SDHI_MMC1_CARD != BSP_IRQ_DISABLED)
  SDHI_MMC1_CARD_IRQn,
#endif
#if (BSP_IRQ_CFG_SDHI_MMC1_ODMSDBREQ != BSP_IRQ_DISABLED)
  SDHI_MMC1_ODMSDBREQ_IRQn,
#endif
#if (BSP_IRQ_CFG_GLCDC_VPOS != BSP_IRQ_DISABLED)
  GLCDC_VPOS_IRQn,
#endif
#if (BSP_IRQ_CFG_GLCDC_L1UNDF != BSP_IRQ_DISABLED)
  GLCDC_L1UNDF_IRQn,
#endif
#if (BSP_IRQ_CFG_GLCDC_L2UNDF != BSP_IRQ_DISABLED)
  GLCDC_L2UNDF_IRQn,
#endif
#if (BSP_IRQ_CFG_DRW_IRQ != BSP_IRQ_DISABLED)
  DRW_IRQ_IRQn,
#endif
#if (BSP_IRQ_CFG_JPEG_JEDI != BSP_IRQ_DISABLED)
  JPEG_JEDI_IRQn,
#endif
#if (BSP_IRQ_CFG_JPEG_JDTI != BSP_IRQ_DISABLED)
  JPEG_JDTI_IRQn,
#endif
  BSP_MAX_NUM_IRQn    /* Used for getting number of active interrupts, do not use. */
} IRQn_Type;

/** @addtogroup Configuration_of_CMSIS
  * @{
  */


/* ================================================================================ */
/* ================      Processor and Core Peripheral Section     ================ */
/* ================================================================================ */

/* ----------------Configuration of the Cortex-M4 Processor and Core Peripherals---------------- */
#define __CM4_REV                 0x0001            /*!< Cortex-M4 Core Revision                                               */
#define __MPU_PRESENT                  1            /*!< MPU present or not                                                    */
#define __NVIC_PRIO_BITS               4            /*!< Number of Bits used for Priority Levels                               */
#define __Vendor_SysTickConfig         0            /*!< Set to 1 if different SysTick Config is used                          */
#define __FPU_PRESENT                  1            /*!< FPU present or not                                                    */
/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm4.h"                               /*!< Cortex-M4 processor and core peripherals                              */
#include "system_S7G2.h"                            /*!< R7FS7G2x System                                                       */


/* ================================================================================ */
/* ================       Device Specific Peripheral Section       ================ */
/* ================================================================================ */


/** @addtogroup Device_Peripheral_Registers
  * @{
  */


/* -------  Start of section using anonymous unions and disabling warnings  ------- */
#if   defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


typedef struct {
  union {
    __IO uint32_t  MMPUACAn;                        /*!< Group A Region %s Access Control Register                             */
    
    struct {
      __IO uint32_t  ENABLE     :  1;               /*!< Region enable                                                         */
      __IO uint32_t  RP         :  1;               /*!< Read protection                                                       */
      __IO uint32_t  WP         :  1;               /*!< Write protection                                                      */
    } MMPUACAn_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  MMPUSAn;                         /*!< Group A Region %s Start Address Register                              */
    
    struct {
      __IO uint32_t  MMPUSA     : 32;               /*!< Address where the region starts, for use in region determination.
                                                         NOTE: The low-order 2 bits are fixed to 0.                            */
    } MMPUSAn_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  MMPUEAn;                         /*!< Group A Region %s End Address Register                                */
    
    struct {
      __IO uint32_t  MMPUEA     : 32;               /*!< Region end address register Address where the region end, for
                                                         use in region determination. NOTE: The low-order 2 bits are
                                                          fixed to 1.                                                          */
    } MMPUEAn_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED[4];   // Padding changed from uint32_t
} R_MMPU_MMPUACAnRC0_Type;

typedef struct {
  union {
    __IO uint32_t  MMPUACBn;                        /*!< Group B Region %s Access Control Register                             */
    
    struct {
      __IO uint32_t  ENABLE     :  1;               /*!< Region enable                                                         */
      __IO uint32_t  RP         :  1;               /*!< Read protection                                                       */
      __IO uint32_t  WP         :  1;               /*!< Write protection                                                      */
    } MMPUACBn_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  MMPUSBn;                         /*!< Group B Region %s Start Address Register                              */
    
    struct {
      __IO uint32_t  MMPUSB     : 32;               /*!< Address where the region starts, for use in region determination.
                                                         NOTE: The low-order 2 bits are fixed to 0.                            */
    } MMPUSBn_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  MMPUEBn;                         /*!< Group B Region %s End Address Register                                */
    
    struct {
      __IO uint32_t  MMPUEB     : 32;               /*!< Region end address register Address where the region end, for
                                                         use in region determination. NOTE: The low-order 2 bits are
                                                          fixed to 1.                                                          */
    } MMPUEBn_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED1[4];   // Padding changed from uint32_t
} R_MMPU_MMPUACBnRC0_Type;

typedef struct {
  union {
    __IO uint32_t  MMPUACCn;                        /*!< Group C Region %s Access Control Register                             */
    
    struct {
      __IO uint32_t  ENABLE     :  1;               /*!< Region enable                                                         */
      __IO uint32_t  RP         :  1;               /*!< Read protection                                                       */
      __IO uint32_t  WP         :  1;               /*!< Write protection                                                      */
    } MMPUACCn_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  MMPUSCn;                         /*!< Group C Region %s Start Address Register                              */
    
    struct {
      __IO uint32_t  MMPUSC     : 32;               /*!< Address where the region starts, for use in region determination.
                                                         NOTE: The low-order 2 bits are fixed to 0.                            */
    } MMPUSCn_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  MMPUECn;                         /*!< Group C Region %s Start Address Register                              */
    
    struct {
      __IO uint32_t  MMPUEC     : 32;               /*!< Region end address register Address where the region end, for
                                                         use in region determination. NOTE: The low-order 2 bits are
                                                          fixed to 1.                                                          */
    } MMPUECn_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED2[4];   // Padding changed from uint32_t
} R_MMPU_MMPUACCnRC0_Type;

typedef struct {
  union {
    __IO uint16_t  SMPUSRAMn;                       /*!< Access Control Register for SRAM%s                                    */
    
    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUSRAMn_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED3[2];   // Padding changed from uint16_t
} R_SMPU_SMPUSRAMnRC0_Type;

typedef struct {
  __I  uint8_t  RESERVED4[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  CSnMOD;                          /*!< CS%s Mode Register                                                    */
    
    struct {
      __IO uint16_t  WRMOD      :  1;               /*!< Write Access Mode Select                                              */
           uint16_t             :  2;
      __IO uint16_t  EWENB      :  1;               /*!< External Wait Enable                                                  */
           uint16_t             :  4;
      __IO uint16_t  PRENB      :  1;               /*!< Page Read Access Enable                                               */
      __IO uint16_t  PWENB      :  1;               /*!< Page Write Access Enable                                              */
           uint16_t             :  5;
      __IO uint16_t  PRDMOD     :  1;               /*!< Page Read Access Mode Select                                          */
    } CSnMOD_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  CSnWCR1;                         /*!< CS%s Wait Control Register 1                                          */
    
    struct {
      __IO uint32_t  CSPWWAIT   :  3;               /*!< Page Write Cycle Wait Select NOTE: The CSPWWAIT value is valid
                                                         only when the PWENB bit in CSnMOD is set to 1.                        */
           uint32_t             :  5;
      __IO uint32_t  CSPRWAIT   :  3;               /*!< Page Read Cycle Wait Select NOTE: The CSPRWAIT value is valid
                                                         only when the PRENB bit in CSnMOD is set to 1.                        */
           uint32_t             :  5;
      __IO uint32_t  CSWWAIT    :  5;               /*!< Normal Write Cycle Wait Select                                        */
           uint32_t             :  3;
      __IO uint32_t  CSRWAIT    :  5;               /*!< Normal Read Cycle Wait Select                                         */
    } CSnWCR1_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  CSnWCR2;                         /*!< CS%s Wait Control Register 2                                          */
    
    struct {
      __IO uint32_t  CSROFF     :  3;               /*!< Read-Access CS Extension Cycle Select                                 */
           uint32_t             :  1;
      __IO uint32_t  CSWOFF     :  3;               /*!< Write-Access CS Extension Cycle Select                                */
           uint32_t             :  1;
      __IO uint32_t  WDOFF      :  3;               /*!< Write Data Output Extension Cycle Select                              */
           uint32_t             :  5;
      __IO uint32_t  RDON       :  3;               /*!< RD Assert Wait Select                                                 */
           uint32_t             :  1;
      __IO uint32_t  WRON       :  3;               /*!< WR Assert Wait Select                                                 */
           uint32_t             :  1;
      __IO uint32_t  WDON       :  3;               /*!< Write Data Output Wait Select                                         */
           uint32_t             :  1;
      __IO uint32_t  CSON       :  3;               /*!< CS Assert Wait Select                                                 */
    } CSnWCR2_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED5[4];   // Padding changed from uint32_t
} CSRC0_Type;

typedef struct {
  __I  uint8_t  RESERVED6[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  CSnCR;                           /*!< CS%s Control Register                                                 */
    
    struct {
      __IO uint16_t  EXENB      :  1;               /*!< Operation Enable                                                      */
           uint16_t             :  3;
      __IO uint16_t  BSIZE      :  2;               /*!< External Bus Width Select                                             */
           uint16_t             :  2;
      __IO uint16_t  EMODE      :  1;               /*!< Endian Mode                                                           */
    } CSnCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED7[3 * 2];
  
  union {
    __IO uint16_t  CSnREC;                          /*!< CS%s Recovery Cycle Register                                          */
    
    struct {
      __IO uint16_t  RRCV       :  4;               /*!< Read Recovery                                                         */
           uint16_t             :  4;
      __IO uint16_t  WRCV       :  4;               /*!< Write Recovery                                                        */
    } CSnREC_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED8[4];   // Padding changed from uint32_t
} CSRC1_Type;

typedef struct {
  union {
    __I  uint32_t  BUSnERRADD;                      /*!< Bus Error Address Register %s                                         */
    
    struct {
      __I  uint32_t  BERAD      : 32;               /*!< Bus Error Address When a bus error occurs, It stores an error
                                                         address..                                                             */
    } BUSnERRADD_b;                                 /*!< BitSize                                                               */
  };
  
  union {
    __I  uint8_t   BUSnERRSTAT;                     /*!< Bus Error Status Register %s                                          */
    
    struct {
      __I  uint8_t   ACCSTS     :  1;               /*!< Error access status The status at the time of the error               */
           uint8_t              :  6;
      __I  uint8_t   ERRSTAT    :  1;               /*!< Bus Error Status When bus error assert, error flag occurs.            */
    } BUSnERRSTAT_b;                                /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED9[11];
} BUSnERRRC0_Type;

typedef struct {
  union {
	        __IO uint32_t DELSRn; /*!< DMAC Event Link Setting Register %s                                   */

	        struct {
	            __IO uint32_t DELS : 9; /*!< Event selection to DMAC Start request                                 */
	                 uint32_t      : 7;
                __IO uint32_t IR   : 1; /*!< Interrupt Status Flag for DMAC              */
	        }DELSRn_b; /*!< BitSize                                                               */
	    };
}R_ICU_DELSRn_Type;

typedef struct {
  union {
    __IO uint8_t   LVDnCR1;                         /*!< Voltage Monitoring %s Circuit Control Register 1                      */
    
    struct {
      __IO uint8_t   IDTSEL     :  2;               /*!< Voltage Monitoring Interrupt Generation Condition Select              */
      __IO uint8_t   IRQSEL     :  1;               /*!< Voltage Monitoring Interrupt Type Select                              */
    } LVDnCR1_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   LVDnSR;                          /*!< Voltage Monitoring %s Circuit Status Register                         */
    
    struct {
      __IO uint8_t   DET        :  1;               /*!< Voltage Monitoring Voltage Change Detection Flag NOTE: Only
                                                         0 can be written to this bit. After writing 0 to this bit, it
                                                          takes 2 system clock cycles for the bit to be read as 0.             */
      __I  uint8_t   MON        :  1;               /*!< Voltage Monitoring 1 Signal Monitor Flag                              */
    } LVDnSR_b;                                     /*!< BitSize                                                               */
  };
} R_SYSTEM_LVDnRC0_Type;

typedef struct {
  union {
    __IO uint8_t   ELSEGRn;                         /*!< Event Link Software Event Generation Register %s                      */
    
    struct {
      __O  uint8_t   SEG        :  1;               /*!< Software Event Generation                                             */
           uint8_t              :  5;
      __IO uint8_t   WE         :  1;               /*!< SEG Bit Write Enable                                                  */
      __O  uint8_t   WI         :  1;               /*!< ELSEGR Register Write Disable                                         */
    } ELSEGRn_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED11;
} R_ELC_ELSEGRnRC0_Type;

typedef struct {
  union {
    __IO uint16_t  ELSRn;                           /*!< Event Link Setting Register %s                                        */
    
    struct {
      __IO uint16_t  ELS        :  9;               /*!< Event Link Select                                                     */
    } ELSRn_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED12[2];   // Padding changed from uint16_t
} R_ELC_ELSRnRC0_Type;

typedef struct {
  union {
    __IO uint8_t   RTCCRn;                          /*!< Time Capture Control Register %s                                      */
    
    struct {
      __IO uint8_t   TCCT       :  2;               /*!< Time Capture Control                                                  */
      __I  uint8_t   TCST       :  1;               /*!< Time Capture Status                                                   */
           uint8_t              :  1;
      __IO uint8_t   TCNF       :  2;               /*!< Time Capture Noise Filter Control                                     */
           uint8_t              :  1;
      __IO uint8_t   TCEN       :  1;               /*!< Time Capture Event Input Pin Enable                                   */
    } RTCCRn_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED13;
} R_RTC_RTCCRnRC0_Type;

typedef struct {
  union {
    union {
      __I  uint8_t   BCNT0CPn;                      /*!< BCNT0 Capture Register %s                                             */
      
      struct {
        __I  uint8_t   BCNT0CP  :  8;               /*!< BCNT0CP is a read-only register that captures the BCNT0 value
                                                         when a time capture event is detected.                                */
      } BCNT0CPn_b;                                 /*!< BitSize                                                               */
    };
    
    union {
      __I  uint8_t   RSECCPn;                       /*!< Second Capture Register %s                                            */
      
      struct {
        __I  uint8_t   SEC1     :  4;               /*!< 1-Second Capture Capture value for the ones place of seconds          */
        __I  uint8_t   SEC10    :  3;               /*!< 10-Second Capture Capture value for the tens place of seconds         */
      } RSECCPn_b;                                  /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED14;
  
  union {
    union {
      __I  uint8_t   BCNT1CPn;                      /*!< BCNT1 Capture Register %s                                             */
      
      struct {
        __I  uint8_t   BCNT1CP  :  8;               /*!< BCNT1CP is a read-only register that captures the BCNT1 value
                                                         when a time capture event is detected.                                */
      } BCNT1CPn_b;                                 /*!< BitSize                                                               */
    };
    
    union {
      __I  uint8_t   RMINCPn;                       /*!< Minute Capture Register %s                                            */
      
      struct {
        __I  uint8_t   MIN1     :  4;               /*!< 1-Minute Capture Capture value for the ones place of minutes          */
        __I  uint8_t   MIN10    :  3;               /*!< 10-Minute Capture Capture value for the tens place of minutes         */
      } RMINCPn_b;                                  /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED15;
  
  union {
    union {
      __I  uint8_t   BCNT2CPn;                      /*!< BCNT2 Capture Register %s                                             */
      
      struct {
        __I  uint8_t   BCNT2CP  :  8;               /*!< BCNT2CP is a read-only register that captures the BCNT2 value
                                                         when a time capture event is detected.                                */
      } BCNT2CPn_b;                                 /*!< BitSize                                                               */
    };
    
    union {
      __I  uint8_t   RHRCPn;                        /*!< Hour Capture Register %s                                              */
      
      struct {
        __I  uint8_t   HR1      :  4;               /*!< 1-Minute Capture Capture value for the ones place of minutes          */
        __I  uint8_t   HR10     :  2;               /*!< 10-Minute Capture Capture value for the tens place of minutes         */
        __I  uint8_t   PM       :  1;               /*!< PM                                                                    */
      } RHRCPn_b;                                   /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED16[3];
  
  union {
    union {
      __I  uint8_t   BCNT3CPn;                      /*!< BCNT3 Capture Register %s                                             */
      
      struct {
        __I  uint8_t   BCNT3CP  :  8;               /*!< BCNT3CP is a read-only register that captures the BCNT3 value
                                                         when a time capture event is detected.                                */
      } BCNT3CPn_b;                                 /*!< BitSize                                                               */
    };
    
    union {
      __I  uint8_t   RDATECPn;                      /*!< Date Capture Register %s                                              */
      
      struct {
        __I  uint8_t   DATE1    :  4;               /*!< 1-Day Capture Capture value for the ones place of minutes             */
        __I  uint8_t   DATE10   :  2;               /*!< 10-Day Capture Capture value for the tens place of minutes            */
      } RDATECPn_b;                                 /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED17;
  
  union {
    __I  uint8_t   RMONCPn;                         /*!< Month Capture Register %s                                             */
    
    struct {
      __I  uint8_t   MON1       :  4;               /*!< 1-Month Capture Capture value for the ones place of months            */
      __I  uint8_t   MON10      :  1;               /*!< 10-Month Capture Capture value for the tens place of months           */
    } RMONCPn_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED18[5];
} R_RTC_CnRC0_Type;

typedef struct {
  union {
    __IO uint32_t  MBn_ID;                          /*!< Mailbox Register ID                                                   */
    
    struct {
      __IO uint32_t  EID        : 18;               /*!< Extended ID                                                           */
      __IO uint32_t  SID        : 11;               /*!< Standard ID                                                           */
           uint32_t             :  1;
      __IO uint32_t  RTR        :  1;               /*!< Remote Transmission Request                                           */
      __IO uint32_t  IDE        :  1;               /*!< ID Extension                                                          */
    } MBn_ID_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED19;
  
  union {
    __IO uint8_t   MBn_DL;                          /*!< Mailbox Register DL                                                   */
    
    struct {
      __IO uint8_t   DLC        :  4;               /*!< Data Length Code                                                      */
    } MBn_DL_b;                                     /*!< BitSize                                                               */
  };
  __IO uint8_t   MBn_D[8];                          /*!< Mailbox Register Data %s                                              */
  
  union {
    __IO uint16_t  MBn_TS;                          /*!< Mailbox Register TS                                                   */
    
    struct {
      __IO uint16_t  TSL        :  8;               /*!< Time Stamp Higher Byte Bits TSL[7:0] store the counter value
                                                         of the time stamp when received messages are stored in the mailbox.   */
      __IO uint16_t  TSH        :  8;               /*!< Time Stamp Lower Byte Bits TSH[7:0] store the counter value
                                                         of the time stamp when received messages are stored in the mailbox.   */
    } MBn_TS_b;                                     /*!< BitSize                                                               */
  };
} R_CAN0_MBn_Type;

typedef struct {
  union {
    __IO uint8_t   SARLn;                           /*!< Slave Address Register L%s                                            */
    
    struct {
      __IO uint8_t   SVA        :  8;               /*!< A slave address is set.7-Bit Address = SVA[7:1] 10-Bit Address
                                                         = { SVA9,SVA8,SVA[7:0] }                                              */
    } SARLn_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   SARUn;                           /*!< Slave Address Register U%s                                            */
    
    struct {
      __IO uint8_t   FS         :  1;               /*!< 7-Bit/10-Bit Address Format Selection                                 */
      __IO uint8_t   SVA8       :  1;               /*!< 10-Bit Address(bit8)                                                  */
      __IO uint8_t   SVA9       :  1;               /*!< 10-Bit Address(bit9)                                                  */
    } SARUn_b;                                      /*!< BitSize                                                               */
  };
} R_IIC0_SARLnRC0_Type;

typedef struct {
  union {
    __IO uint32_t  TMSTTRUn;                        /*!< Timer Start Time Setting Register %s                                  */
    
    struct {
      __IO uint32_t  TMSTTRU    : 32;               /*!< These bits hold the setting for the higher-order 32 bits of
                                                         the start time of the pulse output timer in nanoseconds.              */
    } TMSTTRUn_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  TMSTTRLn;                        /*!< Timer Start Time Setting Register %s                                  */
    
    struct {
      __IO uint32_t  TMSTTRL    : 32;               /*!< These bits hold the setting for the lower-order 32 bits of the
                                                         start time of the pulse output timer in nanoseconds.                  */
    } TMSTTRLn_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  TMCYCRn;                         /*!< Timer Cycle Setting Registers %s                                      */
    
    struct {
      __IO uint32_t  TMCYCR     : 30;               /*!< These bits set the cycle of the pulse output timer in nanoseconds.
                                                         Set a value that is equivalent to at least four cycles of the
                                                          STCA clock.                                                          */
    } TMCYCRn_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  TMPLSRn;                         /*!< Timer Pulse Width Setting Register %s                                 */
    
    struct {
      __IO uint32_t  TMPLSR     : 29;               /*!< These bits set the width at high level of the pulse signal from
                                                         the timer in nanoseconds. Set a value that is equivalent to
                                                          at least two cycles of the STCA clock.                               */
    } TMPLSRn_b;                                    /*!< BitSize                                                               */
  };
} R_EPTPC_GEN_TMRC0_Type;

typedef struct {
  union {
    __IO uint32_t  PRMACRUn;                        /*!< Channel %s Local MAC Address Registers                                */
    
    struct {
      __IO uint32_t  PRMACRU    : 24;               /*!< These bits hold the setting for the higher-order 24 bits of
                                                         the local MAC address for Ethernet port 0.                            */
    } PRMACRUn_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PRMACRLn;                        /*!< Channel %s Local MAC Address Registers                                */
    
    struct {
      __IO uint32_t  PRMACRL    : 24;               /*!< These bits hold the setting for the higher-order 24 bits of
                                                         the local MAC address for Ethernet port 0.                            */
    } PRMACRLn_b;                                   /*!< BitSize                                                               */
  };
} R_EPTPC_GEN_PRMACRUCn_Type;

typedef struct {
  union {
    union {
      __IO uint32_t  GTDLYRn;                       /*!< GTIOC%s Rising Output Delay Register                                  */
      
      struct {
        __IO uint32_t  DLYA     :  5;               /*!< GTIOCnA Output Rising Edge Delay Setting                              */
             uint32_t           : 11;
        __IO uint32_t  DLYB     :  5;               /*!< GTIOCnB Output Rising Edge Delay Setting                              */
      } GTDLYRn_b;                                  /*!< BitSize                                                               */
    };
    
    struct {
      union {
        __IO uint16_t  GTDLYRnA;                    /*!< GTIOC%sA Rising Output Delay Register                                 */
        
        struct {
          __IO uint16_t  DLY    :  5;               /*!< GTIOCnA Output Rising Edge Delay Setting                              */
        } GTDLYRnA_b;                               /*!< BitSize                                                               */
      };
      
      union {
        __IO uint16_t  GTDLYRnB;                    /*!< GTIOC%sB Rising Output Delay Register                                 */
        
        struct {
          __IO uint16_t  DLY    :  5;               /*!< GTIOCnB Output Rising Edge Delay Setting                              */
        } GTDLYRnB_b;                               /*!< BitSize                                                               */
      };
    };
  };
} R_GPT_ODC_GTDLYRnRC0_Type;

typedef struct {
  union {
    union {
      __IO uint32_t  GTDLYFn;                       /*!< GTIOC%s Falling Output Delay Register                                 */
      
      struct {
        __IO uint32_t  DLYA     :  5;               /*!< GTIOCnA Output Falling Edge Delay Setting                             */
             uint32_t           : 11;
        __IO uint32_t  DLYB     :  5;               /*!< GTIOCnB Output Falling Edge Delay Setting                             */
      } GTDLYFn_b;                                  /*!< BitSize                                                               */
    };
    
    struct {
      union {
        __IO uint16_t  GTDLYFnA;                    /*!< GTIOC%sA Falling Output Delay Register                                */
        
        struct {
          __IO uint16_t  DLY    :  5;               /*!< GTIOCnA Output Falling Edge Delay Setting                             */
        } GTDLYFnA_b;                               /*!< BitSize                                                               */
      };
      
      union {
        __IO uint16_t  GTDLYFnB;                    /*!< GTIOC%sB Falling Output Delay Register                                */
        
        struct {
          __IO uint16_t  DLY    :  5;               /*!< GTIOCnB Output Falling Edge Delay Setting                             */
        } GTDLYFnB_b;                               /*!< BitSize                                                               */
      };
    };
  };
} R_GPT_ODC_GTDLYFnRC0_Type;

typedef struct {
  union {
    __IO uint32_t  ARGB;                            /*!< Color palette                                                         */
    
    struct {
      __IO uint32_t  BLUE       :  8;               /*!< Blue                                                                  */
      __IO uint32_t  GREEN      :  8;               /*!< Green                                                                 */
      __IO uint32_t  RED        :  8;               /*!< Red                                                                   */
      __IO uint32_t  ALPHA      :  8;               /*!< Alpha                                                                 */
    } ARGB_b;                                       /*!< BitSize                                                               */
  };
} GLCDC_CLUT_Type;

typedef struct {
  union {
    __IO uint32_t  CONTROL;                         /*!< Operation Control Register                                            */
    
    struct {
      __IO uint32_t  EN         :  1;               /*!< Enable                                                                */
           uint32_t             :  7;
      __IO uint32_t  UPDATE     :  1;               /*!< Update                                                                */
           uint32_t             :  7;
      __IO uint32_t  SWRST      :  1;               /*!< Software reset                                                        */
    } CONTROL_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PERIOD;                          /*!< Background plane setting. Free-running period register                */
    
    struct {
      __IO uint32_t  HORIZONTAL : 11;               /*!< Horizontal                                                            */
           uint32_t             :  5;
      __IO uint32_t  VERTICAL   : 11;               /*!< Vertical                                                              */
    } PERIOD_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SYNC_POSITION;                   /*!< Background plane setting. Synchronization position register           */
    
    struct {
      __IO uint32_t  HORIZONTAL :  4;               /*!< Horizontal                                                            */
           uint32_t             : 12;
      __IO uint32_t  VERTICAL   :  4;               /*!< Vertical                                                              */
    } SYNC_POSITION_b;                              /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  VERTICAL;                        /*!< Background plane setting. Full image vertical size register           */
    
    struct {
      __IO uint32_t  SIZE       : 11;               /*!< Size                                                                  */
           uint32_t             :  5;
      __IO uint32_t  START      : 11;               /*!< Start                                                                 */
    } VERTICAL_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  HORIZONTAL;                      /*!< Background plane setting. Full image horizontal size register         */
    
    struct {
      __IO uint32_t  SIZE       : 11;               /*!< Size                                                                  */
           uint32_t             :  5;
      __IO uint32_t  START      : 11;               /*!< Start                                                                 */
    } HORIZONTAL_b;                                 /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  FILL_COLOR;                      /*!< Background plane setting. Background color register                   */
    
    struct {
      __IO uint32_t  BLUE       :  8;               /*!< Blue                                                                  */
      __IO uint32_t  GREEN      :  8;               /*!< Green                                                                 */
      __IO uint32_t  RED        :  8;               /*!< Red                                                                   */
    } FILL_COLOR_b;                                 /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  MONITOR;                         /*!< Background plane setting. Status monitor register                     */
    
    struct {
      __I  uint32_t  EN         :  1;               /*!< Enable                                                                */
           uint32_t             :  7;
      __I  uint32_t  UPDATE     :  1;               /*!< Update                                                                */
           uint32_t             :  7;
      __I  uint32_t  SWRST      :  1;               /*!< Software reset                                                        */
    } MONITOR_b;                                    /*!< BitSize                                                               */
  };
} R_GLCDC_BACKGROUND_Type;

typedef struct {
  union {
    __IO uint32_t  CONTROL;                         /*!< Register Update Control register                                      */
    
    struct {
      __IO uint32_t  UPDATE     :  1;               /*!< Update                                                                */
    } CONTROL_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  READ;                            /*!< Frame buffer read control register                                    */
    
    struct {
      __IO uint32_t  ENABLE     :  1;               /*!< Enable                                                                */
    } READ_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  FRAME1;                          /*!< Frame buffer control register 1                                       */
    
    struct {
      __I  uint32_t  BURST_MODE :  2;               /*!< Burst Mode                                                            */
    } FRAME1_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  FRAME2;                          /*!< Frame buffer control register 2                                       */
    
    struct {
      __IO uint32_t  BASE       : 32;               /*!< Base                                                                  */
    } FRAME2_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  FRAME3;                          /*!< Frame buffer control register 3                                       */
    
    struct {
      __IO uint32_t  NUMBER     : 10;               /*!< Number                                                                */
           uint32_t             :  6;
      __IO uint32_t  LINE_OFFSET: 16;               /*!< Line Offset                                                           */
    } FRAME3_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  FRAME4;                          /*!< Frame buffer control register 4                                       */
    
    struct {
      __IO uint32_t  OFFSET     : 24;               /*!< Offset                                                                */
    } FRAME4_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  FRAME5;                          /*!< Frame buffer control register 5                                       */
    
    struct {
      __IO uint32_t  LINE_BURSTS: 16;               /*!< Line Bursts                                                           */
      __IO uint32_t  LINE_COUNT : 11;               /*!< Line Count                                                            */
    } FRAME5_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  FRAME6;                          /*!< Frame buffer control register 6                                       */
    
    struct {
           uint32_t             : 28;
      __IO uint32_t  FORMAT     :  3;               /*!< Format                                                                */
    } FRAME6_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  GRAPHICS;                        /*!< Alpha blending control register 1                                     */
    
    struct {
      __IO uint32_t  DISPLAY    :  2;               /*!< xxx                                                                   */
           uint32_t             :  2;
      __IO uint32_t  BORDER_ON  :  1;               /*!< xxx                                                                   */
           uint32_t             :  3;
      __IO uint32_t  ALPHA_BORDER_ON:  1;           /*!< xxx                                                                   */
           uint32_t             :  3;
      __IO uint32_t  ALPHA_RECTANGLE:  1;           /*!< xxx                                                                   */
    } GRAPHICS_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  VERTICAL;                        /*!< Alpha blending control register 2                                     */
    
    struct {
      __IO uint32_t  SIZE       : 11;               /*!< xxx                                                                   */
           uint32_t             :  5;
      __IO uint32_t  START      : 11;               /*!< xxx                                                                   */
    } VERTICAL_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  HORIZONTAL;                      /*!< Graphics %s. Alpha blending control register 3                        */
    
    struct {
      __IO uint32_t  SIZE       : 11;               /*!< xxx                                                                   */
           uint32_t             :  5;
      __IO uint32_t  START      : 11;               /*!< xxx                                                                   */
    } HORIZONTAL_b;                                 /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  ALPHA_VERTICAL;                  /*!< Alpha rectangle vertical definition                                   */
    
    struct {
      __IO uint32_t  SIZE       : 11;               /*!< xxx                                                                   */
           uint32_t             :  5;
      __IO uint32_t  START      : 11;               /*!< xxx                                                                   */
    } ALPHA_VERTICAL_b;                             /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  ALPHA_HORIZONTAL;                /*!< Alpha rectangle horizontal definition                                 */
    
    struct {
      __IO uint32_t  SIZE       : 11;               /*!< xxx                                                                   */
           uint32_t             :  5;
      __IO uint32_t  START      : 11;               /*!< xxx                                                                   */
    } ALPHA_HORIZONTAL_b;                           /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  ALPHA_BLEND1;                    /*!< Alpha blending control register 1                                     */
    
    struct {
      __IO uint32_t  RATE       :  8;               /*!< xxx                                                                   */
           uint32_t             :  8;
      __IO uint32_t  ADDER      :  9;               /*!< xxx                                                                   */
    } ALPHA_BLEND1_b;                               /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  ALPHA_BLEND2;                    /*!< Alpha blending control register 2                                     */
    
    struct {
      __IO uint32_t  CHROMAKEY_ENABLE:  1;          /*!< xxx                                                                   */
           uint32_t             : 15;
      __IO uint32_t  START      :  8;               /*!< xxx                                                                   */
    } ALPHA_BLEND2_b;                               /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  CHROMAKEY_MATCH;                 /*!< Alpha blending control register 8                                     */
    
    struct {
      __IO uint32_t  RED        :  8;               /*!< xxx                                                                   */
      __IO uint32_t  BLUE       :  8;               /*!< xxx                                                                   */
      __IO uint32_t  GREEN      :  8;               /*!< xxx                                                                   */
    } CHROMAKEY_MATCH_b;                            /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  CHROMAKEY_REPLACE;               /*!< Alpha blending control register 9                                     */
    
    struct {
      __IO uint32_t  RED        :  8;               /*!< xxx                                                                   */
      __IO uint32_t  BLUE       :  8;               /*!< xxx                                                                   */
      __IO uint32_t  GREEN      :  8;               /*!< xxx                                                                   */
      __IO uint32_t  ALPHA      :  8;               /*!< xxx                                                                   */
    } CHROMAKEY_REPLACE_b;                          /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED20[2 * 4];
  
  union {
    __IO uint32_t  FILL_COLOR;                      /*!< Graphics %s. Background color control register                        */
    
    struct {
      __IO uint32_t  RED        :  8;               /*!< xxx                                                                   */
      __IO uint32_t  BLUE       :  8;               /*!< xxx                                                                   */
      __IO uint32_t  GREEN      :  8;               /*!< xxx                                                                   */
    } FILL_COLOR_b;                                 /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  CLUT_INT;                        /*!< CLUT table interrupt control register                                 */
    
    struct {
      __IO uint32_t  LINE       : 11;               /*!< xxx                                                                   */
           uint32_t             :  5;
      __IO uint32_t  SEL        :  1;               /*!< xxx                                                                   */
    } CLUT_INT_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  MONITOR;                         /*!< Status monitor register                                               */
    
    struct {
      __I  uint32_t  ARCST      :  1;               /*!< xxx                                                                   */
           uint32_t             : 15;
      __I  uint32_t  UNDFLST    :  1;               /*!< xxx                                                                   */
    } MONITOR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED21[42 * 4];
} R_GLCDC_LAYER_Type;

typedef struct {
  union {
    __IO uint32_t  CONTROL;                         /*!< correction block register update control register                     */
    
    struct {
      __IO uint32_t  UPDATE     :  1;               /*!< xxx                                                                   */
    } CONTROL_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  CORRECTION;                      /*!< correction block function control register                            */
    
    struct {
      __IO uint32_t  ENABLE     :  1;               /*!< xxx                                                                   */
    } CORRECTION_b;                                 /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  GAIN[8];                         /*!< correction block table setting register1                              */
    
    struct {
      __IO uint32_t  HIGH       : 11;               /*!< xxx                                                                   */
           uint32_t             :  5;
      __IO uint32_t  LOW        : 11;               /*!< xxx                                                                   */
    } GAIN_b[8];                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  THRESHOLD[5];                    /*!< correction block area setting register1                               */
    
    struct {
      __IO uint32_t  HIGH       : 10;               /*!< xxx                                                                   */
      __IO uint32_t  MID        : 10;               /*!< xxx                                                                   */
      __IO uint32_t  LOW        : 10;               /*!< xxx                                                                   */
    } THRESHOLD_b[5];                               /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED22[4];   // Padding changed from uint32_t
} GLCDC_GAMMA_Type;

typedef struct {
  union {
    __IO uint32_t  CONTROL;                         /*!< Register update control register                                      */
    
    struct {
      __IO uint32_t  UPDATE     :  1;               /*!< xxx                                                                   */
    } CONTROL_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  INTERFACE;                       /*!< Output interface register                                             */
    
    struct {
      __IO uint32_t  PHASE      :  2;               /*!< xxx                                                                   */
           uint32_t             :  2;
      __IO uint32_t  DIRSEL     :  1;               /*!< xxx                                                                   */
           uint32_t             :  3;
      __IO uint32_t  FRQSEL     :  2;               /*!< xxx                                                                   */
           uint32_t             :  2;
      __IO uint32_t  FORMAT     :  2;               /*!< xxx                                                                   */
           uint32_t             : 10;
      __IO uint32_t  SWAP       :  1;               /*!< xxx                                                                   */
           uint32_t             :  3;
      __IO uint32_t  ENDIAN     :  1;               /*!< xxx                                                                   */
    } INTERFACE_b;                                  /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  BRIGHT1;                         /*!< Brightness (DC) correction register1                                  */
    
    struct {
      __IO uint32_t  GREEN      : 10;               /*!< xxx                                                                   */
    } BRIGHT1_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  BRIGHT2;                         /*!< Brightness (DC) correction register2                                  */
    
    struct {
      __IO uint32_t  RED        : 10;               /*!< xxx                                                                   */
           uint32_t             :  6;
      __IO uint32_t  BLUE       : 10;               /*!< xxx                                                                   */
    } BRIGHT2_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  CONTRAST;                        /*!< Contrast (gain) correction register                                   */
    
    struct {
      __IO uint32_t  RED        :  8;               /*!< xxx                                                                   */
      __IO uint32_t  BLUE       :  8;               /*!< xxx                                                                   */
      __IO uint32_t  GREEN      :  8;               /*!< xxx                                                                   */
    } CONTRAST_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  DITHER;                          /*!< Panel dither register                                                 */
    
    struct {
      __IO uint32_t  PATTERN_D  :  2;               /*!< xxx                                                                   */
           uint32_t             :  2;
      __IO uint32_t  PATTERN_C  :  2;               /*!< xxx                                                                   */
           uint32_t             :  2;
      __IO uint32_t  PATTERN_B  :  2;               /*!< xxx                                                                   */
           uint32_t             :  2;
      __IO uint32_t  PATTERN_A  :  2;               /*!< xxx                                                                   */
           uint32_t             :  2;
      __IO uint32_t  FORMAT     :  2;               /*!< xxx                                                                   */
           uint32_t             :  2;
      __IO uint32_t  MODE       :  2;               /*!< xxx                                                                   */
    } DITHER_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED23[3 * 4];
  
  union {
    __IO uint32_t  CLKPHASE;                        /*!< Output phase control register                                         */
    
    struct {
           uint32_t             :  3;
      __IO uint32_t  TCON3      :  1;               /*!< xxx                                                                   */
      __IO uint32_t  TCON2      :  1;               /*!< xxx                                                                   */
      __IO uint32_t  TCON1      :  1;               /*!< xxx                                                                   */
      __IO uint32_t  TCON0      :  1;               /*!< xxx                                                                   */
           uint32_t             :  1;
      __IO uint32_t  DATA       :  1;               /*!< xxx                                                                   */
           uint32_t             :  3;
      __IO uint32_t  FRONTGAM   :  1;               /*!< xxx                                                                   */
    } CLKPHASE_b;                                   /*!< BitSize                                                               */
  };
} R_GLCDC_OUTPUT_Type;

typedef struct {
  __I  uint8_t  RESERVED24[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  OFFSET;                          /*!< TCON. Reference timing setting register                               */
    
    struct {
      __IO uint32_t  HSYNC      : 11;               /*!< xxx                                                                   */
           uint32_t             :  5;
      __IO uint32_t  VSYNC      : 11;               /*!< xxx                                                                   */
    } OFFSET_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  VSYNCA_REG1;                     /*!< VSYNC %s timing setting register 1                                    */
    
    struct {
      __IO uint32_t  SIZE       : 11;               /*!< xxx                                                                   */
           uint32_t             :  5;
      __IO uint32_t  START      : 11;               /*!< xxx                                                                   */
    } VSYNCA_REG1_b;                                /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  VSYNCA_REG2;                     /*!< VSYNC %s timing setting register 2                                    */
    
    struct {
      __IO uint32_t  TCONN_SELECT:  3;              /*!< xxx                                                                   */
           uint32_t             :  1;
      __IO uint32_t  INV        :  1;               /*!< xxx                                                                   */
    } VSYNCA_REG2_b;                                /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  VSYNCB_REG1;                     /*!< VSYNC %s timing setting register 1                                    */
    
    struct {
      __IO uint32_t  SIZE       : 11;               /*!< xxx                                                                   */
           uint32_t             :  5;
      __IO uint32_t  START      : 11;               /*!< xxx                                                                   */
    } VSYNCB_REG1_b;                                /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  VSYNCB_REG2;                     /*!< VSYNC %s timing setting register 2                                    */
    
    struct {
      __IO uint32_t  TCONN_SELECT:  3;              /*!< xxx                                                                   */
           uint32_t             :  1;
      __IO uint32_t  INV        :  1;               /*!< xxx                                                                   */
    } VSYNCB_REG2_b;                                /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  HSYNCA_REG1;                     /*!< HSYNC %s timing setting register 1                                    */
    
    struct {
      __IO uint32_t  SIZE       : 11;               /*!< xxx                                                                   */
           uint32_t             :  5;
      __IO uint32_t  START      : 11;               /*!< xxx                                                                   */
    } HSYNCA_REG1_b;                                /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  HSYNCA_REG2;                     /*!< HSYNC %s timing setting register 2                                    */
    
    struct {
      __IO uint32_t  TCONN_SELECT:  3;              /*!< xxx                                                                   */
           uint32_t             :  1;
      __IO uint32_t  INV        :  1;               /*!< xxx                                                                   */
           uint32_t             :  3;
      __IO uint32_t  REF        :  1;               /*!< xxx                                                                   */
    } HSYNCA_REG2_b;                                /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  HSYNCB_REG1;                     /*!< HSYNC %s timing setting register 1                                    */
    
    struct {
      __IO uint32_t  SIZE       : 11;               /*!< xxx                                                                   */
           uint32_t             :  5;
      __IO uint32_t  START      : 11;               /*!< xxx                                                                   */
    } HSYNCB_REG1_b;                                /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  HSYNCB_REG2;                     /*!< HSYNC %s timing setting register 2                                    */
    
    struct {
      __IO uint32_t  TCONN_SELECT:  3;              /*!< xxx                                                                   */
           uint32_t             :  1;
      __IO uint32_t  INV        :  1;               /*!< xxx                                                                   */
           uint32_t             :  3;
      __IO uint32_t  REF        :  1;               /*!< xxx                                                                   */
    } HSYNCB_REG2_b;                                /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  DATA_ENABLE;                     /*!< TCON. Data enable polarity setting register                           */
    
    struct {
      __IO uint32_t  INV        :  1;               /*!< xxx                                                                   */
    } DATA_ENABLE_b;                                /*!< BitSize                                                               */
  };
} R_GLCDC_TCON_Type;

typedef struct {
  union {
    __IO uint32_t  DETECT;                          /*!< State detection control register                                      */
    
    struct {
      __IO uint32_t  VPOS       :  1;               /*!< xxx                                                                   */
      __IO uint32_t  L1_UNDF    :  1;               /*!< xxx                                                                   */
      __IO uint32_t  L2_UNDF    :  1;               /*!< xxx                                                                   */
    } DETECT_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  EVENT;                           /*!< Event request enable control register                                 */
    
    struct {
      __IO uint32_t  VPOS       :  1;               /*!< xxx                                                                   */
      __IO uint32_t  L1_UNDF    :  1;               /*!< xxx                                                                   */
      __IO uint32_t  L2_UNDF    :  1;               /*!< xxx                                                                   */
    } EVENT_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  CLEAR;                           /*!< Status clear register                                                 */
    
    struct {
      __IO uint32_t  VPOS       :  1;               /*!< xxx                                                                   */
      __IO uint32_t  L1_UNDF    :  1;               /*!< xxx                                                                   */
      __IO uint32_t  L2_UNDF    :  1;               /*!< xxx                                                                   */
    } CLEAR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint32_t  MONITOR;                           /*!< Status monitor register                                               */
  
  union {
    __IO uint32_t  PANEL_CLK;                       /*!< panel clock control register                                          */
    
    struct {
      __IO uint32_t  DIVIDER    :  6;               /*!< xxx                                                                   */
      __IO uint32_t  CLKEN      :  1;               /*!< xxx                                                                   */
           uint32_t             :  1;
      __IO uint32_t  CLKSEL     :  1;               /*!< xxx                                                                   */
           uint32_t             :  3;
      __IO uint32_t  PIXSEL     :  1;               /*!< xxx                                                                   */
           uint32_t             :  3;
      __I  uint32_t  VER        : 16;               /*!< xxx                                                                   */
    } PANEL_CLK_b;                                  /*!< BitSize                                                               */
  };
} R_GLCDC_SYSTEM_Type;


/* ================================================================================ */
/* ================                     R_MMPU                     ================ */
/* ================================================================================ */


/**
  * @brief Bus Master MPU (R_MMPU)
  */

typedef struct {                                    /*!< R_MMPU Structure                                                      */
  
  union {
    __IO uint16_t  MMPUCTLA;                        /*!< Bus Master MPU Control Group A Register                               */
    
    struct {
      __IO uint16_t  ENABLE     :  1;               /*!< Master Group enable                                                   */
      __IO uint16_t  OAD        :  1;               /*!< Operation after detection                                             */
           uint16_t             :  6;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MMPUCTLA_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED[64 * 4];
  
  union {
    __IO uint16_t  MMPUPTA;                         /*!< Group A Protection of Register                                        */
    
    struct {
      __IO uint16_t  PROTECT    :  1;               /*!< Protection of register(MMPUSAn, MMPUEAn and MMPUACAn)                 */
           uint16_t             :  7;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MMPUPTA_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED1[63 * 4];
  R_MMPU_MMPUACAnRC0_Type MMPUACAnRC0[32];          /*!< Group A Region %s Access Control Register Cluster 0                   */
  
  union {
    __IO uint16_t  MMPUCTLB;                        /*!< Bus Master MPU Control Group B Register                               */
    
    struct {
      __IO uint16_t  ENABLE     :  1;               /*!< Master Group enable                                                   */
      __IO uint16_t  OAD        :  1;               /*!< Operation after detection                                             */
           uint16_t             :  6;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MMPUCTLB_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED2[64 * 4];
  
  union {
    __IO uint16_t  MMPUPTB;                         /*!< Group B Protection of Register                                        */
    
    struct {
      __IO uint16_t  PROTECT    :  1;               /*!< Protection of register(MMPUSBn, MMPUEBn and MMPUACBn)                 */
           uint16_t             :  7;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MMPUPTB_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED3[63 * 4];
  R_MMPU_MMPUACBnRC0_Type MMPUACBnRC0[8];           /*!< Group B Region %s Access Control Register Cluster 0                   */
  __I  uint8_t RESERVED4[96 * 4];
  
  union {
    __IO uint16_t  MMPUCTLC;                        /*!< Bus Master MPU Control Group C Register                               */
    
    struct {
      __IO uint16_t  ENABLE     :  1;               /*!< Master Group enable                                                   */
      __IO uint16_t  OAD        :  1;               /*!< Operation after detection                                             */
           uint16_t             :  6;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MMPUCTLC_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED5[64 * 4];
  
  union {
    __IO uint16_t  MMPUPTC;                         /*!< Group C protection of register                                        */
    
    struct {
      __IO uint16_t  PROTECT    :  1;               /*!< Protection of register(MMPUSCn, MMPUECn and MMPUACCn)                 */
           uint16_t             :  7;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MMPUPTC_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED6[63 * 4];
  R_MMPU_MMPUACCnRC0_Type MMPUACCnRC0[8];           /*!< Group C Region %s Access Control Register Cluster 0                   */
} R_MMPU_Type;


/* ================================================================================ */
/* ================                     R_SMPU                     ================ */
/* ================================================================================ */


/**
  * @brief Bus Slave MPU (R_SMPU)
  */

typedef struct {                                    /*!< R_SMPU Structure                                                      */
  
  union {
    __IO uint16_t  SMPUCTL;                         /*!< Slave MPU Control Register                                            */
    
    struct {
      __IO uint16_t  OAD        :  1;               /*!< Master Group enable                                                   */
      __IO uint16_t  PROTECT    :  2;               /*!< Protection of register Protected register SMPUMBIU, SMPUFBIU,
                                                         SMPUSRAM0, SMPUSRAM1, SMPUP0BIU, SMPUP2BIU, SMPUP6BIU, SMPUP7BIU,
                                                          SMPUEXBIU, SMPUEXBIU2                                                */
           uint16_t             :  5;
      __O  uint16_t  KEY        :  8;               /*!< Key CodeThis bit is used to enable or disable rewriting of the
                                                         PROTECT and OAD bit.                                                  */
    } SMPUCTL_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED[7 * 2];
  
  union {
    __IO uint16_t  SMPUMBIU;                        /*!< Access Control Register for MBIU                                      */
    
    struct {
           uint16_t             :  2;
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
           uint16_t             :  4;
      __IO uint16_t  RP_ROMC    :  1;               /*!< ROMC Read protection                                                  */
      __IO uint16_t  WP_ROMC    :  1;               /*!< ROMC Write protection                                                 */
      __IO uint16_t  RP_HSSRAM  :  1;               /*!< HSSRAM Read protection                                                */
      __IO uint16_t  WP_HSSRAM  :  1;               /*!< HSSRAM Write protection                                               */
    } SMPUMBIU_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED1[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  SMPUFBIU;                        /*!< Access Control Register for FBIU                                      */
    
    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUFBIU_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED2[2];   // Padding changed from uint16_t
  R_SMPU_SMPUSRAMnRC0_Type SMPUSRAMnRC0[2];         /*!< Access Control Register for SRAM%s Register Cluster 0                 */
  
  union {
    __IO uint16_t  SMPUP0BIU;                       /*!< Access Control Register for P%sBIU                                    */
    
    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUP0BIU_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED3[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  SMPUP2BIU;                       /*!< Access Control Register for P%sBIU                                    */
    
    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUP2BIU_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED4[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  SMPUP6BIU;                       /*!< Access Control Register for P%sBIU                                    */
    
    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUP6BIU_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED5[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  SMPUP7BIU;                       /*!< Access Control Register for P%sBIU                                    */
    
    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUP7BIU_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED6[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  SMPUEXBIU;                       /*!< Access Control Register for EXBIU                                     */
    
    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUEXBIU_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED7[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  SMPUEXBIU2;                      /*!< Access Control Register for EXBIU2                                    */
    
    struct {
      __IO uint16_t  RP_CPU     :  1;               /*!< CPU Read protection                                                   */
      __IO uint16_t  WP_CPU     :  1;               /*!< CPU Write protection                                                  */
      __IO uint16_t  RP_GRPA    :  1;               /*!< Master Group A Read protection                                        */
      __IO uint16_t  WP_GRPA    :  1;               /*!< Master Group A Write protection                                       */
      __IO uint16_t  RP_GRPB    :  1;               /*!< Master Group B Read protection                                        */
      __IO uint16_t  WP_GRPB    :  1;               /*!< Master Group B Write protection                                       */
      __IO uint16_t  RP_GRPC    :  1;               /*!< Master Group C Read protection                                        */
      __IO uint16_t  WP_GRPC    :  1;               /*!< Master Group C Write protection                                       */
    } SMPUEXBIU2_b;                                 /*!< BitSize                                                               */
  };
} R_SMPU_Type;


/* ================================================================================ */
/* ================                     R_SPMON                    ================ */
/* ================================================================================ */


/**
  * @brief CPU Stack Pointer Monitor (R_SPMON)
  */

typedef struct {                                    /*!< R_SPMON Structure                                                     */
  
  union {
    __IO uint16_t  MSPMPUOAD;                       /*!< SP_main Monitor Operation After Detection Register                    */
    
    struct {
      __IO uint16_t  OAD        :  1;               /*!< Operation after detection                                             */
           uint16_t             :  7;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MSPMPUOAD_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  MSPMPUCTL;                       /*!< SP_main Monitor Access Control Register                               */
    
    struct {
      __IO uint16_t  ENABLE     :  1;               /*!< SP_main monitor enable                                                */
           uint16_t             :  7;
      __I  uint16_t  ERROR      :  1;               /*!< SP_main monitor error flag                                            */
    } MSPMPUCTL_b;                                  /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  MSPMPUPT;                        /*!< SP_main Monitor Protection of Register                                */
    
    struct {
      __IO uint16_t  PROTECT    :  1;               /*!< Protection of register(MSPMPUAC, MSPMPUSA and MSPMPUSE)               */
           uint16_t             :  7;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } MSPMPUPT_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  MSPMPUSA;                        /*!< SP_main Monitor Start Address Register                                */
    
    struct {
      __IO uint32_t  MSPMPUSA   : 32;               /*!< Region start address registerAddress where the region starts,
                                                         for use in region determination.NOTE: Range: 0x1FF00000-0x200FFFFE
                                                          The low-order 2 bits are fixed to 0.                                 */
    } MSPMPUSA_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  MSPMPUEA;                        /*!< SP_main Monitor End Address Register                                  */
    
    struct {
      __IO uint32_t  MSPMPUEA   : 32;               /*!< Region end address registerAddress where the region starts,
                                                         for use in region determination.NOTE: Range: 0x1FF00003-0x200FFFFF
                                                          The low-order 2 bits are fixed to 1.                                 */
    } MSPMPUEA_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PSPMPUOAD;                       /*!< SP_process Monitor Operation After Detection Register                 */
    
    struct {
      __IO uint16_t  OAD        :  1;               /*!< Operation after detection                                             */
           uint16_t             :  7;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } PSPMPUOAD_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED1[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  PSPMPUCTL;                       /*!< SP_process Monitor Access Control Register                            */
    
    struct {
      __IO uint16_t  ENABLE     :  1;               /*!< SP_process monitor enable                                             */
           uint16_t             :  7;
      __I  uint16_t  ERROR      :  1;               /*!< SP_process monitor error flag                                         */
    } PSPMPUCTL_b;                                  /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PSPMPUPT;                        /*!< SP_process Monitor Protection of Register                             */
    
    struct {
      __IO uint16_t  PROTECT    :  1;               /*!< Protection of register(PSPMPUAC, PSPMPUSA and PSPMPUSE)               */
           uint16_t             :  7;
      __O  uint16_t  KEY        :  8;               /*!< Write KeywordThe data written to these bits are not stored.           */
    } PSPMPUPT_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PSPMPUSA;                        /*!< SP_process Monitor Start Address Register                             */
    
    struct {
      __IO uint32_t  MSPMPUEA   : 32;               /*!< Region start address registerAddress where the region starts,
                                                         for use in region determination.NOTE: Range: 0x1FF00000-0x200FFFFE
                                                          The low-order 2 bits are fixed to 0.                                 */
    } PSPMPUSA_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PSPMPUEA;                        /*!< SP_process Monitor End Address Register                               */
    
    struct {
      __IO uint32_t  PSPMPUEA   : 32;               /*!< Region end address registerAddress where the region starts,
                                                         for use in region determination.NOTE: Range: 0x1FF00003-0x200FFFFF
                                                          The low-order 2 bits are fixed to 1.                                 */
    } PSPMPUEA_b;                                   /*!< BitSize                                                               */
  };
} R_SPMON_Type;


/* ================================================================================ */
/* ================                      R_MMF                     ================ */
/* ================================================================================ */


/**
  * @brief Memory Mirror Function (R_MMF)
  */

typedef struct {                                    /*!< R_MMF Structure                                                       */
  
  union {
    __IO uint32_t  MMSFR;                           /*!< MemMirror SFR                                                         */
    
    struct {
           uint32_t             :  7;
      __IO uint32_t  MEMMIRADDR : 16;               /*!< Specifies the memory mirror address.NOTE: A value cannot be
                                                         set in the low-order 7 bits. These bits are fixed to 0.               */
           uint32_t             :  1;
      __O  uint32_t  KEY        :  8;               /*!< Key Code                                                              */
    } MMSFR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  MMEN;                            /*!< MemMirror Enable Register                                             */
    
    struct {
      __IO uint32_t  EN         :  1;               /*!< Memory Mirror Function Enable                                         */
           uint32_t             : 23;
      __O  uint32_t  KEY        :  8;               /*!< Key Code                                                              */
    } MMEN_b;                                       /*!< BitSize                                                               */
  };
} R_MMF_Type;


/* ================================================================================ */
/* ================                     R_SRAM                     ================ */
/* ================================================================================ */


/**
  * @brief SRAM Control (R_SRAM)
  */

typedef struct {                                    /*!< R_SRAM Structure                                                      */
  
  union {
    __IO uint8_t   PARIOAD;                         /*!< RAM Parity Error Operation After Detection Register                   */
    
    struct {
      __IO uint8_t   OAD        :  1;               /*!< Operation after detection                                             */
    } PARIOAD_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED[3];
  
  union {
    __IO uint8_t   RAMPRCR;                         /*!< RAM Protection Register                                               */
    
    struct {
      __IO uint8_t   RAMPRCR    :  1;               /*!< Register Write Control                                                */
      __O  uint8_t   KEY        :  7;               /*!< Key Code                                                              */
    } RAMPRCR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED1[3];
  
  union {
    __IO uint8_t   RAMWTSC;                         /*!< RAM Wait State Control Register                                       */
    
    struct {
      __IO uint8_t   ECCRAMWRWTEN:  1;              /*!< ECCRAM WRITE wait enable                                              */
      __IO uint8_t   ECCRAMRDWTEN:  1;              /*!< ECCRAM READ wait enable                                               */
      __IO uint8_t   SRAM0WTEN  :  1;               /*!< SRAM0 wait enable                                                     */
      __IO uint8_t   SRAM1WTEN  :  1;               /*!< SRAM1 wait enable                                                     */
      __IO uint8_t   SRAMHSWTEN :  1;               /*!< SRAMHSWTEN                                                            */
    } RAMWTSC_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED2[183];
  
  union {
    __IO uint8_t   ECCRAMMODE;                      /*!< ECCRAM Operating Mode Control Register                                */
    
    struct {
      __IO uint8_t   RAMMOD     :  2;               /*!< RAM Operating Mode Select                                             */
    } ECCRAMMODE_b;                                 /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ECCRAM2STS;                      /*!< ECCRAM 2-Bit Error Status Register                                    */
    
    struct {
      __IO uint8_t   ECCRAM2ERR :  1;               /*!< ECC 2-Bit Error Status                                                */
    } ECCRAM2STS_b;                                 /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ECCRAM1STSEN;                    /*!< ECCRAM 1-Bit Error Information Update Enable Register                 */
    
    struct {
      __IO uint8_t   E1STSEN    :  1;               /*!< ECC 1-Bit Error Information Update Enable                             */
    } ECCRAM1STSEN_b;                               /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ECCRAM1STS;                      /*!< ECCRAM 1-Bit Error Status Register                                    */
    
    struct {
      __IO uint8_t   ECCRAM1ERR :  1;               /*!< ECC 1-Bit Error Status                                                */
    } ECCRAM1STS_b;                                 /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ECCRAMPRCR;                      /*!< ECCRAM Protection Register                                            */
    
    struct {
      __IO uint8_t   ECCRAMPRCR :  1;               /*!< ECCRAMETST Register Write Control                                     */
      __O  uint8_t   KEY        :  7;               /*!< Key Code                                                              */
    } ECCRAMPRCR_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED3[11];
  
  union {
    __IO uint8_t   ECCRAMPRCR2;                     /*!< ECCRAM Protection Register 2                                          */
    
    struct {
      __IO uint8_t   ECCRAMPRCR2:  1;               /*!< ECCRAMETST Register Write Control                                     */
      __O  uint8_t   KEY        :  7;               /*!< Key Code                                                              */
    } ECCRAMPRCR2_b;                                /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED4[3];
  
  union {
    __IO uint8_t   ECCRAMETST;                      /*!< ECCRAM Test Control Register                                          */
    
    struct {
      __IO uint8_t   TSTBYP     :  1;               /*!< ECC Bypass Select                                                     */
    } ECCRAMETST_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED5[3];
  
  union {
    __IO uint8_t   ECCOAD;                          /*!< RAM ECC Error Operation After Detection Register                      */
    
    struct {
      __IO uint8_t   OAD        :  1;               /*!< Operation after detection                                             */
    } ECCOAD_b;                                     /*!< BitSize                                                               */
  };
} R_SRAM_Type;


/* ================================================================================ */
/* ================                      R_BUS                     ================ */
/* ================================================================================ */


/**
  * @brief BUS Control (R_BUS)
  */

typedef struct {                                    /*!< R_BUS Structure                                                       */
  CSRC0_Type CSRC0[8];                              /*!< CS Registers Cluster 0                                                */
  __I  uint8_t RESERVED[480 * 4];
  CSRC1_Type CSRC1[8];                              /*!< CS Registers Cluster 1                                                */
  
  union {
    __IO uint16_t  CSRECEN;                         /*!< CS Recovery Cycle Insertion Enable Register                           */
    
    struct {
      __IO uint16_t  RECVEN0    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 0                        */
      __IO uint16_t  RECVEN1    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 1                        */
      __IO uint16_t  RECVEN2    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 2                        */
      __IO uint16_t  RECVEN3    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 3                        */
      __IO uint16_t  RECVEN4    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 4                        */
      __IO uint16_t  RECVEN5    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 5                        */
      __IO uint16_t  RECVEN6    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 6                        */
      __IO uint16_t  RECVEN7    :  1;               /*!< Separate Bus Recovery Cycle Insertion Enable 7                        */
    } CSRECEN_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED1[447 * 2];
  
  union {
    __IO uint8_t   SDCCR;                           /*!< SDC Control Register                                                  */
    
    struct {
      __IO uint8_t   EXENB      :  1;               /*!< Operation Enable                                                      */
           uint8_t              :  3;
      __IO uint8_t   BSIZE      :  2;               /*!< SDRAM Bus Width Select                                                */
    } SDCCR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   SDCMOD;                          /*!< SDC Mode Register                                                     */
    
    struct {
      __IO uint8_t   EMODE      :  1;               /*!< Endian Mode                                                           */
    } SDCMOD_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   SDAMOD;                          /*!< SDRAM Access Mode Register                                            */
    
    struct {
      __IO uint8_t   BE         :  1;               /*!< Continuous Access Enable                                              */
    } SDAMOD_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED2[13];
  
  union {
    __IO uint8_t   SDSELF;                          /*!< SDRAM Self-Refresh Control Register                                   */
    
    struct {
      __IO uint8_t   SFEN       :  1;               /*!< SDRAM Self-Refresh Enable                                             */
    } SDSELF_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED3[3];
  
  union {
    __IO uint16_t  SDRFCR;                          /*!< SDRAM Refresh Control Register                                        */
    
    struct {
      __IO uint16_t  RFC        : 12;               /*!< Auto-Refresh Request Interval Setting                                 */
      __IO uint16_t  REFW       :  4;               /*!< Auto-Refresh Cycle/ Self-Refresh Clearing Cycle Count Setting.
                                                         ( REFW+1 Cycles )                                                     */
    } SDRFCR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   SDRFEN;                          /*!< SDRAM Auto-Refresh Control Register                                   */
    
    struct {
      __IO uint8_t   RFEN       :  1;               /*!< Auto-Refresh Operation Enable                                         */
    } SDRFEN_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED4[9];
  
  union {
    __IO uint8_t   SDICR;                           /*!< SDRAM Initialization Sequence Control Register                        */
    
    struct {
      __IO uint8_t   INIRQ      :  1;               /*!< Initialization Sequence Start                                         */
    } SDICR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED5[3];
  
  union {
    __IO uint16_t  SDIR;                            /*!< SDRAM Initialization Register                                         */
    
    struct {
      __IO uint16_t  ARFI       :  4;               /*!< Initialization Auto-Refresh Interval ( PRF+3 cycles )                 */
      __IO uint16_t  ARFC       :  4;               /*!< Initialization Auto-Refresh Count                                     */
      __IO uint16_t  PRC        :  3;               /*!< Initialization Precharge Cycle Count ( PRF+3 cycles )                 */
    } SDIR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED6[13 * 2];
  
  union {
    __IO uint8_t   SDADR;                           /*!< SDRAM Address Register                                                */
    
    struct {
      __IO uint8_t   MXC        :  2;               /*!< Address Multiplex Select                                              */
    } SDADR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED7[3];
  
  union {
    __IO uint32_t  SDTR;                            /*!< SDRAM Timing Register                                                 */
    
    struct {
      __IO uint32_t  CL         :  3;               /*!< SDRAMC Column Latency                                                 */
           uint32_t             :  5;
      __IO uint32_t  WR         :  1;               /*!< Write Recovery Interval                                               */
      __IO uint32_t  RP         :  3;               /*!< Row Precharge Interval ( RP+1 cycles )                                */
      __IO uint32_t  RCD        :  2;               /*!< Row Column Latency ( RCD+1 cycles )                                   */
           uint32_t             :  2;
      __IO uint32_t  RAS        :  3;               /*!< Row Active Interval                                                   */
    } SDTR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  SDMOD;                           /*!< SDRAM Mode Register                                                   */
    
    struct {
      __IO uint16_t  MR         : 15;               /*!< Mode Register SettingWriting to these bits: Mode register set
                                                         command is issued.                                                    */
    } SDMOD_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED8[3 * 2];
  
  union {
    __I  uint8_t   SDSR;                            /*!< SDRAM Status Register                                                 */
    
    struct {
      __I  uint8_t   MRSST      :  1;               /*!< Mode Register Setting Status                                          */
           uint8_t              :  2;
      __I  uint8_t   INIST      :  1;               /*!< Initialization Status                                                 */
      __I  uint8_t   SRFST      :  1;               /*!< Self-Refresh Transition/Recovery Status                               */
    } SDSR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED9[943];
  
  union {
    __IO uint16_t  BUSMCNTM4I;                      /*!< Master Bus Control Register %s                                        */
    
    struct {
           uint16_t             :  8;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSMCNTM4I_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED10[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSMCNTM4D;                      /*!< Master Bus Control Register %s                                        */
    
    struct {
           uint16_t             :  8;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSMCNTM4D_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED11[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSMCNTSYS;                      /*!< Master Bus Control Register %s                                        */
    
    struct {
           uint16_t             :  8;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSMCNTSYS_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED12[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSMCNTDMA;                      /*!< Master Bus Control Register %s                                        */
    
    struct {
           uint16_t             :  8;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSMCNTDMA_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED13[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSMCNTEDM;                      /*!< Master Bus Control Register %s                                        */
    
    struct {
           uint16_t             :  8;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSMCNTEDM_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED14[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSMCNTHMI;                      /*!< Master Bus Control Register %s                                        */
    
    struct {
           uint16_t             :  8;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSMCNTHMI_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED15[117 * 2];
  
  union {
    __IO uint16_t  BUSSCNTFLI;                      /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTFLI_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED16[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTRAMH;                     /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTRAMH_b;                                /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED17[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTMBIU;                     /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTMBIU_b;                                /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED18[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTRAM0;                     /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTRAM0_b;                                /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED19[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTRAM1;                     /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTRAM1_b;                                /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED20[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTP0B;                      /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTP0B_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED21[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTP2B;                      /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTP2B_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED22[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTP3B;                      /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTP3B_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED23[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTP4B;                      /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTP4B_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED24[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTP5B;                      /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTP5B_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED25[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTP6B;                      /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTP6B_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED26[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTP7B;                      /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTP7B_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED27[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTFBU;                      /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTFBU_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED28[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTEXT;                      /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTEXT_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED29[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTEXT2;                     /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTEXT2_b;                                /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED30[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BUSSCNTHMI;                      /*!< Slave Bus Control Register %s                                         */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  ARBMET     :  2;               /*!< Arbitration MethodSpecify the priority between groups                 */
           uint16_t             :  2;
      __IO uint16_t  EWRES      :  1;               /*!< Early Write ResponseWhether the next write request is accepted
                                                         or not until a response for the write transaction comes back.
                                                                                                                               */
           uint16_t             :  6;
      __IO uint16_t  IERES      :  1;               /*!< Ignore Error Responses                                                */
    } BUSSCNTHMI_b;                                 /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED31[865 * 2];
  BUSnERRRC0_Type BUSnERRRC0[11];                   /*!< BUS %s Error Registers Cluster 0                                      */
} R_BUS_Type;


/* ================================================================================ */
/* ================                     R_DMAC0                    ================ */
/* ================================================================================ */


/**
  * @brief Direct memory access controller 0 (R_DMAC0)
  */

typedef struct {                                    /*!< R_DMAC0 Structure                                                     */
  
  union {
    __IO uint32_t  DMSAR;                           /*!< DMA Source Address Register                                           */
    
    struct {
      __IO uint32_t  DMSAR      : 32;               /*!< Specifies the transfer source start address.                          */
    } DMSAR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  DMDAR;                           /*!< DMA Destination Address Register                                      */
    
    struct {
      __IO uint32_t  DMDAR      : 32;               /*!< Specifies the transfer destination start address.                     */
    } DMDAR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  DMCRA;                           /*!< DMA Transfer Count Register                                           */
    
    struct {
      __IO uint32_t  DMCRAL     : 16;               /*!< Lower bits of transfer count                                          */
      __IO uint32_t  DMCRAH     : 10;               /*!< Upper bits of transfer count                                          */
    } DMCRA_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  DMCRB;                           /*!< DMA Block Transfer Count Register                                     */
    
    struct {
      __IO uint16_t  DMCRB      : 16;               /*!< Specifies the number of block transfer operations or repeat
                                                         transfer operations.                                                  */
    } DMCRB_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  DMTMD;                           /*!< DMA Transfer Mode Register                                            */
    
    struct {
      __IO uint16_t  DCTG       :  2;               /*!< Transfer Request Source Select                                        */
           uint16_t             :  6;
      __IO uint16_t  SZ         :  2;               /*!< Transfer Data Size Select                                             */
           uint16_t             :  2;
      __IO uint16_t  DTS        :  2;               /*!< Repeat Area Select                                                    */
      __IO uint16_t  MD         :  2;               /*!< Transfer Mode Select                                                  */
    } DMTMD_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED1;
  
  union {
    __IO uint8_t   DMINT;                           /*!< DMA Interrupt Setting Register                                        */
    
    struct {
      __IO uint8_t   DARIE      :  1;               /*!< NMI Detection Set                                                     */
      __IO uint8_t   SARIE      :  1;               /*!< Source Address Extended Repeat Area Overflow Interrupt Enable         */
      __IO uint8_t   RPTIE      :  1;               /*!< Repeat Size End Interrupt Enable                                      */
      __IO uint8_t   ESIE       :  1;               /*!< Transfer Escape End Interrupt Enable                                  */
      __IO uint8_t   DTIE       :  1;               /*!< Transfer End Interrupt Enable                                         */
    } DMINT_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  DMAMD;                           /*!< DMA Address Mode Register                                             */
    
    struct {
      __IO uint16_t  DARA       :  5;               /*!< Destination Address Extended Repeat Area                              */
           uint16_t             :  1;
      __IO uint16_t  DM         :  2;               /*!< Destination Address Update Mode                                       */
      __IO uint16_t  SARA       :  5;               /*!< Source Address Extended Repeat AreaSpecifies the extended repeat
                                                         area on the source address. For details on the settings.              */
           uint16_t             :  1;
      __IO uint16_t  SM         :  2;               /*!< Source Address Update Mode                                            */
    } DMAMD_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED2[2];   // Padding changed from uint16_t
  
  union {
    __IO uint32_t  DMOFR;                           /*!< DMA Offset Register                                                   */
    
    struct {
      __IO uint32_t  DMOFR      : 32;               /*!< Specifies the offset when offset addition is selected as the
                                                         address update mode for transfer source or destination.               */
    } DMOFR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DMCNT;                           /*!< DMA Transfer Enable Register                                          */
    
    struct {
      __IO uint8_t   DTE        :  1;               /*!< DMA Transfer Enable                                                   */
    } DMCNT_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DMREQ;                           /*!< DMA Software Start Register                                           */
    
    struct {
      __IO uint8_t   SWREQ      :  1;               /*!< DMA Software Start                                                    */
           uint8_t              :  3;
      __IO uint8_t   CLRS       :  1;               /*!< DMA Software Start Bit Auto Clear Select                              */
    } DMREQ_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DMSTS;                           /*!< DMA Status Register                                                   */
    
    struct {
      __IO uint8_t   ESIF       :  1;               /*!< Transfer Escape End Interrupt Flag                                    */
           uint8_t              :  3;
      __IO uint8_t   DTIF       :  1;               /*!< Transfer End Interrupt Flag                                           */
           uint8_t              :  2;
      __I  uint8_t   ACT        :  1;               /*!< DMA Active Flag                                                       */
    } DMSTS_b;                                      /*!< BitSize                                                               */
  };
} R_DMAC0_Type;


/* ================================================================================ */
/* ================                      R_DMA                     ================ */
/* ================================================================================ */


/**
  * @brief DMAC Module Activation (R_DMA)
  */

typedef struct {                                    /*!< R_DMA Structure                                                       */
  
  union {
    __IO uint8_t   DMAST;                           /*!< DMA Module Activation Register                                        */
    
    struct {
      __IO uint8_t   DMST       :  1;               /*!< DMAC Operation Enable                                                 */
    } DMAST_b;                                      /*!< BitSize                                                               */
  };
} R_DMA_Type;


/* ================================================================================ */
/* ================                      R_DTC                     ================ */
/* ================================================================================ */


/**
  * @brief Data Transfer Controller (R_DTC)
  */

typedef struct {                                    /*!< R_DTC Structure                                                       */
  
  union {
    __IO uint8_t   DTCCR;                           /*!< DTC Control Register                                                  */
    
    struct {
           uint8_t              :  4;
      __IO uint8_t   RRS        :  1;               /*!< DTC Transfer Information Read Skip Enable.                            */
    } DTCCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED[3];
  
  union {
    __IO uint32_t  DTCVBR;                          /*!< DTC Vector Base Register                                              */
    
    struct {
      __IO uint32_t  DTCVBR     : 32;               /*!< Set DTC Vector Base Address.Note: A value cannot be set in the
                                                         lower-order 10 bits. These bits are fixed to 0.                       */
    } DTCVBR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED1[4];   // Padding changed from uint32_t
  
  union {
    __IO uint8_t   DTCST;                           /*!< DTC Module Start Register                                             */
    
    struct {
      __IO uint8_t   DTCST      :  1;               /*!< DTC Module Start                                                      */
    } DTCST_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED2;
  
  union {
    __I  uint16_t  DTCSTS;                          /*!< DTC Status Register                                                   */
    
    struct {
      __I  uint16_t  VECN       :  8;               /*!< DTC-Activating Vector Number MonitoringThese bits indicate the
                                                         vector number for the activating source when DTC transfer is
                                                          in progress.The value is only valid if DTC transfer is in progress
                                                          (the value of the ACT flag is 1)                                     */
           uint16_t             :  7;
      __I  uint16_t  ACT        :  1;               /*!< DTC Active Flag                                                       */
    } DTCSTS_b;                                     /*!< BitSize                                                               */
  };
} R_DTC_Type;


/* ================================================================================ */
/* ================                      R_ICU                     ================ */
/* ================================================================================ */


/**
  * @brief Interrupt Controller (R_ICU)
  */

typedef struct {                                    /*!< R_ICU Structure                                                       */
  
  union {
    __IO uint8_t   IRQCRn[16];                      /*!< IRQ Control Register %s                                               */
    
    struct {
      __IO uint8_t   IRQMD      :  2;               /*!< IRQ Detection Sense Select                                            */
           uint8_t              :  2;
      __IO uint8_t   FCLKSEL    :  2;               /*!< IRQ Digital Filter Sampling Clock                                     */
           uint8_t              :  1;
      __IO uint8_t   FLTEN      :  1;               /*!< IRQ Digital Filter Enable                                             */
    } IRQCRn_b[16];                                 /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED[60 * 4];
  
  union {
    __IO uint8_t   NMICR;                           /*!< NMI Pin Interrupt Control Register                                    */
    
    struct {
      __IO uint8_t   NMIMD      :  1;               /*!< NMI Detection Set                                                     */
           uint8_t              :  3;
      __IO uint8_t   NFCLKSEL   :  2;               /*!< NMI Digital Filter Sampling Clock                                     */
           uint8_t              :  1;
      __IO uint8_t   NFLTEN     :  1;               /*!< NMI Digital Filter Enable                                             */
    } NMICR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED1[31];
  
  union {
    __IO uint16_t  NMIER;                           /*!< Non-Maskable Interrupt Enable Register                                */
    
    struct {
      __IO uint16_t  IWDTEN     :  1;               /*!< IWDT Underflow/Refresh Error Enable                                   */
      __IO uint16_t  WDTEN      :  1;               /*!< WDT Underflow/Refresh Error Enable                                    */
      __IO uint16_t  LVD1EN     :  1;               /*!< Voltage-Monitoring 1 Interrupt Enable                                 */
      __IO uint16_t  LVD2EN     :  1;               /*!< Voltage-Monitoring 2 Interrupt Enable                                 */
      __IO uint16_t  VBATTEN    :  1;               /*!< VBATT monitor Interrupt Enable                                        */
           uint16_t             :  1;
      __IO uint16_t  OSTEN      :  1;               /*!< Oscillation Stop Detection Interrupt Enable                           */
      __IO uint16_t  NMIEN      :  1;               /*!< NMI Enable                                                            */
      __IO uint16_t  RPEEN      :  1;               /*!< RAM Parity Error Interrupt Enable                                     */
      __IO uint16_t  RECCEN     :  1;               /*!< RAM ECC Error Interrupt Enable                                        */
      __IO uint16_t  BUSSEN     :  1;               /*!< MPU Bus Slave Error Interrupt Enable                                  */
      __IO uint16_t  BUSMEN     :  1;               /*!< MPU Bus Master Error Interrupt Enable                                 */
      __IO uint16_t  SPEEN      :  1;               /*!< MPU Stack Error Interrupt Enable                                      */
    } NMIER_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED2[7 * 2];
  
  union {
    __O  uint16_t  NMICLR;                          /*!< Non-Maskable Interrupt Status Clear Register                          */
    
    struct {
      __O  uint16_t  IWDTCLR    :  1;               /*!< IWDTST Clear                                                          */
      __O  uint16_t  WDTCLR     :  1;               /*!< WDTST Clear                                                           */
      __O  uint16_t  LVD1CLR    :  1;               /*!< LVD1ST Clear                                                          */
      __O  uint16_t  LVD2CLR    :  1;               /*!< LVD2ST Clear                                                          */
      __O  uint16_t  VBATTCLR   :  1;               /*!< VBATTST Clear                                                         */
           uint16_t             :  1;
      __O  uint16_t  OSTCLR     :  1;               /*!< OSTST Clear                                                           */
      __O  uint16_t  NMICLR     :  1;               /*!< NMIST Clear                                                           */
      __O  uint16_t  RPECLR     :  1;               /*!< RPEST Clear                                                           */
      __O  uint16_t  RECCCLR    :  1;               /*!< RECCST Clear                                                          */
      __O  uint16_t  BUSSCLR    :  1;               /*!< BUSSST Clear                                                          */
      __O  uint16_t  BUSMCLR    :  1;               /*!< BUSMST Clear                                                          */
      __O  uint16_t  SPECLR     :  1;               /*!< SPEST Clear                                                           */
    } NMICLR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED3[7 * 2];
  
  union {
    __I  uint16_t  NMISR;                           /*!< Non-Maskable Interrupt Status Register                                */
    
    struct {
      __I  uint16_t  IWDTST     :  1;               /*!< IWDT Underflow/Refresh Error Status Flag                              */
      __I  uint16_t  WDTST      :  1;               /*!< WDT Underflow/Refresh Error Status Flag                               */
      __I  uint16_t  LVD1ST     :  1;               /*!< Voltage-Monitoring 1 Interrupt Status Flag                            */
      __I  uint16_t  LVD2ST     :  1;               /*!< Voltage-Monitoring 2 Interrupt Status Flag                            */
      __I  uint16_t  VBATTST    :  1;               /*!< VBATT monitor Interrupt Status Flag                                   */
           uint16_t             :  1;
      __I  uint16_t  OSTST      :  1;               /*!< Oscillation Stop Detection Interrupt Status Flag                      */
      __I  uint16_t  NMIST      :  1;               /*!< NMI Status Flag                                                       */
      __I  uint16_t  RPEST      :  1;               /*!< RAM Parity Error Interrupt Status Flag                                */
      __I  uint16_t  RECCST     :  1;               /*!< RAM ECC Error Interrupt Status Flag                                   */
      __I  uint16_t  BUSSST     :  1;               /*!< MPU Bus Slave Error Interrupt Status Flag                             */
      __I  uint16_t  BUSMST     :  1;               /*!< MPU Bus Master Error Interrupt Status Flag                            */
      __I  uint16_t  SPEST      :  1;               /*!< MPU Stack Error Interrupt Status Flag                                 */
    } NMISR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED4[47 * 2];
  
  union {
    __IO uint32_t  WUPEN;                           /*!< Wake Up interrupt enable register                                     */
    
    struct {
      __IO uint32_t  IRQWUPEN0  :  1;               /*!< IRQ0 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN1  :  1;               /*!< IRQ1 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN2  :  1;               /*!< IRQ2 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN3  :  1;               /*!< IRQ3 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN4  :  1;               /*!< IRQ4 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN5  :  1;               /*!< IRQ5 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN6  :  1;               /*!< IRQ6 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN7  :  1;               /*!< IRQ7 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN8  :  1;               /*!< IRQ8 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN9  :  1;               /*!< IRQ9 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  IRQWUPEN10 :  1;               /*!< IRQ10 interrupt S/W standby returns enable bit                        */
      __IO uint32_t  IRQWUPEN11 :  1;               /*!< IRQ11 interrupt S/W standby returns enable bit                        */
      __IO uint32_t  IRQWUPEN12 :  1;               /*!< IRQ12 interrupt S/W standby returns enable bit                        */
      __IO uint32_t  IRQWUPEN13 :  1;               /*!< IRQ13 interrupt S/W standby returns enable bit                        */
      __IO uint32_t  IRQWUPEN14 :  1;               /*!< IRQ14 interrupt S/W standby returns enable bit                        */
      __IO uint32_t  IRQWUPEN15 :  1;               /*!< IRQ15 interrupt S/W standby returns enable bit                        */
      __IO uint32_t  IWDTWUPEN  :  1;               /*!< IWDT interrupt S/W standby returns enable bit                         */
      __IO uint32_t  KEYWUPEN   :  1;               /*!< Key interrupt S/W standby returns enable bit                          */
      __IO uint32_t  LVD1WUPEN  :  1;               /*!< LVD1 interrupt S/W standby returns enable bit                         */
      __IO uint32_t  LVD2WUPEN  :  1;               /*!< LVD2 interrupt S/W standby returns enable bit                         */
           uint32_t             :  2;
      __IO uint32_t  COMPOC0WUPEN:  1;              /*!< Comparator-OC0 interrupt S/W standby returns enable bit               */
           uint32_t             :  1;
      __IO uint32_t  RTCALMWUPEN:  1;               /*!< RTC alarm interrupt S/W standby returns enable bit                    */
      __IO uint32_t  RTCPRDWUPEN:  1;               /*!< RTC period interrupt S/W standby returns enable bit                   */
      __IO uint32_t  USBHSWUPEN :  1;               /*!< USBHS interrupt S/W standby returns enable bit                        */
      __IO uint32_t  USBFSWUPEN :  1;               /*!< USBFS interrupt S/W standby returns enable bit                        */
      __IO uint32_t  AGT1UDWUPEN:  1;               /*!< AGT1 underflow interrupt S/W standby returns enable bit               */
      __IO uint32_t  AGT1CAWUPEN:  1;               /*!< AGT1 compare match A interrupt S/W standby returns enable bit         */
      __IO uint32_t  AGT1CBWUPEN:  1;               /*!< AGT1 compare match B interrupt S/W standby returns enable bit         */
      __IO uint32_t  RIIC0WUPEN :  1;               /*!< RIIC0 address match interrupt S/W standby returns enable bit          */
    } WUPEN_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED5[23 * 4];
  
  union {
    __IO uint16_t  SELSR0;                          /*!< Event Selection to Cancel Snooze Mode                                 */
    
    struct {
      __IO uint16_t  SELS       :  9;               /*!< Event selection to cancel snooze mode                                 */
    } SELSR0_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED6[63 * 2];
  R_ICU_DELSRn_Type DELSRn[8];                      /*!< DMAC Event Link Setting Register %s                                   */
  __I  uint8_t RESERVED7[24 * 4];
  
  union {
    __IO uint32_t  IELSRn[96];                      /*!< INT Event Link Setting Register %s                                    */
    
    struct {
      __IO uint32_t  IELS       :  9;               /*!< Event selection to NVIC                                               */
           uint32_t             :  7;
      __IO uint32_t  IR         :  1;               /*!< Interrupt Status Flag                                                 */
           uint32_t             :  7;
      __IO uint32_t  DTCE       :  1;               /*!< DTC Activation Enable                                                 */
    } IELSRn_b[96];                                 /*!< BitSize                                                               */
  };
} R_ICU_Type;


/* ================================================================================ */
/* ================                      R_DBG                     ================ */
/* ================================================================================ */


/**
  * @brief Debug Function (R_DBG)
  */

typedef struct {                                    /*!< R_DBG Structure                                                       */
  
  union {
    __I  uint32_t  DBGSTR;                          /*!< Debug Status Register                                                 */
    
    struct {
           uint32_t             : 28;
      __I  uint32_t  CDBGPWRUPREQ:  1;              /*!< Debug power-up request                                                */
      __I  uint32_t  CDBGPWRUPACK:  1;              /*!< Debug power-up acknowledge                                            */
    } DBGSTR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED[3 * 4];
  
  union {
    __IO uint32_t  DBGSTOPCR;                       /*!< Debug Stop Control Register                                           */
    
    struct {
      __IO uint32_t  DSIWDT     :  1;               /*!< Mask bit for IWDT reset/interruptNOTE: This bit is regarded
                                                         as 0 when debugger is not connected.                                  */
      __IO uint32_t  DSWDT      :  1;               /*!< Mask bit for WDT reset/interruptNOTE: This bit is regarded as
                                                         0 when debugger is not connected.                                     */
           uint32_t             : 14;
      __IO uint32_t  DSLVD0     :  1;               /*!< Mask bit for LVD0 reset/interruptNOTE: This bit is regarded
                                                         as 0 when debugger is not connected.                                  */
      __IO uint32_t  DSLVD1     :  1;               /*!< Mask bit for LVD1 reset/interruptNOTE: This bit is regarded
                                                         as 0 when debugger is not connected.                                  */
      __IO uint32_t  DSLVD2     :  1;               /*!< Mask bit for LVD2 reset/interruptNOTE: This bit is regarded
                                                         as 0 when debugger is not connected.                                  */
           uint32_t             :  5;
      __IO uint32_t  DSRPER     :  1;               /*!< Mask bit for RAM parity error reset/interruptNOTE: This bit
                                                         is regarded as 0 when debugger is not connected.                      */
      __IO uint32_t  DSRECCR    :  1;               /*!< Mask bit for RAM ECC error reset/interruptNOTE: This bit is
                                                         regarded as 0 when debugger is not connected.                         */
    } DBGSTOPCR_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED1[3 * 4];
  
  union {
    __IO uint32_t  TRACECTR;                        /*!< Trace Control Register                                                */
    
    struct {
           uint32_t             : 31;
      __IO uint32_t  ENETBFULL  :  1;               /*!< Enable bit for halt request by ETB full                               */
    } TRACECTR_b;                                   /*!< BitSize                                                               */
  };
} R_DBG_Type;


/* ================================================================================ */
/* ================                     R_ROMC                     ================ */
/* ================================================================================ */


/**
  * @brief ROM Cache (R_ROMC)
  */

typedef struct {                                    /*!< R_ROMC Structure                                                      */
  __I  uint8_t RESERVED[64 * 4];
  
  union {
    __IO uint16_t  ROMCE;                           /*!< ROM Cache Enable                                                      */
    
    struct {
      __IO uint16_t  ROMCEN     :  1;               /*!< ROMC Enable                                                           */
    } ROMCE_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED1[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  ROMCIV;                          /*!< ROM Cache Invalidation                                                */
    
    struct {
      __IO uint16_t  ROMCIV     :  1;               /*!< ROM Cache Invalidation                                                */
    } ROMCIV_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED2[11 * 2];
  
  union {
    __IO uint8_t   ROMWT;                           /*!< ROM wait control register                                             */
    
    struct {
      __IO uint8_t   ROMWT      :  3;               /*!< These bits represent the ratio of the CPU clock period to the
                                                         Flash memory access time.                                             */
    } ROMWT_b;                                      /*!< BitSize                                                               */
  };
} R_ROMC_Type;


/* ================================================================================ */
/* ================                    R_SYSTEM                    ================ */
/* ================================================================================ */


/**
  * @brief System Control (R_SYSTEM)
  */

typedef struct {                                    /*!< R_SYSTEM Structure                                                    */
  __I  uint8_t RESERVED[3 * 4];
  
  union {
    __IO uint16_t  SBYCR;                           /*!< Standby Control Register                                              */
    
    struct {
           uint16_t             : 14;
      __IO uint16_t  OPE        :  1;               /*!< Output Port Enable                                                    */
      __IO uint16_t  SSBY       :  1;               /*!< Software Standby                                                      */
    } SBYCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED1[7 * 2];
  
  union {
    __IO uint32_t  MSTPCRA;                         /*!< Module Stop Control Register A                                        */
    
    struct {
      __IO uint32_t  MSTPA0     :  1;               /*!< RAM0 Module Stop                                                      */
      __IO uint32_t  MSTPA1     :  1;               /*!< RAM1 Module Stop                                                      */
           uint32_t             :  3;
      __IO uint32_t  MSTPA5     :  1;               /*!< High-Speed RAM Module Stop                                            */
      __IO uint32_t  MSTPA6     :  1;               /*!< ECCRAM Module Stop                                                    */
      __IO uint32_t  MSTPA7     :  1;               /*!< Standby RAM Module Stop                                               */
           uint32_t             : 14;
      __IO uint32_t  MSTPA22    :  1;               /*!< DMA Controller/Data Transfer Controller Module Stop                   */
    } MSTPCRA_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SCKDIVCR;                        /*!< System Clock Division Control Register                                */
    
    struct {
      __IO uint32_t  PCKD       :  3;               /*!< Peripheral Module Clock D (PCLKD) Select                              */
           uint32_t             :  1;
      __IO uint32_t  PCKC       :  3;               /*!< Peripheral Module Clock C (PCLKC) Select                              */
           uint32_t             :  1;
      __IO uint32_t  PCKB       :  3;               /*!< Peripheral Module Clock B (PCLKB) Select                              */
           uint32_t             :  1;
      __IO uint32_t  PCKA       :  3;               /*!< Peripheral Module Clock A (PCLKA) Select                              */
           uint32_t             :  1;
      __IO uint32_t  BCK        :  3;               /*!< External Bus Clock (BCLK) Select                                      */
           uint32_t             :  5;
      __IO uint32_t  ICK        :  3;               /*!< System Clock (ICLK) Select                                            */
           uint32_t             :  1;
      __IO uint32_t  FCK        :  3;               /*!< Flash IF Clock (FCLK) Select                                          */
    } SCKDIVCR_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   SCKDIVCR2;                       /*!< System Clock Division Control Register 2                              */
    
    struct {
           uint8_t              :  4;
      __IO uint8_t   UCK        :  3;               /*!< USB Clock (UCLK) Select                                               */
    } SCKDIVCR2_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED2;
  
  union {
    __IO uint8_t   SCKSCR;                          /*!< System Clock Source Control Register                                  */
    
    struct {
      __IO uint8_t   CKSEL      :  3;               /*!< Clock Source Select                                                   */
    } SCKSCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED3;
  
  union {
    __IO uint16_t  PLLCCR;                          /*!< PLL Clock Control Register                                            */
    
    struct {
      __IO uint16_t  PLIDIV     :  2;               /*!< PLL Input Frequency Division Ratio Select                             */
           uint16_t             :  2;
      __IO uint16_t  PLLSRCSEL  :  1;               /*!< PLL Clock Source Select                                               */
           uint16_t             :  3;
      __IO uint16_t  PLLMUL     :  6;               /*!< PLL Frequency Multiplication Factor Select [PLL Frequency Multiplication
                                                         Factor] = (PLLUMUL+1) / 2 Range: 0x23 - 0x3B for example 010011:
                                                          x10.0 010100: x10.5 010101: x11.0 : 011100: x14.5 011101: x15.0
                                                          011110: x15.5 : 111010: x29.5 111011: x30.0                          */
    } PLLCCR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   PLLCR;                           /*!< PLL Control Register                                                  */
    
    struct {
      __IO uint8_t   PLLSTP     :  1;               /*!< PLL Stop Control                                                      */
    } PLLCR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
     __IO uint8_t  PLLCCR2;                          /*!< PLL Clock Control Register                                            */

     struct {
       __IO uint8_t  PLLMUL     :  5;               /*!< PLL Multipler                             */
            uint8_t             :  1;
       __IO uint8_t  PLODIV     :  2;               /*!< PLL Divider                 */
     } PLLCCR2_b;                                   /*!< BitSize                                                               */
   };
  __I  uint8_t   RESERVED4[4];

  union {
    __IO uint8_t   BCKCR;                           /*!< External Bus Clock Control Register                                   */
    
    struct {
      __IO uint8_t   BCLKDIV    :  1;               /*!< BCLK Pin Output Select                                                */
    } BCKCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED5;
  
  union {
    __IO uint8_t   MOSCCR;                          /*!< Main Clock Oscillator Control Register                                */
    
    struct {
      __IO uint8_t   MOSTP      :  1;               /*!< Main Clock Oscillator Stop                                            */
    } MOSCCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED6[3];
  
  union {
    __IO uint8_t   HOCOCR;                          /*!< High-Speed On-Chip Oscillator Control Register                        */
    
    struct {
      __IO uint8_t   HCSTP      :  1;               /*!< HOCO Stop                                                             */
    } HOCOCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED7;
  
  union {
    __IO uint8_t   MOCOCR;                          /*!< Middle-Speed On-Chip Oscillator Control Register                      */
    
    struct {
      __IO uint8_t   MCSTP      :  1;               /*!< MOCO Stop                                                             */
    } MOCOCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED8[3];
  
  union {
    __I  uint8_t   OSCSF;                           /*!< Oscillation Stabilization Flag Register                               */
    
    struct {
      __I  uint8_t   HOCOSF     :  1;               /*!< HOCO Clock Oscillation Stabilization FlagNOTE: The HOCOSF bit
                                                         value after a reset is 1 when the OFS1.HOCOEN bit is 0. It is
                                                          0 when the OFS1.HOCOEN bit is 1.                                     */
           uint8_t              :  2;
      __I  uint8_t   MOSCSF     :  1;               /*!< Main Clock Oscillation Stabilization Flag                             */
           uint8_t              :  1;
      __I  uint8_t   PLLSF      :  1;               /*!< PLL Clock Oscillation Stabilization Flag                              */
    } OSCSF_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED9;
  
  union {
    __IO uint8_t   CKOCR;                           /*!< Clock Out Control Register                                            */
    
    struct {
      __IO uint8_t   CKOSEL     :  3;               /*!< Clock out source select                                               */
           uint8_t              :  1;
      __IO uint8_t   CKODIV     :  3;               /*!< Clock out input frequency Division Select                             */
      __IO uint8_t   CKOEN      :  1;               /*!< Clock out enable                                                      */
    } CKOCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED10;
  
  union {
    __IO uint8_t   OSTDCR;                          /*!< Oscillation Stop Detection Control Register                           */
    
    struct {
      __IO uint8_t   OSTDIE     :  1;               /*!< Oscillation Stop Detection Interrupt Enable                           */
           uint8_t              :  6;
      __IO uint8_t   OSTDE      :  1;               /*!< Oscillation Stop Detection Function Enable                            */
    } OSTDCR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   OSTDSR;                          /*!< Oscillation Stop Detection Status Register                            */
    
    struct {
      __IO uint8_t   OSTDF      :  1;               /*!< Oscillation Stop Detection Flag                                       */
    } OSTDSR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED11A[14];
  
  union {
    __IO uint8_t   SLCDSCKCR;                       /*!< Segment LCD Source Clock Control Register                            */

    struct {
    __IO uint8_t  LCDSCKSEL     :  4;               /*!< LCD Source Clock                                       */
      uint8_t                   :  3;
    __IO uint8_t  LCDSCKEN      :  1;               /*!< LCD Source Clock Out Enable                                       */
    } SLCDSCKCR_b;                                  /*!< BitSize                                                               */
  };

  __I  uint8_t  RESERVED11B[1];
  union {
    __IO uint8_t   EBCKOCR;                         /*!< External Bus Clock Output Control Register                            */
    
    struct {
      __IO uint8_t   EBCKOEN    :  1;               /*!< BCLK Pin Output Control                                               */
    } EBCKOCR_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   SDCKOCR;                         /*!< SDRAM Clock Output Control Register                                   */
    
    struct {
      __IO uint8_t   SDCKOEN    :  1;               /*!< SDCLK Pin Output Control                                              */
    } SDCKOCR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED12[13];
  
  union {
    __IO uint8_t   MOCOUTCR;                        /*!< MOCO User Trimming Control Register                                   */
    
    struct {
      __IO uint8_t   MOCOUTRM   :  8;               /*!< MOCO User Trimming 1000_0000 : -128 1000_0001 : -127 1000_0010
                                                         : -126 . . . 1111_1111 : -1 0000_0000 : Center Code 0000_0001
                                                          : +1 . . . 0111_1101 : +125 0111_1110 : +126 0111_1111 : +127These
                                                          bits are added to original MOCO trimming bits                        */
    } MOCOUTCR_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   HOCOUTCR;                        /*!< HOCO User Trimming Control Register                                   */
    
    struct {
      __IO uint8_t   HOCOUTRM   :  8;               /*!< HOCO User Trimming 1000_0000 : -128 1000_0001 : -127 1000_0010
                                                         : -126 . . . 1111_1111 : -1 0000_0000 : Center Code 0000_0001
                                                          : +1 . . . 0111_1101 : +125 0111_1110 : +126 0111_1111 : +127These
                                                          bits are added to original HOCO trimming bits                        */
    } HOCOUTCR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED13[47];
  
  union {
    __IO uint8_t   SNZCR;                           /*!< Snooze Control Register                                               */
    
    struct {
      __IO uint8_t   RXDREQEN   :  1;               /*!< RXD0 Snooze Request EnableNote:Do not set to 1 other than in
                                                         asynchronous mode.                                                    */
      __IO uint8_t   SNZDTCEN   :  1;               /*!< DTC Enable in Snooze Mode                                             */
           uint8_t              :  5;
      __IO uint8_t   SNZE       :  1;               /*!< Snooze Mode Enable                                                    */
    } SNZCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED14;
  
  union {
    __IO uint8_t   SNZEDCR;                         /*!< Snooze End Control Register                                           */
    
    struct {
      __IO uint8_t   AGT1UNFED  :  1;               /*!< AGT1 underflow Snooze End Enable                                      */
      __IO uint8_t   DTCZRED    :  1;               /*!< Last DTC transmission completion Snooze End Enable                    */
      __IO uint8_t   DTCNZRED   :  1;               /*!< Not Last DTC transmission completion Snooze End Enable                */
      __IO uint8_t   AD0MATED   :  1;               /*!< AD ch0 result match Snooze End Enable                                 */
      __IO uint8_t   AD0UMTED   :  1;               /*!< AD ch0 result unmatch Snooze End Enable                               */
      __IO uint8_t   AD1MATED   :  1;               /*!< AD ch1 result match Snooze End Enable                                 */
      __IO uint8_t   AD1UMTED   :  1;               /*!< AD ch1 result unmatch Snooze End Enable                               */
      __IO uint8_t   SCI0UMTED  :  1;               /*!< SCI0 address unmatch Snooze End EnableNote: Do not set to 1
                                                         other than in asynchronous mode.                                      */
    } SNZEDCR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED15[3];
  
  union {
    __IO uint32_t  SNZREQCR;                        /*!< Snooze Request Control Register                                       */
    
    struct {
      __IO uint32_t  SNZREQEN0  :  1;               /*!< Snooze Request Enable 0Enable IRQ0 pin snooze request                 */
      __IO uint32_t  SNZREQEN1  :  1;               /*!< Snooze Request Enable 1Enable IRQ1 pin snooze request                 */
      __IO uint32_t  SNZREQEN2  :  1;               /*!< Snooze Request Enable 2Enable IRQ2 pin snooze request                 */
      __IO uint32_t  SNZREQEN3  :  1;               /*!< Snooze Request Enable 3Enable IRQ3 pin snooze request                 */
      __IO uint32_t  SNZREQEN4  :  1;               /*!< Snooze Request Enable 4Enable IRQ4 pin snooze request                 */
      __IO uint32_t  SNZREQEN5  :  1;               /*!< Snooze Request Enable 5Enable IRQ5 pin snooze request                 */
      __IO uint32_t  SNZREQEN6  :  1;               /*!< Snooze Request Enable 6Enable IRQ6 pin snooze request                 */
      __IO uint32_t  SNZREQEN7  :  1;               /*!< Snooze Request Enable 7Enable IRQ7 pin snooze request                 */
      __IO uint32_t  SNZREQEN8  :  1;               /*!< Snooze Request Enable 8Enable IRQ8 pin snooze request                 */
      __IO uint32_t  SNZREQEN9  :  1;               /*!< Snooze Request Enable 9Enable IRQ9 pin snooze request                 */
      __IO uint32_t  SNZREQEN10 :  1;               /*!< Snooze Request Enable 10Enable IRQ10 pin snooze request               */
      __IO uint32_t  SNZREQEN11 :  1;               /*!< Snooze Request Enable 11Enable IRQ11 pin snooze request               */
      __IO uint32_t  SNZREQEN12 :  1;               /*!< Snooze Request Enable 12Enable IRQ12 pin snooze request               */
      __IO uint32_t  SNZREQEN13 :  1;               /*!< Snooze Request Enable 13Enable IRQ13 pin snooze request               */
      __IO uint32_t  SNZREQEN14 :  1;               /*!< Snooze Request Enable 14Enable IRQ14 pin snooze request               */
      __IO uint32_t  SNZREQEN15 :  1;               /*!< Snooze Request Enable 15Enable IRQ15 pin snooze request               */
           uint32_t             :  1;
      __IO uint32_t  SNZREQEN17 :  1;               /*!< Snooze Request Enable 17Enable KR snooze request                      */
           uint32_t             :  4;
      __IO uint32_t  SNZREQEN22 :  1;               /*!< Snooze Request Enable 22Enable Comparator-OC0 snooze request          */
           uint32_t             :  1;
      __IO uint32_t  SNZREQEN24 :  1;               /*!< Snooze Request Enable 24Enable RTC alarm snooze request               */
      __IO uint32_t  SNZREQEN25 :  1;               /*!< Snooze Request Enable 25Enable RTC period snooze request              */
           uint32_t             :  2;
      __IO uint32_t  SNZREQEN28 :  1;               /*!< Snooze Request Enable 28Enable AGT1 underflow snooze request          */
      __IO uint32_t  SNZREQEN29 :  1;               /*!< Snooze Request Enable 29Enable AGT1 compare match A snooze request    */
      __IO uint32_t  SNZREQEN30 :  1;               /*!< Snooze Request Enable 30Enable AGT1 compare match B snooze request    */
    } SNZREQCR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED16[4];   // Padding changed from uint32_t
  
  union {
    __IO uint8_t   OPCCR;                           /*!< Operating Power Control Register                                      */
    
    struct {
      __IO uint8_t   OPCM       :  2;               /*!< Operating Power Control Mode Select                                   */
           uint8_t              :  2;
      __I  uint8_t   OPCMTSF    :  1;               /*!< Operating Power Control Mode Transition Status Flag                   */
    } OPCCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED17;
  
  union {
    __IO uint8_t   MOSCWTCR;                        /*!< Main Clock Oscillator Wait Control Register                           */
    
    struct {
      __IO uint8_t   MSTS       :  4;               /*!< Main clock oscillator wait time setting                               */
    } MOSCWTCR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED18a[2];

  union {
    __IO uint8_t   HOCOWTCR;                        /*!< HOCO Clock Oscillator Wait Control Register                           */
    
    struct {
      __IO uint8_t   HSTS       :  3;               /*!< HOCO clock oscillator wait time setting                               */
    } HOCOWTCR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED18b[4];
  
  union {
    __IO uint8_t   SOPCCR;                          /*!< Sub Operating Power Control Register                                  */
    
    struct {
      __IO uint8_t   SOPCM      :  1;               /*!< Sub Operating Power Control Mode Select                               */
           uint8_t              :  3;
      __I  uint8_t   SOPCMTSF   :  1;               /*!< Sub Operating Power Control Mode Transition Status Flag               */
    } SOPCCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED19[21];
  
  union {
    __IO uint16_t  RSTSR1;                          /*!< Reset Status Register 1                                               */
    
    struct {
      __IO uint16_t  IWDTRF     :  1;               /*!< Independent Watchdog Timer Reset Detect Flag                          */
      __IO uint16_t  WDTRF      :  1;               /*!< Watchdog Timer Reset Detect Flag                                      */
      __IO uint16_t  SWRF       :  1;               /*!< Software Reset Detect Flag                                            */
           uint16_t             :  5;
      __IO uint16_t  RPERF      :  1;               /*!< RAM Parity Error Reset Detect Flag                                    */
      __IO uint16_t  REERF      :  1;               /*!< RAM ECC Error Reset Detect Flag                                       */
      __IO uint16_t  BUSSRF     :  1;               /*!< Bus Slave MPU Reset Detect Flag                                       */
      __IO uint16_t  BUSMRF     :  1;               /*!< Bus Master MPU Reset Detect Flag                                      */
      __IO uint16_t  SPERF      :  1;               /*!< SP Error Reset Detect Flag                                            */
    } RSTSR1_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED20[2];   // Padding changed from uint16_t
  
  union {
    __IO uint8_t   SWRRAGT;                         /*!< Software Reset Register for AGT                                       */
    
    struct {
      __IO uint8_t   AGTRST     :  1;               /*!< AG Timer Software Reset                                               */
    } SWRRAGT_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED21[12];

  union {
    __IO uint8_t   SDADCCKCR;                       /*!< 24-bit Sigma-Delta A/D Converter Clock Control Register                            */

    struct {
    __IO uint8_t  SDADCCKSEL     :  1;              /*!< SDADC Source Clock                                       */
    uint8_t                      :  6;
    __IO uint8_t  SDADCCKEN      :  1;              /*!< SDADC Source Clock Out Enable                                       */
    } SDADCCKCR_b;                                  /*!< BitSize                                                               */
  };

  __I  uint8_t   RESERVED21B[14];
  
  R_SYSTEM_LVDnRC0_Type LVDnRC0[2];                 /*!< Voltage Monitoring %s Circuit Register Cluster 0                      */
  __I  uint8_t RESERVED22[397 * 2];
  
  union {
    __IO uint16_t  PRCR;                            /*!< Protect Register                                                      */
    
    struct {
      __IO uint16_t  PRC0       :  1;               /*!< Enables writing to the registers related to the clock generation
                                                         circuit.                                                              */
      __IO uint16_t  PRC1       :  1;               /*!< Enables writing to the registers related to the operating modes,
                                                         the low power consumption modes and the battery backup function.      */
           uint16_t             :  1;
      __IO uint16_t  PRC3       :  1;               /*!< Enables writing to the registers related to the LVD.                  */
           uint16_t             :  4;
      __O  uint16_t  PRKEY      :  8;               /*!< PRKEY Key Code                                                        */
    } PRCR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DSPBYCR;                         /*!< Deep Standby Control Register                                         */
    
    struct {
      __IO uint8_t   DEEPCUT    :  2;               /*!< Power-Supply Control                                                  */
           uint8_t              :  4;
      __IO uint8_t   IOKEEP     :  1;               /*!< I/O Port Retention                                                    */
      __IO uint8_t   DPSBY      :  1;               /*!< Deep Software Standby                                                 */
    } DSPBYCR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED23;
  
  union {
    __IO uint8_t   DPSIER0;                         /*!< Deep Standby Interrupt Enable Register 0                              */
    
    struct {
      __IO uint8_t   DIRQ0E     :  1;               /*!< IRQ0-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ1E     :  1;               /*!< IRQ1-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ2E     :  1;               /*!< IRQ2-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ3E     :  1;               /*!< IRQ3-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ4E     :  1;               /*!< IRQ4-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ5E     :  1;               /*!< IRQ5-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ6E     :  1;               /*!< IRQ6-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ7E     :  1;               /*!< IRQ7-DS Pin Enable                                                    */
    } DPSIER0_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DPSIER1;                         /*!< Deep Standby Interrupt Enable Register 1                              */
    
    struct {
      __IO uint8_t   DIRQ8E     :  1;               /*!< IRQ8-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ9E     :  1;               /*!< IRQ9-DS Pin Enable                                                    */
      __IO uint8_t   DIRQ10E    :  1;               /*!< IRQ10-DS Pin Enable                                                   */
      __IO uint8_t   DIRQ11E    :  1;               /*!< IRQ11-DS Pin Enable                                                   */
      __IO uint8_t   DIRQ12E    :  1;               /*!< IRQ12-DS Pin Enable                                                   */
      __IO uint8_t   DIRQ13E    :  1;               /*!< IRQ13-DS Pin Enable                                                   */
      __IO uint8_t   DIRQ14E    :  1;               /*!< IRQ14-DS Pin Enable                                                   */
      __IO uint8_t   DIRQ15E    :  1;               /*!< IRQ15-DS Pin Enable                                                   */
    } DPSIER1_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DPSIER2;                         /*!< Deep Standby Interrupt Enable Register 2                              */
    
    struct {
      __IO uint8_t   DLVD1IE    :  1;               /*!< LVD1 Deep Standby Cancel Signal Enable                                */
      __IO uint8_t   DLVD2IE    :  1;               /*!< LVD2 Deep Standby Cancel Signal Enable                                */
      __IO uint8_t   DTRTCIIE   :  1;               /*!< RTC Interval interrupt Deep Standby Cancel Signal Enable              */
      __IO uint8_t   DRTCAIE    :  1;               /*!< RTC Alarm interrupt Deep Standby Cancel Signal Enable                 */
      __IO uint8_t   DNMIE      :  1;               /*!< NMI Pin Enable                                                        */
    } DPSIER2_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DPSIER3;                         /*!< Deep Standby Interrupt Enable Register 3                              */
    
    struct {
      __IO uint8_t   DUSBFSIE   :  1;               /*!< USBFS Suspend/Resume Deep Standby Cancel Signal Enable                */
      __IO uint8_t   DUSBHSIE   :  1;               /*!< USBHS Suspend/Resume Deep Standby Cancel Signal Enable                */
      __IO uint8_t   DAGT1IE    :  1;               /*!< AGT1 Underflow Deep Standby Cancel Signal Enable                      */
    } DPSIER3_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DPSIFR0;                         /*!< Deep Standby Interrupt Flag Register 0                                */
    
    struct {
      __IO uint8_t   DIRQ0F     :  1;               /*!< IRQ0-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ1F     :  1;               /*!< IRQ1-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ2F     :  1;               /*!< IRQ2-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ3F     :  1;               /*!< IRQ3-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ4F     :  1;               /*!< IRQ4-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ5F     :  1;               /*!< IRQ5-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ6F     :  1;               /*!< IRQ6-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ7F     :  1;               /*!< IRQ7-DS Pin Deep Standby Cancel Flag                                  */
    } DPSIFR0_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DPSIFR1;                         /*!< Deep Standby Interrupt Flag Register 1                                */
    
    struct {
      __IO uint8_t   DIRQ8F     :  1;               /*!< IRQ8-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ9F     :  1;               /*!< IRQ9-DS Pin Deep Standby Cancel Flag                                  */
      __IO uint8_t   DIRQ10F    :  1;               /*!< IRQ10-DS Pin Deep Standby Cancel Flag                                 */
      __IO uint8_t   DIRQ11F    :  1;               /*!< IRQ11-DS Pin Deep Standby Cancel Flag                                 */
      __IO uint8_t   DIRQ12F    :  1;               /*!< IRQ12-DS Pin Deep Standby Cancel Flag                                 */
      __IO uint8_t   DIRQ13F    :  1;               /*!< IRQ13-DS Pin Deep Standby Cancel Flag                                 */
      __IO uint8_t   DIRQ14F    :  1;               /*!< IRQ14-DS Pin Deep Standby Cancel Flag                                 */
      __IO uint8_t   DIRQ15F    :  1;               /*!< IRQ15-DS Pin Deep Standby Cancel Flag                                 */
    } DPSIFR1_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DPSIFR2;                         /*!< Deep Standby Interrupt Flag Register 2                                */
    
    struct {
      __IO uint8_t   DLVD1IF    :  1;               /*!< LVD1 Deep Standby Cancel Flag                                         */
      __IO uint8_t   DLVD2IF    :  1;               /*!< LVD2 Deep Standby Cancel Flag                                         */
      __IO uint8_t   DTRTCIIF   :  1;               /*!< RTC Interval interrupt Deep Standby Cancel Flag                       */
      __IO uint8_t   DRTCAIF    :  1;               /*!< RTC Alarm interrupt Deep Standby Cancel Flag                          */
      __IO uint8_t   DNMIF      :  1;               /*!< NMI Pin Deep Standby Cancel Flag                                      */
    } DPSIFR2_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DPSIFR3;                         /*!< Deep Standby Interrupt Flag Register 3                                */
    
    struct {
      __IO uint8_t   DUSBFSIF   :  1;               /*!< USBFS Suspend/Resume Deep Standby Cancel Flag                         */
      __IO uint8_t   DUSBHSIF   :  1;               /*!< USBHS Suspend/Resume Deep Standby Cancel Flag                         */
      __IO uint8_t   DAGT1IF    :  1;               /*!< AGT1 Underflow Deep Standby Cancel Flag                               */
    } DPSIFR3_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DPSIEGR0;                        /*!< Deep Standby Interrupt Edge Register 0                                */
    
    struct {
      __IO uint8_t   DIRQ0EG    :  1;               /*!< IRQ0-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ1EG    :  1;               /*!< IRQ1-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ2EG    :  1;               /*!< IRQ2-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ3EG    :  1;               /*!< IRQ3-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ4EG    :  1;               /*!< IRQ4-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ5EG    :  1;               /*!< IRQ5-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ6EG    :  1;               /*!< IRQ6-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ7EG    :  1;               /*!< IRQ7-DS Pin Edge Select                                               */
    } DPSIEGR0_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DPSIEGR1;                        /*!< Deep Standby Interrupt Edge Register 1                                */
    
    struct {
      __IO uint8_t   DIRQ8EG    :  1;               /*!< IRQ8-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ9EG    :  1;               /*!< IRQ9-DS Pin Edge Select                                               */
      __IO uint8_t   DIRQ10EG   :  1;               /*!< IRQ10-DS Pin Edge Select                                              */
      __IO uint8_t   DIRQ11EG   :  1;               /*!< IRQ11-DS Pin Edge Select                                              */
      __IO uint8_t   DIRQ12EG   :  1;               /*!< IRQ12-DS Pin Edge Select                                              */
      __IO uint8_t   DIRQ13EG   :  1;               /*!< IRQ13-DS Pin Edge Select                                              */
      __IO uint8_t   DIRQ14EG   :  1;               /*!< IRQ14-DS Pin Edge Select                                              */
      __IO uint8_t   DIRQ15EG   :  1;               /*!< IRQ15-DS Pin Edge Select                                              */
    } DPSIEGR1_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DPSIEGR2;                        /*!< Deep Standby Interrupt Edge Register 2                                */
    
    struct {
      __IO uint8_t   DLVD1IEG   :  1;               /*!< LVD1 Edge Select                                                      */
      __IO uint8_t   DLVD2IEG   :  1;               /*!< LVD2 Edge Select                                                      */
           uint8_t              :  2;
      __IO uint8_t   DNMIEG     :  1;               /*!< NMI Pin Edge Select                                                   */
    } DPSIEGR2_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED24;
  
  union {
    __IO uint8_t   SYOCDCR;                         /*!< System Control OCD Control Register                                */
    
    struct {
      __IO uint8_t   DOCDF      :  1;               /*!< Deep Standby OCD flag                                                 */
           uint8_t              :  6;
      __IO uint8_t   DBGEN      :  1;               /*!< Debugger Enable bit                                                   */
    } SYOCDCR_b;                                    /*!< BitSize                                                               */
  };
  union {
    __IO uint8_t   STCONR;                          /*!< Standby Condition Register                                            */

    struct {
      __IO uint8_t   STCON      :  2;               /*!< Standby Condition Bits                                                */
           uint8_t              :  6;
    } STCONR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   RSTSR0;                          /*!< Reset Status Register 0                                               */
    
    struct {
      __IO uint8_t   PORF       :  1;               /*!< Power-On Reset Detect Flag                                            */
      __IO uint8_t   LVD0RF     :  1;               /*!< Voltage-Monitoring 0 Reset Detect Flag                                */
      __IO uint8_t   LVD1RF     :  1;               /*!< Voltage-Monitoring 1 Reset Detect Flag                                */
      __IO uint8_t   LVD2RF     :  1;               /*!< Voltage-Monitoring 2 Reset Detect Flag                                */
           uint8_t              :  3;
      __IO uint8_t   DPSRSTF    :  1;               /*!< Deep Software Standby Reset Flag                                      */
    } RSTSR0_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   RSTSR2;                          /*!< Reset Status Register 2                                               */
    
    struct {
      __IO uint8_t   CWSF       :  1;               /*!< Cold/Warm Start Determination Flag                                    */
    } RSTSR2_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED26;
  
  union {
    __IO uint8_t   MOMCR;                           /*!< Main Clock Oscillator Mode Oscillation Control Register               */
    
    struct {
           uint8_t              :  4;
      __IO uint8_t   MODRV0     :  2;               /*!< Main Clock Oscillator DriveCapability 0 Switching                     */
      __IO uint8_t   MOSEL      :  1;               /*!< Main Clock Oscillator Switching                                       */
    } MOMCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED27[3];

  union {
    __IO uint8_t   LVCMPCR;                         /*!< Voltage Monitoring Circuit Control Register                           */

    struct {
           uint8_t              :  5;
      __IO uint8_t   LVD1E      :  1;               /*!< Voltage Detection 1 Enable                                            */
      __IO uint8_t   LVD2E      :  1;               /*!< Voltage Detection 2 Enable                                            */
    } LVCMPCR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   LVDLVLR;                         /*!< Voltage Detection Level Select Register                               */

    struct {
      __IO uint8_t   LVD1LVL    :  5;               /*!< Voltage Detection 1 Level Select (Standard voltage during drop
                                                         in voltage)                                                           */
      __IO uint8_t   LVD2LVL    :  3;               /*!< Voltage Detection 2 Level Select (Standard voltage during drop
                                                         in voltage)                                                           */
    } LVDLVLR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED31;

  union {
    __IO uint8_t   LVDnCR0[2];                      /*!< Voltage Monitoring %s Circuit Control Register 0                      */

    struct {
      __IO uint8_t   RIE        :  1;               /*!< Voltage Monitoring Interrupt/Reset Enable                             */
      __IO uint8_t   DFDIS      :  1;               /*!< Voltage Monitoring Digital Filter Disable Mode Select                 */
      __IO uint8_t   CMPE       :  1;               /*!< Voltage Monitoring Circuit Comparison Result Output Enable            */
           uint8_t              :  1;
      __IO uint8_t   FSAMP      :  2;               /*!< Sampling Clock Select                                                 */
      __IO uint8_t   RI         :  1;               /*!< Voltage Monitoring Circuit Mode Select                                */
      __IO uint8_t   RN         :  1;               /*!< Voltage Monitoring Reset Negate Select                                */
    } LVDnCR0_b[2];                                 /*!< BitSize                                                               */
  };

  __I  uint8_t RESERVED33[25 * 4];
  
  union {
    __IO uint8_t   SOSCCR;                          /*!< Sub-clock oscillator control register                                 */
    
    struct {
      __IO uint8_t   SOSTP      :  1;               /*!< Sub-Clock Oscillator Stop                                             */
    } SOSCCR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   SOMCR;                           /*!< Sub Clock Oscillator Mode Control Register                            */
    
    struct {
           uint8_t              :  1;
      __IO uint8_t   SODRV1     :  1;               /*!< Sub Clock Oscillator Drive Capability Switching                       */
    } SOMCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED28[7 * 2];
  
  union {
    __IO uint8_t   LOCOCR;                          /*!< Low-Speed On-Chip Oscillator Control Register                         */
    
    struct {
      __IO uint8_t   LCSTP      :  1;               /*!< LOCO Stop                                                             */
    } LOCOCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED29;
  
  union {
    __IO uint8_t   LOCOUTCR;                        /*!< LOCO User Trimming Control Register                                   */
    
    struct {
      __IO uint8_t   LOCOUTRM   :  8;               /*!< LOCO User Trimming 1000_0000 : -128 1000_0001 : -127 1000_0010
                                                         : -126 . . . 1111_1111 : -1 0000_0000 : Center Code 0000_0001
                                                          : +1 . . . 0111_1101 : +125 0111_1110 : +126 0111_1111 : +127These
                                                          bits are added to original LOCO trimming bits                        */
    } LOCOUTCR_b;                                   /*!< BitSize                                                               */
  };  
  __I  uint8_t RESERVED32a[40];
  
  union {
    __IO uint8_t   VBTICTLR;                        /*!< VBATT Input Control Register                                          */

    struct {
      __IO uint8_t   VCH0INEN   :  1;               /*!< VBATT CH0 Input Enable                                                */
      __IO uint8_t   VCH1INEN   :  1;               /*!< VBATT CH1 Input Enable                                                */
      __IO uint8_t   VCH2INEN   :  1;               /*!< VBATT CH2 Input Enable                                                */
    } VBTICTLR_b;                                   /*!< BitSize                                                               */
  };

  __I  uint8_t RESERVED32b[68];

  union {
    __IO uint8_t   VBTBKRn[512];                    /*!< VBATT Backup Register %s                                              */
    
    struct {
      __IO uint8_t   VBTBKR     :  8;               /*!< VBTBKR is a 512-byte readable/writeable register to store data
                                                         powered by VBATT.The value of this register is retained even
                                                          when VCC is not powered but VBATT is powered.VBTBKR is initialized
                                                          by VBATT selected voltage power-on-reset.                            */
    } VBTBKRn_b[512];                               /*!< BitSize                                                               */
  };
} R_SYSTEM_Type;


/* ================================================================================ */
/* ================                    R_IOPORT0                   ================ */
/* ================================================================================ */


/**
  * @brief Port 0 Control Registers (R_IOPORT0)
  */

typedef struct {                                    /*!< R_IOPORT0 Structure                                                   */
  __IO uint32_t  PCNTR1;                            /*!< Port Control Register 1                                               */
  __I  uint32_t  PCNTR2;                            /*!< Port Control Register 2                                               */
  __O  uint32_t  PCNTR3;                            /*!< Port Control Register 3                                               */
} R_IOPORT0_Type;


/* ================================================================================ */
/* ================                    R_IOPORT1                   ================ */
/* ================================================================================ */


/**
  * @brief Port 1 Control Registers (R_IOPORT1)
  */

typedef struct {                                    /*!< R_IOPORT1 Structure                                                   */
  __IO uint32_t  PCNTR1;                            /*!< Port Control Register 1                                               */
  __I  uint32_t  PCNTR2;                            /*!< Port Control Register 2                                               */
  __O  uint32_t  PCNTR3;                            /*!< Port Control Register 3                                               */
  __IO uint32_t  PCNTR4;                            /*!< Port Control Register 4                                               */
} R_IOPORT1_Type;


/* ================================================================================ */
/* ================                      R_PFS                     ================ */
/* ================================================================================ */


/**
  * @brief Pmn Pin Function Control Register (PmnPFS) (m = 0 to B, n=0 to 15) (R_PFS)
  */

typedef struct {                                    /*!< R_PFS Structure                                                       */
  
  union {
    __IO uint32_t  P000PFS;                         /*!< P00%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P000PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P001PFS;                         /*!< P00%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P001PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P002PFS;                         /*!< P00%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P002PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P003PFS;                         /*!< P00%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P003PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P004PFS;                         /*!< P00%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P004PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P005PFS;                         /*!< P00%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P005PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P006PFS;                         /*!< P00%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P006PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P007PFS;                         /*!< P00%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P007PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P008PFS;                         /*!< P00%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P008PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P009PFS;                         /*!< P00%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P009PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P010PFS;                         /*!< P0%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P010PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P011PFS;                         /*!< P0%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P011PFS_b;                                    /*!< BitSize                                                               */
  };

  __I  uint8_t RESERVED24[2 * 4];				    // Added MEF 08/25/2015 P012 and P013 are not present
  
  union {
    __IO uint32_t  P014PFS;                         /*!< P0%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P014PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P015PFS;                         /*!< P0%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P015PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P100PFS;                         /*!< P10%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P100PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P101PFS;                         /*!< P10%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P101PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P102PFS;                         /*!< P10%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P102PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P103PFS;                         /*!< P10%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P103PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P104PFS;                         /*!< P10%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P104PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P105PFS;                         /*!< P10%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P105PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P106PFS;                         /*!< P10%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P106PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P107PFS;                         /*!< P10%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P107PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P108PFS;                         /*!< P10%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P108PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P109PFS;                         /*!< P10%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P109PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P110PFS;                         /*!< P1%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P110PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P111PFS;                         /*!< P1%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P111PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P112PFS;                         /*!< P1%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P112PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P113PFS;                         /*!< P1%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P113PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P114PFS;                         /*!< P1%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P114PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P115PFS;                         /*!< P1%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P115PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P200PFS;                         /*!< P20%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P200PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P201PFS;                         /*!< P20%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P201PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P202PFS;                         /*!< P20%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P202PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P203PFS;                         /*!< P20%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P203PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P204PFS;                         /*!< P20%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P204PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P205PFS;                         /*!< P20%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P205PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P206PFS;                         /*!< P20%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P206PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P207PFS;                         /*!< P20%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P207PFS_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED1[4 * 4];				    // Added MEF 08/25/2015 P208, 209, 210, 2111 are not present
  
  union {
    __IO uint32_t  P212PFS;                         /*!< P2%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P212PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P213PFS;                         /*!< P2%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P213PFS_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED2[2 * 4];                    // Added MEF 09/02/2015 P214, 215 are not present
  
  union {
    __IO uint32_t  P300PFS;                         /*!< P30%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P300PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P301PFS;                         /*!< P30%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P301PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P302PFS;                         /*!< P30%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P302PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P303PFS;                         /*!< P30%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P303PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P304PFS;                         /*!< P30%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P304PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P305PFS;                         /*!< P30%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P305PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P306PFS;                         /*!< P30%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P306PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P307PFS;                         /*!< P30%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P307PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P308PFS;                         /*!< P30%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P308PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P309PFS;                         /*!< P30%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P309PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P310PFS;                         /*!< P3%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P310PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P311PFS;                         /*!< P3%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P311PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P312PFS;                         /*!< P3%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P312PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P313PFS;                         /*!< P3%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P313PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P314PFS;                         /*!< P3%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P314PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P315PFS;                         /*!< P3%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P315PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P400PFS;                         /*!< P40%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P400PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P401PFS;                         /*!< P40%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P401PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P402PFS;                         /*!< P40%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P402PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P403PFS;                         /*!< P40%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P403PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P404PFS;                         /*!< P40%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P404PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P405PFS;                         /*!< P40%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P405PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P406PFS;                         /*!< P40%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P406PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P407PFS;                         /*!< P40%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P407PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P408PFS;                         /*!< P40%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P408PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P409PFS;                         /*!< P40%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P409PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P410PFS;                         /*!< P4%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P410PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P411PFS;                         /*!< P4%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P411PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P412PFS;                         /*!< P4%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P412PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P413PFS;                         /*!< P4%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P413PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P414PFS;                         /*!< P4%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P414PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P415PFS;                         /*!< P4%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
      __IO uint32_t  EOFR       :  2;               /*!< Event on Falling/Event on Rising                                      */
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P415PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P500PFS;                         /*!< P50%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P500PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P501PFS;                         /*!< P50%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P501PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P502PFS;                         /*!< P50%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P502PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P503PFS;                         /*!< P50%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P503PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P504PFS;                         /*!< P50%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P504PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P505PFS;                         /*!< P50%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P505PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P506PFS;                         /*!< P50%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P506PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P507PFS;                         /*!< P50%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P507PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P508PFS;                         /*!< P50%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P508PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P509PFS;                         /*!< P50%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P509PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P510PFS;                         /*!< P5%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P510PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P511PFS;                         /*!< P5%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P511PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P512PFS;                         /*!< P5%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P512PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P513PFS;                         /*!< P5%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P513PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P514PFS;                         /*!< P5%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P514PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P515PFS;                         /*!< P5%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P515PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P600PFS;                         /*!< P60%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P600PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P601PFS;                         /*!< P60%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P601PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P602PFS;                         /*!< P60%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P602PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P603PFS;                         /*!< P60%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P603PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P604PFS;                         /*!< P60%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P604PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P605PFS;                         /*!< P60%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P605PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P606PFS;                         /*!< P60%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P606PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P607PFS;                         /*!< P60%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P607PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P608PFS;                         /*!< P60%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P608PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P609PFS;                         /*!< P60%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P609PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P610PFS;                         /*!< P6%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P610PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P611PFS;                         /*!< P6%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P611PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P612PFS;                         /*!< P6%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P612PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P613PFS;                         /*!< P6%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P613PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P614PFS;                         /*!< P6%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P614PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P615PFS;                         /*!< P6%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P615PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P700PFS;                         /*!< P70%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P700PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P701PFS;                         /*!< P70%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P701PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P702PFS;                         /*!< P70%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P702PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P703PFS;                         /*!< P70%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P703PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P704PFS;                         /*!< P70%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P704PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P705PFS;                         /*!< P70%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P705PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P706PFS;                         /*!< P70%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P706PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P707PFS;                         /*!< P70%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P707PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P708PFS;                         /*!< P70%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P708PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P709PFS;                         /*!< P70%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P709PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P710PFS;                         /*!< P7%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P710PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P711PFS;                         /*!< P7%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P711PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P712PFS;                         /*!< P7%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P712PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P713PFS;                         /*!< P7%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P713PFS_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED3[2 * 4];
  
  union {
    __IO uint32_t  P800PFS;                         /*!< P80%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P800PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P801PFS;                         /*!< P80%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P801PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P802PFS;                         /*!< P80%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P802PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P803PFS;                         /*!< P80%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P803PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P804PFS;                         /*!< P80%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P804PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P805PFS;                         /*!< P80%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P805PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P806PFS;                         /*!< P80%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P806PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P807PFS;                         /*!< P80%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P807PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P808PFS;                         /*!< P80%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P808PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P809PFS;                         /*!< P80%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P809PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P810PFS;                         /*!< P8%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P810PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P811PFS;                         /*!< P8%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P811PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P812PFS;                         /*!< P8%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P812PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P813PFS;                         /*!< P8%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P813PFS_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED4[2 * 4];
  
  union {
    __IO uint32_t  P900PFS;                         /*!< P90%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P900PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P901PFS;                         /*!< P90%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P901PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P902PFS;                         /*!< P90%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P902PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P903PFS;                         /*!< P90%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P903PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P904PFS;                         /*!< P90%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P904PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P905PFS;                         /*!< P90%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P905PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P906PFS;                         /*!< P90%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P906PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P907PFS;                         /*!< P90%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P907PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P908PFS;                         /*!< P90%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P908PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P909PFS;                         /*!< P90%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P909PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P910PFS;                         /*!< P9%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P910PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P911PFS;                         /*!< P9%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P911PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P912PFS;                         /*!< P9%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P912PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P913PFS;                         /*!< P9%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P913PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P914PFS;                         /*!< P9%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P914PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  P915PFS;                         /*!< P9%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } P915PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA00PFS;                         /*!< PA0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA00PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA01PFS;                         /*!< PA0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA01PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA02PFS;                         /*!< PA0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA02PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA03PFS;                         /*!< PA0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA03PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA04PFS;                         /*!< PA0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA04PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA05PFS;                         /*!< PA0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA05PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA06PFS;                         /*!< PA0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA06PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA07PFS;                         /*!< PA0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA07PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA08PFS;                         /*!< PA0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA08PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA09PFS;                         /*!< PA0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA09PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA10PFS;                         /*!< PA%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA10PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA11PFS;                         /*!< PA%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA11PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA12PFS;                         /*!< PA%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA12PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA13PFS;                         /*!< PA%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA13PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA14PFS;                         /*!< PA%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA14PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PA15PFS;                         /*!< PA%s Pin Function Control Register                                    */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PA15PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PB00PFS;                         /*!< PB0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB00PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PB01PFS;                         /*!< PB0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB01PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PB02PFS;                         /*!< PB0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB02PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PB03PFS;                         /*!< PB0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB03PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PB04PFS;                         /*!< PB0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB04PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PB05PFS;                         /*!< PB0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB05PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PB06PFS;                         /*!< PB0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB06PFS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  PB07PFS;                         /*!< PB0%s Pin Function Control Register                                   */
    
    struct {
      __IO uint32_t  PODR       :  1;               /*!< Port Output Data                                                      */
      __I  uint32_t  PIDR       :  1;               /*!< Port Input Data                                                       */
      __IO uint32_t  PDR        :  1;               /*!< Port Direction                                                        */
           uint32_t             :  1;
      __IO uint32_t  PCR        :  1;               /*!< Pull-up Control                                                       */
           uint32_t             :  1;
      __IO uint32_t  NCODR      :  1;               /*!< N-Channel Open Drain Control                                          */
      __IO uint32_t  PCODR      :  1;               /*!< P-Channel Open Drain Control                                          */
           uint32_t             :  2;
      __IO uint32_t  DSCR       :  2;               /*!< Drive Strength Control Register                                       */
           uint32_t             :  2;
      __IO uint32_t  ISEL       :  1;               /*!< IRQ input enable                                                      */
      __IO uint32_t  ASEL       :  1;               /*!< Analog Input enable                                                   */
      __IO uint32_t  PMR        :  1;               /*!< Port Mode Control                                                     */
           uint32_t             :  7;
      __IO uint32_t  PSEL       :  5;               /*!< Port Function SelectThese bits select the peripheral function.
                                                         For individual pin functions, see the MPC table                       */
    } PB07PFS_b;                                    /*!< BitSize                                                               */
  };
} R_PFS_Type;


/* ================================================================================ */
/* ================                     R_PMISC                    ================ */
/* ================================================================================ */


/**
  * @brief Miscellaneous Port Control Register (R_PMISC)
  */

typedef struct {                                    /*!< R_PMISC Structure                                                     */
  
  union {
    __IO uint8_t   PFENET;                          /*!< Ethernet Control Register                                             */
    
    struct {
           uint8_t              :  4;
      __IO uint8_t   PHYMODE0   :  1;               /*!< Ethernet Mode Setting ch0                                             */
      __IO uint8_t   PHYMODE1   :  1;               /*!< Ethernet Mode Setting ch1                                             */
    } PFENET_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED[2];   // Padding changed from uint16_t

  union {
    __IO uint8_t   PWPR;                            /*!< Write-Protect Register                                                */
    
    struct {
           uint8_t              :  6;
      __IO uint8_t   PFSWE      :  1;               /*!< PFS Register Write Enable                                             */
      __IO uint8_t   BOWI       :  1;               /*!< PFSWE Bit Write Disable                                               */
    } PWPR_b;                                       /*!< BitSize                                                               */
  };
} R_PMISC_Type;


/* ================================================================================ */
/* ================                      R_ELC                     ================ */
/* ================================================================================ */


/**
  * @brief Event Link Controller  (R_ELC)
  */

typedef struct {                                    /*!< R_ELC Structure                                                       */
  
    union {
      __IO uint8_t   ELCR;                          /*!< Event Link Controller Register                                        */
      
      struct {
             uint8_t            :  7;
        __IO uint8_t   ELCON    :  1;               /*!< All Event Link Enable                                                 */
      } ELCR_b;                                     /*!< BitSize                                                               */
    };

    __I  uint8_t  RESERVED;
  union {
    R_ELC_ELSEGRnRC0_Type ELSEGRnRC0[2];            /*!< Event Link Software Event Generation Register %s Register Cluster
                                                         0                                                                     */

  };
  __I  uint8_t RESERVED1[5 * 2];
  R_ELC_ELSRnRC0_Type ELSRnRC0[19];                 /*!< Event Link Setting Register %s Register Cluster 0                     */
} R_ELC_Type;


/* ================================================================================ */
/* ================                     R_POEG                     ================ */
/* ================================================================================ */


/**
  * @brief Port Output Enable Module for GPT (R_POEG)
  */

typedef struct {                                    /*!< R_POEG Structure                                                      */
  
  union {
    __IO uint32_t  POEGGA;                          /*!< POEG Group %s Setting Register                                        */
    
    struct {
      __IO uint32_t  PIDF       :  1;               /*!< Port Input Detection Flag                                             */
      __IO uint32_t  IOCF       :  1;               /*!< Real Time Overcurrent Detection Flag                                  */
      __IO uint32_t  OSTPF      :  1;               /*!< Oscillation Stop Detection Flag                                       */
      __IO uint32_t  SSF        :  1;               /*!< Software Stop Flag                                                    */
      __IO uint32_t  PIDE       :  1;               /*!< Port Input Detection EnableNote: Can be modified only once after
                                                         a reset.                                                              */
      __IO uint32_t  IOCE       :  1;               /*!< Real Time Overcurrent EnableNote: Can be modified only once
                                                         after a reset.                                                        */
      __IO uint32_t  OSTPE      :  1;               /*!< Oscillation Stop Detection EnableNote: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  1;
      __IO uint32_t  CDRE0      :  1;               /*!< Comparator Disable Request Enable 0Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE1      :  1;               /*!< Comparator Disable Request Enable 1Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE2      :  1;               /*!< Comparator Disable Request Enable 2Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE3      :  1;               /*!< Comparator Disable Request Enable 3Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE4      :  1;               /*!< Comparator Disable Request Enable 4Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE5      :  1;               /*!< Comparator Disable Request Enable 5Note: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  2;
      __I  uint32_t  ST         :  1;               /*!< GTETRG Input Status Flag                                              */
           uint32_t             : 11;
      __IO uint32_t  INV        :  1;               /*!< GTETRG Input Reverse                                                  */
      __IO uint32_t  NFEN       :  1;               /*!< Noise Filter Enable                                                   */
      __IO uint32_t  NFCS       :  2;               /*!< Noise Filter Clock Select                                             */
    } POEGGA_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED[63 * 4];
  
  union {
    __IO uint32_t  POEGGB;                          /*!< POEG Group %s Setting Register                                        */
    
    struct {
      __IO uint32_t  PIDF       :  1;               /*!< Port Input Detection Flag                                             */
      __IO uint32_t  IOCF       :  1;               /*!< Real Time Overcurrent Detection Flag                                  */
      __IO uint32_t  OSTPF      :  1;               /*!< Oscillation Stop Detection Flag                                       */
      __IO uint32_t  SSF        :  1;               /*!< Software Stop Flag                                                    */
      __IO uint32_t  PIDE       :  1;               /*!< Port Input Detection EnableNote: Can be modified only once after
                                                         a reset.                                                              */
      __IO uint32_t  IOCE       :  1;               /*!< Real Time Overcurrent EnableNote: Can be modified only once
                                                         after a reset.                                                        */
      __IO uint32_t  OSTPE      :  1;               /*!< Oscillation Stop Detection EnableNote: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  1;
      __IO uint32_t  CDRE0      :  1;               /*!< Comparator Disable Request Enable 0Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE1      :  1;               /*!< Comparator Disable Request Enable 1Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE2      :  1;               /*!< Comparator Disable Request Enable 2Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE3      :  1;               /*!< Comparator Disable Request Enable 3Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE4      :  1;               /*!< Comparator Disable Request Enable 4Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE5      :  1;               /*!< Comparator Disable Request Enable 5Note: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  2;
      __I  uint32_t  ST         :  1;               /*!< GTETRG Input Status Flag                                              */
           uint32_t             : 11;
      __IO uint32_t  INV        :  1;               /*!< GTETRG Input Reverse                                                  */
      __IO uint32_t  NFEN       :  1;               /*!< Noise Filter Enable                                                   */
      __IO uint32_t  NFCS       :  2;               /*!< Noise Filter Clock Select                                             */
    } POEGGB_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED1[63 * 4];
  
  union {
    __IO uint32_t  POEGGC;                          /*!< POEG Group %s Setting Register                                        */
    
    struct {
      __IO uint32_t  PIDF       :  1;               /*!< Port Input Detection Flag                                             */
      __IO uint32_t  IOCF       :  1;               /*!< Real Time Overcurrent Detection Flag                                  */
      __IO uint32_t  OSTPF      :  1;               /*!< Oscillation Stop Detection Flag                                       */
      __IO uint32_t  SSF        :  1;               /*!< Software Stop Flag                                                    */
      __IO uint32_t  PIDE       :  1;               /*!< Port Input Detection EnableNote: Can be modified only once after
                                                         a reset.                                                              */
      __IO uint32_t  IOCE       :  1;               /*!< Real Time Overcurrent EnableNote: Can be modified only once
                                                         after a reset.                                                        */
      __IO uint32_t  OSTPE      :  1;               /*!< Oscillation Stop Detection EnableNote: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  1;
      __IO uint32_t  CDRE0      :  1;               /*!< Comparator Disable Request Enable 0Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE1      :  1;               /*!< Comparator Disable Request Enable 1Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE2      :  1;               /*!< Comparator Disable Request Enable 2Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE3      :  1;               /*!< Comparator Disable Request Enable 3Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE4      :  1;               /*!< Comparator Disable Request Enable 4Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE5      :  1;               /*!< Comparator Disable Request Enable 5Note: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  2;
      __I  uint32_t  ST         :  1;               /*!< GTETRG Input Status Flag                                              */
           uint32_t             : 11;
      __IO uint32_t  INV        :  1;               /*!< GTETRG Input Reverse                                                  */
      __IO uint32_t  NFEN       :  1;               /*!< Noise Filter Enable                                                   */
      __IO uint32_t  NFCS       :  2;               /*!< Noise Filter Clock Select                                             */
    } POEGGC_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED2[63 * 4];
  
  union {
    __IO uint32_t  POEGGD;                          /*!< POEG Group %s Setting Register                                        */
    
    struct {
      __IO uint32_t  PIDF       :  1;               /*!< Port Input Detection Flag                                             */
      __IO uint32_t  IOCF       :  1;               /*!< Real Time Overcurrent Detection Flag                                  */
      __IO uint32_t  OSTPF      :  1;               /*!< Oscillation Stop Detection Flag                                       */
      __IO uint32_t  SSF        :  1;               /*!< Software Stop Flag                                                    */
      __IO uint32_t  PIDE       :  1;               /*!< Port Input Detection EnableNote: Can be modified only once after
                                                         a reset.                                                              */
      __IO uint32_t  IOCE       :  1;               /*!< Real Time Overcurrent EnableNote: Can be modified only once
                                                         after a reset.                                                        */
      __IO uint32_t  OSTPE      :  1;               /*!< Oscillation Stop Detection EnableNote: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  1;
      __IO uint32_t  CDRE0      :  1;               /*!< Comparator Disable Request Enable 0Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE1      :  1;               /*!< Comparator Disable Request Enable 1Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE2      :  1;               /*!< Comparator Disable Request Enable 2Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE3      :  1;               /*!< Comparator Disable Request Enable 3Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE4      :  1;               /*!< Comparator Disable Request Enable 4Note: Can be modified only
                                                         once after a reset.                                                   */
      __IO uint32_t  CDRE5      :  1;               /*!< Comparator Disable Request Enable 5Note: Can be modified only
                                                         once after a reset.                                                   */
           uint32_t             :  2;
      __I  uint32_t  ST         :  1;               /*!< GTETRG Input Status Flag                                              */
           uint32_t             : 11;
      __IO uint32_t  INV        :  1;               /*!< GTETRG Input Reverse                                                  */
      __IO uint32_t  NFEN       :  1;               /*!< Noise Filter Enable                                                   */
      __IO uint32_t  NFCS       :  2;               /*!< Noise Filter Clock Select                                             */
    } POEGGD_b;                                     /*!< BitSize                                                               */
  };
} R_POEG_Type;


/* ================================================================================ */
/* ================                      R_RTC                     ================ */
/* ================================================================================ */


/**
  * @brief Realtime Clock (R_RTC)
  */

typedef struct {                                    /*!< R_RTC Structure                                                       */
  
  union {
    __I  uint8_t   R64CNT;                          /*!< 64-Hz Counter                                                         */
    
    struct {
      __I  uint8_t   F64HZ      :  1;               /*!< 64Hz                                                                  */
      __I  uint8_t   F32HZ      :  1;               /*!< 32Hz                                                                  */
      __I  uint8_t   F16HZ      :  1;               /*!< 16Hz                                                                  */
      __I  uint8_t   F8HZ       :  1;               /*!< 8Hz                                                                   */
      __I  uint8_t   F4HZ       :  1;               /*!< 4Hz                                                                   */
      __I  uint8_t   F2HZ       :  1;               /*!< 2Hz                                                                   */
      __I  uint8_t   F1HZ       :  1;               /*!< 1Hz                                                                   */
    } R64CNT_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED;
  
  union {
    union {
      __IO uint8_t   BCNT0;                         /*!< Binary Counter 0                                                      */
      
      struct {
        __IO uint8_t   BCNT0    :  8;               /*!< The BCNT0 counter is a readable/writeable 32-bit binary counter
                                                         b7 to b0.                                                             */
      } BCNT0_b;                                    /*!< BitSize                                                               */
    };
    
    union {
      __IO uint8_t   RSECCNT;                       /*!< Second Counter                                                        */
      
      struct {
        __IO uint8_t   SEC1     :  4;               /*!< 1-Second CountCounts from 0 to 9 every second. When a carry
                                                         is generated, 1 is added to the tens place.                           */
        __IO uint8_t   SEC10    :  3;               /*!< 10-Second CountCounts from 0 to 5 for 60-second counting.             */
      } RSECCNT_b;                                  /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED1;
  
  union {
    union {
      __IO uint8_t   BCNT1;                         /*!< Binary Counter 1                                                      */
      
      struct {
        __IO uint8_t   BCNT1    :  8;               /*!< The BCNT1 counter is a readable/writeable 32-bit binary counter
                                                         b15 to b8.                                                            */
      } BCNT1_b;                                    /*!< BitSize                                                               */
    };
    
    union {
      __IO uint8_t   RMINCNT;                       /*!< Minute Counter                                                        */
      
      struct {
        __IO uint8_t   MIN1     :  4;               /*!< 1-Minute CountCounts from 0 to 9 every minute. When a carry
                                                         is generated, 1 is added to the tens place.                           */
        __IO uint8_t   MIN10    :  3;               /*!< 10-Minute CountCounts from 0 to 5 for 60-minute counting.             */
      } RMINCNT_b;                                  /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED2;
  
  union {
    union {
      __IO uint8_t   BCNT2;                         /*!< Binary Counter 2                                                      */
      
      struct {
        __IO uint8_t   BCNT2    :  8;               /*!< The BCNT2 counter is a readable/writeable 32-bit binary counter
                                                         b23 to b16.                                                           */
      } BCNT2_b;                                    /*!< BitSize                                                               */
    };
    
    union {
      __IO uint8_t   RHRCNT;                        /*!< Hour Counter                                                          */
      
      struct {
        __IO uint8_t   HR1      :  4;               /*!< 1-Hour CountCounts from 0 to 9 once per hour. When a carry is
                                                         generated, 1 is added to the tens place.                              */
        __IO uint8_t   HR10     :  2;               /*!< 10-Hour CountCounts from 0 to 2 once per carry from the ones
                                                         place.                                                                */
        __IO uint8_t   PM       :  1;               /*!< Time Counter Setting for a.m./p.m.                                    */
      } RHRCNT_b;                                   /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED3;
  
  union {
    union {
      __IO uint8_t   BCNT3;                         /*!< Binary Counter 3                                                      */
      
      struct {
        __IO uint8_t   BCNT3    :  8;               /*!< The BCNT3 counter is a readable/writeable 32-bit binary counter
                                                         b31 to b24.                                                           */
      } BCNT3_b;                                    /*!< BitSize                                                               */
    };
    
    union {
      __IO uint8_t   RWKCNT;                        /*!< Day-of-Week Counter                                                   */
      
      struct {
        __IO uint8_t   DAYW     :  3;               /*!< Day-of-Week Counting                                                  */
      } RWKCNT_b;                                   /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED4;
  
  union {
    __IO uint8_t   RDAYCNT;                         /*!< Date Counter                                                          */
    
    struct {
      __IO uint8_t   DATE1      :  4;               /*!< 1-Day CountCounts from 0 to 9 once per day. When a carry is
                                                         generated, 1 is added to the tens place.                              */
      __IO uint8_t   DATE10     :  2;               /*!< 10-Day CountCounts from 0 to 3 once per carry from the ones
                                                         place.                                                                */
    } RDAYCNT_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED5;
  
  union {
    __IO uint8_t   RMONCNT;                         /*!< Month Counter                                                         */
    
    struct {
      __IO uint8_t   MON1       :  4;               /*!< 1-Month CountCounts from 0 to 9 once per month. When a carry
                                                         is generated, 1 is added to the tens place.                           */
      __IO uint8_t   MON10      :  1;               /*!< 10-Month CountCounts from 0 to 1 once per carry from the ones
                                                         place.                                                                */
    } RMONCNT_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED6;
  
  union {
    __IO uint16_t  RYRCNT;                          /*!< Year Counter                                                          */
    
    struct {
      __IO uint16_t  YR1        :  4;               /*!< 1-Year CountCounts from 0 to 9 once per year. When a carry is
                                                         generated, 1 is added to the tens place.                              */
      __IO uint16_t  YR10       :  4;               /*!< 10-Year CountCounts from 0 to 9 once per carry from ones place.
                                                         When a carry is generated in the tens place, 1 is added to the
                                                          hundreds place.                                                      */
    } RYRCNT_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    union {
      __IO uint8_t   BCNT0AR;                       /*!< Binary Counter 0 Alarm Register                                       */
      
      struct {
        __IO uint8_t   BCNT0AR  :  8;               /*!< he BCNT0AR counter is a readable/writeable alarm register corresponding
                                                         to 32-bit binary counter b7 to b0.                                    */
      } BCNT0AR_b;                                  /*!< BitSize                                                               */
    };
    
    union {
      __IO uint8_t   RSECAR;                        /*!< Second Alarm Register                                                 */
      
      struct {
        __O  uint8_t   SEC1     :  4;               /*!< 1-SecondValue for the ones place of seconds                           */
        __IO uint8_t   SEC10    :  3;               /*!< 10-SecondsValue for the tens place of seconds                         */
        __IO uint8_t   ENB      :  1;               /*!< Compare enable                                                        */
      } RSECAR_b;                                   /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED7;
  
  union {
    union {
      __IO uint8_t   BCNT1AR;                       /*!< Binary Counter 1 Alarm Register                                       */
      
      struct {
        __IO uint8_t   BCNT1AR  :  8;               /*!< he BCNT1AR counter is a readable/writeable alarm register corresponding
                                                         to 32-bit binary counter b15 to b8.                                   */
      } BCNT1AR_b;                                  /*!< BitSize                                                               */
    };
    
    union {
      __IO uint8_t   RMINAR;                        /*!< Minute Alarm Register                                                 */
      
      struct {
        __IO uint8_t   MIN1     :  4;               /*!< 1-Minute CountValue for the ones place of minutes                     */
        __IO uint8_t   MIN10    :  3;               /*!< 10-Minute CountValue for the tens place of minutes                    */
        __IO uint8_t   ENB      :  1;               /*!< Compare enable                                                        */
      } RMINAR_b;                                   /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED8;
  
  union {
    union {
      __IO uint8_t   BCNT2AR;                       /*!< Binary Counter 2 Alarm Register                                       */
      
      struct {
        __IO uint8_t   BCNT2AR  :  8;               /*!< The BCNT2AR counter is a readable/writeable 32-bit binary counter
                                                         b23 to b16.                                                           */
      } BCNT2AR_b;                                  /*!< BitSize                                                               */
    };
    
    union {
      __IO uint8_t   RHRAR;                         /*!< Hour Alarm Register                                                   */
      
      struct {
        __IO uint8_t   HR1      :  4;               /*!< 1-Hour CountValue for the ones place of hours                         */
        __IO uint8_t   HR10     :  2;               /*!< 10-Hour CountValue for the tens place of hours                        */
        __IO uint8_t   PM       :  1;               /*!< Time Counter Setting for a.m./p.m.                                    */
        __IO uint8_t   ENB      :  1;               /*!< Compare enable                                                        */
      } RHRAR_b;                                    /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED9;
  
  union {
    union {
      __IO uint8_t   BCNT3AR;                       /*!< Binary Counter 3 Alarm Register                                       */
      
      struct {
        __IO uint8_t   BCNT3AR  :  8;               /*!< The BCNT3AR counter is a readable/writeable 32-bit binary counter
                                                         b31 to b24.                                                           */
      } BCNT3AR_b;                                  /*!< BitSize                                                               */
    };
    
    union {
      __IO uint8_t   RWKAR;                         /*!< Day-of-Week Alarm Register                                            */
      
      struct {
        __IO uint8_t   DAYW     :  3;               /*!< Day-of-Week Counting                                                  */
             uint8_t            :  4;
        __IO uint8_t   ENB      :  1;               /*!< Compare enable                                                        */
      } RWKAR_b;                                    /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED10;
  
  union {
    union {
      __IO uint8_t   BCNT0AER;                      /*!< Binary Counter 0 Alarm Enable Register                                */
      
      struct {
        __IO uint8_t   ENB      :  8;               /*!< The BCNT0AER register is a readable/writeable register for setting
                                                         the alarm enable corresponding to 32-bit binary counter b7 to
                                                          b0.                                                                  */
      } BCNT0AER_b;                                 /*!< BitSize                                                               */
    };
    
    union {
      __IO uint8_t   RDAYAR;                        /*!< Date Alarm Register                                                   */
      
      struct {
        __IO uint8_t   DATE1    :  4;               /*!< 1 DayValue for the ones place of days                                 */
        __IO uint8_t   DATE10   :  2;               /*!< 10 DaysValue for the tens place of days                               */
             uint8_t            :  1;
        __IO uint8_t   ENB      :  1;               /*!< Compare enable                                                        */
      } RDAYAR_b;                                   /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED11;
  
  union {
    union {
      __IO uint8_t   BCNT1AER;                      /*!< Binary Counter 1 Alarm Enable Register                                */
      
      struct {
        __IO uint8_t   ENB      :  8;               /*!< The BCNT1AER register is a readable/writeable register for setting
                                                         the alarm enable corresponding to 32-bit binary counter b15
                                                          to b8.                                                               */
      } BCNT1AER_b;                                 /*!< BitSize                                                               */
    };
    
    union {
      __IO uint8_t   RMONAR;                        /*!< Month Alarm Register                                                  */
      
      struct {
        __IO uint8_t   MON1     :  4;               /*!< 1 MonthValue for the ones place of months                             */
        __IO uint8_t   MON10    :  1;               /*!< 10 MonthsValue for the tens place of months                           */
             uint8_t            :  2;
        __IO uint8_t   ENB      :  1;               /*!< Compare enable                                                        */
      } RMONAR_b;                                   /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED12;
  
  union {
    union {
      __IO uint16_t  BCNT2AER;                      /*!< Binary Counter 2 Alarm Enable Register                                */
      
      struct {
        __IO uint16_t  ENB      :  8;               /*!< The BCNT2AER register is a readable/writeable register for setting
                                                         the alarm enable corresponding to 32-bit binary counter b23
                                                          to b16.                                                              */
      } BCNT2AER_b;                                 /*!< BitSize                                                               */
    };
    
    union {
      __IO uint16_t  RYRAR;                         /*!< Year Alarm Register                                                   */
      
      struct {
        __IO uint16_t  YR1      :  4;               /*!< 1 YearValue for the ones place of years                               */
        __IO uint16_t  YR10     :  4;               /*!< 10 YearsValue for the tens place of years                             */
      } RYRAR_b;                                    /*!< BitSize                                                               */
    };
  };
  
  union {
    union {
      __IO uint8_t   BCNT3AER;                      /*!< Binary Counter 3 Alarm Enable Register                                */
      
      struct {
        __IO uint8_t   ENB      :  8;               /*!< The BCNT3AER register is a readable/writeable register for setting
                                                         the alarm enable corresponding to 32-bit binary counter b31
                                                          to b24.                                                              */
      } BCNT3AER_b;                                 /*!< BitSize                                                               */
    };
    
    union {
      __IO uint8_t   RYRAREN;                       /*!< Year Alarm Enable Register                                            */
      
      struct {
             uint8_t            :  7;
        __IO uint8_t   ENB      :  1;               /*!< Compare enable                                                        */
      } RYRAREN_b;                                  /*!< BitSize                                                               */
    };
  };
  __I  uint8_t   RESERVED13[3];
  
  union {
    __IO uint8_t   RCR1;                            /*!< RTC Control Register 1                                                */
    
    struct {
      __IO uint8_t   AIE        :  1;               /*!< Alarm Interrupt Enable                                                */
      __IO uint8_t   CIE        :  1;               /*!< Carry Interrupt Enable                                                */
      __IO uint8_t   PIE        :  1;               /*!< Periodic Interrupt Enable                                             */
      __IO uint8_t   RTCOS      :  1;               /*!< RTCOUT Output Select                                                  */
      __IO uint8_t   PES        :  4;               /*!< Periodic Interrupt Select                                             */
    } RCR1_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED14;
  
  union {
    __IO uint8_t   RCR2;                            /*!< RTC Control Register 2                                                */
    
    struct {
      __IO uint8_t   START      :  1;               /*!< Start                                                                 */
      __IO uint8_t   RESET      :  1;               /*!< RTC Software Reset                                                    */
      __IO uint8_t   ADJ30      :  1;               /*!< 30-Second Adjustment                                                  */
      __IO uint8_t   RTCOE      :  1;               /*!< RTCOUT Output Enable                                                  */
      __IO uint8_t   AADJE      :  1;               /*!< Automatic Adjustment Enable (When the LOCO clock is selected,
                                                         the setting of this bit is disabled.)                                 */
      __IO uint8_t   AADJP      :  1;               /*!< Automatic Adjustment Period Select (When the LOCO clock is selected,
                                                         the setting of this bit is disabled.)                                 */
      __IO uint8_t   HR24       :  1;               /*!< Hours Mode                                                            */
      __IO uint8_t   CNTMD      :  1;               /*!< Count Mode Select                                                     */
    } RCR2_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED15[3];
  
  union {
    __IO uint8_t   RCR4;                            /*!< RTC Control Register 4                                                */
    
    struct {
      __IO uint8_t   RCKSEL     :  1;               /*!< Count Source Select                                                   */
    } RCR4_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED16;
  
  union {
    __IO uint16_t  RFRH;                            /*!< Frequency Register H                                                  */
    
    struct {
      __IO uint16_t  RFC16      :  1;               /*!< Frequency Comparison Value (b16)To generate the operating clock
                                                         from the LOCOclock, this bit sets the comparison value of the
                                                          128-Hz clock cycle.                                                  */
    } RFRH_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  RFRL;                            /*!< Frequency Register L                                                  */
    
    struct {
      __IO uint16_t  RFC        : 16;               /*!< Frequency Comparison Value(b15-b0)To generate the operating
                                                         clock from the main clock, this bit sets the comparison value
                                                          of the 128-Hz clock cycle.                                           */
    } RFRL_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   RADJ;                            /*!< Time Error Adjustment Register                                        */
    
    struct {
      __IO uint8_t   ADJ        :  6;               /*!< Adjustment ValueThese bits specify the adjustment value from
                                                         the prescaler.                                                        */
      __IO uint8_t   PMADJ      :  2;               /*!< Plus-Minus                                                            */
    } RADJ_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED17[17];
  R_RTC_RTCCRnRC0_Type RTCCRnRC0[3];                /*!< Time Capture Control Register %s Register Cluster 0                   */
  __I  uint8_t RESERVED18[3 * 4];
  R_RTC_CnRC0_Type CnRC0[3];                        /*!< Capture %s Register Cluster 0                                         */
} R_RTC_Type;


/* ================================================================================ */
/* ================                      R_WDT                     ================ */
/* ================================================================================ */


/**
  * @brief Watchdog Timer  (R_WDT)
  */

typedef struct {                                    /*!< R_WDT Structure                                                       */
  
  union {
    __IO uint8_t   WDTRR;                           /*!< WDT Refresh Register                                                  */
    
    struct {
      __IO uint8_t   WDTRR      :  8;               /*!< WDTRR is an 8-bit register that refreshes the down-counter of
                                                         the WDT.                                                              */
    } WDTRR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED;
  
  union {
    __IO uint16_t  WDTCR;                           /*!< WDT Control Register                                                  */
    
    struct {
      __IO uint16_t  TOPS       :  2;               /*!< Timeout Period Selection                                              */
           uint16_t             :  2;
      __IO uint16_t  CKS        :  4;               /*!< Clock Division Ratio Selection                                        */
      __IO uint16_t  RPES       :  2;               /*!< Window End Position Selection                                         */
           uint16_t             :  2;
      __IO uint16_t  RPSS       :  2;               /*!< Window Start Position Selection                                       */
    } WDTCR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  WDTSR;                           /*!< WDT Status Register                                                   */
    
    struct {
      __I  uint16_t  CNTVAL     : 14;               /*!< Down-Counter ValueValue counted by the down-counter                   */
      __IO uint16_t  UNDFF      :  1;               /*!< Underflow Flag                                                        */
      __IO uint16_t  REFEF      :  1;               /*!< Refresh Error Flag                                                    */
    } WDTSR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   WDTRCR;                          /*!< WDT Reset Control Register                                            */
    
    struct {
           uint8_t              :  7;
      __IO uint8_t   RSTIRQS    :  1;               /*!< Reset Interrupt Request Selection                                     */
    } WDTRCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED1;
  
  union {
    __IO uint8_t   WDTCSTPR;                        /*!< WDT Count Stop Control Register                                       */
    
    struct {
           uint8_t              :  7;
      __IO uint8_t   SLCSTP     :  1;               /*!< Sleep-Mode Count Stop Control                                         */
    } WDTCSTPR_b;                                   /*!< BitSize                                                               */
  };
} R_WDT_Type;


/* ================================================================================ */
/* ================                     R_IWDT                     ================ */
/* ================================================================================ */


/**
  * @brief Independent Watchdog Timer (R_IWDT)
  */

typedef struct {                                    /*!< R_IWDT Structure                                                      */
  
  union {
    __IO uint8_t   IWDTRR;                          /*!< IWDT Refresh Register                                                 */
    
    struct {
      __IO uint8_t   IWDTRR     :  8;               /*!< The counter is refreshed by writing 0x00 and then writing 0xFF
                                                         to this register.                                                     */
    } IWDTRR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED[3];
  
  union {
    __IO uint16_t  IWDTSR;                          /*!< IWDT Status Register                                                  */
    
    struct {
      __I  uint16_t  CNTVAL     : 14;               /*!< Counter ValueValue counted by the counter                             */
      __IO uint16_t  UNDFF      :  1;               /*!< Underflow Flag                                                        */
      __IO uint16_t  REFEF      :  1;               /*!< Refresh Error Flag                                                    */
    } IWDTSR_b;                                     /*!< BitSize                                                               */
  };
} R_IWDT_Type;


/* ================================================================================ */
/* ================                      R_CAC                     ================ */
/* ================================================================================ */


/**
  * @brief Clock Frequency Accuracy Measurement Circuit  (R_CAC)
  */

typedef struct {                                    /*!< R_CAC Structure                                                       */
  
  union {
    __IO uint8_t   CACR0;                           /*!< CAC Control Register 0                                                */
    
    struct {
      __IO uint8_t   CFME       :  1;               /*!< Clock Frequency Measurement Enable.                                   */
    } CACR0_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   CACR1;                           /*!< CAC Control Register 1                                                */
    
    struct {
      __IO uint8_t   CACREFE    :  1;               /*!< CACREF Pin Input Enable                                               */
      __IO uint8_t   FMCS       :  3;               /*!< Frequency Measurement Output Clock Select                             */
      __IO uint8_t   TCSS       :  2;               /*!< Timer Count Clock Source Select                                       */
      __IO uint8_t   EDGES      :  2;               /*!< Valid Edge Select                                                     */
    } CACR1_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   CACR2;                           /*!< CAC Control Register 2                                                */
    
    struct {
      __IO uint8_t   RPS        :  1;               /*!< Reference Signal Select                                               */
      __IO uint8_t   RSCS       :  3;               /*!< Reference Signal Generation Output Clock Select                       */
      __IO uint8_t   RCDS       :  2;               /*!< Reference Signal Generation Clock Frequency Division Ratio Select
                                                                                                                               */
      __IO uint8_t   DFS        :  2;               /*!< Digital Filter Selection                                              */
    } CACR2_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   CAICR;                           /*!< CAC Interrupt Control Register                                        */
    
    struct {
      __IO uint8_t   FERRIE     :  1;               /*!< Frequency Error Interrupt Enable                                      */
      __IO uint8_t   MENDIE     :  1;               /*!< Measurement End Interrupt Enable                                      */
      __IO uint8_t   OVFIE      :  1;               /*!< Overflow Interrupt Enable                                             */
           uint8_t              :  1;
      __O  uint8_t   FERRFCL    :  1;               /*!< FERRF Clear                                                           */
      __O  uint8_t   MENDFCL    :  1;               /*!< MENDF Clear                                                           */
      __O  uint8_t   OVFFCL     :  1;               /*!< OVFF Clear                                                            */
    } CAICR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   CASTR;                           /*!< CAC Status Register                                                   */
    
    struct {
      __I  uint8_t   FERRF      :  1;               /*!< Frequency Error Flag                                                  */
      __I  uint8_t   MENDF      :  1;               /*!< Measurement End Flag                                                  */
      __I  uint8_t   OVFF       :  1;               /*!< Counter Overflow Flag                                                 */
    } CASTR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED;
  
  union {
    __IO uint16_t  CAULVR;                          /*!< CAC Upper-Limit Value Setting Register                                */
    
    struct {
      __IO uint16_t  CAULVR     : 16;               /*!< CAULVR is a 16-bit readable/writeable register that stores the
                                                         upper-limit value of the frequency.                                   */
    } CAULVR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  CALLVR;                          /*!< CAC Lower-Limit Value Setting Register                                */
    
    struct {
      __IO uint16_t  CALLVR     : 16;               /*!< CALLVR is a 16-bit readable/writeable register that stores the
                                                         lower-limit value of the frequency.                                   */
    } CALLVR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __I  uint16_t  CACNTBR;                         /*!< CAC Counter Buffer Register                                           */
    
    struct {
      __I  uint16_t  CACNTBR    : 16;               /*!< CACNTBR is a 16-bit read-only register that retains the counter
                                                         value at the time a valid reference signal edge is input              */
    } CACNTBR_b;                                    /*!< BitSize                                                               */
  };
} R_CAC_Type;


/* ================================================================================ */
/* ================                     R_MSTP                     ================ */
/* ================================================================================ */


/**
  * @brief Module Stop Control B,C,D (R_MSTP)
  */

typedef struct {                                    /*!< R_MSTP Structure                                                      */
  
  union {
    __IO uint32_t  MSTPCRB;                         /*!< Module Stop Control Register B                                        */
    
    struct {
           uint32_t             :  1;
      __IO uint32_t  MSTPB1     :  1;               /*!< RCAN1 Module Stop                                                     */
      __IO uint32_t  MSTPB2     :  1;               /*!< RCAN0 Module Stop                                                     */
           uint32_t             :  2;
      __IO uint32_t  MSTPB5     :  1;               /*!< IrDA Module Stop                                                      */
      __IO uint32_t  MSTPB6     :  1;               /*!< Queued Serial Peripheral Interface Module Stop                        */
      __IO uint32_t  MSTPB7     :  1;               /*!< I2C Bus Interface 2 Module Stop                                       */
      __IO uint32_t  MSTPB8     :  1;               /*!< I2C Bus Interface 1 Module Stop                                       */
      __IO uint32_t  MSTPB9     :  1;               /*!< I2C Bus Interface 0 Module Stop                                       */
           uint32_t             :  1;
      __IO uint32_t  MSTPB11    :  1;               /*!< Universal Serial Bus 2.0 FS Interface Module Stop                     */
      __IO uint32_t  MSTPB12    :  1;               /*!< Universal Serial Bus 2.0 HS Interface Module Stop                     */
      __IO uint32_t  MSTPB13    :  1;               /*!< EPTPC and PTPEDMAC Module Stop                                        */
      __IO uint32_t  MSTPB14    :  1;               /*!< ETHERC1 and EDMAC1 Module Stop                                        */
      __IO uint32_t  MSTPB15    :  1;               /*!< ETHERC0 and EDMAC0 Module Stop                                        */
           uint32_t             :  2;
      __IO uint32_t  MSTPB18    :  1;               /*!< Serial Peripheral Interface Module Stop                               */
      __IO uint32_t  MSTPB19    :  1;               /*!< Serial Peripheral Interface 0 Module Stop                             */
           uint32_t             :  2;
      __IO uint32_t  MSTPB22    :  1;               /*!< Serial Communication Interface 9 Module Stop                          */
      __IO uint32_t  MSTPB23    :  1;               /*!< Serial Communication Interface 8 Module Stop                          */
      __IO uint32_t  MSTPB24    :  1;               /*!< Serial Communication Interface 7 Module Stop                          */
      __IO uint32_t  MSTPB25    :  1;               /*!< Serial Communication Interface 6 Module Stop                          */
      __IO uint32_t  MSTPB26    :  1;               /*!< Serial Communication Interface 5 Module Stop                          */
      __IO uint32_t  MSTPB27    :  1;               /*!< Serial Communication Interface 4 Module Stop                          */
      __IO uint32_t  MSTPB28    :  1;               /*!< Serial Communication Interface 3 Module Stop                          */
      __IO uint32_t  MSTPB29    :  1;               /*!< Serial Communication Interface 2 Module Stop                          */
      __IO uint32_t  MSTPB30    :  1;               /*!< Serial Communication Interface 1 Module Stop                          */
      __IO uint32_t  MSTPB31    :  1;               /*!< Serial Communication Interface 0 Module Stop                          */
    } MSTPCRB_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  MSTPCRC;                         /*!< Module Stop Control Register C                                        */
    
    struct {
      __IO uint32_t  MSTPC0     :  1;               /*!< CAC Module Stop                                                       */
      __IO uint32_t  MSTPC1     :  1;               /*!< CRC Calculator Module Stop                                            */
      __IO uint32_t  MSTPC2     :  1;               /*!< Parallel Data Capture Module Stop                                     */
      __IO uint32_t  MSTPC3     :  1;               /*!< Capacitive Touch Sensing Unit Module Stop                             */
      __IO uint32_t  MSTPC4     :  1;               /*!< Graphic LCD Controller Module Stop                                    */
      __IO uint32_t  MSTPC5     :  1;               /*!< JPEG codec engine Module Stop                                         */
      __IO uint32_t  MSTPC6     :  1;               /*!< 2DG engine Module Stop                                                */
      __IO uint32_t  MSTPC7     :  1;               /*!< Synchronous Serial Interface 1 Module Stop                            */
      __IO uint32_t  MSTPC8     :  1;               /*!< Synchronous Serial Interface 0 Module Stop                            */
      __IO uint32_t  MSTPC9     :  1;               /*!< Sampling Rate Converter Module Stop                                   */
           uint32_t             :  1;
      __IO uint32_t  MSTPC11    :  1;               /*!< Synchronous Digital Hierarchy/ Multi Media Card 1 Module Stop         */
      __IO uint32_t  MSTPC12    :  1;               /*!< Synchronous Digital Hierarchy/ Multi Media Card 0 Module Stop         */
      __IO uint32_t  MSTPC13    :  1;               /*!< Data Operation Circuit Module Stop                                    */
      __IO uint32_t  MSTPC14    :  1;               /*!< Event Link Controller Module Stop                                     */
           uint32_t             : 16;
      __IO uint32_t  MSTPC31    :  1;               /*!< TSIP Module Stop                                                      */
    } MSTPCRC_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  MSTPCRD;                         /*!< Module Stop Control Register D                                        */
    
    struct {
           uint32_t             :  2;
      __IO uint32_t  MSTPD2     :  1;               /*!< AGT1 Module StopNote: AGT1 is in the module stop state when
                                                         the count source is either of PCLKB, PCLKB/2 or PCLKB/8. In
                                                          case the count source is sub-clock or LOCO, this bit should
                                                          be set to 1 except when accessing the registers of AGT1.             */
      __IO uint32_t  MSTPD3     :  1;               /*!< AGT0 Module StopNote: AGT0 is in the module stop state when
                                                         the count source is either of PCLKB, PCLKB/2 or PCLKB/8. In
                                                          case the count source is sub-clock or LOCO, this bit should
                                                          be set to 1 except when accessing the registers of AGT0.             */
           uint32_t             :  1;
      __IO uint32_t  MSTPD5     :  1;               /*!< GPT ch7-ch0 Module Stop                                               */
      __IO uint32_t  MSTPD6     :  1;               /*!< GPT ch13-ch8 Module Stop                                              */
           uint32_t             :  7;
      __IO uint32_t  MSTPD14    :  1;               /*!< PGI Module Stop                                                       */
      __IO uint32_t  MSTPD15    :  1;               /*!< 12-bit A/D Converter 1 Module Stop                                    */
      __IO uint32_t  MSTPD16    :  1;               /*!< 12-bit A/D Converter 0 Module Stop                                    */
           uint32_t             :  3;
      __IO uint32_t  MSTPD20    :  1;               /*!< D/A Converter 0 Module Stop                                           */
           uint32_t             :  1;
      __IO uint32_t  MSTPD22    :  1;               /*!< Temperature Sensor Module Stop                                        */
      __IO uint32_t  MSTPD23    :  1;               /*!< Comparator-OC5 Module Stop                                            */
      __IO uint32_t  MSTPD24    :  1;               /*!< Comparator-OC4 Module Stop                                            */
      __IO uint32_t  MSTPD25    :  1;               /*!< Comparator-OC3 Module Stop                                            */
      __IO uint32_t  MSTPD26    :  1;               /*!< Comparator-OC2 Module Stop                                            */
      __IO uint32_t  MSTPD27    :  1;               /*!< Comparator-OC1 Module Stop                                            */
      __IO uint32_t  MSTPD28    :  1;               /*!< Comparator-OC0 Module Stop                                            */
    } MSTPCRD_b;                                    /*!< BitSize                                                               */
  };
} R_MSTP_Type;


/* ================================================================================ */
/* ================                      R_SRC                     ================ */
/* ================================================================================ */


/**
  * @brief Sampling Rate Converter (R_SRC)
  */

typedef struct {                                    /*!< R_SRC Structure                                                       */
  
    union {
      __IO uint32_t  SRCFCTRn[5552];                  /*!< Filter Coefficient Table[%s]                                          */

      struct {
        __IO uint32_t  SRCFCOE    : 22;               /*!< Stores a filter coefficient value.                                    */
      } SRCFCTRn_b[5552];                             /*!< BitSize                                                               */
    };

    __I  uint8_t RESERVED[588 * 4];                  /*!< Padding changed from uint32_t                                           */

  union {
    __O  uint32_t  SRCID;                           /*!< Input Data Register                                                   */
    
    struct {
      __O  uint32_t  SRCID      : 32;               /*!< SRCID is a 32-bit writ-only register that is used to input the
                                                         data before sampling rate conversion. All the bits are read
                                                          as 0.                                                                */
    } SRCID_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  SRCOD;                           /*!< Output Data Register                                                  */
    
    struct {
      __I  uint32_t  SRCOD      : 32;               /*!< SRCOD is a 32-bit read-only register used to output the data
                                                         after sampling rate conversion. The data in the 16-stage output
                                                          data FIFO is read through SRCOD. When the number of data in
                                                          the output data FIFO is zero after the start of conversion,
                                                          the value previously read is read again.                             */
    } SRCOD_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  SRCIDCTRL;                       /*!< Input Data Control Register                                           */
    
    struct {
      __IO uint16_t  IFTRG      :  2;               /*!< Input FIFO Data Triggering Number                                     */
           uint16_t             :  6;
      __IO uint16_t  IEN        :  1;               /*!< Input FIFO Empty Interrupt Enable                                     */
      __IO uint16_t  IED        :  1;               /*!< Input Data Endian                                                     */
    } SRCIDCTRL_b;                                  /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  SRCODCTRL;                       /*!< Output Data Control Register                                          */
    
    struct {
      __IO uint16_t  OFTRG      :  2;               /*!< Output FIFO Data Trigger Number                                       */
           uint16_t             :  6;
      __IO uint16_t  OEN        :  1;               /*!< Output Data FIFO Full Interrupt Enable                                */
      __IO uint16_t  OED        :  1;               /*!< Output Data Endian                                                    */
      __IO uint16_t  OCH        :  1;               /*!< Output Data Channel Exchange                                          */
    } SRCODCTRL_b;                                  /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  SRCCTRL;                         /*!< Control Register                                                      */
    
    struct {
      __IO uint16_t  OFS        :  3;               /*!< Output Sampling Rate                                                  */
           uint16_t             :  1;
      __IO uint16_t  IFS        :  4;               /*!< Input Sampling Rate                                                   */
      __IO uint16_t  CL         :  1;               /*!< Internal Work Memory Clear                                            */
      __IO uint16_t  FL         :  1;               /*!< Internal Work Memory Flush                                            */
      __IO uint16_t  OVEN       :  1;               /*!< Output Data FIFO Overwrite Interrupt Enable                           */
      __IO uint16_t  UDEN       :  1;               /*!< Output Data FIFO Underflow Interrupt Enable                           */
      __IO uint16_t  SRCEN      :  1;               /*!< Module Enable                                                         */
      __IO uint16_t  CEEN       :  1;               /*!< Conversion End Interrupt Enable                                       */
           uint16_t             :  1;
      __IO uint16_t  FICRAE     :  1;               /*!< Filter Coefficient Table Access Enable                                */
    } SRCCTRL_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  SRCSTAT;                         /*!< Status Register                                                       */
    
    struct {
      __IO uint16_t  OINT       :  1;               /*!< Output Data FIFO Full Interrupt Request Flag                          */
      __IO uint16_t  IINT       :  1;               /*!< Input Data FIFO Empty Interrupt Request Flag                          */
      __IO uint16_t  OVF        :  1;               /*!< Output Data FIFO Overwrite Interrupt Request Flag                     */
      __IO uint16_t  UDF        :  1;               /*!< Output FIFO Underflow Interrupt Request Flag                          */
      __I  uint16_t  FLF        :  1;               /*!< Flush Processing Status Flag                                          */
      __IO uint16_t  CEF        :  1;               /*!< Conversion End Flag                                                   */
           uint16_t             :  1;
      __IO uint16_t  IFDN       :  4;               /*!< Input FIFO Data CountIndicates the number of data units in the
                                                         input FIFO.                                                           */
      __IO uint16_t  OFDN       :  5;               /*!< Output FIFO Data CountIndicates the number of data units in
                                                         the output FIFO.                                                      */
    } SRCSTAT_b;                                    /*!< BitSize                                                               */
  };

} R_SRC_Type;


/* ================================================================================ */
/* ================                     R_SSI0                     ================ */
/* ================================================================================ */


/**
  * @brief Serial Sound Interface 0 (R_SSI0)
  */

typedef struct {                                    /*!< R_SSI0 Structure                                                      */
  
  union {
    __IO uint32_t  SSICR;                           /*!< Control Register                                                      */
    
    struct {
      __IO uint32_t  REN        :  1;               /*!< Receive Enable                                                        */
      __IO uint32_t  TEN        :  1;               /*!< Transmit Enable                                                       */
           uint32_t             :  1;
      __IO uint32_t  MUEN       :  1;               /*!< Mute EnableNOTE: When this module is muted, the value of outputting
                                                         serial data is rewritten to 0 but data transmission is not stopped.
                                                          Write dummy data to the SSIFTDR not to generate a transmit underflow
                                                          because the number of data in the transmit FIFO is decreasing.       */
      __IO uint32_t  CKDV       :  4;               /*!< Serial Oversampling Clock Division Ratio                              */
      __IO uint32_t  DEL        :  1;               /*!< Serial Data Delay                                                     */
      __IO uint32_t  PDTA       :  1;               /*!< Parallel Data Alignment                                               */
      __IO uint32_t  SDTA       :  1;               /*!< Serial Data Alignment                                                 */
      __IO uint32_t  SPDP       :  1;               /*!< Serial Padding Polarity                                               */
      __IO uint32_t  SWSP       :  1;               /*!< Serial WS Polarity                                                    */
      __IO uint32_t  SCKP       :  1;               /*!< Serial Bit Clock Polarity                                             */
      __IO uint32_t  SWSD       :  1;               /*!< Serial WS DirectionNOTE: Only the following settings are allowed:
                                                         (SCKD, SWSD) = (0, 0) and (1, 1). Other settings are prohibited.      */
      __IO uint32_t  SCKD       :  1;               /*!< Serial Bit Clock DirectionNOTE: Only the following settings
                                                         are allowed: (SCKD, SWSD) = (0, 0) and (1, 1). Other settings
                                                          are prohibited.                                                      */
      __IO uint32_t  SWL        :  3;               /*!< System Word LengthSet the system word length to the bit clock
                                                         frequency/2 fs.                                                       */
      __IO uint32_t  DWL        :  3;               /*!< Data Word Length                                                      */
      __IO uint32_t  CHNL       :  2;               /*!< Channels                                                              */
           uint32_t             :  1;
      __IO uint32_t  IIEN       :  1;               /*!< Idle Mode Interrupt Enable                                            */
      __IO uint32_t  ROIEN      :  1;               /*!< Receive Overflow Interrupt Enable                                     */
      __IO uint32_t  RUIEN      :  1;               /*!< Receive Underflow Interrupt Enable                                    */
      __IO uint32_t  TOIEN      :  1;               /*!< Transmit Overflow Interrupt Enable                                    */
      __IO uint32_t  TUIEN      :  1;               /*!< Transmit Underflow Interrupt Enable                                   */
      __IO uint32_t  CKS        :  1;               /*!< Oversampling Clock Select                                             */
    } SSICR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SSISR;                           /*!< Status Register                                                       */
    
    struct {
      __I  uint32_t  IDST       :  1;               /*!< Idle Mode Status Flag                                                 */
      __I  uint32_t  RSWNO      :  1;               /*!< Receive Serial Word Number                                            */
      __I  uint32_t  RCHNO      :  2;               /*!< Receive Channel Number.These bits are read as 00b.                    */
      __I  uint32_t  TSWNO      :  1;               /*!< Transmit Serial Word Number                                           */
      __I  uint32_t  TCHNO      :  2;               /*!< Transmit Channel Number                                               */
           uint32_t             : 18;
      __I  uint32_t  IIRQ       :  1;               /*!< Idle Mode Interrupt Status Flag                                       */
      __IO uint32_t  ROIRQ      :  1;               /*!< Receive Overflow Error Interrupt Status FlagNOTE: This bit can
                                                         be set to 0 by writing 0 after reading it as 1.                       */
      __IO uint32_t  RUIRQ      :  1;               /*!< Receive Underflow Error Interrupt Status FlagNOTE: This bit
                                                         can be set to 0 by writing 0 after reading it as 1.                   */
      __IO uint32_t  TOIRQ      :  1;               /*!< Transmit Overflow Error Interrupt Status FlagNOTE: This bit
                                                         can be set to 0 by writing 0 after reading it as 1.                   */
      __IO uint32_t  TUIRQ      :  1;               /*!< Transmit Underflow Error Interrupt Status FlagNOTE: This bit
                                                         can be set to 0 by writing 0 after reading it as 1.                   */
    } SSISR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED[2 * 4];
  
  union {
    __IO uint32_t  SSIFCR;                          /*!< FIFO Control Register                                                 */
    
    struct {
      __IO uint32_t  RFRST      :  1;               /*!< Receive FIFO Data Register Reset                                      */
      __IO uint32_t  TFRST      :  1;               /*!< Transmit FIFO Data Register Reset                                     */
      __IO uint32_t  RIE        :  1;               /*!< Receive Interrupt EnableNOTE: RXI can be cleared by clearing
                                                         either the RDF flag (see the description of the RDF bit for
                                                          details) or RIE bit.                                                 */
      __IO uint32_t  TIE        :  1;               /*!< Transmit Interrupt EnableNOTE: TXI can be cleared by clearing
                                                         either the TDE flag (see the description of the TDE bit for
                                                          details) or TIE bit.                                                 */
      __IO uint32_t  RTRG       :  2;               /*!< Receive Data Trigger Number                                           */
      __IO uint32_t  TTRG       :  2;               /*!< Transmit Data Trigger NumberNOTE: The values in parenthesis
                                                         are the number of empty stages in SSIFTDR at which the TDE flag
                                                          is set.                                                              */
           uint32_t             :  8;
      __IO uint32_t  SSIRST     :  1;               /*!< SSI soft ware reset                                                   */
           uint32_t             : 14;
      __IO uint32_t  AUCKE      :  1;               /*!< Oversampling Clock Enable                                             */
    } SSIFCR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SSIFSR;                          /*!< FIFO Status Register                                                  */
    
    struct {
      __IO uint32_t  RDF        :  1;               /*!< Receive Data Full FlagNOTE: Since the SSIFRDR register is a
                                                         32-byte FIFO register, the maximum number of data bytes that
                                                          can be read from it while the RDF flag is 1 is indicated in
                                                          the RDC[3:0] flags. If reading data from the SSIFRDR register
                                                          is continued after all the data is read, undefined values will
                                                          be read.                                                             */
           uint32_t             :  7;
      __I  uint32_t  RDC        :  5;               /*!< Receive Data Indicate Flag(Indicates the number of data units
                                                         stored in SSIFRDR)                                                    */
           uint32_t             :  3;
      __IO uint32_t  TDE        :  1;               /*!< Transmit Data Empty FlagNOTE: Since the SSIFTDR register is
                                                         a 32-byte FIFO register, the maximum number of bytes that can
                                                          be written to it while the TDE flag is 1 is 8 - TDC[3:0]. If
                                                          writing data to the SSIFTDR register is continued after all
                                                          the data is written, writing will be invalid and an overflow
                                                          occurs.                                                              */
           uint32_t             :  7;
      __I  uint32_t  TDC        :  5;               /*!< Transmit Data Indicate Flag(Indicates the number of data units
                                                         stored in SSIFTDR)                                                    */
    } SSIFSR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __O  uint32_t  SSIFTDR;                         /*!< Transmit FIFO Data Register                                           */
    __O  uint16_t  SSIFTDR16;                       /*!< Transmit FIFO Data Register                                           */
    __O  uint8_t   SSIFTDR8;                        /*!< Transmit FIFO Data Register                                           */
    
    struct {
      __O  uint32_t  SSIFTDR    : 32;               /*!< SSIFTDR is a write-only FIFO register consisting of eight stages
                                                         of 32-bit registers for storing data to be serially transmitted.
                                                          NOTE: that when the SSIFTDR register is full of data (32 bytes),
                                                          the next data cannot be written to it. If writing is attempted,
                                                          it will be ignored and an overflow occurs.                           */
    } SSIFTDR_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  SSIFRDR;                         /*!< Receive FIFO Data Register                                            */
    __I  uint16_t  SSIFRDR16;                       /*!< Receive FIFO Data Register                                            */
    __I  uint8_t   SSIFRDR8;                        /*!< Receive FIFO Data Register                                            */
    
    struct {
      __I  uint32_t  SSIFRDR    : 32;               /*!< SSIFRDR is a read-only FIFO register consisting of eight stages
                                                         of 32-bit registers for storing serially received data.               */
    } SSIFRDR_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SSITDMR;                         /*!< TDM Mode Register                                                     */
    
    struct {
           uint32_t             :  8;
      __IO uint32_t  CONT       :  1;               /*!< WS Continue Mode                                                      */
           uint32_t             :  23;
    } SSITDMR_b;                                    /*!< BitSize                                                               */
  };

  union {
    __IO uint32_t  SSISCR;                          /*!< Status Control Register (SSIE only)                                   */

    struct {
      __IO uint32_t  RDFS       :  5;               /*!< RDF Setting Condition Select                                          */
           uint32_t             :  3;
      __IO uint32_t  TDES       :  5;               /*!< TDE Setting Condition Select                                          */
           uint32_t             :  19;
    } SSISCR_b;                                     /*!< BitSize                                                               */
  };
} R_SSI0_Type;


/* ================================================================================ */
/* ================                     R_CAN0                     ================ */
/* ================================================================================ */


/**
  * @brief Controller Area Network 0 Module (R_CAN0)
  */

typedef struct {                                    /*!< R_CAN0 Structure                                                      */
  __I  uint8_t RESERVED[128 * 4];
  R_CAN0_MBn_Type MBn[32];                          /*!< Mailbox %s                                                            */
  
  union {
    __IO uint32_t  MKRn[8];                         /*!< Mask Register %s                                                      */
    
    struct {
      __IO uint32_t  EID        : 18;               /*!< Extended ID                                                           */
      __IO uint32_t  SID        : 11;               /*!< Standard ID                                                           */
    } MKRn_b[8];                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  FIDCRn[2];                       /*!< FIFO Received ID Compare Registers %s                                 */
    
    struct {
      __IO uint32_t  EID        : 18;               /*!< Extended ID                                                           */
      __IO uint32_t  SID        : 11;               /*!< Standard ID                                                           */
           uint32_t             :  1;
      __IO uint32_t  RTR        :  1;               /*!< Remote Transmission Request                                           */
      __IO uint32_t  IDE        :  1;               /*!< ID Extension                                                          */
    } FIDCRn_b[2];                                  /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  MKIVLR;                          /*!< Mask Invalid Register                                                 */
    
    struct {
      __IO uint32_t  MB0        :  1;               /*!< mailbox 0 Mask Invalid                                                */
      __IO uint32_t  MB1        :  1;               /*!< mailbox 1 Mask Invalid                                                */
      __IO uint32_t  MB2        :  1;               /*!< mailbox 2 Mask Invalid                                                */
      __IO uint32_t  MB3        :  1;               /*!< mailbox 3 Mask Invalid                                                */
      __IO uint32_t  MB4        :  1;               /*!< mailbox 4 Mask Invalid                                                */
      __IO uint32_t  MB5        :  1;               /*!< mailbox 5 Mask Invalid                                                */
      __IO uint32_t  MB6        :  1;               /*!< mailbox 6 Mask Invalid                                                */
      __IO uint32_t  MB7        :  1;               /*!< mailbox 7 Mask Invalid                                                */
      __IO uint32_t  MB8        :  1;               /*!< mailbox 8 Mask Invalid                                                */
      __IO uint32_t  MB9        :  1;               /*!< mailbox 9 Mask Invalid                                                */
      __IO uint32_t  MB10       :  1;               /*!< mailbox 10 Mask Invalid                                               */
      __IO uint32_t  MB11       :  1;               /*!< mailbox 11 Mask Invalid                                               */
      __IO uint32_t  MB12       :  1;               /*!< mailbox 12 Mask Invalid                                               */
      __IO uint32_t  MB13       :  1;               /*!< mailbox 13 Mask Invalid                                               */
      __IO uint32_t  MB14       :  1;               /*!< mailbox 14 Mask Invalid                                               */
      __IO uint32_t  MB15       :  1;               /*!< mailbox 15 Mask Invalid                                               */
      __IO uint32_t  MB16       :  1;               /*!< mailbox 16 Mask Invalid                                               */
      __IO uint32_t  MB17       :  1;               /*!< mailbox 17 Mask Invalid                                               */
      __IO uint32_t  MB18       :  1;               /*!< mailbox 18 Mask Invalid                                               */
      __IO uint32_t  MB19       :  1;               /*!< mailbox 19 Mask Invalid                                               */
      __IO uint32_t  MB20       :  1;               /*!< mailbox 20 Mask Invalid                                               */
      __IO uint32_t  MB21       :  1;               /*!< mailbox 21 Mask Invalid                                               */
      __IO uint32_t  MB22       :  1;               /*!< mailbox 22 Mask Invalid                                               */
      __IO uint32_t  MB23       :  1;               /*!< mailbox 23 Mask Invalid                                               */
      __IO uint32_t  MB24       :  1;               /*!< mailbox 24 Mask Invalid                                               */
      __IO uint32_t  MB25       :  1;               /*!< mailbox 25 Mask Invalid                                               */
      __IO uint32_t  MB26       :  1;               /*!< mailbox 26 Mask Invalid                                               */
      __IO uint32_t  MB27       :  1;               /*!< mailbox 27 Mask Invalid                                               */
      __IO uint32_t  MB28       :  1;               /*!< mailbox 28 Mask Invalid                                               */
      __IO uint32_t  MB29       :  1;               /*!< mailbox 29 Mask Invalid                                               */
      __IO uint32_t  MB30       :  1;               /*!< mailbox 30 Mask Invalid                                               */
      __IO uint32_t  MB31       :  1;               /*!< mailbox 31 Mask Invalid                                               */
    } MKIVLR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    union {
      __IO uint32_t  MIER_FIFO;                     /*!< Mailbox Interrupt Enable Register (FIFO mailbox mode)                 */
      
      struct {
        __IO uint32_t  MB0      :  1;               /*!< mailbox 0 Interrupt Enable                                            */
        __IO uint32_t  MB1      :  1;               /*!< mailbox 1 Interrupt Enable                                            */
        __IO uint32_t  MB2      :  1;               /*!< mailbox 2 Interrupt Enable                                            */
        __IO uint32_t  MB3      :  1;               /*!< mailbox 3 Interrupt Enable                                            */
        __IO uint32_t  MB4      :  1;               /*!< mailbox 4 Interrupt Enable                                            */
        __IO uint32_t  MB5      :  1;               /*!< mailbox 5 Interrupt Enable                                            */
        __IO uint32_t  MB6      :  1;               /*!< mailbox 6 Interrupt Enable                                            */
        __IO uint32_t  MB7      :  1;               /*!< mailbox 7 Interrupt Enable                                            */
        __IO uint32_t  MB8      :  1;               /*!< mailbox 8 Interrupt Enable                                            */
        __IO uint32_t  MB9      :  1;               /*!< mailbox 9 Interrupt Enable                                            */
        __IO uint32_t  MB10     :  1;               /*!< mailbox 10 Interrupt Enable                                           */
        __IO uint32_t  MB11     :  1;               /*!< mailbox 11 Interrupt Enable                                           */
        __IO uint32_t  MB12     :  1;               /*!< mailbox 12 Interrupt Enable                                           */
        __IO uint32_t  MB13     :  1;               /*!< mailbox 13 Interrupt Enable                                           */
        __IO uint32_t  MB14     :  1;               /*!< mailbox 14 Interrupt Enable                                           */
        __IO uint32_t  MB15     :  1;               /*!< mailbox 15 Interrupt Enable                                           */
        __IO uint32_t  MB16     :  1;               /*!< mailbox 16 Interrupt Enable                                           */
        __IO uint32_t  MB17     :  1;               /*!< mailbox 17 Interrupt Enable                                           */
        __IO uint32_t  MB18     :  1;               /*!< mailbox 18 Interrupt Enable                                           */
        __IO uint32_t  MB19     :  1;               /*!< mailbox 19 Interrupt Enable                                           */
        __IO uint32_t  MB20     :  1;               /*!< mailbox 20 Interrupt Enable                                           */
        __IO uint32_t  MB21     :  1;               /*!< mailbox 21 Interrupt Enable                                           */
        __IO uint32_t  MB22     :  1;               /*!< mailbox 22 Interrupt Enable                                           */
        __IO uint32_t  MB23     :  1;               /*!< mailbox 23 Interrupt Enable                                           */
        __IO uint32_t  MB24     :  1;               /*!< Transmit FIFO Interrupt Enable                                        */
        __IO uint32_t  MB25     :  1;               /*!< Transmit FIFO Interrupt Generation Timing Control                     */
             uint32_t           :  2;
        __IO uint32_t  MB28     :  1;               /*!< Receive FIFO Interrupt Enable                                         */
        __IO uint32_t  MB29     :  1;               /*!< Receive FIFO Interrupt Generation Timing Control                      */
      } MIER_FIFO_b;                                /*!< BitSize                                                               */
    };
    
    union {
      __IO uint32_t  MIER;                          /*!< Mailbox Interrupt Enable Register (Normal mailbox mode)               */
      
      struct {
        __IO uint32_t  MB0      :  1;               /*!< mailbox 0 Interrupt Enable                                            */
        __IO uint32_t  MB1      :  1;               /*!< mailbox 1 Interrupt Enable                                            */
        __IO uint32_t  MB2      :  1;               /*!< mailbox 2 Interrupt Enable                                            */
        __IO uint32_t  MB3      :  1;               /*!< mailbox 3 Interrupt Enable                                            */
        __IO uint32_t  MB4      :  1;               /*!< mailbox 4 Interrupt Enable                                            */
        __IO uint32_t  MB5      :  1;               /*!< mailbox 5 Interrupt Enable                                            */
        __IO uint32_t  MB6      :  1;               /*!< mailbox 6 Interrupt Enable                                            */
        __IO uint32_t  MB7      :  1;               /*!< mailbox 7 Interrupt Enable                                            */
        __IO uint32_t  MB8      :  1;               /*!< mailbox 8 Interrupt Enable                                            */
        __IO uint32_t  MB9      :  1;               /*!< mailbox 9 Interrupt Enable                                            */
        __IO uint32_t  MB10     :  1;               /*!< mailbox 10 Interrupt Enable                                           */
        __IO uint32_t  MB11     :  1;               /*!< mailbox 11 Interrupt Enable                                           */
        __IO uint32_t  MB12     :  1;               /*!< mailbox 12 Interrupt Enable                                           */
        __IO uint32_t  MB13     :  1;               /*!< mailbox 13 Interrupt Enable                                           */
        __IO uint32_t  MB14     :  1;               /*!< mailbox 14 Interrupt Enable                                           */
        __IO uint32_t  MB15     :  1;               /*!< mailbox 15 Interrupt Enable                                           */
        __IO uint32_t  MB16     :  1;               /*!< mailbox 16 Interrupt Enable                                           */
        __IO uint32_t  MB17     :  1;               /*!< mailbox 17 Interrupt Enable                                           */
        __IO uint32_t  MB18     :  1;               /*!< mailbox 18 Interrupt Enable                                           */
        __IO uint32_t  MB19     :  1;               /*!< mailbox 19 Interrupt Enable                                           */
        __IO uint32_t  MB20     :  1;               /*!< mailbox 20 Interrupt Enable                                           */
        __IO uint32_t  MB21     :  1;               /*!< mailbox 21 Interrupt Enable                                           */
        __IO uint32_t  MB22     :  1;               /*!< mailbox 22 Interrupt Enable                                           */
        __IO uint32_t  MB23     :  1;               /*!< mailbox 23 Interrupt Enable                                           */
        __IO uint32_t  MB24     :  1;               /*!< mailbox 24 Interrupt Enable                                           */
        __IO uint32_t  MB25     :  1;               /*!< mailbox 25 Interrupt Enable                                           */
        __IO uint32_t  MB26     :  1;               /*!< mailbox 26 Interrupt Enable                                           */
        __IO uint32_t  MB27     :  1;               /*!< mailbox 27 Interrupt Enable                                           */
        __IO uint32_t  MB28     :  1;               /*!< mailbox 28 Interrupt Enable                                           */
        __IO uint32_t  MB29     :  1;               /*!< mailbox 29 Interrupt Enable                                           */
        __IO uint32_t  MB30     :  1;               /*!< mailbox 30 Interrupt Enable                                           */
        __IO uint32_t  MB31     :  1;               /*!< mailbox 31 Interrupt Enable                                           */
      } MIER_b;                                     /*!< BitSize                                                               */
    };
  };
  __I  uint8_t RESERVED1[252 * 4];
  
  union {
    union {
      __IO uint8_t   MCTLn_RX[32];                  /*!< Message Control Register( Receive mode (when the TRMREQ bit
                                                         is 0 and the RECREQ bit is 1))                                        */
      
      struct {
        __IO uint8_t   NEWDATA  :  1;               /*!< Reception Complete Flag                                               */
        __I  uint8_t   INVALDATA:  1;               /*!< Reception-in-Progress Status Flag (Receive mailbox setting enabled)   */
        __IO uint8_t   MSGLOST  :  1;               /*!< Message Lost Flag(Receive mailbox setting enabled)                    */
             uint8_t            :  1;
        __IO uint8_t   ONESHOT  :  1;               /*!< One-Shot Enable                                                       */
             uint8_t            :  1;
        __IO uint8_t   RECREQ   :  1;               /*!< Receive Mailbox Request                                               */
        __IO uint8_t   TRMREQ   :  1;               /*!< Transmit Mailbox Request                                              */
      } MCTLn_RX_b[32];                             /*!< BitSize                                                               */
    };
    
    union {
      __IO uint8_t   MCTLn_TX[32];                  /*!< Message Control Register(Transmit mode (when the TRMREQ bit
                                                         is 1 and the RECREQ bit is 0))                                        */
      
      struct {
        __IO uint8_t   SENTDATA :  1;               /*!< Transmission Complete Flag                                            */
        __I  uint8_t   TRMACTIVE:  1;               /*!< Transmission-in-Progress Status Flag(Transmit mailbox setting
                                                         enabled)                                                              */
        __IO uint8_t   TRMABT   :  1;               /*!< Transmission Abort Complete Flag(Transmit mailbox setting enabled)    */
             uint8_t            :  1;
        __IO uint8_t   ONESHOT  :  1;               /*!< One-Shot Enable                                                       */
             uint8_t            :  1;
        __IO uint8_t   RECREQ   :  1;               /*!< Receive Mailbox Request                                               */
        __IO uint8_t   TRMREQ   :  1;               /*!< Transmit Mailbox Request                                              */
      } MCTLn_TX_b[32];                             /*!< BitSize                                                               */
    };
  };
  
  union {
    __IO uint16_t  CTLR;                            /*!< Control Register                                                      */
    
    struct {
      __IO uint16_t  MBM        :  1;               /*!< CAN Mailbox Mode Select                                               */
      __IO uint16_t  IDFM       :  2;               /*!< ID Format Mode Select                                                 */
      __IO uint16_t  MLM        :  1;               /*!< Message Lost Mode Select                                              */
      __IO uint16_t  TPM        :  1;               /*!< Transmission Priority Mode Select                                     */
      __IO uint16_t  TSRC       :  1;               /*!< Time Stamp Counter Reset Command                                      */
      __IO uint16_t  TSPS       :  2;               /*!< Time Stamp Prescaler Select                                           */
      __IO uint16_t  CANM       :  2;               /*!< CAN Operating Mode Select                                             */
      __IO uint16_t  SLPM       :  1;               /*!< CAN Sleep Mode                                                        */
      __IO uint16_t  BOM        :  2;               /*!< Bus-Off Recovery Mode by a program request                            */
      __IO uint16_t  RBOC       :  1;               /*!< Forcible Return From Bus-Off                                          */
    } CTLR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __I  uint16_t  STR;                             /*!< Status Register                                                       */
    
    struct {
      __I  uint16_t  NDST       :  1;               /*!< NEWDATA Status Flag                                                   */
      __I  uint16_t  SDST       :  1;               /*!< SENTDATA Status Flag                                                  */
      __I  uint16_t  RFST       :  1;               /*!< Receive FIFO Status Flag                                              */
      __I  uint16_t  TFST       :  1;               /*!< Transmit FIFO Status Flag                                             */
      __I  uint16_t  NMLST      :  1;               /*!< Normal Mailbox Message Lost Status Flag                               */
      __I  uint16_t  FMLST      :  1;               /*!< FIFO Mailbox Message Lost Status Flag                                 */
      __I  uint16_t  TABST      :  1;               /*!< Transmission Abort Status Flag                                        */
      __I  uint16_t  EST        :  1;               /*!< Error Status Flag                                                     */
      __I  uint16_t  RSTST      :  1;               /*!< CAN Reset Status Flag                                                 */
      __I  uint16_t  HLTST      :  1;               /*!< CAN Halt Status Flag                                                  */
      __I  uint16_t  SLPST      :  1;               /*!< CAN Sleep Status Flag                                                 */
      __I  uint16_t  EPST       :  1;               /*!< Error-Passive Status Flag                                             */
      __I  uint16_t  BOST       :  1;               /*!< Bus-Off Status Flag                                                   */
      __I  uint16_t  TRMST      :  1;               /*!< Transmit Status Flag (transmitter)                                    */
      __I  uint16_t  RECST      :  1;               /*!< Receive Status Flag (receiver)                                        */
    } STR_b;                                        /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  BCR;                             /*!< Bit Configuration Register                                            */
    
    struct {
      __IO uint32_t  CCLKS      :  1;               /*!< CAN Clock Source Selection                                            */
           uint32_t             :  7;
      __IO uint32_t  TSEG2      :  3;               /*!< Time Segment 2 Control                                                */
           uint32_t             :  1;
      __IO uint32_t  SJW        :  2;               /*!< Resynchronization Jump Width Control                                  */
           uint32_t             :  2;
      __IO uint32_t  BRP        : 10;               /*!< Prescaler Division Ratio Select . These bits set the frequency
                                                         of the CAN communication clock (fCANCLK).                             */
           uint32_t             :  2;
      __IO uint32_t  TSEG1      :  4;               /*!< Time Segment 1 Control                                                */
    } BCR_b;                                        /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   RFCR;                            /*!< Receive FIFO Control Register                                         */
    
    struct {
      __IO uint8_t   RFE        :  1;               /*!< Receive FIFO Enable                                                   */
      __I  uint8_t   RFUST      :  3;               /*!< Receive FIFO Unread Message Number Status                             */
      __IO uint8_t   RFMLF      :  1;               /*!< Receive FIFO Message Lost Flag                                        */
      __I  uint8_t   RFFST      :  1;               /*!< Receive FIFO Full Status Flag                                         */
      __I  uint8_t   RFWST      :  1;               /*!< Receive FIFO Buffer Warning Status Flag                               */
      __I  uint8_t   RFEST      :  1;               /*!< Receive FIFO Empty Status Flag                                        */
    } RFCR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __O  uint8_t   RFPCR;                           /*!< Receive FIFO Pointer Control Register                                 */
    
    struct {
      __O  uint8_t   RFPCR      :  8;               /*!< The CPU-side pointer for the receive FIFO is incremented by
                                                         writing FFh to RFPCR.                                                 */
    } RFPCR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   TFCR;                            /*!< Transmit FIFO Control Register                                        */
    
    struct {
      __IO uint8_t   TFE        :  1;               /*!< Transmit FIFO Enable                                                  */
      __I  uint8_t   TFUST      :  3;               /*!< Transmit FIFO Unsent Message Number Status                            */
           uint8_t              :  2;
      __I  uint8_t   TFFST      :  1;               /*!< Transmit FIFO Full Status                                             */
      __I  uint8_t   TFEST      :  1;               /*!< Transmit FIFO Empty Status                                            */
    } TFCR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __O  uint8_t   TFPCR;                           /*!< Transmit FIFO Pointer Control Register                                */
    
    struct {
      __O  uint8_t   TFPCR      :  8;               /*!< The CPU-side pointer for the transmit FIFO is incremented by
                                                         writing FFh to TFPCR.                                                 */
    } TFPCR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   EIER;                            /*!< Error Interrupt Enable Register                                       */
    
    struct {
      __IO uint8_t   BEIE       :  1;               /*!< Bus Error Interrupt Enable                                            */
      __IO uint8_t   EWIE       :  1;               /*!< Error-Warning Interrupt Enable                                        */
      __IO uint8_t   EPIE       :  1;               /*!< Error-Passive Interrupt Enable                                        */
      __IO uint8_t   BOEIE      :  1;               /*!< Bus-Off Entry Interrupt Enable                                        */
      __IO uint8_t   BORIE      :  1;               /*!< Bus-Off Recovery Interrupt Enable                                     */
      __IO uint8_t   ORIE       :  1;               /*!< Overrun Interrupt Enable                                              */
      __IO uint8_t   OLIE       :  1;               /*!< Overload Frame Transmit Interrupt Enable                              */
      __IO uint8_t   BLIE       :  1;               /*!< Bus Lock Interrupt Enable                                             */
    } EIER_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   EIFR;                            /*!< Error Interrupt Factor Judge Register                                 */
    
    struct {
      __IO uint8_t   BEIF       :  1;               /*!< Bus Error Detect Flag                                                 */
      __IO uint8_t   EWIF       :  1;               /*!< Error-Warning Detect Flag                                             */
      __IO uint8_t   EPIF       :  1;               /*!< Error-Passive Detect Flag                                             */
      __IO uint8_t   BOEIF      :  1;               /*!< Bus-Off Entry Detect Flag                                             */
      __IO uint8_t   BORIF      :  1;               /*!< Bus-Off Recovery Detect Flag                                          */
      __IO uint8_t   ORIF       :  1;               /*!< Receive Overrun Detect Flag                                           */
      __IO uint8_t   OLIF       :  1;               /*!< Overload Frame Transmission Detect Flag                               */
      __IO uint8_t   BLIF       :  1;               /*!< Bus Lock Detect Flag                                                  */
    } EIFR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __I  uint8_t   RECR;                            /*!< Receive Error Count Register                                          */
    
    struct {
      __I  uint8_t   RECR       :  8;               /*!< Receive error count functionRECR increments or decrements the
                                                         counter value according to the error status of the CAN module
                                                          during reception.                                                    */
    } RECR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __I  uint8_t   TECR;                            /*!< Transmit Error Count Register                                         */
    
    struct {
      __I  uint8_t   TECR       :  8;               /*!< Transmit error count functionTECR increments or decrements the
                                                         counter value according to the error status of the CAN module
                                                          during transmission.                                                 */
    } TECR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ECSR;                            /*!< Error Code Store Register                                             */
    
    struct {
      __IO uint8_t   SEF        :  1;               /*!< Stuff Error Flag                                                      */
      __IO uint8_t   FEF        :  1;               /*!< Form Error Flag                                                       */
      __IO uint8_t   AEF        :  1;               /*!< ACK Error Flag                                                        */
      __IO uint8_t   CEF        :  1;               /*!< CRC Error Flag                                                        */
      __IO uint8_t   BE1F       :  1;               /*!< Bit Error (recessive) Flag                                            */
      __IO uint8_t   BE0F       :  1;               /*!< Bit Error (dominant) Flag                                             */
      __IO uint8_t   ADEF       :  1;               /*!< ACK Delimiter Error Flag                                              */
      __IO uint8_t   EDPM       :  1;               /*!< Error Display Mode Select                                             */
    } ECSR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   CSSR;                            /*!< Channel Search Support Register                                       */
    
    struct {
      __IO uint8_t   CSSR       :  8;               /*!< When the value for the channel search is input, the channel
                                                         number is output to MSSR.                                             */
    } CSSR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __I  uint8_t   MSSR;                            /*!< Mailbox Search Status Register                                        */
    
    struct {
      __I  uint8_t   MBNST      :  5;               /*!< Search Result Mailbox Number Status These bits output the smallest
                                                         mailbox number that is searched in each mode of MSMR.                 */
           uint8_t              :  2;
      __I  uint8_t   SEST       :  1;               /*!< Search Result Status                                                  */
    } MSSR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   MSMR;                            /*!< Mailbox Search Mode Register                                          */
    
    struct {
      __IO uint8_t   MBSM       :  2;               /*!< Mailbox Search Mode Select                                            */
    } MSMR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __I  uint16_t  TSR;                             /*!< Time Stamp Register                                                   */
    
    struct {
      __I  uint16_t  TSR        : 16;               /*!< Free-running counter value for the time stamp function                */
    } TSR_b;                                        /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  AFSR;                            /*!< Acceptance Filter Support Register                                    */
    
    struct {
      __IO uint16_t  AFSR       : 16;               /*!< After the standard ID of a received message is written, the
                                                         value converted for data table search can be read.                    */
    } AFSR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   TCR;                             /*!< Test Control Register                                                 */
    
    struct {
      __IO uint8_t   TSTE       :  1;               /*!< CAN Test Mode Enable                                                  */
      __IO uint8_t   TSTM       :  2;               /*!< CAN Test Mode Select                                                  */
    } TCR_b;                                        /*!< BitSize                                                               */
  };
} R_CAN0_Type;


/* ================================================================================ */
/* ================                     R_IIC0                     ================ */
/* ================================================================================ */


/**
  * @brief Inter-Integrated Circuit 0 (R_IIC0)
  */

typedef struct {                                    /*!< R_IIC0 Structure                                                      */
  
  union {
    __IO uint8_t   ICCR1;                           /*!< I2C Bus Control Register 1                                            */
    
    struct {
      __I  uint8_t   SDAI       :  1;               /*!< SDA Line Monitor                                                      */
      __I  uint8_t   SCLI       :  1;               /*!< SCL Line Monitor                                                      */
      __IO uint8_t   SDAO       :  1;               /*!< SDA Output Control/Monitor                                            */
      __IO uint8_t   SCLO       :  1;               /*!< SCL Output Control/Monitor                                            */
      __O  uint8_t   SOWP       :  1;               /*!< SCLO/SDAO Write Protect (This bit is read as 1.)                      */
      __IO uint8_t   CLO        :  1;               /*!< Extra SCL Clock Cycle Output                                          */
      __IO uint8_t   IICRST     :  1;               /*!< I2C Bus Interface Internal ResetNote:If an internal reset is
                                                         initiated using the IICRST bit for a bus hang-up occurred during
                                                          communication with the master device in slave mode, the states
                                                          may become different between the slave device and the master
                                                          device (due to the difference in the bit counter information).       */
      __IO uint8_t   ICE        :  1;               /*!< I2C Bus Interface Enable                                              */
    } ICCR1_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ICCR2;                           /*!< I2C Bus Control Register 2                                            */
    
    struct {
           uint8_t              :  1;
      __IO uint8_t   ST         :  1;               /*!< Start Condition Issuance RequestSet the ST bit to 1 (start condition
                                                         issuance request) when the BBSY flag is set to 0 (bus free state).    */
      __IO uint8_t   RS         :  1;               /*!< Restart Condition Issuance RequestNote: Do not set the RS bit
                                                         to 1 while issuing a stop condition.                                  */
      __IO uint8_t   SP         :  1;               /*!< Stop Condition Issuance RequestNote: Writing to the SP bit is
                                                         not possible while the setting of the BBSY flag is 0 (bus free
                                                          state).Note: Do not set the SP bit to 1 while a restart condition
                                                          is being issued.                                                     */
           uint8_t              :  1;
      __IO uint8_t   TRS        :  1;               /*!< Transmit/Receive Mode                                                 */
      __IO uint8_t   MST        :  1;               /*!< Master/Slave Mode                                                     */
      __I  uint8_t   BBSY       :  1;               /*!< Bus Busy Detection Flag                                               */
    } ICCR2_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ICMR1;                           /*!< I2C Bus Mode Register 1                                               */
    
    struct {
      __IO uint8_t   BC         :  3;               /*!< Bit Counter                                                           */
      __O  uint8_t   BCWP       :  1;               /*!< BC Write Protect(This bit is read as 1.)                              */
      __IO uint8_t   CKS        :  3;               /*!< Internal Reference Clock (fIIC) Selection ( fIIC = PCLKB / 2^CKS
                                                         )                                                                     */
      __IO uint8_t   MTWP       :  1;               /*!< MST/TRS Write Protect                                                 */
    } ICMR1_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ICMR2;                           /*!< I2C Bus Mode Register 2                                               */
    
    struct {
      __IO uint8_t   TMOS       :  1;               /*!< Timeout Detection Time Selection                                      */
      __IO uint8_t   TMOL       :  1;               /*!< Timeout L Count Control                                               */
      __IO uint8_t   TMOH       :  1;               /*!< Timeout H Count Control                                               */
           uint8_t              :  1;
      __IO uint8_t   SDDL       :  3;               /*!< SDA Output Delay Counter                                              */
      __IO uint8_t   DLCS       :  1;               /*!< SDA Output Delay Clock Source Selection                               */
    } ICMR2_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ICMR3;                           /*!< I2C Bus Mode Register 3                                               */
    
    struct {
      __IO uint8_t   NF         :  2;               /*!< Noise Filter Stage Selection                                          */
      __I  uint8_t   ACKBR      :  1;               /*!< Receive Acknowledge                                                   */
      __IO uint8_t   ACKBT      :  1;               /*!< Transmit Acknowledge                                                  */
      __IO uint8_t   ACKWP      :  1;               /*!< ACKBT Write Protect                                                   */
      __IO uint8_t   RDRFS      :  1;               /*!< RDRF Flag Set Timing Selection                                        */
      __IO uint8_t   WAIT       :  1;               /*!< WAITNote: When the value of the WAIT bit is to be read, be sure
                                                         to read the ICDRR beforehand.                                         */
      __IO uint8_t   SMBE       :  1;               /*!< SMBus/I2C Bus Selection                                               */
    } ICMR3_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ICFER;                           /*!< I2C Bus Function Enable Register                                      */
    
    struct {
      __IO uint8_t   TMOE       :  1;               /*!< Timeout Function Enable                                               */
      __IO uint8_t   MALE       :  1;               /*!< Master Arbitration-Lost Detection Enable                              */
      __IO uint8_t   NALE       :  1;               /*!< NACK Transmission Arbitration-Lost Detection Enable                   */
      __IO uint8_t   SALE       :  1;               /*!< Slave Arbitration-Lost Detection Enable                               */
      __IO uint8_t   NACKE      :  1;               /*!< NACK Reception Transfer Suspension Enable                             */
      __IO uint8_t   NFE        :  1;               /*!< Digital Noise Filter Circuit Enable                                   */
      __IO uint8_t   SCLE       :  1;               /*!< SCL Synchronous Circuit Enable                                        */
      __IO uint8_t   FMPE       :  1;               /*!< Fast-mode Plus Enable                                                 */
    } ICFER_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ICSER;                           /*!< I2C Bus Status Enable Register                                        */
    
    struct {
      __IO uint8_t   SAR0       :  1;               /*!< Slave Address Register 0 Enable                                       */
      __IO uint8_t   SAR1       :  1;               /*!< Slave Address Register 1 Enable                                       */
      __IO uint8_t   SAR2       :  1;               /*!< Slave Address Register 2 Enable                                       */
      __IO uint8_t   GCE        :  1;               /*!< General Call Address Enable                                           */
           uint8_t              :  1;
      __IO uint8_t   DIDE       :  1;               /*!< Device-ID Address Detection Enable                                    */
           uint8_t              :  1;
      __IO uint8_t   HOAE       :  1;               /*!< Host Address Enable                                                   */
    } ICSER_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ICIER;                           /*!< I2C Bus Interrupt Enable Register                                     */
    
    struct {
      __IO uint8_t   TMOIE      :  1;               /*!< Timeout Interrupt Request Enable                                      */
      __IO uint8_t   ALIE       :  1;               /*!< Arbitration-Lost Interrupt Request Enable                             */
      __IO uint8_t   STIE       :  1;               /*!< Start Condition Detection Interrupt Request Enable                    */
      __IO uint8_t   SPIE       :  1;               /*!< Stop Condition Detection Interrupt Request Enable                     */
      __IO uint8_t   NAKIE      :  1;               /*!< NACK Reception Interrupt Request Enable                               */
      __IO uint8_t   RIE        :  1;               /*!< Receive Data Full Interrupt Request Enable                            */
      __IO uint8_t   TEIE       :  1;               /*!< Transmit End Interrupt Request Enable                                 */
      __IO uint8_t   TIE        :  1;               /*!< Transmit Data Empty Interrupt Request Enable                          */
    } ICIER_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ICSR1;                           /*!< I2C Bus Status Register 1                                             */

    struct {
      __IO uint8_t   AAS0   :  1;                   /*!< Slave Address 0 Detection Flag                                        */
      __IO uint8_t   AAS1   :  1;                   /*!< Slave Address 1 Detection Flag                                        */
      __IO uint8_t   AAS2   :  1;                   /*!< Slave Address 2 Detection Flag                                        */
      __IO uint8_t   ADZ    :  1;                   /*!< General Call Address Detection Flag                                   */
           uint8_t          :  1;
      __IO uint8_t   DID    :  1;                   /*!< Device-ID Address Detection Flag                                      */
           uint8_t          :  1;
      __IO uint8_t   HOA    :  1;                   /*!< Host Address Detection Flag                                           */
    } ICSR1_b;                                      /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   ICSR2;                           /*!< I2C Bus Status Register 2                                             */

    struct {
      __IO uint8_t   TMOF   :  1;                   /*!< Timeout Detection Flag                                                */
      __IO uint8_t   AL     :  1;                   /*!< Arbitration-Lost Flag                                                 */
      __IO uint8_t   START  :  1;                   /*!< Start Condition Detection Flag                                        */
      __IO uint8_t   STOP   :  1;                   /*!< Stop Condition Detection Flag                                         */
      __IO uint8_t   NACKF  :  1;                   /*!< NACK Detection Flag                                                   */
      __IO uint8_t   RDRF   :  1;                   /*!< Receive Data Full Flag                                                */
      __IO uint8_t   TEND   :  1;                   /*!< Transmit End Flag                                                     */
      __I  uint8_t   TDRE   :  1;                   /*!< Transmit Data Empty Flag                                              */
    } ICSR2_b;                                      /*!< BitSize                                                               */
  };

  R_IIC0_SARLnRC0_Type SARLnRC0[3];                 /*!< Slave Address Register L%s                                            */
  
  union {
    __IO uint8_t   ICBRL;                           /*!< I2C Bus Bit Rate Low-Level Register                                   */
    
    struct {
      __IO uint8_t   BRL        :  5;               /*!< Bit Rate Low-Level Period(Low-level period of SCL clock)              */
    } ICBRL_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ICBRH;                           /*!< I2C Bus Bit Rate High-Level Register                                  */
    
    struct {
      __IO uint8_t   BRH        :  5;               /*!< Bit Rate High-Level Period(High-level period of SCL clock)            */
    } ICBRH_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ICDRT;                           /*!< I2C Bus Transmit Data Register                                        */
    
    struct {
      __IO uint8_t   ICDRT      :  8;               /*!< 8-bit read-write register that stores transmit data.                  */
    } ICDRT_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __I  uint8_t   ICDRR;                           /*!< I2C Bus Receive Data Register                                         */
    
    struct {
      __I  uint8_t   ICDRR      :  8;               /*!< 8-bit register that stores the received data                          */
    } ICDRR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED1[2];   // Padding changed from uint16_t
  
  union {
    __IO uint8_t   ICWUR;                           /*!< I2C Bus Wake Up Unit Register                                         */
    
    struct {
      __IO uint8_t   WUAFA      :  1;               /*!< Wake-Up Analog Filter Additional Selection                            */
           uint8_t              :  2;
      __I  uint8_t   WUBFR      :  1;               /*!< Bus Free During Wake-Up Mode                                          */
      __IO uint8_t   WUACK      :  1;               /*!< Asynchronous/Synchronous Operation State Flag                         */
      __IO uint8_t   WUF        :  1;               /*!< Wake-Up Event Occurrence Flag                                         */
      __IO uint8_t   WUIE       :  1;               /*!< Wake Up Interrupt Request Enable                                      */
      __IO uint8_t   WUE        :  1;               /*!< Wake Up function Enable                                               */
    } ICWUR_b;                                      /*!< BitSize                                                               */
  };
} R_IIC0_Type;


/* ================================================================================ */
/* ================                      R_DOC                     ================ */
/* ================================================================================ */


/**
  * @brief Data Operation Circuit (R_DOC)
  */

typedef struct {                                    /*!< R_DOC Structure                                                       */
  
  union {
    __IO uint8_t   DOCR;                            /*!< DOC Control Register                                                  */
    
    struct {
      __IO uint8_t   OMS        :  2;               /*!< Operating Mode Select                                                 */
      __IO uint8_t   DCSEL      :  1;               /*!< Detection Condition Select Result of data comparison. Note:
                                                         Valid only when data comparison mode is selected.                     */
           uint8_t              :  2;
      __I  uint8_t   DOPCF      :  1;               /*!< Data Operation Circuit FlagIndicates the result of an operation.      */
      __IO uint8_t   DOPCFCL    :  1;               /*!< DOPCF Clear                                                           */
    } DOCR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED;
  
  union {
    __IO uint16_t  DODIR;                           /*!< DOC Data Input Register                                               */
    
    struct {
      __IO uint16_t  DODIR      : 16;               /*!< 16-bit read-write register in which 16-bit data for use in the
                                                         operations are stored.                                                */
    } DODIR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  DODSR;                           /*!< DOC Data Setting Register                                             */
    
    struct {
      __IO uint16_t  DODSR      : 16;               /*!< This register stores 16-bit data for use as a reference in data
                                                         comparison mode. This register also stores the results of operations
                                                          in data addition and data subtraction modes.                         */
    } DODSR_b;                                      /*!< BitSize                                                               */
  };
} R_DOC_Type;


/* ================================================================================ */
/* ================                    R_S12ADC0                   ================ */
/* ================================================================================ */


/**
  * @brief 12bit A/D Converter 0 (R_S12ADC0)
  */

typedef struct {                                    /*!< R_S12ADC0 Structure                                                   */
  
  union {
    __IO uint16_t  ADCSR;                           /*!< A/D Control Register                                                  */
    
    struct {
      __IO uint16_t  DBLANS     :  5;               /*!< Double Trigger Channel SelectThese bits select one analog input
                                                         channel for double triggered operation. The setting is only
                                                          effective while double trigger mode is selected.                     */
           uint16_t             :  1;
      __IO uint16_t  GBADIE     :  1;               /*!< Group B Scan End Interrupt Enable                                     */
      __IO uint16_t  DBLE       :  1;               /*!< Double Trigger Mode Select                                            */
      __IO uint16_t  EXTRG      :  1;               /*!< Trigger Select                                                        */
      __IO uint16_t  TRGE       :  1;               /*!< Trigger Start Enable                                                  */
           uint16_t             :  3;
      __IO uint16_t  ADCS       :  2;               /*!< Scan Mode Select                                                      */
      __IO uint16_t  ADST       :  1;               /*!< A/D Conversion Start                                                  */
    } ADCSR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  ADANSA0;                         /*!< A/D Channel Select Register A0                                        */
    
    struct {
      __IO uint16_t  ANSA00     :  1;               /*!< AN000 Select                                                          */
      __IO uint16_t  ANSA01     :  1;               /*!< AN001 Select                                                          */
      __IO uint16_t  ANSA02     :  1;               /*!< AN002 Select                                                          */
      __IO uint16_t  ANSA03     :  1;               /*!< AN003 Select                                                          */
      __IO uint16_t  ANSA04     :  1;               /*!< AN004 Select                                                          */
      __IO uint16_t  ANSA05     :  1;               /*!< AN005 Select                                                          */
      __IO uint16_t  ANSA06     :  1;               /*!< AN006 Select                                                          */
    } ADANSA0_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADANSA1;                         /*!< A/D Channel Select Register A1                                        */
    
    struct {
      __IO uint16_t  ANSA16     :  1;               /*!< AN016 Select                                                          */
      __IO uint16_t  ANSA17     :  1;               /*!< AN017 Select                                                          */
      __IO uint16_t  ANSA18     :  1;               /*!< AN018 Select                                                          */
      __IO uint16_t  ANSA19     :  1;               /*!< AN019 Select                                                          */
      __IO uint16_t  ANSA20     :  1;               /*!< AN020 Select                                                          */
      __IO uint16_t  ANSA21     :  1;               /*!< AN021 Select                                                          */
    } ADANSA1_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADADS0;                          /*!< A/D-Converted Value Addition/Average Channel Select Register
                                                         0                                                                     */
    
    struct {
      __IO uint16_t  ADS00      :  1;               /*!< A/D-Converted Value Addition/Average Channel AN000 Select             */
      __IO uint16_t  ADS01      :  1;               /*!< A/D-Converted Value Addition/Average Channel AN001 Select             */
      __IO uint16_t  ADS02      :  1;               /*!< A/D-Converted Value Addition/Average Channel AN002 Select             */
      __IO uint16_t  ADS03      :  1;               /*!< A/D-Converted Value Addition/Average Channel AN003 Select             */
      __IO uint16_t  ADS04      :  1;               /*!< A/D-Converted Value Addition/Average Channel AN004 Select             */
      __IO uint16_t  ADS05      :  1;               /*!< A/D-Converted Value Addition/Average Channel AN005 Select             */
      __IO uint16_t  ADS06      :  1;               /*!< A/D-Converted Value Addition/Average Channel AN006 Select             */
    } ADADS0_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADADS1;                          /*!< A/D-Converted Value Addition/Average Channel Select Register
                                                         1                                                                     */
    
    struct {
      __IO uint16_t  ADS16      :  1;               /*!< A/D-Converted Value Addition/Average Channel AN016 Select             */
      __IO uint16_t  ADS17      :  1;               /*!< A/D-Converted Value Addition/Average Channel AN017 Select             */
      __IO uint16_t  ADS18      :  1;               /*!< A/D-Converted Value Addition/Average Channel AN018 Select             */
      __IO uint16_t  ADS19      :  1;               /*!< A/D-Converted Value Addition/Average Channel AN019 Select             */
      __IO uint16_t  ADS20      :  1;               /*!< A/D-Converted Value Addition/Average Channel AN020 Select             */
      __IO uint16_t  ADS21      :  1;               /*!< A/D-Converted Value Addition/Average Channel AN021 Select             */
    } ADADS1_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ADADC;                           /*!< A/D-Converted Value Addition/Average Count Select Register            */
    
    struct {
      __IO uint8_t   ADC        :  3;               /*!< Addition frequency selection bit.NOTE: AVEE bit is valid at
                                                         the only setting of ADC[2:0] bits = 001b or 011b. When average
                                                          mode is selected by setting the ADADC.AVEE bit to 1, do not
                                                          set the addition count to three times (ADADC.ADC[2:0] = 010b)        */
           uint8_t              :  4;
      __IO uint8_t   AVEE       :  1;               /*!< Average mode enable bit.Note: The AVEE bit converts twice, and
                                                         only when converting it four times, is effective. Please do
                                                          not set (ADADC.AVEE=1) to conversion (ADADC.ADC 2:0=010b) three
                                                          times when you select the average mode.                              */
    } ADADC_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED1;
  
  union {
    __IO uint16_t  ADCER;                           /*!< A/D Control Extended Register                                         */
    
    struct {
           uint16_t             :  1;
      __IO uint16_t  ADPRC      :  2;               /*!< A/D Conversion Accuracy Specify                                       */
           uint16_t             :  2;
      __IO uint16_t  ACE        :  1;               /*!< A/D Data Register Automatic Clearing Enable                           */
           uint16_t             :  2;
      __IO uint16_t  DIAGVAL    :  2;               /*!< Self-Diagnosis Conversion Voltage Select                              */
      __IO uint16_t  DIAGLD     :  1;               /*!< Self-Diagnosis Mode Select                                            */
      __IO uint16_t  DIAGM      :  1;               /*!< Self-Diagnosis Enable                                                 */
           uint16_t             :  3;
      __IO uint16_t  ADRFMT     :  1;               /*!< A/D Data Register Format Select                                       */
    } ADCER_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADSTRGR;                         /*!< A/D Conversion Start Trigger Select Register                          */
    
    struct {
      __IO uint16_t  TRSB       :  6;               /*!< A/D Conversion Start Trigger Select for Group BSelect the A/D
                                                         conversion start trigger for group B in group scan mode.              */
           uint16_t             :  2;
      __IO uint16_t  TRSA       :  6;               /*!< A/D Conversion Start Trigger SelectSelect the A/D conversion
                                                         start trigger in single scan mode and continuous mode. In group
                                                          scan mode, the A/D conversion start trigger for group A is selected. */
    } ADSTRGR_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADEXICR;                         /*!< A/D Conversion Extended Input Control Register                        */
    
    struct {
      __IO uint16_t  TSSAD      :  1;               /*!< Temperature Sensor Output A/D converted Value Addition/Average
                                                         Mode Select                                                           */
      __IO uint16_t  OCSAD      :  1;               /*!< Internal Reference Voltage A/D converted Value Addition/Average
                                                         Mode Select                                                           */
           uint16_t             :  6;
      __IO uint16_t  TSSA       :  1;               /*!< Temperature Sensor Output A/D Conversion Select                       */
      __IO uint16_t  OCSA       :  1;               /*!< Internal Reference Voltage A/D Conversion Select                      */
      __IO uint16_t  TSSB       :  1;               /*!< Temperature Sensor Output A/D Conversion Select for Group B           */
      __IO uint16_t  OCSB       :  1;               /*!< Internal Reference Voltage A/D Conversion Select for Group B          */
    } ADEXICR_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADANSB0;                         /*!< A/D Channel Select Register B0                                        */
    
    struct {
      __IO uint16_t  ANSB00     :  1;               /*!< AN000 Select                                                          */
      __IO uint16_t  ANSB01     :  1;               /*!< AN001 Select                                                          */
      __IO uint16_t  ANSB02     :  1;               /*!< AN002 Select                                                          */
      __IO uint16_t  ANSB03     :  1;               /*!< AN003 Select                                                          */
      __IO uint16_t  ANSB04     :  1;               /*!< AN004 Select                                                          */
      __IO uint16_t  ANSB05     :  1;               /*!< AN005 Select                                                          */
      __IO uint16_t  ANSB06     :  1;               /*!< AN006 Select                                                          */
    } ADANSB0_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADANSB1;                         /*!< A/D Channel Select Register B1                                        */
    
    struct {
      __IO uint16_t  ANSB16     :  1;               /*!< AN016 Select                                                          */
      __IO uint16_t  ANSB17     :  1;               /*!< AN017 Select                                                          */
      __IO uint16_t  ANSB18     :  1;               /*!< AN018 Select                                                          */
      __IO uint16_t  ANSB19     :  1;               /*!< AN019 Select                                                          */
      __IO uint16_t  ANSB20     :  1;               /*!< AN020 Select                                                          */
      __IO uint16_t  ANSB21     :  1;               /*!< AN021 Select                                                          */
    } ADANSB1_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __I  uint16_t  ADDBLDR;                         /*!< A/D Data Duplication Register                                         */
    
    struct {
      __I  uint16_t  ADDBLDR    : 16;               /*!< This is a 16-bit read-only register for storing the result of
                                                         A/D conversion in response to the second trigger in double trigger
                                                          mode.                                                                */
    } ADDBLDR_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __I  uint16_t  ADTSDR;                          /*!< A/D Temperature Sensor Data Register                                  */
    
    struct {
      __I  uint16_t  ADTSDR     : 16;               /*!< This is a 16-bit read-only register for storing the A/D conversion
                                                         result of temperature sensor output.                                  */
    } ADTSDR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __I  uint16_t  ADOCDR;                          /*!< A/D Internal Reference Voltage Data Register                          */
    
    struct {
      __I  uint16_t  ADOCDR     : 16;               /*!< This is a 16-bit read-only register for storing the A/D result
                                                         of internal reference voltage.                                        */
    } ADOCDR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __I  uint16_t  ADRD;                            /*!< A/D Self-Diagnosis Data Register                                      */
    
    struct {
      __I  uint16_t  AD         : 12;               /*!< A/D-converted value (right-justified)NOTE: Unused bits in the
                                                         AD bit field are fixed "0"                                            */
           uint16_t             :  2;
      __I  uint16_t  DIAGST     :  2;               /*!< Self-Diagnosis Status                                                 */
    } ADRD_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __I  uint16_t  ADDRn[32];                       /*!< A/D Data Register %s                                                  */
    
    struct {
      __I  uint16_t  ADDR       : 16;               /*!< The ADDR register is a 16-bit read-only registers for storing
                                                         the result of A/D conversion.                                         */
    } ADDRn_b[32];                                  /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED2[3 * 2];
  
  union {
    __IO uint16_t  ADSHCR;                          /*!< A/D Sample and Hold Circuit Control Register                          */
    
    struct {
      __IO uint16_t  SSTSH      :  8;               /*!< Channel-Dedicated Sample-and-Hold Circuit Sampling Time Setting
                                                         Set the sampling time (4 to 255 states)                               */
      __IO uint16_t  SHANS0     :  1;               /*!< ANn00 sample-and-hold circuit Select                                  */
      __IO uint16_t  SHANS1     :  1;               /*!< ANn01 sample-and-hold circuit Select                                  */
      __IO uint16_t  SHANS2     :  1;               /*!< ANn02 sample-and-hold circuit Select                                  */
    } ADSHCR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED3[9 * 2];
  
  union {
    __IO uint8_t   ADDISCR;                         /*!< A/D Disconnection Detection Control Register                          */
    
    struct {
      __IO uint8_t   ADNDIS     :  4;               /*!< The charging time                                                     */
      __IO uint8_t   CHARGE     :  1;               /*!< Selection of Precharge or Discharge                                   */
    } ADDISCR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED4;
  
  union {
    __IO uint8_t   ADSHMSR;                         /*!< A/D Sample and Hold Operation Mode Select Register                    */
    
    struct {
      __IO uint8_t   SHMD       :  1;               /*!< Channel-Dedicated Sample-and-Hold Circuit Operation Mode Select       */
    } ADSHMSR_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ADELCCR;                         /*!< A/D Event Link Control Register                                       */
    
    struct {
      __IO uint8_t   ELCC       :  2;               /*!< Event Link Control                                                    */
    } ADELCCR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED5[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  ADGSPCR;                         /*!< A/D Group Scan Priority Control Register                              */
    
    struct {
      __IO uint16_t  PGS        :  1;               /*!< Group A priority control setting bit.Note: When the PGS bit
                                                         is to be set to 1, the ADCSR.ADCS[1:0] bits must be set to 01b
                                                          (group scan mode). If the bits are set to any other values,
                                                          proper operation is not guaranteed.                                  */
      __IO uint16_t  GBRSCN     :  1;               /*!< Group B Restart Setting(Enabled only when PGS = 1. Reserved
                                                         when PGS = 0.)                                                        */
           uint16_t             : 13;
      __IO uint16_t  GBRP       :  1;               /*!< Group B Single Scan Continuous Start(Enabled only when PGS =
                                                         1. Reserved when PGS = 0.)Note: When the GBRP bit has been set
                                                          to 1, single scan is performed continuously for group B regardless
                                                          of the setting of the GBRSCN bit.                                    */
    } ADGSPCR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED6[2];   // Padding changed from uint16_t
  
  union {
    __I  uint16_t  ADDBLDRA;                        /*!< A/D Data Duplication Register A                                       */
    
    struct {
      __I  uint16_t  ADDBLDRA   : 16;               /*!< This register is a 16-bit read-only registers for storing the
                                                         result of A/D conversion in response to the respective triggers
                                                          during extended operation in double trigger mode.                    */
    } ADDBLDRA_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __I  uint16_t  ADDBLDRB;                        /*!< A/D Data Duplication Register B                                       */
    
    struct {
      __I  uint16_t  ADDBLDRB   : 16;               /*!< This register is a 16-bit read-only registers for storing the
                                                         result of A/D conversion in response to the respective triggers
                                                          during extended operation in double trigger mode.                    */
    } ADDBLDRB_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED7[4];   // Padding changed from uint32_t
  
  union {
    __IO uint8_t   ADWINMON;                        /*!< A/D Compare Function Window A/B Status Monitor Register               */
    
    struct {
      __IO uint8_t   MONCOMB    :  1;               /*!< Combination result monitorThis bit indicates the combination
                                                         result.This bit is valid when both window A operation and window
                                                          B operation are enabled.                                             */
           uint8_t              :  3;
      __IO uint8_t   MONCMPA    :  1;               /*!< Comparison Result Monitor A                                           */
      __IO uint8_t   MONCMPB    :  1;               /*!< Comparison Result Monitor B                                           */
    } ADWINMON_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED8[3];
  
  union {
    __IO uint16_t  ADCMPCR;                         /*!< A/D Compare Function Control Register                                 */
    
    struct {
      __IO uint16_t  CMPAB      :  2;               /*!< Window A/B Composite Conditions SettingNOTE: These bits are
                                                         valid when both window A and window B are enabled (CMPAE = 1
                                                          and CMPBE = 1).                                                      */
           uint16_t             :  7;
      __IO uint16_t  CMPBE      :  1;               /*!< Compare Window B Operation Enable                                     */
           uint16_t             :  1;
      __IO uint16_t  CMPAE      :  1;               /*!< Compare Window A Operation Enable                                     */
           uint16_t             :  1;
      __IO uint16_t  CMPBIE     :  1;               /*!< Compare B Interrupt Enable                                            */
      __IO uint16_t  WCMPE      :  1;               /*!< Window Function Setting                                               */
      __IO uint16_t  CMPAIE     :  1;               /*!< Compare A Interrupt Enable                                            */
    } ADCMPCR_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ADCMPANSER;                      /*!< A/D Compare Function Window A Extended Input Select Register          */
    
    struct {
      __IO uint8_t   CMPTSA     :  1;               /*!< Temperature sensor output Compare selection bit.                      */
      __IO uint8_t   CMPOCA     :  1;               /*!< Internal reference voltage Compare selection bit.                     */
    } ADCMPANSER_b;                                 /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ADCMPLER;                        /*!< A/D Compare Function Window A Extended Input Comparison Condition
                                                         Setting Register                                                      */
    
    struct {
      __IO uint8_t   CMPLTSA    :  1;               /*!< Compare Window A Temperature Sensor Output Comparison Condition
                                                         Select                                                                */
      __IO uint8_t   CMPLOCA    :  1;               /*!< Compare Window A Internal Reference Voltage ComparisonCondition
                                                         Select                                                                */
    } ADCMPLER_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADCMPANSR0;                      /*!< A/D Compare Function Window A Channel Select Register 0               */
    
    struct {
      __IO uint16_t  CMPCHA00   :  1;               /*!< AN000 Select                                                          */
      __IO uint16_t  CMPCHA01   :  1;               /*!< AN001 Select                                                          */
      __IO uint16_t  CMPCHA02   :  1;               /*!< AN002 Select                                                          */
      __IO uint16_t  CMPCHA03   :  1;               /*!< AN003 Select                                                          */
      __IO uint16_t  CMPCHA04   :  1;               /*!< AN004 Select                                                          */
      __IO uint16_t  CMPCHA05   :  1;               /*!< AN005 Select                                                          */
      __IO uint16_t  CMPCHA06   :  1;               /*!< AN006 Select                                                          */
    } ADCMPANSR0_b;                                 /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADCMPANSR1;                      /*!< A/D Compare Function Window A Channel Select Register 1               */
    
    struct {
      __IO uint16_t  CMPCHA16   :  1;               /*!< AN016 Select                                                          */
      __IO uint16_t  CMPCHA17   :  1;               /*!< AN017 Select                                                          */
      __IO uint16_t  CMPCHA18   :  1;               /*!< AN018 Select                                                          */
      __IO uint16_t  CMPCHA19   :  1;               /*!< AN019 Select                                                          */
      __IO uint16_t  CMPCHA20   :  1;               /*!< AN020 Select                                                          */
      __IO uint16_t  CMPCHA21   :  1;               /*!< AN021 Select                                                          */
    } ADCMPANSR1_b;                                 /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADCMPLR0;                        /*!< A/D Compare Function Window A Comparison Condition Setting Register
                                                         0                                                                     */
    
    struct {
      __IO uint16_t  CMPLCHA00  :  1;               /*!< Comparison condition of AN000                                         */
      __IO uint16_t  CMPLCHA01  :  1;               /*!< Comparison condition of AN001                                         */
      __IO uint16_t  CMPLCHA02  :  1;               /*!< Comparison condition of AN002                                         */
      __IO uint16_t  CMPLCHA03  :  1;               /*!< Comparison condition of AN003                                         */
      __IO uint16_t  CMPLCHA04  :  1;               /*!< Comparison condition of AN004                                         */
      __IO uint16_t  CMPLCHA05  :  1;               /*!< Comparison condition of AN005                                         */
      __IO uint16_t  CMPLCHA06  :  1;               /*!< Comparison condition of AN006                                         */
    } ADCMPLR0_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADCMPLR1;                        /*!< A/D Compare Function Window A Comparison Condition Setting Register
                                                         1                                                                     */
    
    struct {
      __IO uint16_t  CMPLCHA16  :  1;               /*!< Comparison condition of AN016                                         */
      __IO uint16_t  CMPLCHA17  :  1;               /*!< Comparison condition of AN017                                         */
      __IO uint16_t  CMPLCHA18  :  1;               /*!< Comparison condition of AN018                                         */
      __IO uint16_t  CMPLCHA19  :  1;               /*!< Comparison condition of AN019                                         */
      __IO uint16_t  CMPLCHA20  :  1;               /*!< Comparison condition of AN020                                         */
      __IO uint16_t  CMPLCHA21  :  1;               /*!< Comparison condition of AN021                                         */
    } ADCMPLR1_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADCMPDR0;                        /*!< A/D Compare Function Window A Lower-Side Level Setting Register       */
    
    struct {
      __IO uint16_t  ADCMPDR0   : 16;               /*!< The ADCMPDR0 register sets the reference data when the compare
                                                         window A function is used. ADCMPDR0 sets the lower-side level
                                                          of window A.                                                         */
    } ADCMPDR0_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADCMPDR1;                        /*!< A/D Compare Function Window A Upper-Side Level Setting Register       */
    
    struct {
      __IO uint16_t  ADCMPDR1   : 16;               /*!< The ADCMPDR1 register sets the reference data when the compare
                                                         window A function is used. ADCMPDR1 sets the upper-side level
                                                          of window A..                                                        */
    } ADCMPDR1_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADCMPSR0;                        /*!< A/D Compare Function Window A Channel Status Register 0               */
    
    struct {
      __IO uint16_t  CMPSTCHA00 :  1;               /*!< Compare window A flag of AN000                                        */
      __IO uint16_t  CMPSTCHA01 :  1;               /*!< Compare window A flag of AN001                                        */
      __IO uint16_t  CMPSTCHA02 :  1;               /*!< Compare window A flag of AN002                                        */
      __IO uint16_t  CMPSTCHA03 :  1;               /*!< Compare window A flag of AN003                                        */
      __IO uint16_t  CMPSTCHA04 :  1;               /*!< Compare window A flag of AN004                                        */
      __IO uint16_t  CMPSTCHA05 :  1;               /*!< Compare window A flag of AN005                                        */
      __IO uint16_t  CMPSTCHA06 :  1;               /*!< Compare window A flag of AN006                                        */
    } ADCMPSR0_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADCMPSR1;                        /*!< A/D Compare Function Window A Channel Status Register 1               */
    
    struct {
      __IO uint16_t  CMPSTCHA16 :  1;               /*!< Compare window A flag of AN016                                        */
      __IO uint16_t  CMPSTCHA17 :  1;               /*!< Compare window A flag of AN017                                        */
      __IO uint16_t  CMPSTCHA18 :  1;               /*!< Compare window A flag of AN018                                        */
      __IO uint16_t  CMPSTCHA19 :  1;               /*!< Compare window A flag of AN019                                        */
      __IO uint16_t  CMPSTCHA20 :  1;               /*!< Compare window A flag of AN020                                        */
      __IO uint16_t  CMPSTCHA21 :  1;               /*!< Compare window A flag of AN021                                        */
    } ADCMPSR1_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ADCMPSER;                        /*!< A/D Compare Function Window A Extended Input Channel Status
                                                         Register                                                              */
    
    struct {
      __IO uint8_t   CMPSTTSA   :  1;               /*!< Compare window A Temperature Sensor Output Compare FlagWhen
                                                         window A operation is enabled (ADCMPCR.CMPAE = 1b), this bit
                                                          indicates the temperature sensor output comparison result. When
                                                          window A operation is disabled (ADCMPCR.CMPAE = 0b), comparison
                                                          conditions for CMPSTTSA are not met any time.                        */
      __IO uint8_t   CMPSTOCA   :  1;               /*!< Compare Window A Internal Reference Voltage Compare FlagWhen
                                                         window A operation is enabled (ADCMPCR.CMPAE = 1b), this bit
                                                          indicates the temperature sensor output comparison result. When
                                                          window A operation is disabled (ADCMPCR.CMPAE = 0b), comparison
                                                          conditions for CMPSTTSA are not met any time.                        */
    } ADCMPSER_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED9;
  
  union {
    __IO uint8_t   ADCMPBNSR;                       /*!< A/D Compare Function Window B Channel Selection Register              */
    
    struct {
      __IO uint8_t   CMPCHB     :  6;               /*!< Compare window B channel selection bit.The channel that compares
                                                         it on the condition of compare window B is selected.                  */
           uint8_t              :  1;
      __IO uint8_t   CMPLB      :  1;               /*!< Compare window B Compare condition setting bit.                       */
    } ADCMPBNSR_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED10;
  
  union {
    __IO uint16_t  ADWINLLB;                        /*!< A/D Compare Function Window B Lower-Side Level Setting Register       */
    
    struct {
      __IO uint16_t  ADWINLLB   : 16;               /*!< This register is used to compare A window function is used to
                                                         set the lower level of the window B.                                  */
    } ADWINLLB_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADWINULB;                        /*!< A/D Compare Function Window B Upper-Side Level Setting Register       */
    
    struct {
      __IO uint16_t  ADWINULB   : 16;               /*!< This register is used to compare A window function is used to
                                                         set the higher level of the window B.                                 */
    } ADWINULB_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADCMPBSR;                        /*!< A/D Compare Function Window B Status Register                         */
    
    struct {
      __IO uint16_t  CMPSTB     :  1;               /*!< Compare window B flag.It is a status flag that shows the comparative
                                                         result of CH (AN000-AN006,AN016-AN021, temperature sensor, and
                                                          internal reference voltage) made the object of window B relation
                                                          condition.                                                           */
    } ADCMPBSR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED11[2];   // Padding changed from uint16_t
  
  union {
    __I  uint16_t  ADBUFn[16];                      /*!< A/D Data Buffer Register [%s]                                         */
    
    struct {
      __I  uint16_t  ADBUF      : 16;               /*!< A/D data buffer registers (ADBUF) are 16-bit read-only registers
                                                         that sequentially store all A/D converted values. The automatic
                                                          clear function is not applied to these registers.                    */
    } ADBUFn_b[16];                                 /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ADBUFEN;                         /*!< A/D Data Buffer Enable Register                                       */
    
    struct {
      __IO uint8_t   BUFEN      :  1;               /*!< Data Buffer Enable                                                    */
    } ADBUFEN_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t   RESERVED12;
  
  union {
    __IO uint8_t   ADBUFPTR;                        /*!< A/D Data Buffer Pointer Register                                      */
    
    struct {
      __I  uint8_t   BUFPTR     :  4;               /*!< Data Buffer PointerThese bits indicate the number of data buffer
                                                         to which the next A/D converted data is transferred.                  */
      __I  uint8_t   PTROVF     :  1;               /*!< Pointer Overflow Flag                                                 */
    } ADBUFPTR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED13[5 * 2];
  
  union {
    __IO uint8_t   ADSSTRL;                         /*!< A/D Sampling State Register L                                         */
    
    struct {
      __IO uint8_t   SST        :  8;               /*!< Sampling Time Setting (AN016-AN021)                                   */
    } ADSSTRL_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ADSSTRT;                         /*!< A/D Sampling State Register T                                         */
    
    struct {
      __IO uint8_t   SST        :  8;               /*!< Sampling Time Setting (temperature sensor output)                     */
    } ADSSTRT_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ADSSTRO;                         /*!< A/D Sampling State Register O                                         */
    
    struct {
      __IO uint8_t   SST        :  8;               /*!< Sampling Time Setting (Internal reference voltage)                    */
    } ADSSTRO_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ADSSTR0n[7];                     /*!< A/D Sampling State Register %s (Corresponding Channel is AN00%s
                                                         )                                                                     */
    
    struct {
      __IO uint8_t   SST        :  8;               /*!< Sampling time setting                                                 */
    } ADSSTR0n_b[7];                                /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED14[92 * 2];
  
  union {
    __IO uint16_t  ADPGACR;                         /*!< A/D Programmable Gain Amplifier Control Register                      */
    
    struct {
      __IO uint16_t  P000SEL0   :  1;               /*!< A through amplifier is enable for PGA P000                            */
      __IO uint16_t  P000SEL1   :  1;               /*!< The amplifier passing is enable for PGA P000                          */
      __IO uint16_t  P000ENAMP  :  1;               /*!< Amplifier enable bit for PGA P000                                     */
      __IO uint16_t  P000GEN    :  1;               /*!< PGA P000 gain setting and enable bit                                  */
      __IO uint16_t  P001SEL0   :  1;               /*!< A through amplifier is enable for PGA P001                            */
      __IO uint16_t  P001SEL1   :  1;               /*!< The amplifier passing is enable for PGA P001                          */
      __IO uint16_t  P001ENAMP  :  1;               /*!< Amplifier enable bit for PGA P001                                     */
      __IO uint16_t  P001GEN    :  1;               /*!< PGA P001 gain setting and enable bit                                  */
      __IO uint16_t  P002SEL0   :  1;               /*!< A through amplifier is enable for PGA P002                            */
      __IO uint16_t  P002SEL1   :  1;               /*!< The amplifier passing is enable for PGA P002                          */
      __IO uint16_t  P002ENAMP  :  1;               /*!< Amplifier enable bit for PGA P002                                     */
      __IO uint16_t  P002GEN    :  1;               /*!< PGA P002 gain setting and enable bit                                  */
      __IO uint16_t  P003SEL0   :  1;               /*!< A through amplifier is enable for PGA P003                            */
      __IO uint16_t  P003SEL1   :  1;               /*!< The amplifier passing is enable for PGA P003                          */
      __IO uint16_t  P003ENAMP  :  1;               /*!< Amplifier enable bit for PGA P003                                     */
      __IO uint16_t  P003GEN    :  1;               /*!< PGA P003 gain setting and enable bit                                  */
    } ADPGACR_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  ADPGAGS0;                        /*!< A/D Programmable Gain Amplifier Gain Setting Register 0               */
    
    struct {
      __IO uint16_t  P000GAIN   :  4;               /*!< PGA P000 gain setting bit.The gain magnification of (ADPGSDCR0.P000GEN=0b)
                                                         when the shingle end is input and each PGA P000 is set. When
                                                          the differential motion is input, (ADPGSDCR0.P000GEN=1b) sets
                                                          the gain magnification when the differential motion is input
                                                          by the combination with ADPGSDCR0.P000DG 1:0.                        */
      __IO uint16_t  P001GAIN   :  4;               /*!< PGA P001 gain setting bit.The gain magnification of (ADPGSDCR0.P001GEN=0b)
                                                         when the shingle end is input and each PGA P001 is set. When
                                                          the differential motion is input, (ADPGSDCR0.P001GEN=1b) sets
                                                          the gain magnification when the differential motion is input
                                                          by the combination with ADPGSDCR0.P001DG 1:0.                        */
      __IO uint16_t  P002GAIN   :  4;               /*!< PGA P002 gain setting bit.The gain magnification of (ADPGSDCR0.P002GEN=0b)
                                                         when the shingle end is input and each PGA P002 is set. When
                                                          the differential motion is input, (ADPGSDCR0.P002GEN=1b) sets
                                                          the gain magnification when the differential motion is input
                                                          by the combination with ADPGSDCR0.P002DG 1:0.                        */
      __IO uint16_t  P003GAIN   :  4;               /*!< PGA P003 gain setting bit.The gain magnification of (ADPGSDCR0.P003GEN=0b)
                                                         when the shingle end is input and each PGA P003 is set. When
                                                          the differential motion is input, (ADPGSDCR0.P003GEN=1b) sets
                                                          the gain magnification when the differential motion is input
                                                          by the combination with ADPGSDCR0.P003DG 1:0.                        */
    } ADPGAGS0_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED15[3 * 4];
  
  union {
    __IO uint16_t  ADPGADCR0;                       /*!< A/D Programmable Gain Amplifier Differential Input Control Register   */
    
    struct {
      __IO uint16_t  P000DG     :  2;               /*!< P000 Differential Input Gain SettingNOTE: When these bits are
                                                         used, set {P000DEN, P000GEN} to 11b.                                  */
           uint16_t             :  1;
      __IO uint16_t  P000DEN    :  1;               /*!< P000 Differential Input Enable                                        */
      __IO uint16_t  P001DG     :  2;               /*!< P001 Differential Input Gain SettingNOTE: When these bits are
                                                         used, set {P001DEN, P001GEN} to 11b.                                  */
           uint16_t             :  1;
      __IO uint16_t  P001DEN    :  1;               /*!< P001 Differential Input Enable                                        */
      __IO uint16_t  P002DG     :  2;               /*!< P002 Differential Input Gain SettingNOTE: When these bits are
                                                         used, set {P002DEN, P002GEN} to 11b.                                  */
           uint16_t             :  1;
      __IO uint16_t  P002DEN    :  1;               /*!< P002 Differential Input Enable                                        */
      __IO uint16_t  P003DG     :  2;               /*!< P003 Differential Input Gain SettingNOTE: When these bits are
                                                         used, set {P003DEN, P003GEN} to 11b.                                  */
           uint16_t             :  1;
      __IO uint16_t  P003DEN    :  1;               /*!< P003 Differential Input Enable                                        */
    } ADPGADCR0_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED16[2];   // Padding changed from uint16_t
  
  union {
    __IO uint8_t   ADPGADBS0;                       /*!< A/D Programmable Gain Amplifier Differential Input Bias Select
                                                         Register 0                                                            */
    
    struct {
      __IO uint8_t   P0BIAS     :  1;               /*!< Programmable Gain Amplifiers P000 to P002 Bias Voltage SelectNOTE:
                                                         This bit selects the input bias voltage value when differential
                                                          inputs are used.                                                     */
    } ADPGADBS0_b;                                  /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   ADPGADBS1;                       /*!< A/D Programmable Gain Amplifier Differential Input Bias Select
                                                         Register 1                                                            */
    
    struct {
      __IO uint8_t   P3BIAS     :  1;               /*!< Programmable Gain Amplifiers P003 Bias Voltage SelectNOTE: This
                                                         bit selects the input bias voltage value when differential inputs
                                                          are used.                                                            */
    } ADPGADBS1_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED17[21 * 2];
  
  union {
    __IO uint8_t   ADREFMON;                        /*!< A/D External Reference Voltage Monitor Register                       */
    
    struct {
      __IO uint8_t   PGAMON     :  3;               /*!< PGA Monitor Output Enable                                             */
           uint8_t              :  1;
      __IO uint8_t   MONSEL     :  4;               /*!< Monitor output selection bit.                                         */
    } ADREFMON_b;                                   /*!< BitSize                                                               */
  };
} R_S12ADC0_Type;


/* ================================================================================ */
/* ================                      R_TSN                     ================ */
/* ================================================================================ */


/**
  * @brief Temperature Sensor (R_TSN_Control_Type).
  * This structure defines the control structure for the TSN peripheral.
  * This register is only present on the CM4 devices
  */

typedef struct {                                    /*!< R_TSN Structure                                                       */
                                                    /*!< Enable/Disable registers. Valid only on the CM4 devices             */
    union {
    __IO uint8_t   TSCR;                            /*!< Temperature Sensor Control Register                                   */

    struct {
    uint8_t              :  4;
    __IO uint8_t   TSOE       :  1;               /*!< Temperature Sensor Enable                                             */
    uint8_t              :  2;
    __IO uint8_t   TSEN       :  1;               /*!< Temperature Sensor Output Enable                                      */
    } TSCR_b;                                       /*!< BitSize                                                               */
    };
} R_TSN_Control_Type;

/**
  * @brief Temperature Sensor (R_TSN).
 * This structure defines the calibration structure for the TSN peripheral.
  * This register is only present on the CM0 devices and S5 devices
  */
typedef struct {                                    /*!< R_TSN Structure                                                       */
                                                        /*!< Calibration data registers. Valid only on the CM0 devices and S5 devices */
	union {
        struct{
           union {
              __I  uint8_t   TSCDRL;                            /*!< Calibration data register (Low)                                         */
              struct {
                __I  uint8_t   TSCDRL       :  8;               /*!< Lower byte of the calibration data.                                   */
              } TSCDRL_b;                                       /*!< BitSize                                                               */
            };

            union {
              __I  uint8_t   TSCDRH;                            /*!< Calibration data register (High)                                        */
              struct {
                __I  uint8_t   TSCDRH       :  8;               /*!< Higher byte of the calibration data. Only lower 4 bytes are valid     */
              } TSCDRH_b;                                       /*!< BitSize                                                               */
            };
            __I  uint16_t  RESERVED;
        } TSCDR_b;
      __I  uint32_t  TSCDR;
    };

} R_TSN_Calibration_Type;


/* ================================================================================ */
/* ================                      R_DAC                     ================ */
/* ================================================================================ */


/**
  * @brief 12-bit D/A converter (R_DAC)
  */

typedef struct {                                    /*!< R_DAC Structure                                                       */
  
  union {
    __IO uint16_t  DADRn[2];                        /*!< D/A Data Register %s                                                  */
    
    struct {
      __IO uint16_t  DADR       : 16;               /*!< D/A Data RegisterNOTE: When DADPR.DPSEL = 0, the high-order
                                                         4 bits are fixed to 0: right justified format. When DADPR.DPSEL
                                                          = 1, the low-order 4 bits are fixed to 0: left justified format.     */
    } DADRn_b[2];                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DACR;                            /*!< D/A Control Register                                                  */
    
    struct {
           uint8_t              :  5;
      __IO uint8_t   DAE        :  1;               /*!< D/A Enable                                                            */
      __IO uint8_t   DAOE0      :  1;               /*!< D/A Output Enable 0                                                   */
      __IO uint8_t   DAOE1      :  1;               /*!< D/A Output Enable 1                                                   */
    } DACR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DADPR;                           /*!< DADRm Format Select Register                                          */
    
    struct {
           uint8_t              :  7;
      __IO uint8_t   DPSEL      :  1;               /*!< DADRm Format Select                                                   */
    } DADPR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DAADSCR;                         /*!< D/A-A/D Synchronous Start Control Register                            */
    
    struct {
           uint8_t              :  7;
      __IO uint8_t   DAADST     :  1;               /*!< D/A-A/D Synchronous Conversion                                        */
    } DAADSCR_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint8_t   DAVREFCR;                        /*!< D/A VREF Control Register                                             */

    struct {
      __IO uint8_t   REF        :  3;               /*!< D/A Reference Voltage Select                                          */
           uint8_t              :  5;
    } DAVREFCR_b;                                   /*!< BitSize                                                               */
  };

  union {
    __IO uint8_t   DAAMPCR;                         /*!< D/A Output Amplifier Control Register                                 */
    
    struct {
           uint8_t              :  6;
      __IO uint8_t   DAAMP0     :  1;               /*!< Amplifier Control 0                                                   */
      __IO uint8_t   DAAMP1     :  1;               /*!< Amplifier Control 1                                                   */
    } DAAMPCR_b;                                    /*!< BitSize                                                               */
  };
} R_DAC_Type;


/* ================================================================================ */
/* ================                      R_AMI                     ================ */
/* ================================================================================ */


/**
  * @brief AD-DA Interface (R_AMI)
  */

typedef struct {                                    /*!< R_AMI Structure                                                       */
  __I  uint8_t RESERVED[48 * 4];
  
  union {
    __IO uint8_t   DAADUSR;                         /*!< D/A A/D Synchronous Unit Select Register                              */
    
    struct {
           uint8_t              :  1;
      __IO uint8_t   AMADSEL1   :  1;               /*!< S12ADC1 Select                                                        */
    } DAADUSR_b;                                    /*!< BitSize                                                               */
  };
} R_AMI_Type;


/* ================================================================================ */
/* ================                     R_USBHS                    ================ */
/* ================================================================================ */


/**
  * @brief USB2.0 HS host/device/OTG module (R_USBHS)
  */

typedef struct {                                    /*!< R_USBHS Structure                                                     */
  
  union {
    __IO uint16_t  SYSCFG;                          /*!< System Configuration Control Register                                 */
    
    struct {
      __IO uint16_t  USBE       :  1;               /*!< USB Operation Enable                                                  */
           uint16_t             :  3;
      __IO uint16_t  DPRPU      :  1;               /*!< D+ Line Resistor Control                                              */
      __IO uint16_t  DRPD       :  1;               /*!< D+/D- Line Resistor Control                                           */
      __IO uint16_t  DCFM       :  1;               /*!< Controller Function Select                                            */
      __IO uint16_t  HSE        :  1;               /*!< High-Speed Operation Enable                                           */
      __IO uint16_t  CNEN       :  1;               /*!< Single End Receiver Enable                                            */
    } SYSCFG_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  BUSWAIT;                         /*!< CPU Bus Wait Register                                                 */
    
    struct {
      __IO uint16_t  BWAIT      :  4;               /*!< CPU Bus Access Wait Specification BWAIT waits (BWAIT+2 access
                                                         cycles)                                                               */
    } BUSWAIT_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __I  uint16_t  SYSSTS0;                         /*!< System Configuration Status Register                                  */
    
    struct {
      __I  uint16_t  LNST       :  2;               /*!< USB Data Line Status Monitor                                          */
      __I  uint16_t  IDMON      :  1;               /*!< ID0 Pin Monitor                                                       */
           uint16_t             :  2;
      __I  uint16_t  SOFEA      :  1;               /*!< SOF Active Monitor While Host Controller Function is Selected.        */
      __I  uint16_t  HTACT      :  1;               /*!< Host Sequencer Status Monitor                                         */
           uint16_t             :  7;
      __I  uint16_t  OCVMON     :  2;               /*!< External USB1_OVRCURA/USB1_OVRCURB Input Pin MonitorThe OCVMON[1]
                                                         bit indicates the status of the USBHS_OVRCURA pin. The OCVMON[0]
                                                          bit indicates the status of the USBHS_OVRCURB pin.                   */
    } SYSSTS0_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __I  uint16_t  PLLSTA;                          /*!< PLL Status Register                                                   */
    
    struct {
      __I  uint16_t  PLLLOCK    :  1;               /*!< PLL Lock Flag                                                         */
    } PLLSTA_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  DVSTCTR0;                        /*!< Device State Control Register 0                                       */
    
    struct {
      __I  uint16_t  RHST       :  3;               /*!< USB Bus Reset Status                                                  */
           uint16_t             :  1;
      __IO uint16_t  UACT       :  1;               /*!< USB Bus Enable                                                        */
      __IO uint16_t  RESUME     :  1;               /*!< Resume Output                                                         */
      __IO uint16_t  USBRST     :  1;               /*!< USB Bus Reset Output                                                  */
      __IO uint16_t  RWUPE      :  1;               /*!< Remote Wakeup Detection Enable                                        */
      __IO uint16_t  WKUP       :  1;               /*!< Wakeup Output                                                         */
      __IO uint16_t  VBUSEN     :  1;               /*!< USB0_VBUSEN Output Pin ControlThe VBUSEN bit value is output
                                                         as the status of the external USB0_VBUSEN pin without change.         */
      __IO uint16_t  EXICEN     :  1;               /*!< USB0_EXICEN Output Pin ControlThe EXICEN bit value is output
                                                         as the status of the external USB0_EXICEN pin without change.         */
      __IO uint16_t  HNPBTOA    :  1;               /*!< Host Negotiation Protocol (HNP) Control This bit is used when
                                                         switching from device B to device A while in OTG mode. If the
                                                          HNPBTOA bit is 1, the internal function control keeps the suspended
                                                          state until the HNP processing ends even though SYSCFG.DPRPU
                                                          = 0 or SYSCFG.DCFM = 1 is set.                                       */
    } DVSTCTR0_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  TESTMODE;                        /*!< USB Test Mode Register                                                */
    
    struct {
      __IO uint16_t  UTST       :  4;               /*!< Test Mode                                                             */
    } TESTMODE_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED1[3 * 2];
  
  union {
    __IO uint32_t  CFIFO;                           /*!< CFIFO Port Register                                                   */
    
    struct {
      __IO uint32_t  FIFOPORT   : 32;               /*!< FIFO Port.Read receive data from the FIFO buffer or write transmit
                                                         data to the FIFO buffer by accessing these bits.                      */
    } CFIFO_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  D0FIFO;                          /*!< D0FIFO Port Register                                                  */
    
    struct {
      __IO uint32_t  FIFOPORT   : 32;               /*!< FIFO Port Read receive data from the FIFO buffer or write transmit
                                                         data to the FIFO buffer by accessing these bits.                      */
    } D0FIFO_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  D1FIFO;                          /*!< D1FIFO Port Register                                                  */
    
    struct {
      __IO uint32_t  FIFOPORT   : 32;               /*!< FIFO PortRead receive data from the FIFO buffer or write transmit
                                                         data to the FIFO buffer by accessing these bits.                      */
    } D1FIFO_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  CFIFOSEL;                        /*!< CFIFO Port Select Register                                            */
    
    struct {
      __IO uint16_t  CURPIPE    :  4;               /*!< FIFO Port Access Pipe Specification                                   */
           uint16_t             :  1;
      __IO uint16_t  ISEL       :  1;               /*!< FIFO Port Access Direction when DCP is Selected                       */
           uint16_t             :  2;
      __IO uint16_t  BIGEND     :  1;               /*!< FIFO Port Endian Control                                              */
           uint16_t             :  1;
      __IO uint16_t  MBW        :  2;               /*!< CFIFO Port Access Bit Width                                           */
           uint16_t             :  2;
      __IO uint16_t  REW        :  1;               /*!< Buffer Pointer Rewind                                                 */
      __IO uint16_t  RCNT       :  1;               /*!< Read Count Mode                                                       */
    } CFIFOSEL_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  CFIFOCTR;                        /*!< CFIFO Port Control Register                                           */
    
    struct {
      __I  uint16_t  DTLN       : 12;               /*!< Receive Data Length.Indicates the length of the receive data.         */
           uint16_t             :  1;
      __I  uint16_t  FRDY       :  1;               /*!< FIFO Port ReadyIndicates whether the FIFO port can be accessed.       */
      __IO uint16_t  BCLR       :  1;               /*!< CPU Buffer Clear                                                      */
      __IO uint16_t  BVAL       :  1;               /*!< Buffer Memory Valid Flag                                              */
    } CFIFOCTR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED2[4];   // Padding changed from uint32_t
  
  union {
    __IO uint16_t  D0FIFOSEL;                       /*!< D0FIFO Port Select Register                                           */
    
    struct {
      __IO uint16_t  CURPIPE    :  4;               /*!< FIFO Port Access Pipe Specification                                   */
           uint16_t             :  4;
      __IO uint16_t  BIGEND     :  1;               /*!< FIFO Port Endian Control                                              */
           uint16_t             :  1;
      __IO uint16_t  MBW        :  2;               /*!< FIFO Port Access Bit Width                                            */
      __IO uint16_t  DREQE      :  1;               /*!< UCL_Dx_DREQ Signal Output Enable                                      */
      __IO uint16_t  DCLRM      :  1;               /*!< Auto Buffer Memory Clear Mode Accessed after Specified Pipe
                                                         Data is Read                                                          */
      __IO uint16_t  REW        :  1;               /*!< Buffer Pointer Rewind                                                 */
      __IO uint16_t  RCNT       :  1;               /*!< Read Count Mode                                                       */
    } D0FIFOSEL_b;                                  /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  D0FIFOCTR;                       /*!< D0FIFO Port Control Register                                          */
    
    struct {
      __I  uint16_t  DTLN       : 12;               /*!< Receive Data Length.Indicates the length of the receive data.         */
           uint16_t             :  1;
      __I  uint16_t  FRDY       :  1;               /*!< FIFO Port ReadyIndicates whether the FIFO port can be accessed.       */
      __IO uint16_t  BCLR       :  1;               /*!< CPU Buffer Clear                                                      */
      __IO uint16_t  BVAL       :  1;               /*!< Buffer Memory Valid Flag                                              */
    } D0FIFOCTR_b;                                  /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  D1FIFOSEL;                       /*!< D1FIFO Port Select Register                                           */
    
    struct {
      __IO uint16_t  CURPIPE    :  4;               /*!< FIFO Port Access Pipe Specification                                   */
           uint16_t             :  4;
      __IO uint16_t  BIGEND     :  1;               /*!< FIFO Port Endian Control                                              */
           uint16_t             :  1;
      __IO uint16_t  MBW        :  2;               /*!< FIFO Port Access Bit Width                                            */
      __IO uint16_t  DREQE      :  1;               /*!< UCL_Dx_DREQ Signal Output Enable                                      */
      __IO uint16_t  DCLRM      :  1;               /*!< Auto Buffer Memory Clear Mode Accessed after Specified Pipe
                                                         Data is Read                                                          */
      __IO uint16_t  REW        :  1;               /*!< Buffer Pointer Rewind                                                 */
      __IO uint16_t  RCNT       :  1;               /*!< Read Count Mode                                                       */
    } D1FIFOSEL_b;                                  /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  D1FIFOCTR;                       /*!< D1FIFO Port Control Register                                          */
    
    struct {
      __I  uint16_t  DTLN       : 12;               /*!< Receive Data Length.Indicates the length of the receive data.         */
           uint16_t             :  1;
      __I  uint16_t  FRDY       :  1;               /*!< FIFO Port ReadyIndicates whether the FIFO port can be accessed.       */
      __IO uint16_t  BCLR       :  1;               /*!< CPU Buffer Clear                                                      */
      __IO uint16_t  BVAL       :  1;               /*!< Buffer Memory Valid Flag                                              */
    } D1FIFOCTR_b;                                  /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  INTENB0;                         /*!< Interrupt Enable Register 0                                           */
    
    struct {
           uint16_t             :  8;
      __IO uint16_t  BRDYE      :  1;               /*!< Buffer Ready Interrupt Enable                                         */
      __IO uint16_t  NRDYE      :  1;               /*!< Buffer Not Ready Response Interrupt Enable                            */
      __IO uint16_t  BEMPE      :  1;               /*!< Buffer Empty Interrupt Enable                                         */
      __IO uint16_t  CTRE       :  1;               /*!< Control Transfer Stage Transition Interrupt Enable                    */
      __IO uint16_t  DVSE       :  1;               /*!< Device State Transition Interrupt Enable                              */
      __IO uint16_t  SOFE       :  1;               /*!< Frame Number Update Interrupt Enable                                  */
      __IO uint16_t  RSME       :  1;               /*!< Resume Interrupt Enable                                               */
      __IO uint16_t  VBSE       :  1;               /*!< VBUS Interrupt Enable                                                 */
    } INTENB0_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  INTENB1;                         /*!< Interrupt Enable Register 1                                           */
    
    struct {
      __IO uint16_t  PDDETINTE  :  1;               /*!< PDDETINT Detection Interrupt Enable                                   */
           uint16_t             :  3;
      __IO uint16_t  SACKE      :  1;               /*!< Setup Transaction Normal Response Interrupt Enable                    */
      __IO uint16_t  SIGNE      :  1;               /*!< Setup Transaction Error Interrupt Enable                              */
      __IO uint16_t  EOFERRE    :  1;               /*!< EOF Error Detection Interrupt Enable                                  */
           uint16_t             :  1;
      __IO uint16_t  LPMENDE    :  1;               /*!< LPM Transaction End Interrupt Enable                                  */
      __IO uint16_t  L1RSMENDE  :  1;               /*!< L1 Resume End Interrupt Enable                                        */
           uint16_t             :  1;
      __IO uint16_t  ATTCHE     :  1;               /*!< Connection Detection Interrupt Enable                                 */
      __IO uint16_t  DTCHE      :  1;               /*!< Disconnection Detection Interrupt Enable                              */
           uint16_t             :  1;
      __IO uint16_t  BCHGE      :  1;               /*!< USB Bus Change Interrupt Enable                                       */
      __IO uint16_t  OVRCRE     :  1;               /*!< OVRCRE Interrupt Enable                                               */
    } INTENB1_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED3[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BRDYENB;                         /*!< BRDY Interrupt Enable Register                                        */
    
    struct {
      __IO uint16_t  PIPEBRDYE  : 10;               /*!< BRDY Interrupt Enable for Each Pipe                                   */
    } BRDYENB_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  NRDYENB;                         /*!< NRDY Interrupt Enable Register                                        */
    
    struct {
      __IO uint16_t  PIPENRDYE  : 10;               /*!< NRDY Interrupt Enable for Each Pipe                                   */
    } NRDYENB_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  BEMPENB;                         /*!< BEMP Interrupt Enable Register                                        */
    
    struct {
      __IO uint16_t  PIPEBEMPE  : 10;               /*!< BEMP Interrupt Enable for Each Pipe                                   */
    } BEMPENB_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  SOFCFG;                          /*!< SOF Pin Configuration Register                                        */
    
    struct {
           uint16_t             :  4;
      __I  uint16_t  EDGESTS    :  1;               /*!< Interrupt Edge Processing Status Monitor                              */
      __IO uint16_t  INTL       :  1;               /*!< Interrupt Output Sense Select                                         */
      __IO uint16_t  BRDYM      :  1;               /*!< PIPEBRDY Interrupt Status Clear Timing.This bit can be set only
                                                         in the initial setting (before communications).The setting cannot
                                                          be changed once communication starts.                                */
           uint16_t             :  1;
      __IO uint16_t  TRNENSEL   :  1;               /*!< Transaction-Enabled Time Select.The transfer efficiency can
                                                         be improved by setting this bit to 1 if no low-speed device
                                                          is connected directly or via FS-HUB to the USB port.                 */
    } SOFCFG_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PHYSET;                          /*!< PHY Setting Register                                                  */
    
    struct {
      __IO uint16_t  DIRPD      :  1;               /*!< Power-Down Control                                                    */
      __IO uint16_t  PLLRESET   :  1;               /*!< PLL Reset Control                                                     */
           uint16_t             :  1;
      __IO uint16_t  CDPEN      :  1;               /*!< Charging Downstream Port Enable                                       */
      __IO uint16_t  CLKSEL     :  2;               /*!< Input System Clock Frequency                                          */
           uint16_t             :  2;
      __IO uint16_t  REPSEL     :  2;               /*!< Terminating Resistance Adjustment Cycle                               */
           uint16_t             :  1;
      __IO uint16_t  REPSTART   :  1;               /*!< Forcibly Start Terminating Resistance Adjustment                      */
           uint16_t             :  3;
      __IO uint16_t  HSEB       :  1;               /*!< CL-Only Mode                                                          */
    } PHYSET_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  INTSTS0;                         /*!< Interrupt Status Register 0                                           */
    
    struct {
      __I  uint16_t  CTSQ       :  3;               /*!< Control Transfer Stage                                                */
      __IO uint16_t  VALID      :  1;               /*!< USB Request Reception                                                 */
      __I  uint16_t  DVSQ       :  3;               /*!< Device State                                                          */
      __I  uint16_t  VBSTS      :  1;               /*!< VBUS Input Status                                                     */
      __I  uint16_t  BRDY       :  1;               /*!< Buffer Ready Interrupt Status                                         */
      __I  uint16_t  NRDY       :  1;               /*!< Buffer Not Ready Interrupt Status                                     */
      __I  uint16_t  BEMP       :  1;               /*!< Buffer Empty Interrupt Status                                         */
      __IO uint16_t  CTRT       :  1;               /*!< Control Transfer Stage Transition Interrupt Status                    */
      __IO uint16_t  DVST       :  1;               /*!< Device State Transition Interrupt Status                              */
      __IO uint16_t  SOFR       :  1;               /*!< Frame Number Refresh Interrupt Status                                 */
      __IO uint16_t  RESM       :  1;               /*!< Resume Interrupt Status                                               */
      __IO uint16_t  VBINT      :  1;               /*!< VBUS Interrupt Status                                                 */
    } INTSTS0_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  INTSTS1;                         /*!< Interrupt Status Register 1                                           */
    
    struct {
      __IO uint16_t  PDDETINT   :  1;               /*!< PDDET Detection Interrupt Status                                      */
           uint16_t             :  3;
      __IO uint16_t  SACK       :  1;               /*!< Setup Transaction Normal Response Interrupt Status                    */
      __IO uint16_t  SIGN       :  1;               /*!< Setup Transaction Error Interrupt Status                              */
      __IO uint16_t  EOFERR     :  1;               /*!< EOF Error Detection Interrupt Status                                  */
           uint16_t             :  1;
      __IO uint16_t  LPMEND     :  1;               /*!< LPM Transaction End Interrupt Status                                  */
      __IO uint16_t  L1RSMEND   :  1;               /*!< L1 Resume End Interrupt Status                                        */
           uint16_t             :  1;
      __IO uint16_t  ATTCH      :  1;               /*!< USB Connection Detection Interrupt Status                             */
      __IO uint16_t  DTCH       :  1;               /*!< USB Disconnection Detection Interrupt Status                          */
           uint16_t             :  1;
      __IO uint16_t  BCHG       :  1;               /*!< USB Bus Change Interrupt Status                                       */
      __IO uint16_t  OVRCR      :  1;               /*!< Overcurrent Interrupt Status                                          */
    } INTSTS1_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED4[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  BRDYSTS;                         /*!< BRDY Interrupt Status Register                                        */
    
    struct {
      __IO uint16_t  PIPEBRDY   : 10;               /*!< BRDY Interrupt Status for Each Pipe                                   */
    } BRDYSTS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  NRDYSTS;                         /*!< NRDY Interrupt Status Register                                        */
    
    struct {
      __IO uint16_t  PIPENRDY   : 10;               /*!< NRDY Interrupt Status for Each Pipe                                   */
    } NRDYSTS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  BEMPSTS;                         /*!< BEMP Interrupt Status Register                                        */
    
    struct {
      __IO uint16_t  PIPEBEMP   : 10;               /*!< BEMP Interrupt Status for Each Pipe                                   */
    } BEMPSTS_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  FRMNUM;                          /*!< Frame Number Register                                                 */
    
    struct {
      __I  uint16_t  FRNM       : 11;               /*!< Frame Number.Indicate the latest frame number.                        */
           uint16_t             :  3;
      __IO uint16_t  CRCE       :  1;               /*!< CRC Error Detection Status                                            */
      __IO uint16_t  OVRN       :  1;               /*!< Overrun/Underrun Detection Status                                     */
    } FRMNUM_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  UFRMNUM;                         /*!< uFrame Number Register                                                */
    
    struct {
      __I  uint16_t  UFRNM      :  3;               /*!< MicroframeIndicate the microframe number.                             */
    } UFRMNUM_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  USBADDR;                         /*!< USB Address Register                                                  */
    
    struct {
      __I  uint16_t  USBADDR    :  7;               /*!< USB AddressWhen the function controller function is selected,
                                                         these bits indicate the USB address assigned by the host.             */
    } USBADDR_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED5[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  USBREQ;                          /*!< USB Request Type Register                                             */
    
    struct {
      __IO uint16_t  bmRequestType:  8;             /*!< USB request bmRequestType value Function controller selected
                                                         : read-only Host controller selected : read-write                     */
      __IO uint16_t  bRequest   :  8;               /*!< USB request bRequest value Function controller selected : read-only
                                                         Host controller selected : read-write                                 */
    } USBREQ_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  USBVAL;                          /*!< USB Request Value Register                                            */
    
    struct {
      __IO uint16_t  wValue     : 16;               /*!< Value of USB request wValue Function controller selected : read-only
                                                         Host controller selected : read-write                                 */
    } USBVAL_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  USBINDX;                         /*!< USB Request Index Register                                            */
    
    struct {
      __IO uint16_t  wIndex     : 16;               /*!< Value of USB request wIndex Function controller selected : read-only
                                                         Host controller selected : read-write                                 */
    } USBINDX_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  USBLENG;                         /*!< USB Request Length Register                                           */
    
    struct {
      __IO uint16_t  wLength    : 16;               /*!< Value of USB request wLength Function controller selected :
                                                         read-only Host controller selected : read-write                       */
    } USBLENG_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  DCPCFG;                          /*!< DCP Configuration Register                                            */
    
    struct {
           uint16_t             :  4;
      __IO uint16_t  DIR        :  1;               /*!< Transfer Direction                                                    */
           uint16_t             :  2;
      __IO uint16_t  SHTNAK     :  1;               /*!< Pipe Blocking on End of Transfer                                      */
      __IO uint16_t  CNTMD      :  1;               /*!< Continuous Transfer Mode                                              */
    } DCPCFG_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  DCPMAXP;                         /*!< DCP Maximum Packet Size Register                                      */
    
    struct {
      __IO uint16_t  MXPS       :  7;               /*!< Maximum Packet SizeThese bits specify the maximum data payload
                                                         (maximum packet size) for the DCP.                                    */
           uint16_t             :  5;
      __IO uint16_t  DEVSEL     :  4;               /*!< Device SelectThese bits specify the address of the destination
                                                         function device for control transfer when the host controller
                                                          function is selected.                                                */
    } DCPMAXP_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  DCPCTR;                          /*!< DCP Control Register                                                  */
    
    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PID                                                          */
      __IO uint16_t  CCPL       :  1;               /*!< Control Transfer End Enable                                           */
           uint16_t             :  1;
      __IO uint16_t  PINGE      :  1;               /*!< PING Token Issue Enable                                               */
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe Busy                                                             */
      __I  uint16_t  SQMON      :  1;               /*!< Sequence Toggle Bit Monitor                                           */
      __IO uint16_t  SQSET      :  1;               /*!< Toggle Bit Set                                                        */
      __IO uint16_t  SQCLR      :  1;               /*!< Toggle Bit Clear                                                      */
           uint16_t             :  2;
      __IO uint16_t  SUREQCLR   :  1;               /*!< SUREQ Bit Clear                                                       */
      __I  uint16_t  CSSTS      :  1;               /*!< Split Transaction COMPLETE SPLIT(CSPLIT) Status                       */
      __IO uint16_t  CSCLR      :  1;               /*!< Split Transaction CSPLIT Status Clear                                 */
      __IO uint16_t  SUREQ      :  1;               /*!< SETUP Token Transmission                                              */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer Status                                                         */
    } DCPCTR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED6[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  PIPESEL;                         /*!< Pipe Window Select Register                                           */
    
    struct {
      __IO uint16_t  PIPESEL    :  4;               /*!< Pipe Window SelectThese bits specify the pipe for registers
                                                         at addresses 68H to 6EH.                                              */
    } PIPESEL_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED7[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  PIPECFG;                         /*!< Pipe Configuration Register                                           */
    
    struct {
      __IO uint16_t  EPNUM      :  4;               /*!< Endpoint Number                                                       */
      __IO uint16_t  DIR        :  1;               /*!< Transfer Direction                                                    */
           uint16_t             :  2;
      __IO uint16_t  SHTNAK     :  1;               /*!< Pipe Disabled at End of Transfer                                      */
      __IO uint16_t  CNTMD      :  1;               /*!< Continuous Transfer Mode                                              */
      __IO uint16_t  DBLB       :  1;               /*!< Double Buffer Mode                                                    */
      __IO uint16_t  BFRE       :  1;               /*!< BRDY Interrupt Operation Specification                                */
           uint16_t             :  3;
      __IO uint16_t  TYPE       :  2;               /*!< Transfer Type                                                         */
    } PIPECFG_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPEBUF;                         /*!< Pipe Buffer Register                                                  */
    
    struct {
      __IO uint16_t  BUFNMB     :  8;               /*!< Buffer NumberThese bits specify the FIFO buffer number of the
                                                         selected pipe (04h to 87h).                                           */
           uint16_t             :  2;
      __IO uint16_t  BUFSIZE    :  5;               /*!< Buffer Size 00h: 64 bytes 01h: 128 bytes : 1Fh: 2 Kbytes              */
    } PIPEBUF_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPEMAXP;                        /*!< Pipe Maximum Packet Size Register                                     */
    
    struct {
      __IO uint16_t  MXPS       : 11;               /*!< Maximum Packet SizeThese bits specify the maximum data payload
                                                         (maximum packet size) for the selected pipe.A size of 1h to
                                                          40h bytes can be set for PIPE6 to PIPE9.                             */
           uint16_t             :  1;
      __IO uint16_t  DEVSEL     :  4;               /*!< Device SelectThese bits specify the address of the peripheral
                                                         device when the host controller function is selected.                 */
    } PIPEMAXP_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPEPERI;                        /*!< Pipe Cycle Control Register                                           */
    
    struct {
      __IO uint16_t  IITV       :  3;               /*!< Interval Error Detection IntervalThese bits specify the transfer
                                                         interval timing for the selected pipe as n-th power of 2 of
                                                          the frame timing.                                                    */
           uint16_t             :  9;
      __IO uint16_t  IFIS       :  1;               /*!< Isochronous IN Buffer Flush                                           */
    } PIPEPERI_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE1CTR;                        /*!< PIPE Control Register                                                 */
    
    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PIDThese bits specify the response type for the next
                                                         transaction of the relevant pipe.                                     */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe BusyThis bit indicates whether the relevant pipe is being
                                                         used for the USB bus                                                  */
      __I  uint16_t  SQMON      :  1;               /*!< Toggle Bit ConfirmationThis bit indicates the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe                                                                 */
      __IO uint16_t  SQSET      :  1;               /*!< Toggle Bit SetThis bit is set to 1 when the expected value of
                                                         the sequence toggle bit for the next transaction of the relevant
                                                          pipe is set for DATA1                                                */
      __IO uint16_t  SQCLR      :  1;               /*!< Toggle Bit ClearThis bit is set to 1 when the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe is cleared to DATA0                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear ModeThis bit enables or disables auto buffer
                                                         clear mode for the relevant pipe                                      */
      __IO uint16_t  ATREPM     :  1;               /*!< Auto Response ModeThis bit enables or disables auto response
                                                         mode for the relevant pipe.                                           */
           uint16_t             :  1;
      __I  uint16_t  CSSTS      :  1;               /*!< CSSTS StatusThis bit indicates the CSPLIT status of Split Transaction
                                                         of the relevant pipe                                                  */
      __IO uint16_t  CSCLR      :  1;               /*!< CSPLIT Status ClearSet this bit to 1 when clearing the CSSTS
                                                         bit of the relevant pipe                                              */
      __I  uint16_t  INBUFM     :  1;               /*!< Transmit Buffer MonitorThis bit indicates the FIFO buffer status
                                                         for the relevant pipe in the transmitting direction.                  */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer StatusThis bit indicates the FIFO buffer status for the
                                                         relevant pipe.                                                        */
    } PIPE1CTR_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE2CTR;                        /*!< PIPE Control Register                                                 */
    
    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PIDThese bits specify the response type for the next
                                                         transaction of the relevant pipe.                                     */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe BusyThis bit indicates whether the relevant pipe is being
                                                         used for the USB bus                                                  */
      __I  uint16_t  SQMON      :  1;               /*!< Toggle Bit ConfirmationThis bit indicates the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe                                                                 */
      __IO uint16_t  SQSET      :  1;               /*!< Toggle Bit SetThis bit is set to 1 when the expected value of
                                                         the sequence toggle bit for the next transaction of the relevant
                                                          pipe is set for DATA1                                                */
      __IO uint16_t  SQCLR      :  1;               /*!< Toggle Bit ClearThis bit is set to 1 when the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe is cleared to DATA0                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear ModeThis bit enables or disables auto buffer
                                                         clear mode for the relevant pipe                                      */
      __IO uint16_t  ATREPM     :  1;               /*!< Auto Response ModeThis bit enables or disables auto response
                                                         mode for the relevant pipe.                                           */
           uint16_t             :  1;
      __I  uint16_t  CSSTS      :  1;               /*!< CSSTS StatusThis bit indicates the CSPLIT status of Split Transaction
                                                         of the relevant pipe                                                  */
      __IO uint16_t  CSCLR      :  1;               /*!< CSPLIT Status ClearSet this bit to 1 when clearing the CSSTS
                                                         bit of the relevant pipe                                              */
      __I  uint16_t  INBUFM     :  1;               /*!< Transmit Buffer MonitorThis bit indicates the FIFO buffer status
                                                         for the relevant pipe in the transmitting direction.                  */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer StatusThis bit indicates the FIFO buffer status for the
                                                         relevant pipe.                                                        */
    } PIPE2CTR_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE3CTR;                        /*!< PIPE Control Register                                                 */
    
    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PIDThese bits specify the response type for the next
                                                         transaction of the relevant pipe.                                     */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe BusyThis bit indicates whether the relevant pipe is being
                                                         used for the USB bus                                                  */
      __I  uint16_t  SQMON      :  1;               /*!< Toggle Bit ConfirmationThis bit indicates the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe                                                                 */
      __IO uint16_t  SQSET      :  1;               /*!< Toggle Bit SetThis bit is set to 1 when the expected value of
                                                         the sequence toggle bit for the next transaction of the relevant
                                                          pipe is set for DATA1                                                */
      __IO uint16_t  SQCLR      :  1;               /*!< Toggle Bit ClearThis bit is set to 1 when the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe is cleared to DATA0                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear ModeThis bit enables or disables auto buffer
                                                         clear mode for the relevant pipe                                      */
      __IO uint16_t  ATREPM     :  1;               /*!< Auto Response ModeThis bit enables or disables auto response
                                                         mode for the relevant pipe.                                           */
           uint16_t             :  1;
      __I  uint16_t  CSSTS      :  1;               /*!< CSSTS StatusThis bit indicates the CSPLIT status of Split Transaction
                                                         of the relevant pipe                                                  */
      __IO uint16_t  CSCLR      :  1;               /*!< CSPLIT Status ClearSet this bit to 1 when clearing the CSSTS
                                                         bit of the relevant pipe                                              */
      __I  uint16_t  INBUFM     :  1;               /*!< Transmit Buffer MonitorThis bit indicates the FIFO buffer status
                                                         for the relevant pipe in the transmitting direction.                  */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer StatusThis bit indicates the FIFO buffer status for the
                                                         relevant pipe.                                                        */
    } PIPE3CTR_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE4CTR;                        /*!< PIPE Control Register                                                 */
    
    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PIDThese bits specify the response type for the next
                                                         transaction of the relevant pipe.                                     */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe BusyThis bit indicates whether the relevant pipe is being
                                                         used for the USB bus                                                  */
      __I  uint16_t  SQMON      :  1;               /*!< Toggle Bit ConfirmationThis bit indicates the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe                                                                 */
      __IO uint16_t  SQSET      :  1;               /*!< Toggle Bit SetThis bit is set to 1 when the expected value of
                                                         the sequence toggle bit for the next transaction of the relevant
                                                          pipe is set for DATA1                                                */
      __IO uint16_t  SQCLR      :  1;               /*!< Toggle Bit ClearThis bit is set to 1 when the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe is cleared to DATA0                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear ModeThis bit enables or disables auto buffer
                                                         clear mode for the relevant pipe                                      */
      __IO uint16_t  ATREPM     :  1;               /*!< Auto Response ModeThis bit enables or disables auto response
                                                         mode for the relevant pipe.                                           */
           uint16_t             :  1;
      __I  uint16_t  CSSTS      :  1;               /*!< CSSTS StatusThis bit indicates the CSPLIT status of Split Transaction
                                                         of the relevant pipe                                                  */
      __IO uint16_t  CSCLR      :  1;               /*!< CSPLIT Status ClearSet this bit to 1 when clearing the CSSTS
                                                         bit of the relevant pipe                                              */
      __I  uint16_t  INBUFM     :  1;               /*!< Transmit Buffer MonitorThis bit indicates the FIFO buffer status
                                                         for the relevant pipe in the transmitting direction.                  */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer StatusThis bit indicates the FIFO buffer status for the
                                                         relevant pipe.                                                        */
    } PIPE4CTR_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE5CTR;                        /*!< PIPE Control Register                                                 */
    
    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PIDThese bits specify the response type for the next
                                                         transaction of the relevant pipe.                                     */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe BusyThis bit indicates whether the relevant pipe is being
                                                         used for the USB bus                                                  */
      __I  uint16_t  SQMON      :  1;               /*!< Toggle Bit ConfirmationThis bit indicates the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe                                                                 */
      __IO uint16_t  SQSET      :  1;               /*!< Toggle Bit SetThis bit is set to 1 when the expected value of
                                                         the sequence toggle bit for the next transaction of the relevant
                                                          pipe is set for DATA1                                                */
      __IO uint16_t  SQCLR      :  1;               /*!< Toggle Bit ClearThis bit is set to 1 when the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe is cleared to DATA0                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear ModeThis bit enables or disables auto buffer
                                                         clear mode for the relevant pipe                                      */
      __IO uint16_t  ATREPM     :  1;               /*!< Auto Response ModeThis bit enables or disables auto response
                                                         mode for the relevant pipe.                                           */
           uint16_t             :  1;
      __I  uint16_t  CSSTS      :  1;               /*!< CSSTS StatusThis bit indicates the CSPLIT status of Split Transaction
                                                         of the relevant pipe                                                  */
      __IO uint16_t  CSCLR      :  1;               /*!< CSPLIT Status ClearSet this bit to 1 when clearing the CSSTS
                                                         bit of the relevant pipe                                              */
      __I  uint16_t  INBUFM     :  1;               /*!< Transmit Buffer MonitorThis bit indicates the FIFO buffer status
                                                         for the relevant pipe in the transmitting direction.                  */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer StatusThis bit indicates the FIFO buffer status for the
                                                         relevant pipe.                                                        */
    } PIPE5CTR_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE6CTR;                        /*!< PIPE Control Register                                                 */
    
    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PIDThese bits specify the response type for the next
                                                         transaction of the relevant pipe.                                     */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe BusyThis bit indicates whether the relevant pipe is being
                                                         used for the USB bus                                                  */
      __I  uint16_t  SQMON      :  1;               /*!< Toggle Bit ConfirmationThis bit indicates the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe                                                                 */
      __IO uint16_t  SQSET      :  1;               /*!< Toggle Bit SetThis bit is set to 1 when the expected value of
                                                         the sequence toggle bit for the next transaction of the relevant
                                                          pipe is set for DATA1                                                */
      __IO uint16_t  SQCLR      :  1;               /*!< Toggle Bit ClearThis bit is set to 1 when the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe is cleared to DATA0                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear ModeThis bit enables or disables auto buffer
                                                         clear mode for the relevant pipe                                      */
      __IO uint16_t  ATREPM     :  1;               /*!< Auto Response ModeThis bit enables or disables auto response
                                                         mode for the relevant pipe.                                           */
           uint16_t             :  1;
      __I  uint16_t  CSSTS      :  1;               /*!< CSSTS StatusThis bit indicates the CSPLIT status of Split Transaction
                                                         of the relevant pipe                                                  */
      __IO uint16_t  CSCLR      :  1;               /*!< CSPLIT Status ClearSet this bit to 1 when clearing the CSSTS
                                                         bit of the relevant pipe                                              */
      __I  uint16_t  INBUFM     :  1;               /*!< Transmit Buffer MonitorThis bit indicates the FIFO buffer status
                                                         for the relevant pipe in the transmitting direction.                  */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer StatusThis bit indicates the FIFO buffer status for the
                                                         relevant pipe.                                                        */
    } PIPE6CTR_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE7CTR;                        /*!< PIPE Control Register                                                 */
    
    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PIDThese bits specify the response type for the next
                                                         transaction of the relevant pipe.                                     */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe BusyThis bit indicates whether the relevant pipe is being
                                                         used for the USB bus                                                  */
      __I  uint16_t  SQMON      :  1;               /*!< Toggle Bit ConfirmationThis bit indicates the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe                                                                 */
      __IO uint16_t  SQSET      :  1;               /*!< Toggle Bit SetThis bit is set to 1 when the expected value of
                                                         the sequence toggle bit for the next transaction of the relevant
                                                          pipe is set for DATA1                                                */
      __IO uint16_t  SQCLR      :  1;               /*!< Toggle Bit ClearThis bit is set to 1 when the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe is cleared to DATA0                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear ModeThis bit enables or disables auto buffer
                                                         clear mode for the relevant pipe                                      */
      __IO uint16_t  ATREPM     :  1;               /*!< Auto Response ModeThis bit enables or disables auto response
                                                         mode for the relevant pipe.                                           */
           uint16_t             :  1;
      __I  uint16_t  CSSTS      :  1;               /*!< CSSTS StatusThis bit indicates the CSPLIT status of Split Transaction
                                                         of the relevant pipe                                                  */
      __IO uint16_t  CSCLR      :  1;               /*!< CSPLIT Status ClearSet this bit to 1 when clearing the CSSTS
                                                         bit of the relevant pipe                                              */
      __I  uint16_t  INBUFM     :  1;               /*!< Transmit Buffer MonitorThis bit indicates the FIFO buffer status
                                                         for the relevant pipe in the transmitting direction.                  */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer StatusThis bit indicates the FIFO buffer status for the
                                                         relevant pipe.                                                        */
    } PIPE7CTR_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE8CTR;                        /*!< PIPE Control Register                                                 */
    
    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PIDThese bits specify the response type for the next
                                                         transaction of the relevant pipe.                                     */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe BusyThis bit indicates whether the relevant pipe is being
                                                         used for the USB bus                                                  */
      __I  uint16_t  SQMON      :  1;               /*!< Toggle Bit ConfirmationThis bit indicates the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe                                                                 */
      __IO uint16_t  SQSET      :  1;               /*!< Toggle Bit SetThis bit is set to 1 when the expected value of
                                                         the sequence toggle bit for the next transaction of the relevant
                                                          pipe is set for DATA1                                                */
      __IO uint16_t  SQCLR      :  1;               /*!< Toggle Bit ClearThis bit is set to 1 when the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe is cleared to DATA0                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear ModeThis bit enables or disables auto buffer
                                                         clear mode for the relevant pipe                                      */
      __IO uint16_t  ATREPM     :  1;               /*!< Auto Response ModeThis bit enables or disables auto response
                                                         mode for the relevant pipe.                                           */
           uint16_t             :  1;
      __I  uint16_t  CSSTS      :  1;               /*!< CSSTS StatusThis bit indicates the CSPLIT status of Split Transaction
                                                         of the relevant pipe                                                  */
      __IO uint16_t  CSCLR      :  1;               /*!< CSPLIT Status ClearSet this bit to 1 when clearing the CSSTS
                                                         bit of the relevant pipe                                              */
      __I  uint16_t  INBUFM     :  1;               /*!< Transmit Buffer MonitorThis bit indicates the FIFO buffer status
                                                         for the relevant pipe in the transmitting direction.                  */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer StatusThis bit indicates the FIFO buffer status for the
                                                         relevant pipe.                                                        */
    } PIPE8CTR_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE9CTR;                        /*!< PIPE Control Register                                                 */
    
    struct {
      __IO uint16_t  PID        :  2;               /*!< Response PIDThese bits specify the response type for the next
                                                         transaction of the relevant pipe.                                     */
           uint16_t             :  3;
      __I  uint16_t  PBUSY      :  1;               /*!< Pipe BusyThis bit indicates whether the relevant pipe is being
                                                         used for the USB bus                                                  */
      __I  uint16_t  SQMON      :  1;               /*!< Toggle Bit ConfirmationThis bit indicates the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe                                                                 */
      __IO uint16_t  SQSET      :  1;               /*!< Toggle Bit SetThis bit is set to 1 when the expected value of
                                                         the sequence toggle bit for the next transaction of the relevant
                                                          pipe is set for DATA1                                                */
      __IO uint16_t  SQCLR      :  1;               /*!< Toggle Bit ClearThis bit is set to 1 when the expected value
                                                         of the sequence toggle bit for the next transaction of the relevant
                                                          pipe is cleared to DATA0                                             */
      __IO uint16_t  ACLRM      :  1;               /*!< Auto Buffer Clear ModeThis bit enables or disables auto buffer
                                                         clear mode for the relevant pipe                                      */
      __IO uint16_t  ATREPM     :  1;               /*!< Auto Response ModeThis bit enables or disables auto response
                                                         mode for the relevant pipe.                                           */
           uint16_t             :  1;
      __I  uint16_t  CSSTS      :  1;               /*!< CSSTS StatusThis bit indicates the CSPLIT status of Split Transaction
                                                         of the relevant pipe                                                  */
      __IO uint16_t  CSCLR      :  1;               /*!< CSPLIT Status ClearSet this bit to 1 when clearing the CSSTS
                                                         bit of the relevant pipe                                              */
      __I  uint16_t  INBUFM     :  1;               /*!< Transmit Buffer MonitorThis bit indicates the FIFO buffer status
                                                         for the relevant pipe in the transmitting direction.                  */
      __I  uint16_t  BSTS       :  1;               /*!< Buffer StatusThis bit indicates the FIFO buffer status for the
                                                         relevant pipe.                                                        */
    } PIPE9CTR_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED8[7 * 2];
  
  union {
    __IO uint16_t  PIPE1TRE;                        /*!< PIPE Transaction Counter Enable Register                              */
    
    struct {
           uint16_t             :  8;
      __IO uint16_t  TRCLR      :  1;               /*!< Transaction Counter ClearSetting this bit to 1 allows clearing
                                                         the transaction counter to 0.                                         */
      __IO uint16_t  TRENB      :  1;               /*!< Transaction Counter EnableEnables or disables the transaction
                                                         counter function.                                                     */
    } PIPE1TRE_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE1TRN;                        /*!< PIPE Transaction Counter Register                                     */
    
    struct {
      __IO uint16_t  TRNCNT     : 16;               /*!< Transaction CounterWhen writing to: Specify the number of total
                                                         packets (number of transactions) to be received by the relevant
                                                          PIPE.When read from: When TRENB = 0: Indicate the specified
                                                          number of transactions.When TRENB = 1: Indicate the number of
                                                          currently counted transactions.                                      */
    } PIPE1TRN_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE2TRE;                        /*!< PIPE Transaction Counter Enable Register                              */
    
    struct {
           uint16_t             :  8;
      __IO uint16_t  TRCLR      :  1;               /*!< Transaction Counter ClearSetting this bit to 1 allows clearing
                                                         the transaction counter to 0.                                         */
      __IO uint16_t  TRENB      :  1;               /*!< Transaction Counter EnableEnables or disables the transaction
                                                         counter function.                                                     */
    } PIPE2TRE_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE2TRN;                        /*!< PIPE Transaction Counter Register                                     */
    
    struct {
      __IO uint16_t  TRNCNT     : 16;               /*!< Transaction CounterWhen writing to: Specify the number of total
                                                         packets (number of transactions) to be received by the relevant
                                                          PIPE.When read from: When TRENB = 0: Indicate the specified
                                                          number of transactions.When TRENB = 1: Indicate the number of
                                                          currently counted transactions.                                      */
    } PIPE2TRN_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE3TRE;                        /*!< PIPE Transaction Counter Enable Register                              */
    
    struct {
           uint16_t             :  8;
      __IO uint16_t  TRCLR      :  1;               /*!< Transaction Counter ClearSetting this bit to 1 allows clearing
                                                         the transaction counter to 0.                                         */
      __IO uint16_t  TRENB      :  1;               /*!< Transaction Counter EnableEnables or disables the transaction
                                                         counter function.                                                     */
    } PIPE3TRE_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE3TRN;                        /*!< PIPE Transaction Counter Register                                     */
    
    struct {
      __IO uint16_t  TRNCNT     : 16;               /*!< Transaction CounterWhen writing to: Specify the number of total
                                                         packets (number of transactions) to be received by the relevant
                                                          PIPE.When read from: When TRENB = 0: Indicate the specified
                                                          number of transactions.When TRENB = 1: Indicate the number of
                                                          currently counted transactions.                                      */
    } PIPE3TRN_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE4TRE;                        /*!< PIPE Transaction Counter Enable Register                              */
    
    struct {
           uint16_t             :  8;
      __IO uint16_t  TRCLR      :  1;               /*!< Transaction Counter ClearSetting this bit to 1 allows clearing
                                                         the transaction counter to 0.                                         */
      __IO uint16_t  TRENB      :  1;               /*!< Transaction Counter EnableEnables or disables the transaction
                                                         counter function.                                                     */
    } PIPE4TRE_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE4TRN;                        /*!< PIPE Transaction Counter Register                                     */
    
    struct {
      __IO uint16_t  TRNCNT     : 16;               /*!< Transaction CounterWhen writing to: Specify the number of total
                                                         packets (number of transactions) to be received by the relevant
                                                          PIPE.When read from: When TRENB = 0: Indicate the specified
                                                          number of transactions.When TRENB = 1: Indicate the number of
                                                          currently counted transactions.                                      */
    } PIPE4TRN_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE5TRE;                        /*!< PIPE Transaction Counter Enable Register                              */
    
    struct {
           uint16_t             :  8;
      __IO uint16_t  TRCLR      :  1;               /*!< Transaction Counter ClearSetting this bit to 1 allows clearing
                                                         the transaction counter to 0.                                         */
      __IO uint16_t  TRENB      :  1;               /*!< Transaction Counter EnableEnables or disables the transaction
                                                         counter function.                                                     */
    } PIPE5TRE_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PIPE5TRN;                        /*!< PIPE Transaction Counter Register                                     */
    
    struct {
      __IO uint16_t  TRNCNT     : 16;               /*!< Transaction CounterWhen writing to: Specify the number of total
                                                         packets (number of transactions) to be received by the relevant
                                                          PIPE.When read from: When TRENB = 0: Indicate the specified
                                                          number of transactions.When TRENB = 1: Indicate the number of
                                                          currently counted transactions.                                      */
    } PIPE5TRN_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED9[11 * 4];
  
  union {
    __IO uint16_t  DEVADDn[6];                      /*!< Device Address Configuration Register                                 */
    
    struct {
           uint16_t             :  6;
      __IO uint16_t  USBSPD     :  2;               /*!< Transfer Speed of Communication Target Device                         */
      __IO uint16_t  HUBPORT    :  3;               /*!< Communication Target Connecting Hub Port                              */
      __IO uint16_t  UPPHUB     :  4;               /*!< Communication Target Connecting Hub Register                          */
    } DEVADDn_b[6];                                 /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED10[9 * 4];
  
  union {
    __IO uint16_t  LPCTRL;                          /*!< Low Power Control Register                                            */
    
    struct {
           uint16_t             :  7;
      __IO uint16_t  HWUPM      :  1;               /*!< Hardware return made control                                          */
    } LPCTRL_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  LPSTS;                           /*!< Low Power Status Register                                             */
    
    struct {
           uint16_t             : 14;
      __IO uint16_t  SUSPENDM   :  1;               /*!< UTMI SuspendM ControlThis bit controls the SuspendM signal to
                                                         the PHY designed under the UTMI specification.                        */
    } LPSTS_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED11[15 * 4];
  
  union {
    __IO uint16_t  BCCTRL;                          /*!< Battery Charging Control Register                                     */
    
    struct {
      __IO uint16_t  IDPSRCE    :  1;               /*!< IDPSRC Control                                                        */
      __IO uint16_t  IDMSINKE   :  1;               /*!< IDMSINK Control                                                       */
      __IO uint16_t  VDPSRCE    :  1;               /*!< VDPSRC Control                                                        */
      __IO uint16_t  IDPSINKE   :  1;               /*!< IDPSINK Control                                                       */
      __IO uint16_t  VDMSRCE    :  1;               /*!< VDMSRC Control                                                        */
      __IO uint16_t  DCPMODE    :  1;               /*!< DCP Mode Control                                                      */
           uint16_t             :  2;
      __I  uint16_t  CHGDETSTS  :  1;               /*!< CHGDET Status                                                         */
      __I  uint16_t  PDDETSTS   :  1;               /*!< PDDET Status                                                          */
    } BCCTRL_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED12[2];   // Padding changed from uint16_t
  
  union {
    __IO uint16_t  PL1CTRL1;                        /*!< Function L1 Control Register 1                                        */
    
    struct {
      __IO uint16_t  L1RESPEN   :  1;               /*!< L1 Response Enable                                                    */
      __IO uint16_t  L1RESPMD   :  2;               /*!< L1 Response Mode                                                      */
      __IO uint16_t  L1NEGOMD   :  1;               /*!< L1 Response Negotiation Control.NOTE: This bit is valid only
                                                         when the L1RESPMD[1:0] value is 2'b11.                                */
      __I  uint16_t  DVSQ       :  4;               /*!< DVSQ Extension.DVSQ[3] is Mirror of DVSQ[2:0] in INTSTS0.Indicates
                                                         the L1 state together with the device state bits DVSQ[2:0].           */
      __IO uint16_t  HIRDTHR    :  4;               /*!< L1 Response Negotiation Threshold ValueHIRD threshold value
                                                         used for L1NEGOMD.The format is the same as the HIRD field in
                                                          HL1CTRL.                                                             */
           uint16_t             :  2;
      __IO uint16_t  L1EXTMD    :  1;               /*!< PHY Control Mode at L1 Return                                         */
    } PL1CTRL1_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PL1CTRL2;                        /*!< Function L1 Control Register 2                                        */
    
    struct {
           uint16_t             :  8;
      __IO uint16_t  HIRDMON    :  4;               /*!< HIRD Value Monitor                                                    */
      __IO uint16_t  RWEMON     :  1;               /*!< RWE Value Monitor                                                     */
    } PL1CTRL2_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  HL1CTRL1;                        /*!< Host L1 Control Register 1                                            */
    
    struct {
      __IO uint16_t  L1REQ      :  1;               /*!< L1 Transition Request                                                 */
      __IO uint16_t  L1STATUS   :  2;               /*!< L1 Request Completion Status                                          */
    } HL1CTRL1_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  HL1CTRL2;                        /*!< Host L1 Control Register 2                                            */
    
    struct {
      __IO uint16_t  L1ADDR     :  4;               /*!< LPM Token DeviceAddressThese bits specify the value to be set
                                                         in the ADDR field of LPM token.                                       */
           uint16_t             :  4;
      __IO uint16_t  HIRD       :  4;               /*!< LPM Token HIRD                                                        */
      __IO uint16_t  L1RWE      :  1;               /*!< LPM Token L1 RemoteWake EnableThese bits specify the value to
                                                         be set in the RWE field of LPM token.                                 */
           uint16_t             :  2;
      __IO uint16_t  BESL       :  1;               /*!< BESL & Alternate HIRDThis bit selects the K-State drive period
                                                         at the time of L1 Resume.                                             */
    } HL1CTRL2_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED13[4];   // Padding changed from uint32_t
  
  union {
    __IO uint16_t  PHYTRIM1;                        /*!< PHY Timing Register 1                                                 */
    
    struct {
      __IO uint16_t  DRISE      :  2;               /*!< FS/LS Rising-Edge Output Waveform Adjustment Function                 */
      __IO uint16_t  DFALL      :  2;               /*!< FS/LS Falling-Edge Output Waveform Adjustment Function                */
           uint16_t             :  3;
      __IO uint16_t  PCOMPENB   :  1;               /*!< PVDD Start-up Detection                                               */
      __IO uint16_t  HSIUP      :  4;               /*!< HS Output Level Setting                                               */
      __IO uint16_t  IMPOFFSET  :  3;               /*!< terminating resistance offset value setting.Offset value for
                                                         adjusting the terminating resistance.                                 */
    } PHYTRIM1_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  PHYTRIM2;                        /*!< PHY Timing Register 2                                                 */
    
    struct {
      __IO uint16_t  SQU        :  4;               /*!< Squelch Detection Level                                               */
           uint16_t             :  3;
      __IO uint16_t  HSRXENMO   :  1;               /*!< HS Receive Enable Control Mode                                        */
      __IO uint16_t  PDR        :  2;               /*!< HS Output Adjustment Function                                         */
           uint16_t             :  2;
      __IO uint16_t  DIS        :  3;               /*!< Disconnect Detection Level                                            */
    } PHYTRIM2_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED14[3 * 4];
  
  union {
    __IO uint32_t  DPUSR0R;                         /*!< Deep Standby USB Transceiver Control/Pin Monitor Register             */
    
    struct {
           uint32_t             : 20;
      __I  uint32_t  DOVCAHM    :  1;               /*!< OVRCURA InputIndicates OVRCURA input signal on the HS side of
                                                         USB port.                                                             */
      __I  uint32_t  DOVCBHM    :  1;               /*!< OVRCURB InputIndicates OVRCURB input signal on the HS side of
                                                         USB port.                                                             */
           uint32_t             :  1;
      __I  uint32_t  DVBSTSHM   :  1;               /*!< VBUS InputIndicates VBUS input signal on the HS side of USB
                                                         port.                                                                 */
    } DPUSR0R_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  DPUSR1R;                         /*!< Deep Standby USB Suspend/Resume Interrupt Register                    */
    
    struct {
           uint32_t             :  4;
      __IO uint32_t  DOVCAHE    :  1;               /*!< OVRCURA Interrupt Enable Clear                                        */
      __IO uint32_t  DOVCBHE    :  1;               /*!< OVRCURB Interrupt Enable Clear                                        */
           uint32_t             :  1;
      __IO uint32_t  DVBSTSHE   :  1;               /*!< VBUS Interrupt Enable/Clear                                           */
           uint32_t             : 12;
      __I  uint32_t  DOVCAH     :  1;               /*!< Indication of Return from OVRCURA Interrupt Source                    */
      __I  uint32_t  DOVCBH     :  1;               /*!< Indication of Return from OVRCURB Interrupt Source                    */
           uint32_t             :  1;
      __I  uint32_t  DVBSTSH    :  1;               /*!< Indication of Return from VBUS Interrupt Source                       */
    } DPUSR1R_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  DPUSR2R;                         /*!< Deep Standby USB Suspend/Resume Interrupt Register                    */
    
    struct {
      __I  uint16_t  DPINT      :  1;               /*!< Indication of Return from DP Interrupt Source                         */
      __I  uint16_t  DMINT      :  1;               /*!< Indication of Return from DM Interrupt Source                         */
           uint16_t             :  2;
      __I  uint16_t  DPVAL      :  1;               /*!< DP InputIndicates DP input signal on the HS side of USB port.         */
      __I  uint16_t  DMVAL      :  1;               /*!< DM InputIndicates DM input signal on the HS side of USB port.         */
           uint16_t             :  2;
      __IO uint16_t  DPINTE     :  1;               /*!< DP Interrupt Enable Clear                                             */
      __IO uint16_t  DMINTE     :  1;               /*!< DM Interrupt Enable Clear                                             */
    } DPUSR2R_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint16_t  DPUSRCR;                         /*!< Deep Standby USB Suspend/Resume Command Register                      */
    
    struct {
      __IO uint16_t  FIXPHY     :  1;               /*!< USB Transceiver Control Fix                                           */
    } DPUSRCR_b;                                    /*!< BitSize                                                               */
  };
} R_USBHS_Type;


/* ================================================================================ */
/* ================                     R_SDHI0                    ================ */
/* ================================================================================ */


/**
  * @brief SD Host Interface 0 (R_SDHI0)
  */

typedef struct {                                    /*!< R_SDHI0 Structure                                                     */
  
  union {
    __IO uint32_t  SD_CMD;                          /*!< Command Type Register                                                 */
    
    struct {
      __IO uint32_t  CMDIDX     :  6;               /*!< Command IndexThese bits specify Command Format[45:40] (command
                                                         index).[Examples]CMD6: SD_CMD[7:0] = 8'b00_000110CMD18: SD_CMD[7:0]
                                                          = 8'b00_010010ACMD13: SD_CMD[7:0] = 8'b01_001101                     */
      __IO uint32_t  ACMD       :  2;               /*!< Command Type Select                                                   */
      __IO uint32_t  RSPTP      :  3;               /*!< Mode/Response TypeNOTE: As some commands cannot be used in normal
                                                         mode, see section 1.4.10, Example of SD_CMD Register Setting
                                                          to select mode/response type.                                        */
      __IO uint32_t  CMDTP      :  1;               /*!< Data Mode (Command Type)                                              */
      __IO uint32_t  CMDRW      :  1;               /*!< Write/Read Mode (enabled when the command with data is handled)       */
      __IO uint32_t  TRSTP      :  1;               /*!< Single/Multiple Block Transfer (enabled when the command with
                                                         data is handled)                                                      */
      __IO uint32_t  CMD12AT    :  2;               /*!< Multiple Block Transfer Mode (enabled at multiple block transfer)     */
    } SD_CMD_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SD_PORTSEL;                      /*!< SD Port Select Register                                               */
    
    struct {
      __IO uint32_t  P0         :  1;               /*!< SD Card / MMC Port Selection                                          */
           uint32_t             :  7;
      __I  uint32_t  NP         :  2;               /*!< Number of Supported SD Card / MMC Ports                               */
    } SD_PORTSEL_b;                                 /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SD_ARG;                          /*!< SD Command Argument Register                                          */
    
    struct {
      __IO uint32_t  SD_ARG     : 32;               /*!< Argument RegisterSet command format[39:8] (argument)                  */
    } SD_ARG_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SD_ARG1;                         /*!< SD Command Argument Register 1                                        */
    
    struct {
      __IO uint32_t  SD_ARG1    : 16;               /*!< Argument Register 1Set command format[39:24] (argument)               */
    } SD_ARG1_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SD_STOP;                         /*!< Data Stop Register                                                    */
    
    struct {
      __IO uint32_t  STP        :  1;               /*!< Stop- When STP is set to 1 during multiple block transfer, CMD12
                                                         is issued to halt the transfer through the SD host interface.However,
                                                          if a command sequence is halted because of a communications
                                                          error or timeout, CMD12 is not issued. Although continued buffer
                                                          access is possible even after STP has been set to 1, the buffer
                                                          access error bit (ERR5 or ERR4) in SD_INFO2 will be set accordingly.-
                                                          When STP has been set to 1 during transfer for single block
                                                          write, the access end flag is set when SD_BUF becomes emp            */
           uint32_t             :  7;
      __IO uint32_t  SEC        :  1;               /*!< Block Count EnableSet SEC to 1 at multiple block transfer.When
                                                         SD_CMD is set as follows to start the command sequence while
                                                          SEC is set to 1, CMD12 is automatically issued to stop multi-block
                                                          transfer with the number of blocks which is set to SD_SECCNT.1.
                                                          CMD18 or CMD25 in normal mode (SD_CMD[10:8] = 000)2. SD_CMD[15:13]
                                                          = 001 in extended mode (CMD12 is automatically issued, multiple
                                                          block transfer)When the command sequence is halted because of
                                                          a communications error or timeout, CMD12 is not automatically
                                                                                                                              */
          uint32_t             :  23;
   } SD_STOP_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SD_SECCNT;                       /*!< Block Count Register                                                  */
    
    struct {
      __IO uint32_t  SD_SECCNT  : 32;               /*!< Number of Transfer BlocksNOTE: Do not change the value of this
                                                         bit when the CBSY bit in SD_INFO2 is set to 1.                        */
    } SD_SECCNT_b;                                  /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  SD_RSP10;                        /*!< SD Card Response Register 10                                          */
    
    struct {
      __I  uint32_t  SD_RSP10   : 32;               /*!< Store the response from the SD card/MMC                               */
    } SD_RSP10_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  SD_RSP1;                         /*!< SD Card Response Register 1                                           */
    
    struct {
      __I  uint32_t  SD_RSP1    : 16;               /*!< Store the response from the SD card/MMC                               */
    } SD_RSP1_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  SD_RSP32;                        /*!< SD Card Response Register 32                                          */
    
    struct {
      __I  uint32_t  SD_RSP32   : 32;               /*!< Store the response from the SD card/MMC                               */
    } SD_RSP32_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  SD_RSP3;                         /*!< SD Card Response Register 3                                           */
    
    struct {
      __I  uint32_t  SD_RSP3    : 16;               /*!< Store the response from the SD card/MMC                               */
    } SD_RSP3_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  SD_RSP54;                        /*!< SD Card Response Register 54                                          */
    
    struct {
      __I  uint32_t  SD_RSP54   : 32;               /*!< Store the response from the SD card/MMC                               */
    } SD_RSP54_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  SD_RSP5;                         /*!< SD Card Response Register 5                                           */
    
    struct {
      __I  uint32_t  SD_RSP5    : 16;               /*!< Store the response from the SD card/MMC                               */
    } SD_RSP5_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  SD_RSP76;                        /*!< SD Card Response Register 76                                          */
    
    struct {
      __I  uint32_t  SD_RSP76   : 24;               /*!< Store the response from the SD card/MMC                               */
    } SD_RSP76_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  SD_RSP7;                         /*!< SD Card Response Register 7                                           */
    
    struct {
      __I  uint32_t  SD_RSP7    :  8;               /*!< Store the response from the SD card/MMC                               */
    } SD_RSP7_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SD_INFO1;                        /*!< SD Card Interrupt Flag Register 1                                     */
    
    struct {
      __IO uint32_t  RSPEND     :  1;               /*!< Response End                                                          */
           uint32_t             :  1;
      __IO uint32_t  ACEND      :  1;               /*!< Access End                                                            */
      __IO uint32_t  SDCDRM     :  1;               /*!< SDnCD Card Removal                                                    */
      __IO uint32_t  SDCDIN     :  1;               /*!< SDnCD Card Insertion                                                  */
      __I  uint32_t  CDS        :  1;               /*!< Indicates the SDnCD state                                             */
           uint32_t             :  1;
      __I  uint32_t  WPS        :  1;               /*!< Indicates the SDnWP state                                             */
      __IO uint32_t  DAT3RM     :  1;               /*!< SDnDAT3 Card Removal                                                  */
      __IO uint32_t  DAT3IN     :  1;               /*!< SDnDAT3 Card Insertion                                                */
      __I  uint32_t  DAT3S      :  1;               /*!< Indicates the SDnDAT3 State                                           */
      uint32_t                  : 21;
   } SD_INFO1_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SD_INFO2;                        /*!< SD Card Interrupt Flag Register 2                                     */
    
    struct {
      __IO uint32_t  CMDE       :  1;               /*!< Command Error                                                         */
      __IO uint32_t  CRCE       :  1;               /*!< CRC Error                                                             */
      __IO uint32_t  ENDE       :  1;               /*!< END Error                                                             */
      __IO uint32_t  DTO        :  1;               /*!< Data Timeout                                                          */
      __IO uint32_t  ILW        :  1;               /*!< SD_BUF Illegal Write Access                                           */
      __IO uint32_t  ILR        :  1;               /*!< SD_BUF Illegal Read Access                                            */
      __IO uint32_t  RSPTO      :  1;               /*!< Response Timeout                                                      */
      __I  uint32_t  DAT0       :  1;               /*!< SDDAT0Indicates the SDDAT0 state of the port specified by SD_PORTSEL. */
      __IO uint32_t  BRE        :  1;               /*!< SD_BUF Read Enable                                                    */
      __IO uint32_t  BWE        :  1;               /*!< SD_BUF Write Enable                                                   */
           uint32_t             :  3;
      __I  uint32_t  SCLKDIVEN  :  1;               /*!< When a command sequence is started by writing to SD_CMD, the
                                                         CBSY bit is set to 1 and, at the same time, the SCLKDIVEN bit
                                                          is set to 0. The SCLKDIVEN bit is set to 1 after 8 cycles of
                                                          SDCLK have elapsed after setting of the CBSY bit to 0 due to
                                                          completion of the command sequence.                                  */
      __I  uint32_t  CBSY       :  1;               /*!< Command Type Register Busy                                            */
      __IO uint32_t  ILA        :  1;               /*!< Illegal Access Error                                                  */
      uint32_t                  : 16;
   } SD_INFO2_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SD_INFO1_MASK;                   /*!< SD_INFO1 Interrupt Mask Register                                      */
    
    struct {
      __IO uint32_t  RSPENDM    :  1;               /*!< Response End Interrupt Request Mask                                   */
           uint32_t             :  1;
      __IO uint32_t  ACENDM     :  1;               /*!< Access End Interrupt Request Mask                                     */
      __IO uint32_t  SDCDRMM    :  1;               /*!< SDnCD card Removal Interrupt Request Mask                             */
      __IO uint32_t  SDCDINM    :  1;               /*!< SDnCD card Insertion Interrupt Request Mask                           */
           uint32_t             :  3;
      __IO uint32_t  DAT3RMM    :  1;               /*!< SDnDAT3 Card Removal Interrupt Request Mask                           */
      __IO uint32_t  DAT3INM    :  1;               /*!< SDnDAT3 Card Insertion Interrupt Request Mask                         */
      uint32_t                  : 22;
    } SD_INFO1_MASK_b;                              /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SD_INFO2_MASK;                   /*!< SD_INFO2 Interrupt Mask Register                                      */
    
    struct {
      __IO uint32_t  CMDE       :  1;               /*!< Command Error Interrupt Request Mask                                  */
      __IO uint32_t  CRCE       :  1;               /*!< CRC Error Interrupt Request Mask                                      */
      __IO uint32_t  ENDE       :  1;               /*!< End Bit Error Interrupt Request Mask                                  */
      __IO uint32_t  DTTO       :  1;               /*!< Data Timeout Interrupt Request Mask                                   */
      __IO uint32_t  ILWM       :  1;               /*!< SD_BUF Register Illegal Write Interrupt Request Mask                  */
      __IO uint32_t  ILRM       :  1;               /*!< SD_BUF Register Illegal Read Interrupt Request Mask                   */
      __IO uint32_t  RSPT       :  1;               /*!< Response Timeout Interrupt Request Mask                               */
           uint32_t             :  1;
      __IO uint32_t  BREM       :  1;               /*!< BRE Interrupt Request Mask                                            */
      __IO uint32_t  BWEM       :  1;               /*!< BWE Interrupt Request Mask                                            */
           uint32_t             :  5;
      __IO uint32_t  ILAM       :  1;               /*!< Illegal Access Error Interrupt Request Mask                           */
      uint32_t                  : 16;
    } SD_INFO2_MASK_b;                              /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SD_CLK_CTRL;                     /*!< SD Clock Control Register                                             */
    
    struct {
      __IO uint32_t  DIV        :  8;               /*!< SD/MMC Clock                                                          */
      __IO uint32_t  SCLKEN     :  1;               /*!< SD/MMC Clock Output Control Enable                                    */
      __IO uint32_t  SDCLKOFFEN :  1;               /*!< SD/MMC Clock Output Automatic Control Enable                          */
      uint32_t                  : 22;
    } SD_CLK_CTRL_b;                                /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SD_SIZE;                         /*!< Transfer Data Length Register                                         */
    
    struct {
      __IO uint32_t  LEN        : 10;               /*!< Transfer Data SizeThese bits specify a size between 1 and 512
                                                         bytes for the transfer of single blocks.In cases of multiple
                                                          block transfer with automatic issuing of CMD12 (CMD18 and CMD25),
                                                          the only specifiable transfer data size is 512 bytes. Furthermore,
                                                          in cases of multiple block transfer without automatic issuing
                                                          of CMD12, as well as 512 bytes, 32, 64, 128, and 256 bytes are
                                                          specifiable. However, in the reading of 32, 64, 128, and 256
                                                          bytes for the transfer of multiple blocks, this is restricted
                                                          to mult                                                              */
      uint32_t                  : 22;
   } SD_SIZE_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SD_OPTION;                       /*!< SD Card Access Control Option Register                                */
    
    struct {
      __IO uint32_t  CTOP       :  4;               /*!< Card Detect Time Counter                                              */
      __IO uint32_t  TOP        :  4;               /*!< Timeout Counter                                                       */
      __IO uint32_t  TOUTMASK   :  1;               /*!< Timeout MASKWhen timeout occurs in case of inactivating timeout,
                                                         software reset should be executed to terminate command sequence.      */
           uint32_t             :  4;
      __IO uint32_t  WIDTH8     :  1;               /*!< Bus Widthsee WIDTH                                                    */
           uint32_t             :  1;
      __IO uint32_t  WIDTH      :  1;               /*!< Bus WidthNOTE: Do not set this bit to 1 if data are to be transferred
                                                         in DDR mode (by setting the DDR bit in SDIF_MODE to 1). In case
                                                          of 1-byte write transfer, it is not able to set 8-bit width,
                                                          set 4-bit width or 1-bit width.                                      */
      uint32_t                  : 16;
    } SD_OPTION_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED[4];   // Padding changed from uint32_t
  
  union {
    __I  uint32_t  SD_ERR_STS1;                     /*!< SD Error Status Register 1                                            */
    
    struct {
      __I  uint32_t  CMDE0      :  1;               /*!< Command Error 0NOTE: other than a response to a command issued
                                                         within a command sequence                                             */
      __I  uint32_t  CMDE1      :  1;               /*!< Command Error 1NOTE: In cases where CMD12 is issued by setting
                                                         a command index in SD_CMD, this is Indicated in CMDE0.                */
      __I  uint32_t  RSPLENE0   :  1;               /*!< Response Length Error 0NOTE: other than a response to a command
                                                         issued within a command sequence                                      */
      __I  uint32_t  RSPLENE1   :  1;               /*!< Response Length Error 1NOTE: In cases where CMD12 is issued
                                                         by setting a command index in SD_CMD, this is indicated in RSPLENE0.  */
      __I  uint32_t  RDLENE     :  1;               /*!< Read Data Length Error                                                */
      __I  uint32_t  CRCLENE    :  1;               /*!< CRC Status Token Length Error                                         */
           uint32_t             :  2;
      __I  uint32_t  RSPCRCE0   :  1;               /*!< Response CRC Error 0NOTE: other than a response to a command
                                                         issued within a command sequence                                      */
      __I  uint32_t  RSPCRCE1   :  1;               /*!< Response CRC Error 1NOTE: In cases where CMD12 is issued by
                                                         setting a command index in SD_CMD, this is indicated in RSPCRCE0.     */
      __I  uint32_t  RDCRCE     :  1;               /*!< Read Data CRC Error                                                   */
      __I  uint32_t  CRCTKE     :  1;               /*!< CRC Status Token Error                                                */
      __I  uint32_t  CRCTK      :  3;               /*!< CRC Status TokenStore the CRC status token value (normal value
                                                         is 010b)                                                              */
      uint32_t                  : 17;
 } SD_ERR_STS1_b;                                /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  SD_ERR_STS2;                     /*!< SD Error Status Register 2                                            */
    
    struct {
      __I  uint32_t  RSPTO0     :  1;               /*!< Response Timeout 0                                                    */
      __I  uint32_t  RSPTO1     :  1;               /*!< Response Timeout 1                                                    */
      __I  uint32_t  BSYTO0     :  1;               /*!< Busy Timeout 0                                                        */
      __I  uint32_t  BSYTO1     :  1;               /*!< Busy Timeout 1                                                        */
      __I  uint32_t  RDTO       :  1;               /*!< Read Data Timeout                                                     */
      __I  uint32_t  CRCTO      :  1;               /*!< CRC Status Token Timeout                                              */
      __I  uint32_t  CRCBSYTO   :  1;               /*!< CRC Status Token Busy Timeout                                         */
      uint32_t                  : 25;
    } SD_ERR_STS2_b;                                /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SD_BUF0;                         /*!< SD Buffer Read/Write Register                                         */
    
    struct {
      __IO uint32_t  SD_BUF     : 32;               /*!< SD Buffer RegisterWhen writing to the SD card, the write data
                                                         is written to this register. When reading from the SD card,
                                                          the read data is read from this register. This register is internally
                                                          connected to two 512-byte buffers.If both buffers are not empty
                                                          when executing multiple block read, SD/MMC clock is stopped
                                                          to suspend receiving data. When one of buffers is empty, SD/MMC
                                                          clock is supplied to resume receiving data.                          */
    } SD_BUF0_b;                                    /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED1[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  SDIO_MODE;                       /*!< SDIO Mode Control Register                                            */
    
    struct {
      __IO uint32_t  IOMOD      :  1;               /*!< SDIO Mode                                                             */
           uint32_t             :  1;
      __IO uint32_t  RWREQ      :  1;               /*!< Read Wait RequestWhen RWREQ is set to 1 in the CMD53 (multiple
                                                         block) read sequence, the block transfer enters the read wait
                                                          state between blocks.NOTE: See manual                                */
           uint32_t             :  5;
      __IO uint32_t  IOABT      :  1;               /*!< SDIO AbortNOTE: See manual                                            */
      __IO uint32_t  C52PUB     :  1;               /*!< SDIO None AbortNOTE: See manual                                       */
      uint32_t                  :  22;
    } SDIO_MODE_b;                                  /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SDIO_INFO1;                      /*!< SDIO Interrupt Flag Register 1                                        */
    
    struct {
      __IO uint32_t  IOIRQ      :  1;               /*!< SDIO Interrupt Status                                                 */
           uint32_t             : 13;
      __IO uint32_t  EXPUB52    :  1;               /*!< EXPUB52 Status FlagNOTE: See manual                                   */
      __IO uint32_t  EXWT       :  1;               /*!< EXWT Status FlagNOTE: See manual                                      */
    } SDIO_INFO1_b;                                 /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SDIO_INFO1_MASK;                 /*!< SDIO_INFO1 Interrupt Mask Register                                    */
    
    struct {
      __IO uint32_t  IOIRQM     :  1;               /*!< IOIRQ Interrupt Mask Control                                          */
           uint32_t             : 13;
      __IO uint32_t  EXPUB52M   :  1;               /*!< EXPUB52 Interrupt Request Mask Control                                */
      __IO uint32_t  EXWTM      :  1;               /*!< EXWT Interrupt Request Mask Control                                   */
    } SDIO_INFO1_MASK_b;                            /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED2[79 * 4];
  
  union {
    __IO uint32_t  SD_DMAEN;                        /*!< DMA Mode Enable Register                                              */
    
    struct {
           uint32_t             :  1;
      __IO uint32_t  DMAEN      :  1;               /*!< SD_BUF Read/Write DMA Transfer                                        */
    } SD_DMAEN_b;                                   /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED3[3 * 4];
  
  union {
    __IO uint32_t  SOFT_RST;                        /*!< Software Reset Register                                               */
    
    struct {
      __IO uint32_t  SDRST      :  1;               /*!< Software Reset of SD I/F Unit                                         */
    } SOFT_RST_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  VERSION;                         /*!< Version Register                                                      */
    
    struct {
      __I  uint32_t  IP1        :  8;               /*!< Version of adopted IP                                                 */
      __I  uint32_t  IP2        :  4;               /*!< Version of Renesas IP                                                 */
           uint32_t             :  2;
      __I  uint32_t  CLKRAT     :  1;               /*!< SD/MMC clock :IMCLK = 1:1 Capability                                  */
      __I  uint32_t  CPRM       :  1;               /*!< CPRM Present/Absent                                                   */
    } VERSION_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  HOST_MODE;                       /*!< Host Interface Mode Setting Register                                  */
    
    struct {
      __IO uint32_t  WMODE      :  1;               /*!< Width for access to SD_BUF*                                           */
    } HOST_MODE_b;                                  /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SDIF_MODE;                       /*!< SD Interface Mode Setting Register                                    */
    
    struct {
      __IO uint32_t  DDR        :  1;               /*!< DDR Mode Selection                                                    */
           uint32_t             :  7;
      __IO uint32_t  NOCHKCR    :  1;               /*!< CRC Check Mask (for MMC test commands)                                */
    } SDIF_MODE_b;                                  /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED4[4 * 4];
  
  union {
    __IO uint32_t  EXT_SWAP;                        /*!< Swap Control Register                                                 */
    
    struct {
           uint32_t             :  6;
      __IO uint32_t  SDBWSWAP   :  1;               /*!< SD_BUF0 Swap Write                                                    */
      __IO uint32_t  SDBRSWAP   :  1;               /*!< SD_BUF0 Swap Read                                                     */
    } EXT_SWAP_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  SD_STATUS;                       /*!< SD Status Register                                                    */
    
    struct {
      __IO uint32_t  PWR        :  2;               /*!< Controls the OPOWR[1:0] pins. Set this bit in combination with
                                                         bit 0.                                                                */
           uint32_t             :  2;
      __IO uint32_t  OSTATUS1   :  2;               /*!< Controls OSTATUS1[1:0].The register value is output to OSTATUS1[1:0]. */
           uint32_t             :  2;
      __IO uint32_t  OSTATUS2   :  3;               /*!< Controls OSTATUS2[2:0].The register value is output to OSTATUS2[2:0]. */
    } SD_STATUS_b;                                  /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  EXT_SDIO;                        /*!< Extended Port SDIO Interrupt Register                                 */
    
    struct {
      __IO uint32_t  IOIRQ1     :  1;               /*!< SDIO interrupt                                                        */
           uint32_t             :  3;
      __IO uint32_t  IOMOD1     :  1;               /*!< Port 1 SD IO ModeNOTE: Do not change the value of this bit while
                                                         the CBSY bit in SD_INFO2 is set to 1.                                 */
           uint32_t             :  3;
      __IO uint32_t  IOMSK1     :  1;               /*!< IOIRQ1 Interrupt Mask                                                 */
    } EXT_SDIO_b;                                   /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  EXT_WP;                          /*!< Extended Port Write Protect Register                                  */
    
    struct {
      __I  uint32_t  PORT1      :  1;               /*!< ISD1WP state                                                          */
    } EXT_WP_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  EXT_CD;                          /*!< Extended Port Card Detect (ISDCD) Register                            */
    
    struct {
      __IO uint32_t  P1REM      :  1;               /*!< ISD1CD Card Removal                                                   */
      __IO uint32_t  P1INS      :  1;               /*!< ISD1CD Card Insertion                                                 */
      __I  uint32_t  P1CD       :  1;               /*!< ISD1CD State                                                          */
    } EXT_CD_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  EXT_CD_DAT3;                     /*!< Extended Port Card Detect (SDDAT3) Register                           */
    
    struct {
      __IO uint32_t  P1DREM     :  1;               /*!< SD1DAT3 Card Removal[Setting condition]After change in SD1DAT3
                                                         from 1 to 0, two cycles of IMCLK has elapsed with SD1DAT3 held
                                                          0.[Clearing condition]                                               */
      __IO uint32_t  P1DINS     :  1;               /*!< SD1DAT3 Card Insertion[Setting condition]After change in SD1DAT3
                                                         from 0 to 1, two cycles of IMCLK has elapsed with SD1DAT3 held
                                                          1.[Clearing condition]When 0 is written to P1DINS                    */
      __I  uint32_t  P1DCD      :  1;               /*!< SD1DAT3 State                                                         */
    } EXT_CD_DAT3_b;                                /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  EXT_CD_MASK;                     /*!< EXT_CD Interrupt Mask Register                                        */
    
    struct {
      __IO uint32_t  MASK0      :  1;               /*!< P1REM interrupt masked                                                */
      __IO uint32_t  MASK1      :  1;               /*!< P1INS interrupt masked                                                */
    } EXT_CD_MASK_b;                                /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  EXT_CD_DAT3_MASK;                /*!< EXT_CD_DAT3 Interrupt Mask Register                                   */
    
    struct {
      __IO uint32_t  DMASK0     :  1;               /*!< P1DREM interrupt masked                                               */
      __IO uint32_t  DMASK1     :  1;               /*!< P1DINS interrupt masked                                               */
    } EXT_CD_DAT3_MASK_b;                           /*!< BitSize                                                               */
  };
} R_SDHI0_Type;


/* ================================================================================ */
/* ================                    R_EDMAC0                    ================ */
/* ================================================================================ */


/**
  * @brief DMA Controller for the Ethernet Controller Channel 0 (R_EDMAC0)
  */

typedef struct {                                    /*!< R_EDMAC0 Structure                                                    */
  
  union {
    __IO uint32_t  EDMR;                            /*!< EDMAC Mode Register                                                   */
    
    struct {
      __O  uint32_t  SWR        :  1;               /*!< Software Reset                                                        */
           uint32_t             :  3;
      __IO uint32_t  DL         :  2;               /*!< Transmit/Receive DescriptorLength                                     */
      __IO uint32_t  DE         :  1;               /*!< Big Endian Mode/Little Endian ModeNOTE: This setting applies
                                                         to data for the transmit/receive buffer. It does not apply to
                                                          transmit/receive descriptors and registers.                          */
    } EDMR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  EDTRR;                           /*!< EDMAC Transmit Request Register                                       */
    
    struct {
      __O  uint32_t  TR         :  1;               /*!< Transmit Request                                                      */
    } EDTRR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED1[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  EDRRR;                           /*!< EDMAC Receive Request Register                                        */
    
    struct {
      __IO uint32_t  RR         :  1;               /*!< Receive Request                                                       */
    } EDRRR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED2[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  TDLAR;                           /*!< Transmit Descriptor List Start Address Register                       */
    
    struct {
      __IO uint32_t  TDLAR      : 32;               /*!< The start address of the transmit descriptor list is set. Set
                                                         the start address according to the descriptor length selected
                                                          by the EDMR.DL[1:0] bits.16-byte boundary: Lower 4 bits = 0000b32-byte
                                                          boundary: Lower 5 bits = 00000b64-byte boundary: Lower 6 bits
                                                          = 000000b                                                            */
    } TDLAR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED3[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  RDLAR;                           /*!< Receive Descriptor List Start Address Register                        */
    
    struct {
      __IO uint32_t  RDLAR      : 32;               /*!< The start address of the receive descriptor list is set. Set
                                                         the start address according to the descriptor length selected
                                                          by the EDMR.DL[1:0] bits.16-byte boundary: Lower 4 bits = 0000b32-byte
                                                          boundary: Lower 5 bits = 00000b64-byte boundary: Lower 6 bits
                                                          = 000000b                                                            */
    } RDLAR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED4[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  EESR;                            /*!< ETHERC/EDMAC Status Register                                          */
    
    struct {
      __IO uint32_t  CERF       :  1;               /*!< CRC Error Flag                                                        */
      __IO uint32_t  PRE        :  1;               /*!< PHY-LSI Receive Error Flag                                            */
      __IO uint32_t  RTSF       :  1;               /*!< Frame-Too-Short Error Flag                                            */
      __IO uint32_t  RTLF       :  1;               /*!< Frame-Too-Long Error Flag                                             */
      __IO uint32_t  RRF        :  1;               /*!< Alignment Error Flag                                                  */
           uint32_t             :  2;
      __IO uint32_t  RMAF       :  1;               /*!< Multicast Address Frame Receive Flag                                  */
      __IO uint32_t  TRO        :  1;               /*!< Transmit Retry Over Flag                                              */
      __IO uint32_t  CD         :  1;               /*!< Late Collision Detect Flag                                            */
      __IO uint32_t  DLC        :  1;               /*!< Loss of Carrier Detect Flag                                           */
      __IO uint32_t  CND        :  1;               /*!< Carrier Not Detect Flag                                               */
           uint32_t             :  4;
      __IO uint32_t  RFOF       :  1;               /*!< Receive FIFO Overflow Flag                                            */
      __IO uint32_t  RDE        :  1;               /*!< Receive Descriptor Empty Flag                                         */
      __IO uint32_t  FR         :  1;               /*!< Frame Receive Flag                                                    */
      __IO uint32_t  TFUF       :  1;               /*!< Transmit FIFO Underflow Flag                                          */
      __IO uint32_t  TDE        :  1;               /*!< Transmit Descriptor Empty Flag                                        */
      __IO uint32_t  TC         :  1;               /*!< Frame Transfer Complete Flag                                          */
      __I  uint32_t  ECI        :  1;               /*!< ETHERC Status Register Source FlagNOTE: When the source in the
                                                         ETHERCn.ECSR register is cleared, the ECI flag is also cleared.       */
      __IO uint32_t  ADE        :  1;               /*!< Address Error Flag                                                    */
      __IO uint32_t  RFCOF      :  1;               /*!< Receive Frame Counter Overflow Flag                                   */
      __IO uint32_t  RABT       :  1;               /*!< Receive Abort Detect Flag                                             */
      __IO uint32_t  TABT       :  1;               /*!< Transmit Abort Detect Flag                                            */
           uint32_t             :  3;
      __IO uint32_t  TWB        :  1;               /*!< Write-Back Complete Flag                                              */
    } EESR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED5[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  EESIPR;                          /*!< ETHERC/EDMAC Status Interrupt Enable Register                         */
    
    struct {
      __IO uint32_t  CERFIP     :  1;               /*!< CRC Error Interrupt Request Enable                                    */
      __IO uint32_t  PREIP      :  1;               /*!< PHY-LSI Receive Error Interrupt Request Enable                        */
      __IO uint32_t  RTSFIP     :  1;               /*!< Frame-Too-Short Error Interrupt Request Enable                        */
      __IO uint32_t  RTLFIP     :  1;               /*!< Frame-Too-Long Error Interrupt Request Enable                         */
      __IO uint32_t  RRFIP      :  1;               /*!< Alignment Error Interrupt Request Enable                              */
           uint32_t             :  2;
      __IO uint32_t  RMAFIP     :  1;               /*!< Multicast Address Frame Receive Interrupt Request Enable              */
      __IO uint32_t  TROIP      :  1;               /*!< Transmit Retry Over Interrupt Request Enable                          */
      __IO uint32_t  CDIP       :  1;               /*!< Late Collision Detect Interrupt Request Enable                        */
      __IO uint32_t  DLCIP      :  1;               /*!< Loss of Carrier Detect Interrupt Request Enable                       */
      __IO uint32_t  CNDIP      :  1;               /*!< Carrier Not Detect Interrupt Request Enable                           */
           uint32_t             :  4;
      __IO uint32_t  RFOFIP     :  1;               /*!< Receive FIFO Overflow Interrupt Request Enable                        */
      __IO uint32_t  RDEIP      :  1;               /*!< Receive Descriptor Empty Interrupt Request Enable                     */
      __IO uint32_t  FRIP       :  1;               /*!< Frame Receive Interrupt Request Enable                                */
      __IO uint32_t  TFUFIP     :  1;               /*!< Transmit FIFO Underflow Interrupt Request Enable                      */
      __IO uint32_t  TDEIP      :  1;               /*!< Transmit Descriptor Empty Interrupt Request Enable                    */
      __IO uint32_t  TCIP       :  1;               /*!< Frame Transfer Complete Interrupt Request Enable                      */
      __IO uint32_t  ECIIP      :  1;               /*!< ETHERC Status Register Source Interrupt Request Enable                */
      __IO uint32_t  ADEIP      :  1;               /*!< Address Error Interrupt Request Enable                                */
      __IO uint32_t  RFCOFIP    :  1;               /*!< Receive Frame Counter Overflow Interrupt Request Enable               */
      __IO uint32_t  RABTIP     :  1;               /*!< Receive Abort Detect Interrupt Request Enable                         */
      __IO uint32_t  TABTIP     :  1;               /*!< Transmit Abort Detect Interrupt Request Enable                        */
           uint32_t             :  3;
      __IO uint32_t  TWBIP      :  1;               /*!< Write-Back Complete Interrupt Request Enable                          */
    } EESIPR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED6[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  TRSCER;                          /*!< ETHERC/EDMAC Transmit/Receive Status Copy Enable Register             */
    
    struct {
           uint32_t             :  4;
      __IO uint32_t  RRFCE      :  1;               /*!< RRF Flag Copy Enable                                                  */
           uint32_t             :  2;
      __IO uint32_t  RMAFCE     :  1;               /*!< RMAF Flag Copy Enable                                                 */
    } TRSCER_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED7[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  RMFCR;                           /*!< Missed-Frame Counter Register                                         */
    
    struct {
      __IO uint32_t  MFC        : 16;               /*!< Missed-Frame CounterThese bits indicate the number of frames
                                                         that are discarded and not transferred to the receive buffer
                                                          during reception.                                                    */
    } RMFCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED8[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  TFTR;                            /*!< Transmit FIFO Threshold Register                                      */
    
    struct {
      __IO uint32_t  TFT        : 11;               /*!< Transmit FIFO Threshold00Dh to 200h: The threshold is the set
                                                         value multiplied by 4. Example: 00Dh: 52 bytes 040h: 256 bytes
                                                          100h: 1024 bytes 200h: 2048 bytes                                    */
    } TFTR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED9[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  FDR;                             /*!< Transmit FIFO Threshold Register                                      */
    
    struct {
      __IO uint32_t  RFD        :  5;               /*!< Transmit FIFO Depth                                                   */
           uint32_t             :  3;
      __IO uint32_t  TFD        :  5;               /*!< Receive FIFO Depth                                                    */
    } FDR_b;                                        /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED10[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  RMCR;                            /*!< Receive Method Control Register                                       */
    
    struct {
      __IO uint32_t  RNR        :  1;               /*!< Receive Request Reset                                                 */
    } RMCR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED11[2 * 4];
  
  union {
    __IO uint32_t  TFUCR;                           /*!< Transmit FIFO Underflow Counter                                       */
    
    struct {
      __IO uint32_t  UNDER      : 16;               /*!< Transmit FIFO Underflow CountThese bits indicate how many times
                                                         the transmit FIFO has underflowed. The counter stops when the
                                                          counter value reaches FFFFh.                                         */
    } TFUCR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  RFOCR;                           /*!< Receive FIFO Overflow Counter                                         */
    
    struct {
      __IO uint32_t  OVER       : 16;               /*!< Receive FIFO Overflow CountThese bits indicate how many times
                                                         the receive FIFO has overflowed. The counter stops when the
                                                          counter value reaches FFFFh.                                         */
    } RFOCR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  IOSR;                            /*!< Independent Output Signal Setting Register                            */
    
    struct {
      __IO uint32_t  ELB        :  1;               /*!< External Loopback Mode                                                */
    } IOSR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  FCFTR;                           /*!< Flow Control Start FIFO Threshold Setting Register                    */
    
    struct {
      __IO uint32_t  RFDO       :  3;               /*!< Receive FIFO Data PAUSE Output Threshold(When (RFDO+1)x256-32
                                                         bytes of data is stored in the receive FIFO.)                         */
           uint32_t             : 13;
      __IO uint32_t  RFFO       :  3;               /*!< Receive FIFO Frame PAUSE Output Threshold(When ((RFFO+1)x2)
                                                         receive frames have been stored in the receive FIFO.)                 */
    } FCFTR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED12[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  RPADIR;                          /*!< Receive Data Padding Insert Register                                  */
    
    struct {
      __IO uint32_t  PADR       :  6;               /*!< Padding Slot                                                          */
           uint32_t             : 10;
      __IO uint32_t  PADS       :  2;               /*!< Padding Size                                                          */
    } RPADIR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  TRIMD;                           /*!< Transmit Interrupt Setting Register                                   */
    
    struct {
      __IO uint32_t  TIS        :  1;               /*!< Transmit Interrupt EnableSet the EESR.TWB flag to 1 in the mode
                                                         selected by the TIM bit to notify an interrupt.                       */
           uint32_t             :  3;
      __IO uint32_t  TIM        :  1;               /*!< Transmit Interrupt Mode                                               */
    } TRIMD_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED13[18 * 4];
  
  union {
    __IO uint32_t  RBWAR;                           /*!< Receive Buffer Write Address Register                                 */
    
    struct {
      __I  uint32_t  RBWAR      : 32;               /*!< Receive Buffer Write Address RegisterThe RBWAR register indicates
                                                         the last address that the EDMAC has written data to when writing
                                                          to the receive buffer.Refer to the address indicated by the
                                                          RBWAR register to recognize which address in the receive buffer
                                                          the EDMAC is writing data to. Note that the address that the
                                                          EDMAC is outputting to the receive buffer may not match the
                                                          read value of the RBWAR register during data reception.              */
    } RBWAR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  RDFAR;                           /*!< Receive Descriptor Fetch Address Register                             */
    
    struct {
      __I  uint32_t  RDFAR      : 32;               /*!< Receive Descriptor Fetch Address RegisterThe RDFAR register
                                                         indicates the start address of the last fetched receive descriptor
                                                          when the EDMAC fetches descriptor information from the receive
                                                          descriptor.Refer to the address indicated by the RDFAR register
                                                          to recognize which receive descriptor information the EDMAC
                                                          is using for the current processing. Note that the address of
                                                          the receive descriptor that the EDMAC fetches may not match
                                                          the read value of the RDFAR register during data reception.          */
    } RDFAR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED14[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  TBRAR;                           /*!< Transmit Buffer Read Address Register                                 */
    
    struct {
      __I  uint32_t  TBRAR      : 32;               /*!< Transmit Buffer Read Address RegisterThe TBRAR register indicates
                                                         the last address that the EDMAC has read data from when reading
                                                          data from the transmit buffer.Refer to the address indicated
                                                          by the TBRAR register to recognize which address in the transmit
                                                          buffer the EDMAC is reading from. Note that the address that
                                                          the EDMAC is outputting to the transmit buffer may not match
                                                          the read value of the TBRAR register.                                */
    } TBRAR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __I  uint32_t  TDFAR;                           /*!< Transmit Descriptor Fetch Address Register                            */
    
    struct {
      __I  uint32_t  TDFAR      : 32;               /*!< Transmit Descriptor Fetch Address RegisterThe TDFAR register
                                                         indicates the start address of the last fetched transmit descriptor
                                                          when the EDMAC fetches descriptor information from the transmit
                                                          descriptor.Refer to the address indicated by the TDFAR register
                                                          to recognize which transmit descriptor information the EDMAC
                                                          is using for the current processing. Note that the address of
                                                          the transmit descriptor that the EDMAC fetches may not match
                                                          the read value of the TDFAR register.                                */
    } TDFAR_b;                                      /*!< BitSize                                                               */
  };
} R_EDMAC0_Type;


/* ================================================================================ */
/* ================                    R_ETHERC0                   ================ */
/* ================================================================================ */


/**
  * @brief Ethernet Controller Channel 0 (R_ETHERC0)
  */

typedef struct {                                    /*!< R_ETHERC0 Structure                                                   */
  
  union {
    __IO uint32_t  ECMR;                            /*!< ETHERC Mode Register                                                  */
    
    struct {
      __IO uint32_t  PRM        :  1;               /*!< Promiscuous Mode                                                      */
      __IO uint32_t  DM         :  1;               /*!< Duplex Mode                                                           */
      __IO uint32_t  RTM        :  1;               /*!< Bit Rate                                                              */
      __IO uint32_t  ILB        :  1;               /*!< Internal Loopback Mode                                                */
           uint32_t             :  1;
      __IO uint32_t  TE         :  1;               /*!< Transmission Enable                                                   */
      __IO uint32_t  RE         :  1;               /*!< Reception Enable                                                      */
           uint32_t             :  2;
      __IO uint32_t  MPDE       :  1;               /*!< Magic Packet Detection Enable                                         */
           uint32_t             :  2;
      __IO uint32_t  PRCEF      :  1;               /*!< CRC Error Frame Receive Mode                                          */
           uint32_t             :  3;
      __IO uint32_t  TXF        :  1;               /*!< Transmit Flow Control Operating Mode                                  */
      __IO uint32_t  RXF        :  1;               /*!< Receive Flow Control Operating Mode                                   */
      __IO uint32_t  PFR        :  1;               /*!< PAUSE Frame Receive Mode                                              */
      __IO uint32_t  ZPF        :  1;               /*!< 0 Time PAUSE Frame Enable                                             */
      __IO uint32_t  TPC        :  1;               /*!< PAUSE Frame Transmit                                                  */
    } ECMR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  RFLR;                            /*!< Receive Frame Maximum Length Register                                 */
    
    struct {
      __IO uint32_t  RFL        : 12;               /*!< Receive Frame Maximum LengthThe set value becomes the maximum
                                                         frame length. The minimum value that can be set is 1,518 bytes,
                                                          and the maximum value that can be set is 2,048 bytes. Values
                                                          that are less than 1,518 bytes are regarded as 1,518 bytes,
                                                          and values larger than 2,048 bytes are regarded as 2,048 bytes.      */
    } RFLR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED1[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  ECSR;                            /*!< ETHERC Status Register                                                */
    
    struct {
      __IO uint32_t  ICD        :  1;               /*!< False Carrier Detect Flag                                             */
      __IO uint32_t  MPD        :  1;               /*!< Magic Packet Detect Flag                                              */
      __IO uint32_t  LCHNG      :  1;               /*!< LCHNG Link Signal Change Flag                                         */
           uint32_t             :  1;
      __IO uint32_t  PSRTO      :  1;               /*!< PAUSE Frame Retransmit Over Flag                                      */
      __IO uint32_t  BFR        :  1;               /*!< Continuous Broadcast Frame Reception Flag                             */
    } ECSR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED2[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  ECSIPR;                          /*!< ETHERC Interrupt Enable Register                                      */
    
    struct {
      __IO uint32_t  ICDIP      :  1;               /*!< False Carrier Detect Interrupt Enable                                 */
      __IO uint32_t  MPDIP      :  1;               /*!< Magic Packet Detect Interrupt Enable                                  */
      __IO uint32_t  LCHNGIP    :  1;               /*!< LINK Signal Change Interrupt Enable                                   */
           uint32_t             :  1;
      __IO uint32_t  PSRTOIP    :  1;               /*!< PAUSE Frame Retransmit Over Interrupt Enable                          */
      __IO uint32_t  BFSIPR     :  1;               /*!< Continuous Broadcast Frame Reception Interrupt Enable                 */
    } ECSIPR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED3[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  PIR;                             /*!< PHY Interface Register                                                */
    
    struct {
      __IO uint32_t  MDC        :  1;               /*!< MII/RMII Management Data ClockThe MDC bit value is output from
                                                         the ETn_MDC pin to supply the management data clock to the MII
                                                          or RMII.                                                             */
      __IO uint32_t  MMD        :  1;               /*!< MII/RMII Management Mode                                              */
      __IO uint32_t  MDO        :  1;               /*!< MII/RMII Management Data-OutThe MDO bit value is output from
                                                         the ETn_MDIO pin when the MMD bit is 1 (write). The value is
                                                          not output when the MMD bit is 0 (read).                             */
      __I  uint32_t  MDI        :  1;               /*!< MII/RMII Management Data-InThis bit indicates the level of the
                                                         ETn_MDIO pin. The write value should be 0.                            */
    } PIR_b;                                        /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED4[4];   // Padding changed from uint32_t
  
  union {
    __I  uint32_t  PSR;                             /*!< PHY Status Register                                                   */
    
    struct {
      __I  uint32_t  LMON       :  1;               /*!< ETn_LINKSTA Pin Status FlagThe link status can be read by connecting
                                                         the link signal output from the PHY-LSI to the ETn_LINKSTA pin.
                                                          For details on the polarity, refer to the specifications of
                                                          the connected PHY-LSI.                                               */
    } PSR_b;                                        /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED5[5 * 4];
  
  union {
    __IO uint32_t  RDMLR;                           /*!< Random Number Generation Counter Upper Limit Setting Register         */
    
    struct {
      __IO uint32_t  RMD        : 20;               /*!< Random Number Generation Counter                                      */
    } RDMLR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED6[3 * 4];
  
  union {
    __IO uint32_t  IPGR;                            /*!< IPG Register                                                          */
    
    struct {
      __IO uint32_t  IPG        :  5;               /*!< Interpacket Gap Range:"16bit time(0x00)"-"140bit time(0x1F)"
                                                                                                                               */
    } IPGR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  APR;                             /*!< Automatic PAUSE Frame Register                                        */
    
    struct {
      __IO uint32_t  AP         : 16;               /*!< Automatic PAUSE Time SettingThese bits set the value of the
                                                         pause_time parameter for a PAUSE frame that is automatically
                                                          transmitted. Transmission is not performed until the set value
                                                          multiplied by 512 bit time has elapsed.                              */
    } APR_b;                                        /*!< BitSize                                                               */
  };
  
  union {
    __O  uint32_t  MPR;                             /*!< Manual PAUSE Frame Register                                           */
    
    struct {
      __O  uint32_t  MP         : 16;               /*!< Manual PAUSE Time SettingThese bits set the value of the pause_time
                                                         parameter for a PAUSE frame that is manually transmitted. Transmission
                                                          is not performed until the set value multiplied by 512 bit time
                                                          has elapsed. The read value is undefined.                            */
    } MPR_b;                                        /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED7[4];   // Padding changed from uint32_t
  
  union {
    __I  uint32_t  RFCF;                            /*!< Received PAUSE Frame Counter                                          */
    
    struct {
      __I  uint32_t  RPAUSE     :  8;               /*!< Received PAUSE Frame CountNumber of received PAUSE frames             */
    } RFCF_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  TPAUSER;                         /*!< PAUSE Frame Retransmit Count Setting Register                         */
    
    struct {
      __IO uint32_t  TPAUSE     : 16;               /*!< Automatic PAUSE Frame Retransmit Setting                              */
    } TPAUSER_b;                                    /*!< BitSize                                                               */
  };
  __I  uint32_t  TPAUSECR;                          /*!< PAUSE Frame Retransmit Counter                                        */
  
  union {
    __IO uint32_t  BCFRR;                           /*!< Broadcast Frame Receive Count Setting Register                        */
    
    struct {
      __IO uint32_t  BCF        : 16;               /*!< Broadcast Frame Continuous Receive Count Setting                      */
    } BCFRR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED8[20 * 4];
  
  union {
    __IO uint32_t  MAHR;                            /*!< MAC Address Upper Bit Register                                        */
    
    struct {
      __IO uint32_t  MAHR       : 32;               /*!< MAC Address Upper Bit RegisterThe MAHR register sets the upper
                                                         32 bits (b47 to b16) of the 48-bit MAC address.                       */
    } MAHR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED9[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  MALR;                            /*!< MAC Address Lower Bit Register                                        */
    
    struct {
      __IO uint32_t  MALR       : 16;               /*!< MAC Address Lower Bit RegisterThe MALR register sets the lower
                                                         16 bits of the 48-bit MAC address.                                    */
    } MALR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED10[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  TROCR;                           /*!< Transmit Retry Over Counter Register                                  */
    
    struct {
      __IO uint32_t  TROCR      : 32;               /*!< Transmit Retry Over Counter RegisterThe TROCR register is a
                                                         counter indicating the number of frames that fail to be retransmitted. */
    } TROCR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  CDCR;                            /*!< Late Collision Detect Counter Register                                */
    
    struct {
      __IO uint32_t  TROCR      : 32;               /*!< Late Collision Detect Counter RegisterThe CDCR register is a
                                                         counter indicating the number of late collisions that have been
                                                          detected after transmission starts.                                  */
    } CDCR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  LCCR;                            /*!< Lost Carrier Counter Register                                         */
    
    struct {
      __IO uint32_t  LCCR       : 32;               /*!< Lost Carrier Counter RegisterThe LCCR register is a counter
                                                         indicating the number of times a loss of carrier is detected
                                                          during frame transmission.                                           */
    } LCCR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  CNDCR;                           /*!< Carrier Not Detect Counter Register                                   */
    
    struct {
      __IO uint32_t  CNDCR      : 32;               /*!< Carrier Not Detect Counter RegisterThe CNDCR register is a counter
                                                         indicating the number of times a carrier is not detected during
                                                          preamble transmission.                                               */
    } CNDCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED11[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  CEFCR;                           /*!< CRC Error Frame Receive Counter Register                              */
    
    struct {
      __IO uint32_t  CEFCR      : 32;               /*!< CRC Error Frame Receive Counter RegisterThe CEFCR register is
                                                         a counter indicating the number of received frames where a CRC
                                                          error has been detected.                                             */
    } CEFCR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  FRECR;                           /*!< Frame Receive Error Counter Register                                  */
    
    struct {
      __IO uint32_t  FRECR      : 32;               /*!< Frame Receive Error Counter RegisterThe FRECR register is a
                                                         counter indicating the number of times a frame receive error
                                                          has occurred.                                                        */
    } FRECR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  TSFRCR;                          /*!< Too-Short Frame Receive Counter Register                              */
    
    struct {
      __IO uint32_t  TSFRCR     : 32;               /*!< Too-Short Frame Receive Counter RegisterThe TSFRCR register
                                                         is a counter indicating the number of times a short frame that
                                                          is shorter than 64 bytes has been received.                          */
    } TSFRCR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  TLFRCR;                          /*!< Too-Long Frame Receive Counter Register                               */
    
    struct {
      __IO uint32_t  TLFRCR     : 32;               /*!< Too-Long Frame Receive Counter RegisterThe TLFRCR register is
                                                         a counter indicating the number of times a long frame that is
                                                          longer than the RFLR register value has been received.               */
    } TLFRCR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  RFCR;                            /*!< Received Alignment Error Frame Counter Register                       */
    
    struct {
      __IO uint32_t  RFCR       : 32;               /*!< Received Alignment Error Frame Counter RegisterThe RFCR register
                                                         is a counter indicating the number of times a frame has been
                                                          received with the alignment error (frame is not an integral
                                                          number of octets).                                                   */
    } RFCR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  MAFCR;                           /*!< Multicast Address Frame Receive Counter Register                      */
    
    struct {
      __IO uint32_t  MAFCR      : 32;               /*!< Multicast Address Frame Receive Counter RegisterThe MAFCR register
                                                         is a counter indicating the number of times a frame where the
                                                          multicast address is set has been received.                          */
    } MAFCR_b;                                      /*!< BitSize                                                               */
  };
} R_ETHERC0_Type;


/* ================================================================================ */
/* ================                   R_PTPEDMAC                   ================ */
/* ================================================================================ */


/**
  * @brief DMA Controller for EPTPC (R_PTPEDMAC)
  */

typedef struct {                                    /*!< R_PTPEDMAC Structure                                                  */
  
  union {
    __IO uint32_t  EDMR;                            /*!< PTPEDMAC Mode Register                                                */
    
    struct {
      __O  uint32_t  SWR        :  1;               /*!< Software Reset                                                        */
           uint32_t             :  3;
      __IO uint32_t  DL         :  2;               /*!< Transmit/Receive DescriptorLength                                     */
      __IO uint32_t  DE         :  1;               /*!< Big Endian Mode/Little Endian ModeNOTE: This setting applies
                                                         to data for the transmit/receive buffer. It does not apply to
                                                          transmit/receive descriptors and registers.                          */
    } EDMR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  EDTRR;                           /*!< EDMAC Transmit Request Register                                       */
    
    struct {
      __IO uint32_t  TR         :  1;               /*!< Transmit Request (The read value is 0.)                               */
    } EDTRR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED1[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  EDRRR;                           /*!< EDMAC Receive Request Register                                        */
    
    struct {
      __IO uint32_t  RR         :  1;               /*!< Receive Request                                                       */
    } EDRRR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED2[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  TDLAR;                           /*!< Transmit Descriptor List Start Address Register                       */
    
    struct {
      __IO uint32_t  TDLAR      : 32;               /*!< The start address of the transmit descriptor list is set. Set
                                                         the start address according to the descriptor length selected
                                                          by the EDMR.DL[1:0] bits.16-byte boundary: Lower 4 bits = 0000b32-byte
                                                          boundary: Lower 5 bits = 00000b64-byte boundary: Lower 6 bits
                                                          = 000000b                                                            */
    } TDLAR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED3[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  RDLAR;                           /*!< Receive Descriptor List Start Address Register                        */
    
    struct {
      __IO uint32_t  RDLAR      : 32;               /*!< The start address of the receive descriptor list is set. Set
                                                         the start address according to the descriptor length selected
                                                          by the EDMR.DL[1:0] bits.16-byte boundary: Lower 4 bits = 0000b32-byte
                                                          boundary: Lower 5 bits = 00000b64-byte boundary: Lower 6 bits
                                                          = 000000b                                                            */
    } RDLAR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED4[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  EESR;                            /*!< PTP/EDMAC Status Register                                             */
    
    struct {
      __IO uint32_t  TYPE       :  4;               /*!< PTP v2 Message Type Flag                                              */
      __IO uint32_t  PVER       :  1;               /*!< PTP v2 Packet Flag                                                    */
           uint32_t             :  2;
      __IO uint32_t  RPORT      :  1;               /*!< Receive Port Flag                                                     */
      __IO uint32_t  MACE       :  1;               /*!< MAC Address Mismatch Flag                                             */
           uint32_t             :  7;
      __IO uint32_t  RFOF       :  1;               /*!< Receive FIFO Overflow Flag                                            */
      __IO uint32_t  RDE        :  1;               /*!< Receive Descriptor Empty Flag                                         */
      __IO uint32_t  FR         :  1;               /*!< Frame Receive Flag                                                    */
      __IO uint32_t  TFUF       :  1;               /*!< Transmit FIFO Underflow Flag                                          */
      __IO uint32_t  TDE        :  1;               /*!< Transmit Descriptor Empty Flag                                        */
      __IO uint32_t  TC         :  1;               /*!< Frame Transfer Complete Flag                                          */
           uint32_t             :  1;
      __IO uint32_t  ADE        :  1;               /*!< Address Error Flag                                                    */
      __IO uint32_t  RFCOF      :  1;               /*!< Receive Frame Counter Overflow Flag                                   */
           uint32_t             :  1;
      __IO uint32_t  TABT       :  1;               /*!< Transmit Abort Detect Flag                                            */
           uint32_t             :  3;
      __IO uint32_t  TWB        :  1;               /*!< Write-Back Complete Flag                                              */
    } EESR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED5[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  EESIPR;                          /*!< PTP/EDMAC Status Interrupt Enable Register                            */
    
    struct {
           uint32_t             :  4;
      __IO uint32_t  PVERIP     :  1;               /*!< PTP v2 Packet Receive Interrupt Request Enable                        */
           uint32_t             :  2;
      __IO uint32_t  RPORTIP    :  1;               /*!< Receive Port Interrupt Request Enable                                 */
      __IO uint32_t  MACEIP     :  1;               /*!< MAC Address Mismatch Interrupt Request Enable                         */
           uint32_t             :  7;
      __IO uint32_t  RFOFIP     :  1;               /*!< Receive FIFO Overflow Interrupt Request Enable                        */
      __IO uint32_t  RDEIP      :  1;               /*!< Receive Descriptor Empty Interrupt Request Enable                     */
      __IO uint32_t  FRIP       :  1;               /*!< Frame Receive Interrupt Request Enable                                */
      __IO uint32_t  TFUFIP     :  1;               /*!< Transmit FIFO Underflow Interrupt Request Enable                      */
      __IO uint32_t  TDEIP      :  1;               /*!< Transmit Descriptor Empty Interrupt Request Enable                    */
      __IO uint32_t  TCIP       :  1;               /*!< Frame Transfer Complete Interrupt Request Enable                      */
           uint32_t             :  1;
      __IO uint32_t  ADEIP      :  1;               /*!< Address Error Interrupt Request Enable                                */
      __IO uint32_t  RFCOFIP    :  1;               /*!< Receive Frame Counter Overflow Interrupt Request Enable               */
           uint32_t             :  1;
      __IO uint32_t  TABTIP     :  1;               /*!< Transmit Abort Detect Interrupt Request Enable                        */
           uint32_t             :  3;
      __IO uint32_t  TWBIP      :  1;               /*!< Write-Back Complete Interrupt Request Enable                          */
    } EESIPR_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED6[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  TRSCER;                          /*!< PTP/EDMAC Transmit/Receive Status Copy Enable Register                */
    
    struct {
      __IO uint32_t  TYPECE     :  4;               /*!< TYPE[3:0] Flag Copy Enable TYPE[3]=0: The PTPEDMAC.EESR.TYPE[3]
                                                         flag value is reflected in the RD0.RFE bit of the receive descriptor.
                                                          TYPE[3]=1: The PTPEDMAC.EESR.TYPE[3] flag value is not reflected
                                                          in the RD0.RFE bit of the receive descriptor. TYPE[2]=0: The
                                                          PTPEDMAC.EESR.TYPE[2] flag value is reflected in the RD0.RFE
                                                          bit of the receive descriptor. TYPE[2]=1: The PTPEDMAC.EESR.TYPE[2]
                                                          flag value is not reflected in the RD0.RFE bit of the receive
                                                          descriptor. TYPE[1]=0: The PTPEDMAC.EESR.TYPE[1] flag value
                                                                                                                               */
      __IO uint32_t  PVERCE     :  1;               /*!< PVER Flag Copy Enable                                                 */
           uint32_t             :  2;
      __IO uint32_t  RPORTCE    :  1;               /*!< RPORT Flag Copy Enable                                                */
    } TRSCER_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED7[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  RMFCR;                           /*!< Missed-Frame Counter Register                                         */
    
    struct {
      __IO uint32_t  MFC        : 16;               /*!< Missed-Frame CounterThese bits indicate the number of frames
                                                         that are discarded and not transferred to the receive buffer
                                                          during reception.                                                    */
    } RMFCR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED8[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  TFTR;                            /*!< Transmit FIFO Threshold Register                                      */
    
    struct {
      __IO uint32_t  TFT        : 11;               /*!< Transmit FIFO Threshold00Dh to 200h: The threshold is the set
                                                         value multiplied by 4. Example: 00Dh: 52 bytes 040h: 256 bytes
                                                          100h: 1024 bytes 200h: 2048 bytes                                    */
    } TFTR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED9[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  FDR;                             /*!< Transmit FIFO Threshold Register                                      */
    
    struct {
      __IO uint32_t  RFD        :  5;               /*!< Transmit FIFO Depth                                                   */
           uint32_t             :  3;
      __IO uint32_t  TFD        :  5;               /*!< Receive FIFO Depth                                                    */
    } FDR_b;                                        /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED10[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  RMCR;                            /*!< Receive Method Control Register                                       */
    
    struct {
      __IO uint32_t  RNR        :  1;               /*!< Receive Request Reset                                                 */
    } RMCR_b;                                       /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED11[2 * 4];
  
  union {
    __IO uint32_t  TFUCR;                           /*!< Transmit FIFO Underflow Counter                                       */
    
    struct {
      __IO uint32_t  UNDER      : 16;               /*!< Transmit FIFO Underflow CountThese bits indicate how many times
                                                         the transmit FIFO has underflowed. The counter stops when the
                                                          counter value reaches FFFFh.                                         */
    } TFUCR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  RFOCR;                           /*!< Receive FIFO Overflow Counter                                         */
    
    struct {
      __IO uint32_t  OVER       : 16;               /*!< Receive FIFO Overflow CountThese bits indicate how many times
                                                         the receive FIFO has overflowed. The counter stops when the
                                                          counter value reaches FFFFh.                                         */
    } RFOCR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  IOSR;                            /*!< Independent Output Signal Setting Register                            */
    
    struct {
      __IO uint32_t  ELB        :  1;               /*!< External Loopback Mode                                                */
    } IOSR_b;                                       /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  FCFTR;                           /*!< Flow Control Start FIFO Threshold Setting Register                    */
    
    struct {
      __IO uint32_t  RFDO       :  3;               /*!< Receive FIFO Data PAUSE Output Threshold(When (RFDO+1)x256-32
                                                         bytes of data is stored in the receive FIFO.)                         */
           uint32_t             : 13;
      __IO uint32_t  RFFO       :  3;               /*!< Receive FIFO Frame PAUSE Output Threshold(When ((RFFO+1)x2)
                                                         receive frames have been stored in the receive FIFO.)                 */
    } FCFTR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED12[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  RPADIR;                          /*!< Receive Data Padding Insert Register                                  */
    
    struct {
      __IO uint32_t  PADR       :  6;               /*!< Padding Slot                                                          */
           uint32_t             : 10;
      __IO uint32_t  PADS       :  2;               /*!< Padding Size                                                          */
    } RPADIR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  TRIMD;                           /*!< Transmit Interrupt Setting Register                                   */
    
    struct {
      __IO uint32_t  TIS        :  1;               /*!< Transmit Interrupt EnableSet the EESR.TWB flag to 1 in the mode
                                                         selected by the TIM bit to notify an interrupt.                       */
           uint32_t             :  3;
      __IO uint32_t  TIM        :  1;               /*!< Transmit Interrupt Mode                                               */
    } TRIMD_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED13[18 * 4];
  
  union {
    __IO uint32_t  RBWAR;                           /*!< Receive Buffer Write Address Register                                 */
    
    struct {
      __I  uint32_t  RBWAR      : 32;               /*!< Receive Buffer Write Address RegisterThe RBWAR register indicates
                                                         the last address that the EDMAC has written data to when writing
                                                          to the receive buffer.Refer to the address indicated by the
                                                          RBWAR register to recognize which address in the receive buffer
                                                          the EDMAC is writing data to. Note that the address that the
                                                          EDMAC is outputting to the receive buffer may not match the
                                                          read value of the RBWAR register during data reception.              */
    } RBWAR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  RDFAR;                           /*!< Receive Descriptor Fetch Address Register                             */
    
    struct {
      __I  uint32_t  RDFAR      : 32;               /*!< Receive Descriptor Fetch Address RegisterThe RDFAR register
                                                         indicates the start address of the last fetched receive descriptor
                                                          when the EDMAC fetches descriptor information from the receive
                                                          descriptor.Refer to the address indicated by the RDFAR register
                                                          to recognize which receive descriptor information the EDMAC
                                                          is using for the current processing. Note that the address of
                                                          the receive descriptor that the EDMAC fetches may not match
                                                          the read value of the RDFAR register during data reception.          */
    } RDFAR_b;                                      /*!< BitSize                                                               */
  };
  __I  uint8_t  RESERVED14[4];   // Padding changed from uint32_t
  
  union {
    __IO uint32_t  TBRAR;                           /*!< Transmit Buffer Read Address Register                                 */
    
    struct {
      __I  uint32_t  TBRAR      : 32;               /*!< Transmit Buffer Read Address RegisterThe TBRAR register indicates
                                                         the last address that the EDMAC has read data from when reading
                                                          data from the transmit buffer.Refer to the address indicated
                                                          by the TBRAR register to recognize which address in the transmit
                                                          buffer the EDMAC is reading from. Note that the address that
                                                          the EDMAC is outputting to the transmit buffer may not match
                                                          the read value of the TBRAR register.                                */
    } TBRAR_b;                                      /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  TDFAR;                           /*!< Transmit Descriptor Fetch Address Register                            */
    
    struct {
      __I  uint32_t  TDFAR      : 32;               /*!< Transmit Descriptor Fetch Address RegisterThe TDFAR register
                                                         indicates the start address of the last fetched transmit descriptor
                                                          when the EDMAC fetches descriptor information from the transmit
                                                          descriptor.Refer to the address indicated by the TDFAR register
                                                          to recognize which transmit descriptor information the EDMAC
                                                          is using for the current processing. Note that the address of
                                                          the transmit descriptor that the EDMAC fetches may not match
                                                          the read value of the TDFAR register.                                */
    } TDFAR_b;                                      /*!< BitSize                                                               */
  };
} R_PTPEDMAC_Type;


/* ================================================================================ */
/* ================                   R_EPTPC_CFG                  ================ */
/* ================================================================================ */


/**
  * @brief EPTPC Configuration (R_EPTPC_CFG)
  */

typedef struct {                                    /*!< R_EPTPC_CFG Structure                                                 */
  
  union {
    __IO uint32_t  PTRSTR;                          /*!< PTP Reset Register                                                    */
    
    struct {
      __IO uint32_t  RESET      :  1;               /*!< EPTPC Software ResetNOTE: Do not access the EPTPC-related registers
                                                         other than this register while a software reset is being issued.      */
    } PTRSTR_b;                                     /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  STCSELR;                         /*!< STCA Clock Select Register                                            */
    
    struct {
      __IO uint32_t  SCLKDIV    :  3;               /*!< PCLKA Clock Frequency Division                                        */
           uint32_t             :  5;
      __IO uint32_t  SCLKSEL    :  3;               /*!< STCA Clock Select                                                     */
    } STCSELR_b;                                    /*!< BitSize                                                               */
  };
  
  union {
    __IO uint32_t  BYPASS;                          /*!< Bypass 1588 module Register                                           */
    
    struct {
      __IO uint32_t  BYPASS0    :  1;               /*!< Bypass 1588 module for Ether 0ch                                      */
           uint32_t             : 15;
      __IO uint32_t  BYPASS1    :  1;               /*!< Bypass 1588 module for Ether 1ch                                      */
    } BYPASS_b;                                     /*!< BitSize                                                               */
  };
  __I  uint8_t RESERVED[29 * 4];
  
  union {
    __IO uint32_t  ETn_ETC[2];                      /*!< Ether %s Status                                                       */
    
    struct {
      __I  uint32_t  ED_RX_OPE  :  1;               /*!< EDMACn Receiving operation                                            */
           uint32_t             :  7;
      __I  uint32_t  ET_RX_OPE  :  1;               /*!< ETHERCn Receiving operation                                           */
           uint32_t             :  7;
      __I  uint32_t  TPAUSE     :  1;               /*!< Transmit PAUSE frame                                                  */
           uint32_t  