/**
 * @file efm32_giant_gecko_11_sk.h
 * @brief EFM32 Giant Gecko 11 Starter Kit
 *
 * @section License
 *
 * Copyright (C) 2010-2019 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval.
 *
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.9.4
 **/

#ifndef _EFM32_GIANT_GECKO_11_SK_H
#define _EFM32_GIANT_GECKO_11_SK_H

//Dependencies
#include "em_device.h"

//LED0
#define LED0_R_GPIO_PORT gpioPortH
#define LED0_R_GPIO_PIN  10
#define LED0_G_GPIO_PORT gpioPortH
#define LED0_G_GPIO_PIN  11
#define LED0_B_GPIO_PORT gpioPortH
#define LED0_B_GPIO_PIN  12

//LED1
#define LED1_R_GPIO_PORT gpioPortH
#define LED1_R_GPIO_PIN  13
#define LED1_G_GPIO_PORT gpioPortH
#define LED1_G_GPIO_PIN  14
#define LED1_B_GPIO_PORT gpioPortH
#define LED1_B_GPIO_PIN  15

//BTN0 button
#define BTN0_GPIO_PORT   gpioPortC
#define BTN0_GPIO_PIN    8

//BTN1 button
#define BTN1_GPIO_PORT   gpioPortC
#define BTN1_GPIO_PIN    9

#endif
