/************************************************************************/
/*               (C) Fujitsu Semiconductor Europe GmbH (FSEU)           */
/*                                                                      */
/* The following software deliverable is intended for and must only be  */
/* used for reference and in an evaluation laboratory environment.      */
/* It is provided on an as-is basis without charge and is subject to    */
/* alterations.                                                         */
/* It is the user's obligation to fully test the software in its        */
/* environment and to ensure proper functionality, qualification and    */
/* compliance with component specifications.                            */
/*                                                                      */
/* In the event the software deliverable includes the use of open       */
/* source components, the provisions of the governing open source       */
/* license agreement shall apply with respect to such software          */
/* deliverable.                                                         */
/* FSEU does not warrant that the deliverables do not infringe any      */
/* third party intellectual property right (IPR). In the event that     */
/* the deliverables infringe a third party IPR it is the sole           */
/* responsibility of the customer to obtain necessary licenses to       */
/* continue the usage of the deliverable.                               */
/*                                                                      */
/* To the maximum extent permitted by applicable law FSEU disclaims all */
/* warranties, whether express or implied, in particular, but not       */
/* limited to, warranties of merchantability and fitness for a          */
/* particular purpose for which the deliverable is not designated.      */
/*                                                                      */
/* To the maximum extent permitted by applicable law, FSEU's liability  */
/* is restricted to intentional misconduct and gross negligence.        */
/* FSEU is not liable for consequential damages.                        */
/*                                                                      */
/* (V1.5)                                                               */
/************************************************************************/
/*                                                                      */
/*  Header File for Device MB9BD10T                                     */
/*  Version V1.4                                                        */
/*  Date    2013-03-08                                                  */
/*                                                                      */
/************************************************************************/

/******************************************************************************
 * History
 * Date       Ver Description
 * 2011-09-21 1.0 Initial
 * 2012-02-23 1.1 Added the following bits to the bit fields
 *                - TMD bits of WFSAxx register in MFT
 *                - MD bits of PPGCx register in PPG
 *                - FMD bits of TMCR register in BT
 *                - MD bits of SMR register in MFS
 *                - MSK bits of IFxMSK register in CAN
 *                - ID bits of IFxARB register in CAN
 * 2012-06-07 1.2 Modified FMSINT bit of IRQxxMON register to MFSINT
 *                Removeded the following bits
 *                - ITST bits of SMR register in MFS I2C
 *                - FTST bits of FCR register in MFS
 *                Modified ASZPPSSEL bit of ETH_MODE register to PPSSEL
 * 2012-08-21 1.3 Modified NR0 bit of NMIRR register to NR
 *                Modified NCL0 bit of NMICL register to NCL
 *                Modified FRIE bit of FCR1 register to FRIIE
 * 2013-03-08 1.4 Modified SCFD&PCFD bit band of ADC
 *                Modified bit name of BTSSSR register of BT
 *                Added QPRCRR register of QPRC
 *
 ******************************************************************************/

#ifndef _MB9BD10T_H_
#define _MB9BD10T_H_

#ifdef __cplusplus
extern "C" {
#endif 

#define FM3_DEVICE_TYPE 2

/******************************************************************************
 * Configuration of the Cortex-M3 Processor and Core Peripherals
 ******************************************************************************/
#define __MPU_PRESENT           1 /* FM3 provide an MPU                           */
#define __NVIC_PRIO_BITS        4 /* FM3 uses 4 Bits for the Priority Levels      */
#define __Vendor_SysTickConfig  0 /* Set to 1 if different SysTick Config is used */


/******************************************************************************
 * Interrupt Number Definition
 ******************************************************************************/
typedef enum IRQn
{
    NMI_IRQn          = -14, /*  2 Non Maskable      */
    HardFault_IRQn    = -13, /*  3 Hard Fault        */
    MemManage_IRQn    = -12, /*  4 Memory Management */
    BusFault_IRQn     = -11, /*  5 Bus Fault         */
    UsageFault_IRQn   = -10, /*  6 Usage Fault       */
    SVC_IRQn          = -5,  /* 11 SV Call           */
    DebugMonitor_IRQn = -4,  /* 12 Debug Monitor     */
    PendSV_IRQn       = -2,  /* 14 Pend SV           */
    SysTick_IRQn      = -1,  /* 15 System Tick       */

    CSV_IRQn          =  0, /* Clock Super Visor                             */
    SWDT_IRQn         =  1, /* Software Watchdog Timer                       */
    LVD_IRQn          =  2, /* Low Voltage Detector                          */
    WFG_IRQn          =  3, /* Wave Form Generator                           */
    EXINT0_7_IRQn     =  4, /* External Interrupt Request ch.0 to ch.7       */
    EXINT8_31_IRQn    =  5, /* External Interrupt Request ch.8 to ch.31      */
    DTIM_QDU_IRQn     =  6, /* Dual Timer / Quad Decoder                     */
    MFS0RX_IRQn       =  7, /* MultiFunction Serial Reception ch.0           */
    MFS0TX_IRQn       =  8, /* MultiFunction Serial Transmission ch.0        */
    MFS1RX_IRQn       =  9, /* MultiFunction Serial Reception ch.1           */
    MFS1TX_IRQn       = 10, /* MultiFunction Serial Transmission ch.1        */
    MFS2RX_IRQn       = 11, /* MultiFunction Serial Reception ch.2           */
    MFS2TX_IRQn       = 12, /* MultiFunction Serial Transmission ch.2        */
    MFS3RX_IRQn       = 13, /* MultiFunction Serial Reception ch.3           */
    MFS3TX_IRQn       = 14, /* MultiFunction Serial Transmission ch.3        */
    MFS4RX_IRQn       = 15, /* MultiFunction Serial Reception ch.4           */
    MFS4TX_IRQn       = 16, /* MultiFunction Serial Transmission ch.4        */
    MFS5RX_IRQn       = 17, /* MultiFunction Serial Reception ch.5           */
    MFS5TX_IRQn       = 18, /* MultiFunction Serial Transmission ch.5        */
    MFS6RX_IRQn       = 19, /* MultiFunction Serial Reception ch.6           */
    MFS6TX_IRQn       = 20, /* MultiFunction Serial Transmission ch.6        */
    MFS7RX_IRQn       = 21, /* MultiFunction Serial Reception ch.7           */
    MFS7TX_IRQn       = 22, /* MultiFunction Serial Transmission ch.7        */
    PPG_IRQn          = 23, /* PPG                                           */
    OSC_PLL_WC_IRQn   = 24, /* OSC / PLL / Watch Counter                     */
    ADC0_IRQn         = 25, /* ADC0                                          */
    ADC1_IRQn         = 26, /* ADC1                                          */
    ADC2_IRQn         = 27, /* ADC2                                          */
    FRTIM_IRQn        = 28, /* Free-run Timer                                */
    INCAP_IRQn        = 29, /* Input Capture                                 */
    OUTCOMP_IRQn      = 30, /* Output Compare                                */
    BTIM0_7_IRQn      = 31, /* Base Timer ch.0 to ch.7                       */
    ETHER0_CAN0_IRQn  = 32, /* Ethernet MAC ch.0 / CAN ch.0                  */
    ETHER1_CAN1_IRQn  = 33, /* Ethernet MAC ch.1 / CAN ch.1                  */
    USB0F_IRQn        = 34, /* USB Function ch.0                             */
    USB0F_USB0H_IRQn  = 35, /* USB Function ch.0 / USB Host ch.0             */
    USB1F_IRQn        = 36, /* USB Function ch.1                             */
    USB1F_USB1H_IRQn  = 37, /* USB Function ch.1 / USB Host ch.1             */
    DMAC0_IRQn        = 38, /* DMAC ch.0                                     */
    DMAC1_IRQn        = 39, /* DMAC ch.1                                     */
    DMAC2_IRQn        = 40, /* DMAC ch.2                                     */
    DMAC3_IRQn        = 41, /* DMAC ch.3                                     */
    DMAC4_IRQn        = 42, /* DMAC ch.4                                     */
    DMAC5_IRQn        = 43, /* DMAC ch.5                                     */
    DMAC6_IRQn        = 44, /* DMAC ch.6                                     */
    DMAC7_IRQn        = 45, /* DMAC ch.7                                     */
    BTIM8_15_IRQn     = 46  /* Base Timer ch.8 to ch.15                      */
    /* Reserved       = 47                                                   */
} IRQn_Type;


#include <core_cm3.h>
#include "system_mb9bfd1x.h"
#include <stdint.h>

#define SUCCESS  0
#define ERROR    -1

#ifndef NULL
#define NULL 0
#endif


/******************************************************************************/
/*                Device Specific Peripheral Registers structures             */
/******************************************************************************/

#if defined ( __CC_ARM   )
#pragma anon_unions
#endif

/******************************************************************************
 * Peripheral register bit fields
 ******************************************************************************/

/******************************************************************************
 * Flash_IF_MODULE
 ******************************************************************************/
/* Flash_IF_MODULE register bit fields */
typedef struct stc_flash_if_faszr_field
{
  __IO uint32_t ASZ0       : 1;
  __IO uint32_t ASZ1       : 1;
} stc_flash_if_faszr_field_t;

typedef struct stc_flash_if_frwtr_field
{
  __IO uint32_t RWT0       : 1;
  __IO uint32_t RWT1       : 1;
} stc_flash_if_frwtr_field_t;

typedef struct stc_flash_if_fstr_field
{
  __IO uint32_t RDY        : 1;
  __IO uint32_t HNG        : 1;
  __IO uint32_t EER        : 1;
} stc_flash_if_fstr_field_t;

typedef struct stc_flash_if_fsyndn_field
{
  __IO uint32_t SD0        : 1;
  __IO uint32_t SD1        : 1;
  __IO uint32_t SD2        : 1;
} stc_flash_if_fsyndn_field_t;

typedef struct stc_flash_if_fbfcr_field
{
  __IO uint32_t BE         : 1;
  __IO uint32_t BS         : 1;
} stc_flash_if_fbfcr_field_t;

typedef struct stc_flash_if_crtrmm_field
{
  __IO uint32_t TRMM0      : 1;
  __IO uint32_t TRMM1      : 1;
  __IO uint32_t TRMM2      : 1;
  __IO uint32_t TRMM3      : 1;
  __IO uint32_t TRMM4      : 1;
  __IO uint32_t TRMM5      : 1;
  __IO uint32_t TRMM6      : 1;
  __IO uint32_t TRMM7      : 1;
  __IO uint32_t TRMM8      : 1;
  __IO uint32_t TRMM9      : 1;
} stc_flash_if_crtrmm_field_t;

/******************************************************************************
 * Clock_Reset_MODULE
 ******************************************************************************/
/* Clock_Reset_MODULE register bit fields */
typedef struct stc_crg_scm_ctl_field
{
        uint8_t RESERVED1  : 1;
  __IO  uint8_t MOSCE      : 1;
        uint8_t RESERVED2  : 1;
  __IO  uint8_t SOSCE      : 1;
  __IO  uint8_t PLLE       : 1;
  __IO  uint8_t RCS0       : 1;
  __IO  uint8_t RCS1       : 1;
  __IO  uint8_t RCS2       : 1;
} stc_crg_scm_ctl_field_t;

typedef struct stc_crg_scm_str_field
{
        uint8_t RESERVED1  : 1;
  __IO  uint8_t MORDY      : 1;
        uint8_t RESERVED2  : 1;
  __IO  uint8_t SORDY      : 1;
  __IO  uint8_t PLRDY      : 1;
  __IO  uint8_t RCM0       : 1;
  __IO  uint8_t RCM1       : 1;
  __IO  uint8_t RCM2       : 1;
} stc_crg_scm_str_field_t;

typedef struct stc_crg_rst_str_field
{
  __IO uint16_t PONR       : 1;
  __IO uint16_t INITX      : 1;
       uint16_t RESERVED1  : 2;
  __IO uint16_t SWDT       : 1;
  __IO uint16_t HWDT       : 1;
  __IO uint16_t CSVR       : 1;
  __IO uint16_t FCSR       : 1;
  __IO uint16_t SRST       : 1;
} stc_crg_rst_str_field_t;

typedef struct stc_crg_bsc_psr_field
{
  __IO  uint8_t BSR0       : 1;
  __IO  uint8_t BSR1       : 1;
  __IO  uint8_t BSR2       : 1;
} stc_crg_bsc_psr_field_t;

typedef struct stc_crg_apbc0_psr_field
{
  __IO  uint8_t APBC00     : 1;
  __IO  uint8_t APBC01     : 1;
} stc_crg_apbc0_psr_field_t;

typedef struct stc_crg_apbc1_psr_field
{
  __IO  uint8_t APBC10     : 1;
  __IO  uint8_t APBC11     : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t APBC1RST   : 1;
        uint8_t RESERVED2  : 2;
  __IO  uint8_t APBC1EN    : 1;
} stc_crg_apbc1_psr_field_t;

typedef struct stc_crg_apbc2_psr_field
{
  __IO  uint8_t APBC20     : 1;
  __IO  uint8_t APBC21     : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t APBC2RST   : 1;
        uint8_t RESERVED2  : 2;
  __IO  uint8_t APBC2EN    : 1;
} stc_crg_apbc2_psr_field_t;

typedef struct stc_crg_swc_psr_field
{
  __IO  uint8_t SWDS0      : 1;
  __IO  uint8_t SWDS1      : 1;
        uint8_t RESERVED1  : 5;
  __IO  uint8_t TESTB      : 1;
} stc_crg_swc_psr_field_t;

typedef struct stc_crg_ttc_psr_field
{
  __IO  uint8_t TTC0       : 1;
  __IO  uint8_t TTC1       : 1;
} stc_crg_ttc_psr_field_t;

typedef struct stc_crg_csw_tmr_field
{
  __IO  uint8_t MOWT0      : 1;
  __IO  uint8_t MOWT1      : 1;
  __IO  uint8_t MOWT2      : 1;
  __IO  uint8_t MOWT3      : 1;
  __IO  uint8_t SOWT0      : 1;
  __IO  uint8_t SOWT1      : 1;
  __IO  uint8_t SOWT2      : 1;
} stc_crg_csw_tmr_field_t;

typedef struct stc_crg_psw_tmr_field
{
  __IO  uint8_t POWT0      : 1;
  __IO  uint8_t POWT1      : 1;
  __IO  uint8_t POWT2      : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t PINC       : 1;
} stc_crg_psw_tmr_field_t;

typedef struct stc_crg_pll_ctl1_field
{
  __IO  uint8_t PLLM0      : 1;
  __IO  uint8_t PLLM1      : 1;
  __IO  uint8_t PLLM2      : 1;
  __IO  uint8_t PLLM3      : 1;
  __IO  uint8_t PLLK0      : 1;
  __IO  uint8_t PLLK1      : 1;
  __IO  uint8_t PLLK2      : 1;
  __IO  uint8_t PLLK3      : 1;
} stc_crg_pll_ctl1_field_t;

typedef struct stc_crg_pll_ctl2_field
{
  __IO  uint8_t PLLN0      : 1;
  __IO  uint8_t PLLN1      : 1;
  __IO  uint8_t PLLN2      : 1;
  __IO  uint8_t PLLN3      : 1;
  __IO  uint8_t PLLN4      : 1;
  __IO  uint8_t PLLN5      : 1;
} stc_crg_pll_ctl2_field_t;

typedef struct stc_crg_csv_ctl_field
{
  __IO uint16_t MCSVE      : 1;
  __IO uint16_t SCSVE      : 1;
       uint16_t RESERVED1  : 6;
  __IO uint16_t FCSDE      : 1;
  __IO uint16_t FCSRE      : 1;
       uint16_t RESERVED2  : 2;
  __IO uint16_t FCD0       : 1;
  __IO uint16_t FCD1       : 1;
  __IO uint16_t FCD2       : 1;
} stc_crg_csv_ctl_field_t;

typedef struct stc_crg_csv_str_field
{
  __IO  uint8_t MCMF       : 1;
  __IO  uint8_t SCMF       : 1;
} stc_crg_csv_str_field_t;

typedef struct stc_crg_dbwdt_ctl_field
{
        uint8_t RESERVED1  : 5;
  __IO  uint8_t DPSWBE     : 1;
        uint8_t RESERVED2  : 1;
  __IO  uint8_t DPHWBE     : 1;
} stc_crg_dbwdt_ctl_field_t;

typedef struct stc_crg_int_enr_field
{
  __IO  uint8_t MCSE       : 1;
  __IO  uint8_t SCSE       : 1;
  __IO  uint8_t PCSE       : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t FCSE       : 1;
} stc_crg_int_enr_field_t;

typedef struct stc_crg_int_str_field
{
  __IO  uint8_t MCSI       : 1;
  __IO  uint8_t SCSI       : 1;
  __IO  uint8_t PCSI       : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t FCSI       : 1;
} stc_crg_int_str_field_t;

typedef struct stc_crg_int_clr_field
{
  __IO  uint8_t MCSC       : 1;
  __IO  uint8_t SCSC       : 1;
  __IO  uint8_t PCSC       : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t FCSC       : 1;
} stc_crg_int_clr_field_t;

/******************************************************************************
 * HWWDT_MODULE
 ******************************************************************************/
/* HWWDT_MODULE register bit fields */
typedef struct stc_hwwdt_wdg_ctl_field
{
  __IO  uint8_t INTEN      : 1;
  __IO  uint8_t RESEN      : 1;
} stc_hwwdt_wdg_ctl_field_t;

typedef struct stc_hwwdt_wdg_ris_field
{
  __IO  uint8_t RIS        : 1;
} stc_hwwdt_wdg_ris_field_t;

/******************************************************************************
 * SWWDT_MODULE
 ******************************************************************************/
/* SWWDT_MODULE register bit fields */
typedef struct stc_swwdt_wdogcontrol_field
{
  __IO  uint8_t INTEN      : 1;
  __IO  uint8_t RESEN      : 1;
} stc_swwdt_wdogcontrol_field_t;

typedef struct stc_swwdt_wdogris_field
{
  __IO  uint8_t RIS        : 1;
} stc_swwdt_wdogris_field_t;

/******************************************************************************
 * DTIM_MODULE
 ******************************************************************************/
/* DTIM_MODULE register bit fields */
typedef struct stc_dtim_timer1control_field
{
  __IO uint32_t ONESHOT    : 1;
  __IO uint32_t TIMERSIZE  : 1;
  __IO uint32_t TIMERPRE0  : 1;
  __IO uint32_t TIMERPRE1  : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t INTENABLE  : 1;
  __IO uint32_t TIMERMODE  : 1;
  __IO uint32_t TIMEREN    : 1;
} stc_dtim_timer1control_field_t;

typedef struct stc_dtim_timer1ris_field
{
  __IO uint32_t TIMER1RIS  : 1;
} stc_dtim_timer1ris_field_t;

typedef struct stc_dtim_timer1mis_field
{
  __IO uint32_t TIMER1MIS  : 1;
} stc_dtim_timer1mis_field_t;

typedef struct stc_dtim_timer2control_field
{
  __IO uint32_t ONESHOT    : 1;
  __IO uint32_t TIMERSIZE  : 1;
  __IO uint32_t TIMERPRE0  : 1;
  __IO uint32_t TIMERPRE1  : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t INTENABLE  : 1;
  __IO uint32_t TIMERMODE  : 1;
  __IO uint32_t TIMEREN    : 1;
} stc_dtim_timer2control_field_t;

typedef struct stc_dtim_timer2ris_field
{
  __IO uint32_t TIMER2RIS  : 1;
} stc_dtim_timer2ris_field_t;

typedef struct stc_dtim_timer2mis_field
{
  __IO uint32_t TIMER2MIS  : 1;
} stc_dtim_timer2mis_field_t;

/******************************************************************************
 * MFT_FRT_MODULE
 ******************************************************************************/
/* MFT_FRT_MODULE register bit fields */
typedef struct stc_mft_frt_tcsa0_field
{
  __IO uint16_t CLK0       : 1;
  __IO uint16_t CLK1       : 1;
  __IO uint16_t CLK2       : 1;
  __IO uint16_t CLK3       : 1;
  __IO uint16_t SCLR       : 1;
  __IO uint16_t MODE       : 1;
  __IO uint16_t STOP       : 1;
  __IO uint16_t BFE        : 1;
  __IO uint16_t ICRE       : 1;
  __IO uint16_t ICLR       : 1;
       uint16_t RESERVED1  : 3;
  __IO uint16_t IRQZE      : 1;
  __IO uint16_t IRQZF      : 1;
  __IO uint16_t ECKE       : 1;
} stc_mft_frt_tcsa0_field_t;

typedef struct stc_mft_frt_tcsb0_field
{
  __IO uint16_t AD0E       : 1;
  __IO uint16_t AD1E       : 1;
  __IO uint16_t AD2E       : 1;
} stc_mft_frt_tcsb0_field_t;

typedef struct stc_mft_frt_tcsa1_field
{
  __IO uint16_t CLK0       : 1;
  __IO uint16_t CLK1       : 1;
  __IO uint16_t CLK2       : 1;
  __IO uint16_t CLK3       : 1;
  __IO uint16_t SCLR       : 1;
  __IO uint16_t MODE       : 1;
  __IO uint16_t STOP       : 1;
  __IO uint16_t BFE        : 1;
  __IO uint16_t ICRE       : 1;
  __IO uint16_t ICLR       : 1;
       uint16_t RESERVED1  : 3;
  __IO uint16_t IRQZE      : 1;
  __IO uint16_t IRQZF      : 1;
  __IO uint16_t ECKE       : 1;
} stc_mft_frt_tcsa1_field_t;

typedef struct stc_mft_frt_tcsb1_field
{
  __IO uint16_t AD0E       : 1;
  __IO uint16_t AD1E       : 1;
  __IO uint16_t AD2E       : 1;
} stc_mft_frt_tcsb1_field_t;

typedef struct stc_mft_frt_tcsa2_field
{
  __IO uint16_t CLK0       : 1;
  __IO uint16_t CLK1       : 1;
  __IO uint16_t CLK2       : 1;
  __IO uint16_t CLK3       : 1;
  __IO uint16_t SCLR       : 1;
  __IO uint16_t MODE       : 1;
  __IO uint16_t STOP       : 1;
  __IO uint16_t BFE        : 1;
  __IO uint16_t ICRE       : 1;
  __IO uint16_t ICLR       : 1;
       uint16_t RESERVED1  : 3;
  __IO uint16_t IRQZE      : 1;
  __IO uint16_t IRQZF      : 1;
  __IO uint16_t ECKE       : 1;
} stc_mft_frt_tcsa2_field_t;

typedef struct stc_mft_frt_tcsb2_field
{
  __IO uint16_t AD0E       : 1;
  __IO uint16_t AD1E       : 1;
  __IO uint16_t AD2E       : 1;
} stc_mft_frt_tcsb2_field_t;

/******************************************************************************
 * MFT_OCU_MODULE
 ******************************************************************************/
/* MFT_OCU_MODULE register bit fields */
typedef struct stc_mft_ocu_ocsa10_field
{
  __IO  uint8_t CST0       : 1;
  __IO  uint8_t CST1       : 1;
  __IO  uint8_t BDIS0      : 1;
  __IO  uint8_t BDIS1      : 1;
  __IO  uint8_t IOE0       : 1;
  __IO  uint8_t IOE1       : 1;
  __IO  uint8_t IOP0       : 1;
  __IO  uint8_t IOP1       : 1;
} stc_mft_ocu_ocsa10_field_t;

typedef struct stc_mft_ocu_ocsb10_field
{
  __IO  uint8_t OTD0       : 1;
  __IO  uint8_t OTD1       : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t CMOD       : 1;
  __IO  uint8_t BTS0       : 1;
  __IO  uint8_t BTS1       : 1;
} stc_mft_ocu_ocsb10_field_t;

typedef struct stc_mft_ocu_ocsa32_field
{
  __IO  uint8_t CST2       : 1;
  __IO  uint8_t CST3       : 1;
  __IO  uint8_t BDIS2      : 1;
  __IO  uint8_t BDIS3      : 1;
  __IO  uint8_t IOE2       : 1;
  __IO  uint8_t IOE3       : 1;
  __IO  uint8_t IOP2       : 1;
  __IO  uint8_t IOP3       : 1;
} stc_mft_ocu_ocsa32_field_t;

typedef struct stc_mft_ocu_ocsb32_field
{
  __IO  uint8_t OTD2       : 1;
  __IO  uint8_t OTD3       : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t CMOD       : 1;
  __IO  uint8_t BTS2       : 1;
  __IO  uint8_t BTS3       : 1;
} stc_mft_ocu_ocsb32_field_t;

typedef struct stc_mft_ocu_ocsa54_field
{
  __IO  uint8_t CST4       : 1;
  __IO  uint8_t CST5       : 1;
  __IO  uint8_t BDIS4      : 1;
  __IO  uint8_t BDIS5      : 1;
  __IO  uint8_t IOE4       : 1;
  __IO  uint8_t IOE5       : 1;
  __IO  uint8_t IOP4       : 1;
  __IO  uint8_t IOP5       : 1;
} stc_mft_ocu_ocsa54_field_t;

typedef struct stc_mft_ocu_ocsb54_field
{
  __IO  uint8_t OTD4       : 1;
  __IO  uint8_t OTD5       : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t CMOD       : 1;
  __IO  uint8_t BTS4       : 1;
  __IO  uint8_t BTS5       : 1;
} stc_mft_ocu_ocsb54_field_t;

typedef struct stc_mft_ocu_ocsc_field
{
  __IO  uint8_t MOD0       : 1;
  __IO  uint8_t MOD1       : 1;
  __IO  uint8_t MOD2       : 1;
  __IO  uint8_t MOD3       : 1;
  __IO  uint8_t MOD4       : 1;
  __IO  uint8_t MOD5       : 1;
} stc_mft_ocu_ocsc_field_t;

typedef struct stc_mft_ocu_ocfs10_field
{
  __IO  uint8_t FSO00      : 1;
  __IO  uint8_t FSO01      : 1;
  __IO  uint8_t FSO02      : 1;
  __IO  uint8_t FSO03      : 1;
  __IO  uint8_t FSO10      : 1;
  __IO  uint8_t FSO11      : 1;
  __IO  uint8_t FSO12      : 1;
  __IO  uint8_t FSO13      : 1;
} stc_mft_ocu_ocfs10_field_t;

typedef struct stc_mft_ocu_ocfs32_field
{
  __IO  uint8_t FSO20      : 1;
  __IO  uint8_t FSO21      : 1;
  __IO  uint8_t FSO22      : 1;
  __IO  uint8_t FSO23      : 1;
  __IO  uint8_t FSO30      : 1;
  __IO  uint8_t FSO31      : 1;
  __IO  uint8_t FSO32      : 1;
  __IO  uint8_t FSO33      : 1;
} stc_mft_ocu_ocfs32_field_t;

typedef struct stc_mft_ocu_ocfs54_field
{
  __IO  uint8_t FSO40      : 1;
  __IO  uint8_t FSO41      : 1;
  __IO  uint8_t FSO42      : 1;
  __IO  uint8_t FSO43      : 1;
  __IO  uint8_t FSO50      : 1;
  __IO  uint8_t FSO51      : 1;
  __IO  uint8_t FSO52      : 1;
  __IO  uint8_t FSO53      : 1;
} stc_mft_ocu_ocfs54_field_t;

/******************************************************************************
 * MFT_WFG_MODULE
 ******************************************************************************/
/* MFT_WFG_MODULE register bit fields */
typedef struct stc_mft_wfg_wfsa10_field
{
  __IO uint16_t DCK0       : 1;
  __IO uint16_t DCK1       : 1;
  __IO uint16_t DCK2       : 1;
  __IO uint16_t TMD        : 3;
  __IO uint16_t GTEN0      : 1;
  __IO uint16_t GTEN1      : 1;
  __IO uint16_t PSEL0      : 1;
  __IO uint16_t PSEL1      : 1;
  __IO uint16_t PGEN0      : 1;
  __IO uint16_t PGEN1      : 1;
  __IO uint16_t DMOD       : 1;
} stc_mft_wfg_wfsa10_field_t;

typedef struct stc_mft_wfg_wfsa32_field
{
  __IO uint16_t DCK0       : 1;
  __IO uint16_t DCK1       : 1;
  __IO uint16_t DCK2       : 1;
  __IO uint16_t TMD        : 3;
  __IO uint16_t GTEN0      : 1;
  __IO uint16_t GTEN1      : 1;
  __IO uint16_t PSEL0      : 1;
  __IO uint16_t PSEL1      : 1;
  __IO uint16_t PGEN0      : 1;
  __IO uint16_t PGEN1      : 1;
  __IO uint16_t DMOD       : 1;
} stc_mft_wfg_wfsa32_field_t;

typedef struct stc_mft_wfg_wfsa54_field
{
  __IO uint16_t DCK0       : 1;
  __IO uint16_t DCK1       : 1;
  __IO uint16_t DCK2       : 1;
  __IO uint16_t TMD        : 3;
  __IO uint16_t GTEN0      : 1;
  __IO uint16_t GTEN1      : 1;
  __IO uint16_t PSEL0      : 1;
  __IO uint16_t PSEL1      : 1;
  __IO uint16_t PGEN0      : 1;
  __IO uint16_t PGEN1      : 1;
  __IO uint16_t DMOD       : 1;
} stc_mft_wfg_wfsa54_field_t;

typedef struct stc_mft_wfg_wfir_field
{
  __IO uint16_t DTIF       : 1;
  __IO uint16_t DTIC       : 1;
       uint16_t RESERVED1  : 2;
  __IO uint16_t TMIF10     : 1;
  __IO uint16_t TMIC10     : 1;
  __IO uint16_t TMIE10     : 1;
  __IO uint16_t TMIS10     : 1;
  __IO uint16_t TMIF32     : 1;
  __IO uint16_t TMIC32     : 1;
  __IO uint16_t TMIE32     : 1;
  __IO uint16_t TMIS32     : 1;
  __IO uint16_t TMIF54     : 1;
  __IO uint16_t TMIC54     : 1;
  __IO uint16_t TMIE54     : 1;
  __IO uint16_t TMIS54     : 1;
} stc_mft_wfg_wfir_field_t;

typedef struct stc_mft_wfg_nzcl_field
{
  __IO uint16_t DTIE       : 1;
  __IO uint16_t NWS0       : 1;
  __IO uint16_t NWS1       : 1;
  __IO uint16_t NWS2       : 1;
  __IO uint16_t SDTI       : 1;
} stc_mft_wfg_nzcl_field_t;

/******************************************************************************
 * MFT_ICU_MODULE
 ******************************************************************************/
/* MFT_ICU_MODULE register bit fields */
typedef struct stc_mft_icu_icfs10_field
{
  __IO  uint8_t FSI00      : 1;
  __IO  uint8_t FSI01      : 1;
  __IO  uint8_t FSI02      : 1;
  __IO  uint8_t FSI03      : 1;
  __IO  uint8_t FSI10      : 1;
  __IO  uint8_t FSI11      : 1;
  __IO  uint8_t FSI12      : 1;
  __IO  uint8_t FSI13      : 1;
} stc_mft_icu_icfs10_field_t;

typedef struct stc_mft_icu_icfs32_field
{
  __IO  uint8_t FSI20      : 1;
  __IO  uint8_t FSI21      : 1;
  __IO  uint8_t FSI22      : 1;
  __IO  uint8_t FSI23      : 1;
  __IO  uint8_t FSI30      : 1;
  __IO  uint8_t FSI31      : 1;
  __IO  uint8_t FSI32      : 1;
  __IO  uint8_t FSI33      : 1;
} stc_mft_icu_icfs32_field_t;

typedef struct stc_mft_icu_icsa10_field
{
  __IO  uint8_t EG00       : 1;
  __IO  uint8_t EG01       : 1;
  __IO  uint8_t EG10       : 1;
  __IO  uint8_t EG11       : 1;
  __IO  uint8_t ICE0       : 1;
  __IO  uint8_t ICE1       : 1;
  __IO  uint8_t ICP0       : 1;
  __IO  uint8_t ICP1       : 1;
} stc_mft_icu_icsa10_field_t;

typedef struct stc_mft_icu_icsb10_field
{
  __IO  uint8_t IEI0       : 1;
  __IO  uint8_t IEI1       : 1;
} stc_mft_icu_icsb10_field_t;

typedef struct stc_mft_icu_icsa32_field
{
  __IO  uint8_t EG20       : 1;
  __IO  uint8_t EG21       : 1;
  __IO  uint8_t EG30       : 1;
  __IO  uint8_t EG31       : 1;
  __IO  uint8_t ICE2       : 1;
  __IO  uint8_t ICE3       : 1;
  __IO  uint8_t ICP2       : 1;
  __IO  uint8_t ICP3       : 1;
} stc_mft_icu_icsa32_field_t;

typedef struct stc_mft_icu_icsb32_field
{
  __IO  uint8_t IEI2       : 1;
  __IO  uint8_t IEI3       : 1;
} stc_mft_icu_icsb32_field_t;

/******************************************************************************
 * MFT_ADCMP_MODULE
 ******************************************************************************/
/* MFT_ADCMP_MODULE register bit fields */
typedef struct stc_mft_adcmp_acsb_field
{
  __IO  uint8_t BDIS0      : 1;
  __IO  uint8_t BDIS1      : 1;
  __IO  uint8_t BDIS2      : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t BTS0       : 1;
  __IO  uint8_t BTS1       : 1;
  __IO  uint8_t BTS2       : 1;
} stc_mft_adcmp_acsb_field_t;

typedef struct stc_mft_adcmp_acsa_field
{
  __IO uint16_t CE00       : 1;
  __IO uint16_t CE01       : 1;
  __IO uint16_t CE10       : 1;
  __IO uint16_t CE11       : 1;
  __IO uint16_t CE20       : 1;
  __IO uint16_t CE21       : 1;
       uint16_t RESERVED1  : 2;
  __IO uint16_t SEL00      : 1;
  __IO uint16_t SEL01      : 1;
  __IO uint16_t SEL10      : 1;
  __IO uint16_t SEL11      : 1;
  __IO uint16_t SEL20      : 1;
  __IO uint16_t SEL21      : 1;
} stc_mft_adcmp_acsa_field_t;

typedef struct stc_mft_adcmp_atsa_field
{
  __IO uint16_t AD0S0      : 1;
  __IO uint16_t AD0S1      : 1;
  __IO uint16_t AD1S0      : 1;
  __IO uint16_t AD1S1      : 1;
  __IO uint16_t AD2S0      : 1;
  __IO uint16_t AD2S1      : 1;
       uint16_t RESERVED1  : 2;
  __IO uint16_t AD0P0      : 1;
  __IO uint16_t AD0P1      : 1;
  __IO uint16_t AD1P0      : 1;
  __IO uint16_t AD1P1      : 1;
  __IO uint16_t AD2P0      : 1;
  __IO uint16_t AD2P1      : 1;
} stc_mft_adcmp_atsa_field_t;

/******************************************************************************
 * MFT_PPG_MODULE
 ******************************************************************************/
/* MFT_PPG_MODULE register bit fields */
typedef struct stc_mft_ppg_ttcr0_field
{
  __IO  uint8_t STR0       : 1;
  __IO  uint8_t MONI0      : 1;
  __IO  uint8_t CS00       : 1;
  __IO  uint8_t CS01       : 1;
  __IO  uint8_t TRG0O      : 1;
  __IO  uint8_t TRG2O      : 1;
  __IO  uint8_t TRG4O      : 1;
  __IO  uint8_t TRG6O      : 1;
} stc_mft_ppg_ttcr0_field_t;

typedef struct stc_mft_ppg_ttcr1_field
{
  __IO  uint8_t STR1       : 1;
  __IO  uint8_t MONI1      : 1;
  __IO  uint8_t CS10       : 1;
  __IO  uint8_t CS11       : 1;
  __IO  uint8_t TRG1O      : 1;
  __IO  uint8_t TRG3O      : 1;
  __IO  uint8_t TRG5O      : 1;
  __IO  uint8_t TRG7O      : 1;
} stc_mft_ppg_ttcr1_field_t;

typedef struct stc_mft_ppg_ttcr2_field
{
  __IO  uint8_t STR2       : 1;
  __IO  uint8_t MONI2      : 1;
  __IO  uint8_t CS20       : 1;
  __IO  uint8_t CS21       : 1;
  __IO  uint8_t TRG16O     : 1;
  __IO  uint8_t TRG18O     : 1;
  __IO  uint8_t TRG20O     : 1;
  __IO  uint8_t TRG22O     : 1;
} stc_mft_ppg_ttcr2_field_t;

typedef struct stc_mft_ppg_trg_field
{
  __IO uint16_t PEN00      : 1;
  __IO uint16_t PEN01      : 1;
  __IO uint16_t PEN02      : 1;
  __IO uint16_t PEN03      : 1;
  __IO uint16_t PEN04      : 1;
  __IO uint16_t PEN05      : 1;
  __IO uint16_t PEN06      : 1;
  __IO uint16_t PEN07      : 1;
  __IO uint16_t PEN08      : 1;
  __IO uint16_t PEN09      : 1;
  __IO uint16_t PEN10      : 1;
  __IO uint16_t PEN11      : 1;
  __IO uint16_t PEN12      : 1;
  __IO uint16_t PEN13      : 1;
  __IO uint16_t PEN14      : 1;
  __IO uint16_t PEN15      : 1;
} stc_mft_ppg_trg_field_t;

typedef struct stc_mft_ppg_trg1_field
{
  __IO uint16_t PEN16      : 1;
  __IO uint16_t PEN17      : 1;
  __IO uint16_t PEN18      : 1;
  __IO uint16_t PEN19      : 1;
  __IO uint16_t PEN20      : 1;
  __IO uint16_t PEN21      : 1;
  __IO uint16_t PEN22      : 1;
  __IO uint16_t PEN23      : 1;
} stc_mft_ppg_trg1_field_t;

typedef struct stc_mft_ppg_revc_field
{
  __IO uint16_t REV00      : 1;
  __IO uint16_t REV01      : 1;
  __IO uint16_t REV02      : 1;
  __IO uint16_t REV03      : 1;
  __IO uint16_t REV04      : 1;
  __IO uint16_t REV05      : 1;
  __IO uint16_t REV06      : 1;
  __IO uint16_t REV07      : 1;
  __IO uint16_t REV08      : 1;
  __IO uint16_t REV09      : 1;
  __IO uint16_t REV10      : 1;
  __IO uint16_t REV11      : 1;
  __IO uint16_t REV12      : 1;
  __IO uint16_t REV13      : 1;
  __IO uint16_t REV14      : 1;
  __IO uint16_t REV15      : 1;
} stc_mft_ppg_revc_field_t;

typedef struct stc_mft_ppg_revc1_field
{
  __IO uint16_t REV16      : 1;
  __IO uint16_t REV17      : 1;
  __IO uint16_t REV18      : 1;
  __IO uint16_t REV19      : 1;
  __IO uint16_t REV20      : 1;
  __IO uint16_t REV21      : 1;
  __IO uint16_t REV22      : 1;
  __IO uint16_t REV23      : 1;
} stc_mft_ppg_revc1_field_t;

typedef struct stc_mft_ppg_ppgc1_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc1_field_t;

typedef struct stc_mft_ppg_ppgc0_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc0_field_t;

typedef struct stc_mft_ppg_ppgc3_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc3_field_t;

typedef struct stc_mft_ppg_ppgc2_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc2_field_t;

typedef struct stc_mft_ppg_gatec0_field
{
  __IO  uint8_t EDGE0      : 1;
  __IO  uint8_t STRG0      : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t EDGE2      : 1;
  __IO  uint8_t STRG2      : 1;
} stc_mft_ppg_gatec0_field_t;

typedef struct stc_mft_ppg_ppgc5_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc5_field_t;

typedef struct stc_mft_ppg_ppgc4_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc4_field_t;

typedef struct stc_mft_ppg_ppgc7_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc7_field_t;

typedef struct stc_mft_ppg_ppgc6_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc6_field_t;

typedef struct stc_mft_ppg_gatec4_field
{
  __IO  uint8_t EDGE4      : 1;
  __IO  uint8_t STRG4      : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t EDGE6      : 1;
  __IO  uint8_t STRG6      : 1;
} stc_mft_ppg_gatec4_field_t;

typedef struct stc_mft_ppg_ppgc9_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc9_field_t;

typedef struct stc_mft_ppg_ppgc8_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc8_field_t;

typedef struct stc_mft_ppg_ppgc11_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc11_field_t;

typedef struct stc_mft_ppg_ppgc10_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc10_field_t;

typedef struct stc_mft_ppg_gatec8_field
{
  __IO  uint8_t EDGE8      : 1;
  __IO  uint8_t STRG8      : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t EDGE10     : 1;
  __IO  uint8_t STRG10     : 1;
} stc_mft_ppg_gatec8_field_t;

typedef struct stc_mft_ppg_ppgc13_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc13_field_t;

typedef struct stc_mft_ppg_ppgc12_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc12_field_t;

typedef struct stc_mft_ppg_ppgc15_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc15_field_t;

typedef struct stc_mft_ppg_ppgc14_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc14_field_t;

typedef struct stc_mft_ppg_gatec12_field
{
  __IO  uint8_t EDGE12     : 1;
  __IO  uint8_t STRG12     : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t EDGE14     : 1;
  __IO  uint8_t STRG14     : 1;
} stc_mft_ppg_gatec12_field_t;

typedef struct stc_mft_ppg_ppgc17_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc17_field_t;

typedef struct stc_mft_ppg_ppgc16_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc16_field_t;

typedef struct stc_mft_ppg_ppgc19_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc19_field_t;

typedef struct stc_mft_ppg_ppgc18_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc18_field_t;

typedef struct stc_mft_ppg_gatec16_field
{
  __IO  uint8_t EDGE16     : 1;
  __IO  uint8_t STRG16     : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t EDGE18     : 1;
  __IO  uint8_t STRG18     : 1;
} stc_mft_ppg_gatec16_field_t;

typedef struct stc_mft_ppg_ppgc21_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc21_field_t;

typedef struct stc_mft_ppg_ppgc20_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc20_field_t;

typedef struct stc_mft_ppg_ppgc23_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc23_field_t;

typedef struct stc_mft_ppg_ppgc22_field
{
  __IO  uint8_t TTRG       : 1;
  __IO  uint8_t MD         : 2;
  __IO  uint8_t PCS0       : 1;
  __IO  uint8_t PCS1       : 1;
  __IO  uint8_t INTM       : 1;
  __IO  uint8_t PUF        : 1;
  __IO  uint8_t PIE        : 1;
} stc_mft_ppg_ppgc22_field_t;

typedef struct stc_mft_ppg_gatec20_field
{
  __IO  uint8_t EDGE20     : 1;
  __IO  uint8_t STRG20     : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t EDGE22     : 1;
  __IO  uint8_t STRG22     : 1;
} stc_mft_ppg_gatec20_field_t;

/******************************************************************************
 * BT_PPG_MODULE
 ******************************************************************************/
/* BT_PPG_MODULE register bit fields */
typedef struct stc_bt_ppg_tmcr_field
{
  __IO uint16_t STRG       : 1;
  __IO uint16_t CTEN       : 1;
  __IO uint16_t MDSE       : 1;
  __IO uint16_t OSEL       : 1;
       uint16_t RESERVED4  : 1;
       uint16_t RESERVED5  : 1;
       uint16_t RESERVED6  : 1;
       uint16_t RESERVED1  : 1;
  __IO uint16_t EGS0       : 1;
  __IO uint16_t EGS1       : 1;
  __IO uint16_t PMSK       : 1;
  __IO uint16_t RTGEN      : 1;
  __IO uint16_t CKS0       : 1;
  __IO uint16_t CKS1       : 1;
  __IO uint16_t CKS2       : 1;
} stc_bt_ppg_tmcr_field_t;

typedef struct stc_bt_ppg_stc_field
{
  __IO  uint8_t UDIR       : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t TGIR       : 1;
        uint8_t RESERVED2  : 1;
  __IO  uint8_t UDIE       : 1;
        uint8_t RESERVED3  : 1;
  __IO  uint8_t TGIE       : 1;
} stc_bt_ppg_stc_field_t;

typedef struct stc_bt_ppg_tmcr2_field
{
  __IO  uint8_t CKS3       : 1;
} stc_bt_ppg_tmcr2_field_t;

/******************************************************************************
 * BT_PWM_MODULE
 ******************************************************************************/
/* BT_PWM_MODULE register bit fields */
typedef struct stc_bt_pwm_tmcr_field
{
  __IO uint16_t STRG       : 1;
  __IO uint16_t CTEN       : 1;
  __IO uint16_t MDSE       : 1;
  __IO uint16_t OSEL       : 1;
  __IO uint16_t FMD        : 3;
       uint16_t RESERVED1  : 1;
  __IO uint16_t EGS0       : 1;
  __IO uint16_t EGS1       : 1;
  __IO uint16_t PMSK       : 1;
  __IO uint16_t RTGEN      : 1;
  __IO uint16_t CKS0       : 1;
  __IO uint16_t CKS1       : 1;
  __IO uint16_t CKS2       : 1;
} stc_bt_pwm_tmcr_field_t;

typedef struct stc_bt_pwm_stc_field
{
  __IO  uint8_t UDIR       : 1;
  __IO  uint8_t DTIR       : 1;
  __IO  uint8_t TGIR       : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t UDIE       : 1;
  __IO  uint8_t DTIE       : 1;
  __IO  uint8_t TGIE       : 1;
} stc_bt_pwm_stc_field_t;

typedef struct stc_bt_pwm_tmcr2_field
{
  __IO  uint8_t CKS3       : 1;
} stc_bt_pwm_tmcr2_field_t;

/******************************************************************************
 * BT_RT_MODULE
 ******************************************************************************/
/* BT_RT_MODULE register bit fields */
typedef struct stc_bt_rt_tmcr_field
{
  __IO uint16_t STRG       : 1;
  __IO uint16_t CTEN       : 1;
  __IO uint16_t MDSE       : 1;
  __IO uint16_t OSEL       : 1;
  __IO uint16_t FMD        : 3;
  __IO uint16_t T32        : 1;
  __IO uint16_t EGS0       : 1;
  __IO uint16_t EGS1       : 1;
       uint16_t RESERVED1  : 2;
  __IO uint16_t CKS0       : 1;
  __IO uint16_t CKS1       : 1;
  __IO uint16_t CKS2       : 1;
} stc_bt_rt_tmcr_field_t;

typedef struct stc_bt_rt_stc_field
{
  __IO  uint8_t UDIR       : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t TGIR       : 1;
        uint8_t RESERVED2  : 1;
  __IO  uint8_t UDIE       : 1;
        uint8_t RESERVED3  : 1;
  __IO  uint8_t TGIE       : 1;
} stc_bt_rt_stc_field_t;

typedef struct stc_bt_rt_tmcr2_field
{
  __IO  uint8_t CKS3       : 1;
} stc_bt_rt_tmcr2_field_t;

/******************************************************************************
 * BT_PWC_MODULE
 ******************************************************************************/
/* BT_PWC_MODULE register bit fields */
typedef struct stc_bt_pwc_tmcr_field
{
       uint16_t RESERVED1  : 1;
  __IO uint16_t CTEN       : 1;
  __IO uint16_t MDSE       : 1;
       uint16_t RESERVED2  : 1;
  __IO uint16_t FMD        : 3;
  __IO uint16_t T32        : 1;
  __IO uint16_t EGS0       : 1;
  __IO uint16_t EGS1       : 1;
  __IO uint16_t EGS2       : 1;
       uint16_t RESERVED3  : 1;
  __IO uint16_t CKS0       : 1;
  __IO uint16_t CKS1       : 1;
  __IO uint16_t CKS2       : 1;
} stc_bt_pwc_tmcr_field_t;

typedef struct stc_bt_pwc_stc_field
{
  __IO  uint8_t OVIR       : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t EDIR       : 1;
        uint8_t RESERVED2  : 1;
  __IO  uint8_t OVIE       : 1;
        uint8_t RESERVED3  : 1;
  __IO  uint8_t EDIE       : 1;
  __IO  uint8_t ERR        : 1;
} stc_bt_pwc_stc_field_t;

typedef struct stc_bt_pwc_tmcr2_field
{
  __IO  uint8_t CKS3       : 1;
} stc_bt_pwc_tmcr2_field_t;

/******************************************************************************
 * BTIOSEL03_MODULE
 ******************************************************************************/
/* BTIOSEL03_MODULE register bit fields */
typedef struct stc_btiosel03_btsel0123_field
{
  __IO  uint8_t SEL01_0    : 1;
  __IO  uint8_t SEL01_1    : 1;
  __IO  uint8_t SEL01_2    : 1;
  __IO  uint8_t SEL01_3    : 1;
  __IO  uint8_t SEL23_0    : 1;
  __IO  uint8_t SEL23_1    : 1;
  __IO  uint8_t SEL23_2    : 1;
  __IO  uint8_t SEL23_3    : 1;
} stc_btiosel03_btsel0123_field_t;

/******************************************************************************
 * BTIOSEL47_MODULE
 ******************************************************************************/
/* BTIOSEL47_MODULE register bit fields */
typedef struct stc_btiosel47_btsel4567_field
{
  __IO  uint8_t SEL45_0    : 1;
  __IO  uint8_t SEL45_1    : 1;
  __IO  uint8_t SEL45_2    : 1;
  __IO  uint8_t SEL45_3    : 1;
  __IO  uint8_t SEL67_0    : 1;
  __IO  uint8_t SEL67_1    : 1;
  __IO  uint8_t SEL67_2    : 1;
  __IO  uint8_t SEL67_3    : 1;
} stc_btiosel47_btsel4567_field_t;

/******************************************************************************
 * BTIOSEL811_MODULE
 ******************************************************************************/
/* BTIOSEL811_MODULE register bit fields */
typedef struct stc_btiosel8b_btsel89ab_field
{
  __IO  uint8_t SEL89_0    : 1;
  __IO  uint8_t SEL89_1    : 1;
  __IO  uint8_t SEL89_2    : 1;
  __IO  uint8_t SEL89_3    : 1;
  __IO  uint8_t SELAB_0    : 1;
  __IO  uint8_t SELAB_1    : 1;
  __IO  uint8_t SELAB_2    : 1;
  __IO  uint8_t SELAB_3    : 1;
} stc_btiosel8b_btsel89ab_field_t;

/******************************************************************************
 * BTIOSEL1215_MODULE
 ******************************************************************************/
/* BTIOSEL1215_MODULE register bit fields */
typedef struct stc_btioselcf_btselcdef_field
{
  __IO  uint8_t SELCD_0    : 1;
  __IO  uint8_t SELCD_1    : 1;
  __IO  uint8_t SELCD_2    : 1;
  __IO  uint8_t SELCD_3    : 1;
  __IO  uint8_t SELEF_0    : 1;
  __IO  uint8_t SELEF_1    : 1;
  __IO  uint8_t SELEF_2    : 1;
  __IO  uint8_t SELEF_3    : 1;
} stc_btioselcf_btselcdef_field_t;

/******************************************************************************
 * SBSSR_MODULE
 ******************************************************************************/
/* SBSSR_MODULE register bit fields */
typedef struct stc_sbssr_btsssr_field
{
  __IO uint16_t SSSR0      : 1;
  __IO uint16_t SSSR1      : 1;
  __IO uint16_t SSSR2      : 1;
  __IO uint16_t SSSR3      : 1;
  __IO uint16_t SSSR4      : 1;
  __IO uint16_t SSSR5      : 1;
  __IO uint16_t SSSR6      : 1;
  __IO uint16_t SSSR7      : 1;
  __IO uint16_t SSSR8      : 1;
  __IO uint16_t SSSR9      : 1;
  __IO uint16_t SSSR10     : 1;
  __IO uint16_t SSSR11     : 1;
  __IO uint16_t SSSR12     : 1;
  __IO uint16_t SSSR13     : 1;
  __IO uint16_t SSSR14     : 1;
  __IO uint16_t SSSR15     : 1;
} stc_sbssr_btsssr_field_t;

/******************************************************************************
 * QPRC_MODULE
 ******************************************************************************/
/* QPRC_MODULE register bit fields */
typedef struct stc_qprc_qicr_field
{
  __IO uint16_t QPCMIE     : 1;
  __IO uint16_t QPCMF      : 1;
  __IO uint16_t QPRCMIE    : 1;
  __IO uint16_t QPRCMF     : 1;
  __IO uint16_t OUZIE      : 1;
  __IO uint16_t UFDF       : 1;
  __IO uint16_t OFDF       : 1;
  __IO uint16_t ZIIF       : 1;
  __IO uint16_t CDCIE      : 1;
  __IO uint16_t CDCF       : 1;
  __IO uint16_t DIRPC      : 1;
  __IO uint16_t DIROU      : 1;
  __IO uint16_t QPCNRCMIE  : 1;
  __IO uint16_t QPCNRCMF   : 1;
} stc_qprc_qicr_field_t;

typedef struct stc_qprc_qicrl_field
{
  __IO  uint8_t QPCMIE     : 1;
  __IO  uint8_t QPCMF      : 1;
  __IO  uint8_t QPRCMIE    : 1;
  __IO  uint8_t QPRCMF     : 1;
  __IO  uint8_t OUZIE      : 1;
  __IO  uint8_t UFDF       : 1;
  __IO  uint8_t OFDF       : 1;
  __IO  uint8_t ZIIF       : 1;
} stc_qprc_qicrl_field_t;

typedef struct stc_qprc_qicrh_field
{
  __IO  uint8_t CDCIE      : 1;
  __IO  uint8_t CDCF       : 1;
  __IO  uint8_t DIRPC      : 1;
  __IO  uint8_t DIROU      : 1;
  __IO  uint8_t QPCNRCMIE  : 1;
  __IO  uint8_t QPCNRCMF   : 1;
} stc_qprc_qicrh_field_t;

typedef struct stc_qprc_qcr_field
{
  __IO uint16_t PCM0       : 1;
  __IO uint16_t PCM1       : 1;
  __IO uint16_t RCM0       : 1;
  __IO uint16_t RCM1       : 1;
  __IO uint16_t PSTP       : 1;
  __IO uint16_t CGSC       : 1;
  __IO uint16_t RSEL       : 1;
  __IO uint16_t SWAP       : 1;
  __IO uint16_t PCRM0      : 1;
  __IO uint16_t PCRM1      : 1;
  __IO uint16_t AES0       : 1;
  __IO uint16_t AES1       : 1;
  __IO uint16_t BES0       : 1;
  __IO uint16_t BES1       : 1;
  __IO uint16_t CGE0       : 1;
  __IO uint16_t CGE1       : 1;
} stc_qprc_qcr_field_t;

typedef struct stc_qprc_qcrl_field
{
  __IO  uint8_t PCM0       : 1;
  __IO  uint8_t PCM1       : 1;
  __IO  uint8_t RCM0       : 1;
  __IO  uint8_t RCM1       : 1;
  __IO  uint8_t PSTP       : 1;
  __IO  uint8_t CGSC       : 1;
  __IO  uint8_t RSEL       : 1;
  __IO  uint8_t SWAP       : 1;
} stc_qprc_qcrl_field_t;

typedef struct stc_qprc_qcrh_field
{
  __IO  uint8_t PCRM0      : 1;
  __IO  uint8_t PCRM1      : 1;
  __IO  uint8_t AES0       : 1;
  __IO  uint8_t AES1       : 1;
  __IO  uint8_t BES0       : 1;
  __IO  uint8_t BES1       : 1;
  __IO  uint8_t CGE0       : 1;
  __IO  uint8_t CGE1       : 1;
} stc_qprc_qcrh_field_t;

typedef struct stc_qprc_qecr_field
{
  __IO uint16_t ORNGMD     : 1;
  __IO uint16_t ORNGF      : 1;
  __IO uint16_t ORNGIE     : 1;
} stc_qprc_qecr_field_t;

/******************************************************************************
 * ADC12_MODULE
 ******************************************************************************/
/* ADC12_MODULE register bit fields */
typedef struct stc_adc_adsr_field
{
  __IO  uint8_t SCS        : 1;
  __IO  uint8_t PCS        : 1;
  __IO  uint8_t PCNS       : 1;
        uint8_t RESERVED1  : 3;
  __IO  uint8_t FDAS       : 1;
  __IO  uint8_t ADSTP      : 1;
} stc_adc_adsr_field_t;

typedef struct stc_adc_adcr_field
{
  __IO  uint8_t OVRIE      : 1;
  __IO  uint8_t CMPIE      : 1;
  __IO  uint8_t PCIE       : 1;
  __IO  uint8_t SCIE       : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t CMPIF      : 1;
  __IO  uint8_t PCIF       : 1;
  __IO  uint8_t SCIF       : 1;
} stc_adc_adcr_field_t;

typedef struct stc_adc_sfns_field
{
  __IO  uint8_t SFS0       : 1;
  __IO  uint8_t SFS1       : 1;
  __IO  uint8_t SFS2       : 1;
  __IO  uint8_t SFS3       : 1;
} stc_adc_sfns_field_t;

typedef struct stc_adc_sccr_field
{
  __IO  uint8_t SSTR       : 1;
  __IO  uint8_t SHEN       : 1;
  __IO  uint8_t RPT        : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t SFCLR      : 1;
  __IO  uint8_t SOVR       : 1;
  __IO  uint8_t SFUL       : 1;
  __IO  uint8_t SEMP       : 1;
} stc_adc_sccr_field_t;

typedef struct stc_adc_scfd_field
{
  __IO uint32_t SC0        : 1;
  __IO uint32_t SC1        : 1;
  __IO uint32_t SC2        : 1;
  __IO uint32_t SC3        : 1;
  __IO uint32_t SC4        : 1;
       uint32_t RESERVED1  : 3;
  __IO uint32_t RS0        : 1;
  __IO uint32_t RS1        : 1;
       uint32_t RESERVED2  : 2;
  __IO uint32_t INVL       : 1;
       uint32_t RESERVED3  : 7;
  __IO uint32_t SD0        : 1;
  __IO uint32_t SD1        : 1;
  __IO uint32_t SD2        : 1;
  __IO uint32_t SD3        : 1;
  __IO uint32_t SD4        : 1;
  __IO uint32_t SD5        : 1;
  __IO uint32_t SD6        : 1;
  __IO uint32_t SD7        : 1;
  __IO uint32_t SD8        : 1;
  __IO uint32_t SD9        : 1;
  __IO uint32_t SD10       : 1;
  __IO uint32_t SD11       : 1;
} stc_adc_scfd_field_t;

typedef struct stc_adc_scfdl_field
{
  __IO uint16_t SC0        : 1;
  __IO uint16_t SC1        : 1;
  __IO uint16_t SC2        : 1;
  __IO uint16_t SC3        : 1;
  __IO uint16_t SC4        : 1;
       uint16_t RESERVED1  : 3;
  __IO uint16_t RS0        : 1;
  __IO uint16_t RS1        : 1;
       uint16_t RESERVED2  : 2;
  __IO uint16_t INVL       : 1;
} stc_adc_scfdl_field_t;

typedef struct stc_adc_scfdh_field
{
       uint16_t RESERVED1  : 4;
  __IO uint16_t SD0        : 1;
  __IO uint16_t SD1        : 1;
  __IO uint16_t SD2        : 1;
  __IO uint16_t SD3        : 1;
  __IO uint16_t SD4        : 1;
  __IO uint16_t SD5        : 1;
  __IO uint16_t SD6        : 1;
  __IO uint16_t SD7        : 1;
  __IO uint16_t SD8        : 1;
  __IO uint16_t SD9        : 1;
  __IO uint16_t SD10       : 1;
  __IO uint16_t SD11       : 1;
} stc_adc_scfdh_field_t;

typedef struct stc_adc_scis23_field
{
  __IO uint16_t AN16       : 1;
  __IO uint16_t AN17       : 1;
  __IO uint16_t AN18       : 1;
  __IO uint16_t AN19       : 1;
  __IO uint16_t AN20       : 1;
  __IO uint16_t AN21       : 1;
  __IO uint16_t AN22       : 1;
  __IO uint16_t AN23       : 1;
  __IO uint16_t AN24       : 1;
  __IO uint16_t AN25       : 1;
  __IO uint16_t AN26       : 1;
  __IO uint16_t AN27       : 1;
  __IO uint16_t AN28       : 1;
  __IO uint16_t AN29       : 1;
  __IO uint16_t AN30       : 1;
  __IO uint16_t AN31       : 1;
} stc_adc_scis23_field_t;

typedef struct stc_adc_scis2_field
{
  __IO  uint8_t AN16       : 1;
  __IO  uint8_t AN17       : 1;
  __IO  uint8_t AN18       : 1;
  __IO  uint8_t AN19       : 1;
  __IO  uint8_t AN20       : 1;
  __IO  uint8_t AN21       : 1;
  __IO  uint8_t AN22       : 1;
  __IO  uint8_t AN23       : 1;
} stc_adc_scis2_field_t;

typedef struct stc_adc_scis3_field
{
  __IO  uint8_t AN24       : 1;
  __IO  uint8_t AN25       : 1;
  __IO  uint8_t AN26       : 1;
  __IO  uint8_t AN27       : 1;
  __IO  uint8_t AN28       : 1;
  __IO  uint8_t AN29       : 1;
  __IO  uint8_t AN30       : 1;
  __IO  uint8_t AN31       : 1;
} stc_adc_scis3_field_t;

typedef struct stc_adc_scis01_field
{
  __IO uint16_t AN0        : 1;
  __IO uint16_t AN1        : 1;
  __IO uint16_t AN2        : 1;
  __IO uint16_t AN3        : 1;
  __IO uint16_t AN4        : 1;
  __IO uint16_t AN5        : 1;
  __IO uint16_t AN6        : 1;
  __IO uint16_t AN7        : 1;
  __IO uint16_t AN8        : 1;
  __IO uint16_t AN9        : 1;
  __IO uint16_t AN10       : 1;
  __IO uint16_t AN11       : 1;
  __IO uint16_t AN12       : 1;
  __IO uint16_t AN13       : 1;
  __IO uint16_t AN14       : 1;
  __IO uint16_t AN15       : 1;
} stc_adc_scis01_field_t;

typedef struct stc_adc_scis0_field
{
  __IO  uint8_t AN0        : 1;
  __IO  uint8_t AN1        : 1;
  __IO  uint8_t AN2        : 1;
  __IO  uint8_t AN3        : 1;
  __IO  uint8_t AN4        : 1;
  __IO  uint8_t AN5        : 1;
  __IO  uint8_t AN6        : 1;
  __IO  uint8_t AN7        : 1;
} stc_adc_scis0_field_t;

typedef struct stc_adc_scis1_field
{
  __IO  uint8_t AN8        : 1;
  __IO  uint8_t AN9        : 1;
  __IO  uint8_t AN10       : 1;
  __IO  uint8_t AN11       : 1;
  __IO  uint8_t AN12       : 1;
  __IO  uint8_t AN13       : 1;
  __IO  uint8_t AN14       : 1;
  __IO  uint8_t AN15       : 1;
} stc_adc_scis1_field_t;

typedef struct stc_adc_pfns_field
{
  __IO  uint8_t PFS0       : 1;
  __IO  uint8_t PFS1       : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t TEST0      : 1;
  __IO  uint8_t TEST1      : 1;
} stc_adc_pfns_field_t;

typedef struct stc_adc_pccr_field
{
  __IO  uint8_t PSTR       : 1;
  __IO  uint8_t PHEN       : 1;
  __IO  uint8_t PEEN       : 1;
  __IO  uint8_t ESCE       : 1;
  __IO  uint8_t PFCLR      : 1;
  __IO  uint8_t POVR       : 1;
  __IO  uint8_t PFUL       : 1;
  __IO  uint8_t PEMP       : 1;
} stc_adc_pccr_field_t;

typedef struct stc_adc_pcfd_field
{
  __IO uint32_t PC0        : 1;
  __IO uint32_t PC1        : 1;
  __IO uint32_t PC2        : 1;
  __IO uint32_t PC3        : 1;
  __IO uint32_t PC4        : 1;
       uint32_t RESERVED1  : 3;
  __IO uint32_t RS0        : 1;
  __IO uint32_t RS1        : 1;
  __IO uint32_t RS2        : 1;
       uint32_t RESERVED2  : 1;
  __IO uint32_t INVL       : 1;
       uint32_t RESERVED3  : 7;
  __IO uint32_t PD0        : 1;
  __IO uint32_t PD1        : 1;
  __IO uint32_t PD2        : 1;
  __IO uint32_t PD3        : 1;
  __IO uint32_t PD4        : 1;
  __IO uint32_t PD5        : 1;
  __IO uint32_t PD6        : 1;
  __IO uint32_t PD7        : 1;
  __IO uint32_t PD8        : 1;
  __IO uint32_t PD9        : 1;
  __IO uint32_t PD10       : 1;
  __IO uint32_t PD11       : 1;
} stc_adc_pcfd_field_t;

typedef struct stc_adc_pcfdl_field
{
  __IO uint16_t PC0        : 1;
  __IO uint16_t PC1        : 1;
  __IO uint16_t PC2        : 1;
  __IO uint16_t PC3        : 1;
  __IO uint16_t PC4        : 1;
       uint16_t RESERVED1  : 3;
  __IO uint16_t RS0        : 1;
  __IO uint16_t RS1        : 1;
  __IO uint16_t RS2        : 1;
       uint16_t RESERVED2  : 1;
  __IO uint16_t INVL       : 1;
} stc_adc_pcfdl_field_t;

typedef struct stc_adc_pcfdh_field
{
       uint16_t RESERVED1  : 4;
  __IO uint16_t PD0        : 1;
  __IO uint16_t PD1        : 1;
  __IO uint16_t PD2        : 1;
  __IO uint16_t PD3        : 1;
  __IO uint16_t PD4        : 1;
  __IO uint16_t PD5        : 1;
  __IO uint16_t PD6        : 1;
  __IO uint16_t PD7        : 1;
  __IO uint16_t PD8        : 1;
  __IO uint16_t PD9        : 1;
  __IO uint16_t PD10       : 1;
  __IO uint16_t PD11       : 1;
} stc_adc_pcfdh_field_t;

typedef struct stc_adc_pcis_field
{
  __IO  uint8_t P1A0       : 1;
  __IO  uint8_t P1A1       : 1;
  __IO  uint8_t P1A2       : 1;
  __IO  uint8_t P2A0       : 1;
  __IO  uint8_t P2A1       : 1;
  __IO  uint8_t P2A2       : 1;
  __IO  uint8_t P2A3       : 1;
  __IO  uint8_t P2A4       : 1;
} stc_adc_pcis_field_t;

typedef struct stc_adc_cmpcr_field
{
  __IO  uint8_t CCH0       : 1;
  __IO  uint8_t CCH1       : 1;
  __IO  uint8_t CCH2       : 1;
  __IO  uint8_t CCH3       : 1;
  __IO  uint8_t CCH4       : 1;
  __IO  uint8_t CMD0       : 1;
  __IO  uint8_t CMD1       : 1;
  __IO  uint8_t CMPEN      : 1;
} stc_adc_cmpcr_field_t;

typedef struct stc_adc_cmpd_field
{
       uint16_t RESERVED1  : 6;
  __IO uint16_t CMAD2      : 1;
  __IO uint16_t CMAD3      : 1;
  __IO uint16_t CMAD4      : 1;
  __IO uint16_t CMAD5      : 1;
  __IO uint16_t CMAD6      : 1;
  __IO uint16_t CMAD7      : 1;
  __IO uint16_t CMAD8      : 1;
  __IO uint16_t CMAD9      : 1;
  __IO uint16_t CMAD10     : 1;
  __IO uint16_t CMAD11     : 1;
} stc_adc_cmpd_field_t;

typedef struct stc_adc_adss23_field
{
  __IO uint16_t TS16       : 1;
  __IO uint16_t TS17       : 1;
  __IO uint16_t TS18       : 1;
  __IO uint16_t TS19       : 1;
  __IO uint16_t TS20       : 1;
  __IO uint16_t TS21       : 1;
  __IO uint16_t TS22       : 1;
  __IO uint16_t TS23       : 1;
  __IO uint16_t TS24       : 1;
  __IO uint16_t TS25       : 1;
  __IO uint16_t TS26       : 1;
  __IO uint16_t TS27       : 1;
  __IO uint16_t TS28       : 1;
  __IO uint16_t TS29       : 1;
  __IO uint16_t TS30       : 1;
  __IO uint16_t TS31       : 1;
} stc_adc_adss23_field_t;

typedef struct stc_adc_adss2_field
{
  __IO  uint8_t TS16       : 1;
  __IO  uint8_t TS17       : 1;
  __IO  uint8_t TS18       : 1;
  __IO  uint8_t TS19       : 1;
  __IO  uint8_t TS20       : 1;
  __IO  uint8_t TS21       : 1;
  __IO  uint8_t TS22       : 1;
  __IO  uint8_t TS23       : 1;
} stc_adc_adss2_field_t;

typedef struct stc_adc_adss3_field
{
  __IO  uint8_t TS24       : 1;
  __IO  uint8_t TS25       : 1;
  __IO  uint8_t TS26       : 1;
  __IO  uint8_t TS27       : 1;
  __IO  uint8_t TS28       : 1;
  __IO  uint8_t TS29       : 1;
  __IO  uint8_t TS30       : 1;
  __IO  uint8_t TS31       : 1;
} stc_adc_adss3_field_t;

typedef struct stc_adc_adss01_field
{
  __IO uint16_t TS0        : 1;
  __IO uint16_t TS1        : 1;
  __IO uint16_t TS2        : 1;
  __IO uint16_t TS3        : 1;
  __IO uint16_t TS4        : 1;
  __IO uint16_t TS5        : 1;
  __IO uint16_t TS6        : 1;
  __IO uint16_t TS7        : 1;
  __IO uint16_t TS8        : 1;
  __IO uint16_t TS9        : 1;
  __IO uint16_t TS10       : 1;
  __IO uint16_t TS11       : 1;
  __IO uint16_t TS12       : 1;
  __IO uint16_t TS13       : 1;
  __IO uint16_t TS14       : 1;
  __IO uint16_t TS15       : 1;
} stc_adc_adss01_field_t;

typedef struct stc_adc_adss0_field
{
  __IO  uint8_t TS0        : 1;
  __IO  uint8_t TS1        : 1;
  __IO  uint8_t TS2        : 1;
  __IO  uint8_t TS3        : 1;
  __IO  uint8_t TS4        : 1;
  __IO  uint8_t TS5        : 1;
  __IO  uint8_t TS6        : 1;
  __IO  uint8_t TS7        : 1;
} stc_adc_adss0_field_t;

typedef struct stc_adc_adss1_field
{
  __IO  uint8_t TS8        : 1;
  __IO  uint8_t TS9        : 1;
  __IO  uint8_t TS10       : 1;
  __IO  uint8_t TS11       : 1;
  __IO  uint8_t TS12       : 1;
  __IO  uint8_t TS13       : 1;
  __IO  uint8_t TS14       : 1;
  __IO  uint8_t TS15       : 1;
} stc_adc_adss1_field_t;

typedef struct stc_adc_adst01_field
{
  __IO uint16_t ST10       : 1;
  __IO uint16_t ST11       : 1;
  __IO uint16_t ST12       : 1;
  __IO uint16_t ST13       : 1;
  __IO uint16_t ST14       : 1;
  __IO uint16_t STX10      : 1;
  __IO uint16_t STX11      : 1;
  __IO uint16_t STX12      : 1;
  __IO uint16_t ST00       : 1;
  __IO uint16_t ST01       : 1;
  __IO uint16_t ST02       : 1;
  __IO uint16_t ST03       : 1;
  __IO uint16_t ST04       : 1;
  __IO uint16_t STX00      : 1;
  __IO uint16_t STX01      : 1;
  __IO uint16_t STX02      : 1;
} stc_adc_adst01_field_t;

typedef struct stc_adc_adst1_field
{
  __IO  uint8_t ST10       : 1;
  __IO  uint8_t ST11       : 1;
  __IO  uint8_t ST12       : 1;
  __IO  uint8_t ST13       : 1;
  __IO  uint8_t ST14       : 1;
  __IO  uint8_t STX10      : 1;
  __IO  uint8_t STX11      : 1;
  __IO  uint8_t STX12      : 1;
} stc_adc_adst1_field_t;

typedef struct stc_adc_adst0_field
{
  __IO  uint8_t ST00       : 1;
  __IO  uint8_t ST01       : 1;
  __IO  uint8_t ST02       : 1;
  __IO  uint8_t ST03       : 1;
  __IO  uint8_t ST04       : 1;
  __IO  uint8_t STX00      : 1;
  __IO  uint8_t STX01      : 1;
  __IO  uint8_t STX02      : 1;
} stc_adc_adst0_field_t;

typedef struct stc_adc_adct_field
{
  __IO  uint8_t CT0        : 1;
  __IO  uint8_t CT1        : 1;
  __IO  uint8_t CT2        : 1;
  __IO  uint8_t CT3        : 1;
  __IO  uint8_t CT4        : 1;
  __IO  uint8_t CT5        : 1;
  __IO  uint8_t CT6        : 1;
  __IO  uint8_t CT7        : 1;
} stc_adc_adct_field_t;

typedef struct stc_adc_prtsl_field
{
  __IO  uint8_t PRTSL0     : 1;
  __IO  uint8_t PRTSL1     : 1;
  __IO  uint8_t PRTSL2     : 1;
  __IO  uint8_t PRTSL3     : 1;
} stc_adc_prtsl_field_t;

typedef struct stc_adc_sctsl_field
{
  __IO  uint8_t SCTSL0     : 1;
  __IO  uint8_t SCTSL1     : 1;
  __IO  uint8_t SCTSL2     : 1;
  __IO  uint8_t SCTSL3     : 1;
} stc_adc_sctsl_field_t;

typedef struct stc_adc_adcen_field
{
  __IO  uint8_t ENBL       : 1;
  __IO  uint8_t READY      : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t CYCLSL0    : 1;
  __IO  uint8_t CYCLSL1    : 1;
} stc_adc_adcen_field_t;

/******************************************************************************
 * CRTRIM_MODULE
 ******************************************************************************/
/* CRTRIM_MODULE register bit fields */
typedef struct stc_crtrim_mcr_psr_field
{
  __IO  uint8_t CSR0       : 1;
  __IO  uint8_t CSR1       : 1;
} stc_crtrim_mcr_psr_field_t;

typedef struct stc_crtrim_mcr_ftrm_field
{
  __IO uint16_t TRD0       : 1;
  __IO uint16_t TRD1       : 1;
  __IO uint16_t TRD2       : 1;
  __IO uint16_t TRD3       : 1;
  __IO uint16_t TRD4       : 1;
  __IO uint16_t TRD5       : 1;
  __IO uint16_t TRD6       : 1;
  __IO uint16_t TRD7       : 1;
} stc_crtrim_mcr_ftrm_field_t;

/******************************************************************************
 * EXTI_MODULE
 ******************************************************************************/
/* EXTI_MODULE registEN bit fields */
typedef struct stc_exti_enir_field
{
  __IO uint32_t EN0        : 1;
  __IO uint32_t EN1        : 1;
  __IO uint32_t EN2        : 1;
  __IO uint32_t EN3        : 1;
  __IO uint32_t EN4        : 1;
  __IO uint32_t EN5        : 1;
  __IO uint32_t EN6        : 1;
  __IO uint32_t EN7        : 1;
  __IO uint32_t EN8        : 1;
  __IO uint32_t EN9        : 1;
  __IO uint32_t EN10       : 1;
  __IO uint32_t EN11       : 1;
  __IO uint32_t EN12       : 1;
  __IO uint32_t EN13       : 1;
  __IO uint32_t EN14       : 1;
  __IO uint32_t EN15       : 1;
  __IO uint32_t EN16       : 1;
  __IO uint32_t EN17       : 1;
  __IO uint32_t EN18       : 1;
  __IO uint32_t EN19       : 1;
  __IO uint32_t EN20       : 1;
  __IO uint32_t EN21       : 1;
  __IO uint32_t EN22       : 1;
  __IO uint32_t EN23       : 1;
  __IO uint32_t EN24       : 1;
  __IO uint32_t EN25       : 1;
  __IO uint32_t EN26       : 1;
  __IO uint32_t EN27       : 1;
  __IO uint32_t EN28       : 1;
  __IO uint32_t EN29       : 1;
  __IO uint32_t EN30       : 1;
  __IO uint32_t EN31       : 1;
} stc_exti_enir_field_t;

typedef struct stc_exti_eirr_field
{
  __IO uint32_t ER0        : 1;
  __IO uint32_t ER1        : 1;
  __IO uint32_t ER2        : 1;
  __IO uint32_t ER3        : 1;
  __IO uint32_t ER4        : 1;
  __IO uint32_t ER5        : 1;
  __IO uint32_t ER6        : 1;
  __IO uint32_t ER7        : 1;
  __IO uint32_t ER8        : 1;
  __IO uint32_t ER9        : 1;
  __IO uint32_t ER10       : 1;
  __IO uint32_t ER11       : 1;
  __IO uint32_t ER12       : 1;
  __IO uint32_t ER13       : 1;
  __IO uint32_t ER14       : 1;
  __IO uint32_t ER15       : 1;
  __IO uint32_t ER16       : 1;
  __IO uint32_t ER17       : 1;
  __IO uint32_t ER18       : 1;
  __IO uint32_t ER19       : 1;
  __IO uint32_t ER20       : 1;
  __IO uint32_t ER21       : 1;
  __IO uint32_t ER22       : 1;
  __IO uint32_t ER23       : 1;
  __IO uint32_t ER24       : 1;
  __IO uint32_t ER25       : 1;
  __IO uint32_t ER26       : 1;
  __IO uint32_t ER27       : 1;
  __IO uint32_t ER28       : 1;
  __IO uint32_t ER29       : 1;
  __IO uint32_t ER30       : 1;
  __IO uint32_t ER31       : 1;
} stc_exti_eirr_field_t;

typedef struct stc_exti_eicl_field
{
  __IO uint32_t ECL0       : 1;
  __IO uint32_t ECL1       : 1;
  __IO uint32_t ECL2       : 1;
  __IO uint32_t ECL3       : 1;
  __IO uint32_t ECL4       : 1;
  __IO uint32_t ECL5       : 1;
  __IO uint32_t ECL6       : 1;
  __IO uint32_t ECL7       : 1;
  __IO uint32_t ECL8       : 1;
  __IO uint32_t ECL9       : 1;
  __IO uint32_t ECL10      : 1;
  __IO uint32_t ECL11      : 1;
  __IO uint32_t ECL12      : 1;
  __IO uint32_t ECL13      : 1;
  __IO uint32_t ECL14      : 1;
  __IO uint32_t ECL15      : 1;
  __IO uint32_t ECL16      : 1;
  __IO uint32_t ECL17      : 1;
  __IO uint32_t ECL18      : 1;
  __IO uint32_t ECL19      : 1;
  __IO uint32_t ECL20      : 1;
  __IO uint32_t ECL21      : 1;
  __IO uint32_t ECL22      : 1;
  __IO uint32_t ECL23      : 1;
  __IO uint32_t ECL24      : 1;
  __IO uint32_t ECL25      : 1;
  __IO uint32_t ECL26      : 1;
  __IO uint32_t ECL27      : 1;
  __IO uint32_t ECL28      : 1;
  __IO uint32_t ECL29      : 1;
  __IO uint32_t ECL30      : 1;
  __IO uint32_t ECL31      : 1;
} stc_exti_eicl_field_t;

typedef struct stc_exti_elvr_field
{
  __IO uint32_t LA0        : 1;
  __IO uint32_t LB0        : 1;
  __IO uint32_t LA1        : 1;
  __IO uint32_t LB1        : 1;
  __IO uint32_t LA2        : 1;
  __IO uint32_t LB2        : 1;
  __IO uint32_t LA3        : 1;
  __IO uint32_t LB3        : 1;
  __IO uint32_t LA4        : 1;
  __IO uint32_t LB4        : 1;
  __IO uint32_t LA5        : 1;
  __IO uint32_t LB5        : 1;
  __IO uint32_t LA6        : 1;
  __IO uint32_t LB6        : 1;
  __IO uint32_t LA7        : 1;
  __IO uint32_t LB7        : 1;
  __IO uint32_t LA8        : 1;
  __IO uint32_t LB8        : 1;
  __IO uint32_t LA9        : 1;
  __IO uint32_t LB9        : 1;
  __IO uint32_t LA10       : 1;
  __IO uint32_t LB10       : 1;
  __IO uint32_t LA11       : 1;
  __IO uint32_t LB11       : 1;
  __IO uint32_t LA12       : 1;
  __IO uint32_t LB12       : 1;
  __IO uint32_t LA13       : 1;
  __IO uint32_t LB13       : 1;
  __IO uint32_t LA14       : 1;
  __IO uint32_t LB14       : 1;
  __IO uint32_t LA15       : 1;
  __IO uint32_t LB15       : 1;
} stc_exti_elvr_field_t;

typedef struct stc_exti_elvr1_field
{
  __IO uint32_t LA16       : 1;
  __IO uint32_t LB16       : 1;
  __IO uint32_t LA17       : 1;
  __IO uint32_t LB17       : 1;
  __IO uint32_t LA18       : 1;
  __IO uint32_t LB18       : 1;
  __IO uint32_t LA19       : 1;
  __IO uint32_t LB19       : 1;
  __IO uint32_t LA20       : 1;
  __IO uint32_t LB20       : 1;
  __IO uint32_t LA21       : 1;
  __IO uint32_t LB21       : 1;
  __IO uint32_t LA22       : 1;
  __IO uint32_t LB22       : 1;
  __IO uint32_t LA23       : 1;
  __IO uint32_t LB23       : 1;
  __IO uint32_t LA24       : 1;
  __IO uint32_t LB24       : 1;
  __IO uint32_t LA25       : 1;
  __IO uint32_t LB25       : 1;
  __IO uint32_t LA26       : 1;
  __IO uint32_t LB26       : 1;
  __IO uint32_t LA27       : 1;
  __IO uint32_t LB27       : 1;
  __IO uint32_t LA28       : 1;
  __IO uint32_t LB28       : 1;
  __IO uint32_t LA29       : 1;
  __IO uint32_t LB29       : 1;
  __IO uint32_t LA30       : 1;
  __IO uint32_t LB30       : 1;
  __IO uint32_t LA31       : 1;
  __IO uint32_t LB31       : 1;
} stc_exti_elvr1_field_t;

typedef struct stc_exti_nmirr_field
{
  __IO  uint8_t NR         : 1;
} stc_exti_nmirr_field_t;

typedef struct stc_exti_nmicl_field
{
  __IO  uint8_t NCL        : 1;
} stc_exti_nmicl_field_t;

/******************************************************************************
 * INTREQ_MODULE
 ******************************************************************************/
/* INTREQ_MODULE register bit fields */
typedef struct stc_intreq_drqsel_field
{
  __IO uint32_t DRQSEL0    : 1;
  __IO uint32_t DRQSEL1    : 1;
  __IO uint32_t DRQSEL2    : 1;
  __IO uint32_t DRQSEL3    : 1;
  __IO uint32_t DRQSEL4    : 1;
  __IO uint32_t DRQSEL5    : 1;
  __IO uint32_t DRQSEL6    : 1;
  __IO uint32_t DRQSEL7    : 1;
  __IO uint32_t DRQSEL8    : 1;
  __IO uint32_t DRQSEL9    : 1;
  __IO uint32_t DRQSEL10   : 1;
  __IO uint32_t DRQSEL11   : 1;
  __IO uint32_t DRQSEL12   : 1;
  __IO uint32_t DRQSEL13   : 1;
  __IO uint32_t DRQSEL14   : 1;
  __IO uint32_t DRQSEL15   : 1;
  __IO uint32_t DRQSEL16   : 1;
  __IO uint32_t DRQSEL17   : 1;
  __IO uint32_t DRQSEL18   : 1;
  __IO uint32_t DRQSEL19   : 1;
  __IO uint32_t DRQSEL20   : 1;
  __IO uint32_t DRQSEL21   : 1;
  __IO uint32_t DRQSEL22   : 1;
  __IO uint32_t DRQSEL23   : 1;
  __IO uint32_t DRQSEL24   : 1;
  __IO uint32_t DRQSEL25   : 1;
  __IO uint32_t DRQSEL26   : 1;
  __IO uint32_t DRQSEL27   : 1;
  __IO uint32_t DRQSEL28   : 1;
  __IO uint32_t DRQSEL29   : 1;
  __IO uint32_t DRQSEL30   : 1;
  __IO uint32_t DRQSEL31   : 1;
} stc_intreq_drqsel_field_t;

typedef struct stc_intreq_oddpks_field
{
  __IO  uint8_t ODDPKS0    : 1;
  __IO  uint8_t ODDPKS1    : 1;
  __IO  uint8_t ODDPKS2    : 1;
  __IO  uint8_t ODDPKS3    : 1;
  __IO  uint8_t ODDPKS4    : 1;
} stc_intreq_oddpks_field_t;

typedef struct stc_intreq_exc02mon_field
{
  __IO uint32_t NMI        : 1;
  __IO uint32_t HWINT      : 1;
} stc_intreq_exc02mon_field_t;

typedef struct stc_intreq_irq00mon_field
{
  __IO uint32_t FCSINT     : 1;
} stc_intreq_irq00mon_field_t;

typedef struct stc_intreq_irq01mon_field
{
  __IO uint32_t SWWDTINT   : 1;
} stc_intreq_irq01mon_field_t;

typedef struct stc_intreq_irq02mon_field
{
  __IO uint32_t LVDINT     : 1;
} stc_intreq_irq02mon_field_t;

typedef struct stc_intreq_irq03mon_field
{
  __IO uint32_t WAVE0INT0  : 1;
  __IO uint32_t WAVE0INT1  : 1;
  __IO uint32_t WAVE0INT2  : 1;
  __IO uint32_t WAVE0INT3  : 1;
  __IO uint32_t WAVE1INT0  : 1;
  __IO uint32_t WAVE1INT1  : 1;
  __IO uint32_t WAVE1INT2  : 1;
  __IO uint32_t WAVE1INT3  : 1;
  __IO uint32_t WAVE2INT0  : 1;
  __IO uint32_t WAVE2INT1  : 1;
  __IO uint32_t WAVE2INT2  : 1;
  __IO uint32_t WAVE2INT3  : 1;
} stc_intreq_irq03mon_field_t;

typedef struct stc_intreq_irq04mon_field
{
  __IO uint32_t EXTINT0    : 1;
  __IO uint32_t EXTINT1    : 1;
  __IO uint32_t EXTINT2    : 1;
  __IO uint32_t EXTINT3    : 1;
  __IO uint32_t EXTINT4    : 1;
  __IO uint32_t EXTINT5    : 1;
  __IO uint32_t EXTINT6    : 1;
  __IO uint32_t EXTINT7    : 1;
} stc_intreq_irq04mon_field_t;

typedef struct stc_intreq_irq05mon_field
{
  __IO uint32_t EXTINT0    : 1;
  __IO uint32_t EXTINT1    : 1;
  __IO uint32_t EXTINT2    : 1;
  __IO uint32_t EXTINT3    : 1;
  __IO uint32_t EXTINT4    : 1;
  __IO uint32_t EXTINT5    : 1;
  __IO uint32_t EXTINT6    : 1;
  __IO uint32_t EXTINT7    : 1;
  __IO uint32_t EXTINT8    : 1;
  __IO uint32_t EXTINT9    : 1;
  __IO uint32_t EXTINT10   : 1;
  __IO uint32_t EXTINT11   : 1;
  __IO uint32_t EXTINT12   : 1;
  __IO uint32_t EXTINT13   : 1;
  __IO uint32_t EXTINT14   : 1;
  __IO uint32_t EXTINT15   : 1;
  __IO uint32_t EXTINT16   : 1;
  __IO uint32_t EXTINT17   : 1;
  __IO uint32_t EXTINT18   : 1;
  __IO uint32_t EXTINT19   : 1;
  __IO uint32_t EXTINT20   : 1;
  __IO uint32_t EXTINT21   : 1;
  __IO uint32_t EXTINT22   : 1;
  __IO uint32_t EXTINT23   : 1;
} stc_intreq_irq05mon_field_t;

typedef struct stc_intreq_irq06mon_field
{
  __IO uint32_t TIMINT1    : 1;
  __IO uint32_t TIMINT2    : 1;
  __IO uint32_t QUD0INT0   : 1;
  __IO uint32_t QUD0INT1   : 1;
  __IO uint32_t QUD0INT2   : 1;
  __IO uint32_t QUD0INT3   : 1;
  __IO uint32_t QUD0INT4   : 1;
  __IO uint32_t QUD0INT5   : 1;
  __IO uint32_t QUD1INT0   : 1;
  __IO uint32_t QUD1INT1   : 1;
  __IO uint32_t QUD1INT2   : 1;
  __IO uint32_t QUD1INT3   : 1;
  __IO uint32_t QUD1INT4   : 1;
  __IO uint32_t QUD1INT5   : 1;
  __IO uint32_t QUD2INT0   : 1;
  __IO uint32_t QUD2INT1   : 1;
  __IO uint32_t QUD2INT2   : 1;
  __IO uint32_t QUD2INT3   : 1;
  __IO uint32_t QUD2INT4   : 1;
  __IO uint32_t QUD2INT5   : 1;
} stc_intreq_irq06mon_field_t;

typedef struct stc_intreq_irq07mon_field
{
  __IO uint32_t MFSINT     : 1;
} stc_intreq_irq07mon_field_t;

typedef struct stc_intreq_irq08mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq08mon_field_t;

typedef struct stc_intreq_irq09mon_field
{
  __IO uint32_t MFSINT     : 1;
} stc_intreq_irq09mon_field_t;

typedef struct stc_intreq_irq10mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq10mon_field_t;

typedef struct stc_intreq_irq11mon_field
{
  __IO uint32_t MFSINT     : 1;
} stc_intreq_irq11mon_field_t;

typedef struct stc_intreq_irq12mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq12mon_field_t;

typedef struct stc_intreq_irq13mon_field
{
  __IO uint32_t MFSINT     : 1;
} stc_intreq_irq13mon_field_t;

typedef struct stc_intreq_irq14mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq14mon_field_t;

typedef struct stc_intreq_irq15mon_field
{
  __IO uint32_t MFSINT     : 1;
} stc_intreq_irq15mon_field_t;

typedef struct stc_intreq_irq16mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq16mon_field_t;

typedef struct stc_intreq_irq17mon_field
{
  __IO uint32_t MFSINT     : 1;
} stc_intreq_irq17mon_field_t;

typedef struct stc_intreq_irq18mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq18mon_field_t;

typedef struct stc_intreq_irq19mon_field
{
  __IO uint32_t MFSINT     : 1;
} stc_intreq_irq19mon_field_t;

typedef struct stc_intreq_irq20mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq20mon_field_t;

typedef struct stc_intreq_irq21mon_field
{
  __IO uint32_t MFSINT     : 1;
} stc_intreq_irq21mon_field_t;

typedef struct stc_intreq_irq22mon_field
{
  __IO uint32_t MFSINT0    : 1;
  __IO uint32_t MFSINT1    : 1;
} stc_intreq_irq22mon_field_t;

typedef struct stc_intreq_irq23mon_field
{
  __IO uint32_t PPGINT0    : 1;
  __IO uint32_t PPGINT1    : 1;
  __IO uint32_t PPGINT2    : 1;
  __IO uint32_t PPGINT3    : 1;
  __IO uint32_t PPGINT4    : 1;
  __IO uint32_t PPGINT5    : 1;
  __IO uint32_t PPGINT6    : 1;
  __IO uint32_t PPGINT7    : 1;
  __IO uint32_t PPGINT8    : 1;
} stc_intreq_irq23mon_field_t;

typedef struct stc_intreq_irq24mon_field
{
  __IO uint32_t MOSCINT    : 1;
  __IO uint32_t SOSCINT    : 1;
  __IO uint32_t MPLLINT    : 1;
  __IO uint32_t UPLLINT    : 1;
  __IO uint32_t WCINT      : 1;
} stc_intreq_irq24mon_field_t;

typedef struct stc_intreq_irq25mon_field
{
  __IO uint32_t ADCINT0    : 1;
  __IO uint32_t ADCINT1    : 1;
  __IO uint32_t ADCINT2    : 1;
  __IO uint32_t ADCINT3    : 1;
} stc_intreq_irq25mon_field_t;

typedef struct stc_intreq_irq26mon_field
{
  __IO uint32_t ADCINT0    : 1;
  __IO uint32_t ADCINT1    : 1;
  __IO uint32_t ADCINT2    : 1;
  __IO uint32_t ADCINT3    : 1;
} stc_intreq_irq26mon_field_t;

typedef struct stc_intreq_irq27mon_field
{
  __IO uint32_t ADCINT0    : 1;
  __IO uint32_t ADCINT1    : 1;
  __IO uint32_t ADCINT2    : 1;
  __IO uint32_t ADCINT3    : 1;
} stc_intreq_irq27mon_field_t;

typedef struct stc_intreq_irq28mon_field
{
  __IO uint32_t FRT0INT0   : 1;
  __IO uint32_t FRT0INT1   : 1;
  __IO uint32_t FRT0INT2   : 1;
  __IO uint32_t FRT0INT3   : 1;
  __IO uint32_t FRT0INT4   : 1;
  __IO uint32_t FRT0INT5   : 1;
  __IO uint32_t FRT1INT0   : 1;
  __IO uint32_t FRT1INT1   : 1;
  __IO uint32_t FRT1INT2   : 1;
  __IO uint32_t FRT1INT3   : 1;
  __IO uint32_t FRT1INT4   : 1;
  __IO uint32_t FRT1INT5   : 1;
  __IO uint32_t FRT2INT0   : 1;
  __IO uint32_t FRT2INT1   : 1;
  __IO uint32_t FRT2INT2   : 1;
  __IO uint32_t FRT2INT3   : 1;
  __IO uint32_t FRT2INT4   : 1;
  __IO uint32_t FRT2INT5   : 1;
} stc_intreq_irq28mon_field_t;

typedef struct stc_intreq_irq29mon_field
{
  __IO uint32_t ICU0INT0   : 1;
  __IO uint32_t ICU0INT1   : 1;
  __IO uint32_t ICU0INT2   : 1;
  __IO uint32_t ICU0INT3   : 1;
  __IO uint32_t ICU1INT0   : 1;
  __IO uint32_t ICU1INT1   : 1;
  __IO uint32_t ICU1INT2   : 1;
  __IO uint32_t ICU1INT3   : 1;
  __IO uint32_t ICU2INT0   : 1;
  __IO uint32_t ICU2INT1   : 1;
  __IO uint32_t ICU2INT2   : 1;
  __IO uint32_t ICU2INT3   : 1;
} stc_intreq_irq29mon_field_t;

typedef struct stc_intreq_irq30mon_field
{
  __IO uint32_t OCU0INT0   : 1;
  __IO uint32_t OCU0INT1   : 1;
  __IO uint32_t OCU0INT2   : 1;
  __IO uint32_t OCU0INT3   : 1;
  __IO uint32_t OCU0INT4   : 1;
  __IO uint32_t OCU0INT5   : 1;
  __IO uint32_t OCU1INT0   : 1;
  __IO uint32_t OCU1INT1   : 1;
  __IO uint32_t OCU1INT2   : 1;
  __IO uint32_t OCU1INT3   : 1;
  __IO uint32_t OCU1INT4   : 1;
  __IO uint32_t OCU1INT5   : 1;
  __IO uint32_t OCU2INT0   : 1;
  __IO uint32_t OCU2INT1   : 1;
  __IO uint32_t OCU2INT2   : 1;
  __IO uint32_t OCU2INT3   : 1;
  __IO uint32_t OCU2INT4   : 1;
  __IO uint32_t OCU2INT5   : 1;
} stc_intreq_irq30mon_field_t;

typedef struct stc_intreq_irq31mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
  __IO uint32_t BTINT2     : 1;
  __IO uint32_t BTINT3     : 1;
  __IO uint32_t BTINT4     : 1;
  __IO uint32_t BTINT5     : 1;
  __IO uint32_t BTINT6     : 1;
  __IO uint32_t BTINT7     : 1;
  __IO uint32_t BTINT8     : 1;
  __IO uint32_t BTINT9     : 1;
  __IO uint32_t BTINT10    : 1;
  __IO uint32_t BTINT11    : 1;
  __IO uint32_t BTINT12    : 1;
  __IO uint32_t BTINT13    : 1;
  __IO uint32_t BTINT14    : 1;
  __IO uint32_t BTINT15    : 1;
} stc_intreq_irq31mon_field_t;

typedef struct stc_intreq_irq32mon_field
{
  __IO uint32_t CAN0INT    : 1;
  __IO uint32_t MAC0SBD    : 1;
  __IO uint32_t MAC0PMI    : 1;
  __IO uint32_t MAC0LPI    : 1;
} stc_intreq_irq32mon_field_t;

typedef struct stc_intreq_irq33mon_field
{
  __IO uint32_t CAN1INT    : 1;
  __IO uint32_t MAC1SBD    : 1;
  __IO uint32_t MAC1PMI    : 1;
} stc_intreq_irq33mon_field_t;

typedef struct stc_intreq_irq34mon_field
{
  __IO uint32_t USB0INT0   : 1;
  __IO uint32_t USB0INT1   : 1;
  __IO uint32_t USB0INT2   : 1;
  __IO uint32_t USB0INT3   : 1;
  __IO uint32_t USB0INT4   : 1;
} stc_intreq_irq34mon_field_t;

typedef struct stc_intreq_irq35mon_field
{
  __IO uint32_t USB0INT0   : 1;
  __IO uint32_t USB0INT1   : 1;
  __IO uint32_t USB0INT2   : 1;
  __IO uint32_t USB0INT3   : 1;
  __IO uint32_t USB0INT4   : 1;
  __IO uint32_t USB0INT5   : 1;
} stc_intreq_irq35mon_field_t;

typedef struct stc_intreq_irq36mon_field
{
  __IO uint32_t USB1INT0   : 1;
  __IO uint32_t USB1INT1   : 1;
  __IO uint32_t USB1INT2   : 1;
  __IO uint32_t USB1INT3   : 1;
  __IO uint32_t USB1INT4   : 1;
} stc_intreq_irq36mon_field_t;

typedef struct stc_intreq_irq37mon_field
{
  __IO uint32_t USB1INT0   : 1;
  __IO uint32_t USB1INT1   : 1;
  __IO uint32_t USB1INT2   : 1;
  __IO uint32_t USB1INT3   : 1;
  __IO uint32_t USB1INT4   : 1;
  __IO uint32_t USB1INT5   : 1;
} stc_intreq_irq37mon_field_t;

typedef struct stc_intreq_irq38mon_field
{
  __IO uint32_t DMAINT     : 1;
} stc_intreq_irq38mon_field_t;

typedef struct stc_intreq_irq39mon_field
{
  __IO uint32_t DMAINT     : 1;
} stc_intreq_irq39mon_field_t;

typedef struct stc_intreq_irq40mon_field
{
  __IO uint32_t DMAINT     : 1;
} stc_intreq_irq40mon_field_t;

typedef struct stc_intreq_irq41mon_field
{
  __IO uint32_t DMAINT     : 1;
} stc_intreq_irq41mon_field_t;

typedef struct stc_intreq_irq42mon_field
{
  __IO uint32_t DMAINT     : 1;
} stc_intreq_irq42mon_field_t;

typedef struct stc_intreq_irq43mon_field
{
  __IO uint32_t DMAINT     : 1;
} stc_intreq_irq43mon_field_t;

typedef struct stc_intreq_irq44mon_field
{
  __IO uint32_t DMAINT     : 1;
} stc_intreq_irq44mon_field_t;

typedef struct stc_intreq_irq45mon_field
{
  __IO uint32_t DMAINT     : 1;
} stc_intreq_irq45mon_field_t;

typedef struct stc_intreq_irq46mon_field
{
  __IO uint32_t BTINT0     : 1;
  __IO uint32_t BTINT1     : 1;
  __IO uint32_t BTINT2     : 1;
  __IO uint32_t BTINT3     : 1;
  __IO uint32_t BTINT4     : 1;
  __IO uint32_t BTINT5     : 1;
  __IO uint32_t BTINT6     : 1;
  __IO uint32_t BTINT7     : 1;
  __IO uint32_t BTINT8     : 1;
  __IO uint32_t BTINT9     : 1;
  __IO uint32_t BTINT10    : 1;
  __IO uint32_t BTINT11    : 1;
  __IO uint32_t BTINT12    : 1;
  __IO uint32_t BTINT13    : 1;
  __IO uint32_t BTINT14    : 1;
  __IO uint32_t BTINT15    : 1;
} stc_intreq_irq46mon_field_t;

typedef struct stc_intreq_drqsel1_field
{
  __IO uint32_t DRQSEL10   : 1;
  __IO uint32_t DRQSEL11   : 1;
  __IO uint32_t DRQSEL12   : 1;
  __IO uint32_t DRQSEL13   : 1;
  __IO uint32_t DRQSEL14   : 1;
} stc_intreq_drqsel1_field_t;

typedef struct stc_intreq_dqesel_field
{
  __IO uint32_t ESEL100    : 1;
  __IO uint32_t ESEL101    : 1;
  __IO uint32_t ESEL102    : 1;
  __IO uint32_t ESEL103    : 1;
  __IO uint32_t ESEL110    : 1;
  __IO uint32_t ESEL111    : 1;
  __IO uint32_t ESEL112    : 1;
  __IO uint32_t ESEL113    : 1;
  __IO uint32_t ESEL240    : 1;
  __IO uint32_t ESEL241    : 1;
  __IO uint32_t ESEL242    : 1;
  __IO uint32_t ESEL243    : 1;
  __IO uint32_t ESEL250    : 1;
  __IO uint32_t ESEL251    : 1;
  __IO uint32_t ESEL252    : 1;
  __IO uint32_t ESEL253    : 1;
  __IO uint32_t ESEL260    : 1;
  __IO uint32_t ESEL261    : 1;
  __IO uint32_t ESEL262    : 1;
  __IO uint32_t ESEL263    : 1;
  __IO uint32_t ESEL270    : 1;
  __IO uint32_t ESEL271    : 1;
  __IO uint32_t ESEL272    : 1;
  __IO uint32_t ESEL273    : 1;
  __IO uint32_t ESEL300    : 1;
  __IO uint32_t ESEL301    : 1;
  __IO uint32_t ESEL302    : 1;
  __IO uint32_t ESEL303    : 1;
  __IO uint32_t ESEL310    : 1;
  __IO uint32_t ESEL311    : 1;
  __IO uint32_t ESEL312    : 1;
  __IO uint32_t ESEL313    : 1;
} stc_intreq_dqesel_field_t;

typedef struct stc_intreq_oddpks1_field
{
  __IO  uint8_t ODDPKS10   : 1;
  __IO  uint8_t ODDPKS11   : 1;
  __IO  uint8_t ODDPKS12   : 1;
  __IO  uint8_t ODDPKS13   : 1;
  __IO  uint8_t ODDPKS14   : 1;
} stc_intreq_oddpks1_field_t;

/******************************************************************************
 * GPIO_MODULE
 ******************************************************************************/
/* GPIO_MODULE register bit fields */
typedef struct stc_gpio_pfr0_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
} stc_gpio_pfr0_field_t;

typedef struct stc_gpio_pfr1_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pfr1_field_t;

typedef struct stc_gpio_pfr2_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
} stc_gpio_pfr2_field_t;

typedef struct stc_gpio_pfr3_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pfr3_field_t;

typedef struct stc_gpio_pfr4_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
} stc_gpio_pfr4_field_t;

typedef struct stc_gpio_pfr5_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
} stc_gpio_pfr5_field_t;

typedef struct stc_gpio_pfr6_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
} stc_gpio_pfr6_field_t;

typedef struct stc_gpio_pfr7_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pfr7_field_t;

typedef struct stc_gpio_pfr8_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_pfr8_field_t;

typedef struct stc_gpio_pfr9_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
} stc_gpio_pfr9_field_t;

typedef struct stc_gpio_pfra_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
} stc_gpio_pfra_field_t;

typedef struct stc_gpio_pfrb_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
} stc_gpio_pfrb_field_t;

typedef struct stc_gpio_pfrc_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pfrc_field_t;

typedef struct stc_gpio_pfrd_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_pfrd_field_t;

typedef struct stc_gpio_pfre_field
{
  __IO uint32_t P0         : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_pfre_field_t;

typedef struct stc_gpio_pfrf_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
} stc_gpio_pfrf_field_t;

typedef struct stc_gpio_pcr0_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
} stc_gpio_pcr0_field_t;

typedef struct stc_gpio_pcr1_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pcr1_field_t;

typedef struct stc_gpio_pcr2_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
} stc_gpio_pcr2_field_t;

typedef struct stc_gpio_pcr3_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pcr3_field_t;

typedef struct stc_gpio_pcr4_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
} stc_gpio_pcr4_field_t;

typedef struct stc_gpio_pcr5_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
} stc_gpio_pcr5_field_t;

typedef struct stc_gpio_pcr6_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
} stc_gpio_pcr6_field_t;

typedef struct stc_gpio_pcr7_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pcr7_field_t;

typedef struct stc_gpio_pcr9_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
} stc_gpio_pcr9_field_t;

typedef struct stc_gpio_pcra_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
} stc_gpio_pcra_field_t;

typedef struct stc_gpio_pcrb_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
} stc_gpio_pcrb_field_t;

typedef struct stc_gpio_pcrc_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pcrc_field_t;

typedef struct stc_gpio_pcrd_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_pcrd_field_t;

typedef struct stc_gpio_pcre_field
{
       uint32_t RESERVED1  : 2;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_pcre_field_t;

typedef struct stc_gpio_ddr0_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
} stc_gpio_ddr0_field_t;

typedef struct stc_gpio_ddr1_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_ddr1_field_t;

typedef struct stc_gpio_ddr2_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
} stc_gpio_ddr2_field_t;

typedef struct stc_gpio_ddr3_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_ddr3_field_t;

typedef struct stc_gpio_ddr4_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
} stc_gpio_ddr4_field_t;

typedef struct stc_gpio_ddr5_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
} stc_gpio_ddr5_field_t;

typedef struct stc_gpio_ddr6_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
} stc_gpio_ddr6_field_t;

typedef struct stc_gpio_ddr7_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_ddr7_field_t;

typedef struct stc_gpio_ddr8_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_ddr8_field_t;

typedef struct stc_gpio_ddr9_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
} stc_gpio_ddr9_field_t;

typedef struct stc_gpio_ddra_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
} stc_gpio_ddra_field_t;

typedef struct stc_gpio_ddrb_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
} stc_gpio_ddrb_field_t;

typedef struct stc_gpio_ddrc_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_ddrc_field_t;

typedef struct stc_gpio_ddrd_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_ddrd_field_t;

typedef struct stc_gpio_ddre_field
{
  __IO uint32_t P0         : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_ddre_field_t;

typedef struct stc_gpio_ddrf_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
} stc_gpio_ddrf_field_t;

typedef struct stc_gpio_pdir0_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
} stc_gpio_pdir0_field_t;

typedef struct stc_gpio_pdir1_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pdir1_field_t;

typedef struct stc_gpio_pdir2_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
} stc_gpio_pdir2_field_t;

typedef struct stc_gpio_pdir3_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pdir3_field_t;

typedef struct stc_gpio_pdir4_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
} stc_gpio_pdir4_field_t;

typedef struct stc_gpio_pdir5_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
} stc_gpio_pdir5_field_t;

typedef struct stc_gpio_pdir6_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
} stc_gpio_pdir6_field_t;

typedef struct stc_gpio_pdir7_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pdir7_field_t;

typedef struct stc_gpio_pdir8_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_pdir8_field_t;

typedef struct stc_gpio_pdir9_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
} stc_gpio_pdir9_field_t;

typedef struct stc_gpio_pdira_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
} stc_gpio_pdira_field_t;

typedef struct stc_gpio_pdirb_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
} stc_gpio_pdirb_field_t;

typedef struct stc_gpio_pdirc_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pdirc_field_t;

typedef struct stc_gpio_pdird_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_pdird_field_t;

typedef struct stc_gpio_pdire_field
{
  __IO uint32_t P0         : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_pdire_field_t;

typedef struct stc_gpio_pdirf_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
} stc_gpio_pdirf_field_t;

typedef struct stc_gpio_pdor0_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
} stc_gpio_pdor0_field_t;

typedef struct stc_gpio_pdor1_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pdor1_field_t;

typedef struct stc_gpio_pdor2_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
} stc_gpio_pdor2_field_t;

typedef struct stc_gpio_pdor3_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pdor3_field_t;

typedef struct stc_gpio_pdor4_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
} stc_gpio_pdor4_field_t;

typedef struct stc_gpio_pdor5_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
} stc_gpio_pdor5_field_t;

typedef struct stc_gpio_pdor6_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
} stc_gpio_pdor6_field_t;

typedef struct stc_gpio_pdor7_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pdor7_field_t;

typedef struct stc_gpio_pdor8_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_pdor8_field_t;

typedef struct stc_gpio_pdor9_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
} stc_gpio_pdor9_field_t;

typedef struct stc_gpio_pdora_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
} stc_gpio_pdora_field_t;

typedef struct stc_gpio_pdorb_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
} stc_gpio_pdorb_field_t;

typedef struct stc_gpio_pdorc_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pdorc_field_t;

typedef struct stc_gpio_pdord_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_pdord_field_t;

typedef struct stc_gpio_pdore_field
{
  __IO uint32_t P0         : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_pdore_field_t;

typedef struct stc_gpio_pdorf_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
} stc_gpio_pdorf_field_t;

typedef struct stc_gpio_ade_field
{
  __IO uint32_t AN0        : 1;
  __IO uint32_t AN1        : 1;
  __IO uint32_t AN2        : 1;
  __IO uint32_t AN3        : 1;
  __IO uint32_t AN4        : 1;
  __IO uint32_t AN5        : 1;
  __IO uint32_t AN6        : 1;
  __IO uint32_t AN7        : 1;
  __IO uint32_t AN8        : 1;
  __IO uint32_t AN9        : 1;
  __IO uint32_t AN10       : 1;
  __IO uint32_t AN11       : 1;
  __IO uint32_t AN12       : 1;
  __IO uint32_t AN13       : 1;
  __IO uint32_t AN14       : 1;
  __IO uint32_t AN15       : 1;
  __IO uint32_t AN16       : 1;
  __IO uint32_t AN17       : 1;
  __IO uint32_t AN18       : 1;
  __IO uint32_t AN19       : 1;
  __IO uint32_t AN20       : 1;
  __IO uint32_t AN21       : 1;
  __IO uint32_t AN22       : 1;
  __IO uint32_t AN23       : 1;
  __IO uint32_t AN24       : 1;
  __IO uint32_t AN25       : 1;
  __IO uint32_t AN26       : 1;
  __IO uint32_t AN27       : 1;
  __IO uint32_t AN28       : 1;
  __IO uint32_t AN29       : 1;
  __IO uint32_t AN30       : 1;
  __IO uint32_t AN31       : 1;
} stc_gpio_ade_field_t;

typedef struct stc_gpio_spsr_field
{
  __IO uint32_t SUBXC      : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t MAINXC     : 1;
       uint32_t RESERVED2  : 1;
  __IO uint32_t USB0C      : 1;
  __IO uint32_t USB1C      : 1;
} stc_gpio_spsr_field_t;

typedef struct stc_gpio_epfr00_field
{
  __IO uint32_t NMIS       : 1;
  __IO uint32_t CROUTE0    : 1;
  __IO uint32_t CROUTE1    : 1;
       uint32_t RESERVED1  : 3;
  __IO uint32_t SUBOUTE0   : 1;
  __IO uint32_t SUBOUTE1   : 1;
       uint32_t RESERVED2  : 1;
  __IO uint32_t USBP0E     : 1;
       uint32_t RESERVED3  : 3;
  __IO uint32_t USBP1E     : 1;
       uint32_t RESERVED4  : 2;
  __IO uint32_t JTAGEN0B   : 1;
  __IO uint32_t JTAGEN1S   : 1;
       uint32_t RESERVED5  : 6;
  __IO uint32_t TRC0E      : 1;
  __IO uint32_t TRC1E      : 1;
} stc_gpio_epfr00_field_t;

typedef struct stc_gpio_epfr01_field
{
  __IO uint32_t RTO00E0    : 1;
  __IO uint32_t RTO00E1    : 1;
  __IO uint32_t RTO01E0    : 1;
  __IO uint32_t RTO01E1    : 1;
  __IO uint32_t RTO02E0    : 1;
  __IO uint32_t RTO02E1    : 1;
  __IO uint32_t RTO03E0    : 1;
  __IO uint32_t RTO03E1    : 1;
  __IO uint32_t RTO04E0    : 1;
  __IO uint32_t RTO04E1    : 1;
  __IO uint32_t RTO05E0    : 1;
  __IO uint32_t RTO05E1    : 1;
  __IO uint32_t DTTI0C     : 1;
       uint32_t RESERVED1  : 3;
  __IO uint32_t DTTI0S0    : 1;
  __IO uint32_t DTTI0S1    : 1;
  __IO uint32_t FRCK0S0    : 1;
  __IO uint32_t FRCK0S1    : 1;
  __IO uint32_t IC00S0     : 1;
  __IO uint32_t IC00S1     : 1;
  __IO uint32_t IC00S2     : 1;
  __IO uint32_t IC01S0     : 1;
  __IO uint32_t IC01S1     : 1;
  __IO uint32_t IC01S2     : 1;
  __IO uint32_t IC02S0     : 1;
  __IO uint32_t IC02S1     : 1;
  __IO uint32_t IC02S2     : 1;
  __IO uint32_t IC03S0     : 1;
  __IO uint32_t IC03S1     : 1;
  __IO uint32_t IC03S2     : 1;
} stc_gpio_epfr01_field_t;

typedef struct stc_gpio_epfr02_field
{
  __IO uint32_t RTO10E0    : 1;
  __IO uint32_t RTO10E1    : 1;
  __IO uint32_t RTO11E0    : 1;
  __IO uint32_t RTO11E1    : 1;
  __IO uint32_t RTO12E0    : 1;
  __IO uint32_t RTO12E1    : 1;
  __IO uint32_t RTO13E0    : 1;
  __IO uint32_t RTO13E1    : 1;
  __IO uint32_t RTO14E0    : 1;
  __IO uint32_t RTO14E1    : 1;
  __IO uint32_t RTO15E0    : 1;
  __IO uint32_t RTO15E1    : 1;
  __IO uint32_t DTTI1C     : 1;
       uint32_t RESERVED1  : 3;
  __IO uint32_t DTTI1S0    : 1;
  __IO uint32_t DTTI1S1    : 1;
  __IO uint32_t FRCK1S0    : 1;
  __IO uint32_t FRCK1S1    : 1;
  __IO uint32_t IC10S0     : 1;
  __IO uint32_t IC10S1     : 1;
  __IO uint32_t IC10S2     : 1;
  __IO uint32_t IC11S0     : 1;
  __IO uint32_t IC11S1     : 1;
  __IO uint32_t IC11S2     : 1;
  __IO uint32_t IC12S0     : 1;
  __IO uint32_t IC12S1     : 1;
  __IO uint32_t IC12S2     : 1;
  __IO uint32_t IC13S0     : 1;
  __IO uint32_t IC13S1     : 1;
  __IO uint32_t IC13S2     : 1;
} stc_gpio_epfr02_field_t;

typedef struct stc_gpio_epfr03_field
{
  __IO uint32_t RTO20E0    : 1;
  __IO uint32_t RTO20E1    : 1;
  __IO uint32_t RTO21E0    : 1;
  __IO uint32_t RTO21E1    : 1;
  __IO uint32_t RTO22E0    : 1;
  __IO uint32_t RTO22E1    : 1;
  __IO uint32_t RTO23E0    : 1;
  __IO uint32_t RTO23E1    : 1;
  __IO uint32_t RTO24E0    : 1;
  __IO uint32_t RTO24E1    : 1;
  __IO uint32_t RTO25E0    : 1;
  __IO uint32_t RTO25E1    : 1;
  __IO uint32_t DTTI2C     : 1;
       uint32_t RESERVED1  : 3;
  __IO uint32_t DTTI2S0    : 1;
  __IO uint32_t DTTI2S1    : 1;
  __IO uint32_t FRCK2S0    : 1;
  __IO uint32_t FRCK2S1    : 1;
  __IO uint32_t IC20S0     : 1;
  __IO uint32_t IC20S1     : 1;
  __IO uint32_t IC20S2     : 1;
  __IO uint32_t IC21S0     : 1;
  __IO uint32_t IC21S1     : 1;
  __IO uint32_t IC21S2     : 1;
  __IO uint32_t IC22S0     : 1;
  __IO uint32_t IC22S1     : 1;
  __IO uint32_t IC22S2     : 1;
  __IO uint32_t IC23S0     : 1;
  __IO uint32_t IC23S1     : 1;
  __IO uint32_t IC23S2     : 1;
} stc_gpio_epfr03_field_t;

typedef struct stc_gpio_epfr04_field
{
       uint32_t RESERVED1  : 2;
  __IO uint32_t TIOA0E0    : 1;
  __IO uint32_t TIOA0E1    : 1;
  __IO uint32_t TIOB0S0    : 1;
  __IO uint32_t TIOB0S1    : 1;
       uint32_t RESERVED2  : 2;
  __IO uint32_t TIOA1S0    : 1;
  __IO uint32_t TIOA1S1    : 1;
  __IO uint32_t TIOA1E0    : 1;
  __IO uint32_t TIOA1E1    : 1;
  __IO uint32_t TIOB1S0    : 1;
  __IO uint32_t TIOB1S1    : 1;
       uint32_t RESERVED3  : 4;
  __IO uint32_t TIOA2E0    : 1;
  __IO uint32_t TIOA2E1    : 1;
  __IO uint32_t TIOB2S0    : 1;
  __IO uint32_t TIOB2S1    : 1;
       uint32_t RESERVED4  : 2;
  __IO uint32_t TIOA3S0    : 1;
  __IO uint32_t TIOA3S1    : 1;
  __IO uint32_t TIOA3E0    : 1;
  __IO uint32_t TIOA3E1    : 1;
  __IO uint32_t TIOB3S0    : 1;
  __IO uint32_t TIOB3S1    : 1;
} stc_gpio_epfr04_field_t;

typedef struct stc_gpio_epfr05_field
{
       uint32_t RESERVED1  : 2;
  __IO uint32_t TIOA4E0    : 1;
  __IO uint32_t TIOA4E1    : 1;
  __IO uint32_t TIOB4S0    : 1;
  __IO uint32_t TIOB4S1    : 1;
       uint32_t RESERVED2  : 2;
  __IO uint32_t TIOA5S0    : 1;
  __IO uint32_t TIOA5S1    : 1;
  __IO uint32_t TIOA5E0    : 1;
  __IO uint32_t TIOA5E1    : 1;
  __IO uint32_t TIOB5S0    : 1;
  __IO uint32_t TIOB5S1    : 1;
       uint32_t RESERVED3  : 4;
  __IO uint32_t TIOA6E0    : 1;
  __IO uint32_t TIOA6E1    : 1;
  __IO uint32_t TIOB6S0    : 1;
  __IO uint32_t TIOB6S1    : 1;
       uint32_t RESERVED4  : 2;
  __IO uint32_t TIOA7S0    : 1;
  __IO uint32_t TIOA7S1    : 1;
  __IO uint32_t TIOA7E0    : 1;
  __IO uint32_t TIOA7E1    : 1;
  __IO uint32_t TIOB7S0    : 1;
  __IO uint32_t TIOB7S1    : 1;
} stc_gpio_epfr05_field_t;

typedef struct stc_gpio_epfr06_field
{
  __IO uint32_t EINT00S0   : 1;
  __IO uint32_t EINT00S1   : 1;
  __IO uint32_t EINT01S0   : 1;
  __IO uint32_t EINT01S1   : 1;
  __IO uint32_t EINT02S0   : 1;
  __IO uint32_t EINT02S1   : 1;
  __IO uint32_t EINT03S0   : 1;
  __IO uint32_t EINT03S1   : 1;
  __IO uint32_t EINT04S0   : 1;
  __IO uint32_t EINT04S1   : 1;
  __IO uint32_t EINT05S0   : 1;
  __IO uint32_t EINT05S1   : 1;
  __IO uint32_t EINT06S0   : 1;
  __IO uint32_t EINT06S1   : 1;
  __IO uint32_t EINT07S0   : 1;
  __IO uint32_t EINT07S1   : 1;
  __IO uint32_t EINT08S0   : 1;
  __IO uint32_t EINT08S1   : 1;
  __IO uint32_t EINT09S0   : 1;
  __IO uint32_t EINT09S1   : 1;
  __IO uint32_t EINT10S0   : 1;
  __IO uint32_t EINT10S1   : 1;
  __IO uint32_t EINT11S0   : 1;
  __IO uint32_t EINT11S1   : 1;
  __IO uint32_t EINT12S0   : 1;
  __IO uint32_t EINT12S1   : 1;
  __IO uint32_t EINT13S0   : 1;
  __IO uint32_t EINT13S1   : 1;
  __IO uint32_t EINT14S0   : 1;
  __IO uint32_t EINT14S1   : 1;
  __IO uint32_t EINT15S0   : 1;
  __IO uint32_t EINT15S1   : 1;
} stc_gpio_epfr06_field_t;

typedef struct stc_gpio_epfr07_field
{
       uint32_t RESERVED1  : 4;
  __IO uint32_t SIN0S0     : 1;
  __IO uint32_t SIN0S1     : 1;
  __IO uint32_t SOT0B0     : 1;
  __IO uint32_t SOT0B1     : 1;
  __IO uint32_t SCK0B0     : 1;
  __IO uint32_t SCK0B1     : 1;
  __IO uint32_t SIN1S0     : 1;
  __IO uint32_t SIN1S1     : 1;
  __IO uint32_t SOT1B0     : 1;
  __IO uint32_t SOT1B1     : 1;
  __IO uint32_t SCK1B0     : 1;
  __IO uint32_t SCK1B1     : 1;
  __IO uint32_t SIN2S0     : 1;
  __IO uint32_t SIN2S1     : 1;
  __IO uint32_t SOT2B0     : 1;
  __IO uint32_t SOT2B1     : 1;
  __IO uint32_t SCK2B0     : 1;
  __IO uint32_t SCK2B1     : 1;
  __IO uint32_t SIN3S0     : 1;
  __IO uint32_t SIN3S1     : 1;
  __IO uint32_t SOT3B0     : 1;
  __IO uint32_t SOT3B1     : 1;
  __IO uint32_t SCK3B0     : 1;
  __IO uint32_t SCK3B1     : 1;
} stc_gpio_epfr07_field_t;

typedef struct stc_gpio_epfr08_field
{
  __IO uint32_t RTS4E0     : 1;
  __IO uint32_t RTS4E1     : 1;
  __IO uint32_t CTS4S0     : 1;
  __IO uint32_t CTS4S1     : 1;
  __IO uint32_t SIN4S0     : 1;
  __IO uint32_t SIN4S1     : 1;
  __IO uint32_t SOT4B0     : 1;
  __IO uint32_t SOT4B1     : 1;
  __IO uint32_t SCK4B0     : 1;
  __IO uint32_t SCK4B1     : 1;
  __IO uint32_t SIN5S0     : 1;
  __IO uint32_t SIN5S1     : 1;
  __IO uint32_t SOT5B0     : 1;
  __IO uint32_t SOT5B1     : 1;
  __IO uint32_t SCK5B0     : 1;
  __IO uint32_t SCK5B1     : 1;
  __IO uint32_t SIN6S0     : 1;
  __IO uint32_t SIN6S1     : 1;
  __IO uint32_t SOT6B0     : 1;
  __IO uint32_t SOT6B1     : 1;
  __IO uint32_t SCK6B0     : 1;
  __IO uint32_t SCK6B1     : 1;
  __IO uint32_t SIN7S0     : 1;
  __IO uint32_t SIN7S1     : 1;
  __IO uint32_t SOT7B0     : 1;
  __IO uint32_t SOT7B1     : 1;
  __IO uint32_t SCK7B0     : 1;
  __IO uint32_t SCK7B1     : 1;
} stc_gpio_epfr08_field_t;

typedef struct stc_gpio_epfr09_field
{
  __IO uint32_t QAIN0S0    : 1;
  __IO uint32_t QAIN0S1    : 1;
  __IO uint32_t QBIN0S0    : 1;
  __IO uint32_t QBIN0S1    : 1;
  __IO uint32_t QZIN0S0    : 1;
  __IO uint32_t QZIN0S1    : 1;
  __IO uint32_t QAIN1S0    : 1;
  __IO uint32_t QAIN1S1    : 1;
  __IO uint32_t QBIN1S0    : 1;
  __IO uint32_t QBIN1S1    : 1;
  __IO uint32_t QZIN1S0    : 1;
  __IO uint32_t QZIN1S1    : 1;
  __IO uint32_t ADTRG0S0   : 1;
  __IO uint32_t ADTRG0S1   : 1;
  __IO uint32_t ADTRG0S2   : 1;
  __IO uint32_t ADTRG0S3   : 1;
  __IO uint32_t ADTRG1S0   : 1;
  __IO uint32_t ADTRG1S1   : 1;
  __IO uint32_t ADTRG1S2   : 1;
  __IO uint32_t ADTRG1S3   : 1;
  __IO uint32_t ADTRG2S0   : 1;
  __IO uint32_t ADTRG2S1   : 1;
  __IO uint32_t ADTRG2S2   : 1;
  __IO uint32_t ADTRG2S3   : 1;
  __IO uint32_t CRX0S0     : 1;
  __IO uint32_t CRX0S1     : 1;
  __IO uint32_t CTX0E0     : 1;
  __IO uint32_t CTX0E1     : 1;
  __IO uint32_t CRX1S0     : 1;
  __IO uint32_t CRX1S1     : 1;
  __IO uint32_t CTX1E0     : 1;
  __IO uint32_t CTX1E1     : 1;
} stc_gpio_epfr09_field_t;

typedef struct stc_gpio_epfr10_field
{
  __IO uint32_t UEDEFB     : 1;
  __IO uint32_t UEDTHB     : 1;
  __IO uint32_t UECLKE     : 1;
  __IO uint32_t UEWEXE     : 1;
  __IO uint32_t UEDQME     : 1;
  __IO uint32_t UEOEXE     : 1;
  __IO uint32_t UEFLSE     : 1;
  __IO uint32_t UECS1E     : 1;
  __IO uint32_t UECS2E     : 1;
  __IO uint32_t UECS3E     : 1;
  __IO uint32_t UECS4E     : 1;
  __IO uint32_t UECS5E     : 1;
  __IO uint32_t UECS6E     : 1;
  __IO uint32_t UECS7E     : 1;
  __IO uint32_t UEAOOE     : 1;
  __IO uint32_t UEA08E     : 1;
  __IO uint32_t UEA09E     : 1;
  __IO uint32_t UEA10E     : 1;
  __IO uint32_t UEA11E     : 1;
  __IO uint32_t UEA12E     : 1;
  __IO uint32_t UEA13E     : 1;
  __IO uint32_t UEA14E     : 1;
  __IO uint32_t UEA15E     : 1;
  __IO uint32_t UEA16E     : 1;
  __IO uint32_t UEA17E     : 1;
  __IO uint32_t UEA18E     : 1;
  __IO uint32_t UEA19E     : 1;
  __IO uint32_t UEA20E     : 1;
  __IO uint32_t UEA21E     : 1;
  __IO uint32_t UEA22E     : 1;
  __IO uint32_t UEA23E     : 1;
  __IO uint32_t UEA24E     : 1;
} stc_gpio_epfr10_field_t;

typedef struct stc_gpio_epfr11_field
{
  __IO uint32_t UEALEE     : 1;
  __IO uint32_t UECS0E     : 1;
  __IO uint32_t UEA01E     : 1;
  __IO uint32_t UEA02E     : 1;
  __IO uint32_t UEA03E     : 1;
  __IO uint32_t UEA04E     : 1;
  __IO uint32_t UEA05E     : 1;
  __IO uint32_t UEA06E     : 1;
  __IO uint32_t UEA07E     : 1;
  __IO uint32_t UED00B     : 1;
  __IO uint32_t UED01B     : 1;
  __IO uint32_t UED02B     : 1;
  __IO uint32_t UED03B     : 1;
  __IO uint32_t UED04B     : 1;
  __IO uint32_t UED05B     : 1;
  __IO uint32_t UED06B     : 1;
  __IO uint32_t UED07B     : 1;
  __IO uint32_t UED08B     : 1;
  __IO uint32_t UED09B     : 1;
  __IO uint32_t UED10B     : 1;
  __IO uint32_t UED11B     : 1;
  __IO uint32_t UED12B     : 1;
  __IO uint32_t UED13B     : 1;
  __IO uint32_t UED14B     : 1;
  __IO uint32_t UED15B     : 1;
  __IO uint32_t UERLC      : 1;
} stc_gpio_epfr11_field_t;

typedef struct stc_gpio_epfr12_field
{
       uint32_t RESERVED1  : 2;
  __IO uint32_t TIOA8E0    : 1;
  __IO uint32_t TIOA8E1    : 1;
  __IO uint32_t TIOB8S0    : 1;
  __IO uint32_t TIOB8S1    : 1;
       uint32_t RESERVED2  : 2;
  __IO uint32_t TIOA9S0    : 1;
  __IO uint32_t TIOA9S1    : 1;
  __IO uint32_t TIOA9E0    : 1;
  __IO uint32_t TIOA9E1    : 1;
  __IO uint32_t TIOB9S0    : 1;
  __IO uint32_t TIOB9S1    : 1;
       uint32_t RESERVED3  : 4;
  __IO uint32_t TIOA10E0   : 1;
  __IO uint32_t TIOA10E1   : 1;
  __IO uint32_t TIOB10S0   : 1;
  __IO uint32_t TIOB10S1   : 1;
       uint32_t RESERVED4  : 2;
  __IO uint32_t TIOA11S0   : 1;
  __IO uint32_t TIOA11S1   : 1;
  __IO uint32_t TIOA11E0   : 1;
  __IO uint32_t TIOA11E1   : 1;
  __IO uint32_t TIOB11S0   : 1;
  __IO uint32_t TIOB11S1   : 1;
} stc_gpio_epfr12_field_t;

typedef struct stc_gpio_epfr13_field
{
       uint32_t RESERVED1  : 2;
  __IO uint32_t TIOA12E0   : 1;
  __IO uint32_t TIOA12E1   : 1;
  __IO uint32_t TIOB12S0   : 1;
  __IO uint32_t TIOB12S1   : 1;
       uint32_t RESERVED2  : 2;
  __IO uint32_t TIOA13S0   : 1;
  __IO uint32_t TIOA13S1   : 1;
  __IO uint32_t TIOA13E0   : 1;
  __IO uint32_t TIOA13E1   : 1;
  __IO uint32_t TIOB13S0   : 1;
  __IO uint32_t TIOB13S1   : 1;
       uint32_t RESERVED3  : 4;
  __IO uint32_t TIOA14E0   : 1;
  __IO uint32_t TIOA14E1   : 1;
  __IO uint32_t TIOB14S0   : 1;
  __IO uint32_t TIOB14S1   : 1;
       uint32_t RESERVED4  : 2;
  __IO uint32_t TIOA15S0   : 1;
  __IO uint32_t TIOA15S1   : 1;
  __IO uint32_t TIOA15E0   : 1;
  __IO uint32_t TIOA15E1   : 1;
  __IO uint32_t TIOB15S0   : 1;
  __IO uint32_t TIOB15S1   : 1;
} stc_gpio_epfr13_field_t;

typedef struct stc_gpio_epfr14_field
{
  __IO uint32_t QAIN2S0    : 1;
  __IO uint32_t QAIN2S1    : 1;
  __IO uint32_t QBIN2S0    : 1;
  __IO uint32_t QBIN2S1    : 1;
  __IO uint32_t QZIN2S0    : 1;
  __IO uint32_t QZIN2S1    : 1;
       uint32_t RESERVED1  : 12;
  __IO uint32_t E_TD0E     : 1;
  __IO uint32_t E_TD1E     : 1;
  __IO uint32_t E_TE0E     : 1;
  __IO uint32_t E_TE1E     : 1;
  __IO uint32_t E_MC0E     : 1;
  __IO uint32_t E_MC1B     : 1;
  __IO uint32_t E_MD0B     : 1;
  __IO uint32_t E_MD1B     : 1;
  __IO uint32_t E_CKE      : 1;
  __IO uint32_t E_PSE      : 1;
  __IO uint32_t E_SPLC0    : 1;
  __IO uint32_t E_SPLC1    : 1;
} stc_gpio_epfr14_field_t;

typedef struct stc_gpio_epfr15_field
{
  __IO uint32_t EINT16S0   : 1;
  __IO uint32_t EINT16S1   : 1;
  __IO uint32_t EINT17S0   : 1;
  __IO uint32_t EINT17S1   : 1;
  __IO uint32_t EINT18S0   : 1;
  __IO uint32_t EINT18S1   : 1;
  __IO uint32_t EINT19S0   : 1;
  __IO uint32_t EINT19S1   : 1;
  __IO uint32_t EINT20S0   : 1;
  __IO uint32_t EINT20S1   : 1;
  __IO uint32_t EINT21S0   : 1;
  __IO uint32_t EINT21S1   : 1;
  __IO uint32_t EINT22S0   : 1;
  __IO uint32_t EINT22S1   : 1;
  __IO uint32_t EINT23S0   : 1;
  __IO uint32_t EINT23S1   : 1;
  __IO uint32_t EINT24S0   : 1;
  __IO uint32_t EINT24S1   : 1;
  __IO uint32_t EINT25S0   : 1;
  __IO uint32_t EINT25S1   : 1;
  __IO uint32_t EINT26S0   : 1;
  __IO uint32_t EINT26S1   : 1;
  __IO uint32_t EINT27S0   : 1;
  __IO uint32_t EINT27S1   : 1;
  __IO uint32_t EINT28S0   : 1;
  __IO uint32_t EINT28S1   : 1;
  __IO uint32_t EINT29S0   : 1;
  __IO uint32_t EINT29S1   : 1;
  __IO uint32_t EINT30S0   : 1;
  __IO uint32_t EINT30S1   : 1;
  __IO uint32_t EINT31S0   : 1;
  __IO uint32_t EINT31S1   : 1;
} stc_gpio_epfr15_field_t;

typedef struct stc_gpio_pzr0_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
} stc_gpio_pzr0_field_t;

typedef struct stc_gpio_pzr1_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pzr1_field_t;

typedef struct stc_gpio_pzr2_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
} stc_gpio_pzr2_field_t;

typedef struct stc_gpio_pzr3_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pzr3_field_t;

typedef struct stc_gpio_pzr4_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
} stc_gpio_pzr4_field_t;

typedef struct stc_gpio_pzr5_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
} stc_gpio_pzr5_field_t;

typedef struct stc_gpio_pzr6_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
} stc_gpio_pzr6_field_t;

typedef struct stc_gpio_pzr7_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pzr7_field_t;

typedef struct stc_gpio_pzr8_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_pzr8_field_t;

typedef struct stc_gpio_pzr9_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
} stc_gpio_pzr9_field_t;

typedef struct stc_gpio_pzra_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
} stc_gpio_pzra_field_t;

typedef struct stc_gpio_pzrb_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
} stc_gpio_pzrb_field_t;

typedef struct stc_gpio_pzrc_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
  __IO uint32_t P7         : 1;
  __IO uint32_t P8         : 1;
  __IO uint32_t P9         : 1;
  __IO uint32_t PA         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t PC         : 1;
  __IO uint32_t PD         : 1;
  __IO uint32_t PE         : 1;
  __IO uint32_t PF         : 1;
} stc_gpio_pzrc_field_t;

typedef struct stc_gpio_pzrd_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_pzrd_field_t;

typedef struct stc_gpio_pzre_field
{
  __IO uint32_t P0         : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
} stc_gpio_pzre_field_t;

typedef struct stc_gpio_pzrf_field
{
  __IO uint32_t P0         : 1;
  __IO uint32_t P1         : 1;
  __IO uint32_t P2         : 1;
  __IO uint32_t P3         : 1;
  __IO uint32_t P4         : 1;
  __IO uint32_t P5         : 1;
  __IO uint32_t P6         : 1;
} stc_gpio_pzrf_field_t;

/******************************************************************************
 * LVD_MODULE
 ******************************************************************************/
/* LVD_MODULE register bit fields */
typedef struct stc_lvd_lvd_ctl_field
{
        uint8_t RESERVED1  : 2;
  __IO  uint8_t SVHI0      : 1;
  __IO  uint8_t SVHI1      : 1;
  __IO  uint8_t SVHI2      : 1;
  __IO  uint8_t SVHI3      : 1;
        uint8_t RESERVED2  : 1;
  __IO  uint8_t LVDIE      : 1;
} stc_lvd_lvd_ctl_field_t;

typedef struct stc_lvd_lvd_str_field
{
        uint8_t RESERVED1  : 7;
  __IO  uint8_t LVDIR      : 1;
} stc_lvd_lvd_str_field_t;

typedef struct stc_lvd_lvd_clr_field
{
        uint8_t RESERVED1  : 7;
  __IO  uint8_t LVDCL      : 1;
} stc_lvd_lvd_clr_field_t;

typedef struct stc_lvd_lvd_str2_field
{
        uint8_t RESERVED1  : 7;
  __IO  uint8_t LVDIRDY    : 1;
} stc_lvd_lvd_str2_field_t;

/******************************************************************************
 * USB Ethernet CLK
 ******************************************************************************/
/* USB ETHERNET CLK register bit fields */
typedef struct stc_usbethernetclk_uccr_field
{
  __IO  uint8_t UCEN0      : 1;
  __IO  uint8_t UCSEL0     : 1;
  __IO  uint8_t UCSEL1     : 1;
  __IO  uint8_t UCEN1      : 1;
  __IO  uint8_t ECEN       : 1;
  __IO  uint8_t ECSEL0     : 1;
  __IO  uint8_t ECSEL1     : 1;
} stc_usbethernetclk_uccr_field_t;

typedef struct stc_usbethernetclk_upcr1_field
{
  __IO  uint8_t UPLLEN     : 1;
  __IO  uint8_t UPINC      : 1;
} stc_usbethernetclk_upcr1_field_t;

typedef struct stc_usbethernetclk_upcr2_field
{
  __IO  uint8_t UPOWT0     : 1;
  __IO  uint8_t UPOWT1     : 1;
  __IO  uint8_t UPOWT2     : 1;
} stc_usbethernetclk_upcr2_field_t;

typedef struct stc_usbethernetclk_upcr3_field
{
  __IO  uint8_t UPLLK0     : 1;
  __IO  uint8_t UPLLK1     : 1;
  __IO  uint8_t UPLLK2     : 1;
  __IO  uint8_t UPLLK3     : 1;
  __IO  uint8_t UPLLK4     : 1;
} stc_usbethernetclk_upcr3_field_t;

typedef struct stc_usbethernetclk_upcr4_field
{
  __IO  uint8_t UPLLN0     : 1;
  __IO  uint8_t UPLLN1     : 1;
  __IO  uint8_t UPLLN2     : 1;
  __IO  uint8_t UPLLN3     : 1;
  __IO  uint8_t UPLLN4     : 1;
  __IO  uint8_t UPLLN5     : 1;
  __IO  uint8_t UPLLN6     : 1;
} stc_usbethernetclk_upcr4_field_t;

typedef struct stc_usbethernetclk_up_str_field
{
  __IO  uint8_t UPRDY      : 1;
} stc_usbethernetclk_up_str_field_t;

typedef struct stc_usbethernetclk_upint_enr_field
{
  __IO  uint8_t UPCSE      : 1;
} stc_usbethernetclk_upint_enr_field_t;

typedef struct stc_usbethernetclk_upint_clr_field
{
  __IO  uint8_t UPCSC      : 1;
} stc_usbethernetclk_upint_clr_field_t;

typedef struct stc_usbethernetclk_upint_str_field
{
  __IO  uint8_t UPCSI      : 1;
} stc_usbethernetclk_upint_str_field_t;

typedef struct stc_usbethernetclk_upcr5_field
{
  __IO  uint8_t UPLLM0     : 1;
  __IO  uint8_t UPLLM1     : 1;
  __IO  uint8_t UPLLM2     : 1;
  __IO  uint8_t UPLLM3     : 1;
} stc_usbethernetclk_upcr5_field_t;

typedef struct stc_usbethernetclk_upcr6_field
{
  __IO  uint8_t UBSR0      : 1;
  __IO  uint8_t UBSR1      : 1;
  __IO  uint8_t UBSR2      : 1;
  __IO  uint8_t UBSR3      : 1;
} stc_usbethernetclk_upcr6_field_t;

typedef struct stc_usbethernetclk_upcr7_field
{
  __IO  uint8_t EPLLEN     : 1;
} stc_usbethernetclk_upcr7_field_t;

typedef struct stc_usbethernetclk_usben0_field
{
  __IO  uint8_t USBEN0     : 1;
} stc_usbethernetclk_usben0_field_t;

typedef struct stc_usbethernetclk_usben1_field
{
  __IO  uint8_t USBEN1     : 1;
} stc_usbethernetclk_usben1_field_t;

/******************************************************************************
 * CANPRE_MODULE
 ******************************************************************************/
/* CANPRE_MODULE register bit fields */
typedef struct stc_canpre_canpre_field
{
  __IO  uint8_t CANPRE0    : 1;
  __IO  uint8_t CANPRE1    : 1;
  __IO  uint8_t CANPRE2    : 1;
  __IO  uint8_t CANPRE3    : 1;
} stc_canpre_canpre_field_t;

/******************************************************************************
 * MFS03_UART_MODULE
 ******************************************************************************/
/* MFS03_UART_MODULE register bit fields */
typedef struct stc_mfs03_uart_smr_field
{
  __IO  uint8_t SOE        : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t BDS        : 1;
  __IO  uint8_t SBL        : 1;
  __IO  uint8_t WUCR       : 1;
  __IO  uint8_t MD         : 3;
} stc_mfs03_uart_smr_field_t;

typedef struct stc_mfs03_uart_scr_field
{
  __IO  uint8_t TXE        : 1;
  __IO  uint8_t RXE        : 1;
  __IO  uint8_t TBIE       : 1;
  __IO  uint8_t TIE        : 1;
  __IO  uint8_t RIE        : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t UPCL       : 1;
} stc_mfs03_uart_scr_field_t;

typedef struct stc_mfs03_uart_escr_field
{
  __IO  uint8_t L0         : 1;
  __IO  uint8_t L1         : 1;
  __IO  uint8_t L2         : 1;
  __IO  uint8_t P          : 1;
  __IO  uint8_t PEN        : 1;
  __IO  uint8_t INV        : 1;
  __IO  uint8_t ESBL       : 1;
  __IO  uint8_t FLWEN      : 1;
} stc_mfs03_uart_escr_field_t;

typedef struct stc_mfs03_uart_ssr_field
{
  __IO  uint8_t TBI        : 1;
  __IO  uint8_t TDRE       : 1;
  __IO  uint8_t RDRF       : 1;
  __IO  uint8_t ORE        : 1;
  __IO  uint8_t FRE        : 1;
  __IO  uint8_t PE         : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t REC        : 1;
} stc_mfs03_uart_ssr_field_t;

typedef struct stc_mfs03_uart_rdr_field
{
       uint16_t RESERVED1  : 8;
  __IO uint16_t AD         : 1;
} stc_mfs03_uart_rdr_field_t;

typedef struct stc_mfs03_uart_tdr_field
{
       uint16_t RESERVED1  : 8;
  __IO uint16_t AD         : 1;
} stc_mfs03_uart_tdr_field_t;

typedef struct stc_mfs03_uart_bgr_field
{
       uint16_t RESERVED1  : 15;
  __IO uint16_t EXT        : 1;
} stc_mfs03_uart_bgr_field_t;

typedef struct stc_mfs03_uart_bgr1_field
{
        uint8_t RESERVED1  : 7;
  __IO  uint8_t EXT        : 1;
} stc_mfs03_uart_bgr1_field_t;

/******************************************************************************
 * MFS03_CSIO_MODULE
 ******************************************************************************/
/* MFS03_CSIO_MODULE register bit fields */
typedef struct stc_mfs03_csio_smr_field
{
  __IO  uint8_t SOE        : 1;
  __IO  uint8_t SCKE       : 1;
  __IO  uint8_t BDS        : 1;
  __IO  uint8_t SCINV      : 1;
  __IO  uint8_t WUCR       : 1;
  __IO  uint8_t MD         : 3;
} stc_mfs03_csio_smr_field_t;

typedef struct stc_mfs03_csio_scr_field
{
  __IO  uint8_t TXE        : 1;
  __IO  uint8_t RXE        : 1;
  __IO  uint8_t TBIE       : 1;
  __IO  uint8_t TIE        : 1;
  __IO  uint8_t RIE        : 1;
  __IO  uint8_t SPI        : 1;
  __IO  uint8_t MS         : 1;
  __IO  uint8_t UPCL       : 1;
} stc_mfs03_csio_scr_field_t;

typedef struct stc_mfs03_csio_escr_field
{
  __IO  uint8_t L0         : 1;
  __IO  uint8_t L1         : 1;
  __IO  uint8_t L2         : 1;
  __IO  uint8_t WT0        : 1;
  __IO  uint8_t WT1        : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t SOP        : 1;
} stc_mfs03_csio_escr_field_t;

typedef struct stc_mfs03_csio_ssr_field
{
  __IO  uint8_t TBI        : 1;
  __IO  uint8_t TDRE       : 1;
  __IO  uint8_t RDRF       : 1;
  __IO  uint8_t ORE        : 1;
        uint8_t RESERVED1  : 3;
  __IO  uint8_t REC        : 1;
} stc_mfs03_csio_ssr_field_t;

/******************************************************************************
 * MFS03_LIN_MODULE
 ******************************************************************************/
/* MFS03_LIN_MODULE register bit fields */
typedef struct stc_mfs03_lin_smr_field
{
  __IO  uint8_t SOE        : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t SBL        : 1;
  __IO  uint8_t WUCR       : 1;
  __IO  uint8_t MD         : 3;
} stc_mfs03_lin_smr_field_t;

typedef struct stc_mfs03_lin_scr_field
{
  __IO  uint8_t TXE        : 1;
  __IO  uint8_t RXE        : 1;
  __IO  uint8_t TBIE       : 1;
  __IO  uint8_t TIE        : 1;
  __IO  uint8_t RIE        : 1;
  __IO  uint8_t LBR        : 1;
  __IO  uint8_t MS         : 1;
  __IO  uint8_t UPCL       : 1;
} stc_mfs03_lin_scr_field_t;

typedef struct stc_mfs03_lin_escr_field
{
  __IO  uint8_t DEL0       : 1;
  __IO  uint8_t DEL1       : 1;
  __IO  uint8_t LBL0       : 1;
  __IO  uint8_t LBL1       : 1;
  __IO  uint8_t LBIE       : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t ESBL       : 1;
} stc_mfs03_lin_escr_field_t;

typedef struct stc_mfs03_lin_ssr_field
{
  __IO  uint8_t TBI        : 1;
  __IO  uint8_t TDRE       : 1;
  __IO  uint8_t RDRF       : 1;
  __IO  uint8_t ORE        : 1;
  __IO  uint8_t FRE        : 1;
  __IO  uint8_t LBD        : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t REC        : 1;
} stc_mfs03_lin_ssr_field_t;

typedef struct stc_mfs03_lin_bgr_field
{
       uint16_t RESERVED1  : 15;
  __IO uint16_t EXT        : 1;
} stc_mfs03_lin_bgr_field_t;

typedef struct stc_mfs03_lin_bgr1_field
{
        uint8_t RESERVED1  : 7;
  __IO  uint8_t EXT        : 1;
} stc_mfs03_lin_bgr1_field_t;

/******************************************************************************
 * MFS03_I2C_MODULE
 ******************************************************************************/
/* MFS03_I2C_MODULE register bit fields */
typedef struct stc_mfs03_i2c_smr_field
{
        uint8_t RESERVED1  : 2;
  __IO  uint8_t TIE        : 1;
  __IO  uint8_t RIE        : 1;
  __IO  uint8_t WUCR       : 1;
  __IO  uint8_t MD         : 3;
} stc_mfs03_i2c_smr_field_t;

typedef struct stc_mfs03_i2c_ibcr_field
{
  __IO  uint8_t INT        : 1;
  __IO  uint8_t BER        : 1;
  __IO  uint8_t INTE       : 1;
  __IO  uint8_t CNDE       : 1;
  __IO  uint8_t WSEL       : 1;
  __IO  uint8_t ACKE       : 1;
  __IO  uint8_t SCC        : 1;
  __IO  uint8_t MSS        : 1;
} stc_mfs03_i2c_ibcr_field_t;

typedef struct stc_mfs03_i2c_ibsr_field
{
  __IO  uint8_t BB         : 1;
  __IO  uint8_t SPC        : 1;
  __IO  uint8_t RSC        : 1;
  __IO  uint8_t AL         : 1;
  __IO  uint8_t TRX        : 1;
  __IO  uint8_t RSA        : 1;
  __IO  uint8_t RACK       : 1;
  __IO  uint8_t FBT        : 1;
} stc_mfs03_i2c_ibsr_field_t;

typedef struct stc_mfs03_i2c_ssr_field
{
  __IO  uint8_t TBI        : 1;
  __IO  uint8_t TDRE       : 1;
  __IO  uint8_t RDRF       : 1;
  __IO  uint8_t ORE        : 1;
  __IO  uint8_t TBIE       : 1;
  __IO  uint8_t DMA        : 1;
  __IO  uint8_t TSET       : 1;
  __IO  uint8_t REC        : 1;
} stc_mfs03_i2c_ssr_field_t;

typedef struct stc_mfs03_i2c_isba_field
{
  __IO  uint8_t SA0        : 1;
  __IO  uint8_t SA1        : 1;
  __IO  uint8_t SA2        : 1;
  __IO  uint8_t SA3        : 1;
  __IO  uint8_t SA4        : 1;
  __IO  uint8_t SA5        : 1;
  __IO  uint8_t SA6        : 1;
  __IO  uint8_t SAEN       : 1;
} stc_mfs03_i2c_isba_field_t;

typedef struct stc_mfs03_i2c_ismk_field
{
  __IO  uint8_t SM0        : 1;
  __IO  uint8_t SM1        : 1;
  __IO  uint8_t SM2        : 1;
  __IO  uint8_t SM3        : 1;
  __IO  uint8_t SM4        : 1;
  __IO  uint8_t SM5        : 1;
  __IO  uint8_t SM6        : 1;
  __IO  uint8_t EN         : 1;
} stc_mfs03_i2c_ismk_field_t;

/******************************************************************************
 * MFS47_UART_MODULE
 ******************************************************************************/
/* MFS47_UART_MODULE register bit fields */
typedef struct stc_mfs47_uart_smr_field
{
  __IO  uint8_t SOE        : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t BDS        : 1;
  __IO  uint8_t SBL        : 1;
  __IO  uint8_t WUCR       : 1;
  __IO  uint8_t MD         : 3;
} stc_mfs47_uart_smr_field_t;

typedef struct stc_mfs47_uart_scr_field
{
  __IO  uint8_t TXE        : 1;
  __IO  uint8_t RXE        : 1;
  __IO  uint8_t TBIE       : 1;
  __IO  uint8_t TIE        : 1;
  __IO  uint8_t RIE        : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t UPCL       : 1;
} stc_mfs47_uart_scr_field_t;

typedef struct stc_mfs47_uart_escr_field
{
  __IO  uint8_t L0         : 1;
  __IO  uint8_t L1         : 1;
  __IO  uint8_t L2         : 1;
  __IO  uint8_t P          : 1;
  __IO  uint8_t PEN        : 1;
  __IO  uint8_t INV        : 1;
  __IO  uint8_t ESBL       : 1;
  __IO  uint8_t FLWEN      : 1;
} stc_mfs47_uart_escr_field_t;

typedef struct stc_mfs47_uart_ssr_field
{
  __IO  uint8_t TBI        : 1;
  __IO  uint8_t TDRE       : 1;
  __IO  uint8_t RDRF       : 1;
  __IO  uint8_t ORE        : 1;
  __IO  uint8_t FRE        : 1;
  __IO  uint8_t PE         : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t REC        : 1;
} stc_mfs47_uart_ssr_field_t;

typedef struct stc_mfs47_uart_rdr_field
{
       uint16_t RESERVED1  : 8;
  __IO uint16_t AD         : 1;
} stc_mfs47_uart_rdr_field_t;

typedef struct stc_mfs47_uart_tdr_field
{
       uint16_t RESERVED1  : 8;
  __IO uint16_t AD         : 1;
} stc_mfs47_uart_tdr_field_t;

typedef struct stc_mfs47_uart_bgr_field
{
       uint16_t RESERVED1  : 15;
  __IO uint16_t EXT        : 1;
} stc_mfs47_uart_bgr_field_t;

typedef struct stc_mfs47_uart_bgr1_field
{
        uint8_t RESERVED1  : 7;
  __IO  uint8_t EXT        : 1;
} stc_mfs47_uart_bgr1_field_t;

typedef struct stc_mfs47_uart_fcr_field
{
  __IO uint16_t FE1        : 1;
  __IO uint16_t FE2        : 1;
  __IO uint16_t FCL1       : 1;
  __IO uint16_t FCL2       : 1;
  __IO uint16_t FSET       : 1;
  __IO uint16_t FLD        : 1;
  __IO uint16_t FLST       : 1;
       uint16_t RESERVED1  : 1;
  __IO uint16_t FSEL       : 1;
  __IO uint16_t FTIE       : 1;
  __IO uint16_t FDRQ       : 1;
  __IO uint16_t FRIIE      : 1;
  __IO uint16_t FLSTE      : 1;
       uint16_t RESERVED2  : 1;
} stc_mfs47_uart_fcr_field_t;

typedef struct stc_mfs47_uart_fcr0_field
{
  __IO  uint8_t FE1        : 1;
  __IO  uint8_t FE2        : 1;
  __IO  uint8_t FCL1       : 1;
  __IO  uint8_t FCL2       : 1;
  __IO  uint8_t FSET       : 1;
  __IO  uint8_t FLD        : 1;
  __IO  uint8_t FLST       : 1;
} stc_mfs47_uart_fcr0_field_t;

typedef struct stc_mfs47_uart_fcr1_field
{
  __IO  uint8_t FSEL       : 1;
  __IO  uint8_t FTIE       : 1;
  __IO  uint8_t FDRQ       : 1;
  __IO  uint8_t FRIIE      : 1;
  __IO  uint8_t FLSTE      : 1;
        uint8_t RESERVED1  : 1;
} stc_mfs47_uart_fcr1_field_t;

typedef struct stc_mfs47_uart_fbyte_field
{
  __IO uint16_t FD0        : 1;
  __IO uint16_t FD1        : 1;
  __IO uint16_t FD2        : 1;
  __IO uint16_t FD3        : 1;
  __IO uint16_t FD4        : 1;
  __IO uint16_t FD5        : 1;
  __IO uint16_t FD6        : 1;
  __IO uint16_t FD7        : 1;
  __IO uint16_t FD8        : 1;
  __IO uint16_t FD9        : 1;
  __IO uint16_t FD10       : 1;
  __IO uint16_t FD11       : 1;
  __IO uint16_t FD12       : 1;
  __IO uint16_t FD13       : 1;
  __IO uint16_t FD14       : 1;
  __IO uint16_t FD15       : 1;
} stc_mfs47_uart_fbyte_field_t;

typedef struct stc_mfs47_uart_fbyte1_field
{
  __IO  uint8_t FD0        : 1;
  __IO  uint8_t FD1        : 1;
  __IO  uint8_t FD2        : 1;
  __IO  uint8_t FD3        : 1;
  __IO  uint8_t FD4        : 1;
  __IO  uint8_t FD5        : 1;
  __IO  uint8_t FD6        : 1;
  __IO  uint8_t FD7        : 1;
} stc_mfs47_uart_fbyte1_field_t;

typedef struct stc_mfs47_uart_fbyte2_field
{
  __IO  uint8_t FD8        : 1;
  __IO  uint8_t FD9        : 1;
  __IO  uint8_t FD10       : 1;
  __IO  uint8_t FD11       : 1;
  __IO  uint8_t FD12       : 1;
  __IO  uint8_t FD13       : 1;
  __IO  uint8_t FD14       : 1;
  __IO  uint8_t FD15       : 1;
} stc_mfs47_uart_fbyte2_field_t;

/******************************************************************************
 * MFS47_CSIO_MODULE
 ******************************************************************************/
/* MFS47_CSIO_MODULE register bit fields */
typedef struct stc_mfs47_csio_smr_field
{
  __IO  uint8_t SOE        : 1;
  __IO  uint8_t SCKE       : 1;
  __IO  uint8_t BDS        : 1;
  __IO  uint8_t SCINV      : 1;
  __IO  uint8_t WUCR       : 1;
  __IO  uint8_t MD         : 3;
} stc_mfs47_csio_smr_field_t;

typedef struct stc_mfs47_csio_scr_field
{
  __IO  uint8_t TXE        : 1;
  __IO  uint8_t RXE        : 1;
  __IO  uint8_t TBIE       : 1;
  __IO  uint8_t TIE        : 1;
  __IO  uint8_t RIE        : 1;
  __IO  uint8_t SPI        : 1;
  __IO  uint8_t MS         : 1;
  __IO  uint8_t UPCL       : 1;
} stc_mfs47_csio_scr_field_t;

typedef struct stc_mfs47_csio_escr_field
{
  __IO  uint8_t L0         : 1;
  __IO  uint8_t L1         : 1;
  __IO  uint8_t L2         : 1;
  __IO  uint8_t WT0        : 1;
  __IO  uint8_t WT1        : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t SOP        : 1;
} stc_mfs47_csio_escr_field_t;

typedef struct stc_mfs47_csio_ssr_field
{
  __IO  uint8_t TBI        : 1;
  __IO  uint8_t TDRE       : 1;
  __IO  uint8_t RDRF       : 1;
  __IO  uint8_t ORE        : 1;
        uint8_t RESERVED1  : 3;
  __IO  uint8_t REC        : 1;
} stc_mfs47_csio_ssr_field_t;

typedef struct stc_mfs47_csio_fcr_field
{
  __IO uint16_t FE1        : 1;
  __IO uint16_t FE2        : 1;
  __IO uint16_t FCL1       : 1;
  __IO uint16_t FCL2       : 1;
  __IO uint16_t FSET       : 1;
  __IO uint16_t FLD        : 1;
  __IO uint16_t FLST       : 1;
       uint16_t RESERVED1  : 1;
  __IO uint16_t FSEL       : 1;
  __IO uint16_t FTIE       : 1;
  __IO uint16_t FDRQ       : 1;
  __IO uint16_t FRIIE      : 1;
  __IO uint16_t FLSTE      : 1;
       uint16_t RESERVED2  : 1;
} stc_mfs47_csio_fcr_field_t;

typedef struct stc_mfs47_csio_fcr0_field
{
  __IO  uint8_t FE1        : 1;
  __IO  uint8_t FE2        : 1;
  __IO  uint8_t FCL1       : 1;
  __IO  uint8_t FCL2       : 1;
  __IO  uint8_t FSET       : 1;
  __IO  uint8_t FLD        : 1;
  __IO  uint8_t FLST       : 1;
} stc_mfs47_csio_fcr0_field_t;

typedef struct stc_mfs47_csio_fcr1_field
{
  __IO  uint8_t FSEL       : 1;
  __IO  uint8_t FTIE       : 1;
  __IO  uint8_t FDRQ       : 1;
  __IO  uint8_t FRIIE      : 1;
  __IO  uint8_t FLSTE      : 1;
        uint8_t RESERVED1  : 1;
} stc_mfs47_csio_fcr1_field_t;

typedef struct stc_mfs47_csio_fbyte_field
{
  __IO uint16_t FD0        : 1;
  __IO uint16_t FD1        : 1;
  __IO uint16_t FD2        : 1;
  __IO uint16_t FD3        : 1;
  __IO uint16_t FD4        : 1;
  __IO uint16_t FD5        : 1;
  __IO uint16_t FD6        : 1;
  __IO uint16_t FD7        : 1;
  __IO uint16_t FD8        : 1;
  __IO uint16_t FD9        : 1;
  __IO uint16_t FD10       : 1;
  __IO uint16_t FD11       : 1;
  __IO uint16_t FD12       : 1;
  __IO uint16_t FD13       : 1;
  __IO uint16_t FD14       : 1;
  __IO uint16_t FD15       : 1;
} stc_mfs47_csio_fbyte_field_t;

typedef struct stc_mfs47_csio_fbyte1_field
{
  __IO  uint8_t FD0        : 1;
  __IO  uint8_t FD1        : 1;
  __IO  uint8_t FD2        : 1;
  __IO  uint8_t FD3        : 1;
  __IO  uint8_t FD4        : 1;
  __IO  uint8_t FD5        : 1;
  __IO  uint8_t FD6        : 1;
  __IO  uint8_t FD7        : 1;
} stc_mfs47_csio_fbyte1_field_t;

typedef struct stc_mfs47_csio_fbyte2_field
{
  __IO  uint8_t FD8        : 1;
  __IO  uint8_t FD9        : 1;
  __IO  uint8_t FD10       : 1;
  __IO  uint8_t FD11       : 1;
  __IO  uint8_t FD12       : 1;
  __IO  uint8_t FD13       : 1;
  __IO  uint8_t FD14       : 1;
  __IO  uint8_t FD15       : 1;
} stc_mfs47_csio_fbyte2_field_t;

/******************************************************************************
 * MFS47_LIN_MODULE
 ******************************************************************************/
/* MFS47_LIN_MODULE register bit fields */
typedef struct stc_mfs47_lin_smr_field
{
  __IO  uint8_t SOE        : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t SBL        : 1;
  __IO  uint8_t WUCR       : 1;
  __IO  uint8_t MD         : 3;
} stc_mfs47_lin_smr_field_t;

typedef struct stc_mfs47_lin_scr_field
{
  __IO  uint8_t TXE        : 1;
  __IO  uint8_t RXE        : 1;
  __IO  uint8_t TBIE       : 1;
  __IO  uint8_t TIE        : 1;
  __IO  uint8_t RIE        : 1;
  __IO  uint8_t LBR        : 1;
  __IO  uint8_t MS         : 1;
  __IO  uint8_t UPCL       : 1;
} stc_mfs47_lin_scr_field_t;

typedef struct stc_mfs47_lin_escr_field
{
  __IO  uint8_t DEL0       : 1;
  __IO  uint8_t DEL1       : 1;
  __IO  uint8_t LBL0       : 1;
  __IO  uint8_t LBL1       : 1;
  __IO  uint8_t LBIE       : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t ESBL       : 1;
} stc_mfs47_lin_escr_field_t;

typedef struct stc_mfs47_lin_ssr_field
{
  __IO  uint8_t TBI        : 1;
  __IO  uint8_t TDRE       : 1;
  __IO  uint8_t RDRF       : 1;
  __IO  uint8_t ORE        : 1;
  __IO  uint8_t FRE        : 1;
  __IO  uint8_t LBD        : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t REC        : 1;
} stc_mfs47_lin_ssr_field_t;

typedef struct stc_mfs47_lin_bgr_field
{
       uint16_t RESERVED1  : 15;
  __IO uint16_t EXT        : 1;
} stc_mfs47_lin_bgr_field_t;

typedef struct stc_mfs47_lin_bgr1_field
{
        uint8_t RESERVED1  : 7;
  __IO  uint8_t EXT        : 1;
} stc_mfs47_lin_bgr1_field_t;

typedef struct stc_mfs47_lin_fcr_field
{
  __IO uint16_t FE1        : 1;
  __IO uint16_t FE2        : 1;
  __IO uint16_t FCL1       : 1;
  __IO uint16_t FCL2       : 1;
  __IO uint16_t FSET       : 1;
  __IO uint16_t FLD        : 1;
  __IO uint16_t FLST       : 1;
       uint16_t RESERVED1  : 1;
  __IO uint16_t FSEL       : 1;
  __IO uint16_t FTIE       : 1;
  __IO uint16_t FDRQ       : 1;
  __IO uint16_t FRIIE      : 1;
  __IO uint16_t FLSTE      : 1;
       uint16_t RESERVED2  : 1;
} stc_mfs47_lin_fcr_field_t;

typedef struct stc_mfs47_lin_fcr0_field
{
  __IO  uint8_t FE1        : 1;
  __IO  uint8_t FE2        : 1;
  __IO  uint8_t FCL1       : 1;
  __IO  uint8_t FCL2       : 1;
  __IO  uint8_t FSET       : 1;
  __IO  uint8_t FLD        : 1;
  __IO  uint8_t FLST       : 1;
} stc_mfs47_lin_fcr0_field_t;

typedef struct stc_mfs47_lin_fcr1_field
{
  __IO  uint8_t FSEL       : 1;
  __IO  uint8_t FTIE       : 1;
  __IO  uint8_t FDRQ       : 1;
  __IO  uint8_t FRIIE      : 1;
  __IO  uint8_t FLSTE      : 1;
        uint8_t RESERVED1  : 1;
} stc_mfs47_lin_fcr1_field_t;

typedef struct stc_mfs47_lin_fbyte_field
{
  __IO uint16_t FD0        : 1;
  __IO uint16_t FD1        : 1;
  __IO uint16_t FD2        : 1;
  __IO uint16_t FD3        : 1;
  __IO uint16_t FD4        : 1;
  __IO uint16_t FD5        : 1;
  __IO uint16_t FD6        : 1;
  __IO uint16_t FD7        : 1;
  __IO uint16_t FD8        : 1;
  __IO uint16_t FD9        : 1;
  __IO uint16_t FD10       : 1;
  __IO uint16_t FD11       : 1;
  __IO uint16_t FD12       : 1;
  __IO uint16_t FD13       : 1;
  __IO uint16_t FD14       : 1;
  __IO uint16_t FD15       : 1;
} stc_mfs47_lin_fbyte_field_t;

typedef struct stc_mfs47_lin_fbyte1_field
{
  __IO  uint8_t FD0        : 1;
  __IO  uint8_t FD1        : 1;
  __IO  uint8_t FD2        : 1;
  __IO  uint8_t FD3        : 1;
  __IO  uint8_t FD4        : 1;
  __IO  uint8_t FD5        : 1;
  __IO  uint8_t FD6        : 1;
  __IO  uint8_t FD7        : 1;
} stc_mfs47_lin_fbyte1_field_t;

typedef struct stc_mfs47_lin_fbyte2_field
{
  __IO  uint8_t FD8        : 1;
  __IO  uint8_t FD9        : 1;
  __IO  uint8_t FD10       : 1;
  __IO  uint8_t FD11       : 1;
  __IO  uint8_t FD12       : 1;
  __IO  uint8_t FD13       : 1;
  __IO  uint8_t FD14       : 1;
  __IO  uint8_t FD15       : 1;
} stc_mfs47_lin_fbyte2_field_t;

/******************************************************************************
 * MFS47_I2C_MODULE
 ******************************************************************************/
/* MFS47_I2C_MODULE register bit fields */
typedef struct stc_mfs47_i2c_smr_field
{
        uint8_t RESERVED1  : 2;
  __IO  uint8_t TIE        : 1;
  __IO  uint8_t RIE        : 1;
  __IO  uint8_t WUCR       : 1;
  __IO  uint8_t MD         : 3;
} stc_mfs47_i2c_smr_field_t;

typedef struct stc_mfs47_i2c_ibcr_field
{
  __IO  uint8_t INT        : 1;
  __IO  uint8_t BER        : 1;
  __IO  uint8_t INTE       : 1;
  __IO  uint8_t CNDE       : 1;
  __IO  uint8_t WSEL       : 1;
  __IO  uint8_t ACKE       : 1;
  __IO  uint8_t SCC        : 1;
  __IO  uint8_t MSS        : 1;
} stc_mfs47_i2c_ibcr_field_t;

typedef struct stc_mfs47_i2c_ibsr_field
{
  __IO  uint8_t BB         : 1;
  __IO  uint8_t SPC        : 1;
  __IO  uint8_t RSC        : 1;
  __IO  uint8_t AL         : 1;
  __IO  uint8_t TRX        : 1;
  __IO  uint8_t RSA        : 1;
  __IO  uint8_t RACK       : 1;
  __IO  uint8_t FBT        : 1;
} stc_mfs47_i2c_ibsr_field_t;

typedef struct stc_mfs47_i2c_ssr_field
{
  __IO  uint8_t TBI        : 1;
  __IO  uint8_t TDRE       : 1;
  __IO  uint8_t RDRF       : 1;
  __IO  uint8_t ORE        : 1;
  __IO  uint8_t TBIE       : 1;
  __IO  uint8_t DMA        : 1;
  __IO  uint8_t TSET       : 1;
  __IO  uint8_t REC        : 1;
} stc_mfs47_i2c_ssr_field_t;

typedef struct stc_mfs47_i2c_isba_field
{
  __IO  uint8_t SA0        : 1;
  __IO  uint8_t SA1        : 1;
  __IO  uint8_t SA2        : 1;
  __IO  uint8_t SA3        : 1;
  __IO  uint8_t SA4        : 1;
  __IO  uint8_t SA5        : 1;
  __IO  uint8_t SA6        : 1;
  __IO  uint8_t SAEN       : 1;
} stc_mfs47_i2c_isba_field_t;

typedef struct stc_mfs47_i2c_ismk_field
{
  __IO  uint8_t SM0        : 1;
  __IO  uint8_t SM1        : 1;
  __IO  uint8_t SM2        : 1;
  __IO  uint8_t SM3        : 1;
  __IO  uint8_t SM4        : 1;
  __IO  uint8_t SM5        : 1;
  __IO  uint8_t SM6        : 1;
  __IO  uint8_t EN         : 1;
} stc_mfs47_i2c_ismk_field_t;

typedef struct stc_mfs47_i2c_fcr_field
{
  __IO uint16_t FE1        : 1;
  __IO uint16_t FE2        : 1;
  __IO uint16_t FCL1       : 1;
  __IO uint16_t FCL2       : 1;
  __IO uint16_t FSET       : 1;
  __IO uint16_t FLD        : 1;
  __IO uint16_t FLST       : 1;
       uint16_t RESERVED1  : 1;
  __IO uint16_t FSEL       : 1;
  __IO uint16_t FTIE       : 1;
  __IO uint16_t FDRQ       : 1;
  __IO uint16_t FRIIE      : 1;
  __IO uint16_t FLSTE      : 1;
       uint16_t RESERVED2  : 1;
} stc_mfs47_i2c_fcr_field_t;

typedef struct stc_mfs47_i2c_fcr0_field
{
  __IO  uint8_t FE1        : 1;
  __IO  uint8_t FE2        : 1;
  __IO  uint8_t FCL1       : 1;
  __IO  uint8_t FCL2       : 1;
  __IO  uint8_t FSET       : 1;
  __IO  uint8_t FLD        : 1;
  __IO  uint8_t FLST       : 1;
} stc_mfs47_i2c_fcr0_field_t;

typedef struct stc_mfs47_i2c_fcr1_field
{
  __IO  uint8_t FSEL       : 1;
  __IO  uint8_t FTIE       : 1;
  __IO  uint8_t FDRQ       : 1;
  __IO  uint8_t FRIIE      : 1;
  __IO  uint8_t FLSTE      : 1;
        uint8_t RESERVED1  : 1;
} stc_mfs47_i2c_fcr1_field_t;

typedef struct stc_mfs47_i2c_fbyte_field
{
  __IO uint16_t FD0        : 1;
  __IO uint16_t FD1        : 1;
  __IO uint16_t FD2        : 1;
  __IO uint16_t FD3        : 1;
  __IO uint16_t FD4        : 1;
  __IO uint16_t FD5        : 1;
  __IO uint16_t FD6        : 1;
  __IO uint16_t FD7        : 1;
  __IO uint16_t FD8        : 1;
  __IO uint16_t FD9        : 1;
  __IO uint16_t FD10       : 1;
  __IO uint16_t FD11       : 1;
  __IO uint16_t FD12       : 1;
  __IO uint16_t FD13       : 1;
  __IO uint16_t FD14       : 1;
  __IO uint16_t FD15       : 1;
} stc_mfs47_i2c_fbyte_field_t;

typedef struct stc_mfs47_i2c_fbyte1_field
{
  __IO  uint8_t FD0        : 1;
  __IO  uint8_t FD1        : 1;
  __IO  uint8_t FD2        : 1;
  __IO  uint8_t FD3        : 1;
  __IO  uint8_t FD4        : 1;
  __IO  uint8_t FD5        : 1;
  __IO  uint8_t FD6        : 1;
  __IO  uint8_t FD7        : 1;
} stc_mfs47_i2c_fbyte1_field_t;

typedef struct stc_mfs47_i2c_fbyte2_field
{
  __IO  uint8_t FD8        : 1;
  __IO  uint8_t FD9        : 1;
  __IO  uint8_t FD10       : 1;
  __IO  uint8_t FD11       : 1;
  __IO  uint8_t FD12       : 1;
  __IO  uint8_t FD13       : 1;
  __IO  uint8_t FD14       : 1;
  __IO  uint8_t FD15       : 1;
} stc_mfs47_i2c_fbyte2_field_t;

/******************************************************************************
 * MFS_NFC_MODULE
 ******************************************************************************/
/* MFS_NFC_MODULE register bit fields */
typedef struct stc_mfs_nfc_i2cdnf_field
{
  __IO uint16_t I2CDNF00   : 1;
  __IO uint16_t I2CDNF01   : 1;
  __IO uint16_t I2CDNF10   : 1;
  __IO uint16_t I2CDNF11   : 1;
  __IO uint16_t I2CDNF20   : 1;
  __IO uint16_t I2CDNF21   : 1;
  __IO uint16_t I2CDNF30   : 1;
  __IO uint16_t I2CDNF31   : 1;
  __IO uint16_t I2CDNF40   : 1;
  __IO uint16_t I2CDNF41   : 1;
  __IO uint16_t I2CDNF50   : 1;
  __IO uint16_t I2CDNF51   : 1;
  __IO uint16_t I2CDNF60   : 1;
  __IO uint16_t I2CDNF61   : 1;
  __IO uint16_t I2CDNF70   : 1;
  __IO uint16_t I2CDNF71   : 1;
} stc_mfs_nfc_i2cdnf_field_t;

/******************************************************************************
 * CRC_MODULE
 ******************************************************************************/
/* CRC_MODULE register bit fields */
typedef struct stc_crc_crccr_field
{
  __IO  uint8_t INIT       : 1;
  __IO  uint8_t CRC32      : 1;
  __IO  uint8_t LTLEND     : 1;
  __IO  uint8_t LSBFST     : 1;
  __IO  uint8_t CRCLTE     : 1;
  __IO  uint8_t CRCLSF     : 1;
  __IO  uint8_t FXOR       : 1;
} stc_crc_crccr_field_t;

/******************************************************************************
 * WC_MODULE
 ******************************************************************************/
/* WC_MODULE register bit fields */
typedef struct stc_wc_wcrd_field
{
  __IO  uint8_t CTR0       : 1;
  __IO  uint8_t CTR1       : 1;
  __IO  uint8_t CTR2       : 1;
  __IO  uint8_t CTR3       : 1;
  __IO  uint8_t CTR4       : 1;
  __IO  uint8_t CTR5       : 1;
} stc_wc_wcrd_field_t;

typedef struct stc_wc_wcrl_field
{
  __IO  uint8_t RLC0       : 1;
  __IO  uint8_t RLC1       : 1;
  __IO  uint8_t RLC2       : 1;
  __IO  uint8_t RLC3       : 1;
  __IO  uint8_t RLC4       : 1;
  __IO  uint8_t RLC5       : 1;
} stc_wc_wcrl_field_t;

typedef struct stc_wc_wccr_field
{
  __IO  uint8_t WCIF       : 1;
  __IO  uint8_t WCIE       : 1;
  __IO  uint8_t CS0        : 1;
  __IO  uint8_t CS1        : 1;
        uint8_t RESERVED1  : 2;
  __IO  uint8_t WCOP       : 1;
  __IO  uint8_t WCEN       : 1;
} stc_wc_wccr_field_t;

typedef struct stc_wc_clk_sel_field
{
  __IO uint16_t SEL_IN     : 1;
       uint16_t RESERVED1  : 7;
  __IO uint16_t SEL_OUT    : 1;
} stc_wc_clk_sel_field_t;

typedef struct stc_wc_clk_en_field
{
  __IO  uint8_t CLK_EN     : 1;
  __IO  uint8_t CLK_EN_R   : 1;
} stc_wc_clk_en_field_t;

/******************************************************************************
 * EXBUS_MODULE
 ******************************************************************************/
/* EXBUS_MODULE register bit fields */
typedef struct stc_exbus_mode0_field
{
  __IO uint32_t WDTH0      : 1;
  __IO uint32_t WDTH1      : 1;
  __IO uint32_t RBMON      : 1;
  __IO uint32_t WEOFF      : 1;
  __IO uint32_t NAND       : 1;
  __IO uint32_t PAGE       : 1;
  __IO uint32_t RDY        : 1;
  __IO uint32_t SHRTDOUT   : 1;
  __IO uint32_t MPXMODE    : 1;
  __IO uint32_t ALEINV     : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t MPXDOFF    : 1;
  __IO uint32_t MPXCSOF    : 1;
  __IO uint32_t MOEXEUP    : 1;
} stc_exbus_mode0_field_t;

typedef struct stc_exbus_mode1_field
{
  __IO uint32_t WDTH0      : 1;
  __IO uint32_t WDTH1      : 1;
  __IO uint32_t RBMON      : 1;
  __IO uint32_t WEOFF      : 1;
  __IO uint32_t NAND       : 1;
  __IO uint32_t PAGE       : 1;
  __IO uint32_t RDY        : 1;
  __IO uint32_t SHRTDOUT   : 1;
  __IO uint32_t MPXMODE    : 1;
  __IO uint32_t ALEINV     : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t MPXDOFF    : 1;
  __IO uint32_t MPXCSOF    : 1;
  __IO uint32_t MOEXEUP    : 1;
} stc_exbus_mode1_field_t;

typedef struct stc_exbus_mode2_field
{
  __IO uint32_t WDTH0      : 1;
  __IO uint32_t WDTH1      : 1;
  __IO uint32_t RBMON      : 1;
  __IO uint32_t WEOFF      : 1;
  __IO uint32_t NAND       : 1;
  __IO uint32_t PAGE       : 1;
  __IO uint32_t RDY        : 1;
  __IO uint32_t SHRTDOUT   : 1;
  __IO uint32_t MPXMODE    : 1;
  __IO uint32_t ALEINV     : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t MPXDOFF    : 1;
  __IO uint32_t MPXCSOF    : 1;
  __IO uint32_t MOEXEUP    : 1;
} stc_exbus_mode2_field_t;

typedef struct stc_exbus_mode3_field
{
  __IO uint32_t WDTH0      : 1;
  __IO uint32_t WDTH1      : 1;
  __IO uint32_t RBMON      : 1;
  __IO uint32_t WEOFF      : 1;
  __IO uint32_t NAND       : 1;
  __IO uint32_t PAGE       : 1;
  __IO uint32_t RDY        : 1;
  __IO uint32_t SHRTDOUT   : 1;
  __IO uint32_t MPXMODE    : 1;
  __IO uint32_t ALEINV     : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t MPXDOFF    : 1;
  __IO uint32_t MPXCSOF    : 1;
  __IO uint32_t MOEXEUP    : 1;
} stc_exbus_mode3_field_t;

typedef struct stc_exbus_mode4_field
{
  __IO uint32_t WDTH0      : 1;
  __IO uint32_t WDTH1      : 1;
  __IO uint32_t RBMON      : 1;
  __IO uint32_t WEOFF      : 1;
  __IO uint32_t NAND       : 1;
  __IO uint32_t PAGE       : 1;
  __IO uint32_t RDY        : 1;
  __IO uint32_t SHRTDOUT   : 1;
  __IO uint32_t MPXMODE    : 1;
  __IO uint32_t ALEINV     : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t MPXDOFF    : 1;
  __IO uint32_t MPXCSOF    : 1;
  __IO uint32_t MOEXEUP    : 1;
} stc_exbus_mode4_field_t;

typedef struct stc_exbus_mode5_field
{
  __IO uint32_t WDTH0      : 1;
  __IO uint32_t WDTH1      : 1;
  __IO uint32_t RBMON      : 1;
  __IO uint32_t WEOFF      : 1;
  __IO uint32_t NAND       : 1;
  __IO uint32_t PAGE       : 1;
  __IO uint32_t RDY        : 1;
  __IO uint32_t SHRTDOUT   : 1;
  __IO uint32_t MPXMODE    : 1;
  __IO uint32_t ALEINV     : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t MPXDOFF    : 1;
  __IO uint32_t MPXCSOF    : 1;
  __IO uint32_t MOEXEUP    : 1;
} stc_exbus_mode5_field_t;

typedef struct stc_exbus_mode6_field
{
  __IO uint32_t WDTH0      : 1;
  __IO uint32_t WDTH1      : 1;
  __IO uint32_t RBMON      : 1;
  __IO uint32_t WEOFF      : 1;
  __IO uint32_t NAND       : 1;
  __IO uint32_t PAGE       : 1;
  __IO uint32_t RDY        : 1;
  __IO uint32_t SHRTDOUT   : 1;
  __IO uint32_t MPXMODE    : 1;
  __IO uint32_t ALEINV     : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t MPXDOFF    : 1;
  __IO uint32_t MPXCSOF    : 1;
  __IO uint32_t MOEXEUP    : 1;
} stc_exbus_mode6_field_t;

typedef struct stc_exbus_mode7_field
{
  __IO uint32_t WDTH0      : 1;
  __IO uint32_t WDTH1      : 1;
  __IO uint32_t RBMON      : 1;
  __IO uint32_t WEOFF      : 1;
  __IO uint32_t NAND       : 1;
  __IO uint32_t PAGE       : 1;
  __IO uint32_t RDY        : 1;
  __IO uint32_t SHRTDOUT   : 1;
  __IO uint32_t MPXMODE    : 1;
  __IO uint32_t ALEINV     : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t MPXDOFF    : 1;
  __IO uint32_t MPXCSOF    : 1;
  __IO uint32_t MOEXEUP    : 1;
} stc_exbus_mode7_field_t;

typedef struct stc_exbus_tim0_field
{
  __IO uint32_t RACC0      : 1;
  __IO uint32_t RACC1      : 1;
  __IO uint32_t RACC2      : 1;
  __IO uint32_t RACC3      : 1;
  __IO uint32_t RADC0      : 1;
  __IO uint32_t RADC1      : 1;
  __IO uint32_t RADC2      : 1;
  __IO uint32_t RADC3      : 1;
  __IO uint32_t FRADC0     : 1;
  __IO uint32_t FRADC1     : 1;
  __IO uint32_t FRADC2     : 1;
  __IO uint32_t FRADC3     : 1;
  __IO uint32_t RIDLC0     : 1;
  __IO uint32_t RIDLC1     : 1;
  __IO uint32_t RIDLC2     : 1;
  __IO uint32_t RIDLC3     : 1;
  __IO uint32_t WACC0      : 1;
  __IO uint32_t WACC1      : 1;
  __IO uint32_t WACC2      : 1;
  __IO uint32_t WACC3      : 1;
  __IO uint32_t WADC0      : 1;
  __IO uint32_t WADC1      : 1;
  __IO uint32_t WADC2      : 1;
  __IO uint32_t WADC3      : 1;
  __IO uint32_t WWEC0      : 1;
  __IO uint32_t WWEC1      : 1;
  __IO uint32_t WWEC2      : 1;
  __IO uint32_t WWEC3      : 1;
  __IO uint32_t WIDLC0     : 1;
  __IO uint32_t WIDLC1     : 1;
  __IO uint32_t WIDLC2     : 1;
  __IO uint32_t WIDLC3     : 1;
} stc_exbus_tim0_field_t;

typedef struct stc_exbus_tim1_field
{
  __IO uint32_t RACC0      : 1;
  __IO uint32_t RACC1      : 1;
  __IO uint32_t RACC2      : 1;
  __IO uint32_t RACC3      : 1;
  __IO uint32_t RADC0      : 1;
  __IO uint32_t RADC1      : 1;
  __IO uint32_t RADC2      : 1;
  __IO uint32_t RADC3      : 1;
  __IO uint32_t FRADC0     : 1;
  __IO uint32_t FRADC1     : 1;
  __IO uint32_t FRADC2     : 1;
  __IO uint32_t FRADC3     : 1;
  __IO uint32_t RIDLC0     : 1;
  __IO uint32_t RIDLC1     : 1;
  __IO uint32_t RIDLC2     : 1;
  __IO uint32_t RIDLC3     : 1;
  __IO uint32_t WACC0      : 1;
  __IO uint32_t WACC1      : 1;
  __IO uint32_t WACC2      : 1;
  __IO uint32_t WACC3      : 1;
  __IO uint32_t WADC0      : 1;
  __IO uint32_t WADC1      : 1;
  __IO uint32_t WADC2      : 1;
  __IO uint32_t WADC3      : 1;
  __IO uint32_t WWEC0      : 1;
  __IO uint32_t WWEC1      : 1;
  __IO uint32_t WWEC2      : 1;
  __IO uint32_t WWEC3      : 1;
  __IO uint32_t WIDLC0     : 1;
  __IO uint32_t WIDLC1     : 1;
  __IO uint32_t WIDLC2     : 1;
  __IO uint32_t WIDLC3     : 1;
} stc_exbus_tim1_field_t;

typedef struct stc_exbus_tim2_field
{
  __IO uint32_t RACC0      : 1;
  __IO uint32_t RACC1      : 1;
  __IO uint32_t RACC2      : 1;
  __IO uint32_t RACC3      : 1;
  __IO uint32_t RADC0      : 1;
  __IO uint32_t RADC1      : 1;
  __IO uint32_t RADC2      : 1;
  __IO uint32_t RADC3      : 1;
  __IO uint32_t FRADC0     : 1;
  __IO uint32_t FRADC1     : 1;
  __IO uint32_t FRADC2     : 1;
  __IO uint32_t FRADC3     : 1;
  __IO uint32_t RIDLC0     : 1;
  __IO uint32_t RIDLC1     : 1;
  __IO uint32_t RIDLC2     : 1;
  __IO uint32_t RIDLC3     : 1;
  __IO uint32_t WACC0      : 1;
  __IO uint32_t WACC1      : 1;
  __IO uint32_t WACC2      : 1;
  __IO uint32_t WACC3      : 1;
  __IO uint32_t WADC0      : 1;
  __IO uint32_t WADC1      : 1;
  __IO uint32_t WADC2      : 1;
  __IO uint32_t WADC3      : 1;
  __IO uint32_t WWEC0      : 1;
  __IO uint32_t WWEC1      : 1;
  __IO uint32_t WWEC2      : 1;
  __IO uint32_t WWEC3      : 1;
  __IO uint32_t WIDLC0     : 1;
  __IO uint32_t WIDLC1     : 1;
  __IO uint32_t WIDLC2     : 1;
  __IO uint32_t WIDLC3     : 1;
} stc_exbus_tim2_field_t;

typedef struct stc_exbus_tim3_field
{
  __IO uint32_t RACC0      : 1;
  __IO uint32_t RACC1      : 1;
  __IO uint32_t RACC2      : 1;
  __IO uint32_t RACC3      : 1;
  __IO uint32_t RADC0      : 1;
  __IO uint32_t RADC1      : 1;
  __IO uint32_t RADC2      : 1;
  __IO uint32_t RADC3      : 1;
  __IO uint32_t FRADC0     : 1;
  __IO uint32_t FRADC1     : 1;
  __IO uint32_t FRADC2     : 1;
  __IO uint32_t FRADC3     : 1;
  __IO uint32_t RIDLC0     : 1;
  __IO uint32_t RIDLC1     : 1;
  __IO uint32_t RIDLC2     : 1;
  __IO uint32_t RIDLC3     : 1;
  __IO uint32_t WACC0      : 1;
  __IO uint32_t WACC1      : 1;
  __IO uint32_t WACC2      : 1;
  __IO uint32_t WACC3      : 1;
  __IO uint32_t WADC0      : 1;
  __IO uint32_t WADC1      : 1;
  __IO uint32_t WADC2      : 1;
  __IO uint32_t WADC3      : 1;
  __IO uint32_t WWEC0      : 1;
  __IO uint32_t WWEC1      : 1;
  __IO uint32_t WWEC2      : 1;
  __IO uint32_t WWEC3      : 1;
  __IO uint32_t WIDLC0     : 1;
  __IO uint32_t WIDLC1     : 1;
  __IO uint32_t WIDLC2     : 1;
  __IO uint32_t WIDLC3     : 1;
} stc_exbus_tim3_field_t;

typedef struct stc_exbus_tim4_field
{
  __IO uint32_t RACC0      : 1;
  __IO uint32_t RACC1      : 1;
  __IO uint32_t RACC2      : 1;
  __IO uint32_t RACC3      : 1;
  __IO uint32_t RADC0      : 1;
  __IO uint32_t RADC1      : 1;
  __IO uint32_t RADC2      : 1;
  __IO uint32_t RADC3      : 1;
  __IO uint32_t FRADC0     : 1;
  __IO uint32_t FRADC1     : 1;
  __IO uint32_t FRADC2     : 1;
  __IO uint32_t FRADC3     : 1;
  __IO uint32_t RIDLC0     : 1;
  __IO uint32_t RIDLC1     : 1;
  __IO uint32_t RIDLC2     : 1;
  __IO uint32_t RIDLC3     : 1;
  __IO uint32_t WACC0      : 1;
  __IO uint32_t WACC1      : 1;
  __IO uint32_t WACC2      : 1;
  __IO uint32_t WACC3      : 1;
  __IO uint32_t WADC0      : 1;
  __IO uint32_t WADC1      : 1;
  __IO uint32_t WADC2      : 1;
  __IO uint32_t WADC3      : 1;
  __IO uint32_t WWEC0      : 1;
  __IO uint32_t WWEC1      : 1;
  __IO uint32_t WWEC2      : 1;
  __IO uint32_t WWEC3      : 1;
  __IO uint32_t WIDLC0     : 1;
  __IO uint32_t WIDLC1     : 1;
  __IO uint32_t WIDLC2     : 1;
  __IO uint32_t WIDLC3     : 1;
} stc_exbus_tim4_field_t;

typedef struct stc_exbus_tim5_field
{
  __IO uint32_t RACC0      : 1;
  __IO uint32_t RACC1      : 1;
  __IO uint32_t RACC2      : 1;
  __IO uint32_t RACC3      : 1;
  __IO uint32_t RADC0      : 1;
  __IO uint32_t RADC1      : 1;
  __IO uint32_t RADC2      : 1;
  __IO uint32_t RADC3      : 1;
  __IO uint32_t FRADC0     : 1;
  __IO uint32_t FRADC1     : 1;
  __IO uint32_t FRADC2     : 1;
  __IO uint32_t FRADC3     : 1;
  __IO uint32_t RIDLC0     : 1;
  __IO uint32_t RIDLC1     : 1;
  __IO uint32_t RIDLC2     : 1;
  __IO uint32_t RIDLC3     : 1;
  __IO uint32_t WACC0      : 1;
  __IO uint32_t WACC1      : 1;
  __IO uint32_t WACC2      : 1;
  __IO uint32_t WACC3      : 1;
  __IO uint32_t WADC0      : 1;
  __IO uint32_t WADC1      : 1;
  __IO uint32_t WADC2      : 1;
  __IO uint32_t WADC3      : 1;
  __IO uint32_t WWEC0      : 1;
  __IO uint32_t WWEC1      : 1;
  __IO uint32_t WWEC2      : 1;
  __IO uint32_t WWEC3      : 1;
  __IO uint32_t WIDLC0     : 1;
  __IO uint32_t WIDLC1     : 1;
  __IO uint32_t WIDLC2     : 1;
  __IO uint32_t WIDLC3     : 1;
} stc_exbus_tim5_field_t;

typedef struct stc_exbus_tim6_field
{
  __IO uint32_t RACC0      : 1;
  __IO uint32_t RACC1      : 1;
  __IO uint32_t RACC2      : 1;
  __IO uint32_t RACC3      : 1;
  __IO uint32_t RADC0      : 1;
  __IO uint32_t RADC1      : 1;
  __IO uint32_t RADC2      : 1;
  __IO uint32_t RADC3      : 1;
  __IO uint32_t FRADC0     : 1;
  __IO uint32_t FRADC1     : 1;
  __IO uint32_t FRADC2     : 1;
  __IO uint32_t FRADC3     : 1;
  __IO uint32_t RIDLC0     : 1;
  __IO uint32_t RIDLC1     : 1;
  __IO uint32_t RIDLC2     : 1;
  __IO uint32_t RIDLC3     : 1;
  __IO uint32_t WACC0      : 1;
  __IO uint32_t WACC1      : 1;
  __IO uint32_t WACC2      : 1;
  __IO uint32_t WACC3      : 1;
  __IO uint32_t WADC0      : 1;
  __IO uint32_t WADC1      : 1;
  __IO uint32_t WADC2      : 1;
  __IO uint32_t WADC3      : 1;
  __IO uint32_t WWEC0      : 1;
  __IO uint32_t WWEC1      : 1;
  __IO uint32_t WWEC2      : 1;
  __IO uint32_t WWEC3      : 1;
  __IO uint32_t WIDLC0     : 1;
  __IO uint32_t WIDLC1     : 1;
  __IO uint32_t WIDLC2     : 1;
  __IO uint32_t WIDLC3     : 1;
} stc_exbus_tim6_field_t;

typedef struct stc_exbus_tim7_field
{
  __IO uint32_t RACC0      : 1;
  __IO uint32_t RACC1      : 1;
  __IO uint32_t RACC2      : 1;
  __IO uint32_t RACC3      : 1;
  __IO uint32_t RADC0      : 1;
  __IO uint32_t RADC1      : 1;
  __IO uint32_t RADC2      : 1;
  __IO uint32_t RADC3      : 1;
  __IO uint32_t FRADC0     : 1;
  __IO uint32_t FRADC1     : 1;
  __IO uint32_t FRADC2     : 1;
  __IO uint32_t FRADC3     : 1;
  __IO uint32_t RIDLC0     : 1;
  __IO uint32_t RIDLC1     : 1;
  __IO uint32_t RIDLC2     : 1;
  __IO uint32_t RIDLC3     : 1;
  __IO uint32_t WACC0      : 1;
  __IO uint32_t WACC1      : 1;
  __IO uint32_t WACC2      : 1;
  __IO uint32_t WACC3      : 1;
  __IO uint32_t WADC0      : 1;
  __IO uint32_t WADC1      : 1;
  __IO uint32_t WADC2      : 1;
  __IO uint32_t WADC3      : 1;
  __IO uint32_t WWEC0      : 1;
  __IO uint32_t WWEC1      : 1;
  __IO uint32_t WWEC2      : 1;
  __IO uint32_t WWEC3      : 1;
  __IO uint32_t WIDLC0     : 1;
  __IO uint32_t WIDLC1     : 1;
  __IO uint32_t WIDLC2     : 1;
  __IO uint32_t WIDLC3     : 1;
} stc_exbus_tim7_field_t;

typedef struct stc_exbus_area0_field
{
  __IO uint32_t ADDR0      : 1;
  __IO uint32_t ADDR1      : 1;
  __IO uint32_t ADDR2      : 1;
  __IO uint32_t ADDR3      : 1;
  __IO uint32_t ADDR4      : 1;
  __IO uint32_t ADDR5      : 1;
  __IO uint32_t ADDR6      : 1;
  __IO uint32_t ADDR7      : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MASK0      : 1;
  __IO uint32_t MASK1      : 1;
  __IO uint32_t MASK2      : 1;
  __IO uint32_t MASK3      : 1;
  __IO uint32_t MASK4      : 1;
  __IO uint32_t MASK5      : 1;
  __IO uint32_t MASK6      : 1;
} stc_exbus_area0_field_t;

typedef struct stc_exbus_area1_field
{
  __IO uint32_t ADDR0      : 1;
  __IO uint32_t ADDR1      : 1;
  __IO uint32_t ADDR2      : 1;
  __IO uint32_t ADDR3      : 1;
  __IO uint32_t ADDR4      : 1;
  __IO uint32_t ADDR5      : 1;
  __IO uint32_t ADDR6      : 1;
  __IO uint32_t ADDR7      : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MASK0      : 1;
  __IO uint32_t MASK1      : 1;
  __IO uint32_t MASK2      : 1;
  __IO uint32_t MASK3      : 1;
  __IO uint32_t MASK4      : 1;
  __IO uint32_t MASK5      : 1;
  __IO uint32_t MASK6      : 1;
} stc_exbus_area1_field_t;

typedef struct stc_exbus_area2_field
{
  __IO uint32_t ADDR0      : 1;
  __IO uint32_t ADDR1      : 1;
  __IO uint32_t ADDR2      : 1;
  __IO uint32_t ADDR3      : 1;
  __IO uint32_t ADDR4      : 1;
  __IO uint32_t ADDR5      : 1;
  __IO uint32_t ADDR6      : 1;
  __IO uint32_t ADDR7      : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MASK0      : 1;
  __IO uint32_t MASK1      : 1;
  __IO uint32_t MASK2      : 1;
  __IO uint32_t MASK3      : 1;
  __IO uint32_t MASK4      : 1;
  __IO uint32_t MASK5      : 1;
  __IO uint32_t MASK6      : 1;
} stc_exbus_area2_field_t;

typedef struct stc_exbus_area3_field
{
  __IO uint32_t ADDR0      : 1;
  __IO uint32_t ADDR1      : 1;
  __IO uint32_t ADDR2      : 1;
  __IO uint32_t ADDR3      : 1;
  __IO uint32_t ADDR4      : 1;
  __IO uint32_t ADDR5      : 1;
  __IO uint32_t ADDR6      : 1;
  __IO uint32_t ADDR7      : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MASK0      : 1;
  __IO uint32_t MASK1      : 1;
  __IO uint32_t MASK2      : 1;
  __IO uint32_t MASK3      : 1;
  __IO uint32_t MASK4      : 1;
  __IO uint32_t MASK5      : 1;
  __IO uint32_t MASK6      : 1;
} stc_exbus_area3_field_t;

typedef struct stc_exbus_area4_field
{
  __IO uint32_t ADDR0      : 1;
  __IO uint32_t ADDR1      : 1;
  __IO uint32_t ADDR2      : 1;
  __IO uint32_t ADDR3      : 1;
  __IO uint32_t ADDR4      : 1;
  __IO uint32_t ADDR5      : 1;
  __IO uint32_t ADDR6      : 1;
  __IO uint32_t ADDR7      : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MASK0      : 1;
  __IO uint32_t MASK1      : 1;
  __IO uint32_t MASK2      : 1;
  __IO uint32_t MASK3      : 1;
  __IO uint32_t MASK4      : 1;
  __IO uint32_t MASK5      : 1;
  __IO uint32_t MASK6      : 1;
} stc_exbus_area4_field_t;

typedef struct stc_exbus_area5_field
{
  __IO uint32_t ADDR0      : 1;
  __IO uint32_t ADDR1      : 1;
  __IO uint32_t ADDR2      : 1;
  __IO uint32_t ADDR3      : 1;
  __IO uint32_t ADDR4      : 1;
  __IO uint32_t ADDR5      : 1;
  __IO uint32_t ADDR6      : 1;
  __IO uint32_t ADDR7      : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MASK0      : 1;
  __IO uint32_t MASK1      : 1;
  __IO uint32_t MASK2      : 1;
  __IO uint32_t MASK3      : 1;
  __IO uint32_t MASK4      : 1;
  __IO uint32_t MASK5      : 1;
  __IO uint32_t MASK6      : 1;
} stc_exbus_area5_field_t;

typedef struct stc_exbus_area6_field
{
  __IO uint32_t ADDR0      : 1;
  __IO uint32_t ADDR1      : 1;
  __IO uint32_t ADDR2      : 1;
  __IO uint32_t ADDR3      : 1;
  __IO uint32_t ADDR4      : 1;
  __IO uint32_t ADDR5      : 1;
  __IO uint32_t ADDR6      : 1;
  __IO uint32_t ADDR7      : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MASK0      : 1;
  __IO uint32_t MASK1      : 1;
  __IO uint32_t MASK2      : 1;
  __IO uint32_t MASK3      : 1;
  __IO uint32_t MASK4      : 1;
  __IO uint32_t MASK5      : 1;
  __IO uint32_t MASK6      : 1;
} stc_exbus_area6_field_t;

typedef struct stc_exbus_area7_field
{
  __IO uint32_t ADDR0      : 1;
  __IO uint32_t ADDR1      : 1;
  __IO uint32_t ADDR2      : 1;
  __IO uint32_t ADDR3      : 1;
  __IO uint32_t ADDR4      : 1;
  __IO uint32_t ADDR5      : 1;
  __IO uint32_t ADDR6      : 1;
  __IO uint32_t ADDR7      : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MASK0      : 1;
  __IO uint32_t MASK1      : 1;
  __IO uint32_t MASK2      : 1;
  __IO uint32_t MASK3      : 1;
  __IO uint32_t MASK4      : 1;
  __IO uint32_t MASK5      : 1;
  __IO uint32_t MASK6      : 1;
} stc_exbus_area7_field_t;

typedef struct stc_exbus_atim0_field
{
  __IO uint16_t ALC0       : 1;
  __IO uint16_t ALC1       : 1;
  __IO uint16_t ALC2       : 1;
  __IO uint16_t ALC3       : 1;
  __IO uint16_t ALES0      : 1;
  __IO uint16_t ALES1      : 1;
  __IO uint16_t ALES2      : 1;
  __IO uint16_t ALES3      : 1;
  __IO uint16_t ALEW0      : 1;
  __IO uint16_t ALEW1      : 1;
  __IO uint16_t ALEW2      : 1;
  __IO uint16_t ALEW3      : 1;
} stc_exbus_atim0_field_t;

typedef struct stc_exbus_atim1_field
{
  __IO uint16_t ALC0       : 1;
  __IO uint16_t ALC1       : 1;
  __IO uint16_t ALC2       : 1;
  __IO uint16_t ALC3       : 1;
  __IO uint16_t ALES0      : 1;
  __IO uint16_t ALES1      : 1;
  __IO uint16_t ALES2      : 1;
  __IO uint16_t ALES3      : 1;
  __IO uint16_t ALEW0      : 1;
  __IO uint16_t ALEW1      : 1;
  __IO uint16_t ALEW2      : 1;
  __IO uint16_t ALEW3      : 1;
} stc_exbus_atim1_field_t;

typedef struct stc_exbus_atim2_field
{
  __IO uint16_t ALC0       : 1;
  __IO uint16_t ALC1       : 1;
  __IO uint16_t ALC2       : 1;
  __IO uint16_t ALC3       : 1;
  __IO uint16_t ALES0      : 1;
  __IO uint16_t ALES1      : 1;
  __IO uint16_t ALES2      : 1;
  __IO uint16_t ALES3      : 1;
  __IO uint16_t ALEW0      : 1;
  __IO uint16_t ALEW1      : 1;
  __IO uint16_t ALEW2      : 1;
  __IO uint16_t ALEW3      : 1;
} stc_exbus_atim2_field_t;

typedef struct stc_exbus_atim3_field
{
  __IO uint16_t ALC0       : 1;
  __IO uint16_t ALC1       : 1;
  __IO uint16_t ALC2       : 1;
  __IO uint16_t ALC3       : 1;
  __IO uint16_t ALES0      : 1;
  __IO uint16_t ALES1      : 1;
  __IO uint16_t ALES2      : 1;
  __IO uint16_t ALES3      : 1;
  __IO uint16_t ALEW0      : 1;
  __IO uint16_t ALEW1      : 1;
  __IO uint16_t ALEW2      : 1;
  __IO uint16_t ALEW3      : 1;
} stc_exbus_atim3_field_t;

typedef struct stc_exbus_atim4_field
{
  __IO uint16_t ALC0       : 1;
  __IO uint16_t ALC1       : 1;
  __IO uint16_t ALC2       : 1;
  __IO uint16_t ALC3       : 1;
  __IO uint16_t ALES0      : 1;
  __IO uint16_t ALES1      : 1;
  __IO uint16_t ALES2      : 1;
  __IO uint16_t ALES3      : 1;
  __IO uint16_t ALEW0      : 1;
  __IO uint16_t ALEW1      : 1;
  __IO uint16_t ALEW2      : 1;
  __IO uint16_t ALEW3      : 1;
} stc_exbus_atim4_field_t;

typedef struct stc_exbus_atim5_field
{
  __IO uint16_t ALC0       : 1;
  __IO uint16_t ALC1       : 1;
  __IO uint16_t ALC2       : 1;
  __IO uint16_t ALC3       : 1;
  __IO uint16_t ALES0      : 1;
  __IO uint16_t ALES1      : 1;
  __IO uint16_t ALES2      : 1;
  __IO uint16_t ALES3      : 1;
  __IO uint16_t ALEW0      : 1;
  __IO uint16_t ALEW1      : 1;
  __IO uint16_t ALEW2      : 1;
  __IO uint16_t ALEW3      : 1;
} stc_exbus_atim5_field_t;

typedef struct stc_exbus_atim6_field
{
  __IO uint16_t ALC0       : 1;
  __IO uint16_t ALC1       : 1;
  __IO uint16_t ALC2       : 1;
  __IO uint16_t ALC3       : 1;
  __IO uint16_t ALES0      : 1;
  __IO uint16_t ALES1      : 1;
  __IO uint16_t ALES2      : 1;
  __IO uint16_t ALES3      : 1;
  __IO uint16_t ALEW0      : 1;
  __IO uint16_t ALEW1      : 1;
  __IO uint16_t ALEW2      : 1;
  __IO uint16_t ALEW3      : 1;
} stc_exbus_atim6_field_t;

typedef struct stc_exbus_atim7_field
{
  __IO uint16_t ALC0       : 1;
  __IO uint16_t ALC1       : 1;
  __IO uint16_t ALC2       : 1;
  __IO uint16_t ALC3       : 1;
  __IO uint16_t ALES0      : 1;
  __IO uint16_t ALES1      : 1;
  __IO uint16_t ALES2      : 1;
  __IO uint16_t ALES3      : 1;
  __IO uint16_t ALEW0      : 1;
  __IO uint16_t ALEW1      : 1;
  __IO uint16_t ALEW2      : 1;
  __IO uint16_t ALEW3      : 1;
} stc_exbus_atim7_field_t;

typedef struct stc_exbus_dclkr_field
{
  __IO  uint8_t MDIV0      : 1;
  __IO  uint8_t MDIV1      : 1;
  __IO  uint8_t MDIV2      : 1;
  __IO  uint8_t MDIV3      : 1;
  __IO  uint8_t MCLKON     : 1;
} stc_exbus_dclkr_field_t;

/******************************************************************************
 * USB_MODULE
 ******************************************************************************/
/* USB_MODULE register bit fields */
typedef struct stc_usb_hcnt_field
{
  __IO uint16_t HOST       : 1;
  __IO uint16_t URST       : 1;
  __IO uint16_t SOFIRE     : 1;
  __IO uint16_t DIRE       : 1;
  __IO uint16_t CNNIRE     : 1;
  __IO uint16_t CMPIRE     : 1;
  __IO uint16_t URIRE      : 1;
  __IO uint16_t RWKIRE     : 1;
  __IO uint16_t RETRY      : 1;
  __IO uint16_t CANCEL     : 1;
  __IO uint16_t SOFSTEP    : 1;
} stc_usb_hcnt_field_t;

typedef struct stc_usb_hcnt0_field
{
  __IO  uint8_t HOST       : 1;
  __IO  uint8_t URST       : 1;
  __IO  uint8_t SOFIRE     : 1;
  __IO  uint8_t DIRE       : 1;
  __IO  uint8_t CNNIRE     : 1;
  __IO  uint8_t CMPIRE     : 1;
  __IO  uint8_t URIRE      : 1;
  __IO  uint8_t RWKIRE     : 1;
} stc_usb_hcnt0_field_t;

typedef struct stc_usb_hcnt1_field
{
  __IO  uint8_t RETRY      : 1;
  __IO  uint8_t CANCEL     : 1;
  __IO  uint8_t SOFSTEP    : 1;
} stc_usb_hcnt1_field_t;

typedef struct stc_usb_hirq_field
{
  __IO  uint8_t SOFIRQ     : 1;
  __IO  uint8_t DIRQ       : 1;
  __IO  uint8_t CNNIRQ     : 1;
  __IO  uint8_t CMPIRQ     : 1;
  __IO  uint8_t URIRQ      : 1;
  __IO  uint8_t RWKIRQ     : 1;
        uint8_t RESERVED1  : 1;
  __IO  uint8_t TCAN       : 1;
} stc_usb_hirq_field_t;

typedef struct stc_usb_herr_field
{
  __IO  uint8_t HS0        : 1;
  __IO  uint8_t HS1        : 1;
  __IO  uint8_t STUFF      : 1;
  __IO  uint8_t TGERR      : 1;
  __IO  uint8_t CRC        : 1;
  __IO  uint8_t TOUT       : 1;
  __IO  uint8_t RERR       : 1;
  __IO  uint8_t LSTOF      : 1;
} stc_usb_herr_field_t;

typedef struct stc_usb_hstate_field
{
  __IO  uint8_t CSTAT      : 1;
  __IO  uint8_t TMODE      : 1;
  __IO  uint8_t SUSP       : 1;
  __IO  uint8_t SOFBUSY    : 1;
  __IO  uint8_t CLKSEL     : 1;
  __IO  uint8_t ALIVE      : 1;
} stc_usb_hstate_field_t;

typedef struct stc_usb_hfcomp_field
{
  __IO  uint8_t FRAMECOMP0 : 1;
  __IO  uint8_t FRAMECOMP1 : 1;
  __IO  uint8_t FRAMECOMP2 : 1;
  __IO  uint8_t FRAMECOMP3 : 1;
  __IO  uint8_t FRAMECOMP4 : 1;
  __IO  uint8_t FRAMECOMP5 : 1;
  __IO  uint8_t FRAMECOMP6 : 1;
  __IO  uint8_t FRAMECOMP7 : 1;
} stc_usb_hfcomp_field_t;

typedef struct stc_usb_hrtimer_field
{
  __IO uint16_t RTIMER0    : 1;
  __IO uint16_t RTIMER1    : 1;
  __IO uint16_t RTIMER2    : 1;
  __IO uint16_t RTIMER3    : 1;
  __IO uint16_t RTIMER4    : 1;
  __IO uint16_t RTIMER5    : 1;
  __IO uint16_t RTIMER6    : 1;
  __IO uint16_t RTIMER7    : 1;
  __IO uint16_t RTIMER8    : 1;
  __IO uint16_t RTIMER9    : 1;
  __IO uint16_t RTIMER10   : 1;
  __IO uint16_t RTIMER11   : 1;
  __IO uint16_t RTIMER12   : 1;
  __IO uint16_t RTIMER13   : 1;
  __IO uint16_t RTIMER14   : 1;
  __IO uint16_t RTIMER15   : 1;
} stc_usb_hrtimer_field_t;

typedef struct stc_usb_hrtimer0_field
{
  __IO  uint8_t RTIMER00   : 1;
  __IO  uint8_t RTIMER01   : 1;
  __IO  uint8_t RTIMER02   : 1;
  __IO  uint8_t RTIMER03   : 1;
  __IO  uint8_t RTIMER04   : 1;
  __IO  uint8_t RTIMER05   : 1;
  __IO  uint8_t RTIMER06   : 1;
  __IO  uint8_t RTIMER07   : 1;
} stc_usb_hrtimer0_field_t;

typedef struct stc_usb_hrtimer1_field
{
  __IO  uint8_t RTIMER10   : 1;
  __IO  uint8_t RTIMER11   : 1;
  __IO  uint8_t RTIMER12   : 1;
  __IO  uint8_t RTIMER13   : 1;
  __IO  uint8_t RTIMER14   : 1;
  __IO  uint8_t RTIMER15   : 1;
  __IO  uint8_t RTIMER16   : 1;
  __IO  uint8_t RTIMER17   : 1;
} stc_usb_hrtimer1_field_t;

typedef struct stc_usb_hrtimer2_field
{
  __IO  uint8_t RTIMER20   : 1;
  __IO  uint8_t RTIMER21   : 1;
  __IO  uint8_t RTIMER22   : 1;
} stc_usb_hrtimer2_field_t;

typedef struct stc_usb_hadr_field
{
  __IO  uint8_t ADDRESS0   : 1;
  __IO  uint8_t ADDRESS1   : 1;
  __IO  uint8_t ADDRESS2   : 1;
  __IO  uint8_t ADDRESS3   : 1;
  __IO  uint8_t ADDRESS4   : 1;
  __IO  uint8_t ADDRESS5   : 1;
  __IO  uint8_t ADDRESS6   : 1;
} stc_usb_hadr_field_t;

typedef struct stc_usb_heof_field
{
  __IO uint16_t EOF0       : 1;
  __IO uint16_t EOF1       : 1;
  __IO uint16_t EOF2       : 1;
  __IO uint16_t EOF3       : 1;
  __IO uint16_t EOF4       : 1;
  __IO uint16_t EOF5       : 1;
  __IO uint16_t EOF6       : 1;
  __IO uint16_t EOF7       : 1;
  __IO uint16_t EOF8       : 1;
  __IO uint16_t EOF9       : 1;
  __IO uint16_t EOF10      : 1;
  __IO uint16_t EOF11      : 1;
  __IO uint16_t EOF12      : 1;
  __IO uint16_t EOF13      : 1;
  __IO uint16_t EOF14      : 1;
  __IO uint16_t EOF15      : 1;
} stc_usb_heof_field_t;

typedef struct stc_usb_heof0_field
{
  __IO  uint8_t EOF00      : 1;
  __IO  uint8_t EOF01      : 1;
  __IO  uint8_t EOF02      : 1;
  __IO  uint8_t EOF03      : 1;
  __IO  uint8_t EOF04      : 1;
  __IO  uint8_t EOF05      : 1;
  __IO  uint8_t EOF06      : 1;
  __IO  uint8_t EOF07      : 1;
} stc_usb_heof0_field_t;

typedef struct stc_usb_heof1_field
{
  __IO  uint8_t EOF10      : 1;
  __IO  uint8_t EOF11      : 1;
  __IO  uint8_t EOF12      : 1;
  __IO  uint8_t EOF13      : 1;
  __IO  uint8_t EOF14      : 1;
  __IO  uint8_t EOF15      : 1;
} stc_usb_heof1_field_t;

typedef struct stc_usb_hframe_field
{
  __IO uint16_t FRAME0     : 1;
  __IO uint16_t FRAME1     : 1;
  __IO uint16_t FRAME2     : 1;
  __IO uint16_t FRAME3     : 1;
  __IO uint16_t FRAME4     : 1;
  __IO uint16_t FRAME5     : 1;
  __IO uint16_t FRAME6     : 1;
  __IO uint16_t FRAME7     : 1;
  __IO uint16_t FRAME8     : 1;
  __IO uint16_t FRAME9     : 1;
  __IO uint16_t FRAME10    : 1;
} stc_usb_hframe_field_t;

typedef struct stc_usb_hframe0_field
{
  __IO  uint8_t FRAME00    : 1;
  __IO  uint8_t FRAME01    : 1;
  __IO  uint8_t FRAME02    : 1;
  __IO  uint8_t FRAME03    : 1;
  __IO  uint8_t FRAME04    : 1;
  __IO  uint8_t FRAME05    : 1;
  __IO  uint8_t FRAME06    : 1;
  __IO  uint8_t FRAME07    : 1;
} stc_usb_hframe0_field_t;

typedef struct stc_usb_hframe1_field
{
  __IO  uint8_t FRAME10    : 1;
  __IO  uint8_t FRAME11    : 1;
  __IO  uint8_t FRAME12    : 1;
  __IO  uint8_t FRAME13    : 1;
} stc_usb_hframe1_field_t;

typedef struct stc_usb_htoken_field
{
  __IO  uint8_t ENDPT0     : 1;
  __IO  uint8_t ENDPT1     : 1;
  __IO  uint8_t ENDPT2     : 1;
  __IO  uint8_t ENDPT3     : 1;
  __IO  uint8_t TKNEN0     : 1;
  __IO  uint8_t TKNEN1     : 1;
  __IO  uint8_t TKNEN2     : 1;
  __IO  uint8_t TGGL       : 1;
} stc_usb_htoken_field_t;

typedef struct stc_usb_udcc_field
{
  __IO uint16_t PWC        : 1;
  __IO uint16_t RFBK       : 1;
       uint16_t RESERVED1  : 1;
  __IO uint16_t STALCLREN  : 1;
  __IO uint16_t USTP       : 1;
  __IO uint16_t HCONX      : 1;
  __IO uint16_t RESUM      : 1;
  __IO uint16_t RST        : 1;
} stc_usb_udcc_field_t;

typedef struct stc_usb_ep0c_field
{
  __IO uint16_t PKS00      : 1;
  __IO uint16_t PKS01      : 1;
  __IO uint16_t PKS02      : 1;
  __IO uint16_t PKS03      : 1;
  __IO uint16_t PKS04      : 1;
  __IO uint16_t PKS05      : 1;
  __IO uint16_t PKS06      : 1;
       uint16_t RESERVED1  : 2;
  __IO uint16_t STAL       : 1;
} stc_usb_ep0c_field_t;

typedef struct stc_usb_ep1c_field
{
  __IO uint16_t PKS10      : 1;
  __IO uint16_t PKS11      : 1;
  __IO uint16_t PKS12      : 1;
  __IO uint16_t PKS13      : 1;
  __IO uint16_t PKS14      : 1;
  __IO uint16_t PKS15      : 1;
  __IO uint16_t PKS16      : 1;
  __IO uint16_t PKS17      : 1;
  __IO uint16_t PKS18      : 1;
  __IO uint16_t STAL       : 1;
  __IO uint16_t NULE       : 1;
  __IO uint16_t DMAE       : 1;
  __IO uint16_t DIR        : 1;
  __IO uint16_t TYPE0      : 1;
  __IO uint16_t TYPE1      : 1;
  __IO uint16_t EPEN       : 1;
} stc_usb_ep1c_field_t;

typedef struct stc_usb_ep2c_field
{
  __IO uint16_t PKS20      : 1;
  __IO uint16_t PKS21      : 1;
  __IO uint16_t PKS22      : 1;
  __IO uint16_t PKS23      : 1;
  __IO uint16_t PKS24      : 1;
  __IO uint16_t PKS25      : 1;
  __IO uint16_t PKS26      : 1;
       uint16_t RESERVED1  : 2;
  __IO uint16_t STAL       : 1;
  __IO uint16_t NULE       : 1;
  __IO uint16_t DMAE       : 1;
  __IO uint16_t DIR        : 1;
  __IO uint16_t TYPE0      : 1;
  __IO uint16_t TYPE1      : 1;
  __IO uint16_t EPEN       : 1;
} stc_usb_ep2c_field_t;

typedef struct stc_usb_ep3c_field
{
  __IO uint16_t PKS30      : 1;
  __IO uint16_t PKS31      : 1;
  __IO uint16_t PKS32      : 1;
  __IO uint16_t PKS33      : 1;
  __IO uint16_t PKS34      : 1;
  __IO uint16_t PKS35      : 1;
  __IO uint16_t PKS36      : 1;
       uint16_t RESERVED1  : 2;
  __IO uint16_t STAL       : 1;
  __IO uint16_t NULE       : 1;
  __IO uint16_t DMAE       : 1;
  __IO uint16_t DIR        : 1;
  __IO uint16_t TYPE0      : 1;
  __IO uint16_t TYPE1      : 1;
  __IO uint16_t EPEN       : 1;
} stc_usb_ep3c_field_t;

typedef struct stc_usb_ep4c_field
{
  __IO uint16_t PKS40      : 1;
  __IO uint16_t PKS41      : 1;
  __IO uint16_t PKS42      : 1;
  __IO uint16_t PKS43      : 1;
  __IO uint16_t PKS44      : 1;
  __IO uint16_t PKS45      : 1;
  __IO uint16_t PKS46      : 1;
       uint16_t RESERVED1  : 2;
  __IO uint16_t STAL       : 1;
  __IO uint16_t NULE       : 1;
  __IO uint16_t DMAE       : 1;
  __IO uint16_t DIR        : 1;
  __IO uint16_t TYPE0      : 1;
  __IO uint16_t TYPE1      : 1;
  __IO uint16_t EPEN       : 1;
} stc_usb_ep4c_field_t;

typedef struct stc_usb_ep5c_field
{
  __IO uint16_t PKS50      : 1;
  __IO uint16_t PKS51      : 1;
  __IO uint16_t PKS52      : 1;
  __IO uint16_t PKS53      : 1;
  __IO uint16_t PKS54      : 1;
  __IO uint16_t PKS55      : 1;
  __IO uint16_t PKS56      : 1;
       uint16_t RESERVED1  : 2;
  __IO uint16_t STAL       : 1;
  __IO uint16_t NULE       : 1;
  __IO uint16_t DMAE       : 1;
  __IO uint16_t DIR        : 1;
  __IO uint16_t TYPE0      : 1;
  __IO uint16_t TYPE1      : 1;
  __IO uint16_t EPEN       : 1;
} stc_usb_ep5c_field_t;

typedef struct stc_usb_tmsp_field
{
  __IO uint16_t TMSP0      : 1;
  __IO uint16_t TMSP1      : 1;
  __IO uint16_t TMSP2      : 1;
  __IO uint16_t TMSP3      : 1;
  __IO uint16_t TMSP4      : 1;
  __IO uint16_t TMSP5      : 1;
  __IO uint16_t TMSP6      : 1;
  __IO uint16_t TMSP7      : 1;
  __IO uint16_t TMSP8      : 1;
  __IO uint16_t TMSP9      : 1;
  __IO uint16_t TMSP10     : 1;
} stc_usb_tmsp_field_t;

typedef struct stc_usb_udcs_field
{
  __IO  uint8_t CONF       : 1;
  __IO  uint8_t SETP       : 1;
  __IO  uint8_t WKUP       : 1;
  __IO  uint8_t BRST       : 1;
  __IO  uint8_t SOF        : 1;
  __IO  uint8_t SUSP       : 1;
} stc_usb_udcs_field_t;

typedef struct stc_usb_udcie_field
{
  __IO  uint8_t CONFIE     : 1;
  __IO  uint8_t CONFN      : 1;
  __IO  uint8_t WKUPIE     : 1;
  __IO  uint8_t BRSTIE     : 1;
  __IO  uint8_t SOFIE      : 1;
  __IO  uint8_t SUSPIE     : 1;
} stc_usb_udcie_field_t;

typedef struct stc_usb_ep0is_field
{
       uint16_t RESERVED1  : 10;
  __IO uint16_t DRQI       : 1;
       uint16_t RESERVED2  : 3;
  __IO uint16_t DRQIIE     : 1;
  __IO uint16_t BFINI      : 1;
} stc_usb_ep0is_field_t;

typedef struct stc_usb_ep0os_field
{
  __IO uint16_t SIZE0      : 1;
  __IO uint16_t SIZE1      : 1;
  __IO uint16_t SIZE2      : 1;
  __IO uint16_t SIZE3      : 1;
  __IO uint16_t SIZE4      : 1;
  __IO uint16_t SIZE5      : 1;
  __IO uint16_t SIZE6      : 1;
       uint16_t RESERVED1  : 2;
  __IO uint16_t SPK        : 1;
  __IO uint16_t DRQO       : 1;
       uint16_t RESERVED2  : 2;
  __IO uint16_t SPKIE      : 1;
  __IO uint16_t DRQOIE     : 1;
  __IO uint16_t BFINI      : 1;
} stc_usb_ep0os_field_t;

typedef struct stc_usb_ep1s_field
{
  __IO uint16_t SIZE10     : 1;
  __IO uint16_t SIZE11     : 1;
  __IO uint16_t SIZE12     : 1;
  __IO uint16_t SIZE13     : 1;
  __IO uint16_t SIZE14     : 1;
  __IO uint16_t SIZE15     : 1;
  __IO uint16_t SIZE16     : 1;
  __IO uint16_t SIZE17     : 1;
  __IO uint16_t SIZE18     : 1;
  __IO uint16_t SPK        : 1;
  __IO uint16_t DRQ        : 1;
  __IO uint16_t BUSY       : 1;
       uint16_t RESERVED1  : 1;
  __IO uint16_t SPKIE      : 1;
  __IO uint16_t DRQIE      : 1;
  __IO uint16_t BFINI      : 1;
} stc_usb_ep1s_field_t;

typedef struct stc_usb_ep2s_field
{
  __IO uint16_t SIZE20     : 1;
  __IO uint16_t SIZE21     : 1;
  __IO uint16_t SIZE22     : 1;
  __IO uint16_t SIZE23     : 1;
  __IO uint16_t SIZE24     : 1;
  __IO uint16_t SIZE25     : 1;
  __IO uint16_t SIZE26     : 1;
       uint16_t RESERVED1  : 2;
  __IO uint16_t SPK        : 1;
  __IO uint16_t DRQ        : 1;
  __IO uint16_t BUSY       : 1;
       uint16_t RESERVED2  : 1;
  __IO uint16_t SPKIE      : 1;
  __IO uint16_t DRQIE      : 1;
  __IO uint16_t BFINI      : 1;
} stc_usb_ep2s_field_t;

typedef struct stc_usb_ep4s_field
{
  __IO uint16_t SIZE40     : 1;
  __IO uint16_t SIZE41     : 1;
  __IO uint16_t SIZE42     : 1;
  __IO uint16_t SIZE43     : 1;
  __IO uint16_t SIZE44     : 1;
  __IO uint16_t SIZE45     : 1;
  __IO uint16_t SIZE46     : 1;
       uint16_t RESERVED1  : 2;
  __IO uint16_t SPK        : 1;
  __IO uint16_t DRQ        : 1;
  __IO uint16_t BUSY       : 1;
       uint16_t RESERVED2  : 1;
  __IO uint16_t SPKIE      : 1;
  __IO uint16_t DRQIE      : 1;
  __IO uint16_t BFINI      : 1;
} stc_usb_ep4s_field_t;

typedef struct stc_usb_ep5s_field
{
  __IO uint16_t SIZE50     : 1;
  __IO uint16_t SIZE51     : 1;
  __IO uint16_t SIZE52     : 1;
  __IO uint16_t SIZE53     : 1;
  __IO uint16_t SIZE54     : 1;
  __IO uint16_t SIZE55     : 1;
  __IO uint16_t SIZE56     : 1;
       uint16_t RESERVED1  : 2;
  __IO uint16_t SPK        : 1;
  __IO uint16_t DRQ        : 1;
  __IO uint16_t BUSY       : 1;
       uint16_t RESERVED2  : 1;
  __IO uint16_t SPKIE      : 1;
  __IO uint16_t DRQIE      : 1;
  __IO uint16_t BFINI      : 1;
} stc_usb_ep5s_field_t;

/******************************************************************************
 * DMAC_MODULE
 ******************************************************************************/
/* DMAC_MODULE register bit fields */
typedef struct stc_dmac_dmacr_field
{
       uint32_t RESERVED1  : 24;
  __IO uint32_t DH0        : 1;
  __IO uint32_t DH1        : 1;
  __IO uint32_t DH2        : 1;
  __IO uint32_t DH3        : 1;
  __IO uint32_t PR         : 1;
       uint32_t RESERVED2  : 1;
  __IO uint32_t DS         : 1;
  __IO uint32_t DE         : 1;
} stc_dmac_dmacr_field_t;

typedef struct stc_dmac_dmaca0_field
{
  __IO uint32_t TC0        : 1;
  __IO uint32_t TC1        : 1;
  __IO uint32_t TC2        : 1;
  __IO uint32_t TC3        : 1;
  __IO uint32_t TC4        : 1;
  __IO uint32_t TC5        : 1;
  __IO uint32_t TC6        : 1;
  __IO uint32_t TC7        : 1;
  __IO uint32_t TC8        : 1;
  __IO uint32_t TC9        : 1;
  __IO uint32_t TC10       : 1;
  __IO uint32_t TC11       : 1;
  __IO uint32_t TC12       : 1;
  __IO uint32_t TC13       : 1;
  __IO uint32_t TC14       : 1;
  __IO uint32_t TC15       : 1;
  __IO uint32_t BC0        : 1;
  __IO uint32_t BC1        : 1;
  __IO uint32_t BC2        : 1;
  __IO uint32_t BC3        : 1;
       uint32_t RESERVED1  : 3;
  __IO uint32_t IS0        : 1;
  __IO uint32_t IS1        : 1;
  __IO uint32_t IS2        : 1;
  __IO uint32_t IS3        : 1;
  __IO uint32_t IS4        : 1;
  __IO uint32_t IS5        : 1;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca0_field_t;

typedef struct stc_dmac_dmacb0_field
{
  __IO uint32_t EM         : 1;
       uint32_t RESERVED1  : 15;
  __IO uint32_t SS0        : 1;
  __IO uint32_t SS1        : 1;
  __IO uint32_t SS2        : 1;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW0        : 1;
  __IO uint32_t TW1        : 1;
  __IO uint32_t MS0        : 1;
  __IO uint32_t MS1        : 1;
} stc_dmac_dmacb0_field_t;

typedef struct stc_dmac_dmaca1_field
{
  __IO uint32_t TC0        : 1;
  __IO uint32_t TC1        : 1;
  __IO uint32_t TC2        : 1;
  __IO uint32_t TC3        : 1;
  __IO uint32_t TC4        : 1;
  __IO uint32_t TC5        : 1;
  __IO uint32_t TC6        : 1;
  __IO uint32_t TC7        : 1;
  __IO uint32_t TC8        : 1;
  __IO uint32_t TC9        : 1;
  __IO uint32_t TC10       : 1;
  __IO uint32_t TC11       : 1;
  __IO uint32_t TC12       : 1;
  __IO uint32_t TC13       : 1;
  __IO uint32_t TC14       : 1;
  __IO uint32_t TC15       : 1;
  __IO uint32_t BC0        : 1;
  __IO uint32_t BC1        : 1;
  __IO uint32_t BC2        : 1;
  __IO uint32_t BC3        : 1;
       uint32_t RESERVED1  : 3;
  __IO uint32_t IS0        : 1;
  __IO uint32_t IS1        : 1;
  __IO uint32_t IS2        : 1;
  __IO uint32_t IS3        : 1;
  __IO uint32_t IS4        : 1;
  __IO uint32_t IS5        : 1;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca1_field_t;

typedef struct stc_dmac_dmacb1_field
{
  __IO uint32_t EM         : 1;
       uint32_t RESERVED1  : 15;
  __IO uint32_t SS0        : 1;
  __IO uint32_t SS1        : 1;
  __IO uint32_t SS2        : 1;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW0        : 1;
  __IO uint32_t TW1        : 1;
  __IO uint32_t MS0        : 1;
  __IO uint32_t MS1        : 1;
} stc_dmac_dmacb1_field_t;

typedef struct stc_dmac_dmaca2_field
{
  __IO uint32_t TC0        : 1;
  __IO uint32_t TC1        : 1;
  __IO uint32_t TC2        : 1;
  __IO uint32_t TC3        : 1;
  __IO uint32_t TC4        : 1;
  __IO uint32_t TC5        : 1;
  __IO uint32_t TC6        : 1;
  __IO uint32_t TC7        : 1;
  __IO uint32_t TC8        : 1;
  __IO uint32_t TC9        : 1;
  __IO uint32_t TC10       : 1;
  __IO uint32_t TC11       : 1;
  __IO uint32_t TC12       : 1;
  __IO uint32_t TC13       : 1;
  __IO uint32_t TC14       : 1;
  __IO uint32_t TC15       : 1;
  __IO uint32_t BC0        : 1;
  __IO uint32_t BC1        : 1;
  __IO uint32_t BC2        : 1;
  __IO uint32_t BC3        : 1;
       uint32_t RESERVED1  : 3;
  __IO uint32_t IS0        : 1;
  __IO uint32_t IS1        : 1;
  __IO uint32_t IS2        : 1;
  __IO uint32_t IS3        : 1;
  __IO uint32_t IS4        : 1;
  __IO uint32_t IS5        : 1;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca2_field_t;

typedef struct stc_dmac_dmacb2_field
{
  __IO uint32_t EM         : 1;
       uint32_t RESERVED1  : 15;
  __IO uint32_t SS0        : 1;
  __IO uint32_t SS1        : 1;
  __IO uint32_t SS2        : 1;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW0        : 1;
  __IO uint32_t TW1        : 1;
  __IO uint32_t MS0        : 1;
  __IO uint32_t MS1        : 1;
} stc_dmac_dmacb2_field_t;

typedef struct stc_dmac_dmaca3_field
{
  __IO uint32_t TC0        : 1;
  __IO uint32_t TC1        : 1;
  __IO uint32_t TC2        : 1;
  __IO uint32_t TC3        : 1;
  __IO uint32_t TC4        : 1;
  __IO uint32_t TC5        : 1;
  __IO uint32_t TC6        : 1;
  __IO uint32_t TC7        : 1;
  __IO uint32_t TC8        : 1;
  __IO uint32_t TC9        : 1;
  __IO uint32_t TC10       : 1;
  __IO uint32_t TC11       : 1;
  __IO uint32_t TC12       : 1;
  __IO uint32_t TC13       : 1;
  __IO uint32_t TC14       : 1;
  __IO uint32_t TC15       : 1;
  __IO uint32_t BC0        : 1;
  __IO uint32_t BC1        : 1;
  __IO uint32_t BC2        : 1;
  __IO uint32_t BC3        : 1;
       uint32_t RESERVED1  : 3;
  __IO uint32_t IS0        : 1;
  __IO uint32_t IS1        : 1;
  __IO uint32_t IS2        : 1;
  __IO uint32_t IS3        : 1;
  __IO uint32_t IS4        : 1;
  __IO uint32_t IS5        : 1;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca3_field_t;

typedef struct stc_dmac_dmacb3_field
{
  __IO uint32_t EM         : 1;
       uint32_t RESERVED1  : 15;
  __IO uint32_t SS0        : 1;
  __IO uint32_t SS1        : 1;
  __IO uint32_t SS2        : 1;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW0        : 1;
  __IO uint32_t TW1        : 1;
  __IO uint32_t MS0        : 1;
  __IO uint32_t MS1        : 1;
} stc_dmac_dmacb3_field_t;

typedef struct stc_dmac_dmaca4_field
{
  __IO uint32_t TC0        : 1;
  __IO uint32_t TC1        : 1;
  __IO uint32_t TC2        : 1;
  __IO uint32_t TC3        : 1;
  __IO uint32_t TC4        : 1;
  __IO uint32_t TC5        : 1;
  __IO uint32_t TC6        : 1;
  __IO uint32_t TC7        : 1;
  __IO uint32_t TC8        : 1;
  __IO uint32_t TC9        : 1;
  __IO uint32_t TC10       : 1;
  __IO uint32_t TC11       : 1;
  __IO uint32_t TC12       : 1;
  __IO uint32_t TC13       : 1;
  __IO uint32_t TC14       : 1;
  __IO uint32_t TC15       : 1;
  __IO uint32_t BC0        : 1;
  __IO uint32_t BC1        : 1;
  __IO uint32_t BC2        : 1;
  __IO uint32_t BC3        : 1;
       uint32_t RESERVED1  : 3;
  __IO uint32_t IS0        : 1;
  __IO uint32_t IS1        : 1;
  __IO uint32_t IS2        : 1;
  __IO uint32_t IS3        : 1;
  __IO uint32_t IS4        : 1;
  __IO uint32_t IS5        : 1;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca4_field_t;

typedef struct stc_dmac_dmacb4_field
{
  __IO uint32_t EM         : 1;
       uint32_t RESERVED1  : 15;
  __IO uint32_t SS0        : 1;
  __IO uint32_t SS1        : 1;
  __IO uint32_t SS2        : 1;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW0        : 1;
  __IO uint32_t TW1        : 1;
  __IO uint32_t MS0        : 1;
  __IO uint32_t MS1        : 1;
} stc_dmac_dmacb4_field_t;

typedef struct stc_dmac_dmaca5_field
{
  __IO uint32_t TC0        : 1;
  __IO uint32_t TC1        : 1;
  __IO uint32_t TC2        : 1;
  __IO uint32_t TC3        : 1;
  __IO uint32_t TC4        : 1;
  __IO uint32_t TC5        : 1;
  __IO uint32_t TC6        : 1;
  __IO uint32_t TC7        : 1;
  __IO uint32_t TC8        : 1;
  __IO uint32_t TC9        : 1;
  __IO uint32_t TC10       : 1;
  __IO uint32_t TC11       : 1;
  __IO uint32_t TC12       : 1;
  __IO uint32_t TC13       : 1;
  __IO uint32_t TC14       : 1;
  __IO uint32_t TC15       : 1;
  __IO uint32_t BC0        : 1;
  __IO uint32_t BC1        : 1;
  __IO uint32_t BC2        : 1;
  __IO uint32_t BC3        : 1;
       uint32_t RESERVED1  : 3;
  __IO uint32_t IS0        : 1;
  __IO uint32_t IS1        : 1;
  __IO uint32_t IS2        : 1;
  __IO uint32_t IS3        : 1;
  __IO uint32_t IS4        : 1;
  __IO uint32_t IS5        : 1;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca5_field_t;

typedef struct stc_dmac_dmacb5_field
{
  __IO uint32_t EM         : 1;
       uint32_t RESERVED1  : 15;
  __IO uint32_t SS0        : 1;
  __IO uint32_t SS1        : 1;
  __IO uint32_t SS2        : 1;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW0        : 1;
  __IO uint32_t TW1        : 1;
  __IO uint32_t MS0        : 1;
  __IO uint32_t MS1        : 1;
} stc_dmac_dmacb5_field_t;

typedef struct stc_dmac_dmaca6_field
{
  __IO uint32_t TC0        : 1;
  __IO uint32_t TC1        : 1;
  __IO uint32_t TC2        : 1;
  __IO uint32_t TC3        : 1;
  __IO uint32_t TC4        : 1;
  __IO uint32_t TC5        : 1;
  __IO uint32_t TC6        : 1;
  __IO uint32_t TC7        : 1;
  __IO uint32_t TC8        : 1;
  __IO uint32_t TC9        : 1;
  __IO uint32_t TC10       : 1;
  __IO uint32_t TC11       : 1;
  __IO uint32_t TC12       : 1;
  __IO uint32_t TC13       : 1;
  __IO uint32_t TC14       : 1;
  __IO uint32_t TC15       : 1;
  __IO uint32_t BC0        : 1;
  __IO uint32_t BC1        : 1;
  __IO uint32_t BC2        : 1;
  __IO uint32_t BC3        : 1;
       uint32_t RESERVED1  : 3;
  __IO uint32_t IS0        : 1;
  __IO uint32_t IS1        : 1;
  __IO uint32_t IS2        : 1;
  __IO uint32_t IS3        : 1;
  __IO uint32_t IS4        : 1;
  __IO uint32_t IS5        : 1;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca6_field_t;

typedef struct stc_dmac_dmacb6_field
{
  __IO uint32_t EM         : 1;
       uint32_t RESERVED1  : 15;
  __IO uint32_t SS0        : 1;
  __IO uint32_t SS1        : 1;
  __IO uint32_t SS2        : 1;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW0        : 1;
  __IO uint32_t TW1        : 1;
  __IO uint32_t MS0        : 1;
  __IO uint32_t MS1        : 1;
} stc_dmac_dmacb6_field_t;

typedef struct stc_dmac_dmaca7_field
{
  __IO uint32_t TC0        : 1;
  __IO uint32_t TC1        : 1;
  __IO uint32_t TC2        : 1;
  __IO uint32_t TC3        : 1;
  __IO uint32_t TC4        : 1;
  __IO uint32_t TC5        : 1;
  __IO uint32_t TC6        : 1;
  __IO uint32_t TC7        : 1;
  __IO uint32_t TC8        : 1;
  __IO uint32_t TC9        : 1;
  __IO uint32_t TC10       : 1;
  __IO uint32_t TC11       : 1;
  __IO uint32_t TC12       : 1;
  __IO uint32_t TC13       : 1;
  __IO uint32_t TC14       : 1;
  __IO uint32_t TC15       : 1;
  __IO uint32_t BC0        : 1;
  __IO uint32_t BC1        : 1;
  __IO uint32_t BC2        : 1;
  __IO uint32_t BC3        : 1;
       uint32_t RESERVED1  : 3;
  __IO uint32_t IS0        : 1;
  __IO uint32_t IS1        : 1;
  __IO uint32_t IS2        : 1;
  __IO uint32_t IS3        : 1;
  __IO uint32_t IS4        : 1;
  __IO uint32_t IS5        : 1;
  __IO uint32_t ST         : 1;
  __IO uint32_t PB         : 1;
  __IO uint32_t EB         : 1;
} stc_dmac_dmaca7_field_t;

typedef struct stc_dmac_dmacb7_field
{
  __IO uint32_t EM         : 1;
       uint32_t RESERVED1  : 15;
  __IO uint32_t SS0        : 1;
  __IO uint32_t SS1        : 1;
  __IO uint32_t SS2        : 1;
  __IO uint32_t CI         : 1;
  __IO uint32_t EI         : 1;
  __IO uint32_t RD         : 1;
  __IO uint32_t RS         : 1;
  __IO uint32_t RC         : 1;
  __IO uint32_t FD         : 1;
  __IO uint32_t FS         : 1;
  __IO uint32_t TW0        : 1;
  __IO uint32_t TW1        : 1;
  __IO uint32_t MS0        : 1;
  __IO uint32_t MS1        : 1;
} stc_dmac_dmacb7_field_t;

/******************************************************************************
 * CAN_MODULE
 ******************************************************************************/
/* CAN_MODULE register bit fields */
typedef struct stc_can_ctrlr_field
{
  __IO uint16_t INIT       : 1;
  __IO uint16_t IE         : 1;
  __IO uint16_t SIE        : 1;
  __IO uint16_t EIE        : 1;
       uint16_t RESERVED1  : 1;
  __IO uint16_t DAR        : 1;
  __IO uint16_t CCE        : 1;
  __IO uint16_t TEST       : 1;
} stc_can_ctrlr_field_t;

typedef struct stc_can_statr_field
{
  __IO uint16_t LEC0       : 1;
  __IO uint16_t LEC1       : 1;
  __IO uint16_t LEC2       : 1;
  __IO uint16_t TXOK       : 1;
  __IO uint16_t RXOK       : 1;
  __IO uint16_t EPASS      : 1;
  __IO uint16_t EWARM      : 1;
  __IO uint16_t BOFF       : 1;
} stc_can_statr_field_t;

typedef struct stc_can_errcnt_field
{
  __IO uint16_t TEC0       : 1;
  __IO uint16_t TEC1       : 1;
  __IO uint16_t TEC2       : 1;
  __IO uint16_t TEC3       : 1;
  __IO uint16_t TEC4       : 1;
  __IO uint16_t TEC5       : 1;
  __IO uint16_t TEC6       : 1;
  __IO uint16_t TEC7       : 1;
  __IO uint16_t REC0       : 1;
  __IO uint16_t REC1       : 1;
  __IO uint16_t REC2       : 1;
  __IO uint16_t REC3       : 1;
  __IO uint16_t REC4       : 1;
  __IO uint16_t REC5       : 1;
  __IO uint16_t REC6       : 1;
  __IO uint16_t RP         : 1;
} stc_can_errcnt_field_t;

typedef struct stc_can_btr_field
{
  __IO uint16_t BRP0       : 1;
  __IO uint16_t BRP1       : 1;
  __IO uint16_t BRP2       : 1;
  __IO uint16_t BRP3       : 1;
  __IO uint16_t BRP4       : 1;
  __IO uint16_t BRP5       : 1;
  __IO uint16_t SJW0       : 1;
  __IO uint16_t SJW1       : 1;
  __IO uint16_t TSEG10     : 1;
  __IO uint16_t TSEG11     : 1;
  __IO uint16_t TSEG12     : 1;
  __IO uint16_t TSEG13     : 1;
  __IO uint16_t TSEG20     : 1;
  __IO uint16_t TSEG21     : 1;
  __IO uint16_t TSEG22     : 1;
} stc_can_btr_field_t;

typedef struct stc_can_intr_field
{
  __IO uint16_t INTID0     : 1;
  __IO uint16_t INTID1     : 1;
  __IO uint16_t INTID2     : 1;
  __IO uint16_t INTID3     : 1;
  __IO uint16_t INTID4     : 1;
  __IO uint16_t INTID5     : 1;
  __IO uint16_t INTID6     : 1;
  __IO uint16_t INTID7     : 1;
  __IO uint16_t INTID8     : 1;
  __IO uint16_t INTID9     : 1;
  __IO uint16_t INTID10    : 1;
  __IO uint16_t INTID11    : 1;
  __IO uint16_t INTID12    : 1;
  __IO uint16_t INTID13    : 1;
  __IO uint16_t INTID14    : 1;
  __IO uint16_t INTID15    : 1;
} stc_can_intr_field_t;

typedef struct stc_can_testr_field
{
       uint16_t RESERVED1  : 2;
  __IO uint16_t BASIC      : 1;
  __IO uint16_t SILENT     : 1;
  __IO uint16_t LBACK      : 1;
  __IO uint16_t TX0        : 1;
  __IO uint16_t TX1        : 1;
  __IO uint16_t RX         : 1;
} stc_can_testr_field_t;

typedef struct stc_can_brper_field
{
  __IO uint16_t BRPE0      : 1;
  __IO uint16_t BRPE1      : 1;
  __IO uint16_t BRPE2      : 1;
  __IO uint16_t BRPE3      : 1;
} stc_can_brper_field_t;

typedef struct stc_can_if1creq_field
{
       uint16_t RESERVED1  : 15;
  __IO uint16_t BUSY       : 1;
} stc_can_if1creq_field_t;

typedef struct stc_can_if1cmsk_field
{
  __IO uint16_t DATAB      : 1;
  __IO uint16_t DATAA      : 1;
  __IO uint16_t NEWDAT     : 1;
  __IO uint16_t CIP        : 1;
  __IO uint16_t CONTROL    : 1;
  __IO uint16_t ARB        : 1;
  __IO uint16_t MASK       : 1;
  __IO uint16_t WRRD       : 1;
} stc_can_if1cmsk_field_t;

typedef struct stc_can_if1msk_field
{
  __IO uint32_t MSK        : 29;
       uint32_t RESERVED1  : 1;
  __IO uint32_t MDIR       : 1;
  __IO uint32_t MXTD       : 1;
} stc_can_if1msk_field_t;

typedef struct stc_can_if1msk2_field
{
  __IO uint16_t MSK        : 13;
       uint16_t RESERVED1  : 1;
  __IO uint16_t MDIR       : 1;
  __IO uint16_t MXTD       : 1;
} stc_can_if1msk2_field_t;

typedef struct stc_can_if1arb_field
{
  __IO uint32_t ID         : 29;
  __IO uint32_t DIR        : 1;
  __IO uint32_t XTD        : 1;
  __IO uint32_t MSGVAL     : 1;
} stc_can_if1arb_field_t;

typedef struct stc_can_if1arb2_field
{
  __IO uint16_t ID         : 13;
  __IO uint16_t DIR        : 1;
  __IO uint16_t XTD        : 1;
  __IO uint16_t MSGVAL     : 1;
} stc_can_if1arb2_field_t;

typedef struct stc_can_if1mctr_field
{
  __IO uint16_t DLC0       : 1;
  __IO uint16_t DLC1       : 1;
  __IO uint16_t DLC2       : 1;
  __IO uint16_t DLC3       : 1;
       uint16_t RESERVED1  : 3;
  __IO uint16_t EOB        : 1;
  __IO uint16_t TXRQST     : 1;
  __IO uint16_t RMTEN      : 1;
  __IO uint16_t RXIE       : 1;
  __IO uint16_t TXIE       : 1;
  __IO uint16_t UMASK      : 1;
  __IO uint16_t INTPND     : 1;
  __IO uint16_t MSGLST     : 1;
  __IO uint16_t NEWDAT     : 1;
} stc_can_if1mctr_field_t;

typedef struct stc_can_if2creq_field
{
       uint16_t RESERVED1  : 15;
  __IO uint16_t BUSY       : 1;
} stc_can_if2creq_field_t;

typedef struct stc_can_if2cmsk_field
{
  __IO uint16_t DATAB      : 1;
  __IO uint16_t DATAA      : 1;
  __IO uint16_t NEWDAT     : 1;
  __IO uint16_t CIP        : 1;
  __IO uint16_t CONTROL    : 1;
  __IO uint16_t ARB        : 1;
  __IO uint16_t MASK       : 1;
  __IO uint16_t WRRD       : 1;
} stc_can_if2cmsk_field_t;

typedef struct stc_can_if2msk_field
{
  __IO uint32_t MSK        : 29;
       uint32_t RESERVED1  : 1;
  __IO uint32_t MDIR       : 1;
  __IO uint32_t MXTD       : 1;
} stc_can_if2msk_field_t;

typedef struct stc_can_if2msk2_field
{
  __IO uint16_t MSK        : 13;
       uint16_t RESERVED1  : 1;
  __IO uint16_t MDIR       : 1;
  __IO uint16_t MXTD       : 1;
} stc_can_if2msk2_field_t;

typedef struct stc_can_if2arb_field
{
  __IO uint32_t ID         : 29;
  __IO uint32_t DIR        : 1;
  __IO uint32_t XTD        : 1;
  __IO uint32_t MSGVAL     : 1;
} stc_can_if2arb_field_t;

typedef struct stc_can_if2arb2_field
{
  __IO uint16_t ID         : 13;
  __IO uint16_t DIR        : 1;
  __IO uint16_t XTD        : 1;
  __IO uint16_t MSGVAL     : 1;
} stc_can_if2arb2_field_t;

typedef struct stc_can_if2mctr_field
{
  __IO uint16_t DLC0       : 1;
  __IO uint16_t DLC1       : 1;
  __IO uint16_t DLC2       : 1;
  __IO uint16_t DLC3       : 1;
       uint16_t RESERVED1  : 3;
  __IO uint16_t EOB        : 1;
  __IO uint16_t TXRQST     : 1;
  __IO uint16_t RMTEN      : 1;
  __IO uint16_t RXIE       : 1;
  __IO uint16_t TXIE       : 1;
  __IO uint16_t UMASK      : 1;
  __IO uint16_t INTPND     : 1;
  __IO uint16_t MSGLST     : 1;
  __IO uint16_t NEWDAT     : 1;
} stc_can_if2mctr_field_t;

typedef struct stc_can_treqr_field
{
  __IO uint32_t TXRQST1    : 1;
  __IO uint32_t TXRQST2    : 1;
  __IO uint32_t TXRQST3    : 1;
  __IO uint32_t TXRQST4    : 1;
  __IO uint32_t TXRQST5    : 1;
  __IO uint32_t TXRQST6    : 1;
  __IO uint32_t TXRQST7    : 1;
  __IO uint32_t TXRQST8    : 1;
  __IO uint32_t TXRQST9    : 1;
  __IO uint32_t TXRQST10   : 1;
  __IO uint32_t TXRQST11   : 1;
  __IO uint32_t TXRQST12   : 1;
  __IO uint32_t TXRQST13   : 1;
  __IO uint32_t TXRQST14   : 1;
  __IO uint32_t TXRQST15   : 1;
  __IO uint32_t TXRQST16   : 1;
  __IO uint32_t TXRQST17   : 1;
  __IO uint32_t TXRQST18   : 1;
  __IO uint32_t TXRQST19   : 1;
  __IO uint32_t TXRQST20   : 1;
  __IO uint32_t TXRQST21   : 1;
  __IO uint32_t TXRQST22   : 1;
  __IO uint32_t TXRQST23   : 1;
  __IO uint32_t TXRQST24   : 1;
  __IO uint32_t TXRQST25   : 1;
  __IO uint32_t TXRQST26   : 1;
  __IO uint32_t TXRQST27   : 1;
  __IO uint32_t TXRQST28   : 1;
  __IO uint32_t TXRQST29   : 1;
  __IO uint32_t TXRQST30   : 1;
  __IO uint32_t TXRQST31   : 1;
  __IO uint32_t TXRQST32   : 1;
} stc_can_treqr_field_t;

typedef struct stc_can_treqr1_field
{
  __IO uint16_t TXRQST1    : 1;
  __IO uint16_t TXRQST2    : 1;
  __IO uint16_t TXRQST3    : 1;
  __IO uint16_t TXRQST4    : 1;
  __IO uint16_t TXRQST5    : 1;
  __IO uint16_t TXRQST6    : 1;
  __IO uint16_t TXRQST7    : 1;
  __IO uint16_t TXRQST8    : 1;
  __IO uint16_t TXRQST9    : 1;
  __IO uint16_t TXRQST10   : 1;
  __IO uint16_t TXRQST11   : 1;
  __IO uint16_t TXRQST12   : 1;
  __IO uint16_t TXRQST13   : 1;
  __IO uint16_t TXRQST14   : 1;
  __IO uint16_t TXRQST15   : 1;
  __IO uint16_t TXRQST16   : 1;
} stc_can_treqr1_field_t;

typedef struct stc_can_treqr2_field
{
  __IO uint16_t TXRQST17   : 1;
  __IO uint16_t TXRQST18   : 1;
  __IO uint16_t TXRQST19   : 1;
  __IO uint16_t TXRQST20   : 1;
  __IO uint16_t TXRQST21   : 1;
  __IO uint16_t TXRQST22   : 1;
  __IO uint16_t TXRQST23   : 1;
  __IO uint16_t TXRQST24   : 1;
  __IO uint16_t TXRQST25   : 1;
  __IO uint16_t TXRQST26   : 1;
  __IO uint16_t TXRQST27   : 1;
  __IO uint16_t TXRQST28   : 1;
  __IO uint16_t TXRQST29   : 1;
  __IO uint16_t TXRQST30   : 1;
  __IO uint16_t TXRQST31   : 1;
  __IO uint16_t TXRQST32   : 1;
} stc_can_treqr2_field_t;

typedef struct stc_can_newdt_field
{
  __IO uint32_t NEWDAT1    : 1;
  __IO uint32_t NEWDAT2    : 1;
  __IO uint32_t NEWDAT3    : 1;
  __IO uint32_t NEWDAT4    : 1;
  __IO uint32_t NEWDAT5    : 1;
  __IO uint32_t NEWDAT6    : 1;
  __IO uint32_t NEWDAT7    : 1;
  __IO uint32_t NEWDAT8    : 1;
  __IO uint32_t NEWDAT9    : 1;
  __IO uint32_t NEWDAT10   : 1;
  __IO uint32_t NEWDAT11   : 1;
  __IO uint32_t NEWDAT12   : 1;
  __IO uint32_t NEWDAT13   : 1;
  __IO uint32_t NEWDAT14   : 1;
  __IO uint32_t NEWDAT15   : 1;
  __IO uint32_t NEWDAT16   : 1;
  __IO uint32_t NEWDAT17   : 1;
  __IO uint32_t NEWDAT18   : 1;
  __IO uint32_t NEWDAT19   : 1;
  __IO uint32_t NEWDAT20   : 1;
  __IO uint32_t NEWDAT21   : 1;
  __IO uint32_t NEWDAT22   : 1;
  __IO uint32_t NEWDAT23   : 1;
  __IO uint32_t NEWDAT24   : 1;
  __IO uint32_t NEWDAT25   : 1;
  __IO uint32_t NEWDAT26   : 1;
  __IO uint32_t NEWDAT27   : 1;
  __IO uint32_t NEWDAT28   : 1;
  __IO uint32_t NEWDAT29   : 1;
  __IO uint32_t NEWDAT30   : 1;
  __IO uint32_t NEWDAT31   : 1;
  __IO uint32_t NEWDAT32   : 1;
} stc_can_newdt_field_t;

typedef struct stc_can_newdt1_field
{
  __IO uint16_t NEWDAT1    : 1;
  __IO uint16_t NEWDAT2    : 1;
  __IO uint16_t NEWDAT3    : 1;
  __IO uint16_t NEWDAT4    : 1;
  __IO uint16_t NEWDAT5    : 1;
  __IO uint16_t NEWDAT6    : 1;
  __IO uint16_t NEWDAT7    : 1;
  __IO uint16_t NEWDAT8    : 1;
  __IO uint16_t NEWDAT9    : 1;
  __IO uint16_t NEWDAT10   : 1;
  __IO uint16_t NEWDAT11   : 1;
  __IO uint16_t NEWDAT12   : 1;
  __IO uint16_t NEWDAT13   : 1;
  __IO uint16_t NEWDAT14   : 1;
  __IO uint16_t NEWDAT15   : 1;
  __IO uint16_t NEWDAT16   : 1;
} stc_can_newdt1_field_t;

typedef struct stc_can_intpnd_field
{
  __IO uint32_t INTPND1    : 1;
  __IO uint32_t INTPND2    : 1;
  __IO uint32_t INTPND3    : 1;
  __IO uint32_t INTPND4    : 1;
  __IO uint32_t INTPND5    : 1;
  __IO uint32_t INTPND6    : 1;
  __IO uint32_t INTPND7    : 1;
  __IO uint32_t INTPND8    : 1;
  __IO uint32_t INTPND9    : 1;
  __IO uint32_t INTPND10   : 1;
  __IO uint32_t INTPND11   : 1;
  __IO uint32_t INTPND12   : 1;
  __IO uint32_t INTPND13   : 1;
  __IO uint32_t INTPND14   : 1;
  __IO uint32_t INTPND15   : 1;
  __IO uint32_t INTPND16   : 1;
  __IO uint32_t INTPND17   : 1;
  __IO uint32_t INTPND18   : 1;
  __IO uint32_t INTPND19   : 1;
  __IO uint32_t INTPND20   : 1;
  __IO uint32_t INTPND21   : 1;
  __IO uint32_t INTPND22   : 1;
  __IO uint32_t INTPND23   : 1;
  __IO uint32_t INTPND24   : 1;
  __IO uint32_t INTPND25   : 1;
  __IO uint32_t INTPND26   : 1;
  __IO uint32_t INTPND27   : 1;
  __IO uint32_t INTPND28   : 1;
  __IO uint32_t INTPND29   : 1;
  __IO uint32_t INTPND30   : 1;
  __IO uint32_t INTPND31   : 1;
  __IO uint32_t INTPND32   : 1;
} stc_can_intpnd_field_t;

typedef struct stc_can_intpnd1_field
{
  __IO uint16_t INTPND1    : 1;
  __IO uint16_t INTPND2    : 1;
  __IO uint16_t INTPND3    : 1;
  __IO uint16_t INTPND4    : 1;
  __IO uint16_t INTPND5    : 1;
  __IO uint16_t INTPND6    : 1;
  __IO uint16_t INTPND7    : 1;
  __IO uint16_t INTPND8    : 1;
  __IO uint16_t INTPND9    : 1;
  __IO uint16_t INTPND10   : 1;
  __IO uint16_t INTPND11   : 1;
  __IO uint16_t INTPND12   : 1;
  __IO uint16_t INTPND13   : 1;
  __IO uint16_t INTPND14   : 1;
  __IO uint16_t INTPND15   : 1;
  __IO uint16_t INTPND16   : 1;
} stc_can_intpnd1_field_t;

typedef struct stc_can_intpnd2_field
{
  __IO uint16_t INTPND17   : 1;
  __IO uint16_t INTPND18   : 1;
  __IO uint16_t INTPND19   : 1;
  __IO uint16_t INTPND20   : 1;
  __IO uint16_t INTPND21   : 1;
  __IO uint16_t INTPND22   : 1;
  __IO uint16_t INTPND23   : 1;
  __IO uint16_t INTPND24   : 1;
  __IO uint16_t INTPND25   : 1;
  __IO uint16_t INTPND26   : 1;
  __IO uint16_t INTPND27   : 1;
  __IO uint16_t INTPND28   : 1;
  __IO uint16_t INTPND29   : 1;
  __IO uint16_t INTPND30   : 1;
  __IO uint16_t INTPND31   : 1;
  __IO uint16_t INTPND32   : 1;
} stc_can_intpnd2_field_t;

typedef struct stc_can_msgval_field
{
  __IO uint32_t MSGVAL1    : 1;
  __IO uint32_t MSGVAL2    : 1;
  __IO uint32_t MSGVAL3    : 1;
  __IO uint32_t MSGVAL4    : 1;
  __IO uint32_t MSGVAL5    : 1;
  __IO uint32_t MSGVAL6    : 1;
  __IO uint32_t MSGVAL7    : 1;
  __IO uint32_t MSGVAL8    : 1;
  __IO uint32_t MSGVAL9    : 1;
  __IO uint32_t MSGVAL10   : 1;
  __IO uint32_t MSGVAL11   : 1;
  __IO uint32_t MSGVAL12   : 1;
  __IO uint32_t MSGVAL13   : 1;
  __IO uint32_t MSGVAL14   : 1;
  __IO uint32_t MSGVAL15   : 1;
  __IO uint32_t MSGVAL16   : 1;
  __IO uint32_t MSGVAL17   : 1;
  __IO uint32_t MSGVAL18   : 1;
  __IO uint32_t MSGVAL19   : 1;
  __IO uint32_t MSGVAL20   : 1;
  __IO uint32_t MSGVAL21   : 1;
  __IO uint32_t MSGVAL22   : 1;
  __IO uint32_t MSGVAL23   : 1;
  __IO uint32_t MSGVAL24   : 1;
  __IO uint32_t MSGVAL25   : 1;
  __IO uint32_t MSGVAL26   : 1;
  __IO uint32_t MSGVAL27   : 1;
  __IO uint32_t MSGVAL28   : 1;
  __IO uint32_t MSGVAL29   : 1;
  __IO uint32_t MSGVAL30   : 1;
  __IO uint32_t MSGVAL31   : 1;
  __IO uint32_t MSGVAL32   : 1;
} stc_can_msgval_field_t;

typedef struct stc_can_msgval1_field
{
  __IO uint16_t MSGVAL1    : 1;
  __IO uint16_t MSGVAL2    : 1;
  __IO uint16_t MSGVAL3    : 1;
  __IO uint16_t MSGVAL4    : 1;
  __IO uint16_t MSGVAL5    : 1;
  __IO uint16_t MSGVAL6    : 1;
  __IO uint16_t MSGVAL7    : 1;
  __IO uint16_t MSGVAL8    : 1;
  __IO uint16_t MSGVAL9    : 1;
  __IO uint16_t MSGVAL10   : 1;
  __IO uint16_t MSGVAL11   : 1;
  __IO uint16_t MSGVAL12   : 1;
  __IO uint16_t MSGVAL13   : 1;
  __IO uint16_t MSGVAL14   : 1;
  __IO uint16_t MSGVAL15   : 1;
  __IO uint16_t MSGVAL16   : 1;
} stc_can_msgval1_field_t;

typedef struct stc_can_msgval2_field
{
  __IO uint16_t MSGVAL17   : 1;
  __IO uint16_t MSGVAL18   : 1;
  __IO uint16_t MSGVAL19   : 1;
  __IO uint16_t MSGVAL20   : 1;
  __IO uint16_t MSGVAL21   : 1;
  __IO uint16_t MSGVAL22   : 1;
  __IO uint16_t MSGVAL23   : 1;
  __IO uint16_t MSGVAL24   : 1;
  __IO uint16_t MSGVAL25   : 1;
  __IO uint16_t MSGVAL26   : 1;
  __IO uint16_t MSGVAL27   : 1;
  __IO uint16_t MSGVAL28   : 1;
  __IO uint16_t MSGVAL29   : 1;
  __IO uint16_t MSGVAL30   : 1;
  __IO uint16_t MSGVAL31   : 1;
  __IO uint16_t MSGVAL32   : 1;
} stc_can_msgval2_field_t;

/******************************************************************************
 * ETHERNET_MAC_MODULE
 ******************************************************************************/
/* ETHERNET_MAC_MODULE register bit fields */
typedef struct stc_ethernet_mac_mcr_field
{
       uint32_t RESERVED1  : 2;
  __IO uint32_t RE         : 1;
  __IO uint32_t TE         : 1;
  __IO uint32_t DC         : 1;
  __IO uint32_t BL0        : 1;
  __IO uint32_t BL1        : 1;
  __IO uint32_t ACS        : 1;
  __IO uint32_t LUD        : 1;
  __IO uint32_t DR         : 1;
  __IO uint32_t IPC        : 1;
  __IO uint32_t DM         : 1;
  __IO uint32_t LM         : 1;
  __IO uint32_t DO         : 1;
  __IO uint32_t FES        : 1;
  __IO uint32_t PS         : 1;
  __IO uint32_t DCRS       : 1;
  __IO uint32_t IFG0       : 1;
  __IO uint32_t IFG1       : 1;
  __IO uint32_t IFG2       : 1;
  __IO uint32_t JE         : 1;
  __IO uint32_t BE         : 1;
  __IO uint32_t JD         : 1;
  __IO uint32_t WD         : 1;
  __IO uint32_t TC         : 1;
  __IO uint32_t CST        : 1;
} stc_ethernet_mac_mcr_field_t;

typedef struct stc_ethernet_mac_mffr_field
{
  __IO uint32_t PR         : 1;
  __IO uint32_t HUC        : 1;
  __IO uint32_t HMC        : 1;
  __IO uint32_t DAIF       : 1;
  __IO uint32_t PM         : 1;
  __IO uint32_t DB         : 1;
  __IO uint32_t PCF0       : 1;
  __IO uint32_t PCF1       : 1;
  __IO uint32_t SAIF       : 1;
  __IO uint32_t SAF        : 1;
  __IO uint32_t HPF        : 1;
       uint32_t RESERVED1  :20;
  __IO uint32_t RA         : 1;
} stc_ethernet_mac_mffr_field_t;

typedef struct stc_ethernet_mac_mhtrh_field
{
  __IO uint32_t HTH0       : 1;
  __IO uint32_t HTH1       : 1;
  __IO uint32_t HTH2       : 1;
  __IO uint32_t HTH3       : 1;
  __IO uint32_t HTH4       : 1;
  __IO uint32_t HTH5       : 1;
  __IO uint32_t HTH6       : 1;
  __IO uint32_t HTH7       : 1;
  __IO uint32_t HTH8       : 1;
  __IO uint32_t HTH9       : 1;
  __IO uint32_t HTH10      : 1;
  __IO uint32_t HTH11      : 1;
  __IO uint32_t HTH12      : 1;
  __IO uint32_t HTH13      : 1;
  __IO uint32_t HTH14      : 1;
  __IO uint32_t HTH15      : 1;
  __IO uint32_t HTH16      : 1;
  __IO uint32_t HTH17      : 1;
  __IO uint32_t HTH18      : 1;
  __IO uint32_t HTH19      : 1;
  __IO uint32_t HTH20      : 1;
  __IO uint32_t HTH21      : 1;
  __IO uint32_t HTH22      : 1;
  __IO uint32_t HTH23      : 1;
  __IO uint32_t HTH24      : 1;
  __IO uint32_t HTH25      : 1;
  __IO uint32_t HTH26      : 1;
  __IO uint32_t HTH27      : 1;
  __IO uint32_t HTH28      : 1;
  __IO uint32_t HTH29      : 1;
  __IO uint32_t HTH30      : 1;
  __IO uint32_t HTH31      : 1;
} stc_ethernet_mac_mhtrh_field_t;

typedef struct stc_ethernet_mac_mhtrl_field
{
  __IO uint32_t HTL0       : 1;
  __IO uint32_t HTL1       : 1;
  __IO uint32_t HTL2       : 1;
  __IO uint32_t HTL3       : 1;
  __IO uint32_t HTL4       : 1;
  __IO uint32_t HTL5       : 1;
  __IO uint32_t HTL6       : 1;
  __IO uint32_t HTL7       : 1;
  __IO uint32_t HTL8       : 1;
  __IO uint32_t HTL9       : 1;
  __IO uint32_t HTL10      : 1;
  __IO uint32_t HTL11      : 1;
  __IO uint32_t HTL12      : 1;
  __IO uint32_t HTL13      : 1;
  __IO uint32_t HTL14      : 1;
  __IO uint32_t HTL15      : 1;
  __IO uint32_t HTL16      : 1;
  __IO uint32_t HTL17      : 1;
  __IO uint32_t HTL18      : 1;
  __IO uint32_t HTL19      : 1;
  __IO uint32_t HTL20      : 1;
  __IO uint32_t HTL21      : 1;
  __IO uint32_t HTL22      : 1;
  __IO uint32_t HTL23      : 1;
  __IO uint32_t HTL24      : 1;
  __IO uint32_t HTL25      : 1;
  __IO uint32_t HTL26      : 1;
  __IO uint32_t HTL27      : 1;
  __IO uint32_t HTL28      : 1;
  __IO uint32_t HTL29      : 1;
  __IO uint32_t HTL30      : 1;
  __IO uint32_t HTL31      : 1;
} stc_ethernet_mac_mhtrl_field_t;

typedef struct stc_ethernet_mac_gar_field
{
  __IO uint32_t GB         : 1;
  __IO uint32_t GW         : 1;
  __IO uint32_t CR         : 4;
  __IO uint32_t GR         : 5;
  __IO uint32_t PA         : 5;
} stc_ethernet_mac_gar_field_t;

typedef struct stc_ethernet_mac_gdr_field
{
  __IO uint32_t GD         : 16;
} stc_ethernet_mac_gdr_field_t;

typedef struct stc_ethernet_mac_fcr_field
{
  __IO uint32_t FCB_BPA    : 1;
  __IO uint32_t TFE        : 1;
  __IO uint32_t RFE        : 1;
  __IO uint32_t UP         : 1;
  __IO uint32_t PLT0       : 1;
  __IO uint32_t PLT1       : 1;
       uint32_t RESERVED1  : 1;
  __IO uint32_t DZPQ       : 1;
       uint32_t RESERVED2  : 8;
  __IO uint32_t PT0        : 1;
  __IO uint32_t PT1        : 1;
  __IO uint32_t PT2        : 1;
  __IO uint32_t PT3        : 1;
  __IO uint32_t PT4        : 1;
  __IO uint32_t PT5        : 1;
  __IO uint32_t PT6        : 1;
  __IO uint32_t PT7        : 1;
  __IO uint32_t PT8        : 1;
  __IO uint32_t PT9        : 1;
  __IO uint32_t PT10       : 1;
  __IO uint32_t PT11       : 1;
  __IO uint32_t PT12       : 1;
  __IO uint32_t PT13       : 1;
  __IO uint32_t PT14       : 1;
  __IO uint32_t PT15       : 1;
} stc_ethernet_mac_fcr_field_t;

typedef struct stc_ethernet_mac_vtr_field
{
  __IO uint32_t VL0        : 1;
  __IO uint32_t VL1        : 1;
  __IO uint32_t VL2        : 1;
  __IO uint32_t VL3        : 1;
  __IO uint32_t VL4        : 1;
  __IO uint32_t VL5        : 1;
  __IO uint32_t VL6        : 1;
  __IO uint32_t VL7        : 1;
  __IO uint32_t VL8        : 1;
  __IO uint32_t VL9        : 1;
  __IO uint32_t VL10       : 1;
  __IO uint32_t VL11       : 1;
  __IO uint32_t VL12       : 1;
  __IO uint32_t VL13       : 1;
  __IO uint32_t VL14       : 1;
  __IO uint32_t VL15       : 1;
  __IO uint32_t ETV        : 1;
} stc_ethernet_mac_vtr_field_t;

typedef struct stc_ethernet_mac_rwffr_field
{
  __IO uint32_t RWFFR0     : 1;
  __IO uint32_t RWFFR1     : 1;
  __IO uint32_t RWFFR2     : 1;
  __IO uint32_t RWFFR3     : 1;
  __IO uint32_t RWFFR4     : 1;
  __IO uint32_t RWFFR5     : 1;
  __IO uint32_t RWFFR6     : 1;
  __IO uint32_t RWFFR7     : 1;
  __IO uint32_t RWFFR8     : 1;
  __IO uint32_t RWFFR9     : 1;
  __IO uint32_t RWFFR10    : 1;
  __IO uint32_t RWFFR11    : 1;
  __IO uint32_t RWFFR12    : 1;
  __IO uint32_t RWFFR13    : 1;
  __IO uint32_t RWFFR14    : 1;
  __IO uint32_t RWFFR15    : 1;
  __IO uint32_t RWFFR16    : 1;
  __IO uint32_t RWFFR17    : 1;
  __IO uint32_t RWFFR18    : 1;
  __IO uint32_t RWFFR19    : 1;
  __IO uint32_t RWFFR20    : 1;
  __IO uint32_t RWFFR21    : 1;
  __IO uint32_t RWFFR22    : 1;
  __IO uint32_t RWFFR23    : 1;
  __IO uint32_t RWFFR24    : 1;
  __IO uint32_t RWFFR25    : 1;
  __IO uint32_t RWFFR26    : 1;
  __IO uint32_t RWFFR27    : 1;
  __IO uint32_t RWFFR28    : 1;
  __IO uint32_t RWFFR29    : 1;
  __IO uint32_t RWFFR30    : 1;
  __IO uint32_t RWFFR31    : 1;
} stc_ethernet_mac_rwffr_field_t;

typedef struct stc_ethernet_mac_pmtr_field
{
  __IO uint32_t PD         : 1;
  __IO uint32_t MPE        : 1;
  __IO uint32_t WFE        : 1;
       uint32_t RESERVED1  : 2;
  __IO uint32_t MPR        : 1;
  __IO uint32_t WPR        : 1;
       uint32_t RESERVED2  : 2;
  __IO uint32_t GU         : 1;
       uint32_t RESERVED3  :21;
  __IO uint32_t RWFFRPR    : 1;
} stc_ethernet_mac_pmtr_field_t;

typedef struct stc_ethernet_mac_lpicsr_field
{
  __IO uint32_t TLPIEN     : 1;
  __IO uint32_t TLPIEX     : 1;
  __IO uint32_t RLPIEN     : 1;
  __IO uint32_t RLPIEX     : 1;
       uint32_t RESERVED1  : 4;
  __IO uint32_t TLPIST     : 1;
  __IO uint32_t RLPIST     : 1;
       uint32_t RESERVED2  : 6;
  __IO uint32_t LPIEN      : 1;
  __IO uint32_t PLS        : 1;
  __IO uint32_t PLSEN      : 1;
  __IO uint32_t LPITXA     : 1;
} stc_ethernet_mac_lpicsr_field_t;

typedef struct stc_ethernet_mac_lpitcr_field
{
  __IO uint32_t TWT0       : 1;
  __IO uint32_t TWT1       : 1;
  __IO uint32_t TWT2       : 1;
  __IO uint32_t TWT3       : 1;
  __IO uint32_t TWT4       : 1;
  __IO uint32_t TWT5       : 1;
  __IO uint32_t TWT6       : 1;
  __IO uint32_t TWT7       : 1;
  __IO uint32_t TWT8       : 1;
  __IO uint32_t TWT9       : 1;
  __IO uint32_t TWT10      : 1;
  __IO uint32_t TWT11      : 1;
  __IO uint32_t TWT12      : 1;
  __IO uint32_t TWT13      : 1;
  __IO uint32_t TWT14      : 1;
  __IO uint32_t TWT15      : 1;
  __IO uint32_t LIT0       : 1;
  __IO uint32_t LIT1       : 1;
  __IO uint32_t LIT2       : 1;
  __IO uint32_t LIT3       : 1;
  __IO uint32_t LIT4       : 1;
  __IO uint32_t LIT5       : 1;
  __IO uint32_t LIT6       : 1;
  __IO uint32_t LIT7       : 1;
  __IO uint32_t LIT8       : 1;
  __IO uint32_t LIT9       : 1;
} stc_ethernet_mac_lpitcr_field_t;

typedef struct stc_ethernet_mac_isr_field
{
  __IO uint32_t RGIS       : 1;
       uint32_t RESERVED1  : 2;
  __IO uint32_t PIS        : 1;
  __IO uint32_t MIS        : 1;
  __IO uint32_t RIS        : 1;
  __IO uint32_t TIS        : 1;
  __IO uint32_t COIS       : 1;
       uint32_t RESERVED2  : 1;
  __IO uint32_t TSIS       : 1;
  __IO uint32_t LPIIS      : 1;
} stc_ethernet_mac_isr_field_t;

typedef struct stc_ethernet_mac_imr_field
{
  __IO uint32_t RGIM       : 1;
       uint32_t RESERVED1  : 2;
  __IO uint32_t PIM        : 1;
       uint32_t RESERVED2  : 5;
  __IO uint32_t TSIM       : 1;
  __IO uint32_t LPIIM      : 1;
} stc_ethernet_mac_imr_field_t;

typedef struct stc_ethernet_mac_mar0h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  :15;
  __IO uint32_t MO         : 1;
} stc_ethernet_mac_mar0h_field_t;

typedef struct stc_ethernet_mac_mar0l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar0l_field_t;

typedef struct stc_ethernet_mac_mar1h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar1h_field_t;

typedef struct stc_ethernet_mac_mar1l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar1l_field_t;

typedef struct stc_ethernet_mac_mar2h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar2h_field_t;

typedef struct stc_ethernet_mac_mar2l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar2l_field_t;

typedef struct stc_ethernet_mac_mar3h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar3h_field_t;

typedef struct stc_ethernet_mac_mar3l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar3l_field_t;

typedef struct stc_ethernet_mac_mar4h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar4h_field_t;

typedef struct stc_ethernet_mac_mar4l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar4l_field_t;

typedef struct stc_ethernet_mac_mar5h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar5h_field_t;

typedef struct stc_ethernet_mac_mar5l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar5l_field_t;

typedef struct stc_ethernet_mac_mar6h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar6h_field_t;

typedef struct stc_ethernet_mac_mar6l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar6l_field_t;

typedef struct stc_ethernet_mac_mar7h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar7h_field_t;

typedef struct stc_ethernet_mac_mar7l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar7l_field_t;

typedef struct stc_ethernet_mac_mar8h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar8h_field_t;

typedef struct stc_ethernet_mac_mar8l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar8l_field_t;

typedef struct stc_ethernet_mac_mar9h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar9h_field_t;

typedef struct stc_ethernet_mac_mar9l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar9l_field_t;

typedef struct stc_ethernet_mac_mar10h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar10h_field_t;

typedef struct stc_ethernet_mac_mar10l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar10l_field_t;

typedef struct stc_ethernet_mac_mar11h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar11h_field_t;

typedef struct stc_ethernet_mac_mar11l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar11l_field_t;

typedef struct stc_ethernet_mac_mar12h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar12h_field_t;

typedef struct stc_ethernet_mac_mar12l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar12l_field_t;

typedef struct stc_ethernet_mac_mar13h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar13h_field_t;

typedef struct stc_ethernet_mac_mar13l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar13l_field_t;

typedef struct stc_ethernet_mac_mar14h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar14h_field_t;

typedef struct stc_ethernet_mac_mar14l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar14l_field_t;

typedef struct stc_ethernet_mac_mar15h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar15h_field_t;

typedef struct stc_ethernet_mac_mar15l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar15l_field_t;

typedef struct stc_ethernet_mac_rgsr_field
{
  __IO uint32_t LM         : 1;
  __IO uint32_t LSP0       : 1;
  __IO uint32_t LSP1       : 1;
  __IO uint32_t LS         : 1;
} stc_ethernet_mac_rgsr_field_t;

typedef struct stc_ethernet_mac_tscr_field
{
  __IO uint32_t TSE        : 1;
  __IO uint32_t TFCU       : 1;
  __IO uint32_t TSI        : 1;
  __IO uint32_t TSU        : 1;
  __IO uint32_t TITE       : 1;
  __IO uint32_t TARU       : 1;
       uint32_t RESERVED1  : 2;
  __IO uint32_t TSEA       : 1;
  __IO uint32_t TSDB       : 1;
  __IO uint32_t TSV2E      : 1;
  __IO uint32_t TETSP      : 1;
  __IO uint32_t TSIP6E     : 1;
  __IO uint32_t TSIP4E     : 1;
  __IO uint32_t TETSEM     : 1;
  __IO uint32_t TSMRM      : 1;
  __IO uint32_t TSPS0      : 1;
  __IO uint32_t TSPS1      : 1;
  __IO uint32_t TSENMF     : 1;
       uint32_t RESERVED2  : 5;
  __IO uint32_t ATSFC      : 1;
} stc_ethernet_mac_tscr_field_t;

typedef struct stc_ethernet_mac_ssir_field
{
  __IO uint32_t SSINC0     : 1;
  __IO uint32_t SSINC1     : 1;
  __IO uint32_t SSINC2     : 1;
  __IO uint32_t SSINC3     : 1;
  __IO uint32_t SSINC4     : 1;
  __IO uint32_t SSINC5     : 1;
  __IO uint32_t SSINC6     : 1;
  __IO uint32_t SSINC7     : 1;
} stc_ethernet_mac_ssir_field_t;

typedef struct stc_ethernet_mac_stsr_field
{
  __IO uint32_t TSS0       : 1;
  __IO uint32_t TSS1       : 1;
  __IO uint32_t TSS2       : 1;
  __IO uint32_t TSS3       : 1;
  __IO uint32_t TSS4       : 1;
  __IO uint32_t TSS5       : 1;
  __IO uint32_t TSS6       : 1;
  __IO uint32_t TSS7       : 1;
  __IO uint32_t TSS8       : 1;
  __IO uint32_t TSS9       : 1;
  __IO uint32_t TSS10      : 1;
  __IO uint32_t TSS11      : 1;
  __IO uint32_t TSS12      : 1;
  __IO uint32_t TSS13      : 1;
  __IO uint32_t TSS14      : 1;
  __IO uint32_t TSS15      : 1;
  __IO uint32_t TSS16      : 1;
  __IO uint32_t TSS17      : 1;
  __IO uint32_t TSS18      : 1;
  __IO uint32_t TSS19      : 1;
  __IO uint32_t TSS20      : 1;
  __IO uint32_t TSS21      : 1;
  __IO uint32_t TSS22      : 1;
  __IO uint32_t TSS23      : 1;
  __IO uint32_t TSS24      : 1;
  __IO uint32_t TSS25      : 1;
  __IO uint32_t TSS26      : 1;
  __IO uint32_t TSS27      : 1;
  __IO uint32_t TSS28      : 1;
  __IO uint32_t TSS29      : 1;
  __IO uint32_t TSS30      : 1;
  __IO uint32_t TSS31      : 1;
} stc_ethernet_mac_stsr_field_t;

typedef struct stc_ethernet_mac_stnr_field
{
  __IO uint32_t TSSS0      : 1;
  __IO uint32_t TSSS1      : 1;
  __IO uint32_t TSSS2      : 1;
  __IO uint32_t TSSS3      : 1;
  __IO uint32_t TSSS4      : 1;
  __IO uint32_t TSSS5      : 1;
  __IO uint32_t TSSS6      : 1;
  __IO uint32_t TSSS7      : 1;
  __IO uint32_t TSSS8      : 1;
  __IO uint32_t TSSS9      : 1;
  __IO uint32_t TSSS10     : 1;
  __IO uint32_t TSSS11     : 1;
  __IO uint32_t TSSS12     : 1;
  __IO uint32_t TSSS13     : 1;
  __IO uint32_t TSSS14     : 1;
  __IO uint32_t TSSS15     : 1;
  __IO uint32_t TSSS16     : 1;
  __IO uint32_t TSSS17     : 1;
  __IO uint32_t TSSS18     : 1;
  __IO uint32_t TSSS19     : 1;
  __IO uint32_t TSSS20     : 1;
  __IO uint32_t TSSS21     : 1;
  __IO uint32_t TSSS22     : 1;
  __IO uint32_t TSSS23     : 1;
  __IO uint32_t TSSS24     : 1;
  __IO uint32_t TSSS25     : 1;
  __IO uint32_t TSSS26     : 1;
  __IO uint32_t TSSS27     : 1;
  __IO uint32_t TSSS28     : 1;
  __IO uint32_t TSSS29     : 1;
  __IO uint32_t TSSS30     : 1;
} stc_ethernet_mac_stnr_field_t;

typedef struct stc_ethernet_mac_stsur_field
{
  __IO uint32_t TSS0       : 1;
  __IO uint32_t TSS1       : 1;
  __IO uint32_t TSS2       : 1;
  __IO uint32_t TSS3       : 1;
  __IO uint32_t TSS4       : 1;
  __IO uint32_t TSS5       : 1;
  __IO uint32_t TSS6       : 1;
  __IO uint32_t TSS7       : 1;
  __IO uint32_t TSS8       : 1;
  __IO uint32_t TSS9       : 1;
  __IO uint32_t TSS10      : 1;
  __IO uint32_t TSS11      : 1;
  __IO uint32_t TSS12      : 1;
  __IO uint32_t TSS13      : 1;
  __IO uint32_t TSS14      : 1;
  __IO uint32_t TSS15      : 1;
  __IO uint32_t TSS16      : 1;
  __IO uint32_t TSS17      : 1;
  __IO uint32_t TSS18      : 1;
  __IO uint32_t TSS19      : 1;
  __IO uint32_t TSS20      : 1;
  __IO uint32_t TSS21      : 1;
  __IO uint32_t TSS22      : 1;
  __IO uint32_t TSS23      : 1;
  __IO uint32_t TSS24      : 1;
  __IO uint32_t TSS25      : 1;
  __IO uint32_t TSS26      : 1;
  __IO uint32_t TSS27      : 1;
  __IO uint32_t TSS28      : 1;
  __IO uint32_t TSS29      : 1;
  __IO uint32_t TSS30      : 1;
  __IO uint32_t TSS31      : 1;
} stc_ethernet_mac_stsur_field_t;

typedef struct stc_ethernet_mac_stnur_field
{
  __IO uint32_t TSSS0      : 1;
  __IO uint32_t TSSS1      : 1;
  __IO uint32_t TSSS2      : 1;
  __IO uint32_t TSSS3      : 1;
  __IO uint32_t TSSS4      : 1;
  __IO uint32_t TSSS5      : 1;
  __IO uint32_t TSSS6      : 1;
  __IO uint32_t TSSS7      : 1;
  __IO uint32_t TSSS8      : 1;
  __IO uint32_t TSSS9      : 1;
  __IO uint32_t TSSS10     : 1;
  __IO uint32_t TSSS11     : 1;
  __IO uint32_t TSSS12     : 1;
  __IO uint32_t TSSS13     : 1;
  __IO uint32_t TSSS14     : 1;
  __IO uint32_t TSSS15     : 1;
  __IO uint32_t TSSS16     : 1;
  __IO uint32_t TSSS17     : 1;
  __IO uint32_t TSSS18     : 1;
  __IO uint32_t TSSS19     : 1;
  __IO uint32_t TSSS20     : 1;
  __IO uint32_t TSSS21     : 1;
  __IO uint32_t TSSS22     : 1;
  __IO uint32_t TSSS23     : 1;
  __IO uint32_t TSSS24     : 1;
  __IO uint32_t TSSS25     : 1;
  __IO uint32_t TSSS26     : 1;
  __IO uint32_t TSSS27     : 1;
  __IO uint32_t TSSS28     : 1;
  __IO uint32_t TSSS29     : 1;
  __IO uint32_t TSSS30     : 1;
  __IO uint32_t ADDSUB     : 1;
} stc_ethernet_mac_stnur_field_t;

typedef struct stc_ethernet_mac_tsar_field
{
  __IO uint32_t TSAR0      : 1;
  __IO uint32_t TSAR1      : 1;
  __IO uint32_t TSAR2      : 1;
  __IO uint32_t TSAR3      : 1;
  __IO uint32_t TSAR4      : 1;
  __IO uint32_t TSAR5      : 1;
  __IO uint32_t TSAR6      : 1;
  __IO uint32_t TSAR7      : 1;
  __IO uint32_t TSAR8      : 1;
  __IO uint32_t TSAR9      : 1;
  __IO uint32_t TSAR10     : 1;
  __IO uint32_t TSAR11     : 1;
  __IO uint32_t TSAR12     : 1;
  __IO uint32_t TSAR13     : 1;
  __IO uint32_t TSAR14     : 1;
  __IO uint32_t TSAR15     : 1;
  __IO uint32_t TSAR16     : 1;
  __IO uint32_t TSAR17     : 1;
  __IO uint32_t TSAR18     : 1;
  __IO uint32_t TSAR19     : 1;
  __IO uint32_t TSAR20     : 1;
  __IO uint32_t TSAR21     : 1;
  __IO uint32_t TSAR22     : 1;
  __IO uint32_t TSAR23     : 1;
  __IO uint32_t TSAR24     : 1;
  __IO uint32_t TSAR25     : 1;
  __IO uint32_t TSAR26     : 1;
  __IO uint32_t TSAR27     : 1;
  __IO uint32_t TSAR28     : 1;
  __IO uint32_t TSAR29     : 1;
  __IO uint32_t TSAR30     : 1;
  __IO uint32_t TSAR31     : 1;
} stc_ethernet_mac_tsar_field_t;

typedef struct stc_ethernet_mac_ttsr_field
{
  __IO uint32_t TSTR0      : 1;
  __IO uint32_t TSTR1      : 1;
  __IO uint32_t TSTR2      : 1;
  __IO uint32_t TSTR3      : 1;
  __IO uint32_t TSTR4      : 1;
  __IO uint32_t TSTR5      : 1;
  __IO uint32_t TSTR6      : 1;
  __IO uint32_t TSTR7      : 1;
  __IO uint32_t TSTR8      : 1;
  __IO uint32_t TSTR9      : 1;
  __IO uint32_t TSTR10     : 1;
  __IO uint32_t TSTR11     : 1;
  __IO uint32_t TSTR12     : 1;
  __IO uint32_t TSTR13     : 1;
  __IO uint32_t TSTR14     : 1;
  __IO uint32_t TSTR15     : 1;
  __IO uint32_t TSTR16     : 1;
  __IO uint32_t TSTR17     : 1;
  __IO uint32_t TSTR18     : 1;
  __IO uint32_t TSTR19     : 1;
  __IO uint32_t TSTR20     : 1;
  __IO uint32_t TSTR21     : 1;
  __IO uint32_t TSTR22     : 1;
  __IO uint32_t TSTR23     : 1;
  __IO uint32_t TSTR24     : 1;
  __IO uint32_t TSTR25     : 1;
  __IO uint32_t TSTR26     : 1;
  __IO uint32_t TSTR27     : 1;
  __IO uint32_t TSTR28     : 1;
  __IO uint32_t TSTR29     : 1;
  __IO uint32_t TSTR30     : 1;
  __IO uint32_t TSTR31     : 1;
} stc_ethernet_mac_ttsr_field_t;

typedef struct stc_ethernet_mac_ttnr_field
{
  __IO uint32_t TSTR0      : 1;
  __IO uint32_t TSTR1      : 1;
  __IO uint32_t TSTR2      : 1;
  __IO uint32_t TSTR3      : 1;
  __IO uint32_t TSTR4      : 1;
  __IO uint32_t TSTR5      : 1;
  __IO uint32_t TSTR6      : 1;
  __IO uint32_t TSTR7      : 1;
  __IO uint32_t TSTR8      : 1;
  __IO uint32_t TSTR9      : 1;
  __IO uint32_t TSTR10     : 1;
  __IO uint32_t TSTR11     : 1;
  __IO uint32_t TSTR12     : 1;
  __IO uint32_t TSTR13     : 1;
  __IO uint32_t TSTR14     : 1;
  __IO uint32_t TSTR15     : 1;
  __IO uint32_t TSTR16     : 1;
  __IO uint32_t TSTR17     : 1;
  __IO uint32_t TSTR18     : 1;
  __IO uint32_t TSTR19     : 1;
  __IO uint32_t TSTR20     : 1;
  __IO uint32_t TSTR21     : 1;
  __IO uint32_t TSTR22     : 1;
  __IO uint32_t TSTR23     : 1;
  __IO uint32_t TSTR24     : 1;
  __IO uint32_t TSTR25     : 1;
  __IO uint32_t TSTR26     : 1;
  __IO uint32_t TSTR27     : 1;
  __IO uint32_t TSTR28     : 1;
  __IO uint32_t TSTR29     : 1;
  __IO uint32_t TSTR30     : 1;
} stc_ethernet_mac_ttnr_field_t;

typedef struct stc_ethernet_mac_sthwsr_field
{
  __IO uint32_t TSHWR0     : 1;
  __IO uint32_t TSHWR1     : 1;
  __IO uint32_t TSHWR2     : 1;
  __IO uint32_t TSHWR3     : 1;
  __IO uint32_t TSHWR4     : 1;
  __IO uint32_t TSHWR5     : 1;
  __IO uint32_t TSHWR6     : 1;
  __IO uint32_t TSHWR7     : 1;
  __IO uint32_t TSHWR8     : 1;
  __IO uint32_t TSHWR9     : 1;
  __IO uint32_t TSHWR10    : 1;
  __IO uint32_t TSHWR11    : 1;
  __IO uint32_t TSHWR12    : 1;
  __IO uint32_t TSHWR13    : 1;
  __IO uint32_t TSHWR14    : 1;
  __IO uint32_t TSHWR15    : 1;
} stc_ethernet_mac_sthwsr_field_t;

typedef struct stc_ethernet_mac_tsr_field
{
  __IO uint32_t TSSOVF     : 1;
  __IO uint32_t TSTART     : 1;
  __IO uint32_t ATSTS      : 1;
  __IO uint32_t TRGTER     : 1;
       uint32_t RESERVED1  :20;
  __IO uint32_t ATSSTM     : 1;
  __IO uint32_t ATSNS0     : 1;
  __IO uint32_t ATSNS1     : 1;
  __IO uint32_t ATSNS2     : 1;
} stc_ethernet_mac_tsr_field_t;

typedef struct stc_ethernet_mac_ppscr_field
{
  __IO uint32_t PPSCTRL0   : 1;
  __IO uint32_t PPSCTRL1   : 1;
  __IO uint32_t PPSCTRL2   : 1;
  __IO uint32_t PPSCTRL3   : 1;
} stc_ethernet_mac_ppscr_field_t;

typedef struct stc_ethernet_mac_atnr_field
{
  __IO uint32_t ATN0       : 1;
  __IO uint32_t ATN1       : 1;
  __IO uint32_t ATN2       : 1;
  __IO uint32_t ATN3       : 1;
  __IO uint32_t ATN4       : 1;
  __IO uint32_t ATN5       : 1;
  __IO uint32_t ATN6       : 1;
  __IO uint32_t ATN7       : 1;
  __IO uint32_t ATN8       : 1;
  __IO uint32_t ATN9       : 1;
  __IO uint32_t ATN10      : 1;
  __IO uint32_t ATN11      : 1;
  __IO uint32_t ATN12      : 1;
  __IO uint32_t ATN13      : 1;
  __IO uint32_t ATN14      : 1;
  __IO uint32_t ATN15      : 1;
  __IO uint32_t ATN16      : 1;
  __IO uint32_t ATN17      : 1;
  __IO uint32_t ATN18      : 1;
  __IO uint32_t ATN19      : 1;
  __IO uint32_t ATN20      : 1;
  __IO uint32_t ATN21      : 1;
  __IO uint32_t ATN22      : 1;
  __IO uint32_t ATN23      : 1;
  __IO uint32_t ATN24      : 1;
  __IO uint32_t ATN25      : 1;
  __IO uint32_t ATN26      : 1;
  __IO uint32_t ATN27      : 1;
  __IO uint32_t ATN28      : 1;
  __IO uint32_t ATN29      : 1;
  __IO uint32_t ATN30      : 1;
} stc_ethernet_mac_atnr_field_t;

typedef struct stc_ethernet_mac_atsr_field
{
  __IO uint32_t ATS0       : 1;
  __IO uint32_t ATS1       : 1;
  __IO uint32_t ATS2       : 1;
  __IO uint32_t ATS3       : 1;
  __IO uint32_t ATS4       : 1;
  __IO uint32_t ATS5       : 1;
  __IO uint32_t ATS6       : 1;
  __IO uint32_t ATS7       : 1;
  __IO uint32_t ATS8       : 1;
  __IO uint32_t ATS9       : 1;
  __IO uint32_t ATS10      : 1;
  __IO uint32_t ATS11      : 1;
  __IO uint32_t ATS12      : 1;
  __IO uint32_t ATS13      : 1;
  __IO uint32_t ATS14      : 1;
  __IO uint32_t ATS15      : 1;
  __IO uint32_t ATS16      : 1;
  __IO uint32_t ATS17      : 1;
  __IO uint32_t ATS18      : 1;
  __IO uint32_t ATS19      : 1;
  __IO uint32_t ATS20      : 1;
  __IO uint32_t ATS21      : 1;
  __IO uint32_t ATS22      : 1;
  __IO uint32_t ATS23      : 1;
  __IO uint32_t ATS24      : 1;
  __IO uint32_t ATS25      : 1;
  __IO uint32_t ATS26      : 1;
  __IO uint32_t ATS27      : 1;
  __IO uint32_t ATS28      : 1;
  __IO uint32_t ATS29      : 1;
  __IO uint32_t ATS30      : 1;
  __IO uint32_t ATS31      : 1;
} stc_ethernet_mac_atsr_field_t;

typedef struct stc_ethernet_mac_mar16h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar16h_field_t;

typedef struct stc_ethernet_mac_mar16l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar16l_field_t;

typedef struct stc_ethernet_mac_mar17h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar17h_field_t;

typedef struct stc_ethernet_mac_mar17l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar17l_field_t;

typedef struct stc_ethernet_mac_mar18h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar18h_field_t;

typedef struct stc_ethernet_mac_mar18l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar18l_field_t;

typedef struct stc_ethernet_mac_mar19h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar19h_field_t;

typedef struct stc_ethernet_mac_mar19l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar19l_field_t;

typedef struct stc_ethernet_mac_mar20h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar20h_field_t;

typedef struct stc_ethernet_mac_mar20l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar20l_field_t;

typedef struct stc_ethernet_mac_mar21h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar21h_field_t;

typedef struct stc_ethernet_mac_mar21l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar21l_field_t;

typedef struct stc_ethernet_mac_mar22h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar22h_field_t;

typedef struct stc_ethernet_mac_mar22l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar22l_field_t;

typedef struct stc_ethernet_mac_mar23h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar23h_field_t;

typedef struct stc_ethernet_mac_mar23l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar23l_field_t;

typedef struct stc_ethernet_mac_mar24h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar24h_field_t;

typedef struct stc_ethernet_mac_mar24l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar24l_field_t;

typedef struct stc_ethernet_mac_mar25h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar25h_field_t;

typedef struct stc_ethernet_mac_mar25l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar25l_field_t;

typedef struct stc_ethernet_mac_mar26h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar26h_field_t;

typedef struct stc_ethernet_mac_mar26l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar26l_field_t;

typedef struct stc_ethernet_mac_mar27h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar27h_field_t;

typedef struct stc_ethernet_mac_mar27l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar27l_field_t;

typedef struct stc_ethernet_mac_mar28h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar28h_field_t;

typedef struct stc_ethernet_mac_mar28l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar28l_field_t;

typedef struct stc_ethernet_mac_mar29h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar29h_field_t;

typedef struct stc_ethernet_mac_mar29l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar29l_field_t;

typedef struct stc_ethernet_mac_mar30h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar30h_field_t;

typedef struct stc_ethernet_mac_mar30l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar30l_field_t;

typedef struct stc_ethernet_mac_mar31h_field
{
  __IO uint32_t A32        : 1;
  __IO uint32_t A33        : 1;
  __IO uint32_t A34        : 1;
  __IO uint32_t A35        : 1;
  __IO uint32_t A36        : 1;
  __IO uint32_t A37        : 1;
  __IO uint32_t A38        : 1;
  __IO uint32_t A39        : 1;
  __IO uint32_t A40        : 1;
  __IO uint32_t A41        : 1;
  __IO uint32_t A42        : 1;
  __IO uint32_t A43        : 1;
  __IO uint32_t A44        : 1;
  __IO uint32_t A45        : 1;
  __IO uint32_t A46        : 1;
  __IO uint32_t A47        : 1;
       uint32_t RESERVED1  : 8;
  __IO uint32_t MBC0       : 1;
  __IO uint32_t MBC1       : 1;
  __IO uint32_t MBC2       : 1;
  __IO uint32_t MBC3       : 1;
  __IO uint32_t MBC4       : 1;
  __IO uint32_t MBC5       : 1;
  __IO uint32_t SA         : 1;
  __IO uint32_t AE         : 1;
} stc_ethernet_mac_mar31h_field_t;

typedef struct stc_ethernet_mac_mar31l_field
{
  __IO uint32_t A0         : 1;
  __IO uint32_t A1         : 1;
  __IO uint32_t A2         : 1;
  __IO uint32_t A3         : 1;
  __IO uint32_t A4         : 1;
  __IO uint32_t A5         : 1;
  __IO uint32_t A6         : 1;
  __IO uint32_t A7         : 1;
  __IO uint32_t A8         : 1;
  __IO uint32_t A9         : 1;
  __IO uint32_t A10        : 1;
  __IO uint32_t A11        : 1;
  __IO uint32_t A12        : 1;
  __IO uint32_t A13        : 1;
  __IO uint32_t A14        : 1;
  __IO uint32_t A15        : 1;
  __IO uint32_t A16        : 1;
  __IO uint32_t A17        : 1;
  __IO uint32_t A18        : 1;
  __IO uint32_t A19        : 1;
  __IO uint32_t A20        : 1;
  __IO uint32_t A21        : 1;
  __IO uint32_t A22        : 1;
  __IO uint32_t A23        : 1;
  __IO uint32_t A24        : 1;
  __IO uint32_t A25        : 1;
  __IO uint32_t A26        : 1;
  __IO uint32_t A27        : 1;
  __IO uint32_t A28        : 1;
  __IO uint32_t A29        : 1;
  __IO uint32_t A30        : 1;
  __IO uint32_t A31        : 1;
} stc_ethernet_mac_mar31l_field_t;

typedef struct stc_ethernet_mac_bmr_field
{
  __IO uint32_t SWR        : 1;
  __IO uint32_t DA         : 1;
  __IO uint32_t DSL        : 5;
  __IO uint32_t ATDS       : 1;
  __IO uint32_t PBL        : 6;
  __IO uint32_t PR         : 2;
  __IO uint32_t FB         : 1;
  __IO uint32_t RPBL       : 6;
  __IO uint32_t USP        : 1;
  __IO uint32_t _8XPBL     : 1;
  __IO uint32_t AAL        : 1;
  __IO uint32_t MB         : 1;
  __IO uint32_t TXPR       : 1;
} stc_ethernet_mac_bmr_field_t;

typedef struct stc_ethernet_mac_tpdr_field
{
  __IO uint32_t TPD0       : 1;
  __IO uint32_t TPD1       : 1;
  __IO uint32_t TPD2       : 1;
  __IO uint32_t TPD3       : 1;
  __IO uint32_t TPD4       : 1;
  __IO uint32_t TPD5       : 1;
  __IO uint32_t TPD6       : 1;
  __IO uint32_t TPD7       : 1;
  __IO uint32_t TPD8       : 1;
  __IO uint32_t TPD9       : 1;
  __IO uint32_t TPD10      : 1;
  __IO uint32_t TPD11      : 1;
  __IO uint32_t TPD12      : 1;
  __IO uint32_t TPD13      : 1;
  __IO uint32_t TPD14      : 1;
  __IO uint32_t TPD15      : 1;
  __IO uint32_t TPD16      : 1;
  __IO uint32_t TPD17      : 1;
  __IO uint32_t TPD18      : 1;
  __IO uint32_t TPD19      : 1;
  __IO uint32_t TPD20      : 1;
  __IO uint32_t TPD21      : 1;
  __IO uint32_t TPD22      : 1;
  __IO uint32_t TPD23      : 1;
  __IO uint32_t TPD24      : 1;
  __IO uint32_t TPD25      : 1;
  __IO uint32_t TPD26      : 1;
  __IO uint32_t TPD27      : 1;
  __IO uint32_t TPD28      : 1;
  __IO uint32_t TPD29      : 1;
  __IO uint32_t TPD30      : 1;
  __IO uint32_t TPD31      : 1;
} stc_ethernet_mac_tpdr_field_t;

typedef struct stc_ethernet_mac_rpdr_field
{
  __IO uint32_t RPD0       : 1;
  __IO uint32_t RPD1       : 1;
  __IO uint32_t RPD2       : 1;
  __IO uint32_t RPD3       : 1;
  __IO uint32_t RPD4       : 1;
  __IO uint32_t RPD5       : 1;
  __IO uint32_t RPD6       : 1;
  __IO uint32_t RPD7       : 1;
  __IO uint32_t RPD8       : 1;
  __IO uint32_t RPD9       : 1;
  __IO uint32_t RPD10      : 1;
  __IO uint32_t RPD11      : 1;
  __IO uint32_t RPD12      : 1;
  __IO uint32_t RPD13      : 1;
  __IO uint32_t RPD14      : 1;
  __IO uint32_t RPD15      : 1;
  __IO uint32_t RPD16      : 1;
  __IO uint32_t RPD17      : 1;
  __IO uint32_t RPD18      : 1;
  __IO uint32_t RPD19      : 1;
  __IO uint32_t RPD20      : 1;
  __IO uint32_t RPD21      : 1;
  __IO uint32_t RPD22      : 1;
  __IO uint32_t RPD23      : 1;
  __IO uint32_t RPD24      : 1;
  __IO uint32_t RPD25      : 1;
  __IO uint32_t RPD26      : 1;
  __IO uint32_t RPD27      : 1;
  __IO uint32_t RPD28      : 1;
  __IO uint32_t RPD29      : 1;
  __IO uint32_t RPD30      : 1;
  __IO uint32_t RPD31      : 1;
} stc_ethernet_mac_rpdr_field_t;

typedef struct stc_ethernet_mac_rdlar_field
{
       uint32_t RESERVED1  : 2;
  __IO uint32_t SRL2       : 1;
  __IO uint32_t SRL3       : 1;
  __IO uint32_t SRL4       : 1;
  __IO uint32_t SRL5       : 1;
  __IO uint32_t SRL6       : 1;
  __IO uint32_t SRL7       : 1;
  __IO uint32_t SRL8       : 1;
  __IO uint32_t SRL9       : 1;
  __IO uint32_t SRL10      : 1;
  __IO uint32_t SRL11      : 1;
  __IO uint32_t SRL12      : 1;
  __IO uint32_t SRL13      : 1;
  __IO uint32_t SRL14      : 1;
  __IO uint32_t SRL15      : 1;
  __IO uint32_t SRL16      : 1;
  __IO uint32_t SRL17      : 1;
  __IO uint32_t SRL18      : 1;
  __IO uint32_t SRL19      : 1;
  __IO uint32_t SRL20      : 1;
  __IO uint32_t SRL21      : 1;
  __IO uint32_t SRL22      : 1;
  __IO uint32_t SRL23      : 1;
  __IO uint32_t SRL24      : 1;
  __IO uint32_t SRL25      : 1;
  __IO uint32_t SRL26      : 1;
  __IO uint32_t SRL27      : 1;
  __IO uint32_t SRL28      : 1;
  __IO uint32_t SRL29      : 1;
  __IO uint32_t SRL30      : 1;
  __IO uint32_t SRL31      : 1;
} stc_ethernet_mac_rdlar_field_t;

typedef struct stc_ethernet_mac_tdlar_field
{
       uint32_t RESERVED1  : 2;
  __IO uint32_t STL2       : 1;
  __IO uint32_t STL3       : 1;
  __IO uint32_t STL4       : 1;
  __IO uint32_t STL5       : 1;
  __IO uint32_t STL6       : 1;
  __IO uint32_t STL7       : 1;
  __IO uint32_t STL8       : 1;
  __IO uint32_t STL9       : 1;
  __IO uint32_t STL10      : 1;
  __IO uint32_t STL11      : 1;
  __IO uint32_t STL12      : 1;
  __IO uint32_t STL13      : 1;
  __IO uint32_t STL14      : 1;
  __IO uint32_t STL15      : 1;
  __IO uint32_t STL16      : 1;
  __IO uint32_t STL17      : 1;
  __IO uint32_t STL18      : 1;
  __IO uint32_t STL19      : 1;
  __IO uint32_t STL20      : 1;
  __IO uint32_t STL21      : 1;
  __IO uint32_t STL22      : 1;
  __IO uint32_t STL23      : 1;
  __IO uint32_t STL24      : 1;
  __IO uint32_t STL25      : 1;
  __IO uint32_t STL26      : 1;
  __IO uint32_t STL27      : 1;
  __IO uint32_t STL28      : 1;
  __IO uint32_t STL29      : 1;
  __IO uint32_t STL30      : 1;
  __IO uint32_t STL31      : 1;
} stc_ethernet_mac_tdlar_field_t;

typedef struct stc_ethernet_mac_sr_field
{
  __IO uint32_t TI         : 1;
  __IO uint32_t TPS        : 1;
  __IO uint32_t TU         : 1;
  __IO uint32_t TJT        : 1;
  __IO uint32_t OVF        : 1;
  __IO uint32_t UNF        : 1;
  __IO uint32_t RI         : 1;
  __IO uint32_t RU         : 1;
  __IO uint32_t RPS        : 1;
  __IO uint32_t RWT        : 1;
  __IO uint32_t ETI        : 1;
       uint32_t RESERVED1  : 2;
  __IO uint32_t FBI        : 1;
  __IO uint32_t ERI        : 1;
  __IO uint32_t AIS        : 1;
  __IO uint32_t NIS        : 1;
  __IO uint32_t RS0        : 1;
  __IO uint32_t RS1        : 1;
  __IO uint32_t RS2        : 1;
  __IO uint32_t TS0        : 1;
  __IO uint32_t TS1        : 1;
  __IO uint32_t TS2        : 1;
  __IO uint32_t EB0        : 1;
  __IO uint32_t EB1        : 1;
  __IO uint32_t EB2        : 1;
  __IO uint32_t GLI        : 1;
  __IO uint32_t GMI        : 1;
  __IO uint32_t GPI        : 1;
  __IO uint32_t TTI        : 1;
  __IO uint32_t GLPII      : 1;
} stc_ethernet_mac_sr_field_t;

typedef struct stc_ethernet_mac_omr_field
{
       uint32_t RESERVED1  : 1;
  __IO uint32_t SR         : 1;
  __IO uint32_t OSF        : 1;
  __IO uint32_t RTC0       : 1;
  __IO uint32_t RTC1       : 1;
       uint32_t RESERVED2  : 1;
  __IO uint32_t FUF        : 1;
  __IO uint32_t FEF        : 1;
       uint32_t RESERVED3  : 5;
  __IO uint32_t ST         : 1;
  __IO uint32_t TTC0       : 1;
  __IO uint32_t TTC1       : 1;
  __IO uint32_t TTC2       : 1;
       uint32_t RESERVED4  : 3;
  __IO uint32_t FTF        : 1;
  __IO uint32_t TSF        : 1;
       uint32_t RESERVED5  : 2;
  __IO uint32_t DFF        : 1;
  __IO uint32_t RSF        : 1;
  __IO uint32_t DT         : 1;
} stc_ethernet_mac_omr_field_t;

typedef struct stc_ethernet_mac_ier_field
{
  __IO uint32_t TIE        : 1;
  __IO uint32_t TSE        : 1;
  __IO uint32_t TUE        : 1;
  __IO uint32_t TJE        : 1;
  __IO uint32_t OVE        : 1;
  __IO uint32_t UNE        : 1;
  __IO uint32_t RIE        : 1;
  __IO uint32_t RUE        : 1;
  __IO uint32_t RSE        : 1;
  __IO uint32_t RWE        : 1;
  __IO uint32_t ETE        : 1;
       uint32_t RESERVED1  : 2;
  __IO uint32_t FBE        : 1;
  __IO uint32_t ERE        : 1;
  __IO uint32_t AIE        : 1;
  __IO uint32_t NIE        : 1;
} stc_ethernet_mac_ier_field_t;

typedef struct stc_ethernet_mac_mfbocr_field
{
  __IO uint32_t NMFH0      : 1;
  __IO uint32_t NMFH1      : 1;
  __IO uint32_t NMFH2      : 1;
  __IO uint32_t NMFH3      : 1;
  __IO uint32_t NMFH4      : 1;
  __IO uint32_t NMFH5      : 1;
  __IO uint32_t NMFH6      : 1;
  __IO uint32_t NMFH7      : 1;
  __IO uint32_t NMFH8      : 1;
  __IO uint32_t NMFH9      : 1;
  __IO uint32_t NMFH10     : 1;
  __IO uint32_t NMFH11     : 1;
  __IO uint32_t NMFH12     : 1;
  __IO uint32_t NMFH13     : 1;
  __IO uint32_t NMFH14     : 1;
  __IO uint32_t NMFH15     : 1;
  __IO uint32_t ONMFH      : 1;
  __IO uint32_t NMFF0      : 1;
  __IO uint32_t NMFF1      : 1;
  __IO uint32_t NMFF2      : 1;
  __IO uint32_t NMFF3      : 1;
  __IO uint32_t NMFF4      : 1;
  __IO uint32_t NMFF5      : 1;
  __IO uint32_t NMFF6      : 1;
  __IO uint32_t NMFF7      : 1;
  __IO uint32_t NMFF8      : 1;
  __IO uint32_t NMFF9      : 1;
  __IO uint32_t NMFF10     : 1;
  __IO uint32_t ONMFF      : 1;
} stc_ethernet_mac_mfbocr_field_t;

typedef struct stc_ethernet_mac_riwtr_field
{
  __IO uint32_t RIWT0      : 1;
  __IO uint32_t RIWT1      : 1;
  __IO uint32_t RIWT2      : 1;
  __IO uint32_t RIWT3      : 1;
  __IO uint32_t RIWT4      : 1;
  __IO uint32_t RIWT5      : 1;
  __IO uint32_t RIWT6      : 1;
  __IO uint32_t RIWT7      : 1;
} stc_ethernet_mac_riwtr_field_t;

typedef struct stc_ethernet_mac_ahbsr_field
{
  __IO uint32_t AHBS       : 1;
} stc_ethernet_mac_ahbsr_field_t;

typedef struct stc_ethernet_mac_chtdr_field
{
  __IO uint32_t HTDAP0     : 1;
  __IO uint32_t HTDAP1     : 1;
  __IO uint32_t HTDAP2     : 1;
  __IO uint32_t HTDAP3     : 1;
  __IO uint32_t HTDAP4     : 1;
  __IO uint32_t HTDAP5     : 1;
  __IO uint32_t HTDAP6     : 1;
  __IO uint32_t HTDAP7     : 1;
  __IO uint32_t HTDAP8     : 1;
  __IO uint32_t HTDAP9     : 1;
  __IO uint32_t HTDAP10    : 1;
  __IO uint32_t HTDAP11    : 1;
  __IO uint32_t HTDAP12    : 1;
  __IO uint32_t HTDAP13    : 1;
  __IO uint32_t HTDAP14    : 1;
  __IO uint32_t HTDAP15    : 1;
  __IO uint32_t HTDAP16    : 1;
  __IO uint32_t HTDAP17    : 1;
  __IO uint32_t HTDAP18    : 1;
  __IO uint32_t HTDAP19    : 1;
  __IO uint32_t HTDAP20    : 1;
  __IO uint32_t HTDAP21    : 1;
  __IO uint32_t HTDAP22    : 1;
  __IO uint32_t HTDAP23    : 1;
  __IO uint32_t HTDAP24    : 1;
  __IO uint32_t HTDAP25    : 1;
  __IO uint32_t HTDAP26    : 1;
  __IO uint32_t HTDAP27    : 1;
  __IO uint32_t HTDAP28    : 1;
  __IO uint32_t HTDAP29    : 1;
  __IO uint32_t HTDAP30    : 1;
  __IO uint32_t HTDAP31    : 1;
} stc_ethernet_mac_chtdr_field_t;

typedef struct stc_ethernet_mac_chrdr_field
{
  __IO uint32_t HRDAP0     : 1;
  __IO uint32_t HRDAP1     : 1;
  __IO uint32_t HRDAP2     : 1;
  __IO uint32_t HRDAP3     : 1;
  __IO uint32_t HRDAP4     : 1;
  __IO uint32_t HRDAP5     : 1;
  __IO uint32_t HRDAP6     : 1;
  __IO uint32_t HRDAP7     : 1;
  __IO uint32_t HRDAP8     : 1;
  __IO uint32_t HRDAP9     : 1;
  __IO uint32_t HRDAP10    : 1;
  __IO uint32_t HRDAP11    : 1;
  __IO uint32_t HRDAP12    : 1;
  __IO uint32_t HRDAP13    : 1;
  __IO uint32_t HRDAP14    : 1;
  __IO uint32_t HRDAP15    : 1;
  __IO uint32_t HRDAP16    : 1;
  __IO uint32_t HRDAP17    : 1;
  __IO uint32_t HRDAP18    : 1;
  __IO uint32_t HRDAP19    : 1;
  __IO uint32_t HRDAP20    : 1;
  __IO uint32_t HRDAP21    : 1;
  __IO uint32_t HRDAP22    : 1;
  __IO uint32_t HRDAP23    : 1;
  __IO uint32_t HRDAP24    : 1;
  __IO uint32_t HRDAP25    : 1;
  __IO uint32_t HRDAP26    : 1;
  __IO uint32_t HRDAP27    : 1;
  __IO uint32_t HRDAP28    : 1;
  __IO uint32_t HRDAP29    : 1;
  __IO uint32_t HRDAP30    : 1;
  __IO uint32_t HRDAP31    : 1;
} stc_ethernet_mac_chrdr_field_t;

typedef struct stc_ethernet_mac_chtbar_field
{
  __IO uint32_t HTBAR0     : 1;
  __IO uint32_t HTBAR1     : 1;
  __IO uint32_t HTBAR2     : 1;
  __IO uint32_t HTBAR3     : 1;
  __IO uint32_t HTBAR4     : 1;
  __IO uint32_t HTBAR5     : 1;
  __IO uint32_t HTBAR6     : 1;
  __IO uint32_t HTBAR7     : 1;
  __IO uint32_t HTBAR8     : 1;
  __IO uint32_t HTBAR9     : 1;
  __IO uint32_t HTBAR10    : 1;
  __IO uint32_t HTBAR11    : 1;
  __IO uint32_t HTBAR12    : 1;
  __IO uint32_t HTBAR13    : 1;
  __IO uint32_t HTBAR14    : 1;
  __IO uint32_t HTBAR15    : 1;
  __IO uint32_t HTBAR16    : 1;
  __IO uint32_t HTBAR17    : 1;
  __IO uint32_t HTBAR18    : 1;
  __IO uint32_t HTBAR19    : 1;
  __IO uint32_t HTBAR20    : 1;
  __IO uint32_t HTBAR21    : 1;
  __IO uint32_t HTBAR22    : 1;
  __IO uint32_t HTBAR23    : 1;
  __IO uint32_t HTBAR24    : 1;
  __IO uint32_t HTBAR25    : 1;
  __IO uint32_t HTBAR26    : 1;
  __IO uint32_t HTBAR27    : 1;
  __IO uint32_t HTBAR28    : 1;
  __IO uint32_t HTBAR29    : 1;
  __IO uint32_t HTBAR30    : 1;
  __IO uint32_t HTBAR31    : 1;
} stc_ethernet_mac_chtbar_field_t;

typedef struct stc_ethernet_mac_chrbar_field
{
  __IO uint32_t HRBAR0     : 1;
  __IO uint32_t HRBAR1     : 1;
  __IO uint32_t HRBAR2     : 1;
  __IO uint32_t HRBAR3     : 1;
  __IO uint32_t HRBAR4     : 1;
  __IO uint32_t HRBAR5     : 1;
  __IO uint32_t HRBAR6     : 1;
  __IO uint32_t HRBAR7     : 1;
  __IO uint32_t HRBAR8     : 1;
  __IO uint32_t HRBAR9     : 1;
  __IO uint32_t HRBAR10    : 1;
  __IO uint32_t HRBAR11    : 1;
  __IO uint32_t HRBAR12    : 1;
  __IO uint32_t HRBAR13    : 1;
  __IO uint32_t HRBAR14    : 1;
  __IO uint32_t HRBAR15    : 1;
  __IO uint32_t HRBAR16    : 1;
  __IO uint32_t HRBAR17    : 1;
  __IO uint32_t HRBAR18    : 1;
  __IO uint32_t HRBAR19    : 1;
  __IO uint32_t HRBAR20    : 1;
  __IO uint32_t HRBAR21    : 1;
  __IO uint32_t HRBAR22    : 1;
  __IO uint32_t HRBAR23    : 1;
  __IO uint32_t HRBAR24    : 1;
  __IO uint32_t HRBAR25    : 1;
  __IO uint32_t HRBAR26    : 1;
  __IO uint32_t HRBAR27    : 1;
  __IO uint32_t HRBAR28    : 1;
  __IO uint32_t HRBAR29    : 1;
  __IO uint32_t HRBAR30    : 1;
  __IO uint32_t HRBAR31    : 1;
} stc_ethernet_mac_chrbar_field_t;

/* ETHERNET_CONTROL_MODULE register bit fields */
typedef struct stc_ethernet_control_eth_mode_field
{
  __IO uint32_t IFMODE     : 1;
       uint32_t RESERVED1  : 7;
  __IO uint32_t RST0       : 1;
  __IO uint32_t RST1       : 1;
       uint32_t RESERVED2  :18;
  __IO uint32_t PPSSEL     : 1;
} stc_ethernet_control_eth_mode_field_t;

typedef struct stc_ethernet_control_eth_clkg_field
{
  __IO uint32_t MACEN0     : 1;
  __IO uint32_t MACEN1     : 1;
} stc_ethernet_control_eth_clkg_field_t;

/******************************************************************************
 * Peripheral register structures
 ******************************************************************************/

/******************************************************************************
 * Flash_IF_MODULE
 ******************************************************************************/
/* Flash interface registers */
typedef struct
{
  union {
    __IO uint32_t FASZR;
    stc_flash_if_faszr_field_t FASZR_f;
  };
  union {
    __IO uint32_t FRWTR;
    stc_flash_if_frwtr_field_t FRWTR_f;
  };
  union {
    __IO uint32_t FSTR;
    stc_flash_if_fstr_field_t FSTR_f;
  };
        uint8_t RESERVED0[4];
  union {
    __IO uint32_t FSYNDN;
    stc_flash_if_fsyndn_field_t FSYNDN_f;
  };
  union {
    __IO uint32_t FBFCR;
    stc_flash_if_fbfcr_field_t FBFCR_f;
  };
        uint8_t RESERVED1[232];
  union {
    __IO uint32_t CRTRMM;
    stc_flash_if_crtrmm_field_t CRTRMM_f;
  };
}FM3_FLASH_IF_TypeDef;

/******************************************************************************
 * Clock_Reset_MODULE
 ******************************************************************************/
/* Clock and reset registers */
typedef struct
{
  union {
    __IO  uint8_t SCM_CTL;
    stc_crg_scm_ctl_field_t SCM_CTL_f;
  };
        uint8_t RESERVED0[3];
  union {
    __IO  uint8_t SCM_STR;
    stc_crg_scm_str_field_t SCM_STR_f;
  };
        uint8_t RESERVED1[3];
  __IO uint32_t STB_CTL;
  union {
    __IO uint16_t RST_STR;
    stc_crg_rst_str_field_t RST_STR_f;
  };
        uint8_t RESERVED2[2];
  union {
    __IO  uint8_t BSC_PSR;
    stc_crg_bsc_psr_field_t BSC_PSR_f;
  };
        uint8_t RESERVED3[3];
  union {
    __IO  uint8_t APBC0_PSR;
    stc_crg_apbc0_psr_field_t APBC0_PSR_f;
  };
        uint8_t RESERVED4[3];
  union {
    __IO  uint8_t APBC1_PSR;
    stc_crg_apbc1_psr_field_t APBC1_PSR_f;
  };
        uint8_t RESERVED5[3];
  union {
    __IO  uint8_t APBC2_PSR;
    stc_crg_apbc2_psr_field_t APBC2_PSR_f;
  };
        uint8_t RESERVED6[3];
  union {
    __IO  uint8_t SWC_PSR;
    stc_crg_swc_psr_field_t SWC_PSR_f;
  };
        uint8_t RESERVED7[7];
  union {
    __IO  uint8_t TTC_PSR;
    stc_crg_ttc_psr_field_t TTC_PSR_f;
  };
        uint8_t RESERVED8[7];
  union {
    __IO  uint8_t CSW_TMR;
    stc_crg_csw_tmr_field_t CSW_TMR_f;
  };
        uint8_t RESERVED9[3];
  union {
    __IO  uint8_t PSW_TMR;
    stc_crg_psw_tmr_field_t PSW_TMR_f;
  };
        uint8_t RESERVED10[3];
  union {
    __IO  uint8_t PLL_CTL1;
    stc_crg_pll_ctl1_field_t PLL_CTL1_f;
  };
        uint8_t RESERVED11[3];
  union {
    __IO  uint8_t PLL_CTL2;
    stc_crg_pll_ctl2_field_t PLL_CTL2_f;
  };
        uint8_t RESERVED12[3];
  union {
    __IO uint16_t CSV_CTL;
    stc_crg_csv_ctl_field_t CSV_CTL_f;
  };
        uint8_t RESERVED13[2];
  union {
    __IO  uint8_t CSV_STR;
    stc_crg_csv_str_field_t CSV_STR_f;
  };
        uint8_t RESERVED14[3];
  __IO uint16_t FCSWH_CTL;
        uint8_t RESERVED15[2];
  __IO uint16_t FCSWL_CTL;
        uint8_t RESERVED16[2];
  __IO uint16_t FCSWD_CTL;
        uint8_t RESERVED17[2];
  union {
    __IO  uint8_t DBWDT_CTL;
    stc_crg_dbwdt_ctl_field_t DBWDT_CTL_f;
  };
        uint8_t RESERVED18[11];
  union {
    __IO  uint8_t INT_ENR;
    stc_crg_int_enr_field_t INT_ENR_f;
  };
        uint8_t RESERVED19[3];
  union {
    __IO  uint8_t INT_STR;
    stc_crg_int_str_field_t INT_STR_f;
  };
        uint8_t RESERVED20[3];
  union {
    __IO  uint8_t INT_CLR;
    stc_crg_int_clr_field_t INT_CLR_f;
  };
}FM3_CRG_TypeDef;

/******************************************************************************
 * HWWDT_MODULE
 ******************************************************************************/
/* Hardware watchdog registers */
typedef struct
{
  __IO uint32_t WDG_LDR;
  __IO uint32_t WDG_VLR;
  union {
    __IO  uint8_t WDG_CTL;
    stc_hwwdt_wdg_ctl_field_t WDG_CTL_f;
  };
        uint8_t RESERVED0[3];
  __IO  uint8_t WDG_ICL;
        uint8_t RESERVED1[3];
  union {
    __IO  uint8_t WDG_RIS;
    stc_hwwdt_wdg_ris_field_t WDG_RIS_f;
  };
        uint8_t RESERVED2[3055];
  __IO uint32_t WDG_LCK;
}FM3_HWWDT_TypeDef;

/******************************************************************************
 * SWWDT_MODULE
 ******************************************************************************/
/* Software watchdog registers */
typedef struct
{
  __IO uint32_t WDOGLOAD;
  __IO uint32_t WDOGVALUE;
  union {
    __IO  uint8_t WDOGCONTROL;
    stc_swwdt_wdogcontrol_field_t WDOGCONTROL_f;
  };
        uint8_t RESERVED0[3];
  __IO uint32_t WDOGINTCLR;
  union {
    __IO  uint8_t WDOGRIS;
    stc_swwdt_wdogris_field_t WDOGRIS_f;
  };
        uint8_t RESERVED1[3055];
  __IO uint32_t WDOGLOCK;
}FM3_SWWDT_TypeDef;

/******************************************************************************
 * DTIM_MODULE
 ******************************************************************************/
/* Dual timer 1/2 registers */
typedef struct
{
  __IO uint32_t TIMER1LOAD;
  __IO uint32_t TIMER1VALUE;
  union {
    __IO uint32_t TIMER1CONTROL;
    stc_dtim_timer1control_field_t TIMER1CONTROL_f;
  };
  __IO uint32_t TIMER1INTCLR;
  union {
    __IO uint32_t TIMER1RIS;
    stc_dtim_timer1ris_field_t TIMER1RIS_f;
  };
  union {
    __IO uint32_t TIMER1MIS;
    stc_dtim_timer1mis_field_t TIMER1MIS_f;
  };
  __IO uint32_t TIMER1BGLOAD;
        uint8_t RESERVED0[4];
  __IO uint32_t TIMER2LOAD;
  __IO uint32_t TIMER2VALUE;
  union {
    __IO uint32_t TIMER2CONTROL;
    stc_dtim_timer2control_field_t TIMER2CONTROL_f;
  };
  __IO uint32_t TIMER2INTCLR;
  union {
    __IO uint32_t TIMER2RIS;
    stc_dtim_timer2ris_field_t TIMER2RIS_f;
  };
  union {
    __IO uint32_t TIMER2MIS;
    stc_dtim_timer2mis_field_t TIMER2MIS_f;
  };
  __IO uint32_t TIMER2BGLOAD;
}FM3_DTIM_TypeDef;

/******************************************************************************
 * MFT_FRT_MODULE
 ******************************************************************************/
/* Multifunction Timer unit 0 Free Running Timer registers */
typedef struct
{
        uint8_t RESERVED0[40];
  __IO uint16_t TCCP0;
        uint8_t RESERVED1[2];
  __IO uint16_t TCDT0;
        uint8_t RESERVED2[2];
  union {
    __IO uint16_t TCSA0;
    stc_mft_frt_tcsa0_field_t TCSA0_f;
  };
        uint8_t RESERVED3[2];
  union {
    __IO uint16_t TCSB0;
    stc_mft_frt_tcsb0_field_t TCSB0_f;
  };
        uint8_t RESERVED4[2];
  __IO uint16_t TCCP1;
        uint8_t RESERVED5[2];
  __IO uint16_t TCDT1;
        uint8_t RESERVED6[2];
  union {
    __IO uint16_t TCSA1;
    stc_mft_frt_tcsa1_field_t TCSA1_f;
  };
        uint8_t RESERVED7[2];
  union {
    __IO uint16_t TCSB1;
    stc_mft_frt_tcsb1_field_t TCSB1_f;
  };
        uint8_t RESERVED8[2];
  __IO uint16_t TCCP2;
        uint8_t RESERVED9[2];
  __IO uint16_t TCDT2;
        uint8_t RESERVED10[2];
  union {
    __IO uint16_t TCSA2;
    stc_mft_frt_tcsa2_field_t TCSA2_f;
  };
        uint8_t RESERVED11[2];
  union {
    __IO uint16_t TCSB2;
    stc_mft_frt_tcsb2_field_t TCSB2_f;
  };
}FM3_MFT_FRT_TypeDef;

/******************************************************************************
 * MFT_OCU_MODULE
 ******************************************************************************/
/* Multifunction Timer unit 0 Output Compare Unit registers */
typedef struct
{
  __IO uint16_t OCCP0;
        uint8_t RESERVED0[2];
  __IO uint16_t OCCP1;
        uint8_t RESERVED1[2];
  __IO uint16_t OCCP2;
        uint8_t RESERVED2[2];
  __IO uint16_t OCCP3;
        uint8_t RESERVED3[2];
  __IO uint16_t OCCP4;
        uint8_t RESERVED4[2];
  __IO uint16_t OCCP5;
        uint8_t RESERVED5[2];
  union {
    __IO  uint8_t OCSA10;
    stc_mft_ocu_ocsa10_field_t OCSA10_f;
  };
  union {
    __IO  uint8_t OCSB10;
    stc_mft_ocu_ocsb10_field_t OCSB10_f;
  };
        uint8_t RESERVED6[2];
  union {
    __IO  uint8_t OCSA32;
    stc_mft_ocu_ocsa32_field_t OCSA32_f;
  };
  union {
    __IO  uint8_t OCSB32;
    stc_mft_ocu_ocsb32_field_t OCSB32_f;
  };
        uint8_t RESERVED7[2];
  union {
    __IO  uint8_t OCSA54;
    stc_mft_ocu_ocsa54_field_t OCSA54_f;
  };
  union {
    __IO  uint8_t OCSB54;
    stc_mft_ocu_ocsb54_field_t OCSB54_f;
  };
        uint8_t RESERVED8[3];
  union {
    __IO  uint8_t OCSC;
    stc_mft_ocu_ocsc_field_t OCSC_f;
  };
        uint8_t RESERVED9[50];
  union {
    __IO  uint8_t OCFS10;
    stc_mft_ocu_ocfs10_field_t OCFS10_f;
  };
  union {
    __IO  uint8_t OCFS32;
    stc_mft_ocu_ocfs32_field_t OCFS32_f;
  };
        uint8_t RESERVED10[2];
  union {
    __IO  uint8_t OCFS54;
    stc_mft_ocu_ocfs54_field_t OCFS54_f;
  };
}FM3_MFT_OCU_TypeDef;

/******************************************************************************
 * MFT_WFG_MODULE
 ******************************************************************************/
/* Multifunction Timer unit 0 Waveform Generator and Noise Canceler registers */
typedef struct
{
        uint8_t RESERVED0[128];
  __IO uint16_t WFTM10;
        uint8_t RESERVED1[2];
  __IO uint16_t WFTM32;
        uint8_t RESERVED2[2];
  __IO uint16_t WFTM54;
        uint8_t RESERVED3[2];
  union {
    __IO uint16_t WFSA10;
    stc_mft_wfg_wfsa10_field_t WFSA10_f;
  };
        uint8_t RESERVED4[2];
  union {
    __IO uint16_t WFSA32;
    stc_mft_wfg_wfsa32_field_t WFSA32_f;
  };
        uint8_t RESERVED5[2];
  union {
    __IO uint16_t WFSA54;
    stc_mft_wfg_wfsa54_field_t WFSA54_f;
  };
        uint8_t RESERVED6[2];
  union {
    __IO uint16_t WFIR;
    stc_mft_wfg_wfir_field_t WFIR_f;
  };
        uint8_t RESERVED7[2];
  union {
    __IO uint16_t NZCL;
    stc_mft_wfg_nzcl_field_t NZCL_f;
  };
}FM3_MFT_WFG_TypeDef;

/******************************************************************************
 * MFT_ICU_MODULE
 ******************************************************************************/
/* Multifunction Timer unit 0 Input Capture Unit registers */
typedef struct
{
        uint8_t RESERVED0[96];
  union {
    __IO  uint8_t ICFS10;
    stc_mft_icu_icfs10_field_t ICFS10_f;
  };
  union {
    __IO  uint8_t ICFS32;
    stc_mft_icu_icfs32_field_t ICFS32_f;
  };
        uint8_t RESERVED1[6];
  __IO uint16_t ICCP0;
        uint8_t RESERVED2[2];
  __IO uint16_t ICCP1;
        uint8_t RESERVED3[2];
  __IO uint16_t ICCP2;
        uint8_t RESERVED4[2];
  __IO uint16_t ICCP3;
        uint8_t RESERVED5[2];
  union {
    __IO  uint8_t ICSA10;
    stc_mft_icu_icsa10_field_t ICSA10_f;
  };
  union {
    __IO  uint8_t ICSB10;
    stc_mft_icu_icsb10_field_t ICSB10_f;
  };
        uint8_t RESERVED6[2];
  union {
    __IO  uint8_t ICSA32;
    stc_mft_icu_icsa32_field_t ICSA32_f;
  };
  union {
    __IO  uint8_t ICSB32;
    stc_mft_icu_icsb32_field_t ICSB32_f;
  };
}FM3_MFT_ICU_TypeDef;

/******************************************************************************
 * MFT_ADCMP_MODULE
 ******************************************************************************/
/* Multifunction Timer unit 0 ADC Start Compare Unit registers */
typedef struct
{
        uint8_t RESERVED0[160];
  __IO uint16_t ACCP0;
        uint8_t RESERVED1[2];
  __IO uint16_t ACCPDN0;
        uint8_t RESERVED2[2];
  __IO uint16_t ACCP1;
        uint8_t RESERVED3[2];
  __IO uint16_t ACCPDN1;
        uint8_t RESERVED4[2];
  __IO uint16_t ACCP2;
        uint8_t RESERVED5[2];
  __IO uint16_t ACCPDN2;
        uint8_t RESERVED6[2];
  union {
    __IO  uint8_t ACSB;
    stc_mft_adcmp_acsb_field_t ACSB_f;
  };
        uint8_t RESERVED7[3];
  union {
    __IO uint16_t ACSA;
    stc_mft_adcmp_acsa_field_t ACSA_f;
  };
        uint8_t RESERVED8[2];
  union {
    __IO uint16_t ATSA;
    stc_mft_adcmp_atsa_field_t ATSA_f;
  };
}FM3_MFT_ADCMP_TypeDef;

/******************************************************************************
 * MFT_PPG_MODULE
 ******************************************************************************/
/* Multifunction Timer PPG registers */
typedef struct
{
        uint8_t RESERVED0;
  union {
    __IO  uint8_t TTCR0;
    stc_mft_ppg_ttcr0_field_t TTCR0_f;
  };
        uint8_t RESERVED1[7];
  __IO  uint8_t COMP0;
        uint8_t RESERVED2[2];
  __IO  uint8_t COMP2;
        uint8_t RESERVED3[4];
  __IO  uint8_t COMP4;
        uint8_t RESERVED4[2];
  __IO  uint8_t COMP6;
        uint8_t RESERVED5[12];
  union {
    __IO  uint8_t TTCR1;
    stc_mft_ppg_ttcr1_field_t TTCR1_f;
  };
        uint8_t RESERVED6[7];
  __IO  uint8_t COMP1;
        uint8_t RESERVED7[2];
  __IO  uint8_t COMP3;
        uint8_t RESERVED8[4];
  __IO  uint8_t COMP5;
        uint8_t RESERVED9[2];
  __IO  uint8_t COMP7;
        uint8_t RESERVED10[12];
  union {
    __IO  uint8_t TTCR2;
    stc_mft_ppg_ttcr2_field_t TTCR2_f;
  };
        uint8_t RESERVED11[7];
  __IO  uint8_t COMP8;
        uint8_t RESERVED12[2];
  __IO  uint8_t COMP10;
        uint8_t RESERVED13[4];
  __IO  uint8_t COMP12;
        uint8_t RESERVED14[2];
  __IO  uint8_t COMP14;
        uint8_t RESERVED15[171];
  union {
    __IO uint16_t TRG;
    stc_mft_ppg_trg_field_t TRG_f;
  };
        uint8_t RESERVED16[2];
  union {
    __IO uint16_t REVC;
    stc_mft_ppg_revc_field_t REVC_f;
  };
        uint8_t RESERVED17[58];
  union {
    __IO uint16_t TRG1;
    stc_mft_ppg_trg1_field_t TRG1_f;
  };
        uint8_t RESERVED18[2];
  union {
    __IO uint16_t REVC1;
    stc_mft_ppg_revc1_field_t REVC1_f;
  };
        uint8_t RESERVED19[186];
  union {
    __IO  uint8_t PPGC1;
    stc_mft_ppg_ppgc1_field_t PPGC1_f;
  };
  union {
    __IO  uint8_t PPGC0;
    stc_mft_ppg_ppgc0_field_t PPGC0_f;
  };
        uint8_t RESERVED20[2];
  union {
    __IO  uint8_t PPGC3;
    stc_mft_ppg_ppgc3_field_t PPGC3_f;
  };
  union {
    __IO  uint8_t PPGC2;
    stc_mft_ppg_ppgc2_field_t PPGC2_f;
  };
        uint8_t RESERVED21[2];
  union {
    __IO uint16_t PRL0;
    struct {
      __IO  uint8_t PRLL0;
      __IO  uint8_t PRLH0;
    };
  };
        uint8_t RESERVED22[2];
  union {
    __IO uint16_t PRL1;
    struct {
      __IO  uint8_t PRLL1;
      __IO  uint8_t PRLH1;
    };
  };
        uint8_t RESERVED23[2];
  union {
    __IO uint16_t PRL2;
    struct {
      __IO  uint8_t PRLL2;
      __IO  uint8_t PRLH2;
    };
  };
        uint8_t RESERVED24[2];
  union {
    __IO uint16_t PRL3;
    struct {
      __IO  uint8_t PRLL3;
      __IO  uint8_t PRLH3;
    };
  };
        uint8_t RESERVED25[2];
  union {
    __IO  uint8_t GATEC0;
    stc_mft_ppg_gatec0_field_t GATEC0_f;
  };
        uint8_t RESERVED26[39];
  union {
    __IO  uint8_t PPGC5;
    stc_mft_ppg_ppgc5_field_t PPGC5_f;
  };
  union {
    __IO  uint8_t PPGC4;
    stc_mft_ppg_ppgc4_field_t PPGC4_f;
  };
        uint8_t RESERVED27[2];
  union {
    __IO  uint8_t PPGC7;
    stc_mft_ppg_ppgc7_field_t PPGC7_f;
  };
  union {
    __IO  uint8_t PPGC6;
    stc_mft_ppg_ppgc6_field_t PPGC6_f;
  };
        uint8_t RESERVED28[2];
  union {
    __IO uint16_t PRL4;
    struct {
      __IO  uint8_t PRLL4;
      __IO  uint8_t PRLH4;
    };
  };
        uint8_t RESERVED29[2];
  union {
    __IO uint16_t PRL5;
    struct {
      __IO  uint8_t PRLL5;
      __IO  uint8_t PRLH5;
    };
  };
        uint8_t RESERVED30[2];
  union {
    __IO uint16_t PRL6;
    struct {
      __IO  uint8_t PRLL6;
      __IO  uint8_t PRLH6;
    };
  };
        uint8_t RESERVED31[2];
  union {
    __IO uint16_t PRL7;
    struct {
      __IO  uint8_t PRLL7;
      __IO  uint8_t PRLH7;
    };
  };
        uint8_t RESERVED32[2];
  union {
    __IO  uint8_t GATEC4;
    stc_mft_ppg_gatec4_field_t GATEC4_f;
  };
        uint8_t RESERVED33[39];
  union {
    __IO  uint8_t PPGC9;
    stc_mft_ppg_ppgc9_field_t PPGC9_f;
  };
  union {
    __IO  uint8_t PPGC8;
    stc_mft_ppg_ppgc8_field_t PPGC8_f;
  };
        uint8_t RESERVED34[2];
  union {
    __IO  uint8_t PPGC11;
    stc_mft_ppg_ppgc11_field_t PPGC11_f;
  };
  union {
    __IO  uint8_t PPGC10;
    stc_mft_ppg_ppgc10_field_t PPGC10_f;
  };
        uint8_t RESERVED35[2];
  union {
    __IO uint16_t PRL8;
    struct {
      __IO  uint8_t PRLL8;
      __IO  uint8_t PRLH8;
    };
  };
        uint8_t RESERVED36[2];
  union {
    __IO uint16_t PRL9;
    struct {
      __IO  uint8_t PRLL9;
      __IO  uint8_t PRLH9;
    };
  };
        uint8_t RESERVED37[2];
  union {
    __IO uint16_t PRL10;
    struct {
      __IO  uint8_t PRLL10;
      __IO  uint8_t PRLH10;
    };
  };
        uint8_t RESERVED38[2];
  union {
    __IO uint16_t PRL11;
    struct {
      __IO  uint8_t PRLL11;
      __IO  uint8_t PRLH11;
    };
  };
        uint8_t RESERVED39[2];
  union {
    __IO  uint8_t GATEC8;
    stc_mft_ppg_gatec8_field_t GATEC8_f;
  };
        uint8_t RESERVED40[39];
  union {
    __IO  uint8_t PPGC13;
    stc_mft_ppg_ppgc13_field_t PPGC13_f;
  };
  union {
    __IO  uint8_t PPGC12;
    stc_mft_ppg_ppgc12_field_t PPGC12_f;
  };
        uint8_t RESERVED41[2];
  union {
    __IO  uint8_t PPGC15;
    stc_mft_ppg_ppgc15_field_t PPGC15_f;
  };
  union {
    __IO  uint8_t PPGC14;
    stc_mft_ppg_ppgc14_field_t PPGC14_f;
  };
        uint8_t RESERVED42[2];
  union {
    __IO uint16_t PRL12;
    struct {
      __IO  uint8_t PRLL12;
      __IO  uint8_t PRLH12;
    };
  };
        uint8_t RESERVED43[2];
  union {
    __IO uint16_t PRL13;
    struct {
      __IO  uint8_t PRLL13;
      __IO  uint8_t PRLH13;
    };
  };
        uint8_t RESERVED44[2];
  union {
    __IO uint16_t PRL14;
    struct {
      __IO  uint8_t PRLL14;
      __IO  uint8_t PRLH14;
    };
  };
        uint8_t RESERVED45[2];
  union {
    __IO uint16_t PRL15;
    struct {
      __IO  uint8_t PRLL15;
      __IO  uint8_t PRLH15;
    };
  };
        uint8_t RESERVED46[2];
  union {
    __IO  uint8_t GATEC12;
    stc_mft_ppg_gatec12_field_t GATEC12_f;
  };
        uint8_t RESERVED47[39];  
  union {
    __IO  uint8_t PPGC17;
    stc_mft_ppg_ppgc17_field_t PPGC17_f;
  };
  union {
    __IO  uint8_t PPGC16;
    stc_mft_ppg_ppgc16_field_t PPGC16_f;
  };
        uint8_t RESERVED48[2];
  union {
    __IO  uint8_t PPGC19;
    stc_mft_ppg_ppgc19_field_t PPGC19_f;
  };
  union {
    __IO  uint8_t PPGC18;
    stc_mft_ppg_ppgc18_field_t PPGC18_f;
  };
        uint8_t RESERVED49[2];
  union {
    __IO uint16_t PRL16;
    struct {
      __IO  uint8_t PRLL16;
      __IO  uint8_t PRLH16;
    };
  };
        uint8_t RESERVED50[2];
  union {
    __IO uint16_t PRL17;
    struct {
      __IO  uint8_t PRLL17;
      __IO  uint8_t PRLH17;
    };
  };
        uint8_t RESERVED51[2];
  union {
    __IO uint16_t PRL18;
    struct {
      __IO  uint8_t PRLL18;
      __IO  uint8_t PRLH18;
    };
  };
        uint8_t RESERVED52[2];
  union {
    __IO uint16_t PRL19;
    struct {
      __IO  uint8_t PRLL19;
      __IO  uint8_t PRLH19;
    };
  };
        uint8_t RESERVED53[2];
  union {
    __IO  uint8_t GATEC16;
    stc_mft_ppg_gatec16_field_t GATEC16_f;
  };
        uint8_t RESERVED54[39];
  union {
    __IO  uint8_t PPGC21;
    stc_mft_ppg_ppgc21_field_t PPGC21_f;
  };
  union {
    __IO  uint8_t PPGC20;
    stc_mft_ppg_ppgc20_field_t PPGC20_f;
  };
        uint8_t RESERVED55[2];
  union {
    __IO  uint8_t PPGC23;
    stc_mft_ppg_ppgc23_field_t PPGC23_f;
  };
  union {
    __IO  uint8_t PPGC22;
    stc_mft_ppg_ppgc22_field_t PPGC22_f;
  };
        uint8_t RESERVED56[2];
  union {
    __IO uint16_t PRL20;
    struct {
      __IO  uint8_t PRLL20;
      __IO  uint8_t PRLH20;
    };
  };
        uint8_t RESERVED57[2];
  union {
    __IO uint16_t PRL21;
    struct {
      __IO  uint8_t PRLL21;
      __IO  uint8_t PRLH21;
    };
  };
        uint8_t RESERVED58[2];
  union {
    __IO uint16_t PRL22;
    struct {
      __IO  uint8_t PRLL22;
      __IO  uint8_t PRLH22;
    };
  };
        uint8_t RESERVED59[2];
  union {
    __IO uint16_t PRL23;
    struct {
      __IO  uint8_t PRLL23;
      __IO  uint8_t PRLH23;
    };
  };
        uint8_t RESERVED60[2];
  union {
    __IO  uint8_t GATEC20;
    stc_mft_ppg_gatec20_field_t GATEC20_f;
  };
}FM3_MFT_PPG_TypeDef;

/******************************************************************************
 * BT_PPG_MODULE
 ******************************************************************************/
/* Base Timer 0 PPG registers */
typedef struct
{
  __IO uint16_t PRLL;
        uint8_t RESERVED0[2];
  __IO uint16_t PRLH;
        uint8_t RESERVED1[2];
  __IO uint16_t TMR;
        uint8_t RESERVED2[2];
  union {
    __IO uint16_t TMCR;
    stc_bt_ppg_tmcr_field_t TMCR_f;
  };
        uint8_t RESERVED3[2];
  union {
    __IO  uint8_t STC;
    stc_bt_ppg_stc_field_t STC_f;
  };
  union {
    __IO  uint8_t TMCR2;
    stc_bt_ppg_tmcr2_field_t TMCR2_f;
  };
}FM3_BT_PPG_TypeDef;

/******************************************************************************
 * BT_PWM_MODULE
 ******************************************************************************/
/* Base Timer 0 PWM registers */
typedef struct
{
  __IO uint16_t PCSR;
        uint8_t RESERVED0[2];
  __IO uint16_t PDUT;
        uint8_t RESERVED1[2];
  __IO uint16_t TMR;
        uint8_t RESERVED2[2];
  union {
    __IO uint16_t TMCR;
    stc_bt_pwm_tmcr_field_t TMCR_f;
  };
        uint8_t RESERVED3[2];
  union {
    __IO  uint8_t STC;
    stc_bt_pwm_stc_field_t STC_f;
  };
  union {
    __IO  uint8_t TMCR2;
    stc_bt_pwm_tmcr2_field_t TMCR2_f;
  };
}FM3_BT_PWM_TypeDef;

/******************************************************************************
 * BT_RT_MODULE
 ******************************************************************************/
/* Base Timer 0 RT registers */
typedef struct
{
  __IO uint16_t PCSR;
        uint8_t RESERVED0[6];
  __IO uint16_t TMR;
        uint8_t RESERVED1[2];
  union {
    __IO uint16_t TMCR;
    stc_bt_rt_tmcr_field_t TMCR_f;
  };
        uint8_t RESERVED2[2];
  union {
    __IO  uint8_t STC;
    stc_bt_rt_stc_field_t STC_f;
  };
  union {
    __IO  uint8_t TMCR2;
    stc_bt_rt_tmcr2_field_t TMCR2_f;
  };
}FM3_BT_RT_TypeDef;

/******************************************************************************
 * BT_PWC_MODULE
 ******************************************************************************/
/* Base Timer 0 PWC registers */
typedef struct
{
        uint8_t RESERVED0[4];
  __IO uint16_t DTBF;
        uint8_t RESERVED1[6];
  union {
    __IO uint16_t TMCR;
    stc_bt_pwc_tmcr_field_t TMCR_f;
  };
        uint8_t RESERVED2[2];
  union {
    __IO  uint8_t STC;
    stc_bt_pwc_stc_field_t STC_f;
  };
  union {
    __IO  uint8_t TMCR2;
    stc_bt_pwc_tmcr2_field_t TMCR2_f;
  };
}FM3_BT_PWC_TypeDef;

/******************************************************************************
 * BTIOSEL03_MODULE
 ******************************************************************************/
/* Base Timer I/O selector channel 0 - channel 3 registers */
typedef struct
{
        uint8_t RESERVED0;
  union {
    __IO  uint8_t BTSEL0123;
    stc_btiosel03_btsel0123_field_t BTSEL0123_f;
  };
}FM3_BTIOSEL03_TypeDef;

/******************************************************************************
 * BTIOSEL47_MODULE
 ******************************************************************************/
/* Base Timer I/O selector channel 4 - channel 7 registers */
typedef struct
{
        uint8_t RESERVED0;
  union {
    __IO  uint8_t BTSEL4567;
    stc_btiosel47_btsel4567_field_t BTSEL4567_f;
  };
}FM3_BTIOSEL47_TypeDef;

/******************************************************************************
 * BTIOSEL8B_MODULE
 ******************************************************************************/
/* Base Timer I/O selector channel 8 - channel 11 registers */
typedef struct
{
        uint8_t RESERVED0;
  union {
    __IO  uint8_t BTSEL89AB;
    stc_btiosel8b_btsel89ab_field_t BTSEL89AB_f;
  };
}FM3_BTIOSEL8B_TypeDef;

/******************************************************************************
 * BTIOSELCF_MODULE
 ******************************************************************************/
/* Base Timer I/O selector channel 12 - channel 15 registers */
typedef struct
{
        uint8_t RESERVED0;
  union {
    __IO  uint8_t BTSELCDEF;
    stc_btioselcf_btselcdef_field_t BTSELCDEF_f;
  };
}FM3_BTIOSELCF_TypeDef;

/******************************************************************************
 * SBSSR_MODULE
 ******************************************************************************/
/* Software based Simulation Startup (Base Timer) register */
typedef struct
{
  union {
    __IO uint16_t BTSSSR;
    stc_sbssr_btsssr_field_t BTSSSR_f;
  };
}FM3_SBSSR_TypeDef;

/******************************************************************************
 * QPRC_MODULE
 ******************************************************************************/
/* Quad position and revolution counter channel 0 registers */
typedef struct
{
  __IO uint16_t QPCR;
        uint8_t RESERVED0[2];
  __IO uint16_t QRCR;
        uint8_t RESERVED1[2];
  __IO uint16_t QPCCR;
        uint8_t RESERVED2[2];
  __IO uint16_t QPRCR;
        uint8_t RESERVED3[2];
  __IO uint16_t QMPR;
        uint8_t RESERVED4[2];
  union {
    union {
      __IO uint16_t QICR;
      stc_qprc_qicr_field_t QICR_f;
    };
    struct {
      union {
        __IO  uint8_t QICRL;
        stc_qprc_qicrl_field_t QICRL_f;
      };
      union {
        __IO  uint8_t QICRH;
        stc_qprc_qicrh_field_t QICRH_f;
      };
    };
  };
        uint8_t RESERVED5[2];
  union {
    union {
      __IO uint16_t QCR;
      stc_qprc_qcr_field_t QCR_f;
    };
    struct {
      union {
        __IO  uint8_t QCRL;
        stc_qprc_qcrl_field_t QCRL_f;
      };
      union {
        __IO  uint8_t QCRH;
        stc_qprc_qcrh_field_t QCRH_f;
      };
    };
  };
        uint8_t RESERVED6[2];
  union {
    __IO uint16_t QECR;
    stc_qprc_qecr_field_t QECR_f;
  };
        uint8_t RESERVED7[30];
  union {
    __IO uint32_t QPRCRR;
    struct {
      __IO uint16_t QRCRR;
      __IO uint16_t QPCRR;
    };
  };
}FM3_QPRC_TypeDef;

/******************************************************************************
 * ADC12_MODULE
 ******************************************************************************/
/* 12-bit ADC unit 0 registers */
typedef struct
{
  union {
    __IO  uint8_t ADSR;
    stc_adc_adsr_field_t ADSR_f;
  };
  union {
    __IO  uint8_t ADCR;
    stc_adc_adcr_field_t ADCR_f;
  };
        uint8_t RESERVED0[6];
  union {
    __IO  uint8_t SFNS;
    stc_adc_sfns_field_t SFNS_f;
  };
  union {
    __IO  uint8_t SCCR;
    stc_adc_sccr_field_t SCCR_f;
  };
        uint8_t RESERVED1[2];
  union {
    union {
      __IO uint32_t SCFD;
      stc_adc_scfd_field_t SCFD_f;
    };
    struct {
      union {
        __IO uint16_t SCFDL;
        stc_adc_scfdl_field_t SCFDL_f;
      };
      union {
        __IO uint16_t SCFDH;
        stc_adc_scfdh_field_t SCFDH_f;
      };
    };
  };
  union {
    union {
      __IO uint16_t SCIS23;
      stc_adc_scis23_field_t SCIS23_f;
    };
    struct {
      union {
        __IO  uint8_t SCIS2;
        stc_adc_scis2_field_t SCIS2_f;
      };
      union {
        __IO  uint8_t SCIS3;
        stc_adc_scis3_field_t SCIS3_f;
      };
    };
  };
        uint8_t RESERVED2[2];
  union {
    union {
      __IO uint16_t SCIS01;
      stc_adc_scis01_field_t SCIS01_f;
    };
    struct {
      union {
        __IO  uint8_t SCIS0;
        stc_adc_scis0_field_t SCIS0_f;
      };
      union {
        __IO  uint8_t SCIS1;
        stc_adc_scis1_field_t SCIS1_f;
      };
    };
  };
        uint8_t RESERVED3[2];
  union {
    __IO  uint8_t PFNS;
    stc_adc_pfns_field_t PFNS_f;
  };
  union {
    __IO  uint8_t PCCR;
    stc_adc_pccr_field_t PCCR_f;
  };
        uint8_t RESERVED4[2];
  union {
    union {
      __IO uint32_t PCFD;
      stc_adc_pcfd_field_t PCFD_f;
    };
    struct {
      union {
        __IO uint16_t PCFDL;
        stc_adc_pcfdl_field_t PCFDL_f;
      };
      union {
        __IO uint16_t PCFDH;
        stc_adc_pcfdh_field_t PCFDH_f;
      };
    };
  };
  union {
    __IO  uint8_t PCIS;
    stc_adc_pcis_field_t PCIS_f;
  };
        uint8_t RESERVED5[3];
  union {
    __IO  uint8_t CMPCR;
    stc_adc_cmpcr_field_t CMPCR_f;
  };
        uint8_t RESERVED6;
  union {
    __IO uint16_t CMPD;
    stc_adc_cmpd_field_t CMPD_f;
  };
  union {
    union {
      __IO uint16_t ADSS23;
      stc_adc_adss23_field_t ADSS23_f;
    };
    struct {
      union {
        __IO  uint8_t ADSS2;
        stc_adc_adss2_field_t ADSS2_f;
      };
      union {
        __IO  uint8_t ADSS3;
        stc_adc_adss3_field_t ADSS3_f;
      };
    };
  };
        uint8_t RESERVED7[2];
  union {
    union {
      __IO uint16_t ADSS01;
      stc_adc_adss01_field_t ADSS01_f;
    };
    struct {
      union {
        __IO  uint8_t ADSS0;
        stc_adc_adss0_field_t ADSS0_f;
      };
      union {
        __IO  uint8_t ADSS1;
        stc_adc_adss1_field_t ADSS1_f;
      };
    };
  };
        uint8_t RESERVED8[2];
  union {
    union {
      __IO uint16_t ADST01;
      stc_adc_adst01_field_t ADST01_f;
    };
    struct {
      union {
        __IO  uint8_t ADST1;
        stc_adc_adst1_field_t ADST1_f;
      };
      union {
        __IO  uint8_t ADST0;
        stc_adc_adst0_field_t ADST0_f;
      };
    };
  };
        uint8_t RESERVED9[2];
  union {
    __IO  uint8_t ADCT;
    stc_adc_adct_field_t ADCT_f;
  };
        uint8_t RESERVED10[3];
  union {
    __IO  uint8_t PRTSL;
    stc_adc_prtsl_field_t PRTSL_f;
  };
  union {
    __IO  uint8_t SCTSL;
    stc_adc_sctsl_field_t SCTSL_f;
  };
        uint8_t RESERVED11[2];
  union {
    __IO  uint8_t ADCEN;
    stc_adc_adcen_field_t ADCEN_f;
  };
}FM3_ADC_TypeDef;

/******************************************************************************
 * CRTRIM_MODULE
 ******************************************************************************/
/* CR trimming registers */
typedef struct
{
  union {
    __IO  uint8_t MCR_PSR;
    stc_crtrim_mcr_psr_field_t MCR_PSR_f;
  };
        uint8_t RESERVED0[3];
  union {
    __IO uint16_t MCR_FTRM;
    stc_crtrim_mcr_ftrm_field_t MCR_FTRM_f;
  };
        uint8_t RESERVED1[6];
  __IO uint32_t MCR_RLR;
}FM3_CRTRIM_TypeDef;

/******************************************************************************
 * EXTI_MODULE
 ******************************************************************************/
/* External interrupt registers */
typedef struct
{
  union {
    __IO uint32_t ENIR;
    stc_exti_enir_field_t ENIR_f;
  };
  union {
    __IO uint32_t EIRR;
    stc_exti_eirr_field_t EIRR_f;
  };
  union {
    __IO uint32_t EICL;
    stc_exti_eicl_field_t EICL_f;
  };
  union {
    __IO uint32_t ELVR;
    stc_exti_elvr_field_t ELVR_f;
  };
  union {
    __IO uint32_t ELVR1;
    stc_exti_elvr1_field_t ELVR1_f;
  };
  union {
    __IO  uint8_t NMIRR;
    stc_exti_nmirr_field_t NMIRR_f;
  };
        uint8_t RESERVED4[3];
  union {
    __IO  uint8_t NMICL;
    stc_exti_nmicl_field_t NMICL_f;
  };
}FM3_EXTI_TypeDef;

/******************************************************************************
 * INTREQ_MODULE
 ******************************************************************************/
/* Interrupt request read registers */
typedef struct
{
  union {
    __IO uint32_t DRQSEL;
    stc_intreq_drqsel_field_t DRQSEL_f;
  };
        uint8_t RESERVED0[7];
  union {
    __IO  uint8_t ODDPKS;
    stc_intreq_oddpks_field_t ODDPKS_f;
  };
        uint8_t RESERVED1[4];
  union {
    __IO uint32_t EXC02MON;
    stc_intreq_exc02mon_field_t EXC02MON_f;
  };
  union {
    __IO uint32_t IRQ00MON;
    stc_intreq_irq00mon_field_t IRQ00MON_f;
  };
  union {
    __IO uint32_t IRQ01MON;
    stc_intreq_irq01mon_field_t IRQ01MON_f;
  };
  union {
    __IO uint32_t IRQ02MON;
    stc_intreq_irq02mon_field_t IRQ02MON_f;
  };
  union {
    __IO uint32_t IRQ03MON;
    stc_intreq_irq03mon_field_t IRQ03MON_f;
  };
  union {
    __IO uint32_t IRQ04MON;
    stc_intreq_irq04mon_field_t IRQ04MON_f;
  };
  union {
    __IO uint32_t IRQ05MON;
    stc_intreq_irq05mon_field_t IRQ05MON_f;
  };
  union {
    __IO uint32_t IRQ06MON;
    stc_intreq_irq06mon_field_t IRQ06MON_f;
  };
  union {
    __IO uint32_t IRQ07MON;
    stc_intreq_irq07mon_field_t IRQ07MON_f;
  };
  union {
    __IO uint32_t IRQ08MON;
    stc_intreq_irq08mon_field_t IRQ08MON_f;
  };
  union {
    __IO uint32_t IRQ09MON;
    stc_intreq_irq09mon_field_t IRQ09MON_f;
  };
  union {
    __IO uint32_t IRQ10MON;
    stc_intreq_irq10mon_field_t IRQ10MON_f;
  };
  union {
    __IO uint32_t IRQ11MON;
    stc_intreq_irq11mon_field_t IRQ11MON_f;
  };
  union {
    __IO uint32_t IRQ12MON;
    stc_intreq_irq12mon_field_t IRQ12MON_f;
  };
  union {
    __IO uint32_t IRQ13MON;
    stc_intreq_irq13mon_field_t IRQ13MON_f;
  };
  union {
    __IO uint32_t IRQ14MON;
    stc_intreq_irq14mon_field_t IRQ14MON_f;
  };
  union {
    __IO uint32_t IRQ15MON;
    stc_intreq_irq15mon_field_t IRQ15MON_f;
  };
  union {
    __IO uint32_t IRQ16MON;
    stc_intreq_irq16mon_field_t IRQ16MON_f;
  };
  union {
    __IO uint32_t IRQ17MON;
    stc_intreq_irq17mon_field_t IRQ17MON_f;
  };
  union {
    __IO uint32_t IRQ18MON;
    stc_intreq_irq18mon_field_t IRQ18MON_f;
  };
  union {
    __IO uint32_t IRQ19MON;
    stc_intreq_irq19mon_field_t IRQ19MON_f;
  };
  union {
    __IO uint32_t IRQ20MON;
    stc_intreq_irq20mon_field_t IRQ20MON_f;
  };
  union {
    __IO uint32_t IRQ21MON;
    stc_intreq_irq21mon_field_t IRQ21MON_f;
  };
  union {
    __IO uint32_t IRQ22MON;
    stc_intreq_irq22mon_field_t IRQ22MON_f;
  };
  union {
    __IO uint32_t IRQ23MON;
    stc_intreq_irq23mon_field_t IRQ23MON_f;
  };
  union {
    __IO uint32_t IRQ24MON;
    stc_intreq_irq24mon_field_t IRQ24MON_f;
  };
  union {
    __IO uint32_t IRQ25MON;
    stc_intreq_irq25mon_field_t IRQ25MON_f;
  };
  union {
    __IO uint32_t IRQ26MON;
    stc_intreq_irq26mon_field_t IRQ26MON_f;
  };
  union {
    __IO uint32_t IRQ27MON;
    stc_intreq_irq27mon_field_t IRQ27MON_f;
  };
  union {
    __IO uint32_t IRQ28MON;
    stc_intreq_irq28mon_field_t IRQ28MON_f;
  };
  union {
    __IO uint32_t IRQ29MON;
    stc_intreq_irq29mon_field_t IRQ29MON_f;
  };
  union {
    __IO uint32_t IRQ30MON;
    stc_intreq_irq30mon_field_t IRQ30MON_f;
  };
  union {
    __IO uint32_t IRQ31MON;
    stc_intreq_irq31mon_field_t IRQ31MON_f;
  };
  union {
    __IO uint32_t IRQ32MON;
    stc_intreq_irq32mon_field_t IRQ32MON_f;
  };
  union {
    __IO uint32_t IRQ33MON;
    stc_intreq_irq33mon_field_t IRQ33MON_f;
  };
  union {
    __IO uint32_t IRQ34MON;
    stc_intreq_irq34mon_field_t IRQ34MON_f;
  };
  union {
    __IO uint32_t IRQ35MON;
    stc_intreq_irq35mon_field_t IRQ35MON_f;
  };
  union {
    __IO uint32_t IRQ36MON;
    stc_intreq_irq36mon_field_t IRQ36MON_f;
  };
  union {
    __IO uint32_t IRQ37MON;
    stc_intreq_irq37mon_field_t IRQ37MON_f;
  };
  union {
    __IO uint32_t IRQ38MON;
    stc_intreq_irq38mon_field_t IRQ38MON_f;
  };
  union {
    __IO uint32_t IRQ39MON;
    stc_intreq_irq39mon_field_t IRQ39MON_f;
  };
  union {
    __IO uint32_t IRQ40MON;
    stc_intreq_irq40mon_field_t IRQ40MON_f;
  };
  union {
    __IO uint32_t IRQ41MON;
    stc_intreq_irq41mon_field_t IRQ41MON_f;
  };
  union {
    __IO uint32_t IRQ42MON;
    stc_intreq_irq42mon_field_t IRQ42MON_f;
  };
  union {
    __IO uint32_t IRQ43MON;
    stc_intreq_irq43mon_field_t IRQ43MON_f;
  };
  union {
    __IO uint32_t IRQ44MON;
    stc_intreq_irq44mon_field_t IRQ44MON_f;
  };
  union {
    __IO uint32_t IRQ45MON;
    stc_intreq_irq45mon_field_t IRQ45MON_f;
  };
  union {
    __IO uint32_t IRQ46MON;
    stc_intreq_irq46mon_field_t IRQ46MON_f;
  };
    __IO uint32_t IRQ47MON;
        uint8_t RESERVED2[300];
  union {
    __IO uint32_t DRQSEL1;
    stc_intreq_drqsel1_field_t DRQSEL1_f;
  };
  union {
    __IO uint32_t DQESEL;
    stc_intreq_dqesel_field_t DQESEL_f;
  };
        uint8_t RESERVED3[7];
  union {
    __IO  uint8_t ODDPKS1;
    stc_intreq_oddpks1_field_t ODDPKS1_f;
  };
}FM3_INTREQ_TypeDef;

/******************************************************************************
 * GPIO_MODULE
 ******************************************************************************/
/* General purpose I/O registers */
typedef struct
{
  union {
    __IO uint32_t PFR0;
    stc_gpio_pfr0_field_t PFR0_f;
  };
  union {
    __IO uint32_t PFR1;
    stc_gpio_pfr1_field_t PFR1_f;
  };
  union {
    __IO uint32_t PFR2;
    stc_gpio_pfr2_field_t PFR2_f;
  };
  union {
    __IO uint32_t PFR3;
    stc_gpio_pfr3_field_t PFR3_f;
  };
  union {
    __IO uint32_t PFR4;
    stc_gpio_pfr4_field_t PFR4_f;
  };
  union {
    __IO uint32_t PFR5;
    stc_gpio_pfr5_field_t PFR5_f;
  };
  union {
    __IO uint32_t PFR6;
    stc_gpio_pfr6_field_t PFR6_f;
  };
  union {
    __IO uint32_t PFR7;
    stc_gpio_pfr7_field_t PFR7_f;
  };
  union {
    __IO uint32_t PFR8;
    stc_gpio_pfr8_field_t PFR8_f;
  };
  union {
    __IO uint32_t PFR9;
    stc_gpio_pfr9_field_t PFR9_f;
  };
  union {
    __IO uint32_t PFRA;
    stc_gpio_pfra_field_t PFRA_f;
  };
  union {
    __IO uint32_t PFRB;
    stc_gpio_pfrb_field_t PFRB_f;
  };
  union {
    __IO uint32_t PFRC;
    stc_gpio_pfrc_field_t PFRC_f;
  };
  union {
    __IO uint32_t PFRD;
    stc_gpio_pfrd_field_t PFRD_f;
  };
  union {
    __IO uint32_t PFRE;
    stc_gpio_pfre_field_t PFRE_f;
  };
  union {
    __IO uint32_t PFRF;
    stc_gpio_pfrf_field_t PFRF_f;
  };
        uint8_t RESERVED0[192];
  union {
    __IO uint32_t PCR0;
    stc_gpio_pcr0_field_t PCR0_f;
  };
  union {
    __IO uint32_t PCR1;
    stc_gpio_pcr1_field_t PCR1_f;
  };
  union {
    __IO uint32_t PCR2;
    stc_gpio_pcr2_field_t PCR2_f;
  };
  union {
    __IO uint32_t PCR3;
    stc_gpio_pcr3_field_t PCR3_f;
  };
  union {
    __IO uint32_t PCR4;
    stc_gpio_pcr4_field_t PCR4_f;
  };
  union {
    __IO uint32_t PCR5;
    stc_gpio_pcr5_field_t PCR5_f;
  };
  union {
    __IO uint32_t PCR6;
    stc_gpio_pcr6_field_t PCR6_f;
  };
  union {
    __IO uint32_t PCR7;
    stc_gpio_pcr7_field_t PCR7_f;
  };
  __IO uint32_t PCR8;
  union {
    __IO uint32_t PCR9;
    stc_gpio_pcr9_field_t PCR9_f;
  };
  union {
    __IO uint32_t PCRA;
    stc_gpio_pcra_field_t PCRA_f;
  };
  union {
    __IO uint32_t PCRB;
    stc_gpio_pcrb_field_t PCRB_f;
  };
  union {
    __IO uint32_t PCRC;
    stc_gpio_pcrc_field_t PCRC_f;
  };
  union {
    __IO uint32_t PCRD;
    stc_gpio_pcrd_field_t PCRD_f;
  };
  union {
    __IO uint32_t PCRE;
    stc_gpio_pcre_field_t PCRE_f;
  };
  __IO uint32_t PCRF;
        uint8_t RESERVED1[192];
  union {
    __IO uint32_t DDR0;
    stc_gpio_ddr0_field_t DDR0_f;
  };
  union {
    __IO uint32_t DDR1;
    stc_gpio_ddr1_field_t DDR1_f;
  };
  union {
    __IO uint32_t DDR2;
    stc_gpio_ddr2_field_t DDR2_f;
  };
  union {
    __IO uint32_t DDR3;
    stc_gpio_ddr3_field_t DDR3_f;
  };
  union {
    __IO uint32_t DDR4;
    stc_gpio_ddr4_field_t DDR4_f;
  };
  union {
    __IO uint32_t DDR5;
    stc_gpio_ddr5_field_t DDR5_f;
  };
  union {
    __IO uint32_t DDR6;
    stc_gpio_ddr6_field_t DDR6_f;
  };
  union {
    __IO uint32_t DDR7;
    stc_gpio_ddr7_field_t DDR7_f;
  };
  union {
    __IO uint32_t DDR8;
    stc_gpio_ddr8_field_t DDR8_f;
  };
  union {
    __IO uint32_t DDR9;
    stc_gpio_ddr9_field_t DDR9_f;
  };
  union {
    __IO uint32_t DDRA;
    stc_gpio_ddra_field_t DDRA_f;
  };
  union {
    __IO uint32_t DDRB;
    stc_gpio_ddrb_field_t DDRB_f;
  };
  union {
    __IO uint32_t DDRC;
    stc_gpio_ddrc_field_t DDRC_f;
  };
  union {
    __IO uint32_t DDRD;
    stc_gpio_ddrd_field_t DDRD_f;
  };
  union {
    __IO uint32_t DDRE;
    stc_gpio_ddre_field_t DDRE_f;
  };
  union {
    __IO uint32_t DDRF;
    stc_gpio_ddrf_field_t DDRF_f;
  };
        uint8_t RESERVED2[192];
  union {
    __IO uint32_t PDIR0;
    stc_gpio_pdir0_field_t PDIR0_f;
  };
  union {
    __IO uint32_t PDIR1;
    stc_gpio_pdir1_field_t PDIR1_f;
  };
  union {
    __IO uint32_t PDIR2;
    stc_gpio_pdir2_field_t PDIR2_f;
  };
  union {
    __IO uint32_t PDIR3;
    stc_gpio_pdir3_field_t PDIR3_f;
  };
  union {
    __IO uint32_t PDIR4;
    stc_gpio_pdir4_field_t PDIR4_f;
  };
  union {
    __IO uint32_t PDIR5;
    stc_gpio_pdir5_field_t PDIR5_f;
  };
  union {
    __IO uint32_t PDIR6;
    stc_gpio_pdir6_field_t PDIR6_f;
  };
  union {
    __IO uint32_t PDIR7;
    stc_gpio_pdir7_field_t PDIR7_f;
  };
  union {
    __IO uint32_t PDIR8;
    stc_gpio_pdir8_field_t PDIR8_f;
  };
  union {
    __IO uint32_t PDIR9;
    stc_gpio_pdir9_field_t PDIR9_f;
  };
  union {
    __IO uint32_t PDIRA;
    stc_gpio_pdira_field_t PDIRA_f;
  };
  union {
    __IO uint32_t PDIRB;
    stc_gpio_pdirb_field_t PDIRB_f;
  };
  union {
    __IO uint32_t PDIRC;
    stc_gpio_pdirc_field_t PDIRC_f;
  };
  union {
    __IO uint32_t PDIRD;
    stc_gpio_pdird_field_t PDIRD_f;
  };
  union {
    __IO uint32_t PDIRE;
    stc_gpio_pdire_field_t PDIRE_f;
  };
  union {
    __IO uint32_t PDIRF;
    stc_gpio_pdirf_field_t PDIRF_f;
  };
        uint8_t RESERVED3[192];
  union {
    __IO uint32_t PDOR0;
    stc_gpio_pdor0_field_t PDOR0_f;
  };
  union {
    __IO uint32_t PDOR1;
    stc_gpio_pdor1_field_t PDOR1_f;
  };
  union {
    __IO uint32_t PDOR2;
    stc_gpio_pdor2_field_t PDOR2_f;
  };
  union {
    __IO uint32_t PDOR3;
    stc_gpio_pdor3_field_t PDOR3_f;
  };
  union {
    __IO uint32_t PDOR4;
    stc_gpio_pdor4_field_t PDOR4_f;
  };
  union {
    __IO uint32_t PDOR5;
    stc_gpio_pdor5_field_t PDOR5_f;
  };
  union {
    __IO uint32_t PDOR6;
    stc_gpio_pdor6_field_t PDOR6_f;
  };
  union {
    __IO uint32_t PDOR7;
    stc_gpio_pdor7_field_t PDOR7_f;
  };
  union {
    __IO uint32_t PDOR8;
    stc_gpio_pdor8_field_t PDOR8_f;
  };
  union {
    __IO uint32_t PDOR9;
    stc_gpio_pdor9_field_t PDOR9_f;
  };
  union {
    __IO uint32_t PDORA;
    stc_gpio_pdora_field_t PDORA_f;
  };
  union {
    __IO uint32_t PDORB;
    stc_gpio_pdorb_field_t PDORB_f;
  };
  union {
    __IO uint32_t PDORC;
    stc_gpio_pdorc_field_t PDORC_f;
  };
  union {
    __IO uint32_t PDORD;
    stc_gpio_pdord_field_t PDORD_f;
  };
  union {
    __IO uint32_t PDORE;
    stc_gpio_pdore_field_t PDORE_f;
  };
  union {
    __IO uint32_t PDORF;
    stc_gpio_pdorf_field_t PDORF_f;
  };
        uint8_t RESERVED4[192];
  union {
    __IO uint32_t ADE;
    stc_gpio_ade_field_t ADE_f;
  };
        uint8_t RESERVED5[124];
  union {
    __IO uint32_t SPSR;
    stc_gpio_spsr_field_t SPSR_f;
  };
        uint8_t RESERVED6[124];
  union {
    __IO uint32_t EPFR00;
    stc_gpio_epfr00_field_t EPFR00_f;
  };
  union {
    __IO uint32_t EPFR01;
    stc_gpio_epfr01_field_t EPFR01_f;
  };
  union {
    __IO uint32_t EPFR02;
    stc_gpio_epfr02_field_t EPFR02_f;
  };
  union {
    __IO uint32_t EPFR03;
    stc_gpio_epfr03_field_t EPFR03_f;
  };
  union {
    __IO uint32_t EPFR04;
    stc_gpio_epfr04_field_t EPFR04_f;
  };
  union {
    __IO uint32_t EPFR05;
    stc_gpio_epfr05_field_t EPFR05_f;
  };
  union {
    __IO uint32_t EPFR06;
    stc_gpio_epfr06_field_t EPFR06_f;
  };
  union {
    __IO uint32_t EPFR07;
    stc_gpio_epfr07_field_t EPFR07_f;
  };
  union {
    __IO uint32_t EPFR08;
    stc_gpio_epfr08_field_t EPFR08_f;
  };
  union {
    __IO uint32_t EPFR09;
    stc_gpio_epfr09_field_t EPFR09_f;
  };
  union {
    __IO uint32_t EPFR10;
    stc_gpio_epfr10_field_t EPFR10_f;
  };
  union {
    __IO uint32_t EPFR11;
    stc_gpio_epfr11_field_t EPFR11_f;
  };
  union {
    __IO uint32_t EPFR12;
    stc_gpio_epfr12_field_t EPFR12_f;
  };
  union {
    __IO uint32_t EPFR13;
    stc_gpio_epfr13_field_t EPFR13_f;
  };
  union {
    __IO uint32_t EPFR14;
    stc_gpio_epfr14_field_t EPFR14_f;
  };
  union {
    __IO uint32_t EPFR15;
    stc_gpio_epfr15_field_t EPFR15_f;
  };
        uint8_t RESERVED7[192];
  union {
    __IO uint32_t PZR0;
    stc_gpio_pzr0_field_t PZR0_f;
  };
  union {
    __IO uint32_t PZR1;
    stc_gpio_pzr1_field_t PZR1_f;
  };
  union {
    __IO uint32_t PZR2;
    stc_gpio_pzr2_field_t PZR2_f;
  };
  union {
    __IO uint32_t PZR3;
    stc_gpio_pzr3_field_t PZR3_f;
  };
  union {
    __IO uint32_t PZR4;
    stc_gpio_pzr4_field_t PZR4_f;
  };
  union {
    __IO uint32_t PZR5;
    stc_gpio_pzr5_field_t PZR5_f;
  };
  union {
    __IO uint32_t PZR6;
    stc_gpio_pzr6_field_t PZR6_f;
  };
  union {
    __IO uint32_t PZR7;
    stc_gpio_pzr7_field_t PZR7_f;
  };
  union {
    __IO uint32_t PZR8;
    stc_gpio_pzr8_field_t PZR8_f;
  };
  union {
    __IO uint32_t PZR9;
    stc_gpio_pzr9_field_t PZR9_f;
  };
  union {
    __IO uint32_t PZRA;
    stc_gpio_pzra_field_t PZRA_f;
  };
  union {
    __IO uint32_t PZRB;
    stc_gpio_pzrb_field_t PZRB_f;
  };
  union {
    __IO uint32_t PZRC;
    stc_gpio_pzrc_field_t PZRC_f;
  };
  union {
    __IO uint32_t PZRD;
    stc_gpio_pzrd_field_t PZRD_f;
  };
  union {
    __IO uint32_t PZRE;
    stc_gpio_pzre_field_t PZRE_f;
  };
  union {
    __IO uint32_t PZRF;
    stc_gpio_pzrf_field_t PZRF_f;
  };
}FM3_GPIO_TypeDef;

/******************************************************************************
 * LVD_MODULE
 ******************************************************************************/
/* Low voltage detection registers */
typedef struct
{
  union {
    __IO  uint8_t LVD_CTL;
    stc_lvd_lvd_ctl_field_t LVD_CTL_f;
  };
        uint8_t RESERVED0[3];
  union {
    __IO  uint8_t LVD_STR;
    stc_lvd_lvd_str_field_t LVD_STR_f;
  };
        uint8_t RESERVED1[3];
  union {
    __IO  uint8_t LVD_CLR;
    stc_lvd_lvd_clr_field_t LVD_CLR_f;
  };
        uint8_t RESERVED2[3];
  __IO uint32_t LVD_RLR;
  union {
    __IO  uint8_t LVD_STR2;
    stc_lvd_lvd_str2_field_t LVD_STR2_f;
  };
}FM3_LVD_TypeDef;

/******************************************************************************
 * USBETHERNETCLK
 ******************************************************************************/
/* USB Ethernet clock registers */
typedef struct
{
  union {
    __IO  uint8_t UCCR;
    stc_usbethernetclk_uccr_field_t UCCR_f;
  };
        uint8_t RESERVED0[3];
  union {
    __IO  uint8_t UPCR1;
    stc_usbethernetclk_upcr1_field_t UPCR1_f;
  };
        uint8_t RESERVED1[3];
  union {
    __IO  uint8_t UPCR2;
    stc_usbethernetclk_upcr2_field_t UPCR2_f;
  };
        uint8_t RESERVED2[3];
  union {
    __IO  uint8_t UPCR3;
    stc_usbethernetclk_upcr3_field_t UPCR3_f;
  };
        uint8_t RESERVED3[3];
  union {
    __IO  uint8_t UPCR4;
    stc_usbethernetclk_upcr4_field_t UPCR4_f;
  };
        uint8_t RESERVED4[3];
  union {
    __IO  uint8_t UP_STR;
    stc_usbethernetclk_up_str_field_t UP_STR_f;
  };
        uint8_t RESERVED5[3];
  union {
    __IO  uint8_t UPINT_ENR;
    stc_usbethernetclk_upint_enr_field_t UPINT_ENR_f;
  };
        uint8_t RESERVED6[3];
  union {
    __IO  uint8_t UPINT_CLR;
    stc_usbethernetclk_upint_clr_field_t UPINT_CLR_f;
  };
        uint8_t RESERVED7[3];
  union {
    __IO  uint8_t UPINT_STR;
    stc_usbethernetclk_upint_str_field_t UPINT_STR_f;
  };
        uint8_t RESERVED8[3];
  union {
    __IO  uint8_t UPCR5;
    stc_usbethernetclk_upcr5_field_t UPCR5_f;
  };
        uint8_t RESERVED9[3];
  union {
    __IO  uint8_t UPCR6;
    stc_usbethernetclk_upcr6_field_t UPCR6_f;
  };
        uint8_t RESERVED10[3];
  union {
    __IO  uint8_t UPCR7;
    stc_usbethernetclk_upcr7_field_t UPCR7_f;
  };
        uint8_t RESERVED11[3];
  union {
    __IO  uint8_t USBEN0;
    stc_usbethernetclk_usben0_field_t USBEN0_f;
  };
        uint8_t RESERVED12[3];
  union {
    __IO  uint8_t USBEN1;
    stc_usbethernetclk_usben1_field_t USBEN1_f;
  };
}FM3_USBETHERNETCLK_TypeDef;

/******************************************************************************
 * CANPRE_MODULE
 ******************************************************************************/
/* CAN prescaler register */
typedef struct
{
  union {
    __IO  uint8_t CANPRE;
    stc_canpre_canpre_field_t CANPRE_f;
  };
}FM3_CANPRE_TypeDef;

/******************************************************************************
 * MFS03_UART_MODULE
 ******************************************************************************/
/* UART asynchronous channel 0 registers */
typedef struct
{
  union {
    __IO  uint8_t SMR;
    stc_mfs03_uart_smr_field_t SMR_f;
  };
  union {
    __IO  uint8_t SCR;
    stc_mfs03_uart_scr_field_t SCR_f;
  };
        uint8_t RESERVED0[2];
  union {
    __IO  uint8_t ESCR;
    stc_mfs03_uart_escr_field_t ESCR_f;
  };
  union {
    __IO  uint8_t SSR;
    stc_mfs03_uart_ssr_field_t SSR_f;
  };
        uint8_t RESERVED1[2];
  union {
    union {
      __IO uint16_t RDR;
      stc_mfs03_uart_rdr_field_t RDR_f;
    };
    union {
      __IO uint16_t TDR;
      stc_mfs03_uart_tdr_field_t TDR_f;
    };
  };
        uint8_t RESERVED2[2];
  union {
    union {
      __IO uint16_t BGR;
      stc_mfs03_uart_bgr_field_t BGR_f;
    };
    struct {
      __IO  uint8_t BGR0;
      union {
        __IO  uint8_t BGR1;
        stc_mfs03_uart_bgr1_field_t BGR1_f;
      };
    };
  };
}FM3_MFS03_UART_TypeDef;

/******************************************************************************
 * MFS03_CSIO_MODULE
 ******************************************************************************/
/* UART synchronous channel 0 registers */
typedef struct
{
  union {
    __IO  uint8_t SMR;
    stc_mfs03_csio_smr_field_t SMR_f;
  };
  union {
    __IO  uint8_t SCR;
    stc_mfs03_csio_scr_field_t SCR_f;
  };
        uint8_t RESERVED0[2];
  union {
    __IO  uint8_t ESCR;
    stc_mfs03_csio_escr_field_t ESCR_f;
  };
  union {
    __IO  uint8_t SSR;
    stc_mfs03_csio_ssr_field_t SSR_f;
  };
        uint8_t RESERVED1[2];
  union {
    __IO uint16_t RDR;
    __IO uint16_t TDR;
  };
        uint8_t RESERVED2[2];
  union {
    __IO uint16_t BGR;
    struct {
      __IO  uint8_t BGR0;
      __IO  uint8_t BGR1;
    };
  };
}FM3_MFS03_CSIO_TypeDef;

/******************************************************************************
 * MFS03_LIN_MODULE
 ******************************************************************************/
/* UART LIN channel 0 registers */
typedef struct
{
  union {
    __IO  uint8_t SMR;
    stc_mfs03_lin_smr_field_t SMR_f;
  };
  union {
    __IO  uint8_t SCR;
    stc_mfs03_lin_scr_field_t SCR_f;
  };
        uint8_t RESERVED0[2];
  union {
    __IO  uint8_t ESCR;
    stc_mfs03_lin_escr_field_t ESCR_f;
  };
  union {
    __IO  uint8_t SSR;
    stc_mfs03_lin_ssr_field_t SSR_f;
  };
        uint8_t RESERVED1[2];
  union {
    __IO uint16_t RDR;
    __IO uint16_t TDR;
  };
        uint8_t RESERVED2[2];
  union {
    union {
      __IO uint16_t BGR;
      stc_mfs03_lin_bgr_field_t BGR_f;
    };
    struct {
      __IO  uint8_t BGR0;
      union {
        __IO  uint8_t BGR1;
        stc_mfs03_lin_bgr1_field_t BGR1_f;
      };
    };
  };
}FM3_MFS03_LIN_TypeDef;

/******************************************************************************
 * MFS03_I2C_MODULE
 ******************************************************************************/
/* I2C channel 0 registers */
typedef struct
{
  union {
    __IO  uint8_t SMR;
    stc_mfs03_i2c_smr_field_t SMR_f;
  };
  union {
    __IO  uint8_t IBCR;
    stc_mfs03_i2c_ibcr_field_t IBCR_f;
  };
        uint8_t RESERVED0[2];
  union {
    __IO  uint8_t IBSR;
    stc_mfs03_i2c_ibsr_field_t IBSR_f;
  };
  union {
    __IO  uint8_t SSR;
    stc_mfs03_i2c_ssr_field_t SSR_f;
  };
        uint8_t RESERVED1[2];
  union {
    __IO uint16_t RDR;
    __IO uint16_t TDR;
  };
        uint8_t RESERVED2[2];
  union {
    __IO uint16_t BGR;
    struct {
      __IO  uint8_t BGR0;
      __IO  uint8_t BGR1;
    };
  };
        uint8_t RESERVED3[2];
  union {
    __IO  uint8_t ISBA;
    stc_mfs03_i2c_isba_field_t ISBA_f;
  };
  union {
    __IO  uint8_t ISMK;
    stc_mfs03_i2c_ismk_field_t ISMK_f;
  };
}FM3_MFS03_I2C_TypeDef;

/******************************************************************************
 * MFS47_UART_MODULE
 ******************************************************************************/
/* UART asynchronous channel 4 registers */
typedef struct
{
  union {
    __IO  uint8_t SMR;
    stc_mfs47_uart_smr_field_t SMR_f;
  };
  union {
    __IO  uint8_t SCR;
    stc_mfs47_uart_scr_field_t SCR_f;
  };
        uint8_t RESERVED0[2];
  union {
    __IO  uint8_t ESCR;
    stc_mfs47_uart_escr_field_t ESCR_f;
  };
  union {
    __IO  uint8_t SSR;
    stc_mfs47_uart_ssr_field_t SSR_f;
  };
        uint8_t RESERVED1[2];
  union {
    union {
      __IO uint16_t RDR;
      stc_mfs47_uart_rdr_field_t RDR_f;
    };
    union {
      __IO uint16_t TDR;
      stc_mfs47_uart_tdr_field_t TDR_f;
    };
  };
        uint8_t RESERVED2[2];
  union {
    union {
      __IO uint16_t BGR;
      stc_mfs47_uart_bgr_field_t BGR_f;
    };
    struct {
      __IO  uint8_t BGR0;
      union {
        __IO  uint8_t BGR1;
        stc_mfs47_uart_bgr1_field_t BGR1_f;
      };
    };
  };
        uint8_t RESERVED3[6];
  union {
    union {
      __IO uint16_t FCR;
      stc_mfs47_uart_fcr_field_t FCR_f;
    };
    struct {
      union {
        __IO  uint8_t FCR0;
        stc_mfs47_uart_fcr0_field_t FCR0_f;
      };
      union {
        __IO  uint8_t FCR1;
        stc_mfs47_uart_fcr1_field_t FCR1_f;
      };
    };
  };
        uint8_t RESERVED4[2];
  union {
    union {
      __IO uint16_t FBYTE;
      stc_mfs47_uart_fbyte_field_t FBYTE_f;
    };
    struct {
      union {
        __IO  uint8_t FBYTE1;
        stc_mfs47_uart_fbyte1_field_t FBYTE1_f;
      };
      union {
        __IO  uint8_t FBYTE2;
        stc_mfs47_uart_fbyte2_field_t FBYTE2_f;
      };
    };
  };
}FM3_MFS47_UART_TypeDef;

/******************************************************************************
 * MFS47_CSIO_MODULE
 ******************************************************************************/
/* UART synchronous channel 4 registers */
typedef struct
{
  union {
    __IO  uint8_t SMR;
    stc_mfs47_csio_smr_field_t SMR_f;
  };
  union {
    __IO  uint8_t SCR;
    stc_mfs47_csio_scr_field_t SCR_f;
  };
        uint8_t RESERVED0[2];
  union {
    __IO  uint8_t ESCR;
    stc_mfs47_csio_escr_field_t ESCR_f;
  };
  union {
    __IO  uint8_t SSR;
    stc_mfs47_csio_ssr_field_t SSR_f;
  };
        uint8_t RESERVED1[2];
  union {
    __IO uint16_t RDR;
    __IO uint16_t TDR;
  };
        uint8_t RESERVED2[2];
  union {
    __IO uint16_t BGR;
    struct {
      __IO  uint8_t BGR0;
      __IO  uint8_t BGR1;
    };
  };
        uint8_t RESERVED3[6];
  union {
    union {
      __IO uint16_t FCR;
      stc_mfs47_csio_fcr_field_t FCR_f;
    };
    struct {
      union {
        __IO  uint8_t FCR0;
        stc_mfs47_csio_fcr0_field_t FCR0_f;
      };
      union {
        __IO  uint8_t FCR1;
        stc_mfs47_csio_fcr1_field_t FCR1_f;
      };
    };
  };
        uint8_t RESERVED4[2];
  union {
    union {
      __IO uint16_t FBYTE;
      stc_mfs47_csio_fbyte_field_t FBYTE_f;
    };
    struct {
      union {
        __IO  uint8_t FBYTE1;
        stc_mfs47_csio_fbyte1_field_t FBYTE1_f;
      };
      union {
        __IO  uint8_t FBYTE2;
        stc_mfs47_csio_fbyte2_field_t FBYTE2_f;
      };
    };
  };
}FM3_MFS47_CSIO_TypeDef;

/******************************************************************************
 * MFS47_LIN_MODULE
 ******************************************************************************/
/* UART LIN channel 4 registers */
typedef struct
{
  union {
    __IO  uint8_t SMR;
    stc_mfs47_lin_smr_field_t SMR_f;
  };
  union {
    __IO  uint8_t SCR;
    stc_mfs47_lin_scr_field_t SCR_f;
  };
        uint8_t RESERVED0[2];
  union {
    __IO  uint8_t ESCR;
    stc_mfs47_lin_escr_field_t ESCR_f;
  };
  union {
    __IO  uint8_t SSR;
    stc_mfs47_lin_ssr_field_t SSR_f;
  };
        uint8_t RESERVED1[2];
  union {
    __IO uint16_t RDR;
    __IO uint16_t TDR;
  };
        uint8_t RESERVED2[2];
  union {
    union {
      __IO uint16_t BGR;
      stc_mfs47_lin_bgr_field_t BGR_f;
    };
    struct {
      __IO  uint8_t BGR0;
      union {
        __IO  uint8_t BGR1;
        stc_mfs47_lin_bgr1_field_t BGR1_f;
      };
    };
  };
        uint8_t RESERVED3[6];
  union {
    union {
      __IO uint16_t FCR;
      stc_mfs47_lin_fcr_field_t FCR_f;
    };
    struct {
      union {
        __IO  uint8_t FCR0;
        stc_mfs47_lin_fcr0_field_t FCR0_f;
      };
      union {
        __IO  uint8_t FCR1;
        stc_mfs47_lin_fcr1_field_t FCR1_f;
      };
    };
  };
        uint8_t RESERVED4[2];
  union {
    union {
      __IO uint16_t FBYTE;
      stc_mfs47_lin_fbyte_field_t FBYTE_f;
    };
    struct {
      union {
        __IO  uint8_t FBYTE1;
        stc_mfs47_lin_fbyte1_field_t FBYTE1_f;
      };
      union {
        __IO  uint8_t FBYTE2;
        stc_mfs47_lin_fbyte2_field_t FBYTE2_f;
      };
    };
  };
}FM3_MFS47_LIN_TypeDef;

/******************************************************************************
 * MFS47_I2C_MODULE
 ******************************************************************************/
/* I2C channel 4 registers */
typedef struct
{
  union {
    __IO  uint8_t SMR;
    stc_mfs47_i2c_smr_field_t SMR_f;
  };
  union {
    __IO  uint8_t IBCR;
    stc_mfs47_i2c_ibcr_field_t IBCR_f;
  };
        uint8_t RESERVED0[2];
  union {
    __IO  uint8_t IBSR;
    stc_mfs47_i2c_ibsr_field_t IBSR_f;
  };
  union {
    __IO  uint8_t SSR;
    stc_mfs47_i2c_ssr_field_t SSR_f;
  };
        uint8_t RESERVED1[2];
  union {
    __IO uint16_t RDR;
    __IO uint16_t TDR;
  };
        uint8_t RESERVED2[2];
  union {
    __IO uint16_t BGR;
    struct {
      __IO  uint8_t BGR0;
      __IO  uint8_t BGR1;
    };
  };
        uint8_t RESERVED3[2];
  union {
    __IO  uint8_t ISBA;
    stc_mfs47_i2c_isba_field_t ISBA_f;
  };
  union {
    __IO  uint8_t ISMK;
    stc_mfs47_i2c_ismk_field_t ISMK_f;
  };
        uint8_t RESERVED4[2];
  union {
    union {
      __IO uint16_t FCR;
      stc_mfs47_i2c_fcr_field_t FCR_f;
    };
    struct {
      union {
        __IO  uint8_t FCR0;
        stc_mfs47_i2c_fcr0_field_t FCR0_f;
      };
      union {
        __IO  uint8_t FCR1;
        stc_mfs47_i2c_fcr1_field_t FCR1_f;
      };
    };
  };
        uint8_t RESERVED5[2];
  union {
    union {
      __IO uint16_t FBYTE;
      stc_mfs47_i2c_fbyte_field_t FBYTE_f;
    };
    struct {
      union {
        __IO  uint8_t FBYTE1;
        stc_mfs47_i2c_fbyte1_field_t FBYTE1_f;
      };
      union {
        __IO  uint8_t FBYTE2;
        stc_mfs47_i2c_fbyte2_field_t FBYTE2_f;
      };
    };
  };
}FM3_MFS47_I2C_TypeDef;

/******************************************************************************
 * MFS_NFC_MODULE
 ******************************************************************************/
/* MFS_NFC_MODULE register bit fields */
typedef struct
{
  union {
    __IO  uint16_t I2CDNF;
    stc_mfs_nfc_i2cdnf_field_t I2CDNF_f;
  };
}FM3_MFS_NFC_TypeDef;

/******************************************************************************
 * CRC_MODULE
 ******************************************************************************/
/* CRC registers */
typedef struct
{
  union {
    __IO  uint8_t CRCCR;
    stc_crc_crccr_field_t CRCCR_f;
  };
        uint8_t RESERVED0[3];
  __IO uint32_t CRCINIT;
  union {
    __IO uint32_t CRCIN;
    struct {
      union {
        __IO uint16_t CRCINL;
        struct {
          __IO  uint8_t CRCINLL;
          __IO  uint8_t CRCINLH;
        };
      };
      union {
        __IO uint16_t CRCINH;
        struct {
          __IO  uint8_t CRCINHL;
          __IO  uint8_t CRCINHH;
        };
      };
    };
  };
  __IO uint32_t CRCR;
}FM3_CRC_TypeDef;

/******************************************************************************
 * WC_MODULE
 ******************************************************************************/
/* Watch counter registers */
typedef struct
{
  union {
    __IO  uint8_t WCRD;
    stc_wc_wcrd_field_t WCRD_f;
  };
  union {
    __IO  uint8_t WCRL;
    stc_wc_wcrl_field_t WCRL_f;
  };
  union {
    __IO  uint8_t WCCR;
    stc_wc_wccr_field_t WCCR_f;
  };
        uint8_t RESERVED0[13];
  union {
    __IO uint16_t CLK_SEL;
    stc_wc_clk_sel_field_t CLK_SEL_f;
  };
        uint8_t RESERVED1[2];
  union {
    __IO  uint8_t CLK_EN;
    stc_wc_clk_en_field_t CLK_EN_f;
  };
}FM3_WC_TypeDef;

/******************************************************************************
 * EXBUS_MODULE
 ******************************************************************************/
/* External bus interface registers */
typedef struct
{
  union {
    __IO uint32_t MODE0;
    stc_exbus_mode0_field_t MODE0_f;
  };
  union {
    __IO uint32_t MODE1;
    stc_exbus_mode1_field_t MODE1_f;
  };
  union {
    __IO uint32_t MODE2;
    stc_exbus_mode2_field_t MODE2_f;
  };
  union {
    __IO uint32_t MODE3;
    stc_exbus_mode3_field_t MODE3_f;
  };
  union {
    __IO uint32_t MODE4;
    stc_exbus_mode4_field_t MODE4_f;
  };
  union {
    __IO uint32_t MODE5;
    stc_exbus_mode5_field_t MODE5_f;
  };
  union {
    __IO uint32_t MODE6;
    stc_exbus_mode6_field_t MODE6_f;
  };
  union {
    __IO uint32_t MODE7;
    stc_exbus_mode7_field_t MODE7_f;
  };
  union {
    __IO uint32_t TIM0;
    stc_exbus_tim0_field_t TIM0_f;
  };
  union {
    __IO uint32_t TIM1;
    stc_exbus_tim1_field_t TIM1_f;
  };
  union {
    __IO uint32_t TIM2;
    stc_exbus_tim2_field_t TIM2_f;
  };
  union {
    __IO uint32_t TIM3;
    stc_exbus_tim3_field_t TIM3_f;
  };
  union {
    __IO uint32_t TIM4;
    stc_exbus_tim4_field_t TIM4_f;
  };
  union {
    __IO uint32_t TIM5;
    stc_exbus_tim5_field_t TIM5_f;
  };
  union {
    __IO uint32_t TIM6;
    stc_exbus_tim6_field_t TIM6_f;
  };
  union {
    __IO uint32_t TIM7;
    stc_exbus_tim7_field_t TIM7_f;
  };
  union {
    __IO uint32_t AREA0;
    stc_exbus_area0_field_t AREA0_f;
  };
  union {
    __IO uint32_t AREA1;
    stc_exbus_area1_field_t AREA1_f;
  };
  union {
    __IO uint32_t AREA2;
    stc_exbus_area2_field_t AREA2_f;
  };
  union {
    __IO uint32_t AREA3;
    stc_exbus_area3_field_t AREA3_f;
  };
  union {
    __IO uint32_t AREA4;
    stc_exbus_area4_field_t AREA4_f;
  };
  union {
    __IO uint32_t AREA5;
    stc_exbus_area5_field_t AREA5_f;
  };
  union {
    __IO uint32_t AREA6;
    stc_exbus_area6_field_t AREA6_f;
  };
  union {
    __IO uint32_t AREA7;
    stc_exbus_area7_field_t AREA7_f;
  };
  union {
    __IO uint16_t ATIM0;
    stc_exbus_atim0_field_t ATIM0_f;
  };
        uint8_t RESERVED0[2];
  union {
    __IO uint16_t ATIM1;
    stc_exbus_atim1_field_t ATIM1_f;
  };
        uint8_t RESERVED1[2];
  union {
    __IO uint16_t ATIM2;
    stc_exbus_atim2_field_t ATIM2_f;
  };
        uint8_t RESERVED2[2];
  union {
    __IO uint16_t ATIM3;
    stc_exbus_atim3_field_t ATIM3_f;
  };
        uint8_t RESERVED3[2];
  union {
    __IO uint16_t ATIM4;
    stc_exbus_atim4_field_t ATIM4_f;
  };
        uint8_t RESERVED4[2];
  union {
    __IO uint16_t ATIM5;
    stc_exbus_atim5_field_t ATIM5_f;
  };
        uint8_t RESERVED5[2];
  union {
    __IO uint16_t ATIM6;
    stc_exbus_atim6_field_t ATIM6_f;
  };
        uint8_t RESERVED6[2];
  union {
    __IO uint16_t ATIM7;
    stc_exbus_atim7_field_t ATIM7_f;
  };
        uint8_t RESERVED7[642];
  union {
    __IO  uint8_t DCLKR;
    stc_exbus_dclkr_field_t DCLKR_f;
  };
}FM3_EXBUS_TypeDef;

/******************************************************************************
 * USB_MODULE
 ******************************************************************************/
/* USB channel 0 registers */
typedef struct
{
  union {
    union {
      __IO uint16_t HCNT;
      stc_usb_hcnt_field_t HCNT_f;
    };
    struct {
      union {
        __IO  uint8_t HCNT0;
        stc_usb_hcnt0_field_t HCNT0_f;
      };
      union {
        __IO  uint8_t HCNT1;
        stc_usb_hcnt1_field_t HCNT1_f;
      };
    };
  };
        uint8_t RESERVED0[2];
  union {
    __IO  uint8_t HIRQ;
    stc_usb_hirq_field_t HIRQ_f;
  };
  union {
    __IO  uint8_t HERR;
    stc_usb_herr_field_t HERR_f;
  };
        uint8_t RESERVED1[2];
  union {
    __IO  uint8_t HSTATE;
    stc_usb_hstate_field_t HSTATE_f;
  };
  union {
    __IO  uint8_t HFCOMP;
    stc_usb_hfcomp_field_t HFCOMP_f;
  };
        uint8_t RESERVED2[2];
  union {
    union {
      __IO uint16_t HRTIMER;
      stc_usb_hrtimer_field_t HRTIMER_f;
    };
    struct {
      union {
        __IO  uint8_t HRTIMER0;
        stc_usb_hrtimer0_field_t HRTIMER0_f;
      };
      union {
        __IO  uint8_t HRTIMER1;
        stc_usb_hrtimer1_field_t HRTIMER1_f;
      };
    };
  };
        uint8_t RESERVED3[2];
  union {
    __IO  uint8_t HRTIMER2;
    stc_usb_hrtimer2_field_t HRTIMER2_f;
  };
  union {
    __IO  uint8_t HADR;
    stc_usb_hadr_field_t HADR_f;
  };
        uint8_t RESERVED4[2];
  union {
    union {
      __IO uint16_t HEOF;
      stc_usb_heof_field_t HEOF_f;
    };
    struct {
      union {
        __IO  uint8_t HEOF0;
        stc_usb_heof0_field_t HEOF0_f;
      };
      union {
        __IO  uint8_t HEOF1;
        stc_usb_heof1_field_t HEOF1_f;
      };
    };
  };
        uint8_t RESERVED5[2];
  union {
    union {
      __IO uint16_t HFRAME;
      stc_usb_hframe_field_t HFRAME_f;
    };
    struct {
      union {
        __IO  uint8_t HFRAME0;
        stc_usb_hframe0_field_t HFRAME0_f;
      };
      union {
        __IO  uint8_t HFRAME1;
        stc_usb_hframe1_field_t HFRAME1_f;
      };
    };
  };
        uint8_t RESERVED6[2];
  union {
    __IO  uint8_t HTOKEN;
    stc_usb_htoken_field_t HTOKEN_f;
  };
        uint8_t RESERVED7[3];
  union {
    __IO uint16_t UDCC;
    stc_usb_udcc_field_t UDCC_f;
  };
        uint8_t RESERVED8[2];
  union {
    __IO uint16_t EP0C;
    stc_usb_ep0c_field_t EP0C_f;
  };
        uint8_t RESERVED9[2];
  union {
    __IO uint16_t EP1C;
    stc_usb_ep1c_field_t EP1C_f;
  };
        uint8_t RESERVED10[2];
  union {
    __IO uint16_t EP2C;
    stc_usb_ep2c_field_t EP2C_f;
  };
        uint8_t RESERVED11[2];
  union {
    __IO uint16_t EP3C;
    stc_usb_ep3c_field_t EP3C_f;
  };
        uint8_t RESERVED12[2];
  union {
    __IO uint16_t EP4C;
    stc_usb_ep4c_field_t EP4C_f;
  };
        uint8_t RESERVED13[2];
  union {
    __IO uint16_t EP5C;
    stc_usb_ep5c_field_t EP5C_f;
  };
        uint8_t RESERVED14[2];
  union {
    __IO uint16_t TMSP;
    stc_usb_tmsp_field_t TMSP_f;
  };
        uint8_t RESERVED15[2];
  union {
    __IO  uint8_t UDCS;
    stc_usb_udcs_field_t UDCS_f;
  };
  union {
    __IO  uint8_t UDCIE;
    stc_usb_udcie_field_t UDCIE_f;
  };
        uint8_t RESERVED16[2];
  union {
    __IO uint16_t EP0IS;
    stc_usb_ep0is_field_t EP0IS_f;
  };
        uint8_t RESERVED17[2];
  union {
    __IO uint16_t EP0OS;
    stc_usb_ep0os_field_t EP0OS_f;
  };
        uint8_t RESERVED18[2];
  union {
    __IO uint16_t EP1S;
    stc_usb_ep1s_field_t EP1S_f;
  };
        uint8_t RESERVED19[2];
  union {
    __IO uint16_t EP2S;
    stc_usb_ep2s_field_t EP2S_f;
  };
        uint8_t RESERVED20[2];
  __IO uint16_t EP3S;
        uint8_t RESERVED21[2];
  union {
    __IO uint16_t EP4S;
    stc_usb_ep4s_field_t EP4S_f;
  };
        uint8_t RESERVED22[2];
  union {
    __IO uint16_t EP5S;
    stc_usb_ep5s_field_t EP5S_f;
  };
        uint8_t RESERVED23[2];
  union {
    __IO uint16_t EP0DT;
    struct {
      __IO  uint8_t EP0DTL;
      __IO  uint8_t EP0DTH;
    };
  };
        uint8_t RESERVED24[2];
  union {
    __IO uint16_t EP1DT;
    struct {
      __IO  uint8_t EP1DTL;
      __IO  uint8_t EP1DTH;
    };
  };
        uint8_t RESERVED25[2];
  union {
    __IO uint16_t EP2DT;
    struct {
      __IO  uint8_t EP2DTL;
      __IO  uint8_t EP2DTH;
    };
  };
        uint8_t RESERVED26[2];
  union {
    __IO uint16_t EP3DT;
    struct {
      __IO  uint8_t EP3DTL;
      __IO  uint8_t EP3DTH;
    };
  };
        uint8_t RESERVED27[2];
  union {
    __IO uint16_t EP4DT;
    struct {
      __IO  uint8_t EP4DTL;
      __IO  uint8_t EP4DTH;
    };
  };
        uint8_t RESERVED28[2];
  union {
    __IO uint16_t EP5DT;
    struct {
      __IO  uint8_t EP5DTL;
      __IO  uint8_t EP5DTH;
    };
  };
}FM3_USB_TypeDef;

/******************************************************************************
 * DMAC_MODULE
 ******************************************************************************/
/* DMA controller */
typedef struct
{
  union {
    __IO uint32_t DMACR;
    stc_dmac_dmacr_field_t DMACR_f;
  };
        uint8_t RESERVED0[12];
  union {
    __IO uint32_t DMACA0;
    stc_dmac_dmaca0_field_t DMACA0_f;
  };
  union {
    __IO uint32_t DMACB0;
    stc_dmac_dmacb0_field_t DMACB0_f;
  };
  __IO uint32_t DMACSA0;
  __IO uint32_t DMACDA0;
  union {
    __IO uint32_t DMACA1;
    stc_dmac_dmaca1_field_t DMACA1_f;
  };
  union {
    __IO uint32_t DMACB1;
    stc_dmac_dmacb1_field_t DMACB1_f;
  };
  __IO uint32_t DMACSA1;
  __IO uint32_t DMACDA1;
  union {
    __IO uint32_t DMACA2;
    stc_dmac_dmaca2_field_t DMACA2_f;
  };
  union {
    __IO uint32_t DMACB2;
    stc_dmac_dmacb2_field_t DMACB2_f;
  };
  __IO uint32_t DMACSA2;
  __IO uint32_t DMACDA2;
  union {
    __IO uint32_t DMACA3;
    stc_dmac_dmaca3_field_t DMACA3_f;
  };
  union {
    __IO uint32_t DMACB3;
    stc_dmac_dmacb3_field_t DMACB3_f;
  };
  __IO uint32_t DMACSA3;
  __IO uint32_t DMACDA3;
  union {
    __IO uint32_t DMACA4;
    stc_dmac_dmaca4_field_t DMACA4_f;
  };
  union {
    __IO uint32_t DMACB4;
    stc_dmac_dmacb4_field_t DMACB4_f;
  };
  __IO uint32_t DMACSA4;
  __IO uint32_t DMACDA4;
  union {
    __IO uint32_t DMACA5;
    stc_dmac_dmaca5_field_t DMACA5_f;
  };
  union {
    __IO uint32_t DMACB5;
    stc_dmac_dmacb5_field_t DMACB5_f;
  };
  __IO uint32_t DMACSA5;
  __IO uint32_t DMACDA5;
  union {
    __IO uint32_t DMACA6;
    stc_dmac_dmaca6_field_t DMACA6_f;
  };
  union {
    __IO uint32_t DMACB6;
    stc_dmac_dmacb6_field_t DMACB6_f;
  };
  __IO uint32_t DMACSA6;
  __IO uint32_t DMACDA6;
  union {
    __IO uint32_t DMACA7;
    stc_dmac_dmaca7_field_t DMACA7_f;
  };
  union {
    __IO uint32_t DMACB7;
    stc_dmac_dmacb7_field_t DMACB7_f;
  };
  __IO uint32_t DMACSA7;
  __IO uint32_t DMACDA7;
}FM3_DMAC_TypeDef;

/******************************************************************************
 * CAN_MODULE
 ******************************************************************************/
/* CAN channel 0 registers */
typedef struct
{
  union {
    __IO uint16_t CTRLR;
    stc_can_ctrlr_field_t CTRLR_f;
  };
  union {
    __IO uint16_t STATR;
    stc_can_statr_field_t STATR_f;
  };
  union {
    __IO uint16_t ERRCNT;
    stc_can_errcnt_field_t ERRCNT_f;
  };
  union {
    __IO uint16_t BTR;
    stc_can_btr_field_t BTR_f;
  };
  union {
    __IO uint16_t INTR;
    stc_can_intr_field_t INTR_f;
  };
  union {
    __IO uint16_t TESTR;
    stc_can_testr_field_t TESTR_f;
  };
  union {
    __IO uint16_t BRPER;
    stc_can_brper_field_t BRPER_f;
  };
        uint8_t RESERVED0[2];
  union {
    __IO uint16_t IF1CREQ;
    stc_can_if1creq_field_t IF1CREQ_f;
  };
  union {
    __IO uint16_t IF1CMSK;
    stc_can_if1cmsk_field_t IF1CMSK_f;
  };
  union {
    union {
      __IO uint32_t IF1MSK;
      stc_can_if1msk_field_t IF1MSK_f;
    };
    struct {
      __IO uint16_t IF1MSK1;
      union {
        __IO uint16_t IF1MSK2;
        stc_can_if1msk2_field_t IF1MSK2_f;
      };
    };
  };
  union {
    union {
      __IO uint32_t IF1ARB;
      stc_can_if1arb_field_t IF1ARB_f;
    };
    struct {
      __IO uint16_t IF1ARB1;
      union {
        __IO uint16_t IF1ARB2;
        stc_can_if1arb2_field_t IF1ARB2_f;
      };
    };
  };
  union {
    __IO uint16_t IF1MCTR;
    stc_can_if1mctr_field_t IF1MCTR_f;
  };
        uint8_t RESERVED1[2];
  union {
    __IO uint32_t IF1DTA_L;
    struct {
      __IO uint16_t IF1DTA1_L;
      __IO uint16_t IF1DTA2_L;
    };
  };
  union {
    __IO uint32_t IF1DTB_L;
    struct {
      __IO uint16_t IF1DTB1_L;
      __IO uint16_t IF1DTB2_L;
    };
  };
        uint8_t RESERVED2[8];
  union {
    __IO uint32_t IF1DTA_B;
    struct {
      __IO uint16_t IF1DTA2_B;
      __IO uint16_t IF1DTA1_B;
    };
  };
  union {
    __IO uint32_t IF1DTB_B;
    struct {
      __IO uint16_t IF1DTB2_B;
      __IO uint16_t IF1DTB1_B;
    };
  };
        uint8_t RESERVED3[8];
  union {
    __IO uint16_t IF2CREQ;
    stc_can_if2creq_field_t IF2CREQ_f;
  };
  union {
    __IO uint16_t IF2CMSK;
    stc_can_if2cmsk_field_t IF2CMSK_f;
  };
  union {
    union {
      __IO uint32_t IF2MSK;
      stc_can_if2msk_field_t IF2MSK_f;
    };
    struct {
      __IO uint16_t IF2MSK1;
      union {
        __IO uint16_t IF2MSK2;
        stc_can_if2msk2_field_t IF2MSK2_f;
      };
    };
  };
  union {
    union {
      __IO uint32_t IF2ARB;
      stc_can_if2arb_field_t IF2ARB_f;
    };
    struct {
      __IO uint16_t IF2ARB1;
      union {
        __IO uint16_t IF2ARB2;
        stc_can_if2arb2_field_t IF2ARB2_f;
      };
    };
  };
  union {
    __IO uint16_t IF2MCTR;
    stc_can_if2mctr_field_t IF2MCTR_f;
  };
        uint8_t RESERVED4[2];
  union {
    __IO uint32_t IF2DTA_L;
    struct {
      __IO uint16_t IF2DTA1_L;
      __IO uint16_t IF2DTA2_L;
    };
  };
  union {
    __IO uint32_t IF2DTB_L;
    struct {
      __IO uint16_t IF2DTB1_L;
      __IO uint16_t IF2DTB2_L;
    };
  };
        uint8_t RESERVED5[8];
  union {
    __IO uint32_t IF2DTA_B;
    struct {
      __IO uint16_t IF2DTA2_B;
      __IO uint16_t IF2DTA1_B;
    };
  };
  union {
    __IO uint32_t IF2DTB_B;
    struct {
      __IO uint16_t IF2DTB2_B;
      __IO uint16_t IF2DTB1_B;
    };
  };
        uint8_t RESERVED6[24];
  union {
    union {
      __IO uint32_t TREQR;
      stc_can_treqr_field_t TREQR_f;
    };
    struct {
      union {
        __IO uint16_t TREQR1;
        stc_can_treqr1_field_t TREQR1_f;
      };
      union {
        __IO uint16_t TREQR2;
        stc_can_treqr2_field_t TREQR2_f;
      };
    };
  };
        uint8_t RESERVED7[12];
  union {
    union {
      __IO uint32_t NEWDT;
      stc_can_newdt_field_t NEWDT_f;
    };
    struct {
      union {
        __IO uint16_t NEWDT1;
        stc_can_newdt1_field_t NEWDT1_f;
      };
      __IO uint16_t NEWDT2;
    };
  };
        uint8_t RESERVED8[12];
  union {
    union {
      __IO uint32_t INTPND;
      stc_can_intpnd_field_t INTPND_f;
    };
    struct {
      union {
        __IO uint16_t INTPND1;
        stc_can_intpnd1_field_t INTPND1_f;
      };
      union {
        __IO uint16_t INTPND2;
        stc_can_intpnd2_field_t INTPND2_f;
      };
    };
  };
        uint8_t RESERVED9[12];
  union {
    union {
      __IO uint32_t MSGVAL;
      stc_can_msgval_field_t MSGVAL_f;
    };
    struct {
      union {
        __IO uint16_t MSGVAL1;
        stc_can_msgval1_field_t MSGVAL1_f;
      };
      union {
        __IO uint16_t MSGVAL2;
        stc_can_msgval2_field_t MSGVAL2_f;
      };
    };
  };
}FM3_CAN_TypeDef;

/******************************************************************************
 * ETHERNET_MAC_MODULE
 ******************************************************************************/
/* ETHERNET-MAC registers */
typedef struct
{
  union {
    __IO uint32_t MCR;
    stc_ethernet_mac_mcr_field_t MCR_f;
  };
  union {
    __IO uint32_t MFFR;
    stc_ethernet_mac_mffr_field_t MFFR_f;
  };
  union {
    __IO uint32_t MHTRH;
    stc_ethernet_mac_mhtrh_field_t MHTRH_f;
  };
  union {
    __IO uint32_t MHTRL;
    stc_ethernet_mac_mhtrl_field_t MHTRL_f;
  };
  union {
    __IO uint32_t GAR;
    stc_ethernet_mac_gar_field_t GAR_f;
  };
  union {
    __IO uint32_t GDR;
    stc_ethernet_mac_gdr_field_t GDR_f;
  };
  union {
    __IO uint32_t FCR;
    stc_ethernet_mac_fcr_field_t FCR_f;
  };
  union {
    __IO uint32_t VTR;
    stc_ethernet_mac_vtr_field_t VTR_f;
  };
        uint8_t RESERVED0[8];
  union {
    __IO uint32_t RWFFR;
    stc_ethernet_mac_rwffr_field_t RWFFR_f;
  };
  union {
    __IO uint32_t PMTR;
    stc_ethernet_mac_pmtr_field_t PMTR_f;
  };
  union {
    __IO uint32_t LPICSR;
    stc_ethernet_mac_lpicsr_field_t LPICSR_f;
  };
  union {
    __IO uint32_t LPITCR;
    stc_ethernet_mac_lpitcr_field_t LPITCR_f;
  };
  union {
    __IO uint32_t ISR;
    stc_ethernet_mac_isr_field_t ISR_f;
  };
  union {
    __IO uint32_t IMR;
    stc_ethernet_mac_imr_field_t IMR_f;
  };
  union {
    __IO uint32_t MAR0H;
    stc_ethernet_mac_mar0h_field_t MAR0H_f;
  };
  union {
    __IO uint32_t MAR0L;
    stc_ethernet_mac_mar0l_field_t MAR0L_f;
  };
  union {
    __IO uint32_t MAR1H;
    stc_ethernet_mac_mar1h_field_t MAR1H_f;
  };
  union {
    __IO uint32_t MAR1L;
    stc_ethernet_mac_mar1l_field_t MAR1L_f;
  };
  union {
    __IO uint32_t MAR2H;
    stc_ethernet_mac_mar2h_field_t MAR2H_f;
  };
  union {
    __IO uint32_t MAR2L;
    stc_ethernet_mac_mar2l_field_t MAR2L_f;
  };
  union {
    __IO uint32_t MAR3H;
    stc_ethernet_mac_mar3h_field_t MAR3H_f;
  };
  union {
    __IO uint32_t MAR3L;
    stc_ethernet_mac_mar3l_field_t MAR3L_f;
  };
  union {
    __IO uint32_t MAR4H;
    stc_ethernet_mac_mar4h_field_t MAR4H_f;
  };
  union {
    __IO uint32_t MAR4L;
    stc_ethernet_mac_mar4l_field_t MAR4L_f;
  };
  union {
    __IO uint32_t MAR5H;
    stc_ethernet_mac_mar5h_field_t MAR5H_f;
  };
  union {
    __IO uint32_t MAR5L;
    stc_ethernet_mac_mar5l_field_t MAR5L_f;
  };
  union {
    __IO uint32_t MAR6H;
    stc_ethernet_mac_mar6h_field_t MAR6H_f;
  };
  union {
    __IO uint32_t MAR6L;
    stc_ethernet_mac_mar6l_field_t MAR6L_f;
  };
  union {
    __IO uint32_t MAR7H;
    stc_ethernet_mac_mar7h_field_t MAR7H_f;
  };
  union {
    __IO uint32_t MAR7L;
    stc_ethernet_mac_mar7l_field_t MAR7L_f;
  };
  union {
    __IO uint32_t MAR8H;
    stc_ethernet_mac_mar8h_field_t MAR8H_f;
  };
  union {
    __IO uint32_t MAR8L;
    stc_ethernet_mac_mar8l_field_t MAR8L_f;
  };
  union {
    __IO uint32_t MAR9H;
    stc_ethernet_mac_mar9h_field_t MAR9H_f;
  };
  union {
    __IO uint32_t MAR9L;
    stc_ethernet_mac_mar9l_field_t MAR9L_f;
  };
  union {
    __IO uint32_t MAR10H;
    stc_ethernet_mac_mar10h_field_t MAR10H_f;
  };
  union {
    __IO uint32_t MAR10L;
    stc_ethernet_mac_mar10l_field_t MAR10L_f;
  };
  union {
    __IO uint32_t MAR11H;
    stc_ethernet_mac_mar11h_field_t MAR11H_f;
  };
  union {
    __IO uint32_t MAR11L;
    stc_ethernet_mac_mar11l_field_t MAR11L_f;
  };
  union {
    __IO uint32_t MAR12H;
    stc_ethernet_mac_mar12h_field_t MAR12H_f;
  };
  union {
    __IO uint32_t MAR12L;
    stc_ethernet_mac_mar12l_field_t MAR12L_f;
  };
  union {
    __IO uint32_t MAR13H;
    stc_ethernet_mac_mar13h_field_t MAR13H_f;
  };
  union {
    __IO uint32_t MAR13L;
    stc_ethernet_mac_mar13l_field_t MAR13L_f;
  };
  union {
    __IO uint32_t MAR14H;
    stc_ethernet_mac_mar14h_field_t MAR14H_f;
  };
  union {
    __IO uint32_t MAR14L;
    stc_ethernet_mac_mar14l_field_t MAR14L_f;
  };
  union {
    __IO uint32_t MAR15H;
    stc_ethernet_mac_mar15h_field_t MAR15H_f;
  };
  union {
    __IO uint32_t MAR15L;
    stc_ethernet_mac_mar15l_field_t MAR15L_f;
  };
        uint8_t RESERVED1[24];
  union {
    __IO uint32_t RGSR;
    stc_ethernet_mac_rgsr_field_t RGSR_f;
  };
        uint8_t RESERVED2[36];
  __IO uint32_t mmc_cntl;
  __IO uint32_t mmc_intr_rx;
  __IO uint32_t mmc_intr_tx;
  __IO uint32_t mmc_intr_mask_rx;
  __IO uint32_t mmc_intr_mask_tx;
  __IO uint32_t txoctetcount_gb;
  __IO uint32_t txframecount_gb;
  __IO uint32_t txbroadcastframes_g;
  __IO uint32_t txmulticastframes_g;
  __IO uint32_t tx64octets_gb;
  __IO uint32_t tx65to127octets_gb;
  __IO uint32_t tx128to255octets_gb;
  __IO uint32_t tx256to511octets_gb;
  __IO uint32_t tx512to1023octets_gb;
  __IO uint32_t tx1024tomaxoctets_gb;
  __IO uint32_t txunicastframes_gb;
  __IO uint32_t txmulticastframes_gb;
  __IO uint32_t txbroadcastframes_gb;
  __IO uint32_t txunderflowerror;
  __IO uint32_t txsinglecol_g;
  __IO uint32_t txmulticol_g;
  __IO uint32_t txdeferred;
  __IO uint32_t txlatecol;
  __IO uint32_t txexesscol;
  __IO uint32_t txcarriererror;
  __IO uint32_t txoctetcount_g;
  __IO uint32_t txframecount_g;
  __IO uint32_t txexecessdef_g;
  __IO uint32_t txpauseframes;
  __IO uint32_t txvlanframes_g;
        uint8_t RESERVED3[8];
  __IO uint32_t rxframecount_gb;
  __IO uint32_t rxoctetcount_gb;
  __IO uint32_t rxoctetcount_g;
  __IO uint32_t rxbroadcastframes_g;
  __IO uint32_t rxmulticastframes_g;
  __IO uint32_t rxcrcerror;
  __IO uint32_t rxallignmenterror;
  __IO uint32_t rxrunterror;
  __IO uint32_t rxjabbererror;
  __IO uint32_t rxundersize_g;
  __IO uint32_t rxoversize_g;
  __IO uint32_t rx64octets_gb;
  __IO uint32_t rx65to127octets_gb;
  __IO uint32_t rx128to255octets_gb;
  __IO uint32_t rx256to511octets_gb;
  __IO uint32_t rx512to1023octets_gb;
  __IO uint32_t rx1024tomaxoctets_gb;
  __IO uint32_t rxunicastframes_g;
  __IO uint32_t rxlengtherror;
  __IO uint32_t rxoutofrangetype;
  __IO uint32_t rxpauseframes;
  __IO uint32_t rxfifooverflow;
  __IO uint32_t rxvlanframes_gb;
  __IO uint32_t rxwatchdogerror;
        uint8_t RESERVED4[32];
  __IO uint32_t mmc_ipc_intr_mask_rx;
        uint8_t RESERVED5[4];
  __IO uint32_t mmc_ipc_intr_rx;
        uint8_t RESERVED6[4];
  __IO uint32_t rxipv4_gd_frms;
  __IO uint32_t rxipv4_hdrerr_frms;
  __IO uint32_t rxipv4_nopay_frms;
  __IO uint32_t rxipv4_frag_frms;
  __IO uint32_t rxipv4_udsbl_frms;
  __IO uint32_t rxipv6_gd_frms;
  __IO uint32_t rxipv6_hdrerr_frms;
  __IO uint32_t rxipv6_nopay_frms;
  __IO uint32_t rxudp_gd_frms;
  __IO uint32_t rxudp_err_frms;
  __IO uint32_t rxtcp_gd_frms;
  __IO uint32_t rxtcp_err_frms;
  __IO uint32_t rxicmp_gd_frms;
  __IO uint32_t rxicmp_err_frms;
        uint8_t RESERVED7[8];
  __IO uint32_t rxipv4_gd_octets;
  __IO uint32_t rxipv4_hdrerr_octets;
  __IO uint32_t rxipv4_nopay_octets;
  __IO uint32_t rxipv4_frag_octets;
  __IO uint32_t rxipv4_udsbl_octets;
  __IO uint32_t rxipv6_gd_octets;
  __IO uint32_t rxipv6_hdrerr_octets;
  __IO uint32_t rxipv6_nopay_octets;
  __IO uint32_t rxudp_gd_octets;
  __IO uint32_t rxudp_err_octets;
  __IO uint32_t rxtcp_gd_octets;
  __IO uint32_t rxtcp_err_octets;
  __IO uint32_t rxicmp_gd_octets;
  __IO uint32_t rxicmp_err_octets;
        uint8_t RESERVED8[1144];
  union {
    __IO uint32_t TSCR;
    stc_ethernet_mac_tscr_field_t TSCR_f;
  };
  union {
    __IO uint32_t SSIR;
    stc_ethernet_mac_ssir_field_t SSIR_f;
  };
  union {
    __IO uint32_t STSR;
    stc_ethernet_mac_stsr_field_t STSR_f;
  };
  union {
    __IO uint32_t STNR;
    stc_ethernet_mac_stnr_field_t STNR_f;
  };
  union {
    __IO uint32_t STSUR;
    stc_ethernet_mac_stsur_field_t STSUR_f;
  };
  union {
    __IO uint32_t STNUR;
    stc_ethernet_mac_stnur_field_t STNUR_f;
  };
  union {
    __IO uint32_t TSAR;
    stc_ethernet_mac_tsar_field_t TSAR_f;
  };
  union {
    __IO uint32_t TTSR;
    stc_ethernet_mac_ttsr_field_t TTSR_f;
  };
  union {
    __IO uint32_t TTNR;
    stc_ethernet_mac_ttnr_field_t TTNR_f;
  };
  union {
    __IO uint32_t STHWSR;
    stc_ethernet_mac_sthwsr_field_t STHWSR_f;
  };
  union {
    __IO uint32_t TSR;
    stc_ethernet_mac_tsr_field_t TSR_f;
  };
  union {
    __IO uint32_t PPSCR;
    stc_ethernet_mac_ppscr_field_t PPSCR_f;
  };
  union {
    __IO uint32_t ATNR;
    stc_ethernet_mac_atnr_field_t ATNR_f;
  };
  union {
    __IO uint32_t ATSR;
    stc_ethernet_mac_atsr_field_t ATSR_f;
  };
        uint8_t RESERVED9[200];
  union {
    __IO uint32_t MAR16H;
    stc_ethernet_mac_mar16h_field_t MAR16H_f;
  };
  union {
    __IO uint32_t MAR16L;
    stc_ethernet_mac_mar16l_field_t MAR16L_f;
  };
  union {
    __IO uint32_t MAR17H;
    stc_ethernet_mac_mar17h_field_t MAR17H_f;
  };
  union {
    __IO uint32_t MAR17L;
    stc_ethernet_mac_mar17l_field_t MAR17L_f;
  };
  union {
    __IO uint32_t MAR18H;
    stc_ethernet_mac_mar18h_field_t MAR18H_f;
  };
  union {
    __IO uint32_t MAR18L;
    stc_ethernet_mac_mar18l_field_t MAR18L_f;
  };
  union {
    __IO uint32_t MAR19H;
    stc_ethernet_mac_mar19h_field_t MAR19H_f;
  };
  union {
    __IO uint32_t MAR19L;
    stc_ethernet_mac_mar19l_field_t MAR19L_f;
  };
  union {
    __IO uint32_t MAR20H;
    stc_ethernet_mac_mar20h_field_t MAR20H_f;
  };
  union {
    __IO uint32_t MAR20L;
    stc_ethernet_mac_mar20l_field_t MAR20L_f;
  };
  union {
    __IO uint32_t MAR21H;
    stc_ethernet_mac_mar21h_field_t MAR21H_f;
  };
  union {
    __IO uint32_t MAR21L;
    stc_ethernet_mac_mar21l_field_t MAR21L_f;
  };
  union {
    __IO uint32_t MAR22H;
    stc_ethernet_mac_mar22h_field_t MAR22H_f;
  };
  union {
    __IO uint32_t MAR22L;
    stc_ethernet_mac_mar22l_field_t MAR22L_f;
  };
  union {
    __IO uint32_t MAR23H;
    stc_ethernet_mac_mar23h_field_t MAR23H_f;
  };
  union {
    __IO uint32_t MAR23L;
    stc_ethernet_mac_mar23l_field_t MAR23L_f;
  };
  union {
    __IO uint32_t MAR24H;
    stc_ethernet_mac_mar24h_field_t MAR24H_f;
  };
  union {
    __IO uint32_t MAR24L;
    stc_ethernet_mac_mar24l_field_t MAR24L_f;
  };
  union {
    __IO uint32_t MAR25H;
    stc_ethernet_mac_mar25h_field_t MAR25H_f;
  };
  union {
    __IO uint32_t MAR25L;
    stc_ethernet_mac_mar25l_field_t MAR25L_f;
  };
  union {
    __IO uint32_t MAR26H;
    stc_ethernet_mac_mar26h_field_t MAR26H_f;
  };
  union {
    __IO uint32_t MAR26L;
    stc_ethernet_mac_mar26l_field_t MAR26L_f;
  };
  union {
    __IO uint32_t MAR27H;
    stc_ethernet_mac_mar27h_field_t MAR27H_f;
  };
  union {
    __IO uint32_t MAR27L;
    stc_ethernet_mac_mar27l_field_t MAR27L_f;
  };
  union {
    __IO uint32_t MAR28H;
    stc_ethernet_mac_mar28h_field_t MAR28H_f;
  };
  union {
    __IO uint32_t MAR28L;
    stc_ethernet_mac_mar28l_field_t MAR28L_f;
  };
  union {
    __IO uint32_t MAR29H;
    stc_ethernet_mac_mar29h_field_t MAR29H_f;
  };
  union {
    __IO uint32_t MAR29L;
    stc_ethernet_mac_mar29l_field_t MAR29L_f;
  };
  union {
    __IO uint32_t MAR30H;
    stc_ethernet_mac_mar30h_field_t MAR30H_f;
  };
  union {
    __IO uint32_t MAR30L;
    stc_ethernet_mac_mar30l_field_t MAR30L_f;
  };
  union {
    __IO uint32_t MAR31H;
    stc_ethernet_mac_mar31h_field_t MAR31H_f;
  };
  union {
    __IO uint32_t MAR31L;
    stc_ethernet_mac_mar31l_field_t MAR31L_f;
  };
        uint8_t RESERVED10[1920];
  union {
    __IO uint32_t BMR;
    stc_ethernet_mac_bmr_field_t BMR_f;
  };
  union {
    __IO uint32_t TPDR;
    stc_ethernet_mac_tpdr_field_t TPDR_f;
  };
  union {
    __IO uint32_t RPDR;
    stc_ethernet_mac_rpdr_field_t RPDR_f;
  };
  union {
    __IO uint32_t RDLAR;
    stc_ethernet_mac_rdlar_field_t RDLAR_f;
  };
  union {
    __IO uint32_t TDLAR;
    stc_ethernet_mac_tdlar_field_t TDLAR_f;
  };
  union {
    __IO uint32_t SR;
    stc_ethernet_mac_sr_field_t SR_f;
  };
  union {
    __IO uint32_t OMR;
    stc_ethernet_mac_omr_field_t OMR_f;
  };
  union {
    __IO uint32_t IER;
    stc_ethernet_mac_ier_field_t IER_f;
  };
  union {
    __IO uint32_t MFBOCR;
    stc_ethernet_mac_mfbocr_field_t MFBOCR_f;
  };
  union {
    __IO uint32_t RIWTR;
    stc_ethernet_mac_riwtr_field_t RIWTR_f;
  };
        uint8_t RESERVED11[4];
  union {
    __IO uint32_t AHBSR;
    stc_ethernet_mac_ahbsr_field_t AHBSR_f;
  };
        uint8_t RESERVED12[24];
  union {
    __IO uint32_t CHTDR;
    stc_ethernet_mac_chtdr_field_t CHTDR_f;
  };
  union {
    __IO uint32_t CHRDR;
    stc_ethernet_mac_chrdr_field_t CHRDR_f;
  };
  union {
    __IO uint32_t CHTBAR;
    stc_ethernet_mac_chtbar_field_t CHTBAR_f;
  };
  union {
    __IO uint32_t CHRBAR;
    stc_ethernet_mac_chrbar_field_t CHRBAR_f;
  };
}FM3_ETHERNET_MAC_TypeDef;

/* ETHERNET-CONTROL registers */
typedef struct
{
  union {
    __IO uint32_t ETH_MODE;
    stc_ethernet_control_eth_mode_field_t ETH_MODE_f;
  };
        uint8_t RESERVED1[4];
  union {
    __IO uint32_t ETH_CLKG;
    stc_ethernet_control_eth_clkg_field_t ETH_CLKG_f;
  };
}FM3_ETHERNET_CONTROL_TypeDef;

/******************************************************************************
 * Peripheral memory map
 ******************************************************************************/
#define FM3_FLASH_BASE        (0x00000000UL)                 /* Flash Base                             */
#define FM3_PERIPH_BASE       (0x40000000UL)                 /* Peripheral  Base                       */
#define FM3_CM3_BASE          (0xE0100000UL)                 /* CM3 Private                            */

#define FM3_FLASH_IF_BASE     (FM3_PERIPH_BASE + 0x00000UL)  /* Flash interface registers              */
#define FM3_CRG_BASE          (FM3_PERIPH_BASE + 0x10000UL)  /* Clock and reset registers              */
#define FM3_HWWDT_BASE        (FM3_PERIPH_BASE + 0x11000UL)  /* Hardware watchdog registers            */
#define FM3_SWWDT_BASE        (FM3_PERIPH_BASE + 0x12000UL)  /* Software watchdog registers            */
#define FM3_DTIM_BASE         (FM3_PERIPH_BASE + 0x15000UL)  /* Dual timer 1/2 registers               */
#define FM3_MFT0_FRT_BASE     (FM3_PERIPH_BASE + 0x20000UL)  /* Multifunction Timer unit 0 Free Running Timer registers */
#define FM3_MFT0_OCU_BASE     (FM3_PERIPH_BASE + 0x20000UL)  /* Multifunction Timer unit 0 Output Compare Unit registers */
#define FM3_MFT0_WFG_BASE     (FM3_PERIPH_BASE + 0x20000UL)  /* Multifunction Timer unit 0 Waveform Generator and Noise Canceler registers */
#define FM3_MFT0_ICU_BASE     (FM3_PERIPH_BASE + 0x20000UL)  /* Multifunction Timer unit 0 Input Capture Unit registers */
#define FM3_MFT0_ADCMP_BASE   (FM3_PERIPH_BASE + 0x20000UL)  /* Multifunction Timer unit 0 ADC Start Compare Unit registers */
#define FM3_MFT1_FRT_BASE     (FM3_PERIPH_BASE + 0x21000UL)  /* Multifunction Timer unit 1 Free Running Timer registers */
#define FM3_MFT1_OCU_BASE     (FM3_PERIPH_BASE + 0x21000UL)  /* Multifunction Timer unit 1 Output Compare Unit registers */
#define FM3_MFT1_WFG_BASE     (FM3_PERIPH_BASE + 0x21000UL)  /* Multifunction Timer unit 1 Waveform Generator and Noise Canceler registers */
#define FM3_MFT1_ICU_BASE     (FM3_PERIPH_BASE + 0x21000UL)  /* Multifunction Timer unit 1 Input Capture Unit registers */
#define FM3_MFT1_ADCMP_BASE   (FM3_PERIPH_BASE + 0x21000UL)  /* Multifunction Timer unit 1 ADC Start Compare Unit registers */
#define FM3_MFT2_FRT_BASE     (FM3_PERIPH_BASE + 0x22000UL)  /* Multifunction Timer unit 2 Free Running Timer registers */
#define FM3_MFT2_OCU_BASE     (FM3_PERIPH_BASE + 0x22000UL)  /* Multifunction Timer unit 2 Output Compare Unit registers */
#define FM3_MFT2_WFG_BASE     (FM3_PERIPH_BASE + 0x22000UL)  /* Multifunction Timer unit 2 Waveform Generator and Noise Canceler registers */
#define FM3_MFT2_ICU_BASE     (FM3_PERIPH_BASE + 0x22000UL)  /* Multifunction Timer unit 2 Input Capture Unit registers */
#define FM3_MFT2_ADCMP_BASE   (FM3_PERIPH_BASE + 0x22000UL)  /* Multifunction Timer unit 2 ADC Start Compare Unit registers */
#define FM3_MFT_PPG_BASE      (FM3_PERIPH_BASE + 0x24000UL)  /* Multifunction Timer PPG registers      */
#define FM3_BT0_PPG_BASE      (FM3_PERIPH_BASE + 0x25000UL)  /* Base Timer 0 PPG registers             */
#define FM3_BT0_PWM_BASE      (FM3_PERIPH_BASE + 0x25000UL)  /* Base Timer 0 PWM registers             */
#define FM3_BT0_RT_BASE       (FM3_PERIPH_BASE + 0x25000UL)  /* Base Timer 0 RT registers              */
#define FM3_BT0_PWC_BASE      (FM3_PERIPH_BASE + 0x25000UL)  /* Base Timer 0 PWC registers             */
#define FM3_BT1_PPG_BASE      (FM3_PERIPH_BASE + 0x25040UL)  /* Base Timer 1 PPG registers             */
#define FM3_BT1_PWM_BASE      (FM3_PERIPH_BASE + 0x25040UL)  /* Base Timer 1 PWM registers             */
#define FM3_BT1_RT_BASE       (FM3_PERIPH_BASE + 0x25040UL)  /* Base Timer 1 RT registers              */
#define FM3_BT1_PWC_BASE      (FM3_PERIPH_BASE + 0x25040UL)  /* Base Timer 1 PWC registers             */
#define FM3_BT2_PPG_BASE      (FM3_PERIPH_BASE + 0x25080UL)  /* Base Timer 2 PPG registers             */
#define FM3_BT2_PWM_BASE      (FM3_PERIPH_BASE + 0x25080UL)  /* Base Timer 2 PWM registers             */
#define FM3_BT2_RT_BASE       (FM3_PERIPH_BASE + 0x25080UL)  /* Base Timer 2 RT registers              */
#define FM3_BT2_PWC_BASE      (FM3_PERIPH_BASE + 0x25080UL)  /* Base Timer 2 PWC registers             */
#define FM3_BT3_PPG_BASE      (FM3_PERIPH_BASE + 0x250C0UL)  /* Base Timer 3 PPG registers             */
#define FM3_BT3_PWM_BASE      (FM3_PERIPH_BASE + 0x250C0UL)  /* Base Timer 3 PWM registers             */
#define FM3_BT3_RT_BASE       (FM3_PERIPH_BASE + 0x250C0UL)  /* Base Timer 3 RT registers              */
#define FM3_BT3_PWC_BASE      (FM3_PERIPH_BASE + 0x250C0UL)  /* Base Timer 3 PWC registers             */
#define FM3_BT4_PPG_BASE      (FM3_PERIPH_BASE + 0x25200UL)  /* Base Timer 4 PPG registers             */
#define FM3_BT4_PWM_BASE      (FM3_PERIPH_BASE + 0x25200UL)  /* Base Timer 4 PWM registers             */
#define FM3_BT4_RT_BASE       (FM3_PERIPH_BASE + 0x25200UL)  /* Base Timer 4 RT registers              */
#define FM3_BT4_PWC_BASE      (FM3_PERIPH_BASE + 0x25200UL)  /* Base Timer 4 PWC registers             */
#define FM3_BT5_PPG_BASE      (FM3_PERIPH_BASE + 0x25240UL)  /* Base Timer 5 PPG registers             */
#define FM3_BT5_PWM_BASE      (FM3_PERIPH_BASE + 0x25240UL)  /* Base Timer 5 PWM registers             */
#define FM3_BT5_RT_BASE       (FM3_PERIPH_BASE + 0x25240UL)  /* Base Timer 5 RT registers              */
#define FM3_BT5_PWC_BASE      (FM3_PERIPH_BASE + 0x25240UL)  /* Base Timer 5 PWC registers             */
#define FM3_BT6_PPG_BASE      (FM3_PERIPH_BASE + 0x25280UL)  /* Base Timer 6 PPG registers             */
#define FM3_BT6_PWM_BASE      (FM3_PERIPH_BASE + 0x25280UL)  /* Base Timer 6 PWM registers             */
#define FM3_BT6_RT_BASE       (FM3_PERIPH_BASE + 0x25280UL)  /* Base Timer 6 RT registers              */
#define FM3_BT6_PWC_BASE      (FM3_PERIPH_BASE + 0x25280UL)  /* Base Timer 6 PWC registers             */
#define FM3_BT7_PPG_BASE      (FM3_PERIPH_BASE + 0x252C0UL)  /* Base Timer 7 PPG registers             */
#define FM3_BT7_PWM_BASE      (FM3_PERIPH_BASE + 0x252C0UL)  /* Base Timer 7 PWM registers             */
#define FM3_BT7_RT_BASE       (FM3_PERIPH_BASE + 0x252C0UL)  /* Base Timer 7 RT registers              */
#define FM3_BT7_PWC_BASE      (FM3_PERIPH_BASE + 0x252C0UL)  /* Base Timer 7 PWC registers             */
#define FM3_BTIOSEL03_BASE    (FM3_PERIPH_BASE + 0x25100UL)  /* Base Timer I/O selector channel 0 - channel 3 registers */
#define FM3_BTIOSEL47_BASE    (FM3_PERIPH_BASE + 0x25300UL)  /* Base Timer I/O selector channel 4 - channel 7 registers */
#define FM3_BT8_PPG_BASE      (FM3_PERIPH_BASE + 0x25400UL)  /* Base Timer 8 PPG registers             */
#define FM3_BT8_PWM_BASE      (FM3_PERIPH_BASE + 0x25400UL)  /* Base Timer 8 PWM registers             */
#define FM3_BT8_RT_BASE       (FM3_PERIPH_BASE + 0x25400UL)  /* Base Timer 8 RT registers              */
#define FM3_BT8_PWC_BASE      (FM3_PERIPH_BASE + 0x25400UL)  /* Base Timer 8 PWC registers             */
#define FM3_BT9_PPG_BASE      (FM3_PERIPH_BASE + 0x25440UL)  /* Base Timer 9 PPG registers             */
#define FM3_BT9_PWM_BASE      (FM3_PERIPH_BASE + 0x25440UL)  /* Base Timer 9 PWM registers             */
#define FM3_BT9_RT_BASE       (FM3_PERIPH_BASE + 0x25440UL)  /* Base Timer 9 RT registers              */
#define FM3_BT9_PWC_BASE      (FM3_PERIPH_BASE + 0x25440UL)  /* Base Timer 9 PWC registers             */
#define FM3_BT10_PPG_BASE     (FM3_PERIPH_BASE + 0x25480UL)  /* Base Timer 10 PPG registers            */
#define FM3_BT10_PWM_BASE     (FM3_PERIPH_BASE + 0x25480UL)  /* Base Timer 10 PWM registers            */
#define FM3_BT10_RT_BASE      (FM3_PERIPH_BASE + 0x25480UL)  /* Base Timer 10 RT registers             */
#define FM3_BT10_PWC_BASE     (FM3_PERIPH_BASE + 0x25480UL)  /* Base Timer 10 PWC registers            */
#define FM3_BT11_PPG_BASE     (FM3_PERIPH_BASE + 0x254C0UL)  /* Base Timer 11 PPG registers            */
#define FM3_BT11_PWM_BASE     (FM3_PERIPH_BASE + 0x254C0UL)  /* Base Timer 11 PWM registers            */
#define FM3_BT11_RT_BASE      (FM3_PERIPH_BASE + 0x254C0UL)  /* Base Timer 11 RT registers             */
#define FM3_BT11_PWC_BASE     (FM3_PERIPH_BASE + 0x254C0UL)  /* Base Timer 11 PWC registers            */
#define FM3_BT12_PPG_BASE     (FM3_PERIPH_BASE + 0x25600UL)  /* Base Timer 8 PPG registers             */
#define FM3_BT12_PWM_BASE     (FM3_PERIPH_BASE + 0x25600UL)  /* Base Timer 8 PWM registers             */
#define FM3_BT12_RT_BASE      (FM3_PERIPH_BASE + 0x25600UL)  /* Base Timer 8 RT registers              */
#define FM3_BT12_PWC_BASE     (FM3_PERIPH_BASE + 0x25600UL)  /* Base Timer 8 PWC registers             */
#define FM3_BT13_PPG_BASE     (FM3_PERIPH_BASE + 0x25640UL)  /* Base Timer 9 PPG registers             */
#define FM3_BT13_PWM_BASE     (FM3_PERIPH_BASE + 0x25640UL)  /* Base Timer 9 PWM registers             */
#define FM3_BT13_RT_BASE      (FM3_PERIPH_BASE + 0x25640UL)  /* Base Timer 9 RT registers              */
#define FM3_BT13_PWC_BASE     (FM3_PERIPH_BASE + 0x25640UL)  /* Base Timer 9 PWC registers             */
#define FM3_BT14_PPG_BASE     (FM3_PERIPH_BASE + 0x25680UL)  /* Base Timer 10 PPG registers            */
#define FM3_BT14_PWM_BASE     (FM3_PERIPH_BASE + 0x25680UL)  /* Base Timer 10 PWM registers            */
#define FM3_BT14_RT_BASE      (FM3_PERIPH_BASE + 0x25680UL)  /* Base Timer 10 RT registers             */
#define FM3_BT14_PWC_BASE     (FM3_PERIPH_BASE + 0x25680UL)  /* Base Timer 10 PWC registers            */
#define FM3_BT15_PPG_BASE     (FM3_PERIPH_BASE + 0x256C0UL)  /* Base Timer 11 PPG registers            */
#define FM3_BT15_PWM_BASE     (FM3_PERIPH_BASE + 0x256C0UL)  /* Base Timer 11 PWM registers            */
#define FM3_BT15_RT_BASE      (FM3_PERIPH_BASE + 0x256C0UL)  /* Base Timer 11 RT registers             */
#define FM3_BT15_PWC_BASE     (FM3_PERIPH_BASE + 0x256C0UL)  /* Base Timer 11 PWC registers            */
#define FM3_BTIOSEL8B_BASE    (FM3_PERIPH_BASE + 0x25500UL)  /* Base Timer I/O selector channel 8 - channel 11 registers */
#define FM3_BTIOSELCF_BASE    (FM3_PERIPH_BASE + 0x25700UL)  /* Base Timer I/O selector channel 12 - channel 15 registers */
#define FM3_SBSSR_BASE        (FM3_PERIPH_BASE + 0x25FFCUL)  /* Software based Simulation Startup (Base Timer) register */
#define FM3_QPRC0_BASE        (FM3_PERIPH_BASE + 0x26000UL)  /* Quad position and revolution counter channel 0 registers */
#define FM3_QPRC1_BASE        (FM3_PERIPH_BASE + 0x26040UL)  /* Quad position and revolution counter channel 1 registers */
#define FM3_QPRC2_BASE        (FM3_PERIPH_BASE + 0x26080UL)  /* Quad position and revolution counter channel 2 registers */
#define FM3_ADC0_BASE         (FM3_PERIPH_BASE + 0x27000UL)  /* 12-bit ADC unit 0 registers            */
#define FM3_ADC1_BASE         (FM3_PERIPH_BASE + 0x27100UL)  /* 12-bit ADC unit 1 registers            */
#define FM3_ADC2_BASE         (FM3_PERIPH_BASE + 0x27200UL)  /* 12-bit ADC unit 2 registers            */
#define FM3_CRTRIM_BASE       (FM3_PERIPH_BASE + 0x2E000UL)  /* CR trimming registers                  */
#define FM3_EXTI_BASE         (FM3_PERIPH_BASE + 0x30000UL)  /* External interrupt registers           */
#define FM3_INTREQ_BASE       (FM3_PERIPH_BASE + 0x31000UL)  /* Interrupt request read registers       */
#define FM3_GPIO_BASE         (FM3_PERIPH_BASE + 0x33000UL)  /* General purpose I/O registers          */
#define FM3_LVD_BASE          (FM3_PERIPH_BASE + 0x35000UL)  /* Low voltage detection registers        */
#define FM3_USBETHERNETCLK_BASE (FM3_PERIPH_BASE + 0x36000UL)  /* USB clock registers                    */
#define FM3_CANPRES_BASE      (FM3_PERIPH_BASE + 0x37000UL)  /* CAN prescaler register                 */
#define FM3_MFS0_UART_BASE    (FM3_PERIPH_BASE + 0x38000UL)  /* UART asynchronous channel 0 registers  */
#define FM3_MFS0_CSIO_BASE    (FM3_PERIPH_BASE + 0x38000UL)  /* UART synchronous channel 0 registers   */
#define FM3_MFS0_LIN_BASE     (FM3_PERIPH_BASE + 0x38000UL)  /* UART LIN channel 0 registers           */
#define FM3_MFS0_I2C_BASE     (FM3_PERIPH_BASE + 0x38000UL)  /* I2C channel 0 registers                */
#define FM3_MFS1_UART_BASE    (FM3_PERIPH_BASE + 0x38100UL)  /* UART asynchronous channel 1 registers  */
#define FM3_MFS1_CSIO_BASE    (FM3_PERIPH_BASE + 0x38100UL)  /* UART synchronous channel 1 registers   */
#define FM3_MFS1_LIN_BASE     (FM3_PERIPH_BASE + 0x38100UL)  /* UART LIN channel 1 registers           */
#define FM3_MFS1_I2C_BASE     (FM3_PERIPH_BASE + 0x38100UL)  /* I2C channel 1 registers                */
#define FM3_MFS2_UART_BASE    (FM3_PERIPH_BASE + 0x38200UL)  /* UART asynchronous channel 2 registers  */
#define FM3_MFS2_CSIO_BASE    (FM3_PERIPH_BASE + 0x38200UL)  /* UART synchronous channel 2 registers   */
#define FM3_MFS2_LIN_BASE     (FM3_PERIPH_BASE + 0x38200UL)  /* UART LIN channel 2 registers           */
#define FM3_MFS2_I2C_BASE     (FM3_PERIPH_BASE + 0x38200UL)  /* I2C channel 2 registers                */
#define FM3_MFS3_UART_BASE    (FM3_PERIPH_BASE + 0x38300UL)  /* UART asynchronous channel 3 registers  */
#define FM3_MFS3_CSIO_BASE    (FM3_PERIPH_BASE + 0x38300UL)  /* UART synchronous channel 3 registers   */
#define FM3_MFS3_LIN_BASE     (FM3_PERIPH_BASE + 0x38300UL)  /* UART LIN channel 3 registers           */
#define FM3_MFS3_I2C_BASE     (FM3_PERIPH_BASE + 0x38300UL)  /* I2C channel 3 registers                */
#define FM3_MFS4_UART_BASE    (FM3_PERIPH_BASE + 0x38400UL)  /* UART asynchronous channel 4 registers  */
#define FM3_MFS4_CSIO_BASE    (FM3_PERIPH_BASE + 0x38400UL)  /* UART synchronous channel 4 registers   */
#define FM3_MFS4_LIN_BASE     (FM3_PERIPH_BASE + 0x38400UL)  /* UART LIN channel 4 registers           */
#define FM3_MFS4_I2C_BASE     (FM3_PERIPH_BASE + 0x38400UL)  /* I2C channel 4 registers                */
#define FM3_MFS5_UART_BASE    (FM3_PERIPH_BASE + 0x38500UL)  /* UART asynchronous channel 5 registers  */
#define FM3_MFS5_CSIO_BASE    (FM3_PERIPH_BASE + 0x38500UL)  /* UART synchronous channel 5 registers   */
#define FM3_MFS5_LIN_BASE     (FM3_PERIPH_BASE + 0x38500UL)  /* UART LIN channel 5 registers           */
#define FM3_MFS5_I2C_BASE     (FM3_PERIPH_BASE + 0x38500UL)  /* I2C channel 5 registers                */
#define FM3_MFS6_UART_BASE    (FM3_PERIPH_BASE + 0x38600UL)  /* UART asynchronous channel 6 registers  */
#define FM3_MFS6_CSIO_BASE    (FM3_PERIPH_BASE + 0x38600UL)  /* UART synchronous channel 6 registers   */
#define FM3_MFS6_LIN_BASE     (FM3_PERIPH_BASE + 0x38600UL)  /* UART LIN channel 6 registers           */
#define FM3_MFS6_I2C_BASE     (FM3_PERIPH_BASE + 0x38600UL)  /* I2C channel 6 registers                */
#define FM3_MFS7_UART_BASE    (FM3_PERIPH_BASE + 0x38700UL)  /* UART asynchronous channel 7 registers  */
#define FM3_MFS7_CSIO_BASE    (FM3_PERIPH_BASE + 0x38700UL)  /* UART synchronous channel 7 registers   */
#define FM3_MFS7_LIN_BASE     (FM3_PERIPH_BASE + 0x38700UL)  /* UART LIN channel 7 registers           */
#define FM3_MFS7_I2C_BASE     (FM3_PERIPH_BASE + 0x38700UL)  /* I2C channel 7 registers                */
#define FM3_MFS_NFC_BASE      (FM3_PERIPH_BASE + 0x38800UL)  /* MFS Noise Filter Control register      */
#define FM3_CRC_BASE          (FM3_PERIPH_BASE + 0x39000UL)  /* CRC registers                          */
#define FM3_WC_BASE           (FM3_PERIPH_BASE + 0x3A000UL)  /* Watch counter registers                */
#define FM3_EXBUS_BASE        (FM3_PERIPH_BASE + 0x3F000UL)  /* External bus interface registers       */
#define FM3_USB0_BASE         (FM3_PERIPH_BASE + 0x42100UL)  /* USB channel 0 registers                */
#define FM3_USB1_BASE         (FM3_PERIPH_BASE + 0x52100UL)  /* USB channel 1 registers                */
#define FM3_DMAC_BASE         (FM3_PERIPH_BASE + 0x60000UL)  /* DMA controller                         */
#define FM3_CAN0_BASE         (FM3_PERIPH_BASE + 0x62000UL)  /* CAN channel 0 registers                */
#define FM3_CAN1_BASE         (FM3_PERIPH_BASE + 0x63000UL)  /* CAN channel 1 registers                */
#define FM3_ETHERNET_MAC0_BASE    (FM3_PERIPH_BASE + 0x64000UL) /* Ethernet MAC 0 registers            */
#define FM3_ETHERNET_CONTROL_BASE (FM3_PERIPH_BASE + 0x66000UL) /* Ethernet MAC control registers      */
#define FM3_ETHERNET_MAC1_BASE    (FM3_PERIPH_BASE + 0x67000UL) /* Ethernet MAC 1 registers            */

/******************************************************************************
 * Peripheral declaration
 ******************************************************************************/
#define FM3_FLASH_IF    ((FM3_FLASH_IF_TypeDef *)FM3_FLASH_IF_BASE)
#define FM3_CRG         ((FM3_CRG_TypeDef *)FM3_CRG_BASE)
#define FM3_HWWDT       ((FM3_HWWDT_TypeDef *)FM3_HWWDT_BASE)
#define FM3_SWWDT       ((FM3_SWWDT_TypeDef *)FM3_SWWDT_BASE)
#define FM3_DTIM        ((FM3_DTIM_TypeDef *)FM3_DTIM_BASE)
#define FM3_MFT0_FRT    ((FM3_MFT_FRT_TypeDef *)FM3_MFT0_FRT_BASE)
#define FM3_MFT0_OCU    ((FM3_MFT_OCU_TypeDef *)FM3_MFT0_OCU_BASE)
#define FM3_MFT0_WFG    ((FM3_MFT_WFG_TypeDef *)FM3_MFT0_WFG_BASE)
#define FM3_MFT0_ICU    ((FM3_MFT_ICU_TypeDef *)FM3_MFT0_ICU_BASE)
#define FM3_MFT0_ADCMP  ((FM3_MFT_ADCMP_TypeDef *)FM3_MFT0_ADCMP_BASE)
#define FM3_MFT1_FRT    ((FM3_MFT_FRT_TypeDef *)FM3_MFT1_FRT_BASE)
#define FM3_MFT1_OCU    ((FM3_MFT_OCU_TypeDef *)FM3_MFT1_OCU_BASE)
#define FM3_MFT1_WFG    ((FM3_MFT_WFG_TypeDef *)FM3_MFT1_WFG_BASE)
#define FM3_MFT1_ICU    ((FM3_MFT_ICU_TypeDef *)FM3_MFT1_ICU_BASE)
#define FM3_MFT1_ADCMP  ((FM3_MFT_ADCMP_TypeDef *)FM3_MFT1_ADCMP_BASE)
#define FM3_MFT2_FRT    ((FM3_MFT_FRT_TypeDef *)FM3_MFT2_FRT_BASE)
#define FM3_MFT2_OCU    ((FM3_MFT_OCU_TypeDef *)FM3_MFT2_OCU_BASE)
#define FM3_MFT2_WFG    ((FM3_MFT_WFG_TypeDef *)FM3_MFT2_WFG_BASE)
#define FM3_MFT2_ICU    ((FM3_MFT_ICU_TypeDef *)FM3_MFT2_ICU_BASE)
#define FM3_MFT2_ADCMP  ((FM3_MFT_ADCMP_TypeDef *)FM3_MFT2_ADCMP_BASE)
#define FM3_MFT_PPG     ((FM3_MFT_PPG_TypeDef *)FM3_MFT_PPG_BASE)
#define FM3_BT0_PPG     ((FM3_BT_PPG_TypeDef *)FM3_BT0_PPG_BASE)
#define FM3_BT0_PWM     ((FM3_BT_PWM_TypeDef *)FM3_BT0_PWM_BASE)
#define FM3_BT0_RT      ((FM3_BT_RT_TypeDef *)FM3_BT0_RT_BASE)
#define FM3_BT0_PWC     ((FM3_BT_PWC_TypeDef *)FM3_BT0_PWC_BASE)
#define FM3_BT1_PPG     ((FM3_BT_PPG_TypeDef *)FM3_BT1_PPG_BASE)
#define FM3_BT1_PWM     ((FM3_BT_PWM_TypeDef *)FM3_BT1_PWM_BASE)
#define FM3_BT1_RT      ((FM3_BT_RT_TypeDef *)FM3_BT1_RT_BASE)
#define FM3_BT1_PWC     ((FM3_BT_PWC_TypeDef *)FM3_BT1_PWC_BASE)
#define FM3_BT2_PPG     ((FM3_BT_PPG_TypeDef *)FM3_BT2_PPG_BASE)
#define FM3_BT2_PWM     ((FM3_BT_PWM_TypeDef *)FM3_BT2_PWM_BASE)
#define FM3_BT2_RT      ((FM3_BT_RT_TypeDef *)FM3_BT2_RT_BASE)
#define FM3_BT2_PWC     ((FM3_BT_PWC_TypeDef *)FM3_BT2_PWC_BASE)
#define FM3_BT3_PPG     ((FM3_BT_PPG_TypeDef *)FM3_BT3_PPG_BASE)
#define FM3_BT3_PWM     ((FM3_BT_PWM_TypeDef *)FM3_BT3_PWM_BASE)
#define FM3_BT3_RT      ((FM3_BT_RT_TypeDef *)FM3_BT3_RT_BASE)
#define FM3_BT3_PWC     ((FM3_BT_PWC_TypeDef *)FM3_BT3_PWC_BASE)
#define FM3_BT4_PPG     ((FM3_BT_PPG_TypeDef *)FM3_BT4_PPG_BASE)
#define FM3_BT4_PWM     ((FM3_BT_PWM_TypeDef *)FM3_BT4_PWM_BASE)
#define FM3_BT4_RT      ((FM3_BT_RT_TypeDef *)FM3_BT4_RT_BASE)
#define FM3_BT4_PWC     ((FM3_BT_PWC_TypeDef *)FM3_BT4_PWC_BASE)
#define FM3_BT5_PPG     ((FM3_BT_PPG_TypeDef *)FM3_BT5_PPG_BASE)
#define FM3_BT5_PWM     ((FM3_BT_PWM_TypeDef *)FM3_BT5_PWM_BASE)
#define FM3_BT5_RT      ((FM3_BT_RT_TypeDef *)FM3_BT5_RT_BASE)
#define FM3_BT5_PWC     ((FM3_BT_PWC_TypeDef *)FM3_BT5_PWC_BASE)
#define FM3_BT6_PPG     ((FM3_BT_PPG_TypeDef *)FM3_BT6_PPG_BASE)
#define FM3_BT6_PWM     ((FM3_BT_PWM_TypeDef *)FM3_BT6_PWM_BASE)
#define FM3_BT6_RT      ((FM3_BT_RT_TypeDef *)FM3_BT6_RT_BASE)
#define FM3_BT6_PWC     ((FM3_BT_PWC_TypeDef *)FM3_BT6_PWC_BASE)
#define FM3_BT7_PPG     ((FM3_BT_PPG_TypeDef *)FM3_BT7_PPG_BASE)
#define FM3_BT7_PWM     ((FM3_BT_PWM_TypeDef *)FM3_BT7_PWM_BASE)
#define FM3_BT7_RT      ((FM3_BT_RT_TypeDef *)FM3_BT7_RT_BASE)
#define FM3_BT7_PWC     ((FM3_BT_PWC_TypeDef *)FM3_BT7_PWC_BASE)
#define FM3_BTIOSEL03   ((FM3_BTIOSEL03_TypeDef *)FM3_BTIOSEL03_BASE)
#define FM3_BTIOSEL47   ((FM3_BTIOSEL47_TypeDef *)FM3_BTIOSEL47_BASE)
#define FM3_BT8_PPG     ((FM3_BT_PPG_TypeDef *)FM3_BT8_PPG_BASE)
#define FM3_BT8_PWM     ((FM3_BT_PWM_TypeDef *)FM3_BT8_PWM_BASE)
#define FM3_BT8_RT      ((FM3_BT_RT_TypeDef *)FM3_BT8_RT_BASE)
#define FM3_BT8_PWC     ((FM3_BT_PWC_TypeDef *)FM3_BT8_PWC_BASE)
#define FM3_BT9_PPG     ((FM3_BT_PPG_TypeDef *)FM3_BT9_PPG_BASE)
#define FM3_BT9_PWM     ((FM3_BT_PWM_TypeDef *)FM3_BT9_PWM_BASE)
#define FM3_BT9_RT      ((FM3_BT_RT_TypeDef *)FM3_BT9_RT_BASE)
#define FM3_BT9_PWC     ((FM3_BT_PWC_TypeDef *)FM3_BT9_PWC_BASE)
#define FM3_BT10_PPG    ((FM3_BT_PPG_TypeDef *)FM3_BT10_PPG_BASE)
#define FM3_BT10_PWM    ((FM3_BT_PWM_TypeDef *)FM3_BT10_PWM_BASE)
#define FM3_BT10_RT     ((FM3_BT_RT_TypeDef *)FM3_BT10_RT_BASE)
#define FM3_BT10_PWC    ((FM3_BT_PWC_TypeDef *)FM3_BT10_PWC_BASE)
#define FM3_BT11_PPG    ((FM3_BT_PPG_TypeDef *)FM3_BT11_PPG_BASE)
#define FM3_BT11_PWM    ((FM3_BT_PWM_TypeDef *)FM3_BT11_PWM_BASE)
#define FM3_BT11_RT     ((FM3_BT_RT_TypeDef *)FM3_BT11_RT_BASE)
#define FM3_BT11_PWC    ((FM3_BT_PWC_TypeDef *)FM3_BT11_PWC_BASE)
#define FM3_BT12_PPG    ((FM3_BT_PPG_TypeDef *)FM3_BT12_PPG_BASE)
#define FM3_BT12_PWM    ((FM3_BT_PWM_TypeDef *)FM3_BT12_PWM_BASE)
#define FM3_BT12_RT     ((FM3_BT_RT_TypeDef *)FM3_BT12_RT_BASE)
#define FM3_BT12_PWC    ((FM3_BT_PWC_TypeDef *)FM3_BT12_PWC_BASE)
#define FM3_BT13_PPG    ((FM3_BT_PPG_TypeDef *)FM3_BT13_PPG_BASE)
#define FM3_BT13_PWM    ((FM3_BT_PWM_TypeDef *)FM3_BT13_PWM_BASE)
#define FM3_BT13_RT     ((FM3_BT_RT_TypeDef *)FM3_BT13_RT_BASE)
#define FM3_BT13_PWC    ((FM3_BT_PWC_TypeDef *)FM3_BT13_PWC_BASE)
#define FM3_BT14_PPG    ((FM3_BT_PPG_TypeDef *)FM3_BT14_PPG_BASE)
#define FM3_BT14_PWM    ((FM3_BT_PWM_TypeDef *)FM3_BT14_PWM_BASE)
#define FM3_BT14_RT     ((FM3_BT_RT_TypeDef *)FM3_BT14_RT_BASE)
#define FM3_BT14_PWC    ((FM3_BT_PWC_TypeDef *)FM3_BT14_PWC_BASE)
#define FM3_BT15_PPG    ((FM3_BT_PPG_TypeDef *)FM3_BT15_PPG_BASE)
#define FM3_BT15_PWM    ((FM3_BT_PWM_TypeDef *)FM3_BT15_PWM_BASE)
#define FM3_BT15_RT     ((FM3_BT_RT_TypeDef *)FM3_BT15_RT_BASE)
#define FM3_BT15_PWC    ((FM3_BT_PWC_TypeDef *)FM3_BT15_PWC_BASE)
#define FM3_BTIOSEL8B   ((FM3_BTIOSEL8B_TypeDef *)FM3_BTIOSEL8B_BASE)
#define FM3_BTIOSELCF   ((FM3_BTIOSELCF_TypeDef *)FM3_BTIOSELCF_BASE)
#define FM3_SBSSR       ((FM3_SBSSR_TypeDef *)FM3_SBSSR_BASE)
#define FM3_QPRC0       ((FM3_QPRC_TypeDef *)FM3_QPRC0_BASE)
#define FM3_QPRC1       ((FM3_QPRC_TypeDef *)FM3_QPRC1_BASE)
#define FM3_QPRC2       ((FM3_QPRC_TypeDef *)FM3_QPRC2_BASE)
#define FM3_ADC0        ((FM3_ADC_TypeDef *)FM3_ADC0_BASE)
#define FM3_ADC1        ((FM3_ADC_TypeDef *)FM3_ADC1_BASE)
#define FM3_ADC2        ((FM3_ADC_TypeDef *)FM3_ADC2_BASE)
#define FM3_CRTRIM      ((FM3_CRTRIM_TypeDef *)FM3_CRTRIM_BASE)
#define FM3_EXTI        ((FM3_EXTI_TypeDef *)FM3_EXTI_BASE)
#define FM3_INTREQ      ((FM3_INTREQ_TypeDef *)FM3_INTREQ_BASE)
#define FM3_GPIO        ((FM3_GPIO_TypeDef *)FM3_GPIO_BASE)
#define FM3_LVD         ((FM3_LVD_TypeDef *)FM3_LVD_BASE)
#define FM3_USBETHERNETCLK ((FM3_USBETHERNETCLK_TypeDef *)FM3_USBETHERNETCLK_BASE)
#define FM3_CANPRES     ((FM3_CANPRE_TypeDef *)FM3_CANPRES_BASE)
#define FM3_MFS0_UART   ((FM3_MFS03_UART_TypeDef *)FM3_MFS0_UART_BASE)
#define FM3_MFS0_CSIO   ((FM3_MFS03_CSIO_TypeDef *)FM3_MFS0_CSIO_BASE)
#define FM3_MFS0_LIN    ((FM3_MFS03_LIN_TypeDef *)FM3_MFS0_LIN_BASE)
#define FM3_MFS0_I2C    ((FM3_MFS03_I2C_TypeDef *)FM3_MFS0_I2C_BASE)
#define FM3_MFS1_UART   ((FM3_MFS03_UART_TypeDef *)FM3_MFS1_UART_BASE)
#define FM3_MFS1_CSIO   ((FM3_MFS03_CSIO_TypeDef *)FM3_MFS1_CSIO_BASE)
#define FM3_MFS1_LIN    ((FM3_MFS03_LIN_TypeDef *)FM3_MFS1_LIN_BASE)
#define FM3_MFS1_I2C    ((FM3_MFS03_I2C_TypeDef *)FM3_MFS1_I2C_BASE)
#define FM3_MFS2_UART   ((FM3_MFS03_UART_TypeDef *)FM3_MFS2_UART_BASE)
#define FM3_MFS2_CSIO   ((FM3_MFS03_CSIO_TypeDef *)FM3_MFS2_CSIO_BASE)
#define FM3_MFS2_LIN    ((FM3_MFS03_LIN_TypeDef *)FM3_MFS2_LIN_BASE)
#define FM3_MFS2_I2C    ((FM3_MFS03_I2C_TypeDef *)FM3_MFS2_I2C_BASE)
#define FM3_MFS3_UART   ((FM3_MFS03_UART_TypeDef *)FM3_MFS3_UART_BASE)
#define FM3_MFS3_CSIO   ((FM3_MFS03_CSIO_TypeDef *)FM3_MFS3_CSIO_BASE)
#define FM3_MFS3_LIN    ((FM3_MFS03_LIN_TypeDef *)FM3_MFS3_LIN_BASE)
#define FM3_MFS3_I2C    ((FM3_MFS03_I2C_TypeDef *)FM3_MFS3_I2C_BASE)
#define FM3_MFS4_UART   ((FM3_MFS47_UART_TypeDef *)FM3_MFS4_UART_BASE)
#define FM3_MFS4_CSIO   ((FM3_MFS47_CSIO_TypeDef *)FM3_MFS4_CSIO_BASE)
#define FM3_MFS4_LIN    ((FM3_MFS47_LIN_TypeDef *)FM3_MFS4_LIN_BASE)
#define FM3_MFS4_I2C    ((FM3_MFS47_I2C_TypeDef *)FM3_MFS4_I2C_BASE)
#define FM3_MFS5_UART   ((FM3_MFS47_UART_TypeDef *)FM3_MFS5_UART_BASE)
#define FM3_MFS5_CSIO   ((FM3_MFS47_CSIO_TypeDef *)FM3_MFS5_CSIO_BASE)
#define FM3_MFS5_LIN    ((FM3_MFS47_LIN_TypeDef *)FM3_MFS5_LIN_BASE)
#define FM3_MFS5_I2C    ((FM3_MFS47_I2C_TypeDef *)FM3_MFS5_I2C_BASE)
#define FM3_MFS6_UART   ((FM3_MFS47_UART_TypeDef *)FM3_MFS6_UART_BASE)
#define FM3_MFS6_CSIO   ((FM3_MFS47_CSIO_TypeDef *)FM3_MFS6_CSIO_BASE)
#define FM3_MFS6_LIN    ((FM3_MFS47_LIN_TypeDef *)FM3_MFS6_LIN_BASE)
#define FM3_MFS6_I2C    ((FM3_MFS47_I2C_TypeDef *)FM3_MFS6_I2C_BASE)
#define FM3_MFS7_UART   ((FM3_MFS47_UART_TypeDef *)FM3_MFS7_UART_BASE)
#define FM3_MFS7_CSIO   ((FM3_MFS47_CSIO_TypeDef *)FM3_MFS7_CSIO_BASE)
#define FM3_MFS7_LIN    ((FM3_MFS47_LIN_TypeDef *)FM3_MFS7_LIN_BASE)
#define FM3_MFS7_I2C    ((FM3_MFS47_I2C_TypeDef *)FM3_MFS7_I2C_BASE)
#define FM3_MFS_NFC     ((FM3_MFS_NFC_TypeDef *)FM3_MFS_NFC_BASE)
#define FM3_CRC         ((FM3_CRC_TypeDef *)FM3_CRC_BASE)
#define FM3_WC          ((FM3_WC_TypeDef *)FM3_WC_BASE)
#define FM3_EXBUS       ((FM3_EXBUS_TypeDef *)FM3_EXBUS_BASE)
#define FM3_USB0        ((FM3_USB_TypeDef *)FM3_USB0_BASE)
#define FM3_USB1        ((FM3_USB_TypeDef *)FM3_USB1_BASE)
#define FM3_DMAC        ((FM3_DMAC_TypeDef *)FM3_DMAC_BASE)
#define FM3_CAN0        ((FM3_CAN_TypeDef *)FM3_CAN0_BASE)
#define FM3_CAN1        ((FM3_CAN_TypeDef *)FM3_CAN1_BASE)
#define FM3_ETHERNET_MAC0    ((FM3_ETHERNET_MAC_TypeDef *)FM3_ETHERNET_MAC0_BASE)
#define FM3_ETHERNET_CONTROL ((FM3_ETHERNET_CONTROL_TypeDef *)FM3_ETHERNET_CONTROL_BASE)
#define FM3_ETHERNET_MAC1    ((FM3_ETHERNET_MAC_TypeDef *)FM3_ETHERNET_MAC1_BASE)

/******************************************************************************
 * Peripheral Bit Band Alias declaration
 ******************************************************************************/

/* Flash interface registers */
#define bFM3_FLASH_IF_FASZR_ASZ0               *((volatile unsigned int*)(0x42000000UL))
#define bFM3_FLASH_IF_FASZR_ASZ1               *((volatile unsigned int*)(0x42000004UL))
#define bFM3_FLASH_IF_FRWTR_RWT0               *((volatile unsigned int*)(0x42000080UL))
#define bFM3_FLASH_IF_FRWTR_RWT1               *((volatile unsigned int*)(0x42000084UL))
#define bFM3_FLASH_IF_FSTR_RDY                 *((volatile unsigned int*)(0x42000100UL))
#define bFM3_FLASH_IF_FSTR_HNG                 *((volatile unsigned int*)(0x42000104UL))
#define bFM3_FLASH_IF_FSTR_EER                 *((volatile unsigned int*)(0x42000108UL))
#define bFM3_FLASH_IF_FSYNDN_SD0               *((volatile unsigned int*)(0x42000200UL))
#define bFM3_FLASH_IF_FSYNDN_SD1               *((volatile unsigned int*)(0x42000204UL))
#define bFM3_FLASH_IF_FSYNDN_SD2               *((volatile unsigned int*)(0x42000208UL))
#define bFM3_FLASH_IF_FBFCR_BE                 *((volatile unsigned int*)(0x42000280UL))
#define bFM3_FLASH_IF_FBFCR_BS                 *((volatile unsigned int*)(0x42000284UL))
#define bFM3_FLASH_IF_CRTRMM_TRMM0             *((volatile unsigned int*)(0x42002000UL))
#define bFM3_FLASH_IF_CRTRMM_TRMM1             *((volatile unsigned int*)(0x42002004UL))
#define bFM3_FLASH_IF_CRTRMM_TRMM2             *((volatile unsigned int*)(0x42002008UL))
#define bFM3_FLASH_IF_CRTRMM_TRMM3             *((volatile unsigned int*)(0x4200200CUL))
#define bFM3_FLASH_IF_CRTRMM_TRMM4             *((volatile unsigned int*)(0x42002010UL))
#define bFM3_FLASH_IF_CRTRMM_TRMM5             *((volatile unsigned int*)(0x42002014UL))
#define bFM3_FLASH_IF_CRTRMM_TRMM6             *((volatile unsigned int*)(0x42002018UL))
#define bFM3_FLASH_IF_CRTRMM_TRMM7             *((volatile unsigned int*)(0x4200201CUL))
#define bFM3_FLASH_IF_CRTRMM_TRMM8             *((volatile unsigned int*)(0x42002020UL))
#define bFM3_FLASH_IF_CRTRMM_TRMM9             *((volatile unsigned int*)(0x42002024UL))

/* Clock and reset registers */
#define bFM3_CRG_SCM_CTL_MOSCE                 *((volatile unsigned int*)(0x42200004UL))
#define bFM3_CRG_SCM_CTL_SOSCE                 *((volatile unsigned int*)(0x4220000CUL))
#define bFM3_CRG_SCM_CTL_PLLE                  *((volatile unsigned int*)(0x42200010UL))
#define bFM3_CRG_SCM_CTL_RCS0                  *((volatile unsigned int*)(0x42200014UL))
#define bFM3_CRG_SCM_CTL_RCS1                  *((volatile unsigned int*)(0x42200018UL))
#define bFM3_CRG_SCM_CTL_RCS2                  *((volatile unsigned int*)(0x4220001CUL))
#define bFM3_CRG_SCM_STR_MORDY                 *((volatile unsigned int*)(0x42200084UL))
#define bFM3_CRG_SCM_STR_SORDY                 *((volatile unsigned int*)(0x4220008CUL))
#define bFM3_CRG_SCM_STR_PLRDY                 *((volatile unsigned int*)(0x42200090UL))
#define bFM3_CRG_SCM_STR_RCM0                  *((volatile unsigned int*)(0x42200094UL))
#define bFM3_CRG_SCM_STR_RCM1                  *((volatile unsigned int*)(0x42200098UL))
#define bFM3_CRG_SCM_STR_RCM2                  *((volatile unsigned int*)(0x4220009CUL))
#define bFM3_CRG_RST_STR_PONR                  *((volatile unsigned int*)(0x42200180UL))
#define bFM3_CRG_RST_STR_INITX                 *((volatile unsigned int*)(0x42200184UL))
#define bFM3_CRG_RST_STR_SWDT                  *((volatile unsigned int*)(0x42200190UL))
#define bFM3_CRG_RST_STR_HWDT                  *((volatile unsigned int*)(0x42200194UL))
#define bFM3_CRG_RST_STR_CSVR                  *((volatile unsigned int*)(0x42200198UL))
#define bFM3_CRG_RST_STR_FCSR                  *((volatile unsigned int*)(0x4220019CUL))
#define bFM3_CRG_RST_STR_SRST                  *((volatile unsigned int*)(0x422001A0UL))
#define bFM3_CRG_BSC_PSR_BSR0                  *((volatile unsigned int*)(0x42200200UL))
#define bFM3_CRG_BSC_PSR_BSR1                  *((volatile unsigned int*)(0x42200204UL))
#define bFM3_CRG_BSC_PSR_BSR2                  *((volatile unsigned int*)(0x42200208UL))
#define bFM3_CRG_APBC0_PSR_APBC00              *((volatile unsigned int*)(0x42200280UL))
#define bFM3_CRG_APBC0_PSR_APBC01              *((volatile unsigned int*)(0x42200284UL))
#define bFM3_CRG_APBC1_PSR_APBC10              *((volatile unsigned int*)(0x42200300UL))
#define bFM3_CRG_APBC1_PSR_APBC11              *((volatile unsigned int*)(0x42200304UL))
#define bFM3_CRG_APBC1_PSR_APBC1RST            *((volatile unsigned int*)(0x42200310UL))
#define bFM3_CRG_APBC1_PSR_APBC1EN             *((volatile unsigned int*)(0x4220031CUL))
#define bFM3_CRG_APBC2_PSR_APBC20              *((volatile unsigned int*)(0x42200380UL))
#define bFM3_CRG_APBC2_PSR_APBC21              *((volatile unsigned int*)(0x42200384UL))
#define bFM3_CRG_APBC2_PSR_APBC2RST            *((volatile unsigned int*)(0x42200390UL))
#define bFM3_CRG_APBC2_PSR_APBC2EN             *((volatile unsigned int*)(0x4220039CUL))
#define bFM3_CRG_SWC_PSR_SWDS0                 *((volatile unsigned int*)(0x42200400UL))
#define bFM3_CRG_SWC_PSR_SWDS1                 *((volatile unsigned int*)(0x42200404UL))
#define bFM3_CRG_SWC_PSR_TESTB                 *((volatile unsigned int*)(0x4220041CUL))
#define bFM3_CRG_TTC_PSR_TTC0                  *((volatile unsigned int*)(0x42200500UL))
#define bFM3_CRG_TTC_PSR_TTC1                  *((volatile unsigned int*)(0x42200504UL))
#define bFM3_CRG_CSW_TMR_MOWT0                 *((volatile unsigned int*)(0x42200600UL))
#define bFM3_CRG_CSW_TMR_MOWT1                 *((volatile unsigned int*)(0x42200604UL))
#define bFM3_CRG_CSW_TMR_MOWT2                 *((volatile unsigned int*)(0x42200608UL))
#define bFM3_CRG_CSW_TMR_MOWT3                 *((volatile unsigned int*)(0x4220060CUL))
#define bFM3_CRG_CSW_TMR_SOWT0                 *((volatile unsigned int*)(0x42200610UL))
#define bFM3_CRG_CSW_TMR_SOWT1                 *((volatile unsigned int*)(0x42200614UL))
#define bFM3_CRG_CSW_TMR_SOWT2                 *((volatile unsigned int*)(0x42200618UL))
#define bFM3_CRG_PSW_TMR_POWT0                 *((volatile unsigned int*)(0x42200680UL))
#define bFM3_CRG_PSW_TMR_POWT1                 *((volatile unsigned int*)(0x42200684UL))
#define bFM3_CRG_PSW_TMR_POWT2                 *((volatile unsigned int*)(0x42200688UL))
#define bFM3_CRG_PSW_TMR_PINC                  *((volatile unsigned int*)(0x42200690UL))
#define bFM3_CRG_PLL_CTL1_PLLM0                *((volatile unsigned int*)(0x42200700UL))
#define bFM3_CRG_PLL_CTL1_PLLM1                *((volatile unsigned int*)(0x42200704UL))
#define bFM3_CRG_PLL_CTL1_PLLM2                *((volatile unsigned int*)(0x42200708UL))
#define bFM3_CRG_PLL_CTL1_PLLM3                *((volatile unsigned int*)(0x4220070CUL))
#define bFM3_CRG_PLL_CTL1_PLLK0                *((volatile unsigned int*)(0x42200710UL))
#define bFM3_CRG_PLL_CTL1_PLLK1                *((volatile unsigned int*)(0x42200714UL))
#define bFM3_CRG_PLL_CTL1_PLLK2                *((volatile unsigned int*)(0x42200718UL))
#define bFM3_CRG_PLL_CTL1_PLLK3                *((volatile unsigned int*)(0x4220071CUL))
#define bFM3_CRG_PLL_CTL2_PLLN0                *((volatile unsigned int*)(0x42200780UL))
#define bFM3_CRG_PLL_CTL2_PLLN1                *((volatile unsigned int*)(0x42200784UL))
#define bFM3_CRG_PLL_CTL2_PLLN2                *((volatile unsigned int*)(0x42200788UL))
#define bFM3_CRG_PLL_CTL2_PLLN3                *((volatile unsigned int*)(0x4220078CUL))
#define bFM3_CRG_PLL_CTL2_PLLN4                *((volatile unsigned int*)(0x42200790UL))
#define bFM3_CRG_PLL_CTL2_PLLN5                *((volatile unsigned int*)(0x42200794UL))
#define bFM3_CRG_CSV_CTL_MCSVE                 *((volatile unsigned int*)(0x42200800UL))
#define bFM3_CRG_CSV_CTL_SCSVE                 *((volatile unsigned int*)(0x42200804UL))
#define bFM3_CRG_CSV_CTL_FCSDE                 *((volatile unsigned int*)(0x42200820UL))
#define bFM3_CRG_CSV_CTL_FCSRE                 *((volatile unsigned int*)(0x42200824UL))
#define bFM3_CRG_CSV_CTL_FCD0                  *((volatile unsigned int*)(0x42200830UL))
#define bFM3_CRG_CSV_CTL_FCD1                  *((volatile unsigned int*)(0x42200834UL))
#define bFM3_CRG_CSV_CTL_FCD2                  *((volatile unsigned int*)(0x42200838UL))
#define bFM3_CRG_CSV_STR_MCMF                  *((volatile unsigned int*)(0x42200880UL))
#define bFM3_CRG_CSV_STR_SCMF                  *((volatile unsigned int*)(0x42200884UL))
#define bFM3_CRG_DBWDT_CTL_DPSWBE              *((volatile unsigned int*)(0x42200A94UL))
#define bFM3_CRG_DBWDT_CTL_DPHWBE              *((volatile unsigned int*)(0x42200A9CUL))
#define bFM3_CRG_INT_ENR_MCSE                  *((volatile unsigned int*)(0x42200C00UL))
#define bFM3_CRG_INT_ENR_SCSE                  *((volatile unsigned int*)(0x42200C04UL))
#define bFM3_CRG_INT_ENR_PCSE                  *((volatile unsigned int*)(0x42200C08UL))
#define bFM3_CRG_INT_ENR_FCSE                  *((volatile unsigned int*)(0x42200C14UL))
#define bFM3_CRG_INT_STR_MCSI                  *((volatile unsigned int*)(0x42200C80UL))
#define bFM3_CRG_INT_STR_SCSI                  *((volatile unsigned int*)(0x42200C84UL))
#define bFM3_CRG_INT_STR_PCSI                  *((volatile unsigned int*)(0x42200C88UL))
#define bFM3_CRG_INT_STR_FCSI                  *((volatile unsigned int*)(0x42200C94UL))
#define bFM3_CRG_INT_CLR_MCSC                  *((volatile unsigned int*)(0x42200D00UL))
#define bFM3_CRG_INT_CLR_SCSC                  *((volatile unsigned int*)(0x42200D04UL))
#define bFM3_CRG_INT_CLR_PCSC                  *((volatile unsigned int*)(0x42200D08UL))
#define bFM3_CRG_INT_CLR_FCSC                  *((volatile unsigned int*)(0x42200D14UL))

/* Hardware watchdog registers */
#define bFM3_HWWDT_WDG_CTL_INTEN               *((volatile unsigned int*)(0x42220100UL))
#define bFM3_HWWDT_WDG_CTL_RESEN               *((volatile unsigned int*)(0x42220104UL))
#define bFM3_HWWDT_WDG_RIS_RIS                 *((volatile unsigned int*)(0x42220200UL))

/* Software watchdog registers */
#define bFM3_SWWDT_WDOGCONTROL_INTEN           *((volatile unsigned int*)(0x42240100UL))
#define bFM3_SWWDT_WDOGCONTROL_RESEN           *((volatile unsigned int*)(0x42240104UL))
#define bFM3_SWWDT_WDOGRIS_RIS                 *((volatile unsigned int*)(0x42240200UL))

/* Dual timer 1/2 registers */
#define bFM3_DTIM_TIMER1CONTROL_ONESHOT        *((volatile unsigned int*)(0x422A0100UL))
#define bFM3_DTIM_TIMER1CONTROL_TIMERSIZE      *((volatile unsigned int*)(0x422A0104UL))
#define bFM3_DTIM_TIMER1CONTROL_TIMERPRE0      *((volatile unsigned int*)(0x422A0108UL))
#define bFM3_DTIM_TIMER1CONTROL_TIMERPRE1      *((volatile unsigned int*)(0x422A010CUL))
#define bFM3_DTIM_TIMER1CONTROL_INTENABLE      *((volatile unsigned int*)(0x422A0114UL))
#define bFM3_DTIM_TIMER1CONTROL_TIMERMODE      *((volatile unsigned int*)(0x422A0118UL))
#define bFM3_DTIM_TIMER1CONTROL_TIMEREN        *((volatile unsigned int*)(0x422A011CUL))
#define bFM3_DTIM_TIMER1RIS_TIMER1RIS          *((volatile unsigned int*)(0x422A0200UL))
#define bFM3_DTIM_TIMER1MIS_TIMER1MIS          *((volatile unsigned int*)(0x422A0280UL))
#define bFM3_DTIM_TIMER2CONTROL_ONESHOT        *((volatile unsigned int*)(0x422A0500UL))
#define bFM3_DTIM_TIMER2CONTROL_TIMERSIZE      *((volatile unsigned int*)(0x422A0504UL))
#define bFM3_DTIM_TIMER2CONTROL_TIMERPRE0      *((volatile unsigned int*)(0x422A0508UL))
#define bFM3_DTIM_TIMER2CONTROL_TIMERPRE1      *((volatile unsigned int*)(0x422A050CUL))
#define bFM3_DTIM_TIMER2CONTROL_INTENABLE      *((volatile unsigned int*)(0x422A0514UL))
#define bFM3_DTIM_TIMER2CONTROL_TIMERMODE      *((volatile unsigned int*)(0x422A0518UL))
#define bFM3_DTIM_TIMER2CONTROL_TIMEREN        *((volatile unsigned int*)(0x422A051CUL))
#define bFM3_DTIM_TIMER2RIS_TIMER2RIS          *((volatile unsigned int*)(0x422A0600UL))
#define bFM3_DTIM_TIMER2MIS_TIMER2MIS          *((volatile unsigned int*)(0x422A0680UL))

/* Multifunction Timer unit 0 Free Running Timer registers */
#define bFM3_MFT0_FRT_TCSA0_CLK0               *((volatile unsigned int*)(0x42400600UL))
#define bFM3_MFT0_FRT_TCSA0_CLK1               *((volatile unsigned int*)(0x42400604UL))
#define bFM3_MFT0_FRT_TCSA0_CLK2               *((volatile unsigned int*)(0x42400608UL))
#define bFM3_MFT0_FRT_TCSA0_CLK3               *((volatile unsigned int*)(0x4240060CUL))
#define bFM3_MFT0_FRT_TCSA0_SCLR               *((volatile unsigned int*)(0x42400610UL))
#define bFM3_MFT0_FRT_TCSA0_MODE               *((volatile unsigned int*)(0x42400614UL))
#define bFM3_MFT0_FRT_TCSA0_STOP               *((volatile unsigned int*)(0x42400618UL))
#define bFM3_MFT0_FRT_TCSA0_BFE                *((volatile unsigned int*)(0x4240061CUL))
#define bFM3_MFT0_FRT_TCSA0_ICRE               *((volatile unsigned int*)(0x42400620UL))
#define bFM3_MFT0_FRT_TCSA0_ICLR               *((volatile unsigned int*)(0x42400624UL))
#define bFM3_MFT0_FRT_TCSA0_IRQZE              *((volatile unsigned int*)(0x42400634UL))
#define bFM3_MFT0_FRT_TCSA0_IRQZF              *((volatile unsigned int*)(0x42400638UL))
#define bFM3_MFT0_FRT_TCSA0_ECKE               *((volatile unsigned int*)(0x4240063CUL))
#define bFM3_MFT0_FRT_TCSB0_AD0E               *((volatile unsigned int*)(0x42400680UL))
#define bFM3_MFT0_FRT_TCSB0_AD1E               *((volatile unsigned int*)(0x42400684UL))
#define bFM3_MFT0_FRT_TCSB0_AD2E               *((volatile unsigned int*)(0x42400688UL))
#define bFM3_MFT0_FRT_TCSA1_CLK0               *((volatile unsigned int*)(0x42400800UL))
#define bFM3_MFT0_FRT_TCSA1_CLK1               *((volatile unsigned int*)(0x42400804UL))
#define bFM3_MFT0_FRT_TCSA1_CLK2               *((volatile unsigned int*)(0x42400808UL))
#define bFM3_MFT0_FRT_TCSA1_CLK3               *((volatile unsigned int*)(0x4240080CUL))
#define bFM3_MFT0_FRT_TCSA1_SCLR               *((volatile unsigned int*)(0x42400810UL))
#define bFM3_MFT0_FRT_TCSA1_MODE               *((volatile unsigned int*)(0x42400814UL))
#define bFM3_MFT0_FRT_TCSA1_STOP               *((volatile unsigned int*)(0x42400818UL))
#define bFM3_MFT0_FRT_TCSA1_BFE                *((volatile unsigned int*)(0x4240081CUL))
#define bFM3_MFT0_FRT_TCSA1_ICRE               *((volatile unsigned int*)(0x42400820UL))
#define bFM3_MFT0_FRT_TCSA1_ICLR               *((volatile unsigned int*)(0x42400824UL))
#define bFM3_MFT0_FRT_TCSA1_IRQZE              *((volatile unsigned int*)(0x42400834UL))
#define bFM3_MFT0_FRT_TCSA1_IRQZF              *((volatile unsigned int*)(0x42400838UL))
#define bFM3_MFT0_FRT_TCSA1_ECKE               *((volatile unsigned int*)(0x4240083CUL))
#define bFM3_MFT0_FRT_TCSB1_AD0E               *((volatile unsigned int*)(0x42400880UL))
#define bFM3_MFT0_FRT_TCSB1_AD1E               *((volatile unsigned int*)(0x42400884UL))
#define bFM3_MFT0_FRT_TCSB1_AD2E               *((volatile unsigned int*)(0x42400888UL))
#define bFM3_MFT0_FRT_TCSA2_CLK0               *((volatile unsigned int*)(0x42400A00UL))
#define bFM3_MFT0_FRT_TCSA2_CLK1               *((volatile unsigned int*)(0x42400A04UL))
#define bFM3_MFT0_FRT_TCSA2_CLK2               *((volatile unsigned int*)(0x42400A08UL))
#define bFM3_MFT0_FRT_TCSA2_CLK3               *((volatile unsigned int*)(0x42400A0CUL))
#define bFM3_MFT0_FRT_TCSA2_SCLR               *((volatile unsigned int*)(0x42400A10UL))
#define bFM3_MFT0_FRT_TCSA2_MODE               *((volatile unsigned int*)(0x42400A14UL))
#define bFM3_MFT0_FRT_TCSA2_STOP               *((volatile unsigned int*)(0x42400A18UL))
#define bFM3_MFT0_FRT_TCSA2_BFE                *((volatile unsigned int*)(0x42400A1CUL))
#define bFM3_MFT0_FRT_TCSA2_ICRE               *((volatile unsigned int*)(0x42400A20UL))
#define bFM3_MFT0_FRT_TCSA2_ICLR               *((volatile unsigned int*)(0x42400A24UL))
#define bFM3_MFT0_FRT_TCSA2_IRQZE              *((volatile unsigned int*)(0x42400A34UL))
#define bFM3_MFT0_FRT_TCSA2_IRQZF              *((volatile unsigned int*)(0x42400A38UL))
#define bFM3_MFT0_FRT_TCSA2_ECKE               *((volatile unsigned int*)(0x42400A3CUL))
#define bFM3_MFT0_FRT_TCSB2_AD0E               *((volatile unsigned int*)(0x42400A80UL))
#define bFM3_MFT0_FRT_TCSB2_AD1E               *((volatile unsigned int*)(0x42400A84UL))
#define bFM3_MFT0_FRT_TCSB2_AD2E               *((volatile unsigned int*)(0x42400A88UL))

/* Multifunction Timer unit 0 Output Compare Unit registers */
#define bFM3_MFT0_OCU_OCSA10_CST0              *((volatile unsigned int*)(0x42400300UL))
#define bFM3_MFT0_OCU_OCSA10_CST1              *((volatile unsigned int*)(0x42400304UL))
#define bFM3_MFT0_OCU_OCSA10_BDIS0             *((volatile unsigned int*)(0x42400308UL))
#define bFM3_MFT0_OCU_OCSA10_BDIS1             *((volatile unsigned int*)(0x4240030CUL))
#define bFM3_MFT0_OCU_OCSA10_IOE0              *((volatile unsigned int*)(0x42400310UL))
#define bFM3_MFT0_OCU_OCSA10_IOE1              *((volatile unsigned int*)(0x42400314UL))
#define bFM3_MFT0_OCU_OCSA10_IOP0              *((volatile unsigned int*)(0x42400318UL))
#define bFM3_MFT0_OCU_OCSA10_IOP1              *((volatile unsigned int*)(0x4240031CUL))
#define bFM3_MFT0_OCU_OCSB10_OTD0              *((volatile unsigned int*)(0x42400320UL))
#define bFM3_MFT0_OCU_OCSB10_OTD1              *((volatile unsigned int*)(0x42400324UL))
#define bFM3_MFT0_OCU_OCSB10_CMOD              *((volatile unsigned int*)(0x42400330UL))
#define bFM3_MFT0_OCU_OCSB10_BTS0              *((volatile unsigned int*)(0x42400334UL))
#define bFM3_MFT0_OCU_OCSB10_BTS1              *((volatile unsigned int*)(0x42400338UL))
#define bFM3_MFT0_OCU_OCSA32_CST2              *((volatile unsigned int*)(0x42400380UL))
#define bFM3_MFT0_OCU_OCSA32_CST3              *((volatile unsigned int*)(0x42400384UL))
#define bFM3_MFT0_OCU_OCSA32_BDIS2             *((volatile unsigned int*)(0x42400388UL))
#define bFM3_MFT0_OCU_OCSA32_BDIS3             *((volatile unsigned int*)(0x4240038CUL))
#define bFM3_MFT0_OCU_OCSA32_IOE2              *((volatile unsigned int*)(0x42400390UL))
#define bFM3_MFT0_OCU_OCSA32_IOE3              *((volatile unsigned int*)(0x42400394UL))
#define bFM3_MFT0_OCU_OCSA32_IOP2              *((volatile unsigned int*)(0x42400398UL))
#define bFM3_MFT0_OCU_OCSA32_IOP3              *((volatile unsigned int*)(0x4240039CUL))
#define bFM3_MFT0_OCU_OCSB32_OTD2              *((volatile unsigned int*)(0x424003A0UL))
#define bFM3_MFT0_OCU_OCSB32_OTD3              *((volatile unsigned int*)(0x424003A4UL))
#define bFM3_MFT0_OCU_OCSB32_CMOD              *((volatile unsigned int*)(0x424003B0UL))
#define bFM3_MFT0_OCU_OCSB32_BTS2              *((volatile unsigned int*)(0x424003B4UL))
#define bFM3_MFT0_OCU_OCSB32_BTS3              *((volatile unsigned int*)(0x424003B8UL))
#define bFM3_MFT0_OCU_OCSA54_CST4              *((volatile unsigned int*)(0x42400400UL))
#define bFM3_MFT0_OCU_OCSA54_CST5              *((volatile unsigned int*)(0x42400404UL))
#define bFM3_MFT0_OCU_OCSA54_BDIS4             *((volatile unsigned int*)(0x42400408UL))
#define bFM3_MFT0_OCU_OCSA54_BDIS5             *((volatile unsigned int*)(0x4240040CUL))
#define bFM3_MFT0_OCU_OCSA54_IOE4              *((volatile unsigned int*)(0x42400410UL))
#define bFM3_MFT0_OCU_OCSA54_IOE5              *((volatile unsigned int*)(0x42400414UL))
#define bFM3_MFT0_OCU_OCSA54_IOP4              *((volatile unsigned int*)(0x42400418UL))
#define bFM3_MFT0_OCU_OCSA54_IOP5              *((volatile unsigned int*)(0x4240041CUL))
#define bFM3_MFT0_OCU_OCSB54_OTD4              *((volatile unsigned int*)(0x42400420UL))
#define bFM3_MFT0_OCU_OCSB54_OTD5              *((volatile unsigned int*)(0x42400424UL))
#define bFM3_MFT0_OCU_OCSB54_CMOD              *((volatile unsigned int*)(0x42400430UL))
#define bFM3_MFT0_OCU_OCSB54_BTS4              *((volatile unsigned int*)(0x42400434UL))
#define bFM3_MFT0_OCU_OCSB54_BTS5              *((volatile unsigned int*)(0x42400438UL))
#define bFM3_MFT0_OCU_OCSC_MOD0                *((volatile unsigned int*)(0x424004A0UL))
#define bFM3_MFT0_OCU_OCSC_MOD1                *((volatile unsigned int*)(0x424004A4UL))
#define bFM3_MFT0_OCU_OCSC_MOD2                *((volatile unsigned int*)(0x424004A8UL))
#define bFM3_MFT0_OCU_OCSC_MOD3                *((volatile unsigned int*)(0x424004ACUL))
#define bFM3_MFT0_OCU_OCSC_MOD4                *((volatile unsigned int*)(0x424004B0UL))
#define bFM3_MFT0_OCU_OCSC_MOD5                *((volatile unsigned int*)(0x424004B4UL))
#define bFM3_MFT0_OCU_OCFS10_FSO00             *((volatile unsigned int*)(0x42400B00UL))
#define bFM3_MFT0_OCU_OCFS10_FSO01             *((volatile unsigned int*)(0x42400B04UL))
#define bFM3_MFT0_OCU_OCFS10_FSO02             *((volatile unsigned int*)(0x42400B08UL))
#define bFM3_MFT0_OCU_OCFS10_FSO03             *((volatile unsigned int*)(0x42400B0CUL))
#define bFM3_MFT0_OCU_OCFS10_FSO10             *((volatile unsigned int*)(0x42400B10UL))
#define bFM3_MFT0_OCU_OCFS10_FSO11             *((volatile unsigned int*)(0x42400B14UL))
#define bFM3_MFT0_OCU_OCFS10_FSO12             *((volatile unsigned int*)(0x42400B18UL))
#define bFM3_MFT0_OCU_OCFS10_FSO13             *((volatile unsigned int*)(0x42400B1CUL))
#define bFM3_MFT0_OCU_OCFS32_FSO20             *((volatile unsigned int*)(0x42400B20UL))
#define bFM3_MFT0_OCU_OCFS32_FSO21             *((volatile unsigned int*)(0x42400B24UL))
#define bFM3_MFT0_OCU_OCFS32_FSO22             *((volatile unsigned int*)(0x42400B28UL))
#define bFM3_MFT0_OCU_OCFS32_FSO23             *((volatile unsigned int*)(0x42400B2CUL))
#define bFM3_MFT0_OCU_OCFS32_FSO30             *((volatile unsigned int*)(0x42400B30UL))
#define bFM3_MFT0_OCU_OCFS32_FSO31             *((volatile unsigned int*)(0x42400B34UL))
#define bFM3_MFT0_OCU_OCFS32_FSO32             *((volatile unsigned int*)(0x42400B38UL))
#define bFM3_MFT0_OCU_OCFS32_FSO33             *((volatile unsigned int*)(0x42400B3CUL))
#define bFM3_MFT0_OCU_OCFS54_FSO40             *((volatile unsigned int*)(0x42400B80UL))
#define bFM3_MFT0_OCU_OCFS54_FSO41             *((volatile unsigned int*)(0x42400B84UL))
#define bFM3_MFT0_OCU_OCFS54_FSO42             *((volatile unsigned int*)(0x42400B88UL))
#define bFM3_MFT0_OCU_OCFS54_FSO43             *((volatile unsigned int*)(0x42400B8CUL))
#define bFM3_MFT0_OCU_OCFS54_FSO50             *((volatile unsigned int*)(0x42400B90UL))
#define bFM3_MFT0_OCU_OCFS54_FSO51             *((volatile unsigned int*)(0x42400B94UL))
#define bFM3_MFT0_OCU_OCFS54_FSO52             *((volatile unsigned int*)(0x42400B98UL))
#define bFM3_MFT0_OCU_OCFS54_FSO53             *((volatile unsigned int*)(0x42400B9CUL))

/* Multifunction Timer unit 0 Waveform Generator and Noise Canceler registers */
#define bFM3_MFT0_WFG_WFSA10_DCK0              *((volatile unsigned int*)(0x42401180UL))
#define bFM3_MFT0_WFG_WFSA10_DCK1              *((volatile unsigned int*)(0x42401184UL))
#define bFM3_MFT0_WFG_WFSA10_DCK2              *((volatile unsigned int*)(0x42401188UL))
#define bFM3_MFT0_WFG_WFSA10_GTEN0             *((volatile unsigned int*)(0x42401198UL))
#define bFM3_MFT0_WFG_WFSA10_GTEN1             *((volatile unsigned int*)(0x4240119CUL))
#define bFM3_MFT0_WFG_WFSA10_PSEL0             *((volatile unsigned int*)(0x424011A0UL))
#define bFM3_MFT0_WFG_WFSA10_PSEL1             *((volatile unsigned int*)(0x424011A4UL))
#define bFM3_MFT0_WFG_WFSA10_PGEN0             *((volatile unsigned int*)(0x424011A8UL))
#define bFM3_MFT0_WFG_WFSA10_PGEN1             *((volatile unsigned int*)(0x424011ACUL))
#define bFM3_MFT0_WFG_WFSA10_DMOD              *((volatile unsigned int*)(0x424011B0UL))
#define bFM3_MFT0_WFG_WFSA32_DCK0              *((volatile unsigned int*)(0x42401200UL))
#define bFM3_MFT0_WFG_WFSA32_DCK1              *((volatile unsigned int*)(0x42401204UL))
#define bFM3_MFT0_WFG_WFSA32_DCK2              *((volatile unsigned int*)(0x42401208UL))
#define bFM3_MFT0_WFG_WFSA32_GTEN0             *((volatile unsigned int*)(0x42401218UL))
#define bFM3_MFT0_WFG_WFSA32_GTEN1             *((volatile unsigned int*)(0x4240121CUL))
#define bFM3_MFT0_WFG_WFSA32_PSEL0             *((volatile unsigned int*)(0x42401220UL))
#define bFM3_MFT0_WFG_WFSA32_PSEL1             *((volatile unsigned int*)(0x42401224UL))
#define bFM3_MFT0_WFG_WFSA32_PGEN0             *((volatile unsigned int*)(0x42401228UL))
#define bFM3_MFT0_WFG_WFSA32_PGEN1             *((volatile unsigned int*)(0x4240122CUL))
#define bFM3_MFT0_WFG_WFSA32_DMOD              *((volatile unsigned int*)(0x42401230UL))
#define bFM3_MFT0_WFG_WFSA54_DCK0              *((volatile unsigned int*)(0x42401280UL))
#define bFM3_MFT0_WFG_WFSA54_DCK1              *((volatile unsigned int*)(0x42401284UL))
#define bFM3_MFT0_WFG_WFSA54_DCK2              *((volatile unsigned int*)(0x42401288UL))
#define bFM3_MFT0_WFG_WFSA54_GTEN0             *((volatile unsigned int*)(0x42401298UL))
#define bFM3_MFT0_WFG_WFSA54_GTEN1             *((volatile unsigned int*)(0x4240129CUL))
#define bFM3_MFT0_WFG_WFSA54_PSEL0             *((volatile unsigned int*)(0x424012A0UL))
#define bFM3_MFT0_WFG_WFSA54_PSEL1             *((volatile unsigned int*)(0x424012A4UL))
#define bFM3_MFT0_WFG_WFSA54_PGEN0             *((volatile unsigned int*)(0x424012A8UL))
#define bFM3_MFT0_WFG_WFSA54_PGEN1             *((volatile unsigned int*)(0x424012ACUL))
#define bFM3_MFT0_WFG_WFSA54_DMOD              *((volatile unsigned int*)(0x424012B0UL))
#define bFM3_MFT0_WFG_WFIR_DTIF                *((volatile unsigned int*)(0x42401300UL))
#define bFM3_MFT0_WFG_WFIR_DTIC                *((volatile unsigned int*)(0x42401304UL))
#define bFM3_MFT0_WFG_WFIR_TMIF10              *((volatile unsigned int*)(0x42401310UL))
#define bFM3_MFT0_WFG_WFIR_TMIC10              *((volatile unsigned int*)(0x42401314UL))
#define bFM3_MFT0_WFG_WFIR_TMIE10              *((volatile unsigned int*)(0x42401318UL))
#define bFM3_MFT0_WFG_WFIR_TMIS10              *((volatile unsigned int*)(0x4240131CUL))
#define bFM3_MFT0_WFG_WFIR_TMIF32              *((volatile unsigned int*)(0x42401320UL))
#define bFM3_MFT0_WFG_WFIR_TMIC32              *((volatile unsigned int*)(0x42401324UL))
#define bFM3_MFT0_WFG_WFIR_TMIE32              *((volatile unsigned int*)(0x42401328UL))
#define bFM3_MFT0_WFG_WFIR_TMIS32              *((volatile unsigned int*)(0x4240132CUL))
#define bFM3_MFT0_WFG_WFIR_TMIF54              *((volatile unsigned int*)(0x42401330UL))
#define bFM3_MFT0_WFG_WFIR_TMIC54              *((volatile unsigned int*)(0x42401334UL))
#define bFM3_MFT0_WFG_WFIR_TMIE54              *((volatile unsigned int*)(0x42401338UL))
#define bFM3_MFT0_WFG_WFIR_TMIS54              *((volatile unsigned int*)(0x4240133CUL))
#define bFM3_MFT0_WFG_NZCL_DTIE                *((volatile unsigned int*)(0x42401380UL))
#define bFM3_MFT0_WFG_NZCL_NWS0                *((volatile unsigned int*)(0x42401384UL))
#define bFM3_MFT0_WFG_NZCL_NWS1                *((volatile unsigned int*)(0x42401388UL))
#define bFM3_MFT0_WFG_NZCL_NWS2                *((volatile unsigned int*)(0x4240138CUL))
#define bFM3_MFT0_WFG_NZCL_SDTI                *((volatile unsigned int*)(0x42401390UL))

/* Multifunction Timer unit 0 Input Capture Unit registers */
#define bFM3_MFT0_ICU_ICFS10_FSI00             *((volatile unsigned int*)(0x42400C00UL))
#define bFM3_MFT0_ICU_ICFS10_FSI01             *((volatile unsigned int*)(0x42400C04UL))
#define bFM3_MFT0_ICU_ICFS10_FSI02             *((volatile unsigned int*)(0x42400C08UL))
#define bFM3_MFT0_ICU_ICFS10_FSI03             *((volatile unsigned int*)(0x42400C0CUL))
#define bFM3_MFT0_ICU_ICFS10_FSI10             *((volatile unsigned int*)(0x42400C10UL))
#define bFM3_MFT0_ICU_ICFS10_FSI11             *((volatile unsigned int*)(0x42400C14UL))
#define bFM3_MFT0_ICU_ICFS10_FSI12             *((volatile unsigned int*)(0x42400C18UL))
#define bFM3_MFT0_ICU_ICFS10_FSI13             *((volatile unsigned int*)(0x42400C1CUL))
#define bFM3_MFT0_ICU_ICFS32_FSI20             *((volatile unsigned int*)(0x42400C20UL))
#define bFM3_MFT0_ICU_ICFS32_FSI21             *((volatile unsigned int*)(0x42400C24UL))
#define bFM3_MFT0_ICU_ICFS32_FSI22             *((volatile unsigned int*)(0x42400C28UL))
#define bFM3_MFT0_ICU_ICFS32_FSI23             *((volatile unsigned int*)(0x42400C2CUL))
#define bFM3_MFT0_ICU_ICFS32_FSI30             *((volatile unsigned int*)(0x42400C30UL))
#define bFM3_MFT0_ICU_ICFS32_FSI31             *((volatile unsigned int*)(0x42400C34UL))
#define bFM3_MFT0_ICU_ICFS32_FSI32             *((volatile unsigned int*)(0x42400C38UL))
#define bFM3_MFT0_ICU_ICFS32_FSI33             *((volatile unsigned int*)(0x42400C3CUL))
#define bFM3_MFT0_ICU_ICSA10_EG00              *((volatile unsigned int*)(0x42400F00UL))
#define bFM3_MFT0_ICU_ICSA10_EG01              *((volatile unsigned int*)(0x42400F04UL))
#define bFM3_MFT0_ICU_ICSA10_EG10              *((volatile unsigned int*)(0x42400F08UL))
#define bFM3_MFT0_ICU_ICSA10_EG11              *((volatile unsigned int*)(0x42400F0CUL))
#define bFM3_MFT0_ICU_ICSA10_ICE0              *((volatile unsigned int*)(0x42400F10UL))
#define bFM3_MFT0_ICU_ICSA10_ICE1              *((volatile unsigned int*)(0x42400F14UL))
#define bFM3_MFT0_ICU_ICSA10_ICP0              *((volatile unsigned int*)(0x42400F18UL))
#define bFM3_MFT0_ICU_ICSA10_ICP1              *((volatile unsigned int*)(0x42400F1CUL))
#define bFM3_MFT0_ICU_ICSB10_IEI0              *((volatile unsigned int*)(0x42400F20UL))
#define bFM3_MFT0_ICU_ICSB10_IEI1              *((volatile unsigned int*)(0x42400F24UL))
#define bFM3_MFT0_ICU_ICSA32_EG20              *((volatile unsigned int*)(0x42400F80UL))
#define bFM3_MFT0_ICU_ICSA32_EG21              *((volatile unsigned int*)(0x42400F84UL))
#define bFM3_MFT0_ICU_ICSA32_EG30              *((volatile unsigned int*)(0x42400F88UL))
#define bFM3_MFT0_ICU_ICSA32_EG31              *((volatile unsigned int*)(0x42400F8CUL))
#define bFM3_MFT0_ICU_ICSA32_ICE2              *((volatile unsigned int*)(0x42400F90UL))
#define bFM3_MFT0_ICU_ICSA32_ICE3              *((volatile unsigned int*)(0x42400F94UL))
#define bFM3_MFT0_ICU_ICSA32_ICP2              *((volatile unsigned int*)(0x42400F98UL))
#define bFM3_MFT0_ICU_ICSA32_ICP3              *((volatile unsigned int*)(0x42400F9CUL))
#define bFM3_MFT0_ICU_ICSB32_IEI2              *((volatile unsigned int*)(0x42400FA0UL))
#define bFM3_MFT0_ICU_ICSB32_IEI3              *((volatile unsigned int*)(0x42400FA4UL))

/* Multifunction Timer unit 0 ADC Start Compare Unit registers */
#define bFM3_MFT0_ADCMP_ACSB_BDIS0             *((volatile unsigned int*)(0x42401700UL))
#define bFM3_MFT0_ADCMP_ACSB_BDIS1             *((volatile unsigned int*)(0x42401704UL))
#define bFM3_MFT0_ADCMP_ACSB_BDIS2             *((volatile unsigned int*)(0x42401708UL))
#define bFM3_MFT0_ADCMP_ACSB_BTS0              *((volatile unsigned int*)(0x42401710UL))
#define bFM3_MFT0_ADCMP_ACSB_BTS1              *((volatile unsigned int*)(0x42401714UL))
#define bFM3_MFT0_ADCMP_ACSB_BTS2              *((volatile unsigned int*)(0x42401718UL))
#define bFM3_MFT0_ADCMP_ACSA_CE00              *((volatile unsigned int*)(0x42401780UL))
#define bFM3_MFT0_ADCMP_ACSA_CE01              *((volatile unsigned int*)(0x42401784UL))
#define bFM3_MFT0_ADCMP_ACSA_CE10              *((volatile unsigned int*)(0x42401788UL))
#define bFM3_MFT0_ADCMP_ACSA_CE11              *((volatile unsigned int*)(0x4240178CUL))
#define bFM3_MFT0_ADCMP_ACSA_CE20              *((volatile unsigned int*)(0x42401790UL))
#define bFM3_MFT0_ADCMP_ACSA_CE21              *((volatile unsigned int*)(0x42401794UL))
#define bFM3_MFT0_ADCMP_ACSA_SEL00             *((volatile unsigned int*)(0x424017A0UL))
#define bFM3_MFT0_ADCMP_ACSA_SEL01             *((volatile unsigned int*)(0x424017A4UL))
#define bFM3_MFT0_ADCMP_ACSA_SEL10             *((volatile unsigned int*)(0x424017A8UL))
#define bFM3_MFT0_ADCMP_ACSA_SEL11             *((volatile unsigned int*)(0x424017ACUL))
#define bFM3_MFT0_ADCMP_ACSA_SEL20             *((volatile unsigned int*)(0x424017B0UL))
#define bFM3_MFT0_ADCMP_ACSA_SEL21             *((volatile unsigned int*)(0x424017B4UL))
#define bFM3_MFT0_ADCMP_ATSA_AD0S0             *((volatile unsigned int*)(0x42401800UL))
#define bFM3_MFT0_ADCMP_ATSA_AD0S1             *((volatile unsigned int*)(0x42401804UL))
#define bFM3_MFT0_ADCMP_ATSA_AD1S0             *((volatile unsigned int*)(0x42401808UL))
#define bFM3_MFT0_ADCMP_ATSA_AD1S1             *((volatile unsigned int*)(0x4240180CUL))
#define bFM3_MFT0_ADCMP_ATSA_AD2S0             *((volatile unsigned int*)(0x42401810UL))
#define bFM3_MFT0_ADCMP_ATSA_AD2S1             *((volatile unsigned int*)(0x42401814UL))
#define bFM3_MFT0_ADCMP_ATSA_AD0P0             *((volatile unsigned int*)(0x42401820UL))
#define bFM3_MFT0_ADCMP_ATSA_AD0P1             *((volatile unsigned int*)(0x42401824UL))
#define bFM3_MFT0_ADCMP_ATSA_AD1P0             *((volatile unsigned int*)(0x42401828UL))
#define bFM3_MFT0_ADCMP_ATSA_AD1P1             *((volatile unsigned int*)(0x4240182CUL))
#define bFM3_MFT0_ADCMP_ATSA_AD2P0             *((volatile unsigned int*)(0x42401830UL))
#define bFM3_MFT0_ADCMP_ATSA_AD2P1             *((volatile unsigned int*)(0x42401834UL))

/* Multifunction Timer unit 1 Free Running Timer registers */
#define bFM3_MFT1_FRT_TCSA0_CLK0               *((volatile unsigned int*)(0x42420600UL))
#define bFM3_MFT1_FRT_TCSA0_CLK1               *((volatile unsigned int*)(0x42420604UL))
#define bFM3_MFT1_FRT_TCSA0_CLK2               *((volatile unsigned int*)(0x42420608UL))
#define bFM3_MFT1_FRT_TCSA0_CLK3               *((volatile unsigned int*)(0x4242060CUL))
#define bFM3_MFT1_FRT_TCSA0_SCLR               *((volatile unsigned int*)(0x42420610UL))
#define bFM3_MFT1_FRT_TCSA0_MODE               *((volatile unsigned int*)(0x42420614UL))
#define bFM3_MFT1_FRT_TCSA0_STOP               *((volatile unsigned int*)(0x42420618UL))
#define bFM3_MFT1_FRT_TCSA0_BFE                *((volatile unsigned int*)(0x4242061CUL))
#define bFM3_MFT1_FRT_TCSA0_ICRE               *((volatile unsigned int*)(0x42420620UL))
#define bFM3_MFT1_FRT_TCSA0_ICLR               *((volatile unsigned int*)(0x42420624UL))
#define bFM3_MFT1_FRT_TCSA0_IRQZE              *((volatile unsigned int*)(0x42420634UL))
#define bFM3_MFT1_FRT_TCSA0_IRQZF              *((volatile unsigned int*)(0x42420638UL))
#define bFM3_MFT1_FRT_TCSA0_ECKE               *((volatile unsigned int*)(0x4242063CUL))
#define bFM3_MFT1_FRT_TCSB0_AD0E               *((volatile unsigned int*)(0x42420680UL))
#define bFM3_MFT1_FRT_TCSB0_AD1E               *((volatile unsigned int*)(0x42420684UL))
#define bFM3_MFT1_FRT_TCSB0_AD2E               *((volatile unsigned int*)(0x42420688UL))
#define bFM3_MFT1_FRT_TCSA1_CLK0               *((volatile unsigned int*)(0x42420800UL))
#define bFM3_MFT1_FRT_TCSA1_CLK1               *((volatile unsigned int*)(0x42420804UL))
#define bFM3_MFT1_FRT_TCSA1_CLK2               *((volatile unsigned int*)(0x42420808UL))
#define bFM3_MFT1_FRT_TCSA1_CLK3               *((volatile unsigned int*)(0x4242080CUL))
#define bFM3_MFT1_FRT_TCSA1_SCLR               *((volatile unsigned int*)(0x42420810UL))
#define bFM3_MFT1_FRT_TCSA1_MODE               *((volatile unsigned int*)(0x42420814UL))
#define bFM3_MFT1_FRT_TCSA1_STOP               *((volatile unsigned int*)(0x42420818UL))
#define bFM3_MFT1_FRT_TCSA1_BFE                *((volatile unsigned int*)(0x4242081CUL))
#define bFM3_MFT1_FRT_TCSA1_ICRE               *((volatile unsigned int*)(0x42420820UL))
#define bFM3_MFT1_FRT_TCSA1_ICLR               *((volatile unsigned int*)(0x42420824UL))
#define bFM3_MFT1_FRT_TCSA1_IRQZE              *((volatile unsigned int*)(0x42420834UL))
#define bFM3_MFT1_FRT_TCSA1_IRQZF              *((volatile unsigned int*)(0x42420838UL))
#define bFM3_MFT1_FRT_TCSA1_ECKE               *((volatile unsigned int*)(0x4242083CUL))
#define bFM3_MFT1_FRT_TCSB1_AD0E               *((volatile unsigned int*)(0x42420880UL))
#define bFM3_MFT1_FRT_TCSB1_AD1E               *((volatile unsigned int*)(0x42420884UL))
#define bFM3_MFT1_FRT_TCSB1_AD2E               *((volatile unsigned int*)(0x42420888UL))
#define bFM3_MFT1_FRT_TCSA2_CLK0               *((volatile unsigned int*)(0x42420A00UL))
#define bFM3_MFT1_FRT_TCSA2_CLK1               *((volatile unsigned int*)(0x42420A04UL))
#define bFM3_MFT1_FRT_TCSA2_CLK2               *((volatile unsigned int*)(0x42420A08UL))
#define bFM3_MFT1_FRT_TCSA2_CLK3               *((volatile unsigned int*)(0x42420A0CUL))
#define bFM3_MFT1_FRT_TCSA2_SCLR               *((volatile unsigned int*)(0x42420A10UL))
#define bFM3_MFT1_FRT_TCSA2_MODE               *((volatile unsigned int*)(0x42420A14UL))
#define bFM3_MFT1_FRT_TCSA2_STOP               *((volatile unsigned int*)(0x42420A18UL))
#define bFM3_MFT1_FRT_TCSA2_BFE                *((volatile unsigned int*)(0x42420A1CUL))
#define bFM3_MFT1_FRT_TCSA2_ICRE               *((volatile unsigned int*)(0x42420A20UL))
#define bFM3_MFT1_FRT_TCSA2_ICLR               *((volatile unsigned int*)(0x42420A24UL))
#define bFM3_MFT1_FRT_TCSA2_IRQZE              *((volatile unsigned int*)(0x42420A34UL))
#define bFM3_MFT1_FRT_TCSA2_IRQZF              *((volatile unsigned int*)(0x42420A38UL))
#define bFM3_MFT1_FRT_TCSA2_ECKE               *((volatile unsigned int*)(0x42420A3CUL))
#define bFM3_MFT1_FRT_TCSB2_AD0E               *((volatile unsigned int*)(0x42420A80UL))
#define bFM3_MFT1_FRT_TCSB2_AD1E               *((volatile unsigned int*)(0x42420A84UL))
#define bFM3_MFT1_FRT_TCSB2_AD2E               *((volatile unsigned int*)(0x42420A88UL))

/* Multifunction Timer unit 1 Output Compare Unit registers */
#define bFM3_MFT1_OCU_OCSA10_CST0              *((volatile unsigned int*)(0x42420300UL))
#define bFM3_MFT1_OCU_OCSA10_CST1              *((volatile unsigned int*)(0x42420304UL))
#define bFM3_MFT1_OCU_OCSA10_BDIS0             *((volatile unsigned int*)(0x42420308UL))
#define bFM3_MFT1_OCU_OCSA10_BDIS1             *((volatile unsigned int*)(0x4242030CUL))
#define bFM3_MFT1_OCU_OCSA10_IOE0              *((volatile unsigned int*)(0x42420310UL))
#define bFM3_MFT1_OCU_OCSA10_IOE1              *((volatile unsigned int*)(0x42420314UL))
#define bFM3_MFT1_OCU_OCSA10_IOP0              *((volatile unsigned int*)(0x42420318UL))
#define bFM3_MFT1_OCU_OCSA10_IOP1              *((volatile unsigned int*)(0x4242031CUL))
#define bFM3_MFT1_OCU_OCSB10_OTD0              *((volatile unsigned int*)(0x42420320UL))
#define bFM3_MFT1_OCU_OCSB10_OTD1              *((volatile unsigned int*)(0x42420324UL))
#define bFM3_MFT1_OCU_OCSB10_CMOD              *((volatile unsigned int*)(0x42420330UL))
#define bFM3_MFT1_OCU_OCSB10_BTS0              *((volatile unsigned int*)(0x42420334UL))
#define bFM3_MFT1_OCU_OCSB10_BTS1              *((volatile unsigned int*)(0x42420338UL))
#define bFM3_MFT1_OCU_OCSA32_CST2              *((volatile unsigned int*)(0x42420380UL))
#define bFM3_MFT1_OCU_OCSA32_CST3              *((volatile unsigned int*)(0x42420384UL))
#define bFM3_MFT1_OCU_OCSA32_BDIS2             *((volatile unsigned int*)(0x42420388UL))
#define bFM3_MFT1_OCU_OCSA32_BDIS3             *((volatile unsigned int*)(0x4242038CUL))
#define bFM3_MFT1_OCU_OCSA32_IOE2              *((volatile unsigned int*)(0x42420390UL))
#define bFM3_MFT1_OCU_OCSA32_IOE3              *((volatile unsigned int*)(0x42420394UL))
#define bFM3_MFT1_OCU_OCSA32_IOP2              *((volatile unsigned int*)(0x42420398UL))
#define bFM3_MFT1_OCU_OCSA32_IOP3              *((volatile unsigned int*)(0x4242039CUL))
#define bFM3_MFT1_OCU_OCSB32_OTD2              *((volatile unsigned int*)(0x424203A0UL))
#define bFM3_MFT1_OCU_OCSB32_OTD3              *((volatile unsigned int*)(0x424203A4UL))
#define bFM3_MFT1_OCU_OCSB32_CMOD              *((volatile unsigned int*)(0x424203B0UL))
#define bFM3_MFT1_OCU_OCSB32_BTS2              *((volatile unsigned int*)(0x424203B4UL))
#define bFM3_MFT1_OCU_OCSB32_BTS3              *((volatile unsigned int*)(0x424203B8UL))
#define bFM3_MFT1_OCU_OCSA54_CST4              *((volatile unsigned int*)(0x42420400UL))
#define bFM3_MFT1_OCU_OCSA54_CST5              *((volatile unsigned int*)(0x42420404UL))
#define bFM3_MFT1_OCU_OCSA54_BDIS4             *((volatile unsigned int*)(0x42420408UL))
#define bFM3_MFT1_OCU_OCSA54_BDIS5             *((volatile unsigned int*)(0x4242040CUL))
#define bFM3_MFT1_OCU_OCSA54_IOE4              *((volatile unsigned int*)(0x42420410UL))
#define bFM3_MFT1_OCU_OCSA54_IOE5              *((volatile unsigned int*)(0x42420414UL))
#define bFM3_MFT1_OCU_OCSA54_IOP4              *((volatile unsigned int*)(0x42420418UL))
#define bFM3_MFT1_OCU_OCSA54_IOP5              *((volatile unsigned int*)(0x4242041CUL))
#define bFM3_MFT1_OCU_OCSB54_OTD4              *((volatile unsigned int*)(0x42420420UL))
#define bFM3_MFT1_OCU_OCSB54_OTD5              *((volatile unsigned int*)(0x42420424UL))
#define bFM3_MFT1_OCU_OCSB54_CMOD              *((volatile unsigned int*)(0x42420430UL))
#define bFM3_MFT1_OCU_OCSB54_BTS4              *((volatile unsigned int*)(0x42420434UL))
#define bFM3_MFT1_OCU_OCSB54_BTS5              *((volatile unsigned int*)(0x42420438UL))
#define bFM3_MFT1_OCU_OCSC_MOD0                *((volatile unsigned int*)(0x424204A0UL))
#define bFM3_MFT1_OCU_OCSC_MOD1                *((volatile unsigned int*)(0x424204A4UL))
#define bFM3_MFT1_OCU_OCSC_MOD2                *((volatile unsigned int*)(0x424204A8UL))
#define bFM3_MFT1_OCU_OCSC_MOD3                *((volatile unsigned int*)(0x424204ACUL))
#define bFM3_MFT1_OCU_OCSC_MOD4                *((volatile unsigned int*)(0x424204B0UL))
#define bFM3_MFT1_OCU_OCSC_MOD5                *((volatile unsigned int*)(0x424204B4UL))
#define bFM3_MFT1_OCU_OCFS10_FSO00             *((volatile unsigned int*)(0x42420B00UL))
#define bFM3_MFT1_OCU_OCFS10_FSO01             *((volatile unsigned int*)(0x42420B04UL))
#define bFM3_MFT1_OCU_OCFS10_FSO02             *((volatile unsigned int*)(0x42420B08UL))
#define bFM3_MFT1_OCU_OCFS10_FSO03             *((volatile unsigned int*)(0x42420B0CUL))
#define bFM3_MFT1_OCU_OCFS10_FSO10             *((volatile unsigned int*)(0x42420B10UL))
#define bFM3_MFT1_OCU_OCFS10_FSO11             *((volatile unsigned int*)(0x42420B14UL))
#define bFM3_MFT1_OCU_OCFS10_FSO12             *((volatile unsigned int*)(0x42420B18UL))
#define bFM3_MFT1_OCU_OCFS10_FSO13             *((volatile unsigned int*)(0x42420B1CUL))
#define bFM3_MFT1_OCU_OCFS32_FSO20             *((volatile unsigned int*)(0x42420B20UL))
#define bFM3_MFT1_OCU_OCFS32_FSO21             *((volatile unsigned int*)(0x42420B24UL))
#define bFM3_MFT1_OCU_OCFS32_FSO22             *((volatile unsigned int*)(0x42420B28UL))
#define bFM3_MFT1_OCU_OCFS32_FSO23             *((volatile unsigned int*)(0x42420B2CUL))
#define bFM3_MFT1_OCU_OCFS32_FSO30             *((volatile unsigned int*)(0x42420B30UL))
#define bFM3_MFT1_OCU_OCFS32_FSO31             *((volatile unsigned int*)(0x42420B34UL))
#define bFM3_MFT1_OCU_OCFS32_FSO32             *((volatile unsigned int*)(0x42420B38UL))
#define bFM3_MFT1_OCU_OCFS32_FSO33             *((volatile unsigned int*)(0x42420B3CUL))
#define bFM3_MFT1_OCU_OCFS54_FSO40             *((volatile unsigned int*)(0x42420B80UL))
#define bFM3_MFT1_OCU_OCFS54_FSO41             *((volatile unsigned int*)(0x42420B84UL))
#define bFM3_MFT1_OCU_OCFS54_FSO42             *((volatile unsigned int*)(0x42420B88UL))
#define bFM3_MFT1_OCU_OCFS54_FSO43             *((volatile unsigned int*)(0x42420B8CUL))
#define bFM3_MFT1_OCU_OCFS54_FSO50             *((volatile unsigned int*)(0x42420B90UL))
#define bFM3_MFT1_OCU_OCFS54_FSO51             *((volatile unsigned int*)(0x42420B94UL))
#define bFM3_MFT1_OCU_OCFS54_FSO52             *((volatile unsigned int*)(0x42420B98UL))
#define bFM3_MFT1_OCU_OCFS54_FSO53             *((volatile unsigned int*)(0x42420B9CUL))

/* Multifunction Timer unit 1 Waveform Generator and Noise Canceler registers */
#define bFM3_MFT1_WFG_WFSA10_DCK0              *((volatile unsigned int*)(0x42421180UL))
#define bFM3_MFT1_WFG_WFSA10_DCK1              *((volatile unsigned int*)(0x42421184UL))
#define bFM3_MFT1_WFG_WFSA10_DCK2              *((volatile unsigned int*)(0x42421188UL))
#define bFM3_MFT1_WFG_WFSA10_GTEN0             *((volatile unsigned int*)(0x42421198UL))
#define bFM3_MFT1_WFG_WFSA10_GTEN1             *((volatile unsigned int*)(0x4242119CUL))
#define bFM3_MFT1_WFG_WFSA10_PSEL0             *((volatile unsigned int*)(0x424211A0UL))
#define bFM3_MFT1_WFG_WFSA10_PSEL1             *((volatile unsigned int*)(0x424211A4UL))
#define bFM3_MFT1_WFG_WFSA10_PGEN0             *((volatile unsigned int*)(0x424211A8UL))
#define bFM3_MFT1_WFG_WFSA10_PGEN1             *((volatile unsigned int*)(0x424211ACUL))
#define bFM3_MFT1_WFG_WFSA10_DMOD              *((volatile unsigned int*)(0x424211B0UL))
#define bFM3_MFT1_WFG_WFSA32_DCK0              *((volatile unsigned int*)(0x42421200UL))
#define bFM3_MFT1_WFG_WFSA32_DCK1              *((volatile unsigned int*)(0x42421204UL))
#define bFM3_MFT1_WFG_WFSA32_DCK2              *((volatile unsigned int*)(0x42421208UL))
#define bFM3_MFT1_WFG_WFSA32_GTEN0             *((volatile unsigned int*)(0x42421218UL))
#define bFM3_MFT1_WFG_WFSA32_GTEN1             *((volatile unsigned int*)(0x4242121CUL))
#define bFM3_MFT1_WFG_WFSA32_PSEL0             *((volatile unsigned int*)(0x42421220UL))
#define bFM3_MFT1_WFG_WFSA32_PSEL1             *((volatile unsigned int*)(0x42421224UL))
#define bFM3_MFT1_WFG_WFSA32_PGEN0             *((volatile unsigned int*)(0x42421228UL))
#define bFM3_MFT1_WFG_WFSA32_PGEN1             *((volatile unsigned int*)(0x4242122CUL))
#define bFM3_MFT1_WFG_WFSA32_DMOD              *((volatile unsigned int*)(0x42421230UL))
#define bFM3_MFT1_WFG_WFSA54_DCK0              *((volatile unsigned int*)(0x42421280UL))
#define bFM3_MFT1_WFG_WFSA54_DCK1              *((volatile unsigned int*)(0x42421284UL))
#define bFM3_MFT1_WFG_WFSA54_DCK2              *((volatile unsigned int*)(0x42421288UL))
#define bFM3_MFT1_WFG_WFSA54_GTEN0             *((volatile unsigned int*)(0x42421298UL))
#define bFM3_MFT1_WFG_WFSA54_GTEN1             *((volatile unsigned int*)(0x4242129CUL))
#define bFM3_MFT1_WFG_WFSA54_PSEL0             *((volatile unsigned int*)(0x424212A0UL))
#define bFM3_MFT1_WFG_WFSA54_PSEL1             *((volatile unsigned int*)(0x424212A4UL))
#define bFM3_MFT1_WFG_WFSA54_PGEN0             *((volatile unsigned int*)(0x424212A8UL))
#define bFM3_MFT1_WFG_WFSA54_PGEN1             *((volatile unsigned int*)(0x424212ACUL))
#define bFM3_MFT1_WFG_WFSA54_DMOD              *((volatile unsigned int*)(0x424212B0UL))
#define bFM3_MFT1_WFG_WFIR_DTIF                *((volatile unsigned int*)(0x42421300UL))
#define bFM3_MFT1_WFG_WFIR_DTIC                *((volatile unsigned int*)(0x42421304UL))
#define bFM3_MFT1_WFG_WFIR_TMIF10              *((volatile unsigned int*)(0x42421310UL))
#define bFM3_MFT1_WFG_WFIR_TMIC10              *((volatile unsigned int*)(0x42421314UL))
#define bFM3_MFT1_WFG_WFIR_TMIE10              *((volatile unsigned int*)(0x42421318UL))
#define bFM3_MFT1_WFG_WFIR_TMIS10              *((volatile unsigned int*)(0x4242131CUL))
#define bFM3_MFT1_WFG_WFIR_TMIF32              *((volatile unsigned int*)(0x42421320UL))
#define bFM3_MFT1_WFG_WFIR_TMIC32              *((volatile unsigned int*)(0x42421324UL))
#define bFM3_MFT1_WFG_WFIR_TMIE32              *((volatile unsigned int*)(0x42421328UL))
#define bFM3_MFT1_WFG_WFIR_TMIS32              *((volatile unsigned int*)(0x4242132CUL))
#define bFM3_MFT1_WFG_WFIR_TMIF54              *((volatile unsigned int*)(0x42421330UL))
#define bFM3_MFT1_WFG_WFIR_TMIC54              *((volatile unsigned int*)(0x42421334UL))
#define bFM3_MFT1_WFG_WFIR_TMIE54              *((volatile unsigned int*)(0x42421338UL))
#define bFM3_MFT1_WFG_WFIR_TMIS54              *((volatile unsigned int*)(0x4242133CUL))
#define bFM3_MFT1_WFG_NZCL_DTIE                *((volatile unsigned int*)(0x42421380UL))
#define bFM3_MFT1_WFG_NZCL_NWS0                *((volatile unsigned int*)(0x42421384UL))
#define bFM3_MFT1_WFG_NZCL_NWS1                *((volatile unsigned int*)(0x42421388UL))
#define bFM3_MFT1_WFG_NZCL_NWS2                *((volatile unsigned int*)(0x4242138CUL))
#define bFM3_MFT1_WFG_NZCL_SDTI                *((volatile unsigned int*)(0x42421390UL))

/* Multifunction Timer unit 1 Input Capture Unit registers */
#define bFM3_MFT1_ICU_ICFS10_FSI00             *((volatile unsigned int*)(0x42420C00UL))
#define bFM3_MFT1_ICU_ICFS10_FSI01             *((volatile unsigned int*)(0x42420C04UL))
#define bFM3_MFT1_ICU_ICFS10_FSI02             *((volatile unsigned int*)(0x42420C08UL))
#define bFM3_MFT1_ICU_ICFS10_FSI03             *((volatile unsigned int*)(0x42420C0CUL))
#define bFM3_MFT1_ICU_ICFS10_FSI10             *((volatile unsigned int*)(0x42420C10UL))
#define bFM3_MFT1_ICU_ICFS10_FSI11             *((volatile unsigned int*)(0x42420C14UL))
#define bFM3_MFT1_ICU_ICFS10_FSI12             *((volatile unsigned int*)(0x42420C18UL))
#define bFM3_MFT1_ICU_ICFS10_FSI13             *((volatile unsigned int*)(0x42420C1CUL))
#define bFM3_MFT1_ICU_ICFS32_FSI20             *((volatile unsigned int*)(0x42420C20UL))
#define bFM3_MFT1_ICU_ICFS32_FSI21             *((volatile unsigned int*)(0x42420C24UL))
#define bFM3_MFT1_ICU_ICFS32_FSI22             *((volatile unsigned int*)(0x42420C28UL))
#define bFM3_MFT1_ICU_ICFS32_FSI23             *((volatile unsigned int*)(0x42420C2CUL))
#define bFM3_MFT1_ICU_ICFS32_FSI30             *((volatile unsigned int*)(0x42420C30UL))
#define bFM3_MFT1_ICU_ICFS32_FSI31             *((volatile unsigned int*)(0x42420C34UL))
#define bFM3_MFT1_ICU_ICFS32_FSI32             *((volatile unsigned int*)(0x42420C38UL))
#define bFM3_MFT1_ICU_ICFS32_FSI33             *((volatile unsigned int*)(0x42420C3CUL))
#define bFM3_MFT1_ICU_ICSA10_EG00              *((volatile unsigned int*)(0x42420F00UL))
#define bFM3_MFT1_ICU_ICSA10_EG01              *((volatile unsigned int*)(0x42420F04UL))
#define bFM3_MFT1_ICU_ICSA10_EG10              *((volatile unsigned int*)(0x42420F08UL))
#define bFM3_MFT1_ICU_ICSA10_EG11              *((volatile unsigned int*)(0x42420F0CUL))
#define bFM3_MFT1_ICU_ICSA10_ICE0              *((volatile unsigned int*)(0x42420F10UL))
#define bFM3_MFT1_ICU_ICSA10_ICE1              *((volatile unsigned int*)(0x42420F14UL))
#define bFM3_MFT1_ICU_ICSA10_ICP0              *((volatile unsigned int*)(0x42420F18UL))
#define bFM3_MFT1_ICU_ICSA10_ICP1              *((volatile unsigned int*)(0x42420F1CUL))
#define bFM3_MFT1_ICU_ICSB10_IEI0              *((volatile unsigned int*)(0x42420F20UL))
#define bFM3_MFT1_ICU_ICSB10_IEI1              *((volatile unsigned int*)(0x42420F24UL))
#define bFM3_MFT1_ICU_ICSA32_EG20              *((volatile unsigned int*)(0x42420F80UL))
#define bFM3_MFT1_ICU_ICSA32_EG21              *((volatile unsigned int*)(0x42420F84UL))
#define bFM3_MFT1_ICU_ICSA32_EG30              *((volatile unsigned int*)(0x42420F88UL))
#define bFM3_MFT1_ICU_ICSA32_EG31              *((volatile unsigned int*)(0x42420F8CUL))
#define bFM3_MFT1_ICU_ICSA32_ICE2              *((volatile unsigned int*)(0x42420F90UL))
#define bFM3_MFT1_ICU_ICSA32_ICE3              *((volatile unsigned int*)(0x42420F94UL))
#define bFM3_MFT1_ICU_ICSA32_ICP2              *((volatile unsigned int*)(0x42420F98UL))
#define bFM3_MFT1_ICU_ICSA32_ICP3              *((volatile unsigned int*)(0x42420F9CUL))
#define bFM3_MFT1_ICU_ICSB32_IEI2              *((volatile unsigned int*)(0x42420FA0UL))
#define bFM3_MFT1_ICU_ICSB32_IEI3              *((volatile unsigned int*)(0x42420FA4UL))

/* Multifunction Timer unit 1 ADC Start Compare Unit registers */
#define bFM3_MFT1_ADCMP_ACSB_BDIS0             *((volatile unsigned int*)(0x42421700UL))
#define bFM3_MFT1_ADCMP_ACSB_BDIS1             *((volatile unsigned int*)(0x42421704UL))
#define bFM3_MFT1_ADCMP_ACSB_BDIS2             *((volatile unsigned int*)(0x42421708UL))
#define bFM3_MFT1_ADCMP_ACSB_BTS0              *((volatile unsigned int*)(0x42421710UL))
#define bFM3_MFT1_ADCMP_ACSB_BTS1              *((volatile unsigned int*)(0x42421714UL))
#define bFM3_MFT1_ADCMP_ACSB_BTS2              *((volatile unsigned int*)(0x42421718UL))
#define bFM3_MFT1_ADCMP_ACSA_CE00              *((volatile unsigned int*)(0x42421780UL))
#define bFM3_MFT1_ADCMP_ACSA_CE01              *((volatile unsigned int*)(0x42421784UL))
#define bFM3_MFT1_ADCMP_ACSA_CE10              *((volatile unsigned int*)(0x42421788UL))
#define bFM3_MFT1_ADCMP_ACSA_CE11              *((volatile unsigned int*)(0x4242178CUL))
#define bFM3_MFT1_ADCMP_ACSA_CE20              *((volatile unsigned int*)(0x42421790UL))
#define bFM3_MFT1_ADCMP_ACSA_CE21              *((volatile unsigned int*)(0x42421794UL))
#define bFM3_MFT1_ADCMP_ACSA_SEL00             *((volatile unsigned int*)(0x424217A0UL))
#define bFM3_MFT1_ADCMP_ACSA_SEL01             *((volatile unsigned int*)(0x424217A4UL))
#define bFM3_MFT1_ADCMP_ACSA_SEL10             *((volatile unsigned int*)(0x424217A8UL))
#define bFM3_MFT1_ADCMP_ACSA_SEL11             *((volatile unsigned int*)(0x424217ACUL))
#define bFM3_MFT1_ADCMP_ACSA_SEL20             *((volatile unsigned int*)(0x424217B0UL))
#define bFM3_MFT1_ADCMP_ACSA_SEL21             *((volatile unsigned int*)(0x424217B4UL))
#define bFM3_MFT1_ADCMP_ATSA_AD0S0             *((volatile unsigned int*)(0x42421800UL))
#define bFM3_MFT1_ADCMP_ATSA_AD0S1             *((volatile unsigned int*)(0x42421804UL))
#define bFM3_MFT1_ADCMP_ATSA_AD1S0             *((volatile unsigned int*)(0x42421808UL))
#define bFM3_MFT1_ADCMP_ATSA_AD1S1             *((volatile unsigned int*)(0x4242180CUL))
#define bFM3_MFT1_ADCMP_ATSA_AD2S0             *((volatile unsigned int*)(0x42421810UL))
#define bFM3_MFT1_ADCMP_ATSA_AD2S1             *((volatile unsigned int*)(0x42421814UL))
#define bFM3_MFT1_ADCMP_ATSA_AD0P0             *((volatile unsigned int*)(0x42421820UL))
#define bFM3_MFT1_ADCMP_ATSA_AD0P1             *((volatile unsigned int*)(0x42421824UL))
#define bFM3_MFT1_ADCMP_ATSA_AD1P0             *((volatile unsigned int*)(0x42421828UL))
#define bFM3_MFT1_ADCMP_ATSA_AD1P1             *((volatile unsigned int*)(0x4242182CUL))
#define bFM3_MFT1_ADCMP_ATSA_AD2P0             *((volatile unsigned int*)(0x42421830UL))
#define bFM3_MFT1_ADCMP_ATSA_AD2P1             *((volatile unsigned int*)(0x42421834UL))

/* Multifunction Timer unit 2 Free Running Timer registers */
#define bFM3_MFT2_FRT_TCSA0_CLK0               *((volatile unsigned int*)(0x42440600UL))
#define bFM3_MFT2_FRT_TCSA0_CLK1               *((volatile unsigned int*)(0x42440604UL))
#define bFM3_MFT2_FRT_TCSA0_CLK2               *((volatile unsigned int*)(0x42440608UL))
#define bFM3_MFT2_FRT_TCSA0_CLK3               *((volatile unsigned int*)(0x4244060CUL))
#define bFM3_MFT2_FRT_TCSA0_SCLR               *((volatile unsigned int*)(0x42440610UL))
#define bFM3_MFT2_FRT_TCSA0_MODE               *((volatile unsigned int*)(0x42440614UL))
#define bFM3_MFT2_FRT_TCSA0_STOP               *((volatile unsigned int*)(0x42440618UL))
#define bFM3_MFT2_FRT_TCSA0_BFE                *((volatile unsigned int*)(0x4244061CUL))
#define bFM3_MFT2_FRT_TCSA0_ICRE               *((volatile unsigned int*)(0x42440620UL))
#define bFM3_MFT2_FRT_TCSA0_ICLR               *((volatile unsigned int*)(0x42440624UL))
#define bFM3_MFT2_FRT_TCSA0_IRQZE              *((volatile unsigned int*)(0x42440634UL))
#define bFM3_MFT2_FRT_TCSA0_IRQZF              *((volatile unsigned int*)(0x42440638UL))
#define bFM3_MFT2_FRT_TCSA0_ECKE               *((volatile unsigned int*)(0x4244063CUL))
#define bFM3_MFT2_FRT_TCSB0_AD0E               *((volatile unsigned int*)(0x42440680UL))
#define bFM3_MFT2_FRT_TCSB0_AD1E               *((volatile unsigned int*)(0x42440684UL))
#define bFM3_MFT2_FRT_TCSB0_AD2E               *((volatile unsigned int*)(0x42440688UL))
#define bFM3_MFT2_FRT_TCSA1_CLK0               *((volatile unsigned int*)(0x42440800UL))
#define bFM3_MFT2_FRT_TCSA1_CLK1               *((volatile unsigned int*)(0x42440804UL))
#define bFM3_MFT2_FRT_TCSA1_CLK2               *((volatile unsigned int*)(0x42440808UL))
#define bFM3_MFT2_FRT_TCSA1_CLK3               *((volatile unsigned int*)(0x4244080CUL))
#define bFM3_MFT2_FRT_TCSA1_SCLR               *((volatile unsigned int*)(0x42440810UL))
#define bFM3_MFT2_FRT_TCSA1_MODE               *((volatile unsigned int*)(0x42440814UL))
#define bFM3_MFT2_FRT_TCSA1_STOP               *((volatile unsigned int*)(0x42440818UL))
#define bFM3_MFT2_FRT_TCSA1_BFE                *((volatile unsigned int*)(0x4244081CUL))
#define bFM3_MFT2_FRT_TCSA1_ICRE               *((volatile unsigned int*)(0x42440820UL))
#define bFM3_MFT2_FRT_TCSA1_ICLR               *((volatile unsigned int*)(0x42440824UL))
#define bFM3_MFT2_FRT_TCSA1_IRQZE              *((volatile unsigned int*)(0x42440834UL))
#define bFM3_MFT2_FRT_TCSA1_IRQZF              *((volatile unsigned int*)(0x42440838UL))
#define bFM3_MFT2_FRT_TCSA1_ECKE               *((volatile unsigned int*)(0x4244083CUL))
#define bFM3_MFT2_FRT_TCSB1_AD0E               *((volatile unsigned int*)(0x42440880UL))
#define bFM3_MFT2_FRT_TCSB1_AD1E               *((volatile unsigned int*)(0x42440884UL))
#define bFM3_MFT2_FRT_TCSB1_AD2E               *((volatile unsigned int*)(0x42440888UL))
#define bFM3_MFT2_FRT_TCSA2_CLK0               *((volatile unsigned int*)(0x42440A00UL))
#define bFM3_MFT2_FRT_TCSA2_CLK1               *((volatile unsigned int*)(0x42440A04UL))
#define bFM3_MFT2_FRT_TCSA2_CLK2               *((volatile unsigned int*)(0x42440A08UL))
#define bFM3_MFT2_FRT_TCSA2_CLK3               *((volatile unsigned int*)(0x42440A0CUL))
#define bFM3_MFT2_FRT_TCSA2_SCLR               *((volatile unsigned int*)(0x42440A10UL))
#define bFM3_MFT2_FRT_TCSA2_MODE               *((volatile unsigned int*)(0x42440A14UL))
#define bFM3_MFT2_FRT_TCSA2_STOP               *((volatile unsigned int*)(0x42440A18UL))
#define bFM3_MFT2_FRT_TCSA2_BFE                *((volatile unsigned int*)(0x42440A1CUL))
#define bFM3_MFT2_FRT_TCSA2_ICRE               *((volatile unsigned int*)(0x42440A20UL))
#define bFM3_MFT2_FRT_TCSA2_ICLR               *((volatile unsigned int*)(0x42440A24UL))
#define bFM3_MFT2_FRT_TCSA2_IRQZE              *((volatile unsigned int*)(0x42440A34UL))
#define bFM3_MFT2_FRT_TCSA2_IRQZF              *((volatile unsigned int*)(0x42440A38UL))
#define bFM3_MFT2_FRT_TCSA2_ECKE               *((volatile unsigned int*)(0x42440A3CUL))
#define bFM3_MFT2_FRT_TCSB2_AD0E               *((volatile unsigned int*)(0x42440A80UL))
#define bFM3_MFT2_FRT_TCSB2_AD1E               *((volatile unsigned int*)(0x42440A84UL))
#define bFM3_MFT2_FRT_TCSB2_AD2E               *((volatile unsigned int*)(0x42440A88UL))

/* Multifunction Timer unit 2 Output Compare Unit registers */
#define bFM3_MFT2_OCU_OCSA10_CST0              *((volatile unsigned int*)(0x42440300UL))
#define bFM3_MFT2_OCU_OCSA10_CST1              *((volatile unsigned int*)(0x42440304UL))
#define bFM3_MFT2_OCU_OCSA10_BDIS0             *((volatile unsigned int*)(0x42440308UL))
#define bFM3_MFT2_OCU_OCSA10_BDIS1             *((volatile unsigned int*)(0x4244030CUL))
#define bFM3_MFT2_OCU_OCSA10_IOE0              *((volatile unsigned int*)(0x42440310UL))
#define bFM3_MFT2_OCU_OCSA10_IOE1              *((volatile unsigned int*)(0x42440314UL))
#define bFM3_MFT2_OCU_OCSA10_IOP0              *((volatile unsigned int*)(0x42440318UL))
#define bFM3_MFT2_OCU_OCSA10_IOP1              *((volatile unsigned int*)(0x4244031CUL))
#define bFM3_MFT2_OCU_OCSB10_OTD0              *((volatile unsigned int*)(0x42440320UL))
#define bFM3_MFT2_OCU_OCSB10_OTD1              *((volatile unsigned int*)(0x42440324UL))
#define bFM3_MFT2_OCU_OCSB10_CMOD              *((volatile unsigned int*)(0x42440330UL))
#define bFM3_MFT2_OCU_OCSB10_BTS0              *((volatile unsigned int*)(0x42440334UL))
#define bFM3_MFT2_OCU_OCSB10_BTS1              *((volatile unsigned int*)(0x42440338UL))
#define bFM3_MFT2_OCU_OCSA32_CST2              *((volatile unsigned int*)(0x42440380UL))
#define bFM3_MFT2_OCU_OCSA32_CST3              *((volatile unsigned int*)(0x42440384UL))
#define bFM3_MFT2_OCU_OCSA32_BDIS2             *((volatile unsigned int*)(0x42440388UL))
#define bFM3_MFT2_OCU_OCSA32_BDIS3             *((volatile unsigned int*)(0x4244038CUL))
#define bFM3_MFT2_OCU_OCSA32_IOE2              *((volatile unsigned int*)(0x42440390UL))
#define bFM3_MFT2_OCU_OCSA32_IOE3              *((volatile unsigned int*)(0x42440394UL))
#define bFM3_MFT2_OCU_OCSA32_IOP2              *((volatile unsigned int*)(0x42440398UL))
#define bFM3_MFT2_OCU_OCSA32_IOP3              *((volatile unsigned int*)(0x4244039CUL))
#define bFM3_MFT2_OCU_OCSB32_OTD2              *((volatile unsigned int*)(0x424403A0UL))
#define bFM3_MFT2_OCU_OCSB32_OTD3              *((volatile unsigned int*)(0x424403A4UL))
#define bFM3_MFT2_OCU_OCSB32_CMOD              *((volatile unsigned int*)(0x424403B0UL))
#define bFM3_MFT2_OCU_OCSB32_BTS2              *((volatile unsigned int*)(0x424403B4UL))
#define bFM3_MFT2_OCU_OCSB32_BTS3              *((volatile unsigned int*)(0x424403B8UL))
#define bFM3_MFT2_OCU_OCSA54_CST4              *((volatile unsigned int*)(0x42440400UL))
#define bFM3_MFT2_OCU_OCSA54_CST5              *((volatile unsigned int*)(0x42440404UL))
#define bFM3_MFT2_OCU_OCSA54_BDIS4             *((volatile unsigned int*)(0x42440408UL))
#define bFM3_MFT2_OCU_OCSA54_BDIS5             *((volatile unsigned int*)(0x4244040CUL))
#define bFM3_MFT2_OCU_OCSA54_IOE4              *((volatile unsigned int*)(0x42440410UL))
#define bFM3_MFT2_OCU_OCSA54_IOE5              *((volatile unsigned int*)(0x42440414UL))
#define bFM3_MFT2_OCU_OCSA54_IOP4              *((volatile unsigned int*)(0x42440418UL))
#define bFM3_MFT2_OCU_OCSA54_IOP5              *((volatile unsigned int*)(0x4244041CUL))
#define bFM3_MFT2_OCU_OCSB54_OTD4              *((volatile unsigned int*)(0x42440420UL))
#define bFM3_MFT2_OCU_OCSB54_OTD5              *((volatile unsigned int*)(0x42440424UL))
#define bFM3_MFT2_OCU_OCSB54_CMOD              *((volatile unsigned int*)(0x42440430UL))
#define bFM3_MFT2_OCU_OCSB54_BTS4              *((volatile unsigned int*)(0x42440434UL))
#define bFM3_MFT2_OCU_OCSB54_BTS5              *((volatile unsigned int*)(0x42440438UL))
#define bFM3_MFT2_OCU_OCSC_MOD0                *((volatile unsigned int*)(0x424404A0UL))
#define bFM3_MFT2_OCU_OCSC_MOD1                *((volatile unsigned int*)(0x424404A4UL))
#define bFM3_MFT2_OCU_OCSC_MOD2                *((volatile unsigned int*)(0x424404A8UL))
#define bFM3_MFT2_OCU_OCSC_MOD3                *((volatile unsigned int*)(0x424404ACUL))
#define bFM3_MFT2_OCU_OCSC_MOD4                *((volatile unsigned int*)(0x424404B0UL))
#define bFM3_MFT2_OCU_OCSC_MOD5                *((volatile unsigned int*)(0x424404B4UL))
#define bFM3_MFT2_OCU_OCFS10_FSO00             *((volatile unsigned int*)(0x42440B00UL))
#define bFM3_MFT2_OCU_OCFS10_FSO01             *((volatile unsigned int*)(0x42440B04UL))
#define bFM3_MFT2_OCU_OCFS10_FSO02             *((volatile unsigned int*)(0x42440B08UL))
#define bFM3_MFT2_OCU_OCFS10_FSO03             *((volatile unsigned int*)(0x42440B0CUL))
#define bFM3_MFT2_OCU_OCFS10_FSO10             *((volatile unsigned int*)(0x42440B10UL))
#define bFM3_MFT2_OCU_OCFS10_FSO11             *((volatile unsigned int*)(0x42440B14UL))
#define bFM3_MFT2_OCU_OCFS10_FSO12             *((volatile unsigned int*)(0x42440B18UL))
#define bFM3_MFT2_OCU_OCFS10_FSO13             *((volatile unsigned int*)(0x42440B1CUL))
#define bFM3_MFT2_OCU_OCFS32_FSO20             *((volatile unsigned int*)(0x42440B20UL))
#define bFM3_MFT2_OCU_OCFS32_FSO21             *((volatile unsigned int*)(0x42440B24UL))
#define bFM3_MFT2_OCU_OCFS32_FSO22             *((volatile unsigned int*)(0x42440B28UL))
#define bFM3_MFT2_OCU_OCFS32_FSO23             *((volatile unsigned int*)(0x42440B2CUL))
#define bFM3_MFT2_OCU_OCFS32_FSO30             *((volatile unsigned int*)(0x42440B30UL))
#define bFM3_MFT2_OCU_OCFS32_FSO31             *((volatile unsigned int*)(0x42440B34UL))
#define bFM3_MFT2_OCU_OCFS32_FSO32             *((volatile unsigned int*)(0x42440B38UL))
#define bFM3_MFT2_OCU_OCFS32_FSO33             *((volatile unsigned int*)(0x42440B3CUL))
#define bFM3_MFT2_OCU_OCFS54_FSO40             *((volatile unsigned int*)(0x42440B80UL))
#define bFM3_MFT2_OCU_OCFS54_FSO41             *((volatile unsigned int*)(0x42440B84UL))
#define bFM3_MFT2_OCU_OCFS54_FSO42             *((volatile unsigned int*)(0x42440B88UL))
#define bFM3_MFT2_OCU_OCFS54_FSO43             *((volatile unsigned int*)(0x42440B8CUL))
#define bFM3_MFT2_OCU_OCFS54_FSO50             *((volatile unsigned int*)(0x42440B90UL))
#define bFM3_MFT2_OCU_OCFS54_FSO51             *((volatile unsigned int*)(0x42440B94UL))
#define bFM3_MFT2_OCU_OCFS54_FSO52             *((volatile unsigned int*)(0x42440B98UL))
#define bFM3_MFT2_OCU_OCFS54_FSO53             *((volatile unsigned int*)(0x42440B9CUL))

/* Multifunction Timer unit 2 Waveform Generator and Noise Canceler registers */
#define bFM3_MFT2_WFG_WFSA10_DCK0              *((volatile unsigned int*)(0x42441180UL))
#define bFM3_MFT2_WFG_WFSA10_DCK1              *((volatile unsigned int*)(0x42441184UL))
#define bFM3_MFT2_WFG_WFSA10_DCK2              *((volatile unsigned int*)(0x42441188UL))
#define bFM3_MFT2_WFG_WFSA10_GTEN0             *((volatile unsigned int*)(0x42441198UL))
#define bFM3_MFT2_WFG_WFSA10_GTEN1             *((volatile unsigned int*)(0x4244119CUL))
#define bFM3_MFT2_WFG_WFSA10_PSEL0             *((volatile unsigned int*)(0x424411A0UL))
#define bFM3_MFT2_WFG_WFSA10_PSEL1             *((volatile unsigned int*)(0x424411A4UL))
#define bFM3_MFT2_WFG_WFSA10_PGEN0             *((volatile unsigned int*)(0x424411A8UL))
#define bFM3_MFT2_WFG_WFSA10_PGEN1             *((volatile unsigned int*)(0x424411ACUL))
#define bFM3_MFT2_WFG_WFSA10_DMOD              *((volatile unsigned int*)(0x424411B0UL))
#define bFM3_MFT2_WFG_WFSA32_DCK0              *((volatile unsigned int*)(0x42441200UL))
#define bFM3_MFT2_WFG_WFSA32_DCK1              *((volatile unsigned int*)(0x42441204UL))
#define bFM3_MFT2_WFG_WFSA32_DCK2              *((volatile unsigned int*)(0x42441208UL))
#define bFM3_MFT2_WFG_WFSA32_GTEN0             *((volatile unsigned int*)(0x42441218UL))
#define bFM3_MFT2_WFG_WFSA32_GTEN1             *((volatile unsigned int*)(0x4244121CUL))
#define bFM3_MFT2_WFG_WFSA32_PSEL0             *((volatile unsigned int*)(0x42441220UL))
#define bFM3_MFT2_WFG_WFSA32_PSEL1             *((volatile unsigned int*)(0x42441224UL))
#define bFM3_MFT2_WFG_WFSA32_PGEN0             *((volatile unsigned int*)(0x42441228UL))
#define bFM3_MFT2_WFG_WFSA32_PGEN1             *((volatile unsigned int*)(0x4244122CUL))
#define bFM3_MFT2_WFG_WFSA32_DMOD              *((volatile unsigned int*)(0x42441230UL))
#define bFM3_MFT2_WFG_WFSA54_DCK0              *((volatile unsigned int*)(0x42441280UL))
#define bFM3_MFT2_WFG_WFSA54_DCK1              *((volatile unsigned int*)(0x42441284UL))
#define bFM3_MFT2_WFG_WFSA54_DCK2              *((volatile unsigned int*)(0x42441288UL))
#define bFM3_MFT2_WFG_WFSA54_GTEN0             *((volatile unsigned int*)(0x42441298UL))
#define bFM3_MFT2_WFG_WFSA54_GTEN1             *((volatile unsigned int*)(0x4244129CUL))
#define bFM3_MFT2_WFG_WFSA54_PSEL0             *((volatile unsigned int*)(0x424412A0UL))
#define bFM3_MFT2_WFG_WFSA54_PSEL1             *((volatile unsigned int*)(0x424412A4UL))
#define bFM3_MFT2_WFG_WFSA54_PGEN0             *((volatile unsigned int*)(0x424412A8UL))
#define bFM3_MFT2_WFG_WFSA54_PGEN1             *((volatile unsigned int*)(0x424412ACUL))
#define bFM3_MFT2_WFG_WFSA54_DMOD              *((volatile unsigned int*)(0x424412B0UL))
#define bFM3_MFT2_WFG_WFIR_DTIF                *((volatile unsigned int*)(0x42441300UL))
#define bFM3_MFT2_WFG_WFIR_DTIC                *((volatile unsigned int*)(0x42441304UL))
#define bFM3_MFT2_WFG_WFIR_TMIF10              *((volatile unsigned int*)(0x42441310UL))
#define bFM3_MFT2_WFG_WFIR_TMIC10              *((volatile unsigned int*)(0x42441314UL))
#define bFM3_MFT2_WFG_WFIR_TMIE10              *((volatile unsigned int*)(0x42441318UL))
#define bFM3_MFT2_WFG_WFIR_TMIS10              *((volatile unsigned int*)(0x4244131CUL))
#define bFM3_MFT2_WFG_WFIR_TMIF32              *((volatile unsigned int*)(0x42441320UL))
#define bFM3_MFT2_WFG_WFIR_TMIC32              *((volatile unsigned int*)(0x42441324UL))
#define bFM3_MFT2_WFG_WFIR_TMIE32              *((volatile unsigned int*)(0x42441328UL))
#define bFM3_MFT2_WFG_WFIR_TMIS32              *((volatile unsigned int*)(0x4244132CUL))
#define bFM3_MFT2_WFG_WFIR_TMIF54              *((volatile unsigned int*)(0x42441330UL))
#define bFM3_MFT2_WFG_WFIR_TMIC54              *((volatile unsigned int*)(0x42441334UL))
#define bFM3_MFT2_WFG_WFIR_TMIE54              *((volatile unsigned int*)(0x42441338UL))
#define bFM3_MFT2_WFG_WFIR_TMIS54              *((volatile unsigned int*)(0x4244133CUL))
#define bFM3_MFT2_WFG_NZCL_DTIE                *((volatile unsigned int*)(0x42441380UL))
#define bFM3_MFT2_WFG_NZCL_NWS0                *((volatile unsigned int*)(0x42441384UL))
#define bFM3_MFT2_WFG_NZCL_NWS1                *((volatile unsigned int*)(0x42441388UL))
#define bFM3_MFT2_WFG_NZCL_NWS2                *((volatile unsigned int*)(0x4244138CUL))
#define bFM3_MFT2_WFG_NZCL_SDTI                *((volatile unsigned int*)(0x42441390UL))

/* Multifunction Timer unit 2 Input Capture Unit registers */
#define bFM3_MFT2_ICU_ICFS10_FSI00             *((volatile unsigned int*)(0x42440C00UL))
#define bFM3_MFT2_ICU_ICFS10_FSI01             *((volatile unsigned int*)(0x42440C04UL))
#define bFM3_MFT2_ICU_ICFS10_FSI02             *((volatile unsigned int*)(0x42440C08UL))
#define bFM3_MFT2_ICU_ICFS10_FSI03             *((volatile unsigned int*)(0x42440C0CUL))
#define bFM3_MFT2_ICU_ICFS10_FSI10             *((volatile unsigned int*)(0x42440C10UL))
#define bFM3_MFT2_ICU_ICFS10_FSI11             *((volatile unsigned int*)(0x42440C14UL))
#define bFM3_MFT2_ICU_ICFS10_FSI12             *((volatile unsigned int*)(0x42440C18UL))
#define bFM3_MFT2_ICU_ICFS10_FSI13             *((volatile unsigned int*)(0x42440C1CUL))
#define bFM3_MFT2_ICU_ICFS32_FSI20             *((volatile unsigned int*)(0x42440C20UL))
#define bFM3_MFT2_ICU_ICFS32_FSI21             *((volatile unsigned int*)(0x42440C24UL))
#define bFM3_MFT2_ICU_ICFS32_FSI22             *((volatile unsigned int*)(0x42440C28UL))
#define bFM3_MFT2_ICU_ICFS32_FSI23             *((volatile unsigned int*)(0x42440C2CUL))
#define bFM3_MFT2_ICU_ICFS32_FSI30             *((volatile unsigned int*)(0x42440C30UL))
#define bFM3_MFT2_ICU_ICFS32_FSI31             *((volatile unsigned int*)(0x42440C34UL))
#define bFM3_MFT2_ICU_ICFS32_FSI32             *((volatile unsigned int*)(0x42440C38UL))
#define bFM3_MFT2_ICU_ICFS32_FSI33             *((volatile unsigned int*)(0x42440C3CUL))
#define bFM3_MFT2_ICU_ICSA10_EG00              *((volatile unsigned int*)(0x42440F00UL))
#define bFM3_MFT2_ICU_ICSA10_EG01              *((volatile unsigned int*)(0x42440F04UL))
#define bFM3_MFT2_ICU_ICSA10_EG10              *((volatile unsigned int*)(0x42440F08UL))
#define bFM3_MFT2_ICU_ICSA10_EG11              *((volatile unsigned int*)(0x42440F0CUL))
#define bFM3_MFT2_ICU_ICSA10_ICE0              *((volatile unsigned int*)(0x42440F10UL))
#define bFM3_MFT2_ICU_ICSA10_ICE1              *((volatile unsigned int*)(0x42440F14UL))
#define bFM3_MFT2_ICU_ICSA10_ICP0              *((volatile unsigned int*)(0x42440F18UL))
#define bFM3_MFT2_ICU_ICSA10_ICP1              *((volatile unsigned int*)(0x42440F1CUL))
#define bFM3_MFT2_ICU_ICSB10_IEI0              *((volatile unsigned int*)(0x42440F20UL))
#define bFM3_MFT2_ICU_ICSB10_IEI1              *((volatile unsigned int*)(0x42440F24UL))
#define bFM3_MFT2_ICU_ICSA32_EG20              *((volatile unsigned int*)(0x42440F80UL))
#define bFM3_MFT2_ICU_ICSA32_EG21              *((volatile unsigned int*)(0x42440F84UL))
#define bFM3_MFT2_ICU_ICSA32_EG30              *((volatile unsigned int*)(0x42440F88UL))
#define bFM3_MFT2_ICU_ICSA32_EG31              *((volatile unsigned int*)(0x42440F8CUL))
#define bFM3_MFT2_ICU_ICSA32_ICE2              *((volatile unsigned int*)(0x42440F90UL))
#define bFM3_MFT2_ICU_ICSA32_ICE3              *((volatile unsigned int*)(0x42440F94UL))
#define bFM3_MFT2_ICU_ICSA32_ICP2              *((volatile unsigned int*)(0x42440F98UL))
#define bFM3_MFT2_ICU_ICSA32_ICP3              *((volatile unsigned int*)(0x42440F9CUL))
#define bFM3_MFT2_ICU_ICSB32_IEI2              *((volatile unsigned int*)(0x42440FA0UL))
#define bFM3_MFT2_ICU_ICSB32_IEI3              *((volatile unsigned int*)(0x42440FA4UL))

/* Multifunction Timer unit 2 ADC Start Compare Unit registers */
#define bFM3_MFT2_ADCMP_ACSB_BDIS0             *((volatile unsigned int*)(0x42441700UL))
#define bFM3_MFT2_ADCMP_ACSB_BDIS1             *((volatile unsigned int*)(0x42441704UL))
#define bFM3_MFT2_ADCMP_ACSB_BDIS2             *((volatile unsigned int*)(0x42441708UL))
#define bFM3_MFT2_ADCMP_ACSB_BTS0              *((volatile unsigned int*)(0x42441710UL))
#define bFM3_MFT2_ADCMP_ACSB_BTS1              *((volatile unsigned int*)(0x42441714UL))
#define bFM3_MFT2_ADCMP_ACSB_BTS2              *((volatile unsigned int*)(0x42441718UL))
#define bFM3_MFT2_ADCMP_ACSA_CE00              *((volatile unsigned int*)(0x42441780UL))
#define bFM3_MFT2_ADCMP_ACSA_CE01              *((volatile unsigned int*)(0x42441784UL))
#define bFM3_MFT2_ADCMP_ACSA_CE10              *((volatile unsigned int*)(0x42441788UL))
#define bFM3_MFT2_ADCMP_ACSA_CE11              *((volatile unsigned int*)(0x4244178CUL))
#define bFM3_MFT2_ADCMP_ACSA_CE20              *((volatile unsigned int*)(0x42441790UL))
#define bFM3_MFT2_ADCMP_ACSA_CE21              *((volatile unsigned int*)(0x42441794UL))
#define bFM3_MFT2_ADCMP_ACSA_SEL00             *((volatile unsigned int*)(0x424417A0UL))
#define bFM3_MFT2_ADCMP_ACSA_SEL01             *((volatile unsigned int*)(0x424417A4UL))
#define bFM3_MFT2_ADCMP_ACSA_SEL10             *((volatile unsigned int*)(0x424417A8UL))
#define bFM3_MFT2_ADCMP_ACSA_SEL11             *((volatile unsigned int*)(0x424417ACUL))
#define bFM3_MFT2_ADCMP_ACSA_SEL20             *((volatile unsigned int*)(0x424417B0UL))
#define bFM3_MFT2_ADCMP_ACSA_SEL21             *((volatile unsigned int*)(0x424417B4UL))
#define bFM3_MFT2_ADCMP_ATSA_AD0S0             *((volatile unsigned int*)(0x42441800UL))
#define bFM3_MFT2_ADCMP_ATSA_AD0S1             *((volatile unsigned int*)(0x42441804UL))
#define bFM3_MFT2_ADCMP_ATSA_AD1S0             *((volatile unsigned int*)(0x42441808UL))
#define bFM3_MFT2_ADCMP_ATSA_AD1S1             *((volatile unsigned int*)(0x4244180CUL))
#define bFM3_MFT2_ADCMP_ATSA_AD2S0             *((volatile unsigned int*)(0x42441810UL))
#define bFM3_MFT2_ADCMP_ATSA_AD2S1             *((volatile unsigned int*)(0x42441814UL))
#define bFM3_MFT2_ADCMP_ATSA_AD0P0             *((volatile unsigned int*)(0x42441820UL))
#define bFM3_MFT2_ADCMP_ATSA_AD0P1             *((volatile unsigned int*)(0x42441824UL))
#define bFM3_MFT2_ADCMP_ATSA_AD1P0             *((volatile unsigned int*)(0x42441828UL))
#define bFM3_MFT2_ADCMP_ATSA_AD1P1             *((volatile unsigned int*)(0x4244182CUL))
#define bFM3_MFT2_ADCMP_ATSA_AD2P0             *((volatile unsigned int*)(0x42441830UL))
#define bFM3_MFT2_ADCMP_ATSA_AD2P1             *((volatile unsigned int*)(0x42441834UL))

/* Multifunction Timer PPG registers */
#define bFM3_MFT_PPG_TTCR0_STR0                *((volatile unsigned int*)(0x42480020UL))
#define bFM3_MFT_PPG_TTCR0_MONI0               *((volatile unsigned int*)(0x42480024UL))
#define bFM3_MFT_PPG_TTCR0_CS00                *((volatile unsigned int*)(0x42480028UL))
#define bFM3_MFT_PPG_TTCR0_CS01                *((volatile unsigned int*)(0x4248002CUL))
#define bFM3_MFT_PPG_TTCR0_TRG0O               *((volatile unsigned int*)(0x42480030UL))
#define bFM3_MFT_PPG_TTCR0_TRG2O               *((volatile unsigned int*)(0x42480034UL))
#define bFM3_MFT_PPG_TTCR0_TRG4O               *((volatile unsigned int*)(0x42480038UL))
#define bFM3_MFT_PPG_TTCR0_TRG6O               *((volatile unsigned int*)(0x4248003CUL))
#define bFM3_MFT_PPG_TTCR1_STR1                *((volatile unsigned int*)(0x42480420UL))
#define bFM3_MFT_PPG_TTCR1_MONI1               *((volatile unsigned int*)(0x42480424UL))
#define bFM3_MFT_PPG_TTCR1_CS10                *((volatile unsigned int*)(0x42480428UL))
#define bFM3_MFT_PPG_TTCR1_CS11                *((volatile unsigned int*)(0x4248042CUL))
#define bFM3_MFT_PPG_TTCR1_TRG1O               *((volatile unsigned int*)(0x42480430UL))
#define bFM3_MFT_PPG_TTCR1_TRG3O               *((volatile unsigned int*)(0x42480434UL))
#define bFM3_MFT_PPG_TTCR1_TRG5O               *((volatile unsigned int*)(0x42480438UL))
#define bFM3_MFT_PPG_TTCR1_TRG7O               *((volatile unsigned int*)(0x4248043CUL))
#define bFM3_MFT_PPG_TTCR2_STR2                *((volatile unsigned int*)(0x42480820UL))
#define bFM3_MFT_PPG_TTCR2_MONI2               *((volatile unsigned int*)(0x42480824UL))
#define bFM3_MFT_PPG_TTCR2_CS20                *((volatile unsigned int*)(0x42480828UL))
#define bFM3_MFT_PPG_TTCR2_CS21                *((volatile unsigned int*)(0x4248082CUL))
#define bFM3_MFT_PPG_TTCR2_TRG16O              *((volatile unsigned int*)(0x42480830UL))
#define bFM3_MFT_PPG_TTCR2_TRG18O              *((volatile unsigned int*)(0x42480834UL))
#define bFM3_MFT_PPG_TTCR2_TRG20O              *((volatile unsigned int*)(0x42480838UL))
#define bFM3_MFT_PPG_TTCR2_TRG22O              *((volatile unsigned int*)(0x4248083CUL))
#define bFM3_MFT_PPG_TRG_PEN00                 *((volatile unsigned int*)(0x42482000UL))
#define bFM3_MFT_PPG_TRG_PEN01                 *((volatile unsigned int*)(0x42482004UL))
#define bFM3_MFT_PPG_TRG_PEN02                 *((volatile unsigned int*)(0x42482008UL))
#define bFM3_MFT_PPG_TRG_PEN03                 *((volatile unsigned int*)(0x4248200CUL))
#define bFM3_MFT_PPG_TRG_PEN04                 *((volatile unsigned int*)(0x42482010UL))
#define bFM3_MFT_PPG_TRG_PEN05                 *((volatile unsigned int*)(0x42482014UL))
#define bFM3_MFT_PPG_TRG_PEN06                 *((volatile unsigned int*)(0x42482018UL))
#define bFM3_MFT_PPG_TRG_PEN07                 *((volatile unsigned int*)(0x4248201CUL))
#define bFM3_MFT_PPG_TRG_PEN08                 *((volatile unsigned int*)(0x42482020UL))
#define bFM3_MFT_PPG_TRG_PEN09                 *((volatile unsigned int*)(0x42482024UL))
#define bFM3_MFT_PPG_TRG_PEN10                 *((volatile unsigned int*)(0x42482028UL))
#define bFM3_MFT_PPG_TRG_PEN11                 *((volatile unsigned int*)(0x4248202CUL))
#define bFM3_MFT_PPG_TRG_PEN12                 *((volatile unsigned int*)(0x42482030UL))
#define bFM3_MFT_PPG_TRG_PEN13                 *((volatile unsigned int*)(0x42482034UL))
#define bFM3_MFT_PPG_TRG_PEN14                 *((volatile unsigned int*)(0x42482038UL))
#define bFM3_MFT_PPG_TRG_PEN15                 *((volatile unsigned int*)(0x4248203CUL))
#define bFM3_MFT_PPG_REVC_REV00                *((volatile unsigned int*)(0x42482080UL))
#define bFM3_MFT_PPG_REVC_REV01                *((volatile unsigned int*)(0x42482084UL))
#define bFM3_MFT_PPG_REVC_REV02                *((volatile unsigned int*)(0x42482088UL))
#define bFM3_MFT_PPG_REVC_REV03                *((volatile unsigned int*)(0x4248208CUL))
#define bFM3_MFT_PPG_REVC_REV04                *((volatile unsigned int*)(0x42482090UL))
#define bFM3_MFT_PPG_REVC_REV05                *((volatile unsigned int*)(0x42482094UL))
#define bFM3_MFT_PPG_REVC_REV06                *((volatile unsigned int*)(0x42482098UL))
#define bFM3_MFT_PPG_REVC_REV07                *((volatile unsigned int*)(0x4248209CUL))
#define bFM3_MFT_PPG_REVC_REV08                *((volatile unsigned int*)(0x424820A0UL))
#define bFM3_MFT_PPG_REVC_REV09                *((volatile unsigned int*)(0x424820A4UL))
#define bFM3_MFT_PPG_REVC_REV10                *((volatile unsigned int*)(0x424820A8UL))
#define bFM3_MFT_PPG_REVC_REV11                *((volatile unsigned int*)(0x424820ACUL))
#define bFM3_MFT_PPG_REVC_REV12                *((volatile unsigned int*)(0x424820B0UL))
#define bFM3_MFT_PPG_REVC_REV13                *((volatile unsigned int*)(0x424820B4UL))
#define bFM3_MFT_PPG_REVC_REV14                *((volatile unsigned int*)(0x424820B8UL))
#define bFM3_MFT_PPG_REVC_REV15                *((volatile unsigned int*)(0x424820BCUL))
#define bFM3_MFT_PPG_TRG1_PEN16                *((volatile unsigned int*)(0x42482800UL))
#define bFM3_MFT_PPG_TRG1_PEN17                *((volatile unsigned int*)(0x42482804UL))
#define bFM3_MFT_PPG_TRG1_PEN18                *((volatile unsigned int*)(0x42482808UL))
#define bFM3_MFT_PPG_TRG1_PEN19                *((volatile unsigned int*)(0x4248280CUL))
#define bFM3_MFT_PPG_TRG1_PEN20                *((volatile unsigned int*)(0x42482810UL))
#define bFM3_MFT_PPG_TRG1_PEN21                *((volatile unsigned int*)(0x42482814UL))
#define bFM3_MFT_PPG_TRG1_PEN22                *((volatile unsigned int*)(0x42482818UL))
#define bFM3_MFT_PPG_TRG1_PEN23                *((volatile unsigned int*)(0x4248281CUL))
#define bFM3_MFT_PPG_REVC1_REV16               *((volatile unsigned int*)(0x42482880UL))
#define bFM3_MFT_PPG_REVC1_REV17               *((volatile unsigned int*)(0x42482884UL))
#define bFM3_MFT_PPG_REVC1_REV18               *((volatile unsigned int*)(0x42482888UL))
#define bFM3_MFT_PPG_REVC1_REV19               *((volatile unsigned int*)(0x4248288CUL))
#define bFM3_MFT_PPG_REVC1_REV20               *((volatile unsigned int*)(0x42482890UL))
#define bFM3_MFT_PPG_REVC1_REV21               *((volatile unsigned int*)(0x42482894UL))
#define bFM3_MFT_PPG_REVC1_REV22               *((volatile unsigned int*)(0x42482898UL))
#define bFM3_MFT_PPG_REVC1_REV23               *((volatile unsigned int*)(0x4248289CUL))
#define bFM3_MFT_PPG_PPGC1_TTRG                *((volatile unsigned int*)(0x42484000UL))
#define bFM3_MFT_PPG_PPGC1_PCS0                *((volatile unsigned int*)(0x4248400CUL))
#define bFM3_MFT_PPG_PPGC1_PCS1                *((volatile unsigned int*)(0x42484010UL))
#define bFM3_MFT_PPG_PPGC1_INTM                *((volatile unsigned int*)(0x42484014UL))
#define bFM3_MFT_PPG_PPGC1_PUF                 *((volatile unsigned int*)(0x42484018UL))
#define bFM3_MFT_PPG_PPGC1_PIE                 *((volatile unsigned int*)(0x4248401CUL))
#define bFM3_MFT_PPG_PPGC0_TTRG                *((volatile unsigned int*)(0x42484020UL))
#define bFM3_MFT_PPG_PPGC0_PCS0                *((volatile unsigned int*)(0x4248402CUL))
#define bFM3_MFT_PPG_PPGC0_PCS1                *((volatile unsigned int*)(0x42484030UL))
#define bFM3_MFT_PPG_PPGC0_INTM                *((volatile unsigned int*)(0x42484034UL))
#define bFM3_MFT_PPG_PPGC0_PUF                 *((volatile unsigned int*)(0x42484038UL))
#define bFM3_MFT_PPG_PPGC0_PIE                 *((volatile unsigned int*)(0x4248403CUL))
#define bFM3_MFT_PPG_PPGC3_TTRG                *((volatile unsigned int*)(0x42484080UL))
#define bFM3_MFT_PPG_PPGC3_PCS0                *((volatile unsigned int*)(0x4248408CUL))
#define bFM3_MFT_PPG_PPGC3_PCS1                *((volatile unsigned int*)(0x42484090UL))
#define bFM3_MFT_PPG_PPGC3_INTM                *((volatile unsigned int*)(0x42484094UL))
#define bFM3_MFT_PPG_PPGC3_PUF                 *((volatile unsigned int*)(0x42484098UL))
#define bFM3_MFT_PPG_PPGC3_PIE                 *((volatile unsigned int*)(0x4248409CUL))
#define bFM3_MFT_PPG_PPGC2_TTRG                *((volatile unsigned int*)(0x424840A0UL))
#define bFM3_MFT_PPG_PPGC2_PCS0                *((volatile unsigned int*)(0x424840ACUL))
#define bFM3_MFT_PPG_PPGC2_PCS1                *((volatile unsigned int*)(0x424840B0UL))
#define bFM3_MFT_PPG_PPGC2_INTM                *((volatile unsigned int*)(0x424840B4UL))
#define bFM3_MFT_PPG_PPGC2_PUF                 *((volatile unsigned int*)(0x424840B8UL))
#define bFM3_MFT_PPG_PPGC2_PIE                 *((volatile unsigned int*)(0x424840BCUL))
#define bFM3_MFT_PPG_GATEC0_EDGE0              *((volatile unsigned int*)(0x42484300UL))
#define bFM3_MFT_PPG_GATEC0_STRG0              *((volatile unsigned int*)(0x42484304UL))
#define bFM3_MFT_PPG_GATEC0_EDGE2              *((volatile unsigned int*)(0x42484310UL))
#define bFM3_MFT_PPG_GATEC0_STRG2              *((volatile unsigned int*)(0x42484314UL))
#define bFM3_MFT_PPG_PPGC5_TTRG                *((volatile unsigned int*)(0x42484800UL))
#define bFM3_MFT_PPG_PPGC5_PCS0                *((volatile unsigned int*)(0x4248480CUL))
#define bFM3_MFT_PPG_PPGC5_PCS1                *((volatile unsigned int*)(0x42484810UL))
#define bFM3_MFT_PPG_PPGC5_INTM                *((volatile unsigned int*)(0x42484814UL))
#define bFM3_MFT_PPG_PPGC5_PUF                 *((volatile unsigned int*)(0x42484818UL))
#define bFM3_MFT_PPG_PPGC5_PIE                 *((volatile unsigned int*)(0x4248481CUL))
#define bFM3_MFT_PPG_PPGC4_TTRG                *((volatile unsigned int*)(0x42484820UL))
#define bFM3_MFT_PPG_PPGC4_PCS0                *((volatile unsigned int*)(0x4248482CUL))
#define bFM3_MFT_PPG_PPGC4_PCS1                *((volatile unsigned int*)(0x42484830UL))
#define bFM3_MFT_PPG_PPGC4_INTM                *((volatile unsigned int*)(0x42484834UL))
#define bFM3_MFT_PPG_PPGC4_PUF                 *((volatile unsigned int*)(0x42484838UL))
#define bFM3_MFT_PPG_PPGC4_PIE                 *((volatile unsigned int*)(0x4248483CUL))
#define bFM3_MFT_PPG_PPGC7_TTRG                *((volatile unsigned int*)(0x42484880UL))
#define bFM3_MFT_PPG_PPGC7_PCS0                *((volatile unsigned int*)(0x4248488CUL))
#define bFM3_MFT_PPG_PPGC7_PCS1                *((volatile unsigned int*)(0x42484890UL))
#define bFM3_MFT_PPG_PPGC7_INTM                *((volatile unsigned int*)(0x42484894UL))
#define bFM3_MFT_PPG_PPGC7_PUF                 *((volatile unsigned int*)(0x42484898UL))
#define bFM3_MFT_PPG_PPGC7_PIE                 *((volatile unsigned int*)(0x4248489CUL))
#define bFM3_MFT_PPG_PPGC6_TTRG                *((volatile unsigned int*)(0x424848A0UL))
#define bFM3_MFT_PPG_PPGC6_PCS0                *((volatile unsigned int*)(0x424848ACUL))
#define bFM3_MFT_PPG_PPGC6_PCS1                *((volatile unsigned int*)(0x424848B0UL))
#define bFM3_MFT_PPG_PPGC6_INTM                *((volatile unsigned int*)(0x424848B4UL))
#define bFM3_MFT_PPG_PPGC6_PUF                 *((volatile unsigned int*)(0x424848B8UL))
#define bFM3_MFT_PPG_PPGC6_PIE                 *((volatile unsigned int*)(0x424848BCUL))
#define bFM3_MFT_PPG_GATEC4_EDGE4              *((volatile unsigned int*)(0x42484B00UL))
#define bFM3_MFT_PPG_GATEC4_STRG4              *((volatile unsigned int*)(0x42484B04UL))
#define bFM3_MFT_PPG_GATEC4_EDGE6              *((volatile unsigned int*)(0x42484B10UL))
#define bFM3_MFT_PPG_GATEC4_STRG6              *((volatile unsigned int*)(0x42484B14UL))
#define bFM3_MFT_PPG_PPGC9_TTRG                *((volatile unsigned int*)(0x42485000UL))
#define bFM3_MFT_PPG_PPGC9_PCS0                *((volatile unsigned int*)(0x4248500CUL))
#define bFM3_MFT_PPG_PPGC9_PCS1                *((volatile unsigned int*)(0x42485010UL))
#define bFM3_MFT_PPG_PPGC9_INTM                *((volatile unsigned int*)(0x42485014UL))
#define bFM3_MFT_PPG_PPGC9_PUF                 *((volatile unsigned int*)(0x42485018UL))
#define bFM3_MFT_PPG_PPGC9_PIE                 *((volatile unsigned int*)(0x4248501CUL))
#define bFM3_MFT_PPG_PPGC8_TTRG                *((volatile unsigned int*)(0x42485020UL))
#define bFM3_MFT_PPG_PPGC8_PCS0                *((volatile unsigned int*)(0x4248502CUL))
#define bFM3_MFT_PPG_PPGC8_PCS1                *((volatile unsigned int*)(0x42485030UL))
#define bFM3_MFT_PPG_PPGC8_INTM                *((volatile unsigned int*)(0x42485034UL))
#define bFM3_MFT_PPG_PPGC8_PUF                 *((volatile unsigned int*)(0x42485038UL))
#define bFM3_MFT_PPG_PPGC8_PIE                 *((volatile unsigned int*)(0x4248503CUL))
#define bFM3_MFT_PPG_PPGC11_TTRG               *((volatile unsigned int*)(0x42485080UL))
#define bFM3_MFT_PPG_PPGC11_PCS0               *((volatile unsigned int*)(0x4248508CUL))
#define bFM3_MFT_PPG_PPGC11_PCS1               *((volatile unsigned int*)(0x42485090UL))
#define bFM3_MFT_PPG_PPGC11_INTM               *((volatile unsigned int*)(0x42485094UL))
#define bFM3_MFT_PPG_PPGC11_PUF                *((volatile unsigned int*)(0x42485098UL))
#define bFM3_MFT_PPG_PPGC11_PIE                *((volatile unsigned int*)(0x4248509CUL))
#define bFM3_MFT_PPG_PPGC10_TTRG               *((volatile unsigned int*)(0x424850A0UL))
#define bFM3_MFT_PPG_PPGC10_PCS0               *((volatile unsigned int*)(0x424850ACUL))
#define bFM3_MFT_PPG_PPGC10_PCS1               *((volatile unsigned int*)(0x424850B0UL))
#define bFM3_MFT_PPG_PPGC10_INTM               *((volatile unsigned int*)(0x424850B4UL))
#define bFM3_MFT_PPG_PPGC10_PUF                *((volatile unsigned int*)(0x424850B8UL))
#define bFM3_MFT_PPG_PPGC10_PIE                *((volatile unsigned int*)(0x424850BCUL))
#define bFM3_MFT_PPG_GATEC8_EDGE8              *((volatile unsigned int*)(0x42485300UL))
#define bFM3_MFT_PPG_GATEC8_STRG8              *((volatile unsigned int*)(0x42485304UL))
#define bFM3_MFT_PPG_GATEC8_EDGE10             *((volatile unsigned int*)(0x42485310UL))
#define bFM3_MFT_PPG_GATEC8_STRG10             *((volatile unsigned int*)(0x42485314UL))
#define bFM3_MFT_PPG_PPGC13_TTRG               *((volatile unsigned int*)(0x42485800UL))
#define bFM3_MFT_PPG_PPGC13_PCS0               *((volatile unsigned int*)(0x4248580CUL))
#define bFM3_MFT_PPG_PPGC13_PCS1               *((volatile unsigned int*)(0x42485810UL))
#define bFM3_MFT_PPG_PPGC13_INTM               *((volatile unsigned int*)(0x42485814UL))
#define bFM3_MFT_PPG_PPGC13_PUF                *((volatile unsigned int*)(0x42485818UL))
#define bFM3_MFT_PPG_PPGC13_PIE                *((volatile unsigned int*)(0x4248581CUL))
#define bFM3_MFT_PPG_PPGC12_TTRG               *((volatile unsigned int*)(0x42485820UL))
#define bFM3_MFT_PPG_PPGC12_PCS0               *((volatile unsigned int*)(0x4248582CUL))
#define bFM3_MFT_PPG_PPGC12_PCS1               *((volatile unsigned int*)(0x42485830UL))
#define bFM3_MFT_PPG_PPGC12_INTM               *((volatile unsigned int*)(0x42485834UL))
#define bFM3_MFT_PPG_PPGC12_PUF                *((volatile unsigned int*)(0x42485838UL))
#define bFM3_MFT_PPG_PPGC12_PIE                *((volatile unsigned int*)(0x4248583CUL))
#define bFM3_MFT_PPG_PPGC15_TTRG               *((volatile unsigned int*)(0x42485880UL))
#define bFM3_MFT_PPG_PPGC15_PCS0               *((volatile unsigned int*)(0x4248588CUL))
#define bFM3_MFT_PPG_PPGC15_PCS1               *((volatile unsigned int*)(0x42485890UL))
#define bFM3_MFT_PPG_PPGC15_INTM               *((volatile unsigned int*)(0x42485894UL))
#define bFM3_MFT_PPG_PPGC15_PUF                *((volatile unsigned int*)(0x42485898UL))
#define bFM3_MFT_PPG_PPGC15_PIE                *((volatile unsigned int*)(0x4248589CUL))
#define bFM3_MFT_PPG_PPGC14_TTRG               *((volatile unsigned int*)(0x424858A0UL))
#define bFM3_MFT_PPG_PPGC14_PCS0               *((volatile unsigned int*)(0x424858ACUL))
#define bFM3_MFT_PPG_PPGC14_PCS1               *((volatile unsigned int*)(0x424858B0UL))
#define bFM3_MFT_PPG_PPGC14_INTM               *((volatile unsigned int*)(0x424858B4UL))
#define bFM3_MFT_PPG_PPGC14_PUF                *((volatile unsigned int*)(0x424858B8UL))
#define bFM3_MFT_PPG_PPGC14_PIE                *((volatile unsigned int*)(0x424858BCUL))
#define bFM3_MFT_PPG_GATEC12_EDGE12            *((volatile unsigned int*)(0x42485B00UL))
#define bFM3_MFT_PPG_GATEC12_STRG12            *((volatile unsigned int*)(0x42485B04UL))
#define bFM3_MFT_PPG_GATEC12_EDGE14            *((volatile unsigned int*)(0x42485B10UL))
#define bFM3_MFT_PPG_GATEC12_STRG14            *((volatile unsigned int*)(0x42485B14UL))
#define bFM3_MFT_PPG_PPGC17_TTRG               *((volatile unsigned int*)(0x42486000UL))
#define bFM3_MFT_PPG_PPGC17_PCS0               *((volatile unsigned int*)(0x4248600CUL))
#define bFM3_MFT_PPG_PPGC17_PCS1               *((volatile unsigned int*)(0x42486010UL))
#define bFM3_MFT_PPG_PPGC17_INTM               *((volatile unsigned int*)(0x42486014UL))
#define bFM3_MFT_PPG_PPGC17_PUF                *((volatile unsigned int*)(0x42486018UL))
#define bFM3_MFT_PPG_PPGC17_PIE                *((volatile unsigned int*)(0x4248601CUL))
#define bFM3_MFT_PPG_PPGC16_TTRG               *((volatile unsigned int*)(0x42486020UL))
#define bFM3_MFT_PPG_PPGC16_PCS0               *((volatile unsigned int*)(0x4248602CUL))
#define bFM3_MFT_PPG_PPGC16_PCS1               *((volatile unsigned int*)(0x42486030UL))
#define bFM3_MFT_PPG_PPGC16_INTM               *((volatile unsigned int*)(0x42486034UL))
#define bFM3_MFT_PPG_PPGC16_PUF                *((volatile unsigned int*)(0x42486038UL))
#define bFM3_MFT_PPG_PPGC16_PIE                *((volatile unsigned int*)(0x4248603CUL))
#define bFM3_MFT_PPG_PPGC19_TTRG               *((volatile unsigned int*)(0x42486080UL))
#define bFM3_MFT_PPG_PPGC19_PCS0               *((volatile unsigned int*)(0x4248608CUL))
#define bFM3_MFT_PPG_PPGC19_PCS1               *((volatile unsigned int*)(0x42486090UL))
#define bFM3_MFT_PPG_PPGC19_INTM               *((volatile unsigned int*)(0x42486094UL))
#define bFM3_MFT_PPG_PPGC19_PUF                *((volatile unsigned int*)(0x42486098UL))
#define bFM3_MFT_PPG_PPGC19_PIE                *((volatile unsigned int*)(0x4248609CUL))
#define bFM3_MFT_PPG_PPGC18_TTRG               *((volatile unsigned int*)(0x424860A0UL))
#define bFM3_MFT_PPG_PPGC18_PCS0               *((volatile unsigned int*)(0x424860ACUL))
#define bFM3_MFT_PPG_PPGC18_PCS1               *((volatile unsigned int*)(0x424860B0UL))
#define bFM3_MFT_PPG_PPGC18_INTM               *((volatile unsigned int*)(0x424860B4UL))
#define bFM3_MFT_PPG_PPGC18_PUF                *((volatile unsigned int*)(0x424860B8UL))
#define bFM3_MFT_PPG_PPGC18_PIE                *((volatile unsigned int*)(0x424860BCUL))
#define bFM3_MFT_PPG_GATEC16_EDGE16            *((volatile unsigned int*)(0x42486300UL))
#define bFM3_MFT_PPG_GATEC16_STRG16            *((volatile unsigned int*)(0x42486304UL))
#define bFM3_MFT_PPG_GATEC16_EDGE18            *((volatile unsigned int*)(0x42486310UL))
#define bFM3_MFT_PPG_GATEC16_STRG18            *((volatile unsigned int*)(0x42486314UL))
#define bFM3_MFT_PPG_PPGC21_TTRG               *((volatile unsigned int*)(0x42486800UL))
#define bFM3_MFT_PPG_PPGC21_PCS0               *((volatile unsigned int*)(0x4248680CUL))
#define bFM3_MFT_PPG_PPGC21_PCS1               *((volatile unsigned int*)(0x42486810UL))
#define bFM3_MFT_PPG_PPGC21_INTM               *((volatile unsigned int*)(0x42486814UL))
#define bFM3_MFT_PPG_PPGC21_PUF                *((volatile unsigned int*)(0x42486818UL))
#define bFM3_MFT_PPG_PPGC21_PIE                *((volatile unsigned int*)(0x4248681CUL))
#define bFM3_MFT_PPG_PPGC20_TTRG               *((volatile unsigned int*)(0x42486820UL))
#define bFM3_MFT_PPG_PPGC20_PCS0               *((volatile unsigned int*)(0x4248682CUL))
#define bFM3_MFT_PPG_PPGC20_PCS1               *((volatile unsigned int*)(0x42486830UL))
#define bFM3_MFT_PPG_PPGC20_INTM               *((volatile unsigned int*)(0x42486834UL))
#define bFM3_MFT_PPG_PPGC20_PUF                *((volatile unsigned int*)(0x42486838UL))
#define bFM3_MFT_PPG_PPGC20_PIE                *((volatile unsigned int*)(0x4248683CUL))
#define bFM3_MFT_PPG_PPGC23_TTRG               *((volatile unsigned int*)(0x42486880UL))
#define bFM3_MFT_PPG_PPGC23_PCS0               *((volatile unsigned int*)(0x4248688CUL))
#define bFM3_MFT_PPG_PPGC23_PCS1               *((volatile unsigned int*)(0x42486890UL))
#define bFM3_MFT_PPG_PPGC23_INTM               *((volatile unsigned int*)(0x42486894UL))
#define bFM3_MFT_PPG_PPGC23_PUF                *((volatile unsigned int*)(0x42486898UL))
#define bFM3_MFT_PPG_PPGC23_PIE                *((volatile unsigned int*)(0x4248689CUL))
#define bFM3_MFT_PPG_PPGC22_TTRG               *((volatile unsigned int*)(0x424868A0UL))
#define bFM3_MFT_PPG_PPGC22_PCS0               *((volatile unsigned int*)(0x424868ACUL))
#define bFM3_MFT_PPG_PPGC22_PCS1               *((volatile unsigned int*)(0x424868B0UL))
#define bFM3_MFT_PPG_PPGC22_INTM               *((volatile unsigned int*)(0x424868B4UL))
#define bFM3_MFT_PPG_PPGC22_PUF                *((volatile unsigned int*)(0x424868B8UL))
#define bFM3_MFT_PPG_PPGC22_PIE                *((volatile unsigned int*)(0x424868BCUL))
#define bFM3_MFT_PPG_GATEC20_EDGE20            *((volatile unsigned int*)(0x42486B00UL))
#define bFM3_MFT_PPG_GATEC20_STRG20            *((volatile unsigned int*)(0x42486B04UL))
#define bFM3_MFT_PPG_GATEC20_EDGE22            *((volatile unsigned int*)(0x42486B10UL))
#define bFM3_MFT_PPG_GATEC20_STRG22            *((volatile unsigned int*)(0x42486B14UL))

/* Base Timer 0 PPG registers */
#define bFM3_BT0_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A0180UL))
#define bFM3_BT0_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A0184UL))
#define bFM3_BT0_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A0188UL))
#define bFM3_BT0_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A018CUL))
#define bFM3_BT0_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A01A0UL))
#define bFM3_BT0_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A01A4UL))
#define bFM3_BT0_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A01A8UL))
#define bFM3_BT0_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A01ACUL))
#define bFM3_BT0_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A01B0UL))
#define bFM3_BT0_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A01B4UL))
#define bFM3_BT0_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A01B8UL))
#define bFM3_BT0_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A0200UL))
#define bFM3_BT0_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A0208UL))
#define bFM3_BT0_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A0210UL))
#define bFM3_BT0_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A0218UL))
#define bFM3_BT0_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A0220UL))

/* Base Timer 0 PWM registers */
#define bFM3_BT0_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A0180UL))
#define bFM3_BT0_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A0184UL))
#define bFM3_BT0_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A0188UL))
#define bFM3_BT0_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A018CUL))
#define bFM3_BT0_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A01A0UL))
#define bFM3_BT0_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A01A4UL))
#define bFM3_BT0_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A01A8UL))
#define bFM3_BT0_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A01ACUL))
#define bFM3_BT0_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A01B0UL))
#define bFM3_BT0_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A01B4UL))
#define bFM3_BT0_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A01B8UL))
#define bFM3_BT0_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A0200UL))
#define bFM3_BT0_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A0204UL))
#define bFM3_BT0_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A0208UL))
#define bFM3_BT0_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A0210UL))
#define bFM3_BT0_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A0214UL))
#define bFM3_BT0_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A0218UL))
#define bFM3_BT0_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A0220UL))

/* Base Timer 0 RT registers */
#define bFM3_BT0_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A0180UL))
#define bFM3_BT0_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A0184UL))
#define bFM3_BT0_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A0188UL))
#define bFM3_BT0_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A018CUL))
#define bFM3_BT0_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A019CUL))
#define bFM3_BT0_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A01A0UL))
#define bFM3_BT0_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A01A4UL))
#define bFM3_BT0_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A01B0UL))
#define bFM3_BT0_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A01B4UL))
#define bFM3_BT0_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A01B8UL))
#define bFM3_BT0_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A0200UL))
#define bFM3_BT0_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A0208UL))
#define bFM3_BT0_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A0210UL))
#define bFM3_BT0_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A0218UL))
#define bFM3_BT0_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A0220UL))

/* Base Timer 0 PWC registers */
#define bFM3_BT0_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A0184UL))
#define bFM3_BT0_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A0188UL))
#define bFM3_BT0_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A019CUL))
#define bFM3_BT0_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A01A0UL))
#define bFM3_BT0_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A01A4UL))
#define bFM3_BT0_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A01A8UL))
#define bFM3_BT0_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A01B0UL))
#define bFM3_BT0_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A01B4UL))
#define bFM3_BT0_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A01B8UL))
#define bFM3_BT0_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A0200UL))
#define bFM3_BT0_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A0208UL))
#define bFM3_BT0_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A0210UL))
#define bFM3_BT0_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A0218UL))
#define bFM3_BT0_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A021CUL))
#define bFM3_BT0_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A0220UL))

/* Base Timer 1 PPG registers */
#define bFM3_BT1_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A0980UL))
#define bFM3_BT1_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A0984UL))
#define bFM3_BT1_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A0988UL))
#define bFM3_BT1_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A098CUL))
#define bFM3_BT1_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A09A0UL))
#define bFM3_BT1_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A09A4UL))
#define bFM3_BT1_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A09A8UL))
#define bFM3_BT1_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A09ACUL))
#define bFM3_BT1_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A09B0UL))
#define bFM3_BT1_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A09B4UL))
#define bFM3_BT1_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A09B8UL))
#define bFM3_BT1_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A0A00UL))
#define bFM3_BT1_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A0A08UL))
#define bFM3_BT1_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A0A10UL))
#define bFM3_BT1_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A0A18UL))
#define bFM3_BT1_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A0A20UL))

/* Base Timer 1 PWM registers */
#define bFM3_BT1_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A0980UL))
#define bFM3_BT1_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A0984UL))
#define bFM3_BT1_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A0988UL))
#define bFM3_BT1_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A098CUL))
#define bFM3_BT1_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A09A0UL))
#define bFM3_BT1_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A09A4UL))
#define bFM3_BT1_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A09A8UL))
#define bFM3_BT1_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A09ACUL))
#define bFM3_BT1_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A09B0UL))
#define bFM3_BT1_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A09B4UL))
#define bFM3_BT1_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A09B8UL))
#define bFM3_BT1_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A0A00UL))
#define bFM3_BT1_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A0A04UL))
#define bFM3_BT1_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A0A08UL))
#define bFM3_BT1_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A0A10UL))
#define bFM3_BT1_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A0A14UL))
#define bFM3_BT1_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A0A18UL))
#define bFM3_BT1_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A0A20UL))

/* Base Timer 1 RT registers */
#define bFM3_BT1_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A0980UL))
#define bFM3_BT1_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A0984UL))
#define bFM3_BT1_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A0988UL))
#define bFM3_BT1_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A098CUL))
#define bFM3_BT1_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A099CUL))
#define bFM3_BT1_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A09A0UL))
#define bFM3_BT1_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A09A4UL))
#define bFM3_BT1_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A09B0UL))
#define bFM3_BT1_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A09B4UL))
#define bFM3_BT1_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A09B8UL))
#define bFM3_BT1_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A0A00UL))
#define bFM3_BT1_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A0A08UL))
#define bFM3_BT1_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A0A10UL))
#define bFM3_BT1_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A0A18UL))
#define bFM3_BT1_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A0A20UL))

/* Base Timer 1 PWC registers */
#define bFM3_BT1_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A0984UL))
#define bFM3_BT1_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A0988UL))
#define bFM3_BT1_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A099CUL))
#define bFM3_BT1_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A09A0UL))
#define bFM3_BT1_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A09A4UL))
#define bFM3_BT1_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A09A8UL))
#define bFM3_BT1_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A09B0UL))
#define bFM3_BT1_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A09B4UL))
#define bFM3_BT1_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A09B8UL))
#define bFM3_BT1_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A0A00UL))
#define bFM3_BT1_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A0A08UL))
#define bFM3_BT1_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A0A10UL))
#define bFM3_BT1_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A0A18UL))
#define bFM3_BT1_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A0A1CUL))
#define bFM3_BT1_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A0A20UL))

/* Base Timer 2 PPG registers */
#define bFM3_BT2_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A1180UL))
#define bFM3_BT2_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A1184UL))
#define bFM3_BT2_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A1188UL))
#define bFM3_BT2_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A118CUL))
#define bFM3_BT2_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A11A0UL))
#define bFM3_BT2_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A11A4UL))
#define bFM3_BT2_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A11A8UL))
#define bFM3_BT2_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A11ACUL))
#define bFM3_BT2_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A11B0UL))
#define bFM3_BT2_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A11B4UL))
#define bFM3_BT2_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A11B8UL))
#define bFM3_BT2_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A1200UL))
#define bFM3_BT2_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A1208UL))
#define bFM3_BT2_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A1210UL))
#define bFM3_BT2_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A1218UL))
#define bFM3_BT2_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A1220UL))

/* Base Timer 2 PWM registers */
#define bFM3_BT2_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A1180UL))
#define bFM3_BT2_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A1184UL))
#define bFM3_BT2_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A1188UL))
#define bFM3_BT2_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A118CUL))
#define bFM3_BT2_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A11A0UL))
#define bFM3_BT2_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A11A4UL))
#define bFM3_BT2_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A11A8UL))
#define bFM3_BT2_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A11ACUL))
#define bFM3_BT2_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A11B0UL))
#define bFM3_BT2_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A11B4UL))
#define bFM3_BT2_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A11B8UL))
#define bFM3_BT2_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A1200UL))
#define bFM3_BT2_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A1204UL))
#define bFM3_BT2_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A1208UL))
#define bFM3_BT2_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A1210UL))
#define bFM3_BT2_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A1214UL))
#define bFM3_BT2_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A1218UL))
#define bFM3_BT2_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A1220UL))

/* Base Timer 2 RT registers */
#define bFM3_BT2_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A1180UL))
#define bFM3_BT2_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A1184UL))
#define bFM3_BT2_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A1188UL))
#define bFM3_BT2_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A118CUL))
#define bFM3_BT2_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A119CUL))
#define bFM3_BT2_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A11A0UL))
#define bFM3_BT2_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A11A4UL))
#define bFM3_BT2_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A11B0UL))
#define bFM3_BT2_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A11B4UL))
#define bFM3_BT2_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A11B8UL))
#define bFM3_BT2_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A1200UL))
#define bFM3_BT2_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A1208UL))
#define bFM3_BT2_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A1210UL))
#define bFM3_BT2_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A1218UL))
#define bFM3_BT2_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A1220UL))

/* Base Timer 2 PWC registers */
#define bFM3_BT2_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A1184UL))
#define bFM3_BT2_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A1188UL))
#define bFM3_BT2_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A119CUL))
#define bFM3_BT2_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A11A0UL))
#define bFM3_BT2_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A11A4UL))
#define bFM3_BT2_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A11A8UL))
#define bFM3_BT2_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A11B0UL))
#define bFM3_BT2_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A11B4UL))
#define bFM3_BT2_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A11B8UL))
#define bFM3_BT2_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A1200UL))
#define bFM3_BT2_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A1208UL))
#define bFM3_BT2_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A1210UL))
#define bFM3_BT2_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A1218UL))
#define bFM3_BT2_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A121CUL))
#define bFM3_BT2_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A1220UL))

/* Base Timer 3 PPG registers */
#define bFM3_BT3_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A1980UL))
#define bFM3_BT3_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A1984UL))
#define bFM3_BT3_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A1988UL))
#define bFM3_BT3_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A198CUL))
#define bFM3_BT3_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A19A0UL))
#define bFM3_BT3_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A19A4UL))
#define bFM3_BT3_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A19A8UL))
#define bFM3_BT3_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A19ACUL))
#define bFM3_BT3_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A19B0UL))
#define bFM3_BT3_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A19B4UL))
#define bFM3_BT3_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A19B8UL))
#define bFM3_BT3_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A1A00UL))
#define bFM3_BT3_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A1A08UL))
#define bFM3_BT3_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A1A10UL))
#define bFM3_BT3_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A1A18UL))
#define bFM3_BT3_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A1A20UL))

/* Base Timer 3 PWM registers */
#define bFM3_BT3_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A1980UL))
#define bFM3_BT3_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A1984UL))
#define bFM3_BT3_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A1988UL))
#define bFM3_BT3_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A198CUL))
#define bFM3_BT3_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A19A0UL))
#define bFM3_BT3_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A19A4UL))
#define bFM3_BT3_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A19A8UL))
#define bFM3_BT3_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A19ACUL))
#define bFM3_BT3_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A19B0UL))
#define bFM3_BT3_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A19B4UL))
#define bFM3_BT3_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A19B8UL))
#define bFM3_BT3_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A1A00UL))
#define bFM3_BT3_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A1A04UL))
#define bFM3_BT3_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A1A08UL))
#define bFM3_BT3_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A1A10UL))
#define bFM3_BT3_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A1A14UL))
#define bFM3_BT3_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A1A18UL))
#define bFM3_BT3_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A1A20UL))

/* Base Timer 3 RT registers */
#define bFM3_BT3_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A1980UL))
#define bFM3_BT3_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A1984UL))
#define bFM3_BT3_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A1988UL))
#define bFM3_BT3_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A198CUL))
#define bFM3_BT3_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A199CUL))
#define bFM3_BT3_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A19A0UL))
#define bFM3_BT3_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A19A4UL))
#define bFM3_BT3_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A19B0UL))
#define bFM3_BT3_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A19B4UL))
#define bFM3_BT3_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A19B8UL))
#define bFM3_BT3_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A1A00UL))
#define bFM3_BT3_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A1A08UL))
#define bFM3_BT3_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A1A10UL))
#define bFM3_BT3_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A1A18UL))
#define bFM3_BT3_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A1A20UL))

/* Base Timer 3 PWC registers */
#define bFM3_BT3_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A1984UL))
#define bFM3_BT3_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A1988UL))
#define bFM3_BT3_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A199CUL))
#define bFM3_BT3_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A19A0UL))
#define bFM3_BT3_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A19A4UL))
#define bFM3_BT3_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A19A8UL))
#define bFM3_BT3_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A19B0UL))
#define bFM3_BT3_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A19B4UL))
#define bFM3_BT3_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A19B8UL))
#define bFM3_BT3_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A1A00UL))
#define bFM3_BT3_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A1A08UL))
#define bFM3_BT3_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A1A10UL))
#define bFM3_BT3_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A1A18UL))
#define bFM3_BT3_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A1A1CUL))
#define bFM3_BT3_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A1A20UL))

/* Base Timer 4 PPG registers */
#define bFM3_BT4_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A4180UL))
#define bFM3_BT4_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A4184UL))
#define bFM3_BT4_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A4188UL))
#define bFM3_BT4_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A418CUL))
#define bFM3_BT4_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A41A0UL))
#define bFM3_BT4_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A41A4UL))
#define bFM3_BT4_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A41A8UL))
#define bFM3_BT4_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A41ACUL))
#define bFM3_BT4_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A41B0UL))
#define bFM3_BT4_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A41B4UL))
#define bFM3_BT4_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A41B8UL))
#define bFM3_BT4_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A4200UL))
#define bFM3_BT4_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A4208UL))
#define bFM3_BT4_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A4210UL))
#define bFM3_BT4_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A4218UL))
#define bFM3_BT4_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A4220UL))

/* Base Timer 4 PWM registers */
#define bFM3_BT4_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A4180UL))
#define bFM3_BT4_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A4184UL))
#define bFM3_BT4_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A4188UL))
#define bFM3_BT4_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A418CUL))
#define bFM3_BT4_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A41A0UL))
#define bFM3_BT4_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A41A4UL))
#define bFM3_BT4_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A41A8UL))
#define bFM3_BT4_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A41ACUL))
#define bFM3_BT4_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A41B0UL))
#define bFM3_BT4_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A41B4UL))
#define bFM3_BT4_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A41B8UL))
#define bFM3_BT4_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A4200UL))
#define bFM3_BT4_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A4204UL))
#define bFM3_BT4_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A4208UL))
#define bFM3_BT4_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A4210UL))
#define bFM3_BT4_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A4214UL))
#define bFM3_BT4_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A4218UL))
#define bFM3_BT4_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A4220UL))

/* Base Timer 4 RT registers */
#define bFM3_BT4_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A4180UL))
#define bFM3_BT4_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A4184UL))
#define bFM3_BT4_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A4188UL))
#define bFM3_BT4_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A418CUL))
#define bFM3_BT4_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A419CUL))
#define bFM3_BT4_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A41A0UL))
#define bFM3_BT4_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A41A4UL))
#define bFM3_BT4_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A41B0UL))
#define bFM3_BT4_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A41B4UL))
#define bFM3_BT4_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A41B8UL))
#define bFM3_BT4_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A4200UL))
#define bFM3_BT4_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A4208UL))
#define bFM3_BT4_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A4210UL))
#define bFM3_BT4_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A4218UL))
#define bFM3_BT4_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A4220UL))

/* Base Timer 4 PWC registers */
#define bFM3_BT4_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A4184UL))
#define bFM3_BT4_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A4188UL))
#define bFM3_BT4_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A419CUL))
#define bFM3_BT4_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A41A0UL))
#define bFM3_BT4_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A41A4UL))
#define bFM3_BT4_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A41A8UL))
#define bFM3_BT4_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A41B0UL))
#define bFM3_BT4_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A41B4UL))
#define bFM3_BT4_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A41B8UL))
#define bFM3_BT4_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A4200UL))
#define bFM3_BT4_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A4208UL))
#define bFM3_BT4_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A4210UL))
#define bFM3_BT4_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A4218UL))
#define bFM3_BT4_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A421CUL))
#define bFM3_BT4_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A4220UL))

/* Base Timer 5 PPG registers */
#define bFM3_BT5_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A4980UL))
#define bFM3_BT5_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A4984UL))
#define bFM3_BT5_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A4988UL))
#define bFM3_BT5_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A498CUL))
#define bFM3_BT5_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A49A0UL))
#define bFM3_BT5_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A49A4UL))
#define bFM3_BT5_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A49A8UL))
#define bFM3_BT5_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A49ACUL))
#define bFM3_BT5_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A49B0UL))
#define bFM3_BT5_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A49B4UL))
#define bFM3_BT5_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A49B8UL))
#define bFM3_BT5_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A4A00UL))
#define bFM3_BT5_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A4A08UL))
#define bFM3_BT5_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A4A10UL))
#define bFM3_BT5_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A4A18UL))
#define bFM3_BT5_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A4A20UL))

/* Base Timer 5 PWM registers */
#define bFM3_BT5_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A4980UL))
#define bFM3_BT5_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A4984UL))
#define bFM3_BT5_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A4988UL))
#define bFM3_BT5_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A498CUL))
#define bFM3_BT5_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A49A0UL))
#define bFM3_BT5_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A49A4UL))
#define bFM3_BT5_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A49A8UL))
#define bFM3_BT5_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A49ACUL))
#define bFM3_BT5_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A49B0UL))
#define bFM3_BT5_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A49B4UL))
#define bFM3_BT5_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A49B8UL))
#define bFM3_BT5_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A4A00UL))
#define bFM3_BT5_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A4A04UL))
#define bFM3_BT5_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A4A08UL))
#define bFM3_BT5_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A4A10UL))
#define bFM3_BT5_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A4A14UL))
#define bFM3_BT5_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A4A18UL))
#define bFM3_BT5_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A4A20UL))

/* Base Timer 5 RT registers */
#define bFM3_BT5_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A4980UL))
#define bFM3_BT5_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A4984UL))
#define bFM3_BT5_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A4988UL))
#define bFM3_BT5_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A498CUL))
#define bFM3_BT5_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A499CUL))
#define bFM3_BT5_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A49A0UL))
#define bFM3_BT5_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A49A4UL))
#define bFM3_BT5_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A49B0UL))
#define bFM3_BT5_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A49B4UL))
#define bFM3_BT5_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A49B8UL))
#define bFM3_BT5_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A4A00UL))
#define bFM3_BT5_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A4A08UL))
#define bFM3_BT5_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A4A10UL))
#define bFM3_BT5_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A4A18UL))
#define bFM3_BT5_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A4A20UL))

/* Base Timer 5 PWC registers */
#define bFM3_BT5_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A4984UL))
#define bFM3_BT5_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A4988UL))
#define bFM3_BT5_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A499CUL))
#define bFM3_BT5_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A49A0UL))
#define bFM3_BT5_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A49A4UL))
#define bFM3_BT5_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A49A8UL))
#define bFM3_BT5_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A49B0UL))
#define bFM3_BT5_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A49B4UL))
#define bFM3_BT5_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A49B8UL))
#define bFM3_BT5_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A4A00UL))
#define bFM3_BT5_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A4A08UL))
#define bFM3_BT5_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A4A10UL))
#define bFM3_BT5_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A4A18UL))
#define bFM3_BT5_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A4A1CUL))
#define bFM3_BT5_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A4A20UL))

/* Base Timer 6 PPG registers */
#define bFM3_BT6_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A5180UL))
#define bFM3_BT6_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A5184UL))
#define bFM3_BT6_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A5188UL))
#define bFM3_BT6_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A518CUL))
#define bFM3_BT6_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A51A0UL))
#define bFM3_BT6_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A51A4UL))
#define bFM3_BT6_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A51A8UL))
#define bFM3_BT6_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A51ACUL))
#define bFM3_BT6_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A51B0UL))
#define bFM3_BT6_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A51B4UL))
#define bFM3_BT6_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A51B8UL))
#define bFM3_BT6_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A5200UL))
#define bFM3_BT6_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A5208UL))
#define bFM3_BT6_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A5210UL))
#define bFM3_BT6_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A5218UL))
#define bFM3_BT6_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A5220UL))

/* Base Timer 6 PWM registers */
#define bFM3_BT6_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A5180UL))
#define bFM3_BT6_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A5184UL))
#define bFM3_BT6_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A5188UL))
#define bFM3_BT6_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A518CUL))
#define bFM3_BT6_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A51A0UL))
#define bFM3_BT6_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A51A4UL))
#define bFM3_BT6_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A51A8UL))
#define bFM3_BT6_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A51ACUL))
#define bFM3_BT6_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A51B0UL))
#define bFM3_BT6_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A51B4UL))
#define bFM3_BT6_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A51B8UL))
#define bFM3_BT6_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A5200UL))
#define bFM3_BT6_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A5204UL))
#define bFM3_BT6_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A5208UL))
#define bFM3_BT6_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A5210UL))
#define bFM3_BT6_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A5214UL))
#define bFM3_BT6_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A5218UL))
#define bFM3_BT6_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A5220UL))

/* Base Timer 6 RT registers */
#define bFM3_BT6_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A5180UL))
#define bFM3_BT6_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A5184UL))
#define bFM3_BT6_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A5188UL))
#define bFM3_BT6_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A518CUL))
#define bFM3_BT6_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A519CUL))
#define bFM3_BT6_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A51A0UL))
#define bFM3_BT6_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A51A4UL))
#define bFM3_BT6_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A51B0UL))
#define bFM3_BT6_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A51B4UL))
#define bFM3_BT6_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A51B8UL))
#define bFM3_BT6_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A5200UL))
#define bFM3_BT6_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A5208UL))
#define bFM3_BT6_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A5210UL))
#define bFM3_BT6_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A5218UL))
#define bFM3_BT6_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A5220UL))

/* Base Timer 6 PWC registers */
#define bFM3_BT6_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A5184UL))
#define bFM3_BT6_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A5188UL))
#define bFM3_BT6_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A519CUL))
#define bFM3_BT6_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A51A0UL))
#define bFM3_BT6_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A51A4UL))
#define bFM3_BT6_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A51A8UL))
#define bFM3_BT6_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A51B0UL))
#define bFM3_BT6_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A51B4UL))
#define bFM3_BT6_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A51B8UL))
#define bFM3_BT6_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A5200UL))
#define bFM3_BT6_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A5208UL))
#define bFM3_BT6_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A5210UL))
#define bFM3_BT6_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A5218UL))
#define bFM3_BT6_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A521CUL))
#define bFM3_BT6_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A5220UL))

/* Base Timer 7 PPG registers */
#define bFM3_BT7_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A5980UL))
#define bFM3_BT7_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A5984UL))
#define bFM3_BT7_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A5988UL))
#define bFM3_BT7_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A598CUL))
#define bFM3_BT7_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A59A0UL))
#define bFM3_BT7_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A59A4UL))
#define bFM3_BT7_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A59A8UL))
#define bFM3_BT7_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A59ACUL))
#define bFM3_BT7_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A59B0UL))
#define bFM3_BT7_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A59B4UL))
#define bFM3_BT7_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A59B8UL))
#define bFM3_BT7_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A5A00UL))
#define bFM3_BT7_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A5A08UL))
#define bFM3_BT7_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A5A10UL))
#define bFM3_BT7_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A5A18UL))
#define bFM3_BT7_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A5A20UL))

/* Base Timer 7 PWM registers */
#define bFM3_BT7_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A5980UL))
#define bFM3_BT7_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A5984UL))
#define bFM3_BT7_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A5988UL))
#define bFM3_BT7_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A598CUL))
#define bFM3_BT7_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A59A0UL))
#define bFM3_BT7_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A59A4UL))
#define bFM3_BT7_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A59A8UL))
#define bFM3_BT7_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A59ACUL))
#define bFM3_BT7_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A59B0UL))
#define bFM3_BT7_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A59B4UL))
#define bFM3_BT7_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A59B8UL))
#define bFM3_BT7_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A5A00UL))
#define bFM3_BT7_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A5A04UL))
#define bFM3_BT7_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A5A08UL))
#define bFM3_BT7_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A5A10UL))
#define bFM3_BT7_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A5A14UL))
#define bFM3_BT7_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A5A18UL))
#define bFM3_BT7_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A5A20UL))

/* Base Timer 7 RT registers */
#define bFM3_BT7_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A5980UL))
#define bFM3_BT7_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A5984UL))
#define bFM3_BT7_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A5988UL))
#define bFM3_BT7_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A598CUL))
#define bFM3_BT7_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A599CUL))
#define bFM3_BT7_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A59A0UL))
#define bFM3_BT7_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A59A4UL))
#define bFM3_BT7_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A59B0UL))
#define bFM3_BT7_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A59B4UL))
#define bFM3_BT7_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A59B8UL))
#define bFM3_BT7_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A5A00UL))
#define bFM3_BT7_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A5A08UL))
#define bFM3_BT7_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A5A10UL))
#define bFM3_BT7_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A5A18UL))
#define bFM3_BT7_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A5A20UL))

/* Base Timer 7 PWC registers */
#define bFM3_BT7_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A5984UL))
#define bFM3_BT7_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A5988UL))
#define bFM3_BT7_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A599CUL))
#define bFM3_BT7_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A59A0UL))
#define bFM3_BT7_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A59A4UL))
#define bFM3_BT7_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A59A8UL))
#define bFM3_BT7_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A59B0UL))
#define bFM3_BT7_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A59B4UL))
#define bFM3_BT7_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A59B8UL))
#define bFM3_BT7_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A5A00UL))
#define bFM3_BT7_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A5A08UL))
#define bFM3_BT7_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A5A10UL))
#define bFM3_BT7_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A5A18UL))
#define bFM3_BT7_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A5A1CUL))
#define bFM3_BT7_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A5A20UL))

/* Base Timer I/O selector channel 0 - channel 3 registers */
#define bFM3_BTIOSEL03_BTSEL0123_SEL01_0       *((volatile unsigned int*)(0x424A2020UL))
#define bFM3_BTIOSEL03_BTSEL0123_SEL01_1       *((volatile unsigned int*)(0x424A2024UL))
#define bFM3_BTIOSEL03_BTSEL0123_SEL01_2       *((volatile unsigned int*)(0x424A2028UL))
#define bFM3_BTIOSEL03_BTSEL0123_SEL01_3       *((volatile unsigned int*)(0x424A202CUL))
#define bFM3_BTIOSEL03_BTSEL0123_SEL23_0       *((volatile unsigned int*)(0x424A2030UL))
#define bFM3_BTIOSEL03_BTSEL0123_SEL23_1       *((volatile unsigned int*)(0x424A2034UL))
#define bFM3_BTIOSEL03_BTSEL0123_SEL23_2       *((volatile unsigned int*)(0x424A2038UL))
#define bFM3_BTIOSEL03_BTSEL0123_SEL23_3       *((volatile unsigned int*)(0x424A203CUL))

/* Base Timer I/O selector channel 4 - channel 7 registers */
#define bFM3_BTIOSEL47_BTSEL4567_SEL45_0       *((volatile unsigned int*)(0x424A6020UL))
#define bFM3_BTIOSEL47_BTSEL4567_SEL45_1       *((volatile unsigned int*)(0x424A6024UL))
#define bFM3_BTIOSEL47_BTSEL4567_SEL45_2       *((volatile unsigned int*)(0x424A6028UL))
#define bFM3_BTIOSEL47_BTSEL4567_SEL45_3       *((volatile unsigned int*)(0x424A602CUL))
#define bFM3_BTIOSEL47_BTSEL4567_SEL67_0       *((volatile unsigned int*)(0x424A6030UL))
#define bFM3_BTIOSEL47_BTSEL4567_SEL67_1       *((volatile unsigned int*)(0x424A6034UL))
#define bFM3_BTIOSEL47_BTSEL4567_SEL67_2       *((volatile unsigned int*)(0x424A6038UL))
#define bFM3_BTIOSEL47_BTSEL4567_SEL67_3       *((volatile unsigned int*)(0x424A603CUL))

/* Base Timer 8 PPG registers */
#define bFM3_BT8_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A8180UL))
#define bFM3_BT8_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A8184UL))
#define bFM3_BT8_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A8188UL))
#define bFM3_BT8_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A818CUL))
#define bFM3_BT8_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A81A0UL))
#define bFM3_BT8_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A81A4UL))
#define bFM3_BT8_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A81A8UL))
#define bFM3_BT8_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A81ACUL))
#define bFM3_BT8_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A81B0UL))
#define bFM3_BT8_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A81B4UL))
#define bFM3_BT8_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A81B8UL))
#define bFM3_BT8_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A8200UL))
#define bFM3_BT8_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A8208UL))
#define bFM3_BT8_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A8210UL))
#define bFM3_BT8_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A8218UL))
#define bFM3_BT8_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A8220UL))

/* Base Timer 8 PWM registers */
#define bFM3_BT8_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A8180UL))
#define bFM3_BT8_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A8184UL))
#define bFM3_BT8_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A8188UL))
#define bFM3_BT8_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A818CUL))
#define bFM3_BT8_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A81A0UL))
#define bFM3_BT8_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A81A4UL))
#define bFM3_BT8_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A81A8UL))
#define bFM3_BT8_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A81ACUL))
#define bFM3_BT8_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A81B0UL))
#define bFM3_BT8_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A81B4UL))
#define bFM3_BT8_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A81B8UL))
#define bFM3_BT8_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A8200UL))
#define bFM3_BT8_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A8204UL))
#define bFM3_BT8_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A8208UL))
#define bFM3_BT8_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A8210UL))
#define bFM3_BT8_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A8214UL))
#define bFM3_BT8_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A8218UL))
#define bFM3_BT8_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A8220UL))

/* Base Timer 8 RT registers */
#define bFM3_BT8_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A8180UL))
#define bFM3_BT8_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A8184UL))
#define bFM3_BT8_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A8188UL))
#define bFM3_BT8_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A818CUL))
#define bFM3_BT8_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A819CUL))
#define bFM3_BT8_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A81A0UL))
#define bFM3_BT8_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A81A4UL))
#define bFM3_BT8_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A81B0UL))
#define bFM3_BT8_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A81B4UL))
#define bFM3_BT8_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A81B8UL))
#define bFM3_BT8_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A8200UL))
#define bFM3_BT8_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A8208UL))
#define bFM3_BT8_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A8210UL))
#define bFM3_BT8_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A8218UL))
#define bFM3_BT8_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A8220UL))

/* Base Timer 8 PWC registers */
#define bFM3_BT8_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A8184UL))
#define bFM3_BT8_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A8188UL))
#define bFM3_BT8_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A819CUL))
#define bFM3_BT8_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A81A0UL))
#define bFM3_BT8_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A81A4UL))
#define bFM3_BT8_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A81A8UL))
#define bFM3_BT8_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A81B0UL))
#define bFM3_BT8_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A81B4UL))
#define bFM3_BT8_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A81B8UL))
#define bFM3_BT8_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A8200UL))
#define bFM3_BT8_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A8208UL))
#define bFM3_BT8_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A8210UL))
#define bFM3_BT8_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A8218UL))
#define bFM3_BT8_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A821CUL))
#define bFM3_BT8_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A8220UL))

/* Base Timer 9 PPG registers */
#define bFM3_BT9_PPG_TMCR_STRG                 *((volatile unsigned int*)(0x424A8980UL))
#define bFM3_BT9_PPG_TMCR_CTEN                 *((volatile unsigned int*)(0x424A8984UL))
#define bFM3_BT9_PPG_TMCR_MDSE                 *((volatile unsigned int*)(0x424A8988UL))
#define bFM3_BT9_PPG_TMCR_OSEL                 *((volatile unsigned int*)(0x424A898CUL))
#define bFM3_BT9_PPG_TMCR_EGS0                 *((volatile unsigned int*)(0x424A89A0UL))
#define bFM3_BT9_PPG_TMCR_EGS1                 *((volatile unsigned int*)(0x424A89A4UL))
#define bFM3_BT9_PPG_TMCR_PMSK                 *((volatile unsigned int*)(0x424A89A8UL))
#define bFM3_BT9_PPG_TMCR_RTGEN                *((volatile unsigned int*)(0x424A89ACUL))
#define bFM3_BT9_PPG_TMCR_CKS0                 *((volatile unsigned int*)(0x424A89B0UL))
#define bFM3_BT9_PPG_TMCR_CKS1                 *((volatile unsigned int*)(0x424A89B4UL))
#define bFM3_BT9_PPG_TMCR_CKS2                 *((volatile unsigned int*)(0x424A89B8UL))
#define bFM3_BT9_PPG_STC_UDIR                  *((volatile unsigned int*)(0x424A8A00UL))
#define bFM3_BT9_PPG_STC_TGIR                  *((volatile unsigned int*)(0x424A8A08UL))
#define bFM3_BT9_PPG_STC_UDIE                  *((volatile unsigned int*)(0x424A8A10UL))
#define bFM3_BT9_PPG_STC_TGIE                  *((volatile unsigned int*)(0x424A8A18UL))
#define bFM3_BT9_PPG_TMCR2_CKS3                *((volatile unsigned int*)(0x424A8A20UL))

/* Base Timer 9 PWM registers */
#define bFM3_BT9_PWM_TMCR_STRG                 *((volatile unsigned int*)(0x424A8980UL))
#define bFM3_BT9_PWM_TMCR_CTEN                 *((volatile unsigned int*)(0x424A8984UL))
#define bFM3_BT9_PWM_TMCR_MDSE                 *((volatile unsigned int*)(0x424A8988UL))
#define bFM3_BT9_PWM_TMCR_OSEL                 *((volatile unsigned int*)(0x424A898CUL))
#define bFM3_BT9_PWM_TMCR_EGS0                 *((volatile unsigned int*)(0x424A89A0UL))
#define bFM3_BT9_PWM_TMCR_EGS1                 *((volatile unsigned int*)(0x424A89A4UL))
#define bFM3_BT9_PWM_TMCR_PMSK                 *((volatile unsigned int*)(0x424A89A8UL))
#define bFM3_BT9_PWM_TMCR_RTGEN                *((volatile unsigned int*)(0x424A89ACUL))
#define bFM3_BT9_PWM_TMCR_CKS0                 *((volatile unsigned int*)(0x424A89B0UL))
#define bFM3_BT9_PWM_TMCR_CKS1                 *((volatile unsigned int*)(0x424A89B4UL))
#define bFM3_BT9_PWM_TMCR_CKS2                 *((volatile unsigned int*)(0x424A89B8UL))
#define bFM3_BT9_PWM_STC_UDIR                  *((volatile unsigned int*)(0x424A8A00UL))
#define bFM3_BT9_PWM_STC_DTIR                  *((volatile unsigned int*)(0x424A8A04UL))
#define bFM3_BT9_PWM_STC_TGIR                  *((volatile unsigned int*)(0x424A8A08UL))
#define bFM3_BT9_PWM_STC_UDIE                  *((volatile unsigned int*)(0x424A8A10UL))
#define bFM3_BT9_PWM_STC_DTIE                  *((volatile unsigned int*)(0x424A8A14UL))
#define bFM3_BT9_PWM_STC_TGIE                  *((volatile unsigned int*)(0x424A8A18UL))
#define bFM3_BT9_PWM_TMCR2_CKS3                *((volatile unsigned int*)(0x424A8A20UL))

/* Base Timer 9 RT registers */
#define bFM3_BT9_RT_TMCR_STRG                  *((volatile unsigned int*)(0x424A8980UL))
#define bFM3_BT9_RT_TMCR_CTEN                  *((volatile unsigned int*)(0x424A8984UL))
#define bFM3_BT9_RT_TMCR_MDSE                  *((volatile unsigned int*)(0x424A8988UL))
#define bFM3_BT9_RT_TMCR_OSEL                  *((volatile unsigned int*)(0x424A898CUL))
#define bFM3_BT9_RT_TMCR_T32                   *((volatile unsigned int*)(0x424A899CUL))
#define bFM3_BT9_RT_TMCR_EGS0                  *((volatile unsigned int*)(0x424A89A0UL))
#define bFM3_BT9_RT_TMCR_EGS1                  *((volatile unsigned int*)(0x424A89A4UL))
#define bFM3_BT9_RT_TMCR_CKS0                  *((volatile unsigned int*)(0x424A89B0UL))
#define bFM3_BT9_RT_TMCR_CKS1                  *((volatile unsigned int*)(0x424A89B4UL))
#define bFM3_BT9_RT_TMCR_CKS2                  *((volatile unsigned int*)(0x424A89B8UL))
#define bFM3_BT9_RT_STC_UDIR                   *((volatile unsigned int*)(0x424A8A00UL))
#define bFM3_BT9_RT_STC_TGIR                   *((volatile unsigned int*)(0x424A8A08UL))
#define bFM3_BT9_RT_STC_UDIE                   *((volatile unsigned int*)(0x424A8A10UL))
#define bFM3_BT9_RT_STC_TGIE                   *((volatile unsigned int*)(0x424A8A18UL))
#define bFM3_BT9_RT_TMCR2_CKS3                 *((volatile unsigned int*)(0x424A8A20UL))

/* Base Timer 9 PWC registers */
#define bFM3_BT9_PWC_TMCR_CTEN                 *((volatile unsigned int*)(0x424A8984UL))
#define bFM3_BT9_PWC_TMCR_MDSE                 *((volatile unsigned int*)(0x424A8988UL))
#define bFM3_BT9_PWC_TMCR_T32                  *((volatile unsigned int*)(0x424A899CUL))
#define bFM3_BT9_PWC_TMCR_EGS0                 *((volatile unsigned int*)(0x424A89A0UL))
#define bFM3_BT9_PWC_TMCR_EGS1                 *((volatile unsigned int*)(0x424A89A4UL))
#define bFM3_BT9_PWC_TMCR_EGS2                 *((volatile unsigned int*)(0x424A89A8UL))
#define bFM3_BT9_PWC_TMCR_CKS0                 *((volatile unsigned int*)(0x424A89B0UL))
#define bFM3_BT9_PWC_TMCR_CKS1                 *((volatile unsigned int*)(0x424A89B4UL))
#define bFM3_BT9_PWC_TMCR_CKS2                 *((volatile unsigned int*)(0x424A89B8UL))
#define bFM3_BT9_PWC_STC_OVIR                  *((volatile unsigned int*)(0x424A8A00UL))
#define bFM3_BT9_PWC_STC_EDIR                  *((volatile unsigned int*)(0x424A8A08UL))
#define bFM3_BT9_PWC_STC_OVIE                  *((volatile unsigned int*)(0x424A8A10UL))
#define bFM3_BT9_PWC_STC_EDIE                  *((volatile unsigned int*)(0x424A8A18UL))
#define bFM3_BT9_PWC_STC_ERR                   *((volatile unsigned int*)(0x424A8A1CUL))
#define bFM3_BT9_PWC_TMCR2_CKS3                *((volatile unsigned int*)(0x424A8A20UL))

/* Base Timer 10 PPG registers */
#define bFM3_BT10_PPG_TMCR_STRG                *((volatile unsigned int*)(0x424A9180UL))
#define bFM3_BT10_PPG_TMCR_CTEN                *((volatile unsigned int*)(0x424A9184UL))
#define bFM3_BT10_PPG_TMCR_MDSE                *((volatile unsigned int*)(0x424A9188UL))
#define bFM3_BT10_PPG_TMCR_OSEL                *((volatile unsigned int*)(0x424A918CUL))
#define bFM3_BT10_PPG_TMCR_EGS0                *((volatile unsigned int*)(0x424A91A0UL))
#define bFM3_BT10_PPG_TMCR_EGS1                *((volatile unsigned int*)(0x424A91A4UL))
#define bFM3_BT10_PPG_TMCR_PMSK                *((volatile unsigned int*)(0x424A91A8UL))
#define bFM3_BT10_PPG_TMCR_RTGEN               *((volatile unsigned int*)(0x424A91ACUL))
#define bFM3_BT10_PPG_TMCR_CKS0                *((volatile unsigned int*)(0x424A91B0UL))
#define bFM3_BT10_PPG_TMCR_CKS1                *((volatile unsigned int*)(0x424A91B4UL))
#define bFM3_BT10_PPG_TMCR_CKS2                *((volatile unsigned int*)(0x424A91B8UL))
#define bFM3_BT10_PPG_STC_UDIR                 *((volatile unsigned int*)(0x424A9200UL))
#define bFM3_BT10_PPG_STC_TGIR                 *((volatile unsigned int*)(0x424A9208UL))
#define bFM3_BT10_PPG_STC_UDIE                 *((volatile unsigned int*)(0x424A9210UL))
#define bFM3_BT10_PPG_STC_TGIE                 *((volatile unsigned int*)(0x424A9218UL))
#define bFM3_BT10_PPG_TMCR2_CKS3               *((volatile unsigned int*)(0x424A9220UL))

/* Base Timer 10 PWM registers */
#define bFM3_BT10_PWM_TMCR_STRG                *((volatile unsigned int*)(0x424A9180UL))
#define bFM3_BT10_PWM_TMCR_CTEN                *((volatile unsigned int*)(0x424A9184UL))
#define bFM3_BT10_PWM_TMCR_MDSE                *((volatile unsigned int*)(0x424A9188UL))
#define bFM3_BT10_PWM_TMCR_OSEL                *((volatile unsigned int*)(0x424A918CUL))
#define bFM3_BT10_PWM_TMCR_EGS0                *((volatile unsigned int*)(0x424A91A0UL))
#define bFM3_BT10_PWM_TMCR_EGS1                *((volatile unsigned int*)(0x424A91A4UL))
#define bFM3_BT10_PWM_TMCR_PMSK                *((volatile unsigned int*)(0x424A91A8UL))
#define bFM3_BT10_PWM_TMCR_RTGEN               *((volatile unsigned int*)(0x424A91ACUL))
#define bFM3_BT10_PWM_TMCR_CKS0                *((volatile unsigned int*)(0x424A91B0UL))
#define bFM3_BT10_PWM_TMCR_CKS1                *((volatile unsigned int*)(0x424A91B4UL))
#define bFM3_BT10_PWM_TMCR_CKS2                *((volatile unsigned int*)(0x424A91B8UL))
#define bFM3_BT10_PWM_STC_UDIR                 *((volatile unsigned int*)(0x424A9200UL))
#define bFM3_BT10_PWM_STC_DTIR                 *((volatile unsigned int*)(0x424A9204UL))
#define bFM3_BT10_PWM_STC_TGIR                 *((volatile unsigned int*)(0x424A9208UL))
#define bFM3_BT10_PWM_STC_UDIE                 *((volatile unsigned int*)(0x424A9210UL))
#define bFM3_BT10_PWM_STC_DTIE                 *((volatile unsigned int*)(0x424A9214UL))
#define bFM3_BT10_PWM_STC_TGIE                 *((volatile unsigned int*)(0x424A9218UL))
#define bFM3_BT10_PWM_TMCR2_CKS3               *((volatile unsigned int*)(0x424A9220UL))

/* Base Timer 10 RT registers */
#define bFM3_BT10_RT_TMCR_STRG                 *((volatile unsigned int*)(0x424A9180UL))
#define bFM3_BT10_RT_TMCR_CTEN                 *((volatile unsigned int*)(0x424A9184UL))
#define bFM3_BT10_RT_TMCR_MDSE                 *((volatile unsigned int*)(0x424A9188UL))
#define bFM3_BT10_RT_TMCR_OSEL                 *((volatile unsigned int*)(0x424A918CUL))
#define bFM3_BT10_RT_TMCR_T32                  *((volatile unsigned int*)(0x424A919CUL))
#define bFM3_BT10_RT_TMCR_EGS0                 *((volatile unsigned int*)(0x424A91A0UL))
#define bFM3_BT10_RT_TMCR_EGS1                 *((volatile unsigned int*)(0x424A91A4UL))
#define bFM3_BT10_RT_TMCR_CKS0                 *((volatile unsigned int*)(0x424A91B0UL))
#define bFM3_BT10_RT_TMCR_CKS1                 *((volatile unsigned int*)(0x424A91B4UL))
#define bFM3_BT10_RT_TMCR_CKS2                 *((volatile unsigned int*)(0x424A91B8UL))
#define bFM3_BT10_RT_STC_UDIR                  *((volatile unsigned int*)(0x424A9200UL))
#define bFM3_BT10_RT_STC_TGIR                  *((volatile unsigned int*)(0x424A9208UL))
#define bFM3_BT10_RT_STC_UDIE                  *((volatile unsigned int*)(0x424A9210UL))
#define bFM3_BT10_RT_STC_TGIE                  *((volatile unsigned int*)(0x424A9218UL))
#define bFM3_BT10_RT_TMCR2_CKS3                *((volatile unsigned int*)(0x424A9220UL))

/* Base Timer 10 PWC registers */
#define bFM3_BT10_PWC_TMCR_CTEN                *((volatile unsigned int*)(0x424A9184UL))
#define bFM3_BT10_PWC_TMCR_MDSE                *((volatile unsigned int*)(0x424A9188UL))
#define bFM3_BT10_PWC_TMCR_T32                 *((volatile unsigned int*)(0x424A919CUL))
#define bFM3_BT10_PWC_TMCR_EGS0                *((volatile unsigned int*)(0x424A91A0UL))
#define bFM3_BT10_PWC_TMCR_EGS1                *((volatile unsigned int*)(0x424A91A4UL))
#define bFM3_BT10_PWC_TMCR_EGS2                *((volatile unsigned int*)(0x424A91A8UL))
#define bFM3_BT10_PWC_TMCR_CKS0                *((volatile unsigned int*)(0x424A91B0UL))
#define bFM3_BT10_PWC_TMCR_CKS1                *((volatile unsigned int*)(0x424A91B4UL))
#define bFM3_BT10_PWC_TMCR_CKS2                *((volatile unsigned int*)(0x424A91B8UL))
#define bFM3_BT10_PWC_STC_OVIR                 *((volatile unsigned int*)(0x424A9200UL))
#define bFM3_BT10_PWC_STC_EDIR                 *((volatile unsigned int*)(0x424A9208UL))
#define bFM3_BT10_PWC_STC_OVIE                 *((volatile unsigned int*)(0x424A9210UL))
#define bFM3_BT10_PWC_STC_EDIE                 *((volatile unsigned int*)(0x424A9218UL))
#define bFM3_BT10_PWC_STC_ERR                  *((volatile unsigned int*)(0x424A921CUL))
#define bFM3_BT10_PWC_TMCR2_CKS3               *((volatile unsigned int*)(0x424A9220UL))

/* Base Timer 11 PPG registers */
#define bFM3_BT11_PPG_TMCR_STRG                *((volatile unsigned int*)(0x424A9980UL))
#define bFM3_BT11_PPG_TMCR_CTEN                *((volatile unsigned int*)(0x424A9984UL))
#define bFM3_BT11_PPG_TMCR_MDSE                *((volatile unsigned int*)(0x424A9988UL))
#define bFM3_BT11_PPG_TMCR_OSEL                *((volatile unsigned int*)(0x424A998CUL))
#define bFM3_BT11_PPG_TMCR_EGS0                *((volatile unsigned int*)(0x424A99A0UL))
#define bFM3_BT11_PPG_TMCR_EGS1                *((volatile unsigned int*)(0x424A99A4UL))
#define bFM3_BT11_PPG_TMCR_PMSK                *((volatile unsigned int*)(0x424A99A8UL))
#define bFM3_BT11_PPG_TMCR_RTGEN               *((volatile unsigned int*)(0x424A99ACUL))
#define bFM3_BT11_PPG_TMCR_CKS0                *((volatile unsigned int*)(0x424A99B0UL))
#define bFM3_BT11_PPG_TMCR_CKS1                *((volatile unsigned int*)(0x424A99B4UL))
#define bFM3_BT11_PPG_TMCR_CKS2                *((volatile unsigned int*)(0x424A99B8UL))
#define bFM3_BT11_PPG_STC_UDIR                 *((volatile unsigned int*)(0x424A9A00UL))
#define bFM3_BT11_PPG_STC_TGIR                 *((volatile unsigned int*)(0x424A9A08UL))
#define bFM3_BT11_PPG_STC_UDIE                 *((volatile unsigned int*)(0x424A9A10UL))
#define bFM3_BT11_PPG_STC_TGIE                 *((volatile unsigned int*)(0x424A9A18UL))
#define bFM3_BT11_PPG_TMCR2_CKS3               *((volatile unsigned int*)(0x424A9A20UL))

/* Base Timer 11 PWM registers */
#define bFM3_BT11_PWM_TMCR_STRG                *((volatile unsigned int*)(0x424A9980UL))
#define bFM3_BT11_PWM_TMCR_CTEN                *((volatile unsigned int*)(0x424A9984UL))
#define bFM3_BT11_PWM_TMCR_MDSE                *((volatile unsigned int*)(0x424A9988UL))
#define bFM3_BT11_PWM_TMCR_OSEL                *((volatile unsigned int*)(0x424A998CUL))
#define bFM3_BT11_PWM_TMCR_EGS0                *((volatile unsigned int*)(0x424A99A0UL))
#define bFM3_BT11_PWM_TMCR_EGS1                *((volatile unsigned int*)(0x424A99A4UL))
#define bFM3_BT11_PWM_TMCR_PMSK                *((volatile unsigned int*)(0x424A99A8UL))
#define bFM3_BT11_PWM_TMCR_RTGEN               *((volatile unsigned int*)(0x424A99ACUL))
#define bFM3_BT11_PWM_TMCR_CKS0                *((volatile unsigned int*)(0x424A99B0UL))
#define bFM3_BT11_PWM_TMCR_CKS1                *((volatile unsigned int*)(0x424A99B4UL))
#define bFM3_BT11_PWM_TMCR_CKS2                *((volatile unsigned int*)(0x424A99B8UL))
#define bFM3_BT11_PWM_STC_UDIR                 *((volatile unsigned int*)(0x424A9A00UL))
#define bFM3_BT11_PWM_STC_DTIR                 *((volatile unsigned int*)(0x424A9A04UL))
#define bFM3_BT11_PWM_STC_TGIR                 *((volatile unsigned int*)(0x424A9A08UL))
#define bFM3_BT11_PWM_STC_UDIE                 *((volatile unsigned int*)(0x424A9A10UL))
#define bFM3_BT11_PWM_STC_DTIE                 *((volatile unsigned int*)(0x424A9A14UL))
#define bFM3_BT11_PWM_STC_TGIE                 *((volatile unsigned int*)(0x424A9A18UL))
#define bFM3_BT11_PWM_TMCR2_CKS3               *((volatile unsigned int*)(0x424A9A20UL))

/* Base Timer 11 RT registers */
#define bFM3_BT11_RT_TMCR_STRG                 *((volatile unsigned int*)(0x424A9980UL))
#define bFM3_BT11_RT_TMCR_CTEN                 *((volatile unsigned int*)(0x424A9984UL))
#define bFM3_BT11_RT_TMCR_MDSE                 *((volatile unsigned int*)(0x424A9988UL))
#define bFM3_BT11_RT_TMCR_OSEL                 *((volatile unsigned int*)(0x424A998CUL))
#define bFM3_BT11_RT_TMCR_T32                  *((volatile unsigned int*)(0x424A999CUL))
#define bFM3_BT11_RT_TMCR_EGS0                 *((volatile unsigned int*)(0x424A99A0UL))
#define bFM3_BT11_RT_TMCR_EGS1                 *((volatile unsigned int*)(0x424A99A4UL))
#define bFM3_BT11_RT_TMCR_CKS0                 *((volatile unsigned int*)(0x424A99B0UL))
#define bFM3_BT11_RT_TMCR_CKS1                 *((volatile unsigned int*)(0x424A99B4UL))
#define bFM3_BT11_RT_TMCR_CKS2                 *((volatile unsigned int*)(0x424A99B8UL))
#define bFM3_BT11_RT_STC_UDIR                  *((volatile unsigned int*)(0x424A9A00UL))
#define bFM3_BT11_RT_STC_TGIR                  *((volatile unsigned int*)(0x424A9A08UL))
#define bFM3_BT11_RT_STC_UDIE                  *((volatile unsigned int*)(0x424A9A10UL))
#define bFM3_BT11_RT_STC_TGIE                  *((volatile unsigned int*)(0x424A9A18UL))
#define bFM3_BT11_RT_TMCR2_CKS3                *((volatile unsigned int*)(0x424A9A20UL))

/* Base Timer 11 PWC registers */
#define bFM3_BT11_PWC_TMCR_CTEN                *((volatile unsigned int*)(0x424A9984UL))
#define bFM3_BT11_PWC_TMCR_MDSE                *((volatile unsigned int*)(0x424A9988UL))
#define bFM3_BT11_PWC_TMCR_T32                 *((volatile unsigned int*)(0x424A999CUL))
#define bFM3_BT11_PWC_TMCR_EGS0                *((volatile unsigned int*)(0x424A99A0UL))
#define bFM3_BT11_PWC_TMCR_EGS1                *((volatile unsigned int*)(0x424A99A4UL))
#define bFM3_BT11_PWC_TMCR_EGS2                *((volatile unsigned int*)(0x424A99A8UL))
#define bFM3_BT11_PWC_TMCR_CKS0                *((volatile unsigned int*)(0x424A99B0UL))
#define bFM3_BT11_PWC_TMCR_CKS1                *((volatile unsigned int*)(0x424A99B4UL))
#define bFM3_BT11_PWC_TMCR_CKS2                *((volatile unsigned int*)(0x424A99B8UL))
#define bFM3_BT11_PWC_STC_OVIR                 *((volatile unsigned int*)(0x424A9A00UL))
#define bFM3_BT11_PWC_STC_EDIR                 *((volatile unsigned int*)(0x424A9A08UL))
#define bFM3_BT11_PWC_STC_OVIE                 *((volatile unsigned int*)(0x424A9A10UL))
#define bFM3_BT11_PWC_STC_EDIE                 *((volatile unsigned int*)(0x424A9A18UL))
#define bFM3_BT11_PWC_STC_ERR                  *((volatile unsigned int*)(0x424A9A1CUL))
#define bFM3_BT11_PWC_TMCR2_CKS3               *((volatile unsigned int*)(0x424A9A20UL))

/* Base Timer 12 PPG registers */
#define bFM3_BT12_PPG_TMCR_STRG                *((volatile unsigned int*)(0x424AC180UL))
#define bFM3_BT12_PPG_TMCR_CTEN                *((volatile unsigned int*)(0x424AC184UL))
#define bFM3_BT12_PPG_TMCR_MDSE                *((volatile unsigned int*)(0x424AC188UL))
#define bFM3_BT12_PPG_TMCR_OSEL                *((volatile unsigned int*)(0x424AC18CUL))
#define bFM3_BT12_PPG_TMCR_EGS0                *((volatile unsigned int*)(0x424AC1A0UL))
#define bFM3_BT12_PPG_TMCR_EGS1                *((volatile unsigned int*)(0x424AC1A4UL))
#define bFM3_BT12_PPG_TMCR_PMSK                *((volatile unsigned int*)(0x424AC1A8UL))
#define bFM3_BT12_PPG_TMCR_RTGEN               *((volatile unsigned int*)(0x424AC1ACUL))
#define bFM3_BT12_PPG_TMCR_CKS0                *((volatile unsigned int*)(0x424AC1B0UL))
#define bFM3_BT12_PPG_TMCR_CKS1                *((volatile unsigned int*)(0x424AC1B4UL))
#define bFM3_BT12_PPG_TMCR_CKS2                *((volatile unsigned int*)(0x424AC1B8UL))
#define bFM3_BT12_PPG_STC_UDIR                 *((volatile unsigned int*)(0x424AC200UL))
#define bFM3_BT12_PPG_STC_TGIR                 *((volatile unsigned int*)(0x424AC208UL))
#define bFM3_BT12_PPG_STC_UDIE                 *((volatile unsigned int*)(0x424AC210UL))
#define bFM3_BT12_PPG_STC_TGIE                 *((volatile unsigned int*)(0x424AC218UL))
#define bFM3_BT12_PPG_TMCR2_CKS3               *((volatile unsigned int*)(0x424AC220UL))

/* Base Timer 12 PWM registers */
#define bFM3_BT12_PWM_TMCR_STRG                *((volatile unsigned int*)(0x424AC180UL))
#define bFM3_BT12_PWM_TMCR_CTEN                *((volatile unsigned int*)(0x424AC184UL))
#define bFM3_BT12_PWM_TMCR_MDSE                *((volatile unsigned int*)(0x424AC188UL))
#define bFM3_BT12_PWM_TMCR_OSEL                *((volatile unsigned int*)(0x424AC18CUL))
#define bFM3_BT12_PWM_TMCR_EGS0                *((volatile unsigned int*)(0x424AC1A0UL))
#define bFM3_BT12_PWM_TMCR_EGS1                *((volatile unsigned int*)(0x424AC1A4UL))
#define bFM3_BT12_PWM_TMCR_PMSK                *((volatile unsigned int*)(0x424AC1A8UL))
#define bFM3_BT12_PWM_TMCR_RTGEN               *((volatile unsigned int*)(0x424AC1ACUL))
#define bFM3_BT12_PWM_TMCR_CKS0                *((volatile unsigned int*)(0x424AC1B0UL))
#define bFM3_BT12_PWM_TMCR_CKS1                *((volatile unsigned int*)(0x424AC1B4UL))
#define bFM3_BT12_PWM_TMCR_CKS2                *((volatile unsigned int*)(0x424AC1B8UL))
#define bFM3_BT12_PWM_STC_UDIR                 *((volatile unsigned int*)(0x424AC200UL))
#define bFM3_BT12_PWM_STC_DTIR                 *((volatile unsigned int*)(0x424AC204UL))
#define bFM3_BT12_PWM_STC_TGIR                 *((volatile unsigned int*)(0x424AC208UL))
#define bFM3_BT12_PWM_STC_UDIE                 *((volatile unsigned int*)(0x424AC210UL))
#define bFM3_BT12_PWM_STC_DTIE                 *((volatile unsigned int*)(0x424AC214UL))
#define bFM3_BT12_PWM_STC_TGIE                 *((volatile unsigned int*)(0x424AC218UL))
#define bFM3_BT12_PWM_TMCR2_CKS3               *((volatile unsigned int*)(0x424AC220UL))

/* Base Timer 12 RT registers */
#define bFM3_BT12_RT_TMCR_STRG                 *((volatile unsigned int*)(0x424AC180UL))
#define bFM3_BT12_RT_TMCR_CTEN                 *((volatile unsigned int*)(0x424AC184UL))
#define bFM3_BT12_RT_TMCR_MDSE                 *((volatile unsigned int*)(0x424AC188UL))
#define bFM3_BT12_RT_TMCR_OSEL                 *((volatile unsigned int*)(0x424AC18CUL))
#define bFM3_BT12_RT_TMCR_T32                  *((volatile unsigned int*)(0x424AC19CUL))
#define bFM3_BT12_RT_TMCR_EGS0                 *((volatile unsigned int*)(0x424AC1A0UL))
#define bFM3_BT12_RT_TMCR_EGS1                 *((volatile unsigned int*)(0x424AC1A4UL))
#define bFM3_BT12_RT_TMCR_CKS0                 *((volatile unsigned int*)(0x424AC1B0UL))
#define bFM3_BT12_RT_TMCR_CKS1                 *((volatile unsigned int*)(0x424AC1B4UL))
#define bFM3_BT12_RT_TMCR_CKS2                 *((volatile unsigned int*)(0x424AC1B8UL))
#define bFM3_BT12_RT_STC_UDIR                  *((volatile unsigned int*)(0x424AC200UL))
#define bFM3_BT12_RT_STC_TGIR                  *((volatile unsigned int*)(0x424AC208UL))
#define bFM3_BT12_RT_STC_UDIE                  *((volatile unsigned int*)(0x424AC210UL))
#define bFM3_BT12_RT_STC_TGIE                  *((volatile unsigned int*)(0x424AC218UL))
#define bFM3_BT12_RT_TMCR2_CKS3                *((volatile unsigned int*)(0x424AC220UL))

/* Base Timer 12 PWC registers */
#define bFM3_BT12_PWC_TMCR_CTEN                *((volatile unsigned int*)(0x424AC184UL))
#define bFM3_BT12_PWC_TMCR_MDSE                *((volatile unsigned int*)(0x424AC188UL))
#define bFM3_BT12_PWC_TMCR_T32                 *((volatile unsigned int*)(0x424AC19CUL))
#define bFM3_BT12_PWC_TMCR_EGS0                *((volatile unsigned int*)(0x424AC1A0UL))
#define bFM3_BT12_PWC_TMCR_EGS1                *((volatile unsigned int*)(0x424AC1A4UL))
#define bFM3_BT12_PWC_TMCR_EGS2                *((volatile unsigned int*)(0x424AC1A8UL))
#define bFM3_BT12_PWC_TMCR_CKS0                *((volatile unsigned int*)(0x424AC1B0UL))
#define bFM3_BT12_PWC_TMCR_CKS1                *((volatile unsigned int*)(0x424AC1B4UL))
#define bFM3_BT12_PWC_TMCR_CKS2                *((volatile unsigned int*)(0x424AC1B8UL))
#define bFM3_BT12_PWC_STC_OVIR                 *((volatile unsigned int*)(0x424AC200UL))
#define bFM3_BT12_PWC_STC_EDIR                 *((volatile unsigned int*)(0x424AC208UL))
#define bFM3_BT12_PWC_STC_OVIE                 *((volatile unsigned int*)(0x424AC210UL))
#define bFM3_BT12_PWC_STC_EDIE                 *((volatile unsigned int*)(0x424AC218UL))
#define bFM3_BT12_PWC_STC_ERR                  *((volatile unsigned int*)(0x424AC21CUL))
#define bFM3_BT12_PWC_TMCR2_CKS3               *((volatile unsigned int*)(0x424AC220UL))

/* Base Timer 13 PPG registers */
#define bFM3_BT13_PPG_TMCR_STRG                *((volatile unsigned int*)(0x424AC980UL))
#define bFM3_BT13_PPG_TMCR_CTEN                *((volatile unsigned int*)(0x424AC984UL))
#define bFM3_BT13_PPG_TMCR_MDSE                *((volatile unsigned int*)(0x424AC988UL))
#define bFM3_BT13_PPG_TMCR_OSEL                *((volatile unsigned int*)(0x424AC98CUL))
#define bFM3_BT13_PPG_TMCR_EGS0                *((volatile unsigned int*)(0x424AC9A0UL))
#define bFM3_BT13_PPG_TMCR_EGS1                *((volatile unsigned int*)(0x424AC9A4UL))
#define bFM3_BT13_PPG_TMCR_PMSK                *((volatile unsigned int*)(0x424AC9A8UL))
#define bFM3_BT13_PPG_TMCR_RTGEN               *((volatile unsigned int*)(0x424AC9ACUL))
#define bFM3_BT13_PPG_TMCR_CKS0                *((volatile unsigned int*)(0x424AC9B0UL))
#define bFM3_BT13_PPG_TMCR_CKS1                *((volatile unsigned int*)(0x424AC9B4UL))
#define bFM3_BT13_PPG_TMCR_CKS2                *((volatile unsigned int*)(0x424AC9B8UL))
#define bFM3_BT13_PPG_STC_UDIR                 *((volatile unsigned int*)(0x424ACA00UL))
#define bFM3_BT13_PPG_STC_TGIR                 *((volatile unsigned int*)(0x424ACA08UL))
#define bFM3_BT13_PPG_STC_UDIE                 *((volatile unsigned int*)(0x424ACA10UL))
#define bFM3_BT13_PPG_STC_TGIE                 *((volatile unsigned int*)(0x424ACA18UL))
#define bFM3_BT13_PPG_TMCR2_CKS3               *((volatile unsigned int*)(0x424ACA20UL))

/* Base Timer 13 PWM registers */
#define bFM3_BT13_PWM_TMCR_STRG                *((volatile unsigned int*)(0x424AC980UL))
#define bFM3_BT13_PWM_TMCR_CTEN                *((volatile unsigned int*)(0x424AC984UL))
#define bFM3_BT13_PWM_TMCR_MDSE                *((volatile unsigned int*)(0x424AC988UL))
#define bFM3_BT13_PWM_TMCR_OSEL                *((volatile unsigned int*)(0x424AC98CUL))
#define bFM3_BT13_PWM_TMCR_EGS0                *((volatile unsigned int*)(0x424AC9A0UL))
#define bFM3_BT13_PWM_TMCR_EGS1                *((volatile unsigned int*)(0x424AC9A4UL))
#define bFM3_BT13_PWM_TMCR_PMSK                *((volatile unsigned int*)(0x424AC9A8UL))
#define bFM3_BT13_PWM_TMCR_RTGEN               *((volatile unsigned int*)(0x424AC9ACUL))
#define bFM3_BT13_PWM_TMCR_CKS0                *((volatile unsigned int*)(0x424AC9B0UL))
#define bFM3_BT13_PWM_TMCR_CKS1                *((volatile unsigned int*)(0x424AC9B4UL))
#define bFM3_BT13_PWM_TMCR_CKS2                *((volatile unsigned int*)(0x424AC9B8UL))
#define bFM3_BT13_PWM_STC_UDIR                 *((volatile unsigned int*)(0x424ACA00UL))
#define bFM3_BT13_PWM_STC_DTIR                 *((volatile unsigned int*)(0x424ACA04UL))
#define bFM3_BT13_PWM_STC_TGIR                 *((volatile unsigned int*)(0x424ACA08UL))
#define bFM3_BT13_PWM_STC_UDIE                 *((volatile unsigned int*)(0x424ACA10UL))
#define bFM3_BT13_PWM_STC_DTIE                 *((volatile unsigned int*)(0x424ACA14UL))
#define bFM3_BT13_PWM_STC_TGIE                 *((volatile unsigned int*)(0x424ACA18UL))
#define bFM3_BT13_PWM_TMCR2_CKS3               *((volatile unsigned int*)(0x424ACA20UL))

/* Base Timer 13 RT registers */
#define bFM3_BT13_RT_TMCR_STRG                 *((volatile unsigned int*)(0x424AC980UL))
#define bFM3_BT13_RT_TMCR_CTEN                 *((volatile unsigned int*)(0x424AC984UL))
#define bFM3_BT13_RT_TMCR_MDSE                 *((volatile unsigned int*)(0x424AC988UL))
#define bFM3_BT13_RT_TMCR_OSEL                 *((volatile unsigned int*)(0x424AC98CUL))
#define bFM3_BT13_RT_TMCR_T32                  *((volatile unsigned int*)(0x424AC99CUL))
#define bFM3_BT13_RT_TMCR_EGS0                 *((volatile unsigned int*)(0x424AC9A0UL))
#define bFM3_BT13_RT_TMCR_EGS1                 *((volatile unsigned int*)(0x424AC9A4UL))
#define bFM3_BT13_RT_TMCR_CKS0                 *((volatile unsigned int*)(0x424AC9B0UL))
#define bFM3_BT13_RT_TMCR_CKS1                 *((volatile unsigned int*)(0x424AC9B4UL))
#define bFM3_BT13_RT_TMCR_CKS2                 *((volatile unsigned int*)(0x424AC9B8UL))
#define bFM3_BT13_RT_STC_UDIR                  *((volatile unsigned int*)(0x424ACA00UL))
#define bFM3_BT13_RT_STC_TGIR                  *((volatile unsigned int*)(0x424ACA08UL))
#define bFM3_BT13_RT_STC_UDIE                  *((volatile unsigned int*)(0x424ACA10UL))
#define bFM3_BT13_RT_STC_TGIE                  *((volatile unsigned int*)(0x424ACA18UL))
#define bFM3_BT13_RT_TMCR2_CKS3                *((volatile unsigned int*)(0x424ACA20UL))

/* Base Timer 13 PWC registers */
#define bFM3_BT13_PWC_TMCR_CTEN                *((volatile unsigned int*)(0x424AC984UL))
#define bFM3_BT13_PWC_TMCR_MDSE                *((volatile unsigned int*)(0x424AC988UL))
#define bFM3_BT13_PWC_TMCR_T32                 *((volatile unsigned int*)(0x424AC99CUL))
#define bFM3_BT13_PWC_TMCR_EGS0                *((volatile unsigned int*)(0x424AC9A0UL))
#define bFM3_BT13_PWC_TMCR_EGS1                *((volatile unsigned int*)(0x424AC9A4UL))
#define bFM3_BT13_PWC_TMCR_EGS2                *((volatile unsigned int*)(0x424AC9A8UL))
#define bFM3_BT13_PWC_TMCR_CKS0                *((volatile unsigned int*)(0x424AC9B0UL))
#define bFM3_BT13_PWC_TMCR_CKS1                *((volatile unsigned int*)(0x424AC9B4UL))
#define bFM3_BT13_PWC_TMCR_CKS2                *((volatile unsigned int*)(0x424AC9B8UL))
#define bFM3_BT13_PWC_STC_OVIR                 *((volatile unsigned int*)(0x424ACA00UL))
#define bFM3_BT13_PWC_STC_EDIR                 *((volatile unsigned int*)(0x424ACA08UL))
#define bFM3_BT13_PWC_STC_OVIE                 *((volatile unsigned int*)(0x424ACA10UL))
#define bFM3_BT13_PWC_STC_EDIE                 *((volatile unsigned int*)(0x424ACA18UL))
#define bFM3_BT13_PWC_STC_ERR                  *((volatile unsigned int*)(0x424ACA1CUL))
#define bFM3_BT13_PWC_TMCR2_CKS3               *((volatile unsigned int*)(0x424ACA20UL))

/* Base Timer 14 PPG registers */
#define bFM3_BT14_PPG_TMCR_STRG                *((volatile unsigned int*)(0x424AD180UL))
#define bFM3_BT14_PPG_TMCR_CTEN                *((volatile unsigned int*)(0x424AD184UL))
#define bFM3_BT14_PPG_TMCR_MDSE                *((volatile unsigned int*)(0x424AD188UL))
#define bFM3_BT14_PPG_TMCR_OSEL                *((volatile unsigned int*)(0x424AD18CUL))
#define bFM3_BT14_PPG_TMCR_EGS0                *((volatile unsigned int*)(0x424AD1A0UL))
#define bFM3_BT14_PPG_TMCR_EGS1                *((volatile unsigned int*)(0x424AD1A4UL))
#define bFM3_BT14_PPG_TMCR_PMSK                *((volatile unsigned int*)(0x424AD1A8UL))
#define bFM3_BT14_PPG_TMCR_RTGEN               *((volatile unsigned int*)(0x424AD1ACUL))
#define bFM3_BT14_PPG_TMCR_CKS0                *((volatile unsigned int*)(0x424AD1B0UL))
#define bFM3_BT14_PPG_TMCR_CKS1                *((volatile unsigned int*)(0x424AD1B4UL))
#define bFM3_BT14_PPG_TMCR_CKS2                *((volatile unsigned int*)(0x424AD1B8UL))
#define bFM3_BT14_PPG_STC_UDIR                 *((volatile unsigned int*)(0x424AD200UL))
#define bFM3_BT14_PPG_STC_TGIR                 *((volatile unsigned int*)(0x424AD208UL))
#define bFM3_BT14_PPG_STC_UDIE                 *((volatile unsigned int*)(0x424AD210UL))
#define bFM3_BT14_PPG_STC_TGIE                 *((volatile unsigned int*)(0x424AD218UL))
#define bFM3_BT14_PPG_TMCR2_CKS3               *((volatile unsigned int*)(0x424AD220UL))

/* Base Timer 14 PWM registers */
#define bFM3_BT14_PWM_TMCR_STRG                *((volatile unsigned int*)(0x424AD180UL))
#define bFM3_BT14_PWM_TMCR_CTEN                *((volatile unsigned int*)(0x424AD184UL))
#define bFM3_BT14_PWM_TMCR_MDSE                *((volatile unsigned int*)(0x424AD188UL))
#define bFM3_BT14_PWM_TMCR_OSEL                *((volatile unsigned int*)(0x424AD18CUL))
#define bFM3_BT14_PWM_TMCR_EGS0                *((volatile unsigned int*)(0x424AD1A0UL))
#define bFM3_BT14_PWM_TMCR_EGS1                *((volatile unsigned int*)(0x424AD1A4UL))
#define bFM3_BT14_PWM_TMCR_PMSK                *((volatile unsigned int*)(0x424AD1A8UL))
#define bFM3_BT14_PWM_TMCR_RTGEN               *((volatile unsigned int*)(0x424AD1ACUL))
#define bFM3_BT14_PWM_TMCR_CKS0                *((volatile unsigned int*)(0x424AD1B0UL))
#define bFM3_BT14_PWM_TMCR_CKS1                *((volatile unsigned int*)(0x424AD1B4UL))
#define bFM3_BT14_PWM_TMCR_CKS2                *((volatile unsigned int*)(0x424AD1B8UL))
#define bFM3_BT14_PWM_STC_UDIR                 *((volatile unsigned int*)(0x424AD200UL))
#define bFM3_BT14_PWM_STC_DTIR                 *((volatile unsigned int*)(0x424AD204UL))
#define bFM3_BT14_PWM_STC_TGIR                 *((volatile unsigned int*)(0x424AD208UL))
#define bFM3_BT14_PWM_STC_UDIE                 *((volatile unsigned int*)(0x424AD210UL))
#define bFM3_BT14_PWM_STC_DTIE                 *((volatile unsigned int*)(0x424AD214UL))
#define bFM3_BT14_PWM_STC_TGIE                 *((volatile unsigned int*)(0x424AD218UL))
#define bFM3_BT14_PWM_TMCR2_CKS3               *((volatile unsigned int*)(0x424AD220UL))

/* Base Timer 14 RT registers */
#define bFM3_BT14_RT_TMCR_STRG                 *((volatile unsigned int*)(0x424AD180UL))
#define bFM3_BT14_RT_TMCR_CTEN                 *((volatile unsigned int*)(0x424AD184UL))
#define bFM3_BT14_RT_TMCR_MDSE                 *((volatile unsigned int*)(0x424AD188UL))
#define bFM3_BT14_RT_TMCR_OSEL                 *((volatile unsigned int*)(0x424AD18CUL))
#define bFM3_BT14_RT_TMCR_T32                  *((volatile unsigned int*)(0x424AD19CUL))
#define bFM3_BT14_RT_TMCR_EGS0                 *((volatile unsigned int*)(0x424AD1A0UL))
#define bFM3_BT14_RT_TMCR_EGS1                 *((volatile unsigned int*)(0x424AD1A4UL))
#define bFM3_BT14_RT_TMCR_CKS0                 *((volatile unsigned int*)(0x424AD1B0UL))
#define bFM3_BT14_RT_TMCR_CKS1                 *((volatile unsigned int*)(0x424AD1B4UL))
#define bFM3_BT14_RT_TMCR_CKS2                 *((volatile unsigned int*)(0x424AD1B8UL))
#define bFM3_BT14_RT_STC_UDIR                  *((volatile unsigned int*)(0x424AD200UL))
#define bFM3_BT14_RT_STC_TGIR                  *((volatile unsigned int*)(0x424AD208UL))
#define bFM3_BT14_RT_STC_UDIE                  *((volatile unsigned int*)(0x424AD210UL))
#define bFM3_BT14_RT_STC_TGIE                  *((volatile unsigned int*)(0x424AD218UL))
#define bFM3_BT14_RT_TMCR2_CKS3                *((volatile unsigned int*)(0x424AD220UL))

/* Base Timer 14 PWC registers */
#define bFM3_BT14_PWC_TMCR_CTEN                *((volatile unsigned int*)(0x424AD184UL))
#define bFM3_BT14_PWC_TMCR_MDSE                *((volatile unsigned int*)(0x424AD188UL))
#define bFM3_BT14_PWC_TMCR_T32                 *((volatile unsigned int*)(0x424AD19CUL))
#define bFM3_BT14_PWC_TMCR_EGS0                *((volatile unsigned int*)(0x424AD1A0UL))
#define bFM3_BT14_PWC_TMCR_EGS1                *((volatile unsigned int*)(0x424AD1A4UL))
#define bFM3_BT14_PWC_TMCR_EGS2                *((volatile unsigned int*)(0x424AD1A8UL))
#define bFM3_BT14_PWC_TMCR_CKS0                *((volatile unsigned int*)(0x424AD1B0UL))
#define bFM3_BT14_PWC_TMCR_CKS1                *((volatile unsigned int*)(0x424AD1B4UL))
#define bFM3_BT14_PWC_TMCR_CKS2                *((volatile unsigned int*)(0x424AD1B8UL))
#define bFM3_BT14_PWC_STC_OVIR                 *((volatile unsigned int*)(0x424AD200UL))
#define bFM3_BT14_PWC_STC_EDIR                 *((volatile unsigned int*)(0x424AD208UL))
#define bFM3_BT14_PWC_STC_OVIE                 *((volatile unsigned int*)(0x424AD210UL))
#define bFM3_BT14_PWC_STC_EDIE                 *((volatile unsigned int*)(0x424AD218UL))
#define bFM3_BT14_PWC_STC_ERR                  *((volatile unsigned int*)(0x424AD21CUL))
#define bFM3_BT14_PWC_TMCR2_CKS3               *((volatile unsigned int*)(0x424AD220UL))

/* Base Timer 15 PPG registers */
#define bFM3_BT15_PPG_TMCR_STRG                *((volatile unsigned int*)(0x424AD980UL))
#define bFM3_BT15_PPG_TMCR_CTEN                *((volatile unsigned int*)(0x424AD984UL))
#define bFM3_BT15_PPG_TMCR_MDSE                *((volatile unsigned int*)(0x424AD988UL))
#define bFM3_BT15_PPG_TMCR_OSEL                *((volatile unsigned int*)(0x424AD98CUL))
#define bFM3_BT15_PPG_TMCR_EGS0                *((volatile unsigned int*)(0x424AD9A0UL))
#define bFM3_BT15_PPG_TMCR_EGS1                *((volatile unsigned int*)(0x424AD9A4UL))
#define bFM3_BT15_PPG_TMCR_PMSK                *((volatile unsigned int*)(0x424AD9A8UL))
#define bFM3_BT15_PPG_TMCR_RTGEN               *((volatile unsigned int*)(0x424AD9ACUL))
#define bFM3_BT15_PPG_TMCR_CKS0                *((volatile unsigned int*)(0x424AD9B0UL))
#define bFM3_BT15_PPG_TMCR_CKS1                *((volatile unsigned int*)(0x424AD9B4UL))
#define bFM3_BT15_PPG_TMCR_CKS2                *((volatile unsigned int*)(0x424AD9B8UL))
#define bFM3_BT15_PPG_STC_UDIR                 *((volatile unsigned int*)(0x424ADA00UL))
#define bFM3_BT15_PPG_STC_TGIR                 *((volatile unsigned int*)(0x424ADA08UL))
#define bFM3_BT15_PPG_STC_UDIE                 *((volatile unsigned int*)(0x424ADA10UL))
#define bFM3_BT15_PPG_STC_TGIE                 *((volatile unsigned int*)(0x424ADA18UL))
#define bFM3_BT15_PPG_TMCR2_CKS3               *((volatile unsigned int*)(0x424ADA20UL))

/* Base Timer 15 PWM registers */
#define bFM3_BT15_PWM_TMCR_STRG                *((volatile unsigned int*)(0x424AD980UL))
#define bFM3_BT15_PWM_TMCR_CTEN                *((volatile unsigned int*)(0x424AD984UL))
#define bFM3_BT15_PWM_TMCR_MDSE                *((volatile unsigned int*)(0x424AD988UL))
#define bFM3_BT15_PWM_TMCR_OSEL                *((volatile unsigned int*)(0x424AD98CUL))
#define bFM3_BT15_PWM_TMCR_EGS0                *((volatile unsigned int*)(0x424AD9A0UL))
#define bFM3_BT15_PWM_TMCR_EGS1                *((volatile unsigned int*)(0x424AD9A4UL))
#define bFM3_BT15_PWM_TMCR_PMSK                *((volatile unsigned int*)(0x424AD9A8UL))
#define bFM3_BT15_PWM_TMCR_RTGEN               *((volatile unsigned int*)(0x424AD9ACUL))
#define bFM3_BT15_PWM_TMCR_CKS0                *((volatile unsigned int*)(0x424AD9B0UL))
#define bFM3_BT15_PWM_TMCR_CKS1                *((volatile unsigned int*)(0x424AD9B4UL))
#define bFM3_BT15_PWM_TMCR_CKS2                *((volatile unsigned int*)(0x424AD9B8UL))
#define bFM3_BT15_PWM_STC_UDIR                 *((volatile unsigned int*)(0x424ADA00UL))
#define bFM3_BT15_PWM_STC_DTIR                 *((volatile unsigned int*)(0x424ADA04UL))
#define bFM3_BT15_PWM_STC_TGIR                 *((volatile unsigned int*)(0x424ADA08UL))
#define bFM3_BT15_PWM_STC_UDIE                 *((volatile unsigned int*)(0x424ADA10UL))
#define bFM3_BT15_PWM_STC_DTIE                 *((volatile unsigned int*)(0x424ADA14UL))
#define bFM3_BT15_PWM_STC_TGIE                 *((volatile unsigned int*)(0x424ADA18UL))
#define bFM3_BT15_PWM_TMCR2_CKS3               *((volatile unsigned int*)(0x424ADA20UL))

/* Base Timer 15 RT registers */
#define bFM3_BT15_RT_TMCR_STRG                 *((volatile unsigned int*)(0x424AD980UL))
#define bFM3_BT15_RT_TMCR_CTEN                 *((volatile unsigned int*)(0x424AD984UL))
#define bFM3_BT15_RT_TMCR_MDSE                 *((volatile unsigned int*)(0x424AD988UL))
#define bFM3_BT15_RT_TMCR_OSEL                 *((volatile unsigned int*)(0x424AD98CUL))
#define bFM3_BT15_RT_TMCR_T32                  *((volatile unsigned int*)(0x424AD99CUL))
#define bFM3_BT15_RT_TMCR_EGS0                 *((volatile unsigned int*)(0x424AD9A0UL))
#define bFM3_BT15_RT_TMCR_EGS1                 *((volatile unsigned int*)(0x424AD9A4UL))
#define bFM3_BT15_RT_TMCR_CKS0                 *((volatile unsigned int*)(0x424AD9B0UL))
#define bFM3_BT15_RT_TMCR_CKS1                 *((volatile unsigned int*)(0x424AD9B4UL))
#define bFM3_BT15_RT_TMCR_CKS2                 *((volatile unsigned int*)(0x424AD9B8UL))
#define bFM3_BT15_RT_STC_UDIR                  *((volatile unsigned int*)(0x424ADA00UL))
#define bFM3_BT15_RT_STC_TGIR                  *((volatile unsigned int*)(0x424ADA08UL))
#define bFM3_BT15_RT_STC_UDIE                  *((volatile unsigned int*)(0x424ADA10UL))
#define bFM3_BT15_RT_STC_TGIE                  *((volatile unsigned int*)(0x424ADA18UL))
#define bFM3_BT15_RT_TMCR2_CKS3                *((volatile unsigned int*)(0x424ADA20UL))

/* Base Timer 15 PWC registers */
#define bFM3_BT15_PWC_TMCR_CTEN                *((volatile unsigned int*)(0x424AD984UL))
#define bFM3_BT15_PWC_TMCR_MDSE                *((volatile unsigned int*)(0x424AD988UL))
#define bFM3_BT15_PWC_TMCR_T32                 *((volatile unsigned int*)(0x424AD99CUL))
#define bFM3_BT15_PWC_TMCR_EGS0                *((volatile unsigned int*)(0x424AD9A0UL))
#define bFM3_BT15_PWC_TMCR_EGS1                *((volatile unsigned int*)(0x424AD9A4UL))
#define bFM3_BT15_PWC_TMCR_EGS2                *((volatile unsigned int*)(0x424AD9A8UL))
#define bFM3_BT15_PWC_TMCR_CKS0                *((volatile unsigned int*)(0x424AD9B0UL))
#define bFM3_BT15_PWC_TMCR_CKS1                *((volatile unsigned int*)(0x424AD9B4UL))
#define bFM3_BT15_PWC_TMCR_CKS2                *((volatile unsigned int*)(0x424AD9B8UL))
#define bFM3_BT15_PWC_STC_OVIR                 *((volatile unsigned int*)(0x424ADA00UL))
#define bFM3_BT15_PWC_STC_EDIR                 *((volatile unsigned int*)(0x424ADA08UL))
#define bFM3_BT15_PWC_STC_OVIE                 *((volatile unsigned int*)(0x424ADA10UL))
#define bFM3_BT15_PWC_STC_EDIE                 *((volatile unsigned int*)(0x424ADA18UL))
#define bFM3_BT15_PWC_STC_ERR                  *((volatile unsigned int*)(0x424ADA1CUL))
#define bFM3_BT15_PWC_TMCR2_CKS3               *((volatile unsigned int*)(0x424ADA20UL))

/* Base Timer I/O selector channel 8 - channel 11 registers */
#define bFM3_BTIOSEL8B_BTSEL89AB_SEL89_0       *((volatile unsigned int*)(0x424AA020UL))
#define bFM3_BTIOSEL8B_BTSEL89AB_SEL89_1       *((volatile unsigned int*)(0x424AA024UL))
#define bFM3_BTIOSEL8B_BTSEL89AB_SEL89_2       *((volatile unsigned int*)(0x424AA028UL))
#define bFM3_BTIOSEL8B_BTSEL89AB_SEL89_3       *((volatile unsigned int*)(0x424AA02CUL))
#define bFM3_BTIOSEL8B_BTSEL89AB_SELAB_0       *((volatile unsigned int*)(0x424AA030UL))
#define bFM3_BTIOSEL8B_BTSEL89AB_SELAB_1       *((volatile unsigned int*)(0x424AA034UL))
#define bFM3_BTIOSEL8B_BTSEL89AB_SELAB_2       *((volatile unsigned int*)(0x424AA038UL))
#define bFM3_BTIOSEL8B_BTSEL89AB_SELAB_3       *((volatile unsigned int*)(0x424AA03CUL))

/* Base Timer I/O selector channel 12 - channel 15 registers */
#define bFM3_BTIOSELCF_BTSELCDEF_SELCD_0       *((volatile unsigned int*)(0x424AE020UL))
#define bFM3_BTIOSELCF_BTSELCDEF_SELCD_1       *((volatile unsigned int*)(0x424AE024UL))
#define bFM3_BTIOSELCF_BTSELCDEF_SELCD_2       *((volatile unsigned int*)(0x424AE028UL))
#define bFM3_BTIOSELCF_BTSELCDEF_SELCD_3       *((volatile unsigned int*)(0x424AE02CUL))
#define bFM3_BTIOSELCF_BTSELCDEF_SELEF_0       *((volatile unsigned int*)(0x424AE030UL))
#define bFM3_BTIOSELCF_BTSELCDEF_SELEF_1       *((volatile unsigned int*)(0x424AE034UL))
#define bFM3_BTIOSELCF_BTSELCDEF_SELEF_2       *((volatile unsigned int*)(0x424AE038UL))
#define bFM3_BTIOSELCF_BTSELCDEF_SELEF_3       *((volatile unsigned int*)(0x424AE03CUL))

/* Software based Simulation Startup (Base Timer) register */
#define bFM3_SBSSR_BTSSSR_SSSR0                *((volatile unsigned int*)(0x424BFF80UL))
#define bFM3_SBSSR_BTSSSR_SSSR1                *((volatile unsigned int*)(0x424BFF84UL))
#define bFM3_SBSSR_BTSSSR_SSSR2                *((volatile unsigned int*)(0x424BFF88UL))
#define bFM3_SBSSR_BTSSSR_SSSR3                *((volatile unsigned int*)(0x424BFF8CUL))
#define bFM3_SBSSR_BTSSSR_SSSR4                *((volatile unsigned int*)(0x424BFF90UL))
#define bFM3_SBSSR_BTSSSR_SSSR5                *((volatile unsigned int*)(0x424BFF94UL))
#define bFM3_SBSSR_BTSSSR_SSSR6                *((volatile unsigned int*)(0x424BFF98UL))
#define bFM3_SBSSR_BTSSSR_SSSR7                *((volatile unsigned int*)(0x424BFF9CUL))
#define bFM3_SBSSR_BTSSSR_SSSR8                *((volatile unsigned int*)(0x424BFFA0UL))
#define bFM3_SBSSR_BTSSSR_SSSR9                *((volatile unsigned int*)(0x424BFFA4UL))
#define bFM3_SBSSR_BTSSSR_SSSR10               *((volatile unsigned int*)(0x424BFFA8UL))
#define bFM3_SBSSR_BTSSSR_SSSR11               *((volatile unsigned int*)(0x424BFFACUL))
#define bFM3_SBSSR_BTSSSR_SSSR12               *((volatile unsigned int*)(0x424BFFB0UL))
#define bFM3_SBSSR_BTSSSR_SSSR13               *((volatile unsigned int*)(0x424BFFB4UL))
#define bFM3_SBSSR_BTSSSR_SSSR14               *((volatile unsigned int*)(0x424BFFB8UL))
#define bFM3_SBSSR_BTSSSR_SSSR15               *((volatile unsigned int*)(0x424BFFBCUL))

/* Quad position and revolution counter channel 0 registers */
#define bFM3_QPRC0_QICR_QPCMIE                 *((volatile unsigned int*)(0x424C0280UL))
#define bFM3_QPRC0_QICR_QPCMF                  *((volatile unsigned int*)(0x424C0284UL))
#define bFM3_QPRC0_QICR_QPRCMIE                *((volatile unsigned int*)(0x424C0288UL))
#define bFM3_QPRC0_QICR_QPRCMF                 *((volatile unsigned int*)(0x424C028CUL))
#define bFM3_QPRC0_QICR_OUZIE                  *((volatile unsigned int*)(0x424C0290UL))
#define bFM3_QPRC0_QICR_UFDF                   *((volatile unsigned int*)(0x424C0294UL))
#define bFM3_QPRC0_QICR_OFDF                   *((volatile unsigned int*)(0x424C0298UL))
#define bFM3_QPRC0_QICR_ZIIF                   *((volatile unsigned int*)(0x424C029CUL))
#define bFM3_QPRC0_QICR_CDCIE                  *((volatile unsigned int*)(0x424C02A0UL))
#define bFM3_QPRC0_QICR_CDCF                   *((volatile unsigned int*)(0x424C02A4UL))
#define bFM3_QPRC0_QICR_DIRPC                  *((volatile unsigned int*)(0x424C02A8UL))
#define bFM3_QPRC0_QICR_DIROU                  *((volatile unsigned int*)(0x424C02ACUL))
#define bFM3_QPRC0_QICR_QPCNRCMIE              *((volatile unsigned int*)(0x424C02B0UL))
#define bFM3_QPRC0_QICR_QPCNRCMF               *((volatile unsigned int*)(0x424C02B4UL))
#define bFM3_QPRC0_QICRL_QPCMIE                *((volatile unsigned int*)(0x424C0280UL))
#define bFM3_QPRC0_QICRL_QPCMF                 *((volatile unsigned int*)(0x424C0284UL))
#define bFM3_QPRC0_QICRL_QPRCMIE               *((volatile unsigned int*)(0x424C0288UL))
#define bFM3_QPRC0_QICRL_QPRCMF                *((volatile unsigned int*)(0x424C028CUL))
#define bFM3_QPRC0_QICRL_OUZIE                 *((volatile unsigned int*)(0x424C0290UL))
#define bFM3_QPRC0_QICRL_UFDF                  *((volatile unsigned int*)(0x424C0294UL))
#define bFM3_QPRC0_QICRL_OFDF                  *((volatile unsigned int*)(0x424C0298UL))
#define bFM3_QPRC0_QICRL_ZIIF                  *((volatile unsigned int*)(0x424C029CUL))
#define bFM3_QPRC0_QICRH_CDCIE                 *((volatile unsigned int*)(0x424C02A0UL))
#define bFM3_QPRC0_QICRH_CDCF                  *((volatile unsigned int*)(0x424C02A4UL))
#define bFM3_QPRC0_QICRH_DIRPC                 *((volatile unsigned int*)(0x424C02A8UL))
#define bFM3_QPRC0_QICRH_DIROU                 *((volatile unsigned int*)(0x424C02ACUL))
#define bFM3_QPRC0_QICRH_QPCNRCMIE             *((volatile unsigned int*)(0x424C02B0UL))
#define bFM3_QPRC0_QICRH_QPCNRCMF              *((volatile unsigned int*)(0x424C02B4UL))
#define bFM3_QPRC0_QCR_PCM0                    *((volatile unsigned int*)(0x424C0300UL))
#define bFM3_QPRC0_QCR_PCM1                    *((volatile unsigned int*)(0x424C0304UL))
#define bFM3_QPRC0_QCR_RCM0                    *((volatile unsigned int*)(0x424C0308UL))
#define bFM3_QPRC0_QCR_RCM1                    *((volatile unsigned int*)(0x424C030CUL))
#define bFM3_QPRC0_QCR_PSTP                    *((volatile unsigned int*)(0x424C0310UL))
#define bFM3_QPRC0_QCR_CGSC                    *((volatile unsigned int*)(0x424C0314UL))
#define bFM3_QPRC0_QCR_RSEL                    *((volatile unsigned int*)(0x424C0318UL))
#define bFM3_QPRC0_QCR_SWAP                    *((volatile unsigned int*)(0x424C031CUL))
#define bFM3_QPRC0_QCR_PCRM0                   *((volatile unsigned int*)(0x424C0320UL))
#define bFM3_QPRC0_QCR_PCRM1                   *((volatile unsigned int*)(0x424C0324UL))
#define bFM3_QPRC0_QCR_AES0                    *((volatile unsigned int*)(0x424C0328UL))
#define bFM3_QPRC0_QCR_AES1                    *((volatile unsigned int*)(0x424C032CUL))
#define bFM3_QPRC0_QCR_BES0                    *((volatile unsigned int*)(0x424C0330UL))
#define bFM3_QPRC0_QCR_BES1                    *((volatile unsigned int*)(0x424C0334UL))
#define bFM3_QPRC0_QCR_CGE0                    *((volatile unsigned int*)(0x424C0338UL))
#define bFM3_QPRC0_QCR_CGE1                    *((volatile unsigned int*)(0x424C033CUL))
#define bFM3_QPRC0_QCRL_PCM0                   *((volatile unsigned int*)(0x424C0300UL))
#define bFM3_QPRC0_QCRL_PCM1                   *((volatile unsigned int*)(0x424C0304UL))
#define bFM3_QPRC0_QCRL_RCM0                   *((volatile unsigned int*)(0x424C0308UL))
#define bFM3_QPRC0_QCRL_RCM1                   *((volatile unsigned int*)(0x424C030CUL))
#define bFM3_QPRC0_QCRL_PSTP                   *((volatile unsigned int*)(0x424C0310UL))
#define bFM3_QPRC0_QCRL_CGSC                   *((volatile unsigned int*)(0x424C0314UL))
#define bFM3_QPRC0_QCRL_RSEL                   *((volatile unsigned int*)(0x424C0318UL))
#define bFM3_QPRC0_QCRL_SWAP                   *((volatile unsigned int*)(0x424C031CUL))
#define bFM3_QPRC0_QCRH_PCRM0                  *((volatile unsigned int*)(0x424C0320UL))
#define bFM3_QPRC0_QCRH_PCRM1                  *((volatile unsigned int*)(0x424C0324UL))
#define bFM3_QPRC0_QCRH_AES0                   *((volatile unsigned int*)(0x424C0328UL))
#define bFM3_QPRC0_QCRH_AES1                   *((volatile unsigned int*)(0x424C032CUL))
#define bFM3_QPRC0_QCRH_BES0                   *((volatile unsigned int*)(0x424C0330UL))
#define bFM3_QPRC0_QCRH_BES1                   *((volatile unsigned int*)(0x424C0334UL))
#define bFM3_QPRC0_QCRH_CGE0                   *((volatile unsigned int*)(0x424C0338UL))
#define bFM3_QPRC0_QCRH_CGE1                   *((volatile unsigned int*)(0x424C033CUL))
#define bFM3_QPRC0_QECR_ORNGMD                 *((volatile unsigned int*)(0x424C0380UL))
#define bFM3_QPRC0_QECR_ORNGF                  *((volatile unsigned int*)(0x424C0384UL))
#define bFM3_QPRC0_QECR_ORNGIE                 *((volatile unsigned int*)(0x424C0388UL))

/* Quad position and revolution counter channel 1 registers */
#define bFM3_QPRC1_QICR_QPCMIE                 *((volatile unsigned int*)(0x424C0A80UL))
#define bFM3_QPRC1_QICR_QPCMF                  *((volatile unsigned int*)(0x424C0A84UL))
#define bFM3_QPRC1_QICR_QPRCMIE                *((volatile unsigned int*)(0x424C0A88UL))
#define bFM3_QPRC1_QICR_QPRCMF                 *((volatile unsigned int*)(0x424C0A8CUL))
#define bFM3_QPRC1_QICR_OUZIE                  *((volatile unsigned int*)(0x424C0A90UL))
#define bFM3_QPRC1_QICR_UFDF                   *((volatile unsigned int*)(0x424C0A94UL))
#define bFM3_QPRC1_QICR_OFDF                   *((volatile unsigned int*)(0x424C0A98UL))
#define bFM3_QPRC1_QICR_ZIIF                   *((volatile unsigned int*)(0x424C0A9CUL))
#define bFM3_QPRC1_QICR_CDCIE                  *((volatile unsigned int*)(0x424C0AA0UL))
#define bFM3_QPRC1_QICR_CDCF                   *((volatile unsigned int*)(0x424C0AA4UL))
#define bFM3_QPRC1_QICR_DIRPC                  *((volatile unsigned int*)(0x424C0AA8UL))
#define bFM3_QPRC1_QICR_DIROU                  *((volatile unsigned int*)(0x424C0AACUL))
#define bFM3_QPRC1_QICR_QPCNRCMIE              *((volatile unsigned int*)(0x424C0AB0UL))
#define bFM3_QPRC1_QICR_QPCNRCMF               *((volatile unsigned int*)(0x424C0AB4UL))
#define bFM3_QPRC1_QICRL_QPCMIE                *((volatile unsigned int*)(0x424C0A80UL))
#define bFM3_QPRC1_QICRL_QPCMF                 *((volatile unsigned int*)(0x424C0A84UL))
#define bFM3_QPRC1_QICRL_QPRCMIE               *((volatile unsigned int*)(0x424C0A88UL))
#define bFM3_QPRC1_QICRL_QPRCMF                *((volatile unsigned int*)(0x424C0A8CUL))
#define bFM3_QPRC1_QICRL_OUZIE                 *((volatile unsigned int*)(0x424C0A90UL))
#define bFM3_QPRC1_QICRL_UFDF                  *((volatile unsigned int*)(0x424C0A94UL))
#define bFM3_QPRC1_QICRL_OFDF                  *((volatile unsigned int*)(0x424C0A98UL))
#define bFM3_QPRC1_QICRL_ZIIF                  *((volatile unsigned int*)(0x424C0A9CUL))
#define bFM3_QPRC1_QICRH_CDCIE                 *((volatile unsigned int*)(0x424C0AA0UL))
#define bFM3_QPRC1_QICRH_CDCF                  *((volatile unsigned int*)(0x424C0AA4UL))
#define bFM3_QPRC1_QICRH_DIRPC                 *((volatile unsigned int*)(0x424C0AA8UL))
#define bFM3_QPRC1_QICRH_DIROU                 *((volatile unsigned int*)(0x424C0AACUL))
#define bFM3_QPRC1_QICRH_QPCNRCMIE             *((volatile unsigned int*)(0x424C0AB0UL))
#define bFM3_QPRC1_QICRH_QPCNRCMF              *((volatile unsigned int*)(0x424C0AB4UL))
#define bFM3_QPRC1_QCR_PCM0                    *((volatile unsigned int*)(0x424C0B00UL))
#define bFM3_QPRC1_QCR_PCM1                    *((volatile unsigned int*)(0x424C0B04UL))
#define bFM3_QPRC1_QCR_RCM0                    *((volatile unsigned int*)(0x424C0B08UL))
#define bFM3_QPRC1_QCR_RCM1                    *((volatile unsigned int*)(0x424C0B0CUL))
#define bFM3_QPRC1_QCR_PSTP                    *((volatile unsigned int*)(0x424C0B10UL))
#define bFM3_QPRC1_QCR_CGSC                    *((volatile unsigned int*)(0x424C0B14UL))
#define bFM3_QPRC1_QCR_RSEL                    *((volatile unsigned int*)(0x424C0B18UL))
#define bFM3_QPRC1_QCR_SWAP                    *((volatile unsigned int*)(0x424C0B1CUL))
#define bFM3_QPRC1_QCR_PCRM0                   *((volatile unsigned int*)(0x424C0B20UL))
#define bFM3_QPRC1_QCR_PCRM1                   *((volatile unsigned int*)(0x424C0B24UL))
#define bFM3_QPRC1_QCR_AES0                    *((volatile unsigned int*)(0x424C0B28UL))
#define bFM3_QPRC1_QCR_AES1                    *((volatile unsigned int*)(0x424C0B2CUL))
#define bFM3_QPRC1_QCR_BES0                    *((volatile unsigned int*)(0x424C0B30UL))
#define bFM3_QPRC1_QCR_BES1                    *((volatile unsigned int*)(0x424C0B34UL))
#define bFM3_QPRC1_QCR_CGE0                    *((volatile unsigned int*)(0x424C0B38UL))
#define bFM3_QPRC1_QCR_CGE1                    *((volatile unsigned int*)(0x424C0B3CUL))
#define bFM3_QPRC1_QCRL_PCM0                   *((volatile unsigned int*)(0x424C0B00UL))
#define bFM3_QPRC1_QCRL_PCM1                   *((volatile unsigned int*)(0x424C0B04UL))
#define bFM3_QPRC1_QCRL_RCM0                   *((volatile unsigned int*)(0x424C0B08UL))
#define bFM3_QPRC1_QCRL_RCM1                   *((volatile unsigned int*)(0x424C0B0CUL))
#define bFM3_QPRC1_QCRL_PSTP                   *((volatile unsigned int*)(0x424C0B10UL))
#define bFM3_QPRC1_QCRL_CGSC                   *((volatile unsigned int*)(0x424C0B14UL))
#define bFM3_QPRC1_QCRL_RSEL                   *((volatile unsigned int*)(0x424C0B18UL))
#define bFM3_QPRC1_QCRL_SWAP                   *((volatile unsigned int*)(0x424C0B1CUL))
#define bFM3_QPRC1_QCRH_PCRM0                  *((volatile unsigned int*)(0x424C0B20UL))
#define bFM3_QPRC1_QCRH_PCRM1                  *((volatile unsigned int*)(0x424C0B24UL))
#define bFM3_QPRC1_QCRH_AES0                   *((volatile unsigned int*)(0x424C0B28UL))
#define bFM3_QPRC1_QCRH_AES1                   *((volatile unsigned int*)(0x424C0B2CUL))
#define bFM3_QPRC1_QCRH_BES0                   *((volatile unsigned int*)(0x424C0B30UL))
#define bFM3_QPRC1_QCRH_BES1                   *((volatile unsigned int*)(0x424C0B34UL))
#define bFM3_QPRC1_QCRH_CGE0                   *((volatile unsigned int*)(0x424C0B38UL))
#define bFM3_QPRC1_QCRH_CGE1                   *((volatile unsigned int*)(0x424C0B3CUL))
#define bFM3_QPRC1_QECR_ORNGMD                 *((volatile unsigned int*)(0x424C0B80UL))
#define bFM3_QPRC1_QECR_ORNGF                  *((volatile unsigned int*)(0x424C0B84UL))
#define bFM3_QPRC1_QECR_ORNGIE                 *((volatile unsigned int*)(0x424C0B88UL))

/* Quad position and revolution counter channel 2 registers */
#define bFM3_QPRC2_QICR_QPCMIE                 *((volatile unsigned int*)(0x424C1280UL))
#define bFM3_QPRC2_QICR_QPCMF                  *((volatile unsigned int*)(0x424C1284UL))
#define bFM3_QPRC2_QICR_QPRCMIE                *((volatile unsigned int*)(0x424C1288UL))
#define bFM3_QPRC2_QICR_QPRCMF                 *((volatile unsigned int*)(0x424C128CUL))
#define bFM3_QPRC2_QICR_OUZIE                  *((volatile unsigned int*)(0x424C1290UL))
#define bFM3_QPRC2_QICR_UFDF                   *((volatile unsigned int*)(0x424C1294UL))
#define bFM3_QPRC2_QICR_OFDF                   *((volatile unsigned int*)(0x424C1298UL))
#define bFM3_QPRC2_QICR_ZIIF                   *((volatile unsigned int*)(0x424C129CUL))
#define bFM3_QPRC2_QICR_CDCIE                  *((volatile unsigned int*)(0x424C12A0UL))
#define bFM3_QPRC2_QICR_CDCF                   *((volatile unsigned int*)(0x424C12A4UL))
#define bFM3_QPRC2_QICR_DIRPC                  *((volatile unsigned int*)(0x424C12A8UL))
#define bFM3_QPRC2_QICR_DIROU                  *((volatile unsigned int*)(0x424C12ACUL))
#define bFM3_QPRC2_QICR_QPCNRCMIE              *((volatile unsigned int*)(0x424C12B0UL))
#define bFM3_QPRC2_QICR_QPCNRCMF               *((volatile unsigned int*)(0x424C12B4UL))
#define bFM3_QPRC2_QICRL_QPCMIE                *((volatile unsigned int*)(0x424C1280UL))
#define bFM3_QPRC2_QICRL_QPCMF                 *((volatile unsigned int*)(0x424C1284UL))
#define bFM3_QPRC2_QICRL_QPRCMIE               *((volatile unsigned int*)(0x424C1288UL))
#define bFM3_QPRC2_QICRL_QPRCMF                *((volatile unsigned int*)(0x424C128CUL))
#define bFM3_QPRC2_QICRL_OUZIE                 *((volatile unsigned int*)(0x424C1290UL))
#define bFM3_QPRC2_QICRL_UFDF                  *((volatile unsigned int*)(0x424C1294UL))
#define bFM3_QPRC2_QICRL_OFDF                  *((volatile unsigned int*)(0x424C1298UL))
#define bFM3_QPRC2_QICRL_ZIIF                  *((volatile unsigned int*)(0x424C129CUL))
#define bFM3_QPRC2_QICRH_CDCIE                 *((volatile unsigned int*)(0x424C12A0UL))
#define bFM3_QPRC2_QICRH_CDCF                  *((volatile unsigned int*)(0x424C12A4UL))
#define bFM3_QPRC2_QICRH_DIRPC                 *((volatile unsigned int*)(0x424C12A8UL))
#define bFM3_QPRC2_QICRH_DIROU                 *((volatile unsigned int*)(0x424C12ACUL))
#define bFM3_QPRC2_QICRH_QPCNRCMIE             *((volatile unsigned int*)(0x424C12B0UL))
#define bFM3_QPRC2_QICRH_QPCNRCMF              *((volatile unsigned int*)(0x424C12B4UL))
#define bFM3_QPRC2_QCR_PCM0                    *((volatile unsigned int*)(0x424C1300UL))
#define bFM3_QPRC2_QCR_PCM1                    *((volatile unsigned int*)(0x424C1304UL))
#define bFM3_QPRC2_QCR_RCM0                    *((volatile unsigned int*)(0x424C1308UL))
#define bFM3_QPRC2_QCR_RCM1                    *((volatile unsigned int*)(0x424C130CUL))
#define bFM3_QPRC2_QCR_PSTP                    *((volatile unsigned int*)(0x424C1310UL))
#define bFM3_QPRC2_QCR_CGSC                    *((volatile unsigned int*)(0x424C1314UL))
#define bFM3_QPRC2_QCR_RSEL                    *((volatile unsigned int*)(0x424C1318UL))
#define bFM3_QPRC2_QCR_SWAP                    *((volatile unsigned int*)(0x424C131CUL))
#define bFM3_QPRC2_QCR_PCRM0                   *((volatile unsigned int*)(0x424C1320UL))
#define bFM3_QPRC2_QCR_PCRM1                   *((volatile unsigned int*)(0x424C1324UL))
#define bFM3_QPRC2_QCR_AES0                    *((volatile unsigned int*)(0x424C1328UL))
#define bFM3_QPRC2_QCR_AES1                    *((volatile unsigned int*)(0x424C132CUL))
#define bFM3_QPRC2_QCR_BES0                    *((volatile unsigned int*)(0x424C1330UL))
#define bFM3_QPRC2_QCR_BES1                    *((volatile unsigned int*)(0x424C1334UL))
#define bFM3_QPRC2_QCR_CGE0                    *((volatile unsigned int*)(0x424C1338UL))
#define bFM3_QPRC2_QCR_CGE1                    *((volatile unsigned int*)(0x424C133CUL))
#define bFM3_QPRC2_QCRL_PCM0                   *((volatile unsigned int*)(0x424C1300UL))
#define bFM3_QPRC2_QCRL_PCM1                   *((volatile unsigned int*)(0x424C1304UL))
#define bFM3_QPRC2_QCRL_RCM0                   *((volatile unsigned int*)(0x424C1308UL))
#define bFM3_QPRC2_QCRL_RCM1                   *((volatile unsigned int*)(0x424C130CUL))
#define bFM3_QPRC2_QCRL_PSTP                   *((volatile unsigned int*)(0x424C1310UL))
#define bFM3_QPRC2_QCRL_CGSC                   *((volatile unsigned int*)(0x424C1314UL))
#define bFM3_QPRC2_QCRL_RSEL                   *((volatile unsigned int*)(0x424C1318UL))
#define bFM3_QPRC2_QCRL_SWAP                   *((volatile unsigned int*)(0x424C131CUL))
#define bFM3_QPRC2_QCRH_PCRM0                  *((volatile unsigned int*)(0x424C1320UL))
#define bFM3_QPRC2_QCRH_PCRM1                  *((volatile unsigned int*)(0x424C1324UL))
#define bFM3_QPRC2_QCRH_AES0                   *((volatile unsigned int*)(0x424C1328UL))
#define bFM3_QPRC2_QCRH_AES1                   *((volatile unsigned int*)(0x424C132CUL))
#define bFM3_QPRC2_QCRH_BES0                   *((volatile unsigned int*)(0x424C1330UL))
#define bFM3_QPRC2_QCRH_BES1                   *((volatile unsigned int*)(0x424C1334UL))
#define bFM3_QPRC2_QCRH_CGE0                   *((volatile unsigned int*)(0x424C1338UL))
#define bFM3_QPRC2_QCRH_CGE1                   *((volatile unsigned int*)(0x424C133CUL))
#define bFM3_QPRC2_QECR_ORNGMD                 *((volatile unsigned int*)(0x424C1380UL))
#define bFM3_QPRC2_QECR_ORNGF                  *((volatile unsigned int*)(0x424C1384UL))
#define bFM3_QPRC2_QECR_ORNGIE                 *((volatile unsigned int*)(0x424C1388UL))

/* 12-bit ADC unit 0 registers */
#define bFM3_ADC0_ADSR_SCS                     *((volatile unsigned int*)(0x424E0000UL))
#define bFM3_ADC0_ADSR_PCS                     *((volatile unsigned int*)(0x424E0004UL))
#define bFM3_ADC0_ADSR_PCNS                    *((volatile unsigned int*)(0x424E0008UL))
#define bFM3_ADC0_ADSR_FDAS                    *((volatile unsigned int*)(0x424E0018UL))
#define bFM3_ADC0_ADSR_ADSTP                   *((volatile unsigned int*)(0x424E001CUL))
#define bFM3_ADC0_ADCR_OVRIE                   *((volatile unsigned int*)(0x424E0020UL))
#define bFM3_ADC0_ADCR_CMPIE                   *((volatile unsigned int*)(0x424E0024UL))
#define bFM3_ADC0_ADCR_PCIE                    *((volatile unsigned int*)(0x424E0028UL))
#define bFM3_ADC0_ADCR_SCIE                    *((volatile unsigned int*)(0x424E002CUL))
#define bFM3_ADC0_ADCR_CMPIF                   *((volatile unsigned int*)(0x424E0034UL))
#define bFM3_ADC0_ADCR_PCIF                    *((volatile unsigned int*)(0x424E0038UL))
#define bFM3_ADC0_ADCR_SCIF                    *((volatile unsigned int*)(0x424E003CUL))
#define bFM3_ADC0_SFNS_SFS0                    *((volatile unsigned int*)(0x424E0100UL))
#define bFM3_ADC0_SFNS_SFS1                    *((volatile unsigned int*)(0x424E0104UL))
#define bFM3_ADC0_SFNS_SFS2                    *((volatile unsigned int*)(0x424E0108UL))
#define bFM3_ADC0_SFNS_SFS3                    *((volatile unsigned int*)(0x424E010CUL))
#define bFM3_ADC0_SCCR_SSTR                    *((volatile unsigned int*)(0x424E0120UL))
#define bFM3_ADC0_SCCR_SHEN                    *((volatile unsigned int*)(0x424E0124UL))
#define bFM3_ADC0_SCCR_RPT                     *((volatile unsigned int*)(0x424E0128UL))
#define bFM3_ADC0_SCCR_SFCLR                   *((volatile unsigned int*)(0x424E0130UL))
#define bFM3_ADC0_SCCR_SOVR                    *((volatile unsigned int*)(0x424E0134UL))
#define bFM3_ADC0_SCCR_SFUL                    *((volatile unsigned int*)(0x424E0138UL))
#define bFM3_ADC0_SCCR_SEMP                    *((volatile unsigned int*)(0x424E013CUL))
#define bFM3_ADC0_SCFDL_SC0                    *((volatile unsigned short*)(0x424E0180UL))
#define bFM3_ADC0_SCFDL_SC1                    *((volatile unsigned short*)(0x424E0184UL))
#define bFM3_ADC0_SCFDL_SC2                    *((volatile unsigned short*)(0x424E0188UL))
#define bFM3_ADC0_SCFDL_SC3                    *((volatile unsigned short*)(0x424E018CUL))
#define bFM3_ADC0_SCFDL_SC4                    *((volatile unsigned short*)(0x424E0190UL))
#define bFM3_ADC0_SCFDL_RS0                    *((volatile unsigned short*)(0x424E01A0UL))
#define bFM3_ADC0_SCFDL_RS1                    *((volatile unsigned short*)(0x424E01A4UL))
#define bFM3_ADC0_SCFDL_INVL                   *((volatile unsigned short*)(0x424E01B0UL))
#define bFM3_ADC0_SCFDH_SD0                    *((volatile unsigned short*)(0x424E01D0UL))
#define bFM3_ADC0_SCFDH_SD1                    *((volatile unsigned short*)(0x424E01D4UL))
#define bFM3_ADC0_SCFDH_SD2                    *((volatile unsigned short*)(0x424E01D8UL))
#define bFM3_ADC0_SCFDH_SD3                    *((volatile unsigned short*)(0x424E01DCUL))
#define bFM3_ADC0_SCFDH_SD4                    *((volatile unsigned short*)(0x424E01E0UL))
#define bFM3_ADC0_SCFDH_SD5                    *((volatile unsigned short*)(0x424E01E4UL))
#define bFM3_ADC0_SCFDH_SD6                    *((volatile unsigned short*)(0x424E01E8UL))
#define bFM3_ADC0_SCFDH_SD7                    *((volatile unsigned short*)(0x424E01ECUL))
#define bFM3_ADC0_SCFDH_SD8                    *((volatile unsigned short*)(0x424E01F0UL))
#define bFM3_ADC0_SCFDH_SD9                    *((volatile unsigned short*)(0x424E01F4UL))
#define bFM3_ADC0_SCFDH_SD10                   *((volatile unsigned short*)(0x424E01F8UL))
#define bFM3_ADC0_SCFDH_SD11                   *((volatile unsigned short*)(0x424E01FCUL))
#define bFM3_ADC0_SCIS23_AN16                  *((volatile unsigned int*)(0x424E0200UL))
#define bFM3_ADC0_SCIS23_AN17                  *((volatile unsigned int*)(0x424E0204UL))
#define bFM3_ADC0_SCIS23_AN18                  *((volatile unsigned int*)(0x424E0208UL))
#define bFM3_ADC0_SCIS23_AN19                  *((volatile unsigned int*)(0x424E020CUL))
#define bFM3_ADC0_SCIS23_AN20                  *((volatile unsigned int*)(0x424E0210UL))
#define bFM3_ADC0_SCIS23_AN21                  *((volatile unsigned int*)(0x424E0214UL))
#define bFM3_ADC0_SCIS23_AN22                  *((volatile unsigned int*)(0x424E0218UL))
#define bFM3_ADC0_SCIS23_AN23                  *((volatile unsigned int*)(0x424E021CUL))
#define bFM3_ADC0_SCIS23_AN24                  *((volatile unsigned int*)(0x424E0220UL))
#define bFM3_ADC0_SCIS23_AN25                  *((volatile unsigned int*)(0x424E0224UL))
#define bFM3_ADC0_SCIS23_AN26                  *((volatile unsigned int*)(0x424E0228UL))
#define bFM3_ADC0_SCIS23_AN27                  *((volatile unsigned int*)(0x424E022CUL))
#define bFM3_ADC0_SCIS23_AN28                  *((volatile unsigned int*)(0x424E0230UL))
#define bFM3_ADC0_SCIS23_AN29                  *((volatile unsigned int*)(0x424E0234UL))
#define bFM3_ADC0_SCIS23_AN30                  *((volatile unsigned int*)(0x424E0238UL))
#define bFM3_ADC0_SCIS23_AN31                  *((volatile unsigned int*)(0x424E023CUL))
#define bFM3_ADC0_SCIS2_AN16                   *((volatile unsigned int*)(0x424E0200UL))
#define bFM3_ADC0_SCIS2_AN17                   *((volatile unsigned int*)(0x424E0204UL))
#define bFM3_ADC0_SCIS2_AN18                   *((volatile unsigned int*)(0x424E0208UL))
#define bFM3_ADC0_SCIS2_AN19                   *((volatile unsigned int*)(0x424E020CUL))
#define bFM3_ADC0_SCIS2_AN20                   *((volatile unsigned int*)(0x424E0210UL))
#define bFM3_ADC0_SCIS2_AN21                   *((volatile unsigned int*)(0x424E0214UL))
#define bFM3_ADC0_SCIS2_AN22                   *((volatile unsigned int*)(0x424E0218UL))
#define bFM3_ADC0_SCIS2_AN23                   *((volatile unsigned int*)(0x424E021CUL))
#define bFM3_ADC0_SCIS3_AN24                   *((volatile unsigned int*)(0x424E0220UL))
#define bFM3_ADC0_SCIS3_AN25                   *((volatile unsigned int*)(0x424E0224UL))
#define bFM3_ADC0_SCIS3_AN26                   *((volatile unsigned int*)(0x424E0228UL))
#define bFM3_ADC0_SCIS3_AN27                   *((volatile unsigned int*)(0x424E022CUL))
#define bFM3_ADC0_SCIS3_AN28                   *((volatile unsigned int*)(0x424E0230UL))
#define bFM3_ADC0_SCIS3_AN29                   *((volatile unsigned int*)(0x424E0234UL))
#define bFM3_ADC0_SCIS3_AN30                   *((volatile unsigned int*)(0x424E0238UL))
#define bFM3_ADC0_SCIS3_AN31                   *((volatile unsigned int*)(0x424E023CUL))
#define bFM3_ADC0_SCIS01_AN0                   *((volatile unsigned int*)(0x424E0280UL))
#define bFM3_ADC0_SCIS01_AN1                   *((volatile unsigned int*)(0x424E0284UL))
#define bFM3_ADC0_SCIS01_AN2                   *((volatile unsigned int*)(0x424E0288UL))
#define bFM3_ADC0_SCIS01_AN3                   *((volatile unsigned int*)(0x424E028CUL))
#define bFM3_ADC0_SCIS01_AN4                   *((volatile unsigned int*)(0x424E0290UL))
#define bFM3_ADC0_SCIS01_AN5                   *((volatile unsigned int*)(0x424E0294UL))
#define bFM3_ADC0_SCIS01_AN6                   *((volatile unsigned int*)(0x424E0298UL))
#define bFM3_ADC0_SCIS01_AN7                   *((volatile unsigned int*)(0x424E029CUL))
#define bFM3_ADC0_SCIS01_AN8                   *((volatile unsigned int*)(0x424E02A0UL))
#define bFM3_ADC0_SCIS01_AN9                   *((volatile unsigned int*)(0x424E02A4UL))
#define bFM3_ADC0_SCIS01_AN10                  *((volatile unsigned int*)(0x424E02A8UL))
#define bFM3_ADC0_SCIS01_AN11                  *((volatile unsigned int*)(0x424E02ACUL))
#define bFM3_ADC0_SCIS01_AN12                  *((volatile unsigned int*)(0x424E02B0UL))
#define bFM3_ADC0_SCIS01_AN13                  *((volatile unsigned int*)(0x424E02B4UL))
#define bFM3_ADC0_SCIS01_AN14                  *((volatile unsigned int*)(0x424E02B8UL))
#define bFM3_ADC0_SCIS01_AN15                  *((volatile unsigned int*)(0x424E02BCUL))
#define bFM3_ADC0_SCIS0_AN0                    *((volatile unsigned int*)(0x424E0280UL))
#define bFM3_ADC0_SCIS0_AN1                    *((volatile unsigned int*)(0x424E0284UL))
#define bFM3_ADC0_SCIS0_AN2                    *((volatile unsigned int*)(0x424E0288UL))
#define bFM3_ADC0_SCIS0_AN3                    *((volatile unsigned int*)(0x424E028CUL))
#define bFM3_ADC0_SCIS0_AN4                    *((volatile unsigned int*)(0x424E0290UL))
#define bFM3_ADC0_SCIS0_AN5                    *((volatile unsigned int*)(0x424E0294UL))
#define bFM3_ADC0_SCIS0_AN6                    *((volatile unsigned int*)(0x424E0298UL))
#define bFM3_ADC0_SCIS0_AN7                    *((volatile unsigned int*)(0x424E029CUL))
#define bFM3_ADC0_SCIS1_AN8                    *((volatile unsigned int*)(0x424E02A0UL))
#define bFM3_ADC0_SCIS1_AN9                    *((volatile unsigned int*)(0x424E02A4UL))
#define bFM3_ADC0_SCIS1_AN10                   *((volatile unsigned int*)(0x424E02A8UL))
#define bFM3_ADC0_SCIS1_AN11                   *((volatile unsigned int*)(0x424E02ACUL))
#define bFM3_ADC0_SCIS1_AN12                   *((volatile unsigned int*)(0x424E02B0UL))
#define bFM3_ADC0_SCIS1_AN13                   *((volatile unsigned int*)(0x424E02B4UL))
#define bFM3_ADC0_SCIS1_AN14                   *((volatile unsigned int*)(0x424E02B8UL))
#define bFM3_ADC0_SCIS1_AN15                   *((volatile unsigned int*)(0x424E02BCUL))
#define bFM3_ADC0_PFNS_PFS0                    *((volatile unsigned int*)(0x424E0300UL))
#define bFM3_ADC0_PFNS_PFS1                    *((volatile unsigned int*)(0x424E0304UL))
#define bFM3_ADC0_PFNS_TEST0                   *((volatile unsigned int*)(0x424E0310UL))
#define bFM3_ADC0_PFNS_TEST1                   *((volatile unsigned int*)(0x424E0314UL))
#define bFM3_ADC0_PCCR_PSTR                    *((volatile unsigned int*)(0x424E0320UL))
#define bFM3_ADC0_PCCR_PHEN                    *((volatile unsigned int*)(0x424E0324UL))
#define bFM3_ADC0_PCCR_PEEN                    *((volatile unsigned int*)(0x424E0328UL))
#define bFM3_ADC0_PCCR_ESCE                    *((volatile unsigned int*)(0x424E032CUL))
#define bFM3_ADC0_PCCR_PFCLR                   *((volatile unsigned int*)(0x424E0330UL))
#define bFM3_ADC0_PCCR_POVR                    *((volatile unsigned int*)(0x424E0334UL))
#define bFM3_ADC0_PCCR_PFUL                    *((volatile unsigned int*)(0x424E0338UL))
#define bFM3_ADC0_PCCR_PEMP                    *((volatile unsigned int*)(0x424E033CUL))
#define bFM3_ADC0_PCFDL_PC0                    *((volatile unsigned short*)(0x424E0380UL))
#define bFM3_ADC0_PCFDL_PC1                    *((volatile unsigned short*)(0x424E0384UL))
#define bFM3_ADC0_PCFDL_PC2                    *((volatile unsigned short*)(0x424E0388UL))
#define bFM3_ADC0_PCFDL_PC3                    *((volatile unsigned short*)(0x424E038CUL))
#define bFM3_ADC0_PCFDL_PC4                    *((volatile unsigned short*)(0x424E0390UL))
#define bFM3_ADC0_PCFDL_RS0                    *((volatile unsigned short*)(0x424E03A0UL))
#define bFM3_ADC0_PCFDL_RS1                    *((volatile unsigned short*)(0x424E03A4UL))
#define bFM3_ADC0_PCFDL_RS2                    *((volatile unsigned short*)(0x424E03A8UL))
#define bFM3_ADC0_PCFDL_INVL                   *((volatile unsigned short*)(0x424E03B0UL))
#define bFM3_ADC0_PCFDH_PD0                    *((volatile unsigned short*)(0x424E03D0UL))
#define bFM3_ADC0_PCFDH_PD1                    *((volatile unsigned short*)(0x424E03D4UL))
#define bFM3_ADC0_PCFDH_PD2                    *((volatile unsigned short*)(0x424E03D8UL))
#define bFM3_ADC0_PCFDH_PD3                    *((volatile unsigned short*)(0x424E03DCUL))
#define bFM3_ADC0_PCFDH_PD4                    *((volatile unsigned short*)(0x424E03E0UL))
#define bFM3_ADC0_PCFDH_PD5                    *((volatile unsigned short*)(0x424E03E4UL))
#define bFM3_ADC0_PCFDH_PD6                    *((volatile unsigned short*)(0x424E03E8UL))
#define bFM3_ADC0_PCFDH_PD7                    *((volatile unsigned short*)(0x424E03ECUL))
#define bFM3_ADC0_PCFDH_PD8                    *((volatile unsigned short*)(0x424E03F0UL))
#define bFM3_ADC0_PCFDH_PD9                    *((volatile unsigned short*)(0x424E03F4UL))
#define bFM3_ADC0_PCFDH_PD10                   *((volatile unsigned short*)(0x424E03F8UL))
#define bFM3_ADC0_PCFDH_PD11                   *((volatile unsigned short*)(0x424E03FCUL))
#define bFM3_ADC0_PCIS_P1A0                    *((volatile unsigned int*)(0x424E0400UL))
#define bFM3_ADC0_PCIS_P1A1                    *((volatile unsigned int*)(0x424E0404UL))
#define bFM3_ADC0_PCIS_P1A2                    *((volatile unsigned int*)(0x424E0408UL))
#define bFM3_ADC0_PCIS_P2A0                    *((volatile unsigned int*)(0x424E040CUL))
#define bFM3_ADC0_PCIS_P2A1                    *((volatile unsigned int*)(0x424E0410UL))
#define bFM3_ADC0_PCIS_P2A2                    *((volatile unsigned int*)(0x424E0414UL))
#define bFM3_ADC0_PCIS_P2A3                    *((volatile unsigned int*)(0x424E0418UL))
#define bFM3_ADC0_PCIS_P2A4                    *((volatile unsigned int*)(0x424E041CUL))
#define bFM3_ADC0_CMPCR_CCH0                   *((volatile unsigned int*)(0x424E0480UL))
#define bFM3_ADC0_CMPCR_CCH1                   *((volatile unsigned int*)(0x424E0484UL))
#define bFM3_ADC0_CMPCR_CCH2                   *((volatile unsigned int*)(0x424E0488UL))
#define bFM3_ADC0_CMPCR_CCH3                   *((volatile unsigned int*)(0x424E048CUL))
#define bFM3_ADC0_CMPCR_CCH4                   *((volatile unsigned int*)(0x424E0490UL))
#define bFM3_ADC0_CMPCR_CMD0                   *((volatile unsigned int*)(0x424E0494UL))
#define bFM3_ADC0_CMPCR_CMD1                   *((volatile unsigned int*)(0x424E0498UL))
#define bFM3_ADC0_CMPCR_CMPEN                  *((volatile unsigned int*)(0x424E049CUL))
#define bFM3_ADC0_CMPD_CMAD2                   *((volatile unsigned int*)(0x424E04D8UL))
#define bFM3_ADC0_CMPD_CMAD3                   *((volatile unsigned int*)(0x424E04DCUL))
#define bFM3_ADC0_CMPD_CMAD4                   *((volatile unsigned int*)(0x424E04E0UL))
#define bFM3_ADC0_CMPD_CMAD5                   *((volatile unsigned int*)(0x424E04E4UL))
#define bFM3_ADC0_CMPD_CMAD6                   *((volatile unsigned int*)(0x424E04E8UL))
#define bFM3_ADC0_CMPD_CMAD7                   *((volatile unsigned int*)(0x424E04ECUL))
#define bFM3_ADC0_CMPD_CMAD8                   *((volatile unsigned int*)(0x424E04F0UL))
#define bFM3_ADC0_CMPD_CMAD9                   *((volatile unsigned int*)(0x424E04F4UL))
#define bFM3_ADC0_CMPD_CMAD10                  *((volatile unsigned int*)(0x424E04F8UL))
#define bFM3_ADC0_CMPD_CMAD11                  *((volatile unsigned int*)(0x424E04FCUL))
#define bFM3_ADC0_ADSS23_TS16                  *((volatile unsigned int*)(0x424E0500UL))
#define bFM3_ADC0_ADSS23_TS17                  *((volatile unsigned int*)(0x424E0504UL))
#define bFM3_ADC0_ADSS23_TS18                  *((volatile unsigned int*)(0x424E0508UL))
#define bFM3_ADC0_ADSS23_TS19                  *((volatile unsigned int*)(0x424E050CUL))
#define bFM3_ADC0_ADSS23_TS20                  *((volatile unsigned int*)(0x424E0510UL))
#define bFM3_ADC0_ADSS23_TS21                  *((volatile unsigned int*)(0x424E0514UL))
#define bFM3_ADC0_ADSS23_TS22                  *((volatile unsigned int*)(0x424E0518UL))
#define bFM3_ADC0_ADSS23_TS23                  *((volatile unsigned int*)(0x424E051CUL))
#define bFM3_ADC0_ADSS23_TS24                  *((volatile unsigned int*)(0x424E0520UL))
#define bFM3_ADC0_ADSS23_TS25                  *((volatile unsigned int*)(0x424E0524UL))
#define bFM3_ADC0_ADSS23_TS26                  *((volatile unsigned int*)(0x424E0528UL))
#define bFM3_ADC0_ADSS23_TS27                  *((volatile unsigned int*)(0x424E052CUL))
#define bFM3_ADC0_ADSS23_TS28                  *((volatile unsigned int*)(0x424E0530UL))
#define bFM3_ADC0_ADSS23_TS29                  *((volatile unsigned int*)(0x424E0534UL))
#define bFM3_ADC0_ADSS23_TS30                  *((volatile unsigned int*)(0x424E0538UL))
#define bFM3_ADC0_ADSS23_TS31                  *((volatile unsigned int*)(0x424E053CUL))
#define bFM3_ADC0_ADSS2_TS16                   *((volatile unsigned int*)(0x424E0500UL))
#define bFM3_ADC0_ADSS2_TS17                   *((volatile unsigned int*)(0x424E0504UL))
#define bFM3_ADC0_ADSS2_TS18                   *((volatile unsigned int*)(0x424E0508UL))
#define bFM3_ADC0_ADSS2_TS19                   *((volatile unsigned int*)(0x424E050CUL))
#define bFM3_ADC0_ADSS2_TS20                   *((volatile unsigned int*)(0x424E0510UL))
#define bFM3_ADC0_ADSS2_TS21                   *((volatile unsigned int*)(0x424E0514UL))
#define bFM3_ADC0_ADSS2_TS22                   *((volatile unsigned int*)(0x424E0518UL))
#define bFM3_ADC0_ADSS2_TS23                   *((volatile unsigned int*)(0x424E051CUL))
#define bFM3_ADC0_ADSS3_TS24                   *((volatile unsigned int*)(0x424E0520UL))
#define bFM3_ADC0_ADSS3_TS25                   *((volatile unsigned int*)(0x424E0524UL))
#define bFM3_ADC0_ADSS3_TS26                   *((volatile unsigned int*)(0x424E0528UL))
#define bFM3_ADC0_ADSS3_TS27                   *((volatile unsigned int*)(0x424E052CUL))
#define bFM3_ADC0_ADSS3_TS28                   *((volatile unsigned int*)(0x424E0530UL))
#define bFM3_ADC0_ADSS3_TS29                   *((volatile unsigned int*)(0x424E0534UL))
#define bFM3_ADC0_ADSS3_TS30                   *((volatile unsigned int*)(0x424E0538UL))
#define bFM3_ADC0_ADSS3_TS31                   *((volatile unsigned int*)(0x424E053CUL))
#define bFM3_ADC0_ADSS01_TS0                   *((volatile unsigned int*)(0x424E0580UL))
#define bFM3_ADC0_ADSS01_TS1                   *((volatile unsigned int*)(0x424E0584UL))
#define bFM3_ADC0_ADSS01_TS2                   *((volatile unsigned int*)(0x424E0588UL))
#define bFM3_ADC0_ADSS01_TS3                   *((volatile unsigned int*)(0x424E058CUL))
#define bFM3_ADC0_ADSS01_TS4                   *((volatile unsigned int*)(0x424E0590UL))
#define bFM3_ADC0_ADSS01_TS5                   *((volatile unsigned int*)(0x424E0594UL))
#define bFM3_ADC0_ADSS01_TS6                   *((volatile unsigned int*)(0x424E0598UL))
#define bFM3_ADC0_ADSS01_TS7                   *((volatile unsigned int*)(0x424E059CUL))
#define bFM3_ADC0_ADSS01_TS8                   *((volatile unsigned int*)(0x424E05A0UL))
#define bFM3_ADC0_ADSS01_TS9                   *((volatile unsigned int*)(0x424E05A4UL))
#define bFM3_ADC0_ADSS01_TS10                  *((volatile unsigned int*)(0x424E05A8UL))
#define bFM3_ADC0_ADSS01_TS11                  *((volatile unsigned int*)(0x424E05ACUL))
#define bFM3_ADC0_ADSS01_TS12                  *((volatile unsigned int*)(0x424E05B0UL))
#define bFM3_ADC0_ADSS01_TS13                  *((volatile unsigned int*)(0x424E05B4UL))
#define bFM3_ADC0_ADSS01_TS14                  *((volatile unsigned int*)(0x424E05B8UL))
#define bFM3_ADC0_ADSS01_TS15                  *((volatile unsigned int*)(0x424E05BCUL))
#define bFM3_ADC0_ADSS0_TS0                    *((volatile unsigned int*)(0x424E0580UL))
#define bFM3_ADC0_ADSS0_TS1                    *((volatile unsigned int*)(0x424E0584UL))
#define bFM3_ADC0_ADSS0_TS2                    *((volatile unsigned int*)(0x424E0588UL))
#define bFM3_ADC0_ADSS0_TS3                    *((volatile unsigned int*)(0x424E058CUL))
#define bFM3_ADC0_ADSS0_TS4                    *((volatile unsigned int*)(0x424E0590UL))
#define bFM3_ADC0_ADSS0_TS5                    *((volatile unsigned int*)(0x424E0594UL))
#define bFM3_ADC0_ADSS0_TS6                    *((volatile unsigned int*)(0x424E0598UL))
#define bFM3_ADC0_ADSS0_TS7                    *((volatile unsigned int*)(0x424E059CUL))
#define bFM3_ADC0_ADSS1_TS8                    *((volatile unsigned int*)(0x424E05A0UL))
#define bFM3_ADC0_ADSS1_TS9                    *((volatile unsigned int*)(0x424E05A4UL))
#define bFM3_ADC0_ADSS1_TS10                   *((volatile unsigned int*)(0x424E05A8UL))
#define bFM3_ADC0_ADSS1_TS11                   *((volatile unsigned int*)(0x424E05ACUL))
#define bFM3_ADC0_ADSS1_TS12                   *((volatile unsigned int*)(0x424E05B0UL))
#define bFM3_ADC0_ADSS1_TS13                   *((volatile unsigned int*)(0x424E05B4UL))
#define bFM3_ADC0_ADSS1_TS14                   *((volatile unsigned int*)(0x424E05B8UL))
#define bFM3_ADC0_ADSS1_TS15                   *((volatile unsigned int*)(0x424E05BCUL))
#define bFM3_ADC0_ADST01_ST10                  *((volatile unsigned int*)(0x424E0600UL))
#define bFM3_ADC0_ADST01_ST11                  *((volatile unsigned int*)(0x424E0604UL))
#define bFM3_ADC0_ADST01_ST12                  *((volatile unsigned int*)(0x424E0608UL))
#define bFM3_ADC0_ADST01_ST13                  *((volatile unsigned int*)(0x424E060CUL))
#define bFM3_ADC0_ADST01_ST14                  *((volatile unsigned int*)(0x424E0610UL))
#define bFM3_ADC0_ADST01_STX10                 *((volatile unsigned int*)(0x424E0614UL))
#define bFM3_ADC0_ADST01_STX11                 *((volatile unsigned int*)(0x424E0618UL))
#define bFM3_ADC0_ADST01_STX12                 *((volatile unsigned int*)(0x424E061CUL))
#define bFM3_ADC0_ADST01_ST00                  *((volatile unsigned int*)(0x424E0620UL))
#define bFM3_ADC0_ADST01_ST01                  *((volatile unsigned int*)(0x424E0624UL))
#define bFM3_ADC0_ADST01_ST02                  *((volatile unsigned int*)(0x424E0628UL))
#define bFM3_ADC0_ADST01_ST03                  *((volatile unsigned int*)(0x424E062CUL))
#define bFM3_ADC0_ADST01_ST04                  *((volatile unsigned int*)(0x424E0630UL))
#define bFM3_ADC0_ADST01_STX00                 *((volatile unsigned int*)(0x424E0634UL))
#define bFM3_ADC0_ADST01_STX01                 *((volatile unsigned int*)(0x424E0638UL))
#define bFM3_ADC0_ADST01_STX02                 *((volatile unsigned int*)(0x424E063CUL))
#define bFM3_ADC0_ADST1_ST10                   *((volatile unsigned int*)(0x424E0600UL))
#define bFM3_ADC0_ADST1_ST11                   *((volatile unsigned int*)(0x424E0604UL))
#define bFM3_ADC0_ADST1_ST12                   *((volatile unsigned int*)(0x424E0608UL))
#define bFM3_ADC0_ADST1_ST13                   *((volatile unsigned int*)(0x424E060CUL))
#define bFM3_ADC0_ADST1_ST14                   *((volatile unsigned int*)(0x424E0610UL))
#define bFM3_ADC0_ADST1_STX10                  *((volatile unsigned int*)(0x424E0614UL))
#define bFM3_ADC0_ADST1_STX11                  *((volatile unsigned int*)(0x424E0618UL))
#define bFM3_ADC0_ADST1_STX12                  *((volatile unsigned int*)(0x424E061CUL))
#define bFM3_ADC0_ADST0_ST00                   *((volatile unsigned int*)(0x424E0620UL))
#define bFM3_ADC0_ADST0_ST01                   *((volatile unsigned int*)(0x424E0624UL))
#define bFM3_ADC0_ADST0_ST02                   *((volatile unsigned int*)(0x424E0628UL))
#define bFM3_ADC0_ADST0_ST03                   *((volatile unsigned int*)(0x424E062CUL))
#define bFM3_ADC0_ADST0_ST04                   *((volatile unsigned int*)(0x424E0630UL))
#define bFM3_ADC0_ADST0_STX00                  *((volatile unsigned int*)(0x424E0634UL))
#define bFM3_ADC0_ADST0_STX01                  *((volatile unsigned int*)(0x424E0638UL))
#define bFM3_ADC0_ADST0_STX02                  *((volatile unsigned int*)(0x424E063CUL))
#define bFM3_ADC0_ADCT_CT0                     *((volatile unsigned int*)(0x424E0680UL))
#define bFM3_ADC0_ADCT_CT1                     *((volatile unsigned int*)(0x424E0684UL))
#define bFM3_ADC0_ADCT_CT2                     *((volatile unsigned int*)(0x424E0688UL))
#define bFM3_ADC0_ADCT_CT3                     *((volatile unsigned int*)(0x424E068CUL))
#define bFM3_ADC0_ADCT_CT4                     *((volatile unsigned int*)(0x424E0690UL))
#define bFM3_ADC0_ADCT_CT5                     *((volatile unsigned int*)(0x424E0694UL))
#define bFM3_ADC0_ADCT_CT6                     *((volatile unsigned int*)(0x424E0698UL))
#define bFM3_ADC0_ADCT_CT7                     *((volatile unsigned int*)(0x424E069CUL))
#define bFM3_ADC0_PRTSL_PRTSL0                 *((volatile unsigned int*)(0x424E0700UL))
#define bFM3_ADC0_PRTSL_PRTSL1                 *((volatile unsigned int*)(0x424E0704UL))
#define bFM3_ADC0_PRTSL_PRTSL2                 *((volatile unsigned int*)(0x424E0708UL))
#define bFM3_ADC0_PRTSL_PRTSL3                 *((volatile unsigned int*)(0x424E070CUL))
#define bFM3_ADC0_SCTSL_SCTSL0                 *((volatile unsigned int*)(0x424E0720UL))
#define bFM3_ADC0_SCTSL_SCTSL1                 *((volatile unsigned int*)(0x424E0724UL))
#define bFM3_ADC0_SCTSL_SCTSL2                 *((volatile unsigned int*)(0x424E0728UL))
#define bFM3_ADC0_SCTSL_SCTSL3                 *((volatile unsigned int*)(0x424E072CUL))
#define bFM3_ADC0_ADCEN_ENBL                   *((volatile unsigned int*)(0x424E0780UL))
#define bFM3_ADC0_ADCEN_READY                  *((volatile unsigned int*)(0x424E0784UL))
#define bFM3_ADC0_ADCEN_CYCLSL0                *((volatile unsigned int*)(0x424E0790UL))
#define bFM3_ADC0_ADCEN_CYCLSL1                *((volatile unsigned int*)(0x424E0794UL))

/* 12-bit ADC unit 1 registers */
#define bFM3_ADC1_ADSR_SCS                     *((volatile unsigned int*)(0x424E2000UL))
#define bFM3_ADC1_ADSR_PCS                     *((volatile unsigned int*)(0x424E2004UL))
#define bFM3_ADC1_ADSR_PCNS                    *((volatile unsigned int*)(0x424E2008UL))
#define bFM3_ADC1_ADSR_FDAS                    *((volatile unsigned int*)(0x424E2018UL))
#define bFM3_ADC1_ADSR_ADSTP                   *((volatile unsigned int*)(0x424E201CUL))
#define bFM3_ADC1_ADCR_OVRIE                   *((volatile unsigned int*)(0x424E2020UL))
#define bFM3_ADC1_ADCR_CMPIE                   *((volatile unsigned int*)(0x424E2024UL))
#define bFM3_ADC1_ADCR_PCIE                    *((volatile unsigned int*)(0x424E2028UL))
#define bFM3_ADC1_ADCR_SCIE                    *((volatile unsigned int*)(0x424E202CUL))
#define bFM3_ADC1_ADCR_CMPIF                   *((volatile unsigned int*)(0x424E2034UL))
#define bFM3_ADC1_ADCR_PCIF                    *((volatile unsigned int*)(0x424E2038UL))
#define bFM3_ADC1_ADCR_SCIF                    *((volatile unsigned int*)(0x424E203CUL))
#define bFM3_ADC1_SFNS_SFS0                    *((volatile unsigned int*)(0x424E2100UL))
#define bFM3_ADC1_SFNS_SFS1                    *((volatile unsigned int*)(0x424E2104UL))
#define bFM3_ADC1_SFNS_SFS2                    *((volatile unsigned int*)(0x424E2108UL))
#define bFM3_ADC1_SFNS_SFS3                    *((volatile unsigned int*)(0x424E210CUL))
#define bFM3_ADC1_SCCR_SSTR                    *((volatile unsigned int*)(0x424E2120UL))
#define bFM3_ADC1_SCCR_SHEN                    *((volatile unsigned int*)(0x424E2124UL))
#define bFM3_ADC1_SCCR_RPT                     *((volatile unsigned int*)(0x424E2128UL))
#define bFM3_ADC1_SCCR_SFCLR                   *((volatile unsigned int*)(0x424E2130UL))
#define bFM3_ADC1_SCCR_SOVR                    *((volatile unsigned int*)(0x424E2134UL))
#define bFM3_ADC1_SCCR_SFUL                    *((volatile unsigned int*)(0x424E2138UL))
#define bFM3_ADC1_SCCR_SEMP                    *((volatile unsigned int*)(0x424E213CUL))
#define bFM3_ADC1_SCFDL_SC0                    *((volatile unsigned short*)(0x424E2180UL))
#define bFM3_ADC1_SCFDL_SC1                    *((volatile unsigned short*)(0x424E2184UL))
#define bFM3_ADC1_SCFDL_SC2                    *((volatile unsigned short*)(0x424E2188UL))
#define bFM3_ADC1_SCFDL_SC3                    *((volatile unsigned short*)(0x424E218CUL))
#define bFM3_ADC1_SCFDL_SC4                    *((volatile unsigned short*)(0x424E2190UL))
#define bFM3_ADC1_SCFDL_RS0                    *((volatile unsigned short*)(0x424E21A0UL))
#define bFM3_ADC1_SCFDL_RS1                    *((volatile unsigned short*)(0x424E21A4UL))
#define bFM3_ADC1_SCFDL_INVL                   *((volatile unsigned short*)(0x424E21B0UL))
#define bFM3_ADC1_SCFDH_SD0                    *((volatile unsigned short*)(0x424E21D0UL))
#define bFM3_ADC1_SCFDH_SD1                    *((volatile unsigned short*)(0x424E21D4UL))
#define bFM3_ADC1_SCFDH_SD2                    *((volatile unsigned short*)(0x424E21D8UL))
#define bFM3_ADC1_SCFDH_SD3                    *((volatile unsigned short*)(0x424E21DCUL))
#define bFM3_ADC1_SCFDH_SD4                    *((volatile unsigned short*)(0x424E21E0UL))
#define bFM3_ADC1_SCFDH_SD5                    *((volatile unsigned short*)(0x424E21E4UL))
#define bFM3_ADC1_SCFDH_SD6                    *((volatile unsigned short*)(0x424E21E8UL))
#define bFM3_ADC1_SCFDH_SD7                    *((volatile unsigned short*)(0x424E21ECUL))
#define bFM3_ADC1_SCFDH_SD8                    *((volatile unsigned short*)(0x424E21F0UL))
#define bFM3_ADC1_SCFDH_SD9                    *((volatile unsigned short*)(0x424E21F4UL))
#define bFM3_ADC1_SCFDH_SD10                   *((volatile unsigned short*)(0x424E21F8UL))
#define bFM3_ADC1_SCFDH_SD11                   *((volatile unsigned short*)(0x424E21FCUL))
#define bFM3_ADC1_SCIS23_AN16                  *((volatile unsigned int*)(0x424E2200UL))
#define bFM3_ADC1_SCIS23_AN17                  *((volatile unsigned int*)(0x424E2204UL))
#define bFM3_ADC1_SCIS23_AN18                  *((volatile unsigned int*)(0x424E2208UL))
#define bFM3_ADC1_SCIS23_AN19                  *((volatile unsigned int*)(0x424E220CUL))
#define bFM3_ADC1_SCIS23_AN20                  *((volatile unsigned int*)(0x424E2210UL))
#define bFM3_ADC1_SCIS23_AN21                  *((volatile unsigned int*)(0x424E2214UL))
#define bFM3_ADC1_SCIS23_AN22                  *((volatile unsigned int*)(0x424E2218UL))
#define bFM3_ADC1_SCIS23_AN23                  *((volatile unsigned int*)(0x424E221CUL))
#define bFM3_ADC1_SCIS23_AN24                  *((volatile unsigned int*)(0x424E2220UL))
#define bFM3_ADC1_SCIS23_AN25                  *((volatile unsigned int*)(0x424E2224UL))
#define bFM3_ADC1_SCIS23_AN26                  *((volatile unsigned int*)(0x424E2228UL))
#define bFM3_ADC1_SCIS23_AN27                  *((volatile unsigned int*)(0x424E222CUL))
#define bFM3_ADC1_SCIS23_AN28                  *((volatile unsigned int*)(0x424E2230UL))
#define bFM3_ADC1_SCIS23_AN29                  *((volatile unsigned int*)(0x424E2234UL))
#define bFM3_ADC1_SCIS23_AN30                  *((volatile unsigned int*)(0x424E2238UL))
#define bFM3_ADC1_SCIS23_AN31                  *((volatile unsigned int*)(0x424E223CUL))
#define bFM3_ADC1_SCIS2_AN16                   *((volatile unsigned int*)(0x424E2200UL))
#define bFM3_ADC1_SCIS2_AN17                   *((volatile unsigned int*)(0x424E2204UL))
#define bFM3_ADC1_SCIS2_AN18                   *((volatile unsigned int*)(0x424E2208UL))
#define bFM3_ADC1_SCIS2_AN19                   *((volatile unsigned int*)(0x424E220CUL))
#define bFM3_ADC1_SCIS2_AN20                   *((volatile unsigned int*)(0x424E2210UL))
#define bFM3_ADC1_SCIS2_AN21                   *((volatile unsigned int*)(0x424E2214UL))
#define bFM3_ADC1_SCIS2_AN22                   *((volatile unsigned int*)(0x424E2218UL))
#define bFM3_ADC1_SCIS2_AN23                   *((volatile unsigned int*)(0x424E221CUL))
#define bFM3_ADC1_SCIS3_AN24                   *((volatile unsigned int*)(0x424E2220UL))
#define bFM3_ADC1_SCIS3_AN25                   *((volatile unsigned int*)(0x424E2224UL))
#define bFM3_ADC1_SCIS3_AN26                   *((volatile unsigned int*)(0x424E2228UL))
#define bFM3_ADC1_SCIS3_AN27                   *((volatile unsigned int*)(0x424E222CUL))
#define bFM3_ADC1_SCIS3_AN28                   *((volatile unsigned int*)(0x424E2230UL))
#define bFM3_ADC1_SCIS3_AN29                   *((volatile unsigned int*)(0x424E2234UL))
#define bFM3_ADC1_SCIS3_AN30                   *((volatile unsigned int*)(0x424E2238UL))
#define bFM3_ADC1_SCIS3_AN31                   *((volatile unsigned int*)(0x424E223CUL))
#define bFM3_ADC1_SCIS01_AN0                   *((volatile unsigned int*)(0x424E2280UL))
#define bFM3_ADC1_SCIS01_AN1                   *((volatile unsigned int*)(0x424E2284UL))
#define bFM3_ADC1_SCIS01_AN2                   *((volatile unsigned int*)(0x424E2288UL))
#define bFM3_ADC1_SCIS01_AN3                   *((volatile unsigned int*)(0x424E228CUL))
#define bFM3_ADC1_SCIS01_AN4                   *((volatile unsigned int*)(0x424E2290UL))
#define bFM3_ADC1_SCIS01_AN5                   *((volatile unsigned int*)(0x424E2294UL))
#define bFM3_ADC1_SCIS01_AN6                   *((volatile unsigned int*)(0x424E2298UL))
#define bFM3_ADC1_SCIS01_AN7                   *((volatile unsigned int*)(0x424E229CUL))
#define bFM3_ADC1_SCIS01_AN8                   *((volatile unsigned int*)(0x424E22A0UL))
#define bFM3_ADC1_SCIS01_AN9                   *((volatile unsigned int*)(0x424E22A4UL))
#define bFM3_ADC1_SCIS01_AN10                  *((volatile unsigned int*)(0x424E22A8UL))
#define bFM3_ADC1_SCIS01_AN11                  *((volatile unsigned int*)(0x424E22ACUL))
#define bFM3_ADC1_SCIS01_AN12                  *((volatile unsigned int*)(0x424E22B0UL))
#define bFM3_ADC1_SCIS01_AN13                  *((volatile unsigned int*)(0x424E22B4UL))
#define bFM3_ADC1_SCIS01_AN14                  *((volatile unsigned int*)(0x424E22B8UL))
#define bFM3_ADC1_SCIS01_AN15                  *((volatile unsigned int*)(0x424E22BCUL))
#define bFM3_ADC1_SCIS0_AN0                    *((volatile unsigned int*)(0x424E2280UL))
#define bFM3_ADC1_SCIS0_AN1                    *((volatile unsigned int*)(0x424E2284UL))
#define bFM3_ADC1_SCIS0_AN2                    *((volatile unsigned int*)(0x424E2288UL))
#define bFM3_ADC1_SCIS0_AN3                    *((volatile unsigned int*)(0x424E228CUL))
#define bFM3_ADC1_SCIS0_AN4                    *((volatile unsigned int*)(0x424E2290UL))
#define bFM3_ADC1_SCIS0_AN5                    *((volatile unsigned int*)(0x424E2294UL))
#define bFM3_ADC1_SCIS0_AN6                    *((volatile unsigned int*)(0x424E2298UL))
#define bFM3_ADC1_SCIS0_AN7                    *((volatile unsigned int*)(0x424E229CUL))
#define bFM3_ADC1_SCIS1_AN8                    *((volatile unsigned int*)(0x424E22A0UL))
#define bFM3_ADC1_SCIS1_AN9                    *((volatile unsigned int*)(0x424E22A4UL))
#define bFM3_ADC1_SCIS1_AN10                   *((volatile unsigned int*)(0x424E22A8UL))
#define bFM3_ADC1_SCIS1_AN11                   *((volatile unsigned int*)(0x424E22ACUL))
#define bFM3_ADC1_SCIS1_AN12                   *((volatile unsigned int*)(0x424E22B0UL))
#define bFM3_ADC1_SCIS1_AN13                   *((volatile unsigned int*)(0x424E22B4UL))
#define bFM3_ADC1_SCIS1_AN14                   *((volatile unsigned int*)(0x424E22B8UL))
#define bFM3_ADC1_SCIS1_AN15                   *((volatile unsigned int*)(0x424E22BCUL))
#define bFM3_ADC1_PFNS_PFS0                    *((volatile unsigned int*)(0x424E2300UL))
#define bFM3_ADC1_PFNS_PFS1                    *((volatile unsigned int*)(0x424E2304UL))
#define bFM3_ADC1_PFNS_TEST0                   *((volatile unsigned int*)(0x424E2310UL))
#define bFM3_ADC1_PFNS_TEST1                   *((volatile unsigned int*)(0x424E2314UL))
#define bFM3_ADC1_PCCR_PSTR                    *((volatile unsigned int*)(0x424E2320UL))
#define bFM3_ADC1_PCCR_PHEN                    *((volatile unsigned int*)(0x424E2324UL))
#define bFM3_ADC1_PCCR_PEEN                    *((volatile unsigned int*)(0x424E2328UL))
#define bFM3_ADC1_PCCR_ESCE                    *((volatile unsigned int*)(0x424E232CUL))
#define bFM3_ADC1_PCCR_PFCLR                   *((volatile unsigned int*)(0x424E2330UL))
#define bFM3_ADC1_PCCR_POVR                    *((volatile unsigned int*)(0x424E2334UL))
#define bFM3_ADC1_PCCR_PFUL                    *((volatile unsigned int*)(0x424E2338UL))
#define bFM3_ADC1_PCCR_PEMP                    *((volatile unsigned int*)(0x424E233CUL))
#define bFM3_ADC1_PCFDL_PC0                    *((volatile unsigned short*)(0x424E2380UL))
#define bFM3_ADC1_PCFDL_PC1                    *((volatile unsigned short*)(0x424E2384UL))
#define bFM3_ADC1_PCFDL_PC2                    *((volatile unsigned short*)(0x424E2388UL))
#define bFM3_ADC1_PCFDL_PC3                    *((volatile unsigned short*)(0x424E238CUL))
#define bFM3_ADC1_PCFDL_PC4                    *((volatile unsigned short*)(0x424E2390UL))
#define bFM3_ADC1_PCFDL_RS0                    *((volatile unsigned short*)(0x424E23A0UL))
#define bFM3_ADC1_PCFDL_RS1                    *((volatile unsigned short*)(0x424E23A4UL))
#define bFM3_ADC1_PCFDL_RS2                    *((volatile unsigned short*)(0x424E23A8UL))
#define bFM3_ADC1_PCFDL_INVL                   *((volatile unsigned short*)(0x424E23B0UL))
#define bFM3_ADC1_PCFDH_PD0                    *((volatile unsigned short*)(0x424E23D0UL))
#define bFM3_ADC1_PCFDH_PD1                    *((volatile unsigned short*)(0x424E23D4UL))
#define bFM3_ADC1_PCFDH_PD2                    *((volatile unsigned short*)(0x424E23D8UL))
#define bFM3_ADC1_PCFDH_PD3                    *((volatile unsigned short*)(0x424E23DCUL))
#define bFM3_ADC1_PCFDH_PD4                    *((volatile unsigned short*)(0x424E23E0UL))
#define bFM3_ADC1_PCFDH_PD5                    *((volatile unsigned short*)(0x424E23E4UL))
#define bFM3_ADC1_PCFDH_PD6                    *((volatile unsigned short*)(0x424E23E8UL))
#define bFM3_ADC1_PCFDH_PD7                    *((volatile unsigned short*)(0x424E23ECUL))
#define bFM3_ADC1_PCFDH_PD8                    *((volatile unsigned short*)(0x424E23F0UL))
#define bFM3_ADC1_PCFDH_PD9                    *((volatile unsigned short*)(0x424E23F4UL))
#define bFM3_ADC1_PCFDH_PD10                   *((volatile unsigned short*)(0x424E23F8UL))
#define bFM3_ADC1_PCFDH_PD11                   *((volatile unsigned short*)(0x424E23FCUL))
#define bFM3_ADC1_PCIS_P1A0                    *((volatile unsigned int*)(0x424E2400UL))
#define bFM3_ADC1_PCIS_P1A1                    *((volatile unsigned int*)(0x424E2404UL))
#define bFM3_ADC1_PCIS_P1A2                    *((volatile unsigned int*)(0x424E2408UL))
#define bFM3_ADC1_PCIS_P2A0                    *((volatile unsigned int*)(0x424E240CUL))
#define bFM3_ADC1_PCIS_P2A1                    *((volatile unsigned int*)(0x424E2410UL))
#define bFM3_ADC1_PCIS_P2A2                    *((volatile unsigned int*)(0x424E2414UL))
#define bFM3_ADC1_PCIS_P2A3                    *((volatile unsigned int*)(0x424E2418UL))
#define bFM3_ADC1_PCIS_P2A4                    *((volatile unsigned int*)(0x424E241CUL))
#define bFM3_ADC1_CMPCR_CCH0                   *((volatile unsigned int*)(0x424E2480UL))
#define bFM3_ADC1_CMPCR_CCH1                   *((volatile unsigned int*)(0x424E2484UL))
#define bFM3_ADC1_CMPCR_CCH2                   *((volatile unsigned int*)(0x424E2488UL))
#define bFM3_ADC1_CMPCR_CCH3                   *((volatile unsigned int*)(0x424E248CUL))
#define bFM3_ADC1_CMPCR_CCH4                   *((volatile unsigned int*)(0x424E2490UL))
#define bFM3_ADC1_CMPCR_CMD0                   *((volatile unsigned int*)(0x424E2494UL))
#define bFM3_ADC1_CMPCR_CMD1                   *((volatile unsigned int*)(0x424E2498UL))
#define bFM3_ADC1_CMPCR_CMPEN                  *((volatile unsigned int*)(0x424E249CUL))
#define bFM3_ADC1_CMPD_CMAD2                   *((volatile unsigned int*)(0x424E24D8UL))
#define bFM3_ADC1_CMPD_CMAD3                   *((volatile unsigned int*)(0x424E24DCUL))
#define bFM3_ADC1_CMPD_CMAD4                   *((volatile unsigned int*)(0x424E24E0UL))
#define bFM3_ADC1_CMPD_CMAD5                   *((volatile unsigned int*)(0x424E24E4UL))
#define bFM3_ADC1_CMPD_CMAD6                   *((volatile unsigned int*)(0x424E24E8UL))
#define bFM3_ADC1_CMPD_CMAD7                   *((volatile unsigned int*)(0x424E24ECUL))
#define bFM3_ADC1_CMPD_CMAD8                   *((volatile unsigned int*)(0x424E24F0UL))
#define bFM3_ADC1_CMPD_CMAD9                   *((volatile unsigned int*)(0x424E24F4UL))
#define bFM3_ADC1_CMPD_CMAD10                  *((volatile unsigned int*)(0x424E24F8UL))
#define bFM3_ADC1_CMPD_CMAD11                  *((volatile unsigned int*)(0x424E24FCUL))
#define bFM3_ADC1_ADSS23_TS16                  *((volatile unsigned int*)(0x424E2500UL))
#define bFM3_ADC1_ADSS23_TS17                  *((volatile unsigned int*)(0x424E2504UL))
#define bFM3_ADC1_ADSS23_TS18                  *((volatile unsigned int*)(0x424E2508UL))
#define bFM3_ADC1_ADSS23_TS19                  *((volatile unsigned int*)(0x424E250CUL))
#define bFM3_ADC1_ADSS23_TS20                  *((volatile unsigned int*)(0x424E2510UL))
#define bFM3_ADC1_ADSS23_TS21                  *((volatile unsigned int*)(0x424E2514UL))
#define bFM3_ADC1_ADSS23_TS22                  *((volatile unsigned int*)(0x424E2518UL))
#define bFM3_ADC1_ADSS23_TS23                  *((volatile unsigned int*)(0x424E251CUL))
#define bFM3_ADC1_ADSS23_TS24                  *((volatile unsigned int*)(0x424E2520UL))
#define bFM3_ADC1_ADSS23_TS25                  *((volatile unsigned int*)(0x424E2524UL))
#define bFM3_ADC1_ADSS23_TS26                  *((volatile unsigned int*)(0x424E2528UL))
#define bFM3_ADC1_ADSS23_TS27                  *((volatile unsigned int*)(0x424E252CUL))
#define bFM3_ADC1_ADSS23_TS28                  *((volatile unsigned int*)(0x424E2530UL))
#define bFM3_ADC1_ADSS23_TS29                  *((volatile unsigned int*)(0x424E2534UL))
#define bFM3_ADC1_ADSS23_TS30                  *((volatile unsigned int*)(0x424E2538UL))
#define bFM3_ADC1_ADSS23_TS31                  *((volatile unsigned int*)(0x424E253CUL))
#define bFM3_ADC1_ADSS2_TS16                   *((volatile unsigned int*)(0x424E2500UL))
#define bFM3_ADC1_ADSS2_TS17                   *((volatile unsigned int*)(0x424E2504UL))
#define bFM3_ADC1_ADSS2_TS18                   *((volatile unsigned int*)(0x424E2508UL))
#define bFM3_ADC1_ADSS2_TS19                   *((volatile unsigned int*)(0x424E250CUL))
#define bFM3_ADC1_ADSS2_TS20                   *((volatile unsigned int*)(0x424E2510UL))
#define bFM3_ADC1_ADSS2_TS21                   *((volatile unsigned int*)(0x424E2514UL))
#define bFM3_ADC1_ADSS2_TS22                   *((volatile unsigned int*)(0x424E2518UL))
#define bFM3_ADC1_ADSS2_TS23                   *((volatile unsigned int*)(0x424E251CUL))
#define bFM3_ADC1_ADSS3_TS24                   *((volatile unsigned int*)(0x424E2520UL))
#define bFM3_ADC1_ADSS3_TS25                   *((volatile unsigned int*)(0x424E2524UL))
#define bFM3_ADC1_ADSS3_TS26                   *((volatile unsigned int*)(0x424E2528UL))
#define bFM3_ADC1_ADSS3_TS27                   *((volatile unsigned int*)(0x424E252CUL))
#define bFM3_ADC1_ADSS3_TS28                   *((volatile unsigned int*)(0x424E2530UL))
#define bFM3_ADC1_ADSS3_TS29                   *((volatile unsigned int*)(0x424E2534UL))
#define bFM3_ADC1_ADSS3_TS30                   *((volatile unsigned int*)(0x424E2538UL))
#define bFM3_ADC1_ADSS3_TS31                   *((volatile unsigned int*)(0x424E253CUL))
#define bFM3_ADC1_ADSS01_TS0                   *((volatile unsigned int*)(0x424E2580UL))
#define bFM3_ADC1_ADSS01_TS1                   *((volatile unsigned int*)(0x424E2584UL))
#define bFM3_ADC1_ADSS01_TS2                   *((volatile unsigned int*)(0x424E2588UL))
#define bFM3_ADC1_ADSS01_TS3                   *((volatile unsigned int*)(0x424E258CUL))
#define bFM3_ADC1_ADSS01_TS4                   *((volatile unsigned int*)(0x424E2590UL))
#define bFM3_ADC1_ADSS01_TS5                   *((volatile unsigned int*)(0x424E2594UL))
#define bFM3_ADC1_ADSS01_TS6                   *((volatile unsigned int*)(0x424E2598UL))
#define bFM3_ADC1_ADSS01_TS7                   *((volatile unsigned int*)(0x424E259CUL))
#define bFM3_ADC1_ADSS01_TS8                   *((volatile unsigned int*)(0x424E25A0UL))
#define bFM3_ADC1_ADSS01_TS9                   *((volatile unsigned int*)(0x424E25A4UL))
#define bFM3_ADC1_ADSS01_TS10                  *((volatile unsigned int*)(0x424E25A8UL))
#define bFM3_ADC1_ADSS01_TS11                  *((volatile unsigned int*)(0x424E25ACUL))
#define bFM3_ADC1_ADSS01_TS12                  *((volatile unsigned int*)(0x424E25B0UL))
#define bFM3_ADC1_ADSS01_TS13                  *((volatile unsigned int*)(0x424E25B4UL))
#define bFM3_ADC1_ADSS01_TS14                  *((volatile unsigned int*)(0x424E25B8UL))
#define bFM3_ADC1_ADSS01_TS15                  *((volatile unsigned int*)(0x424E25BCUL))
#define bFM3_ADC1_ADSS0_TS0                    *((volatile unsigned int*)(0x424E2580UL))
#define bFM3_ADC1_ADSS0_TS1                    *((volatile unsigned int*)(0x424E2584UL))
#define bFM3_ADC1_ADSS0_TS2                    *((volatile unsigned int*)(0x424E2588UL))
#define bFM3_ADC1_ADSS0_TS3                    *((volatile unsigned int*)(0x424E258CUL))
#define bFM3_ADC1_ADSS0_TS4                    *((volatile unsigned int*)(0x424E2590UL))
#define bFM3_ADC1_ADSS0_TS5                    *((volatile unsigned int*)(0x424E2594UL))
#define bFM3_ADC1_ADSS0_TS6                    *((volatile unsigned int*)(0x424E2598UL))
#define bFM3_ADC1_ADSS0_TS7                    *((volatile unsigned int*)(0x424E259CUL))
#define bFM3_ADC1_ADSS1_TS8                    *((volatile unsigned int*)(0x424E25A0UL))
#define bFM3_ADC1_ADSS1_TS9                    *((volatile unsigned int*)(0x424E25A4UL))
#define bFM3_ADC1_ADSS1_TS10                   *((volatile unsigned int*)(0x424E25A8UL))
#define bFM3_ADC1_ADSS1_TS11                   *((volatile unsigned int*)(0x424E25ACUL))
#define bFM3_ADC1_ADSS1_TS12                   *((volatile unsigned int*)(0x424E25B0UL))
#define bFM3_ADC1_ADSS1_TS13                   *((volatile unsigned int*)(0x424E25B4UL))
#define bFM3_ADC1_ADSS1_TS14                   *((volatile unsigned int*)(0x424E25B8UL))
#define bFM3_ADC1_ADSS1_TS15                   *((volatile unsigned int*)(0x424E25BCUL))
#define bFM3_ADC1_ADST01_ST10                  *((volatile unsigned int*)(0x424E2600UL))
#define bFM3_ADC1_ADST01_ST11                  *((volatile unsigned int*)(0x424E2604UL))
#define bFM3_ADC1_ADST01_ST12                  *((volatile unsigned int*)(0x424E2608UL))
#define bFM3_ADC1_ADST01_ST13                  *((volatile unsigned int*)(0x424E260CUL))
#define bFM3_ADC1_ADST01_ST14                  *((volatile unsigned int*)(0x424E2610UL))
#define bFM3_ADC1_ADST01_STX10                 *((volatile unsigned int*)(0x424E2614UL))
#define bFM3_ADC1_ADST01_STX11                 *((volatile unsigned int*)(0x424E2618UL))
#define bFM3_ADC1_ADST01_STX12                 *((volatile unsigned int*)(0x424E261CUL))
#define bFM3_ADC1_ADST01_ST00                  *((volatile unsigned int*)(0x424E2620UL))
#define bFM3_ADC1_ADST01_ST01                  *((volatile unsigned int*)(0x424E2624UL))
#define bFM3_ADC1_ADST01_ST02                  *((volatile unsigned int*)(0x424E2628UL))
#define bFM3_ADC1_ADST01_ST03                  *((volatile unsigned int*)(0x424E262CUL))
#define bFM3_ADC1_ADST01_ST04                  *((volatile unsigned int*)(0x424E2630UL))
#define bFM3_ADC1_ADST01_STX00                 *((volatile unsigned int*)(0x424E2634UL))
#define bFM3_ADC1_ADST01_STX01                 *((volatile unsigned int*)(0x424E2638UL))
#define bFM3_ADC1_ADST01_STX02                 *((volatile unsigned int*)(0x424E263CUL))
#define bFM3_ADC1_ADST1_ST10                   *((volatile unsigned int*)(0x424E2600UL))
#define bFM3_ADC1_ADST1_ST11                   *((volatile unsigned int*)(0x424E2604UL))
#define bFM3_ADC1_ADST1_ST12                   *((volatile unsigned int*)(0x424E2608UL))
#define bFM3_ADC1_ADST1_ST13                   *((volatile unsigned int*)(0x424E260CUL))
#define bFM3_ADC1_ADST1_ST14                   *((volatile unsigned int*)(0x424E2610UL))
#define bFM3_ADC1_ADST1_STX10                  *((volatile unsigned int*)(0x424E2614UL))
#define bFM3_ADC1_ADST1_STX11                  *((volatile unsigned int*)(0x424E2618UL))
#define bFM3_ADC1_ADST1_STX12                  *((volatile unsigned int*)(0x424E261CUL))
#define bFM3_ADC1_ADST0_ST00                   *((volatile unsigned int*)(0x424E2620UL))
#define bFM3_ADC1_ADST0_ST01                   *((volatile unsigned int*)(0x424E2624UL))
#define bFM3_ADC1_ADST0_ST02                   *((volatile unsigned int*)(0x424E2628UL))
#define bFM3_ADC1_ADST0_ST03                   *((volatile unsigned int*)(0x424E262CUL))
#define bFM3_ADC1_ADST0_ST04                   *((volatile unsigned int*)(0x424E2630UL))
#define bFM3_ADC1_ADST0_STX00                  *((volatile unsigned int*)(0x424E2634UL))
#define bFM3_ADC1_ADST0_STX01                  *((volatile unsigned int*)(0x424E2638UL))
#define bFM3_ADC1_ADST0_STX02                  *((volatile unsigned int*)(0x424E263CUL))
#define bFM3_ADC1_ADCT_CT0                     *((volatile unsigned int*)(0x424E2680UL))
#define bFM3_ADC1_ADCT_CT1                     *((volatile unsigned int*)(0x424E2684UL))
#define bFM3_ADC1_ADCT_CT2                     *((volatile unsigned int*)(0x424E2688UL))
#define bFM3_ADC1_ADCT_CT3                     *((volatile unsigned int*)(0x424E268CUL))
#define bFM3_ADC1_ADCT_CT4                     *((volatile unsigned int*)(0x424E2690UL))
#define bFM3_ADC1_ADCT_CT5                     *((volatile unsigned int*)(0x424E2694UL))
#define bFM3_ADC1_ADCT_CT6                     *((volatile unsigned int*)(0x424E2698UL))
#define bFM3_ADC1_ADCT_CT7                     *((volatile unsigned int*)(0x424E269CUL))
#define bFM3_ADC1_PRTSL_PRTSL0                 *((volatile unsigned int*)(0x424E2700UL))
#define bFM3_ADC1_PRTSL_PRTSL1                 *((volatile unsigned int*)(0x424E2704UL))
#define bFM3_ADC1_PRTSL_PRTSL2                 *((volatile unsigned int*)(0x424E2708UL))
#define bFM3_ADC1_PRTSL_PRTSL3                 *((volatile unsigned int*)(0x424E270CUL))
#define bFM3_ADC1_SCTSL_SCTSL0                 *((volatile unsigned int*)(0x424E2720UL))
#define bFM3_ADC1_SCTSL_SCTSL1                 *((volatile unsigned int*)(0x424E2724UL))
#define bFM3_ADC1_SCTSL_SCTSL2                 *((volatile unsigned int*)(0x424E2728UL))
#define bFM3_ADC1_SCTSL_SCTSL3                 *((volatile unsigned int*)(0x424E272CUL))
#define bFM3_ADC1_ADCEN_ENBL                   *((volatile unsigned int*)(0x424E2780UL))
#define bFM3_ADC1_ADCEN_READY                  *((volatile unsigned int*)(0x424E2784UL))
#define bFM3_ADC1_ADCEN_CYCLSL0                *((volatile unsigned int*)(0x424E2790UL))
#define bFM3_ADC1_ADCEN_CYCLSL1                *((volatile unsigned int*)(0x424E2794UL))

/* 12-bit ADC unit 2 registers */
#define bFM3_ADC2_ADSR_SCS                     *((volatile unsigned int*)(0x424E4000UL))
#define bFM3_ADC2_ADSR_PCS                     *((volatile unsigned int*)(0x424E4004UL))
#define bFM3_ADC2_ADSR_PCNS                    *((volatile unsigned int*)(0x424E4008UL))
#define bFM3_ADC2_ADSR_FDAS                    *((volatile unsigned int*)(0x424E4018UL))
#define bFM3_ADC2_ADSR_ADSTP                   *((volatile unsigned int*)(0x424E401CUL))
#define bFM3_ADC2_ADCR_OVRIE                   *((volatile unsigned int*)(0x424E4020UL))
#define bFM3_ADC2_ADCR_CMPIE                   *((volatile unsigned int*)(0x424E4024UL))
#define bFM3_ADC2_ADCR_PCIE                    *((volatile unsigned int*)(0x424E4028UL))
#define bFM3_ADC2_ADCR_SCIE                    *((volatile unsigned int*)(0x424E402CUL))
#define bFM3_ADC2_ADCR_CMPIF                   *((volatile unsigned int*)(0x424E4034UL))
#define bFM3_ADC2_ADCR_PCIF                    *((volatile unsigned int*)(0x424E4038UL))
#define bFM3_ADC2_ADCR_SCIF                    *((volatile unsigned int*)(0x424E403CUL))
#define bFM3_ADC2_SFNS_SFS0                    *((volatile unsigned int*)(0x424E4100UL))
#define bFM3_ADC2_SFNS_SFS1                    *((volatile unsigned int*)(0x424E4104UL))
#define bFM3_ADC2_SFNS_SFS2                    *((volatile unsigned int*)(0x424E4108UL))
#define bFM3_ADC2_SFNS_SFS3                    *((volatile unsigned int*)(0x424E410CUL))
#define bFM3_ADC2_SCCR_SSTR                    *((volatile unsigned int*)(0x424E4120UL))
#define bFM3_ADC2_SCCR_SHEN                    *((volatile unsigned int*)(0x424E4124UL))
#define bFM3_ADC2_SCCR_RPT                     *((volatile unsigned int*)(0x424E4128UL))
#define bFM3_ADC2_SCCR_SFCLR                   *((volatile unsigned int*)(0x424E4130UL))
#define bFM3_ADC2_SCCR_SOVR                    *((volatile unsigned int*)(0x424E4134UL))
#define bFM3_ADC2_SCCR_SFUL                    *((volatile unsigned int*)(0x424E4138UL))
#define bFM3_ADC2_SCCR_SEMP                    *((volatile unsigned int*)(0x424E413CUL))
#define bFM3_ADC2_SCFDL_SC0                    *((volatile unsigned short*)(0x424E4180UL))
#define bFM3_ADC2_SCFDL_SC1                    *((volatile unsigned short*)(0x424E4184UL))
#define bFM3_ADC2_SCFDL_SC2                    *((volatile unsigned short*)(0x424E4188UL))
#define bFM3_ADC2_SCFDL_SC3                    *((volatile unsigned short*)(0x424E418CUL))
#define bFM3_ADC2_SCFDL_SC4                    *((volatile unsigned short*)(0x424E4190UL))
#define bFM3_ADC2_SCFDL_RS0                    *((volatile unsigned short*)(0x424E41A0UL))
#define bFM3_ADC2_SCFDL_RS1                    *((volatile unsigned short*)(0x424E41A4UL))
#define bFM3_ADC2_SCFDL_INVL                   *((volatile unsigned short*)(0x424E41B0UL))
#define bFM3_ADC2_SCFDH_SD0                    *((volatile unsigned short*)(0x424E41D0UL))
#define bFM3_ADC2_SCFDH_SD1                    *((volatile unsigned short*)(0x424E41D4UL))
#define bFM3_ADC2_SCFDH_SD2                    *((volatile unsigned short*)(0x424E41D8UL))
#define bFM3_ADC2_SCFDH_SD3                    *((volatile unsigned short*)(0x424E41DCUL))
#define bFM3_ADC2_SCFDH_SD4                    *((volatile unsigned short*)(0x424E41E0UL))
#define bFM3_ADC2_SCFDH_SD5                    *((volatile unsigned short*)(0x424E41E4UL))
#define bFM3_ADC2_SCFDH_SD6                    *((volatile unsigned short*)(0x424E41E8UL))
#define bFM3_ADC2_SCFDH_SD7                    *((volatile unsigned short*)(0x424E41ECUL))
#define bFM3_ADC2_SCFDH_SD8                    *((volatile unsigned short*)(0x424E41F0UL))
#define bFM3_ADC2_SCFDH_SD9                    *((volatile unsigned short*)(0x424E41F4UL))
#define bFM3_ADC2_SCFDH_SD10                   *((volatile unsigned short*)(0x424E41F8UL))
#define bFM3_ADC2_SCFDH_SD11                   *((volatile unsigned short*)(0x424E41FCUL))
#define bFM3_ADC2_SCIS23_AN16                  *((volatile unsigned int*)(0x424E4200UL))
#define bFM3_ADC2_SCIS23_AN17                  *((volatile unsigned int*)(0x424E4204UL))
#define bFM3_ADC2_SCIS23_AN18                  *((volatile unsigned int*)(0x424E4208UL))
#define bFM3_ADC2_SCIS23_AN19                  *((volatile unsigned int*)(0x424E420CUL))
#define bFM3_ADC2_SCIS23_AN20                  *((volatile unsigned int*)(0x424E4210UL))
#define bFM3_ADC2_SCIS23_AN21                  *((volatile unsigned int*)(0x424E4214UL))
#define bFM3_ADC2_SCIS23_AN22                  *((volatile unsigned int*)(0x424E4218UL))
#define bFM3_ADC2_SCIS23_AN23                  *((volatile unsigned int*)(0x424E421CUL))
#define bFM3_ADC2_SCIS23_AN24                  *((volatile unsigned int*)(0x424E4220UL))
#define bFM3_ADC2_SCIS23_AN25                  *((volatile unsigned int*)(0x424E4224UL))
#define bFM3_ADC2_SCIS23_AN26                  *((volatile unsigned int*)(0x424E4228UL))
#define bFM3_ADC2_SCIS23_AN27                  *((volatile unsigned int*)(0x424E422CUL))
#define bFM3_ADC2_SCIS23_AN28                  *((volatile unsigned int*)(0x424E4230UL))
#define bFM3_ADC2_SCIS23_AN29                  *((volatile unsigned int*)(0x424E4234UL))
#define bFM3_ADC2_SCIS23_AN30                  *((volatile unsigned int*)(0x424E4238UL))
#define bFM3_ADC2_SCIS23_AN31                  *((volatile unsigned int*)(0x424E423CUL))
#define bFM3_ADC2_SCIS2_AN16                   *((volatile unsigned int*)(0x424E4200UL))
#define bFM3_ADC2_SCIS2_AN17                   *((volatile unsigned int*)(0x424E4204UL))
#define bFM3_ADC2_SCIS2_AN18                   *((volatile unsigned int*)(0x424E4208UL))
#define bFM3_ADC2_SCIS2_AN19                   *((volatile unsigned int*)(0x424E420CUL))
#define bFM3_ADC2_SCIS2_AN20                   *((volatile unsigned int*)(0x424E4210UL))
#define bFM3_ADC2_SCIS2_AN21                   *((volatile unsigned int*)(0x424E4214UL))
#define bFM3_ADC2_SCIS2_AN22                   *((volatile unsigned int*)(0x424E4218UL))
#define bFM3_ADC2_SCIS2_AN23                   *((volatile unsigned int*)(0x424E421CUL))
#define bFM3_ADC2_SCIS3_AN24                   *((volatile unsigned int*)(0x424E4220UL))
#define bFM3_ADC2_SCIS3_AN25                   *((volatile unsigned int*)(0x424E4224UL))
#define bFM3_ADC2_SCIS3_AN26                   *((volatile unsigned int*)(0x424E4228UL))
#define bFM3_ADC2_SCIS3_AN27                   *((volatile unsigned int*)(0x424E422CUL))
#define bFM3_ADC2_SCIS3_AN28                   *((volatile unsigned int*)(0x424E4230UL))
#define bFM3_ADC2_SCIS3_AN29                   *((volatile unsigned int*)(0x424E4234UL))
#define bFM3_ADC2_SCIS3_AN30                   *((volatile unsigned int*)(0x424E4238UL))
#define bFM3_ADC2_SCIS3_AN31                   *((volatile unsigned int*)(0x424E423CUL))
#define bFM3_ADC2_SCIS01_AN0                   *((volatile unsigned int*)(0x424E4280UL))
#define bFM3_ADC2_SCIS01_AN1                   *((volatile unsigned int*)(0x424E4284UL))
#define bFM3_ADC2_SCIS01_AN2                   *((volatile unsigned int*)(0x424E4288UL))
#define bFM3_ADC2_SCIS01_AN3                   *((volatile unsigned int*)(0x424E428CUL))
#define bFM3_ADC2_SCIS01_AN4                   *((volatile unsigned int*)(0x424E4290UL))
#define bFM3_ADC2_SCIS01_AN5                   *((volatile unsigned int*)(0x424E4294UL))
#define bFM3_ADC2_SCIS01_AN6                   *((volatile unsigned int*)(0x424E4298UL))
#define bFM3_ADC2_SCIS01_AN7                   *((volatile unsigned int*)(0x424E429CUL))
#define bFM3_ADC2_SCIS01_AN8                   *((volatile unsigned int*)(0x424E42A0UL))
#define bFM3_ADC2_SCIS01_AN9                   *((volatile unsigned int*)(0x424E42A4UL))
#define bFM3_ADC2_SCIS01_AN10                  *((volatile unsigned int*)(0x424E42A8UL))
#define bFM3_ADC2_SCIS01_AN11                  *((volatile unsigned int*)(0x424E42ACUL))
#define bFM3_ADC2_SCIS01_AN12                  *((volatile unsigned int*)(0x424E42B0UL))
#define bFM3_ADC2_SCIS01_AN13                  *((volatile unsigned int*)(0x424E42B4UL))
#define bFM3_ADC2_SCIS01_AN14                  *((volatile unsigned int*)(0x424E42B8UL))
#define bFM3_ADC2_SCIS01_AN15                  *((volatile unsigned int*)(0x424E42BCUL))
#define bFM3_ADC2_SCIS0_AN0                    *((volatile unsigned int*)(0x424E4280UL))
#define bFM3_ADC2_SCIS0_AN1                    *((volatile unsigned int*)(0x424E4284UL))
#define bFM3_ADC2_SCIS0_AN2                    *((volatile unsigned int*)(0x424E4288UL))
#define bFM3_ADC2_SCIS0_AN3                    *((volatile unsigned int*)(0x424E428CUL))
#define bFM3_ADC2_SCIS0_AN4                    *((volatile unsigned int*)(0x424E4290UL))
#define bFM3_ADC2_SCIS0_AN5                    *((volatile unsigned int*)(0x424E4294UL))
#define bFM3_ADC2_SCIS0_AN6                    *((volatile unsigned int*)(0x424E4298UL))
#define bFM3_ADC2_SCIS0_AN7                    *((volatile unsigned int*)(0x424E429CUL))
#define bFM3_ADC2_SCIS1_AN8                    *((volatile unsigned int*)(0x424E42A0UL))
#define bFM3_ADC2_SCIS1_AN9                    *((volatile unsigned int*)(0x424E42A4UL))
#define bFM3_ADC2_SCIS1_AN10                   *((volatile unsigned int*)(0x424E42A8UL))
#define bFM3_ADC2_SCIS1_AN11                   *((volatile unsigned int*)(0x424E42ACUL))
#define bFM3_ADC2_SCIS1_AN12                   *((volatile unsigned int*)(0x424E42B0UL))
#define bFM3_ADC2_SCIS1_AN13                   *((volatile unsigned int*)(0x424E42B4UL))
#define bFM3_ADC2_SCIS1_AN14                   *((volatile unsigned int*)(0x424E42B8UL))
#define bFM3_ADC2_SCIS1_AN15                   *((volatile unsigned int*)(0x424E42BCUL))
#define bFM3_ADC2_PFNS_PFS0                    *((volatile unsigned int*)(0x424E4300UL))
#define bFM3_ADC2_PFNS_PFS1                    *((volatile unsigned int*)(0x424E4304UL))
#define bFM3_ADC2_PFNS_TEST0                   *((volatile unsigned int*)(0x424E4310UL))
#define bFM3_ADC2_PFNS_TEST1                   *((volatile unsigned int*)(0x424E4314UL))
#define bFM3_ADC2_PCCR_PSTR                    *((volatile unsigned int*)(0x424E4320UL))
#define bFM3_ADC2_PCCR_PHEN                    *((volatile unsigned int*)(0x424E4324UL))
#define bFM3_ADC2_PCCR_PEEN                    *((volatile unsigned int*)(0x424E4328UL))
#define bFM3_ADC2_PCCR_ESCE                    *((volatile unsigned int*)(0x424E432CUL))
#define bFM3_ADC2_PCCR_PFCLR                   *((volatile unsigned int*)(0x424E4330UL))
#define bFM3_ADC2_PCCR_POVR                    *((volatile unsigned int*)(0x424E4334UL))
#define bFM3_ADC2_PCCR_PFUL                    *((volatile unsigned int*)(0x424E4338UL))
#define bFM3_ADC2_PCCR_PEMP                    *((volatile unsigned int*)(0x424E433CUL))
#define bFM3_ADC2_PCFDL_PC0                    *((volatile unsigned short*)(0x424E4380UL))
#define bFM3_ADC2_PCFDL_PC1                    *((volatile unsigned short*)(0x424E4384UL))
#define bFM3_ADC2_PCFDL_PC2                    *((volatile unsigned short*)(0x424E4388UL))
#define bFM3_ADC2_PCFDL_PC3                    *((volatile unsigned short*)(0x424E438CUL))
#define bFM3_ADC2_PCFDL_PC4                    *((volatile unsigned short*)(0x424E4390UL))
#define bFM3_ADC2_PCFDL_RS0                    *((volatile unsigned short*)(0x424E43A0UL))
#define bFM3_ADC2_PCFDL_RS1                    *((volatile unsigned short*)(0x424E43A4UL))
#define bFM3_ADC2_PCFDL_RS2                    *((volatile unsigned short*)(0x424E43A8UL))
#define bFM3_ADC2_PCFDL_INVL                   *((volatile unsigned short*)(0x424E43B0UL))
#define bFM3_ADC2_PCFDH_PD0                    *((volatile unsigned short*)(0x424E43D0UL))
#define bFM3_ADC2_PCFDH_PD1                    *((volatile unsigned short*)(0x424E43D4UL))
#define bFM3_ADC2_PCFDH_PD2                    *((volatile unsigned short*)(0x424E43D8UL))
#define bFM3_ADC2_PCFDH_PD3                    *((volatile unsigned short*)(0x424E43DCUL))
#define bFM3_ADC2_PCFDH_PD4                    *((volatile unsigned short*)(0x424E43E0UL))
#define bFM3_ADC2_PCFDH_PD5                    *((volatile unsigned short*)(0x424E43E4UL))
#define bFM3_ADC2_PCFDH_PD6                    *((volatile unsigned short*)(0x424E43E8UL))
#define bFM3_ADC2_PCFDH_PD7                    *((volatile unsigned short*)(0x424E43ECUL))
#define bFM3_ADC2_PCFDH_PD8                    *((volatile unsigned short*)(0x424E43F0UL))
#define bFM3_ADC2_PCFDH_PD9                    *((volatile unsigned short*)(0x424E43F4UL))
#define bFM3_ADC2_PCFDH_PD10                   *((volatile unsigned short*)(0x424E43F8UL))
#define bFM3_ADC2_PCFDH_PD11                   *((volatile unsigned short*)(0x424E43FCUL))
#define bFM3_ADC2_PCIS_P1A0                    *((volatile unsigned int*)(0x424E4400UL))
#define bFM3_ADC2_PCIS_P1A1                    *((volatile unsigned int*)(0x424E4404UL))
#define bFM3_ADC2_PCIS_P1A2                    *((volatile unsigned int*)(0x424E4408UL))
#define bFM3_ADC2_PCIS_P2A0                    *((volatile unsigned int*)(0x424E440CUL))
#define bFM3_ADC2_PCIS_P2A1                    *((volatile unsigned int*)(0x424E4410UL))
#define bFM3_ADC2_PCIS_P2A2                    *((volatile unsigned int*)(0x424E4414UL))
#define bFM3_ADC2_PCIS_P2A3                    *((volatile unsigned int*)(0x424E4418UL))
#define bFM3_ADC2_PCIS_P2A4                    *((volatile unsigned int*)(0x424E441CUL))
#define bFM3_ADC2_CMPCR_CCH0                   *((volatile unsigned int*)(0x424E4480UL))
#define bFM3_ADC2_CMPCR_CCH1                   *((volatile unsigned int*)(0x424E4484UL))
#define bFM3_ADC2_CMPCR_CCH2                   *((volatile unsigned int*)(0x424E4488UL))
#define bFM3_ADC2_CMPCR_CCH3                   *((volatile unsigned int*)(0x424E448CUL))
#define bFM3_ADC2_CMPCR_CCH4                   *((volatile unsigned int*)(0x424E4490UL))
#define bFM3_ADC2_CMPCR_CMD0                   *((volatile unsigned int*)(0x424E4494UL))
#define bFM3_ADC2_CMPCR_CMD1                   *((volatile unsigned int*)(0x424E4498UL))
#define bFM3_ADC2_CMPCR_CMPEN                  *((volatile unsigned int*)(0x424E449CUL))
#define bFM3_ADC2_CMPD_CMAD2                   *((volatile unsigned int*)(0x424E44D8UL))
#define bFM3_ADC2_CMPD_CMAD3                   *((volatile unsigned int*)(0x424E44DCUL))
#define bFM3_ADC2_CMPD_CMAD4                   *((volatile unsigned int*)(0x424E44E0UL))
#define bFM3_ADC2_CMPD_CMAD5                   *((volatile unsigned int*)(0x424E44E4UL))
#define bFM3_ADC2_CMPD_CMAD6                   *((volatile unsigned int*)(0x424E44E8UL))
#define bFM3_ADC2_CMPD_CMAD7                   *((volatile unsigned int*)(0x424E44ECUL))
#define bFM3_ADC2_CMPD_CMAD8                   *((volatile unsigned int*)(0x424E44F0UL))
#define bFM3_ADC2_CMPD_CMAD9                   *((volatile unsigned int*)(0x424E44F4UL))
#define bFM3_ADC2_CMPD_CMAD10                  *((volatile unsigned int*)(0x424E44F8UL))
#define bFM3_ADC2_CMPD_CMAD11                  *((volatile unsigned int*)(0x424E44FCUL))
#define bFM3_ADC2_ADSS23_TS16                  *((volatile unsigned int*)(0x424E4500UL))
#define bFM3_ADC2_ADSS23_TS17                  *((volatile unsigned int*)(0x424E4504UL))
#define bFM3_ADC2_ADSS23_TS18                  *((volatile unsigned int*)(0x424E4508UL))
#define bFM3_ADC2_ADSS23_TS19                  *((volatile unsigned int*)(0x424E450CUL))
#define bFM3_ADC2_ADSS23_TS20                  *((volatile unsigned int*)(0x424E4510UL))
#define bFM3_ADC2_ADSS23_TS21                  *((volatile unsigned int*)(0x424E4514UL))
#define bFM3_ADC2_ADSS23_TS22                  *((volatile unsigned int*)(0x424E4518UL))
#define bFM3_ADC2_ADSS23_TS23                  *((volatile unsigned int*)(0x424E451CUL))
#define bFM3_ADC2_ADSS23_TS24                  *((volatile unsigned int*)(0x424E4520UL))
#define bFM3_ADC2_ADSS23_TS25                  *((volatile unsigned int*)(0x424E4524UL))
#define bFM3_ADC2_ADSS23_TS26                  *((volatile unsigned int*)(0x424E4528UL))
#define bFM3_ADC2_ADSS23_TS27                  *((volatile unsigned int*)(0x424E452CUL))
#define bFM3_ADC2_ADSS23_TS28                  *((volatile unsigned int*)(0x424E4530UL))
#define bFM3_ADC2_ADSS23_TS29                  *((volatile unsigned int*)(0x424E4534UL))
#define bFM3_ADC2_ADSS23_TS30                  *((volatile unsigned int*)(0x424E4538UL))
#define bFM3_ADC2_ADSS23_TS31                  *((volatile unsigned int*)(0x424E453CUL))
#define bFM3_ADC2_ADSS2_TS16                   *((volatile unsigned int*)(0x424E4500UL))
#define bFM3_ADC2_ADSS2_TS17                   *((volatile unsigned int*)(0x424E4504UL))
#define bFM3_ADC2_ADSS2_TS18                   *((volatile unsigned int*)(0x424E4508UL))
#define bFM3_ADC2_ADSS2_TS19                   *((volatile unsigned int*)(0x424E450CUL))
#define bFM3_ADC2_ADSS2_TS20                   *((volatile unsigned int*)(0x424E4510UL))
#define bFM3_ADC2_ADSS2_TS21                   *((volatile unsigned int*)(0x424E4514UL))
#define bFM3_ADC2_ADSS2_TS22                   *((volatile unsigned int*)(0x424E4518UL))
#define bFM3_ADC2_ADSS2_TS23                   *((volatile unsigned int*)(0x424E451CUL))
#define bFM3_ADC2_ADSS3_TS24                   *((volatile unsigned int*)(0x424E4520UL))
#define bFM3_ADC2_ADSS3_TS25                   *((volatile unsigned int*)(0x424E4524UL))
#define bFM3_ADC2_ADSS3_TS26                   *((volatile unsigned int*)(0x424E4528UL))
#define bFM3_ADC2_ADSS3_TS27                   *((volatile unsigned int*)(0x424E452CUL))
#define bFM3_ADC2_ADSS3_TS28                   *((volatile unsigned int*)(0x424E4530UL))
#define bFM3_ADC2_ADSS3_TS29                   *((volatile unsigned int*)(0x424E4534UL))
#define bFM3_ADC2_ADSS3_TS30                   *((volatile unsigned int*)(0x424E4538UL))
#define bFM3_ADC2_ADSS3_TS31                   *((volatile unsigned int*)(0x424E453CUL))
#define bFM3_ADC2_ADSS01_TS0                   *((volatile unsigned int*)(0x424E4580UL))
#define bFM3_ADC2_ADSS01_TS1                   *((volatile unsigned int*)(0x424E4584UL))
#define bFM3_ADC2_ADSS01_TS2                   *((volatile unsigned int*)(0x424E4588UL))
#define bFM3_ADC2_ADSS01_TS3                   *((volatile unsigned int*)(0x424E458CUL))
#define bFM3_ADC2_ADSS01_TS4                   *((volatile unsigned int*)(0x424E4590UL))
#define bFM3_ADC2_ADSS01_TS5                   *((volatile unsigned int*)(0x424E4594UL))
#define bFM3_ADC2_ADSS01_TS6                   *((volatile unsigned int*)(0x424E4598UL))
#define bFM3_ADC2_ADSS01_TS7                   *((volatile unsigned int*)(0x424E459CUL))
#define bFM3_ADC2_ADSS01_TS8                   *((volatile unsigned int*)(0x424E45A0UL))
#define bFM3_ADC2_ADSS01_TS9                   *((volatile unsigned int*)(0x424E45A4UL))
#define bFM3_ADC2_ADSS01_TS10                  *((volatile unsigned int*)(0x424E45A8UL))
#define bFM3_ADC2_ADSS01_TS11                  *((volatile unsigned int*)(0x424E45ACUL))
#define bFM3_ADC2_ADSS01_TS12                  *((volatile unsigned int*)(0x424E45B0UL))
#define bFM3_ADC2_ADSS01_TS13                  *((volatile unsigned int*)(0x424E45B4UL))
#define bFM3_ADC2_ADSS01_TS14                  *((volatile unsigned int*)(0x424E45B8UL))
#define bFM3_ADC2_ADSS01_TS15                  *((volatile unsigned int*)(0x424E45BCUL))
#define bFM3_ADC2_ADSS0_TS0                    *((volatile unsigned int*)(0x424E4580UL))
#define bFM3_ADC2_ADSS0_TS1                    *((volatile unsigned int*)(0x424E4584UL))
#define bFM3_ADC2_ADSS0_TS2                    *((volatile unsigned int*)(0x424E4588UL))
#define bFM3_ADC2_ADSS0_TS3                    *((volatile unsigned int*)(0x424E458CUL))
#define bFM3_ADC2_ADSS0_TS4                    *((volatile unsigned int*)(0x424E4590UL))
#define bFM3_ADC2_ADSS0_TS5                    *((volatile unsigned int*)(0x424E4594UL))
#define bFM3_ADC2_ADSS0_TS6                    *((volatile unsigned int*)(0x424E4598UL))
#define bFM3_ADC2_ADSS0_TS7                    *((volatile unsigned int*)(0x424E459CUL))
#define bFM3_ADC2_ADSS1_TS8                    *((volatile unsigned int*)(0x424E45A0UL))
#define bFM3_ADC2_ADSS1_TS9                    *((volatile unsigned int*)(0x424E45A4UL))
#define bFM3_ADC2_ADSS1_TS10                   *((volatile unsigned int*)(0x424E45A8UL))
#define bFM3_ADC2_ADSS1_TS11                   *((volatile unsigned int*)(0x424E45ACUL))
#define bFM3_ADC2_ADSS1_TS12                   *((volatile unsigned int*)(0x424E45B0UL))
#define bFM3_ADC2_ADSS1_TS13                   *((volatile unsigned int*)(0x424E45B4UL))
#define bFM3_ADC2_ADSS1_TS14                   *((volatile unsigned int*)(0x424E45B8UL))
#define bFM3_ADC2_ADSS1_TS15                   *((volatile unsigned int*)(0x424E45BCUL))
#define bFM3_ADC2_ADST01_ST10                  *((volatile unsigned int*)(0x424E4600UL))
#define bFM3_ADC2_ADST01_ST11                  *((volatile unsigned int*)(0x424E4604UL))
#define bFM3_ADC2_ADST01_ST12                  *((volatile unsigned int*)(0x424E4608UL))
#define bFM3_ADC2_ADST01_ST13                  *((volatile unsigned int*)(0x424E460CUL))
#define bFM3_ADC2_ADST01_ST14                  *((volatile unsigned int*)(0x424E4610UL))
#define bFM3_ADC2_ADST01_STX10                 *((volatile unsigned int*)(0x424E4614UL))
#define bFM3_ADC2_ADST01_STX11                 *((volatile unsigned int*)(0x424E4618UL))
#define bFM3_ADC2_ADST01_STX12                 *((volatile unsigned int*)(0x424E461CUL))
#define bFM3_ADC2_ADST01_ST00                  *((volatile unsigned int*)(0x424E4620UL))
#define bFM3_ADC2_ADST01_ST01                  *((volatile unsigned int*)(0x424E4624UL))
#define bFM3_ADC2_ADST01_ST02                  *((volatile unsigned int*)(0x424E4628UL))
#define bFM3_ADC2_ADST01_ST03                  *((volatile unsigned int*)(0x424E462CUL))
#define bFM3_ADC2_ADST01_ST04                  *((volatile unsigned int*)(0x424E4630UL))
#define bFM3_ADC2_ADST01_STX00                 *((volatile unsigned int*)(0x424E4634UL))
#define bFM3_ADC2_ADST01_STX01                 *((volatile unsigned int*)(0x424E4638UL))
#define bFM3_ADC2_ADST01_STX02                 *((volatile unsigned int*)(0x424E463CUL))
#define bFM3_ADC2_ADST1_ST10                   *((volatile unsigned int*)(0x424E4600UL))
#define bFM3_ADC2_ADST1_ST11                   *((volatile unsigned int*)(0x424E4604UL))
#define bFM3_ADC2_ADST1_ST12                   *((volatile unsigned int*)(0x424E4608UL))
#define bFM3_ADC2_ADST1_ST13                   *((volatile unsigned int*)(0x424E460CUL))
#define bFM3_ADC2_ADST1_ST14                   *((volatile unsigned int*)(0x424E4610UL))
#define bFM3_ADC2_ADST1_STX10                  *((volatile unsigned int*)(0x424E4614UL))
#define bFM3_ADC2_ADST1_STX11                  *((volatile unsigned int*)(0x424E4618UL))
#define bFM3_ADC2_ADST1_STX12                  *((volatile unsigned int*)(0x424E461CUL))
#define bFM3_ADC2_ADST0_ST00                   *((volatile unsigned int*)(0x424E4620UL))
#define bFM3_ADC2_ADST0_ST01                   *((volatile unsigned int*)(0x424E4624UL))
#define bFM3_ADC2_ADST0_ST02                   *((volatile unsigned int*)(0x424E4628UL))
#define bFM3_ADC2_ADST0_ST03                   *((volatile unsigned int*)(0x424E462CUL))
#define bFM3_ADC2_ADST0_ST04                   *((volatile unsigned int*)(0x424E4630UL))
#define bFM3_ADC2_ADST0_STX00                  *((volatile unsigned int*)(0x424E4634UL))
#define bFM3_ADC2_ADST0_STX01                  *((volatile unsigned int*)(0x424E4638UL))
#define bFM3_ADC2_ADST0_STX02                  *((volatile unsigned int*)(0x424E463CUL))
#define bFM3_ADC2_ADCT_CT0                     *((volatile unsigned int*)(0x424E4680UL))
#define bFM3_ADC2_ADCT_CT1                     *((volatile unsigned int*)(0x424E4684UL))
#define bFM3_ADC2_ADCT_CT2                     *((volatile unsigned int*)(0x424E4688UL))
#define bFM3_ADC2_ADCT_CT3                     *((volatile unsigned int*)(0x424E468CUL))
#define bFM3_ADC2_ADCT_CT4                     *((volatile unsigned int*)(0x424E4690UL))
#define bFM3_ADC2_ADCT_CT5                     *((volatile unsigned int*)(0x424E4694UL))
#define bFM3_ADC2_ADCT_CT6                     *((volatile unsigned int*)(0x424E4698UL))
#define bFM3_ADC2_ADCT_CT7                     *((volatile unsigned int*)(0x424E469CUL))
#define bFM3_ADC2_PRTSL_PRTSL0                 *((volatile unsigned int*)(0x424E4700UL))
#define bFM3_ADC2_PRTSL_PRTSL1                 *((volatile unsigned int*)(0x424E4704UL))
#define bFM3_ADC2_PRTSL_PRTSL2                 *((volatile unsigned int*)(0x424E4708UL))
#define bFM3_ADC2_PRTSL_PRTSL3                 *((volatile unsigned int*)(0x424E470CUL))
#define bFM3_ADC2_SCTSL_SCTSL0                 *((volatile unsigned int*)(0x424E4720UL))
#define bFM3_ADC2_SCTSL_SCTSL1                 *((volatile unsigned int*)(0x424E4724UL))
#define bFM3_ADC2_SCTSL_SCTSL2                 *((volatile unsigned int*)(0x424E4728UL))
#define bFM3_ADC2_SCTSL_SCTSL3                 *((volatile unsigned int*)(0x424E472CUL))
#define bFM3_ADC2_ADCEN_ENBL                   *((volatile unsigned int*)(0x424E4780UL))
#define bFM3_ADC2_ADCEN_READY                  *((volatile unsigned int*)(0x424E4784UL))
#define bFM3_ADC2_ADCEN_CYCLSL0                *((volatile unsigned int*)(0x424E4790UL))
#define bFM3_ADC2_ADCEN_CYCLSL1                *((volatile unsigned int*)(0x424E4794UL))

/* CR trimming registers */
#define bFM3_CRTRIM_MCR_PSR_CSR0               *((volatile unsigned int*)(0x425C0000UL))
#define bFM3_CRTRIM_MCR_PSR_CSR1               *((volatile unsigned int*)(0x425C0004UL))
#define bFM3_CRTRIM_MCR_FTRM_TRD0              *((volatile unsigned int*)(0x425C0080UL))
#define bFM3_CRTRIM_MCR_FTRM_TRD1              *((volatile unsigned int*)(0x425C0084UL))
#define bFM3_CRTRIM_MCR_FTRM_TRD2              *((volatile unsigned int*)(0x425C0088UL))
#define bFM3_CRTRIM_MCR_FTRM_TRD3              *((volatile unsigned int*)(0x425C008CUL))
#define bFM3_CRTRIM_MCR_FTRM_TRD4              *((volatile unsigned int*)(0x425C0090UL))
#define bFM3_CRTRIM_MCR_FTRM_TRD5              *((volatile unsigned int*)(0x425C0094UL))
#define bFM3_CRTRIM_MCR_FTRM_TRD6              *((volatile unsigned int*)(0x425C0098UL))
#define bFM3_CRTRIM_MCR_FTRM_TRD7              *((volatile unsigned int*)(0x425C009CUL))

/* External interrupt registers */
#define bFM3_EXTI_ENIR_EN0                     *((volatile unsigned int*)(0x42600000UL))
#define bFM3_EXTI_ENIR_EN1                     *((volatile unsigned int*)(0x42600004UL))
#define bFM3_EXTI_ENIR_EN2                     *((volatile unsigned int*)(0x42600008UL))
#define bFM3_EXTI_ENIR_EN3                     *((volatile unsigned int*)(0x4260000CUL))
#define bFM3_EXTI_ENIR_EN4                     *((volatile unsigned int*)(0x42600010UL))
#define bFM3_EXTI_ENIR_EN5                     *((volatile unsigned int*)(0x42600014UL))
#define bFM3_EXTI_ENIR_EN6                     *((volatile unsigned int*)(0x42600018UL))
#define bFM3_EXTI_ENIR_EN7                     *((volatile unsigned int*)(0x4260001CUL))
#define bFM3_EXTI_ENIR_EN8                     *((volatile unsigned int*)(0x42600020UL))
#define bFM3_EXTI_ENIR_EN9                     *((volatile unsigned int*)(0x42600024UL))
#define bFM3_EXTI_ENIR_EN10                    *((volatile unsigned int*)(0x42600028UL))
#define bFM3_EXTI_ENIR_EN11                    *((volatile unsigned int*)(0x4260002CUL))
#define bFM3_EXTI_ENIR_EN12                    *((volatile unsigned int*)(0x42600030UL))
#define bFM3_EXTI_ENIR_EN13                    *((volatile unsigned int*)(0x42600034UL))
#define bFM3_EXTI_ENIR_EN14                    *((volatile unsigned int*)(0x42600038UL))
#define bFM3_EXTI_ENIR_EN15                    *((volatile unsigned int*)(0x4260003CUL))
#define bFM3_EXTI_ENIR_EN16                    *((volatile unsigned int*)(0x42600040UL))
#define bFM3_EXTI_ENIR_EN17                    *((volatile unsigned int*)(0x42600044UL))
#define bFM3_EXTI_ENIR_EN18                    *((volatile unsigned int*)(0x42600048UL))
#define bFM3_EXTI_ENIR_EN19                    *((volatile unsigned int*)(0x4260004CUL))
#define bFM3_EXTI_ENIR_EN20                    *((volatile unsigned int*)(0x42600050UL))
#define bFM3_EXTI_ENIR_EN21                    *((volatile unsigned int*)(0x42600054UL))
#define bFM3_EXTI_ENIR_EN22                    *((volatile unsigned int*)(0x42600058UL))
#define bFM3_EXTI_ENIR_EN23                    *((volatile unsigned int*)(0x4260005CUL))
#define bFM3_EXTI_ENIR_EN24                    *((volatile unsigned int*)(0x42600060UL))
#define bFM3_EXTI_ENIR_EN25                    *((volatile unsigned int*)(0x42600064UL))
#define bFM3_EXTI_ENIR_EN26                    *((volatile unsigned int*)(0x42600068UL))
#define bFM3_EXTI_ENIR_EN27                    *((volatile unsigned int*)(0x4260006CUL))
#define bFM3_EXTI_ENIR_EN28                    *((volatile unsigned int*)(0x42600070UL))
#define bFM3_EXTI_ENIR_EN29                    *((volatile unsigned int*)(0x42600074UL))
#define bFM3_EXTI_ENIR_EN30                    *((volatile unsigned int*)(0x42600078UL))
#define bFM3_EXTI_ENIR_EN31                    *((volatile unsigned int*)(0x4260007CUL))
#define bFM3_EXTI_EIRR_ER0                     *((volatile unsigned int*)(0x42600080UL))
#define bFM3_EXTI_EIRR_ER1                     *((volatile unsigned int*)(0x42600084UL))
#define bFM3_EXTI_EIRR_ER2                     *((volatile unsigned int*)(0x42600088UL))
#define bFM3_EXTI_EIRR_ER3                     *((volatile unsigned int*)(0x4260008CUL))
#define bFM3_EXTI_EIRR_ER4                     *((volatile unsigned int*)(0x42600090UL))
#define bFM3_EXTI_EIRR_ER5                     *((volatile unsigned int*)(0x42600094UL))
#define bFM3_EXTI_EIRR_ER6                     *((volatile unsigned int*)(0x42600098UL))
#define bFM3_EXTI_EIRR_ER7                     *((volatile unsigned int*)(0x4260009CUL))
#define bFM3_EXTI_EIRR_ER8                     *((volatile unsigned int*)(0x426000A0UL))
#define bFM3_EXTI_EIRR_ER9                     *((volatile unsigned int*)(0x426000A4UL))
#define bFM3_EXTI_EIRR_ER10                    *((volatile unsigned int*)(0x426000A8UL))
#define bFM3_EXTI_EIRR_ER11                    *((volatile unsigned int*)(0x426000ACUL))
#define bFM3_EXTI_EIRR_ER12                    *((volatile unsigned int*)(0x426000B0UL))
#define bFM3_EXTI_EIRR_ER13                    *((volatile unsigned int*)(0x426000B4UL))
#define bFM3_EXTI_EIRR_ER14                    *((volatile unsigned int*)(0x426000B8UL))
#define bFM3_EXTI_EIRR_ER15                    *((volatile unsigned int*)(0x426000BCUL))
#define bFM3_EXTI_EIRR_ER16                    *((volatile unsigned int*)(0x426000C0UL))
#define bFM3_EXTI_EIRR_ER17                    *((volatile unsigned int*)(0x426000C4UL))
#define bFM3_EXTI_EIRR_ER18                    *((volatile unsigned int*)(0x426000C8UL))
#define bFM3_EXTI_EIRR_ER19                    *((volatile unsigned int*)(0x426000CCUL))
#define bFM3_EXTI_EIRR_ER20                    *((volatile unsigned int*)(0x426000D0UL))
#define bFM3_EXTI_EIRR_ER21                    *((volatile unsigned int*)(0x426000D4UL))
#define bFM3_EXTI_EIRR_ER22                    *((volatile unsigned int*)(0x426000D8UL))
#define bFM3_EXTI_EIRR_ER23                    *((volatile unsigned int*)(0x426000DCUL))
#define bFM3_EXTI_EIRR_ER24                    *((volatile unsigned int*)(0x426000E0UL))
#define bFM3_EXTI_EIRR_ER25                    *((volatile unsigned int*)(0x426000E4UL))
#define bFM3_EXTI_EIRR_ER26                    *((volatile unsigned int*)(0x426000E8UL))
#define bFM3_EXTI_EIRR_ER27                    *((volatile unsigned int*)(0x426000ECUL))
#define bFM3_EXTI_EIRR_ER28                    *((volatile unsigned int*)(0x426000F0UL))
#define bFM3_EXTI_EIRR_ER29                    *((volatile unsigned int*)(0x426000F4UL))
#define bFM3_EXTI_EIRR_ER30                    *((volatile unsigned int*)(0x426000F8UL))
#define bFM3_EXTI_EIRR_ER31                    *((volatile unsigned int*)(0x426000FCUL))
#define bFM3_EXTI_EICL_ECL0                    *((volatile unsigned int*)(0x42600100UL))
#define bFM3_EXTI_EICL_ECL1                    *((volatile unsigned int*)(0x42600104UL))
#define bFM3_EXTI_EICL_ECL2                    *((volatile unsigned int*)(0x42600108UL))
#define bFM3_EXTI_EICL_ECL3                    *((volatile unsigned int*)(0x4260010CUL))
#define bFM3_EXTI_EICL_ECL4                    *((volatile unsigned int*)(0x42600110UL))
#define bFM3_EXTI_EICL_ECL5                    *((volatile unsigned int*)(0x42600114UL))
#define bFM3_EXTI_EICL_ECL6                    *((volatile unsigned int*)(0x42600118UL))
#define bFM3_EXTI_EICL_ECL7                    *((volatile unsigned int*)(0x4260011CUL))
#define bFM3_EXTI_EICL_ECL8                    *((volatile unsigned int*)(0x42600120UL))
#define bFM3_EXTI_EICL_ECL9                    *((volatile unsigned int*)(0x42600124UL))
#define bFM3_EXTI_EICL_ECL10                   *((volatile unsigned int*)(0x42600128UL))
#define bFM3_EXTI_EICL_ECL11                   *((volatile unsigned int*)(0x4260012CUL))
#define bFM3_EXTI_EICL_ECL12                   *((volatile unsigned int*)(0x42600130UL))
#define bFM3_EXTI_EICL_ECL13                   *((volatile unsigned int*)(0x42600134UL))
#define bFM3_EXTI_EICL_ECL14                   *((volatile unsigned int*)(0x42600138UL))
#define bFM3_EXTI_EICL_ECL15                   *((volatile unsigned int*)(0x4260013CUL))
#define bFM3_EXTI_EICL_ECL16                   *((volatile unsigned int*)(0x42600140UL))
#define bFM3_EXTI_EICL_ECL17                   *((volatile unsigned int*)(0x42600144UL))
#define bFM3_EXTI_EICL_ECL18                   *((volatile unsigned int*)(0x42600148UL))
#define bFM3_EXTI_EICL_ECL19                   *((volatile unsigned int*)(0x4260014CUL))
#define bFM3_EXTI_EICL_ECL20                   *((volatile unsigned int*)(0x42600150UL))
#define bFM3_EXTI_EICL_ECL21                   *((volatile unsigned int*)(0x42600154UL))
#define bFM3_EXTI_EICL_ECL22                   *((volatile unsigned int*)(0x42600158UL))
#define bFM3_EXTI_EICL_ECL23                   *((volatile unsigned int*)(0x4260015CUL))
#define bFM3_EXTI_EICL_ECL24                   *((volatile unsigned int*)(0x42600160UL))
#define bFM3_EXTI_EICL_ECL25                   *((volatile unsigned int*)(0x42600164UL))
#define bFM3_EXTI_EICL_ECL26                   *((volatile unsigned int*)(0x42600168UL))
#define bFM3_EXTI_EICL_ECL27                   *((volatile unsigned int*)(0x4260016CUL))
#define bFM3_EXTI_EICL_ECL28                   *((volatile unsigned int*)(0x42600170UL))
#define bFM3_EXTI_EICL_ECL29                   *((volatile unsigned int*)(0x42600174UL))
#define bFM3_EXTI_EICL_ECL30                   *((volatile unsigned int*)(0x42600178UL))
#define bFM3_EXTI_EICL_ECL31                   *((volatile unsigned int*)(0x4260017CUL))
#define bFM3_EXTI_ELVR_LA0                     *((volatile unsigned int*)(0x42600180UL))
#define bFM3_EXTI_ELVR_LB0                     *((volatile unsigned int*)(0x42600184UL))
#define bFM3_EXTI_ELVR_LA1                     *((volatile unsigned int*)(0x42600188UL))
#define bFM3_EXTI_ELVR_LB1                     *((volatile unsigned int*)(0x4260018CUL))
#define bFM3_EXTI_ELVR_LA2                     *((volatile unsigned int*)(0x42600190UL))
#define bFM3_EXTI_ELVR_LB2                     *((volatile unsigned int*)(0x42600194UL))
#define bFM3_EXTI_ELVR_LA3                     *((volatile unsigned int*)(0x42600198UL))
#define bFM3_EXTI_ELVR_LB3                     *((volatile unsigned int*)(0x4260019CUL))
#define bFM3_EXTI_ELVR_LA4                     *((volatile unsigned int*)(0x426001A0UL))
#define bFM3_EXTI_ELVR_LB4                     *((volatile unsigned int*)(0x426001A4UL))
#define bFM3_EXTI_ELVR_LA5                     *((volatile unsigned int*)(0x426001A8UL))
#define bFM3_EXTI_ELVR_LB5                     *((volatile unsigned int*)(0x426001ACUL))
#define bFM3_EXTI_ELVR_LA6                     *((volatile unsigned int*)(0x426001B0UL))
#define bFM3_EXTI_ELVR_LB6                     *((volatile unsigned int*)(0x426001B4UL))
#define bFM3_EXTI_ELVR_LA7                     *((volatile unsigned int*)(0x426001B8UL))
#define bFM3_EXTI_ELVR_LB7                     *((volatile unsigned int*)(0x426001BCUL))
#define bFM3_EXTI_ELVR_LA8                     *((volatile unsigned int*)(0x426001C0UL))
#define bFM3_EXTI_ELVR_LB8                     *((volatile unsigned int*)(0x426001C4UL))
#define bFM3_EXTI_ELVR_LA9                     *((volatile unsigned int*)(0x426001C8UL))
#define bFM3_EXTI_ELVR_LB9                     *((volatile unsigned int*)(0x426001CCUL))
#define bFM3_EXTI_ELVR_LA10                    *((volatile unsigned int*)(0x426001D0UL))
#define bFM3_EXTI_ELVR_LB10                    *((volatile unsigned int*)(0x426001D4UL))
#define bFM3_EXTI_ELVR_LA11                    *((volatile unsigned int*)(0x426001D8UL))
#define bFM3_EXTI_ELVR_LB11                    *((volatile unsigned int*)(0x426001DCUL))
#define bFM3_EXTI_ELVR_LA12                    *((volatile unsigned int*)(0x426001E0UL))
#define bFM3_EXTI_ELVR_LB12                    *((volatile unsigned int*)(0x426001E4UL))
#define bFM3_EXTI_ELVR_LA13                    *((volatile unsigned int*)(0x426001E8UL))
#define bFM3_EXTI_ELVR_LB13                    *((volatile unsigned int*)(0x426001ECUL))
#define bFM3_EXTI_ELVR_LA14                    *((volatile unsigned int*)(0x426001F0UL))
#define bFM3_EXTI_ELVR_LB14                    *((volatile unsigned int*)(0x426001F4UL))
#define bFM3_EXTI_ELVR_LA15                    *((volatile unsigned int*)(0x426001F8UL))
#define bFM3_EXTI_ELVR_LB15                    *((volatile unsigned int*)(0x426001FCUL))
#define bFM3_EXTI_ELVR_LA16                    *((volatile unsigned int*)(0x42600200UL))
#define bFM3_EXTI_ELVR_LB16                    *((volatile unsigned int*)(0x42600204UL))
#define bFM3_EXTI_ELVR_LA17                    *((volatile unsigned int*)(0x42600208UL))
#define bFM3_EXTI_ELVR_LB17                    *((volatile unsigned int*)(0x4260020CUL))
#define bFM3_EXTI_ELVR_LA18                    *((volatile unsigned int*)(0x42600210UL))
#define bFM3_EXTI_ELVR_LB18                    *((volatile unsigned int*)(0x42600214UL))
#define bFM3_EXTI_ELVR_LA19                    *((volatile unsigned int*)(0x42600218UL))
#define bFM3_EXTI_ELVR_LB19                    *((volatile unsigned int*)(0x4260021CUL))
#define bFM3_EXTI_ELVR_LA20                    *((volatile unsigned int*)(0x42600220UL))
#define bFM3_EXTI_ELVR_LB20                    *((volatile unsigned int*)(0x42600224UL))
#define bFM3_EXTI_ELVR_LA21                    *((volatile unsigned int*)(0x42600228UL))
#define bFM3_EXTI_ELVR_LB21                    *((volatile unsigned int*)(0x4260022CUL))
#define bFM3_EXTI_ELVR_LA22                    *((volatile unsigned int*)(0x42600230UL))
#define bFM3_EXTI_ELVR_LB22                    *((volatile unsigned int*)(0x42600234UL))
#define bFM3_EXTI_ELVR_LA23                    *((volatile unsigned int*)(0x42600238UL))
#define bFM3_EXTI_ELVR_LB23                    *((volatile unsigned int*)(0x4260023CUL))
#define bFM3_EXTI_ELVR_LA24                    *((volatile unsigned int*)(0x42600240UL))
#define bFM3_EXTI_ELVR_LB24                    *((volatile unsigned int*)(0x42600244UL))
#define bFM3_EXTI_ELVR_LA25                    *((volatile unsigned int*)(0x42600248UL))
#define bFM3_EXTI_ELVR_LB25                    *((volatile unsigned int*)(0x4260024CUL))
#define bFM3_EXTI_ELVR_LA26                    *((volatile unsigned int*)(0x42600250UL))
#define bFM3_EXTI_ELVR_LB26                    *((volatile unsigned int*)(0x42600254UL))
#define bFM3_EXTI_ELVR_LA27                    *((volatile unsigned int*)(0x42600258UL))
#define bFM3_EXTI_ELVR_LB27                    *((volatile unsigned int*)(0x4260025CUL))
#define bFM3_EXTI_ELVR_LA28                    *((volatile unsigned int*)(0x42600260UL))
#define bFM3_EXTI_ELVR_LB28                    *((volatile unsigned int*)(0x42600264UL))
#define bFM3_EXTI_ELVR_LA29                    *((volatile unsigned int*)(0x42600268UL))
#define bFM3_EXTI_ELVR_LB29                    *((volatile unsigned int*)(0x4260026CUL))
#define bFM3_EXTI_ELVR_LA30                    *((volatile unsigned int*)(0x42600270UL))
#define bFM3_EXTI_ELVR_LB30                    *((volatile unsigned int*)(0x42600274UL))
#define bFM3_EXTI_ELVR_LA31                    *((volatile unsigned int*)(0x42600278UL))
#define bFM3_EXTI_ELVR_LB31                    *((volatile unsigned int*)(0x4260027CUL))
#define bFM3_EXTI_NMIRR_NR                     *((volatile unsigned int*)(0x42600280UL))
#define bFM3_EXTI_NMICL_NCL                    *((volatile unsigned int*)(0x42600300UL))

/* Interrupt request read registers */
#define bFM3_INTREQ_DRQSEL_DRQSEL0             *((volatile unsigned int*)(0x42620000UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL1             *((volatile unsigned int*)(0x42620004UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL2             *((volatile unsigned int*)(0x42620008UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL3             *((volatile unsigned int*)(0x4262000CUL))
#define bFM3_INTREQ_DRQSEL_DRQSEL4             *((volatile unsigned int*)(0x42620010UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL5             *((volatile unsigned int*)(0x42620014UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL6             *((volatile unsigned int*)(0x42620018UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL7             *((volatile unsigned int*)(0x4262001CUL))
#define bFM3_INTREQ_DRQSEL_DRQSEL8             *((volatile unsigned int*)(0x42620020UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL9             *((volatile unsigned int*)(0x42620024UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL10            *((volatile unsigned int*)(0x42620028UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL11            *((volatile unsigned int*)(0x4262002CUL))
#define bFM3_INTREQ_DRQSEL_DRQSEL12            *((volatile unsigned int*)(0x42620030UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL13            *((volatile unsigned int*)(0x42620034UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL14            *((volatile unsigned int*)(0x42620038UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL15            *((volatile unsigned int*)(0x4262003CUL))
#define bFM3_INTREQ_DRQSEL_DRQSEL16            *((volatile unsigned int*)(0x42620040UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL17            *((volatile unsigned int*)(0x42620044UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL18            *((volatile unsigned int*)(0x42620048UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL19            *((volatile unsigned int*)(0x4262004CUL))
#define bFM3_INTREQ_DRQSEL_DRQSEL20            *((volatile unsigned int*)(0x42620050UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL21            *((volatile unsigned int*)(0x42620054UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL22            *((volatile unsigned int*)(0x42620058UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL23            *((volatile unsigned int*)(0x4262005CUL))
#define bFM3_INTREQ_DRQSEL_DRQSEL24            *((volatile unsigned int*)(0x42620060UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL25            *((volatile unsigned int*)(0x42620064UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL26            *((volatile unsigned int*)(0x42620068UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL27            *((volatile unsigned int*)(0x4262006CUL))
#define bFM3_INTREQ_DRQSEL_DRQSEL28            *((volatile unsigned int*)(0x42620070UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL29            *((volatile unsigned int*)(0x42620074UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL30            *((volatile unsigned int*)(0x42620078UL))
#define bFM3_INTREQ_DRQSEL_DRQSEL31            *((volatile unsigned int*)(0x4262007CUL))
#define bFM3_INTREQ_ODDPKS_ODDPKS0             *((volatile unsigned char*)(0x42620160UL))
#define bFM3_INTREQ_ODDPKS_ODDPKS1             *((volatile unsigned char*)(0x42620164UL))
#define bFM3_INTREQ_ODDPKS_ODDPKS2             *((volatile unsigned char*)(0x42620168UL))
#define bFM3_INTREQ_ODDPKS_ODDPKS3             *((volatile unsigned char*)(0x4262016CUL))
#define bFM3_INTREQ_ODDPKS_ODDPKS4             *((volatile unsigned char*)(0x42620170UL))
#define bFM3_INTREQ_EXC02MON_NMI               *((volatile unsigned int*)(0x42620200UL))
#define bFM3_INTREQ_EXC02MON_HWINT             *((volatile unsigned int*)(0x42620204UL))
#define bFM3_INTREQ_IRQ00MON_FCSINT            *((volatile unsigned int*)(0x42620280UL))
#define bFM3_INTREQ_IRQ01MON_SWWDTINT          *((volatile unsigned int*)(0x42620300UL))
#define bFM3_INTREQ_IRQ02MON_LVDINT            *((volatile unsigned int*)(0x42620380UL))
#define bFM3_INTREQ_IRQ03MON_WAVE0INT0         *((volatile unsigned int*)(0x42620400UL))
#define bFM3_INTREQ_IRQ03MON_WAVE0INT1         *((volatile unsigned int*)(0x42620404UL))
#define bFM3_INTREQ_IRQ03MON_WAVE0INT2         *((volatile unsigned int*)(0x42620408UL))
#define bFM3_INTREQ_IRQ03MON_WAVE0INT3         *((volatile unsigned int*)(0x4262040CUL))
#define bFM3_INTREQ_IRQ03MON_WAVE1INT0         *((volatile unsigned int*)(0x42620410UL))
#define bFM3_INTREQ_IRQ03MON_WAVE1INT1         *((volatile unsigned int*)(0x42620414UL))
#define bFM3_INTREQ_IRQ03MON_WAVE1INT2         *((volatile unsigned int*)(0x42620418UL))
#define bFM3_INTREQ_IRQ03MON_WAVE1INT3         *((volatile unsigned int*)(0x4262041CUL))
#define bFM3_INTREQ_IRQ03MON_WAVE2INT0         *((volatile unsigned int*)(0x42620420UL))
#define bFM3_INTREQ_IRQ03MON_WAVE2INT1         *((volatile unsigned int*)(0x42620424UL))
#define bFM3_INTREQ_IRQ03MON_WAVE2INT2         *((volatile unsigned int*)(0x42620428UL))
#define bFM3_INTREQ_IRQ03MON_WAVE2INT3         *((volatile unsigned int*)(0x4262042CUL))
#define bFM3_INTREQ_IRQ04MON_EXTINT0           *((volatile unsigned int*)(0x42620480UL))
#define bFM3_INTREQ_IRQ04MON_EXTINT1           *((volatile unsigned int*)(0x42620484UL))
#define bFM3_INTREQ_IRQ04MON_EXTINT2           *((volatile unsigned int*)(0x42620488UL))
#define bFM3_INTREQ_IRQ04MON_EXTINT3           *((volatile unsigned int*)(0x4262048CUL))
#define bFM3_INTREQ_IRQ04MON_EXTINT4           *((volatile unsigned int*)(0x42620490UL))
#define bFM3_INTREQ_IRQ04MON_EXTINT5           *((volatile unsigned int*)(0x42620494UL))
#define bFM3_INTREQ_IRQ04MON_EXTINT6           *((volatile unsigned int*)(0x42620498UL))
#define bFM3_INTREQ_IRQ04MON_EXTINT7           *((volatile unsigned int*)(0x4262049CUL))
#define bFM3_INTREQ_IRQ05MON_EXTINT0           *((volatile unsigned int*)(0x42620500UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT1           *((volatile unsigned int*)(0x42620504UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT2           *((volatile unsigned int*)(0x42620508UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT3           *((volatile unsigned int*)(0x4262050CUL))
#define bFM3_INTREQ_IRQ05MON_EXTINT4           *((volatile unsigned int*)(0x42620510UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT5           *((volatile unsigned int*)(0x42620514UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT6           *((volatile unsigned int*)(0x42620518UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT7           *((volatile unsigned int*)(0x4262051CUL))
#define bFM3_INTREQ_IRQ05MON_EXTINT8           *((volatile unsigned int*)(0x42620520UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT9           *((volatile unsigned int*)(0x42620524UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT10          *((volatile unsigned int*)(0x42620528UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT11          *((volatile unsigned int*)(0x4262052CUL))
#define bFM3_INTREQ_IRQ05MON_EXTINT12          *((volatile unsigned int*)(0x42620530UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT13          *((volatile unsigned int*)(0x42620534UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT14          *((volatile unsigned int*)(0x42620538UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT15          *((volatile unsigned int*)(0x4262053CUL))
#define bFM3_INTREQ_IRQ05MON_EXTINT16          *((volatile unsigned int*)(0x42620540UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT17          *((volatile unsigned int*)(0x42620544UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT18          *((volatile unsigned int*)(0x42620548UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT19          *((volatile unsigned int*)(0x4262054CUL))
#define bFM3_INTREQ_IRQ05MON_EXTINT20          *((volatile unsigned int*)(0x42620550UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT21          *((volatile unsigned int*)(0x42620554UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT22          *((volatile unsigned int*)(0x42620558UL))
#define bFM3_INTREQ_IRQ05MON_EXTINT23          *((volatile unsigned int*)(0x4262055CUL))
#define bFM3_INTREQ_IRQ06MON_TIMINT1           *((volatile unsigned int*)(0x42620580UL))
#define bFM3_INTREQ_IRQ06MON_TIMINT2           *((volatile unsigned int*)(0x42620584UL))
#define bFM3_INTREQ_IRQ06MON_QUD0INT0          *((volatile unsigned int*)(0x42620588UL))
#define bFM3_INTREQ_IRQ06MON_QUD0INT1          *((volatile unsigned int*)(0x4262058CUL))
#define bFM3_INTREQ_IRQ06MON_QUD0INT2          *((volatile unsigned int*)(0x42620590UL))
#define bFM3_INTREQ_IRQ06MON_QUD0INT3          *((volatile unsigned int*)(0x42620594UL))
#define bFM3_INTREQ_IRQ06MON_QUD0INT4          *((volatile unsigned int*)(0x42620598UL))
#define bFM3_INTREQ_IRQ06MON_QUD0INT5          *((volatile unsigned int*)(0x4262059CUL))
#define bFM3_INTREQ_IRQ06MON_QUD1INT0          *((volatile unsigned int*)(0x426205A0UL))
#define bFM3_INTREQ_IRQ06MON_QUD1INT1          *((volatile unsigned int*)(0x426205A4UL))
#define bFM3_INTREQ_IRQ06MON_QUD1INT2          *((volatile unsigned int*)(0x426205A8UL))
#define bFM3_INTREQ_IRQ06MON_QUD1INT3          *((volatile unsigned int*)(0x426205ACUL))
#define bFM3_INTREQ_IRQ06MON_QUD1INT4          *((volatile unsigned int*)(0x426205B0UL))
#define bFM3_INTREQ_IRQ06MON_QUD1INT5          *((volatile unsigned int*)(0x426205B4UL))
#define bFM3_INTREQ_IRQ06MON_QUD2INT0          *((volatile unsigned int*)(0x426205B8UL))
#define bFM3_INTREQ_IRQ06MON_QUD2INT1          *((volatile unsigned int*)(0x426205BCUL))
#define bFM3_INTREQ_IRQ06MON_QUD2INT2          *((volatile unsigned int*)(0x426205C0UL))
#define bFM3_INTREQ_IRQ06MON_QUD2INT3          *((volatile unsigned int*)(0x426205C4UL))
#define bFM3_INTREQ_IRQ06MON_QUD2INT4          *((volatile unsigned int*)(0x426205C8UL))
#define bFM3_INTREQ_IRQ06MON_QUD2INT5          *((volatile unsigned int*)(0x426205CCUL))
#define bFM3_INTREQ_IRQ07MON_MFSINT            *((volatile unsigned int*)(0x42620600UL))
#define bFM3_INTREQ_IRQ08MON_MFSINT0           *((volatile unsigned int*)(0x42620680UL))
#define bFM3_INTREQ_IRQ08MON_MFSINT1           *((volatile unsigned int*)(0x42620684UL))
#define bFM3_INTREQ_IRQ09MON_MFSINT            *((volatile unsigned int*)(0x42620700UL))
#define bFM3_INTREQ_IRQ10MON_MFSINT0           *((volatile unsigned int*)(0x42620780UL))
#define bFM3_INTREQ_IRQ10MON_MFSINT1           *((volatile unsigned int*)(0x42620784UL))
#define bFM3_INTREQ_IRQ11MON_MFSINT            *((volatile unsigned int*)(0x42620800UL))
#define bFM3_INTREQ_IRQ12MON_MFSINT0           *((volatile unsigned int*)(0x42620880UL))
#define bFM3_INTREQ_IRQ12MON_MFSINT1           *((volatile unsigned int*)(0x42620884UL))
#define bFM3_INTREQ_IRQ13MON_MFSINT            *((volatile unsigned int*)(0x42620900UL))
#define bFM3_INTREQ_IRQ14MON_MFSINT0           *((volatile unsigned int*)(0x42620980UL))
#define bFM3_INTREQ_IRQ14MON_MFSINT1           *((volatile unsigned int*)(0x42620984UL))
#define bFM3_INTREQ_IRQ15MON_MFSINT            *((volatile unsigned int*)(0x42620A00UL))
#define bFM3_INTREQ_IRQ16MON_MFSINT0           *((volatile unsigned int*)(0x42620A80UL))
#define bFM3_INTREQ_IRQ16MON_MFSINT1           *((volatile unsigned int*)(0x42620A84UL))
#define bFM3_INTREQ_IRQ17MON_MFSINT            *((volatile unsigned int*)(0x42620B00UL))
#define bFM3_INTREQ_IRQ18MON_MFSINT0           *((volatile unsigned int*)(0x42620B80UL))
#define bFM3_INTREQ_IRQ18MON_MFSINT1           *((volatile unsigned int*)(0x42620B84UL))
#define bFM3_INTREQ_IRQ19MON_MFSINT            *((volatile unsigned int*)(0x42620C00UL))
#define bFM3_INTREQ_IRQ20MON_MFSINT0           *((volatile unsigned int*)(0x42620C80UL))
#define bFM3_INTREQ_IRQ20MON_MFSINT1           *((volatile unsigned int*)(0x42620C84UL))
#define bFM3_INTREQ_IRQ21MON_MFSINT            *((volatile unsigned int*)(0x42620D00UL))
#define bFM3_INTREQ_IRQ22MON_MFSINT0           *((volatile unsigned int*)(0x42620D80UL))
#define bFM3_INTREQ_IRQ22MON_MFSINT1           *((volatile unsigned int*)(0x42620D84UL))
#define bFM3_INTREQ_IRQ23MON_PPGINT0           *((volatile unsigned int*)(0x42620E00UL))
#define bFM3_INTREQ_IRQ23MON_PPGINT1           *((volatile unsigned int*)(0x42620E04UL))
#define bFM3_INTREQ_IRQ23MON_PPGINT2           *((volatile unsigned int*)(0x42620E08UL))
#define bFM3_INTREQ_IRQ23MON_PPGINT3           *((volatile unsigned int*)(0x42620E0CUL))
#define bFM3_INTREQ_IRQ23MON_PPGINT4           *((volatile unsigned int*)(0x42620E10UL))
#define bFM3_INTREQ_IRQ23MON_PPGINT5           *((volatile unsigned int*)(0x42620E14UL))
#define bFM3_INTREQ_IRQ23MON_PPGINT6           *((volatile unsigned int*)(0x42620E18UL))
#define bFM3_INTREQ_IRQ23MON_PPGINT7           *((volatile unsigned int*)(0x42620E1CUL))
#define bFM3_INTREQ_IRQ23MON_PPGINT8           *((volatile unsigned int*)(0x42620E20UL))
#define bFM3_INTREQ_IRQ24MON_MOSCINT           *((volatile unsigned int*)(0x42620E80UL))
#define bFM3_INTREQ_IRQ24MON_SOSCINT           *((volatile unsigned int*)(0x42620E84UL))
#define bFM3_INTREQ_IRQ24MON_MPLLINT           *((volatile unsigned int*)(0x42620E88UL))
#define bFM3_INTREQ_IRQ24MON_UPLLINT           *((volatile unsigned int*)(0x42620E8CUL))
#define bFM3_INTREQ_IRQ24MON_WCINT             *((volatile unsigned int*)(0x42620E90UL))
#define bFM3_INTREQ_IRQ25MON_ADCINT0           *((volatile unsigned int*)(0x42620F00UL))
#define bFM3_INTREQ_IRQ25MON_ADCINT1           *((volatile unsigned int*)(0x42620F04UL))
#define bFM3_INTREQ_IRQ25MON_ADCINT2           *((volatile unsigned int*)(0x42620F08UL))
#define bFM3_INTREQ_IRQ25MON_ADCINT3           *((volatile unsigned int*)(0x42620F0CUL))
#define bFM3_INTREQ_IRQ26MON_ADCINT0           *((volatile unsigned int*)(0x42620F80UL))
#define bFM3_INTREQ_IRQ26MON_ADCINT1           *((volatile unsigned int*)(0x42620F84UL))
#define bFM3_INTREQ_IRQ26MON_ADCINT2           *((volatile unsigned int*)(0x42620F88UL))
#define bFM3_INTREQ_IRQ26MON_ADCINT3           *((volatile unsigned int*)(0x42620F8CUL))
#define bFM3_INTREQ_IRQ27MON_ADCINT0           *((volatile unsigned int*)(0x42621000UL))
#define bFM3_INTREQ_IRQ27MON_ADCINT1           *((volatile unsigned int*)(0x42621004UL))
#define bFM3_INTREQ_IRQ27MON_ADCINT2           *((volatile unsigned int*)(0x42621008UL))
#define bFM3_INTREQ_IRQ27MON_ADCINT3           *((volatile unsigned int*)(0x4262100CUL))
#define bFM3_INTREQ_IRQ28MON_FRT0INT0          *((volatile unsigned int*)(0x42621080UL))
#define bFM3_INTREQ_IRQ28MON_FRT0INT1          *((volatile unsigned int*)(0x42621084UL))
#define bFM3_INTREQ_IRQ28MON_FRT0INT2          *((volatile unsigned int*)(0x42621088UL))
#define bFM3_INTREQ_IRQ28MON_FRT0INT3          *((volatile unsigned int*)(0x4262108CUL))
#define bFM3_INTREQ_IRQ28MON_FRT0INT4          *((volatile unsigned int*)(0x42621090UL))
#define bFM3_INTREQ_IRQ28MON_FRT0INT5          *((volatile unsigned int*)(0x42621094UL))
#define bFM3_INTREQ_IRQ28MON_FRT1INT0          *((volatile unsigned int*)(0x42621098UL))
#define bFM3_INTREQ_IRQ28MON_FRT1INT1          *((volatile unsigned int*)(0x4262109CUL))
#define bFM3_INTREQ_IRQ28MON_FRT1INT2          *((volatile unsigned int*)(0x426210A0UL))
#define bFM3_INTREQ_IRQ28MON_FRT1INT3          *((volatile unsigned int*)(0x426210A4UL))
#define bFM3_INTREQ_IRQ28MON_FRT1INT4          *((volatile unsigned int*)(0x426210A8UL))
#define bFM3_INTREQ_IRQ28MON_FRT1INT5          *((volatile unsigned int*)(0x426210ACUL))
#define bFM3_INTREQ_IRQ28MON_FRT2INT0          *((volatile unsigned int*)(0x426210B0UL))
#define bFM3_INTREQ_IRQ28MON_FRT2INT1          *((volatile unsigned int*)(0x426210B4UL))
#define bFM3_INTREQ_IRQ28MON_FRT2INT2          *((volatile unsigned int*)(0x426210B8UL))
#define bFM3_INTREQ_IRQ28MON_FRT2INT3          *((volatile unsigned int*)(0x426210BCUL))
#define bFM3_INTREQ_IRQ28MON_FRT2INT4          *((volatile unsigned int*)(0x426210C0UL))
#define bFM3_INTREQ_IRQ28MON_FRT2INT5          *((volatile unsigned int*)(0x426210C4UL))
#define bFM3_INTREQ_IRQ29MON_ICU0INT0          *((volatile unsigned int*)(0x42621100UL))
#define bFM3_INTREQ_IRQ29MON_ICU0INT1          *((volatile unsigned int*)(0x42621104UL))
#define bFM3_INTREQ_IRQ29MON_ICU0INT2          *((volatile unsigned int*)(0x42621108UL))
#define bFM3_INTREQ_IRQ29MON_ICU0INT3          *((volatile unsigned int*)(0x4262110CUL))
#define bFM3_INTREQ_IRQ29MON_ICU1INT0          *((volatile unsigned int*)(0x42621110UL))
#define bFM3_INTREQ_IRQ29MON_ICU1INT1          *((volatile unsigned int*)(0x42621114UL))
#define bFM3_INTREQ_IRQ29MON_ICU1INT2          *((volatile unsigned int*)(0x42621118UL))
#define bFM3_INTREQ_IRQ29MON_ICU1INT3          *((volatile unsigned int*)(0x4262111CUL))
#define bFM3_INTREQ_IRQ29MON_ICU2INT0          *((volatile unsigned int*)(0x42621120UL))
#define bFM3_INTREQ_IRQ29MON_ICU2INT1          *((volatile unsigned int*)(0x42621124UL))
#define bFM3_INTREQ_IRQ29MON_ICU2INT2          *((volatile unsigned int*)(0x42621128UL))
#define bFM3_INTREQ_IRQ29MON_ICU2INT3          *((volatile unsigned int*)(0x4262112CUL))
#define bFM3_INTREQ_IRQ30MON_OCU0INT0          *((volatile unsigned int*)(0x42621180UL))
#define bFM3_INTREQ_IRQ30MON_OCU0INT1          *((volatile unsigned int*)(0x42621184UL))
#define bFM3_INTREQ_IRQ30MON_OCU0INT2          *((volatile unsigned int*)(0x42621188UL))
#define bFM3_INTREQ_IRQ30MON_OCU0INT3          *((volatile unsigned int*)(0x4262118CUL))
#define bFM3_INTREQ_IRQ30MON_OCU0INT4          *((volatile unsigned int*)(0x42621190UL))
#define bFM3_INTREQ_IRQ30MON_OCU0INT5          *((volatile unsigned int*)(0x42621194UL))
#define bFM3_INTREQ_IRQ30MON_OCU1INT0          *((volatile unsigned int*)(0x42621198UL))
#define bFM3_INTREQ_IRQ30MON_OCU1INT1          *((volatile unsigned int*)(0x4262119CUL))
#define bFM3_INTREQ_IRQ30MON_OCU1INT2          *((volatile unsigned int*)(0x426211A0UL))
#define bFM3_INTREQ_IRQ30MON_OCU1INT3          *((volatile unsigned int*)(0x426211A4UL))
#define bFM3_INTREQ_IRQ30MON_OCU1INT4          *((volatile unsigned int*)(0x426211A8UL))
#define bFM3_INTREQ_IRQ30MON_OCU1INT5          *((volatile unsigned int*)(0x426211ACUL))
#define bFM3_INTREQ_IRQ30MON_OCU2INT0          *((volatile unsigned int*)(0x426211B0UL))
#define bFM3_INTREQ_IRQ30MON_OCU2INT1          *((volatile unsigned int*)(0x426211B4UL))
#define bFM3_INTREQ_IRQ30MON_OCU2INT2          *((volatile unsigned int*)(0x426211B8UL))
#define bFM3_INTREQ_IRQ30MON_OCU2INT3          *((volatile unsigned int*)(0x426211BCUL))
#define bFM3_INTREQ_IRQ30MON_OCU2INT4          *((volatile unsigned int*)(0x426211C0UL))
#define bFM3_INTREQ_IRQ30MON_OCU2INT5          *((volatile unsigned int*)(0x426211C4UL))
#define bFM3_INTREQ_IRQ31MON_BTINT0            *((volatile unsigned int*)(0x42621200UL))
#define bFM3_INTREQ_IRQ31MON_BTINT1            *((volatile unsigned int*)(0x42621204UL))
#define bFM3_INTREQ_IRQ31MON_BTINT2            *((volatile unsigned int*)(0x42621208UL))
#define bFM3_INTREQ_IRQ31MON_BTINT3            *((volatile unsigned int*)(0x4262120CUL))
#define bFM3_INTREQ_IRQ31MON_BTINT4            *((volatile unsigned int*)(0x42621210UL))
#define bFM3_INTREQ_IRQ31MON_BTINT5            *((volatile unsigned int*)(0x42621214UL))
#define bFM3_INTREQ_IRQ31MON_BTINT6            *((volatile unsigned int*)(0x42621218UL))
#define bFM3_INTREQ_IRQ31MON_BTINT7            *((volatile unsigned int*)(0x4262121CUL))
#define bFM3_INTREQ_IRQ31MON_BTINT8            *((volatile unsigned int*)(0x42621220UL))
#define bFM3_INTREQ_IRQ31MON_BTINT9            *((volatile unsigned int*)(0x42621224UL))
#define bFM3_INTREQ_IRQ31MON_BTINT10           *((volatile unsigned int*)(0x42621228UL))
#define bFM3_INTREQ_IRQ31MON_BTINT11           *((volatile unsigned int*)(0x4262122CUL))
#define bFM3_INTREQ_IRQ31MON_BTINT12           *((volatile unsigned int*)(0x42621230UL))
#define bFM3_INTREQ_IRQ31MON_BTINT13           *((volatile unsigned int*)(0x42621234UL))
#define bFM3_INTREQ_IRQ31MON_BTINT14           *((volatile unsigned int*)(0x42621238UL))
#define bFM3_INTREQ_IRQ31MON_BTINT15           *((volatile unsigned int*)(0x4262123CUL))
#define bFM3_INTREQ_IRQ32MON_CAN0INT           *((volatile unsigned int*)(0x42621280UL))
#define bFM3_INTREQ_IRQ32MON_MAC0SBD           *((volatile unsigned int*)(0x42621284UL))
#define bFM3_INTREQ_IRQ32MON_MAC0PMI           *((volatile unsigned int*)(0x42621288UL))
#define bFM3_INTREQ_IRQ32MON_MAC0LPI           *((volatile unsigned int*)(0x4262128CUL))
#define bFM3_INTREQ_IRQ33MON_CAN1INT           *((volatile unsigned int*)(0x42621300UL))
#define bFM3_INTREQ_IRQ33MON_MAC1SBD           *((volatile unsigned int*)(0x42621304UL))
#define bFM3_INTREQ_IRQ33MON_MAC1PMI           *((volatile unsigned int*)(0x42621308UL))
#define bFM3_INTREQ_IRQ34MON_USB0INT0          *((volatile unsigned int*)(0x42621380UL))
#define bFM3_INTREQ_IRQ34MON_USB0INT1          *((volatile unsigned int*)(0x42621384UL))
#define bFM3_INTREQ_IRQ34MON_USB0INT2          *((volatile unsigned int*)(0x42621388UL))
#define bFM3_INTREQ_IRQ34MON_USB0INT3          *((volatile unsigned int*)(0x4262138CUL))
#define bFM3_INTREQ_IRQ34MON_USB0INT4          *((volatile unsigned int*)(0x42621390UL))
#define bFM3_INTREQ_IRQ35MON_USB0INT0          *((volatile unsigned int*)(0x42621400UL))
#define bFM3_INTREQ_IRQ35MON_USB0INT1          *((volatile unsigned int*)(0x42621404UL))
#define bFM3_INTREQ_IRQ35MON_USB0INT2          *((volatile unsigned int*)(0x42621408UL))
#define bFM3_INTREQ_IRQ35MON_USB0INT3          *((volatile unsigned int*)(0x4262140CUL))
#define bFM3_INTREQ_IRQ35MON_USB0INT4          *((volatile unsigned int*)(0x42621410UL))
#define bFM3_INTREQ_IRQ35MON_USB0INT5          *((volatile unsigned int*)(0x42621414UL))
#define bFM3_INTREQ_IRQ36MON_USB1INT0          *((volatile unsigned int*)(0x42621480UL))
#define bFM3_INTREQ_IRQ36MON_USB1INT1          *((volatile unsigned int*)(0x42621484UL))
#define bFM3_INTREQ_IRQ36MON_USB1INT2          *((volatile unsigned int*)(0x42621488UL))
#define bFM3_INTREQ_IRQ36MON_USB1INT3          *((volatile unsigned int*)(0x4262148CUL))
#define bFM3_INTREQ_IRQ36MON_USB1INT4          *((volatile unsigned int*)(0x42621490UL))
#define bFM3_INTREQ_IRQ37MON_USB1INT0          *((volatile unsigned int*)(0x42621500UL))
#define bFM3_INTREQ_IRQ37MON_USB1INT1          *((volatile unsigned int*)(0x42621504UL))
#define bFM3_INTREQ_IRQ37MON_USB1INT2          *((volatile unsigned int*)(0x42621508UL))
#define bFM3_INTREQ_IRQ37MON_USB1INT3          *((volatile unsigned int*)(0x4262150CUL))
#define bFM3_INTREQ_IRQ37MON_USB1INT4          *((volatile unsigned int*)(0x42621510UL))
#define bFM3_INTREQ_IRQ37MON_USB1INT5          *((volatile unsigned int*)(0x42621514UL))
#define bFM3_INTREQ_IRQ38MON_DMAINT            *((volatile unsigned int*)(0x42621580UL))
#define bFM3_INTREQ_IRQ39MON_DMAINT            *((volatile unsigned int*)(0x42621600UL))
#define bFM3_INTREQ_IRQ40MON_DMAINT            *((volatile unsigned int*)(0x42621680UL))
#define bFM3_INTREQ_IRQ41MON_DMAINT            *((volatile unsigned int*)(0x42621700UL))
#define bFM3_INTREQ_IRQ42MON_DMAINT            *((volatile unsigned int*)(0x42621780UL))
#define bFM3_INTREQ_IRQ43MON_DMAINT            *((volatile unsigned int*)(0x42621800UL))
#define bFM3_INTREQ_IRQ44MON_DMAINT            *((volatile unsigned int*)(0x42621880UL))
#define bFM3_INTREQ_IRQ45MON_DMAINT            *((volatile unsigned int*)(0x42621900UL))
#define bFM3_INTREQ_IRQ46MON_BTINT0            *((volatile unsigned int*)(0x42621980UL))
#define bFM3_INTREQ_IRQ46MON_BTINT1            *((volatile unsigned int*)(0x42621984UL))
#define bFM3_INTREQ_IRQ46MON_BTINT2            *((volatile unsigned int*)(0x42621988UL))
#define bFM3_INTREQ_IRQ46MON_BTINT3            *((volatile unsigned int*)(0x4262198CUL))
#define bFM3_INTREQ_IRQ46MON_BTINT4            *((volatile unsigned int*)(0x42621990UL))
#define bFM3_INTREQ_IRQ46MON_BTINT5            *((volatile unsigned int*)(0x42621994UL))
#define bFM3_INTREQ_IRQ46MON_BTINT6            *((volatile unsigned int*)(0x42621998UL))
#define bFM3_INTREQ_IRQ46MON_BTINT7            *((volatile unsigned int*)(0x4262199CUL))
#define bFM3_INTREQ_IRQ46MON_BTINT8            *((volatile unsigned int*)(0x426219A0UL))
#define bFM3_INTREQ_IRQ46MON_BTINT9            *((volatile unsigned int*)(0x426219A4UL))
#define bFM3_INTREQ_IRQ46MON_BTINT10           *((volatile unsigned int*)(0x426219A8UL))
#define bFM3_INTREQ_IRQ46MON_BTINT11           *((volatile unsigned int*)(0x426219ACUL))
#define bFM3_INTREQ_IRQ46MON_BTINT12           *((volatile unsigned int*)(0x426219B0UL))
#define bFM3_INTREQ_IRQ46MON_BTINT13           *((volatile unsigned int*)(0x426219B4UL))
#define bFM3_INTREQ_IRQ46MON_BTINT14           *((volatile unsigned int*)(0x426219B8UL))
#define bFM3_INTREQ_IRQ46MON_BTINT15           *((volatile unsigned int*)(0x426219BCUL))
#define bFM3_INTREQ_DRQSEL1_DRQSEL10           *((volatile unsigned int*)(0x42624000UL))
#define bFM3_INTREQ_DRQSEL1_DRQSEL11           *((volatile unsigned int*)(0x42624004UL))
#define bFM3_INTREQ_DRQSEL1_DRQSEL12           *((volatile unsigned int*)(0x42624008UL))
#define bFM3_INTREQ_DRQSEL1_DRQSEL13           *((volatile unsigned int*)(0x4262400CUL))
#define bFM3_INTREQ_DRQSEL1_DRQSEL14           *((volatile unsigned int*)(0x42624010UL))
#define bFM3_INTREQ_DQESEL_ESEL100             *((volatile unsigned int*)(0x42624080UL))
#define bFM3_INTREQ_DQESEL_ESEL101             *((volatile unsigned int*)(0x42624084UL))
#define bFM3_INTREQ_DQESEL_ESEL102             *((volatile unsigned int*)(0x42624088UL))
#define bFM3_INTREQ_DQESEL_ESEL103             *((volatile unsigned int*)(0x4262408CUL))
#define bFM3_INTREQ_DQESEL_ESEL110             *((volatile unsigned int*)(0x42624090UL))
#define bFM3_INTREQ_DQESEL_ESEL111             *((volatile unsigned int*)(0x42624094UL))
#define bFM3_INTREQ_DQESEL_ESEL112             *((volatile unsigned int*)(0x42624098UL))
#define bFM3_INTREQ_DQESEL_ESEL113             *((volatile unsigned int*)(0x4262409CUL))
#define bFM3_INTREQ_DQESEL_ESEL240             *((volatile unsigned int*)(0x426240A0UL))
#define bFM3_INTREQ_DQESEL_ESEL241             *((volatile unsigned int*)(0x426240A4UL))
#define bFM3_INTREQ_DQESEL_ESEL242             *((volatile unsigned int*)(0x426240A8UL))
#define bFM3_INTREQ_DQESEL_ESEL243             *((volatile unsigned int*)(0x426240ACUL))
#define bFM3_INTREQ_DQESEL_ESEL250             *((volatile unsigned int*)(0x426240B0UL))
#define bFM3_INTREQ_DQESEL_ESEL251             *((volatile unsigned int*)(0x426240B4UL))
#define bFM3_INTREQ_DQESEL_ESEL252             *((volatile unsigned int*)(0x426240B8UL))
#define bFM3_INTREQ_DQESEL_ESEL253             *((volatile unsigned int*)(0x426240BCUL))
#define bFM3_INTREQ_DQESEL_ESEL260             *((volatile unsigned int*)(0x426240C0UL))
#define bFM3_INTREQ_DQESEL_ESEL261             *((volatile unsigned int*)(0x426240C4UL))
#define bFM3_INTREQ_DQESEL_ESEL262             *((volatile unsigned int*)(0x426240C8UL))
#define bFM3_INTREQ_DQESEL_ESEL263             *((volatile unsigned int*)(0x426240CCUL))
#define bFM3_INTREQ_DQESEL_ESEL270             *((volatile unsigned int*)(0x426240D0UL))
#define bFM3_INTREQ_DQESEL_ESEL271             *((volatile unsigned int*)(0x426240D4UL))
#define bFM3_INTREQ_DQESEL_ESEL272             *((volatile unsigned int*)(0x426240D8UL))
#define bFM3_INTREQ_DQESEL_ESEL273             *((volatile unsigned int*)(0x426240DCUL))
#define bFM3_INTREQ_DQESEL_ESEL300             *((volatile unsigned int*)(0x426240E0UL))
#define bFM3_INTREQ_DQESEL_ESEL301             *((volatile unsigned int*)(0x426240E4UL))
#define bFM3_INTREQ_DQESEL_ESEL302             *((volatile unsigned int*)(0x426240E8UL))
#define bFM3_INTREQ_DQESEL_ESEL303             *((volatile unsigned int*)(0x426240ECUL))
#define bFM3_INTREQ_DQESEL_ESEL310             *((volatile unsigned int*)(0x426240F0UL))
#define bFM3_INTREQ_DQESEL_ESEL311             *((volatile unsigned int*)(0x426240F4UL))
#define bFM3_INTREQ_DQESEL_ESEL312             *((volatile unsigned int*)(0x426240F8UL))
#define bFM3_INTREQ_DQESEL_ESEL313             *((volatile unsigned int*)(0x426240FCUL))
#define bFM3_INTREQ_ODDPKS1_ODDPKS10           *((volatile unsigned char*)(0x426241E0UL))
#define bFM3_INTREQ_ODDPKS1_ODDPKS11           *((volatile unsigned char*)(0x426241E4UL))
#define bFM3_INTREQ_ODDPKS1_ODDPKS12           *((volatile unsigned char*)(0x426241E8UL))
#define bFM3_INTREQ_ODDPKS1_ODDPKS13           *((volatile unsigned char*)(0x426241ECUL))
#define bFM3_INTREQ_ODDPKS1_ODDPKS14           *((volatile unsigned char*)(0x426241F0UL))

/* General purpose I/O registers */
#define bFM3_GPIO_PFR0_P0                      *((volatile unsigned int*)(0x42660000UL))
#define bFM3_GPIO_PFR0_P1                      *((volatile unsigned int*)(0x42660004UL))
#define bFM3_GPIO_PFR0_P2                      *((volatile unsigned int*)(0x42660008UL))
#define bFM3_GPIO_PFR0_P3                      *((volatile unsigned int*)(0x4266000CUL))
#define bFM3_GPIO_PFR0_P4                      *((volatile unsigned int*)(0x42660010UL))
#define bFM3_GPIO_PFR0_P5                      *((volatile unsigned int*)(0x42660014UL))
#define bFM3_GPIO_PFR0_P6                      *((volatile unsigned int*)(0x42660018UL))
#define bFM3_GPIO_PFR0_P7                      *((volatile unsigned int*)(0x4266001CUL))
#define bFM3_GPIO_PFR0_P8                      *((volatile unsigned int*)(0x42660020UL))
#define bFM3_GPIO_PFR0_P9                      *((volatile unsigned int*)(0x42660024UL))
#define bFM3_GPIO_PFR1_P0                      *((volatile unsigned int*)(0x42660080UL))
#define bFM3_GPIO_PFR1_P1                      *((volatile unsigned int*)(0x42660084UL))
#define bFM3_GPIO_PFR1_P2                      *((volatile unsigned int*)(0x42660088UL))
#define bFM3_GPIO_PFR1_P3                      *((volatile unsigned int*)(0x4266008CUL))
#define bFM3_GPIO_PFR1_P4                      *((volatile unsigned int*)(0x42660090UL))
#define bFM3_GPIO_PFR1_P5                      *((volatile unsigned int*)(0x42660094UL))
#define bFM3_GPIO_PFR1_P6                      *((volatile unsigned int*)(0x42660098UL))
#define bFM3_GPIO_PFR1_P7                      *((volatile unsigned int*)(0x4266009CUL))
#define bFM3_GPIO_PFR1_P8                      *((volatile unsigned int*)(0x426600A0UL))
#define bFM3_GPIO_PFR1_P9                      *((volatile unsigned int*)(0x426600A4UL))
#define bFM3_GPIO_PFR1_PA                      *((volatile unsigned int*)(0x426600A8UL))
#define bFM3_GPIO_PFR1_PB                      *((volatile unsigned int*)(0x426600ACUL))
#define bFM3_GPIO_PFR1_PC                      *((volatile unsigned int*)(0x426600B0UL))
#define bFM3_GPIO_PFR1_PD                      *((volatile unsigned int*)(0x426600B4UL))
#define bFM3_GPIO_PFR1_PE                      *((volatile unsigned int*)(0x426600B8UL))
#define bFM3_GPIO_PFR1_PF                      *((volatile unsigned int*)(0x426600BCUL))
#define bFM3_GPIO_PFR2_P0                      *((volatile unsigned int*)(0x42660100UL))
#define bFM3_GPIO_PFR2_P1                      *((volatile unsigned int*)(0x42660104UL))
#define bFM3_GPIO_PFR2_P2                      *((volatile unsigned int*)(0x42660108UL))
#define bFM3_GPIO_PFR2_P3                      *((volatile unsigned int*)(0x4266010CUL))
#define bFM3_GPIO_PFR2_P4                      *((volatile unsigned int*)(0x42660110UL))
#define bFM3_GPIO_PFR2_P5                      *((volatile unsigned int*)(0x42660114UL))
#define bFM3_GPIO_PFR2_P6                      *((volatile unsigned int*)(0x42660118UL))
#define bFM3_GPIO_PFR2_P7                      *((volatile unsigned int*)(0x4266011CUL))
#define bFM3_GPIO_PFR2_P8                      *((volatile unsigned int*)(0x42660120UL))
#define bFM3_GPIO_PFR2_P9                      *((volatile unsigned int*)(0x42660124UL))
#define bFM3_GPIO_PFR3_P0                      *((volatile unsigned int*)(0x42660180UL))
#define bFM3_GPIO_PFR3_P1                      *((volatile unsigned int*)(0x42660184UL))
#define bFM3_GPIO_PFR3_P2                      *((volatile unsigned int*)(0x42660188UL))
#define bFM3_GPIO_PFR3_P3                      *((volatile unsigned int*)(0x4266018CUL))
#define bFM3_GPIO_PFR3_P4                      *((volatile unsigned int*)(0x42660190UL))
#define bFM3_GPIO_PFR3_P5                      *((volatile unsigned int*)(0x42660194UL))
#define bFM3_GPIO_PFR3_P6                      *((volatile unsigned int*)(0x42660198UL))
#define bFM3_GPIO_PFR3_P7                      *((volatile unsigned int*)(0x4266019CUL))
#define bFM3_GPIO_PFR3_P8                      *((volatile unsigned int*)(0x426601A0UL))
#define bFM3_GPIO_PFR3_P9                      *((volatile unsigned int*)(0x426601A4UL))
#define bFM3_GPIO_PFR3_PA                      *((volatile unsigned int*)(0x426601A8UL))
#define bFM3_GPIO_PFR3_PB                      *((volatile unsigned int*)(0x426601ACUL))
#define bFM3_GPIO_PFR3_PC                      *((volatile unsigned int*)(0x426601B0UL))
#define bFM3_GPIO_PFR3_PD                      *((volatile unsigned int*)(0x426601B4UL))
#define bFM3_GPIO_PFR3_PE                      *((volatile unsigned int*)(0x426601B8UL))
#define bFM3_GPIO_PFR3_PF                      *((volatile unsigned int*)(0x426601BCUL))
#define bFM3_GPIO_PFR4_P0                      *((volatile unsigned int*)(0x42660200UL))
#define bFM3_GPIO_PFR4_P1                      *((volatile unsigned int*)(0x42660204UL))
#define bFM3_GPIO_PFR4_P2                      *((volatile unsigned int*)(0x42660208UL))
#define bFM3_GPIO_PFR4_P3                      *((volatile unsigned int*)(0x4266020CUL))
#define bFM3_GPIO_PFR4_P4                      *((volatile unsigned int*)(0x42660210UL))
#define bFM3_GPIO_PFR4_P5                      *((volatile unsigned int*)(0x42660214UL))
#define bFM3_GPIO_PFR4_P6                      *((volatile unsigned int*)(0x42660218UL))
#define bFM3_GPIO_PFR4_P7                      *((volatile unsigned int*)(0x4266021CUL))
#define bFM3_GPIO_PFR4_P8                      *((volatile unsigned int*)(0x42660220UL))
#define bFM3_GPIO_PFR4_P9                      *((volatile unsigned int*)(0x42660224UL))
#define bFM3_GPIO_PFR4_PA                      *((volatile unsigned int*)(0x42660228UL))
#define bFM3_GPIO_PFR4_PB                      *((volatile unsigned int*)(0x4266022CUL))
#define bFM3_GPIO_PFR4_PC                      *((volatile unsigned int*)(0x42660230UL))
#define bFM3_GPIO_PFR4_PD                      *((volatile unsigned int*)(0x42660234UL))
#define bFM3_GPIO_PFR4_PE                      *((volatile unsigned int*)(0x42660238UL))
#define bFM3_GPIO_PFR5_P0                      *((volatile unsigned int*)(0x42660280UL))
#define bFM3_GPIO_PFR5_P1                      *((volatile unsigned int*)(0x42660284UL))
#define bFM3_GPIO_PFR5_P2                      *((volatile unsigned int*)(0x42660288UL))
#define bFM3_GPIO_PFR5_P3                      *((volatile unsigned int*)(0x4266028CUL))
#define bFM3_GPIO_PFR5_P4                      *((volatile unsigned int*)(0x42660290UL))
#define bFM3_GPIO_PFR5_P5                      *((volatile unsigned int*)(0x42660294UL))
#define bFM3_GPIO_PFR5_P6                      *((volatile unsigned int*)(0x42660298UL))
#define bFM3_GPIO_PFR5_P7                      *((volatile unsigned int*)(0x4266029CUL))
#define bFM3_GPIO_PFR5_P8                      *((volatile unsigned int*)(0x426602A0UL))
#define bFM3_GPIO_PFR5_P9                      *((volatile unsigned int*)(0x426602A4UL))
#define bFM3_GPIO_PFR5_PA                      *((volatile unsigned int*)(0x426602A8UL))
#define bFM3_GPIO_PFR5_PB                      *((volatile unsigned int*)(0x426602ACUL))
#define bFM3_GPIO_PFR5_PC                      *((volatile unsigned int*)(0x426602B0UL))
#define bFM3_GPIO_PFR5_PD                      *((volatile unsigned int*)(0x426602B4UL))
#define bFM3_GPIO_PFR6_P0                      *((volatile unsigned int*)(0x42660300UL))
#define bFM3_GPIO_PFR6_P1                      *((volatile unsigned int*)(0x42660304UL))
#define bFM3_GPIO_PFR6_P2                      *((volatile unsigned int*)(0x42660308UL))
#define bFM3_GPIO_PFR7_P0                      *((volatile unsigned int*)(0x42660380UL))
#define bFM3_GPIO_PFR7_P1                      *((volatile unsigned int*)(0x42660384UL))
#define bFM3_GPIO_PFR7_P2                      *((volatile unsigned int*)(0x42660388UL))
#define bFM3_GPIO_PFR7_P3                      *((volatile unsigned int*)(0x4266038CUL))
#define bFM3_GPIO_PFR7_P4                      *((volatile unsigned int*)(0x42660390UL))
#define bFM3_GPIO_PFR7_P5                      *((volatile unsigned int*)(0x42660394UL))
#define bFM3_GPIO_PFR7_P6                      *((volatile unsigned int*)(0x42660398UL))
#define bFM3_GPIO_PFR7_P7                      *((volatile unsigned int*)(0x4266039CUL))
#define bFM3_GPIO_PFR7_P8                      *((volatile unsigned int*)(0x426603A0UL))
#define bFM3_GPIO_PFR7_P9                      *((volatile unsigned int*)(0x426603A4UL))
#define bFM3_GPIO_PFR7_PA                      *((volatile unsigned int*)(0x426603A8UL))
#define bFM3_GPIO_PFR7_PB                      *((volatile unsigned int*)(0x426603ACUL))
#define bFM3_GPIO_PFR7_PC                      *((volatile unsigned int*)(0x426603B0UL))
#define bFM3_GPIO_PFR7_PD                      *((volatile unsigned int*)(0x426603B4UL))
#define bFM3_GPIO_PFR7_PE                      *((volatile unsigned int*)(0x426603B8UL))
#define bFM3_GPIO_PFR7_PF                      *((volatile unsigned int*)(0x426603BCUL))
#define bFM3_GPIO_PFR8_P0                      *((volatile unsigned int*)(0x42660400UL))
#define bFM3_GPIO_PFR8_P1                      *((volatile unsigned int*)(0x42660404UL))
#define bFM3_GPIO_PFR8_P2                      *((volatile unsigned int*)(0x42660408UL))
#define bFM3_GPIO_PFR8_P3                      *((volatile unsigned int*)(0x4266040CUL))
#define bFM3_GPIO_PFR9_P0                      *((volatile unsigned int*)(0x42660480UL))
#define bFM3_GPIO_PFR9_P1                      *((volatile unsigned int*)(0x42660484UL))
#define bFM3_GPIO_PFR9_P2                      *((volatile unsigned int*)(0x42660488UL))
#define bFM3_GPIO_PFR9_P3                      *((volatile unsigned int*)(0x4266048CUL))
#define bFM3_GPIO_PFR9_P4                      *((volatile unsigned int*)(0x42660490UL))
#define bFM3_GPIO_PFR9_P5                      *((volatile unsigned int*)(0x42660494UL))
#define bFM3_GPIO_PFRA_P0                      *((volatile unsigned int*)(0x42660500UL))
#define bFM3_GPIO_PFRA_P1                      *((volatile unsigned int*)(0x42660504UL))
#define bFM3_GPIO_PFRA_P2                      *((volatile unsigned int*)(0x42660508UL))
#define bFM3_GPIO_PFRA_P3                      *((volatile unsigned int*)(0x4266050CUL))
#define bFM3_GPIO_PFRA_P4                      *((volatile unsigned int*)(0x42660510UL))
#define bFM3_GPIO_PFRA_P5                      *((volatile unsigned int*)(0x42660514UL))
#define bFM3_GPIO_PFRB_P0                      *((volatile unsigned int*)(0x42660580UL))
#define bFM3_GPIO_PFRB_P1                      *((volatile unsigned int*)(0x42660584UL))
#define bFM3_GPIO_PFRB_P2                      *((volatile unsigned int*)(0x42660588UL))
#define bFM3_GPIO_PFRB_P3                      *((volatile unsigned int*)(0x4266058CUL))
#define bFM3_GPIO_PFRB_P4                      *((volatile unsigned int*)(0x42660590UL))
#define bFM3_GPIO_PFRB_P5                      *((volatile unsigned int*)(0x42660594UL))
#define bFM3_GPIO_PFRB_P6                      *((volatile unsigned int*)(0x42660598UL))
#define bFM3_GPIO_PFRB_P7                      *((volatile unsigned int*)(0x4266059CUL))
#define bFM3_GPIO_PFRC_P0                      *((volatile unsigned int*)(0x42660600UL))
#define bFM3_GPIO_PFRC_P1                      *((volatile unsigned int*)(0x42660604UL))
#define bFM3_GPIO_PFRC_P2                      *((volatile unsigned int*)(0x42660608UL))
#define bFM3_GPIO_PFRC_P3                      *((volatile unsigned int*)(0x4266060CUL))
#define bFM3_GPIO_PFRC_P4                      *((volatile unsigned int*)(0x42660610UL))
#define bFM3_GPIO_PFRC_P5                      *((volatile unsigned int*)(0x42660614UL))
#define bFM3_GPIO_PFRC_P6                      *((volatile unsigned int*)(0x42660618UL))
#define bFM3_GPIO_PFRC_P7                      *((volatile unsigned int*)(0x4266061CUL))
#define bFM3_GPIO_PFRC_P8                      *((volatile unsigned int*)(0x42660620UL))
#define bFM3_GPIO_PFRC_P9                      *((volatile unsigned int*)(0x42660624UL))
#define bFM3_GPIO_PFRC_PA                      *((volatile unsigned int*)(0x42660628UL))
#define bFM3_GPIO_PFRC_PB                      *((volatile unsigned int*)(0x4266062CUL))
#define bFM3_GPIO_PFRC_PC                      *((volatile unsigned int*)(0x42660630UL))
#define bFM3_GPIO_PFRC_PD                      *((volatile unsigned int*)(0x42660634UL))
#define bFM3_GPIO_PFRC_PE                      *((volatile unsigned int*)(0x42660638UL))
#define bFM3_GPIO_PFRC_PF                      *((volatile unsigned int*)(0x4266063CUL))
#define bFM3_GPIO_PFRD_P0                      *((volatile unsigned int*)(0x42660680UL))
#define bFM3_GPIO_PFRD_P1                      *((volatile unsigned int*)(0x42660684UL))
#define bFM3_GPIO_PFRD_P2                      *((volatile unsigned int*)(0x42660688UL))
#define bFM3_GPIO_PFRD_P3                      *((volatile unsigned int*)(0x4266068CUL))
#define bFM3_GPIO_PFRE_P0                      *((volatile unsigned int*)(0x42660700UL))
#define bFM3_GPIO_PFRE_P2                      *((volatile unsigned int*)(0x42660708UL))
#define bFM3_GPIO_PFRE_P3                      *((volatile unsigned int*)(0x4266070CUL))
#define bFM3_GPIO_PFRF_P0                      *((volatile unsigned int*)(0x42660780UL))
#define bFM3_GPIO_PFRF_P1                      *((volatile unsigned int*)(0x42660784UL))
#define bFM3_GPIO_PFRF_P2                      *((volatile unsigned int*)(0x42660788UL))
#define bFM3_GPIO_PFRF_P3                      *((volatile unsigned int*)(0x4266078CUL))
#define bFM3_GPIO_PFRF_P4                      *((volatile unsigned int*)(0x42660790UL))
#define bFM3_GPIO_PFRF_P5                      *((volatile unsigned int*)(0x42660794UL))
#define bFM3_GPIO_PFRF_P6                      *((volatile unsigned int*)(0x42660798UL))
#define bFM3_GPIO_PCR0_P0                      *((volatile unsigned int*)(0x42662000UL))
#define bFM3_GPIO_PCR0_P1                      *((volatile unsigned int*)(0x42662004UL))
#define bFM3_GPIO_PCR0_P2                      *((volatile unsigned int*)(0x42662008UL))
#define bFM3_GPIO_PCR0_P3                      *((volatile unsigned int*)(0x4266200CUL))
#define bFM3_GPIO_PCR0_P4                      *((volatile unsigned int*)(0x42662010UL))
#define bFM3_GPIO_PCR0_P5                      *((volatile unsigned int*)(0x42662014UL))
#define bFM3_GPIO_PCR0_P6                      *((volatile unsigned int*)(0x42662018UL))
#define bFM3_GPIO_PCR0_P7                      *((volatile unsigned int*)(0x4266201CUL))
#define bFM3_GPIO_PCR0_P8                      *((volatile unsigned int*)(0x42662020UL))
#define bFM3_GPIO_PCR0_P9                      *((volatile unsigned int*)(0x42662024UL))
#define bFM3_GPIO_PCR1_P0                      *((volatile unsigned int*)(0x42662080UL))
#define bFM3_GPIO_PCR1_P1                      *((volatile unsigned int*)(0x42662084UL))
#define bFM3_GPIO_PCR1_P2                      *((volatile unsigned int*)(0x42662088UL))
#define bFM3_GPIO_PCR1_P3                      *((volatile unsigned int*)(0x4266208CUL))
#define bFM3_GPIO_PCR1_P4                      *((volatile unsigned int*)(0x42662090UL))
#define bFM3_GPIO_PCR1_P5                      *((volatile unsigned int*)(0x42662094UL))
#define bFM3_GPIO_PCR1_P6                      *((volatile unsigned int*)(0x42662098UL))
#define bFM3_GPIO_PCR1_P7                      *((volatile unsigned int*)(0x4266209CUL))
#define bFM3_GPIO_PCR1_P8                      *((volatile unsigned int*)(0x426620A0UL))
#define bFM3_GPIO_PCR1_P9                      *((volatile unsigned int*)(0x426620A4UL))
#define bFM3_GPIO_PCR1_PA                      *((volatile unsigned int*)(0x426620A8UL))
#define bFM3_GPIO_PCR1_PB                      *((volatile unsigned int*)(0x426620ACUL))
#define bFM3_GPIO_PCR1_PC                      *((volatile unsigned int*)(0x426620B0UL))
#define bFM3_GPIO_PCR1_PD                      *((volatile unsigned int*)(0x426620B4UL))
#define bFM3_GPIO_PCR1_PE                      *((volatile unsigned int*)(0x426620B8UL))
#define bFM3_GPIO_PCR1_PF                      *((volatile unsigned int*)(0x426620BCUL))
#define bFM3_GPIO_PCR2_P0                      *((volatile unsigned int*)(0x42662100UL))
#define bFM3_GPIO_PCR2_P1                      *((volatile unsigned int*)(0x42662104UL))
#define bFM3_GPIO_PCR2_P2                      *((volatile unsigned int*)(0x42662108UL))
#define bFM3_GPIO_PCR2_P3                      *((volatile unsigned int*)(0x4266210CUL))
#define bFM3_GPIO_PCR2_P4                      *((volatile unsigned int*)(0x42662110UL))
#define bFM3_GPIO_PCR2_P5                      *((volatile unsigned int*)(0x42662114UL))
#define bFM3_GPIO_PCR2_P6                      *((volatile unsigned int*)(0x42662118UL))
#define bFM3_GPIO_PCR2_P7                      *((volatile unsigned int*)(0x4266211CUL))
#define bFM3_GPIO_PCR2_P8                      *((volatile unsigned int*)(0x42662120UL))
#define bFM3_GPIO_PCR2_P9                      *((volatile unsigned int*)(0x42662124UL))
#define bFM3_GPIO_PCR3_P0                      *((volatile unsigned int*)(0x42662180UL))
#define bFM3_GPIO_PCR3_P1                      *((volatile unsigned int*)(0x42662184UL))
#define bFM3_GPIO_PCR3_P2                      *((volatile unsigned int*)(0x42662188UL))
#define bFM3_GPIO_PCR3_P3                      *((volatile unsigned int*)(0x4266218CUL))
#define bFM3_GPIO_PCR3_P4                      *((volatile unsigned int*)(0x42662190UL))
#define bFM3_GPIO_PCR3_P5                      *((volatile unsigned int*)(0x42662194UL))
#define bFM3_GPIO_PCR3_P6                      *((volatile unsigned int*)(0x42662198UL))
#define bFM3_GPIO_PCR3_P7                      *((volatile unsigned int*)(0x4266219CUL))
#define bFM3_GPIO_PCR3_P8                      *((volatile unsigned int*)(0x426621A0UL))
#define bFM3_GPIO_PCR3_P9                      *((volatile unsigned int*)(0x426621A4UL))
#define bFM3_GPIO_PCR3_PA                      *((volatile unsigned int*)(0x426621A8UL))
#define bFM3_GPIO_PCR3_PB                      *((volatile unsigned int*)(0x426621ACUL))
#define bFM3_GPIO_PCR3_PC                      *((volatile unsigned int*)(0x426621B0UL))
#define bFM3_GPIO_PCR3_PD                      *((volatile unsigned int*)(0x426621B4UL))
#define bFM3_GPIO_PCR3_PE                      *((volatile unsigned int*)(0x426621B8UL))
#define bFM3_GPIO_PCR3_PF                      *((volatile unsigned int*)(0x426621BCUL))
#define bFM3_GPIO_PCR4_P0                      *((volatile unsigned int*)(0x42662200UL))
#define bFM3_GPIO_PCR4_P1                      *((volatile unsigned int*)(0x42662204UL))
#define bFM3_GPIO_PCR4_P2                      *((volatile unsigned int*)(0x42662208UL))
#define bFM3_GPIO_PCR4_P3                      *((volatile unsigned int*)(0x4266220CUL))
#define bFM3_GPIO_PCR4_P4                      *((volatile unsigned int*)(0x42662210UL))
#define bFM3_GPIO_PCR4_P5                      *((volatile unsigned int*)(0x42662214UL))
#define bFM3_GPIO_PCR4_P6                      *((volatile unsigned int*)(0x42662218UL))
#define bFM3_GPIO_PCR4_P7                      *((volatile unsigned int*)(0x4266221CUL))
#define bFM3_GPIO_PCR4_P8                      *((volatile unsigned int*)(0x42662220UL))
#define bFM3_GPIO_PCR4_P9                      *((volatile unsigned int*)(0x42662224UL))
#define bFM3_GPIO_PCR4_PA                      *((volatile unsigned int*)(0x42662228UL))
#define bFM3_GPIO_PCR4_PB                      *((volatile unsigned int*)(0x4266222CUL))
#define bFM3_GPIO_PCR4_PC                      *((volatile unsigned int*)(0x42662230UL))
#define bFM3_GPIO_PCR4_PD                      *((volatile unsigned int*)(0x42662234UL))
#define bFM3_GPIO_PCR4_PE                      *((volatile unsigned int*)(0x42662238UL))
#define bFM3_GPIO_PCR5_P0                      *((volatile unsigned int*)(0x42662280UL))
#define bFM3_GPIO_PCR5_P1                      *((volatile unsigned int*)(0x42662284UL))
#define bFM3_GPIO_PCR5_P2                      *((volatile unsigned int*)(0x42662288UL))
#define bFM3_GPIO_PCR5_P3                      *((volatile unsigned int*)(0x4266228CUL))
#define bFM3_GPIO_PCR5_P4                      *((volatile unsigned int*)(0x42662290UL))
#define bFM3_GPIO_PCR5_P5                      *((volatile unsigned int*)(0x42662294UL))
#define bFM3_GPIO_PCR5_P6                      *((volatile unsigned int*)(0x42662298UL))
#define bFM3_GPIO_PCR5_P7                      *((volatile unsigned int*)(0x4266229CUL))
#define bFM3_GPIO_PCR5_P8                      *((volatile unsigned int*)(0x426622A0UL))
#define bFM3_GPIO_PCR5_P9                      *((volatile unsigned int*)(0x426622A4UL))
#define bFM3_GPIO_PCR5_PA                      *((volatile unsigned int*)(0x426622A8UL))
#define bFM3_GPIO_PCR5_PB                      *((volatile unsigned int*)(0x426622ACUL))
#define bFM3_GPIO_PCR5_PC                      *((volatile unsigned int*)(0x426622B0UL))
#define bFM3_GPIO_PCR5_PD                      *((volatile unsigned int*)(0x426622B4UL))
#define bFM3_GPIO_PCR6_P0                      *((volatile unsigned int*)(0x42662300UL))
#define bFM3_GPIO_PCR6_P1                      *((volatile unsigned int*)(0x42662304UL))
#define bFM3_GPIO_PCR6_P2                      *((volatile unsigned int*)(0x42662308UL))
#define bFM3_GPIO_PCR7_P0                      *((volatile unsigned int*)(0x42662380UL))
#define bFM3_GPIO_PCR7_P1                      *((volatile unsigned int*)(0x42662384UL))
#define bFM3_GPIO_PCR7_P2                      *((volatile unsigned int*)(0x42662388UL))
#define bFM3_GPIO_PCR7_P3                      *((volatile unsigned int*)(0x4266238CUL))
#define bFM3_GPIO_PCR7_P4                      *((volatile unsigned int*)(0x42662390UL))
#define bFM3_GPIO_PCR7_P5                      *((volatile unsigned int*)(0x42662394UL))
#define bFM3_GPIO_PCR7_P6                      *((volatile unsigned int*)(0x42662398UL))
#define bFM3_GPIO_PCR7_P7                      *((volatile unsigned int*)(0x4266239CUL))
#define bFM3_GPIO_PCR7_P8                      *((volatile unsigned int*)(0x426623A0UL))
#define bFM3_GPIO_PCR7_P9                      *((volatile unsigned int*)(0x426623A4UL))
#define bFM3_GPIO_PCR7_PA                      *((volatile unsigned int*)(0x426623A8UL))
#define bFM3_GPIO_PCR7_PB                      *((volatile unsigned int*)(0x426623ACUL))
#define bFM3_GPIO_PCR7_PC                      *((volatile unsigned int*)(0x426623B0UL))
#define bFM3_GPIO_PCR7_PD                      *((volatile unsigned int*)(0x426623B4UL))
#define bFM3_GPIO_PCR7_PE                      *((volatile unsigned int*)(0x426623B8UL))
#define bFM3_GPIO_PCR7_PF                      *((volatile unsigned int*)(0x426623BCUL))
#define bFM3_GPIO_PCR9_P0                      *((volatile unsigned int*)(0x42662480UL))
#define bFM3_GPIO_PCR9_P1                      *((volatile unsigned int*)(0x42662484UL))
#define bFM3_GPIO_PCR9_P2                      *((volatile unsigned int*)(0x42662488UL))
#define bFM3_GPIO_PCR9_P3                      *((volatile unsigned int*)(0x4266248CUL))
#define bFM3_GPIO_PCR9_P4                      *((volatile unsigned int*)(0x42662490UL))
#define bFM3_GPIO_PCR9_P5                      *((volatile unsigned int*)(0x42662494UL))
#define bFM3_GPIO_PCRA_P0                      *((volatile unsigned int*)(0x42662500UL))
#define bFM3_GPIO_PCRA_P1                      *((volatile unsigned int*)(0x42662504UL))
#define bFM3_GPIO_PCRA_P2                      *((volatile unsigned int*)(0x42662508UL))
#define bFM3_GPIO_PCRA_P3                      *((volatile unsigned int*)(0x4266250CUL))
#define bFM3_GPIO_PCRA_P4                      *((volatile unsigned int*)(0x42662510UL))
#define bFM3_GPIO_PCRA_P5                      *((volatile unsigned int*)(0x42662514UL))
#define bFM3_GPIO_PCRB_P0                      *((volatile unsigned int*)(0x42662580UL))
#define bFM3_GPIO_PCRB_P1                      *((volatile unsigned int*)(0x42662584UL))
#define bFM3_GPIO_PCRB_P2                      *((volatile unsigned int*)(0x42662588UL))
#define bFM3_GPIO_PCRB_P3                      *((volatile unsigned int*)(0x4266258CUL))
#define bFM3_GPIO_PCRB_P4                      *((volatile unsigned int*)(0x42662590UL))
#define bFM3_GPIO_PCRB_P5                      *((volatile unsigned int*)(0x42662594UL))
#define bFM3_GPIO_PCRB_P6                      *((volatile unsigned int*)(0x42662598UL))
#define bFM3_GPIO_PCRB_P7                      *((volatile unsigned int*)(0x4266259CUL))
#define bFM3_GPIO_PCRC_P0                      *((volatile unsigned int*)(0x42662600UL))
#define bFM3_GPIO_PCRC_P1                      *((volatile unsigned int*)(0x42662604UL))
#define bFM3_GPIO_PCRC_P2                      *((volatile unsigned int*)(0x42662608UL))
#define bFM3_GPIO_PCRC_P3                      *((volatile unsigned int*)(0x4266260CUL))
#define bFM3_GPIO_PCRC_P4                      *((volatile unsigned int*)(0x42662610UL))
#define bFM3_GPIO_PCRC_P5                      *((volatile unsigned int*)(0x42662614UL))
#define bFM3_GPIO_PCRC_P6                      *((volatile unsigned int*)(0x42662618UL))
#define bFM3_GPIO_PCRC_P7                      *((volatile unsigned int*)(0x4266261CUL))
#define bFM3_GPIO_PCRC_P8                      *((volatile unsigned int*)(0x42662620UL))
#define bFM3_GPIO_PCRC_P9                      *((volatile unsigned int*)(0x42662624UL))
#define bFM3_GPIO_PCRC_PA                      *((volatile unsigned int*)(0x42662628UL))
#define bFM3_GPIO_PCRC_PB                      *((volatile unsigned int*)(0x4266262CUL))
#define bFM3_GPIO_PCRC_PC                      *((volatile unsigned int*)(0x42662630UL))
#define bFM3_GPIO_PCRC_PD                      *((volatile unsigned int*)(0x42662634UL))
#define bFM3_GPIO_PCRC_PE                      *((volatile unsigned int*)(0x42662638UL))
#define bFM3_GPIO_PCRC_PF                      *((volatile unsigned int*)(0x4266263CUL))
#define bFM3_GPIO_PCRD_P0                      *((volatile unsigned int*)(0x42662680UL))
#define bFM3_GPIO_PCRD_P1                      *((volatile unsigned int*)(0x42662684UL))
#define bFM3_GPIO_PCRD_P2                      *((volatile unsigned int*)(0x42662688UL))
#define bFM3_GPIO_PCRD_P3                      *((volatile unsigned int*)(0x4266268CUL))
#define bFM3_GPIO_PCRE_P2                      *((volatile unsigned int*)(0x42662708UL))
#define bFM3_GPIO_PCRE_P3                      *((volatile unsigned int*)(0x4266270CUL))
#define bFM3_GPIO_DDR0_P0                      *((volatile unsigned int*)(0x42664000UL))
#define bFM3_GPIO_DDR0_P1                      *((volatile unsigned int*)(0x42664004UL))
#define bFM3_GPIO_DDR0_P2                      *((volatile unsigned int*)(0x42664008UL))
#define bFM3_GPIO_DDR0_P3                      *((volatile unsigned int*)(0x4266400CUL))
#define bFM3_GPIO_DDR0_P4                      *((volatile unsigned int*)(0x42664010UL))
#define bFM3_GPIO_DDR0_P5                      *((volatile unsigned int*)(0x42664014UL))
#define bFM3_GPIO_DDR0_P6                      *((volatile unsigned int*)(0x42664018UL))
#define bFM3_GPIO_DDR0_P7                      *((volatile unsigned int*)(0x4266401CUL))
#define bFM3_GPIO_DDR0_P8                      *((volatile unsigned int*)(0x42664020UL))
#define bFM3_GPIO_DDR0_P9                      *((volatile unsigned int*)(0x42664024UL))
#define bFM3_GPIO_DDR1_P0                      *((volatile unsigned int*)(0x42664080UL))
#define bFM3_GPIO_DDR1_P1                      *((volatile unsigned int*)(0x42664084UL))
#define bFM3_GPIO_DDR1_P2                      *((volatile unsigned int*)(0x42664088UL))
#define bFM3_GPIO_DDR1_P3                      *((volatile unsigned int*)(0x4266408CUL))
#define bFM3_GPIO_DDR1_P4                      *((volatile unsigned int*)(0x42664090UL))
#define bFM3_GPIO_DDR1_P5                      *((volatile unsigned int*)(0x42664094UL))
#define bFM3_GPIO_DDR1_P6                      *((volatile unsigned int*)(0x42664098UL))
#define bFM3_GPIO_DDR1_P7                      *((volatile unsigned int*)(0x4266409CUL))
#define bFM3_GPIO_DDR1_P8                      *((volatile unsigned int*)(0x426640A0UL))
#define bFM3_GPIO_DDR1_P9                      *((volatile unsigned int*)(0x426640A4UL))
#define bFM3_GPIO_DDR1_PA                      *((volatile unsigned int*)(0x426640A8UL))
#define bFM3_GPIO_DDR1_PB                      *((volatile unsigned int*)(0x426640ACUL))
#define bFM3_GPIO_DDR1_PC                      *((volatile unsigned int*)(0x426640B0UL))
#define bFM3_GPIO_DDR1_PD                      *((volatile unsigned int*)(0x426640B4UL))
#define bFM3_GPIO_DDR1_PE                      *((volatile unsigned int*)(0x426640B8UL))
#define bFM3_GPIO_DDR1_PF                      *((volatile unsigned int*)(0x426640BCUL))
#define bFM3_GPIO_DDR2_P0                      *((volatile unsigned int*)(0x42664100UL))
#define bFM3_GPIO_DDR2_P1                      *((volatile unsigned int*)(0x42664104UL))
#define bFM3_GPIO_DDR2_P2                      *((volatile unsigned int*)(0x42664108UL))
#define bFM3_GPIO_DDR2_P3                      *((volatile unsigned int*)(0x4266410CUL))
#define bFM3_GPIO_DDR2_P4                      *((volatile unsigned int*)(0x42664110UL))
#define bFM3_GPIO_DDR2_P5                      *((volatile unsigned int*)(0x42664114UL))
#define bFM3_GPIO_DDR2_P6                      *((volatile unsigned int*)(0x42664118UL))
#define bFM3_GPIO_DDR2_P7                      *((volatile unsigned int*)(0x4266411CUL))
#define bFM3_GPIO_DDR2_P8                      *((volatile unsigned int*)(0x42664120UL))
#define bFM3_GPIO_DDR2_P9                      *((volatile unsigned int*)(0x42664124UL))
#define bFM3_GPIO_DDR3_P0                      *((volatile unsigned int*)(0x42664180UL))
#define bFM3_GPIO_DDR3_P1                      *((volatile unsigned int*)(0x42664184UL))
#define bFM3_GPIO_DDR3_P2                      *((volatile unsigned int*)(0x42664188UL))
#define bFM3_GPIO_DDR3_P3                      *((volatile unsigned int*)(0x4266418CUL))
#define bFM3_GPIO_DDR3_P4                      *((volatile unsigned int*)(0x42664190UL))
#define bFM3_GPIO_DDR3_P5                      *((volatile unsigned int*)(0x42664194UL))
#define bFM3_GPIO_DDR3_P6                      *((volatile unsigned int*)(0x42664198UL))
#define bFM3_GPIO_DDR3_P7                      *((volatile unsigned int*)(0x4266419CUL))
#define bFM3_GPIO_DDR3_P8                      *((volatile unsigned int*)(0x426641A0UL))
#define bFM3_GPIO_DDR3_P9                      *((volatile unsigned int*)(0x426641A4UL))
#define bFM3_GPIO_DDR3_PA                      *((volatile unsigned int*)(0x426641A8UL))
#define bFM3_GPIO_DDR3_PB                      *((volatile unsigned int*)(0x426641ACUL))
#define bFM3_GPIO_DDR3_PC                      *((volatile unsigned int*)(0x426641B0UL))
#define bFM3_GPIO_DDR3_PD                      *((volatile unsigned int*)(0x426641B4UL))
#define bFM3_GPIO_DDR3_PE                      *((volatile unsigned int*)(0x426641B8UL))
#define bFM3_GPIO_DDR3_PF                      *((volatile unsigned int*)(0x426641BCUL))
#define bFM3_GPIO_DDR4_P0                      *((volatile unsigned int*)(0x42664200UL))
#define bFM3_GPIO_DDR4_P1                      *((volatile unsigned int*)(0x42664204UL))
#define bFM3_GPIO_DDR4_P2                      *((volatile unsigned int*)(0x42664208UL))
#define bFM3_GPIO_DDR4_P3                      *((volatile unsigned int*)(0x4266420CUL))
#define bFM3_GPIO_DDR4_P4                      *((volatile unsigned int*)(0x42664210UL))
#define bFM3_GPIO_DDR4_P5                      *((volatile unsigned int*)(0x42664214UL))
#define bFM3_GPIO_DDR4_P6                      *((volatile unsigned int*)(0x42664218UL))
#define bFM3_GPIO_DDR4_P7                      *((volatile unsigned int*)(0x4266421CUL))
#define bFM3_GPIO_DDR4_P8                      *((volatile unsigned int*)(0x42664220UL))
#define bFM3_GPIO_DDR4_P9                      *((volatile unsigned int*)(0x42664224UL))
#define bFM3_GPIO_DDR4_PA                      *((volatile unsigned int*)(0x42664228UL))
#define bFM3_GPIO_DDR4_PB                      *((volatile unsigned int*)(0x4266422CUL))
#define bFM3_GPIO_DDR4_PC                      *((volatile unsigned int*)(0x42664230UL))
#define bFM3_GPIO_DDR4_PD                      *((volatile unsigned int*)(0x42664234UL))
#define bFM3_GPIO_DDR4_PE                      *((volatile unsigned int*)(0x42664238UL))
#define bFM3_GPIO_DDR5_P0                      *((volatile unsigned int*)(0x42664280UL))
#define bFM3_GPIO_DDR5_P1                      *((volatile unsigned int*)(0x42664284UL))
#define bFM3_GPIO_DDR5_P2                      *((volatile unsigned int*)(0x42664288UL))
#define bFM3_GPIO_DDR5_P3                      *((volatile unsigned int*)(0x4266428CUL))
#define bFM3_GPIO_DDR5_P4                      *((volatile unsigned int*)(0x42664290UL))
#define bFM3_GPIO_DDR5_P5                      *((volatile unsigned int*)(0x42664294UL))
#define bFM3_GPIO_DDR5_P6                      *((volatile unsigned int*)(0x42664298UL))
#define bFM3_GPIO_DDR5_P7                      *((volatile unsigned int*)(0x4266429CUL))
#define bFM3_GPIO_DDR5_P8                      *((volatile unsigned int*)(0x426642A0UL))
#define bFM3_GPIO_DDR5_P9                      *((volatile unsigned int*)(0x426642A4UL))
#define bFM3_GPIO_DDR5_PA                      *((volatile unsigned int*)(0x426642A8UL))
#define bFM3_GPIO_DDR5_PB                      *((volatile unsigned int*)(0x426642ACUL))
#define bFM3_GPIO_DDR5_PC                      *((volatile unsigned int*)(0x426642B0UL))
#define bFM3_GPIO_DDR5_PD                      *((volatile unsigned int*)(0x426642B4UL))
#define bFM3_GPIO_DDR6_P0                      *((volatile unsigned int*)(0x42664300UL))
#define bFM3_GPIO_DDR6_P1                      *((volatile unsigned int*)(0x42664304UL))
#define bFM3_GPIO_DDR6_P2                      *((volatile unsigned int*)(0x42664308UL))
#define bFM3_GPIO_DDR7_P0                      *((volatile unsigned int*)(0x42664380UL))
#define bFM3_GPIO_DDR7_P1                      *((volatile unsigned int*)(0x42664384UL))
#define bFM3_GPIO_DDR7_P2                      *((volatile unsigned int*)(0x42664388UL))
#define bFM3_GPIO_DDR7_P3                      *((volatile unsigned int*)(0x4266438CUL))
#define bFM3_GPIO_DDR7_P4                      *((volatile unsigned int*)(0x42664390UL))
#define bFM3_GPIO_DDR7_P5                      *((volatile unsigned int*)(0x42664394UL))
#define bFM3_GPIO_DDR7_P6                      *((volatile unsigned int*)(0x42664398UL))
#define bFM3_GPIO_DDR7_P7                      *((volatile unsigned int*)(0x4266439CUL))
#define bFM3_GPIO_DDR7_P8                      *((volatile unsigned int*)(0x426643A0UL))
#define bFM3_GPIO_DDR7_P9                      *((volatile unsigned int*)(0x426643A4UL))
#define bFM3_GPIO_DDR7_PA                      *((volatile unsigned int*)(0x426643A8UL))
#define bFM3_GPIO_DDR7_PB                      *((volatile unsigned int*)(0x426643ACUL))
#define bFM3_GPIO_DDR7_PC                      *((volatile unsigned int*)(0x426643B0UL))
#define bFM3_GPIO_DDR7_PD                      *((volatile unsigned int*)(0x426643B4UL))
#define bFM3_GPIO_DDR7_PE                      *((volatile unsigned int*)(0x426643B8UL))
#define bFM3_GPIO_DDR7_PF                      *((volatile unsigned int*)(0x426643BCUL))
#define bFM3_GPIO_DDR8_P0                      *((volatile unsigned int*)(0x42664400UL))
#define bFM3_GPIO_DDR8_P1                      *((volatile unsigned int*)(0x42664404UL))
#define bFM3_GPIO_DDR8_P2                      *((volatile unsigned int*)(0x42664408UL))
#define bFM3_GPIO_DDR8_P3                      *((volatile unsigned int*)(0x4266440CUL))
#define bFM3_GPIO_DDR9_P0                      *((volatile unsigned int*)(0x42664480UL))
#define bFM3_GPIO_DDR9_P1                      *((volatile unsigned int*)(0x42664484UL))
#define bFM3_GPIO_DDR9_P2                      *((volatile unsigned int*)(0x42664488UL))
#define bFM3_GPIO_DDR9_P3                      *((volatile unsigned int*)(0x4266448CUL))
#define bFM3_GPIO_DDR9_P4                      *((volatile unsigned int*)(0x42664490UL))
#define bFM3_GPIO_DDR9_P5                      *((volatile unsigned int*)(0x42664494UL))
#define bFM3_GPIO_DDRA_P0                      *((volatile unsigned int*)(0x42664500UL))
#define bFM3_GPIO_DDRA_P1                      *((volatile unsigned int*)(0x42664504UL))
#define bFM3_GPIO_DDRA_P2                      *((volatile unsigned int*)(0x42664508UL))
#define bFM3_GPIO_DDRA_P3                      *((volatile unsigned int*)(0x4266450CUL))
#define bFM3_GPIO_DDRA_P4                      *((volatile unsigned int*)(0x42664510UL))
#define bFM3_GPIO_DDRA_P5                      *((volatile unsigned int*)(0x42664514UL))
#define bFM3_GPIO_DDRB_P0                      *((volatile unsigned int*)(0x42664580UL))
#define bFM3_GPIO_DDRB_P1                      *((volatile unsigned int*)(0x42664584UL))
#define bFM3_GPIO_DDRB_P2                      *((volatile unsigned int*)(0x42664588UL))
#define bFM3_GPIO_DDRB_P3                      *((volatile unsigned int*)(0x4266458CUL))
#define bFM3_GPIO_DDRB_P4                      *((volatile unsigned int*)(0x42664590UL))
#define bFM3_GPIO_DDRB_P5                      *((volatile unsigned int*)(0x42664594UL))
#define bFM3_GPIO_DDRB_P6                      *((volatile unsigned int*)(0x42664598UL))
#define bFM3_GPIO_DDRB_P7                      *((volatile unsigned int*)(0x4266459CUL))
#define bFM3_GPIO_DDRC_P0                      *((volatile unsigned int*)(0x42664600UL))
#define bFM3_GPIO_DDRC_P1                      *((volatile unsigned int*)(0x42664604UL))
#define bFM3_GPIO_DDRC_P2                      *((volatile unsigned int*)(0x42664608UL))
#define bFM3_GPIO_DDRC_P3                      *((volatile unsigned int*)(0x4266460CUL))
#define bFM3_GPIO_DDRC_P4                      *((volatile unsigned int*)(0x42664610UL))
#define bFM3_GPIO_DDRC_P5                      *((volatile unsigned int*)(0x42664614UL))
#define bFM3_GPIO_DDRC_P6                      *((volatile unsigned int*)(0x42664618UL))
#define bFM3_GPIO_DDRC_P7                      *((volatile unsigned int*)(0x4266461CUL))
#define bFM3_GPIO_DDRC_P8                      *((volatile unsigned int*)(0x42664620UL))
#define bFM3_GPIO_DDRC_P9                      *((volatile unsigned int*)(0x42664624UL))
#define bFM3_GPIO_DDRC_PA                      *((volatile unsigned int*)(0x42664628UL))
#define bFM3_GPIO_DDRC_PB                      *((volatile unsigned int*)(0x4266462CUL))
#define bFM3_GPIO_DDRC_PC                      *((volatile unsigned int*)(0x42664630UL))
#define bFM3_GPIO_DDRC_PD                      *((volatile unsigned int*)(0x42664634UL))
#define bFM3_GPIO_DDRC_PE                      *((volatile unsigned int*)(0x42664638UL))
#define bFM3_GPIO_DDRC_PF                      *((volatile unsigned int*)(0x4266463CUL))
#define bFM3_GPIO_DDRD_P0                      *((volatile unsigned int*)(0x42664680UL))
#define bFM3_GPIO_DDRD_P1                      *((volatile unsigned int*)(0x42664684UL))
#define bFM3_GPIO_DDRD_P2                      *((volatile unsigned int*)(0x42664688UL))
#define bFM3_GPIO_DDRD_P3                      *((volatile unsigned int*)(0x4266468CUL))
#define bFM3_GPIO_DDRE_P0                      *((volatile unsigned int*)(0x42664700UL))
#define bFM3_GPIO_DDRE_P2                      *((volatile unsigned int*)(0x42664708UL))
#define bFM3_GPIO_DDRE_P3                      *((volatile unsigned int*)(0x4266470CUL))
#define bFM3_GPIO_DDRF_P0                      *((volatile unsigned int*)(0x42664780UL))
#define bFM3_GPIO_DDRF_P1                      *((volatile unsigned int*)(0x42664784UL))
#define bFM3_GPIO_DDRF_P2                      *((volatile unsigned int*)(0x42664788UL))
#define bFM3_GPIO_DDRF_P3                      *((volatile unsigned int*)(0x4266478CUL))
#define bFM3_GPIO_DDRF_P4                      *((volatile unsigned int*)(0x42664790UL))
#define bFM3_GPIO_DDRF_P5                      *((volatile unsigned int*)(0x42664794UL))
#define bFM3_GPIO_DDRF_P6                      *((volatile unsigned int*)(0x42664798UL))
#define bFM3_GPIO_PDIR0_P0                     *((volatile unsigned int*)(0x42666000UL))
#define bFM3_GPIO_PDIR0_P1                     *((volatile unsigned int*)(0x42666004UL))
#define bFM3_GPIO_PDIR0_P2                     *((volatile unsigned int*)(0x42666008UL))
#define bFM3_GPIO_PDIR0_P3                     *((volatile unsigned int*)(0x4266600CUL))
#define bFM3_GPIO_PDIR0_P4                     *((volatile unsigned int*)(0x42666010UL))
#define bFM3_GPIO_PDIR0_P5                     *((volatile unsigned int*)(0x42666014UL))
#define bFM3_GPIO_PDIR0_P6                     *((volatile unsigned int*)(0x42666018UL))
#define bFM3_GPIO_PDIR0_P7                     *((volatile unsigned int*)(0x4266601CUL))
#define bFM3_GPIO_PDIR0_P8                     *((volatile unsigned int*)(0x42666020UL))
#define bFM3_GPIO_PDIR0_P9                     *((volatile unsigned int*)(0x42666024UL))
#define bFM3_GPIO_PDIR1_P0                     *((volatile unsigned int*)(0x42666080UL))
#define bFM3_GPIO_PDIR1_P1                     *((volatile unsigned int*)(0x42666084UL))
#define bFM3_GPIO_PDIR1_P2                     *((volatile unsigned int*)(0x42666088UL))
#define bFM3_GPIO_PDIR1_P3                     *((volatile unsigned int*)(0x4266608CUL))
#define bFM3_GPIO_PDIR1_P4                     *((volatile unsigned int*)(0x42666090UL))
#define bFM3_GPIO_PDIR1_P5                     *((volatile unsigned int*)(0x42666094UL))
#define bFM3_GPIO_PDIR1_P6                     *((volatile unsigned int*)(0x42666098UL))
#define bFM3_GPIO_PDIR1_P7                     *((volatile unsigned int*)(0x4266609CUL))
#define bFM3_GPIO_PDIR1_P8                     *((volatile unsigned int*)(0x426660A0UL))
#define bFM3_GPIO_PDIR1_P9                     *((volatile unsigned int*)(0x426660A4UL))
#define bFM3_GPIO_PDIR1_PA                     *((volatile unsigned int*)(0x426660A8UL))
#define bFM3_GPIO_PDIR1_PB                     *((volatile unsigned int*)(0x426660ACUL))
#define bFM3_GPIO_PDIR1_PC                     *((volatile unsigned int*)(0x426660B0UL))
#define bFM3_GPIO_PDIR1_PD                     *((volatile unsigned int*)(0x426660B4UL))
#define bFM3_GPIO_PDIR1_PE                     *((volatile unsigned int*)(0x426660B8UL))
#define bFM3_GPIO_PDIR1_PF                     *((volatile unsigned int*)(0x426660BCUL))
#define bFM3_GPIO_PDIR2_P0                     *((volatile unsigned int*)(0x42666100UL))
#define bFM3_GPIO_PDIR2_P1                     *((volatile unsigned int*)(0x42666104UL))
#define bFM3_GPIO_PDIR2_P2                     *((volatile unsigned int*)(0x42666108UL))
#define bFM3_GPIO_PDIR2_P3                     *((volatile unsigned int*)(0x4266610CUL))
#define bFM3_GPIO_PDIR2_P4                     *((volatile unsigned int*)(0x42666110UL))
#define bFM3_GPIO_PDIR2_P5                     *((volatile unsigned int*)(0x42666114UL))
#define bFM3_GPIO_PDIR2_P6                     *((volatile unsigned int*)(0x42666118UL))
#define bFM3_GPIO_PDIR2_P7                     *((volatile unsigned int*)(0x4266611CUL))
#define bFM3_GPIO_PDIR2_P8                     *((volatile unsigned int*)(0x42666120UL))
#define bFM3_GPIO_PDIR2_P9                     *((volatile unsigned int*)(0x42666124UL))
#define bFM3_GPIO_PDIR3_P0                     *((volatile unsigned int*)(0x42666180UL))
#define bFM3_GPIO_PDIR3_P1                     *((volatile unsigned int*)(0x42666184UL))
#define bFM3_GPIO_PDIR3_P2                     *((volatile unsigned int*)(0x42666188UL))
#define bFM3_GPIO_PDIR3_P3                     *((volatile unsigned int*)(0x4266618CUL))
#define bFM3_GPIO_PDIR3_P4                     *((volatile unsigned int*)(0x42666190UL))
#define bFM3_GPIO_PDIR3_P5                     *((volatile unsigned int*)(0x42666194UL))
#define bFM3_GPIO_PDIR3_P6                     *((volatile unsigned int*)(0x42666198UL))
#define bFM3_GPIO_PDIR3_P7                     *((volatile unsigned int*)(0x4266619CUL))
#define bFM3_GPIO_PDIR3_P8                     *((volatile unsigned int*)(0x426661A0UL))
#define bFM3_GPIO_PDIR3_P9                     *((volatile unsigned int*)(0x426661A4UL))
#define bFM3_GPIO_PDIR3_PA                     *((volatile unsigned int*)(0x426661A8UL))
#define bFM3_GPIO_PDIR3_PB                     *((volatile unsigned int*)(0x426661ACUL))
#define bFM3_GPIO_PDIR3_PC                     *((volatile unsigned int*)(0x426661B0UL))
#define bFM3_GPIO_PDIR3_PD                     *((volatile unsigned int*)(0x426661B4UL))
#define bFM3_GPIO_PDIR3_PE                     *((volatile unsigned int*)(0x426661B8UL))
#define bFM3_GPIO_PDIR3_PF                     *((volatile unsigned int*)(0x426661BCUL))
#define bFM3_GPIO_PDIR4_P0                     *((volatile unsigned int*)(0x42666200UL))
#define bFM3_GPIO_PDIR4_P1                     *((volatile unsigned int*)(0x42666204UL))
#define bFM3_GPIO_PDIR4_P2                     *((volatile unsigned int*)(0x42666208UL))
#define bFM3_GPIO_PDIR4_P3                     *((volatile unsigned int*)(0x4266620CUL))
#define bFM3_GPIO_PDIR4_P4                     *((volatile unsigned int*)(0x42666210UL))
#define bFM3_GPIO_PDIR4_P5                     *((volatile unsigned int*)(0x42666214UL))
#define bFM3_GPIO_PDIR4_P6                     *((volatile unsigned int*)(0x42666218UL))
#define bFM3_GPIO_PDIR4_P7                     *((volatile unsigned int*)(0x4266621CUL))
#define bFM3_GPIO_PDIR4_P8                     *((volatile unsigned int*)(0x42666220UL))
#define bFM3_GPIO_PDIR4_P9                     *((volatile unsigned int*)(0x42666224UL))
#define bFM3_GPIO_PDIR4_PA                     *((volatile unsigned int*)(0x42666228UL))
#define bFM3_GPIO_PDIR4_PB                     *((volatile unsigned int*)(0x4266622CUL))
#define bFM3_GPIO_PDIR4_PC                     *((volatile unsigned int*)(0x42666230UL))
#define bFM3_GPIO_PDIR4_PD                     *((volatile unsigned int*)(0x42666234UL))
#define bFM3_GPIO_PDIR4_PE                     *((volatile unsigned int*)(0x42666238UL))
#define bFM3_GPIO_PDIR5_P0                     *((volatile unsigned int*)(0x42666280UL))
#define bFM3_GPIO_PDIR5_P1                     *((volatile unsigned int*)(0x42666284UL))
#define bFM3_GPIO_PDIR5_P2                     *((volatile unsigned int*)(0x42666288UL))
#define bFM3_GPIO_PDIR5_P3                     *((volatile unsigned int*)(0x4266628CUL))
#define bFM3_GPIO_PDIR5_P4                     *((volatile unsigned int*)(0x42666290UL))
#define bFM3_GPIO_PDIR5_P5                     *((volatile unsigned int*)(0x42666294UL))
#define bFM3_GPIO_PDIR5_P6                     *((volatile unsigned int*)(0x42666298UL))
#define bFM3_GPIO_PDIR5_P7                     *((volatile unsigned int*)(0x4266629CUL))
#define bFM3_GPIO_PDIR5_P8                     *((volatile unsigned int*)(0x426662A0UL))
#define bFM3_GPIO_PDIR5_P9                     *((volatile unsigned int*)(0x426662A4UL))
#define bFM3_GPIO_PDIR5_PA                     *((volatile unsigned int*)(0x426662A8UL))
#define bFM3_GPIO_PDIR5_PB                     *((volatile unsigned int*)(0x426662ACUL))
#define bFM3_GPIO_PDIR5_PC                     *((volatile unsigned int*)(0x426662B0UL))
#define bFM3_GPIO_PDIR5_PD                     *((volatile unsigned int*)(0x426662B4UL))
#define bFM3_GPIO_PDIR6_P0                     *((volatile unsigned int*)(0x42666300UL))
#define bFM3_GPIO_PDIR6_P1                     *((volatile unsigned int*)(0x42666304UL))
#define bFM3_GPIO_PDIR6_P2                     *((volatile unsigned int*)(0x42666308UL))
#define bFM3_GPIO_PDIR7_P0                     *((volatile unsigned int*)(0x42666380UL))
#define bFM3_GPIO_PDIR7_P1                     *((volatile unsigned int*)(0x42666384UL))
#define bFM3_GPIO_PDIR7_P2                     *((volatile unsigned int*)(0x42666388UL))
#define bFM3_GPIO_PDIR7_P3                     *((volatile unsigned int*)(0x4266638CUL))
#define bFM3_GPIO_PDIR7_P4                     *((volatile unsigned int*)(0x42666390UL))
#define bFM3_GPIO_PDIR7_P5                     *((volatile unsigned int*)(0x42666394UL))
#define bFM3_GPIO_PDIR7_P6                     *((volatile unsigned int*)(0x42666398UL))
#define bFM3_GPIO_PDIR7_P7                     *((volatile unsigned int*)(0x4266639CUL))
#define bFM3_GPIO_PDIR7_P8                     *((volatile unsigned int*)(0x426663A0UL))
#define bFM3_GPIO_PDIR7_P9                     *((volatile unsigned int*)(0x426663A4UL))
#define bFM3_GPIO_PDIR7_PA                     *((volatile unsigned int*)(0x426663A8UL))
#define bFM3_GPIO_PDIR7_PB                     *((volatile unsigned int*)(0x426663ACUL))
#define bFM3_GPIO_PDIR7_PC                     *((volatile unsigned int*)(0x426663B0UL))
#define bFM3_GPIO_PDIR7_PD                     *((volatile unsigned int*)(0x426663B4UL))
#define bFM3_GPIO_PDIR7_PE                     *((volatile unsigned int*)(0x426663B8UL))
#define bFM3_GPIO_PDIR7_PF                     *((volatile unsigned int*)(0x426663BCUL))
#define bFM3_GPIO_PDIR8_P0                     *((volatile unsigned int*)(0x42666400UL))
#define bFM3_GPIO_PDIR8_P1                     *((volatile unsigned int*)(0x42666404UL))
#define bFM3_GPIO_PDIR8_P2                     *((volatile unsigned int*)(0x42666408UL))
#define bFM3_GPIO_PDIR8_P3                     *((volatile unsigned int*)(0x4266640CUL))
#define bFM3_GPIO_PDIR9_P0                     *((volatile unsigned int*)(0x42666480UL))
#define bFM3_GPIO_PDIR9_P1                     *((volatile unsigned int*)(0x42666484UL))
#define bFM3_GPIO_PDIR9_P2                     *((volatile unsigned int*)(0x42666488UL))
#define bFM3_GPIO_PDIR9_P3                     *((volatile unsigned int*)(0x4266648CUL))
#define bFM3_GPIO_PDIR9_P4                     *((volatile unsigned int*)(0x42666490UL))
#define bFM3_GPIO_PDIR9_P5                     *((volatile unsigned int*)(0x42666494UL))
#define bFM3_GPIO_PDIRA_P0                     *((volatile unsigned int*)(0x42666500UL))
#define bFM3_GPIO_PDIRA_P1                     *((volatile unsigned int*)(0x42666504UL))
#define bFM3_GPIO_PDIRA_P2                     *((volatile unsigned int*)(0x42666508UL))
#define bFM3_GPIO_PDIRA_P3                     *((volatile unsigned int*)(0x4266650CUL))
#define bFM3_GPIO_PDIRA_P4                     *((volatile unsigned int*)(0x42666510UL))
#define bFM3_GPIO_PDIRA_P5                     *((volatile unsigned int*)(0x42666514UL))
#define bFM3_GPIO_PDIRB_P0                     *((volatile unsigned int*)(0x42666580UL))
#define bFM3_GPIO_PDIRB_P1                     *((volatile unsigned int*)(0x42666584UL))
#define bFM3_GPIO_PDIRB_P2                     *((volatile unsigned int*)(0x42666588UL))
#define bFM3_GPIO_PDIRB_P3                     *((volatile unsigned int*)(0x4266658CUL))
#define bFM3_GPIO_PDIRB_P4                     *((volatile unsigned int*)(0x42666590UL))
#define bFM3_GPIO_PDIRB_P5                     *((volatile unsigned int*)(0x42666594UL))
#define bFM3_GPIO_PDIRB_P6                     *((volatile unsigned int*)(0x42666598UL))
#define bFM3_GPIO_PDIRB_P7                     *((volatile unsigned int*)(0x4266659CUL))
#define bFM3_GPIO_PDIRC_P0                     *((volatile unsigned int*)(0x42666600UL))
#define bFM3_GPIO_PDIRC_P1                     *((volatile unsigned int*)(0x42666604UL))
#define bFM3_GPIO_PDIRC_P2                     *((volatile unsigned int*)(0x42666608UL))
#define bFM3_GPIO_PDIRC_P3                     *((volatile unsigned int*)(0x4266660CUL))
#define bFM3_GPIO_PDIRC_P4                     *((volatile unsigned int*)(0x42666610UL))
#define bFM3_GPIO_PDIRC_P5                     *((volatile unsigned int*)(0x42666614UL))
#define bFM3_GPIO_PDIRC_P6                     *((volatile unsigned int*)(0x42666618UL))
#define bFM3_GPIO_PDIRC_P7                     *((volatile unsigned int*)(0x4266661CUL))
#define bFM3_GPIO_PDIRC_P8                     *((volatile unsigned int*)(0x42666620UL))
#define bFM3_GPIO_PDIRC_P9                     *((volatile unsigned int*)(0x42666624UL))
#define bFM3_GPIO_PDIRC_PA                     *((volatile unsigned int*)(0x42666628UL))
#define bFM3_GPIO_PDIRC_PB                     *((volatile unsigned int*)(0x4266662CUL))
#define bFM3_GPIO_PDIRC_PC                     *((volatile unsigned int*)(0x42666630UL))
#define bFM3_GPIO_PDIRC_PD                     *((volatile unsigned int*)(0x42666634UL))
#define bFM3_GPIO_PDIRC_PE                     *((volatile unsigned int*)(0x42666638UL))
#define bFM3_GPIO_PDIRC_PF                     *((volatile unsigned int*)(0x4266663CUL))
#define bFM3_GPIO_PDIRD_P0                     *((volatile unsigned int*)(0x42666680UL))
#define bFM3_GPIO_PDIRD_P1                     *((volatile unsigned int*)(0x42666684UL))
#define bFM3_GPIO_PDIRD_P2                     *((volatile unsigned int*)(0x42666688UL))
#define bFM3_GPIO_PDIRD_P3                     *((volatile unsigned int*)(0x4266668CUL))
#define bFM3_GPIO_PDIRE_P0                     *((volatile unsigned int*)(0x42666700UL))
#define bFM3_GPIO_PDIRE_P2                     *((volatile unsigned int*)(0x42666708UL))
#define bFM3_GPIO_PDIRE_P3                     *((volatile unsigned int*)(0x4266670CUL))
#define bFM3_GPIO_PDIRF_P0                     *((volatile unsigned int*)(0x42666780UL))
#define bFM3_GPIO_PDIRF_P1                     *((volatile unsigned int*)(0x42666784UL))
#define bFM3_GPIO_PDIRF_P2                     *((volatile unsigned int*)(0x42666788UL))
#define bFM3_GPIO_PDIRF_P3                     *((volatile unsigned int*)(0x4266678CUL))
#define bFM3_GPIO_PDIRF_P4                     *((volatile unsigned int*)(0x42666790UL))
#define bFM3_GPIO_PDIRF_P5                     *((volatile unsigned int*)(0x42666794UL))
#define bFM3_GPIO_PDIRF_P6                     *((volatile unsigned int*)(0x42666798UL))
#define bFM3_GPIO_PDOR0_P0                     *((volatile unsigned int*)(0x42668000UL))
#define bFM3_GPIO_PDOR0_P1                     *((volatile unsigned int*)(0x42668004UL))
#define bFM3_GPIO_PDOR0_P2                     *((volatile unsigned int*)(0x42668008UL))
#define bFM3_GPIO_PDOR0_P3                     *((volatile unsigned int*)(0x4266800CUL))
#define bFM3_GPIO_PDOR0_P4                     *((volatile unsigned int*)(0x42668010UL))
#define bFM3_GPIO_PDOR0_P5                     *((volatile unsigned int*)(0x42668014UL))
#define bFM3_GPIO_PDOR0_P6                     *((volatile unsigned int*)(0x42668018UL))
#define bFM3_GPIO_PDOR0_P7                     *((volatile unsigned int*)(0x4266801CUL))
#define bFM3_GPIO_PDOR0_P8                     *((volatile unsigned int*)(0x42668020UL))
#define bFM3_GPIO_PDOR0_P9                     *((volatile unsigned int*)(0x42668024UL))
#define bFM3_GPIO_PDOR1_P0                     *((volatile unsigned int*)(0x42668080UL))
#define bFM3_GPIO_PDOR1_P1                     *((volatile unsigned int*)(0x42668084UL))
#define bFM3_GPIO_PDOR1_P2                     *((volatile unsigned int*)(0x42668088UL))
#define bFM3_GPIO_PDOR1_P3                     *((volatile unsigned int*)(0x4266808CUL))
#define bFM3_GPIO_PDOR1_P4                     *((volatile unsigned int*)(0x42668090UL))
#define bFM3_GPIO_PDOR1_P5                     *((volatile unsigned int*)(0x42668094UL))
#define bFM3_GPIO_PDOR1_P6                     *((volatile unsigned int*)(0x42668098UL))
#define bFM3_GPIO_PDOR1_P7                     *((volatile unsigned int*)(0x4266809CUL))
#define bFM3_GPIO_PDOR1_P8                     *((volatile unsigned int*)(0x426680A0UL))
#define bFM3_GPIO_PDOR1_P9                     *((volatile unsigned int*)(0x426680A4UL))
#define bFM3_GPIO_PDOR1_PA                     *((volatile unsigned int*)(0x426680A8UL))
#define bFM3_GPIO_PDOR1_PB                     *((volatile unsigned int*)(0x426680ACUL))
#define bFM3_GPIO_PDOR1_PC                     *((volatile unsigned int*)(0x426680B0UL))
#define bFM3_GPIO_PDOR1_PD                     *((volatile unsigned int*)(0x426680B4UL))
#define bFM3_GPIO_PDOR1_PE                     *((volatile unsigned int*)(0x426680B8UL))
#define bFM3_GPIO_PDOR1_PF                     *((volatile unsigned int*)(0x426680BCUL))
#define bFM3_GPIO_PDOR2_P0                     *((volatile unsigned int*)(0x42668100UL))
#define bFM3_GPIO_PDOR2_P1                     *((volatile unsigned int*)(0x42668104UL))
#define bFM3_GPIO_PDOR2_P2                     *((volatile unsigned int*)(0x42668108UL))
#define bFM3_GPIO_PDOR2_P3                     *((volatile unsigned int*)(0x4266810CUL))
#define bFM3_GPIO_PDOR2_P4                     *((volatile unsigned int*)(0x42668110UL))
#define bFM3_GPIO_PDOR2_P5                     *((volatile unsigned int*)(0x42668114UL))
#define bFM3_GPIO_PDOR2_P6                     *((volatile unsigned int*)(0x42668118UL))
#define bFM3_GPIO_PDOR2_P7                     *((volatile unsigned int*)(0x4266811CUL))
#define bFM3_GPIO_PDOR2_P8                     *((volatile unsigned int*)(0x42668120UL))
#define bFM3_GPIO_PDOR2_P9                     *((volatile unsigned int*)(0x42668124UL))
#define bFM3_GPIO_PDOR3_P0                     *((volatile unsigned int*)(0x42668180UL))
#define bFM3_GPIO_PDOR3_P1                     *((volatile unsigned int*)(0x42668184UL))
#define bFM3_GPIO_PDOR3_P2                     *((volatile unsigned int*)(0x42668188UL))
#define bFM3_GPIO_PDOR3_P3                     *((volatile unsigned int*)(0x4266818CUL))
#define bFM3_GPIO_PDOR3_P4                     *((volatile unsigned int*)(0x42668190UL))
#define bFM3_GPIO_PDOR3_P5                     *((volatile unsigned int*)(0x42668194UL))
#define bFM3_GPIO_PDOR3_P6                     *((volatile unsigned int*)(0x42668198UL))
#define bFM3_GPIO_PDOR3_P7                     *((volatile unsigned int*)(0x4266819CUL))
#define bFM3_GPIO_PDOR3_P8                     *((volatile unsigned int*)(0x426681A0UL))
#define bFM3_GPIO_PDOR3_P9                     *((volatile unsigned int*)(0x426681A4UL))
#define bFM3_GPIO_PDOR3_PA                     *((volatile unsigned int*)(0x426681A8UL))
#define bFM3_GPIO_PDOR3_PB                     *((volatile unsigned int*)(0x426681ACUL))
#define bFM3_GPIO_PDOR3_PC                     *((volatile unsigned int*)(0x426681B0UL))
#define bFM3_GPIO_PDOR3_PD                     *((volatile unsigned int*)(0x426681B4UL))
#define bFM3_GPIO_PDOR3_PE                     *((volatile unsigned int*)(0x426681B8UL))
#define bFM3_GPIO_PDOR3_PF                     *((volatile unsigned int*)(0x426681BCUL))
#define bFM3_GPIO_PDOR4_P0                     *((volatile unsigned int*)(0x42668200UL))
#define bFM3_GPIO_PDOR4_P1                     *((volatile unsigned int*)(0x42668204UL))
#define bFM3_GPIO_PDOR4_P2                     *((volatile unsigned int*)(0x42668208UL))
#define bFM3_GPIO_PDOR4_P3                     *((volatile unsigned int*)(0x4266820CUL))
#define bFM3_GPIO_PDOR4_P4                     *((volatile unsigned int*)(0x42668210UL))
#define bFM3_GPIO_PDOR4_P5                     *((volatile unsigned int*)(0x42668214UL))
#define bFM3_GPIO_PDOR4_P6                     *((volatile unsigned int*)(0x42668218UL))
#define bFM3_GPIO_PDOR4_P7                     *((volatile unsigned int*)(0x4266821CUL))
#define bFM3_GPIO_PDOR4_P8                     *((volatile unsigned int*)(0x42668220UL))
#define bFM3_GPIO_PDOR4_P9                     *((volatile unsigned int*)(0x42668224UL))
#define bFM3_GPIO_PDOR4_PA                     *((volatile unsigned int*)(0x42668228UL))
#define bFM3_GPIO_PDOR4_PB                     *((volatile unsigned int*)(0x4266822CUL))
#define bFM3_GPIO_PDOR4_PC                     *((volatile unsigned int*)(0x42668230UL))
#define bFM3_GPIO_PDOR4_PD                     *((volatile unsigned int*)(0x42668234UL))
#define bFM3_GPIO_PDOR4_PE                     *((volatile unsigned int*)(0x42668238UL))
#define bFM3_GPIO_PDOR5_P0                     *((volatile unsigned int*)(0x42668280UL))
#define bFM3_GPIO_PDOR5_P1                     *((volatile unsigned int*)(0x42668284UL))
#define bFM3_GPIO_PDOR5_P2                     *((volatile unsigned int*)(0x42668288UL))
#define bFM3_GPIO_PDOR5_P3                     *((volatile unsigned int*)(0x4266828CUL))
#define bFM3_GPIO_PDOR5_P4                     *((volatile unsigned int*)(0x42668290UL))
#define bFM3_GPIO_PDOR5_P5                     *((volatile unsigned int*)(0x42668294UL))
#define bFM3_GPIO_PDOR5_P6                     *((volatile unsigned int*)(0x42668298UL))
#define bFM3_GPIO_PDOR5_P7                     *((volatile unsigned int*)(0x4266829CUL))
#define bFM3_GPIO_PDOR5_P8                     *((volatile unsigned int*)(0x426682A0UL))
#define bFM3_GPIO_PDOR5_P9                     *((volatile unsigned int*)(0x426682A4UL))
#define bFM3_GPIO_PDOR5_PA                     *((volatile unsigned int*)(0x426682A8UL))
#define bFM3_GPIO_PDOR5_PB                     *((volatile unsigned int*)(0x426682ACUL))
#define bFM3_GPIO_PDOR5_PC                     *((volatile unsigned int*)(0x426682B0UL))
#define bFM3_GPIO_PDOR5_PD                     *((volatile unsigned int*)(0x426682B4UL))
#define bFM3_GPIO_PDOR6_P0                     *((volatile unsigned int*)(0x42668300UL))
#define bFM3_GPIO_PDOR6_P1                     *((volatile unsigned int*)(0x42668304UL))
#define bFM3_GPIO_PDOR6_P2                     *((volatile unsigned int*)(0x42668308UL))
#define bFM3_GPIO_PDOR7_P0                     *((volatile unsigned int*)(0x42668380UL))
#define bFM3_GPIO_PDOR7_P1                     *((volatile unsigned int*)(0x42668384UL))
#define bFM3_GPIO_PDOR7_P2                     *((volatile unsigned int*)(0x42668388UL))
#define bFM3_GPIO_PDOR7_P3                     *((volatile unsigned int*)(0x4266838CUL))
#define bFM3_GPIO_PDOR7_P4                     *((volatile unsigned int*)(0x42668390UL))
#define bFM3_GPIO_PDOR7_P5                     *((volatile unsigned int*)(0x42668394UL))
#define bFM3_GPIO_PDOR7_P6                     *((volatile unsigned int*)(0x42668398UL))
#define bFM3_GPIO_PDOR7_P7                     *((volatile unsigned int*)(0x4266839CUL))
#define bFM3_GPIO_PDOR7_P8                     *((volatile unsigned int*)(0x426683A0UL))
#define bFM3_GPIO_PDOR7_P9                     *((volatile unsigned int*)(0x426683A4UL))
#define bFM3_GPIO_PDOR7_PA                     *((volatile unsigned int*)(0x426683A8UL))
#define bFM3_GPIO_PDOR7_PB                     *((volatile unsigned int*)(0x426683ACUL))
#define bFM3_GPIO_PDOR7_PC                     *((volatile unsigned int*)(0x426683B0UL))
#define bFM3_GPIO_PDOR7_PD                     *((volatile unsigned int*)(0x426683B4UL))
#define bFM3_GPIO_PDOR7_PE                     *((volatile unsigned int*)(0x426683B8UL))
#define bFM3_GPIO_PDOR7_PF                     *((volatile unsigned int*)(0x426683BCUL))
#define bFM3_GPIO_PDOR8_P0                     *((volatile unsigned int*)(0x42668400UL))
#define bFM3_GPIO_PDOR8_P1                     *((volatile unsigned int*)(0x42668404UL))
#define bFM3_GPIO_PDOR8_P2                     *((volatile unsigned int*)(0x42668408UL))
#define bFM3_GPIO_PDOR8_P3                     *((volatile unsigned int*)(0x4266840CUL))
#define bFM3_GPIO_PDOR9_P0                     *((volatile unsigned int*)(0x42668480UL))
#define bFM3_GPIO_PDOR9_P1                     *((volatile unsigned int*)(0x42668484UL))
#define bFM3_GPIO_PDOR9_P2                     *((volatile unsigned int*)(0x42668488UL))
#define bFM3_GPIO_PDOR9_P3                     *((volatile unsigned int*)(0x4266848CUL))
#define bFM3_GPIO_PDOR9_P4                     *((volatile unsigned int*)(0x42668490UL))
#define bFM3_GPIO_PDOR9_P5                     *((volatile unsigned int*)(0x42668494UL))
#define bFM3_GPIO_PDORA_P0                     *((volatile unsigned int*)(0x42668500UL))
#define bFM3_GPIO_PDORA_P1                     *((volatile unsigned int*)(0x42668504UL))
#define bFM3_GPIO_PDORA_P2                     *((volatile unsigned int*)(0x42668508UL))
#define bFM3_GPIO_PDORA_P3                     *((volatile unsigned int*)(0x4266850CUL))
#define bFM3_GPIO_PDORA_P4                     *((volatile unsigned int*)(0x42668510UL))
#define bFM3_GPIO_PDORA_P5                     *((volatile unsigned int*)(0x42668514UL))
#define bFM3_GPIO_PDORB_P0                     *((volatile unsigned int*)(0x42668580UL))
#define bFM3_GPIO_PDORB_P1                     *((volatile unsigned int*)(0x42668584UL))
#define bFM3_GPIO_PDORB_P2                     *((volatile unsigned int*)(0x42668588UL))
#define bFM3_GPIO_PDORB_P3                     *((volatile unsigned int*)(0x4266858CUL))
#define bFM3_GPIO_PDORB_P4                     *((volatile unsigned int*)(0x42668590UL))
#define bFM3_GPIO_PDORB_P5                     *((volatile unsigned int*)(0x42668594UL))
#define bFM3_GPIO_PDORB_P6                     *((volatile unsigned int*)(0x42668598UL))
#define bFM3_GPIO_PDORB_P7                     *((volatile unsigned int*)(0x4266859CUL))
#define bFM3_GPIO_PDORC_P0                     *((volatile unsigned int*)(0x42668600UL))
#define bFM3_GPIO_PDORC_P1                     *((volatile unsigned int*)(0x42668604UL))
#define bFM3_GPIO_PDORC_P2                     *((volatile unsigned int*)(0x42668608UL))
#define bFM3_GPIO_PDORC_P3                     *((volatile unsigned int*)(0x4266860CUL))
#define bFM3_GPIO_PDORC_P4                     *((volatile unsigned int*)(0x42668610UL))
#define bFM3_GPIO_PDORC_P5                     *((volatile unsigned int*)(0x42668614UL))
#define bFM3_GPIO_PDORC_P6                     *((volatile unsigned int*)(0x42668618UL))
#define bFM3_GPIO_PDORC_P7                     *((volatile unsigned int*)(0x4266861CUL))
#define bFM3_GPIO_PDORC_P8                     *((volatile unsigned int*)(0x42668620UL))
#define bFM3_GPIO_PDORC_P9                     *((volatile unsigned int*)(0x42668624UL))
#define bFM3_GPIO_PDORC_PA                     *((volatile unsigned int*)(0x42668628UL))
#define bFM3_GPIO_PDORC_PB                     *((volatile unsigned int*)(0x4266862CUL))
#define bFM3_GPIO_PDORC_PC                     *((volatile unsigned int*)(0x42668630UL))
#define bFM3_GPIO_PDORC_PD                     *((volatile unsigned int*)(0x42668634UL))
#define bFM3_GPIO_PDORC_PE                     *((volatile unsigned int*)(0x42668638UL))
#define bFM3_GPIO_PDORC_PF                     *((volatile unsigned int*)(0x4266863CUL))
#define bFM3_GPIO_PDORD_P0                     *((volatile unsigned int*)(0x42668680UL))
#define bFM3_GPIO_PDORD_P1                     *((volatile unsigned int*)(0x42668684UL))
#define bFM3_GPIO_PDORD_P2                     *((volatile unsigned int*)(0x42668688UL))
#define bFM3_GPIO_PDORD_P3                     *((volatile unsigned int*)(0x4266868CUL))
#define bFM3_GPIO_PDORE_P0                     *((volatile unsigned int*)(0x42668700UL))
#define bFM3_GPIO_PDORE_P2                     *((volatile unsigned int*)(0x42668708UL))
#define bFM3_GPIO_PDORE_P3                     *((volatile unsigned int*)(0x4266870CUL))
#define bFM3_GPIO_PDORF_P0                     *((volatile unsigned int*)(0x42668780UL))
#define bFM3_GPIO_PDORF_P1                     *((volatile unsigned int*)(0x42668784UL))
#define bFM3_GPIO_PDORF_P2                     *((volatile unsigned int*)(0x42668788UL))
#define bFM3_GPIO_PDORF_P3                     *((volatile unsigned int*)(0x4266878CUL))
#define bFM3_GPIO_PDORF_P4                     *((volatile unsigned int*)(0x42668790UL))
#define bFM3_GPIO_PDORF_P5                     *((volatile unsigned int*)(0x42668794UL))
#define bFM3_GPIO_PDORF_P6                     *((volatile unsigned int*)(0x42668798UL))
#define bFM3_GPIO_ADE_AN0                      *((volatile unsigned int*)(0x4266A000UL))
#define bFM3_GPIO_ADE_AN1                      *((volatile unsigned int*)(0x4266A004UL))
#define bFM3_GPIO_ADE_AN2                      *((volatile unsigned int*)(0x4266A008UL))
#define bFM3_GPIO_ADE_AN3                      *((volatile unsigned int*)(0x4266A00CUL))
#define bFM3_GPIO_ADE_AN4                      *((volatile unsigned int*)(0x4266A010UL))
#define bFM3_GPIO_ADE_AN5                      *((volatile unsigned int*)(0x4266A014UL))
#define bFM3_GPIO_ADE_AN6                      *((volatile unsigned int*)(0x4266A018UL))
#define bFM3_GPIO_ADE_AN7                      *((volatile unsigned int*)(0x4266A01CUL))
#define bFM3_GPIO_ADE_AN8                      *((volatile unsigned int*)(0x4266A020UL))
#define bFM3_GPIO_ADE_AN9                      *((volatile unsigned int*)(0x4266A024UL))
#define bFM3_GPIO_ADE_AN10                     *((volatile unsigned int*)(0x4266A028UL))
#define bFM3_GPIO_ADE_AN11                     *((volatile unsigned int*)(0x4266A02CUL))
#define bFM3_GPIO_ADE_AN12                     *((volatile unsigned int*)(0x4266A030UL))
#define bFM3_GPIO_ADE_AN13                     *((volatile unsigned int*)(0x4266A034UL))
#define bFM3_GPIO_ADE_AN14                     *((volatile unsigned int*)(0x4266A038UL))
#define bFM3_GPIO_ADE_AN15                     *((volatile unsigned int*)(0x4266A03CUL))
#define bFM3_GPIO_ADE_AN16                     *((volatile unsigned int*)(0x4266A040UL))
#define bFM3_GPIO_ADE_AN17                     *((volatile unsigned int*)(0x4266A044UL))
#define bFM3_GPIO_ADE_AN18                     *((volatile unsigned int*)(0x4266A048UL))
#define bFM3_GPIO_ADE_AN19                     *((volatile unsigned int*)(0x4266A04CUL))
#define bFM3_GPIO_ADE_AN20                     *((volatile unsigned int*)(0x4266A050UL))
#define bFM3_GPIO_ADE_AN21                     *((volatile unsigned int*)(0x4266A054UL))
#define bFM3_GPIO_ADE_AN22                     *((volatile unsigned int*)(0x4266A058UL))
#define bFM3_GPIO_ADE_AN23                     *((volatile unsigned int*)(0x4266A05CUL))
#define bFM3_GPIO_ADE_AN24                     *((volatile unsigned int*)(0x4266A060UL))
#define bFM3_GPIO_ADE_AN25                     *((volatile unsigned int*)(0x4266A064UL))
#define bFM3_GPIO_ADE_AN26                     *((volatile unsigned int*)(0x4266A068UL))
#define bFM3_GPIO_ADE_AN27                     *((volatile unsigned int*)(0x4266A06CUL))
#define bFM3_GPIO_ADE_AN28                     *((volatile unsigned int*)(0x4266A070UL))
#define bFM3_GPIO_ADE_AN29                     *((volatile unsigned int*)(0x4266A074UL))
#define bFM3_GPIO_ADE_AN30                     *((volatile unsigned int*)(0x4266A078UL))
#define bFM3_GPIO_ADE_AN31                     *((volatile unsigned int*)(0x4266A07CUL))
#define bFM3_GPIO_SPSR_SUBXC                   *((volatile unsigned int*)(0x4266B000UL))
#define bFM3_GPIO_SPSR_MAINXC                  *((volatile unsigned int*)(0x4266B008UL))
#define bFM3_GPIO_SPSR_USB0C                   *((volatile unsigned int*)(0x4266B010UL))
#define bFM3_GPIO_SPSR_USB1C                   *((volatile unsigned int*)(0x4266B014UL))
#define bFM3_GPIO_EPFR00_NMIS                  *((volatile unsigned int*)(0x4266C000UL))
#define bFM3_GPIO_EPFR00_CROUTE0               *((volatile unsigned int*)(0x4266C004UL))
#define bFM3_GPIO_EPFR00_CROUTE1               *((volatile unsigned int*)(0x4266C008UL))
#define bFM3_GPIO_EPFR00_SUBOUTE0              *((volatile unsigned int*)(0x4266C018UL))
#define bFM3_GPIO_EPFR00_SUBOUTE1              *((volatile unsigned int*)(0x4266C01CUL))
#define bFM3_GPIO_EPFR00_USBP0E                *((volatile unsigned int*)(0x4266C024UL))
#define bFM3_GPIO_EPFR00_USBP1E                *((volatile unsigned int*)(0x4266C034UL))
#define bFM3_GPIO_EPFR00_JTAGEN0B              *((volatile unsigned int*)(0x4266C040UL))
#define bFM3_GPIO_EPFR00_JTAGEN1S              *((volatile unsigned int*)(0x4266C044UL))
#define bFM3_GPIO_EPFR00_TRC0E                 *((volatile unsigned int*)(0x4266C060UL))
#define bFM3_GPIO_EPFR00_TRC1E                 *((volatile unsigned int*)(0x4266C064UL))
#define bFM3_GPIO_EPFR01_RTO00E0               *((volatile unsigned int*)(0x4266C080UL))
#define bFM3_GPIO_EPFR01_RTO00E1               *((volatile unsigned int*)(0x4266C084UL))
#define bFM3_GPIO_EPFR01_RTO01E0               *((volatile unsigned int*)(0x4266C088UL))
#define bFM3_GPIO_EPFR01_RTO01E1               *((volatile unsigned int*)(0x4266C08CUL))
#define bFM3_GPIO_EPFR01_RTO02E0               *((volatile unsigned int*)(0x4266C090UL))
#define bFM3_GPIO_EPFR01_RTO02E1               *((volatile unsigned int*)(0x4266C094UL))
#define bFM3_GPIO_EPFR01_RTO03E0               *((volatile unsigned int*)(0x4266C098UL))
#define bFM3_GPIO_EPFR01_RTO03E1               *((volatile unsigned int*)(0x4266C09CUL))
#define bFM3_GPIO_EPFR01_RTO04E0               *((volatile unsigned int*)(0x4266C0A0UL))
#define bFM3_GPIO_EPFR01_RTO04E1               *((volatile unsigned int*)(0x4266C0A4UL))
#define bFM3_GPIO_EPFR01_RTO05E0               *((volatile unsigned int*)(0x4266C0A8UL))
#define bFM3_GPIO_EPFR01_RTO05E1               *((volatile unsigned int*)(0x4266C0ACUL))
#define bFM3_GPIO_EPFR01_DTTI0C                *((volatile unsigned int*)(0x4266C0B0UL))
#define bFM3_GPIO_EPFR01_DTTI0S0               *((volatile unsigned int*)(0x4266C0C0UL))
#define bFM3_GPIO_EPFR01_DTTI0S1               *((volatile unsigned int*)(0x4266C0C4UL))
#define bFM3_GPIO_EPFR01_FRCK0S0               *((volatile unsigned int*)(0x4266C0C8UL))
#define bFM3_GPIO_EPFR01_FRCK0S1               *((volatile unsigned int*)(0x4266C0CCUL))
#define bFM3_GPIO_EPFR01_IC00S0                *((volatile unsigned int*)(0x4266C0D0UL))
#define bFM3_GPIO_EPFR01_IC00S1                *((volatile unsigned int*)(0x4266C0D4UL))
#define bFM3_GPIO_EPFR01_IC00S2                *((volatile unsigned int*)(0x4266C0D8UL))
#define bFM3_GPIO_EPFR01_IC01S0                *((volatile unsigned int*)(0x4266C0DCUL))
#define bFM3_GPIO_EPFR01_IC01S1                *((volatile unsigned int*)(0x4266C0E0UL))
#define bFM3_GPIO_EPFR01_IC01S2                *((volatile unsigned int*)(0x4266C0E4UL))
#define bFM3_GPIO_EPFR01_IC02S0                *((volatile unsigned int*)(0x4266C0E8UL))
#define bFM3_GPIO_EPFR01_IC02S1                *((volatile unsigned int*)(0x4266C0ECUL))
#define bFM3_GPIO_EPFR01_IC02S2                *((volatile unsigned int*)(0x4266C0F0UL))
#define bFM3_GPIO_EPFR01_IC03S0                *((volatile unsigned int*)(0x4266C0F4UL))
#define bFM3_GPIO_EPFR01_IC03S1                *((volatile unsigned int*)(0x4266C0F8UL))
#define bFM3_GPIO_EPFR01_IC03S2                *((volatile unsigned int*)(0x4266C0FCUL))
#define bFM3_GPIO_EPFR02_RTO10E0               *((volatile unsigned int*)(0x4266C100UL))
#define bFM3_GPIO_EPFR02_RTO10E1               *((volatile unsigned int*)(0x4266C104UL))
#define bFM3_GPIO_EPFR02_RTO11E0               *((volatile unsigned int*)(0x4266C108UL))
#define bFM3_GPIO_EPFR02_RTO11E1               *((volatile unsigned int*)(0x4266C10CUL))
#define bFM3_GPIO_EPFR02_RTO12E0               *((volatile unsigned int*)(0x4266C110UL))
#define bFM3_GPIO_EPFR02_RTO12E1               *((volatile unsigned int*)(0x4266C114UL))
#define bFM3_GPIO_EPFR02_RTO13E0               *((volatile unsigned int*)(0x4266C118UL))
#define bFM3_GPIO_EPFR02_RTO13E1               *((volatile unsigned int*)(0x4266C11CUL))
#define bFM3_GPIO_EPFR02_RTO14E0               *((volatile unsigned int*)(0x4266C120UL))
#define bFM3_GPIO_EPFR02_RTO14E1               *((volatile unsigned int*)(0x4266C124UL))
#define bFM3_GPIO_EPFR02_RTO15E0               *((volatile unsigned int*)(0x4266C128UL))
#define bFM3_GPIO_EPFR02_RTO15E1               *((volatile unsigned int*)(0x4266C12CUL))
#define bFM3_GPIO_EPFR02_DTTI1C                *((volatile unsigned int*)(0x4266C130UL))
#define bFM3_GPIO_EPFR02_DTTI1S0               *((volatile unsigned int*)(0x4266C140UL))
#define bFM3_GPIO_EPFR02_DTTI1S1               *((volatile unsigned int*)(0x4266C144UL))
#define bFM3_GPIO_EPFR02_FRCK1S0               *((volatile unsigned int*)(0x4266C148UL))
#define bFM3_GPIO_EPFR02_FRCK1S1               *((volatile unsigned int*)(0x4266C14CUL))
#define bFM3_GPIO_EPFR02_IC10S0                *((volatile unsigned int*)(0x4266C150UL))
#define bFM3_GPIO_EPFR02_IC10S1                *((volatile unsigned int*)(0x4266C154UL))
#define bFM3_GPIO_EPFR02_IC10S2                *((volatile unsigned int*)(0x4266C158UL))
#define bFM3_GPIO_EPFR02_IC11S0                *((volatile unsigned int*)(0x4266C15CUL))
#define bFM3_GPIO_EPFR02_IC11S1                *((volatile unsigned int*)(0x4266C160UL))
#define bFM3_GPIO_EPFR02_IC11S2                *((volatile unsigned int*)(0x4266C164UL))
#define bFM3_GPIO_EPFR02_IC12S0                *((volatile unsigned int*)(0x4266C168UL))
#define bFM3_GPIO_EPFR02_IC12S1                *((volatile unsigned int*)(0x4266C16CUL))
#define bFM3_GPIO_EPFR02_IC12S2                *((volatile unsigned int*)(0x4266C170UL))
#define bFM3_GPIO_EPFR02_IC13S0                *((volatile unsigned int*)(0x4266C174UL))
#define bFM3_GPIO_EPFR02_IC13S1                *((volatile unsigned int*)(0x4266C178UL))
#define bFM3_GPIO_EPFR02_IC13S2                *((volatile unsigned int*)(0x4266C17CUL))
#define bFM3_GPIO_EPFR03_RTO20E0               *((volatile unsigned int*)(0x4266C180UL))
#define bFM3_GPIO_EPFR03_RTO20E1               *((volatile unsigned int*)(0x4266C184UL))
#define bFM3_GPIO_EPFR03_RTO21E0               *((volatile unsigned int*)(0x4266C188UL))
#define bFM3_GPIO_EPFR03_RTO21E1               *((volatile unsigned int*)(0x4266C18CUL))
#define bFM3_GPIO_EPFR03_RTO22E0               *((volatile unsigned int*)(0x4266C190UL))
#define bFM3_GPIO_EPFR03_RTO22E1               *((volatile unsigned int*)(0x4266C194UL))
#define bFM3_GPIO_EPFR03_RTO23E0               *((volatile unsigned int*)(0x4266C198UL))
#define bFM3_GPIO_EPFR03_RTO23E1               *((volatile unsigned int*)(0x4266C19CUL))
#define bFM3_GPIO_EPFR03_RTO24E0               *((volatile unsigned int*)(0x4266C1A0UL))
#define bFM3_GPIO_EPFR03_RTO24E1               *((volatile unsigned int*)(0x4266C1A4UL))
#define bFM3_GPIO_EPFR03_RTO25E0               *((volatile unsigned int*)(0x4266C1A8UL))
#define bFM3_GPIO_EPFR03_RTO25E1               *((volatile unsigned int*)(0x4266C1ACUL))
#define bFM3_GPIO_EPFR03_DTTI2C                *((volatile unsigned int*)(0x4266C1B0UL))
#define bFM3_GPIO_EPFR03_DTTI2S0               *((volatile unsigned int*)(0x4266C1C0UL))
#define bFM3_GPIO_EPFR03_DTTI2S1               *((volatile unsigned int*)(0x4266C1C4UL))
#define bFM3_GPIO_EPFR03_FRCK2S0               *((volatile unsigned int*)(0x4266C1C8UL))
#define bFM3_GPIO_EPFR03_FRCK2S1               *((volatile unsigned int*)(0x4266C1CCUL))
#define bFM3_GPIO_EPFR03_IC20S0                *((volatile unsigned int*)(0x4266C1D0UL))
#define bFM3_GPIO_EPFR03_IC20S1                *((volatile unsigned int*)(0x4266C1D4UL))
#define bFM3_GPIO_EPFR03_IC20S2                *((volatile unsigned int*)(0x4266C1D8UL))
#define bFM3_GPIO_EPFR03_IC21S0                *((volatile unsigned int*)(0x4266C1DCUL))
#define bFM3_GPIO_EPFR03_IC21S1                *((volatile unsigned int*)(0x4266C1E0UL))
#define bFM3_GPIO_EPFR03_IC21S2                *((volatile unsigned int*)(0x4266C1E4UL))
#define bFM3_GPIO_EPFR03_IC22S0                *((volatile unsigned int*)(0x4266C1E8UL))
#define bFM3_GPIO_EPFR03_IC22S1                *((volatile unsigned int*)(0x4266C1ECUL))
#define bFM3_GPIO_EPFR03_IC22S2                *((volatile unsigned int*)(0x4266C1F0UL))
#define bFM3_GPIO_EPFR03_IC23S0                *((volatile unsigned int*)(0x4266C1F4UL))
#define bFM3_GPIO_EPFR03_IC23S1                *((volatile unsigned int*)(0x4266C1F8UL))
#define bFM3_GPIO_EPFR03_IC23S2                *((volatile unsigned int*)(0x4266C1FCUL))
#define bFM3_GPIO_EPFR04_TIOA0E0               *((volatile unsigned int*)(0x4266C208UL))
#define bFM3_GPIO_EPFR04_TIOA0E1               *((volatile unsigned int*)(0x4266C20CUL))
#define bFM3_GPIO_EPFR04_TIOB0S0               *((volatile unsigned int*)(0x4266C210UL))
#define bFM3_GPIO_EPFR04_TIOB0S1               *((volatile unsigned int*)(0x4266C214UL))
#define bFM3_GPIO_EPFR04_TIOA1S0               *((volatile unsigned int*)(0x4266C220UL))
#define bFM3_GPIO_EPFR04_TIOA1S1               *((volatile unsigned int*)(0x4266C224UL))
#define bFM3_GPIO_EPFR04_TIOA1E0               *((volatile unsigned int*)(0x4266C228UL))
#define bFM3_GPIO_EPFR04_TIOA1E1               *((volatile unsigned int*)(0x4266C22CUL))
#define bFM3_GPIO_EPFR04_TIOB1S0               *((volatile unsigned int*)(0x4266C230UL))
#define bFM3_GPIO_EPFR04_TIOB1S1               *((volatile unsigned int*)(0x4266C234UL))
#define bFM3_GPIO_EPFR04_TIOA2E0               *((volatile unsigned int*)(0x4266C248UL))
#define bFM3_GPIO_EPFR04_TIOA2E1               *((volatile unsigned int*)(0x4266C24CUL))
#define bFM3_GPIO_EPFR04_TIOB2S0               *((volatile unsigned int*)(0x4266C250UL))
#define bFM3_GPIO_EPFR04_TIOB2S1               *((volatile unsigned int*)(0x4266C254UL))
#define bFM3_GPIO_EPFR04_TIOA3S0               *((volatile unsigned int*)(0x4266C260UL))
#define bFM3_GPIO_EPFR04_TIOA3S1               *((volatile unsigned int*)(0x4266C264UL))
#define bFM3_GPIO_EPFR04_TIOA3E0               *((volatile unsigned int*)(0x4266C268UL))
#define bFM3_GPIO_EPFR04_TIOA3E1               *((volatile unsigned int*)(0x4266C26CUL))
#define bFM3_GPIO_EPFR04_TIOB3S0               *((volatile unsigned int*)(0x4266C270UL))
#define bFM3_GPIO_EPFR04_TIOB3S1               *((volatile unsigned int*)(0x4266C274UL))
#define bFM3_GPIO_EPFR05_TIOA4E0               *((volatile unsigned int*)(0x4266C288UL))
#define bFM3_GPIO_EPFR05_TIOA4E1               *((volatile unsigned int*)(0x4266C28CUL))
#define bFM3_GPIO_EPFR05_TIOB4S0               *((volatile unsigned int*)(0x4266C290UL))
#define bFM3_GPIO_EPFR05_TIOB4S1               *((volatile unsigned int*)(0x4266C294UL))
#define bFM3_GPIO_EPFR05_TIOA5S0               *((volatile unsigned int*)(0x4266C2A0UL))
#define bFM3_GPIO_EPFR05_TIOA5S1               *((volatile unsigned int*)(0x4266C2A4UL))
#define bFM3_GPIO_EPFR05_TIOA5E0               *((volatile unsigned int*)(0x4266C2A8UL))
#define bFM3_GPIO_EPFR05_TIOA5E1               *((volatile unsigned int*)(0x4266C2ACUL))
#define bFM3_GPIO_EPFR05_TIOB5S0               *((volatile unsigned int*)(0x4266C2B0UL))
#define bFM3_GPIO_EPFR05_TIOB5S1               *((volatile unsigned int*)(0x4266C2B4UL))
#define bFM3_GPIO_EPFR05_TIOA6E0               *((volatile unsigned int*)(0x4266C2C8UL))
#define bFM3_GPIO_EPFR05_TIOA6E1               *((volatile unsigned int*)(0x4266C2CCUL))
#define bFM3_GPIO_EPFR05_TIOB6S0               *((volatile unsigned int*)(0x4266C2D0UL))
#define bFM3_GPIO_EPFR05_TIOB6S1               *((volatile unsigned int*)(0x4266C2D4UL))
#define bFM3_GPIO_EPFR05_TIOA7S0               *((volatile unsigned int*)(0x4266C2E0UL))
#define bFM3_GPIO_EPFR05_TIOA7S1               *((volatile unsigned int*)(0x4266C2E4UL))
#define bFM3_GPIO_EPFR05_TIOA7E0               *((volatile unsigned int*)(0x4266C2E8UL))
#define bFM3_GPIO_EPFR05_TIOA7E1               *((volatile unsigned int*)(0x4266C2ECUL))
#define bFM3_GPIO_EPFR05_TIOB7S0               *((volatile unsigned int*)(0x4266C2F0UL))
#define bFM3_GPIO_EPFR05_TIOB7S1               *((volatile unsigned int*)(0x4266C2F4UL))
#define bFM3_GPIO_EPFR06_EINT00S0              *((volatile unsigned int*)(0x4266C300UL))
#define bFM3_GPIO_EPFR06_EINT00S1              *((volatile unsigned int*)(0x4266C304UL))
#define bFM3_GPIO_EPFR06_EINT01S0              *((volatile unsigned int*)(0x4266C308UL))
#define bFM3_GPIO_EPFR06_EINT01S1              *((volatile unsigned int*)(0x4266C30CUL))
#define bFM3_GPIO_EPFR06_EINT02S0              *((volatile unsigned int*)(0x4266C310UL))
#define bFM3_GPIO_EPFR06_EINT02S1              *((volatile unsigned int*)(0x4266C314UL))
#define bFM3_GPIO_EPFR06_EINT03S0              *((volatile unsigned int*)(0x4266C318UL))
#define bFM3_GPIO_EPFR06_EINT03S1              *((volatile unsigned int*)(0x4266C31CUL))
#define bFM3_GPIO_EPFR06_EINT04S0              *((volatile unsigned int*)(0x4266C320UL))
#define bFM3_GPIO_EPFR06_EINT04S1              *((volatile unsigned int*)(0x4266C324UL))
#define bFM3_GPIO_EPFR06_EINT05S0              *((volatile unsigned int*)(0x4266C328UL))
#define bFM3_GPIO_EPFR06_EINT05S1              *((volatile unsigned int*)(0x4266C32CUL))
#define bFM3_GPIO_EPFR06_EINT06S0              *((volatile unsigned int*)(0x4266C330UL))
#define bFM3_GPIO_EPFR06_EINT06S1              *((volatile unsigned int*)(0x4266C334UL))
#define bFM3_GPIO_EPFR06_EINT07S0              *((volatile unsigned int*)(0x4266C338UL))
#define bFM3_GPIO_EPFR06_EINT07S1              *((volatile unsigned int*)(0x4266C33CUL))
#define bFM3_GPIO_EPFR06_EINT08S0              *((volatile unsigned int*)(0x4266C340UL))
#define bFM3_GPIO_EPFR06_EINT08S1              *((volatile unsigned int*)(0x4266C344UL))
#define bFM3_GPIO_EPFR06_EINT09S0              *((volatile unsigned int*)(0x4266C348UL))
#define bFM3_GPIO_EPFR06_EINT09S1              *((volatile unsigned int*)(0x4266C34CUL))
#define bFM3_GPIO_EPFR06_EINT10S0              *((volatile unsigned int*)(0x4266C350UL))
#define bFM3_GPIO_EPFR06_EINT10S1              *((volatile unsigned int*)(0x4266C354UL))
#define bFM3_GPIO_EPFR06_EINT11S0              *((volatile unsigned int*)(0x4266C358UL))
#define bFM3_GPIO_EPFR06_EINT11S1              *((volatile unsigned int*)(0x4266C35CUL))
#define bFM3_GPIO_EPFR06_EINT12S0              *((volatile unsigned int*)(0x4266C360UL))
#define bFM3_GPIO_EPFR06_EINT12S1              *((volatile unsigned int*)(0x4266C364UL))
#define bFM3_GPIO_EPFR06_EINT13S0              *((volatile unsigned int*)(0x4266C368UL))
#define bFM3_GPIO_EPFR06_EINT13S1              *((volatile unsigned int*)(0x4266C36CUL))
#define bFM3_GPIO_EPFR06_EINT14S0              *((volatile unsigned int*)(0x4266C370UL))
#define bFM3_GPIO_EPFR06_EINT14S1              *((volatile unsigned int*)(0x4266C374UL))
#define bFM3_GPIO_EPFR06_EINT15S0              *((volatile unsigned int*)(0x4266C378UL))
#define bFM3_GPIO_EPFR06_EINT15S1              *((volatile unsigned int*)(0x4266C37CUL))
#define bFM3_GPIO_EPFR07_SIN0S0                *((volatile unsigned int*)(0x4266C390UL))
#define bFM3_GPIO_EPFR07_SIN0S1                *((volatile unsigned int*)(0x4266C394UL))
#define bFM3_GPIO_EPFR07_SOT0B0                *((volatile unsigned int*)(0x4266C398UL))
#define bFM3_GPIO_EPFR07_SOT0B1                *((volatile unsigned int*)(0x4266C39CUL))
#define bFM3_GPIO_EPFR07_SCK0B0                *((volatile unsigned int*)(0x4266C3A0UL))
#define bFM3_GPIO_EPFR07_SCK0B1                *((volatile unsigned int*)(0x4266C3A4UL))
#define bFM3_GPIO_EPFR07_SIN1S0                *((volatile unsigned int*)(0x4266C3A8UL))
#define bFM3_GPIO_EPFR07_SIN1S1                *((volatile unsigned int*)(0x4266C3ACUL))
#define bFM3_GPIO_EPFR07_SOT1B0                *((volatile unsigned int*)(0x4266C3B0UL))
#define bFM3_GPIO_EPFR07_SOT1B1                *((volatile unsigned int*)(0x4266C3B4UL))
#define bFM3_GPIO_EPFR07_SCK1B0                *((volatile unsigned int*)(0x4266C3B8UL))
#define bFM3_GPIO_EPFR07_SCK1B1                *((volatile unsigned int*)(0x4266C3BCUL))
#define bFM3_GPIO_EPFR07_SIN2S0                *((volatile unsigned int*)(0x4266C3C0UL))
#define bFM3_GPIO_EPFR07_SIN2S1                *((volatile unsigned int*)(0x4266C3C4UL))
#define bFM3_GPIO_EPFR07_SOT2B0                *((volatile unsigned int*)(0x4266C3C8UL))
#define bFM3_GPIO_EPFR07_SOT2B1                *((volatile unsigned int*)(0x4266C3CCUL))
#define bFM3_GPIO_EPFR07_SCK2B0                *((volatile unsigned int*)(0x4266C3D0UL))
#define bFM3_GPIO_EPFR07_SCK2B1                *((volatile unsigned int*)(0x4266C3D4UL))
#define bFM3_GPIO_EPFR07_SIN3S0                *((volatile unsigned int*)(0x4266C3D8UL))
#define bFM3_GPIO_EPFR07_SIN3S1                *((volatile unsigned int*)(0x4266C3DCUL))
#define bFM3_GPIO_EPFR07_SOT3B0                *((volatile unsigned int*)(0x4266C3E0UL))
#define bFM3_GPIO_EPFR07_SOT3B1                *((volatile unsigned int*)(0x4266C3E4UL))
#define bFM3_GPIO_EPFR07_SCK3B0                *((volatile unsigned int*)(0x4266C3E8UL))
#define bFM3_GPIO_EPFR07_SCK3B1                *((volatile unsigned int*)(0x4266C3ECUL))
#define bFM3_GPIO_EPFR08_RTS4E0                *((volatile unsigned int*)(0x4266C400UL))
#define bFM3_GPIO_EPFR08_RTS4E1                *((volatile unsigned int*)(0x4266C404UL))
#define bFM3_GPIO_EPFR08_CTS4S0                *((volatile unsigned int*)(0x4266C408UL))
#define bFM3_GPIO_EPFR08_CTS4S1                *((volatile unsigned int*)(0x4266C40CUL))
#define bFM3_GPIO_EPFR08_SIN4S0                *((volatile unsigned int*)(0x4266C410UL))
#define bFM3_GPIO_EPFR08_SIN4S1                *((volatile unsigned int*)(0x4266C414UL))
#define bFM3_GPIO_EPFR08_SOT4B0                *((volatile unsigned int*)(0x4266C418UL))
#define bFM3_GPIO_EPFR08_SOT4B1                *((volatile unsigned int*)(0x4266C41CUL))
#define bFM3_GPIO_EPFR08_SCK4B0                *((volatile unsigned int*)(0x4266C420UL))
#define bFM3_GPIO_EPFR08_SCK4B1                *((volatile unsigned int*)(0x4266C424UL))
#define bFM3_GPIO_EPFR08_SIN5S0                *((volatile unsigned int*)(0x4266C428UL))
#define bFM3_GPIO_EPFR08_SIN5S1                *((volatile unsigned int*)(0x4266C42CUL))
#define bFM3_GPIO_EPFR08_SOT5B0                *((volatile unsigned int*)(0x4266C430UL))
#define bFM3_GPIO_EPFR08_SOT5B1                *((volatile unsigned int*)(0x4266C434UL))
#define bFM3_GPIO_EPFR08_SCK5B0                *((volatile unsigned int*)(0x4266C438UL))
#define bFM3_GPIO_EPFR08_SCK5B1                *((volatile unsigned int*)(0x4266C43CUL))
#define bFM3_GPIO_EPFR08_SIN6S0                *((volatile unsigned int*)(0x4266C440UL))
#define bFM3_GPIO_EPFR08_SIN6S1                *((volatile unsigned int*)(0x4266C444UL))
#define bFM3_GPIO_EPFR08_SOT6B0                *((volatile unsigned int*)(0x4266C448UL))
#define bFM3_GPIO_EPFR08_SOT6B1                *((volatile unsigned int*)(0x4266C44CUL))
#define bFM3_GPIO_EPFR08_SCK6B0                *((volatile unsigned int*)(0x4266C450UL))
#define bFM3_GPIO_EPFR08_SCK6B1                *((volatile unsigned int*)(0x4266C454UL))
#define bFM3_GPIO_EPFR08_SIN7S0                *((volatile unsigned int*)(0x4266C458UL))
#define bFM3_GPIO_EPFR08_SIN7S1                *((volatile unsigned int*)(0x4266C45CUL))
#define bFM3_GPIO_EPFR08_SOT7B0                *((volatile unsigned int*)(0x4266C460UL))
#define bFM3_GPIO_EPFR08_SOT7B1                *((volatile unsigned int*)(0x4266C464UL))
#define bFM3_GPIO_EPFR08_SCK7B0                *((volatile unsigned int*)(0x4266C468UL))
#define bFM3_GPIO_EPFR08_SCK7B1                *((volatile unsigned int*)(0x4266C46CUL))
#define bFM3_GPIO_EPFR09_QAIN0S0               *((volatile unsigned int*)(0x4266C480UL))
#define bFM3_GPIO_EPFR09_QAIN0S1               *((volatile unsigned int*)(0x4266C484UL))
#define bFM3_GPIO_EPFR09_QBIN0S0               *((volatile unsigned int*)(0x4266C488UL))
#define bFM3_GPIO_EPFR09_QBIN0S1               *((volatile unsigned int*)(0x4266C48CUL))
#define bFM3_GPIO_EPFR09_QZIN0S0               *((volatile unsigned int*)(0x4266C490UL))
#define bFM3_GPIO_EPFR09_QZIN0S1               *((volatile unsigned int*)(0x4266C494UL))
#define bFM3_GPIO_EPFR09_QAIN1S0               *((volatile unsigned int*)(0x4266C498UL))
#define bFM3_GPIO_EPFR09_QAIN1S1               *((volatile unsigned int*)(0x4266C49CUL))
#define bFM3_GPIO_EPFR09_QBIN1S0               *((volatile unsigned int*)(0x4266C4A0UL))
#define bFM3_GPIO_EPFR09_QBIN1S1               *((volatile unsigned int*)(0x4266C4A4UL))
#define bFM3_GPIO_EPFR09_QZIN1S0               *((volatile unsigned int*)(0x4266C4A8UL))
#define bFM3_GPIO_EPFR09_QZIN1S1               *((volatile unsigned int*)(0x4266C4ACUL))
#define bFM3_GPIO_EPFR09_ADTRG0S0              *((volatile unsigned int*)(0x4266C4B0UL))
#define bFM3_GPIO_EPFR09_ADTRG0S1              *((volatile unsigned int*)(0x4266C4B4UL))
#define bFM3_GPIO_EPFR09_ADTRG0S2              *((volatile unsigned int*)(0x4266C4B8UL))
#define bFM3_GPIO_EPFR09_ADTRG0S3              *((volatile unsigned int*)(0x4266C4BCUL))
#define bFM3_GPIO_EPFR09_ADTRG1S0              *((volatile unsigned int*)(0x4266C4C0UL))
#define bFM3_GPIO_EPFR09_ADTRG1S1              *((volatile unsigned int*)(0x4266C4C4UL))
#define bFM3_GPIO_EPFR09_ADTRG1S2              *((volatile unsigned int*)(0x4266C4C8UL))
#define bFM3_GPIO_EPFR09_ADTRG1S3              *((volatile unsigned int*)(0x4266C4CCUL))
#define bFM3_GPIO_EPFR09_ADTRG2S0              *((volatile unsigned int*)(0x4266C4D0UL))
#define bFM3_GPIO_EPFR09_ADTRG2S1              *((volatile unsigned int*)(0x4266C4D4UL))
#define bFM3_GPIO_EPFR09_ADTRG2S2              *((volatile unsigned int*)(0x4266C4D8UL))
#define bFM3_GPIO_EPFR09_ADTRG2S3              *((volatile unsigned int*)(0x4266C4DCUL))
#define bFM3_GPIO_EPFR09_CRX0S0                *((volatile unsigned int*)(0x4266C4E0UL))
#define bFM3_GPIO_EPFR09_CRX0S1                *((volatile unsigned int*)(0x4266C4E4UL))
#define bFM3_GPIO_EPFR09_CTX0E0                *((volatile unsigned int*)(0x4266C4E8UL))
#define bFM3_GPIO_EPFR09_CTX0E1                *((volatile unsigned int*)(0x4266C4ECUL))
#define bFM3_GPIO_EPFR09_CRX1S0                *((volatile unsigned int*)(0x4266C4F0UL))
#define bFM3_GPIO_EPFR09_CRX1S1                *((volatile unsigned int*)(0x4266C4F4UL))
#define bFM3_GPIO_EPFR09_CTX1E0                *((volatile unsigned int*)(0x4266C4F8UL))
#define bFM3_GPIO_EPFR09_CTX1E1                *((volatile unsigned int*)(0x4266C4FCUL))
#define bFM3_GPIO_EPFR10_UEDEFB                *((volatile unsigned int*)(0x4266C500UL))
#define bFM3_GPIO_EPFR10_UEDTHB                *((volatile unsigned int*)(0x4266C504UL))
#define bFM3_GPIO_EPFR10_UECLKE                *((volatile unsigned int*)(0x4266C508UL))
#define bFM3_GPIO_EPFR10_UEWEXE                *((volatile unsigned int*)(0x4266C50CUL))
#define bFM3_GPIO_EPFR10_UEDQME                *((volatile unsigned int*)(0x4266C510UL))
#define bFM3_GPIO_EPFR10_UEOEXE                *((volatile unsigned int*)(0x4266C514UL))
#define bFM3_GPIO_EPFR10_UEFLSE                *((volatile unsigned int*)(0x4266C518UL))
#define bFM3_GPIO_EPFR10_UECS1E                *((volatile unsigned int*)(0x4266C51CUL))
#define bFM3_GPIO_EPFR10_UECS2E                *((volatile unsigned int*)(0x4266C520UL))
#define bFM3_GPIO_EPFR10_UECS3E                *((volatile unsigned int*)(0x4266C524UL))
#define bFM3_GPIO_EPFR10_UECS4E                *((volatile unsigned int*)(0x4266C528UL))
#define bFM3_GPIO_EPFR10_UECS5E                *((volatile unsigned int*)(0x4266C52CUL))
#define bFM3_GPIO_EPFR10_UECS6E                *((volatile unsigned int*)(0x4266C530UL))
#define bFM3_GPIO_EPFR10_UECS7E                *((volatile unsigned int*)(0x4266C534UL))
#define bFM3_GPIO_EPFR10_UEAOOE                *((volatile unsigned int*)(0x4266C538UL))
#define bFM3_GPIO_EPFR10_UEA08E                *((volatile unsigned int*)(0x4266C53CUL))
#define bFM3_GPIO_EPFR10_UEA09E                *((volatile unsigned int*)(0x4266C540UL))
#define bFM3_GPIO_EPFR10_UEA10E                *((volatile unsigned int*)(0x4266C544UL))
#define bFM3_GPIO_EPFR10_UEA11E                *((volatile unsigned int*)(0x4266C548UL))
#define bFM3_GPIO_EPFR10_UEA12E                *((volatile unsigned int*)(0x4266C54CUL))
#define bFM3_GPIO_EPFR10_UEA13E                *((volatile unsigned int*)(0x4266C550UL))
#define bFM3_GPIO_EPFR10_UEA14E                *((volatile unsigned int*)(0x4266C554UL))
#define bFM3_GPIO_EPFR10_UEA15E                *((volatile unsigned int*)(0x4266C558UL))
#define bFM3_GPIO_EPFR10_UEA16E                *((volatile unsigned int*)(0x4266C55CUL))
#define bFM3_GPIO_EPFR10_UEA17E                *((volatile unsigned int*)(0x4266C560UL))
#define bFM3_GPIO_EPFR10_UEA18E                *((volatile unsigned int*)(0x4266C564UL))
#define bFM3_GPIO_EPFR10_UEA19E                *((volatile unsigned int*)(0x4266C568UL))
#define bFM3_GPIO_EPFR10_UEA20E                *((volatile unsigned int*)(0x4266C56CUL))
#define bFM3_GPIO_EPFR10_UEA21E                *((volatile unsigned int*)(0x4266C570UL))
#define bFM3_GPIO_EPFR10_UEA22E                *((volatile unsigned int*)(0x4266C574UL))
#define bFM3_GPIO_EPFR10_UEA23E                *((volatile unsigned int*)(0x4266C578UL))
#define bFM3_GPIO_EPFR10_UEA24E                *((volatile unsigned int*)(0x4266C57CUL))
#define bFM3_GPIO_EPFR11_UEALEE                *((volatile unsigned int*)(0x4266C580UL))
#define bFM3_GPIO_EPFR11_UECS0E                *((volatile unsigned int*)(0x4266C584UL))
#define bFM3_GPIO_EPFR11_UEA01E                *((volatile unsigned int*)(0x4266C588UL))
#define bFM3_GPIO_EPFR11_UEA02E                *((volatile unsigned int*)(0x4266C58CUL))
#define bFM3_GPIO_EPFR11_UEA03E                *((volatile unsigned int*)(0x4266C590UL))
#define bFM3_GPIO_EPFR11_UEA04E                *((volatile unsigned int*)(0x4266C594UL))
#define bFM3_GPIO_EPFR11_UEA05E                *((volatile unsigned int*)(0x4266C598UL))
#define bFM3_GPIO_EPFR11_UEA06E                *((volatile unsigned int*)(0x4266C59CUL))
#define bFM3_GPIO_EPFR11_UEA07E                *((volatile unsigned int*)(0x4266C5A0UL))
#define bFM3_GPIO_EPFR11_UED00B                *((volatile unsigned int*)(0x4266C5A4UL))
#define bFM3_GPIO_EPFR11_UED01B                *((volatile unsigned int*)(0x4266C5A8UL))
#define bFM3_GPIO_EPFR11_UED02B                *((volatile unsigned int*)(0x4266C5ACUL))
#define bFM3_GPIO_EPFR11_UED03B                *((volatile unsigned int*)(0x4266C5B0UL))
#define bFM3_GPIO_EPFR11_UED04B                *((volatile unsigned int*)(0x4266C5B4UL))
#define bFM3_GPIO_EPFR11_UED05B                *((volatile unsigned int*)(0x4266C5B8UL))
#define bFM3_GPIO_EPFR11_UED06B                *((volatile unsigned int*)(0x4266C5BCUL))
#define bFM3_GPIO_EPFR11_UED07B                *((volatile unsigned int*)(0x4266C5C0UL))
#define bFM3_GPIO_EPFR11_UED08B                *((volatile unsigned int*)(0x4266C5C4UL))
#define bFM3_GPIO_EPFR11_UED09B                *((volatile unsigned int*)(0x4266C5C8UL))
#define bFM3_GPIO_EPFR11_UED10B                *((volatile unsigned int*)(0x4266C5CCUL))
#define bFM3_GPIO_EPFR11_UED11B                *((volatile unsigned int*)(0x4266C5D0UL))
#define bFM3_GPIO_EPFR11_UED12B                *((volatile unsigned int*)(0x4266C5D4UL))
#define bFM3_GPIO_EPFR11_UED13B                *((volatile unsigned int*)(0x4266C5D8UL))
#define bFM3_GPIO_EPFR11_UED14B                *((volatile unsigned int*)(0x4266C5DCUL))
#define bFM3_GPIO_EPFR11_UED15B                *((volatile unsigned int*)(0x4266C5E0UL))
#define bFM3_GPIO_EPFR11_UERLC                 *((volatile unsigned int*)(0x4266C5E4UL))
#define bFM3_GPIO_EPFR12_TIOA8E0               *((volatile unsigned int*)(0x4266C608UL))
#define bFM3_GPIO_EPFR12_TIOA8E1               *((volatile unsigned int*)(0x4266C60CUL))
#define bFM3_GPIO_EPFR12_TIOB8S0               *((volatile unsigned int*)(0x4266C610UL))
#define bFM3_GPIO_EPFR12_TIOB8S1               *((volatile unsigned int*)(0x4266C614UL))
#define bFM3_GPIO_EPFR12_TIOA9S0               *((volatile unsigned int*)(0x4266C620UL))
#define bFM3_GPIO_EPFR12_TIOA9S1               *((volatile unsigned int*)(0x4266C624UL))
#define bFM3_GPIO_EPFR12_TIOA9E0               *((volatile unsigned int*)(0x4266C628UL))
#define bFM3_GPIO_EPFR12_TIOA9E1               *((volatile unsigned int*)(0x4266C62CUL))
#define bFM3_GPIO_EPFR12_TIOB9S0               *((volatile unsigned int*)(0x4266C630UL))
#define bFM3_GPIO_EPFR12_TIOB9S1               *((volatile unsigned int*)(0x4266C634UL))
#define bFM3_GPIO_EPFR12_TIOA10E0              *((volatile unsigned int*)(0x4266C648UL))
#define bFM3_GPIO_EPFR12_TIOA10E1              *((volatile unsigned int*)(0x4266C64CUL))
#define bFM3_GPIO_EPFR12_TIOB10S0              *((volatile unsigned int*)(0x4266C650UL))
#define bFM3_GPIO_EPFR12_TIOB10S1              *((volatile unsigned int*)(0x4266C654UL))
#define bFM3_GPIO_EPFR12_TIOA11S0              *((volatile unsigned int*)(0x4266C660UL))
#define bFM3_GPIO_EPFR12_TIOA11S1              *((volatile unsigned int*)(0x4266C664UL))
#define bFM3_GPIO_EPFR12_TIOA11E0              *((volatile unsigned int*)(0x4266C668UL))
#define bFM3_GPIO_EPFR12_TIOA11E1              *((volatile unsigned int*)(0x4266C66CUL))
#define bFM3_GPIO_EPFR12_TIOB11S0              *((volatile unsigned int*)(0x4266C670UL))
#define bFM3_GPIO_EPFR12_TIOB11S1              *((volatile unsigned int*)(0x4266C674UL))
#define bFM3_GPIO_EPFR13_TIOA12E0              *((volatile unsigned int*)(0x4266C688UL))
#define bFM3_GPIO_EPFR13_TIOA12E1              *((volatile unsigned int*)(0x4266C68CUL))
#define bFM3_GPIO_EPFR13_TIOB12S0              *((volatile unsigned int*)(0x4266C690UL))
#define bFM3_GPIO_EPFR13_TIOB12S1              *((volatile unsigned int*)(0x4266C694UL))
#define bFM3_GPIO_EPFR13_TIOA13S0              *((volatile unsigned int*)(0x4266C6A0UL))
#define bFM3_GPIO_EPFR13_TIOA13S1              *((volatile unsigned int*)(0x4266C6A4UL))
#define bFM3_GPIO_EPFR13_TIOA13E0              *((volatile unsigned int*)(0x4266C6A8UL))
#define bFM3_GPIO_EPFR13_TIOA13E1              *((volatile unsigned int*)(0x4266C6ACUL))
#define bFM3_GPIO_EPFR13_TIOB13S0              *((volatile unsigned int*)(0x4266C6B0UL))
#define bFM3_GPIO_EPFR13_TIOB13S1              *((volatile unsigned int*)(0x4266C6B4UL))
#define bFM3_GPIO_EPFR13_TIOA14E0              *((volatile unsigned int*)(0x4266C6C8UL))
#define bFM3_GPIO_EPFR13_TIOA14E1              *((volatile unsigned int*)(0x4266C6CCUL))
#define bFM3_GPIO_EPFR13_TIOB14S0              *((volatile unsigned int*)(0x4266C6D0UL))
#define bFM3_GPIO_EPFR13_TIOB14S1              *((volatile unsigned int*)(0x4266C6D4UL))
#define bFM3_GPIO_EPFR13_TIOA15S0              *((volatile unsigned int*)(0x4266C6E0UL))
#define bFM3_GPIO_EPFR13_TIOA15S1              *((volatile unsigned int*)(0x4266C6E4UL))
#define bFM3_GPIO_EPFR13_TIOA15E0              *((volatile unsigned int*)(0x4266C6E8UL))
#define bFM3_GPIO_EPFR13_TIOA15E1              *((volatile unsigned int*)(0x4266C6ECUL))
#define bFM3_GPIO_EPFR13_TIOB15S0              *((volatile unsigned int*)(0x4266C6F0UL))
#define bFM3_GPIO_EPFR13_TIOB15S1              *((volatile unsigned int*)(0x4266C6F4UL))
#define bFM3_GPIO_EPFR14_QAIN2S0               *((volatile unsigned int*)(0x4266C700UL))
#define bFM3_GPIO_EPFR14_QAIN2S1               *((volatile unsigned int*)(0x4266C704UL))
#define bFM3_GPIO_EPFR14_QBIN2S0               *((volatile unsigned int*)(0x4266C708UL))
#define bFM3_GPIO_EPFR14_QBIN2S1               *((volatile unsigned int*)(0x4266C70CUL))
#define bFM3_GPIO_EPFR14_QZIN2S0               *((volatile unsigned int*)(0x4266C710UL))
#define bFM3_GPIO_EPFR14_QZIN2S1               *((volatile unsigned int*)(0x4266C714UL))
#define bFM3_GPIO_EPFR14_E_TD0E                *((volatile unsigned int*)(0x4266C748UL))
#define bFM3_GPIO_EPFR14_E_TD1E                *((volatile unsigned int*)(0x4266C74CUL))
#define bFM3_GPIO_EPFR14_E_TE0E                *((volatile unsigned int*)(0x4266C750UL))
#define bFM3_GPIO_EPFR14_E_TE1E                *((volatile unsigned int*)(0x4266C754UL))
#define bFM3_GPIO_EPFR14_E_MC0E                *((volatile unsigned int*)(0x4266C758UL))
#define bFM3_GPIO_EPFR14_E_MC1B                *((volatile unsigned int*)(0x4266C75CUL))
#define bFM3_GPIO_EPFR14_E_MD0B                *((volatile unsigned int*)(0x4266C760UL))
#define bFM3_GPIO_EPFR14_E_MD1B                *((volatile unsigned int*)(0x4266C764UL))
#define bFM3_GPIO_EPFR14_E_CKE                 *((volatile unsigned int*)(0x4266C768UL))
#define bFM3_GPIO_EPFR14_E_PSE                 *((volatile unsigned int*)(0x4266C76CUL))
#define bFM3_GPIO_EPFR14_E_SPLC0               *((volatile unsigned int*)(0x4266C770UL))
#define bFM3_GPIO_EPFR14_E_SPLC1               *((volatile unsigned int*)(0x4266C774UL))
#define bFM3_GPIO_EPFR15_EINT16S0              *((volatile unsigned int*)(0x4266C780UL))
#define bFM3_GPIO_EPFR15_EINT16S1              *((volatile unsigned int*)(0x4266C784UL))
#define bFM3_GPIO_EPFR15_EINT17S0              *((volatile unsigned int*)(0x4266C788UL))
#define bFM3_GPIO_EPFR15_EINT17S1              *((volatile unsigned int*)(0x4266C78CUL))
#define bFM3_GPIO_EPFR15_EINT18S0              *((volatile unsigned int*)(0x4266C790UL))
#define bFM3_GPIO_EPFR15_EINT18S1              *((volatile unsigned int*)(0x4266C794UL))
#define bFM3_GPIO_EPFR15_EINT19S0              *((volatile unsigned int*)(0x4266C798UL))
#define bFM3_GPIO_EPFR15_EINT19S1              *((volatile unsigned int*)(0x4266C79CUL))
#define bFM3_GPIO_EPFR15_EINT20S0              *((volatile unsigned int*)(0x4266C7A0UL))
#define bFM3_GPIO_EPFR15_EINT20S1              *((volatile unsigned int*)(0x4266C7A4UL))
#define bFM3_GPIO_EPFR15_EINT21S0              *((volatile unsigned int*)(0x4266C7A8UL))
#define bFM3_GPIO_EPFR15_EINT21S1              *((volatile unsigned int*)(0x4266C7ACUL))
#define bFM3_GPIO_EPFR15_EINT22S0              *((volatile unsigned int*)(0x4266C7B0UL))
#define bFM3_GPIO_EPFR15_EINT22S1              *((volatile unsigned int*)(0x4266C7B4UL))
#define bFM3_GPIO_EPFR15_EINT23S0              *((volatile unsigned int*)(0x4266C7B8UL))
#define bFM3_GPIO_EPFR15_EINT23S1              *((volatile unsigned int*)(0x4266C7BCUL))
#define bFM3_GPIO_EPFR15_EINT24S0              *((volatile unsigned int*)(0x4266C7C0UL))
#define bFM3_GPIO_EPFR15_EINT24S1              *((volatile unsigned int*)(0x4266C7C4UL))
#define bFM3_GPIO_EPFR15_EINT25S0              *((volatile unsigned int*)(0x4266C7C8UL))
#define bFM3_GPIO_EPFR15_EINT25S1              *((volatile unsigned int*)(0x4266C7CCUL))
#define bFM3_GPIO_EPFR15_EINT26S0              *((volatile unsigned int*)(0x4266C7D0UL))
#define bFM3_GPIO_EPFR15_EINT26S1              *((volatile unsigned int*)(0x4266C7D4UL))
#define bFM3_GPIO_EPFR15_EINT27S0              *((volatile unsigned int*)(0x4266C7D8UL))
#define bFM3_GPIO_EPFR15_EINT27S1              *((volatile unsigned int*)(0x4266C7DCUL))
#define bFM3_GPIO_EPFR15_EINT28S0              *((volatile unsigned int*)(0x4266C7E0UL))
#define bFM3_GPIO_EPFR15_EINT28S1              *((volatile unsigned int*)(0x4266C7E4UL))
#define bFM3_GPIO_EPFR15_EINT29S0              *((volatile unsigned int*)(0x4266C7E8UL))
#define bFM3_GPIO_EPFR15_EINT29S1              *((volatile unsigned int*)(0x4266C7ECUL))
#define bFM3_GPIO_EPFR15_EINT30S0              *((volatile unsigned int*)(0x4266C7F0UL))
#define bFM3_GPIO_EPFR15_EINT30S1              *((volatile unsigned int*)(0x4266C7F4UL))
#define bFM3_GPIO_EPFR15_EINT31S0              *((volatile unsigned int*)(0x4266C7F8UL))
#define bFM3_GPIO_EPFR15_EINT31S1              *((volatile unsigned int*)(0x4266C7FCUL))
#define bFM3_GPIO_PZR0_P0                      *((volatile unsigned int*)(0x4266E000UL))
#define bFM3_GPIO_PZR0_P1                      *((volatile unsigned int*)(0x4266E004UL))
#define bFM3_GPIO_PZR0_P2                      *((volatile unsigned int*)(0x4266E008UL))
#define bFM3_GPIO_PZR0_P3                      *((volatile unsigned int*)(0x4266E00CUL))
#define bFM3_GPIO_PZR0_P4                      *((volatile unsigned int*)(0x4266E010UL))
#define bFM3_GPIO_PZR0_P5                      *((volatile unsigned int*)(0x4266E014UL))
#define bFM3_GPIO_PZR0_P6                      *((volatile unsigned int*)(0x4266E018UL))
#define bFM3_GPIO_PZR0_P7                      *((volatile unsigned int*)(0x4266E01CUL))
#define bFM3_GPIO_PZR0_P8                      *((volatile unsigned int*)(0x4266E020UL))
#define bFM3_GPIO_PZR0_P9                      *((volatile unsigned int*)(0x4266E024UL))
#define bFM3_GPIO_PZR1_P0                      *((volatile unsigned int*)(0x4266E080UL))
#define bFM3_GPIO_PZR1_P1                      *((volatile unsigned int*)(0x4266E084UL))
#define bFM3_GPIO_PZR1_P2                      *((volatile unsigned int*)(0x4266E088UL))
#define bFM3_GPIO_PZR1_P3                      *((volatile unsigned int*)(0x4266E08CUL))
#define bFM3_GPIO_PZR1_P4                      *((volatile unsigned int*)(0x4266E090UL))
#define bFM3_GPIO_PZR1_P5                      *((volatile unsigned int*)(0x4266E094UL))
#define bFM3_GPIO_PZR1_P6                      *((volatile unsigned int*)(0x4266E098UL))
#define bFM3_GPIO_PZR1_P7                      *((volatile unsigned int*)(0x4266E09CUL))
#define bFM3_GPIO_PZR1_P8                      *((volatile unsigned int*)(0x4266E0A0UL))
#define bFM3_GPIO_PZR1_P9                      *((volatile unsigned int*)(0x4266E0A4UL))
#define bFM3_GPIO_PZR1_PA                      *((volatile unsigned int*)(0x4266E0A8UL))
#define bFM3_GPIO_PZR1_PB                      *((volatile unsigned int*)(0x4266E0ACUL))
#define bFM3_GPIO_PZR1_PC                      *((volatile unsigned int*)(0x4266E0B0UL))
#define bFM3_GPIO_PZR1_PD                      *((volatile unsigned int*)(0x4266E0B4UL))
#define bFM3_GPIO_PZR1_PE                      *((volatile unsigned int*)(0x4266E0B8UL))
#define bFM3_GPIO_PZR1_PF                      *((volatile unsigned int*)(0x4266E0BCUL))
#define bFM3_GPIO_PZR2_P0                      *((volatile unsigned int*)(0x4266E100UL))
#define bFM3_GPIO_PZR2_P1                      *((volatile unsigned int*)(0x4266E104UL))
#define bFM3_GPIO_PZR2_P2                      *((volatile unsigned int*)(0x4266E108UL))
#define bFM3_GPIO_PZR2_P3                      *((volatile unsigned int*)(0x4266E10CUL))
#define bFM3_GPIO_PZR2_P4                      *((volatile unsigned int*)(0x4266E110UL))
#define bFM3_GPIO_PZR2_P5                      *((volatile unsigned int*)(0x4266E114UL))
#define bFM3_GPIO_PZR2_P6                      *((volatile unsigned int*)(0x4266E118UL))
#define bFM3_GPIO_PZR2_P7                      *((volatile unsigned int*)(0x4266E11CUL))
#define bFM3_GPIO_PZR2_P8                      *((volatile unsigned int*)(0x4266E120UL))
#define bFM3_GPIO_PZR2_P9                      *((volatile unsigned int*)(0x4266E124UL))
#define bFM3_GPIO_PZR3_P0                      *((volatile unsigned int*)(0x4266E180UL))
#define bFM3_GPIO_PZR3_P1                      *((volatile unsigned int*)(0x4266E184UL))
#define bFM3_GPIO_PZR3_P2                      *((volatile unsigned int*)(0x4266E188UL))
#define bFM3_GPIO_PZR3_P3                      *((volatile unsigned int*)(0x4266E18CUL))
#define bFM3_GPIO_PZR3_P4                      *((volatile unsigned int*)(0x4266E190UL))
#define bFM3_GPIO_PZR3_P5                      *((volatile unsigned int*)(0x4266E194UL))
#define bFM3_GPIO_PZR3_P6                      *((volatile unsigned int*)(0x4266E198UL))
#define bFM3_GPIO_PZR3_P7                      *((volatile unsigned int*)(0x4266E19CUL))
#define bFM3_GPIO_PZR3_P8                      *((volatile unsigned int*)(0x4266E1A0UL))
#define bFM3_GPIO_PZR3_P9                      *((volatile unsigned int*)(0x4266E1A4UL))
#define bFM3_GPIO_PZR3_PA                      *((volatile unsigned int*)(0x4266E1A8UL))
#define bFM3_GPIO_PZR3_PB                      *((volatile unsigned int*)(0x4266E1ACUL))
#define bFM3_GPIO_PZR3_PC                      *((volatile unsigned int*)(0x4266E1B0UL))
#define bFM3_GPIO_PZR3_PD                      *((volatile unsigned int*)(0x4266E1B4UL))
#define bFM3_GPIO_PZR3_PE                      *((volatile unsigned int*)(0x4266E1B8UL))
#define bFM3_GPIO_PZR3_PF                      *((volatile unsigned int*)(0x4266E1BCUL))
#define bFM3_GPIO_PZR4_P0                      *((volatile unsigned int*)(0x4266E200UL))
#define bFM3_GPIO_PZR4_P1                      *((volatile unsigned int*)(0x4266E204UL))
#define bFM3_GPIO_PZR4_P2                      *((volatile unsigned int*)(0x4266E208UL))
#define bFM3_GPIO_PZR4_P3                      *((volatile unsigned int*)(0x4266E20CUL))
#define bFM3_GPIO_PZR4_P4                      *((volatile unsigned int*)(0x4266E210UL))
#define bFM3_GPIO_PZR4_P5                      *((volatile unsigned int*)(0x4266E214UL))
#define bFM3_GPIO_PZR4_P6                      *((volatile unsigned int*)(0x4266E218UL))
#define bFM3_GPIO_PZR4_P7                      *((volatile unsigned int*)(0x4266E21CUL))
#define bFM3_GPIO_PZR4_P8                      *((volatile unsigned int*)(0x4266E220UL))
#define bFM3_GPIO_PZR4_P9                      *((volatile unsigned int*)(0x4266E224UL))
#define bFM3_GPIO_PZR4_PA                      *((volatile unsigned int*)(0x4266E228UL))
#define bFM3_GPIO_PZR4_PB                      *((volatile unsigned int*)(0x4266E22CUL))
#define bFM3_GPIO_PZR4_PC                      *((volatile unsigned int*)(0x4266E230UL))
#define bFM3_GPIO_PZR4_PD                      *((volatile unsigned int*)(0x4266E234UL))
#define bFM3_GPIO_PZR4_PE                      *((volatile unsigned int*)(0x4266E238UL))
#define bFM3_GPIO_PZR5_P0                      *((volatile unsigned int*)(0x4266E280UL))
#define bFM3_GPIO_PZR5_P1                      *((volatile unsigned int*)(0x4266E284UL))
#define bFM3_GPIO_PZR5_P2                      *((volatile unsigned int*)(0x4266E288UL))
#define bFM3_GPIO_PZR5_P3                      *((volatile unsigned int*)(0x4266E28CUL))
#define bFM3_GPIO_PZR5_P4                      *((volatile unsigned int*)(0x4266E290UL))
#define bFM3_GPIO_PZR5_P5                      *((volatile unsigned int*)(0x4266E294UL))
#define bFM3_GPIO_PZR5_P6                      *((volatile unsigned int*)(0x4266E298UL))
#define bFM3_GPIO_PZR5_P7                      *((volatile unsigned int*)(0x4266E29CUL))
#define bFM3_GPIO_PZR5_P8                      *((volatile unsigned int*)(0x4266E2A0UL))
#define bFM3_GPIO_PZR5_P9                      *((volatile unsigned int*)(0x4266E2A4UL))
#define bFM3_GPIO_PZR5_PA                      *((volatile unsigned int*)(0x4266E2A8UL))
#define bFM3_GPIO_PZR5_PB                      *((volatile unsigned int*)(0x4266E2ACUL))
#define bFM3_GPIO_PZR5_PC                      *((volatile unsigned int*)(0x4266E2B0UL))
#define bFM3_GPIO_PZR5_PD                      *((volatile unsigned int*)(0x4266E2B4UL))
#define bFM3_GPIO_PZR6_P0                      *((volatile unsigned int*)(0x4266E300UL))
#define bFM3_GPIO_PZR6_P1                      *((volatile unsigned int*)(0x4266E304UL))
#define bFM3_GPIO_PZR6_P2                      *((volatile unsigned int*)(0x4266E308UL))
#define bFM3_GPIO_PZR7_P0                      *((volatile unsigned int*)(0x4266E380UL))
#define bFM3_GPIO_PZR7_P1                      *((volatile unsigned int*)(0x4266E384UL))
#define bFM3_GPIO_PZR7_P2                      *((volatile unsigned int*)(0x4266E388UL))
#define bFM3_GPIO_PZR7_P3                      *((volatile unsigned int*)(0x4266E38CUL))
#define bFM3_GPIO_PZR7_P4                      *((volatile unsigned int*)(0x4266E390UL))
#define bFM3_GPIO_PZR7_P5                      *((volatile unsigned int*)(0x4266E394UL))
#define bFM3_GPIO_PZR7_P6                      *((volatile unsigned int*)(0x4266E398UL))
#define bFM3_GPIO_PZR7_P7                      *((volatile unsigned int*)(0x4266E39CUL))
#define bFM3_GPIO_PZR7_P8                      *((volatile unsigned int*)(0x4266E3A0UL))
#define bFM3_GPIO_PZR7_P9                      *((volatile unsigned int*)(0x4266E3A4UL))
#define bFM3_GPIO_PZR7_PA                      *((volatile unsigned int*)(0x4266E3A8UL))
#define bFM3_GPIO_PZR7_PB                      *((volatile unsigned int*)(0x4266E3ACUL))
#define bFM3_GPIO_PZR7_PC                      *((volatile unsigned int*)(0x4266E3B0UL))
#define bFM3_GPIO_PZR7_PD                      *((volatile unsigned int*)(0x4266E3B4UL))
#define bFM3_GPIO_PZR7_PE                      *((volatile unsigned int*)(0x4266E3B8UL))
#define bFM3_GPIO_PZR7_PF                      *((volatile unsigned int*)(0x4266E3BCUL))
#define bFM3_GPIO_PZR8_P0                      *((volatile unsigned int*)(0x4266E400UL))
#define bFM3_GPIO_PZR8_P1                      *((volatile unsigned int*)(0x4266E404UL))
#define bFM3_GPIO_PZR8_P2                      *((volatile unsigned int*)(0x4266E408UL))
#define bFM3_GPIO_PZR8_P3                      *((volatile unsigned int*)(0x4266E40CUL))
#define bFM3_GPIO_PZR9_P0                      *((volatile unsigned int*)(0x4266E480UL))
#define bFM3_GPIO_PZR9_P1                      *((volatile unsigned int*)(0x4266E484UL))
#define bFM3_GPIO_PZR9_P2                      *((volatile unsigned int*)(0x4266E488UL))
#define bFM3_GPIO_PZR9_P3                      *((volatile unsigned int*)(0x4266E48CUL))
#define bFM3_GPIO_PZR9_P4                      *((volatile unsigned int*)(0x4266E490UL))
#define bFM3_GPIO_PZR9_P5                      *((volatile unsigned int*)(0x4266E494UL))
#define bFM3_GPIO_PZRA_P0                      *((volatile unsigned int*)(0x4266E500UL))
#define bFM3_GPIO_PZRA_P1                      *((volatile unsigned int*)(0x4266E504UL))
#define bFM3_GPIO_PZRA_P2                      *((volatile unsigned int*)(0x4266E508UL))
#define bFM3_GPIO_PZRA_P3                      *((volatile unsigned int*)(0x4266E50CUL))
#define bFM3_GPIO_PZRA_P4                      *((volatile unsigned int*)(0x4266E510UL))
#define bFM3_GPIO_PZRA_P5                      *((volatile unsigned int*)(0x4266E514UL))
#define bFM3_GPIO_PZRB_P0                      *((volatile unsigned int*)(0x4266E580UL))
#define bFM3_GPIO_PZRB_P1                      *((volatile unsigned int*)(0x4266E584UL))
#define bFM3_GPIO_PZRB_P2                      *((volatile unsigned int*)(0x4266E588UL))
#define bFM3_GPIO_PZRB_P3                      *((volatile unsigned int*)(0x4266E58CUL))
#define bFM3_GPIO_PZRB_P4                      *((volatile unsigned int*)(0x4266E590UL))
#define bFM3_GPIO_PZRB_P5                      *((volatile unsigned int*)(0x4266E594UL))
#define bFM3_GPIO_PZRB_P6                      *((volatile unsigned int*)(0x4266E598UL))
#define bFM3_GPIO_PZRB_P7                      *((volatile unsigned int*)(0x4266E59CUL))
#define bFM3_GPIO_PZRC_P0                      *((volatile unsigned int*)(0x4266E600UL))
#define bFM3_GPIO_PZRC_P1                      *((volatile unsigned int*)(0x4266E604UL))
#define bFM3_GPIO_PZRC_P2                      *((volatile unsigned int*)(0x4266E608UL))
#define bFM3_GPIO_PZRC_P3                      *((volatile unsigned int*)(0x4266E60CUL))
#define bFM3_GPIO_PZRC_P4                      *((volatile unsigned int*)(0x4266E610UL))
#define bFM3_GPIO_PZRC_P5                      *((volatile unsigned int*)(0x4266E614UL))
#define bFM3_GPIO_PZRC_P6                      *((volatile unsigned int*)(0x4266E618UL))
#define bFM3_GPIO_PZRC_P7                      *((volatile unsigned int*)(0x4266E61CUL))
#define bFM3_GPIO_PZRC_P8                      *((volatile unsigned int*)(0x4266E620UL))
#define bFM3_GPIO_PZRC_P9                      *((volatile unsigned int*)(0x4266E624UL))
#define bFM3_GPIO_PZRC_PA                      *((volatile unsigned int*)(0x4266E628UL))
#define bFM3_GPIO_PZRC_PB                      *((volatile unsigned int*)(0x4266E62CUL))
#define bFM3_GPIO_PZRC_PC                      *((volatile unsigned int*)(0x4266E630UL))
#define bFM3_GPIO_PZRC_PD                      *((volatile unsigned int*)(0x4266E634UL))
#define bFM3_GPIO_PZRC_PE                      *((volatile unsigned int*)(0x4266E638UL))
#define bFM3_GPIO_PZRC_PF                      *((volatile unsigned int*)(0x4266E63CUL))
#define bFM3_GPIO_PZRD_P0                      *((volatile unsigned int*)(0x4266E680UL))
#define bFM3_GPIO_PZRD_P1                      *((volatile unsigned int*)(0x4266E684UL))
#define bFM3_GPIO_PZRD_P2                      *((volatile unsigned int*)(0x4266E688UL))
#define bFM3_GPIO_PZRD_P3                      *((volatile unsigned int*)(0x4266E68CUL))
#define bFM3_GPIO_PZRE_P0                      *((volatile unsigned int*)(0x4266E700UL))
#define bFM3_GPIO_PZRE_P2                      *((volatile unsigned int*)(0x4266E708UL))
#define bFM3_GPIO_PZRE_P3                      *((volatile unsigned int*)(0x4266E70CUL))
#define bFM3_GPIO_PZRF_P0                      *((volatile unsigned int*)(0x4266E780UL))
#define bFM3_GPIO_PZRF_P1                      *((volatile unsigned int*)(0x4266E784UL))
#define bFM3_GPIO_PZRF_P2                      *((volatile unsigned int*)(0x4266E788UL))
#define bFM3_GPIO_PZRF_P3                      *((volatile unsigned int*)(0x4266E78CUL))
#define bFM3_GPIO_PZRF_P4                      *((volatile unsigned int*)(0x4266E790UL))
#define bFM3_GPIO_PZRF_P5                      *((volatile unsigned int*)(0x4266E794UL))
#define bFM3_GPIO_PZRF_P6                      *((volatile unsigned int*)(0x4266E798UL))

/* Low voltage detection registers */
#define bFM3_LVD_LVD_CTL_SVHI0                 *((volatile unsigned int*)(0x426A0008UL))
#define bFM3_LVD_LVD_CTL_SVHI1                 *((volatile unsigned int*)(0x426A000CUL))
#define bFM3_LVD_LVD_CTL_SVHI2                 *((volatile unsigned int*)(0x426A0010UL))
#define bFM3_LVD_LVD_CTL_SVHI3                 *((volatile unsigned int*)(0x426A0014UL))
#define bFM3_LVD_LVD_CTL_LVDIE                 *((volatile unsigned int*)(0x426A001CUL))
#define bFM3_LVD_LVD_STR_LVDIR                 *((volatile unsigned int*)(0x426A009CUL))
#define bFM3_LVD_LVD_CLR_LVDCL                 *((volatile unsigned int*)(0x426A011CUL))
#define bFM3_LVD_LVD_STR2_LVDIRDY              *((volatile unsigned int*)(0x426A021CUL))

/* USB clock registers */
#define bFM3_USBETHERNETCLK_UCCR_UCEN0         *((volatile unsigned int*)(0x426C0000UL))
#define bFM3_USBETHERNETCLK_UCCR_UCSEL0        *((volatile unsigned int*)(0x426C0004UL))
#define bFM3_USBETHERNETCLK_UCCR_UCSEL1        *((volatile unsigned int*)(0x426C0008UL))
#define bFM3_USBETHERNETCLK_UCCR_UCEN1         *((volatile unsigned int*)(0x426C000CUL))
#define bFM3_USBETHERNETCLK_UCCR_ECEN          *((volatile unsigned int*)(0x426C0010UL))
#define bFM3_USBETHERNETCLK_UCCR_ECSEL0        *((volatile unsigned int*)(0x426C0014UL))
#define bFM3_USBETHERNETCLK_UCCR_ECSEL1        *((volatile unsigned int*)(0x426C0018UL))
#define bFM3_USBETHERNETCLK_UPCR1_UPLLEN       *((volatile unsigned int*)(0x426C0080UL))
#define bFM3_USBETHERNETCLK_UPCR1_UPINC        *((volatile unsigned int*)(0x426C0084UL))
#define bFM3_USBETHERNETCLK_UPCR2_UPOWT0       *((volatile unsigned int*)(0x426C0100UL))
#define bFM3_USBETHERNETCLK_UPCR2_UPOWT1       *((volatile unsigned int*)(0x426C0104UL))
#define bFM3_USBETHERNETCLK_UPCR2_UPOWT2       *((volatile unsigned int*)(0x426C0108UL))
#define bFM3_USBETHERNETCLK_UPCR3_UPLLK0       *((volatile unsigned int*)(0x426C0180UL))
#define bFM3_USBETHERNETCLK_UPCR3_UPLLK1       *((volatile unsigned int*)(0x426C0184UL))
#define bFM3_USBETHERNETCLK_UPCR3_UPLLK2       *((volatile unsigned int*)(0x426C0188UL))
#define bFM3_USBETHERNETCLK_UPCR3_UPLLK3       *((volatile unsigned int*)(0x426C018CUL))
#define bFM3_USBETHERNETCLK_UPCR3_UPLLK4       *((volatile unsigned int*)(0x426C0190UL))
#define bFM3_USBETHERNETCLK_UPCR4_UPLLN0       *((volatile unsigned int*)(0x426C0200UL))
#define bFM3_USBETHERNETCLK_UPCR4_UPLLN1       *((volatile unsigned int*)(0x426C0204UL))
#define bFM3_USBETHERNETCLK_UPCR4_UPLLN2       *((volatile unsigned int*)(0x426C0208UL))
#define bFM3_USBETHERNETCLK_UPCR4_UPLLN3       *((volatile unsigned int*)(0x426C020CUL))
#define bFM3_USBETHERNETCLK_UPCR4_UPLLN4       *((volatile unsigned int*)(0x426C0210UL))
#define bFM3_USBETHERNETCLK_UPCR4_UPLLN5       *((volatile unsigned int*)(0x426C0214UL))
#define bFM3_USBETHERNETCLK_UPCR4_UPLLN6       *((volatile unsigned int*)(0x426C0218UL))
#define bFM3_USBETHERNETCLK_UP_STR_UPRDY       *((volatile unsigned int*)(0x426C0280UL))
#define bFM3_USBETHERNETCLK_UPINT_ENR_UPCSE    *((volatile unsigned int*)(0x426C0300UL))
#define bFM3_USBETHERNETCLK_UPINT_CLR_UPCSC    *((volatile unsigned int*)(0x426C0380UL))
#define bFM3_USBETHERNETCLK_UPINT_STR_UPCSI    *((volatile unsigned int*)(0x426C0400UL))
#define bFM3_USBETHERNETCLK_UPCR5_UPLLM0       *((volatile unsigned int*)(0x426C0480UL))
#define bFM3_USBETHERNETCLK_UPCR5_UPLLM1       *((volatile unsigned int*)(0x426C0484UL))
#define bFM3_USBETHERNETCLK_UPCR5_UPLLM2       *((volatile unsigned int*)(0x426C0488UL))
#define bFM3_USBETHERNETCLK_UPCR5_UPLLM3       *((volatile unsigned int*)(0x426C048CUL))
#define bFM3_USBETHERNETCLK_UPCR6_UBSR0        *((volatile unsigned int*)(0x426C0500UL))
#define bFM3_USBETHERNETCLK_UPCR6_UBSR1        *((volatile unsigned int*)(0x426C0504UL))
#define bFM3_USBETHERNETCLK_UPCR6_UBSR2        *((volatile unsigned int*)(0x426C0508UL))
#define bFM3_USBETHERNETCLK_UPCR6_UBSR3        *((volatile unsigned int*)(0x426C050CUL))
#define bFM3_USBETHERNETCLK_UPCR7_EPLLEN       *((volatile unsigned int*)(0x426C0580UL))
#define bFM3_USBETHERNETCLK_USBEN0_USBEN0      *((volatile unsigned int*)(0x426C0600UL))
#define bFM3_USBETHERNETCLK_USBEN1_USBEN1      *((volatile unsigned int*)(0x426C0680UL))

/* CAN prescaler register */
#define bFM3_CANPRES_CANPRE_CANPRE0            *((volatile unsigned int*)(0x426E0000UL))
#define bFM3_CANPRES_CANPRE_CANPRE1            *((volatile unsigned int*)(0x426E0004UL))
#define bFM3_CANPRES_CANPRE_CANPRE2            *((volatile unsigned int*)(0x426E0008UL))
#define bFM3_CANPRES_CANPRE_CANPRE3            *((volatile unsigned int*)(0x426E000CUL))

/* UART asynchronous channel 0 registers */
#define bFM3_MFS0_UART_SMR_SOE                 *((volatile unsigned int*)(0x42700000UL))
#define bFM3_MFS0_UART_SMR_BDS                 *((volatile unsigned int*)(0x42700008UL))
#define bFM3_MFS0_UART_SMR_SBL                 *((volatile unsigned int*)(0x4270000CUL))
#define bFM3_MFS0_UART_SMR_WUCR                *((volatile unsigned int*)(0x42700010UL))
#define bFM3_MFS0_UART_SCR_TXE                 *((volatile unsigned int*)(0x42700020UL))
#define bFM3_MFS0_UART_SCR_RXE                 *((volatile unsigned int*)(0x42700024UL))
#define bFM3_MFS0_UART_SCR_TBIE                *((volatile unsigned int*)(0x42700028UL))
#define bFM3_MFS0_UART_SCR_TIE                 *((volatile unsigned int*)(0x4270002CUL))
#define bFM3_MFS0_UART_SCR_RIE                 *((volatile unsigned int*)(0x42700030UL))
#define bFM3_MFS0_UART_SCR_UPCL                *((volatile unsigned int*)(0x4270003CUL))
#define bFM3_MFS0_UART_ESCR_L0                 *((volatile unsigned int*)(0x42700080UL))
#define bFM3_MFS0_UART_ESCR_L1                 *((volatile unsigned int*)(0x42700084UL))
#define bFM3_MFS0_UART_ESCR_L2                 *((volatile unsigned int*)(0x42700088UL))
#define bFM3_MFS0_UART_ESCR_P                  *((volatile unsigned int*)(0x4270008CUL))
#define bFM3_MFS0_UART_ESCR_PEN                *((volatile unsigned int*)(0x42700090UL))
#define bFM3_MFS0_UART_ESCR_INV                *((volatile unsigned int*)(0x42700094UL))
#define bFM3_MFS0_UART_ESCR_ESBL               *((volatile unsigned int*)(0x42700098UL))
#define bFM3_MFS0_UART_ESCR_FLWEN              *((volatile unsigned int*)(0x4270009CUL))
#define bFM3_MFS0_UART_SSR_TBI                 *((volatile unsigned int*)(0x427000A0UL))
#define bFM3_MFS0_UART_SSR_TDRE                *((volatile unsigned int*)(0x427000A4UL))
#define bFM3_MFS0_UART_SSR_RDRF                *((volatile unsigned int*)(0x427000A8UL))
#define bFM3_MFS0_UART_SSR_ORE                 *((volatile unsigned int*)(0x427000ACUL))
#define bFM3_MFS0_UART_SSR_FRE                 *((volatile unsigned int*)(0x427000B0UL))
#define bFM3_MFS0_UART_SSR_PE                  *((volatile unsigned int*)(0x427000B4UL))
#define bFM3_MFS0_UART_SSR_REC                 *((volatile unsigned int*)(0x427000BCUL))
#define bFM3_MFS0_UART_RDR_AD                  *((volatile unsigned int*)(0x42700120UL))
#define bFM3_MFS0_UART_TDR_AD                  *((volatile unsigned int*)(0x42700120UL))
#define bFM3_MFS0_UART_BGR_EXT                 *((volatile unsigned int*)(0x427001BCUL))
#define bFM3_MFS0_UART_BGR1_EXT                *((volatile unsigned int*)(0x427001BCUL))

/* UART synchronous channel 0 registers */
#define bFM3_MFS0_CSIO_SMR_SOE                 *((volatile unsigned int*)(0x42700000UL))
#define bFM3_MFS0_CSIO_SMR_SCKE                *((volatile unsigned int*)(0x42700004UL))
#define bFM3_MFS0_CSIO_SMR_BDS                 *((volatile unsigned int*)(0x42700008UL))
#define bFM3_MFS0_CSIO_SMR_SCINV               *((volatile unsigned int*)(0x4270000CUL))
#define bFM3_MFS0_CSIO_SMR_WUCR                *((volatile unsigned int*)(0x42700010UL))
#define bFM3_MFS0_CSIO_SCR_TXE                 *((volatile unsigned int*)(0x42700020UL))
#define bFM3_MFS0_CSIO_SCR_RXE                 *((volatile unsigned int*)(0x42700024UL))
#define bFM3_MFS0_CSIO_SCR_TBIE                *((volatile unsigned int*)(0x42700028UL))
#define bFM3_MFS0_CSIO_SCR_TIE                 *((volatile unsigned int*)(0x4270002CUL))
#define bFM3_MFS0_CSIO_SCR_RIE                 *((volatile unsigned int*)(0x42700030UL))
#define bFM3_MFS0_CSIO_SCR_SPI                 *((volatile unsigned int*)(0x42700034UL))
#define bFM3_MFS0_CSIO_SCR_MS                  *((volatile unsigned int*)(0x42700038UL))
#define bFM3_MFS0_CSIO_SCR_UPCL                *((volatile unsigned int*)(0x4270003CUL))
#define bFM3_MFS0_CSIO_ESCR_L0                 *((volatile unsigned int*)(0x42700080UL))
#define bFM3_MFS0_CSIO_ESCR_L1                 *((volatile unsigned int*)(0x42700084UL))
#define bFM3_MFS0_CSIO_ESCR_L2                 *((volatile unsigned int*)(0x42700088UL))
#define bFM3_MFS0_CSIO_ESCR_WT0                *((volatile unsigned int*)(0x4270008CUL))
#define bFM3_MFS0_CSIO_ESCR_WT1                *((volatile unsigned int*)(0x42700090UL))
#define bFM3_MFS0_CSIO_ESCR_SOP                *((volatile unsigned int*)(0x4270009CUL))
#define bFM3_MFS0_CSIO_SSR_TBI                 *((volatile unsigned int*)(0x427000A0UL))
#define bFM3_MFS0_CSIO_SSR_TDRE                *((volatile unsigned int*)(0x427000A4UL))
#define bFM3_MFS0_CSIO_SSR_RDRF                *((volatile unsigned int*)(0x427000A8UL))
#define bFM3_MFS0_CSIO_SSR_ORE                 *((volatile unsigned int*)(0x427000ACUL))
#define bFM3_MFS0_CSIO_SSR_REC                 *((volatile unsigned int*)(0x427000BCUL))

/* UART LIN channel 0 registers */
#define bFM3_MFS0_LIN_SMR_SOE                  *((volatile unsigned int*)(0x42700000UL))
#define bFM3_MFS0_LIN_SMR_SBL                  *((volatile unsigned int*)(0x4270000CUL))
#define bFM3_MFS0_LIN_SMR_WUCR                 *((volatile unsigned int*)(0x42700010UL))
#define bFM3_MFS0_LIN_SCR_TXE                  *((volatile unsigned int*)(0x42700020UL))
#define bFM3_MFS0_LIN_SCR_RXE                  *((volatile unsigned int*)(0x42700024UL))
#define bFM3_MFS0_LIN_SCR_TBIE                 *((volatile unsigned int*)(0x42700028UL))
#define bFM3_MFS0_LIN_SCR_TIE                  *((volatile unsigned int*)(0x4270002CUL))
#define bFM3_MFS0_LIN_SCR_RIE                  *((volatile unsigned int*)(0x42700030UL))
#define bFM3_MFS0_LIN_SCR_LBR                  *((volatile unsigned int*)(0x42700034UL))
#define bFM3_MFS0_LIN_SCR_MS                   *((volatile unsigned int*)(0x42700038UL))
#define bFM3_MFS0_LIN_SCR_UPCL                 *((volatile unsigned int*)(0x4270003CUL))
#define bFM3_MFS0_LIN_ESCR_DEL0                *((volatile unsigned int*)(0x42700080UL))
#define bFM3_MFS0_LIN_ESCR_DEL1                *((volatile unsigned int*)(0x42700084UL))
#define bFM3_MFS0_LIN_ESCR_LBL0                *((volatile unsigned int*)(0x42700088UL))
#define bFM3_MFS0_LIN_ESCR_LBL1                *((volatile unsigned int*)(0x4270008CUL))
#define bFM3_MFS0_LIN_ESCR_LBIE                *((volatile unsigned int*)(0x42700090UL))
#define bFM3_MFS0_LIN_ESCR_ESBL                *((volatile unsigned int*)(0x42700098UL))
#define bFM3_MFS0_LIN_SSR_TBI                  *((volatile unsigned int*)(0x427000A0UL))
#define bFM3_MFS0_LIN_SSR_TDRE                 *((volatile unsigned int*)(0x427000A4UL))
#define bFM3_MFS0_LIN_SSR_RDRF                 *((volatile unsigned int*)(0x427000A8UL))
#define bFM3_MFS0_LIN_SSR_ORE                  *((volatile unsigned int*)(0x427000ACUL))
#define bFM3_MFS0_LIN_SSR_FRE                  *((volatile unsigned int*)(0x427000B0UL))
#define bFM3_MFS0_LIN_SSR_LBD                  *((volatile unsigned int*)(0x427000B4UL))
#define bFM3_MFS0_LIN_SSR_REC                  *((volatile unsigned int*)(0x427000BCUL))
#define bFM3_MFS0_LIN_BGR_EXT                  *((volatile unsigned int*)(0x427001BCUL))
#define bFM3_MFS0_LIN_BGR1_EXT                 *((volatile unsigned int*)(0x427001BCUL))

/* I2C channel 0 registers */
#define bFM3_MFS0_I2C_SMR_TIE                  *((volatile unsigned int*)(0x42700008UL))
#define bFM3_MFS0_I2C_SMR_RIE                  *((volatile unsigned int*)(0x4270000CUL))
#define bFM3_MFS0_I2C_SMR_WUCR                 *((volatile unsigned int*)(0x42700010UL))
#define bFM3_MFS0_I2C_IBCR_INT                 *((volatile unsigned int*)(0x42700020UL))
#define bFM3_MFS0_I2C_IBCR_BER                 *((volatile unsigned int*)(0x42700024UL))
#define bFM3_MFS0_I2C_IBCR_INTE                *((volatile unsigned int*)(0x42700028UL))
#define bFM3_MFS0_I2C_IBCR_CNDE                *((volatile unsigned int*)(0x4270002CUL))
#define bFM3_MFS0_I2C_IBCR_WSEL                *((volatile unsigned int*)(0x42700030UL))
#define bFM3_MFS0_I2C_IBCR_ACKE                *((volatile unsigned int*)(0x42700034UL))
#define bFM3_MFS0_I2C_IBCR_ACT                 *((volatile unsigned int*)(0x42700038UL))
#define bFM3_MFS0_I2C_IBCR_SCC                 *((volatile unsigned int*)(0x42700038UL))
#define bFM3_MFS0_I2C_IBCR_MSS                 *((volatile unsigned int*)(0x4270003CUL))
#define bFM3_MFS0_I2C_IBSR_BB                  *((volatile unsigned int*)(0x42700080UL))
#define bFM3_MFS0_I2C_IBSR_SPC                 *((volatile unsigned int*)(0x42700084UL))
#define bFM3_MFS0_I2C_IBSR_RSC                 *((volatile unsigned int*)(0x42700088UL))
#define bFM3_MFS0_I2C_IBSR_AL                  *((volatile unsigned int*)(0x4270008CUL))
#define bFM3_MFS0_I2C_IBSR_TRX                 *((volatile unsigned int*)(0x42700090UL))
#define bFM3_MFS0_I2C_IBSR_RSA                 *((volatile unsigned int*)(0x42700094UL))
#define bFM3_MFS0_I2C_IBSR_RACK                *((volatile unsigned int*)(0x42700098UL))
#define bFM3_MFS0_I2C_IBSR_FBT                 *((volatile unsigned int*)(0x4270009CUL))
#define bFM3_MFS0_I2C_SSR_TBI                  *((volatile unsigned int*)(0x427000A0UL))
#define bFM3_MFS0_I2C_SSR_TDRE                 *((volatile unsigned int*)(0x427000A4UL))
#define bFM3_MFS0_I2C_SSR_RDRF                 *((volatile unsigned int*)(0x427000A8UL))
#define bFM3_MFS0_I2C_SSR_ORE                  *((volatile unsigned int*)(0x427000ACUL))
#define bFM3_MFS0_I2C_SSR_TBIE                 *((volatile unsigned int*)(0x427000B0UL))
#define bFM3_MFS0_I2C_SSR_DMA                  *((volatile unsigned int*)(0x427000B4UL))
#define bFM3_MFS0_I2C_SSR_TSET                 *((volatile unsigned int*)(0x427000B8UL))
#define bFM3_MFS0_I2C_SSR_REC                  *((volatile unsigned int*)(0x427000BCUL))
#define bFM3_MFS0_I2C_ISBA_SA0                 *((volatile unsigned int*)(0x42700200UL))
#define bFM3_MFS0_I2C_ISBA_SA1                 *((volatile unsigned int*)(0x42700204UL))
#define bFM3_MFS0_I2C_ISBA_SA2                 *((volatile unsigned int*)(0x42700208UL))
#define bFM3_MFS0_I2C_ISBA_SA3                 *((volatile unsigned int*)(0x4270020CUL))
#define bFM3_MFS0_I2C_ISBA_SA4                 *((volatile unsigned int*)(0x42700210UL))
#define bFM3_MFS0_I2C_ISBA_SA5                 *((volatile unsigned int*)(0x42700214UL))
#define bFM3_MFS0_I2C_ISBA_SA6                 *((volatile unsigned int*)(0x42700218UL))
#define bFM3_MFS0_I2C_ISBA_SAEN                *((volatile unsigned int*)(0x4270021CUL))
#define bFM3_MFS0_I2C_ISMK_SM0                 *((volatile unsigned int*)(0x42700220UL))
#define bFM3_MFS0_I2C_ISMK_SM1                 *((volatile unsigned int*)(0x42700224UL))
#define bFM3_MFS0_I2C_ISMK_SM2                 *((volatile unsigned int*)(0x42700228UL))
#define bFM3_MFS0_I2C_ISMK_SM3                 *((volatile unsigned int*)(0x4270022CUL))
#define bFM3_MFS0_I2C_ISMK_SM4                 *((volatile unsigned int*)(0x42700230UL))
#define bFM3_MFS0_I2C_ISMK_SM5                 *((volatile unsigned int*)(0x42700234UL))
#define bFM3_MFS0_I2C_ISMK_SM6                 *((volatile unsigned int*)(0x42700238UL))
#define bFM3_MFS0_I2C_ISMK_EN                  *((volatile unsigned int*)(0x4270023CUL))

/* UART asynchronous channel 1 registers */
#define bFM3_MFS1_UART_SMR_SOE                 *((volatile unsigned int*)(0x42702000UL))
#define bFM3_MFS1_UART_SMR_BDS                 *((volatile unsigned int*)(0x42702008UL))
#define bFM3_MFS1_UART_SMR_SBL                 *((volatile unsigned int*)(0x4270200CUL))
#define bFM3_MFS1_UART_SMR_WUCR                *((volatile unsigned int*)(0x42702010UL))
#define bFM3_MFS1_UART_SCR_TXE                 *((volatile unsigned int*)(0x42702020UL))
#define bFM3_MFS1_UART_SCR_RXE                 *((volatile unsigned int*)(0x42702024UL))
#define bFM3_MFS1_UART_SCR_TBIE                *((volatile unsigned int*)(0x42702028UL))
#define bFM3_MFS1_UART_SCR_TIE                 *((volatile unsigned int*)(0x4270202CUL))
#define bFM3_MFS1_UART_SCR_RIE                 *((volatile unsigned int*)(0x42702030UL))
#define bFM3_MFS1_UART_SCR_UPCL                *((volatile unsigned int*)(0x4270203CUL))
#define bFM3_MFS1_UART_ESCR_L0                 *((volatile unsigned int*)(0x42702080UL))
#define bFM3_MFS1_UART_ESCR_L1                 *((volatile unsigned int*)(0x42702084UL))
#define bFM3_MFS1_UART_ESCR_L2                 *((volatile unsigned int*)(0x42702088UL))
#define bFM3_MFS1_UART_ESCR_P                  *((volatile unsigned int*)(0x4270208CUL))
#define bFM3_MFS1_UART_ESCR_PEN                *((volatile unsigned int*)(0x42702090UL))
#define bFM3_MFS1_UART_ESCR_INV                *((volatile unsigned int*)(0x42702094UL))
#define bFM3_MFS1_UART_ESCR_ESBL               *((volatile unsigned int*)(0x42702098UL))
#define bFM3_MFS1_UART_ESCR_FLWEN              *((volatile unsigned int*)(0x4270209CUL))
#define bFM3_MFS1_UART_SSR_TBI                 *((volatile unsigned int*)(0x427020A0UL))
#define bFM3_MFS1_UART_SSR_TDRE                *((volatile unsigned int*)(0x427020A4UL))
#define bFM3_MFS1_UART_SSR_RDRF                *((volatile unsigned int*)(0x427020A8UL))
#define bFM3_MFS1_UART_SSR_ORE                 *((volatile unsigned int*)(0x427020ACUL))
#define bFM3_MFS1_UART_SSR_FRE                 *((volatile unsigned int*)(0x427020B0UL))
#define bFM3_MFS1_UART_SSR_PE                  *((volatile unsigned int*)(0x427020B4UL))
#define bFM3_MFS1_UART_SSR_REC                 *((volatile unsigned int*)(0x427020BCUL))
#define bFM3_MFS1_UART_RDR_AD                  *((volatile unsigned int*)(0x42702120UL))
#define bFM3_MFS1_UART_TDR_AD                  *((volatile unsigned int*)(0x42702120UL))
#define bFM3_MFS1_UART_BGR_EXT                 *((volatile unsigned int*)(0x427021BCUL))
#define bFM3_MFS1_UART_BGR1_EXT                *((volatile unsigned int*)(0x427021BCUL))

/* UART synchronous channel 1 registers */
#define bFM3_MFS1_CSIO_SMR_SOE                 *((volatile unsigned int*)(0x42702000UL))
#define bFM3_MFS1_CSIO_SMR_SCKE                *((volatile unsigned int*)(0x42702004UL))
#define bFM3_MFS1_CSIO_SMR_BDS                 *((volatile unsigned int*)(0x42702008UL))
#define bFM3_MFS1_CSIO_SMR_SCINV               *((volatile unsigned int*)(0x4270200CUL))
#define bFM3_MFS1_CSIO_SMR_WUCR                *((volatile unsigned int*)(0x42702010UL))
#define bFM3_MFS1_CSIO_SCR_TXE                 *((volatile unsigned int*)(0x42702020UL))
#define bFM3_MFS1_CSIO_SCR_RXE                 *((volatile unsigned int*)(0x42702024UL))
#define bFM3_MFS1_CSIO_SCR_TBIE                *((volatile unsigned int*)(0x42702028UL))
#define bFM3_MFS1_CSIO_SCR_TIE                 *((volatile unsigned int*)(0x4270202CUL))
#define bFM3_MFS1_CSIO_SCR_RIE                 *((volatile unsigned int*)(0x42702030UL))
#define bFM3_MFS1_CSIO_SCR_SPI                 *((volatile unsigned int*)(0x42702034UL))
#define bFM3_MFS1_CSIO_SCR_MS                  *((volatile unsigned int*)(0x42702038UL))
#define bFM3_MFS1_CSIO_SCR_UPCL                *((volatile unsigned int*)(0x4270203CUL))
#define bFM3_MFS1_CSIO_ESCR_L0                 *((volatile unsigned int*)(0x42702080UL))
#define bFM3_MFS1_CSIO_ESCR_L1                 *((volatile unsigned int*)(0x42702084UL))
#define bFM3_MFS1_CSIO_ESCR_L2                 *((volatile unsigned int*)(0x42702088UL))
#define bFM3_MFS1_CSIO_ESCR_WT0                *((volatile unsigned int*)(0x4270208CUL))
#define bFM3_MFS1_CSIO_ESCR_WT1                *((volatile unsigned int*)(0x42702090UL))
#define bFM3_MFS1_CSIO_ESCR_SOP                *((volatile unsigned int*)(0x4270209CUL))
#define bFM3_MFS1_CSIO_SSR_TBI                 *((volatile unsigned int*)(0x427020A0UL))
#define bFM3_MFS1_CSIO_SSR_TDRE                *((volatile unsigned int*)(0x427020A4UL))
#define bFM3_MFS1_CSIO_SSR_RDRF                *((volatile unsigned int*)(0x427020A8UL))
#define bFM3_MFS1_CSIO_SSR_ORE                 *((volatile unsigned int*)(0x427020ACUL))
#define bFM3_MFS1_CSIO_SSR_REC                 *((volatile unsigned int*)(0x427020BCUL))

/* UART LIN channel 1 registers */
#define bFM3_MFS1_LIN_SMR_SOE                  *((volatile unsigned int*)(0x42702000UL))
#define bFM3_MFS1_LIN_SMR_SBL                  *((volatile unsigned int*)(0x4270200CUL))
#define bFM3_MFS1_LIN_SMR_WUCR                 *((volatile unsigned int*)(0x42702010UL))
#define bFM3_MFS1_LIN_SCR_TXE                  *((volatile unsigned int*)(0x42702020UL))
#define bFM3_MFS1_LIN_SCR_RXE                  *((volatile unsigned int*)(0x42702024UL))
#define bFM3_MFS1_LIN_SCR_TBIE                 *((volatile unsigned int*)(0x42702028UL))
#define bFM3_MFS1_LIN_SCR_TIE                  *((volatile unsigned int*)(0x4270202CUL))
#define bFM3_MFS1_LIN_SCR_RIE                  *((volatile unsigned int*)(0x42702030UL))
#define bFM3_MFS1_LIN_SCR_LBR                  *((volatile unsigned int*)(0x42702034UL))
#define bFM3_MFS1_LIN_SCR_MS                   *((volatile unsigned int*)(0x42702038UL))
#define bFM3_MFS1_LIN_SCR_UPCL                 *((volatile unsigned int*)(0x4270203CUL))
#define bFM3_MFS1_LIN_ESCR_DEL0                *((volatile unsigned int*)(0x42702080UL))
#define bFM3_MFS1_LIN_ESCR_DEL1                *((volatile unsigned int*)(0x42702084UL))
#define bFM3_MFS1_LIN_ESCR_LBL0                *((volatile unsigned int*)(0x42702088UL))
#define bFM3_MFS1_LIN_ESCR_LBL1                *((volatile unsigned int*)(0x4270208CUL))
#define bFM3_MFS1_LIN_ESCR_LBIE                *((volatile unsigned int*)(0x42702090UL))
#define bFM3_MFS1_LIN_ESCR_ESBL                *((volatile unsigned int*)(0x42702098UL))
#define bFM3_MFS1_LIN_SSR_TBI                  *((volatile unsigned int*)(0x427020A0UL))
#define bFM3_MFS1_LIN_SSR_TDRE                 *((volatile unsigned int*)(0x427020A4UL))
#define bFM3_MFS1_LIN_SSR_RDRF                 *((volatile unsigned int*)(0x427020A8UL))
#define bFM3_MFS1_LIN_SSR_ORE                  *((volatile unsigned int*)(0x427020ACUL))
#define bFM3_MFS1_LIN_SSR_FRE                  *((volatile unsigned int*)(0x427020B0UL))
#define bFM3_MFS1_LIN_SSR_LBD                  *((volatile unsigned int*)(0x427020B4UL))
#define bFM3_MFS1_LIN_SSR_REC                  *((volatile unsigned int*)(0x427020BCUL))
#define bFM3_MFS1_LIN_BGR_EXT                  *((volatile unsigned int*)(0x427021BCUL))
#define bFM3_MFS1_LIN_BGR1_EXT                 *((volatile unsigned int*)(0x427021BCUL))

/* I2C channel 1 registers */
#define bFM3_MFS1_I2C_SMR_TIE                  *((volatile unsigned int*)(0x42702008UL))
#define bFM3_MFS1_I2C_SMR_RIE                  *((volatile unsigned int*)(0x4270200CUL))
#define bFM3_MFS1_I2C_SMR_WUCR                 *((volatile unsigned int*)(0x42702010UL))
#define bFM3_MFS1_I2C_IBCR_INT                 *((volatile unsigned int*)(0x42702020UL))
#define bFM3_MFS1_I2C_IBCR_BER                 *((volatile unsigned int*)(0x42702024UL))
#define bFM3_MFS1_I2C_IBCR_INTE                *((volatile unsigned int*)(0x42702028UL))
#define bFM3_MFS1_I2C_IBCR_CNDE                *((volatile unsigned int*)(0x4270202CUL))
#define bFM3_MFS1_I2C_IBCR_WSEL                *((volatile unsigned int*)(0x42702030UL))
#define bFM3_MFS1_I2C_IBCR_ACKE                *((volatile unsigned int*)(0x42702034UL))
#define bFM3_MFS1_I2C_IBCR_ACT                 *((volatile unsigned int*)(0x42702038UL))
#define bFM3_MFS1_I2C_IBCR_SCC                 *((volatile unsigned int*)(0x42702038UL))
#define bFM3_MFS1_I2C_IBCR_MSS                 *((volatile unsigned int*)(0x4270203CUL))
#define bFM3_MFS1_I2C_IBSR_BB                  *((volatile unsigned int*)(0x42702080UL))
#define bFM3_MFS1_I2C_IBSR_SPC                 *((volatile unsigned int*)(0x42702084UL))
#define bFM3_MFS1_I2C_IBSR_RSC                 *((volatile unsigned int*)(0x42702088UL))
#define bFM3_MFS1_I2C_IBSR_AL                  *((volatile unsigned int*)(0x4270208CUL))
#define bFM3_MFS1_I2C_IBSR_TRX                 *((volatile unsigned int*)(0x42702090UL))
#define bFM3_MFS1_I2C_IBSR_RSA                 *((volatile unsigned int*)(0x42702094UL))
#define bFM3_MFS1_I2C_IBSR_RACK                *((volatile unsigned int*)(0x42702098UL))
#define bFM3_MFS1_I2C_IBSR_FBT                 *((volatile unsigned int*)(0x4270209CUL))
#define bFM3_MFS1_I2C_SSR_TBI                  *((volatile unsigned int*)(0x427020A0UL))
#define bFM3_MFS1_I2C_SSR_TDRE                 *((volatile unsigned int*)(0x427020A4UL))
#define bFM3_MFS1_I2C_SSR_RDRF                 *((volatile unsigned int*)(0x427020A8UL))
#define bFM3_MFS1_I2C_SSR_ORE                  *((volatile unsigned int*)(0x427020ACUL))
#define bFM3_MFS1_I2C_SSR_TBIE                 *((volatile unsigned int*)(0x427020B0UL))
#define bFM3_MFS1_I2C_SSR_DMA                  *((volatile unsigned int*)(0x427020B4UL))
#define bFM3_MFS1_I2C_SSR_TSET                 *((volatile unsigned int*)(0x427020B8UL))
#define bFM3_MFS1_I2C_SSR_REC                  *((volatile unsigned int*)(0x427020BCUL))
#define bFM3_MFS1_I2C_ISBA_SA0                 *((volatile unsigned int*)(0x42702200UL))
#define bFM3_MFS1_I2C_ISBA_SA1                 *((volatile unsigned int*)(0x42702204UL))
#define bFM3_MFS1_I2C_ISBA_SA2                 *((volatile unsigned int*)(0x42702208UL))
#define bFM3_MFS1_I2C_ISBA_SA3                 *((volatile unsigned int*)(0x4270220CUL))
#define bFM3_MFS1_I2C_ISBA_SA4                 *((volatile unsigned int*)(0x42702210UL))
#define bFM3_MFS1_I2C_ISBA_SA5                 *((volatile unsigned int*)(0x42702214UL))
#define bFM3_MFS1_I2C_ISBA_SA6                 *((volatile unsigned int*)(0x42702218UL))
#define bFM3_MFS1_I2C_ISBA_SAEN                *((volatile unsigned int*)(0x4270221CUL))
#define bFM3_MFS1_I2C_ISMK_SM0                 *((volatile unsigned int*)(0x42702220UL))
#define bFM3_MFS1_I2C_ISMK_SM1                 *((volatile unsigned int*)(0x42702224UL))
#define bFM3_MFS1_I2C_ISMK_SM2                 *((volatile unsigned int*)(0x42702228UL))
#define bFM3_MFS1_I2C_ISMK_SM3                 *((volatile unsigned int*)(0x4270222CUL))
#define bFM3_MFS1_I2C_ISMK_SM4                 *((volatile unsigned int*)(0x42702230UL))
#define bFM3_MFS1_I2C_ISMK_SM5                 *((volatile unsigned int*)(0x42702234UL))
#define bFM3_MFS1_I2C_ISMK_SM6                 *((volatile unsigned int*)(0x42702238UL))
#define bFM3_MFS1_I2C_ISMK_EN                  *((volatile unsigned int*)(0x4270223CUL))

/* UART asynchronous channel 2 registers */
#define bFM3_MFS2_UART_SMR_SOE                 *((volatile unsigned int*)(0x42704000UL))
#define bFM3_MFS2_UART_SMR_BDS                 *((volatile unsigned int*)(0x42704008UL))
#define bFM3_MFS2_UART_SMR_SBL                 *((volatile unsigned int*)(0x4270400CUL))
#define bFM3_MFS2_UART_SMR_WUCR                *((volatile unsigned int*)(0x42704010UL))
#define bFM3_MFS2_UART_SCR_TXE                 *((volatile unsigned int*)(0x42704020UL))
#define bFM3_MFS2_UART_SCR_RXE                 *((volatile unsigned int*)(0x42704024UL))
#define bFM3_MFS2_UART_SCR_TBIE                *((volatile unsigned int*)(0x42704028UL))
#define bFM3_MFS2_UART_SCR_TIE                 *((volatile unsigned int*)(0x4270402CUL))
#define bFM3_MFS2_UART_SCR_RIE                 *((volatile unsigned int*)(0x42704030UL))
#define bFM3_MFS2_UART_SCR_UPCL                *((volatile unsigned int*)(0x4270403CUL))
#define bFM3_MFS2_UART_ESCR_L0                 *((volatile unsigned int*)(0x42704080UL))
#define bFM3_MFS2_UART_ESCR_L1                 *((volatile unsigned int*)(0x42704084UL))
#define bFM3_MFS2_UART_ESCR_L2                 *((volatile unsigned int*)(0x42704088UL))
#define bFM3_MFS2_UART_ESCR_P                  *((volatile unsigned int*)(0x4270408CUL))
#define bFM3_MFS2_UART_ESCR_PEN                *((volatile unsigned int*)(0x42704090UL))
#define bFM3_MFS2_UART_ESCR_INV                *((volatile unsigned int*)(0x42704094UL))
#define bFM3_MFS2_UART_ESCR_ESBL               *((volatile unsigned int*)(0x42704098UL))
#define bFM3_MFS2_UART_ESCR_FLWEN              *((volatile unsigned int*)(0x4270409CUL))
#define bFM3_MFS2_UART_SSR_TBI                 *((volatile unsigned int*)(0x427040A0UL))
#define bFM3_MFS2_UART_SSR_TDRE                *((volatile unsigned int*)(0x427040A4UL))
#define bFM3_MFS2_UART_SSR_RDRF                *((volatile unsigned int*)(0x427040A8UL))
#define bFM3_MFS2_UART_SSR_ORE                 *((volatile unsigned int*)(0x427040ACUL))
#define bFM3_MFS2_UART_SSR_FRE                 *((volatile unsigned int*)(0x427040B0UL))
#define bFM3_MFS2_UART_SSR_PE                  *((volatile unsigned int*)(0x427040B4UL))
#define bFM3_MFS2_UART_SSR_REC                 *((volatile unsigned int*)(0x427040BCUL))
#define bFM3_MFS2_UART_RDR_AD                  *((volatile unsigned int*)(0x42704120UL))
#define bFM3_MFS2_UART_TDR_AD                  *((volatile unsigned int*)(0x42704120UL))
#define bFM3_MFS2_UART_BGR_EXT                 *((volatile unsigned int*)(0x427041BCUL))
#define bFM3_MFS2_UART_BGR1_EXT                *((volatile unsigned int*)(0x427041BCUL))

/* UART synchronous channel 2 registers */
#define bFM3_MFS2_CSIO_SMR_SOE                 *((volatile unsigned int*)(0x42704000UL))
#define bFM3_MFS2_CSIO_SMR_SCKE                *((volatile unsigned int*)(0x42704004UL))
#define bFM3_MFS2_CSIO_SMR_BDS                 *((volatile unsigned int*)(0x42704008UL))
#define bFM3_MFS2_CSIO_SMR_SCINV               *((volatile unsigned int*)(0x4270400CUL))
#define bFM3_MFS2_CSIO_SMR_WUCR                *((volatile unsigned int*)(0x42704010UL))
#define bFM3_MFS2_CSIO_SCR_TXE                 *((volatile unsigned int*)(0x42704020UL))
#define bFM3_MFS2_CSIO_SCR_RXE                 *((volatile unsigned int*)(0x42704024UL))
#define bFM3_MFS2_CSIO_SCR_TBIE                *((volatile unsigned int*)(0x42704028UL))
#define bFM3_MFS2_CSIO_SCR_TIE                 *((volatile unsigned int*)(0x4270402CUL))
#define bFM3_MFS2_CSIO_SCR_RIE                 *((volatile unsigned int*)(0x42704030UL))
#define bFM3_MFS2_CSIO_SCR_SPI                 *((volatile unsigned int*)(0x42704034UL))
#define bFM3_MFS2_CSIO_SCR_MS                  *((volatile unsigned int*)(0x42704038UL))
#define bFM3_MFS2_CSIO_SCR_UPCL                *((volatile unsigned int*)(0x4270403CUL))
#define bFM3_MFS2_CSIO_ESCR_L0                 *((volatile unsigned int*)(0x42704080UL))
#define bFM3_MFS2_CSIO_ESCR_L1                 *((volatile unsigned int*)(0x42704084UL))
#define bFM3_MFS2_CSIO_ESCR_L2                 *((volatile unsigned int*)(0x42704088UL))
#define bFM3_MFS2_CSIO_ESCR_WT0                *((volatile unsigned int*)(0x4270408CUL))
#define bFM3_MFS2_CSIO_ESCR_WT1                *((volatile unsigned int*)(0x42704090UL))
#define bFM3_MFS2_CSIO_ESCR_SOP                *((volatile unsigned int*)(0x4270409CUL))
#define bFM3_MFS2_CSIO_SSR_TBI                 *((volatile unsigned int*)(0x427040A0UL))
#define bFM3_MFS2_CSIO_SSR_TDRE                *((volatile unsigned int*)(0x427040A4UL))
#define bFM3_MFS2_CSIO_SSR_RDRF                *((volatile unsigned int*)(0x427040A8UL))
#define bFM3_MFS2_CSIO_SSR_ORE                 *((volatile unsigned int*)(0x427040ACUL))
#define bFM3_MFS2_CSIO_SSR_REC                 *((volatile unsigned int*)(0x427040BCUL))

/* UART LIN channel 2 registers */
#define bFM3_MFS2_LIN_SMR_SOE                  *((volatile unsigned int*)(0x42704000UL))
#define bFM3_MFS2_LIN_SMR_SBL                  *((volatile unsigned int*)(0x4270400CUL))
#define bFM3_MFS2_LIN_SMR_WUCR                 *((volatile unsigned int*)(0x42704010UL))
#define bFM3_MFS2_LIN_SCR_TXE                  *((volatile unsigned int*)(0x42704020UL))
#define bFM3_MFS2_LIN_SCR_RXE                  *((volatile unsigned int*)(0x42704024UL))
#define bFM3_MFS2_LIN_SCR_TBIE                 *((volatile unsigned int*)(0x42704028UL))
#define bFM3_MFS2_LIN_SCR_TIE                  *((volatile unsigned int*)(0x4270402CUL))
#define bFM3_MFS2_LIN_SCR_RIE                  *((volatile unsigned int*)(0x42704030UL))
#define bFM3_MFS2_LIN_SCR_LBR                  *((volatile unsigned int*)(0x42704034UL))
#define bFM3_MFS2_LIN_SCR_MS                   *((volatile unsigned int*)(0x42704038UL))
#define bFM3_MFS2_LIN_SCR_UPCL                 *((volatile unsigned int*)(0x4270403CUL))
#define bFM3_MFS2_LIN_ESCR_DEL0                *((volatile unsigned int*)(0x42704080UL))
#define bFM3_MFS2_LIN_ESCR_DEL1                *((volatile unsigned int*)(0x42704084UL))
#define bFM3_MFS2_LIN_ESCR_LBL0                *((volatile unsigned int*)(0x42704088UL))
#define bFM3_MFS2_LIN_ESCR_LBL1                *((volatile unsigned int*)(0x4270408CUL))
#define bFM3_MFS2_LIN_ESCR_LBIE                *((volatile unsigned int*)(0x42704090UL))
#define bFM3_MFS2_LIN_ESCR_ESBL                *((volatile unsigned int*)(0x42704098UL))
#define bFM3_MFS2_LIN_SSR_TBI                  *((volatile unsigned int*)(0x427040A0UL))
#define bFM3_MFS2_LIN_SSR_TDRE                 *((volatile unsigned int*)(0x427040A4UL))
#define bFM3_MFS2_LIN_SSR_RDRF                 *((volatile unsigned int*)(0x427040A8UL))
#define bFM3_MFS2_LIN_SSR_ORE                  *((volatile unsigned int*)(0x427040ACUL))
#define bFM3_MFS2_LIN_SSR_FRE                  *((volatile unsigned int*)(0x427040B0UL))
#define bFM3_MFS2_LIN_SSR_LBD                  *((volatile unsigned int*)(0x427040B4UL))
#define bFM3_MFS2_LIN_SSR_REC                  *((volatile unsigned int*)(0x427040BCUL))
#define bFM3_MFS2_LIN_BGR_EXT                  *((volatile unsigned int*)(0x427041BCUL))
#define bFM3_MFS2_LIN_BGR1_EXT                 *((volatile unsigned int*)(0x427041BCUL))

/* I2C channel 2 registers */
#define bFM3_MFS2_I2C_SMR_TIE                  *((volatile unsigned int*)(0x42704008UL))
#define bFM3_MFS2_I2C_SMR_RIE                  *((volatile unsigned int*)(0x4270400CUL))
#define bFM3_MFS2_I2C_SMR_WUCR                 *((volatile unsigned int*)(0x42704010UL))
#define bFM3_MFS2_I2C_IBCR_INT                 *((volatile unsigned int*)(0x42704020UL))
#define bFM3_MFS2_I2C_IBCR_BER                 *((volatile unsigned int*)(0x42704024UL))
#define bFM3_MFS2_I2C_IBCR_INTE                *((volatile unsigned int*)(0x42704028UL))
#define bFM3_MFS2_I2C_IBCR_CNDE                *((volatile unsigned int*)(0x4270402CUL))
#define bFM3_MFS2_I2C_IBCR_WSEL                *((volatile unsigned int*)(0x42704030UL))
#define bFM3_MFS2_I2C_IBCR_ACKE                *((volatile unsigned int*)(0x42704034UL))
#define bFM3_MFS2_I2C_IBCR_ACT                 *((volatile unsigned int*)(0x42704038UL))
#define bFM3_MFS2_I2C_IBCR_SCC                 *((volatile unsigned int*)(0x42704038UL))
#define bFM3_MFS2_I2C_IBCR_MSS                 *((volatile unsigned int*)(0x4270403CUL))
#define bFM3_MFS2_I2C_IBSR_BB                  *((volatile unsigned int*)(0x42704080UL))
#define bFM3_MFS2_I2C_IBSR_SPC                 *((volatile unsigned int*)(0x42704084UL))
#define bFM3_MFS2_I2C_IBSR_RSC                 *((volatile unsigned int*)(0x42704088UL))
#define bFM3_MFS2_I2C_IBSR_AL                  *((volatile unsigned int*)(0x4270408CUL))
#define bFM3_MFS2_I2C_IBSR_TRX                 *((volatile unsigned int*)(0x42704090UL))
#define bFM3_MFS2_I2C_IBSR_RSA                 *((volatile unsigned int*)(0x42704094UL))
#define bFM3_MFS2_I2C_IBSR_RACK                *((volatile unsigned int*)(0x42704098UL))
#define bFM3_MFS2_I2C_IBSR_FBT                 *((volatile unsigned int*)(0x4270409CUL))
#define bFM3_MFS2_I2C_SSR_TBI                  *((volatile unsigned int*)(0x427040A0UL))
#define bFM3_MFS2_I2C_SSR_TDRE                 *((volatile unsigned int*)(0x427040A4UL))
#define bFM3_MFS2_I2C_SSR_RDRF                 *((volatile unsigned int*)(0x427040A8UL))
#define bFM3_MFS2_I2C_SSR_ORE                  *((volatile unsigned int*)(0x427040ACUL))
#define bFM3_MFS2_I2C_SSR_TBIE                 *((volatile unsigned int*)(0x427040B0UL))
#define bFM3_MFS2_I2C_SSR_DMA                  *((volatile unsigned int*)(0x427040B4UL))
#define bFM3_MFS2_I2C_SSR_TSET                 *((volatile unsigned int*)(0x427040B8UL))
#define bFM3_MFS2_I2C_SSR_REC                  *((volatile unsigned int*)(0x427040BCUL))
#define bFM3_MFS2_I2C_ISBA_SA0                 *((volatile unsigned int*)(0x42704200UL))
#define bFM3_MFS2_I2C_ISBA_SA1                 *((volatile unsigned int*)(0x42704204UL))
#define bFM3_MFS2_I2C_ISBA_SA2                 *((volatile unsigned int*)(0x42704208UL))
#define bFM3_MFS2_I2C_ISBA_SA3                 *((volatile unsigned int*)(0x4270420CUL))
#define bFM3_MFS2_I2C_ISBA_SA4                 *((volatile unsigned int*)(0x42704210UL))
#define bFM3_MFS2_I2C_ISBA_SA5                 *((volatile unsigned int*)(0x42704214UL))
#define bFM3_MFS2_I2C_ISBA_SA6                 *((volatile unsigned int*)(0x42704218UL))
#define bFM3_MFS2_I2C_ISBA_SAEN                *((volatile unsigned int*)(0x4270421CUL))
#define bFM3_MFS2_I2C_ISMK_SM0                 *((volatile unsigned int*)(0x42704220UL))
#define bFM3_MFS2_I2C_ISMK_SM1                 *((volatile unsigned int*)(0x42704224UL))
#define bFM3_MFS2_I2C_ISMK_SM2                 *((volatile unsigned int*)(0x42704228UL))
#define bFM3_MFS2_I2C_ISMK_SM3                 *((volatile unsigned int*)(0x4270422CUL))
#define bFM3_MFS2_I2C_ISMK_SM4                 *((volatile unsigned int*)(0x42704230UL))
#define bFM3_MFS2_I2C_ISMK_SM5                 *((volatile unsigned int*)(0x42704234UL))
#define bFM3_MFS2_I2C_ISMK_SM6                 *((volatile unsigned int*)(0x42704238UL))
#define bFM3_MFS2_I2C_ISMK_EN                  *((volatile unsigned int*)(0x4270423CUL))

/* UART asynchronous channel 3 registers */
#define bFM3_MFS3_UART_SMR_SOE                 *((volatile unsigned int*)(0x42706000UL))
#define bFM3_MFS3_UART_SMR_BDS                 *((volatile unsigned int*)(0x42706008UL))
#define bFM3_MFS3_UART_SMR_SBL                 *((volatile unsigned int*)(0x4270600CUL))
#define bFM3_MFS3_UART_SMR_WUCR                *((volatile unsigned int*)(0x42706010UL))
#define bFM3_MFS3_UART_SCR_TXE                 *((volatile unsigned int*)(0x42706020UL))
#define bFM3_MFS3_UART_SCR_RXE                 *((volatile unsigned int*)(0x42706024UL))
#define bFM3_MFS3_UART_SCR_TBIE                *((volatile unsigned int*)(0x42706028UL))
#define bFM3_MFS3_UART_SCR_TIE                 *((volatile unsigned int*)(0x4270602CUL))
#define bFM3_MFS3_UART_SCR_RIE                 *((volatile unsigned int*)(0x42706030UL))
#define bFM3_MFS3_UART_SCR_UPCL                *((volatile unsigned int*)(0x4270603CUL))
#define bFM3_MFS3_UART_ESCR_L0                 *((volatile unsigned int*)(0x42706080UL))
#define bFM3_MFS3_UART_ESCR_L1                 *((volatile unsigned int*)(0x42706084UL))
#define bFM3_MFS3_UART_ESCR_L2                 *((volatile unsigned int*)(0x42706088UL))
#define bFM3_MFS3_UART_ESCR_P                  *((volatile unsigned int*)(0x4270608CUL))
#define bFM3_MFS3_UART_ESCR_PEN                *((volatile unsigned int*)(0x42706090UL))
#define bFM3_MFS3_UART_ESCR_INV                *((volatile unsigned int*)(0x42706094UL))
#define bFM3_MFS3_UART_ESCR_ESBL               *((volatile unsigned int*)(0x42706098UL))
#define bFM3_MFS3_UART_ESCR_FLWEN              *((volatile unsigned int*)(0x4270609CUL))
#define bFM3_MFS3_UART_SSR_TBI                 *((volatile unsigned int*)(0x427060A0UL))
#define bFM3_MFS3_UART_SSR_TDRE                *((volatile unsigned int*)(0x427060A4UL))
#define bFM3_MFS3_UART_SSR_RDRF                *((volatile unsigned int*)(0x427060A8UL))
#define bFM3_MFS3_UART_SSR_ORE                 *((volatile unsigned int*)(0x427060ACUL))
#define bFM3_MFS3_UART_SSR_FRE                 *((volatile unsigned int*)(0x427060B0UL))
#define bFM3_MFS3_UART_SSR_PE                  *((volatile unsigned int*)(0x427060B4UL))
#define bFM3_MFS3_UART_SSR_REC                 *((volatile unsigned int*)(0x427060BCUL))
#define bFM3_MFS3_UART_RDR_AD                  *((volatile unsigned int*)(0x42706120UL))
#define bFM3_MFS3_UART_TDR_AD                  *((volatile unsigned int*)(0x42706120UL))
#define bFM3_MFS3_UART_BGR_EXT                 *((volatile unsigned int*)(0x427061BCUL))
#define bFM3_MFS3_UART_BGR1_EXT                *((volatile unsigned int*)(0x427061BCUL))

/* UART synchronous channel 3 registers */
#define bFM3_MFS3_CSIO_SMR_SOE                 *((volatile unsigned int*)(0x42706000UL))
#define bFM3_MFS3_CSIO_SMR_SCKE                *((volatile unsigned int*)(0x42706004UL))
#define bFM3_MFS3_CSIO_SMR_BDS                 *((volatile unsigned int*)(0x42706008UL))
#define bFM3_MFS3_CSIO_SMR_SCINV               *((volatile unsigned int*)(0x4270600CUL))
#define bFM3_MFS3_CSIO_SMR_WUCR                *((volatile unsigned int*)(0x42706010UL))
#define bFM3_MFS3_CSIO_SCR_TXE                 *((volatile unsigned int*)(0x42706020UL))
#define bFM3_MFS3_CSIO_SCR_RXE                 *((volatile unsigned int*)(0x42706024UL))
#define bFM3_MFS3_CSIO_SCR_TBIE                *((volatile unsigned int*)(0x42706028UL))
#define bFM3_MFS3_CSIO_SCR_TIE                 *((volatile unsigned int*)(0x4270602CUL))
#define bFM3_MFS3_CSIO_SCR_RIE                 *((volatile unsigned int*)(0x42706030UL))
#define bFM3_MFS3_CSIO_SCR_SPI                 *((volatile unsigned int*)(0x42706034UL))
#define bFM3_MFS3_CSIO_SCR_MS                  *((volatile unsigned int*)(0x42706038UL))
#define bFM3_MFS3_CSIO_SCR_UPCL                *((volatile unsigned int*)(0x4270603CUL))
#define bFM3_MFS3_CSIO_ESCR_L0                 *((volatile unsigned int*)(0x42706080UL))
#define bFM3_MFS3_CSIO_ESCR_L1                 *((volatile unsigned int*)(0x42706084UL))
#define bFM3_MFS3_CSIO_ESCR_L2                 *((volatile unsigned int*)(0x42706088UL))
#define bFM3_MFS3_CSIO_ESCR_WT0                *((volatile unsigned int*)(0x4270608CUL))
#define bFM3_MFS3_CSIO_ESCR_WT1                *((volatile unsigned int*)(0x42706090UL))
#define bFM3_MFS3_CSIO_ESCR_SOP                *((volatile unsigned int*)(0x4270609CUL))
#define bFM3_MFS3_CSIO_SSR_TBI                 *((volatile unsigned int*)(0x427060A0UL))
#define bFM3_MFS3_CSIO_SSR_TDRE                *((volatile unsigned int*)(0x427060A4UL))
#define bFM3_MFS3_CSIO_SSR_RDRF                *((volatile unsigned int*)(0x427060A8UL))
#define bFM3_MFS3_CSIO_SSR_ORE                 *((volatile unsigned int*)(0x427060ACUL))
#define bFM3_MFS3_CSIO_SSR_REC                 *((volatile unsigned int*)(0x427060BCUL))

/* UART LIN channel 3 registers */
#define bFM3_MFS3_LIN_SMR_SOE                  *((volatile unsigned int*)(0x42706000UL))
#define bFM3_MFS3_LIN_SMR_SBL                  *((volatile unsigned int*)(0x4270600CUL))
#define bFM3_MFS3_LIN_SMR_WUCR                 *((volatile unsigned int*)(0x42706010UL))
#define bFM3_MFS3_LIN_SCR_TXE                  *((volatile unsigned int*)(0x42706020UL))
#define bFM3_MFS3_LIN_SCR_RXE                  *((volatile unsigned int*)(0x42706024UL))
#define bFM3_MFS3_LIN_SCR_TBIE                 *((volatile unsigned int*)(0x42706028UL))
#define bFM3_MFS3_LIN_SCR_TIE                  *((volatile unsigned int*)(0x4270602CUL))
#define bFM3_MFS3_LIN_SCR_RIE                  *((volatile unsigned int*)(0x42706030UL))
#define bFM3_MFS3_LIN_SCR_LBR                  *((volatile unsigned int*)(0x42706034UL))
#define bFM3_MFS3_LIN_SCR_MS                   *((volatile unsigned int*)(0x42706038UL))
#define bFM3_MFS3_LIN_SCR_UPCL                 *((volatile unsigned int*)(0x4270603CUL))
#define bFM3_MFS3_LIN_ESCR_DEL0                *((volatile unsigned int*)(0x42706080UL))
#define bFM3_MFS3_LIN_ESCR_DEL1                *((volatile unsigned int*)(0x42706084UL))
#define bFM3_MFS3_LIN_ESCR_LBL0                *((volatile unsigned int*)(0x42706088UL))
#define bFM3_MFS3_LIN_ESCR_LBL1                *((volatile unsigned int*)(0x4270608CUL))
#define bFM3_MFS3_LIN_ESCR_LBIE                *((volatile unsigned int*)(0x42706090UL))
#define bFM3_MFS3_LIN_ESCR_ESBL                *((volatile unsigned int*)(0x42706098UL))
#define bFM3_MFS3_LIN_SSR_TBI                  *((volatile unsigned int*)(0x427060A0UL))
#define bFM3_MFS3_LIN_SSR_TDRE                 *((volatile unsigned int*)(0x427060A4UL))
#define bFM3_MFS3_LIN_SSR_RDRF                 *((volatile unsigned int*)(0x427060A8UL))
#define bFM3_MFS3_LIN_SSR_ORE                  *((volatile unsigned int*)(0x427060ACUL))
#define bFM3_MFS3_LIN_SSR_FRE                  *((volatile unsigned int*)(0x427060B0UL))
#define bFM3_MFS3_LIN_SSR_LBD                  *((volatile unsigned int*)(0x427060B4UL))
#define bFM3_MFS3_LIN_SSR_REC                  *((volatile unsigned int*)(0x427060BCUL))
#define bFM3_MFS3_LIN_BGR_EXT                  *((volatile unsigned int*)(0x427061BCUL))
#define bFM3_MFS3_LIN_BGR1_EXT                 *((volatile unsigned int*)(0x427061BCUL))

/* I2C channel 3 registers */
#define bFM3_MFS3_I2C_SMR_TIE                  *((volatile unsigned int*)(0x42706008UL))
#define bFM3_MFS3_I2C_SMR_RIE                  *((volatile unsigned int*)(0x4270600CUL))
#define bFM3_MFS3_I2C_SMR_WUCR                 *((volatile unsigned int*)(0x42706010UL))
#define bFM3_MFS3_I2C_IBCR_INT                 *((volatile unsigned int*)(0x42706020UL))
#define bFM3_MFS3_I2C_IBCR_BER                 *((volatile unsigned int*)(0x42706024UL))
#define bFM3_MFS3_I2C_IBCR_INTE                *((volatile unsigned int*)(0x42706028UL))
#define bFM3_MFS3_I2C_IBCR_CNDE                *((volatile unsigned int*)(0x4270602CUL))
#define bFM3_MFS3_I2C_IBCR_WSEL                *((volatile unsigned int*)(0x42706030UL))
#define bFM3_MFS3_I2C_IBCR_ACKE                *((volatile unsigned int*)(0x42706034UL))
#define bFM3_MFS3_I2C_IBCR_ACT                 *((volatile unsigned int*)(0x42706038UL))
#define bFM3_MFS3_I2C_IBCR_SCC                 *((volatile unsigned int*)(0x42706038UL))
#define bFM3_MFS3_I2C_IBCR_MSS                 *((volatile unsigned int*)(0x4270603CUL))
#define bFM3_MFS3_I2C_IBSR_BB                  *((volatile unsigned int*)(0x42706080UL))
#define bFM3_MFS3_I2C_IBSR_SPC                 *((volatile unsigned int*)(0x42706084UL))
#define bFM3_MFS3_I2C_IBSR_RSC                 *((volatile unsigned int*)(0x42706088UL))
#define bFM3_MFS3_I2C_IBSR_AL                  *((volatile unsigned int*)(0x4270608CUL))
#define bFM3_MFS3_I2C_IBSR_TRX                 *((volatile unsigned int*)(0x42706090UL))
#define bFM3_MFS3_I2C_IBSR_RSA                 *((volatile unsigned int*)(0x42706094UL))
#define bFM3_MFS3_I2C_IBSR_RACK                *((volatile unsigned int*)(0x42706098UL))
#define bFM3_MFS3_I2C_IBSR_FBT                 *((volatile unsigned int*)(0x4270609CUL))
#define bFM3_MFS3_I2C_SSR_TBI                  *((volatile unsigned int*)(0x427060A0UL))
#define bFM3_MFS3_I2C_SSR_TDRE                 *((volatile unsigned int*)(0x427060A4UL))
#define bFM3_MFS3_I2C_SSR_RDRF                 *((volatile unsigned int*)(0x427060A8UL))
#define bFM3_MFS3_I2C_SSR_ORE                  *((volatile unsigned int*)(0x427060ACUL))
#define bFM3_MFS3_I2C_SSR_TBIE                 *((volatile unsigned int*)(0x427060B0UL))
#define bFM3_MFS3_I2C_SSR_DMA                  *((volatile unsigned int*)(0x427060B4UL))
#define bFM3_MFS3_I2C_SSR_TSET                 *((volatile unsigned int*)(0x427060B8UL))
#define bFM3_MFS3_I2C_SSR_REC                  *((volatile unsigned int*)(0x427060BCUL))
#define bFM3_MFS3_I2C_ISBA_SA0                 *((volatile unsigned int*)(0x42706200UL))
#define bFM3_MFS3_I2C_ISBA_SA1                 *((volatile unsigned int*)(0x42706204UL))
#define bFM3_MFS3_I2C_ISBA_SA2                 *((volatile unsigned int*)(0x42706208UL))
#define bFM3_MFS3_I2C_ISBA_SA3                 *((volatile unsigned int*)(0x4270620CUL))
#define bFM3_MFS3_I2C_ISBA_SA4                 *((volatile unsigned int*)(0x42706210UL))
#define bFM3_MFS3_I2C_ISBA_SA5                 *((volatile unsigned int*)(0x42706214UL))
#define bFM3_MFS3_I2C_ISBA_SA6                 *((volatile unsigned int*)(0x42706218UL))
#define bFM3_MFS3_I2C_ISBA_SAEN                *((volatile unsigned int*)(0x4270621CUL))
#define bFM3_MFS3_I2C_ISMK_SM0                 *((volatile unsigned int*)(0x42706220UL))
#define bFM3_MFS3_I2C_ISMK_SM1                 *((volatile unsigned int*)(0x42706224UL))
#define bFM3_MFS3_I2C_ISMK_SM2                 *((volatile unsigned int*)(0x42706228UL))
#define bFM3_MFS3_I2C_ISMK_SM3                 *((volatile unsigned int*)(0x4270622CUL))
#define bFM3_MFS3_I2C_ISMK_SM4                 *((volatile unsigned int*)(0x42706230UL))
#define bFM3_MFS3_I2C_ISMK_SM5                 *((volatile unsigned int*)(0x42706234UL))
#define bFM3_MFS3_I2C_ISMK_SM6                 *((volatile unsigned int*)(0x42706238UL))
#define bFM3_MFS3_I2C_ISMK_EN                  *((volatile unsigned int*)(0x4270623CUL))

/* UART asynchronous channel 4 registers */
#define bFM3_MFS4_UART_SMR_SOE                 *((volatile unsigned int*)(0x42708000UL))
#define bFM3_MFS4_UART_SMR_BDS                 *((volatile unsigned int*)(0x42708008UL))
#define bFM3_MFS4_UART_SMR_SBL                 *((volatile unsigned int*)(0x4270800CUL))
#define bFM3_MFS4_UART_SMR_WUCR                *((volatile unsigned int*)(0x42708010UL))
#define bFM3_MFS4_UART_SCR_TXE                 *((volatile unsigned int*)(0x42708020UL))
#define bFM3_MFS4_UART_SCR_RXE                 *((volatile unsigned int*)(0x42708024UL))
#define bFM3_MFS4_UART_SCR_TBIE                *((volatile unsigned int*)(0x42708028UL))
#define bFM3_MFS4_UART_SCR_TIE                 *((volatile unsigned int*)(0x4270802CUL))
#define bFM3_MFS4_UART_SCR_RIE                 *((volatile unsigned int*)(0x42708030UL))
#define bFM3_MFS4_UART_SCR_UPCL                *((volatile unsigned int*)(0x4270803CUL))
#define bFM3_MFS4_UART_ESCR_L0                 *((volatile unsigned int*)(0x42708080UL))
#define bFM3_MFS4_UART_ESCR_L1                 *((volatile unsigned int*)(0x42708084UL))
#define bFM3_MFS4_UART_ESCR_L2                 *((volatile unsigned int*)(0x42708088UL))
#define bFM3_MFS4_UART_ESCR_P                  *((volatile unsigned int*)(0x4270808CUL))
#define bFM3_MFS4_UART_ESCR_PEN                *((volatile unsigned int*)(0x42708090UL))
#define bFM3_MFS4_UART_ESCR_INV                *((volatile unsigned int*)(0x42708094UL))
#define bFM3_MFS4_UART_ESCR_ESBL               *((volatile unsigned int*)(0x42708098UL))
#define bFM3_MFS4_UART_ESCR_FLWEN              *((volatile unsigned int*)(0x4270809CUL))
#define bFM3_MFS4_UART_SSR_TBI                 *((volatile unsigned int*)(0x427080A0UL))
#define bFM3_MFS4_UART_SSR_TDRE                *((volatile unsigned int*)(0x427080A4UL))
#define bFM3_MFS4_UART_SSR_RDRF                *((volatile unsigned int*)(0x427080A8UL))
#define bFM3_MFS4_UART_SSR_ORE                 *((volatile unsigned int*)(0x427080ACUL))
#define bFM3_MFS4_UART_SSR_FRE                 *((volatile unsigned int*)(0x427080B0UL))
#define bFM3_MFS4_UART_SSR_PE                  *((volatile unsigned int*)(0x427080B4UL))
#define bFM3_MFS4_UART_SSR_REC                 *((volatile unsigned int*)(0x427080BCUL))
#define bFM3_MFS4_UART_RDR_AD                  *((volatile unsigned int*)(0x42708120UL))
#define bFM3_MFS4_UART_TDR_AD                  *((volatile unsigned int*)(0x42708120UL))
#define bFM3_MFS4_UART_BGR_EXT                 *((volatile unsigned int*)(0x427081BCUL))
#define bFM3_MFS4_UART_BGR1_EXT                *((volatile unsigned int*)(0x427081BCUL))
#define bFM3_MFS4_UART_FCR_FE1                 *((volatile unsigned int*)(0x42708280UL))
#define bFM3_MFS4_UART_FCR_FE2                 *((volatile unsigned int*)(0x42708284UL))
#define bFM3_MFS4_UART_FCR_FCL1                *((volatile unsigned int*)(0x42708288UL))
#define bFM3_MFS4_UART_FCR_FCL2                *((volatile unsigned int*)(0x4270828CUL))
#define bFM3_MFS4_UART_FCR_FSET                *((volatile unsigned int*)(0x42708290UL))
#define bFM3_MFS4_UART_FCR_FLD                 *((volatile unsigned int*)(0x42708294UL))
#define bFM3_MFS4_UART_FCR_FLST                *((volatile unsigned int*)(0x42708298UL))
#define bFM3_MFS4_UART_FCR_FSEL                *((volatile unsigned int*)(0x427082A0UL))
#define bFM3_MFS4_UART_FCR_FTIE                *((volatile unsigned int*)(0x427082A4UL))
#define bFM3_MFS4_UART_FCR_FDRQ                *((volatile unsigned int*)(0x427082A8UL))
#define bFM3_MFS4_UART_FCR_FRIIE               *((volatile unsigned int*)(0x427082ACUL))
#define bFM3_MFS4_UART_FCR_FLSTE               *((volatile unsigned int*)(0x427082B0UL))
#define bFM3_MFS4_UART_FCR0_FE1                *((volatile unsigned int*)(0x42708280UL))
#define bFM3_MFS4_UART_FCR0_FE2                *((volatile unsigned int*)(0x42708284UL))
#define bFM3_MFS4_UART_FCR0_FCL1               *((volatile unsigned int*)(0x42708288UL))
#define bFM3_MFS4_UART_FCR0_FCL2               *((volatile unsigned int*)(0x4270828CUL))
#define bFM3_MFS4_UART_FCR0_FSET               *((volatile unsigned int*)(0x42708290UL))
#define bFM3_MFS4_UART_FCR0_FLD                *((volatile unsigned int*)(0x42708294UL))
#define bFM3_MFS4_UART_FCR0_FLST               *((volatile unsigned int*)(0x42708298UL))
#define bFM3_MFS4_UART_FCR1_FSEL               *((volatile unsigned int*)(0x427082A0UL))
#define bFM3_MFS4_UART_FCR1_FTIE               *((volatile unsigned int*)(0x427082A4UL))
#define bFM3_MFS4_UART_FCR1_FDRQ               *((volatile unsigned int*)(0x427082A8UL))
#define bFM3_MFS4_UART_FCR1_FRIIE              *((volatile unsigned int*)(0x427082ACUL))
#define bFM3_MFS4_UART_FCR1_FLSTE              *((volatile unsigned int*)(0x427082B0UL))
#define bFM3_MFS4_UART_FBYTE_FD0               *((volatile unsigned int*)(0x42708300UL))
#define bFM3_MFS4_UART_FBYTE_FD1               *((volatile unsigned int*)(0x42708304UL))
#define bFM3_MFS4_UART_FBYTE_FD2               *((volatile unsigned int*)(0x42708308UL))
#define bFM3_MFS4_UART_FBYTE_FD3               *((volatile unsigned int*)(0x4270830CUL))
#define bFM3_MFS4_UART_FBYTE_FD4               *((volatile unsigned int*)(0x42708310UL))
#define bFM3_MFS4_UART_FBYTE_FD5               *((volatile unsigned int*)(0x42708314UL))
#define bFM3_MFS4_UART_FBYTE_FD6               *((volatile unsigned int*)(0x42708318UL))
#define bFM3_MFS4_UART_FBYTE_FD7               *((volatile unsigned int*)(0x4270831CUL))
#define bFM3_MFS4_UART_FBYTE_FD8               *((volatile unsigned int*)(0x42708320UL))
#define bFM3_MFS4_UART_FBYTE_FD9               *((volatile unsigned int*)(0x42708324UL))
#define bFM3_MFS4_UART_FBYTE_FD10              *((volatile unsigned int*)(0x42708328UL))
#define bFM3_MFS4_UART_FBYTE_FD11              *((volatile unsigned int*)(0x4270832CUL))
#define bFM3_MFS4_UART_FBYTE_FD12              *((volatile unsigned int*)(0x42708330UL))
#define bFM3_MFS4_UART_FBYTE_FD13              *((volatile unsigned int*)(0x42708334UL))
#define bFM3_MFS4_UART_FBYTE_FD14              *((volatile unsigned int*)(0x42708338UL))
#define bFM3_MFS4_UART_FBYTE_FD15              *((volatile unsigned int*)(0x4270833CUL))
#define bFM3_MFS4_UART_FBYTE1_FD0              *((volatile unsigned int*)(0x42708300UL))
#define bFM3_MFS4_UART_FBYTE1_FD1              *((volatile unsigned int*)(0x42708304UL))
#define bFM3_MFS4_UART_FBYTE1_FD2              *((volatile unsigned int*)(0x42708308UL))
#define bFM3_MFS4_UART_FBYTE1_FD3              *((volatile unsigned int*)(0x4270830CUL))
#define bFM3_MFS4_UART_FBYTE1_FD4              *((volatile unsigned int*)(0x42708310UL))
#define bFM3_MFS4_UART_FBYTE1_FD5              *((volatile unsigned int*)(0x42708314UL))
#define bFM3_MFS4_UART_FBYTE1_FD6              *((volatile unsigned int*)(0x42708318UL))
#define bFM3_MFS4_UART_FBYTE1_FD7              *((volatile unsigned int*)(0x4270831CUL))
#define bFM3_MFS4_UART_FBYTE2_FD8              *((volatile unsigned int*)(0x42708320UL))
#define bFM3_MFS4_UART_FBYTE2_FD9              *((volatile unsigned int*)(0x42708324UL))
#define bFM3_MFS4_UART_FBYTE2_FD10             *((volatile unsigned int*)(0x42708328UL))
#define bFM3_MFS4_UART_FBYTE2_FD11             *((volatile unsigned int*)(0x4270832CUL))
#define bFM3_MFS4_UART_FBYTE2_FD12             *((volatile unsigned int*)(0x42708330UL))
#define bFM3_MFS4_UART_FBYTE2_FD13             *((volatile unsigned int*)(0x42708334UL))
#define bFM3_MFS4_UART_FBYTE2_FD14             *((volatile unsigned int*)(0x42708338UL))
#define bFM3_MFS4_UART_FBYTE2_FD15             *((volatile unsigned int*)(0x4270833CUL))

/* UART synchronous channel 4 registers */
#define bFM3_MFS4_CSIO_SMR_SOE                 *((volatile unsigned int*)(0x42708000UL))
#define bFM3_MFS4_CSIO_SMR_SCKE                *((volatile unsigned int*)(0x42708004UL))
#define bFM3_MFS4_CSIO_SMR_BDS                 *((volatile unsigned int*)(0x42708008UL))
#define bFM3_MFS4_CSIO_SMR_SCINV               *((volatile unsigned int*)(0x4270800CUL))
#define bFM3_MFS4_CSIO_SMR_WUCR                *((volatile unsigned int*)(0x42708010UL))
#define bFM3_MFS4_CSIO_SCR_TXE                 *((volatile unsigned int*)(0x42708020UL))
#define bFM3_MFS4_CSIO_SCR_RXE                 *((volatile unsigned int*)(0x42708024UL))
#define bFM3_MFS4_CSIO_SCR_TBIE                *((volatile unsigned int*)(0x42708028UL))
#define bFM3_MFS4_CSIO_SCR_TIE                 *((volatile unsigned int*)(0x4270802CUL))
#define bFM3_MFS4_CSIO_SCR_RIE                 *((volatile unsigned int*)(0x42708030UL))
#define bFM3_MFS4_CSIO_SCR_SPI                 *((volatile unsigned int*)(0x42708034UL))
#define bFM3_MFS4_CSIO_SCR_MS                  *((volatile unsigned int*)(0x42708038UL))
#define bFM3_MFS4_CSIO_SCR_UPCL                *((volatile unsigned int*)(0x4270803CUL))
#define bFM3_MFS4_CSIO_ESCR_L0                 *((volatile unsigned int*)(0x42708080UL))
#define bFM3_MFS4_CSIO_ESCR_L1                 *((volatile unsigned int*)(0x42708084UL))
#define bFM3_MFS4_CSIO_ESCR_L2                 *((volatile unsigned int*)(0x42708088UL))
#define bFM3_MFS4_CSIO_ESCR_WT0                *((volatile unsigned int*)(0x4270808CUL))
#define bFM3_MFS4_CSIO_ESCR_WT1                *((volatile unsigned int*)(0x42708090UL))
#define bFM3_MFS4_CSIO_ESCR_SOP                *((volatile unsigned int*)(0x4270809CUL))
#define bFM3_MFS4_CSIO_SSR_TBI                 *((volatile unsigned int*)(0x427080A0UL))
#define bFM3_MFS4_CSIO_SSR_TDRE                *((volatile unsigned int*)(0x427080A4UL))
#define bFM3_MFS4_CSIO_SSR_RDRF                *((volatile unsigned int*)(0x427080A8UL))
#define bFM3_MFS4_CSIO_SSR_ORE                 *((volatile unsigned int*)(0x427080ACUL))
#define bFM3_MFS4_CSIO_SSR_REC                 *((volatile unsigned int*)(0x427080BCUL))
#define bFM3_MFS4_CSIO_FCR_FE1                 *((volatile unsigned int*)(0x42708280UL))
#define bFM3_MFS4_CSIO_FCR_FE2                 *((volatile unsigned int*)(0x42708284UL))
#define bFM3_MFS4_CSIO_FCR_FCL1                *((volatile unsigned int*)(0x42708288UL))
#define bFM3_MFS4_CSIO_FCR_FCL2                *((volatile unsigned int*)(0x4270828CUL))
#define bFM3_MFS4_CSIO_FCR_FSET                *((volatile unsigned int*)(0x42708290UL))
#define bFM3_MFS4_CSIO_FCR_FLD                 *((volatile unsigned int*)(0x42708294UL))
#define bFM3_MFS4_CSIO_FCR_FLST                *((volatile unsigned int*)(0x42708298UL))
#define bFM3_MFS4_CSIO_FCR_FSEL                *((volatile unsigned int*)(0x427082A0UL))
#define bFM3_MFS4_CSIO_FCR_FTIE                *((volatile unsigned int*)(0x427082A4UL))
#define bFM3_MFS4_CSIO_FCR_FDRQ                *((volatile unsigned int*)(0x427082A8UL))
#define bFM3_MFS4_CSIO_FCR_FRIIE               *((volatile unsigned int*)(0x427082ACUL))
#define bFM3_MFS4_CSIO_FCR_FLSTE               *((volatile unsigned int*)(0x427082B0UL))
#define bFM3_MFS4_CSIO_FCR0_FE1                *((volatile unsigned int*)(0x42708280UL))
#define bFM3_MFS4_CSIO_FCR0_FE2                *((volatile unsigned int*)(0x42708284UL))
#define bFM3_MFS4_CSIO_FCR0_FCL1               *((volatile unsigned int*)(0x42708288UL))
#define bFM3_MFS4_CSIO_FCR0_FCL2               *((volatile unsigned int*)(0x4270828CUL))
#define bFM3_MFS4_CSIO_FCR0_FSET               *((volatile unsigned int*)(0x42708290UL))
#define bFM3_MFS4_CSIO_FCR0_FLD                *((volatile unsigned int*)(0x42708294UL))
#define bFM3_MFS4_CSIO_FCR0_FLST               *((volatile unsigned int*)(0x42708298UL))
#define bFM3_MFS4_CSIO_FCR1_FSEL               *((volatile unsigned int*)(0x427082A0UL))
#define bFM3_MFS4_CSIO_FCR1_FTIE               *((volatile unsigned int*)(0x427082A4UL))
#define bFM3_MFS4_CSIO_FCR1_FDRQ               *((volatile unsigned int*)(0x427082A8UL))
#define bFM3_MFS4_CSIO_FCR1_FRIIE              *((volatile unsigned int*)(0x427082ACUL))
#define bFM3_MFS4_CSIO_FCR1_FLSTE              *((volatile unsigned int*)(0x427082B0UL))
#define bFM3_MFS4_CSIO_FBYTE_FD0               *((volatile unsigned int*)(0x42708300UL))
#define bFM3_MFS4_CSIO_FBYTE_FD1               *((volatile unsigned int*)(0x42708304UL))
#define bFM3_MFS4_CSIO_FBYTE_FD2               *((volatile unsigned int*)(0x42708308UL))
#define bFM3_MFS4_CSIO_FBYTE_FD3               *((volatile unsigned int*)(0x4270830CUL))
#define bFM3_MFS4_CSIO_FBYTE_FD4               *((volatile unsigned int*)(0x42708310UL))
#define bFM3_MFS4_CSIO_FBYTE_FD5               *((volatile unsigned int*)(0x42708314UL))
#define bFM3_MFS4_CSIO_FBYTE_FD6               *((volatile unsigned int*)(0x42708318UL))
#define bFM3_MFS4_CSIO_FBYTE_FD7               *((volatile unsigned int*)(0x4270831CUL))
#define bFM3_MFS4_CSIO_FBYTE_FD8               *((volatile unsigned int*)(0x42708320UL))
#define bFM3_MFS4_CSIO_FBYTE_FD9               *((volatile unsigned int*)(0x42708324UL))
#define bFM3_MFS4_CSIO_FBYTE_FD10              *((volatile unsigned int*)(0x42708328UL))
#define bFM3_MFS4_CSIO_FBYTE_FD11              *((volatile unsigned int*)(0x4270832CUL))
#define bFM3_MFS4_CSIO_FBYTE_FD12              *((volatile unsigned int*)(0x42708330UL))
#define bFM3_MFS4_CSIO_FBYTE_FD13              *((volatile unsigned int*)(0x42708334UL))
#define bFM3_MFS4_CSIO_FBYTE_FD14              *((volatile unsigned int*)(0x42708338UL))
#define bFM3_MFS4_CSIO_FBYTE_FD15              *((volatile unsigned int*)(0x4270833CUL))
#define bFM3_MFS4_CSIO_FBYTE1_FD0              *((volatile unsigned int*)(0x42708300UL))
#define bFM3_MFS4_CSIO_FBYTE1_FD1              *((volatile unsigned int*)(0x42708304UL))
#define bFM3_MFS4_CSIO_FBYTE1_FD2              *((volatile unsigned int*)(0x42708308UL))
#define bFM3_MFS4_CSIO_FBYTE1_FD3              *((volatile unsigned int*)(0x4270830CUL))
#define bFM3_MFS4_CSIO_FBYTE1_FD4              *((volatile unsigned int*)(0x42708310UL))
#define bFM3_MFS4_CSIO_FBYTE1_FD5              *((volatile unsigned int*)(0x42708314UL))
#define bFM3_MFS4_CSIO_FBYTE1_FD6              *((volatile unsigned int*)(0x42708318UL))
#define bFM3_MFS4_CSIO_FBYTE1_FD7              *((volatile unsigned int*)(0x4270831CUL))
#define bFM3_MFS4_CSIO_FBYTE2_FD8              *((volatile unsigned int*)(0x42708320UL))
#define bFM3_MFS4_CSIO_FBYTE2_FD9              *((volatile unsigned int*)(0x42708324UL))
#define bFM3_MFS4_CSIO_FBYTE2_FD10             *((volatile unsigned int*)(0x42708328UL))
#define bFM3_MFS4_CSIO_FBYTE2_FD11             *((volatile unsigned int*)(0x4270832CUL))
#define bFM3_MFS4_CSIO_FBYTE2_FD12             *((volatile unsigned int*)(0x42708330UL))
#define bFM3_MFS4_CSIO_FBYTE2_FD13             *((volatile unsigned int*)(0x42708334UL))
#define bFM3_MFS4_CSIO_FBYTE2_FD14             *((volatile unsigned int*)(0x42708338UL))
#define bFM3_MFS4_CSIO_FBYTE2_FD15             *((volatile unsigned int*)(0x4270833CUL))

/* UART LIN channel 4 registers */
#define bFM3_MFS4_LIN_SMR_SOE                  *((volatile unsigned int*)(0x42708000UL))
#define bFM3_MFS4_LIN_SMR_SBL                  *((volatile unsigned int*)(0x4270800CUL))
#define bFM3_MFS4_LIN_SMR_WUCR                 *((volatile unsigned int*)(0x42708010UL))
#define bFM3_MFS4_LIN_SCR_TXE                  *((volatile unsigned int*)(0x42708020UL))
#define bFM3_MFS4_LIN_SCR_RXE                  *((volatile unsigned int*)(0x42708024UL))
#define bFM3_MFS4_LIN_SCR_TBIE                 *((volatile unsigned int*)(0x42708028UL))
#define bFM3_MFS4_LIN_SCR_TIE                  *((volatile unsigned int*)(0x4270802CUL))
#define bFM3_MFS4_LIN_SCR_RIE                  *((volatile unsigned int*)(0x42708030UL))
#define bFM3_MFS4_LIN_SCR_LBR                  *((volatile unsigned int*)(0x42708034UL))
#define bFM3_MFS4_LIN_SCR_MS                   *((volatile unsigned int*)(0x42708038UL))
#define bFM3_MFS4_LIN_SCR_UPCL                 *((volatile unsigned int*)(0x4270803CUL))
#define bFM3_MFS4_LIN_ESCR_DEL0                *((volatile unsigned int*)(0x42708080UL))
#define bFM3_MFS4_LIN_ESCR_DEL1                *((volatile unsigned int*)(0x42708084UL))
#define bFM3_MFS4_LIN_ESCR_LBL0                *((volatile unsigned int*)(0x42708088UL))
#define bFM3_MFS4_LIN_ESCR_LBL1                *((volatile unsigned int*)(0x4270808CUL))
#define bFM3_MFS4_LIN_ESCR_LBIE                *((volatile unsigned int*)(0x42708090UL))
#define bFM3_MFS4_LIN_ESCR_ESBL                *((volatile unsigned int*)(0x42708098UL))
#define bFM3_MFS4_LIN_SSR_TBI                  *((volatile unsigned int*)(0x427080A0UL))
#define bFM3_MFS4_LIN_SSR_TDRE                 *((volatile unsigned int*)(0x427080A4UL))
#define bFM3_MFS4_LIN_SSR_RDRF                 *((volatile unsigned int*)(0x427080A8UL))
#define bFM3_MFS4_LIN_SSR_ORE                  *((volatile unsigned int*)(0x427080ACUL))
#define bFM3_MFS4_LIN_SSR_FRE                  *((volatile unsigned int*)(0x427080B0UL))
#define bFM3_MFS4_LIN_SSR_LBD                  *((volatile unsigned int*)(0x427080B4UL))
#define bFM3_MFS4_LIN_SSR_REC                  *((volatile unsigned int*)(0x427080BCUL))
#define bFM3_MFS4_LIN_BGR_EXT                  *((volatile unsigned int*)(0x427081BCUL))
#define bFM3_MFS4_LIN_BGR1_EXT                 *((volatile unsigned int*)(0x427081BCUL))
#define bFM3_MFS4_LIN_FCR_FE1                  *((volatile unsigned int*)(0x42708280UL))
#define bFM3_MFS4_LIN_FCR_FE2                  *((volatile unsigned int*)(0x42708284UL))
#define bFM3_MFS4_LIN_FCR_FCL1                 *((volatile unsigned int*)(0x42708288UL))
#define bFM3_MFS4_LIN_FCR_FCL2                 *((volatile unsigned int*)(0x4270828CUL))
#define bFM3_MFS4_LIN_FCR_FSET                 *((volatile unsigned int*)(0x42708290UL))
#define bFM3_MFS4_LIN_FCR_FLD                  *((volatile unsigned int*)(0x42708294UL))
#define bFM3_MFS4_LIN_FCR_FLST                 *((volatile unsigned int*)(0x42708298UL))
#define bFM3_MFS4_LIN_FCR_FSEL                 *((volatile unsigned int*)(0x427082A0UL))
#define bFM3_MFS4_LIN_FCR_FTIE                 *((volatile unsigned int*)(0x427082A4UL))
#define bFM3_MFS4_LIN_FCR_FDRQ                 *((volatile unsigned int*)(0x427082A8UL))
#define bFM3_MFS4_LIN_FCR_FRIIE                *((volatile unsigned int*)(0x427082ACUL))
#define bFM3_MFS4_LIN_FCR_FLSTE                *((volatile unsigned int*)(0x427082B0UL))
#define bFM3_MFS4_LIN_FCR0_FE1                 *((volatile unsigned int*)(0x42708280UL))
#define bFM3_MFS4_LIN_FCR0_FE2                 *((volatile unsigned int*)(0x42708284UL))
#define bFM3_MFS4_LIN_FCR0_FCL1                *((volatile unsigned int*)(0x42708288UL))
#define bFM3_MFS4_LIN_FCR0_FCL2                *((volatile unsigned int*)(0x4270828CUL))
#define bFM3_MFS4_LIN_FCR0_FSET                *((volatile unsigned int*)(0x42708290UL))
#define bFM3_MFS4_LIN_FCR0_FLD                 *((volatile unsigned int*)(0x42708294UL))
#define bFM3_MFS4_LIN_FCR0_FLST                *((volatile unsigned int*)(0x42708298UL))
#define bFM3_MFS4_LIN_FCR1_FSEL                *((volatile unsigned int*)(0x427082A0UL))
#define bFM3_MFS4_LIN_FCR1_FTIE                *((volatile unsigned int*)(0x427082A4UL))
#define bFM3_MFS4_LIN_FCR1_FDRQ                *((volatile unsigned int*)(0x427082A8UL))
#define bFM3_MFS4_LIN_FCR1_FRIIE               *((volatile unsigned int*)(0x427082ACUL))
#define bFM3_MFS4_LIN_FCR1_FLSTE               *((volatile unsigned int*)(0x427082B0UL))
#define bFM3_MFS4_LIN_FBYTE_FD0                *((volatile unsigned int*)(0x42708300UL))
#define bFM3_MFS4_LIN_FBYTE_FD1                *((volatile unsigned int*)(0x42708304UL))
#define bFM3_MFS4_LIN_FBYTE_FD2                *((volatile unsigned int*)(0x42708308UL))
#define bFM3_MFS4_LIN_FBYTE_FD3                *((volatile unsigned int*)(0x4270830CUL))
#define bFM3_MFS4_LIN_FBYTE_FD4                *((volatile unsigned int*)(0x42708310UL))
#define bFM3_MFS4_LIN_FBYTE_FD5                *((volatile unsigned int*)(0x42708314UL))
#define bFM3_MFS4_LIN_FBYTE_FD6                *((volatile unsigned int*)(0x42708318UL))
#define bFM3_MFS4_LIN_FBYTE_FD7                *((volatile unsigned int*)(0x4270831CUL))
#define bFM3_MFS4_LIN_FBYTE_FD8                *((volatile unsigned int*)(0x42708320UL))
#define bFM3_MFS4_LIN_FBYTE_FD9                *((volatile unsigned int*)(0x42708324UL))
#define bFM3_MFS4_LIN_FBYTE_FD10               *((volatile unsigned int*)(0x42708328UL))
#define bFM3_MFS4_LIN_FBYTE_FD11               *((volatile unsigned int*)(0x4270832CUL))
#define bFM3_MFS4_LIN_FBYTE_FD12               *((volatile unsigned int*)(0x42708330UL))
#define bFM3_MFS4_LIN_FBYTE_FD13               *((volatile unsigned int*)(0x42708334UL))
#define bFM3_MFS4_LIN_FBYTE_FD14               *((volatile unsigned int*)(0x42708338UL))
#define bFM3_MFS4_LIN_FBYTE_FD15               *((volatile unsigned int*)(0x4270833CUL))
#define bFM3_MFS4_LIN_FBYTE1_FD0               *((volatile unsigned int*)(0x42708300UL))
#define bFM3_MFS4_LIN_FBYTE1_FD1               *((volatile unsigned int*)(0x42708304UL))
#define bFM3_MFS4_LIN_FBYTE1_FD2               *((volatile unsigned int*)(0x42708308UL))
#define bFM3_MFS4_LIN_FBYTE1_FD3               *((volatile unsigned int*)(0x4270830CUL))
#define bFM3_MFS4_LIN_FBYTE1_FD4               *((volatile unsigned int*)(0x42708310UL))
#define bFM3_MFS4_LIN_FBYTE1_FD5               *((volatile unsigned int*)(0x42708314UL))
#define bFM3_MFS4_LIN_FBYTE1_FD6               *((volatile unsigned int*)(0x42708318UL))
#define bFM3_MFS4_LIN_FBYTE1_FD7               *((volatile unsigned int*)(0x4270831CUL))
#define bFM3_MFS4_LIN_FBYTE2_FD8               *((volatile unsigned int*)(0x42708320UL))
#define bFM3_MFS4_LIN_FBYTE2_FD9               *((volatile unsigned int*)(0x42708324UL))
#define bFM3_MFS4_LIN_FBYTE2_FD10              *((volatile unsigned int*)(0x42708328UL))
#define bFM3_MFS4_LIN_FBYTE2_FD11              *((volatile unsigned int*)(0x4270832CUL))
#define bFM3_MFS4_LIN_FBYTE2_FD12              *((volatile unsigned int*)(0x42708330UL))
#define bFM3_MFS4_LIN_FBYTE2_FD13              *((volatile unsigned int*)(0x42708334UL))
#define bFM3_MFS4_LIN_FBYTE2_FD14              *((volatile unsigned int*)(0x42708338UL))
#define bFM3_MFS4_LIN_FBYTE2_FD15              *((volatile unsigned int*)(0x4270833CUL))

/* I2C channel 4 registers */
#define bFM3_MFS4_I2C_SMR_TIE                  *((volatile unsigned int*)(0x42708008UL))
#define bFM3_MFS4_I2C_SMR_RIE                  *((volatile unsigned int*)(0x4270800CUL))
#define bFM3_MFS4_I2C_SMR_WUCR                 *((volatile unsigned int*)(0x42708010UL))
#define bFM3_MFS4_I2C_IBCR_INT                 *((volatile unsigned int*)(0x42708020UL))
#define bFM3_MFS4_I2C_IBCR_BER                 *((volatile unsigned int*)(0x42708024UL))
#define bFM3_MFS4_I2C_IBCR_INTE                *((volatile unsigned int*)(0x42708028UL))
#define bFM3_MFS4_I2C_IBCR_CNDE                *((volatile unsigned int*)(0x4270802CUL))
#define bFM3_MFS4_I2C_IBCR_WSEL                *((volatile unsigned int*)(0x42708030UL))
#define bFM3_MFS4_I2C_IBCR_ACKE                *((volatile unsigned int*)(0x42708034UL))
#define bFM3_MFS4_I2C_IBCR_ACT                 *((volatile unsigned int*)(0x42708038UL))
#define bFM3_MFS4_I2C_IBCR_SCC                 *((volatile unsigned int*)(0x42708038UL))
#define bFM3_MFS4_I2C_IBCR_MSS                 *((volatile unsigned int*)(0x4270803CUL))
#define bFM3_MFS4_I2C_IBSR_BB                  *((volatile unsigned int*)(0x42708080UL))
#define bFM3_MFS4_I2C_IBSR_SPC                 *((volatile unsigned int*)(0x42708084UL))
#define bFM3_MFS4_I2C_IBSR_RSC                 *((volatile unsigned int*)(0x42708088UL))
#define bFM3_MFS4_I2C_IBSR_AL                  *((volatile unsigned int*)(0x4270808CUL))
#define bFM3_MFS4_I2C_IBSR_TRX                 *((volatile unsigned int*)(0x42708090UL))
#define bFM3_MFS4_I2C_IBSR_RSA                 *((volatile unsigned int*)(0x42708094UL))
#define bFM3_MFS4_I2C_IBSR_RACK                *((volatile unsigned int*)(0x42708098UL))
#define bFM3_MFS4_I2C_IBSR_FBT                 *((volatile unsigned int*)(0x4270809CUL))
#define bFM3_MFS4_I2C_SSR_TBI                  *((volatile unsigned int*)(0x427080A0UL))
#define bFM3_MFS4_I2C_SSR_TDRE                 *((volatile unsigned int*)(0x427080A4UL))
#define bFM3_MFS4_I2C_SSR_RDRF                 *((volatile unsigned int*)(0x427080A8UL))
#define bFM3_MFS4_I2C_SSR_ORE                  *((volatile unsigned int*)(0x427080ACUL))
#define bFM3_MFS4_I2C_SSR_TBIE                 *((volatile unsigned int*)(0x427080B0UL))
#define bFM3_MFS4_I2C_SSR_DMA                  *((volatile unsigned int*)(0x427080B4UL))
#define bFM3_MFS4_I2C_SSR_TSET                 *((volatile unsigned int*)(0x427080B8UL))
#define bFM3_MFS4_I2C_SSR_REC                  *((volatile unsigned int*)(0x427080BCUL))
#define bFM3_MFS4_I2C_ISBA_SA0                 *((volatile unsigned int*)(0x42708200UL))
#define bFM3_MFS4_I2C_ISBA_SA1                 *((volatile unsigned int*)(0x42708204UL))
#define bFM3_MFS4_I2C_ISBA_SA2                 *((volatile unsigned int*)(0x42708208UL))
#define bFM3_MFS4_I2C_ISBA_SA3                 *((volatile unsigned int*)(0x4270820CUL))
#define bFM3_MFS4_I2C_ISBA_SA4                 *((volatile unsigned int*)(0x42708210UL))
#define bFM3_MFS4_I2C_ISBA_SA5                 *((volatile unsigned int*)(0x42708214UL))
#define bFM3_MFS4_I2C_ISBA_SA6                 *((volatile unsigned int*)(0x42708218UL))
#define bFM3_MFS4_I2C_ISBA_SAEN                *((volatile unsigned int*)(0x4270821CUL))
#define bFM3_MFS4_I2C_ISMK_SM0                 *((volatile unsigned int*)(0x42708220UL))
#define bFM3_MFS4_I2C_ISMK_SM1                 *((volatile unsigned int*)(0x42708224UL))
#define bFM3_MFS4_I2C_ISMK_SM2                 *((volatile unsigned int*)(0x42708228UL))
#define bFM3_MFS4_I2C_ISMK_SM3                 *((volatile unsigned int*)(0x4270822CUL))
#define bFM3_MFS4_I2C_ISMK_SM4                 *((volatile unsigned int*)(0x42708230UL))
#define bFM3_MFS4_I2C_ISMK_SM5                 *((volatile unsigned int*)(0x42708234UL))
#define bFM3_MFS4_I2C_ISMK_SM6                 *((volatile unsigned int*)(0x42708238UL))
#define bFM3_MFS4_I2C_ISMK_EN                  *((volatile unsigned int*)(0x4270823CUL))
#define bFM3_MFS4_I2C_FCR_FE1                  *((volatile unsigned int*)(0x42708280UL))
#define bFM3_MFS4_I2C_FCR_FE2                  *((volatile unsigned int*)(0x42708284UL))
#define bFM3_MFS4_I2C_FCR_FCL1                 *((volatile unsigned int*)(0x42708288UL))
#define bFM3_MFS4_I2C_FCR_FCL2                 *((volatile unsigned int*)(0x4270828CUL))
#define bFM3_MFS4_I2C_FCR_FSET                 *((volatile unsigned int*)(0x42708290UL))
#define bFM3_MFS4_I2C_FCR_FLD                  *((volatile unsigned int*)(0x42708294UL))
#define bFM3_MFS4_I2C_FCR_FLST                 *((volatile unsigned int*)(0x42708298UL))
#define bFM3_MFS4_I2C_FCR_FSEL                 *((volatile unsigned int*)(0x427082A0UL))
#define bFM3_MFS4_I2C_FCR_FTIE                 *((volatile unsigned int*)(0x427082A4UL))
#define bFM3_MFS4_I2C_FCR_FDRQ                 *((volatile unsigned int*)(0x427082A8UL))
#define bFM3_MFS4_I2C_FCR_FRIIE                *((volatile unsigned int*)(0x427082ACUL))
#define bFM3_MFS4_I2C_FCR_FLSTE                *((volatile unsigned int*)(0x427082B0UL))
#define bFM3_MFS4_I2C_FCR0_FE1                 *((volatile unsigned int*)(0x42708280UL))
#define bFM3_MFS4_I2C_FCR0_FE2                 *((volatile unsigned int*)(0x42708284UL))
#define bFM3_MFS4_I2C_FCR0_FCL1                *((volatile unsigned int*)(0x42708288UL))
#define bFM3_MFS4_I2C_FCR0_FCL2                *((volatile unsigned int*)(0x4270828CUL))
#define bFM3_MFS4_I2C_FCR0_FSET                *((volatile unsigned int*)(0x42708290UL))
#define bFM3_MFS4_I2C_FCR0_FLD                 *((volatile unsigned int*)(0x42708294UL))
#define bFM3_MFS4_I2C_FCR0_FLST                *((volatile unsigned int*)(0x42708298UL))
#define bFM3_MFS4_I2C_FCR1_FSEL                *((volatile unsigned int*)(0x427082A0UL))
#define bFM3_MFS4_I2C_FCR1_FTIE                *((volatile unsigned int*)(0x427082A4UL))
#define bFM3_MFS4_I2C_FCR1_FDRQ                *((volatile unsigned int*)(0x427082A8UL))
#define bFM3_MFS4_I2C_FCR1_FRIIE               *((volatile unsigned int*)(0x427082ACUL))
#define bFM3_MFS4_I2C_FCR1_FLSTE               *((volatile unsigned int*)(0x427082B0UL))
#define bFM3_MFS4_I2C_FBYTE_FD0                *((volatile unsigned int*)(0x42708300UL))
#define bFM3_MFS4_I2C_FBYTE_FD1                *((volatile unsigned int*)(0x42708304UL))
#define bFM3_MFS4_I2C_FBYTE_FD2                *((volatile unsigned int*)(0x42708308UL))
#define bFM3_MFS4_I2C_FBYTE_FD3                *((volatile unsigned int*)(0x4270830CUL))
#define bFM3_MFS4_I2C_FBYTE_FD4                *((volatile unsigned int*)(0x42708310UL))
#define bFM3_MFS4_I2C_FBYTE_FD5                *((volatile unsigned int*)(0x42708314UL))
#define bFM3_MFS4_I2C_FBYTE_FD6                *((volatile unsigned int*)(0x42708318UL))
#define bFM3_MFS4_I2C_FBYTE_FD7                *((volatile unsigned int*)(0x4270831CUL))
#define bFM3_MFS4_I2C_FBYTE_FD8                *((volatile unsigned int*)(0x42708320UL))
#define bFM3_MFS4_I2C_FBYTE_FD9                *((volatile unsigned int*)(0x42708324UL))
#define bFM3_MFS4_I2C_FBYTE_FD10               *((volatile unsigned int*)(0x42708328UL))
#define bFM3_MFS4_I2C_FBYTE_FD11               *((volatile unsigned int*)(0x4270832CUL))
#define bFM3_MFS4_I2C_FBYTE_FD12               *((volatile unsigned int*)(0x42708330UL))
#define bFM3_MFS4_I2C_FBYTE_FD13               *((volatile unsigned int*)(0x42708334UL))
#define bFM3_MFS4_I2C_FBYTE_FD14               *((volatile unsigned int*)(0x42708338UL))
#define bFM3_MFS4_I2C_FBYTE_FD15               *((volatile unsigned int*)(0x4270833CUL))
#define bFM3_MFS4_I2C_FBYTE1_FD0               *((volatile unsigned int*)(0x42708300UL))
#define bFM3_MFS4_I2C_FBYTE1_FD1               *((volatile unsigned int*)(0x42708304UL))
#define bFM3_MFS4_I2C_FBYTE1_FD2               *((volatile unsigned int*)(0x42708308UL))
#define bFM3_MFS4_I2C_FBYTE1_FD3               *((volatile unsigned int*)(0x4270830CUL))
#define bFM3_MFS4_I2C_FBYTE1_FD4               *((volatile unsigned int*)(0x42708310UL))
#define bFM3_MFS4_I2C_FBYTE1_FD5               *((volatile unsigned int*)(0x42708314UL))
#define bFM3_MFS4_I2C_FBYTE1_FD6               *((volatile unsigned int*)(0x42708318UL))
#define bFM3_MFS4_I2C_FBYTE1_FD7               *((volatile unsigned int*)(0x4270831CUL))
#define bFM3_MFS4_I2C_FBYTE2_FD8               *((volatile unsigned int*)(0x42708320UL))
#define bFM3_MFS4_I2C_FBYTE2_FD9               *((volatile unsigned int*)(0x42708324UL))
#define bFM3_MFS4_I2C_FBYTE2_FD10              *((volatile unsigned int*)(0x42708328UL))
#define bFM3_MFS4_I2C_FBYTE2_FD11              *((volatile unsigned int*)(0x4270832CUL))
#define bFM3_MFS4_I2C_FBYTE2_FD12              *((volatile unsigned int*)(0x42708330UL))
#define bFM3_MFS4_I2C_FBYTE2_FD13              *((volatile unsigned int*)(0x42708334UL))
#define bFM3_MFS4_I2C_FBYTE2_FD14              *((volatile unsigned int*)(0x42708338UL))
#define bFM3_MFS4_I2C_FBYTE2_FD15              *((volatile unsigned int*)(0x4270833CUL))

/* UART asynchronous channel 5 registers */
#define bFM3_MFS5_UART_SMR_SOE                 *((volatile unsigned int*)(0x4270A000UL))
#define bFM3_MFS5_UART_SMR_BDS                 *((volatile unsigned int*)(0x4270A008UL))
#define bFM3_MFS5_UART_SMR_SBL                 *((volatile unsigned int*)(0x4270A00CUL))
#define bFM3_MFS5_UART_SMR_WUCR                *((volatile unsigned int*)(0x4270A010UL))
#define bFM3_MFS5_UART_SCR_TXE                 *((volatile unsigned int*)(0x4270A020UL))
#define bFM3_MFS5_UART_SCR_RXE                 *((volatile unsigned int*)(0x4270A024UL))
#define bFM3_MFS5_UART_SCR_TBIE                *((volatile unsigned int*)(0x4270A028UL))
#define bFM3_MFS5_UART_SCR_TIE                 *((volatile unsigned int*)(0x4270A02CUL))
#define bFM3_MFS5_UART_SCR_RIE                 *((volatile unsigned int*)(0x4270A030UL))
#define bFM3_MFS5_UART_SCR_UPCL                *((volatile unsigned int*)(0x4270A03CUL))
#define bFM3_MFS5_UART_ESCR_L0                 *((volatile unsigned int*)(0x4270A080UL))
#define bFM3_MFS5_UART_ESCR_L1                 *((volatile unsigned int*)(0x4270A084UL))
#define bFM3_MFS5_UART_ESCR_L2                 *((volatile unsigned int*)(0x4270A088UL))
#define bFM3_MFS5_UART_ESCR_P                  *((volatile unsigned int*)(0x4270A08CUL))
#define bFM3_MFS5_UART_ESCR_PEN                *((volatile unsigned int*)(0x4270A090UL))
#define bFM3_MFS5_UART_ESCR_INV                *((volatile unsigned int*)(0x4270A094UL))
#define bFM3_MFS5_UART_ESCR_ESBL               *((volatile unsigned int*)(0x4270A098UL))
#define bFM3_MFS5_UART_ESCR_FLWEN              *((volatile unsigned int*)(0x4270A09CUL))
#define bFM3_MFS5_UART_SSR_TBI                 *((volatile unsigned int*)(0x4270A0A0UL))
#define bFM3_MFS5_UART_SSR_TDRE                *((volatile unsigned int*)(0x4270A0A4UL))
#define bFM3_MFS5_UART_SSR_RDRF                *((volatile unsigned int*)(0x4270A0A8UL))
#define bFM3_MFS5_UART_SSR_ORE                 *((volatile unsigned int*)(0x4270A0ACUL))
#define bFM3_MFS5_UART_SSR_FRE                 *((volatile unsigned int*)(0x4270A0B0UL))
#define bFM3_MFS5_UART_SSR_PE                  *((volatile unsigned int*)(0x4270A0B4UL))
#define bFM3_MFS5_UART_SSR_REC                 *((volatile unsigned int*)(0x4270A0BCUL))
#define bFM3_MFS5_UART_RDR_AD                  *((volatile unsigned int*)(0x4270A120UL))
#define bFM3_MFS5_UART_TDR_AD                  *((volatile unsigned int*)(0x4270A120UL))
#define bFM3_MFS5_UART_BGR_EXT                 *((volatile unsigned int*)(0x4270A1BCUL))
#define bFM3_MFS5_UART_BGR1_EXT                *((volatile unsigned int*)(0x4270A1BCUL))
#define bFM3_MFS5_UART_FCR_FE1                 *((volatile unsigned int*)(0x4270A280UL))
#define bFM3_MFS5_UART_FCR_FE2                 *((volatile unsigned int*)(0x4270A284UL))
#define bFM3_MFS5_UART_FCR_FCL1                *((volatile unsigned int*)(0x4270A288UL))
#define bFM3_MFS5_UART_FCR_FCL2                *((volatile unsigned int*)(0x4270A28CUL))
#define bFM3_MFS5_UART_FCR_FSET                *((volatile unsigned int*)(0x4270A290UL))
#define bFM3_MFS5_UART_FCR_FLD                 *((volatile unsigned int*)(0x4270A294UL))
#define bFM3_MFS5_UART_FCR_FLST                *((volatile unsigned int*)(0x4270A298UL))
#define bFM3_MFS5_UART_FCR_FSEL                *((volatile unsigned int*)(0x4270A2A0UL))
#define bFM3_MFS5_UART_FCR_FTIE                *((volatile unsigned int*)(0x4270A2A4UL))
#define bFM3_MFS5_UART_FCR_FDRQ                *((volatile unsigned int*)(0x4270A2A8UL))
#define bFM3_MFS5_UART_FCR_FRIIE               *((volatile unsigned int*)(0x4270A2ACUL))
#define bFM3_MFS5_UART_FCR_FLSTE               *((volatile unsigned int*)(0x4270A2B0UL))
#define bFM3_MFS5_UART_FCR0_FE1                *((volatile unsigned int*)(0x4270A280UL))
#define bFM3_MFS5_UART_FCR0_FE2                *((volatile unsigned int*)(0x4270A284UL))
#define bFM3_MFS5_UART_FCR0_FCL1               *((volatile unsigned int*)(0x4270A288UL))
#define bFM3_MFS5_UART_FCR0_FCL2               *((volatile unsigned int*)(0x4270A28CUL))
#define bFM3_MFS5_UART_FCR0_FSET               *((volatile unsigned int*)(0x4270A290UL))
#define bFM3_MFS5_UART_FCR0_FLD                *((volatile unsigned int*)(0x4270A294UL))
#define bFM3_MFS5_UART_FCR0_FLST               *((volatile unsigned int*)(0x4270A298UL))
#define bFM3_MFS5_UART_FCR1_FSEL               *((volatile unsigned int*)(0x4270A2A0UL))
#define bFM3_MFS5_UART_FCR1_FTIE               *((volatile unsigned int*)(0x4270A2A4UL))
#define bFM3_MFS5_UART_FCR1_FDRQ               *((volatile unsigned int*)(0x4270A2A8UL))
#define bFM3_MFS5_UART_FCR1_FRIIE              *((volatile unsigned int*)(0x4270A2ACUL))
#define bFM3_MFS5_UART_FCR1_FLSTE              *((volatile unsigned int*)(0x4270A2B0UL))
#define bFM3_MFS5_UART_FBYTE_FD0               *((volatile unsigned int*)(0x4270A300UL))
#define bFM3_MFS5_UART_FBYTE_FD1               *((volatile unsigned int*)(0x4270A304UL))
#define bFM3_MFS5_UART_FBYTE_FD2               *((volatile unsigned int*)(0x4270A308UL))
#define bFM3_MFS5_UART_FBYTE_FD3               *((volatile unsigned int*)(0x4270A30CUL))
#define bFM3_MFS5_UART_FBYTE_FD4               *((volatile unsigned int*)(0x4270A310UL))
#define bFM3_MFS5_UART_FBYTE_FD5               *((volatile unsigned int*)(0x4270A314UL))
#define bFM3_MFS5_UART_FBYTE_FD6               *((volatile unsigned int*)(0x4270A318UL))
#define bFM3_MFS5_UART_FBYTE_FD7               *((volatile unsigned int*)(0x4270A31CUL))
#define bFM3_MFS5_UART_FBYTE_FD8               *((volatile unsigned int*)(0x4270A320UL))
#define bFM3_MFS5_UART_FBYTE_FD9               *((volatile unsigned int*)(0x4270A324UL))
#define bFM3_MFS5_UART_FBYTE_FD10              *((volatile unsigned int*)(0x4270A328UL))
#define bFM3_MFS5_UART_FBYTE_FD11              *((volatile unsigned int*)(0x4270A32CUL))
#define bFM3_MFS5_UART_FBYTE_FD12              *((volatile unsigned int*)(0x4270A330UL))
#define bFM3_MFS5_UART_FBYTE_FD13              *((volatile unsigned int*)(0x4270A334UL))
#define bFM3_MFS5_UART_FBYTE_FD14              *((volatile unsigned int*)(0x4270A338UL))
#define bFM3_MFS5_UART_FBYTE_FD15              *((volatile unsigned int*)(0x4270A33CUL))
#define bFM3_MFS5_UART_FBYTE1_FD0              *((volatile unsigned int*)(0x4270A300UL))
#define bFM3_MFS5_UART_FBYTE1_FD1              *((volatile unsigned int*)(0x4270A304UL))
#define bFM3_MFS5_UART_FBYTE1_FD2              *((volatile unsigned int*)(0x4270A308UL))
#define bFM3_MFS5_UART_FBYTE1_FD3              *((volatile unsigned int*)(0x4270A30CUL))
#define bFM3_MFS5_UART_FBYTE1_FD4              *((volatile unsigned int*)(0x4270A310UL))
#define bFM3_MFS5_UART_FBYTE1_FD5              *((volatile unsigned int*)(0x4270A314UL))
#define bFM3_MFS5_UART_FBYTE1_FD6              *((volatile unsigned int*)(0x4270A318UL))
#define bFM3_MFS5_UART_FBYTE1_FD7              *((volatile unsigned int*)(0x4270A31CUL))
#define bFM3_MFS5_UART_FBYTE2_FD8              *((volatile unsigned int*)(0x4270A320UL))
#define bFM3_MFS5_UART_FBYTE2_FD9              *((volatile unsigned int*)(0x4270A324UL))
#define bFM3_MFS5_UART_FBYTE2_FD10             *((volatile unsigned int*)(0x4270A328UL))
#define bFM3_MFS5_UART_FBYTE2_FD11             *((volatile unsigned int*)(0x4270A32CUL))
#define bFM3_MFS5_UART_FBYTE2_FD12             *((volatile unsigned int*)(0x4270A330UL))
#define bFM3_MFS5_UART_FBYTE2_FD13             *((volatile unsigned int*)(0x4270A334UL))
#define bFM3_MFS5_UART_FBYTE2_FD14             *((volatile unsigned int*)(0x4270A338UL))
#define bFM3_MFS5_UART_FBYTE2_FD15             *((volatile unsigned int*)(0x4270A33CUL))

/* UART synchronous channel 5 registers */
#define bFM3_MFS5_CSIO_SMR_SOE                 *((volatile unsigned int*)(0x4270A000UL))
#define bFM3_MFS5_CSIO_SMR_SCKE                *((volatile unsigned int*)(0x4270A004UL))
#define bFM3_MFS5_CSIO_SMR_BDS                 *((volatile unsigned int*)(0x4270A008UL))
#define bFM3_MFS5_CSIO_SMR_SCINV               *((volatile unsigned int*)(0x4270A00CUL))
#define bFM3_MFS5_CSIO_SMR_WUCR                *((volatile unsigned int*)(0x4270A010UL))
#define bFM3_MFS5_CSIO_SCR_TXE                 *((volatile unsigned int*)(0x4270A020UL))
#define bFM3_MFS5_CSIO_SCR_RXE                 *((volatile unsigned int*)(0x4270A024UL))
#define bFM3_MFS5_CSIO_SCR_TBIE                *((volatile unsigned int*)(0x4270A028UL))
#define bFM3_MFS5_CSIO_SCR_TIE                 *((volatile unsigned int*)(0x4270A02CUL))
#define bFM3_MFS5_CSIO_SCR_RIE                 *((volatile unsigned int*)(0x4270A030UL))
#define bFM3_MFS5_CSIO_SCR_SPI                 *((volatile unsigned int*)(0x4270A034UL))
#define bFM3_MFS5_CSIO_SCR_MS                  *((volatile unsigned int*)(0x4270A038UL))
#define bFM3_MFS5_CSIO_SCR_UPCL                *((volatile unsigned int*)(0x4270A03CUL))
#define bFM3_MFS5_CSIO_ESCR_L0                 *((volatile unsigned int*)(0x4270A080UL))
#define bFM3_MFS5_CSIO_ESCR_L1                 *((volatile unsigned int*)(0x4270A084UL))
#define bFM3_MFS5_CSIO_ESCR_L2                 *((volatile unsigned int*)(0x4270A088UL))
#define bFM3_MFS5_CSIO_ESCR_WT0                *((volatile unsigned int*)(0x4270A08CUL))
#define bFM3_MFS5_CSIO_ESCR_WT1                *((volatile unsigned int*)(0x4270A090UL))
#define bFM3_MFS5_CSIO_ESCR_SOP                *((volatile unsigned int*)(0x4270A09CUL))
#define bFM3_MFS5_CSIO_SSR_TBI                 *((volatile unsigned int*)(0x4270A0A0UL))
#define bFM3_MFS5_CSIO_SSR_TDRE                *((volatile unsigned int*)(0x4270A0A4UL))
#define bFM3_MFS5_CSIO_SSR_RDRF                *((volatile unsigned int*)(0x4270A0A8UL))
#define bFM3_MFS5_CSIO_SSR_ORE                 *((volatile unsigned int*)(0x4270A0ACUL))
#define bFM3_MFS5_CSIO_SSR_REC                 *((volatile unsigned int*)(0x4270A0BCUL))
#define bFM3_MFS5_CSIO_FCR_FE1                 *((volatile unsigned int*)(0x4270A280UL))
#define bFM3_MFS5_CSIO_FCR_FE2                 *((volatile unsigned int*)(0x4270A284UL))
#define bFM3_MFS5_CSIO_FCR_FCL1                *((volatile unsigned int*)(0x4270A288UL))
#define bFM3_MFS5_CSIO_FCR_FCL2                *((volatile unsigned int*)(0x4270A28CUL))
#define bFM3_MFS5_CSIO_FCR_FSET                *((volatile unsigned int*)(0x4270A290UL))
#define bFM3_MFS5_CSIO_FCR_FLD                 *((volatile unsigned int*)(0x4270A294UL))
#define bFM3_MFS5_CSIO_FCR_FLST                *((volatile unsigned int*)(0x4270A298UL))
#define bFM3_MFS5_CSIO_FCR_FSEL                *((volatile unsigned int*)(0x4270A2A0UL))
#define bFM3_MFS5_CSIO_FCR_FTIE                *((volatile unsigned int*)(0x4270A2A4UL))
#define bFM3_MFS5_CSIO_FCR_FDRQ                *((volatile unsigned int*)(0x4270A2A8UL))
#define bFM3_MFS5_CSIO_FCR_FRIIE               *((volatile unsigned int*)(0x4270A2ACUL))
#define bFM3_MFS5_CSIO_FCR_FLSTE               *((volatile unsigned int*)(0x4270A2B0UL))
#define bFM3_MFS5_CSIO_FCR0_FE1                *((volatile unsigned int*)(0x4270A280UL))
#define bFM3_MFS5_CSIO_FCR0_FE2                *((volatile unsigned int*)(0x4270A284UL))
#define bFM3_MFS5_CSIO_FCR0_FCL1               *((volatile unsigned int*)(0x4270A288UL))
#define bFM3_MFS5_CSIO_FCR0_FCL2               *((volatile unsigned int*)(0x4270A28CUL))
#define bFM3_MFS5_CSIO_FCR0_FSET               *((volatile unsigned int*)(0x4270A290UL))
#define bFM3_MFS5_CSIO_FCR0_FLD                *((volatile unsigned int*)(0x4270A294UL))
#define bFM3_MFS5_CSIO_FCR0_FLST               *((volatile unsigned int*)(0x4270A298UL))
#define bFM3_MFS5_CSIO_FCR1_FSEL               *((volatile unsigned int*)(0x4270A2A0UL))
#define bFM3_MFS5_CSIO_FCR1_FTIE               *((volatile unsigned int*)(0x4270A2A4UL))
#define bFM3_MFS5_CSIO_FCR1_FDRQ               *((volatile unsigned int*)(0x4270A2A8UL))
#define bFM3_MFS5_CSIO_FCR1_FRIIE              *((volatile unsigned int*)(0x4270A2ACUL))
#define bFM3_MFS5_CSIO_FCR1_FLSTE              *((volatile unsigned int*)(0x4270A2B0UL))
#define bFM3_MFS5_CSIO_FBYTE_FD0               *((volatile unsigned int*)(0x4270A300UL))
#define bFM3_MFS5_CSIO_FBYTE_FD1               *((volatile unsigned int*)(0x4270A304UL))
#define bFM3_MFS5_CSIO_FBYTE_FD2               *((volatile unsigned int*)(0x4270A308UL))
#define bFM3_MFS5_CSIO_FBYTE_FD3               *((volatile unsigned int*)(0x4270A30CUL))
#define bFM3_MFS5_CSIO_FBYTE_FD4               *((volatile unsigned int*)(0x4270A310UL))
#define bFM3_MFS5_CSIO_FBYTE_FD5               *((volatile unsigned int*)(0x4270A314UL))
#define bFM3_MFS5_CSIO_FBYTE_FD6               *((volatile unsigned int*)(0x4270A318UL))
#define bFM3_MFS5_CSIO_FBYTE_FD7               *((volatile unsigned int*)(0x4270A31CUL))
#define bFM3_MFS5_CSIO_FBYTE_FD8               *((volatile unsigned int*)(0x4270A320UL))
#define bFM3_MFS5_CSIO_FBYTE_FD9               *((volatile unsigned int*)(0x4270A324UL))
#define bFM3_MFS5_CSIO_FBYTE_FD10              *((volatile unsigned int*)(0x4270A328UL))
#define bFM3_MFS5_CSIO_FBYTE_FD11              *((volatile unsigned int*)(0x4270A32CUL))
#define bFM3_MFS5_CSIO_FBYTE_FD12              *((volatile unsigned int*)(0x4270A330UL))
#define bFM3_MFS5_CSIO_FBYTE_FD13              *((volatile unsigned int*)(0x4270A334UL))
#define bFM3_MFS5_CSIO_FBYTE_FD14              *((volatile unsigned int*)(0x4270A338UL))
#define bFM3_MFS5_CSIO_FBYTE_FD15              *((volatile unsigned int*)(0x4270A33CUL))
#define bFM3_MFS5_CSIO_FBYTE1_FD0              *((volatile unsigned int*)(0x4270A300UL))
#define bFM3_MFS5_CSIO_FBYTE1_FD1              *((volatile unsigned int*)(0x4270A304UL))
#define bFM3_MFS5_CSIO_FBYTE1_FD2              *((volatile unsigned int*)(0x4270A308UL))
#define bFM3_MFS5_CSIO_FBYTE1_FD3              *((volatile unsigned int*)(0x4270A30CUL))
#define bFM3_MFS5_CSIO_FBYTE1_FD4              *((volatile unsigned int*)(0x4270A310UL))
#define bFM3_MFS5_CSIO_FBYTE1_FD5              *((volatile unsigned int*)(0x4270A314UL))
#define bFM3_MFS5_CSIO_FBYTE1_FD6              *((volatile unsigned int*)(0x4270A318UL))
#define bFM3_MFS5_CSIO_FBYTE1_FD7              *((volatile unsigned int*)(0x4270A31CUL))
#define bFM3_MFS5_CSIO_FBYTE2_FD8              *((volatile unsigned int*)(0x4270A320UL))
#define bFM3_MFS5_CSIO_FBYTE2_FD9              *((volatile unsigned int*)(0x4270A324UL))
#define bFM3_MFS5_CSIO_FBYTE2_FD10             *((volatile unsigned int*)(0x4270A328UL))
#define bFM3_MFS5_CSIO_FBYTE2_FD11             *((volatile unsigned int*)(0x4270A32CUL))
#define bFM3_MFS5_CSIO_FBYTE2_FD12             *((volatile unsigned int*)(0x4270A330UL))
#define bFM3_MFS5_CSIO_FBYTE2_FD13             *((volatile unsigned int*)(0x4270A334UL))
#define bFM3_MFS5_CSIO_FBYTE2_FD14             *((volatile unsigned int*)(0x4270A338UL))
#define bFM3_MFS5_CSIO_FBYTE2_FD15             *((volatile unsigned int*)(0x4270A33CUL))

/* UART LIN channel 5 registers */
#define bFM3_MFS5_LIN_SMR_SOE                  *((volatile unsigned int*)(0x4270A000UL))
#define bFM3_MFS5_LIN_SMR_SBL                  *((volatile unsigned int*)(0x4270A00CUL))
#define bFM3_MFS5_LIN_SMR_WUCR                 *((volatile unsigned int*)(0x4270A010UL))
#define bFM3_MFS5_LIN_SCR_TXE                  *((volatile unsigned int*)(0x4270A020UL))
#define bFM3_MFS5_LIN_SCR_RXE                  *((volatile unsigned int*)(0x4270A024UL))
#define bFM3_MFS5_LIN_SCR_TBIE                 *((volatile unsigned int*)(0x4270A028UL))
#define bFM3_MFS5_LIN_SCR_TIE                  *((volatile unsigned int*)(0x4270A02CUL))
#define bFM3_MFS5_LIN_SCR_RIE                  *((volatile unsigned int*)(0x4270A030UL))
#define bFM3_MFS5_LIN_SCR_LBR                  *((volatile unsigned int*)(0x4270A034UL))
#define bFM3_MFS5_LIN_SCR_MS                   *((volatile unsigned int*)(0x4270A038UL))
#define bFM3_MFS5_LIN_SCR_UPCL                 *((volatile unsigned int*)(0x4270A03CUL))
#define bFM3_MFS5_LIN_ESCR_DEL0                *((volatile unsigned int*)(0x4270A080UL))
#define bFM3_MFS5_LIN_ESCR_DEL1                *((volatile unsigned int*)(0x4270A084UL))
#define bFM3_MFS5_LIN_ESCR_LBL0                *((volatile unsigned int*)(0x4270A088UL))
#define bFM3_MFS5_LIN_ESCR_LBL1                *((volatile unsigned int*)(0x4270A08CUL))
#define bFM3_MFS5_LIN_ESCR_LBIE                *((volatile unsigned int*)(0x4270A090UL))
#define bFM3_MFS5_LIN_ESCR_ESBL                *((volatile unsigned int*)(0x4270A098UL))
#define bFM3_MFS5_LIN_SSR_TBI                  *((volatile unsigned int*)(0x4270A0A0UL))
#define bFM3_MFS5_LIN_SSR_TDRE                 *((volatile unsigned int*)(0x4270A0A4UL))
#define bFM3_MFS5_LIN_SSR_RDRF                 *((volatile unsigned int*)(0x4270A0A8UL))
#define bFM3_MFS5_LIN_SSR_ORE                  *((volatile unsigned int*)(0x4270A0ACUL))
#define bFM3_MFS5_LIN_SSR_FRE                  *((volatile unsigned int*)(0x4270A0B0UL))
#define bFM3_MFS5_LIN_SSR_LBD                  *((volatile unsigned int*)(0x4270A0B4UL))
#define bFM3_MFS5_LIN_SSR_REC                  *((volatile unsigned int*)(0x4270A0BCUL))
#define bFM3_MFS5_LIN_BGR_EXT                  *((volatile unsigned int*)(0x4270A1BCUL))
#define bFM3_MFS5_LIN_BGR1_EXT                 *((volatile unsigned int*)(0x4270A1BCUL))
#define bFM3_MFS5_LIN_FCR_FE1                  *((volatile unsigned int*)(0x4270A280UL))
#define bFM3_MFS5_LIN_FCR_FE2                  *((volatile unsigned int*)(0x4270A284UL))
#define bFM3_MFS5_LIN_FCR_FCL1                 *((volatile unsigned int*)(0x4270A288UL))
#define bFM3_MFS5_LIN_FCR_FCL2                 *((volatile unsigned int*)(0x4270A28CUL))
#define bFM3_MFS5_LIN_FCR_FSET                 *((volatile unsigned int*)(0x4270A290UL))
#define bFM3_MFS5_LIN_FCR_FLD                  *((volatile unsigned int*)(0x4270A294UL))
#define bFM3_MFS5_LIN_FCR_FLST                 *((volatile unsigned int*)(0x4270A298UL))
#define bFM3_MFS5_LIN_FCR_FSEL                 *((volatile unsigned int*)(0x4270A2A0UL))
#define bFM3_MFS5_LIN_FCR_FTIE                 *((volatile unsigned int*)(0x4270A2A4UL))
#define bFM3_MFS5_LIN_FCR_FDRQ                 *((volatile unsigned int*)(0x4270A2A8UL))
#define bFM3_MFS5_LIN_FCR_FRIIE                *((volatile unsigned int*)(0x4270A2ACUL))
#define bFM3_MFS5_LIN_FCR_FLSTE                *((volatile unsigned int*)(0x4270A2B0UL))
#define bFM3_MFS5_LIN_FCR0_FE1                 *((volatile unsigned int*)(0x4270A280UL))
#define bFM3_MFS5_LIN_FCR0_FE2                 *((volatile unsigned int*)(0x4270A284UL))
#define bFM3_MFS5_LIN_FCR0_FCL1                *((volatile unsigned int*)(0x4270A288UL))
#define bFM3_MFS5_LIN_FCR0_FCL2                *((volatile unsigned int*)(0x4270A28CUL))
#define bFM3_MFS5_LIN_FCR0_FSET                *((volatile unsigned int*)(0x4270A290UL))
#define bFM3_MFS5_LIN_FCR0_FLD                 *((volatile unsigned int*)(0x4270A294UL))
#define bFM3_MFS5_LIN_FCR0_FLST                *((volatile unsigned int*)(0x4270A298UL))
#define bFM3_MFS5_LIN_FCR1_FSEL                *((volatile unsigned int*)(0x4270A2A0UL))
#define bFM3_MFS5_LIN_FCR1_FTIE                *((volatile unsigned int*)(0x4270A2A4UL))
#define bFM3_MFS5_LIN_FCR1_FDRQ                *((volatile unsigned int*)(0x4270A2A8UL))
#define bFM3_MFS5_LIN_FCR1_FRIIE               *((volatile unsigned int*)(0x4270A2ACUL))
#define bFM3_MFS5_LIN_FCR1_FLSTE               *((volatile unsigned int*)(0x4270A2B0UL))
#define bFM3_MFS5_LIN_FBYTE_FD0                *((volatile unsigned int*)(0x4270A300UL))
#define bFM3_MFS5_LIN_FBYTE_FD1                *((volatile unsigned int*)(0x4270A304UL))
#define bFM3_MFS5_LIN_FBYTE_FD2                *((volatile unsigned int*)(0x4270A308UL))
#define bFM3_MFS5_LIN_FBYTE_FD3                *((volatile unsigned int*)(0x4270A30CUL))
#define bFM3_MFS5_LIN_FBYTE_FD4                *((volatile unsigned int*)(0x4270A310UL))
#define bFM3_MFS5_LIN_FBYTE_FD5                *((volatile unsigned int*)(0x4270A314UL))
#define bFM3_MFS5_LIN_FBYTE_FD6                *((volatile unsigned int*)(0x4270A318UL))
#define bFM3_MFS5_LIN_FBYTE_FD7                *((volatile unsigned int*)(0x4270A31CUL))
#define bFM3_MFS5_LIN_FBYTE_FD8                *((volatile unsigned int*)(0x4270A320UL))
#define bFM3_MFS5_LIN_FBYTE_FD9                *((volatile unsigned int*)(0x4270A324UL))
#define bFM3_MFS5_LIN_FBYTE_FD10               *((volatile unsigned int*)(0x4270A328UL))
#define bFM3_MFS5_LIN_FBYTE_FD11               *((volatile unsigned int*)(0x4270A32CUL))
#define bFM3_MFS5_LIN_FBYTE_FD12               *((volatile unsigned int*)(0x4270A330UL))
#define bFM3_MFS5_LIN_FBYTE_FD13               *((volatile unsigned int*)(0x4270A334UL))
#define bFM3_MFS5_LIN_FBYTE_FD14               *((volatile unsigned int*)(0x4270A338UL))
#define bFM3_MFS5_LIN_FBYTE_FD15               *((volatile unsigned int*)(0x4270A33CUL))
#define bFM3_MFS5_LIN_FBYTE1_FD0               *((volatile unsigned int*)(0x4270A300UL))
#define bFM3_MFS5_LIN_FBYTE1_FD1               *((volatile unsigned int*)(0x4270A304UL))
#define bFM3_MFS5_LIN_FBYTE1_FD2               *((volatile unsigned int*)(0x4270A308UL))
#define bFM3_MFS5_LIN_FBYTE1_FD3               *((volatile unsigned int*)(0x4270A30CUL))
#define bFM3_MFS5_LIN_FBYTE1_FD4               *((volatile unsigned int*)(0x4270A310UL))
#define bFM3_MFS5_LIN_FBYTE1_FD5               *((volatile unsigned int*)(0x4270A314UL))
#define bFM3_MFS5_LIN_FBYTE1_FD6               *((volatile unsigned int*)(0x4270A318UL))
#define bFM3_MFS5_LIN_FBYTE1_FD7               *((volatile unsigned int*)(0x4270A31CUL))
#define bFM3_MFS5_LIN_FBYTE2_FD8               *((volatile unsigned int*)(0x4270A320UL))
#define bFM3_MFS5_LIN_FBYTE2_FD9               *((volatile unsigned int*)(0x4270A324UL))
#define bFM3_MFS5_LIN_FBYTE2_FD10              *((volatile unsigned int*)(0x4270A328UL))
#define bFM3_MFS5_LIN_FBYTE2_FD11              *((volatile unsigned int*)(0x4270A32CUL))
#define bFM3_MFS5_LIN_FBYTE2_FD12              *((volatile unsigned int*)(0x4270A330UL))
#define bFM3_MFS5_LIN_FBYTE2_FD13              *((volatile unsigned int*)(0x4270A334UL))
#define bFM3_MFS5_LIN_FBYTE2_FD14              *((volatile unsigned int*)(0x4270A338UL))
#define bFM3_MFS5_LIN_FBYTE2_FD15              *((volatile unsigned int*)(0x4270A33CUL))

/* I2C channel 5 registers */
#define bFM3_MFS5_I2C_SMR_TIE                  *((volatile unsigned int*)(0x4270A008UL))
#define bFM3_MFS5_I2C_SMR_RIE                  *((volatile unsigned int*)(0x4270A00CUL))
#define bFM3_MFS5_I2C_SMR_WUCR                 *((volatile unsigned int*)(0x4270A010UL))
#define bFM3_MFS5_I2C_IBCR_INT                 *((volatile unsigned int*)(0x4270A020UL))
#define bFM3_MFS5_I2C_IBCR_BER                 *((volatile unsigned int*)(0x4270A024UL))
#define bFM3_MFS5_I2C_IBCR_INTE                *((volatile unsigned int*)(0x4270A028UL))
#define bFM3_MFS5_I2C_IBCR_CNDE                *((volatile unsigned int*)(0x4270A02CUL))
#define bFM3_MFS5_I2C_IBCR_WSEL                *((volatile unsigned int*)(0x4270A030UL))
#define bFM3_MFS5_I2C_IBCR_ACKE                *((volatile unsigned int*)(0x4270A034UL))
#define bFM3_MFS5_I2C_IBCR_ACT                 *((volatile unsigned int*)(0x4270A038UL))
#define bFM3_MFS5_I2C_IBCR_SCC                 *((volatile unsigned int*)(0x4270A038UL))
#define bFM3_MFS5_I2C_IBCR_MSS                 *((volatile unsigned int*)(0x4270A03CUL))
#define bFM3_MFS5_I2C_IBSR_BB                  *((volatile unsigned int*)(0x4270A080UL))
#define bFM3_MFS5_I2C_IBSR_SPC                 *((volatile unsigned int*)(0x4270A084UL))
#define bFM3_MFS5_I2C_IBSR_RSC                 *((volatile unsigned int*)(0x4270A088UL))
#define bFM3_MFS5_I2C_IBSR_AL                  *((volatile unsigned int*)(0x4270A08CUL))
#define bFM3_MFS5_I2C_IBSR_TRX                 *((volatile unsigned int*)(0x4270A090UL))
#define bFM3_MFS5_I2C_IBSR_RSA                 *((volatile unsigned int*)(0x4270A094UL))
#define bFM3_MFS5_I2C_IBSR_RACK                *((volatile unsigned int*)(0x4270A098UL))
#define bFM3_MFS5_I2C_IBSR_FBT                 *((volatile unsigned int*)(0x4270A09CUL))
#define bFM3_MFS5_I2C_SSR_TBI                  *((volatile unsigned int*)(0x4270A0A0UL))
#define bFM3_MFS5_I2C_SSR_TDRE                 *((volatile unsigned int*)(0x4270A0A4UL))
#define bFM3_MFS5_I2C_SSR_RDRF                 *((volatile unsigned int*)(0x4270A0A8UL))
#define bFM3_MFS5_I2C_SSR_ORE                  *((volatile unsigned int*)(0x4270A0ACUL))
#define bFM3_MFS5_I2C_SSR_TBIE                 *((volatile unsigned int*)(0x4270A0B0UL))
#define bFM3_MFS5_I2C_SSR_DMA                  *((volatile unsigned int*)(0x4270A0B4UL))
#define bFM3_MFS5_I2C_SSR_TSET                 *((volatile unsigned int*)(0x4270A0B8UL))
#define bFM3_MFS5_I2C_SSR_REC                  *((volatile unsigned int*)(0x4270A0BCUL))
#define bFM3_MFS5_I2C_ISBA_SA0                 *((volatile unsigned int*)(0x4270A200UL))
#define bFM3_MFS5_I2C_ISBA_SA1                 *((volatile unsigned int*)(0x4270A204UL))
#define bFM3_MFS5_I2C_ISBA_SA2                 *((volatile unsigned int*)(0x4270A208UL))
#define bFM3_MFS5_I2C_ISBA_SA3                 *((volatile unsigned int*)(0x4270A20CUL))
#define bFM3_MFS5_I2C_ISBA_SA4                 *((volatile unsigned int*)(0x4270A210UL))
#define bFM3_MFS5_I2C_ISBA_SA5                 *((volatile unsigned int*)(0x4270A214UL))
#define bFM3_MFS5_I2C_ISBA_SA6                 *((volatile unsigned int*)(0x4270A218UL))
#define bFM3_MFS5_I2C_ISBA_SAEN                *((volatile unsigned int*)(0x4270A21CUL))
#define bFM3_MFS5_I2C_ISMK_SM0                 *((volatile unsigned int*)(0x4270A220UL))
#define bFM3_MFS5_I2C_ISMK_SM1                 *((volatile unsigned int*)(0x4270A224UL))
#define bFM3_MFS5_I2C_ISMK_SM2                 *((volatile unsigned int*)(0x4270A228UL))
#define bFM3_MFS5_I2C_ISMK_SM3                 *((volatile unsigned int*)(0x4270A22CUL))
#define bFM3_MFS5_I2C_ISMK_SM4                 *((volatile unsigned int*)(0x4270A230UL))
#define bFM3_MFS5_I2C_ISMK_SM5                 *((volatile unsigned int*)(0x4270A234UL))
#define bFM3_MFS5_I2C_ISMK_SM6                 *((volatile unsigned int*)(0x4270A238UL))
#define bFM3_MFS5_I2C_ISMK_EN                  *((volatile unsigned int*)(0x4270A23CUL))
#define bFM3_MFS5_I2C_FCR_FE1                  *((volatile unsigned int*)(0x4270A280UL))
#define bFM3_MFS5_I2C_FCR_FE2                  *((volatile unsigned int*)(0x4270A284UL))
#define bFM3_MFS5_I2C_FCR_FCL1                 *((volatile unsigned int*)(0x4270A288UL))
#define bFM3_MFS5_I2C_FCR_FCL2                 *((volatile unsigned int*)(0x4270A28CUL))
#define bFM3_MFS5_I2C_FCR_FSET                 *((volatile unsigned int*)(0x4270A290UL))
#define bFM3_MFS5_I2C_FCR_FLD                