

/**
 *  @Component:   EMIF
 *
 *  @Filename:    ../../CredDataBase/emif4d_cred.h
 *
 ============================================================================ */
/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



#ifndef _HW_EMIF_H_
#define _HW_EMIF_H_

#ifdef __cplusplus
extern "C" {
#endif


/***********************************************************************\
 * Register arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundle arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundles Definition
\***********************************************************************/



/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define EMIF_MOD_ID_REV   (0x0)
#define EMIF_STATUS   (0x4)
#define EMIF_SDRAM_CONFIG   (0x8)
#define EMIF_SDRAM_CONFIG_2   (0xC)
#define EMIF_SDRAM_REF_CTRL   (0x10)
#define EMIF_SDRAM_REF_CTRL_SHDW   (0x14)
#define EMIF_SDRAM_TIM_1   (0x18)
#define EMIF_SDRAM_TIM_1_SHDW  (0x1C)
#define EMIF_SDRAM_TIM_2   (0x20)
#define EMIF_SDRAM_TIM_2_SHDW  (0x24)
#define EMIF_SDRAM_TIM_3   (0x28)
#define EMIF_SDRAM_TIM_3_SHDW  (0x2C)
#define EMIF_LPDDR_NVM_TIM2   (0x30)
#define EMIF_LPDDR_NVM_TIM_SHDW2   (0x34)
#define EMIF_PWR_MGMT_CTRL   (0x38)
#define EMIF_PWR_MGMT_CTRL_SHDW   (0x3C)
#define EMIF_LPDDR_MODE_REG_DATA2   (0x40)
#define EMIF_LPDDR_MODE_REG_CFG2   (0x50)
#define EMIF_L3_CONFIG   (0x54)
#define EMIF_L3_CONFIG_VAL_(n)   (0x58 + (n * 4))
#define EMIF_IODFT_TLGC	(0x60)
#define EMIF_IODFT_DATA_MISR_RSLT_(n)   (0x6C + (n * 4))
#define EMIF_PERF_CNT_(n)   (0x80 + (n * 4))
#define EMIF_PERF_CNT_CFG   (0x88)
#define EMIF_PERF_CNT_SEL   (0x8C)
#define EMIF_PERF_CNT_TIM   (0x90)
#define EMIF_READ_IDLE_CTRL   (0x98)
#define EMIF_READ_IDLE_CTRL_SHDW   (0x9C)
#define EMIF_IRQSTATUS_RAW_SYS   (0xA4)
#define EMIF_IRQSTATUS_RAW_LL   (0xA8)
#define EMIF_IRQSTATUS_SYS   (0xAC)
#define EMIF_IRQSTATUS_LL   (0xB0)
#define EMIF_IRQENABLE_SET_SYS   (0xB4)
#define EMIF_IRQENABLE_SET_LL   (0xB8)
#define EMIF_IRQENABLE_CLR_SYS   (0xBC)
#define EMIF_IRQENABLE_CLR_LL   (0xC0)
#define EMIF_ZQ_CONFIG   (0xC8)
#define EMIF_TEMP_ALERT_CONFIG   (0xCC)
#define EMIF_L3_ERR_LOG   (0xD0)
#define EMIF_DDR_PHY_CTRL_1   (0xE4)
#define EMIF_DDR_PHY_CTRL_1_SHDW  (0xE8)
#define EMIF_DDR_PHY_CTRL_2   (0xEC)

/**************************************************************************\
 * Field Definition Macros
\**************************************************************************/

/* MOD_ID_REV */

/* STATUS */
#define EMIF_STATUS_REG_BE   (0x80000000u)
#define EMIF_STATUS_REG_BE_SHIFT   (0x0000001Fu)

#define EMIF_STATUS_REG_DUAL_CLK_MODE   (0x40000000u)
#define EMIF_STATUS_REG_DUAL_CLK_MODE_SHIFT   (0x0000001Eu)

#define EMIF_STATUS_REG_FAST_INIT   (0x20000000u)
#define EMIF_STATUS_REG_FAST_INIT_SHIFT   (0x0000001Du)

#define EMIF_STATUS_REG_PHY_DLL_READY   (0x00000004u)
#define EMIF_STATUS_REG_PHY_DLL_READY_SHIFT   (0x00000002u)


/* SDRAM_CONFIG */
#define EMIF_SDRAM_CONFIG_REG_CL   (0x00003C00u)
#define EMIF_SDRAM_CONFIG_REG_CL_SHIFT   (0x0000000Au)

#define EMIF_SDRAM_CONFIG_REG_CWL   (0x00030000u)
#define EMIF_SDRAM_CONFIG_REG_CWL_SHIFT   (0x00000010u)

#define EMIF_SDRAM_CONFIG_REG_DDR2_DDQS   (0x00800000u)
#define EMIF_SDRAM_CONFIG_REG_DDR2_DDQS_SHIFT   (0x00000017u)
#define EMIF_SDRAM_CONFIG_REG_DDR2_DDQS_DIFFERENTIAL   (0x1u)
#define EMIF_SDRAM_CONFIG_REG_DDR2_DDQS_SINGLE   (0x0u)

#define EMIF_SDRAM_CONFIG_REG_DDR_DISABLE_DLL   (0x00100000u)
#define EMIF_SDRAM_CONFIG_REG_DDR_DISABLE_DLL_SHIFT   (0x00000014u)

#define EMIF_SDRAM_CONFIG_REG_DDR_TERM   (0x07000000u)
#define EMIF_SDRAM_CONFIG_REG_DDR_TERM_SHIFT   (0x00000018u)

#define EMIF_SDRAM_CONFIG_REG_DYN_ODT   (0x00600000u)
#define EMIF_SDRAM_CONFIG_REG_DYN_ODT_SHIFT   (0x00000015u)

#define EMIF_SDRAM_CONFIG_REG_EBANK   (0x00000008u)
#define EMIF_SDRAM_CONFIG_REG_EBANK_SHIFT   (0x00000003u)
#define EMIF_SDRAM_CONFIG_REG_EBANK_1_LINE   (0x0u)
#define EMIF_SDRAM_CONFIG_REG_EBANK_2_LINE   (0x1u)

#define EMIF_SDRAM_CONFIG_REG_IBANK   (0x00000070u)
#define EMIF_SDRAM_CONFIG_REG_IBANK_SHIFT   (0x00000004u)
#define EMIF_SDRAM_CONFIG_REG_IBANK_1_BANK   (0x0u)
#define EMIF_SDRAM_CONFIG_REG_IBANK_2_BANK   (0x1u)
#define EMIF_SDRAM_CONFIG_REG_IBANK_4_BANK   (0x2u)
#define EMIF_SDRAM_CONFIG_REG_IBANK_8_BANK   (0x3u)

#define EMIF_SDRAM_CONFIG_REG_IBANK_POS   (0x18000000u)
#define EMIF_SDRAM_CONFIG_REG_IBANK_POS_SHIFT   (0x0000001Bu)

#define EMIF_SDRAM_CONFIG_REG_NARROW_MODE   (0x0000C000u)
#define EMIF_SDRAM_CONFIG_REG_NARROW_MODE_SHIFT   (0x0000000Eu)

#define EMIF_SDRAM_CONFIG_REG_PAGESIZE   (0x00000007u)
#define EMIF_SDRAM_CONFIG_REG_PAGESIZE_SHIFT   (0x00000000u)
#define EMIF_SDRAM_CONFIG_REG_PAGESIZE_1024_WORD   (0x2u)
#define EMIF_SDRAM_CONFIG_REG_PAGESIZE_2048_WORD   (0x3u)
#define EMIF_SDRAM_CONFIG_REG_PAGESIZE_256_WORD   (0x0u)
#define EMIF_SDRAM_CONFIG_REG_PAGESIZE_512_WORD   (0x1u)

#define EMIF_SDRAM_CONFIG_REG_ROWSIZE   (0x00000380u)
#define EMIF_SDRAM_CONFIG_REG_ROWSIZE_SHIFT   (0x00000007u)
#define EMIF_SDRAM_CONFIG_REG_ROWSIZE_10_ROW_BITS   (0x1u)
#define EMIF_SDRAM_CONFIG_REG_ROWSIZE_11_ROW_BITS   (0x2u)
#define EMIF_SDRAM_CONFIG_REG_ROWSIZE_12_ROW_BITS   (0x3u)
#define EMIF_SDRAM_CONFIG_REG_ROWSIZE_13_ROW_BITS   (0x4u)
#define EMIF_SDRAM_CONFIG_REG_ROWSIZE_14_ROW_BITS   (0x5u)
#define EMIF_SDRAM_CONFIG_REG_ROWSIZE_15_ROW_BITS   (0x6u)
#define EMIF_SDRAM_CONFIG_REG_ROWSIZE_16_ROW_BITS   (0x7u)
#define EMIF_SDRAM_CONFIG_REG_ROWSIZE_9_ROW_BITS   (0x0u)

#define EMIF_SDRAM_CONFIG_REG_SDRAM_DRIVE   (0x000C0000u)
#define EMIF_SDRAM_CONFIG_REG_SDRAM_DRIVE_SHIFT   (0x00000012u)

#define EMIF_SDRAM_CONFIG_REG_SDRAM_TYPE   (0xE0000000u)
#define EMIF_SDRAM_CONFIG_REG_SDRAM_TYPE_SHIFT   (0x0000001Du)
#define EMIF_SDRAM_CONFIG_REG_SDRAM_TYPE_LPDDR2_S2   (0x5u)
#define EMIF_SDRAM_CONFIG_REG_SDRAM_TYPE_LPDDR2_S4   (0x4u)


/* SDRAM_CONFIG_2 */
#define EMIF_SDRAM_CONFIG_2_REG_CS1NVMEN   (0x40000000u)
#define EMIF_SDRAM_CONFIG_2_REG_CS1NVMEN_SHIFT   (0x0000001Eu)

#define EMIF_SDRAM_CONFIG_2_REG_EBANK_POS   (0x08000000u)
#define EMIF_SDRAM_CONFIG_2_REG_EBANK_POS_SHIFT   (0x0000001Bu)

#define EMIF_SDRAM_CONFIG_2_REG_RDBNUM   (0x00000030u)
#define EMIF_SDRAM_CONFIG_2_REG_RDBNUM_SHIFT   (0x00000004u)

#define EMIF_SDRAM_CONFIG_2_REG_RDBSIZE   (0x00000007u)
#define EMIF_SDRAM_CONFIG_2_REG_RDBSIZE_SHIFT   (0x00000000u)


/* SDRAM_REF_CTRL */
#define EMIF_SDRAM_REF_CTRL_REG_INITREF_DIS   (0x80000000u)
#define EMIF_SDRAM_REF_CTRL_REG_INITREF_DIS_SHIFT   (0x0000001Fu)

#define EMIF_SDRAM_REF_CTRL_REG_REFRESH_RATE   (0x0000FFFFu)
#define EMIF_SDRAM_REF_CTRL_REG_REFRESH_RATE_SHIFT   (0x00000000u)


/* SDRAM_REF_CTRL_SHDW */
#define EMIF_SDRAM_REF_CTRL_SHDW_REG_REFRESH_RATE_SHDW   (0x0000FFFFu)
#define EMIF_SDRAM_REF_CTRL_SHDW_REG_REFRESH_RATE_SHDW_SHIFT   (0x00000000u)


/* SDRAM_TIM_1 */
#define EMIF_SDRAM_TIM_1_REG_T_RAS   (0x0001F000u)
#define EMIF_SDRAM_TIM_1_REG_T_RAS_SHIFT   (0x0000000Cu)

#define EMIF_SDRAM_TIM_1_REG_T_RC   (0x00000FC0u)
#define EMIF_SDRAM_TIM_1_REG_T_RC_SHIFT   (0x00000006u)

#define EMIF_SDRAM_TIM_1_REG_T_RCD   (0x01E00000u)
#define EMIF_SDRAM_TIM_1_REG_T_RCD_SHIFT   (0x00000015u)

#define EMIF_SDRAM_TIM_1_REG_T_RP   (0x1E000000u)
#define EMIF_SDRAM_TIM_1_REG_T_RP_SHIFT   (0x00000019u)

#define EMIF_SDRAM_TIM_1_REG_T_RRD   (0x00000038u)
#define EMIF_SDRAM_TIM_1_REG_T_RRD_SHIFT   (0x00000003u)

#define EMIF_SDRAM_TIM_1_REG_T_WR   (0x001E0000u)
#define EMIF_SDRAM_TIM_1_REG_T_WR_SHIFT   (0x00000011u)

#define EMIF_SDRAM_TIM_1_REG_T_WTR   (0x00000007u)
#define EMIF_SDRAM_TIM_1_REG_T_WTR_SHIFT   (0x00000000u)


/* SDRAM_TIM_1_SHDW */
#define EMIF_SDRAM_TIM_1_SHDW_REG_T_RAS_SHDW   (0x0001F000u)
#define EMIF_SDRAM_TIM_1_SHDW_REG_T_RAS_SHDW_SHIFT   (0x0000000Cu)








/* SDRAM_TIM_2 */
#define EMIF_SDRAM_TIM_2_REG_T_CKE   (0x00000007u)
#define EMIF_SDRAM_TIM_2_REG_T_CKE_SHIFT   (0x00000000u)

#define EMIF_SDRAM_TIM_2_REG_T_RTP   (0x00000038u)
#define EMIF_SDRAM_TIM_2_REG_T_RTP_SHIFT   (0x00000003u)

#define EMIF_SDRAM_TIM_2_REG_T_XP   (0x70000000u)
#define EMIF_SDRAM_TIM_2_REG_T_XP_SHIFT   (0x0000001Cu)

#define EMIF_SDRAM_TIM_2_REG_T_XSNR   (0x01FF0000u)
#define EMIF_SDRAM_TIM_2_REG_T_XSNR_SHIFT   (0x00000010u)

#define EMIF_SDRAM_TIM_2_REG_T_XSRD   (0x0000FFC0u)
#define EMIF_SDRAM_TIM_2_REG_T_XSRD_SHIFT   (0x00000006u)


/* SDRAM_TIM_2_SHDW */
#define EMIF_SDRAM_TIM_2_SHDW_REG_T_CKE_SHDW   (0x00000007u)
#define EMIF_SDRAM_TIM_2_SHDW_REG_T_CKE_SHDW_SHIFT   (0x00000000u)







/* SDRAM_TIM_3 */
#define EMIF_SDRAM_TIM_3_REG_T_CKESR   (0x00E00000u)
#define EMIF_SDRAM_TIM_3_REG_T_CKESR_SHIFT   (0x00000015u)

#define EMIF_SDRAM_TIM_3_REG_T_RAS_MAX   (0x0000000Fu)
#define EMIF_SDRAM_TIM_3_REG_T_RAS_MAX_SHIFT   (0x00000000u)

#define EMIF_SDRAM_TIM_3_REG_T_RFC   (0x00001FF0u)
#define EMIF_SDRAM_TIM_3_REG_T_RFC_SHIFT   (0x00000004u)

#define EMIF_SDRAM_TIM_3_REG_T_TDQSCKMAX   (0x00006000u)
#define EMIF_SDRAM_TIM_3_REG_T_TDQSCKMAX_SHIFT   (0x0000000Du)

#define EMIF_SDRAM_TIM_3_REG_ZQ_ZQCS   (0x001F8000u)
#define EMIF_SDRAM_TIM_3_REG_ZQ_ZQCS_SHIFT   (0x0000000Fu)


/* SDRAM_TIM_3_SHDW */
#define EMIF_SDRAM_TIM_3_SHDW_REG_T_CKESR_SHDW   (0x00E00000u)
#define EMIF_SDRAM_TIM_3_SHDW_REG_T_CKESR_SHDW_SHIFT   (0x00000015u)






/* LPDDR2_NVM_TIM */
#define EMIF_LPDDR2_NVM_TIM_REG_NVM_T_RCDMIN   (0x000000FFu)
#define EMIF_LPDDR2_NVM_TIM_REG_NVM_T_RCDMIN_SHIFT   (0x00000000u)







/* LPDDR2_NVM_TIM_SHDW */
#define EMIF_LPDDR2_NVM_TIM_SHDW_REG_NVM_T_RCDMIN_SHDW   (0x000000FFu)
#define EMIF_LPDDR2_NVM_TIM_SHDW_REG_NVM_T_RCDMIN_SHDW_SHIFT   (0x00000000u)







/* PWR_MGMT_CTRL */
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM   (0x0000000Fu)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_SHIFT   (0x00000000u)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_1024_CLKS   (0x7u)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_128_CLKS   (0x4u)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_131072_CLKS   (0xEu)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_16384_CLKS   (0xBu)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_16_CLKS   (0x1u)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_2048_CLKS   (0x8u)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_256_CLKS   (0x5u)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_262144_CLKS   (0xFu)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_32768_CLKS   (0xCu)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_32_CLKS   (0x2u)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_4096_CLKS   (0x9u)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_512_CLKS   (0x6u)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_64_CLKS   (0x3u)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_65536_CLKS   (0xDu)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_8192_CLKS   (0xAu)
#define EMIF_PWR_MGMT_CTRL_REG_CS_TIM_SELFREFRESH   (0x0u)

#define EMIF_PWR_MGMT_CTRL_REG_DPD_EN   (0x00000800u)
#define EMIF_PWR_MGMT_CTRL_REG_DPD_EN_SHIFT   (0x0000000Bu)
#define EMIF_PWR_MGMT_CTRL_REG_DPD_EN_NORMAL   (0x0u)

#define EMIF_PWR_MGMT_CTRL_REG_LP_MODE   (0x00000700u)
#define EMIF_PWR_MGMT_CTRL_REG_LP_MODE_SHIFT   (0x00000008u)
#define EMIF_PWR_MGMT_CTRL_REG_LP_MODE_SELFREFRESH   (0x2u)

#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM   (0x0000F000u)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_SHIFT   (0x0000000Cu)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_1024_CLKS   (0x7u)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_128_CLKS   (0x4u)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_131072_CLKS   (0xEu)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_16384_CLKS   (0xBu)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_16_CLKS   (0x1u)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_2048_CLKS   (0x8u)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_256_CLKS   (0x5u)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_262144_CLKS   (0xFu)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_32768_CLKS   (0xCu)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_32_CLKS   (0x2u)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_4096_CLKS   (0x9u)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_512_CLKS   (0x6u)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_64_CLKS   (0x3u)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_65536_CLKS   (0xDu)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_8192_CLKS   (0xAu)
#define EMIF_PWR_MGMT_CTRL_REG_PD_TIM_POWERDOWN   (0x0u)

#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM   (0x000000F0u)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_SHIFT   (0x00000004u)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_1024_CLKS   (0x7u)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_128_CLKS   (0x4u)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_131072_CLKS   (0xEu)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_16384_CLKS   (0xBu)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_16_CLKS   (0x1u)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_2048_CLKS   (0x8u)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_256_CLKS   (0x5u)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_262144_CLKS   (0xFu)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_32768_CLKS   (0xCu)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_32_CLKS   (0x2u)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_4096_CLKS   (0x9u)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_512_CLKS   (0x6u)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_64_CLKS   (0x3u)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_65536_CLKS   (0xDu)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_8192_CLKS   (0xAu)
#define EMIF_PWR_MGMT_CTRL_REG_SR_TIM_CLKSTOP   (0x0u)


/* PWR_MGMT_CTRL_SHDW */
#define EMIF_PWR_MGMT_CTRL_SHDW_REG_CS_TIM_SHDW   (0x0000000Fu)
#define EMIF_PWR_MGMT_CTRL_SHDW_REG_CS_TIM_SHDW_SHIFT   (0x00000000u)

#define EMIF_PWR_MGMT_CTRL_SHDW_REG_PD_TIM_SHDW   (0x00000F00u)
#define EMIF_PWR_MGMT_CTRL_SHDW_REG_PD_TIM_SHDW_SHIFT   (0x00000008u)

#define EMIF_PWR_MGMT_CTRL_SHDW_REG_SR_TIM_SHDW   (0x000000F0u)
#define EMIF_PWR_MGMT_CTRL_SHDW_REG_SR_TIM_SHDW_SHIFT   (0x00000004u)


/* LPDDR2_MODE_REG_DATA */
#define EMIF_LPDDR2_MODE_REG_DATA_REG_VALUE_0   (0x0000007Fu)
#define EMIF_LPDDR2_MODE_REG_DATA_REG_VALUE_0_SHIFT   (0x00000000u)


/* LPDDR2_MODE_REG_CFG */
#define EMIF_LPDDR2_MODE_REG_CFG_REG_ADDRESS   (0x000000FFu)
#define EMIF_LPDDR2_MODE_REG_CFG_REG_ADDRESS_SHIFT   (0x00000000u)




/* L3_CONFIG */
#define EMIF_L3_CONFIG_REG_LL_THRESH_MAX   (0x000F0000u)
#define EMIF_L3_CONFIG_REG_LL_THRESH_MAX_SHIFT   (0x00000010u)

#define EMIF_L3_CONFIG_REG_PR_OLD_COUNT   (0x000000FFu)
#define EMIF_L3_CONFIG_REG_PR_OLD_COUNT_SHIFT   (0x00000000u)

#define EMIF_L3_CONFIG_REG_SYS_THRESH_MAX   (0x0F000000u)
#define EMIF_L3_CONFIG_REG_SYS_THRESH_MAX_SHIFT   (0x00000018u)


/* L3_CONFIG_VAL_1 */
#define EMIF_L3_CONFIG_VAL_1_REG_CMD_FIFO_DEPTH   (0x000000FFu)
#define EMIF_L3_CONFIG_VAL_1_REG_CMD_FIFO_DEPTH_SHIFT   (0x00000000u)

#define EMIF_L3_CONFIG_VAL_1_REG_LL_BUS_WIDTH   (0x30000000u)
#define EMIF_L3_CONFIG_VAL_1_REG_LL_BUS_WIDTH_SHIFT   (0x0000001Cu)

#define EMIF_L3_CONFIG_VAL_1_REG_SYS_BUS_WIDTH   (0xC0000000u)
#define EMIF_L3_CONFIG_VAL_1_REG_SYS_BUS_WIDTH_SHIFT   (0x0000001Eu)

#define EMIF_L3_CONFIG_VAL_1_REG_WR_FIFO_DEPTH   (0x0000FF00u)
#define EMIF_L3_CONFIG_VAL_1_REG_WR_FIFO_DEPTH_SHIFT   (0x00000008u)


/* L3_CONFIG_VAL_2 */
#define EMIF_L3_CONFIG_VAL_2_REG_RCMD_FIFO_DEPTH   (0x000000FFu)
#define EMIF_L3_CONFIG_VAL_2_REG_RCMD_FIFO_DEPTH_SHIFT   (0x00000000u)

#define EMIF_L3_CONFIG_VAL_2_REG_RREG_FIFO_DEPTH   (0x00FF0000u)
#define EMIF_L3_CONFIG_VAL_2_REG_RREG_FIFO_DEPTH_SHIFT   (0x00000010u)

#define EMIF_L3_CONFIG_VAL_2_REG_RSD_FIFO_DEPTH   (0x0000FF00u)
#define EMIF_L3_CONFIG_VAL_2_REG_RSD_FIFO_DEPTH_SHIFT   (0x00000008u)


/* IODFT_TLGC */

/* IODFT_CTRL_MISR_RSLT */

/* IODFT_ADDR_MISR_RSLT */

/* IODFT_DATA_MISR_RSLT_1 */

/* IODFT_DATA_MISR_RSLT_2 */

/* IODFT_DATA_MISR_RSLT_3 */

/* PERF_CNT_1 */
#define EMIF_PERF_CNT_1_REG_COUNTER1   (0xFFFFFFFFu)
#define EMIF_PERF_CNT_1_REG_COUNTER1_SHIFT   (0x00000000u)


/* PERF_CNT_2 */
#define EMIF_PERF_CNT_2_REG_COUNTER2   (0xFFFFFFFFu)
#define EMIF_PERF_CNT_2_REG_COUNTER2_SHIFT   (0x00000000u)


/* PERF_CNT_CFG */
#define EMIF_PERF_CNT_CFG_REG_CNTR1_CFG   (0x0000000Fu)
#define EMIF_PERF_CNT_CFG_REG_CNTR1_CFG_SHIFT   (0x00000000u)

#define EMIF_PERF_CNT_CFG_REG_CNTR1_MCONNID_EN   (0x00008000u)
#define EMIF_PERF_CNT_CFG_REG_CNTR1_MCONNID_EN_SHIFT   (0x0000000Fu)

#define EMIF_PERF_CNT_CFG_REG_CNTR1_REGION_EN   (0x00004000u)
#define EMIF_PERF_CNT_CFG_REG_CNTR1_REGION_EN_SHIFT   (0x0000000Eu)

#define EMIF_PERF_CNT_CFG_REG_CNTR2_CFG   (0x000F0000u)
#define EMIF_PERF_CNT_CFG_REG_CNTR2_CFG_SHIFT   (0x00000010u)

#define EMIF_PERF_CNT_CFG_REG_CNTR2_MCONNID_EN   (0x80000000u)
#define EMIF_PERF_CNT_CFG_REG_CNTR2_MCONNID_EN_SHIFT   (0x0000001Fu)

#define EMIF_PERF_CNT_CFG_REG_CNTR2_REGION_EN   (0x40000000u)
#define EMIF_PERF_CNT_CFG_REG_CNTR2_REGION_EN_SHIFT   (0x0000001Eu)


/* PERF_CNT_SEL */
#define EMIF_PERF_CNT_SEL_REG_MCONNID1   (0x0000FF00u)
#define EMIF_PERF_CNT_SEL_REG_MCONNID1_SHIFT   (0x00000008u)

#define EMIF_PERF_CNT_SEL_REG_MCONNID2   (0xFF000000u)
#define EMIF_PERF_CNT_SEL_REG_MCONNID2_SHIFT   (0x00000018u)

#define EMIF_PERF_CNT_SEL_REG_REGION_SEL1   (0x00000003u)
#define EMIF_PERF_CNT_SEL_REG_REGION_SEL1_SHIFT   (0x00000000u)

#define EMIF_PERF_CNT_SEL_REG_REGION_SEL2   (0x00030000u)
#define EMIF_PERF_CNT_SEL_REG_REGION_SEL2_SHIFT   (0x00000010u)


/* PERF_CNT_TIM */
#define EMIF_PERF_CNT_TIM_REG_TOTAL_TIME   (0xFFFFFFFFu)
#define EMIF_PERF_CNT_TIM_REG_TOTAL_TIME_SHIFT   (0x00000000u)


/* READ_IDLE_CTRL */
#define EMIF_READ_IDLE_CTRL_REG_READ_IDLE_INTERVAL   (0x000001FFu)
#define EMIF_READ_IDLE_CTRL_REG_READ_IDLE_INTERVAL_SHIFT   (0x00000000u)

#define EMIF_READ_IDLE_CTRL_REG_READ_IDLE_LEN   (0x000F0000u)
#define EMIF_READ_IDLE_CTRL_REG_READ_IDLE_LEN_SHIFT   (0x00000010u)


/* READ_IDLE_CTRL_SHDW */
#define EMIF_READ_IDLE_CTRL_SHDW_REG_READ_IDLE_INTERVAL_SHDW   (0x000001FFu)
#define EMIF_READ_IDLE_CTRL_SHDW_REG_READ_IDLE_INTERVAL_SHDW_SHIFT   (0x00000000u)

#define EMIF_READ_IDLE_CTRL_SHDW_REG_READ_IDLE_LEN_SHDW   (0x000F0000u)
#define EMIF_READ_IDLE_CTRL_SHDW_REG_READ_IDLE_LEN_SHDW_SHIFT   (0x00000010u)


/* IRQ_EOI */

/* IRQSTATUS_RAW_SYS */
#define EMIF_IRQSTATUS_RAW_SYS_REG_DNV_SYS   (0x00000004u)
#define EMIF_IRQSTATUS_RAW_SYS_REG_DNV_SYS_SHIFT   (0x00000002u)
#define EMIF_IRQSTATUS_RAW_SYS_REG_DNV_SYS_NO   (0x0u)
#define EMIF_IRQSTATUS_RAW_SYS_REG_DNV_SYS_SET   (0x1u)

#define EMIF_IRQSTATUS_RAW_SYS_REG_ERR_SYS   (0x00000001u)
#define EMIF_IRQSTATUS_RAW_SYS_REG_ERR_SYS_SHIFT   (0x00000000u)
#define EMIF_IRQSTATUS_RAW_SYS_REG_ERR_SYS_NO   (0x0u)
#define EMIF_IRQSTATUS_RAW_SYS_REG_ERR_SYS_SET   (0x1u)

#define EMIF_IRQSTATUS_RAW_SYS_REG_TA_SYS   (0x00000002u)
#define EMIF_IRQSTATUS_RAW_SYS_REG_TA_SYS_SHIFT   (0x00000001u)
#define EMIF_IRQSTATUS_RAW_SYS_REG_TA_SYS_NO   (0x0u)
#define EMIF_IRQSTATUS_RAW_SYS_REG_TA_SYS_SET   (0x1u)


/* IRQSTATUS_RAW_LL */
#define EMIF_IRQSTATUS_RAW_LL_REG_DNV_LL   (0x00000004u)
#define EMIF_IRQSTATUS_RAW_LL_REG_DNV_LL_SHIFT   (0x00000002u)
#define EMIF_IRQSTATUS_RAW_LL_REG_DNV_LL_NO   (0x0u)
#define EMIF_IRQSTATUS_RAW_LL_REG_DNV_LL_SET   (0x1u)

#define EMIF_IRQSTATUS_RAW_LL_REG_ERR_LL   (0x00000001u)
#define EMIF_IRQSTATUS_RAW_LL_REG_ERR_LL_SHIFT   (0x00000000u)
#define EMIF_IRQSTATUS_RAW_LL_REG_ERR_LL_NO   (0x0u)
#define EMIF_IRQSTATUS_RAW_LL_REG_ERR_LL_SET   (0x1u)

#define EMIF_IRQSTATUS_RAW_LL_REG_TA_LL   (0x00000002u)
#define EMIF_IRQSTATUS_RAW_LL_REG_TA_LL_SHIFT   (0x00000001u)
#define EMIF_IRQSTATUS_RAW_LL_REG_TA_LL_NO   (0x0u)
#define EMIF_IRQSTATUS_RAW_LL_REG_TA_LL_SET   (0x1u)


/* IRQSTATUS_SYS */
#define EMIF_IRQSTATUS_SYS_REG_DNV_SYS   (0x00000004u)
#define EMIF_IRQSTATUS_SYS_REG_DNV_SYS_SHIFT   (0x00000002u)
#define EMIF_IRQSTATUS_SYS_REG_DNV_SYS_CLEAR   (0x1u)
#define EMIF_IRQSTATUS_SYS_REG_DNV_SYS_NO   (0x0u)

#define EMIF_IRQSTATUS_SYS_REG_ERR_SYS   (0x00000001u)
#define EMIF_IRQSTATUS_SYS_REG_ERR_SYS_SHIFT   (0x00000000u)
#define EMIF_IRQSTATUS_SYS_REG_ERR_SYS_CLEAR   (0x1u)
#define EMIF_IRQSTATUS_SYS_REG_ERR_SYS_NO   (0x0u)

#define EMIF_IRQSTATUS_SYS_REG_TA_SYS   (0x00000002u)
#define EMIF_IRQSTATUS_SYS_REG_TA_SYS_SHIFT   (0x00000001u)
#define EMIF_IRQSTATUS_SYS_REG_TA_SYS_CLEAR   (0x1u)
#define EMIF_IRQSTATUS_SYS_REG_TA_SYS_NO   (0x0u)


/* IRQSTATUS_LL */
#define EMIF_IRQSTATUS_LL_REG_DNV_LL   (0x00000004u)
#define EMIF_IRQSTATUS_LL_REG_DNV_LL_SHIFT   (0x00000002u)
#define EMIF_IRQSTATUS_LL_REG_DNV_LL_CLEAR   (0x1u)
#define EMIF_IRQSTATUS_LL_REG_DNV_LL_NO   (0x0u)

#define EMIF_IRQSTATUS_LL_REG_ERR_LL   (0x00000001u)
#define EMIF_IRQSTATUS_LL_REG_ERR_LL_SHIFT   (0x00000000u)
#define EMIF_IRQSTATUS_LL_REG_ERR_LL_CLEAR   (0x1u)
#define EMIF_IRQSTATUS_LL_REG_ERR_LL_NO   (0x0u)

#define EMIF_IRQSTATUS_LL_REG_TA_LL   (0x00000002u)
#define EMIF_IRQSTATUS_LL_REG_TA_LL_SHIFT   (0x00000001u)
#define EMIF_IRQSTATUS_LL_REG_TA_LL_CLEAR   (0x1u)
#define EMIF_IRQSTATUS_LL_REG_TA_LL_NO   (0x0u)


/* IRQENABLE_SET_SYS */
#define EMIF_IRQENABLE_SET_SYS_REG_EN_DNV_SYS   (0x00000004u)
#define EMIF_IRQENABLE_SET_SYS_REG_EN_DNV_SYS_SHIFT   (0x00000002u)
#define EMIF_IRQENABLE_SET_SYS_REG_EN_DNV_SYS_ENABLE   (0x1u)
#define EMIF_IRQENABLE_SET_SYS_REG_EN_DNV_SYS_NO   (0x0u)

#define EMIF_IRQENABLE_SET_SYS_REG_EN_ERR_SYS   (0x00000001u)
#define EMIF_IRQENABLE_SET_SYS_REG_EN_ERR_SYS_SHIFT   (0x00000000u)
#define EMIF_IRQENABLE_SET_SYS_REG_EN_ERR_SYS_ENABLE   (0x1u)
#define EMIF_IRQENABLE_SET_SYS_REG_EN_ERR_SYS_NO   (0x0u)

#define EMIF_IRQENABLE_SET_SYS_REG_EN_TA_SYS   (0x00000002u)
#define EMIF_IRQENABLE_SET_SYS_REG_EN_TA_SYS_SHIFT   (0x00000001u)
#define EMIF_IRQENABLE_SET_SYS_REG_EN_TA_SYS_ENABLE   (0x1u)
#define EMIF_IRQENABLE_SET_SYS_REG_EN_TA_SYS_NO   (0x0u)


/* IRQENABLE_SET_LL */
#define EMIF_IRQENABLE_SET_LL_REG_EN_DNV_LL   (0x00000004u)
#define EMIF_IRQENABLE_SET_LL_REG_EN_DNV_LL_SHIFT   (0x00000002u)
#define EMIF_IRQENABLE_SET_LL_REG_EN_DNV_LL_ENABLE   (0x1u)
#define EMIF_IRQENABLE_SET_LL_REG_EN_DNV_LL_NO   (0x0u)

#define EMIF_IRQENABLE_SET_LL_REG_EN_ERR_LL   (0x00000001u)
#define EMIF_IRQENABLE_SET_LL_REG_EN_ERR_LL_SHIFT   (0x00000000u)
#define EMIF_IRQENABLE_SET_LL_REG_EN_ERR_LL_ENABLE   (0x1u)
#define EMIF_IRQENABLE_SET_LL_REG_EN_ERR_LL_NO   (0x0u)

#define EMIF_IRQENABLE_SET_LL_REG_EN_TA_LL   (0x00000002u)
#define EMIF_IRQENABLE_SET_LL_REG_EN_TA_LL_SHIFT   (0x00000001u)
#define EMIF_IRQENABLE_SET_LL_REG_EN_TA_LL_ENABLE   (0x1u)
#define EMIF_IRQENABLE_SET_LL_REG_EN_TA_LL_NO   (0x0u)


/* IRQENABLE_CLR_SYS */
#define EMIF_IRQENABLE_CLR_SYS_REG_EN_DNV_SYS   (0x00000004u)
#define EMIF_IRQENABLE_CLR_SYS_REG_EN_DNV_SYS_SHIFT   (0x00000002u)
#define EMIF_IRQENABLE_CLR_SYS_REG_EN_DNV_SYS_DISABLE   (0x1u)
#define EMIF_IRQENABLE_CLR_SYS_REG_EN_DNV_SYS_NO   (0x0u)

#define EMIF_IRQENABLE_CLR_SYS_REG_EN_ERR_SYS   (0x00000001u)
#define EMIF_IRQENABLE_CLR_SYS_REG_EN_ERR_SYS_SHIFT   (0x00000000u)
#define EMIF_IRQENABLE_CLR_SYS_REG_EN_ERR_SYS_DISABLE   (0x1u)
#define EMIF_IRQENABLE_CLR_SYS_REG_EN_ERR_SYS_NO   (0x0u)

#define EMIF_IRQENABLE_CLR_SYS_REG_EN_TA_SYS   (0x00000002u)
#define EMIF_IRQENABLE_CLR_SYS_REG_EN_TA_SYS_SHIFT   (0x00000001u)
#define EMIF_IRQENABLE_CLR_SYS_REG_EN_TA_SYS_DISABLE   (0x1u)
#define EMIF_IRQENABLE_CLR_SYS_REG_EN_TA_SYS_NO   (0x0u)


/* IRQENABLE_CLR_LL */
#define EMIF_IRQENABLE_CLR_LL_REG_EN_DNV_LL   (0x00000004u)
#define EMIF_IRQENABLE_CLR_LL_REG_EN_DNV_LL_SHIFT   (0x00000002u)
#define EMIF_IRQENABLE_CLR_LL_REG_EN_DNV_LL_DISABLE   (0x1u)
#define EMIF_IRQENABLE_CLR_LL_REG_EN_DNV_LL_NO   (0x0u)

#define EMIF_IRQENABLE_CLR_LL_REG_EN_ERR_LL   (0x00000001u)
#define EMIF_IRQENABLE_CLR_LL_REG_EN_ERR_LL_SHIFT   (0x00000000u)
#define EMIF_IRQENABLE_CLR_LL_REG_EN_ERR_LL_DISABLE   (0x1u)
#define EMIF_IRQENABLE_CLR_LL_REG_EN_ERR_LL_NO   (0x0u)

#define EMIF_IRQENABLE_CLR_LL_REG_EN_TA_LL   (0x00000002u)
#define EMIF_IRQENABLE_CLR_LL_REG_EN_TA_LL_SHIFT   (0x00000001u)
#define EMIF_IRQENABLE_CLR_LL_REG_EN_TA_LL_DISABLE   (0x1u)
#define EMIF_IRQENABLE_CLR_LL_REG_EN_TA_LL_NO   (0x0u)


/* ZQ_CONFIG */
#define EMIF_ZQ_CONFIG_REG_ZQ_CS0EN   (0x40000000u)
#define EMIF_ZQ_CONFIG_REG_ZQ_CS0EN_SHIFT   (0x0000001Eu)

#define EMIF_ZQ_CONFIG_REG_ZQ_CS1EN   (0x80000000u)
#define EMIF_ZQ_CONFIG_REG_ZQ_CS1EN_SHIFT   (0x0000001Fu)

#define EMIF_ZQ_CONFIG_REG_ZQ_DUALCALEN   (0x20000000u)
#define EMIF_ZQ_CONFIG_REG_ZQ_DUALCALEN_SHIFT   (0x0000001Du)

#define EMIF_ZQ_CONFIG_REG_ZQ_REFINTERVAL   (0x0000FFFFu)
#define EMIF_ZQ_CONFIG_REG_ZQ_REFINTERVAL_SHIFT   (0x00000000u)

#define EMIF_ZQ_CONFIG_REG_ZQ_SFEXITEN   (0x10000000u)
#define EMIF_ZQ_CONFIG_REG_ZQ_SFEXITEN_SHIFT   (0x0000001Cu)

#define EMIF_ZQ_CONFIG_REG_ZQ_ZQCL_MULT   (0x00030000u)
#define EMIF_ZQ_CONFIG_REG_ZQ_ZQCL_MULT_SHIFT   (0x00000010u)

#define EMIF_ZQ_CONFIG_REG_ZQ_ZQINIT_MULT   (0x000C0000u)
#define EMIF_ZQ_CONFIG_REG_ZQ_ZQINIT_MULT_SHIFT   (0x00000012u)


/* TEMP_ALERT_CONFIG */
#define EMIF_TEMP_ALERT_CONFIG_REG_TA_CS0EN   (0x40000000u)
#define EMIF_TEMP_ALERT_CONFIG_REG_TA_CS0EN_SHIFT   (0x0000001Eu)

#define EMIF_TEMP_ALERT_CONFIG_REG_TA_CS1EN   (0x80000000u)
#define EMIF_TEMP_ALERT_CONFIG_REG_TA_CS1EN_SHIFT   (0x0000001Fu)

#define EMIF_TEMP_ALERT_CONFIG_REG_TA_DEVCNT   (0x03000000u)
#define EMIF_TEMP_ALERT_CONFIG_REG_TA_DEVCNT_SHIFT   (0x00000018u)
#define EMIF_TEMP_ALERT_CONFIG_REG_TA_DEVCNT_1_DEV   (0x0u)
#define EMIF_TEMP_ALERT_CONFIG_REG_TA_DEVCNT_2_DEV   (0x1u)
#define EMIF_TEMP_ALERT_CONFIG_REG_TA_DEVCNT_4_DEV   (0x2u)

#define EMIF_TEMP_ALERT_CONFIG_REG_TA_DEVWDT   (0x0C000000u)
#define EMIF_TEMP_ALERT_CONFIG_REG_TA_DEVWDT_SHIFT   (0x0000001Au)
#define EMIF_TEMP_ALERT_CONFIG_REG_TA_DEVWDT_16_BIT   (0x1u)
#define EMIF_TEMP_ALERT_CONFIG_REG_TA_DEVWDT_32_BIT   (0x2u)
#define EMIF_TEMP_ALERT_CONFIG_REG_TA_DEVWDT_8_BIT   (0x0u)

#define EMIF_TEMP_ALERT_CONFIG_REG_TA_REFINTERVAL   (0x003FFFFFu)
#define EMIF_TEMP_ALERT_CONFIG_REG_TA_REFINTERVAL_SHIFT   (0x00000000u)

#define EMIF_TEMP_ALERT_CONFIG_REG_TA_SFEXITEN   (0x10000000u)
#define EMIF_TEMP_ALERT_CONFIG_REG_TA_SFEXITEN_SHIFT   (0x0000001Cu)


/* L3_ERR_LOG */
#define EMIF_L3_ERR_LOG_REG_MADDRSPACE   (0x0000C000u)
#define EMIF_L3_ERR_LOG_REG_MADDRSPACE_SHIFT   (0x0000000Eu)
#define EMIF_L3_ERR_LOG_REG_MADDRSPACE_LPDDR2_NVM   (0x1u)
#define EMIF_L3_ERR_LOG_REG_MADDRSPACE_SDRAM   (0x0u)

#define EMIF_L3_ERR_LOG_REG_MBURSTSEQ   (0x00003800u)
#define EMIF_L3_ERR_LOG_REG_MBURSTSEQ_SHIFT   (0x0000000Bu)

#define EMIF_L3_ERR_LOG_REG_MCMD   (0x00000700u)
#define EMIF_L3_ERR_LOG_REG_MCMD_SHIFT   (0x00000008u)

#define EMIF_L3_ERR_LOG_REG_MCONNID   (0x000000FFu)
#define EMIF_L3_ERR_LOG_REG_MCONNID_SHIFT   (0x00000000u)


/* DDR_PHY_CTRL_1 */
#define EMIF_DDR_PHY_CTRL_1_DLL_MASTER_SENSITIVITY   (0xC0000000u)
#define EMIF_DDR_PHY_CTRL_1_DLL_MASTER_SENSITIVITY_SHIFT   (0x0000001Eu)

#define EMIF_DDR_PHY_CTRL_1_REG_DLL_MASTER_SW_CODE_CTRL   (0x003FF000u)
#define EMIF_DDR_PHY_CTRL_1_REG_DLL_MASTER_SW_CODE_CTRL_SHIFT   (0x0000000Cu)

#define EMIF_DDR_PHY_CTRL_1_REG_DLL_SLAVE_DLY_CTRL   (0x000000FF0u)
#define EMIF_DDR_PHY_CTRL_1_REG_DLL_SLAVE_DLY_CTRL_SHIFT   (0x00000004u)

#define EMIF_DDR_PHY_CTRL_1_REG_PHY_FREEZE_DELAY_CODE_POSTAMBLE   (0x3C000000u)
#define EMIF_DDR_PHY_CTRL_1_REG_PHY_FREEZE_DELAY_CODE_POSTAMBLE_SHIFT   (0x0000001Au)

#define EMIF_DDR_PHY_CTRL_1_REG_PHY_FREEZE_DELAY_CODE_PREAMBLE   (0x03C00000u)
#define EMIF_DDR_PHY_CTRL_1_REG_PHY_FREEZE_DELAY_CODE_PREAMBLE_SHIFT   (0x00000016u)

#define EMIF_DDR_PHY_CTRL_1_REG_READ_LATENCY   (0x0000000Fu)
#define EMIF_DDR_PHY_CTRL_1_REG_READ_LATENCY_SHIFT   (0x00000000u)


/* DDR_PHY_CTRL_1_SHDW */
#define EMIF_DDR_PHY_CTRL_1_SHDW_REG_DLL_MASTER_SW_CODE_CTRL_SHDW   (0x003FF000u)
#define EMIF_DDR_PHY_CTRL_1_SHDW_REG_DLL_MASTER_SW_CODE_CTRL_SHDW_SHIFT   (0x0000000Cu)






/* DDR_PHY_CTRL_2 */
#define EMIF_DDR_PHY_CTRL_2_REG_DDR_PHY_CTRL_2   (0xFFFFFFFFu)
#define EMIF_DDR_PHY_CTRL_2_REG_DDR_PHY_CTRL_2_SHIFT   (0x00000000u)



#ifdef __cplusplus
}
#endif

#endif

