/**
 * @file spi1_driver.h
 * @brief SPI1 driver
 *
 * @section License
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Copyright (C) 2010-2022 Oryx Embedded SARL. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.2.0
 **/

#ifndef _SPI1_DRIVER_H
#define _SPI1_DRIVER_H

//SPI1 driver
extern const SpiDriver spi1Driver;

//SPI1 related functions
error_t spi1Init(void);
error_t spi1SetMode(uint_t mode);
error_t spi1SetBitrate(uint_t bitrate);
void spi1AssertCs(void);
void spi1DeassertCs(void);
uint8_t spi1Transfer(uint8_t data);

#endif
