/**
 * @file net_config.h
 * @brief CycloneSTP configuration file
 *
 * @section License
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Copyright (C) 2010-2022 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSTP Open.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.2.0
 **/

#ifndef _STP_CONFIG_H
#define _STP_CONFIG_H

//Trace level for STP bridge
#define STP_TRACE_LEVEL TRACE_LEVEL_INFO
//Trace level for RSTP bridge
#define RSTP_TRACE_LEVEL TRACE_LEVEL_INFO

//STP bridge support
#define STP_SUPPORT ENABLED
//RSTP bridge support
#define RSTP_SUPPORT DISABLED

//BRIDGE MIB module support
#define BRIDGE_MIB_SUPPORT ENABLED
//Support for SET operations
#define BRIDGE_MIB_SET_SUPPORT ENABLED

//RSTP MIB module support
#define RSTP_MIB_SUPPORT DISABLED
//Support for SET operations
#define RSTP_MIB_SET_SUPPORT ENABLED


#endif
