/**
 * @file system_s7g2.c
 * @brief System configuration for Renesas Synergy S7G2 device
 *
 * @section License
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Copyright (C) 2010-2022 Oryx Embedded SARL. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.2.0
 **/

#include "bsp_irq_cfg.h"
#include "s7g2.h"

//Event numbers
#define ELC_EVENT_ICU_IRQ0                  1
#define ELC_EVENT_ICU_IRQ1                  2
#define ELC_EVENT_ICU_IRQ2                  3
#define ELC_EVENT_ICU_IRQ3                  4
#define ELC_EVENT_ICU_IRQ4                  5
#define ELC_EVENT_ICU_IRQ5                  6
#define ELC_EVENT_ICU_IRQ6                  7
#define ELC_EVENT_ICU_IRQ7                  8
#define ELC_EVENT_ICU_IRQ8                  9
#define ELC_EVENT_ICU_IRQ9                  10
#define ELC_EVENT_ICU_IRQ10                 11
#define ELC_EVENT_ICU_IRQ11                 12
#define ELC_EVENT_ICU_IRQ12                 13
#define ELC_EVENT_ICU_IRQ13                 14
#define ELC_EVENT_ICU_IRQ14                 15
#define ELC_EVENT_ICU_IRQ15                 16
#define ELC_EVENT_DMAC0_INT                 32
#define ELC_EVENT_DMAC1_INT                 33
#define ELC_EVENT_DMAC2_INT                 34
#define ELC_EVENT_DMAC3_INT                 35
#define ELC_EVENT_DMAC4_INT                 36
#define ELC_EVENT_DMAC5_INT                 37
#define ELC_EVENT_DMAC6_INT                 38
#define ELC_EVENT_DMAC7_INT                 39
#define ELC_EVENT_DTC_COMPLETE              41
#define ELC_EVENT_DTC_END                   42
#define ELC_EVENT_ICU_SNOOZE_CANCEL         45
#define ELC_EVENT_FCU_FIFERR                48
#define ELC_EVENT_FCU_FRDYI                 49
#define ELC_EVENT_LVD_LVD1                  56
#define ELC_EVENT_LVD_LVD2                  57
#define ELC_EVENT_CGC_MOSC_STOP             59
#define ELC_EVENT_LPM_SNOOZE_REQUEST        60
#define ELC_EVENT_AGT0_INT                  64
#define ELC_EVENT_AGT0_COMPARE_A            65
#define ELC_EVENT_AGT0_COMPARE_B            66
#define ELC_EVENT_AGT1_INT                  67
#define ELC_EVENT_AGT1_COMPARE_A            68
#define ELC_EVENT_AGT1_COMPARE_B            69
#define ELC_EVENT_IWDT_UNDERFLOW            70
#define ELC_EVENT_WDT_UNDERFLOW             71
#define ELC_EVENT_RTC_ALARM                 72
#define ELC_EVENT_RTC_PERIOD                73
#define ELC_EVENT_RTC_CARRY                 74
#define ELC_EVENT_ADC0_SCAN_END             75
#define ELC_EVENT_ADC0_SCAN_END_B           76
#define ELC_EVENT_ADC0_WINDOW_A             77
#define ELC_EVENT_ADC0_WINDOW_B             78
#define ELC_EVENT_ADC0_COMPARE_MATCH        79
#define ELC_EVENT_ADC0_COMPARE_MISMATCH     80
#define ELC_EVENT_ADC1_SCAN_END             81
#define ELC_EVENT_ADC1_SCAN_END_B           82
#define ELC_EVENT_ADC1_WINDOW_A             83
#define ELC_EVENT_ADC1_WINDOW_B             84
#define ELC_EVENT_ADC1_COMPARE_MATCH        85
#define ELC_EVENT_ADC1_COMPARE_MISMATCH     86
#define ELC_EVENT_COMP_HS_0                 87
#define ELC_EVENT_COMP_HS0_INT              87
#define ELC_EVENT_COMP_HS_1                 88
#define ELC_EVENT_COMP_HS1_INT              88
#define ELC_EVENT_COMP_HS_2                 89
#define ELC_EVENT_COMP_HS2_INT              89
#define ELC_EVENT_COMP_HS_3                 90
#define ELC_EVENT_COMP_HS3_INT              90
#define ELC_EVENT_COMP_HS_4                 91
#define ELC_EVENT_COMP_HS4_INT              91
#define ELC_EVENT_COMP_HS_5                 92
#define ELC_EVENT_COMP_HS5_INT              92
#define ELC_EVENT_USBFS_FIFO_0              95
#define ELC_EVENT_USBFS_FIFO_1              96
#define ELC_EVENT_USBFS_INT                 97
#define ELC_EVENT_USBFS_RESUME              98
#define ELC_EVENT_IIC0_RXI                  99
#define ELC_EVENT_IIC0_TXI                  100
#define ELC_EVENT_IIC0_TEI                  101
#define ELC_EVENT_IIC0_ERI                  102
#define ELC_EVENT_IIC0_WUI                  103
#define ELC_EVENT_IIC1_RXI                  104
#define ELC_EVENT_IIC1_TXI                  105
#define ELC_EVENT_IIC1_TEI                  106
#define ELC_EVENT_IIC1_ERI                  107
#define ELC_EVENT_IIC2_RXI                  109
#define ELC_EVENT_IIC2_TXI                  110
#define ELC_EVENT_IIC2_TEI                  111
#define ELC_EVENT_IIC2_ERI                  112
#define ELC_EVENT_SSI0_TXI                  114
#define ELC_EVENT_SSI0_RXI                  115
#define ELC_EVENT_SSI0_INT                  117
#define ELC_EVENT_SSI1_TXI_RXI              120
#define ELC_EVENT_SSI1_INT                  121
#define ELC_EVENT_SRC_INPUT_FIFO_EMPTY      122
#define ELC_EVENT_SRC_OUTPUT_FIFO_FULL      123
#define ELC_EVENT_SRC_OUTPUT_FIFO_OVERFLOW  124
#define ELC_EVENT_SRC_OUTPUT_FIFO_UNDERFLOW 125
#define ELC_EVENT_SRC_CONVERSION_END        126
#define ELC_EVENT_PDC_RECEIVE_DATA_READY    127
#define ELC_EVENT_PDC_FRAME_END             128
#define ELC_EVENT_PDC_INT                   129
#define ELC_EVENT_CTSU_WRITE                130
#define ELC_EVENT_CTSU_READ                 131
#define ELC_EVENT_CTSU_END                  132
#define ELC_EVENT_KEY_INT                   133
#define ELC_EVENT_DOC_INT                   134
#define ELC_EVENT_CAC_FREQUENCY_ERROR       135
#define ELC_EVENT_CAC_MEASUREMENT_END       136
#define ELC_EVENT_CAC_OVERFLOW              137
#define ELC_EVENT_CAN0_ERROR                138
#define ELC_EVENT_CAN0_FIFO_RX              139
#define ELC_EVENT_CAN0_FIFO_TX              140
#define ELC_EVENT_CAN0_MAILBOX_RX           141
#define ELC_EVENT_CAN0_MAILBOX_TX           142
#define ELC_EVENT_CAN1_ERROR                143
#define ELC_EVENT_CAN1_FIFO_RX              144
#define ELC_EVENT_CAN1_FIFO_TX              145
#define ELC_EVENT_CAN1_MAILBOX_RX           146
#define ELC_EVENT_CAN1_MAILBOX_TX           147
#define ELC_EVENT_IOPORT_EVENT_1            148
#define ELC_EVENT_IOPORT_EVENT_2            149
#define ELC_EVENT_IOPORT_EVENT_3            150
#define ELC_EVENT_IOPORT_EVENT_4            151
#define ELC_EVENT_ELC_SOFTWARE_EVENT_0      152
#define ELC_EVENT_ELC_SOFTWARE_EVENT_1      153
#define ELC_EVENT_POEG0_EVENT               154
#define ELC_EVENT_POEG1_EVENT               155
#define ELC_EVENT_POEG2_EVENT               156
#define ELC_EVENT_POEG3_EVENT               157
#define ELC_EVENT_GPT0_CAPTURE_COMPARE_A    176
#define ELC_EVENT_GPT0_CAPTURE_COMPARE_B    177
#define ELC_EVENT_GPT0_COMPARE_C            178
#define ELC_EVENT_GPT0_COMPARE_D            179
#define ELC_EVENT_GPT0_COMPARE_E            180
#define ELC_EVENT_GPT0_COMPARE_F            181
#define ELC_EVENT_GPT0_COUNTER_OVERFLOW     182
#define ELC_EVENT_GPT0_COUNTER_UNDERFLOW    183
#define ELC_EVENT_GPT0_AD_TRIG_A            184
#define ELC_EVENT_GPT0_AD_TRIG_B            185
#define ELC_EVENT_GPT1_CAPTURE_COMPARE_A    186
#define ELC_EVENT_GPT1_CAPTURE_COMPARE_B    187
#define ELC_EVENT_GPT1_COMPARE_C            188
#define ELC_EVENT_GPT1_COMPARE_D            189
#define ELC_EVENT_GPT1_COMPARE_E            190
#define ELC_EVENT_GPT1_COMPARE_F            191
#define ELC_EVENT_GPT1_COUNTER_OVERFLOW     192
#define ELC_EVENT_GPT1_COUNTER_UNDERFLOW    193
#define ELC_EVENT_GPT1_AD_TRIG_A            194
#define ELC_EVENT_GPT1_AD_TRIG_B            195
#define ELC_EVENT_GPT2_CAPTURE_COMPARE_A    196
#define ELC_EVENT_GPT2_CAPTURE_COMPARE_B    197
#define ELC_EVENT_GPT2_COMPARE_C            198
#define ELC_EVENT_GPT2_COMPARE_D            199
#define ELC_EVENT_GPT2_COMPARE_E            200
#define ELC_EVENT_GPT2_COMPARE_F            201
#define ELC_EVENT_GPT2_COUNTER_OVERFLOW     202
#define ELC_EVENT_GPT2_COUNTER_UNDERFLOW    203
#define ELC_EVENT_GPT2_AD_TRIG_A            204
#define ELC_EVENT_GPT2_AD_TRIG_B            205
#define ELC_EVENT_GPT3_CAPTURE_COMPARE_A    206
#define ELC_EVENT_GPT3_CAPTURE_COMPARE_B    207
#define ELC_EVENT_GPT3_COMPARE_C            208
#define ELC_EVENT_GPT3_COMPARE_D            209
#define ELC_EVENT_GPT3_COMPARE_E            210
#define ELC_EVENT_GPT3_COMPARE_F            211
#define ELC_EVENT_GPT3_COUNTER_OVERFLOW     212
#define ELC_EVENT_GPT3_COUNTER_UNDERFLOW    213
#define ELC_EVENT_GPT3_AD_TRIG_A            214
#define ELC_EVENT_GPT3_AD_TRIG_B            215
#define ELC_EVENT_GPT4_CAPTURE_COMPARE_A    216
#define ELC_EVENT_GPT4_CAPTURE_COMPARE_B    217
#define ELC_EVENT_GPT4_COMPARE_C            218
#define ELC_EVENT_GPT4_COMPARE_D            219
#define ELC_EVENT_GPT4_COMPARE_E            220
#define ELC_EVENT_GPT4_COMPARE_F            221
#define ELC_EVENT_GPT4_COUNTER_OVERFLOW     222
#define ELC_EVENT_GPT4_COUNTER_UNDERFLOW    223
#define ELC_EVENT_GPT4_AD_TRIG_A            224
#define ELC_EVENT_GPT4_AD_TRIG_B            225
#define ELC_EVENT_GPT5_CAPTURE_COMPARE_A    226
#define ELC_EVENT_GPT5_CAPTURE_COMPARE_B    227
#define ELC_EVENT_GPT5_COMPARE_C            228
#define ELC_EVENT_GPT5_COMPARE_D            229
#define ELC_EVENT_GPT5_COMPARE_E            230
#define ELC_EVENT_GPT5_COMPARE_F            231
#define ELC_EVENT_GPT5_COUNTER_OVERFLOW     232
#define ELC_EVENT_GPT5_COUNTER_UNDERFLOW    233
#define ELC_EVENT_GPT5_AD_TRIG_A            234
#define ELC_EVENT_GPT5_AD_TRIG_B            235
#define ELC_EVENT_GPT6_CAPTURE_COMPARE_A    236
#define ELC_EVENT_GPT6_CAPTURE_COMPARE_B    237
#define ELC_EVENT_GPT6_COMPARE_C            238
#define ELC_EVENT_GPT6_COMPARE_D            239
#define ELC_EVENT_GPT6_COMPARE_E            240
#define ELC_EVENT_GPT6_COMPARE_F            241
#define ELC_EVENT_GPT6_COUNTER_OVERFLOW     242
#define ELC_EVENT_GPT6_COUNTER_UNDERFLOW    243
#define ELC_EVENT_GPT6_AD_TRIG_A            244
#define ELC_EVENT_GPT6_AD_TRIG_B            245
#define ELC_EVENT_GPT7_CAPTURE_COMPARE_A    246
#define ELC_EVENT_GPT7_CAPTURE_COMPARE_B    247
#define ELC_EVENT_GPT7_COMPARE_C            248
#define ELC_EVENT_GPT7_COMPARE_D            249
#define ELC_EVENT_GPT7_COMPARE_E            250
#define ELC_EVENT_GPT7_COMPARE_F            251
#define ELC_EVENT_GPT7_COUNTER_OVERFLOW     252
#define ELC_EVENT_GPT7_COUNTER_UNDERFLOW    253
#define ELC_EVENT_GPT7_AD_TRIG_A            254
#define ELC_EVENT_GPT7_AD_TRIG_B            255
#define ELC_EVENT_GPT8_CAPTURE_COMPARE_A    256
#define ELC_EVENT_GPT8_CAPTURE_COMPARE_B    257
#define ELC_EVENT_GPT8_COMPARE_C            258
#define ELC_EVENT_GPT8_COMPARE_D            259
#define ELC_EVENT_GPT8_COMPARE_E            260
#define ELC_EVENT_GPT8_COMPARE_F            261
#define ELC_EVENT_GPT8_COUNTER_OVERFLOW     262
#define ELC_EVENT_GPT8_COUNTER_UNDERFLOW    263
#define ELC_EVENT_GPT9_CAPTURE_COMPARE_A    266
#define ELC_EVENT_GPT9_CAPTURE_COMPARE_B    267
#define ELC_EVENT_GPT9_COMPARE_C            268
#define ELC_EVENT_GPT9_COMPARE_D            269
#define ELC_EVENT_GPT9_COMPARE_E            270
#define ELC_EVENT_GPT9_COMPARE_F            271
#define ELC_EVENT_GPT9_COUNTER_OVERFLOW     272
#define ELC_EVENT_GPT9_COUNTER_UNDERFLOW    273
#define ELC_EVENT_GPT10_CAPTURE_COMPARE_A   276
#define ELC_EVENT_GPT10_CAPTURE_COMPARE_B   277
#define ELC_EVENT_GPT10_COMPARE_C           278
#define ELC_EVENT_GPT10_COMPARE_D           279
#define ELC_EVENT_GPT10_COMPARE_E           280
#define ELC_EVENT_GPT10_COMPARE_F           281
#define ELC_EVENT_GPT10_COUNTER_OVERFLOW    282
#define ELC_EVENT_GPT10_COUNTER_UNDERFLOW   283
#define ELC_EVENT_GPT11_CAPTURE_COMPARE_A   286
#define ELC_EVENT_GPT11_CAPTURE_COMPARE_B   287
#define ELC_EVENT_GPT11_COMPARE_C           288
#define ELC_EVENT_GPT11_COMPARE_D           289
#define ELC_EVENT_GPT11_COMPARE_E           290
#define ELC_EVENT_GPT11_COMPARE_F           291
#define ELC_EVENT_GPT11_COUNTER_OVERFLOW    292
#define ELC_EVENT_GPT11_COUNTER_UNDERFLOW   293
#define ELC_EVENT_GPT12_CAPTURE_COMPARE_A   296
#define ELC_EVENT_GPT12_CAPTURE_COMPARE_B   297
#define ELC_EVENT_GPT12_COMPARE_C           298
#define ELC_EVENT_GPT12_COMPARE_D           299
#define ELC_EVENT_GPT12_COMPARE_E           300
#define ELC_EVENT_GPT12_COMPARE_F           301
#define ELC_EVENT_GPT12_COUNTER_OVERFLOW    302
#define ELC_EVENT_GPT12_COUNTER_UNDERFLOW   303
#define ELC_EVENT_GPT13_CAPTURE_COMPARE_A   306
#define ELC_EVENT_GPT13_CAPTURE_COMPARE_B   307
#define ELC_EVENT_GPT13_COMPARE_C           308
#define ELC_EVENT_GPT13_COMPARE_D           309
#define ELC_EVENT_GPT13_COMPARE_E           310
#define ELC_EVENT_GPT13_COMPARE_F           311
#define ELC_EVENT_GPT13_COUNTER_OVERFLOW    312
#define ELC_EVENT_GPT13_COUNTER_UNDERFLOW   313
#define ELC_EVENT_OPS_UVW_EDGE              336
#define ELC_EVENT_EPTPC_IPLS                352
#define ELC_EVENT_EPTPC_MINT                353
#define ELC_EVENT_EPTPC_PINT                354
#define ELC_EVENT_EDMAC0_EINT               355
#define ELC_EVENT_EDMAC1_EINT               356
#define ELC_EVENT_EPTPC_TIMER0_RISE         357
#define ELC_EVENT_EPTPC_TIMER1_RISE         358
#define ELC_EVENT_EPTPC_TIMER2_RISE         359
#define ELC_EVENT_EPTPC_TIMER3_RISE         360
#define ELC_EVENT_EPTPC_TIMER4_RISE         361
#define ELC_EVENT_EPTPC_TIMER5_RISE         362
#define ELC_EVENT_EPTPC_TIMER0_FALL         363
#define ELC_EVENT_EPTPC_TIMER1_FALL         364
#define ELC_EVENT_EPTPC_TIMER2_FALL         365
#define ELC_EVENT_EPTPC_TIMER3_FALL         366
#define ELC_EVENT_EPTPC_TIMER4_FALL         367
#define ELC_EVENT_EPTPC_TIMER5_FALL         368
#define ELC_EVENT_USBHS_FIFO_0              369
#define ELC_EVENT_USBHS_FIFO_1              370
#define ELC_EVENT_USBHS_USB_INT_RESUME      371
#define ELC_EVENT_SCI0_RXI                  372
#define ELC_EVENT_SCI0_TXI                  373
#define ELC_EVENT_SCI0_TEI                  374
#define ELC_EVENT_SCI0_ERI                  375
#define ELC_EVENT_SCI0_AM                   376
#define ELC_EVENT_SCI0_RXI_OR_ERI           377
#define ELC_EVENT_SCI1_RXI                  378
#define ELC_EVENT_SCI1_TXI                  379
#define ELC_EVENT_SCI1_TEI                  380
#define ELC_EVENT_SCI1_ERI                  381
#define ELC_EVENT_SCI1_AM                   382
#define ELC_EVENT_SCI2_RXI                  384
#define ELC_EVENT_SCI2_TXI                  385
#define ELC_EVENT_SCI2_TEI                  386
#define ELC_EVENT_SCI2_ERI                  387
#define ELC_EVENT_SCI2_AM                   388
#define ELC_EVENT_SCI3_RXI                  390
#define ELC_EVENT_SCI3_TXI                  391
#define ELC_EVENT_SCI3_TEI                  392
#define ELC_EVENT_SCI3_ERI                  393
#define ELC_EVENT_SCI3_AM                   394
#define ELC_EVENT_SCI4_RXI                  396
#define ELC_EVENT_SCI4_TXI                  397
#define ELC_EVENT_SCI4_TEI                  398
#define ELC_EVENT_SCI4_ERI                  399
#define ELC_EVENT_SCI4_AM                   400
#define ELC_EVENT_SCI5_RXI                  402
#define ELC_EVENT_SCI5_TXI                  403
#define ELC_EVENT_SCI5_TEI                  404
#define ELC_EVENT_SCI5_ERI                  405
#define ELC_EVENT_SCI5_AM                   406
#define ELC_EVENT_SCI6_RXI                  408
#define ELC_EVENT_SCI6_TXI                  409
#define ELC_EVENT_SCI6_TEI                  410
#define ELC_EVENT_SCI6_ERI                  411
#define ELC_EVENT_SCI6_AM                   412
#define ELC_EVENT_SCI7_RXI                  414
#define ELC_EVENT_SCI7_TXI                  415
#define ELC_EVENT_SCI7_TEI                  416
#define ELC_EVENT_SCI7_ERI                  417
#define ELC_EVENT_SCI7_AM                   418
#define ELC_EVENT_SCI8_RXI                  420
#define ELC_EVENT_SCI8_TXI                  421
#define ELC_EVENT_SCI8_TEI                  422
#define ELC_EVENT_SCI8_ERI                  423
#define ELC_EVENT_SCI8_AM                   424
#define ELC_EVENT_SCI9_RXI                  426
#define ELC_EVENT_SCI9_TXI                  427
#define ELC_EVENT_SCI9_TEI                  428
#define ELC_EVENT_SCI9_ERI                  429
#define ELC_EVENT_SCI9_AM                   430
#define ELC_EVENT_SPI0_RXI                  444
#define ELC_EVENT_SPI0_TXI                  445
#define ELC_EVENT_SPI0_IDLE                 446
#define ELC_EVENT_SPI0_ERI                  447
#define ELC_EVENT_SPI0_TEI                  448
#define ELC_EVENT_SPI1_RXI                  449
#define ELC_EVENT_SPI1_TXI                  450
#define ELC_EVENT_SPI1_IDLE                 451
#define ELC_EVENT_SPI1_ERI                  452
#define ELC_EVENT_SPI1_TEI                  453
#define ELC_EVENT_QSPI_INT                  454
#define ELC_EVENT_SDHIMMC0_ACCS             455
#define ELC_EVENT_SDHIMMC0_SDIO             456
#define ELC_EVENT_SDHIMMC0_CARD             457
#define ELC_EVENT_SDHIMMC0_DMA_REQ          458
#define ELC_EVENT_SDHIMMC1_ACCS             459
#define ELC_EVENT_SDHIMMC1_SDIO             460
#define ELC_EVENT_SDHIMMC1_CARD             461
#define ELC_EVENT_SDHIMMC1_DMA_REQ          462
#define ELC_EVENT_SCE_PROC_BUSY             481
#define ELC_EVENT_SCE_ROMOK                 482
#define ELC_EVENT_SCE_LONG_PLG              483
#define ELC_EVENT_SCE_TEST_BUSY             484
#define ELC_EVENT_SCE_WRRDY_0               485
#define ELC_EVENT_SCE_WRRDY_1               486
#define ELC_EVENT_SCE_WRRDY_4               487
#define ELC_EVENT_SCE_RDRDY_0               488
#define ELC_EVENT_SCE_RDRDY_1               489
#define ELC_EVENT_SCE_INTEGRATE_WRRDY       490
#define ELC_EVENT_SCE_INTEGRATE_RDRDY       491
#define ELC_EVENT_GLCDC_LINE_DETECT         506
#define ELC_EVENT_GLCDC_UNDERFLOW_1         507
#define ELC_EVENT_GLCDC_UNDERFLOW_2         508
#define ELC_EVENT_DRW_INT                   509
#define ELC_EVENT_JPEG_JEDI                 510
#define ELC_EVENT_JPEG_JDTI                 511

//System clock frequency (240MHz)
uint32_t SystemCoreClock = 240000000;


/**
 * @brief Setup the system clock
 **/

void SystemInit(void)
{
   //Enable FPU
#if (__FPU_PRESENT == 1) && (__FPU_USED == 1)
   SCB->CPACR |= ((3UL << 10 * 2) | (3UL << 11 * 2));
#endif

   //Redirect the desired events to the NVIC
#if (BSP_IRQ_CFG_ICU_IRQ0 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ0_IRQn] = ELC_EVENT_ICU_IRQ0;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ1_IRQn] = ELC_EVENT_ICU_IRQ1;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ2 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ2_IRQn] = ELC_EVENT_ICU_IRQ2;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ3 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ3_IRQn] = ELC_EVENT_ICU_IRQ3;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ4 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ4_IRQn] = ELC_EVENT_ICU_IRQ4;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ5 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ5_IRQn] = ELC_EVENT_ICU_IRQ5;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ6 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ6_IRQn] = ELC_EVENT_ICU_IRQ6;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ7 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ7_IRQn] = ELC_EVENT_ICU_IRQ7;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ8 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ8_IRQn] = ELC_EVENT_ICU_IRQ8;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ9 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ9_IRQn] = ELC_EVENT_ICU_IRQ9;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ10 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ10_IRQn] = ELC_EVENT_ICU_IRQ10;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ11 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ11_IRQn] = ELC_EVENT_ICU_IRQ11;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ12 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ12_IRQn] = ELC_EVENT_ICU_IRQ12;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ13 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ13_IRQn] = ELC_EVENT_ICU_IRQ13;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ14 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ14_IRQn] = ELC_EVENT_ICU_IRQ14;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ15 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_IRQ15_IRQn] = ELC_EVENT_ICU_IRQ15;
#endif
#if (BSP_IRQ_CFG_DMAC0_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC0_INT_IRQn] = ELC_EVENT_DMAC0_INT;
#endif
#if (BSP_IRQ_CFG_DMAC1_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC1_INT_IRQn] = ELC_EVENT_DMAC1_INT;
#endif
#if (BSP_IRQ_CFG_DMAC2_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC2_INT_IRQn] = ELC_EVENT_DMAC2_INT;
#endif
#if (BSP_IRQ_CFG_DMAC3_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC3_INT_IRQn] = ELC_EVENT_DMAC3_INT;
#endif
#if (BSP_IRQ_CFG_DMAC4_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC4_INT_IRQn] = ELC_EVENT_DMAC4_INT;
#endif
#if (BSP_IRQ_CFG_DMAC5_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC5_INT_IRQn] = ELC_EVENT_DMAC5_INT;
#endif
#if (BSP_IRQ_CFG_DMAC6_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC6_INT_IRQn] = ELC_EVENT_DMAC6_INT;
#endif
#if (BSP_IRQ_CFG_DMAC7_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DMAC7_INT_IRQn] = ELC_EVENT_DMAC7_INT;
#endif
#if (BSP_IRQ_CFG_DTC_COMPLETE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DTC_COMPLETE_IRQn] = ELC_EVENT_DTC_COMPLETE;
#endif
#if (BSP_IRQ_CFG_DTC_END != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DTC_END_IRQn] = ELC_EVENT_DTC_END;
#endif
#if (BSP_IRQ_CFG_ICU_SNOOZE_CANCEL != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ICU_SNOOZE_CANCEL_IRQn] = ELC_EVENT_ICU_SNOOZE_CANCEL;
#endif
#if (BSP_IRQ_CFG_FCU_FIFERR != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[FCU_FIFERR_IRQn] = ELC_EVENT_FCU_FIFERR;
#endif
#if (BSP_IRQ_CFG_FCU_FRDYI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[FCU_FRDYI_IRQn] = ELC_EVENT_FCU_FRDYI;
#endif
#if (BSP_IRQ_CFG_LVD_LVD1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[LVD_LVD1_IRQn] = ELC_EVENT_LVD_LVD1;
#endif
#if (BSP_IRQ_CFG_LVD_LVD2 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[LVD_LVD2_IRQn] = ELC_EVENT_LVD_LVD2;
#endif
#if (BSP_IRQ_CFG_CGC_MOSC_STOP != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CGC_MOSC_STOP_IRQn] = ELC_EVENT_CGC_MOSC_STOP;
#endif
#if (BSP_IRQ_CFG_LPM_SNOOZE_REQUEST != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[LPM_SNOOZE_REQUEST_IRQn] = ELC_EVENT_LPM_SNOOZE_REQUEST;
#endif
#if (BSP_IRQ_CFG_AGT0_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[AGT0_INT_IRQn] = ELC_EVENT_AGT0_INT;
#endif
#if (BSP_IRQ_CFG_AGT0_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[AGT0_COMPARE_A_IRQn] = ELC_EVENT_AGT0_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_AGT0_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[AGT0_COMPARE_B_IRQn] = ELC_EVENT_AGT0_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_AGT1_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[AGT1_INT_IRQn] = ELC_EVENT_AGT1_INT;
#endif
#if (BSP_IRQ_CFG_AGT1_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[AGT1_COMPARE_A_IRQn] = ELC_EVENT_AGT1_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_AGT1_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[AGT1_COMPARE_B_IRQn] = ELC_EVENT_AGT1_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_IWDT_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IWDT_UNDERFLOW_IRQn] = ELC_EVENT_IWDT_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_WDT_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[WDT_UNDERFLOW_IRQn] = ELC_EVENT_WDT_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_RTC_ALARM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[RTC_ALARM_IRQn] = ELC_EVENT_RTC_ALARM;
#endif
#if (BSP_IRQ_CFG_RTC_PERIOD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[RTC_PERIOD_IRQn] = ELC_EVENT_RTC_PERIOD;
#endif
#if (BSP_IRQ_CFG_RTC_CARRY != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[RTC_CARRY_IRQn] = ELC_EVENT_RTC_CARRY;
#endif
#if (BSP_IRQ_CFG_ADC0_SCAN_END != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC0_SCAN_END_IRQn] = ELC_EVENT_ADC0_SCAN_END;
#endif
#if (BSP_IRQ_CFG_ADC0_SCAN_END_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC0_SCAN_END_B_IRQn] = ELC_EVENT_ADC0_SCAN_END_B;
#endif
#if (BSP_IRQ_CFG_ADC0_WINDOW_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC0_WINDOW_A_IRQn] = ELC_EVENT_ADC0_WINDOW_A;
#endif
#if (BSP_IRQ_CFG_ADC0_WINDOW_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC0_WINDOW_B_IRQn] = ELC_EVENT_ADC0_WINDOW_B;
#endif
#if (BSP_IRQ_CFG_ADC0_COMPARE_MATCH != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC0_COMPARE_MATCH_IRQn] = ELC_EVENT_ADC0_COMPARE_MATCH;
#endif
#if (BSP_IRQ_CFG_ADC0_COMPARE_MISMATCH != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC0_COMPARE_MISMATCH_IRQn] = ELC_EVENT_ADC0_COMPARE_MISMATCH;
#endif
#if (BSP_IRQ_CFG_ADC1_SCAN_END != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC1_SCAN_END_IRQn] = ELC_EVENT_ADC1_SCAN_END;
#endif
#if (BSP_IRQ_CFG_ADC1_SCAN_END_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC1_SCAN_END_B_IRQn] = ELC_EVENT_ADC1_SCAN_END_B;
#endif
#if (BSP_IRQ_CFG_ADC1_WINDOW_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC1_WINDOW_A_IRQn] = ELC_EVENT_ADC1_WINDOW_A;
#endif
#if (BSP_IRQ_CFG_ADC1_WINDOW_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC1_WINDOW_B_IRQn] = ELC_EVENT_ADC1_WINDOW_B;
#endif
#if (BSP_IRQ_CFG_ADC1_COMPARE_MATCH != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC1_COMPARE_MATCH_IRQn] = ELC_EVENT_ADC1_COMPARE_MATCH;
#endif
#if (BSP_IRQ_CFG_ADC1_COMPARE_MISMATCH != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ADC1_COMPARE_MISMATCH_IRQn] = ELC_EVENT_ADC1_COMPARE_MISMATCH;
#endif
#if (BSP_IRQ_CFG_COMP_HS_0 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[COMP_HS_0_IRQn] = ELC_EVENT_COMP_HS_0;
#endif
#if (BSP_IRQ_CFG_COMP_HS0_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[COMP_HS0_INT_IRQn] = ELC_EVENT_COMP_HS0_INT;
#endif
#if (BSP_IRQ_CFG_COMP_HS_1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[COMP_HS_1_IRQn] = ELC_EVENT_COMP_HS_1;
#endif
#if (BSP_IRQ_CFG_COMP_HS1_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[COMP_HS1_INT_IRQn] = ELC_EVENT_COMP_HS1_INT;
#endif
#if (BSP_IRQ_CFG_COMP_HS_2 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[COMP_HS_2_IRQn] = ELC_EVENT_COMP_HS_2;
#endif
#if (BSP_IRQ_CFG_COMP_HS2_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[COMP_HS2_INT_IRQn] = ELC_EVENT_COMP_HS2_INT;
#endif
#if (BSP_IRQ_CFG_COMP_HS_3 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[COMP_HS_3_IRQn] = ELC_EVENT_COMP_HS_3;
#endif
#if (BSP_IRQ_CFG_COMP_HS3_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[COMP_HS3_INT_IRQn] = ELC_EVENT_COMP_HS3_INT;
#endif
#if (BSP_IRQ_CFG_COMP_HS_4 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[COMP_HS_4_IRQn] = ELC_EVENT_COMP_HS_4;
#endif
#if (BSP_IRQ_CFG_COMP_HS4_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[COMP_HS4_INT_IRQn] = ELC_EVENT_COMP_HS4_INT;
#endif
#if (BSP_IRQ_CFG_COMP_HS_5 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[COMP_HS_5_IRQn] = ELC_EVENT_COMP_HS_5;
#endif
#if (BSP_IRQ_CFG_COMP_HS5_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[COMP_HS5_INT_IRQn] = ELC_EVENT_COMP_HS5_INT;
#endif
#if (BSP_IRQ_CFG_USBFS_FIFO_0 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[USBFS_FIFO_0_IRQn] = ELC_EVENT_USBFS_FIFO_0;
#endif
#if (BSP_IRQ_CFG_USBFS_FIFO_1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[USBFS_FIFO_1_IRQn] = ELC_EVENT_USBFS_FIFO_1;
#endif
#if (BSP_IRQ_CFG_USBFS_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[USBFS_INT_IRQn] = ELC_EVENT_USBFS_INT;
#endif
#if (BSP_IRQ_CFG_USBFS_RESUME != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[USBFS_RESUME_IRQn] = ELC_EVENT_USBFS_RESUME;
#endif
#if (BSP_IRQ_CFG_IIC0_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC0_RXI_IRQn] = ELC_EVENT_IIC0_RXI;
#endif
#if (BSP_IRQ_CFG_IIC0_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC0_TXI_IRQn] = ELC_EVENT_IIC0_TXI;
#endif
#if (BSP_IRQ_CFG_IIC0_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC0_TEI_IRQn] = ELC_EVENT_IIC0_TEI;
#endif
#if (BSP_IRQ_CFG_IIC0_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC0_ERI_IRQn] = ELC_EVENT_IIC0_ERI;
#endif
#if (BSP_IRQ_CFG_IIC0_WUI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC0_WUI_IRQn] = ELC_EVENT_IIC0_WUI;
#endif
#if (BSP_IRQ_CFG_IIC1_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC1_RXI_IRQn] = ELC_EVENT_IIC1_RXI;
#endif
#if (BSP_IRQ_CFG_IIC1_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC1_TXI_IRQn] = ELC_EVENT_IIC1_TXI;
#endif
#if (BSP_IRQ_CFG_IIC1_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC1_TEI_IRQn] = ELC_EVENT_IIC1_TEI;
#endif
#if (BSP_IRQ_CFG_IIC1_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC1_ERI_IRQn] = ELC_EVENT_IIC1_ERI;
#endif
#if (BSP_IRQ_CFG_IIC2_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC2_RXI_IRQn] = ELC_EVENT_IIC2_RXI;
#endif
#if (BSP_IRQ_CFG_IIC2_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC2_TXI_IRQn] = ELC_EVENT_IIC2_TXI;
#endif
#if (BSP_IRQ_CFG_IIC2_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC2_TEI_IRQn] = ELC_EVENT_IIC2_TEI;
#endif
#if (BSP_IRQ_CFG_IIC2_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IIC2_ERI_IRQn] = ELC_EVENT_IIC2_ERI;
#endif
#if (BSP_IRQ_CFG_SSI0_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SSI0_TXI_IRQn] = ELC_EVENT_SSI0_TXI;
#endif
#if (BSP_IRQ_CFG_SSI0_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SSI0_RXI_IRQn] = ELC_EVENT_SSI0_RXI;
#endif
#if (BSP_IRQ_CFG_SSI0_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SSI0_INT_IRQn] = ELC_EVENT_SSI0_INT;
#endif
#if (BSP_IRQ_CFG_SSI1_TXI_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SSI1_TXI_RXI_IRQn] = ELC_EVENT_SSI1_TXI_RXI;
#endif
#if (BSP_IRQ_CFG_SSI1_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SSI1_INT_IRQn] = ELC_EVENT_SSI1_INT;
#endif
#if (BSP_IRQ_CFG_SRC_INPUT_FIFO_EMPTY != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SRC_INPUT_FIFO_EMPTY_IRQn] = ELC_EVENT_SRC_INPUT_FIFO_EMPTY;
#endif
#if (BSP_IRQ_CFG_SRC_OUTPUT_FIFO_FULL != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SRC_OUTPUT_FIFO_FULL_IRQn] = ELC_EVENT_SRC_OUTPUT_FIFO_FULL;
#endif
#if (BSP_IRQ_CFG_SRC_OUTPUT_FIFO_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SRC_OUTPUT_FIFO_OVERFLOW_IRQn] = ELC_EVENT_SRC_OUTPUT_FIFO_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_SRC_OUTPUT_FIFO_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SRC_OUTPUT_FIFO_UNDERFLOW_IRQn] = ELC_EVENT_SRC_OUTPUT_FIFO_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_SRC_CONVERSION_END != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SRC_CONVERSION_END_IRQn] = ELC_EVENT_SRC_CONVERSION_END;
#endif
#if (BSP_IRQ_CFG_PDC_RECEIVE_DATA_READY != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PDC_RECEIVE_DATA_READY_IRQn] = ELC_EVENT_PDC_RECEIVE_DATA_READY;
#endif
#if (BSP_IRQ_CFG_PDC_FRAME_END != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PDC_FRAME_END_IRQn] = ELC_EVENT_PDC_FRAME_END;
#endif
#if (BSP_IRQ_CFG_PDC_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[PDC_INT_IRQn] = ELC_EVENT_PDC_INT;
#endif
#if (BSP_IRQ_CFG_CTSU_WRITE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CTSU_WRITE_IRQn] = ELC_EVENT_CTSU_WRITE;
#endif
#if (BSP_IRQ_CFG_CTSU_READ != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CTSU_READ_IRQn] = ELC_EVENT_CTSU_READ;
#endif
#if (BSP_IRQ_CFG_CTSU_END != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CTSU_END_IRQn] = ELC_EVENT_CTSU_END;
#endif
#if (BSP_IRQ_CFG_KEY_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[KEY_INT_IRQn] = ELC_EVENT_KEY_INT;
#endif
#if (BSP_IRQ_CFG_DOC_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DOC_INT_IRQn] = ELC_EVENT_DOC_INT;
#endif
#if (BSP_IRQ_CFG_CAC_FREQUENCY_ERROR != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAC_FREQUENCY_ERROR_IRQn] = ELC_EVENT_CAC_FREQUENCY_ERROR;
#endif
#if (BSP_IRQ_CFG_CAC_MEASUREMENT_END != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAC_MEASUREMENT_END_IRQn] = ELC_EVENT_CAC_MEASUREMENT_END;
#endif
#if (BSP_IRQ_CFG_CAC_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAC_OVERFLOW_IRQn] = ELC_EVENT_CAC_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_CAN0_ERROR != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN0_ERROR_IRQn] = ELC_EVENT_CAN0_ERROR;
#endif
#if (BSP_IRQ_CFG_CAN0_FIFO_RX != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN0_FIFO_RX_IRQn] = ELC_EVENT_CAN0_FIFO_RX;
#endif
#if (BSP_IRQ_CFG_CAN0_FIFO_TX != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN0_FIFO_TX_IRQn] = ELC_EVENT_CAN0_FIFO_TX;
#endif
#if (BSP_IRQ_CFG_CAN0_MAILBOX_RX != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN0_MAILBOX_RX_IRQn] = ELC_EVENT_CAN0_MAILBOX_RX;
#endif
#if (BSP_IRQ_CFG_CAN0_MAILBOX_TX != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN0_MAILBOX_TX_IRQn] = ELC_EVENT_CAN0_MAILBOX_TX;
#endif
#if (BSP_IRQ_CFG_CAN1_ERROR != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN1_ERROR_IRQn] = ELC_EVENT_CAN1_ERROR;
#endif
#if (BSP_IRQ_CFG_CAN1_FIFO_RX != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN1_FIFO_RX_IRQn] = ELC_EVENT_CAN1_FIFO_RX;
#endif
#if (BSP_IRQ_CFG_CAN1_FIFO_TX != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN1_FIFO_TX_IRQn] = ELC_EVENT_CAN1_FIFO_TX;
#endif
#if (BSP_IRQ_CFG_CAN1_MAILBOX_RX != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN1_MAILBOX_RX_IRQn] = ELC_EVENT_CAN1_MAILBOX_RX;
#endif
#if (BSP_IRQ_CFG_CAN1_MAILBOX_TX != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[CAN1_MAILBOX_TX_IRQn] = ELC_EVENT_CAN1_MAILBOX_TX;
#endif
#if (BSP_IRQ_CFG_IOPORT_EVENT_1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IOPORT_EVENT_1_IRQn] = ELC_EVENT_IOPORT_EVENT_1;
#endif
#if (BSP_IRQ_CFG_IOPORT_EVENT_2 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IOPORT_EVENT_2_IRQn] = ELC_EVENT_IOPORT_EVENT_2;
#endif
#if (BSP_IRQ_CFG_IOPORT_EVENT_3 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IOPORT_EVENT_3_IRQn] = ELC_EVENT_IOPORT_EVENT_3;
#endif
#if (BSP_IRQ_CFG_IOPORT_EVENT_4 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[IOPORT_EVENT_4_IRQn] = ELC_EVENT_IOPORT_EVENT_4;
#endif
#if (BSP_IRQ_CFG_ELC_SOFTWARE_EVENT_0 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ELC_SOFTWARE_EVENT_0_IRQn] = ELC_EVENT_ELC_SOFTWARE_EVENT_0;
#endif
#if (BSP_IRQ_CFG_ELC_SOFTWARE_EVENT_1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[ELC_SOFTWARE_EVENT_1_IRQn] = ELC_EVENT_ELC_SOFTWARE_EVENT_1;
#endif
#if (BSP_IRQ_CFG_POEG0_EVENT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[POEG0_EVENT_IRQn] = ELC_EVENT_POEG0_EVENT;
#endif
#if (BSP_IRQ_CFG_POEG1_EVENT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[POEG1_EVENT_IRQn] = ELC_EVENT_POEG1_EVENT;
#endif
#if (BSP_IRQ_CFG_POEG2_EVENT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[POEG2_EVENT_IRQn] = ELC_EVENT_POEG2_EVENT;
#endif
#if (BSP_IRQ_CFG_POEG3_EVENT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[POEG3_EVENT_IRQn] = ELC_EVENT_POEG3_EVENT;
#endif
#if (BSP_IRQ_CFG_GPT0_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT0_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT0_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT0_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT0_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_COMPARE_C_IRQn] = ELC_EVENT_GPT0_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT0_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_COMPARE_D_IRQn] = ELC_EVENT_GPT0_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT0_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_COMPARE_E_IRQn] = ELC_EVENT_GPT0_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT0_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_COMPARE_F_IRQn] = ELC_EVENT_GPT0_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT0_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT0_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT0_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT0_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT0_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_AD_TRIG_A_IRQn] = ELC_EVENT_GPT0_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT0_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT0_AD_TRIG_B_IRQn] = ELC_EVENT_GPT0_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT1_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT1_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT1_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT1_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT1_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_COMPARE_C_IRQn] = ELC_EVENT_GPT1_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT1_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_COMPARE_D_IRQn] = ELC_EVENT_GPT1_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT1_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_COMPARE_E_IRQn] = ELC_EVENT_GPT1_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT1_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_COMPARE_F_IRQn] = ELC_EVENT_GPT1_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT1_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT1_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT1_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT1_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT1_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_AD_TRIG_A_IRQn] = ELC_EVENT_GPT1_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT1_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT1_AD_TRIG_B_IRQn] = ELC_EVENT_GPT1_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT2_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT2_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT2_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT2_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT2_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_COMPARE_C_IRQn] = ELC_EVENT_GPT2_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT2_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_COMPARE_D_IRQn] = ELC_EVENT_GPT2_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT2_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_COMPARE_E_IRQn] = ELC_EVENT_GPT2_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT2_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_COMPARE_F_IRQn] = ELC_EVENT_GPT2_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT2_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT2_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT2_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT2_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT2_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_AD_TRIG_A_IRQn] = ELC_EVENT_GPT2_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT2_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT2_AD_TRIG_B_IRQn] = ELC_EVENT_GPT2_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT3_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT3_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT3_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT3_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT3_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_COMPARE_C_IRQn] = ELC_EVENT_GPT3_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT3_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_COMPARE_D_IRQn] = ELC_EVENT_GPT3_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT3_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_COMPARE_E_IRQn] = ELC_EVENT_GPT3_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT3_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_COMPARE_F_IRQn] = ELC_EVENT_GPT3_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT3_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT3_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT3_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT3_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT3_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_AD_TRIG_A_IRQn] = ELC_EVENT_GPT3_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT3_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT3_AD_TRIG_B_IRQn] = ELC_EVENT_GPT3_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT4_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT4_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT4_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT4_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT4_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_COMPARE_C_IRQn] = ELC_EVENT_GPT4_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT4_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_COMPARE_D_IRQn] = ELC_EVENT_GPT4_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT4_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_COMPARE_E_IRQn] = ELC_EVENT_GPT4_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT4_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_COMPARE_F_IRQn] = ELC_EVENT_GPT4_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT4_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT4_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT4_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT4_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT4_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_AD_TRIG_A_IRQn] = ELC_EVENT_GPT4_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT4_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT4_AD_TRIG_B_IRQn] = ELC_EVENT_GPT4_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT5_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT5_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT5_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT5_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT5_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_COMPARE_C_IRQn] = ELC_EVENT_GPT5_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT5_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_COMPARE_D_IRQn] = ELC_EVENT_GPT5_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT5_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_COMPARE_E_IRQn] = ELC_EVENT_GPT5_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT5_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_COMPARE_F_IRQn] = ELC_EVENT_GPT5_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT5_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT5_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT5_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT5_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT5_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_AD_TRIG_A_IRQn] = ELC_EVENT_GPT5_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT5_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT5_AD_TRIG_B_IRQn] = ELC_EVENT_GPT5_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT6_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT6_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT6_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT6_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT6_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_COMPARE_C_IRQn] = ELC_EVENT_GPT6_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT6_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_COMPARE_D_IRQn] = ELC_EVENT_GPT6_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT6_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_COMPARE_E_IRQn] = ELC_EVENT_GPT6_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT6_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_COMPARE_F_IRQn] = ELC_EVENT_GPT6_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT6_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT6_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT6_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT6_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT6_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_AD_TRIG_A_IRQn] = ELC_EVENT_GPT6_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT6_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT6_AD_TRIG_B_IRQn] = ELC_EVENT_GPT6_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT7_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT7_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT7_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT7_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT7_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_COMPARE_C_IRQn] = ELC_EVENT_GPT7_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT7_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_COMPARE_D_IRQn] = ELC_EVENT_GPT7_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT7_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_COMPARE_E_IRQn] = ELC_EVENT_GPT7_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT7_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_COMPARE_F_IRQn] = ELC_EVENT_GPT7_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT7_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT7_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT7_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT7_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT7_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_AD_TRIG_A_IRQn] = ELC_EVENT_GPT7_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT7_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT7_AD_TRIG_B_IRQn] = ELC_EVENT_GPT7_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT8_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT8_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT8_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT8_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT8_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_COMPARE_C_IRQn] = ELC_EVENT_GPT8_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT8_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_COMPARE_D_IRQn] = ELC_EVENT_GPT8_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT8_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_COMPARE_E_IRQn] = ELC_EVENT_GPT8_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT8_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_COMPARE_F_IRQn] = ELC_EVENT_GPT8_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT8_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT8_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT8_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT8_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT8_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT9_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT9_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT9_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT9_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT9_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_COMPARE_C_IRQn] = ELC_EVENT_GPT9_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT9_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_COMPARE_D_IRQn] = ELC_EVENT_GPT9_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT9_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_COMPARE_E_IRQn] = ELC_EVENT_GPT9_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT9_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_COMPARE_F_IRQn] = ELC_EVENT_GPT9_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT9_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT9_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT9_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT9_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT9_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT10_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT10_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT10_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT10_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT10_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_COMPARE_C_IRQn] = ELC_EVENT_GPT10_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT10_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_COMPARE_D_IRQn] = ELC_EVENT_GPT10_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT10_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_COMPARE_E_IRQn] = ELC_EVENT_GPT10_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT10_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_COMPARE_F_IRQn] = ELC_EVENT_GPT10_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT10_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT10_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT10_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT10_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT10_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT11_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT11_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT11_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT11_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT11_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_COMPARE_C_IRQn] = ELC_EVENT_GPT11_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT11_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_COMPARE_D_IRQn] = ELC_EVENT_GPT11_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT11_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_COMPARE_E_IRQn] = ELC_EVENT_GPT11_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT11_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_COMPARE_F_IRQn] = ELC_EVENT_GPT11_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT11_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT11_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT11_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT11_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT11_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT12_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT12_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT12_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT12_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT12_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_COMPARE_C_IRQn] = ELC_EVENT_GPT12_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT12_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_COMPARE_D_IRQn] = ELC_EVENT_GPT12_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT12_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_COMPARE_E_IRQn] = ELC_EVENT_GPT12_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT12_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_COMPARE_F_IRQn] = ELC_EVENT_GPT12_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT12_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT12_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT12_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT12_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT12_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT13_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT13_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT13_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT13_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT13_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_COMPARE_C_IRQn] = ELC_EVENT_GPT13_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT13_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_COMPARE_D_IRQn] = ELC_EVENT_GPT13_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT13_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_COMPARE_E_IRQn] = ELC_EVENT_GPT13_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT13_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_COMPARE_F_IRQn] = ELC_EVENT_GPT13_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT13_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT13_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT13_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GPT13_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT13_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_OPS_UVW_EDGE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[OPS_UVW_EDGE_IRQn] = ELC_EVENT_OPS_UVW_EDGE;
#endif
#if (BSP_IRQ_CFG_EPTPC_IPLS != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_IPLS_IRQn] = ELC_EVENT_EPTPC_IPLS;
#endif
#if (BSP_IRQ_CFG_EPTPC_MINT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_MINT_IRQn] = ELC_EVENT_EPTPC_MINT;
#endif
#if (BSP_IRQ_CFG_EPTPC_PINT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_PINT_IRQn] = ELC_EVENT_EPTPC_PINT;
#endif
#if (BSP_IRQ_CFG_EDMAC0_EINT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EDMAC0_EINT_IRQn] = ELC_EVENT_EDMAC0_EINT;
#endif
#if (BSP_IRQ_CFG_EDMAC1_EINT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EDMAC1_EINT_IRQn] = ELC_EVENT_EDMAC1_EINT;
#endif
#if (BSP_IRQ_CFG_EPTPC_TIMER0_RISE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_TIMER0_RISE_IRQn] = ELC_EVENT_EPTPC_TIMER0_RISE;
#endif
#if (BSP_IRQ_CFG_EPTPC_TIMER1_RISE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_TIMER1_RISE_IRQn] = ELC_EVENT_EPTPC_TIMER1_RISE;
#endif
#if (BSP_IRQ_CFG_EPTPC_TIMER2_RISE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_TIMER2_RISE_IRQn] = ELC_EVENT_EPTPC_TIMER2_RISE;
#endif
#if (BSP_IRQ_CFG_EPTPC_TIMER3_RISE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_TIMER3_RISE_IRQn] = ELC_EVENT_EPTPC_TIMER3_RISE;
#endif
#if (BSP_IRQ_CFG_EPTPC_TIMER4_RISE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_TIMER4_RISE_IRQn] = ELC_EVENT_EPTPC_TIMER4_RISE;
#endif
#if (BSP_IRQ_CFG_EPTPC_TIMER5_RISE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_TIMER5_RISE_IRQn] = ELC_EVENT_EPTPC_TIMER5_RISE;
#endif
#if (BSP_IRQ_CFG_EPTPC_TIMER0_FALL != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_TIMER0_FALL_IRQn] = ELC_EVENT_EPTPC_TIMER0_FALL;
#endif
#if (BSP_IRQ_CFG_EPTPC_TIMER1_FALL != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_TIMER1_FALL_IRQn] = ELC_EVENT_EPTPC_TIMER1_FALL;
#endif
#if (BSP_IRQ_CFG_EPTPC_TIMER2_FALL != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_TIMER2_FALL_IRQn] = ELC_EVENT_EPTPC_TIMER2_FALL;
#endif
#if (BSP_IRQ_CFG_EPTPC_TIMER3_FALL != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_TIMER3_FALL_IRQn] = ELC_EVENT_EPTPC_TIMER3_FALL;
#endif
#if (BSP_IRQ_CFG_EPTPC_TIMER4_FALL != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_TIMER4_FALL_IRQn] = ELC_EVENT_EPTPC_TIMER4_FALL;
#endif
#if (BSP_IRQ_CFG_EPTPC_TIMER5_FALL != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[EPTPC_TIMER5_FALL_IRQn] = ELC_EVENT_EPTPC_TIMER5_FALL;
#endif
#if (BSP_IRQ_CFG_USBHS_FIFO_0 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[USBHS_FIFO_0_IRQn] = ELC_EVENT_USBHS_FIFO_0;
#endif
#if (BSP_IRQ_CFG_USBHS_FIFO_1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[USBHS_FIFO_1_IRQn] = ELC_EVENT_USBHS_FIFO_1;
#endif
#if (BSP_IRQ_CFG_USBHS_USB_INT_RESUME != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[USBHS_USB_INT_RESUME_IRQn] = ELC_EVENT_USBHS_USB_INT_RESUME;
#endif
#if (BSP_IRQ_CFG_SCI0_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI0_RXI_IRQn] = ELC_EVENT_SCI0_RXI;
#endif
#if (BSP_IRQ_CFG_SCI0_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI0_TXI_IRQn] = ELC_EVENT_SCI0_TXI;
#endif
#if (BSP_IRQ_CFG_SCI0_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI0_TEI_IRQn] = ELC_EVENT_SCI0_TEI;
#endif
#if (BSP_IRQ_CFG_SCI0_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI0_ERI_IRQn] = ELC_EVENT_SCI0_ERI;
#endif
#if (BSP_IRQ_CFG_SCI0_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI0_AM_IRQn] = ELC_EVENT_SCI0_AM;
#endif
#if (BSP_IRQ_CFG_SCI0_RXI_OR_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI0_RXI_OR_ERI_IRQn] = ELC_EVENT_SCI0_RXI_OR_ERI;
#endif
#if (BSP_IRQ_CFG_SCI1_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI1_RXI_IRQn] = ELC_EVENT_SCI1_RXI;
#endif
#if (BSP_IRQ_CFG_SCI1_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI1_TXI_IRQn] = ELC_EVENT_SCI1_TXI;
#endif
#if (BSP_IRQ_CFG_SCI1_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI1_TEI_IRQn] = ELC_EVENT_SCI1_TEI;
#endif
#if (BSP_IRQ_CFG_SCI1_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI1_ERI_IRQn] = ELC_EVENT_SCI1_ERI;
#endif
#if (BSP_IRQ_CFG_SCI1_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI1_AM_IRQn] = ELC_EVENT_SCI1_AM;
#endif
#if (BSP_IRQ_CFG_SCI2_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI2_RXI_IRQn] = ELC_EVENT_SCI2_RXI;
#endif
#if (BSP_IRQ_CFG_SCI2_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI2_TXI_IRQn] = ELC_EVENT_SCI2_TXI;
#endif
#if (BSP_IRQ_CFG_SCI2_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI2_TEI_IRQn] = ELC_EVENT_SCI2_TEI;
#endif
#if (BSP_IRQ_CFG_SCI2_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI2_ERI_IRQn] = ELC_EVENT_SCI2_ERI;
#endif
#if (BSP_IRQ_CFG_SCI2_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI2_AM_IRQn] = ELC_EVENT_SCI2_AM;
#endif
#if (BSP_IRQ_CFG_SCI3_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI3_RXI_IRQn] = ELC_EVENT_SCI3_RXI;
#endif
#if (BSP_IRQ_CFG_SCI3_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI3_TXI_IRQn] = ELC_EVENT_SCI3_TXI;
#endif
#if (BSP_IRQ_CFG_SCI3_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI3_TEI_IRQn] = ELC_EVENT_SCI3_TEI;
#endif
#if (BSP_IRQ_CFG_SCI3_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI3_ERI_IRQn] = ELC_EVENT_SCI3_ERI;
#endif
#if (BSP_IRQ_CFG_SCI3_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI3_AM_IRQn] = ELC_EVENT_SCI3_AM;
#endif
#if (BSP_IRQ_CFG_SCI4_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI4_RXI_IRQn] = ELC_EVENT_SCI4_RXI;
#endif
#if (BSP_IRQ_CFG_SCI4_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI4_TXI_IRQn] = ELC_EVENT_SCI4_TXI;
#endif
#if (BSP_IRQ_CFG_SCI4_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI4_TEI_IRQn] = ELC_EVENT_SCI4_TEI;
#endif
#if (BSP_IRQ_CFG_SCI4_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI4_ERI_IRQn] = ELC_EVENT_SCI4_ERI;
#endif
#if (BSP_IRQ_CFG_SCI4_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI4_AM_IRQn] = ELC_EVENT_SCI4_AM;
#endif
#if (BSP_IRQ_CFG_SCI5_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI5_RXI_IRQn] = ELC_EVENT_SCI5_RXI;
#endif
#if (BSP_IRQ_CFG_SCI5_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI5_TXI_IRQn] = ELC_EVENT_SCI5_TXI;
#endif
#if (BSP_IRQ_CFG_SCI5_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI5_TEI_IRQn] = ELC_EVENT_SCI5_TEI;
#endif
#if (BSP_IRQ_CFG_SCI5_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI5_ERI_IRQn] = ELC_EVENT_SCI5_ERI;
#endif
#if (BSP_IRQ_CFG_SCI5_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI5_AM_IRQn] = ELC_EVENT_SCI5_AM;
#endif
#if (BSP_IRQ_CFG_SCI6_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI6_RXI_IRQn] = ELC_EVENT_SCI6_RXI;
#endif
#if (BSP_IRQ_CFG_SCI6_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI6_TXI_IRQn] = ELC_EVENT_SCI6_TXI;
#endif
#if (BSP_IRQ_CFG_SCI6_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI6_TEI_IRQn] = ELC_EVENT_SCI6_TEI;
#endif
#if (BSP_IRQ_CFG_SCI6_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI6_ERI_IRQn] = ELC_EVENT_SCI6_ERI;
#endif
#if (BSP_IRQ_CFG_SCI6_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI6_AM_IRQn] = ELC_EVENT_SCI6_AM;
#endif
#if (BSP_IRQ_CFG_SCI7_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI7_RXI_IRQn] = ELC_EVENT_SCI7_RXI;
#endif
#if (BSP_IRQ_CFG_SCI7_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI7_TXI_IRQn] = ELC_EVENT_SCI7_TXI;
#endif
#if (BSP_IRQ_CFG_SCI7_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI7_TEI_IRQn] = ELC_EVENT_SCI7_TEI;
#endif
#if (BSP_IRQ_CFG_SCI7_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI7_ERI_IRQn] = ELC_EVENT_SCI7_ERI;
#endif
#if (BSP_IRQ_CFG_SCI7_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI7_AM_IRQn] = ELC_EVENT_SCI7_AM;
#endif
#if (BSP_IRQ_CFG_SCI8_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI8_RXI_IRQn] = ELC_EVENT_SCI8_RXI;
#endif
#if (BSP_IRQ_CFG_SCI8_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI8_TXI_IRQn] = ELC_EVENT_SCI8_TXI;
#endif
#if (BSP_IRQ_CFG_SCI8_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI8_TEI_IRQn] = ELC_EVENT_SCI8_TEI;
#endif
#if (BSP_IRQ_CFG_SCI8_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI8_ERI_IRQn] = ELC_EVENT_SCI8_ERI;
#endif
#if (BSP_IRQ_CFG_SCI8_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI8_AM_IRQn] = ELC_EVENT_SCI8_AM;
#endif
#if (BSP_IRQ_CFG_SCI9_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI9_RXI_IRQn] = ELC_EVENT_SCI9_RXI;
#endif
#if (BSP_IRQ_CFG_SCI9_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI9_TXI_IRQn] = ELC_EVENT_SCI9_TXI;
#endif
#if (BSP_IRQ_CFG_SCI9_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI9_TEI_IRQn] = ELC_EVENT_SCI9_TEI;
#endif
#if (BSP_IRQ_CFG_SCI9_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI9_ERI_IRQn] = ELC_EVENT_SCI9_ERI;
#endif
#if (BSP_IRQ_CFG_SCI9_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCI9_AM_IRQn] = ELC_EVENT_SCI9_AM;
#endif
#if (BSP_IRQ_CFG_SPI0_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI0_RXI_IRQn] = ELC_EVENT_SPI0_RXI;
#endif
#if (BSP_IRQ_CFG_SPI0_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI0_TXI_IRQn] = ELC_EVENT_SPI0_TXI;
#endif
#if (BSP_IRQ_CFG_SPI0_IDLE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI0_IDLE_IRQn] = ELC_EVENT_SPI0_IDLE;
#endif
#if (BSP_IRQ_CFG_SPI0_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI0_ERI_IRQn] = ELC_EVENT_SPI0_ERI;
#endif
#if (BSP_IRQ_CFG_SPI0_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI0_TEI_IRQn] = ELC_EVENT_SPI0_TEI;
#endif
#if (BSP_IRQ_CFG_SPI1_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI1_RXI_IRQn] = ELC_EVENT_SPI1_RXI;
#endif
#if (BSP_IRQ_CFG_SPI1_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI1_TXI_IRQn] = ELC_EVENT_SPI1_TXI;
#endif
#if (BSP_IRQ_CFG_SPI1_IDLE != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI1_IDLE_IRQn] = ELC_EVENT_SPI1_IDLE;
#endif
#if (BSP_IRQ_CFG_SPI1_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI1_ERI_IRQn] = ELC_EVENT_SPI1_ERI;
#endif
#if (BSP_IRQ_CFG_SPI1_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SPI1_TEI_IRQn] = ELC_EVENT_SPI1_TEI;
#endif
#if (BSP_IRQ_CFG_QSPI_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[QSPI_INT_IRQn] = ELC_EVENT_QSPI_INT;
#endif
#if (BSP_IRQ_CFG_SDHIMMC0_ACCS != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHIMMC0_ACCS_IRQn] = ELC_EVENT_SDHIMMC0_ACCS;
#endif
#if (BSP_IRQ_CFG_SDHIMMC0_SDIO != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHIMMC0_SDIO_IRQn] = ELC_EVENT_SDHIMMC0_SDIO;
#endif
#if (BSP_IRQ_CFG_SDHIMMC0_CARD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHIMMC0_CARD_IRQn] = ELC_EVENT_SDHIMMC0_CARD;
#endif
#if (BSP_IRQ_CFG_SDHIMMC0_DMA_REQ != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHIMMC0_DMA_REQ_IRQn] = ELC_EVENT_SDHIMMC0_DMA_REQ;
#endif
#if (BSP_IRQ_CFG_SDHIMMC1_ACCS != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHIMMC1_ACCS_IRQn] = ELC_EVENT_SDHIMMC1_ACCS;
#endif
#if (BSP_IRQ_CFG_SDHIMMC1_SDIO != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHIMMC1_SDIO_IRQn] = ELC_EVENT_SDHIMMC1_SDIO;
#endif
#if (BSP_IRQ_CFG_SDHIMMC1_CARD != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHIMMC1_CARD_IRQn] = ELC_EVENT_SDHIMMC1_CARD;
#endif
#if (BSP_IRQ_CFG_SDHIMMC1_DMA_REQ != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SDHIMMC1_DMA_REQ_IRQn] = ELC_EVENT_SDHIMMC1_DMA_REQ;
#endif
#if (BSP_IRQ_CFG_SCE_PROC_BUSY != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCE_PROC_BUSY_IRQn] = ELC_EVENT_SCE_PROC_BUSY;
#endif
#if (BSP_IRQ_CFG_SCE_ROMOK != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCE_ROMOK_IRQn] = ELC_EVENT_SCE_ROMOK;
#endif
#if (BSP_IRQ_CFG_SCE_LONG_PLG != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCE_LONG_PLG_IRQn] = ELC_EVENT_SCE_LONG_PLG;
#endif
#if (BSP_IRQ_CFG_SCE_TEST_BUSY != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCE_TEST_BUSY_IRQn] = ELC_EVENT_SCE_TEST_BUSY;
#endif
#if (BSP_IRQ_CFG_SCE_WRRDY_0 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCE_WRRDY_0_IRQn] = ELC_EVENT_SCE_WRRDY_0;
#endif
#if (BSP_IRQ_CFG_SCE_WRRDY_1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCE_WRRDY_1_IRQn] = ELC_EVENT_SCE_WRRDY_1;
#endif
#if (BSP_IRQ_CFG_SCE_WRRDY_4 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCE_WRRDY_4_IRQn] = ELC_EVENT_SCE_WRRDY_4;
#endif
#if (BSP_IRQ_CFG_SCE_RDRDY_0 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCE_RDRDY_0_IRQn] = ELC_EVENT_SCE_RDRDY_0;
#endif
#if (BSP_IRQ_CFG_SCE_RDRDY_1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCE_RDRDY_1_IRQn] = ELC_EVENT_SCE_RDRDY_1;
#endif
#if (BSP_IRQ_CFG_SCE_INTEGRATE_WRRDY != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCE_INTEGRATE_WRRDY_IRQn] = ELC_EVENT_SCE_INTEGRATE_WRRDY;
#endif
#if (BSP_IRQ_CFG_SCE_INTEGRATE_RDRDY != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[SCE_INTEGRATE_RDRDY_IRQn] = ELC_EVENT_SCE_INTEGRATE_RDRDY;
#endif
#if (BSP_IRQ_CFG_GLCDC_LINE_DETECT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GLCDC_LINE_DETECT_IRQn] = ELC_EVENT_GLCDC_LINE_DETECT;
#endif
#if (BSP_IRQ_CFG_GLCDC_UNDERFLOW_1 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GLCDC_UNDERFLOW_1_IRQn] = ELC_EVENT_GLCDC_UNDERFLOW_1;
#endif
#if (BSP_IRQ_CFG_GLCDC_UNDERFLOW_2 != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[GLCDC_UNDERFLOW_2_IRQn] = ELC_EVENT_GLCDC_UNDERFLOW_2;
#endif
#if (BSP_IRQ_CFG_DRW_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[DRW_INT_IRQn] = ELC_EVENT_DRW_INT;
#endif
#if (BSP_IRQ_CFG_JPEG_JEDI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[JPEG_JEDI_IRQn] = ELC_EVENT_JPEG_JEDI;
#endif
#if (BSP_IRQ_CFG_JPEG_JDTI != BSP_IRQ_DISABLED)
   R_ICU->IELSRn[JPEG_JDTI_IRQn] = ELC_EVENT_JPEG_JDTI;
#endif

   //Disable write protection
   R_SRAM->RAMPRCR = 0xF1;

   //Set RAM wait states
   R_SRAM->RAMWTSC_b.SRAM0WTEN = 1;
   R_SRAM->RAMWTSC_b.SRAM1WTEN = 1;
   R_SRAM->RAMWTSC_b.SRAMHSWTEN = 1;

   //Enable write protection
   R_SRAM->RAMPRCR = 0xF0;

   //Set ROM wait states
   R_ROMC->ROMWT_b.ROMWT = 2;

   //Invalidate the ROM cache
   R_ROMC->ROMCIV_b.ROMCIV = 1;

   //Wait until the ROM cache is invalidated
   while(R_ROMC->ROMCIV_b.ROMCIV != 0)
   {
   }

   //Enable ROM cache
   R_ROMC->ROMCE_b.ROMCEN = 1;

   //Disable write protection
   R_SYSTEM->PRCR = 0xA50F;

   //Select main clock
   R_SYSTEM->MOMCR_b.MOSEL = 0;
   //Set main clock oscillator drive capability (20 to 24MHz)
   R_SYSTEM->MOMCR_b.MODRV0 = 0;
   //Start main clock operation
   R_SYSTEM->MOSCCR_b.MOSTP = 0;

   //Wait for the main clock to stabilize
   while(!R_SYSTEM->OSCSF_b.MOSCSF);

   //Main clock is used as PLL source
   R_SYSTEM->PLLCCR_b.PLLSRCSEL = 0;
   //Configure PLL input division ratio (/1)
   R_SYSTEM->PLLCCR_b.PLIDIV = 0;
   //Configure PLL multiplication ratio (x10)
   R_SYSTEM->PLLCCR_b.PLLMUL = 19;
   //Start PLL
   R_SYSTEM->PLLCR_b.PLLSTP = 0;

   //Wait for the PLL to stabilize
   while(!R_SYSTEM->OSCSF_b.PLLSF);

   //Set FCK clock divisor (1/4)
   R_SYSTEM->SCKDIVCR_b.FCK = 2;
   //Set ICK clock divisor (1/1)
   R_SYSTEM->SCKDIVCR_b.ICK = 0;
   //Set BCK clock divisor (1/2)
   R_SYSTEM->SCKDIVCR_b.BCK = 1;
   //Set PCKA clock divisor (1/2)
   R_SYSTEM->SCKDIVCR_b.PCKA = 1;
   //Set PCKB clock divisor (1/4)
   R_SYSTEM->SCKDIVCR_b.PCKB = 2;
   //Set PCKC clock divisor (1/4)
   R_SYSTEM->SCKDIVCR_b.PCKC = 2;
   //Set PCKD clock divisor (1/2)
   R_SYSTEM->SCKDIVCR_b.PCKD = 1;
   //Set ULCK clock divisor (1/5)
   R_SYSTEM->SCKDIVCR2_b.UCK = 4;

   //Switch from MOCO clock to PLL
   R_SYSTEM->SCKSCR_b.CKSEL = 5;

   //Enable write protection
   R_SYSTEM->PRCR = 0xA500;
}


/**
 * @brief Update the variable SystemCoreClock
 **/

void SystemCoreClockUpdate(void)
{
}
