/**
 * @file sdram.h
 * @brief SDRAM configuration
 *
 * @section License
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Copyright (C) 2010-2022 Oryx Embedded SARL. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.2.0
 **/

#ifndef _SDRAM_H
#define _SDRAM_H

//SDRAM base address
#define SDRAM_BASE 0x70000000
//SDRAM size in bytes
#define SDRAM_SIZE (2 * 1024 * 1024)

//SDRAM signals (PIOA pins assigned to peripheral A)
#define SDRAM_PIOA_PERIPH_A_MASK (PIO_PA16A_EBI_D15 | PIO_PA15A_EBI_D14)

//SDRAM signals (PIOA pins assigned to peripheral C)
#define SDRAM_PIOA_PERIPH_C_MASK (PIO_PA20C_EBI_BA0)

//SDRAM signals (PIOC pins assigned to peripheral A)
#define SDRAM_PIOC_PERIPH_A_MASK (PIO_PC29A_EBI_A11 | PIO_PC28A_EBI_A10 | \
   PIO_PC27A_EBI_A9 | PIO_PC26A_EBI_A8 | PIO_PC25A_EBI_A7 | \
   PIO_PC24A_EBI_A6 | PIO_PC23A_EBI_A5 | PIO_PC22A_EBI_A4 | \
   PIO_PC21A_EBI_A3 | PIO_PC20A_EBI_A2 | PIO_PC18A_EBI_NBS0 | \
   PIO_PC15A_EBI_SDCS | PIO_PC7A_EBI_D7 | PIO_PC6A_EBI_D6 | \
   PIO_PC5A_EBI_D5 | PIO_PC4A_EBI_D4 | PIO_PC3A_EBI_D3 | \
   PIO_PC2A_EBI_D2 | PIO_PC1A_EBI_D1 | PIO_PC0A_EBI_D0)

//SDRAM signals (PIOD pins assigned to peripheral C)
#define SDRAM_PIOD_PERIPH_C_MASK (PIO_PD29C_EBI_SDWE | \
   PIO_PD23C_EBI_SDCK | PIO_PD17C_EBI_CAS | PIO_PD16C_EBI_RAS | \
   PIO_PD14C_EBI_SDCKE | PIO_PD13C_EBI_SDA10| PIO_PD15C_EBI_NBS1)

//SDRAM signals (PIOE pins assigned to peripheral A)
#define SDRAM_PIOE_PERIPH_A_MASK (PIO_PE5A_EBI_D13 | PIO_PE4A_EBI_D12 | \
   PIO_PE3A_EBI_D11 | PIO_PE2A_EBI_D10 | PIO_PE1A_EBI_D9 | PIO_PE0A_EBI_D8)

//SDRAM related functions
void sdramInit(void);

#endif
