/*******************************************************************************
* Copyright (C) 2013-2016, Cypress Semiconductor Corporation or a              *
* subsidiary of Cypress Semiconductor Corporation.  All rights reserved.       *
*                                                                              *
* This software, including source code, documentation and related              *
* materials ("Software"), is owned by Cypress Semiconductor Corporation or     *
* one of its subsidiaries ("Cypress") and is protected by and subject to       *
* worldwide patent protection (United States and foreign), United States       *
* copyright laws and international treaty provisions. Therefore, you may use   *
* this Software only as provided in the license agreement accompanying the     *
* software package from which you obtained this Software ("EULA").             *
*                                                                              *
* If no EULA applies, Cypress hereby grants you a personal, non-exclusive,     *
* non-transferable license to copy, modify, and compile the                    *
* Software source code solely for use in connection with Cypress's             *
* integrated circuit products.  Any reproduction, modification, translation,   *
* compilation, or representation of this Software except as specified          *
* above is prohibited without the express written permission of Cypress.       *
*                                                                              *
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO                         *
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,                         *
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED                                 *
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A                              *
* PARTICULAR PURPOSE. Cypress reserves the right to make                       *
* changes to the Software without notice. Cypress does not assume any          *
* liability arising out of the application or use of the Software or any       *
* product or circuit described in the Software. Cypress does not               *
* authorize its products for use in any products where a malfunction or        *
* failure of the Cypress product may reasonably be expected to result in       *
* significant property damage, injury or death ("High Risk Product"). By       *
* including Cypress's product in a High Risk Product, the manufacturer         *
* of such system or application assumes all risk of such use and in doing      *
* so agrees to indemnify Cypress against all liability.                        *
*******************************************************************************/
/**
 ******************************************************************************
 ** \file   s6e2gmxj.h
 **
 ** MCU Headerfile
 **
 ** History:
 
 **
 ******************************************************************************/

#ifndef _S6E2GMXJ_H_
#define _S6E2GMXJ_H_
#define __S6E2GMXJ_H__
#define __S6E2GM_H__

#if defined __cplusplus
extern "C" {
#endif

#define FM_GENERAL_MCUHEADER_VERSION              0201


#ifndef FM_DEVICE_PACKAGE_S6E_J
#define FM_DEVICE_PACKAGE_S6E_J
#endif 

/******************************************************************************
 ** Configuration of the Cortex-M4 Processor and Core Peripherals
 ** 
 ******************************************************************************/
#define FM4_DEVICE_TYPE                           5
#define FM_DEVICE_TYPE                            4005u
#define FM_CORE_TYPE_FM4                          1
#define __CM4_REV                                 0x0001
#define __MPU_PRESENT                             1
#define __NVIC_PRIO_BITS                          4
#define __Vendor_SysTickConfig                    0
#define __FPU_PRESENT                             1
#define __FPU_DP                                  0
#define __ICACHE_PRESENT                          0
#define __DCACHE_PRESENT                          0
#define __DTCM_PRESENT                            0

/******************************************************************************
 ** Peripheral Types
 ** 
 ******************************************************************************/
#define FM4_ADC_TYPE_A                            1
#define FM4_BT_TYPE_A                             1
#define FM4_BTIOSEL03_TYPE_A                      1
#define FM4_BTIOSEL47_TYPE_A                      1
#define FM4_BTIOSEL8B_TYPE_A                      1
#define FM4_BTIOSELCF_TYPE_A                      1
#define FM4_CAN_TYPE_A                            1
#define FM4_CANPRES_TYPE_A                        1
#define FM4_CLK_GATING_TYPE_C                     1
#define FM4_CRC_TYPE_A                            1
#define FM4_CRG_TYPE_B                            1
#define FM4_CRTRIM_TYPE_A                         1
#define FM4_DMAC_TYPE_A                           1
#define FM4_DS_TYPE_A                             1
#define FM4_DSTC_TYPE_A                           1
#define FM4_DT_TYPE_A                             1
#define FM4_ECC_CAPTURE_TYPE_A                    1
#define FM4_ETHERNET_CONTROL_TYPE_A               1
#define FM4_ETHERNET_MAC_TYPE_A                   1
#define FM4_EXBUS_TYPE_B                          1
#define FM4_EXTI_TYPE_B                           1
#define FM4_FLASH_IF_TYPE_C                       1
#define FM4_GPIO_TYPE_D                           1
#define FM4_HWWDT_TYPE_A                          1
#define FM4_INTREQ_TYPE_B                         1
#define FM4_LSCRP_TYPE_A                          1
#define FM4_LVD_TYPE_A                            1
#define FM4_MFS_TYPE_B                            1
#define FM4_MFSI2S_TYPE_A                         1
#define FM4_MFT_TYPE_B                            1
#define FM4_MFT_PPG_TYPE_A                        1
#define FM4_QPRC_TYPE_B                           1
#define FM4_QPRC_NF_TYPE_A                        1
#define FM4_RTC_TYPE_C                            1
#define FM4_SBSSR_TYPE_A                          1
#define FM4_SDIF_TYPE_A                           1
#define FM4_SMCIF_TYPE_A                          1
#define FM4_SWWDT_TYPE_A                          1
#define FM4_UNIQUE_ID_TYPE_A                      1
#define FM4_USB_TYPE_A                            1
#define FM4_USBETHERCLK_TYPE_A                    1
#define FM4_WC_TYPE_A                             1

/******************************************************************************
 ** Available Peripherals
 ** 
 ******************************************************************************/
#define FM4_ADC_AVAILABLE                         1
#define FM_ADC_AVAILABLE                          1
#define FM4_BT_AVAILABLE                          1
#define FM_BT_AVAILABLE                           1
#define FM4_BT_PPG_AVAILABLE                      1
#define FM_BT_PPG_AVAILABLE                       1
#define FM4_BT_PWC_AVAILABLE                      1
#define FM_BT_PWC_AVAILABLE                       1
#define FM4_BT_PWM_AVAILABLE                      1
#define FM_BT_PWM_AVAILABLE                       1
#define FM4_BT_RT_AVAILABLE                       1
#define FM_BT_RT_AVAILABLE                        1
#define FM4_BTIOSEL03_AVAILABLE                   1
#define FM_BTIOSEL03_AVAILABLE                    1
#define FM4_BTIOSEL47_AVAILABLE                   1
#define FM_BTIOSEL47_AVAILABLE                    1
#define FM4_BTIOSEL8B_AVAILABLE                   1
#define FM_BTIOSEL8B_AVAILABLE                    1
#define FM4_BTIOSELCF_AVAILABLE                   1
#define FM_BTIOSELCF_AVAILABLE                    1
#define FM4_CAN_AVAILABLE                         1
#define FM_CAN_AVAILABLE                          1
#define FM4_CANPRES_AVAILABLE                     1
#define FM_CANPRES_AVAILABLE                      1
#define FM4_CLK_GATING_AVAILABLE                  1
#define FM_CLK_GATING_AVAILABLE                   1
#define FM4_CRC_AVAILABLE                         1
#define FM_CRC_AVAILABLE                          1
#define FM4_CRG_AVAILABLE                         1
#define FM_CRG_AVAILABLE                          1
#define FM4_CRTRIM_AVAILABLE                      1
#define FM_CRTRIM_AVAILABLE                       1
#define FM4_DMAC_AVAILABLE                        1
#define FM_DMAC_AVAILABLE                         1
#define FM4_DS_AVAILABLE                          1
#define FM_DS_AVAILABLE                           1
#define FM4_DSTC_AVAILABLE                        1
#define FM_DSTC_AVAILABLE                         1
#define FM4_DT_AVAILABLE                          1
#define FM_DT_AVAILABLE                           1
#define FM4_ECC_CAPTURE_AVAILABLE                 1
#define FM_ECC_CAPTURE_AVAILABLE                  1
#define FM4_ETHERNET_CONTROL_AVAILABLE            1
#define FM_ETHERNET_CONTROL_AVAILABLE             1
#define FM4_ETHERNET_MAC_AVAILABLE                1
#define FM_ETHERNET_MAC_AVAILABLE                 1
#define FM4_EXBUS_AVAILABLE                       1
#define FM_EXBUS_AVAILABLE                        1
#define FM4_EXTI_AVAILABLE                        1
#define FM_EXTI_AVAILABLE                         1
#define FM4_FLASH_IF_AVAILABLE                    1
#define FM_FLASH_IF_AVAILABLE                     1
#define FM4_GPIO_AVAILABLE                        1
#define FM_GPIO_AVAILABLE                         1
#define FM4_HWWDT_AVAILABLE                       1
#define FM_HWWDT_AVAILABLE                        1
#define FM4_INTREQ_AVAILABLE                      1
#define FM_INTREQ_AVAILABLE                       1
#define FM4_LSCRP_AVAILABLE                       1
#define FM_LSCRP_AVAILABLE                        1
#define FM4_LVD_AVAILABLE                         1
#define FM_LVD_AVAILABLE                          1
#define FM4_MFS_AVAILABLE                         1
#define FM_MFS_AVAILABLE                          1
#define FM4_MFS_CSIO_AVAILABLE                    1
#define FM_MFS_CSIO_AVAILABLE                     1
#define FM4_MFS_I2C_AVAILABLE                     1
#define FM_MFS_I2C_AVAILABLE                      1
#define FM4_MFS_I2S_AVAILABLE                     1
#define FM_MFS_I2S_AVAILABLE                      1
#define FM4_MFS_LIN_AVAILABLE                     1
#define FM_MFS_LIN_AVAILABLE                      1
#define FM4_MFS_UART_AVAILABLE                    1
#define FM_MFS_UART_AVAILABLE                     1
#define FM4_MFSI2S_AVAILABLE                      1
#define FM_MFSI2S_AVAILABLE                       1
#define FM4_MFT_AVAILABLE                         1
#define FM_MFT_AVAILABLE                          1
#define FM4_MFT_ADCMP_AVAILABLE                   1
#define FM_MFT_ADCMP_AVAILABLE                    1
#define FM4_MFT_FRT_AVAILABLE                     1
#define FM_MFT_FRT_AVAILABLE                      1
#define FM4_MFT_ICU_AVAILABLE                     1
#define FM_MFT_ICU_AVAILABLE                      1
#define FM4_MFT_OCU_AVAILABLE                     1
#define FM_MFT_OCU_AVAILABLE                      1
#define FM4_MFT_PPG_AVAILABLE                     1
#define FM_MFT_PPG_AVAILABLE                      1
#define FM4_MFT_WFG_AVAILABLE                     1
#define FM_MFT_WFG_AVAILABLE                      1
#define FM4_QPRC_AVAILABLE                        1
#define FM_QPRC_AVAILABLE                         1
#define FM4_QPRC_NF_AVAILABLE                     1
#define FM_QPRC_NF_AVAILABLE                      1
#define FM4_RTC_AVAILABLE                         1
#define FM_RTC_AVAILABLE                          1
#define FM4_SBSSR_AVAILABLE                       1
#define FM_SBSSR_AVAILABLE                        1
#define FM4_SDIF_AVAILABLE                        1
#define FM_SDIF_AVAILABLE                         1
#define FM4_SMCIF_AVAILABLE                       1
#define FM_SMCIF_AVAILABLE                        1
#define FM4_SWWDT_AVAILABLE                       1
#define FM_SWWDT_AVAILABLE                        1
#define FM4_UNIQUE_ID_AVAILABLE                   1
#define FM_UNIQUE_ID_AVAILABLE                    1
#define FM4_USB_AVAILABLE                         1
#define FM_USB_AVAILABLE                          1
#define FM4_USBETHERCLK_AVAILABLE                 1
#define FM_USBETHERCLK_AVAILABLE                  1
#define FM4_WC_AVAILABLE                          1
#define FM_WC_AVAILABLE                           1

/******************************************************************************
 ** \brief Interrupt number definition for all type MCUs
 ** 
 ******************************************************************************/
#define FM_INTERRUPT_TYPE                         0x400Bu

#define IRQ_NMI_AVAILABLE                         1
#define IRQ_HARDFAULT_AVAILABLE                   1
#define IRQ_MEMMANAGE_AVAILABLE                   1
#define IRQ_BUSFAULT_AVAILABLE                    1
#define IRQ_USAGEFAULT_AVAILABLE                  1
#define IRQ_SVC_AVAILABLE                         1
#define IRQ_DEBUGMONITOR_AVAILABLE                1
#define IRQ_PENDSV_AVAILABLE                      1
#define IRQ_SYSTICK_AVAILABLE                     1

#define IRQ_CSV_AVAILABLE                         1
#define IRQ_SWDT_AVAILABLE                        1
#define IRQ_LVD_AVAILABLE                         1
#define IRQ_IRQ003SEL_AVAILABLE                   1
#define IRQ_IRQ004SEL_AVAILABLE                   1
#define IRQ_IRQ005SEL_AVAILABLE                   1
#define IRQ_IRQ006SEL_AVAILABLE                   1
#define IRQ_IRQ007SEL_AVAILABLE                   1
#define IRQ_IRQ008SEL_AVAILABLE                   1
#define IRQ_IRQ009SEL_AVAILABLE                   1
#define IRQ_IRQ010SEL_AVAILABLE                   1
#define IRQ_EXINT0_AVAILABLE                      1
#define IRQ_EXINT1_AVAILABLE                      1
#define IRQ_EXINT2_AVAILABLE                      1
#define IRQ_EXINT3_AVAILABLE                      1
#define IRQ_EXINT4_AVAILABLE                      1
#define IRQ_EXINT5_AVAILABLE                      1
#define IRQ_EXINT6_AVAILABLE                      1
#define IRQ_EXINT7_AVAILABLE                      1
#define IRQ_QPRC0_AVAILABLE                       1
#define IRQ_QPRC1_AVAILABLE                       1
#define IRQ_MFT0_WFG_DTIF_AVAILABLE               1
#define IRQ_MFT1_WFG_DTIF_AVAILABLE               1
#define IRQ_MFT0_FRT_PEAK_AVAILABLE               1
#define IRQ_MFT0_FRT_ZERO_AVAILABLE               1
#define IRQ_MFT0_ICU_AVAILABLE                    1
#define IRQ_MFT0_OCU_AVAILABLE                    1
#define IRQ_MFT1_FRT_PEAK_AVAILABLE               1
#define IRQ_MFT1_FRT_ZERO_AVAILABLE               1
#define IRQ_MFT1_ICU_AVAILABLE                    1
#define IRQ_MFT1_OCU_AVAILABLE                    1
#define IRQ_PPG00_02_04_AVAILABLE                 1
#define IRQ_PPG08_10_12_AVAILABLE                 1
#define IRQ_PPG16_18_20_AVAILABLE                 1
#define IRQ_BT0_AVAILABLE                         1
#define IRQ_BT1_AVAILABLE                         1
#define IRQ_BT2_AVAILABLE                         1
#define IRQ_BT3_AVAILABLE                         1
#define IRQ_BT4_AVAILABLE                         1
#define IRQ_BT5_AVAILABLE                         1
#define IRQ_BT6_AVAILABLE                         1
#define IRQ_BT7_AVAILABLE                         1
#define IRQ_DT_AVAILABLE                          1
#define IRQ_WC_AVAILABLE                          1
#define IRQ_EXTBUS_ERR_AVAILABLE                  1
#define IRQ_RTC_AVAILABLE                         1
#define IRQ_EXINT8_AVAILABLE                      1
#define IRQ_EXINT9_AVAILABLE                      1
#define IRQ_EXINT10_AVAILABLE                     1
#define IRQ_EXINT11_AVAILABLE                     1
#define IRQ_EXINT12_AVAILABLE                     1
#define IRQ_EXINT13_AVAILABLE                     1
#define IRQ_EXINT14_AVAILABLE                     1
#define IRQ_EXINT15_AVAILABLE                     1
#define IRQ_TIM_AVAILABLE                         1
#define IRQ_MFS0_RX_AVAILABLE                     1
#define IRQ_MFS0_TX_AVAILABLE                     1
#define IRQ_MFS1_RX_AVAILABLE                     1
#define IRQ_MFS1_TX_AVAILABLE                     1
#define IRQ_MFS2_RX_AVAILABLE                     1
#define IRQ_MFS2_TX_AVAILABLE                     1
#define IRQ_MFS3_RX_AVAILABLE                     1
#define IRQ_MFS3_TX_AVAILABLE                     1
#define IRQ_MFS4_RX_AVAILABLE                     1
#define IRQ_MFS4_TX_AVAILABLE                     1
#define IRQ_MFS5_RX_AVAILABLE                     1
#define IRQ_MFS5_TX_AVAILABLE                     1
#define IRQ_MFS6_RX_AVAILABLE                     1
#define IRQ_MFS6_TX_AVAILABLE                     1
#define IRQ_MFS7_RX_AVAILABLE                     1
#define IRQ_MFS7_TX_AVAILABLE                     1
#define IRQ_ADC0_AVAILABLE                        1
#define IRQ_ADC1_AVAILABLE                        1
#define IRQ_USB0_F_AVAILABLE                      1
#define IRQ_USB0_H_F_AVAILABLE                    1
#define IRQ_CAN0_AVAILABLE                        1
#define IRQ_ETHER0_AVAILABLE                      1
#define IRQ_DMAC0_AVAILABLE                       1
#define IRQ_DMAC1_AVAILABLE                       1
#define IRQ_DMAC2_AVAILABLE                       1
#define IRQ_DMAC3_AVAILABLE                       1
#define IRQ_DMAC4_AVAILABLE                       1
#define IRQ_DMAC5_AVAILABLE                       1
#define IRQ_DMAC6_AVAILABLE                       1
#define IRQ_DMAC7_AVAILABLE                       1
#define IRQ_DSTC_AVAILABLE                        1
#define IRQ_EXINT16_19_AVAILABLE                  1
#define IRQ_EXINT20_23_AVAILABLE                  1
#define IRQ_EXINT24_27_AVAILABLE                  1
#define IRQ_EXINT28_31_AVAILABLE                  1
#define IRQ_QPRC2_AVAILABLE                       1
#define IRQ_QPRC3_AVAILABLE                       1
#define IRQ_BT8_AVAILABLE                         1
#define IRQ_BT9_AVAILABLE                         1
#define IRQ_BT10_AVAILABLE                        1
#define IRQ_BT11_AVAILABLE                        1
#define IRQ_BT12_15_AVAILABLE                     1
#define IRQ_MFS8_RX_AVAILABLE                     1
#define IRQ_MFS8_TX_AVAILABLE                     1
#define IRQ_MFS9_RX_AVAILABLE                     1
#define IRQ_MFS9_TX_AVAILABLE                     1
#define IRQ_ADC2_AVAILABLE                        1
#define IRQ_DSTC_HW_AVAILABLE                     1
#define IRQ_USB1_F_AVAILABLE                      1
#define IRQ_USB1_H_F_AVAILABLE                    1
#define IRQ_ICC0_1_AVAILABLE                      1
#define IRQ_SD_AVAILABLE                          1
#define IRQ_FLASHIF_AVAILABLE                     1


typedef enum IRQn
{
    NMI_IRQn                                      =  -14, /* Non Maskable Interrupt NMI */
    HardFault_IRQn                                =  -13, /* HardFault HardFault */
    MemManage_IRQn                                =  -12, /* Memory Management MemManage */
    BusFault_IRQn                                 =  -11, /* Bus Fault BusFault */
    UsageFault_IRQn                               =  -10, /* Usage Fault UsageFault */
    SVC_IRQn                                      =   -5, /* SV Call SVC */
    DebugMonitor_IRQn                             =   -4, /* Debug Monitor DebugMonitor */
    PendSV_IRQn                                   =   -2, /* Pend SV PendSV */
    SysTick_IRQn                                  =   -1, /* System Tick SysTick */

    CSV_IRQn                                      =    0, /* CSV_IRQ */
    SWDT_IRQn                                     =    1, /* SWDT_IRQ */
    LVD_IRQn                                      =    2, /* LVD_IRQ */
    IRQ003SEL_IRQn                                =    3, /* IRQ003SEL_IRQ */
    IRQ004SEL_IRQn                                =    4, /* IRQ004SEL_IRQ */
    IRQ005SEL_IRQn                                =    5, /* IRQ005SEL_IRQ */
    IRQ006SEL_IRQn                                =    6, /* IRQ006SEL_IRQ */
    IRQ007SEL_IRQn                                =    7, /* IRQ007SEL_IRQ */
    IRQ008SEL_IRQn                                =    8, /* IRQ008SEL_IRQ */
    IRQ009SEL_IRQn                                =    9, /* IRQ009SEL_IRQ */
    IRQ010SEL_IRQn                                =   10, /* IRQ010SEL_IRQ */
    EXINT0_IRQn                                   =   11, /* EXINT0_IRQ */
    EXINT1_IRQn                                   =   12, /* EXINT1_IRQ */
    EXINT2_IRQn                                   =   13, /* EXINT2_IRQ */
    EXINT3_IRQn                                   =   14, /* EXINT3_IRQ */
    EXINT4_IRQn                                   =   15, /* EXINT4_IRQ */
    EXINT5_IRQn                                   =   16, /* EXINT5_IRQ */
    EXINT6_IRQn                                   =   17, /* EXINT6_IRQ */
    EXINT7_IRQn                                   =   18, /* EXINT7_IRQ */
    QPRC0_IRQn                                    =   19, /* QPRC0_IRQ */
    QPRC1_IRQn                                    =   20, /* QPRC1_IRQ */
    MFT0_WFG_DTIF_IRQn                            =   21, /* MFT0_WFG_DTIF_IRQ */
    MFT1_WFG_DTIF_IRQn                            =   22, /* MFT1_WFG_DTIF_IRQ */
    MFT0_FRT_PEAK_IRQn                            =   24, /* MFT0_FRT_PEAK_IRQ */
    MFT0_FRT_ZERO_IRQn                            =   25, /* MFT0_FRT_ZERO_IRQ */
    MFT0_ICU_IRQn                                 =   26, /* MFT0_ICU_IRQ */
    MFT0_OCU_IRQn                                 =   27, /* MFT0_OCU_IRQ */
    MFT1_FRT_PEAK_IRQn                            =   28, /* MFT1_FRT_PEAK_IRQ */
    MFT1_FRT_ZERO_IRQn                            =   29, /* MFT1_FRT_ZERO_IRQ */
    MFT1_ICU_IRQn                                 =   30, /* MFT1_ICU_IRQ */
    MFT1_OCU_IRQn                                 =   31, /* MFT1_OCU_IRQ */
    PPG00_02_04_IRQn                              =   36, /* PPG00_02_04_IRQ */
    PPG08_10_12_IRQn                              =   37, /* PPG08_10_12_IRQ */
    PPG16_18_20_IRQn                              =   38, /* PPG16_18_20_IRQ */
    BT0_IRQn                                      =   39, /* BT0_IRQ */
    BT1_IRQn                                      =   40, /* BT1_IRQ */
    BT2_IRQn                                      =   41, /* BT2_IRQ */
    BT3_IRQn                                      =   42, /* BT3_IRQ */
    BT4_IRQn                                      =   43, /* BT4_IRQ */
    BT5_IRQn                                      =   44, /* BT5_IRQ */
    BT6_IRQn                                      =   45, /* BT6_IRQ */
    BT7_IRQn                                      =   46, /* BT7_IRQ */
    DT_IRQn                                       =   47, /* DT_IRQ */
    WC_IRQn                                       =   48, /* WC_IRQ */
    EXTBUS_ERR_IRQn                               =   49, /* EXTBUS_ERR_IRQ */
    RTC_IRQn                                      =   50, /* RTC_IRQ */
    EXINT8_IRQn                                   =   51, /* EXINT8_IRQ */
    EXINT9_IRQn                                   =   52, /* EXINT9_IRQ */
    EXINT10_IRQn                                  =   53, /* EXINT10_IRQ */
    EXINT11_IRQn                                  =   54, /* EXINT11_IRQ */
    EXINT12_IRQn                                  =   55, /* EXINT12_IRQ */
    EXINT13_IRQn                                  =   56, /* EXINT13_IRQ */
    EXINT14_IRQn                                  =   57, /* EXINT14_IRQ */
    EXINT15_IRQn                                  =   58, /* EXINT15_IRQ */
    TIM_IRQn                                      =   59, /* TIM_IRQ */
    MFS0_RX_IRQn                                  =   60, /* MFS0_RX_IRQ */
    MFS0_TX_IRQn                                  =   61, /* MFS0_TX_IRQ */
    MFS1_RX_IRQn                                  =   62, /* MFS1_RX_IRQ */
    MFS1_TX_IRQn                                  =   63, /* MFS1_TX_IRQ */
    MFS2_RX_IRQn                                  =   64, /* MFS2_RX_IRQ */
    MFS2_TX_IRQn                                  =   65, /* MFS2_TX_IRQ */
    MFS3_RX_IRQn                                  =   66, /* MFS3_RX_IRQ */
    MFS3_TX_IRQn                                  =   67, /* MFS3_TX_IRQ */
    MFS4_RX_IRQn                                  =   68, /* MFS4_RX_IRQ */
    MFS4_TX_IRQn                                  =   69, /* MFS4_TX_IRQ */
    MFS5_RX_IRQn                                  =   70, /* MFS5_RX_IRQ */
    MFS5_TX_IRQn                                  =   71, /* MFS5_TX_IRQ */
    MFS6_RX_IRQn                                  =   72, /* MFS6_RX_IRQ */
    MFS6_TX_IRQn                                  =   73, /* MFS6_TX_IRQ */
    MFS7_RX_IRQn                                  =   74, /* MFS7_RX_IRQ */
    MFS7_TX_IRQn                                  =   75, /* MFS7_TX_IRQ */
    ADC0_IRQn                                     =   76, /* ADC0_IRQ */
    ADC1_IRQn                                     =   77, /* ADC1_IRQ */
    USB0_F_IRQn                                   =   78, /* USB0_F_IRQ */
    USB0_H_F_IRQn                                 =   79, /* USB0_H_F_IRQ */
    CAN0_IRQn                                     =   80, /* CAN0_IRQ */
    ETHER0_IRQn                                   =   82, /* ETHER0_IRQ */
    DMAC0_IRQn                                    =   83, /* DMAC0_IRQ */
    DMAC1_IRQn                                    =   84, /* DMAC1_IRQ */
    DMAC2_IRQn                                    =   85, /* DMAC2_IRQ */
    DMAC3_IRQn                                    =   86, /* DMAC3_IRQ */
    DMAC4_IRQn                                    =   87, /* DMAC4_IRQ */
    DMAC5_IRQn                                    =   88, /* DMAC5_IRQ */
    DMAC6_IRQn                                    =   89, /* DMAC6_IRQ */
    DMAC7_IRQn                                    =   90, /* DMAC7_IRQ */
    DSTC_IRQn                                     =   91, /* DSTC_IRQ */
    EXINT16_19_IRQn                               =   92, /* EXINT16_19_IRQ */
    EXINT20_23_IRQn                               =   93, /* EXINT20_23_IRQ */
    EXINT24_27_IRQn                               =   94, /* EXINT24_27_IRQ */
    EXINT28_31_IRQn                               =   95, /* EXINT28_31_IRQ */
    QPRC2_IRQn                                    =   96, /* QPRC2_IRQ */
    QPRC3_IRQn                                    =   97, /* QPRC3_IRQ */
    BT8_IRQn                                      =   98, /* BT8_IRQ */
    BT9_IRQn                                      =   99, /* BT9_IRQ */
    BT10_IRQn                                     =  100, /* BT10_IRQ */
    BT11_IRQn                                     =  101, /* BT11_IRQ */
    BT12_15_IRQn                                  =  102, /* BT12_15_IRQ */
    MFS8_RX_IRQn                                  =  103, /* MFS8_RX_IRQ */
    MFS8_TX_IRQn                                  =  104, /* MFS8_TX_IRQ */
    MFS9_RX_IRQn                                  =  105, /* MFS9_RX_IRQ */
    MFS9_TX_IRQn                                  =  106, /* MFS9_TX_IRQ */
    ADC2_IRQn                                     =  111, /* ADC2_IRQ */
    DSTC_HW_IRQn                                  =  112, /* DSTC_HW_IRQ */
    USB1_F_IRQn                                   =  113, /* USB1_F_IRQ */
    USB1_H_F_IRQn                                 =  114, /* USB1_H_F_IRQ */
    ICC0_1_IRQn                                   =  117, /* ICC0_1_IRQ */
    SD_IRQn                                       =  118, /* SD_IRQ */
    FLASHIF_IRQn                                  =  119, /* FLASHIF_IRQ */
} IRQn_Type;

#include "core_cm4.h"
#include "system_s6e2gm.h"
#include <stdint.h>

/******************************************************************************
 ** Device Specific Peripheral Registers structures
 ** 
 ******************************************************************************/
#if defined ( __CC_ARM   )
#pragma anon_unions
#endif

/******************************************************************************
 ** ADC_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_adc_adsr_field
{
        __IO   uint8_t  SCS                      :1;
        __IO   uint8_t  PCS                      :1;
        __IO   uint8_t  PCNS                     :1;
        __IO   uint8_t  RESERVED0                :3;
        __IO   uint8_t  FDAS                     :1;
        __IO   uint8_t  ADSTP                    :1;
} stc_adc_adsr_field_t;

typedef struct stc_adc_adcr_field
{
        __IO   uint8_t  OVRIE                    :1;
        __IO   uint8_t  CMPIE                    :1;
        __IO   uint8_t  PCIE                     :1;
        __IO   uint8_t  SCIE                     :1;
        __IO   uint8_t  RESERVED0                :1;
        __IO   uint8_t  CMPIF                    :1;
        __IO   uint8_t  PCIF                     :1;
        __IO   uint8_t  SCIF                     :1;
} stc_adc_adcr_field_t;

typedef struct stc_adc_sfns_field
{
    union {
        struct {
            __IO   uint8_t  SFS                  :4;
            __IO   uint8_t  RESERVED0            :4;
        };
        struct {
            __IO   uint8_t  SFS0                 :1;
            __IO   uint8_t  SFS1                 :1;
            __IO   uint8_t  SFS2                 :1;
            __IO   uint8_t  SFS3                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_adc_sfns_field_t;

typedef struct stc_adc_sccr_field
{
        __IO   uint8_t  SSTR                     :1;
        __IO   uint8_t  SHEN                     :1;
        __IO   uint8_t  RPT                      :1;
        __IO   uint8_t  RESERVED0                :1;
        __IO   uint8_t  SFCLR                    :1;
        __IO   uint8_t  SOVR                     :1;
        __IO   uint8_t  SFUL                     :1;
        __IO   uint8_t  SEMP                     :1;
} stc_adc_sccr_field_t;

typedef struct stc_adc_scfd_fdas1_field
{
    union {
        struct {
            __IO  uint32_t  SC                   :5;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  RS                   :2;
            __IO  uint32_t  RESERVED2            :2;
            __IO  uint32_t  INVL                 :1;
            __IO  uint32_t  RESERVED3            :3;
            __IO  uint32_t  SD                   :12;
            __IO  uint32_t  RESERVED5            :4;
        };
        struct {
            __IO  uint32_t  SC0                  :1;
            __IO  uint32_t  SC1                  :1;
            __IO  uint32_t  SC2                  :1;
            __IO  uint32_t  SC3                  :1;
            __IO  uint32_t  SC4                  :1;
            __IO  uint32_t  RESERVED1            :3;
            __IO  uint32_t  RS0                  :1;
            __IO  uint32_t  RS1                  :1;
            __IO  uint32_t  RESERVED4            :6;
            __IO  uint32_t  SD0                  :1;
            __IO  uint32_t  SD1                  :1;
            __IO  uint32_t  SD2                  :1;
            __IO  uint32_t  SD3                  :1;
            __IO  uint32_t  SD4                  :1;
            __IO  uint32_t  SD5                  :1;
            __IO  uint32_t  SD6                  :1;
            __IO  uint32_t  SD7                  :1;
            __IO  uint32_t  SD8                  :1;
            __IO  uint32_t  SD9                  :1;
            __IO  uint32_t  SD10                 :1;
            __IO  uint32_t  SD11                 :1;
            __IO  uint32_t  RESERVED6            :4;
        };
    };
} stc_adc_scfd_fdas1_field_t;

typedef struct stc_adc_scfd_field
{
    union {
        struct {
            __IO  uint32_t  SC                   :5;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  RS                   :2;
            __IO  uint32_t  RESERVED2            :2;
            __IO  uint32_t  INVL                 :1;
            __IO  uint32_t  RESERVED3            :7;
            __IO  uint32_t  SD                   :12;
        };
        struct {
            __IO  uint32_t  SC0                  :1;
            __IO  uint32_t  SC1                  :1;
            __IO  uint32_t  SC2                  :1;
            __IO  uint32_t  SC3                  :1;
            __IO  uint32_t  SC4                  :1;
            __IO  uint32_t  RESERVED1            :3;
            __IO  uint32_t  RS0                  :1;
            __IO  uint32_t  RS1                  :1;
            __IO  uint32_t  RESERVED4            :10;
            __IO  uint32_t  SD0                  :1;
            __IO  uint32_t  SD1                  :1;
            __IO  uint32_t  SD2                  :1;
            __IO  uint32_t  SD3                  :1;
            __IO  uint32_t  SD4                  :1;
            __IO  uint32_t  SD5                  :1;
            __IO  uint32_t  SD6                  :1;
            __IO  uint32_t  SD7                  :1;
            __IO  uint32_t  SD8                  :1;
            __IO  uint32_t  SD9                  :1;
            __IO  uint32_t  SD10                 :1;
            __IO  uint32_t  SD11                 :1;
        };
    };
} stc_adc_scfd_field_t;

typedef struct stc_adc_scis23_field
{
        __IO  uint16_t  AN16                     :1;
        __IO  uint16_t  AN17                     :1;
        __IO  uint16_t  AN18                     :1;
        __IO  uint16_t  AN19                     :1;
        __IO  uint16_t  AN20                     :1;
        __IO  uint16_t  AN21                     :1;
        __IO  uint16_t  AN22                     :1;
        __IO  uint16_t  AN23                     :1;
        __IO  uint16_t  AN24                     :1;
        __IO  uint16_t  AN25                     :1;
        __IO  uint16_t  AN26                     :1;
        __IO  uint16_t  AN27                     :1;
        __IO  uint16_t  AN28                     :1;
        __IO  uint16_t  AN29                     :1;
        __IO  uint16_t  AN30                     :1;
        __IO  uint16_t  AN31                     :1;
} stc_adc_scis23_field_t;

typedef struct stc_adc_scis01_field
{
        __IO  uint16_t  AN0                      :1;
        __IO  uint16_t  AN1                      :1;
        __IO  uint16_t  AN2                      :1;
        __IO  uint16_t  AN3                      :1;
        __IO  uint16_t  AN4                      :1;
        __IO  uint16_t  AN5                      :1;
        __IO  uint16_t  AN6                      :1;
        __IO  uint16_t  AN7                      :1;
        __IO  uint16_t  AN8                      :1;
        __IO  uint16_t  AN9                      :1;
        __IO  uint16_t  AN10                     :1;
        __IO  uint16_t  AN11                     :1;
        __IO  uint16_t  AN12                     :1;
        __IO  uint16_t  AN13                     :1;
        __IO  uint16_t  AN14                     :1;
        __IO  uint16_t  AN15                     :1;
} stc_adc_scis01_field_t;

typedef struct stc_adc_pfns_field
{
    union {
        struct {
            __IO   uint8_t  PFS                  :2;
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  TEST                 :2;
            __IO   uint8_t  RESERVED2            :2;
        };
        struct {
            __IO   uint8_t  PFS0                 :1;
            __IO   uint8_t  PFS1                 :1;
            __IO   uint8_t  RESERVED1            :2;
            __IO   uint8_t  TEST0                :1;
            __IO   uint8_t  TEST1                :1;
            __IO   uint8_t  RESERVED3            :2;
        };
    };
} stc_adc_pfns_field_t;

typedef struct stc_adc_pccr_field
{
        __IO   uint8_t  PSTR                     :1;
        __IO   uint8_t  PHEN                     :1;
        __IO   uint8_t  PEEN                     :1;
        __IO   uint8_t  ESCE                     :1;
        __IO   uint8_t  PFCLR                    :1;
        __IO   uint8_t  POVR                     :1;
        __IO   uint8_t  PFUL                     :1;
        __IO   uint8_t  PEMP                     :1;
} stc_adc_pccr_field_t;

typedef struct stc_adc_pcfd_fdas1_field
{
    union {
        struct {
            __IO  uint32_t  PC                   :5;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  RS                   :3;
            __IO  uint32_t  RESERVED2            :1;
            __IO  uint32_t  INVL                 :1;
            __IO  uint32_t  RESERVED3            :3;
            __IO  uint32_t  PD                   :12;
            __IO  uint32_t  RESERVED5            :4;
        };
        struct {
            __IO  uint32_t  PC0                  :1;
            __IO  uint32_t  PC1                  :1;
            __IO  uint32_t  PC2                  :1;
            __IO  uint32_t  PC3                  :1;
            __IO  uint32_t  PC4                  :1;
            __IO  uint32_t  RESERVED1            :3;
            __IO  uint32_t  RS0                  :1;
            __IO  uint32_t  RS1                  :1;
            __IO  uint32_t  RS2                  :1;
            __IO  uint32_t  RESERVED4            :5;
            __IO  uint32_t  PD0                  :1;
            __IO  uint32_t  PD1                  :1;
            __IO  uint32_t  PD2                  :1;
            __IO  uint32_t  PD3                  :1;
            __IO  uint32_t  PD4                  :1;
            __IO  uint32_t  PD5                  :1;
            __IO  uint32_t  PD6                  :1;
            __IO  uint32_t  PD7                  :1;
            __IO  uint32_t  PD8                  :1;
            __IO  uint32_t  PD9                  :1;
            __IO  uint32_t  PD10                 :1;
            __IO  uint32_t  PD11                 :1;
            __IO  uint32_t  RESERVED6            :4;
        };
    };
} stc_adc_pcfd_fdas1_field_t;

typedef struct stc_adc_pcfd_field
{
    union {
        struct {
            __IO  uint32_t  PC                   :5;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  RS                   :3;
            __IO  uint32_t  RESERVED2            :1;
            __IO  uint32_t  INVL                 :1;
            __IO  uint32_t  RESERVED3            :7;
            __IO  uint32_t  PD                   :12;
        };
        struct {
            __IO  uint32_t  PC0                  :1;
            __IO  uint32_t  PC1                  :1;
            __IO  uint32_t  PC2                  :1;
            __IO  uint32_t  PC3                  :1;
            __IO  uint32_t  PC4                  :1;
            __IO  uint32_t  RESERVED1            :3;
            __IO  uint32_t  RS0                  :1;
            __IO  uint32_t  RS1                  :1;
            __IO  uint32_t  RS2                  :1;
            __IO  uint32_t  RESERVED4            :9;
            __IO  uint32_t  PD0                  :1;
            __IO  uint32_t  PD1                  :1;
            __IO  uint32_t  PD2                  :1;
            __IO  uint32_t  PD3                  :1;
            __IO  uint32_t  PD4                  :1;
            __IO  uint32_t  PD5                  :1;
            __IO  uint32_t  PD6                  :1;
            __IO  uint32_t  PD7                  :1;
            __IO  uint32_t  PD8                  :1;
            __IO  uint32_t  PD9                  :1;
            __IO  uint32_t  PD10                 :1;
            __IO  uint32_t  PD11                 :1;
        };
    };
} stc_adc_pcfd_field_t;

typedef struct stc_adc_pcis_field
{
    union {
        struct {
            __IO   uint8_t  P1A                  :3;
            __IO   uint8_t  P2A                  :5;
        };
        struct {
            __IO   uint8_t  P1A0                 :1;
            __IO   uint8_t  P1A1                 :1;
            __IO   uint8_t  P1A2                 :1;
            __IO   uint8_t  P2A0                 :1;
            __IO   uint8_t  P2A1                 :1;
            __IO   uint8_t  P2A2                 :1;
            __IO   uint8_t  P2A3                 :1;
            __IO   uint8_t  P2A4                 :1;
        };
    };
} stc_adc_pcis_field_t;

typedef struct stc_adc_cmpcr_field
{
    union {
        struct {
            __IO   uint8_t  CCH                  :5;
            __IO   uint8_t  CMD0                 :1;
            __IO   uint8_t  CMD1                 :1;
            __IO   uint8_t  CMPEN                :1;
        };
        struct {
            __IO   uint8_t  CCH0                 :1;
            __IO   uint8_t  CCH1                 :1;
            __IO   uint8_t  CCH2                 :1;
            __IO   uint8_t  CCH3                 :1;
            __IO   uint8_t  CCH4                 :1;
            __IO   uint8_t  RESERVED0            :3;
        };
    };
} stc_adc_cmpcr_field_t;

typedef struct stc_adc_cmpd_field
{
    union {
        struct {
            __IO  uint16_t  RESERVED0            :6;
            __IO  uint16_t  CMAD                 :10;
        };
        struct {
            __IO  uint16_t  RESERVED1            :6;
            __IO  uint16_t  CMAD0                :1;
            __IO  uint16_t  CMAD1                :1;
            __IO  uint16_t  CMAD2                :1;
            __IO  uint16_t  CMAD3                :1;
            __IO  uint16_t  CMAD4                :1;
            __IO  uint16_t  CMAD5                :1;
            __IO  uint16_t  CMAD6                :1;
            __IO  uint16_t  CMAD7                :1;
            __IO  uint16_t  CMAD8                :1;
            __IO  uint16_t  CMAD9                :1;
        };
    };
} stc_adc_cmpd_field_t;

typedef struct stc_adc_adss23_field
{
        __IO  uint16_t  TS16                     :1;
        __IO  uint16_t  TS17                     :1;
        __IO  uint16_t  TS18                     :1;
        __IO  uint16_t  TS19                     :1;
        __IO  uint16_t  TS20                     :1;
        __IO  uint16_t  TS21                     :1;
        __IO  uint16_t  TS22                     :1;
        __IO  uint16_t  TS23                     :1;
        __IO  uint16_t  TS24                     :1;
        __IO  uint16_t  TS25                     :1;
        __IO  uint16_t  TS26                     :1;
        __IO  uint16_t  TS27                     :1;
        __IO  uint16_t  TS28                     :1;
        __IO  uint16_t  TS29                     :1;
        __IO  uint16_t  TS30                     :1;
        __IO  uint16_t  TS31                     :1;
} stc_adc_adss23_field_t;

typedef struct stc_adc_adss01_field
{
        __IO  uint16_t  TS0                      :1;
        __IO  uint16_t  TS1                      :1;
        __IO  uint16_t  TS2                      :1;
        __IO  uint16_t  TS3                      :1;
        __IO  uint16_t  TS4                      :1;
        __IO  uint16_t  TS5                      :1;
        __IO  uint16_t  TS6                      :1;
        __IO  uint16_t  TS7                      :1;
        __IO  uint16_t  TS8                      :1;
        __IO  uint16_t  TS9                      :1;
        __IO  uint16_t  TS10                     :1;
        __IO  uint16_t  TS11                     :1;
        __IO  uint16_t  TS12                     :1;
        __IO  uint16_t  TS13                     :1;
        __IO  uint16_t  TS14                     :1;
        __IO  uint16_t  TS15                     :1;
} stc_adc_adss01_field_t;

typedef struct stc_adc_adst01_field
{
    union {
        struct {
            __IO  uint16_t  ST1                  :5;
            __IO  uint16_t  STX1                 :3;
            __IO  uint16_t  ST0                  :5;
            __IO  uint16_t  STX0                 :3;
        };
        struct {
            __IO  uint16_t  ST10                 :1;
            __IO  uint16_t  ST11                 :1;
            __IO  uint16_t  ST12                 :1;
            __IO  uint16_t  ST13                 :1;
            __IO  uint16_t  ST14                 :1;
            __IO  uint16_t  STX10                :1;
            __IO  uint16_t  STX11                :1;
            __IO  uint16_t  STX12                :1;
            __IO  uint16_t  ST00                 :1;
            __IO  uint16_t  ST01                 :1;
            __IO  uint16_t  ST02                 :1;
            __IO  uint16_t  ST03                 :1;
            __IO  uint16_t  ST04                 :1;
            __IO  uint16_t  STX00                :1;
            __IO  uint16_t  STX01                :1;
            __IO  uint16_t  STX02                :1;
        };
    };
} stc_adc_adst01_field_t;

typedef struct stc_adc_adct_field
{
    union {
        struct {
            __IO   uint8_t  CT                   :8;
        };
        struct {
            __IO   uint8_t  CT0                  :1;
            __IO   uint8_t  CT1                  :1;
            __IO   uint8_t  CT2                  :1;
            __IO   uint8_t  CT3                  :1;
            __IO   uint8_t  CT4                  :1;
            __IO   uint8_t  CT5                  :1;
            __IO   uint8_t  CT6                  :1;
            __IO   uint8_t  CT7                  :1;
        };
    };
} stc_adc_adct_field_t;

typedef struct stc_adc_prtsl_field
{
    union {
        struct {
            __IO   uint8_t  PRTSL                :4;
            __IO   uint8_t  RESERVED0            :4;
        };
        struct {
            __IO   uint8_t  PRTSL0               :1;
            __IO   uint8_t  PRTSL1               :1;
            __IO   uint8_t  PRTSL2               :1;
            __IO   uint8_t  PRTSL3               :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_adc_prtsl_field_t;

typedef struct stc_adc_sctsl_field
{
    union {
        struct {
            __IO   uint8_t  SCTSL                :4;
            __IO   uint8_t  RESERVED0            :4;
        };
        struct {
            __IO   uint8_t  SCTSL0               :1;
            __IO   uint8_t  SCTSL1               :1;
            __IO   uint8_t  SCTSL2               :1;
            __IO   uint8_t  SCTSL3               :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_adc_sctsl_field_t;

typedef struct stc_adc_adcen_field
{
    union {
        struct {
            __IO  uint16_t  ENBL                 :1;
            __IO  uint16_t  READY                :1;
            __IO  uint16_t  RESERVED0            :6;
            __IO  uint16_t  ENBLTIME             :8;
        };
        struct {
            __IO  uint16_t  RESERVED1            :8;
            __IO  uint16_t  ENBLTIME0            :1;
            __IO  uint16_t  ENBLTIME1            :1;
            __IO  uint16_t  ENBLTIME2            :1;
            __IO  uint16_t  ENBLTIME3            :1;
            __IO  uint16_t  ENBLTIME4            :1;
            __IO  uint16_t  ENBLTIME5            :1;
            __IO  uint16_t  ENBLTIME6            :1;
            __IO  uint16_t  ENBLTIME7            :1;
        };
    };
} stc_adc_adcen_field_t;

typedef struct stc_adc_calsr_field
{
    union {
        struct {
            __IO  uint32_t  OFST                 :8;
            __IO  uint32_t  CLBEN                :1;
            __IO  uint32_t  RESERVED0            :23;
        };
        struct {
            __IO  uint32_t  OFST0                :1;
            __IO  uint32_t  OFST1                :1;
            __IO  uint32_t  OFST2                :1;
            __IO  uint32_t  OFST3                :1;
            __IO  uint32_t  OFST4                :1;
            __IO  uint32_t  OFST5                :1;
            __IO  uint32_t  OFST6                :1;
            __IO  uint32_t  OFST7                :1;
            __IO  uint32_t  RESERVED1            :24;
        };
    };
} stc_adc_calsr_field_t;

typedef struct stc_adc_wcmrcot_field
{
        __IO   uint8_t  RCOOF                    :1;
        __IO   uint8_t  RESERVED0                :7;
} stc_adc_wcmrcot_field_t;

typedef struct stc_adc_wcmrcif_field
{
        __IO   uint8_t  RCINT                    :1;
        __IO   uint8_t  RESERVED0                :7;
} stc_adc_wcmrcif_field_t;

typedef struct stc_adc_wcmpcr_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  RCOE                 :1;
            __IO   uint8_t  RCOIE                :1;
            __IO   uint8_t  RCOIRS               :1;
            __IO   uint8_t  RCOCD                :3;
        };
        struct {
            __IO   uint8_t  RESERVED1            :5;
            __IO   uint8_t  RCOCD0               :1;
            __IO   uint8_t  RCOCD1               :1;
            __IO   uint8_t  RCOCD2               :1;
        };
    };
} stc_adc_wcmpcr_field_t;

typedef struct stc_adc_wcmpsr_field
{
    union {
        struct {
            __IO   uint8_t  WCCH                 :5;
            __IO   uint8_t  WCMD                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  WCCH0                :1;
            __IO   uint8_t  WCCH1                :1;
            __IO   uint8_t  WCCH2                :1;
            __IO   uint8_t  WCCH3                :1;
            __IO   uint8_t  WCCH4                :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_adc_wcmpsr_field_t;

typedef struct stc_adc_wcmpdl_field
{
    union {
        struct {
            __IO  uint16_t  RESERVED0            :6;
            __IO  uint16_t  CMLD                 :10;
        };
        struct {
            __IO  uint16_t  RESERVED1            :6;
            __IO  uint16_t  CMLD0                :1;
            __IO  uint16_t  CMLD1                :1;
            __IO  uint16_t  CMLD2                :1;
            __IO  uint16_t  CMLD3                :1;
            __IO  uint16_t  CMLD4                :1;
            __IO  uint16_t  CMLD5                :1;
            __IO  uint16_t  CMLD6                :1;
            __IO  uint16_t  CMLD7                :1;
            __IO  uint16_t  CMLD8                :1;
            __IO  uint16_t  CMLD9                :1;
        };
    };
} stc_adc_wcmpdl_field_t;

typedef struct stc_adc_wcmpdh_field
{
    union {
        struct {
            __IO  uint16_t  RESERVED0            :6;
            __IO  uint16_t  CMHD                 :10;
        };
        struct {
            __IO  uint16_t  RESERVED1            :6;
            __IO  uint16_t  CMHD0                :1;
            __IO  uint16_t  CMHD1                :1;
            __IO  uint16_t  CMHD2                :1;
            __IO  uint16_t  CMHD3                :1;
            __IO  uint16_t  CMHD4                :1;
            __IO  uint16_t  CMHD5                :1;
            __IO  uint16_t  CMHD6                :1;
            __IO  uint16_t  CMHD7                :1;
            __IO  uint16_t  CMHD8                :1;
            __IO  uint16_t  CMHD9                :1;
        };
    };
} stc_adc_wcmpdh_field_t;

/******************************************************************************
 ** BT_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_bt_tmcr_field
{
    union {
        union {
            struct {
                __IO  uint16_t  STRG             :1;
                __IO  uint16_t  CTEN             :1;
                __IO  uint16_t  MDSE             :1;
                __IO  uint16_t  OSEL             :1;
                __IO  uint16_t  FMD              :3;
                __IO  uint16_t  RESERVED1        :1;
                __IO  uint16_t  EGS              :2;
                __IO  uint16_t  PMSK             :1;
                __IO  uint16_t  RTGEN            :1;
                __IO  uint16_t  CKS              :3;
                __IO  uint16_t  RESERVED4        :1;
            };
            struct {
                __IO  uint16_t  RESERVED0        :4;
                __IO  uint16_t  FMD0             :1;
                __IO  uint16_t  FMD1             :1;
                __IO  uint16_t  FMD2             :1;
                __IO  uint16_t  RESERVED2        :1;
                __IO  uint16_t  EGS0             :1;
                __IO  uint16_t  EGS1             :1;
                __IO  uint16_t  RESERVED3        :2;
                __IO  uint16_t  CKS0             :1;
                __IO  uint16_t  CKS1             :1;
                __IO  uint16_t  CKS2             :1;
                __IO  uint16_t  RESERVED5        :1;
            };
        };
        union {
            struct {
                __IO  uint16_t  RESERVED6        :7;
                __IO  uint16_t  T32              :1;
                __IO  uint16_t  RESERVED7        :8;
            };
            struct {
                __IO  uint16_t  RESERVED8        :16;
            };
        };
    };
} stc_bt_tmcr_field_t;

typedef struct stc_bt_stc_field
{
    union {
        struct {
            __IO   uint8_t  UDIR                 :1;
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  TGIR                 :1;
            __IO   uint8_t  RESERVED1            :1;
            __IO   uint8_t  UDIE                 :1;
            __IO   uint8_t  RESERVED2            :1;
            __IO   uint8_t  TGIE                 :1;
            __IO   uint8_t  RESERVED3            :1;
        };
        struct {
            __IO   uint8_t  OVIR                 :1;
            __IO   uint8_t  RESERVED5            :1;
            __IO   uint8_t  EDIR                 :1;
            __IO   uint8_t  RESERVED6            :1;
            __IO   uint8_t  OVIE                 :1;
            __IO   uint8_t  RESERVED7            :1;
            __IO   uint8_t  EDIE                 :1;
            __IO   uint8_t  ERR                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED9            :1;
            __IO   uint8_t  DTIR                 :1;
            __IO   uint8_t  RESERVED10           :3;
            __IO   uint8_t  DTIE                 :1;
            __IO   uint8_t  RESERVED11           :2;
        };
    };
} stc_bt_stc_field_t;

typedef struct stc_bt_tmcr2_field
{
    union {
        struct {
            __IO   uint8_t  CKS3                 :1;
            __IO   uint8_t  RESERVED0            :7;
        };
        struct {
            __IO   uint8_t  RESERVED6            :7;
            __IO   uint8_t  GATE                 :1;
        };
    };
} stc_bt_tmcr2_field_t;

typedef struct stc_bt_ppg_tmcr_field
{
    union {
        struct {
            __IO  uint16_t  STRG                 :1;
            __IO  uint16_t  CTEN                 :1;
            __IO  uint16_t  MDSE                 :1;
            __IO  uint16_t  OSEL                 :1;
            __IO  uint16_t  FMD                  :3;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  EGS                  :2;
            __IO  uint16_t  PMSK                 :1;
            __IO  uint16_t  RTGEN                :1;
            __IO  uint16_t  CKS                  :3;
            __IO  uint16_t  RESERVED4            :1;
        };
        struct {
            __IO  uint16_t  RESERVED0            :4;
            __IO  uint16_t  FMD0                 :1;
            __IO  uint16_t  FMD1                 :1;
            __IO  uint16_t  FMD2                 :1;
            __IO  uint16_t  RESERVED2            :1;
            __IO  uint16_t  EGS0                 :1;
            __IO  uint16_t  EGS1                 :1;
            __IO  uint16_t  RESERVED3            :2;
            __IO  uint16_t  CKS0                 :1;
            __IO  uint16_t  CKS1                 :1;
            __IO  uint16_t  CKS2                 :1;
            __IO  uint16_t  RESERVED5            :1;
        };
    };
} stc_bt_ppg_tmcr_field_t;

typedef struct stc_bt_pwc_tmcr_field
{
    union {
        struct {
            __IO  uint16_t  RESERVED6            :1;
            __IO  uint16_t  CTEN                 :1;
            __IO  uint16_t  MDSE                 :1;
            __IO  uint16_t  RESERVED7            :1;
            __IO  uint16_t  FMD                  :3;
            __IO  uint16_t  T32                  :1;
            __IO  uint16_t  EGS                  :3;
            __IO  uint16_t  RESERVED10           :1;
            __IO  uint16_t  CKS                  :3;
            __IO  uint16_t  RESERVED12           :1;
        };
        struct {
            __IO  uint16_t  RESERVED8            :4;
            __IO  uint16_t  FMD0                 :1;
            __IO  uint16_t  FMD1                 :1;
            __IO  uint16_t  FMD2                 :1;
            __IO  uint16_t  RESERVED9            :1;
            __IO  uint16_t  EGS0                 :1;
            __IO  uint16_t  EGS1                 :1;
            __IO  uint16_t  EGS2                 :1;
            __IO  uint16_t  RESERVED11           :1;
            __IO  uint16_t  CKS0                 :1;
            __IO  uint16_t  CKS1                 :1;
            __IO  uint16_t  CKS2                 :1;
            __IO  uint16_t  RESERVED13           :1;
        };
    };
} stc_bt_pwc_tmcr_field_t;

typedef struct stc_bt_pwm_tmcr_field
{
    union {
        struct {
            __IO  uint16_t  STRG                 :1;
            __IO  uint16_t  CTEN                 :1;
            __IO  uint16_t  MDSE                 :1;
            __IO  uint16_t  OSEL                 :1;
            __IO  uint16_t  FMD                  :3;
            __IO  uint16_t  RESERVED15           :1;
            __IO  uint16_t  EGS                  :2;
            __IO  uint16_t  PMSK                 :1;
            __IO  uint16_t  RTGEN                :1;
            __IO  uint16_t  CKS                  :3;
            __IO  uint16_t  RESERVED18           :1;
        };
        struct {
            __IO  uint16_t  RESERVED14           :4;
            __IO  uint16_t  FMD0                 :1;
            __IO  uint16_t  FMD1                 :1;
            __IO  uint16_t  FMD2                 :1;
            __IO  uint16_t  RESERVED16           :1;
            __IO  uint16_t  EGS0                 :1;
            __IO  uint16_t  EGS1                 :1;
            __IO  uint16_t  RESERVED17           :2;
            __IO  uint16_t  CKS0                 :1;
            __IO  uint16_t  CKS1                 :1;
            __IO  uint16_t  CKS2                 :1;
            __IO  uint16_t  RESERVED19           :1;
        };
    };
} stc_bt_pwm_tmcr_field_t;

typedef struct stc_bt_rt_tmcr_field
{
    union {
        struct {
            __IO  uint16_t  STRG                 :1;
            __IO  uint16_t  CTEN                 :1;
            __IO  uint16_t  MDSE                 :1;
            __IO  uint16_t  OSEL                 :1;
            __IO  uint16_t  FMD                  :3;
            __IO  uint16_t  T32                  :1;
            __IO  uint16_t  EGS                  :2;
            __IO  uint16_t  RESERVED22           :2;
            __IO  uint16_t  CKS                  :3;
            __IO  uint16_t  RESERVED24           :1;
        };
        struct {
            __IO  uint16_t  RESERVED20           :4;
            __IO  uint16_t  FMD0                 :1;
            __IO  uint16_t  FMD1                 :1;
            __IO  uint16_t  FMD2                 :1;
            __IO  uint16_t  RESERVED21           :1;
            __IO  uint16_t  EGS0                 :1;
            __IO  uint16_t  EGS1                 :1;
            __IO  uint16_t  RESERVED23           :2;
            __IO  uint16_t  CKS0                 :1;
            __IO  uint16_t  CKS1                 :1;
            __IO  uint16_t  CKS2                 :1;
            __IO  uint16_t  RESERVED25           :1;
        };
    };
} stc_bt_rt_tmcr_field_t;

typedef struct stc_bt_ppg_stc_field
{
        __IO   uint8_t  UDIR                     :1;
        __IO   uint8_t  RESERVED0                :1;
        __IO   uint8_t  TGIR                     :1;
        __IO   uint8_t  RESERVED1                :1;
        __IO   uint8_t  UDIE                     :1;
        __IO   uint8_t  RESERVED2                :1;
        __IO   uint8_t  TGIE                     :1;
        __IO   uint8_t  RESERVED3                :1;
} stc_bt_ppg_stc_field_t;

typedef struct stc_bt_pwc_stc_field
{
        __IO   uint8_t  OVIR                     :1;
        __IO   uint8_t  RESERVED5                :1;
        __IO   uint8_t  EDIR                     :1;
        __IO   uint8_t  RESERVED6                :1;
        __IO   uint8_t  OVIE                     :1;
        __IO   uint8_t  RESERVED7                :1;
        __IO   uint8_t  EDIE                     :1;
        __IO   uint8_t  ERR                      :1;
} stc_bt_pwc_stc_field_t;

typedef struct stc_bt_pwm_stc_field
{
        __IO   uint8_t  UDIR                     :1;
        __IO   uint8_t  DTIR                     :1;
        __IO   uint8_t  TGIR                     :1;
        __IO   uint8_t  RESERVED9                :1;
        __IO   uint8_t  UDIE                     :1;
        __IO   uint8_t  DTIE                     :1;
        __IO   uint8_t  TGIE                     :1;
        __IO   uint8_t  RESERVED10               :1;
} stc_bt_pwm_stc_field_t;

typedef struct stc_bt_rt_stc_field
{
        __IO   uint8_t  UDIR                     :1;
        __IO   uint8_t  RESERVED12               :1;
        __IO   uint8_t  TGIR                     :1;
        __IO   uint8_t  RESERVED13               :1;
        __IO   uint8_t  UDIE                     :1;
        __IO   uint8_t  RESERVED14               :1;
        __IO   uint8_t  TGIE                     :1;
        __IO   uint8_t  RESERVED15               :1;
} stc_bt_rt_stc_field_t;

typedef struct stc_bt_ppg_tmcr2_field
{
        __IO   uint8_t  CKS3                     :1;
        __IO   uint8_t  RESERVED0                :7;
} stc_bt_ppg_tmcr2_field_t;

typedef struct stc_bt_pwc_tmcr2_field
{
        __IO   uint8_t  CKS3                     :1;
        __IO   uint8_t  RESERVED2                :7;
} stc_bt_pwc_tmcr2_field_t;

typedef struct stc_bt_pwm_tmcr2_field
{
        __IO   uint8_t  CKS3                     :1;
        __IO   uint8_t  RESERVED4                :7;
} stc_bt_pwm_tmcr2_field_t;

typedef struct stc_bt_rt_tmcr2_field
{
        __IO   uint8_t  CKS3                     :1;
        __IO   uint8_t  RESERVED6                :6;
        __IO   uint8_t  GATE                     :1;
} stc_bt_rt_tmcr2_field_t;

/******************************************************************************
 ** BTIOSEL03_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_btiosel03_btsel0123_field
{
    union {
        struct {
            __IO   uint8_t  SEL01                :4;
            __IO   uint8_t  SEL23                :4;
        };
        struct {
            __IO   uint8_t  SEL010               :1;
            __IO   uint8_t  SEL011               :1;
            __IO   uint8_t  SEL012               :1;
            __IO   uint8_t  SEL013               :1;
            __IO   uint8_t  SEL230               :1;
            __IO   uint8_t  SEL231               :1;
            __IO   uint8_t  SEL232               :1;
            __IO   uint8_t  SEL233               :1;
        };
    };
} stc_btiosel03_btsel0123_field_t;

/******************************************************************************
 ** BTIOSEL47_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_btiosel47_btsel4567_field
{
    union {
        struct {
            __IO   uint8_t  SEL45                :4;
            __IO   uint8_t  SEL67                :4;
        };
        struct {
            __IO   uint8_t  SEL450               :1;
            __IO   uint8_t  SEL451               :1;
            __IO   uint8_t  SEL452               :1;
            __IO   uint8_t  SEL453               :1;
            __IO   uint8_t  SEL670               :1;
            __IO   uint8_t  SEL671               :1;
            __IO   uint8_t  SEL672               :1;
            __IO   uint8_t  SEL673               :1;
        };
    };
} stc_btiosel47_btsel4567_field_t;

/******************************************************************************
 ** BTIOSEL8B_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_btiosel8b_btsel89ab_field
{
    union {
        struct {
            __IO   uint8_t  SEL89                :4;
            __IO   uint8_t  SELAB                :4;
        };
        struct {
            __IO   uint8_t  SEL890               :1;
            __IO   uint8_t  SEL891               :1;
            __IO   uint8_t  SEL892               :1;
            __IO   uint8_t  SEL893               :1;
            __IO   uint8_t  SELAB0               :1;
            __IO   uint8_t  SELAB1               :1;
            __IO   uint8_t  SELAB2               :1;
            __IO   uint8_t  SELAB3               :1;
        };
    };
} stc_btiosel8b_btsel89ab_field_t;

/******************************************************************************
 ** BTIOSELCF_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_btioselcf_btselcdef_field
{
    union {
        struct {
            __IO   uint8_t  SELCD                :4;
            __IO   uint8_t  SELEF                :4;
        };
        struct {
            __IO   uint8_t  SELCD0               :1;
            __IO   uint8_t  SELCD1               :1;
            __IO   uint8_t  SELCD2               :1;
            __IO   uint8_t  SELCD3               :1;
            __IO   uint8_t  SELEF0               :1;
            __IO   uint8_t  SELEF1               :1;
            __IO   uint8_t  SELEF2               :1;
            __IO   uint8_t  SELEF3               :1;
        };
    };
} stc_btioselcf_btselcdef_field_t;

/******************************************************************************
 ** CAN_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_can_ctrlr_field
{
        __IO  uint16_t  INIT                     :1;
        __IO  uint16_t  IE                       :1;
        __IO  uint16_t  SIE                      :1;
        __IO  uint16_t  EIE                      :1;
        __IO  uint16_t  RESERVED0                :1;
        __IO  uint16_t  DAR                      :1;
        __IO  uint16_t  CCE                      :1;
        __IO  uint16_t  TEST                     :1;
        __IO  uint16_t  RESERVED1                :8;
} stc_can_ctrlr_field_t;

typedef struct stc_can_statr_field
{
    union {
        struct {
            __IO  uint16_t  LEC                  :3;
            __IO  uint16_t  TXOK                 :1;
            __IO  uint16_t  RXOK                 :1;
            __IO  uint16_t  EPASS                :1;
            __IO  uint16_t  EWARN                :1;
            __IO  uint16_t  BOFF                 :1;
            __IO  uint16_t  RESERVED0            :8;
        };
        struct {
            __IO  uint16_t  LEC0                 :1;
            __IO  uint16_t  LEC1                 :1;
            __IO  uint16_t  LEC2                 :1;
            __IO  uint16_t  RESERVED1            :13;
        };
    };
} stc_can_statr_field_t;

typedef struct stc_can_errcnt_field
{
    union {
        struct {
            __IO  uint16_t  TEC                  :8;
            __IO  uint16_t  REC                  :7;
            __IO  uint16_t  RP                   :1;
        };
        struct {
            __IO  uint16_t  TEC0                 :1;
            __IO  uint16_t  TEC1                 :1;
            __IO  uint16_t  TEC2                 :1;
            __IO  uint16_t  TEC3                 :1;
            __IO  uint16_t  TEC4                 :1;
            __IO  uint16_t  TEC5                 :1;
            __IO  uint16_t  TEC6                 :1;
            __IO  uint16_t  TEC7                 :1;
            __IO  uint16_t  REC0                 :1;
            __IO  uint16_t  REC1                 :1;
            __IO  uint16_t  REC2                 :1;
            __IO  uint16_t  REC3                 :1;
            __IO  uint16_t  REC4                 :1;
            __IO  uint16_t  REC5                 :1;
            __IO  uint16_t  REC6                 :1;
            __IO  uint16_t  RESERVED0            :1;
        };
    };
} stc_can_errcnt_field_t;

typedef struct stc_can_btr_field
{
    union {
        struct {
            __IO  uint16_t  BRP                  :6;
            __IO  uint16_t  SJW                  :2;
            __IO  uint16_t  TSEG1                :4;
            __IO  uint16_t  TSEG2                :3;
            __IO  uint16_t  RESERVED0            :1;
        };
        struct {
            __IO  uint16_t  BRP0                 :1;
            __IO  uint16_t  BRP1                 :1;
            __IO  uint16_t  BRP2                 :1;
            __IO  uint16_t  BRP3                 :1;
            __IO  uint16_t  BRP4                 :1;
            __IO  uint16_t  BRP5                 :1;
            __IO  uint16_t  SJW0                 :1;
            __IO  uint16_t  SJW1                 :1;
            __IO  uint16_t  TSEG10               :1;
            __IO  uint16_t  TSEG11               :1;
            __IO  uint16_t  TSEG12               :1;
            __IO  uint16_t  TSEG13               :1;
            __IO  uint16_t  TSEG20               :1;
            __IO  uint16_t  TSEG21               :1;
            __IO  uint16_t  TSEG22               :1;
            __IO  uint16_t  RESERVED1            :1;
        };
    };
} stc_can_btr_field_t;

typedef struct stc_can_intr_field
{
    union {
        struct {
            __IO  uint16_t  INTID                :16;
        };
        struct {
            __IO  uint16_t  INTID0               :1;
            __IO  uint16_t  INTID1               :1;
            __IO  uint16_t  INTID2               :1;
            __IO  uint16_t  INTID3               :1;
            __IO  uint16_t  INTID4               :1;
            __IO  uint16_t  INTID5               :1;
            __IO  uint16_t  INTID6               :1;
            __IO  uint16_t  INTID7               :1;
            __IO  uint16_t  INTID8               :1;
            __IO  uint16_t  INTID9               :1;
            __IO  uint16_t  INTID10              :1;
            __IO  uint16_t  INTID11              :1;
            __IO  uint16_t  INTID12              :1;
            __IO  uint16_t  INTID13              :1;
            __IO  uint16_t  INTID14              :1;
            __IO  uint16_t  INTID15              :1;
        };
    };
} stc_can_intr_field_t;

typedef struct stc_can_testr_field
{
    union {
        struct {
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  BASIC                :1;
            __IO  uint16_t  SILENT               :1;
            __IO  uint16_t  LBACK                :1;
            __IO  uint16_t  TX                   :2;
            __IO  uint16_t  RX                   :1;
            __IO  uint16_t  RESERVED2            :8;
        };
        struct {
            __IO  uint16_t  RESERVED1            :5;
            __IO  uint16_t  TX0                  :1;
            __IO  uint16_t  TX1                  :1;
            __IO  uint16_t  RESERVED3            :9;
        };
    };
} stc_can_testr_field_t;

typedef struct stc_can_brper_field
{
    union {
        struct {
            __IO  uint16_t  BRPE                 :4;
            __IO  uint16_t  RESERVED0            :12;
        };
        struct {
            __IO  uint16_t  BRPE0                :1;
            __IO  uint16_t  BRPE1                :1;
            __IO  uint16_t  BRPE2                :1;
            __IO  uint16_t  BRPE3                :1;
            __IO  uint16_t  RESERVED1            :12;
        };
    };
} stc_can_brper_field_t;

typedef struct stc_can_if1creq_field
{
    union {
        struct {
            __IO  uint16_t  MESSAGENUMBER        :8;
            __IO  uint16_t  RESERVED0            :7;
            __IO  uint16_t  BUSY                 :1;
        };
        struct {
            __IO  uint16_t  MESSAGENUMBER0       :1;
            __IO  uint16_t  MESSAGENUMBER1       :1;
            __IO  uint16_t  MESSAGENUMBER2       :1;
            __IO  uint16_t  MESSAGENUMBER3       :1;
            __IO  uint16_t  MESSAGENUMBER4       :1;
            __IO  uint16_t  MESSAGENUMBER5       :1;
            __IO  uint16_t  MESSAGENUMBER6       :1;
            __IO  uint16_t  MESSAGENUMBER7       :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_can_if1creq_field_t;

typedef struct stc_can_if1cmsk_field
{
        __IO  uint16_t  DATAB                    :1;
        __IO  uint16_t  DATAA                    :1;
        __IO  uint16_t  NEWDAT                   :1;
        __IO  uint16_t  CIP                      :1;
        __IO  uint16_t  CONTROL                  :1;
        __IO  uint16_t  ARB                      :1;
        __IO  uint16_t  MASK                     :1;
        __IO  uint16_t  WR_RD                    :1;
        __IO  uint16_t  RESERVED0                :8;
} stc_can_if1cmsk_field_t;

typedef struct stc_can_if1msk_field
{
    union {
        struct {
            __IO  uint32_t  MSK                  :29;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  MDIR                 :1;
            __IO  uint32_t  MXTD                 :1;
        };
        struct {
            __IO  uint32_t  MSK0                 :1;
            __IO  uint32_t  MSK1                 :1;
            __IO  uint32_t  MSK2                 :1;
            __IO  uint32_t  MSK3                 :1;
            __IO  uint32_t  MSK4                 :1;
            __IO  uint32_t  MSK5                 :1;
            __IO  uint32_t  MSK6                 :1;
            __IO  uint32_t  MSK7                 :1;
            __IO  uint32_t  MSK8                 :1;
            __IO  uint32_t  MSK9                 :1;
            __IO  uint32_t  MSK10                :1;
            __IO  uint32_t  MSK11                :1;
            __IO  uint32_t  MSK12                :1;
            __IO  uint32_t  MSK13                :1;
            __IO  uint32_t  MSK14                :1;
            __IO  uint32_t  MSK15                :1;
            __IO  uint32_t  MSK16                :1;
            __IO  uint32_t  MSK17                :1;
            __IO  uint32_t  MSK18                :1;
            __IO  uint32_t  MSK19                :1;
            __IO  uint32_t  MSK20                :1;
            __IO  uint32_t  MSK21                :1;
            __IO  uint32_t  MSK22                :1;
            __IO  uint32_t  MSK23                :1;
            __IO  uint32_t  MSK24                :1;
            __IO  uint32_t  MSK25                :1;
            __IO  uint32_t  MSK26                :1;
            __IO  uint32_t  MSK27                :1;
            __IO  uint32_t  MSK28                :1;
            __IO  uint32_t  RESERVED1            :3;
        };
    };
} stc_can_if1msk_field_t;

typedef struct stc_can_if1arb_field
{
    union {
        struct {
            __IO  uint32_t  ID                   :29;
            __IO  uint32_t  DIR                  :1;
            __IO  uint32_t  XTD                  :1;
            __IO  uint32_t  MSGVAL               :1;
        };
        struct {
            __IO  uint32_t  ID0                  :1;
            __IO  uint32_t  ID1                  :1;
            __IO  uint32_t  ID2                  :1;
            __IO  uint32_t  ID3                  :1;
            __IO  uint32_t  ID4                  :1;
            __IO  uint32_t  ID5                  :1;
            __IO  uint32_t  ID6                  :1;
            __IO  uint32_t  ID7                  :1;
            __IO  uint32_t  ID8                  :1;
            __IO  uint32_t  ID9                  :1;
            __IO  uint32_t  ID10                 :1;
            __IO  uint32_t  ID11                 :1;
            __IO  uint32_t  ID12                 :1;
            __IO  uint32_t  ID13                 :1;
            __IO  uint32_t  ID14                 :1;
            __IO  uint32_t  ID15                 :1;
            __IO  uint32_t  ID16                 :1;
            __IO  uint32_t  ID17                 :1;
            __IO  uint32_t  ID18                 :1;
            __IO  uint32_t  ID19                 :1;
            __IO  uint32_t  ID20                 :1;
            __IO  uint32_t  ID21                 :1;
            __IO  uint32_t  ID22                 :1;
            __IO  uint32_t  ID23                 :1;
            __IO  uint32_t  ID24                 :1;
            __IO  uint32_t  ID25                 :1;
            __IO  uint32_t  ID26                 :1;
            __IO  uint32_t  ID27                 :1;
            __IO  uint32_t  ID28                 :1;
            __IO  uint32_t  RESERVED0            :3;
        };
    };
} stc_can_if1arb_field_t;

typedef struct stc_can_if1mctr_field
{
    union {
        struct {
            __IO  uint16_t  DLC                  :4;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  EOB                  :1;
            __IO  uint16_t  TXRQST               :1;
            __IO  uint16_t  RMTEN                :1;
            __IO  uint16_t  RXIE                 :1;
            __IO  uint16_t  TXIE                 :1;
            __IO  uint16_t  UMASK                :1;
            __IO  uint16_t  INTPND               :1;
            __IO  uint16_t  MSGLST               :1;
            __IO  uint16_t  NEWDAT               :1;
        };
        struct {
            __IO  uint16_t  DLC0                 :1;
            __IO  uint16_t  DLC1                 :1;
            __IO  uint16_t  DLC2                 :1;
            __IO  uint16_t  DLC3                 :1;
            __IO  uint16_t  RESERVED1            :12;
        };
    };
} stc_can_if1mctr_field_t;

typedef struct stc_can_if1dta_l_field
{
    union {
        struct {
            __IO  uint32_t  DATA0                :8;
            __IO  uint32_t  DATA1                :8;
            __IO  uint32_t  DATA2                :8;
            __IO  uint32_t  DATA3                :8;
        };
        struct {
            __IO  uint32_t  DATA00               :1;
            __IO  uint32_t  DATA01               :1;
            __IO  uint32_t  DATA02               :1;
            __IO  uint32_t  DATA03               :1;
            __IO  uint32_t  DATA04               :1;
            __IO  uint32_t  DATA05               :1;
            __IO  uint32_t  DATA06               :1;
            __IO  uint32_t  DATA07               :1;
            __IO  uint32_t  DATA10               :1;
            __IO  uint32_t  DATA11               :1;
            __IO  uint32_t  DATA12               :1;
            __IO  uint32_t  DATA13               :1;
            __IO  uint32_t  DATA14               :1;
            __IO  uint32_t  DATA15               :1;
            __IO  uint32_t  DATA16               :1;
            __IO  uint32_t  DATA17               :1;
            __IO  uint32_t  DATA20               :1;
            __IO  uint32_t  DATA21               :1;
            __IO  uint32_t  DATA22               :1;
            __IO  uint32_t  DATA23               :1;
            __IO  uint32_t  DATA24               :1;
            __IO  uint32_t  DATA25               :1;
            __IO  uint32_t  DATA26               :1;
            __IO  uint32_t  DATA27               :1;
            __IO  uint32_t  DATA30               :1;
            __IO  uint32_t  DATA31               :1;
            __IO  uint32_t  DATA32               :1;
            __IO  uint32_t  DATA33               :1;
            __IO  uint32_t  DATA34               :1;
            __IO  uint32_t  DATA35               :1;
            __IO  uint32_t  DATA36               :1;
            __IO  uint32_t  DATA37               :1;
        };
    };
} stc_can_if1dta_l_field_t;

typedef struct stc_can_if1dtb_l_field
{
    union {
        struct {
            __IO  uint32_t  DATA4                :8;
            __IO  uint32_t  DATA5                :8;
            __IO  uint32_t  DATA6                :8;
            __IO  uint32_t  DATA7                :8;
        };
        struct {
            __IO  uint32_t  DATA40               :1;
            __IO  uint32_t  DATA41               :1;
            __IO  uint32_t  DATA42               :1;
            __IO  uint32_t  DATA43               :1;
            __IO  uint32_t  DATA44               :1;
            __IO  uint32_t  DATA45               :1;
            __IO  uint32_t  DATA46               :1;
            __IO  uint32_t  DATA47               :1;
            __IO  uint32_t  DATA50               :1;
            __IO  uint32_t  DATA51               :1;
            __IO  uint32_t  DATA52               :1;
            __IO  uint32_t  DATA53               :1;
            __IO  uint32_t  DATA54               :1;
            __IO  uint32_t  DATA55               :1;
            __IO  uint32_t  DATA56               :1;
            __IO  uint32_t  DATA57               :1;
            __IO  uint32_t  DATA60               :1;
            __IO  uint32_t  DATA61               :1;
            __IO  uint32_t  DATA62               :1;
            __IO  uint32_t  DATA63               :1;
            __IO  uint32_t  DATA64               :1;
            __IO  uint32_t  DATA65               :1;
            __IO  uint32_t  DATA66               :1;
            __IO  uint32_t  DATA67               :1;
            __IO  uint32_t  DATA70               :1;
            __IO  uint32_t  DATA71               :1;
            __IO  uint32_t  DATA72               :1;
            __IO  uint32_t  DATA73               :1;
            __IO  uint32_t  DATA74               :1;
            __IO  uint32_t  DATA75               :1;
            __IO  uint32_t  DATA76               :1;
            __IO  uint32_t  DATA77               :1;
        };
    };
} stc_can_if1dtb_l_field_t;

typedef struct stc_can_if1dta_b_field
{
    union {
        struct {
            __IO  uint32_t  DATA3                :8;
            __IO  uint32_t  DATA2                :8;
            __IO  uint32_t  DATA1                :8;
            __IO  uint32_t  DATA0                :8;
        };
        struct {
            __IO  uint32_t  DATA30               :1;
            __IO  uint32_t  DATA31               :1;
            __IO  uint32_t  DATA32               :1;
            __IO  uint32_t  DATA33               :1;
            __IO  uint32_t  DATA34               :1;
            __IO  uint32_t  DATA35               :1;
            __IO  uint32_t  DATA36               :1;
            __IO  uint32_t  DATA37               :1;
            __IO  uint32_t  DATA20               :1;
            __IO  uint32_t  DATA21               :1;
            __IO  uint32_t  DATA22               :1;
            __IO  uint32_t  DATA23               :1;
            __IO  uint32_t  DATA24               :1;
            __IO  uint32_t  DATA25               :1;
            __IO  uint32_t  DATA26               :1;
            __IO  uint32_t  DATA27               :1;
            __IO  uint32_t  DATA10               :1;
            __IO  uint32_t  DATA11               :1;
            __IO  uint32_t  DATA12               :1;
            __IO  uint32_t  DATA13               :1;
            __IO  uint32_t  DATA14               :1;
            __IO  uint32_t  DATA15               :1;
            __IO  uint32_t  DATA16               :1;
            __IO  uint32_t  DATA17               :1;
            __IO  uint32_t  DATA00               :1;
            __IO  uint32_t  DATA01               :1;
            __IO  uint32_t  DATA02               :1;
            __IO  uint32_t  DATA03               :1;
            __IO  uint32_t  DATA04               :1;
            __IO  uint32_t  DATA05               :1;
            __IO  uint32_t  DATA06               :1;
            __IO  uint32_t  DATA07               :1;
        };
    };
} stc_can_if1dta_b_field_t;

typedef struct stc_can_if1dtb_b_field
{
    union {
        struct {
            __IO  uint32_t  DATA7                :8;
            __IO  uint32_t  DATA6                :8;
            __IO  uint32_t  DATA5                :8;
            __IO  uint32_t  DATA4                :8;
        };
        struct {
            __IO  uint32_t  DATA70               :1;
            __IO  uint32_t  DATA71               :1;
            __IO  uint32_t  DATA72               :1;
            __IO  uint32_t  DATA73               :1;
            __IO  uint32_t  DATA74               :1;
            __IO  uint32_t  DATA75               :1;
            __IO  uint32_t  DATA76               :1;
            __IO  uint32_t  DATA77               :1;
            __IO  uint32_t  DATA60               :1;
            __IO  uint32_t  DATA61               :1;
            __IO  uint32_t  DATA62               :1;
            __IO  uint32_t  DATA63               :1;
            __IO  uint32_t  DATA64               :1;
            __IO  uint32_t  DATA65               :1;
            __IO  uint32_t  DATA66               :1;
            __IO  uint32_t  DATA67               :1;
            __IO  uint32_t  DATA50               :1;
            __IO  uint32_t  DATA51               :1;
            __IO  uint32_t  DATA52               :1;
            __IO  uint32_t  DATA53               :1;
            __IO  uint32_t  DATA54               :1;
            __IO  uint32_t  DATA55               :1;
            __IO  uint32_t  DATA56               :1;
            __IO  uint32_t  DATA57               :1;
            __IO  uint32_t  DATA40               :1;
            __IO  uint32_t  DATA41               :1;
            __IO  uint32_t  DATA42               :1;
            __IO  uint32_t  DATA43               :1;
            __IO  uint32_t  DATA44               :1;
            __IO  uint32_t  DATA45               :1;
            __IO  uint32_t  DATA46               :1;
            __IO  uint32_t  DATA47               :1;
        };
    };
} stc_can_if1dtb_b_field_t;

typedef struct stc_can_if2creq_field
{
    union {
        struct {
            __IO  uint16_t  MESSAGENUMBER        :8;
            __IO  uint16_t  RESERVED0            :7;
            __IO  uint16_t  BUSY                 :1;
        };
        struct {
            __IO  uint16_t  MESSAGENUMBER0       :1;
            __IO  uint16_t  MESSAGENUMBER1       :1;
            __IO  uint16_t  MESSAGENUMBER2       :1;
            __IO  uint16_t  MESSAGENUMBER3       :1;
            __IO  uint16_t  MESSAGENUMBER4       :1;
            __IO  uint16_t  MESSAGENUMBER5       :1;
            __IO  uint16_t  MESSAGENUMBER6       :1;
            __IO  uint16_t  MESSAGENUMBER7       :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_can_if2creq_field_t;

typedef struct stc_can_if2cmsk_field
{
        __IO  uint16_t  DATAB                    :1;
        __IO  uint16_t  DATAA                    :1;
        __IO  uint16_t  NEWDAT                   :1;
        __IO  uint16_t  CIP                      :1;
        __IO  uint16_t  CONTROL                  :1;
        __IO  uint16_t  ARB                      :1;
        __IO  uint16_t  MASK                     :1;
        __IO  uint16_t  WR_RD                    :1;
        __IO  uint16_t  RESERVED0                :8;
} stc_can_if2cmsk_field_t;

typedef struct stc_can_if2msk_field
{
    union {
        struct {
            __IO  uint32_t  MSK                  :29;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  MDIR                 :1;
            __IO  uint32_t  MXTD                 :1;
        };
        struct {
            __IO  uint32_t  MSK0                 :1;
            __IO  uint32_t  MSK1                 :1;
            __IO  uint32_t  MSK2                 :1;
            __IO  uint32_t  MSK3                 :1;
            __IO  uint32_t  MSK4                 :1;
            __IO  uint32_t  MSK5                 :1;
            __IO  uint32_t  MSK6                 :1;
            __IO  uint32_t  MSK7                 :1;
            __IO  uint32_t  MSK8                 :1;
            __IO  uint32_t  MSK9                 :1;
            __IO  uint32_t  MSK10                :1;
            __IO  uint32_t  MSK11                :1;
            __IO  uint32_t  MSK12                :1;
            __IO  uint32_t  MSK13                :1;
            __IO  uint32_t  MSK14                :1;
            __IO  uint32_t  MSK15                :1;
            __IO  uint32_t  MSK16                :1;
            __IO  uint32_t  MSK17                :1;
            __IO  uint32_t  MSK18                :1;
            __IO  uint32_t  MSK19                :1;
            __IO  uint32_t  MSK20                :1;
            __IO  uint32_t  MSK21                :1;
            __IO  uint32_t  MSK22                :1;
            __IO  uint32_t  MSK23                :1;
            __IO  uint32_t  MSK24                :1;
            __IO  uint32_t  MSK25                :1;
            __IO  uint32_t  MSK26                :1;
            __IO  uint32_t  MSK27                :1;
            __IO  uint32_t  MSK28                :1;
            __IO  uint32_t  RESERVED1            :3;
        };
    };
} stc_can_if2msk_field_t;

typedef struct stc_can_if2arb_field
{
    union {
        struct {
            __IO  uint32_t  ID                   :29;
            __IO  uint32_t  DIR                  :1;
            __IO  uint32_t  XTD                  :1;
            __IO  uint32_t  MSGVAL               :1;
        };
        struct {
            __IO  uint32_t  ID0                  :1;
            __IO  uint32_t  ID1                  :1;
            __IO  uint32_t  ID2                  :1;
            __IO  uint32_t  ID3                  :1;
            __IO  uint32_t  ID4                  :1;
            __IO  uint32_t  ID5                  :1;
            __IO  uint32_t  ID6                  :1;
            __IO  uint32_t  ID7                  :1;
            __IO  uint32_t  ID8                  :1;
            __IO  uint32_t  ID9                  :1;
            __IO  uint32_t  ID10                 :1;
            __IO  uint32_t  ID11                 :1;
            __IO  uint32_t  ID12                 :1;
            __IO  uint32_t  ID13                 :1;
            __IO  uint32_t  ID14                 :1;
            __IO  uint32_t  ID15                 :1;
            __IO  uint32_t  ID16                 :1;
            __IO  uint32_t  ID17                 :1;
            __IO  uint32_t  ID18                 :1;
            __IO  uint32_t  ID19                 :1;
            __IO  uint32_t  ID20                 :1;
            __IO  uint32_t  ID21                 :1;
            __IO  uint32_t  ID22                 :1;
            __IO  uint32_t  ID23                 :1;
            __IO  uint32_t  ID24                 :1;
            __IO  uint32_t  ID25                 :1;
            __IO  uint32_t  ID26                 :1;
            __IO  uint32_t  ID27                 :1;
            __IO  uint32_t  ID28                 :1;
            __IO  uint32_t  RESERVED0            :3;
        };
    };
} stc_can_if2arb_field_t;

typedef struct stc_can_if2mctr_field
{
    union {
        struct {
            __IO  uint16_t  DLC                  :4;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  EOB                  :1;
            __IO  uint16_t  TXRQST               :1;
            __IO  uint16_t  RMTEN                :1;
            __IO  uint16_t  RXIE                 :1;
            __IO  uint16_t  TXIE                 :1;
            __IO  uint16_t  UMASK                :1;
            __IO  uint16_t  INTPND               :1;
            __IO  uint16_t  MSGLST               :1;
            __IO  uint16_t  NEWDAT               :1;
        };
        struct {
            __IO  uint16_t  DLC0                 :1;
            __IO  uint16_t  DLC1                 :1;
            __IO  uint16_t  DLC2                 :1;
            __IO  uint16_t  DLC3                 :1;
            __IO  uint16_t  RESERVED1            :12;
        };
    };
} stc_can_if2mctr_field_t;

typedef struct stc_can_if2dta_l_field
{
    union {
        struct {
            __IO  uint32_t  DATA0                :8;
            __IO  uint32_t  DATA1                :8;
            __IO  uint32_t  DATA2                :8;
            __IO  uint32_t  DATA3                :8;
        };
        struct {
            __IO  uint32_t  DATA00               :1;
            __IO  uint32_t  DATA01               :1;
            __IO  uint32_t  DATA02               :1;
            __IO  uint32_t  DATA03               :1;
            __IO  uint32_t  DATA04               :1;
            __IO  uint32_t  DATA05               :1;
            __IO  uint32_t  DATA06               :1;
            __IO  uint32_t  DATA07               :1;
            __IO  uint32_t  DATA10               :1;
            __IO  uint32_t  DATA11               :1;
            __IO  uint32_t  DATA12               :1;
            __IO  uint32_t  DATA13               :1;
            __IO  uint32_t  DATA14               :1;
            __IO  uint32_t  DATA15               :1;
            __IO  uint32_t  DATA16               :1;
            __IO  uint32_t  DATA17               :1;
            __IO  uint32_t  DATA20               :1;
            __IO  uint32_t  DATA21               :1;
            __IO  uint32_t  DATA22               :1;
            __IO  uint32_t  DATA23               :1;
            __IO  uint32_t  DATA24               :1;
            __IO  uint32_t  DATA25               :1;
            __IO  uint32_t  DATA26               :1;
            __IO  uint32_t  DATA27               :1;
            __IO  uint32_t  DATA30               :1;
            __IO  uint32_t  DATA31               :1;
            __IO  uint32_t  DATA32               :1;
            __IO  uint32_t  DATA33               :1;
            __IO  uint32_t  DATA34               :1;
            __IO  uint32_t  DATA35               :1;
            __IO  uint32_t  DATA36               :1;
            __IO  uint32_t  DATA37               :1;
        };
    };
} stc_can_if2dta_l_field_t;

typedef struct stc_can_if2dtb_l_field
{
    union {
        struct {
            __IO  uint32_t  DATA4                :8;
            __IO  uint32_t  DATA5                :8;
            __IO  uint32_t  DATA6                :8;
            __IO  uint32_t  DATA7                :8;
        };
        struct {
            __IO  uint32_t  DATA40               :1;
            __IO  uint32_t  DATA41               :1;
            __IO  uint32_t  DATA42               :1;
            __IO  uint32_t  DATA43               :1;
            __IO  uint32_t  DATA44               :1;
            __IO  uint32_t  DATA45               :1;
            __IO  uint32_t  DATA46               :1;
            __IO  uint32_t  DATA47               :1;
            __IO  uint32_t  DATA50               :1;
            __IO  uint32_t  DATA51               :1;
            __IO  uint32_t  DATA52               :1;
            __IO  uint32_t  DATA53               :1;
            __IO  uint32_t  DATA54               :1;
            __IO  uint32_t  DATA55               :1;
            __IO  uint32_t  DATA56               :1;
            __IO  uint32_t  DATA57               :1;
            __IO  uint32_t  DATA60               :1;
            __IO  uint32_t  DATA61               :1;
            __IO  uint32_t  DATA62               :1;
            __IO  uint32_t  DATA63               :1;
            __IO  uint32_t  DATA64               :1;
            __IO  uint32_t  DATA65               :1;
            __IO  uint32_t  DATA66               :1;
            __IO  uint32_t  DATA67               :1;
            __IO  uint32_t  DATA70               :1;
            __IO  uint32_t  DATA71               :1;
            __IO  uint32_t  DATA72               :1;
            __IO  uint32_t  DATA73               :1;
            __IO  uint32_t  DATA74               :1;
            __IO  uint32_t  DATA75               :1;
            __IO  uint32_t  DATA76               :1;
            __IO  uint32_t  DATA77               :1;
        };
    };
} stc_can_if2dtb_l_field_t;

typedef struct stc_can_if2dta_b_field
{
    union {
        struct {
            __IO  uint32_t  DATA3                :8;
            __IO  uint32_t  DATA2                :8;
            __IO  uint32_t  DATA1                :8;
            __IO  uint32_t  DATA0                :8;
        };
        struct {
            __IO  uint32_t  DATA30               :1;
            __IO  uint32_t  DATA31               :1;
            __IO  uint32_t  DATA32               :1;
            __IO  uint32_t  DATA33               :1;
            __IO  uint32_t  DATA34               :1;
            __IO  uint32_t  DATA35               :1;
            __IO  uint32_t  DATA36               :1;
            __IO  uint32_t  DATA37               :1;
            __IO  uint32_t  DATA20               :1;
            __IO  uint32_t  DATA21               :1;
            __IO  uint32_t  DATA22               :1;
            __IO  uint32_t  DATA23               :1;
            __IO  uint32_t  DATA24               :1;
            __IO  uint32_t  DATA25               :1;
            __IO  uint32_t  DATA26               :1;
            __IO  uint32_t  DATA27               :1;
            __IO  uint32_t  DATA10               :1;
            __IO  uint32_t  DATA11               :1;
            __IO  uint32_t  DATA12               :1;
            __IO  uint32_t  DATA13               :1;
            __IO  uint32_t  DATA14               :1;
            __IO  uint32_t  DATA15               :1;
            __IO  uint32_t  DATA16               :1;
            __IO  uint32_t  DATA17               :1;
            __IO  uint32_t  DATA00               :1;
            __IO  uint32_t  DATA01               :1;
            __IO  uint32_t  DATA02               :1;
            __IO  uint32_t  DATA03               :1;
            __IO  uint32_t  DATA04               :1;
            __IO  uint32_t  DATA05               :1;
            __IO  uint32_t  DATA06               :1;
            __IO  uint32_t  DATA07               :1;
        };
    };
} stc_can_if2dta_b_field_t;

typedef struct stc_can_if2dtb_b_field
{
    union {
        struct {
            __IO  uint32_t  DATA7                :8;
            __IO  uint32_t  DATA6                :8;
            __IO  uint32_t  DATA5                :8;
            __IO  uint32_t  DATA4                :8;
        };
        struct {
            __IO  uint32_t  DATA70               :1;
            __IO  uint32_t  DATA71               :1;
            __IO  uint32_t  DATA72               :1;
            __IO  uint32_t  DATA73               :1;
            __IO  uint32_t  DATA74               :1;
            __IO  uint32_t  DATA75               :1;
            __IO  uint32_t  DATA76               :1;
            __IO  uint32_t  DATA77               :1;
            __IO  uint32_t  DATA60               :1;
            __IO  uint32_t  DATA61               :1;
            __IO  uint32_t  DATA62               :1;
            __IO  uint32_t  DATA63               :1;
            __IO  uint32_t  DATA64               :1;
            __IO  uint32_t  DATA65               :1;
            __IO  uint32_t  DATA66               :1;
            __IO  uint32_t  DATA67               :1;
            __IO  uint32_t  DATA50               :1;
            __IO  uint32_t  DATA51               :1;
            __IO  uint32_t  DATA52               :1;
            __IO  uint32_t  DATA53               :1;
            __IO  uint32_t  DATA54               :1;
            __IO  uint32_t  DATA55               :1;
            __IO  uint32_t  DATA56               :1;
            __IO  uint32_t  DATA57               :1;
            __IO  uint32_t  DATA40               :1;
            __IO  uint32_t  DATA41               :1;
            __IO  uint32_t  DATA42               :1;
            __IO  uint32_t  DATA43               :1;
            __IO  uint32_t  DATA44               :1;
            __IO  uint32_t  DATA45               :1;
            __IO  uint32_t  DATA46               :1;
            __IO  uint32_t  DATA47               :1;
        };
    };
} stc_can_if2dtb_b_field_t;

typedef struct stc_can_treqr_field
{
        __IO  uint32_t  TXRQST1                  :1;
        __IO  uint32_t  TXRQST2                  :1;
        __IO  uint32_t  TXRQST3                  :1;
        __IO  uint32_t  TXRQST4                  :1;
        __IO  uint32_t  TXRQST5                  :1;
        __IO  uint32_t  TXRQST6                  :1;
        __IO  uint32_t  TXRQST7                  :1;
        __IO  uint32_t  TXRQST8                  :1;
        __IO  uint32_t  TXRQST9                  :1;
        __IO  uint32_t  TXRQST10                 :1;
        __IO  uint32_t  TXRQST11                 :1;
        __IO  uint32_t  TXRQST12                 :1;
        __IO  uint32_t  TXRQST13                 :1;
        __IO  uint32_t  TXRQST14                 :1;
        __IO  uint32_t  TXRQST15                 :1;
        __IO  uint32_t  TXRQST16                 :1;
        __IO  uint32_t  TXRQST17                 :1;
        __IO  uint32_t  TXRQST18                 :1;
        __IO  uint32_t  TXRQST19                 :1;
        __IO  uint32_t  TXRQST20                 :1;
        __IO  uint32_t  TXRQST21                 :1;
        __IO  uint32_t  TXRQST22                 :1;
        __IO  uint32_t  TXRQST23                 :1;
        __IO  uint32_t  TXRQST24                 :1;
        __IO  uint32_t  TXRQST25                 :1;
        __IO  uint32_t  TXRQST26                 :1;
        __IO  uint32_t  TXRQST27                 :1;
        __IO  uint32_t  TXRQST28                 :1;
        __IO  uint32_t  TXRQST29                 :1;
        __IO  uint32_t  TXRQST30                 :1;
        __IO  uint32_t  TXRQST31                 :1;
        __IO  uint32_t  TXRQST32                 :1;
} stc_can_treqr_field_t;

typedef struct stc_can_newdt_field
{
        __IO  uint32_t  NEWDAT1                  :1;
        __IO  uint32_t  NEWDAT2                  :1;
        __IO  uint32_t  NEWDAT3                  :1;
        __IO  uint32_t  NEWDAT4                  :1;
        __IO  uint32_t  NEWDAT5                  :1;
        __IO  uint32_t  NEWDAT6                  :1;
        __IO  uint32_t  NEWDAT7                  :1;
        __IO  uint32_t  NEWDAT8                  :1;
        __IO  uint32_t  NEWDAT9                  :1;
        __IO  uint32_t  NEWDAT10                 :1;
        __IO  uint32_t  NEWDAT11                 :1;
        __IO  uint32_t  NEWDAT12                 :1;
        __IO  uint32_t  NEWDAT13                 :1;
        __IO  uint32_t  NEWDAT14                 :1;
        __IO  uint32_t  NEWDAT15                 :1;
        __IO  uint32_t  NEWDAT16                 :1;
        __IO  uint32_t  NEWDAT17                 :1;
        __IO  uint32_t  NEWDAT18                 :1;
        __IO  uint32_t  NEWDAT19                 :1;
        __IO  uint32_t  NEWDAT20                 :1;
        __IO  uint32_t  NEWDAT21                 :1;
        __IO  uint32_t  NEWDAT22                 :1;
        __IO  uint32_t  NEWDAT23                 :1;
        __IO  uint32_t  NEWDAT24                 :1;
        __IO  uint32_t  NEWDAT25                 :1;
        __IO  uint32_t  NEWDAT26                 :1;
        __IO  uint32_t  NEWDAT27                 :1;
        __IO  uint32_t  NEWDAT28                 :1;
        __IO  uint32_t  NEWDAT29                 :1;
        __IO  uint32_t  NEWDAT30                 :1;
        __IO  uint32_t  NEWDAT31                 :1;
        __IO  uint32_t  NEWDAT32                 :1;
} stc_can_newdt_field_t;

typedef struct stc_can_intpnd_field
{
        __IO  uint32_t  INTPND1                  :1;
        __IO  uint32_t  INTPND2                  :1;
        __IO  uint32_t  INTPND3                  :1;
        __IO  uint32_t  INTPND4                  :1;
        __IO  uint32_t  INTPND5                  :1;
        __IO  uint32_t  INTPND6                  :1;
        __IO  uint32_t  INTPND7                  :1;
        __IO  uint32_t  INTPND8                  :1;
        __IO  uint32_t  INTPND9                  :1;
        __IO  uint32_t  INTPND10                 :1;
        __IO  uint32_t  INTPND11                 :1;
        __IO  uint32_t  INTPND12                 :1;
        __IO  uint32_t  INTPND13                 :1;
        __IO  uint32_t  INTPND14                 :1;
        __IO  uint32_t  INTPND15                 :1;
        __IO  uint32_t  INTPND16                 :1;
        __IO  uint32_t  INTPND17                 :1;
        __IO  uint32_t  INTPND18                 :1;
        __IO  uint32_t  INTPND19                 :1;
        __IO  uint32_t  INTPND20                 :1;
        __IO  uint32_t  INTPND21                 :1;
        __IO  uint32_t  INTPND22                 :1;
        __IO  uint32_t  INTPND23                 :1;
        __IO  uint32_t  INTPND24                 :1;
        __IO  uint32_t  INTPND25                 :1;
        __IO  uint32_t  INTPND26                 :1;
        __IO  uint32_t  INTPND27                 :1;
        __IO  uint32_t  INTPND28                 :1;
        __IO  uint32_t  INTPND29                 :1;
        __IO  uint32_t  INTPND30                 :1;
        __IO  uint32_t  INTPND31                 :1;
        __IO  uint32_t  INTPND32                 :1;
} stc_can_intpnd_field_t;

typedef struct stc_can_msgval_field
{
        __IO  uint32_t  MSGVAL1                  :1;
        __IO  uint32_t  MSGVAL2                  :1;
        __IO  uint32_t  MSGVAL3                  :1;
        __IO  uint32_t  MSGVAL4                  :1;
        __IO  uint32_t  MSGVAL5                  :1;
        __IO  uint32_t  MSGVAL6                  :1;
        __IO  uint32_t  MSGVAL7                  :1;
        __IO  uint32_t  MSGVAL8                  :1;
        __IO  uint32_t  MSGVAL9                  :1;
        __IO  uint32_t  MSGVAL10                 :1;
        __IO  uint32_t  MSGVAL11                 :1;
        __IO  uint32_t  MSGVAL12                 :1;
        __IO  uint32_t  MSGVAL13                 :1;
        __IO  uint32_t  MSGVAL14                 :1;
        __IO  uint32_t  MSGVAL15                 :1;
        __IO  uint32_t  MSGVAL16                 :1;
        __IO  uint32_t  MSGVAL17                 :1;
        __IO  uint32_t  MSGVAL18                 :1;
        __IO  uint32_t  MSGVAL19                 :1;
        __IO  uint32_t  MSGVAL20                 :1;
        __IO  uint32_t  MSGVAL21                 :1;
        __IO  uint32_t  MSGVAL22                 :1;
        __IO  uint32_t  MSGVAL23                 :1;
        __IO  uint32_t  MSGVAL24                 :1;
        __IO  uint32_t  MSGVAL25                 :1;
        __IO  uint32_t  MSGVAL26                 :1;
        __IO  uint32_t  MSGVAL27                 :1;
        __IO  uint32_t  MSGVAL28                 :1;
        __IO  uint32_t  MSGVAL29                 :1;
        __IO  uint32_t  MSGVAL30                 :1;
        __IO  uint32_t  MSGVAL31                 :1;
        __IO  uint32_t  MSGVAL32                 :1;
} stc_can_msgval_field_t;

/******************************************************************************
 ** CANPRES_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_canpres_canpre_field
{
    union {
        struct {
            __IO   uint8_t  CANPRE               :4;
            __IO   uint8_t  RESERVED0            :4;
        };
        struct {
            __IO   uint8_t  CANPRE0              :1;
            __IO   uint8_t  CANPRE1              :1;
            __IO   uint8_t  CANPRE2              :1;
            __IO   uint8_t  CANPRE3              :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_canpres_canpre_field_t;

/******************************************************************************
 ** CLK_GATING_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_clk_gating_cken0_field
{
        __IO  uint32_t  MFSCK0                   :1;
        __IO  uint32_t  MFSCK1                   :1;
        __IO  uint32_t  MFSCK2                   :1;
        __IO  uint32_t  MFSCK3                   :1;
        __IO  uint32_t  MFSCK4                   :1;
        __IO  uint32_t  MFSCK5                   :1;
        __IO  uint32_t  MFSCK6                   :1;
        __IO  uint32_t  MFSCK7                   :1;
        __IO  uint32_t  MFSCK8                   :1;
        __IO  uint32_t  MFSCK9                   :1;
        __IO  uint32_t  MFSCK10                  :1;
        __IO  uint32_t  MFSCK11                  :1;
        __IO  uint32_t  MFSCK12                  :1;
        __IO  uint32_t  MFSCK13                  :1;
        __IO  uint32_t  MFSCK14                  :1;
        __IO  uint32_t  MFSCK15                  :1;
        __IO  uint32_t  ADCCK0                   :1;
        __IO  uint32_t  ADCCK1                   :1;
        __IO  uint32_t  ADCCK2                   :1;
        __IO  uint32_t  ADCCK3                   :1;
        __IO  uint32_t  RESERVED0                :4;
        __IO  uint32_t  DMACK                    :1;
        __IO  uint32_t  RESERVED1                :1;
        __IO  uint32_t  EXBCK                    :1;
        __IO  uint32_t  RESERVED2                :1;
        __IO  uint32_t  GIOCK                    :1;
        __IO  uint32_t  RESERVED3                :3;
} stc_clk_gating_cken0_field_t;

typedef struct stc_clk_gating_mrst0_field
{
        __IO  uint32_t  MFSRST0                  :1;
        __IO  uint32_t  MFSRST1                  :1;
        __IO  uint32_t  MFSRST2                  :1;
        __IO  uint32_t  MFSRST3                  :1;
        __IO  uint32_t  MFSRST4                  :1;
        __IO  uint32_t  MFSRST5                  :1;
        __IO  uint32_t  MFSRST6                  :1;
        __IO  uint32_t  MFSRST7                  :1;
        __IO  uint32_t  MFSRST8                  :1;
        __IO  uint32_t  MFSRST9                  :1;
        __IO  uint32_t  MFSRST10                 :1;
        __IO  uint32_t  MFSRST11                 :1;
        __IO  uint32_t  MFSRST12                 :1;
        __IO  uint32_t  MFSRST13                 :1;
        __IO  uint32_t  MFSRST14                 :1;
        __IO  uint32_t  MFSRST15                 :1;
        __IO  uint32_t  ADCRST0                  :1;
        __IO  uint32_t  ADCRST1                  :1;
        __IO  uint32_t  ADCRST2                  :1;
        __IO  uint32_t  ADCRST3                  :1;
        __IO  uint32_t  RESERVED0                :4;
        __IO  uint32_t  DMARST                   :1;
        __IO  uint32_t  RESERVED1                :1;
        __IO  uint32_t  EXBRST                   :1;
        __IO  uint32_t  RESERVED2                :5;
} stc_clk_gating_mrst0_field_t;

typedef struct stc_clk_gating_cken1_field
{
        __IO  uint32_t  BTMCK0                   :1;
        __IO  uint32_t  BTMCK1                   :1;
        __IO  uint32_t  BTMCK2                   :1;
        __IO  uint32_t  BTMCK3                   :1;
        __IO  uint32_t  RESERVED0                :4;
        __IO  uint32_t  MFTCK0                   :1;
        __IO  uint32_t  MFTCK1                   :1;
        __IO  uint32_t  MFTCK2                   :1;
        __IO  uint32_t  MFTCK3                   :1;
        __IO  uint32_t  RESERVED1                :4;
        __IO  uint32_t  QDUCK0                   :1;
        __IO  uint32_t  QDUCK1                   :1;
        __IO  uint32_t  QDUCK2                   :1;
        __IO  uint32_t  QDUCK3                   :1;
        __IO  uint32_t  RESERVED2                :12;
} stc_clk_gating_cken1_field_t;

typedef struct stc_clk_gating_mrst1_field
{
        __IO  uint32_t  BTMRST0                  :1;
        __IO  uint32_t  BTMRST1                  :1;
        __IO  uint32_t  BTMRST2                  :1;
        __IO  uint32_t  BTMRST3                  :1;
        __IO  uint32_t  RESERVED0                :4;
        __IO  uint32_t  MFTRST0                  :1;
        __IO  uint32_t  MFTRST1                  :1;
        __IO  uint32_t  MFTRST2                  :1;
        __IO  uint32_t  MFTRST3                  :1;
        __IO  uint32_t  RESERVED1                :4;
        __IO  uint32_t  QDURST0                  :1;
        __IO  uint32_t  QDURST1                  :1;
        __IO  uint32_t  QDURST2                  :1;
        __IO  uint32_t  QDURST3                  :1;
        __IO  uint32_t  RESERVED2                :12;
} stc_clk_gating_mrst1_field_t;

typedef struct stc_clk_gating_cken2_field
{
        __IO  uint32_t  USBCK0                   :1;
        __IO  uint32_t  USBCK1                   :1;
        __IO  uint32_t  RESERVED0                :2;
        __IO  uint32_t  CANCK0                   :1;
        __IO  uint32_t  CANCK1                   :1;
        __IO  uint32_t  CANCK2                   :1;
        __IO  uint32_t  RESERVED1                :1;
        __IO  uint32_t  SDCCK                    :1;
        __IO  uint32_t  RESERVED2                :3;
        __IO  uint32_t  ICCCK0                   :1;
        __IO  uint32_t  ICCCK1                   :1;
        __IO  uint32_t  IISCCK0                  :1;
        __IO  uint32_t  IISCCK1                  :1;
        __IO  uint32_t  I2SCK0                   :1;
        __IO  uint32_t  I2SCK1                   :1;
        __IO  uint32_t  RESERVED3                :2;
        __IO  uint32_t  PCRCCK                   :1;
        __IO  uint32_t  RESERVED4                :3;
        __IO  uint32_t  CECCK0                   :1;
        __IO  uint32_t  CECCK1                   :1;
        __IO  uint32_t  RESERVED5                :2;
        __IO  uint32_t  HSSPICK                  :1;
        __IO  uint32_t  RESERVED6                :3;
} stc_clk_gating_cken2_field_t;

typedef struct stc_clk_gating_mrst2_field
{
        __IO  uint32_t  USBRST0                  :1;
        __IO  uint32_t  USBRST1                  :1;
        __IO  uint32_t  RESERVED0                :2;
        __IO  uint32_t  CANRST0                  :1;
        __IO  uint32_t  CANRST1                  :1;
        __IO  uint32_t  CANRST2                  :1;
        __IO  uint32_t  RESERVED1                :1;
        __IO  uint32_t  SDCRST                   :1;
        __IO  uint32_t  RESERVED2                :3;
        __IO  uint32_t  ICCRST0                  :1;
        __IO  uint32_t  ICCRST1                  :1;
        __IO  uint32_t  IISCRST0                 :1;
        __IO  uint32_t  IISCRST1                 :1;
        __IO  uint32_t  I2SRST0                  :1;
        __IO  uint32_t  I2SRST1                  :1;
        __IO  uint32_t  RESERVED3                :2;
        __IO  uint32_t  PCRCRST                  :1;
        __IO  uint32_t  RESERVED4                :3;
        __IO  uint32_t  CECRST0                  :1;
        __IO  uint32_t  CECRST1                  :1;
        __IO  uint32_t  RESERVED5                :2;
        __IO  uint32_t  HSSPIRST                 :1;
        __IO  uint32_t  RESERVED6                :3;
} stc_clk_gating_mrst2_field_t;

/******************************************************************************
 ** CRC_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_crc_crccr_field
{
        __IO   uint8_t  INIT                     :1;
        __IO   uint8_t  CRC32                    :1;
        __IO   uint8_t  LTLEND                   :1;
        __IO   uint8_t  LSBFST                   :1;
        __IO   uint8_t  CRCLTE                   :1;
        __IO   uint8_t  CRCLSF                   :1;
        __IO   uint8_t  FXOR                     :1;
        __IO   uint8_t  RESERVED0                :1;
} stc_crc_crccr_field_t;

typedef struct stc_crc_crcinit_field
{
    union {
        struct {
            __IO  uint32_t  D                    :32;
        };
        struct {
            __IO  uint32_t  D0                   :1;
            __IO  uint32_t  D1                   :1;
            __IO  uint32_t  D2                   :1;
            __IO  uint32_t  D3                   :1;
            __IO  uint32_t  D4                   :1;
            __IO  uint32_t  D5                   :1;
            __IO  uint32_t  D6                   :1;
            __IO  uint32_t  D7                   :1;
            __IO  uint32_t  D8                   :1;
            __IO  uint32_t  D9                   :1;
            __IO  uint32_t  D10                  :1;
            __IO  uint32_t  D11                  :1;
            __IO  uint32_t  D12                  :1;
            __IO  uint32_t  D13                  :1;
            __IO  uint32_t  D14                  :1;
            __IO  uint32_t  D15                  :1;
            __IO  uint32_t  D16                  :1;
            __IO  uint32_t  D17                  :1;
            __IO  uint32_t  D18                  :1;
            __IO  uint32_t  D19                  :1;
            __IO  uint32_t  D20                  :1;
            __IO  uint32_t  D21                  :1;
            __IO  uint32_t  D22                  :1;
            __IO  uint32_t  D23                  :1;
            __IO  uint32_t  D24                  :1;
            __IO  uint32_t  D25                  :1;
            __IO  uint32_t  D26                  :1;
            __IO  uint32_t  D27                  :1;
            __IO  uint32_t  D28                  :1;
            __IO  uint32_t  D29                  :1;
            __IO  uint32_t  D30                  :1;
            __IO  uint32_t  D31                  :1;
        };
    };
} stc_crc_crcinit_field_t;

typedef struct stc_crc_crcin_field
{
    union {
        struct {
            __IO  uint32_t  D                    :32;
        };
        struct {
            __IO  uint32_t  D0                   :1;
            __IO  uint32_t  D1                   :1;
            __IO  uint32_t  D2                   :1;
            __IO  uint32_t  D3                   :1;
            __IO  uint32_t  D4                   :1;
            __IO  uint32_t  D5                   :1;
            __IO  uint32_t  D6                   :1;
            __IO  uint32_t  D7                   :1;
            __IO  uint32_t  D8                   :1;
            __IO  uint32_t  D9                   :1;
            __IO  uint32_t  D10                  :1;
            __IO  uint32_t  D11                  :1;
            __IO  uint32_t  D12                  :1;
            __IO  uint32_t  D13                  :1;
            __IO  uint32_t  D14                  :1;
            __IO  uint32_t  D15                  :1;
            __IO  uint32_t  D16                  :1;
            __IO  uint32_t  D17                  :1;
            __IO  uint32_t  D18                  :1;
            __IO  uint32_t  D19                  :1;
            __IO  uint32_t  D20                  :1;
            __IO  uint32_t  D21                  :1;
            __IO  uint32_t  D22                  :1;
            __IO  uint32_t  D23                  :1;
            __IO  uint32_t  D24                  :1;
            __IO  uint32_t  D25                  :1;
            __IO  uint32_t  D26                  :1;
            __IO  uint32_t  D27                  :1;
            __IO  uint32_t  D28                  :1;
            __IO  uint32_t  D29                  :1;
            __IO  uint32_t  D30                  :1;
            __IO  uint32_t  D31                  :1;
        };
    };
} stc_crc_crcin_field_t;

typedef struct stc_crc_crcr_field
{
    union {
        struct {
            __IO  uint32_t  D                    :32;
        };
        struct {
            __IO  uint32_t  D0                   :1;
            __IO  uint32_t  D1                   :1;
            __IO  uint32_t  D2                   :1;
            __IO  uint32_t  D3                   :1;
            __IO  uint32_t  D4                   :1;
            __IO  uint32_t  D5                   :1;
            __IO  uint32_t  D6                   :1;
            __IO  uint32_t  D7                   :1;
            __IO  uint32_t  D8                   :1;
            __IO  uint32_t  D9                   :1;
            __IO  uint32_t  D10                  :1;
            __IO  uint32_t  D11                  :1;
            __IO  uint32_t  D12                  :1;
            __IO  uint32_t  D13                  :1;
            __IO  uint32_t  D14                  :1;
            __IO  uint32_t  D15                  :1;
            __IO  uint32_t  D16                  :1;
            __IO  uint32_t  D17                  :1;
            __IO  uint32_t  D18                  :1;
            __IO  uint32_t  D19                  :1;
            __IO  uint32_t  D20                  :1;
            __IO  uint32_t  D21                  :1;
            __IO  uint32_t  D22                  :1;
            __IO  uint32_t  D23                  :1;
            __IO  uint32_t  D24                  :1;
            __IO  uint32_t  D25                  :1;
            __IO  uint32_t  D26                  :1;
            __IO  uint32_t  D27                  :1;
            __IO  uint32_t  D28                  :1;
            __IO  uint32_t  D29                  :1;
            __IO  uint32_t  D30                  :1;
            __IO  uint32_t  D31                  :1;
        };
    };
} stc_crc_crcr_field_t;

/******************************************************************************
 ** CRG_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_crg_scm_ctl_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  MOSCE                :1;
            __IO  uint32_t  RESERVED1            :1;
            __IO  uint32_t  SOSCE                :1;
            __IO  uint32_t  PLLE                 :1;
            __IO  uint32_t  RCS                  :3;
            __IO  uint32_t  RESERVED3            :24;
        };
        struct {
            __IO  uint32_t  RESERVED2            :5;
            __IO  uint32_t  RCS0                 :1;
            __IO  uint32_t  RCS1                 :1;
            __IO  uint32_t  RCS2                 :1;
            __IO  uint32_t  RESERVED4            :24;
        };
    };
} stc_crg_scm_ctl_field_t;

typedef struct stc_crg_scm_str_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  MORDY                :1;
            __IO  uint32_t  RESERVED1            :1;
            __IO  uint32_t  SORDY                :1;
            __IO  uint32_t  PLRDY                :1;
            __IO  uint32_t  RCM                  :3;
            __IO  uint32_t  RESERVED3            :24;
        };
        struct {
            __IO  uint32_t  RESERVED2            :5;
            __IO  uint32_t  RCM0                 :1;
            __IO  uint32_t  RCM1                 :1;
            __IO  uint32_t  RCM2                 :1;
            __IO  uint32_t  RESERVED4            :24;
        };
    };
} stc_crg_scm_str_field_t;

typedef struct stc_crg_stb_ctl_field
{
    union {
        struct {
            __IO  uint32_t  STM                  :2;
            __IO  uint32_t  DSTM                 :1;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  SPL                  :1;
            __IO  uint32_t  RESERVED1            :11;
            __IO  uint32_t  KEY                  :16;
        };
        struct {
            __IO  uint32_t  STM0                 :1;
            __IO  uint32_t  STM1                 :1;
            __IO  uint32_t  RESERVED2            :14;
            __IO  uint32_t  KEY0                 :1;
            __IO  uint32_t  KEY1                 :1;
            __IO  uint32_t  KEY2                 :1;
            __IO  uint32_t  KEY3                 :1;
            __IO  uint32_t  KEY4                 :1;
            __IO  uint32_t  KEY5                 :1;
            __IO  uint32_t  KEY6                 :1;
            __IO  uint32_t  KEY7                 :1;
            __IO  uint32_t  KEY8                 :1;
            __IO  uint32_t  KEY9                 :1;
            __IO  uint32_t  KEY10                :1;
            __IO  uint32_t  KEY11                :1;
            __IO  uint32_t  KEY12                :1;
            __IO  uint32_t  KEY13                :1;
            __IO  uint32_t  KEY14                :1;
            __IO  uint32_t  KEY15                :1;
        };
    };
} stc_crg_stb_ctl_field_t;

typedef struct stc_crg_rst_str_field
{
        __IO  uint32_t  PONR                     :1;
        __IO  uint32_t  INITX                    :1;
        __IO  uint32_t  RESERVED0                :2;
        __IO  uint32_t  SWDT                     :1;
        __IO  uint32_t  HWDT                     :1;
        __IO  uint32_t  CSVR                     :1;
        __IO  uint32_t  FCSR                     :1;
        __IO  uint32_t  SRST                     :1;
        __IO  uint32_t  RESERVED1                :23;
} stc_crg_rst_str_field_t;

typedef struct stc_crg_bsc_psr_field
{
    union {
        struct {
            __IO  uint32_t  BSR                  :3;
            __IO  uint32_t  RESERVED0            :29;
        };
        struct {
            __IO  uint32_t  BSR0                 :1;
            __IO  uint32_t  BSR1                 :1;
            __IO  uint32_t  BSR2                 :1;
            __IO  uint32_t  RESERVED1            :29;
        };
    };
} stc_crg_bsc_psr_field_t;

typedef struct stc_crg_apbc0_psr_field
{
    union {
        struct {
            __IO  uint32_t  APBC0                :2;
            __IO  uint32_t  RESERVED0            :30;
        };
        struct {
            __IO  uint32_t  APBC00               :1;
            __IO  uint32_t  APBC01               :1;
            __IO  uint32_t  RESERVED1            :30;
        };
    };
} stc_crg_apbc0_psr_field_t;

typedef struct stc_crg_apbc1_psr_field
{
    union {
        struct {
            __IO  uint32_t  APBC1                :2;
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  APBC1RST             :1;
            __IO  uint32_t  RESERVED1            :2;
            __IO  uint32_t  APBC1EN              :1;
            __IO  uint32_t  RESERVED2            :24;
        };
        struct {
            __IO  uint32_t  APBC10               :1;
            __IO  uint32_t  APBC11               :1;
            __IO  uint32_t  RESERVED3            :30;
        };
    };
} stc_crg_apbc1_psr_field_t;

typedef struct stc_crg_apbc2_psr_field
{
    union {
        struct {
            __IO  uint32_t  APBC2                :2;
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  APBC2RST             :1;
            __IO  uint32_t  RESERVED1            :2;
            __IO  uint32_t  APBC2EN              :1;
            __IO  uint32_t  RESERVED2            :24;
        };
        struct {
            __IO  uint32_t  APBC20               :1;
            __IO  uint32_t  APBC21               :1;
            __IO  uint32_t  RESERVED3            :30;
        };
    };
} stc_crg_apbc2_psr_field_t;

typedef struct stc_crg_swc_psr_field
{
    union {
        struct {
            __IO  uint32_t  SWDS                 :2;
            __IO  uint32_t  RESERVED0            :30;
        };
        struct {
            __IO  uint32_t  SWDS0                :1;
            __IO  uint32_t  SWDS1                :1;
            __IO  uint32_t  RESERVED1            :30;
        };
    };
} stc_crg_swc_psr_field_t;

typedef struct stc_crg_ttc_psr_field
{
    union {
        struct {
            __IO  uint32_t  TTC                  :2;
            __IO  uint32_t  RESERVED0            :30;
        };
        struct {
            __IO  uint32_t  TTC0                 :1;
            __IO  uint32_t  TTC1                 :1;
            __IO  uint32_t  RESERVED1            :30;
        };
    };
} stc_crg_ttc_psr_field_t;

typedef struct stc_crg_csw_tmr_field
{
    union {
        struct {
            __IO  uint32_t  MOWT                 :4;
            __IO  uint32_t  SOWT                 :4;
            __IO  uint32_t  RESERVED0            :24;
        };
        struct {
            __IO  uint32_t  MOWT0                :1;
            __IO  uint32_t  MOWT1                :1;
            __IO  uint32_t  MOWT2                :1;
            __IO  uint32_t  MOWT3                :1;
            __IO  uint32_t  SOWT0                :1;
            __IO  uint32_t  SOWT1                :1;
            __IO  uint32_t  SOWT2                :1;
            __IO  uint32_t  SOWT3                :1;
            __IO  uint32_t  RESERVED1            :24;
        };
    };
} stc_crg_csw_tmr_field_t;

typedef struct stc_crg_psw_tmr_field
{
    union {
        struct {
            __IO  uint32_t  POWT                 :3;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  PINC                 :1;
            __IO  uint32_t  RESERVED1            :27;
        };
        struct {
            __IO  uint32_t  POWT0                :1;
            __IO  uint32_t  POWT1                :1;
            __IO  uint32_t  POWT2                :1;
            __IO  uint32_t  RESERVED2            :29;
        };
    };
} stc_crg_psw_tmr_field_t;

typedef struct stc_crg_pll_ctl1_field
{
    union {
        struct {
            __IO  uint32_t  PLLM                 :4;
            __IO  uint32_t  PLLK                 :4;
            __IO  uint32_t  RESERVED0            :24;
        };
        struct {
            __IO  uint32_t  PLLM0                :1;
            __IO  uint32_t  PLLM1                :1;
            __IO  uint32_t  PLLM2                :1;
            __IO  uint32_t  PLLM3                :1;
            __IO  uint32_t  PLLK0                :1;
            __IO  uint32_t  PLLK1                :1;
            __IO  uint32_t  PLLK2                :1;
            __IO  uint32_t  PLLK3                :1;
            __IO  uint32_t  RESERVED1            :24;
        };
    };
} stc_crg_pll_ctl1_field_t;

typedef struct stc_crg_pll_ctl2_field
{
    union {
        struct {
            __IO  uint32_t  PLLN                 :6;
            __IO  uint32_t  RESERVED0            :26;
        };
        struct {
            __IO  uint32_t  PLLN0                :1;
            __IO  uint32_t  PLLN1                :1;
            __IO  uint32_t  PLLN2                :1;
            __IO  uint32_t  PLLN3                :1;
            __IO  uint32_t  PLLN4                :1;
            __IO  uint32_t  PLLN5                :1;
            __IO  uint32_t  RESERVED1            :26;
        };
    };
} stc_crg_pll_ctl2_field_t;

typedef struct stc_crg_csv_ctl_field
{
    union {
        struct {
            __IO  uint32_t  MCSVE                :1;
            __IO  uint32_t  SCSVE                :1;
            __IO  uint32_t  RESERVED0            :6;
            __IO  uint32_t  FCSDE                :1;
            __IO  uint32_t  FCSRE                :1;
            __IO  uint32_t  RESERVED1            :2;
            __IO  uint32_t  FCD                  :3;
            __IO  uint32_t  RESERVED3            :17;
        };
        struct {
            __IO  uint32_t  RESERVED2            :12;
            __IO  uint32_t  FCD0                 :1;
            __IO  uint32_t  FCD1                 :1;
            __IO  uint32_t  FCD2                 :1;
            __IO  uint32_t  RESERVED4            :17;
        };
    };
} stc_crg_csv_ctl_field_t;

typedef struct stc_crg_csv_str_field
{
        __IO  uint32_t  MCMF                     :1;
        __IO  uint32_t  SCMF                     :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_crg_csv_str_field_t;

typedef struct stc_crg_fcswh_ctl_field
{
    union {
        struct {
            __IO  uint32_t  FWH                  :16;
            __IO  uint32_t  RESERVED0            :16;
        };
        struct {
            __IO  uint32_t  FWH0                 :1;
            __IO  uint32_t  FWH1                 :1;
            __IO  uint32_t  FWH2                 :1;
            __IO  uint32_t  FWH3                 :1;
            __IO  uint32_t  FWH4                 :1;
            __IO  uint32_t  FWH5                 :1;
            __IO  uint32_t  FWH6                 :1;
            __IO  uint32_t  FWH7                 :1;
            __IO  uint32_t  FWH8                 :1;
            __IO  uint32_t  FWH9                 :1;
            __IO  uint32_t  FWH10                :1;
            __IO  uint32_t  FWH11                :1;
            __IO  uint32_t  FWH12                :1;
            __IO  uint32_t  FWH13                :1;
            __IO  uint32_t  FWH14                :1;
            __IO  uint32_t  FWH15                :1;
            __IO  uint32_t  RESERVED1            :16;
        };
    };
} stc_crg_fcswh_ctl_field_t;

typedef struct stc_crg_fcswl_ctl_field
{
    union {
        struct {
            __IO  uint32_t  FWL                  :16;
            __IO  uint32_t  RESERVED0            :16;
        };
        struct {
            __IO  uint32_t  FWL0                 :1;
            __IO  uint32_t  FWL1                 :1;
            __IO  uint32_t  FWL2                 :1;
            __IO  uint32_t  FWL3                 :1;
            __IO  uint32_t  FWL4                 :1;
            __IO  uint32_t  FWL5                 :1;
            __IO  uint32_t  FWL6                 :1;
            __IO  uint32_t  FWL7                 :1;
            __IO  uint32_t  FWL8                 :1;
            __IO  uint32_t  FWL9                 :1;
            __IO  uint32_t  FWL10                :1;
            __IO  uint32_t  FWL11                :1;
            __IO  uint32_t  FWL12                :1;
            __IO  uint32_t  FWL13                :1;
            __IO  uint32_t  FWL14                :1;
            __IO  uint32_t  FWL15                :1;
            __IO  uint32_t  RESERVED1            :16;
        };
    };
} stc_crg_fcswl_ctl_field_t;

typedef struct stc_crg_fcswd_ctl_field
{
    union {
        struct {
            __IO  uint32_t  FWD                  :16;
            __IO  uint32_t  RESERVED0            :16;
        };
        struct {
            __IO  uint32_t  FWD0                 :1;
            __IO  uint32_t  FWD1                 :1;
            __IO  uint32_t  FWD2                 :1;
            __IO  uint32_t  FWD3                 :1;
            __IO  uint32_t  FWD4                 :1;
            __IO  uint32_t  FWD5                 :1;
            __IO  uint32_t  FWD6                 :1;
            __IO  uint32_t  FWD7                 :1;
            __IO  uint32_t  FWD8                 :1;
            __IO  uint32_t  FWD9                 :1;
            __IO  uint32_t  FWD10                :1;
            __IO  uint32_t  FWD11                :1;
            __IO  uint32_t  FWD12                :1;
            __IO  uint32_t  FWD13                :1;
            __IO  uint32_t  FWD14                :1;
            __IO  uint32_t  FWD15                :1;
            __IO  uint32_t  RESERVED1            :16;
        };
    };
} stc_crg_fcswd_ctl_field_t;

typedef struct stc_crg_dbwdt_ctl_field
{
        __IO  uint32_t  RESERVED0                :5;
        __IO  uint32_t  DPSWBE                   :1;
        __IO  uint32_t  RESERVED1                :1;
        __IO  uint32_t  DPHWBE                   :1;
        __IO  uint32_t  RESERVED2                :24;
} stc_crg_dbwdt_ctl_field_t;

typedef struct stc_crg_int_enr_field
{
        __IO  uint32_t  MCSE                     :1;
        __IO  uint32_t  SCSE                     :1;
        __IO  uint32_t  PCSE                     :1;
        __IO  uint32_t  RESERVED0                :2;
        __IO  uint32_t  FCSE                     :1;
        __IO  uint32_t  RESERVED1                :26;
} stc_crg_int_enr_field_t;

typedef struct stc_crg_int_str_field
{
        __IO  uint32_t  MCSI                     :1;
        __IO  uint32_t  SCSI                     :1;
        __IO  uint32_t  PCSI                     :1;
        __IO  uint32_t  RESERVED0                :2;
        __IO  uint32_t  FCSI                     :1;
        __IO  uint32_t  RESERVED1                :26;
} stc_crg_int_str_field_t;

typedef struct stc_crg_int_clr_field
{
        __IO  uint32_t  MCSC                     :1;
        __IO  uint32_t  SCSC                     :1;
        __IO  uint32_t  PCSC                     :1;
        __IO  uint32_t  RESERVED0                :2;
        __IO  uint32_t  FCSC                     :1;
        __IO  uint32_t  RESERVED1                :26;
} stc_crg_int_clr_field_t;

typedef struct stc_crg_pllcg_ctl_field
{
    union {
        struct {
            __IO  uint32_t  PLLCGEN              :1;
            __IO  uint32_t  PLLCGSTR             :1;
            __IO  uint32_t  RESERVED0            :4;
            __IO  uint32_t  PLLCGSTS             :2;
            __IO  uint32_t  PLLCGSSN             :6;
            __IO  uint32_t  PLLCGSTP             :2;
            __IO  uint32_t  PLLCGLP              :8;
            __IO  uint32_t  RESERVED2            :8;
        };
        struct {
            __IO  uint32_t  RESERVED1            :6;
            __IO  uint32_t  PLLCGSTS0            :1;
            __IO  uint32_t  PLLCGSTS1            :1;
            __IO  uint32_t  PLLCGSSN0            :1;
            __IO  uint32_t  PLLCGSSN1            :1;
            __IO  uint32_t  PLLCGSSN2            :1;
            __IO  uint32_t  PLLCGSSN3            :1;
            __IO  uint32_t  PLLCGSSN4            :1;
            __IO  uint32_t  PLLCGSSN5            :1;
            __IO  uint32_t  PLLCGSTP0            :1;
            __IO  uint32_t  PLLCGSTP1            :1;
            __IO  uint32_t  PLLCGLP0             :1;
            __IO  uint32_t  PLLCGLP1             :1;
            __IO  uint32_t  PLLCGLP2             :1;
            __IO  uint32_t  PLLCGLP3             :1;
            __IO  uint32_t  PLLCGLP4             :1;
            __IO  uint32_t  PLLCGLP5             :1;
            __IO  uint32_t  PLLCGLP6             :1;
            __IO  uint32_t  PLLCGLP7             :1;
            __IO  uint32_t  RESERVED3            :8;
        };
    };
} stc_crg_pllcg_ctl_field_t;

/******************************************************************************
 ** CRTRIM_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_crtrim_mcr_psr_field
{
    union {
        struct {
            __IO   uint8_t  CSR                  :3;
            __IO   uint8_t  RESERVED0            :5;
        };
        struct {
            __IO   uint8_t  CSR0                 :1;
            __IO   uint8_t  CSR1                 :1;
            __IO   uint8_t  CSR2                 :1;
            __IO   uint8_t  RESERVED1            :5;
        };
    };
} stc_crtrim_mcr_psr_field_t;

typedef struct stc_crtrim_mcr_ftrm_field
{
    union {
        struct {
            __IO  uint32_t  TRD                  :10;
            __IO  uint32_t  RESERVED0            :22;
        };
        struct {
            __IO  uint32_t  TRD0                 :1;
            __IO  uint32_t  TRD1                 :1;
            __IO  uint32_t  TRD2                 :1;
            __IO  uint32_t  TRD3                 :1;
            __IO  uint32_t  TRD4                 :1;
            __IO  uint32_t  TRD5                 :1;
            __IO  uint32_t  TRD6                 :1;
            __IO  uint32_t  TRD7                 :1;
            __IO  uint32_t  TRD8                 :1;
            __IO  uint32_t  TRD9                 :1;
            __IO  uint32_t  RESERVED1            :22;
        };
    };
} stc_crtrim_mcr_ftrm_field_t;

typedef struct stc_crtrim_mcr_ttrm_field
{
    union {
        struct {
            __IO  uint32_t  TRT                  :5;
            __IO  uint32_t  RESERVED0            :27;
        };
        struct {
            __IO  uint32_t  TRT0                 :1;
            __IO  uint32_t  TRT1                 :1;
            __IO  uint32_t  TRT2                 :1;
            __IO  uint32_t  TRT3                 :1;
            __IO  uint32_t  TRT4                 :1;
            __IO  uint32_t  RESERVED1            :27;
        };
    };
} stc_crtrim_mcr_ttrm_field_t;

typedef struct stc_crtrim_mcr_rlr_field
{
    union {
        struct {
            __IO  uint32_t  TRMLCK               :32;
        };
        struct {
            __IO  uint32_t  TRMLCK0              :1;
            __IO  uint32_t  TRMLCK1              :1;
            __IO  uint32_t  TRMLCK2              :1;
            __IO  uint32_t  TRMLCK3              :1;
            __IO  uint32_t  TRMLCK4              :1;
            __IO  uint32_t  TRMLCK5              :1;
            __IO  uint32_t  TRMLCK6              :1;
            __IO  uint32_t  TRMLCK7              :1;
            __IO  uint32_t  TRMLCK8              :1;
            __IO  uint32_t  TRMLCK9              :1;
            __IO  uint32_t  TRMLCK10             :1;
            __IO  uint32_t  TRMLCK11             :1;
            __IO  uint32_t  TRMLCK12             :1;
            __IO  uint32_t  TRMLCK13             :1;
            __IO  uint32_t  TRMLCK14             :1;
            __IO  uint32_t  TRMLCK15             :1;
            __IO  uint32_t  TRMLCK16             :1;
            __IO  uint32_t  TRMLCK17             :1;
            __IO  uint32_t  TRMLCK18             :1;
            __IO  uint32_t  TRMLCK19             :1;
            __IO  uint32_t  TRMLCK20             :1;
            __IO  uint32_t  TRMLCK21             :1;
            __IO  uint32_t  TRMLCK22             :1;
            __IO  uint32_t  TRMLCK23             :1;
            __IO  uint32_t  TRMLCK24             :1;
            __IO  uint32_t  TRMLCK25             :1;
            __IO  uint32_t  TRMLCK26             :1;
            __IO  uint32_t  TRMLCK27             :1;
            __IO  uint32_t  TRMLCK28             :1;
            __IO  uint32_t  TRMLCK29             :1;
            __IO  uint32_t  TRMLCK30             :1;
            __IO  uint32_t  TRMLCK31             :1;
        };
    };
} stc_crtrim_mcr_rlr_field_t;

/******************************************************************************
 ** DMAC_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_dmac_dmacr_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :24;
            __IO  uint32_t  DH                   :4;
            __IO  uint32_t  PR                   :1;
            __IO  uint32_t  RESERVED2            :1;
            __IO  uint32_t  DS                   :1;
            __IO  uint32_t  DE                   :1;
        };
        struct {
            __IO  uint32_t  RESERVED1            :24;
            __IO  uint32_t  DH0                  :1;
            __IO  uint32_t  DH1                  :1;
            __IO  uint32_t  DH2                  :1;
            __IO  uint32_t  DH3                  :1;
            __IO  uint32_t  RESERVED3            :4;
        };
    };
} stc_dmac_dmacr_field_t;

typedef struct stc_dmac_dmaca0_field
{
    union {
        struct {
            __IO  uint32_t  TC                   :16;
            __IO  uint32_t  BC                   :4;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  IS                   :6;
            __IO  uint32_t  ST                   :1;
            __IO  uint32_t  PB                   :1;
            __IO  uint32_t  EB                   :1;
        };
        struct {
            __IO  uint32_t  TC0                  :1;
            __IO  uint32_t  TC1                  :1;
            __IO  uint32_t  TC2                  :1;
            __IO  uint32_t  TC3                  :1;
            __IO  uint32_t  TC4                  :1;
            __IO  uint32_t  TC5                  :1;
            __IO  uint32_t  TC6                  :1;
            __IO  uint32_t  TC7                  :1;
            __IO  uint32_t  TC8                  :1;
            __IO  uint32_t  TC9                  :1;
            __IO  uint32_t  TC10                 :1;
            __IO  uint32_t  TC11                 :1;
            __IO  uint32_t  TC12                 :1;
            __IO  uint32_t  TC13                 :1;
            __IO  uint32_t  TC14                 :1;
            __IO  uint32_t  TC15                 :1;
            __IO  uint32_t  BC0                  :1;
            __IO  uint32_t  BC1                  :1;
            __IO  uint32_t  BC2                  :1;
            __IO  uint32_t  BC3                  :1;
            __IO  uint32_t  RESERVED1            :3;
            __IO  uint32_t  IS0                  :1;
            __IO  uint32_t  IS1                  :1;
            __IO  uint32_t  IS2                  :1;
            __IO  uint32_t  IS3                  :1;
            __IO  uint32_t  IS4                  :1;
            __IO  uint32_t  IS5                  :1;
            __IO  uint32_t  RESERVED2            :3;
        };
    };
} stc_dmac_dmaca0_field_t;

typedef struct stc_dmac_dmacb0_field
{
    union {
        struct {
            __IO  uint32_t  EM                   :1;
            __IO  uint32_t  RESERVED0            :15;
            __IO  uint32_t  SS                   :3;
            __IO  uint32_t  CI                   :1;
            __IO  uint32_t  EI                   :1;
            __IO  uint32_t  RD                   :1;
            __IO  uint32_t  RS                   :1;
            __IO  uint32_t  RC                   :1;
            __IO  uint32_t  FD                   :1;
            __IO  uint32_t  FS                   :1;
            __IO  uint32_t  TW                   :2;
            __IO  uint32_t  MS                   :2;
            __IO  uint32_t  RESERVED3            :2;
        };
        struct {
            __IO  uint32_t  RESERVED1            :16;
            __IO  uint32_t  SS0                  :1;
            __IO  uint32_t  SS1                  :1;
            __IO  uint32_t  SS2                  :1;
            __IO  uint32_t  RESERVED2            :7;
            __IO  uint32_t  TW0                  :1;
            __IO  uint32_t  TW1                  :1;
            __IO  uint32_t  MS0                  :1;
            __IO  uint32_t  MS1                  :1;
            __IO  uint32_t  RESERVED4            :2;
        };
    };
} stc_dmac_dmacb0_field_t;

typedef struct stc_dmac_dmaca1_field
{
    union {
        struct {
            __IO  uint32_t  TC                   :16;
            __IO  uint32_t  BC                   :4;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  IS                   :6;
            __IO  uint32_t  ST                   :1;
            __IO  uint32_t  PB                   :1;
            __IO  uint32_t  EB                   :1;
        };
        struct {
            __IO  uint32_t  TC0                  :1;
            __IO  uint32_t  TC1                  :1;
            __IO  uint32_t  TC2                  :1;
            __IO  uint32_t  TC3                  :1;
            __IO  uint32_t  TC4                  :1;
            __IO  uint32_t  TC5                  :1;
            __IO  uint32_t  TC6                  :1;
            __IO  uint32_t  TC7                  :1;
            __IO  uint32_t  TC8                  :1;
            __IO  uint32_t  TC9                  :1;
            __IO  uint32_t  TC10                 :1;
            __IO  uint32_t  TC11                 :1;
            __IO  uint32_t  TC12                 :1;
            __IO  uint32_t  TC13                 :1;
            __IO  uint32_t  TC14                 :1;
            __IO  uint32_t  TC15                 :1;
            __IO  uint32_t  BC0                  :1;
            __IO  uint32_t  BC1                  :1;
            __IO  uint32_t  BC2                  :1;
            __IO  uint32_t  BC3                  :1;
            __IO  uint32_t  RESERVED1            :3;
            __IO  uint32_t  IS0                  :1;
            __IO  uint32_t  IS1                  :1;
            __IO  uint32_t  IS2                  :1;
            __IO  uint32_t  IS3                  :1;
            __IO  uint32_t  IS4                  :1;
            __IO  uint32_t  IS5                  :1;
            __IO  uint32_t  RESERVED2            :3;
        };
    };
} stc_dmac_dmaca1_field_t;

typedef struct stc_dmac_dmacb1_field
{
    union {
        struct {
            __IO  uint32_t  EM                   :1;
            __IO  uint32_t  RESERVED0            :15;
            __IO  uint32_t  SS                   :3;
            __IO  uint32_t  CI                   :1;
            __IO  uint32_t  EI                   :1;
            __IO  uint32_t  RD                   :1;
            __IO  uint32_t  RS                   :1;
            __IO  uint32_t  RC                   :1;
            __IO  uint32_t  FD                   :1;
            __IO  uint32_t  FS                   :1;
            __IO  uint32_t  TW                   :2;
            __IO  uint32_t  MS                   :2;
            __IO  uint32_t  RESERVED3            :2;
        };
        struct {
            __IO  uint32_t  RESERVED1            :16;
            __IO  uint32_t  SS0                  :1;
            __IO  uint32_t  SS1                  :1;
            __IO  uint32_t  SS2                  :1;
            __IO  uint32_t  RESERVED2            :7;
            __IO  uint32_t  TW0                  :1;
            __IO  uint32_t  TW1                  :1;
            __IO  uint32_t  MS0                  :1;
            __IO  uint32_t  MS1                  :1;
            __IO  uint32_t  RESERVED4            :2;
        };
    };
} stc_dmac_dmacb1_field_t;

typedef struct stc_dmac_dmaca2_field
{
    union {
        struct {
            __IO  uint32_t  TC                   :16;
            __IO  uint32_t  BC                   :4;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  IS                   :6;
            __IO  uint32_t  ST                   :1;
            __IO  uint32_t  PB                   :1;
            __IO  uint32_t  EB                   :1;
        };
        struct {
            __IO  uint32_t  TC0                  :1;
            __IO  uint32_t  TC1                  :1;
            __IO  uint32_t  TC2                  :1;
            __IO  uint32_t  TC3                  :1;
            __IO  uint32_t  TC4                  :1;
            __IO  uint32_t  TC5                  :1;
            __IO  uint32_t  TC6                  :1;
            __IO  uint32_t  TC7                  :1;
            __IO  uint32_t  TC8                  :1;
            __IO  uint32_t  TC9                  :1;
            __IO  uint32_t  TC10                 :1;
            __IO  uint32_t  TC11                 :1;
            __IO  uint32_t  TC12                 :1;
            __IO  uint32_t  TC13                 :1;
            __IO  uint32_t  TC14                 :1;
            __IO  uint32_t  TC15                 :1;
            __IO  uint32_t  BC0                  :1;
            __IO  uint32_t  BC1                  :1;
            __IO  uint32_t  BC2                  :1;
            __IO  uint32_t  BC3                  :1;
            __IO  uint32_t  RESERVED1            :3;
            __IO  uint32_t  IS0                  :1;
            __IO  uint32_t  IS1                  :1;
            __IO  uint32_t  IS2                  :1;
            __IO  uint32_t  IS3                  :1;
            __IO  uint32_t  IS4                  :1;
            __IO  uint32_t  IS5                  :1;
            __IO  uint32_t  RESERVED2            :3;
        };
    };
} stc_dmac_dmaca2_field_t;

typedef struct stc_dmac_dmacb2_field
{
    union {
        struct {
            __IO  uint32_t  EM                   :1;
            __IO  uint32_t  RESERVED0            :15;
            __IO  uint32_t  SS                   :3;
            __IO  uint32_t  CI                   :1;
            __IO  uint32_t  EI                   :1;
            __IO  uint32_t  RD                   :1;
            __IO  uint32_t  RS                   :1;
            __IO  uint32_t  RC                   :1;
            __IO  uint32_t  FD                   :1;
            __IO  uint32_t  FS                   :1;
            __IO  uint32_t  TW                   :2;
            __IO  uint32_t  MS                   :2;
            __IO  uint32_t  RESERVED3            :2;
        };
        struct {
            __IO  uint32_t  RESERVED1            :16;
            __IO  uint32_t  SS0                  :1;
            __IO  uint32_t  SS1                  :1;
            __IO  uint32_t  SS2                  :1;
            __IO  uint32_t  RESERVED2            :7;
            __IO  uint32_t  TW0                  :1;
            __IO  uint32_t  TW1                  :1;
            __IO  uint32_t  MS0                  :1;
            __IO  uint32_t  MS1                  :1;
            __IO  uint32_t  RESERVED4            :2;
        };
    };
} stc_dmac_dmacb2_field_t;

typedef struct stc_dmac_dmaca3_field
{
    union {
        struct {
            __IO  uint32_t  TC                   :16;
            __IO  uint32_t  BC                   :4;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  IS                   :6;
            __IO  uint32_t  ST                   :1;
            __IO  uint32_t  PB                   :1;
            __IO  uint32_t  EB                   :1;
        };
        struct {
            __IO  uint32_t  TC0                  :1;
            __IO  uint32_t  TC1                  :1;
            __IO  uint32_t  TC2                  :1;
            __IO  uint32_t  TC3                  :1;
            __IO  uint32_t  TC4                  :1;
            __IO  uint32_t  TC5                  :1;
            __IO  uint32_t  TC6                  :1;
            __IO  uint32_t  TC7                  :1;
            __IO  uint32_t  TC8                  :1;
            __IO  uint32_t  TC9                  :1;
            __IO  uint32_t  TC10                 :1;
            __IO  uint32_t  TC11                 :1;
            __IO  uint32_t  TC12                 :1;
            __IO  uint32_t  TC13                 :1;
            __IO  uint32_t  TC14                 :1;
            __IO  uint32_t  TC15                 :1;
            __IO  uint32_t  BC0                  :1;
            __IO  uint32_t  BC1                  :1;
            __IO  uint32_t  BC2                  :1;
            __IO  uint32_t  BC3                  :1;
            __IO  uint32_t  RESERVED1            :3;
            __IO  uint32_t  IS0                  :1;
            __IO  uint32_t  IS1                  :1;
            __IO  uint32_t  IS2                  :1;
            __IO  uint32_t  IS3                  :1;
            __IO  uint32_t  IS4                  :1;
            __IO  uint32_t  IS5                  :1;
            __IO  uint32_t  RESERVED2            :3;
        };
    };
} stc_dmac_dmaca3_field_t;

typedef struct stc_dmac_dmacb3_field
{
    union {
        struct {
            __IO  uint32_t  EM                   :1;
            __IO  uint32_t  RESERVED0            :15;
            __IO  uint32_t  SS                   :3;
            __IO  uint32_t  CI                   :1;
            __IO  uint32_t  EI                   :1;
            __IO  uint32_t  RD                   :1;
            __IO  uint32_t  RS                   :1;
            __IO  uint32_t  RC                   :1;
            __IO  uint32_t  FD                   :1;
            __IO  uint32_t  FS                   :1;
            __IO  uint32_t  TW                   :2;
            __IO  uint32_t  MS                   :2;
            __IO  uint32_t  RESERVED3            :2;
        };
        struct {
            __IO  uint32_t  RESERVED1            :16;
            __IO  uint32_t  SS0                  :1;
            __IO  uint32_t  SS1                  :1;
            __IO  uint32_t  SS2                  :1;
            __IO  uint32_t  RESERVED2            :7;
            __IO  uint32_t  TW0                  :1;
            __IO  uint32_t  TW1                  :1;
            __IO  uint32_t  MS0                  :1;
            __IO  uint32_t  MS1                  :1;
            __IO  uint32_t  RESERVED4            :2;
        };
    };
} stc_dmac_dmacb3_field_t;

typedef struct stc_dmac_dmaca4_field
{
    union {
        struct {
            __IO  uint32_t  TC                   :16;
            __IO  uint32_t  BC                   :4;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  IS                   :6;
            __IO  uint32_t  ST                   :1;
            __IO  uint32_t  PB                   :1;
            __IO  uint32_t  EB                   :1;
        };
        struct {
            __IO  uint32_t  TC0                  :1;
            __IO  uint32_t  TC1                  :1;
            __IO  uint32_t  TC2                  :1;
            __IO  uint32_t  TC3                  :1;
            __IO  uint32_t  TC4                  :1;
            __IO  uint32_t  TC5                  :1;
            __IO  uint32_t  TC6                  :1;
            __IO  uint32_t  TC7                  :1;
            __IO  uint32_t  TC8                  :1;
            __IO  uint32_t  TC9                  :1;
            __IO  uint32_t  TC10                 :1;
            __IO  uint32_t  TC11                 :1;
            __IO  uint32_t  TC12                 :1;
            __IO  uint32_t  TC13                 :1;
            __IO  uint32_t  TC14                 :1;
            __IO  uint32_t  TC15                 :1;
            __IO  uint32_t  BC0                  :1;
            __IO  uint32_t  BC1                  :1;
            __IO  uint32_t  BC2                  :1;
            __IO  uint32_t  BC3                  :1;
            __IO  uint32_t  RESERVED1            :3;
            __IO  uint32_t  IS0                  :1;
            __IO  uint32_t  IS1                  :1;
            __IO  uint32_t  IS2                  :1;
            __IO  uint32_t  IS3                  :1;
            __IO  uint32_t  IS4                  :1;
            __IO  uint32_t  IS5                  :1;
            __IO  uint32_t  RESERVED2            :3;
        };
    };
} stc_dmac_dmaca4_field_t;

typedef struct stc_dmac_dmacb4_field
{
    union {
        struct {
            __IO  uint32_t  EM                   :1;
            __IO  uint32_t  RESERVED0            :15;
            __IO  uint32_t  SS                   :3;
            __IO  uint32_t  CI                   :1;
            __IO  uint32_t  EI                   :1;
            __IO  uint32_t  RD                   :1;
            __IO  uint32_t  RS                   :1;
            __IO  uint32_t  RC                   :1;
            __IO  uint32_t  FD                   :1;
            __IO  uint32_t  FS                   :1;
            __IO  uint32_t  TW                   :2;
            __IO  uint32_t  MS                   :2;
            __IO  uint32_t  RESERVED3            :2;
        };
        struct {
            __IO  uint32_t  RESERVED1            :16;
            __IO  uint32_t  SS0                  :1;
            __IO  uint32_t  SS1                  :1;
            __IO  uint32_t  SS2                  :1;
            __IO  uint32_t  RESERVED2            :7;
            __IO  uint32_t  TW0                  :1;
            __IO  uint32_t  TW1                  :1;
            __IO  uint32_t  MS0                  :1;
            __IO  uint32_t  MS1                  :1;
            __IO  uint32_t  RESERVED4            :2;
        };
    };
} stc_dmac_dmacb4_field_t;

typedef struct stc_dmac_dmaca5_field
{
    union {
        struct {
            __IO  uint32_t  TC                   :16;
            __IO  uint32_t  BC                   :4;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  IS                   :6;
            __IO  uint32_t  ST                   :1;
            __IO  uint32_t  PB                   :1;
            __IO  uint32_t  EB                   :1;
        };
        struct {
            __IO  uint32_t  TC0                  :1;
            __IO  uint32_t  TC1                  :1;
            __IO  uint32_t  TC2                  :1;
            __IO  uint32_t  TC3                  :1;
            __IO  uint32_t  TC4                  :1;
            __IO  uint32_t  TC5                  :1;
            __IO  uint32_t  TC6                  :1;
            __IO  uint32_t  TC7                  :1;
            __IO  uint32_t  TC8                  :1;
            __IO  uint32_t  TC9                  :1;
            __IO  uint32_t  TC10                 :1;
            __IO  uint32_t  TC11                 :1;
            __IO  uint32_t  TC12                 :1;
            __IO  uint32_t  TC13                 :1;
            __IO  uint32_t  TC14                 :1;
            __IO  uint32_t  TC15                 :1;
            __IO  uint32_t  BC0                  :1;
            __IO  uint32_t  BC1                  :1;
            __IO  uint32_t  BC2                  :1;
            __IO  uint32_t  BC3                  :1;
            __IO  uint32_t  RESERVED1            :3;
            __IO  uint32_t  IS0                  :1;
            __IO  uint32_t  IS1                  :1;
            __IO  uint32_t  IS2                  :1;
            __IO  uint32_t  IS3                  :1;
            __IO  uint32_t  IS4                  :1;
            __IO  uint32_t  IS5                  :1;
            __IO  uint32_t  RESERVED2            :3;
        };
    };
} stc_dmac_dmaca5_field_t;

typedef struct stc_dmac_dmacb5_field
{
    union {
        struct {
            __IO  uint32_t  EM                   :1;
            __IO  uint32_t  RESERVED0            :15;
            __IO  uint32_t  SS                   :3;
            __IO  uint32_t  CI                   :1;
            __IO  uint32_t  EI                   :1;
            __IO  uint32_t  RD                   :1;
            __IO  uint32_t  RS                   :1;
            __IO  uint32_t  RC                   :1;
            __IO  uint32_t  FD                   :1;
            __IO  uint32_t  FS                   :1;
            __IO  uint32_t  TW                   :2;
            __IO  uint32_t  MS                   :2;
            __IO  uint32_t  RESERVED3            :2;
        };
        struct {
            __IO  uint32_t  RESERVED1            :16;
            __IO  uint32_t  SS0                  :1;
            __IO  uint32_t  SS1                  :1;
            __IO  uint32_t  SS2                  :1;
            __IO  uint32_t  RESERVED2            :7;
            __IO  uint32_t  TW0                  :1;
            __IO  uint32_t  TW1                  :1;
            __IO  uint32_t  MS0                  :1;
            __IO  uint32_t  MS1                  :1;
            __IO  uint32_t  RESERVED4            :2;
        };
    };
} stc_dmac_dmacb5_field_t;

typedef struct stc_dmac_dmaca6_field
{
    union {
        struct {
            __IO  uint32_t  TC                   :16;
            __IO  uint32_t  BC                   :4;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  IS                   :6;
            __IO  uint32_t  ST                   :1;
            __IO  uint32_t  PB                   :1;
            __IO  uint32_t  EB                   :1;
        };
        struct {
            __IO  uint32_t  TC0                  :1;
            __IO  uint32_t  TC1                  :1;
            __IO  uint32_t  TC2                  :1;
            __IO  uint32_t  TC3                  :1;
            __IO  uint32_t  TC4                  :1;
            __IO  uint32_t  TC5                  :1;
            __IO  uint32_t  TC6                  :1;
            __IO  uint32_t  TC7                  :1;
            __IO  uint32_t  TC8                  :1;
            __IO  uint32_t  TC9                  :1;
            __IO  uint32_t  TC10                 :1;
            __IO  uint32_t  TC11                 :1;
            __IO  uint32_t  TC12                 :1;
            __IO  uint32_t  TC13                 :1;
            __IO  uint32_t  TC14                 :1;
            __IO  uint32_t  TC15                 :1;
            __IO  uint32_t  BC0                  :1;
            __IO  uint32_t  BC1                  :1;
            __IO  uint32_t  BC2                  :1;
            __IO  uint32_t  BC3                  :1;
            __IO  uint32_t  RESERVED1            :3;
            __IO  uint32_t  IS0                  :1;
            __IO  uint32_t  IS1                  :1;
            __IO  uint32_t  IS2                  :1;
            __IO  uint32_t  IS3                  :1;
            __IO  uint32_t  IS4                  :1;
            __IO  uint32_t  IS5                  :1;
            __IO  uint32_t  RESERVED2            :3;
        };
    };
} stc_dmac_dmaca6_field_t;

typedef struct stc_dmac_dmacb6_field
{
    union {
        struct {
            __IO  uint32_t  EM                   :1;
            __IO  uint32_t  RESERVED0            :15;
            __IO  uint32_t  SS                   :3;
            __IO  uint32_t  CI                   :1;
            __IO  uint32_t  EI                   :1;
            __IO  uint32_t  RD                   :1;
            __IO  uint32_t  RS                   :1;
            __IO  uint32_t  RC                   :1;
            __IO  uint32_t  FD                   :1;
            __IO  uint32_t  FS                   :1;
            __IO  uint32_t  TW                   :2;
            __IO  uint32_t  MS                   :2;
            __IO  uint32_t  RESERVED3            :2;
        };
        struct {
            __IO  uint32_t  RESERVED1            :16;
            __IO  uint32_t  SS0                  :1;
            __IO  uint32_t  SS1                  :1;
            __IO  uint32_t  SS2                  :1;
            __IO  uint32_t  RESERVED2            :7;
            __IO  uint32_t  TW0                  :1;
            __IO  uint32_t  TW1                  :1;
            __IO  uint32_t  MS0                  :1;
            __IO  uint32_t  MS1                  :1;
            __IO  uint32_t  RESERVED4            :2;
        };
    };
} stc_dmac_dmacb6_field_t;

typedef struct stc_dmac_dmaca7_field
{
    union {
        struct {
            __IO  uint32_t  TC                   :16;
            __IO  uint32_t  BC                   :4;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  IS                   :6;
            __IO  uint32_t  ST                   :1;
            __IO  uint32_t  PB                   :1;
            __IO  uint32_t  EB                   :1;
        };
        struct {
            __IO  uint32_t  TC0                  :1;
            __IO  uint32_t  TC1                  :1;
            __IO  uint32_t  TC2                  :1;
            __IO  uint32_t  TC3                  :1;
            __IO  uint32_t  TC4                  :1;
            __IO  uint32_t  TC5                  :1;
            __IO  uint32_t  TC6                  :1;
            __IO  uint32_t  TC7                  :1;
            __IO  uint32_t  TC8                  :1;
            __IO  uint32_t  TC9                  :1;
            __IO  uint32_t  TC10                 :1;
            __IO  uint32_t  TC11                 :1;
            __IO  uint32_t  TC12                 :1;
            __IO  uint32_t  TC13                 :1;
            __IO  uint32_t  TC14                 :1;
            __IO  uint32_t  TC15                 :1;
            __IO  uint32_t  BC0                  :1;
            __IO  uint32_t  BC1                  :1;
            __IO  uint32_t  BC2                  :1;
            __IO  uint32_t  BC3                  :1;
            __IO  uint32_t  RESERVED1            :3;
            __IO  uint32_t  IS0                  :1;
            __IO  uint32_t  IS1                  :1;
            __IO  uint32_t  IS2                  :1;
            __IO  uint32_t  IS3                  :1;
            __IO  uint32_t  IS4                  :1;
            __IO  uint32_t  IS5                  :1;
            __IO  uint32_t  RESERVED2            :3;
        };
    };
} stc_dmac_dmaca7_field_t;

typedef struct stc_dmac_dmacb7_field
{
    union {
        struct {
            __IO  uint32_t  EM                   :1;
            __IO  uint32_t  RESERVED0            :15;
            __IO  uint32_t  SS                   :3;
            __IO  uint32_t  CI                   :1;
            __IO  uint32_t  EI                   :1;
            __IO  uint32_t  RD                   :1;
            __IO  uint32_t  RS                   :1;
            __IO  uint32_t  RC                   :1;
            __IO  uint32_t  FD                   :1;
            __IO  uint32_t  FS                   :1;
            __IO  uint32_t  TW                   :2;
            __IO  uint32_t  MS                   :2;
            __IO  uint32_t  RESERVED3            :2;
        };
        struct {
            __IO  uint32_t  RESERVED1            :16;
            __IO  uint32_t  SS0                  :1;
            __IO  uint32_t  SS1                  :1;
            __IO  uint32_t  SS2                  :1;
            __IO  uint32_t  RESERVED2            :7;
            __IO  uint32_t  TW0                  :1;
            __IO  uint32_t  TW1                  :1;
            __IO  uint32_t  MS0                  :1;
            __IO  uint32_t  MS1                  :1;
            __IO  uint32_t  RESERVED4            :2;
        };
    };
} stc_dmac_dmacb7_field_t;

/******************************************************************************
 ** DS_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_ds_rck_ctl_field
{
        __IO   uint8_t  RTCCKE                   :1;
        __IO   uint8_t  CECCKE                   :1;
        __IO   uint8_t  RESERVED0                :6;
} stc_ds_rck_ctl_field_t;

typedef struct stc_ds_pmd_ctl_field
{
        __IO   uint8_t  RTCE                     :1;
        __IO   uint8_t  RESERVED0                :7;
} stc_ds_pmd_ctl_field_t;

typedef struct stc_ds_wrfsr_field
{
        __IO   uint8_t  WINITX                   :1;
        __IO   uint8_t  WLVDH                    :1;
        __IO   uint8_t  RESERVED0                :6;
} stc_ds_wrfsr_field_t;

typedef struct stc_ds_wifsr_field
{
        __IO  uint16_t  WRTCI                    :1;
        __IO  uint16_t  WLVDI                    :1;
        __IO  uint16_t  WUI0                     :1;
        __IO  uint16_t  WUI1                     :1;
        __IO  uint16_t  WUI2                     :1;
        __IO  uint16_t  WUI3                     :1;
        __IO  uint16_t  WUI4                     :1;
        __IO  uint16_t  WUI5                     :1;
        __IO  uint16_t  RESERVED0                :8;
} stc_ds_wifsr_field_t;

typedef struct stc_ds_wier_field
{
        __IO  uint16_t  WRTCE                    :1;
        __IO  uint16_t  WLVDE                    :1;
        __IO  uint16_t  RESERVED0                :1;
        __IO  uint16_t  WUI1E                    :1;
        __IO  uint16_t  WUI2E                    :1;
        __IO  uint16_t  WUI3E                    :1;
        __IO  uint16_t  WUI4E                    :1;
        __IO  uint16_t  WUI5E                    :1;
        __IO  uint16_t  RESERVED1                :8;
} stc_ds_wier_field_t;

typedef struct stc_ds_wilvr_field
{
        __IO   uint8_t  WUI1LV                   :1;
        __IO   uint8_t  WUI2LV                   :1;
        __IO   uint8_t  WUI3LV                   :1;
        __IO   uint8_t  WUI4LV                   :1;
        __IO   uint8_t  WUI5LV                   :1;
        __IO   uint8_t  RESERVED0                :3;
} stc_ds_wilvr_field_t;

typedef struct stc_ds_dsramr_field
{
    union {
        struct {
            __IO   uint8_t  SRAMR                :2;
            __IO   uint8_t  RESERVED0            :6;
        };
        struct {
            __IO   uint8_t  SRAMR0               :1;
            __IO   uint8_t  SRAMR1               :1;
            __IO   uint8_t  RESERVED1            :6;
        };
    };
} stc_ds_dsramr_field_t;

/******************************************************************************
 ** DSTC_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_dstc_hwdesp_field
{
    union {
        struct {
            __IO  uint32_t  CHANNEL              :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  HWDESP               :14;
            __IO  uint32_t  RESERVED2            :2;
        };
        struct {
            __IO  uint32_t  CHANNEL0             :1;
            __IO  uint32_t  CHANNEL1             :1;
            __IO  uint32_t  CHANNEL2             :1;
            __IO  uint32_t  CHANNEL3             :1;
            __IO  uint32_t  CHANNEL4             :1;
            __IO  uint32_t  CHANNEL5             :1;
            __IO  uint32_t  CHANNEL6             :1;
            __IO  uint32_t  CHANNEL7             :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  HWDESP0              :1;
            __IO  uint32_t  HWDESP1              :1;
            __IO  uint32_t  HWDESP2              :1;
            __IO  uint32_t  HWDESP3              :1;
            __IO  uint32_t  HWDESP4              :1;
            __IO  uint32_t  HWDESP5              :1;
            __IO  uint32_t  HWDESP6              :1;
            __IO  uint32_t  HWDESP7              :1;
            __IO  uint32_t  HWDESP8              :1;
            __IO  uint32_t  HWDESP9              :1;
            __IO  uint32_t  HWDESP10             :1;
            __IO  uint32_t  HWDESP11             :1;
            __IO  uint32_t  HWDESP12             :1;
            __IO  uint32_t  HWDESP13             :1;
            __IO  uint32_t  RESERVED3            :2;
        };
    };
} stc_dstc_hwdesp_field_t;

typedef struct stc_dstc_cfg_field
{
    union {
        struct {
            __IO   uint8_t  SWINTE               :1;
            __IO   uint8_t  ERINTE               :1;
            __IO   uint8_t  RBDIS                :1;
            __IO   uint8_t  ESTE                 :1;
            __IO   uint8_t  SWPR                 :3;
            __IO   uint8_t  RESERVED1            :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :4;
            __IO   uint8_t  SWPR0                :1;
            __IO   uint8_t  SWPR1                :1;
            __IO   uint8_t  SWPR2                :1;
            __IO   uint8_t  RESERVED2            :1;
        };
    };
} stc_dstc_cfg_field_t;

typedef struct stc_dstc_swtr_field
{
    union {
        struct {
            __IO  uint16_t  SWDESP               :14;
            __IO  uint16_t  SWREQ                :1;
            __IO  uint16_t  SWST                 :1;
        };
        struct {
            __IO  uint16_t  SWDESP0              :1;
            __IO  uint16_t  SWDESP1              :1;
            __IO  uint16_t  SWDESP2              :1;
            __IO  uint16_t  SWDESP3              :1;
            __IO  uint16_t  SWDESP4              :1;
            __IO  uint16_t  SWDESP5              :1;
            __IO  uint16_t  SWDESP6              :1;
            __IO  uint16_t  SWDESP7              :1;
            __IO  uint16_t  SWDESP8              :1;
            __IO  uint16_t  SWDESP9              :1;
            __IO  uint16_t  SWDESP10             :1;
            __IO  uint16_t  SWDESP11             :1;
            __IO  uint16_t  SWDESP12             :1;
            __IO  uint16_t  SWDESP13             :1;
            __IO  uint16_t  RESERVED0            :2;
        };
    };
} stc_dstc_swtr_field_t;

typedef struct stc_dstc_moners_field
{
    union {
        struct {
            __IO  uint32_t  EST                  :3;
            __IO  uint32_t  DER                  :1;
            __IO  uint32_t  ESTOP                :1;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  EHS                  :1;
            __IO  uint32_t  RESERVED1            :1;
            __IO  uint32_t  ECH                  :8;
            __IO  uint32_t  EDESP                :14;
            __IO  uint32_t  RESERVED3            :2;
        };
        struct {
            __IO  uint32_t  EST0                 :1;
            __IO  uint32_t  EST1                 :1;
            __IO  uint32_t  EST2                 :1;
            __IO  uint32_t  RESERVED2            :5;
            __IO  uint32_t  ECH0                 :1;
            __IO  uint32_t  ECH1                 :1;
            __IO  uint32_t  ECH2                 :1;
            __IO  uint32_t  ECH3                 :1;
            __IO  uint32_t  ECH4                 :1;
            __IO  uint32_t  ECH5                 :1;
            __IO  uint32_t  ECH6                 :1;
            __IO  uint32_t  ECH7                 :1;
            __IO  uint32_t  EDESP0               :1;
            __IO  uint32_t  EDESP1               :1;
            __IO  uint32_t  EDESP2               :1;
            __IO  uint32_t  EDESP3               :1;
            __IO  uint32_t  EDESP4               :1;
            __IO  uint32_t  EDESP5               :1;
            __IO  uint32_t  EDESP6               :1;
            __IO  uint32_t  EDESP7               :1;
            __IO  uint32_t  EDESP8               :1;
            __IO  uint32_t  EDESP9               :1;
            __IO  uint32_t  EDESP10              :1;
            __IO  uint32_t  EDESP11              :1;
            __IO  uint32_t  EDESP12              :1;
            __IO  uint32_t  EDESP13              :1;
            __IO  uint32_t  RESERVED4            :2;
        };
    };
} stc_dstc_moners_field_t;

/******************************************************************************
 ** DT_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_dt_timer1control_field
{
    union {
        struct {
            __IO  uint32_t  ONESHOT              :1;
            __IO  uint32_t  TIMERSIZE            :1;
            __IO  uint32_t  TIMERPRE             :2;
            __IO  uint32_t  RESERVED1            :1;
            __IO  uint32_t  INTENABLE            :1;
            __IO  uint32_t  TIMERMODE            :1;
            __IO  uint32_t  TIMEREN              :1;
            __IO  uint32_t  RESERVED2            :24;
        };
        struct {
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  TIMERPRE0            :1;
            __IO  uint32_t  TIMERPRE1            :1;
            __IO  uint32_t  RESERVED3            :28;
        };
    };
} stc_dt_timer1control_field_t;

typedef struct stc_dt_timer1ris_field
{
        __IO  uint32_t  TIMER1RIS                :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_dt_timer1ris_field_t;

typedef struct stc_dt_timer1mis_field
{
        __IO  uint32_t  TIMER1MIS                :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_dt_timer1mis_field_t;

typedef struct stc_dt_timer2control_field
{
    union {
        struct {
            __IO  uint32_t  ONESHOT              :1;
            __IO  uint32_t  TIMERSIZE            :1;
            __IO  uint32_t  TIMERPRE             :2;
            __IO  uint32_t  RESERVED1            :1;
            __IO  uint32_t  INTENABLE            :1;
            __IO  uint32_t  TIMERMODE            :1;
            __IO  uint32_t  TIMEREN              :1;
            __IO  uint32_t  RESERVED2            :24;
        };
        struct {
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  TIMERPRE0            :1;
            __IO  uint32_t  TIMERPRE1            :1;
            __IO  uint32_t  RESERVED3            :28;
        };
    };
} stc_dt_timer2control_field_t;

typedef struct stc_dt_timer2ris_field
{
        __IO  uint32_t  TIMER2RIS                :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_dt_timer2ris_field_t;

typedef struct stc_dt_timer2mis_field
{
        __IO  uint32_t  TIMER2MIS                :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_dt_timer2mis_field_t;

/******************************************************************************
 ** ECC_CAPTURE_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_ecc_capture_ferrad_field
{
    union {
        struct {
            __IO  uint32_t  ERRAD                :23;
            __IO  uint32_t  RESERVED0            :9;
        };
        struct {
            __IO  uint32_t  ERRAD0               :1;
            __IO  uint32_t  ERRAD1               :1;
            __IO  uint32_t  ERRAD2               :1;
            __IO  uint32_t  ERRAD3               :1;
            __IO  uint32_t  ERRAD4               :1;
            __IO  uint32_t  ERRAD5               :1;
            __IO  uint32_t  ERRAD6               :1;
            __IO  uint32_t  ERRAD7               :1;
            __IO  uint32_t  ERRAD8               :1;
            __IO  uint32_t  ERRAD9               :1;
            __IO  uint32_t  ERRAD10              :1;
            __IO  uint32_t  ERRAD11              :1;
            __IO  uint32_t  ERRAD12              :1;
            __IO  uint32_t  ERRAD13              :1;
            __IO  uint32_t  ERRAD14              :1;
            __IO  uint32_t  ERRAD15              :1;
            __IO  uint32_t  ERRAD16              :1;
            __IO  uint32_t  ERRAD17              :1;
            __IO  uint32_t  ERRAD18              :1;
            __IO  uint32_t  ERRAD19              :1;
            __IO  uint32_t  ERRAD20              :1;
            __IO  uint32_t  ERRAD21              :1;
            __IO  uint32_t  ERRAD22              :1;
            __IO  uint32_t  RESERVED1            :9;
        };
    };
} stc_ecc_capture_ferrad_field_t;

/******************************************************************************
 ** ETHERNET_CONTROL_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_ethernet_control_eth_mode_field
{
        __IO  uint32_t  IFMODE                   :1;
        __IO  uint32_t  RESERVED0                :7;
        __IO  uint32_t  RST0                     :1;
        __IO  uint32_t  RST1                     :1;
        __IO  uint32_t  RESERVED1                :18;
        __IO  uint32_t  PPSSEL                   :1;
        __IO  uint32_t  RESERVED2                :3;
} stc_ethernet_control_eth_mode_field_t;

typedef struct stc_ethernet_control_eth_clkg_field
{
    union {
        struct {
            __IO  uint32_t  MACEN                :2;
            __IO  uint32_t  RESERVED0            :30;
        };
        struct {
            __IO  uint32_t  MACEN0               :1;
            __IO  uint32_t  MACEN1               :1;
            __IO  uint32_t  RESERVED1            :30;
        };
    };
} stc_ethernet_control_eth_clkg_field_t;

/******************************************************************************
 ** ETHERNET_MAC_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_ethernet_mac_mcr_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  RE                   :1;
            __IO  uint32_t  TE                   :1;
            __IO  uint32_t  DC                   :1;
            __IO  uint32_t  BL                   :2;
            __IO  uint32_t  ACS                  :1;
            __IO  uint32_t  LUD                  :1;
            __IO  uint32_t  DR                   :1;
            __IO  uint32_t  IPC                  :1;
            __IO  uint32_t  DM                   :1;
            __IO  uint32_t  LM                   :1;
            __IO  uint32_t  DO                   :1;
            __IO  uint32_t  FES                  :1;
            __IO  uint32_t  PS                   :1;
            __IO  uint32_t  DCRS                 :1;
            __IO  uint32_t  IFG                  :3;
            __IO  uint32_t  JE                   :1;
            __IO  uint32_t  BE                   :1;
            __IO  uint32_t  JD                   :1;
            __IO  uint32_t  WD                   :1;
            __IO  uint32_t  TC                   :1;
            __IO  uint32_t  CST                  :1;
            __IO  uint32_t  RESERVED3            :6;
        };
        struct {
            __IO  uint32_t  RESERVED1            :5;
            __IO  uint32_t  BL0                  :1;
            __IO  uint32_t  BL1                  :1;
            __IO  uint32_t  RESERVED2            :10;
            __IO  uint32_t  IFG0                 :1;
            __IO  uint32_t  IFG1                 :1;
            __IO  uint32_t  IFG2                 :1;
            __IO  uint32_t  RESERVED4            :12;
        };
    };
} stc_ethernet_mac_mcr_field_t;

typedef struct stc_ethernet_mac_mffr_field
{
    union {
        struct {
            __IO  uint32_t  PR                   :1;
            __IO  uint32_t  HUC                  :1;
            __IO  uint32_t  HMC                  :1;
            __IO  uint32_t  DAIF                 :1;
            __IO  uint32_t  PM                   :1;
            __IO  uint32_t  DB                   :1;
            __IO  uint32_t  PCF                  :2;
            __IO  uint32_t  SAIF                 :1;
            __IO  uint32_t  SAF                  :1;
            __IO  uint32_t  HPF                  :1;
            __IO  uint32_t  RESERVED1            :20;
            __IO  uint32_t  RA                   :1;
        };
        struct {
            __IO  uint32_t  RESERVED0            :6;
            __IO  uint32_t  PCF0                 :1;
            __IO  uint32_t  PCF1                 :1;
            __IO  uint32_t  RESERVED2            :24;
        };
    };
} stc_ethernet_mac_mffr_field_t;

typedef struct stc_ethernet_mac_mhtrh_field
{
    union {
        struct {
            __IO  uint32_t  HTH                  :32;
        };
        struct {
            __IO  uint32_t  HTH0                 :1;
            __IO  uint32_t  HTH1                 :1;
            __IO  uint32_t  HTH2                 :1;
            __IO  uint32_t  HTH3                 :1;
            __IO  uint32_t  HTH4                 :1;
            __IO  uint32_t  HTH5                 :1;
            __IO  uint32_t  HTH6                 :1;
            __IO  uint32_t  HTH7                 :1;
            __IO  uint32_t  HTH8                 :1;
            __IO  uint32_t  HTH9                 :1;
            __IO  uint32_t  HTH10                :1;
            __IO  uint32_t  HTH11                :1;
            __IO  uint32_t  HTH12                :1;
            __IO  uint32_t  HTH13                :1;
            __IO  uint32_t  HTH14                :1;
            __IO  uint32_t  HTH15                :1;
            __IO  uint32_t  HTH16                :1;
            __IO  uint32_t  HTH17                :1;
            __IO  uint32_t  HTH18                :1;
            __IO  uint32_t  HTH19                :1;
            __IO  uint32_t  HTH20                :1;
            __IO  uint32_t  HTH21                :1;
            __IO  uint32_t  HTH22                :1;
            __IO  uint32_t  HTH23                :1;
            __IO  uint32_t  HTH24                :1;
            __IO  uint32_t  HTH25                :1;
            __IO  uint32_t  HTH26                :1;
            __IO  uint32_t  HTH27                :1;
            __IO  uint32_t  HTH28                :1;
            __IO  uint32_t  HTH29                :1;
            __IO  uint32_t  HTH30                :1;
            __IO  uint32_t  HTH31                :1;
        };
    };
} stc_ethernet_mac_mhtrh_field_t;

typedef struct stc_ethernet_mac_mhtrl_field
{
    union {
        struct {
            __IO  uint32_t  HTL                  :32;
        };
        struct {
            __IO  uint32_t  HTL0                 :1;
            __IO  uint32_t  HTL1                 :1;
            __IO  uint32_t  HTL2                 :1;
            __IO  uint32_t  HTL3                 :1;
            __IO  uint32_t  HTL4                 :1;
            __IO  uint32_t  HTL5                 :1;
            __IO  uint32_t  HTL6                 :1;
            __IO  uint32_t  HTL7                 :1;
            __IO  uint32_t  HTL8                 :1;
            __IO  uint32_t  HTL9                 :1;
            __IO  uint32_t  HTL10                :1;
            __IO  uint32_t  HTL11                :1;
            __IO  uint32_t  HTL12                :1;
            __IO  uint32_t  HTL13                :1;
            __IO  uint32_t  HTL14                :1;
            __IO  uint32_t  HTL15                :1;
            __IO  uint32_t  HTL16                :1;
            __IO  uint32_t  HTL17                :1;
            __IO  uint32_t  HTL18                :1;
            __IO  uint32_t  HTL19                :1;
            __IO  uint32_t  HTL20                :1;
            __IO  uint32_t  HTL21                :1;
            __IO  uint32_t  HTL22                :1;
            __IO  uint32_t  HTL23                :1;
            __IO  uint32_t  HTL24                :1;
            __IO  uint32_t  HTL25                :1;
            __IO  uint32_t  HTL26                :1;
            __IO  uint32_t  HTL27                :1;
            __IO  uint32_t  HTL28                :1;
            __IO  uint32_t  HTL29                :1;
            __IO  uint32_t  HTL30                :1;
            __IO  uint32_t  HTL31                :1;
        };
    };
} stc_ethernet_mac_mhtrl_field_t;

typedef struct stc_ethernet_mac_gar_field
{
    union {
        struct {
            __IO  uint32_t  GB                   :1;
            __IO  uint32_t  GW                   :1;
            __IO  uint32_t  CR                   :4;
            __IO  uint32_t  GR                   :5;
            __IO  uint32_t  PA                   :5;
            __IO  uint32_t  RESERVED1            :16;
        };
        struct {
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  CR0                  :1;
            __IO  uint32_t  CR1                  :1;
            __IO  uint32_t  CR2                  :1;
            __IO  uint32_t  CR3                  :1;
            __IO  uint32_t  GR0                  :1;
            __IO  uint32_t  GR1                  :1;
            __IO  uint32_t  GR2                  :1;
            __IO  uint32_t  GR3                  :1;
            __IO  uint32_t  GR4                  :1;
            __IO  uint32_t  PA0                  :1;
            __IO  uint32_t  PA1                  :1;
            __IO  uint32_t  PA2                  :1;
            __IO  uint32_t  PA3                  :1;
            __IO  uint32_t  PA4                  :1;
            __IO  uint32_t  RESERVED2            :16;
        };
    };
} stc_ethernet_mac_gar_field_t;

typedef struct stc_ethernet_mac_gdr_field
{
    union {
        struct {
            __IO  uint32_t  GD                   :16;
            __IO  uint32_t  RESERVED0            :16;
        };
        struct {
            __IO  uint32_t  GD0                  :1;
            __IO  uint32_t  GD1                  :1;
            __IO  uint32_t  GD2                  :1;
            __IO  uint32_t  GD3                  :1;
            __IO  uint32_t  GD4                  :1;
            __IO  uint32_t  GD5                  :1;
            __IO  uint32_t  GD6                  :1;
            __IO  uint32_t  GD7                  :1;
            __IO  uint32_t  GD8                  :1;
            __IO  uint32_t  GD9                  :1;
            __IO  uint32_t  GD10                 :1;
            __IO  uint32_t  GD11                 :1;
            __IO  uint32_t  GD12                 :1;
            __IO  uint32_t  GD13                 :1;
            __IO  uint32_t  GD14                 :1;
            __IO  uint32_t  GD15                 :1;
            __IO  uint32_t  RESERVED1            :16;
        };
    };
} stc_ethernet_mac_gdr_field_t;

typedef struct stc_ethernet_mac_fcr_field
{
    union {
        struct {
            __IO  uint32_t  FCB_BPA              :1;
            __IO  uint32_t  TFE                  :1;
            __IO  uint32_t  RFE                  :1;
            __IO  uint32_t  UP                   :1;
            __IO  uint32_t  PLT                  :2;
            __IO  uint32_t  RESERVED1            :1;
            __IO  uint32_t  DZPQ                 :1;
            __IO  uint32_t  RESERVED2            :8;
            __IO  uint32_t  PT                   :16;
        };
        struct {
            __IO  uint32_t  RESERVED0            :4;
            __IO  uint32_t  PLT0                 :1;
            __IO  uint32_t  PLT1                 :1;
            __IO  uint32_t  RESERVED3            :10;
            __IO  uint32_t  PT0                  :1;
            __IO  uint32_t  PT1                  :1;
            __IO  uint32_t  PT2                  :1;
            __IO  uint32_t  PT3                  :1;
            __IO  uint32_t  PT4                  :1;
            __IO  uint32_t  PT5                  :1;
            __IO  uint32_t  PT6                  :1;
            __IO  uint32_t  PT7                  :1;
            __IO  uint32_t  PT8                  :1;
            __IO  uint32_t  PT9                  :1;
            __IO  uint32_t  PT10                 :1;
            __IO  uint32_t  PT11                 :1;
            __IO  uint32_t  PT12                 :1;
            __IO  uint32_t  PT13                 :1;
            __IO  uint32_t  PT14                 :1;
            __IO  uint32_t  PT15                 :1;
        };
    };
} stc_ethernet_mac_fcr_field_t;

typedef struct stc_ethernet_mac_vtr_field
{
    union {
        struct {
            __IO  uint32_t  VL                   :16;
            __IO  uint32_t  ETV                  :1;
            __IO  uint32_t  RESERVED0            :15;
        };
        struct {
            __IO  uint32_t  VL0                  :1;
            __IO  uint32_t  VL1                  :1;
            __IO  uint32_t  VL2                  :1;
            __IO  uint32_t  VL3                  :1;
            __IO  uint32_t  VL4                  :1;
            __IO  uint32_t  VL5                  :1;
            __IO  uint32_t  VL6                  :1;
            __IO  uint32_t  VL7                  :1;
            __IO  uint32_t  VL8                  :1;
            __IO  uint32_t  VL9                  :1;
            __IO  uint32_t  VL10                 :1;
            __IO  uint32_t  VL11                 :1;
            __IO  uint32_t  VL12                 :1;
            __IO  uint32_t  VL13                 :1;
            __IO  uint32_t  VL14                 :1;
            __IO  uint32_t  VL15                 :1;
            __IO  uint32_t  RESERVED1            :16;
        };
    };
} stc_ethernet_mac_vtr_field_t;

typedef struct stc_ethernet_mac_rwffr_field
{
    union {
        struct {
            __IO  uint32_t  RWFFR                :32;
        };
        struct {
            __IO  uint32_t  RWFFR0               :1;
            __IO  uint32_t  RWFFR1               :1;
            __IO  uint32_t  RWFFR2               :1;
            __IO  uint32_t  RWFFR3               :1;
            __IO  uint32_t  RWFFR4               :1;
            __IO  uint32_t  RWFFR5               :1;
            __IO  uint32_t  RWFFR6               :1;
            __IO  uint32_t  RWFFR7               :1;
            __IO  uint32_t  RWFFR8               :1;
            __IO  uint32_t  RWFFR9               :1;
            __IO  uint32_t  RWFFR10              :1;
            __IO  uint32_t  RWFFR11              :1;
            __IO  uint32_t  RWFFR12              :1;
            __IO  uint32_t  RWFFR13              :1;
            __IO  uint32_t  RWFFR14              :1;
            __IO  uint32_t  RWFFR15              :1;
            __IO  uint32_t  RWFFR16              :1;
            __IO  uint32_t  RWFFR17              :1;
            __IO  uint32_t  RWFFR18              :1;
            __IO  uint32_t  RWFFR19              :1;
            __IO  uint32_t  RWFFR20              :1;
            __IO  uint32_t  RWFFR21              :1;
            __IO  uint32_t  RWFFR22              :1;
            __IO  uint32_t  RWFFR23              :1;
            __IO  uint32_t  RWFFR24              :1;
            __IO  uint32_t  RWFFR25              :1;
            __IO  uint32_t  RWFFR26              :1;
            __IO  uint32_t  RWFFR27              :1;
            __IO  uint32_t  RWFFR28              :1;
            __IO  uint32_t  RWFFR29              :1;
            __IO  uint32_t  RWFFR30              :1;
            __IO  uint32_t  RWFFR31              :1;
        };
    };
} stc_ethernet_mac_rwffr_field_t;

typedef struct stc_ethernet_mac_pmtr_field
{
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  MPE                      :1;
        __IO  uint32_t  WFE                      :1;
        __IO  uint32_t  RESERVED0                :2;
        __IO  uint32_t  MPR                      :1;
        __IO  uint32_t  WPR                      :1;
        __IO  uint32_t  RESERVED1                :2;
        __IO  uint32_t  GU                       :1;
        __IO  uint32_t  RESERVED2                :21;
        __IO  uint32_t  RWFFRPR                  :1;
} stc_ethernet_mac_pmtr_field_t;

typedef struct stc_ethernet_mac_lpicsr_field
{
        __IO  uint32_t  TLPIEN                   :1;
        __IO  uint32_t  TLPIEX                   :1;
        __IO  uint32_t  RLPIEN                   :1;
        __IO  uint32_t  RLPIEX                   :1;
        __IO  uint32_t  RESERVED0                :4;
        __IO  uint32_t  TLPIST                   :1;
        __IO  uint32_t  RLPIST                   :1;
        __IO  uint32_t  RESERVED1                :6;
        __IO  uint32_t  LPIEN                    :1;
        __IO  uint32_t  PLS                      :1;
        __IO  uint32_t  PLSEN                    :1;
        __IO  uint32_t  LPITXA                   :1;
        __IO  uint32_t  RESERVED2                :12;
} stc_ethernet_mac_lpicsr_field_t;

typedef struct stc_ethernet_mac_lpitcr_field
{
    union {
        struct {
            __IO  uint32_t  TWT                  :16;
            __IO  uint32_t  LIT                  :10;
            __IO  uint32_t  RESERVED0            :6;
        };
        struct {
            __IO  uint32_t  TWT0                 :1;
            __IO  uint32_t  TWT1                 :1;
            __IO  uint32_t  TWT2                 :1;
            __IO  uint32_t  TWT3                 :1;
            __IO  uint32_t  TWT4                 :1;
            __IO  uint32_t  TWT5                 :1;
            __IO  uint32_t  TWT6                 :1;
            __IO  uint32_t  TWT7                 :1;
            __IO  uint32_t  TWT8                 :1;
            __IO  uint32_t  TWT9                 :1;
            __IO  uint32_t  TWT10                :1;
            __IO  uint32_t  TWT11                :1;
            __IO  uint32_t  TWT12                :1;
            __IO  uint32_t  TWT13                :1;
            __IO  uint32_t  TWT14                :1;
            __IO  uint32_t  TWT15                :1;
            __IO  uint32_t  LIT0                 :1;
            __IO  uint32_t  LIT1                 :1;
            __IO  uint32_t  LIT2                 :1;
            __IO  uint32_t  LIT3                 :1;
            __IO  uint32_t  LIT4                 :1;
            __IO  uint32_t  LIT5                 :1;
            __IO  uint32_t  LIT6                 :1;
            __IO  uint32_t  LIT7                 :1;
            __IO  uint32_t  LIT8                 :1;
            __IO  uint32_t  LIT9                 :1;
            __IO  uint32_t  RESERVED1            :6;
        };
    };
} stc_ethernet_mac_lpitcr_field_t;

typedef struct stc_ethernet_mac_isr_field
{
        __IO  uint32_t  RGIS                     :1;
        __IO  uint32_t  RESERVED0                :2;
        __IO  uint32_t  PIS                      :1;
        __IO  uint32_t  MIS                      :1;
        __IO  uint32_t  RIS                      :1;
        __IO  uint32_t  TIS                      :1;
        __IO  uint32_t  COIS                     :1;
        __IO  uint32_t  RESERVED1                :1;
        __IO  uint32_t  TSIS                     :1;
        __IO  uint32_t  LPIIS                    :1;
        __IO  uint32_t  RESERVED2                :21;
} stc_ethernet_mac_isr_field_t;

typedef struct stc_ethernet_mac_imr_field
{
        __IO  uint32_t  RGIM                     :1;
        __IO  uint32_t  RESERVED0                :2;
        __IO  uint32_t  PIM                      :1;
        __IO  uint32_t  RESERVED1                :5;
        __IO  uint32_t  TSIM                     :1;
        __IO  uint32_t  LPIIM                    :1;
        __IO  uint32_t  RESERVED2                :21;
} stc_ethernet_mac_imr_field_t;

typedef struct stc_ethernet_mac_mar0h_field
{
    union {
        struct {
            __IO  uint32_t  A0                   :16;
            __IO  uint32_t  RESERVED0            :15;
            __IO  uint32_t  MO                   :1;
        };
        struct {
            __IO  uint32_t  A00                  :1;
            __IO  uint32_t  A01                  :1;
            __IO  uint32_t  A02                  :1;
            __IO  uint32_t  A03                  :1;
            __IO  uint32_t  A04                  :1;
            __IO  uint32_t  A05                  :1;
            __IO  uint32_t  A06                  :1;
            __IO  uint32_t  A07                  :1;
            __IO  uint32_t  A08                  :1;
            __IO  uint32_t  A09                  :1;
            __IO  uint32_t  A010                 :1;
            __IO  uint32_t  A011                 :1;
            __IO  uint32_t  A012                 :1;
            __IO  uint32_t  A013                 :1;
            __IO  uint32_t  A014                 :1;
            __IO  uint32_t  A015                 :1;
            __IO  uint32_t  RESERVED1            :16;
        };
    };
} stc_ethernet_mac_mar0h_field_t;

typedef struct stc_ethernet_mac_mar0l_field
{
    union {
        struct {
            __IO  uint32_t  A0                   :32;
        };
        struct {
            __IO  uint32_t  A00                  :1;
            __IO  uint32_t  A01                  :1;
            __IO  uint32_t  A02                  :1;
            __IO  uint32_t  A03                  :1;
            __IO  uint32_t  A04                  :1;
            __IO  uint32_t  A05                  :1;
            __IO  uint32_t  A06                  :1;
            __IO  uint32_t  A07                  :1;
            __IO  uint32_t  A08                  :1;
            __IO  uint32_t  A09                  :1;
            __IO  uint32_t  A010                 :1;
            __IO  uint32_t  A011                 :1;
            __IO  uint32_t  A012                 :1;
            __IO  uint32_t  A013                 :1;
            __IO  uint32_t  A014                 :1;
            __IO  uint32_t  A015                 :1;
            __IO  uint32_t  A016                 :1;
            __IO  uint32_t  A017                 :1;
            __IO  uint32_t  A018                 :1;
            __IO  uint32_t  A019                 :1;
            __IO  uint32_t  A020                 :1;
            __IO  uint32_t  A021                 :1;
            __IO  uint32_t  A022                 :1;
            __IO  uint32_t  A023                 :1;
            __IO  uint32_t  A024                 :1;
            __IO  uint32_t  A025                 :1;
            __IO  uint32_t  A026                 :1;
            __IO  uint32_t  A027                 :1;
            __IO  uint32_t  A028                 :1;
            __IO  uint32_t  A029                 :1;
            __IO  uint32_t  A030                 :1;
            __IO  uint32_t  A031                 :1;
        };
    };
} stc_ethernet_mac_mar0l_field_t;

typedef struct stc_ethernet_mac_mar1h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar1h_field_t;

typedef struct stc_ethernet_mac_mar1l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar1l_field_t;

typedef struct stc_ethernet_mac_mar2h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar2h_field_t;

typedef struct stc_ethernet_mac_mar2l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar2l_field_t;

typedef struct stc_ethernet_mac_mar3h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar3h_field_t;

typedef struct stc_ethernet_mac_mar3l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar3l_field_t;

typedef struct stc_ethernet_mac_mar4h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar4h_field_t;

typedef struct stc_ethernet_mac_mar4l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar4l_field_t;

typedef struct stc_ethernet_mac_mar5h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar5h_field_t;

typedef struct stc_ethernet_mac_mar5l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar5l_field_t;

typedef struct stc_ethernet_mac_mar6h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar6h_field_t;

typedef struct stc_ethernet_mac_mar6l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar6l_field_t;

typedef struct stc_ethernet_mac_mar7h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar7h_field_t;

typedef struct stc_ethernet_mac_mar7l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar7l_field_t;

typedef struct stc_ethernet_mac_mar8h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar8h_field_t;

typedef struct stc_ethernet_mac_mar8l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar8l_field_t;

typedef struct stc_ethernet_mac_mar9h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar9h_field_t;

typedef struct stc_ethernet_mac_mar9l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar9l_field_t;

typedef struct stc_ethernet_mac_mar10h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar10h_field_t;

typedef struct stc_ethernet_mac_mar10l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar10l_field_t;

typedef struct stc_ethernet_mac_mar11h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar11h_field_t;

typedef struct stc_ethernet_mac_mar11l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar11l_field_t;

typedef struct stc_ethernet_mac_mar12h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar12h_field_t;

typedef struct stc_ethernet_mac_mar12l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar12l_field_t;

typedef struct stc_ethernet_mac_mar13h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar13h_field_t;

typedef struct stc_ethernet_mac_mar13l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar13l_field_t;

typedef struct stc_ethernet_mac_mar14h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar14h_field_t;

typedef struct stc_ethernet_mac_mar14l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar14l_field_t;

typedef struct stc_ethernet_mac_mar15h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar15h_field_t;

typedef struct stc_ethernet_mac_mar15l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar15l_field_t;

typedef struct stc_ethernet_mac_rgsr_field
{
    union {
        struct {
            __IO  uint32_t  LM                   :1;
            __IO  uint32_t  LSP                  :2;
            __IO  uint32_t  LS                   :1;
            __IO  uint32_t  RESERVED1            :28;
        };
        struct {
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  LSP0                 :1;
            __IO  uint32_t  LSP1                 :1;
            __IO  uint32_t  RESERVED2            :29;
        };
    };
} stc_ethernet_mac_rgsr_field_t;

typedef struct stc_ethernet_mac_mmc_cntl_field
{
    union {
        struct {
            __IO  uint32_t  B                    :6;
            __IO  uint32_t  RESERVED0            :26;
        };
        struct {
            __IO  uint32_t  B0                   :1;
            __IO  uint32_t  B1                   :1;
            __IO  uint32_t  B2                   :1;
            __IO  uint32_t  B3                   :1;
            __IO  uint32_t  B4                   :1;
            __IO  uint32_t  B5                   :1;
            __IO  uint32_t  RESERVED1            :26;
        };
    };
} stc_ethernet_mac_mmc_cntl_field_t;

typedef struct stc_ethernet_mac_mmc_intr_rx_field
{
    union {
        struct {
            __IO  uint32_t  B                    :24;
            __IO  uint32_t  RESERVED0            :8;
        };
        struct {
            __IO  uint32_t  B0                   :1;
            __IO  uint32_t  B1                   :1;
            __IO  uint32_t  B2                   :1;
            __IO  uint32_t  B3                   :1;
            __IO  uint32_t  B4                   :1;
            __IO  uint32_t  B5                   :1;
            __IO  uint32_t  B6                   :1;
            __IO  uint32_t  B7                   :1;
            __IO  uint32_t  B8                   :1;
            __IO  uint32_t  B9                   :1;
            __IO  uint32_t  B10                  :1;
            __IO  uint32_t  B11                  :1;
            __IO  uint32_t  B12                  :1;
            __IO  uint32_t  B13                  :1;
            __IO  uint32_t  B14                  :1;
            __IO  uint32_t  B15                  :1;
            __IO  uint32_t  B16                  :1;
            __IO  uint32_t  B17                  :1;
            __IO  uint32_t  B18                  :1;
            __IO  uint32_t  B19                  :1;
            __IO  uint32_t  B20                  :1;
            __IO  uint32_t  B21                  :1;
            __IO  uint32_t  B22                  :1;
            __IO  uint32_t  B23                  :1;
            __IO  uint32_t  RESERVED1            :8;
        };
    };
} stc_ethernet_mac_mmc_intr_rx_field_t;

typedef struct stc_ethernet_mac_mmc_intr_tx_field
{
    union {
        struct {
            __IO  uint32_t  B                    :25;
            __IO  uint32_t  RESERVED0            :7;
        };
        struct {
            __IO  uint32_t  B0                   :1;
            __IO  uint32_t  B1                   :1;
            __IO  uint32_t  B2                   :1;
            __IO  uint32_t  B3                   :1;
            __IO  uint32_t  B4                   :1;
            __IO  uint32_t  B5                   :1;
            __IO  uint32_t  B6                   :1;
            __IO  uint32_t  B7                   :1;
            __IO  uint32_t  B8                   :1;
            __IO  uint32_t  B9                   :1;
            __IO  uint32_t  B10                  :1;
            __IO  uint32_t  B11                  :1;
            __IO  uint32_t  B12                  :1;
            __IO  uint32_t  B13                  :1;
            __IO  uint32_t  B14                  :1;
            __IO  uint32_t  B15                  :1;
            __IO  uint32_t  B16                  :1;
            __IO  uint32_t  B17                  :1;
            __IO  uint32_t  B18                  :1;
            __IO  uint32_t  B19                  :1;
            __IO  uint32_t  B20                  :1;
            __IO  uint32_t  B21                  :1;
            __IO  uint32_t  B22                  :1;
            __IO  uint32_t  B23                  :1;
            __IO  uint32_t  B24                  :1;
            __IO  uint32_t  RESERVED1            :7;
        };
    };
} stc_ethernet_mac_mmc_intr_tx_field_t;

typedef struct stc_ethernet_mac_mmc_intr_mask_rx_field
{
    union {
        struct {
            __IO  uint32_t  B                    :24;
            __IO  uint32_t  RESERVED0            :8;
        };
        struct {
            __IO  uint32_t  B0                   :1;
            __IO  uint32_t  B1                   :1;
            __IO  uint32_t  B2                   :1;
            __IO  uint32_t  B3                   :1;
            __IO  uint32_t  B4                   :1;
            __IO  uint32_t  B5                   :1;
            __IO  uint32_t  B6                   :1;
            __IO  uint32_t  B7                   :1;
            __IO  uint32_t  B8                   :1;
            __IO  uint32_t  B9                   :1;
            __IO  uint32_t  B10                  :1;
            __IO  uint32_t  B11                  :1;
            __IO  uint32_t  B12                  :1;
            __IO  uint32_t  B13                  :1;
            __IO  uint32_t  B14                  :1;
            __IO  uint32_t  B15                  :1;
            __IO  uint32_t  B16                  :1;
            __IO  uint32_t  B17                  :1;
            __IO  uint32_t  B18                  :1;
            __IO  uint32_t  B19                  :1;
            __IO  uint32_t  B20                  :1;
            __IO  uint32_t  B21                  :1;
            __IO  uint32_t  B22                  :1;
            __IO  uint32_t  B23                  :1;
            __IO  uint32_t  RESERVED1            :8;
        };
    };
} stc_ethernet_mac_mmc_intr_mask_rx_field_t;

typedef struct stc_ethernet_mac_mmc_intr_mask_tx_field
{
    union {
        struct {
            __IO  uint32_t  B                    :25;
            __IO  uint32_t  RESERVED0            :7;
        };
        struct {
            __IO  uint32_t  B0                   :1;
            __IO  uint32_t  B1                   :1;
            __IO  uint32_t  B2                   :1;
            __IO  uint32_t  B3                   :1;
            __IO  uint32_t  B4                   :1;
            __IO  uint32_t  B5                   :1;
            __IO  uint32_t  B6                   :1;
            __IO  uint32_t  B7                   :1;
            __IO  uint32_t  B8                   :1;
            __IO  uint32_t  B9                   :1;
            __IO  uint32_t  B10                  :1;
            __IO  uint32_t  B11                  :1;
            __IO  uint32_t  B12                  :1;
            __IO  uint32_t  B13                  :1;
            __IO  uint32_t  B14                  :1;
            __IO  uint32_t  B15                  :1;
            __IO  uint32_t  B16                  :1;
            __IO  uint32_t  B17                  :1;
            __IO  uint32_t  B18                  :1;
            __IO  uint32_t  B19                  :1;
            __IO  uint32_t  B20                  :1;
            __IO  uint32_t  B21                  :1;
            __IO  uint32_t  B22                  :1;
            __IO  uint32_t  B23                  :1;
            __IO  uint32_t  B24                  :1;
            __IO  uint32_t  RESERVED1            :7;
        };
    };
} stc_ethernet_mac_mmc_intr_mask_tx_field_t;

typedef struct stc_ethernet_mac_mmc_ipc_intr_mask_rx_field
{
    union {
        struct {
            __IO  uint32_t  BL                   :14;
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  BH                   :14;
            __IO  uint32_t  RESERVED2            :2;
        };
        struct {
            __IO  uint32_t  BL0                  :1;
            __IO  uint32_t  BL1                  :1;
            __IO  uint32_t  BL2                  :1;
            __IO  uint32_t  BL3                  :1;
            __IO  uint32_t  BL4                  :1;
            __IO  uint32_t  BL5                  :1;
            __IO  uint32_t  BL6                  :1;
            __IO  uint32_t  BL7                  :1;
            __IO  uint32_t  BL8                  :1;
            __IO  uint32_t  BL9                  :1;
            __IO  uint32_t  BL10                 :1;
            __IO  uint32_t  BL11                 :1;
            __IO  uint32_t  BL12                 :1;
            __IO  uint32_t  BL13                 :1;
            __IO  uint32_t  RESERVED1            :2;
            __IO  uint32_t  BH0                  :1;
            __IO  uint32_t  BH1                  :1;
            __IO  uint32_t  BH2                  :1;
            __IO  uint32_t  BH3                  :1;
            __IO  uint32_t  BH4                  :1;
            __IO  uint32_t  BH5                  :1;
            __IO  uint32_t  BH6                  :1;
            __IO  uint32_t  BH7                  :1;
            __IO  uint32_t  BH8                  :1;
            __IO  uint32_t  BH9                  :1;
            __IO  uint32_t  BH10                 :1;
            __IO  uint32_t  BH11                 :1;
            __IO  uint32_t  BH12                 :1;
            __IO  uint32_t  BH13                 :1;
            __IO  uint32_t  RESERVED3            :2;
        };
    };
} stc_ethernet_mac_mmc_ipc_intr_mask_rx_field_t;

typedef struct stc_ethernet_mac_mmc_ipc_intr_rx_field
{
    union {
        struct {
            __IO  uint32_t  BL                   :14;
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  BH                   :14;
            __IO  uint32_t  RESERVED2            :2;
        };
        struct {
            __IO  uint32_t  BL0                  :1;
            __IO  uint32_t  BL1                  :1;
            __IO  uint32_t  BL2                  :1;
            __IO  uint32_t  BL3                  :1;
            __IO  uint32_t  BL4                  :1;
            __IO  uint32_t  BL5                  :1;
            __IO  uint32_t  BL6                  :1;
            __IO  uint32_t  BL7                  :1;
            __IO  uint32_t  BL8                  :1;
            __IO  uint32_t  BL9                  :1;
            __IO  uint32_t  BL10                 :1;
            __IO  uint32_t  BL11                 :1;
            __IO  uint32_t  BL12                 :1;
            __IO  uint32_t  BL13                 :1;
            __IO  uint32_t  RESERVED1            :2;
            __IO  uint32_t  BH0                  :1;
            __IO  uint32_t  BH1                  :1;
            __IO  uint32_t  BH2                  :1;
            __IO  uint32_t  BH3                  :1;
            __IO  uint32_t  BH4                  :1;
            __IO  uint32_t  BH5                  :1;
            __IO  uint32_t  BH6                  :1;
            __IO  uint32_t  BH7                  :1;
            __IO  uint32_t  BH8                  :1;
            __IO  uint32_t  BH9                  :1;
            __IO  uint32_t  BH10                 :1;
            __IO  uint32_t  BH11                 :1;
            __IO  uint32_t  BH12                 :1;
            __IO  uint32_t  BH13                 :1;
            __IO  uint32_t  RESERVED3            :2;
        };
    };
} stc_ethernet_mac_mmc_ipc_intr_rx_field_t;

typedef struct stc_ethernet_mac_tscr_field
{
    union {
        struct {
            __IO  uint32_t  TSE                  :1;
            __IO  uint32_t  TFCU                 :1;
            __IO  uint32_t  TSI                  :1;
            __IO  uint32_t  TSU                  :1;
            __IO  uint32_t  TITE                 :1;
            __IO  uint32_t  TARU                 :1;
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  TSEA                 :1;
            __IO  uint32_t  TSDB                 :1;
            __IO  uint32_t  TSV2E                :1;
            __IO  uint32_t  TETSP                :1;
            __IO  uint32_t  TSIP6E               :1;
            __IO  uint32_t  TSIP4E               :1;
            __IO  uint32_t  TETSEM               :1;
            __IO  uint32_t  TSMRM                :1;
            __IO  uint32_t  TSPS                 :2;
            __IO  uint32_t  TSENMF               :1;
            __IO  uint32_t  RESERVED2            :5;
            __IO  uint32_t  ATSFC                :1;
            __IO  uint32_t  RESERVED3            :7;
        };
        struct {
            __IO  uint32_t  RESERVED1            :16;
            __IO  uint32_t  TSPS0                :1;
            __IO  uint32_t  TSPS1                :1;
            __IO  uint32_t  RESERVED4            :14;
        };
    };
} stc_ethernet_mac_tscr_field_t;

typedef struct stc_ethernet_mac_ssir_field
{
    union {
        struct {
            __IO  uint32_t  SSINC                :8;
            __IO  uint32_t  RESERVED0            :24;
        };
        struct {
            __IO  uint32_t  SSINC0               :1;
            __IO  uint32_t  SSINC1               :1;
            __IO  uint32_t  SSINC2               :1;
            __IO  uint32_t  SSINC3               :1;
            __IO  uint32_t  SSINC4               :1;
            __IO  uint32_t  SSINC5               :1;
            __IO  uint32_t  SSINC6               :1;
            __IO  uint32_t  SSINC7               :1;
            __IO  uint32_t  RESERVED1            :24;
        };
    };
} stc_ethernet_mac_ssir_field_t;

typedef struct stc_ethernet_mac_stsr_field
{
    union {
        struct {
            __IO  uint32_t  TSS                  :32;
        };
        struct {
            __IO  uint32_t  TSS0                 :1;
            __IO  uint32_t  TSS1                 :1;
            __IO  uint32_t  TSS2                 :1;
            __IO  uint32_t  TSS3                 :1;
            __IO  uint32_t  TSS4                 :1;
            __IO  uint32_t  TSS5                 :1;
            __IO  uint32_t  TSS6                 :1;
            __IO  uint32_t  TSS7                 :1;
            __IO  uint32_t  TSS8                 :1;
            __IO  uint32_t  TSS9                 :1;
            __IO  uint32_t  TSS10                :1;
            __IO  uint32_t  TSS11                :1;
            __IO  uint32_t  TSS12                :1;
            __IO  uint32_t  TSS13                :1;
            __IO  uint32_t  TSS14                :1;
            __IO  uint32_t  TSS15                :1;
            __IO  uint32_t  TSS16                :1;
            __IO  uint32_t  TSS17                :1;
            __IO  uint32_t  TSS18                :1;
            __IO  uint32_t  TSS19                :1;
            __IO  uint32_t  TSS20                :1;
            __IO  uint32_t  TSS21                :1;
            __IO  uint32_t  TSS22                :1;
            __IO  uint32_t  TSS23                :1;
            __IO  uint32_t  TSS24                :1;
            __IO  uint32_t  TSS25                :1;
            __IO  uint32_t  TSS26                :1;
            __IO  uint32_t  TSS27                :1;
            __IO  uint32_t  TSS28                :1;
            __IO  uint32_t  TSS29                :1;
            __IO  uint32_t  TSS30                :1;
            __IO  uint32_t  TSS31                :1;
        };
    };
} stc_ethernet_mac_stsr_field_t;

typedef struct stc_ethernet_mac_stnr_field
{
    union {
        struct {
            __IO  uint32_t  TSSS                 :31;
            __IO  uint32_t  RESERVED0            :1;
        };
        struct {
            __IO  uint32_t  TSSS0                :1;
            __IO  uint32_t  TSSS1                :1;
            __IO  uint32_t  TSSS2                :1;
            __IO  uint32_t  TSSS3                :1;
            __IO  uint32_t  TSSS4                :1;
            __IO  uint32_t  TSSS5                :1;
            __IO  uint32_t  TSSS6                :1;
            __IO  uint32_t  TSSS7                :1;
            __IO  uint32_t  TSSS8                :1;
            __IO  uint32_t  TSSS9                :1;
            __IO  uint32_t  TSSS10               :1;
            __IO  uint32_t  TSSS11               :1;
            __IO  uint32_t  TSSS12               :1;
            __IO  uint32_t  TSSS13               :1;
            __IO  uint32_t  TSSS14               :1;
            __IO  uint32_t  TSSS15               :1;
            __IO  uint32_t  TSSS16               :1;
            __IO  uint32_t  TSSS17               :1;
            __IO  uint32_t  TSSS18               :1;
            __IO  uint32_t  TSSS19               :1;
            __IO  uint32_t  TSSS20               :1;
            __IO  uint32_t  TSSS21               :1;
            __IO  uint32_t  TSSS22               :1;
            __IO  uint32_t  TSSS23               :1;
            __IO  uint32_t  TSSS24               :1;
            __IO  uint32_t  TSSS25               :1;
            __IO  uint32_t  TSSS26               :1;
            __IO  uint32_t  TSSS27               :1;
            __IO  uint32_t  TSSS28               :1;
            __IO  uint32_t  TSSS29               :1;
            __IO  uint32_t  TSSS30               :1;
            __IO  uint32_t  RESERVED1            :1;
        };
    };
} stc_ethernet_mac_stnr_field_t;

typedef struct stc_ethernet_mac_stsur_field
{
    union {
        struct {
            __IO  uint32_t  TSS                  :32;
        };
        struct {
            __IO  uint32_t  TSS0                 :1;
            __IO  uint32_t  TSS1                 :1;
            __IO  uint32_t  TSS2                 :1;
            __IO  uint32_t  TSS3                 :1;
            __IO  uint32_t  TSS4                 :1;
            __IO  uint32_t  TSS5                 :1;
            __IO  uint32_t  TSS6                 :1;
            __IO  uint32_t  TSS7                 :1;
            __IO  uint32_t  TSS8                 :1;
            __IO  uint32_t  TSS9                 :1;
            __IO  uint32_t  TSS10                :1;
            __IO  uint32_t  TSS11                :1;
            __IO  uint32_t  TSS12                :1;
            __IO  uint32_t  TSS13                :1;
            __IO  uint32_t  TSS14                :1;
            __IO  uint32_t  TSS15                :1;
            __IO  uint32_t  TSS16                :1;
            __IO  uint32_t  TSS17                :1;
            __IO  uint32_t  TSS18                :1;
            __IO  uint32_t  TSS19                :1;
            __IO  uint32_t  TSS20                :1;
            __IO  uint32_t  TSS21                :1;
            __IO  uint32_t  TSS22                :1;
            __IO  uint32_t  TSS23                :1;
            __IO  uint32_t  TSS24                :1;
            __IO  uint32_t  TSS25                :1;
            __IO  uint32_t  TSS26                :1;
            __IO  uint32_t  TSS27                :1;
            __IO  uint32_t  TSS28                :1;
            __IO  uint32_t  TSS29                :1;
            __IO  uint32_t  TSS30                :1;
            __IO  uint32_t  TSS31                :1;
        };
    };
} stc_ethernet_mac_stsur_field_t;

typedef struct stc_ethernet_mac_stnur_field
{
    union {
        struct {
            __IO  uint32_t  TSSS                 :31;
            __IO  uint32_t  ADDSUB               :1;
        };
        struct {
            __IO  uint32_t  TSSS0                :1;
            __IO  uint32_t  TSSS1                :1;
            __IO  uint32_t  TSSS2                :1;
            __IO  uint32_t  TSSS3                :1;
            __IO  uint32_t  TSSS4                :1;
            __IO  uint32_t  TSSS5                :1;
            __IO  uint32_t  TSSS6                :1;
            __IO  uint32_t  TSSS7                :1;
            __IO  uint32_t  TSSS8                :1;
            __IO  uint32_t  TSSS9                :1;
            __IO  uint32_t  TSSS10               :1;
            __IO  uint32_t  TSSS11               :1;
            __IO  uint32_t  TSSS12               :1;
            __IO  uint32_t  TSSS13               :1;
            __IO  uint32_t  TSSS14               :1;
            __IO  uint32_t  TSSS15               :1;
            __IO  uint32_t  TSSS16               :1;
            __IO  uint32_t  TSSS17               :1;
            __IO  uint32_t  TSSS18               :1;
            __IO  uint32_t  TSSS19               :1;
            __IO  uint32_t  TSSS20               :1;
            __IO  uint32_t  TSSS21               :1;
            __IO  uint32_t  TSSS22               :1;
            __IO  uint32_t  TSSS23               :1;
            __IO  uint32_t  TSSS24               :1;
            __IO  uint32_t  TSSS25               :1;
            __IO  uint32_t  TSSS26               :1;
            __IO  uint32_t  TSSS27               :1;
            __IO  uint32_t  TSSS28               :1;
            __IO  uint32_t  TSSS29               :1;
            __IO  uint32_t  TSSS30               :1;
            __IO  uint32_t  RESERVED0            :1;
        };
    };
} stc_ethernet_mac_stnur_field_t;

typedef struct stc_ethernet_mac_tsar_field
{
    union {
        struct {
            __IO  uint32_t  TSAR                 :32;
        };
        struct {
            __IO  uint32_t  TSAR0                :1;
            __IO  uint32_t  TSAR1                :1;
            __IO  uint32_t  TSAR2                :1;
            __IO  uint32_t  TSAR3                :1;
            __IO  uint32_t  TSAR4                :1;
            __IO  uint32_t  TSAR5                :1;
            __IO  uint32_t  TSAR6                :1;
            __IO  uint32_t  TSAR7                :1;
            __IO  uint32_t  TSAR8                :1;
            __IO  uint32_t  TSAR9                :1;
            __IO  uint32_t  TSAR10               :1;
            __IO  uint32_t  TSAR11               :1;
            __IO  uint32_t  TSAR12               :1;
            __IO  uint32_t  TSAR13               :1;
            __IO  uint32_t  TSAR14               :1;
            __IO  uint32_t  TSAR15               :1;
            __IO  uint32_t  TSAR16               :1;
            __IO  uint32_t  TSAR17               :1;
            __IO  uint32_t  TSAR18               :1;
            __IO  uint32_t  TSAR19               :1;
            __IO  uint32_t  TSAR20               :1;
            __IO  uint32_t  TSAR21               :1;
            __IO  uint32_t  TSAR22               :1;
            __IO  uint32_t  TSAR23               :1;
            __IO  uint32_t  TSAR24               :1;
            __IO  uint32_t  TSAR25               :1;
            __IO  uint32_t  TSAR26               :1;
            __IO  uint32_t  TSAR27               :1;
            __IO  uint32_t  TSAR28               :1;
            __IO  uint32_t  TSAR29               :1;
            __IO  uint32_t  TSAR30               :1;
            __IO  uint32_t  TSAR31               :1;
        };
    };
} stc_ethernet_mac_tsar_field_t;

typedef struct stc_ethernet_mac_ttsr_field
{
    union {
        struct {
            __IO  uint32_t  TSTR                 :32;
        };
        struct {
            __IO  uint32_t  TSTR0                :1;
            __IO  uint32_t  TSTR1                :1;
            __IO  uint32_t  TSTR2                :1;
            __IO  uint32_t  TSTR3                :1;
            __IO  uint32_t  TSTR4                :1;
            __IO  uint32_t  TSTR5                :1;
            __IO  uint32_t  TSTR6                :1;
            __IO  uint32_t  TSTR7                :1;
            __IO  uint32_t  TSTR8                :1;
            __IO  uint32_t  TSTR9                :1;
            __IO  uint32_t  TSTR10               :1;
            __IO  uint32_t  TSTR11               :1;
            __IO  uint32_t  TSTR12               :1;
            __IO  uint32_t  TSTR13               :1;
            __IO  uint32_t  TSTR14               :1;
            __IO  uint32_t  TSTR15               :1;
            __IO  uint32_t  TSTR16               :1;
            __IO  uint32_t  TSTR17               :1;
            __IO  uint32_t  TSTR18               :1;
            __IO  uint32_t  TSTR19               :1;
            __IO  uint32_t  TSTR20               :1;
            __IO  uint32_t  TSTR21               :1;
            __IO  uint32_t  TSTR22               :1;
            __IO  uint32_t  TSTR23               :1;
            __IO  uint32_t  TSTR24               :1;
            __IO  uint32_t  TSTR25               :1;
            __IO  uint32_t  TSTR26               :1;
            __IO  uint32_t  TSTR27               :1;
            __IO  uint32_t  TSTR28               :1;
            __IO  uint32_t  TSTR29               :1;
            __IO  uint32_t  TSTR30               :1;
            __IO  uint32_t  TSTR31               :1;
        };
    };
} stc_ethernet_mac_ttsr_field_t;

typedef struct stc_ethernet_mac_ttnr_field
{
    union {
        struct {
            __IO  uint32_t  TSTR                 :31;
            __IO  uint32_t  RESERVED0            :1;
        };
        struct {
            __IO  uint32_t  TSTR0                :1;
            __IO  uint32_t  TSTR1                :1;
            __IO  uint32_t  TSTR2                :1;
            __IO  uint32_t  TSTR3                :1;
            __IO  uint32_t  TSTR4                :1;
            __IO  uint32_t  TSTR5                :1;
            __IO  uint32_t  TSTR6                :1;
            __IO  uint32_t  TSTR7                :1;
            __IO  uint32_t  TSTR8                :1;
            __IO  uint32_t  TSTR9                :1;
            __IO  uint32_t  TSTR10               :1;
            __IO  uint32_t  TSTR11               :1;
            __IO  uint32_t  TSTR12               :1;
            __IO  uint32_t  TSTR13               :1;
            __IO  uint32_t  TSTR14               :1;
            __IO  uint32_t  TSTR15               :1;
            __IO  uint32_t  TSTR16               :1;
            __IO  uint32_t  TSTR17               :1;
            __IO  uint32_t  TSTR18               :1;
            __IO  uint32_t  TSTR19               :1;
            __IO  uint32_t  TSTR20               :1;
            __IO  uint32_t  TSTR21               :1;
            __IO  uint32_t  TSTR22               :1;
            __IO  uint32_t  TSTR23               :1;
            __IO  uint32_t  TSTR24               :1;
            __IO  uint32_t  TSTR25               :1;
            __IO  uint32_t  TSTR26               :1;
            __IO  uint32_t  TSTR27               :1;
            __IO  uint32_t  TSTR28               :1;
            __IO  uint32_t  TSTR29               :1;
            __IO  uint32_t  TSTR30               :1;
            __IO  uint32_t  RESERVED1            :1;
        };
    };
} stc_ethernet_mac_ttnr_field_t;

typedef struct stc_ethernet_mac_sthwsr_field
{
    union {
        struct {
            __IO  uint32_t  TSHWR                :16;
            __IO  uint32_t  RESERVED0            :16;
        };
        struct {
            __IO  uint32_t  TSHWR0               :1;
            __IO  uint32_t  TSHWR1               :1;
            __IO  uint32_t  TSHWR2               :1;
            __IO  uint32_t  TSHWR3               :1;
            __IO  uint32_t  TSHWR4               :1;
            __IO  uint32_t  TSHWR5               :1;
            __IO  uint32_t  TSHWR6               :1;
            __IO  uint32_t  TSHWR7               :1;
            __IO  uint32_t  TSHWR8               :1;
            __IO  uint32_t  TSHWR9               :1;
            __IO  uint32_t  TSHWR10              :1;
            __IO  uint32_t  TSHWR11              :1;
            __IO  uint32_t  TSHWR12              :1;
            __IO  uint32_t  TSHWR13              :1;
            __IO  uint32_t  TSHWR14              :1;
            __IO  uint32_t  TSHWR15              :1;
            __IO  uint32_t  RESERVED1            :16;
        };
    };
} stc_ethernet_mac_sthwsr_field_t;

typedef struct stc_ethernet_mac_tsr_field
{
    union {
        struct {
            __IO  uint32_t  TSSOVF               :1;
            __IO  uint32_t  TSTART               :1;
            __IO  uint32_t  ATSTS                :1;
            __IO  uint32_t  TRGTER               :1;
            __IO  uint32_t  RESERVED0            :20;
            __IO  uint32_t  ATSSTM               :1;
            __IO  uint32_t  ATSNS                :3;
            __IO  uint32_t  RESERVED2            :4;
        };
        struct {
            __IO  uint32_t  RESERVED1            :25;
            __IO  uint32_t  ATSNS0               :1;
            __IO  uint32_t  ATSNS1               :1;
            __IO  uint32_t  ATSNS2               :1;
            __IO  uint32_t  RESERVED3            :4;
        };
    };
} stc_ethernet_mac_tsr_field_t;

typedef struct stc_ethernet_mac_ppscr_field
{
    union {
        struct {
            __IO  uint32_t  PPSCTRL              :4;
            __IO  uint32_t  RESERVED0            :28;
        };
        struct {
            __IO  uint32_t  PPSCTRL0             :1;
            __IO  uint32_t  PPSCTRL1             :1;
            __IO  uint32_t  PPSCTRL2             :1;
            __IO  uint32_t  PPSCTRL3             :1;
            __IO  uint32_t  RESERVED1            :28;
        };
    };
} stc_ethernet_mac_ppscr_field_t;

typedef struct stc_ethernet_mac_atnr_field
{
    union {
        struct {
            __IO  uint32_t  ATN                  :31;
            __IO  uint32_t  RESERVED0            :1;
        };
        struct {
            __IO  uint32_t  ATN0                 :1;
            __IO  uint32_t  ATN1                 :1;
            __IO  uint32_t  ATN2                 :1;
            __IO  uint32_t  ATN3                 :1;
            __IO  uint32_t  ATN4                 :1;
            __IO  uint32_t  ATN5                 :1;
            __IO  uint32_t  ATN6                 :1;
            __IO  uint32_t  ATN7                 :1;
            __IO  uint32_t  ATN8                 :1;
            __IO  uint32_t  ATN9                 :1;
            __IO  uint32_t  ATN10                :1;
            __IO  uint32_t  ATN11                :1;
            __IO  uint32_t  ATN12                :1;
            __IO  uint32_t  ATN13                :1;
            __IO  uint32_t  ATN14                :1;
            __IO  uint32_t  ATN15                :1;
            __IO  uint32_t  ATN16                :1;
            __IO  uint32_t  ATN17                :1;
            __IO  uint32_t  ATN18                :1;
            __IO  uint32_t  ATN19                :1;
            __IO  uint32_t  ATN20                :1;
            __IO  uint32_t  ATN21                :1;
            __IO  uint32_t  ATN22                :1;
            __IO  uint32_t  ATN23                :1;
            __IO  uint32_t  ATN24                :1;
            __IO  uint32_t  ATN25                :1;
            __IO  uint32_t  ATN26                :1;
            __IO  uint32_t  ATN27                :1;
            __IO  uint32_t  ATN28                :1;
            __IO  uint32_t  ATN29                :1;
            __IO  uint32_t  ATN30                :1;
            __IO  uint32_t  RESERVED1            :1;
        };
    };
} stc_ethernet_mac_atnr_field_t;

typedef struct stc_ethernet_mac_atsr_field
{
    union {
        struct {
            __IO  uint32_t  ATS                  :32;
        };
        struct {
            __IO  uint32_t  ATS0                 :1;
            __IO  uint32_t  ATS1                 :1;
            __IO  uint32_t  ATS2                 :1;
            __IO  uint32_t  ATS3                 :1;
            __IO  uint32_t  ATS4                 :1;
            __IO  uint32_t  ATS5                 :1;
            __IO  uint32_t  ATS6                 :1;
            __IO  uint32_t  ATS7                 :1;
            __IO  uint32_t  ATS8                 :1;
            __IO  uint32_t  ATS9                 :1;
            __IO  uint32_t  ATS10                :1;
            __IO  uint32_t  ATS11                :1;
            __IO  uint32_t  ATS12                :1;
            __IO  uint32_t  ATS13                :1;
            __IO  uint32_t  ATS14                :1;
            __IO  uint32_t  ATS15                :1;
            __IO  uint32_t  ATS16                :1;
            __IO  uint32_t  ATS17                :1;
            __IO  uint32_t  ATS18                :1;
            __IO  uint32_t  ATS19                :1;
            __IO  uint32_t  ATS20                :1;
            __IO  uint32_t  ATS21                :1;
            __IO  uint32_t  ATS22                :1;
            __IO  uint32_t  ATS23                :1;
            __IO  uint32_t  ATS24                :1;
            __IO  uint32_t  ATS25                :1;
            __IO  uint32_t  ATS26                :1;
            __IO  uint32_t  ATS27                :1;
            __IO  uint32_t  ATS28                :1;
            __IO  uint32_t  ATS29                :1;
            __IO  uint32_t  ATS30                :1;
            __IO  uint32_t  ATS31                :1;
        };
    };
} stc_ethernet_mac_atsr_field_t;

typedef struct stc_ethernet_mac_mar16h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar16h_field_t;

typedef struct stc_ethernet_mac_mar16l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar16l_field_t;

typedef struct stc_ethernet_mac_mar17h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar17h_field_t;

typedef struct stc_ethernet_mac_mar17l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar17l_field_t;

typedef struct stc_ethernet_mac_mar18h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar18h_field_t;

typedef struct stc_ethernet_mac_mar18l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar18l_field_t;

typedef struct stc_ethernet_mac_mar19h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar19h_field_t;

typedef struct stc_ethernet_mac_mar19l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar19l_field_t;

typedef struct stc_ethernet_mac_mar20h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar20h_field_t;

typedef struct stc_ethernet_mac_mar20l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar20l_field_t;

typedef struct stc_ethernet_mac_mar21h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar21h_field_t;

typedef struct stc_ethernet_mac_mar21l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar21l_field_t;

typedef struct stc_ethernet_mac_mar22h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar22h_field_t;

typedef struct stc_ethernet_mac_mar22l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar22l_field_t;

typedef struct stc_ethernet_mac_mar23h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar23h_field_t;

typedef struct stc_ethernet_mac_mar23l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar23l_field_t;

typedef struct stc_ethernet_mac_mar24h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar24h_field_t;

typedef struct stc_ethernet_mac_mar24l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar24l_field_t;

typedef struct stc_ethernet_mac_mar25h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar25h_field_t;

typedef struct stc_ethernet_mac_mar25l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar25l_field_t;

typedef struct stc_ethernet_mac_mar26h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar26h_field_t;

typedef struct stc_ethernet_mac_mar26l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar26l_field_t;

typedef struct stc_ethernet_mac_mar27h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar27h_field_t;

typedef struct stc_ethernet_mac_mar27l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar27l_field_t;

typedef struct stc_ethernet_mac_mar28h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar28h_field_t;

typedef struct stc_ethernet_mac_mar28l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar28l_field_t;

typedef struct stc_ethernet_mac_mar29h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar29h_field_t;

typedef struct stc_ethernet_mac_mar29l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar29l_field_t;

typedef struct stc_ethernet_mac_mar30h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar30h_field_t;

typedef struct stc_ethernet_mac_mar30l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar30l_field_t;

typedef struct stc_ethernet_mac_mar31h_field
{
    union {
        struct {
            __IO  uint32_t  A                    :16;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MBC                  :6;
            __IO  uint32_t  SA                   :1;
            __IO  uint32_t  AE                   :1;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MBC0                 :1;
            __IO  uint32_t  MBC1                 :1;
            __IO  uint32_t  MBC2                 :1;
            __IO  uint32_t  MBC3                 :1;
            __IO  uint32_t  MBC4                 :1;
            __IO  uint32_t  MBC5                 :1;
            __IO  uint32_t  RESERVED2            :2;
        };
    };
} stc_ethernet_mac_mar31h_field_t;

typedef struct stc_ethernet_mac_mar31l_field
{
    union {
        struct {
            __IO  uint32_t  A                    :32;
        };
        struct {
            __IO  uint32_t  A0                   :1;
            __IO  uint32_t  A1                   :1;
            __IO  uint32_t  A2                   :1;
            __IO  uint32_t  A3                   :1;
            __IO  uint32_t  A4                   :1;
            __IO  uint32_t  A5                   :1;
            __IO  uint32_t  A6                   :1;
            __IO  uint32_t  A7                   :1;
            __IO  uint32_t  A8                   :1;
            __IO  uint32_t  A9                   :1;
            __IO  uint32_t  A10                  :1;
            __IO  uint32_t  A11                  :1;
            __IO  uint32_t  A12                  :1;
            __IO  uint32_t  A13                  :1;
            __IO  uint32_t  A14                  :1;
            __IO  uint32_t  A15                  :1;
            __IO  uint32_t  A16                  :1;
            __IO  uint32_t  A17                  :1;
            __IO  uint32_t  A18                  :1;
            __IO  uint32_t  A19                  :1;
            __IO  uint32_t  A20                  :1;
            __IO  uint32_t  A21                  :1;
            __IO  uint32_t  A22                  :1;
            __IO  uint32_t  A23                  :1;
            __IO  uint32_t  A24                  :1;
            __IO  uint32_t  A25                  :1;
            __IO  uint32_t  A26                  :1;
            __IO  uint32_t  A27                  :1;
            __IO  uint32_t  A28                  :1;
            __IO  uint32_t  A29                  :1;
            __IO  uint32_t  A30                  :1;
            __IO  uint32_t  A31                  :1;
        };
    };
} stc_ethernet_mac_mar31l_field_t;

typedef struct stc_ethernet_mac_bmr_field
{
    union {
        struct {
            __IO  uint32_t  SWR                  :1;
            __IO  uint32_t  DA                   :1;
            __IO  uint32_t  DSL                  :5;
            __IO  uint32_t  ATDS                 :1;
            __IO  uint32_t  PBL                  :6;
            __IO  uint32_t  PR                   :2;
            __IO  uint32_t  FB                   :1;
            __IO  uint32_t  RPBL                 :6;
            __IO  uint32_t  USP                  :1;
            __IO  uint32_t  _8XPBL               :1;
            __IO  uint32_t  AAL                  :1;
            __IO  uint32_t  MB                   :1;
            __IO  uint32_t  TXPR                 :1;
            __IO  uint32_t  RESERVED3            :4;
        };
        struct {
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  DSL0                 :1;
            __IO  uint32_t  DSL1                 :1;
            __IO  uint32_t  DSL2                 :1;
            __IO  uint32_t  DSL3                 :1;
            __IO  uint32_t  DSL4                 :1;
            __IO  uint32_t  RESERVED1            :1;
            __IO  uint32_t  PBL0                 :1;
            __IO  uint32_t  PBL1                 :1;
            __IO  uint32_t  PBL2                 :1;
            __IO  uint32_t  PBL3                 :1;
            __IO  uint32_t  PBL4                 :1;
            __IO  uint32_t  PBL5                 :1;
            __IO  uint32_t  PR0                  :1;
            __IO  uint32_t  PR1                  :1;
            __IO  uint32_t  RESERVED2            :1;
            __IO  uint32_t  RPBL0                :1;
            __IO  uint32_t  RPBL1                :1;
            __IO  uint32_t  RPBL2                :1;
            __IO  uint32_t  RPBL3                :1;
            __IO  uint32_t  RPBL4                :1;
            __IO  uint32_t  RPBL5                :1;
            __IO  uint32_t  RESERVED4            :9;
        };
    };
} stc_ethernet_mac_bmr_field_t;

typedef struct stc_ethernet_mac_tpdr_field
{
    union {
        struct {
            __IO  uint32_t  TPD                  :32;
        };
        struct {
            __IO  uint32_t  TPD0                 :1;
            __IO  uint32_t  TPD1                 :1;
            __IO  uint32_t  TPD2                 :1;
            __IO  uint32_t  TPD3                 :1;
            __IO  uint32_t  TPD4                 :1;
            __IO  uint32_t  TPD5                 :1;
            __IO  uint32_t  TPD6                 :1;
            __IO  uint32_t  TPD7                 :1;
            __IO  uint32_t  TPD8                 :1;
            __IO  uint32_t  TPD9                 :1;
            __IO  uint32_t  TPD10                :1;
            __IO  uint32_t  TPD11                :1;
            __IO  uint32_t  TPD12                :1;
            __IO  uint32_t  TPD13                :1;
            __IO  uint32_t  TPD14                :1;
            __IO  uint32_t  TPD15                :1;
            __IO  uint32_t  TPD16                :1;
            __IO  uint32_t  TPD17                :1;
            __IO  uint32_t  TPD18                :1;
            __IO  uint32_t  TPD19                :1;
            __IO  uint32_t  TPD20                :1;
            __IO  uint32_t  TPD21                :1;
            __IO  uint32_t  TPD22                :1;
            __IO  uint32_t  TPD23                :1;
            __IO  uint32_t  TPD24                :1;
            __IO  uint32_t  TPD25                :1;
            __IO  uint32_t  TPD26                :1;
            __IO  uint32_t  TPD27                :1;
            __IO  uint32_t  TPD28                :1;
            __IO  uint32_t  TPD29                :1;
            __IO  uint32_t  TPD30                :1;
            __IO  uint32_t  TPD31                :1;
        };
    };
} stc_ethernet_mac_tpdr_field_t;

typedef struct stc_ethernet_mac_rpdr_field
{
    union {
        struct {
            __IO  uint32_t  RPD                  :32;
        };
        struct {
            __IO  uint32_t  RPD0                 :1;
            __IO  uint32_t  RPD1                 :1;
            __IO  uint32_t  RPD2                 :1;
            __IO  uint32_t  RPD3                 :1;
            __IO  uint32_t  RPD4                 :1;
            __IO  uint32_t  RPD5                 :1;
            __IO  uint32_t  RPD6                 :1;
            __IO  uint32_t  RPD7                 :1;
            __IO  uint32_t  RPD8                 :1;
            __IO  uint32_t  RPD9                 :1;
            __IO  uint32_t  RPD10                :1;
            __IO  uint32_t  RPD11                :1;
            __IO  uint32_t  RPD12                :1;
            __IO  uint32_t  RPD13                :1;
            __IO  uint32_t  RPD14                :1;
            __IO  uint32_t  RPD15                :1;
            __IO  uint32_t  RPD16                :1;
            __IO  uint32_t  RPD17                :1;
            __IO  uint32_t  RPD18                :1;
            __IO  uint32_t  RPD19                :1;
            __IO  uint32_t  RPD20                :1;
            __IO  uint32_t  RPD21                :1;
            __IO  uint32_t  RPD22                :1;
            __IO  uint32_t  RPD23                :1;
            __IO  uint32_t  RPD24                :1;
            __IO  uint32_t  RPD25                :1;
            __IO  uint32_t  RPD26                :1;
            __IO  uint32_t  RPD27                :1;
            __IO  uint32_t  RPD28                :1;
            __IO  uint32_t  RPD29                :1;
            __IO  uint32_t  RPD30                :1;
            __IO  uint32_t  RPD31                :1;
        };
    };
} stc_ethernet_mac_rpdr_field_t;

typedef struct stc_ethernet_mac_rdlar_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  SRL                  :30;
        };
        struct {
            __IO  uint32_t  RESERVED1            :2;
            __IO  uint32_t  SRL0                 :1;
            __IO  uint32_t  SRL1                 :1;
            __IO  uint32_t  SRL2                 :1;
            __IO  uint32_t  SRL3                 :1;
            __IO  uint32_t  SRL4                 :1;
            __IO  uint32_t  SRL5                 :1;
            __IO  uint32_t  SRL6                 :1;
            __IO  uint32_t  SRL7                 :1;
            __IO  uint32_t  SRL8                 :1;
            __IO  uint32_t  SRL9                 :1;
            __IO  uint32_t  SRL10                :1;
            __IO  uint32_t  SRL11                :1;
            __IO  uint32_t  SRL12                :1;
            __IO  uint32_t  SRL13                :1;
            __IO  uint32_t  SRL14                :1;
            __IO  uint32_t  SRL15                :1;
            __IO  uint32_t  SRL16                :1;
            __IO  uint32_t  SRL17                :1;
            __IO  uint32_t  SRL18                :1;
            __IO  uint32_t  SRL19                :1;
            __IO  uint32_t  SRL20                :1;
            __IO  uint32_t  SRL21                :1;
            __IO  uint32_t  SRL22                :1;
            __IO  uint32_t  SRL23                :1;
            __IO  uint32_t  SRL24                :1;
            __IO  uint32_t  SRL25                :1;
            __IO  uint32_t  SRL26                :1;
            __IO  uint32_t  SRL27                :1;
            __IO  uint32_t  SRL28                :1;
            __IO  uint32_t  SRL29                :1;
        };
    };
} stc_ethernet_mac_rdlar_field_t;

typedef struct stc_ethernet_mac_tdlar_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  STL                  :30;
        };
        struct {
            __IO  uint32_t  RESERVED1            :2;
            __IO  uint32_t  STL0                 :1;
            __IO  uint32_t  STL1                 :1;
            __IO  uint32_t  STL2                 :1;
            __IO  uint32_t  STL3                 :1;
            __IO  uint32_t  STL4                 :1;
            __IO  uint32_t  STL5                 :1;
            __IO  uint32_t  STL6                 :1;
            __IO  uint32_t  STL7                 :1;
            __IO  uint32_t  STL8                 :1;
            __IO  uint32_t  STL9                 :1;
            __IO  uint32_t  STL10                :1;
            __IO  uint32_t  STL11                :1;
            __IO  uint32_t  STL12                :1;
            __IO  uint32_t  STL13                :1;
            __IO  uint32_t  STL14                :1;
            __IO  uint32_t  STL15                :1;
            __IO  uint32_t  STL16                :1;
            __IO  uint32_t  STL17                :1;
            __IO  uint32_t  STL18                :1;
            __IO  uint32_t  STL19                :1;
            __IO  uint32_t  STL20                :1;
            __IO  uint32_t  STL21                :1;
            __IO  uint32_t  STL22                :1;
            __IO  uint32_t  STL23                :1;
            __IO  uint32_t  STL24                :1;
            __IO  uint32_t  STL25                :1;
            __IO  uint32_t  STL26                :1;
            __IO  uint32_t  STL27                :1;
            __IO  uint32_t  STL28                :1;
            __IO  uint32_t  STL29                :1;
        };
    };
} stc_ethernet_mac_tdlar_field_t;

typedef struct stc_ethernet_mac_sr_field
{
    union {
        struct {
            __IO  uint32_t  TI                   :1;
            __IO  uint32_t  TPS                  :1;
            __IO  uint32_t  TU                   :1;
            __IO  uint32_t  TJT                  :1;
            __IO  uint32_t  OVF                  :1;
            __IO  uint32_t  UNF                  :1;
            __IO  uint32_t  RI                   :1;
            __IO  uint32_t  RU                   :1;
            __IO  uint32_t  RPS                  :1;
            __IO  uint32_t  RWT                  :1;
            __IO  uint32_t  ETI                  :1;
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  FBI                  :1;
            __IO  uint32_t  ERI                  :1;
            __IO  uint32_t  AIS                  :1;
            __IO  uint32_t  NIS                  :1;
            __IO  uint32_t  RS                   :3;
            __IO  uint32_t  TS                   :3;
            __IO  uint32_t  EB                   :3;
            __IO  uint32_t  GLI                  :1;
            __IO  uint32_t  GMI                  :1;
            __IO  uint32_t  GPI                  :1;
            __IO  uint32_t  TTI                  :1;
            __IO  uint32_t  GLPII                :1;
            __IO  uint32_t  RESERVED2            :1;
        };
        struct {
            __IO  uint32_t  RESERVED1            :17;
            __IO  uint32_t  RS0                  :1;
            __IO  uint32_t  RS1                  :1;
            __IO  uint32_t  RS2                  :1;
            __IO  uint32_t  TS0                  :1;
            __IO  uint32_t  TS1                  :1;
            __IO  uint32_t  TS2                  :1;
            __IO  uint32_t  EB0                  :1;
            __IO  uint32_t  EB1                  :1;
            __IO  uint32_t  EB2                  :1;
            __IO  uint32_t  RESERVED3            :6;
        };
    };
} stc_ethernet_mac_sr_field_t;

typedef struct stc_ethernet_mac_omr_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  SR                   :1;
            __IO  uint32_t  OSF                  :1;
            __IO  uint32_t  RTC                  :2;
            __IO  uint32_t  RESERVED2            :1;
            __IO  uint32_t  FUF                  :1;
            __IO  uint32_t  FEF                  :1;
            __IO  uint32_t  RESERVED3            :5;
            __IO  uint32_t  ST                   :1;
            __IO  uint32_t  TTC                  :3;
            __IO  uint32_t  RESERVED5            :3;
            __IO  uint32_t  FTF                  :1;
            __IO  uint32_t  TSF                  :1;
            __IO  uint32_t  RESERVED6            :2;
            __IO  uint32_t  DFF                  :1;
            __IO  uint32_t  RSF                  :1;
            __IO  uint32_t  DT                   :1;
            __IO  uint32_t  RESERVED7            :5;
        };
        struct {
            __IO  uint32_t  RESERVED1            :3;
            __IO  uint32_t  RTC0                 :1;
            __IO  uint32_t  RTC1                 :1;
            __IO  uint32_t  RESERVED4            :9;
            __IO  uint32_t  TTC0                 :1;
            __IO  uint32_t  TTC1                 :1;
            __IO  uint32_t  TTC2                 :1;
            __IO  uint32_t  RESERVED8            :15;
        };
    };
} stc_ethernet_mac_omr_field_t;

typedef struct stc_ethernet_mac_ier_field
{
        __IO  uint32_t  TIE                      :1;
        __IO  uint32_t  TSE                      :1;
        __IO  uint32_t  TUE                      :1;
        __IO  uint32_t  TJE                      :1;
        __IO  uint32_t  OVE                      :1;
        __IO  uint32_t  UNE                      :1;
        __IO  uint32_t  RIE                      :1;
        __IO  uint32_t  RUE                      :1;
        __IO  uint32_t  RSE                      :1;
        __IO  uint32_t  RWE                      :1;
        __IO  uint32_t  ETE                      :1;
        __IO  uint32_t  RESERVED0                :2;
        __IO  uint32_t  FBE                      :1;
        __IO  uint32_t  ERE                      :1;
        __IO  uint32_t  AIE                      :1;
        __IO  uint32_t  NIE                      :1;
        __IO  uint32_t  RESERVED1                :15;
} stc_ethernet_mac_ier_field_t;

typedef struct stc_ethernet_mac_mfbocr_field
{
    union {
        struct {
            __IO  uint32_t  NMFH                 :16;
            __IO  uint32_t  ONMFH                :1;
            __IO  uint32_t  NMFF                 :11;
            __IO  uint32_t  ONMFF                :1;
            __IO  uint32_t  RESERVED1            :3;
        };
        struct {
            __IO  uint32_t  NMFH0                :1;
            __IO  uint32_t  NMFH1                :1;
            __IO  uint32_t  NMFH2                :1;
            __IO  uint32_t  NMFH3                :1;
            __IO  uint32_t  NMFH4                :1;
            __IO  uint32_t  NMFH5                :1;
            __IO  uint32_t  NMFH6                :1;
            __IO  uint32_t  NMFH7                :1;
            __IO  uint32_t  NMFH8                :1;
            __IO  uint32_t  NMFH9                :1;
            __IO  uint32_t  NMFH10               :1;
            __IO  uint32_t  NMFH11               :1;
            __IO  uint32_t  NMFH12               :1;
            __IO  uint32_t  NMFH13               :1;
            __IO  uint32_t  NMFH14               :1;
            __IO  uint32_t  NMFH15               :1;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  NMFF0                :1;
            __IO  uint32_t  NMFF1                :1;
            __IO  uint32_t  NMFF2                :1;
            __IO  uint32_t  NMFF3                :1;
            __IO  uint32_t  NMFF4                :1;
            __IO  uint32_t  NMFF5                :1;
            __IO  uint32_t  NMFF6                :1;
            __IO  uint32_t  NMFF7                :1;
            __IO  uint32_t  NMFF8                :1;
            __IO  uint32_t  NMFF9                :1;
            __IO  uint32_t  NMFF10               :1;
            __IO  uint32_t  RESERVED2            :4;
        };
    };
} stc_ethernet_mac_mfbocr_field_t;

typedef struct stc_ethernet_mac_riwtr_field
{
    union {
        struct {
            __IO  uint32_t  RIWT                 :8;
            __IO  uint32_t  RESERVED0            :24;
        };
        struct {
            __IO  uint32_t  RIWT0                :1;
            __IO  uint32_t  RIWT1                :1;
            __IO  uint32_t  RIWT2                :1;
            __IO  uint32_t  RIWT3                :1;
            __IO  uint32_t  RIWT4                :1;
            __IO  uint32_t  RIWT5                :1;
            __IO  uint32_t  RIWT6                :1;
            __IO  uint32_t  RIWT7                :1;
            __IO  uint32_t  RESERVED1            :24;
        };
    };
} stc_ethernet_mac_riwtr_field_t;

typedef struct stc_ethernet_mac_ahbsr_field
{
        __IO  uint32_t  AHBS                     :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_ethernet_mac_ahbsr_field_t;

typedef struct stc_ethernet_mac_chtdr_field
{
    union {
        struct {
            __IO  uint32_t  HTDAP                :32;
        };
        struct {
            __IO  uint32_t  HTDAP0               :1;
            __IO  uint32_t  HTDAP1               :1;
            __IO  uint32_t  HTDAP2               :1;
            __IO  uint32_t  HTDAP3               :1;
            __IO  uint32_t  HTDAP4               :1;
            __IO  uint32_t  HTDAP5               :1;
            __IO  uint32_t  HTDAP6               :1;
            __IO  uint32_t  HTDAP7               :1;
            __IO  uint32_t  HTDAP8               :1;
            __IO  uint32_t  HTDAP9               :1;
            __IO  uint32_t  HTDAP10              :1;
            __IO  uint32_t  HTDAP11              :1;
            __IO  uint32_t  HTDAP12              :1;
            __IO  uint32_t  HTDAP13              :1;
            __IO  uint32_t  HTDAP14              :1;
            __IO  uint32_t  HTDAP15              :1;
            __IO  uint32_t  HTDAP16              :1;
            __IO  uint32_t  HTDAP17              :1;
            __IO  uint32_t  HTDAP18              :1;
            __IO  uint32_t  HTDAP19              :1;
            __IO  uint32_t  HTDAP20              :1;
            __IO  uint32_t  HTDAP21              :1;
            __IO  uint32_t  HTDAP22              :1;
            __IO  uint32_t  HTDAP23              :1;
            __IO  uint32_t  HTDAP24              :1;
            __IO  uint32_t  HTDAP25              :1;
            __IO  uint32_t  HTDAP26              :1;
            __IO  uint32_t  HTDAP27              :1;
            __IO  uint32_t  HTDAP28              :1;
            __IO  uint32_t  HTDAP29              :1;
            __IO  uint32_t  HTDAP30              :1;
            __IO  uint32_t  HTDAP31              :1;
        };
    };
} stc_ethernet_mac_chtdr_field_t;

typedef struct stc_ethernet_mac_chrdr_field
{
    union {
        struct {
            __IO  uint32_t  HRDAP                :32;
        };
        struct {
            __IO  uint32_t  HRDAP0               :1;
            __IO  uint32_t  HRDAP1               :1;
            __IO  uint32_t  HRDAP2               :1;
            __IO  uint32_t  HRDAP3               :1;
            __IO  uint32_t  HRDAP4               :1;
            __IO  uint32_t  HRDAP5               :1;
            __IO  uint32_t  HRDAP6               :1;
            __IO  uint32_t  HRDAP7               :1;
            __IO  uint32_t  HRDAP8               :1;
            __IO  uint32_t  HRDAP9               :1;
            __IO  uint32_t  HRDAP10              :1;
            __IO  uint32_t  HRDAP11              :1;
            __IO  uint32_t  HRDAP12              :1;
            __IO  uint32_t  HRDAP13              :1;
            __IO  uint32_t  HRDAP14              :1;
            __IO  uint32_t  HRDAP15              :1;
            __IO  uint32_t  HRDAP16              :1;
            __IO  uint32_t  HRDAP17              :1;
            __IO  uint32_t  HRDAP18              :1;
            __IO  uint32_t  HRDAP19              :1;
            __IO  uint32_t  HRDAP20              :1;
            __IO  uint32_t  HRDAP21              :1;
            __IO  uint32_t  HRDAP22              :1;
            __IO  uint32_t  HRDAP23              :1;
            __IO  uint32_t  HRDAP24              :1;
            __IO  uint32_t  HRDAP25              :1;
            __IO  uint32_t  HRDAP26              :1;
            __IO  uint32_t  HRDAP27              :1;
            __IO  uint32_t  HRDAP28              :1;
            __IO  uint32_t  HRDAP29              :1;
            __IO  uint32_t  HRDAP30              :1;
            __IO  uint32_t  HRDAP31              :1;
        };
    };
} stc_ethernet_mac_chrdr_field_t;

typedef struct stc_ethernet_mac_chtbar_field
{
    union {
        struct {
            __IO  uint32_t  HTBAR                :32;
        };
        struct {
            __IO  uint32_t  HTBAR0               :1;
            __IO  uint32_t  HTBAR1               :1;
            __IO  uint32_t  HTBAR2               :1;
            __IO  uint32_t  HTBAR3               :1;
            __IO  uint32_t  HTBAR4               :1;
            __IO  uint32_t  HTBAR5               :1;
            __IO  uint32_t  HTBAR6               :1;
            __IO  uint32_t  HTBAR7               :1;
            __IO  uint32_t  HTBAR8               :1;
            __IO  uint32_t  HTBAR9               :1;
            __IO  uint32_t  HTBAR10              :1;
            __IO  uint32_t  HTBAR11              :1;
            __IO  uint32_t  HTBAR12              :1;
            __IO  uint32_t  HTBAR13              :1;
            __IO  uint32_t  HTBAR14              :1;
            __IO  uint32_t  HTBAR15              :1;
            __IO  uint32_t  HTBAR16              :1;
            __IO  uint32_t  HTBAR17              :1;
            __IO  uint32_t  HTBAR18              :1;
            __IO  uint32_t  HTBAR19              :1;
            __IO  uint32_t  HTBAR20              :1;
            __IO  uint32_t  HTBAR21              :1;
            __IO  uint32_t  HTBAR22              :1;
            __IO  uint32_t  HTBAR23              :1;
            __IO  uint32_t  HTBAR24              :1;
            __IO  uint32_t  HTBAR25              :1;
            __IO  uint32_t  HTBAR26              :1;
            __IO  uint32_t  HTBAR27              :1;
            __IO  uint32_t  HTBAR28              :1;
            __IO  uint32_t  HTBAR29              :1;
            __IO  uint32_t  HTBAR30              :1;
            __IO  uint32_t  HTBAR31              :1;
        };
    };
} stc_ethernet_mac_chtbar_field_t;

typedef struct stc_ethernet_mac_chrbar_field
{
    union {
        struct {
            __IO  uint32_t  HRBAR                :32;
        };
        struct {
            __IO  uint32_t  HRBAR0               :1;
            __IO  uint32_t  HRBAR1               :1;
            __IO  uint32_t  HRBAR2               :1;
            __IO  uint32_t  HRBAR3               :1;
            __IO  uint32_t  HRBAR4               :1;
            __IO  uint32_t  HRBAR5               :1;
            __IO  uint32_t  HRBAR6               :1;
            __IO  uint32_t  HRBAR7               :1;
            __IO  uint32_t  HRBAR8               :1;
            __IO  uint32_t  HRBAR9               :1;
            __IO  uint32_t  HRBAR10              :1;
            __IO  uint32_t  HRBAR11              :1;
            __IO  uint32_t  HRBAR12              :1;
            __IO  uint32_t  HRBAR13              :1;
            __IO  uint32_t  HRBAR14              :1;
            __IO  uint32_t  HRBAR15              :1;
            __IO  uint32_t  HRBAR16              :1;
            __IO  uint32_t  HRBAR17              :1;
            __IO  uint32_t  HRBAR18              :1;
            __IO  uint32_t  HRBAR19              :1;
            __IO  uint32_t  HRBAR20              :1;
            __IO  uint32_t  HRBAR21              :1;
            __IO  uint32_t  HRBAR22              :1;
            __IO  uint32_t  HRBAR23              :1;
            __IO  uint32_t  HRBAR24              :1;
            __IO  uint32_t  HRBAR25              :1;
            __IO  uint32_t  HRBAR26              :1;
            __IO  uint32_t  HRBAR27              :1;
            __IO  uint32_t  HRBAR28              :1;
            __IO  uint32_t  HRBAR29              :1;
            __IO  uint32_t  HRBAR30              :1;
            __IO  uint32_t  HRBAR31              :1;
        };
    };
} stc_ethernet_mac_chrbar_field_t;

/******************************************************************************
 ** EXBUS_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_exbus_mode0_field
{
    union {
        struct {
            __IO  uint32_t  WDTH                 :2;
            __IO  uint32_t  RBMON                :1;
            __IO  uint32_t  WEOFF                :1;
            __IO  uint32_t  NAND                 :1;
            __IO  uint32_t  PAGE                 :1;
            __IO  uint32_t  RDY                  :1;
            __IO  uint32_t  SHRTDOUT             :1;
            __IO  uint32_t  MPXMODE              :1;
            __IO  uint32_t  ALEINV               :1;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  MPXDOFF              :1;
            __IO  uint32_t  MPXCSOF              :1;
            __IO  uint32_t  MOEXEUP              :1;
            __IO  uint32_t  RESERVED1            :18;
        };
        struct {
            __IO  uint32_t  WDTH0                :1;
            __IO  uint32_t  WDTH1                :1;
            __IO  uint32_t  RESERVED2            :30;
        };
    };
} stc_exbus_mode0_field_t;

typedef struct stc_exbus_mode1_field
{
    union {
        struct {
            __IO  uint32_t  WDTH                 :2;
            __IO  uint32_t  RBMON                :1;
            __IO  uint32_t  WEOFF                :1;
            __IO  uint32_t  NAND                 :1;
            __IO  uint32_t  PAGE                 :1;
            __IO  uint32_t  RDY                  :1;
            __IO  uint32_t  SHRTDOUT             :1;
            __IO  uint32_t  MPXMODE              :1;
            __IO  uint32_t  ALEINV               :1;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  MPXDOFF              :1;
            __IO  uint32_t  MPXCSOF              :1;
            __IO  uint32_t  MOEXEUP              :1;
            __IO  uint32_t  RESERVED1            :18;
        };
        struct {
            __IO  uint32_t  WDTH0                :1;
            __IO  uint32_t  WDTH1                :1;
            __IO  uint32_t  RESERVED2            :30;
        };
    };
} stc_exbus_mode1_field_t;

typedef struct stc_exbus_mode2_field
{
    union {
        struct {
            __IO  uint32_t  WDTH                 :2;
            __IO  uint32_t  RBMON                :1;
            __IO  uint32_t  WEOFF                :1;
            __IO  uint32_t  NAND                 :1;
            __IO  uint32_t  PAGE                 :1;
            __IO  uint32_t  RDY                  :1;
            __IO  uint32_t  SHRTDOUT             :1;
            __IO  uint32_t  MPXMODE              :1;
            __IO  uint32_t  ALEINV               :1;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  MPXDOFF              :1;
            __IO  uint32_t  MPXCSOF              :1;
            __IO  uint32_t  MOEXEUP              :1;
            __IO  uint32_t  RESERVED1            :18;
        };
        struct {
            __IO  uint32_t  WDTH0                :1;
            __IO  uint32_t  WDTH1                :1;
            __IO  uint32_t  RESERVED2            :30;
        };
    };
} stc_exbus_mode2_field_t;

typedef struct stc_exbus_mode3_field
{
    union {
        struct {
            __IO  uint32_t  WDTH                 :2;
            __IO  uint32_t  RBMON                :1;
            __IO  uint32_t  WEOFF                :1;
            __IO  uint32_t  NAND                 :1;
            __IO  uint32_t  PAGE                 :1;
            __IO  uint32_t  RDY                  :1;
            __IO  uint32_t  SHRTDOUT             :1;
            __IO  uint32_t  MPXMODE              :1;
            __IO  uint32_t  ALEINV               :1;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  MPXDOFF              :1;
            __IO  uint32_t  MPXCSOF              :1;
            __IO  uint32_t  MOEXEUP              :1;
            __IO  uint32_t  RESERVED1            :18;
        };
        struct {
            __IO  uint32_t  WDTH0                :1;
            __IO  uint32_t  WDTH1                :1;
            __IO  uint32_t  RESERVED2            :30;
        };
    };
} stc_exbus_mode3_field_t;

typedef struct stc_exbus_mode4_field
{
    union {
        struct {
            __IO  uint32_t  WDTH                 :2;
            __IO  uint32_t  RBMON                :1;
            __IO  uint32_t  WEOFF                :1;
            __IO  uint32_t  NAND                 :1;
            __IO  uint32_t  PAGE                 :1;
            __IO  uint32_t  RDY                  :1;
            __IO  uint32_t  SHRTDOUT             :1;
            __IO  uint32_t  MPXMODE              :1;
            __IO  uint32_t  ALEINV               :1;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  MPXDOFF              :1;
            __IO  uint32_t  MPXCSOF              :1;
            __IO  uint32_t  MOEXEUP              :1;
            __IO  uint32_t  RESERVED1            :18;
        };
        struct {
            __IO  uint32_t  WDTH0                :1;
            __IO  uint32_t  WDTH1                :1;
            __IO  uint32_t  RESERVED2            :30;
        };
    };
} stc_exbus_mode4_field_t;

typedef struct stc_exbus_mode5_field
{
    union {
        struct {
            __IO  uint32_t  WDTH                 :2;
            __IO  uint32_t  RBMON                :1;
            __IO  uint32_t  WEOFF                :1;
            __IO  uint32_t  NAND                 :1;
            __IO  uint32_t  PAGE                 :1;
            __IO  uint32_t  RDY                  :1;
            __IO  uint32_t  SHRTDOUT             :1;
            __IO  uint32_t  MPXMODE              :1;
            __IO  uint32_t  ALEINV               :1;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  MPXDOFF              :1;
            __IO  uint32_t  MPXCSOF              :1;
            __IO  uint32_t  MOEXEUP              :1;
            __IO  uint32_t  RESERVED1            :18;
        };
        struct {
            __IO  uint32_t  WDTH0                :1;
            __IO  uint32_t  WDTH1                :1;
            __IO  uint32_t  RESERVED2            :30;
        };
    };
} stc_exbus_mode5_field_t;

typedef struct stc_exbus_mode6_field
{
    union {
        struct {
            __IO  uint32_t  WDTH                 :2;
            __IO  uint32_t  RBMON                :1;
            __IO  uint32_t  WEOFF                :1;
            __IO  uint32_t  NAND                 :1;
            __IO  uint32_t  PAGE                 :1;
            __IO  uint32_t  RDY                  :1;
            __IO  uint32_t  SHRTDOUT             :1;
            __IO  uint32_t  MPXMODE              :1;
            __IO  uint32_t  ALEINV               :1;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  MPXDOFF              :1;
            __IO  uint32_t  MPXCSOF              :1;
            __IO  uint32_t  MOEXEUP              :1;
            __IO  uint32_t  RESERVED1            :18;
        };
        struct {
            __IO  uint32_t  WDTH0                :1;
            __IO  uint32_t  WDTH1                :1;
            __IO  uint32_t  RESERVED2            :30;
        };
    };
} stc_exbus_mode6_field_t;

typedef struct stc_exbus_mode7_field
{
    union {
        struct {
            __IO  uint32_t  WDTH                 :2;
            __IO  uint32_t  RBMON                :1;
            __IO  uint32_t  WEOFF                :1;
            __IO  uint32_t  NAND                 :1;
            __IO  uint32_t  PAGE                 :1;
            __IO  uint32_t  RDY                  :1;
            __IO  uint32_t  SHRTDOUT             :1;
            __IO  uint32_t  MPXMODE              :1;
            __IO  uint32_t  ALEINV               :1;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  MPXDOFF              :1;
            __IO  uint32_t  MPXCSOF              :1;
            __IO  uint32_t  MOEXEUP              :1;
            __IO  uint32_t  RESERVED1            :18;
        };
        struct {
            __IO  uint32_t  WDTH0                :1;
            __IO  uint32_t  WDTH1                :1;
            __IO  uint32_t  RESERVED2            :30;
        };
    };
} stc_exbus_mode7_field_t;

typedef struct stc_exbus_tim0_field
{
    union {
        struct {
            __IO  uint32_t  RACC                 :4;
            __IO  uint32_t  RADC                 :4;
            __IO  uint32_t  FRADC                :4;
            __IO  uint32_t  RIDLC                :4;
            __IO  uint32_t  WACC                 :4;
            __IO  uint32_t  WADC                 :4;
            __IO  uint32_t  WWEC                 :4;
            __IO  uint32_t  WIDLC                :4;
        };
        struct {
            __IO  uint32_t  RACC0                :1;
            __IO  uint32_t  RACC1                :1;
            __IO  uint32_t  RACC2                :1;
            __IO  uint32_t  RACC3                :1;
            __IO  uint32_t  RADC0                :1;
            __IO  uint32_t  RADC1                :1;
            __IO  uint32_t  RADC2                :1;
            __IO  uint32_t  RADC3                :1;
            __IO  uint32_t  FRADC0               :1;
            __IO  uint32_t  FRADC1               :1;
            __IO  uint32_t  FRADC2               :1;
            __IO  uint32_t  FRADC3               :1;
            __IO  uint32_t  RIDLC0               :1;
            __IO  uint32_t  RIDLC1               :1;
            __IO  uint32_t  RIDLC2               :1;
            __IO  uint32_t  RIDLC3               :1;
            __IO  uint32_t  WACC0                :1;
            __IO  uint32_t  WACC1                :1;
            __IO  uint32_t  WACC2                :1;
            __IO  uint32_t  WACC3                :1;
            __IO  uint32_t  WADC0                :1;
            __IO  uint32_t  WADC1                :1;
            __IO  uint32_t  WADC2                :1;
            __IO  uint32_t  WADC3                :1;
            __IO  uint32_t  WWEC0                :1;
            __IO  uint32_t  WWEC1                :1;
            __IO  uint32_t  WWEC2                :1;
            __IO  uint32_t  WWEC3                :1;
            __IO  uint32_t  WIDLC0               :1;
            __IO  uint32_t  WIDLC1               :1;
            __IO  uint32_t  WIDLC2               :1;
            __IO  uint32_t  WIDLC3               :1;
        };
    };
} stc_exbus_tim0_field_t;

typedef struct stc_exbus_tim1_field
{
    union {
        struct {
            __IO  uint32_t  RACC                 :4;
            __IO  uint32_t  RADC                 :4;
            __IO  uint32_t  FRADC                :4;
            __IO  uint32_t  RIDLC                :4;
            __IO  uint32_t  WACC                 :4;
            __IO  uint32_t  WADC                 :4;
            __IO  uint32_t  WWEC                 :4;
            __IO  uint32_t  WIDLC                :4;
        };
        struct {
            __IO  uint32_t  RACC0                :1;
            __IO  uint32_t  RACC1                :1;
            __IO  uint32_t  RACC2                :1;
            __IO  uint32_t  RACC3                :1;
            __IO  uint32_t  RADC0                :1;
            __IO  uint32_t  RADC1                :1;
            __IO  uint32_t  RADC2                :1;
            __IO  uint32_t  RADC3                :1;
            __IO  uint32_t  FRADC0               :1;
            __IO  uint32_t  FRADC1               :1;
            __IO  uint32_t  FRADC2               :1;
            __IO  uint32_t  FRADC3               :1;
            __IO  uint32_t  RIDLC0               :1;
            __IO  uint32_t  RIDLC1               :1;
            __IO  uint32_t  RIDLC2               :1;
            __IO  uint32_t  RIDLC3               :1;
            __IO  uint32_t  WACC0                :1;
            __IO  uint32_t  WACC1                :1;
            __IO  uint32_t  WACC2                :1;
            __IO  uint32_t  WACC3                :1;
            __IO  uint32_t  WADC0                :1;
            __IO  uint32_t  WADC1                :1;
            __IO  uint32_t  WADC2                :1;
            __IO  uint32_t  WADC3                :1;
            __IO  uint32_t  WWEC0                :1;
            __IO  uint32_t  WWEC1                :1;
            __IO  uint32_t  WWEC2                :1;
            __IO  uint32_t  WWEC3                :1;
            __IO  uint32_t  WIDLC0               :1;
            __IO  uint32_t  WIDLC1               :1;
            __IO  uint32_t  WIDLC2               :1;
            __IO  uint32_t  WIDLC3               :1;
        };
    };
} stc_exbus_tim1_field_t;

typedef struct stc_exbus_tim2_field
{
    union {
        struct {
            __IO  uint32_t  RACC                 :4;
            __IO  uint32_t  RADC                 :4;
            __IO  uint32_t  FRADC                :4;
            __IO  uint32_t  RIDLC                :4;
            __IO  uint32_t  WACC                 :4;
            __IO  uint32_t  WADC                 :4;
            __IO  uint32_t  WWEC                 :4;
            __IO  uint32_t  WIDLC                :4;
        };
        struct {
            __IO  uint32_t  RACC0                :1;
            __IO  uint32_t  RACC1                :1;
            __IO  uint32_t  RACC2                :1;
            __IO  uint32_t  RACC3                :1;
            __IO  uint32_t  RADC0                :1;
            __IO  uint32_t  RADC1                :1;
            __IO  uint32_t  RADC2                :1;
            __IO  uint32_t  RADC3                :1;
            __IO  uint32_t  FRADC0               :1;
            __IO  uint32_t  FRADC1               :1;
            __IO  uint32_t  FRADC2               :1;
            __IO  uint32_t  FRADC3               :1;
            __IO  uint32_t  RIDLC0               :1;
            __IO  uint32_t  RIDLC1               :1;
            __IO  uint32_t  RIDLC2               :1;
            __IO  uint32_t  RIDLC3               :1;
            __IO  uint32_t  WACC0                :1;
            __IO  uint32_t  WACC1                :1;
            __IO  uint32_t  WACC2                :1;
            __IO  uint32_t  WACC3                :1;
            __IO  uint32_t  WADC0                :1;
            __IO  uint32_t  WADC1                :1;
            __IO  uint32_t  WADC2                :1;
            __IO  uint32_t  WADC3                :1;
            __IO  uint32_t  WWEC0                :1;
            __IO  uint32_t  WWEC1                :1;
            __IO  uint32_t  WWEC2                :1;
            __IO  uint32_t  WWEC3                :1;
            __IO  uint32_t  WIDLC0               :1;
            __IO  uint32_t  WIDLC1               :1;
            __IO  uint32_t  WIDLC2               :1;
            __IO  uint32_t  WIDLC3               :1;
        };
    };
} stc_exbus_tim2_field_t;

typedef struct stc_exbus_tim3_field
{
    union {
        struct {
            __IO  uint32_t  RACC                 :4;
            __IO  uint32_t  RADC                 :4;
            __IO  uint32_t  FRADC                :4;
            __IO  uint32_t  RIDLC                :4;
            __IO  uint32_t  WACC                 :4;
            __IO  uint32_t  WADC                 :4;
            __IO  uint32_t  WWEC                 :4;
            __IO  uint32_t  WIDLC                :4;
        };
        struct {
            __IO  uint32_t  RACC0                :1;
            __IO  uint32_t  RACC1                :1;
            __IO  uint32_t  RACC2                :1;
            __IO  uint32_t  RACC3                :1;
            __IO  uint32_t  RADC0                :1;
            __IO  uint32_t  RADC1                :1;
            __IO  uint32_t  RADC2                :1;
            __IO  uint32_t  RADC3                :1;
            __IO  uint32_t  FRADC0               :1;
            __IO  uint32_t  FRADC1               :1;
            __IO  uint32_t  FRADC2               :1;
            __IO  uint32_t  FRADC3               :1;
            __IO  uint32_t  RIDLC0               :1;
            __IO  uint32_t  RIDLC1               :1;
            __IO  uint32_t  RIDLC2               :1;
            __IO  uint32_t  RIDLC3               :1;
            __IO  uint32_t  WACC0                :1;
            __IO  uint32_t  WACC1                :1;
            __IO  uint32_t  WACC2                :1;
            __IO  uint32_t  WACC3                :1;
            __IO  uint32_t  WADC0                :1;
            __IO  uint32_t  WADC1                :1;
            __IO  uint32_t  WADC2                :1;
            __IO  uint32_t  WADC3                :1;
            __IO  uint32_t  WWEC0                :1;
            __IO  uint32_t  WWEC1                :1;
            __IO  uint32_t  WWEC2                :1;
            __IO  uint32_t  WWEC3                :1;
            __IO  uint32_t  WIDLC0               :1;
            __IO  uint32_t  WIDLC1               :1;
            __IO  uint32_t  WIDLC2               :1;
            __IO  uint32_t  WIDLC3               :1;
        };
    };
} stc_exbus_tim3_field_t;

typedef struct stc_exbus_tim4_field
{
    union {
        struct {
            __IO  uint32_t  RACC                 :4;
            __IO  uint32_t  RADC                 :4;
            __IO  uint32_t  FRADC                :4;
            __IO  uint32_t  RIDLC                :4;
            __IO  uint32_t  WACC                 :4;
            __IO  uint32_t  WADC                 :4;
            __IO  uint32_t  WWEC                 :4;
            __IO  uint32_t  WIDLC                :4;
        };
        struct {
            __IO  uint32_t  RACC0                :1;
            __IO  uint32_t  RACC1                :1;
            __IO  uint32_t  RACC2                :1;
            __IO  uint32_t  RACC3                :1;
            __IO  uint32_t  RADC0                :1;
            __IO  uint32_t  RADC1                :1;
            __IO  uint32_t  RADC2                :1;
            __IO  uint32_t  RADC3                :1;
            __IO  uint32_t  FRADC0               :1;
            __IO  uint32_t  FRADC1               :1;
            __IO  uint32_t  FRADC2               :1;
            __IO  uint32_t  FRADC3               :1;
            __IO  uint32_t  RIDLC0               :1;
            __IO  uint32_t  RIDLC1               :1;
            __IO  uint32_t  RIDLC2               :1;
            __IO  uint32_t  RIDLC3               :1;
            __IO  uint32_t  WACC0                :1;
            __IO  uint32_t  WACC1                :1;
            __IO  uint32_t  WACC2                :1;
            __IO  uint32_t  WACC3                :1;
            __IO  uint32_t  WADC0                :1;
            __IO  uint32_t  WADC1                :1;
            __IO  uint32_t  WADC2                :1;
            __IO  uint32_t  WADC3                :1;
            __IO  uint32_t  WWEC0                :1;
            __IO  uint32_t  WWEC1                :1;
            __IO  uint32_t  WWEC2                :1;
            __IO  uint32_t  WWEC3                :1;
            __IO  uint32_t  WIDLC0               :1;
            __IO  uint32_t  WIDLC1               :1;
            __IO  uint32_t  WIDLC2               :1;
            __IO  uint32_t  WIDLC3               :1;
        };
    };
} stc_exbus_tim4_field_t;

typedef struct stc_exbus_tim5_field
{
    union {
        struct {
            __IO  uint32_t  RACC                 :4;
            __IO  uint32_t  RADC                 :4;
            __IO  uint32_t  FRADC                :4;
            __IO  uint32_t  RIDLC                :4;
            __IO  uint32_t  WACC                 :4;
            __IO  uint32_t  WADC                 :4;
            __IO  uint32_t  WWEC                 :4;
            __IO  uint32_t  WIDLC                :4;
        };
        struct {
            __IO  uint32_t  RACC0                :1;
            __IO  uint32_t  RACC1                :1;
            __IO  uint32_t  RACC2                :1;
            __IO  uint32_t  RACC3                :1;
            __IO  uint32_t  RADC0                :1;
            __IO  uint32_t  RADC1                :1;
            __IO  uint32_t  RADC2                :1;
            __IO  uint32_t  RADC3                :1;
            __IO  uint32_t  FRADC0               :1;
            __IO  uint32_t  FRADC1               :1;
            __IO  uint32_t  FRADC2               :1;
            __IO  uint32_t  FRADC3               :1;
            __IO  uint32_t  RIDLC0               :1;
            __IO  uint32_t  RIDLC1               :1;
            __IO  uint32_t  RIDLC2               :1;
            __IO  uint32_t  RIDLC3               :1;
            __IO  uint32_t  WACC0                :1;
            __IO  uint32_t  WACC1                :1;
            __IO  uint32_t  WACC2                :1;
            __IO  uint32_t  WACC3                :1;
            __IO  uint32_t  WADC0                :1;
            __IO  uint32_t  WADC1                :1;
            __IO  uint32_t  WADC2                :1;
            __IO  uint32_t  WADC3                :1;
            __IO  uint32_t  WWEC0                :1;
            __IO  uint32_t  WWEC1                :1;
            __IO  uint32_t  WWEC2                :1;
            __IO  uint32_t  WWEC3                :1;
            __IO  uint32_t  WIDLC0               :1;
            __IO  uint32_t  WIDLC1               :1;
            __IO  uint32_t  WIDLC2               :1;
            __IO  uint32_t  WIDLC3               :1;
        };
    };
} stc_exbus_tim5_field_t;

typedef struct stc_exbus_tim6_field
{
    union {
        struct {
            __IO  uint32_t  RACC                 :4;
            __IO  uint32_t  RADC                 :4;
            __IO  uint32_t  FRADC                :4;
            __IO  uint32_t  RIDLC                :4;
            __IO  uint32_t  WACC                 :4;
            __IO  uint32_t  WADC                 :4;
            __IO  uint32_t  WWEC                 :4;
            __IO  uint32_t  WIDLC                :4;
        };
        struct {
            __IO  uint32_t  RACC0                :1;
            __IO  uint32_t  RACC1                :1;
            __IO  uint32_t  RACC2                :1;
            __IO  uint32_t  RACC3                :1;
            __IO  uint32_t  RADC0                :1;
            __IO  uint32_t  RADC1                :1;
            __IO  uint32_t  RADC2                :1;
            __IO  uint32_t  RADC3                :1;
            __IO  uint32_t  FRADC0               :1;
            __IO  uint32_t  FRADC1               :1;
            __IO  uint32_t  FRADC2               :1;
            __IO  uint32_t  FRADC3               :1;
            __IO  uint32_t  RIDLC0               :1;
            __IO  uint32_t  RIDLC1               :1;
            __IO  uint32_t  RIDLC2               :1;
            __IO  uint32_t  RIDLC3               :1;
            __IO  uint32_t  WACC0                :1;
            __IO  uint32_t  WACC1                :1;
            __IO  uint32_t  WACC2                :1;
            __IO  uint32_t  WACC3                :1;
            __IO  uint32_t  WADC0                :1;
            __IO  uint32_t  WADC1                :1;
            __IO  uint32_t  WADC2                :1;
            __IO  uint32_t  WADC3                :1;
            __IO  uint32_t  WWEC0                :1;
            __IO  uint32_t  WWEC1                :1;
            __IO  uint32_t  WWEC2                :1;
            __IO  uint32_t  WWEC3                :1;
            __IO  uint32_t  WIDLC0               :1;
            __IO  uint32_t  WIDLC1               :1;
            __IO  uint32_t  WIDLC2               :1;
            __IO  uint32_t  WIDLC3               :1;
        };
    };
} stc_exbus_tim6_field_t;

typedef struct stc_exbus_tim7_field
{
    union {
        struct {
            __IO  uint32_t  RACC                 :4;
            __IO  uint32_t  RADC                 :4;
            __IO  uint32_t  FRADC                :4;
            __IO  uint32_t  RIDLC                :4;
            __IO  uint32_t  WACC                 :4;
            __IO  uint32_t  WADC                 :4;
            __IO  uint32_t  WWEC                 :4;
            __IO  uint32_t  WIDLC                :4;
        };
        struct {
            __IO  uint32_t  RACC0                :1;
            __IO  uint32_t  RACC1                :1;
            __IO  uint32_t  RACC2                :1;
            __IO  uint32_t  RACC3                :1;
            __IO  uint32_t  RADC0                :1;
            __IO  uint32_t  RADC1                :1;
            __IO  uint32_t  RADC2                :1;
            __IO  uint32_t  RADC3                :1;
            __IO  uint32_t  FRADC0               :1;
            __IO  uint32_t  FRADC1               :1;
            __IO  uint32_t  FRADC2               :1;
            __IO  uint32_t  FRADC3               :1;
            __IO  uint32_t  RIDLC0               :1;
            __IO  uint32_t  RIDLC1               :1;
            __IO  uint32_t  RIDLC2               :1;
            __IO  uint32_t  RIDLC3               :1;
            __IO  uint32_t  WACC0                :1;
            __IO  uint32_t  WACC1                :1;
            __IO  uint32_t  WACC2                :1;
            __IO  uint32_t  WACC3                :1;
            __IO  uint32_t  WADC0                :1;
            __IO  uint32_t  WADC1                :1;
            __IO  uint32_t  WADC2                :1;
            __IO  uint32_t  WADC3                :1;
            __IO  uint32_t  WWEC0                :1;
            __IO  uint32_t  WWEC1                :1;
            __IO  uint32_t  WWEC2                :1;
            __IO  uint32_t  WWEC3                :1;
            __IO  uint32_t  WIDLC0               :1;
            __IO  uint32_t  WIDLC1               :1;
            __IO  uint32_t  WIDLC2               :1;
            __IO  uint32_t  WIDLC3               :1;
        };
    };
} stc_exbus_tim7_field_t;

typedef struct stc_exbus_area0_field
{
    union {
        struct {
            __IO  uint32_t  ADDR                 :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MASK                 :7;
            __IO  uint32_t  RESERVED2            :9;
        };
        struct {
            __IO  uint32_t  ADDR0                :1;
            __IO  uint32_t  ADDR1                :1;
            __IO  uint32_t  ADDR2                :1;
            __IO  uint32_t  ADDR3                :1;
            __IO  uint32_t  ADDR4                :1;
            __IO  uint32_t  ADDR5                :1;
            __IO  uint32_t  ADDR6                :1;
            __IO  uint32_t  ADDR7                :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MASK0                :1;
            __IO  uint32_t  MASK1                :1;
            __IO  uint32_t  MASK2                :1;
            __IO  uint32_t  MASK3                :1;
            __IO  uint32_t  MASK4                :1;
            __IO  uint32_t  MASK5                :1;
            __IO  uint32_t  MASK6                :1;
            __IO  uint32_t  RESERVED3            :9;
        };
    };
} stc_exbus_area0_field_t;

typedef struct stc_exbus_area1_field
{
    union {
        struct {
            __IO  uint32_t  ADDR                 :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MASK                 :7;
            __IO  uint32_t  RESERVED2            :9;
        };
        struct {
            __IO  uint32_t  ADDR0                :1;
            __IO  uint32_t  ADDR1                :1;
            __IO  uint32_t  ADDR2                :1;
            __IO  uint32_t  ADDR3                :1;
            __IO  uint32_t  ADDR4                :1;
            __IO  uint32_t  ADDR5                :1;
            __IO  uint32_t  ADDR6                :1;
            __IO  uint32_t  ADDR7                :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MASK0                :1;
            __IO  uint32_t  MASK1                :1;
            __IO  uint32_t  MASK2                :1;
            __IO  uint32_t  MASK3                :1;
            __IO  uint32_t  MASK4                :1;
            __IO  uint32_t  MASK5                :1;
            __IO  uint32_t  MASK6                :1;
            __IO  uint32_t  RESERVED3            :9;
        };
    };
} stc_exbus_area1_field_t;

typedef struct stc_exbus_area2_field
{
    union {
        struct {
            __IO  uint32_t  ADDR                 :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MASK                 :7;
            __IO  uint32_t  RESERVED2            :9;
        };
        struct {
            __IO  uint32_t  ADDR0                :1;
            __IO  uint32_t  ADDR1                :1;
            __IO  uint32_t  ADDR2                :1;
            __IO  uint32_t  ADDR3                :1;
            __IO  uint32_t  ADDR4                :1;
            __IO  uint32_t  ADDR5                :1;
            __IO  uint32_t  ADDR6                :1;
            __IO  uint32_t  ADDR7                :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MASK0                :1;
            __IO  uint32_t  MASK1                :1;
            __IO  uint32_t  MASK2                :1;
            __IO  uint32_t  MASK3                :1;
            __IO  uint32_t  MASK4                :1;
            __IO  uint32_t  MASK5                :1;
            __IO  uint32_t  MASK6                :1;
            __IO  uint32_t  RESERVED3            :9;
        };
    };
} stc_exbus_area2_field_t;

typedef struct stc_exbus_area3_field
{
    union {
        struct {
            __IO  uint32_t  ADDR                 :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MASK                 :7;
            __IO  uint32_t  RESERVED2            :9;
        };
        struct {
            __IO  uint32_t  ADDR0                :1;
            __IO  uint32_t  ADDR1                :1;
            __IO  uint32_t  ADDR2                :1;
            __IO  uint32_t  ADDR3                :1;
            __IO  uint32_t  ADDR4                :1;
            __IO  uint32_t  ADDR5                :1;
            __IO  uint32_t  ADDR6                :1;
            __IO  uint32_t  ADDR7                :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MASK0                :1;
            __IO  uint32_t  MASK1                :1;
            __IO  uint32_t  MASK2                :1;
            __IO  uint32_t  MASK3                :1;
            __IO  uint32_t  MASK4                :1;
            __IO  uint32_t  MASK5                :1;
            __IO  uint32_t  MASK6                :1;
            __IO  uint32_t  RESERVED3            :9;
        };
    };
} stc_exbus_area3_field_t;

typedef struct stc_exbus_area4_field
{
    union {
        struct {
            __IO  uint32_t  ADDR                 :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MASK                 :7;
            __IO  uint32_t  RESERVED2            :9;
        };
        struct {
            __IO  uint32_t  ADDR0                :1;
            __IO  uint32_t  ADDR1                :1;
            __IO  uint32_t  ADDR2                :1;
            __IO  uint32_t  ADDR3                :1;
            __IO  uint32_t  ADDR4                :1;
            __IO  uint32_t  ADDR5                :1;
            __IO  uint32_t  ADDR6                :1;
            __IO  uint32_t  ADDR7                :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MASK0                :1;
            __IO  uint32_t  MASK1                :1;
            __IO  uint32_t  MASK2                :1;
            __IO  uint32_t  MASK3                :1;
            __IO  uint32_t  MASK4                :1;
            __IO  uint32_t  MASK5                :1;
            __IO  uint32_t  MASK6                :1;
            __IO  uint32_t  RESERVED3            :9;
        };
    };
} stc_exbus_area4_field_t;

typedef struct stc_exbus_area5_field
{
    union {
        struct {
            __IO  uint32_t  ADDR                 :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MASK                 :7;
            __IO  uint32_t  RESERVED2            :9;
        };
        struct {
            __IO  uint32_t  ADDR0                :1;
            __IO  uint32_t  ADDR1                :1;
            __IO  uint32_t  ADDR2                :1;
            __IO  uint32_t  ADDR3                :1;
            __IO  uint32_t  ADDR4                :1;
            __IO  uint32_t  ADDR5                :1;
            __IO  uint32_t  ADDR6                :1;
            __IO  uint32_t  ADDR7                :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MASK0                :1;
            __IO  uint32_t  MASK1                :1;
            __IO  uint32_t  MASK2                :1;
            __IO  uint32_t  MASK3                :1;
            __IO  uint32_t  MASK4                :1;
            __IO  uint32_t  MASK5                :1;
            __IO  uint32_t  MASK6                :1;
            __IO  uint32_t  RESERVED3            :9;
        };
    };
} stc_exbus_area5_field_t;

typedef struct stc_exbus_area6_field
{
    union {
        struct {
            __IO  uint32_t  ADDR                 :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MASK                 :7;
            __IO  uint32_t  RESERVED2            :9;
        };
        struct {
            __IO  uint32_t  ADDR0                :1;
            __IO  uint32_t  ADDR1                :1;
            __IO  uint32_t  ADDR2                :1;
            __IO  uint32_t  ADDR3                :1;
            __IO  uint32_t  ADDR4                :1;
            __IO  uint32_t  ADDR5                :1;
            __IO  uint32_t  ADDR6                :1;
            __IO  uint32_t  ADDR7                :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MASK0                :1;
            __IO  uint32_t  MASK1                :1;
            __IO  uint32_t  MASK2                :1;
            __IO  uint32_t  MASK3                :1;
            __IO  uint32_t  MASK4                :1;
            __IO  uint32_t  MASK5                :1;
            __IO  uint32_t  MASK6                :1;
            __IO  uint32_t  RESERVED3            :9;
        };
    };
} stc_exbus_area6_field_t;

typedef struct stc_exbus_area7_field
{
    union {
        struct {
            __IO  uint32_t  ADDR                 :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  MASK                 :7;
            __IO  uint32_t  RESERVED2            :9;
        };
        struct {
            __IO  uint32_t  ADDR0                :1;
            __IO  uint32_t  ADDR1                :1;
            __IO  uint32_t  ADDR2                :1;
            __IO  uint32_t  ADDR3                :1;
            __IO  uint32_t  ADDR4                :1;
            __IO  uint32_t  ADDR5                :1;
            __IO  uint32_t  ADDR6                :1;
            __IO  uint32_t  ADDR7                :1;
            __IO  uint32_t  RESERVED1            :8;
            __IO  uint32_t  MASK0                :1;
            __IO  uint32_t  MASK1                :1;
            __IO  uint32_t  MASK2                :1;
            __IO  uint32_t  MASK3                :1;
            __IO  uint32_t  MASK4                :1;
            __IO  uint32_t  MASK5                :1;
            __IO  uint32_t  MASK6                :1;
            __IO  uint32_t  RESERVED3            :9;
        };
    };
} stc_exbus_area7_field_t;

typedef struct stc_exbus_atim0_field
{
    union {
        struct {
            __IO  uint32_t  ALC                  :4;
            __IO  uint32_t  ALES                 :4;
            __IO  uint32_t  ALEW                 :4;
            __IO  uint32_t  RESERVED0            :20;
        };
        struct {
            __IO  uint32_t  ALC0                 :1;
            __IO  uint32_t  ALC1                 :1;
            __IO  uint32_t  ALC2                 :1;
            __IO  uint32_t  ALC3                 :1;
            __IO  uint32_t  ALES0                :1;
            __IO  uint32_t  ALES1                :1;
            __IO  uint32_t  ALES2                :1;
            __IO  uint32_t  ALES3                :1;
            __IO  uint32_t  ALEW0                :1;
            __IO  uint32_t  ALEW1                :1;
            __IO  uint32_t  ALEW2                :1;
            __IO  uint32_t  ALEW3                :1;
            __IO  uint32_t  RESERVED1            :20;
        };
    };
} stc_exbus_atim0_field_t;

typedef struct stc_exbus_atim1_field
{
    union {
        struct {
            __IO  uint32_t  ALC                  :4;
            __IO  uint32_t  ALES                 :4;
            __IO  uint32_t  ALEW                 :4;
            __IO  uint32_t  RESERVED0            :20;
        };
        struct {
            __IO  uint32_t  ALC0                 :1;
            __IO  uint32_t  ALC1                 :1;
            __IO  uint32_t  ALC2                 :1;
            __IO  uint32_t  ALC3                 :1;
            __IO  uint32_t  ALES0                :1;
            __IO  uint32_t  ALES1                :1;
            __IO  uint32_t  ALES2                :1;
            __IO  uint32_t  ALES3                :1;
            __IO  uint32_t  ALEW0                :1;
            __IO  uint32_t  ALEW1                :1;
            __IO  uint32_t  ALEW2                :1;
            __IO  uint32_t  ALEW3                :1;
            __IO  uint32_t  RESERVED1            :20;
        };
    };
} stc_exbus_atim1_field_t;

typedef struct stc_exbus_atim2_field
{
    union {
        struct {
            __IO  uint32_t  ALC                  :4;
            __IO  uint32_t  ALES                 :4;
            __IO  uint32_t  ALEW                 :4;
            __IO  uint32_t  RESERVED0            :20;
        };
        struct {
            __IO  uint32_t  ALC0                 :1;
            __IO  uint32_t  ALC1                 :1;
            __IO  uint32_t  ALC2                 :1;
            __IO  uint32_t  ALC3                 :1;
            __IO  uint32_t  ALES0                :1;
            __IO  uint32_t  ALES1                :1;
            __IO  uint32_t  ALES2                :1;
            __IO  uint32_t  ALES3                :1;
            __IO  uint32_t  ALEW0                :1;
            __IO  uint32_t  ALEW1                :1;
            __IO  uint32_t  ALEW2                :1;
            __IO  uint32_t  ALEW3                :1;
            __IO  uint32_t  RESERVED1            :20;
        };
    };
} stc_exbus_atim2_field_t;

typedef struct stc_exbus_atim3_field
{
    union {
        struct {
            __IO  uint32_t  ALC                  :4;
            __IO  uint32_t  ALES                 :4;
            __IO  uint32_t  ALEW                 :4;
            __IO  uint32_t  RESERVED0            :20;
        };
        struct {
            __IO  uint32_t  ALC0                 :1;
            __IO  uint32_t  ALC1                 :1;
            __IO  uint32_t  ALC2                 :1;
            __IO  uint32_t  ALC3                 :1;
            __IO  uint32_t  ALES0                :1;
            __IO  uint32_t  ALES1                :1;
            __IO  uint32_t  ALES2                :1;
            __IO  uint32_t  ALES3                :1;
            __IO  uint32_t  ALEW0                :1;
            __IO  uint32_t  ALEW1                :1;
            __IO  uint32_t  ALEW2                :1;
            __IO  uint32_t  ALEW3                :1;
            __IO  uint32_t  RESERVED1            :20;
        };
    };
} stc_exbus_atim3_field_t;

typedef struct stc_exbus_atim4_field
{
    union {
        struct {
            __IO  uint32_t  ALC                  :4;
            __IO  uint32_t  ALES                 :4;
            __IO  uint32_t  ALEW                 :4;
            __IO  uint32_t  RESERVED0            :20;
        };
        struct {
            __IO  uint32_t  ALC0                 :1;
            __IO  uint32_t  ALC1                 :1;
            __IO  uint32_t  ALC2                 :1;
            __IO  uint32_t  ALC3                 :1;
            __IO  uint32_t  ALES0                :1;
            __IO  uint32_t  ALES1                :1;
            __IO  uint32_t  ALES2                :1;
            __IO  uint32_t  ALES3                :1;
            __IO  uint32_t  ALEW0                :1;
            __IO  uint32_t  ALEW1                :1;
            __IO  uint32_t  ALEW2                :1;
            __IO  uint32_t  ALEW3                :1;
            __IO  uint32_t  RESERVED1            :20;
        };
    };
} stc_exbus_atim4_field_t;

typedef struct stc_exbus_atim5_field
{
    union {
        struct {
            __IO  uint32_t  ALC                  :4;
            __IO  uint32_t  ALES                 :4;
            __IO  uint32_t  ALEW                 :4;
            __IO  uint32_t  RESERVED0            :20;
        };
        struct {
            __IO  uint32_t  ALC0                 :1;
            __IO  uint32_t  ALC1                 :1;
            __IO  uint32_t  ALC2                 :1;
            __IO  uint32_t  ALC3                 :1;
            __IO  uint32_t  ALES0                :1;
            __IO  uint32_t  ALES1                :1;
            __IO  uint32_t  ALES2                :1;
            __IO  uint32_t  ALES3                :1;
            __IO  uint32_t  ALEW0                :1;
            __IO  uint32_t  ALEW1                :1;
            __IO  uint32_t  ALEW2                :1;
            __IO  uint32_t  ALEW3                :1;
            __IO  uint32_t  RESERVED1            :20;
        };
    };
} stc_exbus_atim5_field_t;

typedef struct stc_exbus_atim6_field
{
    union {
        struct {
            __IO  uint32_t  ALC                  :4;
            __IO  uint32_t  ALES                 :4;
            __IO  uint32_t  ALEW                 :4;
            __IO  uint32_t  RESERVED0            :20;
        };
        struct {
            __IO  uint32_t  ALC0                 :1;
            __IO  uint32_t  ALC1                 :1;
            __IO  uint32_t  ALC2                 :1;
            __IO  uint32_t  ALC3                 :1;
            __IO  uint32_t  ALES0                :1;
            __IO  uint32_t  ALES1                :1;
            __IO  uint32_t  ALES2                :1;
            __IO  uint32_t  ALES3                :1;
            __IO  uint32_t  ALEW0                :1;
            __IO  uint32_t  ALEW1                :1;
            __IO  uint32_t  ALEW2                :1;
            __IO  uint32_t  ALEW3                :1;
            __IO  uint32_t  RESERVED1            :20;
        };
    };
} stc_exbus_atim6_field_t;

typedef struct stc_exbus_atim7_field
{
    union {
        struct {
            __IO  uint32_t  ALC                  :4;
            __IO  uint32_t  ALES                 :4;
            __IO  uint32_t  ALEW                 :4;
            __IO  uint32_t  RESERVED0            :20;
        };
        struct {
            __IO  uint32_t  ALC0                 :1;
            __IO  uint32_t  ALC1                 :1;
            __IO  uint32_t  ALC2                 :1;
            __IO  uint32_t  ALC3                 :1;
            __IO  uint32_t  ALES0                :1;
            __IO  uint32_t  ALES1                :1;
            __IO  uint32_t  ALES2                :1;
            __IO  uint32_t  ALES3                :1;
            __IO  uint32_t  ALEW0                :1;
            __IO  uint32_t  ALEW1                :1;
            __IO  uint32_t  ALEW2                :1;
            __IO  uint32_t  ALEW3                :1;
            __IO  uint32_t  RESERVED1            :20;
        };
    };
} stc_exbus_atim7_field_t;

typedef struct stc_exbus_sdmode_field
{
    union {
        struct {
            __IO  uint32_t  SDON                 :1;
            __IO  uint32_t  PDON                 :1;
            __IO  uint32_t  ROFF                 :1;
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  CASEL                :2;
            __IO  uint32_t  RESERVED2            :2;
            __IO  uint32_t  RASEL                :4;
            __IO  uint32_t  BASEL                :4;
            __IO  uint32_t  MSDCLKOFF            :1;
            __IO  uint32_t  RESERVED4            :15;
        };
        struct {
            __IO  uint32_t  RESERVED1            :4;
            __IO  uint32_t  CASEL0               :1;
            __IO  uint32_t  CASEL1               :1;
            __IO  uint32_t  RESERVED3            :2;
            __IO  uint32_t  RASEL0               :1;
            __IO  uint32_t  RASEL1               :1;
            __IO  uint32_t  RASEL2               :1;
            __IO  uint32_t  RASEL3               :1;
            __IO  uint32_t  BASEL0               :1;
            __IO  uint32_t  BASEL1               :1;
            __IO  uint32_t  BASEL2               :1;
            __IO  uint32_t  BASEL3               :1;
            __IO  uint32_t  RESERVED5            :16;
        };
    };
} stc_exbus_sdmode_field_t;

typedef struct stc_exbus_reftim_field
{
    union {
        struct {
            __IO  uint32_t  REFC                 :16;
            __IO  uint32_t  NREF                 :8;
            __IO  uint32_t  PREF                 :1;
            __IO  uint32_t  RESERVED0            :7;
        };
        struct {
            __IO  uint32_t  REFC0                :1;
            __IO  uint32_t  REFC1                :1;
            __IO  uint32_t  REFC2                :1;
            __IO  uint32_t  REFC3                :1;
            __IO  uint32_t  REFC4                :1;
            __IO  uint32_t  REFC5                :1;
            __IO  uint32_t  REFC6                :1;
            __IO  uint32_t  REFC7                :1;
            __IO  uint32_t  REFC8                :1;
            __IO  uint32_t  REFC9                :1;
            __IO  uint32_t  REFC10               :1;
            __IO  uint32_t  REFC11               :1;
            __IO  uint32_t  REFC12               :1;
            __IO  uint32_t  REFC13               :1;
            __IO  uint32_t  REFC14               :1;
            __IO  uint32_t  REFC15               :1;
            __IO  uint32_t  NREF0                :1;
            __IO  uint32_t  NREF1                :1;
            __IO  uint32_t  NREF2                :1;
            __IO  uint32_t  NREF3                :1;
            __IO  uint32_t  NREF4                :1;
            __IO  uint32_t  NREF5                :1;
            __IO  uint32_t  NREF6                :1;
            __IO  uint32_t  NREF7                :1;
            __IO  uint32_t  RESERVED1            :8;
        };
    };
} stc_exbus_reftim_field_t;

typedef struct stc_exbus_pwrdwn_field
{
    union {
        struct {
            __IO  uint32_t  PDC                  :16;
            __IO  uint32_t  RESERVED0            :16;
        };
        struct {
            __IO  uint32_t  PDC0                 :1;
            __IO  uint32_t  PDC1                 :1;
            __IO  uint32_t  PDC2                 :1;
            __IO  uint32_t  PDC3                 :1;
            __IO  uint32_t  PDC4                 :1;
            __IO  uint32_t  PDC5                 :1;
            __IO  uint32_t  PDC6                 :1;
            __IO  uint32_t  PDC7                 :1;
            __IO  uint32_t  PDC8                 :1;
            __IO  uint32_t  PDC9                 :1;
            __IO  uint32_t  PDC10                :1;
            __IO  uint32_t  PDC11                :1;
            __IO  uint32_t  PDC12                :1;
            __IO  uint32_t  PDC13                :1;
            __IO  uint32_t  PDC14                :1;
            __IO  uint32_t  PDC15                :1;
            __IO  uint32_t  RESERVED1            :16;
        };
    };
} stc_exbus_pwrdwn_field_t;

typedef struct stc_exbus_sdtim_field
{
    union {
        struct {
            __IO  uint32_t  CL                   :2;
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  TRC                  :4;
            __IO  uint32_t  TRP                  :4;
            __IO  uint32_t  TRCD                 :4;
            __IO  uint32_t  TRAS                 :4;
            __IO  uint32_t  TREFC                :4;
            __IO  uint32_t  TDPL                 :2;
            __IO  uint32_t  RESERVED2            :5;
            __IO  uint32_t  BOFF                 :1;
        };
        struct {
            __IO  uint32_t  CL0                  :1;
            __IO  uint32_t  CL1                  :1;
            __IO  uint32_t  RESERVED1            :2;
            __IO  uint32_t  TRC0                 :1;
            __IO  uint32_t  TRC1                 :1;
            __IO  uint32_t  TRC2                 :1;
            __IO  uint32_t  TRC3                 :1;
            __IO  uint32_t  TRP0                 :1;
            __IO  uint32_t  TRP1                 :1;
            __IO  uint32_t  TRP2                 :1;
            __IO  uint32_t  TRP3                 :1;
            __IO  uint32_t  TRCD0                :1;
            __IO  uint32_t  TRCD1                :1;
            __IO  uint32_t  TRCD2                :1;
            __IO  uint32_t  TRCD3                :1;
            __IO  uint32_t  TRAS0                :1;
            __IO  uint32_t  TRAS1                :1;
            __IO  uint32_t  TRAS2                :1;
            __IO  uint32_t  TRAS3                :1;
            __IO  uint32_t  TREFC0               :1;
            __IO  uint32_t  TREFC1               :1;
            __IO  uint32_t  TREFC2               :1;
            __IO  uint32_t  TREFC3               :1;
            __IO  uint32_t  TDPL0                :1;
            __IO  uint32_t  TDPL1                :1;
            __IO  uint32_t  RESERVED3            :6;
        };
    };
} stc_exbus_sdtim_field_t;

typedef struct stc_exbus_sdcmd_field
{
    union {
        struct {
            __IO  uint32_t  SDAD                 :16;
            __IO  uint32_t  SDWE                 :1;
            __IO  uint32_t  SDCAS                :1;
            __IO  uint32_t  SDRAS                :1;
            __IO  uint32_t  SDCS                 :1;
            __IO  uint32_t  SDCKE                :1;
            __IO  uint32_t  RESERVED0            :10;
            __IO  uint32_t  PEND                 :1;
        };
        struct {
            __IO  uint32_t  SDAD0                :1;
            __IO  uint32_t  SDAD1                :1;
            __IO  uint32_t  SDAD2                :1;
            __IO  uint32_t  SDAD3                :1;
            __IO  uint32_t  SDAD4                :1;
            __IO  uint32_t  SDAD5                :1;
            __IO  uint32_t  SDAD6                :1;
            __IO  uint32_t  SDAD7                :1;
            __IO  uint32_t  SDAD8                :1;
            __IO  uint32_t  SDAD9                :1;
            __IO  uint32_t  SDAD10               :1;
            __IO  uint32_t  SDAD11               :1;
            __IO  uint32_t  SDAD12               :1;
            __IO  uint32_t  SDAD13               :1;
            __IO  uint32_t  SDAD14               :1;
            __IO  uint32_t  SDAD15               :1;
            __IO  uint32_t  RESERVED1            :16;
        };
    };
} stc_exbus_sdcmd_field_t;

typedef struct stc_exbus_memcerr_field
{
        __IO  uint32_t  SFER                     :1;
        __IO  uint32_t  SDER                     :1;
        __IO  uint32_t  SFION                    :1;
        __IO  uint32_t  SDION                    :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_exbus_memcerr_field_t;

typedef struct stc_exbus_dclkr_field
{
    union {
        struct {
            __IO  uint32_t  MDIV                 :4;
            __IO  uint32_t  MCLKON               :1;
            __IO  uint32_t  RESERVED0            :27;
        };
        struct {
            __IO  uint32_t  MDIV0                :1;
            __IO  uint32_t  MDIV1                :1;
            __IO  uint32_t  MDIV2                :1;
            __IO  uint32_t  MDIV3                :1;
            __IO  uint32_t  RESERVED1            :28;
        };
    };
} stc_exbus_dclkr_field_t;

typedef struct stc_exbus_est_field
{
        __IO  uint32_t  WERR                     :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_exbus_est_field_t;

typedef struct stc_exbus_wead_field
{
    union {
        struct {
            __IO  uint32_t  ADDR                 :32;
        };
        struct {
            __IO  uint32_t  ADDR0                :1;
            __IO  uint32_t  ADDR1                :1;
            __IO  uint32_t  ADDR2                :1;
            __IO  uint32_t  ADDR3                :1;
            __IO  uint32_t  ADDR4                :1;
            __IO  uint32_t  ADDR5                :1;
            __IO  uint32_t  ADDR6                :1;
            __IO  uint32_t  ADDR7                :1;
            __IO  uint32_t  ADDR8                :1;
            __IO  uint32_t  ADDR9                :1;
            __IO  uint32_t  ADDR10               :1;
            __IO  uint32_t  ADDR11               :1;
            __IO  uint32_t  ADDR12               :1;
            __IO  uint32_t  ADDR13               :1;
            __IO  uint32_t  ADDR14               :1;
            __IO  uint32_t  ADDR15               :1;
            __IO  uint32_t  ADDR16               :1;
            __IO  uint32_t  ADDR17               :1;
            __IO  uint32_t  ADDR18               :1;
            __IO  uint32_t  ADDR19               :1;
            __IO  uint32_t  ADDR20               :1;
            __IO  uint32_t  ADDR21               :1;
            __IO  uint32_t  ADDR22               :1;
            __IO  uint32_t  ADDR23               :1;
            __IO  uint32_t  ADDR24               :1;
            __IO  uint32_t  ADDR25               :1;
            __IO  uint32_t  ADDR26               :1;
            __IO  uint32_t  ADDR27               :1;
            __IO  uint32_t  ADDR28               :1;
            __IO  uint32_t  ADDR29               :1;
            __IO  uint32_t  ADDR30               :1;
            __IO  uint32_t  ADDR31               :1;
        };
    };
} stc_exbus_wead_field_t;

typedef struct stc_exbus_esclr_field
{
        __IO  uint32_t  WERRCLR                  :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_exbus_esclr_field_t;

typedef struct stc_exbus_amode_field
{
        __IO  uint32_t  WAEN                     :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_exbus_amode_field_t;

/******************************************************************************
 ** EXTI_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_exti_enir_field
{
        __IO  uint32_t  EN0                      :1;
        __IO  uint32_t  EN1                      :1;
        __IO  uint32_t  EN2                      :1;
        __IO  uint32_t  EN3                      :1;
        __IO  uint32_t  EN4                      :1;
        __IO  uint32_t  EN5                      :1;
        __IO  uint32_t  EN6                      :1;
        __IO  uint32_t  EN7                      :1;
        __IO  uint32_t  EN8                      :1;
        __IO  uint32_t  EN9                      :1;
        __IO  uint32_t  EN10                     :1;
        __IO  uint32_t  EN11                     :1;
        __IO  uint32_t  EN12                     :1;
        __IO  uint32_t  EN13                     :1;
        __IO  uint32_t  EN14                     :1;
        __IO  uint32_t  EN15                     :1;
        __IO  uint32_t  EN16                     :1;
        __IO  uint32_t  EN17                     :1;
        __IO  uint32_t  EN18                     :1;
        __IO  uint32_t  EN19                     :1;
        __IO  uint32_t  EN20                     :1;
        __IO  uint32_t  EN21                     :1;
        __IO  uint32_t  EN22                     :1;
        __IO  uint32_t  EN23                     :1;
        __IO  uint32_t  EN24                     :1;
        __IO  uint32_t  EN25                     :1;
        __IO  uint32_t  EN26                     :1;
        __IO  uint32_t  EN27                     :1;
        __IO  uint32_t  EN28                     :1;
        __IO  uint32_t  EN29                     :1;
        __IO  uint32_t  EN30                     :1;
        __IO  uint32_t  EN31                     :1;
} stc_exti_enir_field_t;

typedef struct stc_exti_eirr_field
{
        __IO  uint32_t  ER0                      :1;
        __IO  uint32_t  ER1                      :1;
        __IO  uint32_t  ER2                      :1;
        __IO  uint32_t  ER3                      :1;
        __IO  uint32_t  ER4                      :1;
        __IO  uint32_t  ER5                      :1;
        __IO  uint32_t  ER6                      :1;
        __IO  uint32_t  ER7                      :1;
        __IO  uint32_t  ER8                      :1;
        __IO  uint32_t  ER9                      :1;
        __IO  uint32_t  ER10                     :1;
        __IO  uint32_t  ER11                     :1;
        __IO  uint32_t  ER12                     :1;
        __IO  uint32_t  ER13                     :1;
        __IO  uint32_t  ER14                     :1;
        __IO  uint32_t  ER15                     :1;
        __IO  uint32_t  ER16                     :1;
        __IO  uint32_t  ER17                     :1;
        __IO  uint32_t  ER18                     :1;
        __IO  uint32_t  ER19                     :1;
        __IO  uint32_t  ER20                     :1;
        __IO  uint32_t  ER21                     :1;
        __IO  uint32_t  ER22                     :1;
        __IO  uint32_t  ER23                     :1;
        __IO  uint32_t  ER24                     :1;
        __IO  uint32_t  ER25                     :1;
        __IO  uint32_t  ER26                     :1;
        __IO  uint32_t  ER27                     :1;
        __IO  uint32_t  ER28                     :1;
        __IO  uint32_t  ER29                     :1;
        __IO  uint32_t  ER30                     :1;
        __IO  uint32_t  ER31                     :1;
} stc_exti_eirr_field_t;

typedef struct stc_exti_eicl_field
{
        __IO  uint32_t  ECL0                     :1;
        __IO  uint32_t  ECL1                     :1;
        __IO  uint32_t  ECL2                     :1;
        __IO  uint32_t  ECL3                     :1;
        __IO  uint32_t  ECL4                     :1;
        __IO  uint32_t  ECL5                     :1;
        __IO  uint32_t  ECL6                     :1;
        __IO  uint32_t  ECL7                     :1;
        __IO  uint32_t  ECL8                     :1;
        __IO  uint32_t  ECL9                     :1;
        __IO  uint32_t  ECL10                    :1;
        __IO  uint32_t  ECL11                    :1;
        __IO  uint32_t  ECL12                    :1;
        __IO  uint32_t  ECL13                    :1;
        __IO  uint32_t  ECL14                    :1;
        __IO  uint32_t  ECL15                    :1;
        __IO  uint32_t  ECL16                    :1;
        __IO  uint32_t  ECL17                    :1;
        __IO  uint32_t  ECL18                    :1;
        __IO  uint32_t  ECL19                    :1;
        __IO  uint32_t  ECL20                    :1;
        __IO  uint32_t  ECL21                    :1;
        __IO  uint32_t  ECL22                    :1;
        __IO  uint32_t  ECL23                    :1;
        __IO  uint32_t  ECL24                    :1;
        __IO  uint32_t  ECL25                    :1;
        __IO  uint32_t  ECL26                    :1;
        __IO  uint32_t  ECL27                    :1;
        __IO  uint32_t  ECL28                    :1;
        __IO  uint32_t  ECL29                    :1;
        __IO  uint32_t  ECL30                    :1;
        __IO  uint32_t  ECL31                    :1;
} stc_exti_eicl_field_t;

typedef struct stc_exti_elvr_field
{
        __IO  uint32_t  LA0                      :1;
        __IO  uint32_t  LB0                      :1;
        __IO  uint32_t  LA1                      :1;
        __IO  uint32_t  LB1                      :1;
        __IO  uint32_t  LA2                      :1;
        __IO  uint32_t  LB2                      :1;
        __IO  uint32_t  LA3                      :1;
        __IO  uint32_t  LB3                      :1;
        __IO  uint32_t  LA4                      :1;
        __IO  uint32_t  LB4                      :1;
        __IO  uint32_t  LA5                      :1;
        __IO  uint32_t  LB5                      :1;
        __IO  uint32_t  LA6                      :1;
        __IO  uint32_t  LB6                      :1;
        __IO  uint32_t  LA7                      :1;
        __IO  uint32_t  LB7                      :1;
        __IO  uint32_t  LA8                      :1;
        __IO  uint32_t  LB8                      :1;
        __IO  uint32_t  LA9                      :1;
        __IO  uint32_t  LB9                      :1;
        __IO  uint32_t  LA10                     :1;
        __IO  uint32_t  LB10                     :1;
        __IO  uint32_t  LA11                     :1;
        __IO  uint32_t  LB11                     :1;
        __IO  uint32_t  LA12                     :1;
        __IO  uint32_t  LB12                     :1;
        __IO  uint32_t  LA13                     :1;
        __IO  uint32_t  LB13                     :1;
        __IO  uint32_t  LA14                     :1;
        __IO  uint32_t  LB14                     :1;
        __IO  uint32_t  LA15                     :1;
        __IO  uint32_t  LB15                     :1;
} stc_exti_elvr_field_t;

typedef struct stc_exti_elvr1_field
{
        __IO  uint32_t  LA16                     :1;
        __IO  uint32_t  LB16                     :1;
        __IO  uint32_t  LA17                     :1;
        __IO  uint32_t  LB17                     :1;
        __IO  uint32_t  LA18                     :1;
        __IO  uint32_t  LB18                     :1;
        __IO  uint32_t  LA19                     :1;
        __IO  uint32_t  LB19                     :1;
        __IO  uint32_t  LA20                     :1;
        __IO  uint32_t  LB20                     :1;
        __IO  uint32_t  LA21                     :1;
        __IO  uint32_t  LB21                     :1;
        __IO  uint32_t  LA22                     :1;
        __IO  uint32_t  LB22                     :1;
        __IO  uint32_t  LA23                     :1;
        __IO  uint32_t  LB23                     :1;
        __IO  uint32_t  LA24                     :1;
        __IO  uint32_t  LB24                     :1;
        __IO  uint32_t  LA25                     :1;
        __IO  uint32_t  LB25                     :1;
        __IO  uint32_t  LA26                     :1;
        __IO  uint32_t  LB26                     :1;
        __IO  uint32_t  LA27                     :1;
        __IO  uint32_t  LB27                     :1;
        __IO  uint32_t  LA28                     :1;
        __IO  uint32_t  LB28                     :1;
        __IO  uint32_t  LA29                     :1;
        __IO  uint32_t  LB29                     :1;
        __IO  uint32_t  LA30                     :1;
        __IO  uint32_t  LB30                     :1;
        __IO  uint32_t  LA31                     :1;
        __IO  uint32_t  LB31                     :1;
} stc_exti_elvr1_field_t;

typedef struct stc_exti_nmirr_field
{
        __IO  uint16_t  NR                       :1;
        __IO  uint16_t  RESERVED0                :15;
} stc_exti_nmirr_field_t;

typedef struct stc_exti_nmicl_field
{
        __IO  uint16_t  NCL                      :1;
        __IO  uint16_t  RESERVED0                :15;
} stc_exti_nmicl_field_t;

typedef struct stc_exti_elvr2_field
{
        __IO  uint32_t  LC0                      :1;
        __IO  uint32_t  LC1                      :1;
        __IO  uint32_t  LC2                      :1;
        __IO  uint32_t  LC3                      :1;
        __IO  uint32_t  LC4                      :1;
        __IO  uint32_t  LC5                      :1;
        __IO  uint32_t  LC6                      :1;
        __IO  uint32_t  LC7                      :1;
        __IO  uint32_t  LC8                      :1;
        __IO  uint32_t  LC9                      :1;
        __IO  uint32_t  LC10                     :1;
        __IO  uint32_t  LC11                     :1;
        __IO  uint32_t  LC12                     :1;
        __IO  uint32_t  LC13                     :1;
        __IO  uint32_t  LC14                     :1;
        __IO  uint32_t  LC15                     :1;
        __IO  uint32_t  LC16                     :1;
        __IO  uint32_t  LC17                     :1;
        __IO  uint32_t  LC18                     :1;
        __IO  uint32_t  LC19                     :1;
        __IO  uint32_t  LC20                     :1;
        __IO  uint32_t  LC21                     :1;
        __IO  uint32_t  LC22                     :1;
        __IO  uint32_t  LC23                     :1;
        __IO  uint32_t  LC24                     :1;
        __IO  uint32_t  LC25                     :1;
        __IO  uint32_t  LC26                     :1;
        __IO  uint32_t  LC27                     :1;
        __IO  uint32_t  LC28                     :1;
        __IO  uint32_t  LC29                     :1;
        __IO  uint32_t  LC30                     :1;
        __IO  uint32_t  LC31                     :1;
} stc_exti_elvr2_field_t;

/******************************************************************************
 ** FLASH_IF_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_flash_if_faszr_field
{
    union {
        struct {
            __IO  uint32_t  ASZ                  :2;
            __IO  uint32_t  RESERVED0            :30;
        };
        struct {
            __IO  uint32_t  ASZ0                 :1;
            __IO  uint32_t  ASZ1                 :1;
            __IO  uint32_t  RESERVED1            :30;
        };
    };
} stc_flash_if_faszr_field_t;

typedef struct stc_flash_if_frwtr_field
{
    union {
        struct {
            __IO  uint32_t  RWT                  :2;
            __IO  uint32_t  RESERVED0            :30;
        };
        struct {
            __IO  uint32_t  RWT0                 :1;
            __IO  uint32_t  RWT1                 :1;
            __IO  uint32_t  RESERVED1            :30;
        };
    };
} stc_flash_if_frwtr_field_t;

typedef struct stc_flash_if_fstr_field
{
        __IO  uint32_t  RDY                      :1;
        __IO  uint32_t  HNG                      :1;
        __IO  uint32_t  ERR                      :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_flash_if_fstr_field_t;

typedef struct stc_flash_if_fsyndn_field
{
    union {
        struct {
            __IO  uint32_t  SD                   :3;
            __IO  uint32_t  RESERVED0            :29;
        };
        struct {
            __IO  uint32_t  SD0                  :1;
            __IO  uint32_t  SD1                  :1;
            __IO  uint32_t  SD2                  :1;
            __IO  uint32_t  RESERVED1            :29;
        };
    };
} stc_flash_if_fsyndn_field_t;

typedef struct stc_flash_if_fbfcr_field
{
        __IO  uint32_t  BE                       :1;
        __IO  uint32_t  BS                       :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_flash_if_fbfcr_field_t;

typedef struct stc_flash_if_ficr_field
{
        __IO  uint32_t  RDYIE                    :1;
        __IO  uint32_t  HNGIE                    :1;
        __IO  uint32_t  ERRIE                    :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_flash_if_ficr_field_t;

typedef struct stc_flash_if_fisr_field
{
        __IO  uint32_t  RDYIF                    :1;
        __IO  uint32_t  HNGIF                    :1;
        __IO  uint32_t  ERRIF                    :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_flash_if_fisr_field_t;

typedef struct stc_flash_if_ficlr_field
{
        __IO  uint32_t  RDYIC                    :1;
        __IO  uint32_t  HNGIC                    :1;
        __IO  uint32_t  ERRIC                    :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_flash_if_ficlr_field_t;

typedef struct stc_flash_if_crtrmm_field
{
    union {
        struct {
            __IO  uint32_t  TRMM                 :10;
            __IO  uint32_t  RESERVED0            :6;
            __IO  uint32_t  TTRMM                :5;
            __IO  uint32_t  RESERVED2            :11;
        };
        struct {
            __IO  uint32_t  TRMM0                :1;
            __IO  uint32_t  TRMM1                :1;
            __IO  uint32_t  TRMM2                :1;
            __IO  uint32_t  TRMM3                :1;
            __IO  uint32_t  TRMM4                :1;
            __IO  uint32_t  TRMM5                :1;
            __IO  uint32_t  TRMM6                :1;
            __IO  uint32_t  TRMM7                :1;
            __IO  uint32_t  TRMM8                :1;
            __IO  uint32_t  TRMM9                :1;
            __IO  uint32_t  RESERVED1            :6;
            __IO  uint32_t  TTRMM0               :1;
            __IO  uint32_t  TTRMM1               :1;
            __IO  uint32_t  TTRMM2               :1;
            __IO  uint32_t  TTRMM3               :1;
            __IO  uint32_t  TTRMM4               :1;
            __IO  uint32_t  RESERVED3            :11;
        };
    };
} stc_flash_if_crtrmm_field_t;

typedef struct stc_flash_if_fgpdm1_field
{
    union {
        struct {
            __IO  uint32_t  GPD1                 :32;
        };
        struct {
            __IO  uint32_t  GPD10                :1;
            __IO  uint32_t  GPD11                :1;
            __IO  uint32_t  GPD12                :1;
            __IO  uint32_t  GPD13                :1;
            __IO  uint32_t  GPD14                :1;
            __IO  uint32_t  GPD15                :1;
            __IO  uint32_t  GPD16                :1;
            __IO  uint32_t  GPD17                :1;
            __IO  uint32_t  GPD18                :1;
            __IO  uint32_t  GPD19                :1;
            __IO  uint32_t  GPD110               :1;
            __IO  uint32_t  GPD111               :1;
            __IO  uint32_t  GPD112               :1;
            __IO  uint32_t  GPD113               :1;
            __IO  uint32_t  GPD114               :1;
            __IO  uint32_t  GPD115               :1;
            __IO  uint32_t  GPD116               :1;
            __IO  uint32_t  GPD117               :1;
            __IO  uint32_t  GPD118               :1;
            __IO  uint32_t  GPD119               :1;
            __IO  uint32_t  GPD120               :1;
            __IO  uint32_t  GPD121               :1;
            __IO  uint32_t  GPD122               :1;
            __IO  uint32_t  GPD123               :1;
            __IO  uint32_t  GPD124               :1;
            __IO  uint32_t  GPD125               :1;
            __IO  uint32_t  GPD126               :1;
            __IO  uint32_t  GPD127               :1;
            __IO  uint32_t  GPD128               :1;
            __IO  uint32_t  GPD129               :1;
            __IO  uint32_t  GPD130               :1;
            __IO  uint32_t  GPD131               :1;
        };
    };
} stc_flash_if_fgpdm1_field_t;

typedef struct stc_flash_if_fgpdm2_field
{
    union {
        struct {
            __IO  uint32_t  GPD2                 :32;
        };
        struct {
            __IO  uint32_t  GPD20                :1;
            __IO  uint32_t  GPD21                :1;
            __IO  uint32_t  GPD22                :1;
            __IO  uint32_t  GPD23                :1;
            __IO  uint32_t  GPD24                :1;
            __IO  uint32_t  GPD25                :1;
            __IO  uint32_t  GPD26                :1;
            __IO  uint32_t  GPD27                :1;
            __IO  uint32_t  GPD28                :1;
            __IO  uint32_t  GPD29                :1;
            __IO  uint32_t  GPD210               :1;
            __IO  uint32_t  GPD211               :1;
            __IO  uint32_t  GPD212               :1;
            __IO  uint32_t  GPD213               :1;
            __IO  uint32_t  GPD214               :1;
            __IO  uint32_t  GPD215               :1;
            __IO  uint32_t  GPD216               :1;
            __IO  uint32_t  GPD217               :1;
            __IO  uint32_t  GPD218               :1;
            __IO  uint32_t  GPD219               :1;
            __IO  uint32_t  GPD220               :1;
            __IO  uint32_t  GPD221               :1;
            __IO  uint32_t  GPD222               :1;
            __IO  uint32_t  GPD223               :1;
            __IO  uint32_t  GPD224               :1;
            __IO  uint32_t  GPD225               :1;
            __IO  uint32_t  GPD226               :1;
            __IO  uint32_t  GPD227               :1;
            __IO  uint32_t  GPD228               :1;
            __IO  uint32_t  GPD229               :1;
            __IO  uint32_t  GPD230               :1;
            __IO  uint32_t  GPD231               :1;
        };
    };
} stc_flash_if_fgpdm2_field_t;

typedef struct stc_flash_if_fgpdm3_field
{
    union {
        struct {
            __IO  uint32_t  GPD3                 :32;
        };
        struct {
            __IO  uint32_t  GPD30                :1;
            __IO  uint32_t  GPD31                :1;
            __IO  uint32_t  GPD32                :1;
            __IO  uint32_t  GPD33                :1;
            __IO  uint32_t  GPD34                :1;
            __IO  uint32_t  GPD35                :1;
            __IO  uint32_t  GPD36                :1;
            __IO  uint32_t  GPD37                :1;
            __IO  uint32_t  GPD38                :1;
            __IO  uint32_t  GPD39                :1;
            __IO  uint32_t  GPD310               :1;
            __IO  uint32_t  GPD311               :1;
            __IO  uint32_t  GPD312               :1;
            __IO  uint32_t  GPD313               :1;
            __IO  uint32_t  GPD314               :1;
            __IO  uint32_t  GPD315               :1;
            __IO  uint32_t  GPD316               :1;
            __IO  uint32_t  GPD317               :1;
            __IO  uint32_t  GPD318               :1;
            __IO  uint32_t  GPD319               :1;
            __IO  uint32_t  GPD320               :1;
            __IO  uint32_t  GPD321               :1;
            __IO  uint32_t  GPD322               :1;
            __IO  uint32_t  GPD323               :1;
            __IO  uint32_t  GPD324               :1;
            __IO  uint32_t  GPD325               :1;
            __IO  uint32_t  GPD326               :1;
            __IO  uint32_t  GPD327               :1;
            __IO  uint32_t  GPD328               :1;
            __IO  uint32_t  GPD329               :1;
            __IO  uint32_t  GPD330               :1;
            __IO  uint32_t  GPD331               :1;
        };
    };
} stc_flash_if_fgpdm3_field_t;

typedef struct stc_flash_if_fgpdm4_field
{
    union {
        struct {
            __IO  uint32_t  GPD4                 :32;
        };
        struct {
            __IO  uint32_t  GPD40                :1;
            __IO  uint32_t  GPD41                :1;
            __IO  uint32_t  GPD42                :1;
            __IO  uint32_t  GPD43                :1;
            __IO  uint32_t  GPD44                :1;
            __IO  uint32_t  GPD45                :1;
            __IO  uint32_t  GPD46                :1;
            __IO  uint32_t  GPD47                :1;
            __IO  uint32_t  GPD48                :1;
            __IO  uint32_t  GPD49                :1;
            __IO  uint32_t  GPD410               :1;
            __IO  uint32_t  GPD411               :1;
            __IO  uint32_t  GPD412               :1;
            __IO  uint32_t  GPD413               :1;
            __IO  uint32_t  GPD414               :1;
            __IO  uint32_t  GPD415               :1;
            __IO  uint32_t  GPD416               :1;
            __IO  uint32_t  GPD417               :1;
            __IO  uint32_t  GPD418               :1;
            __IO  uint32_t  GPD419               :1;
            __IO  uint32_t  GPD420               :1;
            __IO  uint32_t  GPD421               :1;
            __IO  uint32_t  GPD422               :1;
            __IO  uint32_t  GPD423               :1;
            __IO  uint32_t  GPD424               :1;
            __IO  uint32_t  GPD425               :1;
            __IO  uint32_t  GPD426               :1;
            __IO  uint32_t  GPD427               :1;
            __IO  uint32_t  GPD428               :1;
            __IO  uint32_t  GPD429               :1;
            __IO  uint32_t  GPD430               :1;
            __IO  uint32_t  GPD431               :1;
        };
    };
} stc_flash_if_fgpdm4_field_t;

/******************************************************************************
 ** GPIO_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_gpio_pfr0_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  RESERVED0                :3;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED1                :21;
} stc_gpio_pfr0_field_t;

typedef struct stc_gpio_pfr1_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pfr1_field_t;

typedef struct stc_gpio_pfr2_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED0                :21;
} stc_gpio_pfr2_field_t;

typedef struct stc_gpio_pfr3_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED0                :17;
} stc_gpio_pfr3_field_t;

typedef struct stc_gpio_pfr4_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED0                :17;
} stc_gpio_pfr4_field_t;

typedef struct stc_gpio_pfr5_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  RESERVED0                :10;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED1                :16;
} stc_gpio_pfr5_field_t;

typedef struct stc_gpio_pfr6_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  RESERVED0                :8;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED1                :17;
} stc_gpio_pfr6_field_t;

typedef struct stc_gpio_pfr7_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED0                :21;
} stc_gpio_pfr7_field_t;

typedef struct stc_gpio_pfr8_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_gpio_pfr8_field_t;

typedef struct stc_gpio_pfr9_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_gpio_pfr9_field_t;

typedef struct stc_gpio_pfra_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pfra_field_t;

typedef struct stc_gpio_pfrb_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_gpio_pfrb_field_t;

typedef struct stc_gpio_pfrc_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pfrc_field_t;

typedef struct stc_gpio_pfrd_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_gpio_pfrd_field_t;

typedef struct stc_gpio_pfre_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  RESERVED0                :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  RESERVED1                :28;
} stc_gpio_pfre_field_t;

typedef struct stc_gpio_pfrf_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_gpio_pfrf_field_t;

typedef struct stc_gpio_pcr0_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  RESERVED0                :3;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED1                :21;
} stc_gpio_pcr0_field_t;

typedef struct stc_gpio_pcr1_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pcr1_field_t;

typedef struct stc_gpio_pcr2_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED0                :21;
} stc_gpio_pcr2_field_t;

typedef struct stc_gpio_pcr3_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED0                :17;
} stc_gpio_pcr3_field_t;

typedef struct stc_gpio_pcr4_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED0                :17;
} stc_gpio_pcr4_field_t;

typedef struct stc_gpio_pcr5_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  RESERVED0                :10;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED1                :16;
} stc_gpio_pcr5_field_t;

typedef struct stc_gpio_pcr6_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  RESERVED0                :8;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED1                :17;
} stc_gpio_pcr6_field_t;

typedef struct stc_gpio_pcr7_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED0                :21;
} stc_gpio_pcr7_field_t;

typedef struct stc_gpio_pcr9_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_gpio_pcr9_field_t;

typedef struct stc_gpio_pcra_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pcra_field_t;

typedef struct stc_gpio_pcrb_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_gpio_pcrb_field_t;

typedef struct stc_gpio_pcrc_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pcrc_field_t;

typedef struct stc_gpio_pcrd_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_gpio_pcrd_field_t;

typedef struct stc_gpio_pcre_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  RESERVED0                :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  RESERVED1                :28;
} stc_gpio_pcre_field_t;

typedef struct stc_gpio_pcrf_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_gpio_pcrf_field_t;

typedef struct stc_gpio_ddr0_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  RESERVED0                :3;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED1                :21;
} stc_gpio_ddr0_field_t;

typedef struct stc_gpio_ddr1_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_ddr1_field_t;

typedef struct stc_gpio_ddr2_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED0                :21;
} stc_gpio_ddr2_field_t;

typedef struct stc_gpio_ddr3_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED0                :17;
} stc_gpio_ddr3_field_t;

typedef struct stc_gpio_ddr4_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED0                :17;
} stc_gpio_ddr4_field_t;

typedef struct stc_gpio_ddr5_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  RESERVED0                :10;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED1                :16;
} stc_gpio_ddr5_field_t;

typedef struct stc_gpio_ddr6_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  RESERVED0                :8;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED1                :17;
} stc_gpio_ddr6_field_t;

typedef struct stc_gpio_ddr7_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED0                :21;
} stc_gpio_ddr7_field_t;

typedef struct stc_gpio_ddr8_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_gpio_ddr8_field_t;

typedef struct stc_gpio_ddr9_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_gpio_ddr9_field_t;

typedef struct stc_gpio_ddra_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_ddra_field_t;

typedef struct stc_gpio_ddrb_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_gpio_ddrb_field_t;

typedef struct stc_gpio_ddrc_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_ddrc_field_t;

typedef struct stc_gpio_ddrd_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_gpio_ddrd_field_t;

typedef struct stc_gpio_ddre_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  RESERVED0                :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  RESERVED1                :28;
} stc_gpio_ddre_field_t;

typedef struct stc_gpio_ddrf_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_gpio_ddrf_field_t;

typedef struct stc_gpio_pdir0_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  RESERVED0                :3;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED1                :21;
} stc_gpio_pdir0_field_t;

typedef struct stc_gpio_pdir1_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pdir1_field_t;

typedef struct stc_gpio_pdir2_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED0                :21;
} stc_gpio_pdir2_field_t;

typedef struct stc_gpio_pdir3_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED0                :17;
} stc_gpio_pdir3_field_t;

typedef struct stc_gpio_pdir4_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED0                :17;
} stc_gpio_pdir4_field_t;

typedef struct stc_gpio_pdir5_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  RESERVED0                :10;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED1                :16;
} stc_gpio_pdir5_field_t;

typedef struct stc_gpio_pdir6_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  RESERVED0                :8;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED1                :17;
} stc_gpio_pdir6_field_t;

typedef struct stc_gpio_pdir7_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED0                :21;
} stc_gpio_pdir7_field_t;

typedef struct stc_gpio_pdir8_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_gpio_pdir8_field_t;

typedef struct stc_gpio_pdir9_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_gpio_pdir9_field_t;

typedef struct stc_gpio_pdira_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pdira_field_t;

typedef struct stc_gpio_pdirb_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_gpio_pdirb_field_t;

typedef struct stc_gpio_pdirc_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pdirc_field_t;

typedef struct stc_gpio_pdird_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_gpio_pdird_field_t;

typedef struct stc_gpio_pdire_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  RESERVED0                :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  RESERVED1                :28;
} stc_gpio_pdire_field_t;

typedef struct stc_gpio_pdirf_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_gpio_pdirf_field_t;

typedef struct stc_gpio_pdor0_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  RESERVED0                :3;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED1                :21;
} stc_gpio_pdor0_field_t;

typedef struct stc_gpio_pdor1_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pdor1_field_t;

typedef struct stc_gpio_pdor2_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED0                :21;
} stc_gpio_pdor2_field_t;

typedef struct stc_gpio_pdor3_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED0                :17;
} stc_gpio_pdor3_field_t;

typedef struct stc_gpio_pdor4_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED0                :17;
} stc_gpio_pdor4_field_t;

typedef struct stc_gpio_pdor5_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  RESERVED0                :10;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED1                :16;
} stc_gpio_pdor5_field_t;

typedef struct stc_gpio_pdor6_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  RESERVED0                :8;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED1                :17;
} stc_gpio_pdor6_field_t;

typedef struct stc_gpio_pdor7_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED0                :21;
} stc_gpio_pdor7_field_t;

typedef struct stc_gpio_pdor8_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_gpio_pdor8_field_t;

typedef struct stc_gpio_pdor9_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_gpio_pdor9_field_t;

typedef struct stc_gpio_pdora_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pdora_field_t;

typedef struct stc_gpio_pdorb_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_gpio_pdorb_field_t;

typedef struct stc_gpio_pdorc_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pdorc_field_t;

typedef struct stc_gpio_pdord_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_gpio_pdord_field_t;

typedef struct stc_gpio_pdore_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  RESERVED0                :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  RESERVED1                :28;
} stc_gpio_pdore_field_t;

typedef struct stc_gpio_pdorf_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_gpio_pdorf_field_t;

typedef struct stc_gpio_ade_field
{
        __IO  uint32_t  AN00                     :1;
        __IO  uint32_t  AN01                     :1;
        __IO  uint32_t  AN02                     :1;
        __IO  uint32_t  AN03                     :1;
        __IO  uint32_t  AN04                     :1;
        __IO  uint32_t  AN05                     :1;
        __IO  uint32_t  AN06                     :1;
        __IO  uint32_t  AN07                     :1;
        __IO  uint32_t  AN08                     :1;
        __IO  uint32_t  AN09                     :1;
        __IO  uint32_t  AN10                     :1;
        __IO  uint32_t  AN11                     :1;
        __IO  uint32_t  AN12                     :1;
        __IO  uint32_t  AN13                     :1;
        __IO  uint32_t  AN14                     :1;
        __IO  uint32_t  AN15                     :1;
        __IO  uint32_t  AN16                     :1;
        __IO  uint32_t  AN17                     :1;
        __IO  uint32_t  AN18                     :1;
        __IO  uint32_t  AN19                     :1;
        __IO  uint32_t  AN20                     :1;
        __IO  uint32_t  AN21                     :1;
        __IO  uint32_t  AN22                     :1;
        __IO  uint32_t  AN23                     :1;
        __IO  uint32_t  AN24                     :1;
        __IO  uint32_t  AN25                     :1;
        __IO  uint32_t  AN26                     :1;
        __IO  uint32_t  AN27                     :1;
        __IO  uint32_t  AN28                     :1;
        __IO  uint32_t  AN29                     :1;
        __IO  uint32_t  AN30                     :1;
        __IO  uint32_t  AN31                     :1;
} stc_gpio_ade_field_t;

typedef struct stc_gpio_spsr_field
{
    union {
        struct {
            __IO  uint32_t  SUBXC                :2;
            __IO  uint32_t  MAINXC               :2;
            __IO  uint32_t  USB0C                :1;
            __IO  uint32_t  USB1C                :1;
            __IO  uint32_t  RESERVED0            :26;
        };
        struct {
            __IO  uint32_t  SUBXC0               :1;
            __IO  uint32_t  SUBXC1               :1;
            __IO  uint32_t  MAINXC0              :1;
            __IO  uint32_t  MAINXC1              :1;
            __IO  uint32_t  RESERVED1            :28;
        };
    };
} stc_gpio_spsr_field_t;

typedef struct stc_gpio_epfr00_field
{
    union {
        struct {
            __IO  uint32_t  NMIS                 :1;
            __IO  uint32_t  CROUTE               :2;
            __IO  uint32_t  RESERVED1            :1;
            __IO  uint32_t  RTCCOE               :2;
            __IO  uint32_t  SUBOUTE              :2;
            __IO  uint32_t  RESERVED3            :1;
            __IO  uint32_t  USBP0E               :1;
            __IO  uint32_t  RESERVED4            :3;
            __IO  uint32_t  USBP1E               :1;
            __IO  uint32_t  RESERVED5            :2;
            __IO  uint32_t  JTAGEN0B             :1;
            __IO  uint32_t  JTAGEN1S             :1;
            __IO  uint32_t  RESERVED6            :6;
            __IO  uint32_t  TRC0E                :1;
            __IO  uint32_t  TRC1E                :1;
            __IO  uint32_t  TRC2E                :1;
            __IO  uint32_t  TRC3E                :1;
            __IO  uint32_t  RESERVED7            :4;
        };
        struct {
            __IO  uint32_t  RESERVED0            :1;
            __IO  uint32_t  CROUTE0              :1;
            __IO  uint32_t  CROUTE1              :1;
            __IO  uint32_t  RESERVED2            :1;
            __IO  uint32_t  RTCCOE0              :1;
            __IO  uint32_t  RTCCOE1              :1;
            __IO  uint32_t  SUBOUTE0             :1;
            __IO  uint32_t  SUBOUTE1             :1;
            __IO  uint32_t  RESERVED8            :24;
        };
    };
} stc_gpio_epfr00_field_t;

typedef struct stc_gpio_epfr01_field
{
    union {
        struct {
            __IO  uint32_t  RTO00E               :2;
            __IO  uint32_t  RTO01E               :2;
            __IO  uint32_t  RTO02E               :2;
            __IO  uint32_t  RTO03E               :2;
            __IO  uint32_t  RTO04E               :2;
            __IO  uint32_t  RTO05E               :2;
            __IO  uint32_t  DTTI0C               :1;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  DTTI0S               :2;
            __IO  uint32_t  FRCK0S               :2;
            __IO  uint32_t  IC00S                :3;
            __IO  uint32_t  IC01S                :3;
            __IO  uint32_t  IC02S                :3;
            __IO  uint32_t  IC03S                :3;
        };
        struct {
            __IO  uint32_t  RTO00E0              :1;
            __IO  uint32_t  RTO00E1              :1;
            __IO  uint32_t  RTO01E0              :1;
            __IO  uint32_t  RTO01E1              :1;
            __IO  uint32_t  RTO02E0              :1;
            __IO  uint32_t  RTO02E1              :1;
            __IO  uint32_t  RTO03E0              :1;
            __IO  uint32_t  RTO03E1              :1;
            __IO  uint32_t  RTO04E0              :1;
            __IO  uint32_t  RTO04E1              :1;
            __IO  uint32_t  RTO05E0              :1;
            __IO  uint32_t  RTO05E1              :1;
            __IO  uint32_t  RESERVED1            :4;
            __IO  uint32_t  DTTI0S0              :1;
            __IO  uint32_t  DTTI0S1              :1;
            __IO  uint32_t  FRCK0S0              :1;
            __IO  uint32_t  FRCK0S1              :1;
            __IO  uint32_t  IC00S0               :1;
            __IO  uint32_t  IC00S1               :1;
            __IO  uint32_t  IC00S2               :1;
            __IO  uint32_t  IC01S0               :1;
            __IO  uint32_t  IC01S1               :1;
            __IO  uint32_t  IC01S2               :1;
            __IO  uint32_t  IC02S0               :1;
            __IO  uint32_t  IC02S1               :1;
            __IO  uint32_t  IC02S2               :1;
            __IO  uint32_t  IC03S0               :1;
            __IO  uint32_t  IC03S1               :1;
            __IO  uint32_t  IC03S2               :1;
        };
    };
} stc_gpio_epfr01_field_t;

typedef struct stc_gpio_epfr02_field
{
    union {
        struct {
            __IO  uint32_t  RTO10E               :2;
            __IO  uint32_t  RTO11E               :2;
            __IO  uint32_t  RTO12E               :2;
            __IO  uint32_t  RTO13E               :2;
            __IO  uint32_t  RTO14E               :2;
            __IO  uint32_t  RTO15E               :2;
            __IO  uint32_t  DTTI1C               :1;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  DTTI1S               :2;
            __IO  uint32_t  FRCK1S               :2;
            __IO  uint32_t  IC10S                :3;
            __IO  uint32_t  IC11S                :3;
            __IO  uint32_t  IC12S                :3;
            __IO  uint32_t  IC13S                :3;
        };
        struct {
            __IO  uint32_t  RTO10E0              :1;
            __IO  uint32_t  RTO10E1              :1;
            __IO  uint32_t  RTO11E0              :1;
            __IO  uint32_t  RTO11E1              :1;
            __IO  uint32_t  RTO12E0              :1;
            __IO  uint32_t  RTO12E1              :1;
            __IO  uint32_t  RTO13E0              :1;
            __IO  uint32_t  RTO13E1              :1;
            __IO  uint32_t  RTO14E0              :1;
            __IO  uint32_t  RTO14E1              :1;
            __IO  uint32_t  RTO15E0              :1;
            __IO  uint32_t  RTO15E1              :1;
            __IO  uint32_t  RESERVED1            :4;
            __IO  uint32_t  DTTI1S0              :1;
            __IO  uint32_t  DTTI1S1              :1;
            __IO  uint32_t  FRCK1S0              :1;
            __IO  uint32_t  FRCK1S1              :1;
            __IO  uint32_t  IC10S0               :1;
            __IO  uint32_t  IC10S1               :1;
            __IO  uint32_t  IC10S2               :1;
            __IO  uint32_t  IC11S0               :1;
            __IO  uint32_t  IC11S1               :1;
            __IO  uint32_t  IC11S2               :1;
            __IO  uint32_t  IC12S0               :1;
            __IO  uint32_t  IC12S1               :1;
            __IO  uint32_t  IC12S2               :1;
            __IO  uint32_t  IC13S0               :1;
            __IO  uint32_t  IC13S1               :1;
            __IO  uint32_t  IC13S2               :1;
        };
    };
} stc_gpio_epfr02_field_t;

typedef struct stc_gpio_epfr03_field
{
    union {
        struct {
            __IO  uint32_t  RTO20E               :2;
            __IO  uint32_t  RTO21E               :2;
            __IO  uint32_t  RTO22E               :2;
            __IO  uint32_t  RTO23E               :2;
            __IO  uint32_t  RTO24E               :2;
            __IO  uint32_t  RTO25E               :2;
            __IO  uint32_t  DTTI2C               :1;
            __IO  uint32_t  RESERVED0            :3;
            __IO  uint32_t  DTTI2S               :2;
            __IO  uint32_t  FRCK2S               :2;
            __IO  uint32_t  IC20S                :3;
            __IO  uint32_t  IC21S                :3;
            __IO  uint32_t  IC22S                :3;
            __IO  uint32_t  IC23S                :3;
        };
        struct {
            __IO  uint32_t  RTO20E0              :1;
            __IO  uint32_t  RTO20E1              :1;
            __IO  uint32_t  RTO21E0              :1;
            __IO  uint32_t  RTO21E1              :1;
            __IO  uint32_t  RTO22E0              :1;
            __IO  uint32_t  RTO22E1              :1;
            __IO  uint32_t  RTO23E0              :1;
            __IO  uint32_t  RTO23E1              :1;
            __IO  uint32_t  RTO24E0              :1;
            __IO  uint32_t  RTO24E1              :1;
            __IO  uint32_t  RTO25E0              :1;
            __IO  uint32_t  RTO25E1              :1;
            __IO  uint32_t  RESERVED1            :4;
            __IO  uint32_t  DTTI2S0              :1;
            __IO  uint32_t  DTTI2S1              :1;
            __IO  uint32_t  FRCK2S0              :1;
            __IO  uint32_t  FRCK2S1              :1;
            __IO  uint32_t  IC20S0               :1;
            __IO  uint32_t  IC20S1               :1;
            __IO  uint32_t  IC20S2               :1;
            __IO  uint32_t  IC21S0               :1;
            __IO  uint32_t  IC21S1               :1;
            __IO  uint32_t  IC21S2               :1;
            __IO  uint32_t  IC22S0               :1;
            __IO  uint32_t  IC22S1               :1;
            __IO  uint32_t  IC22S2               :1;
            __IO  uint32_t  IC23S0               :1;
            __IO  uint32_t  IC23S1               :1;
            __IO  uint32_t  IC23S2               :1;
        };
    };
} stc_gpio_epfr03_field_t;

typedef struct stc_gpio_epfr04_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  TIOA0E               :2;
            __IO  uint32_t  TIOB0S               :3;
            __IO  uint32_t  RESERVED2            :1;
            __IO  uint32_t  TIOA1S               :2;
            __IO  uint32_t  TIOA1E               :2;
            __IO  uint32_t  TIOB1S               :2;
            __IO  uint32_t  RESERVED4            :4;
            __IO  uint32_t  TIOA2E               :2;
            __IO  uint32_t  TIOB2S               :2;
            __IO  uint32_t  RESERVED6            :2;
            __IO  uint32_t  TIOA3S               :2;
            __IO  uint32_t  TIOA3E               :2;
            __IO  uint32_t  TIOB3S               :2;
            __IO  uint32_t  RESERVED8            :2;
        };
        struct {
            __IO  uint32_t  RESERVED1            :2;
            __IO  uint32_t  TIOA0E0              :1;
            __IO  uint32_t  TIOA0E1              :1;
            __IO  uint32_t  TIOB0S0              :1;
            __IO  uint32_t  TIOB0S1              :1;
            __IO  uint32_t  TIOB0S2              :1;
            __IO  uint32_t  RESERVED3            :1;
            __IO  uint32_t  TIOA1S0              :1;
            __IO  uint32_t  TIOA1S1              :1;
            __IO  uint32_t  TIOA1E0              :1;
            __IO  uint32_t  TIOA1E1              :1;
            __IO  uint32_t  TIOB1S0              :1;
            __IO  uint32_t  TIOB1S1              :1;
            __IO  uint32_t  RESERVED5            :4;
            __IO  uint32_t  TIOA2E0              :1;
            __IO  uint32_t  TIOA2E1              :1;
            __IO  uint32_t  TIOB2S0              :1;
            __IO  uint32_t  TIOB2S1              :1;
            __IO  uint32_t  RESERVED7            :2;
            __IO  uint32_t  TIOA3S0              :1;
            __IO  uint32_t  TIOA3S1              :1;
            __IO  uint32_t  TIOA3E0              :1;
            __IO  uint32_t  TIOA3E1              :1;
            __IO  uint32_t  TIOB3S0              :1;
            __IO  uint32_t  TIOB3S1              :1;
            __IO  uint32_t  RESERVED9            :2;
        };
    };
} stc_gpio_epfr04_field_t;

typedef struct stc_gpio_epfr05_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  TIOA4E               :2;
            __IO  uint32_t  TIOB4S               :2;
            __IO  uint32_t  RESERVED2            :2;
            __IO  uint32_t  TIOA5S               :2;
            __IO  uint32_t  TIOA5E               :2;
            __IO  uint32_t  TIOB5S               :2;
            __IO  uint32_t  RESERVED4            :4;
            __IO  uint32_t  TIOA6E               :2;
            __IO  uint32_t  TIOB6S               :2;
            __IO  uint32_t  RESERVED6            :2;
            __IO  uint32_t  TIOA7S               :2;
            __IO  uint32_t  TIOA7E               :2;
            __IO  uint32_t  TIOB7S               :2;
            __IO  uint32_t  RESERVED8            :2;
        };
        struct {
            __IO  uint32_t  RESERVED1            :2;
            __IO  uint32_t  TIOA4E0              :1;
            __IO  uint32_t  TIOA4E1              :1;
            __IO  uint32_t  TIOB4S0              :1;
            __IO  uint32_t  TIOB4S1              :1;
            __IO  uint32_t  RESERVED3            :2;
            __IO  uint32_t  TIOA5S0              :1;
            __IO  uint32_t  TIOA5S1              :1;
            __IO  uint32_t  TIOA5E0              :1;
            __IO  uint32_t  TIOA5E1              :1;
            __IO  uint32_t  TIOB5S0              :1;
            __IO  uint32_t  TIOB5S1              :1;
            __IO  uint32_t  RESERVED5            :4;
            __IO  uint32_t  TIOA6E0              :1;
            __IO  uint32_t  TIOA6E1              :1;
            __IO  uint32_t  TIOB6S0              :1;
            __IO  uint32_t  TIOB6S1              :1;
            __IO  uint32_t  RESERVED7            :2;
            __IO  uint32_t  TIOA7S0              :1;
            __IO  uint32_t  TIOA7S1              :1;
            __IO  uint32_t  TIOA7E0              :1;
            __IO  uint32_t  TIOA7E1              :1;
            __IO  uint32_t  TIOB7S0              :1;
            __IO  uint32_t  TIOB7S1              :1;
            __IO  uint32_t  RESERVED9            :2;
        };
    };
} stc_gpio_epfr05_field_t;

typedef struct stc_gpio_epfr06_field
{
    union {
        struct {
            __IO  uint32_t  EINT00S              :2;
            __IO  uint32_t  EINT01S              :2;
            __IO  uint32_t  EINT02S              :2;
            __IO  uint32_t  EINT03S              :2;
            __IO  uint32_t  EINT04S              :2;
            __IO  uint32_t  EINT05S              :2;
            __IO  uint32_t  EINT06S              :2;
            __IO  uint32_t  EINT07S              :2;
            __IO  uint32_t  EINT08S              :2;
            __IO  uint32_t  EINT09S              :2;
            __IO  uint32_t  EINT10S              :2;
            __IO  uint32_t  EINT11S              :2;
            __IO  uint32_t  EINT12S              :2;
            __IO  uint32_t  EINT13S              :2;
            __IO  uint32_t  EINT14S              :2;
            __IO  uint32_t  EINT15S              :2;
        };
        struct {
            __IO  uint32_t  EINT00S0             :1;
            __IO  uint32_t  EINT00S1             :1;
            __IO  uint32_t  EINT01S0             :1;
            __IO  uint32_t  EINT01S1             :1;
            __IO  uint32_t  EINT02S0             :1;
            __IO  uint32_t  EINT02S1             :1;
            __IO  uint32_t  EINT03S0             :1;
            __IO  uint32_t  EINT03S1             :1;
            __IO  uint32_t  EINT04S0             :1;
            __IO  uint32_t  EINT04S1             :1;
            __IO  uint32_t  EINT05S0             :1;
            __IO  uint32_t  EINT05S1             :1;
            __IO  uint32_t  EINT06S0             :1;
            __IO  uint32_t  EINT06S1             :1;
            __IO  uint32_t  EINT07S0             :1;
            __IO  uint32_t  EINT07S1             :1;
            __IO  uint32_t  EINT08S0             :1;
            __IO  uint32_t  EINT08S1             :1;
            __IO  uint32_t  EINT09S0             :1;
            __IO  uint32_t  EINT09S1             :1;
            __IO  uint32_t  EINT10S0             :1;
            __IO  uint32_t  EINT10S1             :1;
            __IO  uint32_t  EINT11S0             :1;
            __IO  uint32_t  EINT11S1             :1;
            __IO  uint32_t  EINT12S0             :1;
            __IO  uint32_t  EINT12S1             :1;
            __IO  uint32_t  EINT13S0             :1;
            __IO  uint32_t  EINT13S1             :1;
            __IO  uint32_t  EINT14S0             :1;
            __IO  uint32_t  EINT14S1             :1;
            __IO  uint32_t  EINT15S0             :1;
            __IO  uint32_t  EINT15S1             :1;
        };
    };
} stc_gpio_epfr06_field_t;

typedef struct stc_gpio_epfr07_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :4;
            __IO  uint32_t  SIN0S                :2;
            __IO  uint32_t  SOT0B                :2;
            __IO  uint32_t  SCK0B                :2;
            __IO  uint32_t  SIN1S                :2;
            __IO  uint32_t  SOT1B                :2;
            __IO  uint32_t  SCK1B                :2;
            __IO  uint32_t  SIN2S                :2;
            __IO  uint32_t  SOT2B                :2;
            __IO  uint32_t  SCK2B                :2;
            __IO  uint32_t  SIN3S                :2;
            __IO  uint32_t  SOT3B                :2;
            __IO  uint32_t  SCK3B                :2;
            __IO  uint32_t  RESERVED2            :4;
        };
        struct {
            __IO  uint32_t  RESERVED1            :4;
            __IO  uint32_t  SIN0S0               :1;
            __IO  uint32_t  SIN0S1               :1;
            __IO  uint32_t  SOT0B0               :1;
            __IO  uint32_t  SOT0B1               :1;
            __IO  uint32_t  SCK0B0               :1;
            __IO  uint32_t  SCK0B1               :1;
            __IO  uint32_t  SIN1S0               :1;
            __IO  uint32_t  SIN1S1               :1;
            __IO  uint32_t  SOT1B0               :1;
            __IO  uint32_t  SOT1B1               :1;
            __IO  uint32_t  SCK1B0               :1;
            __IO  uint32_t  SCK1B1               :1;
            __IO  uint32_t  SIN2S0               :1;
            __IO  uint32_t  SIN2S1               :1;
            __IO  uint32_t  SOT2B0               :1;
            __IO  uint32_t  SOT2B1               :1;
            __IO  uint32_t  SCK2B0               :1;
            __IO  uint32_t  SCK2B1               :1;
            __IO  uint32_t  SIN3S0               :1;
            __IO  uint32_t  SIN3S1               :1;
            __IO  uint32_t  SOT3B0               :1;
            __IO  uint32_t  SOT3B1               :1;
            __IO  uint32_t  SCK3B0               :1;
            __IO  uint32_t  SCK3B1               :1;
            __IO  uint32_t  RESERVED3            :4;
        };
    };
} stc_gpio_epfr07_field_t;

typedef struct stc_gpio_epfr08_field
{
    union {
        struct {
            __IO  uint32_t  RTS4E                :2;
            __IO  uint32_t  CTS4S                :2;
            __IO  uint32_t  SIN4S                :2;
            __IO  uint32_t  SOT4B                :2;
            __IO  uint32_t  SCK4B                :2;
            __IO  uint32_t  SIN5S                :2;
            __IO  uint32_t  SOT5B                :2;
            __IO  uint32_t  SCK5B                :2;
            __IO  uint32_t  SIN6S                :2;
            __IO  uint32_t  SOT6B                :2;
            __IO  uint32_t  SCK6B                :2;
            __IO  uint32_t  SIN7S                :2;
            __IO  uint32_t  SOT7B                :2;
            __IO  uint32_t  SCK7B                :2;
            __IO  uint32_t  RTS5E                :2;
            __IO  uint32_t  CTS5S                :2;
        };
        struct {
            __IO  uint32_t  RTS4E0               :1;
            __IO  uint32_t  RTS4E1               :1;
            __IO  uint32_t  CTS4S0               :1;
            __IO  uint32_t  CTS4S1               :1;
            __IO  uint32_t  SIN4S0               :1;
            __IO  uint32_t  SIN4S1               :1;
            __IO  uint32_t  SOT4B0               :1;
            __IO  uint32_t  SOT4B1               :1;
            __IO  uint32_t  SCK4B0               :1;
            __IO  uint32_t  SCK4B1               :1;
            __IO  uint32_t  SIN5S0               :1;
            __IO  uint32_t  SIN5S1               :1;
            __IO  uint32_t  SOT5B0               :1;
            __IO  uint32_t  SOT5B1               :1;
            __IO  uint32_t  SCK5B0               :1;
            __IO  uint32_t  SCK5B1               :1;
            __IO  uint32_t  SIN6S0               :1;
            __IO  uint32_t  SIN6S1               :1;
            __IO  uint32_t  SOT6B0               :1;
            __IO  uint32_t  SOT6B1               :1;
            __IO  uint32_t  SCK6B0               :1;
            __IO  uint32_t  SCK6B1               :1;
            __IO  uint32_t  SIN7S0               :1;
            __IO  uint32_t  SIN7S1               :1;
            __IO  uint32_t  SOT7B0               :1;
            __IO  uint32_t  SOT7B1               :1;
            __IO  uint32_t  SCK7B0               :1;
            __IO  uint32_t  SCK7B1               :1;
            __IO  uint32_t  RTS5E0               :1;
            __IO  uint32_t  RTS5E1               :1;
            __IO  uint32_t  CTS5S0               :1;
            __IO  uint32_t  CTS5S1               :1;
        };
    };
} stc_gpio_epfr08_field_t;

typedef struct stc_gpio_epfr09_field
{
    union {
        struct {
            __IO  uint32_t  QAIN0S               :2;
            __IO  uint32_t  QBIN0S               :2;
            __IO  uint32_t  QZIN0S               :2;
            __IO  uint32_t  QAIN1S               :2;
            __IO  uint32_t  QBIN1S               :2;
            __IO  uint32_t  QZIN1S               :2;
            __IO  uint32_t  ADTRG0S              :4;
            __IO  uint32_t  ADTRG1S              :4;
            __IO  uint32_t  ADTRG2S              :4;
            __IO  uint32_t  CRX0S                :2;
            __IO  uint32_t  CTX0E                :2;
            __IO  uint32_t  CRX1S                :2;
            __IO  uint32_t  CTX1E                :2;
        };
        struct {
            __IO  uint32_t  QAIN0S0              :1;
            __IO  uint32_t  QAIN0S1              :1;
            __IO  uint32_t  QBIN0S0              :1;
            __IO  uint32_t  QBIN0S1              :1;
            __IO  uint32_t  QZIN0S0              :1;
            __IO  uint32_t  QZIN0S1              :1;
            __IO  uint32_t  QAIN1S0              :1;
            __IO  uint32_t  QAIN1S1              :1;
            __IO  uint32_t  QBIN1S0              :1;
            __IO  uint32_t  QBIN1S1              :1;
            __IO  uint32_t  QZIN1S0              :1;
            __IO  uint32_t  QZIN1S1              :1;
            __IO  uint32_t  ADTRG0S0             :1;
            __IO  uint32_t  ADTRG0S1             :1;
            __IO  uint32_t  ADTRG0S2             :1;
            __IO  uint32_t  ADTRG0S3             :1;
            __IO  uint32_t  ADTRG1S0             :1;
            __IO  uint32_t  ADTRG1S1             :1;
            __IO  uint32_t  ADTRG1S2             :1;
            __IO  uint32_t  ADTRG1S3             :1;
            __IO  uint32_t  ADTRG2S0             :1;
            __IO  uint32_t  ADTRG2S1             :1;
            __IO  uint32_t  ADTRG2S2             :1;
            __IO  uint32_t  ADTRG2S3             :1;
            __IO  uint32_t  CRX0S0               :1;
            __IO  uint32_t  CRX0S1               :1;
            __IO  uint32_t  CTX0E0               :1;
            __IO  uint32_t  CTX0E1               :1;
            __IO  uint32_t  CRX1S0               :1;
            __IO  uint32_t  CRX1S1               :1;
            __IO  uint32_t  CTX1E0               :1;
            __IO  uint32_t  CTX1E1               :1;
        };
    };
} stc_gpio_epfr09_field_t;

typedef struct stc_gpio_epfr10_field
{
        __IO  uint32_t  UEDEFB                   :1;
        __IO  uint32_t  UEDTHB                   :1;
        __IO  uint32_t  UECLKE                   :1;
        __IO  uint32_t  UEWEXE                   :1;
        __IO  uint32_t  UEDQME                   :1;
        __IO  uint32_t  UEOEXE                   :1;
        __IO  uint32_t  UEFLSE                   :1;
        __IO  uint32_t  UECS1E                   :1;
        __IO  uint32_t  UECS2E                   :1;
        __IO  uint32_t  UECS3E                   :1;
        __IO  uint32_t  UECS4E                   :1;
        __IO  uint32_t  UECS5E                   :1;
        __IO  uint32_t  UECS6E                   :1;
        __IO  uint32_t  UECS7E                   :1;
        __IO  uint32_t  UEAOOE                   :1;
        __IO  uint32_t  UEA08E                   :1;
        __IO  uint32_t  UEA09E                   :1;
        __IO  uint32_t  UEA10E                   :1;
        __IO  uint32_t  UEA11E                   :1;
        __IO  uint32_t  UEA12E                   :1;
        __IO  uint32_t  UEA13E                   :1;
        __IO  uint32_t  UEA14E                   :1;
        __IO  uint32_t  UEA15E                   :1;
        __IO  uint32_t  UEA16E                   :1;
        __IO  uint32_t  UEA17E                   :1;
        __IO  uint32_t  UEA18E                   :1;
        __IO  uint32_t  UEA19E                   :1;
        __IO  uint32_t  UEA20E                   :1;
        __IO  uint32_t  UEA21E                   :1;
        __IO  uint32_t  UEA22E                   :1;
        __IO  uint32_t  UEA23E                   :1;
        __IO  uint32_t  UEA24E                   :1;
} stc_gpio_epfr10_field_t;

typedef struct stc_gpio_epfr11_field
{
        __IO  uint32_t  UEALEE                   :1;
        __IO  uint32_t  UECS0E                   :1;
        __IO  uint32_t  UEA01E                   :1;
        __IO  uint32_t  UEA02E                   :1;
        __IO  uint32_t  UEA03E                   :1;
        __IO  uint32_t  UEA04E                   :1;
        __IO  uint32_t  UEA05E                   :1;
        __IO  uint32_t  UEA06E                   :1;
        __IO  uint32_t  UEA07E                   :1;
        __IO  uint32_t  UED00B                   :1;
        __IO  uint32_t  UED01B                   :1;
        __IO  uint32_t  UED02B                   :1;
        __IO  uint32_t  UED03B                   :1;
        __IO  uint32_t  UED04B                   :1;
        __IO  uint32_t  UED05B                   :1;
        __IO  uint32_t  UED06B                   :1;
        __IO  uint32_t  UED07B                   :1;
        __IO  uint32_t  UED08B                   :1;
        __IO  uint32_t  UED09B                   :1;
        __IO  uint32_t  UED10B                   :1;
        __IO  uint32_t  UED11B                   :1;
        __IO  uint32_t  UED12B                   :1;
        __IO  uint32_t  UED13B                   :1;
        __IO  uint32_t  UED14B                   :1;
        __IO  uint32_t  UED15B                   :1;
        __IO  uint32_t  UERLC                    :1;
        __IO  uint32_t  RESERVED0                :6;
} stc_gpio_epfr11_field_t;

typedef struct stc_gpio_epfr12_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  TIOA8E               :2;
            __IO  uint32_t  TIOB8S               :2;
            __IO  uint32_t  RESERVED2            :2;
            __IO  uint32_t  TIOA9S               :2;
            __IO  uint32_t  TIOA9E               :2;
            __IO  uint32_t  TIOB9S               :2;
            __IO  uint32_t  RESERVED4            :4;
            __IO  uint32_t  TIOA10E              :2;
            __IO  uint32_t  TIOB10S              :2;
            __IO  uint32_t  RESERVED6            :2;
            __IO  uint32_t  TIOA11S              :2;
            __IO  uint32_t  TIOA11E              :2;
            __IO  uint32_t  TIOB11S              :2;
            __IO  uint32_t  RESERVED8            :2;
        };
        struct {
            __IO  uint32_t  RESERVED1            :2;
            __IO  uint32_t  TIOA8E0              :1;
            __IO  uint32_t  TIOA8E1              :1;
            __IO  uint32_t  TIOB8S0              :1;
            __IO  uint32_t  TIOB8S1              :1;
            __IO  uint32_t  RESERVED3            :2;
            __IO  uint32_t  TIOA9S0              :1;
            __IO  uint32_t  TIOA9S1              :1;
            __IO  uint32_t  TIOA9E0              :1;
            __IO  uint32_t  TIOA9E1              :1;
            __IO  uint32_t  TIOB9S0              :1;
            __IO  uint32_t  TIOB9S1              :1;
            __IO  uint32_t  RESERVED5            :4;
            __IO  uint32_t  TIOA10E0             :1;
            __IO  uint32_t  TIOA10E1             :1;
            __IO  uint32_t  TIOB10S0             :1;
            __IO  uint32_t  TIOB10S1             :1;
            __IO  uint32_t  RESERVED7            :2;
            __IO  uint32_t  TIOA11S0             :1;
            __IO  uint32_t  TIOA11S1             :1;
            __IO  uint32_t  TIOA11E0             :1;
            __IO  uint32_t  TIOA11E1             :1;
            __IO  uint32_t  TIOB11S0             :1;
            __IO  uint32_t  TIOB11S1             :1;
            __IO  uint32_t  RESERVED9            :2;
        };
    };
} stc_gpio_epfr12_field_t;

typedef struct stc_gpio_epfr13_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  TIOA12E              :2;
            __IO  uint32_t  TIOB12S              :2;
            __IO  uint32_t  RESERVED2            :2;
            __IO  uint32_t  TIOA13S              :2;
            __IO  uint32_t  TIOA13E              :2;
            __IO  uint32_t  TIOB13S              :2;
            __IO  uint32_t  RESERVED4            :4;
            __IO  uint32_t  TIOA14E              :2;
            __IO  uint32_t  TIOB14S              :2;
            __IO  uint32_t  RESERVED6            :2;
            __IO  uint32_t  TIOA15S              :2;
            __IO  uint32_t  TIOA15E              :2;
            __IO  uint32_t  TIOB15S              :2;
            __IO  uint32_t  RESERVED8            :2;
        };
        struct {
            __IO  uint32_t  RESERVED1            :2;
            __IO  uint32_t  TIOA12E0             :1;
            __IO  uint32_t  TIOA12E1             :1;
            __IO  uint32_t  TIOB12S0             :1;
            __IO  uint32_t  TIOB12S1             :1;
            __IO  uint32_t  RESERVED3            :2;
            __IO  uint32_t  TIOA13S0             :1;
            __IO  uint32_t  TIOA13S1             :1;
            __IO  uint32_t  TIOA13E0             :1;
            __IO  uint32_t  TIOA13E1             :1;
            __IO  uint32_t  TIOB13S0             :1;
            __IO  uint32_t  TIOB13S1             :1;
            __IO  uint32_t  RESERVED5            :4;
            __IO  uint32_t  TIOA14E0             :1;
            __IO  uint32_t  TIOA14E1             :1;
            __IO  uint32_t  TIOB14S0             :1;
            __IO  uint32_t  TIOB14S1             :1;
            __IO  uint32_t  RESERVED7            :2;
            __IO  uint32_t  TIOA15S0             :1;
            __IO  uint32_t  TIOA15S1             :1;
            __IO  uint32_t  TIOA15E0             :1;
            __IO  uint32_t  TIOA15E1             :1;
            __IO  uint32_t  TIOB15S0             :1;
            __IO  uint32_t  TIOB15S1             :1;
            __IO  uint32_t  RESERVED9            :2;
        };
    };
} stc_gpio_epfr13_field_t;

typedef struct stc_gpio_epfr14_field
{
    union {
        struct {
            __IO  uint32_t  QAIN2S               :2;
            __IO  uint32_t  QBIN2S               :2;
            __IO  uint32_t  QZIN2S               :2;
            __IO  uint32_t  RESERVED0            :12;
            __IO  uint32_t  E_TD0E               :1;
            __IO  uint32_t  E_TD1E               :1;
            __IO  uint32_t  E_TE0E               :1;
            __IO  uint32_t  E_TE1E               :1;
            __IO  uint32_t  E_MC0E               :1;
            __IO  uint32_t  E_MC1B               :1;
            __IO  uint32_t  E_MD0B               :1;
            __IO  uint32_t  E_MD1B               :1;
            __IO  uint32_t  E_CKE                :1;
            __IO  uint32_t  E_PSE                :1;
            __IO  uint32_t  E_SPLC               :2;
            __IO  uint32_t  RESERVED2            :2;
        };
        struct {
            __IO  uint32_t  QAIN2S0              :1;
            __IO  uint32_t  QAIN2S1              :1;
            __IO  uint32_t  QBIN2S0              :1;
            __IO  uint32_t  QBIN2S1              :1;
            __IO  uint32_t  QZIN2S0              :1;
            __IO  uint32_t  QZIN2S1              :1;
            __IO  uint32_t  RESERVED1            :22;
            __IO  uint32_t  E_SPLC0              :1;
            __IO  uint32_t  E_SPLC1              :1;
            __IO  uint32_t  RESERVED3            :2;
        };
    };
} stc_gpio_epfr14_field_t;

typedef struct stc_gpio_epfr15_field
{
    union {
        struct {
            __IO  uint32_t  EINT16S              :2;
            __IO  uint32_t  EINT17S              :2;
            __IO  uint32_t  EINT18S              :2;
            __IO  uint32_t  EINT19S              :2;
            __IO  uint32_t  EINT20S              :2;
            __IO  uint32_t  EINT21S              :2;
            __IO  uint32_t  EINT22S              :2;
            __IO  uint32_t  EINT23S              :2;
            __IO  uint32_t  EINT24S              :2;
            __IO  uint32_t  EINT25S              :2;
            __IO  uint32_t  EINT26S              :2;
            __IO  uint32_t  EINT27S              :2;
            __IO  uint32_t  EINT28S              :2;
            __IO  uint32_t  EINT29S              :2;
            __IO  uint32_t  EINT30S              :2;
            __IO  uint32_t  EINT31S              :2;
        };
        struct {
            __IO  uint32_t  EINT16S0             :1;
            __IO  uint32_t  EINT16S1             :1;
            __IO  uint32_t  EINT17S0             :1;
            __IO  uint32_t  EINT17S1             :1;
            __IO  uint32_t  EINT18S0             :1;
            __IO  uint32_t  EINT18S1             :1;
            __IO  uint32_t  EINT19S0             :1;
            __IO  uint32_t  EINT19S1             :1;
            __IO  uint32_t  EINT20S0             :1;
            __IO  uint32_t  EINT20S1             :1;
            __IO  uint32_t  EINT21S0             :1;
            __IO  uint32_t  EINT21S1             :1;
            __IO  uint32_t  EINT22S0             :1;
            __IO  uint32_t  EINT22S1             :1;
            __IO  uint32_t  EINT23S0             :1;
            __IO  uint32_t  EINT23S1             :1;
            __IO  uint32_t  EINT24S0             :1;
            __IO  uint32_t  EINT24S1             :1;
            __IO  uint32_t  EINT25S0             :1;
            __IO  uint32_t  EINT25S1             :1;
            __IO  uint32_t  EINT26S0             :1;
            __IO  uint32_t  EINT26S1             :1;
            __IO  uint32_t  EINT27S0             :1;
            __IO  uint32_t  EINT27S1             :1;
            __IO  uint32_t  EINT28S0             :1;
            __IO  uint32_t  EINT28S1             :1;
            __IO  uint32_t  EINT29S0             :1;
            __IO  uint32_t  EINT29S1             :1;
            __IO  uint32_t  EINT30S0             :1;
            __IO  uint32_t  EINT30S1             :1;
            __IO  uint32_t  EINT31S0             :1;
            __IO  uint32_t  EINT31S1             :1;
        };
    };
} stc_gpio_epfr15_field_t;

typedef struct stc_gpio_epfr16_field
{
    union {
        struct {
            __IO  uint32_t  SCS6B                :2;
            __IO  uint32_t  SCS7B                :2;
            __IO  uint32_t  SIN8S                :2;
            __IO  uint32_t  SOT8B                :2;
            __IO  uint32_t  SCK8B                :2;
            __IO  uint32_t  SIN9S                :2;
            __IO  uint32_t  SOT9B                :2;
            __IO  uint32_t  SCK9B                :2;
            __IO  uint32_t  SIN10S               :2;
            __IO  uint32_t  SOT10B               :2;
            __IO  uint32_t  SCK10B               :2;
            __IO  uint32_t  SIN11S               :2;
            __IO  uint32_t  SOT11B               :2;
            __IO  uint32_t  SCK11B               :2;
            __IO  uint32_t  SFMPAC               :1;
            __IO  uint32_t  SFMPBC               :1;
            __IO  uint32_t  RESERVED0            :2;
        };
        struct {
            __IO  uint32_t  SCS6B0               :1;
            __IO  uint32_t  SCS6B1               :1;
            __IO  uint32_t  SCS7B0               :1;
            __IO  uint32_t  SCS7B1               :1;
            __IO  uint32_t  SIN8S0               :1;
            __IO  uint32_t  SIN8S1               :1;
            __IO  uint32_t  SOT8B0               :1;
            __IO  uint32_t  SOT8B1               :1;
            __IO  uint32_t  SCK8B0               :1;
            __IO  uint32_t  SCK8B1               :1;
            __IO  uint32_t  SIN9S0               :1;
            __IO  uint32_t  SIN9S1               :1;
            __IO  uint32_t  SOT9B0               :1;
            __IO  uint32_t  SOT9B1               :1;
            __IO  uint32_t  SCK9B0               :1;
            __IO  uint32_t  SCK9B1               :1;
            __IO  uint32_t  SIN10S0              :1;
            __IO  uint32_t  SIN10S1              :1;
            __IO  uint32_t  SOT10B0              :1;
            __IO  uint32_t  SOT10B1              :1;
            __IO  uint32_t  SCK10B0              :1;
            __IO  uint32_t  SCK10B1              :1;
            __IO  uint32_t  SIN11S0              :1;
            __IO  uint32_t  SIN11S1              :1;
            __IO  uint32_t  SOT11B0              :1;
            __IO  uint32_t  SOT11B1              :1;
            __IO  uint32_t  SCK11B0              :1;
            __IO  uint32_t  SCK11B1              :1;
            __IO  uint32_t  RESERVED1            :4;
        };
    };
} stc_gpio_epfr16_field_t;

typedef struct stc_gpio_epfr17_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :4;
            __IO  uint32_t  SIN12S               :2;
            __IO  uint32_t  SOT12B               :2;
            __IO  uint32_t  SCK12B               :2;
            __IO  uint32_t  SIN13S               :2;
            __IO  uint32_t  SOT13B               :2;
            __IO  uint32_t  SCK13B               :2;
            __IO  uint32_t  SIN14S               :2;
            __IO  uint32_t  SOT14B               :2;
            __IO  uint32_t  SCK14B               :2;
            __IO  uint32_t  SIN15S               :2;
            __IO  uint32_t  SOT15B               :2;
            __IO  uint32_t  SCK15B               :2;
            __IO  uint32_t  RESERVED2            :4;
        };
        struct {
            __IO  uint32_t  RESERVED1            :4;
            __IO  uint32_t  SIN12S0              :1;
            __IO  uint32_t  SIN12S1              :1;
            __IO  uint32_t  SOT12B0              :1;
            __IO  uint32_t  SOT12B1              :1;
            __IO  uint32_t  SCK12B0              :1;
            __IO  uint32_t  SCK12B1              :1;
            __IO  uint32_t  SIN13S0              :1;
            __IO  uint32_t  SIN13S1              :1;
            __IO  uint32_t  SOT13B0              :1;
            __IO  uint32_t  SOT13B1              :1;
            __IO  uint32_t  SCK13B0              :1;
            __IO  uint32_t  SCK13B1              :1;
            __IO  uint32_t  SIN14S0              :1;
            __IO  uint32_t  SIN14S1              :1;
            __IO  uint32_t  SOT14B0              :1;
            __IO  uint32_t  SOT14B1              :1;
            __IO  uint32_t  SCK14B0              :1;
            __IO  uint32_t  SCK14B1              :1;
            __IO  uint32_t  SIN15S0              :1;
            __IO  uint32_t  SIN15S1              :1;
            __IO  uint32_t  SOT15B0              :1;
            __IO  uint32_t  SOT15B1              :1;
            __IO  uint32_t  SCK15B0              :1;
            __IO  uint32_t  SCK15B1              :1;
            __IO  uint32_t  RESERVED3            :4;
        };
    };
} stc_gpio_epfr17_field_t;

typedef struct stc_gpio_epfr18_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :4;
            __IO  uint32_t  QAIN3S               :2;
            __IO  uint32_t  QBIN3S               :2;
            __IO  uint32_t  QZIN3S               :2;
            __IO  uint32_t  RESERVED2            :4;
            __IO  uint32_t  SDCLKE               :2;
            __IO  uint32_t  SDCMDB               :2;
            __IO  uint32_t  SDDATA0B             :2;
            __IO  uint32_t  SDDATA1B             :2;
            __IO  uint32_t  SDDATA2B             :2;
            __IO  uint32_t  SDDATA3B             :2;
            __IO  uint32_t  SDCDS                :2;
            __IO  uint32_t  SDWPS                :2;
            __IO  uint32_t  RESERVED4            :2;
        };
        struct {
            __IO  uint32_t  RESERVED1            :4;
            __IO  uint32_t  QAIN3S0              :1;
            __IO  uint32_t  QAIN3S1              :1;
            __IO  uint32_t  QBIN3S0              :1;
            __IO  uint32_t  QBIN3S1              :1;
            __IO  uint32_t  QZIN3S0              :1;
            __IO  uint32_t  QZIN3S1              :1;
            __IO  uint32_t  RESERVED3            :4;
            __IO  uint32_t  SDCLKE0              :1;
            __IO  uint32_t  SDCLKE1              :1;
            __IO  uint32_t  SDCMDB0              :1;
            __IO  uint32_t  SDCMDB1              :1;
            __IO  uint32_t  SDDATA0B0            :1;
            __IO  uint32_t  SDDATA0B1            :1;
            __IO  uint32_t  SDDATA1B0            :1;
            __IO  uint32_t  SDDATA1B1            :1;
            __IO  uint32_t  SDDATA2B0            :1;
            __IO  uint32_t  SDDATA2B1            :1;
            __IO  uint32_t  SDDATA3B0            :1;
            __IO  uint32_t  SDDATA3B1            :1;
            __IO  uint32_t  SDCDS0               :1;
            __IO  uint32_t  SDCDS1               :1;
            __IO  uint32_t  SDWPS0               :1;
            __IO  uint32_t  SDWPS1               :1;
            __IO  uint32_t  RESERVED5            :2;
        };
    };
} stc_gpio_epfr18_field_t;

typedef struct stc_gpio_epfr20_field
{
        __IO  uint32_t  UESMCKE                  :1;
        __IO  uint32_t  UESMCEE                  :1;
        __IO  uint32_t  UERASE                   :1;
        __IO  uint32_t  UECASE                   :1;
        __IO  uint32_t  UEDWEXE                  :1;
        __IO  uint32_t  UECSXE                   :1;
        __IO  uint32_t  UEDQM2E                  :1;
        __IO  uint32_t  UEDQM3E                  :1;
        __IO  uint32_t  UEDTHHB                  :1;
        __IO  uint32_t  UED16B                   :1;
        __IO  uint32_t  UED17B                   :1;
        __IO  uint32_t  UED18B                   :1;
        __IO  uint32_t  UED19B                   :1;
        __IO  uint32_t  UED20B                   :1;
        __IO  uint32_t  UED21B                   :1;
        __IO  uint32_t  UED22B                   :1;
        __IO  uint32_t  UED23B                   :1;
        __IO  uint32_t  UED24B                   :1;
        __IO  uint32_t  UED25B                   :1;
        __IO  uint32_t  UED26B                   :1;
        __IO  uint32_t  UED27B                   :1;
        __IO  uint32_t  UED28B                   :1;
        __IO  uint32_t  UED29B                   :1;
        __IO  uint32_t  UED30B                   :1;
        __IO  uint32_t  UED31B                   :1;
        __IO  uint32_t  RESERVED0                :7;
} stc_gpio_epfr20_field_t;

typedef struct stc_gpio_epfr23_field
{
    union {
        struct {
            __IO  uint32_t  SCS60E               :2;
            __IO  uint32_t  SCS61E               :2;
            __IO  uint32_t  SCS62E               :2;
            __IO  uint32_t  SCS63E               :2;
            __IO  uint32_t  SCS70E               :2;
            __IO  uint32_t  SCS71E               :2;
            __IO  uint32_t  SCS72E               :2;
            __IO  uint32_t  SCS73E               :2;
            __IO  uint32_t  RESERVED0            :16;
        };
        struct {
            __IO  uint32_t  SCS60E0              :1;
            __IO  uint32_t  SCS60E1              :1;
            __IO  uint32_t  SCS61E0              :1;
            __IO  uint32_t  SCS61E1              :1;
            __IO  uint32_t  SCS62E0              :1;
            __IO  uint32_t  SCS62E1              :1;
            __IO  uint32_t  SCS63E0              :1;
            __IO  uint32_t  SCS63E1              :1;
            __IO  uint32_t  SCS70E0              :1;
            __IO  uint32_t  SCS70E1              :1;
            __IO  uint32_t  SCS71E0              :1;
            __IO  uint32_t  SCS71E1              :1;
            __IO  uint32_t  SCS72E0              :1;
            __IO  uint32_t  SCS72E1              :1;
            __IO  uint32_t  SCS73E0              :1;
            __IO  uint32_t  SCS73E1              :1;
            __IO  uint32_t  RESERVED1            :16;
        };
    };
} stc_gpio_epfr23_field_t;

typedef struct stc_gpio_epfr24_field
{
    union {
        struct {
            __IO  uint32_t  I2SM4_MCLK0S         :2;
            __IO  uint32_t  I2SM4_MCLK0E         :2;
            __IO  uint32_t  I2SM4_SCK0B          :2;
            __IO  uint32_t  I2SM4_WS0B           :2;
            __IO  uint32_t  I2SM4_SDI0S          :2;
            __IO  uint32_t  I2SM4_SDO0E          :2;
            __IO  uint32_t  RESERVED0            :4;
            __IO  uint32_t  I2SM4_MCLK1S         :2;
            __IO  uint32_t  I2SM4_MCLK1E         :2;
            __IO  uint32_t  I2SM4_SCK1B          :2;
            __IO  uint32_t  I2SM4_WS1B           :2;
            __IO  uint32_t  I2SM4_SDI1S          :2;
            __IO  uint32_t  I2SM4_SDO1E          :2;
            __IO  uint32_t  RESERVED2            :4;
        };
        struct {
            __IO  uint32_t  I2SM4_MCLK0S0        :1;
            __IO  uint32_t  I2SM4_MCLK0S1        :1;
            __IO  uint32_t  I2SM4_MCLK0E0        :1;
            __IO  uint32_t  I2SM4_MCLK0E1        :1;
            __IO  uint32_t  I2SM4_SCK0B0         :1;
            __IO  uint32_t  I2SM4_SCK0B1         :1;
            __IO  uint32_t  I2SM4_WS0B0          :1;
            __IO  uint32_t  I2SM4_WS0B1          :1;
            __IO  uint32_t  I2SM4_SDI0S0         :1;
            __IO  uint32_t  I2SM4_SDI0S1         :1;
            __IO  uint32_t  I2SM4_SDO0E0         :1;
            __IO  uint32_t  I2SM4_SDO0E1         :1;
            __IO  uint32_t  RESERVED1            :4;
            __IO  uint32_t  I2SM4_MCLK1S0        :1;
            __IO  uint32_t  I2SM4_MCLK1S1        :1;
            __IO  uint32_t  I2SM4_MCLK1E0        :1;
            __IO  uint32_t  I2SM4_MCLK1E1        :1;
            __IO  uint32_t  I2SM4_SCK1B0         :1;
            __IO  uint32_t  I2SM4_SCK1B1         :1;
            __IO  uint32_t  I2SM4_WS1B0          :1;
            __IO  uint32_t  I2SM4_WS1B1          :1;
            __IO  uint32_t  I2SM4_SDI1S0         :1;
            __IO  uint32_t  I2SM4_SDI1S1         :1;
            __IO  uint32_t  I2SM4_SDO1E0         :1;
            __IO  uint32_t  I2SM4_SDO1E1         :1;
            __IO  uint32_t  RESERVED3            :4;
        };
    };
} stc_gpio_epfr24_field_t;

typedef struct stc_gpio_epfr25_field
{
    union {
        struct {
            __IO  uint32_t  MCRX2S               :2;
            __IO  uint32_t  MCTX2E               :2;
            __IO  uint32_t  RESERVED0            :28;
        };
        struct {
            __IO  uint32_t  MCRX2S0              :1;
            __IO  uint32_t  MCRX2S1              :1;
            __IO  uint32_t  MCTX2E0              :1;
            __IO  uint32_t  MCTX2E1              :1;
            __IO  uint32_t  RESERVED1            :28;
        };
    };
} stc_gpio_epfr25_field_t;

typedef struct stc_gpio_epfr26_field
{
    union {
        struct {
            __IO  uint32_t  Q_SCKB               :2;
            __IO  uint32_t  Q_CS0E               :2;
            __IO  uint32_t  Q_CS1E               :2;
            __IO  uint32_t  Q_CS2E               :2;
            __IO  uint32_t  Q_CS3E               :2;
            __IO  uint32_t  Q_IO0B               :2;
            __IO  uint32_t  Q_IO1B               :2;
            __IO  uint32_t  Q_IO2B               :2;
            __IO  uint32_t  Q_IO3B               :2;
            __IO  uint32_t  RESERVED0            :14;
        };
        struct {
            __IO  uint32_t  Q_SCKB0              :1;
            __IO  uint32_t  Q_SCKB1              :1;
            __IO  uint32_t  Q_CS0E0              :1;
            __IO  uint32_t  Q_CS0E1              :1;
            __IO  uint32_t  Q_CS1E0              :1;
            __IO  uint32_t  Q_CS1E1              :1;
            __IO  uint32_t  Q_CS2E0              :1;
            __IO  uint32_t  Q_CS2E1              :1;
            __IO  uint32_t  Q_CS3E0              :1;
            __IO  uint32_t  Q_CS3E1              :1;
            __IO  uint32_t  Q_IO0B0              :1;
            __IO  uint32_t  Q_IO0B1              :1;
            __IO  uint32_t  Q_IO1B0              :1;
            __IO  uint32_t  Q_IO1B1              :1;
            __IO  uint32_t  Q_IO2B0              :1;
            __IO  uint32_t  Q_IO2B1              :1;
            __IO  uint32_t  Q_IO3B0              :1;
            __IO  uint32_t  Q_IO3B1              :1;
            __IO  uint32_t  RESERVED1            :14;
        };
    };
} stc_gpio_epfr26_field_t;

typedef struct stc_gpio_epfr33_field
{
    union {
        struct {
            __IO  uint32_t  CIN0S                :2;
            __IO  uint32_t  DATA0B               :2;
            __IO  uint32_t  RST0E                :2;
            __IO  uint32_t  VPEN0E               :2;
            __IO  uint32_t  VCC0E                :2;
            __IO  uint32_t  CLK0E                :2;
            __IO  uint32_t  RESERVED0            :4;
            __IO  uint32_t  CIN1S                :2;
            __IO  uint32_t  DATA1B               :2;
            __IO  uint32_t  RST1E                :2;
            __IO  uint32_t  VPEN1E               :2;
            __IO  uint32_t  VCC1E                :2;
            __IO  uint32_t  CLK1E                :2;
            __IO  uint32_t  RESERVED2            :4;
        };
        struct {
            __IO  uint32_t  CIN0S0               :1;
            __IO  uint32_t  CIN0S1               :1;
            __IO  uint32_t  DATA0B0              :1;
            __IO  uint32_t  DATA0B1              :1;
            __IO  uint32_t  RST0E0               :1;
            __IO  uint32_t  RST0E1               :1;
            __IO  uint32_t  VPEN0E0              :1;
            __IO  uint32_t  VPEN0E1              :1;
            __IO  uint32_t  VCC0E0               :1;
            __IO  uint32_t  VCC0E1               :1;
            __IO  uint32_t  CLK0E0               :1;
            __IO  uint32_t  CLK0E1               :1;
            __IO  uint32_t  RESERVED1            :4;
            __IO  uint32_t  CIN1S0               :1;
            __IO  uint32_t  CIN1S1               :1;
            __IO  uint32_t  DATA1B0              :1;
            __IO  uint32_t  DATA1B1              :1;
            __IO  uint32_t  RST1E0               :1;
            __IO  uint32_t  RST1E1               :1;
            __IO  uint32_t  VPEN1E0              :1;
            __IO  uint32_t  VPEN1E1              :1;
            __IO  uint32_t  VCC1E0               :1;
            __IO  uint32_t  VCC1E1               :1;
            __IO  uint32_t  CLK1E0               :1;
            __IO  uint32_t  CLK1E1               :1;
            __IO  uint32_t  RESERVED3            :4;
        };
    };
} stc_gpio_epfr33_field_t;

typedef struct stc_gpio_epfr35_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :16;
            __IO  uint32_t  MCK1S                :2;
            __IO  uint32_t  MCK1E                :2;
            __IO  uint32_t  SCK1B                :2;
            __IO  uint32_t  WS1B                 :2;
            __IO  uint32_t  SDI1S                :2;
            __IO  uint32_t  SDO1E                :2;
            __IO  uint32_t  RESERVED2            :4;
        };
        struct {
            __IO  uint32_t  RESERVED1            :16;
            __IO  uint32_t  MCK1S0               :1;
            __IO  uint32_t  MCK1S1               :1;
            __IO  uint32_t  MCK1E0               :1;
            __IO  uint32_t  MCK1E1               :1;
            __IO  uint32_t  SCK1B0               :1;
            __IO  uint32_t  SCK1B1               :1;
            __IO  uint32_t  WS1B0                :1;
            __IO  uint32_t  WS1B1                :1;
            __IO  uint32_t  SDI1S0               :1;
            __IO  uint32_t  SDI1S1               :1;
            __IO  uint32_t  SDO1E0               :1;
            __IO  uint32_t  SDO1E1               :1;
            __IO  uint32_t  RESERVED3            :4;
        };
    };
} stc_gpio_epfr35_field_t;

typedef struct stc_gpio_pzr0_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  RESERVED0                :3;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED1                :21;
} stc_gpio_pzr0_field_t;

typedef struct stc_gpio_pzr1_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pzr1_field_t;

typedef struct stc_gpio_pzr2_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED0                :21;
} stc_gpio_pzr2_field_t;

typedef struct stc_gpio_pzr3_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED0                :17;
} stc_gpio_pzr3_field_t;

typedef struct stc_gpio_pzr4_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED0                :17;
} stc_gpio_pzr4_field_t;

typedef struct stc_gpio_pzr5_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  RESERVED0                :10;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED1                :16;
} stc_gpio_pzr5_field_t;

typedef struct stc_gpio_pzr6_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  RESERVED0                :8;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED1                :17;
} stc_gpio_pzr6_field_t;

typedef struct stc_gpio_pzr7_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED0                :21;
} stc_gpio_pzr7_field_t;

typedef struct stc_gpio_pzr8_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_gpio_pzr8_field_t;

typedef struct stc_gpio_pzr9_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_gpio_pzr9_field_t;

typedef struct stc_gpio_pzra_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pzra_field_t;

typedef struct stc_gpio_pzrb_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_gpio_pzrb_field_t;

typedef struct stc_gpio_pzrc_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pzrc_field_t;

typedef struct stc_gpio_pzrd_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_gpio_pzrd_field_t;

typedef struct stc_gpio_pzre_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  RESERVED0                :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  RESERVED1                :28;
} stc_gpio_pzre_field_t;

typedef struct stc_gpio_pzrf_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_gpio_pzrf_field_t;

typedef struct stc_gpio_pdsr0_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  RESERVED0                :3;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED1                :21;
} stc_gpio_pdsr0_field_t;

typedef struct stc_gpio_pdsr1_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pdsr1_field_t;

typedef struct stc_gpio_pdsr2_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED0                :21;
} stc_gpio_pdsr2_field_t;

typedef struct stc_gpio_pdsr3_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED0                :17;
} stc_gpio_pdsr3_field_t;

typedef struct stc_gpio_pdsr4_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED0                :17;
} stc_gpio_pdsr4_field_t;

typedef struct stc_gpio_pdsr5_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  RESERVED0                :10;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED1                :16;
} stc_gpio_pdsr5_field_t;

typedef struct stc_gpio_pdsr6_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  RESERVED0                :8;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  RESERVED1                :17;
} stc_gpio_pdsr6_field_t;

typedef struct stc_gpio_pdsr7_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  RESERVED0                :21;
} stc_gpio_pdsr7_field_t;

typedef struct stc_gpio_pdsr8_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_gpio_pdsr8_field_t;

typedef struct stc_gpio_pdsr9_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_gpio_pdsr9_field_t;

typedef struct stc_gpio_pdsra_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pdsra_field_t;

typedef struct stc_gpio_pdsrb_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_gpio_pdsrb_field_t;

typedef struct stc_gpio_pdsrc_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  P8                       :1;
        __IO  uint32_t  P9                       :1;
        __IO  uint32_t  PA                       :1;
        __IO  uint32_t  PB                       :1;
        __IO  uint32_t  PC                       :1;
        __IO  uint32_t  PD                       :1;
        __IO  uint32_t  PE                       :1;
        __IO  uint32_t  PF                       :1;
        __IO  uint32_t  RESERVED0                :16;
} stc_gpio_pdsrc_field_t;

typedef struct stc_gpio_pdsrd_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_gpio_pdsrd_field_t;

typedef struct stc_gpio_pdsre_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  RESERVED0                :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  RESERVED1                :28;
} stc_gpio_pdsre_field_t;

typedef struct stc_gpio_pdsrf_field
{
        __IO  uint32_t  P0                       :1;
        __IO  uint32_t  P1                       :1;
        __IO  uint32_t  P2                       :1;
        __IO  uint32_t  P3                       :1;
        __IO  uint32_t  P4                       :1;
        __IO  uint32_t  P5                       :1;
        __IO  uint32_t  P6                       :1;
        __IO  uint32_t  P7                       :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_gpio_pdsrf_field_t;

/******************************************************************************
 ** HWWDT_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_hwwdt_wdg_ctl_field
{
        __IO  uint32_t  INTEN                    :1;
        __IO  uint32_t  RESEN                    :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_hwwdt_wdg_ctl_field_t;

typedef struct stc_hwwdt_wdg_ris_field
{
        __IO  uint32_t  RIS                      :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_hwwdt_wdg_ris_field_t;

/******************************************************************************
 ** INTREQ_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_intreq_drqsel_field
{
        __IO  uint32_t  USBEP1                   :1;
        __IO  uint32_t  USBEP2                   :1;
        __IO  uint32_t  USBEP3                   :1;
        __IO  uint32_t  USBEP4                   :1;
        __IO  uint32_t  USBEP5                   :1;
        __IO  uint32_t  ADCSCAN0                 :1;
        __IO  uint32_t  ADCSCAN1                 :1;
        __IO  uint32_t  ADCSCAN2                 :1;
        __IO  uint32_t  IRQ0BT0                  :1;
        __IO  uint32_t  IRQ0BT2                  :1;
        __IO  uint32_t  IRQ0BT4                  :1;
        __IO  uint32_t  IRQ0BT6                  :1;
        __IO  uint32_t  MFS0RX                   :1;
        __IO  uint32_t  MFS0TX                   :1;
        __IO  uint32_t  MFS1RX                   :1;
        __IO  uint32_t  MFS1TX                   :1;
        __IO  uint32_t  MFS2RX                   :1;
        __IO  uint32_t  MFS2TX                   :1;
        __IO  uint32_t  MFS3RX                   :1;
        __IO  uint32_t  MFS3TX                   :1;
        __IO  uint32_t  MFS4RX                   :1;
        __IO  uint32_t  MFS4TX                   :1;
        __IO  uint32_t  MFS5RX                   :1;
        __IO  uint32_t  MFS5TX                   :1;
        __IO  uint32_t  MFS6RX                   :1;
        __IO  uint32_t  MFS6TX                   :1;
        __IO  uint32_t  MFS7RX                   :1;
        __IO  uint32_t  MFS7TX                   :1;
        __IO  uint32_t  EXINT0                   :1;
        __IO  uint32_t  EXINT1                   :1;
        __IO  uint32_t  EXINT2                   :1;
        __IO  uint32_t  EXINT3                   :1;
} stc_intreq_drqsel_field_t;

typedef struct stc_intreq_oddpks_field
{
        __IO   uint8_t  ODDPKS0                  :1;
        __IO   uint8_t  ODDPKS1                  :1;
        __IO   uint8_t  ODDPKS2                  :1;
        __IO   uint8_t  ODDPKS3                  :1;
        __IO   uint8_t  ODDPKS4                  :1;
        __IO   uint8_t  RESERVED0                :3;
} stc_intreq_oddpks_field_t;

typedef struct stc_intreq_oddpks1_field
{
        __IO   uint8_t  ODDPKS10                 :1;
        __IO   uint8_t  ODDPKS11                 :1;
        __IO   uint8_t  ODDPKS12                 :1;
        __IO   uint8_t  ODDPKS13                 :1;
        __IO   uint8_t  ODDPKS14                 :1;
        __IO   uint8_t  RESERVED0                :3;
} stc_intreq_oddpks1_field_t;

typedef struct stc_intreq_irq003sel_field
{
    union {
        struct {
            __IO  uint32_t  SELIRQ               :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  SELBIT0              :1;
            __IO  uint32_t  SELBIT1              :1;
            __IO  uint32_t  SELBIT2              :1;
            __IO  uint32_t  SELBIT3              :1;
            __IO  uint32_t  SELBIT4              :1;
            __IO  uint32_t  SELBIT5              :1;
            __IO  uint32_t  SELBIT6              :1;
            __IO  uint32_t  SELBIT7              :1;
            __IO  uint32_t  SELBIT8              :1;
            __IO  uint32_t  SELBIT9              :1;
            __IO  uint32_t  SELBIT10             :1;
            __IO  uint32_t  SELBIT11             :1;
            __IO  uint32_t  SELBIT12             :1;
            __IO  uint32_t  SELBIT13             :1;
            __IO  uint32_t  SELBIT14             :1;
            __IO  uint32_t  SELBIT15             :1;
        };
        struct {
            __IO  uint32_t  SELIRQ0              :1;
            __IO  uint32_t  SELIRQ1              :1;
            __IO  uint32_t  SELIRQ2              :1;
            __IO  uint32_t  SELIRQ3              :1;
            __IO  uint32_t  SELIRQ4              :1;
            __IO  uint32_t  SELIRQ5              :1;
            __IO  uint32_t  SELIRQ6              :1;
            __IO  uint32_t  SELIRQ7              :1;
            __IO  uint32_t  RESERVED1            :24;
        };
    };
} stc_intreq_irq003sel_field_t;

typedef struct stc_intreq_irq004sel_field
{
    union {
        struct {
            __IO  uint32_t  SELIRQ               :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  SELBIT0              :1;
            __IO  uint32_t  SELBIT1              :1;
            __IO  uint32_t  SELBIT2              :1;
            __IO  uint32_t  SELBIT3              :1;
            __IO  uint32_t  SELBIT4              :1;
            __IO  uint32_t  SELBIT5              :1;
            __IO  uint32_t  SELBIT6              :1;
            __IO  uint32_t  SELBIT7              :1;
            __IO  uint32_t  SELBIT8              :1;
            __IO  uint32_t  SELBIT9              :1;
            __IO  uint32_t  SELBIT10             :1;
            __IO  uint32_t  SELBIT11             :1;
            __IO  uint32_t  SELBIT12             :1;
            __IO  uint32_t  SELBIT13             :1;
            __IO  uint32_t  SELBIT14             :1;
            __IO  uint32_t  SELBIT15             :1;
        };
        struct {
            __IO  uint32_t  SELIRQ0              :1;
            __IO  uint32_t  SELIRQ1              :1;
            __IO  uint32_t  SELIRQ2              :1;
            __IO  uint32_t  SELIRQ3              :1;
            __IO  uint32_t  SELIRQ4              :1;
            __IO  uint32_t  SELIRQ5              :1;
            __IO  uint32_t  SELIRQ6              :1;
            __IO  uint32_t  SELIRQ7              :1;
            __IO  uint32_t  RESERVED1            :24;
        };
    };
} stc_intreq_irq004sel_field_t;

typedef struct stc_intreq_irq005sel_field
{
    union {
        struct {
            __IO  uint32_t  SELIRQ               :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  SELBIT0              :1;
            __IO  uint32_t  SELBIT1              :1;
            __IO  uint32_t  SELBIT2              :1;
            __IO  uint32_t  SELBIT3              :1;
            __IO  uint32_t  SELBIT4              :1;
            __IO  uint32_t  SELBIT5              :1;
            __IO  uint32_t  SELBIT6              :1;
            __IO  uint32_t  SELBIT7              :1;
            __IO  uint32_t  SELBIT8              :1;
            __IO  uint32_t  SELBIT9              :1;
            __IO  uint32_t  SELBIT10             :1;
            __IO  uint32_t  SELBIT11             :1;
            __IO  uint32_t  SELBIT12             :1;
            __IO  uint32_t  SELBIT13             :1;
            __IO  uint32_t  SELBIT14             :1;
            __IO  uint32_t  SELBIT15             :1;
        };
        struct {
            __IO  uint32_t  SELIRQ0              :1;
            __IO  uint32_t  SELIRQ1              :1;
            __IO  uint32_t  SELIRQ2              :1;
            __IO  uint32_t  SELIRQ3              :1;
            __IO  uint32_t  SELIRQ4              :1;
            __IO  uint32_t  SELIRQ5              :1;
            __IO  uint32_t  SELIRQ6              :1;
            __IO  uint32_t  SELIRQ7              :1;
            __IO  uint32_t  RESERVED1            :24;
        };
    };
} stc_intreq_irq005sel_field_t;

typedef struct stc_intreq_irq006sel_field
{
    union {
        struct {
            __IO  uint32_t  SELIRQ               :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  SELBIT0              :1;
            __IO  uint32_t  SELBIT1              :1;
            __IO  uint32_t  SELBIT2              :1;
            __IO  uint32_t  SELBIT3              :1;
            __IO  uint32_t  SELBIT4              :1;
            __IO  uint32_t  SELBIT5              :1;
            __IO  uint32_t  SELBIT6              :1;
            __IO  uint32_t  SELBIT7              :1;
            __IO  uint32_t  SELBIT8              :1;
            __IO  uint32_t  SELBIT9              :1;
            __IO  uint32_t  SELBIT10             :1;
            __IO  uint32_t  SELBIT11             :1;
            __IO  uint32_t  SELBIT12             :1;
            __IO  uint32_t  SELBIT13             :1;
            __IO  uint32_t  SELBIT14             :1;
            __IO  uint32_t  SELBIT15             :1;
        };
        struct {
            __IO  uint32_t  SELIRQ0              :1;
            __IO  uint32_t  SELIRQ1              :1;
            __IO  uint32_t  SELIRQ2              :1;
            __IO  uint32_t  SELIRQ3              :1;
            __IO  uint32_t  SELIRQ4              :1;
            __IO  uint32_t  SELIRQ5              :1;
            __IO  uint32_t  SELIRQ6              :1;
            __IO  uint32_t  SELIRQ7              :1;
            __IO  uint32_t  RESERVED1            :24;
        };
    };
} stc_intreq_irq006sel_field_t;

typedef struct stc_intreq_irq007sel_field
{
    union {
        struct {
            __IO  uint32_t  SELIRQ               :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  SELBIT0              :1;
            __IO  uint32_t  SELBIT1              :1;
            __IO  uint32_t  SELBIT2              :1;
            __IO  uint32_t  SELBIT3              :1;
            __IO  uint32_t  SELBIT4              :1;
            __IO  uint32_t  SELBIT5              :1;
            __IO  uint32_t  SELBIT6              :1;
            __IO  uint32_t  SELBIT7              :1;
            __IO  uint32_t  SELBIT8              :1;
            __IO  uint32_t  SELBIT9              :1;
            __IO  uint32_t  SELBIT10             :1;
            __IO  uint32_t  SELBIT11             :1;
            __IO  uint32_t  SELBIT12             :1;
            __IO  uint32_t  SELBIT13             :1;
            __IO  uint32_t  SELBIT14             :1;
            __IO  uint32_t  SELBIT15             :1;
        };
        struct {
            __IO  uint32_t  SELIRQ0              :1;
            __IO  uint32_t  SELIRQ1              :1;
            __IO  uint32_t  SELIRQ2              :1;
            __IO  uint32_t  SELIRQ3              :1;
            __IO  uint32_t  SELIRQ4              :1;
            __IO  uint32_t  SELIRQ5              :1;
            __IO  uint32_t  SELIRQ6              :1;
            __IO  uint32_t  SELIRQ7              :1;
            __IO  uint32_t  RESERVED1            :24;
        };
    };
} stc_intreq_irq007sel_field_t;

typedef struct stc_intreq_irq008sel_field
{
    union {
        struct {
            __IO  uint32_t  SELIRQ               :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  SELBIT0              :1;
            __IO  uint32_t  SELBIT1              :1;
            __IO  uint32_t  SELBIT2              :1;
            __IO  uint32_t  SELBIT3              :1;
            __IO  uint32_t  SELBIT4              :1;
            __IO  uint32_t  SELBIT5              :1;
            __IO  uint32_t  SELBIT6              :1;
            __IO  uint32_t  SELBIT7              :1;
            __IO  uint32_t  SELBIT8              :1;
            __IO  uint32_t  SELBIT9              :1;
            __IO  uint32_t  SELBIT10             :1;
            __IO  uint32_t  SELBIT11             :1;
            __IO  uint32_t  SELBIT12             :1;
            __IO  uint32_t  SELBIT13             :1;
            __IO  uint32_t  SELBIT14             :1;
            __IO  uint32_t  SELBIT15             :1;
        };
        struct {
            __IO  uint32_t  SELIRQ0              :1;
            __IO  uint32_t  SELIRQ1              :1;
            __IO  uint32_t  SELIRQ2              :1;
            __IO  uint32_t  SELIRQ3              :1;
            __IO  uint32_t  SELIRQ4              :1;
            __IO  uint32_t  SELIRQ5              :1;
            __IO  uint32_t  SELIRQ6              :1;
            __IO  uint32_t  SELIRQ7              :1;
            __IO  uint32_t  RESERVED1            :24;
        };
    };
} stc_intreq_irq008sel_field_t;

typedef struct stc_intreq_irq009sel_field
{
    union {
        struct {
            __IO  uint32_t  SELIRQ               :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  SELBIT0              :1;
            __IO  uint32_t  SELBIT1              :1;
            __IO  uint32_t  SELBIT2              :1;
            __IO  uint32_t  SELBIT3              :1;
            __IO  uint32_t  SELBIT4              :1;
            __IO  uint32_t  SELBIT5              :1;
            __IO  uint32_t  SELBIT6              :1;
            __IO  uint32_t  SELBIT7              :1;
            __IO  uint32_t  SELBIT8              :1;
            __IO  uint32_t  SELBIT9              :1;
            __IO  uint32_t  SELBIT10             :1;
            __IO  uint32_t  SELBIT11             :1;
            __IO  uint32_t  SELBIT12             :1;
            __IO  uint32_t  SELBIT13             :1;
            __IO  uint32_t  SELBIT14             :1;
            __IO  uint32_t  SELBIT15             :1;
        };
        struct {
            __IO  uint32_t  SELIRQ0              :1;
            __IO  uint32_t  SELIRQ1              :1;
            __IO  uint32_t  SELIRQ2              :1;
            __IO  uint32_t  SELIRQ3              :1;
            __IO  uint32_t  SELIRQ4              :1;
            __IO  uint32_t  SELIRQ5              :1;
            __IO  uint32_t  SELIRQ6              :1;
            __IO  uint32_t  SELIRQ7              :1;
            __IO  uint32_t  RESERVED1            :24;
        };
    };
} stc_intreq_irq009sel_field_t;

typedef struct stc_intreq_irq010sel_field
{
    union {
        struct {
            __IO  uint32_t  SELIRQ               :8;
            __IO  uint32_t  RESERVED0            :8;
            __IO  uint32_t  SELBIT0              :1;
            __IO  uint32_t  SELBIT1              :1;
            __IO  uint32_t  SELBIT2              :1;
            __IO  uint32_t  SELBIT3              :1;
            __IO  uint32_t  SELBIT4              :1;
            __IO  uint32_t  SELBIT5              :1;
            __IO  uint32_t  SELBIT6              :1;
            __IO  uint32_t  SELBIT7              :1;
            __IO  uint32_t  SELBIT8              :1;
            __IO  uint32_t  SELBIT9              :1;
            __IO  uint32_t  SELBIT10             :1;
            __IO  uint32_t  SELBIT11             :1;
            __IO  uint32_t  SELBIT12             :1;
            __IO  uint32_t  SELBIT13             :1;
            __IO  uint32_t  SELBIT14             :1;
            __IO  uint32_t  SELBIT15             :1;
        };
        struct {
            __IO  uint32_t  SELIRQ0              :1;
            __IO  uint32_t  SELIRQ1              :1;
            __IO  uint32_t  SELIRQ2              :1;
            __IO  uint32_t  SELIRQ3              :1;
            __IO  uint32_t  SELIRQ4              :1;
            __IO  uint32_t  SELIRQ5              :1;
            __IO  uint32_t  SELIRQ6              :1;
            __IO  uint32_t  SELIRQ7              :1;
            __IO  uint32_t  RESERVED1            :24;
        };
    };
} stc_intreq_irq010sel_field_t;

typedef struct stc_intreq_exc02mon_field
{
        __IO  uint32_t  NMI                      :1;
        __IO  uint32_t  HWINT                    :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_exc02mon_field_t;

typedef struct stc_intreq_irq000mon_field
{
        __IO  uint32_t  FCSINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq000mon_field_t;

typedef struct stc_intreq_irq001mon_field
{
        __IO  uint32_t  SWWDTINT                 :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq001mon_field_t;

typedef struct stc_intreq_irq002mon_field
{
        __IO  uint32_t  LVDINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq002mon_field_t;

typedef struct stc_intreq_irq003mon_field
{
        __IO  uint32_t  IRQBIT0                  :1;
        __IO  uint32_t  IRQBIT1                  :1;
        __IO  uint32_t  IRQBIT2                  :1;
        __IO  uint32_t  IRQBIT3                  :1;
        __IO  uint32_t  IRQBIT4                  :1;
        __IO  uint32_t  IRQBIT5                  :1;
        __IO  uint32_t  IRQBIT6                  :1;
        __IO  uint32_t  IRQBIT7                  :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_intreq_irq003mon_field_t;

typedef struct stc_intreq_irq004mon_field
{
        __IO  uint32_t  IRQBIT0                  :1;
        __IO  uint32_t  IRQBIT1                  :1;
        __IO  uint32_t  IRQBIT2                  :1;
        __IO  uint32_t  IRQBIT3                  :1;
        __IO  uint32_t  IRQBIT4                  :1;
        __IO  uint32_t  IRQBIT5                  :1;
        __IO  uint32_t  IRQBIT6                  :1;
        __IO  uint32_t  IRQBIT7                  :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_intreq_irq004mon_field_t;

typedef struct stc_intreq_irq005mon_field
{
        __IO  uint32_t  IRQBIT0                  :1;
        __IO  uint32_t  IRQBIT1                  :1;
        __IO  uint32_t  IRQBIT2                  :1;
        __IO  uint32_t  IRQBIT3                  :1;
        __IO  uint32_t  IRQBIT4                  :1;
        __IO  uint32_t  IRQBIT5                  :1;
        __IO  uint32_t  IRQBIT6                  :1;
        __IO  uint32_t  IRQBIT7                  :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_intreq_irq005mon_field_t;

typedef struct stc_intreq_irq006mon_field
{
        __IO  uint32_t  IRQBIT0                  :1;
        __IO  uint32_t  IRQBIT1                  :1;
        __IO  uint32_t  IRQBIT2                  :1;
        __IO  uint32_t  IRQBIT3                  :1;
        __IO  uint32_t  IRQBIT4                  :1;
        __IO  uint32_t  IRQBIT5                  :1;
        __IO  uint32_t  IRQBIT6                  :1;
        __IO  uint32_t  IRQBIT7                  :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_intreq_irq006mon_field_t;

typedef struct stc_intreq_irq007mon_field
{
        __IO  uint32_t  IRQBIT0                  :1;
        __IO  uint32_t  IRQBIT1                  :1;
        __IO  uint32_t  IRQBIT2                  :1;
        __IO  uint32_t  IRQBIT3                  :1;
        __IO  uint32_t  IRQBIT4                  :1;
        __IO  uint32_t  IRQBIT5                  :1;
        __IO  uint32_t  IRQBIT6                  :1;
        __IO  uint32_t  IRQBIT7                  :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_intreq_irq007mon_field_t;

typedef struct stc_intreq_irq008mon_field
{
        __IO  uint32_t  IRQBIT0                  :1;
        __IO  uint32_t  IRQBIT1                  :1;
        __IO  uint32_t  IRQBIT2                  :1;
        __IO  uint32_t  IRQBIT3                  :1;
        __IO  uint32_t  IRQBIT4                  :1;
        __IO  uint32_t  IRQBIT5                  :1;
        __IO  uint32_t  IRQBIT6                  :1;
        __IO  uint32_t  IRQBIT7                  :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_intreq_irq008mon_field_t;

typedef struct stc_intreq_irq009mon_field
{
        __IO  uint32_t  IRQBIT0                  :1;
        __IO  uint32_t  IRQBIT1                  :1;
        __IO  uint32_t  IRQBIT2                  :1;
        __IO  uint32_t  IRQBIT3                  :1;
        __IO  uint32_t  IRQBIT4                  :1;
        __IO  uint32_t  IRQBIT5                  :1;
        __IO  uint32_t  IRQBIT6                  :1;
        __IO  uint32_t  IRQBIT7                  :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_intreq_irq009mon_field_t;

typedef struct stc_intreq_irq010mon_field
{
        __IO  uint32_t  IRQBIT0                  :1;
        __IO  uint32_t  IRQBIT1                  :1;
        __IO  uint32_t  IRQBIT2                  :1;
        __IO  uint32_t  IRQBIT3                  :1;
        __IO  uint32_t  IRQBIT4                  :1;
        __IO  uint32_t  IRQBIT5                  :1;
        __IO  uint32_t  IRQBIT6                  :1;
        __IO  uint32_t  IRQBIT7                  :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_intreq_irq010mon_field_t;

typedef struct stc_intreq_irq011mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq011mon_field_t;

typedef struct stc_intreq_irq012mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq012mon_field_t;

typedef struct stc_intreq_irq013mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq013mon_field_t;

typedef struct stc_intreq_irq014mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq014mon_field_t;

typedef struct stc_intreq_irq015mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq015mon_field_t;

typedef struct stc_intreq_irq016mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq016mon_field_t;

typedef struct stc_intreq_irq017mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq017mon_field_t;

typedef struct stc_intreq_irq018mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq018mon_field_t;

typedef struct stc_intreq_irq019mon_field
{
        __IO  uint32_t  QPRCINT0                 :1;
        __IO  uint32_t  QPRCINT1                 :1;
        __IO  uint32_t  QPRCINT2                 :1;
        __IO  uint32_t  QPRCINT3                 :1;
        __IO  uint32_t  QPRCINT4                 :1;
        __IO  uint32_t  QPRCINT5                 :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_intreq_irq019mon_field_t;

typedef struct stc_intreq_irq020mon_field
{
        __IO  uint32_t  QPRCINT0                 :1;
        __IO  uint32_t  QPRCINT1                 :1;
        __IO  uint32_t  QPRCINT2                 :1;
        __IO  uint32_t  QPRCINT3                 :1;
        __IO  uint32_t  QPRCINT4                 :1;
        __IO  uint32_t  QPRCINT5                 :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_intreq_irq020mon_field_t;

typedef struct stc_intreq_irq021mon_field
{
        __IO  uint32_t  WAVEINT0                 :1;
        __IO  uint32_t  WAVEINT1                 :1;
        __IO  uint32_t  WAVEINT2                 :1;
        __IO  uint32_t  WAVEINT3                 :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_intreq_irq021mon_field_t;

typedef struct stc_intreq_irq022mon_field
{
        __IO  uint32_t  WAVEINT0                 :1;
        __IO  uint32_t  WAVEINT1                 :1;
        __IO  uint32_t  WAVEINT2                 :1;
        __IO  uint32_t  WAVEINT3                 :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_intreq_irq022mon_field_t;

typedef struct stc_intreq_irq023mon_field
{
        __IO  uint32_t  WAVEINT0                 :1;
        __IO  uint32_t  WAVEINT1                 :1;
        __IO  uint32_t  WAVEINT2                 :1;
        __IO  uint32_t  WAVEINT3                 :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_intreq_irq023mon_field_t;

typedef struct stc_intreq_irq024mon_field
{
        __IO  uint32_t  FRT_PEAK_INT0            :1;
        __IO  uint32_t  FRT_PEAK_INT1            :1;
        __IO  uint32_t  FRT_PEAK_INT2            :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_intreq_irq024mon_field_t;

typedef struct stc_intreq_irq025mon_field
{
        __IO  uint32_t  FRT_ZERO_INT0            :1;
        __IO  uint32_t  FRT_ZERO_INT1            :1;
        __IO  uint32_t  FRT_ZERO_INT2            :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_intreq_irq025mon_field_t;

typedef struct stc_intreq_irq026mon_field
{
        __IO  uint32_t  ICUINT0                  :1;
        __IO  uint32_t  ICUINT1                  :1;
        __IO  uint32_t  ICUINT2                  :1;
        __IO  uint32_t  ICUINT3                  :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_intreq_irq026mon_field_t;

typedef struct stc_intreq_irq027mon_field
{
        __IO  uint32_t  OCUINT0                  :1;
        __IO  uint32_t  OCUINT1                  :1;
        __IO  uint32_t  OCUINT2                  :1;
        __IO  uint32_t  OCUINT3                  :1;
        __IO  uint32_t  OCUINT4                  :1;
        __IO  uint32_t  OCUINT5                  :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_intreq_irq027mon_field_t;

typedef struct stc_intreq_irq028mon_field
{
        __IO  uint32_t  FRT_PEAK_INT0            :1;
        __IO  uint32_t  FRT_PEAK_INT1            :1;
        __IO  uint32_t  FRT_PEAK_INT2            :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_intreq_irq028mon_field_t;

typedef struct stc_intreq_irq029mon_field
{
        __IO  uint32_t  FRT_ZERO_INT0            :1;
        __IO  uint32_t  FRT_ZERO_INT1            :1;
        __IO  uint32_t  FRT_ZERO_INT2            :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_intreq_irq029mon_field_t;

typedef struct stc_intreq_irq030mon_field
{
        __IO  uint32_t  ICUINT0                  :1;
        __IO  uint32_t  ICUINT1                  :1;
        __IO  uint32_t  ICUINT2                  :1;
        __IO  uint32_t  ICUINT3                  :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_intreq_irq030mon_field_t;

typedef struct stc_intreq_irq031mon_field
{
        __IO  uint32_t  OCUINT0                  :1;
        __IO  uint32_t  OCUINT1                  :1;
        __IO  uint32_t  OCUINT2                  :1;
        __IO  uint32_t  OCUINT3                  :1;
        __IO  uint32_t  OCUINT4                  :1;
        __IO  uint32_t  OCUINT5                  :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_intreq_irq031mon_field_t;

typedef struct stc_intreq_irq032mon_field
{
        __IO  uint32_t  FRT_PEAK_INT0            :1;
        __IO  uint32_t  FRT_PEAK_INT1            :1;
        __IO  uint32_t  FRT_PEAK_INT2            :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_intreq_irq032mon_field_t;

typedef struct stc_intreq_irq033mon_field
{
        __IO  uint32_t  FRT_ZERO_INT0            :1;
        __IO  uint32_t  FRT_ZERO_INT1            :1;
        __IO  uint32_t  FRT_ZERO_INT2            :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_intreq_irq033mon_field_t;

typedef struct stc_intreq_irq034mon_field
{
        __IO  uint32_t  ICUINT0                  :1;
        __IO  uint32_t  ICUINT1                  :1;
        __IO  uint32_t  ICUINT2                  :1;
        __IO  uint32_t  ICUINT3                  :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_intreq_irq034mon_field_t;

typedef struct stc_intreq_irq035mon_field
{
        __IO  uint32_t  OCUINT0                  :1;
        __IO  uint32_t  OCUINT1                  :1;
        __IO  uint32_t  OCUINT2                  :1;
        __IO  uint32_t  OCUINT3                  :1;
        __IO  uint32_t  OCUINT4                  :1;
        __IO  uint32_t  OCUINT5                  :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_intreq_irq035mon_field_t;

typedef struct stc_intreq_irq036mon_field
{
        __IO  uint32_t  PPGINT0                  :1;
        __IO  uint32_t  PPGINT1                  :1;
        __IO  uint32_t  PPGINT2                  :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_intreq_irq036mon_field_t;

typedef struct stc_intreq_irq037mon_field
{
        __IO  uint32_t  PPGINT0                  :1;
        __IO  uint32_t  PPGINT1                  :1;
        __IO  uint32_t  PPGINT2                  :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_intreq_irq037mon_field_t;

typedef struct stc_intreq_irq038mon_field
{
        __IO  uint32_t  PPGINT0                  :1;
        __IO  uint32_t  PPGINT1                  :1;
        __IO  uint32_t  PPGINT2                  :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_intreq_irq038mon_field_t;

typedef struct stc_intreq_irq039mon_field
{
        __IO  uint32_t  BTINT0                   :1;
        __IO  uint32_t  BTINT1                   :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq039mon_field_t;

typedef struct stc_intreq_irq040mon_field
{
        __IO  uint32_t  BTINT0                   :1;
        __IO  uint32_t  BTINT1                   :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq040mon_field_t;

typedef struct stc_intreq_irq041mon_field
{
        __IO  uint32_t  BTINT0                   :1;
        __IO  uint32_t  BTINT1                   :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq041mon_field_t;

typedef struct stc_intreq_irq042mon_field
{
        __IO  uint32_t  BTINT0                   :1;
        __IO  uint32_t  BTINT1                   :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq042mon_field_t;

typedef struct stc_intreq_irq043mon_field
{
        __IO  uint32_t  BTINT0                   :1;
        __IO  uint32_t  BTINT1                   :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq043mon_field_t;

typedef struct stc_intreq_irq044mon_field
{
        __IO  uint32_t  BTINT0                   :1;
        __IO  uint32_t  BTINT1                   :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq044mon_field_t;

typedef struct stc_intreq_irq045mon_field
{
        __IO  uint32_t  BTINT0                   :1;
        __IO  uint32_t  BTINT1                   :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq045mon_field_t;

typedef struct stc_intreq_irq046mon_field
{
        __IO  uint32_t  BTINT0                   :1;
        __IO  uint32_t  BTINT1                   :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq046mon_field_t;

typedef struct stc_intreq_irq047mon_field
{
        __IO  uint32_t  TIMINT1                  :1;
        __IO  uint32_t  TIMINT2                  :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq047mon_field_t;

typedef struct stc_intreq_irq048mon_field
{
        __IO  uint32_t  WCINT                    :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq048mon_field_t;

typedef struct stc_intreq_irq049mon_field
{
        __IO  uint32_t  BMEMCS                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq049mon_field_t;

typedef struct stc_intreq_irq050mon_field
{
        __IO  uint32_t  RTCINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq050mon_field_t;

typedef struct stc_intreq_irq051mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq051mon_field_t;

typedef struct stc_intreq_irq052mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq052mon_field_t;

typedef struct stc_intreq_irq053mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq053mon_field_t;

typedef struct stc_intreq_irq054mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq054mon_field_t;

typedef struct stc_intreq_irq055mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq055mon_field_t;

typedef struct stc_intreq_irq056mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq056mon_field_t;

typedef struct stc_intreq_irq057mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq057mon_field_t;

typedef struct stc_intreq_irq058mon_field
{
        __IO  uint32_t  EXTINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq058mon_field_t;

typedef struct stc_intreq_irq059mon_field
{
        __IO  uint32_t  MOSCINT                  :1;
        __IO  uint32_t  SOSCINT                  :1;
        __IO  uint32_t  MPLLINT                  :1;
        __IO  uint32_t  UPLLINT                  :1;
        __IO  uint32_t  IPLLINT                  :1;
        __IO  uint32_t  RESERVED0                :27;
} stc_intreq_irq059mon_field_t;

typedef struct stc_intreq_irq060mon_field
{
        __IO  uint32_t  MFSINT0_RX               :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq060mon_field_t;

typedef struct stc_intreq_irq061mon_field
{
        __IO  uint32_t  MFSINT0_TX               :1;
        __IO  uint32_t  MFSINT0_STATUS           :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq061mon_field_t;

typedef struct stc_intreq_irq062mon_field
{
        __IO  uint32_t  MFSINT1_RX               :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq062mon_field_t;

typedef struct stc_intreq_irq063mon_field
{
        __IO  uint32_t  MFSINT1_TX               :1;
        __IO  uint32_t  MFSINT1_STATUS           :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq063mon_field_t;

typedef struct stc_intreq_irq064mon_field
{
        __IO  uint32_t  MFSINT2_RX               :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq064mon_field_t;

typedef struct stc_intreq_irq065mon_field
{
        __IO  uint32_t  MFSINT2_TX               :1;
        __IO  uint32_t  MFSINT2_STATUS           :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq065mon_field_t;

typedef struct stc_intreq_irq066mon_field
{
        __IO  uint32_t  MFSINT3_RX               :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq066mon_field_t;

typedef struct stc_intreq_irq067mon_field
{
        __IO  uint32_t  MFSINT3_TX               :1;
        __IO  uint32_t  MFSINT3_STATUS           :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq067mon_field_t;

typedef struct stc_intreq_irq068mon_field
{
        __IO  uint32_t  MFSINT4_RX               :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq068mon_field_t;

typedef struct stc_intreq_irq069mon_field
{
        __IO  uint32_t  MFSINT4_TX               :1;
        __IO  uint32_t  MFSINT4_STATUS           :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq069mon_field_t;

typedef struct stc_intreq_irq070mon_field
{
        __IO  uint32_t  MFSINT5_RX               :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq070mon_field_t;

typedef struct stc_intreq_irq071mon_field
{
        __IO  uint32_t  MFSINT5_TX               :1;
        __IO  uint32_t  MFSINT5_STATUS           :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq071mon_field_t;

typedef struct stc_intreq_irq072mon_field
{
        __IO  uint32_t  MFSINT6_RX               :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq072mon_field_t;

typedef struct stc_intreq_irq073mon_field
{
        __IO  uint32_t  MFSINT6_TX               :1;
        __IO  uint32_t  MFSINT6_STATUS           :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq073mon_field_t;

typedef struct stc_intreq_irq074mon_field
{
        __IO  uint32_t  MFSINT7_RX               :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq074mon_field_t;

typedef struct stc_intreq_irq075mon_field
{
        __IO  uint32_t  MFSINT7_TX               :1;
        __IO  uint32_t  MFSINT7_STATUS           :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq075mon_field_t;

typedef struct stc_intreq_irq076mon_field
{
        __IO  uint32_t  ADCINT0                  :1;
        __IO  uint32_t  ADCINT1                  :1;
        __IO  uint32_t  ADCINT2                  :1;
        __IO  uint32_t  ADCINT3                  :1;
        __IO  uint32_t  ADCINT4                  :1;
        __IO  uint32_t  RESERVED0                :27;
} stc_intreq_irq076mon_field_t;

typedef struct stc_intreq_irq077mon_field
{
        __IO  uint32_t  ADCINT0                  :1;
        __IO  uint32_t  ADCINT1                  :1;
        __IO  uint32_t  ADCINT2                  :1;
        __IO  uint32_t  ADCINT3                  :1;
        __IO  uint32_t  ADCINT4                  :1;
        __IO  uint32_t  RESERVED0                :27;
} stc_intreq_irq077mon_field_t;

typedef struct stc_intreq_irq078mon_field
{
        __IO  uint32_t  USB_DRQ_INT0             :1;
        __IO  uint32_t  USB_DRQ_INT1             :1;
        __IO  uint32_t  USB_DRQ_INT2             :1;
        __IO  uint32_t  USB_DRQ_INT3             :1;
        __IO  uint32_t  USB_DRQ_INT4             :1;
        __IO  uint32_t  RESERVED0                :27;
} stc_intreq_irq078mon_field_t;

typedef struct stc_intreq_irq079mon_field
{
        __IO  uint32_t  USB_INT0                 :1;
        __IO  uint32_t  USB_INT1                 :1;
        __IO  uint32_t  USB_INT2                 :1;
        __IO  uint32_t  USB_INT3                 :1;
        __IO  uint32_t  USB_INT4                 :1;
        __IO  uint32_t  USB_INT5                 :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_intreq_irq079mon_field_t;

typedef struct stc_intreq_irq080mon_field
{
        __IO  uint32_t  CANINT                   :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq080mon_field_t;

typedef struct stc_intreq_irq081mon_field
{
        __IO  uint32_t  CANINT                   :1;
        __IO  uint32_t  CANDEINT                 :1;
        __IO  uint32_t  CANSEINT                 :1;
        __IO  uint32_t  CAN0INT                  :1;
        __IO  uint32_t  CAN1INT                  :1;
        __IO  uint32_t  RESERVED0                :27;
} stc_intreq_irq081mon_field_t;

typedef struct stc_intreq_irq082mon_field
{
        __IO  uint32_t  MACSBD                   :1;
        __IO  uint32_t  MACPMT                   :1;
        __IO  uint32_t  MACLPI                   :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_intreq_irq082mon_field_t;

typedef struct stc_intreq_irq083mon_field
{
        __IO  uint32_t  DMACINT                  :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq083mon_field_t;

typedef struct stc_intreq_irq084mon_field
{
        __IO  uint32_t  DMACINT                  :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq084mon_field_t;

typedef struct stc_intreq_irq085mon_field
{
        __IO  uint32_t  DMACINT                  :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq085mon_field_t;

typedef struct stc_intreq_irq086mon_field
{
        __IO  uint32_t  DMACINT                  :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq086mon_field_t;

typedef struct stc_intreq_irq087mon_field
{
        __IO  uint32_t  DMACINT                  :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq087mon_field_t;

typedef struct stc_intreq_irq088mon_field
{
        __IO  uint32_t  DMACINT                  :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq088mon_field_t;

typedef struct stc_intreq_irq089mon_field
{
        __IO  uint32_t  DMACINT                  :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq089mon_field_t;

typedef struct stc_intreq_irq090mon_field
{
        __IO  uint32_t  DMACINT                  :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq090mon_field_t;

typedef struct stc_intreq_irq091mon_field
{
        __IO  uint32_t  DSTCINT0                 :1;
        __IO  uint32_t  DSTCINT1                 :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq091mon_field_t;

typedef struct stc_intreq_irq092mon_field
{
        __IO  uint32_t  EXTINT0                  :1;
        __IO  uint32_t  EXTINT1                  :1;
        __IO  uint32_t  EXTINT2                  :1;
        __IO  uint32_t  EXTINT3                  :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_intreq_irq092mon_field_t;

typedef struct stc_intreq_irq093mon_field
{
        __IO  uint32_t  EXTINT0                  :1;
        __IO  uint32_t  EXTINT1                  :1;
        __IO  uint32_t  EXTINT2                  :1;
        __IO  uint32_t  EXTINT3                  :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_intreq_irq093mon_field_t;

typedef struct stc_intreq_irq094mon_field
{
        __IO  uint32_t  EXTINT0                  :1;
        __IO  uint32_t  EXTINT1                  :1;
        __IO  uint32_t  EXTINT2                  :1;
        __IO  uint32_t  EXTINT3                  :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_intreq_irq094mon_field_t;

typedef struct stc_intreq_irq095mon_field
{
        __IO  uint32_t  EXTINT0                  :1;
        __IO  uint32_t  EXTINT1                  :1;
        __IO  uint32_t  EXTINT2                  :1;
        __IO  uint32_t  EXTINT3                  :1;
        __IO  uint32_t  RESERVED0                :28;
} stc_intreq_irq095mon_field_t;

typedef struct stc_intreq_irq096mon_field
{
        __IO  uint32_t  QPRCINT0                 :1;
        __IO  uint32_t  QPRCINT1                 :1;
        __IO  uint32_t  QPRCINT2                 :1;
        __IO  uint32_t  QPRCINT3                 :1;
        __IO  uint32_t  QPRCINT4                 :1;
        __IO  uint32_t  QPRCINT5                 :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_intreq_irq096mon_field_t;

typedef struct stc_intreq_irq097mon_field
{
        __IO  uint32_t  QPRCINT0                 :1;
        __IO  uint32_t  QPRCINT1                 :1;
        __IO  uint32_t  QPRCINT2                 :1;
        __IO  uint32_t  QPRCINT3                 :1;
        __IO  uint32_t  QPRCINT4                 :1;
        __IO  uint32_t  QPRCINT5                 :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_intreq_irq097mon_field_t;

typedef struct stc_intreq_irq098mon_field
{
        __IO  uint32_t  BTINT0                   :1;
        __IO  uint32_t  BTINT1                   :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq098mon_field_t;

typedef struct stc_intreq_irq099mon_field
{
        __IO  uint32_t  BTINT0                   :1;
        __IO  uint32_t  BTINT1                   :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq099mon_field_t;

typedef struct stc_intreq_irq100mon_field
{
        __IO  uint32_t  BTINT0                   :1;
        __IO  uint32_t  BTINT1                   :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq100mon_field_t;

typedef struct stc_intreq_irq101mon_field
{
        __IO  uint32_t  BTINT0                   :1;
        __IO  uint32_t  BTINT1                   :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq101mon_field_t;

typedef struct stc_intreq_irq102mon_field
{
        __IO  uint32_t  BTINT0                   :1;
        __IO  uint32_t  BTINT1                   :1;
        __IO  uint32_t  BTINT2                   :1;
        __IO  uint32_t  BTINT3                   :1;
        __IO  uint32_t  BTINT4                   :1;
        __IO  uint32_t  BTINT5                   :1;
        __IO  uint32_t  BTINT6                   :1;
        __IO  uint32_t  BTINT7                   :1;
        __IO  uint32_t  RESERVED0                :24;
} stc_intreq_irq102mon_field_t;

typedef struct stc_intreq_irq103mon_field
{
        __IO  uint32_t  MFSINT8_RX               :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq103mon_field_t;

typedef struct stc_intreq_irq104mon_field
{
        __IO  uint32_t  MFSINT8_TX               :1;
        __IO  uint32_t  MFSINT8_STATUS           :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq104mon_field_t;

typedef struct stc_intreq_irq105mon_field
{
        __IO  uint32_t  MFSINT9_RX               :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq105mon_field_t;

typedef struct stc_intreq_irq106mon_field
{
        __IO  uint32_t  MFSINT9_TX               :1;
        __IO  uint32_t  MFSINT9_STATUS           :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq106mon_field_t;

typedef struct stc_intreq_irq107mon_field
{
        __IO  uint32_t  MFSINT10_RX              :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq107mon_field_t;

typedef struct stc_intreq_irq108mon_field
{
        __IO  uint32_t  MFSINT10_TX              :1;
        __IO  uint32_t  MFSINT10_STATUS          :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq108mon_field_t;

typedef struct stc_intreq_irq109mon_field
{
        __IO  uint32_t  MFSINT11_RX              :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq109mon_field_t;

typedef struct stc_intreq_irq110mon_field
{
        __IO  uint32_t  MFSINT11_TX              :1;
        __IO  uint32_t  MFSINT11_STATUS          :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq110mon_field_t;

typedef struct stc_intreq_irq111mon_field
{
        __IO  uint32_t  ADCINT0                  :1;
        __IO  uint32_t  ADCINT1                  :1;
        __IO  uint32_t  ADCINT2                  :1;
        __IO  uint32_t  ADCINT3                  :1;
        __IO  uint32_t  ADCINT4                  :1;
        __IO  uint32_t  RESERVED0                :27;
} stc_intreq_irq111mon_field_t;

typedef struct stc_intreq_irq112mon_field
{
        __IO  uint32_t  I2SDINT0                 :1;
        __IO  uint32_t  I2SDINT1                 :1;
        __IO  uint32_t  HSSPIDINT0               :1;
        __IO  uint32_t  HSSPIDINT1               :1;
        __IO  uint32_t  PCRCDINT                 :1;
        __IO  uint32_t  CANDINT                  :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_intreq_irq112mon_field_t;

typedef struct stc_intreq_irq113mon_field
{
        __IO  uint32_t  USB_DRQ_INT0             :1;
        __IO  uint32_t  USB_DRQ_INT1             :1;
        __IO  uint32_t  USB_DRQ_INT2             :1;
        __IO  uint32_t  USB_DRQ_INT3             :1;
        __IO  uint32_t  USB_DRQ_INT4             :1;
        __IO  uint32_t  RCEC0INT                 :1;
        __IO  uint32_t  RESERVED0                :26;
} stc_intreq_irq113mon_field_t;

typedef struct stc_intreq_irq114mon_field
{
        __IO  uint32_t  USB_INT0                 :1;
        __IO  uint32_t  USB_INT1                 :1;
        __IO  uint32_t  USB_INT2                 :1;
        __IO  uint32_t  USB_INT3                 :1;
        __IO  uint32_t  USB_INT4                 :1;
        __IO  uint32_t  USB_INT5                 :1;
        __IO  uint32_t  RCEC1INT                 :1;
        __IO  uint32_t  RESERVED0                :25;
} stc_intreq_irq114mon_field_t;

typedef struct stc_intreq_irq115mon_field
{
        __IO  uint32_t  HSSPIINT0                :1;
        __IO  uint32_t  HSSPIINT1                :1;
        __IO  uint32_t  HSSPIINT2                :1;
        __IO  uint32_t  RESERVED0                :29;
} stc_intreq_irq115mon_field_t;

typedef struct stc_intreq_irq117mon_field
{
        __IO  uint32_t  I2SINT                   :1;
        __IO  uint32_t  PCRC                     :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq117mon_field_t;

typedef struct stc_intreq_irq118mon_field
{
        __IO  uint32_t  SDINT0                   :1;
        __IO  uint32_t  SDINT1                   :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq118mon_field_t;

typedef struct stc_intreq_irq119mon_field
{
        __IO  uint32_t  FLINT                    :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq119mon_field_t;

typedef struct stc_intreq_irq120mon_field
{
        __IO  uint32_t  MFSINT12_RX              :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq120mon_field_t;

typedef struct stc_intreq_irq121mon_field
{
        __IO  uint32_t  MFSINT12_TX              :1;
        __IO  uint32_t  MFSINT12_STATUS          :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq121mon_field_t;

typedef struct stc_intreq_irq122mon_field
{
        __IO  uint32_t  MFSINT13_RX              :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq122mon_field_t;

typedef struct stc_intreq_irq123mon_field
{
        __IO  uint32_t  MFSINT13_TX              :1;
        __IO  uint32_t  MFSINT13_STATUS          :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq123mon_field_t;

typedef struct stc_intreq_irq124mon_field
{
        __IO  uint32_t  MFSINT14_RX              :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq124mon_field_t;

typedef struct stc_intreq_irq125mon_field
{
        __IO  uint32_t  MFSINT14_TX              :1;
        __IO  uint32_t  MFSINT14_STATUS          :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq125mon_field_t;

typedef struct stc_intreq_irq126mon_field
{
        __IO  uint32_t  MFSINT15_RX              :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_intreq_irq126mon_field_t;

typedef struct stc_intreq_irq127mon_field
{
        __IO  uint32_t  MFSINT15_TX              :1;
        __IO  uint32_t  MFSINT15_STATUS          :1;
        __IO  uint32_t  RESERVED0                :30;
} stc_intreq_irq127mon_field_t;

/******************************************************************************
 ** LSCRP_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_lscrp_lcr_prsld_field
{
    union {
        struct {
            __IO   uint8_t  LCR_PRSLD            :6;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  LCR_PRSLD0           :1;
            __IO   uint8_t  LCR_PRSLD1           :1;
            __IO   uint8_t  LCR_PRSLD2           :1;
            __IO   uint8_t  LCR_PRSLD3           :1;
            __IO   uint8_t  LCR_PRSLD4           :1;
            __IO   uint8_t  LCR_PRSLD5           :1;
            __IO   uint8_t  RESERVED1            :2;
        };
    };
} stc_lscrp_lcr_prsld_field_t;

/******************************************************************************
 ** LVD_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_lvd_lvd_ctl_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  SVHI                 :5;
            __IO   uint8_t  LVDIE                :1;
        };
        struct {
            __IO   uint8_t  RESERVED1            :2;
            __IO   uint8_t  SVHI0                :1;
            __IO   uint8_t  SVHI1                :1;
            __IO   uint8_t  SVHI2                :1;
            __IO   uint8_t  SVHI3                :1;
            __IO   uint8_t  SVHI4                :1;
            __IO   uint8_t  RESERVED2            :1;
        };
    };
} stc_lvd_lvd_ctl_field_t;

typedef struct stc_lvd_lvd_str_field
{
        __IO   uint8_t  RESERVED0                :7;
        __IO   uint8_t  LVDIR                    :1;
} stc_lvd_lvd_str_field_t;

typedef struct stc_lvd_lvd_clr_field
{
        __IO   uint8_t  RESERVED0                :7;
        __IO   uint8_t  LVDCL                    :1;
} stc_lvd_lvd_clr_field_t;

typedef struct stc_lvd_lvd_rlr_field
{
    union {
        struct {
            __IO  uint32_t  LVDLCK               :32;
        };
        struct {
            __IO  uint32_t  LVDLCK0              :1;
            __IO  uint32_t  LVDLCK1              :1;
            __IO  uint32_t  LVDLCK2              :1;
            __IO  uint32_t  LVDLCK3              :1;
            __IO  uint32_t  LVDLCK4              :1;
            __IO  uint32_t  LVDLCK5              :1;
            __IO  uint32_t  LVDLCK6              :1;
            __IO  uint32_t  LVDLCK7              :1;
            __IO  uint32_t  LVDLCK8              :1;
            __IO  uint32_t  LVDLCK9              :1;
            __IO  uint32_t  LVDLCK10             :1;
            __IO  uint32_t  LVDLCK11             :1;
            __IO  uint32_t  LVDLCK12             :1;
            __IO  uint32_t  LVDLCK13             :1;
            __IO  uint32_t  LVDLCK14             :1;
            __IO  uint32_t  LVDLCK15             :1;
            __IO  uint32_t  LVDLCK16             :1;
            __IO  uint32_t  LVDLCK17             :1;
            __IO  uint32_t  LVDLCK18             :1;
            __IO  uint32_t  LVDLCK19             :1;
            __IO  uint32_t  LVDLCK20             :1;
            __IO  uint32_t  LVDLCK21             :1;
            __IO  uint32_t  LVDLCK22             :1;
            __IO  uint32_t  LVDLCK23             :1;
            __IO  uint32_t  LVDLCK24             :1;
            __IO  uint32_t  LVDLCK25             :1;
            __IO  uint32_t  LVDLCK26             :1;
            __IO  uint32_t  LVDLCK27             :1;
            __IO  uint32_t  LVDLCK28             :1;
            __IO  uint32_t  LVDLCK29             :1;
            __IO  uint32_t  LVDLCK30             :1;
            __IO  uint32_t  LVDLCK31             :1;
        };
    };
} stc_lvd_lvd_rlr_field_t;

typedef struct stc_lvd_lvd_str2_field
{
        __IO   uint8_t  RESERVED0                :7;
        __IO   uint8_t  LVDIRDY                  :1;
} stc_lvd_lvd_str2_field_t;

/******************************************************************************
 ** MFS_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_mfs_smr_field
{
    union {
        union {
            struct {
                __IO   uint8_t  SOE              :1;
                __IO   uint8_t  SCKE             :1;
                __IO   uint8_t  BDS              :1;
                __IO   uint8_t  SCINV            :1;
                __IO   uint8_t  RESERVED0        :1;
                __IO   uint8_t  MD               :3;
            };
            struct {
                __IO   uint8_t  RESERVED1        :5;
                __IO   uint8_t  MD0              :1;
                __IO   uint8_t  MD1              :1;
                __IO   uint8_t  MD2              :1;
            };
        };
        union {
            struct {
                __IO   uint8_t  RESERVED2        :2;
                __IO   uint8_t  TIE              :1;
                __IO   uint8_t  RIE              :1;
                __IO   uint8_t  RESERVED3        :4;
            };
            struct {
                __IO   uint8_t  RESERVED4        :8;
            };
        };
        union {
            struct {
                __IO   uint8_t  RESERVED7        :3;
                __IO   uint8_t  SBL              :1;
                __IO   uint8_t  WUCR             :1;
                __IO   uint8_t  RESERVED8        :3;
            };
            struct {
                __IO   uint8_t  RESERVED9        :8;
            };
        };
    };
} stc_mfs_smr_field_t;

typedef struct stc_mfs_ibcr_field
{
    union {
        struct {
            __IO   uint8_t  TXE                  :1;
            __IO   uint8_t  RXE                  :1;
            __IO   uint8_t  TBIE                 :1;
            __IO   uint8_t  TIE                  :1;
            __IO   uint8_t  RIE                  :1;
            __IO   uint8_t  SPI                  :1;
            __IO   uint8_t  MS                   :1;
            __IO   uint8_t  UPCL                 :1;
        };
        struct {
            __IO   uint8_t  INT                  :1;
            __IO   uint8_t  BER                  :1;
            __IO   uint8_t  INTE                 :1;
            __IO   uint8_t  CNDE                 :1;
            __IO   uint8_t  WSEL                 :1;
            __IO   uint8_t  ACKE                 :1;
            __IO   uint8_t  ACT_SCC              :1;
            __IO   uint8_t  MSS                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED4            :5;
            __IO   uint8_t  LBR                  :1;
            __IO   uint8_t  RESERVED5            :2;
        };
    };
} stc_mfs_ibcr_field_t;

typedef struct stc_mfs_scr_field
{
    union {
        struct {
            __IO   uint8_t  TXE                  :1;
            __IO   uint8_t  RXE                  :1;
            __IO   uint8_t  TBIE                 :1;
            __IO   uint8_t  TIE                  :1;
            __IO   uint8_t  RIE                  :1;
            __IO   uint8_t  SPI                  :1;
            __IO   uint8_t  MS                   :1;
            __IO   uint8_t  UPCL                 :1;
        };
        struct {
            __IO   uint8_t  INT                  :1;
            __IO   uint8_t  BER                  :1;
            __IO   uint8_t  INTE                 :1;
            __IO   uint8_t  CNDE                 :1;
            __IO   uint8_t  WSEL                 :1;
            __IO   uint8_t  ACKE                 :1;
            __IO   uint8_t  ACT_SCC              :1;
            __IO   uint8_t  MSS                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED4            :5;
            __IO   uint8_t  LBR                  :1;
            __IO   uint8_t  RESERVED5            :2;
        };
    };
} stc_mfs_scr_field_t;

typedef struct stc_mfs_escr_field
{
    union {
        union {
            struct {
                __IO   uint8_t  L                :3;
                __IO   uint8_t  WT               :2;
                __IO   uint8_t  CSFE             :1;
                __IO   uint8_t  L3               :1;
                __IO   uint8_t  SOP              :1;
            };
            struct {
                __IO   uint8_t  L0               :1;
                __IO   uint8_t  L1               :1;
                __IO   uint8_t  L2               :1;
                __IO   uint8_t  WT0              :1;
                __IO   uint8_t  WT1              :1;
                __IO   uint8_t  RESERVED0        :3;
            };
        };
        struct {
            __IO   uint8_t  BB                   :1;
            __IO   uint8_t  SPC                  :1;
            __IO   uint8_t  RSC                  :1;
            __IO   uint8_t  AL                   :1;
            __IO   uint8_t  TRX                  :1;
            __IO   uint8_t  RSA                  :1;
            __IO   uint8_t  RACK                 :1;
            __IO   uint8_t  FBT                  :1;
        };
        union {
            struct {
                __IO   uint8_t  DEL              :2;
                __IO   uint8_t  LBL              :2;
                __IO   uint8_t  LBIE             :1;
                __IO   uint8_t  RESERVED4        :1;
                __IO   uint8_t  ESBL             :1;
                __IO   uint8_t  RESERVED5        :1;
            };
            struct {
                __IO   uint8_t  DEL0             :1;
                __IO   uint8_t  DEL1             :1;
                __IO   uint8_t  LBL0             :1;
                __IO   uint8_t  LBL1             :1;
                __IO   uint8_t  RESERVED6        :4;
            };
        };
        union {
            struct {
                __IO   uint8_t  RESERVED7        :3;
                __IO   uint8_t  P                :1;
                __IO   uint8_t  PEN              :1;
                __IO   uint8_t  INV              :1;
                __IO   uint8_t  RESERVED8        :1;
                __IO   uint8_t  FLWEN            :1;
            };
            struct {
                __IO   uint8_t  RESERVED9        :8;
            };
        };
    };
} stc_mfs_escr_field_t;

typedef struct stc_mfs_ibsr_field
{
    union {
        union {
            struct {
                __IO   uint8_t  L                :3;
                __IO   uint8_t  WT               :2;
                __IO   uint8_t  CSFE             :1;
                __IO   uint8_t  L3               :1;
                __IO   uint8_t  SOP              :1;
            };
            struct {
                __IO   uint8_t  L0               :1;
                __IO   uint8_t  L1               :1;
                __IO   uint8_t  L2               :1;
                __IO   uint8_t  WT0              :1;
                __IO   uint8_t  WT1              :1;
                __IO   uint8_t  RESERVED0        :3;
            };
        };
        struct {
            __IO   uint8_t  BB                   :1;
            __IO   uint8_t  SPC                  :1;
            __IO   uint8_t  RSC                  :1;
            __IO   uint8_t  AL                   :1;
            __IO   uint8_t  TRX                  :1;
            __IO   uint8_t  RSA                  :1;
            __IO   uint8_t  RACK                 :1;
            __IO   uint8_t  FBT                  :1;
        };
        union {
            struct {
                __IO   uint8_t  DEL              :2;
                __IO   uint8_t  LBL              :2;
                __IO   uint8_t  LBIE             :1;
                __IO   uint8_t  RESERVED4        :1;
                __IO   uint8_t  ESBL             :1;
                __IO   uint8_t  RESERVED5        :1;
            };
            struct {
                __IO   uint8_t  DEL0             :1;
                __IO   uint8_t  DEL1             :1;
                __IO   uint8_t  LBL0             :1;
                __IO   uint8_t  LBL1             :1;
                __IO   uint8_t  RESERVED6        :4;
            };
        };
        union {
            struct {
                __IO   uint8_t  RESERVED7        :3;
                __IO   uint8_t  P                :1;
                __IO   uint8_t  PEN              :1;
                __IO   uint8_t  INV              :1;
                __IO   uint8_t  RESERVED8        :1;
                __IO   uint8_t  FLWEN            :1;
            };
            struct {
                __IO   uint8_t  RESERVED9        :8;
            };
        };
    };
} stc_mfs_ibsr_field_t;

typedef struct stc_mfs_ssr_field
{
    union {
        struct {
            __IO   uint8_t  TBI                  :1;
            __IO   uint8_t  TDRE                 :1;
            __IO   uint8_t  RDRF                 :1;
            __IO   uint8_t  ORE                  :1;
            __IO   uint8_t  AWC                  :1;
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  REC                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED2            :4;
            __IO   uint8_t  TBIE                 :1;
            __IO   uint8_t  DMA                  :1;
            __IO   uint8_t  TSET                 :1;
            __IO   uint8_t  RESERVED3            :1;
        };
        struct {
            __IO   uint8_t  RESERVED7            :4;
            __IO   uint8_t  FRE                  :1;
            __IO   uint8_t  LBD                  :1;
            __IO   uint8_t  RESERVED8            :2;
        };
        struct {
            __IO   uint8_t  RESERVED10           :5;
            __IO   uint8_t  PE                   :1;
            __IO   uint8_t  RESERVED11           :2;
        };
    };
} stc_mfs_ssr_field_t;

typedef struct stc_mfs_rdr_field
{
    union {
        union {
            struct {
                __IO  uint16_t  D                :16;
            };
            struct {
                __IO  uint16_t  D0               :1;
                __IO  uint16_t  D1               :1;
                __IO  uint16_t  D2               :1;
                __IO  uint16_t  D3               :1;
                __IO  uint16_t  D4               :1;
                __IO  uint16_t  D5               :1;
                __IO  uint16_t  D6               :1;
                __IO  uint16_t  D7               :1;
                __IO  uint16_t  D8               :1;
                __IO  uint16_t  D9               :1;
                __IO  uint16_t  D10              :1;
                __IO  uint16_t  D11              :1;
                __IO  uint16_t  D12              :1;
                __IO  uint16_t  D13              :1;
                __IO  uint16_t  D14              :1;
                __IO  uint16_t  D15              :1;
            };
        };
    };
} stc_mfs_rdr_field_t;

typedef struct stc_mfs_tdr_field
{
    union {
        union {
            struct {
                __IO  uint16_t  D                :16;
            };
            struct {
                __IO  uint16_t  D0               :1;
                __IO  uint16_t  D1               :1;
                __IO  uint16_t  D2               :1;
                __IO  uint16_t  D3               :1;
                __IO  uint16_t  D4               :1;
                __IO  uint16_t  D5               :1;
                __IO  uint16_t  D6               :1;
                __IO  uint16_t  D7               :1;
                __IO  uint16_t  D8               :1;
                __IO  uint16_t  D9               :1;
                __IO  uint16_t  D10              :1;
                __IO  uint16_t  D11              :1;
                __IO  uint16_t  D12              :1;
                __IO  uint16_t  D13              :1;
                __IO  uint16_t  D14              :1;
                __IO  uint16_t  D15              :1;
            };
        };
    };
} stc_mfs_tdr_field_t;

typedef struct stc_mfs_bgr_field
{
    union {
        union {
            struct {
                __IO  uint16_t  BGR              :15;
                __IO  uint16_t  RESERVED0        :1;
            };
            struct {
                __IO  uint16_t  BGR0             :1;
                __IO  uint16_t  BGR1             :1;
                __IO  uint16_t  BGR2             :1;
                __IO  uint16_t  BGR3             :1;
                __IO  uint16_t  BGR4             :1;
                __IO  uint16_t  BGR5             :1;
                __IO  uint16_t  BGR6             :1;
                __IO  uint16_t  BGR7             :1;
                __IO  uint16_t  BGR8             :1;
                __IO  uint16_t  BGR9             :1;
                __IO  uint16_t  BGR10            :1;
                __IO  uint16_t  BGR11            :1;
                __IO  uint16_t  BGR12            :1;
                __IO  uint16_t  BGR13            :1;
                __IO  uint16_t  BGR14            :1;
                __IO  uint16_t  RESERVED1        :1;
            };
        };
        union {
            struct {
                __IO  uint16_t  RESERVED4        :15;
                __IO  uint16_t  EXT              :1;
            };
            struct {
                __IO  uint16_t  RESERVED5        :16;
            };
        };
    };
} stc_mfs_bgr_field_t;

typedef struct stc_mfs_isba_field
{
    union {
        struct {
            __IO   uint8_t  SA                   :7;
            __IO   uint8_t  SAEN                 :1;
        };
        struct {
            __IO   uint8_t  SA0                  :1;
            __IO   uint8_t  SA1                  :1;
            __IO   uint8_t  SA2                  :1;
            __IO   uint8_t  SA3                  :1;
            __IO   uint8_t  SA4                  :1;
            __IO   uint8_t  SA5                  :1;
            __IO   uint8_t  SA6                  :1;
            __IO   uint8_t  RESERVED0            :1;
        };
    };
} stc_mfs_isba_field_t;

typedef struct stc_mfs_ismk_field
{
    union {
        struct {
            __IO   uint8_t  SM                   :7;
            __IO   uint8_t  EN                   :1;
        };
        struct {
            __IO   uint8_t  SM0                  :1;
            __IO   uint8_t  SM1                  :1;
            __IO   uint8_t  SM2                  :1;
            __IO   uint8_t  SM3                  :1;
            __IO   uint8_t  SM4                  :1;
            __IO   uint8_t  SM5                  :1;
            __IO   uint8_t  SM6                  :1;
            __IO   uint8_t  RESERVED0            :1;
        };
    };
} stc_mfs_ismk_field_t;

typedef struct stc_mfs_fcr_field
{
    union {
        struct {
            __IO  uint16_t  FE1                  :1;
            __IO  uint16_t  FE2                  :1;
            __IO  uint16_t  FCL1                 :1;
            __IO  uint16_t  FCL2                 :1;
            __IO  uint16_t  FSET                 :1;
            __IO  uint16_t  FLD                  :1;
            __IO  uint16_t  FLST                 :1;
            __IO  uint16_t  RESERVED0            :1;
            __IO  uint16_t  FSEL                 :1;
            __IO  uint16_t  FTIE                 :1;
            __IO  uint16_t  FDRQ                 :1;
            __IO  uint16_t  FRIIE                :1;
            __IO  uint16_t  FLSTE                :1;
            __IO  uint16_t  RESERVED1            :3;
        };
    };
} stc_mfs_fcr_field_t;

typedef struct stc_mfs_fbyte1_field
{
    union {
        union {
            struct {
                __IO   uint8_t  FD               :8;
            };
            struct {
                __IO   uint8_t  FD0              :1;
                __IO   uint8_t  FD1              :1;
                __IO   uint8_t  FD2              :1;
                __IO   uint8_t  FD3              :1;
                __IO   uint8_t  FD4              :1;
                __IO   uint8_t  FD5              :1;
                __IO   uint8_t  FD6              :1;
                __IO   uint8_t  FD7              :1;
            };
        };
    };
} stc_mfs_fbyte1_field_t;

typedef struct stc_mfs_fbyte2_field
{
    union {
        union {
            struct {
                __IO   uint8_t  FD               :8;
            };
            struct {
                __IO   uint8_t  FD0              :1;
                __IO   uint8_t  FD1              :1;
                __IO   uint8_t  FD2              :1;
                __IO   uint8_t  FD3              :1;
                __IO   uint8_t  FD4              :1;
                __IO   uint8_t  FD5              :1;
                __IO   uint8_t  FD6              :1;
                __IO   uint8_t  FD7              :1;
            };
        };
    };
} stc_mfs_fbyte2_field_t;

typedef struct stc_mfs_nfcr_field
{
    union {
        union {
            struct {
                __IO   uint8_t  CSHD             :8;
            };
            struct {
                __IO   uint8_t  CSHD0            :1;
                __IO   uint8_t  CSHD1            :1;
                __IO   uint8_t  CSHD2            :1;
                __IO   uint8_t  CSHD3            :1;
                __IO   uint8_t  CSHD4            :1;
                __IO   uint8_t  CSHD5            :1;
                __IO   uint8_t  CSHD6            :1;
                __IO   uint8_t  CSHD7            :1;
            };
        };
        union {
            struct {
                __IO   uint8_t  NFT              :5;
                __IO   uint8_t  RESERVED0        :3;
            };
            struct {
                __IO   uint8_t  NFT0             :1;
                __IO   uint8_t  NFT1             :1;
                __IO   uint8_t  NFT2             :1;
                __IO   uint8_t  NFT3             :1;
                __IO   uint8_t  NFT4             :1;
                __IO   uint8_t  RESERVED1        :3;
            };
        };
    };
} stc_mfs_nfcr_field_t;

typedef struct stc_mfs_scstr0_field
{
    union {
        union {
            struct {
                __IO   uint8_t  CSHD             :8;
            };
            struct {
                __IO   uint8_t  CSHD0            :1;
                __IO   uint8_t  CSHD1            :1;
                __IO   uint8_t  CSHD2            :1;
                __IO   uint8_t  CSHD3            :1;
                __IO   uint8_t  CSHD4            :1;
                __IO   uint8_t  CSHD5            :1;
                __IO   uint8_t  CSHD6            :1;
                __IO   uint8_t  CSHD7            :1;
            };
        };
        union {
            struct {
                __IO   uint8_t  NFT              :5;
                __IO   uint8_t  RESERVED0        :3;
            };
            struct {
                __IO   uint8_t  NFT0             :1;
                __IO   uint8_t  NFT1             :1;
                __IO   uint8_t  NFT2             :1;
                __IO   uint8_t  NFT3             :1;
                __IO   uint8_t  NFT4             :1;
                __IO   uint8_t  RESERVED1        :3;
            };
        };
    };
} stc_mfs_scstr0_field_t;

typedef struct stc_mfs_eibcr_field
{
    union {
        union {
            struct {
                __IO   uint8_t  CSSU             :8;
            };
            struct {
                __IO   uint8_t  CSSU0            :1;
                __IO   uint8_t  CSSU1            :1;
                __IO   uint8_t  CSSU2            :1;
                __IO   uint8_t  CSSU3            :1;
                __IO   uint8_t  CSSU4            :1;
                __IO   uint8_t  CSSU5            :1;
                __IO   uint8_t  CSSU6            :1;
                __IO   uint8_t  CSSU7            :1;
            };
        };
        struct {
            __IO   uint8_t  BEC                  :1;
            __IO   uint8_t  SOCE                 :1;
            __IO   uint8_t  SCLC                 :1;
            __IO   uint8_t  SDAC                 :1;
            __IO   uint8_t  SCLS                 :1;
            __IO   uint8_t  SDAS                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
    };
} stc_mfs_eibcr_field_t;

typedef struct stc_mfs_scstr1_field
{
    union {
        union {
            struct {
                __IO   uint8_t  CSSU             :8;
            };
            struct {
                __IO   uint8_t  CSSU0            :1;
                __IO   uint8_t  CSSU1            :1;
                __IO   uint8_t  CSSU2            :1;
                __IO   uint8_t  CSSU3            :1;
                __IO   uint8_t  CSSU4            :1;
                __IO   uint8_t  CSSU5            :1;
                __IO   uint8_t  CSSU6            :1;
                __IO   uint8_t  CSSU7            :1;
            };
        };
        struct {
            __IO   uint8_t  BEC                  :1;
            __IO   uint8_t  SOCE                 :1;
            __IO   uint8_t  SCLC                 :1;
            __IO   uint8_t  SDAC                 :1;
            __IO   uint8_t  SCLS                 :1;
            __IO   uint8_t  SDAS                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
    };
} stc_mfs_scstr1_field_t;

typedef struct stc_mfs_scstr32_field
{
    union {
        struct {
            __IO  uint16_t  CSDS                 :16;
        };
        struct {
            __IO  uint16_t  CSDS0                :1;
            __IO  uint16_t  CSDS1                :1;
            __IO  uint16_t  CSDS2                :1;
            __IO  uint16_t  CSDS3                :1;
            __IO  uint16_t  CSDS4                :1;
            __IO  uint16_t  CSDS5                :1;
            __IO  uint16_t  CSDS6                :1;
            __IO  uint16_t  CSDS7                :1;
            __IO  uint16_t  CSDS8                :1;
            __IO  uint16_t  CSDS9                :1;
            __IO  uint16_t  CSDS10               :1;
            __IO  uint16_t  CSDS11               :1;
            __IO  uint16_t  CSDS12               :1;
            __IO  uint16_t  CSDS13               :1;
            __IO  uint16_t  CSDS14               :1;
            __IO  uint16_t  CSDS15               :1;
        };
    };
} stc_mfs_scstr32_field_t;

typedef struct stc_mfs_sacsr_field
{
    union {
        struct {
            __IO  uint16_t  TMRE                 :1;
            __IO  uint16_t  TDIV                 :4;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  TSYNE                :1;
            __IO  uint16_t  TINTE                :1;
            __IO  uint16_t  TINT                 :1;
            __IO  uint16_t  RESERVED2            :2;
            __IO  uint16_t  CSE                  :1;
            __IO  uint16_t  CSEIE                :1;
            __IO  uint16_t  TBEEN                :1;
            __IO  uint16_t  RESERVED3            :2;
        };
        struct {
            __IO  uint16_t  RESERVED0            :1;
            __IO  uint16_t  TDIV0                :1;
            __IO  uint16_t  TDIV1                :1;
            __IO  uint16_t  TDIV2                :1;
            __IO  uint16_t  TDIV3                :1;
            __IO  uint16_t  RESERVED4            :11;
        };
    };
} stc_mfs_sacsr_field_t;

typedef struct stc_mfs_stmr_field
{
    union {
        struct {
            __IO  uint16_t  TM                   :16;
        };
        struct {
            __IO  uint16_t  TM0                  :1;
            __IO  uint16_t  TM1                  :1;
            __IO  uint16_t  TM2                  :1;
            __IO  uint16_t  TM3                  :1;
            __IO  uint16_t  TM4                  :1;
            __IO  uint16_t  TM5                  :1;
            __IO  uint16_t  TM6                  :1;
            __IO  uint16_t  TM7                  :1;
            __IO  uint16_t  TM8                  :1;
            __IO  uint16_t  TM9                  :1;
            __IO  uint16_t  TM10                 :1;
            __IO  uint16_t  TM11                 :1;
            __IO  uint16_t  TM12                 :1;
            __IO  uint16_t  TM13                 :1;
            __IO  uint16_t  TM14                 :1;
            __IO  uint16_t  TM15                 :1;
        };
    };
} stc_mfs_stmr_field_t;

typedef struct stc_mfs_stmcr_field
{
    union {
        struct {
            __IO  uint16_t  TC                   :16;
        };
        struct {
            __IO  uint16_t  TC0                  :1;
            __IO  uint16_t  TC1                  :1;
            __IO  uint16_t  TC2                  :1;
            __IO  uint16_t  TC3                  :1;
            __IO  uint16_t  TC4                  :1;
            __IO  uint16_t  TC5                  :1;
            __IO  uint16_t  TC6                  :1;
            __IO  uint16_t  TC7                  :1;
            __IO  uint16_t  TC8                  :1;
            __IO  uint16_t  TC9                  :1;
            __IO  uint16_t  TC10                 :1;
            __IO  uint16_t  TC11                 :1;
            __IO  uint16_t  TC12                 :1;
            __IO  uint16_t  TC13                 :1;
            __IO  uint16_t  TC14                 :1;
            __IO  uint16_t  TC15                 :1;
        };
    };
} stc_mfs_stmcr_field_t;

typedef struct stc_mfs_scscr_field
{
    union {
        struct {
            __IO  uint16_t  CSOE                 :1;
            __IO  uint16_t  CSEN0                :1;
            __IO  uint16_t  CSEN1                :1;
            __IO  uint16_t  CSEN2                :1;
            __IO  uint16_t  CSEN3                :1;
            __IO  uint16_t  CSLVL                :1;
            __IO  uint16_t  CDIV                 :3;
            __IO  uint16_t  SCAM                 :1;
            __IO  uint16_t  SCD                  :2;
            __IO  uint16_t  SED                  :2;
            __IO  uint16_t  SST                  :2;
        };
        struct {
            __IO  uint16_t  RESERVED0            :6;
            __IO  uint16_t  CDIV0                :1;
            __IO  uint16_t  CDIV1                :1;
            __IO  uint16_t  CDIV2                :1;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  SCD0                 :1;
            __IO  uint16_t  SCD1                 :1;
            __IO  uint16_t  SED0                 :1;
            __IO  uint16_t  SED1                 :1;
            __IO  uint16_t  SST0                 :1;
            __IO  uint16_t  SST1                 :1;
        };
    };
} stc_mfs_scscr_field_t;

typedef struct stc_mfs_scsfr0_field
{
    union {
        struct {
            __IO   uint8_t  CS1L                 :5;
            __IO   uint8_t  CS1SPI               :1;
            __IO   uint8_t  CS1SCINV             :1;
            __IO   uint8_t  CS1CSLVL             :1;
        };
        struct {
            __IO   uint8_t  CS1L0                :1;
            __IO   uint8_t  CS1L1                :1;
            __IO   uint8_t  CS1L2                :1;
            __IO   uint8_t  CS1L3                :1;
            __IO   uint8_t  CS1L4                :1;
            __IO   uint8_t  RESERVED0            :3;
        };
    };
} stc_mfs_scsfr0_field_t;

typedef struct stc_mfs_scsfr1_field
{
    union {
        struct {
            __IO   uint8_t  CS2L                 :5;
            __IO   uint8_t  CS2SPI               :1;
            __IO   uint8_t  CS2SCINV             :1;
            __IO   uint8_t  CS2CSLVL             :1;
        };
        struct {
            __IO   uint8_t  CS2L0                :1;
            __IO   uint8_t  CS2L1                :1;
            __IO   uint8_t  CS2L2                :1;
            __IO   uint8_t  CS2L3                :1;
            __IO   uint8_t  CS2L4                :1;
            __IO   uint8_t  RESERVED0            :3;
        };
    };
} stc_mfs_scsfr1_field_t;

typedef struct stc_mfs_scsfr2_field
{
    union {
        struct {
            __IO   uint8_t  CS3L                 :5;
            __IO   uint8_t  CS3SPI               :1;
            __IO   uint8_t  CS3SCINV             :1;
            __IO   uint8_t  CS3CSLVL             :1;
        };
        struct {
            __IO   uint8_t  CS3L0                :1;
            __IO   uint8_t  CS3L1                :1;
            __IO   uint8_t  CS3L2                :1;
            __IO   uint8_t  CS3L3                :1;
            __IO   uint8_t  CS3L4                :1;
            __IO   uint8_t  RESERVED0            :3;
        };
    };
} stc_mfs_scsfr2_field_t;

typedef struct stc_mfs_csio_smr_field
{
    union {
        struct {
            __IO   uint8_t  SOE                  :1;
            __IO   uint8_t  SCKE                 :1;
            __IO   uint8_t  BDS                  :1;
            __IO   uint8_t  SCINV                :1;
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  MD                   :3;
        };
        struct {
            __IO   uint8_t  RESERVED1            :5;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  MD2                  :1;
        };
    };
} stc_mfs_csio_smr_field_t;

typedef struct stc_mfs_i2c_smr_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED2            :2;
            __IO   uint8_t  TIE                  :1;
            __IO   uint8_t  RIE                  :1;
            __IO   uint8_t  RESERVED3            :1;
            __IO   uint8_t  MD                   :3;
        };
        struct {
            __IO   uint8_t  RESERVED4            :5;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  MD2                  :1;
        };
    };
} stc_mfs_i2c_smr_field_t;

typedef struct stc_mfs_i2s_smr_field
{
    union {
        struct {
            __IO   uint8_t  SOE                  :1;
            __IO   uint8_t  RESERVED5            :1;
            __IO   uint8_t  BDS                  :1;
            __IO   uint8_t  RESERVED6            :2;
            __IO   uint8_t  MD                   :3;
        };
        struct {
            __IO   uint8_t  RESERVED7            :5;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  MD2                  :1;
        };
    };
} stc_mfs_i2s_smr_field_t;

typedef struct stc_mfs_lin_smr_field
{
    union {
        struct {
            __IO   uint8_t  SOE                  :1;
            __IO   uint8_t  RESERVED8            :2;
            __IO   uint8_t  SBL                  :1;
            __IO   uint8_t  WUCR                 :1;
            __IO   uint8_t  MD                   :3;
        };
        struct {
            __IO   uint8_t  RESERVED9            :5;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  MD2                  :1;
        };
    };
} stc_mfs_lin_smr_field_t;

typedef struct stc_mfs_uart_smr_field
{
    union {
        struct {
            __IO   uint8_t  SOE                  :1;
            __IO   uint8_t  RESERVED10           :1;
            __IO   uint8_t  BDS                  :1;
            __IO   uint8_t  SBL                  :1;
            __IO   uint8_t  RESERVED11           :1;
            __IO   uint8_t  MD                   :3;
        };
        struct {
            __IO   uint8_t  RESERVED12           :5;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  MD2                  :1;
        };
    };
} stc_mfs_uart_smr_field_t;

typedef struct stc_mfs_csio_scr_field
{
        __IO   uint8_t  TXE                      :1;
        __IO   uint8_t  RXE                      :1;
        __IO   uint8_t  TBIE                     :1;
        __IO   uint8_t  TIE                      :1;
        __IO   uint8_t  RIE                      :1;
        __IO   uint8_t  SPI                      :1;
        __IO   uint8_t  MS                       :1;
        __IO   uint8_t  UPCL                     :1;
} stc_mfs_csio_scr_field_t;

typedef struct stc_mfs_i2c_ibcr_field
{
        __IO   uint8_t  INT                      :1;
        __IO   uint8_t  BER                      :1;
        __IO   uint8_t  INTE                     :1;
        __IO   uint8_t  CNDE                     :1;
        __IO   uint8_t  WSEL                     :1;
        __IO   uint8_t  ACKE                     :1;
        __IO   uint8_t  ACT_SCC                  :1;
        __IO   uint8_t  MSS                      :1;
} stc_mfs_i2c_ibcr_field_t;

typedef struct stc_mfs_i2s_scr_field
{
        __IO   uint8_t  TXE                      :1;
        __IO   uint8_t  RXE                      :1;
        __IO   uint8_t  RESERVED2                :2;
        __IO   uint8_t  RIE                      :1;
        __IO   uint8_t  RESERVED3                :1;
        __IO   uint8_t  MS                       :1;
        __IO   uint8_t  UPCL                     :1;
} stc_mfs_i2s_scr_field_t;

typedef struct stc_mfs_lin_scr_field
{
        __IO   uint8_t  TXE                      :1;
        __IO   uint8_t  RXE                      :1;
        __IO   uint8_t  TBIE                     :1;
        __IO   uint8_t  TIE                      :1;
        __IO   uint8_t  RIE                      :1;
        __IO   uint8_t  LBR                      :1;
        __IO   uint8_t  MS                       :1;
        __IO   uint8_t  UPCL                     :1;
} stc_mfs_lin_scr_field_t;

typedef struct stc_mfs_uart_scr_field
{
        __IO   uint8_t  TXE                      :1;
        __IO   uint8_t  RXE                      :1;
        __IO   uint8_t  TBIE                     :1;
        __IO   uint8_t  TIE                      :1;
        __IO   uint8_t  RIE                      :1;
        __IO   uint8_t  RESERVED6                :2;
        __IO   uint8_t  UPCL                     :1;
} stc_mfs_uart_scr_field_t;

typedef struct stc_mfs_csio_escr_field
{
    union {
        struct {
            __IO   uint8_t  L                    :3;
            __IO   uint8_t  WT                   :2;
            __IO   uint8_t  CSFE                 :1;
            __IO   uint8_t  L3                   :1;
            __IO   uint8_t  SOP                  :1;
        };
        struct {
            __IO   uint8_t  L0                   :1;
            __IO   uint8_t  L1                   :1;
            __IO   uint8_t  L2                   :1;
            __IO   uint8_t  WT0                  :1;
            __IO   uint8_t  WT1                  :1;
            __IO   uint8_t  RESERVED0            :3;
        };
    };
} stc_mfs_csio_escr_field_t;

typedef struct stc_mfs_i2c_ibsr_field
{
        __IO   uint8_t  BB                       :1;
        __IO   uint8_t  SPC                      :1;
        __IO   uint8_t  RSC                      :1;
        __IO   uint8_t  AL                       :1;
        __IO   uint8_t  TRX                      :1;
        __IO   uint8_t  RSA                      :1;
        __IO   uint8_t  RACK                     :1;
        __IO   uint8_t  FBT                      :1;
} stc_mfs_i2c_ibsr_field_t;

typedef struct stc_mfs_i2s_escr_field
{
    union {
        struct {
            __IO   uint8_t  L                    :3;
            __IO   uint8_t  RESERVED2            :3;
            __IO   uint8_t  L3                   :1;
            __IO   uint8_t  SOP                  :1;
        };
        struct {
            __IO   uint8_t  L0                   :1;
            __IO   uint8_t  L1                   :1;
            __IO   uint8_t  L2                   :1;
            __IO   uint8_t  RESERVED3            :5;
        };
    };
} stc_mfs_i2s_escr_field_t;

typedef struct stc_mfs_lin_escr_field
{
    union {
        struct {
            __IO   uint8_t  DEL                  :2;
            __IO   uint8_t  LBL                  :2;
            __IO   uint8_t  LBIE                 :1;
            __IO   uint8_t  RESERVED4            :1;
            __IO   uint8_t  ESBL                 :1;
            __IO   uint8_t  RESERVED5            :1;
        };
        struct {
            __IO   uint8_t  DEL0                 :1;
            __IO   uint8_t  DEL1                 :1;
            __IO   uint8_t  LBL0                 :1;
            __IO   uint8_t  LBL1                 :1;
            __IO   uint8_t  RESERVED6            :4;
        };
    };
} stc_mfs_lin_escr_field_t;

typedef struct stc_mfs_uart_escr_field
{
    union {
        struct {
            __IO   uint8_t  L                    :3;
            __IO   uint8_t  P                    :1;
            __IO   uint8_t  PEN                  :1;
            __IO   uint8_t  INV                  :1;
            __IO   uint8_t  ESBL                 :1;
            __IO   uint8_t  FLWEN                :1;
        };
        struct {
            __IO   uint8_t  L0                   :1;
            __IO   uint8_t  L1                   :1;
            __IO   uint8_t  L2                   :1;
            __IO   uint8_t  RESERVED7            :5;
        };
    };
} stc_mfs_uart_escr_field_t;

typedef struct stc_mfs_csio_ssr_field
{
        __IO   uint8_t  TBI                      :1;
        __IO   uint8_t  TDRE                     :1;
        __IO   uint8_t  RDRF                     :1;
        __IO   uint8_t  ORE                      :1;
        __IO   uint8_t  AWC                      :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  REC                      :1;
} stc_mfs_csio_ssr_field_t;

typedef struct stc_mfs_i2c_ssr_field
{
        __IO   uint8_t  TBI                      :1;
        __IO   uint8_t  TDRE                     :1;
        __IO   uint8_t  RDRF                     :1;
        __IO   uint8_t  ORE                      :1;
        __IO   uint8_t  TBIE                     :1;
        __IO   uint8_t  DMA                      :1;
        __IO   uint8_t  TSET                     :1;
        __IO   uint8_t  REC                      :1;
} stc_mfs_i2c_ssr_field_t;

typedef struct stc_mfs_i2s_ssr_field
{
        __IO   uint8_t  RESERVED3                :1;
        __IO   uint8_t  TDRE                     :1;
        __IO   uint8_t  RDRF                     :1;
        __IO   uint8_t  ORE                      :1;
        __IO   uint8_t  AWC                      :1;
        __IO   uint8_t  RESERVED4                :2;
        __IO   uint8_t  REC                      :1;
} stc_mfs_i2s_ssr_field_t;

typedef struct stc_mfs_lin_ssr_field
{
        __IO   uint8_t  TBI                      :1;
        __IO   uint8_t  TDRE                     :1;
        __IO   uint8_t  RDRF                     :1;
        __IO   uint8_t  ORE                      :1;
        __IO   uint8_t  FRE                      :1;
        __IO   uint8_t  LBD                      :1;
        __IO   uint8_t  RESERVED6                :1;
        __IO   uint8_t  REC                      :1;
} stc_mfs_lin_ssr_field_t;

typedef struct stc_mfs_uart_ssr_field
{
        __IO   uint8_t  TBI                      :1;
        __IO   uint8_t  TDRE                     :1;
        __IO   uint8_t  RDRF                     :1;
        __IO   uint8_t  ORE                      :1;
        __IO   uint8_t  FRE                      :1;
        __IO   uint8_t  PE                       :1;
        __IO   uint8_t  RESERVED8                :1;
        __IO   uint8_t  REC                      :1;
} stc_mfs_uart_ssr_field_t;

typedef struct stc_mfs_csio_rdr_field
{
    union {
        struct {
            __IO  uint16_t  D                    :16;
        };
        struct {
            __IO  uint16_t  D0                   :1;
            __IO  uint16_t  D1                   :1;
            __IO  uint16_t  D2                   :1;
            __IO  uint16_t  D3                   :1;
            __IO  uint16_t  D4                   :1;
            __IO  uint16_t  D5                   :1;
            __IO  uint16_t  D6                   :1;
            __IO  uint16_t  D7                   :1;
            __IO  uint16_t  D8                   :1;
            __IO  uint16_t  D9                   :1;
            __IO  uint16_t  D10                  :1;
            __IO  uint16_t  D11                  :1;
            __IO  uint16_t  D12                  :1;
            __IO  uint16_t  D13                  :1;
            __IO  uint16_t  D14                  :1;
            __IO  uint16_t  D15                  :1;
        };
    };
} stc_mfs_csio_rdr_field_t;

typedef struct stc_mfs_csio_tdr_field
{
    union {
        struct {
            __IO  uint16_t  D                    :16;
        };
        struct {
            __IO  uint16_t  D0                   :1;
            __IO  uint16_t  D1                   :1;
            __IO  uint16_t  D2                   :1;
            __IO  uint16_t  D3                   :1;
            __IO  uint16_t  D4                   :1;
            __IO  uint16_t  D5                   :1;
            __IO  uint16_t  D6                   :1;
            __IO  uint16_t  D7                   :1;
            __IO  uint16_t  D8                   :1;
            __IO  uint16_t  D9                   :1;
            __IO  uint16_t  D10                  :1;
            __IO  uint16_t  D11                  :1;
            __IO  uint16_t  D12                  :1;
            __IO  uint16_t  D13                  :1;
            __IO  uint16_t  D14                  :1;
            __IO  uint16_t  D15                  :1;
        };
    };
} stc_mfs_csio_tdr_field_t;

typedef struct stc_mfs_i2c_rdr_field
{
    union {
        struct {
            __IO  uint16_t  D                    :8;
            __IO  uint16_t  RESERVED0            :8;
        };
        struct {
            __IO  uint16_t  D0                   :1;
            __IO  uint16_t  D1                   :1;
            __IO  uint16_t  D2                   :1;
            __IO  uint16_t  D3                   :1;
            __IO  uint16_t  D4                   :1;
            __IO  uint16_t  D5                   :1;
            __IO  uint16_t  D6                   :1;
            __IO  uint16_t  D7                   :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_mfs_i2c_rdr_field_t;

typedef struct stc_mfs_i2c_tdr_field
{
    union {
        struct {
            __IO  uint16_t  D                    :8;
            __IO  uint16_t  RESERVED2            :8;
        };
        struct {
            __IO  uint16_t  D0                   :1;
            __IO  uint16_t  D1                   :1;
            __IO  uint16_t  D2                   :1;
            __IO  uint16_t  D3                   :1;
            __IO  uint16_t  D4                   :1;
            __IO  uint16_t  D5                   :1;
            __IO  uint16_t  D6                   :1;
            __IO  uint16_t  D7                   :1;
            __IO  uint16_t  RESERVED3            :8;
        };
    };
} stc_mfs_i2c_tdr_field_t;

typedef struct stc_mfs_lin_rdr_field
{
    union {
        struct {
            __IO  uint16_t  D                    :8;
            __IO  uint16_t  RESERVED4            :8;
        };
        struct {
            __IO  uint16_t  D0                   :1;
            __IO  uint16_t  D1                   :1;
            __IO  uint16_t  D2                   :1;
            __IO  uint16_t  D3                   :1;
            __IO  uint16_t  D4                   :1;
            __IO  uint16_t  D5                   :1;
            __IO  uint16_t  D6                   :1;
            __IO  uint16_t  D7                   :1;
            __IO  uint16_t  RESERVED5            :8;
        };
    };
} stc_mfs_lin_rdr_field_t;

typedef struct stc_mfs_lin_tdr_field
{
    union {
        struct {
            __IO  uint16_t  D                    :8;
            __IO  uint16_t  RESERVED6            :8;
        };
        struct {
            __IO  uint16_t  D0                   :1;
            __IO  uint16_t  D1                   :1;
            __IO  uint16_t  D2                   :1;
            __IO  uint16_t  D3                   :1;
            __IO  uint16_t  D4                   :1;
            __IO  uint16_t  D5                   :1;
            __IO  uint16_t  D6                   :1;
            __IO  uint16_t  D7                   :1;
            __IO  uint16_t  RESERVED7            :8;
        };
    };
} stc_mfs_lin_tdr_field_t;

typedef struct stc_mfs_uart_rdr_field
{
    union {
        struct {
            __IO  uint16_t  D                    :9;
            __IO  uint16_t  RESERVED8            :7;
        };
        struct {
            __IO  uint16_t  D0                   :1;
            __IO  uint16_t  D1                   :1;
            __IO  uint16_t  D2                   :1;
            __IO  uint16_t  D3                   :1;
            __IO  uint16_t  D4                   :1;
            __IO  uint16_t  D5                   :1;
            __IO  uint16_t  D6                   :1;
            __IO  uint16_t  D7                   :1;
            __IO  uint16_t  D8                   :1;
            __IO  uint16_t  RESERVED9            :7;
        };
    };
} stc_mfs_uart_rdr_field_t;

typedef struct stc_mfs_uart_tdr_field
{
    union {
        struct {
            __IO  uint16_t  D                    :9;
            __IO  uint16_t  RESERVED10           :7;
        };
        struct {
            __IO  uint16_t  D0                   :1;
            __IO  uint16_t  D1                   :1;
            __IO  uint16_t  D2                   :1;
            __IO  uint16_t  D3                   :1;
            __IO  uint16_t  D4                   :1;
            __IO  uint16_t  D5                   :1;
            __IO  uint16_t  D6                   :1;
            __IO  uint16_t  D7                   :1;
            __IO  uint16_t  D8                   :1;
            __IO  uint16_t  RESERVED11           :7;
        };
    };
} stc_mfs_uart_tdr_field_t;

typedef struct stc_mfs_csio_bgr_field
{
    union {
        struct {
            __IO  uint16_t  BGR                  :15;
            __IO  uint16_t  RESERVED0            :1;
        };
        struct {
            __IO  uint16_t  BGR0                 :1;
            __IO  uint16_t  BGR1                 :1;
            __IO  uint16_t  BGR2                 :1;
            __IO  uint16_t  BGR3                 :1;
            __IO  uint16_t  BGR4                 :1;
            __IO  uint16_t  BGR5                 :1;
            __IO  uint16_t  BGR6                 :1;
            __IO  uint16_t  BGR7                 :1;
            __IO  uint16_t  BGR8                 :1;
            __IO  uint16_t  BGR9                 :1;
            __IO  uint16_t  BGR10                :1;
            __IO  uint16_t  BGR11                :1;
            __IO  uint16_t  BGR12                :1;
            __IO  uint16_t  BGR13                :1;
            __IO  uint16_t  BGR14                :1;
            __IO  uint16_t  RESERVED1            :1;
        };
    };
} stc_mfs_csio_bgr_field_t;

typedef struct stc_mfs_i2c_bgr_field
{
    union {
        struct {
            __IO  uint16_t  BGR                  :15;
            __IO  uint16_t  RESERVED2            :1;
        };
        struct {
            __IO  uint16_t  BGR0                 :1;
            __IO  uint16_t  BGR1                 :1;
            __IO  uint16_t  BGR2                 :1;
            __IO  uint16_t  BGR3                 :1;
            __IO  uint16_t  BGR4                 :1;
            __IO  uint16_t  BGR5                 :1;
            __IO  uint16_t  BGR6                 :1;
            __IO  uint16_t  BGR7                 :1;
            __IO  uint16_t  BGR8                 :1;
            __IO  uint16_t  BGR9                 :1;
            __IO  uint16_t  BGR10                :1;
            __IO  uint16_t  BGR11                :1;
            __IO  uint16_t  BGR12                :1;
            __IO  uint16_t  BGR13                :1;
            __IO  uint16_t  BGR14                :1;
            __IO  uint16_t  RESERVED3            :1;
        };
    };
} stc_mfs_i2c_bgr_field_t;

typedef struct stc_mfs_lin_bgr_field
{
    union {
        struct {
            __IO  uint16_t  BGR                  :15;
            __IO  uint16_t  EXT                  :1;
        };
        struct {
            __IO  uint16_t  BGR0                 :1;
            __IO  uint16_t  BGR1                 :1;
            __IO  uint16_t  BGR2                 :1;
            __IO  uint16_t  BGR3                 :1;
            __IO  uint16_t  BGR4                 :1;
            __IO  uint16_t  BGR5                 :1;
            __IO  uint16_t  BGR6                 :1;
            __IO  uint16_t  BGR7                 :1;
            __IO  uint16_t  BGR8                 :1;
            __IO  uint16_t  BGR9                 :1;
            __IO  uint16_t  BGR10                :1;
            __IO  uint16_t  BGR11                :1;
            __IO  uint16_t  BGR12                :1;
            __IO  uint16_t  BGR13                :1;
            __IO  uint16_t  BGR14                :1;
            __IO  uint16_t  RESERVED4            :1;
        };
    };
} stc_mfs_lin_bgr_field_t;

typedef struct stc_mfs_uart_bgr_field
{
    union {
        struct {
            __IO  uint16_t  BGR                  :15;
            __IO  uint16_t  EXT                  :1;
        };
        struct {
            __IO  uint16_t  BGR0                 :1;
            __IO  uint16_t  BGR1                 :1;
            __IO  uint16_t  BGR2                 :1;
            __IO  uint16_t  BGR3                 :1;
            __IO  uint16_t  BGR4                 :1;
            __IO  uint16_t  BGR5                 :1;
            __IO  uint16_t  BGR6                 :1;
            __IO  uint16_t  BGR7                 :1;
            __IO  uint16_t  BGR8                 :1;
            __IO  uint16_t  BGR9                 :1;
            __IO  uint16_t  BGR10                :1;
            __IO  uint16_t  BGR11                :1;
            __IO  uint16_t  BGR12                :1;
            __IO  uint16_t  BGR13                :1;
            __IO  uint16_t  BGR14                :1;
            __IO  uint16_t  RESERVED5            :1;
        };
    };
} stc_mfs_uart_bgr_field_t;

typedef struct stc_mfs_i2c_isba_field
{
    union {
        struct {
            __IO   uint8_t  SA                   :7;
            __IO   uint8_t  SAEN                 :1;
        };
        struct {
            __IO   uint8_t  SA0                  :1;
            __IO   uint8_t  SA1                  :1;
            __IO   uint8_t  SA2                  :1;
            __IO   uint8_t  SA3                  :1;
            __IO   uint8_t  SA4                  :1;
            __IO   uint8_t  SA5                  :1;
            __IO   uint8_t  SA6                  :1;
            __IO   uint8_t  RESERVED0            :1;
        };
    };
} stc_mfs_i2c_isba_field_t;

typedef struct stc_mfs_i2c_ismk_field
{
    union {
        struct {
            __IO   uint8_t  SM                   :7;
            __IO   uint8_t  EN                   :1;
        };
        struct {
            __IO   uint8_t  SM0                  :1;
            __IO   uint8_t  SM1                  :1;
            __IO   uint8_t  SM2                  :1;
            __IO   uint8_t  SM3                  :1;
            __IO   uint8_t  SM4                  :1;
            __IO   uint8_t  SM5                  :1;
            __IO   uint8_t  SM6                  :1;
            __IO   uint8_t  RESERVED0            :1;
        };
    };
} stc_mfs_i2c_ismk_field_t;

typedef struct stc_mfs_csio_fcr_field
{
        __IO  uint16_t  FE1                      :1;
        __IO  uint16_t  FE2                      :1;
        __IO  uint16_t  FCL1                     :1;
        __IO  uint16_t  FCL2                     :1;
        __IO  uint16_t  FSET                     :1;
        __IO  uint16_t  FLD                      :1;
        __IO  uint16_t  FLST                     :1;
        __IO  uint16_t  RESERVED0                :1;
        __IO  uint16_t  FSEL                     :1;
        __IO  uint16_t  FTIE                     :1;
        __IO  uint16_t  FDRQ                     :1;
        __IO  uint16_t  FRIIE                    :1;
        __IO  uint16_t  FLSTE                    :1;
        __IO  uint16_t  RESERVED1                :3;
} stc_mfs_csio_fcr_field_t;

typedef struct stc_mfs_i2c_fcr_field
{
        __IO  uint16_t  FE1                      :1;
        __IO  uint16_t  FE2                      :1;
        __IO  uint16_t  FCL1                     :1;
        __IO  uint16_t  FCL2                     :1;
        __IO  uint16_t  FSET                     :1;
        __IO  uint16_t  FLD                      :1;
        __IO  uint16_t  FLST                     :1;
        __IO  uint16_t  RESERVED3                :1;
        __IO  uint16_t  FSEL                     :1;
        __IO  uint16_t  FTIE                     :1;
        __IO  uint16_t  FDRQ                     :1;
        __IO  uint16_t  FRIIE                    :1;
        __IO  uint16_t  FLSTE                    :1;
        __IO  uint16_t  RESERVED4                :3;
} stc_mfs_i2c_fcr_field_t;

typedef struct stc_mfs_i2s_fcr_field
{
        __IO  uint16_t  FE1                      :1;
        __IO  uint16_t  FE2                      :1;
        __IO  uint16_t  FCL1                     :1;
        __IO  uint16_t  FCL2                     :1;
        __IO  uint16_t  RESERVED6                :4;
        __IO  uint16_t  FSEL                     :1;
        __IO  uint16_t  FTIE                     :1;
        __IO  uint16_t  FDRQ                     :1;
        __IO  uint16_t  RESERVED7                :5;
} stc_mfs_i2s_fcr_field_t;

typedef struct stc_mfs_lin_fcr_field
{
        __IO  uint16_t  FE1                      :1;
        __IO  uint16_t  FE2                      :1;
        __IO  uint16_t  FCL1                     :1;
        __IO  uint16_t  FCL2                     :1;
        __IO  uint16_t  FSET                     :1;
        __IO  uint16_t  FLD                      :1;
        __IO  uint16_t  FLST                     :1;
        __IO  uint16_t  RESERVED9                :1;
        __IO  uint16_t  FSEL                     :1;
        __IO  uint16_t  FTIE                     :1;
        __IO  uint16_t  FDRQ                     :1;
        __IO  uint16_t  FRIIE                    :1;
        __IO  uint16_t  FLSTE                    :1;
        __IO  uint16_t  RESERVED10               :3;
} stc_mfs_lin_fcr_field_t;

typedef struct stc_mfs_uart_fcr_field
{
        __IO  uint16_t  FE1                      :1;
        __IO  uint16_t  FE2                      :1;
        __IO  uint16_t  FCL1                     :1;
        __IO  uint16_t  FCL2                     :1;
        __IO  uint16_t  FSET                     :1;
        __IO  uint16_t  FLD                      :1;
        __IO  uint16_t  FLST                     :1;
        __IO  uint16_t  RESERVED12               :1;
        __IO  uint16_t  FSEL                     :1;
        __IO  uint16_t  FTIE                     :1;
        __IO  uint16_t  FDRQ                     :1;
        __IO  uint16_t  FRIIE                    :1;
        __IO  uint16_t  FLSTE                    :1;
        __IO  uint16_t  RESERVED13               :3;
} stc_mfs_uart_fcr_field_t;

typedef struct stc_mfs_csio_fbyte1_field
{
    union {
        struct {
            __IO   uint8_t  FD                   :8;
        };
        struct {
            __IO   uint8_t  FD0                  :1;
            __IO   uint8_t  FD1                  :1;
            __IO   uint8_t  FD2                  :1;
            __IO   uint8_t  FD3                  :1;
            __IO   uint8_t  FD4                  :1;
            __IO   uint8_t  FD5                  :1;
            __IO   uint8_t  FD6                  :1;
            __IO   uint8_t  FD7                  :1;
        };
    };
} stc_mfs_csio_fbyte1_field_t;

typedef struct stc_mfs_i2c_fbyte1_field
{
    union {
        struct {
            __IO   uint8_t  FD                   :8;
        };
        struct {
            __IO   uint8_t  FD0                  :1;
            __IO   uint8_t  FD1                  :1;
            __IO   uint8_t  FD2                  :1;
            __IO   uint8_t  FD3                  :1;
            __IO   uint8_t  FD4                  :1;
            __IO   uint8_t  FD5                  :1;
            __IO   uint8_t  FD6                  :1;
            __IO   uint8_t  FD7                  :1;
        };
    };
} stc_mfs_i2c_fbyte1_field_t;

typedef struct stc_mfs_i2s_fbyte1_field
{
    union {
        struct {
            __IO   uint8_t  FD                   :8;
        };
        struct {
            __IO   uint8_t  FD0                  :1;
            __IO   uint8_t  FD1                  :1;
            __IO   uint8_t  FD2                  :1;
            __IO   uint8_t  FD3                  :1;
            __IO   uint8_t  FD4                  :1;
            __IO   uint8_t  FD5                  :1;
            __IO   uint8_t  FD6                  :1;
            __IO   uint8_t  FD7                  :1;
        };
    };
} stc_mfs_i2s_fbyte1_field_t;

typedef struct stc_mfs_lin_fbyte1_field
{
    union {
        struct {
            __IO   uint8_t  FD                   :8;
        };
        struct {
            __IO   uint8_t  FD0                  :1;
            __IO   uint8_t  FD1                  :1;
            __IO   uint8_t  FD2                  :1;
            __IO   uint8_t  FD3                  :1;
            __IO   uint8_t  FD4                  :1;
            __IO   uint8_t  FD5                  :1;
            __IO   uint8_t  FD6                  :1;
            __IO   uint8_t  FD7                  :1;
        };
    };
} stc_mfs_lin_fbyte1_field_t;

typedef struct stc_mfs_uart_fbyte1_field
{
    union {
        struct {
            __IO   uint8_t  FD                   :8;
        };
        struct {
            __IO   uint8_t  FD0                  :1;
            __IO   uint8_t  FD1                  :1;
            __IO   uint8_t  FD2                  :1;
            __IO   uint8_t  FD3                  :1;
            __IO   uint8_t  FD4                  :1;
            __IO   uint8_t  FD5                  :1;
            __IO   uint8_t  FD6                  :1;
            __IO   uint8_t  FD7                  :1;
        };
    };
} stc_mfs_uart_fbyte1_field_t;

typedef struct stc_mfs_csio_fbyte2_field
{
    union {
        struct {
            __IO   uint8_t  FD                   :8;
        };
        struct {
            __IO   uint8_t  FD0                  :1;
            __IO   uint8_t  FD1                  :1;
            __IO   uint8_t  FD2                  :1;
            __IO   uint8_t  FD3                  :1;
            __IO   uint8_t  FD4                  :1;
            __IO   uint8_t  FD5                  :1;
            __IO   uint8_t  FD6                  :1;
            __IO   uint8_t  FD7                  :1;
        };
    };
} stc_mfs_csio_fbyte2_field_t;

typedef struct stc_mfs_i2c_fbyte2_field
{
    union {
        struct {
            __IO   uint8_t  FD                   :8;
        };
        struct {
            __IO   uint8_t  FD0                  :1;
            __IO   uint8_t  FD1                  :1;
            __IO   uint8_t  FD2                  :1;
            __IO   uint8_t  FD3                  :1;
            __IO   uint8_t  FD4                  :1;
            __IO   uint8_t  FD5                  :1;
            __IO   uint8_t  FD6                  :1;
            __IO   uint8_t  FD7                  :1;
        };
    };
} stc_mfs_i2c_fbyte2_field_t;

typedef struct stc_mfs_i2s_fbyte2_field
{
    union {
        struct {
            __IO   uint8_t  FD                   :8;
        };
        struct {
            __IO   uint8_t  FD0                  :1;
            __IO   uint8_t  FD1                  :1;
            __IO   uint8_t  FD2                  :1;
            __IO   uint8_t  FD3                  :1;
            __IO   uint8_t  FD4                  :1;
            __IO   uint8_t  FD5                  :1;
            __IO   uint8_t  FD6                  :1;
            __IO   uint8_t  FD7                  :1;
        };
    };
} stc_mfs_i2s_fbyte2_field_t;

typedef struct stc_mfs_lin_fbyte2_field
{
    union {
        struct {
            __IO   uint8_t  FD                   :8;
        };
        struct {
            __IO   uint8_t  FD0                  :1;
            __IO   uint8_t  FD1                  :1;
            __IO   uint8_t  FD2                  :1;
            __IO   uint8_t  FD3                  :1;
            __IO   uint8_t  FD4                  :1;
            __IO   uint8_t  FD5                  :1;
            __IO   uint8_t  FD6                  :1;
            __IO   uint8_t  FD7                  :1;
        };
    };
} stc_mfs_lin_fbyte2_field_t;

typedef struct stc_mfs_uart_fbyte2_field
{
    union {
        struct {
            __IO   uint8_t  FD                   :8;
        };
        struct {
            __IO   uint8_t  FD0                  :1;
            __IO   uint8_t  FD1                  :1;
            __IO   uint8_t  FD2                  :1;
            __IO   uint8_t  FD3                  :1;
            __IO   uint8_t  FD4                  :1;
            __IO   uint8_t  FD5                  :1;
            __IO   uint8_t  FD6                  :1;
            __IO   uint8_t  FD7                  :1;
        };
    };
} stc_mfs_uart_fbyte2_field_t;

typedef struct stc_mfs_csio_scstr0_field
{
    union {
        struct {
            __IO   uint8_t  CSHD                 :8;
        };
        struct {
            __IO   uint8_t  CSHD0                :1;
            __IO   uint8_t  CSHD1                :1;
            __IO   uint8_t  CSHD2                :1;
            __IO   uint8_t  CSHD3                :1;
            __IO   uint8_t  CSHD4                :1;
            __IO   uint8_t  CSHD5                :1;
            __IO   uint8_t  CSHD6                :1;
            __IO   uint8_t  CSHD7                :1;
        };
    };
} stc_mfs_csio_scstr0_field_t;

typedef struct stc_mfs_i2c_nfcr_field
{
    union {
        struct {
            __IO   uint8_t  NFT                  :5;
            __IO   uint8_t  RESERVED0            :3;
        };
        struct {
            __IO   uint8_t  NFT0                 :1;
            __IO   uint8_t  NFT1                 :1;
            __IO   uint8_t  NFT2                 :1;
            __IO   uint8_t  NFT3                 :1;
            __IO   uint8_t  NFT4                 :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mfs_i2c_nfcr_field_t;

typedef struct stc_mfs_csio_scstr1_field
{
    union {
        struct {
            __IO   uint8_t  CSSU                 :8;
        };
        struct {
            __IO   uint8_t  CSSU0                :1;
            __IO   uint8_t  CSSU1                :1;
            __IO   uint8_t  CSSU2                :1;
            __IO   uint8_t  CSSU3                :1;
            __IO   uint8_t  CSSU4                :1;
            __IO   uint8_t  CSSU5                :1;
            __IO   uint8_t  CSSU6                :1;
            __IO   uint8_t  CSSU7                :1;
        };
    };
} stc_mfs_csio_scstr1_field_t;

typedef struct stc_mfs_i2c_eibcr_field
{
        __IO   uint8_t  BEC                      :1;
        __IO   uint8_t  SOCE                     :1;
        __IO   uint8_t  SCLC                     :1;
        __IO   uint8_t  SDAC                     :1;
        __IO   uint8_t  SCLS                     :1;
        __IO   uint8_t  SDAS                     :1;
        __IO   uint8_t  RESERVED0                :2;
} stc_mfs_i2c_eibcr_field_t;

typedef struct stc_mfs_csio_scstr32_field
{
    union {
        struct {
            __IO  uint16_t  CSDS                 :16;
        };
        struct {
            __IO  uint16_t  CSDS0                :1;
            __IO  uint16_t  CSDS1                :1;
            __IO  uint16_t  CSDS2                :1;
            __IO  uint16_t  CSDS3                :1;
            __IO  uint16_t  CSDS4                :1;
            __IO  uint16_t  CSDS5                :1;
            __IO  uint16_t  CSDS6                :1;
            __IO  uint16_t  CSDS7                :1;
            __IO  uint16_t  CSDS8                :1;
            __IO  uint16_t  CSDS9                :1;
            __IO  uint16_t  CSDS10               :1;
            __IO  uint16_t  CSDS11               :1;
            __IO  uint16_t  CSDS12               :1;
            __IO  uint16_t  CSDS13               :1;
            __IO  uint16_t  CSDS14               :1;
            __IO  uint16_t  CSDS15               :1;
        };
    };
} stc_mfs_csio_scstr32_field_t;

typedef struct stc_mfs_csio_sacsr_field
{
    union {
        struct {
            __IO  uint16_t  TMRE                 :1;
            __IO  uint16_t  TDIV                 :4;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  TSYNE                :1;
            __IO  uint16_t  TINTE                :1;
            __IO  uint16_t  TINT                 :1;
            __IO  uint16_t  RESERVED2            :2;
            __IO  uint16_t  CSE                  :1;
            __IO  uint16_t  CSEIE                :1;
            __IO  uint16_t  TBEEN                :1;
            __IO  uint16_t  RESERVED3            :2;
        };
        struct {
            __IO  uint16_t  RESERVED0            :1;
            __IO  uint16_t  TDIV0                :1;
            __IO  uint16_t  TDIV1                :1;
            __IO  uint16_t  TDIV2                :1;
            __IO  uint16_t  TDIV3                :1;
            __IO  uint16_t  RESERVED4            :11;
        };
    };
} stc_mfs_csio_sacsr_field_t;

typedef struct stc_mfs_csio_stmr_field
{
    union {
        struct {
            __IO  uint16_t  TM                   :16;
        };
        struct {
            __IO  uint16_t  TM0                  :1;
            __IO  uint16_t  TM1                  :1;
            __IO  uint16_t  TM2                  :1;
            __IO  uint16_t  TM3                  :1;
            __IO  uint16_t  TM4                  :1;
            __IO  uint16_t  TM5                  :1;
            __IO  uint16_t  TM6                  :1;
            __IO  uint16_t  TM7                  :1;
            __IO  uint16_t  TM8                  :1;
            __IO  uint16_t  TM9                  :1;
            __IO  uint16_t  TM10                 :1;
            __IO  uint16_t  TM11                 :1;
            __IO  uint16_t  TM12                 :1;
            __IO  uint16_t  TM13                 :1;
            __IO  uint16_t  TM14                 :1;
            __IO  uint16_t  TM15                 :1;
        };
    };
} stc_mfs_csio_stmr_field_t;

typedef struct stc_mfs_csio_stmcr_field
{
    union {
        struct {
            __IO  uint16_t  TC                   :16;
        };
        struct {
            __IO  uint16_t  TC0                  :1;
            __IO  uint16_t  TC1                  :1;
            __IO  uint16_t  TC2                  :1;
            __IO  uint16_t  TC3                  :1;
            __IO  uint16_t  TC4                  :1;
            __IO  uint16_t  TC5                  :1;
            __IO  uint16_t  TC6                  :1;
            __IO  uint16_t  TC7                  :1;
            __IO  uint16_t  TC8                  :1;
            __IO  uint16_t  TC9                  :1;
            __IO  uint16_t  TC10                 :1;
            __IO  uint16_t  TC11                 :1;
            __IO  uint16_t  TC12                 :1;
            __IO  uint16_t  TC13                 :1;
            __IO  uint16_t  TC14                 :1;
            __IO  uint16_t  TC15                 :1;
        };
    };
} stc_mfs_csio_stmcr_field_t;

typedef struct stc_mfs_csio_scscr_field
{
    union {
        struct {
            __IO  uint16_t  CSOE                 :1;
            __IO  uint16_t  CSEN0                :1;
            __IO  uint16_t  CSEN1                :1;
            __IO  uint16_t  CSEN2                :1;
            __IO  uint16_t  CSEN3                :1;
            __IO  uint16_t  CSLVL                :1;
            __IO  uint16_t  CDIV                 :3;
            __IO  uint16_t  SCAM                 :1;
            __IO  uint16_t  SCD                  :2;
            __IO  uint16_t  SED                  :2;
            __IO  uint16_t  SST                  :2;
        };
        struct {
            __IO  uint16_t  RESERVED0            :6;
            __IO  uint16_t  CDIV0                :1;
            __IO  uint16_t  CDIV1                :1;
            __IO  uint16_t  CDIV2                :1;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  SCD0                 :1;
            __IO  uint16_t  SCD1                 :1;
            __IO  uint16_t  SED0                 :1;
            __IO  uint16_t  SED1                 :1;
            __IO  uint16_t  SST0                 :1;
            __IO  uint16_t  SST1                 :1;
        };
    };
} stc_mfs_csio_scscr_field_t;

typedef struct stc_mfs_csio_scsfr0_field
{
    union {
        struct {
            __IO   uint8_t  CS1L                 :5;
            __IO   uint8_t  CS1SPI               :1;
            __IO   uint8_t  CS1SCINV             :1;
            __IO   uint8_t  CS1CSLVL             :1;
        };
        struct {
            __IO   uint8_t  CS1L0                :1;
            __IO   uint8_t  CS1L1                :1;
            __IO   uint8_t  CS1L2                :1;
            __IO   uint8_t  CS1L3                :1;
            __IO   uint8_t  CS1L4                :1;
            __IO   uint8_t  RESERVED0            :3;
        };
    };
} stc_mfs_csio_scsfr0_field_t;

typedef struct stc_mfs_csio_scsfr1_field
{
    union {
        struct {
            __IO   uint8_t  CS2L                 :5;
            __IO   uint8_t  CS2SPI               :1;
            __IO   uint8_t  CS2SCINV             :1;
            __IO   uint8_t  CS2CSLVL             :1;
        };
        struct {
            __IO   uint8_t  CS2L0                :1;
            __IO   uint8_t  CS2L1                :1;
            __IO   uint8_t  CS2L2                :1;
            __IO   uint8_t  CS2L3                :1;
            __IO   uint8_t  CS2L4                :1;
            __IO   uint8_t  RESERVED0            :3;
        };
    };
} stc_mfs_csio_scsfr1_field_t;

typedef struct stc_mfs_csio_scsfr2_field
{
    union {
        struct {
            __IO   uint8_t  CS3L                 :5;
            __IO   uint8_t  CS3SPI               :1;
            __IO   uint8_t  CS3SCINV             :1;
            __IO   uint8_t  CS3CSLVL             :1;
        };
        struct {
            __IO   uint8_t  CS3L0                :1;
            __IO   uint8_t  CS3L1                :1;
            __IO   uint8_t  CS3L2                :1;
            __IO   uint8_t  CS3L3                :1;
            __IO   uint8_t  CS3L4                :1;
            __IO   uint8_t  RESERVED0            :3;
        };
    };
} stc_mfs_csio_scsfr2_field_t;

/******************************************************************************
 ** MFSI2S_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_mfsi2s_cntlreg_field
{
        __IO  uint16_t  FRAML                    :1;
        __IO  uint16_t  RESERVED0                :2;
        __IO  uint16_t  I2SMOD                   :1;
        __IO  uint16_t  FSPL                     :1;
        __IO  uint16_t  I2SEN                    :1;
        __IO  uint16_t  CKOE                     :1;
        __IO  uint16_t  RESERVED1                :1;
        __IO  uint16_t  MSKB                     :1;
        __IO  uint16_t  RESERVED2                :1;
        __IO  uint16_t  I2SRUN                   :1;
        __IO  uint16_t  RESERVED3                :5;
} stc_mfsi2s_cntlreg_field_t;

typedef struct stc_mfsi2s_i2sclk_field
{
    union {
        struct {
            __IO  uint16_t  I2SDIV               :8;
            __IO  uint16_t  RESERVED0            :6;
            __IO  uint16_t  MCKOE                :1;
            __IO  uint16_t  MCKIE                :1;
        };
        struct {
            __IO  uint16_t  I2SDIV0              :1;
            __IO  uint16_t  I2SDIV1              :1;
            __IO  uint16_t  I2SDIV2              :1;
            __IO  uint16_t  I2SDIV3              :1;
            __IO  uint16_t  I2SDIV4              :1;
            __IO  uint16_t  I2SDIV5              :1;
            __IO  uint16_t  I2SDIV6              :1;
            __IO  uint16_t  I2SDIV7              :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_mfsi2s_i2sclk_field_t;

typedef struct stc_mfsi2s_i2srst_field
{
    union {
        struct {
            __IO   uint8_t  I2SRST               :8;
        };
        struct {
            __IO   uint8_t  I2SRST0              :1;
            __IO   uint8_t  I2SRST1              :1;
            __IO   uint8_t  I2SRST2              :1;
            __IO   uint8_t  I2SRST3              :1;
            __IO   uint8_t  I2SRST4              :1;
            __IO   uint8_t  I2SRST5              :1;
            __IO   uint8_t  I2SRST6              :1;
            __IO   uint8_t  I2SRST7              :1;
        };
    };
} stc_mfsi2s_i2srst_field_t;

typedef struct stc_mfsi2s_i2sst_field
{
        __IO   uint8_t  CKSTP                    :1;
        __IO   uint8_t  BUSY                     :1;
        __IO   uint8_t  RESERVED0                :6;
} stc_mfsi2s_i2sst_field_t;

/******************************************************************************
 ** MFT_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_mft_ocsa10_field
{
        __IO   uint8_t  CST0                     :1;
        __IO   uint8_t  CST1                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  IOE0                     :1;
        __IO   uint8_t  IOE1                     :1;
        __IO   uint8_t  IOP0                     :1;
        __IO   uint8_t  IOP1                     :1;
} stc_mft_ocsa10_field_t;

typedef struct stc_mft_ocsb10_field
{
        __IO   uint8_t  OTD0                     :1;
        __IO   uint8_t  OTD1                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  CMOD                     :1;
        __IO   uint8_t  RESERVED1                :2;
        __IO   uint8_t  FM4                      :1;
} stc_mft_ocsb10_field_t;

typedef struct stc_mft_ocsd10_field
{
    union {
        struct {
            __IO  uint16_t  OCCP0BUFE            :2;
            __IO  uint16_t  OCCP1BUFE            :2;
            __IO  uint16_t  OCSE0BUFE            :2;
            __IO  uint16_t  OCSE1BUFE            :2;
            __IO  uint16_t  OPBM0                :1;
            __IO  uint16_t  OPBM1                :1;
            __IO  uint16_t  OEBM0                :1;
            __IO  uint16_t  OEBM1                :1;
            __IO  uint16_t  OFEX0                :1;
            __IO  uint16_t  OFEX1                :1;
            __IO  uint16_t  RESERVED0            :2;
        };
        struct {
            __IO  uint16_t  OCCP0BUFE0           :1;
            __IO  uint16_t  OCCP0BUFE1           :1;
            __IO  uint16_t  OCCP1BUFE0           :1;
            __IO  uint16_t  OCCP1BUFE1           :1;
            __IO  uint16_t  OCSE0BUFE0           :1;
            __IO  uint16_t  OCSE0BUFE1           :1;
            __IO  uint16_t  OCSE1BUFE0           :1;
            __IO  uint16_t  OCSE1BUFE1           :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_mft_ocsd10_field_t;

typedef struct stc_mft_ocsa32_field
{
        __IO   uint8_t  CST2                     :1;
        __IO   uint8_t  CST3                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  IOE2                     :1;
        __IO   uint8_t  IOE3                     :1;
        __IO   uint8_t  IOP2                     :1;
        __IO   uint8_t  IOP3                     :1;
} stc_mft_ocsa32_field_t;

typedef struct stc_mft_ocsb32_field
{
        __IO   uint8_t  OTD2                     :1;
        __IO   uint8_t  OTD3                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  CMOD                     :1;
        __IO   uint8_t  RESERVED1                :2;
        __IO   uint8_t  FM4                      :1;
} stc_mft_ocsb32_field_t;

typedef struct stc_mft_ocsd32_field
{
    union {
        struct {
            __IO  uint16_t  OCCP2BUFE            :2;
            __IO  uint16_t  OCCP3BUFE            :2;
            __IO  uint16_t  OCSE2BUFE            :2;
            __IO  uint16_t  OCSE3BUFE            :2;
            __IO  uint16_t  OPBM2                :1;
            __IO  uint16_t  OPBM3                :1;
            __IO  uint16_t  OEBM2                :1;
            __IO  uint16_t  OEBM3                :1;
            __IO  uint16_t  OFEX2                :1;
            __IO  uint16_t  OFEX3                :1;
            __IO  uint16_t  RESERVED0            :2;
        };
        struct {
            __IO  uint16_t  OCCP2BUFE0           :1;
            __IO  uint16_t  OCCP2BUFE1           :1;
            __IO  uint16_t  OCCP3BUFE0           :1;
            __IO  uint16_t  OCCP3BUFE1           :1;
            __IO  uint16_t  OCSE2BUFE0           :1;
            __IO  uint16_t  OCSE2BUFE1           :1;
            __IO  uint16_t  OCSE3BUFE0           :1;
            __IO  uint16_t  OCSE3BUFE1           :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_mft_ocsd32_field_t;

typedef struct stc_mft_ocsa54_field
{
        __IO   uint8_t  CST4                     :1;
        __IO   uint8_t  CST5                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  IOE4                     :1;
        __IO   uint8_t  IOE5                     :1;
        __IO   uint8_t  IOP4                     :1;
        __IO   uint8_t  IOP5                     :1;
} stc_mft_ocsa54_field_t;

typedef struct stc_mft_ocsb54_field
{
        __IO   uint8_t  OTD4                     :1;
        __IO   uint8_t  OTD5                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  CMOD                     :1;
        __IO   uint8_t  RESERVED1                :2;
        __IO   uint8_t  FM4                      :1;
} stc_mft_ocsb54_field_t;

typedef struct stc_mft_ocsd54_field
{
    union {
        struct {
            __IO  uint16_t  OCCP4BUFE            :2;
            __IO  uint16_t  OCCP5BUFE            :2;
            __IO  uint16_t  OCSE4BUFE            :2;
            __IO  uint16_t  OCSE5BUFE            :2;
            __IO  uint16_t  OPBM4                :1;
            __IO  uint16_t  OPBM5                :1;
            __IO  uint16_t  OEBM4                :1;
            __IO  uint16_t  OEBM5                :1;
            __IO  uint16_t  OFEX4                :1;
            __IO  uint16_t  OFEX5                :1;
            __IO  uint16_t  RESERVED0            :2;
        };
        struct {
            __IO  uint16_t  OCCP4BUFE0           :1;
            __IO  uint16_t  OCCP4BUFE1           :1;
            __IO  uint16_t  OCCP5BUFE0           :1;
            __IO  uint16_t  OCCP5BUFE1           :1;
            __IO  uint16_t  OCSE4BUFE0           :1;
            __IO  uint16_t  OCSE4BUFE1           :1;
            __IO  uint16_t  OCSE5BUFE0           :1;
            __IO  uint16_t  OCSE5BUFE1           :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_mft_ocsd54_field_t;

typedef struct stc_mft_ocsc_field
{
        __IO   uint8_t  MOD0                     :1;
        __IO   uint8_t  MOD1                     :1;
        __IO   uint8_t  MOD2                     :1;
        __IO   uint8_t  MOD3                     :1;
        __IO   uint8_t  MOD4                     :1;
        __IO   uint8_t  MOD5                     :1;
        __IO   uint8_t  RESERVED0                :2;
} stc_mft_ocsc_field_t;

typedef struct stc_mft_ocse0_field
{
    union {
        struct {
            __IO  uint16_t  OCSE                 :16;
        };
        struct {
            __IO  uint16_t  OCSE0                :1;
            __IO  uint16_t  OCSE1                :1;
            __IO  uint16_t  OCSE2                :1;
            __IO  uint16_t  OCSE3                :1;
            __IO  uint16_t  OCSE4                :1;
            __IO  uint16_t  OCSE5                :1;
            __IO  uint16_t  OCSE6                :1;
            __IO  uint16_t  OCSE7                :1;
            __IO  uint16_t  OCSE8                :1;
            __IO  uint16_t  OCSE9                :1;
            __IO  uint16_t  OCSE10               :1;
            __IO  uint16_t  OCSE11               :1;
            __IO  uint16_t  OCSE12               :1;
            __IO  uint16_t  OCSE13               :1;
            __IO  uint16_t  OCSE14               :1;
            __IO  uint16_t  OCSE15               :1;
        };
    };
} stc_mft_ocse0_field_t;

typedef struct stc_mft_ocse1_field
{
    union {
        struct {
            __IO  uint32_t  OCSE                 :32;
        };
        struct {
            __IO  uint32_t  OCSE0                :1;
            __IO  uint32_t  OCSE1                :1;
            __IO  uint32_t  OCSE2                :1;
            __IO  uint32_t  OCSE3                :1;
            __IO  uint32_t  OCSE4                :1;
            __IO  uint32_t  OCSE5                :1;
            __IO  uint32_t  OCSE6                :1;
            __IO  uint32_t  OCSE7                :1;
            __IO  uint32_t  OCSE8                :1;
            __IO  uint32_t  OCSE9                :1;
            __IO  uint32_t  OCSE10               :1;
            __IO  uint32_t  OCSE11               :1;
            __IO  uint32_t  OCSE12               :1;
            __IO  uint32_t  OCSE13               :1;
            __IO  uint32_t  OCSE14               :1;
            __IO  uint32_t  OCSE15               :1;
            __IO  uint32_t  OCSE16               :1;
            __IO  uint32_t  OCSE17               :1;
            __IO  uint32_t  OCSE18               :1;
            __IO  uint32_t  OCSE19               :1;
            __IO  uint32_t  OCSE20               :1;
            __IO  uint32_t  OCSE21               :1;
            __IO  uint32_t  OCSE22               :1;
            __IO  uint32_t  OCSE23               :1;
            __IO  uint32_t  OCSE24               :1;
            __IO  uint32_t  OCSE25               :1;
            __IO  uint32_t  OCSE26               :1;
            __IO  uint32_t  OCSE27               :1;
            __IO  uint32_t  OCSE28               :1;
            __IO  uint32_t  OCSE29               :1;
            __IO  uint32_t  OCSE30               :1;
            __IO  uint32_t  OCSE31               :1;
        };
    };
} stc_mft_ocse1_field_t;

typedef struct stc_mft_ocse2_field
{
    union {
        struct {
            __IO  uint16_t  OCSE                 :16;
        };
        struct {
            __IO  uint16_t  OCSE0                :1;
            __IO  uint16_t  OCSE1                :1;
            __IO  uint16_t  OCSE2                :1;
            __IO  uint16_t  OCSE3                :1;
            __IO  uint16_t  OCSE4                :1;
            __IO  uint16_t  OCSE5                :1;
            __IO  uint16_t  OCSE6                :1;
            __IO  uint16_t  OCSE7                :1;
            __IO  uint16_t  OCSE8                :1;
            __IO  uint16_t  OCSE9                :1;
            __IO  uint16_t  OCSE10               :1;
            __IO  uint16_t  OCSE11               :1;
            __IO  uint16_t  OCSE12               :1;
            __IO  uint16_t  OCSE13               :1;
            __IO  uint16_t  OCSE14               :1;
            __IO  uint16_t  OCSE15               :1;
        };
    };
} stc_mft_ocse2_field_t;

typedef struct stc_mft_ocse3_field
{
    union {
        struct {
            __IO  uint32_t  OCSE                 :32;
        };
        struct {
            __IO  uint32_t  OCSE0                :1;
            __IO  uint32_t  OCSE1                :1;
            __IO  uint32_t  OCSE2                :1;
            __IO  uint32_t  OCSE3                :1;
            __IO  uint32_t  OCSE4                :1;
            __IO  uint32_t  OCSE5                :1;
            __IO  uint32_t  OCSE6                :1;
            __IO  uint32_t  OCSE7                :1;
            __IO  uint32_t  OCSE8                :1;
            __IO  uint32_t  OCSE9                :1;
            __IO  uint32_t  OCSE10               :1;
            __IO  uint32_t  OCSE11               :1;
            __IO  uint32_t  OCSE12               :1;
            __IO  uint32_t  OCSE13               :1;
            __IO  uint32_t  OCSE14               :1;
            __IO  uint32_t  OCSE15               :1;
            __IO  uint32_t  OCSE16               :1;
            __IO  uint32_t  OCSE17               :1;
            __IO  uint32_t  OCSE18               :1;
            __IO  uint32_t  OCSE19               :1;
            __IO  uint32_t  OCSE20               :1;
            __IO  uint32_t  OCSE21               :1;
            __IO  uint32_t  OCSE22               :1;
            __IO  uint32_t  OCSE23               :1;
            __IO  uint32_t  OCSE24               :1;
            __IO  uint32_t  OCSE25               :1;
            __IO  uint32_t  OCSE26               :1;
            __IO  uint32_t  OCSE27               :1;
            __IO  uint32_t  OCSE28               :1;
            __IO  uint32_t  OCSE29               :1;
            __IO  uint32_t  OCSE30               :1;
            __IO  uint32_t  OCSE31               :1;
        };
    };
} stc_mft_ocse3_field_t;

typedef struct stc_mft_ocse4_field
{
    union {
        struct {
            __IO  uint16_t  OCSE                 :16;
        };
        struct {
            __IO  uint16_t  OCSE0                :1;
            __IO  uint16_t  OCSE1                :1;
            __IO  uint16_t  OCSE2                :1;
            __IO  uint16_t  OCSE3                :1;
            __IO  uint16_t  OCSE4                :1;
            __IO  uint16_t  OCSE5                :1;
            __IO  uint16_t  OCSE6                :1;
            __IO  uint16_t  OCSE7                :1;
            __IO  uint16_t  OCSE8                :1;
            __IO  uint16_t  OCSE9                :1;
            __IO  uint16_t  OCSE10               :1;
            __IO  uint16_t  OCSE11               :1;
            __IO  uint16_t  OCSE12               :1;
            __IO  uint16_t  OCSE13               :1;
            __IO  uint16_t  OCSE14               :1;
            __IO  uint16_t  OCSE15               :1;
        };
    };
} stc_mft_ocse4_field_t;

typedef struct stc_mft_ocse5_field
{
    union {
        struct {
            __IO  uint32_t  OCSE                 :32;
        };
        struct {
            __IO  uint32_t  OCSE0                :1;
            __IO  uint32_t  OCSE1                :1;
            __IO  uint32_t  OCSE2                :1;
            __IO  uint32_t  OCSE3                :1;
            __IO  uint32_t  OCSE4                :1;
            __IO  uint32_t  OCSE5                :1;
            __IO  uint32_t  OCSE6                :1;
            __IO  uint32_t  OCSE7                :1;
            __IO  uint32_t  OCSE8                :1;
            __IO  uint32_t  OCSE9                :1;
            __IO  uint32_t  OCSE10               :1;
            __IO  uint32_t  OCSE11               :1;
            __IO  uint32_t  OCSE12               :1;
            __IO  uint32_t  OCSE13               :1;
            __IO  uint32_t  OCSE14               :1;
            __IO  uint32_t  OCSE15               :1;
            __IO  uint32_t  OCSE16               :1;
            __IO  uint32_t  OCSE17               :1;
            __IO  uint32_t  OCSE18               :1;
            __IO  uint32_t  OCSE19               :1;
            __IO  uint32_t  OCSE20               :1;
            __IO  uint32_t  OCSE21               :1;
            __IO  uint32_t  OCSE22               :1;
            __IO  uint32_t  OCSE23               :1;
            __IO  uint32_t  OCSE24               :1;
            __IO  uint32_t  OCSE25               :1;
            __IO  uint32_t  OCSE26               :1;
            __IO  uint32_t  OCSE27               :1;
            __IO  uint32_t  OCSE28               :1;
            __IO  uint32_t  OCSE29               :1;
            __IO  uint32_t  OCSE30               :1;
            __IO  uint32_t  OCSE31               :1;
        };
    };
} stc_mft_ocse5_field_t;

typedef struct stc_mft_tccp0_field
{
    union {
        struct {
            __IO  uint16_t  TCCP                 :16;
        };
        struct {
            __IO  uint16_t  TCCP0                :1;
            __IO  uint16_t  TCCP1                :1;
            __IO  uint16_t  TCCP2                :1;
            __IO  uint16_t  TCCP3                :1;
            __IO  uint16_t  TCCP4                :1;
            __IO  uint16_t  TCCP5                :1;
            __IO  uint16_t  TCCP6                :1;
            __IO  uint16_t  TCCP7                :1;
            __IO  uint16_t  TCCP8                :1;
            __IO  uint16_t  TCCP9                :1;
            __IO  uint16_t  TCCP10               :1;
            __IO  uint16_t  TCCP11               :1;
            __IO  uint16_t  TCCP12               :1;
            __IO  uint16_t  TCCP13               :1;
            __IO  uint16_t  TCCP14               :1;
            __IO  uint16_t  TCCP15               :1;
        };
    };
} stc_mft_tccp0_field_t;

typedef struct stc_mft_tcsa0_field
{
    union {
        struct {
            __IO  uint16_t  CLK                  :4;
            __IO  uint16_t  SCLR                 :1;
            __IO  uint16_t  MODE                 :1;
            __IO  uint16_t  STOP                 :1;
            __IO  uint16_t  BFE                  :1;
            __IO  uint16_t  ICRE                 :1;
            __IO  uint16_t  ICLR                 :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  IRQZE                :1;
            __IO  uint16_t  IRQZF                :1;
            __IO  uint16_t  ECKE                 :1;
        };
        struct {
            __IO  uint16_t  CLK0                 :1;
            __IO  uint16_t  CLK1                 :1;
            __IO  uint16_t  CLK2                 :1;
            __IO  uint16_t  CLK3                 :1;
            __IO  uint16_t  RESERVED1            :12;
        };
    };
} stc_mft_tcsa0_field_t;

typedef struct stc_mft_tcsc0_field
{
    union {
        struct {
            __IO  uint16_t  MSZI                 :4;
            __IO  uint16_t  MSPI                 :4;
            __IO  uint16_t  MSZC                 :4;
            __IO  uint16_t  MSPC                 :4;
        };
        struct {
            __IO  uint16_t  MSZI0                :1;
            __IO  uint16_t  MSZI1                :1;
            __IO  uint16_t  MSZI2                :1;
            __IO  uint16_t  MSZI3                :1;
            __IO  uint16_t  MSPI0                :1;
            __IO  uint16_t  MSPI1                :1;
            __IO  uint16_t  MSPI2                :1;
            __IO  uint16_t  MSPI3                :1;
            __IO  uint16_t  MSZC0                :1;
            __IO  uint16_t  MSZC1                :1;
            __IO  uint16_t  MSZC2                :1;
            __IO  uint16_t  MSZC3                :1;
            __IO  uint16_t  MSPC0                :1;
            __IO  uint16_t  MSPC1                :1;
            __IO  uint16_t  MSPC2                :1;
            __IO  uint16_t  MSPC3                :1;
        };
    };
} stc_mft_tcsc0_field_t;

typedef struct stc_mft_tccp1_field
{
    union {
        struct {
            __IO  uint16_t  TCCP                 :16;
        };
        struct {
            __IO  uint16_t  TCCP0                :1;
            __IO  uint16_t  TCCP1                :1;
            __IO  uint16_t  TCCP2                :1;
            __IO  uint16_t  TCCP3                :1;
            __IO  uint16_t  TCCP4                :1;
            __IO  uint16_t  TCCP5                :1;
            __IO  uint16_t  TCCP6                :1;
            __IO  uint16_t  TCCP7                :1;
            __IO  uint16_t  TCCP8                :1;
            __IO  uint16_t  TCCP9                :1;
            __IO  uint16_t  TCCP10               :1;
            __IO  uint16_t  TCCP11               :1;
            __IO  uint16_t  TCCP12               :1;
            __IO  uint16_t  TCCP13               :1;
            __IO  uint16_t  TCCP14               :1;
            __IO  uint16_t  TCCP15               :1;
        };
    };
} stc_mft_tccp1_field_t;

typedef struct stc_mft_tcsa1_field
{
    union {
        struct {
            __IO  uint16_t  CLK                  :4;
            __IO  uint16_t  SCLR                 :1;
            __IO  uint16_t  MODE                 :1;
            __IO  uint16_t  STOP                 :1;
            __IO  uint16_t  BFE                  :1;
            __IO  uint16_t  ICRE                 :1;
            __IO  uint16_t  ICLR                 :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  IRQZE                :1;
            __IO  uint16_t  IRQZF                :1;
            __IO  uint16_t  ECKE                 :1;
        };
        struct {
            __IO  uint16_t  CLK0                 :1;
            __IO  uint16_t  CLK1                 :1;
            __IO  uint16_t  CLK2                 :1;
            __IO  uint16_t  CLK3                 :1;
            __IO  uint16_t  RESERVED1            :12;
        };
    };
} stc_mft_tcsa1_field_t;

typedef struct stc_mft_tcsc1_field
{
    union {
        struct {
            __IO  uint16_t  MSZI                 :4;
            __IO  uint16_t  MSPI                 :4;
            __IO  uint16_t  MSZC                 :4;
            __IO  uint16_t  MSPC                 :4;
        };
        struct {
            __IO  uint16_t  MSZI0                :1;
            __IO  uint16_t  MSZI1                :1;
            __IO  uint16_t  MSZI2                :1;
            __IO  uint16_t  MSZI3                :1;
            __IO  uint16_t  MSPI0                :1;
            __IO  uint16_t  MSPI1                :1;
            __IO  uint16_t  MSPI2                :1;
            __IO  uint16_t  MSPI3                :1;
            __IO  uint16_t  MSZC0                :1;
            __IO  uint16_t  MSZC1                :1;
            __IO  uint16_t  MSZC2                :1;
            __IO  uint16_t  MSZC3                :1;
            __IO  uint16_t  MSPC0                :1;
            __IO  uint16_t  MSPC1                :1;
            __IO  uint16_t  MSPC2                :1;
            __IO  uint16_t  MSPC3                :1;
        };
    };
} stc_mft_tcsc1_field_t;

typedef struct stc_mft_tccp2_field
{
    union {
        struct {
            __IO  uint16_t  TCCP                 :16;
        };
        struct {
            __IO  uint16_t  TCCP0                :1;
            __IO  uint16_t  TCCP1                :1;
            __IO  uint16_t  TCCP2                :1;
            __IO  uint16_t  TCCP3                :1;
            __IO  uint16_t  TCCP4                :1;
            __IO  uint16_t  TCCP5                :1;
            __IO  uint16_t  TCCP6                :1;
            __IO  uint16_t  TCCP7                :1;
            __IO  uint16_t  TCCP8                :1;
            __IO  uint16_t  TCCP9                :1;
            __IO  uint16_t  TCCP10               :1;
            __IO  uint16_t  TCCP11               :1;
            __IO  uint16_t  TCCP12               :1;
            __IO  uint16_t  TCCP13               :1;
            __IO  uint16_t  TCCP14               :1;
            __IO  uint16_t  TCCP15               :1;
        };
    };
} stc_mft_tccp2_field_t;

typedef struct stc_mft_tcsa2_field
{
    union {
        struct {
            __IO  uint16_t  CLK                  :4;
            __IO  uint16_t  SCLR                 :1;
            __IO  uint16_t  MODE                 :1;
            __IO  uint16_t  STOP                 :1;
            __IO  uint16_t  BFE                  :1;
            __IO  uint16_t  ICRE                 :1;
            __IO  uint16_t  ICLR                 :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  IRQZE                :1;
            __IO  uint16_t  IRQZF                :1;
            __IO  uint16_t  ECKE                 :1;
        };
        struct {
            __IO  uint16_t  CLK0                 :1;
            __IO  uint16_t  CLK1                 :1;
            __IO  uint16_t  CLK2                 :1;
            __IO  uint16_t  CLK3                 :1;
            __IO  uint16_t  RESERVED1            :12;
        };
    };
} stc_mft_tcsa2_field_t;

typedef struct stc_mft_tcsc2_field
{
    union {
        struct {
            __IO  uint16_t  MSZI                 :4;
            __IO  uint16_t  MSPI                 :4;
            __IO  uint16_t  MSZC                 :4;
            __IO  uint16_t  MSPC                 :4;
        };
        struct {
            __IO  uint16_t  MSZI0                :1;
            __IO  uint16_t  MSZI1                :1;
            __IO  uint16_t  MSZI2                :1;
            __IO  uint16_t  MSZI3                :1;
            __IO  uint16_t  MSPI0                :1;
            __IO  uint16_t  MSPI1                :1;
            __IO  uint16_t  MSPI2                :1;
            __IO  uint16_t  MSPI3                :1;
            __IO  uint16_t  MSZC0                :1;
            __IO  uint16_t  MSZC1                :1;
            __IO  uint16_t  MSZC2                :1;
            __IO  uint16_t  MSZC3                :1;
            __IO  uint16_t  MSPC0                :1;
            __IO  uint16_t  MSPC1                :1;
            __IO  uint16_t  MSPC2                :1;
            __IO  uint16_t  MSPC3                :1;
        };
    };
} stc_mft_tcsc2_field_t;

typedef struct stc_mft_tcal_field
{
        __IO  uint32_t  STOP00                   :1;
        __IO  uint32_t  STOP01                   :1;
        __IO  uint32_t  STOP02                   :1;
        __IO  uint32_t  STOP10                   :1;
        __IO  uint32_t  STOP11                   :1;
        __IO  uint32_t  STOP12                   :1;
        __IO  uint32_t  STOP20                   :1;
        __IO  uint32_t  STOP21                   :1;
        __IO  uint32_t  STOP22                   :1;
        __IO  uint32_t  RESERVED0                :7;
        __IO  uint32_t  SCLR00                   :1;
        __IO  uint32_t  SCLR01                   :1;
        __IO  uint32_t  SCLR02                   :1;
        __IO  uint32_t  SCLR10                   :1;
        __IO  uint32_t  SCLR11                   :1;
        __IO  uint32_t  SCLR12                   :1;
        __IO  uint32_t  SCLR20                   :1;
        __IO  uint32_t  SCLR21                   :1;
        __IO  uint32_t  SCLR22                   :1;
        __IO  uint32_t  RESERVED1                :7;
} stc_mft_tcal_field_t;

typedef struct stc_mft_ocfs10_field
{
    union {
        struct {
            __IO   uint8_t  FSO0                 :4;
            __IO   uint8_t  FSO1                 :4;
        };
        struct {
            __IO   uint8_t  FSO00                :1;
            __IO   uint8_t  FSO01                :1;
            __IO   uint8_t  FSO02                :1;
            __IO   uint8_t  FSO03                :1;
            __IO   uint8_t  FSO10                :1;
            __IO   uint8_t  FSO11                :1;
            __IO   uint8_t  FSO12                :1;
            __IO   uint8_t  FSO13                :1;
        };
    };
} stc_mft_ocfs10_field_t;

typedef struct stc_mft_ocfs32_field
{
    union {
        struct {
            __IO   uint8_t  FSO2                 :4;
            __IO   uint8_t  FSO3                 :4;
        };
        struct {
            __IO   uint8_t  FSO20                :1;
            __IO   uint8_t  FSO21                :1;
            __IO   uint8_t  FSO22                :1;
            __IO   uint8_t  FSO23                :1;
            __IO   uint8_t  FSO30                :1;
            __IO   uint8_t  FSO31                :1;
            __IO   uint8_t  FSO32                :1;
            __IO   uint8_t  FSO33                :1;
        };
    };
} stc_mft_ocfs32_field_t;

typedef struct stc_mft_ocfs54_field
{
    union {
        struct {
            __IO   uint8_t  FSO4                 :4;
            __IO   uint8_t  FSO5                 :4;
        };
        struct {
            __IO   uint8_t  FSO40                :1;
            __IO   uint8_t  FSO41                :1;
            __IO   uint8_t  FSO42                :1;
            __IO   uint8_t  FSO43                :1;
            __IO   uint8_t  FSO50                :1;
            __IO   uint8_t  FSO51                :1;
            __IO   uint8_t  FSO52                :1;
            __IO   uint8_t  FSO53                :1;
        };
    };
} stc_mft_ocfs54_field_t;

typedef struct stc_mft_icfs10_field
{
    union {
        struct {
            __IO   uint8_t  FSI0                 :4;
            __IO   uint8_t  FSI1                 :4;
        };
        struct {
            __IO   uint8_t  FSI00                :1;
            __IO   uint8_t  FSI01                :1;
            __IO   uint8_t  FSI02                :1;
            __IO   uint8_t  FSI03                :1;
            __IO   uint8_t  FSI10                :1;
            __IO   uint8_t  FSI11                :1;
            __IO   uint8_t  FSI12                :1;
            __IO   uint8_t  FSI13                :1;
        };
    };
} stc_mft_icfs10_field_t;

typedef struct stc_mft_icfs32_field
{
    union {
        struct {
            __IO   uint8_t  FSI2                 :4;
            __IO   uint8_t  FSI3                 :4;
        };
        struct {
            __IO   uint8_t  FSI20                :1;
            __IO   uint8_t  FSI21                :1;
            __IO   uint8_t  FSI22                :1;
            __IO   uint8_t  FSI23                :1;
            __IO   uint8_t  FSI30                :1;
            __IO   uint8_t  FSI31                :1;
            __IO   uint8_t  FSI32                :1;
            __IO   uint8_t  FSI33                :1;
        };
    };
} stc_mft_icfs32_field_t;

typedef struct stc_mft_acfs10_field
{
    union {
        struct {
            __IO   uint8_t  FSA0                 :4;
            __IO   uint8_t  FSA1                 :4;
        };
        struct {
            __IO   uint8_t  FSA00                :1;
            __IO   uint8_t  FSA01                :1;
            __IO   uint8_t  FSA02                :1;
            __IO   uint8_t  FSA03                :1;
            __IO   uint8_t  FSA10                :1;
            __IO   uint8_t  FSA11                :1;
            __IO   uint8_t  FSA12                :1;
            __IO   uint8_t  FSA13                :1;
        };
    };
} stc_mft_acfs10_field_t;

typedef struct stc_mft_acfs32_field
{
    union {
        struct {
            __IO   uint8_t  FSA2                 :4;
            __IO   uint8_t  FSA3                 :4;
        };
        struct {
            __IO   uint8_t  FSA20                :1;
            __IO   uint8_t  FSA21                :1;
            __IO   uint8_t  FSA22                :1;
            __IO   uint8_t  FSA23                :1;
            __IO   uint8_t  FSA30                :1;
            __IO   uint8_t  FSA31                :1;
            __IO   uint8_t  FSA32                :1;
            __IO   uint8_t  FSA33                :1;
        };
    };
} stc_mft_acfs32_field_t;

typedef struct stc_mft_acfs54_field
{
    union {
        struct {
            __IO   uint8_t  FSA4                 :4;
            __IO   uint8_t  FSA5                 :4;
        };
        struct {
            __IO   uint8_t  FSA40                :1;
            __IO   uint8_t  FSA41                :1;
            __IO   uint8_t  FSA42                :1;
            __IO   uint8_t  FSA43                :1;
            __IO   uint8_t  FSA50                :1;
            __IO   uint8_t  FSA51                :1;
            __IO   uint8_t  FSA52                :1;
            __IO   uint8_t  FSA53                :1;
        };
    };
} stc_mft_acfs54_field_t;

typedef struct stc_mft_icsa10_field
{
    union {
        struct {
            __IO   uint8_t  EG0                  :2;
            __IO   uint8_t  EG1                  :2;
            __IO   uint8_t  ICE0                 :1;
            __IO   uint8_t  ICE1                 :1;
            __IO   uint8_t  ICP0                 :1;
            __IO   uint8_t  ICP1                 :1;
        };
        struct {
            __IO   uint8_t  EG00                 :1;
            __IO   uint8_t  EG01                 :1;
            __IO   uint8_t  EG10                 :1;
            __IO   uint8_t  EG11                 :1;
            __IO   uint8_t  RESERVED0            :4;
        };
    };
} stc_mft_icsa10_field_t;

typedef struct stc_mft_icsb10_field
{
        __IO   uint8_t  IEI0                     :1;
        __IO   uint8_t  IEI1                     :1;
        __IO   uint8_t  RESERVED0                :6;
} stc_mft_icsb10_field_t;

typedef struct stc_mft_icsa32_field
{
    union {
        struct {
            __IO   uint8_t  EG2                  :2;
            __IO   uint8_t  EG3                  :2;
            __IO   uint8_t  ICE2                 :1;
            __IO   uint8_t  ICE3                 :1;
            __IO   uint8_t  ICP2                 :1;
            __IO   uint8_t  ICP3                 :1;
        };
        struct {
            __IO   uint8_t  EG20                 :1;
            __IO   uint8_t  EG21                 :1;
            __IO   uint8_t  EG30                 :1;
            __IO   uint8_t  EG31                 :1;
            __IO   uint8_t  RESERVED0            :4;
        };
    };
} stc_mft_icsa32_field_t;

typedef struct stc_mft_icsb32_field
{
        __IO   uint8_t  IEI2                     :1;
        __IO   uint8_t  IEI3                     :1;
        __IO   uint8_t  RESERVED0                :6;
} stc_mft_icsb32_field_t;

typedef struct stc_mft_wfsa10_field
{
    union {
        struct {
            __IO  uint16_t  DCK                  :3;
            __IO  uint16_t  TMD                  :3;
            __IO  uint16_t  GTEN                 :2;
            __IO  uint16_t  PSEL                 :2;
            __IO  uint16_t  PGEN                 :2;
            __IO  uint16_t  DMOD                 :2;
            __IO  uint16_t  RESERVED0            :2;
        };
        struct {
            __IO  uint16_t  DCK0                 :1;
            __IO  uint16_t  DCK1                 :1;
            __IO  uint16_t  DCK2                 :1;
            __IO  uint16_t  TMD0                 :1;
            __IO  uint16_t  TMD1                 :1;
            __IO  uint16_t  TMD2                 :1;
            __IO  uint16_t  GTEN0                :1;
            __IO  uint16_t  GTEN1                :1;
            __IO  uint16_t  PSEL0                :1;
            __IO  uint16_t  PSEL1                :1;
            __IO  uint16_t  PGEN0                :1;
            __IO  uint16_t  PGEN1                :1;
            __IO  uint16_t  DMOD0                :1;
            __IO  uint16_t  DMOD1                :1;
            __IO  uint16_t  RESERVED1            :2;
        };
    };
} stc_mft_wfsa10_field_t;

typedef struct stc_mft_wfsa32_field
{
    union {
        struct {
            __IO  uint16_t  DCK                  :3;
            __IO  uint16_t  TMD                  :3;
            __IO  uint16_t  GTEN                 :2;
            __IO  uint16_t  PSEL                 :2;
            __IO  uint16_t  PGEN                 :2;
            __IO  uint16_t  DMOD                 :2;
            __IO  uint16_t  RESERVED0            :2;
        };
        struct {
            __IO  uint16_t  DCK0                 :1;
            __IO  uint16_t  DCK1                 :1;
            __IO  uint16_t  DCK2                 :1;
            __IO  uint16_t  TMD0                 :1;
            __IO  uint16_t  TMD1                 :1;
            __IO  uint16_t  TMD2                 :1;
            __IO  uint16_t  GTEN0                :1;
            __IO  uint16_t  GTEN1                :1;
            __IO  uint16_t  PSEL0                :1;
            __IO  uint16_t  PSEL1                :1;
            __IO  uint16_t  PGEN0                :1;
            __IO  uint16_t  PGEN1                :1;
            __IO  uint16_t  DMOD0                :1;
            __IO  uint16_t  DMOD1                :1;
            __IO  uint16_t  RESERVED1            :2;
        };
    };
} stc_mft_wfsa32_field_t;

typedef struct stc_mft_wfsa54_field
{
    union {
        struct {
            __IO  uint16_t  DCK                  :3;
            __IO  uint16_t  TMD                  :3;
            __IO  uint16_t  GTEN                 :2;
            __IO  uint16_t  PSEL                 :2;
            __IO  uint16_t  PGEN                 :2;
            __IO  uint16_t  DMOD                 :2;
            __IO  uint16_t  RESERVED0            :2;
        };
        struct {
            __IO  uint16_t  DCK0                 :1;
            __IO  uint16_t  DCK1                 :1;
            __IO  uint16_t  DCK2                 :1;
            __IO  uint16_t  TMD0                 :1;
            __IO  uint16_t  TMD1                 :1;
            __IO  uint16_t  TMD2                 :1;
            __IO  uint16_t  GTEN0                :1;
            __IO  uint16_t  GTEN1                :1;
            __IO  uint16_t  PSEL0                :1;
            __IO  uint16_t  PSEL1                :1;
            __IO  uint16_t  PGEN0                :1;
            __IO  uint16_t  PGEN1                :1;
            __IO  uint16_t  DMOD0                :1;
            __IO  uint16_t  DMOD1                :1;
            __IO  uint16_t  RESERVED1            :2;
        };
    };
} stc_mft_wfsa54_field_t;

typedef struct stc_mft_wfir_field
{
        __IO  uint16_t  DTIFA                    :1;
        __IO  uint16_t  DTICA                    :1;
        __IO  uint16_t  DTIFB                    :1;
        __IO  uint16_t  DTICB                    :1;
        __IO  uint16_t  TMIF10                   :1;
        __IO  uint16_t  TMIC10                   :1;
        __IO  uint16_t  TMIE10                   :1;
        __IO  uint16_t  TMIS10                   :1;
        __IO  uint16_t  TMIF32                   :1;
        __IO  uint16_t  TMIC32                   :1;
        __IO  uint16_t  TMIE32                   :1;
        __IO  uint16_t  TMIS32                   :1;
        __IO  uint16_t  TMIF54                   :1;
        __IO  uint16_t  TMIC54                   :1;
        __IO  uint16_t  TMIE54                   :1;
        __IO  uint16_t  TMIS54                   :1;
} stc_mft_wfir_field_t;

typedef struct stc_mft_nzcl_field
{
    union {
        struct {
            __IO  uint16_t  DTIEA                :1;
            __IO  uint16_t  NWS                  :3;
            __IO  uint16_t  SDTI                 :1;
            __IO  uint16_t  DTIEB                :1;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  DHOLD                :1;
            __IO  uint16_t  DIMA                 :1;
            __IO  uint16_t  DIMB                 :1;
            __IO  uint16_t  RESERVED2            :2;
            __IO  uint16_t  WIM10                :1;
            __IO  uint16_t  WIM32                :1;
            __IO  uint16_t  WIM54                :1;
            __IO  uint16_t  RESERVED3            :1;
        };
        struct {
            __IO  uint16_t  RESERVED0            :1;
            __IO  uint16_t  NWS0                 :1;
            __IO  uint16_t  NWS1                 :1;
            __IO  uint16_t  NWS2                 :1;
            __IO  uint16_t  RESERVED4            :12;
        };
    };
} stc_mft_nzcl_field_t;

typedef struct stc_mft_acmp0_field
{
    union {
        struct {
            __IO  uint16_t  ACMP                 :16;
        };
        struct {
            __IO  uint16_t  ACMP0                :1;
            __IO  uint16_t  ACMP1                :1;
            __IO  uint16_t  ACMP2                :1;
            __IO  uint16_t  ACMP3                :1;
            __IO  uint16_t  ACMP4                :1;
            __IO  uint16_t  ACMP5                :1;
            __IO  uint16_t  ACMP6                :1;
            __IO  uint16_t  ACMP7                :1;
            __IO  uint16_t  ACMP8                :1;
            __IO  uint16_t  ACMP9                :1;
            __IO  uint16_t  ACMP10               :1;
            __IO  uint16_t  ACMP11               :1;
            __IO  uint16_t  ACMP12               :1;
            __IO  uint16_t  ACMP13               :1;
            __IO  uint16_t  ACMP14               :1;
            __IO  uint16_t  ACMP15               :1;
        };
    };
} stc_mft_acmp0_field_t;

typedef struct stc_mft_acmp1_field
{
    union {
        struct {
            __IO  uint16_t  ACMP                 :16;
        };
        struct {
            __IO  uint16_t  ACMP0                :1;
            __IO  uint16_t  ACMP1                :1;
            __IO  uint16_t  ACMP2                :1;
            __IO  uint16_t  ACMP3                :1;
            __IO  uint16_t  ACMP4                :1;
            __IO  uint16_t  ACMP5                :1;
            __IO  uint16_t  ACMP6                :1;
            __IO  uint16_t  ACMP7                :1;
            __IO  uint16_t  ACMP8                :1;
            __IO  uint16_t  ACMP9                :1;
            __IO  uint16_t  ACMP10               :1;
            __IO  uint16_t  ACMP11               :1;
            __IO  uint16_t  ACMP12               :1;
            __IO  uint16_t  ACMP13               :1;
            __IO  uint16_t  ACMP14               :1;
            __IO  uint16_t  ACMP15               :1;
        };
    };
} stc_mft_acmp1_field_t;

typedef struct stc_mft_acmp2_field
{
    union {
        struct {
            __IO  uint16_t  ACMP                 :16;
        };
        struct {
            __IO  uint16_t  ACMP0                :1;
            __IO  uint16_t  ACMP1                :1;
            __IO  uint16_t  ACMP2                :1;
            __IO  uint16_t  ACMP3                :1;
            __IO  uint16_t  ACMP4                :1;
            __IO  uint16_t  ACMP5                :1;
            __IO  uint16_t  ACMP6                :1;
            __IO  uint16_t  ACMP7                :1;
            __IO  uint16_t  ACMP8                :1;
            __IO  uint16_t  ACMP9                :1;
            __IO  uint16_t  ACMP10               :1;
            __IO  uint16_t  ACMP11               :1;
            __IO  uint16_t  ACMP12               :1;
            __IO  uint16_t  ACMP13               :1;
            __IO  uint16_t  ACMP14               :1;
            __IO  uint16_t  ACMP15               :1;
        };
    };
} stc_mft_acmp2_field_t;

typedef struct stc_mft_acmp3_field
{
    union {
        struct {
            __IO  uint16_t  ACMP                 :16;
        };
        struct {
            __IO  uint16_t  ACMP0                :1;
            __IO  uint16_t  ACMP1                :1;
            __IO  uint16_t  ACMP2                :1;
            __IO  uint16_t  ACMP3                :1;
            __IO  uint16_t  ACMP4                :1;
            __IO  uint16_t  ACMP5                :1;
            __IO  uint16_t  ACMP6                :1;
            __IO  uint16_t  ACMP7                :1;
            __IO  uint16_t  ACMP8                :1;
            __IO  uint16_t  ACMP9                :1;
            __IO  uint16_t  ACMP10               :1;
            __IO  uint16_t  ACMP11               :1;
            __IO  uint16_t  ACMP12               :1;
            __IO  uint16_t  ACMP13               :1;
            __IO  uint16_t  ACMP14               :1;
            __IO  uint16_t  ACMP15               :1;
        };
    };
} stc_mft_acmp3_field_t;

typedef struct stc_mft_acmp4_field
{
    union {
        struct {
            __IO  uint16_t  ACMP                 :16;
        };
        struct {
            __IO  uint16_t  ACMP0                :1;
            __IO  uint16_t  ACMP1                :1;
            __IO  uint16_t  ACMP2                :1;
            __IO  uint16_t  ACMP3                :1;
            __IO  uint16_t  ACMP4                :1;
            __IO  uint16_t  ACMP5                :1;
            __IO  uint16_t  ACMP6                :1;
            __IO  uint16_t  ACMP7                :1;
            __IO  uint16_t  ACMP8                :1;
            __IO  uint16_t  ACMP9                :1;
            __IO  uint16_t  ACMP10               :1;
            __IO  uint16_t  ACMP11               :1;
            __IO  uint16_t  ACMP12               :1;
            __IO  uint16_t  ACMP13               :1;
            __IO  uint16_t  ACMP14               :1;
            __IO  uint16_t  ACMP15               :1;
        };
    };
} stc_mft_acmp4_field_t;

typedef struct stc_mft_acmp5_field
{
    union {
        struct {
            __IO  uint16_t  ACMP                 :16;
        };
        struct {
            __IO  uint16_t  ACMP0                :1;
            __IO  uint16_t  ACMP1                :1;
            __IO  uint16_t  ACMP2                :1;
            __IO  uint16_t  ACMP3                :1;
            __IO  uint16_t  ACMP4                :1;
            __IO  uint16_t  ACMP5                :1;
            __IO  uint16_t  ACMP6                :1;
            __IO  uint16_t  ACMP7                :1;
            __IO  uint16_t  ACMP8                :1;
            __IO  uint16_t  ACMP9                :1;
            __IO  uint16_t  ACMP10               :1;
            __IO  uint16_t  ACMP11               :1;
            __IO  uint16_t  ACMP12               :1;
            __IO  uint16_t  ACMP13               :1;
            __IO  uint16_t  ACMP14               :1;
            __IO  uint16_t  ACMP15               :1;
        };
    };
} stc_mft_acmp5_field_t;

typedef struct stc_mft_acsa_field
{
    union {
        struct {
            __IO  uint16_t  CE10                 :2;
            __IO  uint16_t  CE32                 :2;
            __IO  uint16_t  CE54                 :2;
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  SEL10                :2;
            __IO  uint16_t  SEL32                :2;
            __IO  uint16_t  SEL54                :2;
            __IO  uint16_t  RESERVED2            :2;
        };
        struct {
            __IO  uint16_t  CE100                :1;
            __IO  uint16_t  CE101                :1;
            __IO  uint16_t  CE320                :1;
            __IO  uint16_t  CE321                :1;
            __IO  uint16_t  CE540                :1;
            __IO  uint16_t  CE541                :1;
            __IO  uint16_t  RESERVED1            :2;
            __IO  uint16_t  SEL100               :1;
            __IO  uint16_t  SEL101               :1;
            __IO  uint16_t  SEL320               :1;
            __IO  uint16_t  SEL321               :1;
            __IO  uint16_t  SEL540               :1;
            __IO  uint16_t  SEL541               :1;
            __IO  uint16_t  RESERVED3            :2;
        };
    };
} stc_mft_acsa_field_t;

typedef struct stc_mft_acsc0_field
{
    union {
        struct {
            __IO   uint8_t  BUFE                 :2;
            __IO   uint8_t  ADSEL                :3;
            __IO   uint8_t  APBM                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  BUFE0                :1;
            __IO   uint8_t  BUFE1                :1;
            __IO   uint8_t  ADSEL0               :1;
            __IO   uint8_t  ADSEL1               :1;
            __IO   uint8_t  ADSEL2               :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_acsc0_field_t;

typedef struct stc_mft_acsd0_field
{
        __IO   uint8_t  AMOD                     :1;
        __IO   uint8_t  OCUS                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  DE                       :1;
        __IO   uint8_t  PE                       :1;
        __IO   uint8_t  UE                       :1;
        __IO   uint8_t  ZE                       :1;
} stc_mft_acsd0_field_t;

typedef struct stc_mft_acmc0_field
{
    union {
        struct {
            __IO   uint8_t  AMC                  :4;
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  MZCE                 :1;
            __IO   uint8_t  MPCE                 :1;
        };
        struct {
            __IO   uint8_t  AMC0                 :1;
            __IO   uint8_t  AMC1                 :1;
            __IO   uint8_t  AMC2                 :1;
            __IO   uint8_t  AMC3                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_acmc0_field_t;

typedef struct stc_mft_acsc1_field
{
    union {
        struct {
            __IO   uint8_t  BUFE                 :2;
            __IO   uint8_t  ADSEL                :3;
            __IO   uint8_t  APBM                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  BUFE0                :1;
            __IO   uint8_t  BUFE1                :1;
            __IO   uint8_t  ADSEL0               :1;
            __IO   uint8_t  ADSEL1               :1;
            __IO   uint8_t  ADSEL2               :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_acsc1_field_t;

typedef struct stc_mft_acsd1_field
{
        __IO   uint8_t  AMOD                     :1;
        __IO   uint8_t  OCUS                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  DE                       :1;
        __IO   uint8_t  PE                       :1;
        __IO   uint8_t  UE                       :1;
        __IO   uint8_t  ZE                       :1;
} stc_mft_acsd1_field_t;

typedef struct stc_mft_acmc1_field
{
    union {
        struct {
            __IO   uint8_t  AMC                  :4;
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  MZCE                 :1;
            __IO   uint8_t  MPCE                 :1;
        };
        struct {
            __IO   uint8_t  AMC0                 :1;
            __IO   uint8_t  AMC1                 :1;
            __IO   uint8_t  AMC2                 :1;
            __IO   uint8_t  AMC3                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_acmc1_field_t;

typedef struct stc_mft_acsc2_field
{
    union {
        struct {
            __IO   uint8_t  BUFE                 :2;
            __IO   uint8_t  ADSEL                :3;
            __IO   uint8_t  APBM                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  BUFE0                :1;
            __IO   uint8_t  BUFE1                :1;
            __IO   uint8_t  ADSEL0               :1;
            __IO   uint8_t  ADSEL1               :1;
            __IO   uint8_t  ADSEL2               :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_acsc2_field_t;

typedef struct stc_mft_acsd2_field
{
        __IO   uint8_t  AMOD                     :1;
        __IO   uint8_t  OCUS                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  DE                       :1;
        __IO   uint8_t  PE                       :1;
        __IO   uint8_t  UE                       :1;
        __IO   uint8_t  ZE                       :1;
} stc_mft_acsd2_field_t;

typedef struct stc_mft_acmc2_field
{
    union {
        struct {
            __IO   uint8_t  AMC                  :4;
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  MZCE                 :1;
            __IO   uint8_t  MPCE                 :1;
        };
        struct {
            __IO   uint8_t  AMC0                 :1;
            __IO   uint8_t  AMC1                 :1;
            __IO   uint8_t  AMC2                 :1;
            __IO   uint8_t  AMC3                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_acmc2_field_t;

typedef struct stc_mft_acsc3_field
{
    union {
        struct {
            __IO   uint8_t  BUFE                 :2;
            __IO   uint8_t  ADSEL                :3;
            __IO   uint8_t  APBM                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  BUFE0                :1;
            __IO   uint8_t  BUFE1                :1;
            __IO   uint8_t  ADSEL0               :1;
            __IO   uint8_t  ADSEL1               :1;
            __IO   uint8_t  ADSEL2               :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_acsc3_field_t;

typedef struct stc_mft_acsd3_field
{
        __IO   uint8_t  AMOD                     :1;
        __IO   uint8_t  OCUS                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  DE                       :1;
        __IO   uint8_t  PE                       :1;
        __IO   uint8_t  UE                       :1;
        __IO   uint8_t  ZE                       :1;
} stc_mft_acsd3_field_t;

typedef struct stc_mft_acmc3_field
{
    union {
        struct {
            __IO   uint8_t  AMC                  :4;
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  MZCE                 :1;
            __IO   uint8_t  MPCE                 :1;
        };
        struct {
            __IO   uint8_t  AMC0                 :1;
            __IO   uint8_t  AMC1                 :1;
            __IO   uint8_t  AMC2                 :1;
            __IO   uint8_t  AMC3                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_acmc3_field_t;

typedef struct stc_mft_acsc4_field
{
    union {
        struct {
            __IO   uint8_t  BUFE                 :2;
            __IO   uint8_t  ADSEL                :3;
            __IO   uint8_t  APBM                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  BUFE0                :1;
            __IO   uint8_t  BUFE1                :1;
            __IO   uint8_t  ADSEL0               :1;
            __IO   uint8_t  ADSEL1               :1;
            __IO   uint8_t  ADSEL2               :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_acsc4_field_t;

typedef struct stc_mft_acsd4_field
{
        __IO   uint8_t  AMOD                     :1;
        __IO   uint8_t  OCUS                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  DE                       :1;
        __IO   uint8_t  PE                       :1;
        __IO   uint8_t  UE                       :1;
        __IO   uint8_t  ZE                       :1;
} stc_mft_acsd4_field_t;

typedef struct stc_mft_acmc4_field
{
    union {
        struct {
            __IO   uint8_t  AMC                  :4;
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  MZCE                 :1;
            __IO   uint8_t  MPCE                 :1;
        };
        struct {
            __IO   uint8_t  AMC0                 :1;
            __IO   uint8_t  AMC1                 :1;
            __IO   uint8_t  AMC2                 :1;
            __IO   uint8_t  AMC3                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_acmc4_field_t;

typedef struct stc_mft_acsc5_field
{
    union {
        struct {
            __IO   uint8_t  BUFE                 :2;
            __IO   uint8_t  ADSEL                :3;
            __IO   uint8_t  APBM                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  BUFE0                :1;
            __IO   uint8_t  BUFE1                :1;
            __IO   uint8_t  ADSEL0               :1;
            __IO   uint8_t  ADSEL1               :1;
            __IO   uint8_t  ADSEL2               :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_acsc5_field_t;

typedef struct stc_mft_acsd5_field
{
        __IO   uint8_t  AMOD                     :1;
        __IO   uint8_t  OCUS                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  DE                       :1;
        __IO   uint8_t  PE                       :1;
        __IO   uint8_t  UE                       :1;
        __IO   uint8_t  ZE                       :1;
} stc_mft_acsd5_field_t;

typedef struct stc_mft_acmc5_field
{
    union {
        struct {
            __IO   uint8_t  AMC                  :4;
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  MZCE                 :1;
            __IO   uint8_t  MPCE                 :1;
        };
        struct {
            __IO   uint8_t  AMC0                 :1;
            __IO   uint8_t  AMC1                 :1;
            __IO   uint8_t  AMC2                 :1;
            __IO   uint8_t  AMC3                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_acmc5_field_t;

typedef struct stc_mft_tcsd_field
{
        __IO   uint8_t  OFMD1                    :1;
        __IO   uint8_t  OFMD2                    :1;
        __IO   uint8_t  RESERVED0                :6;
} stc_mft_tcsd_field_t;

typedef struct stc_mft_ocu_ocsa10_field
{
        __IO   uint8_t  CST0                     :1;
        __IO   uint8_t  CST1                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  IOE0                     :1;
        __IO   uint8_t  IOE1                     :1;
        __IO   uint8_t  IOP0                     :1;
        __IO   uint8_t  IOP1                     :1;
} stc_mft_ocu_ocsa10_field_t;

typedef struct stc_mft_ocu_ocsb10_field
{
        __IO   uint8_t  OTD0                     :1;
        __IO   uint8_t  OTD1                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  CMOD                     :1;
        __IO   uint8_t  RESERVED1                :2;
        __IO   uint8_t  FM4                      :1;
} stc_mft_ocu_ocsb10_field_t;

typedef struct stc_mft_ocu_ocsd10_field
{
    union {
        struct {
            __IO  uint16_t  OCCP0BUFE            :2;
            __IO  uint16_t  OCCP1BUFE            :2;
            __IO  uint16_t  OCSE0BUFE            :2;
            __IO  uint16_t  OCSE1BUFE            :2;
            __IO  uint16_t  OPBM0                :1;
            __IO  uint16_t  OPBM1                :1;
            __IO  uint16_t  OEBM0                :1;
            __IO  uint16_t  OEBM1                :1;
            __IO  uint16_t  OFEX0                :1;
            __IO  uint16_t  OFEX1                :1;
            __IO  uint16_t  RESERVED0            :2;
        };
        struct {
            __IO  uint16_t  OCCP0BUFE0           :1;
            __IO  uint16_t  OCCP0BUFE1           :1;
            __IO  uint16_t  OCCP1BUFE0           :1;
            __IO  uint16_t  OCCP1BUFE1           :1;
            __IO  uint16_t  OCSE0BUFE0           :1;
            __IO  uint16_t  OCSE0BUFE1           :1;
            __IO  uint16_t  OCSE1BUFE0           :1;
            __IO  uint16_t  OCSE1BUFE1           :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_mft_ocu_ocsd10_field_t;

typedef struct stc_mft_ocu_ocsa32_field
{
        __IO   uint8_t  CST2                     :1;
        __IO   uint8_t  CST3                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  IOE2                     :1;
        __IO   uint8_t  IOE3                     :1;
        __IO   uint8_t  IOP2                     :1;
        __IO   uint8_t  IOP3                     :1;
} stc_mft_ocu_ocsa32_field_t;

typedef struct stc_mft_ocu_ocsb32_field
{
        __IO   uint8_t  OTD2                     :1;
        __IO   uint8_t  OTD3                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  CMOD                     :1;
        __IO   uint8_t  RESERVED1                :2;
        __IO   uint8_t  FM4                      :1;
} stc_mft_ocu_ocsb32_field_t;

typedef struct stc_mft_ocu_ocsd32_field
{
    union {
        struct {
            __IO  uint16_t  OCCP2BUFE            :2;
            __IO  uint16_t  OCCP3BUFE            :2;
            __IO  uint16_t  OCSE2BUFE            :2;
            __IO  uint16_t  OCSE3BUFE            :2;
            __IO  uint16_t  OPBM2                :1;
            __IO  uint16_t  OPBM3                :1;
            __IO  uint16_t  OEBM2                :1;
            __IO  uint16_t  OEBM3                :1;
            __IO  uint16_t  OFEX2                :1;
            __IO  uint16_t  OFEX3                :1;
            __IO  uint16_t  RESERVED0            :2;
        };
        struct {
            __IO  uint16_t  OCCP2BUFE0           :1;
            __IO  uint16_t  OCCP2BUFE1           :1;
            __IO  uint16_t  OCCP3BUFE0           :1;
            __IO  uint16_t  OCCP3BUFE1           :1;
            __IO  uint16_t  OCSE2BUFE0           :1;
            __IO  uint16_t  OCSE2BUFE1           :1;
            __IO  uint16_t  OCSE3BUFE0           :1;
            __IO  uint16_t  OCSE3BUFE1           :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_mft_ocu_ocsd32_field_t;

typedef struct stc_mft_ocu_ocsa54_field
{
        __IO   uint8_t  CST4                     :1;
        __IO   uint8_t  CST5                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  IOE4                     :1;
        __IO   uint8_t  IOE5                     :1;
        __IO   uint8_t  IOP4                     :1;
        __IO   uint8_t  IOP5                     :1;
} stc_mft_ocu_ocsa54_field_t;

typedef struct stc_mft_ocu_ocsb54_field
{
        __IO   uint8_t  OTD4                     :1;
        __IO   uint8_t  OTD5                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  CMOD                     :1;
        __IO   uint8_t  RESERVED1                :2;
        __IO   uint8_t  FM4                      :1;
} stc_mft_ocu_ocsb54_field_t;

typedef struct stc_mft_ocu_ocsd54_field
{
    union {
        struct {
            __IO  uint16_t  OCCP4BUFE            :2;
            __IO  uint16_t  OCCP5BUFE            :2;
            __IO  uint16_t  OCSE4BUFE            :2;
            __IO  uint16_t  OCSE5BUFE            :2;
            __IO  uint16_t  OPBM4                :1;
            __IO  uint16_t  OPBM5                :1;
            __IO  uint16_t  OEBM4                :1;
            __IO  uint16_t  OEBM5                :1;
            __IO  uint16_t  OFEX4                :1;
            __IO  uint16_t  OFEX5                :1;
            __IO  uint16_t  RESERVED0            :2;
        };
        struct {
            __IO  uint16_t  OCCP4BUFE0           :1;
            __IO  uint16_t  OCCP4BUFE1           :1;
            __IO  uint16_t  OCCP5BUFE0           :1;
            __IO  uint16_t  OCCP5BUFE1           :1;
            __IO  uint16_t  OCSE4BUFE0           :1;
            __IO  uint16_t  OCSE4BUFE1           :1;
            __IO  uint16_t  OCSE5BUFE0           :1;
            __IO  uint16_t  OCSE5BUFE1           :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_mft_ocu_ocsd54_field_t;

typedef struct stc_mft_ocu_ocsc_field
{
        __IO   uint8_t  MOD0                     :1;
        __IO   uint8_t  MOD1                     :1;
        __IO   uint8_t  MOD2                     :1;
        __IO   uint8_t  MOD3                     :1;
        __IO   uint8_t  MOD4                     :1;
        __IO   uint8_t  MOD5                     :1;
        __IO   uint8_t  RESERVED0                :2;
} stc_mft_ocu_ocsc_field_t;

typedef struct stc_mft_ocu_ocse0_field
{
    union {
        struct {
            __IO  uint16_t  OCSE                 :16;
        };
        struct {
            __IO  uint16_t  OCSE0                :1;
            __IO  uint16_t  OCSE1                :1;
            __IO  uint16_t  OCSE2                :1;
            __IO  uint16_t  OCSE3                :1;
            __IO  uint16_t  OCSE4                :1;
            __IO  uint16_t  OCSE5                :1;
            __IO  uint16_t  OCSE6                :1;
            __IO  uint16_t  OCSE7                :1;
            __IO  uint16_t  OCSE8                :1;
            __IO  uint16_t  OCSE9                :1;
            __IO  uint16_t  OCSE10               :1;
            __IO  uint16_t  OCSE11               :1;
            __IO  uint16_t  OCSE12               :1;
            __IO  uint16_t  OCSE13               :1;
            __IO  uint16_t  OCSE14               :1;
            __IO  uint16_t  OCSE15               :1;
        };
    };
} stc_mft_ocu_ocse0_field_t;

typedef struct stc_mft_ocu_ocse1_field
{
    union {
        struct {
            __IO  uint32_t  OCSE                 :32;
        };
        struct {
            __IO  uint32_t  OCSE0                :1;
            __IO  uint32_t  OCSE1                :1;
            __IO  uint32_t  OCSE2                :1;
            __IO  uint32_t  OCSE3                :1;
            __IO  uint32_t  OCSE4                :1;
            __IO  uint32_t  OCSE5                :1;
            __IO  uint32_t  OCSE6                :1;
            __IO  uint32_t  OCSE7                :1;
            __IO  uint32_t  OCSE8                :1;
            __IO  uint32_t  OCSE9                :1;
            __IO  uint32_t  OCSE10               :1;
            __IO  uint32_t  OCSE11               :1;
            __IO  uint32_t  OCSE12               :1;
            __IO  uint32_t  OCSE13               :1;
            __IO  uint32_t  OCSE14               :1;
            __IO  uint32_t  OCSE15               :1;
            __IO  uint32_t  OCSE16               :1;
            __IO  uint32_t  OCSE17               :1;
            __IO  uint32_t  OCSE18               :1;
            __IO  uint32_t  OCSE19               :1;
            __IO  uint32_t  OCSE20               :1;
            __IO  uint32_t  OCSE21               :1;
            __IO  uint32_t  OCSE22               :1;
            __IO  uint32_t  OCSE23               :1;
            __IO  uint32_t  OCSE24               :1;
            __IO  uint32_t  OCSE25               :1;
            __IO  uint32_t  OCSE26               :1;
            __IO  uint32_t  OCSE27               :1;
            __IO  uint32_t  OCSE28               :1;
            __IO  uint32_t  OCSE29               :1;
            __IO  uint32_t  OCSE30               :1;
            __IO  uint32_t  OCSE31               :1;
        };
    };
} stc_mft_ocu_ocse1_field_t;

typedef struct stc_mft_ocu_ocse2_field
{
    union {
        struct {
            __IO  uint16_t  OCSE                 :16;
        };
        struct {
            __IO  uint16_t  OCSE0                :1;
            __IO  uint16_t  OCSE1                :1;
            __IO  uint16_t  OCSE2                :1;
            __IO  uint16_t  OCSE3                :1;
            __IO  uint16_t  OCSE4                :1;
            __IO  uint16_t  OCSE5                :1;
            __IO  uint16_t  OCSE6                :1;
            __IO  uint16_t  OCSE7                :1;
            __IO  uint16_t  OCSE8                :1;
            __IO  uint16_t  OCSE9                :1;
            __IO  uint16_t  OCSE10               :1;
            __IO  uint16_t  OCSE11               :1;
            __IO  uint16_t  OCSE12               :1;
            __IO  uint16_t  OCSE13               :1;
            __IO  uint16_t  OCSE14               :1;
            __IO  uint16_t  OCSE15               :1;
        };
    };
} stc_mft_ocu_ocse2_field_t;

typedef struct stc_mft_ocu_ocse3_field
{
    union {
        struct {
            __IO  uint32_t  OCSE                 :32;
        };
        struct {
            __IO  uint32_t  OCSE0                :1;
            __IO  uint32_t  OCSE1                :1;
            __IO  uint32_t  OCSE2                :1;
            __IO  uint32_t  OCSE3                :1;
            __IO  uint32_t  OCSE4                :1;
            __IO  uint32_t  OCSE5                :1;
            __IO  uint32_t  OCSE6                :1;
            __IO  uint32_t  OCSE7                :1;
            __IO  uint32_t  OCSE8                :1;
            __IO  uint32_t  OCSE9                :1;
            __IO  uint32_t  OCSE10               :1;
            __IO  uint32_t  OCSE11               :1;
            __IO  uint32_t  OCSE12               :1;
            __IO  uint32_t  OCSE13               :1;
            __IO  uint32_t  OCSE14               :1;
            __IO  uint32_t  OCSE15               :1;
            __IO  uint32_t  OCSE16               :1;
            __IO  uint32_t  OCSE17               :1;
            __IO  uint32_t  OCSE18               :1;
            __IO  uint32_t  OCSE19               :1;
            __IO  uint32_t  OCSE20               :1;
            __IO  uint32_t  OCSE21               :1;
            __IO  uint32_t  OCSE22               :1;
            __IO  uint32_t  OCSE23               :1;
            __IO  uint32_t  OCSE24               :1;
            __IO  uint32_t  OCSE25               :1;
            __IO  uint32_t  OCSE26               :1;
            __IO  uint32_t  OCSE27               :1;
            __IO  uint32_t  OCSE28               :1;
            __IO  uint32_t  OCSE29               :1;
            __IO  uint32_t  OCSE30               :1;
            __IO  uint32_t  OCSE31               :1;
        };
    };
} stc_mft_ocu_ocse3_field_t;

typedef struct stc_mft_ocu_ocse4_field
{
    union {
        struct {
            __IO  uint16_t  OCSE                 :16;
        };
        struct {
            __IO  uint16_t  OCSE0                :1;
            __IO  uint16_t  OCSE1                :1;
            __IO  uint16_t  OCSE2                :1;
            __IO  uint16_t  OCSE3                :1;
            __IO  uint16_t  OCSE4                :1;
            __IO  uint16_t  OCSE5                :1;
            __IO  uint16_t  OCSE6                :1;
            __IO  uint16_t  OCSE7                :1;
            __IO  uint16_t  OCSE8                :1;
            __IO  uint16_t  OCSE9                :1;
            __IO  uint16_t  OCSE10               :1;
            __IO  uint16_t  OCSE11               :1;
            __IO  uint16_t  OCSE12               :1;
            __IO  uint16_t  OCSE13               :1;
            __IO  uint16_t  OCSE14               :1;
            __IO  uint16_t  OCSE15               :1;
        };
    };
} stc_mft_ocu_ocse4_field_t;

typedef struct stc_mft_ocu_ocse5_field
{
    union {
        struct {
            __IO  uint32_t  OCSE                 :32;
        };
        struct {
            __IO  uint32_t  OCSE0                :1;
            __IO  uint32_t  OCSE1                :1;
            __IO  uint32_t  OCSE2                :1;
            __IO  uint32_t  OCSE3                :1;
            __IO  uint32_t  OCSE4                :1;
            __IO  uint32_t  OCSE5                :1;
            __IO  uint32_t  OCSE6                :1;
            __IO  uint32_t  OCSE7                :1;
            __IO  uint32_t  OCSE8                :1;
            __IO  uint32_t  OCSE9                :1;
            __IO  uint32_t  OCSE10               :1;
            __IO  uint32_t  OCSE11               :1;
            __IO  uint32_t  OCSE12               :1;
            __IO  uint32_t  OCSE13               :1;
            __IO  uint32_t  OCSE14               :1;
            __IO  uint32_t  OCSE15               :1;
            __IO  uint32_t  OCSE16               :1;
            __IO  uint32_t  OCSE17               :1;
            __IO  uint32_t  OCSE18               :1;
            __IO  uint32_t  OCSE19               :1;
            __IO  uint32_t  OCSE20               :1;
            __IO  uint32_t  OCSE21               :1;
            __IO  uint32_t  OCSE22               :1;
            __IO  uint32_t  OCSE23               :1;
            __IO  uint32_t  OCSE24               :1;
            __IO  uint32_t  OCSE25               :1;
            __IO  uint32_t  OCSE26               :1;
            __IO  uint32_t  OCSE27               :1;
            __IO  uint32_t  OCSE28               :1;
            __IO  uint32_t  OCSE29               :1;
            __IO  uint32_t  OCSE30               :1;
            __IO  uint32_t  OCSE31               :1;
        };
    };
} stc_mft_ocu_ocse5_field_t;

typedef struct stc_mft_frt_tccp0_field
{
    union {
        struct {
            __IO  uint16_t  TCCP                 :16;
        };
        struct {
            __IO  uint16_t  TCCP0                :1;
            __IO  uint16_t  TCCP1                :1;
            __IO  uint16_t  TCCP2                :1;
            __IO  uint16_t  TCCP3                :1;
            __IO  uint16_t  TCCP4                :1;
            __IO  uint16_t  TCCP5                :1;
            __IO  uint16_t  TCCP6                :1;
            __IO  uint16_t  TCCP7                :1;
            __IO  uint16_t  TCCP8                :1;
            __IO  uint16_t  TCCP9                :1;
            __IO  uint16_t  TCCP10               :1;
            __IO  uint16_t  TCCP11               :1;
            __IO  uint16_t  TCCP12               :1;
            __IO  uint16_t  TCCP13               :1;
            __IO  uint16_t  TCCP14               :1;
            __IO  uint16_t  TCCP15               :1;
        };
    };
} stc_mft_frt_tccp0_field_t;

typedef struct stc_mft_frt_tcsa0_field
{
    union {
        struct {
            __IO  uint16_t  CLK                  :4;
            __IO  uint16_t  SCLR                 :1;
            __IO  uint16_t  MODE                 :1;
            __IO  uint16_t  STOP                 :1;
            __IO  uint16_t  BFE                  :1;
            __IO  uint16_t  ICRE                 :1;
            __IO  uint16_t  ICLR                 :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  IRQZE                :1;
            __IO  uint16_t  IRQZF                :1;
            __IO  uint16_t  ECKE                 :1;
        };
        struct {
            __IO  uint16_t  CLK0                 :1;
            __IO  uint16_t  CLK1                 :1;
            __IO  uint16_t  CLK2                 :1;
            __IO  uint16_t  CLK3                 :1;
            __IO  uint16_t  RESERVED1            :12;
        };
    };
} stc_mft_frt_tcsa0_field_t;

typedef struct stc_mft_frt_tcsc0_field
{
    union {
        struct {
            __IO  uint16_t  MSZI                 :4;
            __IO  uint16_t  MSPI                 :4;
            __IO  uint16_t  MSZC                 :4;
            __IO  uint16_t  MSPC                 :4;
        };
        struct {
            __IO  uint16_t  MSZI0                :1;
            __IO  uint16_t  MSZI1                :1;
            __IO  uint16_t  MSZI2                :1;
            __IO  uint16_t  MSZI3                :1;
            __IO  uint16_t  MSPI0                :1;
            __IO  uint16_t  MSPI1                :1;
            __IO  uint16_t  MSPI2                :1;
            __IO  uint16_t  MSPI3                :1;
            __IO  uint16_t  MSZC0                :1;
            __IO  uint16_t  MSZC1                :1;
            __IO  uint16_t  MSZC2                :1;
            __IO  uint16_t  MSZC3                :1;
            __IO  uint16_t  MSPC0                :1;
            __IO  uint16_t  MSPC1                :1;
            __IO  uint16_t  MSPC2                :1;
            __IO  uint16_t  MSPC3                :1;
        };
    };
} stc_mft_frt_tcsc0_field_t;

typedef struct stc_mft_frt_tccp1_field
{
    union {
        struct {
            __IO  uint16_t  TCCP                 :16;
        };
        struct {
            __IO  uint16_t  TCCP0                :1;
            __IO  uint16_t  TCCP1                :1;
            __IO  uint16_t  TCCP2                :1;
            __IO  uint16_t  TCCP3                :1;
            __IO  uint16_t  TCCP4                :1;
            __IO  uint16_t  TCCP5                :1;
            __IO  uint16_t  TCCP6                :1;
            __IO  uint16_t  TCCP7                :1;
            __IO  uint16_t  TCCP8                :1;
            __IO  uint16_t  TCCP9                :1;
            __IO  uint16_t  TCCP10               :1;
            __IO  uint16_t  TCCP11               :1;
            __IO  uint16_t  TCCP12               :1;
            __IO  uint16_t  TCCP13               :1;
            __IO  uint16_t  TCCP14               :1;
            __IO  uint16_t  TCCP15               :1;
        };
    };
} stc_mft_frt_tccp1_field_t;

typedef struct stc_mft_frt_tcsa1_field
{
    union {
        struct {
            __IO  uint16_t  CLK                  :4;
            __IO  uint16_t  SCLR                 :1;
            __IO  uint16_t  MODE                 :1;
            __IO  uint16_t  STOP                 :1;
            __IO  uint16_t  BFE                  :1;
            __IO  uint16_t  ICRE                 :1;
            __IO  uint16_t  ICLR                 :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  IRQZE                :1;
            __IO  uint16_t  IRQZF                :1;
            __IO  uint16_t  ECKE                 :1;
        };
        struct {
            __IO  uint16_t  CLK0                 :1;
            __IO  uint16_t  CLK1                 :1;
            __IO  uint16_t  CLK2                 :1;
            __IO  uint16_t  CLK3                 :1;
            __IO  uint16_t  RESERVED1            :12;
        };
    };
} stc_mft_frt_tcsa1_field_t;

typedef struct stc_mft_frt_tcsc1_field
{
    union {
        struct {
            __IO  uint16_t  MSZI                 :4;
            __IO  uint16_t  MSPI                 :4;
            __IO  uint16_t  MSZC                 :4;
            __IO  uint16_t  MSPC                 :4;
        };
        struct {
            __IO  uint16_t  MSZI0                :1;
            __IO  uint16_t  MSZI1                :1;
            __IO  uint16_t  MSZI2                :1;
            __IO  uint16_t  MSZI3                :1;
            __IO  uint16_t  MSPI0                :1;
            __IO  uint16_t  MSPI1                :1;
            __IO  uint16_t  MSPI2                :1;
            __IO  uint16_t  MSPI3                :1;
            __IO  uint16_t  MSZC0                :1;
            __IO  uint16_t  MSZC1                :1;
            __IO  uint16_t  MSZC2                :1;
            __IO  uint16_t  MSZC3                :1;
            __IO  uint16_t  MSPC0                :1;
            __IO  uint16_t  MSPC1                :1;
            __IO  uint16_t  MSPC2                :1;
            __IO  uint16_t  MSPC3                :1;
        };
    };
} stc_mft_frt_tcsc1_field_t;

typedef struct stc_mft_frt_tccp2_field
{
    union {
        struct {
            __IO  uint16_t  TCCP                 :16;
        };
        struct {
            __IO  uint16_t  TCCP0                :1;
            __IO  uint16_t  TCCP1                :1;
            __IO  uint16_t  TCCP2                :1;
            __IO  uint16_t  TCCP3                :1;
            __IO  uint16_t  TCCP4                :1;
            __IO  uint16_t  TCCP5                :1;
            __IO  uint16_t  TCCP6                :1;
            __IO  uint16_t  TCCP7                :1;
            __IO  uint16_t  TCCP8                :1;
            __IO  uint16_t  TCCP9                :1;
            __IO  uint16_t  TCCP10               :1;
            __IO  uint16_t  TCCP11               :1;
            __IO  uint16_t  TCCP12               :1;
            __IO  uint16_t  TCCP13               :1;
            __IO  uint16_t  TCCP14               :1;
            __IO  uint16_t  TCCP15               :1;
        };
    };
} stc_mft_frt_tccp2_field_t;

typedef struct stc_mft_frt_tcsa2_field
{
    union {
        struct {
            __IO  uint16_t  CLK                  :4;
            __IO  uint16_t  SCLR                 :1;
            __IO  uint16_t  MODE                 :1;
            __IO  uint16_t  STOP                 :1;
            __IO  uint16_t  BFE                  :1;
            __IO  uint16_t  ICRE                 :1;
            __IO  uint16_t  ICLR                 :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  IRQZE                :1;
            __IO  uint16_t  IRQZF                :1;
            __IO  uint16_t  ECKE                 :1;
        };
        struct {
            __IO  uint16_t  CLK0                 :1;
            __IO  uint16_t  CLK1                 :1;
            __IO  uint16_t  CLK2                 :1;
            __IO  uint16_t  CLK3                 :1;
            __IO  uint16_t  RESERVED1            :12;
        };
    };
} stc_mft_frt_tcsa2_field_t;

typedef struct stc_mft_frt_tcsc2_field
{
    union {
        struct {
            __IO  uint16_t  MSZI                 :4;
            __IO  uint16_t  MSPI                 :4;
            __IO  uint16_t  MSZC                 :4;
            __IO  uint16_t  MSPC                 :4;
        };
        struct {
            __IO  uint16_t  MSZI0                :1;
            __IO  uint16_t  MSZI1                :1;
            __IO  uint16_t  MSZI2                :1;
            __IO  uint16_t  MSZI3                :1;
            __IO  uint16_t  MSPI0                :1;
            __IO  uint16_t  MSPI1                :1;
            __IO  uint16_t  MSPI2                :1;
            __IO  uint16_t  MSPI3                :1;
            __IO  uint16_t  MSZC0                :1;
            __IO  uint16_t  MSZC1                :1;
            __IO  uint16_t  MSZC2                :1;
            __IO  uint16_t  MSZC3                :1;
            __IO  uint16_t  MSPC0                :1;
            __IO  uint16_t  MSPC1                :1;
            __IO  uint16_t  MSPC2                :1;
            __IO  uint16_t  MSPC3                :1;
        };
    };
} stc_mft_frt_tcsc2_field_t;

typedef struct stc_mft_frt_tcal_field
{
        __IO  uint32_t  STOP00                   :1;
        __IO  uint32_t  STOP01                   :1;
        __IO  uint32_t  STOP02                   :1;
        __IO  uint32_t  STOP10                   :1;
        __IO  uint32_t  STOP11                   :1;
        __IO  uint32_t  STOP12                   :1;
        __IO  uint32_t  STOP20                   :1;
        __IO  uint32_t  STOP21                   :1;
        __IO  uint32_t  STOP22                   :1;
        __IO  uint32_t  RESERVED0                :7;
        __IO  uint32_t  SCLR00                   :1;
        __IO  uint32_t  SCLR01                   :1;
        __IO  uint32_t  SCLR02                   :1;
        __IO  uint32_t  SCLR10                   :1;
        __IO  uint32_t  SCLR11                   :1;
        __IO  uint32_t  SCLR12                   :1;
        __IO  uint32_t  SCLR20                   :1;
        __IO  uint32_t  SCLR21                   :1;
        __IO  uint32_t  SCLR22                   :1;
        __IO  uint32_t  RESERVED1                :7;
} stc_mft_frt_tcal_field_t;

typedef struct stc_mft_ocu_ocfs10_field
{
    union {
        struct {
            __IO   uint8_t  FSO0                 :4;
            __IO   uint8_t  FSO1                 :4;
        };
        struct {
            __IO   uint8_t  FSO00                :1;
            __IO   uint8_t  FSO01                :1;
            __IO   uint8_t  FSO02                :1;
            __IO   uint8_t  FSO03                :1;
            __IO   uint8_t  FSO10                :1;
            __IO   uint8_t  FSO11                :1;
            __IO   uint8_t  FSO12                :1;
            __IO   uint8_t  FSO13                :1;
        };
    };
} stc_mft_ocu_ocfs10_field_t;

typedef struct stc_mft_ocu_ocfs32_field
{
    union {
        struct {
            __IO   uint8_t  FSO2                 :4;
            __IO   uint8_t  FSO3                 :4;
        };
        struct {
            __IO   uint8_t  FSO20                :1;
            __IO   uint8_t  FSO21                :1;
            __IO   uint8_t  FSO22                :1;
            __IO   uint8_t  FSO23                :1;
            __IO   uint8_t  FSO30                :1;
            __IO   uint8_t  FSO31                :1;
            __IO   uint8_t  FSO32                :1;
            __IO   uint8_t  FSO33                :1;
        };
    };
} stc_mft_ocu_ocfs32_field_t;

typedef struct stc_mft_ocu_ocfs54_field
{
    union {
        struct {
            __IO   uint8_t  FSO4                 :4;
            __IO   uint8_t  FSO5                 :4;
        };
        struct {
            __IO   uint8_t  FSO40                :1;
            __IO   uint8_t  FSO41                :1;
            __IO   uint8_t  FSO42                :1;
            __IO   uint8_t  FSO43                :1;
            __IO   uint8_t  FSO50                :1;
            __IO   uint8_t  FSO51                :1;
            __IO   uint8_t  FSO52                :1;
            __IO   uint8_t  FSO53                :1;
        };
    };
} stc_mft_ocu_ocfs54_field_t;

typedef struct stc_mft_icu_icfs10_field
{
    union {
        struct {
            __IO   uint8_t  FSI0                 :4;
            __IO   uint8_t  FSI1                 :4;
        };
        struct {
            __IO   uint8_t  FSI00                :1;
            __IO   uint8_t  FSI01                :1;
            __IO   uint8_t  FSI02                :1;
            __IO   uint8_t  FSI03                :1;
            __IO   uint8_t  FSI10                :1;
            __IO   uint8_t  FSI11                :1;
            __IO   uint8_t  FSI12                :1;
            __IO   uint8_t  FSI13                :1;
        };
    };
} stc_mft_icu_icfs10_field_t;

typedef struct stc_mft_icu_icfs32_field
{
    union {
        struct {
            __IO   uint8_t  FSI2                 :4;
            __IO   uint8_t  FSI3                 :4;
        };
        struct {
            __IO   uint8_t  FSI20                :1;
            __IO   uint8_t  FSI21                :1;
            __IO   uint8_t  FSI22                :1;
            __IO   uint8_t  FSI23                :1;
            __IO   uint8_t  FSI30                :1;
            __IO   uint8_t  FSI31                :1;
            __IO   uint8_t  FSI32                :1;
            __IO   uint8_t  FSI33                :1;
        };
    };
} stc_mft_icu_icfs32_field_t;

typedef struct stc_mft_adcmp_acfs10_field
{
    union {
        struct {
            __IO   uint8_t  FSA0                 :4;
            __IO   uint8_t  FSA1                 :4;
        };
        struct {
            __IO   uint8_t  FSA00                :1;
            __IO   uint8_t  FSA01                :1;
            __IO   uint8_t  FSA02                :1;
            __IO   uint8_t  FSA03                :1;
            __IO   uint8_t  FSA10                :1;
            __IO   uint8_t  FSA11                :1;
            __IO   uint8_t  FSA12                :1;
            __IO   uint8_t  FSA13                :1;
        };
    };
} stc_mft_adcmp_acfs10_field_t;

typedef struct stc_mft_adcmp_acfs32_field
{
    union {
        struct {
            __IO   uint8_t  FSA2                 :4;
            __IO   uint8_t  FSA3                 :4;
        };
        struct {
            __IO   uint8_t  FSA20                :1;
            __IO   uint8_t  FSA21                :1;
            __IO   uint8_t  FSA22                :1;
            __IO   uint8_t  FSA23                :1;
            __IO   uint8_t  FSA30                :1;
            __IO   uint8_t  FSA31                :1;
            __IO   uint8_t  FSA32                :1;
            __IO   uint8_t  FSA33                :1;
        };
    };
} stc_mft_adcmp_acfs32_field_t;

typedef struct stc_mft_adcmp_acfs54_field
{
    union {
        struct {
            __IO   uint8_t  FSA4                 :4;
            __IO   uint8_t  FSA5                 :4;
        };
        struct {
            __IO   uint8_t  FSA40                :1;
            __IO   uint8_t  FSA41                :1;
            __IO   uint8_t  FSA42                :1;
            __IO   uint8_t  FSA43                :1;
            __IO   uint8_t  FSA50                :1;
            __IO   uint8_t  FSA51                :1;
            __IO   uint8_t  FSA52                :1;
            __IO   uint8_t  FSA53                :1;
        };
    };
} stc_mft_adcmp_acfs54_field_t;

typedef struct stc_mft_icu_icsa10_field
{
    union {
        struct {
            __IO   uint8_t  EG0                  :2;
            __IO   uint8_t  EG1                  :2;
            __IO   uint8_t  ICE0                 :1;
            __IO   uint8_t  ICE1                 :1;
            __IO   uint8_t  ICP0                 :1;
            __IO   uint8_t  ICP1                 :1;
        };
        struct {
            __IO   uint8_t  EG00                 :1;
            __IO   uint8_t  EG01                 :1;
            __IO   uint8_t  EG10                 :1;
            __IO   uint8_t  EG11                 :1;
            __IO   uint8_t  RESERVED0            :4;
        };
    };
} stc_mft_icu_icsa10_field_t;

typedef struct stc_mft_icu_icsb10_field
{
        __IO   uint8_t  IEI0                     :1;
        __IO   uint8_t  IEI1                     :1;
        __IO   uint8_t  RESERVED0                :6;
} stc_mft_icu_icsb10_field_t;

typedef struct stc_mft_icu_icsa32_field
{
    union {
        struct {
            __IO   uint8_t  EG2                  :2;
            __IO   uint8_t  EG3                  :2;
            __IO   uint8_t  ICE2                 :1;
            __IO   uint8_t  ICE3                 :1;
            __IO   uint8_t  ICP2                 :1;
            __IO   uint8_t  ICP3                 :1;
        };
        struct {
            __IO   uint8_t  EG20                 :1;
            __IO   uint8_t  EG21                 :1;
            __IO   uint8_t  EG30                 :1;
            __IO   uint8_t  EG31                 :1;
            __IO   uint8_t  RESERVED0            :4;
        };
    };
} stc_mft_icu_icsa32_field_t;

typedef struct stc_mft_icu_icsb32_field
{
        __IO   uint8_t  IEI2                     :1;
        __IO   uint8_t  IEI3                     :1;
        __IO   uint8_t  RESERVED0                :6;
} stc_mft_icu_icsb32_field_t;

typedef struct stc_mft_wfg_wfsa10_field
{
    union {
        struct {
            __IO  uint16_t  DCK                  :3;
            __IO  uint16_t  TMD                  :3;
            __IO  uint16_t  GTEN                 :2;
            __IO  uint16_t  PSEL                 :2;
            __IO  uint16_t  PGEN                 :2;
            __IO  uint16_t  DMOD                 :2;
            __IO  uint16_t  RESERVED0            :2;
        };
        struct {
            __IO  uint16_t  DCK0                 :1;
            __IO  uint16_t  DCK1                 :1;
            __IO  uint16_t  DCK2                 :1;
            __IO  uint16_t  TMD0                 :1;
            __IO  uint16_t  TMD1                 :1;
            __IO  uint16_t  TMD2                 :1;
            __IO  uint16_t  GTEN0                :1;
            __IO  uint16_t  GTEN1                :1;
            __IO  uint16_t  PSEL0                :1;
            __IO  uint16_t  PSEL1                :1;
            __IO  uint16_t  PGEN0                :1;
            __IO  uint16_t  PGEN1                :1;
            __IO  uint16_t  DMOD0                :1;
            __IO  uint16_t  DMOD1                :1;
            __IO  uint16_t  RESERVED1            :2;
        };
    };
} stc_mft_wfg_wfsa10_field_t;

typedef struct stc_mft_wfg_wfsa32_field
{
    union {
        struct {
            __IO  uint16_t  DCK                  :3;
            __IO  uint16_t  TMD                  :3;
            __IO  uint16_t  GTEN                 :2;
            __IO  uint16_t  PSEL                 :2;
            __IO  uint16_t  PGEN                 :2;
            __IO  uint16_t  DMOD                 :2;
            __IO  uint16_t  RESERVED0            :2;
        };
        struct {
            __IO  uint16_t  DCK0                 :1;
            __IO  uint16_t  DCK1                 :1;
            __IO  uint16_t  DCK2                 :1;
            __IO  uint16_t  TMD0                 :1;
            __IO  uint16_t  TMD1                 :1;
            __IO  uint16_t  TMD2                 :1;
            __IO  uint16_t  GTEN0                :1;
            __IO  uint16_t  GTEN1                :1;
            __IO  uint16_t  PSEL0                :1;
            __IO  uint16_t  PSEL1                :1;
            __IO  uint16_t  PGEN0                :1;
            __IO  uint16_t  PGEN1                :1;
            __IO  uint16_t  DMOD0                :1;
            __IO  uint16_t  DMOD1                :1;
            __IO  uint16_t  RESERVED1            :2;
        };
    };
} stc_mft_wfg_wfsa32_field_t;

typedef struct stc_mft_wfg_wfsa54_field
{
    union {
        struct {
            __IO  uint16_t  DCK                  :3;
            __IO  uint16_t  TMD                  :3;
            __IO  uint16_t  GTEN                 :2;
            __IO  uint16_t  PSEL                 :2;
            __IO  uint16_t  PGEN                 :2;
            __IO  uint16_t  DMOD                 :2;
            __IO  uint16_t  RESERVED0            :2;
        };
        struct {
            __IO  uint16_t  DCK0                 :1;
            __IO  uint16_t  DCK1                 :1;
            __IO  uint16_t  DCK2                 :1;
            __IO  uint16_t  TMD0                 :1;
            __IO  uint16_t  TMD1                 :1;
            __IO  uint16_t  TMD2                 :1;
            __IO  uint16_t  GTEN0                :1;
            __IO  uint16_t  GTEN1                :1;
            __IO  uint16_t  PSEL0                :1;
            __IO  uint16_t  PSEL1                :1;
            __IO  uint16_t  PGEN0                :1;
            __IO  uint16_t  PGEN1                :1;
            __IO  uint16_t  DMOD0                :1;
            __IO  uint16_t  DMOD1                :1;
            __IO  uint16_t  RESERVED1            :2;
        };
    };
} stc_mft_wfg_wfsa54_field_t;

typedef struct stc_mft_wfg_wfir_field
{
        __IO  uint16_t  DTIFA                    :1;
        __IO  uint16_t  DTICA                    :1;
        __IO  uint16_t  DTIFB                    :1;
        __IO  uint16_t  DTICB                    :1;
        __IO  uint16_t  TMIF10                   :1;
        __IO  uint16_t  TMIC10                   :1;
        __IO  uint16_t  TMIE10                   :1;
        __IO  uint16_t  TMIS10                   :1;
        __IO  uint16_t  TMIF32                   :1;
        __IO  uint16_t  TMIC32                   :1;
        __IO  uint16_t  TMIE32                   :1;
        __IO  uint16_t  TMIS32                   :1;
        __IO  uint16_t  TMIF54                   :1;
        __IO  uint16_t  TMIC54                   :1;
        __IO  uint16_t  TMIE54                   :1;
        __IO  uint16_t  TMIS54                   :1;
} stc_mft_wfg_wfir_field_t;

typedef struct stc_mft_wfg_nzcl_field
{
    union {
        struct {
            __IO  uint16_t  DTIEA                :1;
            __IO  uint16_t  NWS                  :3;
            __IO  uint16_t  SDTI                 :1;
            __IO  uint16_t  DTIEB                :1;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  DHOLD                :1;
            __IO  uint16_t  DIMA                 :1;
            __IO  uint16_t  DIMB                 :1;
            __IO  uint16_t  RESERVED2            :2;
            __IO  uint16_t  WIM10                :1;
            __IO  uint16_t  WIM32                :1;
            __IO  uint16_t  WIM54                :1;
            __IO  uint16_t  RESERVED3            :1;
        };
        struct {
            __IO  uint16_t  RESERVED0            :1;
            __IO  uint16_t  NWS0                 :1;
            __IO  uint16_t  NWS1                 :1;
            __IO  uint16_t  NWS2                 :1;
            __IO  uint16_t  RESERVED4            :12;
        };
    };
} stc_mft_wfg_nzcl_field_t;

typedef struct stc_mft_adcmp_acmp0_field
{
    union {
        struct {
            __IO  uint16_t  ACMP                 :16;
        };
        struct {
            __IO  uint16_t  ACMP0                :1;
            __IO  uint16_t  ACMP1                :1;
            __IO  uint16_t  ACMP2                :1;
            __IO  uint16_t  ACMP3                :1;
            __IO  uint16_t  ACMP4                :1;
            __IO  uint16_t  ACMP5                :1;
            __IO  uint16_t  ACMP6                :1;
            __IO  uint16_t  ACMP7                :1;
            __IO  uint16_t  ACMP8                :1;
            __IO  uint16_t  ACMP9                :1;
            __IO  uint16_t  ACMP10               :1;
            __IO  uint16_t  ACMP11               :1;
            __IO  uint16_t  ACMP12               :1;
            __IO  uint16_t  ACMP13               :1;
            __IO  uint16_t  ACMP14               :1;
            __IO  uint16_t  ACMP15               :1;
        };
    };
} stc_mft_adcmp_acmp0_field_t;

typedef struct stc_mft_adcmp_acmp1_field
{
    union {
        struct {
            __IO  uint16_t  ACMP                 :16;
        };
        struct {
            __IO  uint16_t  ACMP0                :1;
            __IO  uint16_t  ACMP1                :1;
            __IO  uint16_t  ACMP2                :1;
            __IO  uint16_t  ACMP3                :1;
            __IO  uint16_t  ACMP4                :1;
            __IO  uint16_t  ACMP5                :1;
            __IO  uint16_t  ACMP6                :1;
            __IO  uint16_t  ACMP7                :1;
            __IO  uint16_t  ACMP8                :1;
            __IO  uint16_t  ACMP9                :1;
            __IO  uint16_t  ACMP10               :1;
            __IO  uint16_t  ACMP11               :1;
            __IO  uint16_t  ACMP12               :1;
            __IO  uint16_t  ACMP13               :1;
            __IO  uint16_t  ACMP14               :1;
            __IO  uint16_t  ACMP15               :1;
        };
    };
} stc_mft_adcmp_acmp1_field_t;

typedef struct stc_mft_adcmp_acmp2_field
{
    union {
        struct {
            __IO  uint16_t  ACMP                 :16;
        };
        struct {
            __IO  uint16_t  ACMP0                :1;
            __IO  uint16_t  ACMP1                :1;
            __IO  uint16_t  ACMP2                :1;
            __IO  uint16_t  ACMP3                :1;
            __IO  uint16_t  ACMP4                :1;
            __IO  uint16_t  ACMP5                :1;
            __IO  uint16_t  ACMP6                :1;
            __IO  uint16_t  ACMP7                :1;
            __IO  uint16_t  ACMP8                :1;
            __IO  uint16_t  ACMP9                :1;
            __IO  uint16_t  ACMP10               :1;
            __IO  uint16_t  ACMP11               :1;
            __IO  uint16_t  ACMP12               :1;
            __IO  uint16_t  ACMP13               :1;
            __IO  uint16_t  ACMP14               :1;
            __IO  uint16_t  ACMP15               :1;
        };
    };
} stc_mft_adcmp_acmp2_field_t;

typedef struct stc_mft_adcmp_acmp3_field
{
    union {
        struct {
            __IO  uint16_t  ACMP                 :16;
        };
        struct {
            __IO  uint16_t  ACMP0                :1;
            __IO  uint16_t  ACMP1                :1;
            __IO  uint16_t  ACMP2                :1;
            __IO  uint16_t  ACMP3                :1;
            __IO  uint16_t  ACMP4                :1;
            __IO  uint16_t  ACMP5                :1;
            __IO  uint16_t  ACMP6                :1;
            __IO  uint16_t  ACMP7                :1;
            __IO  uint16_t  ACMP8                :1;
            __IO  uint16_t  ACMP9                :1;
            __IO  uint16_t  ACMP10               :1;
            __IO  uint16_t  ACMP11               :1;
            __IO  uint16_t  ACMP12               :1;
            __IO  uint16_t  ACMP13               :1;
            __IO  uint16_t  ACMP14               :1;
            __IO  uint16_t  ACMP15               :1;
        };
    };
} stc_mft_adcmp_acmp3_field_t;

typedef struct stc_mft_adcmp_acmp4_field
{
    union {
        struct {
            __IO  uint16_t  ACMP                 :16;
        };
        struct {
            __IO  uint16_t  ACMP0                :1;
            __IO  uint16_t  ACMP1                :1;
            __IO  uint16_t  ACMP2                :1;
            __IO  uint16_t  ACMP3                :1;
            __IO  uint16_t  ACMP4                :1;
            __IO  uint16_t  ACMP5                :1;
            __IO  uint16_t  ACMP6                :1;
            __IO  uint16_t  ACMP7                :1;
            __IO  uint16_t  ACMP8                :1;
            __IO  uint16_t  ACMP9                :1;
            __IO  uint16_t  ACMP10               :1;
            __IO  uint16_t  ACMP11               :1;
            __IO  uint16_t  ACMP12               :1;
            __IO  uint16_t  ACMP13               :1;
            __IO  uint16_t  ACMP14               :1;
            __IO  uint16_t  ACMP15               :1;
        };
    };
} stc_mft_adcmp_acmp4_field_t;

typedef struct stc_mft_adcmp_acmp5_field
{
    union {
        struct {
            __IO  uint16_t  ACMP                 :16;
        };
        struct {
            __IO  uint16_t  ACMP0                :1;
            __IO  uint16_t  ACMP1                :1;
            __IO  uint16_t  ACMP2                :1;
            __IO  uint16_t  ACMP3                :1;
            __IO  uint16_t  ACMP4                :1;
            __IO  uint16_t  ACMP5                :1;
            __IO  uint16_t  ACMP6                :1;
            __IO  uint16_t  ACMP7                :1;
            __IO  uint16_t  ACMP8                :1;
            __IO  uint16_t  ACMP9                :1;
            __IO  uint16_t  ACMP10               :1;
            __IO  uint16_t  ACMP11               :1;
            __IO  uint16_t  ACMP12               :1;
            __IO  uint16_t  ACMP13               :1;
            __IO  uint16_t  ACMP14               :1;
            __IO  uint16_t  ACMP15               :1;
        };
    };
} stc_mft_adcmp_acmp5_field_t;

typedef struct stc_mft_adcmp_acsa_field
{
    union {
        struct {
            __IO  uint16_t  CE10                 :2;
            __IO  uint16_t  CE32                 :2;
            __IO  uint16_t  CE54                 :2;
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  SEL10                :2;
            __IO  uint16_t  SEL32                :2;
            __IO  uint16_t  SEL54                :2;
            __IO  uint16_t  RESERVED2            :2;
        };
        struct {
            __IO  uint16_t  CE100                :1;
            __IO  uint16_t  CE101                :1;
            __IO  uint16_t  CE320                :1;
            __IO  uint16_t  CE321                :1;
            __IO  uint16_t  CE540                :1;
            __IO  uint16_t  CE541                :1;
            __IO  uint16_t  RESERVED1            :2;
            __IO  uint16_t  SEL100               :1;
            __IO  uint16_t  SEL101               :1;
            __IO  uint16_t  SEL320               :1;
            __IO  uint16_t  SEL321               :1;
            __IO  uint16_t  SEL540               :1;
            __IO  uint16_t  SEL541               :1;
            __IO  uint16_t  RESERVED3            :2;
        };
    };
} stc_mft_adcmp_acsa_field_t;

typedef struct stc_mft_adcmp_acsc0_field
{
    union {
        struct {
            __IO   uint8_t  BUFE                 :2;
            __IO   uint8_t  ADSEL                :3;
            __IO   uint8_t  APBM                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  BUFE0                :1;
            __IO   uint8_t  BUFE1                :1;
            __IO   uint8_t  ADSEL0               :1;
            __IO   uint8_t  ADSEL1               :1;
            __IO   uint8_t  ADSEL2               :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_adcmp_acsc0_field_t;

typedef struct stc_mft_adcmp_acsd0_field
{
        __IO   uint8_t  AMOD                     :1;
        __IO   uint8_t  OCUS                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  DE                       :1;
        __IO   uint8_t  PE                       :1;
        __IO   uint8_t  UE                       :1;
        __IO   uint8_t  ZE                       :1;
} stc_mft_adcmp_acsd0_field_t;

typedef struct stc_mft_adcmp_acmc0_field
{
    union {
        struct {
            __IO   uint8_t  AMC                  :4;
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  MZCE                 :1;
            __IO   uint8_t  MPCE                 :1;
        };
        struct {
            __IO   uint8_t  AMC0                 :1;
            __IO   uint8_t  AMC1                 :1;
            __IO   uint8_t  AMC2                 :1;
            __IO   uint8_t  AMC3                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_adcmp_acmc0_field_t;

typedef struct stc_mft_adcmp_acsc1_field
{
    union {
        struct {
            __IO   uint8_t  BUFE                 :2;
            __IO   uint8_t  ADSEL                :3;
            __IO   uint8_t  APBM                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  BUFE0                :1;
            __IO   uint8_t  BUFE1                :1;
            __IO   uint8_t  ADSEL0               :1;
            __IO   uint8_t  ADSEL1               :1;
            __IO   uint8_t  ADSEL2               :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_adcmp_acsc1_field_t;

typedef struct stc_mft_adcmp_acsd1_field
{
        __IO   uint8_t  AMOD                     :1;
        __IO   uint8_t  OCUS                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  DE                       :1;
        __IO   uint8_t  PE                       :1;
        __IO   uint8_t  UE                       :1;
        __IO   uint8_t  ZE                       :1;
} stc_mft_adcmp_acsd1_field_t;

typedef struct stc_mft_adcmp_acmc1_field
{
    union {
        struct {
            __IO   uint8_t  AMC                  :4;
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  MZCE                 :1;
            __IO   uint8_t  MPCE                 :1;
        };
        struct {
            __IO   uint8_t  AMC0                 :1;
            __IO   uint8_t  AMC1                 :1;
            __IO   uint8_t  AMC2                 :1;
            __IO   uint8_t  AMC3                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_adcmp_acmc1_field_t;

typedef struct stc_mft_adcmp_acsc2_field
{
    union {
        struct {
            __IO   uint8_t  BUFE                 :2;
            __IO   uint8_t  ADSEL                :3;
            __IO   uint8_t  APBM                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  BUFE0                :1;
            __IO   uint8_t  BUFE1                :1;
            __IO   uint8_t  ADSEL0               :1;
            __IO   uint8_t  ADSEL1               :1;
            __IO   uint8_t  ADSEL2               :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_adcmp_acsc2_field_t;

typedef struct stc_mft_adcmp_acsd2_field
{
        __IO   uint8_t  AMOD                     :1;
        __IO   uint8_t  OCUS                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  DE                       :1;
        __IO   uint8_t  PE                       :1;
        __IO   uint8_t  UE                       :1;
        __IO   uint8_t  ZE                       :1;
} stc_mft_adcmp_acsd2_field_t;

typedef struct stc_mft_adcmp_acmc2_field
{
    union {
        struct {
            __IO   uint8_t  AMC                  :4;
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  MZCE                 :1;
            __IO   uint8_t  MPCE                 :1;
        };
        struct {
            __IO   uint8_t  AMC0                 :1;
            __IO   uint8_t  AMC1                 :1;
            __IO   uint8_t  AMC2                 :1;
            __IO   uint8_t  AMC3                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_adcmp_acmc2_field_t;

typedef struct stc_mft_adcmp_acsc3_field
{
    union {
        struct {
            __IO   uint8_t  BUFE                 :2;
            __IO   uint8_t  ADSEL                :3;
            __IO   uint8_t  APBM                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  BUFE0                :1;
            __IO   uint8_t  BUFE1                :1;
            __IO   uint8_t  ADSEL0               :1;
            __IO   uint8_t  ADSEL1               :1;
            __IO   uint8_t  ADSEL2               :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_adcmp_acsc3_field_t;

typedef struct stc_mft_adcmp_acsd3_field
{
        __IO   uint8_t  AMOD                     :1;
        __IO   uint8_t  OCUS                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  DE                       :1;
        __IO   uint8_t  PE                       :1;
        __IO   uint8_t  UE                       :1;
        __IO   uint8_t  ZE                       :1;
} stc_mft_adcmp_acsd3_field_t;

typedef struct stc_mft_adcmp_acmc3_field
{
    union {
        struct {
            __IO   uint8_t  AMC                  :4;
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  MZCE                 :1;
            __IO   uint8_t  MPCE                 :1;
        };
        struct {
            __IO   uint8_t  AMC0                 :1;
            __IO   uint8_t  AMC1                 :1;
            __IO   uint8_t  AMC2                 :1;
            __IO   uint8_t  AMC3                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_adcmp_acmc3_field_t;

typedef struct stc_mft_adcmp_acsc4_field
{
    union {
        struct {
            __IO   uint8_t  BUFE                 :2;
            __IO   uint8_t  ADSEL                :3;
            __IO   uint8_t  APBM                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  BUFE0                :1;
            __IO   uint8_t  BUFE1                :1;
            __IO   uint8_t  ADSEL0               :1;
            __IO   uint8_t  ADSEL1               :1;
            __IO   uint8_t  ADSEL2               :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_adcmp_acsc4_field_t;

typedef struct stc_mft_adcmp_acsd4_field
{
        __IO   uint8_t  AMOD                     :1;
        __IO   uint8_t  OCUS                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  DE                       :1;
        __IO   uint8_t  PE                       :1;
        __IO   uint8_t  UE                       :1;
        __IO   uint8_t  ZE                       :1;
} stc_mft_adcmp_acsd4_field_t;

typedef struct stc_mft_adcmp_acmc4_field
{
    union {
        struct {
            __IO   uint8_t  AMC                  :4;
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  MZCE                 :1;
            __IO   uint8_t  MPCE                 :1;
        };
        struct {
            __IO   uint8_t  AMC0                 :1;
            __IO   uint8_t  AMC1                 :1;
            __IO   uint8_t  AMC2                 :1;
            __IO   uint8_t  AMC3                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_adcmp_acmc4_field_t;

typedef struct stc_mft_adcmp_acsc5_field
{
    union {
        struct {
            __IO   uint8_t  BUFE                 :2;
            __IO   uint8_t  ADSEL                :3;
            __IO   uint8_t  APBM                 :1;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  BUFE0                :1;
            __IO   uint8_t  BUFE1                :1;
            __IO   uint8_t  ADSEL0               :1;
            __IO   uint8_t  ADSEL1               :1;
            __IO   uint8_t  ADSEL2               :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_adcmp_acsc5_field_t;

typedef struct stc_mft_adcmp_acsd5_field
{
        __IO   uint8_t  AMOD                     :1;
        __IO   uint8_t  OCUS                     :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  DE                       :1;
        __IO   uint8_t  PE                       :1;
        __IO   uint8_t  UE                       :1;
        __IO   uint8_t  ZE                       :1;
} stc_mft_adcmp_acsd5_field_t;

typedef struct stc_mft_adcmp_acmc5_field
{
    union {
        struct {
            __IO   uint8_t  AMC                  :4;
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  MZCE                 :1;
            __IO   uint8_t  MPCE                 :1;
        };
        struct {
            __IO   uint8_t  AMC0                 :1;
            __IO   uint8_t  AMC1                 :1;
            __IO   uint8_t  AMC2                 :1;
            __IO   uint8_t  AMC3                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_adcmp_acmc5_field_t;

typedef struct stc_mft_frt_tcsd_field
{
        __IO   uint8_t  OFMD1                    :1;
        __IO   uint8_t  OFMD2                    :1;
        __IO   uint8_t  RESERVED0                :6;
} stc_mft_frt_tcsd_field_t;

/******************************************************************************
 ** MFT_PPG_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_mft_ppg_ttcr0_field
{
    union {
        struct {
            __IO   uint8_t  STR0                 :1;
            __IO   uint8_t  MONI0                :1;
            __IO   uint8_t  CS0                  :2;
            __IO   uint8_t  TRG0O                :1;
            __IO   uint8_t  TRG2O                :1;
            __IO   uint8_t  TRG4O                :1;
            __IO   uint8_t  TRG6O                :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  CS00                 :1;
            __IO   uint8_t  CS01                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_ppg_ttcr0_field_t;

typedef struct stc_mft_ppg_ttcr1_field
{
    union {
        struct {
            __IO   uint8_t  STR1                 :1;
            __IO   uint8_t  MONI1                :1;
            __IO   uint8_t  CS1                  :2;
            __IO   uint8_t  TRG1O                :1;
            __IO   uint8_t  TRG3O                :1;
            __IO   uint8_t  TRG5O                :1;
            __IO   uint8_t  TRG7O                :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  CS10                 :1;
            __IO   uint8_t  CS11                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_ppg_ttcr1_field_t;

typedef struct stc_mft_ppg_ttcr2_field
{
    union {
        struct {
            __IO   uint8_t  STR2                 :1;
            __IO   uint8_t  MONI2                :1;
            __IO   uint8_t  CS2                  :2;
            __IO   uint8_t  TRG16O               :1;
            __IO   uint8_t  TRG18O               :1;
            __IO   uint8_t  TRG20O               :1;
            __IO   uint8_t  TRG22O               :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :2;
            __IO   uint8_t  CS20                 :1;
            __IO   uint8_t  CS21                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_mft_ppg_ttcr2_field_t;

typedef struct stc_mft_ppg_trg0_field
{
        __IO  uint16_t  PEN00                    :1;
        __IO  uint16_t  PEN01                    :1;
        __IO  uint16_t  PEN02                    :1;
        __IO  uint16_t  PEN03                    :1;
        __IO  uint16_t  PEN04                    :1;
        __IO  uint16_t  PEN05                    :1;
        __IO  uint16_t  PEN06                    :1;
        __IO  uint16_t  PEN07                    :1;
        __IO  uint16_t  PEN08                    :1;
        __IO  uint16_t  PEN09                    :1;
        __IO  uint16_t  PEN10                    :1;
        __IO  uint16_t  PEN11                    :1;
        __IO  uint16_t  PEN12                    :1;
        __IO  uint16_t  PEN13                    :1;
        __IO  uint16_t  PEN14                    :1;
        __IO  uint16_t  PEN15                    :1;
} stc_mft_ppg_trg0_field_t;

typedef struct stc_mft_ppg_revc0_field
{
        __IO  uint16_t  REV00                    :1;
        __IO  uint16_t  REV01                    :1;
        __IO  uint16_t  REV02                    :1;
        __IO  uint16_t  REV03                    :1;
        __IO  uint16_t  REV04                    :1;
        __IO  uint16_t  REV05                    :1;
        __IO  uint16_t  REV06                    :1;
        __IO  uint16_t  REV07                    :1;
        __IO  uint16_t  REV08                    :1;
        __IO  uint16_t  REV09                    :1;
        __IO  uint16_t  REV10                    :1;
        __IO  uint16_t  REV11                    :1;
        __IO  uint16_t  REV12                    :1;
        __IO  uint16_t  REV13                    :1;
        __IO  uint16_t  REV14                    :1;
        __IO  uint16_t  REV15                    :1;
} stc_mft_ppg_revc0_field_t;

typedef struct stc_mft_ppg_trg1_field
{
        __IO  uint16_t  PEN16                    :1;
        __IO  uint16_t  PEN17                    :1;
        __IO  uint16_t  PEN18                    :1;
        __IO  uint16_t  PEN19                    :1;
        __IO  uint16_t  PEN20                    :1;
        __IO  uint16_t  PEN21                    :1;
        __IO  uint16_t  PEN22                    :1;
        __IO  uint16_t  PEN23                    :1;
        __IO  uint16_t  RESERVED0                :8;
} stc_mft_ppg_trg1_field_t;

typedef struct stc_mft_ppg_revc1_field
{
        __IO  uint16_t  REV16                    :1;
        __IO  uint16_t  REV17                    :1;
        __IO  uint16_t  REV18                    :1;
        __IO  uint16_t  REV19                    :1;
        __IO  uint16_t  REV20                    :1;
        __IO  uint16_t  REV21                    :1;
        __IO  uint16_t  REV22                    :1;
        __IO  uint16_t  REV23                    :1;
        __IO  uint16_t  RESERVED0                :8;
} stc_mft_ppg_revc1_field_t;

typedef struct stc_mft_ppg_ppgc1_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED0            :3;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED1            :3;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED2            :3;
        };
    };
} stc_mft_ppg_ppgc1_field_t;

typedef struct stc_mft_ppg_ppgc0_field
{
    union {
        struct {
            __IO   uint8_t  TTRG                 :1;
            __IO   uint8_t  MD                   :2;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_ppg_ppgc0_field_t;

typedef struct stc_mft_ppg_ppgc3_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED0            :3;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED1            :3;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED2            :3;
        };
    };
} stc_mft_ppg_ppgc3_field_t;

typedef struct stc_mft_ppg_ppgc2_field
{
    union {
        struct {
            __IO   uint8_t  TTRG                 :1;
            __IO   uint8_t  MD                   :2;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_ppg_ppgc2_field_t;

typedef struct stc_mft_ppg_prll0_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll0_field_t;

typedef struct stc_mft_ppg_prlh0_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh0_field_t;

typedef struct stc_mft_ppg_prll1_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll1_field_t;

typedef struct stc_mft_ppg_prlh1_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh1_field_t;

typedef struct stc_mft_ppg_prll2_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll2_field_t;

typedef struct stc_mft_ppg_prlh2_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh2_field_t;

typedef struct stc_mft_ppg_prll3_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll3_field_t;

typedef struct stc_mft_ppg_prlh3_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh3_field_t;

typedef struct stc_mft_ppg_gatec0_field
{
        __IO   uint8_t  EDGE0                    :1;
        __IO   uint8_t  STRG0                    :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  EDGE2                    :1;
        __IO   uint8_t  STRG2                    :1;
        __IO   uint8_t  RESERVED1                :2;
} stc_mft_ppg_gatec0_field_t;

typedef struct stc_mft_ppg_ppgc5_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED0            :3;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED1            :3;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED2            :3;
        };
    };
} stc_mft_ppg_ppgc5_field_t;

typedef struct stc_mft_ppg_ppgc4_field
{
    union {
        struct {
            __IO   uint8_t  TTRG                 :1;
            __IO   uint8_t  MD                   :2;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_ppg_ppgc4_field_t;

typedef struct stc_mft_ppg_ppgc7_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED0            :3;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED1            :3;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED2            :3;
        };
    };
} stc_mft_ppg_ppgc7_field_t;

typedef struct stc_mft_ppg_ppgc6_field
{
    union {
        struct {
            __IO   uint8_t  TTRG                 :1;
            __IO   uint8_t  MD                   :2;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_ppg_ppgc6_field_t;

typedef struct stc_mft_ppg_prll4_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll4_field_t;

typedef struct stc_mft_ppg_prlh4_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh4_field_t;

typedef struct stc_mft_ppg_prll5_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll5_field_t;

typedef struct stc_mft_ppg_prlh5_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh5_field_t;

typedef struct stc_mft_ppg_prll6_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll6_field_t;

typedef struct stc_mft_ppg_prlh6_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh6_field_t;

typedef struct stc_mft_ppg_prll7_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll7_field_t;

typedef struct stc_mft_ppg_prlh7_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh7_field_t;

typedef struct stc_mft_ppg_gatec4_field
{
        __IO   uint8_t  EDGE4                    :1;
        __IO   uint8_t  STRG4                    :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  EDGE6                    :1;
        __IO   uint8_t  STRG6                    :1;
        __IO   uint8_t  RESERVED1                :2;
} stc_mft_ppg_gatec4_field_t;

typedef struct stc_mft_ppg_ppgc9_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED0            :3;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED1            :3;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED2            :3;
        };
    };
} stc_mft_ppg_ppgc9_field_t;

typedef struct stc_mft_ppg_ppgc8_field
{
    union {
        struct {
            __IO   uint8_t  TTRG                 :1;
            __IO   uint8_t  MD                   :2;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_ppg_ppgc8_field_t;

typedef struct stc_mft_ppg_ppgc11_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED0            :3;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED1            :3;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED2            :3;
        };
    };
} stc_mft_ppg_ppgc11_field_t;

typedef struct stc_mft_ppg_ppgc10_field
{
    union {
        struct {
            __IO   uint8_t  TTRG                 :1;
            __IO   uint8_t  MD                   :2;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_ppg_ppgc10_field_t;

typedef struct stc_mft_ppg_prll8_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll8_field_t;

typedef struct stc_mft_ppg_prlh8_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh8_field_t;

typedef struct stc_mft_ppg_prll9_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll9_field_t;

typedef struct stc_mft_ppg_prlh9_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh9_field_t;

typedef struct stc_mft_ppg_prll10_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll10_field_t;

typedef struct stc_mft_ppg_prlh10_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh10_field_t;

typedef struct stc_mft_ppg_prll11_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll11_field_t;

typedef struct stc_mft_ppg_prlh11_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh11_field_t;

typedef struct stc_mft_ppg_gatec8_field
{
        __IO   uint8_t  EDGE8                    :1;
        __IO   uint8_t  STRG8                    :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  EDGE10                   :1;
        __IO   uint8_t  STRG10                   :1;
        __IO   uint8_t  RESERVED1                :2;
} stc_mft_ppg_gatec8_field_t;

typedef struct stc_mft_ppg_ppgc13_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED0            :3;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED1            :3;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED2            :3;
        };
    };
} stc_mft_ppg_ppgc13_field_t;

typedef struct stc_mft_ppg_ppgc12_field
{
    union {
        struct {
            __IO   uint8_t  TTRG                 :1;
            __IO   uint8_t  MD                   :2;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_ppg_ppgc12_field_t;

typedef struct stc_mft_ppg_ppgc15_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED0            :3;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED1            :3;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED2            :3;
        };
    };
} stc_mft_ppg_ppgc15_field_t;

typedef struct stc_mft_ppg_ppgc14_field
{
    union {
        struct {
            __IO   uint8_t  TTRG                 :1;
            __IO   uint8_t  MD                   :2;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_ppg_ppgc14_field_t;

typedef struct stc_mft_ppg_prll12_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll12_field_t;

typedef struct stc_mft_ppg_prlh12_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh12_field_t;

typedef struct stc_mft_ppg_prll13_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll13_field_t;

typedef struct stc_mft_ppg_prlh13_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh13_field_t;

typedef struct stc_mft_ppg_prll14_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll14_field_t;

typedef struct stc_mft_ppg_prlh14_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh14_field_t;

typedef struct stc_mft_ppg_prll15_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll15_field_t;

typedef struct stc_mft_ppg_prlh15_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh15_field_t;

typedef struct stc_mft_ppg_gatec12_field
{
        __IO   uint8_t  EDGE12                   :1;
        __IO   uint8_t  STRG12                   :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  EDGE14                   :1;
        __IO   uint8_t  STRG14                   :1;
        __IO   uint8_t  RESERVED1                :2;
} stc_mft_ppg_gatec12_field_t;

typedef struct stc_mft_ppg_ppgc17_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED0            :3;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED1            :3;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED2            :3;
        };
    };
} stc_mft_ppg_ppgc17_field_t;

typedef struct stc_mft_ppg_ppgc16_field
{
    union {
        struct {
            __IO   uint8_t  TTRG                 :1;
            __IO   uint8_t  MD                   :2;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_ppg_ppgc16_field_t;

typedef struct stc_mft_ppg_ppgc19_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED0            :3;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED1            :3;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED2            :3;
        };
    };
} stc_mft_ppg_ppgc19_field_t;

typedef struct stc_mft_ppg_ppgc18_field
{
    union {
        struct {
            __IO   uint8_t  TTRG                 :1;
            __IO   uint8_t  MD                   :2;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_ppg_ppgc18_field_t;

typedef struct stc_mft_ppg_prll16_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll16_field_t;

typedef struct stc_mft_ppg_prlh16_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh16_field_t;

typedef struct stc_mft_ppg_prll17_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll17_field_t;

typedef struct stc_mft_ppg_prlh17_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh17_field_t;

typedef struct stc_mft_ppg_prll18_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll18_field_t;

typedef struct stc_mft_ppg_prlh18_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh18_field_t;

typedef struct stc_mft_ppg_prll19_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll19_field_t;

typedef struct stc_mft_ppg_prlh19_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh19_field_t;

typedef struct stc_mft_ppg_gatec16_field
{
        __IO   uint8_t  EDGE16                   :1;
        __IO   uint8_t  STRG16                   :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  EDGE18                   :1;
        __IO   uint8_t  STRG18                   :1;
        __IO   uint8_t  RESERVED1                :2;
} stc_mft_ppg_gatec16_field_t;

typedef struct stc_mft_ppg_ppgc21_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED0            :3;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED1            :3;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED2            :3;
        };
    };
} stc_mft_ppg_ppgc21_field_t;

typedef struct stc_mft_ppg_ppgc20_field
{
    union {
        struct {
            __IO   uint8_t  TTRG                 :1;
            __IO   uint8_t  MD                   :2;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_ppg_ppgc20_field_t;

typedef struct stc_mft_ppg_ppgc23_field
{
    union {
        struct {
            __IO   uint8_t  RESERVED0            :3;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED1            :3;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED2            :3;
        };
    };
} stc_mft_ppg_ppgc23_field_t;

typedef struct stc_mft_ppg_ppgc22_field
{
    union {
        struct {
            __IO   uint8_t  TTRG                 :1;
            __IO   uint8_t  MD                   :2;
            __IO   uint8_t  PCS                  :2;
            __IO   uint8_t  INTM                 :1;
            __IO   uint8_t  PUF                  :1;
            __IO   uint8_t  PIE                  :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  MD0                  :1;
            __IO   uint8_t  MD1                  :1;
            __IO   uint8_t  PCS0                 :1;
            __IO   uint8_t  PCS1                 :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_mft_ppg_ppgc22_field_t;

typedef struct stc_mft_ppg_prll20_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll20_field_t;

typedef struct stc_mft_ppg_prlh20_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh20_field_t;

typedef struct stc_mft_ppg_prll21_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll21_field_t;

typedef struct stc_mft_ppg_prlh21_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh21_field_t;

typedef struct stc_mft_ppg_prll22_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll22_field_t;

typedef struct stc_mft_ppg_prlh22_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh22_field_t;

typedef struct stc_mft_ppg_prll23_field
{
    union {
        struct {
            __IO   uint8_t  PRLL                 :8;
        };
        struct {
            __IO   uint8_t  PRLL0                :1;
            __IO   uint8_t  PRLL1                :1;
            __IO   uint8_t  PRLL2                :1;
            __IO   uint8_t  PRLL3                :1;
            __IO   uint8_t  PRLL4                :1;
            __IO   uint8_t  PRLL5                :1;
            __IO   uint8_t  PRLL6                :1;
            __IO   uint8_t  PRLL7                :1;
        };
    };
} stc_mft_ppg_prll23_field_t;

typedef struct stc_mft_ppg_prlh23_field
{
    union {
        struct {
            __IO   uint8_t  PRLH                 :8;
        };
        struct {
            __IO   uint8_t  PRLH0                :1;
            __IO   uint8_t  PRLH1                :1;
            __IO   uint8_t  PRLH2                :1;
            __IO   uint8_t  PRLH3                :1;
            __IO   uint8_t  PRLH4                :1;
            __IO   uint8_t  PRLH5                :1;
            __IO   uint8_t  PRLH6                :1;
            __IO   uint8_t  PRLH7                :1;
        };
    };
} stc_mft_ppg_prlh23_field_t;

typedef struct stc_mft_ppg_gatec20_field
{
        __IO   uint8_t  EDGE20                   :1;
        __IO   uint8_t  STRG20                   :1;
        __IO   uint8_t  RESERVED0                :2;
        __IO   uint8_t  EDGE22                   :1;
        __IO   uint8_t  STRG22                   :1;
        __IO   uint8_t  RESERVED1                :2;
} stc_mft_ppg_gatec20_field_t;

/******************************************************************************
 ** QPRC_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_qprc_qicrl_field
{
        __IO   uint8_t  QPCMIE                   :1;
        __IO   uint8_t  QPCMF                    :1;
        __IO   uint8_t  QPRCMIE                  :1;
        __IO   uint8_t  QPRCMF                   :1;
        __IO   uint8_t  OUZIE                    :1;
        __IO   uint8_t  UFDF                     :1;
        __IO   uint8_t  OFDF                     :1;
        __IO   uint8_t  ZIIF                     :1;
} stc_qprc_qicrl_field_t;

typedef struct stc_qprc_qicrh_field
{
        __IO   uint8_t  CDCIE                    :1;
        __IO   uint8_t  CDCF                     :1;
        __IO   uint8_t  DIRPC                    :1;
        __IO   uint8_t  DIROU                    :1;
        __IO   uint8_t  QPCNRCMIE                :1;
        __IO   uint8_t  QPCNRCMF                 :1;
        __IO   uint8_t  RESERVED0                :2;
} stc_qprc_qicrh_field_t;

typedef struct stc_qprc_qcr_field
{
    union {
        struct {
            __IO  uint16_t  PCM                  :2;
            __IO  uint16_t  RCM                  :2;
            __IO  uint16_t  PSTP                 :1;
            __IO  uint16_t  CGSC                 :1;
            __IO  uint16_t  RSEL                 :1;
            __IO  uint16_t  SWAP                 :1;
            __IO  uint16_t  PCRM                 :2;
            __IO  uint16_t  AES                  :2;
            __IO  uint16_t  BES                  :2;
            __IO  uint16_t  CGE                  :2;
        };
        struct {
            __IO  uint16_t  PCM0                 :1;
            __IO  uint16_t  PCM1                 :1;
            __IO  uint16_t  RCM0                 :1;
            __IO  uint16_t  RCM1                 :1;
            __IO  uint16_t  RESERVED0            :4;
            __IO  uint16_t  PCRM0                :1;
            __IO  uint16_t  PCRM1                :1;
            __IO  uint16_t  AES0                 :1;
            __IO  uint16_t  AES1                 :1;
            __IO  uint16_t  BES0                 :1;
            __IO  uint16_t  BES1                 :1;
            __IO  uint16_t  CGE0                 :1;
            __IO  uint16_t  CGE1                 :1;
        };
    };
} stc_qprc_qcr_field_t;

typedef struct stc_qprc_qecr_field
{
        __IO  uint16_t  ORNGMD                   :1;
        __IO  uint16_t  ORNGF                    :1;
        __IO  uint16_t  ORNGIE                   :1;
        __IO  uint16_t  PEC                      :1;
        __IO  uint16_t  RESERVED0                :12;
} stc_qprc_qecr_field_t;

typedef struct stc_qprc_qprcrr_field
{
    union {
        struct {
            __IO  uint32_t  QPCRR                :16;
            __IO  uint32_t  QRCRR                :16;
        };
        struct {
            __IO  uint32_t  QPCRR0               :1;
            __IO  uint32_t  QPCRR1               :1;
            __IO  uint32_t  QPCRR2               :1;
            __IO  uint32_t  QPCRR3               :1;
            __IO  uint32_t  QPCRR4               :1;
            __IO  uint32_t  QPCRR5               :1;
            __IO  uint32_t  QPCRR6               :1;
            __IO  uint32_t  QPCRR7               :1;
            __IO  uint32_t  QPCRR8               :1;
            __IO  uint32_t  QPCRR9               :1;
            __IO  uint32_t  QPCRR10              :1;
            __IO  uint32_t  QPCRR11              :1;
            __IO  uint32_t  QPCRR12              :1;
            __IO  uint32_t  QPCRR13              :1;
            __IO  uint32_t  QPCRR14              :1;
            __IO  uint32_t  QPCRR15              :1;
            __IO  uint32_t  QRCRR0               :1;
            __IO  uint32_t  QRCRR1               :1;
            __IO  uint32_t  QRCRR2               :1;
            __IO  uint32_t  QRCRR3               :1;
            __IO  uint32_t  QRCRR4               :1;
            __IO  uint32_t  QRCRR5               :1;
            __IO  uint32_t  QRCRR6               :1;
            __IO  uint32_t  QRCRR7               :1;
            __IO  uint32_t  QRCRR8               :1;
            __IO  uint32_t  QRCRR9               :1;
            __IO  uint32_t  QRCRR10              :1;
            __IO  uint32_t  QRCRR11              :1;
            __IO  uint32_t  QRCRR12              :1;
            __IO  uint32_t  QRCRR13              :1;
            __IO  uint32_t  QRCRR14              :1;
            __IO  uint32_t  QRCRR15              :1;
        };
    };
} stc_qprc_qprcrr_field_t;

/******************************************************************************
 ** QPRC_NF_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_qprc_nf_nfctla_field
{
    union {
        struct {
            __IO   uint8_t  AINNWS               :3;
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  AINLV                :1;
            __IO   uint8_t  AINMD                :1;
            __IO   uint8_t  RESERVED1            :2;
        };
        struct {
            __IO   uint8_t  AINNWS0              :1;
            __IO   uint8_t  AINNWS1              :1;
            __IO   uint8_t  AINNWS2              :1;
            __IO   uint8_t  RESERVED2            :5;
        };
    };
} stc_qprc_nf_nfctla_field_t;

typedef struct stc_qprc_nf_nfctlb_field
{
    union {
        struct {
            __IO   uint8_t  BINNWS               :3;
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  BINLV                :1;
            __IO   uint8_t  BINMD                :1;
            __IO   uint8_t  RESERVED1            :2;
        };
        struct {
            __IO   uint8_t  BINNWS0              :1;
            __IO   uint8_t  BINNWS1              :1;
            __IO   uint8_t  BINNWS2              :1;
            __IO   uint8_t  RESERVED2            :5;
        };
    };
} stc_qprc_nf_nfctlb_field_t;

typedef struct stc_qprc_nf_nfctlz_field
{
    union {
        struct {
            __IO   uint8_t  ZINNWS               :3;
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  ZINLV                :1;
            __IO   uint8_t  ZINMD                :1;
            __IO   uint8_t  RESERVED1            :2;
        };
        struct {
            __IO   uint8_t  ZINNWS0              :1;
            __IO   uint8_t  ZINNWS1              :1;
            __IO   uint8_t  ZINNWS2              :1;
            __IO   uint8_t  RESERVED2            :5;
        };
    };
} stc_qprc_nf_nfctlz_field_t;

/******************************************************************************
 ** RTC_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_rtc_wtcr1_field
{
        __IO  uint32_t  ST                       :1;
        __IO  uint32_t  RESERVED0                :1;
        __IO  uint32_t  RUN                      :1;
        __IO  uint32_t  SRST                     :1;
        __IO  uint32_t  SCST                     :1;
        __IO  uint32_t  SCRST                    :1;
        __IO  uint32_t  BUSY                     :1;
        __IO  uint32_t  RESERVED1                :1;
        __IO  uint32_t  MIEN                     :1;
        __IO  uint32_t  HEN                      :1;
        __IO  uint32_t  DEN                      :1;
        __IO  uint32_t  MOEN                     :1;
        __IO  uint32_t  YEN                      :1;
        __IO  uint32_t  RESERVED2                :3;
        __IO  uint32_t  INTSSI                   :1;
        __IO  uint32_t  INTSI                    :1;
        __IO  uint32_t  INTMI                    :1;
        __IO  uint32_t  INTHI                    :1;
        __IO  uint32_t  INTTMI                   :1;
        __IO  uint32_t  INTALI                   :1;
        __IO  uint32_t  INTERI                   :1;
        __IO  uint32_t  INTCRI                   :1;
        __IO  uint32_t  INTSSIE                  :1;
        __IO  uint32_t  INTSIE                   :1;
        __IO  uint32_t  INTMIE                   :1;
        __IO  uint32_t  INTHIE                   :1;
        __IO  uint32_t  INTTMIE                  :1;
        __IO  uint32_t  INTALIE                  :1;
        __IO  uint32_t  INTERIE                  :1;
        __IO  uint32_t  INTCRIE                  :1;
} stc_rtc_wtcr1_field_t;

typedef struct stc_rtc_wtcr2_field
{
        __IO  uint32_t  CREAD                    :1;
        __IO  uint32_t  RESERVED0                :7;
        __IO  uint32_t  TMST                     :1;
        __IO  uint32_t  TMEN                     :1;
        __IO  uint32_t  TMRUN                    :1;
        __IO  uint32_t  RESERVED1                :21;
} stc_rtc_wtcr2_field_t;

typedef struct stc_rtc_wtbr_field
{
    union {
        struct {
            __IO  uint32_t  BR                   :24;
            __IO  uint32_t  RESERVED0            :8;
        };
        struct {
            __IO  uint32_t  BR0                  :1;
            __IO  uint32_t  BR1                  :1;
            __IO  uint32_t  BR2                  :1;
            __IO  uint32_t  BR3                  :1;
            __IO  uint32_t  BR4                  :1;
            __IO  uint32_t  BR5                  :1;
            __IO  uint32_t  BR6                  :1;
            __IO  uint32_t  BR7                  :1;
            __IO  uint32_t  BR8                  :1;
            __IO  uint32_t  BR9                  :1;
            __IO  uint32_t  BR10                 :1;
            __IO  uint32_t  BR11                 :1;
            __IO  uint32_t  BR12                 :1;
            __IO  uint32_t  BR13                 :1;
            __IO  uint32_t  BR14                 :1;
            __IO  uint32_t  BR15                 :1;
            __IO  uint32_t  BR16                 :1;
            __IO  uint32_t  BR17                 :1;
            __IO  uint32_t  BR18                 :1;
            __IO  uint32_t  BR19                 :1;
            __IO  uint32_t  BR20                 :1;
            __IO  uint32_t  BR21                 :1;
            __IO  uint32_t  BR22                 :1;
            __IO  uint32_t  BR23                 :1;
            __IO  uint32_t  RESERVED1            :8;
        };
    };
} stc_rtc_wtbr_field_t;

typedef struct stc_rtc_wtsr_field
{
    union {
        struct {
            __IO   uint8_t  S                    :4;
            __IO   uint8_t  TS                   :3;
            __IO   uint8_t  RESERVED0            :1;
        };
        struct {
            __IO   uint8_t  S0                   :1;
            __IO   uint8_t  S1                   :1;
            __IO   uint8_t  S2                   :1;
            __IO   uint8_t  S3                   :1;
            __IO   uint8_t  TS0                  :1;
            __IO   uint8_t  TS1                  :1;
            __IO   uint8_t  TS2                  :1;
            __IO   uint8_t  RESERVED1            :1;
        };
    };
} stc_rtc_wtsr_field_t;

typedef struct stc_rtc_wtmir_field
{
    union {
        struct {
            __IO   uint8_t  MI                   :4;
            __IO   uint8_t  TMI                  :3;
            __IO   uint8_t  RESERVED0            :1;
        };
        struct {
            __IO   uint8_t  MI0                  :1;
            __IO   uint8_t  MI1                  :1;
            __IO   uint8_t  MI2                  :1;
            __IO   uint8_t  MI3                  :1;
            __IO   uint8_t  TMI0                 :1;
            __IO   uint8_t  TMI1                 :1;
            __IO   uint8_t  TMI2                 :1;
            __IO   uint8_t  RESERVED1            :1;
        };
    };
} stc_rtc_wtmir_field_t;

typedef struct stc_rtc_wthr_field
{
    union {
        struct {
            __IO   uint8_t  H                    :4;
            __IO   uint8_t  TH                   :2;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  H0                   :1;
            __IO   uint8_t  H1                   :1;
            __IO   uint8_t  H2                   :1;
            __IO   uint8_t  H3                   :1;
            __IO   uint8_t  TH0                  :1;
            __IO   uint8_t  TH1                  :1;
            __IO   uint8_t  RESERVED1            :2;
        };
    };
} stc_rtc_wthr_field_t;

typedef struct stc_rtc_wtdr_field
{
    union {
        struct {
            __IO   uint8_t  D                    :4;
            __IO   uint8_t  TD                   :2;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  D0                   :1;
            __IO   uint8_t  D1                   :1;
            __IO   uint8_t  D2                   :1;
            __IO   uint8_t  D3                   :1;
            __IO   uint8_t  TD0                  :1;
            __IO   uint8_t  TD1                  :1;
            __IO   uint8_t  RESERVED1            :2;
        };
    };
} stc_rtc_wtdr_field_t;

typedef struct stc_rtc_wtdw_field
{
    union {
        struct {
            __IO   uint8_t  DW                   :3;
            __IO   uint8_t  RESERVED0            :5;
        };
        struct {
            __IO   uint8_t  DW0                  :1;
            __IO   uint8_t  DW1                  :1;
            __IO   uint8_t  DW2                  :1;
            __IO   uint8_t  RESERVED1            :5;
        };
    };
} stc_rtc_wtdw_field_t;

typedef struct stc_rtc_wtmor_field
{
    union {
        struct {
            __IO   uint8_t  MO                   :4;
            __IO   uint8_t  TMO0                 :1;
            __IO   uint8_t  RESERVED0            :3;
        };
        struct {
            __IO   uint8_t  MO0                  :1;
            __IO   uint8_t  MO1                  :1;
            __IO   uint8_t  MO2                  :1;
            __IO   uint8_t  MO3                  :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_rtc_wtmor_field_t;

typedef struct stc_rtc_wtyr_field
{
    union {
        struct {
            __IO   uint8_t  Y                    :4;
            __IO   uint8_t  TY                   :4;
        };
        struct {
            __IO   uint8_t  Y0                   :1;
            __IO   uint8_t  Y1                   :1;
            __IO   uint8_t  Y2                   :1;
            __IO   uint8_t  Y3                   :1;
            __IO   uint8_t  TY0                  :1;
            __IO   uint8_t  TY1                  :1;
            __IO   uint8_t  TY2                  :1;
            __IO   uint8_t  TY3                  :1;
        };
    };
} stc_rtc_wtyr_field_t;

typedef struct stc_rtc_almir_field
{
    union {
        struct {
            __IO   uint8_t  AMI                  :4;
            __IO   uint8_t  TAMI                 :3;
            __IO   uint8_t  RESERVED0            :1;
        };
        struct {
            __IO   uint8_t  AMI0                 :1;
            __IO   uint8_t  AMI1                 :1;
            __IO   uint8_t  AMI2                 :1;
            __IO   uint8_t  AMI3                 :1;
            __IO   uint8_t  TAMI0                :1;
            __IO   uint8_t  TAMI1                :1;
            __IO   uint8_t  TAMI2                :1;
            __IO   uint8_t  RESERVED1            :1;
        };
    };
} stc_rtc_almir_field_t;

typedef struct stc_rtc_alhr_field
{
    union {
        struct {
            __IO   uint8_t  AH                   :4;
            __IO   uint8_t  TAH                  :2;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  AH0                  :1;
            __IO   uint8_t  AH1                  :1;
            __IO   uint8_t  AH2                  :1;
            __IO   uint8_t  AH3                  :1;
            __IO   uint8_t  TAH0                 :1;
            __IO   uint8_t  TAH1                 :1;
            __IO   uint8_t  RESERVED1            :2;
        };
    };
} stc_rtc_alhr_field_t;

typedef struct stc_rtc_aldr_field
{
    union {
        struct {
            __IO   uint8_t  AD                   :4;
            __IO   uint8_t  TAD                  :2;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  AD0                  :1;
            __IO   uint8_t  AD1                  :1;
            __IO   uint8_t  AD2                  :1;
            __IO   uint8_t  AD3                  :1;
            __IO   uint8_t  TAD0                 :1;
            __IO   uint8_t  TAD1                 :1;
            __IO   uint8_t  RESERVED1            :2;
        };
    };
} stc_rtc_aldr_field_t;

typedef struct stc_rtc_almor_field
{
    union {
        struct {
            __IO   uint8_t  AMO                  :4;
            __IO   uint8_t  TAMO0                :1;
            __IO   uint8_t  RESERVED0            :3;
        };
        struct {
            __IO   uint8_t  AMO0                 :1;
            __IO   uint8_t  AMO1                 :1;
            __IO   uint8_t  AMO2                 :1;
            __IO   uint8_t  AMO3                 :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_rtc_almor_field_t;

typedef struct stc_rtc_alyr_field
{
    union {
        struct {
            __IO   uint8_t  AY                   :4;
            __IO   uint8_t  TAY                  :4;
        };
        struct {
            __IO   uint8_t  AY0                  :1;
            __IO   uint8_t  AY1                  :1;
            __IO   uint8_t  AY2                  :1;
            __IO   uint8_t  AY3                  :1;
            __IO   uint8_t  TAY0                 :1;
            __IO   uint8_t  TAY1                 :1;
            __IO   uint8_t  TAY2                 :1;
            __IO   uint8_t  TAY3                 :1;
        };
    };
} stc_rtc_alyr_field_t;

typedef struct stc_rtc_wttr_field
{
    union {
        struct {
            __IO  uint32_t  TM                   :18;
            __IO  uint32_t  RESERVED0            :14;
        };
        struct {
            __IO  uint32_t  TM0                  :1;
            __IO  uint32_t  TM1                  :1;
            __IO  uint32_t  TM2                  :1;
            __IO  uint32_t  TM3                  :1;
            __IO  uint32_t  TM4                  :1;
            __IO  uint32_t  TM5                  :1;
            __IO  uint32_t  TM6                  :1;
            __IO  uint32_t  TM7                  :1;
            __IO  uint32_t  TM8                  :1;
            __IO  uint32_t  TM9                  :1;
            __IO  uint32_t  TM10                 :1;
            __IO  uint32_t  TM11                 :1;
            __IO  uint32_t  TM12                 :1;
            __IO  uint32_t  TM13                 :1;
            __IO  uint32_t  TM14                 :1;
            __IO  uint32_t  TM15                 :1;
            __IO  uint32_t  TM16                 :1;
            __IO  uint32_t  TM17                 :1;
            __IO  uint32_t  RESERVED1            :14;
        };
    };
} stc_rtc_wttr_field_t;

typedef struct stc_rtc_wtclks_field
{
        __IO   uint8_t  WTCLKS                   :1;
        __IO   uint8_t  RESERVED0                :7;
} stc_rtc_wtclks_field_t;

typedef struct stc_rtc_wtclkm_field
{
    union {
        struct {
            __IO   uint8_t  WTCLKM               :2;
            __IO   uint8_t  RESERVED0            :6;
        };
        struct {
            __IO   uint8_t  WTCLKM0              :1;
            __IO   uint8_t  WTCLKM1              :1;
            __IO   uint8_t  RESERVED1            :6;
        };
    };
} stc_rtc_wtclkm_field_t;

typedef struct stc_rtc_wtcal_field
{
    union {
        struct {
            __IO  uint16_t  WTCAL                :10;
            __IO  uint16_t  RESERVED0            :6;
        };
        struct {
            __IO  uint16_t  WTCAL0               :1;
            __IO  uint16_t  WTCAL1               :1;
            __IO  uint16_t  WTCAL2               :1;
            __IO  uint16_t  WTCAL3               :1;
            __IO  uint16_t  WTCAL4               :1;
            __IO  uint16_t  WTCAL5               :1;
            __IO  uint16_t  WTCAL6               :1;
            __IO  uint16_t  WTCAL7               :1;
            __IO  uint16_t  WTCAL8               :1;
            __IO  uint16_t  WTCAL9               :1;
            __IO  uint16_t  RESERVED1            :6;
        };
    };
} stc_rtc_wtcal_field_t;

typedef struct stc_rtc_wtcalen_field
{
        __IO   uint8_t  WTCALEN                  :1;
        __IO   uint8_t  RESERVED0                :7;
} stc_rtc_wtcalen_field_t;

typedef struct stc_rtc_wtdiv_field
{
    union {
        struct {
            __IO   uint8_t  WTDIV                :4;
            __IO   uint8_t  RESERVED0            :4;
        };
        struct {
            __IO   uint8_t  WTDIV0               :1;
            __IO   uint8_t  WTDIV1               :1;
            __IO   uint8_t  WTDIV2               :1;
            __IO   uint8_t  WTDIV3               :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_rtc_wtdiv_field_t;

typedef struct stc_rtc_wtdiven_field
{
        __IO   uint8_t  WTDIVEN                  :1;
        __IO   uint8_t  WTDIVRDY                 :1;
        __IO   uint8_t  RESERVED0                :6;
} stc_rtc_wtdiven_field_t;

typedef struct stc_rtc_wtcalprd_field
{
    union {
        struct {
            __IO   uint8_t  WTCALPRD             :6;
            __IO   uint8_t  RESERVED0            :2;
        };
        struct {
            __IO   uint8_t  WTCALPRD0            :1;
            __IO   uint8_t  WTCALPRD1            :1;
            __IO   uint8_t  WTCALPRD2            :1;
            __IO   uint8_t  WTCALPRD3            :1;
            __IO   uint8_t  WTCALPRD4            :1;
            __IO   uint8_t  WTCALPRD5            :1;
            __IO   uint8_t  RESERVED1            :2;
        };
    };
} stc_rtc_wtcalprd_field_t;

typedef struct stc_rtc_wtcosel_field
{
        __IO   uint8_t  WTCOSEL                  :1;
        __IO   uint8_t  RESERVED0                :7;
} stc_rtc_wtcosel_field_t;

/******************************************************************************
 ** SBSSR_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_sbssr_btsssr_field
{
        __IO  uint16_t  SSSR0                    :1;
        __IO  uint16_t  SSSR1                    :1;
        __IO  uint16_t  SSSR2                    :1;
        __IO  uint16_t  SSSR3                    :1;
        __IO  uint16_t  SSSR4                    :1;
        __IO  uint16_t  SSSR5                    :1;
        __IO  uint16_t  SSSR6                    :1;
        __IO  uint16_t  SSSR7                    :1;
        __IO  uint16_t  SSSR8                    :1;
        __IO  uint16_t  SSSR9                    :1;
        __IO  uint16_t  SSSR10                   :1;
        __IO  uint16_t  SSSR11                   :1;
        __IO  uint16_t  SSSR12                   :1;
        __IO  uint16_t  SSSR13                   :1;
        __IO  uint16_t  SSSR14                   :1;
        __IO  uint16_t  SSSR15                   :1;
} stc_sbssr_btsssr_field_t;

/******************************************************************************
 ** SDIF_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_sdif_sbsize_field
{
    union {
        struct {
            __IO  uint16_t  TRSFBLCKSZ           :12;
            __IO  uint16_t  HSDMABUFBD           :3;
            __IO  uint16_t  RESERVED0            :1;
        };
        struct {
            __IO  uint16_t  TRSFBLCKSZ0          :1;
            __IO  uint16_t  TRSFBLCKSZ1          :1;
            __IO  uint16_t  TRSFBLCKSZ2          :1;
            __IO  uint16_t  TRSFBLCKSZ3          :1;
            __IO  uint16_t  TRSFBLCKSZ4          :1;
            __IO  uint16_t  TRSFBLCKSZ5          :1;
            __IO  uint16_t  TRSFBLCKSZ6          :1;
            __IO  uint16_t  TRSFBLCKSZ7          :1;
            __IO  uint16_t  TRSFBLCKSZ8          :1;
            __IO  uint16_t  TRSFBLCKSZ9          :1;
            __IO  uint16_t  TRSFBLCKSZ10         :1;
            __IO  uint16_t  TRSFBLCKSZ11         :1;
            __IO  uint16_t  HSDMABUFBD0          :1;
            __IO  uint16_t  HSDMABUFBD1          :1;
            __IO  uint16_t  HSDMABUFBD2          :1;
            __IO  uint16_t  RESERVED1            :1;
        };
    };
} stc_sdif_sbsize_field_t;

typedef struct stc_sdif_strsfmd_field
{
    union {
        struct {
            __IO  uint16_t  DMAEN                :1;
            __IO  uint16_t  BLCKCNTEN            :1;
            __IO  uint16_t  AUTOCMDEN            :2;
            __IO  uint16_t  DTTRSFDIR            :1;
            __IO  uint16_t  BLCKCNTSEL           :1;
            __IO  uint16_t  RESERVED1            :10;
        };
        struct {
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  AUTOCMDEN0           :1;
            __IO  uint16_t  AUTOCMDEN1           :1;
            __IO  uint16_t  RESERVED2            :12;
        };
    };
} stc_sdif_strsfmd_field_t;

typedef struct stc_sdif_scmmd_field
{
    union {
        struct {
            __IO  uint16_t  RESPTYPE             :2;
            __IO  uint16_t  RESERVED0            :1;
            __IO  uint16_t  CMDCRCCHKE           :1;
            __IO  uint16_t  CMDIDXCHKE           :1;
            __IO  uint16_t  DATPRESSEL           :1;
            __IO  uint16_t  CMDTYPE              :2;
            __IO  uint16_t  CMDINDEX             :6;
            __IO  uint16_t  RESERVED2            :2;
        };
        struct {
            __IO  uint16_t  RESPTYPE0            :1;
            __IO  uint16_t  RESPTYPE1            :1;
            __IO  uint16_t  RESERVED1            :4;
            __IO  uint16_t  CMDTYPE0             :1;
            __IO  uint16_t  CMDTYPE1             :1;
            __IO  uint16_t  CMDINDEX0            :1;
            __IO  uint16_t  CMDINDEX1            :1;
            __IO  uint16_t  CMDINDEX2            :1;
            __IO  uint16_t  CMDINDEX3            :1;
            __IO  uint16_t  CMDINDEX4            :1;
            __IO  uint16_t  CMDINDEX5            :1;
            __IO  uint16_t  RESERVED3            :2;
        };
    };
} stc_sdif_scmmd_field_t;

typedef struct stc_sdif_sprstat_field
{
    union {
        struct {
            __IO  uint32_t  CMDINH               :1;
            __IO  uint32_t  CMDDATINH            :1;
            __IO  uint32_t  DATLNACT             :1;
            __IO  uint32_t  RETUNEREQ            :1;
            __IO  uint32_t  RESERVED0            :4;
            __IO  uint32_t  WRTRSFACT            :1;
            __IO  uint32_t  RDTRSFACT            :1;
            __IO  uint32_t  BUFWREN              :1;
            __IO  uint32_t  BUFRDEN              :1;
            __IO  uint32_t  RESERVED1            :4;
            __IO  uint32_t  CARDINS              :1;
            __IO  uint32_t  CARDSTB              :1;
            __IO  uint32_t  CARDDET              :1;
            __IO  uint32_t  WPPINLVL             :1;
            __IO  uint32_t  LNSGNLVL             :4;
            __IO  uint32_t  CMDLNSGN             :1;
            __IO  uint32_t  RESERVED3            :7;
        };
        struct {
            __IO  uint32_t  RESERVED2            :20;
            __IO  uint32_t  LNSGNLVL0            :1;
            __IO  uint32_t  LNSGNLVL1            :1;
            __IO  uint32_t  LNSGNLVL2            :1;
            __IO  uint32_t  LNSGNLVL3            :1;
            __IO  uint32_t  RESERVED4            :8;
        };
    };
} stc_sdif_sprstat_field_t;

typedef struct stc_sdif_shctl1_field
{
    union {
        struct {
            __IO   uint8_t  LEDCTRL              :1;
            __IO   uint8_t  DATAWIDTH            :1;
            __IO   uint8_t  HIGHSPDEN            :1;
            __IO   uint8_t  DMASEL               :2;
            __IO   uint8_t  EXTDTWIDTH           :1;
            __IO   uint8_t  CDTSTLVL             :1;
            __IO   uint8_t  CDSGNSEL             :1;
        };
        struct {
            __IO   uint8_t  RESERVED0            :3;
            __IO   uint8_t  DMASEL0              :1;
            __IO   uint8_t  DMASEL1              :1;
            __IO   uint8_t  RESERVED1            :3;
        };
    };
} stc_sdif_shctl1_field_t;

typedef struct stc_sdif_spwrctl_field
{
    union {
        struct {
            __IO   uint8_t  SDBUSPWR             :1;
            __IO   uint8_t  SDBUSVLSEL           :3;
            __IO   uint8_t  RESERVED1            :4;
        };
        struct {
            __IO   uint8_t  RESERVED0            :1;
            __IO   uint8_t  SDBUSVLSEL0          :1;
            __IO   uint8_t  SDBUSVLSEL1          :1;
            __IO   uint8_t  SDBUSVLSEL2          :1;
            __IO   uint8_t  RESERVED2            :4;
        };
    };
} stc_sdif_spwrctl_field_t;

typedef struct stc_sdif_sblkgpctl_field
{
        __IO   uint8_t  BLCKGSTPREQ              :1;
        __IO   uint8_t  CONTREQ                  :1;
        __IO   uint8_t  RDWAITCTL                :1;
        __IO   uint8_t  BLCKGAPINT               :1;
        __IO   uint8_t  RESERVED0                :4;
} stc_sdif_sblkgpctl_field_t;

typedef struct stc_sdif_swkupctl_field
{
        __IO   uint8_t  WKUPEVNTEN0              :1;
        __IO   uint8_t  WKUPEVNTEN1              :1;
        __IO   uint8_t  WKUPEVNTEN2              :1;
        __IO   uint8_t  RESERVED0                :5;
} stc_sdif_swkupctl_field_t;

typedef struct stc_sdif_sclkctl_field
{
    union {
        struct {
            __IO  uint16_t  INTLCLCKEN           :1;
            __IO  uint16_t  INTLCLCKST           :1;
            __IO  uint16_t  SDCLCKEN             :1;
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  CLCKGENSEL           :1;
            __IO  uint16_t  UPSDCLKSEL           :2;
            __IO  uint16_t  SDCLKSEL             :8;
        };
        struct {
            __IO  uint16_t  RESERVED1            :6;
            __IO  uint16_t  UPSDCLKSEL0          :1;
            __IO  uint16_t  UPSDCLKSEL1          :1;
            __IO  uint16_t  SDCLKSEL0            :1;
            __IO  uint16_t  SDCLKSEL1            :1;
            __IO  uint16_t  SDCLKSEL2            :1;
            __IO  uint16_t  SDCLKSEL3            :1;
            __IO  uint16_t  SDCLKSEL4            :1;
            __IO  uint16_t  SDCLKSEL5            :1;
            __IO  uint16_t  SDCLKSEL6            :1;
            __IO  uint16_t  SDCLKSEL7            :1;
        };
    };
} stc_sdif_sclkctl_field_t;

typedef struct stc_sdif_stoctl_field
{
    union {
        struct {
            __IO   uint8_t  DTTMOUTVAL           :4;
            __IO   uint8_t  RESERVED0            :4;
        };
        struct {
            __IO   uint8_t  DTTMOUTVAL0          :1;
            __IO   uint8_t  DTTMOUTVAL1          :1;
            __IO   uint8_t  DTTMOUTVAL2          :1;
            __IO   uint8_t  DTTMOUTVAL3          :1;
            __IO   uint8_t  RESERVED1            :4;
        };
    };
} stc_sdif_stoctl_field_t;

typedef struct stc_sdif_ssrst_field
{
        __IO   uint8_t  SWRSTALL                 :1;
        __IO   uint8_t  SWRSTCMDLN               :1;
        __IO   uint8_t  SWRSTDATLN               :1;
        __IO   uint8_t  RESERVED0                :5;
} stc_sdif_ssrst_field_t;

typedef struct stc_sdif_snintst_field
{
        __IO  uint16_t  CMDCMPLT                 :1;
        __IO  uint16_t  TRSFCMPLT                :1;
        __IO  uint16_t  BLCKGEVNT                :1;
        __IO  uint16_t  DMAINT                   :1;
        __IO  uint16_t  BUFWRRDY                 :1;
        __IO  uint16_t  BUFRDRDY                 :1;
        __IO  uint16_t  CARDINS                  :1;
        __IO  uint16_t  CARDRMV                  :1;
        __IO  uint16_t  CARDINT                  :1;
        __IO  uint16_t  INT_A                    :1;
        __IO  uint16_t  INT_B                    :1;
        __IO  uint16_t  INT_C                    :1;
        __IO  uint16_t  RETUNEEVT                :1;
        __IO  uint16_t  RESERVED0                :2;
        __IO  uint16_t  ERRORINT                 :1;
} stc_sdif_snintst_field_t;

typedef struct stc_sdif_seintst_field
{
        __IO  uint16_t  CMDTOERR                 :1;
        __IO  uint16_t  CMDCRCERR                :1;
        __IO  uint16_t  CMDEBERR                 :1;
        __IO  uint16_t  CMDIDXERR                :1;
        __IO  uint16_t  DTTOERR                  :1;
        __IO  uint16_t  DTCRCERR                 :1;
        __IO  uint16_t  DTEBERR                  :1;
        __IO  uint16_t  CRTLMTERR                :1;
        __IO  uint16_t  ACMD12ERR                :1;
        __IO  uint16_t  ADMAERR                  :1;
        __IO  uint16_t  TUNINGERR                :1;
        __IO  uint16_t  RESERVED0                :1;
        __IO  uint16_t  BTACKERR                 :1;
        __IO  uint16_t  ACMD19ERR                :1;
        __IO  uint16_t  AHBMSTERR                :1;
        __IO  uint16_t  RESERVED1                :1;
} stc_sdif_seintst_field_t;

typedef struct stc_sdif_snintste_field
{
        __IO  uint16_t  CMDCMPLTS                :1;
        __IO  uint16_t  TRSFCMPLTS               :1;
        __IO  uint16_t  BLCKGEVNTS               :1;
        __IO  uint16_t  DMAINTS                  :1;
        __IO  uint16_t  BUFWRRDYS                :1;
        __IO  uint16_t  BUFRDRDYS                :1;
        __IO  uint16_t  CARDINSS                 :1;
        __IO  uint16_t  CARDRMVS                 :1;
        __IO  uint16_t  CARDINTS                 :1;
        __IO  uint16_t  INT_AS                   :1;
        __IO  uint16_t  INT_BS                   :1;
        __IO  uint16_t  INT_CS                   :1;
        __IO  uint16_t  RETUNEEVTS               :1;
        __IO  uint16_t  RESERVED0                :3;
} stc_sdif_snintste_field_t;

typedef struct stc_sdif_seintste_field
{
        __IO  uint16_t  CMDTOERRS                :1;
        __IO  uint16_t  CMDCRCERRS               :1;
        __IO  uint16_t  CMDEBERRS                :1;
        __IO  uint16_t  CMDIDXERRS               :1;
        __IO  uint16_t  DTTOERRS                 :1;
        __IO  uint16_t  DTCRCERRS                :1;
        __IO  uint16_t  DTEBERRS                 :1;
        __IO  uint16_t  CRTLMTERRS               :1;
        __IO  uint16_t  ACMD12ERRS               :1;
        __IO  uint16_t  ADMAERRS                 :1;
        __IO  uint16_t  TUNINGERRS               :1;
        __IO  uint16_t  RESERVED0                :1;
        __IO  uint16_t  BTACKERRS                :1;
        __IO  uint16_t  ACMD19ERRS               :1;
        __IO  uint16_t  AHBMSTERRS               :1;
        __IO  uint16_t  RESERVED1                :1;
} stc_sdif_seintste_field_t;

typedef struct stc_sdif_snintsge_field
{
        __IO  uint16_t  CMDCMPLTG                :1;
        __IO  uint16_t  TRSFCMPLTG               :1;
        __IO  uint16_t  BLCKGEVNTG               :1;
        __IO  uint16_t  DMAINTG                  :1;
        __IO  uint16_t  BUFWRRDYG                :1;
        __IO  uint16_t  BUFRDRDYG                :1;
        __IO  uint16_t  CARDINSG                 :1;
        __IO  uint16_t  CARDRMVG                 :1;
        __IO  uint16_t  CARDINTG                 :1;
        __IO  uint16_t  INT_AG                   :1;
        __IO  uint16_t  INT_BG                   :1;
        __IO  uint16_t  INT_CG                   :1;
        __IO  uint16_t  RETUNEEVTG               :1;
        __IO  uint16_t  RESERVED0                :3;
} stc_sdif_snintsge_field_t;

typedef struct stc_sdif_seintsge_field
{
        __IO  uint16_t  CMDTOERRG                :1;
        __IO  uint16_t  CMDCRCERRG               :1;
        __IO  uint16_t  CMDEBERRG                :1;
        __IO  uint16_t  CMDIDXERRG               :1;
        __IO  uint16_t  DTTOERRG                 :1;
        __IO  uint16_t  DTCRCERRG                :1;
        __IO  uint16_t  DTEBERRG                 :1;
        __IO  uint16_t  CRTLMTERRG               :1;
        __IO  uint16_t  ACMD12ERRG               :1;
        __IO  uint16_t  ADMAERRG                 :1;
        __IO  uint16_t  TUNINGERRG               :1;
        __IO  uint16_t  RESERVED0                :1;
        __IO  uint16_t  BTACKERRG                :1;
        __IO  uint16_t  ACMD19ERRG               :1;
        __IO  uint16_t  AHBMSTERRG               :1;
        __IO  uint16_t  RESERVED1                :1;
} stc_sdif_seintsge_field_t;

typedef struct stc_sdif_sacmdest_field
{
        __IO  uint16_t  ACMD12NOEX               :1;
        __IO  uint16_t  ACMDTOERR                :1;
        __IO  uint16_t  ACMDCRCERR               :1;
        __IO  uint16_t  ACMDEBERR                :1;
        __IO  uint16_t  ACMDIDXERR               :1;
        __IO  uint16_t  RESERVED0                :2;
        __IO  uint16_t  CMDND12ERR               :1;
        __IO  uint16_t  RESERVED1                :8;
} stc_sdif_sacmdest_field_t;

typedef struct stc_sdif_shctl2_field
{
    union {
        struct {
            __IO  uint16_t  UHSMDSEL             :3;
            __IO  uint16_t  V18SGNEN             :1;
            __IO  uint16_t  DRVSEL               :2;
            __IO  uint16_t  DOTUING              :1;
            __IO  uint16_t  SMPCLKSEL            :1;
            __IO  uint16_t  RESERVED1            :6;
            __IO  uint16_t  ASYINTEN             :1;
            __IO  uint16_t  PREVALEN             :1;
        };
        struct {
            __IO  uint16_t  UHSMDSEL0            :1;
            __IO  uint16_t  UHSMDSEL1            :1;
            __IO  uint16_t  UHSMDSEL2            :1;
            __IO  uint16_t  RESERVED0            :1;
            __IO  uint16_t  DRVSEL0              :1;
            __IO  uint16_t  DRVSEL1              :1;
            __IO  uint16_t  RESERVED2            :10;
        };
    };
} stc_sdif_shctl2_field_t;

typedef struct stc_sdif_capblty0_field
{
    union {
        struct {
            __IO  uint16_t  TOCLKFREQ            :6;
            __IO  uint16_t  RESERVED0            :1;
            __IO  uint16_t  TOCLKUNIT            :1;
            __IO  uint16_t  SDBASECLK            :8;
        };
        struct {
            __IO  uint16_t  TOCLKFREQ0           :1;
            __IO  uint16_t  TOCLKFREQ1           :1;
            __IO  uint16_t  TOCLKFREQ2           :1;
            __IO  uint16_t  TOCLKFREQ3           :1;
            __IO  uint16_t  TOCLKFREQ4           :1;
            __IO  uint16_t  TOCLKFREQ5           :1;
            __IO  uint16_t  RESERVED1            :2;
            __IO  uint16_t  SDBASECLK0           :1;
            __IO  uint16_t  SDBASECLK1           :1;
            __IO  uint16_t  SDBASECLK2           :1;
            __IO  uint16_t  SDBASECLK3           :1;
            __IO  uint16_t  SDBASECLK4           :1;
            __IO  uint16_t  SDBASECLK5           :1;
            __IO  uint16_t  SDBASECLK6           :1;
            __IO  uint16_t  SDBASECLK7           :1;
        };
    };
} stc_sdif_capblty0_field_t;

typedef struct stc_sdif_capblty1_field
{
    union {
        struct {
            __IO  uint16_t  MAXBLCKLEN           :2;
            __IO  uint16_t  EMBD8BIT             :1;
            __IO  uint16_t  ADMA2SPT             :1;
            __IO  uint16_t  RESERVED0            :1;
            __IO  uint16_t  HGHSPDSPT            :1;
            __IO  uint16_t  SDMASPT              :1;
            __IO  uint16_t  LWPWRSPT             :1;
            __IO  uint16_t  V33SPT               :1;
            __IO  uint16_t  V30SPT               :1;
            __IO  uint16_t  V18SPT               :1;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  BUS64SPT             :1;
            __IO  uint16_t  ASYINTSPT            :1;
            __IO  uint16_t  STOPTYPE             :2;
        };
        struct {
            __IO  uint16_t  MAXBLCKLEN0          :1;
            __IO  uint16_t  MAXBLCKLEN1          :1;
            __IO  uint16_t  RESERVED2            :12;
            __IO  uint16_t  STOPTYPE0            :1;
            __IO  uint16_t  STOPTYPE1            :1;
        };
    };
} stc_sdif_capblty1_field_t;

typedef struct stc_sdif_capblty2_field
{
    union {
        struct {
            __IO  uint16_t  SDR50SPT             :1;
            __IO  uint16_t  SDR104SPT            :1;
            __IO  uint16_t  DDR50SPT             :1;
            __IO  uint16_t  RESERVED0            :1;
            __IO  uint16_t  DRVTPASPT            :1;
            __IO  uint16_t  DRVTPCSPT            :1;
            __IO  uint16_t  DRVTPDSPT            :1;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  TMCNTRETN            :4;
            __IO  uint16_t  RESERVED3            :1;
            __IO  uint16_t  USETNSDR50           :1;
            __IO  uint16_t  RETNMODE             :2;
        };
        struct {
            __IO  uint16_t  RESERVED2            :8;
            __IO  uint16_t  TMCNTRETN0           :1;
            __IO  uint16_t  TMCNTRETN1           :1;
            __IO  uint16_t  TMCNTRETN2           :1;
            __IO  uint16_t  TMCNTRETN3           :1;
            __IO  uint16_t  RESERVED4            :2;
            __IO  uint16_t  RETNMODE0            :1;
            __IO  uint16_t  RETNMODE1            :1;
        };
    };
} stc_sdif_capblty2_field_t;

typedef struct stc_sdif_capblty3_field
{
    union {
        struct {
            __IO  uint16_t  CLKMULTPL            :8;
            __IO  uint16_t  RESERVED0            :8;
        };
        struct {
            __IO  uint16_t  CLKMULTPL0           :1;
            __IO  uint16_t  CLKMULTPL1           :1;
            __IO  uint16_t  CLKMULTPL2           :1;
            __IO  uint16_t  CLKMULTPL3           :1;
            __IO  uint16_t  CLKMULTPL4           :1;
            __IO  uint16_t  CLKMULTPL5           :1;
            __IO  uint16_t  CLKMULTPL6           :1;
            __IO  uint16_t  CLKMULTPL7           :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_sdif_capblty3_field_t;

typedef struct stc_sdif_mxccapy0_field
{
    union {
        struct {
            __IO  uint16_t  V33MAXCUR            :8;
            __IO  uint16_t  V30MAXCUR            :8;
        };
        struct {
            __IO  uint16_t  V33MAXCUR0           :1;
            __IO  uint16_t  V33MAXCUR1           :1;
            __IO  uint16_t  V33MAXCUR2           :1;
            __IO  uint16_t  V33MAXCUR3           :1;
            __IO  uint16_t  V33MAXCUR4           :1;
            __IO  uint16_t  V33MAXCUR5           :1;
            __IO  uint16_t  V33MAXCUR6           :1;
            __IO  uint16_t  V33MAXCUR7           :1;
            __IO  uint16_t  V30MAXCUR0           :1;
            __IO  uint16_t  V30MAXCUR1           :1;
            __IO  uint16_t  V30MAXCUR2           :1;
            __IO  uint16_t  V30MAXCUR3           :1;
            __IO  uint16_t  V30MAXCUR4           :1;
            __IO  uint16_t  V30MAXCUR5           :1;
            __IO  uint16_t  V30MAXCUR6           :1;
            __IO  uint16_t  V30MAXCUR7           :1;
        };
    };
} stc_sdif_mxccapy0_field_t;

typedef struct stc_sdif_mxccapy1_field
{
    union {
        struct {
            __IO  uint16_t  V18MAXCUR            :8;
            __IO  uint16_t  RESERVED0            :8;
        };
        struct {
            __IO  uint16_t  V18MAXCUR0           :1;
            __IO  uint16_t  V18MAXCUR1           :1;
            __IO  uint16_t  V18MAXCUR2           :1;
            __IO  uint16_t  V18MAXCUR3           :1;
            __IO  uint16_t  V18MAXCUR4           :1;
            __IO  uint16_t  V18MAXCUR5           :1;
            __IO  uint16_t  V18MAXCUR6           :1;
            __IO  uint16_t  V18MAXCUR7           :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_sdif_mxccapy1_field_t;

typedef struct stc_sdif_feacest_field
{
        __IO  uint16_t  FEVNT12ND                :1;
        __IO  uint16_t  FEVNTTO                  :1;
        __IO  uint16_t  FEVNTCRC                 :1;
        __IO  uint16_t  FEVNTEB                  :1;
        __IO  uint16_t  FEVNTIDX                 :1;
        __IO  uint16_t  RESERVED0                :2;
        __IO  uint16_t  FEVNTCMD12               :1;
        __IO  uint16_t  RESERVED1                :8;
} stc_sdif_feacest_field_t;

typedef struct stc_sdif_sfeeist_field
{
        __IO  uint16_t  FETOERR                  :1;
        __IO  uint16_t  FECRCERR                 :1;
        __IO  uint16_t  FEEBERR                  :1;
        __IO  uint16_t  FEIDXERR                 :1;
        __IO  uint16_t  FEDTOTERR                :1;
        __IO  uint16_t  FEDTCRCERR               :1;
        __IO  uint16_t  FEDTEBERR                :1;
        __IO  uint16_t  FECRLTERR                :1;
        __IO  uint16_t  FEA12ERR                 :1;
        __IO  uint16_t  FEADMAERR                :1;
        __IO  uint16_t  FETUNEERR                :1;
        __IO  uint16_t  RESERVED0                :1;
        __IO  uint16_t  FEACKERR                 :1;
        __IO  uint16_t  FEA19ERR                 :1;
        __IO  uint16_t  FEAHBMSERR               :1;
        __IO  uint16_t  RESERVED1                :1;
} stc_sdif_sfeeist_field_t;

typedef struct stc_sdif_admaest_field
{
    union {
        struct {
            __IO   uint8_t  ADMAERRS             :2;
            __IO   uint8_t  ADMALENME            :1;
            __IO   uint8_t  RESERVED0            :5;
        };
        struct {
            __IO   uint8_t  ADMAERRS0            :1;
            __IO   uint8_t  ADMAERRS1            :1;
            __IO   uint8_t  RESERVED1            :6;
        };
    };
} stc_sdif_admaest_field_t;

typedef struct stc_sdif_sadsa0_field
{
    union {
        struct {
            __IO  uint16_t  ADR1500              :16;
        };
        struct {
            __IO  uint16_t  ADR15000             :1;
            __IO  uint16_t  ADR15001             :1;
            __IO  uint16_t  ADR15002             :1;
            __IO  uint16_t  ADR15003             :1;
            __IO  uint16_t  ADR15004             :1;
            __IO  uint16_t  ADR15005             :1;
            __IO  uint16_t  ADR15006             :1;
            __IO  uint16_t  ADR15007             :1;
            __IO  uint16_t  ADR15008             :1;
            __IO  uint16_t  ADR15009             :1;
            __IO  uint16_t  ADR150010            :1;
            __IO  uint16_t  ADR150011            :1;
            __IO  uint16_t  ADR150012            :1;
            __IO  uint16_t  ADR150013            :1;
            __IO  uint16_t  ADR150014            :1;
            __IO  uint16_t  ADR150015            :1;
        };
    };
} stc_sdif_sadsa0_field_t;

typedef struct stc_sdif_sadsa1_field
{
    union {
        struct {
            __IO  uint16_t  ADR3116              :16;
        };
        struct {
            __IO  uint16_t  ADR31160             :1;
            __IO  uint16_t  ADR31161             :1;
            __IO  uint16_t  ADR31162             :1;
            __IO  uint16_t  ADR31163             :1;
            __IO  uint16_t  ADR31164             :1;
            __IO  uint16_t  ADR31165             :1;
            __IO  uint16_t  ADR31166             :1;
            __IO  uint16_t  ADR31167             :1;
            __IO  uint16_t  ADR31168             :1;
            __IO  uint16_t  ADR31169             :1;
            __IO  uint16_t  ADR311610            :1;
            __IO  uint16_t  ADR311611            :1;
            __IO  uint16_t  ADR311612            :1;
            __IO  uint16_t  ADR311613            :1;
            __IO  uint16_t  ADR311614            :1;
            __IO  uint16_t  ADR311615            :1;
        };
    };
} stc_sdif_sadsa1_field_t;

typedef struct stc_sdif_sadsa2_field
{
    union {
        struct {
            __IO  uint16_t  ADR4732              :16;
        };
        struct {
            __IO  uint16_t  ADR47320             :1;
            __IO  uint16_t  ADR47321             :1;
            __IO  uint16_t  ADR47322             :1;
            __IO  uint16_t  ADR47323             :1;
            __IO  uint16_t  ADR47324             :1;
            __IO  uint16_t  ADR47325             :1;
            __IO  uint16_t  ADR47326             :1;
            __IO  uint16_t  ADR47327             :1;
            __IO  uint16_t  ADR47328             :1;
            __IO  uint16_t  ADR47329             :1;
            __IO  uint16_t  ADR473210            :1;
            __IO  uint16_t  ADR473211            :1;
            __IO  uint16_t  ADR473212            :1;
            __IO  uint16_t  ADR473213            :1;
            __IO  uint16_t  ADR473214            :1;
            __IO  uint16_t  ADR473215            :1;
        };
    };
} stc_sdif_sadsa2_field_t;

typedef struct stc_sdif_sadsa3_field
{
    union {
        struct {
            __IO  uint16_t  ADR6348              :16;
        };
        struct {
            __IO  uint16_t  ADR63480             :1;
            __IO  uint16_t  ADR63481             :1;
            __IO  uint16_t  ADR63482             :1;
            __IO  uint16_t  ADR63483             :1;
            __IO  uint16_t  ADR63484             :1;
            __IO  uint16_t  ADR63485             :1;
            __IO  uint16_t  ADR63486             :1;
            __IO  uint16_t  ADR63487             :1;
            __IO  uint16_t  ADR63488             :1;
            __IO  uint16_t  ADR63489             :1;
            __IO  uint16_t  ADR634810            :1;
            __IO  uint16_t  ADR634811            :1;
            __IO  uint16_t  ADR634812            :1;
            __IO  uint16_t  ADR634813            :1;
            __IO  uint16_t  ADR634814            :1;
            __IO  uint16_t  ADR634815            :1;
        };
    };
} stc_sdif_sadsa3_field_t;

typedef struct stc_sdif_sprval0_field
{
    union {
        struct {
            __IO  uint16_t  SCFSELVAL            :10;
            __IO  uint16_t  CGSELVAL             :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  DSSELVAL             :2;
        };
        struct {
            __IO  uint16_t  SCFSELVAL0           :1;
            __IO  uint16_t  SCFSELVAL1           :1;
            __IO  uint16_t  SCFSELVAL2           :1;
            __IO  uint16_t  SCFSELVAL3           :1;
            __IO  uint16_t  SCFSELVAL4           :1;
            __IO  uint16_t  SCFSELVAL5           :1;
            __IO  uint16_t  SCFSELVAL6           :1;
            __IO  uint16_t  SCFSELVAL7           :1;
            __IO  uint16_t  SCFSELVAL8           :1;
            __IO  uint16_t  SCFSELVAL9           :1;
            __IO  uint16_t  RESERVED1            :4;
            __IO  uint16_t  DSSELVAL0            :1;
            __IO  uint16_t  DSSELVAL1            :1;
        };
    };
} stc_sdif_sprval0_field_t;

typedef struct stc_sdif_sprval1_field
{
    union {
        struct {
            __IO  uint16_t  SCFSELVAL            :10;
            __IO  uint16_t  CGSELVAL             :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  DSSELVAL             :2;
        };
        struct {
            __IO  uint16_t  SCFSELVAL0           :1;
            __IO  uint16_t  SCFSELVAL1           :1;
            __IO  uint16_t  SCFSELVAL2           :1;
            __IO  uint16_t  SCFSELVAL3           :1;
            __IO  uint16_t  SCFSELVAL4           :1;
            __IO  uint16_t  SCFSELVAL5           :1;
            __IO  uint16_t  SCFSELVAL6           :1;
            __IO  uint16_t  SCFSELVAL7           :1;
            __IO  uint16_t  SCFSELVAL8           :1;
            __IO  uint16_t  SCFSELVAL9           :1;
            __IO  uint16_t  RESERVED1            :4;
            __IO  uint16_t  DSSELVAL0            :1;
            __IO  uint16_t  DSSELVAL1            :1;
        };
    };
} stc_sdif_sprval1_field_t;

typedef struct stc_sdif_sprval2_field
{
    union {
        struct {
            __IO  uint16_t  SCFSELVAL            :10;
            __IO  uint16_t  CGSELVAL             :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  DSSELVAL             :2;
        };
        struct {
            __IO  uint16_t  SCFSELVAL0           :1;
            __IO  uint16_t  SCFSELVAL1           :1;
            __IO  uint16_t  SCFSELVAL2           :1;
            __IO  uint16_t  SCFSELVAL3           :1;
            __IO  uint16_t  SCFSELVAL4           :1;
            __IO  uint16_t  SCFSELVAL5           :1;
            __IO  uint16_t  SCFSELVAL6           :1;
            __IO  uint16_t  SCFSELVAL7           :1;
            __IO  uint16_t  SCFSELVAL8           :1;
            __IO  uint16_t  SCFSELVAL9           :1;
            __IO  uint16_t  RESERVED1            :4;
            __IO  uint16_t  DSSELVAL0            :1;
            __IO  uint16_t  DSSELVAL1            :1;
        };
    };
} stc_sdif_sprval2_field_t;

typedef struct stc_sdif_sprval3_field
{
    union {
        struct {
            __IO  uint16_t  SCFSELVAL            :10;
            __IO  uint16_t  CGSELVAL             :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  DSSELVAL             :2;
        };
        struct {
            __IO  uint16_t  SCFSELVAL0           :1;
            __IO  uint16_t  SCFSELVAL1           :1;
            __IO  uint16_t  SCFSELVAL2           :1;
            __IO  uint16_t  SCFSELVAL3           :1;
            __IO  uint16_t  SCFSELVAL4           :1;
            __IO  uint16_t  SCFSELVAL5           :1;
            __IO  uint16_t  SCFSELVAL6           :1;
            __IO  uint16_t  SCFSELVAL7           :1;
            __IO  uint16_t  SCFSELVAL8           :1;
            __IO  uint16_t  SCFSELVAL9           :1;
            __IO  uint16_t  RESERVED1            :4;
            __IO  uint16_t  DSSELVAL0            :1;
            __IO  uint16_t  DSSELVAL1            :1;
        };
    };
} stc_sdif_sprval3_field_t;

typedef struct stc_sdif_sprval4_field
{
    union {
        struct {
            __IO  uint16_t  SCFSELVAL            :10;
            __IO  uint16_t  CGSELVAL             :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  DSSELVAL             :2;
        };
        struct {
            __IO  uint16_t  SCFSELVAL0           :1;
            __IO  uint16_t  SCFSELVAL1           :1;
            __IO  uint16_t  SCFSELVAL2           :1;
            __IO  uint16_t  SCFSELVAL3           :1;
            __IO  uint16_t  SCFSELVAL4           :1;
            __IO  uint16_t  SCFSELVAL5           :1;
            __IO  uint16_t  SCFSELVAL6           :1;
            __IO  uint16_t  SCFSELVAL7           :1;
            __IO  uint16_t  SCFSELVAL8           :1;
            __IO  uint16_t  SCFSELVAL9           :1;
            __IO  uint16_t  RESERVED1            :4;
            __IO  uint16_t  DSSELVAL0            :1;
            __IO  uint16_t  DSSELVAL1            :1;
        };
    };
} stc_sdif_sprval4_field_t;

typedef struct stc_sdif_sprval5_field
{
    union {
        struct {
            __IO  uint16_t  SCFSELVAL            :10;
            __IO  uint16_t  CGSELVAL             :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  DSSELVAL             :2;
        };
        struct {
            __IO  uint16_t  SCFSELVAL0           :1;
            __IO  uint16_t  SCFSELVAL1           :1;
            __IO  uint16_t  SCFSELVAL2           :1;
            __IO  uint16_t  SCFSELVAL3           :1;
            __IO  uint16_t  SCFSELVAL4           :1;
            __IO  uint16_t  SCFSELVAL5           :1;
            __IO  uint16_t  SCFSELVAL6           :1;
            __IO  uint16_t  SCFSELVAL7           :1;
            __IO  uint16_t  SCFSELVAL8           :1;
            __IO  uint16_t  SCFSELVAL9           :1;
            __IO  uint16_t  RESERVED1            :4;
            __IO  uint16_t  DSSELVAL0            :1;
            __IO  uint16_t  DSSELVAL1            :1;
        };
    };
} stc_sdif_sprval5_field_t;

typedef struct stc_sdif_sprval6_field
{
    union {
        struct {
            __IO  uint16_t  SCFSELVAL            :10;
            __IO  uint16_t  CGSELVAL             :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  DSSELVAL             :2;
        };
        struct {
            __IO  uint16_t  SCFSELVAL0           :1;
            __IO  uint16_t  SCFSELVAL1           :1;
            __IO  uint16_t  SCFSELVAL2           :1;
            __IO  uint16_t  SCFSELVAL3           :1;
            __IO  uint16_t  SCFSELVAL4           :1;
            __IO  uint16_t  SCFSELVAL5           :1;
            __IO  uint16_t  SCFSELVAL6           :1;
            __IO  uint16_t  SCFSELVAL7           :1;
            __IO  uint16_t  SCFSELVAL8           :1;
            __IO  uint16_t  SCFSELVAL9           :1;
            __IO  uint16_t  RESERVED1            :4;
            __IO  uint16_t  DSSELVAL0            :1;
            __IO  uint16_t  DSSELVAL1            :1;
        };
    };
} stc_sdif_sprval6_field_t;

typedef struct stc_sdif_sprval7_field
{
    union {
        struct {
            __IO  uint16_t  SCFSELVAL            :10;
            __IO  uint16_t  CGSELVAL             :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  DSSELVAL             :2;
        };
        struct {
            __IO  uint16_t  SCFSELVAL0           :1;
            __IO  uint16_t  SCFSELVAL1           :1;
            __IO  uint16_t  SCFSELVAL2           :1;
            __IO  uint16_t  SCFSELVAL3           :1;
            __IO  uint16_t  SCFSELVAL4           :1;
            __IO  uint16_t  SCFSELVAL5           :1;
            __IO  uint16_t  SCFSELVAL6           :1;
            __IO  uint16_t  SCFSELVAL7           :1;
            __IO  uint16_t  SCFSELVAL8           :1;
            __IO  uint16_t  SCFSELVAL9           :1;
            __IO  uint16_t  RESERVED1            :4;
            __IO  uint16_t  DSSELVAL0            :1;
            __IO  uint16_t  DSSELVAL1            :1;
        };
    };
} stc_sdif_sprval7_field_t;

typedef struct stc_sdif_sshbctll_field
{
    union {
        struct {
            __IO  uint16_t  CLCKPIN              :3;
            __IO  uint16_t  RESERVED0            :1;
            __IO  uint16_t  INTINPIN             :2;
            __IO  uint16_t  RESERVED2            :2;
            __IO  uint16_t  BUSWDPRST            :7;
            __IO  uint16_t  RESERVED4            :1;
        };
        struct {
            __IO  uint16_t  CLCKPIN0             :1;
            __IO  uint16_t  CLCKPIN1             :1;
            __IO  uint16_t  CLCKPIN2             :1;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  INTINPIN0            :1;
            __IO  uint16_t  INTINPIN1            :1;
            __IO  uint16_t  RESERVED3            :2;
            __IO  uint16_t  BUSWDPRST0           :1;
            __IO  uint16_t  BUSWDPRST1           :1;
            __IO  uint16_t  BUSWDPRST2           :1;
            __IO  uint16_t  BUSWDPRST3           :1;
            __IO  uint16_t  BUSWDPRST4           :1;
            __IO  uint16_t  BUSWDPRST5           :1;
            __IO  uint16_t  BUSWDPRST6           :1;
            __IO  uint16_t  RESERVED5            :1;
        };
    };
} stc_sdif_sshbctll_field_t;

typedef struct stc_sdif_sshbctlh_field
{
    union {
        struct {
            __IO  uint16_t  CLCKPINSEL           :3;
            __IO  uint16_t  RESERVED0            :1;
            __IO  uint16_t  INTPINSEL            :3;
            __IO  uint16_t  RESERVED2            :1;
            __IO  uint16_t  BEPWRCTL             :7;
            __IO  uint16_t  RESERVED4            :1;
        };
        struct {
            __IO  uint16_t  CLCKPINSEL0          :1;
            __IO  uint16_t  CLCKPINSEL1          :1;
            __IO  uint16_t  CLCKPINSEL2          :1;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  INTPINSEL0           :1;
            __IO  uint16_t  INTPINSEL1           :1;
            __IO  uint16_t  INTPINSEL2           :1;
            __IO  uint16_t  RESERVED3            :1;
            __IO  uint16_t  BEPWRCTL0            :1;
            __IO  uint16_t  BEPWRCTL1            :1;
            __IO  uint16_t  BEPWRCTL2            :1;
            __IO  uint16_t  BEPWRCTL3            :1;
            __IO  uint16_t  BEPWRCTL4            :1;
            __IO  uint16_t  BEPWRCTL5            :1;
            __IO  uint16_t  BEPWRCTL6            :1;
            __IO  uint16_t  RESERVED5            :1;
        };
    };
} stc_sdif_sshbctlh_field_t;

typedef struct stc_sdif_sslist_field
{
    union {
        struct {
            __IO  uint16_t  SLOTINTSGN           :8;
            __IO  uint16_t  RESERVED0            :8;
        };
        struct {
            __IO  uint16_t  SLOTINTSGN0          :1;
            __IO  uint16_t  SLOTINTSGN1          :1;
            __IO  uint16_t  SLOTINTSGN2          :1;
            __IO  uint16_t  SLOTINTSGN3          :1;
            __IO  uint16_t  SLOTINTSGN4          :1;
            __IO  uint16_t  SLOTINTSGN5          :1;
            __IO  uint16_t  SLOTINTSGN6          :1;
            __IO  uint16_t  SLOTINTSGN7          :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_sdif_sslist_field_t;

typedef struct stc_sdif_shctlv_field
{
    union {
        struct {
            __IO  uint16_t  SPECVERNUM           :8;
            __IO  uint16_t  VNDVERNUM            :8;
        };
        struct {
            __IO  uint16_t  SPECVERNUM0          :1;
            __IO  uint16_t  SPECVERNUM1          :1;
            __IO  uint16_t  SPECVERNUM2          :1;
            __IO  uint16_t  SPECVERNUM3          :1;
            __IO  uint16_t  SPECVERNUM4          :1;
            __IO  uint16_t  SPECVERNUM5          :1;
            __IO  uint16_t  SPECVERNUM6          :1;
            __IO  uint16_t  SPECVERNUM7          :1;
            __IO  uint16_t  VNDVERNUM0           :1;
            __IO  uint16_t  VNDVERNUM1           :1;
            __IO  uint16_t  VNDVERNUM2           :1;
            __IO  uint16_t  VNDVERNUM3           :1;
            __IO  uint16_t  VNDVERNUM4           :1;
            __IO  uint16_t  VNDVERNUM5           :1;
            __IO  uint16_t  VNDVERNUM6           :1;
            __IO  uint16_t  VNDVERNUM7           :1;
        };
    };
} stc_sdif_shctlv_field_t;

typedef struct stc_sdif_ahbcfgl_field
{
    union {
        struct {
            __IO  uint16_t  INCRSEL              :3;
            __IO  uint16_t  SINEN                :1;
            __IO  uint16_t  BSLOCK               :1;
            __IO  uint16_t  BSLOCKSEL            :1;
            __IO  uint16_t  ENDIANSEL            :1;
            __IO  uint16_t  RESERVED0            :9;
        };
        struct {
            __IO  uint16_t  INCRSEL0             :1;
            __IO  uint16_t  INCRSEL1             :1;
            __IO  uint16_t  INCRSEL2             :1;
            __IO  uint16_t  RESERVED1            :13;
        };
    };
} stc_sdif_ahbcfgl_field_t;

typedef struct stc_sdif_spwswcl_field
{
        __IO  uint16_t  ATPWRSWEN                :1;
        __IO  uint16_t  IOREGSEL                 :1;
        __IO  uint16_t  RESERVED0                :14;
} stc_sdif_spwswcl_field_t;

typedef struct stc_sdif_stunsetl_field
{
    union {
        struct {
            __IO  uint16_t  TNPTSEL              :8;
            __IO  uint16_t  TNPHSELEN            :1;
            __IO  uint16_t  TNERRBDSEL           :1;
            __IO  uint16_t  RETNTAPSEL           :1;
            __IO  uint16_t  RETNRNGSEL           :2;
            __IO  uint16_t  RESERVED1            :3;
        };
        struct {
            __IO  uint16_t  TNPTSEL0             :1;
            __IO  uint16_t  TNPTSEL1             :1;
            __IO  uint16_t  TNPTSEL2             :1;
            __IO  uint16_t  TNPTSEL3             :1;
            __IO  uint16_t  TNPTSEL4             :1;
            __IO  uint16_t  TNPTSEL5             :1;
            __IO  uint16_t  TNPTSEL6             :1;
            __IO  uint16_t  TNPTSEL7             :1;
            __IO  uint16_t  RESERVED0            :3;
            __IO  uint16_t  RETNRNGSEL0          :1;
            __IO  uint16_t  RETNRNGSEL1          :1;
            __IO  uint16_t  RESERVED2            :3;
        };
    };
} stc_sdif_stunsetl_field_t;

typedef struct stc_sdif_stunseth_field
{
    union {
        struct {
            __IO  uint16_t  CMDCFCHKDS           :1;
            __IO  uint16_t  RESERVED0            :7;
            __IO  uint16_t  DTOTCNTVAL           :4;
            __IO  uint16_t  RESERVED2            :4;
        };
        struct {
            __IO  uint16_t  RESERVED1            :8;
            __IO  uint16_t  DTOTCNTVAL0          :1;
            __IO  uint16_t  DTOTCNTVAL1          :1;
            __IO  uint16_t  DTOTCNTVAL2          :1;
            __IO  uint16_t  DTOTCNTVAL3          :1;
            __IO  uint16_t  RESERVED3            :4;
        };
    };
} stc_sdif_stunseth_field_t;

typedef struct stc_sdif_stunstl_field
{
    union {
        struct {
            __IO  uint16_t  REP8TNRSLT           :8;
            __IO  uint16_t  REP3TNRSLT           :3;
            __IO  uint16_t  RESERVED0            :5;
        };
        struct {
            __IO  uint16_t  REP8TNRSLT0          :1;
            __IO  uint16_t  REP8TNRSLT1          :1;
            __IO  uint16_t  REP8TNRSLT2          :1;
            __IO  uint16_t  REP8TNRSLT3          :1;
            __IO  uint16_t  REP8TNRSLT4          :1;
            __IO  uint16_t  REP8TNRSLT5          :1;
            __IO  uint16_t  REP8TNRSLT6          :1;
            __IO  uint16_t  REP8TNRSLT7          :1;
            __IO  uint16_t  REP3TNRSLT0          :1;
            __IO  uint16_t  REP3TNRSLT1          :1;
            __IO  uint16_t  REP3TNRSLT2          :1;
            __IO  uint16_t  RESERVED1            :5;
        };
    };
} stc_sdif_stunstl_field_t;

typedef struct stc_sdif_stunsth_field
{
    union {
        struct {
            __IO  uint16_t  PRSTTNPNT            :8;
            __IO  uint16_t  RESERVED0            :8;
        };
        struct {
            __IO  uint16_t  PRSTTNPNT0           :1;
            __IO  uint16_t  PRSTTNPNT1           :1;
            __IO  uint16_t  PRSTTNPNT2           :1;
            __IO  uint16_t  PRSTTNPNT3           :1;
            __IO  uint16_t  PRSTTNPNT4           :1;
            __IO  uint16_t  PRSTTNPNT5           :1;
            __IO  uint16_t  PRSTTNPNT6           :1;
            __IO  uint16_t  PRSTTNPNT7           :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_sdif_stunsth_field_t;

typedef struct stc_sdif_pswistl_field
{
        __IO  uint16_t  INT5MS                   :1;
        __IO  uint16_t  INT1MS                   :1;
        __IO  uint16_t  RESERVED0                :14;
} stc_sdif_pswistl_field_t;

typedef struct stc_sdif_pswistel_field
{
        __IO  uint16_t  INT5MSSTS                :1;
        __IO  uint16_t  INT1MSSTS                :1;
        __IO  uint16_t  RESERVED0                :14;
} stc_sdif_pswistel_field_t;

typedef struct stc_sdif_pswisgel_field
{
        __IO  uint16_t  INT5MSSGEN               :1;
        __IO  uint16_t  INT1MSSGEN               :1;
        __IO  uint16_t  RESERVED0                :14;
} stc_sdif_pswisgel_field_t;

typedef struct stc_sdif_mmcsdcl_field
{
        __IO  uint16_t  LCKRSTESD                :1;
        __IO  uint16_t  RSTMMC                   :1;
        __IO  uint16_t  VCCCTLMMC                :1;
        __IO  uint16_t  VCCQCTLMMC               :1;
        __IO  uint16_t  RESERVED0                :4;
        __IO  uint16_t  MMCDDRSEL                :1;
        __IO  uint16_t  CMDDATDLY                :1;
        __IO  uint16_t  RESERVED1                :6;
} stc_sdif_mmcsdcl_field_t;

typedef struct stc_sdif_mmcsdch_field
{
        __IO  uint16_t  BTACKENMMC               :1;
        __IO  uint16_t  BTABTENMMC               :1;
        __IO  uint16_t  BTMDENMMC                :1;
        __IO  uint16_t  RESERVED0                :13;
} stc_sdif_mmcsdch_field_t;

typedef struct stc_sdif_mcwirqc0_field
{
        __IO  uint16_t  WTIRQEN                  :1;
        __IO  uint16_t  WTIRQST                  :1;
        __IO  uint16_t  RESERVED0                :14;
} stc_sdif_mcwirqc0_field_t;

typedef struct stc_sdif_mcwirqc1_field
{
    union {
        struct {
            __IO  uint16_t  WTIRQCNCLR           :16;
        };
        struct {
            __IO  uint16_t  WTIRQCNCLR0          :1;
            __IO  uint16_t  WTIRQCNCLR1          :1;
            __IO  uint16_t  WTIRQCNCLR2          :1;
            __IO  uint16_t  WTIRQCNCLR3          :1;
            __IO  uint16_t  WTIRQCNCLR4          :1;
            __IO  uint16_t  WTIRQCNCLR5          :1;
            __IO  uint16_t  WTIRQCNCLR6          :1;
            __IO  uint16_t  WTIRQCNCLR7          :1;
            __IO  uint16_t  WTIRQCNCLR8          :1;
            __IO  uint16_t  WTIRQCNCLR9          :1;
            __IO  uint16_t  WTIRQCNCLR10         :1;
            __IO  uint16_t  WTIRQCNCLR11         :1;
            __IO  uint16_t  WTIRQCNCLR12         :1;
            __IO  uint16_t  WTIRQCNCLR13         :1;
            __IO  uint16_t  WTIRQCNCLR14         :1;
            __IO  uint16_t  WTIRQCNCLR15         :1;
        };
    };
} stc_sdif_mcwirqc1_field_t;

typedef struct stc_sdif_mcwirqc2_field
{
    union {
        struct {
            __IO  uint16_t  WTIRQCNCLR           :16;
        };
        struct {
            __IO  uint16_t  WTIRQCNCLR0          :1;
            __IO  uint16_t  WTIRQCNCLR1          :1;
            __IO  uint16_t  WTIRQCNCLR2          :1;
            __IO  uint16_t  WTIRQCNCLR3          :1;
            __IO  uint16_t  WTIRQCNCLR4          :1;
            __IO  uint16_t  WTIRQCNCLR5          :1;
            __IO  uint16_t  WTIRQCNCLR6          :1;
            __IO  uint16_t  WTIRQCNCLR7          :1;
            __IO  uint16_t  WTIRQCNCLR8          :1;
            __IO  uint16_t  WTIRQCNCLR9          :1;
            __IO  uint16_t  WTIRQCNCLR10         :1;
            __IO  uint16_t  WTIRQCNCLR11         :1;
            __IO  uint16_t  WTIRQCNCLR12         :1;
            __IO  uint16_t  WTIRQCNCLR13         :1;
            __IO  uint16_t  WTIRQCNCLR14         :1;
            __IO  uint16_t  WTIRQCNCLR15         :1;
        };
    };
} stc_sdif_mcwirqc2_field_t;

typedef struct stc_sdif_mcwirqc3_field
{
    union {
        struct {
            __IO  uint16_t  WTIRQCNCLR           :16;
        };
        struct {
            __IO  uint16_t  WTIRQCNCLR0          :1;
            __IO  uint16_t  WTIRQCNCLR1          :1;
            __IO  uint16_t  WTIRQCNCLR2          :1;
            __IO  uint16_t  WTIRQCNCLR3          :1;
            __IO  uint16_t  WTIRQCNCLR4          :1;
            __IO  uint16_t  WTIRQCNCLR5          :1;
            __IO  uint16_t  WTIRQCNCLR6          :1;
            __IO  uint16_t  WTIRQCNCLR7          :1;
            __IO  uint16_t  WTIRQCNCLR8          :1;
            __IO  uint16_t  WTIRQCNCLR9          :1;
            __IO  uint16_t  WTIRQCNCLR10         :1;
            __IO  uint16_t  WTIRQCNCLR11         :1;
            __IO  uint16_t  WTIRQCNCLR12         :1;
            __IO  uint16_t  WTIRQCNCLR13         :1;
            __IO  uint16_t  WTIRQCNCLR14         :1;
            __IO  uint16_t  WTIRQCNCLR15         :1;
        };
    };
} stc_sdif_mcwirqc3_field_t;

typedef struct stc_sdif_mcrpckbl_field
{
    union {
        struct {
            __IO  uint16_t  CHECKBIT1            :7;
            __IO  uint16_t  CHECKBIT2            :6;
            __IO  uint16_t  RESERVED0            :3;
        };
        struct {
            __IO  uint16_t  CHECKBIT10           :1;
            __IO  uint16_t  CHECKBIT11           :1;
            __IO  uint16_t  CHECKBIT12           :1;
            __IO  uint16_t  CHECKBIT13           :1;
            __IO  uint16_t  CHECKBIT14           :1;
            __IO  uint16_t  CHECKBIT15           :1;
            __IO  uint16_t  CHECKBIT16           :1;
            __IO  uint16_t  CHECKBIT20           :1;
            __IO  uint16_t  CHECKBIT21           :1;
            __IO  uint16_t  CHECKBIT22           :1;
            __IO  uint16_t  CHECKBIT23           :1;
            __IO  uint16_t  CHECKBIT24           :1;
            __IO  uint16_t  CHECKBIT25           :1;
            __IO  uint16_t  RESERVED1            :3;
        };
    };
} stc_sdif_mcrpckbl_field_t;

typedef struct stc_sdif_scdetecs_field
{
    union {
        struct {
            __IO  uint16_t  RESERVED0            :8;
            __IO  uint16_t  CDDEBTCVAL           :4;
            __IO  uint16_t  RESERVED2            :4;
        };
        struct {
            __IO  uint16_t  RESERVED1            :8;
            __IO  uint16_t  CDDEBTCVAL0          :1;
            __IO  uint16_t  CDDEBTCVAL1          :1;
            __IO  uint16_t  CDDEBTCVAL2          :1;
            __IO  uint16_t  CDDEBTCVAL3          :1;
            __IO  uint16_t  RESERVED3            :4;
        };
    };
} stc_sdif_scdetecs_field_t;

/******************************************************************************
 ** SMCIF_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_smcif_globalcontrol1_field
{
        __IO  uint16_t  PARITY                   :1;
        __IO  uint16_t  FRM0                     :1;
        __IO  uint16_t  FRM1                     :1;
        __IO  uint16_t  MODE8N1                  :1;
        __IO  uint16_t  MASKRXFUL                :1;
        __IO  uint16_t  MASKTXEMP                :1;
        __IO  uint16_t  MASKSTI                  :1;
        __IO  uint16_t  MASKCAEVENT              :1;
        __IO  uint16_t  MASKITEXP                :1;
        __IO  uint16_t  IOMOD                    :1;
        __IO  uint16_t  CKMOD                    :1;
        __IO  uint16_t  RESND                    :1;
        __IO  uint16_t  GUAEN                    :1;
        __IO  uint16_t  STIDT                    :1;
        __IO  uint16_t  IDTSC                    :1;
        __IO  uint16_t  RESERVED0                :1;
} stc_smcif_globalcontrol1_field_t;

typedef struct stc_smcif_status_field
{
        __IO  uint16_t  TXEMP                    :1;
        __IO  uint16_t  RXFUL                    :1;
        __IO  uint16_t  RXACT                    :1;
        __IO  uint16_t  TXACT                    :1;
        __IO  uint16_t  CARDDETECT               :1;
        __IO  uint16_t  CARDEVENT                :1;
        __IO  uint16_t  RECOFL                   :1;
        __IO  uint16_t  IDTRUN                   :1;
        __IO  uint16_t  RDFIFOOVR                :1;
        __IO  uint16_t  RDFIFOFUL                :1;
        __IO  uint16_t  WRFIFOEMP                :1;
        __IO  uint16_t  RXSTARTERR               :1;
        __IO  uint16_t  TXRESEND                 :1;
        __IO  uint16_t  RXRESEND                 :1;
        __IO  uint16_t  RESERVED0                :2;
} stc_smcif_status_field_t;

typedef struct stc_smcif_portcontrol_field
{
        __IO  uint16_t  TRIMOD                   :1;
        __IO  uint16_t  RESERVED0                :1;
        __IO  uint16_t  IO1                      :1;
        __IO  uint16_t  RESERVED1                :1;
        __IO  uint16_t  IO1EN                    :1;
        __IO  uint16_t  RESERVED2                :1;
        __IO  uint16_t  CLKPT                    :1;
        __IO  uint16_t  RST                      :1;
        __IO  uint16_t  VCCEN                    :1;
        __IO  uint16_t  VPEN                     :1;
        __IO  uint16_t  RESERVED3                :2;
        __IO  uint16_t  CLKOUTEN                 :1;
        __IO  uint16_t  RSTOUTEN                 :1;
        __IO  uint16_t  VCCOUTEN                 :1;
        __IO  uint16_t  VPENOUTEN                :1;
} stc_smcif_portcontrol_field_t;

typedef struct stc_smcif_data_field
{
    union {
        struct {
            __IO  uint16_t  DATA                 :9;
            __IO  uint16_t  RESERVED0            :7;
        };
        struct {
            __IO  uint16_t  DATA0                :1;
            __IO  uint16_t  DATA1                :1;
            __IO  uint16_t  DATA2                :1;
            __IO  uint16_t  DATA3                :1;
            __IO  uint16_t  DATA4                :1;
            __IO  uint16_t  DATA5                :1;
            __IO  uint16_t  DATA6                :1;
            __IO  uint16_t  DATA7                :1;
            __IO  uint16_t  DATA8                :1;
            __IO  uint16_t  RESERVED1            :7;
        };
    };
} stc_smcif_data_field_t;

typedef struct stc_smcif_cardclock_field
{
    union {
        struct {
            __IO  uint16_t  CLKDIVIDER           :16;
        };
        struct {
            __IO  uint16_t  CLKDIVIDER0          :1;
            __IO  uint16_t  CLKDIVIDER1          :1;
            __IO  uint16_t  CLKDIVIDER2          :1;
            __IO  uint16_t  CLKDIVIDER3          :1;
            __IO  uint16_t  CLKDIVIDER4          :1;
            __IO  uint16_t  CLKDIVIDER5          :1;
            __IO  uint16_t  CLKDIVIDER6          :1;
            __IO  uint16_t  CLKDIVIDER7          :1;
            __IO  uint16_t  CLKDIVIDER8          :1;
            __IO  uint16_t  CLKDIVIDER9          :1;
            __IO  uint16_t  CLKDIVIDER10         :1;
            __IO  uint16_t  CLKDIVIDER11         :1;
            __IO  uint16_t  CLKDIVIDER12         :1;
            __IO  uint16_t  CLKDIVIDER13         :1;
            __IO  uint16_t  CLKDIVIDER14         :1;
            __IO  uint16_t  CLKDIVIDER15         :1;
        };
    };
} stc_smcif_cardclock_field_t;

typedef struct stc_smcif_baudrate_field
{
    union {
        struct {
            __IO  uint16_t  BRREG                :15;
            __IO  uint16_t  LITTLESTEP           :1;
        };
        struct {
            __IO  uint16_t  BRREG0               :1;
            __IO  uint16_t  BRREG1               :1;
            __IO  uint16_t  BRREG2               :1;
            __IO  uint16_t  BRREG3               :1;
            __IO  uint16_t  BRREG4               :1;
            __IO  uint16_t  BRREG5               :1;
            __IO  uint16_t  BRREG6               :1;
            __IO  uint16_t  BRREG7               :1;
            __IO  uint16_t  BRREG8               :1;
            __IO  uint16_t  BRREG9               :1;
            __IO  uint16_t  BRREG10              :1;
            __IO  uint16_t  BRREG11              :1;
            __IO  uint16_t  BRREG12              :1;
            __IO  uint16_t  BRREG13              :1;
            __IO  uint16_t  BRREG14              :1;
            __IO  uint16_t  RESERVED0            :1;
        };
    };
} stc_smcif_baudrate_field_t;

typedef struct stc_smcif_guardtimer_field
{
    union {
        struct {
            __IO  uint16_t  GTREG                :8;
            __IO  uint16_t  RESERVED0            :8;
        };
        struct {
            __IO  uint16_t  GTREG0               :1;
            __IO  uint16_t  GTREG1               :1;
            __IO  uint16_t  GTREG2               :1;
            __IO  uint16_t  GTREG3               :1;
            __IO  uint16_t  GTREG4               :1;
            __IO  uint16_t  GTREG5               :1;
            __IO  uint16_t  GTREG6               :1;
            __IO  uint16_t  GTREG7               :1;
            __IO  uint16_t  RESERVED1            :8;
        };
    };
} stc_smcif_guardtimer_field_t;

typedef struct stc_smcif_idletimer_field
{
    union {
        struct {
            __IO  uint16_t  IDTREG               :16;
        };
        struct {
            __IO  uint16_t  IDTREG0              :1;
            __IO  uint16_t  IDTREG1              :1;
            __IO  uint16_t  IDTREG2              :1;
            __IO  uint16_t  IDTREG3              :1;
            __IO  uint16_t  IDTREG4              :1;
            __IO  uint16_t  IDTREG5              :1;
            __IO  uint16_t  IDTREG6              :1;
            __IO  uint16_t  IDTREG7              :1;
            __IO  uint16_t  IDTREG8              :1;
            __IO  uint16_t  IDTREG9              :1;
            __IO  uint16_t  IDTREG10             :1;
            __IO  uint16_t  IDTREG11             :1;
            __IO  uint16_t  IDTREG12             :1;
            __IO  uint16_t  IDTREG13             :1;
            __IO  uint16_t  IDTREG14             :1;
            __IO  uint16_t  IDTREG15             :1;
        };
    };
} stc_smcif_idletimer_field_t;

typedef struct stc_smcif_globalcontrol2_field
{
        __IO  uint16_t  RX8N1                    :1;
        __IO  uint16_t  INVDATAOUT               :1;
        __IO  uint16_t  RESERVED0                :1;
        __IO  uint16_t  ICCDISABLE               :1;
        __IO  uint16_t  RESERVED1                :12;
} stc_smcif_globalcontrol2_field_t;

typedef struct stc_smcif_data_fifo_field
{
    union {
        struct {
            __IO  uint16_t  DATA                 :9;
            __IO  uint16_t  RESERVED0            :7;
        };
        struct {
            __IO  uint16_t  DATA0                :1;
            __IO  uint16_t  DATA1                :1;
            __IO  uint16_t  DATA2                :1;
            __IO  uint16_t  DATA3                :1;
            __IO  uint16_t  DATA4                :1;
            __IO  uint16_t  DATA5                :1;
            __IO  uint16_t  DATA6                :1;
            __IO  uint16_t  DATA7                :1;
            __IO  uint16_t  DATA8                :1;
            __IO  uint16_t  RESERVED1            :7;
        };
    };
} stc_smcif_data_fifo_field_t;

typedef struct stc_smcif_fifo_level_read_field
{
    union {
        struct {
            __IO  uint16_t  FIFORDLEVEL          :16;
        };
        struct {
            __IO  uint16_t  FIFORDLEVEL0         :1;
            __IO  uint16_t  FIFORDLEVEL1         :1;
            __IO  uint16_t  FIFORDLEVEL2         :1;
            __IO  uint16_t  FIFORDLEVEL3         :1;
            __IO  uint16_t  FIFORDLEVEL4         :1;
            __IO  uint16_t  FIFORDLEVEL5         :1;
            __IO  uint16_t  FIFORDLEVEL6         :1;
            __IO  uint16_t  FIFORDLEVEL7         :1;
            __IO  uint16_t  FIFORDLEVEL8         :1;
            __IO  uint16_t  FIFORDLEVEL9         :1;
            __IO  uint16_t  FIFORDLEVEL10        :1;
            __IO  uint16_t  FIFORDLEVEL11        :1;
            __IO  uint16_t  FIFORDLEVEL12        :1;
            __IO  uint16_t  FIFORDLEVEL13        :1;
            __IO  uint16_t  FIFORDLEVEL14        :1;
            __IO  uint16_t  FIFORDLEVEL15        :1;
        };
    };
} stc_smcif_fifo_level_read_field_t;

typedef struct stc_smcif_fifo_level_write_field
{
    union {
        struct {
            __IO  uint16_t  FIFOWRLEVEL          :16;
        };
        struct {
            __IO  uint16_t  FIFOWRLEVEL0         :1;
            __IO  uint16_t  FIFOWRLEVEL1         :1;
            __IO  uint16_t  FIFOWRLEVEL2         :1;
            __IO  uint16_t  FIFOWRLEVEL3         :1;
            __IO  uint16_t  FIFOWRLEVEL4         :1;
            __IO  uint16_t  FIFOWRLEVEL5         :1;
            __IO  uint16_t  FIFOWRLEVEL6         :1;
            __IO  uint16_t  FIFOWRLEVEL7         :1;
            __IO  uint16_t  FIFOWRLEVEL8         :1;
            __IO  uint16_t  FIFOWRLEVEL9         :1;
            __IO  uint16_t  FIFOWRLEVEL10        :1;
            __IO  uint16_t  FIFOWRLEVEL11        :1;
            __IO  uint16_t  FIFOWRLEVEL12        :1;
            __IO  uint16_t  FIFOWRLEVEL13        :1;
            __IO  uint16_t  FIFOWRLEVEL14        :1;
            __IO  uint16_t  FIFOWRLEVEL15        :1;
        };
    };
} stc_smcif_fifo_level_write_field_t;

typedef struct stc_smcif_fifo_mode_field
{
    union {
        struct {
            __IO  uint16_t  FIFOEN               :1;
            __IO  uint16_t  RDFIFOOVRIRQEN       :1;
            __IO  uint16_t  WRFIFOIRQEN          :1;
            __IO  uint16_t  RDFIFOIRQEN          :1;
            __IO  uint16_t  RESERVED0            :4;
            __IO  uint16_t  WRFIFOLEVEL          :4;
            __IO  uint16_t  RDFIFOLEVEL          :4;
        };
        struct {
            __IO  uint16_t  RESERVED1            :8;
            __IO  uint16_t  WRFIFOLEVEL0         :1;
            __IO  uint16_t  WRFIFOLEVEL1         :1;
            __IO  uint16_t  WRFIFOLEVEL2         :1;
            __IO  uint16_t  WRFIFOLEVEL3         :1;
            __IO  uint16_t  RDFIFOLEVEL0         :1;
            __IO  uint16_t  RDFIFOLEVEL1         :1;
            __IO  uint16_t  RDFIFOLEVEL2         :1;
            __IO  uint16_t  RDFIFOLEVEL3         :1;
        };
    };
} stc_smcif_fifo_mode_field_t;

typedef struct stc_smcif_fifo_clear_msb_write_field
{
        __IO  uint16_t  CLRWRFIFO                :1;
        __IO  uint16_t  RESERVED0                :15;
} stc_smcif_fifo_clear_msb_write_field_t;

typedef struct stc_smcif_fifo_clear_msb_read_field
{
        __IO  uint16_t  CLRRDFIFO                :1;
        __IO  uint16_t  RESERVED0                :15;
} stc_smcif_fifo_clear_msb_read_field_t;

typedef struct stc_smcif_irq_status_field
{
        __IO  uint16_t  RDFIFOOVRIRQ             :1;
        __IO  uint16_t  WRFIFOIRQ                :1;
        __IO  uint16_t  RDFIFOIRQ                :1;
        __IO  uint16_t  IDTEXPIRQ                :1;
        __IO  uint16_t  CARDEVENTIRQ             :1;
        __IO  uint16_t  RXSTBIIRQ                :1;
        __IO  uint16_t  TXEMPIRQ                 :1;
        __IO  uint16_t  RXFULIRQ                 :1;
        __IO  uint16_t  RESERVED0                :8;
} stc_smcif_irq_status_field_t;

/******************************************************************************
 ** SWWDT_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_swwdt_wdogcontrol_field
{
    union {
        struct {
            __IO  uint32_t  INTEN                :1;
            __IO  uint32_t  RESEN                :1;
            __IO  uint32_t  TWD                  :2;
            __IO  uint32_t  SPM                  :1;
            __IO  uint32_t  RESERVED1            :27;
        };
        struct {
            __IO  uint32_t  RESERVED0            :2;
            __IO  uint32_t  TWD0                 :1;
            __IO  uint32_t  TWD1                 :1;
            __IO  uint32_t  RESERVED2            :28;
        };
    };
} stc_swwdt_wdogcontrol_field_t;

typedef struct stc_swwdt_wdogris_field
{
        __IO  uint32_t  RIS                      :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_swwdt_wdogris_field_t;

typedef struct stc_swwdt_wdogspmc_field
{
        __IO  uint32_t  TGR                      :1;
        __IO  uint32_t  RESERVED0                :31;
} stc_swwdt_wdogspmc_field_t;

/******************************************************************************
 ** UNIQUE_ID_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_unique_id_uidr0_field
{
    union {
        struct {
            __IO  uint32_t  RESERVED0            :4;
            __IO  uint32_t  UID                  :28;
        };
        struct {
            __IO  uint32_t  RESERVED1            :4;
            __IO  uint32_t  UID0                 :1;
            __IO  uint32_t  UID1                 :1;
            __IO  uint32_t  UID2                 :1;
            __IO  uint32_t  UID3                 :1;
            __IO  uint32_t  UID4                 :1;
            __IO  uint32_t  UID5                 :1;
            __IO  uint32_t  UID6                 :1;
            __IO  uint32_t  UID7                 :1;
            __IO  uint32_t  UID8                 :1;
            __IO  uint32_t  UID9                 :1;
            __IO  uint32_t  UID10                :1;
            __IO  uint32_t  UID11                :1;
            __IO  uint32_t  UID12                :1;
            __IO  uint32_t  UID13                :1;
            __IO  uint32_t  UID14                :1;
            __IO  uint32_t  UID15                :1;
            __IO  uint32_t  UID16                :1;
            __IO  uint32_t  UID17                :1;
            __IO  uint32_t  UID18                :1;
            __IO  uint32_t  UID19                :1;
            __IO  uint32_t  UID20                :1;
            __IO  uint32_t  UID21                :1;
            __IO  uint32_t  UID22                :1;
            __IO  uint32_t  UID23                :1;
            __IO  uint32_t  UID24                :1;
            __IO  uint32_t  UID25                :1;
            __IO  uint32_t  UID26                :1;
            __IO  uint32_t  UID27                :1;
        };
    };
} stc_unique_id_uidr0_field_t;

typedef struct stc_unique_id_uidr1_field
{
    union {
        struct {
            __IO  uint32_t  UID                  :13;
            __IO  uint32_t  RESERVED0            :19;
        };
        struct {
            __IO  uint32_t  UID0                 :1;
            __IO  uint32_t  UID1                 :1;
            __IO  uint32_t  UID2                 :1;
            __IO  uint32_t  UID3                 :1;
            __IO  uint32_t  UID4                 :1;
            __IO  uint32_t  UID5                 :1;
            __IO  uint32_t  UID6                 :1;
            __IO  uint32_t  UID7                 :1;
            __IO  uint32_t  UID8                 :1;
            __IO  uint32_t  UID9                 :1;
            __IO  uint32_t  UID10                :1;
            __IO  uint32_t  UID11                :1;
            __IO  uint32_t  UID12                :1;
            __IO  uint32_t  RESERVED1            :19;
        };
    };
} stc_unique_id_uidr1_field_t;

/******************************************************************************
 ** USB_MODULE
 ** 
 ******************************************************************************/
typedef struct stc_usb_hcnt_field
{
        __IO  uint16_t  HOST                     :1;
        __IO  uint16_t  URST                     :1;
        __IO  uint16_t  SOFIRE                   :1;
        __IO  uint16_t  DIRE                     :1;
        __IO  uint16_t  CNNIRE                   :1;
        __IO  uint16_t  CMPIRE                   :1;
        __IO  uint16_t  URIRE                    :1;
        __IO  uint16_t  RWKIRE                   :1;
        __IO  uint16_t  RETRY                    :1;
        __IO  uint16_t  CANCEL                   :1;
        __IO  uint16_t  SOFSTEP                  :1;
        __IO  uint16_t  RESERVED0                :5;
} stc_usb_hcnt_field_t;

typedef struct stc_usb_hirq_field
{
        __IO   uint8_t  SOFIRQ                   :1;
        __IO   uint8_t  DIRQ                     :1;
        __IO   uint8_t  CNNIRQ                   :1;
        __IO   uint8_t  CMPIRQ                   :1;
        __IO   uint8_t  URIRQ                    :1;
        __IO   uint8_t  RWKIRQ                   :1;
        __IO   uint8_t  RESERVED0                :1;
        __IO   uint8_t  TCAN                     :1;
} stc_usb_hirq_field_t;

typedef struct stc_usb_herr_field
{
    union {
        struct {
            __IO   uint8_t  HS                   :2;
            __IO   uint8_t  STUFF                :1;
            __IO   uint8_t  TGERR                :1;
            __IO   uint8_t  CRC                  :1;
            __IO   uint8_t  TOUT                 :1;
            __IO   uint8_t  RERR                 :1;
            __IO   uint8_t  LSTSOF               :1;
        };
        struct {
            __IO   uint8_t  HS0                  :1;
            __IO   uint8_t  HS1                  :1;
            __IO   uint8_t  RESERVED0            :6;
        };
    };
} stc_usb_herr_field_t;

typedef struct stc_usb_hstate_field
{
        __IO   uint8_t  CSTAT                    :1;
        __IO   uint8_t  TMODE                    :1;
        __IO   uint8_t  SUSP                     :1;
        __IO   uint8_t  SOFBUSY                  :1;
        __IO   uint8_t  CLKSEL                   :1;
        __IO   uint8_t  ALIVE                    :1;
        __IO   uint8_t  RESERVED0                :2;
} stc_usb_hstate_field_t;

typedef struct stc_usb_hfcomp_field
{
    union {
        struct {
            __IO   uint8_t  FRAMECOMP            :8;
        };
        struct {
            __IO   uint8_t  FRAMECOMP0           :1;
            __IO   uint8_t  FRAMECOMP1           :1;
            __IO   uint8_t  FRAMECOMP2           :1;
            __IO   uint8_t  FRAMECOMP3           :1;
            __IO   uint8_t  FRAMECOMP4           :1;
            __IO   uint8_t  FRAMECOMP5           :1;
            __IO   uint8_t  FRAMECOMP6           :1;
            __IO   uint8_t  FRAMECOMP7           :1;
        };
    };
} stc_usb_hfcomp_field_t;

typedef struct stc_usb_hrtimer_field
{
    union {
        struct {
            __IO  uint16_t  RTIMER               :16;
        };
        struct {
            __IO  uint16_t  RTIMER0              :1;
            __IO  uint16_t  RTIMER1              :1;
            __IO  uint16_t  RTIMER2              :1;
            __IO  uint16_t  RTIMER3              :1;
            __IO  uint16_t  RTIMER4              :1;
            __IO  uint16_t  RTIMER5              :1;
            __IO  uint16_t  RTIMER6              :1;
            __IO  uint16_t  RTIMER7              :1;
            __IO  uint16_t  RTIMER8              :1;
            __IO  uint16_t  RTIMER9              :1;
            __IO  uint16_t  RTIMER10             :1;
            __IO  uint16_t  RTIMER11             :1;
            __IO  uint16_t  RTIMER12             :1;
            __IO  uint16_t  RTIMER13             :1;
            __IO  uint16_t  RTIMER14             :1;
            __IO  uint16_t  RTIMER15             :1;
        };
    };
} stc_usb_hrtimer_field_t;

typedef struct stc_usb_hrtimer2_field
{
    union {
        struct {
            __IO   uint8_t  RTIMER2              :2;
            __IO   uint8_t  RESERVED0            :6;
        };
        struct {
            __IO   uint8_t  RTIMER20             :1;
            __IO   uint8_t  RTIMER21             :1;
            __IO   uint8_t  RESERVED1            :6;
        };
    };
} stc_usb_hrtimer2_field_t;

typedef struct stc_usb_hadr_field
{
    union {
        struct {
            __IO   uint8_t  ADDRESS              :7;
            __IO   uint8_t  RESERVED0            :1;
        };
        struct {
            __IO   uint8_t  ADDRESS0             :1;
            __IO   uint8_t  ADDRESS1             :1;
            __IO   uint8_t  ADDRESS2             :1;
            __IO   uint8_t  ADDRESS3             :1;
            __IO   uint8_t  ADDRESS4             :1;
            __IO   uint8_t  ADDRESS5             :1;
            __IO   uint8_t  ADDRESS6             :1;
            __IO   uint8_t  RESERVED1            :1;
        };
    };
} stc_usb_hadr_field_t;

typedef struct stc_usb_heof_field
{
    union {
        struct {
            __IO  uint16_t  HEOF                 :14;
            __IO  uint16_t  RESERVED0            :2;
        };
        struct {
            __IO  uint16_t  HEOF0                :1;
            __IO  uint16_t  HEOF1                :1;
            __IO  uint16_t  HEOF2                :1;
            __IO  uint16_t  HEOF3                :1;
            __IO  uint16_t  HEOF4                :1;
            __IO  uint16_t  HEOF5                :1;
            __IO  uint16_t  HEOF6                :1;
            __IO  uint16_t  HEOF7                :1;
            __IO  uint16_t  HEOF8                :1;
            __IO  uint16_t  HEOF9                :1;
            __IO  uint16_t  HEOF10               :1;
            __IO  uint16_t  HEOF11               :1;
            __IO  uint16_t  HEOF12               :1;
            __IO  uint16_t  HEOF13               :1;
            __IO  uint16_t  RESERVED1            :2;
        };
    };
} stc_usb_heof_field_t;

typedef struct stc_usb_hframe_field
{
    union {
        struct {
            __IO  uint16_t  FRAME                :11;
            __IO  uint16_t  RESERVED0            :5;
        };
        struct {
            __IO  uint16_t  FRAME0               :1;
            __IO  uint16_t  FRAME1               :1;
            __IO  uint16_t  FRAME2               :1;
            __IO  uint16_t  FRAME3               :1;
            __IO  uint16_t  FRAME4               :1;
            __IO  uint16_t  FRAME5               :1;
            __IO  uint16_t  FRAME6               :1;
            __IO  uint16_t  FRAME7               :1;
            __IO  uint16_t  FRAME8               :1;
            __IO  uint16_t  FRAME9               :1;
            __IO  uint16_t  FRAME10              :1;
            __IO  uint16_t  RESERVED1            :5;
        };
    };
} stc_usb_hframe_field_t;

typedef struct stc_usb_htoken_field
{
    union {
        struct {
            __IO   uint8_t  ENDPT                :4;
            __IO   uint8_t  TKNEN                :3;
            __IO   uint8_t  TGGL                 :1;
        };
        struct {
            __IO   uint8_t  ENDPT0               :1;
            __IO   uint8_t  ENDPT1               :1;
            __IO   uint8_t  ENDPT2               :1;
            __IO   uint8_t  ENDPT3               :1;
            __IO   uint8_t  TKNEN0               :1;
            __IO   uint8_t  TKNEN1               :1;
            __IO   uint8_t  TKNEN2               :1;
            __IO   uint8_t  RESERVED0            :1;
        };
    };
} stc_usb_htoken_field_t;

typedef struct stc_usb_udcc_field
{
        __IO  uint16_t  PWC                      :1;
        __IO  uint16_t  RFBK                     :1;
        __IO  uint16_t  RESERVED0                :1;
        __IO  uint16_t  STALCLREN                :1;
        __IO  uint16_t  USTP                     :1;
        __IO  uint16_t  HCONX                    :1;
        __IO  uint16_t  RESUM                    :1;
        __IO  uint16_t  RST                      :1;
        __IO  uint16_t  RESERVED1                :8;
} stc_usb_udcc_field_t;

typedef struct stc_usb_ep0c_field
{
    union {
        struct {
            __IO  uint16_t  PKS                  :7;
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  STAL                 :1;
            __IO  uint16_t  RESERVED1            :6;
        };
        struct {
            __IO  uint16_t  PKS0                 :1;
            __IO  uint16_t  PKS1                 :1;
            __IO  uint16_t  PKS2                 :1;
            __IO  uint16_t  PKS3                 :1;
            __IO  uint16_t  PKS4                 :1;
            __IO  uint16_t  PKS5                 :1;
            __IO  uint16_t  PKS6                 :1;
            __IO  uint16_t  RESERVED2            :9;
        };
    };
} stc_usb_ep0c_field_t;

typedef struct stc_usb_ep1c_field
{
    union {
        struct {
            __IO  uint16_t  PKS                  :9;
            __IO  uint16_t  STAL                 :1;
            __IO  uint16_t  NULE                 :1;
            __IO  uint16_t  DMAE                 :1;
            __IO  uint16_t  DIR                  :1;
            __IO  uint16_t  TYPE                 :2;
            __IO  uint16_t  EPEN                 :1;
        };
        struct {
            __IO  uint16_t  PKS0                 :1;
            __IO  uint16_t  PKS1                 :1;
            __IO  uint16_t  PKS2                 :1;
            __IO  uint16_t  PKS3                 :1;
            __IO  uint16_t  PKS4                 :1;
            __IO  uint16_t  PKS5                 :1;
            __IO  uint16_t  PKS6                 :1;
            __IO  uint16_t  PKS7                 :1;
            __IO  uint16_t  PKS8                 :1;
            __IO  uint16_t  RESERVED0            :4;
            __IO  uint16_t  TYPE0                :1;
            __IO  uint16_t  TYPE1                :1;
            __IO  uint16_t  RESERVED1            :1;
        };
    };
} stc_usb_ep1c_field_t;

typedef struct stc_usb_ep2c_field
{
    union {
        struct {
            __IO  uint16_t  PKS                  :7;
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  STAL                 :1;
            __IO  uint16_t  NULE                 :1;
            __IO  uint16_t  DMAE                 :1;
            __IO  uint16_t  DIR                  :1;
            __IO  uint16_t  TYPE                 :2;
            __IO  uint16_t  EPEN                 :1;
        };
        struct {
            __IO  uint16_t  PKS0                 :1;
            __IO  uint16_t  PKS1                 :1;
            __IO  uint16_t  PKS2                 :1;
            __IO  uint16_t  PKS3                 :1;
            __IO  uint16_t  PKS4                 :1;
            __IO  uint16_t  PKS5                 :1;
            __IO  uint16_t  PKS6                 :1;
            __IO  uint16_t  RESERVED1            :6;
            __IO  uint16_t  TYPE0                :1;
            __IO  uint16_t  TYPE1                :1;
            __IO  uint16_t  RESERVED2            :1;
        };
    };
} stc_usb_ep2c_field_t;

typedef struct stc_usb_ep3c_field
{
    union {
        struct {
            __IO  uint16_t  PKS                  :7;
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  STAL                 :1;
            __IO  uint16_t  NULE                 :1;
            __IO  uint16_t  DMAE                 :1;
            __IO  uint16_t  DIR                  :1;
            __IO  uint16_t  TYPE                 :2;
            __IO  uint16_t  EPEN                 :1;
        };
        struct {
            __IO  uint16_t  PKS0                 :1;
            __IO  uint16_t  PKS1                 :1;
            __IO  uint16_t  PKS2                 :1;
            __IO  uint16_t  PKS3                 :1;
            __IO  uint16_t  PKS4                 :1;
            __IO  uint16_t  PKS5                 :1;
            __IO  uint16_t  PKS6                 :1;
            __IO  uint16_t  RESERVED1            :6;
            __IO  uint16_t  TYPE0                :1;
            __IO  uint16_t  TYPE1                :1;
            __IO  uint16_t  RESERVED2            :1;
        };
    };
} stc_usb_ep3c_field_t;

typedef struct stc_usb_ep4c_field
{
    union {
        struct {
            __IO  uint16_t  PKS                  :7;
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  STAL                 :1;
            __IO  uint16_t  NULE                 :1;
            __IO  uint16_t  DMAE                 :1;
            __IO  uint16_t  DIR                  :1;
            __IO  uint16_t  TYPE                 :2;
            __IO  uint16_t  EPEN                 :1;
        };
        struct {
            __IO  uint16_t  PKS0                 :1;
            __IO  uint16_t  PKS1                 :1;
            __IO  uint16_t  PKS2                 :1;
            __IO  uint16_t  PKS3                 :1;
            __IO  uint16_t  PKS4                 :1;
            __IO  uint16_t  PKS5                 :1;
            __IO  uint16_t  PKS6                 :1;
            __IO  uint16_t  RESERVED1            :6;
            __IO  uint16_t  TYPE0                :1;
            __IO  uint16_t  TYPE1                :1;
            __IO  uint16_t  RESERVED2            :1;
        };
    };
} stc_usb_ep4c_field_t;

typedef struct stc_usb_ep5c_field
{
    union {
        struct {
            __IO  uint16_t  PKS                  :7;
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  STAL                 :1;
            __IO  uint16_t  NULE                 :1;
            __IO  uint16_t  DMAE                 :1;
            __IO  uint16_t  DIR                  :1;
            __IO  uint16_t  TYPE                 :2;
            __IO  uint16_t  EPEN                 :1;
        };
        struct {
            __IO  uint16_t  PKS0                 :1;
            __IO  uint16_t  PKS1                 :1;
            __IO  uint16_t  PKS2                 :1;
            __IO  uint16_t  PKS3                 :1;
            __IO  uint16_t  PKS4                 :1;
            __IO  uint16_t  PKS5                 :1;
            __IO  uint16_t  PKS6                 :1;
            __IO  uint16_t  RESERVED1            :6;
            __IO  uint16_t  TYPE0                :1;
            __IO  uint16_t  TYPE1                :1;
            __IO  uint16_t  RESERVED2            :1;
        };
    };
} stc_usb_ep5c_field_t;

typedef struct stc_usb_tmsp_field
{
    union {
        struct {
            __IO  uint16_t  TMSP                 :11;
            __IO  uint16_t  RESERVED0            :5;
        };
        struct {
            __IO  uint16_t  TMSP0                :1;
            __IO  uint16_t  TMSP1                :1;
            __IO  uint16_t  TMSP2                :1;
            __IO  uint16_t  TMSP3                :1;
            __IO  uint16_t  TMSP4                :1;
            __IO  uint16_t  TMSP5                :1;
            __IO  uint16_t  TMSP6                :1;
            __IO  uint16_t  TMSP7                :1;
            __IO  uint16_t  TMSP8                :1;
            __IO  uint16_t  TMSP9                :1;
            __IO  uint16_t  TMSP10               :1;
            __IO  uint16_t  RESERVED1            :5;
        };
    };
} stc_usb_tmsp_field_t;

typedef struct stc_usb_udcs_field
{
        __IO   uint8_t  CONF                     :1;
        __IO   uint8_t  SETP                     :1;
        __IO   uint8_t  WKUP                     :1;
        __IO   uint8_t  BRST                     :1;
        __IO   uint8_t  SOF                      :1;
        __IO   uint8_t  SUSP                     :1;
        __IO   uint8_t  RESERVED0                :2;
} stc_usb_udcs_field_t;

typedef struct stc_usb_udcie_field
{
        __IO   uint8_t  CONFIE                   :1;
        __IO   uint8_t  CONFN                    :1;
        __IO   uint8_t  WKUPIE                   :1;
        __IO   uint8_t  BRSTIE                   :1;
        __IO   uint8_t  SOFIE                    :1;
        __IO   uint8_t  SUSPIE                   :1;
        __IO   uint8_t  RESERVED0                :2;
} stc_usb_udcie_field_t;

typedef struct stc_usb_ep0is_field
{
        __IO  uint16_t  RESERVED0                :10;
        __IO  uint16_t  DRQI                     :1;
        __IO  uint16_t  RESERVED1                :3;
        __IO  uint16_t  DRQIIE                   :1;
        __IO  uint16_t  BFINI                    :1;
} stc_usb_ep0is_field_t;

typedef struct stc_usb_ep0os_field
{
    union {
        struct {
            __IO  uint16_t  SIZE                 :7;
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  SPK                  :1;
            __IO  uint16_t  DRQO                 :1;
            __IO  uint16_t  RESERVED1            :2;
            __IO  uint16_t  SPKIE                :1;
            __IO  uint16_t  DRQOIE               :1;
            __IO  uint16_t  BFINI                :1;
        };
        struct {
            __IO  uint16_t  SIZE0                :1;
            __IO  uint16_t  SIZE1                :1;
            __IO  uint16_t  SIZE2                :1;
            __IO  uint16_t  SIZE3                :1;
            __IO  uint16_t  SIZE4                :1;
            __IO  uint16_t  SIZE5                :1;
            __IO  uint16_t  SIZE6                :1;
            __IO  uint16_t  RESERVED2            :9;
        };
    };
} stc_usb_ep0os_field_t;

typedef struct stc_usb_ep1s_field
{
    union {
        struct {
            __IO  uint16_t  SIZE                 :9;
            __IO  uint16_t  SPK                  :1;
            __IO  uint16_t  DRQ                  :1;
            __IO  uint16_t  BUSY                 :1;
            __IO  uint16_t  RESERVED0            :1;
            __IO  uint16_t  SPKIE                :1;
            __IO  uint16_t  DRQIE                :1;
            __IO  uint16_t  BFINI                :1;
        };
        struct {
            __IO  uint16_t  SIZE0                :1;
            __IO  uint16_t  SIZE1                :1;
            __IO  uint16_t  SIZE2                :1;
            __IO  uint16_t  SIZE3                :1;
            __IO  uint16_t  SIZE4                :1;
            __IO  uint16_t  SIZE5                :1;
            __IO  uint16_t  SIZE6                :1;
            __IO  uint16_t  SIZE7                :1;
            __IO  uint16_t  SIZE8                :1;
            __IO  uint16_t  RESERVED1            :7;
        };
    };
} stc_usb_ep1s_field_t;

typedef struct stc_usb_ep2s_field
{
    union {
        struct {
            __IO  uint16_t  SIZE                 :7;
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  SPK                  :1;
            __IO  uint16_t  DRQ                  :1;
            __IO  uint16_t  BUSY                 :1;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  SPKIE                :1;
            __IO  uint16_t  DRQIE                :1;
            __IO  uint16_t  BFINI                :1;
        };
        struct {
            __IO  uint16_t  SIZE0                :1;
            __IO  uint16_t  SIZE1                :1;
            __IO  uint16_t  SIZE2                :1;
            __IO  uint16_t  SIZE3                :1;
            __IO  uint16_t  SIZE4                :1;
            __IO  uint16_t  SIZE5                :1;
            __IO  uint16_t  SIZE6                :1;
            __IO  uint16_t  RESERVED2            :9;
        };
    };
} stc_usb_ep2s_field_t;

typedef struct stc_usb_ep3s_field
{
    union {
        struct {
            __IO  uint16_t  SIZE                 :7;
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  SPK                  :1;
            __IO  uint16_t  DRQ                  :1;
            __IO  uint16_t  BUSY                 :1;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  SPKIE                :1;
            __IO  uint16_t  DRQIE                :1;
            __IO  uint16_t  BFINI                :1;
        };
        struct {
            __IO  uint16_t  SIZE0                :1;
            __IO  uint16_t  SIZE1                :1;
            __IO  uint16_t  SIZE2                :1;
            __IO  uint16_t  SIZE3                :1;
            __IO  uint16_t  SIZE4                :1;
            __IO  uint16_t  SIZE5                :1;
            __IO  uint16_t  SIZE6                :1;
            __IO  uint16_t  RESERVED2            :9;
        };
    };
} stc_usb_ep3s_field_t;

typedef struct stc_usb_ep4s_field
{
    union {
        struct {
            __IO  uint16_t  SIZE                 :7;
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  SPK                  :1;
            __IO  uint16_t  DRQ                  :1;
            __IO  uint16_t  BUSY                 :1;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  SPKIE                :1;
            __IO  uint16_t  DRQIE                :1;
            __IO  uint16_t  BFINI                :1;
        };
        struct {
            __IO  uint16_t  SIZE0                :1;
            __IO  uint16_t  SIZE1                :1;
            __IO  uint16_t  SIZE2                :1;
            __IO  uint16_t  SIZE3                :1;
            __IO  uint16_t  SIZE4                :1;
            __IO  uint16_t  SIZE5                :1;
            __IO  uint16_t  SIZE6                :1;
            __IO  uint16_t  RESERVED2            :9;
        };
    };
} stc_usb_ep4s_field_t;

typedef struct stc_usb_ep5s_field
{
    union {
        struct {
            __IO  uint16_t  SIZE                 :7;
            __IO  uint16_t  RESERVED0            :2;
            __IO  uint16_t  SPK                  :1;
            __IO  uint16_t  DRQ                  :1;
            __IO  uint16_t  BUSY                 :1;
            __IO  uint16_t  RESERVED1            :1;
            __IO  uint16_t  SPKIE                :1;
            __IO  uint16_t  DRQIE                :1;
            __IO  uint16_t  BFINI                :1;
        };
        struct {
            __IO  uint16_t  SIZE0                :1;
            __IO  uint16_t  SIZE1                :1;
            __IO  uint16_t  SIZE2                :1;
            __IO  uint16_t  SIZE3                :1;
            __IO  uint16_t  SIZE4                :1;
            __IO  uint16_t  SIZE5                :1;
            __IO  uint16_t  SIZE6                :1;
            __IO  uint16_t  RESERVED2            :9;
        };
    };
} stc_usb_ep5s_field_t;

typedef struct stc_usb_ep0dt_field
{
    union {
        struct {
            __IO  uint16_t  BFDT                 :16;
        };
        struct {
            __IO  uint16_t  BFDT0                :1;
            __IO  uint16_t  BFDT1                :1;
            __IO  uint16_t  BFDT2                :1;
            __IO  uint16_t  BFDT3                :1;
            __IO  uint16_t  BFDT4                :1;
            __IO  uint16_t  BFDT5                :1;
            __IO  uint16_t  BFDT6                :1;
            __IO  uint16_t  BFDT7                :1;
            __IO  uint16_t  BFDT8                :1;
            __IO  uint16_t  BFDT9                :1;
            __IO  uint16_t  BFDT10               :1;
            __IO  uint16_t  BFDT11               :1;
            __IO  uint16_t  BFDT12               :1;
            __IO  uint16_t  BFDT13               :1;
            __IO  uint16_t  BFDT14               :1;
            __IO  uint16_t  BFDT15               :1;
        };
    };
} stc_usb_ep0dt_field_t;

typedef struct stc_usb_ep1dt_field
{
    union {
        struct {
            __IO  uint16_t  BFDT                 :16;
  