/****************************************************************************/
/**
Copyright (C) 2011-2015 Infineon Technologies AG. All rights reserved.
* 
*
* @par
* Infineon Technologies AG (Infineon) is supplying this software for use with 
* Infineon's microcontrollers.  This file can be freely distributed within
* development tools that are supporting such microcontrollers.
*
* @par
* THIS SOFTWARE IS PROVIDED AS IS. NO WARRANTIES, WHETHER EXPRESS, IMPLIED
* OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
* INFINEON SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL,
* OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
*
******************************************************************************/


/****************************************************************************************************//**
 * @file     XMC4800.h
 *
 * @brief    CMSIS Cortex-M4 Peripheral Access Layer Header File for
 *           XMC4800 from Infineon.
 *
 * @version  V1.1.3 (Reference Manual v1.0)
 * @date     3. February 2016
 *
 * @note     Generated with SVDConv V2.87g 
 *           from CMSIS SVD File 'XMC4800_Processed_SVD.xml' Version 1.1.3 (Reference Manual v1.0),
 *******************************************************************************************************/



/** @addtogroup Infineon
  * @{
  */

/** @addtogroup XMC4800
  * @{
  */

#ifndef XMC4800_H
#define XMC4800_H

#ifdef __cplusplus
extern "C" {
#endif


/* -------------------------  Interrupt Number Definition  ------------------------ */

typedef enum {
/* -------------------  Cortex-M4 Processor Exceptions Numbers  ------------------- */
  Reset_IRQn                    = -15,              /*!<   1  Reset Vector, invoked on Power up and warm reset                 */
  NonMaskableInt_IRQn           = -14,              /*!<   2  Non maskable Interrupt, cannot be stopped or preempted           */
  HardFault_IRQn                = -13,              /*!<   3  Hard Fault, all classes of Fault                                 */
  MemoryManagement_IRQn         = -12,              /*!<   4  Memory Management, MPU mismatch, including Access Violation
                                                         and No Match                                                          */
  BusFault_IRQn                 = -11,              /*!<   5  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                         related Fault                                                         */
  UsageFault_IRQn               = -10,              /*!<   6  Usage Fault, i.e. Undef Instruction, Illegal State Transition    */
  SVCall_IRQn                   =  -5,              /*!<  11  System Service Call via SVC instruction                          */
  DebugMonitor_IRQn             =  -4,              /*!<  12  Debug Monitor                                                    */
  PendSV_IRQn                   =  -2,              /*!<  14  Pendable request for system service                              */
  SysTick_IRQn                  =  -1,              /*!<  15  System Tick Timer                                                */
/* ---------------------  XMC4800 Specific Interrupt Numbers  --------------------- */
  SCU_0_IRQn                    =   0,              /*!<   0  SCU_0                                                            */
  ERU0_0_IRQn                   =   1,              /*!<   1  ERU0_0                                                           */
  ERU0_1_IRQn                   =   2,              /*!<   2  ERU0_1                                                           */
  ERU0_2_IRQn                   =   3,              /*!<   3  ERU0_2                                                           */
  ERU0_3_IRQn                   =   4,              /*!<   4  ERU0_3                                                           */
  ERU1_0_IRQn                   =   5,              /*!<   5  ERU1_0                                                           */
  ERU1_1_IRQn                   =   6,              /*!<   6  ERU1_1                                                           */
  ERU1_2_IRQn                   =   7,              /*!<   7  ERU1_2                                                           */
  ERU1_3_IRQn                   =   8,              /*!<   8  ERU1_3                                                           */
  PMU0_0_IRQn                   =  12,              /*!<  12  PMU0_0                                                           */
  VADC0_C0_0_IRQn               =  14,              /*!<  14  VADC0_C0_0                                                       */
  VADC0_C0_1_IRQn               =  15,              /*!<  15  VADC0_C0_1                                                       */
  VADC0_C0_2_IRQn               =  16,              /*!<  16  VADC0_C0_2                                                       */
  VADC0_C0_3_IRQn               =  17,              /*!<  17  VADC0_C0_3                                                       */
  VADC0_G0_0_IRQn               =  18,              /*!<  18  VADC0_G0_0                                                       */
  VADC0_G0_1_IRQn               =  19,              /*!<  19  VADC0_G0_1                                                       */
  VADC0_G0_2_IRQn               =  20,              /*!<  20  VADC0_G0_2                                                       */
  VADC0_G0_3_IRQn               =  21,              /*!<  21  VADC0_G0_3                                                       */
  VADC0_G1_0_IRQn               =  22,              /*!<  22  VADC0_G1_0                                                       */
  VADC0_G1_1_IRQn               =  23,              /*!<  23  VADC0_G1_1                                                       */
  VADC0_G1_2_IRQn               =  24,              /*!<  24  VADC0_G1_2                                                       */
  VADC0_G1_3_IRQn               =  25,              /*!<  25  VADC0_G1_3                                                       */
  VADC0_G2_0_IRQn               =  26,              /*!<  26  VADC0_G2_0                                                       */
  VADC0_G2_1_IRQn               =  27,              /*!<  27  VADC0_G2_1                                                       */
  VADC0_G2_2_IRQn               =  28,              /*!<  28  VADC0_G2_2                                                       */
  VADC0_G2_3_IRQn               =  29,              /*!<  29  VADC0_G2_3                                                       */
  VADC0_G3_0_IRQn               =  30,              /*!<  30  VADC0_G3_0                                                       */
  VADC0_G3_1_IRQn               =  31,              /*!<  31  VADC0_G3_1                                                       */
  VADC0_G3_2_IRQn               =  32,              /*!<  32  VADC0_G3_2                                                       */
  VADC0_G3_3_IRQn               =  33,              /*!<  33  VADC0_G3_3                                                       */
  DSD0_M_0_IRQn                 =  34,              /*!<  34  DSD0_M_0                                                         */
  DSD0_M_1_IRQn                 =  35,              /*!<  35  DSD0_M_1                                                         */
  DSD0_M_2_IRQn                 =  36,              /*!<  36  DSD0_M_2                                                         */
  DSD0_M_3_IRQn                 =  37,              /*!<  37  DSD0_M_3                                                         */
  DSD0_A_4_IRQn                 =  38,              /*!<  38  DSD0_A_4                                                         */
  DSD0_A_5_IRQn                 =  39,              /*!<  39  DSD0_A_5                                                         */
  DSD0_A_6_IRQn                 =  40,              /*!<  40  DSD0_A_6                                                         */
  DSD0_A_7_IRQn                 =  41,              /*!<  41  DSD0_A_7                                                         */
  DAC0_0_IRQn                   =  42,              /*!<  42  DAC0_0                                                           */
  DAC0_1_IRQn                   =  43,              /*!<  43  DAC0_1                                                           */
  CCU40_0_IRQn                  =  44,              /*!<  44  CCU40_0                                                          */
  CCU40_1_IRQn                  =  45,              /*!<  45  CCU40_1                                                          */
  CCU40_2_IRQn                  =  46,              /*!<  46  CCU40_2                                                          */
  CCU40_3_IRQn                  =  47,              /*!<  47  CCU40_3                                                          */
  CCU41_0_IRQn                  =  48,              /*!<  48  CCU41_0                                                          */
  CCU41_1_IRQn                  =  49,              /*!<  49  CCU41_1                                                          */
  CCU41_2_IRQn                  =  50,              /*!<  50  CCU41_2                                                          */
  CCU41_3_IRQn                  =  51,              /*!<  51  CCU41_3                                                          */
  CCU42_0_IRQn                  =  52,              /*!<  52  CCU42_0                                                          */
  CCU42_1_IRQn                  =  53,              /*!<  53  CCU42_1                                                          */
  CCU42_2_IRQn                  =  54,              /*!<  54  CCU42_2                                                          */
  CCU42_3_IRQn                  =  55,              /*!<  55  CCU42_3                                                          */
  CCU43_0_IRQn                  =  56,              /*!<  56  CCU43_0                                                          */
  CCU43_1_IRQn                  =  57,              /*!<  57  CCU43_1                                                          */
  CCU43_2_IRQn                  =  58,              /*!<  58  CCU43_2                                                          */
  CCU43_3_IRQn                  =  59,              /*!<  59  CCU43_3                                                          */
  CCU80_0_IRQn                  =  60,              /*!<  60  CCU80_0                                                          */
  CCU80_1_IRQn                  =  61,              /*!<  61  CCU80_1                                                          */
  CCU80_2_IRQn                  =  62,              /*!<  62  CCU80_2                                                          */
  CCU80_3_IRQn                  =  63,              /*!<  63  CCU80_3                                                          */
  CCU81_0_IRQn                  =  64,              /*!<  64  CCU81_0                                                          */
  CCU81_1_IRQn                  =  65,              /*!<  65  CCU81_1                                                          */
  CCU81_2_IRQn                  =  66,              /*!<  66  CCU81_2                                                          */
  CCU81_3_IRQn                  =  67,              /*!<  67  CCU81_3                                                          */
  POSIF0_0_IRQn                 =  68,              /*!<  68  POSIF0_0                                                         */
  POSIF0_1_IRQn                 =  69,              /*!<  69  POSIF0_1                                                         */
  POSIF1_0_IRQn                 =  70,              /*!<  70  POSIF1_0                                                         */
  POSIF1_1_IRQn                 =  71,              /*!<  71  POSIF1_1                                                         */
  CAN0_0_IRQn                   =  76,              /*!<  76  CAN0_0                                                           */
  CAN0_1_IRQn                   =  77,              /*!<  77  CAN0_1                                                           */
  CAN0_2_IRQn                   =  78,              /*!<  78  CAN0_2                                                           */
  CAN0_3_IRQn                   =  79,              /*!<  79  CAN0_3                                                           */
  CAN0_4_IRQn                   =  80,              /*!<  80  CAN0_4                                                           */
  CAN0_5_IRQn                   =  81,              /*!<  81  CAN0_5                                                           */
  CAN0_6_IRQn                   =  82,              /*!<  82  CAN0_6                                                           */
  CAN0_7_IRQn                   =  83,              /*!<  83  CAN0_7                                                           */
  USIC0_0_IRQn                  =  84,              /*!<  84  USIC0_0                                                          */
  USIC0_1_IRQn                  =  85,              /*!<  85  USIC0_1                                                          */
  USIC0_2_IRQn                  =  86,              /*!<  86  USIC0_2                                                          */
  USIC0_3_IRQn                  =  87,              /*!<  87  USIC0_3                                                          */
  USIC0_4_IRQn                  =  88,              /*!<  88  USIC0_4                                                          */
  USIC0_5_IRQn                  =  89,              /*!<  89  USIC0_5                                                          */
  USIC1_0_IRQn                  =  90,              /*!<  90  USIC1_0                                                          */
  USIC1_1_IRQn                  =  91,              /*!<  91  USIC1_1                                                          */
  USIC1_2_IRQn                  =  92,              /*!<  92  USIC1_2                                                          */
  USIC1_3_IRQn                  =  93,              /*!<  93  USIC1_3                                                          */
  USIC1_4_IRQn                  =  94,              /*!<  94  USIC1_4                                                          */
  USIC1_5_IRQn                  =  95,              /*!<  95  USIC1_5                                                          */
  USIC2_0_IRQn                  =  96,              /*!<  96  USIC2_0                                                          */
  USIC2_1_IRQn                  =  97,              /*!<  97  USIC2_1                                                          */
  USIC2_2_IRQn                  =  98,              /*!<  98  USIC2_2                                                          */
  USIC2_3_IRQn                  =  99,              /*!<  99  USIC2_3                                                          */
  USIC2_4_IRQn                  = 100,              /*!< 100  USIC2_4                                                          */
  USIC2_5_IRQn                  = 101,              /*!< 101  USIC2_5                                                          */
  LEDTS0_0_IRQn                 = 102,              /*!< 102  LEDTS0_0                                                         */
  FCE0_0_IRQn                   = 104,              /*!< 104  FCE0_0                                                           */
  GPDMA0_0_IRQn                 = 105,              /*!< 105  GPDMA0_0                                                         */
  SDMMC0_0_IRQn                 = 106,              /*!< 106  SDMMC0_0                                                         */
  USB0_0_IRQn                   = 107,              /*!< 107  USB0_0                                                           */
  ETH0_0_IRQn                   = 108,              /*!< 108  ETH0_0                                                           */
  ECAT0_0_IRQn                  = 109,              /*!< 109  ECAT0_0                                                          */
  GPDMA1_0_IRQn                 = 110               /*!< 110  GPDMA1_0                                                         */
} IRQn_Type;


/** @addtogroup Configuration_of_CMSIS
  * @{
  */


/* ================================================================================ */
/* ================      Processor and Core Peripheral Section     ================ */
/* ================================================================================ */

/* ----------------Configuration of the Cortex-M4 Processor and Core Peripherals---------------- */
#define __CM4_REV                 0x0200            /*!< Cortex-M4 Core Revision                                               */
#define __MPU_PRESENT                  1            /*!< MPU present or not                                                    */
#define __NVIC_PRIO_BITS               6            /*!< Number of Bits used for Priority Levels                               */
#define __Vendor_SysTickConfig         0            /*!< Set to 1 if different SysTick Config is used                          */
#define __FPU_PRESENT                  1            /*!< FPU present or not                                                    */
/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm4.h"                               /*!< Cortex-M4 processor and core peripherals                              */
#include "system_XMC4800.h"                         /*!< XMC4800 System                                                        */


/* ================================================================================ */
/* ================       Device Specific Peripheral Section       ================ */
/* ================================================================================ */
/* Macro to modify desired bitfields of a register */
#define WR_REG(reg, mask, pos, val) reg = (((uint32_t)val << pos) & \
		                                         ((uint32_t)mask)) | \
                                          (reg & ((uint32_t)~((uint32_t)mask)))

/* Macro to modify desired bitfields of a register */
#define WR_REG_SIZE(reg, mask, pos, val, size) {  \
uint##size##_t VAL1 = (uint##size##_t)((uint##size##_t)val << pos); \
uint##size##_t VAL2 = (uint##size##_t) (VAL1 & (uint##size##_t)mask); \
uint##size##_t VAL3 = (uint##size##_t)~((uint##size##_t)mask); \
uint##size##_t VAL4 = (uint##size##_t) ((uint##size##_t)reg & VAL3); \
reg = (uint##size##_t) (VAL2 | VAL4);\
}

/** Macro to read bitfields from a register */
#define RD_REG(reg, mask, pos) (((uint32_t)reg & (uint32_t)mask) >> pos)

/** Macro to read bitfields from a register */
#define RD_REG_SIZE(reg, mask, pos,size) ((uint##size##_t)(((uint32_t)reg & \
                                                      (uint32_t)mask) >> pos) )

/** Macro to set a bit in register */
#define SET_BIT(reg, pos)     (reg |= ((uint32_t)1<<pos))

/** Macro to clear a bit in register */
#define CLR_BIT(reg, pos)     (reg = reg & (uint32_t)(~((uint32_t)1<<pos)) )
/*
* ==========================================================================
* ---------- Interrupt Handler Definition ----------------------------------
* ==========================================================================
*/
#define IRQ_Hdlr_0   SCU_0_IRQHandler
#define IRQ_Hdlr_1   ERU0_0_IRQHandler
#define IRQ_Hdlr_2   ERU0_1_IRQHandler
#define IRQ_Hdlr_3   ERU0_2_IRQHandler
#define IRQ_Hdlr_4   ERU0_3_IRQHandler
#define IRQ_Hdlr_5   ERU1_0_IRQHandler
#define IRQ_Hdlr_6   ERU1_1_IRQHandler
#define IRQ_Hdlr_7   ERU1_2_IRQHandler
#define IRQ_Hdlr_8   ERU1_3_IRQHandler
#define IRQ_Hdlr_12  PMU0_0_IRQHandler
#define IRQ_Hdlr_14  VADC0_C0_0_IRQHandler
#define IRQ_Hdlr_15  VADC0_C0_1_IRQHandler
#define IRQ_Hdlr_16  VADC0_C0_2_IRQHandler
#define IRQ_Hdlr_17  VADC0_C0_3_IRQHandler
#define IRQ_Hdlr_18  VADC0_G0_0_IRQHandler
#define IRQ_Hdlr_19  VADC0_G0_1_IRQHandler
#define IRQ_Hdlr_20  VADC0_G0_2_IRQHandler
#define IRQ_Hdlr_21  VADC0_G0_3_IRQHandler
#define IRQ_Hdlr_22  VADC0_G1_0_IRQHandler
#define IRQ_Hdlr_23  VADC0_G1_1_IRQHandler
#define IRQ_Hdlr_24  VADC0_G1_2_IRQHandler
#define IRQ_Hdlr_25  VADC0_G1_3_IRQHandler
#define IRQ_Hdlr_26  VADC0_G2_0_IRQHandler
#define IRQ_Hdlr_27  VADC0_G2_1_IRQHandler
#define IRQ_Hdlr_28  VADC0_G2_2_IRQHandler
#define IRQ_Hdlr_29  VADC0_G2_3_IRQHandler
#define IRQ_Hdlr_30  VADC0_G3_0_IRQHandler
#define IRQ_Hdlr_31  VADC0_G3_1_IRQHandler
#define IRQ_Hdlr_32  VADC0_G3_2_IRQHandler
#define IRQ_Hdlr_33  VADC0_G3_3_IRQHandler
#define IRQ_Hdlr_34  DSD0_0_IRQHandler
#define IRQ_Hdlr_35  DSD0_1_IRQHandler
#define IRQ_Hdlr_36  DSD0_2_IRQHandler
#define IRQ_Hdlr_37  DSD0_3_IRQHandler
#define IRQ_Hdlr_38  DSD0_4_IRQHandler
#define IRQ_Hdlr_39  DSD0_5_IRQHandler
#define IRQ_Hdlr_40  DSD0_6_IRQHandler
#define IRQ_Hdlr_41  DSD0_7_IRQHandler
#define IRQ_Hdlr_42  DAC0_0_IRQHandler
#define IRQ_Hdlr_43  DAC0_1_IRQHandler
#define IRQ_Hdlr_44  CCU40_0_IRQHandler
#define IRQ_Hdlr_45  CCU40_1_IRQHandler
#define IRQ_Hdlr_46  CCU40_2_IRQHandler
#define IRQ_Hdlr_47  CCU40_3_IRQHandler
#define IRQ_Hdlr_48  CCU41_0_IRQHandler
#define IRQ_Hdlr_49  CCU41_1_IRQHandler
#define IRQ_Hdlr_50  CCU41_2_IRQHandler
#define IRQ_Hdlr_51  CCU41_3_IRQHandler
#define IRQ_Hdlr_52  CCU42_0_IRQHandler
#define IRQ_Hdlr_53  CCU42_1_IRQHandler
#define IRQ_Hdlr_54  CCU42_2_IRQHandler
#define IRQ_Hdlr_55  CCU42_3_IRQHandler
#define IRQ_Hdlr_56  CCU43_0_IRQHandler
#define IRQ_Hdlr_57  CCU43_1_IRQHandler
#define IRQ_Hdlr_58  CCU43_2_IRQHandler
#define IRQ_Hdlr_59  CCU43_3_IRQHandler
#define IRQ_Hdlr_60  CCU80_0_IRQHandler
#define IRQ_Hdlr_61  CCU80_1_IRQHandler
#define IRQ_Hdlr_62  CCU80_2_IRQHandler
#define IRQ_Hdlr_63  CCU80_3_IRQHandler
#define IRQ_Hdlr_64  CCU81_0_IRQHandler
#define IRQ_Hdlr_65  CCU81_1_IRQHandler
#define IRQ_Hdlr_66  CCU81_2_IRQHandler
#define IRQ_Hdlr_67  CCU81_3_IRQHandler
#define IRQ_Hdlr_68  POSIF0_0_IRQHandler
#define IRQ_Hdlr_69  POSIF0_1_IRQHandler
#define IRQ_Hdlr_70  POSIF1_0_IRQHandler
#define IRQ_Hdlr_71  POSIF1_1_IRQHandler
#define IRQ_Hdlr_76  CAN0_0_IRQHandler
#define IRQ_Hdlr_77  CAN0_1_IRQHandler
#define IRQ_Hdlr_78  CAN0_2_IRQHandler
#define IRQ_Hdlr_79  CAN0_3_IRQHandler
#define IRQ_Hdlr_80  CAN0_4_IRQHandler
#define IRQ_Hdlr_81  CAN0_5_IRQHandler
#define IRQ_Hdlr_82  CAN0_6_IRQHandler
#define IRQ_Hdlr_83  CAN0_7_IRQHandler
#define IRQ_Hdlr_84  USIC0_0_IRQHandler
#define IRQ_Hdlr_85  USIC0_1_IRQHandler
#define IRQ_Hdlr_86  USIC0_2_IRQHandler
#define IRQ_Hdlr_87  USIC0_3_IRQHandler
#define IRQ_Hdlr_88  USIC0_4_IRQHandler
#define IRQ_Hdlr_89  USIC0_5_IRQHandler
#define IRQ_Hdlr_90  USIC1_0_IRQHandler
#define IRQ_Hdlr_91  USIC1_1_IRQHandler
#define IRQ_Hdlr_92  USIC1_2_IRQHandler
#define IRQ_Hdlr_93  USIC1_3_IRQHandler
#define IRQ_Hdlr_94  USIC1_4_IRQHandler
#define IRQ_Hdlr_95  USIC1_5_IRQHandler
#define IRQ_Hdlr_96  USIC2_0_IRQHandler
#define IRQ_Hdlr_97  USIC2_1_IRQHandler
#define IRQ_Hdlr_98  USIC2_2_IRQHandler
#define IRQ_Hdlr_99  USIC2_3_IRQHandler
#define IRQ_Hdlr_100 USIC2_4_IRQHandler
#define IRQ_Hdlr_101 USIC2_5_IRQHandler
#define IRQ_Hdlr_102 LEDTS0_0_IRQHandler
#define IRQ_Hdlr_104 FCE0_0_IRQHandler
#define IRQ_Hdlr_105 GPDMA0_0_IRQHandler
#define IRQ_Hdlr_106 SDMMC0_0_IRQHandler
#define IRQ_Hdlr_107 USB0_0_IRQHandler
#define IRQ_Hdlr_108 ETH0_0_IRQHandler
#define IRQ_Hdlr_109 ECAT0_0_IRQHandler
#define IRQ_Hdlr_110 GPDMA1_0_IRQHandler

/*
* ==========================================================================
* ---------- Interrupt Handler retrieval macro -----------------------------
* ==========================================================================
*/
#define GET_IRQ_HANDLER(N) IRQ_Hdlr_##N

/** @addtogroup Device_Peripheral_Registers
  * @{
  */


/* -------------------  Start of section using anonymous unions  ------------------ */
#if defined(__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined(__ICCARM__)
  #pragma language=extended
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__TMS470__)
/* anonymous unions are enabled by default */
#elif defined(__TASKING__)
  #pragma warning 586
#else
  #warning Not supported compiler type
#endif


typedef struct {
  __IO uint32_t  MOFCR;                             /*!< (@ 0x48015000) Message Object Function Control Register               */
  __IO uint32_t  MOFGPR;                            /*!< (@ 0x48015004) Message Object FIFO/Gateway Pointer Register           */
  __IO uint32_t  MOIPR;                             /*!< (@ 0x48015008) Message Object Interrupt Pointer Register              */
  __IO uint32_t  MOAMR;                             /*!< (@ 0x4801500C) Message Object Acceptance Mask Register                */
  __IO uint32_t  MODATAL;                           /*!< (@ 0x48015010) Message Object Data Register Low                       */
  __IO uint32_t  MODATAH;                           /*!< (@ 0x48015014) Message Object Data Register High                      */
  __IO uint32_t  MOAR;                              /*!< (@ 0x48015018) Message Object Arbitration Register                    */
  
  union {
    __I  uint32_t  MOSTAT;                          /*!< (@ 0x4801501C) Message Object Status Register                         */
    __O  uint32_t  MOCTR;                           /*!< (@ 0x4801501C) Message Object Control Register                        */
  };
} CAN_MO_TypeDef;                                      /*!< (@ 0x48015020) Cluster End. Size = 32 (0x20)                          */


/* ================================================================================ */
/* ================                       PPB                      ================ */
/* ================================================================================ */


/**
  * @brief Cortex-M4 Private Peripheral Block (PPB)
  */

typedef struct {                                    /*!< (@ 0xE000E000) PPB Structure                                          */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  ACTLR;                             /*!< (@ 0xE000E008) Auxiliary Control Register                             */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  SYST_CSR;                          /*!< (@ 0xE000E010) SysTick Control and Status Register                    */
  __IO uint32_t  SYST_RVR;                          /*!< (@ 0xE000E014) SysTick Reload Value Register                          */
  __IO uint32_t  SYST_CVR;                          /*!< (@ 0xE000E018) SysTick Current Value Register                         */
  __IO uint32_t  SYST_CALIB;                        /*!< (@ 0xE000E01C) SysTick Calibration Value Register r                   */
  __I  uint32_t  RESERVED2[56];
  __IO uint32_t  NVIC_ISER0;                        /*!< (@ 0xE000E100) Interrupt Set-enable Register 0                        */
  __IO uint32_t  NVIC_ISER1;                        /*!< (@ 0xE000E104) Interrupt Set-enable Register 1                        */
  __IO uint32_t  NVIC_ISER2;                        /*!< (@ 0xE000E108) Interrupt Set-enable Register 2                        */
  __IO uint32_t  NVIC_ISER3;                        /*!< (@ 0xE000E10C) Interrupt Set-enable Register 3                        */
  __I  uint32_t  RESERVED3[28];
  __IO uint32_t  NVIC_ICER0;                        /*!< (@ 0xE000E180) Interrupt Clear-enable Register 0                      */
  __IO uint32_t  NVIC_ICER1;                        /*!< (@ 0xE000E184) Interrupt Clear-enable Register 1                      */
  __IO uint32_t  NVIC_ICER2;                        /*!< (@ 0xE000E188) Interrupt Clear-enable Register 2                      */
  __IO uint32_t  NVIC_ICER3;                        /*!< (@ 0xE000E18C) Interrupt Clear-enable Register 3                      */
  __I  uint32_t  RESERVED4[28];
  __IO uint32_t  NVIC_ISPR0;                        /*!< (@ 0xE000E200) Interrupt Set-pending Register 0                       */
  __IO uint32_t  NVIC_ISPR1;                        /*!< (@ 0xE000E204) Interrupt Set-pending Register 1                       */
  __IO uint32_t  NVIC_ISPR2;                        /*!< (@ 0xE000E208) Interrupt Set-pending Register 2                       */
  __IO uint32_t  NVIC_ISPR3;                        /*!< (@ 0xE000E20C) Interrupt Set-pending Register 3                       */
  __I  uint32_t  RESERVED5[28];
  __IO uint32_t  NVIC_ICPR0;                        /*!< (@ 0xE000E280) Interrupt Clear-pending Register 0                     */
  __IO uint32_t  NVIC_ICPR1;                        /*!< (@ 0xE000E284) Interrupt Clear-pending Register 1                     */
  __IO uint32_t  NVIC_ICPR2;                        /*!< (@ 0xE000E288) Interrupt Clear-pending Register 2                     */
  __IO uint32_t  NVIC_ICPR3;                        /*!< (@ 0xE000E28C) Interrupt Clear-pending Register 3                     */
  __I  uint32_t  RESERVED6[28];
  __IO uint32_t  NVIC_IABR0;                        /*!< (@ 0xE000E300) Interrupt Active Bit Register 0                        */
  __IO uint32_t  NVIC_IABR1;                        /*!< (@ 0xE000E304) Interrupt Active Bit Register 1                        */
  __IO uint32_t  NVIC_IABR2;                        /*!< (@ 0xE000E308) Interrupt Active Bit Register 2                        */
  __IO uint32_t  NVIC_IABR3;                        /*!< (@ 0xE000E30C) Interrupt Active Bit Register 3                        */
  __I  uint32_t  RESERVED7[60];
  __IO uint32_t  NVIC_IPR0;                         /*!< (@ 0xE000E400) Interrupt Priority Register 0                          */
  __IO uint32_t  NVIC_IPR1;                         /*!< (@ 0xE000E404) Interrupt Priority Register 1                          */
  __IO uint32_t  NVIC_IPR2;                         /*!< (@ 0xE000E408) Interrupt Priority Register 2                          */
  __IO uint32_t  NVIC_IPR3;                         /*!< (@ 0xE000E40C) Interrupt Priority Register 3                          */
  __IO uint32_t  NVIC_IPR4;                         /*!< (@ 0xE000E410) Interrupt Priority Register 4                          */
  __IO uint32_t  NVIC_IPR5;                         /*!< (@ 0xE000E414) Interrupt Priority Register 5                          */
  __IO uint32_t  NVIC_IPR6;                         /*!< (@ 0xE000E418) Interrupt Priority Register 6                          */
  __IO uint32_t  NVIC_IPR7;                         /*!< (@ 0xE000E41C) Interrupt Priority Register 7                          */
  __IO uint32_t  NVIC_IPR8;                         /*!< (@ 0xE000E420) Interrupt Priority Register 8                          */
  __IO uint32_t  NVIC_IPR9;                         /*!< (@ 0xE000E424) Interrupt Priority Register 9                          */
  __IO uint32_t  NVIC_IPR10;                        /*!< (@ 0xE000E428) Interrupt Priority Register 10                         */
  __IO uint32_t  NVIC_IPR11;                        /*!< (@ 0xE000E42C) Interrupt Priority Register 11                         */
  __IO uint32_t  NVIC_IPR12;                        /*!< (@ 0xE000E430) Interrupt Priority Register 12                         */
  __IO uint32_t  NVIC_IPR13;                        /*!< (@ 0xE000E434) Interrupt Priority Register 13                         */
  __IO uint32_t  NVIC_IPR14;                        /*!< (@ 0xE000E438) Interrupt Priority Register 14                         */
  __IO uint32_t  NVIC_IPR15;                        /*!< (@ 0xE000E43C) Interrupt Priority Register 15                         */
  __IO uint32_t  NVIC_IPR16;                        /*!< (@ 0xE000E440) Interrupt Priority Register 16                         */
  __IO uint32_t  NVIC_IPR17;                        /*!< (@ 0xE000E444) Interrupt Priority Register 17                         */
  __IO uint32_t  NVIC_IPR18;                        /*!< (@ 0xE000E448) Interrupt Priority Register 18                         */
  __IO uint32_t  NVIC_IPR19;                        /*!< (@ 0xE000E44C) Interrupt Priority Register 19                         */
  __IO uint32_t  NVIC_IPR20;                        /*!< (@ 0xE000E450) Interrupt Priority Register 20                         */
  __IO uint32_t  NVIC_IPR21;                        /*!< (@ 0xE000E454) Interrupt Priority Register 21                         */
  __IO uint32_t  NVIC_IPR22;                        /*!< (@ 0xE000E458) Interrupt Priority Register 22                         */
  __IO uint32_t  NVIC_IPR23;                        /*!< (@ 0xE000E45C) Interrupt Priority Register 23                         */
  __IO uint32_t  NVIC_IPR24;                        /*!< (@ 0xE000E460) Interrupt Priority Register 24                         */
  __IO uint32_t  NVIC_IPR25;                        /*!< (@ 0xE000E464) Interrupt Priority Register 25                         */
  __IO uint32_t  NVIC_IPR26;                        /*!< (@ 0xE000E468) Interrupt Priority Register 26                         */
  __IO uint32_t  NVIC_IPR27;                        /*!< (@ 0xE000E46C) Interrupt Priority Register 27                         */
  __I  uint32_t  RESERVED8[548];
  __I  uint32_t  CPUID;                             /*!< (@ 0xE000ED00) CPUID Base Register                                    */
  __IO uint32_t  ICSR;                              /*!< (@ 0xE000ED04) Interrupt Control and State Register                   */
  __IO uint32_t  VTOR;                              /*!< (@ 0xE000ED08) Vector Table Offset Register                           */
  __IO uint32_t  AIRCR;                             /*!< (@ 0xE000ED0C) Application Interrupt and Reset Control Register       */
  __IO uint32_t  SCR;                               /*!< (@ 0xE000ED10) System Control Register                                */
  __IO uint32_t  CCR;                               /*!< (@ 0xE000ED14) Configuration and Control Register                     */
  __IO uint32_t  SHPR1;                             /*!< (@ 0xE000ED18) System Handler Priority Register 1                     */
  __IO uint32_t  SHPR2;                             /*!< (@ 0xE000ED1C) System Handler Priority Register 2                     */
  __IO uint32_t  SHPR3;                             /*!< (@ 0xE000ED20) System Handler Priority Register 3                     */
  __IO uint32_t  SHCSR;                             /*!< (@ 0xE000ED24) System Handler Control and State Register              */
  __IO uint32_t  CFSR;                              /*!< (@ 0xE000ED28) Configurable Fault Status Register                     */
  __IO uint32_t  HFSR;                              /*!< (@ 0xE000ED2C) HardFault Status Register                              */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  MMFAR;                             /*!< (@ 0xE000ED34) MemManage Fault Address Register                       */
  __IO uint32_t  BFAR;                              /*!< (@ 0xE000ED38) BusFault Address Register                              */
  __IO uint32_t  AFSR;                              /*!< (@ 0xE000ED3C) Auxiliary Fault Status Register                        */
  __I  uint32_t  RESERVED10[18];
  __IO uint32_t  CPACR;                             /*!< (@ 0xE000ED88) Coprocessor Access Control Register                    */
  __I  uint32_t  RESERVED11;
  __I  uint32_t  MPU_TYPE;                          /*!< (@ 0xE000ED90) MPU Type Register                                      */
  __IO uint32_t  MPU_CTRL;                          /*!< (@ 0xE000ED94) MPU Control Register                                   */
  __IO uint32_t  MPU_RNR;                           /*!< (@ 0xE000ED98) MPU Region Number Register                             */
  __IO uint32_t  MPU_RBAR;                          /*!< (@ 0xE000ED9C) MPU Region Base Address Register                       */
  __IO uint32_t  MPU_RASR;                          /*!< (@ 0xE000EDA0) MPU Region Attribute and Size Register                 */
  __IO uint32_t  MPU_RBAR_A1;                       /*!< (@ 0xE000EDA4) MPU Region Base Address Register A1                    */
  __IO uint32_t  MPU_RASR_A1;                       /*!< (@ 0xE000EDA8) MPU Region Attribute and Size Register A1              */
  __IO uint32_t  MPU_RBAR_A2;                       /*!< (@ 0xE000EDAC) MPU Region Base Address Register A2                    */
  __IO uint32_t  MPU_RASR_A2;                       /*!< (@ 0xE000EDB0) MPU Region Attribute and Size Register A2              */
  __IO uint32_t  MPU_RBAR_A3;                       /*!< (@ 0xE000EDB4) MPU Region Base Address Register A3                    */
  __IO uint32_t  MPU_RASR_A3;                       /*!< (@ 0xE000EDB8) MPU Region Attribute and Size Register A3              */
  __I  uint32_t  RESERVED12[81];
  __O  uint32_t  STIR;                              /*!< (@ 0xE000EF00) Software Trigger Interrupt Register                    */
  __I  uint32_t  RESERVED13[12];
  __IO uint32_t  FPCCR;                             /*!< (@ 0xE000EF34) Floating-point Context Control Register                */
  __IO uint32_t  FPCAR;                             /*!< (@ 0xE000EF38) Floating-point Context Address Register                */
  __IO uint32_t  FPDSCR;                            /*!< (@ 0xE000EF3C) Floating-point Default Status Control Register         */
} PPB_Type;


/* ================================================================================ */
/* ================                       DLR                      ================ */
/* ================================================================================ */


/**
  * @brief DMA Line Router (DLR)
  */

typedef struct {                                    /*!< (@ 0x50004900) DLR Structure                                          */
  __I  uint32_t  OVRSTAT;                           /*!< (@ 0x50004900) Overrun Status                                         */
  __O  uint32_t  OVRCLR;                            /*!< (@ 0x50004904) Overrun Clear                                          */
  __IO uint32_t  SRSEL0;                            /*!< (@ 0x50004908) Service Request Selection 0                            */
  __IO uint32_t  SRSEL1;                            /*!< (@ 0x5000490C) Service Request Selection 1                            */
  __IO uint32_t  LNEN;                              /*!< (@ 0x50004910) Line Enable                                            */
} DLR_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                   ERU [ERU0]                   ================ */
/* ================================================================================ */


/**
  * @brief Event Request Unit 0 (ERU)
  */

typedef struct {                                    /*!< (@ 0x50004800) ERU Structure                                          */
  __IO uint32_t  EXISEL;                            /*!< (@ 0x50004800) Event Input Select                                     */
  __I  uint32_t  RESERVED[3];
  __IO uint32_t  EXICON[4];                         /*!< (@ 0x50004810) Event Input Control                                    */
  __IO uint32_t  EXOCON[4];                         /*!< (@ 0x50004820) Event Output Trigger Control                           */
} ERU_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                     GPDMA0                     ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA Unit 0 (GPDMA0)
  */

typedef struct {                                    /*!< (@ 0x500142C0) GPDMA0 Structure                                       */
  __IO uint32_t  RAWTFR;                            /*!< (@ 0x500142C0) Raw IntTfr Status                                      */
  __I  uint32_t  RESERVED;
  __IO uint32_t  RAWBLOCK;                          /*!< (@ 0x500142C8) Raw IntBlock Status                                    */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  RAWSRCTRAN;                        /*!< (@ 0x500142D0) Raw IntSrcTran Status                                  */
  __I  uint32_t  RESERVED2;
  __IO uint32_t  RAWDSTTRAN;                        /*!< (@ 0x500142D8) Raw IntBlock Status                                    */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  RAWERR;                            /*!< (@ 0x500142E0) Raw IntErr Status                                      */
  __I  uint32_t  RESERVED4;
  __I  uint32_t  STATUSTFR;                         /*!< (@ 0x500142E8) IntTfr Status                                          */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  STATUSBLOCK;                       /*!< (@ 0x500142F0) IntBlock Status                                        */
  __I  uint32_t  RESERVED6;
  __I  uint32_t  STATUSSRCTRAN;                     /*!< (@ 0x500142F8) IntSrcTran Status                                      */
  __I  uint32_t  RESERVED7;
  __I  uint32_t  STATUSDSTTRAN;                     /*!< (@ 0x50014300) IntBlock Status                                        */
  __I  uint32_t  RESERVED8;
  __I  uint32_t  STATUSERR;                         /*!< (@ 0x50014308) IntErr Status                                          */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  MASKTFR;                           /*!< (@ 0x50014310) Mask for Raw IntTfr Status                             */
  __I  uint32_t  RESERVED10;
  __IO uint32_t  MASKBLOCK;                         /*!< (@ 0x50014318) Mask for Raw IntBlock Status                           */
  __I  uint32_t  RESERVED11;
  __IO uint32_t  MASKSRCTRAN;                       /*!< (@ 0x50014320) Mask for Raw IntSrcTran Status                         */
  __I  uint32_t  RESERVED12;
  __IO uint32_t  MASKDSTTRAN;                       /*!< (@ 0x50014328) Mask for Raw IntBlock Status                           */
  __I  uint32_t  RESERVED13;
  __IO uint32_t  MASKERR;                           /*!< (@ 0x50014330) Mask for Raw IntErr Status                             */
  __I  uint32_t  RESERVED14;
  __O  uint32_t  CLEARTFR;                          /*!< (@ 0x50014338) IntTfr Status                                          */
  __I  uint32_t  RESERVED15;
  __O  uint32_t  CLEARBLOCK;                        /*!< (@ 0x50014340) IntBlock Status                                        */
  __I  uint32_t  RESERVED16;
  __O  uint32_t  CLEARSRCTRAN;                      /*!< (@ 0x50014348) IntSrcTran Status                                      */
  __I  uint32_t  RESERVED17;
  __O  uint32_t  CLEARDSTTRAN;                      /*!< (@ 0x50014350) IntBlock Status                                        */
  __I  uint32_t  RESERVED18;
  __O  uint32_t  CLEARERR;                          /*!< (@ 0x50014358) IntErr Status                                          */
  __I  uint32_t  RESERVED19;
  __I  uint32_t  STATUSINT;                         /*!< (@ 0x50014360) Combined Interrupt Status Register                     */
  __I  uint32_t  RESERVED20;
  __IO uint32_t  REQSRCREG;                         /*!< (@ 0x50014368) Source Software Transaction Request Register           */
  __I  uint32_t  RESERVED21;
  __IO uint32_t  REQDSTREG;                         /*!< (@ 0x50014370) Destination Software Transaction Request Register      */
  __I  uint32_t  RESERVED22;
  __IO uint32_t  SGLREQSRCREG;                      /*!< (@ 0x50014378) Single Source Transaction Request Register             */
  __I  uint32_t  RESERVED23;
  __IO uint32_t  SGLREQDSTREG;                      /*!< (@ 0x50014380) Single Destination Transaction Request Register        */
  __I  uint32_t  RESERVED24;
  __IO uint32_t  LSTSRCREG;                         /*!< (@ 0x50014388) Last Source Transaction Request Register               */
  __I  uint32_t  RESERVED25;
  __IO uint32_t  LSTDSTREG;                         /*!< (@ 0x50014390) Last Destination Transaction Request Register          */
  __I  uint32_t  RESERVED26;
  __IO uint32_t  DMACFGREG;                         /*!< (@ 0x50014398) GPDMA Configuration Register                           */
  __I  uint32_t  RESERVED27;
  __IO uint32_t  CHENREG;                           /*!< (@ 0x500143A0) GPDMA Channel Enable Register                          */
  __I  uint32_t  RESERVED28;
  __I  uint32_t  ID;                                /*!< (@ 0x500143A8) GPDMA0 ID Register                                     */
  __I  uint32_t  RESERVED29[19];
  __I  uint32_t  TYPE;                              /*!< (@ 0x500143F8) GPDMA Component Type                                   */
  __I  uint32_t  VERSION;                           /*!< (@ 0x500143FC) DMA Component Version                                  */
} GPDMA0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================            GPDMA0_CH0_1 [GPDMA0_CH0]           ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA Unit 0 (GPDMA0_CH0_1)
  */

typedef struct {                                    /*!< (@ 0x50014000) GPDMA0_CH0_1 Structure                                 */
  __IO uint32_t  SAR;                               /*!< (@ 0x50014000) Source Address Register                                */
  __I  uint32_t  RESERVED;
  __IO uint32_t  DAR;                               /*!< (@ 0x50014008) Destination Address Register                           */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  LLP;                               /*!< (@ 0x50014010) Linked List Pointer Register                           */
  __I  uint32_t  RESERVED2;
  __IO uint32_t  CTLL;                              /*!< (@ 0x50014018) Control Register Low                                   */
  __IO uint32_t  CTLH;                              /*!< (@ 0x5001401C) Control Register High                                  */
  __IO uint32_t  SSTAT;                             /*!< (@ 0x50014020) Source Status Register                                 */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  DSTAT;                             /*!< (@ 0x50014028) Destination Status Register                            */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  SSTATAR;                           /*!< (@ 0x50014030) Source Status Address Register                         */
  __I  uint32_t  RESERVED5;
  __IO uint32_t  DSTATAR;                           /*!< (@ 0x50014038) Destination Status Address Register                    */
  __I  uint32_t  RESERVED6;
  __IO uint32_t  CFGL;                              /*!< (@ 0x50014040) Configuration Register Low                             */
  __IO uint32_t  CFGH;                              /*!< (@ 0x50014044) Configuration Register High                            */
  __IO uint32_t  SGR;                               /*!< (@ 0x50014048) Source Gather Register                                 */
  __I  uint32_t  RESERVED7;
  __IO uint32_t  DSR;                               /*!< (@ 0x50014050) Destination Scatter Register                           */
} GPDMA0_CH_TypeDef;


/* ================================================================================ */
/* ================            GPDMA0_CH2_7 [GPDMA0_CH2]           ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA Unit 0 (GPDMA0_CH2_7)
  */

typedef struct {                                    /*!< (@ 0x500140B0) GPDMA0_CH2_7 Structure                                 */
  __IO uint32_t  SAR;                               /*!< (@ 0x500140B0) Source Address Register                                */
  __I  uint32_t  RESERVED;
  __IO uint32_t  DAR;                               /*!< (@ 0x500140B8) Destination Address Register                           */
  __I  uint32_t  RESERVED1[3];
  __IO uint32_t  CTLL;                              /*!< (@ 0x500140C8) Control Register Low                                   */
  __IO uint32_t  CTLH;                              /*!< (@ 0x500140CC) Control Register High                                  */
  __I  uint32_t  RESERVED2[8];
  __IO uint32_t  CFGL;                              /*!< (@ 0x500140F0) Configuration Register Low                             */
  __IO uint32_t  CFGH;                              /*!< (@ 0x500140F4) Configuration Register High                            */
} GPDMA0_CH2_7_Type;


/* ================================================================================ */
/* ================                     GPDMA1                     ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA Unit 1 (GPDMA1)
  */

typedef struct {                                    /*!< (@ 0x500182C0) GPDMA1 Structure                                       */
  __IO uint32_t  RAWTFR;                            /*!< (@ 0x500182C0) Raw IntTfr Status                                      */
  __I  uint32_t  RESERVED;
  __IO uint32_t  RAWBLOCK;                          /*!< (@ 0x500182C8) Raw IntBlock Status                                    */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  RAWSRCTRAN;                        /*!< (@ 0x500182D0) Raw IntSrcTran Status                                  */
  __I  uint32_t  RESERVED2;
  __IO uint32_t  RAWDSTTRAN;                        /*!< (@ 0x500182D8) Raw IntBlock Status                                    */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  RAWERR;                            /*!< (@ 0x500182E0) Raw IntErr Status                                      */
  __I  uint32_t  RESERVED4;
  __I  uint32_t  STATUSTFR;                         /*!< (@ 0x500182E8) IntTfr Status                                          */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  STATUSBLOCK;                       /*!< (@ 0x500182F0) IntBlock Status                                        */
  __I  uint32_t  RESERVED6;
  __I  uint32_t  STATUSSRCTRAN;                     /*!< (@ 0x500182F8) IntSrcTran Status                                      */
  __I  uint32_t  RESERVED7;
  __I  uint32_t  STATUSDSTTRAN;                     /*!< (@ 0x50018300) IntBlock Status                                        */
  __I  uint32_t  RESERVED8;
  __I  uint32_t  STATUSERR;                         /*!< (@ 0x50018308) IntErr Status                                          */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  MASKTFR;                           /*!< (@ 0x50018310) Mask for Raw IntTfr Status                             */
  __I  uint32_t  RESERVED10;
  __IO uint32_t  MASKBLOCK;                         /*!< (@ 0x50018318) Mask for Raw IntBlock Status                           */
  __I  uint32_t  RESERVED11;
  __IO uint32_t  MASKSRCTRAN;                       /*!< (@ 0x50018320) Mask for Raw IntSrcTran Status                         */
  __I  uint32_t  RESERVED12;
  __IO uint32_t  MASKDSTTRAN;                       /*!< (@ 0x50018328) Mask for Raw IntBlock Status                           */
  __I  uint32_t  RESERVED13;
  __IO uint32_t  MASKERR;                           /*!< (@ 0x50018330) Mask for Raw IntErr Status                             */
  __I  uint32_t  RESERVED14;
  __O  uint32_t  CLEARTFR;                          /*!< (@ 0x50018338) IntTfr Status                                          */
  __I  uint32_t  RESERVED15;
  __O  uint32_t  CLEARBLOCK;                        /*!< (@ 0x50018340) IntBlock Status                                        */
  __I  uint32_t  RESERVED16;
  __O  uint32_t  CLEARSRCTRAN;                      /*!< (@ 0x50018348) IntSrcTran Status                                      */
  __I  uint32_t  RESERVED17;
  __O  uint32_t  CLEARDSTTRAN;                      /*!< (@ 0x50018350) IntBlock Status                                        */
  __I  uint32_t  RESERVED18;
  __O  uint32_t  CLEARERR;                          /*!< (@ 0x50018358) IntErr Status                                          */
  __I  uint32_t  RESERVED19;
  __I  uint32_t  STATUSINT;                         /*!< (@ 0x50018360) Combined Interrupt Status Register                     */
  __I  uint32_t  RESERVED20;
  __IO uint32_t  REQSRCREG;                         /*!< (@ 0x50018368) Source Software Transaction Request Register           */
  __I  uint32_t  RESERVED21;
  __IO uint32_t  REQDSTREG;                         /*!< (@ 0x50018370) Destination Software Transaction Request Register      */
  __I  uint32_t  RESERVED22;
  __IO uint32_t  SGLREQSRCREG;                      /*!< (@ 0x50018378) Single Source Transaction Request Register             */
  __I  uint32_t  RESERVED23;
  __IO uint32_t  SGLREQDSTREG;                      /*!< (@ 0x50018380) Single Destination Transaction Request Register        */
  __I  uint32_t  RESERVED24;
  __IO uint32_t  LSTSRCREG;                         /*!< (@ 0x50018388) Last Source Transaction Request Register               */
  __I  uint32_t  RESERVED25;
  __IO uint32_t  LSTDSTREG;                         /*!< (@ 0x50018390) Last Destination Transaction Request Register          */
  __I  uint32_t  RESERVED26;
  __IO uint32_t  DMACFGREG;                         /*!< (@ 0x50018398) GPDMA Configuration Register                           */
  __I  uint32_t  RESERVED27;
  __IO uint32_t  CHENREG;                           /*!< (@ 0x500183A0) GPDMA Channel Enable Register                          */
  __I  uint32_t  RESERVED28;
  __I  uint32_t  ID;                                /*!< (@ 0x500183A8) GPDMA1 ID Register                                     */
  __I  uint32_t  RESERVED29[19];
  __I  uint32_t  TYPE;                              /*!< (@ 0x500183F8) GPDMA Component Type                                   */
  __I  uint32_t  VERSION;                           /*!< (@ 0x500183FC) DMA Component Version                                  */
} GPDMA1_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================             GPDMA1_CH [GPDMA1_CH0]             ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA Unit 1 (GPDMA1_CH)
  */

typedef struct {                                    /*!< (@ 0x50018000) GPDMA1_CH Structure                                    */
  __IO uint32_t  SAR;                               /*!< (@ 0x50018000) Source Address Register                                */
  __I  uint32_t  RESERVED;
  __IO uint32_t  DAR;                               /*!< (@ 0x50018008) Destination Address Register                           */
  __I  uint32_t  RESERVED1[3];
  __IO uint32_t  CTLL;                              /*!< (@ 0x50018018) Control Register Low                                   */
  __IO uint32_t  CTLH;                              /*!< (@ 0x5001801C) Control Register High                                  */
  __I  uint32_t  RESERVED2[8];
  __IO uint32_t  CFGL;                              /*!< (@ 0x50018040) Configuration Register Low                             */
  __IO uint32_t  CFGH;                              /*!< (@ 0x50018044) Configuration Register High                            */
} GPDMA1_CH_TypeDef;


/* ================================================================================ */
/* ================                       FCE                      ================ */
/* ================================================================================ */


/**
  * @brief Flexible CRC Engine (FCE)
  */

typedef struct {                                    /*!< (@ 0x50020000) FCE Structure                                          */
  __IO uint32_t  CLC;                               /*!< (@ 0x50020000) Clock Control Register                                 */
  __I  uint32_t  RESERVED;
  __I  uint32_t  ID;                                /*!< (@ 0x50020008) Module Identification Register                         */
} FCE_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                FCE_KE [FCE_KE0]                ================ */
/* ================================================================================ */


/**
  * @brief Flexible CRC Engine (FCE_KE)
  */

typedef struct {                                    /*!< (@ 0x50020020) FCE_KE Structure                                       */
  __IO uint32_t  IR;                                /*!< (@ 0x50020020) Input Register                                         */
  __I  uint32_t  RES;                               /*!< (@ 0x50020024) CRC Result Register                                    */
  __IO uint32_t  CFG;                               /*!< (@ 0x50020028) CRC Configuration Register                             */
  __IO uint32_t  STS;                               /*!< (@ 0x5002002C) CRC Status Register                                    */
  __IO uint32_t  LENGTH;                            /*!< (@ 0x50020030) CRC Length Register                                    */
  __IO uint32_t  CHECK;                             /*!< (@ 0x50020034) CRC Check Register                                     */
  __IO uint32_t  CRC;                               /*!< (@ 0x50020038) CRC Register                                           */
  __IO uint32_t  CTR;                               /*!< (@ 0x5002003C) CRC Test Register                                      */
} FCE_KE_TypeDef;


/* ================================================================================ */
/* ================                   PBA [PBA0]                   ================ */
/* ================================================================================ */


/**
  * @brief Peripheral Bridge AHB 0 (PBA)
  */

typedef struct {                                    /*!< (@ 0x40000000) PBA Structure                                          */
  __IO uint32_t  STS;                               /*!< (@ 0x40000000) Peripheral Bridge Status Register                      */
  __I  uint32_t  WADDR;                             /*!< (@ 0x40000004) PBA Write Error Address Register                       */
} PBA_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                 FLASH [FLASH0]                 ================ */
/* ================================================================================ */


/**
  * @brief Flash Memory Controller (FLASH)
  */

typedef struct {                                    /*!< (@ 0x58001000) FLASH Structure                                        */
  __I  uint32_t  RESERVED[1026];
  __I  uint32_t  ID;                                /*!< (@ 0x58002008) Flash Module Identification Register                   */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  FSR;                               /*!< (@ 0x58002010) Flash Status Register                                  */
  __IO uint32_t  FCON;                              /*!< (@ 0x58002014) Flash Configuration Register                           */
  __IO uint32_t  MARP;                              /*!< (@ 0x58002018) Margin Control Register PFLASH                         */
  __I  uint32_t  RESERVED2;
  __I  uint32_t  PROCON0;                           /*!< (@ 0x58002020) Flash Protection Configuration Register User
                                                         0                                                                     */
  __I  uint32_t  PROCON1;                           /*!< (@ 0x58002024) Flash Protection Configuration Register User
                                                         1                                                                     */
  __I  uint32_t  PROCON2;                           /*!< (@ 0x58002028) Flash Protection Configuration Register User
                                                         2                                                                     */
} FLASH0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                      PREF                      ================ */
/* ================================================================================ */


/**
  * @brief Prefetch Unit (PREF)
  */

typedef struct {                                    /*!< (@ 0x58004000) PREF Structure                                         */
  __IO uint32_t  PCON;                              /*!< (@ 0x58004000) Prefetch Configuration Register                        */
} PREF_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                   PMU [PMU0]                   ================ */
/* ================================================================================ */


/**
  * @brief Program Management Unit (PMU)
  */

typedef struct {                                    /*!< (@ 0x58000508) PMU Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x58000508) PMU0 Identification Register                           */
} PMU0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                       WDT                      ================ */
/* ================================================================================ */


/**
  * @brief Watch Dog Timer (WDT)
  */

typedef struct {                                    /*!< (@ 0x50008000) WDT Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x50008000) WDT ID Register                                        */
  __IO uint32_t  CTR;                               /*!< (@ 0x50008004) WDT Control Register                                   */
  __O  uint32_t  SRV;                               /*!< (@ 0x50008008) WDT Service Register                                   */
  __I  uint32_t  TIM;                               /*!< (@ 0x5000800C) WDT Timer Register                                     */
  __IO uint32_t  WLB;                               /*!< (@ 0x50008010) WDT Window Lower Bound Register                        */
  __IO uint32_t  WUB;                               /*!< (@ 0x50008014) WDT Window Upper Bound Register                        */
  __I  uint32_t  WDTSTS;                            /*!< (@ 0x50008018) WDT Status Register                                    */
  __O  uint32_t  WDTCLR;                            /*!< (@ 0x5000801C) WDT Clear Register                                     */
} WDT_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                       RTC                      ================ */
/* ================================================================================ */


/**
  * @brief Real Time Clock (RTC)
  */

typedef struct {                                    /*!< (@ 0x50004A00) RTC Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x50004A00) RTC ID Register                                        */
  __IO uint32_t  CTR;                               /*!< (@ 0x50004A04) RTC Control Register                                   */
  __I  uint32_t  RAWSTAT;                           /*!< (@ 0x50004A08) RTC Raw Service Request Register                       */
  __I  uint32_t  STSSR;                             /*!< (@ 0x50004A0C) RTC Service Request Status Register                    */
  __IO uint32_t  MSKSR;                             /*!< (@ 0x50004A10) RTC Service Request Mask Register                      */
  __O  uint32_t  CLRSR;                             /*!< (@ 0x50004A14) RTC Clear Service Request Register                     */
  __IO uint32_t  ATIM0;                             /*!< (@ 0x50004A18) RTC Alarm Time Register 0                              */
  __IO uint32_t  ATIM1;                             /*!< (@ 0x50004A1C) RTC Alarm Time Register 1                              */
  __IO uint32_t  TIM0;                              /*!< (@ 0x50004A20) RTC Time Register 0                                    */
  __IO uint32_t  TIM1;                              /*!< (@ 0x50004A24) RTC Time Register 1                                    */
} RTC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                     SCU_CLK                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_CLK)
  */

typedef struct {                                    /*!< (@ 0x50004600) SCU_CLK Structure                                      */
  __I  uint32_t  CLKSTAT;                           /*!< (@ 0x50004600) Clock Status Register                                  */
  __O  uint32_t  CLKSET;                            /*!< (@ 0x50004604) CLK Set Register                                       */
  __O  uint32_t  CLKCLR;                            /*!< (@ 0x50004608) CLK Clear Register                                     */
  __IO uint32_t  SYSCLKCR;                          /*!< (@ 0x5000460C) System Clock Control Register                          */
  __IO uint32_t  CPUCLKCR;                          /*!< (@ 0x50004610) CPU Clock Control Register                             */
  __IO uint32_t  PBCLKCR;                           /*!< (@ 0x50004614) Peripheral Bus Clock Control Register                  */
  __IO uint32_t  USBCLKCR;                          /*!< (@ 0x50004618) USB Clock Control Register                             */
  __IO uint32_t  EBUCLKCR;                          /*!< (@ 0x5000461C) EBU Clock Control Register                             */
  __IO uint32_t  CCUCLKCR;                          /*!< (@ 0x50004620) CCU Clock Control Register                             */
  __IO uint32_t  WDTCLKCR;                          /*!< (@ 0x50004624) WDT Clock Control Register                             */
  __IO uint32_t  EXTCLKCR;                          /*!< (@ 0x50004628) External Clock Control                                 */
  __IO uint32_t  MLINKCLKCR;                        /*!< (@ 0x5000462C) Multi-Link Clock Control                               */
  __IO uint32_t  SLEEPCR;                           /*!< (@ 0x50004630) Sleep Control Register                                 */
  __IO uint32_t  DSLEEPCR;                          /*!< (@ 0x50004634) Deep Sleep Control Register                            */
  __IO uint32_t  ECATCLKCR;                         /*!< (@ 0x50004638) EtherCAT Clock Control Register                        */
  __I  uint32_t  RESERVED;
  __I  uint32_t  CGATSTAT0;                         /*!< (@ 0x50004640) Peripheral 0 Clock Gating Status                       */
  __O  uint32_t  CGATSET0;                          /*!< (@ 0x50004644) Peripheral 0 Clock Gating Set                          */
  __O  uint32_t  CGATCLR0;                          /*!< (@ 0x50004648) Peripheral 0 Clock Gating Clear                        */
  __I  uint32_t  CGATSTAT1;                         /*!< (@ 0x5000464C) Peripheral 1 Clock Gating Status                       */
  __O  uint32_t  CGATSET1;                          /*!< (@ 0x50004650) Peripheral 1 Clock Gating Set                          */
  __O  uint32_t  CGATCLR1;                          /*!< (@ 0x50004654) Peripheral 1 Clock Gating Clear                        */
  __I  uint32_t  CGATSTAT2;                         /*!< (@ 0x50004658) Peripheral 2 Clock Gating Status                       */
  __O  uint32_t  CGATSET2;                          /*!< (@ 0x5000465C) Peripheral 2 Clock Gating Set                          */
  __O  uint32_t  CGATCLR2;                          /*!< (@ 0x50004660) Peripheral 2 Clock Gating Clear                        */
  __I  uint32_t  CGATSTAT3;                         /*!< (@ 0x50004664) Peripheral 3 Clock Gating Status                       */
  __O  uint32_t  CGATSET3;                          /*!< (@ 0x50004668) Peripheral 3 Clock Gating Set                          */
  __O  uint32_t  CGATCLR3;                          /*!< (@ 0x5000466C) Peripheral 3 Clock Gating Clear                        */
} SCU_CLK_TypeDef;


/* ================================================================================ */
/* ================                     SCU_OSC                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_OSC)
  */

typedef struct {                                    /*!< (@ 0x50004700) SCU_OSC Structure                                      */
  __I  uint32_t  OSCHPSTAT;                         /*!< (@ 0x50004700) OSC_HP Status Register                                 */
  __IO uint32_t  OSCHPCTRL;                         /*!< (@ 0x50004704) OSC_HP Control Register                                */
  __I  uint32_t  RESERVED;
  __IO uint32_t  CLKCALCONST;                       /*!< (@ 0x5000470C) Clock Calibration Constant Register                    */
} SCU_OSC_TypeDef;


/* ================================================================================ */
/* ================                     SCU_PLL                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_PLL)
  */

typedef struct {                                    /*!< (@ 0x50004710) SCU_PLL Structure                                      */
  __I  uint32_t  PLLSTAT;                           /*!< (@ 0x50004710) PLL Status Register                                    */
  __IO uint32_t  PLLCON0;                           /*!< (@ 0x50004714) PLL Configuration 0 Register                           */
  __IO uint32_t  PLLCON1;                           /*!< (@ 0x50004718) PLL Configuration 1 Register                           */
  __IO uint32_t  PLLCON2;                           /*!< (@ 0x5000471C) PLL Configuration 2 Register                           */
  __I  uint32_t  USBPLLSTAT;                        /*!< (@ 0x50004720) USB PLL Status Register                                */
  __IO uint32_t  USBPLLCON;                         /*!< (@ 0x50004724) USB PLL Configuration Register                         */
  __I  uint32_t  RESERVED[4];
  __I  uint32_t  CLKMXSTAT;                         /*!< (@ 0x50004738) Clock Multiplexing Status Register                     */
} SCU_PLL_TypeDef;


/* ================================================================================ */
/* ================                   SCU_GENERAL                  ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_GENERAL)
  */

typedef struct {                                    /*!< (@ 0x50004000) SCU_GENERAL Structure                                  */
  __I  uint32_t  ID;                                /*!< (@ 0x50004000) SCU Module ID Register                                 */
  __I  uint32_t  IDCHIP;                            /*!< (@ 0x50004004) Chip ID Register                                       */
  __I  uint32_t  IDMANUF;                           /*!< (@ 0x50004008) Manufactory ID Register                                */
  __I  uint32_t  RESERVED;
  __IO uint32_t  STCON;                             /*!< (@ 0x50004010) Startup Configuration Register                         */
  __I  uint32_t  RESERVED1[6];
  __IO uint32_t  GPR[2];                            /*!< (@ 0x5000402C) General Purpose Register 0                             */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  CCUCON;                            /*!< (@ 0x5000404C) CCU Control Register                                   */
  __I  uint32_t  RESERVED3[15];
  __IO uint32_t  DTSCON;                            /*!< (@ 0x5000408C) Die Temperature Sensor Control Register                */
  __I  uint32_t  DTSSTAT;                           /*!< (@ 0x50004090) Die Temperature Sensor Status Register                 */
  __I  uint32_t  RESERVED4[2];
  __IO uint32_t  SDMMCDEL;                          /*!< (@ 0x5000409C) SD-MMC Delay Control Register                          */
  __IO uint32_t  GORCEN[2];                         /*!< (@ 0x500040A0) Out of Range Comparator Enable Register 0              */
  __I  uint32_t  RESERVED5[7];
  __I  uint32_t  MIRRSTS;                           /*!< (@ 0x500040C4) Mirror Write Status Register                           */
  __IO uint32_t  RMACR;                             /*!< (@ 0x500040C8) Retention Memory Access Control Register               */
  __IO uint32_t  RMDATA;                            /*!< (@ 0x500040CC) Retention Memory Access Data Register                  */
} SCU_GENERAL_TypeDef;


/* ================================================================================ */
/* ================                  SCU_INTERRUPT                 ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_INTERRUPT)
  */

typedef struct {                                    /*!< (@ 0x50004074) SCU_INTERRUPT Structure                                */
  __I  uint32_t  SRSTAT;                            /*!< (@ 0x50004074) SCU Service Request Status                             */
  __I  uint32_t  SRRAW;                             /*!< (@ 0x50004078) SCU Raw Service Request Status                         */
  __IO uint32_t  SRMSK;                             /*!< (@ 0x5000407C) SCU Service Request Mask                               */
  __O  uint32_t  SRCLR;                             /*!< (@ 0x50004080) SCU Service Request Clear                              */
  __O  uint32_t  SRSET;                             /*!< (@ 0x50004084) SCU Service Request Set                                */
  __IO uint32_t  NMIREQEN;                          /*!< (@ 0x50004088) SCU Service Request Mask                               */
} SCU_INTERRUPT_TypeDef;


/* ================================================================================ */
/* ================                   SCU_PARITY                   ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_PARITY)
  */

typedef struct {                                    /*!< (@ 0x5000413C) SCU_PARITY Structure                                   */
  __IO uint32_t  PEEN;                              /*!< (@ 0x5000413C) Parity Error Enable Register                           */
  __IO uint32_t  MCHKCON;                           /*!< (@ 0x50004140) Memory Checking Control Register                       */
  __IO uint32_t  PETE;                              /*!< (@ 0x50004144) Parity Error Trap Enable Register                      */
  __IO uint32_t  PERSTEN;                           /*!< (@ 0x50004148) Parity Error Reset Enable Register                     */
  __I  uint32_t  RESERVED;
  __IO uint32_t  PEFLAG;                            /*!< (@ 0x50004150) Parity Error Flag Register                             */
  __IO uint32_t  PMTPR;                             /*!< (@ 0x50004154) Parity Memory Test Pattern Register                    */
  __IO uint32_t  PMTSR;                             /*!< (@ 0x50004158) Parity Memory Test Select Register                     */
} SCU_PARITY_TypeDef;


/* ================================================================================ */
/* ================                    SCU_TRAP                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_TRAP)
  */

typedef struct {                                    /*!< (@ 0x50004160) SCU_TRAP Structure                                     */
  __I  uint32_t  TRAPSTAT;                          /*!< (@ 0x50004160) Trap Status Register                                   */
  __I  uint32_t  TRAPRAW;                           /*!< (@ 0x50004164) Trap Raw Status Register                               */
  __IO uint32_t  TRAPDIS;                           /*!< (@ 0x50004168) Trap Disable Register                                  */
  __O  uint32_t  TRAPCLR;                           /*!< (@ 0x5000416C) Trap Clear Register                                    */
  __O  uint32_t  TRAPSET;                           /*!< (@ 0x50004170) Trap Set Register                                      */
} SCU_TRAP_TypeDef;


/* ================================================================================ */
/* ================                  SCU_HIBERNATE                 ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_HIBERNATE)
  */

typedef struct {                                    /*!< (@ 0x50004300) SCU_HIBERNATE Structure                                */
  __I  uint32_t  HDSTAT;                            /*!< (@ 0x50004300) Hibernate Domain Status Register                       */
  __O  uint32_t  HDCLR;                             /*!< (@ 0x50004304) Hibernate Domain Status Clear Register                 */
  __O  uint32_t  HDSET;                             /*!< (@ 0x50004308) Hibernate Domain Status Set Register                   */
  __IO uint32_t  HDCR;                              /*!< (@ 0x5000430C) Hibernate Domain Control Register                      */
  __I  uint32_t  RESERVED;
  __IO uint32_t  OSCSICTRL;                         /*!< (@ 0x50004314) fOSI Control Register                                  */
  __I  uint32_t  OSCULSTAT;                         /*!< (@ 0x50004318) OSC_ULP Status Register                                */
  __IO uint32_t  OSCULCTRL;                         /*!< (@ 0x5000431C) OSC_ULP Control Register                               */
} SCU_HIBERNATE_TypeDef;


/* ================================================================================ */
/* ================                    SCU_POWER                   ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_POWER)
  */

typedef struct {                                    /*!< (@ 0x50004200) SCU_POWER Structure                                    */
  __I  uint32_t  PWRSTAT;                           /*!< (@ 0x50004200) PCU Status Register                                    */
  __O  uint32_t  PWRSET;                            /*!< (@ 0x50004204) PCU Set Control Register                               */
  __O  uint32_t  PWRCLR;                            /*!< (@ 0x50004208) PCU Clear Control Register                             */
  __I  uint32_t  RESERVED;
  __I  uint32_t  EVRSTAT;                           /*!< (@ 0x50004210) EVR Status Register                                    */
  __I  uint32_t  EVRVADCSTAT;                       /*!< (@ 0x50004214) EVR VADC Status Register                               */
  __I  uint32_t  RESERVED1[5];
  __IO uint32_t  PWRMON;                            /*!< (@ 0x5000422C) Power Monitor Control                                  */
} SCU_POWER_TypeDef;


/* ================================================================================ */
/* ================                    SCU_RESET                   ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_RESET)
  */

typedef struct {                                    /*!< (@ 0x50004400) SCU_RESET Structure                                    */
  __I  uint32_t  RSTSTAT;                           /*!< (@ 0x50004400) RCU Reset Status                                       */
  __O  uint32_t  RSTSET;                            /*!< (@ 0x50004404) RCU Reset Set Register                                 */
  __O  uint32_t  RSTCLR;                            /*!< (@ 0x50004408) RCU Reset Clear Register                               */
  __I  uint32_t  PRSTAT0;                           /*!< (@ 0x5000440C) RCU Peripheral 0 Reset Status                          */
  __O  uint32_t  PRSET0;                            /*!< (@ 0x50004410) RCU Peripheral 0 Reset Set                             */
  __O  uint32_t  PRCLR0;                            /*!< (@ 0x50004414) RCU Peripheral 0 Reset Clear                           */
  __I  uint32_t  PRSTAT1;                           /*!< (@ 0x50004418) RCU Peripheral 1 Reset Status                          */
  __O  uint32_t  PRSET1;                            /*!< (@ 0x5000441C) RCU Peripheral 1 Reset Set                             */
  __O  uint32_t  PRCLR1;                            /*!< (@ 0x50004420) RCU Peripheral 1 Reset Clear                           */
  __I  uint32_t  PRSTAT2;                           /*!< (@ 0x50004424) RCU Peripheral 2 Reset Status                          */
  __O  uint32_t  PRSET2;                            /*!< (@ 0x50004428) RCU Peripheral 2 Reset Set                             */
  __O  uint32_t  PRCLR2;                            /*!< (@ 0x5000442C) RCU Peripheral 2 Reset Clear                           */
  __I  uint32_t  PRSTAT3;                           /*!< (@ 0x50004430) RCU Peripheral 3 Reset Status                          */
  __O  uint32_t  PRSET3;                            /*!< (@ 0x50004434) RCU Peripheral 3 Reset Set                             */
  __O  uint32_t  PRCLR3;                            /*!< (@ 0x50004438) RCU Peripheral 3 Reset Clear                           */
} SCU_RESET_TypeDef;


/* ================================================================================ */
/* ================                 LEDTS [LEDTS0]                 ================ */
/* ================================================================================ */


/**
  * @brief LED and Touch Sense Unit 0 (LEDTS)
  */

typedef struct {                                    /*!< (@ 0x48010000) LEDTS Structure                                        */
  __I  uint32_t  ID;                                /*!< (@ 0x48010000) Module Identification Register                         */
  __IO uint32_t  GLOBCTL;                           /*!< (@ 0x48010004) Global Control Register                                */
  __IO uint32_t  FNCTL;                             /*!< (@ 0x48010008) Function Control Register                              */
  __O  uint32_t  EVFR;                              /*!< (@ 0x4801000C) Event Flag Register                                    */
  __IO uint32_t  TSVAL;                             /*!< (@ 0x48010010) Touch-sense TS-Counter Value                           */
  __IO uint32_t  LINE0;                             /*!< (@ 0x48010014) Line Pattern Register 0                                */
  __IO uint32_t  LINE1;                             /*!< (@ 0x48010018) Line Pattern Register 1                                */
  __IO uint32_t  LDCMP0;                            /*!< (@ 0x4801001C) LED Compare Register 0                                 */
  __IO uint32_t  LDCMP1;                            /*!< (@ 0x48010020) LED Compare Register 1                                 */
  __IO uint32_t  TSCMP0;                            /*!< (@ 0x48010024) Touch-sense Compare Register 0                         */
  __IO uint32_t  TSCMP1;                            /*!< (@ 0x48010028) Touch-sense Compare Register 1                         */
} LEDTS0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                    SDMMC_CON                   ================ */
/* ================================================================================ */


/**
  * @brief SD and Multimediacard Control Register (SDMMC_CON)
  */

typedef struct {                                    /*!< (@ 0x500040B4) SDMMC_CON Structure                                    */
  __IO uint32_t  SDMMC_CON;                         /*!< (@ 0x500040B4) SDMMC Configuration                                    */
} SDMMC_CON_Type;


/* ================================================================================ */
/* ================                      SDMMC                     ================ */
/* ================================================================================ */


/**
  * @brief SD and Multimediacard Interface (SDMMC)
  */

typedef struct {                                    /*!< (@ 0x4801C000) SDMMC Structure                                        */
  __I  uint32_t  RESERVED;
  __IO uint16_t  BLOCK_SIZE;                        /*!< (@ 0x4801C004) Block Size Register                                    */
  __IO uint16_t  BLOCK_COUNT;                       /*!< (@ 0x4801C006) Block Count Register                                   */
  __IO uint32_t  ARGUMENT1;                         /*!< (@ 0x4801C008) Argument1 Register                                     */
  __IO uint16_t  TRANSFER_MODE;                     /*!< (@ 0x4801C00C) Transfer Mode Register                                 */
  __IO uint16_t  COMMAND;                           /*!< (@ 0x4801C00E) Command Register                                       */
  __I  uint32_t  RESPONSE0;                         /*!< (@ 0x4801C010) Response 0 Register                                    */
  __I  uint32_t  RESPONSE2;                         /*!< (@ 0x4801C014) Response 2 Register                                    */
  __I  uint32_t  RESPONSE4;                         /*!< (@ 0x4801C018) Response 4 Register                                    */
  __I  uint32_t  RESPONSE6;                         /*!< (@ 0x4801C01C) Response 6 Register                                    */
  __IO uint32_t  DATA_BUFFER;                       /*!< (@ 0x4801C020) Data Buffer Register                                   */
  __I  uint32_t  PRESENT_STATE;                     /*!< (@ 0x4801C024) Present State Register                                 */
  __IO uint8_t   HOST_CTRL;                         /*!< (@ 0x4801C028) Host Control Register                                  */
  __IO uint8_t   POWER_CTRL;                        /*!< (@ 0x4801C029) Power Control Register                                 */
  __IO uint8_t   BLOCK_GAP_CTRL;                    /*!< (@ 0x4801C02A) Block Gap Control Register                             */
  __IO uint8_t   WAKEUP_CTRL;                       /*!< (@ 0x4801C02B) Wake-up Control Register                               */
  __IO uint16_t  CLOCK_CTRL;                        /*!< (@ 0x4801C02C) Clock Control Register                                 */
  __IO uint8_t   TIMEOUT_CTRL;                      /*!< (@ 0x4801C02E) Timeout Control Register                               */
  __IO uint8_t   SW_RESET;                          /*!< (@ 0x4801C02F) Software Reset Register                                */
  __IO uint16_t  INT_STATUS_NORM;                   /*!< (@ 0x4801C030) Normal Interrupt Status Register                       */
  __IO uint16_t  INT_STATUS_ERR;                    /*!< (@ 0x4801C032) Error Interrupt Status Register                        */
  __IO uint16_t  EN_INT_STATUS_NORM;                /*!< (@ 0x4801C034) Normal Interrupt Status Enable Register                */
  __IO uint16_t  EN_INT_STATUS_ERR;                 /*!< (@ 0x4801C036) Error Interrupt Status Enable Register                 */
  __IO uint16_t  EN_INT_SIGNAL_NORM;                /*!< (@ 0x4801C038) Normal Interrupt Signal Enable Register                */
  __IO uint16_t  EN_INT_SIGNAL_ERR;                 /*!< (@ 0x4801C03A) Error Interrupt Signal Enable Register                 */
  __I  uint16_t  ACMD_ERR_STATUS;                   /*!< (@ 0x4801C03C) Auto CMD Error Status Register                         */
  __I  uint16_t  RESERVED1;
  __I  uint32_t  CAPABILITIES;                      /*!< (@ 0x4801C040) Capabilities Register                                  */
  __I  uint32_t  CAPABILITIES_HI;                   /*!< (@ 0x4801C044) Capabilities Register High                             */
  __I  uint32_t  MAX_CURRENT_CAP;                   /*!< (@ 0x4801C048) Maximum Current Capabilities Register                  */
  __I  uint32_t  RESERVED2;
  __O  uint16_t  FORCE_EVENT_ACMD_ERR_STATUS;       /*!< (@ 0x4801C050) Force Event Register for Auto CMD Error Status         */
  __O  uint16_t  FORCE_EVENT_ERR_STATUS;            /*!< (@ 0x4801C052) Force Event Register for Error Interrupt Status        */
  __I  uint32_t  RESERVED3[8];
  __O  uint32_t  DEBUG_SEL;                         /*!< (@ 0x4801C074) Debug Selection Register                               */
  __I  uint32_t  RESERVED4[30];
  __IO uint32_t  SPI;                               /*!< (@ 0x4801C0F0) SPI Interrupt Support Register                         */
  __I  uint32_t  RESERVED5[2];
  __I  uint16_t  SLOT_INT_STATUS;                   /*!< (@ 0x4801C0FC) Slot Interrupt Status Register                         */
} SDMMC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                       EBU                      ================ */
/* ================================================================================ */


/**
  * @brief External Bus Unit (EBU)
  */

typedef struct {                                    /*!< (@ 0x58008000) EBU Structure                                          */
  __IO uint32_t  CLC;                               /*!< (@ 0x58008000) EBU Clock Control Register                             */
  __IO uint32_t  MODCON;                            /*!< (@ 0x58008004) EBU Configuration Register                             */
  __I  uint32_t  ID;                                /*!< (@ 0x58008008) EBU Module Identification Register                     */
  __IO uint32_t  USERCON;                           /*!< (@ 0x5800800C) EBU Test/Control Configuration Register                */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  ADDRSEL0;                          /*!< (@ 0x58008018) EBU Address Select Register 0                          */
  __IO uint32_t  ADDRSEL1;                          /*!< (@ 0x5800801C) EBU Address Select Register 1                          */
  __IO uint32_t  ADDRSEL2;                          /*!< (@ 0x58008020) EBU Address Select Register 2                          */
  __IO uint32_t  ADDRSEL3;                          /*!< (@ 0x58008024) EBU Address Select Register 3                          */
  __IO uint32_t  BUSRCON0;                          /*!< (@ 0x58008028) EBU Bus Configuration Register                         */
  __IO uint32_t  BUSRAP0;                           /*!< (@ 0x5800802C) EBU Bus Read Access Parameter Register                 */
  __IO uint32_t  BUSWCON0;                          /*!< (@ 0x58008030) EBU Bus Write Configuration Register                   */
  __IO uint32_t  BUSWAP0;                           /*!< (@ 0x58008034) EBU Bus Write Access Parameter Register                */
  __IO uint32_t  BUSRCON1;                          /*!< (@ 0x58008038) EBU Bus Configuration Register                         */
  __IO uint32_t  BUSRAP1;                           /*!< (@ 0x5800803C) EBU Bus Read Access Parameter Register                 */
  __IO uint32_t  BUSWCON1;                          /*!< (@ 0x58008040) EBU Bus Write Configuration Register                   */
  __IO uint32_t  BUSWAP1;                           /*!< (@ 0x58008044) EBU Bus Write Access Parameter Register                */
  __IO uint32_t  BUSRCON2;                          /*!< (@ 0x58008048) EBU Bus Configuration Register                         */
  __IO uint32_t  BUSRAP2;                           /*!< (@ 0x5800804C) EBU Bus Read Access Parameter Register                 */
  __IO uint32_t  BUSWCON2;                          /*!< (@ 0x58008050) EBU Bus Write Configuration Register                   */
  __IO uint32_t  BUSWAP2;                           /*!< (@ 0x58008054) EBU Bus Write Access Parameter Register                */
  __IO uint32_t  BUSRCON3;                          /*!< (@ 0x58008058) EBU Bus Configuration Register                         */
  __IO uint32_t  BUSRAP3;                           /*!< (@ 0x5800805C) EBU Bus Read Access Parameter Register                 */
  __IO uint32_t  BUSWCON3;                          /*!< (@ 0x58008060) EBU Bus Write Configuration Register                   */
  __IO uint32_t  BUSWAP3;                           /*!< (@ 0x58008064) EBU Bus Write Access Parameter Register                */
  __IO uint32_t  SDRMCON;                           /*!< (@ 0x58008068) EBU SDRAM Control Register                             */
  __IO uint32_t  SDRMOD;                            /*!< (@ 0x5800806C) EBU SDRAM Mode Register                                */
  __IO uint32_t  SDRMREF;                           /*!< (@ 0x58008070) EBU SDRAM Refresh Control Register                     */
  __I  uint32_t  SDRSTAT;                           /*!< (@ 0x58008074) EBU SDRAM Status Register                              */
} EBU_Type;


/* ================================================================================ */
/* ================                    ETH0_CON                    ================ */
/* ================================================================================ */


/**
  * @brief Ethernet Control Register (ETH0_CON)
  */

typedef struct {                                    /*!< (@ 0x50004040) ETH0_CON Structure                                     */
  __IO uint32_t  CON;                          /*!< (@ 0x50004040) Ethernet 0 Port Control Register                       */
} ETH0_CON_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                   ETH [ETH0]                   ================ */
/* ================================================================================ */


/**
  * @brief Ethernet Unit 0 (ETH)
  */

typedef struct {                                    /*!< (@ 0x5000C000) ETH Structure                                          */
  __IO uint32_t  MAC_CONFIGURATION;                 /*!< (@ 0x5000C000) MAC Configuration Register                             */
  __IO uint32_t  MAC_FRAME_FILTER;                  /*!< (@ 0x5000C004) MAC Frame Filter                                       */
  __IO uint32_t  HASH_TABLE_HIGH;                   /*!< (@ 0x5000C008) Hash Table High Register                               */
  __IO uint32_t  HASH_TABLE_LOW;                    /*!< (@ 0x5000C00C) Hash Table Low Register                                */
  __IO uint32_t  GMII_ADDRESS;                      /*!< (@ 0x5000C010) MII Address Register                                   */
  __IO uint32_t  GMII_DATA;                         /*!< (@ 0x5000C014) MII Data Register                                      */
  __IO uint32_t  FLOW_CONTROL;                      /*!< (@ 0x5000C018) Flow Control Register                                  */
  __IO uint32_t  VLAN_TAG;                          /*!< (@ 0x5000C01C) VLAN Tag Register                                      */
  __I  uint32_t  VERSION;                           /*!< (@ 0x5000C020) Version Register                                       */
  __I  uint32_t  DEBUG;                             /*!< (@ 0x5000C024) Debug Register                                         */
  __IO uint32_t  REMOTE_WAKE_UP_FRAME_FILTER;       /*!< (@ 0x5000C028) Remote Wake Up Frame Filter Register                   */
  __IO uint32_t  PMT_CONTROL_STATUS;                /*!< (@ 0x5000C02C) PMT Control and Status Register                        */
  __I  uint32_t  RESERVED[2];
  __I  uint32_t  INTERRUPT_STATUS;                  /*!< (@ 0x5000C038) Interrupt Register                                     */
  __IO uint32_t  INTERRUPT_MASK;                    /*!< (@ 0x5000C03C) Interrupt Mask Register                                */
  __IO uint32_t  MAC_ADDRESS0_HIGH;                 /*!< (@ 0x5000C040) MAC Address0 High Register                             */
  __IO uint32_t  MAC_ADDRESS0_LOW;                  /*!< (@ 0x5000C044) MAC Address0 Low Register                              */
  __IO uint32_t  MAC_ADDRESS1_HIGH;                 /*!< (@ 0x5000C048) MAC Address1 High Register                             */
  __IO uint32_t  MAC_ADDRESS1_LOW;                  /*!< (@ 0x5000C04C) MAC Address1 Low Register                              */
  __IO uint32_t  MAC_ADDRESS2_HIGH;                 /*!< (@ 0x5000C050) MAC Address2 High Register                             */
  __IO uint32_t  MAC_ADDRESS2_LOW;                  /*!< (@ 0x5000C054) MAC Address2 Low Register                              */
  __IO uint32_t  MAC_ADDRESS3_HIGH;                 /*!< (@ 0x5000C058) MAC Address3 High Register                             */
  __IO uint32_t  MAC_ADDRESS3_LOW;                  /*!< (@ 0x5000C05C) MAC Address3 Low Register                              */
  __I  uint32_t  RESERVED1[40];
  __IO uint32_t  MMC_CONTROL;                       /*!< (@ 0x5000C100) MMC Control Register                                   */
  __I  uint32_t  MMC_RECEIVE_INTERRUPT;             /*!< (@ 0x5000C104) MMC Receive Interrupt Register                         */
  __I  uint32_t  MMC_TRANSMIT_INTERRUPT;            /*!< (@ 0x5000C108) MMC Transmit Interrupt Register                        */
  __IO uint32_t  MMC_RECEIVE_INTERRUPT_MASK;        /*!< (@ 0x5000C10C) MMC Reveive Interrupt Mask Register                    */
  __IO uint32_t  MMC_TRANSMIT_INTERRUPT_MASK;       /*!< (@ 0x5000C110) MMC Transmit Interrupt Mask Register                   */
  __I  uint32_t  TX_OCTET_COUNT_GOOD_BAD;           /*!< (@ 0x5000C114) Transmit Octet Count for Good and Bad Frames
                                                         Register                                                              */
  __I  uint32_t  TX_FRAME_COUNT_GOOD_BAD;           /*!< (@ 0x5000C118) Transmit Frame Count for Goodand Bad Frames Register   */
  __I  uint32_t  TX_BROADCAST_FRAMES_GOOD;          /*!< (@ 0x5000C11C) Transmit Frame Count for Good Broadcast Frames         */
  __I  uint32_t  TX_MULTICAST_FRAMES_GOOD;          /*!< (@ 0x5000C120) Transmit Frame Count for Good Multicast Frames         */
  __I  uint32_t  TX_64OCTETS_FRAMES_GOOD_BAD;       /*!< (@ 0x5000C124) Transmit Octet Count for Good and Bad 64 Byte
                                                         Frames                                                                */
  __I  uint32_t  TX_65TO127OCTETS_FRAMES_GOOD_BAD;  /*!< (@ 0x5000C128) Transmit Octet Count for Good and Bad 65 to 127
                                                         Bytes Frames                                                          */
  __I  uint32_t  TX_128TO255OCTETS_FRAMES_GOOD_BAD; /*!< (@ 0x5000C12C) Transmit Octet Count for Good and Bad 128 to
                                                         255 Bytes Frames                                                      */
  __I  uint32_t  TX_256TO511OCTETS_FRAMES_GOOD_BAD; /*!< (@ 0x5000C130) Transmit Octet Count for Good and Bad 256 to
                                                         511 Bytes Frames                                                      */
  __I  uint32_t  TX_512TO1023OCTETS_FRAMES_GOOD_BAD;/*!< (@ 0x5000C134) Transmit Octet Count for Good and Bad 512 to
                                                         1023 Bytes Frames                                                     */
  __I  uint32_t  TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD;/*!< (@ 0x5000C138) Transmit Octet Count for Good and Bad 1024 to
                                                         Maxsize Bytes Frames                                                  */
  __I  uint32_t  TX_UNICAST_FRAMES_GOOD_BAD;        /*!< (@ 0x5000C13C) Transmit Frame Count for Good and Bad Unicast
                                                         Frames                                                                */
  __I  uint32_t  TX_MULTICAST_FRAMES_GOOD_BAD;      /*!< (@ 0x5000C140) Transmit Frame Count for Good and Bad Multicast
                                                         Frames                                                                */
  __I  uint32_t  TX_BROADCAST_FRAMES_GOOD_BAD;      /*!< (@ 0x5000C144) Transmit Frame Count for Good and Bad Broadcast
                                                         Frames                                                                */
  __I  uint32_t  TX_UNDERFLOW_ERROR_FRAMES;         /*!< (@ 0x5000C148) Transmit Frame Count for Underflow Error Frames        */
  __I  uint32_t  TX_SINGLE_COLLISION_GOOD_FRAMES;   /*!< (@ 0x5000C14C) Transmit Frame Count for Frames Transmitted after
                                                         Single Collision                                                      */
  __I  uint32_t  TX_MULTIPLE_COLLISION_GOOD_FRAMES; /*!< (@ 0x5000C150) Transmit Frame Count for Frames Transmitted after
                                                         Multiple Collision                                                    */
  __I  uint32_t  TX_DEFERRED_FRAMES;                /*!< (@ 0x5000C154) Tx Deferred Frames Register                            */
  __I  uint32_t  TX_LATE_COLLISION_FRAMES;          /*!< (@ 0x5000C158) Transmit Frame Count for Late Collision Error
                                                         Frames                                                                */
  __I  uint32_t  TX_EXCESSIVE_COLLISION_FRAMES;     /*!< (@ 0x5000C15C) Transmit Frame Count for Excessive Collision
                                                         Error Frames                                                          */
  __I  uint32_t  TX_CARRIER_ERROR_FRAMES;           /*!< (@ 0x5000C160) Transmit Frame Count for Carrier Sense Error
                                                         Frames                                                                */
  __I  uint32_t  TX_OCTET_COUNT_GOOD;               /*!< (@ 0x5000C164) Tx Octet Count Good Register                           */
  __I  uint32_t  TX_FRAME_COUNT_GOOD;               /*!< (@ 0x5000C168) Tx Frame Count Good Register                           */
  __I  uint32_t  TX_EXCESSIVE_DEFERRAL_ERROR;       /*!< (@ 0x5000C16C) Transmit Frame Count for Excessive Deferral Error
                                                         Frames                                                                */
  __I  uint32_t  TX_PAUSE_FRAMES;                   /*!< (@ 0x5000C170) Transmit Frame Count for Good PAUSE Frames             */
  __I  uint32_t  TX_VLAN_FRAMES_GOOD;               /*!< (@ 0x5000C174) Transmit Frame Count for Good VLAN Frames              */
  __I  uint32_t  TX_OSIZE_FRAMES_GOOD;              /*!< (@ 0x5000C178) Transmit Frame Count for Good Oversize Frames          */
  __I  uint32_t  RESERVED2;
  __I  uint32_t  RX_FRAMES_COUNT_GOOD_BAD;          /*!< (@ 0x5000C180) Receive Frame Count for Good and Bad Frames            */
  __I  uint32_t  RX_OCTET_COUNT_GOOD_BAD;           /*!< (@ 0x5000C184) Receive Octet Count for Good and Bad Frames            */
  __I  uint32_t  RX_OCTET_COUNT_GOOD;               /*!< (@ 0x5000C188) Rx Octet Count Good Register                           */
  __I  uint32_t  RX_BROADCAST_FRAMES_GOOD;          /*!< (@ 0x5000C18C) Receive Frame Count for Good Broadcast Frames          */
  __I  uint32_t  RX_MULTICAST_FRAMES_GOOD;          /*!< (@ 0x5000C190) Receive Frame Count for Good Multicast Frames          */
  __I  uint32_t  RX_CRC_ERROR_FRAMES;               /*!< (@ 0x5000C194) Receive Frame Count for CRC Error Frames               */
  __I  uint32_t  RX_ALIGNMENT_ERROR_FRAMES;         /*!< (@ 0x5000C198) Receive Frame Count for Alignment Error Frames         */
  __I  uint32_t  RX_RUNT_ERROR_FRAMES;              /*!< (@ 0x5000C19C) Receive Frame Count for Runt Error Frames              */
  __I  uint32_t  RX_JABBER_ERROR_FRAMES;            /*!< (@ 0x5000C1A0) Receive Frame Count for Jabber Error Frames            */
  __I  uint32_t  RX_UNDERSIZE_FRAMES_GOOD;          /*!< (@ 0x5000C1A4) Receive Frame Count for Undersize Frames               */
  __I  uint32_t  RX_OVERSIZE_FRAMES_GOOD;           /*!< (@ 0x5000C1A8) Rx Oversize Frames Good Register                       */
  __I  uint32_t  RX_64OCTETS_FRAMES_GOOD_BAD;       /*!< (@ 0x5000C1AC) Receive Frame Count for Good and Bad 64 Byte
                                                         Frames                                                                */
  __I  uint32_t  RX_65TO127OCTETS_FRAMES_GOOD_BAD;  /*!< (@ 0x5000C1B0) Receive Frame Count for Good and Bad 65 to 127
                                                         Bytes Frames                                                          */
  __I  uint32_t  RX_128TO255OCTETS_FRAMES_GOOD_BAD; /*!< (@ 0x5000C1B4) Receive Frame Count for Good and Bad 128 to 255
                                                         Bytes Frames                                                          */
  __I  uint32_t  RX_256TO511OCTETS_FRAMES_GOOD_BAD; /*!< (@ 0x5000C1B8) Receive Frame Count for Good and Bad 256 to 511
                                                         Bytes Frames                                                          */
  __I  uint32_t  RX_512TO1023OCTETS_FRAMES_GOOD_BAD;/*!< (@ 0x5000C1BC) Receive Frame Count for Good and Bad 512 to 1,023
                                                         Bytes Frames                                                          */
  __I  uint32_t  RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD;/*!< (@ 0x5000C1C0) Receive Frame Count for Good and Bad 1,024 to
                                                         Maxsize Bytes Frames                                                  */
  __I  uint32_t  RX_UNICAST_FRAMES_GOOD;            /*!< (@ 0x5000C1C4) Receive Frame Count for Good Unicast Frames            */
  __I  uint32_t  RX_LENGTH_ERROR_FRAMES;            /*!< (@ 0x5000C1C8) Receive Frame Count for Length Error Frames            */
  __I  uint32_t  RX_OUT_OF_RANGE_TYPE_FRAMES;       /*!< (@ 0x5000C1CC) Receive Frame Count for Out of Range Frames            */
  __I  uint32_t  RX_PAUSE_FRAMES;                   /*!< (@ 0x5000C1D0) Receive Frame Count for PAUSE Frames                   */
  __I  uint32_t  RX_FIFO_OVERFLOW_FRAMES;           /*!< (@ 0x5000C1D4) Receive Frame Count for FIFO Overflow Frames           */
  __I  uint32_t  RX_VLAN_FRAMES_GOOD_BAD;           /*!< (@ 0x5000C1D8) Receive Frame Count for Good and Bad VLAN Frames       */
  __I  uint32_t  RX_WATCHDOG_ERROR_FRAMES;          /*!< (@ 0x5000C1DC) Receive Frame Count for Watchdog Error Frames          */
  __I  uint32_t  RX_RECEIVE_ERROR_FRAMES;           /*!< (@ 0x5000C1E0) Receive Frame Count for Receive Error Frames           */
  __I  uint32_t  RX_CONTROL_FRAMES_GOOD;            /*!< (@ 0x5000C1E4) Receive Frame Count for Good Control Frames Frames     */
  __I  uint32_t  RESERVED3[6];
  __IO uint32_t  MMC_IPC_RECEIVE_INTERRUPT_MASK;    /*!< (@ 0x5000C200) MMC Receive Checksum Offload Interrupt Mask Register   */
  __I  uint32_t  RESERVED4;
  __I  uint32_t  MMC_IPC_RECEIVE_INTERRUPT;         /*!< (@ 0x5000C208) MMC Receive Checksum Offload Interrupt Register        */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  RXIPV4_GOOD_FRAMES;                /*!< (@ 0x5000C210) RxIPv4 Good Frames Register                            */
  __I  uint32_t  RXIPV4_HEADER_ERROR_FRAMES;        /*!< (@ 0x5000C214) Receive IPV4 Header Error Frame Counter Register       */
  __I  uint32_t  RXIPV4_NO_PAYLOAD_FRAMES;          /*!< (@ 0x5000C218) Receive IPV4 No Payload Frame Counter Register         */
  __I  uint32_t  RXIPV4_FRAGMENTED_FRAMES;          /*!< (@ 0x5000C21C) Receive IPV4 Fragmented Frame Counter Register         */
  __I  uint32_t  RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES;/*!< (@ 0x5000C220) Receive IPV4 UDP Checksum Disabled Frame Counter
                                                         Register                                                              */
  __I  uint32_t  RXIPV6_GOOD_FRAMES;                /*!< (@ 0x5000C224) RxIPv6 Good Frames Register                            */
  __I  uint32_t  RXIPV6_HEADER_ERROR_FRAMES;        /*!< (@ 0x5000C228) Receive IPV6 Header Error Frame Counter Register       */
  __I  uint32_t  RXIPV6_NO_PAYLOAD_FRAMES;          /*!< (@ 0x5000C22C) Receive IPV6 No Payload Frame Counter Register         */
  __I  uint32_t  RXUDP_GOOD_FRAMES;                 /*!< (@ 0x5000C230) RxUDP Good Frames Register                             */
  __I  uint32_t  RXUDP_ERROR_FRAMES;                /*!< (@ 0x5000C234) RxUDP Error Frames Register                            */
  __I  uint32_t  RXTCP_GOOD_FRAMES;                 /*!< (@ 0x5000C238) RxTCP Good Frames Register                             */
  __I  uint32_t  RXTCP_ERROR_FRAMES;                /*!< (@ 0x5000C23C) RxTCP Error Frames Register                            */
  __I  uint32_t  RXICMP_GOOD_FRAMES;                /*!< (@ 0x5000C240) RxICMP Good Frames Register                            */
  __I  uint32_t  RXICMP_ERROR_FRAMES;               /*!< (@ 0x5000C244) RxICMP Error Frames Register                           */
  __I  uint32_t  RESERVED6[2];
  __I  uint32_t  RXIPV4_GOOD_OCTETS;                /*!< (@ 0x5000C250) RxIPv4 Good Octets Register                            */
  __I  uint32_t  RXIPV4_HEADER_ERROR_OCTETS;        /*!< (@ 0x5000C254) Receive IPV4 Header Error Octet Counter Register       */
  __I  uint32_t  RXIPV4_NO_PAYLOAD_OCTETS;          /*!< (@ 0x5000C258) Receive IPV4 No Payload Octet Counter Register         */
  __I  uint32_t  RXIPV4_FRAGMENTED_OCTETS;          /*!< (@ 0x5000C25C) Receive IPV4 Fragmented Octet Counter Register         */
  __I  uint32_t  RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS;/*!< (@ 0x5000C260) Receive IPV4 Fragmented Octet Counter Register         */
  __I  uint32_t  RXIPV6_GOOD_OCTETS;                /*!< (@ 0x5000C264) RxIPv6 Good Octets Register                            */
  __I  uint32_t  RXIPV6_HEADER_ERROR_OCTETS;        /*!< (@ 0x5000C268) Receive IPV6 Header Error Octet Counter Register       */
  __I  uint32_t  RXIPV6_NO_PAYLOAD_OCTETS;          /*!< (@ 0x5000C26C) Receive IPV6 No Payload Octet Counter Register         */
  __I  uint32_t  RXUDP_GOOD_OCTETS;                 /*!< (@ 0x5000C270) Receive UDP Good Octets Register                       */
  __I  uint32_t  RXUDP_ERROR_OCTETS;                /*!< (@ 0x5000C274) Receive UDP Error Octets Register                      */
  __I  uint32_t  RXTCP_GOOD_OCTETS;                 /*!< (@ 0x5000C278) Receive TCP Good Octets Register                       */
  __I  uint32_t  RXTCP_ERROR_OCTETS;                /*!< (@ 0x5000C27C) Receive TCP Error Octets Register                      */
  __I  uint32_t  RXICMP_GOOD_OCTETS;                /*!< (@ 0x5000C280) Receive ICMP Good Octets Register                      */
  __I  uint32_t  RXICMP_ERROR_OCTETS;               /*!< (@ 0x5000C284) Receive ICMP Error Octets Register                     */
  __I  uint32_t  RESERVED7[286];
  __IO uint32_t  TIMESTAMP_CONTROL;                 /*!< (@ 0x5000C700) Timestamp Control Register                             */
  __IO uint32_t  SUB_SECOND_INCREMENT;              /*!< (@ 0x5000C704) Sub-Second Increment Register                          */
  __I  uint32_t  SYSTEM_TIME_SECONDS;               /*!< (@ 0x5000C708) System Time - Seconds Register                         */
  __I  uint32_t  SYSTEM_TIME_NANOSECONDS;           /*!< (@ 0x5000C70C) System Time Nanoseconds Register                       */
  __IO uint32_t  SYSTEM_TIME_SECONDS_UPDATE;        /*!< (@ 0x5000C710) System Time - Seconds Update Register                  */
  __IO uint32_t  SYSTEM_TIME_NANOSECONDS_UPDATE;    /*!< (@ 0x5000C714) System Time Nanoseconds Update Register                */
  __IO uint32_t  TIMESTAMP_ADDEND;                  /*!< (@ 0x5000C718) Timestamp Addend Register                              */
  __IO uint32_t  TARGET_TIME_SECONDS;               /*!< (@ 0x5000C71C) Target Time Seconds Register                           */
  __IO uint32_t  TARGET_TIME_NANOSECONDS;           /*!< (@ 0x5000C720) Target Time Nanoseconds Register                       */
  __IO uint32_t  SYSTEM_TIME_HIGHER_WORD_SECONDS;   /*!< (@ 0x5000C724) System Time - Higher Word Seconds Register             */
  __I  uint32_t  TIMESTAMP_STATUS;                  /*!< (@ 0x5000C728) Timestamp Status Register                              */
  __I  uint32_t  RESERVED8[565];
  __IO uint32_t  BUS_MODE;                          /*!< (@ 0x5000D000) Bus Mode Register                                      */
  __IO uint32_t  TRANSMIT_POLL_DEMAND;              /*!< (@ 0x5000D004) Transmit Poll Demand Register                          */
  __IO uint32_t  RECEIVE_POLL_DEMAND;               /*!< (@ 0x5000D008) Receive Poll Demand Register                           */
  __IO uint32_t  RECEIVE_DESCRIPTOR_LIST_ADDRESS;   /*!< (@ 0x5000D00C) Receive Descriptor Address Register                    */
  __IO uint32_t  TRANSMIT_DESCRIPTOR_LIST_ADDRESS;  /*!< (@ 0x5000D010) Transmit descripter Address Register                   */
  __IO uint32_t  STATUS;                            /*!< (@ 0x5000D014) Status Register                                        */
  __IO uint32_t  OPERATION_MODE;                    /*!< (@ 0x5000D018) Operation Mode Register                                */
  __IO uint32_t  INTERRUPT_ENABLE;                  /*!< (@ 0x5000D01C) Interrupt Enable Register                              */
  __I  uint32_t  MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER;/*!< (@ 0x5000D020) Missed Frame and Buffer Overflow Counter Register */
  __IO uint32_t  RECEIVE_INTERRUPT_WATCHDOG_TIMER;  /*!< (@ 0x5000D024) Receive Interrupt Watchdog Timer Register              */
  __I  uint32_t  RESERVED9;
  __I  uint32_t  AHB_STATUS;                        /*!< (@ 0x5000D02C) AHB Status Register                                    */
  __I  uint32_t  RESERVED10[6];
  __I  uint32_t  CURRENT_HOST_TRANSMIT_DESCRIPTOR;  /*!< (@ 0x5000D048) Current Host Transmit Descriptor Register              */
  __I  uint32_t  CURRENT_HOST_RECEIVE_DESCRIPTOR;   /*!< (@ 0x5000D04C) Current Host Receive Descriptor Register               */
  __I  uint32_t  CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS;/*!< (@ 0x5000D050) Current Host Transmit Buffer Address Register        */
  __I  uint32_t  CURRENT_HOST_RECEIVE_BUFFER_ADDRESS;/*!< (@ 0x5000D054) Current Host Receive Buffer Address Register          */
  __IO uint32_t  HW_FEATURE;                        /*!< (@ 0x5000D058) HW Feature Register                                    */
} ETH_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                    ECAT0_CON                   ================ */
/* ================================================================================ */


/**
  * @brief EtherCAT 0 Control Register (ECAT0_CON)
  */

typedef struct {                                    /*!< (@ 0x500041B0) ECAT0_CON Structure                                    */
  __IO uint32_t  CON;                               /*!< (@ 0x500041B0) EtherCAT 0 Control                                     */
  __IO uint32_t  CONP0;                             /*!< (@ 0x500041B4) EtherCAT 0 Port 1 Control Register                     */
  __IO uint32_t  CONP1;                             /*!< (@ 0x500041B8) EtherCAT 0 Port 1 Control Register                     */
} ECAT0_CON_Type;


/* ================================================================================ */
/* ================                  ECAT [ECAT0]                  ================ */
/* ================================================================================ */


/**
  * @brief EtherCAT 0 (ECAT)
  */

typedef struct {                                    /*!< (@ 0x54010000) ECAT Structure                                         */
  __I  uint8_t   TYPE;                              /*!< (@ 0x54010000) Type of EtherCAT Controller                            */
  __I  uint8_t   REVISION;                          /*!< (@ 0x54010001) Revision of EtherCAT Controller                        */
  __I  uint16_t  BUILD;                             /*!< (@ 0x54010002) Build Version                                          */
  __I  uint8_t   FMMU_NUM;                          /*!< (@ 0x54010004) FMMUs Supported                                        */
  __I  uint8_t   SYNC_MANAGER;                      /*!< (@ 0x54010005) SyncManagers Supported                                 */
  __I  uint8_t   RAM_SIZE;                          /*!< (@ 0x54010006) RAM Size                                               */
  __I  uint8_t   PORT_DESC;                         /*!< (@ 0x54010007) Port Descriptor                                        */
  __I  uint16_t  FEATURE;                           /*!< (@ 0x54010008) ESC Features Supported                                 */
  __I  uint16_t  RESERVED[3];
  __I  uint16_t  STATION_ADR;                       /*!< (@ 0x54010010) Configured Station Address                             */
  __IO uint16_t  STATION_ALIAS;                     /*!< (@ 0x54010012) Configured Station Alias                               */
  __I  uint32_t  RESERVED1[3];
  __I  uint8_t   WR_REG_ENABLE;                     /*!< (@ 0x54010020) Write Register Enable                                  */
  __I  uint8_t   WR_REG_PROTECT;                    /*!< (@ 0x54010021) Write Register Protection                              */
  __I  uint16_t  RESERVED2[7];
  __I  uint8_t   ESC_WR_ENABLE;                     /*!< (@ 0x54010030) ESC Write Enable                                       */
  __I  uint8_t   ESC_WR_PROTECT;                    /*!< (@ 0x54010031) ESC Write Protection                                   */
  __I  uint16_t  RESERVED3[7];
  
  union {
    __I  uint8_t   ESC_RESET_ECAT_READMode;         /*!< (@ 0x54010040) ESC Reset ECAT [READ Mode]                             */
    __I  uint8_t   ESC_RESET_ECAT_WRITEMode;        /*!< (@ 0x54010040) ESC Reset ECAT [WRITE Mode]                            */
  };
  
  union {
    __I  uint8_t   ESC_RESET_PDI_READMode;          /*!< (@ 0x54010041) ESC Reset PDI [READ Mode]                              */
    __I  uint8_t   ESC_RESET_PDI_WRITEMode;         /*!< (@ 0x54010041) ESC Reset PDI [WRITE Mode]                             */
  };
  __I  uint16_t  RESERVED4[95];
  __I  uint32_t  ESC_DL_CONTROL;                    /*!< (@ 0x54010100) ESC DL Control                                         */
  __I  uint32_t  RESERVED5;
  __I  uint16_t  PHYSICAL_RW_OFFSET;                /*!< (@ 0x54010108) Physical Read/Write Offset                             */
  __I  uint16_t  RESERVED6[3];
  __I  uint16_t  ESC_DL_STATUS;                     /*!< (@ 0x54010110) ESC DL Status                                          */
  __I  uint16_t  RESERVED7[7];
  __I  uint16_t  AL_CONTROL;                        /*!< (@ 0x54010120) AL Control                                             */
  __I  uint16_t  RESERVED8[7];
  __IO uint16_t  AL_STATUS;                         /*!< (@ 0x54010130) AL Status                                              */
  __I  uint16_t  RESERVED9;
  __IO uint16_t  AL_STATUS_CODE;                    /*!< (@ 0x54010134) AL Status Code                                         */
  __I  uint16_t  RESERVED10;
  __IO uint8_t   RUN_LED;                           /*!< (@ 0x54010138) RUN LED Override                                       */
  __IO uint8_t   ERR_LED;                           /*!< (@ 0x54010139) RUN ERR Override                                       */
  __I  uint16_t  RESERVED11[3];
  __I  uint8_t   PDI_CONTROL;                       /*!< (@ 0x54010140) PDI Control                                            */
  __I  uint8_t   ESC_CONFIG;                        /*!< (@ 0x54010141) ESC Configuration                                      */
  __I  uint16_t  RESERVED12[7];
  __I  uint8_t   PDI_CONFIG;                        /*!< (@ 0x54010150) PDI Control                                            */
  __I  uint8_t   SYNC_LATCH_CONFIG;                 /*!< (@ 0x54010151) Sync/Latch[1:0] PDI Configuration                      */
  __I  uint16_t  PDI_EXT_CONFIG;                    /*!< (@ 0x54010152) PDI Synchronous Microcontroller extended Configuration */
  __I  uint32_t  RESERVED13[43];
  __I  uint16_t  EVENT_MASK;                        /*!< (@ 0x54010200) ECAT Event Mask                                        */
  __I  uint16_t  RESERVED14;
  __IO uint32_t  AL_EVENT_MASK;                     /*!< (@ 0x54010204) PDI AL Event Mask                                      */
  __I  uint32_t  RESERVED15[2];
  __I  uint16_t  EVENT_REQ;                         /*!< (@ 0x54010210) ECAT Event Request                                     */
  __I  uint16_t  RESERVED16[7];
  __IO uint32_t  AL_EVENT_REQ;                      /*!< (@ 0x54010220) AL Event Request                                       */
  __I  uint32_t  RESERVED17[55];
  __I  uint16_t  RX_ERR_COUNT0;                     /*!< (@ 0x54010300) RX Error Counter Port 0                                */
  __I  uint16_t  RX_ERR_COUNT1;                     /*!< (@ 0x54010302) RX Error Counter Port 1                                */
  __I  uint32_t  RESERVED18;
  __I  uint8_t   FWD_RX_ERR_COUNT0;                 /*!< (@ 0x54010308) Forwarded RX Error Counter Port 0                      */
  __I  uint8_t   FWD_RX_ERR_COUNT1;                 /*!< (@ 0x54010309) Forwarded RX Error Counter Port 1                      */
  __I  uint16_t  RESERVED19;
  __I  uint8_t   PROC_ERR_COUNT;                    /*!< (@ 0x5401030C) ECAT Processing Unit Error Counter                     */
  __I  uint8_t   PDI_ERR_COUNT;                     /*!< (@ 0x5401030D) PDI Error Counter                                      */
  __I  uint16_t  RESERVED20;
  __I  uint8_t   LOST_LINK_COUNT0;                  /*!< (@ 0x54010310) Lost Link Counter Port 0                               */
  __I  uint8_t   LOST_LINK_COUNT1;                  /*!< (@ 0x54010311) Lost Link Counter Port 1                               */
  __I  uint16_t  RESERVED21[119];
  __IO uint16_t  WD_DIVIDE;                         /*!< (@ 0x54010400) Watchdog Divider                                       */
  __I  uint16_t  RESERVED22[7];
  __IO uint16_t  WD_TIME_PDI;                       /*!< (@ 0x54010410) Watchdog Time PDI                                      */
  __I  uint16_t  RESERVED23[7];
  __IO uint16_t  WD_TIME_PDATA;                     /*!< (@ 0x54010420) Watchdog Time Process Data                             */
  __I  uint16_t  RESERVED24[15];
  __I  uint16_t  WD_STAT_PDATA;                     /*!< (@ 0x54010440) Watchdog Status Process Data                           */
  __I  uint8_t   WD_COUNT_PDATA;                    /*!< (@ 0x54010442) Watchdog Counter Process Data                          */
  __I  uint8_t   WD_COUNT_PDI;                      /*!< (@ 0x54010443) Watchdog Counter PDI                                   */
  __I  uint32_t  RESERVED25[47];
  __I  uint8_t   EEP_CONF;                          /*!< (@ 0x54010500) EEPROM Configuration                                   */
  __IO uint8_t   EEP_STATE;                         /*!< (@ 0x54010501) EEPROM PDI Access State                                */
  __IO uint16_t  EEP_CONT_STAT;                     /*!< (@ 0x54010502) EEPROM Control/Status                                  */
  __IO uint32_t  EEP_ADR;                           /*!< (@ 0x54010504) EEPROM Address                                         */
  __IO uint32_t  EEP_DATA[2];                       /*!< (@ 0x54010508) EEPROM Read/Write data                                 */
  __IO uint16_t  MII_CONT_STAT;                     /*!< (@ 0x54010510) MII Management Control/Status                          */
  __IO uint8_t   MII_PHY_ADR;                       /*!< (@ 0x54010512) PHY Address                                            */
  __IO uint8_t   MII_PHY_REG_ADR;                   /*!< (@ 0x54010513) PHY Register Address                                   */
  __IO uint16_t  MII_PHY_DATA;                      /*!< (@ 0x54010514) PHY Data                                               */
  __I  uint8_t   MII_ECAT_ACS_STATE;                /*!< (@ 0x54010516) MII ECAT ACS STATE                                     */
  __IO uint8_t   MII_PDI_ACS_STATE;                 /*!< (@ 0x54010517) MII PDI ACS STATE                                      */
  __I  uint32_t  RESERVED26[250];
  __I  uint32_t  DC_RCV_TIME_PORT0;                 /*!< (@ 0x54010900) Receive Time Port 0                                    */
  __I  uint32_t  DC_RCV_TIME_PORT1;                 /*!< (@ 0x54010904) Receive Time Port 1                                    */
  __I  uint32_t  RESERVED27[2];
  
  union {
    __I  uint32_t  READMode_DC_SYS_TIME[2];         /*!< (@ 0x54010910) System Time read access                                */
    __O  uint32_t  DC_SYS_TIME_WRITEMode;           /*!< (@ 0x54010910) System Time [WRITE Mode]                               */
  };
  __I  uint32_t  RECEIVE_TIME_PU[2];                /*!< (@ 0x54010918) Local time of the beginning of a frame                 */
  __IO uint32_t  DC_SYS_TIME_OFFSET[2];             /*!< (@ 0x54010920) Difference between local time and System Time          */
  __IO uint32_t  DC_SYS_TIME_DELAY;                 /*!< (@ 0x54010928) System Time Delay                                      */
  __I  uint32_t  DC_SYS_TIME_DIFF;                  /*!< (@ 0x5401092C) System Time Difference                                 */
  __IO uint16_t  DC_SPEED_COUNT_START;              /*!< (@ 0x54010930) Speed Counter Start                                    */
  __I  uint16_t  DC_SPEED_COUNT_DIFF;               /*!< (@ 0x54010932) Speed Counter Diff                                     */
  __IO uint8_t   DC_SYS_TIME_FIL_DEPTH;             /*!< (@ 0x54010934) System Time Difference Filter Depth                    */
  __IO uint8_t   DC_SPEED_COUNT_FIL_DEPTH;          /*!< (@ 0x54010935) Speed Counter Filter Depth                             */
  __I  uint16_t  RESERVED28[37];
  __I  uint8_t   DC_CYC_CONT;                       /*!< (@ 0x54010980) Cyclic Unit Control                                    */
  __IO uint8_t   DC_ACT;                            /*!< (@ 0x54010981) Activation register                                    */
  __I  uint16_t  DC_PULSE_LEN;                      /*!< (@ 0x54010982) Pulse Length of SyncSignals                            */
  __I  uint8_t   DC_ACT_STAT;                       /*!< (@ 0x54010984) Activation Status                                      */
  __I  uint8_t   RESERVED29[9];
  __I  uint8_t   DC_SYNC0_STAT;                     /*!< (@ 0x5401098E) SYNC0 Status                                           */
  __I  uint8_t   DC_SYNC1_STAT;                     /*!< (@ 0x5401098F) SYNC1 Status                                           */
  __IO uint32_t  DC_CYC_START_TIME[2];              /*!< (@ 0x54010990) Start Time Cyclic Operation                            */
  __I  uint32_t  DC_NEXT_SYNC1_PULSE[2];            /*!< (@ 0x54010998) System time of next SYNC1 pulse in ns                  */
  __IO uint32_t  DC_SYNC0_CYC_TIME;                 /*!< (@ 0x540109A0) SYNC0 Cycle Time                                       */
  __IO uint32_t  DC_SYNC1_CYC_TIME;                 /*!< (@ 0x540109A4) SYNC1 Cycle Time                                       */
  __IO uint8_t   DC_LATCH0_CONT;                    /*!< (@ 0x540109A8) Latch0 Control                                         */
  __IO uint8_t   DC_LATCH1_CONT;                    /*!< (@ 0x540109A9) Latch1 Control                                         */
  __I  uint32_t  RESERVED30;
  __I  uint8_t   DC_LATCH0_STAT;                    /*!< (@ 0x540109AE) Latch0 Status                                          */
  __I  uint8_t   DC_LATCH1_STAT;                    /*!< (@ 0x540109AF) Latch1 Status                                          */
  __I  uint32_t  DC_LATCH0_TIME_POS[2];             /*!< (@ 0x540109B0) Register captures System time at the positive
                                                         edge of the Latch0 signal                                             */
  __I  uint32_t  DC_LATCH0_TIME_NEG[2];             /*!< (@ 0x540109B8) Register captures System time at the negative
                                                         edge of the Latch0 signal                                             */
  __I  uint32_t  DC_LATCH1_TIME_POS[2];             /*!< (@ 0x540109C0) Register captures System time at the positive
                                                         edge of the Latch1 signal                                             */
  __I  uint32_t  DC_LATCH1_TIME_NEG[2];             /*!< (@ 0x540109C8) Register captures System time at the negative
                                                         edge of the Latch1 signal                                             */
  __I  uint32_t  RESERVED31[8];
  __I  uint32_t  DC_ECAT_CNG_EV_TIME;               /*!< (@ 0x540109F0) EtherCAT Buffer Change Event Time                      */
  __I  uint32_t  RESERVED32;
  __I  uint32_t  DC_PDI_START_EV_TIME;              /*!< (@ 0x540109F8) PDI Buffer Start Event Time                            */
  __I  uint32_t  DC_PDI_CNG_EV_TIME;                /*!< (@ 0x540109FC) PDI Buffer Change Event Time                           */
  __I  uint32_t  RESERVED33[256];
  __I  uint32_t  ID;                                /*!< (@ 0x54010E00) ECAT0 Module ID                                        */
  __I  uint32_t  RESERVED34;
  __I  uint32_t  STATUS;                            /*!< (@ 0x54010E08) ECAT0 Status                                           */
} ECAT_Type;


/* ================================================================================ */
/* ================            ECAT0_FMMU [ECAT0_FMMU0]            ================ */
/* ================================================================================ */


/**
  * @brief EtherCAT 0 (ECAT0_FMMU)
  */

typedef struct {                                    /*!< (@ 0x54010600) ECAT0_FMMU Structure                                   */
  __I  uint32_t  FMMU_L_START_ADR;                  /*!< (@ 0x54010600) Logical Start address FMMU                             */
  __I  uint16_t  FMMU_LEN;                          /*!< (@ 0x54010604) Length FMMU 0                                          */
  __I  uint8_t   FMMU_L_START_BIT;                  /*!< (@ 0x54010606) Start bit FMMU 0 in logical address space              */
  __I  uint8_t   FMMU_L_STOP_BIT;                   /*!< (@ 0x54010607) Stop bit FMMU 0 in logical address space               */
  __I  uint16_t  FMMU_P_START_ADR;                  /*!< (@ 0x54010608) Ph0sical Start address FMMU y                          */
  __I  uint8_t   FMMU_P_START_BIT;                  /*!< (@ 0x5401060A) Ph0sical Start bit FMMU y                              */
  __I  uint8_t   FMMU_TYPE;                         /*!< (@ 0x5401060B) T0pe FMMU y                                            */
  __I  uint8_t   FMMU_ACT;                          /*!< (@ 0x5401060C) Activate FMMU 0                                        */
} ECAT0_FMMU_Type;


/* ================================================================================ */
/* ================              ECAT0_SM [ECAT0_SM0]              ================ */
/* ================================================================================ */


/**
  * @brief EtherCAT 0 (ECAT0_SM)
  */

typedef struct {                                    /*!< (@ 0x54010800) ECAT0_SM Structure                                     */
  __I  uint16_t  SM_P_START_ADR;                    /*!< (@ 0x54010800) Physical Start Address SyncManager 0                   */
  __I  uint16_t  SM_LEN;                            /*!< (@ 0x54010802) Length SyncManager 0                                   */
  __I  uint8_t   SM_CONTROL;                        /*!< (@ 0x54010804) Control Register SyncManager 0                         */
  __I  uint8_t   SM_STATUS;                         /*!< (@ 0x54010805) Status Register SyncManager 0                          */
  __I  uint8_t   SM_ACT;                            /*!< (@ 0x54010806) Activate SyncManager 0                                 */
  __IO uint8_t   SM_PDI_CTR;                        /*!< (@ 0x54010807) PDI Control SyncManager 0                              */
} ECAT0_SM_Type;


/* ================================================================================ */
/* ================                   USB [USB0]                   ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB)
  */

typedef struct {                                    /*!< (@ 0x50040000) USB Structure                                          */
  __IO uint32_t  GOTGCTL;                           /*!< (@ 0x50040000) Control and Status Register                            */
  __IO uint32_t  GOTGINT;                           /*!< (@ 0x50040004) OTG Interrupt Register                                 */
  __IO uint32_t  GAHBCFG;                           /*!< (@ 0x50040008) AHB Configuration Register                             */
  __IO uint32_t  GUSBCFG;                           /*!< (@ 0x5004000C) USB Configuration Register                             */
  __IO uint32_t  GRSTCTL;                           /*!< (@ 0x50040010) Reset Register                                         */
  
  union {
    __IO uint32_t  GINTSTS_DEVICEMODE;              /*!< (@ 0x50040014) Interrupt Register [DEVICEMODE]                        */
    __IO uint32_t  GINTSTS_HOSTMODE;                /*!< (@ 0x50040014) Interrupt Register [HOSTMODE]                          */
  };
  
  union {
    __IO uint32_t  GINTMSK_DEVICEMODE;              /*!< (@ 0x50040018) Interrupt Mask Register [DEVICEMODE]                   */
    __IO uint32_t  GINTMSK_HOSTMODE;                /*!< (@ 0x50040018) Interrupt Mask Register [HOSTMODE]                     */
  };
  
  union {
    __I  uint32_t  GRXSTSR_DEVICEMODE;              /*!< (@ 0x5004001C) Receive Status Debug Read Register [DEVICEMODE]        */
    __I  uint32_t  GRXSTSR_HOSTMODE;                /*!< (@ 0x5004001C) Receive Status Debug Read Register [HOSTMODE]          */
  };
  
  union {
    __I  uint32_t  GRXSTSP_HOSTMODE;                /*!< (@ 0x50040020) Receive Status Read and Pop Register [HOSTMODE]        */
    __I  uint32_t  GRXSTSP_DEVICEMODE;              /*!< (@ 0x50040020) Receive Status Read and Pop Register [DEVICEMODE]      */
  };
  __IO uint32_t  GRXFSIZ;                           /*!< (@ 0x50040024) Receive FIFO Size Register                             */
  
  union {
    __IO uint32_t  GNPTXFSIZ_DEVICEMODE;            /*!< (@ 0x50040028) Non-Periodic Transmit FIFO Size Register [DEVICEMODE]  */
    __IO uint32_t  GNPTXFSIZ_HOSTMODE;              /*!< (@ 0x50040028) Non-Periodic Transmit FIFO Size Register [HOSTMODE]    */
  };
  __I  uint32_t  GNPTXSTS;                          /*!< (@ 0x5004002C) Non-Periodic Transmit FIFO/Queue Status Register       */
  __I  uint32_t  RESERVED[3];
  __IO uint32_t  GUID;                              /*!< (@ 0x5004003C) USB Module Identification Register                     */
  __I  uint32_t  RESERVED1[7];
  __IO uint32_t  GDFIFOCFG;                         /*!< (@ 0x5004005C) Global DFIFO Software Config Register                  */
  __I  uint32_t  RESERVED2[40];
  __IO uint32_t  HPTXFSIZ;                          /*!< (@ 0x50040100) Host Periodic Transmit FIFO Size Register              */
  __IO uint32_t  DIEPTXF1;                          /*!< (@ 0x50040104) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF2;                          /*!< (@ 0x50040108) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF3;                          /*!< (@ 0x5004010C) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF4;                          /*!< (@ 0x50040110) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF5;                          /*!< (@ 0x50040114) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF6;                          /*!< (@ 0x50040118) Device IN Endpoint Transmit FIFO Size Register         */
  __I  uint32_t  RESERVED3[185];
  __IO uint32_t  HCFG;                              /*!< (@ 0x50040400) Host Configuration Register                            */
  __IO uint32_t  HFIR;                              /*!< (@ 0x50040404) Host Frame Interval Register                           */
  __IO uint32_t  HFNUM;                             /*!< (@ 0x50040408) Host Frame Number/Frame Time Remaining Register        */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  HPTXSTS;                           /*!< (@ 0x50040410) Host Periodic Transmit FIFO/ Queue Status Register     */
  __I  uint32_t  HAINT;                             /*!< (@ 0x50040414) Host All Channels Interrupt Register                   */
  __IO uint32_t  HAINTMSK;                          /*!< (@ 0x50040418) Host All Channels Interrupt Mask Register              */
  __IO uint32_t  HFLBADDR;                          /*!< (@ 0x5004041C) Host Frame List Base Address Register                  */
  __I  uint32_t  RESERVED5[8];
  __IO uint32_t  HPRT;                              /*!< (@ 0x50040440) Host Port Control and Status Register                  */
  __I  uint32_t  RESERVED6[239];
  __IO uint32_t  DCFG;                              /*!< (@ 0x50040800) Device Configuration Register                          */
  __IO uint32_t  DCTL;                              /*!< (@ 0x50040804) Device Control Register                                */
  __I  uint32_t  DSTS;                              /*!< (@ 0x50040808) Device Status Register                                 */
  __I  uint32_t  RESERVED7;
  __IO uint32_t  DIEPMSK;                           /*!< (@ 0x50040810) Device IN Endpoint Common Interrupt Mask Register      */
  __IO uint32_t  DOEPMSK;                           /*!< (@ 0x50040814) Device OUT Endpoint Common Interrupt Mask Register     */
  __I  uint32_t  DAINT;                             /*!< (@ 0x50040818) Device All Endpoints Interrupt Register                */
  __IO uint32_t  DAINTMSK;                          /*!< (@ 0x5004081C) Device All Endpoints Interrupt Mask Register           */
  __I  uint32_t  RESERVED8[2];
  __IO uint32_t  DVBUSDIS;                          /*!< (@ 0x50040828) Device VBUS Discharge Time Register                    */
  __IO uint32_t  DVBUSPULSE;                        /*!< (@ 0x5004082C) Device VBUS Pulsing Time Register                      */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  DIEPEMPMSK;                        /*!< (@ 0x50040834) Device IN Endpoint FIFO Empty Interrupt Mask
                                                         Register                                                              */
  __I  uint32_t  RESERVED10[370];
  __IO uint32_t  PCGCCTL;                           /*!< (@ 0x50040E00) Power and Clock Gating Control Register                */
} USB0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                    USB0_EP0                    ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB0_EP0)
  */

typedef struct {                                    /*!< (@ 0x50040900) USB0_EP0 Structure                                     */
  __IO uint32_t  DIEPCTL0;                          /*!< (@ 0x50040900) Device Control IN Endpoint Control Register            */
  __I  uint32_t  RESERVED;
  __IO uint32_t  DIEPINT0;                          /*!< (@ 0x50040908) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  DIEPTSIZ0;                         /*!< (@ 0x50040910) Device IN Endpoint Transfer Size Register              */
  __IO uint32_t  DIEPDMA0;                          /*!< (@ 0x50040914) Device Endpoint DMA Address Register                   */
  __I  uint32_t  DTXFSTS0;                          /*!< (@ 0x50040918) Device IN Endpoint Transmit FIFO Status Register       */
  __I  uint32_t  DIEPDMAB0;                         /*!< (@ 0x5004091C) Device Endpoint DMA Buffer Address Register            */
  __I  uint32_t  RESERVED2[120];
  __IO uint32_t  DOEPCTL0;                          /*!< (@ 0x50040B00) Device Control OUT Endpoint Control Register           */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  DOEPINT0;                          /*!< (@ 0x50040B08) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  DOEPTSIZ0;                         /*!< (@ 0x50040B10) Device OUT Endpoint Transfer Size Register             */
  __IO uint32_t  DOEPDMA0;                          /*!< (@ 0x50040B14) Device Endpoint DMA Address Register                   */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  DOEPDMAB0;                         /*!< (@ 0x50040B1C) Device Endpoint DMA Buffer Address Register            */
} USB0_EP0_TypeDef;


/* ================================================================================ */
/* ================                USB_EP [USB0_EP1]               ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB_EP)
  */

typedef struct {                                    /*!< (@ 0x50040920) USB_EP Structure                                       */
  
  union {
    __IO uint32_t  DIEPCTL_INTBULK;                 /*!< (@ 0x50040920) Device Endpoint Control Register [INTBULK]             */
    __IO uint32_t  DIEPCTL_ISOCONT;                 /*!< (@ 0x50040920) Device Endpoint Control Register [ISOCONT]             */
  };
  __I  uint32_t  RESERVED;
  __IO uint32_t  DIEPINT;                           /*!< (@ 0x50040928) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  DIEPTSIZ;                          /*!< (@ 0x50040930) Device Endpoint Transfer Size Register                 */
  __IO uint32_t  DIEPDMA;                           /*!< (@ 0x50040934) Device Endpoint DMA Address Register                   */
  __I  uint32_t  DTXFSTS;                           /*!< (@ 0x50040938) Device IN Endpoint Transmit FIFO Status Register       */
  __I  uint32_t  DIEPDMAB;                          /*!< (@ 0x5004093C) Device Endpoint DMA Buffer Address Register            */
  __I  uint32_t  RESERVED2[120];
  
  union {
    __IO uint32_t  DOEPCTL_INTBULK;                 /*!< (@ 0x50040B20) Device Endpoint Control Register [INTBULK]             */
    __IO uint32_t  DOEPCTL_ISOCONT;                 /*!< (@ 0x50040B20) Device Endpoint Control Register [ISOCONT]             */
  };
  __I  uint32_t  RESERVED3;
  __IO uint32_t  DOEPINT;                           /*!< (@ 0x50040B28) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED4;
  
  union {
    __IO uint32_t  DOEPTSIZ_CONTROL;                /*!< (@ 0x50040B30) Device Endpoint Transfer Size Register [CONT]          */
    __IO uint32_t  DOEPTSIZ_ISO;                    /*!< (@ 0x50040B30) Device Endpoint Transfer Size Register [ISO]           */
  };
  __IO uint32_t  DOEPDMA;                           /*!< (@ 0x50040B34) Device Endpoint DMA Address Register                   */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  DOEPDMAB;                          /*!< (@ 0x50040B3C) Device Endpoint DMA Buffer Address Register            */
} USB0_EP_TypeDef;


/* ================================================================================ */
/* ================                USB_CH [USB0_CH0]               ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB_CH)
  */

typedef struct {                                    /*!< (@ 0x50040500) USB_CH Structure                                       */
  __IO uint32_t  HCCHAR;                            /*!< (@ 0x50040500) Host Channel Characteristics Register                  */
  __I  uint32_t  RESERVED;
  __IO uint32_t  HCINT;                             /*!< (@ 0x50040508) Host Channel Interrupt Register                        */
  __IO uint32_t  HCINTMSK;                          /*!< (@ 0x5004050C) Host Channel Interrupt Mask Register                   */
  
  union {
    __IO uint32_t  HCTSIZ_SCATGATHER;               /*!< (@ 0x50040510) Host Channel Transfer Size Register [SCATGATHER]       */
    __IO uint32_t  HCTSIZ_BUFFERMODE;               /*!< (@ 0x50040510) Host Channel Transfer Size Register [BUFFERMODE]       */
  };
  
  union {
    __IO uint32_t  HCDMA_SCATGATHER;                /*!< (@ 0x50040514) Host Channel DMA Address Register [SCATGATHER]         */
    __IO uint32_t  HCDMA_BUFFERMODE;                /*!< (@ 0x50040514) Host Channel DMA Address Register [BUFFERMODE]         */
  };
  __I  uint32_t  RESERVED1;
  __I  uint32_t  HCDMAB;                            /*!< (@ 0x5004051C) Host Channel DMA Buffer Address Register               */
} USB0_CH_TypeDef;


/* ================================================================================ */
/* ================                  USIC [USIC0]                  ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Interface Controller 0 (USIC)
  */

typedef struct {                                    /*!< (@ 0x40030008) USIC Structure                                         */
  __I  uint32_t  ID;                                /*!< (@ 0x40030008) Module Identification Register                         */
} USIC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================               USIC_CH [USIC0_CH0]              ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Interface Controller 0 (USIC_CH)
  */

typedef struct {                                    /*!< (@ 0x40030000) USIC_CH Structure                                      */
  __I  uint32_t  RESERVED;
  __I  uint32_t  CCFG;                              /*!< (@ 0x40030004) Channel Configuration Register                         */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  KSCFG;                             /*!< (@ 0x4003000C) Kernel State Configuration Register                    */
  __IO uint32_t  FDR;                               /*!< (@ 0x40030010) Fractional Divider Register                            */
  __IO uint32_t  BRG;                               /*!< (@ 0x40030014) Baud Rate Generator Register                           */
  __IO uint32_t  INPR;                              /*!< (@ 0x40030018) Interrupt Node Pointer Register                        */
  __IO uint32_t  DX0CR;                             /*!< (@ 0x4003001C) Input Control Register 0                               */
  __IO uint32_t  DX1CR;                             /*!< (@ 0x40030020) Input Control Register 1                               */
  __IO uint32_t  DX2CR;                             /*!< (@ 0x40030024) Input Control Register 2                               */
  __IO uint32_t  DX3CR;                             /*!< (@ 0x40030028) Input Control Register 3                               */
  __IO uint32_t  DX4CR;                             /*!< (@ 0x4003002C) Input Control Register 4                               */
  __IO uint32_t  DX5CR;                             /*!< (@ 0x40030030) Input Control Register 5                               */
  __IO uint32_t  SCTR;                              /*!< (@ 0x40030034) Shift Control Register                                 */
  __IO uint32_t  TCSR;                              /*!< (@ 0x40030038) Transmit Control/Status Register                       */
  
  union {
    __IO uint32_t  PCR_IICMode;                     /*!< (@ 0x4003003C) Protocol Control Register [IIC Mode]                   */
    __IO uint32_t  PCR_IISMode;                     /*!< (@ 0x4003003C) Protocol Control Register [IIS Mode]                   */
    __IO uint32_t  PCR_SSCMode;                     /*!< (@ 0x4003003C) Protocol Control Register [SSC Mode]                   */
    __IO uint32_t  PCR;                             /*!< (@ 0x4003003C) Protocol Control Register                              */
    __IO uint32_t  PCR_ASCMode;                     /*!< (@ 0x4003003C) Protocol Control Register [ASC Mode]                   */
  };
  __IO uint32_t  CCR;                               /*!< (@ 0x40030040) Channel Control Register                               */
  __IO uint32_t  CMTR;                              /*!< (@ 0x40030044) Capture Mode Timer Register                            */
  
  union {
    __IO uint32_t  PSR_IICMode;                     /*!< (@ 0x40030048) Protocol Status Register [IIC Mode]                    */
    __IO uint32_t  PSR_IISMode;                     /*!< (@ 0x40030048) Protocol Status Register [IIS Mode]                    */
    __IO uint32_t  PSR_SSCMode;                     /*!< (@ 0x40030048) Protocol Status Register [SSC Mode]                    */
    __IO uint32_t  PSR;                             /*!< (@ 0x40030048) Protocol Status Register                               */
    __IO uint32_t  PSR_ASCMode;                     /*!< (@ 0x40030048) Protocol Status Register [ASC Mode]                    */
  };
  __O  uint32_t  PSCR;                              /*!< (@ 0x4003004C) Protocol Status Clear Register                         */
  __I  uint32_t  RBUFSR;                            /*!< (@ 0x40030050) Receiver Buffer Status Register                        */
  __I  uint32_t  RBUF;                              /*!< (@ 0x40030054) Receiver Buffer Register                               */
  __I  uint32_t  RBUFD;                             /*!< (@ 0x40030058) Receiver Buffer Register for Debugger                  */
  __I  uint32_t  RBUF0;                             /*!< (@ 0x4003005C) Receiver Buffer Register 0                             */
  __I  uint32_t  RBUF1;                             /*!< (@ 0x40030060) Receiver Buffer Register 1                             */
  __I  uint32_t  RBUF01SR;                          /*!< (@ 0x40030064) Receiver Buffer 01 Status Register                     */
  __O  uint32_t  FMR;                               /*!< (@ 0x40030068) Flag Modification Register                             */
  __I  uint32_t  RESERVED2[5];
  __IO uint32_t  TBUF[32];                          /*!< (@ 0x40030080) Transmit Buffer                                        */
  __IO uint32_t  BYP;                               /*!< (@ 0x40030100) Bypass Data Register                                   */
  __IO uint32_t  BYPCR;                             /*!< (@ 0x40030104) Bypass Control Register                                */
  __IO uint32_t  TBCTR;                             /*!< (@ 0x40030108) Transmitter Buffer Control Register                    */
  __IO uint32_t  RBCTR;                             /*!< (@ 0x4003010C) Receiver Buffer Control Register                       */
  __I  uint32_t  TRBPTR;                            /*!< (@ 0x40030110) Transmit/Receive Buffer Pointer Register               */
  __IO uint32_t  TRBSR;                             /*!< (@ 0x40030114) Transmit/Receive Buffer Status Register                */
  __O  uint32_t  TRBSCR;                            /*!< (@ 0x40030118) Transmit/Receive Buffer Status Clear Register          */
  __I  uint32_t  OUTR;                              /*!< (@ 0x4003011C) Receiver Buffer Output Register                        */
  __I  uint32_t  OUTDR;                             /*!< (@ 0x40030120) Receiver Buffer Output Register L for Debugger         */
  __I  uint32_t  RESERVED3[23];
  __O  uint32_t  IN[32];                            /*!< (@ 0x40030180) Transmit FIFO Buffer                                   */
} USIC_CH_TypeDef;


/* ================================================================================ */
/* ================                       CAN                      ================ */
/* ================================================================================ */


/**
  * @brief Controller Area Networks (CAN)
  */

typedef struct {                                    /*!< (@ 0x48014000) CAN Structure                                          */
  __IO uint32_t  CLC;                               /*!< (@ 0x48014000) CAN Clock Control Register                             */
  __I  uint32_t  RESERVED;
  __I  uint32_t  ID;                                /*!< (@ 0x48014008) Module Identification Register                         */
  __IO uint32_t  FDR;                               /*!< (@ 0x4801400C) CAN Fractional Divider Register                        */
  __I  uint32_t  RESERVED1[60];
  __I  uint32_t  LIST[16];                          /*!< (@ 0x48014100) List Register                                          */
  __IO uint32_t  MSPND[8];                          /*!< (@ 0x48014140) Message Pending Register                               */
  __I  uint32_t  RESERVED2[8];
  __I  uint32_t  MSID[8];                           /*!< (@ 0x48014180) Message Index Register                                 */
  __I  uint32_t  RESERVED3[8];
  __IO uint32_t  MSIMASK;                           /*!< (@ 0x480141C0) Message Index Mask Register                            */
  __IO uint32_t  PANCTR;                            /*!< (@ 0x480141C4) Panel Control Register                                 */
  __IO uint32_t  MCR;                               /*!< (@ 0x480141C8) Module Control Register                                */
  __O  uint32_t  MITR;                              /*!< (@ 0x480141CC) Module Interrupt Trigger Register                      */
} CAN_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================              CAN_NODE [CAN_NODE0]              ================ */
/* ================================================================================ */


/**
  * @brief Controller Area Networks (CAN_NODE)
  */

typedef struct {                                    /*!< (@ 0x48014200) CAN_NODE Structure                                     */
  __IO uint32_t  NCR;                               /*!< (@ 0x48014200) Node Control Register                                  */
  __IO uint32_t  NSR;                               /*!< (@ 0x48014204) Node Status Register                                   */
  __IO uint32_t  NIPR;                              /*!< (@ 0x48014208) Node Interrupt Pointer Register                        */
  __IO uint32_t  NPCR;                              /*!< (@ 0x4801420C) Node Port Control Register                             */
  __IO uint32_t  NBTR;                              /*!< (@ 0x48014210) Node Bit Timing Register                               */
  __IO uint32_t  NECNT;                             /*!< (@ 0x48014214) Node Error Counter Register                            */
  __IO uint32_t  NFCR;                              /*!< (@ 0x48014218) Node Frame Counter Register                            */
} CAN_NODE_TypeDef;


/* ================================================================================ */
/* ================             CAN_MO_CLUSTER [CAN_MO]            ================ */
/* ================================================================================ */


/**
  * @brief Controller Area Networks (CAN_MO_CLUSTER)
  */

typedef struct {                                    /*!< (@ 0x48015000) CAN_MO_CLUSTER Structure                               */
  CAN_MO_TypeDef MO[256];                              /*!< (@ 0x48015000) Message Object Registers                               */
} CAN_MO_CLUSTER_Type;


/* ================================================================================ */
/* ================                      VADC                      ================ */
/* ================================================================================ */


/**
  * @brief Analog to Digital Converter (VADC)
  */

typedef struct {                                    /*!< (@ 0x40004000) VADC Structure                                         */
  __IO uint32_t  CLC;                               /*!< (@ 0x40004000) Clock Control Register                                 */
  __I  uint32_t  RESERVED;
  __I  uint32_t  ID;                                /*!< (@ 0x40004008) Module Identification Register                         */
  __I  uint32_t  RESERVED1[7];
  __IO uint32_t  OCS;                               /*!< (@ 0x40004028) OCDS Control and Status Register                       */
  __I  uint32_t  RESERVED2[21];
  __IO uint32_t  GLOBCFG;                           /*!< (@ 0x40004080) Global Configuration Register                          */
  __I  uint32_t  RESERVED3[7];
  __IO uint32_t  GLOBICLASS[2];                     /*!< (@ 0x400040A0) Input Class Register, Global                           */
  __I  uint32_t  RESERVED4[4];
  __IO uint32_t  GLOBBOUND;                         /*!< (@ 0x400040B8) Global Boundary Select Register                        */
  __I  uint32_t  RESERVED5[9];
  __IO uint32_t  GLOBEFLAG;                         /*!< (@ 0x400040E0) Global Event Flag Register                             */
  __I  uint32_t  RESERVED6[23];
  __IO uint32_t  GLOBEVNP;                          /*!< (@ 0x40004140) Global Event Node Pointer Register                     */
  __I  uint32_t  RESERVED7[7];
  __IO uint32_t  GLOBTF;                            /*!< (@ 0x40004160) Global Test Functions Register                         */
  __I  uint32_t  RESERVED8[7];
  __IO uint32_t  BRSSEL[4];                         /*!< (@ 0x40004180) Background Request Source Channel Select Register      */
  __I  uint32_t  RESERVED9[12];
  __IO uint32_t  BRSPND[4];                         /*!< (@ 0x400041C0) Background Request Source Pending Register             */
  __I  uint32_t  RESERVED10[12];
  __IO uint32_t  BRSCTRL;                           /*!< (@ 0x40004200) Background Request Source Control Register             */
  __IO uint32_t  BRSMR;                             /*!< (@ 0x40004204) Background Request Source Mode Register                */
  __I  uint32_t  RESERVED11[30];
  __IO uint32_t  GLOBRCR;                           /*!< (@ 0x40004280) Global Result Control Register                         */
  __I  uint32_t  RESERVED12[31];
  __IO uint32_t  GLOBRES;                           /*!< (@ 0x40004300) Global Result Register                                 */
  __I  uint32_t  RESERVED13[31];
  __IO uint32_t  GLOBRESD;                          /*!< (@ 0x40004380) Global Result Register, Debug                          */
  __I  uint32_t  RESERVED14[27];
  __IO uint32_t  EMUXSEL;                           /*!< (@ 0x400043F0) External Multiplexer Select Register                   */
} VADC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                VADC_G [VADC_G0]                ================ */
/* ================================================================================ */


/**
  * @brief Analog to Digital Converter (VADC_G)
  */

typedef struct {                                    /*!< (@ 0x40004400) VADC_G Structure                                       */
  __I  uint32_t  RESERVED[32];
  __IO uint32_t  ARBCFG;                            /*!< (@ 0x40004480) Arbitration Configuration Register                     */
  __IO uint32_t  ARBPR;                             /*!< (@ 0x40004484) Arbitration Priority Register                          */
  __IO uint32_t  CHASS;                             /*!< (@ 0x40004488) Channel Assignment Register                            */
  __I  uint32_t  RESERVED1[5];
  __IO uint32_t  ICLASS[2];                         /*!< (@ 0x400044A0) Input Class Register                                   */
  __I  uint32_t  RESERVED2[2];
  __IO uint32_t  ALIAS;                             /*!< (@ 0x400044B0) Alias Register                                         */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  BOUND;                             /*!< (@ 0x400044B8) Boundary Select Register                               */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  SYNCTR;                            /*!< (@ 0x400044C0) Synchronization Control Register                       */
  __I  uint32_t  RESERVED5;
  __IO uint32_t  BFL;                               /*!< (@ 0x400044C8) Boundary Flag Register                                 */
  __O  uint32_t  BFLS;                              /*!< (@ 0x400044CC) Boundary Flag Software Register                        */
  __IO uint32_t  BFLC;                              /*!< (@ 0x400044D0) Boundary Flag Control Register                         */
  __IO uint32_t  BFLNP;                             /*!< (@ 0x400044D4) Boundary Flag Node Pointer Register                    */
  __I  uint32_t  RESERVED6[10];
  __IO uint32_t  QCTRL0;                            /*!< (@ 0x40004500) Queue 0 Source Control Register                        */
  __IO uint32_t  QMR0;                              /*!< (@ 0x40004504) Queue 0 Mode Register                                  */
  __I  uint32_t  QSR0;                              /*!< (@ 0x40004508) Queue 0 Status Register                                */
  __I  uint32_t  Q0R0;                              /*!< (@ 0x4000450C) Queue 0 Register 0                                     */
  
  union {
    __I  uint32_t  QBUR0;                           /*!< (@ 0x40004510) Queue 0 Backup Register                                */
    __O  uint32_t  QINR0;                           /*!< (@ 0x40004510) Queue 0 Input Register                                 */
  };
  __I  uint32_t  RESERVED7[3];
  __IO uint32_t  ASCTRL;                            /*!< (@ 0x40004520) Autoscan Source Control Register                       */
  __IO uint32_t  ASMR;                              /*!< (@ 0x40004524) Autoscan Source Mode Register                          */
  __IO uint32_t  ASSEL;                             /*!< (@ 0x40004528) Autoscan Source Channel Select Register                */
  __IO uint32_t  ASPND;                             /*!< (@ 0x4000452C) Autoscan Source Pending Register                       */
  __I  uint32_t  RESERVED8[20];
  __IO uint32_t  CEFLAG;                            /*!< (@ 0x40004580) Channel Event Flag Register                            */
  __IO uint32_t  REFLAG;                            /*!< (@ 0x40004584) Result Event Flag Register                             */
  __IO uint32_t  SEFLAG;                            /*!< (@ 0x40004588) Source Event Flag Register                             */
  __I  uint32_t  RESERVED9;
  __O  uint32_t  CEFCLR;                            /*!< (@ 0x40004590) Channel Event Flag Clear Register                      */
  __O  uint32_t  REFCLR;                            /*!< (@ 0x40004594) Result Event Flag Clear Register                       */
  __O  uint32_t  SEFCLR;                            /*!< (@ 0x40004598) Source Event Flag Clear Register                       */
  __I  uint32_t  RESERVED10;
  __IO uint32_t  CEVNP0;                            /*!< (@ 0x400045A0) Channel Event Node Pointer Register 0                  */
  __I  uint32_t  RESERVED11[3];
  __IO uint32_t  REVNP0;                            /*!< (@ 0x400045B0) Result Event Node Pointer Register 0                   */
  __IO uint32_t  REVNP1;                            /*!< (@ 0x400045B4) Result Event Node Pointer Register 1                   */
  __I  uint32_t  RESERVED12[2];
  __IO uint32_t  SEVNP;                             /*!< (@ 0x400045C0) Source Event Node Pointer Register                     */
  __I  uint32_t  RESERVED13;
  __O  uint32_t  SRACT;                             /*!< (@ 0x400045C8) Service Request Software Activation Trigger            */
  __I  uint32_t  RESERVED14[9];
  __IO uint32_t  EMUXCTR;                           /*!< (@ 0x400045F0) E0ternal Multiplexer Control Register                  */
  __I  uint32_t  RESERVED15;
  __IO uint32_t  VFR;                               /*!< (@ 0x400045F8) Valid Flag Register                                    */
  __I  uint32_t  RESERVED16;
  __IO uint32_t  CHCTR[8];                          /*!< (@ 0x40004600) Channel Ctrl. Reg.                                     */
  __I  uint32_t  RESERVED17[24];
  __IO uint32_t  RCR[16];                           /*!< (@ 0x40004680) Result Control Register                                */
  __I  uint32_t  RESERVED18[16];
  __IO uint32_t  RES[16];                           /*!< (@ 0x40004700) Result Register                                        */
  __I  uint32_t  RESERVED19[16];
  __I  uint32_t  RESD[16];                          /*!< (@ 0x40004780) Result Register, Debug                                 */
} VADC_G_TypeDef;


/* ================================================================================ */
/* ================                       DSD                      ================ */
/* ================================================================================ */


/**
  * @brief Delta Sigma Demodulator (DSD)
  */

typedef struct {                                    /*!< (@ 0x40008000) DSD Structure                                          */
  __IO uint32_t  CLC;                               /*!< (@ 0x40008000) Clock Control Register                                 */
  __I  uint32_t  RESERVED;
  __I  uint32_t  ID;                                /*!< (@ 0x40008008) Module Identification Register                         */
  __I  uint32_t  RESERVED1[7];
  __IO uint32_t  OCS;                               /*!< (@ 0x40008028) OCDS Control and Status Register                       */
  __I  uint32_t  RESERVED2[21];
  __IO uint32_t  GLOBCFG;                           /*!< (@ 0x40008080) Global Configuration Register                          */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  GLOBRC;                            /*!< (@ 0x40008088) Global Run Control Register                            */
  __I  uint32_t  RESERVED4[5];
  __IO uint32_t  CGCFG;                             /*!< (@ 0x400080A0) Carrier Generator Configuration Register               */
  __I  uint32_t  RESERVED5[15];
  __IO uint32_t  EVFLAG;                            /*!< (@ 0x400080E0) Event Flag Register                                    */
  __O  uint32_t  EVFLAGCLR;                         /*!< (@ 0x400080E4) Event Flag Clear Register                              */
} DSD_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                DSD_CH [DSD_CH0]                ================ */
/* ================================================================================ */


/**
  * @brief Delta Sigma Demodulator (DSD_CH)
  */

typedef struct {                                    /*!< (@ 0x40008100) DSD_CH Structure                                       */
  __IO uint32_t  MODCFG;                            /*!< (@ 0x40008100) Modulator Configuration Register                       */
  __I  uint32_t  RESERVED;
  __IO uint32_t  DICFG;                             /*!< (@ 0x40008108) Demodulator Input Configuration Register               */
  __I  uint32_t  RESERVED1[2];
  __IO uint32_t  FCFGC;                             /*!< (@ 0x40008114) Filter Configuration Register, Main CIC Filter         */
  __IO uint32_t  FCFGA;                             /*!< (@ 0x40008118) Filter Configuration Register, Auxiliary Filter        */
  __I  uint32_t  RESERVED2;
  __IO uint32_t  IWCTR;                             /*!< (@ 0x40008120) Integration Window Control Register                    */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  BOUNDSEL;                          /*!< (@ 0x40008128) Boundary Select Register                               */
  __I  uint32_t  RESERVED4;
  __I  uint32_t  RESM;                              /*!< (@ 0x40008130) Result Register, Main Filter                           */
  __I  uint32_t  RESERVED5;
  __IO uint32_t  OFFM;                              /*!< (@ 0x40008138) Offset Register, Main Filter                           */
  __I  uint32_t  RESERVED6;
  __I  uint32_t  RESA;                              /*!< (@ 0x40008140) Result Register, Auxiliary Filter                      */
  __I  uint32_t  RESERVED7[3];
  __I  uint32_t  TSTMP;                             /*!< (@ 0x40008150) Time-Stamp Register                                    */
  __I  uint32_t  RESERVED8[19];
  __IO uint32_t  CGSYNC;                            /*!< (@ 0x400081A0) Carrier Generator Synchronization Register             */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  RECTCFG;                           /*!< (@ 0x400081A8) Rectification Configuration Register                   */
} DSD_CH_TypeDef;


/* ================================================================================ */
/* ================                       DAC                      ================ */
/* ================================================================================ */


/**
  * @brief Digital to Analog Converter (DAC)
  */

typedef struct {                                    /*!< (@ 0x48018000) DAC Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x48018000) Module Identification Register                         */
  __IO uint32_t  DAC0CFG0;                          /*!< (@ 0x48018004) DAC0 Configuration Register 0                          */
  __IO uint32_t  DAC0CFG1;                          /*!< (@ 0x48018008) DAC0 Configuration Register 1                          */
  __IO uint32_t  DAC1CFG0;                          /*!< (@ 0x4801800C) DAC1 Configuration Register 0                          */
  __IO uint32_t  DAC1CFG1;                          /*!< (@ 0x48018010) DAC1 Configuration Register 1                          */
  __IO uint32_t  DAC0DATA;                          /*!< (@ 0x48018014) DAC0 Data Register                                     */
  __IO uint32_t  DAC1DATA;                          /*!< (@ 0x48018018) DAC1 Data Register                                     */
  __IO uint32_t  DAC01DATA;                         /*!< (@ 0x4801801C) DAC01 Data Register                                    */
  __IO uint32_t  DAC0PATL;                          /*!< (@ 0x48018020) DAC0 Lower Pattern Register                            */
  __IO uint32_t  DAC0PATH;                          /*!< (@ 0x48018024) DAC0 Higher Pattern Register                           */
  __IO uint32_t  DAC1PATL;                          /*!< (@ 0x48018028) DAC1 Lower Pattern Register                            */
  __IO uint32_t  DAC1PATH;                          /*!< (@ 0x4801802C) DAC1 Higher Pattern Register                           */
} DAC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                  CCU4 [CCU40]                  ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 4 - Unit 0 (CCU4)
  */

typedef struct {                                    /*!< (@ 0x4000C000) CCU4 Structure                                         */
  __IO uint32_t  GCTRL;                             /*!< (@ 0x4000C000) Global Control Register                                */
  __I  uint32_t  GSTAT;                             /*!< (@ 0x4000C004) Global Status Register                                 */
  __O  uint32_t  GIDLS;                             /*!< (@ 0x4000C008) Global Idle Set                                        */
  __O  uint32_t  GIDLC;                             /*!< (@ 0x4000C00C) Global Idle Clear                                      */
  __O  uint32_t  GCSS;                              /*!< (@ 0x4000C010) Global Channel Set                                     */
  __O  uint32_t  GCSC;                              /*!< (@ 0x4000C014) Global Channel Clear                                   */
  __I  uint32_t  GCST;                              /*!< (@ 0x4000C018) Global Channel Status                                  */
  __I  uint32_t  RESERVED[25];
  __I  uint32_t  MIDR;                              /*!< (@ 0x4000C080) Module Identification                                  */
} CCU4_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================              CCU4_CC4 [CCU40_CC40]             ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 4 - Unit 0 (CCU4_CC4)
  */

typedef struct {                                    /*!< (@ 0x4000C100) CCU4_CC4 Structure                                     */
  __IO uint32_t  INS;                               /*!< (@ 0x4000C100) Input Selector Configuration                           */
  __IO uint32_t  CMC;                               /*!< (@ 0x4000C104) Connection Matrix Control                              */
  __I  uint32_t  TCST;                              /*!< (@ 0x4000C108) Slice Timer Status                                     */
  __O  uint32_t  TCSET;                             /*!< (@ 0x4000C10C) Slice Timer Run Set                                    */
  __O  uint32_t  TCCLR;                             /*!< (@ 0x4000C110) Slice Timer Clear                                      */
  __IO uint32_t  TC;                                /*!< (@ 0x4000C114) Slice Timer Control                                    */
  __IO uint32_t  PSL;                               /*!< (@ 0x4000C118) Passive Level Config                                   */
  __I  uint32_t  DIT;                               /*!< (@ 0x4000C11C) Dither Config                                          */
  __IO uint32_t  DITS;                              /*!< (@ 0x4000C120) Dither Shadow Register                                 */
  __IO uint32_t  PSC;                               /*!< (@ 0x4000C124) Prescaler Control                                      */
  __IO uint32_t  FPC;                               /*!< (@ 0x4000C128) Floating Prescaler Control                             */
  __IO uint32_t  FPCS;                              /*!< (@ 0x4000C12C) Floating Prescaler Shadow                              */
  __I  uint32_t  PR;                                /*!< (@ 0x4000C130) Timer Period Value                                     */
  __IO uint32_t  PRS;                               /*!< (@ 0x4000C134) Timer Shadow Period Value                              */
  __I  uint32_t  CR;                                /*!< (@ 0x4000C138) Timer Compare Value                                    */
  __IO uint32_t  CRS;                               /*!< (@ 0x4000C13C) Timer Shadow Compare Value                             */
  __I  uint32_t  RESERVED[12];
  __IO uint32_t  TIMER;                             /*!< (@ 0x4000C170) Timer Value                                            */
  __I  uint32_t  CV[4];                             /*!< (@ 0x4000C174) Capture Register 0                                     */
  __I  uint32_t  RESERVED1[7];
  __I  uint32_t  INTS;                              /*!< (@ 0x4000C1A0) Interrupt Status                                       */
  __IO uint32_t  INTE;                              /*!< (@ 0x4000C1A4) Interrupt Enable Control                               */
  __IO uint32_t  SRS;                               /*!< (@ 0x4000C1A8) Service Request Selector                               */
  __O  uint32_t  SWS;                               /*!< (@ 0x4000C1AC) Interrupt Status Set                                   */
  __O  uint32_t  SWR;                               /*!< (@ 0x4000C1B0) Interrupt Status Clear                                 */
  __I  uint32_t  RESERVED2;
  __I  uint32_t  ECRD0;                             /*!< (@ 0x4000C1B8) Extended Read Back 0                                   */
  __I  uint32_t  ECRD1;                             /*!< (@ 0x4000C1BC) Extended Read Back 1                                   */
} CCU4_CC4_TypeDef;


/* ================================================================================ */
/* ================                  CCU8 [CCU80]                  ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 8 - Unit 0 (CCU8)
  */

typedef struct {                                    /*!< (@ 0x40020000) CCU8 Structure                                         */
  __IO uint32_t  GCTRL;                             /*!< (@ 0x40020000) Global Control Register                                */
  __I  uint32_t  GSTAT;                             /*!< (@ 0x40020004) Global Status Register                                 */
  __O  uint32_t  GIDLS;                             /*!< (@ 0x40020008) Global Idle Set                                        */
  __O  uint32_t  GIDLC;                             /*!< (@ 0x4002000C) Global Idle Clear                                      */
  __O  uint32_t  GCSS;                              /*!< (@ 0x40020010) Global Channel Set                                     */
  __O  uint32_t  GCSC;                              /*!< (@ 0x40020014) Global Channel Clear                                   */
  __I  uint32_t  GCST;                              /*!< (@ 0x40020018) Global Channel status                                  */
  __IO uint32_t  GPCHK;                             /*!< (@ 0x4002001C) Parity Checker Configuration                           */
  __I  uint32_t  RESERVED[12];
  __I  uint32_t  ECRD;                              /*!< (@ 0x40020050) Extended Capture Mode Read                             */
  __I  uint32_t  RESERVED1[11];
  __I  uint32_t  MIDR;                              /*!< (@ 0x40020080) Module Identification                                  */
} CCU8_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================              CCU8_CC8 [CCU80_CC80]             ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 8 - Unit 0 (CCU8_CC8)
  */

typedef struct {                                    /*!< (@ 0x40020100) CCU8_CC8 Structure                                     */
  __IO uint32_t  INS;                               /*!< (@ 0x40020100) Input Selector Configuration                           */
  __IO uint32_t  CMC;                               /*!< (@ 0x40020104) Connection Matrix Control                              */
  __I  uint32_t  TCST;                              /*!< (@ 0x40020108) Slice Timer Status                                     */
  __O  uint32_t  TCSET;                             /*!< (@ 0x4002010C) Slice Timer Run Set                                    */
  __O  uint32_t  TCCLR;                             /*!< (@ 0x40020110) Slice Timer Clear                                      */
  __IO uint32_t  TC;                                /*!< (@ 0x40020114) Slice Timer Control                                    */
  __IO uint32_t  PSL;                               /*!< (@ 0x40020118) Passive Level Config                                   */
  __I  uint32_t  DIT;                               /*!< (@ 0x4002011C) Dither Config                                          */
  __IO uint32_t  DITS;                              /*!< (@ 0x40020120) Dither Shadow Register                                 */
  __IO uint32_t  PSC;                               /*!< (@ 0x40020124) Prescaler Control                                      */
  __IO uint32_t  FPC;                               /*!< (@ 0x40020128) Floating Prescaler Control                             */
  __IO uint32_t  FPCS;                              /*!< (@ 0x4002012C) Floating Prescaler Shadow                              */
  __I  uint32_t  PR;                                /*!< (@ 0x40020130) Timer Period Value                                     */
  __IO uint32_t  PRS;                               /*!< (@ 0x40020134) Timer Shadow Period Value                              */
  __I  uint32_t  CR1;                               /*!< (@ 0x40020138) Channel 1 Compare Value                                */
  __IO uint32_t  CR1S;                              /*!< (@ 0x4002013C) Channel 1 Compare Shadow Value                         */
  __I  uint32_t  CR2;                               /*!< (@ 0x40020140) Channel 2 Compare Value                                */
  __IO uint32_t  CR2S;                              /*!< (@ 0x40020144) Channel 2 Compare Shadow Value                         */
  __IO uint32_t  CHC;                               /*!< (@ 0x40020148) Channel Control                                        */
  __IO uint32_t  DTC;                               /*!< (@ 0x4002014C) Dead Time Control                                      */
  __IO uint32_t  DC1R;                              /*!< (@ 0x40020150) Channel 1 Dead Time Values                             */
  __IO uint32_t  DC2R;                              /*!< (@ 0x40020154) Channel 2 Dead Time Values                             */
  __I  uint32_t  RESERVED[6];
  __IO uint32_t  TIMER;                             /*!< (@ 0x40020170) Timer Value                                            */
  __I  uint32_t  CV[4];                             /*!< (@ 0x40020174) Capture Register 0                                     */
  __I  uint32_t  RESERVED1[7];
  __I  uint32_t  INTS;                              /*!< (@ 0x400201A0) Interrupt Status                                       */
  __IO uint32_t  INTE;                              /*!< (@ 0x400201A4) Interrupt Enable Control                               */
  __IO uint32_t  SRS;                               /*!< (@ 0x400201A8) Service Request Selector                               */
  __O  uint32_t  SWS;                               /*!< (@ 0x400201AC) Interrupt Status Set                                   */
  __O  uint32_t  SWR;                               /*!< (@ 0x400201B0) Interrupt Status Clear                                 */
  __IO uint32_t  STC;                               /*!< (@ 0x400201B4) Shadow transfer control                                */
  __I  uint32_t  ECRD0;                             /*!< (@ 0x400201B8) Extended Read Back 0                                   */
  __I  uint32_t  ECRD1;                             /*!< (@ 0x400201BC) Extended Read Back 1                                   */
} CCU8_CC8_TypeDef;


/* ================================================================================ */
/* ================                 POSIF [POSIF0]                 ================ */
/* ================================================================================ */


/**
  * @brief Position Interface 0 (POSIF)
  */

typedef struct {                                    /*!< (@ 0x40028000) POSIF Structure                                        */
  __IO uint32_t  PCONF;                             /*!< (@ 0x40028000) POSIF configuration                                    */
  __IO uint32_t  PSUS;                              /*!< (@ 0x40028004) POSIF Suspend Config                                   */
  __O  uint32_t  PRUNS;                             /*!< (@ 0x40028008) POSIF Run Bit Set                                      */
  __O  uint32_t  PRUNC;                             /*!< (@ 0x4002800C) POSIF Run Bit Clear                                    */
  __I  uint32_t  PRUN;                              /*!< (@ 0x40028010) POSIF Run Bit Status                                   */
  __I  uint32_t  RESERVED[3];
  __I  uint32_t  MIDR;                              /*!< (@ 0x40028020) Module Identification register                         */
  __I  uint32_t  RESERVED1[3];
  __I  uint32_t  HALP;                              /*!< (@ 0x40028030) Hall Sensor Patterns                                   */
  __IO uint32_t  HALPS;                             /*!< (@ 0x40028034) Hall Sensor Shadow Patterns                            */
  __I  uint32_t  RESERVED2[2];
  __I  uint32_t  MCM;                               /*!< (@ 0x40028040) Multi-Channel Pattern                                  */
  __IO uint32_t  MCSM;                              /*!< (@ 0x40028044) Multi-Channel Shadow Pattern                           */
  __O  uint32_t  MCMS;                              /*!< (@ 0x40028048) Multi-Channel Pattern Control set                      */
  __O  uint32_t  MCMC;                              /*!< (@ 0x4002804C) Multi-Channel Pattern Control clear                    */
  __I  uint32_t  MCMF;                              /*!< (@ 0x40028050) Multi-Channel Pattern Control flag                     */
  __I  uint32_t  RESERVED3[3];
  __IO uint32_t  QDC;                               /*!< (@ 0x40028060) Quadrature Decoder Control                             */
  __I  uint32_t  RESERVED4[3];
  __I  uint32_t  PFLG;                              /*!< (@ 0x40028070) POSIF Interrupt Flags                                  */
  __IO uint32_t  PFLGE;                             /*!< (@ 0x40028074) POSIF Interrupt Enable                                 */
  __O  uint32_t  SPFLG;                             /*!< (@ 0x40028078) POSIF Interrupt Set                                    */
  __O  uint32_t  RPFLG;                             /*!< (@ 0x4002807C) POSIF Interrupt Clear                                  */
  __I  uint32_t  RESERVED5[32];
  __I  uint32_t  PDBG;                              /*!< (@ 0x40028100) POSIF Debug register                                   */
} POSIF_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                      PORT0                     ================ */
/* ================================================================================ */


/**
  * @brief Port 0 (PORT0)
  */

typedef struct {                                    /*!< (@ 0x48028000) PORT0 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028000) Port 0 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028004) Port 0 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028010) Port 0 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028014) Port 0 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028018) Port 0 Input/Output Control Register 8                 */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x4802801C) Port 0 Input/Output Control Register 12                */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028024) Port 0 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028040) Port 0 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028044) Port 0 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028060) Port 0 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028070) Port 0 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028074) Port 0 Pin Hardware Select Register                    */
} PORT0_Type;


/* ================================================================================ */
/* ================                      PORT1                     ================ */
/* ================================================================================ */


/**
  * @brief Port 1 (PORT1)
  */

typedef struct {                                    /*!< (@ 0x48028100) PORT1 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028100) Port 1 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028104) Port 1 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028110) Port 1 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028114) Port 1 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028118) Port 1 Input/Output Control Register 8                 */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x4802811C) Port 1 Input/Output Control Register 12                */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028124) Port 1 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028140) Port 1 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028144) Port 1 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028160) Port 1 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028170) Port 1 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028174) Port 1 Pin Hardware Select Register                    */
} PORT1_Type;


/* ================================================================================ */
/* ================                      PORT2                     ================ */
/* ================================================================================ */


/**
  * @brief Port 2 (PORT2)
  */

typedef struct {                                    /*!< (@ 0x48028200) PORT2 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028200) Port 2 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028204) Port 2 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028210) Port 2 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028214) Port 2 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028218) Port 2 Input/Output Control Register 8                 */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x4802821C) Port 2 Input/Output Control Register 12                */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028224) Port 2 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028240) Port 2 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028244) Port 2 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028260) Port 2 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028270) Port 2 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028274) Port 2 Pin Hardware Select Register                    */
} PORT2_Type;


/* ================================================================================ */
/* ================                      PORT3                     ================ */
/* ================================================================================ */


/**
  * @brief Port 3 (PORT3)
  */

typedef struct {                                    /*!< (@ 0x48028300) PORT3 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028300) Port 3 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028304) Port 3 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028310) Port 3 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028314) Port 3 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028318) Port 3 Input/Output Control Register 8                 */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x4802831C) Port 3 Input/Output Control Register 12                */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028324) Port 3 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028340) Port 3 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028344) Port 3 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028360) Port 3 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028370) Port 3 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028374) Port 3 Pin Hardware Select Register                    */
} PORT3_Type;


/* ================================================================================ */
/* ================                      PORT4                     ================ */
/* ================================================================================ */


/**
  * @brief Port 4 (PORT4)
  */

typedef struct {                                    /*!< (@ 0x48028400) PORT4 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028400) Port 4 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028404) Port 4 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028410) Port 4 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028414) Port 4 Input/Output Control Register 4                 */
  __I  uint32_t  RESERVED1[3];
  __I  uint32_t  IN;                                /*!< (@ 0x48028424) Port 4 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028440) Port 4 Pad Driver Mode 0 Register                      */
  __I  uint32_t  RESERVED3[7];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028460) Port 4 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028470) Port 4 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028474) Port 4 Pin Hardware Select Register                    */
} PORT4_Type;


/* ================================================================================ */
/* ================                      PORT5                     ================ */
/* ================================================================================ */


/**
  * @brief Port 5 (PORT5)
  */

typedef struct {                                    /*!< (@ 0x48028500) PORT5 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028500) Port 5 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028504) Port 5 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028510) Port 5 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028514) Port 5 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028518) Port 5 Input/Output Control Register 8                 */
  __I  uint32_t  RESERVED1[2];
  __I  uint32_t  IN;                                /*!< (@ 0x48028524) Port 5 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028540) Port 5 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028544) Port 5 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028560) Port 5 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028570) Port 5 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028574) Port 5 Pin Hardware Select Register                    */
} PORT5_Type;


/* ================================================================================ */
/* ================                      PORT6                     ================ */
/* ================================================================================ */


/**
  * @brief Port 6 (PORT6)
  */

typedef struct {                                    /*!< (@ 0x48028600) PORT6 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028600) Port 6 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028604) Port 6 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028610) Port 6 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028614) Port 6 Input/Output Control Register 4                 */
  __I  uint32_t  RESERVED1[3];
  __I  uint32_t  IN;                                /*!< (@ 0x48028624) Port 6 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028640) Port 6 Pad Driver Mode 0 Register                      */
  __I  uint32_t  RESERVED3[7];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028660) Port 6 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028670) Port 6 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028674) Port 6 Pin Hardware Select Register                    */
} PORT6_Type;


/* ================================================================================ */
/* ================                      PORT7                     ================ */
/* ================================================================================ */


/**
  * @brief Port 7 (PORT7)
  */

typedef struct {                                    /*!< (@ 0x48028700) PORT7 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028700) Port 7 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028704) Port 7 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028710) Port 7 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028714) Port 7 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028718) Port 7 Input/Output Control Register 8                 */
  __I  uint32_t  RESERVED1[2];
  __I  uint32_t  IN;                                /*!< (@ 0x48028724) Port 7 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028740) Port 7 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028744) Port 7 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028760) Port 7 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028770) Port 7 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028774) Port 7 Pin Hardware Select Register                    */
} PORT7_Type;


/* ================================================================================ */
/* ================                      PORT8                     ================ */
/* ================================================================================ */


/**
  * @brief Port 8 (PORT8)
  */

typedef struct {                                    /*!< (@ 0x48028800) PORT8 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028800) Port 8 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028804) Port 8 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028810) Port 8 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028814) Port 8 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028818) Port 8 Input/Output Control Register 8                 */
  __I  uint32_t  RESERVED1[2];
  __I  uint32_t  IN;                                /*!< (@ 0x48028824) Port 8 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028840) Port 8 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028844) Port 8 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028860) Port 8 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028870) Port 8 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028874) Port 8 Pin Hardware Select Register                    */
} PORT8_Type;


/* ================================================================================ */
/* ================                      PORT9                     ================ */
/* ================================================================================ */


/**
  * @brief Port 9 (PORT9)
  */

typedef struct {                                    /*!< (@ 0x48028900) PORT9 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028900) Port 9 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028904) Port 9 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028910) Port 9 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028914) Port 5 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028918) Port 9 Input/Output Control Register 8                 */
  __I  uint32_t  RESERVED1[2];
  __I  uint32_t  IN;                                /*!< (@ 0x48028924) Port 9 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028940) Port 9 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028944) Port 9 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028960) Port 9 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028970) Port 9 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028974) Port 9 Pin Hardware Select Register                    */
} PORT9_Type;


/* ================================================================================ */
/* ================                     PORT14                     ================ */
/* ================================================================================ */


/**
  * @brief Port 14 (PORT14)
  */

typedef struct {                                    /*!< (@ 0x48028E00) PORT14 Structure                                       */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028E00) Port 14 Output Register                                */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028E04) Port 14 Output Modification Register                   */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028E10) Port 14 Input/Output Control Register 0                */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028E14) Port 14 Input/Output Control Register 4                */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028E18) Port 14 Input/Output Control Register 8                */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x48028E1C) Port 14 Input/Output Control Register 12               */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028E24) Port 14 Input Register                                 */
  __I  uint32_t  RESERVED2[14];
  __IO uint32_t  PDISC;                             /*!< (@ 0x48028E60) Port 14 Pin Function Decision Control Register         */
  __I  uint32_t  RESERVED3[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028E70) Port 14 Pin Power Save Register                        */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028E74) Port 14 Pin Hardware Select Register                   */
} PORT14_Type;


/* ================================================================================ */
/* ================                     PORT15                     ================ */
/* ================================================================================ */


/**
  * @brief Port 15 (PORT15)
  */

typedef struct {                                    /*!< (@ 0x48028F00) PORT15 Structure                                       */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028F00) Port 15 Output Register                                */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028F04) Port 15 Output Modification Register                   */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028F10) Port 15 Input/Output Control Register 0                */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028F14) Port 15 Input/Output Control Register 4                */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028F18) Port 15 Input/Output Control Register 8                */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x48028F1C) Port 15 Input/Output Control Register 12               */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028F24) Port 15 Input Register                                 */
  __I  uint32_t  RESERVED2[14];
  __IO uint32_t  PDISC;                             /*!< (@ 0x48028F60) Port 15 Pin Function Decision Control Register         */
  __I  uint32_t  RESERVED3[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028F70) Port 15 Pin Power Save Register                        */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028F74) Port 15 Pin Hardware Select Register                   */
} PORT15_Type;


/* --------------------  End of section using anonymous unions  ------------------- */
#if defined(__CC_ARM)
  #pragma pop
#elif defined(__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined(__TASKING__)
  #pragma warning restore
#else
  #warning Not supported compiler type
#endif



/* ================================================================================ */
/* ================          struct 'PPB' Position & Mask          ================ */
/* ================================================================================ */


/* ----------------------------------  PPB_ACTLR  --------------------------------- */
#define PPB_ACTLR_DISMCYCINT_Pos              (0UL)                     /*!< PPB ACTLR: DISMCYCINT (Bit 0)                               */
#define PPB_ACTLR_DISMCYCINT_Msk              (0x1UL)                   /*!< PPB ACTLR: DISMCYCINT (Bitfield-Mask: 0x01)                 */
#define PPB_ACTLR_DISDEFWBUF_Pos              (1UL)                     /*!< PPB ACTLR: DISDEFWBUF (Bit 1)                               */
#define PPB_ACTLR_DISDEFWBUF_Msk              (0x2UL)                   /*!< PPB ACTLR: DISDEFWBUF (Bitfield-Mask: 0x01)                 */
#define PPB_ACTLR_DISFOLD_Pos                 (2UL)                     /*!< PPB ACTLR: DISFOLD (Bit 2)                                  */
#define PPB_ACTLR_DISFOLD_Msk                 (0x4UL)                   /*!< PPB ACTLR: DISFOLD (Bitfield-Mask: 0x01)                    */
#define PPB_ACTLR_DISFPCA_Pos                 (8UL)                     /*!< PPB ACTLR: DISFPCA (Bit 8)                                  */
#define PPB_ACTLR_DISFPCA_Msk                 (0x100UL)                 /*!< PPB ACTLR: DISFPCA (Bitfield-Mask: 0x01)                    */
#define PPB_ACTLR_DISOOFP_Pos                 (9UL)                     /*!< PPB ACTLR: DISOOFP (Bit 9)                                  */
#define PPB_ACTLR_DISOOFP_Msk                 (0x200UL)                 /*!< PPB ACTLR: DISOOFP (Bitfield-Mask: 0x01)                    */

/* --------------------------------  PPB_SYST_CSR  -------------------------------- */
#define PPB_SYST_CSR_ENABLE_Pos               (0UL)                     /*!< PPB SYST_CSR: ENABLE (Bit 0)                                */
#define PPB_SYST_CSR_ENABLE_Msk               (0x1UL)                   /*!< PPB SYST_CSR: ENABLE (Bitfield-Mask: 0x01)                  */
#define PPB_SYST_CSR_TICKINT_Pos              (1UL)                     /*!< PPB SYST_CSR: TICKINT (Bit 1)                               */
#define PPB_SYST_CSR_TICKINT_Msk              (0x2UL)                   /*!< PPB SYST_CSR: TICKINT (Bitfield-Mask: 0x01)                 */
#define PPB_SYST_CSR_CLKSOURCE_Pos            (2UL)                     /*!< PPB SYST_CSR: CLKSOURCE (Bit 2)                             */
#define PPB_SYST_CSR_CLKSOURCE_Msk            (0x4UL)                   /*!< PPB SYST_CSR: CLKSOURCE (Bitfield-Mask: 0x01)               */
#define PPB_SYST_CSR_COUNTFLAG_Pos            (16UL)                    /*!< PPB SYST_CSR: COUNTFLAG (Bit 16)                            */
#define PPB_SYST_CSR_COUNTFLAG_Msk            (0x10000UL)               /*!< PPB SYST_CSR: COUNTFLAG (Bitfield-Mask: 0x01)               */

/* --------------------------------  PPB_SYST_RVR  -------------------------------- */
#define PPB_SYST_RVR_RELOAD_Pos               (0UL)                     /*!< PPB SYST_RVR: RELOAD (Bit 0)                                */
#define PPB_SYST_RVR_RELOAD_Msk               (0xffffffUL)              /*!< PPB SYST_RVR: RELOAD (Bitfield-Mask: 0xffffff)              */

/* --------------------------------  PPB_SYST_CVR  -------------------------------- */
#define PPB_SYST_CVR_CURRENT_Pos              (0UL)                     /*!< PPB SYST_CVR: CURRENT (Bit 0)                               */
#define PPB_SYST_CVR_CURRENT_Msk              (0xffffffUL)              /*!< PPB SYST_CVR: CURRENT (Bitfield-Mask: 0xffffff)             */

/* -------------------------------  PPB_SYST_CALIB  ------------------------------- */
#define PPB_SYST_CALIB_TENMS_Pos              (0UL)                     /*!< PPB SYST_CALIB: TENMS (Bit 0)                               */
#define PPB_SYST_CALIB_TENMS_Msk              (0xffffffUL)              /*!< PPB SYST_CALIB: TENMS (Bitfield-Mask: 0xffffff)             */
#define PPB_SYST_CALIB_SKEW_Pos               (30UL)                    /*!< PPB SYST_CALIB: SKEW (Bit 30)                               */
#define PPB_SYST_CALIB_SKEW_Msk               (0x40000000UL)            /*!< PPB SYST_CALIB: SKEW (Bitfield-Mask: 0x01)                  */
#define PPB_SYST_CALIB_NOREF_Pos              (31UL)                    /*!< PPB SYST_CALIB: NOREF (Bit 31)                              */
#define PPB_SYST_CALIB_NOREF_Msk              (0x80000000UL)            /*!< PPB SYST_CALIB: NOREF (Bitfield-Mask: 0x01)                 */

/* -------------------------------  PPB_NVIC_ISER0  ------------------------------- */
#define PPB_NVIC_ISER0_SETENA_Pos             (0UL)                     /*!< PPB NVIC_ISER0: SETENA (Bit 0)                              */
#define PPB_NVIC_ISER0_SETENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ISER0: SETENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ISER1  ------------------------------- */
#define PPB_NVIC_ISER1_SETENA_Pos             (0UL)                     /*!< PPB NVIC_ISER1: SETENA (Bit 0)                              */
#define PPB_NVIC_ISER1_SETENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ISER1: SETENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ISER2  ------------------------------- */
#define PPB_NVIC_ISER2_SETENA_Pos             (0UL)                     /*!< PPB NVIC_ISER2: SETENA (Bit 0)                              */
#define PPB_NVIC_ISER2_SETENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ISER2: SETENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ISER3  ------------------------------- */
#define PPB_NVIC_ISER3_SETENA_Pos             (0UL)                     /*!< PPB NVIC_ISER3: SETENA (Bit 0)                              */
#define PPB_NVIC_ISER3_SETENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ISER3: SETENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ICER0  ------------------------------- */
#define PPB_NVIC_ICER0_CLRENA_Pos             (0UL)                     /*!< PPB NVIC_ICER0: CLRENA (Bit 0)                              */
#define PPB_NVIC_ICER0_CLRENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ICER0: CLRENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ICER1  ------------------------------- */
#define PPB_NVIC_ICER1_CLRENA_Pos             (0UL)                     /*!< PPB NVIC_ICER1: CLRENA (Bit 0)                              */
#define PPB_NVIC_ICER1_CLRENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ICER1: CLRENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ICER2  ------------------------------- */
#define PPB_NVIC_ICER2_CLRENA_Pos             (0UL)                     /*!< PPB NVIC_ICER2: CLRENA (Bit 0)                              */
#define PPB_NVIC_ICER2_CLRENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ICER2: CLRENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ICER3  ------------------------------- */
#define PPB_NVIC_ICER3_CLRENA_Pos             (0UL)                     /*!< PPB NVIC_ICER3: CLRENA (Bit 0)                              */
#define PPB_NVIC_ICER3_CLRENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ICER3: CLRENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ISPR0  ------------------------------- */
#define PPB_NVIC_ISPR0_SETPEND_Pos            (0UL)                     /*!< PPB NVIC_ISPR0: SETPEND (Bit 0)                             */
#define PPB_NVIC_ISPR0_SETPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ISPR0: SETPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_ISPR1  ------------------------------- */
#define PPB_NVIC_ISPR1_SETPEND_Pos            (0UL)                     /*!< PPB NVIC_ISPR1: SETPEND (Bit 0)                             */
#define PPB_NVIC_ISPR1_SETPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ISPR1: SETPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_ISPR2  ------------------------------- */
#define PPB_NVIC_ISPR2_SETPEND_Pos            (0UL)                     /*!< PPB NVIC_ISPR2: SETPEND (Bit 0)                             */
#define PPB_NVIC_ISPR2_SETPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ISPR2: SETPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_ISPR3  ------------------------------- */
#define PPB_NVIC_ISPR3_SETPEND_Pos            (0UL)                     /*!< PPB NVIC_ISPR3: SETPEND (Bit 0)                             */
#define PPB_NVIC_ISPR3_SETPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ISPR3: SETPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_ICPR0  ------------------------------- */
#define PPB_NVIC_ICPR0_CLRPEND_Pos            (0UL)                     /*!< PPB NVIC_ICPR0: CLRPEND (Bit 0)                             */
#define PPB_NVIC_ICPR0_CLRPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ICPR0: CLRPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_ICPR1  ------------------------------- */
#define PPB_NVIC_ICPR1_CLRPEND_Pos            (0UL)                     /*!< PPB NVIC_ICPR1: CLRPEND (Bit 0)                             */
#define PPB_NVIC_ICPR1_CLRPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ICPR1: CLRPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_ICPR2  ------------------------------- */
#define PPB_NVIC_ICPR2_CLRPEND_Pos            (0UL)                     /*!< PPB NVIC_ICPR2: CLRPEND (Bit 0)                             */
#define PPB_NVIC_ICPR2_CLRPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ICPR2: CLRPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_ICPR3  ------------------------------- */
#define PPB_NVIC_ICPR3_CLRPEND_Pos            (0UL)                     /*!< PPB NVIC_ICPR3: CLRPEND (Bit 0)                             */
#define PPB_NVIC_ICPR3_CLRPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ICPR3: CLRPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_IABR0  ------------------------------- */
#define PPB_NVIC_IABR0_ACTIVE_Pos             (0UL)                     /*!< PPB NVIC_IABR0: ACTIVE (Bit 0)                              */
#define PPB_NVIC_IABR0_ACTIVE_Msk             (0xffffffffUL)            /*!< PPB NVIC_IABR0: ACTIVE (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_IABR1  ------------------------------- */
#define PPB_NVIC_IABR1_ACTIVE_Pos             (0UL)                     /*!< PPB NVIC_IABR1: ACTIVE (Bit 0)                              */
#define PPB_NVIC_IABR1_ACTIVE_Msk             (0xffffffffUL)            /*!< PPB NVIC_IABR1: ACTIVE (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_IABR2  ------------------------------- */
#define PPB_NVIC_IABR2_ACTIVE_Pos             (0UL)                     /*!< PPB NVIC_IABR2: ACTIVE (Bit 0)                              */
#define PPB_NVIC_IABR2_ACTIVE_Msk             (0xffffffffUL)            /*!< PPB NVIC_IABR2: ACTIVE (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_IABR3  ------------------------------- */
#define PPB_NVIC_IABR3_ACTIVE_Pos             (0UL)                     /*!< PPB NVIC_IABR3: ACTIVE (Bit 0)                              */
#define PPB_NVIC_IABR3_ACTIVE_Msk             (0xffffffffUL)            /*!< PPB NVIC_IABR3: ACTIVE (Bitfield-Mask: 0xffffffff)          */

/* --------------------------------  PPB_NVIC_IPR0  ------------------------------- */
#define PPB_NVIC_IPR0_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR0: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR0_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR0: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR0_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR0: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR0_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR0: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR0_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR0: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR0_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR0: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR0_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR0: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR0_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR0: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR1  ------------------------------- */
#define PPB_NVIC_IPR1_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR1: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR1_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR1: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR1_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR1: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR1_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR1: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR1_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR1: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR1_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR1: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR1_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR1: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR1_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR1: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR2  ------------------------------- */
#define PPB_NVIC_IPR2_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR2: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR2_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR2: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR2_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR2: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR2_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR2: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR2_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR2: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR2_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR2: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR2_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR2: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR2_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR2: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR3  ------------------------------- */
#define PPB_NVIC_IPR3_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR3: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR3_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR3: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR3_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR3: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR3_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR3: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR3_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR3: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR3_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR3: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR3_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR3: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR3_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR3: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR4  ------------------------------- */
#define PPB_NVIC_IPR4_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR4: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR4_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR4: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR4_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR4: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR4_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR4: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR4_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR4: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR4_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR4: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR4_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR4: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR4_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR4: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR5  ------------------------------- */
#define PPB_NVIC_IPR5_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR5: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR5_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR5: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR5_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR5: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR5_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR5: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR5_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR5: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR5_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR5: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR5_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR5: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR5_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR5: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR6  ------------------------------- */
#define PPB_NVIC_IPR6_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR6: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR6_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR6: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR6_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR6: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR6_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR6: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR6_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR6: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR6_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR6: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR6_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR6: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR6_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR6: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR7  ------------------------------- */
#define PPB_NVIC_IPR7_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR7: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR7_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR7: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR7_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR7: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR7_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR7: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR7_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR7: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR7_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR7: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR7_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR7: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR7_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR7: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR8  ------------------------------- */
#define PPB_NVIC_IPR8_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR8: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR8_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR8: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR8_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR8: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR8_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR8: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR8_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR8: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR8_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR8: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR8_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR8: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR8_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR8: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR9  ------------------------------- */
#define PPB_NVIC_IPR9_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR9: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR9_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR9: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR9_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR9: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR9_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR9: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR9_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR9: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR9_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR9: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR9_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR9: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR9_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR9: PRI_3 (Bitfield-Mask: 0xff)                  */

/* -------------------------------  PPB_NVIC_IPR10  ------------------------------- */
#define PPB_NVIC_IPR10_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR10: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR10_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR10: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR10_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR10: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR10_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR10: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR10_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR10: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR10_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR10: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR10_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR10: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR10_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR10: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR11  ------------------------------- */
#define PPB_NVIC_IPR11_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR11: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR11_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR11: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR11_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR11: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR11_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR11: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR11_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR11: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR11_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR11: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR11_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR11: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR11_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR11: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR12  ------------------------------- */
#define PPB_NVIC_IPR12_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR12: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR12_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR12: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR12_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR12: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR12_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR12: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR12_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR12: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR12_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR12: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR12_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR12: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR12_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR12: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR13  ------------------------------- */
#define PPB_NVIC_IPR13_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR13: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR13_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR13: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR13_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR13: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR13_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR13: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR13_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR13: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR13_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR13: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR13_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR13: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR13_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR13: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR14  ------------------------------- */
#define PPB_NVIC_IPR14_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR14: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR14_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR14: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR14_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR14: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR14_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR14: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR14_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR14: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR14_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR14: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR14_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR14: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR14_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR14: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR15  ------------------------------- */
#define PPB_NVIC_IPR15_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR15: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR15_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR15: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR15_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR15: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR15_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR15: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR15_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR15: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR15_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR15: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR15_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR15: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR15_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR15: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR16  ------------------------------- */
#define PPB_NVIC_IPR16_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR16: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR16_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR16: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR16_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR16: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR16_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR16: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR16_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR16: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR16_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR16: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR16_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR16: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR16_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR16: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR17  ------------------------------- */
#define PPB_NVIC_IPR17_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR17: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR17_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR17: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR17_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR17: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR17_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR17: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR17_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR17: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR17_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR17: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR17_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR17: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR17_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR17: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR18  ------------------------------- */
#define PPB_NVIC_IPR18_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR18: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR18_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR18: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR18_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR18: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR18_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR18: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR18_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR18: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR18_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR18: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR18_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR18: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR18_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR18: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR19  ------------------------------- */
#define PPB_NVIC_IPR19_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR19: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR19_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR19: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR19_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR19: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR19_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR19: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR19_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR19: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR19_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR19: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR19_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR19: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR19_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR19: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR20  ------------------------------- */
#define PPB_NVIC_IPR20_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR20: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR20_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR20: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR20_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR20: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR20_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR20: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR20_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR20: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR20_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR20: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR20_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR20: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR20_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR20: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR21  ------------------------------- */
#define PPB_NVIC_IPR21_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR21: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR21_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR21: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR21_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR21: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR21_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR21: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR21_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR21: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR21_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR21: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR21_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR21: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR21_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR21: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR22  ------------------------------- */
#define PPB_NVIC_IPR22_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR22: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR22_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR22: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR22_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR22: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR22_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR22: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR22_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR22: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR22_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR22: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR22_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR22: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR22_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR22: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR23  ------------------------------- */
#define PPB_NVIC_IPR23_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR23: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR23_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR23: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR23_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR23: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR23_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR23: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR23_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR23: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR23_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR23: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR23_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR23: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR23_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR23: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR24  ------------------------------- */
#define PPB_NVIC_IPR24_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR24: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR24_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR24: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR24_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR24: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR24_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR24: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR24_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR24: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR24_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR24: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR24_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR24: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR24_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR24: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR25  ------------------------------- */
#define PPB_NVIC_IPR25_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR25: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR25_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR25: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR25_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR25: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR25_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR25: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR25_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR25: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR25_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR25: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR25_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR25: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR25_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR25: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR26  ------------------------------- */
#define PPB_NVIC_IPR26_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR26: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR26_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR26: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR26_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR26: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR26_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR26: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR26_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR26: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR26_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR26: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR26_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR26: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR26_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR26: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR27  ------------------------------- */
#define PPB_NVIC_IPR27_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR27: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR27_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR27: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR27_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR27: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR27_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR27: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR27_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR27: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR27_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR27: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR27_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR27: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR27_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR27: PRI_3 (Bitfield-Mask: 0xff)                 */

/* ----------------------------------  PPB_CPUID  --------------------------------- */
#define PPB_CPUID_Revision_Pos                (0UL)                     /*!< PPB CPUID: Revision (Bit 0)                                 */
#define PPB_CPUID_Revision_Msk                (0xfUL)                   /*!< PPB CPUID: Revision (Bitfield-Mask: 0x0f)                   */
#define PPB_CPUID_PartNo_Pos                  (4UL)                     /*!< PPB CPUID: PartNo (Bit 4)                                   */
#define PPB_CPUID_PartNo_Msk                  (0xfff0UL)                /*!< PPB CPUID: PartNo (Bitfield-Mask: 0xfff)                    */
#define PPB_CPUID_Constant_Pos                (16UL)                    /*!< PPB CPUID: Constant (Bit 16)                                */
#define PPB_CPUID_Constant_Msk                (0xf0000UL)               /*!< PPB CPUID: Constant (Bitfield-Mask: 0x0f)                   */
#define PPB_CPUID_Variant_Pos                 (20UL)                    /*!< PPB CPUID: Variant (Bit 20)                                 */
#define PPB_CPUID_Variant_Msk                 (0xf00000UL)              /*!< PPB CPUID: Variant (Bitfield-Mask: 0x0f)                    */
#define PPB_CPUID_Implementer_Pos             (24UL)                    /*!< PPB CPUID: Implementer (Bit 24)                             */
#define PPB_CPUID_Implementer_Msk             (0xff000000UL)            /*!< PPB CPUID: Implementer (Bitfield-Mask: 0xff)                */

/* ----------------------------------  PPB_ICSR  ---------------------------------- */
#define PPB_ICSR_VECTACTIVE_Pos               (0UL)                     /*!< PPB ICSR: VECTACTIVE (Bit 0)                                */
#define PPB_ICSR_VECTACTIVE_Msk               (0x1ffUL)                 /*!< PPB ICSR: VECTACTIVE (Bitfield-Mask: 0x1ff)                 */
#define PPB_ICSR_RETTOBASE_Pos                (11UL)                    /*!< PPB ICSR: RETTOBASE (Bit 11)                                */
#define PPB_ICSR_RETTOBASE_Msk                (0x800UL)                 /*!< PPB ICSR: RETTOBASE (Bitfield-Mask: 0x01)                   */
#define PPB_ICSR_VECTPENDING_Pos              (12UL)                    /*!< PPB ICSR: VECTPENDING (Bit 12)                              */
#define PPB_ICSR_VECTPENDING_Msk              (0x3f000UL)               /*!< PPB ICSR: VECTPENDING (Bitfield-Mask: 0x3f)                 */
#define PPB_ICSR_ISRPENDING_Pos               (22UL)                    /*!< PPB ICSR: ISRPENDING (Bit 22)                               */
#define PPB_ICSR_ISRPENDING_Msk               (0x400000UL)              /*!< PPB ICSR: ISRPENDING (Bitfield-Mask: 0x01)                  */
#define PPB_ICSR_PENDSTCLR_Pos                (25UL)                    /*!< PPB ICSR: PENDSTCLR (Bit 25)                                */
#define PPB_ICSR_PENDSTCLR_Msk                (0x2000000UL)             /*!< PPB ICSR: PENDSTCLR (Bitfield-Mask: 0x01)                   */
#define PPB_ICSR_PENDSTSET_Pos                (26UL)                    /*!< PPB ICSR: PENDSTSET (Bit 26)                                */
#define PPB_ICSR_PENDSTSET_Msk                (0x4000000UL)             /*!< PPB ICSR: PENDSTSET (Bitfield-Mask: 0x01)                   */
#define PPB_ICSR_PENDSVCLR_Pos                (27UL)                    /*!< PPB ICSR: PENDSVCLR (Bit 27)                                */
#define PPB_ICSR_PENDSVCLR_Msk                (0x8000000UL)             /*!< PPB ICSR: PENDSVCLR (Bitfield-Mask: 0x01)                   */
#define PPB_ICSR_PENDSVSET_Pos                (28UL)                    /*!< PPB ICSR: PENDSVSET (Bit 28)                                */
#define PPB_ICSR_PENDSVSET_Msk                (0x10000000UL)            /*!< PPB ICSR: PENDSVSET (Bitfield-Mask: 0x01)                   */
#define PPB_ICSR_NMIPENDSET_Pos               (31UL)                    /*!< PPB ICSR: NMIPENDSET (Bit 31)                               */
#define PPB_ICSR_NMIPENDSET_Msk               (0x80000000UL)            /*!< PPB ICSR: NMIPENDSET (Bitfield-Mask: 0x01)                  */

/* ----------------------------------  PPB_VTOR  ---------------------------------- */
#define PPB_VTOR_TBLOFF_Pos                   (10UL)                    /*!< PPB VTOR: TBLOFF (Bit 10)                                   */
#define PPB_VTOR_TBLOFF_Msk                   (0xfffffc00UL)            /*!< PPB VTOR: TBLOFF (Bitfield-Mask: 0x3fffff)                  */

/* ----------------------------------  PPB_AIRCR  --------------------------------- */
#define PPB_AIRCR_VECTRESET_Pos               (0UL)                     /*!< PPB AIRCR: VECTRESET (Bit 0)                                */
#define PPB_AIRCR_VECTRESET_Msk               (0x1UL)                   /*!< PPB AIRCR: VECTRESET (Bitfield-Mask: 0x01)                  */
#define PPB_AIRCR_VECTCLRACTIVE_Pos           (1UL)                     /*!< PPB AIRCR: VECTCLRACTIVE (Bit 1)                            */
#define PPB_AIRCR_VECTCLRACTIVE_Msk           (0x2UL)                   /*!< PPB AIRCR: VECTCLRACTIVE (Bitfield-Mask: 0x01)              */
#define PPB_AIRCR_SYSRESETREQ_Pos             (2UL)                     /*!< PPB AIRCR: SYSRESETREQ (Bit 2)                              */
#define PPB_AIRCR_SYSRESETREQ_Msk             (0x4UL)                   /*!< PPB AIRCR: SYSRESETREQ (Bitfield-Mask: 0x01)                */
#define PPB_AIRCR_PRIGROUP_Pos                (8UL)                     /*!< PPB AIRCR: PRIGROUP (Bit 8)                                 */
#define PPB_AIRCR_PRIGROUP_Msk                (0x700UL)                 /*!< PPB AIRCR: PRIGROUP (Bitfield-Mask: 0x07)                   */
#define PPB_AIRCR_ENDIANNESS_Pos              (15UL)                    /*!< PPB AIRCR: ENDIANNESS (Bit 15)                              */
#define PPB_AIRCR_ENDIANNESS_Msk              (0x8000UL)                /*!< PPB AIRCR: ENDIANNESS (Bitfield-Mask: 0x01)                 */
#define PPB_AIRCR_VECTKEY_Pos                 (16UL)                    /*!< PPB AIRCR: VECTKEY (Bit 16)                                 */
#define PPB_AIRCR_VECTKEY_Msk                 (0xffff0000UL)            /*!< PPB AIRCR: VECTKEY (Bitfield-Mask: 0xffff)                  */

/* -----------------------------------  PPB_SCR  ---------------------------------- */
#define PPB_SCR_SLEEPONEXIT_Pos               (1UL)                     /*!< PPB SCR: SLEEPONEXIT (Bit 1)                                */
#define PPB_SCR_SLEEPONEXIT_Msk               (0x2UL)                   /*!< PPB SCR: SLEEPONEXIT (Bitfield-Mask: 0x01)                  */
#define PPB_SCR_SLEEPDEEP_Pos                 (2UL)                     /*!< PPB SCR: SLEEPDEEP (Bit 2)                                  */
#define PPB_SCR_SLEEPDEEP_Msk                 (0x4UL)                   /*!< PPB SCR: SLEEPDEEP (Bitfield-Mask: 0x01)                    */
#define PPB_SCR_SEVONPEND_Pos                 (4UL)                     /*!< PPB SCR: SEVONPEND (Bit 4)                                  */
#define PPB_SCR_SEVONPEND_Msk                 (0x10UL)                  /*!< PPB SCR: SEVONPEND (Bitfield-Mask: 0x01)                    */

/* -----------------------------------  PPB_CCR  ---------------------------------- */
#define PPB_CCR_NONBASETHRDENA_Pos            (0UL)                     /*!< PPB CCR: NONBASETHRDENA (Bit 0)                             */
#define PPB_CCR_NONBASETHRDENA_Msk            (0x1UL)                   /*!< PPB CCR: NONBASETHRDENA (Bitfield-Mask: 0x01)               */
#define PPB_CCR_USERSETMPEND_Pos              (1UL)                     /*!< PPB CCR: USERSETMPEND (Bit 1)                               */
#define PPB_CCR_USERSETMPEND_Msk              (0x2UL)                   /*!< PPB CCR: USERSETMPEND (Bitfield-Mask: 0x01)                 */
#define PPB_CCR_UNALIGN_TRP_Pos               (3UL)                     /*!< PPB CCR: UNALIGN_TRP (Bit 3)                                */
#define PPB_CCR_UNALIGN_TRP_Msk               (0x8UL)                   /*!< PPB CCR: UNALIGN_TRP (Bitfield-Mask: 0x01)                  */
#define PPB_CCR_DIV_0_TRP_Pos                 (4UL)                     /*!< PPB CCR: DIV_0_TRP (Bit 4)                                  */
#define PPB_CCR_DIV_0_TRP_Msk                 (0x10UL)                  /*!< PPB CCR: DIV_0_TRP (Bitfield-Mask: 0x01)                    */
#define PPB_CCR_BFHFNMIGN_Pos                 (8UL)                     /*!< PPB CCR: BFHFNMIGN (Bit 8)                                  */
#define PPB_CCR_BFHFNMIGN_Msk                 (0x100UL)                 /*!< PPB CCR: BFHFNMIGN (Bitfield-Mask: 0x01)                    */
#define PPB_CCR_STKALIGN_Pos                  (9UL)                     /*!< PPB CCR: STKALIGN (Bit 9)                                   */
#define PPB_CCR_STKALIGN_Msk                  (0x200UL)                 /*!< PPB CCR: STKALIGN (Bitfield-Mask: 0x01)                     */

/* ----------------------------------  PPB_SHPR1  --------------------------------- */
#define PPB_SHPR1_PRI_4_Pos                   (0UL)                     /*!< PPB SHPR1: PRI_4 (Bit 0)                                    */
#define PPB_SHPR1_PRI_4_Msk                   (0xffUL)                  /*!< PPB SHPR1: PRI_4 (Bitfield-Mask: 0xff)                      */
#define PPB_SHPR1_PRI_5_Pos                   (8UL)                     /*!< PPB SHPR1: PRI_5 (Bit 8)                                    */
#define PPB_SHPR1_PRI_5_Msk                   (0xff00UL)                /*!< PPB SHPR1: PRI_5 (Bitfield-Mask: 0xff)                      */
#define PPB_SHPR1_PRI_6_Pos                   (16UL)                    /*!< PPB SHPR1: PRI_6 (Bit 16)                                   */
#define PPB_SHPR1_PRI_6_Msk                   (0xff0000UL)              /*!< PPB SHPR1: PRI_6 (Bitfield-Mask: 0xff)                      */

/* ----------------------------------  PPB_SHPR2  --------------------------------- */
#define PPB_SHPR2_PRI_11_Pos                  (24UL)                    /*!< PPB SHPR2: PRI_11 (Bit 24)                                  */
#define PPB_SHPR2_PRI_11_Msk                  (0xff000000UL)            /*!< PPB SHPR2: PRI_11 (Bitfield-Mask: 0xff)                     */

/* ----------------------------------  PPB_SHPR3  --------------------------------- */
#define PPB_SHPR3_PRI_14_Pos                  (16UL)                    /*!< PPB SHPR3: PRI_14 (Bit 16)                                  */
#define PPB_SHPR3_PRI_14_Msk                  (0xff0000UL)              /*!< PPB SHPR3: PRI_14 (Bitfield-Mask: 0xff)                     */
#define PPB_SHPR3_PRI_15_Pos                  (24UL)                    /*!< PPB SHPR3: PRI_15 (Bit 24)                                  */
#define PPB_SHPR3_PRI_15_Msk                  (0xff000000UL)            /*!< PPB SHPR3: PRI_15 (Bitfield-Mask: 0xff)                     */

/* ----------------------------------  PPB_SHCSR  --------------------------------- */
#define PPB_SHCSR_MEMFAULTACT_Pos             (0UL)                     /*!< PPB SHCSR: MEMFAULTACT (Bit 0)                              */
#define PPB_SHCSR_MEMFAULTACT_Msk             (0x1UL)                   /*!< PPB SHCSR: MEMFAULTACT (Bitfield-Mask: 0x01)                */
#define PPB_SHCSR_BUSFAULTACT_Pos             (1UL)                     /*!< PPB SHCSR: BUSFAULTACT (Bit 1)                              */
#define PPB_SHCSR_BUSFAULTACT_Msk             (0x2UL)                   /*!< PPB SHCSR: BUSFAULTACT (Bitfield-Mask: 0x01)                */
#define PPB_SHCSR_USGFAULTACT_Pos             (3UL)                     /*!< PPB SHCSR: USGFAULTACT (Bit 3)                              */
#define PPB_SHCSR_USGFAULTACT_Msk             (0x8UL)                   /*!< PPB SHCSR: USGFAULTACT (Bitfield-Mask: 0x01)                */
#define PPB_SHCSR_SVCALLACT_Pos               (7UL)                     /*!< PPB SHCSR: SVCALLACT (Bit 7)                                */
#define PPB_SHCSR_SVCALLACT_Msk               (0x80UL)                  /*!< PPB SHCSR: SVCALLACT (Bitfield-Mask: 0x01)                  */
#define PPB_SHCSR_MONITORACT_Pos              (8UL)                     /*!< PPB SHCSR: MONITORACT (Bit 8)                               */
#define PPB_SHCSR_MONITORACT_Msk              (0x100UL)                 /*!< PPB SHCSR: MONITORACT (Bitfield-Mask: 0x01)                 */
#define PPB_SHCSR_PENDSVACT_Pos               (10UL)                    /*!< PPB SHCSR: PENDSVACT (Bit 10)                               */
#define PPB_SHCSR_PENDSVACT_Msk               (0x400UL)                 /*!< PPB SHCSR: PENDSVACT (Bitfield-Mask: 0x01)                  */
#define PPB_SHCSR_SYSTICKACT_Pos              (11UL)                    /*!< PPB SHCSR: SYSTICKACT (Bit 11)                              */
#define PPB_SHCSR_SYSTICKACT_Msk              (0x800UL)                 /*!< PPB SHCSR: SYSTICKACT (Bitfield-Mask: 0x01)                 */
#define PPB_SHCSR_USGFAULTPENDED_Pos          (12UL)                    /*!< PPB SHCSR: USGFAULTPENDED (Bit 12)                          */
#define PPB_SHCSR_USGFAULTPENDED_Msk          (0x1000UL)                /*!< PPB SHCSR: USGFAULTPENDED (Bitfield-Mask: 0x01)             */
#define PPB_SHCSR_MEMFAULTPENDED_Pos          (13UL)                    /*!< PPB SHCSR: MEMFAULTPENDED (Bit 13)                          */
#define PPB_SHCSR_MEMFAULTPENDED_Msk          (0x2000UL)                /*!< PPB SHCSR: MEMFAULTPENDED (Bitfield-Mask: 0x01)             */
#define PPB_SHCSR_BUSFAULTPENDED_Pos          (14UL)                    /*!< PPB SHCSR: BUSFAULTPENDED (Bit 14)                          */
#define PPB_SHCSR_BUSFAULTPENDED_Msk          (0x4000UL)                /*!< PPB SHCSR: BUSFAULTPENDED (Bitfield-Mask: 0x01)             */
#define PPB_SHCSR_SVCALLPENDED_Pos            (15UL)                    /*!< PPB SHCSR: SVCALLPENDED (Bit 15)                            */
#define PPB_SHCSR_SVCALLPENDED_Msk            (0x8000UL)                /*!< PPB SHCSR: SVCALLPENDED (Bitfield-Mask: 0x01)               */
#define PPB_SHCSR_MEMFAULTENA_Pos             (16UL)                    /*!< PPB SHCSR: MEMFAULTENA (Bit 16)                             */
#define PPB_SHCSR_MEMFAULTENA_Msk             (0x10000UL)               /*!< PPB SHCSR: MEMFAULTENA (Bitfield-Mask: 0x01)                */
#define PPB_SHCSR_BUSFAULTENA_Pos             (17UL)                    /*!< PPB SHCSR: BUSFAULTENA (Bit 17)                             */
#define PPB_SHCSR_BUSFAULTENA_Msk             (0x20000UL)               /*!< PPB SHCSR: BUSFAULTENA (Bitfield-Mask: 0x01)                */
#define PPB_SHCSR_USGFAULTENA_Pos             (18UL)                    /*!< PPB SHCSR: USGFAULTENA (Bit 18)                             */
#define PPB_SHCSR_USGFAULTENA_Msk             (0x40000UL)               /*!< PPB SHCSR: USGFAULTENA (Bitfield-Mask: 0x01)                */

/* ----------------------------------  PPB_CFSR  ---------------------------------- */
#define PPB_CFSR_IACCVIOL_Pos                 (0UL)                     /*!< PPB CFSR: IACCVIOL (Bit 0)                                  */
#define PPB_CFSR_IACCVIOL_Msk                 (0x1UL)                   /*!< PPB CFSR: IACCVIOL (Bitfield-Mask: 0x01)                    */
#define PPB_CFSR_DACCVIOL_Pos                 (1UL)                     /*!< PPB CFSR: DACCVIOL (Bit 1)                                  */
#define PPB_CFSR_DACCVIOL_Msk                 (0x2UL)                   /*!< PPB CFSR: DACCVIOL (Bitfield-Mask: 0x01)                    */
#define PPB_CFSR_MUNSTKERR_Pos                (3UL)                     /*!< PPB CFSR: MUNSTKERR (Bit 3)                                 */
#define PPB_CFSR_MUNSTKERR_Msk                (0x8UL)                   /*!< PPB CFSR: MUNSTKERR (Bitfield-Mask: 0x01)                   */
#define PPB_CFSR_MSTKERR_Pos                  (4UL)                     /*!< PPB CFSR: MSTKERR (Bit 4)                                   */
#define PPB_CFSR_MSTKERR_Msk                  (0x10UL)                  /*!< PPB CFSR: MSTKERR (Bitfield-Mask: 0x01)                     */
#define PPB_CFSR_MLSPERR_Pos                  (5UL)                     /*!< PPB CFSR: MLSPERR (Bit 5)                                   */
#define PPB_CFSR_MLSPERR_Msk                  (0x20UL)                  /*!< PPB CFSR: MLSPERR (Bitfield-Mask: 0x01)                     */
#define PPB_CFSR_MMARVALID_Pos                (7UL)                     /*!< PPB CFSR: MMARVALID (Bit 7)                                 */
#define PPB_CFSR_MMARVALID_Msk                (0x80UL)                  /*!< PPB CFSR: MMARVALID (Bitfield-Mask: 0x01)                   */
#define PPB_CFSR_IBUSERR_Pos                  (8UL)                     /*!< PPB CFSR: IBUSERR (Bit 8)                                   */
#define PPB_CFSR_IBUSERR_Msk                  (0x100UL)                 /*!< PPB CFSR: IBUSERR (Bitfield-Mask: 0x01)                     */
#define PPB_CFSR_PRECISERR_Pos                (9UL)                     /*!< PPB CFSR: PRECISERR (Bit 9)                                 */
#define PPB_CFSR_PRECISERR_Msk                (0x200UL)                 /*!< PPB CFSR: PRECISERR (Bitfield-Mask: 0x01)                   */
#define PPB_CFSR_IMPRECISERR_Pos              (10UL)                    /*!< PPB CFSR: IMPRECISERR (Bit 10)                              */
#define PPB_CFSR_IMPRECISERR_Msk              (0x400UL)                 /*!< PPB CFSR: IMPRECISERR (Bitfield-Mask: 0x01)                 */
#define PPB_CFSR_UNSTKERR_Pos                 (11UL)                    /*!< PPB CFSR: UNSTKERR (Bit 11)                                 */
#define PPB_CFSR_UNSTKERR_Msk                 (0x800UL)                 /*!< PPB CFSR: UNSTKERR (Bitfield-Mask: 0x01)                    */
#define PPB_CFSR_STKERR_Pos                   (12UL)                    /*!< PPB CFSR: STKERR (Bit 12)                                   */
#define PPB_CFSR_STKERR_Msk                   (0x1000UL)                /*!< PPB CFSR: STKERR (Bitfield-Mask: 0x01)                      */
#define PPB_CFSR_LSPERR_Pos                   (13UL)                    /*!< PPB CFSR: LSPERR (Bit 13)                                   */
#define PPB_CFSR_LSPERR_Msk                   (0x2000UL)                /*!< PPB CFSR: LSPERR (Bitfield-Mask: 0x01)                      */
#define PPB_CFSR_BFARVALID_Pos                (15UL)                    /*!< PPB CFSR: BFARVALID (Bit 15)                                */
#define PPB_CFSR_BFARVALID_Msk                (0x8000UL)                /*!< PPB CFSR: BFARVALID (Bitfield-Mask: 0x01)                   */
#define PPB_CFSR_UNDEFINSTR_Pos               (16UL)                    /*!< PPB CFSR: UNDEFINSTR (Bit 16)                               */
#define PPB_CFSR_UNDEFINSTR_Msk               (0x10000UL)               /*!< PPB CFSR: UNDEFINSTR (Bitfield-Mask: 0x01)                  */
#define PPB_CFSR_INVSTATE_Pos                 (17UL)                    /*!< PPB CFSR: INVSTATE (Bit 17)                                 */
#define PPB_CFSR_INVSTATE_Msk                 (0x20000UL)               /*!< PPB CFSR: INVSTATE (Bitfield-Mask: 0x01)                    */
#define PPB_CFSR_INVPC_Pos                    (18UL)                    /*!< PPB CFSR: INVPC (Bit 18)                                    */
#define PPB_CFSR_INVPC_Msk                    (0x40000UL)               /*!< PPB CFSR: INVPC (Bitfield-Mask: 0x01)                       */
#define PPB_CFSR_NOCP_Pos                     (19UL)                    /*!< PPB CFSR: NOCP (Bit 19)                                     */
#define PPB_CFSR_NOCP_Msk                     (0x80000UL)               /*!< PPB CFSR: NOCP (Bitfield-Mask: 0x01)                        */
#define PPB_CFSR_UNALIGNED_Pos                (24UL)                    /*!< PPB CFSR: UNALIGNED (Bit 24)                                */
#define PPB_CFSR_UNALIGNED_Msk                (0x1000000UL)             /*!< PPB CFSR: UNALIGNED (Bitfield-Mask: 0x01)                   */
#define PPB_CFSR_DIVBYZERO_Pos                (25UL)                    /*!< PPB CFSR: DIVBYZERO (Bit 25)                                */
#define PPB_CFSR_DIVBYZERO_Msk                (0x2000000UL)             /*!< PPB CFSR: DIVBYZERO (Bitfield-Mask: 0x01)                   */

/* ----------------------------------  PPB_HFSR  ---------------------------------- */
#define PPB_HFSR_VECTTBL_Pos                  (1UL)                     /*!< PPB HFSR: VECTTBL (Bit 1)                                   */
#define PPB_HFSR_VECTTBL_Msk                  (0x2UL)                   /*!< PPB HFSR: VECTTBL (Bitfield-Mask: 0x01)                     */
#define PPB_HFSR_FORCED_Pos                   (30UL)                    /*!< PPB HFSR: FORCED (Bit 30)                                   */
#define PPB_HFSR_FORCED_Msk                   (0x40000000UL)            /*!< PPB HFSR: FORCED (Bitfield-Mask: 0x01)                      */
#define PPB_HFSR_DEBUGEVT_Pos                 (31UL)                    /*!< PPB HFSR: DEBUGEVT (Bit 31)                                 */
#define PPB_HFSR_DEBUGEVT_Msk                 (0x80000000UL)            /*!< PPB HFSR: DEBUGEVT (Bitfield-Mask: 0x01)                    */

/* ----------------------------------  PPB_MMFAR  --------------------------------- */
#define PPB_MMFAR_ADDRESS_Pos                 (0UL)                     /*!< PPB MMFAR: ADDRESS (Bit 0)                                  */
#define PPB_MMFAR_ADDRESS_Msk                 (0xffffffffUL)            /*!< PPB MMFAR: ADDRESS (Bitfield-Mask: 0xffffffff)              */

/* ----------------------------------  PPB_BFAR  ---------------------------------- */
#define PPB_BFAR_ADDRESS_Pos                  (0UL)                     /*!< PPB BFAR: ADDRESS (Bit 0)                                   */
#define PPB_BFAR_ADDRESS_Msk                  (0xffffffffUL)            /*!< PPB BFAR: ADDRESS (Bitfield-Mask: 0xffffffff)               */

/* ----------------------------------  PPB_AFSR  ---------------------------------- */
#define PPB_AFSR_VALUE_Pos                    (0UL)                     /*!< PPB AFSR: VALUE (Bit 0)                                     */
#define PPB_AFSR_VALUE_Msk                    (0xffffffffUL)            /*!< PPB AFSR: VALUE (Bitfield-Mask: 0xffffffff)                 */

/* ----------------------------------  PPB_CPACR  --------------------------------- */
#define PPB_CPACR_CP10_Pos                    (20UL)                    /*!< PPB CPACR: CP10 (Bit 20)                                    */
#define PPB_CPACR_CP10_Msk                    (0x300000UL)              /*!< PPB CPACR: CP10 (Bitfield-Mask: 0x03)                       */
#define PPB_CPACR_CP11_Pos                    (22UL)                    /*!< PPB CPACR: CP11 (Bit 22)                                    */
#define PPB_CPACR_CP11_Msk                    (0xc00000UL)              /*!< PPB CPACR: CP11 (Bitfield-Mask: 0x03)                       */

/* --------------------------------  PPB_MPU_TYPE  -------------------------------- */
#define PPB_MPU_TYPE_SEPARATE_Pos             (0UL)                     /*!< PPB MPU_TYPE: SEPARATE (Bit 0)                              */
#define PPB_MPU_TYPE_SEPARATE_Msk             (0x1UL)                   /*!< PPB MPU_TYPE: SEPARATE (Bitfield-Mask: 0x01)                */
#define PPB_MPU_TYPE_DREGION_Pos              (8UL)                     /*!< PPB MPU_TYPE: DREGION (Bit 8)                               */
#define PPB_MPU_TYPE_DREGION_Msk              (0xff00UL)                /*!< PPB MPU_TYPE: DREGION (Bitfield-Mask: 0xff)                 */
#define PPB_MPU_TYPE_IREGION_Pos              (16UL)                    /*!< PPB MPU_TYPE: IREGION (Bit 16)                              */
#define PPB_MPU_TYPE_IREGION_Msk              (0xff0000UL)              /*!< PPB MPU_TYPE: IREGION (Bitfield-Mask: 0xff)                 */

/* --------------------------------  PPB_MPU_CTRL  -------------------------------- */
#define PPB_MPU_CTRL_ENABLE_Pos               (0UL)                     /*!< PPB MPU_CTRL: ENABLE (Bit 0)                                */
#define PPB_MPU_CTRL_ENABLE_Msk               (0x1UL)                   /*!< PPB MPU_CTRL: ENABLE (Bitfield-Mask: 0x01)                  */
#define PPB_MPU_CTRL_HFNMIENA_Pos             (1UL)                     /*!< PPB MPU_CTRL: HFNMIENA (Bit 1)                              */
#define PPB_MPU_CTRL_HFNMIENA_Msk             (0x2UL)                   /*!< PPB MPU_CTRL: HFNMIENA (Bitfield-Mask: 0x01)                */
#define PPB_MPU_CTRL_PRIVDEFENA_Pos           (2UL)                     /*!< PPB MPU_CTRL: PRIVDEFENA (Bit 2)                            */
#define PPB_MPU_CTRL_PRIVDEFENA_Msk           (0x4UL)                   /*!< PPB MPU_CTRL: PRIVDEFENA (Bitfield-Mask: 0x01)              */

/* ---------------------------------  PPB_MPU_RNR  -------------------------------- */
#define PPB_MPU_RNR_REGION_Pos                (0UL)                     /*!< PPB MPU_RNR: REGION (Bit 0)                                 */
#define PPB_MPU_RNR_REGION_Msk                (0xffUL)                  /*!< PPB MPU_RNR: REGION (Bitfield-Mask: 0xff)                   */

/* --------------------------------  PPB_MPU_RBAR  -------------------------------- */
#define PPB_MPU_RBAR_REGION_Pos               (0UL)                     /*!< PPB MPU_RBAR: REGION (Bit 0)                                */
#define PPB_MPU_RBAR_REGION_Msk               (0xfUL)                   /*!< PPB MPU_RBAR: REGION (Bitfield-Mask: 0x0f)                  */
#define PPB_MPU_RBAR_VALID_Pos                (4UL)                     /*!< PPB MPU_RBAR: VALID (Bit 4)                                 */
#define PPB_MPU_RBAR_VALID_Msk                (0x10UL)                  /*!< PPB MPU_RBAR: VALID (Bitfield-Mask: 0x01)                   */
#define PPB_MPU_RBAR_ADDR_Pos                 (9UL)                     /*!< PPB MPU_RBAR: ADDR (Bit 9)                                  */
#define PPB_MPU_RBAR_ADDR_Msk                 (0xfffffe00UL)            /*!< PPB MPU_RBAR: ADDR (Bitfield-Mask: 0x7fffff)                */

/* --------------------------------  PPB_MPU_RASR  -------------------------------- */
#define PPB_MPU_RASR_ENABLE_Pos               (0UL)                     /*!< PPB MPU_RASR: ENABLE (Bit 0)                                */
#define PPB_MPU_RASR_ENABLE_Msk               (0x1UL)                   /*!< PPB MPU_RASR: ENABLE (Bitfield-Mask: 0x01)                  */
#define PPB_MPU_RASR_SIZE_Pos                 (1UL)                     /*!< PPB MPU_RASR: SIZE (Bit 1)                                  */
#define PPB_MPU_RASR_SIZE_Msk                 (0x3eUL)                  /*!< PPB MPU_RASR: SIZE (Bitfield-Mask: 0x1f)                    */
#define PPB_MPU_RASR_SRD_Pos                  (8UL)                     /*!< PPB MPU_RASR: SRD (Bit 8)                                   */
#define PPB_MPU_RASR_SRD_Msk                  (0xff00UL)                /*!< PPB MPU_RASR: SRD (Bitfield-Mask: 0xff)                     */
#define PPB_MPU_RASR_B_Pos                    (16UL)                    /*!< PPB MPU_RASR: B (Bit 16)                                    */
#define PPB_MPU_RASR_B_Msk                    (0x10000UL)               /*!< PPB MPU_RASR: B (Bitfield-Mask: 0x01)                       */
#define PPB_MPU_RASR_C_Pos                    (17UL)                    /*!< PPB MPU_RASR: C (Bit 17)                                    */
#define PPB_MPU_RASR_C_Msk                    (0x20000UL)               /*!< PPB MPU_RASR: C (Bitfield-Mask: 0x01)                       */
#define PPB_MPU_RASR_S_Pos                    (18UL)                    /*!< PPB MPU_RASR: S (Bit 18)                                    */
#define PPB_MPU_RASR_S_Msk                    (0x40000UL)               /*!< PPB MPU_RASR: S (Bitfield-Mask: 0x01)                       */
#define PPB_MPU_RASR_TEX_Pos                  (19UL)                    /*!< PPB MPU_RASR: TEX (Bit 19)                                  */
#define PPB_MPU_RASR_TEX_Msk                  (0x380000UL)              /*!< PPB MPU_RASR: TEX (Bitfield-Mask: 0x07)                     */
#define PPB_MPU_RASR_AP_Pos                   (24UL)                    /*!< PPB MPU_RASR: AP (Bit 24)                                   */
#define PPB_MPU_RASR_AP_Msk                   (0x7000000UL)             /*!< PPB MPU_RASR: AP (Bitfield-Mask: 0x07)                      */
#define PPB_MPU_RASR_XN_Pos                   (28UL)                    /*!< PPB MPU_RASR: XN (Bit 28)                                   */
#define PPB_MPU_RASR_XN_Msk                   (0x10000000UL)            /*!< PPB MPU_RASR: XN (Bitfield-Mask: 0x01)                      */

/* -------------------------------  PPB_MPU_RBAR_A1  ------------------------------ */
#define PPB_MPU_RBAR_A1_REGION_Pos            (0UL)                     /*!< PPB MPU_RBAR_A1: REGION (Bit 0)                             */
#define PPB_MPU_RBAR_A1_REGION_Msk            (0xfUL)                   /*!< PPB MPU_RBAR_A1: REGION (Bitfield-Mask: 0x0f)               */
#define PPB_MPU_RBAR_A1_VALID_Pos             (4UL)                     /*!< PPB MPU_RBAR_A1: VALID (Bit 4)                              */
#define PPB_MPU_RBAR_A1_VALID_Msk             (0x10UL)                  /*!< PPB MPU_RBAR_A1: VALID (Bitfield-Mask: 0x01)                */
#define PPB_MPU_RBAR_A1_ADDR_Pos              (9UL)                     /*!< PPB MPU_RBAR_A1: ADDR (Bit 9)                               */
#define PPB_MPU_RBAR_A1_ADDR_Msk              (0xfffffe00UL)            /*!< PPB MPU_RBAR_A1: ADDR (Bitfield-Mask: 0x7fffff)             */

/* -------------------------------  PPB_MPU_RASR_A1  ------------------------------ */
#define PPB_MPU_RASR_A1_ENABLE_Pos            (0UL)                     /*!< PPB MPU_RASR_A1: ENABLE (Bit 0)                             */
#define PPB_MPU_RASR_A1_ENABLE_Msk            (0x1UL)                   /*!< PPB MPU_RASR_A1: ENABLE (Bitfield-Mask: 0x01)               */
#define PPB_MPU_RASR_A1_SIZE_Pos              (1UL)                     /*!< PPB MPU_RASR_A1: SIZE (Bit 1)                               */
#define PPB_MPU_RASR_A1_SIZE_Msk              (0x3eUL)                  /*!< PPB MPU_RASR_A1: SIZE (Bitfield-Mask: 0x1f)                 */
#define PPB_MPU_RASR_A1_SRD_Pos               (8UL)                     /*!< PPB MPU_RASR_A1: SRD (Bit 8)                                */
#define PPB_MPU_RASR_A1_SRD_Msk               (0xff00UL)                /*!< PPB MPU_RASR_A1: SRD (Bitfield-Mask: 0xff)                  */
#define PPB_MPU_RASR_A1_B_Pos                 (16UL)                    /*!< PPB MPU_RASR_A1: B (Bit 16)                                 */
#define PPB_MPU_RASR_A1_B_Msk                 (0x10000UL)               /*!< PPB MPU_RASR_A1: B (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A1_C_Pos                 (17UL)                    /*!< PPB MPU_RASR_A1: C (Bit 17)                                 */
#define PPB_MPU_RASR_A1_C_Msk                 (0x20000UL)               /*!< PPB MPU_RASR_A1: C (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A1_S_Pos                 (18UL)                    /*!< PPB MPU_RASR_A1: S (Bit 18)                                 */
#define PPB_MPU_RASR_A1_S_Msk                 (0x40000UL)               /*!< PPB MPU_RASR_A1: S (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A1_TEX_Pos               (19UL)                    /*!< PPB MPU_RASR_A1: TEX (Bit 19)                               */
#define PPB_MPU_RASR_A1_TEX_Msk               (0x380000UL)              /*!< PPB MPU_RASR_A1: TEX (Bitfield-Mask: 0x07)                  */
#define PPB_MPU_RASR_A1_AP_Pos                (24UL)                    /*!< PPB MPU_RASR_A1: AP (Bit 24)                                */
#define PPB_MPU_RASR_A1_AP_Msk                (0x7000000UL)             /*!< PPB MPU_RASR_A1: AP (Bitfield-Mask: 0x07)                   */
#define PPB_MPU_RASR_A1_XN_Pos                (28UL)                    /*!< PPB MPU_RASR_A1: XN (Bit 28)                                */
#define PPB_MPU_RASR_A1_XN_Msk                (0x10000000UL)            /*!< PPB MPU_RASR_A1: XN (Bitfield-Mask: 0x01)                   */

/* -------------------------------  PPB_MPU_RBAR_A2  ------------------------------ */
#define PPB_MPU_RBAR_A2_REGION_Pos            (0UL)                     /*!< PPB MPU_RBAR_A2: REGION (Bit 0)                             */
#define PPB_MPU_RBAR_A2_REGION_Msk            (0xfUL)                   /*!< PPB MPU_RBAR_A2: REGION (Bitfield-Mask: 0x0f)               */
#define PPB_MPU_RBAR_A2_VALID_Pos             (4UL)                     /*!< PPB MPU_RBAR_A2: VALID (Bit 4)                              */
#define PPB_MPU_RBAR_A2_VALID_Msk             (0x10UL)                  /*!< PPB MPU_RBAR_A2: VALID (Bitfield-Mask: 0x01)                */
#define PPB_MPU_RBAR_A2_ADDR_Pos              (9UL)                     /*!< PPB MPU_RBAR_A2: ADDR (Bit 9)                               */
#define PPB_MPU_RBAR_A2_ADDR_Msk              (0xfffffe00UL)            /*!< PPB MPU_RBAR_A2: ADDR (Bitfield-Mask: 0x7fffff)             */

/* -------------------------------  PPB_MPU_RASR_A2  ------------------------------ */
#define PPB_MPU_RASR_A2_ENABLE_Pos            (0UL)                     /*!< PPB MPU_RASR_A2: ENABLE (Bit 0)                             */
#define PPB_MPU_RASR_A2_ENABLE_Msk            (0x1UL)                   /*!< PPB MPU_RASR_A2: ENABLE (Bitfield-Mask: 0x01)               */
#define PPB_MPU_RASR_A2_SIZE_Pos              (1UL)                     /*!< PPB MPU_RASR_A2: SIZE (Bit 1)                               */
#define PPB_MPU_RASR_A2_SIZE_Msk              (0x3eUL)                  /*!< PPB MPU_RASR_A2: SIZE (Bitfield-Mask: 0x1f)                 */
#define PPB_MPU_RASR_A2_SRD_Pos               (8UL)                     /*!< PPB MPU_RASR_A2: SRD (Bit 8)                                */
#define PPB_MPU_RASR_A2_SRD_Msk               (0xff00UL)                /*!< PPB MPU_RASR_A2: SRD (Bitfield-Mask: 0xff)                  */
#define PPB_MPU_RASR_A2_B_Pos                 (16UL)                    /*!< PPB MPU_RASR_A2: B (Bit 16)                                 */
#define PPB_MPU_RASR_A2_B_Msk                 (0x10000UL)               /*!< PPB MPU_RASR_A2: B (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A2_C_Pos                 (17UL)                    /*!< PPB MPU_RASR_A2: C (Bit 17)                                 */
#define PPB_MPU_RASR_A2_C_Msk                 (0x20000UL)               /*!< PPB MPU_RASR_A2: C (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A2_S_Pos                 (18UL)                    /*!< PPB MPU_RASR_A2: S (Bit 18)                                 */
#define PPB_MPU_RASR_A2_S_Msk                 (0x40000UL)               /*!< PPB MPU_RASR_A2: S (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A2_TEX_Pos               (19UL)                    /*!< PPB MPU_RASR_A2: TEX (Bit 19)                               */
#define PPB_MPU_RASR_A2_TEX_Msk               (0x380000UL)              /*!< PPB MPU_RASR_A2: TEX (Bitfield-Mask: 0x07)                  */
#define PPB_MPU_RASR_A2_AP_Pos                (24UL)                    /*!< PPB MPU_RASR_A2: AP (Bit 24)                                */
#define PPB_MPU_RASR_A2_AP_Msk                (0x7000000UL)             /*!< PPB MPU_RASR_A2: AP (Bitfield-Mask: 0x07)                   */
#define PPB_MPU_RASR_A2_XN_Pos                (28UL)                    /*!< PPB MPU_RASR_A2: XN (Bit 28)                                */
#define PPB_MPU_RASR_A2_XN_Msk                (0x10000000UL)            /*!< PPB MPU_RASR_A2: XN (Bitfield-Mask: 0x01)                   */

/* -------------------------------  PPB_MPU_RBAR_A3  ------------------------------ */
#define PPB_MPU_RBAR_A3_REGION_Pos            (0UL)                     /*!< PPB MPU_RBAR_A3: REGION (Bit 0)                             */
#define PPB_MPU_RBAR_A3_REGION_Msk            (0xfUL)                   /*!< PPB MPU_RBAR_A3: REGION (Bitfield-Mask: 0x0f)               */
#define PPB_MPU_RBAR_A3_VALID_Pos             (4UL)                     /*!< PPB MPU_RBAR_A3: VALID (Bit 4)                              */
#define PPB_MPU_RBAR_A3_VALID_Msk             (0x10UL)                  /*!< PPB MPU_RBAR_A3: VALID (Bitfield-Mask: 0x01)                */
#define PPB_MPU_RBAR_A3_ADDR_Pos              (9UL)                     /*!< PPB MPU_RBAR_A3: ADDR (Bit 9)                               */
#define PPB_MPU_RBAR_A3_ADDR_Msk              (0xfffffe00UL)            /*!< PPB MPU_RBAR_A3: ADDR (Bitfield-Mask: 0x7fffff)             */

/* -------------------------------  PPB_MPU_RASR_A3  ------------------------------ */
#define PPB_MPU_RASR_A3_ENABLE_Pos            (0UL)                     /*!< PPB MPU_RASR_A3: ENABLE (Bit 0)                             */
#define PPB_MPU_RASR_A3_ENABLE_Msk            (0x1UL)                   /*!< PPB MPU_RASR_A3: ENABLE (Bitfield-Mask: 0x01)               */
#define PPB_MPU_RASR_A3_SIZE_Pos              (1UL)                     /*!< PPB MPU_RASR_A3: SIZE (Bit 1)                               */
#define PPB_MPU_RASR_A3_SIZE_Msk              (0x3eUL)                  /*!< PPB MPU_RASR_A3: SIZE (Bitfield-Mask: 0x1f)                 */
#define PPB_MPU_RASR_A3_SRD_Pos               (8UL)                     /*!< PPB MPU_RASR_A3: SRD (Bit 8)                                */
#define PPB_MPU_RASR_A3_SRD_Msk               (0xff00UL)                /*!< PPB MPU_RASR_A3: SRD (Bitfield-Mask: 0xff)                  */
#define PPB_MPU_RASR_A3_B_Pos                 (16UL)                    /*!< PPB MPU_RASR_A3: B (Bit 16)                                 */
#define PPB_MPU_RASR_A3_B_Msk                 (0x10000UL)               /*!< PPB MPU_RASR_A3: B (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A3_C_Pos                 (17UL)                    /*!< PPB MPU_RASR_A3: C (Bit 17)                                 */
#define PPB_MPU_RASR_A3_C_Msk                 (0x20000UL)               /*!< PPB MPU_RASR_A3: C (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A3_S_Pos                 (18UL)                    /*!< PPB MPU_RASR_A3: S (Bit 18)                                 */
#define PPB_MPU_RASR_A3_S_Msk                 (0x40000UL)               /*!< PPB MPU_RASR_A3: S (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A3_TEX_Pos               (19UL)                    /*!< PPB MPU_RASR_A3: TEX (Bit 19)                               */
#define PPB_MPU_RASR_A3_TEX_Msk               (0x380000UL)              /*!< PPB MPU_RASR_A3: TEX (Bitfield-Mask: 0x07)                  */
#define PPB_MPU_RASR_A3_AP_Pos                (24UL)                    /*!< PPB MPU_RASR_A3: AP (Bit 24)                                */
#define PPB_MPU_RASR_A3_AP_Msk                (0x7000000UL)             /*!< PPB MPU_RASR_A3: AP (Bitfield-Mask: 0x07)                   */
#define PPB_MPU_RASR_A3_XN_Pos                (28UL)                    /*!< PPB MPU_RASR_A3: XN (Bit 28)                                */
#define PPB_MPU_RASR_A3_XN_Msk                (0x10000000UL)            /*!< PPB MPU_RASR_A3: XN (Bitfield-Mask: 0x01)                   */

/* ----------------------------------  PPB_STIR  ---------------------------------- */
#define PPB_STIR_INTID_Pos                    (0UL)                     /*!< PPB STIR: INTID (Bit 0)                                     */
#define PPB_STIR_INTID_Msk                    (0x1ffUL)                 /*!< PPB STIR: INTID (Bitfield-Mask: 0x1ff)                      */

/* ----------------------------------  PPB_FPCCR  --------------------------------- */
#define PPB_FPCCR_LSPACT_Pos                  (0UL)                     /*!< PPB FPCCR: LSPACT (Bit 0)                                   */
#define PPB_FPCCR_LSPACT_Msk                  (0x1UL)                   /*!< PPB FPCCR: LSPACT (Bitfield-Mask: 0x01)                     */
#define PPB_FPCCR_USER_Pos                    (1UL)                     /*!< PPB FPCCR: USER (Bit 1)                                     */
#define PPB_FPCCR_USER_Msk                    (0x2UL)                   /*!< PPB FPCCR: USER (Bitfield-Mask: 0x01)                       */
#define PPB_FPCCR_THREAD_Pos                  (3UL)                     /*!< PPB FPCCR: THREAD (Bit 3)                                   */
#define PPB_FPCCR_THREAD_Msk                  (0x8UL)                   /*!< PPB FPCCR: THREAD (Bitfield-Mask: 0x01)                     */
#define PPB_FPCCR_HFRDY_Pos                   (4UL)                     /*!< PPB FPCCR: HFRDY (Bit 4)                                    */
#define PPB_FPCCR_HFRDY_Msk                   (0x10UL)                  /*!< PPB FPCCR: HFRDY (Bitfield-Mask: 0x01)                      */
#define PPB_FPCCR_MMRDY_Pos                   (5UL)                     /*!< PPB FPCCR: MMRDY (Bit 5)                                    */
#define PPB_FPCCR_MMRDY_Msk                   (0x20UL)                  /*!< PPB FPCCR: MMRDY (Bitfield-Mask: 0x01)                      */
#define PPB_FPCCR_BFRDY_Pos                   (6UL)                     /*!< PPB FPCCR: BFRDY (Bit 6)                                    */
#define PPB_FPCCR_BFRDY_Msk                   (0x40UL)                  /*!< PPB FPCCR: BFRDY (Bitfield-Mask: 0x01)                      */
#define PPB_FPCCR_MONRDY_Pos                  (8UL)                     /*!< PPB FPCCR: MONRDY (Bit 8)                                   */
#define PPB_FPCCR_MONRDY_Msk                  (0x100UL)                 /*!< PPB FPCCR: MONRDY (Bitfield-Mask: 0x01)                     */
#define PPB_FPCCR_LSPEN_Pos                   (30UL)                    /*!< PPB FPCCR: LSPEN (Bit 30)                                   */
#define PPB_FPCCR_LSPEN_Msk                   (0x40000000UL)            /*!< PPB FPCCR: LSPEN (Bitfield-Mask: 0x01)                      */
#define PPB_FPCCR_ASPEN_Pos                   (31UL)                    /*!< PPB FPCCR: ASPEN (Bit 31)                                   */
#define PPB_FPCCR_ASPEN_Msk                   (0x80000000UL)            /*!< PPB FPCCR: ASPEN (Bitfield-Mask: 0x01)                      */

/* ----------------------------------  PPB_FPCAR  --------------------------------- */
#define PPB_FPCAR_ADDRESS_Pos                 (3UL)                     /*!< PPB FPCAR: ADDRESS (Bit 3)                                  */
#define PPB_FPCAR_ADDRESS_Msk                 (0xfffffff8UL)            /*!< PPB FPCAR: ADDRESS (Bitfield-Mask: 0x1fffffff)              */

/* ---------------------------------  PPB_FPDSCR  --------------------------------- */
#define PPB_FPDSCR_RMode_Pos                  (22UL)                    /*!< PPB FPDSCR: RMode (Bit 22)                                  */
#define PPB_FPDSCR_RMode_Msk                  (0xc00000UL)              /*!< PPB FPDSCR: RMode (Bitfield-Mask: 0x03)                     */
#define PPB_FPDSCR_FZ_Pos                     (24UL)                    /*!< PPB FPDSCR: FZ (Bit 24)                                     */
#define PPB_FPDSCR_FZ_Msk                     (0x1000000UL)             /*!< PPB FPDSCR: FZ (Bitfield-Mask: 0x01)                        */
#define PPB_FPDSCR_DN_Pos                     (25UL)                    /*!< PPB FPDSCR: DN (Bit 25)                                     */
#define PPB_FPDSCR_DN_Msk                     (0x2000000UL)             /*!< PPB FPDSCR: DN (Bitfield-Mask: 0x01)                        */
#define PPB_FPDSCR_AHP_Pos                    (26UL)                    /*!< PPB FPDSCR: AHP (Bit 26)                                    */
#define PPB_FPDSCR_AHP_Msk                    (0x4000000UL)             /*!< PPB FPDSCR: AHP (Bitfield-Mask: 0x01)                       */


/* ================================================================================ */
/* ================          struct 'DLR' Position & Mask          ================ */
/* ================================================================================ */


/* ---------------------------------  DLR_OVRSTAT  -------------------------------- */
#define DLR_OVRSTAT_LN0_Pos                   (0UL)                     /*!< DLR OVRSTAT: LN0 (Bit 0)                                    */
#define DLR_OVRSTAT_LN0_Msk                   (0x1UL)                   /*!< DLR OVRSTAT: LN0 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN1_Pos                   (1UL)                     /*!< DLR OVRSTAT: LN1 (Bit 1)                                    */
#define DLR_OVRSTAT_LN1_Msk                   (0x2UL)                   /*!< DLR OVRSTAT: LN1 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN2_Pos                   (2UL)                     /*!< DLR OVRSTAT: LN2 (Bit 2)                                    */
#define DLR_OVRSTAT_LN2_Msk                   (0x4UL)                   /*!< DLR OVRSTAT: LN2 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN3_Pos                   (3UL)                     /*!< DLR OVRSTAT: LN3 (Bit 3)                                    */
#define DLR_OVRSTAT_LN3_Msk                   (0x8UL)                   /*!< DLR OVRSTAT: LN3 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN4_Pos                   (4UL)                     /*!< DLR OVRSTAT: LN4 (Bit 4)                                    */
#define DLR_OVRSTAT_LN4_Msk                   (0x10UL)                  /*!< DLR OVRSTAT: LN4 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN5_Pos                   (5UL)                     /*!< DLR OVRSTAT: LN5 (Bit 5)                                    */
#define DLR_OVRSTAT_LN5_Msk                   (0x20UL)                  /*!< DLR OVRSTAT: LN5 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN6_Pos                   (6UL)                     /*!< DLR OVRSTAT: LN6 (Bit 6)                                    */
#define DLR_OVRSTAT_LN6_Msk                   (0x40UL)                  /*!< DLR OVRSTAT: LN6 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN7_Pos                   (7UL)                     /*!< DLR OVRSTAT: LN7 (Bit 7)                                    */
#define DLR_OVRSTAT_LN7_Msk                   (0x80UL)                  /*!< DLR OVRSTAT: LN7 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN8_Pos                   (8UL)                     /*!< DLR OVRSTAT: LN8 (Bit 8)                                    */
#define DLR_OVRSTAT_LN8_Msk                   (0x100UL)                 /*!< DLR OVRSTAT: LN8 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN9_Pos                   (9UL)                     /*!< DLR OVRSTAT: LN9 (Bit 9)                                    */
#define DLR_OVRSTAT_LN9_Msk                   (0x200UL)                 /*!< DLR OVRSTAT: LN9 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN10_Pos                  (10UL)                    /*!< DLR OVRSTAT: LN10 (Bit 10)                                  */
#define DLR_OVRSTAT_LN10_Msk                  (0x400UL)                 /*!< DLR OVRSTAT: LN10 (Bitfield-Mask: 0x01)                     */
#define DLR_OVRSTAT_LN11_Pos                  (11UL)                    /*!< DLR OVRSTAT: LN11 (Bit 11)                                  */
#define DLR_OVRSTAT_LN11_Msk                  (0x800UL)                 /*!< DLR OVRSTAT: LN11 (Bitfield-Mask: 0x01)                     */

/* ---------------------------------  DLR_OVRCLR  --------------------------------- */
#define DLR_OVRCLR_LN0_Pos                    (0UL)                     /*!< DLR OVRCLR: LN0 (Bit 0)                                     */
#define DLR_OVRCLR_LN0_Msk                    (0x1UL)                   /*!< DLR OVRCLR: LN0 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN1_Pos                    (1UL)                     /*!< DLR OVRCLR: LN1 (Bit 1)                                     */
#define DLR_OVRCLR_LN1_Msk                    (0x2UL)                   /*!< DLR OVRCLR: LN1 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN2_Pos                    (2UL)                     /*!< DLR OVRCLR: LN2 (Bit 2)                                     */
#define DLR_OVRCLR_LN2_Msk                    (0x4UL)                   /*!< DLR OVRCLR: LN2 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN3_Pos                    (3UL)                     /*!< DLR OVRCLR: LN3 (Bit 3)                                     */
#define DLR_OVRCLR_LN3_Msk                    (0x8UL)                   /*!< DLR OVRCLR: LN3 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN4_Pos                    (4UL)                     /*!< DLR OVRCLR: LN4 (Bit 4)                                     */
#define DLR_OVRCLR_LN4_Msk                    (0x10UL)                  /*!< DLR OVRCLR: LN4 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN5_Pos                    (5UL)                     /*!< DLR OVRCLR: LN5 (Bit 5)                                     */
#define DLR_OVRCLR_LN5_Msk                    (0x20UL)                  /*!< DLR OVRCLR: LN5 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN6_Pos                    (6UL)                     /*!< DLR OVRCLR: LN6 (Bit 6)                                     */
#define DLR_OVRCLR_LN6_Msk                    (0x40UL)                  /*!< DLR OVRCLR: LN6 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN7_Pos                    (7UL)                     /*!< DLR OVRCLR: LN7 (Bit 7)                                     */
#define DLR_OVRCLR_LN7_Msk                    (0x80UL)                  /*!< DLR OVRCLR: LN7 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN8_Pos                    (8UL)                     /*!< DLR OVRCLR: LN8 (Bit 8)                                     */
#define DLR_OVRCLR_LN8_Msk                    (0x100UL)                 /*!< DLR OVRCLR: LN8 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN9_Pos                    (9UL)                     /*!< DLR OVRCLR: LN9 (Bit 9)                                     */
#define DLR_OVRCLR_LN9_Msk                    (0x200UL)                 /*!< DLR OVRCLR: LN9 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN10_Pos                   (10UL)                    /*!< DLR OVRCLR: LN10 (Bit 10)                                   */
#define DLR_OVRCLR_LN10_Msk                   (0x400UL)                 /*!< DLR OVRCLR: LN10 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRCLR_LN11_Pos                   (11UL)                    /*!< DLR OVRCLR: LN11 (Bit 11)                                   */
#define DLR_OVRCLR_LN11_Msk                   (0x800UL)                 /*!< DLR OVRCLR: LN11 (Bitfield-Mask: 0x01)                      */

/* ---------------------------------  DLR_SRSEL0  --------------------------------- */
#define DLR_SRSEL0_RS0_Pos                    (0UL)                     /*!< DLR SRSEL0: RS0 (Bit 0)                                     */
#define DLR_SRSEL0_RS0_Msk                    (0xfUL)                   /*!< DLR SRSEL0: RS0 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL0_RS1_Pos                    (4UL)                     /*!< DLR SRSEL0: RS1 (Bit 4)                                     */
#define DLR_SRSEL0_RS1_Msk                    (0xf0UL)                  /*!< DLR SRSEL0: RS1 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL0_RS2_Pos                    (8UL)                     /*!< DLR SRSEL0: RS2 (Bit 8)                                     */
#define DLR_SRSEL0_RS2_Msk                    (0xf00UL)                 /*!< DLR SRSEL0: RS2 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL0_RS3_Pos                    (12UL)                    /*!< DLR SRSEL0: RS3 (Bit 12)                                    */
#define DLR_SRSEL0_RS3_Msk                    (0xf000UL)                /*!< DLR SRSEL0: RS3 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL0_RS4_Pos                    (16UL)                    /*!< DLR SRSEL0: RS4 (Bit 16)                                    */
#define DLR_SRSEL0_RS4_Msk                    (0xf0000UL)               /*!< DLR SRSEL0: RS4 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL0_RS5_Pos                    (20UL)                    /*!< DLR SRSEL0: RS5 (Bit 20)                                    */
#define DLR_SRSEL0_RS5_Msk                    (0xf00000UL)              /*!< DLR SRSEL0: RS5 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL0_RS6_Pos                    (24UL)                    /*!< DLR SRSEL0: RS6 (Bit 24)                                    */
#define DLR_SRSEL0_RS6_Msk                    (0xf000000UL)             /*!< DLR SRSEL0: RS6 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL0_RS7_Pos                    (28UL)                    /*!< DLR SRSEL0: RS7 (Bit 28)                                    */
#define DLR_SRSEL0_RS7_Msk                    (0xf0000000UL)            /*!< DLR SRSEL0: RS7 (Bitfield-Mask: 0x0f)                       */

/* ---------------------------------  DLR_SRSEL1  --------------------------------- */
#define DLR_SRSEL1_RS8_Pos                    (0UL)                     /*!< DLR SRSEL1: RS8 (Bit 0)                                     */
#define DLR_SRSEL1_RS8_Msk                    (0xfUL)                   /*!< DLR SRSEL1: RS8 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL1_RS9_Pos                    (4UL)                     /*!< DLR SRSEL1: RS9 (Bit 4)                                     */
#define DLR_SRSEL1_RS9_Msk                    (0xf0UL)                  /*!< DLR SRSEL1: RS9 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL1_RS10_Pos                   (8UL)                     /*!< DLR SRSEL1: RS10 (Bit 8)                                    */
#define DLR_SRSEL1_RS10_Msk                   (0xf00UL)                 /*!< DLR SRSEL1: RS10 (Bitfield-Mask: 0x0f)                      */
#define DLR_SRSEL1_RS11_Pos                   (12UL)                    /*!< DLR SRSEL1: RS11 (Bit 12)                                   */
#define DLR_SRSEL1_RS11_Msk                   (0xf000UL)                /*!< DLR SRSEL1: RS11 (Bitfield-Mask: 0x0f)                      */

/* ----------------------------------  DLR_LNEN  ---------------------------------- */
#define DLR_LNEN_LN0_Pos                      (0UL)                     /*!< DLR LNEN: LN0 (Bit 0)                                       */
#define DLR_LNEN_LN0_Msk                      (0x1UL)                   /*!< DLR LNEN: LN0 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN1_Pos                      (1UL)                     /*!< DLR LNEN: LN1 (Bit 1)                                       */
#define DLR_LNEN_LN1_Msk                      (0x2UL)                   /*!< DLR LNEN: LN1 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN2_Pos                      (2UL)                     /*!< DLR LNEN: LN2 (Bit 2)                                       */
#define DLR_LNEN_LN2_Msk                      (0x4UL)                   /*!< DLR LNEN: LN2 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN3_Pos                      (3UL)                     /*!< DLR LNEN: LN3 (Bit 3)                                       */
#define DLR_LNEN_LN3_Msk                      (0x8UL)                   /*!< DLR LNEN: LN3 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN4_Pos                      (4UL)                     /*!< DLR LNEN: LN4 (Bit 4)                                       */
#define DLR_LNEN_LN4_Msk                      (0x10UL)                  /*!< DLR LNEN: LN4 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN5_Pos                      (5UL)                     /*!< DLR LNEN: LN5 (Bit 5)                                       */
#define DLR_LNEN_LN5_Msk                      (0x20UL)                  /*!< DLR LNEN: LN5 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN6_Pos                      (6UL)                     /*!< DLR LNEN: LN6 (Bit 6)                                       */
#define DLR_LNEN_LN6_Msk                      (0x40UL)                  /*!< DLR LNEN: LN6 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN7_Pos                      (7UL)                     /*!< DLR LNEN: LN7 (Bit 7)                                       */
#define DLR_LNEN_LN7_Msk                      (0x80UL)                  /*!< DLR LNEN: LN7 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN8_Pos                      (8UL)                     /*!< DLR LNEN: LN8 (Bit 8)                                       */
#define DLR_LNEN_LN8_Msk                      (0x100UL)                 /*!< DLR LNEN: LN8 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN9_Pos                      (9UL)                     /*!< DLR LNEN: LN9 (Bit 9)                                       */
#define DLR_LNEN_LN9_Msk                      (0x200UL)                 /*!< DLR LNEN: LN9 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN10_Pos                     (10UL)                    /*!< DLR LNEN: LN10 (Bit 10)                                     */
#define DLR_LNEN_LN10_Msk                     (0x400UL)                 /*!< DLR LNEN: LN10 (Bitfield-Mask: 0x01)                        */
#define DLR_LNEN_LN11_Pos                     (11UL)                    /*!< DLR LNEN: LN11 (Bit 11)                                     */
#define DLR_LNEN_LN11_Msk                     (0x800UL)                 /*!< DLR LNEN: LN11 (Bitfield-Mask: 0x01)                        */


/* ================================================================================ */
/* ================           Group 'ERU' Position & Mask          ================ */
/* ================================================================================ */


/* ---------------------------------  ERU_EXISEL  --------------------------------- */
#define ERU_EXISEL_EXS0A_Pos                  (0UL)                     /*!< ERU EXISEL: EXS0A (Bit 0)                                   */
#define ERU_EXISEL_EXS0A_Msk                  (0x3UL)                   /*!< ERU EXISEL: EXS0A (Bitfield-Mask: 0x03)                     */
#define ERU_EXISEL_EXS0B_Pos                  (2UL)                     /*!< ERU EXISEL: EXS0B (Bit 2)                                   */
#define ERU_EXISEL_EXS0B_Msk                  (0xcUL)                   /*!< ERU EXISEL: EXS0B (Bitfield-Mask: 0x03)                     */
#define ERU_EXISEL_EXS1A_Pos                  (4UL)                     /*!< ERU EXISEL: EXS1A (Bit 4)                                   */
#define ERU_EXISEL_EXS1A_Msk                  (0x30UL)                  /*!< ERU EXISEL: EXS1A (Bitfield-Mask: 0x03)                     */
#define ERU_EXISEL_EXS1B_Pos                  (6UL)                     /*!< ERU EXISEL: EXS1B (Bit 6)                                   */
#define ERU_EXISEL_EXS1B_Msk                  (0xc0UL)                  /*!< ERU EXISEL: EXS1B (Bitfield-Mask: 0x03)                     */
#define ERU_EXISEL_EXS2A_Pos                  (8UL)                     /*!< ERU EXISEL: EXS2A (Bit 8)                                   */
#define ERU_EXISEL_EXS2A_Msk                  (0x300UL)                 /*!< ERU EXISEL: EXS2A (Bitfield-Mask: 0x03)                     */
#define ERU_EXISEL_EXS2B_Pos                  (10UL)                    /*!< ERU EXISEL: EXS2B (Bit 10)                                  */
#define ERU_EXISEL_EXS2B_Msk                  (0xc00UL)                 /*!< ERU EXISEL: EXS2B (Bitfield-Mask: 0x03)                     */
#define ERU_EXISEL_EXS3A_Pos                  (12UL)                    /*!< ERU EXISEL: EXS3A (Bit 12)                                  */
#define ERU_EXISEL_EXS3A_Msk                  (0x3000UL)                /*!< ERU EXISEL: EXS3A (Bitfield-Mask: 0x03)                     */
#define ERU_EXISEL_EXS3B_Pos                  (14UL)                    /*!< ERU EXISEL: EXS3B (Bit 14)                                  */
#define ERU_EXISEL_EXS3B_Msk                  (0xc000UL)                /*!< ERU EXISEL: EXS3B (Bitfield-Mask: 0x03)                     */

/* ---------------------------------  ERU_EXICON  --------------------------------- */
#define ERU_EXICON_PE_Pos                     (0UL)                     /*!< ERU EXICON: PE (Bit 0)                                      */
#define ERU_EXICON_PE_Msk                     (0x1UL)                   /*!< ERU EXICON: PE (Bitfield-Mask: 0x01)                        */
#define ERU_EXICON_LD_Pos                     (1UL)                     /*!< ERU EXICON: LD (Bit 1)                                      */
#define ERU_EXICON_LD_Msk                     (0x2UL)                   /*!< ERU EXICON: LD (Bitfield-Mask: 0x01)                        */
#define ERU_EXICON_RE_Pos                     (2UL)                     /*!< ERU EXICON: RE (Bit 2)                                      */
#define ERU_EXICON_RE_Msk                     (0x4UL)                   /*!< ERU EXICON: RE (Bitfield-Mask: 0x01)                        */
#define ERU_EXICON_FE_Pos                     (3UL)                     /*!< ERU EXICON: FE (Bit 3)                                      */
#define ERU_EXICON_FE_Msk                     (0x8UL)                   /*!< ERU EXICON: FE (Bitfield-Mask: 0x01)                        */
#define ERU_EXICON_OCS_Pos                    (4UL)                     /*!< ERU EXICON: OCS (Bit 4)                                     */
#define ERU_EXICON_OCS_Msk                    (0x70UL)                  /*!< ERU EXICON: OCS (Bitfield-Mask: 0x07)                       */
#define ERU_EXICON_FL_Pos                     (7UL)                     /*!< ERU EXICON: FL (Bit 7)                                      */
#define ERU_EXICON_FL_Msk                     (0x80UL)                  /*!< ERU EXICON: FL (Bitfield-Mask: 0x01)                        */
#define ERU_EXICON_SS_Pos                     (8UL)                     /*!< ERU EXICON: SS (Bit 8)                                      */
#define ERU_EXICON_SS_Msk                     (0x300UL)                 /*!< ERU EXICON: SS (Bitfield-Mask: 0x03)                        */
#define ERU_EXICON_NA_Pos                     (10UL)                    /*!< ERU EXICON: NA (Bit 10)                                     */
#define ERU_EXICON_NA_Msk                     (0x400UL)                 /*!< ERU EXICON: NA (Bitfield-Mask: 0x01)                        */
#define ERU_EXICON_NB_Pos                     (11UL)                    /*!< ERU EXICON: NB (Bit 11)                                     */
#define ERU_EXICON_NB_Msk                     (0x800UL)                 /*!< ERU EXICON: NB (Bitfield-Mask: 0x01)                        */

/* ---------------------------------  ERU_EXOCON  --------------------------------- */
#define ERU_EXOCON_ISS_Pos                    (0UL)                     /*!< ERU EXOCON: ISS (Bit 0)                                     */
#define ERU_EXOCON_ISS_Msk                    (0x3UL)                   /*!< ERU EXOCON: ISS (Bitfield-Mask: 0x03)                       */
#define ERU_EXOCON_GEEN_Pos                   (2UL)                     /*!< ERU EXOCON: GEEN (Bit 2)                                    */
#define ERU_EXOCON_GEEN_Msk                   (0x4UL)                   /*!< ERU EXOCON: GEEN (Bitfield-Mask: 0x01)                      */
#define ERU_EXOCON_PDR_Pos                    (3UL)                     /*!< ERU EXOCON: PDR (Bit 3)                                     */
#define ERU_EXOCON_PDR_Msk                    (0x8UL)                   /*!< ERU EXOCON: PDR (Bitfield-Mask: 0x01)                       */
#define ERU_EXOCON_GP_Pos                     (4UL)                     /*!< ERU EXOCON: GP (Bit 4)                                      */
#define ERU_EXOCON_GP_Msk                     (0x30UL)                  /*!< ERU EXOCON: GP (Bitfield-Mask: 0x03)                        */
#define ERU_EXOCON_IPEN0_Pos                  (12UL)                    /*!< ERU EXOCON: IPEN0 (Bit 12)                                  */
#define ERU_EXOCON_IPEN0_Msk                  (0x1000UL)                /*!< ERU EXOCON: IPEN0 (Bitfield-Mask: 0x01)                     */
#define ERU_EXOCON_IPEN1_Pos                  (13UL)                    /*!< ERU EXOCON: IPEN1 (Bit 13)                                  */
#define ERU_EXOCON_IPEN1_Msk                  (0x2000UL)                /*!< ERU EXOCON: IPEN1 (Bitfield-Mask: 0x01)                     */
#define ERU_EXOCON_IPEN2_Pos                  (14UL)                    /*!< ERU EXOCON: IPEN2 (Bit 14)                                  */
#define ERU_EXOCON_IPEN2_Msk                  (0x4000UL)                /*!< ERU EXOCON: IPEN2 (Bitfield-Mask: 0x01)                     */
#define ERU_EXOCON_IPEN3_Pos                  (15UL)                    /*!< ERU EXOCON: IPEN3 (Bit 15)                                  */
#define ERU_EXOCON_IPEN3_Msk                  (0x8000UL)                /*!< ERU EXOCON: IPEN3 (Bitfield-Mask: 0x01)                     */


/* ================================================================================ */
/* ================         struct 'GPDMA0' Position & Mask        ================ */
/* ================================================================================ */


/* --------------------------------  GPDMA0_RAWTFR  ------------------------------- */
#define GPDMA0_RAWTFR_CH0_Pos                 (0UL)                     /*!< GPDMA0 RAWTFR: CH0 (Bit 0)                                  */
#define GPDMA0_RAWTFR_CH0_Msk                 (0x1UL)                   /*!< GPDMA0 RAWTFR: CH0 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWTFR_CH1_Pos                 (1UL)                     /*!< GPDMA0 RAWTFR: CH1 (Bit 1)                                  */
#define GPDMA0_RAWTFR_CH1_Msk                 (0x2UL)                   /*!< GPDMA0 RAWTFR: CH1 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWTFR_CH2_Pos                 (2UL)                     /*!< GPDMA0 RAWTFR: CH2 (Bit 2)                                  */
#define GPDMA0_RAWTFR_CH2_Msk                 (0x4UL)                   /*!< GPDMA0 RAWTFR: CH2 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWTFR_CH3_Pos                 (3UL)                     /*!< GPDMA0 RAWTFR: CH3 (Bit 3)                                  */
#define GPDMA0_RAWTFR_CH3_Msk                 (0x8UL)                   /*!< GPDMA0 RAWTFR: CH3 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWTFR_CH4_Pos                 (4UL)                     /*!< GPDMA0 RAWTFR: CH4 (Bit 4)                                  */
#define GPDMA0_RAWTFR_CH4_Msk                 (0x10UL)                  /*!< GPDMA0 RAWTFR: CH4 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWTFR_CH5_Pos                 (5UL)                     /*!< GPDMA0 RAWTFR: CH5 (Bit 5)                                  */
#define GPDMA0_RAWTFR_CH5_Msk                 (0x20UL)                  /*!< GPDMA0 RAWTFR: CH5 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWTFR_CH6_Pos                 (6UL)                     /*!< GPDMA0 RAWTFR: CH6 (Bit 6)                                  */
#define GPDMA0_RAWTFR_CH6_Msk                 (0x40UL)                  /*!< GPDMA0 RAWTFR: CH6 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWTFR_CH7_Pos                 (7UL)                     /*!< GPDMA0 RAWTFR: CH7 (Bit 7)                                  */
#define GPDMA0_RAWTFR_CH7_Msk                 (0x80UL)                  /*!< GPDMA0 RAWTFR: CH7 (Bitfield-Mask: 0x01)                    */

/* -------------------------------  GPDMA0_RAWBLOCK  ------------------------------ */
#define GPDMA0_RAWBLOCK_CH0_Pos               (0UL)                     /*!< GPDMA0 RAWBLOCK: CH0 (Bit 0)                                */
#define GPDMA0_RAWBLOCK_CH0_Msk               (0x1UL)                   /*!< GPDMA0 RAWBLOCK: CH0 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_RAWBLOCK_CH1_Pos               (1UL)                     /*!< GPDMA0 RAWBLOCK: CH1 (Bit 1)                                */
#define GPDMA0_RAWBLOCK_CH1_Msk               (0x2UL)                   /*!< GPDMA0 RAWBLOCK: CH1 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_RAWBLOCK_CH2_Pos               (2UL)                     /*!< GPDMA0 RAWBLOCK: CH2 (Bit 2)                                */
#define GPDMA0_RAWBLOCK_CH2_Msk               (0x4UL)                   /*!< GPDMA0 RAWBLOCK: CH2 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_RAWBLOCK_CH3_Pos               (3UL)                     /*!< GPDMA0 RAWBLOCK: CH3 (Bit 3)                                */
#define GPDMA0_RAWBLOCK_CH3_Msk               (0x8UL)                   /*!< GPDMA0 RAWBLOCK: CH3 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_RAWBLOCK_CH4_Pos               (4UL)                     /*!< GPDMA0 RAWBLOCK: CH4 (Bit 4)                                */
#define GPDMA0_RAWBLOCK_CH4_Msk               (0x10UL)                  /*!< GPDMA0 RAWBLOCK: CH4 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_RAWBLOCK_CH5_Pos               (5UL)                     /*!< GPDMA0 RAWBLOCK: CH5 (Bit 5)                                */
#define GPDMA0_RAWBLOCK_CH5_Msk               (0x20UL)                  /*!< GPDMA0 RAWBLOCK: CH5 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_RAWBLOCK_CH6_Pos               (6UL)                     /*!< GPDMA0 RAWBLOCK: CH6 (Bit 6)                                */
#define GPDMA0_RAWBLOCK_CH6_Msk               (0x40UL)                  /*!< GPDMA0 RAWBLOCK: CH6 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_RAWBLOCK_CH7_Pos               (7UL)                     /*!< GPDMA0 RAWBLOCK: CH7 (Bit 7)                                */
#define GPDMA0_RAWBLOCK_CH7_Msk               (0x80UL)                  /*!< GPDMA0 RAWBLOCK: CH7 (Bitfield-Mask: 0x01)                  */

/* ------------------------------  GPDMA0_RAWSRCTRAN  ----------------------------- */
#define GPDMA0_RAWSRCTRAN_CH0_Pos             (0UL)                     /*!< GPDMA0 RAWSRCTRAN: CH0 (Bit 0)                              */
#define GPDMA0_RAWSRCTRAN_CH0_Msk             (0x1UL)                   /*!< GPDMA0 RAWSRCTRAN: CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWSRCTRAN_CH1_Pos             (1UL)                     /*!< GPDMA0 RAWSRCTRAN: CH1 (Bit 1)                              */
#define GPDMA0_RAWSRCTRAN_CH1_Msk             (0x2UL)                   /*!< GPDMA0 RAWSRCTRAN: CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWSRCTRAN_CH2_Pos             (2UL)                     /*!< GPDMA0 RAWSRCTRAN: CH2 (Bit 2)                              */
#define GPDMA0_RAWSRCTRAN_CH2_Msk             (0x4UL)                   /*!< GPDMA0 RAWSRCTRAN: CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWSRCTRAN_CH3_Pos             (3UL)                     /*!< GPDMA0 RAWSRCTRAN: CH3 (Bit 3)                              */
#define GPDMA0_RAWSRCTRAN_CH3_Msk             (0x8UL)                   /*!< GPDMA0 RAWSRCTRAN: CH3 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWSRCTRAN_CH4_Pos             (4UL)                     /*!< GPDMA0 RAWSRCTRAN: CH4 (Bit 4)                              */
#define GPDMA0_RAWSRCTRAN_CH4_Msk             (0x10UL)                  /*!< GPDMA0 RAWSRCTRAN: CH4 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWSRCTRAN_CH5_Pos             (5UL)                     /*!< GPDMA0 RAWSRCTRAN: CH5 (Bit 5)                              */
#define GPDMA0_RAWSRCTRAN_CH5_Msk             (0x20UL)                  /*!< GPDMA0 RAWSRCTRAN: CH5 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWSRCTRAN_CH6_Pos             (6UL)                     /*!< GPDMA0 RAWSRCTRAN: CH6 (Bit 6)                              */
#define GPDMA0_RAWSRCTRAN_CH6_Msk             (0x40UL)                  /*!< GPDMA0 RAWSRCTRAN: CH6 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWSRCTRAN_CH7_Pos             (7UL)                     /*!< GPDMA0 RAWSRCTRAN: CH7 (Bit 7)                              */
#define GPDMA0_RAWSRCTRAN_CH7_Msk             (0x80UL)                  /*!< GPDMA0 RAWSRCTRAN: CH7 (Bitfield-Mask: 0x01)                */

/* ------------------------------  GPDMA0_RAWDSTTRAN  ----------------------------- */
#define GPDMA0_RAWDSTTRAN_CH0_Pos             (0UL)                     /*!< GPDMA0 RAWDSTTRAN: CH0 (Bit 0)                              */
#define GPDMA0_RAWDSTTRAN_CH0_Msk             (0x1UL)                   /*!< GPDMA0 RAWDSTTRAN: CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWDSTTRAN_CH1_Pos             (1UL)                     /*!< GPDMA0 RAWDSTTRAN: CH1 (Bit 1)                              */
#define GPDMA0_RAWDSTTRAN_CH1_Msk             (0x2UL)                   /*!< GPDMA0 RAWDSTTRAN: CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWDSTTRAN_CH2_Pos             (2UL)                     /*!< GPDMA0 RAWDSTTRAN: CH2 (Bit 2)                              */
#define GPDMA0_RAWDSTTRAN_CH2_Msk             (0x4UL)                   /*!< GPDMA0 RAWDSTTRAN: CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWDSTTRAN_CH3_Pos             (3UL)                     /*!< GPDMA0 RAWDSTTRAN: CH3 (Bit 3)                              */
#define GPDMA0_RAWDSTTRAN_CH3_Msk             (0x8UL)                   /*!< GPDMA0 RAWDSTTRAN: CH3 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWDSTTRAN_CH4_Pos             (4UL)                     /*!< GPDMA0 RAWDSTTRAN: CH4 (Bit 4)                              */
#define GPDMA0_RAWDSTTRAN_CH4_Msk             (0x10UL)                  /*!< GPDMA0 RAWDSTTRAN: CH4 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWDSTTRAN_CH5_Pos             (5UL)                     /*!< GPDMA0 RAWDSTTRAN: CH5 (Bit 5)                              */
#define GPDMA0_RAWDSTTRAN_CH5_Msk             (0x20UL)                  /*!< GPDMA0 RAWDSTTRAN: CH5 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWDSTTRAN_CH6_Pos             (6UL)                     /*!< GPDMA0 RAWDSTTRAN: CH6 (Bit 6)                              */
#define GPDMA0_RAWDSTTRAN_CH6_Msk             (0x40UL)                  /*!< GPDMA0 RAWDSTTRAN: CH6 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWDSTTRAN_CH7_Pos             (7UL)                     /*!< GPDMA0 RAWDSTTRAN: CH7 (Bit 7)                              */
#define GPDMA0_RAWDSTTRAN_CH7_Msk             (0x80UL)                  /*!< GPDMA0 RAWDSTTRAN: CH7 (Bitfield-Mask: 0x01)                */

/* --------------------------------  GPDMA0_RAWERR  ------------------------------- */
#define GPDMA0_RAWERR_CH0_Pos                 (0UL)                     /*!< GPDMA0 RAWERR: CH0 (Bit 0)                                  */
#define GPDMA0_RAWERR_CH0_Msk                 (0x1UL)                   /*!< GPDMA0 RAWERR: CH0 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWERR_CH1_Pos                 (1UL)                     /*!< GPDMA0 RAWERR: CH1 (Bit 1)                                  */
#define GPDMA0_RAWERR_CH1_Msk                 (0x2UL)                   /*!< GPDMA0 RAWERR: CH1 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWERR_CH2_Pos                 (2UL)                     /*!< GPDMA0 RAWERR: CH2 (Bit 2)                                  */
#define GPDMA0_RAWERR_CH2_Msk                 (0x4UL)                   /*!< GPDMA0 RAWERR: CH2 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWERR_CH3_Pos                 (3UL)                     /*!< GPDMA0 RAWERR: CH3 (Bit 3)                                  */
#define GPDMA0_RAWERR_CH3_Msk                 (0x8UL)                   /*!< GPDMA0 RAWERR: CH3 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWERR_CH4_Pos                 (4UL)                     /*!< GPDMA0 RAWERR: CH4 (Bit 4)                                  */
#define GPDMA0_RAWERR_CH4_Msk                 (0x10UL)                  /*!< GPDMA0 RAWERR: CH4 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWERR_CH5_Pos                 (5UL)                     /*!< GPDMA0 RAWERR: CH5 (Bit 5)                                  */
#define GPDMA0_RAWERR_CH5_Msk                 (0x20UL)                  /*!< GPDMA0 RAWERR: CH5 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWERR_CH6_Pos                 (6UL)                     /*!< GPDMA0 RAWERR: CH6 (Bit 6)                                  */
#define GPDMA0_RAWERR_CH6_Msk                 (0x40UL)                  /*!< GPDMA0 RAWERR: CH6 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWERR_CH7_Pos                 (7UL)                     /*!< GPDMA0 RAWERR: CH7 (Bit 7)                                  */
#define GPDMA0_RAWERR_CH7_Msk                 (0x80UL)                  /*!< GPDMA0 RAWERR: CH7 (Bitfield-Mask: 0x01)                    */

/* ------------------------------  GPDMA0_STATUSTFR  ------------------------------ */
#define GPDMA0_STATUSTFR_CH0_Pos              (0UL)                     /*!< GPDMA0 STATUSTFR: CH0 (Bit 0)                               */
#define GPDMA0_STATUSTFR_CH0_Msk              (0x1UL)                   /*!< GPDMA0 STATUSTFR: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSTFR_CH1_Pos              (1UL)                     /*!< GPDMA0 STATUSTFR: CH1 (Bit 1)                               */
#define GPDMA0_STATUSTFR_CH1_Msk              (0x2UL)                   /*!< GPDMA0 STATUSTFR: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSTFR_CH2_Pos              (2UL)                     /*!< GPDMA0 STATUSTFR: CH2 (Bit 2)                               */
#define GPDMA0_STATUSTFR_CH2_Msk              (0x4UL)                   /*!< GPDMA0 STATUSTFR: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSTFR_CH3_Pos              (3UL)                     /*!< GPDMA0 STATUSTFR: CH3 (Bit 3)                               */
#define GPDMA0_STATUSTFR_CH3_Msk              (0x8UL)                   /*!< GPDMA0 STATUSTFR: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSTFR_CH4_Pos              (4UL)                     /*!< GPDMA0 STATUSTFR: CH4 (Bit 4)                               */
#define GPDMA0_STATUSTFR_CH4_Msk              (0x10UL)                  /*!< GPDMA0 STATUSTFR: CH4 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSTFR_CH5_Pos              (5UL)                     /*!< GPDMA0 STATUSTFR: CH5 (Bit 5)                               */
#define GPDMA0_STATUSTFR_CH5_Msk              (0x20UL)                  /*!< GPDMA0 STATUSTFR: CH5 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSTFR_CH6_Pos              (6UL)                     /*!< GPDMA0 STATUSTFR: CH6 (Bit 6)                               */
#define GPDMA0_STATUSTFR_CH6_Msk              (0x40UL)                  /*!< GPDMA0 STATUSTFR: CH6 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSTFR_CH7_Pos              (7UL)                     /*!< GPDMA0 STATUSTFR: CH7 (Bit 7)                               */
#define GPDMA0_STATUSTFR_CH7_Msk              (0x80UL)                  /*!< GPDMA0 STATUSTFR: CH7 (Bitfield-Mask: 0x01)                 */

/* -----------------------------  GPDMA0_STATUSBLOCK  ----------------------------- */
#define GPDMA0_STATUSBLOCK_CH0_Pos            (0UL)                     /*!< GPDMA0 STATUSBLOCK: CH0 (Bit 0)                             */
#define GPDMA0_STATUSBLOCK_CH0_Msk            (0x1UL)                   /*!< GPDMA0 STATUSBLOCK: CH0 (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSBLOCK_CH1_Pos            (1UL)                     /*!< GPDMA0 STATUSBLOCK: CH1 (Bit 1)                             */
#define GPDMA0_STATUSBLOCK_CH1_Msk            (0x2UL)                   /*!< GPDMA0 STATUSBLOCK: CH1 (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSBLOCK_CH2_Pos            (2UL)                     /*!< GPDMA0 STATUSBLOCK: CH2 (Bit 2)                             */
#define GPDMA0_STATUSBLOCK_CH2_Msk            (0x4UL)                   /*!< GPDMA0 STATUSBLOCK: CH2 (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSBLOCK_CH3_Pos            (3UL)                     /*!< GPDMA0 STATUSBLOCK: CH3 (Bit 3)                             */
#define GPDMA0_STATUSBLOCK_CH3_Msk            (0x8UL)                   /*!< GPDMA0 STATUSBLOCK: CH3 (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSBLOCK_CH4_Pos            (4UL)                     /*!< GPDMA0 STATUSBLOCK: CH4 (Bit 4)                             */
#define GPDMA0_STATUSBLOCK_CH4_Msk            (0x10UL)                  /*!< GPDMA0 STATUSBLOCK: CH4 (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSBLOCK_CH5_Pos            (5UL)                     /*!< GPDMA0 STATUSBLOCK: CH5 (Bit 5)                             */
#define GPDMA0_STATUSBLOCK_CH5_Msk            (0x20UL)                  /*!< GPDMA0 STATUSBLOCK: CH5 (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSBLOCK_CH6_Pos            (6UL)                     /*!< GPDMA0 STATUSBLOCK: CH6 (Bit 6)                             */
#define GPDMA0_STATUSBLOCK_CH6_Msk            (0x40UL)                  /*!< GPDMA0 STATUSBLOCK: CH6 (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSBLOCK_CH7_Pos            (7UL)                     /*!< GPDMA0 STATUSBLOCK: CH7 (Bit 7)                             */
#define GPDMA0_STATUSBLOCK_CH7_Msk            (0x80UL)                  /*!< GPDMA0 STATUSBLOCK: CH7 (Bitfield-Mask: 0x01)               */

/* ----------------------------  GPDMA0_STATUSSRCTRAN  ---------------------------- */
#define GPDMA0_STATUSSRCTRAN_CH0_Pos          (0UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH0 (Bit 0)                           */
#define GPDMA0_STATUSSRCTRAN_CH0_Msk          (0x1UL)                   /*!< GPDMA0 STATUSSRCTRAN: CH0 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSSRCTRAN_CH1_Pos          (1UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH1 (Bit 1)                           */
#define GPDMA0_STATUSSRCTRAN_CH1_Msk          (0x2UL)                   /*!< GPDMA0 STATUSSRCTRAN: CH1 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSSRCTRAN_CH2_Pos          (2UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH2 (Bit 2)                           */
#define GPDMA0_STATUSSRCTRAN_CH2_Msk          (0x4UL)                   /*!< GPDMA0 STATUSSRCTRAN: CH2 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSSRCTRAN_CH3_Pos          (3UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH3 (Bit 3)                           */
#define GPDMA0_STATUSSRCTRAN_CH3_Msk          (0x8UL)                   /*!< GPDMA0 STATUSSRCTRAN: CH3 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSSRCTRAN_CH4_Pos          (4UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH4 (Bit 4)                           */
#define GPDMA0_STATUSSRCTRAN_CH4_Msk          (0x10UL)                  /*!< GPDMA0 STATUSSRCTRAN: CH4 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSSRCTRAN_CH5_Pos          (5UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH5 (Bit 5)                           */
#define GPDMA0_STATUSSRCTRAN_CH5_Msk          (0x20UL)                  /*!< GPDMA0 STATUSSRCTRAN: CH5 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSSRCTRAN_CH6_Pos          (6UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH6 (Bit 6)                           */
#define GPDMA0_STATUSSRCTRAN_CH6_Msk          (0x40UL)                  /*!< GPDMA0 STATUSSRCTRAN: CH6 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSSRCTRAN_CH7_Pos          (7UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH7 (Bit 7)                           */
#define GPDMA0_STATUSSRCTRAN_CH7_Msk          (0x80UL)                  /*!< GPDMA0 STATUSSRCTRAN: CH7 (Bitfield-Mask: 0x01)             */

/* ----------------------------  GPDMA0_STATUSDSTTRAN  ---------------------------- */
#define GPDMA0_STATUSDSTTRAN_CH0_Pos          (0UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH0 (Bit 0)                           */
#define GPDMA0_STATUSDSTTRAN_CH0_Msk          (0x1UL)                   /*!< GPDMA0 STATUSDSTTRAN: CH0 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSDSTTRAN_CH1_Pos          (1UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH1 (Bit 1)                           */
#define GPDMA0_STATUSDSTTRAN_CH1_Msk          (0x2UL)                   /*!< GPDMA0 STATUSDSTTRAN: CH1 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSDSTTRAN_CH2_Pos          (2UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH2 (Bit 2)                           */
#define GPDMA0_STATUSDSTTRAN_CH2_Msk          (0x4UL)                   /*!< GPDMA0 STATUSDSTTRAN: CH2 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSDSTTRAN_CH3_Pos          (3UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH3 (Bit 3)                           */
#define GPDMA0_STATUSDSTTRAN_CH3_Msk          (0x8UL)                   /*!< GPDMA0 STATUSDSTTRAN: CH3 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSDSTTRAN_CH4_Pos          (4UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH4 (Bit 4)                           */
#define GPDMA0_STATUSDSTTRAN_CH4_Msk          (0x10UL)                  /*!< GPDMA0 STATUSDSTTRAN: CH4 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSDSTTRAN_CH5_Pos          (5UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH5 (Bit 5)                           */
#define GPDMA0_STATUSDSTTRAN_CH5_Msk          (0x20UL)                  /*!< GPDMA0 STATUSDSTTRAN: CH5 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSDSTTRAN_CH6_Pos          (6UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH6 (Bit 6)                           */
#define GPDMA0_STATUSDSTTRAN_CH6_Msk          (0x40UL)                  /*!< GPDMA0 STATUSDSTTRAN: CH6 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSDSTTRAN_CH7_Pos          (7UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH7 (Bit 7)                           */
#define GPDMA0_STATUSDSTTRAN_CH7_Msk          (0x80UL)                  /*!< GPDMA0 STATUSDSTTRAN: CH7 (Bitfield-Mask: 0x01)             */

/* ------------------------------  GPDMA0_STATUSERR  ------------------------------ */
#define GPDMA0_STATUSERR_CH0_Pos              (0UL)                     /*!< GPDMA0 STATUSERR: CH0 (Bit 0)                               */
#define GPDMA0_STATUSERR_CH0_Msk              (0x1UL)                   /*!< GPDMA0 STATUSERR: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSERR_CH1_Pos              (1UL)                     /*!< GPDMA0 STATUSERR: CH1 (Bit 1)                               */
#define GPDMA0_STATUSERR_CH1_Msk              (0x2UL)                   /*!< GPDMA0 STATUSERR: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSERR_CH2_Pos              (2UL)                     /*!< GPDMA0 STATUSERR: CH2 (Bit 2)                               */
#define GPDMA0_STATUSERR_CH2_Msk              (0x4UL)                   /*!< GPDMA0 STATUSERR: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSERR_CH3_Pos              (3UL)                     /*!< GPDMA0 STATUSERR: CH3 (Bit 3)                               */
#define GPDMA0_STATUSERR_CH3_Msk              (0x8UL)                   /*!< GPDMA0 STATUSERR: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSERR_CH4_Pos              (4UL)                     /*!< GPDMA0 STATUSERR: CH4 (Bit 4)                               */
#define GPDMA0_STATUSERR_CH4_Msk              (0x10UL)                  /*!< GPDMA0 STATUSERR: CH4 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSERR_CH5_Pos              (5UL)                     /*!< GPDMA0 STATUSERR: CH5 (Bit 5)                               */
#define GPDMA0_STATUSERR_CH5_Msk              (0x20UL)                  /*!< GPDMA0 STATUSERR: CH5 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSERR_CH6_Pos              (6UL)                     /*!< GPDMA0 STATUSERR: CH6 (Bit 6)                               */
#define GPDMA0_STATUSERR_CH6_Msk              (0x40UL)                  /*!< GPDMA0 STATUSERR: CH6 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSERR_CH7_Pos              (7UL)                     /*!< GPDMA0 STATUSERR: CH7 (Bit 7)                               */
#define GPDMA0_STATUSERR_CH7_Msk              (0x80UL)                  /*!< GPDMA0 STATUSERR: CH7 (Bitfield-Mask: 0x01)                 */

/* -------------------------------  GPDMA0_MASKTFR  ------------------------------- */
#define GPDMA0_MASKTFR_CH0_Pos                (0UL)                     /*!< GPDMA0 MASKTFR: CH0 (Bit 0)                                 */
#define GPDMA0_MASKTFR_CH0_Msk                (0x1UL)                   /*!< GPDMA0 MASKTFR: CH0 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_CH1_Pos                (1UL)                     /*!< GPDMA0 MASKTFR: CH1 (Bit 1)                                 */
#define GPDMA0_MASKTFR_CH1_Msk                (0x2UL)                   /*!< GPDMA0 MASKTFR: CH1 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_CH2_Pos                (2UL)                     /*!< GPDMA0 MASKTFR: CH2 (Bit 2)                                 */
#define GPDMA0_MASKTFR_CH2_Msk                (0x4UL)                   /*!< GPDMA0 MASKTFR: CH2 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_CH3_Pos                (3UL)                     /*!< GPDMA0 MASKTFR: CH3 (Bit 3)                                 */
#define GPDMA0_MASKTFR_CH3_Msk                (0x8UL)                   /*!< GPDMA0 MASKTFR: CH3 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_CH4_Pos                (4UL)                     /*!< GPDMA0 MASKTFR: CH4 (Bit 4)                                 */
#define GPDMA0_MASKTFR_CH4_Msk                (0x10UL)                  /*!< GPDMA0 MASKTFR: CH4 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_CH5_Pos                (5UL)                     /*!< GPDMA0 MASKTFR: CH5 (Bit 5)                                 */
#define GPDMA0_MASKTFR_CH5_Msk                (0x20UL)                  /*!< GPDMA0 MASKTFR: CH5 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_CH6_Pos                (6UL)                     /*!< GPDMA0 MASKTFR: CH6 (Bit 6)                                 */
#define GPDMA0_MASKTFR_CH6_Msk                (0x40UL)                  /*!< GPDMA0 MASKTFR: CH6 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_CH7_Pos                (7UL)                     /*!< GPDMA0 MASKTFR: CH7 (Bit 7)                                 */
#define GPDMA0_MASKTFR_CH7_Msk                (0x80UL)                  /*!< GPDMA0 MASKTFR: CH7 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_WE_CH0_Pos             (8UL)                     /*!< GPDMA0 MASKTFR: WE_CH0 (Bit 8)                              */
#define GPDMA0_MASKTFR_WE_CH0_Msk             (0x100UL)                 /*!< GPDMA0 MASKTFR: WE_CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKTFR_WE_CH1_Pos             (9UL)                     /*!< GPDMA0 MASKTFR: WE_CH1 (Bit 9)                              */
#define GPDMA0_MASKTFR_WE_CH1_Msk             (0x200UL)                 /*!< GPDMA0 MASKTFR: WE_CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKTFR_WE_CH2_Pos             (10UL)                    /*!< GPDMA0 MASKTFR: WE_CH2 (Bit 10)                             */
#define GPDMA0_MASKTFR_WE_CH2_Msk             (0x400UL)                 /*!< GPDMA0 MASKTFR: WE_CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKTFR_WE_CH3_Pos             (11UL)                    /*!< GPDMA0 MASKTFR: WE_CH3 (Bit 11)                             */
#define GPDMA0_MASKTFR_WE_CH3_Msk             (0x800UL)                 /*!< GPDMA0 MASKTFR: WE_CH3 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKTFR_WE_CH4_Pos             (12UL)                    /*!< GPDMA0 MASKTFR: WE_CH4 (Bit 12)                             */
#define GPDMA0_MASKTFR_WE_CH4_Msk             (0x1000UL)                /*!< GPDMA0 MASKTFR: WE_CH4 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKTFR_WE_CH5_Pos             (13UL)                    /*!< GPDMA0 MASKTFR: WE_CH5 (Bit 13)                             */
#define GPDMA0_MASKTFR_WE_CH5_Msk             (0x2000UL)                /*!< GPDMA0 MASKTFR: WE_CH5 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKTFR_WE_CH6_Pos             (14UL)                    /*!< GPDMA0 MASKTFR: WE_CH6 (Bit 14)                             */
#define GPDMA0_MASKTFR_WE_CH6_Msk             (0x4000UL)                /*!< GPDMA0 MASKTFR: WE_CH6 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKTFR_WE_CH7_Pos             (15UL)                    /*!< GPDMA0 MASKTFR: WE_CH7 (Bit 15)                             */
#define GPDMA0_MASKTFR_WE_CH7_Msk             (0x8000UL)                /*!< GPDMA0 MASKTFR: WE_CH7 (Bitfield-Mask: 0x01)                */

/* ------------------------------  GPDMA0_MASKBLOCK  ------------------------------ */
#define GPDMA0_MASKBLOCK_CH0_Pos              (0UL)                     /*!< GPDMA0 MASKBLOCK: CH0 (Bit 0)                               */
#define GPDMA0_MASKBLOCK_CH0_Msk              (0x1UL)                   /*!< GPDMA0 MASKBLOCK: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_CH1_Pos              (1UL)                     /*!< GPDMA0 MASKBLOCK: CH1 (Bit 1)                               */
#define GPDMA0_MASKBLOCK_CH1_Msk              (0x2UL)                   /*!< GPDMA0 MASKBLOCK: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_CH2_Pos              (2UL)                     /*!< GPDMA0 MASKBLOCK: CH2 (Bit 2)                               */
#define GPDMA0_MASKBLOCK_CH2_Msk              (0x4UL)                   /*!< GPDMA0 MASKBLOCK: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_CH3_Pos              (3UL)                     /*!< GPDMA0 MASKBLOCK: CH3 (Bit 3)                               */
#define GPDMA0_MASKBLOCK_CH3_Msk              (0x8UL)                   /*!< GPDMA0 MASKBLOCK: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_CH4_Pos              (4UL)                     /*!< GPDMA0 MASKBLOCK: CH4 (Bit 4)                               */
#define GPDMA0_MASKBLOCK_CH4_Msk              (0x10UL)                  /*!< GPDMA0 MASKBLOCK: CH4 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_CH5_Pos              (5UL)                     /*!< GPDMA0 MASKBLOCK: CH5 (Bit 5)                               */
#define GPDMA0_MASKBLOCK_CH5_Msk              (0x20UL)                  /*!< GPDMA0 MASKBLOCK: CH5 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_CH6_Pos              (6UL)                     /*!< GPDMA0 MASKBLOCK: CH6 (Bit 6)                               */
#define GPDMA0_MASKBLOCK_CH6_Msk              (0x40UL)                  /*!< GPDMA0 MASKBLOCK: CH6 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_CH7_Pos              (7UL)                     /*!< GPDMA0 MASKBLOCK: CH7 (Bit 7)                               */
#define GPDMA0_MASKBLOCK_CH7_Msk              (0x80UL)                  /*!< GPDMA0 MASKBLOCK: CH7 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_WE_CH0_Pos           (8UL)                     /*!< GPDMA0 MASKBLOCK: WE_CH0 (Bit 8)                            */
#define GPDMA0_MASKBLOCK_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA0 MASKBLOCK: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_MASKBLOCK_WE_CH1_Pos           (9UL)                     /*!< GPDMA0 MASKBLOCK: WE_CH1 (Bit 9)                            */
#define GPDMA0_MASKBLOCK_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA0 MASKBLOCK: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_MASKBLOCK_WE_CH2_Pos           (10UL)                    /*!< GPDMA0 MASKBLOCK: WE_CH2 (Bit 10)                           */
#define GPDMA0_MASKBLOCK_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA0 MASKBLOCK: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_MASKBLOCK_WE_CH3_Pos           (11UL)                    /*!< GPDMA0 MASKBLOCK: WE_CH3 (Bit 11)                           */
#define GPDMA0_MASKBLOCK_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA0 MASKBLOCK: WE_CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_MASKBLOCK_WE_CH4_Pos           (12UL)                    /*!< GPDMA0 MASKBLOCK: WE_CH4 (Bit 12)                           */
#define GPDMA0_MASKBLOCK_WE_CH4_Msk           (0x1000UL)                /*!< GPDMA0 MASKBLOCK: WE_CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_MASKBLOCK_WE_CH5_Pos           (13UL)                    /*!< GPDMA0 MASKBLOCK: WE_CH5 (Bit 13)                           */
#define GPDMA0_MASKBLOCK_WE_CH5_Msk           (0x2000UL)                /*!< GPDMA0 MASKBLOCK: WE_CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_MASKBLOCK_WE_CH6_Pos           (14UL)                    /*!< GPDMA0 MASKBLOCK: WE_CH6 (Bit 14)                           */
#define GPDMA0_MASKBLOCK_WE_CH6_Msk           (0x4000UL)                /*!< GPDMA0 MASKBLOCK: WE_CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_MASKBLOCK_WE_CH7_Pos           (15UL)                    /*!< GPDMA0 MASKBLOCK: WE_CH7 (Bit 15)                           */
#define GPDMA0_MASKBLOCK_WE_CH7_Msk           (0x8000UL)                /*!< GPDMA0 MASKBLOCK: WE_CH7 (Bitfield-Mask: 0x01)              */

/* -----------------------------  GPDMA0_MASKSRCTRAN  ----------------------------- */
#define GPDMA0_MASKSRCTRAN_CH0_Pos            (0UL)                     /*!< GPDMA0 MASKSRCTRAN: CH0 (Bit 0)                             */
#define GPDMA0_MASKSRCTRAN_CH0_Msk            (0x1UL)                   /*!< GPDMA0 MASKSRCTRAN: CH0 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_CH1_Pos            (1UL)                     /*!< GPDMA0 MASKSRCTRAN: CH1 (Bit 1)                             */
#define GPDMA0_MASKSRCTRAN_CH1_Msk            (0x2UL)                   /*!< GPDMA0 MASKSRCTRAN: CH1 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_CH2_Pos            (2UL)                     /*!< GPDMA0 MASKSRCTRAN: CH2 (Bit 2)                             */
#define GPDMA0_MASKSRCTRAN_CH2_Msk            (0x4UL)                   /*!< GPDMA0 MASKSRCTRAN: CH2 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_CH3_Pos            (3UL)                     /*!< GPDMA0 MASKSRCTRAN: CH3 (Bit 3)                             */
#define GPDMA0_MASKSRCTRAN_CH3_Msk            (0x8UL)                   /*!< GPDMA0 MASKSRCTRAN: CH3 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_CH4_Pos            (4UL)                     /*!< GPDMA0 MASKSRCTRAN: CH4 (Bit 4)                             */
#define GPDMA0_MASKSRCTRAN_CH4_Msk            (0x10UL)                  /*!< GPDMA0 MASKSRCTRAN: CH4 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_CH5_Pos            (5UL)                     /*!< GPDMA0 MASKSRCTRAN: CH5 (Bit 5)                             */
#define GPDMA0_MASKSRCTRAN_CH5_Msk            (0x20UL)                  /*!< GPDMA0 MASKSRCTRAN: CH5 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_CH6_Pos            (6UL)                     /*!< GPDMA0 MASKSRCTRAN: CH6 (Bit 6)                             */
#define GPDMA0_MASKSRCTRAN_CH6_Msk            (0x40UL)                  /*!< GPDMA0 MASKSRCTRAN: CH6 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_CH7_Pos            (7UL)                     /*!< GPDMA0 MASKSRCTRAN: CH7 (Bit 7)                             */
#define GPDMA0_MASKSRCTRAN_CH7_Msk            (0x80UL)                  /*!< GPDMA0 MASKSRCTRAN: CH7 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_WE_CH0_Pos         (8UL)                     /*!< GPDMA0 MASKSRCTRAN: WE_CH0 (Bit 8)                          */
#define GPDMA0_MASKSRCTRAN_WE_CH0_Msk         (0x100UL)                 /*!< GPDMA0 MASKSRCTRAN: WE_CH0 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKSRCTRAN_WE_CH1_Pos         (9UL)                     /*!< GPDMA0 MASKSRCTRAN: WE_CH1 (Bit 9)                          */
#define GPDMA0_MASKSRCTRAN_WE_CH1_Msk         (0x200UL)                 /*!< GPDMA0 MASKSRCTRAN: WE_CH1 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKSRCTRAN_WE_CH2_Pos         (10UL)                    /*!< GPDMA0 MASKSRCTRAN: WE_CH2 (Bit 10)                         */
#define GPDMA0_MASKSRCTRAN_WE_CH2_Msk         (0x400UL)                 /*!< GPDMA0 MASKSRCTRAN: WE_CH2 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKSRCTRAN_WE_CH3_Pos         (11UL)                    /*!< GPDMA0 MASKSRCTRAN: WE_CH3 (Bit 11)                         */
#define GPDMA0_MASKSRCTRAN_WE_CH3_Msk         (0x800UL)                 /*!< GPDMA0 MASKSRCTRAN: WE_CH3 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKSRCTRAN_WE_CH4_Pos         (12UL)                    /*!< GPDMA0 MASKSRCTRAN: WE_CH4 (Bit 12)                         */
#define GPDMA0_MASKSRCTRAN_WE_CH4_Msk         (0x1000UL)                /*!< GPDMA0 MASKSRCTRAN: WE_CH4 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKSRCTRAN_WE_CH5_Pos         (13UL)                    /*!< GPDMA0 MASKSRCTRAN: WE_CH5 (Bit 13)                         */
#define GPDMA0_MASKSRCTRAN_WE_CH5_Msk         (0x2000UL)                /*!< GPDMA0 MASKSRCTRAN: WE_CH5 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKSRCTRAN_WE_CH6_Pos         (14UL)                    /*!< GPDMA0 MASKSRCTRAN: WE_CH6 (Bit 14)                         */
#define GPDMA0_MASKSRCTRAN_WE_CH6_Msk         (0x4000UL)                /*!< GPDMA0 MASKSRCTRAN: WE_CH6 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKSRCTRAN_WE_CH7_Pos         (15UL)                    /*!< GPDMA0 MASKSRCTRAN: WE_CH7 (Bit 15)                         */
#define GPDMA0_MASKSRCTRAN_WE_CH7_Msk         (0x8000UL)                /*!< GPDMA0 MASKSRCTRAN: WE_CH7 (Bitfield-Mask: 0x01)            */

/* -----------------------------  GPDMA0_MASKDSTTRAN  ----------------------------- */
#define GPDMA0_MASKDSTTRAN_CH0_Pos            (0UL)                     /*!< GPDMA0 MASKDSTTRAN: CH0 (Bit 0)                             */
#define GPDMA0_MASKDSTTRAN_CH0_Msk            (0x1UL)                   /*!< GPDMA0 MASKDSTTRAN: CH0 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_CH1_Pos            (1UL)                     /*!< GPDMA0 MASKDSTTRAN: CH1 (Bit 1)                             */
#define GPDMA0_MASKDSTTRAN_CH1_Msk            (0x2UL)                   /*!< GPDMA0 MASKDSTTRAN: CH1 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_CH2_Pos            (2UL)                     /*!< GPDMA0 MASKDSTTRAN: CH2 (Bit 2)                             */
#define GPDMA0_MASKDSTTRAN_CH2_Msk            (0x4UL)                   /*!< GPDMA0 MASKDSTTRAN: CH2 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_CH3_Pos            (3UL)                     /*!< GPDMA0 MASKDSTTRAN: CH3 (Bit 3)                             */
#define GPDMA0_MASKDSTTRAN_CH3_Msk            (0x8UL)                   /*!< GPDMA0 MASKDSTTRAN: CH3 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_CH4_Pos            (4UL)                     /*!< GPDMA0 MASKDSTTRAN: CH4 (Bit 4)                             */
#define GPDMA0_MASKDSTTRAN_CH4_Msk            (0x10UL)                  /*!< GPDMA0 MASKDSTTRAN: CH4 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_CH5_Pos            (5UL)                     /*!< GPDMA0 MASKDSTTRAN: CH5 (Bit 5)                             */
#define GPDMA0_MASKDSTTRAN_CH5_Msk            (0x20UL)                  /*!< GPDMA0 MASKDSTTRAN: CH5 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_CH6_Pos            (6UL)                     /*!< GPDMA0 MASKDSTTRAN: CH6 (Bit 6)                             */
#define GPDMA0_MASKDSTTRAN_CH6_Msk            (0x40UL)                  /*!< GPDMA0 MASKDSTTRAN: CH6 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_CH7_Pos            (7UL)                     /*!< GPDMA0 MASKDSTTRAN: CH7 (Bit 7)                             */
#define GPDMA0_MASKDSTTRAN_CH7_Msk            (0x80UL)                  /*!< GPDMA0 MASKDSTTRAN: CH7 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_WE_CH0_Pos         (8UL)                     /*!< GPDMA0 MASKDSTTRAN: WE_CH0 (Bit 8)                          */
#define GPDMA0_MASKDSTTRAN_WE_CH0_Msk         (0x100UL)                 /*!< GPDMA0 MASKDSTTRAN: WE_CH0 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKDSTTRAN_WE_CH1_Pos         (9UL)                     /*!< GPDMA0 MASKDSTTRAN: WE_CH1 (Bit 9)                          */
#define GPDMA0_MASKDSTTRAN_WE_CH1_Msk         (0x200UL)                 /*!< GPDMA0 MASKDSTTRAN: WE_CH1 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKDSTTRAN_WE_CH2_Pos         (10UL)                    /*!< GPDMA0 MASKDSTTRAN: WE_CH2 (Bit 10)                         */
#define GPDMA0_MASKDSTTRAN_WE_CH2_Msk         (0x400UL)                 /*!< GPDMA0 MASKDSTTRAN: WE_CH2 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKDSTTRAN_WE_CH3_Pos         (11UL)                    /*!< GPDMA0 MASKDSTTRAN: WE_CH3 (Bit 11)                         */
#define GPDMA0_MASKDSTTRAN_WE_CH3_Msk         (0x800UL)                 /*!< GPDMA0 MASKDSTTRAN: WE_CH3 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKDSTTRAN_WE_CH4_Pos         (12UL)                    /*!< GPDMA0 MASKDSTTRAN: WE_CH4 (Bit 12)                         */
#define GPDMA0_MASKDSTTRAN_WE_CH4_Msk         (0x1000UL)                /*!< GPDMA0 MASKDSTTRAN: WE_CH4 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKDSTTRAN_WE_CH5_Pos         (13UL)                    /*!< GPDMA0 MASKDSTTRAN: WE_CH5 (Bit 13)                         */
#define GPDMA0_MASKDSTTRAN_WE_CH5_Msk         (0x2000UL)                /*!< GPDMA0 MASKDSTTRAN: WE_CH5 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKDSTTRAN_WE_CH6_Pos         (14UL)                    /*!< GPDMA0 MASKDSTTRAN: WE_CH6 (Bit 14)                         */
#define GPDMA0_MASKDSTTRAN_WE_CH6_Msk         (0x4000UL)                /*!< GPDMA0 MASKDSTTRAN: WE_CH6 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKDSTTRAN_WE_CH7_Pos         (15UL)                    /*!< GPDMA0 MASKDSTTRAN: WE_CH7 (Bit 15)                         */
#define GPDMA0_MASKDSTTRAN_WE_CH7_Msk         (0x8000UL)                /*!< GPDMA0 MASKDSTTRAN: WE_CH7 (Bitfield-Mask: 0x01)            */

/* -------------------------------  GPDMA0_MASKERR  ------------------------------- */
#define GPDMA0_MASKERR_CH0_Pos                (0UL)                     /*!< GPDMA0 MASKERR: CH0 (Bit 0)                                 */
#define GPDMA0_MASKERR_CH0_Msk                (0x1UL)                   /*!< GPDMA0 MASKERR: CH0 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_CH1_Pos                (1UL)                     /*!< GPDMA0 MASKERR: CH1 (Bit 1)                                 */
#define GPDMA0_MASKERR_CH1_Msk                (0x2UL)                   /*!< GPDMA0 MASKERR: CH1 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_CH2_Pos                (2UL)                     /*!< GPDMA0 MASKERR: CH2 (Bit 2)                                 */
#define GPDMA0_MASKERR_CH2_Msk                (0x4UL)                   /*!< GPDMA0 MASKERR: CH2 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_CH3_Pos                (3UL)                     /*!< GPDMA0 MASKERR: CH3 (Bit 3)                                 */
#define GPDMA0_MASKERR_CH3_Msk                (0x8UL)                   /*!< GPDMA0 MASKERR: CH3 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_CH4_Pos                (4UL)                     /*!< GPDMA0 MASKERR: CH4 (Bit 4)                                 */
#define GPDMA0_MASKERR_CH4_Msk                (0x10UL)                  /*!< GPDMA0 MASKERR: CH4 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_CH5_Pos                (5UL)                     /*!< GPDMA0 MASKERR: CH5 (Bit 5)                                 */
#define GPDMA0_MASKERR_CH5_Msk                (0x20UL)                  /*!< GPDMA0 MASKERR: CH5 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_CH6_Pos                (6UL)                     /*!< GPDMA0 MASKERR: CH6 (Bit 6)                                 */
#define GPDMA0_MASKERR_CH6_Msk                (0x40UL)                  /*!< GPDMA0 MASKERR: CH6 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_CH7_Pos                (7UL)                     /*!< GPDMA0 MASKERR: CH7 (Bit 7)                                 */
#define GPDMA0_MASKERR_CH7_Msk                (0x80UL)                  /*!< GPDMA0 MASKERR: CH7 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_WE_CH0_Pos             (8UL)                     /*!< GPDMA0 MASKERR: WE_CH0 (Bit 8)                              */
#define GPDMA0_MASKERR_WE_CH0_Msk             (0x100UL)                 /*!< GPDMA0 MASKERR: WE_CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKERR_WE_CH1_Pos             (9UL)                     /*!< GPDMA0 MASKERR: WE_CH1 (Bit 9)                              */
#define GPDMA0_MASKERR_WE_CH1_Msk             (0x200UL)                 /*!< GPDMA0 MASKERR: WE_CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKERR_WE_CH2_Pos             (10UL)                    /*!< GPDMA0 MASKERR: WE_CH2 (Bit 10)                             */
#define GPDMA0_MASKERR_WE_CH2_Msk             (0x400UL)                 /*!< GPDMA0 MASKERR: WE_CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKERR_WE_CH3_Pos             (11UL)                    /*!< GPDMA0 MASKERR: WE_CH3 (Bit 11)                             */
#define GPDMA0_MASKERR_WE_CH3_Msk             (0x800UL)                 /*!< GPDMA0 MASKERR: WE_CH3 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKERR_WE_CH4_Pos             (12UL)                    /*!< GPDMA0 MASKERR: WE_CH4 (Bit 12)                             */
#define GPDMA0_MASKERR_WE_CH4_Msk             (0x1000UL)                /*!< GPDMA0 MASKERR: WE_CH4 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKERR_WE_CH5_Pos             (13UL)                    /*!< GPDMA0 MASKERR: WE_CH5 (Bit 13)                             */
#define GPDMA0_MASKERR_WE_CH5_Msk             (0x2000UL)                /*!< GPDMA0 MASKERR: WE_CH5 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKERR_WE_CH6_Pos             (14UL)                    /*!< GPDMA0 MASKERR: WE_CH6 (Bit 14)                             */
#define GPDMA0_MASKERR_WE_CH6_Msk             (0x4000UL)                /*!< GPDMA0 MASKERR: WE_CH6 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKERR_WE_CH7_Pos             (15UL)                    /*!< GPDMA0 MASKERR: WE_CH7 (Bit 15)                             */
#define GPDMA0_MASKERR_WE_CH7_Msk             (0x8000UL)                /*!< GPDMA0 MASKERR: WE_CH7 (Bitfield-Mask: 0x01)                */

/* -------------------------------  GPDMA0_CLEARTFR  ------------------------------ */
#define GPDMA0_CLEARTFR_CH0_Pos               (0UL)                     /*!< GPDMA0 CLEARTFR: CH0 (Bit 0)                                */
#define GPDMA0_CLEARTFR_CH0_Msk               (0x1UL)                   /*!< GPDMA0 CLEARTFR: CH0 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARTFR_CH1_Pos               (1UL)                     /*!< GPDMA0 CLEARTFR: CH1 (Bit 1)                                */
#define GPDMA0_CLEARTFR_CH1_Msk               (0x2UL)                   /*!< GPDMA0 CLEARTFR: CH1 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARTFR_CH2_Pos               (2UL)                     /*!< GPDMA0 CLEARTFR: CH2 (Bit 2)                                */
#define GPDMA0_CLEARTFR_CH2_Msk               (0x4UL)                   /*!< GPDMA0 CLEARTFR: CH2 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARTFR_CH3_Pos               (3UL)                     /*!< GPDMA0 CLEARTFR: CH3 (Bit 3)                                */
#define GPDMA0_CLEARTFR_CH3_Msk               (0x8UL)                   /*!< GPDMA0 CLEARTFR: CH3 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARTFR_CH4_Pos               (4UL)                     /*!< GPDMA0 CLEARTFR: CH4 (Bit 4)                                */
#define GPDMA0_CLEARTFR_CH4_Msk               (0x10UL)                  /*!< GPDMA0 CLEARTFR: CH4 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARTFR_CH5_Pos               (5UL)                     /*!< GPDMA0 CLEARTFR: CH5 (Bit 5)                                */
#define GPDMA0_CLEARTFR_CH5_Msk               (0x20UL)                  /*!< GPDMA0 CLEARTFR: CH5 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARTFR_CH6_Pos               (6UL)                     /*!< GPDMA0 CLEARTFR: CH6 (Bit 6)                                */
#define GPDMA0_CLEARTFR_CH6_Msk               (0x40UL)                  /*!< GPDMA0 CLEARTFR: CH6 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARTFR_CH7_Pos               (7UL)                     /*!< GPDMA0 CLEARTFR: CH7 (Bit 7)                                */
#define GPDMA0_CLEARTFR_CH7_Msk               (0x80UL)                  /*!< GPDMA0 CLEARTFR: CH7 (Bitfield-Mask: 0x01)                  */

/* ------------------------------  GPDMA0_CLEARBLOCK  ----------------------------- */
#define GPDMA0_CLEARBLOCK_CH0_Pos             (0UL)                     /*!< GPDMA0 CLEARBLOCK: CH0 (Bit 0)                              */
#define GPDMA0_CLEARBLOCK_CH0_Msk             (0x1UL)                   /*!< GPDMA0 CLEARBLOCK: CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA0_CLEARBLOCK_CH1_Pos             (1UL)                     /*!< GPDMA0 CLEARBLOCK: CH1 (Bit 1)                              */
#define GPDMA0_CLEARBLOCK_CH1_Msk             (0x2UL)                   /*!< GPDMA0 CLEARBLOCK: CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA0_CLEARBLOCK_CH2_Pos             (2UL)                     /*!< GPDMA0 CLEARBLOCK: CH2 (Bit 2)                              */
#define GPDMA0_CLEARBLOCK_CH2_Msk             (0x4UL)                   /*!< GPDMA0 CLEARBLOCK: CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA0_CLEARBLOCK_CH3_Pos             (3UL)                     /*!< GPDMA0 CLEARBLOCK: CH3 (Bit 3)                              */
#define GPDMA0_CLEARBLOCK_CH3_Msk             (0x8UL)                   /*!< GPDMA0 CLEARBLOCK: CH3 (Bitfield-Mask: 0x01)                */
#define GPDMA0_CLEARBLOCK_CH4_Pos             (4UL)                     /*!< GPDMA0 CLEARBLOCK: CH4 (Bit 4)                              */
#define GPDMA0_CLEARBLOCK_CH4_Msk             (0x10UL)                  /*!< GPDMA0 CLEARBLOCK: CH4 (Bitfield-Mask: 0x01)                */
#define GPDMA0_CLEARBLOCK_CH5_Pos             (5UL)                     /*!< GPDMA0 CLEARBLOCK: CH5 (Bit 5)                              */
#define GPDMA0_CLEARBLOCK_CH5_Msk             (0x20UL)                  /*!< GPDMA0 CLEARBLOCK: CH5 (Bitfield-Mask: 0x01)                */
#define GPDMA0_CLEARBLOCK_CH6_Pos             (6UL)                     /*!< GPDMA0 CLEARBLOCK: CH6 (Bit 6)                              */
#define GPDMA0_CLEARBLOCK_CH6_Msk             (0x40UL)                  /*!< GPDMA0 CLEARBLOCK: CH6 (Bitfield-Mask: 0x01)                */
#define GPDMA0_CLEARBLOCK_CH7_Pos             (7UL)                     /*!< GPDMA0 CLEARBLOCK: CH7 (Bit 7)                              */
#define GPDMA0_CLEARBLOCK_CH7_Msk             (0x80UL)                  /*!< GPDMA0 CLEARBLOCK: CH7 (Bitfield-Mask: 0x01)                */

/* -----------------------------  GPDMA0_CLEARSRCTRAN  ---------------------------- */
#define GPDMA0_CLEARSRCTRAN_CH0_Pos           (0UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH0 (Bit 0)                            */
#define GPDMA0_CLEARSRCTRAN_CH0_Msk           (0x1UL)                   /*!< GPDMA0 CLEARSRCTRAN: CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARSRCTRAN_CH1_Pos           (1UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH1 (Bit 1)                            */
#define GPDMA0_CLEARSRCTRAN_CH1_Msk           (0x2UL)                   /*!< GPDMA0 CLEARSRCTRAN: CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARSRCTRAN_CH2_Pos           (2UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH2 (Bit 2)                            */
#define GPDMA0_CLEARSRCTRAN_CH2_Msk           (0x4UL)                   /*!< GPDMA0 CLEARSRCTRAN: CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARSRCTRAN_CH3_Pos           (3UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH3 (Bit 3)                            */
#define GPDMA0_CLEARSRCTRAN_CH3_Msk           (0x8UL)                   /*!< GPDMA0 CLEARSRCTRAN: CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARSRCTRAN_CH4_Pos           (4UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH4 (Bit 4)                            */
#define GPDMA0_CLEARSRCTRAN_CH4_Msk           (0x10UL)                  /*!< GPDMA0 CLEARSRCTRAN: CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARSRCTRAN_CH5_Pos           (5UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH5 (Bit 5)                            */
#define GPDMA0_CLEARSRCTRAN_CH5_Msk           (0x20UL)                  /*!< GPDMA0 CLEARSRCTRAN: CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARSRCTRAN_CH6_Pos           (6UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH6 (Bit 6)                            */
#define GPDMA0_CLEARSRCTRAN_CH6_Msk           (0x40UL)                  /*!< GPDMA0 CLEARSRCTRAN: CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARSRCTRAN_CH7_Pos           (7UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH7 (Bit 7)                            */
#define GPDMA0_CLEARSRCTRAN_CH7_Msk           (0x80UL)                  /*!< GPDMA0 CLEARSRCTRAN: CH7 (Bitfield-Mask: 0x01)              */

/* -----------------------------  GPDMA0_CLEARDSTTRAN  ---------------------------- */
#define GPDMA0_CLEARDSTTRAN_CH0_Pos           (0UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH0 (Bit 0)                            */
#define GPDMA0_CLEARDSTTRAN_CH0_Msk           (0x1UL)                   /*!< GPDMA0 CLEARDSTTRAN: CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARDSTTRAN_CH1_Pos           (1UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH1 (Bit 1)                            */
#define GPDMA0_CLEARDSTTRAN_CH1_Msk           (0x2UL)                   /*!< GPDMA0 CLEARDSTTRAN: CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARDSTTRAN_CH2_Pos           (2UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH2 (Bit 2)                            */
#define GPDMA0_CLEARDSTTRAN_CH2_Msk           (0x4UL)                   /*!< GPDMA0 CLEARDSTTRAN: CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARDSTTRAN_CH3_Pos           (3UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH3 (Bit 3)                            */
#define GPDMA0_CLEARDSTTRAN_CH3_Msk           (0x8UL)                   /*!< GPDMA0 CLEARDSTTRAN: CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARDSTTRAN_CH4_Pos           (4UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH4 (Bit 4)                            */
#define GPDMA0_CLEARDSTTRAN_CH4_Msk           (0x10UL)                  /*!< GPDMA0 CLEARDSTTRAN: CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARDSTTRAN_CH5_Pos           (5UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH5 (Bit 5)                            */
#define GPDMA0_CLEARDSTTRAN_CH5_Msk           (0x20UL)                  /*!< GPDMA0 CLEARDSTTRAN: CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARDSTTRAN_CH6_Pos           (6UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH6 (Bit 6)                            */
#define GPDMA0_CLEARDSTTRAN_CH6_Msk           (0x40UL)                  /*!< GPDMA0 CLEARDSTTRAN: CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARDSTTRAN_CH7_Pos           (7UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH7 (Bit 7)                            */
#define GPDMA0_CLEARDSTTRAN_CH7_Msk           (0x80UL)                  /*!< GPDMA0 CLEARDSTTRAN: CH7 (Bitfield-Mask: 0x01)              */

/* -------------------------------  GPDMA0_CLEARERR  ------------------------------ */
#define GPDMA0_CLEARERR_CH0_Pos               (0UL)                     /*!< GPDMA0 CLEARERR: CH0 (Bit 0)                                */
#define GPDMA0_CLEARERR_CH0_Msk               (0x1UL)                   /*!< GPDMA0 CLEARERR: CH0 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARERR_CH1_Pos               (1UL)                     /*!< GPDMA0 CLEARERR: CH1 (Bit 1)                                */
#define GPDMA0_CLEARERR_CH1_Msk               (0x2UL)                   /*!< GPDMA0 CLEARERR: CH1 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARERR_CH2_Pos               (2UL)                     /*!< GPDMA0 CLEARERR: CH2 (Bit 2)                                */
#define GPDMA0_CLEARERR_CH2_Msk               (0x4UL)                   /*!< GPDMA0 CLEARERR: CH2 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARERR_CH3_Pos               (3UL)                     /*!< GPDMA0 CLEARERR: CH3 (Bit 3)                                */
#define GPDMA0_CLEARERR_CH3_Msk               (0x8UL)                   /*!< GPDMA0 CLEARERR: CH3 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARERR_CH4_Pos               (4UL)                     /*!< GPDMA0 CLEARERR: CH4 (Bit 4)                                */
#define GPDMA0_CLEARERR_CH4_Msk               (0x10UL)                  /*!< GPDMA0 CLEARERR: CH4 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARERR_CH5_Pos               (5UL)                     /*!< GPDMA0 CLEARERR: CH5 (Bit 5)                                */
#define GPDMA0_CLEARERR_CH5_Msk               (0x20UL)                  /*!< GPDMA0 CLEARERR: CH5 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARERR_CH6_Pos               (6UL)                     /*!< GPDMA0 CLEARERR: CH6 (Bit 6)                                */
#define GPDMA0_CLEARERR_CH6_Msk               (0x40UL)                  /*!< GPDMA0 CLEARERR: CH6 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARERR_CH7_Pos               (7UL)                     /*!< GPDMA0 CLEARERR: CH7 (Bit 7)                                */
#define GPDMA0_CLEARERR_CH7_Msk               (0x80UL)                  /*!< GPDMA0 CLEARERR: CH7 (Bitfield-Mask: 0x01)                  */

/* ------------------------------  GPDMA0_STATUSINT  ------------------------------ */
#define GPDMA0_STATUSINT_TFR_Pos              (0UL)                     /*!< GPDMA0 STATUSINT: TFR (Bit 0)                               */
#define GPDMA0_STATUSINT_TFR_Msk              (0x1UL)                   /*!< GPDMA0 STATUSINT: TFR (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSINT_BLOCK_Pos            (1UL)                     /*!< GPDMA0 STATUSINT: BLOCK (Bit 1)                             */
#define GPDMA0_STATUSINT_BLOCK_Msk            (0x2UL)                   /*!< GPDMA0 STATUSINT: BLOCK (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSINT_SRCT_Pos             (2UL)                     /*!< GPDMA0 STATUSINT: SRCT (Bit 2)                              */
#define GPDMA0_STATUSINT_SRCT_Msk             (0x4UL)                   /*!< GPDMA0 STATUSINT: SRCT (Bitfield-Mask: 0x01)                */
#define GPDMA0_STATUSINT_DSTT_Pos             (3UL)                     /*!< GPDMA0 STATUSINT: DSTT (Bit 3)                              */
#define GPDMA0_STATUSINT_DSTT_Msk             (0x8UL)                   /*!< GPDMA0 STATUSINT: DSTT (Bitfield-Mask: 0x01)                */
#define GPDMA0_STATUSINT_ERR_Pos              (4UL)                     /*!< GPDMA0 STATUSINT: ERR (Bit 4)                               */
#define GPDMA0_STATUSINT_ERR_Msk              (0x10UL)                  /*!< GPDMA0 STATUSINT: ERR (Bitfield-Mask: 0x01)                 */

/* ------------------------------  GPDMA0_REQSRCREG  ------------------------------ */
#define GPDMA0_REQSRCREG_CH0_Pos              (0UL)                     /*!< GPDMA0 REQSRCREG: CH0 (Bit 0)                               */
#define GPDMA0_REQSRCREG_CH0_Msk              (0x1UL)                   /*!< GPDMA0 REQSRCREG: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_CH1_Pos              (1UL)                     /*!< GPDMA0 REQSRCREG: CH1 (Bit 1)                               */
#define GPDMA0_REQSRCREG_CH1_Msk              (0x2UL)                   /*!< GPDMA0 REQSRCREG: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_CH2_Pos              (2UL)                     /*!< GPDMA0 REQSRCREG: CH2 (Bit 2)                               */
#define GPDMA0_REQSRCREG_CH2_Msk              (0x4UL)                   /*!< GPDMA0 REQSRCREG: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_CH3_Pos              (3UL)                     /*!< GPDMA0 REQSRCREG: CH3 (Bit 3)                               */
#define GPDMA0_REQSRCREG_CH3_Msk              (0x8UL)                   /*!< GPDMA0 REQSRCREG: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_CH4_Pos              (4UL)                     /*!< GPDMA0 REQSRCREG: CH4 (Bit 4)                               */
#define GPDMA0_REQSRCREG_CH4_Msk              (0x10UL)                  /*!< GPDMA0 REQSRCREG: CH4 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_CH5_Pos              (5UL)                     /*!< GPDMA0 REQSRCREG: CH5 (Bit 5)                               */
#define GPDMA0_REQSRCREG_CH5_Msk              (0x20UL)                  /*!< GPDMA0 REQSRCREG: CH5 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_CH6_Pos              (6UL)                     /*!< GPDMA0 REQSRCREG: CH6 (Bit 6)                               */
#define GPDMA0_REQSRCREG_CH6_Msk              (0x40UL)                  /*!< GPDMA0 REQSRCREG: CH6 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_CH7_Pos              (7UL)                     /*!< GPDMA0 REQSRCREG: CH7 (Bit 7)                               */
#define GPDMA0_REQSRCREG_CH7_Msk              (0x80UL)                  /*!< GPDMA0 REQSRCREG: CH7 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_WE_CH0_Pos           (8UL)                     /*!< GPDMA0 REQSRCREG: WE_CH0 (Bit 8)                            */
#define GPDMA0_REQSRCREG_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA0 REQSRCREG: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQSRCREG_WE_CH1_Pos           (9UL)                     /*!< GPDMA0 REQSRCREG: WE_CH1 (Bit 9)                            */
#define GPDMA0_REQSRCREG_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA0 REQSRCREG: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQSRCREG_WE_CH2_Pos           (10UL)                    /*!< GPDMA0 REQSRCREG: WE_CH2 (Bit 10)                           */
#define GPDMA0_REQSRCREG_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA0 REQSRCREG: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQSRCREG_WE_CH3_Pos           (11UL)                    /*!< GPDMA0 REQSRCREG: WE_CH3 (Bit 11)                           */
#define GPDMA0_REQSRCREG_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA0 REQSRCREG: WE_CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQSRCREG_WE_CH4_Pos           (12UL)                    /*!< GPDMA0 REQSRCREG: WE_CH4 (Bit 12)                           */
#define GPDMA0_REQSRCREG_WE_CH4_Msk           (0x1000UL)                /*!< GPDMA0 REQSRCREG: WE_CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQSRCREG_WE_CH5_Pos           (13UL)                    /*!< GPDMA0 REQSRCREG: WE_CH5 (Bit 13)                           */
#define GPDMA0_REQSRCREG_WE_CH5_Msk           (0x2000UL)                /*!< GPDMA0 REQSRCREG: WE_CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQSRCREG_WE_CH6_Pos           (14UL)                    /*!< GPDMA0 REQSRCREG: WE_CH6 (Bit 14)                           */
#define GPDMA0_REQSRCREG_WE_CH6_Msk           (0x4000UL)                /*!< GPDMA0 REQSRCREG: WE_CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQSRCREG_WE_CH7_Pos           (15UL)                    /*!< GPDMA0 REQSRCREG: WE_CH7 (Bit 15)                           */
#define GPDMA0_REQSRCREG_WE_CH7_Msk           (0x8000UL)                /*!< GPDMA0 REQSRCREG: WE_CH7 (Bitfield-Mask: 0x01)              */

/* ------------------------------  GPDMA0_REQDSTREG  ------------------------------ */
#define GPDMA0_REQDSTREG_CH0_Pos              (0UL)                     /*!< GPDMA0 REQDSTREG: CH0 (Bit 0)                               */
#define GPDMA0_REQDSTREG_CH0_Msk              (0x1UL)                   /*!< GPDMA0 REQDSTREG: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_CH1_Pos              (1UL)                     /*!< GPDMA0 REQDSTREG: CH1 (Bit 1)                               */
#define GPDMA0_REQDSTREG_CH1_Msk              (0x2UL)                   /*!< GPDMA0 REQDSTREG: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_CH2_Pos              (2UL)                     /*!< GPDMA0 REQDSTREG: CH2 (Bit 2)                               */
#define GPDMA0_REQDSTREG_CH2_Msk              (0x4UL)                   /*!< GPDMA0 REQDSTREG: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_CH3_Pos              (3UL)                     /*!< GPDMA0 REQDSTREG: CH3 (Bit 3)                               */
#define GPDMA0_REQDSTREG_CH3_Msk              (0x8UL)                   /*!< GPDMA0 REQDSTREG: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_CH4_Pos              (4UL)                     /*!< GPDMA0 REQDSTREG: CH4 (Bit 4)                               */
#define GPDMA0_REQDSTREG_CH4_Msk              (0x10UL)                  /*!< GPDMA0 REQDSTREG: CH4 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_CH5_Pos              (5UL)                     /*!< GPDMA0 REQDSTREG: CH5 (Bit 5)                               */
#define GPDMA0_REQDSTREG_CH5_Msk              (0x20UL)                  /*!< GPDMA0 REQDSTREG: CH5 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_CH6_Pos              (6UL)                     /*!< GPDMA0 REQDSTREG: CH6 (Bit 6)                               */
#define GPDMA0_REQDSTREG_CH6_Msk              (0x40UL)                  /*!< GPDMA0 REQDSTREG: CH6 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_CH7_Pos              (7UL)                     /*!< GPDMA0 REQDSTREG: CH7 (Bit 7)                               */
#define GPDMA0_REQDSTREG_CH7_Msk              (0x80UL)                  /*!< GPDMA0 REQDSTREG: CH7 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_WE_CH0_Pos           (8UL)                     /*!< GPDMA0 REQDSTREG: WE_CH0 (Bit 8)                            */
#define GPDMA0_REQDSTREG_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA0 REQDSTREG: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQDSTREG_WE_CH1_Pos           (9UL)                     /*!< GPDMA0 REQDSTREG: WE_CH1 (Bit 9)                            */
#define GPDMA0_REQDSTREG_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA0 REQDSTREG: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQDSTREG_WE_CH2_Pos           (10UL)                    /*!< GPDMA0 REQDSTREG: WE_CH2 (Bit 10)                           */
#define GPDMA0_REQDSTREG_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA0 REQDSTREG: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQDSTREG_WE_CH3_Pos           (11UL)                    /*!< GPDMA0 REQDSTREG: WE_CH3 (Bit 11)                           */
#define GPDMA0_REQDSTREG_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA0 REQDSTREG: WE_CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQDSTREG_WE_CH4_Pos           (12UL)                    /*!< GPDMA0 REQDSTREG: WE_CH4 (Bit 12)                           */
#define GPDMA0_REQDSTREG_WE_CH4_Msk           (0x1000UL)                /*!< GPDMA0 REQDSTREG: WE_CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQDSTREG_WE_CH5_Pos           (13UL)                    /*!< GPDMA0 REQDSTREG: WE_CH5 (Bit 13)                           */
#define GPDMA0_REQDSTREG_WE_CH5_Msk           (0x2000UL)                /*!< GPDMA0 REQDSTREG: WE_CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQDSTREG_WE_CH6_Pos           (14UL)                    /*!< GPDMA0 REQDSTREG: WE_CH6 (Bit 14)                           */
#define GPDMA0_REQDSTREG_WE_CH6_Msk           (0x4000UL)                /*!< GPDMA0 REQDSTREG: WE_CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQDSTREG_WE_CH7_Pos           (15UL)                    /*!< GPDMA0 REQDSTREG: WE_CH7 (Bit 15)                           */
#define GPDMA0_REQDSTREG_WE_CH7_Msk           (0x8000UL)                /*!< GPDMA0 REQDSTREG: WE_CH7 (Bitfield-Mask: 0x01)              */

/* -----------------------------  GPDMA0_SGLREQSRCREG  ---------------------------- */
#define GPDMA0_SGLREQSRCREG_CH0_Pos           (0UL)                     /*!< GPDMA0 SGLREQSRCREG: CH0 (Bit 0)                            */
#define GPDMA0_SGLREQSRCREG_CH0_Msk           (0x1UL)                   /*!< GPDMA0 SGLREQSRCREG: CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_CH1_Pos           (1UL)                     /*!< GPDMA0 SGLREQSRCREG: CH1 (Bit 1)                            */
#define GPDMA0_SGLREQSRCREG_CH1_Msk           (0x2UL)                   /*!< GPDMA0 SGLREQSRCREG: CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_CH2_Pos           (2UL)                     /*!< GPDMA0 SGLREQSRCREG: CH2 (Bit 2)                            */
#define GPDMA0_SGLREQSRCREG_CH2_Msk           (0x4UL)                   /*!< GPDMA0 SGLREQSRCREG: CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_CH3_Pos           (3UL)                     /*!< GPDMA0 SGLREQSRCREG: CH3 (Bit 3)                            */
#define GPDMA0_SGLREQSRCREG_CH3_Msk           (0x8UL)                   /*!< GPDMA0 SGLREQSRCREG: CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_CH4_Pos           (4UL)                     /*!< GPDMA0 SGLREQSRCREG: CH4 (Bit 4)                            */
#define GPDMA0_SGLREQSRCREG_CH4_Msk           (0x10UL)                  /*!< GPDMA0 SGLREQSRCREG: CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_CH5_Pos           (5UL)                     /*!< GPDMA0 SGLREQSRCREG: CH5 (Bit 5)                            */
#define GPDMA0_SGLREQSRCREG_CH5_Msk           (0x20UL)                  /*!< GPDMA0 SGLREQSRCREG: CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_CH6_Pos           (6UL)                     /*!< GPDMA0 SGLREQSRCREG: CH6 (Bit 6)                            */
#define GPDMA0_SGLREQSRCREG_CH6_Msk           (0x40UL)                  /*!< GPDMA0 SGLREQSRCREG: CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_CH7_Pos           (7UL)                     /*!< GPDMA0 SGLREQSRCREG: CH7 (Bit 7)                            */
#define GPDMA0_SGLREQSRCREG_CH7_Msk           (0x80UL)                  /*!< GPDMA0 SGLREQSRCREG: CH7 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_WE_CH0_Pos        (8UL)                     /*!< GPDMA0 SGLREQSRCREG: WE_CH0 (Bit 8)                         */
#define GPDMA0_SGLREQSRCREG_WE_CH0_Msk        (0x100UL)                 /*!< GPDMA0 SGLREQSRCREG: WE_CH0 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQSRCREG_WE_CH1_Pos        (9UL)                     /*!< GPDMA0 SGLREQSRCREG: WE_CH1 (Bit 9)                         */
#define GPDMA0_SGLREQSRCREG_WE_CH1_Msk        (0x200UL)                 /*!< GPDMA0 SGLREQSRCREG: WE_CH1 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQSRCREG_WE_CH2_Pos        (10UL)                    /*!< GPDMA0 SGLREQSRCREG: WE_CH2 (Bit 10)                        */
#define GPDMA0_SGLREQSRCREG_WE_CH2_Msk        (0x400UL)                 /*!< GPDMA0 SGLREQSRCREG: WE_CH2 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQSRCREG_WE_CH3_Pos        (11UL)                    /*!< GPDMA0 SGLREQSRCREG: WE_CH3 (Bit 11)                        */
#define GPDMA0_SGLREQSRCREG_WE_CH3_Msk        (0x800UL)                 /*!< GPDMA0 SGLREQSRCREG: WE_CH3 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQSRCREG_WE_CH4_Pos        (12UL)                    /*!< GPDMA0 SGLREQSRCREG: WE_CH4 (Bit 12)                        */
#define GPDMA0_SGLREQSRCREG_WE_CH4_Msk        (0x1000UL)                /*!< GPDMA0 SGLREQSRCREG: WE_CH4 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQSRCREG_WE_CH5_Pos        (13UL)                    /*!< GPDMA0 SGLREQSRCREG: WE_CH5 (Bit 13)                        */
#define GPDMA0_SGLREQSRCREG_WE_CH5_Msk        (0x2000UL)                /*!< GPDMA0 SGLREQSRCREG: WE_CH5 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQSRCREG_WE_CH6_Pos        (14UL)                    /*!< GPDMA0 SGLREQSRCREG: WE_CH6 (Bit 14)                        */
#define GPDMA0_SGLREQSRCREG_WE_CH6_Msk        (0x4000UL)                /*!< GPDMA0 SGLREQSRCREG: WE_CH6 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQSRCREG_WE_CH7_Pos        (15UL)                    /*!< GPDMA0 SGLREQSRCREG: WE_CH7 (Bit 15)                        */
#define GPDMA0_SGLREQSRCREG_WE_CH7_Msk        (0x8000UL)                /*!< GPDMA0 SGLREQSRCREG: WE_CH7 (Bitfield-Mask: 0x01)           */

/* -----------------------------  GPDMA0_SGLREQDSTREG  ---------------------------- */
#define GPDMA0_SGLREQDSTREG_CH0_Pos           (0UL)                     /*!< GPDMA0 SGLREQDSTREG: CH0 (Bit 0)                            */
#define GPDMA0_SGLREQDSTREG_CH0_Msk           (0x1UL)                   /*!< GPDMA0 SGLREQDSTREG: CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_CH1_Pos           (1UL)                     /*!< GPDMA0 SGLREQDSTREG: CH1 (Bit 1)                            */
#define GPDMA0_SGLREQDSTREG_CH1_Msk           (0x2UL)                   /*!< GPDMA0 SGLREQDSTREG: CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_CH2_Pos           (2UL)                     /*!< GPDMA0 SGLREQDSTREG: CH2 (Bit 2)                            */
#define GPDMA0_SGLREQDSTREG_CH2_Msk           (0x4UL)                   /*!< GPDMA0 SGLREQDSTREG: CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_CH3_Pos           (3UL)                     /*!< GPDMA0 SGLREQDSTREG: CH3 (Bit 3)                            */
#define GPDMA0_SGLREQDSTREG_CH3_Msk           (0x8UL)                   /*!< GPDMA0 SGLREQDSTREG: CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_CH4_Pos           (4UL)                     /*!< GPDMA0 SGLREQDSTREG: CH4 (Bit 4)                            */
#define GPDMA0_SGLREQDSTREG_CH4_Msk           (0x10UL)                  /*!< GPDMA0 SGLREQDSTREG: CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_CH5_Pos           (5UL)                     /*!< GPDMA0 SGLREQDSTREG: CH5 (Bit 5)                            */
#define GPDMA0_SGLREQDSTREG_CH5_Msk           (0x20UL)                  /*!< GPDMA0 SGLREQDSTREG: CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_CH6_Pos           (6UL)                     /*!< GPDMA0 SGLREQDSTREG: CH6 (Bit 6)                            */
#define GPDMA0_SGLREQDSTREG_CH6_Msk           (0x40UL)                  /*!< GPDMA0 SGLREQDSTREG: CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_CH7_Pos           (7UL)                     /*!< GPDMA0 SGLREQDSTREG: CH7 (Bit 7)                            */
#define GPDMA0_SGLREQDSTREG_CH7_Msk           (0x80UL)                  /*!< GPDMA0 SGLREQDSTREG: CH7 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_WE_CH0_Pos        (8UL)                     /*!< GPDMA0 SGLREQDSTREG: WE_CH0 (Bit 8)                         */
#define GPDMA0_SGLREQDSTREG_WE_CH0_Msk        (0x100UL)                 /*!< GPDMA0 SGLREQDSTREG: WE_CH0 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQDSTREG_WE_CH1_Pos        (9UL)                     /*!< GPDMA0 SGLREQDSTREG: WE_CH1 (Bit 9)                         */
#define GPDMA0_SGLREQDSTREG_WE_CH1_Msk        (0x200UL)                 /*!< GPDMA0 SGLREQDSTREG: WE_CH1 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQDSTREG_WE_CH2_Pos        (10UL)                    /*!< GPDMA0 SGLREQDSTREG: WE_CH2 (Bit 10)                        */
#define GPDMA0_SGLREQDSTREG_WE_CH2_Msk        (0x400UL)                 /*!< GPDMA0 SGLREQDSTREG: WE_CH2 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQDSTREG_WE_CH3_Pos        (11UL)                    /*!< GPDMA0 SGLREQDSTREG: WE_CH3 (Bit 11)                        */
#define GPDMA0_SGLREQDSTREG_WE_CH3_Msk        (0x800UL)                 /*!< GPDMA0 SGLREQDSTREG: WE_CH3 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQDSTREG_WE_CH4_Pos        (12UL)                    /*!< GPDMA0 SGLREQDSTREG: WE_CH4 (Bit 12)                        */
#define GPDMA0_SGLREQDSTREG_WE_CH4_Msk        (0x1000UL)                /*!< GPDMA0 SGLREQDSTREG: WE_CH4 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQDSTREG_WE_CH5_Pos        (13UL)                    /*!< GPDMA0 SGLREQDSTREG: WE_CH5 (Bit 13)                        */
#define GPDMA0_SGLREQDSTREG_WE_CH5_Msk        (0x2000UL)                /*!< GPDMA0 SGLREQDSTREG: WE_CH5 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQDSTREG_WE_CH6_Pos        (14UL)                    /*!< GPDMA0 SGLREQDSTREG: WE_CH6 (Bit 14)                        */
#define GPDMA0_SGLREQDSTREG_WE_CH6_Msk        (0x4000UL)                /*!< GPDMA0 SGLREQDSTREG: WE_CH6 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQDSTREG_WE_CH7_Pos        (15UL)                    /*!< GPDMA0 SGLREQDSTREG: WE_CH7 (Bit 15)                        */
#define GPDMA0_SGLREQDSTREG_WE_CH7_Msk        (0x8000UL)                /*!< GPDMA0 SGLREQDSTREG: WE_CH7 (Bitfield-Mask: 0x01)           */

/* ------------------------------  GPDMA0_LSTSRCREG  ------------------------------ */
#define GPDMA0_LSTSRCREG_CH0_Pos              (0UL)                     /*!< GPDMA0 LSTSRCREG: CH0 (Bit 0)                               */
#define GPDMA0_LSTSRCREG_CH0_Msk              (0x1UL)                   /*!< GPDMA0 LSTSRCREG: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_CH1_Pos              (1UL)                     /*!< GPDMA0 LSTSRCREG: CH1 (Bit 1)                               */
#define GPDMA0_LSTSRCREG_CH1_Msk              (0x2UL)                   /*!< GPDMA0 LSTSRCREG: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_CH2_Pos              (2UL)                     /*!< GPDMA0 LSTSRCREG: CH2 (Bit 2)                               */
#define GPDMA0_LSTSRCREG_CH2_Msk              (0x4UL)                   /*!< GPDMA0 LSTSRCREG: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_CH3_Pos              (3UL)                     /*!< GPDMA0 LSTSRCREG: CH3 (Bit 3)                               */
#define GPDMA0_LSTSRCREG_CH3_Msk              (0x8UL)                   /*!< GPDMA0 LSTSRCREG: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_CH4_Pos              (4UL)                     /*!< GPDMA0 LSTSRCREG: CH4 (Bit 4)                               */
#define GPDMA0_LSTSRCREG_CH4_Msk              (0x10UL)                  /*!< GPDMA0 LSTSRCREG: CH4 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_CH5_Pos              (5UL)                     /*!< GPDMA0 LSTSRCREG: CH5 (Bit 5)                               */
#define GPDMA0_LSTSRCREG_CH5_Msk              (0x20UL)                  /*!< GPDMA0 LSTSRCREG: CH5 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_CH6_Pos              (6UL)                     /*!< GPDMA0 LSTSRCREG: CH6 (Bit 6)                               */
#define GPDMA0_LSTSRCREG_CH6_Msk              (0x40UL)                  /*!< GPDMA0 LSTSRCREG: CH6 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_CH7_Pos              (7UL)                     /*!< GPDMA0 LSTSRCREG: CH7 (Bit 7)                               */
#define GPDMA0_LSTSRCREG_CH7_Msk              (0x80UL)                  /*!< GPDMA0 LSTSRCREG: CH7 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_WE_CH0_Pos           (8UL)                     /*!< GPDMA0 LSTSRCREG: WE_CH0 (Bit 8)                            */
#define GPDMA0_LSTSRCREG_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA0 LSTSRCREG: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTSRCREG_WE_CH1_Pos           (9UL)                     /*!< GPDMA0 LSTSRCREG: WE_CH1 (Bit 9)                            */
#define GPDMA0_LSTSRCREG_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA0 LSTSRCREG: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTSRCREG_WE_CH2_Pos           (10UL)                    /*!< GPDMA0 LSTSRCREG: WE_CH2 (Bit 10)                           */
#define GPDMA0_LSTSRCREG_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA0 LSTSRCREG: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTSRCREG_WE_CH3_Pos           (11UL)                    /*!< GPDMA0 LSTSRCREG: WE_CH3 (Bit 11)                           */
#define GPDMA0_LSTSRCREG_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA0 LSTSRCREG: WE_CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTSRCREG_WE_CH4_Pos           (12UL)                    /*!< GPDMA0 LSTSRCREG: WE_CH4 (Bit 12)                           */
#define GPDMA0_LSTSRCREG_WE_CH4_Msk           (0x1000UL)                /*!< GPDMA0 LSTSRCREG: WE_CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTSRCREG_WE_CH5_Pos           (13UL)                    /*!< GPDMA0 LSTSRCREG: WE_CH5 (Bit 13)                           */
#define GPDMA0_LSTSRCREG_WE_CH5_Msk           (0x2000UL)                /*!< GPDMA0 LSTSRCREG: WE_CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTSRCREG_WE_CH6_Pos           (14UL)                    /*!< GPDMA0 LSTSRCREG: WE_CH6 (Bit 14)                           */
#define GPDMA0_LSTSRCREG_WE_CH6_Msk           (0x4000UL)                /*!< GPDMA0 LSTSRCREG: WE_CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTSRCREG_WE_CH7_Pos           (15UL)                    /*!< GPDMA0 LSTSRCREG: WE_CH7 (Bit 15)                           */
#define GPDMA0_LSTSRCREG_WE_CH7_Msk           (0x8000UL)                /*!< GPDMA0 LSTSRCREG: WE_CH7 (Bitfield-Mask: 0x01)              */

/* ------------------------------  GPDMA0_LSTDSTREG  ------------------------------ */
#define GPDMA0_LSTDSTREG_CH0_Pos              (0UL)                     /*!< GPDMA0 LSTDSTREG: CH0 (Bit 0)                               */
#define GPDMA0_LSTDSTREG_CH0_Msk              (0x1UL)                   /*!< GPDMA0 LSTDSTREG: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_CH1_Pos              (1UL)                     /*!< GPDMA0 LSTDSTREG: CH1 (Bit 1)                               */
#define GPDMA0_LSTDSTREG_CH1_Msk              (0x2UL)                   /*!< GPDMA0 LSTDSTREG: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_CH2_Pos              (2UL)                     /*!< GPDMA0 LSTDSTREG: CH2 (Bit 2)                               */
#define GPDMA0_LSTDSTREG_CH2_Msk              (0x4UL)                   /*!< GPDMA0 LSTDSTREG: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_CH3_Pos              (3UL)                     /*!< GPDMA0 LSTDSTREG: CH3 (Bit 3)                               */
#define GPDMA0_LSTDSTREG_CH3_Msk              (0x8UL)                   /*!< GPDMA0 LSTDSTREG: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_CH4_Pos              (4UL)                     /*!< GPDMA0 LSTDSTREG: CH4 (Bit 4)                               */
#define GPDMA0_LSTDSTREG_CH4_Msk              (0x10UL)                  /*!< GPDMA0 LSTDSTREG: CH4 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_CH5_Pos              (5UL)                     /*!< GPDMA0 LSTDSTREG: CH5 (Bit 5)                               */
#define GPDMA0_LSTDSTREG_CH5_Msk              (0x20UL)                  /*!< GPDMA0 LSTDSTREG: CH5 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_CH6_Pos              (6UL)                     /*!< GPDMA0 LSTDSTREG: CH6 (Bit 6)                               */
#define GPDMA0_LSTDSTREG_CH6_Msk              (0x40UL)                  /*!< GPDMA0 LSTDSTREG: CH6 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_CH7_Pos              (7UL)                     /*!< GPDMA0 LSTDSTREG: CH7 (Bit 7)                               */
#define GPDMA0_LSTDSTREG_CH7_Msk              (0x80UL)                  /*!< GPDMA0 LSTDSTREG: CH7 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_WE_CH0_Pos           (8UL)                     /*!< GPDMA0 LSTDSTREG: WE_CH0 (Bit 8)                            */
#define GPDMA0_LSTDSTREG_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA0 LSTDSTREG: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTDSTREG_WE_CH1_Pos           (9UL)                     /*!< GPDMA0 LSTDSTREG: WE_CH1 (Bit 9)                            */
#define GPDMA0_LSTDSTREG_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA0 LSTDSTREG: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTDSTREG_WE_CH2_Pos           (10UL)                    /*!< GPDMA0 LSTDSTREG: WE_CH2 (Bit 10)                           */
#define GPDMA0_LSTDSTREG_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA0 LSTDSTREG: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTDSTREG_WE_CH3_Pos           (11UL)                    /*!< GPDMA0 LSTDSTREG: WE_CH3 (Bit 11)                           */
#define GPDMA0_LSTDSTREG_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA0 LSTDSTREG: WE_CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTDSTREG_WE_CH4_Pos           (12UL)                    /*!< GPDMA0 LSTDSTREG: WE_CH4 (Bit 12)                           */
#define GPDMA0_LSTDSTREG_WE_CH4_Msk           (0x1000UL)                /*!< GPDMA0 LSTDSTREG: WE_CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTDSTREG_WE_CH5_Pos           (13UL)                    /*!< GPDMA0 LSTDSTREG: WE_CH5 (Bit 13)                           */
#define GPDMA0_LSTDSTREG_WE_CH5_Msk           (0x2000UL)                /*!< GPDMA0 LSTDSTREG: WE_CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTDSTREG_WE_CH6_Pos           (14UL)                    /*!< GPDMA0 LSTDSTREG: WE_CH6 (Bit 14)                           */
#define GPDMA0_LSTDSTREG_WE_CH6_Msk           (0x4000UL)                /*!< GPDMA0 LSTDSTREG: WE_CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTDSTREG_WE_CH7_Pos           (15UL)                    /*!< GPDMA0 LSTDSTREG: WE_CH7 (Bit 15)                           */
#define GPDMA0_LSTDSTREG_WE_CH7_Msk           (0x8000UL)                /*!< GPDMA0 LSTDSTREG: WE_CH7 (Bitfield-Mask: 0x01)              */

/* ------------------------------  GPDMA0_DMACFGREG  ------------------------------ */
#define GPDMA0_DMACFGREG_DMA_EN_Pos           (0UL)                     /*!< GPDMA0 DMACFGREG: DMA_EN (Bit 0)                            */
#define GPDMA0_DMACFGREG_DMA_EN_Msk           (0x1UL)                   /*!< GPDMA0 DMACFGREG: DMA_EN (Bitfield-Mask: 0x01)              */

/* -------------------------------  GPDMA0_CHENREG  ------------------------------- */
#define GPDMA0_CHENREG_CH_Pos                 (0UL)                     /*!< GPDMA0 CHENREG: CH (Bit 0)                                  */
#define GPDMA0_CHENREG_CH_Msk                 (0xffUL)                  /*!< GPDMA0 CHENREG: CH (Bitfield-Mask: 0xff)                    */
#define GPDMA0_CHENREG_WE_CH_Pos              (8UL)                     /*!< GPDMA0 CHENREG: WE_CH (Bit 8)                               */
#define GPDMA0_CHENREG_WE_CH_Msk              (0xff00UL)                /*!< GPDMA0 CHENREG: WE_CH (Bitfield-Mask: 0xff)                 */

/* ----------------------------------  GPDMA0_ID  --------------------------------- */
#define GPDMA0_ID_VALUE_Pos                   (0UL)                     /*!< GPDMA0 ID: VALUE (Bit 0)                                    */
#define GPDMA0_ID_VALUE_Msk                   (0xffffffffUL)            /*!< GPDMA0 ID: VALUE (Bitfield-Mask: 0xffffffff)                */

/* ---------------------------------  GPDMA0_TYPE  -------------------------------- */
#define GPDMA0_TYPE_VALUE_Pos                 (0UL)                     /*!< GPDMA0 TYPE: VALUE (Bit 0)                                  */
#define GPDMA0_TYPE_VALUE_Msk                 (0xffffffffUL)            /*!< GPDMA0 TYPE: VALUE (Bitfield-Mask: 0xffffffff)              */

/* -------------------------------  GPDMA0_VERSION  ------------------------------- */
#define GPDMA0_VERSION_VALUE_Pos              (0UL)                     /*!< GPDMA0 VERSION: VALUE (Bit 0)                               */
#define GPDMA0_VERSION_VALUE_Msk              (0xffffffffUL)            /*!< GPDMA0 VERSION: VALUE (Bitfield-Mask: 0xffffffff)           */


/* ================================================================================ */
/* ================      Group 'GPDMA0_CH0_1' Position & Mask      ================ */
/* ================================================================================ */


/* ------------------------------  GPDMA0_CH_SAR  ------------------------------ */
#define GPDMA0_CH_SAR_SAR_Pos              (0UL)                     /*!< GPDMA0_CH0_1 SAR: SAR (Bit 0)                               */
#define GPDMA0_CH_SAR_SAR_Msk              (0xffffffffUL)            /*!< GPDMA0_CH0_1 SAR: SAR (Bitfield-Mask: 0xffffffff)           */

/* ------------------------------  GPDMA0_CH_DAR  ------------------------------ */
#define GPDMA0_CH_DAR_DAR_Pos              (0UL)                     /*!< GPDMA0_CH0_1 DAR: DAR (Bit 0)                               */
#define GPDMA0_CH_DAR_DAR_Msk              (0xffffffffUL)            /*!< GPDMA0_CH0_1 DAR: DAR (Bitfield-Mask: 0xffffffff)           */

/* ------------------------------  GPDMA0_CH_LLP  ------------------------------ */
#define GPDMA0_CH_LLP_LOC_Pos              (2UL)                     /*!< GPDMA0_CH0_1 LLP: LOC (Bit 2)                               */
#define GPDMA0_CH_LLP_LOC_Msk              (0xfffffffcUL)            /*!< GPDMA0_CH0_1 LLP: LOC (Bitfield-Mask: 0x3fffffff)           */

/* ------------------------------  GPDMA0_CH_CTLL  ----------------------------- */
#define GPDMA0_CH_CTLL_INT_EN_Pos          (0UL)                     /*!< GPDMA0_CH0_1 CTLL: INT_EN (Bit 0)                           */
#define GPDMA0_CH_CTLL_INT_EN_Msk          (0x1UL)                   /*!< GPDMA0_CH0_1 CTLL: INT_EN (Bitfield-Mask: 0x01)             */
#define GPDMA0_CH_CTLL_DST_TR_WIDTH_Pos    (1UL)                     /*!< GPDMA0_CH0_1 CTLL: DST_TR_WIDTH (Bit 1)                     */
#define GPDMA0_CH_CTLL_DST_TR_WIDTH_Msk    (0xeUL)                   /*!< GPDMA0_CH0_1 CTLL: DST_TR_WIDTH (Bitfield-Mask: 0x07)       */
#define GPDMA0_CH_CTLL_SRC_TR_WIDTH_Pos    (4UL)                     /*!< GPDMA0_CH0_1 CTLL: SRC_TR_WIDTH (Bit 4)                     */
#define GPDMA0_CH_CTLL_SRC_TR_WIDTH_Msk    (0x70UL)                  /*!< GPDMA0_CH0_1 CTLL: SRC_TR_WIDTH (Bitfield-Mask: 0x07)       */
#define GPDMA0_CH_CTLL_DINC_Pos            (7UL)                     /*!< GPDMA0_CH0_1 CTLL: DINC (Bit 7)                             */
#define GPDMA0_CH_CTLL_DINC_Msk            (0x180UL)                 /*!< GPDMA0_CH0_1 CTLL: DINC (Bitfield-Mask: 0x03)               */
#define GPDMA0_CH_CTLL_SINC_Pos            (9UL)                     /*!< GPDMA0_CH0_1 CTLL: SINC (Bit 9)                             */
#define GPDMA0_CH_CTLL_SINC_Msk            (0x600UL)                 /*!< GPDMA0_CH0_1 CTLL: SINC (Bitfield-Mask: 0x03)               */
#define GPDMA0_CH_CTLL_DEST_MSIZE_Pos      (11UL)                    /*!< GPDMA0_CH0_1 CTLL: DEST_MSIZE (Bit 11)                      */
#define GPDMA0_CH_CTLL_DEST_MSIZE_Msk      (0x3800UL)                /*!< GPDMA0_CH0_1 CTLL: DEST_MSIZE (Bitfield-Mask: 0x07)         */
#define GPDMA0_CH_CTLL_SRC_MSIZE_Pos       (14UL)                    /*!< GPDMA0_CH0_1 CTLL: SRC_MSIZE (Bit 14)                       */
#define GPDMA0_CH_CTLL_SRC_MSIZE_Msk       (0x1c000UL)               /*!< GPDMA0_CH0_1 CTLL: SRC_MSIZE (Bitfield-Mask: 0x07)          */
#define GPDMA0_CH_CTLL_SRC_GATHER_EN_Pos   (17UL)                    /*!< GPDMA0_CH0_1 CTLL: SRC_GATHER_EN (Bit 17)                   */
#define GPDMA0_CH_CTLL_SRC_GATHER_EN_Msk   (0x20000UL)               /*!< GPDMA0_CH0_1 CTLL: SRC_GATHER_EN (Bitfield-Mask: 0x01)      */
#define GPDMA0_CH_CTLL_DST_SCATTER_EN_Pos  (18UL)                    /*!< GPDMA0_CH0_1 CTLL: DST_SCATTER_EN (Bit 18)                  */
#define GPDMA0_CH_CTLL_DST_SCATTER_EN_Msk  (0x40000UL)               /*!< GPDMA0_CH0_1 CTLL: DST_SCATTER_EN (Bitfield-Mask: 0x01)     */
#define GPDMA0_CH_CTLL_TT_FC_Pos           (20UL)                    /*!< GPDMA0_CH0_1 CTLL: TT_FC (Bit 20)                           */
#define GPDMA0_CH_CTLL_TT_FC_Msk           (0x700000UL)              /*!< GPDMA0_CH0_1 CTLL: TT_FC (Bitfield-Mask: 0x07)              */
#define GPDMA0_CH_CTLL_LLP_DST_EN_Pos      (27UL)                    /*!< GPDMA0_CH0_1 CTLL: LLP_DST_EN (Bit 27)                      */
#define GPDMA0_CH_CTLL_LLP_DST_EN_Msk      (0x8000000UL)             /*!< GPDMA0_CH0_1 CTLL: LLP_DST_EN (Bitfield-Mask: 0x01)         */
#define GPDMA0_CH_CTLL_LLP_SRC_EN_Pos      (28UL)                    /*!< GPDMA0_CH0_1 CTLL: LLP_SRC_EN (Bit 28)                      */
#define GPDMA0_CH_CTLL_LLP_SRC_EN_Msk      (0x10000000UL)            /*!< GPDMA0_CH0_1 CTLL: LLP_SRC_EN (Bitfield-Mask: 0x01)         */

/* ------------------------------  GPDMA0_CH_CTLH  ----------------------------- */
#define GPDMA0_CH_CTLH_BLOCK_TS_Pos        (0UL)                     /*!< GPDMA0_CH0_1 CTLH: BLOCK_TS (Bit 0)                         */
#define GPDMA0_CH_CTLH_BLOCK_TS_Msk        (0xfffUL)                 /*!< GPDMA0_CH0_1 CTLH: BLOCK_TS (Bitfield-Mask: 0xfff)          */
#define GPDMA0_CH_CTLH_DONE_Pos            (12UL)                    /*!< GPDMA0_CH0_1 CTLH: DONE (Bit 12)                            */
#define GPDMA0_CH_CTLH_DONE_Msk            (0x1000UL)                /*!< GPDMA0_CH0_1 CTLH: DONE (Bitfield-Mask: 0x01)               */

/* -----------------------------  GPDMA0_CH_SSTAT  ----------------------------- */
#define GPDMA0_CH_SSTAT_SSTAT_Pos          (0UL)                     /*!< GPDMA0_CH0_1 SSTAT: SSTAT (Bit 0)                           */
#define GPDMA0_CH_SSTAT_SSTAT_Msk          (0xffffffffUL)            /*!< GPDMA0_CH0_1 SSTAT: SSTAT (Bitfield-Mask: 0xffffffff)       */

/* -----------------------------  GPDMA0_CH_DSTAT  ----------------------------- */
#define GPDMA0_CH_DSTAT_DSTAT_Pos          (0UL)                     /*!< GPDMA0_CH0_1 DSTAT: DSTAT (Bit 0)                           */
#define GPDMA0_CH_DSTAT_DSTAT_Msk          (0xffffffffUL)            /*!< GPDMA0_CH0_1 DSTAT: DSTAT (Bitfield-Mask: 0xffffffff)       */

/* ----------------------------  GPDMA0_CH_SSTATAR  ---------------------------- */
#define GPDMA0_CH_SSTATAR_SSTATAR_Pos      (0UL)                     /*!< GPDMA0_CH0_1 SSTATAR: SSTATAR (Bit 0)                       */
#define GPDMA0_CH_SSTATAR_SSTATAR_Msk      (0xffffffffUL)            /*!< GPDMA0_CH0_1 SSTATAR: SSTATAR (Bitfield-Mask: 0xffffffff)   */

/* ----------------------------  GPDMA0_CH_DSTATAR  ---------------------------- */
#define GPDMA0_CH_DSTATAR_DSTATAR_Pos      (0UL)                     /*!< GPDMA0_CH0_1 DSTATAR: DSTATAR (Bit 0)                       */
#define GPDMA0_CH_DSTATAR_DSTATAR_Msk      (0xffffffffUL)            /*!< GPDMA0_CH0_1 DSTATAR: DSTATAR (Bitfield-Mask: 0xffffffff)   */

/* ------------------------------  GPDMA0_CH_CFGL  ----------------------------- */
#define GPDMA0_CH_CFGL_CH_PRIOR_Pos        (5UL)                     /*!< GPDMA0_CH0_1 CFGL: CH_PRIOR (Bit 5)                         */
#define GPDMA0_CH_CFGL_CH_PRIOR_Msk        (0xe0UL)                  /*!< GPDMA0_CH0_1 CFGL: CH_PRIOR (Bitfield-Mask: 0x07)           */
#define GPDMA0_CH_CFGL_CH_SUSP_Pos         (8UL)                     /*!< GPDMA0_CH0_1 CFGL: CH_SUSP (Bit 8)                          */
#define GPDMA0_CH_CFGL_CH_SUSP_Msk         (0x100UL)                 /*!< GPDMA0_CH0_1 CFGL: CH_SUSP (Bitfield-Mask: 0x01)            */
#define GPDMA0_CH_CFGL_FIFO_EMPTY_Pos      (9UL)                     /*!< GPDMA0_CH0_1 CFGL: FIFO_EMPTY (Bit 9)                       */
#define GPDMA0_CH_CFGL_FIFO_EMPTY_Msk      (0x200UL)                 /*!< GPDMA0_CH0_1 CFGL: FIFO_EMPTY (Bitfield-Mask: 0x01)         */
#define GPDMA0_CH_CFGL_HS_SEL_DST_Pos      (10UL)                    /*!< GPDMA0_CH0_1 CFGL: HS_SEL_DST (Bit 10)                      */
#define GPDMA0_CH_CFGL_HS_SEL_DST_Msk      (0x400UL)                 /*!< GPDMA0_CH0_1 CFGL: HS_SEL_DST (Bitfield-Mask: 0x01)         */
#define GPDMA0_CH_CFGL_HS_SEL_SRC_Pos      (11UL)                    /*!< GPDMA0_CH0_1 CFGL: HS_SEL_SRC (Bit 11)                      */
#define GPDMA0_CH_CFGL_HS_SEL_SRC_Msk      (0x800UL)                 /*!< GPDMA0_CH0_1 CFGL: HS_SEL_SRC (Bitfield-Mask: 0x01)         */
#define GPDMA0_CH_CFGL_LOCK_CH_L_Pos       (12UL)                    /*!< GPDMA0_CH0_1 CFGL: LOCK_CH_L (Bit 12)                       */
#define GPDMA0_CH_CFGL_LOCK_CH_L_Msk       (0x3000UL)                /*!< GPDMA0_CH0_1 CFGL: LOCK_CH_L (Bitfield-Mask: 0x03)          */
#define GPDMA0_CH_CFGL_LOCK_B_L_Pos        (14UL)                    /*!< GPDMA0_CH0_1 CFGL: LOCK_B_L (Bit 14)                        */
#define GPDMA0_CH_CFGL_LOCK_B_L_Msk        (0xc000UL)                /*!< GPDMA0_CH0_1 CFGL: LOCK_B_L (Bitfield-Mask: 0x03)           */
#define GPDMA0_CH_CFGL_LOCK_CH_Pos         (16UL)                    /*!< GPDMA0_CH0_1 CFGL: LOCK_CH (Bit 16)                         */
#define GPDMA0_CH_CFGL_LOCK_CH_Msk         (0x10000UL)               /*!< GPDMA0_CH0_1 CFGL: LOCK_CH (Bitfield-Mask: 0x01)            */
#define GPDMA0_CH_CFGL_LOCK_B_Pos          (17UL)                    /*!< GPDMA0_CH0_1 CFGL: LOCK_B (Bit 17)                          */
#define GPDMA0_CH_CFGL_LOCK_B_Msk          (0x20000UL)               /*!< GPDMA0_CH0_1 CFGL: LOCK_B (Bitfield-Mask: 0x01)             */
#define GPDMA0_CH_CFGL_DST_HS_POL_Pos      (18UL)                    /*!< GPDMA0_CH0_1 CFGL: DST_HS_POL (Bit 18)                      */
#define GPDMA0_CH_CFGL_DST_HS_POL_Msk      (0x40000UL)               /*!< GPDMA0_CH0_1 CFGL: DST_HS_POL (Bitfield-Mask: 0x01)         */
#define GPDMA0_CH_CFGL_SRC_HS_POL_Pos      (19UL)                    /*!< GPDMA0_CH0_1 CFGL: SRC_HS_POL (Bit 19)                      */
#define GPDMA0_CH_CFGL_SRC_HS_POL_Msk      (0x80000UL)               /*!< GPDMA0_CH0_1 CFGL: SRC_HS_POL (Bitfield-Mask: 0x01)         */
#define GPDMA0_CH_CFGL_MAX_ABRST_Pos       (20UL)                    /*!< GPDMA0_CH0_1 CFGL: MAX_ABRST (Bit 20)                       */
#define GPDMA0_CH_CFGL_MAX_ABRST_Msk       (0x3ff00000UL)            /*!< GPDMA0_CH0_1 CFGL: MAX_ABRST (Bitfield-Mask: 0x3ff)         */
#define GPDMA0_CH_CFGL_RELOAD_SRC_Pos      (30UL)                    /*!< GPDMA0_CH0_1 CFGL: RELOAD_SRC (Bit 30)                      */
#define GPDMA0_CH_CFGL_RELOAD_SRC_Msk      (0x40000000UL)            /*!< GPDMA0_CH0_1 CFGL: RELOAD_SRC (Bitfield-Mask: 0x01)         */
#define GPDMA0_CH_CFGL_RELOAD_DST_Pos      (31UL)                    /*!< GPDMA0_CH0_1 CFGL: RELOAD_DST (Bit 31)                      */
#define GPDMA0_CH_CFGL_RELOAD_DST_Msk      (0x80000000UL)            /*!< GPDMA0_CH0_1 CFGL: RELOAD_DST (Bitfield-Mask: 0x01)         */

/* ------------------------------  GPDMA0_CH_CFGH  ----------------------------- */
#define GPDMA0_CH_CFGH_FCMODE_Pos          (0UL)                     /*!< GPDMA0_CH0_1 CFGH: FCMODE (Bit 0)                           */
#define GPDMA0_CH_CFGH_FCMODE_Msk          (0x1UL)                   /*!< GPDMA0_CH0_1 CFGH: FCMODE (Bitfield-Mask: 0x01)             */
#define GPDMA0_CH_CFGH_FIFO_MODE_Pos       (1UL)                     /*!< GPDMA0_CH0_1 CFGH: FIFO_MODE (Bit 1)                        */
#define GPDMA0_CH_CFGH_FIFO_MODE_Msk       (0x2UL)                   /*!< GPDMA0_CH0_1 CFGH: FIFO_MODE (Bitfield-Mask: 0x01)          */
#define GPDMA0_CH_CFGH_PROTCTL_Pos         (2UL)                     /*!< GPDMA0_CH0_1 CFGH: PROTCTL (Bit 2)                          */
#define GPDMA0_CH_CFGH_PROTCTL_Msk         (0x1cUL)                  /*!< GPDMA0_CH0_1 CFGH: PROTCTL (Bitfield-Mask: 0x07)            */
#define GPDMA0_CH_CFGH_DS_UPD_EN_Pos       (5UL)                     /*!< GPDMA0_CH0_1 CFGH: DS_UPD_EN (Bit 5)                        */
#define GPDMA0_CH_CFGH_DS_UPD_EN_Msk       (0x20UL)                  /*!< GPDMA0_CH0_1 CFGH: DS_UPD_EN (Bitfield-Mask: 0x01)          */
#define GPDMA0_CH_CFGH_SS_UPD_EN_Pos       (6UL)                     /*!< GPDMA0_CH0_1 CFGH: SS_UPD_EN (Bit 6)                        */
#define GPDMA0_CH_CFGH_SS_UPD_EN_Msk       (0x40UL)                  /*!< GPDMA0_CH0_1 CFGH: SS_UPD_EN (Bitfield-Mask: 0x01)          */
#define GPDMA0_CH_CFGH_SRC_PER_Pos         (7UL)                     /*!< GPDMA0_CH0_1 CFGH: SRC_PER (Bit 7)                          */
#define GPDMA0_CH_CFGH_SRC_PER_Msk         (0x780UL)                 /*!< GPDMA0_CH0_1 CFGH: SRC_PER (Bitfield-Mask: 0x0f)            */
#define GPDMA0_CH_CFGH_DEST_PER_Pos        (11UL)                    /*!< GPDMA0_CH0_1 CFGH: DEST_PER (Bit 11)                        */
#define GPDMA0_CH_CFGH_DEST_PER_Msk        (0x7800UL)                /*!< GPDMA0_CH0_1 CFGH: DEST_PER (Bitfield-Mask: 0x0f)           */

/* ------------------------------  GPDMA0_CH_SGR  ------------------------------ */
#define GPDMA0_CH_SGR_SGI_Pos              (0UL)                     /*!< GPDMA0_CH0_1 SGR: SGI (Bit 0)                               */
#define GPDMA0_CH_SGR_SGI_Msk              (0xfffffUL)               /*!< GPDMA0_CH0_1 SGR: SGI (Bitfield-Mask: 0xfffff)              */
#define GPDMA0_CH_SGR_SGC_Pos              (20UL)                    /*!< GPDMA0_CH0_1 SGR: SGC (Bit 20)                              */
#define GPDMA0_CH_SGR_SGC_Msk              (0xfff00000UL)            /*!< GPDMA0_CH0_1 SGR: SGC (Bitfield-Mask: 0xfff)                */

/* ------------------------------  GPDMA0_CH_DSR  ------------------------------ */
#define GPDMA0_CH_DSR_DSI_Pos              (0UL)                     /*!< GPDMA0_CH0_1 DSR: DSI (Bit 0)                               */
#define GPDMA0_CH_DSR_DSI_Msk              (0xfffffUL)               /*!< GPDMA0_CH0_1 DSR: DSI (Bitfield-Mask: 0xfffff)              */
#define GPDMA0_CH_DSR_DSC_Pos              (20UL)                    /*!< GPDMA0_CH0_1 DSR: DSC (Bit 20)                              */
#define GPDMA0_CH_DSR_DSC_Msk              (0xfff00000UL)            /*!< GPDMA0_CH0_1 DSR: DSC (Bitfield-Mask: 0xfff)                */


/* ================================================================================ */
/* ================         struct 'GPDMA1' Position & Mask        ================ */
/* ================================================================================ */


/* --------------------------------  GPDMA1_RAWTFR  ------------------------------- */
#define GPDMA1_RAWTFR_CH0_Pos                 (0UL)                     /*!< GPDMA1 RAWTFR: CH0 (Bit 0)                                  */
#define GPDMA1_RAWTFR_CH0_Msk                 (0x1UL)                   /*!< GPDMA1 RAWTFR: CH0 (Bitfield-Mask: 0x01)                    */
#define GPDMA1_RAWTFR_CH1_Pos                 (1UL)                     /*!< GPDMA1 RAWTFR: CH1 (Bit 1)                                  */
#define GPDMA1_RAWTFR_CH1_Msk                 (0x2UL)                   /*!< GPDMA1 RAWTFR: CH1 (Bitfield-Mask: 0x01)                    */
#define GPDMA1_RAWTFR_CH2_Pos                 (2UL)                     /*!< GPDMA1 RAWTFR: CH2 (Bit 2)                                  */
#define GPDMA1_RAWTFR_CH2_Msk                 (0x4UL)                   /*!< GPDMA1 RAWTFR: CH2 (Bitfield-Mask: 0x01)                    */
#define GPDMA1_RAWTFR_CH3_Pos                 (3UL)                     /*!< GPDMA1 RAWTFR: CH3 (Bit 3)                                  */
#define GPDMA1_RAWTFR_CH3_Msk                 (0x8UL)                   /*!< GPDMA1 RAWTFR: CH3 (Bitfield-Mask: 0x01)                    */

/* -------------------------------  GPDMA1_RAWBLOCK  ------------------------------ */
#define GPDMA1_RAWBLOCK_CH0_Pos               (0UL)                     /*!< GPDMA1 RAWBLOCK: CH0 (Bit 0)                                */
#define GPDMA1_RAWBLOCK_CH0_Msk               (0x1UL)                   /*!< GPDMA1 RAWBLOCK: CH0 (Bitfield-Mask: 0x01)                  */
#define GPDMA1_RAWBLOCK_CH1_Pos               (1UL)                     /*!< GPDMA1 RAWBLOCK: CH1 (Bit 1)                                */
#define GPDMA1_RAWBLOCK_CH1_Msk               (0x2UL)                   /*!< GPDMA1 RAWBLOCK: CH1 (Bitfield-Mask: 0x01)                  */
#define GPDMA1_RAWBLOCK_CH2_Pos               (2UL)                     /*!< GPDMA1 RAWBLOCK: CH2 (Bit 2)                                */
#define GPDMA1_RAWBLOCK_CH2_Msk               (0x4UL)                   /*!< GPDMA1 RAWBLOCK: CH2 (Bitfield-Mask: 0x01)                  */
#define GPDMA1_RAWBLOCK_CH3_Pos               (3UL)                     /*!< GPDMA1 RAWBLOCK: CH3 (Bit 3)                                */
#define GPDMA1_RAWBLOCK_CH3_Msk               (0x8UL)                   /*!< GPDMA1 RAWBLOCK: CH3 (Bitfield-Mask: 0x01)                  */

/* ------------------------------  GPDMA1_RAWSRCTRAN  ----------------------------- */
#define GPDMA1_RAWSRCTRAN_CH0_Pos             (0UL)                     /*!< GPDMA1 RAWSRCTRAN: CH0 (Bit 0)                              */
#define GPDMA1_RAWSRCTRAN_CH0_Msk             (0x1UL)                   /*!< GPDMA1 RAWSRCTRAN: CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA1_RAWSRCTRAN_CH1_Pos             (1UL)                     /*!< GPDMA1 RAWSRCTRAN: CH1 (Bit 1)                              */
#define GPDMA1_RAWSRCTRAN_CH1_Msk             (0x2UL)                   /*!< GPDMA1 RAWSRCTRAN: CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA1_RAWSRCTRAN_CH2_Pos             (2UL)                     /*!< GPDMA1 RAWSRCTRAN: CH2 (Bit 2)                              */
#define GPDMA1_RAWSRCTRAN_CH2_Msk             (0x4UL)                   /*!< GPDMA1 RAWSRCTRAN: CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA1_RAWSRCTRAN_CH3_Pos             (3UL)                     /*!< GPDMA1 RAWSRCTRAN: CH3 (Bit 3)                              */
#define GPDMA1_RAWSRCTRAN_CH3_Msk             (0x8UL)                   /*!< GPDMA1 RAWSRCTRAN: CH3 (Bitfield-Mask: 0x01)                */

/* ------------------------------  GPDMA1_RAWDSTTRAN  ----------------------------- */
#define GPDMA1_RAWDSTTRAN_CH0_Pos             (0UL)                     /*!< GPDMA1 RAWDSTTRAN: CH0 (Bit 0)                              */
#define GPDMA1_RAWDSTTRAN_CH0_Msk             (0x1UL)                   /*!< GPDMA1 RAWDSTTRAN: CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA1_RAWDSTTRAN_CH1_Pos             (1UL)                     /*!< GPDMA1 RAWDSTTRAN: CH1 (Bit 1)                              */
#define GPDMA1_RAWDSTTRAN_CH1_Msk             (0x2UL)                   /*!< GPDMA1 RAWDSTTRAN: CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA1_RAWDSTTRAN_CH2_Pos             (2UL)                     /*!< GPDMA1 RAWDSTTRAN: CH2 (Bit 2)                              */
#define GPDMA1_RAWDSTTRAN_CH2_Msk             (0x4UL)                   /*!< GPDMA1 RAWDSTTRAN: CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA1_RAWDSTTRAN_CH3_Pos             (3UL)                     /*!< GPDMA1 RAWDSTTRAN: CH3 (Bit 3)                              */
#define GPDMA1_RAWDSTTRAN_CH3_Msk             (0x8UL)                   /*!< GPDMA1 RAWDSTTRAN: CH3 (Bitfield-Mask: 0x01)                */

/* --------------------------------  GPDMA1_RAWERR  ------------------------------- */
#define GPDMA1_RAWERR_CH0_Pos                 (0UL)                     /*!< GPDMA1 RAWERR: CH0 (Bit 0)                                  */
#define GPDMA1_RAWERR_CH0_Msk                 (0x1UL)                   /*!< GPDMA1 RAWERR: CH0 (Bitfield-Mask: 0x01)                    */
#define GPDMA1_RAWERR_CH1_Pos                 (1UL)                     /*!< GPDMA1 RAWERR: CH1 (Bit 1)                                  */
#define GPDMA1_RAWERR_CH1_Msk                 (0x2UL)                   /*!< GPDMA1 RAWERR: CH1 (Bitfield-Mask: 0x01)                    */
#define GPDMA1_RAWERR_CH2_Pos                 (2UL)                     /*!< GPDMA1 RAWERR: CH2 (Bit 2)                                  */
#define GPDMA1_RAWERR_CH2_Msk                 (0x4UL)                   /*!< GPDMA1 RAWERR: CH2 (Bitfield-Mask: 0x01)                    */
#define GPDMA1_RAWERR_CH3_Pos                 (3UL)                     /*!< GPDMA1 RAWERR: CH3 (Bit 3)                                  */
#define GPDMA1_RAWERR_CH3_Msk                 (0x8UL)                   /*!< GPDMA1 RAWERR: CH3 (Bitfield-Mask: 0x01)                    */

/* ------------------------------  GPDMA1_STATUSTFR  ------------------------------ */
#define GPDMA1_STATUSTFR_CH0_Pos              (0UL)                     /*!< GPDMA1 STATUSTFR: CH0 (Bit 0)                               */
#define GPDMA1_STATUSTFR_CH0_Msk              (0x1UL)                   /*!< GPDMA1 STATUSTFR: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_STATUSTFR_CH1_Pos              (1UL)                     /*!< GPDMA1 STATUSTFR: CH1 (Bit 1)                               */
#define GPDMA1_STATUSTFR_CH1_Msk              (0x2UL)                   /*!< GPDMA1 STATUSTFR: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_STATUSTFR_CH2_Pos              (2UL)                     /*!< GPDMA1 STATUSTFR: CH2 (Bit 2)                               */
#define GPDMA1_STATUSTFR_CH2_Msk              (0x4UL)                   /*!< GPDMA1 STATUSTFR: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_STATUSTFR_CH3_Pos              (3UL)                     /*!< GPDMA1 STATUSTFR: CH3 (Bit 3)                               */
#define GPDMA1_STATUSTFR_CH3_Msk              (0x8UL)                   /*!< GPDMA1 STATUSTFR: CH3 (Bitfield-Mask: 0x01)                 */

/* -----------------------------  GPDMA1_STATUSBLOCK  ----------------------------- */
#define GPDMA1_STATUSBLOCK_CH0_Pos            (0UL)                     /*!< GPDMA1 STATUSBLOCK: CH0 (Bit 0)                             */
#define GPDMA1_STATUSBLOCK_CH0_Msk            (0x1UL)                   /*!< GPDMA1 STATUSBLOCK: CH0 (Bitfield-Mask: 0x01)               */
#define GPDMA1_STATUSBLOCK_CH1_Pos            (1UL)                     /*!< GPDMA1 STATUSBLOCK: CH1 (Bit 1)                             */
#define GPDMA1_STATUSBLOCK_CH1_Msk            (0x2UL)                   /*!< GPDMA1 STATUSBLOCK: CH1 (Bitfield-Mask: 0x01)               */
#define GPDMA1_STATUSBLOCK_CH2_Pos            (2UL)                     /*!< GPDMA1 STATUSBLOCK: CH2 (Bit 2)                             */
#define GPDMA1_STATUSBLOCK_CH2_Msk            (0x4UL)                   /*!< GPDMA1 STATUSBLOCK: CH2 (Bitfield-Mask: 0x01)               */
#define GPDMA1_STATUSBLOCK_CH3_Pos            (3UL)                     /*!< GPDMA1 STATUSBLOCK: CH3 (Bit 3)                             */
#define GPDMA1_STATUSBLOCK_CH3_Msk            (0x8UL)                   /*!< GPDMA1 STATUSBLOCK: CH3 (Bitfield-Mask: 0x01)               */

/* ----------------------------  GPDMA1_STATUSSRCTRAN  ---------------------------- */
#define GPDMA1_STATUSSRCTRAN_CH0_Pos          (0UL)                     /*!< GPDMA1 STATUSSRCTRAN: CH0 (Bit 0)                           */
#define GPDMA1_STATUSSRCTRAN_CH0_Msk          (0x1UL)                   /*!< GPDMA1 STATUSSRCTRAN: CH0 (Bitfield-Mask: 0x01)             */
#define GPDMA1_STATUSSRCTRAN_CH1_Pos          (1UL)                     /*!< GPDMA1 STATUSSRCTRAN: CH1 (Bit 1)                           */
#define GPDMA1_STATUSSRCTRAN_CH1_Msk          (0x2UL)                   /*!< GPDMA1 STATUSSRCTRAN: CH1 (Bitfield-Mask: 0x01)             */
#define GPDMA1_STATUSSRCTRAN_CH2_Pos          (2UL)                     /*!< GPDMA1 STATUSSRCTRAN: CH2 (Bit 2)                           */
#define GPDMA1_STATUSSRCTRAN_CH2_Msk          (0x4UL)                   /*!< GPDMA1 STATUSSRCTRAN: CH2 (Bitfield-Mask: 0x01)             */
#define GPDMA1_STATUSSRCTRAN_CH3_Pos          (3UL)                     /*!< GPDMA1 STATUSSRCTRAN: CH3 (Bit 3)                           */
#define GPDMA1_STATUSSRCTRAN_CH3_Msk          (0x8UL)                   /*!< GPDMA1 STATUSSRCTRAN: CH3 (Bitfield-Mask: 0x01)             */

/* ----------------------------  GPDMA1_STATUSDSTTRAN  ---------------------------- */
#define GPDMA1_STATUSDSTTRAN_CH0_Pos          (0UL)                     /*!< GPDMA1 STATUSDSTTRAN: CH0 (Bit 0)                           */
#define GPDMA1_STATUSDSTTRAN_CH0_Msk          (0x1UL)                   /*!< GPDMA1 STATUSDSTTRAN: CH0 (Bitfield-Mask: 0x01)             */
#define GPDMA1_STATUSDSTTRAN_CH1_Pos          (1UL)                     /*!< GPDMA1 STATUSDSTTRAN: CH1 (Bit 1)                           */
#define GPDMA1_STATUSDSTTRAN_CH1_Msk          (0x2UL)                   /*!< GPDMA1 STATUSDSTTRAN: CH1 (Bitfield-Mask: 0x01)             */
#define GPDMA1_STATUSDSTTRAN_CH2_Pos          (2UL)                     /*!< GPDMA1 STATUSDSTTRAN: CH2 (Bit 2)                           */
#define GPDMA1_STATUSDSTTRAN_CH2_Msk          (0x4UL)                   /*!< GPDMA1 STATUSDSTTRAN: CH2 (Bitfield-Mask: 0x01)             */
#define GPDMA1_STATUSDSTTRAN_CH3_Pos          (3UL)                     /*!< GPDMA1 STATUSDSTTRAN: CH3 (Bit 3)                           */
#define GPDMA1_STATUSDSTTRAN_CH3_Msk          (0x8UL)                   /*!< GPDMA1 STATUSDSTTRAN: CH3 (Bitfield-Mask: 0x01)             */

/* ------------------------------  GPDMA1_STATUSERR  ------------------------------ */
#define GPDMA1_STATUSERR_CH0_Pos              (0UL)                     /*!< GPDMA1 STATUSERR: CH0 (Bit 0)                               */
#define GPDMA1_STATUSERR_CH0_Msk              (0x1UL)                   /*!< GPDMA1 STATUSERR: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_STATUSERR_CH1_Pos              (1UL)                     /*!< GPDMA1 STATUSERR: CH1 (Bit 1)                               */
#define GPDMA1_STATUSERR_CH1_Msk              (0x2UL)                   /*!< GPDMA1 STATUSERR: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_STATUSERR_CH2_Pos              (2UL)                     /*!< GPDMA1 STATUSERR: CH2 (Bit 2)                               */
#define GPDMA1_STATUSERR_CH2_Msk              (0x4UL)                   /*!< GPDMA1 STATUSERR: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_STATUSERR_CH3_Pos              (3UL)                     /*!< GPDMA1 STATUSERR: CH3 (Bit 3)                               */
#define GPDMA1_STATUSERR_CH3_Msk              (0x8UL)                   /*!< GPDMA1 STATUSERR: CH3 (Bitfield-Mask: 0x01)                 */

/* -------------------------------  GPDMA1_MASKTFR  ------------------------------- */
#define GPDMA1_MASKTFR_CH0_Pos                (0UL)                     /*!< GPDMA1 MASKTFR: CH0 (Bit 0)                                 */
#define GPDMA1_MASKTFR_CH0_Msk                (0x1UL)                   /*!< GPDMA1 MASKTFR: CH0 (Bitfield-Mask: 0x01)                   */
#define GPDMA1_MASKTFR_CH1_Pos                (1UL)                     /*!< GPDMA1 MASKTFR: CH1 (Bit 1)                                 */
#define GPDMA1_MASKTFR_CH1_Msk                (0x2UL)                   /*!< GPDMA1 MASKTFR: CH1 (Bitfield-Mask: 0x01)                   */
#define GPDMA1_MASKTFR_CH2_Pos                (2UL)                     /*!< GPDMA1 MASKTFR: CH2 (Bit 2)                                 */
#define GPDMA1_MASKTFR_CH2_Msk                (0x4UL)                   /*!< GPDMA1 MASKTFR: CH2 (Bitfield-Mask: 0x01)                   */
#define GPDMA1_MASKTFR_CH3_Pos                (3UL)                     /*!< GPDMA1 MASKTFR: CH3 (Bit 3)                                 */
#define GPDMA1_MASKTFR_CH3_Msk                (0x8UL)                   /*!< GPDMA1 MASKTFR: CH3 (Bitfield-Mask: 0x01)                   */
#define GPDMA1_MASKTFR_WE_CH0_Pos             (8UL)                     /*!< GPDMA1 MASKTFR: WE_CH0 (Bit 8)                              */
#define GPDMA1_MASKTFR_WE_CH0_Msk             (0x100UL)                 /*!< GPDMA1 MASKTFR: WE_CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA1_MASKTFR_WE_CH1_Pos             (9UL)                     /*!< GPDMA1 MASKTFR: WE_CH1 (Bit 9)                              */
#define GPDMA1_MASKTFR_WE_CH1_Msk             (0x200UL)                 /*!< GPDMA1 MASKTFR: WE_CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA1_MASKTFR_WE_CH2_Pos             (10UL)                    /*!< GPDMA1 MASKTFR: WE_CH2 (Bit 10)                             */
#define GPDMA1_MASKTFR_WE_CH2_Msk             (0x400UL)                 /*!< GPDMA1 MASKTFR: WE_CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA1_MASKTFR_WE_CH3_Pos             (11UL)                    /*!< GPDMA1 MASKTFR: WE_CH3 (Bit 11)                             */
#define GPDMA1_MASKTFR_WE_CH3_Msk             (0x800UL)                 /*!< GPDMA1 MASKTFR: WE_CH3 (Bitfield-Mask: 0x01)                */

/* ------------------------------  GPDMA1_MASKBLOCK  ------------------------------ */
#define GPDMA1_MASKBLOCK_CH0_Pos              (0UL)                     /*!< GPDMA1 MASKBLOCK: CH0 (Bit 0)                               */
#define GPDMA1_MASKBLOCK_CH0_Msk              (0x1UL)                   /*!< GPDMA1 MASKBLOCK: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_MASKBLOCK_CH1_Pos              (1UL)                     /*!< GPDMA1 MASKBLOCK: CH1 (Bit 1)                               */
#define GPDMA1_MASKBLOCK_CH1_Msk              (0x2UL)                   /*!< GPDMA1 MASKBLOCK: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_MASKBLOCK_CH2_Pos              (2UL)                     /*!< GPDMA1 MASKBLOCK: CH2 (Bit 2)                               */
#define GPDMA1_MASKBLOCK_CH2_Msk              (0x4UL)                   /*!< GPDMA1 MASKBLOCK: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_MASKBLOCK_CH3_Pos              (3UL)                     /*!< GPDMA1 MASKBLOCK: CH3 (Bit 3)                               */
#define GPDMA1_MASKBLOCK_CH3_Msk              (0x8UL)                   /*!< GPDMA1 MASKBLOCK: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_MASKBLOCK_WE_CH0_Pos           (8UL)                     /*!< GPDMA1 MASKBLOCK: WE_CH0 (Bit 8)                            */
#define GPDMA1_MASKBLOCK_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA1 MASKBLOCK: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA1_MASKBLOCK_WE_CH1_Pos           (9UL)                     /*!< GPDMA1 MASKBLOCK: WE_CH1 (Bit 9)                            */
#define GPDMA1_MASKBLOCK_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA1 MASKBLOCK: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA1_MASKBLOCK_WE_CH2_Pos           (10UL)                    /*!< GPDMA1 MASKBLOCK: WE_CH2 (Bit 10)                           */
#define GPDMA1_MASKBLOCK_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA1 MASKBLOCK: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA1_MASKBLOCK_WE_CH3_Pos           (11UL)                    /*!< GPDMA1 MASKBLOCK: WE_CH3 (Bit 11)                           */
#define GPDMA1_MASKBLOCK_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA1 MASKBLOCK: WE_CH3 (Bitfield-Mask: 0x01)              */

/* -----------------------------  GPDMA1_MASKSRCTRAN  ----------------------------- */
#define GPDMA1_MASKSRCTRAN_CH0_Pos            (0UL)                     /*!< GPDMA1 MASKSRCTRAN: CH0 (Bit 0)                             */
#define GPDMA1_MASKSRCTRAN_CH0_Msk            (0x1UL)                   /*!< GPDMA1 MASKSRCTRAN: CH0 (Bitfield-Mask: 0x01)               */
#define GPDMA1_MASKSRCTRAN_CH1_Pos            (1UL)                     /*!< GPDMA1 MASKSRCTRAN: CH1 (Bit 1)                             */
#define GPDMA1_MASKSRCTRAN_CH1_Msk            (0x2UL)                   /*!< GPDMA1 MASKSRCTRAN: CH1 (Bitfield-Mask: 0x01)               */
#define GPDMA1_MASKSRCTRAN_CH2_Pos            (2UL)                     /*!< GPDMA1 MASKSRCTRAN: CH2 (Bit 2)                             */
#define GPDMA1_MASKSRCTRAN_CH2_Msk            (0x4UL)                   /*!< GPDMA1 MASKSRCTRAN: CH2 (Bitfield-Mask: 0x01)               */
#define GPDMA1_MASKSRCTRAN_CH3_Pos            (3UL)                     /*!< GPDMA1 MASKSRCTRAN: CH3 (Bit 3)                             */
#define GPDMA1_MASKSRCTRAN_CH3_Msk            (0x8UL)                   /*!< GPDMA1 MASKSRCTRAN: CH3 (Bitfield-Mask: 0x01)               */
#define GPDMA1_MASKSRCTRAN_WE_CH0_Pos         (8UL)                     /*!< GPDMA1 MASKSRCTRAN: WE_CH0 (Bit 8)                          */
#define GPDMA1_MASKSRCTRAN_WE_CH0_Msk         (0x100UL)                 /*!< GPDMA1 MASKSRCTRAN: WE_CH0 (Bitfield-Mask: 0x01)            */
#define GPDMA1_MASKSRCTRAN_WE_CH1_Pos         (9UL)                     /*!< GPDMA1 MASKSRCTRAN: WE_CH1 (Bit 9)                          */
#define GPDMA1_MASKSRCTRAN_WE_CH1_Msk         (0x200UL)                 /*!< GPDMA1 MASKSRCTRAN: WE_CH1 (Bitfield-Mask: 0x01)            */
#define GPDMA1_MASKSRCTRAN_WE_CH2_Pos         (10UL)                    /*!< GPDMA1 MASKSRCTRAN: WE_CH2 (Bit 10)                         */
#define GPDMA1_MASKSRCTRAN_WE_CH2_Msk         (0x400UL)                 /*!< GPDMA1 MASKSRCTRAN: WE_CH2 (Bitfield-Mask: 0x01)            */
#define GPDMA1_MASKSRCTRAN_WE_CH3_Pos         (11UL)                    /*!< GPDMA1 MASKSRCTRAN: WE_CH3 (Bit 11)                         */
#define GPDMA1_MASKSRCTRAN_WE_CH3_Msk         (0x800UL)                 /*!< GPDMA1 MASKSRCTRAN: WE_CH3 (Bitfield-Mask: 0x01)            */

/* -----------------------------  GPDMA1_MASKDSTTRAN  ----------------------------- */
#define GPDMA1_MASKDSTTRAN_CH0_Pos            (0UL)                     /*!< GPDMA1 MASKDSTTRAN: CH0 (Bit 0)                             */
#define GPDMA1_MASKDSTTRAN_CH0_Msk            (0x1UL)                   /*!< GPDMA1 MASKDSTTRAN: CH0 (Bitfield-Mask: 0x01)               */
#define GPDMA1_MASKDSTTRAN_CH1_Pos            (1UL)                     /*!< GPDMA1 MASKDSTTRAN: CH1 (Bit 1)                             */
#define GPDMA1_MASKDSTTRAN_CH1_Msk            (0x2UL)                   /*!< GPDMA1 MASKDSTTRAN: CH1 (Bitfield-Mask: 0x01)               */
#define GPDMA1_MASKDSTTRAN_CH2_Pos            (2UL)                     /*!< GPDMA1 MASKDSTTRAN: CH2 (Bit 2)                             */
#define GPDMA1_MASKDSTTRAN_CH2_Msk            (0x4UL)                   /*!< GPDMA1 MASKDSTTRAN: CH2 (Bitfield-Mask: 0x01)               */
#define GPDMA1_MASKDSTTRAN_CH3_Pos            (3UL)                     /*!< GPDMA1 MASKDSTTRAN: CH3 (Bit 3)                             */
#define GPDMA1_MASKDSTTRAN_CH3_Msk            (0x8UL)                   /*!< GPDMA1 MASKDSTTRAN: CH3 (Bitfield-Mask: 0x01)               */
#define GPDMA1_MASKDSTTRAN_WE_CH0_Pos         (8UL)                     /*!< GPDMA1 MASKDSTTRAN: WE_CH0 (Bit 8)                          */
#define GPDMA1_MASKDSTTRAN_WE_CH0_Msk         (0x100UL)                 /*!< GPDMA1 MASKDSTTRAN: WE_CH0 (Bitfield-Mask: 0x01)            */
#define GPDMA1_MASKDSTTRAN_WE_CH1_Pos         (9UL)                     /*!< GPDMA1 MASKDSTTRAN: WE_CH1 (Bit 9)                          */
#define GPDMA1_MASKDSTTRAN_WE_CH1_Msk         (0x200UL)                 /*!< GPDMA1 MASKDSTTRAN: WE_CH1 (Bitfield-Mask: 0x01)            */
#define GPDMA1_MASKDSTTRAN_WE_CH2_Pos         (10UL)                    /*!< GPDMA1 MASKDSTTRAN: WE_CH2 (Bit 10)                         */
#define GPDMA1_MASKDSTTRAN_WE_CH2_Msk         (0x400UL)                 /*!< GPDMA1 MASKDSTTRAN: WE_CH2 (Bitfield-Mask: 0x01)            */
#define GPDMA1_MASKDSTTRAN_WE_CH3_Pos         (11UL)                    /*!< GPDMA1 MASKDSTTRAN: WE_CH3 (Bit 11)                         */
#define GPDMA1_MASKDSTTRAN_WE_CH3_Msk         (0x800UL)                 /*!< GPDMA1 MASKDSTTRAN: WE_CH3 (Bitfield-Mask: 0x01)            */

/* -------------------------------  GPDMA1_MASKERR  ------------------------------- */
#define GPDMA1_MASKERR_CH0_Pos                (0UL)                     /*!< GPDMA1 MASKERR: CH0 (Bit 0)                                 */
#define GPDMA1_MASKERR_CH0_Msk                (0x1UL)                   /*!< GPDMA1 MASKERR: CH0 (Bitfield-Mask: 0x01)                   */
#define GPDMA1_MASKERR_CH1_Pos                (1UL)                     /*!< GPDMA1 MASKERR: CH1 (Bit 1)                                 */
#define GPDMA1_MASKERR_CH1_Msk                (0x2UL)                   /*!< GPDMA1 MASKERR: CH1 (Bitfield-Mask: 0x01)                   */
#define GPDMA1_MASKERR_CH2_Pos                (2UL)                     /*!< GPDMA1 MASKERR: CH2 (Bit 2)                                 */
#define GPDMA1_MASKERR_CH2_Msk                (0x4UL)                   /*!< GPDMA1 MASKERR: CH2 (Bitfield-Mask: 0x01)                   */
#define GPDMA1_MASKERR_CH3_Pos                (3UL)                     /*!< GPDMA1 MASKERR: CH3 (Bit 3)                                 */
#define GPDMA1_MASKERR_CH3_Msk                (0x8UL)                   /*!< GPDMA1 MASKERR: CH3 (Bitfield-Mask: 0x01)                   */
#define GPDMA1_MASKERR_WE_CH0_Pos             (8UL)                     /*!< GPDMA1 MASKERR: WE_CH0 (Bit 8)                              */
#define GPDMA1_MASKERR_WE_CH0_Msk             (0x100UL)                 /*!< GPDMA1 MASKERR: WE_CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA1_MASKERR_WE_CH1_Pos             (9UL)                     /*!< GPDMA1 MASKERR: WE_CH1 (Bit 9)                              */
#define GPDMA1_MASKERR_WE_CH1_Msk             (0x200UL)                 /*!< GPDMA1 MASKERR: WE_CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA1_MASKERR_WE_CH2_Pos             (10UL)                    /*!< GPDMA1 MASKERR: WE_CH2 (Bit 10)                             */
#define GPDMA1_MASKERR_WE_CH2_Msk             (0x400UL)                 /*!< GPDMA1 MASKERR: WE_CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA1_MASKERR_WE_CH3_Pos             (11UL)                    /*!< GPDMA1 MASKERR: WE_CH3 (Bit 11)                             */
#define GPDMA1_MASKERR_WE_CH3_Msk             (0x800UL)                 /*!< GPDMA1 MASKERR: WE_CH3 (Bitfield-Mask: 0x01)                */

/* -------------------------------  GPDMA1_CLEARTFR  ------------------------------ */
#define GPDMA1_CLEARTFR_CH0_Pos               (0UL)                     /*!< GPDMA1 CLEARTFR: CH0 (Bit 0)                                */
#define GPDMA1_CLEARTFR_CH0_Msk               (0x1UL)                   /*!< GPDMA1 CLEARTFR: CH0 (Bitfield-Mask: 0x01)                  */
#define GPDMA1_CLEARTFR_CH1_Pos               (1UL)                     /*!< GPDMA1 CLEARTFR: CH1 (Bit 1)                                */
#define GPDMA1_CLEARTFR_CH1_Msk               (0x2UL)                   /*!< GPDMA1 CLEARTFR: CH1 (Bitfield-Mask: 0x01)                  */
#define GPDMA1_CLEARTFR_CH2_Pos               (2UL)                     /*!< GPDMA1 CLEARTFR: CH2 (Bit 2)                                */
#define GPDMA1_CLEARTFR_CH2_Msk               (0x4UL)                   /*!< GPDMA1 CLEARTFR: CH2 (Bitfield-Mask: 0x01)                  */
#define GPDMA1_CLEARTFR_CH3_Pos               (3UL)                     /*!< GPDMA1 CLEARTFR: CH3 (Bit 3)                                */
#define GPDMA1_CLEARTFR_CH3_Msk               (0x8UL)                   /*!< GPDMA1 CLEARTFR: CH3 (Bitfield-Mask: 0x01)                  */

/* ------------------------------  GPDMA1_CLEARBLOCK  ----------------------------- */
#define GPDMA1_CLEARBLOCK_CH0_Pos             (0UL)                     /*!< GPDMA1 CLEARBLOCK: CH0 (Bit 0)                              */
#define GPDMA1_CLEARBLOCK_CH0_Msk             (0x1UL)                   /*!< GPDMA1 CLEARBLOCK: CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA1_CLEARBLOCK_CH1_Pos             (1UL)                     /*!< GPDMA1 CLEARBLOCK: CH1 (Bit 1)                              */
#define GPDMA1_CLEARBLOCK_CH1_Msk             (0x2UL)                   /*!< GPDMA1 CLEARBLOCK: CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA1_CLEARBLOCK_CH2_Pos             (2UL)                     /*!< GPDMA1 CLEARBLOCK: CH2 (Bit 2)                              */
#define GPDMA1_CLEARBLOCK_CH2_Msk             (0x4UL)                   /*!< GPDMA1 CLEARBLOCK: CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA1_CLEARBLOCK_CH3_Pos             (3UL)                     /*!< GPDMA1 CLEARBLOCK: CH3 (Bit 3)                              */
#define GPDMA1_CLEARBLOCK_CH3_Msk             (0x8UL)                   /*!< GPDMA1 CLEARBLOCK: CH3 (Bitfield-Mask: 0x01)                */

/* -----------------------------  GPDMA1_CLEARSRCTRAN  ---------------------------- */
#define GPDMA1_CLEARSRCTRAN_CH0_Pos           (0UL)                     /*!< GPDMA1 CLEARSRCTRAN: CH0 (Bit 0)                            */
#define GPDMA1_CLEARSRCTRAN_CH0_Msk           (0x1UL)                   /*!< GPDMA1 CLEARSRCTRAN: CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA1_CLEARSRCTRAN_CH1_Pos           (1UL)                     /*!< GPDMA1 CLEARSRCTRAN: CH1 (Bit 1)                            */
#define GPDMA1_CLEARSRCTRAN_CH1_Msk           (0x2UL)                   /*!< GPDMA1 CLEARSRCTRAN: CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA1_CLEARSRCTRAN_CH2_Pos           (2UL)                     /*!< GPDMA1 CLEARSRCTRAN: CH2 (Bit 2)                            */
#define GPDMA1_CLEARSRCTRAN_CH2_Msk           (0x4UL)                   /*!< GPDMA1 CLEARSRCTRAN: CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA1_CLEARSRCTRAN_CH3_Pos           (3UL)                     /*!< GPDMA1 CLEARSRCTRAN: CH3 (Bit 3)                            */
#define GPDMA1_CLEARSRCTRAN_CH3_Msk           (0x8UL)                   /*!< GPDMA1 CLEARSRCTRAN: CH3 (Bitfield-Mask: 0x01)              */

/* -----------------------------  GPDMA1_CLEARDSTTRAN  ---------------------------- */
#define GPDMA1_CLEARDSTTRAN_CH0_Pos           (0UL)                     /*!< GPDMA1 CLEARDSTTRAN: CH0 (Bit 0)                            */
#define GPDMA1_CLEARDSTTRAN_CH0_Msk           (0x1UL)                   /*!< GPDMA1 CLEARDSTTRAN: CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA1_CLEARDSTTRAN_CH1_Pos           (1UL)                     /*!< GPDMA1 CLEARDSTTRAN: CH1 (Bit 1)                            */
#define GPDMA1_CLEARDSTTRAN_CH1_Msk           (0x2UL)                   /*!< GPDMA1 CLEARDSTTRAN: CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA1_CLEARDSTTRAN_CH2_Pos           (2UL)                     /*!< GPDMA1 CLEARDSTTRAN: CH2 (Bit 2)                            */
#define GPDMA1_CLEARDSTTRAN_CH2_Msk           (0x4UL)                   /*!< GPDMA1 CLEARDSTTRAN: CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA1_CLEARDSTTRAN_CH3_Pos           (3UL)                     /*!< GPDMA1 CLEARDSTTRAN: CH3 (Bit 3)                            */
#define GPDMA1_CLEARDSTTRAN_CH3_Msk           (0x8UL)                   /*!< GPDMA1 CLEARDSTTRAN: CH3 (Bitfield-Mask: 0x01)              */

/* -------------------------------  GPDMA1_CLEARERR  ------------------------------ */
#define GPDMA1_CLEARERR_CH0_Pos               (0UL)                     /*!< GPDMA1 CLEARERR: CH0 (Bit 0)                                */
#define GPDMA1_CLEARERR_CH0_Msk               (0x1UL)                   /*!< GPDMA1 CLEARERR: CH0 (Bitfield-Mask: 0x01)                  */
#define GPDMA1_CLEARERR_CH1_Pos               (1UL)                     /*!< GPDMA1 CLEARERR: CH1 (Bit 1)                                */
#define GPDMA1_CLEARERR_CH1_Msk               (0x2UL)                   /*!< GPDMA1 CLEARERR: CH1 (Bitfield-Mask: 0x01)                  */
#define GPDMA1_CLEARERR_CH2_Pos               (2UL)                     /*!< GPDMA1 CLEARERR: CH2 (Bit 2)                                */
#define GPDMA1_CLEARERR_CH2_Msk               (0x4UL)                   /*!< GPDMA1 CLEARERR: CH2 (Bitfield-Mask: 0x01)                  */
#define GPDMA1_CLEARERR_CH3_Pos               (3UL)                     /*!< GPDMA1 CLEARERR: CH3 (Bit 3)                                */
#define GPDMA1_CLEARERR_CH3_Msk               (0x8UL)                   /*!< GPDMA1 CLEARERR: CH3 (Bitfield-Mask: 0x01)                  */

/* ------------------------------  GPDMA1_STATUSINT  ------------------------------ */
#define GPDMA1_STATUSINT_TFR_Pos              (0UL)                     /*!< GPDMA1 STATUSINT: TFR (Bit 0)                               */
#define GPDMA1_STATUSINT_TFR_Msk              (0x1UL)                   /*!< GPDMA1 STATUSINT: TFR (Bitfield-Mask: 0x01)                 */
#define GPDMA1_STATUSINT_BLOCK_Pos            (1UL)                     /*!< GPDMA1 STATUSINT: BLOCK (Bit 1)                             */
#define GPDMA1_STATUSINT_BLOCK_Msk            (0x2UL)                   /*!< GPDMA1 STATUSINT: BLOCK (Bitfield-Mask: 0x01)               */
#define GPDMA1_STATUSINT_SRCT_Pos             (2UL)                     /*!< GPDMA1 STATUSINT: SRCT (Bit 2)                              */
#define GPDMA1_STATUSINT_SRCT_Msk             (0x4UL)                   /*!< GPDMA1 STATUSINT: SRCT (Bitfield-Mask: 0x01)                */
#define GPDMA1_STATUSINT_DSTT_Pos             (3UL)                     /*!< GPDMA1 STATUSINT: DSTT (Bit 3)                              */
#define GPDMA1_STATUSINT_DSTT_Msk             (0x8UL)                   /*!< GPDMA1 STATUSINT: DSTT (Bitfield-Mask: 0x01)                */
#define GPDMA1_STATUSINT_ERR_Pos              (4UL)                     /*!< GPDMA1 STATUSINT: ERR (Bit 4)                               */
#define GPDMA1_STATUSINT_ERR_Msk              (0x10UL)                  /*!< GPDMA1 STATUSINT: ERR (Bitfield-Mask: 0x01)                 */

/* ------------------------------  GPDMA1_REQSRCREG  ------------------------------ */
#define GPDMA1_REQSRCREG_CH0_Pos              (0UL)                     /*!< GPDMA1 REQSRCREG: CH0 (Bit 0)                               */
#define GPDMA1_REQSRCREG_CH0_Msk              (0x1UL)                   /*!< GPDMA1 REQSRCREG: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_REQSRCREG_CH1_Pos              (1UL)                     /*!< GPDMA1 REQSRCREG: CH1 (Bit 1)                               */
#define GPDMA1_REQSRCREG_CH1_Msk              (0x2UL)                   /*!< GPDMA1 REQSRCREG: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_REQSRCREG_CH2_Pos              (2UL)                     /*!< GPDMA1 REQSRCREG: CH2 (Bit 2)                               */
#define GPDMA1_REQSRCREG_CH2_Msk              (0x4UL)                   /*!< GPDMA1 REQSRCREG: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_REQSRCREG_CH3_Pos              (3UL)                     /*!< GPDMA1 REQSRCREG: CH3 (Bit 3)                               */
#define GPDMA1_REQSRCREG_CH3_Msk              (0x8UL)                   /*!< GPDMA1 REQSRCREG: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_REQSRCREG_WE_CH0_Pos           (8UL)                     /*!< GPDMA1 REQSRCREG: WE_CH0 (Bit 8)                            */
#define GPDMA1_REQSRCREG_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA1 REQSRCREG: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA1_REQSRCREG_WE_CH1_Pos           (9UL)                     /*!< GPDMA1 REQSRCREG: WE_CH1 (Bit 9)                            */
#define GPDMA1_REQSRCREG_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA1 REQSRCREG: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA1_REQSRCREG_WE_CH2_Pos           (10UL)                    /*!< GPDMA1 REQSRCREG: WE_CH2 (Bit 10)                           */
#define GPDMA1_REQSRCREG_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA1 REQSRCREG: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA1_REQSRCREG_WE_CH3_Pos           (11UL)                    /*!< GPDMA1 REQSRCREG: WE_CH3 (Bit 11)                           */
#define GPDMA1_REQSRCREG_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA1 REQSRCREG: WE_CH3 (Bitfield-Mask: 0x01)              */

/* ------------------------------  GPDMA1_REQDSTREG  ------------------------------ */
#define GPDMA1_REQDSTREG_CH0_Pos              (0UL)                     /*!< GPDMA1 REQDSTREG: CH0 (Bit 0)                               */
#define GPDMA1_REQDSTREG_CH0_Msk              (0x1UL)                   /*!< GPDMA1 REQDSTREG: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_REQDSTREG_CH1_Pos              (1UL)                     /*!< GPDMA1 REQDSTREG: CH1 (Bit 1)                               */
#define GPDMA1_REQDSTREG_CH1_Msk              (0x2UL)                   /*!< GPDMA1 REQDSTREG: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_REQDSTREG_CH2_Pos              (2UL)                     /*!< GPDMA1 REQDSTREG: CH2 (Bit 2)                               */
#define GPDMA1_REQDSTREG_CH2_Msk              (0x4UL)                   /*!< GPDMA1 REQDSTREG: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_REQDSTREG_CH3_Pos              (3UL)                     /*!< GPDMA1 REQDSTREG: CH3 (Bit 3)                               */
#define GPDMA1_REQDSTREG_CH3_Msk              (0x8UL)                   /*!< GPDMA1 REQDSTREG: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_REQDSTREG_WE_CH0_Pos           (8UL)                     /*!< GPDMA1 REQDSTREG: WE_CH0 (Bit 8)                            */
#define GPDMA1_REQDSTREG_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA1 REQDSTREG: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA1_REQDSTREG_WE_CH1_Pos           (9UL)                     /*!< GPDMA1 REQDSTREG: WE_CH1 (Bit 9)                            */
#define GPDMA1_REQDSTREG_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA1 REQDSTREG: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA1_REQDSTREG_WE_CH2_Pos           (10UL)                    /*!< GPDMA1 REQDSTREG: WE_CH2 (Bit 10)                           */
#define GPDMA1_REQDSTREG_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA1 REQDSTREG: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA1_REQDSTREG_WE_CH3_Pos           (11UL)                    /*!< GPDMA1 REQDSTREG: WE_CH3 (Bit 11)                           */
#define GPDMA1_REQDSTREG_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA1 REQDSTREG: WE_CH3 (Bitfield-Mask: 0x01)              */

/* -----------------------------  GPDMA1_SGLREQSRCREG  ---------------------------- */
#define GPDMA1_SGLREQSRCREG_CH0_Pos           (0UL)                     /*!< GPDMA1 SGLREQSRCREG: CH0 (Bit 0)                            */
#define GPDMA1_SGLREQSRCREG_CH0_Msk           (0x1UL)                   /*!< GPDMA1 SGLREQSRCREG: CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA1_SGLREQSRCREG_CH1_Pos           (1UL)                     /*!< GPDMA1 SGLREQSRCREG: CH1 (Bit 1)                            */
#define GPDMA1_SGLREQSRCREG_CH1_Msk           (0x2UL)                   /*!< GPDMA1 SGLREQSRCREG: CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA1_SGLREQSRCREG_CH2_Pos           (2UL)                     /*!< GPDMA1 SGLREQSRCREG: CH2 (Bit 2)                            */
#define GPDMA1_SGLREQSRCREG_CH2_Msk           (0x4UL)                   /*!< GPDMA1 SGLREQSRCREG: CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA1_SGLREQSRCREG_CH3_Pos           (3UL)                     /*!< GPDMA1 SGLREQSRCREG: CH3 (Bit 3)                            */
#define GPDMA1_SGLREQSRCREG_CH3_Msk           (0x8UL)                   /*!< GPDMA1 SGLREQSRCREG: CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA1_SGLREQSRCREG_WE_CH0_Pos        (8UL)                     /*!< GPDMA1 SGLREQSRCREG: WE_CH0 (Bit 8)                         */
#define GPDMA1_SGLREQSRCREG_WE_CH0_Msk        (0x100UL)                 /*!< GPDMA1 SGLREQSRCREG: WE_CH0 (Bitfield-Mask: 0x01)           */
#define GPDMA1_SGLREQSRCREG_WE_CH1_Pos        (9UL)                     /*!< GPDMA1 SGLREQSRCREG: WE_CH1 (Bit 9)                         */
#define GPDMA1_SGLREQSRCREG_WE_CH1_Msk        (0x200UL)                 /*!< GPDMA1 SGLREQSRCREG: WE_CH1 (Bitfield-Mask: 0x01)           */
#define GPDMA1_SGLREQSRCREG_WE_CH2_Pos        (10UL)                    /*!< GPDMA1 SGLREQSRCREG: WE_CH2 (Bit 10)                        */
#define GPDMA1_SGLREQSRCREG_WE_CH2_Msk        (0x400UL)                 /*!< GPDMA1 SGLREQSRCREG: WE_CH2 (Bitfield-Mask: 0x01)           */
#define GPDMA1_SGLREQSRCREG_WE_CH3_Pos        (11UL)                    /*!< GPDMA1 SGLREQSRCREG: WE_CH3 (Bit 11)                        */
#define GPDMA1_SGLREQSRCREG_WE_CH3_Msk        (0x800UL)                 /*!< GPDMA1 SGLREQSRCREG: WE_CH3 (Bitfield-Mask: 0x01)           */

/* -----------------------------  GPDMA1_SGLREQDSTREG  ---------------------------- */
#define GPDMA1_SGLREQDSTREG_CH0_Pos           (0UL)                     /*!< GPDMA1 SGLREQDSTREG: CH0 (Bit 0)                            */
#define GPDMA1_SGLREQDSTREG_CH0_Msk           (0x1UL)                   /*!< GPDMA1 SGLREQDSTREG: CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA1_SGLREQDSTREG_CH1_Pos           (1UL)                     /*!< GPDMA1 SGLREQDSTREG: CH1 (Bit 1)                            */
#define GPDMA1_SGLREQDSTREG_CH1_Msk           (0x2UL)                   /*!< GPDMA1 SGLREQDSTREG: CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA1_SGLREQDSTREG_CH2_Pos           (2UL)                     /*!< GPDMA1 SGLREQDSTREG: CH2 (Bit 2)                            */
#define GPDMA1_SGLREQDSTREG_CH2_Msk           (0x4UL)                   /*!< GPDMA1 SGLREQDSTREG: CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA1_SGLREQDSTREG_CH3_Pos           (3UL)                     /*!< GPDMA1 SGLREQDSTREG: CH3 (Bit 3)                            */
#define GPDMA1_SGLREQDSTREG_CH3_Msk           (0x8UL)                   /*!< GPDMA1 SGLREQDSTREG: CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA1_SGLREQDSTREG_WE_CH0_Pos        (8UL)                     /*!< GPDMA1 SGLREQDSTREG: WE_CH0 (Bit 8)                         */
#define GPDMA1_SGLREQDSTREG_WE_CH0_Msk        (0x100UL)                 /*!< GPDMA1 SGLREQDSTREG: WE_CH0 (Bitfield-Mask: 0x01)           */
#define GPDMA1_SGLREQDSTREG_WE_CH1_Pos        (9UL)                     /*!< GPDMA1 SGLREQDSTREG: WE_CH1 (Bit 9)                         */
#define GPDMA1_SGLREQDSTREG_WE_CH1_Msk        (0x200UL)                 /*!< GPDMA1 SGLREQDSTREG: WE_CH1 (Bitfield-Mask: 0x01)           */
#define GPDMA1_SGLREQDSTREG_WE_CH2_Pos        (10UL)                    /*!< GPDMA1 SGLREQDSTREG: WE_CH2 (Bit 10)                        */
#define GPDMA1_SGLREQDSTREG_WE_CH2_Msk        (0x400UL)                 /*!< GPDMA1 SGLREQDSTREG: WE_CH2 (Bitfield-Mask: 0x01)           */
#define GPDMA1_SGLREQDSTREG_WE_CH3_Pos        (11UL)                    /*!< GPDMA1 SGLREQDSTREG: WE_CH3 (Bit 11)                        */
#define GPDMA1_SGLREQDSTREG_WE_CH3_Msk        (0x800UL)                 /*!< GPDMA1 SGLREQDSTREG: WE_CH3 (Bitfield-Mask: 0x01)           */

/* ------------------------------  GPDMA1_LSTSRCREG  ------------------------------ */
#define GPDMA1_LSTSRCREG_CH0_Pos              (0UL)                     /*!< GPDMA1 LSTSRCREG: CH0 (Bit 0)                               */
#define GPDMA1_LSTSRCREG_CH0_Msk              (0x1UL)                   /*!< GPDMA1 LSTSRCREG: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_LSTSRCREG_CH1_Pos              (1UL)                     /*!< GPDMA1 LSTSRCREG: CH1 (Bit 1)                               */
#define GPDMA1_LSTSRCREG_CH1_Msk              (0x2UL)                   /*!< GPDMA1 LSTSRCREG: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_LSTSRCREG_CH2_Pos              (2UL)                     /*!< GPDMA1 LSTSRCREG: CH2 (Bit 2)                               */
#define GPDMA1_LSTSRCREG_CH2_Msk              (0x4UL)                   /*!< GPDMA1 LSTSRCREG: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_LSTSRCREG_CH3_Pos              (3UL)                     /*!< GPDMA1 LSTSRCREG: CH3 (Bit 3)                               */
#define GPDMA1_LSTSRCREG_CH3_Msk              (0x8UL)                   /*!< GPDMA1 LSTSRCREG: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_LSTSRCREG_WE_CH0_Pos           (8UL)                     /*!< GPDMA1 LSTSRCREG: WE_CH0 (Bit 8)                            */
#define GPDMA1_LSTSRCREG_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA1 LSTSRCREG: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA1_LSTSRCREG_WE_CH1_Pos           (9UL)                     /*!< GPDMA1 LSTSRCREG: WE_CH1 (Bit 9)                            */
#define GPDMA1_LSTSRCREG_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA1 LSTSRCREG: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA1_LSTSRCREG_WE_CH2_Pos           (10UL)                    /*!< GPDMA1 LSTSRCREG: WE_CH2 (Bit 10)                           */
#define GPDMA1_LSTSRCREG_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA1 LSTSRCREG: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA1_LSTSRCREG_WE_CH3_Pos           (11UL)                    /*!< GPDMA1 LSTSRCREG: WE_CH3 (Bit 11)                           */
#define GPDMA1_LSTSRCREG_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA1 LSTSRCREG: WE_CH3 (Bitfield-Mask: 0x01)              */

/* ------------------------------  GPDMA1_LSTDSTREG  ------------------------------ */
#define GPDMA1_LSTDSTREG_CH0_Pos              (0UL)                     /*!< GPDMA1 LSTDSTREG: CH0 (Bit 0)                               */
#define GPDMA1_LSTDSTREG_CH0_Msk              (0x1UL)                   /*!< GPDMA1 LSTDSTREG: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_LSTDSTREG_CH1_Pos              (1UL)                     /*!< GPDMA1 LSTDSTREG: CH1 (Bit 1)                               */
#define GPDMA1_LSTDSTREG_CH1_Msk              (0x2UL)                   /*!< GPDMA1 LSTDSTREG: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_LSTDSTREG_CH2_Pos              (2UL)                     /*!< GPDMA1 LSTDSTREG: CH2 (Bit 2)                               */
#define GPDMA1_LSTDSTREG_CH2_Msk              (0x4UL)                   /*!< GPDMA1 LSTDSTREG: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_LSTDSTREG_CH3_Pos              (3UL)                     /*!< GPDMA1 LSTDSTREG: CH3 (Bit 3)                               */
#define GPDMA1_LSTDSTREG_CH3_Msk              (0x8UL)                   /*!< GPDMA1 LSTDSTREG: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA1_LSTDSTREG_WE_CH0_Pos           (8UL)                     /*!< GPDMA1 LSTDSTREG: WE_CH0 (Bit 8)                            */
#define GPDMA1_LSTDSTREG_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA1 LSTDSTREG: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA1_LSTDSTREG_WE_CH1_Pos           (9UL)                     /*!< GPDMA1 LSTDSTREG: WE_CH1 (Bit 9)                            */
#define GPDMA1_LSTDSTREG_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA1 LSTDSTREG: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA1_LSTDSTREG_WE_CH2_Pos           (10UL)                    /*!< GPDMA1 LSTDSTREG: WE_CH2 (Bit 10)                           */
#define GPDMA1_LSTDSTREG_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA1 LSTDSTREG: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA1_LSTDSTREG_WE_CH3_Pos           (11UL)                    /*!< GPDMA1 LSTDSTREG: WE_CH3 (Bit 11)                           */
#define GPDMA1_LSTDSTREG_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA1 LSTDSTREG: WE_CH3 (Bitfield-Mask: 0x01)              */

/* ------------------------------  GPDMA1_DMACFGREG  ------------------------------ */
#define GPDMA1_DMACFGREG_DMA_EN_Pos           (0UL)                     /*!< GPDMA1 DMACFGREG: DMA_EN (Bit 0)                            */
#define GPDMA1_DMACFGREG_DMA_EN_Msk           (0x1UL)                   /*!< GPDMA1 DMACFGREG: DMA_EN (Bitfield-Mask: 0x01)              */

/* -------------------------------  GPDMA1_CHENREG  ------------------------------- */
#define GPDMA1_CHENREG_CH_Pos                 (0UL)                     /*!< GPDMA1 CHENREG: CH (Bit 0)                                  */
#define GPDMA1_CHENREG_CH_Msk                 (0xfUL)                   /*!< GPDMA1 CHENREG: CH (Bitfield-Mask: 0x0f)                    */
#define GPDMA1_CHENREG_WE_CH_Pos              (8UL)                     /*!< GPDMA1 CHENREG: WE_CH (Bit 8)                               */
#define GPDMA1_CHENREG_WE_CH_Msk              (0xf00UL)                 /*!< GPDMA1 CHENREG: WE_CH (Bitfield-Mask: 0x0f)                 */

/* ----------------------------------  GPDMA1_ID  --------------------------------- */
#define GPDMA1_ID_VALUE_Pos                   (0UL)                     /*!< GPDMA1 ID: VALUE (Bit 0)                                    */
#define GPDMA1_ID_VALUE_Msk                   (0xffffffffUL)            /*!< GPDMA1 ID: VALUE (Bitfield-Mask: 0xffffffff)                */

/* ---------------------------------  GPDMA1_TYPE  -------------------------------- */
#define GPDMA1_TYPE_VALUE_Pos                 (0UL)                     /*!< GPDMA1 TYPE: VALUE (Bit 0)                                  */
#define GPDMA1_TYPE_VALUE_Msk                 (0xffffffffUL)            /*!< GPDMA1 TYPE: VALUE (Bitfield-Mask: 0xffffffff)              */

/* -------------------------------  GPDMA1_VERSION  ------------------------------- */
#define GPDMA1_VERSION_VALUE_Pos              (0UL)                     /*!< GPDMA1 VERSION: VALUE (Bit 0)                               */
#define GPDMA1_VERSION_VALUE_Msk              (0xffffffffUL)            /*!< GPDMA1 VERSION: VALUE (Bitfield-Mask: 0xffffffff)           */


/* ================================================================================ */
/* ================        Group 'GPDMA1_CH' Position & Mask       ================ */
/* ================================================================================ */


/* --------------------------------  GPDMA1_CH_SAR  ------------------------------- */
#define GPDMA1_CH_SAR_SAR_Pos                 (0UL)                     /*!< GPDMA1_CH SAR: SAR (Bit 0)                                  */
#define GPDMA1_CH_SAR_SAR_Msk                 (0xffffffffUL)            /*!< GPDMA1_CH SAR: SAR (Bitfield-Mask: 0xffffffff)              */

/* --------------------------------  GPDMA1_CH_DAR  ------------------------------- */
#define GPDMA1_CH_DAR_DAR_Pos                 (0UL)                     /*!< GPDMA1_CH DAR: DAR (Bit 0)                                  */
#define GPDMA1_CH_DAR_DAR_Msk                 (0xffffffffUL)            /*!< GPDMA1_CH DAR: DAR (Bitfield-Mask: 0xffffffff)              */

/* -------------------------------  GPDMA1_CH_CTLL  ------------------------------- */
#define GPDMA1_CH_CTLL_INT_EN_Pos             (0UL)                     /*!< GPDMA1_CH CTLL: INT_EN (Bit 0)                              */
#define GPDMA1_CH_CTLL_INT_EN_Msk             (0x1UL)                   /*!< GPDMA1_CH CTLL: INT_EN (Bitfield-Mask: 0x01)                */
#define GPDMA1_CH_CTLL_DST_TR_WIDTH_Pos       (1UL)                     /*!< GPDMA1_CH CTLL: DST_TR_WIDTH (Bit 1)                        */
#define GPDMA1_CH_CTLL_DST_TR_WIDTH_Msk       (0xeUL)                   /*!< GPDMA1_CH CTLL: DST_TR_WIDTH (Bitfield-Mask: 0x07)          */
#define GPDMA1_CH_CTLL_SRC_TR_WIDTH_Pos       (4UL)                     /*!< GPDMA1_CH CTLL: SRC_TR_WIDTH (Bit 4)                        */
#define GPDMA1_CH_CTLL_SRC_TR_WIDTH_Msk       (0x70UL)                  /*!< GPDMA1_CH CTLL: SRC_TR_WIDTH (Bitfield-Mask: 0x07)          */
#define GPDMA1_CH_CTLL_DINC_Pos               (7UL)                     /*!< GPDMA1_CH CTLL: DINC (Bit 7)                                */
#define GPDMA1_CH_CTLL_DINC_Msk               (0x180UL)                 /*!< GPDMA1_CH CTLL: DINC (Bitfield-Mask: 0x03)                  */
#define GPDMA1_CH_CTLL_SINC_Pos               (9UL)                     /*!< GPDMA1_CH CTLL: SINC (Bit 9)                                */
#define GPDMA1_CH_CTLL_SINC_Msk               (0x600UL)                 /*!< GPDMA1_CH CTLL: SINC (Bitfield-Mask: 0x03)                  */
#define GPDMA1_CH_CTLL_DEST_MSIZE_Pos         (11UL)                    /*!< GPDMA1_CH CTLL: DEST_MSIZE (Bit 11)                         */
#define GPDMA1_CH_CTLL_DEST_MSIZE_Msk         (0x3800UL)                /*!< GPDMA1_CH CTLL: DEST_MSIZE (Bitfield-Mask: 0x07)            */
#define GPDMA1_CH_CTLL_SRC_MSIZE_Pos          (14UL)                    /*!< GPDMA1_CH CTLL: SRC_MSIZE (Bit 14)                          */
#define GPDMA1_CH_CTLL_SRC_MSIZE_Msk          (0x1c000UL)               /*!< GPDMA1_CH CTLL: SRC_MSIZE (Bitfield-Mask: 0x07)             */
#define GPDMA1_CH_CTLL_TT_FC_Pos              (20UL)                    /*!< GPDMA1_CH CTLL: TT_FC (Bit 20)                              */
#define GPDMA1_CH_CTLL_TT_FC_Msk              (0x700000UL)              /*!< GPDMA1_CH CTLL: TT_FC (Bitfield-Mask: 0x07)                 */

/* -------------------------------  GPDMA1_CH_CTLH  ------------------------------- */
#define GPDMA1_CH_CTLH_BLOCK_TS_Pos           (0UL)                     /*!< GPDMA1_CH CTLH: BLOCK_TS (Bit 0)                            */
#define GPDMA1_CH_CTLH_BLOCK_TS_Msk           (0xfffUL)                 /*!< GPDMA1_CH CTLH: BLOCK_TS (Bitfield-Mask: 0xfff)             */
#define GPDMA1_CH_CTLH_DONE_Pos               (12UL)                    /*!< GPDMA1_CH CTLH: DONE (Bit 12)                               */
#define GPDMA1_CH_CTLH_DONE_Msk               (0x1000UL)                /*!< GPDMA1_CH CTLH: DONE (Bitfield-Mask: 0x01)                  */

/* -------------------------------  GPDMA1_CH_CFGL  ------------------------------- */
#define GPDMA1_CH_CFGL_CH_PRIOR_Pos           (5UL)                     /*!< GPDMA1_CH CFGL: CH_PRIOR (Bit 5)                            */
#define GPDMA1_CH_CFGL_CH_PRIOR_Msk           (0xe0UL)                  /*!< GPDMA1_CH CFGL: CH_PRIOR (Bitfield-Mask: 0x07)              */
#define GPDMA1_CH_CFGL_CH_SUSP_Pos            (8UL)                     /*!< GPDMA1_CH CFGL: CH_SUSP (Bit 8)                             */
#define GPDMA1_CH_CFGL_CH_SUSP_Msk            (0x100UL)                 /*!< GPDMA1_CH CFGL: CH_SUSP (Bitfield-Mask: 0x01)               */
#define GPDMA1_CH_CFGL_FIFO_EMPTY_Pos         (9UL)                     /*!< GPDMA1_CH CFGL: FIFO_EMPTY (Bit 9)                          */
#define GPDMA1_CH_CFGL_FIFO_EMPTY_Msk         (0x200UL)                 /*!< GPDMA1_CH CFGL: FIFO_EMPTY (Bitfield-Mask: 0x01)            */
#define GPDMA1_CH_CFGL_HS_SEL_DST_Pos         (10UL)                    /*!< GPDMA1_CH CFGL: HS_SEL_DST (Bit 10)                         */
#define GPDMA1_CH_CFGL_HS_SEL_DST_Msk         (0x400UL)                 /*!< GPDMA1_CH CFGL: HS_SEL_DST (Bitfield-Mask: 0x01)            */
#define GPDMA1_CH_CFGL_HS_SEL_SRC_Pos         (11UL)                    /*!< GPDMA1_CH CFGL: HS_SEL_SRC (Bit 11)                         */
#define GPDMA1_CH_CFGL_HS_SEL_SRC_Msk         (0x800UL)                 /*!< GPDMA1_CH CFGL: HS_SEL_SRC (Bitfield-Mask: 0x01)            */
#define GPDMA1_CH_CFGL_LOCK_CH_L_Pos          (12UL)                    /*!< GPDMA1_CH CFGL: LOCK_CH_L (Bit 12)                          */
#define GPDMA1_CH_CFGL_LOCK_CH_L_Msk          (0x3000UL)                /*!< GPDMA1_CH CFGL: LOCK_CH_L (Bitfield-Mask: 0x03)             */
#define GPDMA1_CH_CFGL_LOCK_B_L_Pos           (14UL)                    /*!< GPDMA1_CH CFGL: LOCK_B_L (Bit 14)                           */
#define GPDMA1_CH_CFGL_LOCK_B_L_Msk           (0xc000UL)                /*!< GPDMA1_CH CFGL: LOCK_B_L (Bitfield-Mask: 0x03)              */
#define GPDMA1_CH_CFGL_LOCK_CH_Pos            (16UL)                    /*!< GPDMA1_CH CFGL: LOCK_CH (Bit 16)                            */
#define GPDMA1_CH_CFGL_LOCK_CH_Msk            (0x10000UL)               /*!< GPDMA1_CH CFGL: LOCK_CH (Bitfield-Mask: 0x01)               */
#define GPDMA1_CH_CFGL_LOCK_B_Pos             (17UL)                    /*!< GPDMA1_CH CFGL: LOCK_B (Bit 17)                             */
#define GPDMA1_CH_CFGL_LOCK_B_Msk             (0x20000UL)               /*!< GPDMA1_CH CFGL: LOCK_B (Bitfield-Mask: 0x01)                */
#define GPDMA1_CH_CFGL_DST_HS_POL_Pos         (18UL)                    /*!< GPDMA1_CH CFGL: DST_HS_POL (Bit 18)                         */
#define GPDMA1_CH_CFGL_DST_HS_POL_Msk         (0x40000UL)               /*!< GPDMA1_CH CFGL: DST_HS_POL (Bitfield-Mask: 0x01)            */
#define GPDMA1_CH_CFGL_SRC_HS_POL_Pos         (19UL)                    /*!< GPDMA1_CH CFGL: SRC_HS_POL (Bit 19)                         */
#define GPDMA1_CH_CFGL_SRC_HS_POL_Msk         (0x80000UL)               /*!< GPDMA1_CH CFGL: SRC_HS_POL (Bitfield-Mask: 0x01)            */
#define GPDMA1_CH_CFGL_MAX_ABRST_Pos          (20UL)                    /*!< GPDMA1_CH CFGL: MAX_ABRST (Bit 20)                          */
#define GPDMA1_CH_CFGL_MAX_ABRST_Msk          (0x3ff00000UL)            /*!< GPDMA1_CH CFGL: MAX_ABRST (Bitfield-Mask: 0x3ff)            */

/* -------------------------------  GPDMA1_CH_CFGH  ------------------------------- */
#define GPDMA1_CH_CFGH_FCMODE_Pos             (0UL)                     /*!< GPDMA1_CH CFGH: FCMODE (Bit 0)                              */
#define GPDMA1_CH_CFGH_FCMODE_Msk             (0x1UL)                   /*!< GPDMA1_CH CFGH: FCMODE (Bitfield-Mask: 0x01)                */
#define GPDMA1_CH_CFGH_FIFO_MODE_Pos          (1UL)                     /*!< GPDMA1_CH CFGH: FIFO_MODE (Bit 1)                           */
#define GPDMA1_CH_CFGH_FIFO_MODE_Msk          (0x2UL)                   /*!< GPDMA1_CH CFGH: FIFO_MODE (Bitfield-Mask: 0x01)             */
#define GPDMA1_CH_CFGH_PROTCTL_Pos            (2UL)                     /*!< GPDMA1_CH CFGH: PROTCTL (Bit 2)                             */
#define GPDMA1_CH_CFGH_PROTCTL_Msk            (0x1cUL)                  /*!< GPDMA1_CH CFGH: PROTCTL (Bitfield-Mask: 0x07)               */
#define GPDMA1_CH_CFGH_SRC_PER_Pos            (7UL)                     /*!< GPDMA1_CH CFGH: SRC_PER (Bit 7)                             */
#define GPDMA1_CH_CFGH_SRC_PER_Msk            (0x780UL)                 /*!< GPDMA1_CH CFGH: SRC_PER (Bitfield-Mask: 0x0f)               */
#define GPDMA1_CH_CFGH_DEST_PER_Pos           (11UL)                    /*!< GPDMA1_CH CFGH: DEST_PER (Bit 11)                           */
#define GPDMA1_CH_CFGH_DEST_PER_Msk           (0x7800UL)                /*!< GPDMA1_CH CFGH: DEST_PER (Bitfield-Mask: 0x0f)              */


/* ================================================================================ */
/* ================          struct 'FCE' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  FCE_CLC  ---------------------------------- */
#define FCE_CLC_DISR_Pos                      (0UL)                     /*!< FCE CLC: DISR (Bit 0)                                       */
#define FCE_CLC_DISR_Msk                      (0x1UL)                   /*!< FCE CLC: DISR (Bitfield-Mask: 0x01)                         */
#define FCE_CLC_DISS_Pos                      (1UL)                     /*!< FCE CLC: DISS (Bit 1)                                       */
#define FCE_CLC_DISS_Msk                      (0x2UL)                   /*!< FCE CLC: DISS (Bitfield-Mask: 0x01)                         */

/* -----------------------------------  FCE_ID  ----------------------------------- */
#define FCE_ID_MOD_REV_Pos                    (0UL)                     /*!< FCE ID: MOD_REV (Bit 0)                                     */
#define FCE_ID_MOD_REV_Msk                    (0xffUL)                  /*!< FCE ID: MOD_REV (Bitfield-Mask: 0xff)                       */
#define FCE_ID_MOD_TYPE_Pos                   (8UL)                     /*!< FCE ID: MOD_TYPE (Bit 8)                                    */
#define FCE_ID_MOD_TYPE_Msk                   (0xff00UL)                /*!< FCE ID: MOD_TYPE (Bitfield-Mask: 0xff)                      */
#define FCE_ID_MOD_NUMBER_Pos                 (16UL)                    /*!< FCE ID: MOD_NUMBER (Bit 16)                                 */
#define FCE_ID_MOD_NUMBER_Msk                 (0xffff0000UL)            /*!< FCE ID: MOD_NUMBER (Bitfield-Mask: 0xffff)                  */


/* ================================================================================ */
/* ================         Group 'FCE_KE' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  FCE_KE_IR  --------------------------------- */
#define FCE_KE_IR_IR_Pos                      (0UL)                     /*!< FCE_KE IR: IR (Bit 0)                                       */
#define FCE_KE_IR_IR_Msk                      (0xffffffffUL)            /*!< FCE_KE IR: IR (Bitfield-Mask: 0xffffffff)                   */

/* ---------------------------------  FCE_KE_RES  --------------------------------- */
#define FCE_KE_RES_RES_Pos                    (0UL)                     /*!< FCE_KE RES: RES (Bit 0)                                     */
#define FCE_KE_RES_RES_Msk                    (0xffffffffUL)            /*!< FCE_KE RES: RES (Bitfield-Mask: 0xffffffff)                 */

/* ---------------------------------  FCE_KE_CFG  --------------------------------- */
#define FCE_KE_CFG_CMI_Pos                    (0UL)                     /*!< FCE_KE CFG: CMI (Bit 0)                                     */
#define FCE_KE_CFG_CMI_Msk                    (0x1UL)                   /*!< FCE_KE CFG: CMI (Bitfield-Mask: 0x01)                       */
#define FCE_KE_CFG_CEI_Pos                    (1UL)                     /*!< FCE_KE CFG: CEI (Bit 1)                                     */
#define FCE_KE_CFG_CEI_Msk                    (0x2UL)                   /*!< FCE_KE CFG: CEI (Bitfield-Mask: 0x01)                       */
#define FCE_KE_CFG_LEI_Pos                    (2UL)                     /*!< FCE_KE CFG: LEI (Bit 2)                                     */
#define FCE_KE_CFG_LEI_Msk                    (0x4UL)                   /*!< FCE_KE CFG: LEI (Bitfield-Mask: 0x01)                       */
#define FCE_KE_CFG_BEI_Pos                    (3UL)                     /*!< FCE_KE CFG: BEI (Bit 3)                                     */
#define FCE_KE_CFG_BEI_Msk                    (0x8UL)                   /*!< FCE_KE CFG: BEI (Bitfield-Mask: 0x01)                       */
#define FCE_KE_CFG_CCE_Pos                    (4UL)                     /*!< FCE_KE CFG: CCE (Bit 4)                                     */
#define FCE_KE_CFG_CCE_Msk                    (0x10UL)                  /*!< FCE_KE CFG: CCE (Bitfield-Mask: 0x01)                       */
#define FCE_KE_CFG_ALR_Pos                    (5UL)                     /*!< FCE_KE CFG: ALR (Bit 5)                                     */
#define FCE_KE_CFG_ALR_Msk                    (0x20UL)                  /*!< FCE_KE CFG: ALR (Bitfield-Mask: 0x01)                       */
#define FCE_KE_CFG_REFIN_Pos                  (8UL)                     /*!< FCE_KE CFG: REFIN (Bit 8)                                   */
#define FCE_KE_CFG_REFIN_Msk                  (0x100UL)                 /*!< FCE_KE CFG: REFIN (Bitfield-Mask: 0x01)                     */
#define FCE_KE_CFG_REFOUT_Pos                 (9UL)                     /*!< FCE_KE CFG: REFOUT (Bit 9)                                  */
#define FCE_KE_CFG_REFOUT_Msk                 (0x200UL)                 /*!< FCE_KE CFG: REFOUT (Bitfield-Mask: 0x01)                    */
#define FCE_KE_CFG_XSEL_Pos                   (10UL)                    /*!< FCE_KE CFG: XSEL (Bit 10)                                   */
#define FCE_KE_CFG_XSEL_Msk                   (0x400UL)                 /*!< FCE_KE CFG: XSEL (Bitfield-Mask: 0x01)                      */

/* ---------------------------------  FCE_KE_STS  --------------------------------- */
#define FCE_KE_STS_CMF_Pos                    (0UL)                     /*!< FCE_KE STS: CMF (Bit 0)                                     */
#define FCE_KE_STS_CMF_Msk                    (0x1UL)                   /*!< FCE_KE STS: CMF (Bitfield-Mask: 0x01)                       */
#define FCE_KE_STS_CEF_Pos                    (1UL)                     /*!< FCE_KE STS: CEF (Bit 1)                                     */
#define FCE_KE_STS_CEF_Msk                    (0x2UL)                   /*!< FCE_KE STS: CEF (Bitfield-Mask: 0x01)                       */
#define FCE_KE_STS_LEF_Pos                    (2UL)                     /*!< FCE_KE STS: LEF (Bit 2)                                     */
#define FCE_KE_STS_LEF_Msk                    (0x4UL)                   /*!< FCE_KE STS: LEF (Bitfield-Mask: 0x01)                       */
#define FCE_KE_STS_BEF_Pos                    (3UL)                     /*!< FCE_KE STS: BEF (Bit 3)                                     */
#define FCE_KE_STS_BEF_Msk                    (0x8UL)                   /*!< FCE_KE STS: BEF (Bitfield-Mask: 0x01)                       */

/* --------------------------------  FCE_KE_LENGTH  ------------------------------- */
#define FCE_KE_LENGTH_LENGTH_Pos              (0UL)                     /*!< FCE_KE LENGTH: LENGTH (Bit 0)                               */
#define FCE_KE_LENGTH_LENGTH_Msk              (0xffffUL)                /*!< FCE_KE LENGTH: LENGTH (Bitfield-Mask: 0xffff)               */

/* --------------------------------  FCE_KE_CHECK  -------------------------------- */
#define FCE_KE_CHECK_CHECK_Pos                (0UL)                     /*!< FCE_KE CHECK: CHECK (Bit 0)                                 */
#define FCE_KE_CHECK_CHECK_Msk                (0xffffffffUL)            /*!< FCE_KE CHECK: CHECK (Bitfield-Mask: 0xffffffff)             */

/* ---------------------------------  FCE_KE_CRC  --------------------------------- */
#define FCE_KE_CRC_CRC_Pos                    (0UL)                     /*!< FCE_KE CRC: CRC (Bit 0)                                     */
#define FCE_KE_CRC_CRC_Msk                    (0xffffffffUL)            /*!< FCE_KE CRC: CRC (Bitfield-Mask: 0xffffffff)                 */

/* ---------------------------------  FCE_KE_CTR  --------------------------------- */
#define FCE_KE_CTR_FCM_Pos                    (0UL)                     /*!< FCE_KE CTR: FCM (Bit 0)                                     */
#define FCE_KE_CTR_FCM_Msk                    (0x1UL)                   /*!< FCE_KE CTR: FCM (Bitfield-Mask: 0x01)                       */
#define FCE_KE_CTR_FRM_CFG_Pos                (1UL)                     /*!< FCE_KE CTR: FRM_CFG (Bit 1)                                 */
#define FCE_KE_CTR_FRM_CFG_Msk                (0x2UL)                   /*!< FCE_KE CTR: FRM_CFG (Bitfield-Mask: 0x01)                   */
#define FCE_KE_CTR_FRM_CHECK_Pos              (2UL)                     /*!< FCE_KE CTR: FRM_CHECK (Bit 2)                               */
#define FCE_KE_CTR_FRM_CHECK_Msk              (0x4UL)                   /*!< FCE_KE CTR: FRM_CHECK (Bitfield-Mask: 0x01)                 */


/* ================================================================================ */
/* ================           Group 'PBA' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  PBA_STS  ---------------------------------- */
#define PBA_STS_WERR_Pos                      (0UL)                     /*!< PBA STS: WERR (Bit 0)                                       */
#define PBA_STS_WERR_Msk                      (0x1UL)                   /*!< PBA STS: WERR (Bitfield-Mask: 0x01)                         */

/* ----------------------------------  PBA_WADDR  --------------------------------- */
#define PBA_WADDR_WADDR_Pos                   (0UL)                     /*!< PBA WADDR: WADDR (Bit 0)                                    */
#define PBA_WADDR_WADDR_Msk                   (0xffffffffUL)            /*!< PBA WADDR: WADDR (Bitfield-Mask: 0xffffffff)                */


/* ================================================================================ */
/* ================          Group 'FLASH' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  FLASH_ID  ---------------------------------- */
#define FLASH_ID_MOD_REV_Pos                  (0UL)                     /*!< FLASH ID: MOD_REV (Bit 0)                                   */
#define FLASH_ID_MOD_REV_Msk                  (0xffUL)                  /*!< FLASH ID: MOD_REV (Bitfield-Mask: 0xff)                     */
#define FLASH_ID_MOD_TYPE_Pos                 (8UL)                     /*!< FLASH ID: MOD_TYPE (Bit 8)                                  */
#define FLASH_ID_MOD_TYPE_Msk                 (0xff00UL)                /*!< FLASH ID: MOD_TYPE (Bitfield-Mask: 0xff)                    */
#define FLASH_ID_MOD_NUMBER_Pos               (16UL)                    /*!< FLASH ID: MOD_NUMBER (Bit 16)                               */
#define FLASH_ID_MOD_NUMBER_Msk               (0xffff0000UL)            /*!< FLASH ID: MOD_NUMBER (Bitfield-Mask: 0xffff)                */

/* ----------------------------------  FLASH_FSR  --------------------------------- */
#define FLASH_FSR_PBUSY_Pos                   (0UL)                     /*!< FLASH FSR: PBUSY (Bit 0)                                    */
#define FLASH_FSR_PBUSY_Msk                   (0x1UL)                   /*!< FLASH FSR: PBUSY (Bitfield-Mask: 0x01)                      */
#define FLASH_FSR_FABUSY_Pos                  (1UL)                     /*!< FLASH FSR: FABUSY (Bit 1)                                   */
#define FLASH_FSR_FABUSY_Msk                  (0x2UL)                   /*!< FLASH FSR: FABUSY (Bitfield-Mask: 0x01)                     */
#define FLASH_FSR_PROG_Pos                    (4UL)                     /*!< FLASH FSR: PROG (Bit 4)                                     */
#define FLASH_FSR_PROG_Msk                    (0x10UL)                  /*!< FLASH FSR: PROG (Bitfield-Mask: 0x01)                       */
#define FLASH_FSR_ERASE_Pos                   (5UL)                     /*!< FLASH FSR: ERASE (Bit 5)                                    */
#define FLASH_FSR_ERASE_Msk                   (0x20UL)                  /*!< FLASH FSR: ERASE (Bitfield-Mask: 0x01)                      */
#define FLASH_FSR_PFPAGE_Pos                  (6UL)                     /*!< FLASH FSR: PFPAGE (Bit 6)                                   */
#define FLASH_FSR_PFPAGE_Msk                  (0x40UL)                  /*!< FLASH FSR: PFPAGE (Bitfield-Mask: 0x01)                     */
#define FLASH_FSR_PFOPER_Pos                  (8UL)                     /*!< FLASH FSR: PFOPER (Bit 8)                                   */
#define FLASH_FSR_PFOPER_Msk                  (0x100UL)                 /*!< FLASH FSR: PFOPER (Bitfield-Mask: 0x01)                     */
#define FLASH_FSR_SQER_Pos                    (10UL)                    /*!< FLASH FSR: SQER (Bit 10)                                    */
#define FLASH_FSR_SQER_Msk                    (0x400UL)                 /*!< FLASH FSR: SQER (Bitfield-Mask: 0x01)                       */
#define FLASH_FSR_PROER_Pos                   (11UL)                    /*!< FLASH FSR: PROER (Bit 11)                                   */
#define FLASH_FSR_PROER_Msk                   (0x800UL)                 /*!< FLASH FSR: PROER (Bitfield-Mask: 0x01)                      */
#define FLASH_FSR_PFSBER_Pos                  (12UL)                    /*!< FLASH FSR: PFSBER (Bit 12)                                  */
#define FLASH_FSR_PFSBER_Msk                  (0x1000UL)                /*!< FLASH FSR: PFSBER (Bitfield-Mask: 0x01)                     */
#define FLASH_FSR_PFDBER_Pos                  (14UL)                    /*!< FLASH FSR: PFDBER (Bit 14)                                  */
#define FLASH_FSR_PFDBER_Msk                  (0x4000UL)                /*!< FLASH FSR: PFDBER (Bitfield-Mask: 0x01)                     */
#define FLASH_FSR_PROIN_Pos                   (16UL)                    /*!< FLASH FSR: PROIN (Bit 16)                                   */
#define FLASH_FSR_PROIN_Msk                   (0x10000UL)               /*!< FLASH FSR: PROIN (Bitfield-Mask: 0x01)                      */
#define FLASH_FSR_RPROIN_Pos                  (18UL)                    /*!< FLASH FSR: RPROIN (Bit 18)                                  */
#define FLASH_FSR_RPROIN_Msk                  (0x40000UL)               /*!< FLASH FSR: RPROIN (Bitfield-Mask: 0x01)                     */
#define FLASH_FSR_RPRODIS_Pos                 (19UL)                    /*!< FLASH FSR: RPRODIS (Bit 19)                                 */
#define FLASH_FSR_RPRODIS_Msk                 (0x80000UL)               /*!< FLASH FSR: RPRODIS (Bitfield-Mask: 0x01)                    */
#define FLASH_FSR_WPROIN0_Pos                 (21UL)                    /*!< FLASH FSR: WPROIN0 (Bit 21)                                 */
#define FLASH_FSR_WPROIN0_Msk                 (0x200000UL)              /*!< FLASH FSR: WPROIN0 (Bitfield-Mask: 0x01)                    */
#define FLASH_FSR_WPROIN1_Pos                 (22UL)                    /*!< FLASH FSR: WPROIN1 (Bit 22)                                 */
#define FLASH_FSR_WPROIN1_Msk                 (0x400000UL)              /*!< FLASH FSR: WPROIN1 (Bitfield-Mask: 0x01)                    */
#define FLASH_FSR_WPROIN2_Pos                 (23UL)                    /*!< FLASH FSR: WPROIN2 (Bit 23)                                 */
#define FLASH_FSR_WPROIN2_Msk                 (0x800000UL)              /*!< FLASH FSR: WPROIN2 (Bitfield-Mask: 0x01)                    */
#define FLASH_FSR_WPRODIS0_Pos                (25UL)                    /*!< FLASH FSR: WPRODIS0 (Bit 25)                                */
#define FLASH_FSR_WPRODIS0_Msk                (0x2000000UL)             /*!< FLASH FSR: WPRODIS0 (Bitfield-Mask: 0x01)                   */
#define FLASH_FSR_WPRODIS1_Pos                (26UL)                    /*!< FLASH FSR: WPRODIS1 (Bit 26)                                */
#define FLASH_FSR_WPRODIS1_Msk                (0x4000000UL)             /*!< FLASH FSR: WPRODIS1 (Bitfield-Mask: 0x01)                   */
#define FLASH_FSR_SLM_Pos                     (28UL)                    /*!< FLASH FSR: SLM (Bit 28)                                     */
#define FLASH_FSR_SLM_Msk                     (0x10000000UL)            /*!< FLASH FSR: SLM (Bitfield-Mask: 0x01)                        */
#define FLASH_FSR_VER_Pos                     (31UL)                    /*!< FLASH FSR: VER (Bit 31)                                     */
#define FLASH_FSR_VER_Msk                     (0x80000000UL)            /*!< FLASH FSR: VER (Bitfield-Mask: 0x01)                        */

/* ---------------------------------  FLASH_FCON  --------------------------------- */
#define FLASH_FCON_WSPFLASH_Pos               (0UL)                     /*!< FLASH FCON: WSPFLASH (Bit 0)                                */
#define FLASH_FCON_WSPFLASH_Msk               (0xfUL)                   /*!< FLASH FCON: WSPFLASH (Bitfield-Mask: 0x0f)                  */
#define FLASH_FCON_WSECPF_Pos                 (4UL)                     /*!< FLASH FCON: WSECPF (Bit 4)                                  */
#define FLASH_FCON_WSECPF_Msk                 (0x10UL)                  /*!< FLASH FCON: WSECPF (Bitfield-Mask: 0x01)                    */
#define FLASH_FCON_IDLE_Pos                   (13UL)                    /*!< FLASH FCON: IDLE (Bit 13)                                   */
#define FLASH_FCON_IDLE_Msk                   (0x2000UL)                /*!< FLASH FCON: IDLE (Bitfield-Mask: 0x01)                      */
#define FLASH_FCON_ESLDIS_Pos                 (14UL)                    /*!< FLASH FCON: ESLDIS (Bit 14)                                 */
#define FLASH_FCON_ESLDIS_Msk                 (0x4000UL)                /*!< FLASH FCON: ESLDIS (Bitfield-Mask: 0x01)                    */
#define FLASH_FCON_SLEEP_Pos                  (15UL)                    /*!< FLASH FCON: SLEEP (Bit 15)                                  */
#define FLASH_FCON_SLEEP_Msk                  (0x8000UL)                /*!< FLASH FCON: SLEEP (Bitfield-Mask: 0x01)                     */
#define FLASH_FCON_RPA_Pos                    (16UL)                    /*!< FLASH FCON: RPA (Bit 16)                                    */
#define FLASH_FCON_RPA_Msk                    (0x10000UL)               /*!< FLASH FCON: RPA (Bitfield-Mask: 0x01)                       */
#define FLASH_FCON_DCF_Pos                    (17UL)                    /*!< FLASH FCON: DCF (Bit 17)                                    */
#define FLASH_FCON_DCF_Msk                    (0x20000UL)               /*!< FLASH FCON: DCF (Bitfield-Mask: 0x01)                       */
#define FLASH_FCON_DDF_Pos                    (18UL)                    /*!< FLASH FCON: DDF (Bit 18)                                    */
#define FLASH_FCON_DDF_Msk                    (0x40000UL)               /*!< FLASH FCON: DDF (Bitfield-Mask: 0x01)                       */
#define FLASH_FCON_VOPERM_Pos                 (24UL)                    /*!< FLASH FCON: VOPERM (Bit 24)                                 */
#define FLASH_FCON_VOPERM_Msk                 (0x1000000UL)             /*!< FLASH FCON: VOPERM (Bitfield-Mask: 0x01)                    */
#define FLASH_FCON_SQERM_Pos                  (25UL)                    /*!< FLASH FCON: SQERM (Bit 25)                                  */
#define FLASH_FCON_SQERM_Msk                  (0x2000000UL)             /*!< FLASH FCON: SQERM (Bitfield-Mask: 0x01)                     */
#define FLASH_FCON_PROERM_Pos                 (26UL)                    /*!< FLASH FCON: PROERM (Bit 26)                                 */
#define FLASH_FCON_PROERM_Msk                 (0x4000000UL)             /*!< FLASH FCON: PROERM (Bitfield-Mask: 0x01)                    */
#define FLASH_FCON_PFSBERM_Pos                (27UL)                    /*!< FLASH FCON: PFSBERM (Bit 27)                                */
#define FLASH_FCON_PFSBERM_Msk                (0x8000000UL)             /*!< FLASH FCON: PFSBERM (Bitfield-Mask: 0x01)                   */
#define FLASH_FCON_PFDBERM_Pos                (29UL)                    /*!< FLASH FCON: PFDBERM (Bit 29)                                */
#define FLASH_FCON_PFDBERM_Msk                (0x20000000UL)            /*!< FLASH FCON: PFDBERM (Bitfield-Mask: 0x01)                   */
#define FLASH_FCON_EOBM_Pos                   (31UL)                    /*!< FLASH FCON: EOBM (Bit 31)                                   */
#define FLASH_FCON_EOBM_Msk                   (0x80000000UL)            /*!< FLASH FCON: EOBM (Bitfield-Mask: 0x01)                      */

/* ---------------------------------  FLASH_MARP  --------------------------------- */
#define FLASH_MARP_MARGIN_Pos                 (0UL)                     /*!< FLASH MARP: MARGIN (Bit 0)                                  */
#define FLASH_MARP_MARGIN_Msk                 (0xfUL)                   /*!< FLASH MARP: MARGIN (Bitfield-Mask: 0x0f)                    */
#define FLASH_MARP_TRAPDIS_Pos                (15UL)                    /*!< FLASH MARP: TRAPDIS (Bit 15)                                */
#define FLASH_MARP_TRAPDIS_Msk                (0x8000UL)                /*!< FLASH MARP: TRAPDIS (Bitfield-Mask: 0x01)                   */

/* --------------------------------  FLASH_PROCON0  ------------------------------- */
#define FLASH_PROCON0_S0L_Pos                 (0UL)                     /*!< FLASH PROCON0: S0L (Bit 0)                                  */
#define FLASH_PROCON0_S0L_Msk                 (0x1UL)                   /*!< FLASH PROCON0: S0L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S1L_Pos                 (1UL)                     /*!< FLASH PROCON0: S1L (Bit 1)                                  */
#define FLASH_PROCON0_S1L_Msk                 (0x2UL)                   /*!< FLASH PROCON0: S1L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S2L_Pos                 (2UL)                     /*!< FLASH PROCON0: S2L (Bit 2)                                  */
#define FLASH_PROCON0_S2L_Msk                 (0x4UL)                   /*!< FLASH PROCON0: S2L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S3L_Pos                 (3UL)                     /*!< FLASH PROCON0: S3L (Bit 3)                                  */
#define FLASH_PROCON0_S3L_Msk                 (0x8UL)                   /*!< FLASH PROCON0: S3L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S4L_Pos                 (4UL)                     /*!< FLASH PROCON0: S4L (Bit 4)                                  */
#define FLASH_PROCON0_S4L_Msk                 (0x10UL)                  /*!< FLASH PROCON0: S4L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S5L_Pos                 (5UL)                     /*!< FLASH PROCON0: S5L (Bit 5)                                  */
#define FLASH_PROCON0_S5L_Msk                 (0x20UL)                  /*!< FLASH PROCON0: S5L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S6L_Pos                 (6UL)                     /*!< FLASH PROCON0: S6L (Bit 6)                                  */
#define FLASH_PROCON0_S6L_Msk                 (0x40UL)                  /*!< FLASH PROCON0: S6L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S7L_Pos                 (7UL)                     /*!< FLASH PROCON0: S7L (Bit 7)                                  */
#define FLASH_PROCON0_S7L_Msk                 (0x80UL)                  /*!< FLASH PROCON0: S7L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S8L_Pos                 (8UL)                     /*!< FLASH PROCON0: S8L (Bit 8)                                  */
#define FLASH_PROCON0_S8L_Msk                 (0x100UL)                 /*!< FLASH PROCON0: S8L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S9L_Pos                 (9UL)                     /*!< FLASH PROCON0: S9L (Bit 9)                                  */
#define FLASH_PROCON0_S9L_Msk                 (0x200UL)                 /*!< FLASH PROCON0: S9L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S10_S11L_Pos            (10UL)                    /*!< FLASH PROCON0: S10_S11L (Bit 10)                            */
#define FLASH_PROCON0_S10_S11L_Msk            (0x400UL)                 /*!< FLASH PROCON0: S10_S11L (Bitfield-Mask: 0x01)               */
#define FLASH_PROCON0_S12_S13L_Pos            (11UL)                    /*!< FLASH PROCON0: S12_S13L (Bit 11)                            */
#define FLASH_PROCON0_S12_S13L_Msk            (0x800UL)                 /*!< FLASH PROCON0: S12_S13L (Bitfield-Mask: 0x01)               */
#define FLASH_PROCON0_S14_S15L_Pos            (12UL)                    /*!< FLASH PROCON0: S14_S15L (Bit 12)                            */
#define FLASH_PROCON0_S14_S15L_Msk            (0x1000UL)                /*!< FLASH PROCON0: S14_S15L (Bitfield-Mask: 0x01)               */
#define FLASH_PROCON0_RPRO_Pos                (15UL)                    /*!< FLASH PROCON0: RPRO (Bit 15)                                */
#define FLASH_PROCON0_RPRO_Msk                (0x8000UL)                /*!< FLASH PROCON0: RPRO (Bitfield-Mask: 0x01)                   */

/* --------------------------------  FLASH_PROCON1  ------------------------------- */
#define FLASH_PROCON1_S0L_Pos                 (0UL)                     /*!< FLASH PROCON1: S0L (Bit 0)                                  */
#define FLASH_PROCON1_S0L_Msk                 (0x1UL)                   /*!< FLASH PROCON1: S0L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S1L_Pos                 (1UL)                     /*!< FLASH PROCON1: S1L (Bit 1)                                  */
#define FLASH_PROCON1_S1L_Msk                 (0x2UL)                   /*!< FLASH PROCON1: S1L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S2L_Pos                 (2UL)                     /*!< FLASH PROCON1: S2L (Bit 2)                                  */
#define FLASH_PROCON1_S2L_Msk                 (0x4UL)                   /*!< FLASH PROCON1: S2L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S3L_Pos                 (3UL)                     /*!< FLASH PROCON1: S3L (Bit 3)                                  */
#define FLASH_PROCON1_S3L_Msk                 (0x8UL)                   /*!< FLASH PROCON1: S3L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S4L_Pos                 (4UL)                     /*!< FLASH PROCON1: S4L (Bit 4)                                  */
#define FLASH_PROCON1_S4L_Msk                 (0x10UL)                  /*!< FLASH PROCON1: S4L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S5L_Pos                 (5UL)                     /*!< FLASH PROCON1: S5L (Bit 5)                                  */
#define FLASH_PROCON1_S5L_Msk                 (0x20UL)                  /*!< FLASH PROCON1: S5L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S6L_Pos                 (6UL)                     /*!< FLASH PROCON1: S6L (Bit 6)                                  */
#define FLASH_PROCON1_S6L_Msk                 (0x40UL)                  /*!< FLASH PROCON1: S6L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S7L_Pos                 (7UL)                     /*!< FLASH PROCON1: S7L (Bit 7)                                  */
#define FLASH_PROCON1_S7L_Msk                 (0x80UL)                  /*!< FLASH PROCON1: S7L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S8L_Pos                 (8UL)                     /*!< FLASH PROCON1: S8L (Bit 8)                                  */
#define FLASH_PROCON1_S8L_Msk                 (0x100UL)                 /*!< FLASH PROCON1: S8L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S9L_Pos                 (9UL)                     /*!< FLASH PROCON1: S9L (Bit 9)                                  */
#define FLASH_PROCON1_S9L_Msk                 (0x200UL)                 /*!< FLASH PROCON1: S9L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S10_S11L_Pos            (10UL)                    /*!< FLASH PROCON1: S10_S11L (Bit 10)                            */
#define FLASH_PROCON1_S10_S11L_Msk            (0x400UL)                 /*!< FLASH PROCON1: S10_S11L (Bitfield-Mask: 0x01)               */
#define FLASH_PROCON1_S12_S13L_Pos            (11UL)                    /*!< FLASH PROCON1: S12_S13L (Bit 11)                            */
#define FLASH_PROCON1_S12_S13L_Msk            (0x800UL)                 /*!< FLASH PROCON1: S12_S13L (Bitfield-Mask: 0x01)               */
#define FLASH_PROCON1_S14_S15L_Pos            (12UL)                    /*!< FLASH PROCON1: S14_S15L (Bit 12)                            */
#define FLASH_PROCON1_S14_S15L_Msk            (0x1000UL)                /*!< FLASH PROCON1: S14_S15L (Bitfield-Mask: 0x01)               */
#define FLASH_PROCON1_PSR_Pos                 (16UL)                    /*!< FLASH PROCON1: PSR (Bit 16)                                 */
#define FLASH_PROCON1_PSR_Msk                 (0x10000UL)               /*!< FLASH PROCON1: PSR (Bitfield-Mask: 0x01)                    */

/* --------------------------------  FLASH_PROCON2  ------------------------------- */
#define FLASH_PROCON2_S0ROM_Pos               (0UL)                     /*!< FLASH PROCON2: S0ROM (Bit 0)                                */
#define FLASH_PROCON2_S0ROM_Msk               (0x1UL)                   /*!< FLASH PROCON2: S0ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S1ROM_Pos               (1UL)                     /*!< FLASH PROCON2: S1ROM (Bit 1)                                */
#define FLASH_PROCON2_S1ROM_Msk               (0x2UL)                   /*!< FLASH PROCON2: S1ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S2ROM_Pos               (2UL)                     /*!< FLASH PROCON2: S2ROM (Bit 2)                                */
#define FLASH_PROCON2_S2ROM_Msk               (0x4UL)                   /*!< FLASH PROCON2: S2ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S3ROM_Pos               (3UL)                     /*!< FLASH PROCON2: S3ROM (Bit 3)                                */
#define FLASH_PROCON2_S3ROM_Msk               (0x8UL)                   /*!< FLASH PROCON2: S3ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S4ROM_Pos               (4UL)                     /*!< FLASH PROCON2: S4ROM (Bit 4)                                */
#define FLASH_PROCON2_S4ROM_Msk               (0x10UL)                  /*!< FLASH PROCON2: S4ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S5ROM_Pos               (5UL)                     /*!< FLASH PROCON2: S5ROM (Bit 5)                                */
#define FLASH_PROCON2_S5ROM_Msk               (0x20UL)                  /*!< FLASH PROCON2: S5ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S6ROM_Pos               (6UL)                     /*!< FLASH PROCON2: S6ROM (Bit 6)                                */
#define FLASH_PROCON2_S6ROM_Msk               (0x40UL)                  /*!< FLASH PROCON2: S6ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S7ROM_Pos               (7UL)                     /*!< FLASH PROCON2: S7ROM (Bit 7)                                */
#define FLASH_PROCON2_S7ROM_Msk               (0x80UL)                  /*!< FLASH PROCON2: S7ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S8ROM_Pos               (8UL)                     /*!< FLASH PROCON2: S8ROM (Bit 8)                                */
#define FLASH_PROCON2_S8ROM_Msk               (0x100UL)                 /*!< FLASH PROCON2: S8ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S9ROM_Pos               (9UL)                     /*!< FLASH PROCON2: S9ROM (Bit 9)                                */
#define FLASH_PROCON2_S9ROM_Msk               (0x200UL)                 /*!< FLASH PROCON2: S9ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S10_S11ROM_Pos          (10UL)                    /*!< FLASH PROCON2: S10_S11ROM (Bit 10)                          */
#define FLASH_PROCON2_S10_S11ROM_Msk          (0x400UL)                 /*!< FLASH PROCON2: S10_S11ROM (Bitfield-Mask: 0x01)             */
#define FLASH_PROCON2_S12_S13ROM_Pos          (11UL)                    /*!< FLASH PROCON2: S12_S13ROM (Bit 11)                          */
#define FLASH_PROCON2_S12_S13ROM_Msk          (0x800UL)                 /*!< FLASH PROCON2: S12_S13ROM (Bitfield-Mask: 0x01)             */
#define FLASH_PROCON2_S14_S15ROM_Pos          (12UL)                    /*!< FLASH PROCON2: S14_S15ROM (Bit 12)                          */
#define FLASH_PROCON2_S14_S15ROM_Msk          (0x1000UL)                /*!< FLASH PROCON2: S14_S15ROM (Bitfield-Mask: 0x01)             */


/* ================================================================================ */
/* ================          struct 'PREF' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  PREF_PCON  --------------------------------- */
#define PREF_PCON_IBYP_Pos                    (0UL)                     /*!< PREF PCON: IBYP (Bit 0)                                     */
#define PREF_PCON_IBYP_Msk                    (0x1UL)                   /*!< PREF PCON: IBYP (Bitfield-Mask: 0x01)                       */
#define PREF_PCON_IINV_Pos                    (1UL)                     /*!< PREF PCON: IINV (Bit 1)                                     */
#define PREF_PCON_IINV_Msk                    (0x2UL)                   /*!< PREF PCON: IINV (Bitfield-Mask: 0x01)                       */
#define PREF_PCON_DBYP_Pos                    (4UL)                     /*!< PREF PCON: DBYP (Bit 4)                                     */
#define PREF_PCON_DBYP_Msk                    (0x10UL)                  /*!< PREF PCON: DBYP (Bitfield-Mask: 0x01)                       */


/* ================================================================================ */
/* ================           Group 'PMU' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  PMU_ID  ----------------------------------- */
#define PMU_ID_MOD_REV_Pos                    (0UL)                     /*!< PMU ID: MOD_REV (Bit 0)                                     */
#define PMU_ID_MOD_REV_Msk                    (0xffUL)                  /*!< PMU ID: MOD_REV (Bitfield-Mask: 0xff)                       */
#define PMU_ID_MOD_TYPE_Pos                   (8UL)                     /*!< PMU ID: MOD_TYPE (Bit 8)                                    */
#define PMU_ID_MOD_TYPE_Msk                   (0xff00UL)                /*!< PMU ID: MOD_TYPE (Bitfield-Mask: 0xff)                      */
#define PMU_ID_MOD_NUMBER_Pos                 (16UL)                    /*!< PMU ID: MOD_NUMBER (Bit 16)                                 */
#define PMU_ID_MOD_NUMBER_Msk                 (0xffff0000UL)            /*!< PMU ID: MOD_NUMBER (Bitfield-Mask: 0xffff)                  */


/* ================================================================================ */
/* ================          struct 'WDT' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  WDT_ID  ----------------------------------- */
#define WDT_ID_MOD_REV_Pos                    (0UL)                     /*!< WDT ID: MOD_REV (Bit 0)                                     */
#define WDT_ID_MOD_REV_Msk                    (0xffUL)                  /*!< WDT ID: MOD_REV (Bitfield-Mask: 0xff)                       */
#define WDT_ID_MOD_TYPE_Pos                   (8UL)                     /*!< WDT ID: MOD_TYPE (Bit 8)                                    */
#define WDT_ID_MOD_TYPE_Msk                   (0xff00UL)                /*!< WDT ID: MOD_TYPE (Bitfield-Mask: 0xff)                      */
#define WDT_ID_MOD_NUMBER_Pos                 (16UL)                    /*!< WDT ID: MOD_NUMBER (Bit 16)                                 */
#define WDT_ID_MOD_NUMBER_Msk                 (0xffff0000UL)            /*!< WDT ID: MOD_NUMBER (Bitfield-Mask: 0xffff)                  */

/* -----------------------------------  WDT_CTR  ---------------------------------- */
#define WDT_CTR_ENB_Pos                       (0UL)                     /*!< WDT CTR: ENB (Bit 0)                                        */
#define WDT_CTR_ENB_Msk                       (0x1UL)                   /*!< WDT CTR: ENB (Bitfield-Mask: 0x01)                          */
#define WDT_CTR_PRE_Pos                       (1UL)                     /*!< WDT CTR: PRE (Bit 1)                                        */
#define WDT_CTR_PRE_Msk                       (0x2UL)                   /*!< WDT CTR: PRE (Bitfield-Mask: 0x01)                          */
#define WDT_CTR_DSP_Pos                       (4UL)                     /*!< WDT CTR: DSP (Bit 4)                                        */
#define WDT_CTR_DSP_Msk                       (0x10UL)                  /*!< WDT CTR: DSP (Bitfield-Mask: 0x01)                          */
#define WDT_CTR_SPW_Pos                       (8UL)                     /*!< WDT CTR: SPW (Bit 8)                                        */
#define WDT_CTR_SPW_Msk                       (0xff00UL)                /*!< WDT CTR: SPW (Bitfield-Mask: 0xff)                          */

/* -----------------------------------  WDT_SRV  ---------------------------------- */
#define WDT_SRV_SRV_Pos                       (0UL)                     /*!< WDT SRV: SRV (Bit 0)                                        */
#define WDT_SRV_SRV_Msk                       (0xffffffffUL)            /*!< WDT SRV: SRV (Bitfield-Mask: 0xffffffff)                    */

/* -----------------------------------  WDT_TIM  ---------------------------------- */
#define WDT_TIM_TIM_Pos                       (0UL)                     /*!< WDT TIM: TIM (Bit 0)                                        */
#define WDT_TIM_TIM_Msk                       (0xffffffffUL)            /*!< WDT TIM: TIM (Bitfield-Mask: 0xffffffff)                    */

/* -----------------------------------  WDT_WLB  ---------------------------------- */
#define WDT_WLB_WLB_Pos                       (0UL)                     /*!< WDT WLB: WLB (Bit 0)                                        */
#define WDT_WLB_WLB_Msk                       (0xffffffffUL)            /*!< WDT WLB: WLB (Bitfield-Mask: 0xffffffff)                    */

/* -----------------------------------  WDT_WUB  ---------------------------------- */
#define WDT_WUB_WUB_Pos                       (0UL)                     /*!< WDT WUB: WUB (Bit 0)                                        */
#define WDT_WUB_WUB_Msk                       (0xffffffffUL)            /*!< WDT WUB: WUB (Bitfield-Mask: 0xffffffff)                    */

/* ---------------------------------  WDT_WDTSTS  --------------------------------- */
#define WDT_WDTSTS_ALMS_Pos                   (0UL)                     /*!< WDT WDTSTS: ALMS (Bit 0)                                    */
#define WDT_WDTSTS_ALMS_Msk                   (0x1UL)                   /*!< WDT WDTSTS: ALMS (Bitfield-Mask: 0x01)                      */

/* ---------------------------------  WDT_WDTCLR  --------------------------------- */
#define WDT_WDTCLR_ALMC_Pos                   (0UL)                     /*!< WDT WDTCLR: ALMC (Bit 0)                                    */
#define WDT_WDTCLR_ALMC_Msk                   (0x1UL)                   /*!< WDT WDTCLR: ALMC (Bitfield-Mask: 0x01)                      */


/* ================================================================================ */
/* ================          struct 'RTC' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  RTC_ID  ----------------------------------- */
#define RTC_ID_MOD_REV_Pos                    (0UL)                     /*!< RTC ID: MOD_REV (Bit 0)                                     */
#define RTC_ID_MOD_REV_Msk                    (0xffUL)                  /*!< RTC ID: MOD_REV (Bitfield-Mask: 0xff)                       */
#define RTC_ID_MOD_TYPE_Pos                   (8UL)                     /*!< RTC ID: MOD_TYPE (Bit 8)                                    */
#define RTC_ID_MOD_TYPE_Msk                   (0xff00UL)                /*!< RTC ID: MOD_TYPE (Bitfield-Mask: 0xff)                      */
#define RTC_ID_MOD_NUMBER_Pos                 (16UL)                    /*!< RTC ID: MOD_NUMBER (Bit 16)                                 */
#define RTC_ID_MOD_NUMBER_Msk                 (0xffff0000UL)            /*!< RTC ID: MOD_NUMBER (Bitfield-Mask: 0xffff)                  */

/* -----------------------------------  RTC_CTR  ---------------------------------- */
#define RTC_CTR_ENB_Pos                       (0UL)                     /*!< RTC CTR: ENB (Bit 0)                                        */
#define RTC_CTR_ENB_Msk                       (0x1UL)                   /*!< RTC CTR: ENB (Bitfield-Mask: 0x01)                          */
#define RTC_CTR_TAE_Pos                       (2UL)                     /*!< RTC CTR: TAE (Bit 2)                                        */
#define RTC_CTR_TAE_Msk                       (0x4UL)                   /*!< RTC CTR: TAE (Bitfield-Mask: 0x01)                          */
#define RTC_CTR_ESEC_Pos                      (8UL)                     /*!< RTC CTR: ESEC (Bit 8)                                       */
#define RTC_CTR_ESEC_Msk                      (0x100UL)                 /*!< RTC CTR: ESEC (Bitfield-Mask: 0x01)                         */
#define RTC_CTR_EMIC_Pos                      (9UL)                     /*!< RTC CTR: EMIC (Bit 9)                                       */
#define RTC_CTR_EMIC_Msk                      (0x200UL)                 /*!< RTC CTR: EMIC (Bitfield-Mask: 0x01)                         */
#define RTC_CTR_EHOC_Pos                      (10UL)                    /*!< RTC CTR: EHOC (Bit 10)                                      */
#define RTC_CTR_EHOC_Msk                      (0x400UL)                 /*!< RTC CTR: EHOC (Bitfield-Mask: 0x01)                         */
#define RTC_CTR_EDAC_Pos                      (11UL)                    /*!< RTC CTR: EDAC (Bit 11)                                      */
#define RTC_CTR_EDAC_Msk                      (0x800UL)                 /*!< RTC CTR: EDAC (Bitfield-Mask: 0x01)                         */
#define RTC_CTR_EMOC_Pos                      (13UL)                    /*!< RTC CTR: EMOC (Bit 13)                                      */
#define RTC_CTR_EMOC_Msk                      (0x2000UL)                /*!< RTC CTR: EMOC (Bitfield-Mask: 0x01)                         */
#define RTC_CTR_EYEC_Pos                      (14UL)                    /*!< RTC CTR: EYEC (Bit 14)                                      */
#define RTC_CTR_EYEC_Msk                      (0x4000UL)                /*!< RTC CTR: EYEC (Bitfield-Mask: 0x01)                         */
#define RTC_CTR_DIV_Pos                       (16UL)                    /*!< RTC CTR: DIV (Bit 16)                                       */
#define RTC_CTR_DIV_Msk                       (0xffff0000UL)            /*!< RTC CTR: DIV (Bitfield-Mask: 0xffff)                        */

/* ---------------------------------  RTC_RAWSTAT  -------------------------------- */
#define RTC_RAWSTAT_RPSE_Pos                  (0UL)                     /*!< RTC RAWSTAT: RPSE (Bit 0)                                   */
#define RTC_RAWSTAT_RPSE_Msk                  (0x1UL)                   /*!< RTC RAWSTAT: RPSE (Bitfield-Mask: 0x01)                     */
#define RTC_RAWSTAT_RPMI_Pos                  (1UL)                     /*!< RTC RAWSTAT: RPMI (Bit 1)                                   */
#define RTC_RAWSTAT_RPMI_Msk                  (0x2UL)                   /*!< RTC RAWSTAT: RPMI (Bitfield-Mask: 0x01)                     */
#define RTC_RAWSTAT_RPHO_Pos                  (2UL)                     /*!< RTC RAWSTAT: RPHO (Bit 2)                                   */
#define RTC_RAWSTAT_RPHO_Msk                  (0x4UL)                   /*!< RTC RAWSTAT: RPHO (Bitfield-Mask: 0x01)                     */
#define RTC_RAWSTAT_RPDA_Pos                  (3UL)                     /*!< RTC RAWSTAT: RPDA (Bit 3)                                   */
#define RTC_RAWSTAT_RPDA_Msk                  (0x8UL)                   /*!< RTC RAWSTAT: RPDA (Bitfield-Mask: 0x01)                     */
#define RTC_RAWSTAT_RPMO_Pos                  (5UL)                     /*!< RTC RAWSTAT: RPMO (Bit 5)                                   */
#define RTC_RAWSTAT_RPMO_Msk                  (0x20UL)                  /*!< RTC RAWSTAT: RPMO (Bitfield-Mask: 0x01)                     */
#define RTC_RAWSTAT_RPYE_Pos                  (6UL)                     /*!< RTC RAWSTAT: RPYE (Bit 6)                                   */
#define RTC_RAWSTAT_RPYE_Msk                  (0x40UL)                  /*!< RTC RAWSTAT: RPYE (Bitfield-Mask: 0x01)                     */
#define RTC_RAWSTAT_RAI_Pos                   (8UL)                     /*!< RTC RAWSTAT: RAI (Bit 8)                                    */
#define RTC_RAWSTAT_RAI_Msk                   (0x100UL)                 /*!< RTC RAWSTAT: RAI (Bitfield-Mask: 0x01)                      */

/* ----------------------------------  RTC_STSSR  --------------------------------- */
#define RTC_STSSR_SPSE_Pos                    (0UL)                     /*!< RTC STSSR: SPSE (Bit 0)                                     */
#define RTC_STSSR_SPSE_Msk                    (0x1UL)                   /*!< RTC STSSR: SPSE (Bitfield-Mask: 0x01)                       */
#define RTC_STSSR_SPMI_Pos                    (1UL)                     /*!< RTC STSSR: SPMI (Bit 1)                                     */
#define RTC_STSSR_SPMI_Msk                    (0x2UL)                   /*!< RTC STSSR: SPMI (Bitfield-Mask: 0x01)                       */
#define RTC_STSSR_SPHO_Pos                    (2UL)                     /*!< RTC STSSR: SPHO (Bit 2)                                     */
#define RTC_STSSR_SPHO_Msk                    (0x4UL)                   /*!< RTC STSSR: SPHO (Bitfield-Mask: 0x01)                       */
#define RTC_STSSR_SPDA_Pos                    (3UL)                     /*!< RTC STSSR: SPDA (Bit 3)                                     */
#define RTC_STSSR_SPDA_Msk                    (0x8UL)                   /*!< RTC STSSR: SPDA (Bitfield-Mask: 0x01)                       */
#define RTC_STSSR_SPMO_Pos                    (5UL)                     /*!< RTC STSSR: SPMO (Bit 5)                                     */
#define RTC_STSSR_SPMO_Msk                    (0x20UL)                  /*!< RTC STSSR: SPMO (Bitfield-Mask: 0x01)                       */
#define RTC_STSSR_SPYE_Pos                    (6UL)                     /*!< RTC STSSR: SPYE (Bit 6)                                     */
#define RTC_STSSR_SPYE_Msk                    (0x40UL)                  /*!< RTC STSSR: SPYE (Bitfield-Mask: 0x01)                       */
#define RTC_STSSR_SAI_Pos                     (8UL)                     /*!< RTC STSSR: SAI (Bit 8)                                      */
#define RTC_STSSR_SAI_Msk                     (0x100UL)                 /*!< RTC STSSR: SAI (Bitfield-Mask: 0x01)                        */

/* ----------------------------------  RTC_MSKSR  --------------------------------- */
#define RTC_MSKSR_MPSE_Pos                    (0UL)                     /*!< RTC MSKSR: MPSE (Bit 0)                                     */
#define RTC_MSKSR_MPSE_Msk                    (0x1UL)                   /*!< RTC MSKSR: MPSE (Bitfield-Mask: 0x01)                       */
#define RTC_MSKSR_MPMI_Pos                    (1UL)                     /*!< RTC MSKSR: MPMI (Bit 1)                                     */
#define RTC_MSKSR_MPMI_Msk                    (0x2UL)                   /*!< RTC MSKSR: MPMI (Bitfield-Mask: 0x01)                       */
#define RTC_MSKSR_MPHO_Pos                    (2UL)                     /*!< RTC MSKSR: MPHO (Bit 2)                                     */
#define RTC_MSKSR_MPHO_Msk                    (0x4UL)                   /*!< RTC MSKSR: MPHO (Bitfield-Mask: 0x01)                       */
#define RTC_MSKSR_MPDA_Pos                    (3UL)                     /*!< RTC MSKSR: MPDA (Bit 3)                                     */
#define RTC_MSKSR_MPDA_Msk                    (0x8UL)                   /*!< RTC MSKSR: MPDA (Bitfield-Mask: 0x01)                       */
#define RTC_MSKSR_MPMO_Pos                    (5UL)                     /*!< RTC MSKSR: MPMO (Bit 5)                                     */
#define RTC_MSKSR_MPMO_Msk                    (0x20UL)                  /*!< RTC MSKSR: MPMO (Bitfield-Mask: 0x01)                       */
#define RTC_MSKSR_MPYE_Pos                    (6UL)                     /*!< RTC MSKSR: MPYE (Bit 6)                                     */
#define RTC_MSKSR_MPYE_Msk                    (0x40UL)                  /*!< RTC MSKSR: MPYE (Bitfield-Mask: 0x01)                       */
#define RTC_MSKSR_MAI_Pos                     (8UL)                     /*!< RTC MSKSR: MAI (Bit 8)                                      */
#define RTC_MSKSR_MAI_Msk                     (0x100UL)                 /*!< RTC MSKSR: MAI (Bitfield-Mask: 0x01)                        */

/* ----------------------------------  RTC_CLRSR  --------------------------------- */
#define RTC_CLRSR_RPSE_Pos                    (0UL)                     /*!< RTC CLRSR: RPSE (Bit 0)                                     */
#define RTC_CLRSR_RPSE_Msk                    (0x1UL)                   /*!< RTC CLRSR: RPSE (Bitfield-Mask: 0x01)                       */
#define RTC_CLRSR_RPMI_Pos                    (1UL)                     /*!< RTC CLRSR: RPMI (Bit 1)                                     */
#define RTC_CLRSR_RPMI_Msk                    (0x2UL)                   /*!< RTC CLRSR: RPMI (Bitfield-Mask: 0x01)                       */
#define RTC_CLRSR_RPHO_Pos                    (2UL)                     /*!< RTC CLRSR: RPHO (Bit 2)                                     */
#define RTC_CLRSR_RPHO_Msk                    (0x4UL)                   /*!< RTC CLRSR: RPHO (Bitfield-Mask: 0x01)                       */
#define RTC_CLRSR_RPDA_Pos                    (3UL)                     /*!< RTC CLRSR: RPDA (Bit 3)                                     */
#define RTC_CLRSR_RPDA_Msk                    (0x8UL)                   /*!< RTC CLRSR: RPDA (Bitfield-Mask: 0x01)                       */
#define RTC_CLRSR_RPMO_Pos                    (5UL)                     /*!< RTC CLRSR: RPMO (Bit 5)                                     */
#define RTC_CLRSR_RPMO_Msk                    (0x20UL)                  /*!< RTC CLRSR: RPMO (Bitfield-Mask: 0x01)                       */
#define RTC_CLRSR_RPYE_Pos                    (6UL)                     /*!< RTC CLRSR: RPYE (Bit 6)                                     */
#define RTC_CLRSR_RPYE_Msk                    (0x40UL)                  /*!< RTC CLRSR: RPYE (Bitfield-Mask: 0x01)                       */
#define RTC_CLRSR_RAI_Pos                     (8UL)                     /*!< RTC CLRSR: RAI (Bit 8)                                      */
#define RTC_CLRSR_RAI_Msk                     (0x100UL)                 /*!< RTC CLRSR: RAI (Bitfield-Mask: 0x01)                        */

/* ----------------------------------  RTC_ATIM0  --------------------------------- */
#define RTC_ATIM0_ASE_Pos                     (0UL)                     /*!< RTC ATIM0: ASE (Bit 0)                                      */
#define RTC_ATIM0_ASE_Msk                     (0x3fUL)                  /*!< RTC ATIM0: ASE (Bitfield-Mask: 0x3f)                        */
#define RTC_ATIM0_AMI_Pos                     (8UL)                     /*!< RTC ATIM0: AMI (Bit 8)                                      */
#define RTC_ATIM0_AMI_Msk                     (0x3f00UL)                /*!< RTC ATIM0: AMI (Bitfield-Mask: 0x3f)                        */
#define RTC_ATIM0_AHO_Pos                     (16UL)                    /*!< RTC ATIM0: AHO (Bit 16)                                     */
#define RTC_ATIM0_AHO_Msk                     (0x1f0000UL)              /*!< RTC ATIM0: AHO (Bitfield-Mask: 0x1f)                        */
#define RTC_ATIM0_ADA_Pos                     (24UL)                    /*!< RTC ATIM0: ADA (Bit 24)                                     */
#define RTC_ATIM0_ADA_Msk                     (0x1f000000UL)            /*!< RTC ATIM0: ADA (Bitfield-Mask: 0x1f)                        */

/* ----------------------------------  RTC_ATIM1  --------------------------------- */
#define RTC_ATIM1_AMO_Pos                     (8UL)                     /*!< RTC ATIM1: AMO (Bit 8)                                      */
#define RTC_ATIM1_AMO_Msk                     (0xf00UL)                 /*!< RTC ATIM1: AMO (Bitfield-Mask: 0x0f)                        */
#define RTC_ATIM1_AYE_Pos                     (16UL)                    /*!< RTC ATIM1: AYE (Bit 16)                                     */
#define RTC_ATIM1_AYE_Msk                     (0xffff0000UL)            /*!< RTC ATIM1: AYE (Bitfield-Mask: 0xffff)                      */

/* ----------------------------------  RTC_TIM0  ---------------------------------- */
#define RTC_TIM0_SE_Pos                       (0UL)                     /*!< RTC TIM0: SE (Bit 0)                                        */
#define RTC_TIM0_SE_Msk                       (0x3fUL)                  /*!< RTC TIM0: SE (Bitfield-Mask: 0x3f)                          */
#define RTC_TIM0_MI_Pos                       (8UL)                     /*!< RTC TIM0: MI (Bit 8)                                        */
#define RTC_TIM0_MI_Msk                       (0x3f00UL)                /*!< RTC TIM0: MI (Bitfield-Mask: 0x3f)                          */
#define RTC_TIM0_HO_Pos                       (16UL)                    /*!< RTC TIM0: HO (Bit 16)                                       */
#define RTC_TIM0_HO_Msk                       (0x1f0000UL)              /*!< RTC TIM0: HO (Bitfield-Mask: 0x1f)                          */
#define RTC_TIM0_DA_Pos                       (24UL)                    /*!< RTC TIM0: DA (Bit 24)                                       */
#define RTC_TIM0_DA_Msk                       (0x1f000000UL)            /*!< RTC TIM0: DA (Bitfield-Mask: 0x1f)                          */

/* ----------------------------------  RTC_TIM1  ---------------------------------- */
#define RTC_TIM1_DAWE_Pos                     (0UL)                     /*!< RTC TIM1: DAWE (Bit 0)                                      */
#define RTC_TIM1_DAWE_Msk                     (0x7UL)                   /*!< RTC TIM1: DAWE (Bitfield-Mask: 0x07)                        */
#define RTC_TIM1_MO_Pos                       (8UL)                     /*!< RTC TIM1: MO (Bit 8)                                        */
#define RTC_TIM1_MO_Msk                       (0xf00UL)                 /*!< RTC TIM1: MO (Bitfield-Mask: 0x0f)                          */
#define RTC_TIM1_YE_Pos                       (16UL)                    /*!< RTC TIM1: YE (Bit 16)                                       */
#define RTC_TIM1_YE_Msk                       (0xffff0000UL)            /*!< RTC TIM1: YE (Bitfield-Mask: 0xffff)                        */


/* ================================================================================ */
/* ================        struct 'SCU_CLK' Position & Mask        ================ */
/* ================================================================================ */


/* -------------------------------  SCU_CLK_CLKSTAT  ------------------------------ */
#define SCU_CLK_CLKSTAT_USBCST_Pos            (0UL)                     /*!< SCU_CLK CLKSTAT: USBCST (Bit 0)                             */
#define SCU_CLK_CLKSTAT_USBCST_Msk            (0x1UL)                   /*!< SCU_CLK CLKSTAT: USBCST (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CLKSTAT_MMCCST_Pos            (1UL)                     /*!< SCU_CLK CLKSTAT: MMCCST (Bit 1)                             */
#define SCU_CLK_CLKSTAT_MMCCST_Msk            (0x2UL)                   /*!< SCU_CLK CLKSTAT: MMCCST (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CLKSTAT_ETH0CST_Pos           (2UL)                     /*!< SCU_CLK CLKSTAT: ETH0CST (Bit 2)                            */
#define SCU_CLK_CLKSTAT_ETH0CST_Msk           (0x4UL)                   /*!< SCU_CLK CLKSTAT: ETH0CST (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CLKSTAT_EBUCST_Pos            (3UL)                     /*!< SCU_CLK CLKSTAT: EBUCST (Bit 3)                             */
#define SCU_CLK_CLKSTAT_EBUCST_Msk            (0x8UL)                   /*!< SCU_CLK CLKSTAT: EBUCST (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CLKSTAT_CCUCST_Pos            (4UL)                     /*!< SCU_CLK CLKSTAT: CCUCST (Bit 4)                             */
#define SCU_CLK_CLKSTAT_CCUCST_Msk            (0x10UL)                  /*!< SCU_CLK CLKSTAT: CCUCST (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CLKSTAT_WDTCST_Pos            (5UL)                     /*!< SCU_CLK CLKSTAT: WDTCST (Bit 5)                             */
#define SCU_CLK_CLKSTAT_WDTCST_Msk            (0x20UL)                  /*!< SCU_CLK CLKSTAT: WDTCST (Bitfield-Mask: 0x01)               */

/* -------------------------------  SCU_CLK_CLKSET  ------------------------------- */
#define SCU_CLK_CLKSET_USBCEN_Pos             (0UL)                     /*!< SCU_CLK CLKSET: USBCEN (Bit 0)                              */
#define SCU_CLK_CLKSET_USBCEN_Msk             (0x1UL)                   /*!< SCU_CLK CLKSET: USBCEN (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CLKSET_MMCCEN_Pos             (1UL)                     /*!< SCU_CLK CLKSET: MMCCEN (Bit 1)                              */
#define SCU_CLK_CLKSET_MMCCEN_Msk             (0x2UL)                   /*!< SCU_CLK CLKSET: MMCCEN (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CLKSET_ETH0CEN_Pos            (2UL)                     /*!< SCU_CLK CLKSET: ETH0CEN (Bit 2)                             */
#define SCU_CLK_CLKSET_ETH0CEN_Msk            (0x4UL)                   /*!< SCU_CLK CLKSET: ETH0CEN (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CLKSET_EBUCEN_Pos             (3UL)                     /*!< SCU_CLK CLKSET: EBUCEN (Bit 3)                              */
#define SCU_CLK_CLKSET_EBUCEN_Msk             (0x8UL)                   /*!< SCU_CLK CLKSET: EBUCEN (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CLKSET_CCUCEN_Pos             (4UL)                     /*!< SCU_CLK CLKSET: CCUCEN (Bit 4)                              */
#define SCU_CLK_CLKSET_CCUCEN_Msk             (0x10UL)                  /*!< SCU_CLK CLKSET: CCUCEN (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CLKSET_WDTCEN_Pos             (5UL)                     /*!< SCU_CLK CLKSET: WDTCEN (Bit 5)                              */
#define SCU_CLK_CLKSET_WDTCEN_Msk             (0x20UL)                  /*!< SCU_CLK CLKSET: WDTCEN (Bitfield-Mask: 0x01)                */

/* -------------------------------  SCU_CLK_CLKCLR  ------------------------------- */
#define SCU_CLK_CLKCLR_USBCDI_Pos             (0UL)                     /*!< SCU_CLK CLKCLR: USBCDI (Bit 0)                              */
#define SCU_CLK_CLKCLR_USBCDI_Msk             (0x1UL)                   /*!< SCU_CLK CLKCLR: USBCDI (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CLKCLR_MMCCDI_Pos             (1UL)                     /*!< SCU_CLK CLKCLR: MMCCDI (Bit 1)                              */
#define SCU_CLK_CLKCLR_MMCCDI_Msk             (0x2UL)                   /*!< SCU_CLK CLKCLR: MMCCDI (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CLKCLR_ETH0CDI_Pos            (2UL)                     /*!< SCU_CLK CLKCLR: ETH0CDI (Bit 2)                             */
#define SCU_CLK_CLKCLR_ETH0CDI_Msk            (0x4UL)                   /*!< SCU_CLK CLKCLR: ETH0CDI (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CLKCLR_EBUCDI_Pos             (3UL)                     /*!< SCU_CLK CLKCLR: EBUCDI (Bit 3)                              */
#define SCU_CLK_CLKCLR_EBUCDI_Msk             (0x8UL)                   /*!< SCU_CLK CLKCLR: EBUCDI (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CLKCLR_CCUCDI_Pos             (4UL)                     /*!< SCU_CLK CLKCLR: CCUCDI (Bit 4)                              */
#define SCU_CLK_CLKCLR_CCUCDI_Msk             (0x10UL)                  /*!< SCU_CLK CLKCLR: CCUCDI (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CLKCLR_WDTCDI_Pos             (5UL)                     /*!< SCU_CLK CLKCLR: WDTCDI (Bit 5)                              */
#define SCU_CLK_CLKCLR_WDTCDI_Msk             (0x20UL)                  /*!< SCU_CLK CLKCLR: WDTCDI (Bitfield-Mask: 0x01)                */

/* ------------------------------  SCU_CLK_SYSCLKCR  ------------------------------ */
#define SCU_CLK_SYSCLKCR_SYSDIV_Pos           (0UL)                     /*!< SCU_CLK SYSCLKCR: SYSDIV (Bit 0)                            */
#define SCU_CLK_SYSCLKCR_SYSDIV_Msk           (0xffUL)                  /*!< SCU_CLK SYSCLKCR: SYSDIV (Bitfield-Mask: 0xff)              */
#define SCU_CLK_SYSCLKCR_SYSSEL_Pos           (16UL)                    /*!< SCU_CLK SYSCLKCR: SYSSEL (Bit 16)                           */
#define SCU_CLK_SYSCLKCR_SYSSEL_Msk           (0x10000UL)               /*!< SCU_CLK SYSCLKCR: SYSSEL (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_CLK_CPUCLKCR  ------------------------------ */
#define SCU_CLK_CPUCLKCR_CPUDIV_Pos           (0UL)                     /*!< SCU_CLK CPUCLKCR: CPUDIV (Bit 0)                            */
#define SCU_CLK_CPUCLKCR_CPUDIV_Msk           (0x1UL)                   /*!< SCU_CLK CPUCLKCR: CPUDIV (Bitfield-Mask: 0x01)              */

/* -------------------------------  SCU_CLK_PBCLKCR  ------------------------------ */
#define SCU_CLK_PBCLKCR_PBDIV_Pos             (0UL)                     /*!< SCU_CLK PBCLKCR: PBDIV (Bit 0)                              */
#define SCU_CLK_PBCLKCR_PBDIV_Msk             (0x1UL)                   /*!< SCU_CLK PBCLKCR: PBDIV (Bitfield-Mask: 0x01)                */

/* ------------------------------  SCU_CLK_USBCLKCR  ------------------------------ */
#define SCU_CLK_USBCLKCR_USBDIV_Pos           (0UL)                     /*!< SCU_CLK USBCLKCR: USBDIV (Bit 0)                            */
#define SCU_CLK_USBCLKCR_USBDIV_Msk           (0x7UL)                   /*!< SCU_CLK USBCLKCR: USBDIV (Bitfield-Mask: 0x07)              */
#define SCU_CLK_USBCLKCR_USBSEL_Pos           (16UL)                    /*!< SCU_CLK USBCLKCR: USBSEL (Bit 16)                           */
#define SCU_CLK_USBCLKCR_USBSEL_Msk           (0x10000UL)               /*!< SCU_CLK USBCLKCR: USBSEL (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_CLK_EBUCLKCR  ------------------------------ */
#define SCU_CLK_EBUCLKCR_EBUDIV_Pos           (0UL)                     /*!< SCU_CLK EBUCLKCR: EBUDIV (Bit 0)                            */
#define SCU_CLK_EBUCLKCR_EBUDIV_Msk           (0x3fUL)                  /*!< SCU_CLK EBUCLKCR: EBUDIV (Bitfield-Mask: 0x3f)              */

/* ------------------------------  SCU_CLK_CCUCLKCR  ------------------------------ */
#define SCU_CLK_CCUCLKCR_CCUDIV_Pos           (0UL)                     /*!< SCU_CLK CCUCLKCR: CCUDIV (Bit 0)                            */
#define SCU_CLK_CCUCLKCR_CCUDIV_Msk           (0x1UL)                   /*!< SCU_CLK CCUCLKCR: CCUDIV (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_CLK_WDTCLKCR  ------------------------------ */
#define SCU_CLK_WDTCLKCR_WDTDIV_Pos           (0UL)                     /*!< SCU_CLK WDTCLKCR: WDTDIV (Bit 0)                            */
#define SCU_CLK_WDTCLKCR_WDTDIV_Msk           (0xffUL)                  /*!< SCU_CLK WDTCLKCR: WDTDIV (Bitfield-Mask: 0xff)              */
#define SCU_CLK_WDTCLKCR_WDTSEL_Pos           (16UL)                    /*!< SCU_CLK WDTCLKCR: WDTSEL (Bit 16)                           */
#define SCU_CLK_WDTCLKCR_WDTSEL_Msk           (0x30000UL)               /*!< SCU_CLK WDTCLKCR: WDTSEL (Bitfield-Mask: 0x03)              */

/* ------------------------------  SCU_CLK_EXTCLKCR  ------------------------------ */
#define SCU_CLK_EXTCLKCR_ECKSEL_Pos           (0UL)                     /*!< SCU_CLK EXTCLKCR: ECKSEL (Bit 0)                            */
#define SCU_CLK_EXTCLKCR_ECKSEL_Msk           (0x3UL)                   /*!< SCU_CLK EXTCLKCR: ECKSEL (Bitfield-Mask: 0x03)              */
#define SCU_CLK_EXTCLKCR_ECKDIV_Pos           (16UL)                    /*!< SCU_CLK EXTCLKCR: ECKDIV (Bit 16)                           */
#define SCU_CLK_EXTCLKCR_ECKDIV_Msk           (0x1ff0000UL)             /*!< SCU_CLK EXTCLKCR: ECKDIV (Bitfield-Mask: 0x1ff)             */

/* -----------------------------  SCU_CLK_MLINKCLKCR  ----------------------------- */
#define SCU_CLK_MLINKCLKCR_SYSDIV_Pos         (0UL)                     /*!< SCU_CLK MLINKCLKCR: SYSDIV (Bit 0)                          */
#define SCU_CLK_MLINKCLKCR_SYSDIV_Msk         (0xffUL)                  /*!< SCU_CLK MLINKCLKCR: SYSDIV (Bitfield-Mask: 0xff)            */
#define SCU_CLK_MLINKCLKCR_SYSSEL_Pos         (8UL)                     /*!< SCU_CLK MLINKCLKCR: SYSSEL (Bit 8)                          */
#define SCU_CLK_MLINKCLKCR_SYSSEL_Msk         (0x100UL)                 /*!< SCU_CLK MLINKCLKCR: SYSSEL (Bitfield-Mask: 0x01)            */
#define SCU_CLK_MLINKCLKCR_CPUDIV_Pos         (10UL)                    /*!< SCU_CLK MLINKCLKCR: CPUDIV (Bit 10)                         */
#define SCU_CLK_MLINKCLKCR_CPUDIV_Msk         (0x400UL)                 /*!< SCU_CLK MLINKCLKCR: CPUDIV (Bitfield-Mask: 0x01)            */
#define SCU_CLK_MLINKCLKCR_PBDIV_Pos          (12UL)                    /*!< SCU_CLK MLINKCLKCR: PBDIV (Bit 12)                          */
#define SCU_CLK_MLINKCLKCR_PBDIV_Msk          (0x1000UL)                /*!< SCU_CLK MLINKCLKCR: PBDIV (Bitfield-Mask: 0x01)             */
#define SCU_CLK_MLINKCLKCR_CCUDIV_Pos         (14UL)                    /*!< SCU_CLK MLINKCLKCR: CCUDIV (Bit 14)                         */
#define SCU_CLK_MLINKCLKCR_CCUDIV_Msk         (0x4000UL)                /*!< SCU_CLK MLINKCLKCR: CCUDIV (Bitfield-Mask: 0x01)            */
#define SCU_CLK_MLINKCLKCR_WDTDIV_Pos         (16UL)                    /*!< SCU_CLK MLINKCLKCR: WDTDIV (Bit 16)                         */
#define SCU_CLK_MLINKCLKCR_WDTDIV_Msk         (0xff0000UL)              /*!< SCU_CLK MLINKCLKCR: WDTDIV (Bitfield-Mask: 0xff)            */
#define SCU_CLK_MLINKCLKCR_WDTSEL_Pos         (24UL)                    /*!< SCU_CLK MLINKCLKCR: WDTSEL (Bit 24)                         */
#define SCU_CLK_MLINKCLKCR_WDTSEL_Msk         (0x3000000UL)             /*!< SCU_CLK MLINKCLKCR: WDTSEL (Bitfield-Mask: 0x03)            */
#define SCU_CLK_MLINKCLKCR_EBUDIV_Pos         (26UL)                    /*!< SCU_CLK MLINKCLKCR: EBUDIV (Bit 26)                         */
#define SCU_CLK_MLINKCLKCR_EBUDIV_Msk         (0xfc000000UL)            /*!< SCU_CLK MLINKCLKCR: EBUDIV (Bitfield-Mask: 0x3f)            */

/* -------------------------------  SCU_CLK_SLEEPCR  ------------------------------ */
#define SCU_CLK_SLEEPCR_SYSSEL_Pos            (0UL)                     /*!< SCU_CLK SLEEPCR: SYSSEL (Bit 0)                             */
#define SCU_CLK_SLEEPCR_SYSSEL_Msk            (0x1UL)                   /*!< SCU_CLK SLEEPCR: SYSSEL (Bitfield-Mask: 0x01)               */
#define SCU_CLK_SLEEPCR_USBCR_Pos             (16UL)                    /*!< SCU_CLK SLEEPCR: USBCR (Bit 16)                             */
#define SCU_CLK_SLEEPCR_USBCR_Msk             (0x10000UL)               /*!< SCU_CLK SLEEPCR: USBCR (Bitfield-Mask: 0x01)                */
#define SCU_CLK_SLEEPCR_MMCCR_Pos             (17UL)                    /*!< SCU_CLK SLEEPCR: MMCCR (Bit 17)                             */
#define SCU_CLK_SLEEPCR_MMCCR_Msk             (0x20000UL)               /*!< SCU_CLK SLEEPCR: MMCCR (Bitfield-Mask: 0x01)                */
#define SCU_CLK_SLEEPCR_ETH0CR_Pos            (18UL)                    /*!< SCU_CLK SLEEPCR: ETH0CR (Bit 18)                            */
#define SCU_CLK_SLEEPCR_ETH0CR_Msk            (0x40000UL)               /*!< SCU_CLK SLEEPCR: ETH0CR (Bitfield-Mask: 0x01)               */
#define SCU_CLK_SLEEPCR_EBUCR_Pos             (19UL)                    /*!< SCU_CLK SLEEPCR: EBUCR (Bit 19)                             */
#define SCU_CLK_SLEEPCR_EBUCR_Msk             (0x80000UL)               /*!< SCU_CLK SLEEPCR: EBUCR (Bitfield-Mask: 0x01)                */
#define SCU_CLK_SLEEPCR_CCUCR_Pos             (20UL)                    /*!< SCU_CLK SLEEPCR: CCUCR (Bit 20)                             */
#define SCU_CLK_SLEEPCR_CCUCR_Msk             (0x100000UL)              /*!< SCU_CLK SLEEPCR: CCUCR (Bitfield-Mask: 0x01)                */
#define SCU_CLK_SLEEPCR_WDTCR_Pos             (21UL)                    /*!< SCU_CLK SLEEPCR: WDTCR (Bit 21)                             */
#define SCU_CLK_SLEEPCR_WDTCR_Msk             (0x200000UL)              /*!< SCU_CLK SLEEPCR: WDTCR (Bitfield-Mask: 0x01)                */

/* ------------------------------  SCU_CLK_DSLEEPCR  ------------------------------ */
#define SCU_CLK_DSLEEPCR_SYSSEL_Pos           (0UL)                     /*!< SCU_CLK DSLEEPCR: SYSSEL (Bit 0)                            */
#define SCU_CLK_DSLEEPCR_SYSSEL_Msk           (0x3UL)                   /*!< SCU_CLK DSLEEPCR: SYSSEL (Bitfield-Mask: 0x03)              */
#define SCU_CLK_DSLEEPCR_FPDN_Pos             (11UL)                    /*!< SCU_CLK DSLEEPCR: FPDN (Bit 11)                             */
#define SCU_CLK_DSLEEPCR_FPDN_Msk             (0x800UL)                 /*!< SCU_CLK DSLEEPCR: FPDN (Bitfield-Mask: 0x01)                */
#define SCU_CLK_DSLEEPCR_PLLPDN_Pos           (12UL)                    /*!< SCU_CLK DSLEEPCR: PLLPDN (Bit 12)                           */
#define SCU_CLK_DSLEEPCR_PLLPDN_Msk           (0x1000UL)                /*!< SCU_CLK DSLEEPCR: PLLPDN (Bitfield-Mask: 0x01)              */
#define SCU_CLK_DSLEEPCR_VCOPDN_Pos           (13UL)                    /*!< SCU_CLK DSLEEPCR: VCOPDN (Bit 13)                           */
#define SCU_CLK_DSLEEPCR_VCOPDN_Msk           (0x2000UL)                /*!< SCU_CLK DSLEEPCR: VCOPDN (Bitfield-Mask: 0x01)              */
#define SCU_CLK_DSLEEPCR_USBCR_Pos            (16UL)                    /*!< SCU_CLK DSLEEPCR: USBCR (Bit 16)                            */
#define SCU_CLK_DSLEEPCR_USBCR_Msk            (0x10000UL)               /*!< SCU_CLK DSLEEPCR: USBCR (Bitfield-Mask: 0x01)               */
#define SCU_CLK_DSLEEPCR_MMCCR_Pos            (17UL)                    /*!< SCU_CLK DSLEEPCR: MMCCR (Bit 17)                            */
#define SCU_CLK_DSLEEPCR_MMCCR_Msk            (0x20000UL)               /*!< SCU_CLK DSLEEPCR: MMCCR (Bitfield-Mask: 0x01)               */
#define SCU_CLK_DSLEEPCR_ETH0CR_Pos           (18UL)                    /*!< SCU_CLK DSLEEPCR: ETH0CR (Bit 18)                           */
#define SCU_CLK_DSLEEPCR_ETH0CR_Msk           (0x40000UL)               /*!< SCU_CLK DSLEEPCR: ETH0CR (Bitfield-Mask: 0x01)              */
#define SCU_CLK_DSLEEPCR_EBUCR_Pos            (19UL)                    /*!< SCU_CLK DSLEEPCR: EBUCR (Bit 19)                            */
#define SCU_CLK_DSLEEPCR_EBUCR_Msk            (0x80000UL)               /*!< SCU_CLK DSLEEPCR: EBUCR (Bitfield-Mask: 0x01)               */
#define SCU_CLK_DSLEEPCR_CCUCR_Pos            (20UL)                    /*!< SCU_CLK DSLEEPCR: CCUCR (Bit 20)                            */
#define SCU_CLK_DSLEEPCR_CCUCR_Msk            (0x100000UL)              /*!< SCU_CLK DSLEEPCR: CCUCR (Bitfield-Mask: 0x01)               */
#define SCU_CLK_DSLEEPCR_WDTCR_Pos            (21UL)                    /*!< SCU_CLK DSLEEPCR: WDTCR (Bit 21)                            */
#define SCU_CLK_DSLEEPCR_WDTCR_Msk            (0x200000UL)              /*!< SCU_CLK DSLEEPCR: WDTCR (Bitfield-Mask: 0x01)               */

/* ------------------------------  SCU_CLK_ECATCLKCR  ----------------------------- */
#define SCU_CLK_ECATCLKCR_ECADIV_Pos          (0UL)                     /*!< SCU_CLK ECATCLKCR: ECADIV (Bit 0)                           */
#define SCU_CLK_ECATCLKCR_ECADIV_Msk          (0x3UL)                   /*!< SCU_CLK ECATCLKCR: ECADIV (Bitfield-Mask: 0x03)             */
#define SCU_CLK_ECATCLKCR_ECATSEL_Pos         (16UL)                    /*!< SCU_CLK ECATCLKCR: ECATSEL (Bit 16)                         */
#define SCU_CLK_ECATCLKCR_ECATSEL_Msk         (0x10000UL)               /*!< SCU_CLK ECATCLKCR: ECATSEL (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_CLK_CGATSTAT0  ----------------------------- */
#define SCU_CLK_CGATSTAT0_VADC_Pos            (0UL)                     /*!< SCU_CLK CGATSTAT0: VADC (Bit 0)                             */
#define SCU_CLK_CGATSTAT0_VADC_Msk            (0x1UL)                   /*!< SCU_CLK CGATSTAT0: VADC (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSTAT0_DSD_Pos             (1UL)                     /*!< SCU_CLK CGATSTAT0: DSD (Bit 1)                              */
#define SCU_CLK_CGATSTAT0_DSD_Msk             (0x2UL)                   /*!< SCU_CLK CGATSTAT0: DSD (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSTAT0_CCU40_Pos           (2UL)                     /*!< SCU_CLK CGATSTAT0: CCU40 (Bit 2)                            */
#define SCU_CLK_CGATSTAT0_CCU40_Msk           (0x4UL)                   /*!< SCU_CLK CGATSTAT0: CCU40 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT0_CCU41_Pos           (3UL)                     /*!< SCU_CLK CGATSTAT0: CCU41 (Bit 3)                            */
#define SCU_CLK_CGATSTAT0_CCU41_Msk           (0x8UL)                   /*!< SCU_CLK CGATSTAT0: CCU41 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT0_CCU42_Pos           (4UL)                     /*!< SCU_CLK CGATSTAT0: CCU42 (Bit 4)                            */
#define SCU_CLK_CGATSTAT0_CCU42_Msk           (0x10UL)                  /*!< SCU_CLK CGATSTAT0: CCU42 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT0_CCU80_Pos           (7UL)                     /*!< SCU_CLK CGATSTAT0: CCU80 (Bit 7)                            */
#define SCU_CLK_CGATSTAT0_CCU80_Msk           (0x80UL)                  /*!< SCU_CLK CGATSTAT0: CCU80 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT0_CCU81_Pos           (8UL)                     /*!< SCU_CLK CGATSTAT0: CCU81 (Bit 8)                            */
#define SCU_CLK_CGATSTAT0_CCU81_Msk           (0x100UL)                 /*!< SCU_CLK CGATSTAT0: CCU81 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT0_POSIF0_Pos          (9UL)                     /*!< SCU_CLK CGATSTAT0: POSIF0 (Bit 9)                           */
#define SCU_CLK_CGATSTAT0_POSIF0_Msk          (0x200UL)                 /*!< SCU_CLK CGATSTAT0: POSIF0 (Bitfield-Mask: 0x01)             */
#define SCU_CLK_CGATSTAT0_POSIF1_Pos          (10UL)                    /*!< SCU_CLK CGATSTAT0: POSIF1 (Bit 10)                          */
#define SCU_CLK_CGATSTAT0_POSIF1_Msk          (0x400UL)                 /*!< SCU_CLK CGATSTAT0: POSIF1 (Bitfield-Mask: 0x01)             */
#define SCU_CLK_CGATSTAT0_USIC0_Pos           (11UL)                    /*!< SCU_CLK CGATSTAT0: USIC0 (Bit 11)                           */
#define SCU_CLK_CGATSTAT0_USIC0_Msk           (0x800UL)                 /*!< SCU_CLK CGATSTAT0: USIC0 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT0_ERU1_Pos            (16UL)                    /*!< SCU_CLK CGATSTAT0: ERU1 (Bit 16)                            */
#define SCU_CLK_CGATSTAT0_ERU1_Msk            (0x10000UL)               /*!< SCU_CLK CGATSTAT0: ERU1 (Bitfield-Mask: 0x01)               */

/* ------------------------------  SCU_CLK_CGATSET0  ------------------------------ */
#define SCU_CLK_CGATSET0_VADC_Pos             (0UL)                     /*!< SCU_CLK CGATSET0: VADC (Bit 0)                              */
#define SCU_CLK_CGATSET0_VADC_Msk             (0x1UL)                   /*!< SCU_CLK CGATSET0: VADC (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSET0_DSD_Pos              (1UL)                     /*!< SCU_CLK CGATSET0: DSD (Bit 1)                               */
#define SCU_CLK_CGATSET0_DSD_Msk              (0x2UL)                   /*!< SCU_CLK CGATSET0: DSD (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATSET0_CCU40_Pos            (2UL)                     /*!< SCU_CLK CGATSET0: CCU40 (Bit 2)                             */
#define SCU_CLK_CGATSET0_CCU40_Msk            (0x4UL)                   /*!< SCU_CLK CGATSET0: CCU40 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET0_CCU41_Pos            (3UL)                     /*!< SCU_CLK CGATSET0: CCU41 (Bit 3)                             */
#define SCU_CLK_CGATSET0_CCU41_Msk            (0x8UL)                   /*!< SCU_CLK CGATSET0: CCU41 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET0_CCU42_Pos            (4UL)                     /*!< SCU_CLK CGATSET0: CCU42 (Bit 4)                             */
#define SCU_CLK_CGATSET0_CCU42_Msk            (0x10UL)                  /*!< SCU_CLK CGATSET0: CCU42 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET0_CCU80_Pos            (7UL)                     /*!< SCU_CLK CGATSET0: CCU80 (Bit 7)                             */
#define SCU_CLK_CGATSET0_CCU80_Msk            (0x80UL)                  /*!< SCU_CLK CGATSET0: CCU80 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET0_CCU81_Pos            (8UL)                     /*!< SCU_CLK CGATSET0: CCU81 (Bit 8)                             */
#define SCU_CLK_CGATSET0_CCU81_Msk            (0x100UL)                 /*!< SCU_CLK CGATSET0: CCU81 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET0_POSIF0_Pos           (9UL)                     /*!< SCU_CLK CGATSET0: POSIF0 (Bit 9)                            */
#define SCU_CLK_CGATSET0_POSIF0_Msk           (0x200UL)                 /*!< SCU_CLK CGATSET0: POSIF0 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSET0_POSIF1_Pos           (10UL)                    /*!< SCU_CLK CGATSET0: POSIF1 (Bit 10)                           */
#define SCU_CLK_CGATSET0_POSIF1_Msk           (0x400UL)                 /*!< SCU_CLK CGATSET0: POSIF1 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSET0_USIC0_Pos            (11UL)                    /*!< SCU_CLK CGATSET0: USIC0 (Bit 11)                            */
#define SCU_CLK_CGATSET0_USIC0_Msk            (0x800UL)                 /*!< SCU_CLK CGATSET0: USIC0 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET0_ERU1_Pos             (16UL)                    /*!< SCU_CLK CGATSET0: ERU1 (Bit 16)                             */
#define SCU_CLK_CGATSET0_ERU1_Msk             (0x10000UL)               /*!< SCU_CLK CGATSET0: ERU1 (Bitfield-Mask: 0x01)                */

/* ------------------------------  SCU_CLK_CGATCLR0  ------------------------------ */
#define SCU_CLK_CGATCLR0_VADC_Pos             (0UL)                     /*!< SCU_CLK CGATCLR0: VADC (Bit 0)                              */
#define SCU_CLK_CGATCLR0_VADC_Msk             (0x1UL)                   /*!< SCU_CLK CGATCLR0: VADC (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATCLR0_DSD_Pos              (1UL)                     /*!< SCU_CLK CGATCLR0: DSD (Bit 1)                               */
#define SCU_CLK_CGATCLR0_DSD_Msk              (0x2UL)                   /*!< SCU_CLK CGATCLR0: DSD (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATCLR0_CCU40_Pos            (2UL)                     /*!< SCU_CLK CGATCLR0: CCU40 (Bit 2)                             */
#define SCU_CLK_CGATCLR0_CCU40_Msk            (0x4UL)                   /*!< SCU_CLK CGATCLR0: CCU40 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR0_CCU41_Pos            (3UL)                     /*!< SCU_CLK CGATCLR0: CCU41 (Bit 3)                             */
#define SCU_CLK_CGATCLR0_CCU41_Msk            (0x8UL)                   /*!< SCU_CLK CGATCLR0: CCU41 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR0_CCU42_Pos            (4UL)                     /*!< SCU_CLK CGATCLR0: CCU42 (Bit 4)                             */
#define SCU_CLK_CGATCLR0_CCU42_Msk            (0x10UL)                  /*!< SCU_CLK CGATCLR0: CCU42 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR0_CCU80_Pos            (7UL)                     /*!< SCU_CLK CGATCLR0: CCU80 (Bit 7)                             */
#define SCU_CLK_CGATCLR0_CCU80_Msk            (0x80UL)                  /*!< SCU_CLK CGATCLR0: CCU80 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR0_CCU81_Pos            (8UL)                     /*!< SCU_CLK CGATCLR0: CCU81 (Bit 8)                             */
#define SCU_CLK_CGATCLR0_CCU81_Msk            (0x100UL)                 /*!< SCU_CLK CGATCLR0: CCU81 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR0_POSIF0_Pos           (9UL)                     /*!< SCU_CLK CGATCLR0: POSIF0 (Bit 9)                            */
#define SCU_CLK_CGATCLR0_POSIF0_Msk           (0x200UL)                 /*!< SCU_CLK CGATCLR0: POSIF0 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATCLR0_POSIF1_Pos           (10UL)                    /*!< SCU_CLK CGATCLR0: POSIF1 (Bit 10)                           */
#define SCU_CLK_CGATCLR0_POSIF1_Msk           (0x400UL)                 /*!< SCU_CLK CGATCLR0: POSIF1 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATCLR0_USIC0_Pos            (11UL)                    /*!< SCU_CLK CGATCLR0: USIC0 (Bit 11)                            */
#define SCU_CLK_CGATCLR0_USIC0_Msk            (0x800UL)                 /*!< SCU_CLK CGATCLR0: USIC0 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR0_ERU1_Pos             (16UL)                    /*!< SCU_CLK CGATCLR0: ERU1 (Bit 16)                             */
#define SCU_CLK_CGATCLR0_ERU1_Msk             (0x10000UL)               /*!< SCU_CLK CGATCLR0: ERU1 (Bitfield-Mask: 0x01)                */

/* ------------------------------  SCU_CLK_CGATSTAT1  ----------------------------- */
#define SCU_CLK_CGATSTAT1_CCU43_Pos           (0UL)                     /*!< SCU_CLK CGATSTAT1: CCU43 (Bit 0)                            */
#define SCU_CLK_CGATSTAT1_CCU43_Msk           (0x1UL)                   /*!< SCU_CLK CGATSTAT1: CCU43 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT1_LEDTSCU0_Pos        (3UL)                     /*!< SCU_CLK CGATSTAT1: LEDTSCU0 (Bit 3)                         */
#define SCU_CLK_CGATSTAT1_LEDTSCU0_Msk        (0x8UL)                   /*!< SCU_CLK CGATSTAT1: LEDTSCU0 (Bitfield-Mask: 0x01)           */
#define SCU_CLK_CGATSTAT1_MCAN0_Pos           (4UL)                     /*!< SCU_CLK CGATSTAT1: MCAN0 (Bit 4)                            */
#define SCU_CLK_CGATSTAT1_MCAN0_Msk           (0x10UL)                  /*!< SCU_CLK CGATSTAT1: MCAN0 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT1_DAC_Pos             (5UL)                     /*!< SCU_CLK CGATSTAT1: DAC (Bit 5)                              */
#define SCU_CLK_CGATSTAT1_DAC_Msk             (0x20UL)                  /*!< SCU_CLK CGATSTAT1: DAC (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSTAT1_MMCI_Pos            (6UL)                     /*!< SCU_CLK CGATSTAT1: MMCI (Bit 6)                             */
#define SCU_CLK_CGATSTAT1_MMCI_Msk            (0x40UL)                  /*!< SCU_CLK CGATSTAT1: MMCI (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSTAT1_USIC1_Pos           (7UL)                     /*!< SCU_CLK CGATSTAT1: USIC1 (Bit 7)                            */
#define SCU_CLK_CGATSTAT1_USIC1_Msk           (0x80UL)                  /*!< SCU_CLK CGATSTAT1: USIC1 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT1_USIC2_Pos           (8UL)                     /*!< SCU_CLK CGATSTAT1: USIC2 (Bit 8)                            */
#define SCU_CLK_CGATSTAT1_USIC2_Msk           (0x100UL)                 /*!< SCU_CLK CGATSTAT1: USIC2 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT1_PPORTS_Pos          (9UL)                     /*!< SCU_CLK CGATSTAT1: PPORTS (Bit 9)                           */
#define SCU_CLK_CGATSTAT1_PPORTS_Msk          (0x200UL)                 /*!< SCU_CLK CGATSTAT1: PPORTS (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_CLK_CGATSET1  ------------------------------ */
#define SCU_CLK_CGATSET1_CCU43_Pos            (0UL)                     /*!< SCU_CLK CGATSET1: CCU43 (Bit 0)                             */
#define SCU_CLK_CGATSET1_CCU43_Msk            (0x1UL)                   /*!< SCU_CLK CGATSET1: CCU43 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET1_LEDTSCU0_Pos         (3UL)                     /*!< SCU_CLK CGATSET1: LEDTSCU0 (Bit 3)                          */
#define SCU_CLK_CGATSET1_LEDTSCU0_Msk         (0x8UL)                   /*!< SCU_CLK CGATSET1: LEDTSCU0 (Bitfield-Mask: 0x01)            */
#define SCU_CLK_CGATSET1_MCAN0_Pos            (4UL)                     /*!< SCU_CLK CGATSET1: MCAN0 (Bit 4)                             */
#define SCU_CLK_CGATSET1_MCAN0_Msk            (0x10UL)                  /*!< SCU_CLK CGATSET1: MCAN0 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET1_DAC_Pos              (5UL)                     /*!< SCU_CLK CGATSET1: DAC (Bit 5)                               */
#define SCU_CLK_CGATSET1_DAC_Msk              (0x20UL)                  /*!< SCU_CLK CGATSET1: DAC (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATSET1_MMCI_Pos             (6UL)                     /*!< SCU_CLK CGATSET1: MMCI (Bit 6)                              */
#define SCU_CLK_CGATSET1_MMCI_Msk             (0x40UL)                  /*!< SCU_CLK CGATSET1: MMCI (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSET1_USIC1_Pos            (7UL)                     /*!< SCU_CLK CGATSET1: USIC1 (Bit 7)                             */
#define SCU_CLK_CGATSET1_USIC1_Msk            (0x80UL)                  /*!< SCU_CLK CGATSET1: USIC1 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET1_USIC2_Pos            (8UL)                     /*!< SCU_CLK CGATSET1: USIC2 (Bit 8)                             */
#define SCU_CLK_CGATSET1_USIC2_Msk            (0x100UL)                 /*!< SCU_CLK CGATSET1: USIC2 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET1_PPORTS_Pos           (9UL)                     /*!< SCU_CLK CGATSET1: PPORTS (Bit 9)                            */
#define SCU_CLK_CGATSET1_PPORTS_Msk           (0x200UL)                 /*!< SCU_CLK CGATSET1: PPORTS (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_CLK_CGATCLR1  ------------------------------ */
#define SCU_CLK_CGATCLR1_CCU43_Pos            (0UL)                     /*!< SCU_CLK CGATCLR1: CCU43 (Bit 0)                             */
#define SCU_CLK_CGATCLR1_CCU43_Msk            (0x1UL)                   /*!< SCU_CLK CGATCLR1: CCU43 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR1_LEDTSCU0_Pos         (3UL)                     /*!< SCU_CLK CGATCLR1: LEDTSCU0 (Bit 3)                          */
#define SCU_CLK_CGATCLR1_LEDTSCU0_Msk         (0x8UL)                   /*!< SCU_CLK CGATCLR1: LEDTSCU0 (Bitfield-Mask: 0x01)            */
#define SCU_CLK_CGATCLR1_MCAN0_Pos            (4UL)                     /*!< SCU_CLK CGATCLR1: MCAN0 (Bit 4)                             */
#define SCU_CLK_CGATCLR1_MCAN0_Msk            (0x10UL)                  /*!< SCU_CLK CGATCLR1: MCAN0 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR1_DAC_Pos              (5UL)                     /*!< SCU_CLK CGATCLR1: DAC (Bit 5)                               */
#define SCU_CLK_CGATCLR1_DAC_Msk              (0x20UL)                  /*!< SCU_CLK CGATCLR1: DAC (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATCLR1_MMCI_Pos             (6UL)                     /*!< SCU_CLK CGATCLR1: MMCI (Bit 6)                              */
#define SCU_CLK_CGATCLR1_MMCI_Msk             (0x40UL)                  /*!< SCU_CLK CGATCLR1: MMCI (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATCLR1_USIC1_Pos            (7UL)                     /*!< SCU_CLK CGATCLR1: USIC1 (Bit 7)                             */
#define SCU_CLK_CGATCLR1_USIC1_Msk            (0x80UL)                  /*!< SCU_CLK CGATCLR1: USIC1 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR1_USIC2_Pos            (8UL)                     /*!< SCU_CLK CGATCLR1: USIC2 (Bit 8)                             */
#define SCU_CLK_CGATCLR1_USIC2_Msk            (0x100UL)                 /*!< SCU_CLK CGATCLR1: USIC2 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR1_PPORTS_Pos           (9UL)                     /*!< SCU_CLK CGATCLR1: PPORTS (Bit 9)                            */
#define SCU_CLK_CGATCLR1_PPORTS_Msk           (0x200UL)                 /*!< SCU_CLK CGATCLR1: PPORTS (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_CLK_CGATSTAT2  ----------------------------- */
#define SCU_CLK_CGATSTAT2_WDT_Pos             (1UL)                     /*!< SCU_CLK CGATSTAT2: WDT (Bit 1)                              */
#define SCU_CLK_CGATSTAT2_WDT_Msk             (0x2UL)                   /*!< SCU_CLK CGATSTAT2: WDT (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSTAT2_ETH0_Pos            (2UL)                     /*!< SCU_CLK CGATSTAT2: ETH0 (Bit 2)                             */
#define SCU_CLK_CGATSTAT2_ETH0_Msk            (0x4UL)                   /*!< SCU_CLK CGATSTAT2: ETH0 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSTAT2_DMA0_Pos            (4UL)                     /*!< SCU_CLK CGATSTAT2: DMA0 (Bit 4)                             */
#define SCU_CLK_CGATSTAT2_DMA0_Msk            (0x10UL)                  /*!< SCU_CLK CGATSTAT2: DMA0 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSTAT2_DMA1_Pos            (5UL)                     /*!< SCU_CLK CGATSTAT2: DMA1 (Bit 5)                             */
#define SCU_CLK_CGATSTAT2_DMA1_Msk            (0x20UL)                  /*!< SCU_CLK CGATSTAT2: DMA1 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSTAT2_FCE_Pos             (6UL)                     /*!< SCU_CLK CGATSTAT2: FCE (Bit 6)                              */
#define SCU_CLK_CGATSTAT2_FCE_Msk             (0x40UL)                  /*!< SCU_CLK CGATSTAT2: FCE (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSTAT2_USB_Pos             (7UL)                     /*!< SCU_CLK CGATSTAT2: USB (Bit 7)                              */
#define SCU_CLK_CGATSTAT2_USB_Msk             (0x80UL)                  /*!< SCU_CLK CGATSTAT2: USB (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSTAT2_ECAT0_Pos           (10UL)                    /*!< SCU_CLK CGATSTAT2: ECAT0 (Bit 10)                           */
#define SCU_CLK_CGATSTAT2_ECAT0_Msk           (0x400UL)                 /*!< SCU_CLK CGATSTAT2: ECAT0 (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_CLK_CGATSET2  ------------------------------ */
#define SCU_CLK_CGATSET2_WDT_Pos              (1UL)                     /*!< SCU_CLK CGATSET2: WDT (Bit 1)                               */
#define SCU_CLK_CGATSET2_WDT_Msk              (0x2UL)                   /*!< SCU_CLK CGATSET2: WDT (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATSET2_ETH0_Pos             (2UL)                     /*!< SCU_CLK CGATSET2: ETH0 (Bit 2)                              */
#define SCU_CLK_CGATSET2_ETH0_Msk             (0x4UL)                   /*!< SCU_CLK CGATSET2: ETH0 (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSET2_DMA0_Pos             (4UL)                     /*!< SCU_CLK CGATSET2: DMA0 (Bit 4)                              */
#define SCU_CLK_CGATSET2_DMA0_Msk             (0x10UL)                  /*!< SCU_CLK CGATSET2: DMA0 (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSET2_DMA1_Pos             (5UL)                     /*!< SCU_CLK CGATSET2: DMA1 (Bit 5)                              */
#define SCU_CLK_CGATSET2_DMA1_Msk             (0x20UL)                  /*!< SCU_CLK CGATSET2: DMA1 (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSET2_FCE_Pos              (6UL)                     /*!< SCU_CLK CGATSET2: FCE (Bit 6)                               */
#define SCU_CLK_CGATSET2_FCE_Msk              (0x40UL)                  /*!< SCU_CLK CGATSET2: FCE (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATSET2_USB_Pos              (7UL)                     /*!< SCU_CLK CGATSET2: USB (Bit 7)                               */
#define SCU_CLK_CGATSET2_USB_Msk              (0x80UL)                  /*!< SCU_CLK CGATSET2: USB (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATSET2_ECAT0_Pos            (10UL)                    /*!< SCU_CLK CGATSET2: ECAT0 (Bit 10)                            */
#define SCU_CLK_CGATSET2_ECAT0_Msk            (0x400UL)                 /*!< SCU_CLK CGATSET2: ECAT0 (Bitfield-Mask: 0x01)               */

/* ------------------------------  SCU_CLK_CGATCLR2  ------------------------------ */
#define SCU_CLK_CGATCLR2_WDT_Pos              (1UL)                     /*!< SCU_CLK CGATCLR2: WDT (Bit 1)                               */
#define SCU_CLK_CGATCLR2_WDT_Msk              (0x2UL)                   /*!< SCU_CLK CGATCLR2: WDT (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATCLR2_ETH0_Pos             (2UL)                     /*!< SCU_CLK CGATCLR2: ETH0 (Bit 2)                              */
#define SCU_CLK_CGATCLR2_ETH0_Msk             (0x4UL)                   /*!< SCU_CLK CGATCLR2: ETH0 (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATCLR2_DMA0_Pos             (4UL)                     /*!< SCU_CLK CGATCLR2: DMA0 (Bit 4)                              */
#define SCU_CLK_CGATCLR2_DMA0_Msk             (0x10UL)                  /*!< SCU_CLK CGATCLR2: DMA0 (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATCLR2_DMA1_Pos             (5UL)                     /*!< SCU_CLK CGATCLR2: DMA1 (Bit 5)                              */
#define SCU_CLK_CGATCLR2_DMA1_Msk             (0x20UL)                  /*!< SCU_CLK CGATCLR2: DMA1 (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATCLR2_FCE_Pos              (6UL)                     /*!< SCU_CLK CGATCLR2: FCE (Bit 6)                               */
#define SCU_CLK_CGATCLR2_FCE_Msk              (0x40UL)                  /*!< SCU_CLK CGATCLR2: FCE (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATCLR2_USB_Pos              (7UL)                     /*!< SCU_CLK CGATCLR2: USB (Bit 7)                               */
#define SCU_CLK_CGATCLR2_USB_Msk              (0x80UL)                  /*!< SCU_CLK CGATCLR2: USB (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATCLR2_ECAT0_Pos            (10UL)                    /*!< SCU_CLK CGATCLR2: ECAT0 (Bit 10)                            */
#define SCU_CLK_CGATCLR2_ECAT0_Msk            (0x400UL)                 /*!< SCU_CLK CGATCLR2: ECAT0 (Bitfield-Mask: 0x01)               */

/* ------------------------------  SCU_CLK_CGATSTAT3  ----------------------------- */
#define SCU_CLK_CGATSTAT3_EBU_Pos             (2UL)                     /*!< SCU_CLK CGATSTAT3: EBU (Bit 2)                              */
#define SCU_CLK_CGATSTAT3_EBU_Msk             (0x4UL)                   /*!< SCU_CLK CGATSTAT3: EBU (Bitfield-Mask: 0x01)                */

/* ------------------------------  SCU_CLK_CGATSET3  ------------------------------ */
#define SCU_CLK_CGATSET3_EBU_Pos              (2UL)                     /*!< SCU_CLK CGATSET3: EBU (Bit 2)                               */
#define SCU_CLK_CGATSET3_EBU_Msk              (0x4UL)                   /*!< SCU_CLK CGATSET3: EBU (Bitfield-Mask: 0x01)                 */

/* ------------------------------  SCU_CLK_CGATCLR3  ------------------------------ */
#define SCU_CLK_CGATCLR3_EBU_Pos              (2UL)                     /*!< SCU_CLK CGATCLR3: EBU (Bit 2)                               */
#define SCU_CLK_CGATCLR3_EBU_Msk              (0x4UL)                   /*!< SCU_CLK CGATCLR3: EBU (Bitfield-Mask: 0x01)                 */


/* ================================================================================ */
/* ================        struct 'SCU_OSC' Position & Mask        ================ */
/* ================================================================================ */


/* ------------------------------  SCU_OSC_OSCHPSTAT  ----------------------------- */
#define SCU_OSC_OSCHPSTAT_X1D_Pos             (0UL)                     /*!< SCU_OSC OSCHPSTAT: X1D (Bit 0)                              */
#define SCU_OSC_OSCHPSTAT_X1D_Msk             (0x1UL)                   /*!< SCU_OSC OSCHPSTAT: X1D (Bitfield-Mask: 0x01)                */

/* ------------------------------  SCU_OSC_OSCHPCTRL  ----------------------------- */
#define SCU_OSC_OSCHPCTRL_X1DEN_Pos           (0UL)                     /*!< SCU_OSC OSCHPCTRL: X1DEN (Bit 0)                            */
#define SCU_OSC_OSCHPCTRL_X1DEN_Msk           (0x1UL)                   /*!< SCU_OSC OSCHPCTRL: X1DEN (Bitfield-Mask: 0x01)              */
#define SCU_OSC_OSCHPCTRL_SHBY_Pos            (1UL)                     /*!< SCU_OSC OSCHPCTRL: SHBY (Bit 1)                             */
#define SCU_OSC_OSCHPCTRL_SHBY_Msk            (0x2UL)                   /*!< SCU_OSC OSCHPCTRL: SHBY (Bitfield-Mask: 0x01)               */
#define SCU_OSC_OSCHPCTRL_GAINSEL_Pos         (2UL)                     /*!< SCU_OSC OSCHPCTRL: GAINSEL (Bit 2)                          */
#define SCU_OSC_OSCHPCTRL_GAINSEL_Msk         (0xcUL)                   /*!< SCU_OSC OSCHPCTRL: GAINSEL (Bitfield-Mask: 0x03)            */
#define SCU_OSC_OSCHPCTRL_MODE_Pos            (4UL)                     /*!< SCU_OSC OSCHPCTRL: MODE (Bit 4)                             */
#define SCU_OSC_OSCHPCTRL_MODE_Msk            (0x30UL)                  /*!< SCU_OSC OSCHPCTRL: MODE (Bitfield-Mask: 0x03)               */
#define SCU_OSC_OSCHPCTRL_OSCVAL_Pos          (16UL)                    /*!< SCU_OSC OSCHPCTRL: OSCVAL (Bit 16)                          */
#define SCU_OSC_OSCHPCTRL_OSCVAL_Msk          (0xf0000UL)               /*!< SCU_OSC OSCHPCTRL: OSCVAL (Bitfield-Mask: 0x0f)             */

/* -----------------------------  SCU_OSC_CLKCALCONST  ---------------------------- */
#define SCU_OSC_CLKCALCONST_CALIBCONST_Pos    (0UL)                     /*!< SCU_OSC CLKCALCONST: CALIBCONST (Bit 0)                     */
#define SCU_OSC_CLKCALCONST_CALIBCONST_Msk    (0xfUL)                   /*!< SCU_OSC CLKCALCONST: CALIBCONST (Bitfield-Mask: 0x0f)       */


/* ================================================================================ */
/* ================        struct 'SCU_PLL' Position & Mask        ================ */
/* ================================================================================ */


/* -------------------------------  SCU_PLL_PLLSTAT  ------------------------------ */
#define SCU_PLL_PLLSTAT_VCOBYST_Pos           (0UL)                     /*!< SCU_PLL PLLSTAT: VCOBYST (Bit 0)                            */
#define SCU_PLL_PLLSTAT_VCOBYST_Msk           (0x1UL)                   /*!< SCU_PLL PLLSTAT: VCOBYST (Bitfield-Mask: 0x01)              */
#define SCU_PLL_PLLSTAT_PWDSTAT_Pos           (1UL)                     /*!< SCU_PLL PLLSTAT: PWDSTAT (Bit 1)                            */
#define SCU_PLL_PLLSTAT_PWDSTAT_Msk           (0x2UL)                   /*!< SCU_PLL PLLSTAT: PWDSTAT (Bitfield-Mask: 0x01)              */
#define SCU_PLL_PLLSTAT_VCOLOCK_Pos           (2UL)                     /*!< SCU_PLL PLLSTAT: VCOLOCK (Bit 2)                            */
#define SCU_PLL_PLLSTAT_VCOLOCK_Msk           (0x4UL)                   /*!< SCU_PLL PLLSTAT: VCOLOCK (Bitfield-Mask: 0x01)              */
#define SCU_PLL_PLLSTAT_K1RDY_Pos             (4UL)                     /*!< SCU_PLL PLLSTAT: K1RDY (Bit 4)                              */
#define SCU_PLL_PLLSTAT_K1RDY_Msk             (0x10UL)                  /*!< SCU_PLL PLLSTAT: K1RDY (Bitfield-Mask: 0x01)                */
#define SCU_PLL_PLLSTAT_K2RDY_Pos             (5UL)                     /*!< SCU_PLL PLLSTAT: K2RDY (Bit 5)                              */
#define SCU_PLL_PLLSTAT_K2RDY_Msk             (0x20UL)                  /*!< SCU_PLL PLLSTAT: K2RDY (Bitfield-Mask: 0x01)                */
#define SCU_PLL_PLLSTAT_BY_Pos                (6UL)                     /*!< SCU_PLL PLLSTAT: BY (Bit 6)                                 */
#define SCU_PLL_PLLSTAT_BY_Msk                (0x40UL)                  /*!< SCU_PLL PLLSTAT: BY (Bitfield-Mask: 0x01)                   */
#define SCU_PLL_PLLSTAT_PLLLV_Pos             (7UL)                     /*!< SCU_PLL PLLSTAT: PLLLV (Bit 7)                              */
#define SCU_PLL_PLLSTAT_PLLLV_Msk             (0x80UL)                  /*!< SCU_PLL PLLSTAT: PLLLV (Bitfield-Mask: 0x01)                */
#define SCU_PLL_PLLSTAT_PLLHV_Pos             (8UL)                     /*!< SCU_PLL PLLSTAT: PLLHV (Bit 8)                              */
#define SCU_PLL_PLLSTAT_PLLHV_Msk             (0x100UL)                 /*!< SCU_PLL PLLSTAT: PLLHV (Bitfield-Mask: 0x01)                */
#define SCU_PLL_PLLSTAT_PLLSP_Pos             (9UL)                     /*!< SCU_PLL PLLSTAT: PLLSP (Bit 9)                              */
#define SCU_PLL_PLLSTAT_PLLSP_Msk             (0x200UL)                 /*!< SCU_PLL PLLSTAT: PLLSP (Bitfield-Mask: 0x01)                */

/* -------------------------------  SCU_PLL_PLLCON0  ------------------------------ */
#define SCU_PLL_PLLCON0_VCOBYP_Pos            (0UL)                     /*!< SCU_PLL PLLCON0: VCOBYP (Bit 0)                             */
#define SCU_PLL_PLLCON0_VCOBYP_Msk            (0x1UL)                   /*!< SCU_PLL PLLCON0: VCOBYP (Bitfield-Mask: 0x01)               */
#define SCU_PLL_PLLCON0_VCOPWD_Pos            (1UL)                     /*!< SCU_PLL PLLCON0: VCOPWD (Bit 1)                             */
#define SCU_PLL_PLLCON0_VCOPWD_Msk            (0x2UL)                   /*!< SCU_PLL PLLCON0: VCOPWD (Bitfield-Mask: 0x01)               */
#define SCU_PLL_PLLCON0_VCOTR_Pos             (2UL)                     /*!< SCU_PLL PLLCON0: VCOTR (Bit 2)                              */
#define SCU_PLL_PLLCON0_VCOTR_Msk             (0x4UL)                   /*!< SCU_PLL PLLCON0: VCOTR (Bitfield-Mask: 0x01)                */
#define SCU_PLL_PLLCON0_FINDIS_Pos            (4UL)                     /*!< SCU_PLL PLLCON0: FINDIS (Bit 4)                             */
#define SCU_PLL_PLLCON0_FINDIS_Msk            (0x10UL)                  /*!< SCU_PLL PLLCON0: FINDIS (Bitfield-Mask: 0x01)               */
#define SCU_PLL_PLLCON0_OSCDISCDIS_Pos        (6UL)                     /*!< SCU_PLL PLLCON0: OSCDISCDIS (Bit 6)                         */
#define SCU_PLL_PLLCON0_OSCDISCDIS_Msk        (0x40UL)                  /*!< SCU_PLL PLLCON0: OSCDISCDIS (Bitfield-Mask: 0x01)           */
#define SCU_PLL_PLLCON0_PLLPWD_Pos            (16UL)                    /*!< SCU_PLL PLLCON0: PLLPWD (Bit 16)                            */
#define SCU_PLL_PLLCON0_PLLPWD_Msk            (0x10000UL)               /*!< SCU_PLL PLLCON0: PLLPWD (Bitfield-Mask: 0x01)               */
#define SCU_PLL_PLLCON0_OSCRES_Pos            (17UL)                    /*!< SCU_PLL PLLCON0: OSCRES (Bit 17)                            */
#define SCU_PLL_PLLCON0_OSCRES_Msk            (0x20000UL)               /*!< SCU_PLL PLLCON0: OSCRES (Bitfield-Mask: 0x01)               */
#define SCU_PLL_PLLCON0_RESLD_Pos             (18UL)                    /*!< SCU_PLL PLLCON0: RESLD (Bit 18)                             */
#define SCU_PLL_PLLCON0_RESLD_Msk             (0x40000UL)               /*!< SCU_PLL PLLCON0: RESLD (Bitfield-Mask: 0x01)                */
#define SCU_PLL_PLLCON0_AOTREN_Pos            (19UL)                    /*!< SCU_PLL PLLCON0: AOTREN (Bit 19)                            */
#define SCU_PLL_PLLCON0_AOTREN_Msk            (0x80000UL)               /*!< SCU_PLL PLLCON0: AOTREN (Bitfield-Mask: 0x01)               */
#define SCU_PLL_PLLCON0_FOTR_Pos              (20UL)                    /*!< SCU_PLL PLLCON0: FOTR (Bit 20)                              */
#define SCU_PLL_PLLCON0_FOTR_Msk              (0x100000UL)              /*!< SCU_PLL PLLCON0: FOTR (Bitfield-Mask: 0x01)                 */

/* -------------------------------  SCU_PLL_PLLCON1  ------------------------------ */
#define SCU_PLL_PLLCON1_K1DIV_Pos             (0UL)                     /*!< SCU_PLL PLLCON1: K1DIV (Bit 0)                              */
#define SCU_PLL_PLLCON1_K1DIV_Msk             (0x7fUL)                  /*!< SCU_PLL PLLCON1: K1DIV (Bitfield-Mask: 0x7f)                */
#define SCU_PLL_PLLCON1_NDIV_Pos              (8UL)                     /*!< SCU_PLL PLLCON1: NDIV (Bit 8)                               */
#define SCU_PLL_PLLCON1_NDIV_Msk              (0x7f00UL)                /*!< SCU_PLL PLLCON1: NDIV (Bitfield-Mask: 0x7f)                 */
#define SCU_PLL_PLLCON1_K2DIV_Pos             (16UL)                    /*!< SCU_PLL PLLCON1: K2DIV (Bit 16)                             */
#define SCU_PLL_PLLCON1_K2DIV_Msk             (0x7f0000UL)              /*!< SCU_PLL PLLCON1: K2DIV (Bitfield-Mask: 0x7f)                */
#define SCU_PLL_PLLCON1_PDIV_Pos              (24UL)                    /*!< SCU_PLL PLLCON1: PDIV (Bit 24)                              */
#define SCU_PLL_PLLCON1_PDIV_Msk              (0xf000000UL)             /*!< SCU_PLL PLLCON1: PDIV (Bitfield-Mask: 0x0f)                 */

/* -------------------------------  SCU_PLL_PLLCON2  ------------------------------ */
#define SCU_PLL_PLLCON2_PINSEL_Pos            (0UL)                     /*!< SCU_PLL PLLCON2: PINSEL (Bit 0)                             */
#define SCU_PLL_PLLCON2_PINSEL_Msk            (0x1UL)                   /*!< SCU_PLL PLLCON2: PINSEL (Bitfield-Mask: 0x01)               */
#define SCU_PLL_PLLCON2_K1INSEL_Pos           (8UL)                     /*!< SCU_PLL PLLCON2: K1INSEL (Bit 8)                            */
#define SCU_PLL_PLLCON2_K1INSEL_Msk           (0x100UL)                 /*!< SCU_PLL PLLCON2: K1INSEL (Bitfield-Mask: 0x01)              */

/* -----------------------------  SCU_PLL_USBPLLSTAT  ----------------------------- */
#define SCU_PLL_USBPLLSTAT_VCOBYST_Pos        (0UL)                     /*!< SCU_PLL USBPLLSTAT: VCOBYST (Bit 0)                         */
#define SCU_PLL_USBPLLSTAT_VCOBYST_Msk        (0x1UL)                   /*!< SCU_PLL USBPLLSTAT: VCOBYST (Bitfield-Mask: 0x01)           */
#define SCU_PLL_USBPLLSTAT_PWDSTAT_Pos        (1UL)                     /*!< SCU_PLL USBPLLSTAT: PWDSTAT (Bit 1)                         */
#define SCU_PLL_USBPLLSTAT_PWDSTAT_Msk        (0x2UL)                   /*!< SCU_PLL USBPLLSTAT: PWDSTAT (Bitfield-Mask: 0x01)           */
#define SCU_PLL_USBPLLSTAT_VCOLOCK_Pos        (2UL)                     /*!< SCU_PLL USBPLLSTAT: VCOLOCK (Bit 2)                         */
#define SCU_PLL_USBPLLSTAT_VCOLOCK_Msk        (0x4UL)                   /*!< SCU_PLL USBPLLSTAT: VCOLOCK (Bitfield-Mask: 0x01)           */
#define SCU_PLL_USBPLLSTAT_BY_Pos             (6UL)                     /*!< SCU_PLL USBPLLSTAT: BY (Bit 6)                              */
#define SCU_PLL_USBPLLSTAT_BY_Msk             (0x40UL)                  /*!< SCU_PLL USBPLLSTAT: BY (Bitfield-Mask: 0x01)                */
#define SCU_PLL_USBPLLSTAT_VCOLOCKED_Pos      (7UL)                     /*!< SCU_PLL USBPLLSTAT: VCOLOCKED (Bit 7)                       */
#define SCU_PLL_USBPLLSTAT_VCOLOCKED_Msk      (0x80UL)                  /*!< SCU_PLL USBPLLSTAT: VCOLOCKED (Bitfield-Mask: 0x01)         */

/* ------------------------------  SCU_PLL_USBPLLCON  ----------------------------- */
#define SCU_PLL_USBPLLCON_VCOBYP_Pos          (0UL)                     /*!< SCU_PLL USBPLLCON: VCOBYP (Bit 0)                           */
#define SCU_PLL_USBPLLCON_VCOBYP_Msk          (0x1UL)                   /*!< SCU_PLL USBPLLCON: VCOBYP (Bitfield-Mask: 0x01)             */
#define SCU_PLL_USBPLLCON_VCOPWD_Pos          (1UL)                     /*!< SCU_PLL USBPLLCON: VCOPWD (Bit 1)                           */
#define SCU_PLL_USBPLLCON_VCOPWD_Msk          (0x2UL)                   /*!< SCU_PLL USBPLLCON: VCOPWD (Bitfield-Mask: 0x01)             */
#define SCU_PLL_USBPLLCON_VCOTR_Pos           (2UL)                     /*!< SCU_PLL USBPLLCON: VCOTR (Bit 2)                            */
#define SCU_PLL_USBPLLCON_VCOTR_Msk           (0x4UL)                   /*!< SCU_PLL USBPLLCON: VCOTR (Bitfield-Mask: 0x01)              */
#define SCU_PLL_USBPLLCON_FINDIS_Pos          (4UL)                     /*!< SCU_PLL USBPLLCON: FINDIS (Bit 4)                           */
#define SCU_PLL_USBPLLCON_FINDIS_Msk          (0x10UL)                  /*!< SCU_PLL USBPLLCON: FINDIS (Bitfield-Mask: 0x01)             */
#define SCU_PLL_USBPLLCON_OSCDISCDIS_Pos      (6UL)                     /*!< SCU_PLL USBPLLCON: OSCDISCDIS (Bit 6)                       */
#define SCU_PLL_USBPLLCON_OSCDISCDIS_Msk      (0x40UL)                  /*!< SCU_PLL USBPLLCON: OSCDISCDIS (Bitfield-Mask: 0x01)         */
#define SCU_PLL_USBPLLCON_NDIV_Pos            (8UL)                     /*!< SCU_PLL USBPLLCON: NDIV (Bit 8)                             */
#define SCU_PLL_USBPLLCON_NDIV_Msk            (0x7f00UL)                /*!< SCU_PLL USBPLLCON: NDIV (Bitfield-Mask: 0x7f)               */
#define SCU_PLL_USBPLLCON_PLLPWD_Pos          (16UL)                    /*!< SCU_PLL USBPLLCON: PLLPWD (Bit 16)                          */
#define SCU_PLL_USBPLLCON_PLLPWD_Msk          (0x10000UL)               /*!< SCU_PLL USBPLLCON: PLLPWD (Bitfield-Mask: 0x01)             */
#define SCU_PLL_USBPLLCON_RESLD_Pos           (18UL)                    /*!< SCU_PLL USBPLLCON: RESLD (Bit 18)                           */
#define SCU_PLL_USBPLLCON_RESLD_Msk           (0x40000UL)               /*!< SCU_PLL USBPLLCON: RESLD (Bitfield-Mask: 0x01)              */
#define SCU_PLL_USBPLLCON_PDIV_Pos            (24UL)                    /*!< SCU_PLL USBPLLCON: PDIV (Bit 24)                            */
#define SCU_PLL_USBPLLCON_PDIV_Msk            (0xf000000UL)             /*!< SCU_PLL USBPLLCON: PDIV (Bitfield-Mask: 0x0f)               */

/* ------------------------------  SCU_PLL_CLKMXSTAT  ----------------------------- */
#define SCU_PLL_CLKMXSTAT_SYSCLKMUX_Pos       (0UL)                     /*!< SCU_PLL CLKMXSTAT: SYSCLKMUX (Bit 0)                        */
#define SCU_PLL_CLKMXSTAT_SYSCLKMUX_Msk       (0x3UL)                   /*!< SCU_PLL CLKMXSTAT: SYSCLKMUX (Bitfield-Mask: 0x03)          */


/* ================================================================================ */
/* ================      struct 'SCU_GENERAL' Position & Mask      ================ */
/* ================================================================================ */


/* -------------------------------  SCU_GENERAL_ID  ------------------------------- */
#define SCU_GENERAL_ID_MOD_REV_Pos            (0UL)                     /*!< SCU_GENERAL ID: MOD_REV (Bit 0)                             */
#define SCU_GENERAL_ID_MOD_REV_Msk            (0xffUL)                  /*!< SCU_GENERAL ID: MOD_REV (Bitfield-Mask: 0xff)               */
#define SCU_GENERAL_ID_MOD_TYPE_Pos           (8UL)                     /*!< SCU_GENERAL ID: MOD_TYPE (Bit 8)                            */
#define SCU_GENERAL_ID_MOD_TYPE_Msk           (0xff00UL)                /*!< SCU_GENERAL ID: MOD_TYPE (Bitfield-Mask: 0xff)              */
#define SCU_GENERAL_ID_MOD_NUMBER_Pos         (16UL)                    /*!< SCU_GENERAL ID: MOD_NUMBER (Bit 16)                         */
#define SCU_GENERAL_ID_MOD_NUMBER_Msk         (0xffff0000UL)            /*!< SCU_GENERAL ID: MOD_NUMBER (Bitfield-Mask: 0xffff)          */

/* -----------------------------  SCU_GENERAL_IDCHIP  ----------------------------- */
#define SCU_GENERAL_IDCHIP_IDCHIP_Pos         (0UL)                     /*!< SCU_GENERAL IDCHIP: IDCHIP (Bit 0)                          */
#define SCU_GENERAL_IDCHIP_IDCHIP_Msk         (0xffffffffUL)            /*!< SCU_GENERAL IDCHIP: IDCHIP (Bitfield-Mask: 0xffffffff)      */

/* -----------------------------  SCU_GENERAL_IDMANUF  ---------------------------- */
#define SCU_GENERAL_IDMANUF_DEPT_Pos          (0UL)                     /*!< SCU_GENERAL IDMANUF: DEPT (Bit 0)                           */
#define SCU_GENERAL_IDMANUF_DEPT_Msk          (0x1fUL)                  /*!< SCU_GENERAL IDMANUF: DEPT (Bitfield-Mask: 0x1f)             */
#define SCU_GENERAL_IDMANUF_MANUF_Pos         (5UL)                     /*!< SCU_GENERAL IDMANUF: MANUF (Bit 5)                          */
#define SCU_GENERAL_IDMANUF_MANUF_Msk         (0xffe0UL)                /*!< SCU_GENERAL IDMANUF: MANUF (Bitfield-Mask: 0x7ff)           */

/* ------------------------------  SCU_GENERAL_STCON  ----------------------------- */
#define SCU_GENERAL_STCON_HWCON_Pos           (0UL)                     /*!< SCU_GENERAL STCON: HWCON (Bit 0)                            */
#define SCU_GENERAL_STCON_HWCON_Msk           (0x3UL)                   /*!< SCU_GENERAL STCON: HWCON (Bitfield-Mask: 0x03)              */
#define SCU_GENERAL_STCON_SWCON_Pos           (8UL)                     /*!< SCU_GENERAL STCON: SWCON (Bit 8)                            */
#define SCU_GENERAL_STCON_SWCON_Msk           (0xf00UL)                 /*!< SCU_GENERAL STCON: SWCON (Bitfield-Mask: 0x0f)              */

/* -------------------------------  SCU_GENERAL_GPR  ------------------------------ */
#define SCU_GENERAL_GPR_DAT_Pos               (0UL)                     /*!< SCU_GENERAL GPR: DAT (Bit 0)                                */
#define SCU_GENERAL_GPR_DAT_Msk               (0xffffffffUL)            /*!< SCU_GENERAL GPR: DAT (Bitfield-Mask: 0xffffffff)            */

/* -----------------------------  SCU_GENERAL_CCUCON  ----------------------------- */
#define SCU_GENERAL_CCUCON_GSC40_Pos          (0UL)                     /*!< SCU_GENERAL CCUCON: GSC40 (Bit 0)                           */
#define SCU_GENERAL_CCUCON_GSC40_Msk          (0x1UL)                   /*!< SCU_GENERAL CCUCON: GSC40 (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_CCUCON_GSC41_Pos          (1UL)                     /*!< SCU_GENERAL CCUCON: GSC41 (Bit 1)                           */
#define SCU_GENERAL_CCUCON_GSC41_Msk          (0x2UL)                   /*!< SCU_GENERAL CCUCON: GSC41 (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_CCUCON_GSC42_Pos          (2UL)                     /*!< SCU_GENERAL CCUCON: GSC42 (Bit 2)                           */
#define SCU_GENERAL_CCUCON_GSC42_Msk          (0x4UL)                   /*!< SCU_GENERAL CCUCON: GSC42 (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_CCUCON_GSC43_Pos          (3UL)                     /*!< SCU_GENERAL CCUCON: GSC43 (Bit 3)                           */
#define SCU_GENERAL_CCUCON_GSC43_Msk          (0x8UL)                   /*!< SCU_GENERAL CCUCON: GSC43 (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_CCUCON_GSC80_Pos          (8UL)                     /*!< SCU_GENERAL CCUCON: GSC80 (Bit 8)                           */
#define SCU_GENERAL_CCUCON_GSC80_Msk          (0x100UL)                 /*!< SCU_GENERAL CCUCON: GSC80 (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_CCUCON_GSC81_Pos          (9UL)                     /*!< SCU_GENERAL CCUCON: GSC81 (Bit 9)                           */
#define SCU_GENERAL_CCUCON_GSC81_Msk          (0x200UL)                 /*!< SCU_GENERAL CCUCON: GSC81 (Bitfield-Mask: 0x01)             */

/* -----------------------------  SCU_GENERAL_DTSCON  ----------------------------- */
#define SCU_GENERAL_DTSCON_PWD_Pos            (0UL)                     /*!< SCU_GENERAL DTSCON: PWD (Bit 0)                             */
#define SCU_GENERAL_DTSCON_PWD_Msk            (0x1UL)                   /*!< SCU_GENERAL DTSCON: PWD (Bitfield-Mask: 0x01)               */
#define SCU_GENERAL_DTSCON_START_Pos          (1UL)                     /*!< SCU_GENERAL DTSCON: START (Bit 1)                           */
#define SCU_GENERAL_DTSCON_START_Msk          (0x2UL)                   /*!< SCU_GENERAL DTSCON: START (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_DTSCON_OFFSET_Pos         (4UL)                     /*!< SCU_GENERAL DTSCON: OFFSET (Bit 4)                          */
#define SCU_GENERAL_DTSCON_OFFSET_Msk         (0x7f0UL)                 /*!< SCU_GENERAL DTSCON: OFFSET (Bitfield-Mask: 0x7f)            */
#define SCU_GENERAL_DTSCON_GAIN_Pos           (11UL)                    /*!< SCU_GENERAL DTSCON: GAIN (Bit 11)                           */
#define SCU_GENERAL_DTSCON_GAIN_Msk           (0x1f800UL)               /*!< SCU_GENERAL DTSCON: GAIN (Bitfield-Mask: 0x3f)              */
#define SCU_GENERAL_DTSCON_REFTRIM_Pos        (17UL)                    /*!< SCU_GENERAL DTSCON: REFTRIM (Bit 17)                        */
#define SCU_GENERAL_DTSCON_REFTRIM_Msk        (0xe0000UL)               /*!< SCU_GENERAL DTSCON: REFTRIM (Bitfield-Mask: 0x07)           */
#define SCU_GENERAL_DTSCON_BGTRIM_Pos         (20UL)                    /*!< SCU_GENERAL DTSCON: BGTRIM (Bit 20)                         */
#define SCU_GENERAL_DTSCON_BGTRIM_Msk         (0xf00000UL)              /*!< SCU_GENERAL DTSCON: BGTRIM (Bitfield-Mask: 0x0f)            */

/* -----------------------------  SCU_GENERAL_DTSSTAT  ---------------------------- */
#define SCU_GENERAL_DTSSTAT_RESULT_Pos        (0UL)                     /*!< SCU_GENERAL DTSSTAT: RESULT (Bit 0)                         */
#define SCU_GENERAL_DTSSTAT_RESULT_Msk        (0x3ffUL)                 /*!< SCU_GENERAL DTSSTAT: RESULT (Bitfield-Mask: 0x3ff)          */
#define SCU_GENERAL_DTSSTAT_RDY_Pos           (14UL)                    /*!< SCU_GENERAL DTSSTAT: RDY (Bit 14)                           */
#define SCU_GENERAL_DTSSTAT_RDY_Msk           (0x4000UL)                /*!< SCU_GENERAL DTSSTAT: RDY (Bitfield-Mask: 0x01)              */
#define SCU_GENERAL_DTSSTAT_BUSY_Pos          (15UL)                    /*!< SCU_GENERAL DTSSTAT: BUSY (Bit 15)                          */
#define SCU_GENERAL_DTSSTAT_BUSY_Msk          (0x8000UL)                /*!< SCU_GENERAL DTSSTAT: BUSY (Bitfield-Mask: 0x01)             */

/* ----------------------------  SCU_GENERAL_SDMMCDEL  ---------------------------- */
#define SCU_GENERAL_SDMMCDEL_TAPEN_Pos        (0UL)                     /*!< SCU_GENERAL SDMMCDEL: TAPEN (Bit 0)                         */
#define SCU_GENERAL_SDMMCDEL_TAPEN_Msk        (0x1UL)                   /*!< SCU_GENERAL SDMMCDEL: TAPEN (Bitfield-Mask: 0x01)           */
#define SCU_GENERAL_SDMMCDEL_TAPDEL_Pos       (4UL)                     /*!< SCU_GENERAL SDMMCDEL: TAPDEL (Bit 4)                        */
#define SCU_GENERAL_SDMMCDEL_TAPDEL_Msk       (0xf0UL)                  /*!< SCU_GENERAL SDMMCDEL: TAPDEL (Bitfield-Mask: 0x0f)          */

/* -----------------------------  SCU_GENERAL_GORCEN  ----------------------------- */
#define SCU_GENERAL_GORCEN_ENORC6_Pos         (6UL)                     /*!< SCU_GENERAL GORCEN: ENORC6 (Bit 6)                          */
#define SCU_GENERAL_GORCEN_ENORC6_Msk         (0x40UL)                  /*!< SCU_GENERAL GORCEN: ENORC6 (Bitfield-Mask: 0x01)            */
#define SCU_GENERAL_GORCEN_ENORC7_Pos         (7UL)                     /*!< SCU_GENERAL GORCEN: ENORC7 (Bit 7)                          */
#define SCU_GENERAL_GORCEN_ENORC7_Msk         (0x80UL)                  /*!< SCU_GENERAL GORCEN: ENORC7 (Bitfield-Mask: 0x01)            */

/* -----------------------------  SCU_GENERAL_MIRRSTS  ---------------------------- */
#define SCU_GENERAL_MIRRSTS_HDCLR_Pos         (1UL)                     /*!< SCU_GENERAL MIRRSTS: HDCLR (Bit 1)                          */
#define SCU_GENERAL_MIRRSTS_HDCLR_Msk         (0x2UL)                   /*!< SCU_GENERAL MIRRSTS: HDCLR (Bitfield-Mask: 0x01)            */
#define SCU_GENERAL_MIRRSTS_HDSET_Pos         (2UL)                     /*!< SCU_GENERAL MIRRSTS: HDSET (Bit 2)                          */
#define SCU_GENERAL_MIRRSTS_HDSET_Msk         (0x4UL)                   /*!< SCU_GENERAL MIRRSTS: HDSET (Bitfield-Mask: 0x01)            */
#define SCU_GENERAL_MIRRSTS_HDCR_Pos          (3UL)                     /*!< SCU_GENERAL MIRRSTS: HDCR (Bit 3)                           */
#define SCU_GENERAL_MIRRSTS_HDCR_Msk          (0x8UL)                   /*!< SCU_GENERAL MIRRSTS: HDCR (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_MIRRSTS_OSCSICTRL_Pos     (5UL)                     /*!< SCU_GENERAL MIRRSTS: OSCSICTRL (Bit 5)                      */
#define SCU_GENERAL_MIRRSTS_OSCSICTRL_Msk     (0x20UL)                  /*!< SCU_GENERAL MIRRSTS: OSCSICTRL (Bitfield-Mask: 0x01)        */
#define SCU_GENERAL_MIRRSTS_OSCULSTAT_Pos     (6UL)                     /*!< SCU_GENERAL MIRRSTS: OSCULSTAT (Bit 6)                      */
#define SCU_GENERAL_MIRRSTS_OSCULSTAT_Msk     (0x40UL)                  /*!< SCU_GENERAL MIRRSTS: OSCULSTAT (Bitfield-Mask: 0x01)        */
#define SCU_GENERAL_MIRRSTS_OSCULCTRL_Pos     (7UL)                     /*!< SCU_GENERAL MIRRSTS: OSCULCTRL (Bit 7)                      */
#define SCU_GENERAL_MIRRSTS_OSCULCTRL_Msk     (0x80UL)                  /*!< SCU_GENERAL MIRRSTS: OSCULCTRL (Bitfield-Mask: 0x01)        */
#define SCU_GENERAL_MIRRSTS_RTC_CTR_Pos       (8UL)                     /*!< SCU_GENERAL MIRRSTS: RTC_CTR (Bit 8)                        */
#define SCU_GENERAL_MIRRSTS_RTC_CTR_Msk       (0x100UL)                 /*!< SCU_GENERAL MIRRSTS: RTC_CTR (Bitfield-Mask: 0x01)          */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM0_Pos     (9UL)                     /*!< SCU_GENERAL MIRRSTS: RTC_ATIM0 (Bit 9)                      */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM0_Msk     (0x200UL)                 /*!< SCU_GENERAL MIRRSTS: RTC_ATIM0 (Bitfield-Mask: 0x01)        */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM1_Pos     (10UL)                    /*!< SCU_GENERAL MIRRSTS: RTC_ATIM1 (Bit 10)                     */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM1_Msk     (0x400UL)                 /*!< SCU_GENERAL MIRRSTS: RTC_ATIM1 (Bitfield-Mask: 0x01)        */
#define SCU_GENERAL_MIRRSTS_RTC_TIM0_Pos      (11UL)                    /*!< SCU_GENERAL MIRRSTS: RTC_TIM0 (Bit 11)                      */
#define SCU_GENERAL_MIRRSTS_RTC_TIM0_Msk      (0x800UL)                 /*!< SCU_GENERAL MIRRSTS: RTC_TIM0 (Bitfield-Mask: 0x01)         */
#define SCU_GENERAL_MIRRSTS_RTC_TIM1_Pos      (12UL)                    /*!< SCU_GENERAL MIRRSTS: RTC_TIM1 (Bit 12)                      */
#define SCU_GENERAL_MIRRSTS_RTC_TIM1_Msk      (0x1000UL)                /*!< SCU_GENERAL MIRRSTS: RTC_TIM1 (Bitfield-Mask: 0x01)         */
#define SCU_GENERAL_MIRRSTS_RMX_Pos           (13UL)                    /*!< SCU_GENERAL MIRRSTS: RMX (Bit 13)                           */
#define SCU_GENERAL_MIRRSTS_RMX_Msk           (0x2000UL)                /*!< SCU_GENERAL MIRRSTS: RMX (Bitfield-Mask: 0x01)              */
#define SCU_GENERAL_MIRRSTS_RTC_MSKSR_Pos     (14UL)                    /*!< SCU_GENERAL MIRRSTS: RTC_MSKSR (Bit 14)                     */
#define SCU_GENERAL_MIRRSTS_RTC_MSKSR_Msk     (0x4000UL)                /*!< SCU_GENERAL MIRRSTS: RTC_MSKSR (Bitfield-Mask: 0x01)        */
#define SCU_GENERAL_MIRRSTS_RTC_CLRSR_Pos     (15UL)                    /*!< SCU_GENERAL MIRRSTS: RTC_CLRSR (Bit 15)                     */
#define SCU_GENERAL_MIRRSTS_RTC_CLRSR_Msk     (0x8000UL)                /*!< SCU_GENERAL MIRRSTS: RTC_CLRSR (Bitfield-Mask: 0x01)        */

/* ------------------------------  SCU_GENERAL_RMACR  ----------------------------- */
#define SCU_GENERAL_RMACR_RDWR_Pos            (0UL)                     /*!< SCU_GENERAL RMACR: RDWR (Bit 0)                             */
#define SCU_GENERAL_RMACR_RDWR_Msk            (0x1UL)                   /*!< SCU_GENERAL RMACR: RDWR (Bitfield-Mask: 0x01)               */
#define SCU_GENERAL_RMACR_ADDR_Pos            (16UL)                    /*!< SCU_GENERAL RMACR: ADDR (Bit 16)                            */
#define SCU_GENERAL_RMACR_ADDR_Msk            (0xf0000UL)               /*!< SCU_GENERAL RMACR: ADDR (Bitfield-Mask: 0x0f)               */

/* -----------------------------  SCU_GENERAL_RMDATA  ----------------------------- */
#define SCU_GENERAL_RMDATA_DATA_Pos           (0UL)                     /*!< SCU_GENERAL RMDATA: DATA (Bit 0)                            */
#define SCU_GENERAL_RMDATA_DATA_Msk           (0xffffffffUL)            /*!< SCU_GENERAL RMDATA: DATA (Bitfield-Mask: 0xffffffff)        */


/* ================================================================================ */
/* ================     struct 'SCU_INTERRUPT' Position & Mask     ================ */
/* ================================================================================ */


/* ----------------------------  SCU_INTERRUPT_SRSTAT  ---------------------------- */
#define SCU_INTERRUPT_SRSTAT_PRWARN_Pos       (0UL)                     /*!< SCU_INTERRUPT SRSTAT: PRWARN (Bit 0)                        */
#define SCU_INTERRUPT_SRSTAT_PRWARN_Msk       (0x1UL)                   /*!< SCU_INTERRUPT SRSTAT: PRWARN (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSTAT_PI_Pos           (1UL)                     /*!< SCU_INTERRUPT SRSTAT: PI (Bit 1)                            */
#define SCU_INTERRUPT_SRSTAT_PI_Msk           (0x2UL)                   /*!< SCU_INTERRUPT SRSTAT: PI (Bitfield-Mask: 0x01)              */
#define SCU_INTERRUPT_SRSTAT_AI_Pos           (2UL)                     /*!< SCU_INTERRUPT SRSTAT: AI (Bit 2)                            */
#define SCU_INTERRUPT_SRSTAT_AI_Msk           (0x4UL)                   /*!< SCU_INTERRUPT SRSTAT: AI (Bitfield-Mask: 0x01)              */
#define SCU_INTERRUPT_SRSTAT_DLROVR_Pos       (3UL)                     /*!< SCU_INTERRUPT SRSTAT: DLROVR (Bit 3)                        */
#define SCU_INTERRUPT_SRSTAT_DLROVR_Msk       (0x8UL)                   /*!< SCU_INTERRUPT SRSTAT: DLROVR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSTAT_HDSTAT_Pos       (16UL)                    /*!< SCU_INTERRUPT SRSTAT: HDSTAT (Bit 16)                       */
#define SCU_INTERRUPT_SRSTAT_HDSTAT_Msk       (0x10000UL)               /*!< SCU_INTERRUPT SRSTAT: HDSTAT (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSTAT_HDCLR_Pos        (17UL)                    /*!< SCU_INTERRUPT SRSTAT: HDCLR (Bit 17)                        */
#define SCU_INTERRUPT_SRSTAT_HDCLR_Msk        (0x20000UL)               /*!< SCU_INTERRUPT SRSTAT: HDCLR (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRSTAT_HDSET_Pos        (18UL)                    /*!< SCU_INTERRUPT SRSTAT: HDSET (Bit 18)                        */
#define SCU_INTERRUPT_SRSTAT_HDSET_Msk        (0x40000UL)               /*!< SCU_INTERRUPT SRSTAT: HDSET (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRSTAT_HDCR_Pos         (19UL)                    /*!< SCU_INTERRUPT SRSTAT: HDCR (Bit 19)                         */
#define SCU_INTERRUPT_SRSTAT_HDCR_Msk         (0x80000UL)               /*!< SCU_INTERRUPT SRSTAT: HDCR (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_SRSTAT_OSCSICTRL_Pos    (21UL)                    /*!< SCU_INTERRUPT SRSTAT: OSCSICTRL (Bit 21)                    */
#define SCU_INTERRUPT_SRSTAT_OSCSICTRL_Msk    (0x200000UL)              /*!< SCU_INTERRUPT SRSTAT: OSCSICTRL (Bitfield-Mask: 0x01)       */
#define SCU_INTERRUPT_SRSTAT_OSCULSTAT_Pos    (22UL)                    /*!< SCU_INTERRUPT SRSTAT: OSCULSTAT (Bit 22)                    */
#define SCU_INTERRUPT_SRSTAT_OSCULSTAT_Msk    (0x400000UL)              /*!< SCU_INTERRUPT SRSTAT: OSCULSTAT (Bitfield-Mask: 0x01)       */
#define SCU_INTERRUPT_SRSTAT_OSCULCTRL_Pos    (23UL)                    /*!< SCU_INTERRUPT SRSTAT: OSCULCTRL (Bit 23)                    */
#define SCU_INTERRUPT_SRSTAT_OSCULCTRL_Msk    (0x800000UL)              /*!< SCU_INTERRUPT SRSTAT: OSCULCTRL (Bitfield-Mask: 0x01)       */
#define SCU_INTERRUPT_SRSTAT_RTC_CTR_Pos      (24UL)                    /*!< SCU_INTERRUPT SRSTAT: RTC_CTR (Bit 24)                      */
#define SCU_INTERRUPT_SRSTAT_RTC_CTR_Msk      (0x1000000UL)             /*!< SCU_INTERRUPT SRSTAT: RTC_CTR (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM0_Pos    (25UL)                    /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM0 (Bit 25)                    */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM0_Msk    (0x2000000UL)             /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM0 (Bitfield-Mask: 0x01)       */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM1_Pos    (26UL)                    /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM1 (Bit 26)                    */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM1_Msk    (0x4000000UL)             /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM1 (Bitfield-Mask: 0x01)       */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM0_Pos     (27UL)                    /*!< SCU_INTERRUPT SRSTAT: RTC_TIM0 (Bit 27)                     */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM0_Msk     (0x8000000UL)             /*!< SCU_INTERRUPT SRSTAT: RTC_TIM0 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM1_Pos     (28UL)                    /*!< SCU_INTERRUPT SRSTAT: RTC_TIM1 (Bit 28)                     */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM1_Msk     (0x10000000UL)            /*!< SCU_INTERRUPT SRSTAT: RTC_TIM1 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRSTAT_RMX_Pos          (29UL)                    /*!< SCU_INTERRUPT SRSTAT: RMX (Bit 29)                          */
#define SCU_INTERRUPT_SRSTAT_RMX_Msk          (0x20000000UL)            /*!< SCU_INTERRUPT SRSTAT: RMX (Bitfield-Mask: 0x01)             */

/* -----------------------------  SCU_INTERRUPT_SRRAW  ---------------------------- */
#define SCU_INTERRUPT_SRRAW_PRWARN_Pos        (0UL)                     /*!< SCU_INTERRUPT SRRAW: PRWARN (Bit 0)                         */
#define SCU_INTERRUPT_SRRAW_PRWARN_Msk        (0x1UL)                   /*!< SCU_INTERRUPT SRRAW: PRWARN (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRRAW_PI_Pos            (1UL)                     /*!< SCU_INTERRUPT SRRAW: PI (Bit 1)                             */
#define SCU_INTERRUPT_SRRAW_PI_Msk            (0x2UL)                   /*!< SCU_INTERRUPT SRRAW: PI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRRAW_AI_Pos            (2UL)                     /*!< SCU_INTERRUPT SRRAW: AI (Bit 2)                             */
#define SCU_INTERRUPT_SRRAW_AI_Msk            (0x4UL)                   /*!< SCU_INTERRUPT SRRAW: AI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRRAW_DLROVR_Pos        (3UL)                     /*!< SCU_INTERRUPT SRRAW: DLROVR (Bit 3)                         */
#define SCU_INTERRUPT_SRRAW_DLROVR_Msk        (0x8UL)                   /*!< SCU_INTERRUPT SRRAW: DLROVR (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRRAW_HDSTAT_Pos        (16UL)                    /*!< SCU_INTERRUPT SRRAW: HDSTAT (Bit 16)                        */
#define SCU_INTERRUPT_SRRAW_HDSTAT_Msk        (0x10000UL)               /*!< SCU_INTERRUPT SRRAW: HDSTAT (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRRAW_HDCLR_Pos         (17UL)                    /*!< SCU_INTERRUPT SRRAW: HDCLR (Bit 17)                         */
#define SCU_INTERRUPT_SRRAW_HDCLR_Msk         (0x20000UL)               /*!< SCU_INTERRUPT SRRAW: HDCLR (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_SRRAW_HDSET_Pos         (18UL)                    /*!< SCU_INTERRUPT SRRAW: HDSET (Bit 18)                         */
#define SCU_INTERRUPT_SRRAW_HDSET_Msk         (0x40000UL)               /*!< SCU_INTERRUPT SRRAW: HDSET (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_SRRAW_HDCR_Pos          (19UL)                    /*!< SCU_INTERRUPT SRRAW: HDCR (Bit 19)                          */
#define SCU_INTERRUPT_SRRAW_HDCR_Msk          (0x80000UL)               /*!< SCU_INTERRUPT SRRAW: HDCR (Bitfield-Mask: 0x01)             */
#define SCU_INTERRUPT_SRRAW_OSCSICTRL_Pos     (21UL)                    /*!< SCU_INTERRUPT SRRAW: OSCSICTRL (Bit 21)                     */
#define SCU_INTERRUPT_SRRAW_OSCSICTRL_Msk     (0x200000UL)              /*!< SCU_INTERRUPT SRRAW: OSCSICTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRRAW_OSCULSTAT_Pos     (22UL)                    /*!< SCU_INTERRUPT SRRAW: OSCULSTAT (Bit 22)                     */
#define SCU_INTERRUPT_SRRAW_OSCULSTAT_Msk     (0x400000UL)              /*!< SCU_INTERRUPT SRRAW: OSCULSTAT (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRRAW_OSCULCTRL_Pos     (23UL)                    /*!< SCU_INTERRUPT SRRAW: OSCULCTRL (Bit 23)                     */
#define SCU_INTERRUPT_SRRAW_OSCULCTRL_Msk     (0x800000UL)              /*!< SCU_INTERRUPT SRRAW: OSCULCTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRRAW_RTC_CTR_Pos       (24UL)                    /*!< SCU_INTERRUPT SRRAW: RTC_CTR (Bit 24)                       */
#define SCU_INTERRUPT_SRRAW_RTC_CTR_Msk       (0x1000000UL)             /*!< SCU_INTERRUPT SRRAW: RTC_CTR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM0_Pos     (25UL)                    /*!< SCU_INTERRUPT SRRAW: RTC_ATIM0 (Bit 25)                     */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM0_Msk     (0x2000000UL)             /*!< SCU_INTERRUPT SRRAW: RTC_ATIM0 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM1_Pos     (26UL)                    /*!< SCU_INTERRUPT SRRAW: RTC_ATIM1 (Bit 26)                     */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM1_Msk     (0x4000000UL)             /*!< SCU_INTERRUPT SRRAW: RTC_ATIM1 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRRAW_RTC_TIM0_Pos      (27UL)                    /*!< SCU_INTERRUPT SRRAW: RTC_TIM0 (Bit 27)                      */
#define SCU_INTERRUPT_SRRAW_RTC_TIM0_Msk      (0x8000000UL)             /*!< SCU_INTERRUPT SRRAW: RTC_TIM0 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRRAW_RTC_TIM1_Pos      (28UL)                    /*!< SCU_INTERRUPT SRRAW: RTC_TIM1 (Bit 28)                      */
#define SCU_INTERRUPT_SRRAW_RTC_TIM1_Msk      (0x10000000UL)            /*!< SCU_INTERRUPT SRRAW: RTC_TIM1 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRRAW_RMX_Pos           (29UL)                    /*!< SCU_INTERRUPT SRRAW: RMX (Bit 29)                           */
#define SCU_INTERRUPT_SRRAW_RMX_Msk           (0x20000000UL)            /*!< SCU_INTERRUPT SRRAW: RMX (Bitfield-Mask: 0x01)              */

/* -----------------------------  SCU_INTERRUPT_SRMSK  ---------------------------- */
#define SCU_INTERRUPT_SRMSK_PRWARN_Pos        (0UL)                     /*!< SCU_INTERRUPT SRMSK: PRWARN (Bit 0)                         */
#define SCU_INTERRUPT_SRMSK_PRWARN_Msk        (0x1UL)                   /*!< SCU_INTERRUPT SRMSK: PRWARN (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRMSK_PI_Pos            (1UL)                     /*!< SCU_INTERRUPT SRMSK: PI (Bit 1)                             */
#define SCU_INTERRUPT_SRMSK_PI_Msk            (0x2UL)                   /*!< SCU_INTERRUPT SRMSK: PI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRMSK_AI_Pos            (2UL)                     /*!< SCU_INTERRUPT SRMSK: AI (Bit 2)                             */
#define SCU_INTERRUPT_SRMSK_AI_Msk            (0x4UL)                   /*!< SCU_INTERRUPT SRMSK: AI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRMSK_DLROVR_Pos        (3UL)                     /*!< SCU_INTERRUPT SRMSK: DLROVR (Bit 3)                         */
#define SCU_INTERRUPT_SRMSK_DLROVR_Msk        (0x8UL)                   /*!< SCU_INTERRUPT SRMSK: DLROVR (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRMSK_HDSTAT_Pos        (16UL)                    /*!< SCU_INTERRUPT SRMSK: HDSTAT (Bit 16)                        */
#define SCU_INTERRUPT_SRMSK_HDSTAT_Msk        (0x10000UL)               /*!< SCU_INTERRUPT SRMSK: HDSTAT (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRMSK_HDCLR_Pos         (17UL)                    /*!< SCU_INTERRUPT SRMSK: HDCLR (Bit 17)                         */
#define SCU_INTERRUPT_SRMSK_HDCLR_Msk         (0x20000UL)               /*!< SCU_INTERRUPT SRMSK: HDCLR (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_SRMSK_HDSET_Pos         (18UL)                    /*!< SCU_INTERRUPT SRMSK: HDSET (Bit 18)                         */
#define SCU_INTERRUPT_SRMSK_HDSET_Msk         (0x40000UL)               /*!< SCU_INTERRUPT SRMSK: HDSET (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_SRMSK_HDCR_Pos          (19UL)                    /*!< SCU_INTERRUPT SRMSK: HDCR (Bit 19)                          */
#define SCU_INTERRUPT_SRMSK_HDCR_Msk          (0x80000UL)               /*!< SCU_INTERRUPT SRMSK: HDCR (Bitfield-Mask: 0x01)             */
#define SCU_INTERRUPT_SRMSK_OSCSICTRL_Pos     (21UL)                    /*!< SCU_INTERRUPT SRMSK: OSCSICTRL (Bit 21)                     */
#define SCU_INTERRUPT_SRMSK_OSCSICTRL_Msk     (0x200000UL)              /*!< SCU_INTERRUPT SRMSK: OSCSICTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRMSK_OSCULSTAT_Pos     (22UL)                    /*!< SCU_INTERRUPT SRMSK: OSCULSTAT (Bit 22)                     */
#define SCU_INTERRUPT_SRMSK_OSCULSTAT_Msk     (0x400000UL)              /*!< SCU_INTERRUPT SRMSK: OSCULSTAT (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRMSK_OSCULCTRL_Pos     (23UL)                    /*!< SCU_INTERRUPT SRMSK: OSCULCTRL (Bit 23)                     */
#define SCU_INTERRUPT_SRMSK_OSCULCTRL_Msk     (0x800000UL)              /*!< SCU_INTERRUPT SRMSK: OSCULCTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRMSK_RTC_CTR_Pos       (24UL)                    /*!< SCU_INTERRUPT SRMSK: RTC_CTR (Bit 24)                       */
#define SCU_INTERRUPT_SRMSK_RTC_CTR_Msk       (0x1000000UL)             /*!< SCU_INTERRUPT SRMSK: RTC_CTR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM0_Pos     (25UL)                    /*!< SCU_INTERRUPT SRMSK: RTC_ATIM0 (Bit 25)                     */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM0_Msk     (0x2000000UL)             /*!< SCU_INTERRUPT SRMSK: RTC_ATIM0 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM1_Pos     (26UL)                    /*!< SCU_INTERRUPT SRMSK: RTC_ATIM1 (Bit 26)                     */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM1_Msk     (0x4000000UL)             /*!< SCU_INTERRUPT SRMSK: RTC_ATIM1 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRMSK_RTC_TIM0_Pos      (27UL)                    /*!< SCU_INTERRUPT SRMSK: RTC_TIM0 (Bit 27)                      */
#define SCU_INTERRUPT_SRMSK_RTC_TIM0_Msk      (0x8000000UL)             /*!< SCU_INTERRUPT SRMSK: RTC_TIM0 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRMSK_RTC_TIM1_Pos      (28UL)                    /*!< SCU_INTERRUPT SRMSK: RTC_TIM1 (Bit 28)                      */
#define SCU_INTERRUPT_SRMSK_RTC_TIM1_Msk      (0x10000000UL)            /*!< SCU_INTERRUPT SRMSK: RTC_TIM1 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRMSK_RMX_Pos           (29UL)                    /*!< SCU_INTERRUPT SRMSK: RMX (Bit 29)                           */
#define SCU_INTERRUPT_SRMSK_RMX_Msk           (0x20000000UL)            /*!< SCU_INTERRUPT SRMSK: RMX (Bitfield-Mask: 0x01)              */

/* -----------------------------  SCU_INTERRUPT_SRCLR  ---------------------------- */
#define SCU_INTERRUPT_SRCLR_PRWARN_Pos        (0UL)                     /*!< SCU_INTERRUPT SRCLR: PRWARN (Bit 0)                         */
#define SCU_INTERRUPT_SRCLR_PRWARN_Msk        (0x1UL)                   /*!< SCU_INTERRUPT SRCLR: PRWARN (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRCLR_PI_Pos            (1UL)                     /*!< SCU_INTERRUPT SRCLR: PI (Bit 1)                             */
#define SCU_INTERRUPT_SRCLR_PI_Msk            (0x2UL)                   /*!< SCU_INTERRUPT SRCLR: PI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRCLR_AI_Pos            (2UL)                     /*!< SCU_INTERRUPT SRCLR: AI (Bit 2)                             */
#define SCU_INTERRUPT_SRCLR_AI_Msk            (0x4UL)                   /*!< SCU_INTERRUPT SRCLR: AI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRCLR_DLROVR_Pos        (3UL)                     /*!< SCU_INTERRUPT SRCLR: DLROVR (Bit 3)                         */
#define SCU_INTERRUPT_SRCLR_DLROVR_Msk        (0x8UL)                   /*!< SCU_INTERRUPT SRCLR: DLROVR (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRCLR_HDSTAT_Pos        (16UL)                    /*!< SCU_INTERRUPT SRCLR: HDSTAT (Bit 16)                        */
#define SCU_INTERRUPT_SRCLR_HDSTAT_Msk        (0x10000UL)               /*!< SCU_INTERRUPT SRCLR: HDSTAT (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRCLR_HDCLR_Pos         (17UL)                    /*!< SCU_INTERRUPT SRCLR: HDCLR (Bit 17)                         */
#define SCU_INTERRUPT_SRCLR_HDCLR_Msk         (0x20000UL)               /*!< SCU_INTERRUPT SRCLR: HDCLR (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_SRCLR_HDSET_Pos         (18UL)                    /*!< SCU_INTERRUPT SRCLR: HDSET (Bit 18)                         */
#define SCU_INTERRUPT_SRCLR_HDSET_Msk         (0x40000UL)               /*!< SCU_INTERRUPT SRCLR: HDSET (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_SRCLR_HDCR_Pos          (19UL)                    /*!< SCU_INTERRUPT SRCLR: HDCR (Bit 19)                          */
#define SCU_INTERRUPT_SRCLR_HDCR_Msk          (0x80000UL)               /*!< SCU_INTERRUPT SRCLR: HDCR (Bitfield-Mask: 0x01)             */
#define SCU_INTERRUPT_SRCLR_OSCSICTRL_Pos     (21UL)                    /*!< SCU_INTERRUPT SRCLR: OSCSICTRL (Bit 21)                     */
#define SCU_INTERRUPT_SRCLR_OSCSICTRL_Msk     (0x200000UL)              /*!< SCU_INTERRUPT SRCLR: OSCSICTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRCLR_OSCULSTAT_Pos     (22UL)                    /*!< SCU_INTERRUPT SRCLR: OSCULSTAT (Bit 22)                     */
#define SCU_INTERRUPT_SRCLR_OSCULSTAT_Msk     (0x400000UL)              /*!< SCU_INTERRUPT SRCLR: OSCULSTAT (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRCLR_OSCULCTRL_Pos     (23UL)                    /*!< SCU_INTERRUPT SRCLR: OSCULCTRL (Bit 23)                     */
#define SCU_INTERRUPT_SRCLR_OSCULCTRL_Msk     (0x800000UL)              /*!< SCU_INTERRUPT SRCLR: OSCULCTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRCLR_RTC_CTR_Pos       (24UL)                    /*!< SCU_INTERRUPT SRCLR: RTC_CTR (Bit 24)                       */
#define SCU_INTERRUPT_SRCLR_RTC_CTR_Msk       (0x1000000UL)             /*!< SCU_INTERRUPT SRCLR: RTC_CTR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM0_Pos     (25UL)                    /*!< SCU_INTERRUPT SRCLR: RTC_ATIM0 (Bit 25)                     */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM0_Msk     (0x2000000UL)             /*!< SCU_INTERRUPT SRCLR: RTC_ATIM0 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM1_Pos     (26UL)                    /*!< SCU_INTERRUPT SRCLR: RTC_ATIM1 (Bit 26)                     */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM1_Msk     (0x4000000UL)             /*!< SCU_INTERRUPT SRCLR: RTC_ATIM1 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRCLR_RTC_TIM0_Pos      (27UL)                    /*!< SCU_INTERRUPT SRCLR: RTC_TIM0 (Bit 27)                      */
#define SCU_INTERRUPT_SRCLR_RTC_TIM0_Msk      (0x8000000UL)             /*!< SCU_INTERRUPT SRCLR: RTC_TIM0 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRCLR_RTC_TIM1_Pos      (28UL)                    /*!< SCU_INTERRUPT SRCLR: RTC_TIM1 (Bit 28)                      */
#define SCU_INTERRUPT_SRCLR_RTC_TIM1_Msk      (0x10000000UL)            /*!< SCU_INTERRUPT SRCLR: RTC_TIM1 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRCLR_RMX_Pos           (29UL)                    /*!< SCU_INTERRUPT SRCLR: RMX (Bit 29)                           */
#define SCU_INTERRUPT_SRCLR_RMX_Msk           (0x20000000UL)            /*!< SCU_INTERRUPT SRCLR: RMX (Bitfield-Mask: 0x01)              */

/* -----------------------------  SCU_INTERRUPT_SRSET  ---------------------------- */
#define SCU_INTERRUPT_SRSET_PRWARN_Pos        (0UL)                     /*!< SCU_INTERRUPT SRSET: PRWARN (Bit 0)                         */
#define SCU_INTERRUPT_SRSET_PRWARN_Msk        (0x1UL)                   /*!< SCU_INTERRUPT SRSET: PRWARN (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRSET_PI_Pos            (1UL)                     /*!< SCU_INTERRUPT SRSET: PI (Bit 1)                             */
#define SCU_INTERRUPT_SRSET_PI_Msk            (0x2UL)                   /*!< SCU_INTERRUPT SRSET: PI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRSET_AI_Pos            (2UL)                     /*!< SCU_INTERRUPT SRSET: AI (Bit 2)                             */
#define SCU_INTERRUPT_SRSET_AI_Msk            (0x4UL)                   /*!< SCU_INTERRUPT SRSET: AI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRSET_DLROVR_Pos        (3UL)                     /*!< SCU_INTERRUPT SRSET: DLROVR (Bit 3)                         */
#define SCU_INTERRUPT_SRSET_DLROVR_Msk        (0x8UL)                   /*!< SCU_INTERRUPT SRSET: DLROVR (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRSET_HDSTAT_Pos        (16UL)                    /*!< SCU_INTERRUPT SRSET: HDSTAT (Bit 16)                        */
#define SCU_INTERRUPT_SRSET_HDSTAT_Msk        (0x10000UL)               /*!< SCU_INTERRUPT SRSET: HDSTAT (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRSET_HDCRCLR_Pos       (17UL)                    /*!< SCU_INTERRUPT SRSET: HDCRCLR (Bit 17)                       */
#define SCU_INTERRUPT_SRSET_HDCRCLR_Msk       (0x20000UL)               /*!< SCU_INTERRUPT SRSET: HDCRCLR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSET_HDCRSET_Pos       (18UL)                    /*!< SCU_INTERRUPT SRSET: HDCRSET (Bit 18)                       */
#define SCU_INTERRUPT_SRSET_HDCRSET_Msk       (0x40000UL)               /*!< SCU_INTERRUPT SRSET: HDCRSET (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSET_HDCR_Pos          (19UL)                    /*!< SCU_INTERRUPT SRSET: HDCR (Bit 19)                          */
#define SCU_INTERRUPT_SRSET_HDCR_Msk          (0x80000UL)               /*!< SCU_INTERRUPT SRSET: HDCR (Bitfield-Mask: 0x01)             */
#define SCU_INTERRUPT_SRSET_OSCSICTRL_Pos     (21UL)                    /*!< SCU_INTERRUPT SRSET: OSCSICTRL (Bit 21)                     */
#define SCU_INTERRUPT_SRSET_OSCSICTRL_Msk     (0x200000UL)              /*!< SCU_INTERRUPT SRSET: OSCSICTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRSET_OSCULSTAT_Pos     (22UL)                    /*!< SCU_INTERRUPT SRSET: OSCULSTAT (Bit 22)                     */
#define SCU_INTERRUPT_SRSET_OSCULSTAT_Msk     (0x400000UL)              /*!< SCU_INTERRUPT SRSET: OSCULSTAT (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRSET_OSCULCTRL_Pos     (23UL)                    /*!< SCU_INTERRUPT SRSET: OSCULCTRL (Bit 23)                     */
#define SCU_INTERRUPT_SRSET_OSCULCTRL_Msk     (0x800000UL)              /*!< SCU_INTERRUPT SRSET: OSCULCTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRSET_RTC_CTR_Pos       (24UL)                    /*!< SCU_INTERRUPT SRSET: RTC_CTR (Bit 24)                       */
#define SCU_INTERRUPT_SRSET_RTC_CTR_Msk       (0x1000000UL)             /*!< SCU_INTERRUPT SRSET: RTC_CTR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSET_RTC_ATIM0_Pos     (25UL)                    /*!< SCU_INTERRUPT SRSET: RTC_ATIM0 (Bit 25)                     */
#define SCU_INTERRUPT_SRSET_RTC_ATIM0_Msk     (0x2000000UL)             /*!< SCU_INTERRUPT SRSET: RTC_ATIM0 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRSET_RTC_ATIM1_Pos     (26UL)                    /*!< SCU_INTERRUPT SRSET: RTC_ATIM1 (Bit 26)                     */
#define SCU_INTERRUPT_SRSET_RTC_ATIM1_Msk     (0x4000000UL)             /*!< SCU_INTERRUPT SRSET: RTC_ATIM1 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRSET_RTC_TIM0_Pos      (27UL)                    /*!< SCU_INTERRUPT SRSET: RTC_TIM0 (Bit 27)                      */
#define SCU_INTERRUPT_SRSET_RTC_TIM0_Msk      (0x8000000UL)             /*!< SCU_INTERRUPT SRSET: RTC_TIM0 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRSET_RTC_TIM1_Pos      (28UL)                    /*!< SCU_INTERRUPT SRSET: RTC_TIM1 (Bit 28)                      */
#define SCU_INTERRUPT_SRSET_RTC_TIM1_Msk      (0x10000000UL)            /*!< SCU_INTERRUPT SRSET: RTC_TIM1 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRSET_RMX_Pos           (29UL)                    /*!< SCU_INTERRUPT SRSET: RMX (Bit 29)                           */
#define SCU_INTERRUPT_SRSET_RMX_Msk           (0x20000000UL)            /*!< SCU_INTERRUPT SRSET: RMX (Bitfield-Mask: 0x01)              */

/* ---------------------------  SCU_INTERRUPT_NMIREQEN  --------------------------- */
#define SCU_INTERRUPT_NMIREQEN_PRWARN_Pos     (0UL)                     /*!< SCU_INTERRUPT NMIREQEN: PRWARN (Bit 0)                      */
#define SCU_INTERRUPT_NMIREQEN_PRWARN_Msk     (0x1UL)                   /*!< SCU_INTERRUPT NMIREQEN: PRWARN (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_NMIREQEN_PI_Pos         (1UL)                     /*!< SCU_INTERRUPT NMIREQEN: PI (Bit 1)                          */
#define SCU_INTERRUPT_NMIREQEN_PI_Msk         (0x2UL)                   /*!< SCU_INTERRUPT NMIREQEN: PI (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_NMIREQEN_AI_Pos         (2UL)                     /*!< SCU_INTERRUPT NMIREQEN: AI (Bit 2)                          */
#define SCU_INTERRUPT_NMIREQEN_AI_Msk         (0x4UL)                   /*!< SCU_INTERRUPT NMIREQEN: AI (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_NMIREQEN_ERU00_Pos      (16UL)                    /*!< SCU_INTERRUPT NMIREQEN: ERU00 (Bit 16)                      */
#define SCU_INTERRUPT_NMIREQEN_ERU00_Msk      (0x10000UL)               /*!< SCU_INTERRUPT NMIREQEN: ERU00 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_NMIREQEN_ERU01_Pos      (17UL)                    /*!< SCU_INTERRUPT NMIREQEN: ERU01 (Bit 17)                      */
#define SCU_INTERRUPT_NMIREQEN_ERU01_Msk      (0x20000UL)               /*!< SCU_INTERRUPT NMIREQEN: ERU01 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_NMIREQEN_ERU02_Pos      (18UL)                    /*!< SCU_INTERRUPT NMIREQEN: ERU02 (Bit 18)                      */
#define SCU_INTERRUPT_NMIREQEN_ERU02_Msk      (0x40000UL)               /*!< SCU_INTERRUPT NMIREQEN: ERU02 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_NMIREQEN_ERU03_Pos      (19UL)                    /*!< SCU_INTERRUPT NMIREQEN: ERU03 (Bit 19)                      */
#define SCU_INTERRUPT_NMIREQEN_ERU03_Msk      (0x80000UL)               /*!< SCU_INTERRUPT NMIREQEN: ERU03 (Bitfield-Mask: 0x01)         */


/* ================================================================================ */
/* ================       struct 'SCU_PARITY' Position & Mask      ================ */
/* ================================================================================ */


/* -------------------------------  SCU_PARITY_PEEN  ------------------------------ */
#define SCU_PARITY_PEEN_PEENPS_Pos            (0UL)                     /*!< SCU_PARITY PEEN: PEENPS (Bit 0)                             */
#define SCU_PARITY_PEEN_PEENPS_Msk            (0x1UL)                   /*!< SCU_PARITY PEEN: PEENPS (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PEEN_PEENDS1_Pos           (1UL)                     /*!< SCU_PARITY PEEN: PEENDS1 (Bit 1)                            */
#define SCU_PARITY_PEEN_PEENDS1_Msk           (0x2UL)                   /*!< SCU_PARITY PEEN: PEENDS1 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEEN_PEENDS2_Pos           (2UL)                     /*!< SCU_PARITY PEEN: PEENDS2 (Bit 2)                            */
#define SCU_PARITY_PEEN_PEENDS2_Msk           (0x4UL)                   /*!< SCU_PARITY PEEN: PEENDS2 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEEN_PEENU0_Pos            (8UL)                     /*!< SCU_PARITY PEEN: PEENU0 (Bit 8)                             */
#define SCU_PARITY_PEEN_PEENU0_Msk            (0x100UL)                 /*!< SCU_PARITY PEEN: PEENU0 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PEEN_PEENU1_Pos            (9UL)                     /*!< SCU_PARITY PEEN: PEENU1 (Bit 9)                             */
#define SCU_PARITY_PEEN_PEENU1_Msk            (0x200UL)                 /*!< SCU_PARITY PEEN: PEENU1 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PEEN_PEENU2_Pos            (10UL)                    /*!< SCU_PARITY PEEN: PEENU2 (Bit 10)                            */
#define SCU_PARITY_PEEN_PEENU2_Msk            (0x400UL)                 /*!< SCU_PARITY PEEN: PEENU2 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PEEN_PEENMC_Pos            (12UL)                    /*!< SCU_PARITY PEEN: PEENMC (Bit 12)                            */
#define SCU_PARITY_PEEN_PEENMC_Msk            (0x1000UL)                /*!< SCU_PARITY PEEN: PEENMC (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PEEN_PEENPPRF_Pos          (13UL)                    /*!< SCU_PARITY PEEN: PEENPPRF (Bit 13)                          */
#define SCU_PARITY_PEEN_PEENPPRF_Msk          (0x2000UL)                /*!< SCU_PARITY PEEN: PEENPPRF (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_PEEN_PEENUSB_Pos           (16UL)                    /*!< SCU_PARITY PEEN: PEENUSB (Bit 16)                           */
#define SCU_PARITY_PEEN_PEENUSB_Msk           (0x10000UL)               /*!< SCU_PARITY PEEN: PEENUSB (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEEN_PEENETH0TX_Pos        (17UL)                    /*!< SCU_PARITY PEEN: PEENETH0TX (Bit 17)                        */
#define SCU_PARITY_PEEN_PEENETH0TX_Msk        (0x20000UL)               /*!< SCU_PARITY PEEN: PEENETH0TX (Bitfield-Mask: 0x01)           */
#define SCU_PARITY_PEEN_PEENETH0RX_Pos        (18UL)                    /*!< SCU_PARITY PEEN: PEENETH0RX (Bit 18)                        */
#define SCU_PARITY_PEEN_PEENETH0RX_Msk        (0x40000UL)               /*!< SCU_PARITY PEEN: PEENETH0RX (Bitfield-Mask: 0x01)           */
#define SCU_PARITY_PEEN_PEENSD0_Pos           (19UL)                    /*!< SCU_PARITY PEEN: PEENSD0 (Bit 19)                           */
#define SCU_PARITY_PEEN_PEENSD0_Msk           (0x80000UL)               /*!< SCU_PARITY PEEN: PEENSD0 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEEN_PEENSD1_Pos           (20UL)                    /*!< SCU_PARITY PEEN: PEENSD1 (Bit 20)                           */
#define SCU_PARITY_PEEN_PEENSD1_Msk           (0x100000UL)              /*!< SCU_PARITY PEEN: PEENSD1 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEEN_PEENECAT0_Pos         (24UL)                    /*!< SCU_PARITY PEEN: PEENECAT0 (Bit 24)                         */
#define SCU_PARITY_PEEN_PEENECAT0_Msk         (0x1000000UL)             /*!< SCU_PARITY PEEN: PEENECAT0 (Bitfield-Mask: 0x01)            */

/* -----------------------------  SCU_PARITY_MCHKCON  ----------------------------- */
#define SCU_PARITY_MCHKCON_SELPS_Pos          (0UL)                     /*!< SCU_PARITY MCHKCON: SELPS (Bit 0)                           */
#define SCU_PARITY_MCHKCON_SELPS_Msk          (0x1UL)                   /*!< SCU_PARITY MCHKCON: SELPS (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_MCHKCON_SELDS1_Pos         (1UL)                     /*!< SCU_PARITY MCHKCON: SELDS1 (Bit 1)                          */
#define SCU_PARITY_MCHKCON_SELDS1_Msk         (0x2UL)                   /*!< SCU_PARITY MCHKCON: SELDS1 (Bitfield-Mask: 0x01)            */
#define SCU_PARITY_MCHKCON_SELDS2_Pos         (2UL)                     /*!< SCU_PARITY MCHKCON: SELDS2 (Bit 2)                          */
#define SCU_PARITY_MCHKCON_SELDS2_Msk         (0x4UL)                   /*!< SCU_PARITY MCHKCON: SELDS2 (Bitfield-Mask: 0x01)            */
#define SCU_PARITY_MCHKCON_USIC0DRA_Pos       (8UL)                     /*!< SCU_PARITY MCHKCON: USIC0DRA (Bit 8)                        */
#define SCU_PARITY_MCHKCON_USIC0DRA_Msk       (0x100UL)                 /*!< SCU_PARITY MCHKCON: USIC0DRA (Bitfield-Mask: 0x01)          */
#define SCU_PARITY_MCHKCON_USIC1DRA_Pos       (9UL)                     /*!< SCU_PARITY MCHKCON: USIC1DRA (Bit 9)                        */
#define SCU_PARITY_MCHKCON_USIC1DRA_Msk       (0x200UL)                 /*!< SCU_PARITY MCHKCON: USIC1DRA (Bitfield-Mask: 0x01)          */
#define SCU_PARITY_MCHKCON_USIC2DRA_Pos       (10UL)                    /*!< SCU_PARITY MCHKCON: USIC2DRA (Bit 10)                       */
#define SCU_PARITY_MCHKCON_USIC2DRA_Msk       (0x400UL)                 /*!< SCU_PARITY MCHKCON: USIC2DRA (Bitfield-Mask: 0x01)          */
#define SCU_PARITY_MCHKCON_MCANDRA_Pos        (12UL)                    /*!< SCU_PARITY MCHKCON: MCANDRA (Bit 12)                        */
#define SCU_PARITY_MCHKCON_MCANDRA_Msk        (0x1000UL)                /*!< SCU_PARITY MCHKCON: MCANDRA (Bitfield-Mask: 0x01)           */
#define SCU_PARITY_MCHKCON_PPRFDRA_Pos        (13UL)                    /*!< SCU_PARITY MCHKCON: PPRFDRA (Bit 13)                        */
#define SCU_PARITY_MCHKCON_PPRFDRA_Msk        (0x2000UL)                /*!< SCU_PARITY MCHKCON: PPRFDRA (Bitfield-Mask: 0x01)           */
#define SCU_PARITY_MCHKCON_SELUSB_Pos         (16UL)                    /*!< SCU_PARITY MCHKCON: SELUSB (Bit 16)                         */
#define SCU_PARITY_MCHKCON_SELUSB_Msk         (0x10000UL)               /*!< SCU_PARITY MCHKCON: SELUSB (Bitfield-Mask: 0x01)            */
#define SCU_PARITY_MCHKCON_SELETH0TX_Pos      (17UL)                    /*!< SCU_PARITY MCHKCON: SELETH0TX (Bit 17)                      */
#define SCU_PARITY_MCHKCON_SELETH0TX_Msk      (0x20000UL)               /*!< SCU_PARITY MCHKCON: SELETH0TX (Bitfield-Mask: 0x01)         */
#define SCU_PARITY_MCHKCON_SELETH0RX_Pos      (18UL)                    /*!< SCU_PARITY MCHKCON: SELETH0RX (Bit 18)                      */
#define SCU_PARITY_MCHKCON_SELETH0RX_Msk      (0x40000UL)               /*!< SCU_PARITY MCHKCON: SELETH0RX (Bitfield-Mask: 0x01)         */
#define SCU_PARITY_MCHKCON_SELSD0_Pos         (19UL)                    /*!< SCU_PARITY MCHKCON: SELSD0 (Bit 19)                         */
#define SCU_PARITY_MCHKCON_SELSD0_Msk         (0x80000UL)               /*!< SCU_PARITY MCHKCON: SELSD0 (Bitfield-Mask: 0x01)            */
#define SCU_PARITY_MCHKCON_SELSD1_Pos         (20UL)                    /*!< SCU_PARITY MCHKCON: SELSD1 (Bit 20)                         */
#define SCU_PARITY_MCHKCON_SELSD1_Msk         (0x100000UL)              /*!< SCU_PARITY MCHKCON: SELSD1 (Bitfield-Mask: 0x01)            */
#define SCU_PARITY_MCHKCON_SELECAT0_Pos       (24UL)                    /*!< SCU_PARITY MCHKCON: SELECAT0 (Bit 24)                       */
#define SCU_PARITY_MCHKCON_SELECAT0_Msk       (0x1000000UL)             /*!< SCU_PARITY MCHKCON: SELECAT0 (Bitfield-Mask: 0x01)          */

/* -------------------------------  SCU_PARITY_PETE  ------------------------------ */
#define SCU_PARITY_PETE_PETEPS_Pos            (0UL)                     /*!< SCU_PARITY PETE: PETEPS (Bit 0)                             */
#define SCU_PARITY_PETE_PETEPS_Msk            (0x1UL)                   /*!< SCU_PARITY PETE: PETEPS (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PETE_PETEDS1_Pos           (1UL)                     /*!< SCU_PARITY PETE: PETEDS1 (Bit 1)                            */
#define SCU_PARITY_PETE_PETEDS1_Msk           (0x2UL)                   /*!< SCU_PARITY PETE: PETEDS1 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PETE_PETEDS2_Pos           (2UL)                     /*!< SCU_PARITY PETE: PETEDS2 (Bit 2)                            */
#define SCU_PARITY_PETE_PETEDS2_Msk           (0x4UL)                   /*!< SCU_PARITY PETE: PETEDS2 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PETE_PETEU0_Pos            (8UL)                     /*!< SCU_PARITY PETE: PETEU0 (Bit 8)                             */
#define SCU_PARITY_PETE_PETEU0_Msk            (0x100UL)                 /*!< SCU_PARITY PETE: PETEU0 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PETE_PETEU1_Pos            (9UL)                     /*!< SCU_PARITY PETE: PETEU1 (Bit 9)                             */
#define SCU_PARITY_PETE_PETEU1_Msk            (0x200UL)                 /*!< SCU_PARITY PETE: PETEU1 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PETE_PETEU2_Pos            (10UL)                    /*!< SCU_PARITY PETE: PETEU2 (Bit 10)                            */
#define SCU_PARITY_PETE_PETEU2_Msk            (0x400UL)                 /*!< SCU_PARITY PETE: PETEU2 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PETE_PETEMC_Pos            (12UL)                    /*!< SCU_PARITY PETE: PETEMC (Bit 12)                            */
#define SCU_PARITY_PETE_PETEMC_Msk            (0x1000UL)                /*!< SCU_PARITY PETE: PETEMC (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PETE_PETEPPRF_Pos          (13UL)                    /*!< SCU_PARITY PETE: PETEPPRF (Bit 13)                          */
#define SCU_PARITY_PETE_PETEPPRF_Msk          (0x2000UL)                /*!< SCU_PARITY PETE: PETEPPRF (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_PETE_PETEUSB_Pos           (16UL)                    /*!< SCU_PARITY PETE: PETEUSB (Bit 16)                           */
#define SCU_PARITY_PETE_PETEUSB_Msk           (0x10000UL)               /*!< SCU_PARITY PETE: PETEUSB (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PETE_PETEETH0TX_Pos        (17UL)                    /*!< SCU_PARITY PETE: PETEETH0TX (Bit 17)                        */
#define SCU_PARITY_PETE_PETEETH0TX_Msk        (0x20000UL)               /*!< SCU_PARITY PETE: PETEETH0TX (Bitfield-Mask: 0x01)           */
#define SCU_PARITY_PETE_PETEETH0RX_Pos        (18UL)                    /*!< SCU_PARITY PETE: PETEETH0RX (Bit 18)                        */
#define SCU_PARITY_PETE_PETEETH0RX_Msk        (0x40000UL)               /*!< SCU_PARITY PETE: PETEETH0RX (Bitfield-Mask: 0x01)           */
#define SCU_PARITY_PETE_PETESD0_Pos           (19UL)                    /*!< SCU_PARITY PETE: PETESD0 (Bit 19)                           */
#define SCU_PARITY_PETE_PETESD0_Msk           (0x80000UL)               /*!< SCU_PARITY PETE: PETESD0 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PETE_PETESD1_Pos           (20UL)                    /*!< SCU_PARITY PETE: PETESD1 (Bit 20)                           */
#define SCU_PARITY_PETE_PETESD1_Msk           (0x100000UL)              /*!< SCU_PARITY PETE: PETESD1 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PETE_PETEECAT0_Pos         (24UL)                    /*!< SCU_PARITY PETE: PETEECAT0 (Bit 24)                         */
#define SCU_PARITY_PETE_PETEECAT0_Msk         (0x1000000UL)             /*!< SCU_PARITY PETE: PETEECAT0 (Bitfield-Mask: 0x01)            */

/* -----------------------------  SCU_PARITY_PERSTEN  ----------------------------- */
#define SCU_PARITY_PERSTEN_RSEN_Pos           (0UL)                     /*!< SCU_PARITY PERSTEN: RSEN (Bit 0)                            */
#define SCU_PARITY_PERSTEN_RSEN_Msk           (0x1UL)                   /*!< SCU_PARITY PERSTEN: RSEN (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_PARITY_PEFLAG  ----------------------------- */
#define SCU_PARITY_PEFLAG_PEFPS_Pos           (0UL)                     /*!< SCU_PARITY PEFLAG: PEFPS (Bit 0)                            */
#define SCU_PARITY_PEFLAG_PEFPS_Msk           (0x1UL)                   /*!< SCU_PARITY PEFLAG: PEFPS (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEFLAG_PEFDS1_Pos          (1UL)                     /*!< SCU_PARITY PEFLAG: PEFDS1 (Bit 1)                           */
#define SCU_PARITY_PEFLAG_PEFDS1_Msk          (0x2UL)                   /*!< SCU_PARITY PEFLAG: PEFDS1 (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_PEFLAG_PEFDS2_Pos          (2UL)                     /*!< SCU_PARITY PEFLAG: PEFDS2 (Bit 2)                           */
#define SCU_PARITY_PEFLAG_PEFDS2_Msk          (0x4UL)                   /*!< SCU_PARITY PEFLAG: PEFDS2 (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_PEFLAG_PEFU0_Pos           (8UL)                     /*!< SCU_PARITY PEFLAG: PEFU0 (Bit 8)                            */
#define SCU_PARITY_PEFLAG_PEFU0_Msk           (0x100UL)                 /*!< SCU_PARITY PEFLAG: PEFU0 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEFLAG_PEFU1_Pos           (9UL)                     /*!< SCU_PARITY PEFLAG: PEFU1 (Bit 9)                            */
#define SCU_PARITY_PEFLAG_PEFU1_Msk           (0x200UL)                 /*!< SCU_PARITY PEFLAG: PEFU1 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEFLAG_PEFU2_Pos           (10UL)                    /*!< SCU_PARITY PEFLAG: PEFU2 (Bit 10)                           */
#define SCU_PARITY_PEFLAG_PEFU2_Msk           (0x400UL)                 /*!< SCU_PARITY PEFLAG: PEFU2 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEFLAG_PEFMC_Pos           (12UL)                    /*!< SCU_PARITY PEFLAG: PEFMC (Bit 12)                           */
#define SCU_PARITY_PEFLAG_PEFMC_Msk           (0x1000UL)                /*!< SCU_PARITY PEFLAG: PEFMC (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEFLAG_PEFPPRF_Pos         (13UL)                    /*!< SCU_PARITY PEFLAG: PEFPPRF (Bit 13)                         */
#define SCU_PARITY_PEFLAG_PEFPPRF_Msk         (0x2000UL)                /*!< SCU_PARITY PEFLAG: PEFPPRF (Bitfield-Mask: 0x01)            */
#define SCU_PARITY_PEFLAG_PEUSB_Pos           (16UL)                    /*!< SCU_PARITY PEFLAG: PEUSB (Bit 16)                           */
#define SCU_PARITY_PEFLAG_PEUSB_Msk           (0x10000UL)               /*!< SCU_PARITY PEFLAG: PEUSB (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEFLAG_PEETH0TX_Pos        (17UL)                    /*!< SCU_PARITY PEFLAG: PEETH0TX (Bit 17)                        */
#define SCU_PARITY_PEFLAG_PEETH0TX_Msk        (0x20000UL)               /*!< SCU_PARITY PEFLAG: PEETH0TX (Bitfield-Mask: 0x01)           */
#define SCU_PARITY_PEFLAG_PEETH0RX_Pos        (18UL)                    /*!< SCU_PARITY PEFLAG: PEETH0RX (Bit 18)                        */
#define SCU_PARITY_PEFLAG_PEETH0RX_Msk        (0x40000UL)               /*!< SCU_PARITY PEFLAG: PEETH0RX (Bitfield-Mask: 0x01)           */
#define SCU_PARITY_PEFLAG_PESD0_Pos           (19UL)                    /*!< SCU_PARITY PEFLAG: PESD0 (Bit 19)                           */
#define SCU_PARITY_PEFLAG_PESD0_Msk           (0x80000UL)               /*!< SCU_PARITY PEFLAG: PESD0 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEFLAG_PESD1_Pos           (20UL)                    /*!< SCU_PARITY PEFLAG: PESD1 (Bit 20)                           */
#define SCU_PARITY_PEFLAG_PESD1_Msk           (0x100000UL)              /*!< SCU_PARITY PEFLAG: PESD1 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEFLAG_PEECAT0_Pos         (24UL)                    /*!< SCU_PARITY PEFLAG: PEECAT0 (Bit 24)                         */
#define SCU_PARITY_PEFLAG_PEECAT0_Msk         (0x1000000UL)             /*!< SCU_PARITY PEFLAG: PEECAT0 (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_PARITY_PMTPR  ------------------------------ */
#define SCU_PARITY_PMTPR_PWR_Pos              (0UL)                     /*!< SCU_PARITY PMTPR: PWR (Bit 0)                               */
#define SCU_PARITY_PMTPR_PWR_Msk              (0xffUL)                  /*!< SCU_PARITY PMTPR: PWR (Bitfield-Mask: 0xff)                 */
#define SCU_PARITY_PMTPR_PRD_Pos              (8UL)                     /*!< SCU_PARITY PMTPR: PRD (Bit 8)                               */
#define SCU_PARITY_PMTPR_PRD_Msk              (0xff00UL)                /*!< SCU_PARITY PMTPR: PRD (Bitfield-Mask: 0xff)                 */

/* ------------------------------  SCU_PARITY_PMTSR  ------------------------------ */
#define SCU_PARITY_PMTSR_MTENPS_Pos           (0UL)                     /*!< SCU_PARITY PMTSR: MTENPS (Bit 0)                            */
#define SCU_PARITY_PMTSR_MTENPS_Msk           (0x1UL)                   /*!< SCU_PARITY PMTSR: MTENPS (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PMTSR_MTENDS1_Pos          (1UL)                     /*!< SCU_PARITY PMTSR: MTENDS1 (Bit 1)                           */
#define SCU_PARITY_PMTSR_MTENDS1_Msk          (0x2UL)                   /*!< SCU_PARITY PMTSR: MTENDS1 (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_PMTSR_MTENDS2_Pos          (2UL)                     /*!< SCU_PARITY PMTSR: MTENDS2 (Bit 2)                           */
#define SCU_PARITY_PMTSR_MTENDS2_Msk          (0x4UL)                   /*!< SCU_PARITY PMTSR: MTENDS2 (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_PMTSR_MTEU0_Pos            (8UL)                     /*!< SCU_PARITY PMTSR: MTEU0 (Bit 8)                             */
#define SCU_PARITY_PMTSR_MTEU0_Msk            (0x100UL)                 /*!< SCU_PARITY PMTSR: MTEU0 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PMTSR_MTEU1_Pos            (9UL)                     /*!< SCU_PARITY PMTSR: MTEU1 (Bit 9)                             */
#define SCU_PARITY_PMTSR_MTEU1_Msk            (0x200UL)                 /*!< SCU_PARITY PMTSR: MTEU1 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PMTSR_MTEU2_Pos            (10UL)                    /*!< SCU_PARITY PMTSR: MTEU2 (Bit 10)                            */
#define SCU_PARITY_PMTSR_MTEU2_Msk            (0x400UL)                 /*!< SCU_PARITY PMTSR: MTEU2 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PMTSR_MTEMC_Pos            (12UL)                    /*!< SCU_PARITY PMTSR: MTEMC (Bit 12)                            */
#define SCU_PARITY_PMTSR_MTEMC_Msk            (0x1000UL)                /*!< SCU_PARITY PMTSR: MTEMC (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PMTSR_MTEPPRF_Pos          (13UL)                    /*!< SCU_PARITY PMTSR: MTEPPRF (Bit 13)                          */
#define SCU_PARITY_PMTSR_MTEPPRF_Msk          (0x2000UL)                /*!< SCU_PARITY PMTSR: MTEPPRF (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_PMTSR_MTUSB_Pos            (16UL)                    /*!< SCU_PARITY PMTSR: MTUSB (Bit 16)                            */
#define SCU_PARITY_PMTSR_MTUSB_Msk            (0x10000UL)               /*!< SCU_PARITY PMTSR: MTUSB (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PMTSR_MTETH0TX_Pos         (17UL)                    /*!< SCU_PARITY PMTSR: MTETH0TX (Bit 17)                         */
#define SCU_PARITY_PMTSR_MTETH0TX_Msk         (0x20000UL)               /*!< SCU_PARITY PMTSR: MTETH0TX (Bitfield-Mask: 0x01)            */
#define SCU_PARITY_PMTSR_MTETH0RX_Pos         (18UL)                    /*!< SCU_PARITY PMTSR: MTETH0RX (Bit 18)                         */
#define SCU_PARITY_PMTSR_MTETH0RX_Msk         (0x40000UL)               /*!< SCU_PARITY PMTSR: MTETH0RX (Bitfield-Mask: 0x01)            */
#define SCU_PARITY_PMTSR_MTSD0_Pos            (19UL)                    /*!< SCU_PARITY PMTSR: MTSD0 (Bit 19)                            */
#define SCU_PARITY_PMTSR_MTSD0_Msk            (0x80000UL)               /*!< SCU_PARITY PMTSR: MTSD0 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PMTSR_MTSD1_Pos            (20UL)                    /*!< SCU_PARITY PMTSR: MTSD1 (Bit 20)                            */
#define SCU_PARITY_PMTSR_MTSD1_Msk            (0x100000UL)              /*!< SCU_PARITY PMTSR: MTSD1 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PMTSR_MTECAT0_Pos          (24UL)                    /*!< SCU_PARITY PMTSR: MTECAT0 (Bit 24)                          */
#define SCU_PARITY_PMTSR_MTECAT0_Msk          (0x1000000UL)             /*!< SCU_PARITY PMTSR: MTECAT0 (Bitfield-Mask: 0x01)             */


/* ================================================================================ */
/* ================        struct 'SCU_TRAP' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  SCU_TRAP_TRAPSTAT  ----------------------------- */
#define SCU_TRAP_TRAPSTAT_SOSCWDGT_Pos        (0UL)                     /*!< SCU_TRAP TRAPSTAT: SOSCWDGT (Bit 0)                         */
#define SCU_TRAP_TRAPSTAT_SOSCWDGT_Msk        (0x1UL)                   /*!< SCU_TRAP TRAPSTAT: SOSCWDGT (Bitfield-Mask: 0x01)           */
#define SCU_TRAP_TRAPSTAT_SVCOLCKT_Pos        (2UL)                     /*!< SCU_TRAP TRAPSTAT: SVCOLCKT (Bit 2)                         */
#define SCU_TRAP_TRAPSTAT_SVCOLCKT_Msk        (0x4UL)                   /*!< SCU_TRAP TRAPSTAT: SVCOLCKT (Bitfield-Mask: 0x01)           */
#define SCU_TRAP_TRAPSTAT_UVCOLCKT_Pos        (3UL)                     /*!< SCU_TRAP TRAPSTAT: UVCOLCKT (Bit 3)                         */
#define SCU_TRAP_TRAPSTAT_UVCOLCKT_Msk        (0x8UL)                   /*!< SCU_TRAP TRAPSTAT: UVCOLCKT (Bitfield-Mask: 0x01)           */
#define SCU_TRAP_TRAPSTAT_PET_Pos             (4UL)                     /*!< SCU_TRAP TRAPSTAT: PET (Bit 4)                              */
#define SCU_TRAP_TRAPSTAT_PET_Msk             (0x10UL)                  /*!< SCU_TRAP TRAPSTAT: PET (Bitfield-Mask: 0x01)                */
#define SCU_TRAP_TRAPSTAT_BRWNT_Pos           (5UL)                     /*!< SCU_TRAP TRAPSTAT: BRWNT (Bit 5)                            */
#define SCU_TRAP_TRAPSTAT_BRWNT_Msk           (0x20UL)                  /*!< SCU_TRAP TRAPSTAT: BRWNT (Bitfield-Mask: 0x01)              */
#define SCU_TRAP_TRAPSTAT_ULPWDGT_Pos         (6UL)                     /*!< SCU_TRAP TRAPSTAT: ULPWDGT (Bit 6)                          */
#define SCU_TRAP_TRAPSTAT_ULPWDGT_Msk         (0x40UL)                  /*!< SCU_TRAP TRAPSTAT: ULPWDGT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPSTAT_BWERR0T_Pos         (7UL)                     /*!< SCU_TRAP TRAPSTAT: BWERR0T (Bit 7)                          */
#define SCU_TRAP_TRAPSTAT_BWERR0T_Msk         (0x80UL)                  /*!< SCU_TRAP TRAPSTAT: BWERR0T (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPSTAT_BWERR1T_Pos         (8UL)                     /*!< SCU_TRAP TRAPSTAT: BWERR1T (Bit 8)                          */
#define SCU_TRAP_TRAPSTAT_BWERR1T_Msk         (0x100UL)                 /*!< SCU_TRAP TRAPSTAT: BWERR1T (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPSTAT_ECAT0RST_Pos        (16UL)                    /*!< SCU_TRAP TRAPSTAT: ECAT0RST (Bit 16)                        */
#define SCU_TRAP_TRAPSTAT_ECAT0RST_Msk        (0x10000UL)               /*!< SCU_TRAP TRAPSTAT: ECAT0RST (Bitfield-Mask: 0x01)           */

/* ------------------------------  SCU_TRAP_TRAPRAW  ------------------------------ */
#define SCU_TRAP_TRAPRAW_SOSCWDGT_Pos         (0UL)                     /*!< SCU_TRAP TRAPRAW: SOSCWDGT (Bit 0)                          */
#define SCU_TRAP_TRAPRAW_SOSCWDGT_Msk         (0x1UL)                   /*!< SCU_TRAP TRAPRAW: SOSCWDGT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPRAW_SVCOLCKT_Pos         (2UL)                     /*!< SCU_TRAP TRAPRAW: SVCOLCKT (Bit 2)                          */
#define SCU_TRAP_TRAPRAW_SVCOLCKT_Msk         (0x4UL)                   /*!< SCU_TRAP TRAPRAW: SVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPRAW_UVCOLCKT_Pos         (3UL)                     /*!< SCU_TRAP TRAPRAW: UVCOLCKT (Bit 3)                          */
#define SCU_TRAP_TRAPRAW_UVCOLCKT_Msk         (0x8UL)                   /*!< SCU_TRAP TRAPRAW: UVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPRAW_PET_Pos              (4UL)                     /*!< SCU_TRAP TRAPRAW: PET (Bit 4)                               */
#define SCU_TRAP_TRAPRAW_PET_Msk              (0x10UL)                  /*!< SCU_TRAP TRAPRAW: PET (Bitfield-Mask: 0x01)                 */
#define SCU_TRAP_TRAPRAW_BRWNT_Pos            (5UL)                     /*!< SCU_TRAP TRAPRAW: BRWNT (Bit 5)                             */
#define SCU_TRAP_TRAPRAW_BRWNT_Msk            (0x20UL)                  /*!< SCU_TRAP TRAPRAW: BRWNT (Bitfield-Mask: 0x01)               */
#define SCU_TRAP_TRAPRAW_ULPWDGT_Pos          (6UL)                     /*!< SCU_TRAP TRAPRAW: ULPWDGT (Bit 6)                           */
#define SCU_TRAP_TRAPRAW_ULPWDGT_Msk          (0x40UL)                  /*!< SCU_TRAP TRAPRAW: ULPWDGT (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPRAW_BWERR0T_Pos          (7UL)                     /*!< SCU_TRAP TRAPRAW: BWERR0T (Bit 7)                           */
#define SCU_TRAP_TRAPRAW_BWERR0T_Msk          (0x80UL)                  /*!< SCU_TRAP TRAPRAW: BWERR0T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPRAW_BWERR1T_Pos          (8UL)                     /*!< SCU_TRAP TRAPRAW: BWERR1T (Bit 8)                           */
#define SCU_TRAP_TRAPRAW_BWERR1T_Msk          (0x100UL)                 /*!< SCU_TRAP TRAPRAW: BWERR1T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPRAW_ECAT0RST_Pos         (16UL)                    /*!< SCU_TRAP TRAPRAW: ECAT0RST (Bit 16)                         */
#define SCU_TRAP_TRAPRAW_ECAT0RST_Msk         (0x10000UL)               /*!< SCU_TRAP TRAPRAW: ECAT0RST (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_TRAP_TRAPDIS  ------------------------------ */
#define SCU_TRAP_TRAPDIS_SOSCWDGT_Pos         (0UL)                     /*!< SCU_TRAP TRAPDIS: SOSCWDGT (Bit 0)                          */
#define SCU_TRAP_TRAPDIS_SOSCWDGT_Msk         (0x1UL)                   /*!< SCU_TRAP TRAPDIS: SOSCWDGT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPDIS_SVCOLCKT_Pos         (2UL)                     /*!< SCU_TRAP TRAPDIS: SVCOLCKT (Bit 2)                          */
#define SCU_TRAP_TRAPDIS_SVCOLCKT_Msk         (0x4UL)                   /*!< SCU_TRAP TRAPDIS: SVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPDIS_UVCOLCKT_Pos         (3UL)                     /*!< SCU_TRAP TRAPDIS: UVCOLCKT (Bit 3)                          */
#define SCU_TRAP_TRAPDIS_UVCOLCKT_Msk         (0x8UL)                   /*!< SCU_TRAP TRAPDIS: UVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPDIS_PET_Pos              (4UL)                     /*!< SCU_TRAP TRAPDIS: PET (Bit 4)                               */
#define SCU_TRAP_TRAPDIS_PET_Msk              (0x10UL)                  /*!< SCU_TRAP TRAPDIS: PET (Bitfield-Mask: 0x01)                 */
#define SCU_TRAP_TRAPDIS_BRWNT_Pos            (5UL)                     /*!< SCU_TRAP TRAPDIS: BRWNT (Bit 5)                             */
#define SCU_TRAP_TRAPDIS_BRWNT_Msk            (0x20UL)                  /*!< SCU_TRAP TRAPDIS: BRWNT (Bitfield-Mask: 0x01)               */
#define SCU_TRAP_TRAPDIS_ULPWDGT_Pos          (6UL)                     /*!< SCU_TRAP TRAPDIS: ULPWDGT (Bit 6)                           */
#define SCU_TRAP_TRAPDIS_ULPWDGT_Msk          (0x40UL)                  /*!< SCU_TRAP TRAPDIS: ULPWDGT (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPDIS_BWERR0T_Pos          (7UL)                     /*!< SCU_TRAP TRAPDIS: BWERR0T (Bit 7)                           */
#define SCU_TRAP_TRAPDIS_BWERR0T_Msk          (0x80UL)                  /*!< SCU_TRAP TRAPDIS: BWERR0T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPDIS_BWERR1T_Pos          (8UL)                     /*!< SCU_TRAP TRAPDIS: BWERR1T (Bit 8)                           */
#define SCU_TRAP_TRAPDIS_BWERR1T_Msk          (0x100UL)                 /*!< SCU_TRAP TRAPDIS: BWERR1T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPDIS_ECAT0RST_Pos         (16UL)                    /*!< SCU_TRAP TRAPDIS: ECAT0RST (Bit 16)                         */
#define SCU_TRAP_TRAPDIS_ECAT0RST_Msk         (0x10000UL)               /*!< SCU_TRAP TRAPDIS: ECAT0RST (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_TRAP_TRAPCLR  ------------------------------ */
#define SCU_TRAP_TRAPCLR_SOSCWDGT_Pos         (0UL)                     /*!< SCU_TRAP TRAPCLR: SOSCWDGT (Bit 0)                          */
#define SCU_TRAP_TRAPCLR_SOSCWDGT_Msk         (0x1UL)                   /*!< SCU_TRAP TRAPCLR: SOSCWDGT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPCLR_SVCOLCKT_Pos         (2UL)                     /*!< SCU_TRAP TRAPCLR: SVCOLCKT (Bit 2)                          */
#define SCU_TRAP_TRAPCLR_SVCOLCKT_Msk         (0x4UL)                   /*!< SCU_TRAP TRAPCLR: SVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPCLR_UVCOLCKT_Pos         (3UL)                     /*!< SCU_TRAP TRAPCLR: UVCOLCKT (Bit 3)                          */
#define SCU_TRAP_TRAPCLR_UVCOLCKT_Msk         (0x8UL)                   /*!< SCU_TRAP TRAPCLR: UVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPCLR_PET_Pos              (4UL)                     /*!< SCU_TRAP TRAPCLR: PET (Bit 4)                               */
#define SCU_TRAP_TRAPCLR_PET_Msk              (0x10UL)                  /*!< SCU_TRAP TRAPCLR: PET (Bitfield-Mask: 0x01)                 */
#define SCU_TRAP_TRAPCLR_BRWNT_Pos            (5UL)                     /*!< SCU_TRAP TRAPCLR: BRWNT (Bit 5)                             */
#define SCU_TRAP_TRAPCLR_BRWNT_Msk            (0x20UL)                  /*!< SCU_TRAP TRAPCLR: BRWNT (Bitfield-Mask: 0x01)               */
#define SCU_TRAP_TRAPCLR_ULPWDGT_Pos          (6UL)                     /*!< SCU_TRAP TRAPCLR: ULPWDGT (Bit 6)                           */
#define SCU_TRAP_TRAPCLR_ULPWDGT_Msk          (0x40UL)                  /*!< SCU_TRAP TRAPCLR: ULPWDGT (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPCLR_BWERR0T_Pos          (7UL)                     /*!< SCU_TRAP TRAPCLR: BWERR0T (Bit 7)                           */
#define SCU_TRAP_TRAPCLR_BWERR0T_Msk          (0x80UL)                  /*!< SCU_TRAP TRAPCLR: BWERR0T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPCLR_BWERR1T_Pos          (8UL)                     /*!< SCU_TRAP TRAPCLR: BWERR1T (Bit 8)                           */
#define SCU_TRAP_TRAPCLR_BWERR1T_Msk          (0x100UL)                 /*!< SCU_TRAP TRAPCLR: BWERR1T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPCLR_ECAT0RST_Pos         (16UL)                    /*!< SCU_TRAP TRAPCLR: ECAT0RST (Bit 16)                         */
#define SCU_TRAP_TRAPCLR_ECAT0RST_Msk         (0x10000UL)               /*!< SCU_TRAP TRAPCLR: ECAT0RST (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_TRAP_TRAPSET  ------------------------------ */
#define SCU_TRAP_TRAPSET_SOSCWDGT_Pos         (0UL)                     /*!< SCU_TRAP TRAPSET: SOSCWDGT (Bit 0)                          */
#define SCU_TRAP_TRAPSET_SOSCWDGT_Msk         (0x1UL)                   /*!< SCU_TRAP TRAPSET: SOSCWDGT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPSET_SVCOLCKT_Pos         (2UL)                     /*!< SCU_TRAP TRAPSET: SVCOLCKT (Bit 2)                          */
#define SCU_TRAP_TRAPSET_SVCOLCKT_Msk         (0x4UL)                   /*!< SCU_TRAP TRAPSET: SVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPSET_UVCOLCKT_Pos         (3UL)                     /*!< SCU_TRAP TRAPSET: UVCOLCKT (Bit 3)                          */
#define SCU_TRAP_TRAPSET_UVCOLCKT_Msk         (0x8UL)                   /*!< SCU_TRAP TRAPSET: UVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPSET_PET_Pos              (4UL)                     /*!< SCU_TRAP TRAPSET: PET (Bit 4)                               */
#define SCU_TRAP_TRAPSET_PET_Msk              (0x10UL)                  /*!< SCU_TRAP TRAPSET: PET (Bitfield-Mask: 0x01)                 */
#define SCU_TRAP_TRAPSET_BRWNT_Pos            (5UL)                     /*!< SCU_TRAP TRAPSET: BRWNT (Bit 5)                             */
#define SCU_TRAP_TRAPSET_BRWNT_Msk            (0x20UL)                  /*!< SCU_TRAP TRAPSET: BRWNT (Bitfield-Mask: 0x01)               */
#define SCU_TRAP_TRAPSET_ULPWDT_Pos           (6UL)                     /*!< SCU_TRAP TRAPSET: ULPWDT (Bit 6)                            */
#define SCU_TRAP_TRAPSET_ULPWDT_Msk           (0x40UL)                  /*!< SCU_TRAP TRAPSET: ULPWDT (Bitfield-Mask: 0x01)              */
#define SCU_TRAP_TRAPSET_BWERR0T_Pos          (7UL)                     /*!< SCU_TRAP TRAPSET: BWERR0T (Bit 7)                           */
#define SCU_TRAP_TRAPSET_BWERR0T_Msk          (0x80UL)                  /*!< SCU_TRAP TRAPSET: BWERR0T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPSET_BWERR1T_Pos          (8UL)                     /*!< SCU_TRAP TRAPSET: BWERR1T (Bit 8)                           */
#define SCU_TRAP_TRAPSET_BWERR1T_Msk          (0x100UL)                 /*!< SCU_TRAP TRAPSET: BWERR1T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPSET_ECAT0RST_Pos         (16UL)                    /*!< SCU_TRAP TRAPSET: ECAT0RST (Bit 16)                         */
#define SCU_TRAP_TRAPSET_ECAT0RST_Msk         (0x10000UL)               /*!< SCU_TRAP TRAPSET: ECAT0RST (Bitfield-Mask: 0x01)            */


/* ================================================================================ */
/* ================     struct 'SCU_HIBERNATE' Position & Mask     ================ */
/* ================================================================================ */


/* ----------------------------  SCU_HIBERNATE_HDSTAT  ---------------------------- */
#define SCU_HIBERNATE_HDSTAT_EPEV_Pos         (0UL)                     /*!< SCU_HIBERNATE HDSTAT: EPEV (Bit 0)                          */
#define SCU_HIBERNATE_HDSTAT_EPEV_Msk         (0x1UL)                   /*!< SCU_HIBERNATE HDSTAT: EPEV (Bitfield-Mask: 0x01)            */
#define SCU_HIBERNATE_HDSTAT_ENEV_Pos         (1UL)                     /*!< SCU_HIBERNATE HDSTAT: ENEV (Bit 1)                          */
#define SCU_HIBERNATE_HDSTAT_ENEV_Msk         (0x2UL)                   /*!< SCU_HIBERNATE HDSTAT: ENEV (Bitfield-Mask: 0x01)            */
#define SCU_HIBERNATE_HDSTAT_RTCEV_Pos        (2UL)                     /*!< SCU_HIBERNATE HDSTAT: RTCEV (Bit 2)                         */
#define SCU_HIBERNATE_HDSTAT_RTCEV_Msk        (0x4UL)                   /*!< SCU_HIBERNATE HDSTAT: RTCEV (Bitfield-Mask: 0x01)           */
#define SCU_HIBERNATE_HDSTAT_ULPWDG_Pos       (3UL)                     /*!< SCU_HIBERNATE HDSTAT: ULPWDG (Bit 3)                        */
#define SCU_HIBERNATE_HDSTAT_ULPWDG_Msk       (0x8UL)                   /*!< SCU_HIBERNATE HDSTAT: ULPWDG (Bitfield-Mask: 0x01)          */
#define SCU_HIBERNATE_HDSTAT_HIBNOUT_Pos      (4UL)                     /*!< SCU_HIBERNATE HDSTAT: HIBNOUT (Bit 4)                       */
#define SCU_HIBERNATE_HDSTAT_HIBNOUT_Msk      (0x10UL)                  /*!< SCU_HIBERNATE HDSTAT: HIBNOUT (Bitfield-Mask: 0x01)         */

/* -----------------------------  SCU_HIBERNATE_HDCLR  ---------------------------- */
#define SCU_HIBERNATE_HDCLR_EPEV_Pos          (0UL)                     /*!< SCU_HIBERNATE HDCLR: EPEV (Bit 0)                           */
#define SCU_HIBERNATE_HDCLR_EPEV_Msk          (0x1UL)                   /*!< SCU_HIBERNATE HDCLR: EPEV (Bitfield-Mask: 0x01)             */
#define SCU_HIBERNATE_HDCLR_ENEV_Pos          (1UL)                     /*!< SCU_HIBERNATE HDCLR: ENEV (Bit 1)                           */
#define SCU_HIBERNATE_HDCLR_ENEV_Msk          (0x2UL)                   /*!< SCU_HIBERNATE HDCLR: ENEV (Bitfield-Mask: 0x01)             */
#define SCU_HIBERNATE_HDCLR_RTCEV_Pos         (2UL)                     /*!< SCU_HIBERNATE HDCLR: RTCEV (Bit 2)                          */
#define SCU_HIBERNATE_HDCLR_RTCEV_Msk         (0x4UL)                   /*!< SCU_HIBERNATE HDCLR: RTCEV (Bitfield-Mask: 0x01)            */
#define SCU_HIBERNATE_HDCLR_ULPWDG_Pos        (3UL)                     /*!< SCU_HIBERNATE HDCLR: ULPWDG (Bit 3)                         */
#define SCU_HIBERNATE_HDCLR_ULPWDG_Msk        (0x8UL)                   /*!< SCU_HIBERNATE HDCLR: ULPWDG (Bitfield-Mask: 0x01)           */

/* -----------------------------  SCU_HIBERNATE_HDSET  ---------------------------- */
#define SCU_HIBERNATE_HDSET_EPEV_Pos          (0UL)                     /*!< SCU_HIBERNATE HDSET: EPEV (Bit 0)                           */
#define SCU_HIBERNATE_HDSET_EPEV_Msk          (0x1UL)                   /*!< SCU_HIBERNATE HDSET: EPEV (Bitfield-Mask: 0x01)             */
#define SCU_HIBERNATE_HDSET_ENEV_Pos          (1UL)                     /*!< SCU_HIBERNATE HDSET: ENEV (Bit 1)                           */
#define SCU_HIBERNATE_HDSET_ENEV_Msk          (0x2UL)                   /*!< SCU_HIBERNATE HDSET: ENEV (Bitfield-Mask: 0x01)             */
#define SCU_HIBERNATE_HDSET_RTCEV_Pos         (2UL)                     /*!< SCU_HIBERNATE HDSET: RTCEV (Bit 2)                          */
#define SCU_HIBERNATE_HDSET_RTCEV_Msk         (0x4UL)                   /*!< SCU_HIBERNATE HDSET: RTCEV (Bitfield-Mask: 0x01)            */
#define SCU_HIBERNATE_HDSET_ULPWDG_Pos        (3UL)                     /*!< SCU_HIBERNATE HDSET: ULPWDG (Bit 3)                         */
#define SCU_HIBERNATE_HDSET_ULPWDG_Msk        (0x8UL)                   /*!< SCU_HIBERNATE HDSET: ULPWDG (Bitfield-Mask: 0x01)           */

/* -----------------------------  SCU_HIBERNATE_HDCR  ----------------------------- */
#define SCU_HIBERNATE_HDCR_WKPEP_Pos          (0UL)                     /*!< SCU_HIBERNATE HDCR: WKPEP (Bit 0)                           */
#define SCU_HIBERNATE_HDCR_WKPEP_Msk          (0x1UL)                   /*!< SCU_HIBERNATE HDCR: WKPEP (Bitfield-Mask: 0x01)             */
#define SCU_HIBERNATE_HDCR_WKPEN_Pos          (1UL)                     /*!< SCU_HIBERNATE HDCR: WKPEN (Bit 1)                           */
#define SCU_HIBERNATE_HDCR_WKPEN_Msk          (0x2UL)                   /*!< SCU_HIBERNATE HDCR: WKPEN (Bitfield-Mask: 0x01)             */
#define SCU_HIBERNATE_HDCR_RTCE_Pos           (2UL)                     /*!< SCU_HIBERNATE HDCR: RTCE (Bit 2)                            */
#define SCU_HIBERNATE_HDCR_RTCE_Msk           (0x4UL)                   /*!< SCU_HIBERNATE HDCR: RTCE (Bitfield-Mask: 0x01)              */
#define SCU_HIBERNATE_HDCR_ULPWDGEN_Pos       (3UL)                     /*!< SCU_HIBERNATE HDCR: ULPWDGEN (Bit 3)                        */
#define SCU_HIBERNATE_HDCR_ULPWDGEN_Msk       (0x8UL)                   /*!< SCU_HIBERNATE HDCR: ULPWDGEN (Bitfield-Mask: 0x01)          */
#define SCU_HIBERNATE_HDCR_HIB_Pos            (4UL)                     /*!< SCU_HIBERNATE HDCR: HIB (Bit 4)                             */
#define SCU_HIBERNATE_HDCR_HIB_Msk            (0x10UL)                  /*!< SCU_HIBERNATE HDCR: HIB (Bitfield-Mask: 0x01)               */
#define SCU_HIBERNATE_HDCR_RCS_Pos            (6UL)                     /*!< SCU_HIBERNATE HDCR: RCS (Bit 6)                             */
#define SCU_HIBERNATE_HDCR_RCS_Msk            (0x40UL)                  /*!< SCU_HIBERNATE HDCR: RCS (Bitfield-Mask: 0x01)               */
#define SCU_HIBERNATE_HDCR_STDBYSEL_Pos       (7UL)                     /*!< SCU_HIBERNATE HDCR: STDBYSEL (Bit 7)                        */
#define SCU_HIBERNATE_HDCR_STDBYSEL_Msk       (0x80UL)                  /*!< SCU_HIBERNATE HDCR: STDBYSEL (Bitfield-Mask: 0x01)          */
#define SCU_HIBERNATE_HDCR_WKUPSEL_Pos        (8UL)                     /*!< SCU_HIBERNATE HDCR: WKUPSEL (Bit 8)                         */
#define SCU_HIBERNATE_HDCR_WKUPSEL_Msk        (0x100UL)                 /*!< SCU_HIBERNATE HDCR: WKUPSEL (Bitfield-Mask: 0x01)           */
#define SCU_HIBERNATE_HDCR_GPI0SEL_Pos        (10UL)                    /*!< SCU_HIBERNATE HDCR: GPI0SEL (Bit 10)                        */
#define SCU_HIBERNATE_HDCR_GPI0SEL_Msk        (0x400UL)                 /*!< SCU_HIBERNATE HDCR: GPI0SEL (Bitfield-Mask: 0x01)           */
#define SCU_HIBERNATE_HDCR_HIBIO0POL_Pos      (12UL)                    /*!< SCU_HIBERNATE HDCR: HIBIO0POL (Bit 12)                      */
#define SCU_HIBERNATE_HDCR_HIBIO0POL_Msk      (0x1000UL)                /*!< SCU_HIBERNATE HDCR: HIBIO0POL (Bitfield-Mask: 0x01)         */
#define SCU_HIBERNATE_HDCR_HIBIO1POL_Pos      (13UL)                    /*!< SCU_HIBERNATE HDCR: HIBIO1POL (Bit 13)                      */
#define SCU_HIBERNATE_HDCR_HIBIO1POL_Msk      (0x2000UL)                /*!< SCU_HIBERNATE HDCR: HIBIO1POL (Bitfield-Mask: 0x01)         */
#define SCU_HIBERNATE_HDCR_HIBIO0SEL_Pos      (16UL)                    /*!< SCU_HIBERNATE HDCR: HIBIO0SEL (Bit 16)                      */
#define SCU_HIBERNATE_HDCR_HIBIO0SEL_Msk      (0xf0000UL)               /*!< SCU_HIBERNATE HDCR: HIBIO0SEL (Bitfield-Mask: 0x0f)         */
#define SCU_HIBERNATE_HDCR_HIBIO1SEL_Pos      (20UL)                    /*!< SCU_HIBERNATE HDCR: HIBIO1SEL (Bit 20)                      */
#define SCU_HIBERNATE_HDCR_HIBIO1SEL_Msk      (0xf00000UL)              /*!< SCU_HIBERNATE HDCR: HIBIO1SEL (Bitfield-Mask: 0x0f)         */

/* ---------------------------  SCU_HIBERNATE_OSCSICTRL  -------------------------- */
#define SCU_HIBERNATE_OSCSICTRL_PWD_Pos       (0UL)                     /*!< SCU_HIBERNATE OSCSICTRL: PWD (Bit 0)                        */
#define SCU_HIBERNATE_OSCSICTRL_PWD_Msk       (0x1UL)                   /*!< SCU_HIBERNATE OSCSICTRL: PWD (Bitfield-Mask: 0x01)          */

/* ---------------------------  SCU_HIBERNATE_OSCULSTAT  -------------------------- */
#define SCU_HIBERNATE_OSCULSTAT_X1D_Pos       (0UL)                     /*!< SCU_HIBERNATE OSCULSTAT: X1D (Bit 0)                        */
#define SCU_HIBERNATE_OSCULSTAT_X1D_Msk       (0x1UL)                   /*!< SCU_HIBERNATE OSCULSTAT: X1D (Bitfield-Mask: 0x01)          */

/* ---------------------------  SCU_HIBERNATE_OSCULCTRL  -------------------------- */
#define SCU_HIBERNATE_OSCULCTRL_X1DEN_Pos     (0UL)                     /*!< SCU_HIBERNATE OSCULCTRL: X1DEN (Bit 0)                      */
#define SCU_HIBERNATE_OSCULCTRL_X1DEN_Msk     (0x1UL)                   /*!< SCU_HIBERNATE OSCULCTRL: X1DEN (Bitfield-Mask: 0x01)        */
#define SCU_HIBERNATE_OSCULCTRL_MODE_Pos      (4UL)                     /*!< SCU_HIBERNATE OSCULCTRL: MODE (Bit 4)                       */
#define SCU_HIBERNATE_OSCULCTRL_MODE_Msk      (0x30UL)                  /*!< SCU_HIBERNATE OSCULCTRL: MODE (Bitfield-Mask: 0x03)         */


/* ================================================================================ */
/* ================       struct 'SCU_POWER' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  SCU_POWER_PWRSTAT  ----------------------------- */
#define SCU_POWER_PWRSTAT_HIBEN_Pos           (0UL)                     /*!< SCU_POWER PWRSTAT: HIBEN (Bit 0)                            */
#define SCU_POWER_PWRSTAT_HIBEN_Msk           (0x1UL)                   /*!< SCU_POWER PWRSTAT: HIBEN (Bitfield-Mask: 0x01)              */
#define SCU_POWER_PWRSTAT_USBPHYPDQ_Pos       (16UL)                    /*!< SCU_POWER PWRSTAT: USBPHYPDQ (Bit 16)                       */
#define SCU_POWER_PWRSTAT_USBPHYPDQ_Msk       (0x10000UL)               /*!< SCU_POWER PWRSTAT: USBPHYPDQ (Bitfield-Mask: 0x01)          */
#define SCU_POWER_PWRSTAT_USBOTGEN_Pos        (17UL)                    /*!< SCU_POWER PWRSTAT: USBOTGEN (Bit 17)                        */
#define SCU_POWER_PWRSTAT_USBOTGEN_Msk        (0x20000UL)               /*!< SCU_POWER PWRSTAT: USBOTGEN (Bitfield-Mask: 0x01)           */
#define SCU_POWER_PWRSTAT_USBPUWQ_Pos         (18UL)                    /*!< SCU_POWER PWRSTAT: USBPUWQ (Bit 18)                         */
#define SCU_POWER_PWRSTAT_USBPUWQ_Msk         (0x40000UL)               /*!< SCU_POWER PWRSTAT: USBPUWQ (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_POWER_PWRSET  ------------------------------ */
#define SCU_POWER_PWRSET_HIB_Pos              (0UL)                     /*!< SCU_POWER PWRSET: HIB (Bit 0)                               */
#define SCU_POWER_PWRSET_HIB_Msk              (0x1UL)                   /*!< SCU_POWER PWRSET: HIB (Bitfield-Mask: 0x01)                 */
#define SCU_POWER_PWRSET_USBPHYPDQ_Pos        (16UL)                    /*!< SCU_POWER PWRSET: USBPHYPDQ (Bit 16)                        */
#define SCU_POWER_PWRSET_USBPHYPDQ_Msk        (0x10000UL)               /*!< SCU_POWER PWRSET: USBPHYPDQ (Bitfield-Mask: 0x01)           */
#define SCU_POWER_PWRSET_USBOTGEN_Pos         (17UL)                    /*!< SCU_POWER PWRSET: USBOTGEN (Bit 17)                         */
#define SCU_POWER_PWRSET_USBOTGEN_Msk         (0x20000UL)               /*!< SCU_POWER PWRSET: USBOTGEN (Bitfield-Mask: 0x01)            */
#define SCU_POWER_PWRSET_USBPUWQ_Pos          (18UL)                    /*!< SCU_POWER PWRSET: USBPUWQ (Bit 18)                          */
#define SCU_POWER_PWRSET_USBPUWQ_Msk          (0x40000UL)               /*!< SCU_POWER PWRSET: USBPUWQ (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_POWER_PWRCLR  ------------------------------ */
#define SCU_POWER_PWRCLR_HIB_Pos              (0UL)                     /*!< SCU_POWER PWRCLR: HIB (Bit 0)                               */
#define SCU_POWER_PWRCLR_HIB_Msk              (0x1UL)                   /*!< SCU_POWER PWRCLR: HIB (Bitfield-Mask: 0x01)                 */
#define SCU_POWER_PWRCLR_USBPHYPDQ_Pos        (16UL)                    /*!< SCU_POWER PWRCLR: USBPHYPDQ (Bit 16)                        */
#define SCU_POWER_PWRCLR_USBPHYPDQ_Msk        (0x10000UL)               /*!< SCU_POWER PWRCLR: USBPHYPDQ (Bitfield-Mask: 0x01)           */
#define SCU_POWER_PWRCLR_USBOTGEN_Pos         (17UL)                    /*!< SCU_POWER PWRCLR: USBOTGEN (Bit 17)                         */
#define SCU_POWER_PWRCLR_USBOTGEN_Msk         (0x20000UL)               /*!< SCU_POWER PWRCLR: USBOTGEN (Bitfield-Mask: 0x01)            */
#define SCU_POWER_PWRCLR_USBPUWQ_Pos          (18UL)                    /*!< SCU_POWER PWRCLR: USBPUWQ (Bit 18)                          */
#define SCU_POWER_PWRCLR_USBPUWQ_Msk          (0x40000UL)               /*!< SCU_POWER PWRCLR: USBPUWQ (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_POWER_EVRSTAT  ----------------------------- */
#define SCU_POWER_EVRSTAT_OV13_Pos            (1UL)                     /*!< SCU_POWER EVRSTAT: OV13 (Bit 1)                             */
#define SCU_POWER_EVRSTAT_OV13_Msk            (0x2UL)                   /*!< SCU_POWER EVRSTAT: OV13 (Bitfield-Mask: 0x01)               */

/* ----------------------------  SCU_POWER_EVRVADCSTAT  --------------------------- */
#define SCU_POWER_EVRVADCSTAT_VADC13V_Pos     (0UL)                     /*!< SCU_POWER EVRVADCSTAT: VADC13V (Bit 0)                      */
#define SCU_POWER_EVRVADCSTAT_VADC13V_Msk     (0xffUL)                  /*!< SCU_POWER EVRVADCSTAT: VADC13V (Bitfield-Mask: 0xff)        */
#define SCU_POWER_EVRVADCSTAT_VADC33V_Pos     (8UL)                     /*!< SCU_POWER EVRVADCSTAT: VADC33V (Bit 8)                      */
#define SCU_POWER_EVRVADCSTAT_VADC33V_Msk     (0xff00UL)                /*!< SCU_POWER EVRVADCSTAT: VADC33V (Bitfield-Mask: 0xff)        */

/* ------------------------------  SCU_POWER_PWRMON  ------------------------------ */
#define SCU_POWER_PWRMON_THRS_Pos             (0UL)                     /*!< SCU_POWER PWRMON: THRS (Bit 0)                              */
#define SCU_POWER_PWRMON_THRS_Msk             (0xffUL)                  /*!< SCU_POWER PWRMON: THRS (Bitfield-Mask: 0xff)                */
#define SCU_POWER_PWRMON_INTV_Pos             (8UL)                     /*!< SCU_POWER PWRMON: INTV (Bit 8)                              */
#define SCU_POWER_PWRMON_INTV_Msk             (0xff00UL)                /*!< SCU_POWER PWRMON: INTV (Bitfield-Mask: 0xff)                */
#define SCU_POWER_PWRMON_ENB_Pos              (16UL)                    /*!< SCU_POWER PWRMON: ENB (Bit 16)                              */
#define SCU_POWER_PWRMON_ENB_Msk              (0x10000UL)               /*!< SCU_POWER PWRMON: ENB (Bitfield-Mask: 0x01)                 */


/* ================================================================================ */
/* ================       struct 'SCU_RESET' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  SCU_RESET_RSTSTAT  ----------------------------- */
#define SCU_RESET_RSTSTAT_RSTSTAT_Pos         (0UL)                     /*!< SCU_RESET RSTSTAT: RSTSTAT (Bit 0)                          */
#define SCU_RESET_RSTSTAT_RSTSTAT_Msk         (0xffUL)                  /*!< SCU_RESET RSTSTAT: RSTSTAT (Bitfield-Mask: 0xff)            */
#define SCU_RESET_RSTSTAT_HIBWK_Pos           (8UL)                     /*!< SCU_RESET RSTSTAT: HIBWK (Bit 8)                            */
#define SCU_RESET_RSTSTAT_HIBWK_Msk           (0x100UL)                 /*!< SCU_RESET RSTSTAT: HIBWK (Bitfield-Mask: 0x01)              */
#define SCU_RESET_RSTSTAT_HIBRS_Pos           (9UL)                     /*!< SCU_RESET RSTSTAT: HIBRS (Bit 9)                            */
#define SCU_RESET_RSTSTAT_HIBRS_Msk           (0x200UL)                 /*!< SCU_RESET RSTSTAT: HIBRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_RSTSTAT_LCKEN_Pos           (10UL)                    /*!< SCU_RESET RSTSTAT: LCKEN (Bit 10)                           */
#define SCU_RESET_RSTSTAT_LCKEN_Msk           (0x400UL)                 /*!< SCU_RESET RSTSTAT: LCKEN (Bitfield-Mask: 0x01)              */
#define SCU_RESET_RSTSTAT_ECAT0RS_Pos         (12UL)                    /*!< SCU_RESET RSTSTAT: ECAT0RS (Bit 12)                         */
#define SCU_RESET_RSTSTAT_ECAT0RS_Msk         (0x1000UL)                /*!< SCU_RESET RSTSTAT: ECAT0RS (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_RESET_RSTSET  ------------------------------ */
#define SCU_RESET_RSTSET_HIBWK_Pos            (8UL)                     /*!< SCU_RESET RSTSET: HIBWK (Bit 8)                             */
#define SCU_RESET_RSTSET_HIBWK_Msk            (0x100UL)                 /*!< SCU_RESET RSTSET: HIBWK (Bitfield-Mask: 0x01)               */
#define SCU_RESET_RSTSET_HIBRS_Pos            (9UL)                     /*!< SCU_RESET RSTSET: HIBRS (Bit 9)                             */
#define SCU_RESET_RSTSET_HIBRS_Msk            (0x200UL)                 /*!< SCU_RESET RSTSET: HIBRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_RSTSET_LCKEN_Pos            (10UL)                    /*!< SCU_RESET RSTSET: LCKEN (Bit 10)                            */
#define SCU_RESET_RSTSET_LCKEN_Msk            (0x400UL)                 /*!< SCU_RESET RSTSET: LCKEN (Bitfield-Mask: 0x01)               */
#define SCU_RESET_RSTSET_ECAT0RS_Pos          (12UL)                    /*!< SCU_RESET RSTSET: ECAT0RS (Bit 12)                          */
#define SCU_RESET_RSTSET_ECAT0RS_Msk          (0x1000UL)                /*!< SCU_RESET RSTSET: ECAT0RS (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_RESET_RSTCLR  ------------------------------ */
#define SCU_RESET_RSTCLR_RSCLR_Pos            (0UL)                     /*!< SCU_RESET RSTCLR: RSCLR (Bit 0)                             */
#define SCU_RESET_RSTCLR_RSCLR_Msk            (0x1UL)                   /*!< SCU_RESET RSTCLR: RSCLR (Bitfield-Mask: 0x01)               */
#define SCU_RESET_RSTCLR_HIBWK_Pos            (8UL)                     /*!< SCU_RESET RSTCLR: HIBWK (Bit 8)                             */
#define SCU_RESET_RSTCLR_HIBWK_Msk            (0x100UL)                 /*!< SCU_RESET RSTCLR: HIBWK (Bitfield-Mask: 0x01)               */
#define SCU_RESET_RSTCLR_HIBRS_Pos            (9UL)                     /*!< SCU_RESET RSTCLR: HIBRS (Bit 9)                             */
#define SCU_RESET_RSTCLR_HIBRS_Msk            (0x200UL)                 /*!< SCU_RESET RSTCLR: HIBRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_RSTCLR_LCKEN_Pos            (10UL)                    /*!< SCU_RESET RSTCLR: LCKEN (Bit 10)                            */
#define SCU_RESET_RSTCLR_LCKEN_Msk            (0x400UL)                 /*!< SCU_RESET RSTCLR: LCKEN (Bitfield-Mask: 0x01)               */
#define SCU_RESET_RSTCLR_ECAT0RS_Pos          (12UL)                    /*!< SCU_RESET RSTCLR: ECAT0RS (Bit 12)                          */
#define SCU_RESET_RSTCLR_ECAT0RS_Msk          (0x1000UL)                /*!< SCU_RESET RSTCLR: ECAT0RS (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_RESET_PRSTAT0  ----------------------------- */
#define SCU_RESET_PRSTAT0_VADCRS_Pos          (0UL)                     /*!< SCU_RESET PRSTAT0: VADCRS (Bit 0)                           */
#define SCU_RESET_PRSTAT0_VADCRS_Msk          (0x1UL)                   /*!< SCU_RESET PRSTAT0: VADCRS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSTAT0_DSDRS_Pos           (1UL)                     /*!< SCU_RESET PRSTAT0: DSDRS (Bit 1)                            */
#define SCU_RESET_PRSTAT0_DSDRS_Msk           (0x2UL)                   /*!< SCU_RESET PRSTAT0: DSDRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSTAT0_CCU40RS_Pos         (2UL)                     /*!< SCU_RESET PRSTAT0: CCU40RS (Bit 2)                          */
#define SCU_RESET_PRSTAT0_CCU40RS_Msk         (0x4UL)                   /*!< SCU_RESET PRSTAT0: CCU40RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT0_CCU41RS_Pos         (3UL)                     /*!< SCU_RESET PRSTAT0: CCU41RS (Bit 3)                          */
#define SCU_RESET_PRSTAT0_CCU41RS_Msk         (0x8UL)                   /*!< SCU_RESET PRSTAT0: CCU41RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT0_CCU42RS_Pos         (4UL)                     /*!< SCU_RESET PRSTAT0: CCU42RS (Bit 4)                          */
#define SCU_RESET_PRSTAT0_CCU42RS_Msk         (0x10UL)                  /*!< SCU_RESET PRSTAT0: CCU42RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT0_CCU80RS_Pos         (7UL)                     /*!< SCU_RESET PRSTAT0: CCU80RS (Bit 7)                          */
#define SCU_RESET_PRSTAT0_CCU80RS_Msk         (0x80UL)                  /*!< SCU_RESET PRSTAT0: CCU80RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT0_CCU81RS_Pos         (8UL)                     /*!< SCU_RESET PRSTAT0: CCU81RS (Bit 8)                          */
#define SCU_RESET_PRSTAT0_CCU81RS_Msk         (0x100UL)                 /*!< SCU_RESET PRSTAT0: CCU81RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT0_POSIF0RS_Pos        (9UL)                     /*!< SCU_RESET PRSTAT0: POSIF0RS (Bit 9)                         */
#define SCU_RESET_PRSTAT0_POSIF0RS_Msk        (0x200UL)                 /*!< SCU_RESET PRSTAT0: POSIF0RS (Bitfield-Mask: 0x01)           */
#define SCU_RESET_PRSTAT0_POSIF1RS_Pos        (10UL)                    /*!< SCU_RESET PRSTAT0: POSIF1RS (Bit 10)                        */
#define SCU_RESET_PRSTAT0_POSIF1RS_Msk        (0x400UL)                 /*!< SCU_RESET PRSTAT0: POSIF1RS (Bitfield-Mask: 0x01)           */
#define SCU_RESET_PRSTAT0_USIC0RS_Pos         (11UL)                    /*!< SCU_RESET PRSTAT0: USIC0RS (Bit 11)                         */
#define SCU_RESET_PRSTAT0_USIC0RS_Msk         (0x800UL)                 /*!< SCU_RESET PRSTAT0: USIC0RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT0_ERU1RS_Pos          (16UL)                    /*!< SCU_RESET PRSTAT0: ERU1RS (Bit 16)                          */
#define SCU_RESET_PRSTAT0_ERU1RS_Msk          (0x10000UL)               /*!< SCU_RESET PRSTAT0: ERU1RS (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_RESET_PRSET0  ------------------------------ */
#define SCU_RESET_PRSET0_VADCRS_Pos           (0UL)                     /*!< SCU_RESET PRSET0: VADCRS (Bit 0)                            */
#define SCU_RESET_PRSET0_VADCRS_Msk           (0x1UL)                   /*!< SCU_RESET PRSET0: VADCRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSET0_DSDRS_Pos            (1UL)                     /*!< SCU_RESET PRSET0: DSDRS (Bit 1)                             */
#define SCU_RESET_PRSET0_DSDRS_Msk            (0x2UL)                   /*!< SCU_RESET PRSET0: DSDRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRSET0_CCU40RS_Pos          (2UL)                     /*!< SCU_RESET PRSET0: CCU40RS (Bit 2)                           */
#define SCU_RESET_PRSET0_CCU40RS_Msk          (0x4UL)                   /*!< SCU_RESET PRSET0: CCU40RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET0_CCU41RS_Pos          (3UL)                     /*!< SCU_RESET PRSET0: CCU41RS (Bit 3)                           */
#define SCU_RESET_PRSET0_CCU41RS_Msk          (0x8UL)                   /*!< SCU_RESET PRSET0: CCU41RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET0_CCU42RS_Pos          (4UL)                     /*!< SCU_RESET PRSET0: CCU42RS (Bit 4)                           */
#define SCU_RESET_PRSET0_CCU42RS_Msk          (0x10UL)                  /*!< SCU_RESET PRSET0: CCU42RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET0_CCU80RS_Pos          (7UL)                     /*!< SCU_RESET PRSET0: CCU80RS (Bit 7)                           */
#define SCU_RESET_PRSET0_CCU80RS_Msk          (0x80UL)                  /*!< SCU_RESET PRSET0: CCU80RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET0_CCU81RS_Pos          (8UL)                     /*!< SCU_RESET PRSET0: CCU81RS (Bit 8)                           */
#define SCU_RESET_PRSET0_CCU81RS_Msk          (0x100UL)                 /*!< SCU_RESET PRSET0: CCU81RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET0_POSIF0RS_Pos         (9UL)                     /*!< SCU_RESET PRSET0: POSIF0RS (Bit 9)                          */
#define SCU_RESET_PRSET0_POSIF0RS_Msk         (0x200UL)                 /*!< SCU_RESET PRSET0: POSIF0RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSET0_POSIF1RS_Pos         (10UL)                    /*!< SCU_RESET PRSET0: POSIF1RS (Bit 10)                         */
#define SCU_RESET_PRSET0_POSIF1RS_Msk         (0x400UL)                 /*!< SCU_RESET PRSET0: POSIF1RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSET0_USIC0RS_Pos          (11UL)                    /*!< SCU_RESET PRSET0: USIC0RS (Bit 11)                          */
#define SCU_RESET_PRSET0_USIC0RS_Msk          (0x800UL)                 /*!< SCU_RESET PRSET0: USIC0RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET0_ERU1RS_Pos           (16UL)                    /*!< SCU_RESET PRSET0: ERU1RS (Bit 16)                           */
#define SCU_RESET_PRSET0_ERU1RS_Msk           (0x10000UL)               /*!< SCU_RESET PRSET0: ERU1RS (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_RESET_PRCLR0  ------------------------------ */
#define SCU_RESET_PRCLR0_VADCRS_Pos           (0UL)                     /*!< SCU_RESET PRCLR0: VADCRS (Bit 0)                            */
#define SCU_RESET_PRCLR0_VADCRS_Msk           (0x1UL)                   /*!< SCU_RESET PRCLR0: VADCRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRCLR0_DSDRS_Pos            (1UL)                     /*!< SCU_RESET PRCLR0: DSDRS (Bit 1)                             */
#define SCU_RESET_PRCLR0_DSDRS_Msk            (0x2UL)                   /*!< SCU_RESET PRCLR0: DSDRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRCLR0_CCU40RS_Pos          (2UL)                     /*!< SCU_RESET PRCLR0: CCU40RS (Bit 2)                           */
#define SCU_RESET_PRCLR0_CCU40RS_Msk          (0x4UL)                   /*!< SCU_RESET PRCLR0: CCU40RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR0_CCU41RS_Pos          (3UL)                     /*!< SCU_RESET PRCLR0: CCU41RS (Bit 3)                           */
#define SCU_RESET_PRCLR0_CCU41RS_Msk          (0x8UL)                   /*!< SCU_RESET PRCLR0: CCU41RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR0_CCU42RS_Pos          (4UL)                     /*!< SCU_RESET PRCLR0: CCU42RS (Bit 4)                           */
#define SCU_RESET_PRCLR0_CCU42RS_Msk          (0x10UL)                  /*!< SCU_RESET PRCLR0: CCU42RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR0_CCU80RS_Pos          (7UL)                     /*!< SCU_RESET PRCLR0: CCU80RS (Bit 7)                           */
#define SCU_RESET_PRCLR0_CCU80RS_Msk          (0x80UL)                  /*!< SCU_RESET PRCLR0: CCU80RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR0_CCU81RS_Pos          (8UL)                     /*!< SCU_RESET PRCLR0: CCU81RS (Bit 8)                           */
#define SCU_RESET_PRCLR0_CCU81RS_Msk          (0x100UL)                 /*!< SCU_RESET PRCLR0: CCU81RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR0_POSIF0RS_Pos         (9UL)                     /*!< SCU_RESET PRCLR0: POSIF0RS (Bit 9)                          */
#define SCU_RESET_PRCLR0_POSIF0RS_Msk         (0x200UL)                 /*!< SCU_RESET PRCLR0: POSIF0RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRCLR0_POSIF1RS_Pos         (10UL)                    /*!< SCU_RESET PRCLR0: POSIF1RS (Bit 10)                         */
#define SCU_RESET_PRCLR0_POSIF1RS_Msk         (0x400UL)                 /*!< SCU_RESET PRCLR0: POSIF1RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRCLR0_USIC0RS_Pos          (11UL)                    /*!< SCU_RESET PRCLR0: USIC0RS (Bit 11)                          */
#define SCU_RESET_PRCLR0_USIC0RS_Msk          (0x800UL)                 /*!< SCU_RESET PRCLR0: USIC0RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR0_ERU1RS_Pos           (16UL)                    /*!< SCU_RESET PRCLR0: ERU1RS (Bit 16)                           */
#define SCU_RESET_PRCLR0_ERU1RS_Msk           (0x10000UL)               /*!< SCU_RESET PRCLR0: ERU1RS (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_RESET_PRSTAT1  ----------------------------- */
#define SCU_RESET_PRSTAT1_CCU43RS_Pos         (0UL)                     /*!< SCU_RESET PRSTAT1: CCU43RS (Bit 0)                          */
#define SCU_RESET_PRSTAT1_CCU43RS_Msk         (0x1UL)                   /*!< SCU_RESET PRSTAT1: CCU43RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT1_LEDTSCU0RS_Pos      (3UL)                     /*!< SCU_RESET PRSTAT1: LEDTSCU0RS (Bit 3)                       */
#define SCU_RESET_PRSTAT1_LEDTSCU0RS_Msk      (0x8UL)                   /*!< SCU_RESET PRSTAT1: LEDTSCU0RS (Bitfield-Mask: 0x01)         */
#define SCU_RESET_PRSTAT1_MCAN0RS_Pos         (4UL)                     /*!< SCU_RESET PRSTAT1: MCAN0RS (Bit 4)                          */
#define SCU_RESET_PRSTAT1_MCAN0RS_Msk         (0x10UL)                  /*!< SCU_RESET PRSTAT1: MCAN0RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT1_DACRS_Pos           (5UL)                     /*!< SCU_RESET PRSTAT1: DACRS (Bit 5)                            */
#define SCU_RESET_PRSTAT1_DACRS_Msk           (0x20UL)                  /*!< SCU_RESET PRSTAT1: DACRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSTAT1_MMCIRS_Pos          (6UL)                     /*!< SCU_RESET PRSTAT1: MMCIRS (Bit 6)                           */
#define SCU_RESET_PRSTAT1_MMCIRS_Msk          (0x40UL)                  /*!< SCU_RESET PRSTAT1: MMCIRS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSTAT1_USIC1RS_Pos         (7UL)                     /*!< SCU_RESET PRSTAT1: USIC1RS (Bit 7)                          */
#define SCU_RESET_PRSTAT1_USIC1RS_Msk         (0x80UL)                  /*!< SCU_RESET PRSTAT1: USIC1RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT1_USIC2RS_Pos         (8UL)                     /*!< SCU_RESET PRSTAT1: USIC2RS (Bit 8)                          */
#define SCU_RESET_PRSTAT1_USIC2RS_Msk         (0x100UL)                 /*!< SCU_RESET PRSTAT1: USIC2RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT1_PPORTSRS_Pos        (9UL)                     /*!< SCU_RESET PRSTAT1: PPORTSRS (Bit 9)                         */
#define SCU_RESET_PRSTAT1_PPORTSRS_Msk        (0x200UL)                 /*!< SCU_RESET PRSTAT1: PPORTSRS (Bitfield-Mask: 0x01)           */

/* ------------------------------  SCU_RESET_PRSET1  ------------------------------ */
#define SCU_RESET_PRSET1_CCU43RS_Pos          (0UL)                     /*!< SCU_RESET PRSET1: CCU43RS (Bit 0)                           */
#define SCU_RESET_PRSET1_CCU43RS_Msk          (0x1UL)                   /*!< SCU_RESET PRSET1: CCU43RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET1_LEDTSCU0RS_Pos       (3UL)                     /*!< SCU_RESET PRSET1: LEDTSCU0RS (Bit 3)                        */
#define SCU_RESET_PRSET1_LEDTSCU0RS_Msk       (0x8UL)                   /*!< SCU_RESET PRSET1: LEDTSCU0RS (Bitfield-Mask: 0x01)          */
#define SCU_RESET_PRSET1_MCAN0RS_Pos          (4UL)                     /*!< SCU_RESET PRSET1: MCAN0RS (Bit 4)                           */
#define SCU_RESET_PRSET1_MCAN0RS_Msk          (0x10UL)                  /*!< SCU_RESET PRSET1: MCAN0RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET1_DACRS_Pos            (5UL)                     /*!< SCU_RESET PRSET1: DACRS (Bit 5)                             */
#define SCU_RESET_PRSET1_DACRS_Msk            (0x20UL)                  /*!< SCU_RESET PRSET1: DACRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRSET1_MMCIRS_Pos           (6UL)                     /*!< SCU_RESET PRSET1: MMCIRS (Bit 6)                            */
#define SCU_RESET_PRSET1_MMCIRS_Msk           (0x40UL)                  /*!< SCU_RESET PRSET1: MMCIRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSET1_USIC1RS_Pos          (7UL)                     /*!< SCU_RESET PRSET1: USIC1RS (Bit 7)                           */
#define SCU_RESET_PRSET1_USIC1RS_Msk          (0x80UL)                  /*!< SCU_RESET PRSET1: USIC1RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET1_USIC2RS_Pos          (8UL)                     /*!< SCU_RESET PRSET1: USIC2RS (Bit 8)                           */
#define SCU_RESET_PRSET1_USIC2RS_Msk          (0x100UL)                 /*!< SCU_RESET PRSET1: USIC2RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET1_PPORTSRS_Pos         (9UL)                     /*!< SCU_RESET PRSET1: PPORTSRS (Bit 9)                          */
#define SCU_RESET_PRSET1_PPORTSRS_Msk         (0x200UL)                 /*!< SCU_RESET PRSET1: PPORTSRS (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_RESET_PRCLR1  ------------------------------ */
#define SCU_RESET_PRCLR1_CCU43RS_Pos          (0UL)                     /*!< SCU_RESET PRCLR1: CCU43RS (Bit 0)                           */
#define SCU_RESET_PRCLR1_CCU43RS_Msk          (0x1UL)                   /*!< SCU_RESET PRCLR1: CCU43RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR1_LEDTSCU0RS_Pos       (3UL)                     /*!< SCU_RESET PRCLR1: LEDTSCU0RS (Bit 3)                        */
#define SCU_RESET_PRCLR1_LEDTSCU0RS_Msk       (0x8UL)                   /*!< SCU_RESET PRCLR1: LEDTSCU0RS (Bitfield-Mask: 0x01)          */
#define SCU_RESET_PRCLR1_MCAN0RS_Pos          (4UL)                     /*!< SCU_RESET PRCLR1: MCAN0RS (Bit 4)                           */
#define SCU_RESET_PRCLR1_MCAN0RS_Msk          (0x10UL)                  /*!< SCU_RESET PRCLR1: MCAN0RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR1_DACRS_Pos            (5UL)                     /*!< SCU_RESET PRCLR1: DACRS (Bit 5)                             */
#define SCU_RESET_PRCLR1_DACRS_Msk            (0x20UL)                  /*!< SCU_RESET PRCLR1: DACRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRCLR1_MMCIRS_Pos           (6UL)                     /*!< SCU_RESET PRCLR1: MMCIRS (Bit 6)                            */
#define SCU_RESET_PRCLR1_MMCIRS_Msk           (0x40UL)                  /*!< SCU_RESET PRCLR1: MMCIRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRCLR1_USIC1RS_Pos          (7UL)                     /*!< SCU_RESET PRCLR1: USIC1RS (Bit 7)                           */
#define SCU_RESET_PRCLR1_USIC1RS_Msk          (0x80UL)                  /*!< SCU_RESET PRCLR1: USIC1RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR1_USIC2RS_Pos          (8UL)                     /*!< SCU_RESET PRCLR1: USIC2RS (Bit 8)                           */
#define SCU_RESET_PRCLR1_USIC2RS_Msk          (0x100UL)                 /*!< SCU_RESET PRCLR1: USIC2RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR1_PPORTSRS_Pos         (9UL)                     /*!< SCU_RESET PRCLR1: PPORTSRS (Bit 9)                          */
#define SCU_RESET_PRCLR1_PPORTSRS_Msk         (0x200UL)                 /*!< SCU_RESET PRCLR1: PPORTSRS (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_RESET_PRSTAT2  ----------------------------- */
#define SCU_RESET_PRSTAT2_WDTRS_Pos           (1UL)                     /*!< SCU_RESET PRSTAT2: WDTRS (Bit 1)                            */
#define SCU_RESET_PRSTAT2_WDTRS_Msk           (0x2UL)                   /*!< SCU_RESET PRSTAT2: WDTRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSTAT2_ETH0RS_Pos          (2UL)                     /*!< SCU_RESET PRSTAT2: ETH0RS (Bit 2)                           */
#define SCU_RESET_PRSTAT2_ETH0RS_Msk          (0x4UL)                   /*!< SCU_RESET PRSTAT2: ETH0RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSTAT2_DMA0RS_Pos          (4UL)                     /*!< SCU_RESET PRSTAT2: DMA0RS (Bit 4)                           */
#define SCU_RESET_PRSTAT2_DMA0RS_Msk          (0x10UL)                  /*!< SCU_RESET PRSTAT2: DMA0RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSTAT2_DMA1RS_Pos          (5UL)                     /*!< SCU_RESET PRSTAT2: DMA1RS (Bit 5)                           */
#define SCU_RESET_PRSTAT2_DMA1RS_Msk          (0x20UL)                  /*!< SCU_RESET PRSTAT2: DMA1RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSTAT2_FCERS_Pos           (6UL)                     /*!< SCU_RESET PRSTAT2: FCERS (Bit 6)                            */
#define SCU_RESET_PRSTAT2_FCERS_Msk           (0x40UL)                  /*!< SCU_RESET PRSTAT2: FCERS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSTAT2_USBRS_Pos           (7UL)                     /*!< SCU_RESET PRSTAT2: USBRS (Bit 7)                            */
#define SCU_RESET_PRSTAT2_USBRS_Msk           (0x80UL)                  /*!< SCU_RESET PRSTAT2: USBRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSTAT2_ECAT0RS_Pos         (10UL)                    /*!< SCU_RESET PRSTAT2: ECAT0RS (Bit 10)                         */
#define SCU_RESET_PRSTAT2_ECAT0RS_Msk         (0x400UL)                 /*!< SCU_RESET PRSTAT2: ECAT0RS (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_RESET_PRSET2  ------------------------------ */
#define SCU_RESET_PRSET2_WDTRS_Pos            (1UL)                     /*!< SCU_RESET PRSET2: WDTRS (Bit 1)                             */
#define SCU_RESET_PRSET2_WDTRS_Msk            (0x2UL)                   /*!< SCU_RESET PRSET2: WDTRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRSET2_ETH0RS_Pos           (2UL)                     /*!< SCU_RESET PRSET2: ETH0RS (Bit 2)                            */
#define SCU_RESET_PRSET2_ETH0RS_Msk           (0x4UL)                   /*!< SCU_RESET PRSET2: ETH0RS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSET2_DMA0RS_Pos           (4UL)                     /*!< SCU_RESET PRSET2: DMA0RS (Bit 4)                            */
#define SCU_RESET_PRSET2_DMA0RS_Msk           (0x10UL)                  /*!< SCU_RESET PRSET2: DMA0RS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSET2_DMA1RS_Pos           (5UL)                     /*!< SCU_RESET PRSET2: DMA1RS (Bit 5)                            */
#define SCU_RESET_PRSET2_DMA1RS_Msk           (0x20UL)                  /*!< SCU_RESET PRSET2: DMA1RS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSET2_FCERS_Pos            (6UL)                     /*!< SCU_RESET PRSET2: FCERS (Bit 6)                             */
#define SCU_RESET_PRSET2_FCERS_Msk            (0x40UL)                  /*!< SCU_RESET PRSET2: FCERS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRSET2_USBRS_Pos            (7UL)                     /*!< SCU_RESET PRSET2: USBRS (Bit 7)                             */
#define SCU_RESET_PRSET2_USBRS_Msk            (0x80UL)                  /*!< SCU_RESET PRSET2: USBRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRSET2_ECAT0RS_Pos          (10UL)                    /*!< SCU_RESET PRSET2: ECAT0RS (Bit 10)                          */
#define SCU_RESET_PRSET2_ECAT0RS_Msk          (0x400UL)                 /*!< SCU_RESET PRSET2: ECAT0RS (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_RESET_PRCLR2  ------------------------------ */
#define SCU_RESET_PRCLR2_WDTRS_Pos            (1UL)                     /*!< SCU_RESET PRCLR2: WDTRS (Bit 1)                             */
#define SCU_RESET_PRCLR2_WDTRS_Msk            (0x2UL)                   /*!< SCU_RESET PRCLR2: WDTRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRCLR2_ETH0RS_Pos           (2UL)                     /*!< SCU_RESET PRCLR2: ETH0RS (Bit 2)                            */
#define SCU_RESET_PRCLR2_ETH0RS_Msk           (0x4UL)                   /*!< SCU_RESET PRCLR2: ETH0RS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRCLR2_DMA0RS_Pos           (4UL)                     /*!< SCU_RESET PRCLR2: DMA0RS (Bit 4)                            */
#define SCU_RESET_PRCLR2_DMA0RS_Msk           (0x10UL)                  /*!< SCU_RESET PRCLR2: DMA0RS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRCLR2_DMA1RS_Pos           (5UL)                     /*!< SCU_RESET PRCLR2: DMA1RS (Bit 5)                            */
#define SCU_RESET_PRCLR2_DMA1RS_Msk           (0x20UL)                  /*!< SCU_RESET PRCLR2: DMA1RS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRCLR2_FCERS_Pos            (6UL)                     /*!< SCU_RESET PRCLR2: FCERS (Bit 6)                             */
#define SCU_RESET_PRCLR2_FCERS_Msk            (0x40UL)                  /*!< SCU_RESET PRCLR2: FCERS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRCLR2_USBRS_Pos            (7UL)                     /*!< SCU_RESET PRCLR2: USBRS (Bit 7)                             */
#define SCU_RESET_PRCLR2_USBRS_Msk            (0x80UL)                  /*!< SCU_RESET PRCLR2: USBRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRCLR2_ECAT0RS_Pos          (10UL)                    /*!< SCU_RESET PRCLR2: ECAT0RS (Bit 10)                          */
#define SCU_RESET_PRCLR2_ECAT0RS_Msk          (0x400UL)                 /*!< SCU_RESET PRCLR2: ECAT0RS (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_RESET_PRSTAT3  ----------------------------- */
#define SCU_RESET_PRSTAT3_EBURS_Pos           (2UL)                     /*!< SCU_RESET PRSTAT3: EBURS (Bit 2)                            */
#define SCU_RESET_PRSTAT3_EBURS_Msk           (0x4UL)                   /*!< SCU_RESET PRSTAT3: EBURS (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_RESET_PRSET3  ------------------------------ */
#define SCU_RESET_PRSET3_EBURS_Pos            (2UL)                     /*!< SCU_RESET PRSET3: EBURS (Bit 2)                             */
#define SCU_RESET_PRSET3_EBURS_Msk            (0x4UL)                   /*!< SCU_RESET PRSET3: EBURS (Bitfield-Mask: 0x01)               */

/* ------------------------------  SCU_RESET_PRCLR3  ------------------------------ */
#define SCU_RESET_PRCLR3_EBURS_Pos            (2UL)                     /*!< SCU_RESET PRCLR3: EBURS (Bit 2)                             */
#define SCU_RESET_PRCLR3_EBURS_Msk            (0x4UL)                   /*!< SCU_RESET PRCLR3: EBURS (Bitfield-Mask: 0x01)               */


/* ================================================================================ */
/* ================          Group 'LEDTS' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  LEDTS_ID  ---------------------------------- */
#define LEDTS_ID_MOD_REV_Pos                  (0UL)                     /*!< LEDTS ID: MOD_REV (Bit 0)                                   */
#define LEDTS_ID_MOD_REV_Msk                  (0xffUL)                  /*!< LEDTS ID: MOD_REV (Bitfield-Mask: 0xff)                     */
#define LEDTS_ID_MOD_TYPE_Pos                 (8UL)                     /*!< LEDTS ID: MOD_TYPE (Bit 8)                                  */
#define LEDTS_ID_MOD_TYPE_Msk                 (0xff00UL)                /*!< LEDTS ID: MOD_TYPE (Bitfield-Mask: 0xff)                    */
#define LEDTS_ID_MOD_NUMBER_Pos               (16UL)                    /*!< LEDTS ID: MOD_NUMBER (Bit 16)                               */
#define LEDTS_ID_MOD_NUMBER_Msk               (0xffff0000UL)            /*!< LEDTS ID: MOD_NUMBER (Bitfield-Mask: 0xffff)                */

/* --------------------------------  LEDTS_GLOBCTL  ------------------------------- */
#define LEDTS_GLOBCTL_TS_EN_Pos               (0UL)                     /*!< LEDTS GLOBCTL: TS_EN (Bit 0)                                */
#define LEDTS_GLOBCTL_TS_EN_Msk               (0x1UL)                   /*!< LEDTS GLOBCTL: TS_EN (Bitfield-Mask: 0x01)                  */
#define LEDTS_GLOBCTL_LD_EN_Pos               (1UL)                     /*!< LEDTS GLOBCTL: LD_EN (Bit 1)                                */
#define LEDTS_GLOBCTL_LD_EN_Msk               (0x2UL)                   /*!< LEDTS GLOBCTL: LD_EN (Bitfield-Mask: 0x01)                  */
#define LEDTS_GLOBCTL_CMTR_Pos                (2UL)                     /*!< LEDTS GLOBCTL: CMTR (Bit 2)                                 */
#define LEDTS_GLOBCTL_CMTR_Msk                (0x4UL)                   /*!< LEDTS GLOBCTL: CMTR (Bitfield-Mask: 0x01)                   */
#define LEDTS_GLOBCTL_ENSYNC_Pos              (3UL)                     /*!< LEDTS GLOBCTL: ENSYNC (Bit 3)                               */
#define LEDTS_GLOBCTL_ENSYNC_Msk              (0x8UL)                   /*!< LEDTS GLOBCTL: ENSYNC (Bitfield-Mask: 0x01)                 */
#define LEDTS_GLOBCTL_SUSCFG_Pos              (8UL)                     /*!< LEDTS GLOBCTL: SUSCFG (Bit 8)                               */
#define LEDTS_GLOBCTL_SUSCFG_Msk              (0x100UL)                 /*!< LEDTS GLOBCTL: SUSCFG (Bitfield-Mask: 0x01)                 */
#define LEDTS_GLOBCTL_MASKVAL_Pos             (9UL)                     /*!< LEDTS GLOBCTL: MASKVAL (Bit 9)                              */
#define LEDTS_GLOBCTL_MASKVAL_Msk             (0xe00UL)                 /*!< LEDTS GLOBCTL: MASKVAL (Bitfield-Mask: 0x07)                */
#define LEDTS_GLOBCTL_FENVAL_Pos              (12UL)                    /*!< LEDTS GLOBCTL: FENVAL (Bit 12)                              */
#define LEDTS_GLOBCTL_FENVAL_Msk              (0x1000UL)                /*!< LEDTS GLOBCTL: FENVAL (Bitfield-Mask: 0x01)                 */
#define LEDTS_GLOBCTL_ITS_EN_Pos              (13UL)                    /*!< LEDTS GLOBCTL: ITS_EN (Bit 13)                              */
#define LEDTS_GLOBCTL_ITS_EN_Msk              (0x2000UL)                /*!< LEDTS GLOBCTL: ITS_EN (Bitfield-Mask: 0x01)                 */
#define LEDTS_GLOBCTL_ITF_EN_Pos              (14UL)                    /*!< LEDTS GLOBCTL: ITF_EN (Bit 14)                              */
#define LEDTS_GLOBCTL_ITF_EN_Msk              (0x4000UL)                /*!< LEDTS GLOBCTL: ITF_EN (Bitfield-Mask: 0x01)                 */
#define LEDTS_GLOBCTL_ITP_EN_Pos              (15UL)                    /*!< LEDTS GLOBCTL: ITP_EN (Bit 15)                              */
#define LEDTS_GLOBCTL_ITP_EN_Msk              (0x8000UL)                /*!< LEDTS GLOBCTL: ITP_EN (Bitfield-Mask: 0x01)                 */
#define LEDTS_GLOBCTL_CLK_PS_Pos              (16UL)                    /*!< LEDTS GLOBCTL: CLK_PS (Bit 16)                              */
#define LEDTS_GLOBCTL_CLK_PS_Msk              (0xffff0000UL)            /*!< LEDTS GLOBCTL: CLK_PS (Bitfield-Mask: 0xffff)               */

/* ---------------------------------  LEDTS_FNCTL  -------------------------------- */
#define LEDTS_FNCTL_PADT_Pos                  (0UL)                     /*!< LEDTS FNCTL: PADT (Bit 0)                                   */
#define LEDTS_FNCTL_PADT_Msk                  (0x7UL)                   /*!< LEDTS FNCTL: PADT (Bitfield-Mask: 0x07)                     */
#define LEDTS_FNCTL_PADTSW_Pos                (3UL)                     /*!< LEDTS FNCTL: PADTSW (Bit 3)                                 */
#define LEDTS_FNCTL_PADTSW_Msk                (0x8UL)                   /*!< LEDTS FNCTL: PADTSW (Bitfield-Mask: 0x01)                   */
#define LEDTS_FNCTL_EPULL_Pos                 (4UL)                     /*!< LEDTS FNCTL: EPULL (Bit 4)                                  */
#define LEDTS_FNCTL_EPULL_Msk                 (0x10UL)                  /*!< LEDTS FNCTL: EPULL (Bitfield-Mask: 0x01)                    */
#define LEDTS_FNCTL_FNCOL_Pos                 (5UL)                     /*!< LEDTS FNCTL: FNCOL (Bit 5)                                  */
#define LEDTS_FNCTL_FNCOL_Msk                 (0xe0UL)                  /*!< LEDTS FNCTL: FNCOL (Bitfield-Mask: 0x07)                    */
#define LEDTS_FNCTL_ACCCNT_Pos                (16UL)                    /*!< LEDTS FNCTL: ACCCNT (Bit 16)                                */
#define LEDTS_FNCTL_ACCCNT_Msk                (0xf0000UL)               /*!< LEDTS FNCTL: ACCCNT (Bitfield-Mask: 0x0f)                   */
#define LEDTS_FNCTL_TSCCMP_Pos                (20UL)                    /*!< LEDTS FNCTL: TSCCMP (Bit 20)                                */
#define LEDTS_FNCTL_TSCCMP_Msk                (0x100000UL)              /*!< LEDTS FNCTL: TSCCMP (Bitfield-Mask: 0x01)                   */
#define LEDTS_FNCTL_TSOEXT_Pos                (21UL)                    /*!< LEDTS FNCTL: TSOEXT (Bit 21)                                */
#define LEDTS_FNCTL_TSOEXT_Msk                (0x600000UL)              /*!< LEDTS FNCTL: TSOEXT (Bitfield-Mask: 0x03)                   */
#define LEDTS_FNCTL_TSCTRR_Pos                (23UL)                    /*!< LEDTS FNCTL: TSCTRR (Bit 23)                                */
#define LEDTS_FNCTL_TSCTRR_Msk                (0x800000UL)              /*!< LEDTS FNCTL: TSCTRR (Bitfield-Mask: 0x01)                   */
#define LEDTS_FNCTL_TSCTRSAT_Pos              (24UL)                    /*!< LEDTS FNCTL: TSCTRSAT (Bit 24)                              */
#define LEDTS_FNCTL_TSCTRSAT_Msk              (0x1000000UL)             /*!< LEDTS FNCTL: TSCTRSAT (Bitfield-Mask: 0x01)                 */
#define LEDTS_FNCTL_NR_TSIN_Pos               (25UL)                    /*!< LEDTS FNCTL: NR_TSIN (Bit 25)                               */
#define LEDTS_FNCTL_NR_TSIN_Msk               (0xe000000UL)             /*!< LEDTS FNCTL: NR_TSIN (Bitfield-Mask: 0x07)                  */
#define LEDTS_FNCTL_COLLEV_Pos                (28UL)                    /*!< LEDTS FNCTL: COLLEV (Bit 28)                                */
#define LEDTS_FNCTL_COLLEV_Msk                (0x10000000UL)            /*!< LEDTS FNCTL: COLLEV (Bitfield-Mask: 0x01)                   */
#define LEDTS_FNCTL_NR_LEDCOL_Pos             (29UL)                    /*!< LEDTS FNCTL: NR_LEDCOL (Bit 29)                             */
#define LEDTS_FNCTL_NR_LEDCOL_Msk             (0xe0000000UL)            /*!< LEDTS FNCTL: NR_LEDCOL (Bitfield-Mask: 0x07)                */

/* ---------------------------------  LEDTS_EVFR  --------------------------------- */
#define LEDTS_EVFR_TSF_Pos                    (0UL)                     /*!< LEDTS EVFR: TSF (Bit 0)                                     */
#define LEDTS_EVFR_TSF_Msk                    (0x1UL)                   /*!< LEDTS EVFR: TSF (Bitfield-Mask: 0x01)                       */
#define LEDTS_EVFR_TFF_Pos                    (1UL)                     /*!< LEDTS EVFR: TFF (Bit 1)                                     */
#define LEDTS_EVFR_TFF_Msk                    (0x2UL)                   /*!< LEDTS EVFR: TFF (Bitfield-Mask: 0x01)                       */
#define LEDTS_EVFR_TPF_Pos                    (2UL)                     /*!< LEDTS EVFR: TPF (Bit 2)                                     */
#define LEDTS_EVFR_TPF_Msk                    (0x4UL)                   /*!< LEDTS EVFR: TPF (Bitfield-Mask: 0x01)                       */
#define LEDTS_EVFR_TSCTROVF_Pos               (3UL)                     /*!< LEDTS EVFR: TSCTROVF (Bit 3)                                */
#define LEDTS_EVFR_TSCTROVF_Msk               (0x8UL)                   /*!< LEDTS EVFR: TSCTROVF (Bitfield-Mask: 0x01)                  */
#define LEDTS_EVFR_CTSF_Pos                   (16UL)                    /*!< LEDTS EVFR: CTSF (Bit 16)                                   */
#define LEDTS_EVFR_CTSF_Msk                   (0x10000UL)               /*!< LEDTS EVFR: CTSF (Bitfield-Mask: 0x01)                      */
#define LEDTS_EVFR_CTFF_Pos                   (17UL)                    /*!< LEDTS EVFR: CTFF (Bit 17)                                   */
#define LEDTS_EVFR_CTFF_Msk                   (0x20000UL)               /*!< LEDTS EVFR: CTFF (Bitfield-Mask: 0x01)                      */
#define LEDTS_EVFR_CTPF_Pos                   (18UL)                    /*!< LEDTS EVFR: CTPF (Bit 18)                                   */
#define LEDTS_EVFR_CTPF_Msk                   (0x40000UL)               /*!< LEDTS EVFR: CTPF (Bitfield-Mask: 0x01)                      */

/* ---------------------------------  LEDTS_TSVAL  -------------------------------- */
#define LEDTS_TSVAL_TSCTRVALR_Pos             (0UL)                     /*!< LEDTS TSVAL: TSCTRVALR (Bit 0)                              */
#define LEDTS_TSVAL_TSCTRVALR_Msk             (0xffffUL)                /*!< LEDTS TSVAL: TSCTRVALR (Bitfield-Mask: 0xffff)              */
#define LEDTS_TSVAL_TSCTRVAL_Pos              (16UL)                    /*!< LEDTS TSVAL: TSCTRVAL (Bit 16)                              */
#define LEDTS_TSVAL_TSCTRVAL_Msk              (0xffff0000UL)            /*!< LEDTS TSVAL: TSCTRVAL (Bitfield-Mask: 0xffff)               */

/* ---------------------------------  LEDTS_LINE0  -------------------------------- */
#define LEDTS_LINE0_LINE_0_Pos                (0UL)                     /*!< LEDTS LINE0: LINE_0 (Bit 0)                                 */
#define LEDTS_LINE0_LINE_0_Msk                (0xffUL)                  /*!< LEDTS LINE0: LINE_0 (Bitfield-Mask: 0xff)                   */
#define LEDTS_LINE0_LINE_1_Pos                (8UL)                     /*!< LEDTS LINE0: LINE_1 (Bit 8)                                 */
#define LEDTS_LINE0_LINE_1_Msk                (0xff00UL)                /*!< LEDTS LINE0: LINE_1 (Bitfield-Mask: 0xff)                   */
#define LEDTS_LINE0_LINE_2_Pos                (16UL)                    /*!< LEDTS LINE0: LINE_2 (Bit 16)                                */
#define LEDTS_LINE0_LINE_2_Msk                (0xff0000UL)              /*!< LEDTS LINE0: LINE_2 (Bitfield-Mask: 0xff)                   */
#define LEDTS_LINE0_LINE_3_Pos                (24UL)                    /*!< LEDTS LINE0: LINE_3 (Bit 24)                                */
#define LEDTS_LINE0_LINE_3_Msk                (0xff000000UL)            /*!< LEDTS LINE0: LINE_3 (Bitfield-Mask: 0xff)                   */

/* ---------------------------------  LEDTS_LINE1  -------------------------------- */
#define LEDTS_LINE1_LINE_4_Pos                (0UL)                     /*!< LEDTS LINE1: LINE_4 (Bit 0)                                 */
#define LEDTS_LINE1_LINE_4_Msk                (0xffUL)                  /*!< LEDTS LINE1: LINE_4 (Bitfield-Mask: 0xff)                   */
#define LEDTS_LINE1_LINE_5_Pos                (8UL)                     /*!< LEDTS LINE1: LINE_5 (Bit 8)                                 */
#define LEDTS_LINE1_LINE_5_Msk                (0xff00UL)                /*!< LEDTS LINE1: LINE_5 (Bitfield-Mask: 0xff)                   */
#define LEDTS_LINE1_LINE_6_Pos                (16UL)                    /*!< LEDTS LINE1: LINE_6 (Bit 16)                                */
#define LEDTS_LINE1_LINE_6_Msk                (0xff0000UL)              /*!< LEDTS LINE1: LINE_6 (Bitfield-Mask: 0xff)                   */
#define LEDTS_LINE1_LINE_A_Pos                (24UL)                    /*!< LEDTS LINE1: LINE_A (Bit 24)                                */
#define LEDTS_LINE1_LINE_A_Msk                (0xff000000UL)            /*!< LEDTS LINE1: LINE_A (Bitfield-Mask: 0xff)                   */

/* --------------------------------  LEDTS_LDCMP0  -------------------------------- */
#define LEDTS_LDCMP0_CMP_LD0_Pos              (0UL)                     /*!< LEDTS LDCMP0: CMP_LD0 (Bit 0)                               */
#define LEDTS_LDCMP0_CMP_LD0_Msk              (0xffUL)                  /*!< LEDTS LDCMP0: CMP_LD0 (Bitfield-Mask: 0xff)                 */
#define LEDTS_LDCMP0_CMP_LD1_Pos              (8UL)                     /*!< LEDTS LDCMP0: CMP_LD1 (Bit 8)                               */
#define LEDTS_LDCMP0_CMP_LD1_Msk              (0xff00UL)                /*!< LEDTS LDCMP0: CMP_LD1 (Bitfield-Mask: 0xff)                 */
#define LEDTS_LDCMP0_CMP_LD2_Pos              (16UL)                    /*!< LEDTS LDCMP0: CMP_LD2 (Bit 16)                              */
#define LEDTS_LDCMP0_CMP_LD2_Msk              (0xff0000UL)              /*!< LEDTS LDCMP0: CMP_LD2 (Bitfield-Mask: 0xff)                 */
#define LEDTS_LDCMP0_CMP_LD3_Pos              (24UL)                    /*!< LEDTS LDCMP0: CMP_LD3 (Bit 24)                              */
#define LEDTS_LDCMP0_CMP_LD3_Msk              (0xff000000UL)            /*!< LEDTS LDCMP0: CMP_LD3 (Bitfield-Mask: 0xff)                 */

/* --------------------------------  LEDTS_LDCMP1  -------------------------------- */
#define LEDTS_LDCMP1_CMP_LD4_Pos              (0UL)                     /*!< LEDTS LDCMP1: CMP_LD4 (Bit 0)                               */
#define LEDTS_LDCMP1_CMP_LD4_Msk              (0xffUL)                  /*!< LEDTS LDCMP1: CMP_LD4 (Bitfield-Mask: 0xff)                 */
#define LEDTS_LDCMP1_CMP_LD5_Pos              (8UL)                     /*!< LEDTS LDCMP1: CMP_LD5 (Bit 8)                               */
#define LEDTS_LDCMP1_CMP_LD5_Msk              (0xff00UL)                /*!< LEDTS LDCMP1: CMP_LD5 (Bitfield-Mask: 0xff)                 */
#define LEDTS_LDCMP1_CMP_LD6_Pos              (16UL)                    /*!< LEDTS LDCMP1: CMP_LD6 (Bit 16)                              */
#define LEDTS_LDCMP1_CMP_LD6_Msk              (0xff0000UL)              /*!< LEDTS LDCMP1: CMP_LD6 (Bitfield-Mask: 0xff)                 */
#define LEDTS_LDCMP1_CMP_LDA_TSCOM_Pos        (24UL)                    /*!< LEDTS LDCMP1: CMP_LDA_TSCOM (Bit 24)                        */
#define LEDTS_LDCMP1_CMP_LDA_TSCOM_Msk        (0xff000000UL)            /*!< LEDTS LDCMP1: CMP_LDA_TSCOM (Bitfield-Mask: 0xff)           */

/* --------------------------------  LEDTS_TSCMP0  -------------------------------- */
#define LEDTS_TSCMP0_CMP_TS0_Pos              (0UL)                     /*!< LEDTS TSCMP0: CMP_TS0 (Bit 0)                               */
#define LEDTS_TSCMP0_CMP_TS0_Msk              (0xffUL)                  /*!< LEDTS TSCMP0: CMP_TS0 (Bitfield-Mask: 0xff)                 */
#define LEDTS_TSCMP0_CMP_TS1_Pos              (8UL)                     /*!< LEDTS TSCMP0: CMP_TS1 (Bit 8)                               */
#define LEDTS_TSCMP0_CMP_TS1_Msk              (0xff00UL)                /*!< LEDTS TSCMP0: CMP_TS1 (Bitfield-Mask: 0xff)                 */
#define LEDTS_TSCMP0_CMP_TS2_Pos              (16UL)                    /*!< LEDTS TSCMP0: CMP_TS2 (Bit 16)                              */
#define LEDTS_TSCMP0_CMP_TS2_Msk              (0xff0000UL)              /*!< LEDTS TSCMP0: CMP_TS2 (Bitfield-Mask: 0xff)                 */
#define LEDTS_TSCMP0_CMP_TS3_Pos              (24UL)                    /*!< LEDTS TSCMP0: CMP_TS3 (Bit 24)                              */
#define LEDTS_TSCMP0_CMP_TS3_Msk              (0xff000000UL)            /*!< LEDTS TSCMP0: CMP_TS3 (Bitfield-Mask: 0xff)                 */

/* --------------------------------  LEDTS_TSCMP1  -------------------------------- */
#define LEDTS_TSCMP1_CMP_TS4_Pos              (0UL)                     /*!< LEDTS TSCMP1: CMP_TS4 (Bit 0)                               */
#define LEDTS_TSCMP1_CMP_TS4_Msk              (0xffUL)                  /*!< LEDTS TSCMP1: CMP_TS4 (Bitfield-Mask: 0xff)                 */
#define LEDTS_TSCMP1_CMP_TS5_Pos              (8UL)                     /*!< LEDTS TSCMP1: CMP_TS5 (Bit 8)                               */
#define LEDTS_TSCMP1_CMP_TS5_Msk              (0xff00UL)                /*!< LEDTS TSCMP1: CMP_TS5 (Bitfield-Mask: 0xff)                 */
#define LEDTS_TSCMP1_CMP_TS6_Pos              (16UL)                    /*!< LEDTS TSCMP1: CMP_TS6 (Bit 16)                              */
#define LEDTS_TSCMP1_CMP_TS6_Msk              (0xff0000UL)              /*!< LEDTS TSCMP1: CMP_TS6 (Bitfield-Mask: 0xff)                 */
#define LEDTS_TSCMP1_CMP_TS7_Pos              (24UL)                    /*!< LEDTS TSCMP1: CMP_TS7 (Bit 24)                              */
#define LEDTS_TSCMP1_CMP_TS7_Msk              (0xff000000UL)            /*!< LEDTS TSCMP1: CMP_TS7 (Bitfield-Mask: 0xff)                 */


/* ================================================================================ */
/* ================         struct 'SDMMC' Position & Mask         ================ */
/* ================================================================================ */


/* ------------------------------  SDMMC_BLOCK_SIZE  ------------------------------ */
#define SDMMC_BLOCK_SIZE_TX_BLOCK_SIZE_Pos    (0UL)                     /*!< SDMMC BLOCK_SIZE: TX_BLOCK_SIZE (Bit 0)                     */
#define SDMMC_BLOCK_SIZE_TX_BLOCK_SIZE_Msk    (0xfffUL)                 /*!< SDMMC BLOCK_SIZE: TX_BLOCK_SIZE (Bitfield-Mask: 0xfff)      */
#define SDMMC_BLOCK_SIZE_TX_BLOCK_SIZE_12_Pos (15UL)                    /*!< SDMMC BLOCK_SIZE: TX_BLOCK_SIZE_12 (Bit 15)                 */
#define SDMMC_BLOCK_SIZE_TX_BLOCK_SIZE_12_Msk (0x8000UL)                /*!< SDMMC BLOCK_SIZE: TX_BLOCK_SIZE_12 (Bitfield-Mask: 0x01)    */

/* ------------------------------  SDMMC_BLOCK_COUNT  ----------------------------- */
#define SDMMC_BLOCK_COUNT_BLOCK_COUNT_Pos     (0UL)                     /*!< SDMMC BLOCK_COUNT: BLOCK_COUNT (Bit 0)                      */
#define SDMMC_BLOCK_COUNT_BLOCK_COUNT_Msk     (0xffffUL)                /*!< SDMMC BLOCK_COUNT: BLOCK_COUNT (Bitfield-Mask: 0xffff)      */

/* -------------------------------  SDMMC_ARGUMENT1  ------------------------------ */
#define SDMMC_ARGUMENT1_ARGUMENT1_Pos         (0UL)                     /*!< SDMMC ARGUMENT1: ARGUMENT1 (Bit 0)                          */
#define SDMMC_ARGUMENT1_ARGUMENT1_Msk         (0xffffffffUL)            /*!< SDMMC ARGUMENT1: ARGUMENT1 (Bitfield-Mask: 0xffffffff)      */

/* -----------------------------  SDMMC_TRANSFER_MODE  ---------------------------- */
#define SDMMC_TRANSFER_MODE_BLOCK_COUNT_EN_Pos (1UL)                    /*!< SDMMC TRANSFER_MODE: BLOCK_COUNT_EN (Bit 1)                 */
#define SDMMC_TRANSFER_MODE_BLOCK_COUNT_EN_Msk (0x2UL)                  /*!< SDMMC TRANSFER_MODE: BLOCK_COUNT_EN (Bitfield-Mask: 0x01)   */
#define SDMMC_TRANSFER_MODE_ACMD_EN_Pos       (2UL)                     /*!< SDMMC TRANSFER_MODE: ACMD_EN (Bit 2)                        */
#define SDMMC_TRANSFER_MODE_ACMD_EN_Msk       (0xcUL)                   /*!< SDMMC TRANSFER_MODE: ACMD_EN (Bitfield-Mask: 0x03)          */
#define SDMMC_TRANSFER_MODE_TX_DIR_SELECT_Pos (4UL)                     /*!< SDMMC TRANSFER_MODE: TX_DIR_SELECT (Bit 4)                  */
#define SDMMC_TRANSFER_MODE_TX_DIR_SELECT_Msk (0x10UL)                  /*!< SDMMC TRANSFER_MODE: TX_DIR_SELECT (Bitfield-Mask: 0x01)    */
#define SDMMC_TRANSFER_MODE_MULTI_BLOCK_SELECT_Pos (5UL)                /*!< SDMMC TRANSFER_MODE: MULTI_BLOCK_SELECT (Bit 5)             */
#define SDMMC_TRANSFER_MODE_MULTI_BLOCK_SELECT_Msk (0x20UL)             /*!< SDMMC TRANSFER_MODE: MULTI_BLOCK_SELECT (Bitfield-Mask: 0x01) */
#define SDMMC_TRANSFER_MODE_CMD_COMP_ATA_Pos  (6UL)                     /*!< SDMMC TRANSFER_MODE: CMD_COMP_ATA (Bit 6)                   */
#define SDMMC_TRANSFER_MODE_CMD_COMP_ATA_Msk  (0x40UL)                  /*!< SDMMC TRANSFER_MODE: CMD_COMP_ATA (Bitfield-Mask: 0x01)     */

/* --------------------------------  SDMMC_COMMAND  ------------------------------- */
#define SDMMC_COMMAND_RESP_TYPE_SELECT_Pos    (0UL)                     /*!< SDMMC COMMAND: RESP_TYPE_SELECT (Bit 0)                     */
#define SDMMC_COMMAND_RESP_TYPE_SELECT_Msk    (0x3UL)                   /*!< SDMMC COMMAND: RESP_TYPE_SELECT (Bitfield-Mask: 0x03)       */
#define SDMMC_COMMAND_CMD_CRC_CHECK_EN_Pos    (3UL)                     /*!< SDMMC COMMAND: CMD_CRC_CHECK_EN (Bit 3)                     */
#define SDMMC_COMMAND_CMD_CRC_CHECK_EN_Msk    (0x8UL)                   /*!< SDMMC COMMAND: CMD_CRC_CHECK_EN (Bitfield-Mask: 0x01)       */
#define SDMMC_COMMAND_CMD_IND_CHECK_EN_Pos    (4UL)                     /*!< SDMMC COMMAND: CMD_IND_CHECK_EN (Bit 4)                     */
#define SDMMC_COMMAND_CMD_IND_CHECK_EN_Msk    (0x10UL)                  /*!< SDMMC COMMAND: CMD_IND_CHECK_EN (Bitfield-Mask: 0x01)       */
#define SDMMC_COMMAND_DATA_PRESENT_SELECT_Pos (5UL)                     /*!< SDMMC COMMAND: DATA_PRESENT_SELECT (Bit 5)                  */
#define SDMMC_COMMAND_DATA_PRESENT_SELECT_Msk (0x20UL)                  /*!< SDMMC COMMAND: DATA_PRESENT_SELECT (Bitfield-Mask: 0x01)    */
#define SDMMC_COMMAND_CMD_TYPE_Pos            (6UL)                     /*!< SDMMC COMMAND: CMD_TYPE (Bit 6)                             */
#define SDMMC_COMMAND_CMD_TYPE_Msk            (0xc0UL)                  /*!< SDMMC COMMAND: CMD_TYPE (Bitfield-Mask: 0x03)               */
#define SDMMC_COMMAND_CMD_IND_Pos             (8UL)                     /*!< SDMMC COMMAND: CMD_IND (Bit 8)                              */
#define SDMMC_COMMAND_CMD_IND_Msk             (0x3f00UL)                /*!< SDMMC COMMAND: CMD_IND (Bitfield-Mask: 0x3f)                */

/* -------------------------------  SDMMC_RESPONSE0  ------------------------------ */
#define SDMMC_RESPONSE0_RESPONSE0_Pos         (0UL)                     /*!< SDMMC RESPONSE0: RESPONSE0 (Bit 0)                          */
#define SDMMC_RESPONSE0_RESPONSE0_Msk         (0xffffUL)                /*!< SDMMC RESPONSE0: RESPONSE0 (Bitfield-Mask: 0xffff)          */
#define SDMMC_RESPONSE0_RESPONSE1_Pos         (16UL)                    /*!< SDMMC RESPONSE0: RESPONSE1 (Bit 16)                         */
#define SDMMC_RESPONSE0_RESPONSE1_Msk         (0xffff0000UL)            /*!< SDMMC RESPONSE0: RESPONSE1 (Bitfield-Mask: 0xffff)          */

/* -------------------------------  SDMMC_RESPONSE2  ------------------------------ */
#define SDMMC_RESPONSE2_RESPONSE2_Pos         (0UL)                     /*!< SDMMC RESPONSE2: RESPONSE2 (Bit 0)                          */
#define SDMMC_RESPONSE2_RESPONSE2_Msk         (0xffffUL)                /*!< SDMMC RESPONSE2: RESPONSE2 (Bitfield-Mask: 0xffff)          */
#define SDMMC_RESPONSE2_RESPONSE3_Pos         (16UL)                    /*!< SDMMC RESPONSE2: RESPONSE3 (Bit 16)                         */
#define SDMMC_RESPONSE2_RESPONSE3_Msk         (0xffff0000UL)            /*!< SDMMC RESPONSE2: RESPONSE3 (Bitfield-Mask: 0xffff)          */

/* -------------------------------  SDMMC_RESPONSE4  ------------------------------ */
#define SDMMC_RESPONSE4_RESPONSE4_Pos         (0UL)                     /*!< SDMMC RESPONSE4: RESPONSE4 (Bit 0)                          */
#define SDMMC_RESPONSE4_RESPONSE4_Msk         (0xffffUL)                /*!< SDMMC RESPONSE4: RESPONSE4 (Bitfield-Mask: 0xffff)          */
#define SDMMC_RESPONSE4_RESPONSE5_Pos         (16UL)                    /*!< SDMMC RESPONSE4: RESPONSE5 (Bit 16)                         */
#define SDMMC_RESPONSE4_RESPONSE5_Msk         (0xffff0000UL)            /*!< SDMMC RESPONSE4: RESPONSE5 (Bitfield-Mask: 0xffff)          */

/* -------------------------------  SDMMC_RESPONSE6  ------------------------------ */
#define SDMMC_RESPONSE6_RESPONSE6_Pos         (0UL)                     /*!< SDMMC RESPONSE6: RESPONSE6 (Bit 0)                          */
#define SDMMC_RESPONSE6_RESPONSE6_Msk         (0xffffUL)                /*!< SDMMC RESPONSE6: RESPONSE6 (Bitfield-Mask: 0xffff)          */
#define SDMMC_RESPONSE6_RESPONSE7_Pos         (16UL)                    /*!< SDMMC RESPONSE6: RESPONSE7 (Bit 16)                         */
#define SDMMC_RESPONSE6_RESPONSE7_Msk         (0xffff0000UL)            /*!< SDMMC RESPONSE6: RESPONSE7 (Bitfield-Mask: 0xffff)          */

/* ------------------------------  SDMMC_DATA_BUFFER  ----------------------------- */
#define SDMMC_DATA_BUFFER_DATA_BUFFER_Pos     (0UL)                     /*!< SDMMC DATA_BUFFER: DATA_BUFFER (Bit 0)                      */
#define SDMMC_DATA_BUFFER_DATA_BUFFER_Msk     (0xffffffffUL)            /*!< SDMMC DATA_BUFFER: DATA_BUFFER (Bitfield-Mask: 0xffffffff)  */

/* -----------------------------  SDMMC_PRESENT_STATE  ---------------------------- */
#define SDMMC_PRESENT_STATE_COMMAND_INHIBIT_CMD_Pos (0UL)               /*!< SDMMC PRESENT_STATE: COMMAND_INHIBIT_CMD (Bit 0)            */
#define SDMMC_PRESENT_STATE_COMMAND_INHIBIT_CMD_Msk (0x1UL)             /*!< SDMMC PRESENT_STATE: COMMAND_INHIBIT_CMD (Bitfield-Mask: 0x01) */
#define SDMMC_PRESENT_STATE_COMMAND_INHIBIT_DAT_Pos (1UL)               /*!< SDMMC PRESENT_STATE: COMMAND_INHIBIT_DAT (Bit 1)            */
#define SDMMC_PRESENT_STATE_COMMAND_INHIBIT_DAT_Msk (0x2UL)             /*!< SDMMC PRESENT_STATE: COMMAND_INHIBIT_DAT (Bitfield-Mask: 0x01) */
#define SDMMC_PRESENT_STATE_DAT_LINE_ACTIVE_Pos (2UL)                   /*!< SDMMC PRESENT_STATE: DAT_LINE_ACTIVE (Bit 2)                */
#define SDMMC_PRESENT_STATE_DAT_LINE_ACTIVE_Msk (0x4UL)                 /*!< SDMMC PRESENT_STATE: DAT_LINE_ACTIVE (Bitfield-Mask: 0x01)  */
#define SDMMC_PRESENT_STATE_WRITE_TRANSFER_ACTIVE_Pos (8UL)             /*!< SDMMC PRESENT_STATE: WRITE_TRANSFER_ACTIVE (Bit 8)          */
#define SDMMC_PRESENT_STATE_WRITE_TRANSFER_ACTIVE_Msk (0x100UL)         /*!< SDMMC PRESENT_STATE: WRITE_TRANSFER_ACTIVE (Bitfield-Mask: 0x01) */
#define SDMMC_PRESENT_STATE_READ_TRANSFER_ACTIVE_Pos (9UL)              /*!< SDMMC PRESENT_STATE: READ_TRANSFER_ACTIVE (Bit 9)           */
#define SDMMC_PRESENT_STATE_READ_TRANSFER_ACTIVE_Msk (0x200UL)          /*!< SDMMC PRESENT_STATE: READ_TRANSFER_ACTIVE (Bitfield-Mask: 0x01) */
#define SDMMC_PRESENT_STATE_BUFFER_WRITE_ENABLE_Pos (10UL)              /*!< SDMMC PRESENT_STATE: BUFFER_WRITE_ENABLE (Bit 10)           */
#define SDMMC_PRESENT_STATE_BUFFER_WRITE_ENABLE_Msk (0x400UL)           /*!< SDMMC PRESENT_STATE: BUFFER_WRITE_ENABLE (Bitfield-Mask: 0x01) */
#define SDMMC_PRESENT_STATE_BUFFER_READ_ENABLE_Pos (11UL)               /*!< SDMMC PRESENT_STATE: BUFFER_READ_ENABLE (Bit 11)            */
#define SDMMC_PRESENT_STATE_BUFFER_READ_ENABLE_Msk (0x800UL)            /*!< SDMMC PRESENT_STATE: BUFFER_READ_ENABLE (Bitfield-Mask: 0x01) */
#define SDMMC_PRESENT_STATE_CARD_INSERTED_Pos (16UL)                    /*!< SDMMC PRESENT_STATE: CARD_INSERTED (Bit 16)                 */
#define SDMMC_PRESENT_STATE_CARD_INSERTED_Msk (0x10000UL)               /*!< SDMMC PRESENT_STATE: CARD_INSERTED (Bitfield-Mask: 0x01)    */
#define SDMMC_PRESENT_STATE_CARD_STATE_STABLE_Pos (17UL)                /*!< SDMMC PRESENT_STATE: CARD_STATE_STABLE (Bit 17)             */
#define SDMMC_PRESENT_STATE_CARD_STATE_STABLE_Msk (0x20000UL)           /*!< SDMMC PRESENT_STATE: CARD_STATE_STABLE (Bitfield-Mask: 0x01) */
#define SDMMC_PRESENT_STATE_CARD_DETECT_PIN_LEVEL_Pos (18UL)            /*!< SDMMC PRESENT_STATE: CARD_DETECT_PIN_LEVEL (Bit 18)         */
#define SDMMC_PRESENT_STATE_CARD_DETECT_PIN_LEVEL_Msk (0x40000UL)       /*!< SDMMC PRESENT_STATE: CARD_DETECT_PIN_LEVEL (Bitfield-Mask: 0x01) */
#define SDMMC_PRESENT_STATE_WRITE_PROTECT_PIN_LEVEL_Pos (19UL)          /*!< SDMMC PRESENT_STATE: WRITE_PROTECT_PIN_LEVEL (Bit 19)       */
#define SDMMC_PRESENT_STATE_WRITE_PROTECT_PIN_LEVEL_Msk (0x80000UL)     /*!< SDMMC PRESENT_STATE: WRITE_PROTECT_PIN_LEVEL (Bitfield-Mask: 0x01) */
#define SDMMC_PRESENT_STATE_DAT_3_0_PIN_LEVEL_Pos (20UL)                /*!< SDMMC PRESENT_STATE: DAT_3_0_PIN_LEVEL (Bit 20)             */
#define SDMMC_PRESENT_STATE_DAT_3_0_PIN_LEVEL_Msk (0xf00000UL)          /*!< SDMMC PRESENT_STATE: DAT_3_0_PIN_LEVEL (Bitfield-Mask: 0x0f) */
#define SDMMC_PRESENT_STATE_CMD_LINE_LEVEL_Pos (24UL)                   /*!< SDMMC PRESENT_STATE: CMD_LINE_LEVEL (Bit 24)                */
#define SDMMC_PRESENT_STATE_CMD_LINE_LEVEL_Msk (0x1000000UL)            /*!< SDMMC PRESENT_STATE: CMD_LINE_LEVEL (Bitfield-Mask: 0x01)   */
#define SDMMC_PRESENT_STATE_DAT_7_4_PIN_LEVEL_Pos (25UL)                /*!< SDMMC PRESENT_STATE: DAT_7_4_PIN_LEVEL (Bit 25)             */
#define SDMMC_PRESENT_STATE_DAT_7_4_PIN_LEVEL_Msk (0x1e000000UL)        /*!< SDMMC PRESENT_STATE: DAT_7_4_PIN_LEVEL (Bitfield-Mask: 0x0f) */

/* -------------------------------  SDMMC_HOST_CTRL  ------------------------------ */
#define SDMMC_HOST_CTRL_LED_CTRL_Pos          (0UL)                     /*!< SDMMC HOST_CTRL: LED_CTRL (Bit 0)                           */
#define SDMMC_HOST_CTRL_LED_CTRL_Msk          (0x1UL)                   /*!< SDMMC HOST_CTRL: LED_CTRL (Bitfield-Mask: 0x01)             */
#define SDMMC_HOST_CTRL_DATA_TX_WIDTH_Pos     (1UL)                     /*!< SDMMC HOST_CTRL: DATA_TX_WIDTH (Bit 1)                      */
#define SDMMC_HOST_CTRL_DATA_TX_WIDTH_Msk     (0x2UL)                   /*!< SDMMC HOST_CTRL: DATA_TX_WIDTH (Bitfield-Mask: 0x01)        */
#define SDMMC_HOST_CTRL_HIGH_SPEED_EN_Pos     (2UL)                     /*!< SDMMC HOST_CTRL: HIGH_SPEED_EN (Bit 2)                      */
#define SDMMC_HOST_CTRL_HIGH_SPEED_EN_Msk     (0x4UL)                   /*!< SDMMC HOST_CTRL: HIGH_SPEED_EN (Bitfield-Mask: 0x01)        */
#define SDMMC_HOST_CTRL_SD_8BIT_MODE_Pos      (5UL)                     /*!< SDMMC HOST_CTRL: SD_8BIT_MODE (Bit 5)                       */
#define SDMMC_HOST_CTRL_SD_8BIT_MODE_Msk      (0x20UL)                  /*!< SDMMC HOST_CTRL: SD_8BIT_MODE (Bitfield-Mask: 0x01)         */
#define SDMMC_HOST_CTRL_CARD_DETECT_TEST_LEVEL_Pos (6UL)                /*!< SDMMC HOST_CTRL: CARD_DETECT_TEST_LEVEL (Bit 6)             */
#define SDMMC_HOST_CTRL_CARD_DETECT_TEST_LEVEL_Msk (0x40UL)             /*!< SDMMC HOST_CTRL: CARD_DETECT_TEST_LEVEL (Bitfield-Mask: 0x01) */
#define SDMMC_HOST_CTRL_CARD_DET_SIGNAL_DETECT_Pos (7UL)                /*!< SDMMC HOST_CTRL: CARD_DET_SIGNAL_DETECT (Bit 7)             */
#define SDMMC_HOST_CTRL_CARD_DET_SIGNAL_DETECT_Msk (0x80UL)             /*!< SDMMC HOST_CTRL: CARD_DET_SIGNAL_DETECT (Bitfield-Mask: 0x01) */

/* ------------------------------  SDMMC_POWER_CTRL  ------------------------------ */
#define SDMMC_POWER_CTRL_SD_BUS_POWER_Pos     (0UL)                     /*!< SDMMC POWER_CTRL: SD_BUS_POWER (Bit 0)                      */
#define SDMMC_POWER_CTRL_SD_BUS_POWER_Msk     (0x1UL)                   /*!< SDMMC POWER_CTRL: SD_BUS_POWER (Bitfield-Mask: 0x01)        */
#define SDMMC_POWER_CTRL_SD_BUS_VOLTAGE_SEL_Pos (1UL)                   /*!< SDMMC POWER_CTRL: SD_BUS_VOLTAGE_SEL (Bit 1)                */
#define SDMMC_POWER_CTRL_SD_BUS_VOLTAGE_SEL_Msk (0xeUL)                 /*!< SDMMC POWER_CTRL: SD_BUS_VOLTAGE_SEL (Bitfield-Mask: 0x07)  */
#define SDMMC_POWER_CTRL_HARDWARE_RESET_Pos   (4UL)                     /*!< SDMMC POWER_CTRL: HARDWARE_RESET (Bit 4)                    */
#define SDMMC_POWER_CTRL_HARDWARE_RESET_Msk   (0x10UL)                  /*!< SDMMC POWER_CTRL: HARDWARE_RESET (Bitfield-Mask: 0x01)      */

/* ----------------------------  SDMMC_BLOCK_GAP_CTRL  ---------------------------- */
#define SDMMC_BLOCK_GAP_CTRL_STOP_AT_BLOCK_GAP_Pos (0UL)                /*!< SDMMC BLOCK_GAP_CTRL: STOP_AT_BLOCK_GAP (Bit 0)             */
#define SDMMC_BLOCK_GAP_CTRL_STOP_AT_BLOCK_GAP_Msk (0x1UL)              /*!< SDMMC BLOCK_GAP_CTRL: STOP_AT_BLOCK_GAP (Bitfield-Mask: 0x01) */
#define SDMMC_BLOCK_GAP_CTRL_CONTINUE_REQ_Pos (1UL)                     /*!< SDMMC BLOCK_GAP_CTRL: CONTINUE_REQ (Bit 1)                  */
#define SDMMC_BLOCK_GAP_CTRL_CONTINUE_REQ_Msk (0x2UL)                   /*!< SDMMC BLOCK_GAP_CTRL: CONTINUE_REQ (Bitfield-Mask: 0x01)    */
#define SDMMC_BLOCK_GAP_CTRL_READ_WAIT_CTRL_Pos (2UL)                   /*!< SDMMC BLOCK_GAP_CTRL: READ_WAIT_CTRL (Bit 2)                */
#define SDMMC_BLOCK_GAP_CTRL_READ_WAIT_CTRL_Msk (0x4UL)                 /*!< SDMMC BLOCK_GAP_CTRL: READ_WAIT_CTRL (Bitfield-Mask: 0x01)  */
#define SDMMC_BLOCK_GAP_CTRL_INT_AT_BLOCK_GAP_Pos (3UL)                 /*!< SDMMC BLOCK_GAP_CTRL: INT_AT_BLOCK_GAP (Bit 3)              */
#define SDMMC_BLOCK_GAP_CTRL_INT_AT_BLOCK_GAP_Msk (0x8UL)               /*!< SDMMC BLOCK_GAP_CTRL: INT_AT_BLOCK_GAP (Bitfield-Mask: 0x01) */
#define SDMMC_BLOCK_GAP_CTRL_SPI_MODE_Pos     (4UL)                     /*!< SDMMC BLOCK_GAP_CTRL: SPI_MODE (Bit 4)                      */
#define SDMMC_BLOCK_GAP_CTRL_SPI_MODE_Msk     (0x10UL)                  /*!< SDMMC BLOCK_GAP_CTRL: SPI_MODE (Bitfield-Mask: 0x01)        */

/* ------------------------------  SDMMC_WAKEUP_CTRL  ----------------------------- */
#define SDMMC_WAKEUP_CTRL_WAKEUP_EVENT_EN_INT_Pos (0UL)                 /*!< SDMMC WAKEUP_CTRL: WAKEUP_EVENT_EN_INT (Bit 0)              */
#define SDMMC_WAKEUP_CTRL_WAKEUP_EVENT_EN_INT_Msk (0x1UL)               /*!< SDMMC WAKEUP_CTRL: WAKEUP_EVENT_EN_INT (Bitfield-Mask: 0x01) */
#define SDMMC_WAKEUP_CTRL_WAKEUP_EVENT_EN_INS_Pos (1UL)                 /*!< SDMMC WAKEUP_CTRL: WAKEUP_EVENT_EN_INS (Bit 1)              */
#define SDMMC_WAKEUP_CTRL_WAKEUP_EVENT_EN_INS_Msk (0x2UL)               /*!< SDMMC WAKEUP_CTRL: WAKEUP_EVENT_EN_INS (Bitfield-Mask: 0x01) */
#define SDMMC_WAKEUP_CTRL_WAKEUP_EVENT_EN_REM_Pos (2UL)                 /*!< SDMMC WAKEUP_CTRL: WAKEUP_EVENT_EN_REM (Bit 2)              */
#define SDMMC_WAKEUP_CTRL_WAKEUP_EVENT_EN_REM_Msk (0x4UL)               /*!< SDMMC WAKEUP_CTRL: WAKEUP_EVENT_EN_REM (Bitfield-Mask: 0x01) */

/* ------------------------------  SDMMC_CLOCK_CTRL  ------------------------------ */
#define SDMMC_CLOCK_CTRL_INTERNAL_CLOCK_EN_Pos (0UL)                    /*!< SDMMC CLOCK_CTRL: INTERNAL_CLOCK_EN (Bit 0)                 */
#define SDMMC_CLOCK_CTRL_INTERNAL_CLOCK_EN_Msk (0x1UL)                  /*!< SDMMC CLOCK_CTRL: INTERNAL_CLOCK_EN (Bitfield-Mask: 0x01)   */
#define SDMMC_CLOCK_CTRL_INTERNAL_CLOCK_STABLE_Pos (1UL)                /*!< SDMMC CLOCK_CTRL: INTERNAL_CLOCK_STABLE (Bit 1)             */
#define SDMMC_CLOCK_CTRL_INTERNAL_CLOCK_STABLE_Msk (0x2UL)              /*!< SDMMC CLOCK_CTRL: INTERNAL_CLOCK_STABLE (Bitfield-Mask: 0x01) */
#define SDMMC_CLOCK_CTRL_SDCLOCK_EN_Pos       (2UL)                     /*!< SDMMC CLOCK_CTRL: SDCLOCK_EN (Bit 2)                        */
#define SDMMC_CLOCK_CTRL_SDCLOCK_EN_Msk       (0x4UL)                   /*!< SDMMC CLOCK_CTRL: SDCLOCK_EN (Bitfield-Mask: 0x01)          */
#define SDMMC_CLOCK_CTRL_SDCLK_FREQ_SEL_Pos   (8UL)                     /*!< SDMMC CLOCK_CTRL: SDCLK_FREQ_SEL (Bit 8)                    */
#define SDMMC_CLOCK_CTRL_SDCLK_FREQ_SEL_Msk   (0xff00UL)                /*!< SDMMC CLOCK_CTRL: SDCLK_FREQ_SEL (Bitfield-Mask: 0xff)      */

/* -----------------------------  SDMMC_TIMEOUT_CTRL  ----------------------------- */
#define SDMMC_TIMEOUT_CTRL_DAT_TIMEOUT_CNT_VAL_Pos (0UL)                /*!< SDMMC TIMEOUT_CTRL: DAT_TIMEOUT_CNT_VAL (Bit 0)             */
#define SDMMC_TIMEOUT_CTRL_DAT_TIMEOUT_CNT_VAL_Msk (0xfUL)              /*!< SDMMC TIMEOUT_CTRL: DAT_TIMEOUT_CNT_VAL (Bitfield-Mask: 0x0f) */

/* -------------------------------  SDMMC_SW_RESET  ------------------------------- */
#define SDMMC_SW_RESET_SW_RST_ALL_Pos         (0UL)                     /*!< SDMMC SW_RESET: SW_RST_ALL (Bit 0)                          */
#define SDMMC_SW_RESET_SW_RST_ALL_Msk         (0x1UL)                   /*!< SDMMC SW_RESET: SW_RST_ALL (Bitfield-Mask: 0x01)            */
#define SDMMC_SW_RESET_SW_RST_CMD_LINE_Pos    (1UL)                     /*!< SDMMC SW_RESET: SW_RST_CMD_LINE (Bit 1)                     */
#define SDMMC_SW_RESET_SW_RST_CMD_LINE_Msk    (0x2UL)                   /*!< SDMMC SW_RESET: SW_RST_CMD_LINE (Bitfield-Mask: 0x01)       */
#define SDMMC_SW_RESET_SW_RST_DAT_LINE_Pos    (2UL)                     /*!< SDMMC SW_RESET: SW_RST_DAT_LINE (Bit 2)                     */
#define SDMMC_SW_RESET_SW_RST_DAT_LINE_Msk    (0x4UL)                   /*!< SDMMC SW_RESET: SW_RST_DAT_LINE (Bitfield-Mask: 0x01)       */

/* ----------------------------  SDMMC_INT_STATUS_NORM  --------------------------- */
#define SDMMC_INT_STATUS_NORM_CMD_COMPLETE_Pos (0UL)                    /*!< SDMMC INT_STATUS_NORM: CMD_COMPLETE (Bit 0)                 */
#define SDMMC_INT_STATUS_NORM_CMD_COMPLETE_Msk (0x1UL)                  /*!< SDMMC INT_STATUS_NORM: CMD_COMPLETE (Bitfield-Mask: 0x01)   */
#define SDMMC_INT_STATUS_NORM_TX_COMPLETE_Pos (1UL)                     /*!< SDMMC INT_STATUS_NORM: TX_COMPLETE (Bit 1)                  */
#define SDMMC_INT_STATUS_NORM_TX_COMPLETE_Msk (0x2UL)                   /*!< SDMMC INT_STATUS_NORM: TX_COMPLETE (Bitfield-Mask: 0x01)    */
#define SDMMC_INT_STATUS_NORM_BLOCK_GAP_EVENT_Pos (2UL)                 /*!< SDMMC INT_STATUS_NORM: BLOCK_GAP_EVENT (Bit 2)              */
#define SDMMC_INT_STATUS_NORM_BLOCK_GAP_EVENT_Msk (0x4UL)               /*!< SDMMC INT_STATUS_NORM: BLOCK_GAP_EVENT (Bitfield-Mask: 0x01) */
#define SDMMC_INT_STATUS_NORM_BUFF_WRITE_READY_Pos (4UL)                /*!< SDMMC INT_STATUS_NORM: BUFF_WRITE_READY (Bit 4)             */
#define SDMMC_INT_STATUS_NORM_BUFF_WRITE_READY_Msk (0x10UL)             /*!< SDMMC INT_STATUS_NORM: BUFF_WRITE_READY (Bitfield-Mask: 0x01) */
#define SDMMC_INT_STATUS_NORM_BUFF_READ_READY_Pos (5UL)                 /*!< SDMMC INT_STATUS_NORM: BUFF_READ_READY (Bit 5)              */
#define SDMMC_INT_STATUS_NORM_BUFF_READ_READY_Msk (0x20UL)              /*!< SDMMC INT_STATUS_NORM: BUFF_READ_READY (Bitfield-Mask: 0x01) */
#define SDMMC_INT_STATUS_NORM_CARD_INS_Pos    (6UL)                     /*!< SDMMC INT_STATUS_NORM: CARD_INS (Bit 6)                     */
#define SDMMC_INT_STATUS_NORM_CARD_INS_Msk    (0x40UL)                  /*!< SDMMC INT_STATUS_NORM: CARD_INS (Bitfield-Mask: 0x01)       */
#define SDMMC_INT_STATUS_NORM_CARD_REMOVAL_Pos (7UL)                    /*!< SDMMC INT_STATUS_NORM: CARD_REMOVAL (Bit 7)                 */
#define SDMMC_INT_STATUS_NORM_CARD_REMOVAL_Msk (0x80UL)                 /*!< SDMMC INT_STATUS_NORM: CARD_REMOVAL (Bitfield-Mask: 0x01)   */
#define SDMMC_INT_STATUS_NORM_CARD_INT_Pos    (8UL)                     /*!< SDMMC INT_STATUS_NORM: CARD_INT (Bit 8)                     */
#define SDMMC_INT_STATUS_NORM_CARD_INT_Msk    (0x100UL)                 /*!< SDMMC INT_STATUS_NORM: CARD_INT (Bitfield-Mask: 0x01)       */
#define SDMMC_INT_STATUS_NORM_ERR_INT_Pos     (15UL)                    /*!< SDMMC INT_STATUS_NORM: ERR_INT (Bit 15)                     */
#define SDMMC_INT_STATUS_NORM_ERR_INT_Msk     (0x8000UL)                /*!< SDMMC INT_STATUS_NORM: ERR_INT (Bitfield-Mask: 0x01)        */

/* ----------------------------  SDMMC_INT_STATUS_ERR  ---------------------------- */
#define SDMMC_INT_STATUS_ERR_CMD_TIMEOUT_ERR_Pos (0UL)                  /*!< SDMMC INT_STATUS_ERR: CMD_TIMEOUT_ERR (Bit 0)               */
#define SDMMC_INT_STATUS_ERR_CMD_TIMEOUT_ERR_Msk (0x1UL)                /*!< SDMMC INT_STATUS_ERR: CMD_TIMEOUT_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_INT_STATUS_ERR_CMD_CRC_ERR_Pos  (1UL)                     /*!< SDMMC INT_STATUS_ERR: CMD_CRC_ERR (Bit 1)                   */
#define SDMMC_INT_STATUS_ERR_CMD_CRC_ERR_Msk  (0x2UL)                   /*!< SDMMC INT_STATUS_ERR: CMD_CRC_ERR (Bitfield-Mask: 0x01)     */
#define SDMMC_INT_STATUS_ERR_CMD_END_BIT_ERR_Pos (2UL)                  /*!< SDMMC INT_STATUS_ERR: CMD_END_BIT_ERR (Bit 2)               */
#define SDMMC_INT_STATUS_ERR_CMD_END_BIT_ERR_Msk (0x4UL)                /*!< SDMMC INT_STATUS_ERR: CMD_END_BIT_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_INT_STATUS_ERR_CMD_IND_ERR_Pos  (3UL)                     /*!< SDMMC INT_STATUS_ERR: CMD_IND_ERR (Bit 3)                   */
#define SDMMC_INT_STATUS_ERR_CMD_IND_ERR_Msk  (0x8UL)                   /*!< SDMMC INT_STATUS_ERR: CMD_IND_ERR (Bitfield-Mask: 0x01)     */
#define SDMMC_INT_STATUS_ERR_DATA_TIMEOUT_ERR_Pos (4UL)                 /*!< SDMMC INT_STATUS_ERR: DATA_TIMEOUT_ERR (Bit 4)              */
#define SDMMC_INT_STATUS_ERR_DATA_TIMEOUT_ERR_Msk (0x10UL)              /*!< SDMMC INT_STATUS_ERR: DATA_TIMEOUT_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_INT_STATUS_ERR_DATA_CRC_ERR_Pos (5UL)                     /*!< SDMMC INT_STATUS_ERR: DATA_CRC_ERR (Bit 5)                  */
#define SDMMC_INT_STATUS_ERR_DATA_CRC_ERR_Msk (0x20UL)                  /*!< SDMMC INT_STATUS_ERR: DATA_CRC_ERR (Bitfield-Mask: 0x01)    */
#define SDMMC_INT_STATUS_ERR_DATA_END_BIT_ERR_Pos (6UL)                 /*!< SDMMC INT_STATUS_ERR: DATA_END_BIT_ERR (Bit 6)              */
#define SDMMC_INT_STATUS_ERR_DATA_END_BIT_ERR_Msk (0x40UL)              /*!< SDMMC INT_STATUS_ERR: DATA_END_BIT_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_INT_STATUS_ERR_CURRENT_LIMIT_ERR_Pos (7UL)                /*!< SDMMC INT_STATUS_ERR: CURRENT_LIMIT_ERR (Bit 7)             */
#define SDMMC_INT_STATUS_ERR_CURRENT_LIMIT_ERR_Msk (0x80UL)             /*!< SDMMC INT_STATUS_ERR: CURRENT_LIMIT_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_INT_STATUS_ERR_ACMD_ERR_Pos     (8UL)                     /*!< SDMMC INT_STATUS_ERR: ACMD_ERR (Bit 8)                      */
#define SDMMC_INT_STATUS_ERR_ACMD_ERR_Msk     (0x100UL)                 /*!< SDMMC INT_STATUS_ERR: ACMD_ERR (Bitfield-Mask: 0x01)        */
#define SDMMC_INT_STATUS_ERR_CEATA_ERR_Pos    (13UL)                    /*!< SDMMC INT_STATUS_ERR: CEATA_ERR (Bit 13)                    */
#define SDMMC_INT_STATUS_ERR_CEATA_ERR_Msk    (0x2000UL)                /*!< SDMMC INT_STATUS_ERR: CEATA_ERR (Bitfield-Mask: 0x01)       */

/* --------------------------  SDMMC_EN_INT_STATUS_NORM  -------------------------- */
#define SDMMC_EN_INT_STATUS_NORM_CMD_COMPLETE_EN_Pos (0UL)              /*!< SDMMC EN_INT_STATUS_NORM: CMD_COMPLETE_EN (Bit 0)           */
#define SDMMC_EN_INT_STATUS_NORM_CMD_COMPLETE_EN_Msk (0x1UL)            /*!< SDMMC EN_INT_STATUS_NORM: CMD_COMPLETE_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_NORM_TX_COMPLETE_EN_Pos (1UL)               /*!< SDMMC EN_INT_STATUS_NORM: TX_COMPLETE_EN (Bit 1)            */
#define SDMMC_EN_INT_STATUS_NORM_TX_COMPLETE_EN_Msk (0x2UL)             /*!< SDMMC EN_INT_STATUS_NORM: TX_COMPLETE_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_NORM_BLOCK_GAP_EVENT_EN_Pos (2UL)           /*!< SDMMC EN_INT_STATUS_NORM: BLOCK_GAP_EVENT_EN (Bit 2)        */
#define SDMMC_EN_INT_STATUS_NORM_BLOCK_GAP_EVENT_EN_Msk (0x4UL)         /*!< SDMMC EN_INT_STATUS_NORM: BLOCK_GAP_EVENT_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_NORM_BUFF_WRITE_READY_EN_Pos (4UL)          /*!< SDMMC EN_INT_STATUS_NORM: BUFF_WRITE_READY_EN (Bit 4)       */
#define SDMMC_EN_INT_STATUS_NORM_BUFF_WRITE_READY_EN_Msk (0x10UL)       /*!< SDMMC EN_INT_STATUS_NORM: BUFF_WRITE_READY_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_NORM_BUFF_READ_READY_EN_Pos (5UL)           /*!< SDMMC EN_INT_STATUS_NORM: BUFF_READ_READY_EN (Bit 5)        */
#define SDMMC_EN_INT_STATUS_NORM_BUFF_READ_READY_EN_Msk (0x20UL)        /*!< SDMMC EN_INT_STATUS_NORM: BUFF_READ_READY_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_NORM_CARD_INS_EN_Pos (6UL)                  /*!< SDMMC EN_INT_STATUS_NORM: CARD_INS_EN (Bit 6)               */
#define SDMMC_EN_INT_STATUS_NORM_CARD_INS_EN_Msk (0x40UL)               /*!< SDMMC EN_INT_STATUS_NORM: CARD_INS_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_NORM_CARD_REMOVAL_EN_Pos (7UL)              /*!< SDMMC EN_INT_STATUS_NORM: CARD_REMOVAL_EN (Bit 7)           */
#define SDMMC_EN_INT_STATUS_NORM_CARD_REMOVAL_EN_Msk (0x80UL)           /*!< SDMMC EN_INT_STATUS_NORM: CARD_REMOVAL_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_NORM_CARD_INT_EN_Pos (8UL)                  /*!< SDMMC EN_INT_STATUS_NORM: CARD_INT_EN (Bit 8)               */
#define SDMMC_EN_INT_STATUS_NORM_CARD_INT_EN_Msk (0x100UL)              /*!< SDMMC EN_INT_STATUS_NORM: CARD_INT_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_NORM_FIXED_TO_0_Pos (15UL)                  /*!< SDMMC EN_INT_STATUS_NORM: FIXED_TO_0 (Bit 15)               */
#define SDMMC_EN_INT_STATUS_NORM_FIXED_TO_0_Msk (0x8000UL)              /*!< SDMMC EN_INT_STATUS_NORM: FIXED_TO_0 (Bitfield-Mask: 0x01)  */

/* ---------------------------  SDMMC_EN_INT_STATUS_ERR  -------------------------- */
#define SDMMC_EN_INT_STATUS_ERR_CMD_TIMEOUT_ERR_EN_Pos (0UL)            /*!< SDMMC EN_INT_STATUS_ERR: CMD_TIMEOUT_ERR_EN (Bit 0)         */
#define SDMMC_EN_INT_STATUS_ERR_CMD_TIMEOUT_ERR_EN_Msk (0x1UL)          /*!< SDMMC EN_INT_STATUS_ERR: CMD_TIMEOUT_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_ERR_CMD_CRC_ERR_EN_Pos (1UL)                /*!< SDMMC EN_INT_STATUS_ERR: CMD_CRC_ERR_EN (Bit 1)             */
#define SDMMC_EN_INT_STATUS_ERR_CMD_CRC_ERR_EN_Msk (0x2UL)              /*!< SDMMC EN_INT_STATUS_ERR: CMD_CRC_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_ERR_CMD_END_BIT_ERR_EN_Pos (2UL)            /*!< SDMMC EN_INT_STATUS_ERR: CMD_END_BIT_ERR_EN (Bit 2)         */
#define SDMMC_EN_INT_STATUS_ERR_CMD_END_BIT_ERR_EN_Msk (0x4UL)          /*!< SDMMC EN_INT_STATUS_ERR: CMD_END_BIT_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_ERR_CMD_IND_ERR_EN_Pos (3UL)                /*!< SDMMC EN_INT_STATUS_ERR: CMD_IND_ERR_EN (Bit 3)             */
#define SDMMC_EN_INT_STATUS_ERR_CMD_IND_ERR_EN_Msk (0x8UL)              /*!< SDMMC EN_INT_STATUS_ERR: CMD_IND_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_ERR_DATA_TIMEOUT_ERR_EN_Pos (4UL)           /*!< SDMMC EN_INT_STATUS_ERR: DATA_TIMEOUT_ERR_EN (Bit 4)        */
#define SDMMC_EN_INT_STATUS_ERR_DATA_TIMEOUT_ERR_EN_Msk (0x10UL)        /*!< SDMMC EN_INT_STATUS_ERR: DATA_TIMEOUT_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_ERR_DATA_CRC_ERR_EN_Pos (5UL)               /*!< SDMMC EN_INT_STATUS_ERR: DATA_CRC_ERR_EN (Bit 5)            */
#define SDMMC_EN_INT_STATUS_ERR_DATA_CRC_ERR_EN_Msk (0x20UL)            /*!< SDMMC EN_INT_STATUS_ERR: DATA_CRC_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_ERR_DATA_END_BIT_ERR_EN_Pos (6UL)           /*!< SDMMC EN_INT_STATUS_ERR: DATA_END_BIT_ERR_EN (Bit 6)        */
#define SDMMC_EN_INT_STATUS_ERR_DATA_END_BIT_ERR_EN_Msk (0x40UL)        /*!< SDMMC EN_INT_STATUS_ERR: DATA_END_BIT_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_ERR_CURRENT_LIMIT_ERR_EN_Pos (7UL)          /*!< SDMMC EN_INT_STATUS_ERR: CURRENT_LIMIT_ERR_EN (Bit 7)       */
#define SDMMC_EN_INT_STATUS_ERR_CURRENT_LIMIT_ERR_EN_Msk (0x80UL)       /*!< SDMMC EN_INT_STATUS_ERR: CURRENT_LIMIT_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_ERR_ACMD_ERR_EN_Pos (8UL)                   /*!< SDMMC EN_INT_STATUS_ERR: ACMD_ERR_EN (Bit 8)                */
#define SDMMC_EN_INT_STATUS_ERR_ACMD_ERR_EN_Msk (0x100UL)               /*!< SDMMC EN_INT_STATUS_ERR: ACMD_ERR_EN (Bitfield-Mask: 0x01)  */
#define SDMMC_EN_INT_STATUS_ERR_TARGET_RESP_ERR_EN_Pos (12UL)           /*!< SDMMC EN_INT_STATUS_ERR: TARGET_RESP_ERR_EN (Bit 12)        */
#define SDMMC_EN_INT_STATUS_ERR_TARGET_RESP_ERR_EN_Msk (0x1000UL)       /*!< SDMMC EN_INT_STATUS_ERR: TARGET_RESP_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_STATUS_ERR_CEATA_ERR_EN_Pos (13UL)                 /*!< SDMMC EN_INT_STATUS_ERR: CEATA_ERR_EN (Bit 13)              */
#define SDMMC_EN_INT_STATUS_ERR_CEATA_ERR_EN_Msk (0x2000UL)             /*!< SDMMC EN_INT_STATUS_ERR: CEATA_ERR_EN (Bitfield-Mask: 0x01) */

/* --------------------------  SDMMC_EN_INT_SIGNAL_NORM  -------------------------- */
#define SDMMC_EN_INT_SIGNAL_NORM_CMD_COMPLETE_EN_Pos (0UL)              /*!< SDMMC EN_INT_SIGNAL_NORM: CMD_COMPLETE_EN (Bit 0)           */
#define SDMMC_EN_INT_SIGNAL_NORM_CMD_COMPLETE_EN_Msk (0x1UL)            /*!< SDMMC EN_INT_SIGNAL_NORM: CMD_COMPLETE_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_NORM_TX_COMPLETE_EN_Pos (1UL)               /*!< SDMMC EN_INT_SIGNAL_NORM: TX_COMPLETE_EN (Bit 1)            */
#define SDMMC_EN_INT_SIGNAL_NORM_TX_COMPLETE_EN_Msk (0x2UL)             /*!< SDMMC EN_INT_SIGNAL_NORM: TX_COMPLETE_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_NORM_BLOCK_GAP_EVENT_EN_Pos (2UL)           /*!< SDMMC EN_INT_SIGNAL_NORM: BLOCK_GAP_EVENT_EN (Bit 2)        */
#define SDMMC_EN_INT_SIGNAL_NORM_BLOCK_GAP_EVENT_EN_Msk (0x4UL)         /*!< SDMMC EN_INT_SIGNAL_NORM: BLOCK_GAP_EVENT_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_NORM_BUFF_WRITE_READY_EN_Pos (4UL)          /*!< SDMMC EN_INT_SIGNAL_NORM: BUFF_WRITE_READY_EN (Bit 4)       */
#define SDMMC_EN_INT_SIGNAL_NORM_BUFF_WRITE_READY_EN_Msk (0x10UL)       /*!< SDMMC EN_INT_SIGNAL_NORM: BUFF_WRITE_READY_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_NORM_BUFF_READ_READY_EN_Pos (5UL)           /*!< SDMMC EN_INT_SIGNAL_NORM: BUFF_READ_READY_EN (Bit 5)        */
#define SDMMC_EN_INT_SIGNAL_NORM_BUFF_READ_READY_EN_Msk (0x20UL)        /*!< SDMMC EN_INT_SIGNAL_NORM: BUFF_READ_READY_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_NORM_CARD_INS_EN_Pos (6UL)                  /*!< SDMMC EN_INT_SIGNAL_NORM: CARD_INS_EN (Bit 6)               */
#define SDMMC_EN_INT_SIGNAL_NORM_CARD_INS_EN_Msk (0x40UL)               /*!< SDMMC EN_INT_SIGNAL_NORM: CARD_INS_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_NORM_CARD_REMOVAL_EN_Pos (7UL)              /*!< SDMMC EN_INT_SIGNAL_NORM: CARD_REMOVAL_EN (Bit 7)           */
#define SDMMC_EN_INT_SIGNAL_NORM_CARD_REMOVAL_EN_Msk (0x80UL)           /*!< SDMMC EN_INT_SIGNAL_NORM: CARD_REMOVAL_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_NORM_CARD_INT_EN_Pos (8UL)                  /*!< SDMMC EN_INT_SIGNAL_NORM: CARD_INT_EN (Bit 8)               */
#define SDMMC_EN_INT_SIGNAL_NORM_CARD_INT_EN_Msk (0x100UL)              /*!< SDMMC EN_INT_SIGNAL_NORM: CARD_INT_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_NORM_FIXED_TO_0_Pos (15UL)                  /*!< SDMMC EN_INT_SIGNAL_NORM: FIXED_TO_0 (Bit 15)               */
#define SDMMC_EN_INT_SIGNAL_NORM_FIXED_TO_0_Msk (0x8000UL)              /*!< SDMMC EN_INT_SIGNAL_NORM: FIXED_TO_0 (Bitfield-Mask: 0x01)  */

/* ---------------------------  SDMMC_EN_INT_SIGNAL_ERR  -------------------------- */
#define SDMMC_EN_INT_SIGNAL_ERR_CMD_TIMEOUT_ERR_EN_Pos (0UL)            /*!< SDMMC EN_INT_SIGNAL_ERR: CMD_TIMEOUT_ERR_EN (Bit 0)         */
#define SDMMC_EN_INT_SIGNAL_ERR_CMD_TIMEOUT_ERR_EN_Msk (0x1UL)          /*!< SDMMC EN_INT_SIGNAL_ERR: CMD_TIMEOUT_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_ERR_CMD_CRC_ERR_EN_Pos (1UL)                /*!< SDMMC EN_INT_SIGNAL_ERR: CMD_CRC_ERR_EN (Bit 1)             */
#define SDMMC_EN_INT_SIGNAL_ERR_CMD_CRC_ERR_EN_Msk (0x2UL)              /*!< SDMMC EN_INT_SIGNAL_ERR: CMD_CRC_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_ERR_CMD_END_BIT_ERR_EN_Pos (2UL)            /*!< SDMMC EN_INT_SIGNAL_ERR: CMD_END_BIT_ERR_EN (Bit 2)         */
#define SDMMC_EN_INT_SIGNAL_ERR_CMD_END_BIT_ERR_EN_Msk (0x4UL)          /*!< SDMMC EN_INT_SIGNAL_ERR: CMD_END_BIT_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_ERR_CMD_IND_ERR_EN_Pos (3UL)                /*!< SDMMC EN_INT_SIGNAL_ERR: CMD_IND_ERR_EN (Bit 3)             */
#define SDMMC_EN_INT_SIGNAL_ERR_CMD_IND_ERR_EN_Msk (0x8UL)              /*!< SDMMC EN_INT_SIGNAL_ERR: CMD_IND_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_ERR_DATA_TIMEOUT_ERR_EN_Pos (4UL)           /*!< SDMMC EN_INT_SIGNAL_ERR: DATA_TIMEOUT_ERR_EN (Bit 4)        */
#define SDMMC_EN_INT_SIGNAL_ERR_DATA_TIMEOUT_ERR_EN_Msk (0x10UL)        /*!< SDMMC EN_INT_SIGNAL_ERR: DATA_TIMEOUT_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_ERR_DATA_CRC_ERR_EN_Pos (5UL)               /*!< SDMMC EN_INT_SIGNAL_ERR: DATA_CRC_ERR_EN (Bit 5)            */
#define SDMMC_EN_INT_SIGNAL_ERR_DATA_CRC_ERR_EN_Msk (0x20UL)            /*!< SDMMC EN_INT_SIGNAL_ERR: DATA_CRC_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_ERR_DATA_END_BIT_ERR_EN_Pos (6UL)           /*!< SDMMC EN_INT_SIGNAL_ERR: DATA_END_BIT_ERR_EN (Bit 6)        */
#define SDMMC_EN_INT_SIGNAL_ERR_DATA_END_BIT_ERR_EN_Msk (0x40UL)        /*!< SDMMC EN_INT_SIGNAL_ERR: DATA_END_BIT_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_ERR_CURRENT_LIMIT_ERR_EN_Pos (7UL)          /*!< SDMMC EN_INT_SIGNAL_ERR: CURRENT_LIMIT_ERR_EN (Bit 7)       */
#define SDMMC_EN_INT_SIGNAL_ERR_CURRENT_LIMIT_ERR_EN_Msk (0x80UL)       /*!< SDMMC EN_INT_SIGNAL_ERR: CURRENT_LIMIT_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_ERR_ACMD_ERR_EN_Pos (8UL)                   /*!< SDMMC EN_INT_SIGNAL_ERR: ACMD_ERR_EN (Bit 8)                */
#define SDMMC_EN_INT_SIGNAL_ERR_ACMD_ERR_EN_Msk (0x100UL)               /*!< SDMMC EN_INT_SIGNAL_ERR: ACMD_ERR_EN (Bitfield-Mask: 0x01)  */
#define SDMMC_EN_INT_SIGNAL_ERR_TARGET_RESP_ERR_EN_Pos (12UL)           /*!< SDMMC EN_INT_SIGNAL_ERR: TARGET_RESP_ERR_EN (Bit 12)        */
#define SDMMC_EN_INT_SIGNAL_ERR_TARGET_RESP_ERR_EN_Msk (0x1000UL)       /*!< SDMMC EN_INT_SIGNAL_ERR: TARGET_RESP_ERR_EN (Bitfield-Mask: 0x01) */
#define SDMMC_EN_INT_SIGNAL_ERR_CEATA_ERR_EN_Pos (13UL)                 /*!< SDMMC EN_INT_SIGNAL_ERR: CEATA_ERR_EN (Bit 13)              */
#define SDMMC_EN_INT_SIGNAL_ERR_CEATA_ERR_EN_Msk (0x2000UL)             /*!< SDMMC EN_INT_SIGNAL_ERR: CEATA_ERR_EN (Bitfield-Mask: 0x01) */

/* ----------------------------  SDMMC_ACMD_ERR_STATUS  --------------------------- */
#define SDMMC_ACMD_ERR_STATUS_ACMD12_NOT_EXEC_ERR_Pos (0UL)             /*!< SDMMC ACMD_ERR_STATUS: ACMD12_NOT_EXEC_ERR (Bit 0)          */
#define SDMMC_ACMD_ERR_STATUS_ACMD12_NOT_EXEC_ERR_Msk (0x1UL)           /*!< SDMMC ACMD_ERR_STATUS: ACMD12_NOT_EXEC_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_ACMD_ERR_STATUS_ACMD_TIMEOUT_ERR_Pos (1UL)                /*!< SDMMC ACMD_ERR_STATUS: ACMD_TIMEOUT_ERR (Bit 1)             */
#define SDMMC_ACMD_ERR_STATUS_ACMD_TIMEOUT_ERR_Msk (0x2UL)              /*!< SDMMC ACMD_ERR_STATUS: ACMD_TIMEOUT_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_ACMD_ERR_STATUS_ACMD_CRC_ERR_Pos (2UL)                    /*!< SDMMC ACMD_ERR_STATUS: ACMD_CRC_ERR (Bit 2)                 */
#define SDMMC_ACMD_ERR_STATUS_ACMD_CRC_ERR_Msk (0x4UL)                  /*!< SDMMC ACMD_ERR_STATUS: ACMD_CRC_ERR (Bitfield-Mask: 0x01)   */
#define SDMMC_ACMD_ERR_STATUS_ACMD_END_BIT_ERR_Pos (3UL)                /*!< SDMMC ACMD_ERR_STATUS: ACMD_END_BIT_ERR (Bit 3)             */
#define SDMMC_ACMD_ERR_STATUS_ACMD_END_BIT_ERR_Msk (0x8UL)              /*!< SDMMC ACMD_ERR_STATUS: ACMD_END_BIT_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_ACMD_ERR_STATUS_ACMD_IND_ERR_Pos (4UL)                    /*!< SDMMC ACMD_ERR_STATUS: ACMD_IND_ERR (Bit 4)                 */
#define SDMMC_ACMD_ERR_STATUS_ACMD_IND_ERR_Msk (0x10UL)                 /*!< SDMMC ACMD_ERR_STATUS: ACMD_IND_ERR (Bitfield-Mask: 0x01)   */
#define SDMMC_ACMD_ERR_STATUS_CMD_NOT_ISSUED_BY_ACMD12_ERR_Pos (7UL)    /*!< SDMMC ACMD_ERR_STATUS: CMD_NOT_ISSUED_BY_ACMD12_ERR (Bit 7) */
#define SDMMC_ACMD_ERR_STATUS_CMD_NOT_ISSUED_BY_ACMD12_ERR_Msk (0x80UL) /*!< SDMMC ACMD_ERR_STATUS: CMD_NOT_ISSUED_BY_ACMD12_ERR (Bitfield-Mask: 0x01) */

/* -----------------------------  SDMMC_CAPABILITIES  ----------------------------- */
#define SDMMC_CAPABILITIES_TIMEOUT_CLOCK_FREQ_Pos (0UL)                 /*!< SDMMC CAPABILITIES: TIMEOUT_CLOCK_FREQ (Bit 0)              */
#define SDMMC_CAPABILITIES_TIMEOUT_CLOCK_FREQ_Msk (0x3fUL)              /*!< SDMMC CAPABILITIES: TIMEOUT_CLOCK_FREQ (Bitfield-Mask: 0x3f) */
#define SDMMC_CAPABILITIES_TIMEOUT_CLOCK_UNIT_Pos (7UL)                 /*!< SDMMC CAPABILITIES: TIMEOUT_CLOCK_UNIT (Bit 7)              */
#define SDMMC_CAPABILITIES_TIMEOUT_CLOCK_UNIT_Msk (0x80UL)              /*!< SDMMC CAPABILITIES: TIMEOUT_CLOCK_UNIT (Bitfield-Mask: 0x01) */
#define SDMMC_CAPABILITIES_BASE_SD_CLOCK_FREQ_Pos (8UL)                 /*!< SDMMC CAPABILITIES: BASE_SD_CLOCK_FREQ (Bit 8)              */
#define SDMMC_CAPABILITIES_BASE_SD_CLOCK_FREQ_Msk (0xff00UL)            /*!< SDMMC CAPABILITIES: BASE_SD_CLOCK_FREQ (Bitfield-Mask: 0xff) */
#define SDMMC_CAPABILITIES_MAX_BLOCK_LENGTH_Pos (16UL)                  /*!< SDMMC CAPABILITIES: MAX_BLOCK_LENGTH (Bit 16)               */
#define SDMMC_CAPABILITIES_MAX_BLOCK_LENGTH_Msk (0x30000UL)             /*!< SDMMC CAPABILITIES: MAX_BLOCK_LENGTH (Bitfield-Mask: 0x03)  */
#define SDMMC_CAPABILITIES_EXT_MEDIA_BUS_SUPPORT_Pos (18UL)             /*!< SDMMC CAPABILITIES: EXT_MEDIA_BUS_SUPPORT (Bit 18)          */
#define SDMMC_CAPABILITIES_EXT_MEDIA_BUS_SUPPORT_Msk (0x40000UL)        /*!< SDMMC CAPABILITIES: EXT_MEDIA_BUS_SUPPORT (Bitfield-Mask: 0x01) */
#define SDMMC_CAPABILITIES_ADMA2_SUPPORT_Pos  (19UL)                    /*!< SDMMC CAPABILITIES: ADMA2_SUPPORT (Bit 19)                  */
#define SDMMC_CAPABILITIES_ADMA2_SUPPORT_Msk  (0x80000UL)               /*!< SDMMC CAPABILITIES: ADMA2_SUPPORT (Bitfield-Mask: 0x01)     */
#define SDMMC_CAPABILITIES_HIGH_SPEED_SUPPORT_Pos (21UL)                /*!< SDMMC CAPABILITIES: HIGH_SPEED_SUPPORT (Bit 21)             */
#define SDMMC_CAPABILITIES_HIGH_SPEED_SUPPORT_Msk (0x200000UL)          /*!< SDMMC CAPABILITIES: HIGH_SPEED_SUPPORT (Bitfield-Mask: 0x01) */
#define SDMMC_CAPABILITIES_SDMA_SUPPORT_Pos   (22UL)                    /*!< SDMMC CAPABILITIES: SDMA_SUPPORT (Bit 22)                   */
#define SDMMC_CAPABILITIES_SDMA_SUPPORT_Msk   (0x400000UL)              /*!< SDMMC CAPABILITIES: SDMA_SUPPORT (Bitfield-Mask: 0x01)      */
#define SDMMC_CAPABILITIES_SUSPEND_RESUME_SUPPORT_Pos (23UL)            /*!< SDMMC CAPABILITIES: SUSPEND_RESUME_SUPPORT (Bit 23)         */
#define SDMMC_CAPABILITIES_SUSPEND_RESUME_SUPPORT_Msk (0x800000UL)      /*!< SDMMC CAPABILITIES: SUSPEND_RESUME_SUPPORT (Bitfield-Mask: 0x01) */
#define SDMMC_CAPABILITIES_VOLTAGE_SUPPORT_3_3V_Pos (24UL)              /*!< SDMMC CAPABILITIES: VOLTAGE_SUPPORT_3_3V (Bit 24)           */
#define SDMMC_CAPABILITIES_VOLTAGE_SUPPORT_3_3V_Msk (0x1000000UL)       /*!< SDMMC CAPABILITIES: VOLTAGE_SUPPORT_3_3V (Bitfield-Mask: 0x01) */
#define SDMMC_CAPABILITIES_VOLTAGE_SUPPORT_3V_Pos (25UL)                /*!< SDMMC CAPABILITIES: VOLTAGE_SUPPORT_3V (Bit 25)             */
#define SDMMC_CAPABILITIES_VOLTAGE_SUPPORT_3V_Msk (0x2000000UL)         /*!< SDMMC CAPABILITIES: VOLTAGE_SUPPORT_3V (Bitfield-Mask: 0x01) */
#define SDMMC_CAPABILITIES_VOLTAGE_SUPPORT_1_8V_Pos (26UL)              /*!< SDMMC CAPABILITIES: VOLTAGE_SUPPORT_1_8V (Bit 26)           */
#define SDMMC_CAPABILITIES_VOLTAGE_SUPPORT_1_8V_Msk (0x4000000UL)       /*!< SDMMC CAPABILITIES: VOLTAGE_SUPPORT_1_8V (Bitfield-Mask: 0x01) */
#define SDMMC_CAPABILITIES_SYSBUS_64_SUPPORT_Pos (28UL)                 /*!< SDMMC CAPABILITIES: SYSBUS_64_SUPPORT (Bit 28)              */
#define SDMMC_CAPABILITIES_SYSBUS_64_SUPPORT_Msk (0x10000000UL)         /*!< SDMMC CAPABILITIES: SYSBUS_64_SUPPORT (Bitfield-Mask: 0x01) */
#define SDMMC_CAPABILITIES_ASYNC_INT_SUPPORT_Pos (29UL)                 /*!< SDMMC CAPABILITIES: ASYNC_INT_SUPPORT (Bit 29)              */
#define SDMMC_CAPABILITIES_ASYNC_INT_SUPPORT_Msk (0x20000000UL)         /*!< SDMMC CAPABILITIES: ASYNC_INT_SUPPORT (Bitfield-Mask: 0x01) */
#define SDMMC_CAPABILITIES_SLOT_TYPE_Pos      (30UL)                    /*!< SDMMC CAPABILITIES: SLOT_TYPE (Bit 30)                      */
#define SDMMC_CAPABILITIES_SLOT_TYPE_Msk      (0xc0000000UL)            /*!< SDMMC CAPABILITIES: SLOT_TYPE (Bitfield-Mask: 0x03)         */

/* ----------------------------  SDMMC_CAPABILITIES_HI  --------------------------- */
#define SDMMC_CAPABILITIES_HI_SDR50_SUPPORT_Pos (0UL)                   /*!< SDMMC CAPABILITIES_HI: SDR50_SUPPORT (Bit 0)                */
#define SDMMC_CAPABILITIES_HI_SDR50_SUPPORT_Msk (0x1UL)                 /*!< SDMMC CAPABILITIES_HI: SDR50_SUPPORT (Bitfield-Mask: 0x01)  */
#define SDMMC_CAPABILITIES_HI_SDR104_SUPPORT_Pos (1UL)                  /*!< SDMMC CAPABILITIES_HI: SDR104_SUPPORT (Bit 1)               */
#define SDMMC_CAPABILITIES_HI_SDR104_SUPPORT_Msk (0x2UL)                /*!< SDMMC CAPABILITIES_HI: SDR104_SUPPORT (Bitfield-Mask: 0x01) */
#define SDMMC_CAPABILITIES_HI_DDR50_SUPPORT_Pos (2UL)                   /*!< SDMMC CAPABILITIES_HI: DDR50_SUPPORT (Bit 2)                */
#define SDMMC_CAPABILITIES_HI_DDR50_SUPPORT_Msk (0x4UL)                 /*!< SDMMC CAPABILITIES_HI: DDR50_SUPPORT (Bitfield-Mask: 0x01)  */
#define SDMMC_CAPABILITIES_HI_DRV_A_SUPPORT_Pos (4UL)                   /*!< SDMMC CAPABILITIES_HI: DRV_A_SUPPORT (Bit 4)                */
#define SDMMC_CAPABILITIES_HI_DRV_A_SUPPORT_Msk (0x10UL)                /*!< SDMMC CAPABILITIES_HI: DRV_A_SUPPORT (Bitfield-Mask: 0x01)  */
#define SDMMC_CAPABILITIES_HI_DRV_C_SUPPORT_Pos (5UL)                   /*!< SDMMC CAPABILITIES_HI: DRV_C_SUPPORT (Bit 5)                */
#define SDMMC_CAPABILITIES_HI_DRV_C_SUPPORT_Msk (0x20UL)                /*!< SDMMC CAPABILITIES_HI: DRV_C_SUPPORT (Bitfield-Mask: 0x01)  */
#define SDMMC_CAPABILITIES_HI_DRV_D_SUPPORT_Pos (6UL)                   /*!< SDMMC CAPABILITIES_HI: DRV_D_SUPPORT (Bit 6)                */
#define SDMMC_CAPABILITIES_HI_DRV_D_SUPPORT_Msk (0x40UL)                /*!< SDMMC CAPABILITIES_HI: DRV_D_SUPPORT (Bitfield-Mask: 0x01)  */
#define SDMMC_CAPABILITIES_HI_TIM_CNT_RETUNE_Pos (8UL)                  /*!< SDMMC CAPABILITIES_HI: TIM_CNT_RETUNE (Bit 8)               */
#define SDMMC_CAPABILITIES_HI_TIM_CNT_RETUNE_Msk (0xf00UL)              /*!< SDMMC CAPABILITIES_HI: TIM_CNT_RETUNE (Bitfield-Mask: 0x0f) */
#define SDMMC_CAPABILITIES_HI_USE_TUNING_SDR50_Pos (13UL)               /*!< SDMMC CAPABILITIES_HI: USE_TUNING_SDR50 (Bit 13)            */
#define SDMMC_CAPABILITIES_HI_USE_TUNING_SDR50_Msk (0x2000UL)           /*!< SDMMC CAPABILITIES_HI: USE_TUNING_SDR50 (Bitfield-Mask: 0x01) */
#define SDMMC_CAPABILITIES_HI_RE_TUNING_MODES_Pos (14UL)                /*!< SDMMC CAPABILITIES_HI: RE_TUNING_MODES (Bit 14)             */
#define SDMMC_CAPABILITIES_HI_RE_TUNING_MODES_Msk (0xc000UL)            /*!< SDMMC CAPABILITIES_HI: RE_TUNING_MODES (Bitfield-Mask: 0x03) */
#define SDMMC_CAPABILITIES_HI_CLK_MULT_Pos    (16UL)                    /*!< SDMMC CAPABILITIES_HI: CLK_MULT (Bit 16)                    */
#define SDMMC_CAPABILITIES_HI_CLK_MULT_Msk    (0xff0000UL)              /*!< SDMMC CAPABILITIES_HI: CLK_MULT (Bitfield-Mask: 0xff)       */

/* ----------------------------  SDMMC_MAX_CURRENT_CAP  --------------------------- */
#define SDMMC_MAX_CURRENT_CAP_MAX_CURRENT_FOR_3_3V_Pos (0UL)            /*!< SDMMC MAX_CURRENT_CAP: MAX_CURRENT_FOR_3_3V (Bit 0)         */
#define SDMMC_MAX_CURRENT_CAP_MAX_CURRENT_FOR_3_3V_Msk (0xffUL)         /*!< SDMMC MAX_CURRENT_CAP: MAX_CURRENT_FOR_3_3V (Bitfield-Mask: 0xff) */

/* ----------------------  SDMMC_FORCE_EVENT_ACMD_ERR_STATUS  --------------------- */
#define SDMMC_FORCE_EVENT_ACMD_ERR_STATUS_FE_ACMD_NOT_EXEC_Pos (0UL)    /*!< SDMMC FORCE_EVENT_ACMD_ERR_STATUS: FE_ACMD_NOT_EXEC (Bit 0) */
#define SDMMC_FORCE_EVENT_ACMD_ERR_STATUS_FE_ACMD_NOT_EXEC_Msk (0x1UL)  /*!< SDMMC FORCE_EVENT_ACMD_ERR_STATUS: FE_ACMD_NOT_EXEC (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ACMD_ERR_STATUS_FE_ACMD_TIMEOUT_ERR_Pos (1UL) /*!< SDMMC FORCE_EVENT_ACMD_ERR_STATUS: FE_ACMD_TIMEOUT_ERR (Bit 1) */
#define SDMMC_FORCE_EVENT_ACMD_ERR_STATUS_FE_ACMD_TIMEOUT_ERR_Msk (0x2UL) /*!< SDMMC FORCE_EVENT_ACMD_ERR_STATUS: FE_ACMD_TIMEOUT_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ACMD_ERR_STATUS_FE_ACMD_CRC_ERR_Pos (2UL)     /*!< SDMMC FORCE_EVENT_ACMD_ERR_STATUS: FE_ACMD_CRC_ERR (Bit 2)  */
#define SDMMC_FORCE_EVENT_ACMD_ERR_STATUS_FE_ACMD_CRC_ERR_Msk (0x4UL)   /*!< SDMMC FORCE_EVENT_ACMD_ERR_STATUS: FE_ACMD_CRC_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ACMD_ERR_STATUS_FE_ACMD_END_BIT_ERR_Pos (3UL) /*!< SDMMC FORCE_EVENT_ACMD_ERR_STATUS: FE_ACMD_END_BIT_ERR (Bit 3) */
#define SDMMC_FORCE_EVENT_ACMD_ERR_STATUS_FE_ACMD_END_BIT_ERR_Msk (0x8UL) /*!< SDMMC FORCE_EVENT_ACMD_ERR_STATUS: FE_ACMD_END_BIT_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ACMD_ERR_STATUS_FE_ACMD_IND_ERR_Pos (4UL)     /*!< SDMMC FORCE_EVENT_ACMD_ERR_STATUS: FE_ACMD_IND_ERR (Bit 4)  */
#define SDMMC_FORCE_EVENT_ACMD_ERR_STATUS_FE_ACMD_IND_ERR_Msk (0x10UL)  /*!< SDMMC FORCE_EVENT_ACMD_ERR_STATUS: FE_ACMD_IND_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ACMD_ERR_STATUS_FE_CMD_NOT_ISSUED_ACMD12_ERR_Pos (7UL) /*!< SDMMC FORCE_EVENT_ACMD_ERR_STATUS: FE_CMD_NOT_ISSUED_ACMD12_ERR (Bit 7) */
#define SDMMC_FORCE_EVENT_ACMD_ERR_STATUS_FE_CMD_NOT_ISSUED_ACMD12_ERR_Msk (0x80UL) /*!< SDMMC FORCE_EVENT_ACMD_ERR_STATUS: FE_CMD_NOT_ISSUED_ACMD12_ERR (Bitfield-Mask: 0x01) */

/* ------------------------  SDMMC_FORCE_EVENT_ERR_STATUS  ------------------------ */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_CMD_TIMEOUT_ERR_Pos (0UL)       /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_CMD_TIMEOUT_ERR (Bit 0)    */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_CMD_TIMEOUT_ERR_Msk (0x1UL)     /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_CMD_TIMEOUT_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_CMD_CRC_ERR_Pos (1UL)           /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_CMD_CRC_ERR (Bit 1)        */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_CMD_CRC_ERR_Msk (0x2UL)         /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_CMD_CRC_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_CMD_END_BIT_ERR_Pos (2UL)       /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_CMD_END_BIT_ERR (Bit 2)    */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_CMD_END_BIT_ERR_Msk (0x4UL)     /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_CMD_END_BIT_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_CMD_IND_ERR_Pos (3UL)           /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_CMD_IND_ERR (Bit 3)        */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_CMD_IND_ERR_Msk (0x8UL)         /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_CMD_IND_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_DATA_TIMEOUT_ERR_Pos (4UL)      /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_DATA_TIMEOUT_ERR (Bit 4)   */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_DATA_TIMEOUT_ERR_Msk (0x10UL)   /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_DATA_TIMEOUT_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_DATA_CRC_ERR_Pos (5UL)          /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_DATA_CRC_ERR (Bit 5)       */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_DATA_CRC_ERR_Msk (0x20UL)       /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_DATA_CRC_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_DATA_END_BIT_ERR_Pos (6UL)      /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_DATA_END_BIT_ERR (Bit 6)   */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_DATA_END_BIT_ERR_Msk (0x40UL)   /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_DATA_END_BIT_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_CURRENT_LIMIT_ERR_Pos (7UL)     /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_CURRENT_LIMIT_ERR (Bit 7)  */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_CURRENT_LIMIT_ERR_Msk (0x80UL)  /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_CURRENT_LIMIT_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_ACMD12_ERR_Pos (8UL)            /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_ACMD12_ERR (Bit 8)         */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_ACMD12_ERR_Msk (0x100UL)        /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_ACMD12_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_TARGET_RESPONSE_ERR_Pos (12UL)  /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_TARGET_RESPONSE_ERR (Bit 12) */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_TARGET_RESPONSE_ERR_Msk (0x1000UL) /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_TARGET_RESPONSE_ERR (Bitfield-Mask: 0x01) */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_CEATA_ERR_Pos (13UL)            /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_CEATA_ERR (Bit 13)         */
#define SDMMC_FORCE_EVENT_ERR_STATUS_FE_CEATA_ERR_Msk (0x2000UL)        /*!< SDMMC FORCE_EVENT_ERR_STATUS: FE_CEATA_ERR (Bitfield-Mask: 0x01) */

/* -------------------------------  SDMMC_DEBUG_SEL  ------------------------------ */
#define SDMMC_DEBUG_SEL_DEBUG_SEL_Pos         (0UL)                     /*!< SDMMC DEBUG_SEL: DEBUG_SEL (Bit 0)                          */
#define SDMMC_DEBUG_SEL_DEBUG_SEL_Msk         (0x1UL)                   /*!< SDMMC DEBUG_SEL: DEBUG_SEL (Bitfield-Mask: 0x01)            */

/* ----------------------------------  SDMMC_SPI  --------------------------------- */
#define SDMMC_SPI_SPI_INT_SUPPORT_Pos         (0UL)                     /*!< SDMMC SPI: SPI_INT_SUPPORT (Bit 0)                          */
#define SDMMC_SPI_SPI_INT_SUPPORT_Msk         (0xffUL)                  /*!< SDMMC SPI: SPI_INT_SUPPORT (Bitfield-Mask: 0xff)            */

/* ----------------------------  SDMMC_SLOT_INT_STATUS  --------------------------- */
#define SDMMC_SLOT_INT_STATUS_SLOT_INT_STATUS_Pos (0UL)                 /*!< SDMMC SLOT_INT_STATUS: SLOT_INT_STATUS (Bit 0)              */
#define SDMMC_SLOT_INT_STATUS_SLOT_INT_STATUS_Msk (0xffUL)              /*!< SDMMC SLOT_INT_STATUS: SLOT_INT_STATUS (Bitfield-Mask: 0xff) */


/* ================================================================================ */
/* ================          struct 'EBU' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  EBU_CLC  ---------------------------------- */
#define EBU_CLC_DISR_Pos                      (0UL)                     /*!< EBU CLC: DISR (Bit 0)                                       */
#define EBU_CLC_DISR_Msk                      (0x1UL)                   /*!< EBU CLC: DISR (Bitfield-Mask: 0x01)                         */
#define EBU_CLC_DISS_Pos                      (1UL)                     /*!< EBU CLC: DISS (Bit 1)                                       */
#define EBU_CLC_DISS_Msk                      (0x2UL)                   /*!< EBU CLC: DISS (Bitfield-Mask: 0x01)                         */
#define EBU_CLC_SYNC_Pos                      (16UL)                    /*!< EBU CLC: SYNC (Bit 16)                                      */
#define EBU_CLC_SYNC_Msk                      (0x10000UL)               /*!< EBU CLC: SYNC (Bitfield-Mask: 0x01)                         */
#define EBU_CLC_DIV2_Pos                      (17UL)                    /*!< EBU CLC: DIV2 (Bit 17)                                      */
#define EBU_CLC_DIV2_Msk                      (0x20000UL)               /*!< EBU CLC: DIV2 (Bitfield-Mask: 0x01)                         */
#define EBU_CLC_EBUDIV_Pos                    (18UL)                    /*!< EBU CLC: EBUDIV (Bit 18)                                    */
#define EBU_CLC_EBUDIV_Msk                    (0xc0000UL)               /*!< EBU CLC: EBUDIV (Bitfield-Mask: 0x03)                       */
#define EBU_CLC_SYNCACK_Pos                   (20UL)                    /*!< EBU CLC: SYNCACK (Bit 20)                                   */
#define EBU_CLC_SYNCACK_Msk                   (0x100000UL)              /*!< EBU CLC: SYNCACK (Bitfield-Mask: 0x01)                      */
#define EBU_CLC_DIV2ACK_Pos                   (21UL)                    /*!< EBU CLC: DIV2ACK (Bit 21)                                   */
#define EBU_CLC_DIV2ACK_Msk                   (0x200000UL)              /*!< EBU CLC: DIV2ACK (Bitfield-Mask: 0x01)                      */
#define EBU_CLC_EBUDIVACK_Pos                 (22UL)                    /*!< EBU CLC: EBUDIVACK (Bit 22)                                 */
#define EBU_CLC_EBUDIVACK_Msk                 (0xc00000UL)              /*!< EBU CLC: EBUDIVACK (Bitfield-Mask: 0x03)                    */

/* ---------------------------------  EBU_MODCON  --------------------------------- */
#define EBU_MODCON_STS_Pos                    (0UL)                     /*!< EBU MODCON: STS (Bit 0)                                     */
#define EBU_MODCON_STS_Msk                    (0x1UL)                   /*!< EBU MODCON: STS (Bitfield-Mask: 0x01)                       */
#define EBU_MODCON_LCKABRT_Pos                (1UL)                     /*!< EBU MODCON: LCKABRT (Bit 1)                                 */
#define EBU_MODCON_LCKABRT_Msk                (0x2UL)                   /*!< EBU MODCON: LCKABRT (Bitfield-Mask: 0x01)                   */
#define EBU_MODCON_SDTRI_Pos                  (2UL)                     /*!< EBU MODCON: SDTRI (Bit 2)                                   */
#define EBU_MODCON_SDTRI_Msk                  (0x4UL)                   /*!< EBU MODCON: SDTRI (Bitfield-Mask: 0x01)                     */
#define EBU_MODCON_EXTLOCK_Pos                (4UL)                     /*!< EBU MODCON: EXTLOCK (Bit 4)                                 */
#define EBU_MODCON_EXTLOCK_Msk                (0x10UL)                  /*!< EBU MODCON: EXTLOCK (Bitfield-Mask: 0x01)                   */
#define EBU_MODCON_ARBSYNC_Pos                (5UL)                     /*!< EBU MODCON: ARBSYNC (Bit 5)                                 */
#define EBU_MODCON_ARBSYNC_Msk                (0x20UL)                  /*!< EBU MODCON: ARBSYNC (Bitfield-Mask: 0x01)                   */
#define EBU_MODCON_ARBMODE_Pos                (6UL)                     /*!< EBU MODCON: ARBMODE (Bit 6)                                 */
#define EBU_MODCON_ARBMODE_Msk                (0xc0UL)                  /*!< EBU MODCON: ARBMODE (Bitfield-Mask: 0x03)                   */
#define EBU_MODCON_TIMEOUTC_Pos               (8UL)                     /*!< EBU MODCON: TIMEOUTC (Bit 8)                                */
#define EBU_MODCON_TIMEOUTC_Msk               (0xff00UL)                /*!< EBU MODCON: TIMEOUTC (Bitfield-Mask: 0xff)                  */
#define EBU_MODCON_LOCKTIMEOUT_Pos            (16UL)                    /*!< EBU MODCON: LOCKTIMEOUT (Bit 16)                            */
#define EBU_MODCON_LOCKTIMEOUT_Msk            (0xff0000UL)              /*!< EBU MODCON: LOCKTIMEOUT (Bitfield-Mask: 0xff)               */
#define EBU_MODCON_GLOBALCS_Pos               (24UL)                    /*!< EBU MODCON: GLOBALCS (Bit 24)                               */
#define EBU_MODCON_GLOBALCS_Msk               (0xf000000UL)             /*!< EBU MODCON: GLOBALCS (Bitfield-Mask: 0x0f)                  */
#define EBU_MODCON_ACCSINH_Pos                (28UL)                    /*!< EBU MODCON: ACCSINH (Bit 28)                                */
#define EBU_MODCON_ACCSINH_Msk                (0x10000000UL)            /*!< EBU MODCON: ACCSINH (Bitfield-Mask: 0x01)                   */
#define EBU_MODCON_ACCSINHACK_Pos             (29UL)                    /*!< EBU MODCON: ACCSINHACK (Bit 29)                             */
#define EBU_MODCON_ACCSINHACK_Msk             (0x20000000UL)            /*!< EBU MODCON: ACCSINHACK (Bitfield-Mask: 0x01)                */
#define EBU_MODCON_ALE_Pos                    (31UL)                    /*!< EBU MODCON: ALE (Bit 31)                                    */
#define EBU_MODCON_ALE_Msk                    (0x80000000UL)            /*!< EBU MODCON: ALE (Bitfield-Mask: 0x01)                       */

/* -----------------------------------  EBU_ID  ----------------------------------- */
#define EBU_ID_MOD_REV_Pos                    (0UL)                     /*!< EBU ID: MOD_REV (Bit 0)                                     */
#define EBU_ID_MOD_REV_Msk                    (0xffUL)                  /*!< EBU ID: MOD_REV (Bitfield-Mask: 0xff)                       */
#define EBU_ID_MOD_TYPE_Pos                   (8UL)                     /*!< EBU ID: MOD_TYPE (Bit 8)                                    */
#define EBU_ID_MOD_TYPE_Msk                   (0xff00UL)                /*!< EBU ID: MOD_TYPE (Bitfield-Mask: 0xff)                      */
#define EBU_ID_MOD_NUMBER_Pos                 (16UL)                    /*!< EBU ID: MOD_NUMBER (Bit 16)                                 */
#define EBU_ID_MOD_NUMBER_Msk                 (0xffff0000UL)            /*!< EBU ID: MOD_NUMBER (Bitfield-Mask: 0xffff)                  */

/* ---------------------------------  EBU_USERCON  -------------------------------- */
#define EBU_USERCON_DIP_Pos                   (0UL)                     /*!< EBU USERCON: DIP (Bit 0)                                    */
#define EBU_USERCON_DIP_Msk                   (0x1UL)                   /*!< EBU USERCON: DIP (Bitfield-Mask: 0x01)                      */
#define EBU_USERCON_ADDIO_Pos                 (16UL)                    /*!< EBU USERCON: ADDIO (Bit 16)                                 */
#define EBU_USERCON_ADDIO_Msk                 (0x1ff0000UL)             /*!< EBU USERCON: ADDIO (Bitfield-Mask: 0x1ff)                   */
#define EBU_USERCON_ADVIO_Pos                 (25UL)                    /*!< EBU USERCON: ADVIO (Bit 25)                                 */
#define EBU_USERCON_ADVIO_Msk                 (0x2000000UL)             /*!< EBU USERCON: ADVIO (Bitfield-Mask: 0x01)                    */

/* --------------------------------  EBU_ADDRSEL0  -------------------------------- */
#define EBU_ADDRSEL0_REGENAB_Pos              (0UL)                     /*!< EBU ADDRSEL0: REGENAB (Bit 0)                               */
#define EBU_ADDRSEL0_REGENAB_Msk              (0x1UL)                   /*!< EBU ADDRSEL0: REGENAB (Bitfield-Mask: 0x01)                 */
#define EBU_ADDRSEL0_ALTENAB_Pos              (1UL)                     /*!< EBU ADDRSEL0: ALTENAB (Bit 1)                               */
#define EBU_ADDRSEL0_ALTENAB_Msk              (0x2UL)                   /*!< EBU ADDRSEL0: ALTENAB (Bitfield-Mask: 0x01)                 */
#define EBU_ADDRSEL0_WPROT_Pos                (2UL)                     /*!< EBU ADDRSEL0: WPROT (Bit 2)                                 */
#define EBU_ADDRSEL0_WPROT_Msk                (0x4UL)                   /*!< EBU ADDRSEL0: WPROT (Bitfield-Mask: 0x01)                   */

/* --------------------------------  EBU_ADDRSEL1  -------------------------------- */
#define EBU_ADDRSEL1_REGENAB_Pos              (0UL)                     /*!< EBU ADDRSEL1: REGENAB (Bit 0)                               */
#define EBU_ADDRSEL1_REGENAB_Msk              (0x1UL)                   /*!< EBU ADDRSEL1: REGENAB (Bitfield-Mask: 0x01)                 */
#define EBU_ADDRSEL1_ALTENAB_Pos              (1UL)                     /*!< EBU ADDRSEL1: ALTENAB (Bit 1)                               */
#define EBU_ADDRSEL1_ALTENAB_Msk              (0x2UL)                   /*!< EBU ADDRSEL1: ALTENAB (Bitfield-Mask: 0x01)                 */
#define EBU_ADDRSEL1_WPROT_Pos                (2UL)                     /*!< EBU ADDRSEL1: WPROT (Bit 2)                                 */
#define EBU_ADDRSEL1_WPROT_Msk                (0x4UL)                   /*!< EBU ADDRSEL1: WPROT (Bitfield-Mask: 0x01)                   */

/* --------------------------------  EBU_ADDRSEL2  -------------------------------- */
#define EBU_ADDRSEL2_REGENAB_Pos              (0UL)                     /*!< EBU ADDRSEL2: REGENAB (Bit 0)                               */
#define EBU_ADDRSEL2_REGENAB_Msk              (0x1UL)                   /*!< EBU ADDRSEL2: REGENAB (Bitfield-Mask: 0x01)                 */
#define EBU_ADDRSEL2_ALTENAB_Pos              (1UL)                     /*!< EBU ADDRSEL2: ALTENAB (Bit 1)                               */
#define EBU_ADDRSEL2_ALTENAB_Msk              (0x2UL)                   /*!< EBU ADDRSEL2: ALTENAB (Bitfield-Mask: 0x01)                 */
#define EBU_ADDRSEL2_WPROT_Pos                (2UL)                     /*!< EBU ADDRSEL2: WPROT (Bit 2)                                 */
#define EBU_ADDRSEL2_WPROT_Msk                (0x4UL)                   /*!< EBU ADDRSEL2: WPROT (Bitfield-Mask: 0x01)                   */

/* --------------------------------  EBU_ADDRSEL3  -------------------------------- */
#define EBU_ADDRSEL3_REGENAB_Pos              (0UL)                     /*!< EBU ADDRSEL3: REGENAB (Bit 0)                               */
#define EBU_ADDRSEL3_REGENAB_Msk              (0x1UL)                   /*!< EBU ADDRSEL3: REGENAB (Bitfield-Mask: 0x01)                 */
#define EBU_ADDRSEL3_ALTENAB_Pos              (1UL)                     /*!< EBU ADDRSEL3: ALTENAB (Bit 1)                               */
#define EBU_ADDRSEL3_ALTENAB_Msk              (0x2UL)                   /*!< EBU ADDRSEL3: ALTENAB (Bitfield-Mask: 0x01)                 */
#define EBU_ADDRSEL3_WPROT_Pos                (2UL)                     /*!< EBU ADDRSEL3: WPROT (Bit 2)                                 */
#define EBU_ADDRSEL3_WPROT_Msk                (0x4UL)                   /*!< EBU ADDRSEL3: WPROT (Bitfield-Mask: 0x01)                   */

/* --------------------------------  EBU_BUSRCON0  -------------------------------- */
#define EBU_BUSRCON0_FETBLEN_Pos              (0UL)                     /*!< EBU BUSRCON0: FETBLEN (Bit 0)                               */
#define EBU_BUSRCON0_FETBLEN_Msk              (0x7UL)                   /*!< EBU BUSRCON0: FETBLEN (Bitfield-Mask: 0x07)                 */
#define EBU_BUSRCON0_FBBMSEL_Pos              (3UL)                     /*!< EBU BUSRCON0: FBBMSEL (Bit 3)                               */
#define EBU_BUSRCON0_FBBMSEL_Msk              (0x8UL)                   /*!< EBU BUSRCON0: FBBMSEL (Bitfield-Mask: 0x01)                 */
#define EBU_BUSRCON0_BFSSS_Pos                (4UL)                     /*!< EBU BUSRCON0: BFSSS (Bit 4)                                 */
#define EBU_BUSRCON0_BFSSS_Msk                (0x10UL)                  /*!< EBU BUSRCON0: BFSSS (Bitfield-Mask: 0x01)                   */
#define EBU_BUSRCON0_FDBKEN_Pos               (5UL)                     /*!< EBU BUSRCON0: FDBKEN (Bit 5)                                */
#define EBU_BUSRCON0_FDBKEN_Msk               (0x20UL)                  /*!< EBU BUSRCON0: FDBKEN (Bitfield-Mask: 0x01)                  */
#define EBU_BUSRCON0_BFCMSEL_Pos              (6UL)                     /*!< EBU BUSRCON0: BFCMSEL (Bit 6)                               */
#define EBU_BUSRCON0_BFCMSEL_Msk              (0x40UL)                  /*!< EBU BUSRCON0: BFCMSEL (Bitfield-Mask: 0x01)                 */
#define EBU_BUSRCON0_NAA_Pos                  (7UL)                     /*!< EBU BUSRCON0: NAA (Bit 7)                                   */
#define EBU_BUSRCON0_NAA_Msk                  (0x80UL)                  /*!< EBU BUSRCON0: NAA (Bitfield-Mask: 0x01)                     */
#define EBU_BUSRCON0_ECSE_Pos                 (16UL)                    /*!< EBU BUSRCON0: ECSE (Bit 16)                                 */
#define EBU_BUSRCON0_ECSE_Msk                 (0x10000UL)               /*!< EBU BUSRCON0: ECSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSRCON0_EBSE_Pos                 (17UL)                    /*!< EBU BUSRCON0: EBSE (Bit 17)                                 */
#define EBU_BUSRCON0_EBSE_Msk                 (0x20000UL)               /*!< EBU BUSRCON0: EBSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSRCON0_DBA_Pos                  (18UL)                    /*!< EBU BUSRCON0: DBA (Bit 18)                                  */
#define EBU_BUSRCON0_DBA_Msk                  (0x40000UL)               /*!< EBU BUSRCON0: DBA (Bitfield-Mask: 0x01)                     */
#define EBU_BUSRCON0_WAITINV_Pos              (19UL)                    /*!< EBU BUSRCON0: WAITINV (Bit 19)                              */
#define EBU_BUSRCON0_WAITINV_Msk              (0x80000UL)               /*!< EBU BUSRCON0: WAITINV (Bitfield-Mask: 0x01)                 */
#define EBU_BUSRCON0_BCGEN_Pos                (20UL)                    /*!< EBU BUSRCON0: BCGEN (Bit 20)                                */
#define EBU_BUSRCON0_BCGEN_Msk                (0x300000UL)              /*!< EBU BUSRCON0: BCGEN (Bitfield-Mask: 0x03)                   */
#define EBU_BUSRCON0_PORTW_Pos                (22UL)                    /*!< EBU BUSRCON0: PORTW (Bit 22)                                */
#define EBU_BUSRCON0_PORTW_Msk                (0xc00000UL)              /*!< EBU BUSRCON0: PORTW (Bitfield-Mask: 0x03)                   */
#define EBU_BUSRCON0_WAIT_Pos                 (24UL)                    /*!< EBU BUSRCON0: WAIT (Bit 24)                                 */
#define EBU_BUSRCON0_WAIT_Msk                 (0x3000000UL)             /*!< EBU BUSRCON0: WAIT (Bitfield-Mask: 0x03)                    */
#define EBU_BUSRCON0_AAP_Pos                  (26UL)                    /*!< EBU BUSRCON0: AAP (Bit 26)                                  */
#define EBU_BUSRCON0_AAP_Msk                  (0x4000000UL)             /*!< EBU BUSRCON0: AAP (Bitfield-Mask: 0x01)                     */
#define EBU_BUSRCON0_AGEN_Pos                 (28UL)                    /*!< EBU BUSRCON0: AGEN (Bit 28)                                 */
#define EBU_BUSRCON0_AGEN_Msk                 (0xf0000000UL)            /*!< EBU BUSRCON0: AGEN (Bitfield-Mask: 0x0f)                    */

/* ---------------------------------  EBU_BUSRAP0  -------------------------------- */
#define EBU_BUSRAP0_RDDTACS_Pos               (0UL)                     /*!< EBU BUSRAP0: RDDTACS (Bit 0)                                */
#define EBU_BUSRAP0_RDDTACS_Msk               (0xfUL)                   /*!< EBU BUSRAP0: RDDTACS (Bitfield-Mask: 0x0f)                  */
#define EBU_BUSRAP0_RDRECOVC_Pos              (4UL)                     /*!< EBU BUSRAP0: RDRECOVC (Bit 4)                               */
#define EBU_BUSRAP0_RDRECOVC_Msk              (0x70UL)                  /*!< EBU BUSRAP0: RDRECOVC (Bitfield-Mask: 0x07)                 */
#define EBU_BUSRAP0_WAITRDC_Pos               (7UL)                     /*!< EBU BUSRAP0: WAITRDC (Bit 7)                                */
#define EBU_BUSRAP0_WAITRDC_Msk               (0xf80UL)                 /*!< EBU BUSRAP0: WAITRDC (Bitfield-Mask: 0x1f)                  */
#define EBU_BUSRAP0_DATAC_Pos                 (12UL)                    /*!< EBU BUSRAP0: DATAC (Bit 12)                                 */
#define EBU_BUSRAP0_DATAC_Msk                 (0xf000UL)                /*!< EBU BUSRAP0: DATAC (Bitfield-Mask: 0x0f)                    */
#define EBU_BUSRAP0_EXTCLOCK_Pos              (16UL)                    /*!< EBU BUSRAP0: EXTCLOCK (Bit 16)                              */
#define EBU_BUSRAP0_EXTCLOCK_Msk              (0x30000UL)               /*!< EBU BUSRAP0: EXTCLOCK (Bitfield-Mask: 0x03)                 */
#define EBU_BUSRAP0_EXTDATA_Pos               (18UL)                    /*!< EBU BUSRAP0: EXTDATA (Bit 18)                               */
#define EBU_BUSRAP0_EXTDATA_Msk               (0xc0000UL)               /*!< EBU BUSRAP0: EXTDATA (Bitfield-Mask: 0x03)                  */
#define EBU_BUSRAP0_CMDDELAY_Pos              (20UL)                    /*!< EBU BUSRAP0: CMDDELAY (Bit 20)                              */
#define EBU_BUSRAP0_CMDDELAY_Msk              (0xf00000UL)              /*!< EBU BUSRAP0: CMDDELAY (Bitfield-Mask: 0x0f)                 */
#define EBU_BUSRAP0_AHOLDC_Pos                (24UL)                    /*!< EBU BUSRAP0: AHOLDC (Bit 24)                                */
#define EBU_BUSRAP0_AHOLDC_Msk                (0xf000000UL)             /*!< EBU BUSRAP0: AHOLDC (Bitfield-Mask: 0x0f)                   */
#define EBU_BUSRAP0_ADDRC_Pos                 (28UL)                    /*!< EBU BUSRAP0: ADDRC (Bit 28)                                 */
#define EBU_BUSRAP0_ADDRC_Msk                 (0xf0000000UL)            /*!< EBU BUSRAP0: ADDRC (Bitfield-Mask: 0x0f)                    */

/* --------------------------------  EBU_BUSWCON0  -------------------------------- */
#define EBU_BUSWCON0_FETBLEN_Pos              (0UL)                     /*!< EBU BUSWCON0: FETBLEN (Bit 0)                               */
#define EBU_BUSWCON0_FETBLEN_Msk              (0x7UL)                   /*!< EBU BUSWCON0: FETBLEN (Bitfield-Mask: 0x07)                 */
#define EBU_BUSWCON0_FBBMSEL_Pos              (3UL)                     /*!< EBU BUSWCON0: FBBMSEL (Bit 3)                               */
#define EBU_BUSWCON0_FBBMSEL_Msk              (0x8UL)                   /*!< EBU BUSWCON0: FBBMSEL (Bitfield-Mask: 0x01)                 */
#define EBU_BUSWCON0_NAA_Pos                  (7UL)                     /*!< EBU BUSWCON0: NAA (Bit 7)                                   */
#define EBU_BUSWCON0_NAA_Msk                  (0x80UL)                  /*!< EBU BUSWCON0: NAA (Bitfield-Mask: 0x01)                     */
#define EBU_BUSWCON0_ECSE_Pos                 (16UL)                    /*!< EBU BUSWCON0: ECSE (Bit 16)                                 */
#define EBU_BUSWCON0_ECSE_Msk                 (0x10000UL)               /*!< EBU BUSWCON0: ECSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSWCON0_EBSE_Pos                 (17UL)                    /*!< EBU BUSWCON0: EBSE (Bit 17)                                 */
#define EBU_BUSWCON0_EBSE_Msk                 (0x20000UL)               /*!< EBU BUSWCON0: EBSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSWCON0_WAITINV_Pos              (19UL)                    /*!< EBU BUSWCON0: WAITINV (Bit 19)                              */
#define EBU_BUSWCON0_WAITINV_Msk              (0x80000UL)               /*!< EBU BUSWCON0: WAITINV (Bitfield-Mask: 0x01)                 */
#define EBU_BUSWCON0_BCGEN_Pos                (20UL)                    /*!< EBU BUSWCON0: BCGEN (Bit 20)                                */
#define EBU_BUSWCON0_BCGEN_Msk                (0x300000UL)              /*!< EBU BUSWCON0: BCGEN (Bitfield-Mask: 0x03)                   */
#define EBU_BUSWCON0_PORTW_Pos                (22UL)                    /*!< EBU BUSWCON0: PORTW (Bit 22)                                */
#define EBU_BUSWCON0_PORTW_Msk                (0xc00000UL)              /*!< EBU BUSWCON0: PORTW (Bitfield-Mask: 0x03)                   */
#define EBU_BUSWCON0_WAIT_Pos                 (24UL)                    /*!< EBU BUSWCON0: WAIT (Bit 24)                                 */
#define EBU_BUSWCON0_WAIT_Msk                 (0x3000000UL)             /*!< EBU BUSWCON0: WAIT (Bitfield-Mask: 0x03)                    */
#define EBU_BUSWCON0_AAP_Pos                  (26UL)                    /*!< EBU BUSWCON0: AAP (Bit 26)                                  */
#define EBU_BUSWCON0_AAP_Msk                  (0x4000000UL)             /*!< EBU BUSWCON0: AAP (Bitfield-Mask: 0x01)                     */
#define EBU_BUSWCON0_LOCKCS_Pos               (27UL)                    /*!< EBU BUSWCON0: LOCKCS (Bit 27)                               */
#define EBU_BUSWCON0_LOCKCS_Msk               (0x8000000UL)             /*!< EBU BUSWCON0: LOCKCS (Bitfield-Mask: 0x01)                  */
#define EBU_BUSWCON0_AGEN_Pos                 (28UL)                    /*!< EBU BUSWCON0: AGEN (Bit 28)                                 */
#define EBU_BUSWCON0_AGEN_Msk                 (0xf0000000UL)            /*!< EBU BUSWCON0: AGEN (Bitfield-Mask: 0x0f)                    */

/* ---------------------------------  EBU_BUSWAP0  -------------------------------- */
#define EBU_BUSWAP0_WRDTACS_Pos               (0UL)                     /*!< EBU BUSWAP0: WRDTACS (Bit 0)                                */
#define EBU_BUSWAP0_WRDTACS_Msk               (0xfUL)                   /*!< EBU BUSWAP0: WRDTACS (Bitfield-Mask: 0x0f)                  */
#define EBU_BUSWAP0_WRRECOVC_Pos              (4UL)                     /*!< EBU BUSWAP0: WRRECOVC (Bit 4)                               */
#define EBU_BUSWAP0_WRRECOVC_Msk              (0x70UL)                  /*!< EBU BUSWAP0: WRRECOVC (Bitfield-Mask: 0x07)                 */
#define EBU_BUSWAP0_WAITWRC_Pos               (7UL)                     /*!< EBU BUSWAP0: WAITWRC (Bit 7)                                */
#define EBU_BUSWAP0_WAITWRC_Msk               (0xf80UL)                 /*!< EBU BUSWAP0: WAITWRC (Bitfield-Mask: 0x1f)                  */
#define EBU_BUSWAP0_DATAC_Pos                 (12UL)                    /*!< EBU BUSWAP0: DATAC (Bit 12)                                 */
#define EBU_BUSWAP0_DATAC_Msk                 (0xf000UL)                /*!< EBU BUSWAP0: DATAC (Bitfield-Mask: 0x0f)                    */
#define EBU_BUSWAP0_EXTCLOCK_Pos              (16UL)                    /*!< EBU BUSWAP0: EXTCLOCK (Bit 16)                              */
#define EBU_BUSWAP0_EXTCLOCK_Msk              (0x30000UL)               /*!< EBU BUSWAP0: EXTCLOCK (Bitfield-Mask: 0x03)                 */
#define EBU_BUSWAP0_EXTDATA_Pos               (18UL)                    /*!< EBU BUSWAP0: EXTDATA (Bit 18)                               */
#define EBU_BUSWAP0_EXTDATA_Msk               (0xc0000UL)               /*!< EBU BUSWAP0: EXTDATA (Bitfield-Mask: 0x03)                  */
#define EBU_BUSWAP0_CMDDELAY_Pos              (20UL)                    /*!< EBU BUSWAP0: CMDDELAY (Bit 20)                              */
#define EBU_BUSWAP0_CMDDELAY_Msk              (0xf00000UL)              /*!< EBU BUSWAP0: CMDDELAY (Bitfield-Mask: 0x0f)                 */
#define EBU_BUSWAP0_AHOLDC_Pos                (24UL)                    /*!< EBU BUSWAP0: AHOLDC (Bit 24)                                */
#define EBU_BUSWAP0_AHOLDC_Msk                (0xf000000UL)             /*!< EBU BUSWAP0: AHOLDC (Bitfield-Mask: 0x0f)                   */
#define EBU_BUSWAP0_ADDRC_Pos                 (28UL)                    /*!< EBU BUSWAP0: ADDRC (Bit 28)                                 */
#define EBU_BUSWAP0_ADDRC_Msk                 (0xf0000000UL)            /*!< EBU BUSWAP0: ADDRC (Bitfield-Mask: 0x0f)                    */

/* --------------------------------  EBU_BUSRCON1  -------------------------------- */
#define EBU_BUSRCON1_FETBLEN_Pos              (0UL)                     /*!< EBU BUSRCON1: FETBLEN (Bit 0)                               */
#define EBU_BUSRCON1_FETBLEN_Msk              (0x7UL)                   /*!< EBU BUSRCON1: FETBLEN (Bitfield-Mask: 0x07)                 */
#define EBU_BUSRCON1_FBBMSEL_Pos              (3UL)                     /*!< EBU BUSRCON1: FBBMSEL (Bit 3)                               */
#define EBU_BUSRCON1_FBBMSEL_Msk              (0x8UL)                   /*!< EBU BUSRCON1: FBBMSEL (Bitfield-Mask: 0x01)                 */
#define EBU_BUSRCON1_BFSSS_Pos                (4UL)                     /*!< EBU BUSRCON1: BFSSS (Bit 4)                                 */
#define EBU_BUSRCON1_BFSSS_Msk                (0x10UL)                  /*!< EBU BUSRCON1: BFSSS (Bitfield-Mask: 0x01)                   */
#define EBU_BUSRCON1_FDBKEN_Pos               (5UL)                     /*!< EBU BUSRCON1: FDBKEN (Bit 5)                                */
#define EBU_BUSRCON1_FDBKEN_Msk               (0x20UL)                  /*!< EBU BUSRCON1: FDBKEN (Bitfield-Mask: 0x01)                  */
#define EBU_BUSRCON1_BFCMSEL_Pos              (6UL)                     /*!< EBU BUSRCON1: BFCMSEL (Bit 6)                               */
#define EBU_BUSRCON1_BFCMSEL_Msk              (0x40UL)                  /*!< EBU BUSRCON1: BFCMSEL (Bitfield-Mask: 0x01)                 */
#define EBU_BUSRCON1_NAA_Pos                  (7UL)                     /*!< EBU BUSRCON1: NAA (Bit 7)                                   */
#define EBU_BUSRCON1_NAA_Msk                  (0x80UL)                  /*!< EBU BUSRCON1: NAA (Bitfield-Mask: 0x01)                     */
#define EBU_BUSRCON1_ECSE_Pos                 (16UL)                    /*!< EBU BUSRCON1: ECSE (Bit 16)                                 */
#define EBU_BUSRCON1_ECSE_Msk                 (0x10000UL)               /*!< EBU BUSRCON1: ECSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSRCON1_EBSE_Pos                 (17UL)                    /*!< EBU BUSRCON1: EBSE (Bit 17)                                 */
#define EBU_BUSRCON1_EBSE_Msk                 (0x20000UL)               /*!< EBU BUSRCON1: EBSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSRCON1_DBA_Pos                  (18UL)                    /*!< EBU BUSRCON1: DBA (Bit 18)                                  */
#define EBU_BUSRCON1_DBA_Msk                  (0x40000UL)               /*!< EBU BUSRCON1: DBA (Bitfield-Mask: 0x01)                     */
#define EBU_BUSRCON1_WAITINV_Pos              (19UL)                    /*!< EBU BUSRCON1: WAITINV (Bit 19)                              */
#define EBU_BUSRCON1_WAITINV_Msk              (0x80000UL)               /*!< EBU BUSRCON1: WAITINV (Bitfield-Mask: 0x01)                 */
#define EBU_BUSRCON1_BCGEN_Pos                (20UL)                    /*!< EBU BUSRCON1: BCGEN (Bit 20)                                */
#define EBU_BUSRCON1_BCGEN_Msk                (0x300000UL)              /*!< EBU BUSRCON1: BCGEN (Bitfield-Mask: 0x03)                   */
#define EBU_BUSRCON1_PORTW_Pos                (22UL)                    /*!< EBU BUSRCON1: PORTW (Bit 22)                                */
#define EBU_BUSRCON1_PORTW_Msk                (0xc00000UL)              /*!< EBU BUSRCON1: PORTW (Bitfield-Mask: 0x03)                   */
#define EBU_BUSRCON1_WAIT_Pos                 (24UL)                    /*!< EBU BUSRCON1: WAIT (Bit 24)                                 */
#define EBU_BUSRCON1_WAIT_Msk                 (0x3000000UL)             /*!< EBU BUSRCON1: WAIT (Bitfield-Mask: 0x03)                    */
#define EBU_BUSRCON1_AAP_Pos                  (26UL)                    /*!< EBU BUSRCON1: AAP (Bit 26)                                  */
#define EBU_BUSRCON1_AAP_Msk                  (0x4000000UL)             /*!< EBU BUSRCON1: AAP (Bitfield-Mask: 0x01)                     */
#define EBU_BUSRCON1_AGEN_Pos                 (28UL)                    /*!< EBU BUSRCON1: AGEN (Bit 28)                                 */
#define EBU_BUSRCON1_AGEN_Msk                 (0xf0000000UL)            /*!< EBU BUSRCON1: AGEN (Bitfield-Mask: 0x0f)                    */

/* ---------------------------------  EBU_BUSRAP1  -------------------------------- */
#define EBU_BUSRAP1_RDDTACS_Pos               (0UL)                     /*!< EBU BUSRAP1: RDDTACS (Bit 0)                                */
#define EBU_BUSRAP1_RDDTACS_Msk               (0xfUL)                   /*!< EBU BUSRAP1: RDDTACS (Bitfield-Mask: 0x0f)                  */
#define EBU_BUSRAP1_RDRECOVC_Pos              (4UL)                     /*!< EBU BUSRAP1: RDRECOVC (Bit 4)                               */
#define EBU_BUSRAP1_RDRECOVC_Msk              (0x70UL)                  /*!< EBU BUSRAP1: RDRECOVC (Bitfield-Mask: 0x07)                 */
#define EBU_BUSRAP1_WAITRDC_Pos               (7UL)                     /*!< EBU BUSRAP1: WAITRDC (Bit 7)                                */
#define EBU_BUSRAP1_WAITRDC_Msk               (0xf80UL)                 /*!< EBU BUSRAP1: WAITRDC (Bitfield-Mask: 0x1f)                  */
#define EBU_BUSRAP1_DATAC_Pos                 (12UL)                    /*!< EBU BUSRAP1: DATAC (Bit 12)                                 */
#define EBU_BUSRAP1_DATAC_Msk                 (0xf000UL)                /*!< EBU BUSRAP1: DATAC (Bitfield-Mask: 0x0f)                    */
#define EBU_BUSRAP1_EXTCLOCK_Pos              (16UL)                    /*!< EBU BUSRAP1: EXTCLOCK (Bit 16)                              */
#define EBU_BUSRAP1_EXTCLOCK_Msk              (0x30000UL)               /*!< EBU BUSRAP1: EXTCLOCK (Bitfield-Mask: 0x03)                 */
#define EBU_BUSRAP1_EXTDATA_Pos               (18UL)                    /*!< EBU BUSRAP1: EXTDATA (Bit 18)                               */
#define EBU_BUSRAP1_EXTDATA_Msk               (0xc0000UL)               /*!< EBU BUSRAP1: EXTDATA (Bitfield-Mask: 0x03)                  */
#define EBU_BUSRAP1_CMDDELAY_Pos              (20UL)                    /*!< EBU BUSRAP1: CMDDELAY (Bit 20)                              */
#define EBU_BUSRAP1_CMDDELAY_Msk              (0xf00000UL)              /*!< EBU BUSRAP1: CMDDELAY (Bitfield-Mask: 0x0f)                 */
#define EBU_BUSRAP1_AHOLDC_Pos                (24UL)                    /*!< EBU BUSRAP1: AHOLDC (Bit 24)                                */
#define EBU_BUSRAP1_AHOLDC_Msk                (0xf000000UL)             /*!< EBU BUSRAP1: AHOLDC (Bitfield-Mask: 0x0f)                   */
#define EBU_BUSRAP1_ADDRC_Pos                 (28UL)                    /*!< EBU BUSRAP1: ADDRC (Bit 28)                                 */
#define EBU_BUSRAP1_ADDRC_Msk                 (0xf0000000UL)            /*!< EBU BUSRAP1: ADDRC (Bitfield-Mask: 0x0f)                    */

/* --------------------------------  EBU_BUSWCON1  -------------------------------- */
#define EBU_BUSWCON1_FETBLEN_Pos              (0UL)                     /*!< EBU BUSWCON1: FETBLEN (Bit 0)                               */
#define EBU_BUSWCON1_FETBLEN_Msk              (0x7UL)                   /*!< EBU BUSWCON1: FETBLEN (Bitfield-Mask: 0x07)                 */
#define EBU_BUSWCON1_FBBMSEL_Pos              (3UL)                     /*!< EBU BUSWCON1: FBBMSEL (Bit 3)                               */
#define EBU_BUSWCON1_FBBMSEL_Msk              (0x8UL)                   /*!< EBU BUSWCON1: FBBMSEL (Bitfield-Mask: 0x01)                 */
#define EBU_BUSWCON1_NAA_Pos                  (7UL)                     /*!< EBU BUSWCON1: NAA (Bit 7)                                   */
#define EBU_BUSWCON1_NAA_Msk                  (0x80UL)                  /*!< EBU BUSWCON1: NAA (Bitfield-Mask: 0x01)                     */
#define EBU_BUSWCON1_ECSE_Pos                 (16UL)                    /*!< EBU BUSWCON1: ECSE (Bit 16)                                 */
#define EBU_BUSWCON1_ECSE_Msk                 (0x10000UL)               /*!< EBU BUSWCON1: ECSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSWCON1_EBSE_Pos                 (17UL)                    /*!< EBU BUSWCON1: EBSE (Bit 17)                                 */
#define EBU_BUSWCON1_EBSE_Msk                 (0x20000UL)               /*!< EBU BUSWCON1: EBSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSWCON1_WAITINV_Pos              (19UL)                    /*!< EBU BUSWCON1: WAITINV (Bit 19)                              */
#define EBU_BUSWCON1_WAITINV_Msk              (0x80000UL)               /*!< EBU BUSWCON1: WAITINV (Bitfield-Mask: 0x01)                 */
#define EBU_BUSWCON1_BCGEN_Pos                (20UL)                    /*!< EBU BUSWCON1: BCGEN (Bit 20)                                */
#define EBU_BUSWCON1_BCGEN_Msk                (0x300000UL)              /*!< EBU BUSWCON1: BCGEN (Bitfield-Mask: 0x03)                   */
#define EBU_BUSWCON1_PORTW_Pos                (22UL)                    /*!< EBU BUSWCON1: PORTW (Bit 22)                                */
#define EBU_BUSWCON1_PORTW_Msk                (0xc00000UL)              /*!< EBU BUSWCON1: PORTW (Bitfield-Mask: 0x03)                   */
#define EBU_BUSWCON1_WAIT_Pos                 (24UL)                    /*!< EBU BUSWCON1: WAIT (Bit 24)                                 */
#define EBU_BUSWCON1_WAIT_Msk                 (0x3000000UL)             /*!< EBU BUSWCON1: WAIT (Bitfield-Mask: 0x03)                    */
#define EBU_BUSWCON1_AAP_Pos                  (26UL)                    /*!< EBU BUSWCON1: AAP (Bit 26)                                  */
#define EBU_BUSWCON1_AAP_Msk                  (0x4000000UL)             /*!< EBU BUSWCON1: AAP (Bitfield-Mask: 0x01)                     */
#define EBU_BUSWCON1_LOCKCS_Pos               (27UL)                    /*!< EBU BUSWCON1: LOCKCS (Bit 27)                               */
#define EBU_BUSWCON1_LOCKCS_Msk               (0x8000000UL)             /*!< EBU BUSWCON1: LOCKCS (Bitfield-Mask: 0x01)                  */
#define EBU_BUSWCON1_AGEN_Pos                 (28UL)                    /*!< EBU BUSWCON1: AGEN (Bit 28)                                 */
#define EBU_BUSWCON1_AGEN_Msk                 (0xf0000000UL)            /*!< EBU BUSWCON1: AGEN (Bitfield-Mask: 0x0f)                    */

/* ---------------------------------  EBU_BUSWAP1  -------------------------------- */
#define EBU_BUSWAP1_WRDTACS_Pos               (0UL)                     /*!< EBU BUSWAP1: WRDTACS (Bit 0)                                */
#define EBU_BUSWAP1_WRDTACS_Msk               (0xfUL)                   /*!< EBU BUSWAP1: WRDTACS (Bitfield-Mask: 0x0f)                  */
#define EBU_BUSWAP1_WRRECOVC_Pos              (4UL)                     /*!< EBU BUSWAP1: WRRECOVC (Bit 4)                               */
#define EBU_BUSWAP1_WRRECOVC_Msk              (0x70UL)                  /*!< EBU BUSWAP1: WRRECOVC (Bitfield-Mask: 0x07)                 */
#define EBU_BUSWAP1_WAITWRC_Pos               (7UL)                     /*!< EBU BUSWAP1: WAITWRC (Bit 7)                                */
#define EBU_BUSWAP1_WAITWRC_Msk               (0xf80UL)                 /*!< EBU BUSWAP1: WAITWRC (Bitfield-Mask: 0x1f)                  */
#define EBU_BUSWAP1_DATAC_Pos                 (12UL)                    /*!< EBU BUSWAP1: DATAC (Bit 12)                                 */
#define EBU_BUSWAP1_DATAC_Msk                 (0xf000UL)                /*!< EBU BUSWAP1: DATAC (Bitfield-Mask: 0x0f)                    */
#define EBU_BUSWAP1_EXTCLOCK_Pos              (16UL)                    /*!< EBU BUSWAP1: EXTCLOCK (Bit 16)                              */
#define EBU_BUSWAP1_EXTCLOCK_Msk              (0x30000UL)               /*!< EBU BUSWAP1: EXTCLOCK (Bitfield-Mask: 0x03)                 */
#define EBU_BUSWAP1_EXTDATA_Pos               (18UL)                    /*!< EBU BUSWAP1: EXTDATA (Bit 18)                               */
#define EBU_BUSWAP1_EXTDATA_Msk               (0xc0000UL)               /*!< EBU BUSWAP1: EXTDATA (Bitfield-Mask: 0x03)                  */
#define EBU_BUSWAP1_CMDDELAY_Pos              (20UL)                    /*!< EBU BUSWAP1: CMDDELAY (Bit 20)                              */
#define EBU_BUSWAP1_CMDDELAY_Msk              (0xf00000UL)              /*!< EBU BUSWAP1: CMDDELAY (Bitfield-Mask: 0x0f)                 */
#define EBU_BUSWAP1_AHOLDC_Pos                (24UL)                    /*!< EBU BUSWAP1: AHOLDC (Bit 24)                                */
#define EBU_BUSWAP1_AHOLDC_Msk                (0xf000000UL)             /*!< EBU BUSWAP1: AHOLDC (Bitfield-Mask: 0x0f)                   */
#define EBU_BUSWAP1_ADDRC_Pos                 (28UL)                    /*!< EBU BUSWAP1: ADDRC (Bit 28)                                 */
#define EBU_BUSWAP1_ADDRC_Msk                 (0xf0000000UL)            /*!< EBU BUSWAP1: ADDRC (Bitfield-Mask: 0x0f)                    */

/* --------------------------------  EBU_BUSRCON2  -------------------------------- */
#define EBU_BUSRCON2_FETBLEN_Pos              (0UL)                     /*!< EBU BUSRCON2: FETBLEN (Bit 0)                               */
#define EBU_BUSRCON2_FETBLEN_Msk              (0x7UL)                   /*!< EBU BUSRCON2: FETBLEN (Bitfield-Mask: 0x07)                 */
#define EBU_BUSRCON2_FBBMSEL_Pos              (3UL)                     /*!< EBU BUSRCON2: FBBMSEL (Bit 3)                               */
#define EBU_BUSRCON2_FBBMSEL_Msk              (0x8UL)                   /*!< EBU BUSRCON2: FBBMSEL (Bitfield-Mask: 0x01)                 */
#define EBU_BUSRCON2_BFSSS_Pos                (4UL)                     /*!< EBU BUSRCON2: BFSSS (Bit 4)                                 */
#define EBU_BUSRCON2_BFSSS_Msk                (0x10UL)                  /*!< EBU BUSRCON2: BFSSS (Bitfield-Mask: 0x01)                   */
#define EBU_BUSRCON2_FDBKEN_Pos               (5UL)                     /*!< EBU BUSRCON2: FDBKEN (Bit 5)                                */
#define EBU_BUSRCON2_FDBKEN_Msk               (0x20UL)                  /*!< EBU BUSRCON2: FDBKEN (Bitfield-Mask: 0x01)                  */
#define EBU_BUSRCON2_BFCMSEL_Pos              (6UL)                     /*!< EBU BUSRCON2: BFCMSEL (Bit 6)                               */
#define EBU_BUSRCON2_BFCMSEL_Msk              (0x40UL)                  /*!< EBU BUSRCON2: BFCMSEL (Bitfield-Mask: 0x01)                 */
#define EBU_BUSRCON2_NAA_Pos                  (7UL)                     /*!< EBU BUSRCON2: NAA (Bit 7)                                   */
#define EBU_BUSRCON2_NAA_Msk                  (0x80UL)                  /*!< EBU BUSRCON2: NAA (Bitfield-Mask: 0x01)                     */
#define EBU_BUSRCON2_ECSE_Pos                 (16UL)                    /*!< EBU BUSRCON2: ECSE (Bit 16)                                 */
#define EBU_BUSRCON2_ECSE_Msk                 (0x10000UL)               /*!< EBU BUSRCON2: ECSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSRCON2_EBSE_Pos                 (17UL)                    /*!< EBU BUSRCON2: EBSE (Bit 17)                                 */
#define EBU_BUSRCON2_EBSE_Msk                 (0x20000UL)               /*!< EBU BUSRCON2: EBSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSRCON2_DBA_Pos                  (18UL)                    /*!< EBU BUSRCON2: DBA (Bit 18)                                  */
#define EBU_BUSRCON2_DBA_Msk                  (0x40000UL)               /*!< EBU BUSRCON2: DBA (Bitfield-Mask: 0x01)                     */
#define EBU_BUSRCON2_WAITINV_Pos              (19UL)                    /*!< EBU BUSRCON2: WAITINV (Bit 19)                              */
#define EBU_BUSRCON2_WAITINV_Msk              (0x80000UL)               /*!< EBU BUSRCON2: WAITINV (Bitfield-Mask: 0x01)                 */
#define EBU_BUSRCON2_BCGEN_Pos                (20UL)                    /*!< EBU BUSRCON2: BCGEN (Bit 20)                                */
#define EBU_BUSRCON2_BCGEN_Msk                (0x300000UL)              /*!< EBU BUSRCON2: BCGEN (Bitfield-Mask: 0x03)                   */
#define EBU_BUSRCON2_PORTW_Pos                (22UL)                    /*!< EBU BUSRCON2: PORTW (Bit 22)                                */
#define EBU_BUSRCON2_PORTW_Msk                (0xc00000UL)              /*!< EBU BUSRCON2: PORTW (Bitfield-Mask: 0x03)                   */
#define EBU_BUSRCON2_WAIT_Pos                 (24UL)                    /*!< EBU BUSRCON2: WAIT (Bit 24)                                 */
#define EBU_BUSRCON2_WAIT_Msk                 (0x3000000UL)             /*!< EBU BUSRCON2: WAIT (Bitfield-Mask: 0x03)                    */
#define EBU_BUSRCON2_AAP_Pos                  (26UL)                    /*!< EBU BUSRCON2: AAP (Bit 26)                                  */
#define EBU_BUSRCON2_AAP_Msk                  (0x4000000UL)             /*!< EBU BUSRCON2: AAP (Bitfield-Mask: 0x01)                     */
#define EBU_BUSRCON2_AGEN_Pos                 (28UL)                    /*!< EBU BUSRCON2: AGEN (Bit 28)                                 */
#define EBU_BUSRCON2_AGEN_Msk                 (0xf0000000UL)            /*!< EBU BUSRCON2: AGEN (Bitfield-Mask: 0x0f)                    */

/* ---------------------------------  EBU_BUSRAP2  -------------------------------- */
#define EBU_BUSRAP2_RDDTACS_Pos               (0UL)                     /*!< EBU BUSRAP2: RDDTACS (Bit 0)                                */
#define EBU_BUSRAP2_RDDTACS_Msk               (0xfUL)                   /*!< EBU BUSRAP2: RDDTACS (Bitfield-Mask: 0x0f)                  */
#define EBU_BUSRAP2_RDRECOVC_Pos              (4UL)                     /*!< EBU BUSRAP2: RDRECOVC (Bit 4)                               */
#define EBU_BUSRAP2_RDRECOVC_Msk              (0x70UL)                  /*!< EBU BUSRAP2: RDRECOVC (Bitfield-Mask: 0x07)                 */
#define EBU_BUSRAP2_WAITRDC_Pos               (7UL)                     /*!< EBU BUSRAP2: WAITRDC (Bit 7)                                */
#define EBU_BUSRAP2_WAITRDC_Msk               (0xf80UL)                 /*!< EBU BUSRAP2: WAITRDC (Bitfield-Mask: 0x1f)                  */
#define EBU_BUSRAP2_DATAC_Pos                 (12UL)                    /*!< EBU BUSRAP2: DATAC (Bit 12)                                 */
#define EBU_BUSRAP2_DATAC_Msk                 (0xf000UL)                /*!< EBU BUSRAP2: DATAC (Bitfield-Mask: 0x0f)                    */
#define EBU_BUSRAP2_EXTCLOCK_Pos              (16UL)                    /*!< EBU BUSRAP2: EXTCLOCK (Bit 16)                              */
#define EBU_BUSRAP2_EXTCLOCK_Msk              (0x30000UL)               /*!< EBU BUSRAP2: EXTCLOCK (Bitfield-Mask: 0x03)                 */
#define EBU_BUSRAP2_EXTDATA_Pos               (18UL)                    /*!< EBU BUSRAP2: EXTDATA (Bit 18)                               */
#define EBU_BUSRAP2_EXTDATA_Msk               (0xc0000UL)               /*!< EBU BUSRAP2: EXTDATA (Bitfield-Mask: 0x03)                  */
#define EBU_BUSRAP2_CMDDELAY_Pos              (20UL)                    /*!< EBU BUSRAP2: CMDDELAY (Bit 20)                              */
#define EBU_BUSRAP2_CMDDELAY_Msk              (0xf00000UL)              /*!< EBU BUSRAP2: CMDDELAY (Bitfield-Mask: 0x0f)                 */
#define EBU_BUSRAP2_AHOLDC_Pos                (24UL)                    /*!< EBU BUSRAP2: AHOLDC (Bit 24)                                */
#define EBU_BUSRAP2_AHOLDC_Msk                (0xf000000UL)             /*!< EBU BUSRAP2: AHOLDC (Bitfield-Mask: 0x0f)                   */
#define EBU_BUSRAP2_ADDRC_Pos                 (28UL)                    /*!< EBU BUSRAP2: ADDRC (Bit 28)                                 */
#define EBU_BUSRAP2_ADDRC_Msk                 (0xf0000000UL)            /*!< EBU BUSRAP2: ADDRC (Bitfield-Mask: 0x0f)                    */

/* --------------------------------  EBU_BUSWCON2  -------------------------------- */
#define EBU_BUSWCON2_FETBLEN_Pos              (0UL)                     /*!< EBU BUSWCON2: FETBLEN (Bit 0)                               */
#define EBU_BUSWCON2_FETBLEN_Msk              (0x7UL)                   /*!< EBU BUSWCON2: FETBLEN (Bitfield-Mask: 0x07)                 */
#define EBU_BUSWCON2_FBBMSEL_Pos              (3UL)                     /*!< EBU BUSWCON2: FBBMSEL (Bit 3)                               */
#define EBU_BUSWCON2_FBBMSEL_Msk              (0x8UL)                   /*!< EBU BUSWCON2: FBBMSEL (Bitfield-Mask: 0x01)                 */
#define EBU_BUSWCON2_NAA_Pos                  (7UL)                     /*!< EBU BUSWCON2: NAA (Bit 7)                                   */
#define EBU_BUSWCON2_NAA_Msk                  (0x80UL)                  /*!< EBU BUSWCON2: NAA (Bitfield-Mask: 0x01)                     */
#define EBU_BUSWCON2_ECSE_Pos                 (16UL)                    /*!< EBU BUSWCON2: ECSE (Bit 16)                                 */
#define EBU_BUSWCON2_ECSE_Msk                 (0x10000UL)               /*!< EBU BUSWCON2: ECSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSWCON2_EBSE_Pos                 (17UL)                    /*!< EBU BUSWCON2: EBSE (Bit 17)                                 */
#define EBU_BUSWCON2_EBSE_Msk                 (0x20000UL)               /*!< EBU BUSWCON2: EBSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSWCON2_WAITINV_Pos              (19UL)                    /*!< EBU BUSWCON2: WAITINV (Bit 19)                              */
#define EBU_BUSWCON2_WAITINV_Msk              (0x80000UL)               /*!< EBU BUSWCON2: WAITINV (Bitfield-Mask: 0x01)                 */
#define EBU_BUSWCON2_BCGEN_Pos                (20UL)                    /*!< EBU BUSWCON2: BCGEN (Bit 20)                                */
#define EBU_BUSWCON2_BCGEN_Msk                (0x300000UL)              /*!< EBU BUSWCON2: BCGEN (Bitfield-Mask: 0x03)                   */
#define EBU_BUSWCON2_PORTW_Pos                (22UL)                    /*!< EBU BUSWCON2: PORTW (Bit 22)                                */
#define EBU_BUSWCON2_PORTW_Msk                (0xc00000UL)              /*!< EBU BUSWCON2: PORTW (Bitfield-Mask: 0x03)                   */
#define EBU_BUSWCON2_WAIT_Pos                 (24UL)                    /*!< EBU BUSWCON2: WAIT (Bit 24)                                 */
#define EBU_BUSWCON2_WAIT_Msk                 (0x3000000UL)             /*!< EBU BUSWCON2: WAIT (Bitfield-Mask: 0x03)                    */
#define EBU_BUSWCON2_AAP_Pos                  (26UL)                    /*!< EBU BUSWCON2: AAP (Bit 26)                                  */
#define EBU_BUSWCON2_AAP_Msk                  (0x4000000UL)             /*!< EBU BUSWCON2: AAP (Bitfield-Mask: 0x01)                     */
#define EBU_BUSWCON2_LOCKCS_Pos               (27UL)                    /*!< EBU BUSWCON2: LOCKCS (Bit 27)                               */
#define EBU_BUSWCON2_LOCKCS_Msk               (0x8000000UL)             /*!< EBU BUSWCON2: LOCKCS (Bitfield-Mask: 0x01)                  */
#define EBU_BUSWCON2_AGEN_Pos                 (28UL)                    /*!< EBU BUSWCON2: AGEN (Bit 28)                                 */
#define EBU_BUSWCON2_AGEN_Msk                 (0xf0000000UL)            /*!< EBU BUSWCON2: AGEN (Bitfield-Mask: 0x0f)                    */

/* ---------------------------------  EBU_BUSWAP2  -------------------------------- */
#define EBU_BUSWAP2_WRDTACS_Pos               (0UL)                     /*!< EBU BUSWAP2: WRDTACS (Bit 0)                                */
#define EBU_BUSWAP2_WRDTACS_Msk               (0xfUL)                   /*!< EBU BUSWAP2: WRDTACS (Bitfield-Mask: 0x0f)                  */
#define EBU_BUSWAP2_WRRECOVC_Pos              (4UL)                     /*!< EBU BUSWAP2: WRRECOVC (Bit 4)                               */
#define EBU_BUSWAP2_WRRECOVC_Msk              (0x70UL)                  /*!< EBU BUSWAP2: WRRECOVC (Bitfield-Mask: 0x07)                 */
#define EBU_BUSWAP2_WAITWRC_Pos               (7UL)                     /*!< EBU BUSWAP2: WAITWRC (Bit 7)                                */
#define EBU_BUSWAP2_WAITWRC_Msk               (0xf80UL)                 /*!< EBU BUSWAP2: WAITWRC (Bitfield-Mask: 0x1f)                  */
#define EBU_BUSWAP2_DATAC_Pos                 (12UL)                    /*!< EBU BUSWAP2: DATAC (Bit 12)                                 */
#define EBU_BUSWAP2_DATAC_Msk                 (0xf000UL)                /*!< EBU BUSWAP2: DATAC (Bitfield-Mask: 0x0f)                    */
#define EBU_BUSWAP2_EXTCLOCK_Pos              (16UL)                    /*!< EBU BUSWAP2: EXTCLOCK (Bit 16)                              */
#define EBU_BUSWAP2_EXTCLOCK_Msk              (0x30000UL)               /*!< EBU BUSWAP2: EXTCLOCK (Bitfield-Mask: 0x03)                 */
#define EBU_BUSWAP2_EXTDATA_Pos               (18UL)                    /*!< EBU BUSWAP2: EXTDATA (Bit 18)                               */
#define EBU_BUSWAP2_EXTDATA_Msk               (0xc0000UL)               /*!< EBU BUSWAP2: EXTDATA (Bitfield-Mask: 0x03)                  */
#define EBU_BUSWAP2_CMDDELAY_Pos              (20UL)                    /*!< EBU BUSWAP2: CMDDELAY (Bit 20)                              */
#define EBU_BUSWAP2_CMDDELAY_Msk              (0xf00000UL)              /*!< EBU BUSWAP2: CMDDELAY (Bitfield-Mask: 0x0f)                 */
#define EBU_BUSWAP2_AHOLDC_Pos                (24UL)                    /*!< EBU BUSWAP2: AHOLDC (Bit 24)                                */
#define EBU_BUSWAP2_AHOLDC_Msk                (0xf000000UL)             /*!< EBU BUSWAP2: AHOLDC (Bitfield-Mask: 0x0f)                   */
#define EBU_BUSWAP2_ADDRC_Pos                 (28UL)                    /*!< EBU BUSWAP2: ADDRC (Bit 28)                                 */
#define EBU_BUSWAP2_ADDRC_Msk                 (0xf0000000UL)            /*!< EBU BUSWAP2: ADDRC (Bitfield-Mask: 0x0f)                    */

/* --------------------------------  EBU_BUSRCON3  -------------------------------- */
#define EBU_BUSRCON3_FETBLEN_Pos              (0UL)                     /*!< EBU BUSRCON3: FETBLEN (Bit 0)                               */
#define EBU_BUSRCON3_FETBLEN_Msk              (0x7UL)                   /*!< EBU BUSRCON3: FETBLEN (Bitfield-Mask: 0x07)                 */
#define EBU_BUSRCON3_FBBMSEL_Pos              (3UL)                     /*!< EBU BUSRCON3: FBBMSEL (Bit 3)                               */
#define EBU_BUSRCON3_FBBMSEL_Msk              (0x8UL)                   /*!< EBU BUSRCON3: FBBMSEL (Bitfield-Mask: 0x01)                 */
#define EBU_BUSRCON3_BFSSS_Pos                (4UL)                     /*!< EBU BUSRCON3: BFSSS (Bit 4)                                 */
#define EBU_BUSRCON3_BFSSS_Msk                (0x10UL)                  /*!< EBU BUSRCON3: BFSSS (Bitfield-Mask: 0x01)                   */
#define EBU_BUSRCON3_FDBKEN_Pos               (5UL)                     /*!< EBU BUSRCON3: FDBKEN (Bit 5)                                */
#define EBU_BUSRCON3_FDBKEN_Msk               (0x20UL)                  /*!< EBU BUSRCON3: FDBKEN (Bitfield-Mask: 0x01)                  */
#define EBU_BUSRCON3_BFCMSEL_Pos              (6UL)                     /*!< EBU BUSRCON3: BFCMSEL (Bit 6)                               */
#define EBU_BUSRCON3_BFCMSEL_Msk              (0x40UL)                  /*!< EBU BUSRCON3: BFCMSEL (Bitfield-Mask: 0x01)                 */
#define EBU_BUSRCON3_NAA_Pos                  (7UL)                     /*!< EBU BUSRCON3: NAA (Bit 7)                                   */
#define EBU_BUSRCON3_NAA_Msk                  (0x80UL)                  /*!< EBU BUSRCON3: NAA (Bitfield-Mask: 0x01)                     */
#define EBU_BUSRCON3_ECSE_Pos                 (16UL)                    /*!< EBU BUSRCON3: ECSE (Bit 16)                                 */
#define EBU_BUSRCON3_ECSE_Msk                 (0x10000UL)               /*!< EBU BUSRCON3: ECSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSRCON3_EBSE_Pos                 (17UL)                    /*!< EBU BUSRCON3: EBSE (Bit 17)                                 */
#define EBU_BUSRCON3_EBSE_Msk                 (0x20000UL)               /*!< EBU BUSRCON3: EBSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSRCON3_DBA_Pos                  (18UL)                    /*!< EBU BUSRCON3: DBA (Bit 18)                                  */
#define EBU_BUSRCON3_DBA_Msk                  (0x40000UL)               /*!< EBU BUSRCON3: DBA (Bitfield-Mask: 0x01)                     */
#define EBU_BUSRCON3_WAITINV_Pos              (19UL)                    /*!< EBU BUSRCON3: WAITINV (Bit 19)                              */
#define EBU_BUSRCON3_WAITINV_Msk              (0x80000UL)               /*!< EBU BUSRCON3: WAITINV (Bitfield-Mask: 0x01)                 */
#define EBU_BUSRCON3_BCGEN_Pos                (20UL)                    /*!< EBU BUSRCON3: BCGEN (Bit 20)                                */
#define EBU_BUSRCON3_BCGEN_Msk                (0x300000UL)              /*!< EBU BUSRCON3: BCGEN (Bitfield-Mask: 0x03)                   */
#define EBU_BUSRCON3_PORTW_Pos                (22UL)                    /*!< EBU BUSRCON3: PORTW (Bit 22)                                */
#define EBU_BUSRCON3_PORTW_Msk                (0xc00000UL)              /*!< EBU BUSRCON3: PORTW (Bitfield-Mask: 0x03)                   */
#define EBU_BUSRCON3_WAIT_Pos                 (24UL)                    /*!< EBU BUSRCON3: WAIT (Bit 24)                                 */
#define EBU_BUSRCON3_WAIT_Msk                 (0x3000000UL)             /*!< EBU BUSRCON3: WAIT (Bitfield-Mask: 0x03)                    */
#define EBU_BUSRCON3_AAP_Pos                  (26UL)                    /*!< EBU BUSRCON3: AAP (Bit 26)                                  */
#define EBU_BUSRCON3_AAP_Msk                  (0x4000000UL)             /*!< EBU BUSRCON3: AAP (Bitfield-Mask: 0x01)                     */
#define EBU_BUSRCON3_AGEN_Pos                 (28UL)                    /*!< EBU BUSRCON3: AGEN (Bit 28)                                 */
#define EBU_BUSRCON3_AGEN_Msk                 (0xf0000000UL)            /*!< EBU BUSRCON3: AGEN (Bitfield-Mask: 0x0f)                    */

/* ---------------------------------  EBU_BUSRAP3  -------------------------------- */
#define EBU_BUSRAP3_RDDTACS_Pos               (0UL)                     /*!< EBU BUSRAP3: RDDTACS (Bit 0)                                */
#define EBU_BUSRAP3_RDDTACS_Msk               (0xfUL)                   /*!< EBU BUSRAP3: RDDTACS (Bitfield-Mask: 0x0f)                  */
#define EBU_BUSRAP3_RDRECOVC_Pos              (4UL)                     /*!< EBU BUSRAP3: RDRECOVC (Bit 4)                               */
#define EBU_BUSRAP3_RDRECOVC_Msk              (0x70UL)                  /*!< EBU BUSRAP3: RDRECOVC (Bitfield-Mask: 0x07)                 */
#define EBU_BUSRAP3_WAITRDC_Pos               (7UL)                     /*!< EBU BUSRAP3: WAITRDC (Bit 7)                                */
#define EBU_BUSRAP3_WAITRDC_Msk               (0xf80UL)                 /*!< EBU BUSRAP3: WAITRDC (Bitfield-Mask: 0x1f)                  */
#define EBU_BUSRAP3_DATAC_Pos                 (12UL)                    /*!< EBU BUSRAP3: DATAC (Bit 12)                                 */
#define EBU_BUSRAP3_DATAC_Msk                 (0xf000UL)                /*!< EBU BUSRAP3: DATAC (Bitfield-Mask: 0x0f)                    */
#define EBU_BUSRAP3_EXTCLOCK_Pos              (16UL)                    /*!< EBU BUSRAP3: EXTCLOCK (Bit 16)                              */
#define EBU_BUSRAP3_EXTCLOCK_Msk              (0x30000UL)               /*!< EBU BUSRAP3: EXTCLOCK (Bitfield-Mask: 0x03)                 */
#define EBU_BUSRAP3_EXTDATA_Pos               (18UL)                    /*!< EBU BUSRAP3: EXTDATA (Bit 18)                               */
#define EBU_BUSRAP3_EXTDATA_Msk               (0xc0000UL)               /*!< EBU BUSRAP3: EXTDATA (Bitfield-Mask: 0x03)                  */
#define EBU_BUSRAP3_CMDDELAY_Pos              (20UL)                    /*!< EBU BUSRAP3: CMDDELAY (Bit 20)                              */
#define EBU_BUSRAP3_CMDDELAY_Msk              (0xf00000UL)              /*!< EBU BUSRAP3: CMDDELAY (Bitfield-Mask: 0x0f)                 */
#define EBU_BUSRAP3_AHOLDC_Pos                (24UL)                    /*!< EBU BUSRAP3: AHOLDC (Bit 24)                                */
#define EBU_BUSRAP3_AHOLDC_Msk                (0xf000000UL)             /*!< EBU BUSRAP3: AHOLDC (Bitfield-Mask: 0x0f)                   */
#define EBU_BUSRAP3_ADDRC_Pos                 (28UL)                    /*!< EBU BUSRAP3: ADDRC (Bit 28)                                 */
#define EBU_BUSRAP3_ADDRC_Msk                 (0xf0000000UL)            /*!< EBU BUSRAP3: ADDRC (Bitfield-Mask: 0x0f)                    */

/* --------------------------------  EBU_BUSWCON3  -------------------------------- */
#define EBU_BUSWCON3_FETBLEN_Pos              (0UL)                     /*!< EBU BUSWCON3: FETBLEN (Bit 0)                               */
#define EBU_BUSWCON3_FETBLEN_Msk              (0x7UL)                   /*!< EBU BUSWCON3: FETBLEN (Bitfield-Mask: 0x07)                 */
#define EBU_BUSWCON3_FBBMSEL_Pos              (3UL)                     /*!< EBU BUSWCON3: FBBMSEL (Bit 3)                               */
#define EBU_BUSWCON3_FBBMSEL_Msk              (0x8UL)                   /*!< EBU BUSWCON3: FBBMSEL (Bitfield-Mask: 0x01)                 */
#define EBU_BUSWCON3_NAA_Pos                  (7UL)                     /*!< EBU BUSWCON3: NAA (Bit 7)                                   */
#define EBU_BUSWCON3_NAA_Msk                  (0x80UL)                  /*!< EBU BUSWCON3: NAA (Bitfield-Mask: 0x01)                     */
#define EBU_BUSWCON3_ECSE_Pos                 (16UL)                    /*!< EBU BUSWCON3: ECSE (Bit 16)                                 */
#define EBU_BUSWCON3_ECSE_Msk                 (0x10000UL)               /*!< EBU BUSWCON3: ECSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSWCON3_EBSE_Pos                 (17UL)                    /*!< EBU BUSWCON3: EBSE (Bit 17)                                 */
#define EBU_BUSWCON3_EBSE_Msk                 (0x20000UL)               /*!< EBU BUSWCON3: EBSE (Bitfield-Mask: 0x01)                    */
#define EBU_BUSWCON3_WAITINV_Pos              (19UL)                    /*!< EBU BUSWCON3: WAITINV (Bit 19)                              */
#define EBU_BUSWCON3_WAITINV_Msk              (0x80000UL)               /*!< EBU BUSWCON3: WAITINV (Bitfield-Mask: 0x01)                 */
#define EBU_BUSWCON3_BCGEN_Pos                (20UL)                    /*!< EBU BUSWCON3: BCGEN (Bit 20)                                */
#define EBU_BUSWCON3_BCGEN_Msk                (0x300000UL)              /*!< EBU BUSWCON3: BCGEN (Bitfield-Mask: 0x03)                   */
#define EBU_BUSWCON3_PORTW_Pos                (22UL)                    /*!< EBU BUSWCON3: PORTW (Bit 22)                                */
#define EBU_BUSWCON3_PORTW_Msk                (0xc00000UL)              /*!< EBU BUSWCON3: PORTW (Bitfield-Mask: 0x03)                   */
#define EBU_BUSWCON3_WAIT_Pos                 (24UL)                    /*!< EBU BUSWCON3: WAIT (Bit 24)                                 */
#define EBU_BUSWCON3_WAIT_Msk                 (0x3000000UL)             /*!< EBU BUSWCON3: WAIT (Bitfield-Mask: 0x03)                    */
#define EBU_BUSWCON3_AAP_Pos                  (26UL)                    /*!< EBU BUSWCON3: AAP (Bit 26)                                  */
#define EBU_BUSWCON3_AAP_Msk                  (0x4000000UL)             /*!< EBU BUSWCON3: AAP (Bitfield-Mask: 0x01)                     */
#define EBU_BUSWCON3_LOCKCS_Pos               (27UL)                    /*!< EBU BUSWCON3: LOCKCS (Bit 27)                               */
#define EBU_BUSWCON3_LOCKCS_Msk               (0x8000000UL)             /*!< EBU BUSWCON3: LOCKCS (Bitfield-Mask: 0x01)                  */
#define EBU_BUSWCON3_AGEN_Pos                 (28UL)                    /*!< EBU BUSWCON3: AGEN (Bit 28)                                 */
#define EBU_BUSWCON3_AGEN_Msk                 (0xf0000000UL)            /*!< EBU BUSWCON3: AGEN (Bitfield-Mask: 0x0f)                    */

/* ---------------------------------  EBU_BUSWAP3  -------------------------------- */
#define EBU_BUSWAP3_WRDTACS_Pos               (0UL)                     /*!< EBU BUSWAP3: WRDTACS (Bit 0)                                */
#define EBU_BUSWAP3_WRDTACS_Msk               (0xfUL)                   /*!< EBU BUSWAP3: WRDTACS (Bitfield-Mask: 0x0f)                  */
#define EBU_BUSWAP3_WRRECOVC_Pos              (4UL)                     /*!< EBU BUSWAP3: WRRECOVC (Bit 4)                               */
#define EBU_BUSWAP3_WRRECOVC_Msk              (0x70UL)                  /*!< EBU BUSWAP3: WRRECOVC (Bitfield-Mask: 0x07)                 */
#define EBU_BUSWAP3_WAITWRC_Pos               (7UL)                     /*!< EBU BUSWAP3: WAITWRC (Bit 7)                                */
#define EBU_BUSWAP3_WAITWRC_Msk               (0xf80UL)                 /*!< EBU BUSWAP3: WAITWRC (Bitfield-Mask: 0x1f)                  */
#define EBU_BUSWAP3_DATAC_Pos                 (12UL)                    /*!< EBU BUSWAP3: DATAC (Bit 12)                                 */
#define EBU_BUSWAP3_DATAC_Msk                 (0xf000UL)                /*!< EBU BUSWAP3: DATAC (Bitfield-Mask: 0x0f)                    */
#define EBU_BUSWAP3_EXTCLOCK_Pos              (16UL)                    /*!< EBU BUSWAP3: EXTCLOCK (Bit 16)                              */
#define EBU_BUSWAP3_EXTCLOCK_Msk              (0x30000UL)               /*!< EBU BUSWAP3: EXTCLOCK (Bitfield-Mask: 0x03)                 */
#define EBU_BUSWAP3_EXTDATA_Pos               (18UL)                    /*!< EBU BUSWAP3: EXTDATA (Bit 18)                               */
#define EBU_BUSWAP3_EXTDATA_Msk               (0xc0000UL)               /*!< EBU BUSWAP3: EXTDATA (Bitfield-Mask: 0x03)                  */
#define EBU_BUSWAP3_CMDDELAY_Pos              (20UL)                    /*!< EBU BUSWAP3: CMDDELAY (Bit 20)                              */
#define EBU_BUSWAP3_CMDDELAY_Msk              (0xf00000UL)              /*!< EBU BUSWAP3: CMDDELAY (Bitfield-Mask: 0x0f)                 */
#define EBU_BUSWAP3_AHOLDC_Pos                (24UL)                    /*!< EBU BUSWAP3: AHOLDC (Bit 24)                                */
#define EBU_BUSWAP3_AHOLDC_Msk                (0xf000000UL)             /*!< EBU BUSWAP3: AHOLDC (Bitfield-Mask: 0x0f)                   */
#define EBU_BUSWAP3_ADDRC_Pos                 (28UL)                    /*!< EBU BUSWAP3: ADDRC (Bit 28)                                 */
#define EBU_BUSWAP3_ADDRC_Msk                 (0xf0000000UL)            /*!< EBU BUSWAP3: ADDRC (Bitfield-Mask: 0x0f)                    */

/* ---------------------------------  EBU_SDRMCON  -------------------------------- */
#define EBU_SDRMCON_CRAS_Pos                  (0UL)                     /*!< EBU SDRMCON: CRAS (Bit 0)                                   */
#define EBU_SDRMCON_CRAS_Msk                  (0xfUL)                   /*!< EBU SDRMCON: CRAS (Bitfield-Mask: 0x0f)                     */
#define EBU_SDRMCON_CRFSH_Pos                 (4UL)                     /*!< EBU SDRMCON: CRFSH (Bit 4)                                  */
#define EBU_SDRMCON_CRFSH_Msk                 (0xf0UL)                  /*!< EBU SDRMCON: CRFSH (Bitfield-Mask: 0x0f)                    */
#define EBU_SDRMCON_CRSC_Pos                  (8UL)                     /*!< EBU SDRMCON: CRSC (Bit 8)                                   */
#define EBU_SDRMCON_CRSC_Msk                  (0x300UL)                 /*!< EBU SDRMCON: CRSC (Bitfield-Mask: 0x03)                     */
#define EBU_SDRMCON_CRP_Pos                   (10UL)                    /*!< EBU SDRMCON: CRP (Bit 10)                                   */
#define EBU_SDRMCON_CRP_Msk                   (0xc00UL)                 /*!< EBU SDRMCON: CRP (Bitfield-Mask: 0x03)                      */
#define EBU_SDRMCON_AWIDTH_Pos                (12UL)                    /*!< EBU SDRMCON: AWIDTH (Bit 12)                                */
#define EBU_SDRMCON_AWIDTH_Msk                (0x3000UL)                /*!< EBU SDRMCON: AWIDTH (Bitfield-Mask: 0x03)                   */
#define EBU_SDRMCON_CRCD_Pos                  (14UL)                    /*!< EBU SDRMCON: CRCD (Bit 14)                                  */
#define EBU_SDRMCON_CRCD_Msk                  (0xc000UL)                /*!< EBU SDRMCON: CRCD (Bitfield-Mask: 0x03)                     */
#define EBU_SDRMCON_CRC_Pos                   (16UL)                    /*!< EBU SDRMCON: CRC (Bit 16)                                   */
#define EBU_SDRMCON_CRC_Msk                   (0x70000UL)               /*!< EBU SDRMCON: CRC (Bitfield-Mask: 0x07)                      */
#define EBU_SDRMCON_ROWM_Pos                  (19UL)                    /*!< EBU SDRMCON: ROWM (Bit 19)                                  */
#define EBU_SDRMCON_ROWM_Msk                  (0x380000UL)              /*!< EBU SDRMCON: ROWM (Bitfield-Mask: 0x07)                     */
#define EBU_SDRMCON_BANKM_Pos                 (22UL)                    /*!< EBU SDRMCON: BANKM (Bit 22)                                 */
#define EBU_SDRMCON_BANKM_Msk                 (0x1c00000UL)             /*!< EBU SDRMCON: BANKM (Bitfield-Mask: 0x07)                    */
#define EBU_SDRMCON_CRCE_Pos                  (25UL)                    /*!< EBU SDRMCON: CRCE (Bit 25)                                  */
#define EBU_SDRMCON_CRCE_Msk                  (0xe000000UL)             /*!< EBU SDRMCON: CRCE (Bitfield-Mask: 0x07)                     */
#define EBU_SDRMCON_CLKDIS_Pos                (28UL)                    /*!< EBU SDRMCON: CLKDIS (Bit 28)                                */
#define EBU_SDRMCON_CLKDIS_Msk                (0x10000000UL)            /*!< EBU SDRMCON: CLKDIS (Bitfield-Mask: 0x01)                   */
#define EBU_SDRMCON_PWR_MODE_Pos              (29UL)                    /*!< EBU SDRMCON: PWR_MODE (Bit 29)                              */
#define EBU_SDRMCON_PWR_MODE_Msk              (0x60000000UL)            /*!< EBU SDRMCON: PWR_MODE (Bitfield-Mask: 0x03)                 */
#define EBU_SDRMCON_SDCMSEL_Pos               (31UL)                    /*!< EBU SDRMCON: SDCMSEL (Bit 31)                               */
#define EBU_SDRMCON_SDCMSEL_Msk               (0x80000000UL)            /*!< EBU SDRMCON: SDCMSEL (Bitfield-Mask: 0x01)                  */

/* ---------------------------------  EBU_SDRMOD  --------------------------------- */
#define EBU_SDRMOD_BURSTL_Pos                 (0UL)                     /*!< EBU SDRMOD: BURSTL (Bit 0)                                  */
#define EBU_SDRMOD_BURSTL_Msk                 (0x7UL)                   /*!< EBU SDRMOD: BURSTL (Bitfield-Mask: 0x07)                    */
#define EBU_SDRMOD_BTYP_Pos                   (3UL)                     /*!< EBU SDRMOD: BTYP (Bit 3)                                    */
#define EBU_SDRMOD_BTYP_Msk                   (0x8UL)                   /*!< EBU SDRMOD: BTYP (Bitfield-Mask: 0x01)                      */
#define EBU_SDRMOD_CASLAT_Pos                 (4UL)                     /*!< EBU SDRMOD: CASLAT (Bit 4)                                  */
#define EBU_SDRMOD_CASLAT_Msk                 (0x70UL)                  /*!< EBU SDRMOD: CASLAT (Bitfield-Mask: 0x07)                    */
#define EBU_SDRMOD_OPMODE_Pos                 (7UL)                     /*!< EBU SDRMOD: OPMODE (Bit 7)                                  */
#define EBU_SDRMOD_OPMODE_Msk                 (0x3f80UL)                /*!< EBU SDRMOD: OPMODE (Bitfield-Mask: 0x7f)                    */
#define EBU_SDRMOD_COLDSTART_Pos              (15UL)                    /*!< EBU SDRMOD: COLDSTART (Bit 15)                              */
#define EBU_SDRMOD_COLDSTART_Msk              (0x8000UL)                /*!< EBU SDRMOD: COLDSTART (Bitfield-Mask: 0x01)                 */
#define EBU_SDRMOD_XOPM_Pos                   (16UL)                    /*!< EBU SDRMOD: XOPM (Bit 16)                                   */
#define EBU_SDRMOD_XOPM_Msk                   (0xfff0000UL)             /*!< EBU SDRMOD: XOPM (Bitfield-Mask: 0xfff)                     */
#define EBU_SDRMOD_XBA_Pos                    (28UL)                    /*!< EBU SDRMOD: XBA (Bit 28)                                    */
#define EBU_SDRMOD_XBA_Msk                    (0xf0000000UL)            /*!< EBU SDRMOD: XBA (Bitfield-Mask: 0x0f)                       */

/* ---------------------------------  EBU_SDRMREF  -------------------------------- */
#define EBU_SDRMREF_REFRESHC_Pos              (0UL)                     /*!< EBU SDRMREF: REFRESHC (Bit 0)                               */
#define EBU_SDRMREF_REFRESHC_Msk              (0x3fUL)                  /*!< EBU SDRMREF: REFRESHC (Bitfield-Mask: 0x3f)                 */
#define EBU_SDRMREF_REFRESHR_Pos              (6UL)                     /*!< EBU SDRMREF: REFRESHR (Bit 6)                               */
#define EBU_SDRMREF_REFRESHR_Msk              (0x1c0UL)                 /*!< EBU SDRMREF: REFRESHR (Bitfield-Mask: 0x07)                 */
#define EBU_SDRMREF_SELFREXST_Pos             (9UL)                     /*!< EBU SDRMREF: SELFREXST (Bit 9)                              */
#define EBU_SDRMREF_SELFREXST_Msk             (0x200UL)                 /*!< EBU SDRMREF: SELFREXST (Bitfield-Mask: 0x01)                */
#define EBU_SDRMREF_SELFREX_Pos               (10UL)                    /*!< EBU SDRMREF: SELFREX (Bit 10)                               */
#define EBU_SDRMREF_SELFREX_Msk               (0x400UL)                 /*!< EBU SDRMREF: SELFREX (Bitfield-Mask: 0x01)                  */
#define EBU_SDRMREF_SELFRENST_Pos             (11UL)                    /*!< EBU SDRMREF: SELFRENST (Bit 11)                             */
#define EBU_SDRMREF_SELFRENST_Msk             (0x800UL)                 /*!< EBU SDRMREF: SELFRENST (Bitfield-Mask: 0x01)                */
#define EBU_SDRMREF_SELFREN_Pos               (12UL)                    /*!< EBU SDRMREF: SELFREN (Bit 12)                               */
#define EBU_SDRMREF_SELFREN_Msk               (0x1000UL)                /*!< EBU SDRMREF: SELFREN (Bitfield-Mask: 0x01)                  */
#define EBU_SDRMREF_AUTOSELFR_Pos             (13UL)                    /*!< EBU SDRMREF: AUTOSELFR (Bit 13)                             */
#define EBU_SDRMREF_AUTOSELFR_Msk             (0x2000UL)                /*!< EBU SDRMREF: AUTOSELFR (Bitfield-Mask: 0x01)                */
#define EBU_SDRMREF_ERFSHC_Pos                (14UL)                    /*!< EBU SDRMREF: ERFSHC (Bit 14)                                */
#define EBU_SDRMREF_ERFSHC_Msk                (0xc000UL)                /*!< EBU SDRMREF: ERFSHC (Bitfield-Mask: 0x03)                   */
#define EBU_SDRMREF_SELFREX_DLY_Pos           (16UL)                    /*!< EBU SDRMREF: SELFREX_DLY (Bit 16)                           */
#define EBU_SDRMREF_SELFREX_DLY_Msk           (0xff0000UL)              /*!< EBU SDRMREF: SELFREX_DLY (Bitfield-Mask: 0xff)              */
#define EBU_SDRMREF_ARFSH_Pos                 (24UL)                    /*!< EBU SDRMREF: ARFSH (Bit 24)                                 */
#define EBU_SDRMREF_ARFSH_Msk                 (0x1000000UL)             /*!< EBU SDRMREF: ARFSH (Bitfield-Mask: 0x01)                    */
#define EBU_SDRMREF_RES_DLY_Pos               (25UL)                    /*!< EBU SDRMREF: RES_DLY (Bit 25)                               */
#define EBU_SDRMREF_RES_DLY_Msk               (0xe000000UL)             /*!< EBU SDRMREF: RES_DLY (Bitfield-Mask: 0x07)                  */

/* ---------------------------------  EBU_SDRSTAT  -------------------------------- */
#define EBU_SDRSTAT_REFERR_Pos                (0UL)                     /*!< EBU SDRSTAT: REFERR (Bit 0)                                 */
#define EBU_SDRSTAT_REFERR_Msk                (0x1UL)                   /*!< EBU SDRSTAT: REFERR (Bitfield-Mask: 0x01)                   */
#define EBU_SDRSTAT_SDRMBUSY_Pos              (1UL)                     /*!< EBU SDRSTAT: SDRMBUSY (Bit 1)                               */
#define EBU_SDRSTAT_SDRMBUSY_Msk              (0x2UL)                   /*!< EBU SDRSTAT: SDRMBUSY (Bitfield-Mask: 0x01)                 */
#define EBU_SDRSTAT_SDERR_Pos                 (2UL)                     /*!< EBU SDRSTAT: SDERR (Bit 2)                                  */
#define EBU_SDRSTAT_SDERR_Msk                 (0x4UL)                   /*!< EBU SDRSTAT: SDERR (Bitfield-Mask: 0x01)                    */


/* ================================================================================ */
/* ================        struct 'ETH0_CON' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  ETH0_CON_ETH0_CON  ----------------------------- */
#define ETH_CON_RXD0_Pos            (0UL)                     /*!< ETH0_CON ETH0_CON: RXD0 (Bit 0)                             */
#define ETH_CON_RXD0_Msk            (0x3UL)                   /*!< ETH0_CON ETH0_CON: RXD0 (Bitfield-Mask: 0x03)               */
#define ETH_CON_RXD1_Pos            (2UL)                     /*!< ETH0_CON ETH0_CON: RXD1 (Bit 2)                             */
#define ETH_CON_RXD1_Msk            (0xcUL)                   /*!< ETH0_CON ETH0_CON: RXD1 (Bitfield-Mask: 0x03)               */
#define ETH_CON_RXD2_Pos            (4UL)                     /*!< ETH0_CON ETH0_CON: RXD2 (Bit 4)                             */
#define ETH_CON_RXD2_Msk            (0x30UL)                  /*!< ETH0_CON ETH0_CON: RXD2 (Bitfield-Mask: 0x03)               */
#define ETH_CON_RXD3_Pos            (6UL)                     /*!< ETH0_CON ETH0_CON: RXD3 (Bit 6)                             */
#define ETH_CON_RXD3_Msk            (0xc0UL)                  /*!< ETH0_CON ETH0_CON: RXD3 (Bitfield-Mask: 0x03)               */
#define ETH_CON_CLK_RMII_Pos        (8UL)                     /*!< ETH0_CON ETH0_CON: CLK_RMII (Bit 8)                         */
#define ETH_CON_CLK_RMII_Msk        (0x300UL)                 /*!< ETH0_CON ETH0_CON: CLK_RMII (Bitfield-Mask: 0x03)           */
#define ETH_CON_CRS_DV_Pos          (10UL)                    /*!< ETH0_CON ETH0_CON: CRS_DV (Bit 10)                          */
#define ETH_CON_CRS_DV_Msk          (0xc00UL)                 /*!< ETH0_CON ETH0_CON: CRS_DV (Bitfield-Mask: 0x03)             */
#define ETH_CON_CRS_Pos             (12UL)                    /*!< ETH0_CON ETH0_CON: CRS (Bit 12)                             */
#define ETH_CON_CRS_Msk             (0x3000UL)                /*!< ETH0_CON ETH0_CON: CRS (Bitfield-Mask: 0x03)                */
#define ETH_CON_RXER_Pos            (14UL)                    /*!< ETH0_CON ETH0_CON: RXER (Bit 14)                            */
#define ETH_CON_RXER_Msk            (0xc000UL)                /*!< ETH0_CON ETH0_CON: RXER (Bitfield-Mask: 0x03)               */
#define ETH_CON_COL_Pos             (16UL)                    /*!< ETH0_CON ETH0_CON: COL (Bit 16)                             */
#define ETH_CON_COL_Msk             (0x30000UL)               /*!< ETH0_CON ETH0_CON: COL (Bitfield-Mask: 0x03)                */
#define ETH_CON_CLK_TX_Pos          (18UL)                    /*!< ETH0_CON ETH0_CON: CLK_TX (Bit 18)                          */
#define ETH_CON_CLK_TX_Msk          (0xc0000UL)               /*!< ETH0_CON ETH0_CON: CLK_TX (Bitfield-Mask: 0x03)             */
#define ETH_CON_MDIO_Pos            (22UL)                    /*!< ETH0_CON ETH0_CON: MDIO (Bit 22)                            */
#define ETH_CON_MDIO_Msk            (0xc00000UL)              /*!< ETH0_CON ETH0_CON: MDIO (Bitfield-Mask: 0x03)               */
#define ETH_CON_INFSEL_Pos          (26UL)                    /*!< ETH0_CON ETH0_CON: INFSEL (Bit 26)                          */
#define ETH_CON_INFSEL_Msk          (0x4000000UL)             /*!< ETH0_CON ETH0_CON: INFSEL (Bitfield-Mask: 0x01)             */


/* ================================================================================ */
/* ================           Group 'ETH' Position & Mask          ================ */
/* ================================================================================ */


/* ----------------------------  ETH_MAC_CONFIGURATION  --------------------------- */
#define ETH_MAC_CONFIGURATION_PRELEN_Pos      (0UL)                     /*!< ETH MAC_CONFIGURATION: PRELEN (Bit 0)                       */
#define ETH_MAC_CONFIGURATION_PRELEN_Msk      (0x3UL)                   /*!< ETH MAC_CONFIGURATION: PRELEN (Bitfield-Mask: 0x03)         */
#define ETH_MAC_CONFIGURATION_RE_Pos          (2UL)                     /*!< ETH MAC_CONFIGURATION: RE (Bit 2)                           */
#define ETH_MAC_CONFIGURATION_RE_Msk          (0x4UL)                   /*!< ETH MAC_CONFIGURATION: RE (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_TE_Pos          (3UL)                     /*!< ETH MAC_CONFIGURATION: TE (Bit 3)                           */
#define ETH_MAC_CONFIGURATION_TE_Msk          (0x8UL)                   /*!< ETH MAC_CONFIGURATION: TE (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_DC_Pos          (4UL)                     /*!< ETH MAC_CONFIGURATION: DC (Bit 4)                           */
#define ETH_MAC_CONFIGURATION_DC_Msk          (0x10UL)                  /*!< ETH MAC_CONFIGURATION: DC (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_BL_Pos          (5UL)                     /*!< ETH MAC_CONFIGURATION: BL (Bit 5)                           */
#define ETH_MAC_CONFIGURATION_BL_Msk          (0x60UL)                  /*!< ETH MAC_CONFIGURATION: BL (Bitfield-Mask: 0x03)             */
#define ETH_MAC_CONFIGURATION_ACS_Pos         (7UL)                     /*!< ETH MAC_CONFIGURATION: ACS (Bit 7)                          */
#define ETH_MAC_CONFIGURATION_ACS_Msk         (0x80UL)                  /*!< ETH MAC_CONFIGURATION: ACS (Bitfield-Mask: 0x01)            */
#define ETH_MAC_CONFIGURATION_DR_Pos          (9UL)                     /*!< ETH MAC_CONFIGURATION: DR (Bit 9)                           */
#define ETH_MAC_CONFIGURATION_DR_Msk          (0x200UL)                 /*!< ETH MAC_CONFIGURATION: DR (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_IPC_Pos         (10UL)                    /*!< ETH MAC_CONFIGURATION: IPC (Bit 10)                         */
#define ETH_MAC_CONFIGURATION_IPC_Msk         (0x400UL)                 /*!< ETH MAC_CONFIGURATION: IPC (Bitfield-Mask: 0x01)            */
#define ETH_MAC_CONFIGURATION_DM_Pos          (11UL)                    /*!< ETH MAC_CONFIGURATION: DM (Bit 11)                          */
#define ETH_MAC_CONFIGURATION_DM_Msk          (0x800UL)                 /*!< ETH MAC_CONFIGURATION: DM (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_LM_Pos          (12UL)                    /*!< ETH MAC_CONFIGURATION: LM (Bit 12)                          */
#define ETH_MAC_CONFIGURATION_LM_Msk          (0x1000UL)                /*!< ETH MAC_CONFIGURATION: LM (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_DO_Pos          (13UL)                    /*!< ETH MAC_CONFIGURATION: DO (Bit 13)                          */
#define ETH_MAC_CONFIGURATION_DO_Msk          (0x2000UL)                /*!< ETH MAC_CONFIGURATION: DO (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_FES_Pos         (14UL)                    /*!< ETH MAC_CONFIGURATION: FES (Bit 14)                         */
#define ETH_MAC_CONFIGURATION_FES_Msk         (0x4000UL)                /*!< ETH MAC_CONFIGURATION: FES (Bitfield-Mask: 0x01)            */
#define ETH_MAC_CONFIGURATION_DCRS_Pos        (16UL)                    /*!< ETH MAC_CONFIGURATION: DCRS (Bit 16)                        */
#define ETH_MAC_CONFIGURATION_DCRS_Msk        (0x10000UL)               /*!< ETH MAC_CONFIGURATION: DCRS (Bitfield-Mask: 0x01)           */
#define ETH_MAC_CONFIGURATION_IFG_Pos         (17UL)                    /*!< ETH MAC_CONFIGURATION: IFG (Bit 17)                         */
#define ETH_MAC_CONFIGURATION_IFG_Msk         (0xe0000UL)               /*!< ETH MAC_CONFIGURATION: IFG (Bitfield-Mask: 0x07)            */
#define ETH_MAC_CONFIGURATION_JE_Pos          (20UL)                    /*!< ETH MAC_CONFIGURATION: JE (Bit 20)                          */
#define ETH_MAC_CONFIGURATION_JE_Msk          (0x100000UL)              /*!< ETH MAC_CONFIGURATION: JE (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_BE_Pos          (21UL)                    /*!< ETH MAC_CONFIGURATION: BE (Bit 21)                          */
#define ETH_MAC_CONFIGURATION_BE_Msk          (0x200000UL)              /*!< ETH MAC_CONFIGURATION: BE (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_JD_Pos          (22UL)                    /*!< ETH MAC_CONFIGURATION: JD (Bit 22)                          */
#define ETH_MAC_CONFIGURATION_JD_Msk          (0x400000UL)              /*!< ETH MAC_CONFIGURATION: JD (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_WD_Pos          (23UL)                    /*!< ETH MAC_CONFIGURATION: WD (Bit 23)                          */
#define ETH_MAC_CONFIGURATION_WD_Msk          (0x800000UL)              /*!< ETH MAC_CONFIGURATION: WD (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_TC_Pos          (24UL)                    /*!< ETH MAC_CONFIGURATION: TC (Bit 24)                          */
#define ETH_MAC_CONFIGURATION_TC_Msk          (0x1000000UL)             /*!< ETH MAC_CONFIGURATION: TC (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_CST_Pos         (25UL)                    /*!< ETH MAC_CONFIGURATION: CST (Bit 25)                         */
#define ETH_MAC_CONFIGURATION_CST_Msk         (0x2000000UL)             /*!< ETH MAC_CONFIGURATION: CST (Bitfield-Mask: 0x01)            */
#define ETH_MAC_CONFIGURATION_TWOKPE_Pos      (27UL)                    /*!< ETH MAC_CONFIGURATION: TWOKPE (Bit 27)                      */
#define ETH_MAC_CONFIGURATION_TWOKPE_Msk      (0x8000000UL)             /*!< ETH MAC_CONFIGURATION: TWOKPE (Bitfield-Mask: 0x01)         */
#define ETH_MAC_CONFIGURATION_SARC_Pos        (28UL)                    /*!< ETH MAC_CONFIGURATION: SARC (Bit 28)                        */
#define ETH_MAC_CONFIGURATION_SARC_Msk        (0x70000000UL)            /*!< ETH MAC_CONFIGURATION: SARC (Bitfield-Mask: 0x07)           */

/* ----------------------------  ETH_MAC_FRAME_FILTER  ---------------------------- */
#define ETH_MAC_FRAME_FILTER_PR_Pos           (0UL)                     /*!< ETH MAC_FRAME_FILTER: PR (Bit 0)                            */
#define ETH_MAC_FRAME_FILTER_PR_Msk           (0x1UL)                   /*!< ETH MAC_FRAME_FILTER: PR (Bitfield-Mask: 0x01)              */
#define ETH_MAC_FRAME_FILTER_HUC_Pos          (1UL)                     /*!< ETH MAC_FRAME_FILTER: HUC (Bit 1)                           */
#define ETH_MAC_FRAME_FILTER_HUC_Msk          (0x2UL)                   /*!< ETH MAC_FRAME_FILTER: HUC (Bitfield-Mask: 0x01)             */
#define ETH_MAC_FRAME_FILTER_HMC_Pos          (2UL)                     /*!< ETH MAC_FRAME_FILTER: HMC (Bit 2)                           */
#define ETH_MAC_FRAME_FILTER_HMC_Msk          (0x4UL)                   /*!< ETH MAC_FRAME_FILTER: HMC (Bitfield-Mask: 0x01)             */
#define ETH_MAC_FRAME_FILTER_DAIF_Pos         (3UL)                     /*!< ETH MAC_FRAME_FILTER: DAIF (Bit 3)                          */
#define ETH_MAC_FRAME_FILTER_DAIF_Msk         (0x8UL)                   /*!< ETH MAC_FRAME_FILTER: DAIF (Bitfield-Mask: 0x01)            */
#define ETH_MAC_FRAME_FILTER_PM_Pos           (4UL)                     /*!< ETH MAC_FRAME_FILTER: PM (Bit 4)                            */
#define ETH_MAC_FRAME_FILTER_PM_Msk           (0x10UL)                  /*!< ETH MAC_FRAME_FILTER: PM (Bitfield-Mask: 0x01)              */
#define ETH_MAC_FRAME_FILTER_DBF_Pos          (5UL)                     /*!< ETH MAC_FRAME_FILTER: DBF (Bit 5)                           */
#define ETH_MAC_FRAME_FILTER_DBF_Msk          (0x20UL)                  /*!< ETH MAC_FRAME_FILTER: DBF (Bitfield-Mask: 0x01)             */
#define ETH_MAC_FRAME_FILTER_PCF_Pos          (6UL)                     /*!< ETH MAC_FRAME_FILTER: PCF (Bit 6)                           */
#define ETH_MAC_FRAME_FILTER_PCF_Msk          (0xc0UL)                  /*!< ETH MAC_FRAME_FILTER: PCF (Bitfield-Mask: 0x03)             */
#define ETH_MAC_FRAME_FILTER_SAIF_Pos         (8UL)                     /*!< ETH MAC_FRAME_FILTER: SAIF (Bit 8)                          */
#define ETH_MAC_FRAME_FILTER_SAIF_Msk         (0x100UL)                 /*!< ETH MAC_FRAME_FILTER: SAIF (Bitfield-Mask: 0x01)            */
#define ETH_MAC_FRAME_FILTER_SAF_Pos          (9UL)                     /*!< ETH MAC_FRAME_FILTER: SAF (Bit 9)                           */
#define ETH_MAC_FRAME_FILTER_SAF_Msk          (0x200UL)                 /*!< ETH MAC_FRAME_FILTER: SAF (Bitfield-Mask: 0x01)             */
#define ETH_MAC_FRAME_FILTER_HPF_Pos          (10UL)                    /*!< ETH MAC_FRAME_FILTER: HPF (Bit 10)                          */
#define ETH_MAC_FRAME_FILTER_HPF_Msk          (0x400UL)                 /*!< ETH MAC_FRAME_FILTER: HPF (Bitfield-Mask: 0x01)             */
#define ETH_MAC_FRAME_FILTER_VTFE_Pos         (16UL)                    /*!< ETH MAC_FRAME_FILTER: VTFE (Bit 16)                         */
#define ETH_MAC_FRAME_FILTER_VTFE_Msk         (0x10000UL)               /*!< ETH MAC_FRAME_FILTER: VTFE (Bitfield-Mask: 0x01)            */
#define ETH_MAC_FRAME_FILTER_IPFE_Pos         (20UL)                    /*!< ETH MAC_FRAME_FILTER: IPFE (Bit 20)                         */
#define ETH_MAC_FRAME_FILTER_IPFE_Msk         (0x100000UL)              /*!< ETH MAC_FRAME_FILTER: IPFE (Bitfield-Mask: 0x01)            */
#define ETH_MAC_FRAME_FILTER_DNTU_Pos         (21UL)                    /*!< ETH MAC_FRAME_FILTER: DNTU (Bit 21)                         */
#define ETH_MAC_FRAME_FILTER_DNTU_Msk         (0x200000UL)              /*!< ETH MAC_FRAME_FILTER: DNTU (Bitfield-Mask: 0x01)            */
#define ETH_MAC_FRAME_FILTER_RA_Pos           (31UL)                    /*!< ETH MAC_FRAME_FILTER: RA (Bit 31)                           */
#define ETH_MAC_FRAME_FILTER_RA_Msk           (0x80000000UL)            /*!< ETH MAC_FRAME_FILTER: RA (Bitfield-Mask: 0x01)              */

/* -----------------------------  ETH_HASH_TABLE_HIGH  ---------------------------- */
#define ETH_HASH_TABLE_HIGH_HTH_Pos           (0UL)                     /*!< ETH HASH_TABLE_HIGH: HTH (Bit 0)                            */
#define ETH_HASH_TABLE_HIGH_HTH_Msk           (0xffffffffUL)            /*!< ETH HASH_TABLE_HIGH: HTH (Bitfield-Mask: 0xffffffff)        */

/* -----------------------------  ETH_HASH_TABLE_LOW  ----------------------------- */
#define ETH_HASH_TABLE_LOW_HTL_Pos            (0UL)                     /*!< ETH HASH_TABLE_LOW: HTL (Bit 0)                             */
#define ETH_HASH_TABLE_LOW_HTL_Msk            (0xffffffffUL)            /*!< ETH HASH_TABLE_LOW: HTL (Bitfield-Mask: 0xffffffff)         */

/* ------------------------------  ETH_GMII_ADDRESS  ------------------------------ */
#define ETH_GMII_ADDRESS_MB_Pos               (0UL)                     /*!< ETH GMII_ADDRESS: MB (Bit 0)                                */
#define ETH_GMII_ADDRESS_MB_Msk               (0x1UL)                   /*!< ETH GMII_ADDRESS: MB (Bitfield-Mask: 0x01)                  */
#define ETH_GMII_ADDRESS_MW_Pos               (1UL)                     /*!< ETH GMII_ADDRESS: MW (Bit 1)                                */
#define ETH_GMII_ADDRESS_MW_Msk               (0x2UL)                   /*!< ETH GMII_ADDRESS: MW (Bitfield-Mask: 0x01)                  */
#define ETH_GMII_ADDRESS_CR_Pos               (2UL)                     /*!< ETH GMII_ADDRESS: CR (Bit 2)                                */
#define ETH_GMII_ADDRESS_CR_Msk               (0x3cUL)                  /*!< ETH GMII_ADDRESS: CR (Bitfield-Mask: 0x0f)                  */
#define ETH_GMII_ADDRESS_MR_Pos               (6UL)                     /*!< ETH GMII_ADDRESS: MR (Bit 6)                                */
#define ETH_GMII_ADDRESS_MR_Msk               (0x7c0UL)                 /*!< ETH GMII_ADDRESS: MR (Bitfield-Mask: 0x1f)                  */
#define ETH_GMII_ADDRESS_PA_Pos               (11UL)                    /*!< ETH GMII_ADDRESS: PA (Bit 11)                               */
#define ETH_GMII_ADDRESS_PA_Msk               (0xf800UL)                /*!< ETH GMII_ADDRESS: PA (Bitfield-Mask: 0x1f)                  */

/* --------------------------------  ETH_GMII_DATA  ------------------------------- */
#define ETH_GMII_DATA_MD_Pos                  (0UL)                     /*!< ETH GMII_DATA: MD (Bit 0)                                   */
#define ETH_GMII_DATA_MD_Msk                  (0xffffUL)                /*!< ETH GMII_DATA: MD (Bitfield-Mask: 0xffff)                   */

/* ------------------------------  ETH_FLOW_CONTROL  ------------------------------ */
#define ETH_FLOW_CONTROL_FCA_BPA_Pos          (0UL)                     /*!< ETH FLOW_CONTROL: FCA_BPA (Bit 0)                           */
#define ETH_FLOW_CONTROL_FCA_BPA_Msk          (0x1UL)                   /*!< ETH FLOW_CONTROL: FCA_BPA (Bitfield-Mask: 0x01)             */
#define ETH_FLOW_CONTROL_TFE_Pos              (1UL)                     /*!< ETH FLOW_CONTROL: TFE (Bit 1)                               */
#define ETH_FLOW_CONTROL_TFE_Msk              (0x2UL)                   /*!< ETH FLOW_CONTROL: TFE (Bitfield-Mask: 0x01)                 */
#define ETH_FLOW_CONTROL_RFE_Pos              (2UL)                     /*!< ETH FLOW_CONTROL: RFE (Bit 2)                               */
#define ETH_FLOW_CONTROL_RFE_Msk              (0x4UL)                   /*!< ETH FLOW_CONTROL: RFE (Bitfield-Mask: 0x01)                 */
#define ETH_FLOW_CONTROL_UP_Pos               (3UL)                     /*!< ETH FLOW_CONTROL: UP (Bit 3)                                */
#define ETH_FLOW_CONTROL_UP_Msk               (0x8UL)                   /*!< ETH FLOW_CONTROL: UP (Bitfield-Mask: 0x01)                  */
#define ETH_FLOW_CONTROL_PLT_Pos              (4UL)                     /*!< ETH FLOW_CONTROL: PLT (Bit 4)                               */
#define ETH_FLOW_CONTROL_PLT_Msk              (0x30UL)                  /*!< ETH FLOW_CONTROL: PLT (Bitfield-Mask: 0x03)                 */
#define ETH_FLOW_CONTROL_DZPQ_Pos             (7UL)                     /*!< ETH FLOW_CONTROL: DZPQ (Bit 7)                              */
#define ETH_FLOW_CONTROL_DZPQ_Msk             (0x80UL)                  /*!< ETH FLOW_CONTROL: DZPQ (Bitfield-Mask: 0x01)                */
#define ETH_FLOW_CONTROL_PT_Pos               (16UL)                    /*!< ETH FLOW_CONTROL: PT (Bit 16)                               */
#define ETH_FLOW_CONTROL_PT_Msk               (0xffff0000UL)            /*!< ETH FLOW_CONTROL: PT (Bitfield-Mask: 0xffff)                */

/* --------------------------------  ETH_VLAN_TAG  -------------------------------- */
#define ETH_VLAN_TAG_VL_Pos                   (0UL)                     /*!< ETH VLAN_TAG: VL (Bit 0)                                    */
#define ETH_VLAN_TAG_VL_Msk                   (0xffffUL)                /*!< ETH VLAN_TAG: VL (Bitfield-Mask: 0xffff)                    */
#define ETH_VLAN_TAG_ETV_Pos                  (16UL)                    /*!< ETH VLAN_TAG: ETV (Bit 16)                                  */
#define ETH_VLAN_TAG_ETV_Msk                  (0x10000UL)               /*!< ETH VLAN_TAG: ETV (Bitfield-Mask: 0x01)                     */
#define ETH_VLAN_TAG_VTIM_Pos                 (17UL)                    /*!< ETH VLAN_TAG: VTIM (Bit 17)                                 */
#define ETH_VLAN_TAG_VTIM_Msk                 (0x20000UL)               /*!< ETH VLAN_TAG: VTIM (Bitfield-Mask: 0x01)                    */
#define ETH_VLAN_TAG_ESVL_Pos                 (18UL)                    /*!< ETH VLAN_TAG: ESVL (Bit 18)                                 */
#define ETH_VLAN_TAG_ESVL_Msk                 (0x40000UL)               /*!< ETH VLAN_TAG: ESVL (Bitfield-Mask: 0x01)                    */
#define ETH_VLAN_TAG_VTHM_Pos                 (19UL)                    /*!< ETH VLAN_TAG: VTHM (Bit 19)                                 */
#define ETH_VLAN_TAG_VTHM_Msk                 (0x80000UL)               /*!< ETH VLAN_TAG: VTHM (Bitfield-Mask: 0x01)                    */

/* ---------------------------------  ETH_VERSION  -------------------------------- */
#define ETH_VERSION_SNPSVER_Pos               (0UL)                     /*!< ETH VERSION: SNPSVER (Bit 0)                                */
#define ETH_VERSION_SNPSVER_Msk               (0xffUL)                  /*!< ETH VERSION: SNPSVER (Bitfield-Mask: 0xff)                  */
#define ETH_VERSION_USERVER_Pos               (8UL)                     /*!< ETH VERSION: USERVER (Bit 8)                                */
#define ETH_VERSION_USERVER_Msk               (0xff00UL)                /*!< ETH VERSION: USERVER (Bitfield-Mask: 0xff)                  */

/* ----------------------------------  ETH_DEBUG  --------------------------------- */
#define ETH_DEBUG_RPESTS_Pos                  (0UL)                     /*!< ETH DEBUG: RPESTS (Bit 0)                                   */
#define ETH_DEBUG_RPESTS_Msk                  (0x1UL)                   /*!< ETH DEBUG: RPESTS (Bitfield-Mask: 0x01)                     */
#define ETH_DEBUG_RFCFCSTS_Pos                (1UL)                     /*!< ETH DEBUG: RFCFCSTS (Bit 1)                                 */
#define ETH_DEBUG_RFCFCSTS_Msk                (0x6UL)                   /*!< ETH DEBUG: RFCFCSTS (Bitfield-Mask: 0x03)                   */
#define ETH_DEBUG_RWCSTS_Pos                  (4UL)                     /*!< ETH DEBUG: RWCSTS (Bit 4)                                   */
#define ETH_DEBUG_RWCSTS_Msk                  (0x10UL)                  /*!< ETH DEBUG: RWCSTS (Bitfield-Mask: 0x01)                     */
#define ETH_DEBUG_RRCSTS_Pos                  (5UL)                     /*!< ETH DEBUG: RRCSTS (Bit 5)                                   */
#define ETH_DEBUG_RRCSTS_Msk                  (0x60UL)                  /*!< ETH DEBUG: RRCSTS (Bitfield-Mask: 0x03)                     */
#define ETH_DEBUG_RXFSTS_Pos                  (8UL)                     /*!< ETH DEBUG: RXFSTS (Bit 8)                                   */
#define ETH_DEBUG_RXFSTS_Msk                  (0x300UL)                 /*!< ETH DEBUG: RXFSTS (Bitfield-Mask: 0x03)                     */
#define ETH_DEBUG_TPESTS_Pos                  (16UL)                    /*!< ETH DEBUG: TPESTS (Bit 16)                                  */
#define ETH_DEBUG_TPESTS_Msk                  (0x10000UL)               /*!< ETH DEBUG: TPESTS (Bitfield-Mask: 0x01)                     */
#define ETH_DEBUG_TFCSTS_Pos                  (17UL)                    /*!< ETH DEBUG: TFCSTS (Bit 17)                                  */
#define ETH_DEBUG_TFCSTS_Msk                  (0x60000UL)               /*!< ETH DEBUG: TFCSTS (Bitfield-Mask: 0x03)                     */
#define ETH_DEBUG_TXPAUSED_Pos                (19UL)                    /*!< ETH DEBUG: TXPAUSED (Bit 19)                                */
#define ETH_DEBUG_TXPAUSED_Msk                (0x80000UL)               /*!< ETH DEBUG: TXPAUSED (Bitfield-Mask: 0x01)                   */
#define ETH_DEBUG_TRCSTS_Pos                  (20UL)                    /*!< ETH DEBUG: TRCSTS (Bit 20)                                  */
#define ETH_DEBUG_TRCSTS_Msk                  (0x300000UL)              /*!< ETH DEBUG: TRCSTS (Bitfield-Mask: 0x03)                     */
#define ETH_DEBUG_TWCSTS_Pos                  (22UL)                    /*!< ETH DEBUG: TWCSTS (Bit 22)                                  */
#define ETH_DEBUG_TWCSTS_Msk                  (0x400000UL)              /*!< ETH DEBUG: TWCSTS (Bitfield-Mask: 0x01)                     */
#define ETH_DEBUG_TXFSTS_Pos                  (24UL)                    /*!< ETH DEBUG: TXFSTS (Bit 24)                                  */
#define ETH_DEBUG_TXFSTS_Msk                  (0x1000000UL)             /*!< ETH DEBUG: TXFSTS (Bitfield-Mask: 0x01)                     */
#define ETH_DEBUG_TXSTSFSTS_Pos               (25UL)                    /*!< ETH DEBUG: TXSTSFSTS (Bit 25)                               */
#define ETH_DEBUG_TXSTSFSTS_Msk               (0x2000000UL)             /*!< ETH DEBUG: TXSTSFSTS (Bitfield-Mask: 0x01)                  */

/* -----------------------  ETH_REMOTE_WAKE_UP_FRAME_FILTER  ---------------------- */
#define ETH_REMOTE_WAKE_UP_FRAME_FILTER_WKUPFRMFTR_Pos (0UL)            /*!< ETH REMOTE_WAKE_UP_FRAME_FILTER: WKUPFRMFTR (Bit 0)         */
#define ETH_REMOTE_WAKE_UP_FRAME_FILTER_WKUPFRMFTR_Msk (0xffffffffUL)   /*!< ETH REMOTE_WAKE_UP_FRAME_FILTER: WKUPFRMFTR (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_PMT_CONTROL_STATUS  --------------------------- */
#define ETH_PMT_CONTROL_STATUS_PWRDWN_Pos     (0UL)                     /*!< ETH PMT_CONTROL_STATUS: PWRDWN (Bit 0)                      */
#define ETH_PMT_CONTROL_STATUS_PWRDWN_Msk     (0x1UL)                   /*!< ETH PMT_CONTROL_STATUS: PWRDWN (Bitfield-Mask: 0x01)        */
#define ETH_PMT_CONTROL_STATUS_MGKPKTEN_Pos   (1UL)                     /*!< ETH PMT_CONTROL_STATUS: MGKPKTEN (Bit 1)                    */
#define ETH_PMT_CONTROL_STATUS_MGKPKTEN_Msk   (0x2UL)                   /*!< ETH PMT_CONTROL_STATUS: MGKPKTEN (Bitfield-Mask: 0x01)      */
#define ETH_PMT_CONTROL_STATUS_RWKPKTEN_Pos   (2UL)                     /*!< ETH PMT_CONTROL_STATUS: RWKPKTEN (Bit 2)                    */
#define ETH_PMT_CONTROL_STATUS_RWKPKTEN_Msk   (0x4UL)                   /*!< ETH PMT_CONTROL_STATUS: RWKPKTEN (Bitfield-Mask: 0x01)      */
#define ETH_PMT_CONTROL_STATUS_MGKPRCVD_Pos   (5UL)                     /*!< ETH PMT_CONTROL_STATUS: MGKPRCVD (Bit 5)                    */
#define ETH_PMT_CONTROL_STATUS_MGKPRCVD_Msk   (0x20UL)                  /*!< ETH PMT_CONTROL_STATUS: MGKPRCVD (Bitfield-Mask: 0x01)      */
#define ETH_PMT_CONTROL_STATUS_RWKPRCVD_Pos   (6UL)                     /*!< ETH PMT_CONTROL_STATUS: RWKPRCVD (Bit 6)                    */
#define ETH_PMT_CONTROL_STATUS_RWKPRCVD_Msk   (0x40UL)                  /*!< ETH PMT_CONTROL_STATUS: RWKPRCVD (Bitfield-Mask: 0x01)      */
#define ETH_PMT_CONTROL_STATUS_GLBLUCAST_Pos  (9UL)                     /*!< ETH PMT_CONTROL_STATUS: GLBLUCAST (Bit 9)                   */
#define ETH_PMT_CONTROL_STATUS_GLBLUCAST_Msk  (0x200UL)                 /*!< ETH PMT_CONTROL_STATUS: GLBLUCAST (Bitfield-Mask: 0x01)     */
#define ETH_PMT_CONTROL_STATUS_RWKFILTRST_Pos (31UL)                    /*!< ETH PMT_CONTROL_STATUS: RWKFILTRST (Bit 31)                 */
#define ETH_PMT_CONTROL_STATUS_RWKFILTRST_Msk (0x80000000UL)            /*!< ETH PMT_CONTROL_STATUS: RWKFILTRST (Bitfield-Mask: 0x01)    */

/* ----------------------------  ETH_INTERRUPT_STATUS  ---------------------------- */
#define ETH_INTERRUPT_STATUS_PMTIS_Pos        (3UL)                     /*!< ETH INTERRUPT_STATUS: PMTIS (Bit 3)                         */
#define ETH_INTERRUPT_STATUS_PMTIS_Msk        (0x8UL)                   /*!< ETH INTERRUPT_STATUS: PMTIS (Bitfield-Mask: 0x01)           */
#define ETH_INTERRUPT_STATUS_MMCIS_Pos        (4UL)                     /*!< ETH INTERRUPT_STATUS: MMCIS (Bit 4)                         */
#define ETH_INTERRUPT_STATUS_MMCIS_Msk        (0x10UL)                  /*!< ETH INTERRUPT_STATUS: MMCIS (Bitfield-Mask: 0x01)           */
#define ETH_INTERRUPT_STATUS_MMCRXIS_Pos      (5UL)                     /*!< ETH INTERRUPT_STATUS: MMCRXIS (Bit 5)                       */
#define ETH_INTERRUPT_STATUS_MMCRXIS_Msk      (0x20UL)                  /*!< ETH INTERRUPT_STATUS: MMCRXIS (Bitfield-Mask: 0x01)         */
#define ETH_INTERRUPT_STATUS_MMCTXIS_Pos      (6UL)                     /*!< ETH INTERRUPT_STATUS: MMCTXIS (Bit 6)                       */
#define ETH_INTERRUPT_STATUS_MMCTXIS_Msk      (0x40UL)                  /*!< ETH INTERRUPT_STATUS: MMCTXIS (Bitfield-Mask: 0x01)         */
#define ETH_INTERRUPT_STATUS_MMCRXIPIS_Pos    (7UL)                     /*!< ETH INTERRUPT_STATUS: MMCRXIPIS (Bit 7)                     */
#define ETH_INTERRUPT_STATUS_MMCRXIPIS_Msk    (0x80UL)                  /*!< ETH INTERRUPT_STATUS: MMCRXIPIS (Bitfield-Mask: 0x01)       */
#define ETH_INTERRUPT_STATUS_TSIS_Pos         (9UL)                     /*!< ETH INTERRUPT_STATUS: TSIS (Bit 9)                          */
#define ETH_INTERRUPT_STATUS_TSIS_Msk         (0x200UL)                 /*!< ETH INTERRUPT_STATUS: TSIS (Bitfield-Mask: 0x01)            */

/* -----------------------------  ETH_INTERRUPT_MASK  ----------------------------- */
#define ETH_INTERRUPT_MASK_PMTIM_Pos          (3UL)                     /*!< ETH INTERRUPT_MASK: PMTIM (Bit 3)                           */
#define ETH_INTERRUPT_MASK_PMTIM_Msk          (0x8UL)                   /*!< ETH INTERRUPT_MASK: PMTIM (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_MASK_TSIM_Pos           (9UL)                     /*!< ETH INTERRUPT_MASK: TSIM (Bit 9)                            */
#define ETH_INTERRUPT_MASK_TSIM_Msk           (0x200UL)                 /*!< ETH INTERRUPT_MASK: TSIM (Bitfield-Mask: 0x01)              */

/* ----------------------------  ETH_MAC_ADDRESS0_HIGH  --------------------------- */
#define ETH_MAC_ADDRESS0_HIGH_ADDRHI_Pos      (0UL)                     /*!< ETH MAC_ADDRESS0_HIGH: ADDRHI (Bit 0)                       */
#define ETH_MAC_ADDRESS0_HIGH_ADDRHI_Msk      (0xffffUL)                /*!< ETH MAC_ADDRESS0_HIGH: ADDRHI (Bitfield-Mask: 0xffff)       */
#define ETH_MAC_ADDRESS0_HIGH_AE_Pos          (31UL)                    /*!< ETH MAC_ADDRESS0_HIGH: AE (Bit 31)                          */
#define ETH_MAC_ADDRESS0_HIGH_AE_Msk          (0x80000000UL)            /*!< ETH MAC_ADDRESS0_HIGH: AE (Bitfield-Mask: 0x01)             */

/* ----------------------------  ETH_MAC_ADDRESS0_LOW  ---------------------------- */
#define ETH_MAC_ADDRESS0_LOW_ADDRLO_Pos       (0UL)                     /*!< ETH MAC_ADDRESS0_LOW: ADDRLO (Bit 0)                        */
#define ETH_MAC_ADDRESS0_LOW_ADDRLO_Msk       (0xffffffffUL)            /*!< ETH MAC_ADDRESS0_LOW: ADDRLO (Bitfield-Mask: 0xffffffff)    */

/* ----------------------------  ETH_MAC_ADDRESS1_HIGH  --------------------------- */
#define ETH_MAC_ADDRESS1_HIGH_ADDRHI_Pos      (0UL)                     /*!< ETH MAC_ADDRESS1_HIGH: ADDRHI (Bit 0)                       */
#define ETH_MAC_ADDRESS1_HIGH_ADDRHI_Msk      (0xffffUL)                /*!< ETH MAC_ADDRESS1_HIGH: ADDRHI (Bitfield-Mask: 0xffff)       */
#define ETH_MAC_ADDRESS1_HIGH_MBC_Pos         (24UL)                    /*!< ETH MAC_ADDRESS1_HIGH: MBC (Bit 24)                         */
#define ETH_MAC_ADDRESS1_HIGH_MBC_Msk         (0x3f000000UL)            /*!< ETH MAC_ADDRESS1_HIGH: MBC (Bitfield-Mask: 0x3f)            */
#define ETH_MAC_ADDRESS1_HIGH_SA_Pos          (30UL)                    /*!< ETH MAC_ADDRESS1_HIGH: SA (Bit 30)                          */
#define ETH_MAC_ADDRESS1_HIGH_SA_Msk          (0x40000000UL)            /*!< ETH MAC_ADDRESS1_HIGH: SA (Bitfield-Mask: 0x01)             */
#define ETH_MAC_ADDRESS1_HIGH_AE_Pos          (31UL)                    /*!< ETH MAC_ADDRESS1_HIGH: AE (Bit 31)                          */
#define ETH_MAC_ADDRESS1_HIGH_AE_Msk          (0x80000000UL)            /*!< ETH MAC_ADDRESS1_HIGH: AE (Bitfield-Mask: 0x01)             */

/* ----------------------------  ETH_MAC_ADDRESS1_LOW  ---------------------------- */
#define ETH_MAC_ADDRESS1_LOW_ADDRLO_Pos       (0UL)                     /*!< ETH MAC_ADDRESS1_LOW: ADDRLO (Bit 0)                        */
#define ETH_MAC_ADDRESS1_LOW_ADDRLO_Msk       (0xffffffffUL)            /*!< ETH MAC_ADDRESS1_LOW: ADDRLO (Bitfield-Mask: 0xffffffff)    */

/* ----------------------------  ETH_MAC_ADDRESS2_HIGH  --------------------------- */
#define ETH_MAC_ADDRESS2_HIGH_ADDRHI_Pos      (0UL)                     /*!< ETH MAC_ADDRESS2_HIGH: ADDRHI (Bit 0)                       */
#define ETH_MAC_ADDRESS2_HIGH_ADDRHI_Msk      (0xffffUL)                /*!< ETH MAC_ADDRESS2_HIGH: ADDRHI (Bitfield-Mask: 0xffff)       */
#define ETH_MAC_ADDRESS2_HIGH_MBC_Pos         (24UL)                    /*!< ETH MAC_ADDRESS2_HIGH: MBC (Bit 24)                         */
#define ETH_MAC_ADDRESS2_HIGH_MBC_Msk         (0x3f000000UL)            /*!< ETH MAC_ADDRESS2_HIGH: MBC (Bitfield-Mask: 0x3f)            */
#define ETH_MAC_ADDRESS2_HIGH_SA_Pos          (30UL)                    /*!< ETH MAC_ADDRESS2_HIGH: SA (Bit 30)                          */
#define ETH_MAC_ADDRESS2_HIGH_SA_Msk          (0x40000000UL)            /*!< ETH MAC_ADDRESS2_HIGH: SA (Bitfield-Mask: 0x01)             */
#define ETH_MAC_ADDRESS2_HIGH_AE_Pos          (31UL)                    /*!< ETH MAC_ADDRESS2_HIGH: AE (Bit 31)                          */
#define ETH_MAC_ADDRESS2_HIGH_AE_Msk          (0x80000000UL)            /*!< ETH MAC_ADDRESS2_HIGH: AE (Bitfield-Mask: 0x01)             */

/* ----------------------------  ETH_MAC_ADDRESS2_LOW  ---------------------------- */
#define ETH_MAC_ADDRESS2_LOW_ADDRLO_Pos       (0UL)                     /*!< ETH MAC_ADDRESS2_LOW: ADDRLO (Bit 0)                        */
#define ETH_MAC_ADDRESS2_LOW_ADDRLO_Msk       (0xffffffffUL)            /*!< ETH MAC_ADDRESS2_LOW: ADDRLO (Bitfield-Mask: 0xffffffff)    */

/* ----------------------------  ETH_MAC_ADDRESS3_HIGH  --------------------------- */
#define ETH_MAC_ADDRESS3_HIGH_ADDRHI_Pos      (0UL)                     /*!< ETH MAC_ADDRESS3_HIGH: ADDRHI (Bit 0)                       */
#define ETH_MAC_ADDRESS3_HIGH_ADDRHI_Msk      (0xffffUL)                /*!< ETH MAC_ADDRESS3_HIGH: ADDRHI (Bitfield-Mask: 0xffff)       */
#define ETH_MAC_ADDRESS3_HIGH_MBC_Pos         (24UL)                    /*!< ETH MAC_ADDRESS3_HIGH: MBC (Bit 24)                         */
#define ETH_MAC_ADDRESS3_HIGH_MBC_Msk         (0x3f000000UL)            /*!< ETH MAC_ADDRESS3_HIGH: MBC (Bitfield-Mask: 0x3f)            */
#define ETH_MAC_ADDRESS3_HIGH_SA_Pos          (30UL)                    /*!< ETH MAC_ADDRESS3_HIGH: SA (Bit 30)                          */
#define ETH_MAC_ADDRESS3_HIGH_SA_Msk          (0x40000000UL)            /*!< ETH MAC_ADDRESS3_HIGH: SA (Bitfield-Mask: 0x01)             */
#define ETH_MAC_ADDRESS3_HIGH_AE_Pos          (31UL)                    /*!< ETH MAC_ADDRESS3_HIGH: AE (Bit 31)                          */
#define ETH_MAC_ADDRESS3_HIGH_AE_Msk          (0x80000000UL)            /*!< ETH MAC_ADDRESS3_HIGH: AE (Bitfield-Mask: 0x01)             */

/* ----------------------------  ETH_MAC_ADDRESS3_LOW  ---------------------------- */
#define ETH_MAC_ADDRESS3_LOW_ADDRLO_Pos       (0UL)                     /*!< ETH MAC_ADDRESS3_LOW: ADDRLO (Bit 0)                        */
#define ETH_MAC_ADDRESS3_LOW_ADDRLO_Msk       (0xffffffffUL)            /*!< ETH MAC_ADDRESS3_LOW: ADDRLO (Bitfield-Mask: 0xffffffff)    */

/* -------------------------------  ETH_MMC_CONTROL  ------------------------------ */
#define ETH_MMC_CONTROL_CNTRST_Pos            (0UL)                     /*!< ETH MMC_CONTROL: CNTRST (Bit 0)                             */
#define ETH_MMC_CONTROL_CNTRST_Msk            (0x1UL)                   /*!< ETH MMC_CONTROL: CNTRST (Bitfield-Mask: 0x01)               */
#define ETH_MMC_CONTROL_CNTSTOPRO_Pos         (1UL)                     /*!< ETH MMC_CONTROL: CNTSTOPRO (Bit 1)                          */
#define ETH_MMC_CONTROL_CNTSTOPRO_Msk         (0x2UL)                   /*!< ETH MMC_CONTROL: CNTSTOPRO (Bitfield-Mask: 0x01)            */
#define ETH_MMC_CONTROL_RSTONRD_Pos           (2UL)                     /*!< ETH MMC_CONTROL: RSTONRD (Bit 2)                            */
#define ETH_MMC_CONTROL_RSTONRD_Msk           (0x4UL)                   /*!< ETH MMC_CONTROL: RSTONRD (Bitfield-Mask: 0x01)              */
#define ETH_MMC_CONTROL_CNTFREEZ_Pos          (3UL)                     /*!< ETH MMC_CONTROL: CNTFREEZ (Bit 3)                           */
#define ETH_MMC_CONTROL_CNTFREEZ_Msk          (0x8UL)                   /*!< ETH MMC_CONTROL: CNTFREEZ (Bitfield-Mask: 0x01)             */
#define ETH_MMC_CONTROL_CNTPRST_Pos           (4UL)                     /*!< ETH MMC_CONTROL: CNTPRST (Bit 4)                            */
#define ETH_MMC_CONTROL_CNTPRST_Msk           (0x10UL)                  /*!< ETH MMC_CONTROL: CNTPRST (Bitfield-Mask: 0x01)              */
#define ETH_MMC_CONTROL_CNTPRSTLVL_Pos        (5UL)                     /*!< ETH MMC_CONTROL: CNTPRSTLVL (Bit 5)                         */
#define ETH_MMC_CONTROL_CNTPRSTLVL_Msk        (0x20UL)                  /*!< ETH MMC_CONTROL: CNTPRSTLVL (Bitfield-Mask: 0x01)           */
#define ETH_MMC_CONTROL_UCDBC_Pos             (8UL)                     /*!< ETH MMC_CONTROL: UCDBC (Bit 8)                              */
#define ETH_MMC_CONTROL_UCDBC_Msk             (0x100UL)                 /*!< ETH MMC_CONTROL: UCDBC (Bitfield-Mask: 0x01)                */

/* --------------------------  ETH_MMC_RECEIVE_INTERRUPT  ------------------------- */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGBFRMIS_Pos (0UL)                   /*!< ETH MMC_RECEIVE_INTERRUPT: RXGBFRMIS (Bit 0)                */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGBFRMIS_Msk (0x1UL)                 /*!< ETH MMC_RECEIVE_INTERRUPT: RXGBFRMIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGBOCTIS_Pos (1UL)                   /*!< ETH MMC_RECEIVE_INTERRUPT: RXGBOCTIS (Bit 1)                */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGBOCTIS_Msk (0x2UL)                 /*!< ETH MMC_RECEIVE_INTERRUPT: RXGBOCTIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGOCTIS_Pos (2UL)                    /*!< ETH MMC_RECEIVE_INTERRUPT: RXGOCTIS (Bit 2)                 */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGOCTIS_Msk (0x4UL)                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXGOCTIS (Bitfield-Mask: 0x01)   */
#define ETH_MMC_RECEIVE_INTERRUPT_RXBCGFIS_Pos (3UL)                    /*!< ETH MMC_RECEIVE_INTERRUPT: RXBCGFIS (Bit 3)                 */
#define ETH_MMC_RECEIVE_INTERRUPT_RXBCGFIS_Msk (0x8UL)                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXBCGFIS (Bitfield-Mask: 0x01)   */
#define ETH_MMC_RECEIVE_INTERRUPT_RXMCGFIS_Pos (4UL)                    /*!< ETH MMC_RECEIVE_INTERRUPT: RXMCGFIS (Bit 4)                 */
#define ETH_MMC_RECEIVE_INTERRUPT_RXMCGFIS_Msk (0x10UL)                 /*!< ETH MMC_RECEIVE_INTERRUPT: RXMCGFIS (Bitfield-Mask: 0x01)   */
#define ETH_MMC_RECEIVE_INTERRUPT_RXCRCERFIS_Pos (5UL)                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXCRCERFIS (Bit 5)               */
#define ETH_MMC_RECEIVE_INTERRUPT_RXCRCERFIS_Msk (0x20UL)               /*!< ETH MMC_RECEIVE_INTERRUPT: RXCRCERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXALGNERFIS_Pos (6UL)                 /*!< ETH MMC_RECEIVE_INTERRUPT: RXALGNERFIS (Bit 6)              */
#define ETH_MMC_RECEIVE_INTERRUPT_RXALGNERFIS_Msk (0x40UL)              /*!< ETH MMC_RECEIVE_INTERRUPT: RXALGNERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXRUNTFIS_Pos (7UL)                   /*!< ETH MMC_RECEIVE_INTERRUPT: RXRUNTFIS (Bit 7)                */
#define ETH_MMC_RECEIVE_INTERRUPT_RXRUNTFIS_Msk (0x80UL)                /*!< ETH MMC_RECEIVE_INTERRUPT: RXRUNTFIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_RECEIVE_INTERRUPT_RXJABERFIS_Pos (8UL)                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXJABERFIS (Bit 8)               */
#define ETH_MMC_RECEIVE_INTERRUPT_RXJABERFIS_Msk (0x100UL)              /*!< ETH MMC_RECEIVE_INTERRUPT: RXJABERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXUSIZEGFIS_Pos (9UL)                 /*!< ETH MMC_RECEIVE_INTERRUPT: RXUSIZEGFIS (Bit 9)              */
#define ETH_MMC_RECEIVE_INTERRUPT_RXUSIZEGFIS_Msk (0x200UL)             /*!< ETH MMC_RECEIVE_INTERRUPT: RXUSIZEGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXOSIZEGFIS_Pos (10UL)                /*!< ETH MMC_RECEIVE_INTERRUPT: RXOSIZEGFIS (Bit 10)             */
#define ETH_MMC_RECEIVE_INTERRUPT_RXOSIZEGFIS_Msk (0x400UL)             /*!< ETH MMC_RECEIVE_INTERRUPT: RXOSIZEGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RX64OCTGBFIS_Pos (11UL)               /*!< ETH MMC_RECEIVE_INTERRUPT: RX64OCTGBFIS (Bit 11)            */
#define ETH_MMC_RECEIVE_INTERRUPT_RX64OCTGBFIS_Msk (0x800UL)            /*!< ETH MMC_RECEIVE_INTERRUPT: RX64OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RX65T127OCTGBFIS_Pos (12UL)           /*!< ETH MMC_RECEIVE_INTERRUPT: RX65T127OCTGBFIS (Bit 12)        */
#define ETH_MMC_RECEIVE_INTERRUPT_RX65T127OCTGBFIS_Msk (0x1000UL)       /*!< ETH MMC_RECEIVE_INTERRUPT: RX65T127OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RX128T255OCTGBFIS_Pos (13UL)          /*!< ETH MMC_RECEIVE_INTERRUPT: RX128T255OCTGBFIS (Bit 13)       */
#define ETH_MMC_RECEIVE_INTERRUPT_RX128T255OCTGBFIS_Msk (0x2000UL)      /*!< ETH MMC_RECEIVE_INTERRUPT: RX128T255OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RX256T511OCTGBFIS_Pos (14UL)          /*!< ETH MMC_RECEIVE_INTERRUPT: RX256T511OCTGBFIS (Bit 14)       */
#define ETH_MMC_RECEIVE_INTERRUPT_RX256T511OCTGBFIS_Msk (0x4000UL)      /*!< ETH MMC_RECEIVE_INTERRUPT: RX256T511OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RX512T1023OCTGBFIS_Pos (15UL)         /*!< ETH MMC_RECEIVE_INTERRUPT: RX512T1023OCTGBFIS (Bit 15)      */
#define ETH_MMC_RECEIVE_INTERRUPT_RX512T1023OCTGBFIS_Msk (0x8000UL)     /*!< ETH MMC_RECEIVE_INTERRUPT: RX512T1023OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RX1024TMAXOCTGBFIS_Pos (16UL)         /*!< ETH MMC_RECEIVE_INTERRUPT: RX1024TMAXOCTGBFIS (Bit 16)      */
#define ETH_MMC_RECEIVE_INTERRUPT_RX1024TMAXOCTGBFIS_Msk (0x10000UL)    /*!< ETH MMC_RECEIVE_INTERRUPT: RX1024TMAXOCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXUCGFIS_Pos (17UL)                   /*!< ETH MMC_RECEIVE_INTERRUPT: RXUCGFIS (Bit 17)                */
#define ETH_MMC_RECEIVE_INTERRUPT_RXUCGFIS_Msk (0x20000UL)              /*!< ETH MMC_RECEIVE_INTERRUPT: RXUCGFIS (Bitfield-Mask: 0x01)   */
#define ETH_MMC_RECEIVE_INTERRUPT_RXLENERFIS_Pos (18UL)                 /*!< ETH MMC_RECEIVE_INTERRUPT: RXLENERFIS (Bit 18)              */
#define ETH_MMC_RECEIVE_INTERRUPT_RXLENERFIS_Msk (0x40000UL)            /*!< ETH MMC_RECEIVE_INTERRUPT: RXLENERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXORANGEFIS_Pos (19UL)                /*!< ETH MMC_RECEIVE_INTERRUPT: RXORANGEFIS (Bit 19)             */
#define ETH_MMC_RECEIVE_INTERRUPT_RXORANGEFIS_Msk (0x80000UL)           /*!< ETH MMC_RECEIVE_INTERRUPT: RXORANGEFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXPAUSFIS_Pos (20UL)                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXPAUSFIS (Bit 20)               */
#define ETH_MMC_RECEIVE_INTERRUPT_RXPAUSFIS_Msk (0x100000UL)            /*!< ETH MMC_RECEIVE_INTERRUPT: RXPAUSFIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_RECEIVE_INTERRUPT_RXFOVFIS_Pos (21UL)                   /*!< ETH MMC_RECEIVE_INTERRUPT: RXFOVFIS (Bit 21)                */
#define ETH_MMC_RECEIVE_INTERRUPT_RXFOVFIS_Msk (0x200000UL)             /*!< ETH MMC_RECEIVE_INTERRUPT: RXFOVFIS (Bitfield-Mask: 0x01)   */
#define ETH_MMC_RECEIVE_INTERRUPT_RXVLANGBFIS_Pos (22UL)                /*!< ETH MMC_RECEIVE_INTERRUPT: RXVLANGBFIS (Bit 22)             */
#define ETH_MMC_RECEIVE_INTERRUPT_RXVLANGBFIS_Msk (0x400000UL)          /*!< ETH MMC_RECEIVE_INTERRUPT: RXVLANGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXWDOGFIS_Pos (23UL)                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXWDOGFIS (Bit 23)               */
#define ETH_MMC_RECEIVE_INTERRUPT_RXWDOGFIS_Msk (0x800000UL)            /*!< ETH MMC_RECEIVE_INTERRUPT: RXWDOGFIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_RECEIVE_INTERRUPT_RXRCVERRFIS_Pos (24UL)                /*!< ETH MMC_RECEIVE_INTERRUPT: RXRCVERRFIS (Bit 24)             */
#define ETH_MMC_RECEIVE_INTERRUPT_RXRCVERRFIS_Msk (0x1000000UL)         /*!< ETH MMC_RECEIVE_INTERRUPT: RXRCVERRFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXCTRLFIS_Pos (25UL)                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXCTRLFIS (Bit 25)               */
#define ETH_MMC_RECEIVE_INTERRUPT_RXCTRLFIS_Msk (0x2000000UL)           /*!< ETH MMC_RECEIVE_INTERRUPT: RXCTRLFIS (Bitfield-Mask: 0x01)  */

/* -------------------------  ETH_MMC_TRANSMIT_INTERRUPT  ------------------------- */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGBOCTIS_Pos (0UL)                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGBOCTIS (Bit 0)               */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGBOCTIS_Msk (0x1UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGBOCTIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGBFRMIS_Pos (1UL)                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGBFRMIS (Bit 1)               */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGBFRMIS_Msk (0x2UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGBFRMIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXBCGFIS_Pos (2UL)                   /*!< ETH MMC_TRANSMIT_INTERRUPT: TXBCGFIS (Bit 2)                */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXBCGFIS_Msk (0x4UL)                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TXBCGFIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCGFIS_Pos (3UL)                   /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCGFIS (Bit 3)                */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCGFIS_Msk (0x8UL)                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCGFIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX64OCTGBFIS_Pos (4UL)               /*!< ETH MMC_TRANSMIT_INTERRUPT: TX64OCTGBFIS (Bit 4)            */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX64OCTGBFIS_Msk (0x10UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT: TX64OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX65T127OCTGBFIS_Pos (5UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT: TX65T127OCTGBFIS (Bit 5)        */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX65T127OCTGBFIS_Msk (0x20UL)        /*!< ETH MMC_TRANSMIT_INTERRUPT: TX65T127OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX128T255OCTGBFIS_Pos (6UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT: TX128T255OCTGBFIS (Bit 6)       */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX128T255OCTGBFIS_Msk (0x40UL)       /*!< ETH MMC_TRANSMIT_INTERRUPT: TX128T255OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX256T511OCTGBFIS_Pos (7UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT: TX256T511OCTGBFIS (Bit 7)       */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX256T511OCTGBFIS_Msk (0x80UL)       /*!< ETH MMC_TRANSMIT_INTERRUPT: TX256T511OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX512T1023OCTGBFIS_Pos (8UL)         /*!< ETH MMC_TRANSMIT_INTERRUPT: TX512T1023OCTGBFIS (Bit 8)      */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX512T1023OCTGBFIS_Msk (0x100UL)     /*!< ETH MMC_TRANSMIT_INTERRUPT: TX512T1023OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX1024TMAXOCTGBFIS_Pos (9UL)         /*!< ETH MMC_TRANSMIT_INTERRUPT: TX1024TMAXOCTGBFIS (Bit 9)      */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX1024TMAXOCTGBFIS_Msk (0x200UL)     /*!< ETH MMC_TRANSMIT_INTERRUPT: TX1024TMAXOCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXUCGBFIS_Pos (10UL)                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TXUCGBFIS (Bit 10)              */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXUCGBFIS_Msk (0x400UL)              /*!< ETH MMC_TRANSMIT_INTERRUPT: TXUCGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCGBFIS_Pos (11UL)                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCGBFIS (Bit 11)              */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCGBFIS_Msk (0x800UL)              /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXBCGBFIS_Pos (12UL)                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TXBCGBFIS (Bit 12)              */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXBCGBFIS_Msk (0x1000UL)             /*!< ETH MMC_TRANSMIT_INTERRUPT: TXBCGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXUFLOWERFIS_Pos (13UL)              /*!< ETH MMC_TRANSMIT_INTERRUPT: TXUFLOWERFIS (Bit 13)           */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXUFLOWERFIS_Msk (0x2000UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT: TXUFLOWERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXSCOLGFIS_Pos (14UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXSCOLGFIS (Bit 14)             */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXSCOLGFIS_Msk (0x4000UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT: TXSCOLGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCOLGFIS_Pos (15UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCOLGFIS (Bit 15)             */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCOLGFIS_Msk (0x8000UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCOLGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXDEFFIS_Pos (16UL)                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXDEFFIS (Bit 16)               */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXDEFFIS_Msk (0x10000UL)             /*!< ETH MMC_TRANSMIT_INTERRUPT: TXDEFFIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXLATCOLFIS_Pos (17UL)               /*!< ETH MMC_TRANSMIT_INTERRUPT: TXLATCOLFIS (Bit 17)            */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXLATCOLFIS_Msk (0x20000UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT: TXLATCOLFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXEXCOLFIS_Pos (18UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXEXCOLFIS (Bit 18)             */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXEXCOLFIS_Msk (0x40000UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT: TXEXCOLFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXCARERFIS_Pos (19UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXCARERFIS (Bit 19)             */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXCARERFIS_Msk (0x80000UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT: TXCARERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGOCTIS_Pos (20UL)                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGOCTIS (Bit 20)               */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGOCTIS_Msk (0x100000UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGOCTIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGFRMIS_Pos (21UL)                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGFRMIS (Bit 21)               */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGFRMIS_Msk (0x200000UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGFRMIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXEXDEFFIS_Pos (22UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXEXDEFFIS (Bit 22)             */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXEXDEFFIS_Msk (0x400000UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT: TXEXDEFFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXPAUSFIS_Pos (23UL)                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TXPAUSFIS (Bit 23)              */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXPAUSFIS_Msk (0x800000UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT: TXPAUSFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXVLANGFIS_Pos (24UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXVLANGFIS (Bit 24)             */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXVLANGFIS_Msk (0x1000000UL)         /*!< ETH MMC_TRANSMIT_INTERRUPT: TXVLANGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXOSIZEGFIS_Pos (25UL)               /*!< ETH MMC_TRANSMIT_INTERRUPT: TXOSIZEGFIS (Bit 25)            */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXOSIZEGFIS_Msk (0x2000000UL)        /*!< ETH MMC_TRANSMIT_INTERRUPT: TXOSIZEGFIS (Bitfield-Mask: 0x01) */

/* -----------------------  ETH_MMC_RECEIVE_INTERRUPT_MASK  ----------------------- */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGBFRMIM_Pos (0UL)              /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGBFRMIM (Bit 0)           */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGBFRMIM_Msk (0x1UL)            /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGBFRMIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGBOCTIM_Pos (1UL)              /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGBOCTIM (Bit 1)           */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGBOCTIM_Msk (0x2UL)            /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGBOCTIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGOCTIM_Pos (2UL)               /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGOCTIM (Bit 2)            */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGOCTIM_Msk (0x4UL)             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGOCTIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXBCGFIM_Pos (3UL)               /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXBCGFIM (Bit 3)            */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXBCGFIM_Msk (0x8UL)             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXBCGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXMCGFIM_Pos (4UL)               /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXMCGFIM (Bit 4)            */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXMCGFIM_Msk (0x10UL)            /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXMCGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXCRCERFIM_Pos (5UL)             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXCRCERFIM (Bit 5)          */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXCRCERFIM_Msk (0x20UL)          /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXCRCERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXALGNERFIM_Pos (6UL)            /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXALGNERFIM (Bit 6)         */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXALGNERFIM_Msk (0x40UL)         /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXALGNERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXRUNTFIM_Pos (7UL)              /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXRUNTFIM (Bit 7)           */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXRUNTFIM_Msk (0x80UL)           /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXRUNTFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXJABERFIM_Pos (8UL)             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXJABERFIM (Bit 8)          */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXJABERFIM_Msk (0x100UL)         /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXJABERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXUSIZEGFIM_Pos (9UL)            /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXUSIZEGFIM (Bit 9)         */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXUSIZEGFIM_Msk (0x200UL)        /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXUSIZEGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXOSIZEGFIM_Pos (10UL)           /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXOSIZEGFIM (Bit 10)        */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXOSIZEGFIM_Msk (0x400UL)        /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXOSIZEGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX64OCTGBFIM_Pos (11UL)          /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX64OCTGBFIM (Bit 11)       */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX64OCTGBFIM_Msk (0x800UL)       /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX64OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX65T127OCTGBFIM_Pos (12UL)      /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX65T127OCTGBFIM (Bit 12)   */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX65T127OCTGBFIM_Msk (0x1000UL)  /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX65T127OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX128T255OCTGBFIM_Pos (13UL)     /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX128T255OCTGBFIM (Bit 13)  */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX128T255OCTGBFIM_Msk (0x2000UL) /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX128T255OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX256T511OCTGBFIM_Pos (14UL)     /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX256T511OCTGBFIM (Bit 14)  */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX256T511OCTGBFIM_Msk (0x4000UL) /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX256T511OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX512T1023OCTGBFIM_Pos (15UL)    /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX512T1023OCTGBFIM (Bit 15) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX512T1023OCTGBFIM_Msk (0x8000UL) /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX512T1023OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX1024TMAXOCTGBFIM_Pos (16UL)    /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX1024TMAXOCTGBFIM (Bit 16) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX1024TMAXOCTGBFIM_Msk (0x10000UL) /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX1024TMAXOCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXUCGFIM_Pos (17UL)              /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXUCGFIM (Bit 17)           */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXUCGFIM_Msk (0x20000UL)         /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXUCGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXLENERFIM_Pos (18UL)            /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXLENERFIM (Bit 18)         */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXLENERFIM_Msk (0x40000UL)       /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXLENERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXORANGEFIM_Pos (19UL)           /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXORANGEFIM (Bit 19)        */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXORANGEFIM_Msk (0x80000UL)      /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXORANGEFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXPAUSFIM_Pos (20UL)             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXPAUSFIM (Bit 20)          */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXPAUSFIM_Msk (0x100000UL)       /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXPAUSFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXFOVFIM_Pos (21UL)              /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXFOVFIM (Bit 21)           */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXFOVFIM_Msk (0x200000UL)        /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXFOVFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXVLANGBFIM_Pos (22UL)           /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXVLANGBFIM (Bit 22)        */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXVLANGBFIM_Msk (0x400000UL)     /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXVLANGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXWDOGFIM_Pos (23UL)             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXWDOGFIM (Bit 23)          */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXWDOGFIM_Msk (0x800000UL)       /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXWDOGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXRCVERRFIM_Pos (24UL)           /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXRCVERRFIM (Bit 24)        */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXRCVERRFIM_Msk (0x1000000UL)    /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXRCVERRFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXCTRLFIM_Pos (25UL)             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXCTRLFIM (Bit 25)          */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXCTRLFIM_Msk (0x2000000UL)      /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXCTRLFIM (Bitfield-Mask: 0x01) */

/* -----------------------  ETH_MMC_TRANSMIT_INTERRUPT_MASK  ---------------------- */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGBOCTIM_Pos (0UL)             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGBOCTIM (Bit 0)          */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGBOCTIM_Msk (0x1UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGBOCTIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGBFRMIM_Pos (1UL)             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGBFRMIM (Bit 1)          */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGBFRMIM_Msk (0x2UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGBFRMIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXBCGFIM_Pos (2UL)              /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXBCGFIM (Bit 2)           */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXBCGFIM_Msk (0x4UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXBCGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCGFIM_Pos (3UL)              /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCGFIM (Bit 3)           */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCGFIM_Msk (0x8UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX64OCTGBFIM_Pos (4UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX64OCTGBFIM (Bit 4)       */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX64OCTGBFIM_Msk (0x10UL)       /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX64OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX65T127OCTGBFIM_Pos (5UL)      /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX65T127OCTGBFIM (Bit 5)   */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX65T127OCTGBFIM_Msk (0x20UL)   /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX65T127OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX128T255OCTGBFIM_Pos (6UL)     /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX128T255OCTGBFIM (Bit 6)  */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX128T255OCTGBFIM_Msk (0x40UL)  /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX128T255OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX256T511OCTGBFIM_Pos (7UL)     /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX256T511OCTGBFIM (Bit 7)  */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX256T511OCTGBFIM_Msk (0x80UL)  /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX256T511OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX512T1023OCTGBFIM_Pos (8UL)    /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX512T1023OCTGBFIM (Bit 8) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX512T1023OCTGBFIM_Msk (0x100UL) /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX512T1023OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX1024TMAXOCTGBFIM_Pos (9UL)    /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX1024TMAXOCTGBFIM (Bit 9) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX1024TMAXOCTGBFIM_Msk (0x200UL) /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX1024TMAXOCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXUCGBFIM_Pos (10UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXUCGBFIM (Bit 10)         */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXUCGBFIM_Msk (0x400UL)         /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXUCGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCGBFIM_Pos (11UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCGBFIM (Bit 11)         */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCGBFIM_Msk (0x800UL)         /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXBCGBFIM_Pos (12UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXBCGBFIM (Bit 12)         */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXBCGBFIM_Msk (0x1000UL)        /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXBCGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXUFLOWERFIM_Pos (13UL)         /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXUFLOWERFIM (Bit 13)      */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXUFLOWERFIM_Msk (0x2000UL)     /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXUFLOWERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXSCOLGFIM_Pos (14UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXSCOLGFIM (Bit 14)        */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXSCOLGFIM_Msk (0x4000UL)       /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXSCOLGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCOLGFIM_Pos (15UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCOLGFIM (Bit 15)        */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCOLGFIM_Msk (0x8000UL)       /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCOLGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXDEFFIM_Pos (16UL)             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXDEFFIM (Bit 16)          */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXDEFFIM_Msk (0x10000UL)        /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXDEFFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXLATCOLFIM_Pos (17UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXLATCOLFIM (Bit 17)       */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXLATCOLFIM_Msk (0x20000UL)     /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXLATCOLFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXEXCOLFIM_Pos (18UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXEXCOLFIM (Bit 18)        */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXEXCOLFIM_Msk (0x40000UL)      /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXEXCOLFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXCARERFIM_Pos (19UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXCARERFIM (Bit 19)        */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXCARERFIM_Msk (0x80000UL)      /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXCARERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGOCTIM_Pos (20UL)             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGOCTIM (Bit 20)          */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGOCTIM_Msk (0x100000UL)       /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGOCTIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGFRMIM_Pos (21UL)             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGFRMIM (Bit 21)          */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGFRMIM_Msk (0x200000UL)       /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGFRMIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXEXDEFFIM_Pos (22UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXEXDEFFIM (Bit 22)        */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXEXDEFFIM_Msk (0x400000UL)     /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXEXDEFFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXPAUSFIM_Pos (23UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXPAUSFIM (Bit 23)         */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXPAUSFIM_Msk (0x800000UL)      /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXPAUSFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXVLANGFIM_Pos (24UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXVLANGFIM (Bit 24)        */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXVLANGFIM_Msk (0x1000000UL)    /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXVLANGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXOSIZEGFIM_Pos (25UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXOSIZEGFIM (Bit 25)       */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXOSIZEGFIM_Msk (0x2000000UL)   /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXOSIZEGFIM (Bitfield-Mask: 0x01) */

/* -------------------------  ETH_TX_OCTET_COUNT_GOOD_BAD  ------------------------ */
#define ETH_TX_OCTET_COUNT_GOOD_BAD_TXOCTGB_Pos (0UL)                   /*!< ETH TX_OCTET_COUNT_GOOD_BAD: TXOCTGB (Bit 0)                */
#define ETH_TX_OCTET_COUNT_GOOD_BAD_TXOCTGB_Msk (0xffffffffUL)          /*!< ETH TX_OCTET_COUNT_GOOD_BAD: TXOCTGB (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_TX_FRAME_COUNT_GOOD_BAD  ------------------------ */
#define ETH_TX_FRAME_COUNT_GOOD_BAD_TXFRMGB_Pos (0UL)                   /*!< ETH TX_FRAME_COUNT_GOOD_BAD: TXFRMGB (Bit 0)                */
#define ETH_TX_FRAME_COUNT_GOOD_BAD_TXFRMGB_Msk (0xffffffffUL)          /*!< ETH TX_FRAME_COUNT_GOOD_BAD: TXFRMGB (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_TX_BROADCAST_FRAMES_GOOD  ------------------------ */
#define ETH_TX_BROADCAST_FRAMES_GOOD_TXBCASTG_Pos (0UL)                 /*!< ETH TX_BROADCAST_FRAMES_GOOD: TXBCASTG (Bit 0)              */
#define ETH_TX_BROADCAST_FRAMES_GOOD_TXBCASTG_Msk (0xffffffffUL)        /*!< ETH TX_BROADCAST_FRAMES_GOOD: TXBCASTG (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_TX_MULTICAST_FRAMES_GOOD  ------------------------ */
#define ETH_TX_MULTICAST_FRAMES_GOOD_TXMCASTG_Pos (0UL)                 /*!< ETH TX_MULTICAST_FRAMES_GOOD: TXMCASTG (Bit 0)              */
#define ETH_TX_MULTICAST_FRAMES_GOOD_TXMCASTG_Msk (0xffffffffUL)        /*!< ETH TX_MULTICAST_FRAMES_GOOD: TXMCASTG (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_TX_64OCTETS_FRAMES_GOOD_BAD  ---------------------- */
#define ETH_TX_64OCTETS_FRAMES_GOOD_BAD_TX64OCTGB_Pos (0UL)             /*!< ETH TX_64OCTETS_FRAMES_GOOD_BAD: TX64OCTGB (Bit 0)          */
#define ETH_TX_64OCTETS_FRAMES_GOOD_BAD_TX64OCTGB_Msk (0xffffffffUL)    /*!< ETH TX_64OCTETS_FRAMES_GOOD_BAD: TX64OCTGB (Bitfield-Mask: 0xffffffff) */

/* --------------------  ETH_TX_65TO127OCTETS_FRAMES_GOOD_BAD  -------------------- */
#define ETH_TX_65TO127OCTETS_FRAMES_GOOD_BAD_TX65_127OCTGB_Pos (0UL)    /*!< ETH TX_65TO127OCTETS_FRAMES_GOOD_BAD: TX65_127OCTGB (Bit 0) */
#define ETH_TX_65TO127OCTETS_FRAMES_GOOD_BAD_TX65_127OCTGB_Msk (0xffffffffUL) /*!< ETH TX_65TO127OCTETS_FRAMES_GOOD_BAD: TX65_127OCTGB (Bitfield-Mask: 0xffffffff) */

/* --------------------  ETH_TX_128TO255OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_TX_128TO255OCTETS_FRAMES_GOOD_BAD_TX128_255OCTGB_Pos (0UL)  /*!< ETH TX_128TO255OCTETS_FRAMES_GOOD_BAD: TX128_255OCTGB (Bit 0) */
#define ETH_TX_128TO255OCTETS_FRAMES_GOOD_BAD_TX128_255OCTGB_Msk (0xffffffffUL) /*!< ETH TX_128TO255OCTETS_FRAMES_GOOD_BAD: TX128_255OCTGB (Bitfield-Mask: 0xffffffff) */

/* --------------------  ETH_TX_256TO511OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_TX_256TO511OCTETS_FRAMES_GOOD_BAD_TX256_511OCTGB_Pos (0UL)  /*!< ETH TX_256TO511OCTETS_FRAMES_GOOD_BAD: TX256_511OCTGB (Bit 0) */
#define ETH_TX_256TO511OCTETS_FRAMES_GOOD_BAD_TX256_511OCTGB_Msk (0xffffffffUL) /*!< ETH TX_256TO511OCTETS_FRAMES_GOOD_BAD: TX256_511OCTGB (Bitfield-Mask: 0xffffffff) */

/* -------------------  ETH_TX_512TO1023OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_TX_512TO1023OCTETS_FRAMES_GOOD_BAD_TX512_1023OCTGB_Pos (0UL) /*!< ETH TX_512TO1023OCTETS_FRAMES_GOOD_BAD: TX512_1023OCTGB (Bit 0) */
#define ETH_TX_512TO1023OCTETS_FRAMES_GOOD_BAD_TX512_1023OCTGB_Msk (0xffffffffUL) /*!< ETH TX_512TO1023OCTETS_FRAMES_GOOD_BAD: TX512_1023OCTGB (Bitfield-Mask: 0xffffffff) */

/* -------------------  ETH_TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD_TX1024_MAXOCTGB_Pos (0UL) /*!< ETH TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD: TX1024_MAXOCTGB (Bit 0) */
#define ETH_TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD_TX1024_MAXOCTGB_Msk (0xffffffffUL) /*!< ETH TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD: TX1024_MAXOCTGB (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_TX_UNICAST_FRAMES_GOOD_BAD  ----------------------- */
#define ETH_TX_UNICAST_FRAMES_GOOD_BAD_TXUCASTGB_Pos (0UL)              /*!< ETH TX_UNICAST_FRAMES_GOOD_BAD: TXUCASTGB (Bit 0)           */
#define ETH_TX_UNICAST_FRAMES_GOOD_BAD_TXUCASTGB_Msk (0xffffffffUL)     /*!< ETH TX_UNICAST_FRAMES_GOOD_BAD: TXUCASTGB (Bitfield-Mask: 0xffffffff) */

/* ----------------------  ETH_TX_MULTICAST_FRAMES_GOOD_BAD  ---------------------- */
#define ETH_TX_MULTICAST_FRAMES_GOOD_BAD_TXMCASTGB_Pos (0UL)            /*!< ETH TX_MULTICAST_FRAMES_GOOD_BAD: TXMCASTGB (Bit 0)         */
#define ETH_TX_MULTICAST_FRAMES_GOOD_BAD_TXMCASTGB_Msk (0xffffffffUL)   /*!< ETH TX_MULTICAST_FRAMES_GOOD_BAD: TXMCASTGB (Bitfield-Mask: 0xffffffff) */

/* ----------------------  ETH_TX_BROADCAST_FRAMES_GOOD_BAD  ---------------------- */
#define ETH_TX_BROADCAST_FRAMES_GOOD_BAD_TXBCASTGB_Pos (0UL)            /*!< ETH TX_BROADCAST_FRAMES_GOOD_BAD: TXBCASTGB (Bit 0)         */
#define ETH_TX_BROADCAST_FRAMES_GOOD_BAD_TXBCASTGB_Msk (0xffffffffUL)   /*!< ETH TX_BROADCAST_FRAMES_GOOD_BAD: TXBCASTGB (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_TX_UNDERFLOW_ERROR_FRAMES  ----------------------- */
#define ETH_TX_UNDERFLOW_ERROR_FRAMES_TXUNDRFLW_Pos (0UL)               /*!< ETH TX_UNDERFLOW_ERROR_FRAMES: TXUNDRFLW (Bit 0)            */
#define ETH_TX_UNDERFLOW_ERROR_FRAMES_TXUNDRFLW_Msk (0xffffffffUL)      /*!< ETH TX_UNDERFLOW_ERROR_FRAMES: TXUNDRFLW (Bitfield-Mask: 0xffffffff) */

/* ---------------------  ETH_TX_SINGLE_COLLISION_GOOD_FRAMES  -------------------- */
#define ETH_TX_SINGLE_COLLISION_GOOD_FRAMES_TXSNGLCOLG_Pos (0UL)        /*!< ETH TX_SINGLE_COLLISION_GOOD_FRAMES: TXSNGLCOLG (Bit 0)     */
#define ETH_TX_SINGLE_COLLISION_GOOD_FRAMES_TXSNGLCOLG_Msk (0xffffffffUL) /*!< ETH TX_SINGLE_COLLISION_GOOD_FRAMES: TXSNGLCOLG (Bitfield-Mask: 0xffffffff) */

/* --------------------  ETH_TX_MULTIPLE_COLLISION_GOOD_FRAMES  ------------------- */
#define ETH_TX_MULTIPLE_COLLISION_GOOD_FRAMES_TXMULTCOLG_Pos (0UL)      /*!< ETH TX_MULTIPLE_COLLISION_GOOD_FRAMES: TXMULTCOLG (Bit 0)   */
#define ETH_TX_MULTIPLE_COLLISION_GOOD_FRAMES_TXMULTCOLG_Msk (0xffffffffUL) /*!< ETH TX_MULTIPLE_COLLISION_GOOD_FRAMES: TXMULTCOLG (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_TX_DEFERRED_FRAMES  --------------------------- */
#define ETH_TX_DEFERRED_FRAMES_TXDEFRD_Pos    (0UL)                     /*!< ETH TX_DEFERRED_FRAMES: TXDEFRD (Bit 0)                     */
#define ETH_TX_DEFERRED_FRAMES_TXDEFRD_Msk    (0xffffffffUL)            /*!< ETH TX_DEFERRED_FRAMES: TXDEFRD (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_TX_LATE_COLLISION_FRAMES  ------------------------ */
#define ETH_TX_LATE_COLLISION_FRAMES_TXLATECOL_Pos (0UL)                /*!< ETH TX_LATE_COLLISION_FRAMES: TXLATECOL (Bit 0)             */
#define ETH_TX_LATE_COLLISION_FRAMES_TXLATECOL_Msk (0xffffffffUL)       /*!< ETH TX_LATE_COLLISION_FRAMES: TXLATECOL (Bitfield-Mask: 0xffffffff) */

/* ----------------------  ETH_TX_EXCESSIVE_COLLISION_FRAMES  --------------------- */
#define ETH_TX_EXCESSIVE_COLLISION_FRAMES_TXEXSCOL_Pos (0UL)            /*!< ETH TX_EXCESSIVE_COLLISION_FRAMES: TXEXSCOL (Bit 0)         */
#define ETH_TX_EXCESSIVE_COLLISION_FRAMES_TXEXSCOL_Msk (0xffffffffUL)   /*!< ETH TX_EXCESSIVE_COLLISION_FRAMES: TXEXSCOL (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_TX_CARRIER_ERROR_FRAMES  ------------------------ */
#define ETH_TX_CARRIER_ERROR_FRAMES_TXCARR_Pos (0UL)                    /*!< ETH TX_CARRIER_ERROR_FRAMES: TXCARR (Bit 0)                 */
#define ETH_TX_CARRIER_ERROR_FRAMES_TXCARR_Msk (0xffffffffUL)           /*!< ETH TX_CARRIER_ERROR_FRAMES: TXCARR (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_TX_OCTET_COUNT_GOOD  -------------------------- */
#define ETH_TX_OCTET_COUNT_GOOD_TXOCTG_Pos    (0UL)                     /*!< ETH TX_OCTET_COUNT_GOOD: TXOCTG (Bit 0)                     */
#define ETH_TX_OCTET_COUNT_GOOD_TXOCTG_Msk    (0xffffffffUL)            /*!< ETH TX_OCTET_COUNT_GOOD: TXOCTG (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_TX_FRAME_COUNT_GOOD  -------------------------- */
#define ETH_TX_FRAME_COUNT_GOOD_TXFRMG_Pos    (0UL)                     /*!< ETH TX_FRAME_COUNT_GOOD: TXFRMG (Bit 0)                     */
#define ETH_TX_FRAME_COUNT_GOOD_TXFRMG_Msk    (0xffffffffUL)            /*!< ETH TX_FRAME_COUNT_GOOD: TXFRMG (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_TX_EXCESSIVE_DEFERRAL_ERROR  ---------------------- */
#define ETH_TX_EXCESSIVE_DEFERRAL_ERROR_TXEXSDEF_Pos (0UL)              /*!< ETH TX_EXCESSIVE_DEFERRAL_ERROR: TXEXSDEF (Bit 0)           */
#define ETH_TX_EXCESSIVE_DEFERRAL_ERROR_TXEXSDEF_Msk (0xffffffffUL)     /*!< ETH TX_EXCESSIVE_DEFERRAL_ERROR: TXEXSDEF (Bitfield-Mask: 0xffffffff) */

/* -----------------------------  ETH_TX_PAUSE_FRAMES  ---------------------------- */
#define ETH_TX_PAUSE_FRAMES_TXPAUSE_Pos       (0UL)                     /*!< ETH TX_PAUSE_FRAMES: TXPAUSE (Bit 0)                        */
#define ETH_TX_PAUSE_FRAMES_TXPAUSE_Msk       (0xffffffffUL)            /*!< ETH TX_PAUSE_FRAMES: TXPAUSE (Bitfield-Mask: 0xffffffff)    */

/* ---------------------------  ETH_TX_VLAN_FRAMES_GOOD  -------------------------- */
#define ETH_TX_VLAN_FRAMES_GOOD_TXVLANG_Pos   (0UL)                     /*!< ETH TX_VLAN_FRAMES_GOOD: TXVLANG (Bit 0)                    */
#define ETH_TX_VLAN_FRAMES_GOOD_TXVLANG_Msk   (0xffffffffUL)            /*!< ETH TX_VLAN_FRAMES_GOOD: TXVLANG (Bitfield-Mask: 0xffffffff) */

/* --------------------------  ETH_TX_OSIZE_FRAMES_GOOD  -------------------------- */
#define ETH_TX_OSIZE_FRAMES_GOOD_TXOSIZG_Pos  (0UL)                     /*!< ETH TX_OSIZE_FRAMES_GOOD: TXOSIZG (Bit 0)                   */
#define ETH_TX_OSIZE_FRAMES_GOOD_TXOSIZG_Msk  (0xffffffffUL)            /*!< ETH TX_OSIZE_FRAMES_GOOD: TXOSIZG (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RX_FRAMES_COUNT_GOOD_BAD  ------------------------ */
#define ETH_RX_FRAMES_COUNT_GOOD_BAD_RXFRMGB_Pos (0UL)                  /*!< ETH RX_FRAMES_COUNT_GOOD_BAD: RXFRMGB (Bit 0)               */
#define ETH_RX_FRAMES_COUNT_GOOD_BAD_RXFRMGB_Msk (0xffffffffUL)         /*!< ETH RX_FRAMES_COUNT_GOOD_BAD: RXFRMGB (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_OCTET_COUNT_GOOD_BAD  ------------------------ */
#define ETH_RX_OCTET_COUNT_GOOD_BAD_RXOCTGB_Pos (0UL)                   /*!< ETH RX_OCTET_COUNT_GOOD_BAD: RXOCTGB (Bit 0)                */
#define ETH_RX_OCTET_COUNT_GOOD_BAD_RXOCTGB_Msk (0xffffffffUL)          /*!< ETH RX_OCTET_COUNT_GOOD_BAD: RXOCTGB (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RX_OCTET_COUNT_GOOD  -------------------------- */
#define ETH_RX_OCTET_COUNT_GOOD_RXOCTG_Pos    (0UL)                     /*!< ETH RX_OCTET_COUNT_GOOD: RXOCTG (Bit 0)                     */
#define ETH_RX_OCTET_COUNT_GOOD_RXOCTG_Msk    (0xffffffffUL)            /*!< ETH RX_OCTET_COUNT_GOOD: RXOCTG (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RX_BROADCAST_FRAMES_GOOD  ------------------------ */
#define ETH_RX_BROADCAST_FRAMES_GOOD_RXBCASTG_Pos (0UL)                 /*!< ETH RX_BROADCAST_FRAMES_GOOD: RXBCASTG (Bit 0)              */
#define ETH_RX_BROADCAST_FRAMES_GOOD_RXBCASTG_Msk (0xffffffffUL)        /*!< ETH RX_BROADCAST_FRAMES_GOOD: RXBCASTG (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RX_MULTICAST_FRAMES_GOOD  ------------------------ */
#define ETH_RX_MULTICAST_FRAMES_GOOD_RXMCASTG_Pos (0UL)                 /*!< ETH RX_MULTICAST_FRAMES_GOOD: RXMCASTG (Bit 0)              */
#define ETH_RX_MULTICAST_FRAMES_GOOD_RXMCASTG_Msk (0xffffffffUL)        /*!< ETH RX_MULTICAST_FRAMES_GOOD: RXMCASTG (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RX_CRC_ERROR_FRAMES  -------------------------- */
#define ETH_RX_CRC_ERROR_FRAMES_RXCRCERR_Pos  (0UL)                     /*!< ETH RX_CRC_ERROR_FRAMES: RXCRCERR (Bit 0)                   */
#define ETH_RX_CRC_ERROR_FRAMES_RXCRCERR_Msk  (0xffffffffUL)            /*!< ETH RX_CRC_ERROR_FRAMES: RXCRCERR (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RX_ALIGNMENT_ERROR_FRAMES  ----------------------- */
#define ETH_RX_ALIGNMENT_ERROR_FRAMES_RXALGNERR_Pos (0UL)               /*!< ETH RX_ALIGNMENT_ERROR_FRAMES: RXALGNERR (Bit 0)            */
#define ETH_RX_ALIGNMENT_ERROR_FRAMES_RXALGNERR_Msk (0xffffffffUL)      /*!< ETH RX_ALIGNMENT_ERROR_FRAMES: RXALGNERR (Bitfield-Mask: 0xffffffff) */

/* --------------------------  ETH_RX_RUNT_ERROR_FRAMES  -------------------------- */
#define ETH_RX_RUNT_ERROR_FRAMES_RXRUNTERR_Pos (0UL)                    /*!< ETH RX_RUNT_ERROR_FRAMES: RXRUNTERR (Bit 0)                 */
#define ETH_RX_RUNT_ERROR_FRAMES_RXRUNTERR_Msk (0xffffffffUL)           /*!< ETH RX_RUNT_ERROR_FRAMES: RXRUNTERR (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_JABBER_ERROR_FRAMES  ------------------------- */
#define ETH_RX_JABBER_ERROR_FRAMES_RXJABERR_Pos (0UL)                   /*!< ETH RX_JABBER_ERROR_FRAMES: RXJABERR (Bit 0)                */
#define ETH_RX_JABBER_ERROR_FRAMES_RXJABERR_Msk (0xffffffffUL)          /*!< ETH RX_JABBER_ERROR_FRAMES: RXJABERR (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RX_UNDERSIZE_FRAMES_GOOD  ------------------------ */
#define ETH_RX_UNDERSIZE_FRAMES_GOOD_RXUNDERSZG_Pos (0UL)               /*!< ETH RX_UNDERSIZE_FRAMES_GOOD: RXUNDERSZG (Bit 0)            */
#define ETH_RX_UNDERSIZE_FRAMES_GOOD_RXUNDERSZG_Msk (0xffffffffUL)      /*!< ETH RX_UNDERSIZE_FRAMES_GOOD: RXUNDERSZG (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_OVERSIZE_FRAMES_GOOD  ------------------------ */
#define ETH_RX_OVERSIZE_FRAMES_GOOD_RXOVERSZG_Pos (0UL)                 /*!< ETH RX_OVERSIZE_FRAMES_GOOD: RXOVERSZG (Bit 0)              */
#define ETH_RX_OVERSIZE_FRAMES_GOOD_RXOVERSZG_Msk (0xffffffffUL)        /*!< ETH RX_OVERSIZE_FRAMES_GOOD: RXOVERSZG (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_RX_64OCTETS_FRAMES_GOOD_BAD  ---------------------- */
#define ETH_RX_64OCTETS_FRAMES_GOOD_BAD_RX64OCTGB_Pos (0UL)             /*!< ETH RX_64OCTETS_FRAMES_GOOD_BAD: RX64OCTGB (Bit 0)          */
#define ETH_RX_64OCTETS_FRAMES_GOOD_BAD_RX64OCTGB_Msk (0xffffffffUL)    /*!< ETH RX_64OCTETS_FRAMES_GOOD_BAD: RX64OCTGB (Bitfield-Mask: 0xffffffff) */

/* --------------------  ETH_RX_65TO127OCTETS_FRAMES_GOOD_BAD  -------------------- */
#define ETH_RX_65TO127OCTETS_FRAMES_GOOD_BAD_RX65_127OCTGB_Pos (0UL)    /*!< ETH RX_65TO127OCTETS_FRAMES_GOOD_BAD: RX65_127OCTGB (Bit 0) */
#define ETH_RX_65TO127OCTETS_FRAMES_GOOD_BAD_RX65_127OCTGB_Msk (0xffffffffUL) /*!< ETH RX_65TO127OCTETS_FRAMES_GOOD_BAD: RX65_127OCTGB (Bitfield-Mask: 0xffffffff) */

/* --------------------  ETH_RX_128TO255OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_RX_128TO255OCTETS_FRAMES_GOOD_BAD_RX128_255OCTGB_Pos (0UL)  /*!< ETH RX_128TO255OCTETS_FRAMES_GOOD_BAD: RX128_255OCTGB (Bit 0) */
#define ETH_RX_128TO255OCTETS_FRAMES_GOOD_BAD_RX128_255OCTGB_Msk (0xffffffffUL) /*!< ETH RX_128TO255OCTETS_FRAMES_GOOD_BAD: RX128_255OCTGB (Bitfield-Mask: 0xffffffff) */

/* --------------------  ETH_RX_256TO511OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_RX_256TO511OCTETS_FRAMES_GOOD_BAD_RX256_511OCTGB_Pos (0UL)  /*!< ETH RX_256TO511OCTETS_FRAMES_GOOD_BAD: RX256_511OCTGB (Bit 0) */
#define ETH_RX_256TO511OCTETS_FRAMES_GOOD_BAD_RX256_511OCTGB_Msk (0xffffffffUL) /*!< ETH RX_256TO511OCTETS_FRAMES_GOOD_BAD: RX256_511OCTGB (Bitfield-Mask: 0xffffffff) */

/* -------------------  ETH_RX_512TO1023OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_RX_512TO1023OCTETS_FRAMES_GOOD_BAD_RX512_1023OCTGB_Pos (0UL) /*!< ETH RX_512TO1023OCTETS_FRAMES_GOOD_BAD: RX512_1023OCTGB (Bit 0) */
#define ETH_RX_512TO1023OCTETS_FRAMES_GOOD_BAD_RX512_1023OCTGB_Msk (0xffffffffUL) /*!< ETH RX_512TO1023OCTETS_FRAMES_GOOD_BAD: RX512_1023OCTGB (Bitfield-Mask: 0xffffffff) */

/* -------------------  ETH_RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD_RX1024_MAXOCTGB_Pos (0UL) /*!< ETH RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD: RX1024_MAXOCTGB (Bit 0) */
#define ETH_RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD_RX1024_MAXOCTGB_Msk (0xffffffffUL) /*!< ETH RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD: RX1024_MAXOCTGB (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_UNICAST_FRAMES_GOOD  ------------------------- */
#define ETH_RX_UNICAST_FRAMES_GOOD_RXUCASTG_Pos (0UL)                   /*!< ETH RX_UNICAST_FRAMES_GOOD: RXUCASTG (Bit 0)                */
#define ETH_RX_UNICAST_FRAMES_GOOD_RXUCASTG_Msk (0xffffffffUL)          /*!< ETH RX_UNICAST_FRAMES_GOOD: RXUCASTG (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_LENGTH_ERROR_FRAMES  ------------------------- */
#define ETH_RX_LENGTH_ERROR_FRAMES_RXLENERR_Pos (0UL)                   /*!< ETH RX_LENGTH_ERROR_FRAMES: RXLENERR (Bit 0)                */
#define ETH_RX_LENGTH_ERROR_FRAMES_RXLENERR_Msk (0xffffffffUL)          /*!< ETH RX_LENGTH_ERROR_FRAMES: RXLENERR (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_RX_OUT_OF_RANGE_TYPE_FRAMES  ---------------------- */
#define ETH_RX_OUT_OF_RANGE_TYPE_FRAMES_RXOUTOFRNG_Pos (0UL)            /*!< ETH RX_OUT_OF_RANGE_TYPE_FRAMES: RXOUTOFRNG (Bit 0)         */
#define ETH_RX_OUT_OF_RANGE_TYPE_FRAMES_RXOUTOFRNG_Msk (0xffffffffUL)   /*!< ETH RX_OUT_OF_RANGE_TYPE_FRAMES: RXOUTOFRNG (Bitfield-Mask: 0xffffffff) */

/* -----------------------------  ETH_RX_PAUSE_FRAMES  ---------------------------- */
#define ETH_RX_PAUSE_FRAMES_RXPAUSEFRM_Pos    (0UL)                     /*!< ETH RX_PAUSE_FRAMES: RXPAUSEFRM (Bit 0)                     */
#define ETH_RX_PAUSE_FRAMES_RXPAUSEFRM_Msk    (0xffffffffUL)            /*!< ETH RX_PAUSE_FRAMES: RXPAUSEFRM (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_FIFO_OVERFLOW_FRAMES  ------------------------ */
#define ETH_RX_FIFO_OVERFLOW_FRAMES_RXFIFOOVFL_Pos (0UL)                /*!< ETH RX_FIFO_OVERFLOW_FRAMES: RXFIFOOVFL (Bit 0)             */
#define ETH_RX_FIFO_OVERFLOW_FRAMES_RXFIFOOVFL_Msk (0xffffffffUL)       /*!< ETH RX_FIFO_OVERFLOW_FRAMES: RXFIFOOVFL (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_VLAN_FRAMES_GOOD_BAD  ------------------------ */
#define ETH_RX_VLAN_FRAMES_GOOD_BAD_RXVLANFRGB_Pos (0UL)                /*!< ETH RX_VLAN_FRAMES_GOOD_BAD: RXVLANFRGB (Bit 0)             */
#define ETH_RX_VLAN_FRAMES_GOOD_BAD_RXVLANFRGB_Msk (0xffffffffUL)       /*!< ETH RX_VLAN_FRAMES_GOOD_BAD: RXVLANFRGB (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RX_WATCHDOG_ERROR_FRAMES  ------------------------ */
#define ETH_RX_WATCHDOG_ERROR_FRAMES_RXWDGERR_Pos (0UL)                 /*!< ETH RX_WATCHDOG_ERROR_FRAMES: RXWDGERR (Bit 0)              */
#define ETH_RX_WATCHDOG_ERROR_FRAMES_RXWDGERR_Msk (0xffffffffUL)        /*!< ETH RX_WATCHDOG_ERROR_FRAMES: RXWDGERR (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_RECEIVE_ERROR_FRAMES  ------------------------ */
#define ETH_RX_RECEIVE_ERROR_FRAMES_RXRCVERR_Pos (0UL)                  /*!< ETH RX_RECEIVE_ERROR_FRAMES: RXRCVERR (Bit 0)               */
#define ETH_RX_RECEIVE_ERROR_FRAMES_RXRCVERR_Msk (0xffffffffUL)         /*!< ETH RX_RECEIVE_ERROR_FRAMES: RXRCVERR (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_CONTROL_FRAMES_GOOD  ------------------------- */
#define ETH_RX_CONTROL_FRAMES_GOOD_RXCTRLG_Pos (0UL)                    /*!< ETH RX_CONTROL_FRAMES_GOOD: RXCTRLG (Bit 0)                 */
#define ETH_RX_CONTROL_FRAMES_GOOD_RXCTRLG_Msk (0xffffffffUL)           /*!< ETH RX_CONTROL_FRAMES_GOOD: RXCTRLG (Bitfield-Mask: 0xffffffff) */

/* ---------------------  ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK  --------------------- */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4GFIM_Pos (0UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4GFIM (Bit 0)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4GFIM_Msk (0x1UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4GFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4HERFIM_Pos (1UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4HERFIM (Bit 1)    */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4HERFIM_Msk (0x2UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4HERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4NOPAYFIM_Pos (2UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4NOPAYFIM (Bit 2)  */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4NOPAYFIM_Msk (0x4UL)   /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4NOPAYFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4FRAGFIM_Pos (3UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4FRAGFIM (Bit 3)   */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4FRAGFIM_Msk (0x8UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4FRAGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4UDSBLFIM_Pos (4UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4UDSBLFIM (Bit 4)  */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4UDSBLFIM_Msk (0x10UL)  /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4UDSBLFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6GFIM_Pos (5UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6GFIM (Bit 5)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6GFIM_Msk (0x20UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6GFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6HERFIM_Pos (6UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6HERFIM (Bit 6)    */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6HERFIM_Msk (0x40UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6HERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6NOPAYFIM_Pos (7UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6NOPAYFIM (Bit 7)  */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6NOPAYFIM_Msk (0x80UL)  /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6NOPAYFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPGFIM_Pos (8UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPGFIM (Bit 8)       */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPGFIM_Msk (0x100UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPERFIM_Pos (9UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPERFIM (Bit 9)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPERFIM_Msk (0x200UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPGFIM_Pos (10UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPGFIM (Bit 10)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPGFIM_Msk (0x400UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPERFIM_Pos (11UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPERFIM (Bit 11)     */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPERFIM_Msk (0x800UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPGFIM_Pos (12UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPGFIM (Bit 12)     */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPGFIM_Msk (0x1000UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPERFIM_Pos (13UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPERFIM (Bit 13)    */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPERFIM_Msk (0x2000UL)   /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4GOIM_Pos (16UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4GOIM (Bit 16)     */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4GOIM_Msk (0x10000UL)   /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4GOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4HEROIM_Pos (17UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4HEROIM (Bit 17)   */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4HEROIM_Msk (0x20000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4HEROIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4NOPAYOIM_Pos (18UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4NOPAYOIM (Bit 18) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4NOPAYOIM_Msk (0x40000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4NOPAYOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4FRAGOIM_Pos (19UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4FRAGOIM (Bit 19)  */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4FRAGOIM_Msk (0x80000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4FRAGOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4UDSBLOIM_Pos (20UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4UDSBLOIM (Bit 20) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4UDSBLOIM_Msk (0x100000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4UDSBLOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6GOIM_Pos (21UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6GOIM (Bit 21)     */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6GOIM_Msk (0x200000UL)  /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6GOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6HEROIM_Pos (22UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6HEROIM (Bit 22)   */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6HEROIM_Msk (0x400000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6HEROIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6NOPAYOIM_Pos (23UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6NOPAYOIM (Bit 23) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6NOPAYOIM_Msk (0x800000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6NOPAYOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPGOIM_Pos (24UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPGOIM (Bit 24)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPGOIM_Msk (0x1000000UL)  /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPGOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPEROIM_Pos (25UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPEROIM (Bit 25)     */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPEROIM_Msk (0x2000000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPEROIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPGOIM_Pos (26UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPGOIM (Bit 26)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPGOIM_Msk (0x4000000UL)  /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPGOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPEROIM_Pos (27UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPEROIM (Bit 27)     */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPEROIM_Msk (0x8000000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPEROIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPGOIM_Pos (28UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPGOIM (Bit 28)     */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPGOIM_Msk (0x10000000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPGOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPEROIM_Pos (29UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPEROIM (Bit 29)    */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPEROIM_Msk (0x20000000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPEROIM (Bitfield-Mask: 0x01) */

/* ------------------------  ETH_MMC_IPC_RECEIVE_INTERRUPT  ----------------------- */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4GFIS_Pos (0UL)              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4GFIS (Bit 0)           */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4GFIS_Msk (0x1UL)            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4GFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4HERFIS_Pos (1UL)            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4HERFIS (Bit 1)         */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4HERFIS_Msk (0x2UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4HERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4NOPAYFIS_Pos (2UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4NOPAYFIS (Bit 2)       */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4NOPAYFIS_Msk (0x4UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4NOPAYFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4FRAGFIS_Pos (3UL)           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4FRAGFIS (Bit 3)        */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4FRAGFIS_Msk (0x8UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4FRAGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4UDSBLFIS_Pos (4UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4UDSBLFIS (Bit 4)       */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4UDSBLFIS_Msk (0x10UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4UDSBLFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6GFIS_Pos (5UL)              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6GFIS (Bit 5)           */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6GFIS_Msk (0x20UL)           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6GFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6HERFIS_Pos (6UL)            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6HERFIS (Bit 6)         */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6HERFIS_Msk (0x40UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6HERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6NOPAYFIS_Pos (7UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6NOPAYFIS (Bit 7)       */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6NOPAYFIS_Msk (0x80UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6NOPAYFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPGFIS_Pos (8UL)               /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPGFIS (Bit 8)            */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPGFIS_Msk (0x100UL)           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPERFIS_Pos (9UL)              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPERFIS (Bit 9)           */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPERFIS_Msk (0x200UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPGFIS_Pos (10UL)              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPGFIS (Bit 10)           */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPGFIS_Msk (0x400UL)           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPERFIS_Pos (11UL)             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPERFIS (Bit 11)          */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPERFIS_Msk (0x800UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPGFIS_Pos (12UL)             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPGFIS (Bit 12)          */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPGFIS_Msk (0x1000UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPERFIS_Pos (13UL)            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPERFIS (Bit 13)         */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPERFIS_Msk (0x2000UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4GOIS_Pos (16UL)             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4GOIS (Bit 16)          */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4GOIS_Msk (0x10000UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4GOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4HEROIS_Pos (17UL)           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4HEROIS (Bit 17)        */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4HEROIS_Msk (0x20000UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4HEROIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4NOPAYOIS_Pos (18UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4NOPAYOIS (Bit 18)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4NOPAYOIS_Msk (0x40000UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4NOPAYOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4FRAGOIS_Pos (19UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4FRAGOIS (Bit 19)       */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4FRAGOIS_Msk (0x80000UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4FRAGOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4UDSBLOIS_Pos (20UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4UDSBLOIS (Bit 20)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4UDSBLOIS_Msk (0x100000UL)   /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4UDSBLOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6GOIS_Pos (21UL)             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6GOIS (Bit 21)          */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6GOIS_Msk (0x200000UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6GOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6HEROIS_Pos (22UL)           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6HEROIS (Bit 22)        */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6HEROIS_Msk (0x400000UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6HEROIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6NOPAYOIS_Pos (23UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6NOPAYOIS (Bit 23)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6NOPAYOIS_Msk (0x800000UL)   /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6NOPAYOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPGOIS_Pos (24UL)              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPGOIS (Bit 24)           */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPGOIS_Msk (0x1000000UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPGOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPEROIS_Pos (25UL)             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPEROIS (Bit 25)          */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPEROIS_Msk (0x2000000UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPEROIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPGOIS_Pos (26UL)              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPGOIS (Bit 26)           */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPGOIS_Msk (0x4000000UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPGOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPEROIS_Pos (27UL)             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPEROIS (Bit 27)          */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPEROIS_Msk (0x8000000UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPEROIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPGOIS_Pos (28UL)             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPGOIS (Bit 28)          */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPGOIS_Msk (0x10000000UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPGOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPEROIS_Pos (29UL)            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPEROIS (Bit 29)         */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPEROIS_Msk (0x20000000UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPEROIS (Bitfield-Mask: 0x01) */

/* ---------------------------  ETH_RXIPV4_GOOD_FRAMES  --------------------------- */
#define ETH_RXIPV4_GOOD_FRAMES_RXIPV4GDFRM_Pos (0UL)                    /*!< ETH RXIPV4_GOOD_FRAMES: RXIPV4GDFRM (Bit 0)                 */
#define ETH_RXIPV4_GOOD_FRAMES_RXIPV4GDFRM_Msk (0xffffffffUL)           /*!< ETH RXIPV4_GOOD_FRAMES: RXIPV4GDFRM (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_RXIPV4_HEADER_ERROR_FRAMES  ----------------------- */
#define ETH_RXIPV4_HEADER_ERROR_FRAMES_RXIPV4HDRERRFRM_Pos (0UL)        /*!< ETH RXIPV4_HEADER_ERROR_FRAMES: RXIPV4HDRERRFRM (Bit 0)     */
#define ETH_RXIPV4_HEADER_ERROR_FRAMES_RXIPV4HDRERRFRM_Msk (0xffffffffUL) /*!< ETH RXIPV4_HEADER_ERROR_FRAMES: RXIPV4HDRERRFRM (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RXIPV4_NO_PAYLOAD_FRAMES  ------------------------ */
#define ETH_RXIPV4_NO_PAYLOAD_FRAMES_RXIPV4NOPAYFRM_Pos (0UL)           /*!< ETH RXIPV4_NO_PAYLOAD_FRAMES: RXIPV4NOPAYFRM (Bit 0)        */
#define ETH_RXIPV4_NO_PAYLOAD_FRAMES_RXIPV4NOPAYFRM_Msk (0xffffffffUL)  /*!< ETH RXIPV4_NO_PAYLOAD_FRAMES: RXIPV4NOPAYFRM (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RXIPV4_FRAGMENTED_FRAMES  ------------------------ */
#define ETH_RXIPV4_FRAGMENTED_FRAMES_RXIPV4FRAGFRM_Pos (0UL)            /*!< ETH RXIPV4_FRAGMENTED_FRAMES: RXIPV4FRAGFRM (Bit 0)         */
#define ETH_RXIPV4_FRAGMENTED_FRAMES_RXIPV4FRAGFRM_Msk (0xffffffffUL)   /*!< ETH RXIPV4_FRAGMENTED_FRAMES: RXIPV4FRAGFRM (Bitfield-Mask: 0xffffffff) */

/* -------------------  ETH_RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES  ------------------ */
#define ETH_RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES_RXIPV4UDSBLFRM_Pos (0UL) /*!< ETH RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES: RXIPV4UDSBLFRM (Bit 0) */
#define ETH_RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES_RXIPV4UDSBLFRM_Msk (0xffffffffUL) /*!< ETH RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES: RXIPV4UDSBLFRM (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXIPV6_GOOD_FRAMES  --------------------------- */
#define ETH_RXIPV6_GOOD_FRAMES_RXIPV6GDFRM_Pos (0UL)                    /*!< ETH RXIPV6_GOOD_FRAMES: RXIPV6GDFRM (Bit 0)                 */
#define ETH_RXIPV6_GOOD_FRAMES_RXIPV6GDFRM_Msk (0xffffffffUL)           /*!< ETH RXIPV6_GOOD_FRAMES: RXIPV6GDFRM (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_RXIPV6_HEADER_ERROR_FRAMES  ----------------------- */
#define ETH_RXIPV6_HEADER_ERROR_FRAMES_RXIPV6HDRERRFRM_Pos (0UL)        /*!< ETH RXIPV6_HEADER_ERROR_FRAMES: RXIPV6HDRERRFRM (Bit 0)     */
#define ETH_RXIPV6_HEADER_ERROR_FRAMES_RXIPV6HDRERRFRM_Msk (0xffffffffUL) /*!< ETH RXIPV6_HEADER_ERROR_FRAMES: RXIPV6HDRERRFRM (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RXIPV6_NO_PAYLOAD_FRAMES  ------------------------ */
#define ETH_RXIPV6_NO_PAYLOAD_FRAMES_RXIPV6NOPAYFRM_Pos (0UL)           /*!< ETH RXIPV6_NO_PAYLOAD_FRAMES: RXIPV6NOPAYFRM (Bit 0)        */
#define ETH_RXIPV6_NO_PAYLOAD_FRAMES_RXIPV6NOPAYFRM_Msk (0xffffffffUL)  /*!< ETH RXIPV6_NO_PAYLOAD_FRAMES: RXIPV6NOPAYFRM (Bitfield-Mask: 0xffffffff) */

/* ----------------------------  ETH_RXUDP_GOOD_FRAMES  --------------------------- */
#define ETH_RXUDP_GOOD_FRAMES_RXUDPGDFRM_Pos  (0UL)                     /*!< ETH RXUDP_GOOD_FRAMES: RXUDPGDFRM (Bit 0)                   */
#define ETH_RXUDP_GOOD_FRAMES_RXUDPGDFRM_Msk  (0xffffffffUL)            /*!< ETH RXUDP_GOOD_FRAMES: RXUDPGDFRM (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXUDP_ERROR_FRAMES  --------------------------- */
#define ETH_RXUDP_ERROR_FRAMES_RXUDPERRFRM_Pos (0UL)                    /*!< ETH RXUDP_ERROR_FRAMES: RXUDPERRFRM (Bit 0)                 */
#define ETH_RXUDP_ERROR_FRAMES_RXUDPERRFRM_Msk (0xffffffffUL)           /*!< ETH RXUDP_ERROR_FRAMES: RXUDPERRFRM (Bitfield-Mask: 0xffffffff) */

/* ----------------------------  ETH_RXTCP_GOOD_FRAMES  --------------------------- */
#define ETH_RXTCP_GOOD_FRAMES_RXTCPGDFRM_Pos  (0UL)                     /*!< ETH RXTCP_GOOD_FRAMES: RXTCPGDFRM (Bit 0)                   */
#define ETH_RXTCP_GOOD_FRAMES_RXTCPGDFRM_Msk  (0xffffffffUL)            /*!< ETH RXTCP_GOOD_FRAMES: RXTCPGDFRM (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXTCP_ERROR_FRAMES  --------------------------- */
#define ETH_RXTCP_ERROR_FRAMES_RXTCPERRFRM_Pos (0UL)                    /*!< ETH RXTCP_ERROR_FRAMES: RXTCPERRFRM (Bit 0)                 */
#define ETH_RXTCP_ERROR_FRAMES_RXTCPERRFRM_Msk (0xffffffffUL)           /*!< ETH RXTCP_ERROR_FRAMES: RXTCPERRFRM (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXICMP_GOOD_FRAMES  --------------------------- */
#define ETH_RXICMP_GOOD_FRAMES_RXICMPGDFRM_Pos (0UL)                    /*!< ETH RXICMP_GOOD_FRAMES: RXICMPGDFRM (Bit 0)                 */
#define ETH_RXICMP_GOOD_FRAMES_RXICMPGDFRM_Msk (0xffffffffUL)           /*!< ETH RXICMP_GOOD_FRAMES: RXICMPGDFRM (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXICMP_ERROR_FRAMES  -------------------------- */
#define ETH_RXICMP_ERROR_FRAMES_RXICMPERRFRM_Pos (0UL)                  /*!< ETH RXICMP_ERROR_FRAMES: RXICMPERRFRM (Bit 0)               */
#define ETH_RXICMP_ERROR_FRAMES_RXICMPERRFRM_Msk (0xffffffffUL)         /*!< ETH RXICMP_ERROR_FRAMES: RXICMPERRFRM (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXIPV4_GOOD_OCTETS  --------------------------- */
#define ETH_RXIPV4_GOOD_OCTETS_RXIPV4GDOCT_Pos (0UL)                    /*!< ETH RXIPV4_GOOD_OCTETS: RXIPV4GDOCT (Bit 0)                 */
#define ETH_RXIPV4_GOOD_OCTETS_RXIPV4GDOCT_Msk (0xffffffffUL)           /*!< ETH RXIPV4_GOOD_OCTETS: RXIPV4GDOCT (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_RXIPV4_HEADER_ERROR_OCTETS  ----------------------- */
#define ETH_RXIPV4_HEADER_ERROR_OCTETS_RXIPV4HDRERROCT_Pos (0UL)        /*!< ETH RXIPV4_HEADER_ERROR_OCTETS: RXIPV4HDRERROCT (Bit 0)     */
#define ETH_RXIPV4_HEADER_ERROR_OCTETS_RXIPV4HDRERROCT_Msk (0xffffffffUL) /*!< ETH RXIPV4_HEADER_ERROR_OCTETS: RXIPV4HDRERROCT (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RXIPV4_NO_PAYLOAD_OCTETS  ------------------------ */
#define ETH_RXIPV4_NO_PAYLOAD_OCTETS_RXIPV4NOPAYOCT_Pos (0UL)           /*!< ETH RXIPV4_NO_PAYLOAD_OCTETS: RXIPV4NOPAYOCT (Bit 0)        */
#define ETH_RXIPV4_NO_PAYLOAD_OCTETS_RXIPV4NOPAYOCT_Msk (0xffffffffUL)  /*!< ETH RXIPV4_NO_PAYLOAD_OCTETS: RXIPV4NOPAYOCT (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RXIPV4_FRAGMENTED_OCTETS  ------------------------ */
#define ETH_RXIPV4_FRAGMENTED_OCTETS_RXIPV4FRAGOCT_Pos (0UL)            /*!< ETH RXIPV4_FRAGMENTED_OCTETS: RXIPV4FRAGOCT (Bit 0)         */
#define ETH_RXIPV4_FRAGMENTED_OCTETS_RXIPV4FRAGOCT_Msk (0xffffffffUL)   /*!< ETH RXIPV4_FRAGMENTED_OCTETS: RXIPV4FRAGOCT (Bitfield-Mask: 0xffffffff) */

/* -------------------  ETH_RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS  ------------------- */
#define ETH_RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS_RXIPV4UDSBLOCT_Pos (0UL) /*!< ETH RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS: RXIPV4UDSBLOCT (Bit 0) */
#define ETH_RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS_RXIPV4UDSBLOCT_Msk (0xffffffffUL) /*!< ETH RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS: RXIPV4UDSBLOCT (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXIPV6_GOOD_OCTETS  --------------------------- */
#define ETH_RXIPV6_GOOD_OCTETS_RXIPV6GDOCT_Pos (0UL)                    /*!< ETH RXIPV6_GOOD_OCTETS: RXIPV6GDOCT (Bit 0)                 */
#define ETH_RXIPV6_GOOD_OCTETS_RXIPV6GDOCT_Msk (0xffffffffUL)           /*!< ETH RXIPV6_GOOD_OCTETS: RXIPV6GDOCT (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_RXIPV6_HEADER_ERROR_OCTETS  ----------------------- */
#define ETH_RXIPV6_HEADER_ERROR_OCTETS_RXIPV6HDRERROCT_Pos (0UL)        /*!< ETH RXIPV6_HEADER_ERROR_OCTETS: RXIPV6HDRERROCT (Bit 0)     */
#define ETH_RXIPV6_HEADER_ERROR_OCTETS_RXIPV6HDRERROCT_Msk (0xffffffffUL) /*!< ETH RXIPV6_HEADER_ERROR_OCTETS: RXIPV6HDRERROCT (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RXIPV6_NO_PAYLOAD_OCTETS  ------------------------ */
#define ETH_RXIPV6_NO_PAYLOAD_OCTETS_RXIPV6NOPAYOCT_Pos (0UL)           /*!< ETH RXIPV6_NO_PAYLOAD_OCTETS: RXIPV6NOPAYOCT (Bit 0)        */
#define ETH_RXIPV6_NO_PAYLOAD_OCTETS_RXIPV6NOPAYOCT_Msk (0xffffffffUL)  /*!< ETH RXIPV6_NO_PAYLOAD_OCTETS: RXIPV6NOPAYOCT (Bitfield-Mask: 0xffffffff) */

/* ----------------------------  ETH_RXUDP_GOOD_OCTETS  --------------------------- */
#define ETH_RXUDP_GOOD_OCTETS_RXUDPGDOCT_Pos  (0UL)                     /*!< ETH RXUDP_GOOD_OCTETS: RXUDPGDOCT (Bit 0)                   */
#define ETH_RXUDP_GOOD_OCTETS_RXUDPGDOCT_Msk  (0xffffffffUL)            /*!< ETH RXUDP_GOOD_OCTETS: RXUDPGDOCT (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXUDP_ERROR_OCTETS  --------------------------- */
#define ETH_RXUDP_ERROR_OCTETS_RXUDPERROCT_Pos (0UL)                    /*!< ETH RXUDP_ERROR_OCTETS: RXUDPERROCT (Bit 0)                 */
#define ETH_RXUDP_ERROR_OCTETS_RXUDPERROCT_Msk (0xffffffffUL)           /*!< ETH RXUDP_ERROR_OCTETS: RXUDPERROCT (Bitfield-Mask: 0xffffffff) */

/* ----------------------------  ETH_RXTCP_GOOD_OCTETS  --------------------------- */
#define ETH_RXTCP_GOOD_OCTETS_RXTCPGDOCT_Pos  (0UL)                     /*!< ETH RXTCP_GOOD_OCTETS: RXTCPGDOCT (Bit 0)                   */
#define ETH_RXTCP_GOOD_OCTETS_RXTCPGDOCT_Msk  (0xffffffffUL)            /*!< ETH RXTCP_GOOD_OCTETS: RXTCPGDOCT (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXTCP_ERROR_OCTETS  --------------------------- */
#define ETH_RXTCP_ERROR_OCTETS_RXTCPERROCT_Pos (0UL)                    /*!< ETH RXTCP_ERROR_OCTETS: RXTCPERROCT (Bit 0)                 */
#define ETH_RXTCP_ERROR_OCTETS_RXTCPERROCT_Msk (0xffffffffUL)           /*!< ETH RXTCP_ERROR_OCTETS: RXTCPERROCT (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXICMP_GOOD_OCTETS  --------------------------- */
#define ETH_RXICMP_GOOD_OCTETS_RXICMPGDOCT_Pos (0UL)                    /*!< ETH RXICMP_GOOD_OCTETS: RXICMPGDOCT (Bit 0)                 */
#define ETH_RXICMP_GOOD_OCTETS_RXICMPGDOCT_Msk (0xffffffffUL)           /*!< ETH RXICMP_GOOD_OCTETS: RXICMPGDOCT (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXICMP_ERROR_OCTETS  -------------------------- */
#define ETH_RXICMP_ERROR_OCTETS_RXICMPERROCT_Pos (0UL)                  /*!< ETH RXICMP_ERROR_OCTETS: RXICMPERROCT (Bit 0)               */
#define ETH_RXICMP_ERROR_OCTETS_RXICMPERROCT_Msk (0xffffffffUL)         /*!< ETH RXICMP_ERROR_OCTETS: RXICMPERROCT (Bitfield-Mask: 0xffffffff) */

/* ----------------------------  ETH_TIMESTAMP_CONTROL  --------------------------- */
#define ETH_TIMESTAMP_CONTROL_TSENA_Pos       (0UL)                     /*!< ETH TIMESTAMP_CONTROL: TSENA (Bit 0)                        */
#define ETH_TIMESTAMP_CONTROL_TSENA_Msk       (0x1UL)                   /*!< ETH TIMESTAMP_CONTROL: TSENA (Bitfield-Mask: 0x01)          */
#define ETH_TIMESTAMP_CONTROL_TSCFUPDT_Pos    (1UL)                     /*!< ETH TIMESTAMP_CONTROL: TSCFUPDT (Bit 1)                     */
#define ETH_TIMESTAMP_CONTROL_TSCFUPDT_Msk    (0x2UL)                   /*!< ETH TIMESTAMP_CONTROL: TSCFUPDT (Bitfield-Mask: 0x01)       */
#define ETH_TIMESTAMP_CONTROL_TSINIT_Pos      (2UL)                     /*!< ETH TIMESTAMP_CONTROL: TSINIT (Bit 2)                       */
#define ETH_TIMESTAMP_CONTROL_TSINIT_Msk      (0x4UL)                   /*!< ETH TIMESTAMP_CONTROL: TSINIT (Bitfield-Mask: 0x01)         */
#define ETH_TIMESTAMP_CONTROL_TSUPDT_Pos      (3UL)                     /*!< ETH TIMESTAMP_CONTROL: TSUPDT (Bit 3)                       */
#define ETH_TIMESTAMP_CONTROL_TSUPDT_Msk      (0x8UL)                   /*!< ETH TIMESTAMP_CONTROL: TSUPDT (Bitfield-Mask: 0x01)         */
#define ETH_TIMESTAMP_CONTROL_TSTRIG_Pos      (4UL)                     /*!< ETH TIMESTAMP_CONTROL: TSTRIG (Bit 4)                       */
#define ETH_TIMESTAMP_CONTROL_TSTRIG_Msk      (0x10UL)                  /*!< ETH TIMESTAMP_CONTROL: TSTRIG (Bitfield-Mask: 0x01)         */
#define ETH_TIMESTAMP_CONTROL_TSADDREG_Pos    (5UL)                     /*!< ETH TIMESTAMP_CONTROL: TSADDREG (Bit 5)                     */
#define ETH_TIMESTAMP_CONTROL_TSADDREG_Msk    (0x20UL)                  /*!< ETH TIMESTAMP_CONTROL: TSADDREG (Bitfield-Mask: 0x01)       */
#define ETH_TIMESTAMP_CONTROL_TSENALL_Pos     (8UL)                     /*!< ETH TIMESTAMP_CONTROL: TSENALL (Bit 8)                      */
#define ETH_TIMESTAMP_CONTROL_TSENALL_Msk     (0x100UL)                 /*!< ETH TIMESTAMP_CONTROL: TSENALL (Bitfield-Mask: 0x01)        */
#define ETH_TIMESTAMP_CONTROL_TSCTRLSSR_Pos   (9UL)                     /*!< ETH TIMESTAMP_CONTROL: TSCTRLSSR (Bit 9)                    */
#define ETH_TIMESTAMP_CONTROL_TSCTRLSSR_Msk   (0x200UL)                 /*!< ETH TIMESTAMP_CONTROL: TSCTRLSSR (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_CONTROL_TSVER2ENA_Pos   (10UL)                    /*!< ETH TIMESTAMP_CONTROL: TSVER2ENA (Bit 10)                   */
#define ETH_TIMESTAMP_CONTROL_TSVER2ENA_Msk   (0x400UL)                 /*!< ETH TIMESTAMP_CONTROL: TSVER2ENA (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_CONTROL_TSIPENA_Pos     (11UL)                    /*!< ETH TIMESTAMP_CONTROL: TSIPENA (Bit 11)                     */
#define ETH_TIMESTAMP_CONTROL_TSIPENA_Msk     (0x800UL)                 /*!< ETH TIMESTAMP_CONTROL: TSIPENA (Bitfield-Mask: 0x01)        */
#define ETH_TIMESTAMP_CONTROL_TSIPV6ENA_Pos   (12UL)                    /*!< ETH TIMESTAMP_CONTROL: TSIPV6ENA (Bit 12)                   */
#define ETH_TIMESTAMP_CONTROL_TSIPV6ENA_Msk   (0x1000UL)                /*!< ETH TIMESTAMP_CONTROL: TSIPV6ENA (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_CONTROL_TSIPV4ENA_Pos   (13UL)                    /*!< ETH TIMESTAMP_CONTROL: TSIPV4ENA (Bit 13)                   */
#define ETH_TIMESTAMP_CONTROL_TSIPV4ENA_Msk   (0x2000UL)                /*!< ETH TIMESTAMP_CONTROL: TSIPV4ENA (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_CONTROL_TSEVNTENA_Pos   (14UL)                    /*!< ETH TIMESTAMP_CONTROL: TSEVNTENA (Bit 14)                   */
#define ETH_TIMESTAMP_CONTROL_TSEVNTENA_Msk   (0x4000UL)                /*!< ETH TIMESTAMP_CONTROL: TSEVNTENA (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_CONTROL_TSMSTRENA_Pos   (15UL)                    /*!< ETH TIMESTAMP_CONTROL: TSMSTRENA (Bit 15)                   */
#define ETH_TIMESTAMP_CONTROL_TSMSTRENA_Msk   (0x8000UL)                /*!< ETH TIMESTAMP_CONTROL: TSMSTRENA (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_CONTROL_SNAPTYPSEL_Pos  (16UL)                    /*!< ETH TIMESTAMP_CONTROL: SNAPTYPSEL (Bit 16)                  */
#define ETH_TIMESTAMP_CONTROL_SNAPTYPSEL_Msk  (0x30000UL)               /*!< ETH TIMESTAMP_CONTROL: SNAPTYPSEL (Bitfield-Mask: 0x03)     */
#define ETH_TIMESTAMP_CONTROL_TSENMACADDR_Pos (18UL)                    /*!< ETH TIMESTAMP_CONTROL: TSENMACADDR (Bit 18)                 */
#define ETH_TIMESTAMP_CONTROL_TSENMACADDR_Msk (0x40000UL)               /*!< ETH TIMESTAMP_CONTROL: TSENMACADDR (Bitfield-Mask: 0x01)    */

/* --------------------------  ETH_SUB_SECOND_INCREMENT  -------------------------- */
#define ETH_SUB_SECOND_INCREMENT_SSINC_Pos    (0UL)                     /*!< ETH SUB_SECOND_INCREMENT: SSINC (Bit 0)                     */
#define ETH_SUB_SECOND_INCREMENT_SSINC_Msk    (0xffUL)                  /*!< ETH SUB_SECOND_INCREMENT: SSINC (Bitfield-Mask: 0xff)       */

/* ---------------------------  ETH_SYSTEM_TIME_SECONDS  -------------------------- */
#define ETH_SYSTEM_TIME_SECONDS_TSS_Pos       (0UL)                     /*!< ETH SYSTEM_TIME_SECONDS: TSS (Bit 0)                        */
#define ETH_SYSTEM_TIME_SECONDS_TSS_Msk       (0xffffffffUL)            /*!< ETH SYSTEM_TIME_SECONDS: TSS (Bitfield-Mask: 0xffffffff)    */

/* -------------------------  ETH_SYSTEM_TIME_NANOSECONDS  ------------------------ */
#define ETH_SYSTEM_TIME_NANOSECONDS_TSSS_Pos  (0UL)                     /*!< ETH SYSTEM_TIME_NANOSECONDS: TSSS (Bit 0)                   */
#define ETH_SYSTEM_TIME_NANOSECONDS_TSSS_Msk  (0x7fffffffUL)            /*!< ETH SYSTEM_TIME_NANOSECONDS: TSSS (Bitfield-Mask: 0x7fffffff) */

/* -----------------------  ETH_SYSTEM_TIME_SECONDS_UPDATE  ----------------------- */
#define ETH_SYSTEM_TIME_SECONDS_UPDATE_TSS_Pos (0UL)                    /*!< ETH SYSTEM_TIME_SECONDS_UPDATE: TSS (Bit 0)                 */
#define ETH_SYSTEM_TIME_SECONDS_UPDATE_TSS_Msk (0xffffffffUL)           /*!< ETH SYSTEM_TIME_SECONDS_UPDATE: TSS (Bitfield-Mask: 0xffffffff) */

/* ---------------------  ETH_SYSTEM_TIME_NANOSECONDS_UPDATE  --------------------- */
#define ETH_SYSTEM_TIME_NANOSECONDS_UPDATE_TSSS_Pos (0UL)               /*!< ETH SYSTEM_TIME_NANOSECONDS_UPDATE: TSSS (Bit 0)            */
#define ETH_SYSTEM_TIME_NANOSECONDS_UPDATE_TSSS_Msk (0x7fffffffUL)      /*!< ETH SYSTEM_TIME_NANOSECONDS_UPDATE: TSSS (Bitfield-Mask: 0x7fffffff) */
#define ETH_SYSTEM_TIME_NANOSECONDS_UPDATE_ADDSUB_Pos (31UL)            /*!< ETH SYSTEM_TIME_NANOSECONDS_UPDATE: ADDSUB (Bit 31)         */
#define ETH_SYSTEM_TIME_NANOSECONDS_UPDATE_ADDSUB_Msk (0x80000000UL)    /*!< ETH SYSTEM_TIME_NANOSECONDS_UPDATE: ADDSUB (Bitfield-Mask: 0x01) */

/* ----------------------------  ETH_TIMESTAMP_ADDEND  ---------------------------- */
#define ETH_TIMESTAMP_ADDEND_TSAR_Pos         (0UL)                     /*!< ETH TIMESTAMP_ADDEND: TSAR (Bit 0)                          */
#define ETH_TIMESTAMP_ADDEND_TSAR_Msk         (0xffffffffUL)            /*!< ETH TIMESTAMP_ADDEND: TSAR (Bitfield-Mask: 0xffffffff)      */

/* ---------------------------  ETH_TARGET_TIME_SECONDS  -------------------------- */
#define ETH_TARGET_TIME_SECONDS_TSTR_Pos      (0UL)                     /*!< ETH TARGET_TIME_SECONDS: TSTR (Bit 0)                       */
#define ETH_TARGET_TIME_SECONDS_TSTR_Msk      (0xffffffffUL)            /*!< ETH TARGET_TIME_SECONDS: TSTR (Bitfield-Mask: 0xffffffff)   */

/* -------------------------  ETH_TARGET_TIME_NANOSECONDS  ------------------------ */
#define ETH_TARGET_TIME_NANOSECONDS_TTSLO_Pos (0UL)                     /*!< ETH TARGET_TIME_NANOSECONDS: TTSLO (Bit 0)                  */
#define ETH_TARGET_TIME_NANOSECONDS_TTSLO_Msk (0x7fffffffUL)            /*!< ETH TARGET_TIME_NANOSECONDS: TTSLO (Bitfield-Mask: 0x7fffffff) */
#define ETH_TARGET_TIME_NANOSECONDS_TRGTBUSY_Pos (31UL)                 /*!< ETH TARGET_TIME_NANOSECONDS: TRGTBUSY (Bit 31)              */
#define ETH_TARGET_TIME_NANOSECONDS_TRGTBUSY_Msk (0x80000000UL)         /*!< ETH TARGET_TIME_NANOSECONDS: TRGTBUSY (Bitfield-Mask: 0x01) */

/* ---------------------  ETH_SYSTEM_TIME_HIGHER_WORD_SECONDS  -------------------- */
#define ETH_SYSTEM_TIME_HIGHER_WORD_SECONDS_TSHWR_Pos (0UL)             /*!< ETH SYSTEM_TIME_HIGHER_WORD_SECONDS: TSHWR (Bit 0)          */
#define ETH_SYSTEM_TIME_HIGHER_WORD_SECONDS_TSHWR_Msk (0xffffUL)        /*!< ETH SYSTEM_TIME_HIGHER_WORD_SECONDS: TSHWR (Bitfield-Mask: 0xffff) */

/* ----------------------------  ETH_TIMESTAMP_STATUS  ---------------------------- */
#define ETH_TIMESTAMP_STATUS_TSSOVF_Pos       (0UL)                     /*!< ETH TIMESTAMP_STATUS: TSSOVF (Bit 0)                        */
#define ETH_TIMESTAMP_STATUS_TSSOVF_Msk       (0x1UL)                   /*!< ETH TIMESTAMP_STATUS: TSSOVF (Bitfield-Mask: 0x01)          */
#define ETH_TIMESTAMP_STATUS_TSTARGT_Pos      (1UL)                     /*!< ETH TIMESTAMP_STATUS: TSTARGT (Bit 1)                       */
#define ETH_TIMESTAMP_STATUS_TSTARGT_Msk      (0x2UL)                   /*!< ETH TIMESTAMP_STATUS: TSTARGT (Bitfield-Mask: 0x01)         */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR_Pos    (3UL)                     /*!< ETH TIMESTAMP_STATUS: TSTRGTERR (Bit 3)                     */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR_Msk    (0x8UL)                   /*!< ETH TIMESTAMP_STATUS: TSTRGTERR (Bitfield-Mask: 0x01)       */
#define ETH_TIMESTAMP_STATUS_TSTARGT1_Pos     (4UL)                     /*!< ETH TIMESTAMP_STATUS: TSTARGT1 (Bit 4)                      */
#define ETH_TIMESTAMP_STATUS_TSTARGT1_Msk     (0x10UL)                  /*!< ETH TIMESTAMP_STATUS: TSTARGT1 (Bitfield-Mask: 0x01)        */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR1_Pos   (5UL)                     /*!< ETH TIMESTAMP_STATUS: TSTRGTERR1 (Bit 5)                    */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR1_Msk   (0x20UL)                  /*!< ETH TIMESTAMP_STATUS: TSTRGTERR1 (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_STATUS_TSTARGT2_Pos     (6UL)                     /*!< ETH TIMESTAMP_STATUS: TSTARGT2 (Bit 6)                      */
#define ETH_TIMESTAMP_STATUS_TSTARGT2_Msk     (0x40UL)                  /*!< ETH TIMESTAMP_STATUS: TSTARGT2 (Bitfield-Mask: 0x01)        */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR2_Pos   (7UL)                     /*!< ETH TIMESTAMP_STATUS: TSTRGTERR2 (Bit 7)                    */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR2_Msk   (0x80UL)                  /*!< ETH TIMESTAMP_STATUS: TSTRGTERR2 (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_STATUS_TSTARGT3_Pos     (8UL)                     /*!< ETH TIMESTAMP_STATUS: TSTARGT3 (Bit 8)                      */
#define ETH_TIMESTAMP_STATUS_TSTARGT3_Msk     (0x100UL)                 /*!< ETH TIMESTAMP_STATUS: TSTARGT3 (Bitfield-Mask: 0x01)        */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR3_Pos   (9UL)                     /*!< ETH TIMESTAMP_STATUS: TSTRGTERR3 (Bit 9)                    */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR3_Msk   (0x200UL)                 /*!< ETH TIMESTAMP_STATUS: TSTRGTERR3 (Bitfield-Mask: 0x01)      */

/* --------------------------------  ETH_BUS_MODE  -------------------------------- */
#define ETH_BUS_MODE_SWR_Pos                  (0UL)                     /*!< ETH BUS_MODE: SWR (Bit 0)                                   */
#define ETH_BUS_MODE_SWR_Msk                  (0x1UL)                   /*!< ETH BUS_MODE: SWR (Bitfield-Mask: 0x01)                     */
#define ETH_BUS_MODE_DA_Pos                   (1UL)                     /*!< ETH BUS_MODE: DA (Bit 1)                                    */
#define ETH_BUS_MODE_DA_Msk                   (0x2UL)                   /*!< ETH BUS_MODE: DA (Bitfield-Mask: 0x01)                      */
#define ETH_BUS_MODE_DSL_Pos                  (2UL)                     /*!< ETH BUS_MODE: DSL (Bit 2)                                   */
#define ETH_BUS_MODE_DSL_Msk                  (0x7cUL)                  /*!< ETH BUS_MODE: DSL (Bitfield-Mask: 0x1f)                     */
#define ETH_BUS_MODE_ATDS_Pos                 (7UL)                     /*!< ETH BUS_MODE: ATDS (Bit 7)                                  */
#define ETH_BUS_MODE_ATDS_Msk                 (0x80UL)                  /*!< ETH BUS_MODE: ATDS (Bitfield-Mask: 0x01)                    */
#define ETH_BUS_MODE_PBL_Pos                  (8UL)                     /*!< ETH BUS_MODE: PBL (Bit 8)                                   */
#define ETH_BUS_MODE_PBL_Msk                  (0x3f00UL)                /*!< ETH BUS_MODE: PBL (Bitfield-Mask: 0x3f)                     */
#define ETH_BUS_MODE_PR_Pos                   (14UL)                    /*!< ETH BUS_MODE: PR (Bit 14)                                   */
#define ETH_BUS_MODE_PR_Msk                   (0xc000UL)                /*!< ETH BUS_MODE: PR (Bitfield-Mask: 0x03)                      */
#define ETH_BUS_MODE_FB_Pos                   (16UL)                    /*!< ETH BUS_MODE: FB (Bit 16)                                   */
#define ETH_BUS_MODE_FB_Msk                   (0x10000UL)               /*!< ETH BUS_MODE: FB (Bitfield-Mask: 0x01)                      */
#define ETH_BUS_MODE_RPBL_Pos                 (17UL)                    /*!< ETH BUS_MODE: RPBL (Bit 17)                                 */
#define ETH_BUS_MODE_RPBL_Msk                 (0x7e0000UL)              /*!< ETH BUS_MODE: RPBL (Bitfield-Mask: 0x3f)                    */
#define ETH_BUS_MODE_USP_Pos                  (23UL)                    /*!< ETH BUS_MODE: USP (Bit 23)                                  */
#define ETH_BUS_MODE_USP_Msk                  (0x800000UL)              /*!< ETH BUS_MODE: USP (Bitfield-Mask: 0x01)                     */
#define ETH_BUS_MODE_PBLX8_Pos                (24UL)                    /*!< ETH BUS_MODE: PBLX8 (Bit 24)                                */
#define ETH_BUS_MODE_PBLX8_Msk                (0x1000000UL)             /*!< ETH BUS_MODE: PBLX8 (Bitfield-Mask: 0x01)                   */
#define ETH_BUS_MODE_AAL_Pos                  (25UL)                    /*!< ETH BUS_MODE: AAL (Bit 25)                                  */
#define ETH_BUS_MODE_AAL_Msk                  (0x2000000UL)             /*!< ETH BUS_MODE: AAL (Bitfield-Mask: 0x01)                     */
#define ETH_BUS_MODE_MB_Pos                   (26UL)                    /*!< ETH BUS_MODE: MB (Bit 26)                                   */
#define ETH_BUS_MODE_MB_Msk                   (0x4000000UL)             /*!< ETH BUS_MODE: MB (Bitfield-Mask: 0x01)                      */
#define ETH_BUS_MODE_TXPR_Pos                 (27UL)                    /*!< ETH BUS_MODE: TXPR (Bit 27)                                 */
#define ETH_BUS_MODE_TXPR_Msk                 (0x8000000UL)             /*!< ETH BUS_MODE: TXPR (Bitfield-Mask: 0x01)                    */
#define ETH_BUS_MODE_PRWG_Pos                 (28UL)                    /*!< ETH BUS_MODE: PRWG (Bit 28)                                 */
#define ETH_BUS_MODE_PRWG_Msk                 (0x30000000UL)            /*!< ETH BUS_MODE: PRWG (Bitfield-Mask: 0x03)                    */

/* --------------------------  ETH_TRANSMIT_POLL_DEMAND  -------------------------- */
#define ETH_TRANSMIT_POLL_DEMAND_TPD_Pos      (0UL)                     /*!< ETH TRANSMIT_POLL_DEMAND: TPD (Bit 0)                       */
#define ETH_TRANSMIT_POLL_DEMAND_TPD_Msk      (0xffffffffUL)            /*!< ETH TRANSMIT_POLL_DEMAND: TPD (Bitfield-Mask: 0xffffffff)   */

/* ---------------------------  ETH_RECEIVE_POLL_DEMAND  -------------------------- */
#define ETH_RECEIVE_POLL_DEMAND_RPD_Pos       (0UL)                     /*!< ETH RECEIVE_POLL_DEMAND: RPD (Bit 0)                        */
#define ETH_RECEIVE_POLL_DEMAND_RPD_Msk       (0xffffffffUL)            /*!< ETH RECEIVE_POLL_DEMAND: RPD (Bitfield-Mask: 0xffffffff)    */

/* ---------------------  ETH_RECEIVE_DESCRIPTOR_LIST_ADDRESS  -------------------- */
#define ETH_RECEIVE_DESCRIPTOR_LIST_ADDRESS_RDESLA_32bit_Pos (2UL)      /*!< ETH RECEIVE_DESCRIPTOR_LIST_ADDRESS: RDESLA_32bit (Bit 2)   */
#define ETH_RECEIVE_DESCRIPTOR_LIST_ADDRESS_RDESLA_32bit_Msk (0xfffffffcUL) /*!< ETH RECEIVE_DESCRIPTOR_LIST_ADDRESS: RDESLA_32bit (Bitfield-Mask: 0x3fffffff) */

/* --------------------  ETH_TRANSMIT_DESCRIPTOR_LIST_ADDRESS  -------------------- */
#define ETH_TRANSMIT_DESCRIPTOR_LIST_ADDRESS_TDESLA_32bit_Pos (2UL)     /*!< ETH TRANSMIT_DESCRIPTOR_LIST_ADDRESS: TDESLA_32bit (Bit 2)  */
#define ETH_TRANSMIT_DESCRIPTOR_LIST_ADDRESS_TDESLA_32bit_Msk (0xfffffffcUL) /*!< ETH TRANSMIT_DESCRIPTOR_LIST_ADDRESS: TDESLA_32bit (Bitfield-Mask: 0x3fffffff) */

/* ---------------------------------  ETH_STATUS  --------------------------------- */
#define ETH_STATUS_TI_Pos                     (0UL)                     /*!< ETH STATUS: TI (Bit 0)                                      */
#define ETH_STATUS_TI_Msk                     (0x1UL)                   /*!< ETH STATUS: TI (Bitfield-Mask: 0x01)                        */
#define ETH_STATUS_TPS_Pos                    (1UL)                     /*!< ETH STATUS: TPS (Bit 1)                                     */
#define ETH_STATUS_TPS_Msk                    (0x2UL)                   /*!< ETH STATUS: TPS (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_TU_Pos                     (2UL)                     /*!< ETH STATUS: TU (Bit 2)                                      */
#define ETH_STATUS_TU_Msk                     (0x4UL)                   /*!< ETH STATUS: TU (Bitfield-Mask: 0x01)                        */
#define ETH_STATUS_TJT_Pos                    (3UL)                     /*!< ETH STATUS: TJT (Bit 3)                                     */
#define ETH_STATUS_TJT_Msk                    (0x8UL)                   /*!< ETH STATUS: TJT (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_OVF_Pos                    (4UL)                     /*!< ETH STATUS: OVF (Bit 4)                                     */
#define ETH_STATUS_OVF_Msk                    (0x10UL)                  /*!< ETH STATUS: OVF (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_UNF_Pos                    (5UL)                     /*!< ETH STATUS: UNF (Bit 5)                                     */
#define ETH_STATUS_UNF_Msk                    (0x20UL)                  /*!< ETH STATUS: UNF (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_RI_Pos                     (6UL)                     /*!< ETH STATUS: RI (Bit 6)                                      */
#define ETH_STATUS_RI_Msk                     (0x40UL)                  /*!< ETH STATUS: RI (Bitfield-Mask: 0x01)                        */
#define ETH_STATUS_RU_Pos                     (7UL)                     /*!< ETH STATUS: RU (Bit 7)                                      */
#define ETH_STATUS_RU_Msk                     (0x80UL)                  /*!< ETH STATUS: RU (Bitfield-Mask: 0x01)                        */
#define ETH_STATUS_RPS_Pos                    (8UL)                     /*!< ETH STATUS: RPS (Bit 8)                                     */
#define ETH_STATUS_RPS_Msk                    (0x100UL)                 /*!< ETH STATUS: RPS (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_RWT_Pos                    (9UL)                     /*!< ETH STATUS: RWT (Bit 9)                                     */
#define ETH_STATUS_RWT_Msk                    (0x200UL)                 /*!< ETH STATUS: RWT (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_ETI_Pos                    (10UL)                    /*!< ETH STATUS: ETI (Bit 10)                                    */
#define ETH_STATUS_ETI_Msk                    (0x400UL)                 /*!< ETH STATUS: ETI (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_FBI_Pos                    (13UL)                    /*!< ETH STATUS: FBI (Bit 13)                                    */
#define ETH_STATUS_FBI_Msk                    (0x2000UL)                /*!< ETH STATUS: FBI (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_ERI_Pos                    (14UL)                    /*!< ETH STATUS: ERI (Bit 14)                                    */
#define ETH_STATUS_ERI_Msk                    (0x4000UL)                /*!< ETH STATUS: ERI (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_AIS_Pos                    (15UL)                    /*!< ETH STATUS: AIS (Bit 15)                                    */
#define ETH_STATUS_AIS_Msk                    (0x8000UL)                /*!< ETH STATUS: AIS (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_NIS_Pos                    (16UL)                    /*!< ETH STATUS: NIS (Bit 16)                                    */
#define ETH_STATUS_NIS_Msk                    (0x10000UL)               /*!< ETH STATUS: NIS (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_RS_Pos                     (17UL)                    /*!< ETH STATUS: RS (Bit 17)                                     */
#define ETH_STATUS_RS_Msk                     (0xe0000UL)               /*!< ETH STATUS: RS (Bitfield-Mask: 0x07)                        */
#define ETH_STATUS_TS_Pos                     (20UL)                    /*!< ETH STATUS: TS (Bit 20)                                     */
#define ETH_STATUS_TS_Msk                     (0x700000UL)              /*!< ETH STATUS: TS (Bitfield-Mask: 0x07)                        */
#define ETH_STATUS_EB_Pos                     (23UL)                    /*!< ETH STATUS: EB (Bit 23)                                     */
#define ETH_STATUS_EB_Msk                     (0x3800000UL)             /*!< ETH STATUS: EB (Bitfield-Mask: 0x07)                        */
#define ETH_STATUS_EMI_Pos                    (27UL)                    /*!< ETH STATUS: EMI (Bit 27)                                    */
#define ETH_STATUS_EMI_Msk                    (0x8000000UL)             /*!< ETH STATUS: EMI (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_EPI_Pos                    (28UL)                    /*!< ETH STATUS: EPI (Bit 28)                                    */
#define ETH_STATUS_EPI_Msk                    (0x10000000UL)            /*!< ETH STATUS: EPI (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_TTI_Pos                    (29UL)                    /*!< ETH STATUS: TTI (Bit 29)                                    */
#define ETH_STATUS_TTI_Msk                    (0x20000000UL)            /*!< ETH STATUS: TTI (Bitfield-Mask: 0x01)                       */

/* -----------------------------  ETH_OPERATION_MODE  ----------------------------- */
#define ETH_OPERATION_MODE_SR_Pos             (1UL)                     /*!< ETH OPERATION_MODE: SR (Bit 1)                              */
#define ETH_OPERATION_MODE_SR_Msk             (0x2UL)                   /*!< ETH OPERATION_MODE: SR (Bitfield-Mask: 0x01)                */
#define ETH_OPERATION_MODE_OSF_Pos            (2UL)                     /*!< ETH OPERATION_MODE: OSF (Bit 2)                             */
#define ETH_OPERATION_MODE_OSF_Msk            (0x4UL)                   /*!< ETH OPERATION_MODE: OSF (Bitfield-Mask: 0x01)               */
#define ETH_OPERATION_MODE_RTC_Pos            (3UL)                     /*!< ETH OPERATION_MODE: RTC (Bit 3)                             */
#define ETH_OPERATION_MODE_RTC_Msk            (0x18UL)                  /*!< ETH OPERATION_MODE: RTC (Bitfield-Mask: 0x03)               */
#define ETH_OPERATION_MODE_FUF_Pos            (6UL)                     /*!< ETH OPERATION_MODE: FUF (Bit 6)                             */
#define ETH_OPERATION_MODE_FUF_Msk            (0x40UL)                  /*!< ETH OPERATION_MODE: FUF (Bitfield-Mask: 0x01)               */
#define ETH_OPERATION_MODE_FEF_Pos            (7UL)                     /*!< ETH OPERATION_MODE: FEF (Bit 7)                             */
#define ETH_OPERATION_MODE_FEF_Msk            (0x80UL)                  /*!< ETH OPERATION_MODE: FEF (Bitfield-Mask: 0x01)               */
#define ETH_OPERATION_MODE_ST_Pos             (13UL)                    /*!< ETH OPERATION_MODE: ST (Bit 13)                             */
#define ETH_OPERATION_MODE_ST_Msk             (0x2000UL)                /*!< ETH OPERATION_MODE: ST (Bitfield-Mask: 0x01)                */
#define ETH_OPERATION_MODE_TTC_Pos            (14UL)                    /*!< ETH OPERATION_MODE: TTC (Bit 14)                            */
#define ETH_OPERATION_MODE_TTC_Msk            (0x1c000UL)               /*!< ETH OPERATION_MODE: TTC (Bitfield-Mask: 0x07)               */
#define ETH_OPERATION_MODE_FTF_Pos            (20UL)                    /*!< ETH OPERATION_MODE: FTF (Bit 20)                            */
#define ETH_OPERATION_MODE_FTF_Msk            (0x100000UL)              /*!< ETH OPERATION_MODE: FTF (Bitfield-Mask: 0x01)               */
#define ETH_OPERATION_MODE_TSF_Pos            (21UL)                    /*!< ETH OPERATION_MODE: TSF (Bit 21)                            */
#define ETH_OPERATION_MODE_TSF_Msk            (0x200000UL)              /*!< ETH OPERATION_MODE: TSF (Bitfield-Mask: 0x01)               */
#define ETH_OPERATION_MODE_DFF_Pos            (24UL)                    /*!< ETH OPERATION_MODE: DFF (Bit 24)                            */
#define ETH_OPERATION_MODE_DFF_Msk            (0x1000000UL)             /*!< ETH OPERATION_MODE: DFF (Bitfield-Mask: 0x01)               */
#define ETH_OPERATION_MODE_RSF_Pos            (25UL)                    /*!< ETH OPERATION_MODE: RSF (Bit 25)                            */
#define ETH_OPERATION_MODE_RSF_Msk            (0x2000000UL)             /*!< ETH OPERATION_MODE: RSF (Bitfield-Mask: 0x01)               */
#define ETH_OPERATION_MODE_DT_Pos             (26UL)                    /*!< ETH OPERATION_MODE: DT (Bit 26)                             */
#define ETH_OPERATION_MODE_DT_Msk             (0x4000000UL)             /*!< ETH OPERATION_MODE: DT (Bitfield-Mask: 0x01)                */

/* ----------------------------  ETH_INTERRUPT_ENABLE  ---------------------------- */
#define ETH_INTERRUPT_ENABLE_TIE_Pos          (0UL)                     /*!< ETH INTERRUPT_ENABLE: TIE (Bit 0)                           */
#define ETH_INTERRUPT_ENABLE_TIE_Msk          (0x1UL)                   /*!< ETH INTERRUPT_ENABLE: TIE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_TSE_Pos          (1UL)                     /*!< ETH INTERRUPT_ENABLE: TSE (Bit 1)                           */
#define ETH_INTERRUPT_ENABLE_TSE_Msk          (0x2UL)                   /*!< ETH INTERRUPT_ENABLE: TSE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_TUE_Pos          (2UL)                     /*!< ETH INTERRUPT_ENABLE: TUE (Bit 2)                           */
#define ETH_INTERRUPT_ENABLE_TUE_Msk          (0x4UL)                   /*!< ETH INTERRUPT_ENABLE: TUE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_TJE_Pos          (3UL)                     /*!< ETH INTERRUPT_ENABLE: TJE (Bit 3)                           */
#define ETH_INTERRUPT_ENABLE_TJE_Msk          (0x8UL)                   /*!< ETH INTERRUPT_ENABLE: TJE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_OVE_Pos          (4UL)                     /*!< ETH INTERRUPT_ENABLE: OVE (Bit 4)                           */
#define ETH_INTERRUPT_ENABLE_OVE_Msk          (0x10UL)                  /*!< ETH INTERRUPT_ENABLE: OVE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_UNE_Pos          (5UL)                     /*!< ETH INTERRUPT_ENABLE: UNE (Bit 5)                           */
#define ETH_INTERRUPT_ENABLE_UNE_Msk          (0x20UL)                  /*!< ETH INTERRUPT_ENABLE: UNE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_RIE_Pos          (6UL)                     /*!< ETH INTERRUPT_ENABLE: RIE (Bit 6)                           */
#define ETH_INTERRUPT_ENABLE_RIE_Msk          (0x40UL)                  /*!< ETH INTERRUPT_ENABLE: RIE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_RUE_Pos          (7UL)                     /*!< ETH INTERRUPT_ENABLE: RUE (Bit 7)                           */
#define ETH_INTERRUPT_ENABLE_RUE_Msk          (0x80UL)                  /*!< ETH INTERRUPT_ENABLE: RUE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_RSE_Pos          (8UL)                     /*!< ETH INTERRUPT_ENABLE: RSE (Bit 8)                           */
#define ETH_INTERRUPT_ENABLE_RSE_Msk          (0x100UL)                 /*!< ETH INTERRUPT_ENABLE: RSE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_RWE_Pos          (9UL)                     /*!< ETH INTERRUPT_ENABLE: RWE (Bit 9)                           */
#define ETH_INTERRUPT_ENABLE_RWE_Msk          (0x200UL)                 /*!< ETH INTERRUPT_ENABLE: RWE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_ETE_Pos          (10UL)                    /*!< ETH INTERRUPT_ENABLE: ETE (Bit 10)                          */
#define ETH_INTERRUPT_ENABLE_ETE_Msk          (0x400UL)                 /*!< ETH INTERRUPT_ENABLE: ETE (Bitfield-Mask: 0x01)             */
#