/**************************************************************************//**
 * @file     NUC472_442.h
 * @version  V1.00
 * $Revision: 173 $
 * $Date: 16/06/07 11:24a $
 * @brief    NUC472/NUC442 peripheral access layer header file.
 *           This file contains all the peripheral register's definitions,
 *           bits definitions and memory mapping for NuMicro NUC472/NUC442 MCU.
 * @note
 * Copyright (C) 2017 Nuvoton Technology Corp. All rights reserved.
 *****************************************************************************/
/**
   \mainpage NuMicro NUC472/NUC442 MCU Driver Reference Guide
   *
   * <b>Introduction</b>
   *
   * This user manual describes the usage of NUC472/NUC442 MCU device driver
   *
   * <b>Disclaimer</b>
   *
   * The Software is furnished "AS IS", without warranty as to performance or results, and
   * the entire risk as to performance or results is assumed by YOU. Nuvoton disclaims all
   * warranties, express, implied or otherwise, with regard to the Software, its use, or
   * operation, including without limitation any and all warranties of merchantability, fitness
   * for a particular purpose, and non-infringement of intellectual property rights.
   *
   * <b>Important Notice</b>
   *
   * Nuvoton Products are neither intended nor warranted for usage in systems or equipment,
   * any malfunction or failure of which may cause loss of human life, bodily injury or severe
   * property damage. Such applications are deemed, "Insecure Usage".
   *
   * Insecure usage includes, but is not limited to: equipment for surgical implementation,
   * atomic energy control instruments, airplane or spaceship instruments, the control or
   * operation of dynamic, brake or safety systems designed for vehicular use, traffic signal
   * instruments, all types of safety devices, and other applications intended to support or
   * sustain life.
   *
   * All Insecure Usage shall be made at customer's risk, and in the event that third parties
   * lay claims to Nuvoton as a result of customer's Insecure Usage, customer shall indemnify
   * the damages and liabilities thus incurred by Nuvoton.
   *
   * Please note that all data and specifications are subject to change without notice. All the
   * trademarks of products and companies mentioned in this document belong to their respective
   * owners.
   *
   * <b>Copyright Notice</b>
   *
   * Copyright (C) 2015~2017 Nuvoton Technology Corp. All rights reserved.
   */

#ifndef __NUC472_442_H__
#define __NUC472_442_H__

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************/
/*                Processor and Core Peripherals                              */
/******************************************************************************/
/** @addtogroup NUC472_442_CMSIS NUC472/NUC442 Device CMSIS Definitions
  Configuration of the Cortex-M4 Processor and Core Peripherals
  @{
*/

/**
 * @details  Interrupt Number Definition.
 */
typedef enum IRQn {
    /******  Cortex-M4 Processor Exceptions Numbers ***************************************************/
    NonMaskableInt_IRQn           = -14,      /*!<  2 Non Maskable Interrupt                        */
    MemoryManagement_IRQn         = -12,      /*!<  4 Memory Management Interrupt                   */
    BusFault_IRQn                 = -11,      /*!<  5 Bus Fault Interrupt                           */
    UsageFault_IRQn               = -10,      /*!<  6 Usage Fault Interrupt                         */
    SVCall_IRQn                   = -5,       /*!< 11 SV Call Interrupt                             */
    DebugMonitor_IRQn             = -4,       /*!< 12 Debug Monitor Interrupt                       */
    PendSV_IRQn                   = -2,       /*!< 14 Pend SV Interrupt                             */
    SysTick_IRQn                  = -1,       /*!< 15 System Tick Interrupt                         */

    /******  NUC472/NUC442 Specific Interrupt Numbers ********************************************************/

    BOD_IRQn                      = 0,        /*!< Brown Out detection Interrupt                    */
    IRC_IRQn                      = 1,        /*!< Internal RC Interrupt                            */
    PWRWU_IRQn                    = 2,        /*!< Power Down Wake Up Interrupt                     */
    SRAMF_IRQn                    = 3,        /*!< SRAM Parity Check Failed Interrupt               */
    CLKF_IRQn                     = 4,        /*!< Clock Detection Failed Interrupt                 */
    RTC_IRQn                      = 6,        /*!< Real Time Clock Interrupt                        */
    TAMPER_IRQn                   = 7,        /*!< Tamper detection Interrupt                       */
    EINT0_IRQn                    = 8,        /*!< External Input 0 Interrupt                       */
    EINT1_IRQn                    = 9,        /*!< External Input 1 Interrupt                       */
    EINT2_IRQn                    = 10,       /*!< External Input 2 Interrupt                       */
    EINT3_IRQn                    = 11,       /*!< External Input 3 Interrupt                       */
    EINT4_IRQn                    = 12,       /*!< External Input 4 Interrupt                       */
    EINT5_IRQn                    = 13,       /*!< External Input 5 Interrupt                       */
    EINT6_IRQn                    = 14,       /*!< External Input 6 Interrupt                       */
    EINT7_IRQn                    = 15,       /*!< External Input 7 Interrupt                       */
    GPA_IRQn                      = 16,       /*!< GPIO Port A Interrupt                            */
    GPB_IRQn                      = 17,       /*!< GPIO Port B Interrupt                            */
    GPC_IRQn                      = 18,       /*!< GPIO Port C Interrupt                            */
    GPD_IRQn                      = 19,       /*!< GPIO Port D Interrupt                            */
    GPE_IRQn                      = 20,       /*!< GPIO Port E Interrupt                            */
    GPF_IRQn                      = 21,       /*!< GPIO Port F Interrupt                            */
    GPG_IRQn                      = 22,       /*!< GPIO Port G Interrupt                            */
    GPH_IRQn                      = 23,       /*!< GPIO Port H Interrupt                            */
    GPI_IRQn                      = 24,       /*!< GPIO Port I Interrupt                            */
    TMR0_IRQn                     = 32,       /*!< Timer 0 Interrupt                                */
    TMR1_IRQn                     = 33,       /*!< Timer 1 Interrupt                                */
    TMR2_IRQn                     = 34,       /*!< Timer 2 Interrupt                                */
    TMR3_IRQn                     = 35,       /*!< Timer 3 Interrupt                                */
    PDMA_IRQn                     = 40,       /*!< Peripheral DMA Interrupt                         */
    ADC_IRQn                      = 42,       /*!< ADC Interrupt                                    */
    WDT_IRQn                      = 46,       /*!< Watch Dog Timer Interrupt                        */
    WWDT_IRQn                     = 47,       /*!< Window Watch Dog Timer Interrupt                 */
    EADC0_IRQn                    = 48,       /*!< Enhanced ADC 0 Interrupt                         */
    EADC1_IRQn                    = 49,       /*!< Enhanced ADC 1 Interrupt                         */
    EADC2_IRQn                    = 50,       /*!< Enhanced ADC 2 Interrupt                         */
    EADC3_IRQn                    = 51,       /*!< Enhanced ADC 3 Interrupt                         */
    ACMP_IRQn                     = 56,       /*!< Analog Comparator Interrupt                      */
    OPA0_IRQn                     = 60,       /*!< OPA 0 Interrupt                                  */
    OPA1_IRQn                     = 61,       /*!< OPA 1 Interrupt                                  */
    ICAP0_IRQn                    = 62,       /*!< Input Capture 0 Interrupt                        */
    ICAP1_IRQn                    = 63,       /*!< Input Capture 1 Interrupt                        */
    PWM0CH0_IRQn                  = 64,       /*!< PWM 0 Channel 0 Interrupt                        */
    PWM0CH1_IRQn                  = 65,       /*!< PWM 0 Channel 1 Interrupt                        */
    PWM0CH2_IRQn                  = 66,       /*!< PWM 0 Channel 2 Interrupt                        */
    PWM0CH3_IRQn                  = 67,       /*!< PWM 0 Channel 3 Interrupt                        */
    PWM0CH4_IRQn                  = 68,       /*!< PWM 0 Channel 4 Interrupt                        */
    PWM0CH5_IRQn                  = 69,       /*!< PWM 0 Channel 5 Interrupt                        */
    PWM0_BRK_IRQn                 = 70,       /*!< PWM 0 Brake Interrupt                            */
    QEI0_IRQn                     = 71,       /*!< QEI 0  Interrupt                                 */
    PWM1CH0_IRQn                  = 72,       /*!< PWM 1 Channel 0 Interrupt                        */
    PWM1CH1_IRQn                  = 73,       /*!< PWM 1 Channel 1 Interrupt                        */
    PWM1CH2_IRQn                  = 74,       /*!< PWM 1 Channel 2 Interrupt                        */
    PWM1CH3_IRQn                  = 75,       /*!< PWM 1 Channel 3 Interrupt                        */
    PWM1CH4_IRQn                  = 76,       /*!< PWM 1 Channel 4 Interrupt                        */
    PWM1CH5_IRQn                  = 77,       /*!< PWM 1 Channel 5 Interrupt                        */
    PWM1BRK_IRQn                 = 78,        /*!< PWM 1 Brake Interrupt                            */
    QEI1_IRQn                     = 79,       /*!< QEI 1  Interrupt                                 */
    EPWM0_IRQn                    = 80,       /*!< Enhanced PWM 0 Interrupt                         */
    EPWM0BRK_IRQn                 = 81,       /*!< Enhanced PWM 0 Brake Interrupt                   */
    EPWM1_IRQn                    = 82,       /*!< Enhanced PWM 1 Interrupt                         */
    EPWM1BRK_IRQn                 = 83,       /*!< Enhanced PWM 1 Brake Interrupt                   */
    USBD_IRQn                     = 88,       /*!< USB FS Device Interrupt                          */
    USBH_IRQn                     = 89,       /*!< USB FS Host Interrupt                            */
    USB_OTG_IRQn                  = 90,       /*!< USB OTG Interrupt                                */
    EMAC_TX_IRQn                  = 92,       /*!< Ethernet MAC TX Interrupt                        */
    EMAC_RX_IRQn                  = 93,       /*!< Ethernet MAC RX Interrupt                        */
    SPI0_IRQn                     = 96,       /*!< SPI 0 Interrupt                                  */
    SPI1_IRQn                     = 97,       /*!< SPI 1 Interrupt                                  */
    SPI2_IRQn                     = 98,       /*!< SPI 2 Interrupt                                  */
    SPI3_IRQn                     = 99,       /*!< SPI 3 Interrupt                                  */
    UART0_IRQn                    = 104,      /*!< UART 0 Interrupt                                 */
    UART1_IRQn                    = 105,      /*!< UART 1 Interrupt                                 */
    UART2_IRQn                    = 106,      /*!< UART 2 Interrupt                                 */
    UART3_IRQn                    = 107,      /*!< UART 3 Interrupt                                 */
    UART4_IRQn                    = 108,      /*!< UART 4 Interrupt                                 */
    UART5_IRQn                    = 109,      /*!< UART 5 Interrupt                                 */
    I2C0_IRQn                     = 112,      /*!< I2C 0 Interrupt                                  */
    I2C1_IRQn                     = 113,      /*!< I2C 1 Interrupt                                  */
    I2C2_IRQn                     = 114,      /*!< I2C 2 Interrupt                                  */
    I2C3_IRQn                     = 115,      /*!< I2C 3 Interrupt                                  */
    I2C4_IRQn                     = 116,      /*!< I2C 4 Interrupt                                  */
    SC0_IRQn                      = 120,      /*!< Smart Card 0 Interrupt                           */
    SC1_IRQn                      = 121,      /*!< Smart Card 1 Interrupt                           */
    SC2_IRQn                      = 122,      /*!< Smart Card 2 Interrupt                           */
    SC3_IRQn                      = 123,      /*!< Smart Card 3 Interrupt                           */
    SC4_IRQn                      = 124,      /*!< Smart Card 4 Interrupt                           */
    SC5_IRQn                      = 125,      /*!< Smart Card 5 Interrupt                           */
    CAN0_IRQn                     = 128,      /*!< CAN 0 Interrupt                                  */
    CAN1_IRQn                     = 129,      /*!< CAN 1 Interrupt                                  */
    I2S0_IRQn                     = 132,      /*!< I2S 0 Interrupt                                  */
    I2S1_IRQn                     = 133,      /*!< I2S 1 Interrupt                                  */
    SD_IRQn                       = 136,      /*!< SD Host Interrupt                                */
    PS2D_IRQn                     = 138,      /*!< PS/2 device Interrupt                            */
    CAP_IRQn                      = 139,      /*!< VCAP Interrupt                                   */
    CRPT_IRQn                     = 140,      /*!< Cryptographic Accelerator Interrupt                                 */
    CRC_IRQn                      = 141,      /*!< CRC Interrupt                                    */
}
IRQn_Type;


/*
 * ==========================================================================
 * ----------- Processor and Core Peripheral Section ------------------------
 * ==========================================================================
 */

/* Configuration of the Cortex-M# Processor and Core Peripherals */
#define __CM4_REV                 0x0201    /*!< Core Revision r2p1                               */
#define __NVIC_PRIO_BITS          4         /*!< Number of Bits used for Priority Levels          */
#define __Vendor_SysTickConfig    0         /*!< Set to 1 if different SysTick Config is used     */
#define __MPU_PRESENT             1         /*!< MPU present or not                               */
#define __FPU_PRESENT             1         /*!< FPU present or not                               */

/*@}*/ /* end of group NUC472_442_CMSIS */


#include "core_cm4.h"                       /* Cortex-M4 processor and core peripherals           */
#include "system_NUC472_442.h"            /* NUC472/NUC442 System include file                         */
#include <stdint.h>

/******************************************************************************/
/*                Device Specific Peripheral registers structures             */
/******************************************************************************/
/** @addtogroup NUC472_442_Peripherals NUC472/NUC442 Control Register
  NUC472/NUC442 Device Specific Peripheral registers structures
  @{
*/

#if defined ( __CC_ARM   )
#pragma anon_unions
#endif


/*---------------------- Analog Comparator Controller -------------------------*/
/**
    @addtogroup ACMP Analog Comparator Controller(ACMP)
    Memory Mapped Structure for ACMP Controller
@{ */

typedef struct {


    /**
     * CTL0, CTL1, CTL2
     * ===================================================================================================
     * Offset: 0x00~0x08 Analog Comparator 0/1/2 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |ACMPEN    |Comparator x Enable Control
     * |        |          |0 = Comparator x Disabled.
     * |        |          |1 = Comparator x Enabled.
     * |        |          |Note: The comparator output needs to wait 2 us stable time after ACMPEN is set.
     * |[1]     |ACMPIE    |Comparator x Interrupt Enable Control
     * |        |          |0 = Comparator x interrupt Disabled.
     * |        |          |1 = Comparator x interrupt Enabled.
     * |[2]     |HYSEN     |Comparator x Hysteresis Enable Control
     * |        |          |0 = Comparator x hysteresis Disabled (Default).
     * |        |          |1 = Comparator x hysteresis Enabled (typical range is 20 mV).
     * |[3]     |ACMPOINV  |Comparator x Output Inverse
     * |        |          |0 = Comparator x output inverse Disabled.
     * |        |          |1 = Comparator x output inverse Enabled.
     * |[4]     |NEGSEL    |Comparator x Negative Input Selection
     * |        |          |0 = The source of comparator x negative input is from ACMP0_N pin.
     * |        |          |1 = The internal comparator reference voltage (Band-gap voltage or CRV) is selected as the source of comparator x negative input.
     * |[5:7]   |POSSEL    |Comparator x Positive Input Selection
     * |        |          |000= Input from ACMPx_P0.
     * |        |          |001= Input from ACMPx_P1.
     * |        |          |010= Input from ACMPx_P2.
     * |        |          |011= Input from ACMPx_P3.
     * |        |          |100= Input from OPA0x. (Reserved for ACMP2)
     * |        |          |The other options are reserved.
    */
    __IO uint32_t CTL[3];

    /**
     * STATUS
     * ===================================================================================================
     * Offset: 0x0C  Analog Comparator Status Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |ACMPIF0   |Comparator 0 Flag
     * |        |          |This bit is set by hardware whenever the comparator 0 output changes state.
     * |        |          |This will cause an interrupt if ACMP_CTL0[1] is set to 1.
     * |        |          |Write 1 to clear this bit to 0.
     * |[1]     |ACMPIF1   |Comparator 1 Flag
     * |        |          |This bit is set by hardware whenever the comparator 1 output changes state.
     * |        |          |This will cause an interrupt if ACMP_CTL1[1] is set to 1.
     * |        |          |Write 1 to clear this bit to 0.
     * |[2]     |ACMPIF2   |Comparator 2 Flag
     * |        |          |This bit is set by hardware whenever the comparator 2 output changes state.
     * |        |          |This will cause an interrupt if ACMP_CTL2[1] is set to 1.
     * |        |          |Write 1 to clear this bit to 0.
     * |[3]     |ACMPO0    |Comparator 0 Output
     * |        |          |Synchronized to the APB clock to allow reading by software.
     * |        |          |Cleared when the comparator 0 is disabled (ACMP_CTL0[0] = 0).
     * |[4]     |ACMPO1    |Comparator 1 Output
     * |        |          |Synchronized to the APB clock to allow reading by software.
     * |        |          |Cleared when the comparator 1 is disabled (ACMP_CTL1[0] = 0).
     * |[5]     |ACMPO2    |Comparator 2 Output
     * |        |          |Synchronized to the APB clock to allow reading by software.
     * |        |          |Cleared when the comparator 2 is disabled (ACMP_CTL2[0] = 0).
    */
    __IO uint32_t STATUS;

    /**
     * VREF
     * ===================================================================================================
     * Offset: 0x10  Analog Comparator Reference Voltage Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CRVCTL    |Comparator Reference Voltage Setting
     * |        |          |CRV = CRV source voltage * (1/6+VREF[3:0]/24).
     * |[6]     |CRVSSEL   |CRV Source Voltage Selection
     * |        |          |0 = VDDA is selected as CRV source voltage.
     * |        |          |1 = Internal reference voltage is selected as CRV source voltage.
     * |[7]     |IREFSEL   |Internal Reference Selection
     * |        |          |0 = Band-gap voltage is selected as internal reference.
     * |        |          |1 = CRV is selected as internal reference.
    */
    __IO uint32_t VREF;

} ACMP_T;

/**
    @addtogroup ACMP_CONST ACMP Bit Field Definition
    Constant Definitions for ACMP Controller
@{ */

#define ACMP_CTL_ACMPEN_Pos              (0)                                               /*!< ACMP_T::CTL: ACMPEN Position              */
#define ACMP_CTL_ACMPEN_Msk              (0x1ul << ACMP_CTL_ACMPEN_Pos)                    /*!< ACMP_T::CTL: ACMPEN Mask                  */

#define ACMP_CTL_ACMPIE_Pos              (1)                                               /*!< ACMP_T::CTL: ACMPIE Position              */
#define ACMP_CTL_ACMPIE_Msk              (0x1ul << ACMP_CTL_ACMPIE_Pos)                    /*!< ACMP_T::CTL: ACMPIE Mask                  */

#define ACMP_CTL_HYSEN_Pos               (2)                                               /*!< ACMP_T::CTL: HYSEN Position               */
#define ACMP_CTL_HYSEN_Msk               (0x1ul << ACMP_CTL_HYSEN_Pos)                     /*!< ACMP_T::CTL: HYSEN Mask                   */

#define ACMP_CTL_ACMPOINV_Pos            (3)                                               /*!< ACMP_T::CTL: ACMPOINV Position            */
#define ACMP_CTL_ACMPOINV_Msk            (0x1ul << ACMP_CTL_ACMPOINV_Pos)                  /*!< ACMP_T::CTL: ACMPOINV Mask                */

#define ACMP_CTL_NEGSEL_Pos              (4)                                               /*!< ACMP_T::CTL: NEGSEL Position              */
#define ACMP_CTL_NEGSEL_Msk              (0x1ul << ACMP_CTL_NEGSEL_Pos)                    /*!< ACMP_T::CTL: NEGSEL Mask                  */

#define ACMP_CTL_POSSEL_Pos              (5)                                               /*!< ACMP_T::CTL: POSSEL Position              */
#define ACMP_CTL_POSSEL_Msk              (0x7ul << ACMP_CTL_POSSEL_Pos)                    /*!< ACMP_T::CTL: POSSEL Mask                  */

#define ACMP_STATUS_ACMPIF0_Pos          (0)                                               /*!< ACMP_T::STATUS: ACMPIF0 Position          */
#define ACMP_STATUS_ACMPIF0_Msk          (0x1ul << ACMP_STATUS_ACMPIF0_Pos)                /*!< ACMP_T::STATUS: ACMPIF0 Mask              */

#define ACMP_STATUS_ACMPIF1_Pos          (1)                                               /*!< ACMP_T::STATUS: ACMPIF1 Position          */
#define ACMP_STATUS_ACMPIF1_Msk          (0x1ul << ACMP_STATUS_ACMPIF1_Pos)                /*!< ACMP_T::STATUS: ACMPIF1 Mask              */

#define ACMP_STATUS_ACMPIF2_Pos          (2)                                               /*!< ACMP_T::STATUS: ACMPIF2 Position          */
#define ACMP_STATUS_ACMPIF2_Msk          (0x1ul << ACMP_STATUS_ACMPIF2_Pos)                /*!< ACMP_T::STATUS: ACMPIF2 Mask              */

#define ACMP_STATUS_ACMPO0_Pos           (3)                                               /*!< ACMP_T::STATUS: ACMPO0 Position           */
#define ACMP_STATUS_ACMPO0_Msk           (0x1ul << ACMP_STATUS_ACMPO0_Pos)                 /*!< ACMP_T::STATUS: ACMPO0 Mask               */

#define ACMP_STATUS_ACMPO1_Pos           (4)                                               /*!< ACMP_T::STATUS: ACMPO1 Position           */
#define ACMP_STATUS_ACMPO1_Msk           (0x1ul << ACMP_STATUS_ACMPO1_Pos)                 /*!< ACMP_T::STATUS: ACMPO1 Mask               */

#define ACMP_STATUS_ACMPO2_Pos           (5)                                               /*!< ACMP_T::STATUS: ACMPO2 Position           */
#define ACMP_STATUS_ACMPO2_Msk           (0x1ul << ACMP_STATUS_ACMPO2_Pos)                 /*!< ACMP_T::STATUS: ACMPO2 Mask               */

#define ACMP_VREF_CRVCTL_Pos             (0)                                               /*!< ACMP_T::VREF: CRVCTL Position             */
#define ACMP_VREF_CRVCTL_Msk             (0xful << ACMP_VREF_CRVCTL_Pos)                   /*!< ACMP_T::VREF: CRVCTL Mask                 */

#define ACMP_VREF_CRVSSEL_Pos            (6)                                               /*!< ACMP_T::VREF: CRVSSEL Position            */
#define ACMP_VREF_CRVSSEL_Msk            (0x1ul << ACMP_VREF_CRVSSEL_Pos)                  /*!< ACMP_T::VREF: CRVSSEL Mask                */

#define ACMP_VREF_IREFSEL_Pos            (7)                                               /*!< ACMP_T::VREF: IREFSEL Position            */
#define ACMP_VREF_IREFSEL_Msk            (0x1ul << ACMP_VREF_IREFSEL_Pos)                  /*!< ACMP_T::VREF: IREFSEL Mask                */

/**@}*/ /* ACMP_CONST */
/**@}*/ /* end of ACMP register group */


/*---------------------- Analog to Digital Converter -------------------------*/
/**
    @addtogroup ADC Analog to Digital Converter(ADC)
    Memory Mapped Structure for ADC Controller
@{ */

typedef struct {


    /**
     * DAT
     * ===================================================================================================
     * Offset: 0x00~0x34 ADC Data Register 0~13
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains conversion result of ADC.
     * |        |          |When DMOF (ADC_CTL[31]) bit is set to 0, 12-bit ADC conversion result with unsigned format will be filled in RESULT[11:0] and zero will be filled in RESULT[15:12].
     * |        |          |When DMOF (ADC_CTL[31]) bit set to 1, 12-bit ADC conversion result with 2'complement format will be filled in RESULT[11:0] and signed bits to will be filled in RESULT[15:12].
     * |[16]    |OV        |Overrun Flag (Read Only)
     * |        |          |0 = Data in RESULT (ADC_DATx[15:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (ADC_DATx[15:0]) is overwrite.
     * |        |          |If converted data in RESULT[15:0] has not been read before new conversion result is loaded to this register, OV is set to 1 and previous conversion result is gone.
     * |        |          |It is cleared by hardware after ADC_DAT register is read.
     * |[17]    |VALID     |Valid Flag (Read Only)
     * |        |          |0 = Data in RESULT (ADC_DATx[15:0]) bits is not valid.
     * |        |          |1 = Data in RESULT (ADC_DATx[15:0]) bits is valid.
     * |        |          |This bit is set to 1 when corresponding channel analog input conversion is completed and cleared by hardware after ADC_DAT register is read.
    */
    __I  uint32_t DAT[14];

    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE0[2];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * CTL
     * ===================================================================================================
     * Offset: 0x40  ADC Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |ADCEN     |ADC Enable Control
     * |        |          |0 = ADC analog circuit Disabled.
     * |        |          |1 = ADC analog circuit Enabled.
     * |        |          |Before disabling ADC clock, this bit should be cleared to 0 by software.
     * |[1]     |ADCIEN    |ADC Interrupt Enable Control
     * |        |          |0 = ADC interrupt function Disabled.
     * |        |          |1 = ADC interrupt function Enabled.
     * |        |          |A/D conversion end interrupt request is generated if ADCIEN (ADC_CTL[1]) bit is set to 1.
     * |[2:3]   |OPMODE    |ADC Operation Mode
     * |        |          |00 = Single conversion.
     * |        |          |01 = Reserved.
     * |        |          |10 = Single-cycle scan.
     * |        |          |11 = Continuous scan.
     * |        |          |When changing the operation mode, software should disable SWTRG (ADC_CTL[11]) bit firstly.
     * |[4:5]   |HWTRGSEL  |External Hardware Trigger Source
     * |        |          |00 = A/D conversion is started by external pin (STADC).
     * |        |          |01 = Reserved.
     * |        |          |10 = Reserved.
     * |        |          |11 = PWM0 or PWM1 trigger condition is matched.
     * |        |          |Software should disable HWTRGCOND (ADC_CTL[8]) and SWTRG (ADC_CTL[11]) before changing HWTRGSEL (ADC_CTL[5:4]).
     * |        |          |In hardware trigger mode, the SWTRG (ADC_CTL[11]) bit is set by hardware trigger source.
     * |[6:7]   |HWTRGCOND |External Pin Trigger Conditions
     * |        |          |These two bits decide external pin (STADC) trigger event.
     * |        |          |The signal must be kept at stable state at least 8 system clocks for level trigger and 4 system clocks at high and low state for edge trigger.
     * |        |          |00 = Low level.
     * |        |          |01 = High level.
     * |        |          |10 = Falling edge.
     * |        |          |11 = Rising edge.
     * |[8]     |HWTRGEN   |External Hardware Trigger Enable Control
     * |        |          |Enable or disable hardware triggering of A/D conversion.
     * |        |          |The hardware trigger source include external pin (STADC) or PWM trigger which is controlled by HWTRGSEL (ADC_CTL[5:4]) register.
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |        |          |ADC hardware trigger function is only supported in single-cycle scan mode.
     * |[9]     |PDMAEN    |PDMA Transfer Enable Control
     * |        |          |0 = PDMA data transfer Disabled.
     * |        |          |1 = PDMA data transfer in ADC_DATx Enabled.
     * |        |          |When A/D conversion is completed, the converted data is loaded into ADC_DATx, software can enable this bit to generate a PDMA data transfer request.
     * |        |          |When PDMAEN (ADC_CTL[9]) is set to 1, software must set ADCIEN (ADC_CTL[1]) bit to 0 to disable interrupt.
     * |[10]    |DIFFEN    |Differential Input Mode Enable Control
     * |        |          |0 = Single-end analog input mode.
     * |        |          |1 = Differential analog input mode.
     * |        |          |The A/D analog input ADC0_CH0/ADC0_CH1 consists of a differential pair.
     * |        |          |So as ADC0_CH2/ADC0_CH3, ADC0_CH4/ADC0_CH5, ADC0_CH6/ADC0_CH7, ADC0_CH8/ADC0_CH9 and ADC0_CH10/ADC0_CH11.
     * |        |          |The even channel defines as plus analog input voltage (Vplus) and the odd channel defines as minus analog input voltage (Vminus).
     * |        |          |Differential input voltage (Vdiff) = Vplus - Vminus, where Vplus
     * |        |          |is the analog input; Vminus is the inverted analog input.
     * |        |          |In differential input mode, only the even number of the two corresponding channels needs to be enabled in ADCHER (ADC_CHEN[11:0]).
     * |        |          |The conversion result will be placed to the corresponding data register of the enabled channel.
     * |[11]    |SWTRG     |A/D Conversion Start
     * |        |          |0 = Conversion stopped and A/D converter enter idle state.
     * |        |          |1 = Conversion start.
     * |        |          |The SWTRG (ADC_CTL[11]) bit can be set to 1 from two sources: software and hardware trigger.
     * |        |          |The SWTRG (ADC_CTL[11]) bit will be cleared to 0 by hardware automatically at the ends of single mode and single-cycle scan mode.
     * |        |          |In continuous scan mode, A/D conversion is continuously performed until software write 0 to this bit or chip reset.
     * |[16:23] |PWMTRGDLY |PWM Trigger Delay Time
     * |        |          |Setting this field will delay ADC start conversion time after PWM trigger comes.
     * |        |          |PWM trigger delay time is 4 * system clock * PWMTRGDLY (ADC_CTL[23:16])
     * |[31]    |DMOF      |ADC Differential Input Mode Output Format
     * |        |          |0 = A/D conversion result will be filled in RESULT (ADC_DATx[15:0]) registers with unsigned format.
     * |        |          |1 = A/D conversion result will be filled in RESULT (ADC_DATx[15:0]) registers with 2'complement format.
    */
    __IO uint32_t CTL;

    /**
     * CHEN
     * ===================================================================================================
     * Offset: 0x44  ADC Channel Enable Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |CHEN      |Analog Input Channel Enable Control
     * |        |          |Set CHEN (ADC_CHEN[11:0]) to enable the corresponding analog input channel (ADC0_CH1 ~ ADC0_CH11).
     * |        |          |If DIFFEN bit is set to 1, only the even number channels need to be enabled.
     * |        |          |0 = ADC input channel Disabled.
     * |        |          |1 = ADC input channel Enabled.
     * |[16]    |ADTSEN    |Internal Temperature Sensor Selection
     * |        |          |0 = Internal temperature sensor is not selected to be the analog input source of ADC.
     * |        |          |1 = Internal temperature sensor is selected to be the analog input source of ADC.
     * |        |          |ADC can only work at Single mode when software selects the temperature sensor voltage as the analog input source of ADC
     * |[17]    |ADBGEN    |Internal Band-Gap Selection
     * |        |          |0 = Internal band-gap is not selected to be the analog input source of ADC.
     * |        |          |1 = Internal band-gap is selected to be the analog input source of ADC.
     * |        |          |ADC can only work at Single mode when software selects the band-gap voltage as the analog input source of ADC
    */
    __IO uint32_t CHEN;

    /**
     * CMP
     * ===================================================================================================
     * Offset: 0x48  ADC Compare Register 0/1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |ADCMPEN   |Compare Enable Control
     * |        |          |0 = Compare function Disabled.
     * |        |          |1 = Compare function Enabled.
     * |        |          |Set this bit to 1 to enable ADC controller to compare CMPDAT (ADC_CMPx[27:16]) with the conversion result of the channel specified by CMPCH (ADC_CMPx[6:3]) when the conversion data of the specified channel is loaded into ADC_DATx register.
     * |[1]     |ADCMPIE   |Compare Interrupt Enable Control
     * |        |          |0 = Compare function interrupt Disabled.
     * |        |          |1 = Compare function interrupt Enabled.
     * |        |          |If the compare function is enabled and the compare condition matches the setting of CMPCOND (ADC_CMPx[2]) and CMPMCNT(ADC_CMPx[11:8]), ADCMPFx (ADC_STATUS0[2:1]) bit will be asserted, in the meanwhile, if ADCMPIE (ADC_CMPx[1])is set to 1, a compare interrupt request is generated.
     * |[2]     |CMPCOND   |Compare Condition
     * |        |          |0 = Set the compare condition as that when a 12-bit A/D conversion result is less than the 12-bit CMPDAT (ADC_CMPx[27:16]), the internal match counter will increase one.
     * |        |          |1 = Set the compare condition as that when a 12-bit A/D conversion result is greater or equal to the 12-bit CMPDAT (ADC_CMPx[27:16]), the internal match counter will increase one.
     * |        |          |Note: When the internal counter reaches the value to CMPMCNT (ADC_CMPx[11:8]) + 1, the ADCMPFx (ADC_STATUS0[2:1]) bit will be set.
     * |[3:6]   |CMPCH     |Compare Channel Selection
     * |        |          |0000 = Channel 0 conversion result is selected to be compared.
     * |        |          |0001 = Channel 1 conversion result is selected to be compared.
     * |        |          |0010 = Channel 2 conversion result is selected to be compared.
     * |        |          |0011 = Channel 3 conversion result is selected to be compared.
     * |        |          |0100 = Channel 4 conversion result is selected to be compared.
     * |        |          |0101 = Channel 5 conversion result is selected to be compared.
     * |        |          |0110 = Channel 6 conversion result is selected to be compared.
     * |        |          |0111 = Channel 7 conversion result is selected to be compared.
     * |        |          |1000 = Channel 8 conversion result is selected to be compared.
     * |        |          |1001 = Channel 9 conversion result is selected to be compared.
     * |        |          |1010 = Channel 10 conversion result is selected to be compared.
     * |        |          |1011 = Channel 11 conversion result is selected to be compared.
     * |        |          |1100 = band-gap voltage result is selected to be compared.
     * |        |          |1101 = temperature sensor conversion result is selected to be compared.
     * |        |          |Others = reserved.
     * |[8:11]  |CMPMCNT   |Compare Match Count
     * |        |          |When the specified ADC channel analog conversion result matches the compare condition defined by CMPCOND (ADC_CMPx[2]), the internal match counter will increase 1.
     * |        |          |When the internal counter reaches the value to CMPMCNT (ADC_CMPx[11:8]) + 1, the ADCMPFx (ADC_STATUS0[2:1]) bit will be set.
     * |[16:27] |CMPDAT    |Compared Data
     * |        |          |When DMOF (ADC_CTL[31]) bit is set to 0, ADC comparator compares CMPDAT (ADC_CTL[27:16]) with conversion result with unsigned format.
     * |        |          |CMPDAT (ADC_CTL[27:16]) should be filled in unsigned format.
     * |        |          |When DMOF (ADC_CTL[31]) bit is set to 1, ADC comparator compares CMPDAT (ADC_CTL[27:16]) with conversion result with 2'complement format.
     * |        |          |CMPDAT (ADC_CTL[27:16]) should be filled in 2'complement format.
    */
    __IO uint32_t CMP[2];

    /**
     * STATUS0
     * ===================================================================================================
     * Offset: 0x50  ADC Status Register 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |ADIF      |ADC Interrupt Flag
     * |        |          |A status flag that indicates the end of A/D conversion.
     * |        |          |ADIF (ADC_STATUS0[0]) is set to 1 at these two conditions:
     * |        |          |1. When A/D conversion ends in Single mode
     * |        |          |2. When A/D conversion ends on all specified channels in Scan mode
     * |        |          |Note: This flag can be cleared by writing 1 to it.
     * |[1]     |ADCMPF0   |Compare Flag
     * |        |          |When the selected channel A/D conversion result meets setting condition in ADCMPR0 then this bit is set to 1.
     * |        |          |And it is cleared by writing 1 to self.
     * |        |          |0 = Conversion result in ADC_DATx does not meet ADCMPR0 setting.
     * |        |          |1 = Conversion result in ADC_DATx meets ADCMPR0 setting.
     * |[2]     |ADCMPF1   |Compare Flag
     * |        |          |When the selected channel A/D conversion result meets setting condition in ADCMPR1 then this bit is set to 1.
     * |        |          |And it is cleared by writing 1 to self.
     * |        |          |0 = Conversion result in ADC_DATx does not meet ADCMPR1 setting.
     * |        |          |1 = Conversion result in ADC_DATx meets ADCMPR1 setting.
     * |[3]     |BUSY      |BUSY/IDLE (Read Only)
     * |        |          |0 = ADC is in idle state.
     * |        |          |1 = ADC is doing conversion.
     * |        |          |This bit is mirror of as SWTRG (ADC_CTL[11]) bit.
     * |[4:7]   |CHANNEL   |Current Conversion Channel (Read Only)
     * |        |          |This field reflects the current conversion channel when BUSY (ADC_STATUS0[3]) = 1.
     * |        |          |When BUSY (ADC_STATUS0[3]) = 0, it shows the number of the next converted channel.
    */
    __IO uint32_t STATUS0;

    /**
     * STATUS1
     * ===================================================================================================
     * Offset: 0x54  ADC Status Register 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:13]  |VALID     |Data Valid Flag (Read Only)
     * |        |          |It is a mirror of VALID (ADC_DATx[17]) bit.
     * |[16:29] |OV        |Overrun Flag (Read Only)
     * |        |          |It is a mirror to OV (ADC_DATx[16]) bit.
    */
    __I  uint32_t STATUS1;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE1[2];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * CURDAT
     * ===================================================================================================
     * Offset: 0x60  ADC PDMA Current Transfer Data Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:17]  |CURDAT    |ADC PDMA Current Transfer Data Bit (Read Only)
     * |        |          |When PDMA transferring, read this register can monitor current PDMA transfer data.
    */
    __I  uint32_t CURDAT;

} ADC_T;

/**
    @addtogroup ADC_CONST ADC Bit Field Definition
    Constant Definitions for ADC Controller
@{ */

#define ADC_DAT0_RESULT_Pos              (0)                                               /*!< ADC_T::DAT: RESULT Position              */
#define ADC_DAT0_RESULT_Msk              (0xfffful << ADC_DAT0_RESULT_Pos)                 /*!< ADC_T::DAT: RESULT Mask                  */

#define ADC_DAT0_OV_Pos                  (16)                                              /*!< ADC_T::DAT: OV Position                  */
#define ADC_DAT0_OV_Msk                  (0x1ul << ADC_DAT0_OV_Pos)                        /*!< ADC_T::DAT: OV Mask                      */

#define ADC_DAT0_VALID_Pos               (17)                                              /*!< ADC_T::DAT: VALID Position               */
#define ADC_DAT0_VALID_Msk               (0x1ul << ADC_DAT0_VALID_Pos)                     /*!< ADC_T::DAT: VALID Mask                   */

#define ADC_DAT1_RESULT_Pos              (0)                                               /*!< ADC_T::DAT: RESULT Position              */
#define ADC_DAT1_RESULT_Msk              (0xfffful << ADC_DAT1_RESULT_Pos)                 /*!< ADC_T::DAT: RESULT Mask                  */

#define ADC_DAT1_OV_Pos                  (16)                                              /*!< ADC_T::DAT: OV Position                  */
#define ADC_DAT1_OV_Msk                  (0x1ul << ADC_DAT1_OV_Pos)                        /*!< ADC_T::DAT: OV Mask                      */

#define ADC_DAT1_VALID_Pos               (17)                                              /*!< ADC_T::DAT: VALID Position               */
#define ADC_DAT1_VALID_Msk               (0x1ul << ADC_DAT1_VALID_Pos)                     /*!< ADC_T::DAT: VALID Mask                   */

#define ADC_DAT2_RESULT_Pos              (0)                                               /*!< ADC_T::DAT: RESULT Position              */
#define ADC_DAT2_RESULT_Msk              (0xfffful << ADC_DAT2_RESULT_Pos)                 /*!< ADC_T::DAT: RESULT Mask                  */

#define ADC_DAT2_OV_Pos                  (16)                                              /*!< ADC_T::DAT: OV Position                  */
#define ADC_DAT2_OV_Msk                  (0x1ul << ADC_DAT2_OV_Pos)                        /*!< ADC_T::DAT: OV Mask                      */

#define ADC_DAT2_VALID_Pos               (17)                                              /*!< ADC_T::DAT: VALID Position               */
#define ADC_DAT2_VALID_Msk               (0x1ul << ADC_DAT2_VALID_Pos)                     /*!< ADC_T::DAT: VALID Mask                   */

#define ADC_DAT3_RESULT_Pos              (0)                                               /*!< ADC_T::DAT: RESULT Position              */
#define ADC_DAT3_RESULT_Msk              (0xfffful << ADC_DAT3_RESULT_Pos)                 /*!< ADC_T::DAT: RESULT Mask                  */

#define ADC_DAT3_OV_Pos                  (16)                                              /*!< ADC_T::DAT: OV Position                  */
#define ADC_DAT3_OV_Msk                  (0x1ul << ADC_DAT3_OV_Pos)                        /*!< ADC_T::DAT: OV Mask                      */

#define ADC_DAT3_VALID_Pos               (17)                                              /*!< ADC_T::DAT: VALID Position               */
#define ADC_DAT3_VALID_Msk               (0x1ul << ADC_DAT3_VALID_Pos)                     /*!< ADC_T::DAT: VALID Mask                   */

#define ADC_DAT4_RESULT_Pos              (0)                                               /*!< ADC_T::DAT: RESULT Position              */
#define ADC_DAT4_RESULT_Msk              (0xfffful << ADC_DAT4_RESULT_Pos)                 /*!< ADC_T::DAT: RESULT Mask                  */

#define ADC_DAT4_OV_Pos                  (16)                                              /*!< ADC_T::DAT: OV Position                  */
#define ADC_DAT4_OV_Msk                  (0x1ul << ADC_DAT4_OV_Pos)                        /*!< ADC_T::DAT: OV Mask                      */

#define ADC_DAT4_VALID_Pos               (17)                                              /*!< ADC_T::DAT: VALID Position               */
#define ADC_DAT4_VALID_Msk               (0x1ul << ADC_DAT4_VALID_Pos)                     /*!< ADC_T::DAT: VALID Mask                   */

#define ADC_DAT5_RESULT_Pos              (0)                                               /*!< ADC_T::DAT: RESULT Position              */
#define ADC_DAT5_RESULT_Msk              (0xfffful << ADC_DAT5_RESULT_Pos)                 /*!< ADC_T::DAT: RESULT Mask                  */

#define ADC_DAT5_OV_Pos                  (16)                                              /*!< ADC_T::DAT: OV Position                  */
#define ADC_DAT5_OV_Msk                  (0x1ul << ADC_DAT5_OV_Pos)                        /*!< ADC_T::DAT: OV Mask                      */

#define ADC_DAT5_VALID_Pos               (17)                                              /*!< ADC_T::DAT: VALID Position               */
#define ADC_DAT5_VALID_Msk               (0x1ul << ADC_DAT5_VALID_Pos)                     /*!< ADC_T::DAT: VALID Mask                   */

#define ADC_DAT6_RESULT_Pos              (0)                                               /*!< ADC_T::DAT: RESULT Position              */
#define ADC_DAT6_RESULT_Msk              (0xfffful << ADC_DAT6_RESULT_Pos)                 /*!< ADC_T::DAT: RESULT Mask                  */

#define ADC_DAT6_OV_Pos                  (16)                                              /*!< ADC_T::DAT: OV Position                  */
#define ADC_DAT6_OV_Msk                  (0x1ul << ADC_DAT6_OV_Pos)                        /*!< ADC_T::DAT: OV Mask                      */

#define ADC_DAT6_VALID_Pos               (17)                                              /*!< ADC_T::DAT: VALID Position               */
#define ADC_DAT6_VALID_Msk               (0x1ul << ADC_DAT6_VALID_Pos)                     /*!< ADC_T::DAT: VALID Mask                   */

#define ADC_DAT7_RESULT_Pos              (0)                                               /*!< ADC_T::DAT: RESULT Position              */
#define ADC_DAT7_RESULT_Msk              (0xfffful << ADC_DAT7_RESULT_Pos)                 /*!< ADC_T::DAT: RESULT Mask                  */

#define ADC_DAT7_OV_Pos                  (16)                                              /*!< ADC_T::DAT: OV Position                  */
#define ADC_DAT7_OV_Msk                  (0x1ul << ADC_DAT7_OV_Pos)                        /*!< ADC_T::DAT: OV Mask                      */

#define ADC_DAT7_VALID_Pos               (17)                                              /*!< ADC_T::DAT: VALID Position               */
#define ADC_DAT7_VALID_Msk               (0x1ul << ADC_DAT7_VALID_Pos)                     /*!< ADC_T::DAT: VALID Mask                   */

#define ADC_DAT8_RESULT_Pos              (0)                                               /*!< ADC_T::DAT: RESULT Position              */
#define ADC_DAT8_RESULT_Msk              (0xfffful << ADC_DAT8_RESULT_Pos)                 /*!< ADC_T::DAT: RESULT Mask                  */

#define ADC_DAT8_OV_Pos                  (16)                                              /*!< ADC_T::DAT: OV Position                  */
#define ADC_DAT8_OV_Msk                  (0x1ul << ADC_DAT8_OV_Pos)                        /*!< ADC_T::DAT: OV Mask                      */

#define ADC_DAT8_VALID_Pos               (17)                                              /*!< ADC_T::DAT: VALID Position               */
#define ADC_DAT8_VALID_Msk               (0x1ul << ADC_DAT8_VALID_Pos)                     /*!< ADC_T::DAT: VALID Mask                   */

#define ADC_DAT9_RESULT_Pos              (0)                                               /*!< ADC_T::DAT: RESULT Position              */
#define ADC_DAT9_RESULT_Msk              (0xfffful << ADC_DAT9_RESULT_Pos)                 /*!< ADC_T::DAT: RESULT Mask                  */

#define ADC_DAT9_OV_Pos                  (16)                                              /*!< ADC_T::DAT: OV Position                  */
#define ADC_DAT9_OV_Msk                  (0x1ul << ADC_DAT9_OV_Pos)                        /*!< ADC_T::DAT: OV Mask                      */

#define ADC_DAT9_VALID_Pos               (17)                                              /*!< ADC_T::DAT: VALID Position               */
#define ADC_DAT9_VALID_Msk               (0x1ul << ADC_DAT9_VALID_Pos)                     /*!< ADC_T::DAT: VALID Mask                   */

#define ADC_DAT10_RESULT_Pos             (0)                                               /*!< ADC_T::DAT: RESULT Position             */
#define ADC_DAT10_RESULT_Msk             (0xfffful << ADC_DAT10_RESULT_Pos)                /*!< ADC_T::DAT: RESULT Mask                 */

#define ADC_DAT10_OV_Pos                 (16)                                              /*!< ADC_T::DAT: OV Position                 */
#define ADC_DAT10_OV_Msk                 (0x1ul << ADC_DAT10_OV_Pos)                       /*!< ADC_T::DAT: OV Mask                     */

#define ADC_DAT10_VALID_Pos              (17)                                              /*!< ADC_T::DAT: VALID Position              */
#define ADC_DAT10_VALID_Msk              (0x1ul << ADC_DAT10_VALID_Pos)                    /*!< ADC_T::DAT: VALID Mask                  */

#define ADC_DAT11_RESULT_Pos             (0)                                               /*!< ADC_T::DAT: RESULT Position             */
#define ADC_DAT11_RESULT_Msk             (0xfffful << ADC_DAT11_RESULT_Pos)                /*!< ADC_T::DAT: RESULT Mask                 */

#define ADC_DAT11_OV_Pos                 (16)                                              /*!< ADC_T::DAT: OV Position                 */
#define ADC_DAT11_OV_Msk                 (0x1ul << ADC_DAT11_OV_Pos)                       /*!< ADC_T::DAT: OV Mask                     */

#define ADC_DAT11_VALID_Pos              (17)                                              /*!< ADC_T::DAT: VALID Position              */
#define ADC_DAT11_VALID_Msk              (0x1ul << ADC_DAT11_VALID_Pos)                    /*!< ADC_T::DAT: VALID Mask                  */

#define ADC_DAT12_RESULT_Pos             (0)                                               /*!< ADC_T::DAT: RESULT Position             */
#define ADC_DAT12_RESULT_Msk             (0xfffful << ADC_DAT12_RESULT_Pos)                /*!< ADC_T::DAT: RESULT Mask                 */

#define ADC_DAT12_OV_Pos                 (16)                                              /*!< ADC_T::DAT: OV Position                 */
#define ADC_DAT12_OV_Msk                 (0x1ul << ADC_DAT12_OV_Pos)                       /*!< ADC_T::DAT: OV Mask                     */

#define ADC_DAT12_VALID_Pos              (17)                                              /*!< ADC_T::DAT: VALID Position              */
#define ADC_DAT12_VALID_Msk              (0x1ul << ADC_DAT12_VALID_Pos)                    /*!< ADC_T::DAT: VALID Mask                  */

#define ADC_DAT13_RESULT_Pos             (0)                                               /*!< ADC_T::DAT: RESULT Position             */
#define ADC_DAT13_RESULT_Msk             (0xfffful << ADC_DAT13_RESULT_Pos)                /*!< ADC_T::DAT: RESULT Mask                 */

#define ADC_DAT13_OV_Pos                 (16)                                              /*!< ADC_T::DAT: OV Position                 */
#define ADC_DAT13_OV_Msk                 (0x1ul << ADC_DAT13_OV_Pos)                       /*!< ADC_T::DAT: OV Mask                     */

#define ADC_DAT13_VALID_Pos              (17)                                              /*!< ADC_T::DAT: VALID Position              */
#define ADC_DAT13_VALID_Msk              (0x1ul << ADC_DAT13_VALID_Pos)                    /*!< ADC_T::DAT: VALID Mask                  */

#define ADC_CTL_ADCEN_Pos                (0)                                               /*!< ADC_T::CTL: ADCEN Position                */
#define ADC_CTL_ADCEN_Msk                (0x1ul << ADC_CTL_ADCEN_Pos)                      /*!< ADC_T::CTL: ADCEN Mask                    */

#define ADC_CTL_ADCIEN_Pos               (1)                                               /*!< ADC_T::CTL: ADCIEN Position               */
#define ADC_CTL_ADCIEN_Msk               (0x1ul << ADC_CTL_ADCIEN_Pos)                     /*!< ADC_T::CTL: ADCIEN Mask                   */

#define ADC_CTL_OPMODE_Pos               (2)                                               /*!< ADC_T::CTL: OPMODE Position               */
#define ADC_CTL_OPMODE_Msk               (0x3ul << ADC_CTL_OPMODE_Pos)                     /*!< ADC_T::CTL: OPMODE Mask                   */

#define ADC_CTL_HWTRGSEL_Pos             (4)                                               /*!< ADC_T::CTL: HWTRGSEL Position             */
#define ADC_CTL_HWTRGSEL_Msk             (0x3ul << ADC_CTL_HWTRGSEL_Pos)                   /*!< ADC_T::CTL: HWTRGSEL Mask                 */

#define ADC_CTL_HWTRGCOND_Pos            (6)                                               /*!< ADC_T::CTL: HWTRGCOND Position            */
#define ADC_CTL_HWTRGCOND_Msk            (0x3ul << ADC_CTL_HWTRGCOND_Pos)                  /*!< ADC_T::CTL: HWTRGCOND Mask                */

#define ADC_CTL_HWTRGEN_Pos              (8)                                               /*!< ADC_T::CTL: HWTRGEN Position              */
#define ADC_CTL_HWTRGEN_Msk              (0x1ul << ADC_CTL_HWTRGEN_Pos)                    /*!< ADC_T::CTL: HWTRGEN Mask                  */

#define ADC_CTL_PDMAEN_Pos               (9)                                               /*!< ADC_T::CTL: PDMAEN Position               */
#define ADC_CTL_PDMAEN_Msk               (0x1ul << ADC_CTL_PDMAEN_Pos)                     /*!< ADC_T::CTL: PDMAEN Mask                   */

#define ADC_CTL_DIFFEN_Pos               (10)                                              /*!< ADC_T::CTL: DIFFEN Position               */
#define ADC_CTL_DIFFEN_Msk               (0x1ul << ADC_CTL_DIFFEN_Pos)                     /*!< ADC_T::CTL: DIFFEN Mask                   */

#define ADC_CTL_SWTRG_Pos                (11)                                              /*!< ADC_T::CTL: SWTRG Position                */
#define ADC_CTL_SWTRG_Msk                (0x1ul << ADC_CTL_SWTRG_Pos)                      /*!< ADC_T::CTL: SWTRG Mask                    */

#define ADC_CTL_PWMTRGDLY_Pos            (16)                                              /*!< ADC_T::CTL: PWMTRGDLY Position            */
#define ADC_CTL_PWMTRGDLY_Msk            (0xfful << ADC_CTL_PWMTRGDLY_Pos)                 /*!< ADC_T::CTL: PWMTRGDLY Mask                */

#define ADC_CTL_DMOF_Pos                 (31)                                              /*!< ADC_T::CTL: DMOF Position                 */
#define ADC_CTL_DMOF_Msk                 (0x1ul << ADC_CTL_DMOF_Pos)                       /*!< ADC_T::CTL: DMOF Mask                     */

#define ADC_CHEN_CHEN_Pos                (0)                                               /*!< ADC_T::CHEN: CHEN Position                */
#define ADC_CHEN_CHEN_Msk                (0xffful << ADC_CHEN_CHEN_Pos)                    /*!< ADC_T::CHEN: CHEN Mask                    */

#define ADC_CHEN_ADTSEN_Pos              (16)                                              /*!< ADC_T::CHEN: ADTSEN Position              */
#define ADC_CHEN_ADTSEN_Msk              (0x1ul << ADC_CHEN_ADTSEN_Pos)                    /*!< ADC_T::CHEN: ADTSEN Mask                  */

#define ADC_CHEN_ADBGEN_Pos              (17)                                              /*!< ADC_T::CHEN: ADBGEN Position              */
#define ADC_CHEN_ADBGEN_Msk              (0x1ul << ADC_CHEN_ADBGEN_Pos)                    /*!< ADC_T::CHEN: ADBGEN Mask                  */

#define ADC_CMP0_ADCMPEN_Pos             (0)                                               /*!< ADC_T::CMP: ADCMPEN Position             */
#define ADC_CMP0_ADCMPEN_Msk             (0x1ul << ADC_CMP0_ADCMPEN_Pos)                   /*!< ADC_T::CMP: ADCMPEN Mask                 */

#define ADC_CMP0_ADCMPIE_Pos             (1)                                               /*!< ADC_T::CMP: ADCMPIE Position             */
#define ADC_CMP0_ADCMPIE_Msk             (0x1ul << ADC_CMP0_ADCMPIE_Pos)                   /*!< ADC_T::CMP: ADCMPIE Mask                 */

#define ADC_CMP0_CMPCOND_Pos             (2)                                               /*!< ADC_T::CMP: CMPCOND Position             */
#define ADC_CMP0_CMPCOND_Msk             (0x1ul << ADC_CMP0_CMPCOND_Pos)                   /*!< ADC_T::CMP: CMPCOND Mask                 */

#define ADC_CMP0_CMPCH_Pos               (3)                                               /*!< ADC_T::CMP: CMPCH Position               */
#define ADC_CMP0_CMPCH_Msk               (0xful << ADC_CMP0_CMPCH_Pos)                     /*!< ADC_T::CMP: CMPCH Mask                   */

#define ADC_CMP0_CMPMCNT_Pos             (8)                                               /*!< ADC_T::CMP: CMPMCNT Position             */
#define ADC_CMP0_CMPMCNT_Msk             (0xful << ADC_CMP0_CMPMCNT_Pos)                   /*!< ADC_T::CMP: CMPMCNT Mask                 */

#define ADC_CMP0_CMPDAT_Pos              (16)                                              /*!< ADC_T::CMP: CMPDAT Position              */
#define ADC_CMP0_CMPDAT_Msk              (0xffful << ADC_CMP0_CMPDAT_Pos)                  /*!< ADC_T::CMP: CMPDAT Mask                  */

#define ADC_CMP1_ADCMPEN_Pos             (0)                                               /*!< ADC_T::CMP: ADCMPEN Position             */
#define ADC_CMP1_ADCMPEN_Msk             (0x1ul << ADC_CMP1_ADCMPEN_Pos)                   /*!< ADC_T::CMP: ADCMPEN Mask                 */

#define ADC_CMP1_ADCMPIE_Pos             (1)                                               /*!< ADC_T::CMP: ADCMPIE Position             */
#define ADC_CMP1_ADCMPIE_Msk             (0x1ul << ADC_CMP1_ADCMPIE_Pos)                   /*!< ADC_T::CMP: ADCMPIE Mask                 */

#define ADC_CMP1_CMPCOND_Pos             (2)                                               /*!< ADC_T::CMP: CMPCOND Position             */
#define ADC_CMP1_CMPCOND_Msk             (0x1ul << ADC_CMP1_CMPCOND_Pos)                   /*!< ADC_T::CMP: CMPCOND Mask                 */

#define ADC_CMP1_CMPCH_Pos               (3)                                               /*!< ADC_T::CMP: CMPCH Position               */
#define ADC_CMP1_CMPCH_Msk               (0xful << ADC_CMP1_CMPCH_Pos)                     /*!< ADC_T::CMP: CMPCH Mask                   */

#define ADC_CMP1_CMPMCNT_Pos             (8)                                               /*!< ADC_T::CMP: CMPMCNT Position             */
#define ADC_CMP1_CMPMCNT_Msk             (0xful << ADC_CMP1_CMPMCNT_Pos)                   /*!< ADC_T::CMP: CMPMCNT Mask                 */

#define ADC_CMP1_CMPDAT_Pos              (16)                                              /*!< ADC_T::CMP: CMPDAT Position              */
#define ADC_CMP1_CMPDAT_Msk              (0xffful << ADC_CMP1_CMPDAT_Pos)                  /*!< ADC_T::CMP: CMPDAT Mask                  */

#define ADC_STATUS0_ADIF_Pos             (0)                                               /*!< ADC_T::STATUS0: ADIF Position             */
#define ADC_STATUS0_ADIF_Msk             (0x1ul << ADC_STATUS0_ADIF_Pos)                   /*!< ADC_T::STATUS0: ADIF Mask                 */

#define ADC_STATUS0_ADCMPF0_Pos          (1)                                               /*!< ADC_T::STATUS0: ADCMPF0 Position          */
#define ADC_STATUS0_ADCMPF0_Msk          (0x1ul << ADC_STATUS0_ADCMPF0_Pos)                /*!< ADC_T::STATUS0: ADCMPF0 Mask              */

#define ADC_STATUS0_ADCMPF1_Pos          (2)                                               /*!< ADC_T::STATUS0: ADCMPF1 Position          */
#define ADC_STATUS0_ADCMPF1_Msk          (0x1ul << ADC_STATUS0_ADCMPF1_Pos)                /*!< ADC_T::STATUS0: ADCMPF1 Mask              */

#define ADC_STATUS0_BUSY_Pos             (3)                                               /*!< ADC_T::STATUS0: BUSY Position             */
#define ADC_STATUS0_BUSY_Msk             (0x1ul << ADC_STATUS0_BUSY_Pos)                   /*!< ADC_T::STATUS0: BUSY Mask                 */

#define ADC_STATUS0_CHANNEL_Pos          (4)                                               /*!< ADC_T::STATUS0: CHANNEL Position          */
#define ADC_STATUS0_CHANNEL_Msk          (0xful << ADC_STATUS0_CHANNEL_Pos)                /*!< ADC_T::STATUS0: CHANNEL Mask              */

#define ADC_STATUS1_VALID_Pos            (0)                                               /*!< ADC_T::STATUS1: VALID Position            */
#define ADC_STATUS1_VALID_Msk            (0x3ffful << ADC_STATUS1_VALID_Pos)               /*!< ADC_T::STATUS1: VALID Mask                */

#define ADC_STATUS1_OV_Pos               (16)                                              /*!< ADC_T::STATUS1: OV Position               */
#define ADC_STATUS1_OV_Msk               (0x3ffful << ADC_STATUS1_OV_Pos)                  /*!< ADC_T::STATUS1: OV Mask                   */

#define ADC_CURDAT_CURDAT_Pos            (0)                                               /*!< ADC_T::CURDAT: CURDAT Position            */
#define ADC_CURDAT_CURDAT_Msk            (0x3fffful << ADC_CURDAT_CURDAT_Pos)              /*!< ADC_T::CURDAT: CURDAT Mask                */

/**@}*/ /* ADC_CONST */
/**@}*/ /* end of ADC register group */


/*---------------------- Controller Area Network Controller -------------------------*/
/**
    @addtogroup CAN Controller Area Network Controller(CAN)
    Memory Mapped Structure for CAN Controller
@{ */

typedef struct {

    /**
     * CAN_IFn_CREQ
     * ===================================================================================================
     * Offset: 0x20, 0x80  IFn (Register Map Note 2) Command Request Registers
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:5]   |MessageNumber|Message Number
     * |        |          |0x01-0x20: Valid Message Number, the Message Object in the Message
     * |        |          |RAM is selected for data transfer.
     * |        |          |0x00: Not a valid Message Number, interpreted as 0x20.
     * |        |          |0x21-0x3F: Not a valid Message Number, interpreted as 0x01-0x1F.
     * |[15]    |Busy      |Busy Flag
     * |        |          |0 = Read/write action has finished.
     * |        |          |1 = Writing to the IFn Command Request Register is in progress.
     * |        |          |This bit can only be read by the software.
    */
    __IO uint32_t CREQ;

    /**
     * CAN_IFn_CMASK
     * ===================================================================================================
     * Offset: 0x24, 0x84  IFn Command Mask Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |DAT_B     |Access Data Bytes [7:4]
     * |        |          |Write Operation:
     * |        |          |0 = Data Bytes [7:4] unchanged.
     * |        |          |1 = Transfer Data Bytes [7:4] to Message Object.
     * |        |          |Read Operation:
     * |        |          |0 = Data Bytes [7:4] unchanged.
     * |        |          |1 = Transfer Data Bytes [7:4] to IFn Message Buffer Register.
     * |[1]     |DAT_A     |Access Data Bytes [3:0]
     * |        |          |Write Operation:
     * |        |          |0 = Data Bytes [3:0] unchanged.
     * |        |          |1 = Transfer Data Bytes [3:0] to Message Object.
     * |        |          |Read Operation:
     * |        |          |0 = Data Bytes [3:0] unchanged.
     * |        |          |1 = Transfer Data Bytes [3:0] to IFn Message Buffer Register.
     * |[2]     |TxRqst_NewDat|Access Transmission Request Bit When Write Operation
     * |        |          |0 = TxRqst bit unchanged.
     * |        |          |1 = Set TxRqst bit.
     * |        |          |Note: If a transmission is requested by programming bit TxRqst/NewDat in the IFn Command Mask Register, bit TxRqst in the IFn Message Control Register will be ignored.
     * |        |          |Access New Data Bit when Read Operation.
     * |        |          |0 = NewDat bit remains unchanged.
     * |        |          |1 = Clear NewDat bit in the Message Object.
     * |        |          |Note: A read access to a Message Object can be combined with the reset of the control bits IntPnd and NewDat.
     * |        |          |The values of these bits transferred to the IFn Message Control Register always reflect the status before resetting these bits.
     * |[3]     |ClrIntPnd |Clear Interrupt Pending Bit
     * |        |          |Write Operation:
     * |        |          |When writing to a Message Object, this bit is ignored.
     * |        |          |Read Operation:
     * |        |          |0 = IntPnd bit (CAN_IFn_MCON[13]) remains unchanged.
     * |        |          |1 = Clear IntPnd bit in the Message Object.
     * |[4]     |Control   |Control Access Control Bits
     * |        |          |Write Operation:
     * |        |          |0 = Control Bits unchanged.
     * |        |          |1 = Transfer Control Bits to Message Object.
     * |        |          |Read Operation:
     * |        |          |0 = Control Bits unchanged.
     * |        |          |1 = Transfer Control Bits to IFn Message Buffer Register.
     * |[5]     |Arb       |Access Arbitration Bits
     * |        |          |Write Operation:
     * |        |          |0 = Arbitration bits unchanged.
     * |        |          |1 = Transfer Identifier + Dir (CAN_IFn_ARB2[13]) + Xtd (CAN_IFn_ARB2[14]) + MsgVal (CAN_IFn_APB2[15]) to Message Object.
     * |        |          |Read Operation:
     * |        |          |0 = Arbitration bits unchanged.
     * |        |          |1 = Transfer Identifier + Dir + Xtd + MsgVal to IFn Message Buffer Register.
     * |[6]     |Mask      |Access Mask Bits
     * |        |          |Write Operation:
     * |        |          |0 = Mask bits unchanged.
     * |        |          |1 = Transfer Identifier Mask + MDir + MXtd to Message Object.
     * |        |          |Read Operation:
     * |        |          |0 = Mask bits unchanged.
     * |        |          |1 = Transfer Identifier Mask + MDir + MXtd to IFn Message Buffer Register.
     * |[7]     |WR_RD     |Write / Read Mode
     * |        |          |0 = Read: Transfer data from the Message Object addressed by the Command Request Register into the selected Message Buffer Registers.
     * |        |          |1 = Write: Transfer data from the selected Message Buffer Registers to the Message Object addressed by the Command Request Register.
    */
    __IO uint32_t CMASK;

    /**
     * CAN_IFn_MASK1
     * ===================================================================================================
     * Offset: 0x28, 0x88  IFn Mask 1 Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |Msk150    |Identifier Mask 15-0
     * |        |          |0 = The corresponding bit in the identifier of the message object cannot inhibit the match in the acceptance filtering.
     * |        |          |1 = The corresponding identifier bit is used for acceptance filtering.
    */
    __IO uint32_t MASK1;

    /**
     * CAN_IFn_MASK2
     * ===================================================================================================
     * Offset: 0x2C, 0x8C  IFn Mask 2 Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:12]  |Msk2816   |Identifier Mask 28-16
     * |        |          |0 = The corresponding bit in the identifier of the message object cannot inhibit the match in the acceptance filtering.
     * |        |          |1 = The corresponding identifier bit is used for acceptance filtering.
     * |[14]    |MDir      |Mask Message Direction
     * |        |          |0 = The message direction bit (Dir (CAN_IFn_ARB2[13])) has no effect on the acceptance filtering.
     * |        |          |1 = The message direction bit (Dir) is used for acceptance filtering.
     * |[15]    |MXtd      |Mask Extended Identifier
     * |        |          |0 = The extended identifier bit (IDE) has no effect on the acceptance filtering.
     * |        |          |1 = The extended identifier bit (IDE) is used for acceptance filtering.
     * |        |          |Note: When 11-bit ("standard") Identifiers are used for a Message Object, the identifiers of received Data Frames are written into bits ID28 to ID18 (CAN_IFn_ARB2[12:2]).
     * |        |          |For acceptance filtering, only these bits together with mask bits Msk28 to Msk18 (CAN_IFn_MASK2[12:2]) are considered.
    */
    __IO uint32_t MASK2;

    /**
     * CAN_IFn_ARB1
     * ===================================================================================================
     * Offset: 0x30, 0x90  IFn Arbitration 1 Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |ID150     |Message Identifier 15-0
     * |        |          |ID28 - ID0, 29-bit Identifier ("Extended Frame").
     * |        |          |ID28 - ID18, 11-bit Identifier ("Standard Frame")
    */
    __IO uint32_t ARB1;

    /**
     * CAN_IFn_ARB2
     * ===================================================================================================
     * Offset: 0x34, 0x94  IFn Arbitration 2 Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:12]  |ID2816    |Message Identifier 28-16
     * |        |          |ID28 - ID0, 29-bit Identifier ("Extended Frame").
     * |        |          |ID28 - ID18, 11-bit Identifier ("Standard Frame")
     * |[13]    |Dir       |Message Direction
     * |        |          |0 = Direction is receive.
     * |        |          |On TxRqst, a Remote Frame with the identifier of this Message Object is transmitted.
     * |        |          |On reception of a Data Frame with matching identifier, that message is stored in this Message Object.
     * |        |          |1 = Direction is transmit.
     * |        |          |On TxRqst, the respective Message Object is transmitted as a Data Frame.
     * |        |          |On reception of a Remote Frame with matching identifier, the TxRqst bit (CAN_IFn_CMASK[2]) of this Message Object is set (if RmtEn (CAN_IFn_MCON[9]) = one).
     * |[14]    |Xtd       |Extended Identifier
     * |        |          |0 = The 11-bit ("standard") Identifier will be used for this Message Object.
     * |        |          |1 = The 29-bit ("extended") Identifier will be used for this Message Object.
     * |[15]    |MsgVal    |Message Valid
     * |        |          |0 = The Message Object is ignored by the Message Handler.
     * |        |          |1 = The Message Object is configured and should be considered by the Message Handler.
     * |        |          |Note: The application software must reset the MsgVal bit of all unused Messages Objects during the initialization before it resets bit Init (CAN_CON[0]).
     * |        |          |This bit must also be reset before the identifier Id28-0 (CAN_IFn_ARB1/2), the control bits Xtd (CAN_IFn_ARB2[14]), Dir (CAN_IFn_APB2[13]), or the Data Length Code DLC3-0 (CAN_IFn_MCON[3:0]) are modified, or if the Messages Object is no longer required.
    */
    __IO uint32_t ARB2;

    /**
     * CAN_IFn_MCON
     * ===================================================================================================
     * Offset: 0x38, 0x98  IFn Message Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |DLC       |Data Length Code
     * |        |          |0-8: Data Frame has 0-8 data bytes.
     * |        |          |9-15: Data Frame has 8 data bytes
     * |        |          |Note: The Data Length Code of a Message Object must be defined the same as in all the corresponding objects with the same identifier at other nodes.
     * |        |          |When the Message Handler stores a data frame, it will write the DLC to the value given by the received message.
     * |        |          |Data 0: 1st data byte of a CAN Data Frame
     * |        |          |Data 1: 2nd data byte of a CAN Data Frame
     * |        |          |Data 2: 3rd data byte of a CAN Data Frame
     * |        |          |Data 3: 4th data byte of a CAN Data Frame
     * |        |          |Data 4: 5th data byte of a CAN Data Frame
     * |        |          |Data 5: 6th data byte of a CAN Data Frame
     * |        |          |Data 6: 7th data byte of a CAN Data Frame
     * |        |          |Data 7 : 8th data byte of a CAN Data Frame
     * |        |          |Note: The Data 0 Byte is the first data byte shifted into the shift register of the CAN Core during a reception while the Data 7 byte is the last.
     * |        |          |When the Message Handler stores a Data Frame, it will write all the eight data bytes into a Message Object.
     * |        |          |If the Data Length Code is less than 8, the remaining bytes of the Message Object will be overwritten by unspecified values.
     * |[7]     |EoB       |End Of Buffer
     * |        |          |0 = Message Object belongs to a FIFO Buffer and is not the last Message Object of that FIFO Buffer.
     * |        |          |1 = Single Message Object or last Message Object of a FIFO Buffer.
     * |        |          |Note: This bit is used to concatenate two or more Message Objects (up to 32) to build a FIFO Buffer.
     * |        |          |For single Message Objects (not belonging to a FIFO Buffer), this bit must always be set to one.
     * |[8]     |TxRqst    |Transmit Request
     * |        |          |0 = This Message Object is not waiting for transmission.
     * |        |          |1 = The transmission of this Message Object is requested and is not yet done.
     * |[9]     |RmtEn     |Remote Enable Control
     * |        |          |0 = At the reception of a Remote Frame, TxRqst (CAN_IFn_MCON[8]) is left unchanged.
     * |        |          |1 = At the reception of a Remote Frame, TxRqst is set.
     * |[10]    |RxIE      |Receive Interrupt Enable Control
     * |        |          |0 = IntPnd (CAN_IFn_MCON[13]) will be left unchanged after a successful reception of a frame.
     * |        |          |1 = IntPnd will be set after a successful reception of a frame.
     * |[11]    |TxIE      |Transmit Interrupt Enable Control
     * |        |          |0 = IntPnd (CAN_IFn_MCON[13]) will be left unchanged after the successful transmission of a frame.
     * |        |          |1 = IntPnd will be set after a successful transmission of a frame.
     * |[12]    |UMask     |Use Acceptance Mask
     * |        |          |0 = Mask ignored.
     * |        |          |1 = Use Mask (Msk28-0, MXtd, and MDir) for acceptance filtering.
     * |        |          |Note: If the UMask bit is set to one, the Message Object's mask bits have to be programmed during initialization of the Message Object before MsgVal bit (CAN_IFn_APB2[15]) is set to one.
     * |[13]    |IntPnd    |Interrupt Pending
     * |        |          |0 = This message object is not the source of an interrupt.
     * |        |          |1 = This message object is the source of an interrupt.
     * |        |          |The Interrupt Identifier in the Interrupt Register will point to this message object if there is no other interrupt source with higher priority.
     * |[14]    |MsgLst    |Message Lost (only valid for Message Objects with direction = receive).
     * |        |          |0 = No message lost since last time this bit was reset by the CPU.
     * |        |          |1 = The Message Handler stored a new message into this object when NewDat was still set, the CPU has lost a message.
     * |[15]    |NewDat    |New Data
     * |        |          |0 = No new data has been written into the data portion of this Message Object by the Message Handler since last time this flag was cleared by the application software.
     * |        |          |1 = The Message Handler or the application software has written new data into the data portion of this Message Object.
    */
    __IO uint32_t MCON;

    /**
     * CAN_IFn_DAT_A1
     * ===================================================================================================
     * Offset: 0x3C, 0x9C  IFn Data A1 Register (Register Map Note 3)
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |Data0     |Data Byte 0
     * |        |          |1st data byte of a CAN Data Frame
     * |[8:15]  |Data1     |Data Byte 1
     * |        |          |2nd data byte of a CAN Data Frame
    */
    __IO uint32_t DAT_A1;

    /**
     * CAN_IFn_DAT_A2
     * ===================================================================================================
     * Offset: 0x40, 0xA0  IFn Data A2 Register (Register Map Note 3)
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |Data2     |Data Byte 2
     * |        |          |3rd data byte of CAN Data Frame
     * |[8:15]  |Data3     |Data Byte 3
     * |        |          |4th data byte of CAN Data Frame
    */
    __IO uint32_t DAT_A2;

    /**
     * CAN_IFn_DAT_B1
     * ===================================================================================================
     * Offset: 0x44, 0xA4  IFn Data B1 Register (Register Map Note 3)
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |Data4     |Data Byte 4
     * |        |          |5th data byte of CAN Data Frame
     * |[8:15]  |Data5     |Data Byte 5
     * |        |          |6th data byte of CAN Data Frame
    */
    __IO uint32_t DAT_B1;

    /**
     * CAN_IFn_DAT_B2
     * ===================================================================================================
     * Offset: 0x48, 0xA8  IFn Data B2 Register (Register Map Note 3)
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |Data6     |Data Byte 6
     * |        |          |7th data byte of CAN Data Frame.
     * |[8:15]  |Data7     |Data Byte 7
     * |        |          |8th data byte of CAN Data Frame.
    */
    __IO uint32_t DAT_B2;
    /// @cond HIDDEN_SYMBOLS
    __I uint32_t RESERVE0[13];
    /// @endcond //HIDDEN_SYMBOLS
} CAN_IF_T;

typedef struct {

    /**
     * CAN_CON
     * ===================================================================================================
     * Offset: 0x00  Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |Init      |Init Initialization
     * |        |          |0 = Normal Operation.
     * |        |          |1 = Initialization is started.
     * |[1]     |IE        |Module Interrupt Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[2]     |SIE       |Status Change Interrupt Enable Control
     * |        |          |0 = Disabled - No Status Change Interrupt will be generated.
     * |        |          |1 = Enabled - An interrupt will be generated when a message transfer is successfully completed or a CAN bus error is detected.
     * |[3]     |EIE       |Error Interrupt Enable Control
     * |        |          |0 = Disabled - No Error Status Interrupt will be generated.
     * |        |          |1 = Enabled - A change in the bits BOff (CAN_STATUS[7]) or EWarn (CAN_STATUS[6]) in the Status Register will generate an interrupt.
     * |[5]     |DAR       |Automatic Re-Transmission Disable Control
     * |        |          |0 = Automatic Retransmission of disturbed messages enabled.
     * |        |          |1 = Automatic Retransmission disabled.
     * |[6]     |CCE       |Configuration Change Enable Control
     * |        |          |0 = No write access to the Bit Timing Register.
     * |        |          |1 = Write access to the Bit Timing Register (CAN_BTIME) allowed. (while Init bit (CAN_CON[0]) = 1).
     * |[7]     |Test      |Test Mode Enable Control
     * |        |          |0 = Normal Operation.
     * |        |          |1 = Test Mode.
    */
    __IO uint32_t   CON;

    /**
     * CAN_STATUS
     * ===================================================================================================
     * Offset: 0x04  Status Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:2]   |LEC       |Last Error Code (Type Of The Last Error To Occur On The CAN Bus)
     * |        |          |The LEC field holds a code, which indicates the type of the last error to occur on the CAN bus.
     * |        |          |This field will be cleared to '0' when a message has been transferred (reception or transmission) without error.
     * |        |          |The unused code '7' may be written by the CPU to check for updates.
     * |        |          |The following table describes the error code.
     * |[3]     |TxOK      |Transmitted A Message Successfully
     * |        |          |0 = Since this bit was reset by the CPU, no message has been successfully transmitted.
     * |        |          |This bit is never reset by the CAN Core.
     * |        |          |1 = Since this bit was last reset by the CPU, a message has been successfully (error free and acknowledged by at least one other node) transmitted.
     * |[4]     |RxOK      |Received A Message Successfully
     * |        |          |0 = No message has been successfully received since this bit was last reset by the CPU.
     * |        |          |This bit is never reset by the CAN Core.
     * |        |          |1 = A message has been successfully received since this bit was last reset by the CPU (independent of the result of acceptance filtering).
     * |[5]     |EPass     |Error Passive (Read Only)
     * |        |          |0 = The CAN Core is error active.
     * |        |          |1 = The CAN Core is in the error passive state as defined in the CAN Specification.
     * |[6]     |EWarn     |Error Warning Status (Read Only)
     * |        |          |0 = Both error counters are below the error warning limit of 96.
     * |        |          |1 = At least one of the error counters in the EML has reached the error warning limit of 96.
     * |[7]     |BOff      |Bus-Off Status (Read Only)
     * |        |          |0 = The CAN module is not in bus-off state.
     * |        |          |1 = The CAN module is in bus-off state.
    */
    __IO uint32_t   STATUS;

    /**
     * CAN_ERR
     * ===================================================================================================
     * Offset: 0x08  Error Counter Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |TEC       |Transmit Error Counter
     * |        |          |Actual state of the Transmit Error Counter. Values between 0 and 255.
     * |[8:14]  |REC       |Receive Error Counter
     * |        |          |Actual state of the Receive Error Counter. Values between 0 and 127.
     * |[15]    |RP        |Receive Error Passive
     * |        |          |0 = The Receive Error Counter is below the error passive level.
     * |        |          |1 = The Receive Error Counter has reached the error passive level as defined in the CAN Specification.
    */
    __IO uint32_t   ERR;

    /**
     * CAN_BTIME
     * ===================================================================================================
     * Offset: 0x0C  Bit Timing Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:5]   |BRP       |Baud Rate Prescaler
     * |        |          |0x01-0x3F: The value by which the oscillator frequency is divided for generating the bit time quanta.
     * |        |          |The bit time is built up from a multiple of this quanta.
     * |        |          |Valid values for the Baud Rate Prescaler are [ 0 ... 63 ].
     * |        |          |The actual interpretation by the hardware of this value is such that one more than the value programmed here is used.
     * |[6:7]   |SJW       |(Re)Synchronization Jump Width
     * |        |          |0x0-0x3: Valid programmed values are [0 ... 3].
     * |        |          |The actual interpretation by the hardware of this value is such that one more than the value programmed here is used.
     * |[8:11]  |TSeg1     |Time Segment Before The Sample Point Minus Sync_Seg
     * |        |          |0x01-0x0F: valid values for TSeg1 are [1 ... 15].
     * |        |          |The actual interpretation by the hardware of this value is such that one more than the value programmed is used.
     * |[12:14] |TSeg2     |Time Segment After Sample Point
     * |        |          |0x0-0x7: Valid values for TSeg2 are [0 ... 7].
     * |        |          |The actual interpretation by the hardware of this value is such that one more than the value programmed here is used.
    */
    __IO uint32_t   BTIME;

    /**
     * CAN_IIDR
     * ===================================================================================================
     * Offset: 0x10  Interrupt Identifier Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |IntId     |Interrupt Identifier (Indicates The Source Of The Interrupt)
     * |        |          |If several interrupts are pending, the CAN Interrupt Register will point to the pending interrupt with the highest priority, disregarding their chronological order.
     * |        |          |An interrupt remains pending until the application software has cleared it.
     * |        |          |If IntId is different from 0x0000 and IE (CAN_IFn_MCON[1]) is set, the IRQ interrupt signal to the EIC is active.
     * |        |          |The interrupt remains active until IntId is back to value 0x0000 (the cause of the interrupt is reset) or until IE is reset.
     * |        |          |The Status Interrupt has the highest priority.
     * |        |          |Among the message interrupts, the Message Object' s interrupt priority decreases with increasing message number.
     * |        |          |A message interrupt is cleared by clearing the Message Object's IntPnd bit (CAN_IFn_MCON[13]).
     * |        |          |The Status Interrupt is cleared by reading the Status Register.
    */
    __IO uint32_t   IIDR;

    /**
     * CAN_TEST
     * ===================================================================================================
     * Offset: 0x14  Test Register (Register Map Note 1)
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:1]   |Res       |Reserved
     * |        |          |There are reserved bits.
     * |        |          |These bits are always read as '0' and must always be written with '0'.
     * |[2]     |Basic     |Basic Mode
     * |        |          |0 = Basic Mode disabled.
     * |        |          |1= IF1 Registers used as Tx Buffer, IF2 Registers used as Rx Buffer.
     * |[3]     |Silent    |Silent Mode
     * |        |          |0 = Normal operation.
     * |        |          |1 = The module is in Silent Mode.
     * |[4]     |LBack     |Loop Back Mode Enable Control
     * |        |          |0 = Loop Back Mode is disabled.
     * |        |          |1 = Loop Back Mode is enabled.
     * |[5:6]   |Tx10      |Tx[1:0]: Control Of CAN_TX Pin
     * |        |          |00 = Reset value, CAN_TX pin is controlled by the CAN Core.
     * |        |          |01 = Sample Point can be monitored at CAN_TX pin.
     * |        |          |10 = CAN_TX pin drives a dominant ('0') value.
     * |        |          |11 = CAN_TX pin drives a recessive ('1') value.
     * |[7]     |Rx        |Monitors The Actual Value Of CAN_RX Pin (Read Only)
     * |        |          |0 = The CAN bus is dominant (CAN_RX = '0').
     * |        |          |1 = The CAN bus is recessive (CAN_RX = '1').
    */
    __IO uint32_t   TEST;

    /**
     * CAN_BRPE
     * ===================================================================================================
     * Offset: 0x18  Baud Rate Prescaler Extension Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |BRPE      |BRPE: Baud Rate Prescaler Extension
     * |        |          |0x00-0x0F: By programming BRPE, the Baud Rate Prescaler can be extended to values up to 1023.
     * |        |          |The actual interpretation by the hardware is that one more than the value programmed by BRPE (MSBs) and BTIME (LSBs) is used.
    */
    __IO uint32_t   BRPE;

    __I uint32_t    RESERVE0[1];

    __IO CAN_IF_T   IF[2];

    __I uint32_t    RESERVE1[8];

    /**
     * CAN_TXREQ1
     * ===================================================================================================
     * Offset: 0x100  Transmission Request Register 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |TxRqst161 |Transmission Request Bits 16-1 (Of All Message Objects)
     * |        |          |0 = This Message Object is not waiting for transmission.
     * |        |          |1 = The transmission of this Message Object is requested and is not yet done.
     * |        |          |These bits are read only.
    */
    __IO uint32_t   TXREQ1;

    /**
     * CAN_TXREQ2
     * ===================================================================================================
     * Offset: 0x104  Transmission Request Register 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |TxRqst3217|Transmission Request Bits 32-17 (Of All Message Objects)
     * |        |          |0 = This Message Object is not waiting for transmission.
     * |        |          |1 = The transmission of this Message Object is requested and is not yet done.
     * |        |          |These bits are read only.
    */
    __IO uint32_t   TXREQ2;

    __I uint32_t    RESERVE2[6];

    /**
     * CAN_NDAT1
     * ===================================================================================================
     * Offset: 0x120  New Data Register 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |NewData161|New Data Bits 16-1 (Of All Message Objects)
     * |        |          |0 = No new data has been written into the data portion of this Message Object by the Message Handler since the last time this flag was cleared by the application software.
     * |        |          |1 = The Message Handler or the application software has written new data into the data portion of this Message Object.
    */
    __IO uint32_t   NDAT1;

    /**
     * CAN_NDAT2
     * ===================================================================================================
     * Offset: 0x124  New Data Register 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |NewData3217|New Data Bits 32-17 (Of All Message Objects)
     * |        |          |0 = No new data has been written into the data portion of this Message Object by the Message Handler since the last time this flag was cleared by the application software.
     * |        |          |1 = The Message Handler or the application software has written new data into the data portion of this Message Object.
    */
    __IO uint32_t   NDAT2;

    __I uint32_t    RESERVE3[6];

    /**
     * CAN_IPND1
     * ===================================================================================================
     * Offset: 0x140  Interrupt Pending Register 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |IntPnd161 |Interrupt Pending Bits 16-1 (Of All Message Objects)
     * |        |          |0 = This message object is not the source of an interrupt.
     * |        |          |1 = This message object is the source of an interrupt.
    */
    __IO uint32_t   IPND1;

    /**
     * CAN_IPND2
     * ===================================================================================================
     * Offset: 0x144  Interrupt Pending Register 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |IntPnd3217|Interrupt Pending Bits 32-17(Of All Message Objects)
     * |        |          |0 = This message object is not the source of an interrupt.
     * |        |          |1 = This message object is the source of an interrupt.
    */
    __IO uint32_t   IPND2;

    __I uint32_t    RESERVE4[6];

    /**
     * CAN_MVLD1
     * ===================================================================================================
     * Offset: 0x160  Message Valid Register 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |MsgVal161 |Message Valid Bits 16-1 (Of All Message Objects) (Read Only)
     * |        |          |0 = This Message Object is ignored by the Message Handler.
     * |        |          |1 = This Message Object is configured and should be considered by the Message Handler.
     * |        |          |Ex.
     * |        |          |CAN_MVLD1[0] means Message object No.1 is valid or not.
     * |        |          |If CAN_MVLD1[0] is set, message object No.1 is configured.
    */
    __IO uint32_t   MVLD1;

    /**
     * CAN_MVLD2
     * ===================================================================================================
     * Offset: 0x164  Message Valid Register 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |MsgVal3217|Message Valid Bits 32-17 (Of All Message Objects) (Read Only)
     * |        |          |0 = This Message Object is ignored by the Message Handler.
     * |        |          |1 = This Message Object is configured and should be considered by the Message Handler.
     * |        |          |Ex.CAN_MVLD2[15] means Message object No.32 is valid or not.
     * |        |          |If CAN_MVLD2[15] is set, message object No.32 is configured.
    */
    __IO uint32_t   MVLD2;

    /**
     * CAN_WU_EN
     * ===================================================================================================
     * Offset: 0x168  Wake-up Enable Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |WAKUP_EN  |Wake-Up Enable Control
     * |        |          |0 = The wake-up function Disabled.
     * |        |          |1 = The wake-up function Enabled.
     * |        |          |Note: User can wake-up system when there is a falling edge in the CAN_Rx pin.
    */
    __IO uint32_t WU_EN;

    /**
     * CAN_WU_STATUS
     * ===================================================================================================
     * Offset: 0x16C  Wake-up Status Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |WAKUP_STS |Wake-Up Status
     * |        |          |0 = No wake-up event occurred.
     * |        |          |1 = Wake-up event occurred.
     * |        |          |Note: This bit can be cleared by writing '0'.
    */
    __IO uint32_t WU_STATUS;
} CAN_T;

/**
    @addtogroup CAN_CONST CAN Bit Field Definition
    Constant Definitions for CAN Controller
@{ */

#define CAN_CON_TEST_Pos           7                                    /*!< CAN_T::CON: TEST Position */
#define CAN_CON_TEST_Msk           (1ul << CAN_CON_TEST_Pos)            /*!< CAN_T::CON: TEST Mask     */

#define CAN_CON_CCE_Pos            6                                    /*!< CAN_T::CON: CCE Position  */
#define CAN_CON_CCE_Msk            (1ul << CAN_CON_CCE_Pos)             /*!< CAN_T::CON: CCE Mask      */

#define CAN_CON_DAR_Pos            5                                    /*!< CAN_T::CON: DAR Position  */
#define CAN_CON_DAR_Msk            (1ul << CAN_CON_DAR_Pos)             /*!< CAN_T::CON: DAR Mask      */

#define CAN_CON_EIE_Pos            3                                    /*!< CAN_T::CON: EIE Position  */
#define CAN_CON_EIE_Msk            (1ul << CAN_CON_EIE_Pos)             /*!< CAN_T::CON: EIE Mask      */

#define CAN_CON_SIE_Pos            2                                    /*!< CAN_T::CON: SIE Position  */
#define CAN_CON_SIE_Msk            (1ul << CAN_CON_SIE_Pos)             /*!< CAN_T::CON: SIE Mask      */

#define CAN_CON_IE_Pos             1                                    /*!< CAN_T::CON: IE Position   */
#define CAN_CON_IE_Msk             (1ul << CAN_CON_IE_Pos)              /*!< CAN_T::CON: IE Mask       */

#define CAN_CON_INIT_Pos           0                                    /*!< CAN_T::CON: INIT Position */
#define CAN_CON_INIT_Msk           (1ul << CAN_CON_INIT_Pos)            /*!< CAN_T::CON: INIT Mask     */

#define CAN_STATUS_BOFF_Pos        7                                    /*!< CAN_T::STATUS: BOFF Position  */
#define CAN_STATUS_BOFF_Msk        (1ul << CAN_STATUS_BOFF_Pos)         /*!< CAN_T::STATUS: BOFF Mask      */

#define CAN_STATUS_EWARN_Pos       6                                    /*!< CAN_T::STATUS: EWARN Position */
#define CAN_STATUS_EWARN_Msk       (1ul << CAN_STATUS_EWARN_Pos)        /*!< CAN_T::STATUS: EWARN Mask     */

#define CAN_STATUS_EPASS_Pos       5                                    /*!< CAN_T::STATUS: EPASS Position */
#define CAN_STATUS_EPASS_Msk       (1ul << CAN_STATUS_EPASS_Pos)        /*!< CAN_T::STATUS: EPASS Mask     */

#define CAN_STATUS_RXOK_Pos        4                                    /*!< CAN_T::STATUS: RXOK Position  */
#define CAN_STATUS_RXOK_Msk        (1ul << CAN_STATUS_RXOK_Pos)         /*!< CAN_T::STATUS: RXOK Mask      */

#define CAN_STATUS_TXOK_Pos        3                                    /*!< CAN_T::STATUS: TXOK Position  */
#define CAN_STATUS_TXOK_Msk        (1ul << CAN_STATUS_TXOK_Pos)         /*!< CAN_T::STATUS: TXOK Mask      */

#define CAN_STATUS_LEC_Pos         0                                    /*!< CAN_T::STATUS: LEC Position   */
#define CAN_STATUS_LEC_Msk         (0x7ul << CAN_STATUS_LEC_Pos)        /*!< CAN_T::STATUS: LEC Mask       */

#define CAN_ERR_RP_Pos             15                                   /*!< CAN_T::ERR: RP Position       */
#define CAN_ERR_RP_Msk             (1ul << CAN_ERR_RP_Pos)              /*!< CAN_T::ERR: RP Mask           */

#define CAN_ERR_REC_Pos            8                                    /*!< CAN_T::ERR: REC Position      */
#define CAN_ERR_REC_Msk            (0x7Ful << CAN_ERR_REC_Pos)          /*!< CAN_T::ERR: REC Mask          */

#define CAN_ERR_TEC_Pos            0                                    /*!< CAN_T::ERR: TEC Position      */
#define CAN_ERR_TEC_Msk            (0xFFul << CAN_ERR_TEC_Pos)          /*!< CAN_T::ERR: TEC Mask          */

#define CAN_BTIME_TSEG2_Pos        12                                   /*!< CAN_T::BTIME: TSEG2 Position  */
#define CAN_BTIME_TSEG2_Msk        (0x7ul << CAN_BTIME_TSEG2_Pos)       /*!< CAN_T::BTIME: TSEG2 Mask      */

#define CAN_BTIME_TSEG1_Pos        8                                    /*!< CAN_T::BTIME: TSEG1 Position  */
#define CAN_BTIME_TSEG1_Msk        (0xFul << CAN_BTIME_TSEG1_Pos)       /*!< CAN_T::BTIME: TSEG1 Mask      */

#define CAN_BTIME_SJW_Pos          6                                    /*!< CAN_T::BTIME: SJW Position    */
#define CAN_BTIME_SJW_Msk          (0x3ul << CAN_BTIME_SJW_Pos)         /*!< CAN_T::BTIME: SJW Mask        */

#define CAN_BTIME_BRP_Pos          0                                    /*!< CAN_T::BTIME: BRP Position    */
#define CAN_BTIME_BRP_Msk          (0x3Ful << CAN_BTIME_BRP_Pos)        /*!< CAN_T::BTIME: BRP Mask        */

#define CAN_IIDR_INTID_Pos         0                                    /*!< CAN_T::IIDR: INTID Position   */
#define CAN_IIDR_INTID_Msk         (0xFFFFul << CAN_IIDR_INTID_Pos)     /*!< CAN_T::IIDR: INTID Mask       */

#define CAN_TEST_RX_Pos            7                                    /*!< CAN_T::TEST: RX Position      */
#define CAN_TEST_RX_Msk            (1ul << CAN_TEST_RX_Pos)             /*!< CAN_T::TEST: RX Mask          */

#define CAN_TEST_TX_Pos            5                                    /*!< CAN_T::TEST: TX Position      */
#define CAN_TEST_TX_Msk            (0x3ul << CAN_TEST_TX_Pos)           /*!< CAN_T::TEST: TX Mask          */

#define CAN_TEST_LBACK_Pos         4                                    /*!< CAN_T::TEST: LBACK Position   */
#define CAN_TEST_LBACK_Msk         (1ul << CAN_TEST_LBACK_Pos)          /*!< CAN_T::TEST: LBACK Mask       */

#define CAN_TEST_SILENT_Pos        3                                    /*!< CAN_T::TEST: Silent Position  */
#define CAN_TEST_SILENT_Msk        (1ul << CAN_TEST_SILENT_Pos)         /*!< CAN_T::TEST: Silent Mask      */

#define CAN_TEST_BASIC_Pos         2                                    /*!< CAN_T::TEST: Basic Position   */
#define CAN_TEST_BASIC_Msk         (1ul << CAN_TEST_BASIC_Pos)          /*!< CAN_T::TEST: Basic Mask       */

#define CAN_BRPE_BRPE_Pos          0                                    /*!< CAN_T::BRPE: BRPE Position    */
#define CAN_BRPE_BRPE_Msk          (0xFul << CAN_BRPE_BRPE_Pos)         /*!< CAN_T::BRPE: BRPE Mask        */

#define CAN_IF_CREQ_BUSY_Pos       15                                   /*!< CAN_IF_T::CREQ: BUSY Position */
#define CAN_IF_CREQ_BUSY_Msk       (1ul << CAN_IF_CREQ_BUSY_Pos)        /*!< CAN_IF_T::CREQ: BUSY Mask     */

#define CAN_IF_CREQ_MSGNUM_Pos     0                                    /*!< CAN_IF_T::CREQ: MSGNUM Position */
#define CAN_IF_CREQ_MSGNUM_Msk     (0x3Ful << CAN_IF_CREQ_MSGNUM_Pos)   /*!< CAN_IF_T::CREQ: MSGNUM Mask     */

#define CAN_IF_CMASK_WRRD_Pos      7                                    /*!< CAN_IF_T::CMASK: WRRD Position */
#define CAN_IF_CMASK_WRRD_Msk      (1ul << CAN_IF_CMASK_WRRD_Pos)       /*!< CAN_IF_T::CMASK: WRRD Mask     */

#define CAN_IF_CMASK_MASK_Pos      6                                    /*!< CAN_IF_T::CMASK: MASK Position */
#define CAN_IF_CMASK_MASK_Msk      (1ul << CAN_IF_CMASK_MASK_Pos)       /*!< CAN_IF_T::CMASK: MASK Mask     */

#define CAN_IF_CMASK_ARB_Pos       5                                    /*!< CAN_IF_T::CMASK: ARB Position  */
#define CAN_IF_CMASK_ARB_Msk       (1ul << CAN_IF_CMASK_ARB_Pos)        /*!< CAN_IF_T::CMASK: ARB Mask      */

#define CAN_IF_CMASK_CONTROL_Pos   4                                    /*!< CAN_IF_T::CMASK: CONTROL Position */
#define CAN_IF_CMASK_CONTROL_Msk   (1ul << CAN_IF_CMASK_CONTROL_Pos)    /*!< CAN_IF_T::CMASK: CONTROL Mask */

#define CAN_IF_CMASK_CLRINTPND_Pos 3                                    /*!< CAN_IF_T::CMASK: CLRINTPND Position */
#define CAN_IF_CMASK_CLRINTPND_Msk (1ul << CAN_IF_CMASK_CLRINTPND_Pos)  /*!< CAN_IF_T::CMASK: CLRINTPND Mask */

#define CAN_IF_CMASK_TXRQSTNEWDAT_Pos 2                                         /*!< CAN_IF_T::CMASK: TXRQSTNEWDAT Position */
#define CAN_IF_CMASK_TXRQSTNEWDAT_Msk (1ul << CAN_IF_CMASK_TXRQSTNEWDAT_Pos)    /*!< CAN_IF_T::CMASK: TXRQSTNEWDAT Mask     */

#define CAN_IF_CMASK_DATAA_Pos     1                                    /*!< CAN_IF_T::CMASK: DATAA Position */
#define CAN_IF_CMASK_DATAA_Msk     (1ul << CAN_IF_CMASK_DATAA_Pos)      /*!< CAN_IF_T::CMASK: DATAA Mask     */

#define CAN_IF_CMASK_DATAB_Pos     0                                    /*!< CAN_IF_T::CMASK: DATAB Position */
#define CAN_IF_CMASK_DATAB_Msk     (1ul << CAN_IF_CMASK_DATAB_Pos)      /*!< CAN_IF_T::CMASK: DATAB Mask     */

#define CAN_IF_MASK1_MSK_Pos       0                                    /*!< CAN_IF_T::MASK1: MSK Position   */
#define CAN_IF_MASK1_MSK_Msk       (0xFFul << CAN_IF_MASK1_MSK_Pos)     /*!< CAN_IF_T::MASK1: MSK Mask       */

#define CAN_IF_MASK2_MXTD_Pos      15                                   /*!< CAN_IF_T::MASK2: MXTD Position */
#define CAN_IF_MASK2_MXTD_Msk      (1ul << CAN_IF_MASK2_MXTD_Pos)       /*!< CAN_IF_T::MASK2: MXTD Mask     */

#define CAN_IF_MASK2_MDIR_Pos      14                                   /*!< CAN_IF_T::MASK2: MDIR Position */
#define CAN_IF_MASK2_MDIR_Msk      (1ul << CAN_IF_MASK2_MDIR_Pos)       /*!< CAN_IF_T::MASK2: MDIR Mask     */

#define CAN_IF_MASK2_MSK_Pos       0                                    /*!< CAN_IF_T::MASK2: MSK Position */
#define CAN_IF_MASK2_MSK_Msk       (0x1FFul << CAN_IF_MASK2_MSK_Pos)    /*!< CAN_IF_T::MASK2: MSK Mask     */

#define CAN_IF_ARB1_ID_Pos         0                                    /*!< CAN_IF_T::ARB1: ID Position   */
#define CAN_IF_ARB1_ID_Msk         (0xFFFFul << CAN_IF_ARB1_ID_Pos)     /*!< CAN_IF_T::ARB1: ID Mask       */

#define CAN_IF_ARB2_MSGVAL_Pos     15                                   /*!< CAN_IF_T::ARB2: MSGVAL Position */
#define CAN_IF_ARB2_MSGVAL_Msk     (1ul << CAN_IF_ARB2_MSGVAL_Pos)      /*!< CAN_IF_T::ARB2: MSGVAL Mask     */

#define CAN_IF_ARB2_XTD_Pos        14                                   /*!< CAN_IF_T::ARB2: XTD Position    */
#define CAN_IF_ARB2_XTD_Msk        (1ul << CAN_IF_ARB2_XTD_Pos)         /*!< CAN_IF_T::ARB2: XTD Mask        */

#define CAN_IF_ARB2_DIR_Pos        13                                   /*!< CAN_IF_T::ARB2: DIR Position    */
#define CAN_IF_ARB2_DIR_Msk        (1ul << CAN_IF_ARB2_DIR_Pos)         /*!< CAN_IF_T::ARB2: DIR Mask        */

#define CAN_IF_ARB2_ID_Pos         0                                    /*!< CAN_IF_T::ARB2: ID Position     */
#define CAN_IF_ARB2_ID_Msk         (0x1FFFul << CAN_IF_ARB2_ID_Pos)     /*!< CAN_IF_T::ARB2: ID Mask         */

#define CAN_IF_MCON_NEWDAT_Pos     15                                   /*!< CAN_IF_T::MCON: NEWDAT Position */
#define CAN_IF_MCON_NEWDAT_Msk     (1ul << CAN_IF_MCON_NEWDAT_Pos)      /*!< CAN_IF_T::MCON: NEWDAT Mask     */

#define CAN_IF_MCON_MSGLST_Pos     14                                   /*!< CAN_IF_T::MCON: MSGLST Position */
#define CAN_IF_MCON_MSGLST_Msk     (1ul << CAN_IF_MCON_MSGLST_Pos)      /*!< CAN_IF_T::MCON: MSGLST Mask     */

#define CAN_IF_MCON_INTPND_Pos     13                                   /*!< CAN_IF_T::MCON: INTPND Position */
#define CAN_IF_MCON_INTPND_Msk     (1ul << CAN_IF_MCON_INTPND_Pos)      /*!< CAN_IF_T::MCON: INTPND Mask     */

#define CAN_IF_MCON_UMASK_Pos      12                                   /*!< CAN_IF_T::MCON: UMASK Position  */
#define CAN_IF_MCON_UMASK_Msk      (1ul << CAN_IF_MCON_UMASK_Pos)       /*!< CAN_IF_T::MCON: UMASK Mask      */

#define CAN_IF_MCON_TXIE_Pos       11                                   /*!< CAN_IF_T::MCON: TXIE Position   */
#define CAN_IF_MCON_TXIE_Msk       (1ul << CAN_IF_MCON_TXIE_Pos)        /*!< CAN_IF_T::MCON: TXIE Mask       */

#define CAN_IF_MCON_RXIE_Pos       10                                   /*!< CAN_IF_T::MCON: RXIE Position   */
#define CAN_IF_MCON_RXIE_Msk       (1ul << CAN_IF_MCON_RXIE_Pos)        /*!< CAN_IF_T::MCON: RXIE Mask       */

#define CAN_IF_MCON_RMTEN_Pos      9                                    /*!< CAN_IF_T::MCON: RMTEN Position  */
#define CAN_IF_MCON_RMTEN_Msk      (1ul << CAN_IF_MCON_RMTEN_Pos)       /*!< CAN_IF_T::MCON: RMTEN Mask      */

#define CAN_IF_MCON_TXRQST_Pos     8                                    /*!< CAN_IF_T::MCON: TXRQST Position */
#define CAN_IF_MCON_TXRQST_Msk     (1ul << CAN_IF_MCON_TXRQST_Pos)      /*!< CAN_IF_T::MCON: TXRQST Mask     */

#define CAN_IF_MCON_EOB_Pos        7                                    /*!< CAN_IF_T::MCON: EOB Position    */
#define CAN_IF_MCON_EOB_Msk        (1ul << CAN_IF_MCON_EOB_Pos)         /*!< CAN_IF_T::MCON: EOB Mask        */

#define CAN_IF_MCON_DLC_Pos        0                                    /*!< CAN_IF_T::MCON: DLC Position    */
#define CAN_IF_MCON_DLC_Msk        (0xFul << CAN_IF_MCON_DLC_Pos)       /*!< CAN_IF_T::MCON: DLC Mask        */

#define CAN_IF_DAT_A1_DATA1_Pos    8                                    /*!< CAN_IF_T::DAT_A1: DATA1 Position */
#define CAN_IF_DAT_A1_DATA1_Msk    (0xFFul << CAN_IF_DAT_A1_DATA1_Pos)  /*!< CAN_IF_T::DAT_A1: DATA1 Mask     */

#define CAN_IF_DAT_A1_DATA0_Pos    0                                    /*!< CAN_IF_T::DAT_A1: DATA0 Position */
#define CAN_IF_DAT_A1_DATA0_Msk    (0xFFul << CAN_IF_DAT_A1_DATA0_Pos)  /*!< CAN_IF_T::DAT_A1: DATA0 Mask     */

#define CAN_IF_DAT_A2_DATA3_Pos    8                                    /*!< CAN_IF_T::DAT_A2: DATA3 Position */
#define CAN_IF_DAT_A2_DATA3_Msk    (0xFFul << CAN_IF_DAT_A2_DATA3_Pos)  /*!< CAN_IF_T::DAT_A2: DATA3 Mask     */

#define CAN_IF_DAT_A2_DATA2_Pos    0                                    /*!< CAN_IF_T::DAT_A2: DATA2 Position */
#define CAN_IF_DAT_A2_DATA2_Msk    (0xFFul << CAN_IF_DAT_A2_DATA2_Pos)  /*!< CAN_IF_T::DAT_A2: DATA2 Mask     */

#define CAN_IF_DAT_B1_DATA5_Pos    8                                    /*!< CAN_IF_T::DAT_B1: DATA5 Position */
#define CAN_IF_DAT_B1_DATA5_Msk    (0xFFul << CAN_IF_DAT_B1_DATA5_Pos)  /*!< CAN_IF_T::DAT_B1: DATA5 Mask */

#define CAN_IF_DAT_B1_DATA4_Pos    0                                    /*!< CAN_IF_T::DAT_B1: DATA4 Position */
#define CAN_IF_DAT_B1_DATA4_Msk    (0xFFul << CAN_IF_DAT_B1_DATA4_Pos)  /*!< CAN_IF_T::DAT_B1: DATA4 Mask */

#define CAN_IF_DAT_B2_DATA7_Pos    8                                    /*!< CAN_IF_T::DAT_B2: DATA7 Position */
#define CAN_IF_DAT_B2_DATA7_Msk    (0xFFul << CAN_IF_DAT_B2_DATA7_Pos)  /*!< CAN_IF_T::DAT_B2: DATA7 Mask     */

#define CAN_IF_DAT_B2_DATA6_Pos    0                                    /*!< CAN_IF_T::DAT_B2: DATA6 Position */
#define CAN_IF_DAT_B2_DATA6_Msk    (0xFFul << CAN_IF_DAT_B2_DATA6_Pos)  /*!< CAN_IF_T::DAT_B2: DATA6 Mask     */

#define CAN_IF_TXRQST1_TXRQST_Pos  0                                        /*!< CAN_T::TXRQST1: TXRQST Position */
#define CAN_IF_TXRQST1_TXRQST_Msk  (0xFFFFul << CAN_IF_TXRQST1_TXRQST_Pos)  /*!< CAN_T::TXRQST1: TXRQST Mask     */

#define CAN_IF_TXRQST2_TXRQST_Pos  0                                        /*!< CAN_T::TXRQST2: TXRQST Position  */
#define CAN_IF_TXRQST2_TXRQST_Msk  (0xFFFFul << CAN_IF_TXRQST2_TXRQST_Pos)  /*!< CAN_T::TXRQST2: TXRQST Mask      */

#define CAN_IF_NDAT1_NEWDATA_Pos   0                                        /*!< CAN_T::NDAT1: NEWDATA Position */
#define CAN_IF_NDAT1_NEWDATA_Msk   (0xFFFFul << CAN_IF_NDAT1_NEWDATA_Pos)   /*!< CAN_T::NDAT1: NEWDATA Mask     */

#define CAN_IF_NDAT2_NEWDATA_Pos   0                                        /*!< CAN_T::NDAT2: NEWDATA Position */
#define CAN_IF_NDAT2_NEWDATA_Msk   (0xFFFFul << CAN_IF_NDAT2_NEWDATA_Pos)   /*!< CAN_T::NDAT2: NEWDATA Mask     */

#define CAN_IF_IPND1_INTPND_Pos   0                                         /*!< CAN_T::IPND1: INTPND Position */
#define CAN_IF_IPND1_INTPND_Msk   (0xFFFFul << CAN_IF_IPND1_INTPND_Pos)     /*!< CAN_T::IPND1: INTPND Mask     */

#define CAN_IF_IPND2_INTPND_Pos   0                                         /*!< CAN_T::IPND2: INTPND Position */
#define CAN_IF_IPND2_INTPND_Msk   (0xFFFFul << CAN_IF_IPND2_INTPND_Pos)     /*!< CAN_T::IPND2: INTPND Mask     */

#define CAN_IF_MVLD1_MSGVAL_Pos   0                                         /*!< CAN_T::MVLD1: MSGVAL Position */
#define CAN_IF_MVLD1_MSGVAL_Msk   (0xFFFFul << CAN_IF_MVLD1_MSGVAL_Pos)     /*!< CAN_T::MVLD1: MSGVAL Mask     */

#define CAN_IF_MVLD2_MSGVAL_Pos   0                                         /*!< CAN_T::MVLD2: MSGVAL Position */
#define CAN_IF_MVLD2_MSGVAL_Msk   (0xFFFFul << CAN_IF_MVLD2_MSGVAL_Pos)     /*!< CAN_T::MVLD2: MSGVAL Mask     */

#define CAN_WUEN_WAKUP_EN_Pos     0                                         /*!< CAN_T::WU_EN: WAKUP_EN Position */
#define CAN_WUEN_WAKUP_EN_Msk    (1ul << CAN_WUEN_WAKUP_EN_Pos)             /*!< CAN_T::WU_EN: WAKUP_EN Mask     */

#define CAN_WUSTATUS_WAKUP_STS_Pos     0                                    /*!< CAN_T::WU_STATUS: WAKUP_STS Position */
#define CAN_WUSTATUS_WAKUP_STS_Msk    (1ul << CAN_WUSTATUS_WAKUP_STS_Pos)   /*!< CAN_T::WU_STATUS: WAKUP_STS Mask     */

/**@}*/ /* CAN_CONST */
/**@}*/ /* end of CAN register group */


/*---------------------- Capture Engine -------------------------*/
/**
    @addtogroup CAP Capture Engine(CAP)
    Memory Mapped Structure for CAP Controller
@{ */

typedef struct {


    /**
     * CTL
     * ===================================================================================================
     * Offset: 0x00  Image Capture Interface Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |CAPEN     |Image Capture Interface Enable
     * |        |          |0 = Image Capture Interface Disabled.
     * |        |          |1 = Image Capture Interface Enabled.
     * |[3]     |ADDRSW    |Packet Buffer Address Switch
     * |        |          |0 = Packet buffer address switch Disabled.
     * |        |          |1 = Packet buffer address switch Enabled.
     * |[5]     |PLNEN     |Planar Output Enable
     * |        |          |0 = Planar output Disabled.
     * |        |          |1 = Planar output Enabled.
     * |[6]     |PKTEN     |Packet Output Enable
     * |        |          |0 = Packet output Disabled.
     * |        |          |1 = Packet output Enabled.
     * |[16]    |SHUTTER   |Image Capture Interface Automatically Disable The Capture Interface After A Frame Had Been Captured
     * |        |          |0 = Shutter Disabled.
     * |        |          |1 = Shutter Enabled.
     * |[20]    |UPDATE    |Update Register At New Frame
     * |        |          |0 = Update register at new frame Disabled.
     * |        |          |1 = Update register at new frame Enabled (Auto clear to 0 when register updated).
     * |[24]    |VPRST     |Capture Interface Reset
     * |        |          |0 = Capture interface reset Disabled.
     * |        |          |1 = Capture interface reset Enabled.
    */
    __IO uint32_t CTL;

    /**
     * PAR
     * ===================================================================================================
     * Offset: 0x04  Image Capture Interface Parameter Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |INFMT     |Sensor Input Data Format
     * |        |          |0 = YCbCr422.
     * |        |          |1 = RGB565.
     * |[1]     |SENTYPE   |Sensor Input Type
     * |        |          |0 = CCIR601.
     * |        |          |1 = CCIR656, VSync & Hsync embedded in the data signal.
     * |[2:3]   |INDATORD  |Sensor Input Data Order
     * |        |          |If INFMT = 0 (YCbCr),.
     * |        |          | Byte 0 1 2 3
     * |        |          |00 = Y0 U0 Y1 V0.
     * |        |          |01 = Y0 V0 Y1 U0.
     * |        |          |10 = U0 Y0 V0 Y1.
     * |        |          |11 = V0 Y0 U0 Y1.
     * |        |          |If INFMT = 1 (RGB565),.
     * |        |          |00 = Byte0[R[4:0] G[5:3]] Byte1[G[2:0] B[4:0]]
     * |        |          |01 = Byte0[B[4:0] G[5:3]] Byte1[G[2:0] R[4:0]]
     * |        |          |10 = Byte0[G[2:0] B[4:0]] Byte1[R[4:0] G[5:3]]
     * |        |          |11 = Byte0[G[2:0] R[4:0]] Byte1[B[4:0] G[5:3]]
     * |[4:5]   |OUTFMT    |Image Data Format Output To System Memory
     * |        |          |00 = YCbCr422.
     * |        |          |01 = Only output Y.
     * |        |          |10 = RGB555.
     * |        |          |11 = RGB565.
     * |[6]     |RANGE     |Scale Input YUV CCIR601 Color Range To Full Range
     * |        |          |0 = default.
     * |        |          |1 = Scale to full range.
     * |[7]     |PLNFMT    |Planar Output YUV Format
     * |        |          |0 = YUV422.
     * |        |          |1 = YUV420.
     * |[8]     |PCLKP     |Sensor Pixel Clock Polarity
     * |        |          |0 = Input video data and signals are latched by falling edge of Pixel Clock.
     * |        |          |1 = Input video data and signals are latched by rising edge of Pixel Clock.
     * |[9]     |HSP       |Sensor Hsync Polarity
     * |        |          |0 = Sync Low.
     * |        |          |1 = Sync High.
     * |[10]    |VSP       |Sensor Vsync Polarity
     * |        |          |0 = Sync Low.
     * |        |          |1 = Sync High.
     * |[11:12] |COLORCTL  |Special COLORCTL Processing
     * |        |          |00 = Normal Color.
     * |        |          |01 = Sepia effect, corresponding U,V component value is set at register CAP_SEPIA.
     * |        |          |10 = Negative picture.
     * |        |          |11 = Posterize image, the Y, U, V components posterizing factor are set at register CAP_POSTERIZE.
     * |[18]    |FBB       |Field By Blank
     * |        |          |Hardware will tag field0 or field1 by vertical blanking instead of FIELD flag in CCIR-656 mode.
     * |        |          |0 = Field by blank Disabled.
     * |        |          |1 = Field by blank Enabled.
    */
    __IO uint32_t PAR;

    /**
     * INT
     * ===================================================================================================
     * Offset: 0x08  Image Capture Interface Interrupt Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |VINTF     |Video Frame End Interrupt
     * |        |          |If this bit shows 1, receiving a frame completed.
     * |        |          |Write 1 to clear it.
     * |[1]     |MEINTF    |Bus Master Transfer Error Interrupt
     * |        |          |If this bit shows 1, Transfer Error occurred. Write 1 to clear it.
     * |[3]     |ADDRMINTF |Memory Address Match Interrupt
     * |        |          |If this bit shows 1, Memory Address Match Interrupt occurred.
     * |        |          |Write 1 to clear it.
     * |[4]     |MDINTF    |Motion Detection Output Finish Interrupt
     * |        |          |If this bit shows 1, Motion Detection Output Finish Interrupt occurred.
     * |        |          |Write 1 to clear it.
     * |[16]    |VIEN      |Video Frame End Interrupt Enable
     * |        |          |0 = Video frame end interrupt Disabled.
     * |        |          |1 = Video frame end interrupt Enabled.
     * |[17]    |MEIEN     |System Memory Error Interrupt Enable
     * |        |          |0 = System memory error interrupt Disabled.
     * |        |          |1 = System memory error interrupt Enabled.
     * |[19]    |ADDRMIEN  |Address Match Interrupt Enable
     * |        |          |0 = Address match interrupt Disabled.
     * |        |          |1 = Address match interrupt Enabled.
     * |[20]    |MDIEN     |Motion Detection Output Finish Interrupt Enable
     * |        |          |0 = CAP_MD finish interrupt Disabled.
     * |        |          |1 = CAP_MD finish interrupt Enabled.
    */
    __IO uint32_t INT;

    /**
     * POSTERIZE
     * ===================================================================================================
     * Offset: 0x0C  YUV Component Posterizing Factor Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |VCOMP     |V Component Posterizing Factor
     * |        |          |Final_V_Out = Original_V[7:0] & V_Posterizing_Factor.
     * |[8:15]  |UCOMP     |U Component Posterizing Factor
     * |        |          |Final_U_Out = Original_U[7:0] & U_Posterizing_Factor.
     * |[16:23] |YCOMP     |Y Component Posterizing Factor
     * |        |          |Final_Y_Out = Original_Y[7:0] & Y_Posterizing_Factor.
    */
    __IO uint32_t POSTERIZE;

    /**
     * MD
     * ===================================================================================================
     * Offset: 0x10  Motion Detection Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |MDEN      |Motion Detection Enable
     * |        |          |0 = CAP_MD Disabled.
     * |        |          |1 = CAP_MD Enabled.
     * |[8]     |MDBS      |Motion Detection Block Size
     * |        |          |0 = 16x16.
     * |        |          |1 = 8x8.
     * |[9]     |MDSM      |Motion Detection Save Mode
     * |        |          |0 = 1 bit DIFF + 7 bit Y Differential.
     * |        |          |1 = 1 bit DIFF only.
     * |[10:11] |MDDF      |Motion Detection Detect Frequency
     * |        |          |00 = Each frame.
     * |        |          |01 = Every 2 frame.
     * |        |          |10 = Every 3 frame.
     * |        |          |11 = Every 4 frame.
     * |[16:20] |MDTHR     |Motion Detection Differential Threshold
    */
    __IO uint32_t MD;

    /**
     * MDADDR
     * ===================================================================================================
     * Offset: 0x14  Motion Detection Output Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |MDADDR    |Motion Detection Output Address Register (Word Alignment)
    */
    __IO uint32_t MDADDR;

    /**
     * MDYADDR
     * ===================================================================================================
     * Offset: 0x18  Motion Detection Temp Y Output Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |MDYADDR   |Motion Detection Temp Y Output Address Register (Word Alignment)
    */
    __IO uint32_t MDYADDR;

    /**
     * SEPIA
     * ===================================================================================================
     * Offset: 0x1C  Sepia Effect Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |VCOMP     |Define the constant V component while Sepia color effect is turned on.
     * |[8:15]  |UCOMP     |Define the constant U component while Sepia color effect is turned on.
    */
    __IO uint32_t SEPIA;

    /**
     * CWSP
     * ===================================================================================================
     * Offset: 0x20  Cropping Window Starting Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |CWSADDRH  |Cropping Window Horizontal Starting Address
     * |[16:26] |CWSADDRV  |Cropping Window Vertical Starting Address
    */
    __IO uint32_t CWSP;

    /**
     * CWS
     * ===================================================================================================
     * Offset: 0x24  Cropping Window Size Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |CIWW      |Cropping Image Window Width
     * |[16:26] |CIWH      |Cropping Image Window Height
    */
    __IO uint32_t CWS;

    /**
     * PKTSL
     * ===================================================================================================
     * Offset: 0x28  Packet Scaling Vertical/Horizontal Factor Register (LSB)
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |PKTSHML   |Packet Scaling Horizontal Factor M (Lower 8-Bit)
     * |        |          |Specifies the lower 8-bit of denominator part (M) of the horizontal scaling factor.
     * |        |          |The lower 8-bit will be cascaded with higher 8-bit (PKDSHMH) to form a 16-bit denominator (M) of vertical factor.
     * |        |          |The output image width will be equal to the image width * N/M.
     * |        |          |Note: The value of N must be equal to or less than M.
     * |[8:15]  |PKTSHNL   |Packet Scaling Horizontal Factor N (Lower 8-Bit)
     * |        |          |Specify the lower 8-bit of numerator part (N) of the horizontal scaling factor.
     * |        |          |The lower 8-bit will be cascaded with higher 8-bit (PKDSHNH) to form a 16-bit numerator of horizontal factor.
     * |[16:23] |PKTSVML   |Packet Scaling Vertical Factor M (Lower 8-Bit)
     * |        |          |Specify the lower 8-bit of denominator part (M) of the vertical scaling factor.
     * |        |          |The lower 8-bit will be cascaded with higher 8-bit (PKDSVMH) to form a 16-bit denominator (M) of vertical factor.
     * |        |          |The output image width will be equal to the image height * N/M.
     * |        |          |Note: The value of N must be equal to or less than M.
     * |[24:31] |PKTSVNL   |Packet Scaling Vertical Factor N (Lower 8-Bit)
     * |        |          |Specify the lower 8-bit of numerator part (N) of the vertical scaling factor.
     * |        |          |The lower 8-bit will be cascaded with higher 8-bit (PKDSVNH) to form a 16-bit numerator of vertical factor
    */
    __IO uint32_t PKTSL;

    /**
     * PLNSL
     * ===================================================================================================
     * Offset: 0x2C  Planar Scaling Vertical/Horizontal Factor Register (LSB)
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |PLNSHML   |Planar Scaling Horizontal Factor M (Lower 8-Bit)
     * |        |          |Specify the lower 8-bit of denominator part (M) of the horizontal scaling factor.
     * |        |          |The lower 8-bit will be cascaded with higher 8-bit (PNDSHMH) to form a 16-bit denominator (M) of vertical factor.
     * |        |          |The output image width will be equal to the image width * N/M.
     * |        |          |Note: The value of N must be equal to or less than M.
     * |[8:15]  |PLNSHNL   |Planar Scaling Horizontal Factor N (Lower 8-Bit)
     * |        |          |Specify the lower 8-bit of numerator part (N) of the horizontal scaling factor.
     * |        |          |The lower 8-bit will be cascaded with higher 8-bit (PNDSHNH) to form a 16-bit numerator of horizontal factor.
     * |[16:23] |PLNSVML   |Planar Scaling Vertical Factor M (Lower 8-Bit)
     * |        |          |Specify the lower 8-bit of denominator part (M) of the vertical scaling factor.
     * |        |          |The lower 8-bit will be cascaded with higher 8-bit (PNDSVMH) to form a 16-bit denominator (M) of vertical factor.
     * |        |          |The output image width will be equal to the image height * N/M.
     * |        |          |Note: The value of N must be equal to or less than M.
     * |[24:31] |PLNSVNL   |Planar Scaling Vertical Factor N (Lower 8-Bit)
     * |        |          |Specify the lower 8-bit of numerator part (N) of the vertical scaling factor.
     * |        |          |The lower 8-bit will be cascaded with higher 8-bit (PNDSVNH) to form a 16-bit numerator of vertical factor.
    */
    __IO uint32_t PLNSL;

    /**
     * FRCTL
     * ===================================================================================================
     * Offset: 0x30  Scaling Frame Rate Factor Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:5]   |FRM       |Scaling Frame Rate Factor M
     * |        |          |Specify the denominator part (M) of the frame rate scaling factor.
     * |        |          |The output image frame rate will be equal to input image frame rate * (N/M).
     * |        |          |Note: The value of N must be equal to or less than M.
     * |[8:13]  |FRN       |Scaling Frame Rate Factor N
     * |        |          |Specify the denominator part (N) of the frame rate scaling factor.
    */
    __IO uint32_t FRCTL;

    /**
     * STRIDE
     * ===================================================================================================
     * Offset: 0x34  Frame Output Pixel Stride Width Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:13]  |PKTSTRIDE |Packet Frame Output Pixel Stride Width
     * |        |          |The output pixel stride size of packet pipe.
     * |[16:29] |PLNSTRIDE |Planar Frame Output Pixel Stride Width
     * |        |          |The output pixel stride size of planar pipe.
    */
    __IO uint32_t STRIDE;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE0[1];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * FIFOTH
     * ===================================================================================================
     * Offset: 0x3C  FIFO Threshold Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |PLNVFTH   |Planar V FIFO Threshold
     * |[8:11]  |PLNUFTH   |Planar U FIFO Threshold
     * |[16:20] |PLNYFTH   |Planar Y FIFO Threshold
     * |[24:28] |PKTFTH    |Packet FIFO Threshold
     * |[31]    |OVF       |FIFO Overflow Flag
    */
    __IO uint32_t FIFOTH;

    /**
     * CMPADDR
     * ===================================================================================================
     * Offset: 0x40  Compare Memory Base Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CMPADDR   |Compare Memory Base Address
     * |        |          |Word aligns address; ignore the bits [1:0].
    */
    __IO uint32_t CMPADDR;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE1[1];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * PKTSM
     * ===================================================================================================
     * Offset: 0x48  Packet Scaling Vertical/Horizontal Factor Register (MSB)
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |PKTSHMH   |Packet Scaling Horizontal Factor M (Higher 8-Bit)
     * |        |          |Specify the lower 8-bit of denominator part (M) of the horizontal scaling factor.
     * |        |          |Please refer to the register CAP_PKTSL?for the detailed operation.
     * |[8:15]  |PKTSHNH   |Packet Scaling Horizontal Factor N (Higher 8-Bit)
     * |        |          |Specify the lower 8-bit of numerator part (N) of the horizontal scaling factor.
     * |        |          |Please refer to the register CAP_PKTSL for the detailed operation.
     * |[16:23] |PKTSVMH   |Packet Scaling Vertical Factor M (Higher 8-Bit)
     * |        |          |Specify the lower 8-bit of denominator part (M) of the vertical scaling factor.
     * |        |          |Please refer to the register CAP_PKTSL to check the cooperation between these two registers.
     * |[24:31] |PKTSVNH   |Packet Scaling Vertical Factor N (Higher 8-Bit)
     * |        |          |Specify the higher 8-bit of numerator part (N) of the vertical scaling factor.
     * |        |          |Please refer to the register CAP_PKTSL?to check the cooperation between these two registers.
    */
    __IO uint32_t PKTSM;

    /**
     * PLNSM
     * ===================================================================================================
     * Offset: 0x4C  Planar Scaling Vertical/Horizontal Factor Register (MSB)
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |PLNSHMH   |Planar Scaling Horizontal Factor M (Higher 8-Bit)
     * |        |          |Specifies the higher 8-bit of denominator part (M) of the horizontal scaling factor
     * |        |          |For detailed programming, please refer to the register CAP_PLNSL?
     * |[8:15]  |PLNSHNH   |Planar Scaling Horizontal Factor N (Higher 8-Bit)
     * |        |          |Specifies the higher 8-bit of numerator part (N) of the horizontal scaling factor.
     * |        |          |For detailed programming, please refer to the register CAP_PLNSL?
     * |[16:23] |PLNSVMH   |Planar Scaling Vertical Factor M (Higher 8-Bit)
     * |        |          |Specifies the lower 8-bit of denominator part (M) of the vertical scaling factor.
     * |        |          |For detailed programming, please refer to the register CAP_PLNSL?
     * |[24:31] |PLNSVNH   |Planar Scaling Vertical Factor N (Higher 8-Bit)
     * |        |          |Specifies the higher 8-bit of numerator part (N) of the vertical scaling factor.
     * |        |          |For detailed programming, please refer to the register CAP_PLNSL?
    */
    __IO uint32_t PLNSM;

    /**
     * CURADDRP
     * ===================================================================================================
     * Offset: 0x50  Current Packet System Memory Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CURADDR   |Current Packet Output Memory Address
    */
    __I  uint32_t CURADDRP;

    /**
     * CURADDRY
     * ===================================================================================================
     * Offset: 0x54  Current Planar Y System Memory Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CURADDR   |Current Planar Y Output Memory Address
    */
    __I  uint32_t CURADDRY;

    /**
     * CURADDRU
     * ===================================================================================================
     * Offset: 0x58  Current Planar U System Memory Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CURADDR   |Current Planar U Output Memory Address
    */
    __I  uint32_t CURADDRU;

    /**
     * CURVADDR
     * ===================================================================================================
     * Offset: 0x5C  Current Planar V System Memory Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CURADDR   |Current Planar V Output Memory Address
    */
    __I  uint32_t CURVADDR;

    /**
     * PKTBA0
     * ===================================================================================================
     * Offset: 0x60  System Memory Packet Base Address 0 Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |BASEADDR  |System Memory Packet Base Address 0
     * |        |          |Word aligns address; ignore the bits [1:0].
    */
    __IO uint32_t PKTBA0;

    /**
     * PKTBA1
     * ===================================================================================================
     * Offset: 0x64  System Memory Packet Base Address 1 Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |BASEADDR  |System Memory Packet Base Address 1
     * |        |          |Word aligns address; ignore the bits [1:0].
    */
    __IO uint32_t PKTBA1;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE2[6];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * YBA
     * ===================================================================================================
     * Offset: 0x80  System Memory Planar Y Base Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |BASEADDR  |System Memory Planar Y Base Address
     * |        |          |Word aligns address; ignore the bits [1:0].
    */
    __IO uint32_t YBA;

    /**
     * UBA
     * ===================================================================================================
     * Offset: 0x84  System Memory Planar U Base Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |BASEADDR  |System Memory Planar U Base Address
     * |        |          |Word aligns address; ignore the bits [1:0].
    */
    __IO uint32_t UBA;

    /**
     * VBA
     * ===================================================================================================
     * Offset: 0x88  System Memory Planar V Base Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |BASEADDR  |System Memory Planar V Base Address
     * |        |          |Word aligns address; ignore the bits [1:0].
    */
    __IO uint32_t VBA;

} CAP_T;

/**
    @addtogroup CAP_CONST CAP Bit Field Definition
    Constant Definitions for CAP Controller
@{ */

#define CAP_CTL_CAPEN_Pos                (0)                                               /*!< CAP_T::CTL: CAPEN Position                */
#define CAP_CTL_CAPEN_Msk                (0x1ul << CAP_CTL_CAPEN_Pos)                      /*!< CAP_T::CTL: CAPEN Mask                    */

#define CAP_CTL_ADDRSW_Pos               (3)                                               /*!< CAP_T::CTL: ADDRSW Position               */
#define CAP_CTL_ADDRSW_Msk               (0x1ul << CAP_CTL_ADDRSW_Pos)                     /*!< CAP_T::CTL: ADDRSW Mask                   */

#define CAP_CTL_PLNEN_Pos                (5)                                               /*!< CAP_T::CTL: PLNEN Position                */
#define CAP_CTL_PLNEN_Msk                (0x1ul << CAP_CTL_PLNEN_Pos)                      /*!< CAP_T::CTL: PLNEN Mask                    */

#define CAP_CTL_PKTEN_Pos                (6)                                               /*!< CAP_T::CTL: PKTEN Position                */
#define CAP_CTL_PKTEN_Msk                (0x1ul << CAP_CTL_PKTEN_Pos)                      /*!< CAP_T::CTL: PKTEN Mask                    */

#define CAP_CTL_SHUTTER_Pos              (16)                                              /*!< CAP_T::CTL: SHUTTER Position              */
#define CAP_CTL_SHUTTER_Msk              (0x1ul << CAP_CTL_SHUTTER_Pos)                    /*!< CAP_T::CTL: SHUTTER Mask                  */

#define CAP_CTL_UPDATE_Pos               (20)                                              /*!< CAP_T::CTL: UPDATE Position               */
#define CAP_CTL_UPDATE_Msk               (0x1ul << CAP_CTL_UPDATE_Pos)                     /*!< CAP_T::CTL: UPDATE Mask                   */

#define CAP_CTL_VPRST_Pos                (24)                                              /*!< CAP_T::CTL: VPRST Position                */
#define CAP_CTL_VPRST_Msk                (0x1ul << CAP_CTL_VPRST_Pos)                      /*!< CAP_T::CTL: VPRST Mask                    */

#define CAP_PAR_INFMT_Pos                (0)                                               /*!< CAP_T::PAR: INFMT Position                */
#define CAP_PAR_INFMT_Msk                (0x1ul << CAP_PAR_INFMT_Pos)                      /*!< CAP_T::PAR: INFMT Mask                    */

#define CAP_PAR_SENTYPE_Pos              (1)                                               /*!< CAP_T::PAR: SENTYPE Position              */
#define CAP_PAR_SENTYPE_Msk              (0x1ul << CAP_PAR_SENTYPE_Pos)                    /*!< CAP_T::PAR: SENTYPE Mask                  */

#define CAP_PAR_INDATORD_Pos             (2)                                               /*!< CAP_T::PAR: INDATORD Position             */
#define CAP_PAR_INDATORD_Msk             (0x3ul << CAP_PAR_INDATORD_Pos)                   /*!< CAP_T::PAR: INDATORD Mask                 */

#define CAP_PAR_OUTFMT_Pos               (4)                                               /*!< CAP_T::PAR: OUTFMT Position               */
#define CAP_PAR_OUTFMT_Msk               (0x3ul << CAP_PAR_OUTFMT_Pos)                     /*!< CAP_T::PAR: OUTFMT Mask                   */

#define CAP_PAR_RANGE_Pos                (6)                                               /*!< CAP_T::PAR: RANGE Position                */
#define CAP_PAR_RANGE_Msk                (0x1ul << CAP_PAR_RANGE_Pos)                      /*!< CAP_T::PAR: RANGE Mask                    */

#define CAP_PAR_PLNFMT_Pos               (7)                                               /*!< CAP_T::PAR: PLNFMT Position               */
#define CAP_PAR_PLNFMT_Msk               (0x1ul << CAP_PAR_PLNFMT_Pos)                     /*!< CAP_T::PAR: PLNFMT Mask                   */

#define CAP_PAR_PCLKP_Pos                (8)                                               /*!< CAP_T::PAR: PCLKP Position                */
#define CAP_PAR_PCLKP_Msk                (0x1ul << CAP_PAR_PCLKP_Pos)                      /*!< CAP_T::PAR: PCLKP Mask                    */

#define CAP_PAR_HSP_Pos                  (9)                                               /*!< CAP_T::PAR: HSP Position                  */
#define CAP_PAR_HSP_Msk                  (0x1ul << CAP_PAR_HSP_Pos)                        /*!< CAP_T::PAR: HSP Mask                      */

#define CAP_PAR_VSP_Pos                  (10)                                              /*!< CAP_T::PAR: VSP Position                  */
#define CAP_PAR_VSP_Msk                  (0x1ul << CAP_PAR_VSP_Pos)                        /*!< CAP_T::PAR: VSP Mask                      */

#define CAP_PAR_COLORCTL_Pos             (11)                                              /*!< CAP_T::PAR: COLORCTL Position             */
#define CAP_PAR_COLORCTL_Msk             (0x3ul << CAP_PAR_COLORCTL_Pos)                   /*!< CAP_T::PAR: COLORCTL Mask                 */

#define CAP_PAR_FBB_Pos                  (18)                                              /*!< CAP_T::PAR: FBB Position                  */
#define CAP_PAR_FBB_Msk                  (0x1ul << CAP_PAR_FBB_Pos)                        /*!< CAP_T::PAR: FBB Mask                      */

#define CAP_INT_VINTF_Pos                (0)                                               /*!< CAP_T::INT: VINTF Position                */
#define CAP_INT_VINTF_Msk                (0x1ul << CAP_INT_VINTF_Pos)                      /*!< CAP_T::INT: VINTF Mask                    */

#define CAP_INT_MEINTF_Pos               (1)                                               /*!< CAP_T::INT: MEINTF Position               */
#define CAP_INT_MEINTF_Msk               (0x1ul << CAP_INT_MEINTF_Pos)                     /*!< CAP_T::INT: MEINTF Mask                   */

#define CAP_INT_ADDRMINTF_Pos            (3)                                               /*!< CAP_T::INT: ADDRMINTF Position            */
#define CAP_INT_ADDRMINTF_Msk            (0x1ul << CAP_INT_ADDRMINTF_Pos)                  /*!< CAP_T::INT: ADDRMINTF Mask                */

#define CAP_INT_MDINTF_Pos               (4)                                               /*!< CAP_T::INT: MDINTF Position               */
#define CAP_INT_MDINTF_Msk               (0x1ul << CAP_INT_MDINTF_Pos)                     /*!< CAP_T::INT: MDINTF Mask                   */

#define CAP_INT_VIEN_Pos                 (16)                                              /*!< CAP_T::INT: VIEN Position                 */
#define CAP_INT_VIEN_Msk                 (0x1ul << CAP_INT_VIEN_Pos)                       /*!< CAP_T::INT: VIEN Mask                     */

#define CAP_INT_MEIEN_Pos                (17)                                              /*!< CAP_T::INT: MEIEN Position                */
#define CAP_INT_MEIEN_Msk                (0x1ul << CAP_INT_MEIEN_Pos)                      /*!< CAP_T::INT: MEIEN Mask                    */

#define CAP_INT_ADDRMIEN_Pos             (19)                                              /*!< CAP_T::INT: ADDRMIEN Position             */
#define CAP_INT_ADDRMIEN_Msk             (0x1ul << CAP_INT_ADDRMIEN_Pos)                   /*!< CAP_T::INT: ADDRMIEN Mask                 */

#define CAP_INT_MDIEN_Pos                (20)                                              /*!< CAP_T::INT: MDIEN Position                */
#define CAP_INT_MDIEN_Msk                (0x1ul << CAP_INT_MDIEN_Pos)                      /*!< CAP_T::INT: MDIEN Mask                    */

#define CAP_POSTERIZE_VCOMP_Pos          (0)                                               /*!< CAP_T::POSTERIZE: VCOMP Position          */
#define CAP_POSTERIZE_VCOMP_Msk          (0xfful << CAP_POSTERIZE_VCOMP_Pos)               /*!< CAP_T::POSTERIZE: VCOMP Mask              */

#define CAP_POSTERIZE_UCOMP_Pos          (8)                                               /*!< CAP_T::POSTERIZE: UCOMP Position          */
#define CAP_POSTERIZE_UCOMP_Msk          (0xfful << CAP_POSTERIZE_UCOMP_Pos)               /*!< CAP_T::POSTERIZE: UCOMP Mask              */

#define CAP_POSTERIZE_YCOMP_Pos          (16)                                              /*!< CAP_T::POSTERIZE: YCOMP Position          */
#define CAP_POSTERIZE_YCOMP_Msk          (0xfful << CAP_POSTERIZE_YCOMP_Pos)               /*!< CAP_T::POSTERIZE: YCOMP Mask              */

#define CAP_MD_MDEN_Pos                  (0)                                               /*!< CAP_T::MD: MDEN Position                  */
#define CAP_MD_MDEN_Msk                  (0x1ul << CAP_MD_MDEN_Pos)                        /*!< CAP_T::MD: MDEN Mask                      */

#define CAP_MD_MDBS_Pos                  (8)                                               /*!< CAP_T::MD: MDBS Position                  */
#define CAP_MD_MDBS_Msk                  (0x1ul << CAP_MD_MDBS_Pos)                        /*!< CAP_T::MD: MDBS Mask                      */

#define CAP_MD_MDSM_Pos                  (9)                                               /*!< CAP_T::MD: MDSM Position                  */
#define CAP_MD_MDSM_Msk                  (0x1ul << CAP_MD_MDSM_Pos)                        /*!< CAP_T::MD: MDSM Mask                      */

#define CAP_MD_MDDF_Pos                  (10)                                              /*!< CAP_T::MD: MDDF Position                  */
#define CAP_MD_MDDF_Msk                  (0x3ul << CAP_MD_MDDF_Pos)                        /*!< CAP_T::MD: MDDF Mask                      */

#define CAP_MD_MDTHR_Pos                 (16)                                              /*!< CAP_T::MD: MDTHR Position                 */
#define CAP_MD_MDTHR_Msk                 (0x1ful << CAP_MD_MDTHR_Pos)                      /*!< CAP_T::MD: MDTHR Mask                     */

#define CAP_MDADDR_MDADDR_Pos            (0)                                               /*!< CAP_T::MDADDR: MDADDR Position            */
#define CAP_MDADDR_MDADDR_Msk            (0xfffffffful << CAP_MDADDR_MDADDR_Pos)           /*!< CAP_T::MDADDR: MDADDR Mask                */

#define CAP_MDYADDR_MDYADDR_Pos          (0)                                               /*!< CAP_T::MDYADDR: MDYADDR Position          */
#define CAP_MDYADDR_MDYADDR_Msk          (0xfffffffful << CAP_MDYADDR_MDYADDR_Pos)         /*!< CAP_T::MDYADDR: MDYADDR Mask              */

#define CAP_SEPIA_VCOMP_Pos              (0)                                               /*!< CAP_T::SEPIA: VCOMP Position              */
#define CAP_SEPIA_VCOMP_Msk              (0xfful << CAP_SEPIA_VCOMP_Pos)                   /*!< CAP_T::SEPIA: VCOMP Mask                  */

#define CAP_SEPIA_UCOMP_Pos              (8)                                               /*!< CAP_T::SEPIA: UCOMP Position              */
#define CAP_SEPIA_UCOMP_Msk              (0xfful << CAP_SEPIA_UCOMP_Pos)                   /*!< CAP_T::SEPIA: UCOMP Mask                  */

#define CAP_CWSP_CWSADDRH_Pos            (0)                                               /*!< CAP_T::CWSP: CWSADDRH Position            */
#define CAP_CWSP_CWSADDRH_Msk            (0xffful << CAP_CWSP_CWSADDRH_Pos)                /*!< CAP_T::CWSP: CWSADDRH Mask                */

#define CAP_CWSP_CWSADDRV_Pos            (16)                                              /*!< CAP_T::CWSP: CWSADDRV Position            */
#define CAP_CWSP_CWSADDRV_Msk            (0x7fful << CAP_CWSP_CWSADDRV_Pos)                /*!< CAP_T::CWSP: CWSADDRV Mask                */

#define CAP_CWS_CWW_Pos                  (0)                                               /*!< CAP_T::CWS: CWW Position                 */
#define CAP_CWS_CWW_Msk                  (0xffful << CAP_CWS_CWW_Pos)                      /*!< CAP_T::CWS: CWW Mask                     */

#define CAP_CWS_CWH_Pos                  (16)                                              /*!< CAP_T::CWS: CIWH Position                 */
#define CAP_CWS_CWH_Msk                  (0x7fful << CAP_CWS_CWH_Pos)                      /*!< CAP_T::CWS: CIWH Mask                     */

#define CAP_PKTSL_PKTSHML_Pos            (0)                                               /*!< CAP_T::PKTSL: PKTSHML Position            */
#define CAP_PKTSL_PKTSHML_Msk            (0xfful << CAP_PKTSL_PKTSHML_Pos)                 /*!< CAP_T::PKTSL: PKTSHML Mask                */

#define CAP_PKTSL_PKTSHNL_Pos            (8)                                               /*!< CAP_T::PKTSL: PKTSHNL Position            */
#define CAP_PKTSL_PKTSHNL_Msk            (0xfful << CAP_PKTSL_PKTSHNL_Pos)                 /*!< CAP_T::PKTSL: PKTSHNL Mask                */

#define CAP_PKTSL_PKTSVML_Pos            (16)                                              /*!< CAP_T::PKTSL: PKTSVML Position            */
#define CAP_PKTSL_PKTSVML_Msk            (0xfful << CAP_PKTSL_PKTSVML_Pos)                 /*!< CAP_T::PKTSL: PKTSVML Mask                */

#define CAP_PKTSL_PKTSVNL_Pos            (24)                                              /*!< CAP_T::PKTSL: PKTSVNL Position            */
#define CAP_PKTSL_PKTSVNL_Msk            (0xfful << CAP_PKTSL_PKTSVNL_Pos)                 /*!< CAP_T::PKTSL: PKTSVNL Mask                */

#define CAP_PLNSL_PLNSHML_Pos            (0)                                               /*!< CAP_T::PLNSL: PLNSHML Position            */
#define CAP_PLNSL_PLNSHML_Msk            (0xfful << CAP_PLNSL_PLNSHML_Pos)                 /*!< CAP_T::PLNSL: PLNSHML Mask                */

#define CAP_PLNSL_PLNSHNL_Pos            (8)                                               /*!< CAP_T::PLNSL: PLNSHNL Position            */
#define CAP_PLNSL_PLNSHNL_Msk            (0xfful << CAP_PLNSL_PLNSHNL_Pos)                 /*!< CAP_T::PLNSL: PLNSHNL Mask                */

#define CAP_PLNSL_PLNSVML_Pos            (16)                                              /*!< CAP_T::PLNSL: PLNSVML Position            */
#define CAP_PLNSL_PLNSVML_Msk            (0xfful << CAP_PLNSL_PLNSVML_Pos)                 /*!< CAP_T::PLNSL: PLNSVML Mask                */

#define CAP_PLNSL_PLNSVNL_Pos            (24)                                              /*!< CAP_T::PLNSL: PLNSVNL Position            */
#define CAP_PLNSL_PLNSVNL_Msk            (0xfful << CAP_PLNSL_PLNSVNL_Pos)                 /*!< CAP_T::PLNSL: PLNSVNL Mask                */

#define CAP_FRCTL_FRM_Pos                (0)                                               /*!< CAP_T::FRCTL: FRM Position                */
#define CAP_FRCTL_FRM_Msk                (0x3ful << CAP_FRCTL_FRM_Pos)                     /*!< CAP_T::FRCTL: FRM Mask                    */

#define CAP_FRCTL_FRN_Pos                (8)                                               /*!< CAP_T::FRCTL: FRN Position                */
#define CAP_FRCTL_FRN_Msk                (0x3ful << CAP_FRCTL_FRN_Pos)                     /*!< CAP_T::FRCTL: FRN Mask                    */

#define CAP_STRIDE_PKTSTRIDE_Pos         (0)                                               /*!< CAP_T::STRIDE: PKTSTRIDE Position         */
#define CAP_STRIDE_PKTSTRIDE_Msk         (0x3ffful << CAP_STRIDE_PKTSTRIDE_Pos)            /*!< CAP_T::STRIDE: PKTSTRIDE Mask             */

#define CAP_STRIDE_PLNSTRIDE_Pos         (16)                                              /*!< CAP_T::STRIDE: PLNSTRIDE Position         */
#define CAP_STRIDE_PLNSTRIDE_Msk         (0x3ffful << CAP_STRIDE_PLNSTRIDE_Pos)            /*!< CAP_T::STRIDE: PLNSTRIDE Mask             */

#define CAP_FIFOTH_PLNVFTH_Pos           (0)                                               /*!< CAP_T::FIFOTH: PLNVFTH Position           */
#define CAP_FIFOTH_PLNVFTH_Msk           (0xful << CAP_FIFOTH_PLNVFTH_Pos)                 /*!< CAP_T::FIFOTH: PLNVFTH Mask               */

#define CAP_FIFOTH_PLNUFTH_Pos           (8)                                               /*!< CAP_T::FIFOTH: PLNUFTH Position           */
#define CAP_FIFOTH_PLNUFTH_Msk           (0xful << CAP_FIFOTH_PLNUFTH_Pos)                 /*!< CAP_T::FIFOTH: PLNUFTH Mask               */

#define CAP_FIFOTH_PLNYFTH_Pos           (16)                                              /*!< CAP_T::FIFOTH: PLNYFTH Position           */
#define CAP_FIFOTH_PLNYFTH_Msk           (0x1ful << CAP_FIFOTH_PLNYFTH_Pos)                /*!< CAP_T::FIFOTH: PLNYFTH Mask               */

#define CAP_FIFOTH_PKTFTH_Pos            (24)                                              /*!< CAP_T::FIFOTH: PKTFTH Position            */
#define CAP_FIFOTH_PKTFTH_Msk            (0x1ful << CAP_FIFOTH_PKTFTH_Pos)                 /*!< CAP_T::FIFOTH: PKTFTH Mask                */

#define CAP_FIFOTH_OVF_Pos               (31)                                              /*!< CAP_T::FIFOTH: OVF Position               */
#define CAP_FIFOTH_OVF_Msk               (0x1ul << CAP_FIFOTH_OVF_Pos)                     /*!< CAP_T::FIFOTH: OVF Mask                   */

#define CAP_CMPADDR_CMPADDR_Pos          (0)                                               /*!< CAP_T::CMPADDR: CMPADDR Position          */
#define CAP_CMPADDR_CMPADDR_Msk          (0xfffffffful << CAP_CMPADDR_CMPADDR_Pos)         /*!< CAP_T::CMPADDR: CMPADDR Mask              */

#define CAP_PKTSM_PKTSHMH_Pos            (0)                                               /*!< CAP_T::PKTSM: PKTSHMH Position            */
#define CAP_PKTSM_PKTSHMH_Msk            (0xfful << CAP_PKTSM_PKTSHMH_Pos)                 /*!< CAP_T::PKTSM: PKTSHMH Mask                */

#define CAP_PKTSM_PKTSHNH_Pos            (8)                                               /*!< CAP_T::PKTSM: PKTSHNH Position            */
#define CAP_PKTSM_PKTSHNH_Msk            (0xfful << CAP_PKTSM_PKTSHNH_Pos)                 /*!< CAP_T::PKTSM: PKTSHNH Mask                */

#define CAP_PKTSM_PKTSVMH_Pos            (16)                                              /*!< CAP_T::PKTSM: PKTSVMH Position            */
#define CAP_PKTSM_PKTSVMH_Msk            (0xfful << CAP_PKTSM_PKTSVMH_Pos)                 /*!< CAP_T::PKTSM: PKTSVMH Mask                */

#define CAP_PKTSM_PKTSVNH_Pos            (24)                                              /*!< CAP_T::PKTSM: PKTSVNH Position            */
#define CAP_PKTSM_PKTSVNH_Msk            (0xfful << CAP_PKTSM_PKTSVNH_Pos)                 /*!< CAP_T::PKTSM: PKTSVNH Mask                */

#define CAP_PLNSM_PLNSHMH_Pos            (0)                                               /*!< CAP_T::PLNSM: PLNSHMH Position            */
#define CAP_PLNSM_PLNSHMH_Msk            (0xfful << CAP_PLNSM_PLNSHMH_Pos)                 /*!< CAP_T::PLNSM: PLNSHMH Mask                */

#define CAP_PLNSM_PLNSHNH_Pos            (8)                                               /*!< CAP_T::PLNSM: PLNSHNH Position            */
#define CAP_PLNSM_PLNSHNH_Msk            (0xfful << CAP_PLNSM_PLNSHNH_Pos)                 /*!< CAP_T::PLNSM: PLNSHNH Mask                */

#define CAP_PLNSM_PLNSVMH_Pos            (16)                                              /*!< CAP_T::PLNSM: PLNSVMH Position            */
#define CAP_PLNSM_PLNSVMH_Msk            (0xfful << CAP_PLNSM_PLNSVMH_Pos)                 /*!< CAP_T::PLNSM: PLNSVMH Mask                */

#define CAP_PLNSM_PLNSVNH_Pos            (24)                                              /*!< CAP_T::PLNSM: PLNSVNH Position            */
#define CAP_PLNSM_PLNSVNH_Msk            (0xfful << CAP_PLNSM_PLNSVNH_Pos)                 /*!< CAP_T::PLNSM: PLNSVNH Mask                */

#define CAP_CURADDRP_CURADDR_Pos         (0)                                               /*!< CAP_T::CURADDRP: CURADDR Position         */
#define CAP_CURADDRP_CURADDR_Msk         (0xfffffffful << CAP_CURADDRP_CURADDR_Pos)        /*!< CAP_T::CURADDRP: CURADDR Mask             */

#define CAP_CURADDRY_CURADDR_Pos         (0)                                               /*!< CAP_T::CURADDRY: CURADDR Position         */
#define CAP_CURADDRY_CURADDR_Msk         (0xfffffffful << CAP_CURADDRY_CURADDR_Pos)        /*!< CAP_T::CURADDRY: CURADDR Mask             */

#define CAP_CURADDRU_CURADDR_Pos         (0)                                               /*!< CAP_T::CURADDRU: CURADDR Position         */
#define CAP_CURADDRU_CURADDR_Msk         (0xfffffffful << CAP_CURADDRU_CURADDR_Pos)        /*!< CAP_T::CURADDRU: CURADDR Mask             */

#define CAP_CURVADDR_CURADDR_Pos         (0)                                               /*!< CAP_T::CURVADDR: CURADDR Position         */
#define CAP_CURVADDR_CURADDR_Msk         (0xfffffffful << CAP_CURVADDR_CURADDR_Pos)        /*!< CAP_T::CURVADDR: CURADDR Mask             */

#define CAP_PKTBA0_BASEADDR_Pos          (0)                                               /*!< CAP_T::PKTBA0: BASEADDR Position          */
#define CAP_PKTBA0_BASEADDR_Msk          (0xfffffffful << CAP_PKTBA0_BASEADDR_Pos)         /*!< CAP_T::PKTBA0: BASEADDR Mask              */

#define CAP_PKTBA1_BASEADDR_Pos          (0)                                               /*!< CAP_T::PKTBA1: BASEADDR Position          */
#define CAP_PKTBA1_BASEADDR_Msk          (0xfffffffful << CAP_PKTBA1_BASEADDR_Pos)         /*!< CAP_T::PKTBA1: BASEADDR Mask              */

#define CAP_YBA_BASEADDR_Pos             (0)                                               /*!< CAP_T::YBA: BASEADDR Position             */
#define CAP_YBA_BASEADDR_Msk             (0xfffffffful << CAP_YBA_BASEADDR_Pos)            /*!< CAP_T::YBA: BASEADDR Mask                 */

#define CAP_UBA_BASEADDR_Pos             (0)                                               /*!< CAP_T::UBA: BASEADDR Position             */
#define CAP_UBA_BASEADDR_Msk             (0xfffffffful << CAP_UBA_BASEADDR_Pos)            /*!< CAP_T::UBA: BASEADDR Mask                 */

#define CAP_VBA_BASEADDR_Pos             (0)                                               /*!< CAP_T::VBA: BASEADDR Position             */
#define CAP_VBA_BASEADDR_Msk             (0xfffffffful << CAP_VBA_BASEADDR_Pos)            /*!< CAP_T::VBA: BASEADDR Mask                 */

/**@}*/ /* CAP_CONST */
/**@}*/ /* end of CAP register group */


/*---------------------- Enhanced Input Capture Timer -------------------------*/
/**
    @addtogroup ECAP Enhanced Input Capture Timer(ECAP)
    Memory Mapped Structure for ECAP Controller
@{ */

typedef struct {


    /**
     * CNT
     * ===================================================================================================
     * Offset: 0x00  Input Capture Counter (24-bit up counter)
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:23]  |VAL       |Input Capture Timer/Counter
     * |        |          |The input Capture Timer/Counter is a 24-bit up-counting counter.
     * |        |          |The clock source for the counter is from the clock divider output which the CAP_CLK is software optionally divided by 1,4,16 or 32.
    */
    __IO uint32_t CNT;

    /**
     * HOLD0
     * ===================================================================================================
     * Offset: 0x04  Input Capture Counter Hold Register 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:23]  |VAL       |Input Capture Counter Hold Register
     * |        |          |When an active input capture channel detects a valid edge signal change, the ECAP_CNT value is latched into the corresponding holding register.
     * |        |          |Each input channel has itself holding register named by ECAP_HOLDx where x is from 0 to 2 to indicate inputs from IC0 to IC2, respectively.
    */
    __IO uint32_t HOLD0;

    /**
     * HOLD1
     * ===================================================================================================
     * Offset: 0x08  Input Capture Counter Hold Register 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:23]  |VAL       |Input Capture Counter Hold Register
     * |        |          |When an active input capture channel detects a valid edge signal change, the ECAP_CNT value is latched into the corresponding holding register.
     * |        |          |Each input channel has itself holding register named by ECAP_HOLDx where x is from 0 to 2 to indicate inputs from IC0 to IC2, respectively.
    */
    __IO uint32_t HOLD1;

    /**
     * HOLD2
     * ===================================================================================================
     * Offset: 0x0C  Input Capture Counter Hold Register 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:23]  |VAL       |Input Capture Counter Hold Register
     * |        |          |When an active input capture channel detects a valid edge signal change, the ECAP_CNT value is latched into the corresponding holding register.
     * |        |          |Each input channel has itself holding register named by ECAP_HOLDx where x is from 0 to 2 to indicate inputs from IC0 to IC2, respectively.
    */
    __IO uint32_t HOLD2;

    /**
     * CNTCMP
     * ===================================================================================================
     * Offset: 0x10  Input Capture Counter Compare Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:23]  |VAL       |Input Capture Counter Compare Register
     * |        |          |If the compare function is enabled (CMPEN = 1), the compare register is loaded with the value that the compare function compares the capture counter (ECAP_CNT) with.
     * |        |          |If the reload control is enabled (RLDEN = 1), an overflow event or capture events will trigger the hardware to reload ECAP_CNTCMP into ECAP_CNT.
    */
    __IO uint32_t CNTCMP;

    /**
     * CTL0
     * ===================================================================================================
     * Offset: 0x14  Input Capture Control Register 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:1]   |NFDIS     |Noise Filter Clock Pre-Divide Selection
     * |        |          |To determine the sampling frequency of the Noise Filter clock
     * |        |          |00 = CAP_CLK.
     * |        |          |01 = CAP_CLK/2.
     * |        |          |10 = CAP_CLK/4.
     * |        |          |11 = CAP_CLK/16.
     * |[3]     |CAPNF_DIS |Input Capture Noise Filter Disable Control
     * |        |          |0 = Noise filter of Input Capture Enabled.
     * |        |          |1 = Noise filter of Input Capture Disabled.
     * |[4]     |CAPEN0    |Port Pin IC0 Input To Input Capture Unit Enable Control
     * |        |          |0 = IC0 input to Input Capture Unit Disabled.
     * |        |          |1 = IC0 input to Input Capture Unit Enabled.
     * |[5]     |CAPEN1    |Port Pin IC1 Input To Input Capture Unit Enable Control
     * |        |          |0 = IC1 input to Input Capture Unit Disabled.
     * |        |          |1 = IC1 input to Input Capture Unit Enabled.
     * |[6]     |CAPEN2    |Port Pin IC2 Input To Input Capture Unit Enable Control
     * |        |          |0 = IC2 input to Input Capture Unit Disabled.
     * |        |          |1 = IC2 input to Input Capture Unit Enabled.
     * |[8:9]   |CAPSEL0   |CAP0 Input Source Selection
     * |        |          |00 = CAP0 input is from port pin IC0.
     * |        |          |01 = CAP0 input is from signal CPO0 (Analog comparator 0 output).
     * |        |          |10 = CAP0 input is from signal CHA of QEI controller unit x.
     * |        |          |11 = CAP0 input is from signal OPDO0 (OP0 digital output).
     * |        |          |Note: Input capture unit n matches QEI or comparator unit x, where x = 0~1.
     * |[10:11] |CAPSEL1   |CAP1 Input Source Selection
     * |        |          |00 = CAP1 input is from port pin IC1.
     * |        |          |01 = CAP1 input is from signal CPO1 (Analog comparator 1 output).
     * |        |          |10 = CAP1 input is from signal CHB of QEI controller unit x.
     * |        |          |11 = CAP1 input is from signal OPDO1 (OP1 digital output).
     * |        |          |Note: Input capture unit n matches QEI or comparator unit x, where x = 0~1.
     * |[12:13] |CAPSEL2   |CAP2 Input Source Selection
     * |        |          |00 = CAP2 input is from port pin IC2.
     * |        |          |01 = CAP2 input is from signal CPO2 (Analog comparator 2 output).
     * |        |          |10 = CAP2 input is from signal CHX of QEI controller unit x.
     * |        |          |11 = CAP2 input is from signal ADCMPOx (ADC compare output x).
     * |        |          |Note: Input capture unit n matches QEI or comparator unit x, where x = 0~1.
     * |[16]    |CAPIEN0   |Input Capture Channel 0 Interrupt Enable Control
     * |        |          |0 = The flag CAPF0 can trigger Input Capture interrupt Disabled.
     * |        |          |1 = The flag CAPF0 can trigger Input Capture interrupt Enabled.
     * |[17]    |CAPIEN1   |Input Capture Channel 1 Interrupt Enable Control
     * |        |          |0 = The flag CAPF1 can trigger Input Capture interrupt Disabled.
     * |        |          |1 = The flag CAPF1 can trigger Input Capture interrupt Enabled.
     * |[18]    |CAPIEN2   |Input Capture Channel 2 Interrupt Enable Control
     * |        |          |0 = The flag CAPF2 can trigger Input Capture interrupt Disabled.
     * |        |          |1 = The flag CAPF2 can trigger Input Capture interrupt Enabled.
     * |[20]    |OVIEN     |OVF Trigger Input Capture Interrupt Enable Control
     * |        |          |0 = The flag OVUNF can trigger Input Capture interrupt Disabled.
     * |        |          |1 = The flag OVUNF can trigger Input Capture interrupt Enabled.
     * |[21]    |CMPIEN    |CMPF Trigger Input Capture Interrupt Enable Control
     * |        |          |0 = The flag CMPF can trigger Input Capture interrupt Disabled.
     * |        |          |1 = The flag CMPF can trigger Input Capture interrupt Enabled.
     * |[24]    |CNTEN     |Input Capture Counter Start
     * |        |          |Setting this bit to 1, the capture counter (ECAP_CNT) starts up-counting synchronously with capture clock input (CAP_CLK).
     * |        |          |0 = ECAP_CNT stop counting.
     * |        |          |1 = ECAP_CNT starts up-counting.
     * |[25]    |CMPCLR    |Input Capture Counter Cleared By Compare-Match Control
     * |        |          |If this bit is set to 1, the capture counter (ECAP_CNT) will be cleared to 0 when the compare-match event (CAMCMPF = 1) occurs.
     * |        |          |0 = Compare-match event (CAMCMPF) can clear capture counter (ECAP_CNT) Disabled.
     * |        |          |1 = Compare-match event (CAMCMPF) can clear capture counter (ECAP_CNT) Enabled.
     * |[26]    |CPTCLR    |Input Capture Counter Cleared By Capture Events Control
     * |        |          |If this bit is set to 1, the capture counter (ECAP_CNT) will be cleared to zero when any one of capture events (CAPF0~3) occurs.
     * |        |          |0 = Capture events (CAPF0~3) can clear capture counter (ECAP_CNT) Disabled.
     * |        |          |1 = Capture events (CAPF0~3) can clear capture counter (ECAP_CNT) Enabled.
     * |[27]    |RLDEN     |Reload Function Enable Control
     * |        |          |Setting this bit to enable the reload function.
     * |        |          |If the reload control is enabled, an overflow event (OVF) or capture events (CAPFx) will trigger the hardware to reload ECAP_CNTCMP into ECAP_CNT.
     * |        |          |0 = The reload function Disabled.
     * |        |          |1 = The reload function Enabled.
     * |[28]    |CMPEN     |Compare Function Enable Control
     * |        |          |The compare function in input capture timer/counter is to compare the dynamic counting ECAP_CNT with the compare register ECAP_CNTCMP, if ECAP_CNT value reaches ECAP_CNTCMP, the flag CMPF will be set.
     * |        |          |0 = The compare function Disabled.
     * |        |          |1 = The compare function Enabled.
     * |[29]    |CAPEN     |Input Capture Timer/Counter Enable Control
     * |        |          |0 = Input Capture function Disabled.
     * |        |          |1 = Input Capture function Enabled.
    */
    __IO uint32_t CTL0;

    /**
     * CTL1
     * ===================================================================================================
     * Offset: 0x18  Input Capture Control Register 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:1]   |EDGESEL0  |Channel 0 Captured Edge Selection
     * |        |          |Input capture can detect falling edge change only, rising edge change only or one of both edge change
     * |        |          |00 = Detect rising edge.
     * |        |          |01 = Detect falling edge.
     * |        |          |1x = Detect either rising or falling edge.
     * |[2:3]   |EDGESEL1  |Channel 1 Captured Edge Selection
     * |        |          |Input capture can detect falling edge change only, rising edge change only or one of both edge change
     * |        |          |00 = Detect rising edge.
     * |        |          |01 = Detect falling edge.
     * |        |          |1x = Detect either rising or falling edge.
     * |[4:5]   |EDGESEL2  |Channel 2 Captured Edge Selection
     * |        |          |Input capture can detect falling edge change or rising edge change only, or one of both edge changes.
     * |        |          |00 = Detect rising edge.
     * |        |          |01 = Detect falling edge.
     * |        |          |1x = Detect either rising or falling edge.
     * |[8:10]  |RLDSEL    |ECAP_CNT Reload Trigger Source Selection
     * |        |          |If the reload function is enabled RLDEN (ECAP_CTL0[27]) = 1, when a reload trigger event comes, the ECAP_CNT is reloaded with ECAP_CNTCMP.
     * |        |          |RLDSEL[2:0] determines the ECAP_CNT reload trigger source
     * |        |          |000 = CAPF0.
     * |        |          |001 = CAPF1.
     * |        |          |010 = CAPF2.
     * |        |          |100 = OVF.
     * |        |          |Others = Reserved.
     * |[12:14] |CLKSEL    |Capture Timer Clock Divide Selection
     * |        |          |The capture timer clock has a pre-divider with four divided options controlled by CLKSEL[1:0].
     * |        |          |000 = CAP_CLK/1.
     * |        |          |001 = CAP_CLK/4.
     * |        |          |010 = CAP_CLK/16.
     * |        |          |011 = CAP_CLK/32.
     * |        |          |100 = CAP_CLK/64.
     * |        |          |101 = CAP_CLK/96.
     * |        |          |110 = CAP_CLK/112.
     * |        |          |111 = CAP_CLK/128.
     * |[16:17] |SRCSEL    |Capture Timer/Counter Clock Source Selection
     * |        |          |Select the capture timer/counter clock source.
     * |        |          |00 = CAP_CLK (default).
     * |        |          |01 = CAP0.
     * |        |          |10 = CAP1.
     * |        |          |11 = CAP2.
    */
    __IO uint32_t CTL1;

    /**
     * STATUS
     * ===================================================================================================
     * Offset: 0x1C  Input Capture Status Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |CAPF0     |Input Capture Channel 0 Captured Flag
     * |        |          |When the input capture channel 0 detects a valid edge change at CAP0 input, it will set flag CAPF0 to high.
     * |        |          |0 = No valid edge change is detected at CAP0 input.
     * |        |          |1 = A valid edge change is detected at CAP0 input.
     * |        |          |Note: This bit is only cleared by writing 1 to it.
     * |[1]     |CAPF1     |Input Capture Channel 1 Captured Flag
     * |        |          |When the input capture channel 1 detects a valid edge change at CAP1 input, it will set flag CAPF1 to high.
     * |        |          |0 = No valid edge change is detected at CAP1 input.
     * |        |          |1 = A valid edge change is detected at CAP1 input.
     * |        |          |Note: This bit is only cleared by writing 1 to it.
     * |[2]     |CAPF2     |Input Capture Channel 2 Captured Flag
     * |        |          |When the input capture channel 2 detects a valid edge change at CAP2 input, it will set flag CAPF2 to high.
     * |        |          |0 = No valid edge change is detected at CAP2 input.
     * |        |          |1 = A valid edge change is detected at CAP2 input.
     * |        |          |Note: This bit is only cleared by writing 1 to it.
     * |[4]     |CMPF      |Input Capture Compare-Match Flag
     * |        |          |If the input capture compare function is enabled, the flag is set by hardware while capture counter (ECAP_CNT) up counts and reach to the ECAP_CNTCMP value.
     * |        |          |0 = ECAP_CNT does not match with ECAP_CNTCMP value.
     * |        |          |1 = ECAP_CNT counts to the same as ECAP_CNTCMP value.
     * |        |          |Note: This bit is only cleared by writing 1 to it.
     * |[5]     |OVF       |Input Capture Counter Overflow Flag
     * |        |          |Flag is set by hardware when input capture up counter (ECAP_CNT) overflows from 0x00FF_FFFF to zero.
     * |        |          |0 = No overflow occurs in ECAP_CNT.
     * |        |          |1 = ECAP_CNT overflows.
     * |        |          |Note: This bit is only cleared by writing 1 to it.
    */
    __IO uint32_t STATUS;

} ECAP_T;

/**
    @addtogroup ECAP_CONST ECAP Bit Field Definition
    Constant Definitions for ECAP Controller
@{ */

#define ECAP_CNT_VAL_Pos                 (0)                                               /*!< ECAP_T::CNT: VAL Position                 */
#define ECAP_CNT_VAL_Msk                 (0xfffffful << ECAP_CNT_VAL_Pos)                  /*!< ECAP_T::CNT: VAL Mask                     */

#define ECAP_HOLD0_VAL_Pos               (0)                                               /*!< ECAP_T::HOLD0: VAL Position               */
#define ECAP_HOLD0_VAL_Msk               (0xfffffful << ECAP_HOLD0_VAL_Pos)                /*!< ECAP_T::HOLD0: VAL Mask                   */

#define ECAP_HOLD1_VAL_Pos               (0)                                               /*!< ECAP_T::HOLD1: VAL Position               */
#define ECAP_HOLD1_VAL_Msk               (0xfffffful << ECAP_HOLD1_VAL_Pos)                /*!< ECAP_T::HOLD1: VAL Mask                   */

#define ECAP_HOLD2_VAL_Pos               (0)                                               /*!< ECAP_T::HOLD2: VAL Position               */
#define ECAP_HOLD2_VAL_Msk               (0xfffffful << ECAP_HOLD2_VAL_Pos)                /*!< ECAP_T::HOLD2: VAL Mask                   */

#define ECAP_CNTCMP_VAL_Pos              (0)                                               /*!< ECAP_T::CNTCMP: VAL Position              */
#define ECAP_CNTCMP_VAL_Msk              (0xfffffful << ECAP_CNTCMP_VAL_Pos)               /*!< ECAP_T::CNTCMP: VAL Mask                  */

#define ECAP_CTL0_NFDIS_Pos              (0)                                               /*!< ECAP_T::CTL0: NFDIS Position              */
#define ECAP_CTL0_NFDIS_Msk              (0x3ul << ECAP_CTL0_NFDIS_Pos)                    /*!< ECAP_T::CTL0: NFDIS Mask                  */

#define ECAP_CTL0_CAPNF_DIS_Pos          (3)                                               /*!< ECAP_T::CTL0: CAPNF_DIS Position          */
#define ECAP_CTL0_CAPNF_DIS_Msk          (0x1ul << ECAP_CTL0_CAPNF_DIS_Pos)                /*!< ECAP_T::CTL0: CAPNF_DIS Mask              */

#define ECAP_CTL0_CAPEN0_Pos             (4)                                               /*!< ECAP_T::CTL0: CAPEN0 Position             */
#define ECAP_CTL0_CAPEN0_Msk             (0x1ul << ECAP_CTL0_CAPEN0_Pos)                   /*!< ECAP_T::CTL0: CAPEN0 Mask                 */

#define ECAP_CTL0_CAPEN1_Pos             (5)                                               /*!< ECAP_T::CTL0: CAPEN1 Position             */
#define ECAP_CTL0_CAPEN1_Msk             (0x1ul << ECAP_CTL0_CAPEN1_Pos)                   /*!< ECAP_T::CTL0: CAPEN1 Mask                 */

#define ECAP_CTL0_CAPEN2_Pos             (6)                                               /*!< ECAP_T::CTL0: CAPEN2 Position             */
#define ECAP_CTL0_CAPEN2_Msk             (0x1ul << ECAP_CTL0_CAPEN2_Pos)                   /*!< ECAP_T::CTL0: CAPEN2 Mask                 */

#define ECAP_CTL0_CAPSEL0_Pos            (8)                                               /*!< ECAP_T::CTL0: CAPSEL0 Position            */
#define ECAP_CTL0_CAPSEL0_Msk            (0x3ul << ECAP_CTL0_CAPSEL0_Pos)                  /*!< ECAP_T::CTL0: CAPSEL0 Mask                */

#define ECAP_CTL0_CAPSEL1_Pos            (10)                                              /*!< ECAP_T::CTL0: CAPSEL1 Position            */
#define ECAP_CTL0_CAPSEL1_Msk            (0x3ul << ECAP_CTL0_CAPSEL1_Pos)                  /*!< ECAP_T::CTL0: CAPSEL1 Mask                */

#define ECAP_CTL0_CAPSEL2_Pos            (12)                                              /*!< ECAP_T::CTL0: CAPSEL2 Position            */
#define ECAP_CTL0_CAPSEL2_Msk            (0x3ul << ECAP_CTL0_CAPSEL2_Pos)                  /*!< ECAP_T::CTL0: CAPSEL2 Mask                */

#define ECAP_CTL0_CAPIEN0_Pos            (16)                                              /*!< ECAP_T::CTL0: CAPIEN0 Position            */
#define ECAP_CTL0_CAPIEN0_Msk            (0x1ul << ECAP_CTL0_CAPIEN0_Pos)                  /*!< ECAP_T::CTL0: CAPIEN0 Mask                */

#define ECAP_CTL0_CAPIEN1_Pos            (17)                                              /*!< ECAP_T::CTL0: CAPIEN1 Position            */
#define ECAP_CTL0_CAPIEN1_Msk            (0x1ul << ECAP_CTL0_CAPIEN1_Pos)                  /*!< ECAP_T::CTL0: CAPIEN1 Mask                */

#define ECAP_CTL0_CAPIEN2_Pos            (18)                                              /*!< ECAP_T::CTL0: CAPIEN2 Position            */
#define ECAP_CTL0_CAPIEN2_Msk            (0x1ul << ECAP_CTL0_CAPIEN2_Pos)                  /*!< ECAP_T::CTL0: CAPIEN2 Mask                */

#define ECAP_CTL0_OVIEN_Pos              (20)                                              /*!< ECAP_T::CTL0: OVIEN Position              */
#define ECAP_CTL0_OVIEN_Msk              (0x1ul << ECAP_CTL0_OVIEN_Pos)                    /*!< ECAP_T::CTL0: OVIEN Mask                  */

#define ECAP_CTL0_CMPIEN_Pos             (21)                                              /*!< ECAP_T::CTL0: CMPIEN Position             */
#define ECAP_CTL0_CMPIEN_Msk             (0x1ul << ECAP_CTL0_CMPIEN_Pos)                   /*!< ECAP_T::CTL0: CMPIEN Mask                 */

#define ECAP_CTL0_CNTEN_Pos              (24)                                              /*!< ECAP_T::CTL0: CNTEN Position              */
#define ECAP_CTL0_CNTEN_Msk              (0x1ul << ECAP_CTL0_CNTEN_Pos)                    /*!< ECAP_T::CTL0: CNTEN Mask                  */

#define ECAP_CTL0_CMPCLR_Pos             (25)                                              /*!< ECAP_T::CTL0: CMPCLR Position             */
#define ECAP_CTL0_CMPCLR_Msk             (0x1ul << ECAP_CTL0_CMPCLR_Pos)                   /*!< ECAP_T::CTL0: CMPCLR Mask                 */

#define ECAP_CTL0_CPTCLR_Pos             (26)                                              /*!< ECAP_T::CTL0: CPTCLR Position             */
#define ECAP_CTL0_CPTCLR_Msk             (0x1ul << ECAP_CTL0_CPTCLR_Pos)                   /*!< ECAP_T::CTL0: CPTCLR Mask                 */

#define ECAP_CTL0_RLDEN_Pos              (27)                                              /*!< ECAP_T::CTL0: RLDEN Position              */
#define ECAP_CTL0_RLDEN_Msk              (0x1ul << ECAP_CTL0_RLDEN_Pos)                    /*!< ECAP_T::CTL0: RLDEN Mask                  */

#define ECAP_CTL0_CMPEN_Pos              (28)                                              /*!< ECAP_T::CTL0: CMPEN Position              */
#define ECAP_CTL0_CMPEN_Msk              (0x1ul << ECAP_CTL0_CMPEN_Pos)                    /*!< ECAP_T::CTL0: CMPEN Mask                  */

#define ECAP_CTL0_CAPEN_Pos              (29)                                              /*!< ECAP_T::CTL0: CAPEN Position              */
#define ECAP_CTL0_CAPEN_Msk              (0x1ul << ECAP_CTL0_CAPEN_Pos)                    /*!< ECAP_T::CTL0: CAPEN Mask                  */

#define ECAP_CTL1_EDGESEL0_Pos           (0)                                               /*!< ECAP_T::CTL1: EDGESEL0 Position           */
#define ECAP_CTL1_EDGESEL0_Msk           (0x3ul << ECAP_CTL1_EDGESEL0_Pos)                 /*!< ECAP_T::CTL1: EDGESEL0 Mask               */

#define ECAP_CTL1_EDGESEL1_Pos           (2)                                               /*!< ECAP_T::CTL1: EDGESEL1 Position           */
#define ECAP_CTL1_EDGESEL1_Msk           (0x3ul << ECAP_CTL1_EDGESEL1_Pos)                 /*!< ECAP_T::CTL1: EDGESEL1 Mask               */

#define ECAP_CTL1_EDGESEL2_Pos           (4)                                               /*!< ECAP_T::CTL1: EDGESEL2 Position           */
#define ECAP_CTL1_EDGESEL2_Msk           (0x3ul << ECAP_CTL1_EDGESEL2_Pos)                 /*!< ECAP_T::CTL1: EDGESEL2 Mask               */

#define ECAP_CTL1_RLDSEL_Pos             (8)                                               /*!< ECAP_T::CTL1: RLDSEL Position             */
#define ECAP_CTL1_RLDSEL_Msk             (0x7ul << ECAP_CTL1_RLDSEL_Pos)                   /*!< ECAP_T::CTL1: RLDSEL Mask                 */

#define ECAP_CTL1_CLKSEL_Pos             (12)                                              /*!< ECAP_T::CTL1: CLKSEL Position             */
#define ECAP_CTL1_CLKSEL_Msk             (0x7ul << ECAP_CTL1_CLKSEL_Pos)                   /*!< ECAP_T::CTL1: CLKSEL Mask                 */

#define ECAP_CTL1_SRCSEL_Pos             (16)                                              /*!< ECAP_T::CTL1: SRCSEL Position             */
#define ECAP_CTL1_SRCSEL_Msk             (0x3ul << ECAP_CTL1_SRCSEL_Pos)                   /*!< ECAP_T::CTL1: SRCSEL Mask                 */

#define ECAP_STATUS_CAPF0_Pos            (0)                                               /*!< ECAP_T::STATUS: CAPF0 Position            */
#define ECAP_STATUS_CAPF0_Msk            (0x1ul << ECAP_STATUS_CAPF0_Pos)                  /*!< ECAP_T::STATUS: CAPF0 Mask                */

#define ECAP_STATUS_CAPF1_Pos            (1)                                               /*!< ECAP_T::STATUS: CAPF1 Position            */
#define ECAP_STATUS_CAPF1_Msk            (0x1ul << ECAP_STATUS_CAPF1_Pos)                  /*!< ECAP_T::STATUS: CAPF1 Mask                */

#define ECAP_STATUS_CAPF2_Pos            (2)                                               /*!< ECAP_T::STATUS: CAPF2 Position            */
#define ECAP_STATUS_CAPF2_Msk            (0x1ul << ECAP_STATUS_CAPF2_Pos)                  /*!< ECAP_T::STATUS: CAPF2 Mask                */

#define ECAP_STATUS_CMPF_Pos             (4)                                               /*!< ECAP_T::STATUS: CMPF Position             */
#define ECAP_STATUS_CMPF_Msk             (0x1ul << ECAP_STATUS_CMPF_Pos)                   /*!< ECAP_T::STATUS: CMPF Mask                 */

#define ECAP_STATUS_OVF_Pos              (5)                                               /*!< ECAP_T::STATUS: OVF Position              */
#define ECAP_STATUS_OVF_Msk              (0x1ul << ECAP_STATUS_OVF_Pos)                    /*!< ECAP_T::STATUS: OVF Mask                  */

/**@}*/ /* ECAP_CONST */
/**@}*/ /* end of ECAP register group */


/*---------------------- System Clock Controller -------------------------*/
/**
    @addtogroup CLK System Clock Controller(CLK)
    Memory Mapped Structure for CLK Controller
@{ */

typedef struct {


    /**
     * PWRCTL
     * ===================================================================================================
     * Offset: 0x00  System Power-down Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |HXTEN     |4~24 MHz External High-Speed Crystal Enable Control (Write Protect)
     * |        |          |The bit default value is set by flash controller user configuration register config0 [26:24].
     * |        |          |When the default clock source is from 4~24 MHz external high-speed crystal, this bit is set to 1 automatically
     * |        |          |0 = HXT Disabled.
     * |        |          |1 = HXT Enabled.
     * |[1]     |LXTEN     |LXT Enable Control (Write Protect)
     * |        |          |0 = LXT Disabled.
     * |        |          |1 = LXT (Normal operation) Enabled.
     * |[2]     |HIRCEN    |HIRC Enable Control (Write Protect)
     * |        |          |0 = HIRC Disabled.
     * |        |          |1 = HIRC Enabled.
     * |[3]     |LIRCEN    |10 KHz Internal Low-Speed Oscillator Enable Control (Write Protect)
     * |        |          |0 = LIRC Disabled.
     * |        |          |1 = LIRC Enabled (default 1).
     * |[4]     |PDWKDLY   |Wake-Up Delay Counter Enable Control (Write Protect)
     * |        |          |When the chip wakes up from Power-down mode, the clock control will delay certain clock cycles to wait system clock stable.
     * |        |          |The delayed clock cycle is 4096 clock cycles when chip work at HXT, and 256 clock cycles when chip works at HIRC.
     * |        |          |0 = Clock cycles delay Disabled.
     * |        |          |1 = Clock cycles delay Enabled.
     * |[5]     |PDWKIEN   |Power-Down Mode Wake-Up Interrupt Enable Control (Write Protect)
     * |        |          |0 = Power-down Mode Wake-up Interrupt Disabled.
     * |        |          |1 = Power-down Mode Wake-up Interrupt Enabled.
     * |        |          |Note: The interrupt will occur when both PDWKIF and PDWKIEN are high.
     * |[6]     |PDWKIF    |Power-Down Mode Wake-Up Interrupt Status
     * |        |          |Set by "power-down wake-up event", it indicates that resume from Power-down mode"
     * |        |          |The flag is set if the GPIO, USB, UART, WDT, CAN, ACMP, BOD, RTC or SDHOST wake-up occurred
     * |        |          |Note1: Write 1 to clear the bit to 0.
     * |        |          |Note2: This bit works only if PDWKIEN (CLK_PWRCTL[5]) set to 1.
     * |[7]     |PDEN      |System Power-Down Enable Control (Write Protect)
     * |        |          |When this bit is set to 1, Power-down mode is enabled and chip power-down behavior will depend on the PDEN bit.
     * |        |          |(a) If the PDEN is 0, then the chip enters Power-down mode immediately after
     * |        |          |the PWR_DOWN_EN bit set. ( default)
     * |        |          |(b) if the PDEN is 1, then the chip keeps active till the CPU sleep mode is also
     * |        |          |active and then the chip enters Power-down mode
     * |        |          |When chip wakes up from Power-down mode, this bit is auto cleared. Users need to set
     * |        |          |this bit again for next power-down.
     * |        |          |In Power-down mode, HXT and the HIRC will be disabled in this mode, but the LXT and
     * |        |          |LIRC are not controlled by Power-down mode.
     * |        |          |In Power-down mode, the PLL and system clock are disabled, and ignored the clock
     * |        |          |source selection. The clocks of peripheral are not controlled by Power-down mode, if the
     * |        |          |peripheral clock source is from LXT or the LIRC.
     * |        |          |0 = Chip operating normally or chip in idle mode by WFI command.
     * |        |          |1 = Chip enters Power-down mode instant or waits CPU sleep command WFI.
     * |[8]     |PDWTCPU   |This Bit Control The Power-Down Entry Condition (Write Protect)
     * |        |          |0 = Chip enters Power-down mode when the PWR_DOWN_EN bit is set to 1.
     * |        |          |1 = Chip enters Power-down mode when the both PDEN and PWR_DOWN_EN bits are set to 1 and CPU run WFI instruction.
     * |[9]     |DBPDEN    |Chip Entering Power-Down Even ICE Connected
     * |        |          |0 = Chip enters power-down disabled in Debug mode.
     * |        |          |1 = Chip enters power-down enabled in Debug mode.
    */
    __IO uint32_t PWRCTL;

    /**
     * AHBCLK
     * ===================================================================================================
     * Offset: 0x04  AHB Devices Clock Enable Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[1]     |PDMACKEN  |PDMA Controller Clock Enable Control
     * |        |          |0 = PDMA engine clock Disabled.
     * |        |          |1 = PDMA engine clock Enabled.
     * |[2]     |ISPCKEN   |Flash ISP Controller Clock Enable Control
     * |        |          |0 = Flash ISP engine clock Disabled.
     * |        |          |1 = Flash ISP engine clock Enabled.
     * |[3]     |EBICKEN   |EBI Controller Clock Enable Control
     * |        |          |0 = EBI engine clock Disabled.
     * |        |          |1 = EBI engine clock Enabled.
     * |[4]     |USBHCKEN  |USB HOST Controller Clock Enable Control
     * |        |          |0 = USB HOST engine clock Disabled.
     * |        |          |1 = USB HOST engine clock Enabled.
     * |[5]     |EMACCKEN  |Ethernet Controller Clock Enable Control (NUC472 Only)
     * |        |          |0 = Ethernet Controller engine clock Disabled.
     * |        |          |1 = Ethernet Controller engine clock Enabled.
     * |[6]     |SDHCKEN   |SDHOST Controller Clock Enable Control
     * |        |          |0 = SDHOST engine clock Disabled.
     * |        |          |1 = SDHOST engine clock Enabled.
     * |[7]     |CRCCKEN   |CRC Generator Controller Clock Enable Control
     * |        |          |0 = CRC engine clock Disabled.
     * |        |          |1 = CRC engine clock Enabled.
     * |[8]     |CAPCKEN   |Image Capture Interface Controller Clock Enable Control
     * |        |          |0 = CAP controller's clock Disabled.
     * |        |          |1 = CAP controller's clock Enabled.
     * |[9]     |SENCKEN   |Sensor Clock Enable Control
     * |        |          |0 = Sensor clock Disabled.
     * |        |          |1 = Sensor clock Enabled.
     * |[10]    |USBDCKEN  |USB 2.0 Device Clock Enable Control
     * |        |          |0 = USB device controller's clock Disabled.
     * |        |          |1 = USB device controller's clock Enabled.
     * |[12]    |CRPTCKEN  |Cryptographic Accelerator Clock Enable Control
     * |        |          |0 = Cryptographic Accelerator clock Disabled.
     * |        |          |1 = Cryptographic Accelerator clock Enabled.
    */
    __IO uint32_t AHBCLK;

    /**
     * APBCLK0
     * ===================================================================================================
     * Offset: 0x08  APB Devices Clock Enable Control Register 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |WDTCKEN   |Watchdog Timer Clock Enable Control (Write Protect)
     * |        |          |This bit is the protected bit, which means programming this needs to write "59h", "16h", "88h" to address 0x4000_0100 to disable register protection.
     * |        |          |Refer to the register REGWRPROT at address GCR_BA+0x100.
     * |        |          |0 = Watchdog Timer Clock Disabled.
     * |        |          |1 = Watchdog Timer Clock Enabled.
     * |[1]     |RTCCKEN   |Real-Time-Clock APB Interface Clock Enable Control
     * |        |          |This bit is used to control the RTC APB clock only, The RTC engine clock source is from the 32.768 kHz external low-speed crystal.
     * |        |          |0 = RTC Clock Disabled.
     * |        |          |1 = RTC Clock Enabled.
     * |[2]     |TMR0CKEN  |Timer0 Clock Enable Control
     * |        |          |0 = Timer0 Clock Disabled.
     * |        |          |1 = Timer0 Clock Enabled.
     * |[3]     |TMR1CKEN  |Timer1 Clock Enable Control
     * |        |          |0 = Timer1 Clock Disabled.
     * |        |          |1 = Timer1 Clock Enabled.
     * |[4]     |TMR2CKEN  |Timer2 Clock Enable Control
     * |        |          |0 = Timer2 Clock Disabled.
     * |        |          |1 = Timer2 Clock Enabled.
     * |[5]     |TMR3CKEN  |Timer3 Clock Enable Control
     * |        |          |0 = Timer3 Clock Disabled.
     * |        |          |1 = Timer3 Clock Enabled.
     * |[6]     |CLKOCKEN  |Clock Output Enable Control
     * |        |          |0 = Clock Output Disabled.
     * |        |          |1 = Clock Output Enabled.
     * |[7]     |ACMPCKEN  |Analog Comparator Clock Enable Control
     * |        |          |0 = Analog Comparator Clock Disabled.
     * |        |          |1 = Analog Comparator Clock Enabled.
     * |[8]     |I2C0CKEN  |I2C0 Clock Enable Control
     * |        |          |0 = I2C0 Clock Disabled.
     * |        |          |1 = I2C0 Clock Enabled.
     * |[9]     |I2C1CKEN  |I2C1 Clock Enable Control
     * |        |          |0 = I2C1 Clock Disabled.
     * |        |          |1 = I2C1 Clock Enabled.
     * |[10]    |I2C2CKEN  |I2C2 Clock Enable Control
     * |        |          |0 = I2C2 Clock Disabled.
     * |        |          |1 = I2C2 Clock Enabled.
     * |[11]    |I2C3CKEN  |I2C3 Clock Enable Control
     * |        |          |0 = I2C3 Clock Disabled.
     * |        |          |1 = I2C3 Clock Enabled.
     * |[12]    |SPI0CKEN  |SPI0 Clock Enable Control
     * |        |          |0 = SPI0 Clock Disabled.
     * |        |          |1= SPI0 Clock Enabled.
     * |[13]    |SPI1CKEN  |SPI1 Clock Enable Control
     * |        |          |0 = SPI1 Clock Disabled.
     * |        |          |1 = SPI1 Clock Enabled.
     * |[14]    |SPI2CKEN  |SPI2 Clock Enable Control
     * |        |          |0 = SPI2 Clock Disabled.
     * |        |          |1 = SPI2 Clock Enabled.
     * |[15]    |SPI3CKEN  |SPI3 Clock Enable Control
     * |        |          |0 = SPI3 Clock Disabled.
     * |        |          |1 = SPI3 Clock Enabled.
     * |[16]    |UART0CKEN |UART0 Clock Enable Control
     * |        |          |0 = UART0 clock Disabled.
     * |        |          |1 = UART0 clock Enabled.
     * |[17]    |UART1CKEN |UART1 Clock Enable Control
     * |        |          |0 = UART1 clock Disabled.
     * |        |          |1 = UART1 clock Enabled.
     * |[18]    |UART2CKEN |UART2 Clock Enable Control
     * |        |          |0 = UART2 clock Disabled.
     * |        |          |1 = UART2 clock Enabled.
     * |[19]    |UART3CKEN |UART3 Clock Enable Control
     * |        |          |0 = UART3 clock Disabled.
     * |        |          |1 = UART3 clock Enabled.
     * |[20]    |UART4CKEN |UART4 Clock Enable Control
     * |        |          |0 = UART4 clock Disabled.
     * |        |          |1 = UART4 clock Enabled.
     * |[21]    |UART5CKEN |UART5 Clock Enable Control
     * |        |          |0 = UART5 clock Disabled.
     * |        |          |1 = UART5 clock Enabled.
     * |[24]    |CAN0CKEN  |CAN Bus Controller-0 Clock Enable Control
     * |        |          |0 = CAN0 clock Disabled.
     * |        |          |1 = CAN0 clock Enabled.
     * |[25]    |CAN1CKEN  |CAN Bus Controller-1 Clock Enable Control
     * |        |          |0 = CAN1 clock Disabled.
     * |        |          |1 = CAN1 clock Enabled.
     * |[26]    |OTGCKEN   |USB 2.0 OTG Device Controller Clock Enable Control
     * |        |          |0 = OTG clock Disabled.
     * |        |          |1 = OTG clock Enabled.
     * |[28]    |ADCCKEN   |Analog-Digital-Converter (ADC) Clock Enable Control
     * |        |          |0 = ADC clock Disabled.
     * |        |          |1 = ADC clock Enabled.
     * |[29]    |I2S0CKEN  |I2S0 Clock Enable Control
     * |        |          |0 = I2S Clock Disabled.
     * |        |          |1 = I2S Clock Enabled.
     * |[30]    |I2S1CKEN  |I2S1 Clock Enable Control
     * |        |          |0 = I2S1 Clock Disabled.
     * |        |          |1 = I2S1 Clock Enabled.
     * |[31]    |PS2CKEN   |PS/2 Clock Enable Control
     * |        |          |0 = PS/2 clock Disabled.
     * |        |          |1 = PS/2 clock Enabled.
    */
    __IO uint32_t APBCLK0;

    /**
     * APBCLK1
     * ===================================================================================================
     * Offset: 0x0C  APB Devices Clock Enable Control Register 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |SC0CKEN   |SC0 Clock Enable Control
     * |        |          |0 = SC0 Clock Disabled.
     * |        |          |1 = SC0 Clock Enabled.
     * |[1]     |SC1CKEN   |SC1 Clock Enable Control
     * |        |          |0 = SC1 Clock Disabled.
     * |        |          |1 = SC1 Clock Enabled.
     * |[2]     |SC2CKEN   |SC2 Clock Enable Control
     * |        |          |0 = SC2 Clock Disabled.
     * |        |          |1 = SC2 Clock Enabled.
     * |[3]     |SC3CKEN   |SC3 Clock Enable Control
     * |        |          |0 = SC3 Clock Disabled.
     * |        |          |1 = SC3 Clock Enabled.
     * |[4]     |SC4CKEN   |SC4 Clock Enable Control
     * |        |          |0 = SC4 Clock Disabled.
     * |        |          |1 = SC4 Clock Enabled.
     * |[5]     |SC5CKEN   |SC5 Clock Enable Control
     * |        |          |0 = SC5 Clock Disabled.
     * |        |          |1 = SC5 Clock Enabled.
     * |[8]     |I2C4CKEN  |I2C4 Clock Enable Control
     * |        |          |0 = I2C4 Clock Disabled.
     * |        |          |1 = I2C4 Clock Enabled.
     * |[16]    |PWM0CH01CKEN|PWM0_01 Clock Enable Control
     * |        |          |0 = PWM0_01 Clock Disabled.
     * |        |          |1 = PWM0_01 Clock Enabled.
     * |[17]    |PWM0CH23CKEN|PWM0_23 Clock Enable Control
     * |        |          |0 = PWM0_23 Clock Disabled.
     * |        |          |1 = PWM0_23 Clock Enabled.
     * |[18]    |PWM0CH45CKEN|PWM0_45 Clock Enable Control
     * |        |          |0 = PWM0_45 Clock Disabled.
     * |        |          |1 = PWM0_45 Clock Enabled.
     * |[19]    |PWM1CH01CKEN|PWM1_01 Clock Enable Control
     * |        |          |0 = PWM1_01 Clock Disabled.
     * |        |          |1 = PWM1_01 Clock Enabled.
     * |[21]    |PWM1CH2345CKEN|PWM1_2345 Clock Enable Control
     * |        |          |0 = PWM1_2345 Clock Disabled.
     * |        |          |1 = PWM1_2345 Clock Enabled.
     * |[22]    |QEI0CKEN  |Quadrature Encoder Interface (QEI0) Clock Enable Control
     * |        |          |0 = QEI0 clock Disabled.
     * |        |          |1 = QEI0 clock Enabled.
     * |[23]    |QEI1CKEN  |Quadrature Encoder Interface (QEI1) Clock Enable Control
     * |        |          |0 = QEI1 clock Disabled.
     * |        |          |1 = QEI1 clock Enabled.
     * |[26]    |ECAP0CKEN |Enhance CAP (ECAP0) Clock Enable Control
     * |        |          |0 = ECAP0 clock Disabled.
     * |        |          |1 = ECAP0 clock Enabled.
     * |[27]    |ECAP1CKEN |Enhance CAP (ECAP1) Clock Enable Control
     * |        |          |0 = ECAP1 clock Disabled.
     * |        |          |1 = ECAP1 clock Enabled.
     * |[28]    |EPWM0CKEN |Enhance PWM0 (EPWM) Clock Enable Control
     * |        |          |0 = EPWM0 clock Disabled.
     * |        |          |1 = EPWM0 clock Enabled.
     * |[29]    |EPWM1CKEN |Enhance PWM1 (EPWM) Clock Enable Control
     * |        |          |0 = EPWM1 clock Disabled.
     * |        |          |1 = EPWM1 clock Enabled.
     * |[30]    |OPACKEN   |OP Amplifier (OPA) Clock Enable Control
     * |        |          |0 = OPA clock Disabled.
     * |        |          |1 = OPA clock Enabled.
     * |[31]    |EADCCKEN  |Enhance Analog-Digital-Converter (E ADC) Clock Enable Control
     * |        |          |0 = EADC clock Disabled.
     * |        |          |1 = EADC clock Enabled.
    */
    __IO uint32_t APBCLK1;

    /**
     * CLKSEL0
     * ===================================================================================================
     * Offset: 0x10  Clock Source Select Control Register 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:2]   |HCLKSEL   |HCLK Clock Source Selection (Write Protect)
     * |        |          |Before clock switching, the related clock sources (both pre-select and new-select) must be turned on
     * |        |          |1.
     * |        |          |The 3-bit default value is reloaded from the value of CFOSC (Config0[26:24]) in user configuration register of Flash controller by any reset.
     * |        |          |Therefore the default value is either 000b or 111b.
     * |        |          |2.
     * |        |          |These bits are protected bit, it means programming this bit needs to write "59h", "16h", "88h" to address 0x4000_0100 to disable register protection.
     * |        |          |Refer to the register REGWRPROT at address GCR_BA+0x100.
     * |        |          |000 = Clock source from HXT clock.
     * |        |          |001 = Clock source from LXT clock.
     * |        |          |010 = Clock source from PLL clock.
     * |        |          |011 = Clock source from LIRC clock.
     * |        |          |100 = Clock source from PLL2 clock.
     * |        |          |111 = Clock source from HIRC clock.
     * |        |          |Other = Reserved.
     * |[3:5]   |STCLKSEL  |Cortex(TM)-M4 SysTick Clock Source Selection (Write Protect)
     * |        |          |If SYST_CSR[2]=0, SysTick uses listed clock source below.
     * |        |          |These bits are protected bit.
     * |        |          |It means programming this bit needs to write "59h", "16h", "88h" to address 0x4000_0100 to disable register protection.
     * |        |          |Refer to the register REGWRPROT at address GCR_BA+0x100.
     * |        |          |000 = Clock source from HXT clock.
     * |        |          |001 = Clock source from LXT clock.
     * |        |          |010 = Clock source from HXT clock/2.
     * |        |          |011 = Clock source from HCLK/2.
     * |        |          |111 = Clock source from HIRC clock/2.
     * |[6]     |PCLKSEL   |PCLK Clock Source Selection (Write Protect)
     * |        |          |These bits are protected bit.
     * |        |          |It means programming this bit needs to write "59h", "16h", "88h" to address 0x4000_0100 to disable register protection.
     * |        |          |Refer to the register REGWRPROT at address GCR_BA+0x100.
     * |        |          |0 = Clock source from HCLK.
     * |        |          |1 = Clock source from HCLK/2.
     * |[8]     |USBHSEL   |USB Host Clock Source Selection (Write Protect)
     * |        |          |These bits are protected bit.
     * |        |          |It means programming this bit needs to write "59h", "16h", "88h" to address 0x4000_0100 to disable register protection.
     * |        |          |Refer to the register REGWRPROT at address GCR_BA+0x100.
     * |        |          |0 = Clock source from PLL2.
     * |        |          |1 = Clock source from PLL.
     * |[16:17] |CAPSEL    |Image Capture Interface Clock Source Selection
     * |        |          |These bits are protected bit.
     * |        |          |It means programming this bit needs to write "59h", "16h", "88h" to address 0x4000_0100 to disable register protection.
     * |        |          |Refer to the register REGWRPROT at address GCR_BA+0x100.
     * |        |          |00 = Clock source from HXT clock.
     * |        |          |01 = Clock source from PLL clock.
     * |        |          |10 = Clock source from HCLK.
     * |        |          |11 = Clock source from HIRC clock.
     * |[20:21] |SDHSEL    |SDHOST Engine Clock Source Selection
     * |        |          |These bits are protected bit.
     * |        |          |It means programming this bit needs to write "59h", "16h", "88h" to address 0x4000_0100 to disable register protection.
     * |        |          |Refer to the register REGWRPROT at address GCR_BA+0x100.
     * |        |          |00 = Clock source from HXT clock.
     * |        |          |01 = Clock source from PLL clock.
     * |        |          |10 = Clock source from HCLK.
     * |        |          |11 = Clock source from HIRC clock.
    */
    __IO uint32_t CLKSEL0;

    /**
     * CLKSEL1
     * ===================================================================================================
     * Offset: 0x14  Clock Source Select Control Register 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:1]   |WDTSEL    |Watchdog Timer Clock Source Selection (Write Protect)
     * |        |          |These bits are protected bit,and programming this needs to write "59h", "16h", "88h" to address 0x4000_0100 to disable register protection.
     * |        |          |Refer to the register REGWRPROT at address GCR_BA+0x100.
     * |        |          |00 = Clock source from 4~24 MHz external high-speed crystal clock.
     * |        |          |01 = Clock source from LXT clock.
     * |        |          |10 = Clock source from HCLK/2048 clock.
     * |        |          |11 = Clock source from LIRC clock.
     * |[2:3]   |EADCSEL   |ADC Clock Source Selection
     * |        |          |00 = Clock source from HXT clock.
     * |        |          |01 = Clock source from PLL clock.
     * |        |          |10 = Clock source from PCLK.
     * |        |          |11 = Clock source from HIRC clock.
     * |[4]     |SPI0SEL   |SPI0 Clock Source Selection
     * |        |          |0 = Clock source from PLL clock.
     * |        |          |1 = Clock source from PCLK.
     * |[5]     |SPI1SEL   |SPI1 Clock Source Selection
     * |        |          |0 = Clock source from PLL clock.
     * |        |          |1 = Clock source from PCLK.
     * |[6]     |SPI2SEL   |SPI2 Clock Source Selection
     * |        |          |0 = Clock source from PLL clock.
     * |        |          |1 = Clock source from PCLK.
     * |[7]     |SPI3SEL   |SPI3 Clock Source Selection
     * |        |          |0 = Clock source from PLL clock.
     * |        |          |1 = Clock source from PCLK.
     * |[8:10]  |TMR0SEL   |TIMER0 Clock Source Selection
     * |        |          |000 = Clock source from HXT clock.
     * |        |          |001 = Clock source from LXT clock.
     * |        |          |010 = Clock source from PCLK.
     * |        |          |011 = Clock source from external trigger.
     * |        |          |101 = Clock source from LIRC clock.
     * |        |          |111 = Clock source from HIRC clock.
     * |        |          |Others = reserved.
     * |[12:14] |TMR1SEL   |TIMER1 Clock Source Selection
     * |        |          |000 = Clock source from HXT clock.
     * |        |          |001 = Clock source from LXT clock.
     * |        |          |010 = Clock source from PCLK.
     * |        |          |011 = Clock source from external trigger.
     * |        |          |101 = Clock source from LIRC clock.
     * |        |          |111 = Clock source from HIRC clock.
     * |        |          |Others = reserved.
     * |[16:18] |TMR2SEL   |TIMER2 Clock Source Selection
     * |        |          |000 = Clock source from HXT clock.
     * |        |          |001 = Clock source from LXT clock.
     * |        |          |010 = Clock source from PCLK.
     * |        |          |011 = Clock source from external trigger.
     * |        |          |101 = Clock source from LIRC clock.
     * |        |          |111 = Clock source from HIRC clock.
     * |        |          |Others = reserved.
     * |[20:22] |TMR3SEL   |TIMER3 Clock Source Selection
     * |        |          |000 = Clock source from HXT clock.
     * |        |          |001 = Clock source from LXT clock.
     * |        |          |010 = Clock source from PCLK.
     * |        |          |011 = Clock source from external trigger.
     * |        |          |101 = Clock source from LIRC clock.
     * |        |          |111 = Clock source from HIRC clock.
     * |        |          |Others = reserved.
     * |[24:25] |UARTSEL   |UART Clock Source Selection
     * |        |          |00 = Clock source from HXT clock.
     * |        |          |01 = Clock source from PLL clock.
     * |        |          |10/11 = Clock source from HIRC clock.
     * |[28:29] |CLKOSEL   |Clock Divider Clock Source Selection
     * |        |          |00 = Clock source from HXT clock.
     * |        |          |01 = Clock source from LXT clock.
     * |        |          |10 = Clock source from HCLK.
     * |        |          |11 = Clock source from HIRC clock.
     * |[30:31] |WWDTSEL   |Window Watchdog Timer Clock Source Selection
     * |        |          |00 = Reserved.
     * |        |          |01 = Reserved.
     * |        |          |10 = Clock source from HCLK/2048 clock.
     * |        |          |11 = Clock source from LIRC clock.
    */
    __IO uint32_t CLKSEL1;

    /**
     * CLKSEL2
     * ===================================================================================================
     * Offset: 0x18  Clock Source Select Control Register 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:2]   |PWM0CH01SEL|PWM0_0 And PWM0_1 Clock Source Selection
     * |        |          |PWM0_0 and PWM0_1 uses the same Engine clock source, both of them use the same prescaler.
     * |        |          |The Engine clock source of PWM0_0 and PWM0_1 is defined by PWM0CH01SEL[2:0].
     * |        |          |000 = Clock source from HXT clock.
     * |        |          |001 = Clock source from LXT clock.
     * |        |          |010 = Clock source from PCLK.
     * |        |          |011 = Clock source from HIRC clock.
     * |        |          |100 = Clock source from LIRC clock.
     * |        |          |Other = Reserved.
     * |[4:6]   |PPWM0CH23SEL|PWM0_2 And PWM0_3 Clock Source Selection
     * |        |          |PWM0_2 and PWM0_3 uses the same Engine clock source, both of them use the same prescaler.
     * |        |          |The Engine clock source of PWM0_2 and PWM0_3 is defined by PPWM0CH23SEL[2:0].
     * |        |          |000 = Clock source from HXT clock.
     * |        |          |001 = Clock source from LXT clock.
     * |        |          |010 = Clock source from PCLK.
     * |        |          |011 = Clock source from HIRC clock.
     * |        |          |100 = Clock source from LIRC clock.
     * |        |          |Other = Reserved.
     * |[8:10]  |PWM0CH45SEL|PWM0_4 And PWM0_5 Clock Source Selection
     * |        |          |PWM0_4 and PWM0_5 used the same Engine clock source; both of them use the same prescaler.
     * |        |          |The Engine clock source of PWM0_4 and PWM0_5 is defined by PWM0CH45SEL[2:0].
     * |        |          |000 = Clock source from HXT clock.
     * |        |          |001 = Clock source from LXT clock.
     * |        |          |010 = Clock source from PCLK.
     * |        |          |011 = Clock source from HIRC clock.
     * |        |          |100 = Clock source from LIRC clock.
     * |        |          |Other = Reserved.
     * |[12:14] |PWM1CH01SEL|PWM1_0 And PWM1_1 Clock Source Selection
     * |        |          |PWM1_0 and PWM1_1 uses the same Engine clock source, both of them use the same prescaler.
     * |        |          |The Engine clock source of PWM1_0 and PWM1_1 is defined by PWM1CH01SEL[2:0].
     * |        |          |000 = Clock source from HXT clock.
     * |        |          |001 = Clock source from LXT clock.
     * |        |          |010 = Clock source from PCLK.
     * |        |          |011 = Clock source from HIRC clock.
     * |        |          |100 = Clock source from LIRC clock.
     * |        |          |Other = Reserved.
     * |[16:18] |PWM1CH23SEL|PWM1_2 And PWM1_3 Clock Source Selection
     * |        |          |PWM1_2 and PWM1_3 uses the same Engine clock source, both of them use the same prescaler.
     * |        |          |The Engine clock source of PWM1_2 and PWM1_3 is defined by PWM1CH23SEL[2:0].
     * |        |          |000 = Clock source from HXT clock.
     * |        |          |001 = Clock source from LXT clock.
     * |        |          |010 = Clock source from PCLK.
     * |        |          |011 = Clock source from HIRC clock.
     * |        |          |100= Clock source from LIRC clock.
     * |        |          |Other = Reserved.
     * |[20:22] |PWM1CH45SEL|PWM1_4 And PWM1_5 Clock Source Selection
     * |        |          |PWM1_4 and PWM1_5 used the same Engine clock source; both of them use the same prescaler.
     * |        |          |The Engine clock source of PWM1_4 and PWM1_5 is defined by PWM1CH45SEL[2:0].
     * |        |          |000 = Clock source from HXT clock.
     * |        |          |001 = Clock source from LXT clock.
     * |        |          |010 = Clock source from PCLK.
     * |        |          |011 = Clock source from HIRC clock.
     * |        |          |100 = Clock source from LIRC clock.
     * |        |          |Other = Reserved.
    */
    __IO uint32_t CLKSEL2;

    /**
     * CLKSEL3
     * ===================================================================================================
     * Offset: 0x1C  Clock Source Select Control Register 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:1]   |SC0SEL    |SC0 Clock Source Selection
     * |        |          |00 = Clock source from HXT clock.
     * |        |          |01 = Clock source from PLL clock.
     * |        |          |10 = PCLK.
     * |        |          |11 = Clock source from HIRC clock.
     * |[2:3]   |SC1SEL    |SC1 Clock Source Selection
     * |        |          |00 = Clock source from HXT clock.
     * |        |          |01 = Clock source from PLL clock.
     * |        |          |10 = PCLK.
     * |        |          |11 = Clock source from HIRC clock.
     * |[4:5]   |SC2SEL    |SC2 Clock Source Selection
     * |        |          |00 = Clock source from HXT clock.
     * |        |          |01 = Clock source from PLL clock.
     * |        |          |10 = PCLK.
     * |        |          |11 = Clock source from HIRC clock.
     * |[6:7]   |SC3SEL    |SC3 Clock Source Selection
     * |        |          |00 = Clock source from HXT clock.
     * |        |          |01 = Clock source from PLL clock.
     * |        |          |10 = PCLK.
     * |        |          |11 = Clock source from HIRC clock.
     * |[8:9]   |SC4SEL    |SC4 Clock Source Selection
     * |        |          |00 = Clock source from HXT clock.
     * |        |          |01 = Clock source from PLL clock.
     * |        |          |10 = PCLK.
     * |        |          |11 = Clock source from HIRC clock.
     * |[10:11] |SC5SEL    |SC5 Clock Source Selection
     * |        |          |00 = Clock source from HXT clock.
     * |        |          |01 = Clock source from PLL clock.
     * |        |          |10 = PCLK.
     * |        |          |11 = Clock source from HIRC clock.
     * |[16:17] |I2S0SEL   |I2S0 Clock Source Selection
     * |        |          |00 = Clock source from HXT clock.
     * |        |          |01 = Clock source from PLL clock.
     * |        |          |10 = Clock source from PCLK.
     * |        |          |11 = Clock source from HIRC clock.
     * |[18:19] |I2S1SEL   |I2S1 Clock Source Selection
     * |        |          |00 = Clock source from HXT clock.
     * |        |          |01 = Clock source from PLL clock.
     * |        |          |10 = Clock source from PCLK.
     * |        |          |11 = Clock source from HIRC clock.
    */
    __IO uint32_t CLKSEL3;

    /**
     * CLKDIV0
     * ===================================================================================================
     * Offset: 0x20  Clock Divider Number Register 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |HCLKDIV   |HCLK Clock Divide Number From HCLK Clock Source
     * |        |          |HCLK clock frequency = (HCLK clock source frequency) / (HCLKDIV + 1).
     * |[4:7]   |USBHDIV   |USB Host Clock Divide Number From PLL Clock
     * |        |          |USB Host clock frequency = (PLL frequency) / (USBHDIV + 1).
     * |[8:11]  |UARTDIV   |UART Clock Divide Number From UART Clock Source
     * |        |          |UART clock frequency = (UART clock source frequency) / (UARTDIV + 1).
     * |[16:23] |ADCDIV    |ADC Clock Divide Number From ADC Clock Source
     * |        |          |ADC clock frequency = (ADC clock source frequency) / (ADCDIV + 1).
     * |[24:31] |SDHDIV    |SDHOST Clock Divide Number From SDHOST Clock Source
     * |        |          |SDHOST clock frequency = (SDHOST clock source frequency) / (SDHDIV + 1).
    */
    __IO uint32_t CLKDIV0;

    /**
     * CLKDIV1
     * ===================================================================================================
     * Offset: 0x24  Clock Divider Number Register 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |SC0DIV    |SC0 Clock Divide Number From SC0 Clock Source
     * |        |          |SC0 clock frequency = (SC0 clock source frequency ) / (SC0DIV+ 1).
     * |[8:15]  |SC1DIV    |SC1 Clock Divide Number From SC1 Clock Source
     * |        |          |SC1 clock frequency = (SC1 clock source frequency ) / (SC1DIV + 1).
     * |[16:23] |SC2DIV    |SC2 Clock Divide Number From SC2 Clock Source
     * |        |          |SC2 clock frequency = (SC2 clock source frequency ) / (SC2DIV + 1).
     * |[24:31] |SC3DIV    |SC3 Clock Divide Number From SC3 Clock Source
     * |        |          |SC3 clock frequency = (SC3 clock source frequency ) / (SC3DIV+ 1).
    */
    __IO uint32_t CLKDIV1;

    /**
     * CLKDIV2
     * ===================================================================================================
     * Offset: 0x28  Clock Divider Number Register 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |SC4DIV    |SC4 Clock Divide Number From SC4 Clock Source
     * |        |          |SC4 clock frequency = (SC4 clock source frequency ) / (SC4DIV + 1).
     * |[8:15]  |SC5DIV    |SC5 Clock Divide Number From SC5 Clock Source
     * |        |          |SC5 clock frequency = (SC5 clock source frequency ) / (SC5DIV + 1).
    */
    __IO uint32_t CLKDIV2;

    /**
     * CLKDIV3
     * ===================================================================================================
     * Offset: 0x2C  Clock Divider Number Register 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |CAPDIV    |Image Capture Sensor Clock Divide Number From ICAP Clock Source
     * |        |          |Image sensor clock frequency = (ICAP clock source frequency) / (ICAPDIV + 1).
     * |[8:15]  |VSENSEDIV |Video Pixel Clock Divide Number From ICAP Clock Source
     * |        |          |Video pixel clock frequency = (ICAP clock source frequency) / (VSENSEDIV + 1).
     * |[16:23] |EMACDIV   |Ethernet Clock Divide Number Form HCLK (NUC472 Only)
     * |        |          |EMAC MDCLK clock frequency = (HCLK) / (EMACDIV + 1).
    */
    __IO uint32_t CLKDIV3;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE0[4];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * PLLCTL
     * ===================================================================================================
     * Offset: 0x40  PLL Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:8]   |FBDIV     |PLL Feedback Divider Control Pins
     * |        |          |Refer to the formulas below the table.
     * |[9:13]  |INDIV     |PLL Input Divider Control Pins
     * |        |          |Refer to the formulas below the table.
     * |[14:15] |OUTDV     |PLL Output Divider Control Pins
     * |        |          |Refer to the formulas below the table.
     * |[16]    |PD        |Power-Down Mode
     * |        |          |If set the PWR_DOWN_EN bit to 1 in CLK_PWRCTL register, the PLL will enter Power-down mode, too.
     * |        |          |0 = PLL is in normal mode.
     * |        |          |1 = PLL is in Power-down mode (default).
     * |[17]    |BP        |PLL Bypass Control
     * |        |          |0 = PLL is in normal mode (default).
     * |        |          |1 = PLL clock output is same as clock input (XTALin).
     * |[18]    |OE        |PLL OE (FOUT Enable) Pin Control
     * |        |          |0 = PLL FOUT Enabled.
     * |        |          |1 = PLL FOUT is fixed low.
     * |[19]    |PLLSRC    |PLL Source Clock Selection
     * |        |          |0 = PLL source clock from HXT.
     * |        |          |1 = PLL source clock from HIRC.
     * |[20]    |PLLREMAP  |PLL Remap Enable Bit
     * |        |          |0 = PLL remap enable.
     * |        |          |1 = PLL remap disable.
    */
    __IO uint32_t PLLCTL;

    /**
     * PLL2CTL
     * ===================================================================================================
     * Offset: 0x44  PLL2 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |PLL2DIV   |PLL2 Divider Control
     * |        |          |PLL2 clock frequency = (480 MHz) / 2 / (PLL2DIV + 1).
     * |        |          |Note: Max. PLL frequency 240 MHz when XTL12M.
     * |[8]     |PLL2CKEN  |USB OHY 480 MHz Enable Control
     * |        |          |This bit enables USB PHY PLL (480 MHz), and user needs to care extend 12 MHz source.
     * |        |          |0 = USB PHY PLL (480 MHz) Disabled.
     * |        |          |1 = USB PHY PLL (480 MHz) Enabled.
    */
    __IO uint32_t PLL2CTL;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE1[2];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * STATUS
     * ===================================================================================================
     * Offset: 0x50  Clock Status Monitor Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |HXTSTB    |4~24 MHz External High-Speed Crystal Clock(HXT) Source Stable Flag
     * |        |          |0 = HXT clock is not stable or disabled.
     * |        |          |1 = HXT clock is stable.
     * |        |          |Note: This bit is read only.
     * |[1]     |LXTSTB    |32.768 KHz External Low-Speed Crystal Clock(LXT) Source Stable Flag
     * |        |          |0 = LXT clock is not stable or disabled.
     * |        |          |1 = LXT clock is stabled.
     * |        |          |Note: This is read only.
     * |[2]     |PLLSTB    |Internal PLL Clock Source Stable Flag
     * |        |          |0 = Internal PLL clock is not stable or disabled.
     * |        |          |1 = Internal PLL clock is stable.
     * |        |          |Note: This bit is read only.
     * |[3]     |LIRCSTB   |10 KHz Internal Low-Speed Oscillator Clock (LIRC)Source Stable Flag
     * |        |          |0 = LIRC clock is not stable or disabled.
     * |        |          |1 = LIRC clock is stable.
     * |        |          |Note: This bit is read only.
     * |[4]     |HIRCSTB   |22.1184 MHz Internal High-Speed Oscillator Clock (HIRC) Clock Source Stable Flag
     * |        |          |0 = HIRC clock is not stable or disabled.
     * |        |          |1 = HIRC clock is stable.
     * |        |          |Note: This bit is read only.
     * |[5]     |PLL2STB   |Internal PLL2 Clock Source Stable Flag
     * |        |          |0 = Internal PLL2 clock is not stable or disabled.
     * |        |          |1 = Internal PLL2 clock is stable.
     * |        |          |Note: This bit is read only.
     * |[7]     |CLKSFAIL  |Clock Switching Fail Flag
     * |        |          |0 = Clock switching success.
     * |        |          |1 = Clock switching failure.
     * |        |          |Note1: This bit is updated when software switches system clock source.
     * |        |          |If switch target clock is stable, this bit will be set to 0.
     * |        |          |If switch target clock is not stable, this bit will be set to 1.
     * |        |          |Note2: Write 1 to clear the bit to 0.
    */
    __IO uint32_t STATUS;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE2[3];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * CLKOCTL
     * ===================================================================================================
     * Offset: 0x60  Frequency Divider Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |FSEL      |Divider Output Frequency Selection
     * |        |          |The formula of output frequency is:
     * |        |          |Fout = Fin/2(N+1).
     * |        |          |Fin is the input clock frequency.
     * |        |          |Fout is the frequency of divider output clock.
     * |        |          |N is the 4-bit value of FSEL[3:0].
     * |[4]     |CLKOEN    |Clock Output Enable Control
     * |        |          |0 = Clock Output disabled.
     * |        |          |1 = Clock Output enabled.
     * |[5]     |DIV1EN    |Frequency Divider 1 Enable Control
     * |        |          |0 = Divider output frequency is dependent on FSEL value when FDIVEN is enabled.
     * |        |          |1 = Divider output frequency is input clock frequency.
    */
    __IO uint32_t CLKOCTL;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE3[3];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * CLKDCTL
     * ===================================================================================================
     * Offset: 0x70  Clock Fail Detector Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |SYSFDEN   |System Clock Detector Enable Control
     * |        |          |0 = system clock fail interrupt disabled.
     * |        |          |1 = system clock fail interrupt enabled.
     * |[1]     |SYSFIEN   |System Clock Detector Interrupt Enable Control
     * |        |          |0 = system clock fail interrupt disabled.
     * |        |          |1 = system clock fail interrupt enabled.
     * |[2]     |SYSFIF    |System Clock Detect Fail Flag
     * |        |          |0 = System clock normal.
     * |        |          |1 = System clock abnormal (write " 1" to clear).
     * |[8]     |IRCDEN    |Internal RC Clock Detector Enable Control
     * |        |          |0 = IRC clock fail interrupt disabled.
     * |        |          |1 = IRC clock fail interrupt enabled.
     * |[9]     |IRCFIEN   |Internal RC Clock Detector Interrupt Enable Control
     * |        |          |0 = IRC clock fail interrupt disabled.
     * |        |          |1 = IRC clock fail interrupt enabled.
     * |[10]    |IRCFIF    |Internal RC Clock Fail Flag
     * |        |          |0 = IRC clock normal.
     * |        |          |1 = IRC abnormal (write "1" to clear) .
    */
    __IO uint32_t CLKDCTL;

} CLK_T;

/**
    @addtogroup CLK_CONST CLK Bit Field Definition
    Constant Definitions for CLK Controller
@{ */

#define CLK_PWRCTL_HXTEN_Pos             (0)                                               /*!< CLK_T::PWRCTL: HXTEN Position             */
#define CLK_PWRCTL_HXTEN_Msk             (0x1ul << CLK_PWRCTL_HXTEN_Pos)                   /*!< CLK_T::PWRCTL: HXTEN Mask                 */

#define CLK_PWRCTL_LXTEN_Pos             (1)                                               /*!< CLK_T::PWRCTL: LXTEN Position             */
#define CLK_PWRCTL_LXTEN_Msk             (0x1ul << CLK_PWRCTL_LXTEN_Pos)                   /*!< CLK_T::PWRCTL: LXTEN Mask                 */

#define CLK_PWRCTL_HIRCEN_Pos            (2)                                               /*!< CLK_T::PWRCTL: HIRCEN Position            */
#define CLK_PWRCTL_HIRCEN_Msk            (0x1ul << CLK_PWRCTL_HIRCEN_Pos)                  /*!< CLK_T::PWRCTL: HIRCEN Mask                */

#define CLK_PWRCTL_LIRCEN_Pos            (3)                                               /*!< CLK_T::PWRCTL: LIRCEN Position            */
#define CLK_PWRCTL_LIRCEN_Msk            (0x1ul << CLK_PWRCTL_LIRCEN_Pos)                  /*!< CLK_T::PWRCTL: LIRCEN Mask                */

#define CLK_PWRCTL_PDWKDLY_Pos           (4)                                               /*!< CLK_T::PWRCTL: PDWKDLY Position           */
#define CLK_PWRCTL_PDWKDLY_Msk           (0x1ul << CLK_PWRCTL_PDWKDLY_Pos)                 /*!< CLK_T::PWRCTL: PDWKDLY Mask               */

#define CLK_PWRCTL_PDWKIEN_Pos           (5)                                               /*!< CLK_T::PWRCTL: PDWKIEN Position           */
#define CLK_PWRCTL_PDWKIEN_Msk           (0x1ul << CLK_PWRCTL_PDWKIEN_Pos)                 /*!< CLK_T::PWRCTL: PDWKIEN Mask               */

#define CLK_PWRCTL_PDWKIF_Pos            (6)                                               /*!< CLK_T::PWRCTL: PDWKIF Position            */
#define CLK_PWRCTL_PDWKIF_Msk            (0x1ul << CLK_PWRCTL_PDWKIF_Pos)                  /*!< CLK_T::PWRCTL: PDWKIF Mask                */

#define CLK_PWRCTL_PDEN_Pos              (7)                                               /*!< CLK_T::PWRCTL: PDEN Position              */
#define CLK_PWRCTL_PDEN_Msk              (0x1ul << CLK_PWRCTL_PDEN_Pos)                    /*!< CLK_T::PWRCTL: PDEN Mask                  */

#define CLK_PWRCTL_PDWTCPU_Pos           (8)                                               /*!< CLK_T::PWRCTL: PDWTCPU Position           */
#define CLK_PWRCTL_PDWTCPU_Msk           (0x1ul << CLK_PWRCTL_PDWTCPU_Pos)                 /*!< CLK_T::PWRCTL: PDWTCPU Mask               */

#define CLK_PWRCTL_DBPDEN_Pos            (9)                                               /*!< CLK_T::PWRCTL: DBPDEN Position            */
#define CLK_PWRCTL_DBPDEN_Msk            (0x1ul << CLK_PWRCTL_DBPDEN_Pos)                  /*!< CLK_T::PWRCTL: DBPDEN Mask                */

#define CLK_AHBCLK_PDMACKEN_Pos          (1)                                               /*!< CLK_T::AHBCLK: PDMACKEN Position          */
#define CLK_AHBCLK_PDMACKEN_Msk          (0x1ul << CLK_AHBCLK_PDMACKEN_Pos)                /*!< CLK_T::AHBCLK: PDMACKEN Mask              */

#define CLK_AHBCLK_ISPCKEN_Pos           (2)                                               /*!< CLK_T::AHBCLK: ISPCKEN Position           */
#define CLK_AHBCLK_ISPCKEN_Msk           (0x1ul << CLK_AHBCLK_ISPCKEN_Pos)                 /*!< CLK_T::AHBCLK: ISPCKEN Mask               */

#define CLK_AHBCLK_EBICKEN_Pos           (3)                                               /*!< CLK_T::AHBCLK: EBICKEN Position           */
#define CLK_AHBCLK_EBICKEN_Msk           (0x1ul << CLK_AHBCLK_EBICKEN_Pos)                 /*!< CLK_T::AHBCLK: EBICKEN Mask               */

#define CLK_AHBCLK_USBHCKEN_Pos          (4)                                               /*!< CLK_T::AHBCLK: USBHCKEN Position          */
#define CLK_AHBCLK_USBHCKEN_Msk          (0x1ul << CLK_AHBCLK_USBHCKEN_Pos)                /*!< CLK_T::AHBCLK: USBHCKEN Mask              */

#define CLK_AHBCLK_EMACCKEN_Pos          (5)                                               /*!< CLK_T::AHBCLK: EMACCKEN Position          */
#define CLK_AHBCLK_EMACCKEN_Msk          (0x1ul << CLK_AHBCLK_EMACCKEN_Pos)                /*!< CLK_T::AHBCLK: EMACCKEN Mask              */

#define CLK_AHBCLK_SDHCKEN_Pos           (6)                                               /*!< CLK_T::AHBCLK: SDHCKEN Position           */
#define CLK_AHBCLK_SDHCKEN_Msk           (0x1ul << CLK_AHBCLK_SDHCKEN_Pos)                 /*!< CLK_T::AHBCLK: SDHCKEN Mask               */

#define CLK_AHBCLK_CRCCKEN_Pos           (7)                                               /*!< CLK_T::AHBCLK: CRCCKEN Position           */
#define CLK_AHBCLK_CRCCKEN_Msk           (0x1ul << CLK_AHBCLK_CRCCKEN_Pos)                 /*!< CLK_T::AHBCLK: CRCCKEN Mask               */

#define CLK_AHBCLK_CAPCKEN_Pos           (8)                                               /*!< CLK_T::AHBCLK: CAPCKEN Position          */
#define CLK_AHBCLK_CAPCKEN_Msk           (0x1ul << CLK_AHBCLK_CAPCKEN_Pos)                 /*!< CLK_T::AHBCLK: CAPCKEN Mask              */

#define CLK_AHBCLK_SENCKEN_Pos           (9)                                               /*!< CLK_T::AHBCLK: SENCKEN Position           */
#define CLK_AHBCLK_SENCKEN_Msk           (0x1ul << CLK_AHBCLK_SENCKEN_Pos)                 /*!< CLK_T::AHBCLK: SENCKEN Mask               */

#define CLK_AHBCLK_USBDCKEN_Pos          (10)                                              /*!< CLK_T::AHBCLK: USBDCKEN Position          */
#define CLK_AHBCLK_USBDCKEN_Msk          (0x1ul << CLK_AHBCLK_USBDCKEN_Pos)                /*!< CLK_T::AHBCLK: USBDCKEN Mask              */

#define CLK_AHBCLK_CRPTCKEN_Pos          (12)                                              /*!< CLK_T::AHBCLK: CRPTCKEN Position          */
#define CLK_AHBCLK_CRPTCKEN_Msk          (0x1ul << CLK_AHBCLK_CRPTCKEN_Pos)                /*!< CLK_T::AHBCLK: CRPTCKEN Mask              */

#define CLK_APBCLK0_WDTCKEN_Pos          (0)                                               /*!< CLK_T::APBCLK0: WDTCKEN Position          */
#define CLK_APBCLK0_WDTCKEN_Msk          (0x1ul << CLK_APBCLK0_WDTCKEN_Pos)                /*!< CLK_T::APBCLK0: WDTCKEN Mask              */

#define CLK_APBCLK0_RTCCKEN_Pos          (1)                                               /*!< CLK_T::APBCLK0: RTCCKEN Position          */
#define CLK_APBCLK0_RTCCKEN_Msk          (0x1ul << CLK_APBCLK0_RTCCKEN_Pos)                /*!< CLK_T::APBCLK0: RTCCKEN Mask              */

#define CLK_APBCLK0_TMR0CKEN_Pos         (2)                                               /*!< CLK_T::APBCLK0: TMR0CKEN Position         */
#define CLK_APBCLK0_TMR0CKEN_Msk         (0x1ul << CLK_APBCLK0_TMR0CKEN_Pos)               /*!< CLK_T::APBCLK0: TMR0CKEN Mask             */

#define CLK_APBCLK0_TMR1CKEN_Pos         (3)                                               /*!< CLK_T::APBCLK0: TMR1CKEN Position         */
#define CLK_APBCLK0_TMR1CKEN_Msk         (0x1ul << CLK_APBCLK0_TMR1CKEN_Pos)               /*!< CLK_T::APBCLK0: TMR1CKEN Mask             */

#define CLK_APBCLK0_TMR2CKEN_Pos         (4)                                               /*!< CLK_T::APBCLK0: TMR2CKEN Position         */
#define CLK_APBCLK0_TMR2CKEN_Msk         (0x1ul << CLK_APBCLK0_TMR2CKEN_Pos)               /*!< CLK_T::APBCLK0: TMR2CKEN Mask             */

#define CLK_APBCLK0_TMR3CKEN_Pos         (5)                                               /*!< CLK_T::APBCLK0: TMR3CKEN Position         */
#define CLK_APBCLK0_TMR3CKEN_Msk         (0x1ul << CLK_APBCLK0_TMR3CKEN_Pos)               /*!< CLK_T::APBCLK0: TMR3CKEN Mask             */

#define CLK_APBCLK0_CLKOCKEN_Pos         (6)                                               /*!< CLK_T::APBCLK0: CLKOCKEN Position         */
#define CLK_APBCLK0_CLKOCKEN_Msk         (0x1ul << CLK_APBCLK0_CLKOCKEN_Pos)               /*!< CLK_T::APBCLK0: CLKOCKEN Mask             */

#define CLK_APBCLK0_ACMPCKEN_Pos         (7)                                               /*!< CLK_T::APBCLK0: ACMPCKEN Position         */
#define CLK_APBCLK0_ACMPCKEN_Msk         (0x1ul << CLK_APBCLK0_ACMPCKEN_Pos)               /*!< CLK_T::APBCLK0: ACMPCKEN Mask             */

#define CLK_APBCLK0_I2C0CKEN_Pos         (8)                                               /*!< CLK_T::APBCLK0: I2C0CKEN Position         */
#define CLK_APBCLK0_I2C0CKEN_Msk         (0x1ul << CLK_APBCLK0_I2C0CKEN_Pos)               /*!< CLK_T::APBCLK0: I2C0CKEN Mask             */

#define CLK_APBCLK0_I2C1CKEN_Pos         (9)                                               /*!< CLK_T::APBCLK0: I2C1CKEN Position         */
#define CLK_APBCLK0_I2C1CKEN_Msk         (0x1ul << CLK_APBCLK0_I2C1CKEN_Pos)               /*!< CLK_T::APBCLK0: I2C1CKEN Mask             */

#define CLK_APBCLK0_I2C2CKEN_Pos         (10)                                              /*!< CLK_T::APBCLK0: I2C2CKEN Position         */
#define CLK_APBCLK0_I2C2CKEN_Msk         (0x1ul << CLK_APBCLK0_I2C2CKEN_Pos)               /*!< CLK_T::APBCLK0: I2C2CKEN Mask             */

#define CLK_APBCLK0_I2C3CKEN_Pos         (11)                                              /*!< CLK_T::APBCLK0: I2C3CKEN Position         */
#define CLK_APBCLK0_I2C3CKEN_Msk         (0x1ul << CLK_APBCLK0_I2C3CKEN_Pos)               /*!< CLK_T::APBCLK0: I2C3CKEN Mask             */

#define CLK_APBCLK0_SPI0CKEN_Pos         (12)                                              /*!< CLK_T::APBCLK0: SPI0CKEN Position         */
#define CLK_APBCLK0_SPI0CKEN_Msk         (0x1ul << CLK_APBCLK0_SPI0CKEN_Pos)               /*!< CLK_T::APBCLK0: SPI0CKEN Mask             */

#define CLK_APBCLK0_SPI1CKEN_Pos         (13)                                              /*!< CLK_T::APBCLK0: SPI1CKEN Position         */
#define CLK_APBCLK0_SPI1CKEN_Msk         (0x1ul << CLK_APBCLK0_SPI1CKEN_Pos)               /*!< CLK_T::APBCLK0: SPI1CKEN Mask             */

#define CLK_APBCLK0_SPI2CKEN_Pos         (14)                                              /*!< CLK_T::APBCLK0: SPI2CKEN Position         */
#define CLK_APBCLK0_SPI2CKEN_Msk         (0x1ul << CLK_APBCLK0_SPI2CKEN_Pos)               /*!< CLK_T::APBCLK0: SPI2CKEN Mask             */

#define CLK_APBCLK0_SPI3CKEN_Pos         (15)                                              /*!< CLK_T::APBCLK0: SPI3CKEN Position         */
#define CLK_APBCLK0_SPI3CKEN_Msk         (0x1ul << CLK_APBCLK0_SPI3CKEN_Pos)               /*!< CLK_T::APBCLK0: SPI3CKEN Mask             */

#define CLK_APBCLK0_UART0CKEN_Pos        (16)                                              /*!< CLK_T::APBCLK0: UART0CKEN Position        */
#define CLK_APBCLK0_UART0CKEN_Msk        (0x1ul << CLK_APBCLK0_UART0CKEN_Pos)              /*!< CLK_T::APBCLK0: UART0CKEN Mask            */

#define CLK_APBCLK0_UART1CKEN_Pos        (17)                                              /*!< CLK_T::APBCLK0: UART1CKEN Position        */
#define CLK_APBCLK0_UART1CKEN_Msk        (0x1ul << CLK_APBCLK0_UART1CKEN_Pos)              /*!< CLK_T::APBCLK0: UART1CKEN Mask            */

#define CLK_APBCLK0_UART2CKEN_Pos        (18)                                              /*!< CLK_T::APBCLK0: UART2CKEN Position        */
#define CLK_APBCLK0_UART2CKEN_Msk        (0x1ul << CLK_APBCLK0_UART2CKEN_Pos)              /*!< CLK_T::APBCLK0: UART2CKEN Mask            */

#define CLK_APBCLK0_UART3CKEN_Pos        (19)                                              /*!< CLK_T::APBCLK0: UART3CKEN Position        */
#define CLK_APBCLK0_UART3CKEN_Msk        (0x1ul << CLK_APBCLK0_UART3CKEN_Pos)              /*!< CLK_T::APBCLK0: UART3CKEN Mask            */

#define CLK_APBCLK0_UART4CKEN_Pos        (20)                                              /*!< CLK_T::APBCLK0: UART4CKEN Position        */
#define CLK_APBCLK0_UART4CKEN_Msk        (0x1ul << CLK_APBCLK0_UART4CKEN_Pos)              /*!< CLK_T::APBCLK0: UART4CKEN Mask            */

#define CLK_APBCLK0_UART5CKEN_Pos        (21)                                              /*!< CLK_T::APBCLK0: UART5CKEN Position        */
#define CLK_APBCLK0_UART5CKEN_Msk        (0x1ul << CLK_APBCLK0_UART5CKEN_Pos)              /*!< CLK_T::APBCLK0: UART5CKEN Mask            */

#define CLK_APBCLK0_CAN0CKEN_Pos         (24)                                              /*!< CLK_T::APBCLK0: CAN0CKEN Position         */
#define CLK_APBCLK0_CAN0CKEN_Msk         (0x1ul << CLK_APBCLK0_CAN0CKEN_Pos)               /*!< CLK_T::APBCLK0: CAN0CKEN Mask             */

#define CLK_APBCLK0_CAN1CKEN_Pos         (25)                                              /*!< CLK_T::APBCLK0: CAN1CKEN Position         */
#define CLK_APBCLK0_CAN1CKEN_Msk         (0x1ul << CLK_APBCLK0_CAN1CKEN_Pos)               /*!< CLK_T::APBCLK0: CAN1CKEN Mask             */

#define CLK_APBCLK0_OTGCKEN_Pos          (26)                                              /*!< CLK_T::APBCLK0: OTGCKEN Position          */
#define CLK_APBCLK0_OTGCKEN_Msk          (0x1ul << CLK_APBCLK0_OTGCKEN_Pos)                /*!< CLK_T::APBCLK0: OTGCKEN Mask              */

#define CLK_APBCLK0_ADCCKEN_Pos          (28)                                              /*!< CLK_T::APBCLK0: ADCCKEN Position          */
#define CLK_APBCLK0_ADCCKEN_Msk          (0x1ul << CLK_APBCLK0_ADCCKEN_Pos)                /*!< CLK_T::APBCLK0: ADCCKEN Mask              */

#define CLK_APBCLK0_I2S0CKEN_Pos         (29)                                              /*!< CLK_T::APBCLK0: I2S0CKEN Position         */
#define CLK_APBCLK0_I2S0CKEN_Msk         (0x1ul << CLK_APBCLK0_I2S0CKEN_Pos)               /*!< CLK_T::APBCLK0: I2S0CKEN Mask             */

#define CLK_APBCLK0_I2S1CKEN_Pos         (30)                                              /*!< CLK_T::APBCLK0: I2S1CKEN Position         */
#define CLK_APBCLK0_I2S1CKEN_Msk         (0x1ul << CLK_APBCLK0_I2S1CKEN_Pos)               /*!< CLK_T::APBCLK0: I2S1CKEN Mask             */

#define CLK_APBCLK0_PS2CKEN_Pos          (31)                                              /*!< CLK_T::APBCLK0: PS2CKEN Position          */
#define CLK_APBCLK0_PS2CKEN_Msk          (0x1ul << CLK_APBCLK0_PS2CKEN_Pos)                /*!< CLK_T::APBCLK0: PS2CKEN Mask              */

#define CLK_APBCLK1_SC0CKEN_Pos          (0)                                               /*!< CLK_T::APBCLK1: SC0CKEN Position          */
#define CLK_APBCLK1_SC0CKEN_Msk          (0x1ul << CLK_APBCLK1_SC0CKEN_Pos)                /*!< CLK_T::APBCLK1: SC0CKEN Mask              */

#define CLK_APBCLK1_SC1CKEN_Pos          (1)                                               /*!< CLK_T::APBCLK1: SC1CKEN Position          */
#define CLK_APBCLK1_SC1CKEN_Msk          (0x1ul << CLK_APBCLK1_SC1CKEN_Pos)                /*!< CLK_T::APBCLK1: SC1CKEN Mask              */

#define CLK_APBCLK1_SC2CKEN_Pos          (2)                                               /*!< CLK_T::APBCLK1: SC2CKEN Position          */
#define CLK_APBCLK1_SC2CKEN_Msk          (0x1ul << CLK_APBCLK1_SC2CKEN_Pos)                /*!< CLK_T::APBCLK1: SC2CKEN Mask              */

#define CLK_APBCLK1_SC3CKEN_Pos          (3)                                               /*!< CLK_T::APBCLK1: SC3CKEN Position          */
#define CLK_APBCLK1_SC3CKEN_Msk          (0x1ul << CLK_APBCLK1_SC3CKEN_Pos)                /*!< CLK_T::APBCLK1: SC3CKEN Mask              */

#define CLK_APBCLK1_SC4CKEN_Pos          (4)                                               /*!< CLK_T::APBCLK1: SC4CKEN Position          */
#define CLK_APBCLK1_SC4CKEN_Msk          (0x1ul << CLK_APBCLK1_SC4CKEN_Pos)                /*!< CLK_T::APBCLK1: SC4CKEN Mask              */

#define CLK_APBCLK1_SC5CKEN_Pos          (5)                                               /*!< CLK_T::APBCLK1: SC5CKEN Position          */
#define CLK_APBCLK1_SC5CKEN_Msk          (0x1ul << CLK_APBCLK1_SC5CKEN_Pos)                /*!< CLK_T::APBCLK1: SC5CKEN Mask              */

#define CLK_APBCLK1_I2C4CKEN_Pos         (8)                                               /*!< CLK_T::APBCLK1: I2C4CKEN Position         */
#define CLK_APBCLK1_I2C4CKEN_Msk         (0x1ul << CLK_APBCLK1_I2C4CKEN_Pos)               /*!< CLK_T::APBCLK1: I2C4CKEN Mask             */

#define CLK_APBCLK1_PWM0CH01CKEN_Pos     (16)                                              /*!< CLK_T::APBCLK1: PWM0CH01CKEN Position     */
#define CLK_APBCLK1_PWM0CH01CKEN_Msk     (0x1ul << CLK_APBCLK1_PWM0CH01CKEN_Pos)           /*!< CLK_T::APBCLK1: PWM0CH01CKEN Mask         */

#define CLK_APBCLK1_PWM0CH23CKEN_Pos     (17)                                              /*!< CLK_T::APBCLK1: PWM0CH23CKEN Position     */
#define CLK_APBCLK1_PWM0CH23CKEN_Msk     (0x1ul << CLK_APBCLK1_PWM0CH23CKEN_Pos)           /*!< CLK_T::APBCLK1: PWM0CH23CKEN Mask         */

#define CLK_APBCLK1_PWM0CH45CKEN_Pos     (18)                                              /*!< CLK_T::APBCLK1: PWM0CH45CKEN Position     */
#define CLK_APBCLK1_PWM0CH45CKEN_Msk     (0x1ul << CLK_APBCLK1_PWM0CH45CKEN_Pos)           /*!< CLK_T::APBCLK1: PWM0CH45CKEN Mask         */

#define CLK_APBCLK1_PWM1CH01CKEN_Pos     (19)                                              /*!< CLK_T::APBCLK1: PWM1CH01CKEN Position     */
#define CLK_APBCLK1_PWM1CH01CKEN_Msk     (0x1ul << CLK_APBCLK1_PWM1CH01CKEN_Pos)           /*!< CLK_T::APBCLK1: PWM1CH01CKEN Mask         */

#define CLK_APBCLK1_PWM1CH2345CKEN_Pos   (21)                                              /*!< CLK_T::APBCLK1: PWM1CH2345CKEN Position   */
#define CLK_APBCLK1_PWM1CH2345CKEN_Msk   (0x1ul << CLK_APBCLK1_PWM1CH2345CKEN_Pos)         /*!< CLK_T::APBCLK1: PWM1CH2345CKEN Mask       */

#define CLK_APBCLK1_QEI0CKEN_Pos         (22)                                              /*!< CLK_T::APBCLK1: QEI0CKEN Position         */
#define CLK_APBCLK1_QEI0CKEN_Msk         (0x1ul << CLK_APBCLK1_QEI0CKEN_Pos)               /*!< CLK_T::APBCLK1: QEI0CKEN Mask             */

#define CLK_APBCLK1_QEI1CKEN_Pos         (23)                                              /*!< CLK_T::APBCLK1: QEI1CKEN Position         */
#define CLK_APBCLK1_QEI1CKEN_Msk         (0x1ul << CLK_APBCLK1_QEI1CKEN_Pos)               /*!< CLK_T::APBCLK1: QEI1CKEN Mask             */

#define CLK_APBCLK1_ECAP0CKEN_Pos        (26)                                              /*!< CLK_T::APBCLK1: ECAP0CKEN Position        */
#define CLK_APBCLK1_ECAP0CKEN_Msk        (0x1ul << CLK_APBCLK1_ECAP0CKEN_Pos)              /*!< CLK_T::APBCLK1: ECAP0CKEN Mask            */

#define CLK_APBCLK1_ECAP1CKEN_Pos        (27)                                              /*!< CLK_T::APBCLK1: ECAP1CKEN Position        */
#define CLK_APBCLK1_ECAP1CKEN_Msk        (0x1ul << CLK_APBCLK1_ECAP1CKEN_Pos)              /*!< CLK_T::APBCLK1: ECAP1CKEN Mask            */

#define CLK_APBCLK1_EPWM0CKEN_Pos        (28)                                              /*!< CLK_T::APBCLK1: EPWM0CKEN Position        */
#define CLK_APBCLK1_EPWM0CKEN_Msk        (0x1ul << CLK_APBCLK1_EPWM0CKEN_Pos)              /*!< CLK_T::APBCLK1: EPWM0CKEN Mask            */

#define CLK_APBCLK1_EPWM1CKEN_Pos        (29)                                              /*!< CLK_T::APBCLK1: EPWM1CKEN Position        */
#define CLK_APBCLK1_EPWM1CKEN_Msk        (0x1ul << CLK_APBCLK1_EPWM1CKEN_Pos)              /*!< CLK_T::APBCLK1: EPWM1CKEN Mask            */

#define CLK_APBCLK1_OPACKEN_Pos          (30)                                              /*!< CLK_T::APBCLK1: OPACKEN Position          */
#define CLK_APBCLK1_OPACKEN_Msk          (0x1ul << CLK_APBCLK1_OPACKEN_Pos)                /*!< CLK_T::APBCLK1: OPACKEN Mask              */

#define CLK_APBCLK1_EADCCKEN_Pos         (31)                                              /*!< CLK_T::APBCLK1: EADCCKEN Position         */
#define CLK_APBCLK1_EADCCKEN_Msk         (0x1ul << CLK_APBCLK1_EADCCKEN_Pos)               /*!< CLK_T::APBCLK1: EADCCKEN Mask             */

#define CLK_CLKSEL0_HCLKSEL_Pos          (0)                                               /*!< CLK_T::CLKSEL0: HCLKSEL Position          */
#define CLK_CLKSEL0_HCLKSEL_Msk          (0x7ul << CLK_CLKSEL0_HCLKSEL_Pos)                /*!< CLK_T::CLKSEL0: HCLKSEL Mask              */

#define CLK_CLKSEL0_STCLKSEL_Pos         (3)                                               /*!< CLK_T::CLKSEL0: STCLKSEL Position         */
#define CLK_CLKSEL0_STCLKSEL_Msk         (0x7ul << CLK_CLKSEL0_STCLKSEL_Pos)               /*!< CLK_T::CLKSEL0: STCLKSEL Mask             */

#define CLK_CLKSEL0_PCLKSEL_Pos          (6)                                               /*!< CLK_T::CLKSEL0: PCLKSEL Position          */
#define CLK_CLKSEL0_PCLKSEL_Msk          (0x1ul << CLK_CLKSEL0_PCLKSEL_Pos)                /*!< CLK_T::CLKSEL0: PCLKSEL Mask              */

#define CLK_CLKSEL0_USBHSEL_Pos          (8)                                               /*!< CLK_T::CLKSEL0: USBHSEL Position          */
#define CLK_CLKSEL0_USBHSEL_Msk          (0x1ul << CLK_CLKSEL0_USBHSEL_Pos)                /*!< CLK_T::CLKSEL0: USBHSEL Mask              */

#define CLK_CLKSEL0_CAPSEL_Pos          (16)                                               /*!< CLK_T::CLKSEL0: CAPSEL Position          */
#define CLK_CLKSEL0_CAPSEL_Msk          (0x3ul << CLK_CLKSEL0_CAPSEL_Pos)                  /*!< CLK_T::CLKSEL0: CAPSEL Mask              */

#define CLK_CLKSEL0_SDHSEL_Pos           (20)                                              /*!< CLK_T::CLKSEL0: SDHSEL Position           */
#define CLK_CLKSEL0_SDHSEL_Msk           (0x3ul << CLK_CLKSEL0_SDHSEL_Pos)                 /*!< CLK_T::CLKSEL0: SDHSEL Mask               */

#define CLK_CLKSEL1_WDTSEL_Pos           (0)                                               /*!< CLK_T::CLKSEL1: WDTSEL Position           */
#define CLK_CLKSEL1_WDTSEL_Msk           (0x3ul << CLK_CLKSEL1_WDTSEL_Pos)                 /*!< CLK_T::CLKSEL1: WDTSEL Mask               */

#define CLK_CLKSEL1_ADCSEL_Pos           (2)                                               /*!< CLK_T::CLKSEL1: ADCSEL Position          */
#define CLK_CLKSEL1_ADCSEL_Msk           (0x3ul << CLK_CLKSEL1_ADCSEL_Pos)                 /*!< CLK_T::CLKSEL1: ADCSEL Mask              */

#define CLK_CLKSEL1_SPI0SEL_Pos          (4)                                               /*!< CLK_T::CLKSEL1: SPI0SEL Position          */
#define CLK_CLKSEL1_SPI0SEL_Msk          (0x1ul << CLK_CLKSEL1_SPI0SEL_Pos)                /*!< CLK_T::CLKSEL1: SPI0SEL Mask              */

#define CLK_CLKSEL1_SPI1SEL_Pos          (5)                                               /*!< CLK_T::CLKSEL1: SPI1SEL Position          */
#define CLK_CLKSEL1_SPI1SEL_Msk          (0x1ul << CLK_CLKSEL1_SPI1SEL_Pos)                /*!< CLK_T::CLKSEL1: SPI1SEL Mask              */

#define CLK_CLKSEL1_SPI2SEL_Pos          (6)                                               /*!< CLK_T::CLKSEL1: SPI2SEL Position          */
#define CLK_CLKSEL1_SPI2SEL_Msk          (0x1ul << CLK_CLKSEL1_SPI2SEL_Pos)                /*!< CLK_T::CLKSEL1: SPI2SEL Mask              */

#define CLK_CLKSEL1_SPI3SEL_Pos          (7)                                               /*!< CLK_T::CLKSEL1: SPI3SEL Position          */
#define CLK_CLKSEL1_SPI3SEL_Msk          (0x1ul << CLK_CLKSEL1_SPI3SEL_Pos)                /*!< CLK_T::CLKSEL1: SPI3SEL Mask              */

#define CLK_CLKSEL1_TMR0SEL_Pos          (8)                                               /*!< CLK_T::CLKSEL1: TMR0SEL Position          */
#define CLK_CLKSEL1_TMR0SEL_Msk          (0x7ul << CLK_CLKSEL1_TMR0SEL_Pos)                /*!< CLK_T::CLKSEL1: TMR0SEL Mask              */

#define CLK_CLKSEL1_TMR1SEL_Pos          (12)                                              /*!< CLK_T::CLKSEL1: TMR1SEL Position          */
#define CLK_CLKSEL1_TMR1SEL_Msk          (0x7ul << CLK_CLKSEL1_TMR1SEL_Pos)                /*!< CLK_T::CLKSEL1: TMR1SEL Mask              */

#define CLK_CLKSEL1_TMR2SEL_Pos          (16)                                              /*!< CLK_T::CLKSEL1: TMR2SEL Position          */
#define CLK_CLKSEL1_TMR2SEL_Msk          (0x7ul << CLK_CLKSEL1_TMR2SEL_Pos)                /*!< CLK_T::CLKSEL1: TMR2SEL Mask              */

#define CLK_CLKSEL1_TMR3SEL_Pos          (20)                                              /*!< CLK_T::CLKSEL1: TMR3SEL Position          */
#define CLK_CLKSEL1_TMR3SEL_Msk          (0x7ul << CLK_CLKSEL1_TMR3SEL_Pos)                /*!< CLK_T::CLKSEL1: TMR3SEL Mask              */

#define CLK_CLKSEL1_UARTSEL_Pos          (24)                                              /*!< CLK_T::CLKSEL1: UARTSEL Position          */
#define CLK_CLKSEL1_UARTSEL_Msk          (0x3ul << CLK_CLKSEL1_UARTSEL_Pos)                /*!< CLK_T::CLKSEL1: UARTSEL Mask              */

#define CLK_CLKSEL1_CLKOSEL_Pos          (28)                                              /*!< CLK_T::CLKSEL1: CLKOSEL Position          */
#define CLK_CLKSEL1_CLKOSEL_Msk          (0x3ul << CLK_CLKSEL1_CLKOSEL_Pos)                /*!< CLK_T::CLKSEL1: CLKOSEL Mask              */

#define CLK_CLKSEL1_WWDTSEL_Pos          (30)                                              /*!< CLK_T::CLKSEL1: WWDTSEL Position          */
#define CLK_CLKSEL1_WWDTSEL_Msk          (0x3ul << CLK_CLKSEL1_WWDTSEL_Pos)                /*!< CLK_T::CLKSEL1: WWDTSEL Mask              */

#define CLK_CLKSEL2_PWM0CH01SEL_Pos      (0)                                               /*!< CLK_T::CLKSEL2: PWM0CH01SEL Position      */
#define CLK_CLKSEL2_PWM0CH01SEL_Msk      (0x7ul << CLK_CLKSEL2_PWM0CH01SEL_Pos)            /*!< CLK_T::CLKSEL2: PWM0CH01SEL Mask          */

#define CLK_CLKSEL2_PWM0CH23SEL_Pos      (4)                                               /*!< CLK_T::CLKSEL2: PWM0CH23SEL Position     */
#define CLK_CLKSEL2_PWM0CH23SEL_Msk      (0x7ul << CLK_CLKSEL2_PWM0CH23SEL_Pos)            /*!< CLK_T::CLKSEL2: PWM0CH23SEL Mask         */

#define CLK_CLKSEL2_PWM0CH45SEL_Pos      (8)                                               /*!< CLK_T::CLKSEL2: PWM0CH45SEL Position      */
#define CLK_CLKSEL2_PWM0CH45SEL_Msk      (0x7ul << CLK_CLKSEL2_PWM0CH45SEL_Pos)            /*!< CLK_T::CLKSEL2: PWM0CH45SEL Mask          */

#define CLK_CLKSEL2_PWM1CH01SEL_Pos      (12)                                              /*!< CLK_T::CLKSEL2: PWM1CH01SEL Position      */
#define CLK_CLKSEL2_PWM1CH01SEL_Msk      (0x7ul << CLK_CLKSEL2_PWM1CH01SEL_Pos)            /*!< CLK_T::CLKSEL2: PWM1CH01SEL Mask          */

#define CLK_CLKSEL2_PWM1CH23SEL_Pos      (16)                                              /*!< CLK_T::CLKSEL2: PWM1CH23SEL Position      */
#define CLK_CLKSEL2_PWM1CH23SEL_Msk      (0x7ul << CLK_CLKSEL2_PWM1CH23SEL_Pos)            /*!< CLK_T::CLKSEL2: PWM1CH23SEL Mask          */

#define CLK_CLKSEL2_PWM1CH45SEL_Pos      (20)                                              /*!< CLK_T::CLKSEL2: PWM1CH45SEL Position      */
#define CLK_CLKSEL2_PWM1CH45SEL_Msk      (0x7ul << CLK_CLKSEL2_PWM1CH45SEL_Pos)            /*!< CLK_T::CLKSEL2: PWM1CH45SEL Mask          */

#define CLK_CLKSEL3_SC0SEL_Pos           (0)                                               /*!< CLK_T::CLKSEL3: SC0SEL Position           */
#define CLK_CLKSEL3_SC0SEL_Msk           (0x3ul << CLK_CLKSEL3_SC0SEL_Pos)                 /*!< CLK_T::CLKSEL3: SC0SEL Mask               */

#define CLK_CLKSEL3_SC1SEL_Pos           (2)                                               /*!< CLK_T::CLKSEL3: SC1SEL Position           */
#define CLK_CLKSEL3_SC1SEL_Msk           (0x3ul << CLK_CLKSEL3_SC1SEL_Pos)                 /*!< CLK_T::CLKSEL3: SC1SEL Mask               */

#define CLK_CLKSEL3_SC2SEL_Pos           (4)                                               /*!< CLK_T::CLKSEL3: SC2SEL Position           */
#define CLK_CLKSEL3_SC2SEL_Msk           (0x3ul << CLK_CLKSEL3_SC2SEL_Pos)                 /*!< CLK_T::CLKSEL3: SC2SEL Mask               */

#define CLK_CLKSEL3_SC3SEL_Pos           (6)                                               /*!< CLK_T::CLKSEL3: SC3SEL Position           */
#define CLK_CLKSEL3_SC3SEL_Msk           (0x3ul << CLK_CLKSEL3_SC3SEL_Pos)                 /*!< CLK_T::CLKSEL3: SC3SEL Mask               */

#define CLK_CLKSEL3_SC4SEL_Pos           (8)                                               /*!< CLK_T::CLKSEL3: SC4SEL Position           */
#define CLK_CLKSEL3_SC4SEL_Msk           (0x3ul << CLK_CLKSEL3_SC4SEL_Pos)                 /*!< CLK_T::CLKSEL3: SC4SEL Mask               */

#define CLK_CLKSEL3_SC5SEL_Pos           (10)                                              /*!< CLK_T::CLKSEL3: SC5SEL Position           */
#define CLK_CLKSEL3_SC5SEL_Msk           (0x3ul << CLK_CLKSEL3_SC5SEL_Pos)                 /*!< CLK_T::CLKSEL3: SC5SEL Mask               */

#define CLK_CLKSEL3_I2S0SEL_Pos          (16)                                              /*!< CLK_T::CLKSEL3: I2S0SEL Position          */
#define CLK_CLKSEL3_I2S0SEL_Msk          (0x3ul << CLK_CLKSEL3_I2S0SEL_Pos)                /*!< CLK_T::CLKSEL3: I2S0SEL Mask              */

#define CLK_CLKSEL3_I2S1SEL_Pos          (18)                                              /*!< CLK_T::CLKSEL3: I2S1SEL Position          */
#define CLK_CLKSEL3_I2S1SEL_Msk          (0x3ul << CLK_CLKSEL3_I2S1SEL_Pos)                /*!< CLK_T::CLKSEL3: I2S1SEL Mask              */

#define CLK_CLKDIV0_HCLKDIV_Pos          (0)                                               /*!< CLK_T::CLKDIV0: HCLKDIV Position          */
#define CLK_CLKDIV0_HCLKDIV_Msk          (0xful << CLK_CLKDIV0_HCLKDIV_Pos)                /*!< CLK_T::CLKDIV0: HCLKDIV Mask              */

#define CLK_CLKDIV0_USBHDIV_Pos          (4)                                               /*!< CLK_T::CLKDIV0: USBHDIV Position          */
#define CLK_CLKDIV0_USBHDIV_Msk          (0xful << CLK_CLKDIV0_USBHDIV_Pos)                /*!< CLK_T::CLKDIV0: USBHDIV Mask              */

#define CLK_CLKDIV0_UARTDIV_Pos          (8)                                               /*!< CLK_T::CLKDIV0: UARTDIV Position          */
#define CLK_CLKDIV0_UARTDIV_Msk          (0xful << CLK_CLKDIV0_UARTDIV_Pos)                /*!< CLK_T::CLKDIV0: UARTDIV Mask              */

#define CLK_CLKDIV0_ADCDIV_Pos           (16)                                              /*!< CLK_T::CLKDIV0: ADCDIV Position           */
#define CLK_CLKDIV0_ADCDIV_Msk           (0xfful << CLK_CLKDIV0_ADCDIV_Pos)                /*!< CLK_T::CLKDIV0: ADCDIV Mask               */

#define CLK_CLKDIV0_SDHDIV_Pos           (24)                                              /*!< CLK_T::CLKDIV0: SDHDIV Position           */
#define CLK_CLKDIV0_SDHDIV_Msk           (0xfful << CLK_CLKDIV0_SDHDIV_Pos)                /*!< CLK_T::CLKDIV0: SDHDIV Mask               */

#define CLK_CLKDIV1_SC0DIV_Pos           (0)                                               /*!< CLK_T::CLKDIV1: SC0DIV Position           */
#define CLK_CLKDIV1_SC0DIV_Msk           (0xfful << CLK_CLKDIV1_SC0DIV_Pos)                /*!< CLK_T::CLKDIV1: SC0DIV Mask               */

#define CLK_CLKDIV1_SC1DIV_Pos           (8)                                               /*!< CLK_T::CLKDIV1: SC1DIV Position           */
#define CLK_CLKDIV1_SC1DIV_Msk           (0xfful << CLK_CLKDIV1_SC1DIV_Pos)                /*!< CLK_T::CLKDIV1: SC1DIV Mask               */

#define CLK_CLKDIV1_SC2DIV_Pos           (16)                                              /*!< CLK_T::CLKDIV1: SC2DIV Position           */
#define CLK_CLKDIV1_SC2DIV_Msk           (0xfful << CLK_CLKDIV1_SC2DIV_Pos)                /*!< CLK_T::CLKDIV1: SC2DIV Mask               */

#define CLK_CLKDIV1_SC3DIV_Pos           (24)                                              /*!< CLK_T::CLKDIV1: SC3DIV Position           */
#define CLK_CLKDIV1_SC3DIV_Msk           (0xfful << CLK_CLKDIV1_SC3DIV_Pos)                /*!< CLK_T::CLKDIV1: SC3DIV Mask               */

#define CLK_CLKDIV2_SC4DIV_Pos           (0)                                               /*!< CLK_T::CLKDIV2: SC4DIV Position           */
#define CLK_CLKDIV2_SC4DIV_Msk           (0xfful << CLK_CLKDIV2_SC4DIV_Pos)                /*!< CLK_T::CLKDIV2: SC4DIV Mask               */

#define CLK_CLKDIV2_SC5DIV_Pos           (8)                                               /*!< CLK_T::CLKDIV2: SC5DIV Position           */
#define CLK_CLKDIV2_SC5DIV_Msk           (0xfful << CLK_CLKDIV2_SC5DIV_Pos)                /*!< CLK_T::CLKDIV2: SC5DIV Mask               */

#define CLK_CLKDIV3_CAPDIV_Pos           (0)                                               /*!< CLK_T::CLKDIV3: CAPDIV Position          */
#define CLK_CLKDIV3_CAPDIV_Msk           (0xfful << CLK_CLKDIV3_CAPDIV_Pos)                /*!< CLK_T::CLKDIV3: CAPDIV Mask              */

#define CLK_CLKDIV3_VSENSEDIV_Pos        (8)                                               /*!< CLK_T::CLKDIV3: VSENSEDIV Position        */
#define CLK_CLKDIV3_VSENSEDIV_Msk        (0xfful << CLK_CLKDIV3_VSENSEDIV_Pos)             /*!< CLK_T::CLKDIV3: VSENSEDIV Mask            */

#define CLK_CLKDIV3_EMACDIV_Pos          (16)                                              /*!< CLK_T::CLKDIV3: EMACDIV Position          */
#define CLK_CLKDIV3_EMACDIV_Msk          (0xfful << CLK_CLKDIV3_EMACDIV_Pos)               /*!< CLK_T::CLKDIV3: EMACDIV Mask              */

#define CLK_PLLCTL_FBDIV_Pos             (0)                                               /*!< CLK_T::PLLCTL: FBDIV Position             */
#define CLK_PLLCTL_FBDIV_Msk             (0x1fful << CLK_PLLCTL_FBDIV_Pos)                 /*!< CLK_T::PLLCTL: FBDIV Mask                 */

#define CLK_PLLCTL_INDIV_Pos             (9)                                               /*!< CLK_T::PLLCTL: INDIV Position             */
#define CLK_PLLCTL_INDIV_Msk             (0x1ful << CLK_PLLCTL_INDIV_Pos)                  /*!< CLK_T::PLLCTL: INDIV Mask                 */

#define CLK_PLLCTL_OUTDV_Pos             (14)                                              /*!< CLK_T::PLLCTL: OUTDV Position             */
#define CLK_PLLCTL_OUTDV_Msk             (0x3ul << CLK_PLLCTL_OUTDV_Pos)                   /*!< CLK_T::PLLCTL: OUTDV Mask                 */

#define CLK_PLLCTL_PD_Pos                (16)                                              /*!< CLK_T::PLLCTL: PD Position                */
#define CLK_PLLCTL_PD_Msk                (0x1ul << CLK_PLLCTL_PD_Pos)                      /*!< CLK_T::PLLCTL: PD Mask                    */

#define CLK_PLLCTL_BP_Pos                (17)                                              /*!< CLK_T::PLLCTL: BP Position                */
#define CLK_PLLCTL_BP_Msk                (0x1ul << CLK_PLLCTL_BP_Pos)                      /*!< CLK_T::PLLCTL: BP Mask                    */

#define CLK_PLLCTL_OE_Pos                (18)                                              /*!< CLK_T::PLLCTL: OE Position                */
#define CLK_PLLCTL_OE_Msk                (0x1ul << CLK_PLLCTL_OE_Pos)                      /*!< CLK_T::PLLCTL: OE Mask                    */

#define CLK_PLLCTL_PLLSRC_Pos            (19)                                              /*!< CLK_T::PLLCTL: PLLSRC Position            */
#define CLK_PLLCTL_PLLSRC_Msk            (0x1ul << CLK_PLLCTL_PLLSRC_Pos)                  /*!< CLK_T::PLLCTL: PLLSRC Mask                */

#define CLK_PLLCTL_PLLREMAP_Pos          (20)                                              /*!< CLK_T::PLLCTL: PLLREMAP Position          */
#define CLK_PLLCTL_PLLREMAP_Msk          (0x1ul << CLK_PLLCTL_PLLREMAP_Pos)                /*!< CLK_T::PLLCTL: PLLREMAP Mask              */

#define CLK_PLL2CTL_PLL2DIV_Pos          (0)                                               /*!< CLK_T::PLL2CTL: PLL2DIV Position          */
#define CLK_PLL2CTL_PLL2DIV_Msk          (0xfful << CLK_PLL2CTL_PLL2DIV_Pos)               /*!< CLK_T::PLL2CTL: PLL2DIV Mask              */

#define CLK_PLL2CTL_PLL2CKEN_Pos         (8)                                               /*!< CLK_T::PLL2CTL: PLL2CKEN Position         */
#define CLK_PLL2CTL_PLL2CKEN_Msk         (0x1ul << CLK_PLL2CTL_PLL2CKEN_Pos)               /*!< CLK_T::PLL2CTL: PLL2CKEN Mask             */

#define CLK_STATUS_HXTSTB_Pos            (0)                                               /*!< CLK_T::STATUS: HXTSTB Position            */
#define CLK_STATUS_HXTSTB_Msk            (0x1ul << CLK_STATUS_HXTSTB_Pos)                  /*!< CLK_T::STATUS: HXTSTB Mask                */

#define CLK_STATUS_LXTSTB_Pos            (1)                                               /*!< CLK_T::STATUS: LXTSTB Position            */
#define CLK_STATUS_LXTSTB_Msk            (0x1ul << CLK_STATUS_LXTSTB_Pos)                  /*!< CLK_T::STATUS: LXTSTB Mask                */

#define CLK_STATUS_PLLSTB_Pos            (2)                                               /*!< CLK_T::STATUS: PLLSTB Position            */
#define CLK_STATUS_PLLSTB_Msk            (0x1ul << CLK_STATUS_PLLSTB_Pos)                  /*!< CLK_T::STATUS: PLLSTB Mask                */

#define CLK_STATUS_LIRCSTB_Pos           (3)                                               /*!< CLK_T::STATUS: LIRCSTB Position           */
#define CLK_STATUS_LIRCSTB_Msk           (0x1ul << CLK_STATUS_LIRCSTB_Pos)                 /*!< CLK_T::STATUS: LIRCSTB Mask               */

#define CLK_STATUS_HIRCSTB_Pos           (4)                                               /*!< CLK_T::STATUS: HIRCSTB Position           */
#define CLK_STATUS_HIRCSTB_Msk           (0x1ul << CLK_STATUS_HIRCSTB_Pos)                 /*!< CLK_T::STATUS: HIRCSTB Mask               */

#define CLK_STATUS_PLL2STB_Pos           (5)                                               /*!< CLK_T::STATUS: PLL2STB Position           */
#define CLK_STATUS_PLL2STB_Msk           (0x1ul << CLK_STATUS_PLL2STB_Pos)                 /*!< CLK_T::STATUS: PLL2STB Mask               */

#define CLK_STATUS_CLKSFAIL_Pos          (7)                                               /*!< CLK_T::STATUS: CLKSFAIL Position          */
#define CLK_STATUS_CLKSFAIL_Msk          (0x1ul << CLK_STATUS_CLKSFAIL_Pos)                /*!< CLK_T::STATUS: CLKSFAIL Mask              */

#define CLK_CLKOCTL_FSEL_Pos             (0)                                               /*!< CLK_T::CLKOCTL: FSEL Position             */
#define CLK_CLKOCTL_FSEL_Msk             (0xful << CLK_CLKOCTL_FSEL_Pos)                   /*!< CLK_T::CLKOCTL: FSEL Mask                 */

#define CLK_CLKOCTL_CLKOEN_Pos           (4)                                               /*!< CLK_T::CLKOCTL: CLKOEN Position           */
#define CLK_CLKOCTL_CLKOEN_Msk           (0x1ul << CLK_CLKOCTL_CLKOEN_Pos)                 /*!< CLK_T::CLKOCTL: CLKOEN Mask               */

#define CLK_CLKOCTL_DIV1EN_Pos           (5)                                               /*!< CLK_T::CLKOCTL: DIV1EN Position             */
#define CLK_CLKOCTL_DIV1EN_Msk           (0x1ul << CLK_CLKOCTL_DIV1EN_Pos)                 /*!< CLK_T::CLKOCTL: DIV1EN Mask                 */

#define CLK_CLKDCTL_SYSFDEN_Pos          (0)                                               /*!< CLK_T::CLKDCTL: SYSFDEN Position          */
#define CLK_CLKDCTL_SYSFDEN_Msk          (0x1ul << CLK_CLKDCTL_SYSFDEN_Pos)                /*!< CLK_T::CLKDCTL: SYSFDEN Mask              */

#define CLK_CLKDCTL_SYSFIEN_Pos          (1)                                               /*!< CLK_T::CLKDCTL: SYSFIEN Position          */
#define CLK_CLKDCTL_SYSFIEN_Msk          (0x1ul << CLK_CLKDCTL_SYSFIEN_Pos)                /*!< CLK_T::CLKDCTL: SYSFIEN Mask              */

#define CLK_CLKDCTL_SYSFIF_Pos           (2)                                               /*!< CLK_T::CLKDCTL: SYSFIF Position           */
#define CLK_CLKDCTL_SYSFIF_Msk           (0x1ul << CLK_CLKDCTL_SYSFIF_Pos)                 /*!< CLK_T::CLKDCTL: SYSFIF Mask               */

#define CLK_CLKDCTL_IRCDEN_Pos           (8)                                               /*!< CLK_T::CLKDCTL: IRCDEN Position           */
#define CLK_CLKDCTL_IRCDEN_Msk           (0x1ul << CLK_CLKDCTL_IRCDEN_Pos)                 /*!< CLK_T::CLKDCTL: IRCDEN Mask               */

#define CLK_CLKDCTL_IRCFIEN_Pos          (9)                                               /*!< CLK_T::CLKDCTL: IRCFIEN Position          */
#define CLK_CLKDCTL_IRCFIEN_Msk          (0x1ul << CLK_CLKDCTL_IRCFIEN_Pos)                /*!< CLK_T::CLKDCTL: IRCFIEN Mask              */

#define CLK_CLKDCTL_IRCFIF_Pos           (10)                                              /*!< CLK_T::CLKDCTL: IRCFIF Position           */
#define CLK_CLKDCTL_IRCFIF_Msk           (0x1ul << CLK_CLKDCTL_IRCFIF_Pos)                 /*!< CLK_T::CLKDCTL: IRCFIF Mask               */

/**@}*/ /* CLK_CONST */
/**@}*/ /* end of CLK register group */


/*---------------------- Cyclic Redundancy Check Controller -------------------------*/
/**
    @addtogroup CRC Cyclic Redundancy Check Controller(CRC)
    Memory Mapped Structure for CRC Controller
@{ */

typedef struct {


    /**
     * CTL
     * ===================================================================================================
     * Offset: 0x00  CRC Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |CRCEN     |CRC Channel Enable Control
     * |        |          |0 = CRC function Disabled.
     * |        |          |1 = CRC function Enabled.
     * |[1]     |CRCRST    |CRC Engine Reset
     * |        |          |0 = No effect.
     * |        |          |1 = Reset the internal CRC state machine and internal buffer.
     * |        |          |The contents of control register will not be cleared.
     * |        |          |This bit will automatically be cleared after few clock cycles.
     * |        |          |Note: Setting this bit will reload the initial seed value.
     * |[24]    |DATREV    |Write Data Order Reverse
     * |        |          |0 = No bit order reversed for CRC write data in.
     * |        |          |1 = Bit order reversed for CRC write data in (per byte).
     * |        |          |Note: If the write data is 0xAABBCCDD, the bit order reverse for CRC write data in is 0x55DD33BB
     * |[25]    |CHKSREV   |Checksum Reverse
     * |        |          |0 = No bit order reverse for CRC checksum.
     * |        |          |1 = Bit order reverse for CRC checksum.
     * |        |          |Note: If the checksum data is 0XDD7B0F2E, the bit order reversed for CRC checksum is 0x74F0DEBB.
     * |[26]    |DATFMT    |Write Data Complement
     * |        |          |0 = No bit order reversed for CRC write data in.
     * |        |          |1 = 1's complement for CRC write data in.
     * |[27]    |CHKSFMT   |Checksum Complement
     * |        |          |0 = No bit order reverse for CRC checksum.
     * |        |          |1 = 1's complement for CRC checksum.
     * |[28:29] |DATLEN    |CPU Write Data Length
     * |        |          |This field indicates the write data length.
     * |        |          |00 = Data length is 8-bit mode.
     * |        |          |01 = Data length is 16-bit mode.
     * |        |          |1x = Data length is 32-bit mode.
     * |        |          |Note: When the data length is 8-bit mode, the valid data is DATA [7:0]; if the data length is 16-bit mode, the valid data is DATA [15:0].
     * |[30:31] |CRCMODE   |CRC Polynomial Mode Selection
     * |        |          |00 = CRC-CCITT Polynomial mode.
     * |        |          |01 = CRC-8 Polynomial mode.
     * |        |          |10 = CRC-16 Polynomial mode.
     * |        |          |11 = CRC-32 Polynomial mode.
    */
    __IO uint32_t CTL;

    /**
     * DAT
     * ===================================================================================================
     * Offset: 0x04  CRC Write Data Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DATA      |CRC Write Data Bits
     * |        |          |Software can write data to this field to perform CRC operation, or uses PDMA function to get the data from memory
     * |        |          |Note1: The CRC_CTL [DATFMT] and CRC_CTL [DATREV] bit setting will affect this field; for example, if DATREV = 1, if the write data in DATA register is 0xAABBCCDD, the read data from DATA register will be 0x55DD33BB.
    */
    __IO uint32_t DAT;

    /**
     * SEED
     * ===================================================================================================
     * Offset: 0x08  CRC Seed Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SEED      |CRC Seed Bits
     * |        |          |This field indicates the CRC seed value.
    */
    __IO uint32_t SEED;

    /**
     * CHECKSUM
     * ===================================================================================================
     * Offset: 0x0C  CRC Checksum Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CHECKSUM  |CRC Checksum Bits
     * |        |          |This field indicates the CRC checksum.
    */
    __I  uint32_t CHECKSUM;

} CRC_T;

/**
    @addtogroup CRC_CONST CRC Bit Field Definition
    Constant Definitions for CRC Controller
@{ */

#define CRC_CTL_CRCEN_Pos                (0)                                               /*!< CRC_T::CTL: CRCEN Position                */
#define CRC_CTL_CRCEN_Msk                (0x1ul << CRC_CTL_CRCEN_Pos)                      /*!< CRC_T::CTL: CRCEN Mask                    */

#define CRC_CTL_CRCRST_Pos               (1)                                               /*!< CRC_T::CTL: CRCRST Position               */
#define CRC_CTL_CRCRST_Msk               (0x1ul << CRC_CTL_CRCRST_Pos)                     /*!< CRC_T::CTL: CRCRST Mask                   */

#define CRC_CTL_DATREV_Pos               (24)                                              /*!< CRC_T::CTL: DATREV Position               */
#define CRC_CTL_DATREV_Msk               (0x1ul << CRC_CTL_DATREV_Pos)                     /*!< CRC_T::CTL: DATREV Mask                   */

#define CRC_CTL_CHKSREV_Pos              (25)                                              /*!< CRC_T::CTL: CHKSREV Position            */
#define CRC_CTL_CHKSREV_Msk              (0x1ul << CRC_CTL_CHKSREV_Pos)                    /*!< CRC_T::CTL: CHKSREV Mask                */

#define CRC_CTL_DATFMT_Pos               (26)                                              /*!< CRC_T::CTL: DATFMT Position               */
#define CRC_CTL_DATFMT_Msk               (0x1ul << CRC_CTL_DATFMT_Pos)                     /*!< CRC_T::CTL: DATFMT Mask                   */

#define CRC_CTL_CHKSFMT_Pos              (27)                                              /*!< CRC_T::CTL: CHKSFMT Position            */
#define CRC_CTL_CHKSFMT_Msk              (0x1ul << CRC_CTL_CHKSFMT_Pos)                    /*!< CRC_T::CTL: CHKSFMT Mask                */

#define CRC_CTL_DATLEN_Pos               (28)                                              /*!< CRC_T::CTL: DATLEN Position               */
#define CRC_CTL_DATLEN_Msk               (0x3ul << CRC_CTL_DATLEN_Pos)                     /*!< CRC_T::CTL: DATLEN Mask                   */

#define CRC_CTL_CRCMODE_Pos              (30)                                              /*!< CRC_T::CTL: CRCMODE Position              */
#define CRC_CTL_CRCMODE_Msk              (0x3ul << CRC_CTL_CRCMODE_Pos)                    /*!< CRC_T::CTL: CRCMODE Mask                  */

#define CRC_DAT_DATA_Pos                 (0)                                               /*!< CRC_T::DAT: DATA Position                 */
#define CRC_DAT_DATA_Msk                 (0xfffffffful << CRC_DAT_DATA_Pos)                /*!< CRC_T::DAT: DATA Mask                     */

#define CRC_SEED_SEED_Pos                (0)                                               /*!< CRC_T::SEED: SEED Position                */
#define CRC_SEED_SEED_Msk                (0xfffffffful << CRC_SEED_SEED_Pos)               /*!< CRC_T::SEED: SEED Mask                    */

#define CRC_CHECKSUM_CHECKSUM_Pos        (0)                                               /*!< CRC_T::CHECKSUM: CHECKSUM Position        */
#define CRC_CHECKSUM_CHECKSUM_Msk        (0xfffffffful << CRC_CHECKSUM_CHECKSUM_Pos)       /*!< CRC_T::CHECKSUM: CHECKSUM Mask            */

/**@}*/ /* CRC_CONST */
/**@}*/ /* end of CRC register group */


/*---------------------- Cryptographic Accelerator -------------------------*/
/**
    @addtogroup CRPT Cryptographic Accelerator(CRPT)
    Memory Mapped Structure for CRPT Controller
@{ */

typedef struct {
    /**
     * INTEN
     * ===================================================================================================
     * Offset: 0x00  Crypto Interrupt Enable Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |AESIEN    |AES Interrupt Enable Control
     * |        |          |0 = AES interrupt Disabled.
     * |        |          |1 = AES interrupt Enabled.
     * |        |          |In DMA mode, an interrupt will be triggered when amount of data set in AES_DMA_CNT is fed into the AES engine.
     * |        |          |In Non-DMA mode, an interrupt will be triggered when the AES engine finishes the operation.
     * |[1]     |AESERRIEN |AES Error Flag Enable Control
     * |        |          |0 = AES error interrupt flag Disabled.
     * |        |          |1 = AES error interrupt flag Enabled.
     * |[8]     |TDESIEN   |TDES/DES Interrupt Enable Control
     * |        |          |0 = TDES/DES interrupt Disabled.
     * |        |          |1 = TDES/DES interrupt Enabled.
     * |        |          |In DMA mode, an interrupt will be triggered when amount of data set in TDES_DMA_CNT is fed into the TDES engine.
     * |        |          |In Non-DMA mode, an interrupt will be triggered when the TDES engine finishes the operation.
     * |[9]     |TDESERRIEN|TDES/DES Error Flag Enable Control
     * |        |          |0 = TDES/DES error interrupt flag Disabled.
     * |        |          |1 = TDES/DES error interrupt flag Enabled.
     * |[16]    |PRNGIEN   |PRNG Interrupt Enable Control
     * |        |          |0 = PRNG interrupt Disabled.
     * |        |          |1 = PRNG interrupt Enabled.
     * |[24]    |SHAIEN    |SHA Interrupt Enable Control
     * |        |          |0 = SHA interrupt Disabled.
     * |        |          |1 = SHA interrupt Enabled.
     * |        |          |In DMA mode, an interrupt will be triggered when amount of data set in SHA _DMA_CNT is fed into the SHA engine.
     * |        |          |In Non-DMA mode, an interrupt will be triggered when the SHA engine finishes the operation.
     * |[25]    |SHAERRIEN |SHA Error Interrupt Enable Control
     * |        |          |0 = SHA error interrupt flag Disabled.
     * |        |          |1 = SHA error interrupt flag Enabled.
    */
    __IO uint32_t INTEN;

    /**
     * INTSTS
     * ===================================================================================================
     * Offset: 0x04  Crypto Interrupt Flag
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |AESIF     |AES Finish Interrupt Flag
     * |        |          |This bit is cleared by writing 1, and it has no effect by writing 0.
     * |        |          |0 = No AES interrupt.
     * |        |          |1 = AES encryption/decryption done interrupt.
     * |[1]     |AESERRIF  |AES Error Flag
     * |        |          |This bit is cleared by writing 1, and it has no effect by writing 0.
     * |        |          |0 = No AES error.
     * |        |          |1 = AES encryption/decryption done interrupt.
     * |[8]     |TDESIF    |TDES/DES Finish Interrupt Flag
     * |        |          |This bit is cleared by writing 1, and it has no effect by writing 0.
     * |        |          |0 = No TDES/DES interrupt.
     * |        |          |1 = TDES/DES encryption/decryption done interrupt.
     * |[9]     |TDESERRIF |TDES/DES Error Flag
     * |        |          |This bit includes the operating and setting error.
     * |        |          |The detailed flag is shown in the TDES _FLAG register.
     * |        |          |This includes operating and setting error.
     * |        |          |This bit is cleared by writing 1, and it has no effect by writing 0.
     * |        |          |0 = No TDES/DES error.
     * |        |          |1 = TDES/DES encryption/decryption error interrupt.
     * |[16]    |PRNGIF    |PRNG Finish Interrupt Flag
     * |        |          |This bit is cleared by writing 1, and it has no effect by writing 0.
     * |        |          |0 = No PRNG interrupt.
     * |        |          |1 = PRNG key generation done interrupt.
     * |[24]    |SHAIF     |SHA Finish Interrupt Flag
     * |        |          |This bit is cleared by writing 1, and it has no effect by writing 0.
     * |        |          |0 = No SHA interrupt.
     * |        |          |1 = SHA operation done interrupt.
     * |[25]    |SHAERRIF  |SHA Error Flag
     * |        |          |This register includes operating and setting error. The detail flag is shown in SHA _FLAG register.
     * |        |          |This bit is cleared by writing 1, and it has no effect by writing 0.
     * |        |          |0 = No SHA error.
     * |        |          |1 = SHA error interrupt.
    */
    __IO uint32_t INTSTS;

    /**
     * PRNG_CTL
     * ===================================================================================================
     * Offset: 0x08  PRNG Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |START     |Start PRNG Engine
     * |        |          |0 = Stop PRNG engine.
     * |        |          |1 = Generate new key and store the new key to register CRPT_PRNG_KEYx , which will be cleared when the new key is generated.
     * |[1]     |SEEDRLD   |Reload New Seed For PRNG Engine
     * |        |          |0 = Generating key based on the current seed.
     * |        |          |1 = Reload new seed.
     * |[2:3]   |KEYSZ     |PRNG Generate Key Size
     * |        |          |00 = 64 bits.
     * |        |          |01 = 128 bits.
     * |        |          |10 = 192 bits.
     * |        |          |11 = 256 bits.
     * |[8]     |BUSY      |PRNG Busy (Read Only)
     * |        |          |0 = PRNG engine is idle.
     * |        |          |1 = Indicate that the PRNG engine is generating CRPT_PRNG_KEYx.
    */
    __IO uint32_t PRNG_CTL;

    /**
     * PRNG_SEED
     * ===================================================================================================
     * Offset: 0x0C  Seed for PRNG
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CRPT_PRNG_SEED|Seed For PRNG (Write Only)
     * |        |          |The bits store the seed for PRNG engine.
    */
    __O  uint32_t PRNG_SEED;

    /**
     * PRNG_KEY0
     * ===================================================================================================
     * Offset: 0x10  PRNG Generated Key0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYx      |Store PRNG Generated Key (Read Only)
     * |        |          |The bits store the key that is generated by PRNG.
    */
    __I  uint32_t PRNG_KEY0;

    /**
     * PRNG_KEY1
     * ===================================================================================================
     * Offset: 0x14  PRNG Generated Key1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYx      |Store PRNG Generated Key (Read Only)
     * |        |          |The bits store the key that is generated by PRNG.
    */
    __I  uint32_t PRNG_KEY1;

    /**
     * PRNG_KEY2
     * ===================================================================================================
     * Offset: 0x18  PRNG Generated Key2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYx      |Store PRNG Generated Key (Read Only)
     * |        |          |The bits store the key that is generated by PRNG.
    */
    __I  uint32_t PRNG_KEY2;

    /**
     * PRNG_KEY3
     * ===================================================================================================
     * Offset: 0x1C  PRNG Generated Key3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYx      |Store PRNG Generated Key (Read Only)
     * |        |          |The bits store the key that is generated by PRNG.
    */
    __I  uint32_t PRNG_KEY3;

    /**
     * PRNG_KEY4
     * ===================================================================================================
     * Offset: 0x20  PRNG Generated Key4
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYx      |Store PRNG Generated Key (Read Only)
     * |        |          |The bits store the key that is generated by PRNG.
    */
    __I  uint32_t PRNG_KEY4;

    /**
     * PRNG_KEY5
     * ===================================================================================================
     * Offset: 0x24  PRNG Generated Key5
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYx      |Store PRNG Generated Key (Read Only)
     * |        |          |The bits store the key that is generated by PRNG.
    */
    __I  uint32_t PRNG_KEY5;

    /**
     * PRNG_KEY6
     * ===================================================================================================
     * Offset: 0x28  PRNG Generated Key6
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYx      |Store PRNG Generated Key (Read Only)
     * |        |          |The bits store the key that is generated by PRNG.
    */
    __I  uint32_t PRNG_KEY6;

    /**
     * PRNG_KEY7
     * ===================================================================================================
     * Offset: 0x2C  PRNG Generated Key7
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYx      |Store PRNG Generated Key (Read Only)
     * |        |          |The bits store the key that is generated by PRNG.
    */
    __I  uint32_t PRNG_KEY7;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE0[8];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * AES_FDBCK0
     * ===================================================================================================
     * Offset: 0x50  AES Engine Output Feedback Data after Cryptographic Operation
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |FDBCK     |AES Feedback Information
     * |        |          |The feedback value is 128 bits in size.
     * |        |          |The AES engine uses the data from AES_FEEEDBACK as the data inputted to AES_IV for the next block in DMA cascade mode.
     * |        |          |The AES engine outputs feedback information for IV in the next block's operation.
     * |        |          |Software can use this feedback information to implement more than four DMA channels.
     * |        |          |Software can store that feedback value temporarily.
     * |        |          |After switching back, fill the stored feedback value to this register in the same channel operation, and then continue the operation with the original setting.
    */
    __I  uint32_t AES_FDBCK0;

    /**
     * AES_FDBCK1
     * ===================================================================================================
     * Offset: 0x54  AES Engine Output Feedback Data after Cryptographic Operation
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |FDBCK     |AES Feedback Information
     * |        |          |The feedback value is 128 bits in size.
     * |        |          |The AES engine uses the data from AES_FEEEDBACK as the data inputted to AES_IV for the next block in DMA cascade mode.
     * |        |          |The AES engine outputs feedback information for IV in the next block's operation.
     * |        |          |Software can use this feedback information to implement more than four DMA channels.
     * |        |          |Software can store that feedback value temporarily.
     * |        |          |After switching back, fill the stored feedback value to this register in the same channel operation, and then continue the operation with the original setting.
    */
    __I  uint32_t AES_FDBCK1;

    /**
     * AES_FDBCK2
     * ===================================================================================================
     * Offset: 0x58  AES Engine Output Feedback Data after Cryptographic Operation
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |FDBCK     |AES Feedback Information
     * |        |          |The feedback value is 128 bits in size.
     * |        |          |The AES engine uses the data from AES_FEEEDBACK as the data inputted to AES_IV for the next block in DMA cascade mode.
     * |        |          |The AES engine outputs feedback information for IV in the next block's operation.
     * |        |          |Software can use this feedback information to implement more than four DMA channels.
     * |        |          |Software can store that feedback value temporarily.
     * |        |          |After switching back, fill the stored feedback value to this register in the same channel operation, and then continue the operation with the original setting.
    */
    __I  uint32_t AES_FDBCK2;

    /**
     * AES_FDBCK3
     * ===================================================================================================
     * Offset: 0x5C  AES Engine Output Feedback Data after Cryptographic Operation
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |FDBCK     |AES Feedback Information
     * |        |          |The feedback value is 128 bits in size.
     * |        |          |The AES engine uses the data from AES_FEEEDBACK as the data inputted to AES_IV for the next block in DMA cascade mode.
     * |        |          |The AES engine outputs feedback information for IV in the next block's operation.
     * |        |          |Software can use this feedback information to implement more than four DMA channels.
     * |        |          |Software can store that feedback value temporarily.
     * |        |          |After switching back, fill the stored feedback value to this register in the same channel operation, and then continue the operation with the original setting.
    */
    __I  uint32_t AES_FDBCK3;

    /**
     * TDES_FDBCKH
     * ===================================================================================================
     * Offset: 0x60  TDES/DES Engine Output Feedback High Word Data after Cryptographic Operation
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |FDBCK     |TDES/DES Feedback
     * |        |          |The feedback value is 64 bits in size.
     * |        |          |The TDES/DES engine uses the data from CRPT_TDES_FEEEDBACK as the data inputted to CRPT_TDES_IV for the next block in DMA cascade mode.
     * |        |          |The feedback register is for CBC, CFB, and OFB mode.
     * |        |          |TDES/DES engine outputs feedback information for IV in the next block's operation.
     * |        |          |Software can use this feedback information to implement more than four DMA channels.
     * |        |          |Software can store that feedback value temporarily.
     * |        |          |After switching back, fill the stored feedback value to this register in the same channel operation.
     * |        |          |Then can continue the operation with the original setting.
    */
    __I  uint32_t TDES_FDBCKH;

    /**
     * TDES_FDBCKL
     * ===================================================================================================
     * Offset: 0x64  TDES/DES Engine Output Feedback Low Word Data after Cryptographic Operation
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |FDBCK     |TDES/DES Feedback
     * |        |          |The feedback value is 64 bits in size.
     * |        |          |The TDES/DES engine uses the data from CRPT_TDES_FEEEDBACK as the data inputted to CRPT_TDES_IV for the next block in DMA cascade mode.
     * |        |          |The feedback register is for CBC, CFB, and OFB mode.
     * |        |          |TDES/DES engine outputs feedback information for IV in the next block's operation.
     * |        |          |Software can use this feedback information to implement more than four DMA channels.
     * |        |          |Software can store that feedback value temporarily.
     * |        |          |After switching back, fill the stored feedback value to this register in the same channel operation.
     * |        |          |Then can continue the operation with the original setting.
    */
    __I  uint32_t TDES_FDBCKL;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE1[38];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * AES_CTL
     * ===================================================================================================
     * Offset: 0x100  AES Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |START     |AES Engine Start
     * |        |          |0 = No effect.
     * |        |          |1 = Start AES engine. BUSY flag will be set.
     * |        |          |Note: This bit is always 0 when it's read back.
     * |[1]     |STOP      |AES Engine Stop
     * |        |          |0 = No effect.
     * |        |          |1 = Stop AES engine.
     * |        |          |Note: This bit is always 0 when it's read back.
     * |[2:3]   |KEYSZ     |AES Key Size
     * |        |          |This bit defines three different key size for AES operation.
     * |        |          |2'b00 = 128 bits key.
     * |        |          |2'b01 = 192 bits key.
     * |        |          |2'b10 = 256 bits key.
     * |        |          |2'b11 = Reserved.
     * |        |          |If the AES accelerator is operating and the corresponding flag BUSY is 1, updating this register has no effect.
     * |[5]     |DMALAST   |AES Last Block
     * |        |          |In DMA mode, this bit must be set as beginning the last DMA cascade round.
     * |        |          |In Non-DMA mode, this bit must be set when feeding in the last block of data in ECB, CBC, CTR, OFB, and CFB mode, and feeding in the (last-1) block of data at CBC-CS1, CBC-CS2, and CBC-CS3 mode.
     * |        |          |This bit is always 0 when it's read back. Must be written again once START is triggered.
     * |[6]     |DMACSCAD  |AES Engine DMA With Cascade Mode
     * |        |          |0 = DMA cascade function Disabled.
     * |        |          |1 = In DMA cascade mode, software can update DMA source address register, destination address register, and byte count register during a cascade operation, without finishing the accelerator operation.
     * |[7]     |DMAEN     |AES Engine DMA Enable Control
     * |        |          |0 = AES DMA engine Disabled.
     * |        |          |The AES engine operates in Non-DMA mode, and gets data from the port CRPT_AES_DATIN.
     * |        |          |1 = AES DMA engine Enabled.
     * |        |          |The AES engine operates in DMA mode, and data movement from/to the engine is done by DMA logic.
     * |[8:15]  |OPMODE    |AES Engine Operation Modes
     * |        |          |0x00 = ECB (Electronic Codebook Mode)
     * |        |          |0x01 = CBC (Cipher Block Chaining Mode).
     * |        |          |0x02 = CFB (Cipher Feedback Mode).
     * |        |          |0x03 = OFB (Output Feedback Mode).
     * |        |          |0x04 = CTR (Counter Mode).
     * |        |          |0x10 = CBC-CS1 (CBC Ciphertext-Stealing 1 Mode).
     * |        |          |0x11 = CBC-CS2 (CBC Ciphertext-Stealing 2 Mode).
     * |        |          |0x12 = CBC-CS3 (CBC Ciphertext-Stealing 3 Mode).
     * |[16]    |ENCRPT    |AES Encryption/Decryption
     * |        |          |0 = AES engine executes decryption operation.
     * |        |          |1 = AES engine executes encryption operation.
     * |[22]    |OUTSWAP   |AES Engine Output Data Swap
     * |        |          |0 = Keep the original order.
     * |        |          |1 = The order that CPU outputs data from the accelerator will be changed from {byte3, byte2, byte1, byte0} to {byte0, byte1, byte2, byte3}.
     * |[23]    |INSWAP    |AES Engine Input Data Swap
     * |        |          |0 = Keep the original order.
     * |        |          |1 = The order that CPU feeds data to the accelerator will be changed from {byte3, byte2, byte1, byte0} to {byte0, byte1, byte2, byte3}.
     * |[24:25] |CHANNEL   |AES Engine Working Channel
     * |        |          |00 = Current control register setting is for channel 0.
     * |        |          |01 = Current control register setting is for channel 1.
     * |        |          |10 = Current control register setting is for channel 2.
     * |        |          |11 = Current control register setting is for channel 3.
     * |[26:30] |KEYUNPRT  |Unprotect Key
     * |        |          |Writing 0 to CRPT_AES_CTL [31] and "10110" to CRPT_AES_CTL [30:26] is to unprotect the AES key.
     * |        |          |The KEYUNPRT can be read and written.
     * |        |          |When it is written as the AES engine is operating, BUSY flag is 1, there would be no effect on KEYUNPRT.
     * |[31]    |KEYPRT    |Protect Key
     * |        |          |Read as a flag to reflect KEYPRT.
     * |        |          |0 = No effect.
     * |        |          |1 = Protect the content of the AES key from reading.
     * |        |          |The return value for reading CRPT_AESn_KEYx is not the content of the registers CRPT_AESn_KEYx.
     * |        |          |Once it is set, it can be cleared by asserting KEYUNPRT.
     * |        |          |And the key content would be cleared as well.
    */
    __IO uint32_t AES_CTL;

    /**
     * AES_STS
     * ===================================================================================================
     * Offset: 0x104  AES Engine Flag
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |BUSY      |AES Engine Busy
     * |        |          |0 = The AES engine is idle or finished.
     * |        |          |1 = The AES engine is under processing.
     * |[8]     |INBUFEMPTY|AES Input Buffer Empty
     * |        |          |0 = There are some data in input buffer waiting for the AES engine to process.
     * |        |          |1 = AES input buffer is empty.
     * |        |          |Software needs to feed data to the AES engine.
     * |        |          |Otherwise, the AES engine will be pending to wait for input data.
     * |[9]     |INBUFFULL |AES Input Buffer Full Flag
     * |        |          |0 = AES input buffer is not full. Software can feed the data into the AES engine.
     * |        |          |1 = AES input buffer is full.
     * |        |          |Software cannot feed data to the AES engine.
     * |        |          |Otherwise, the flag INBUFERR will be set to 1.
     * |[10]    |INBUFERR  |AES Input Buffer Error Flag
     * |        |          |0 = No error.
     * |        |          |1 = Error happens during feeding data to the AES engine.
     * |[12]    |CNTERR    |AES_CNT Setting Error
     * |        |          |0 = No error in AES_CNT setting.
     * |        |          |1 = AES_CNT is not a multiply of 16 in ECB, CBC, CFB, OFB, and CTR mode.
     * |[16]    |OUTBUFEMPTY|AES Out Buffer Empty
     * |        |          |0 = AES output buffer is not empty. There are some valid data kept in output buffer.
     * |        |          |1 = AES output buffer is empty.
     * |        |          |Software cannot get data from AES_DATA_OUT.
     * |        |          |Otherwise, the flag OUTBUFERR will be set to 1 since the output buffer is empty.
     * |[17]    |OUTBUFFULL|AES Out Buffer Full Flag
     * |        |          |0 = AES output buffer is not full.
     * |        |          |1 = AES output buffer is full, and software needs to get data from AES_DATA_OUT.
     * |        |          |Otherwise, the AES engine will be pending since the output buffer is full.
     * |[18]    |OUTBUFERR |AES Out Buffer Error Flag
     * |        |          |0 = No error.
     * |        |          |1 = Error happens during getting the result from AES engine.
     * |[20]    |BUSERR    |AES DMA Access Bus Error Flag
     * |        |          |0 = No error.
     * |        |          |1 = Bus error will stop DMA operation and AES engine.
    */
    __I  uint32_t AES_STS;

    /**
     * AES_DATIN
     * ===================================================================================================
     * Offset: 0x108  AES Engine Data Input Port Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DATIN     |AES Engine Input Port
     * |        |          |CPU feeds data to AES engine through this port by checking CRPT_AES_STS. Feed data as INBUFFULL is 0.
    */
    __IO uint32_t AES_DATIN;

    /**
     * AES_DATOUT
     * ===================================================================================================
     * Offset: 0x10C  AES Engine Data Output Port Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DATOUT    |AES Engine Output Port
     * |        |          |CPU gets results from the AES engine through this port by checking CRPT_AES_STS.
     * |        |          |Get data as OUTBUFEMPTY is 0.
    */
    __I  uint32_t AES_DATOUT;

    /**
     * AES0_KEY0
     * ===================================================================================================
     * Offset: 0x110  AES Key Word 0 Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES0_KEY0;

    /**
     * AES0_KEY1
     * ===================================================================================================
     * Offset: 0x114  AES Key Word 1 Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES0_KEY1;

    /**
     * AES0_KEY2
     * ===================================================================================================
     * Offset: 0x118  AES Key Word 2 Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES0_KEY2;

    /**
     * AES0_KEY3
     * ===================================================================================================
     * Offset: 0x11C  AES Key Word 3 Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES0_KEY3;

    /**
     * AES0_KEY4
     * ===================================================================================================
     * Offset: 0x120  AES Key Word 4 Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES0_KEY4;

    /**
     * AES0_KEY5
     * ===================================================================================================
     * Offset: 0x124  AES Key Word 5 Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES0_KEY5;

    /**
     * AES0_KEY6
     * ===================================================================================================
     * Offset: 0x128  AES Key Word 6 Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES0_KEY6;

    /**
     * AES0_KEY7
     * ===================================================================================================
     * Offset: 0x12C  AES Key Word 7 Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES0_KEY7;

    /**
     * AES0_IV0
     * ===================================================================================================
     * Offset: 0x130  AES Initial Vector Word 0 Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES0_IV0;

    /**
     * AES0_IV1
     * ===================================================================================================
     * Offset: 0x134  AES Initial Vector Word 1 Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES0_IV1;

    /**
     * AES0_IV2
     * ===================================================================================================
     * Offset: 0x138  AES Initial Vector Word 2 Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES0_IV2;

    /**
     * AES0_IV3
     * ===================================================================================================
     * Offset: 0x13C  AES Initial Vector Word 3 Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES0_IV3;

    /**
     * AES0_SADDR
     * ===================================================================================================
     * Offset: 0x140  AES DMA Source Address Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SADDR     |AES DMA Source Address
     * |        |          |The AES accelerator supports DMA function to transfer the plain text between system memory and embedded FIFO.
     * |        |          |The AES_SADR keeps the source address of the data buffer where the source text is stored.
     * |        |          |Based on the source address, the AES accelerator can read the plain text from system memory and do AES operation.
     * |        |          |The start of source address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of AES_SADR are ignored.
     * |        |          |AES_SADR can be read and written.
     * |        |          |Writing to AES_SADR while the AES accelerator is operating doesn't affect the current AES operation.
     * |        |          |But the value of AES_SADR will be updated later on.
     * |        |          |Consequently, software can prepare the DMA source address for the next AES operation.
     * |        |          |In DMA mode, software can update the next AES_SADR before triggering START.
     * |        |          |The value of AES_SADR and AES_DADR can be the same.
    */
    __IO uint32_t AES0_SADDR;

    /**
     * AES0_DADDR
     * ===================================================================================================
     * Offset: 0x144  AES DMA Destination Address Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DADDR     |AES DMA Destination Address
     * |        |          |The AES accelerator supports DMA function to transfer the cipher text between system memory and embedded FIFO.
     * |        |          |The AES_DADR keeps the destination address of the data buffer where the engine output's text will be stored.
     * |        |          |Based on the destination address, the AES accelerator can write the cipher text back to system memory after the AES operation is finished.
     * |        |          |The start of destination address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of AES_DADR are ignored.
     * |        |          |AES_DADR can be read and written.
     * |        |          |Writing to AES_DADR while the AES accelerator is operating doesn't affect the current AES operation.
     * |        |          |But the value of AES_DADR will be updated later on.
     * |        |          |Consequently, software can prepare the destination address for the next AES operation.
     * |        |          |In DMA mode, software can update the next AES_DADR before triggering START.
     * |        |          |The value of AES_SADR and AES_DADR can be the same.
    */
    __IO uint32_t AES0_DADDR;

    /**
     * AES0_CNT
     * ===================================================================================================
     * Offset: 0x148  AES Byte Count Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CNT       |AES Byte Count
     * |        |          |The AES_CNT keeps the byte count of source text that is for the AES engine operating in DMA mode.
     * |        |          |The AES_CNT is 32-bit and the maximum of byte count is 4G bytes.
     * |        |          |AES_CNT can be read and written.
     * |        |          |Writing to AES_CNT while the AES accelerator is operating doesn't affect the current AES operation.
     * |        |          |But the value of AES_CNT will be updated later on.
     * |        |          |Consequently, software can prepare the byte count of data for the next AES operation.
     * |        |          |According to CBC-CS1, CBC-CS2, and CBC-CS3 standard, the count of operation data must be at least one block.
     * |        |          |Operations that are less than one block will output unexpected result.
     * |        |          |In Non-DMA ECB, CBC, CFB, OFB, and CTR mode, AES_CNT must be set as byte count for the last block of data before feeding in the last block of data.
     * |        |          |In Non-DMA CBC-CS1, CBC-CS2, and CBC-CS3 mode, AES_CNT must be set as byte count for the last two blocks of data before feeding in the last two blocks of data.
    */
    __IO uint32_t AES0_CNT;

    /**
     * AES1_KEY0
     * ===================================================================================================
     * Offset: 0x14C  AES Key Word 0 Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES1_KEY0;

    /**
     * AES1_KEY1
     * ===================================================================================================
     * Offset: 0x150  AES Key Word 1 Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES1_KEY1;

    /**
     * AES1_KEY2
     * ===================================================================================================
     * Offset: 0x154  AES Key Word 2 Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES1_KEY2;

    /**
     * AES1_KEY3
     * ===================================================================================================
     * Offset: 0x158  AES Key Word 3 Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES1_KEY3;

    /**
     * AES1_KEY4
     * ===================================================================================================
     * Offset: 0x15C  AES Key Word 4 Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES1_KEY4;

    /**
     * AES1_KEY5
     * ===================================================================================================
     * Offset: 0x160  AES Key Word 5 Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES1_KEY5;

    /**
     * AES1_KEY6
     * ===================================================================================================
     * Offset: 0x164  AES Key Word 6 Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES1_KEY6;

    /**
     * AES1_KEY7
     * ===================================================================================================
     * Offset: 0x168  AES Key Word 7 Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES1_KEY7;

    /**
     * AES1_IV0
     * ===================================================================================================
     * Offset: 0x16C  AES Initial Vector Word 0 Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES1_IV0;

    /**
     * AES1_IV1
     * ===================================================================================================
     * Offset: 0x170  AES Initial Vector Word 1 Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES1_IV1;

    /**
     * AES1_IV2
     * ===================================================================================================
     * Offset: 0x174  AES Initial Vector Word 2 Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES1_IV2;

    /**
     * AES1_IV3
     * ===================================================================================================
     * Offset: 0x178  AES Initial Vector Word 3 Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES1_IV3;

    /**
     * AES1_SADDR
     * ===================================================================================================
     * Offset: 0x17C  AES DMA Source Address Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SADDR     |AES DMA Source Address
     * |        |          |The AES accelerator supports DMA function to transfer the plain text between system memory and embedded FIFO.
     * |        |          |The AES_SADR keeps the source address of the data buffer where the source text is stored.
     * |        |          |Based on the source address, the AES accelerator can read the plain text from system memory and do AES operation.
     * |        |          |The start of source address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of AES_SADR are ignored.
     * |        |          |AES_SADR can be read and written.
     * |        |          |Writing to AES_SADR while the AES accelerator is operating doesn't affect the current AES operation.
     * |        |          |But the value of AES_SADR will be updated later on.
     * |        |          |Consequently, software can prepare the DMA source address for the next AES operation.
     * |        |          |In DMA mode, software can update the next AES_SADR before triggering START.
     * |        |          |The value of AES_SADR and AES_DADR can be the same.
    */
    __IO uint32_t AES1_SADDR;

    /**
     * AES1_DADDR
     * ===================================================================================================
     * Offset: 0x180  AES DMA Destination Address Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DADDR     |AES DMA Destination Address
     * |        |          |The AES accelerator supports DMA function to transfer the cipher text between system memory and embedded FIFO.
     * |        |          |The AES_DADR keeps the destination address of the data buffer where the engine output's text will be stored.
     * |        |          |Based on the destination address, the AES accelerator can write the cipher text back to system memory after the AES operation is finished.
     * |        |          |The start of destination address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of AES_DADR are ignored.
     * |        |          |AES_DADR can be read and written.
     * |        |          |Writing to AES_DADR while the AES accelerator is operating doesn't affect the current AES operation.
     * |        |          |But the value of AES_DADR will be updated later on.
     * |        |          |Consequently, software can prepare the destination address for the next AES operation.
     * |        |          |In DMA mode, software can update the next AES_DADR before triggering START.
     * |        |          |The value of AES_SADR and AES_DADR can be the same.
    */
    __IO uint32_t AES1_DADDR;

    /**
     * AES1_CNT
     * ===================================================================================================
     * Offset: 0x184  AES Byte Count Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CNT       |AES Byte Count
     * |        |          |The AES_CNT keeps the byte count of source text that is for the AES engine operating in DMA mode.
     * |        |          |The AES_CNT is 32-bit and the maximum of byte count is 4G bytes.
     * |        |          |AES_CNT can be read and written.
     * |        |          |Writing to AES_CNT while the AES accelerator is operating doesn't affect the current AES operation.
     * |        |          |But the value of AES_CNT will be updated later on.
     * |        |          |Consequently, software can prepare the byte count of data for the next AES operation.
     * |        |          |According to CBC-CS1, CBC-CS2, and CBC-CS3 standard, the count of operation data must be at least one block.
     * |        |          |Operations that are less than one block will output unexpected result.
     * |        |          |In Non-DMA ECB, CBC, CFB, OFB, and CTR mode, AES_CNT must be set as byte count for the last block of data before feeding in the last block of data.
     * |        |          |In Non-DMA CBC-CS1, CBC-CS2, and CBC-CS3 mode, AES_CNT must be set as byte count for the last two blocks of data before feeding in the last two blocks of data.
    */
    __IO uint32_t AES1_CNT;

    /**
     * AES2_KEY0
     * ===================================================================================================
     * Offset: 0x188  AES Key Word 0 Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES2_KEY0;

    /**
     * AES2_KEY1
     * ===================================================================================================
     * Offset: 0x18C  AES Key Word 1 Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES2_KEY1;

    /**
     * AES2_KEY2
     * ===================================================================================================
     * Offset: 0x190  AES Key Word 2 Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES2_KEY2;

    /**
     * AES2_KEY3
     * ===================================================================================================
     * Offset: 0x194  AES Key Word 3 Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES2_KEY3;

    /**
     * AES2_KEY4
     * ===================================================================================================
     * Offset: 0x198  AES Key Word 4 Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES2_KEY4;

    /**
     * AES2_KEY5
     * ===================================================================================================
     * Offset: 0x19C  AES Key Word 5 Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES2_KEY5;

    /**
     * AES2_KEY6
     * ===================================================================================================
     * Offset: 0x1A0  AES Key Word 6 Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES2_KEY6;

    /**
     * AES2_KEY7
     * ===================================================================================================
     * Offset: 0x1A4  AES Key Word 7 Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES2_KEY7;

    /**
     * AES2_IV0
     * ===================================================================================================
     * Offset: 0x1A8  AES Initial Vector Word 0 Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES2_IV0;

    /**
     * AES2_IV1
     * ===================================================================================================
     * Offset: 0x1AC  AES Initial Vector Word 1 Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES2_IV1;

    /**
     * AES2_IV2
     * ===================================================================================================
     * Offset: 0x1B0  AES Initial Vector Word 2 Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES2_IV2;

    /**
     * AES2_IV3
     * ===================================================================================================
     * Offset: 0x1B4  AES Initial Vector Word 3 Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES2_IV3;

    /**
     * AES2_SADDR
     * ===================================================================================================
     * Offset: 0x1B8  AES DMA Source Address Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SADDR     |AES DMA Source Address
     * |        |          |The AES accelerator supports DMA function to transfer the plain text between system memory and embedded FIFO.
     * |        |          |The AES_SADR keeps the source address of the data buffer where the source text is stored.
     * |        |          |Based on the source address, the AES accelerator can read the plain text from system memory and do AES operation.
     * |        |          |The start of source address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of AES_SADR are ignored.
     * |        |          |AES_SADR can be read and written.
     * |        |          |Writing to AES_SADR while the AES accelerator is operating doesn't affect the current AES operation.
     * |        |          |But the value of AES_SADR will be updated later on.
     * |        |          |Consequently, software can prepare the DMA source address for the next AES operation.
     * |        |          |In DMA mode, software can update the next AES_SADR before triggering START.
     * |        |          |The value of AES_SADR and AES_DADR can be the same.
    */
    __IO uint32_t AES2_SADDR;

    /**
     * AES2_DADDR
     * ===================================================================================================
     * Offset: 0x1BC  AES DMA Destination Address Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DADDR     |AES DMA Destination Address
     * |        |          |The AES accelerator supports DMA function to transfer the cipher text between system memory and embedded FIFO.
     * |        |          |The AES_DADR keeps the destination address of the data buffer where the engine output's text will be stored.
     * |        |          |Based on the destination address, the AES accelerator can write the cipher text back to system memory after the AES operation is finished.
     * |        |          |The start of destination address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of AES_DADR are ignored.
     * |        |          |AES_DADR can be read and written.
     * |        |          |Writing to AES_DADR while the AES accelerator is operating doesn't affect the current AES operation.
     * |        |          |But the value of AES_DADR will be updated later on.
     * |        |          |Consequently, software can prepare the destination address for the next AES operation.
     * |        |          |In DMA mode, software can update the next AES_DADR before triggering START.
     * |        |          |The value of AES_SADR and AES_DADR can be the same.
    */
    __IO uint32_t AES2_DADDR;

    /**
     * AES2_CNT
     * ===================================================================================================
     * Offset: 0x1C0  AES Byte Count Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CNT       |AES Byte Count
     * |        |          |The AES_CNT keeps the byte count of source text that is for the AES engine operating in DMA mode.
     * |        |          |The AES_CNT is 32-bit and the maximum of byte count is 4G bytes.
     * |        |          |AES_CNT can be read and written.
     * |        |          |Writing to AES_CNT while the AES accelerator is operating doesn't affect the current AES operation.
     * |        |          |But the value of AES_CNT will be updated later on.
     * |        |          |Consequently, software can prepare the byte count of data for the next AES operation.
     * |        |          |According to CBC-CS1, CBC-CS2, and CBC-CS3 standard, the count of operation data must be at least one block.
     * |        |          |Operations that are less than one block will output unexpected result.
     * |        |          |In Non-DMA ECB, CBC, CFB, OFB, and CTR mode, AES_CNT must be set as byte count for the last block of data before feeding in the last block of data.
     * |        |          |In Non-DMA CBC-CS1, CBC-CS2, and CBC-CS3 mode, AES_CNT must be set as byte count for the last two blocks of data before feeding in the last two blocks of data.
    */
    __IO uint32_t AES2_CNT;

    /**
     * AES3_KEY0
     * ===================================================================================================
     * Offset: 0x1C4  AES Key Word 0 Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES3_KEY0;

    /**
     * AES3_KEY1
     * ===================================================================================================
     * Offset: 0x1C8  AES Key Word 1 Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES3_KEY1;

    /**
     * AES3_KEY2
     * ===================================================================================================
     * Offset: 0x1CC  AES Key Word 2 Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES3_KEY2;

    /**
     * AES3_KEY3
     * ===================================================================================================
     * Offset: 0x1D0  AES Key Word 3 Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES3_KEY3;

    /**
     * AES3_KEY4
     * ===================================================================================================
     * Offset: 0x1D4  AES Key Word 4 Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES3_KEY4;

    /**
     * AES3_KEY5
     * ===================================================================================================
     * Offset: 0x1D8  AES Key Word 5 Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES3_KEY5;

    /**
     * AES3_KEY6
     * ===================================================================================================
     * Offset: 0x1DC  AES Key Word 6 Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES3_KEY6;

    /**
     * AES3_KEY7
     * ===================================================================================================
     * Offset: 0x1E0  AES Key Word 7 Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |AES Key X
     * |        |          |The KEY keeps the security key for AES operation.
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..7.
     * |        |          |The security key for AES accelerator can be 128, 192, or 256 bits and four, six, or eight 32-bit registers are to store each security key.
     * |        |          |{AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 128-bit security key for AES operation.
     * |        |          |{AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 192-bit security key for AES operation.
     * |        |          |{AES_KEY7, AES_KEY6, AES_KEY5, AES_KEY4, AES_KEY3, AES_KEY2, AES_KEY1, AES_KEY0} stores the 256-bit security key for AES operation.
    */
    __IO uint32_t AES3_KEY7;

    /**
     * AES3_IV0
     * ===================================================================================================
     * Offset: 0x1E4  AES Initial Vector Word 0 Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES3_IV0;

    /**
     * AES3_IV1
     * ===================================================================================================
     * Offset: 0x1E8  AES Initial Vector Word 1 Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES3_IV1;

    /**
     * AES3_IV2
     * ===================================================================================================
     * Offset: 0x1EC  AES Initial Vector Word 2 Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES3_IV2;

    /**
     * AES3_IV3
     * ===================================================================================================
     * Offset: 0x1F0  AES Initial Vector Word 3 Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IV        |AES Initial Vector Word X
     * |        |          |n = 0, 1..3.
     * |        |          |x = 0, 1..3.
     * |        |          |Four initial vectors (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) are for AES operating in CBC, CFB, and OFB mode.
     * |        |          |Four registers (AES_IV0, AES_IV1, AES_IV2, and AES_IV3) act as Nonce counter when the AES engine is operating in CTR mode.
    */
    __IO uint32_t AES3_IV3;

    /**
     * AES3_SADDR
     * ===================================================================================================
     * Offset: 0x1F4  AES DMA Source Address Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SADDR     |AES DMA Source Address
     * |        |          |The AES accelerator supports DMA function to transfer the plain text between system memory and embedded FIFO.
     * |        |          |The AES_SADR keeps the source address of the data buffer where the source text is stored.
     * |        |          |Based on the source address, the AES accelerator can read the plain text from system memory and do AES operation.
     * |        |          |The start of source address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of AES_SADR are ignored.
     * |        |          |AES_SADR can be read and written.
     * |        |          |Writing to AES_SADR while the AES accelerator is operating doesn't affect the current AES operation.
     * |        |          |But the value of AES_SADR will be updated later on.
     * |        |          |Consequently, software can prepare the DMA source address for the next AES operation.
     * |        |          |In DMA mode, software can update the next AES_SADR before triggering START.
     * |        |          |The value of AES_SADR and AES_DADR can be the same.
    */
    __IO uint32_t AES3_SADDR;

    /**
     * AES3_DADDR
     * ===================================================================================================
     * Offset: 0x1F8  AES DMA Destination Address Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DADDR     |AES DMA Destination Address
     * |        |          |The AES accelerator supports DMA function to transfer the cipher text between system memory and embedded FIFO.
     * |        |          |The AES_DADR keeps the destination address of the data buffer where the engine output's text will be stored.
     * |        |          |Based on the destination address, the AES accelerator can write the cipher text back to system memory after the AES operation is finished.
     * |        |          |The start of destination address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of AES_DADR are ignored.
     * |        |          |AES_DADR can be read and written.
     * |        |          |Writing to AES_DADR while the AES accelerator is operating doesn't affect the current AES operation.
     * |        |          |But the value of AES_DADR will be updated later on.
     * |        |          |Consequently, software can prepare the destination address for the next AES operation.
     * |        |          |In DMA mode, software can update the next AES_DADR before triggering START.
     * |        |          |The value of AES_SADR and AES_DADR can be the same.
    */
    __IO uint32_t AES3_DADDR;

    /**
     * AES3_CNT
     * ===================================================================================================
     * Offset: 0x1FC  AES Byte Count Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CNT       |AES Byte Count
     * |        |          |The AES_CNT keeps the byte count of source text that is for the AES engine operating in DMA mode.
     * |        |          |The AES_CNT is 32-bit and the maximum of byte count is 4G bytes.
     * |        |          |AES_CNT can be read and written.
     * |        |          |Writing to AES_CNT while the AES accelerator is operating doesn't affect the current AES operation.
     * |        |          |But the value of AES_CNT will be updated later on.
     * |        |          |Consequently, software can prepare the byte count of data for the next AES operation.
     * |        |          |According to CBC-CS1, CBC-CS2, and CBC-CS3 standard, the count of operation data must be at least one block.
     * |        |          |Operations that are less than one block will output unexpected result.
     * |        |          |In Non-DMA ECB, CBC, CFB, OFB, and CTR mode, AES_CNT must be set as byte count for the last block of data before feeding in the last block of data.
     * |        |          |In Non-DMA CBC-CS1, CBC-CS2, and CBC-CS3 mode, AES_CNT must be set as byte count for the last two blocks of data before feeding in the last two blocks of data.
    */
    __IO uint32_t AES3_CNT;

    /**
     * TDES_CTL
     * ===================================================================================================
     * Offset: 0x200  TDES/DES Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |START     |TDES/DES Engine Start
     * |        |          |0 = No effect.
     * |        |          |1 = Start TDES/DES engine. The flag BUSY would be set.
     * |        |          |Note: The bit is always 0 when it's read back.
     * |[1]     |STOP      |TDES/DES Engine Stop
     * |        |          |0 = No effect.
     * |        |          |1 = Stop TDES/DES engine.
     * |        |          |Note: The bit is always 0 when it's read back.
     * |[2]     |TMODE     |TDES/DES Engine Operating Mode
     * |        |          |0 = Set DES mode for TDES/DES engine.
     * |        |          |1 = Set Triple DES mode for TDES/DES engine.
     * |[3]     |3KEYS     |TDES/DES Key Number
     * |        |          |0 = Select KEY1 and KEY2 in TDES/DES engine.
     * |        |          |1 = Triple keys in TDES/DES engine Enabled.
     * |[5]     |DMALAST   |TDES/DES Engine Start For The Last Block
     * |        |          |In DMA mode, this bit must be set as beginning the last DMA cascade round.
     * |        |          |In Non-DMA mode, this bit must be set as feeding in last block of data.
     * |[6]     |DMACSCAD  |TDES/DES Engine DMA With Cascade Mode
     * |        |          |0 = DMA cascade function Disabled.
     * |        |          |1 = In DMA Cascade mode, software can update DMA source address register, destination address register, and byte count register during a cascade operation, without finishing the accelerator operation.
     * |[7]     |DMAEN     |TDES/DES Engine DMA Enable Control
     * |        |          |0 = TDES_DMA engine Disabled.
     * |        |          |TDES engine operates in Non-DMA mode, and get data from the port CRPT_TDES_DATIN.
     * |        |          |1 = TDES_DMA engine Enabled.
     * |        |          |TDES engine operates in DMA mode, and data movement from/to the engine is done by DMA logic.
     * |[8:10]  |OPMODE    |TDES/DES Engine Operation Mode
     * |        |          |0x00 = ECB (Electronic Codebook Mode).
     * |        |          |0x01 = CBC (Cipher Block Chaining Mode).
     * |        |          |0x02 = CFB (Cipher Feedback Mode).
     * |        |          |0x03 = OFB (Output Feedback Mode).
     * |        |          |0x04 = CTR (Counter Mode).
     * |        |          |Others = CTR (Counter Mode).
     * |[16]    |ENCRPT    |TDES/DES Encryption/Decryption
     * |        |          |0 = TDES engine executes decryption operation.
     * |        |          |1 = TDES engine executes encryption operation.
     * |[21]    |BLKSWAP   |TDES/DES Engine Block Double Word Endian Swap
     * |        |          |0 = Keep the original order, e.g. {WORD_H, WORD_L}.
     * |        |          |1 = When this bit is set to 1, the TDES engine would exchange high and low word in the sequence {WORD_L, WORD_H}.
     * |[22]    |OUTSWAP   |TDES/DES Engine Output Data Swap
     * |        |          |0 = Keep the original order.
     * |        |          |1 = The order that CPU outputs data from the accelerator will be changed from {byte3, byte2, byte1, byte0} to {byte0, byte1, byte2, byte3}.
     * |[23]    |INSWAP    |TDES/DES Engine Input Data Swap
     * |        |          |0 = Keep the original order.
     * |        |          |1 = The order that CPU feeds data to the accelerator will be changed from {byte3, byte2, byte1, byte0} to {byte0, byte1, byte2, byte3}.
     * |[24:25] |CHANNEL   |TDES/DES Engine Working Channel
     * |        |          |00 = Current control register setting is for channel 0.
     * |        |          |01 = Current control register setting is for channel 1.
     * |        |          |10 = Current control register setting is for channel 2.
     * |        |          |11 = Current control register setting is for channel 3.
     * |[26:30] |KEYUNPRT  |Unprotected Key
     * |        |          |Writing 0 to CRPT_TDES_CTL [31] and "10110" to CRPT_TDES_CTL [30:26] is to unprotect TDES key.
     * |        |          |The KEYUNPRT can be read and written.
     * |        |          |When it is written as the TDES engine is operating, BUSY flag is 1, there would be no effect on KEYUNPRT.
     * |[31]    |KEYPRT    |Protect Key
     * |        |          |Read as a flag to reflect KEYPRT.
     * |        |          |0 = No effect.
     * |        |          |1 = This bit is to protect the content of TDES key from reading.
     * |        |          |The return value for reading CRPT_ TDESn_KEYxH/L is not the content in the registers CRPT_ TDESn_KEYxH/L.
     * |        |          |Once it is set, it can be cleared by asserting KEYUNPRT.
     * |        |          |The key content would be cleared as well.
    */
    __IO uint32_t TDES_CTL;

    /**
     * TDES_STS
     * ===================================================================================================
     * Offset: 0x204  TDES/DES Engine Flag
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |BUSY      |TDES/DES Engine Busy
     * |        |          |0 = TDES/DES engine is idle or finished.
     * |        |          |1 = TDES/DES engine is under processing.
     * |[8]     |INBUFEMPTY|TDES/DES In Buffer Empty
     * |        |          |0 = There are some data in input buffer waiting for the TDES/DES engine to process.
     * |        |          |1 = TDES/DES input buffer is empty.
     * |        |          |Software needs to feed data to the TDES/DES engine.
     * |        |          |Otherwise, the TDES/DES engine will be pending to wait for input data.
     * |[9]     |INBUFFULL |TDES/DES In Buffer Full Flag
     * |        |          |0 = TDES/DES input buffer is not full. Software can feed the data into the TDES/DES engine.
     * |        |          |1 = TDES input buffer is full.
     * |        |          |Software cannot feed data to the TDES/DES engine.
     * |        |          |Otherwise, the flag INBUFERR will be set to 1.
     * |[10]    |INBUFERR  |TDES/DES In Buffer Error Flag
     * |        |          |0 = No error.
     * |        |          |1 = Error happens during feeding data to the TDES/DES engine.
     * |[16]    |OUTBUFEMPTY|TDES/DES Output Buffer Empty Flag
     * |        |          |0 = TDES/DES output buffer is not empty. There are some valid data kept in output buffer.
     * |        |          |1 = TDES/DES output buffer is empty, Software cannot get data from TDES_DATA_OUT.
     * |        |          |Otherwise the flag OUTBUFERR will be set to 1, since output buffer is empty.
     * |[17]    |OUTBUFFULL|TDES/DES Output Buffer Full Flag
     * |        |          |0 = TDES/DES output buffer is not full.
     * |        |          |1 = TDES/DES output buffer is full, and software needs to get data from TDES_DATA_OUT.
     * |        |          |Otherwise, the TDES/DES engine will be pending since output buffer is full.
     * |[18]    |OUTBUFERR |TDES/DES Out Buffer Error Flag
     * |        |          |0 = No error.
     * |        |          |1 = Error happens during getting test result from TDES/DES engine.
     * |[20]    |BUSERR    |TDES/DES DMA Access Bus Error Flag
     * |        |          |0 = No error.
     * |        |          |1 = Bus error will stop DMA operation and TDES/DES engine.
    */
    __I  uint32_t TDES_STS;

    /**
     * TDES0_KEY1H
     * ===================================================================================================
     * Offset: 0x208  TDES/DES Key 1 High Word Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES0_KEY1H;

    /**
     * TDES0_KEY1L
     * ===================================================================================================
     * Offset: 0x20C  TDES/DES Key 1 Low Word Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES0_KEY1L;

    /**
     * TDES0_KEY2H
     * ===================================================================================================
     * Offset: 0x210  TDES Key 2 High Word Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES0_KEY2H;

    /**
     * TDES0_KEY2L
     * ===================================================================================================
     * Offset: 0x214  TDES Key 2 Low Word Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES0_KEY2L;

    /**
     * TDES0_KEY3H
     * ===================================================================================================
     * Offset: 0x218  TDES Key 3 High Word Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES0_KEY3H;

    /**
     * TDES0_KEY3L
     * ===================================================================================================
     * Offset: 0x21C  TDES Key 3 Low Word Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES0_KEY3L;

    /**
     * TDES0_IVH
     * ===================================================================================================
     * Offset: 0x220  TDES/DES Initial Vector High Word Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IVH_IVL   |TDES/DES Initial Vector High/Low Word
     * |        |          |Initial vector (IV) is for TDES/DES engine in CBC, CFB, and OFB mode.
     * |        |          |IV is Nonce counter for TDES/DES engine in CTR mode.
    */
    __IO uint32_t TDES0_IVH;

    /**
     * TDES0_IVL
     * ===================================================================================================
     * Offset: 0x224  TDES/DES Initial Vector Low Word Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IVH_IVL   |TDES/DES Initial Vector High/Low Word
     * |        |          |Initial vector (IV) is for TDES/DES engine in CBC, CFB, and OFB mode.
     * |        |          |IV is Nonce counter for TDES/DES engine in CTR mode.
    */
    __IO uint32_t TDES0_IVL;

    /**
     * TDES0_SADDR
     * ===================================================================================================
     * Offset: 0x228  TDES/DES DMA Source Address Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SADDR     |TDES/DES DMA Source Address
     * |        |          |The TDES/DES accelerator supports DMA function to transfer the plain text between system memory and embedded FIFO.
     * |        |          |The TDES_SADR keeps the source address of the data buffer where the source text is stored.
     * |        |          |Based on the source address, the TDES/DES accelerator can read the plain text from system memory and do TDES/DES operation.
     * |        |          |The start of source address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of TDES_SADR are ignored.
     * |        |          |TDES_SADR can be read and written.
     * |        |          |Writing to TDES_SADR while the TDES/DES accelerator is operating doesn't affect the current TDES/DES operation.
     * |        |          |But the value of TDES_SADR will be updated later on.
     * |        |          |Consequently, software can prepare the DMA source address for the next TDES/DES operation.
     * |        |          |In DMA mode, software can update the next TDES_SADR before triggering START.
     * |        |          |TDES_SADR and TDES_DADR can be the same in the value.
    */
    __IO uint32_t TDES0_SADDR;

    /**
     * TDES0_DADDR
     * ===================================================================================================
     * Offset: 0x22C  TDES/DES DMA Destination Address Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DADDR     |TDES/DES DMA Destination Address
     * |        |          |The TDES/DES accelerator supports DMA function to transfer the cipher text between system memory and embedded FIFO.
     * |        |          |The TDES_DADR keeps the destination address of the data buffer where the engine output's text will be stored.
     * |        |          |Based on the destination address, the TDES/DES accelerator can write the cipher text back to system memory after the TDES/DES operation is finished.
     * |        |          |The start of destination address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of TDES_DADR are ignored.
     * |        |          |TDES_DADR can be read and written.
     * |        |          |Writing to TDES_DADR while the TDES/DES accelerator is operating doesn't affect the current TDES/DES operation.
     * |        |          |But the value of TDES_DADR will be updated later on.
     * |        |          |Consequently, software can prepare the destination address for the next TDES/DES operation.
     * |        |          |In DMA mode, software can update the next TDES_DADR before triggering START.
     * |        |          |TDES_SADR and TDES_DADR can be the same in the value.
    */
    __IO uint32_t TDES0_DADDR;

    /**
     * TDES0_CNT
     * ===================================================================================================
     * Offset: 0x230  TDES/DES Byte Count Register for Channel 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CNT       |TDES/DES Byte Count
     * |        |          |The TDES_CNT keeps the byte count of source text that is for the TDES/DES engine operating in DMA mode.
     * |        |          |The TDES_CNT is 32-bit and the maximum of byte count is 4G bytes.
     * |        |          |TDES_CNT can be read and written.
     * |        |          |Writing to TDES_CNT while the TDES/DES accelerator is operating doesn't affect the current TDES/DES operation.
     * |        |          |But the value of TDES_CNT will be updated later on.
     * |        |          |Consequently, software can prepare the byte count of data for the next TDES /DES operation.
     * |        |          |In Non-DMA ECB, CBC, CFB, OFB, and CTR mode, TDES_CNT must be set as byte count for the last block of data before feeding in the last block of data.
    */
    __IO uint32_t TDES0_CNT;

    /**
     * TDES_DATIN
     * ===================================================================================================
     * Offset: 0x234  TDES/DES Engine Input data Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DATIN     |TDES/DES Engine Input Port
     * |        |          |CPU feeds data to TDES/DES engine through this port by checking CRPT_TDES_STS.
     * |        |          |Feed data as INBUFFULL is 0.
    */
    __IO uint32_t TDES_DATIN;

    /**
     * TDES_DATOUT
     * ===================================================================================================
     * Offset: 0x238  TDES/DES Engine Output data Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DATOUT    |TDES/DES Engine Output Port
     * |        |          |CPU gets result from the TDES/DES engine through this port by checking CRPT_TDES_STS.
     * |        |          |Get data as OUTBUFEMPTY is 0.
    */
    __I  uint32_t TDES_DATOUT;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE2[3];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * TDES1_KEY1H
     * ===================================================================================================
     * Offset: 0x248  TDES/DES Key 1 High Word Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES1_KEY1H;

    /**
     * TDES1_KEY1L
     * ===================================================================================================
     * Offset: 0x24C  TDES/DES Key 1 Low Word Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES1_KEY1L;

    /**
     * TDES1_KEY2H
     * ===================================================================================================
     * Offset: 0x250  TDES Key 2 High Word Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES1_KEY2H;

    /**
     * TDES1_KEY2L
     * ===================================================================================================
     * Offset: 0x254  TDES Key 2 Low Word Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES1_KEY2L;

    /**
     * TDES1_KEY3H
     * ===================================================================================================
     * Offset: 0x258  TDES Key 3 High Word Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES1_KEY3H;

    /**
     * TDES1_KEY3L
     * ===================================================================================================
     * Offset: 0x25C  TDES Key 3 Low Word Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES1_KEY3L;

    /**
     * TDES1_IVH
     * ===================================================================================================
     * Offset: 0x260  TDES/DES Initial Vector High Word Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IVH_IVL   |TDES/DES Initial Vector High/Low Word
     * |        |          |Initial vector (IV) is for TDES/DES engine in CBC, CFB, and OFB mode.
     * |        |          |IV is Nonce counter for TDES/DES engine in CTR mode.
    */
    __IO uint32_t TDES1_IVH;

    /**
     * TDES1_IVL
     * ===================================================================================================
     * Offset: 0x264  TDES/DES Initial Vector Low Word Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IVH_IVL   |TDES/DES Initial Vector High/Low Word
     * |        |          |Initial vector (IV) is for TDES/DES engine in CBC, CFB, and OFB mode.
     * |        |          |IV is Nonce counter for TDES/DES engine in CTR mode.
    */
    __IO uint32_t TDES1_IVL;

    /**
     * TDES1_SADDR
     * ===================================================================================================
     * Offset: 0x268  TDES/DES DMA Source Address Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SADDR     |TDES/DES DMA Source Address
     * |        |          |The TDES/DES accelerator supports DMA function to transfer the plain text between system memory and embedded FIFO.
     * |        |          |The TDES_SADR keeps the source address of the data buffer where the source text is stored.
     * |        |          |Based on the source address, the TDES/DES accelerator can read the plain text from system memory and do TDES/DES operation.
     * |        |          |The start of source address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of TDES_SADR are ignored.
     * |        |          |TDES_SADR can be read and written.
     * |        |          |Writing to TDES_SADR while the TDES/DES accelerator is operating doesn't affect the current TDES/DES operation.
     * |        |          |But the value of TDES_SADR will be updated later on.
     * |        |          |Consequently, software can prepare the DMA source address for the next TDES/DES operation.
     * |        |          |In DMA mode, software can update the next TDES_SADR before triggering START.
     * |        |          |TDES_SADR and TDES_DADR can be the same in the value.
    */
    __IO uint32_t TDES1_SADDR;

    /**
     * TDES1_DADDR
     * ===================================================================================================
     * Offset: 0x26C  TDES/DES DMA Destination Address Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DADDR     |TDES/DES DMA Destination Address
     * |        |          |The TDES/DES accelerator supports DMA function to transfer the cipher text between system memory and embedded FIFO.
     * |        |          |The TDES_DADR keeps the destination address of the data buffer where the engine output's text will be stored.
     * |        |          |Based on the destination address, the TDES/DES accelerator can write the cipher text back to system memory after the TDES/DES operation is finished.
     * |        |          |The start of destination address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of TDES_DADR are ignored.
     * |        |          |TDES_DADR can be read and written.
     * |        |          |Writing to TDES_DADR while the TDES/DES accelerator is operating doesn't affect the current TDES/DES operation.
     * |        |          |But the value of TDES_DADR will be updated later on.
     * |        |          |Consequently, software can prepare the destination address for the next TDES/DES operation.
     * |        |          |In DMA mode, software can update the next TDES_DADR before triggering START.
     * |        |          |TDES_SADR and TDES_DADR can be the same in the value.
    */
    __IO uint32_t TDES1_DADDR;

    /**
     * TDES1_CNT
     * ===================================================================================================
     * Offset: 0x270  TDES/DES Byte Count Register for Channel 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CNT       |TDES/DES Byte Count
     * |        |          |The TDES_CNT keeps the byte count of source text that is for the TDES/DES engine operating in DMA mode.
     * |        |          |The TDES_CNT is 32-bit and the maximum of byte count is 4G bytes.
     * |        |          |TDES_CNT can be read and written.
     * |        |          |Writing to TDES_CNT while the TDES/DES accelerator is operating doesn't affect the current TDES/DES operation.
     * |        |          |But the value of TDES_CNT will be updated later on.
     * |        |          |Consequently, software can prepare the byte count of data for the next TDES /DES operation.
     * |        |          |In Non-DMA ECB, CBC, CFB, OFB, and CTR mode, TDES_CNT must be set as byte count for the last block of data before feeding in the last block of data.
    */
    __IO uint32_t TDES1_CNT;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE3[5];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * TDES2_KEY1H
     * ===================================================================================================
     * Offset: 0x288  TDES/DES Key 1 High Word Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES2_KEY1H;

    /**
     * TDES2_KEY1L
     * ===================================================================================================
     * Offset: 0x28C  TDES/DES Key 1 Low Word Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES2_KEY1L;

    /**
     * TDES2_KEY2H
     * ===================================================================================================
     * Offset: 0x290  TDES Key 2 High Word Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES2_KEY2H;

    /**
     * TDES2_KEY2L
     * ===================================================================================================
     * Offset: 0x294  TDES Key 2 Low Word Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES2_KEY2L;

    /**
     * TDES2_KEY3H
     * ===================================================================================================
     * Offset: 0x298  TDES Key 3 High Word Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES2_KEY3H;

    /**
     * TDES2_KEY3L
     * ===================================================================================================
     * Offset: 0x29C  TDES Key 3 Low Word Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES2_KEY3L;

    /**
     * TDES2_IVH
     * ===================================================================================================
     * Offset: 0x2A0  TDES/DES Initial Vector High Word Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IVH_IVL   |TDES/DES Initial Vector High/Low Word
     * |        |          |Initial vector (IV) is for TDES/DES engine in CBC, CFB, and OFB mode.
     * |        |          |IV is Nonce counter for TDES/DES engine in CTR mode.
    */
    __IO uint32_t TDES2_IVH;

    /**
     * TDES2_IVL
     * ===================================================================================================
     * Offset: 0x2A4  TDES/DES Initial Vector Low Word Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IVH_IVL   |TDES/DES Initial Vector High/Low Word
     * |        |          |Initial vector (IV) is for TDES/DES engine in CBC, CFB, and OFB mode.
     * |        |          |IV is Nonce counter for TDES/DES engine in CTR mode.
    */
    __IO uint32_t TDES2_IVL;

    /**
     * TDES2_SADDR
     * ===================================================================================================
     * Offset: 0x2A8  TDES/DES DMA Source Address Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SADDR     |TDES/DES DMA Source Address
     * |        |          |The TDES/DES accelerator supports DMA function to transfer the plain text between system memory and embedded FIFO.
     * |        |          |The TDES_SADR keeps the source address of the data buffer where the source text is stored.
     * |        |          |Based on the source address, the TDES/DES accelerator can read the plain text from system memory and do TDES/DES operation.
     * |        |          |The start of source address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of TDES_SADR are ignored.
     * |        |          |TDES_SADR can be read and written.
     * |        |          |Writing to TDES_SADR while the TDES/DES accelerator is operating doesn't affect the current TDES/DES operation.
     * |        |          |But the value of TDES_SADR will be updated later on.
     * |        |          |Consequently, software can prepare the DMA source address for the next TDES/DES operation.
     * |        |          |In DMA mode, software can update the next TDES_SADR before triggering START.
     * |        |          |TDES_SADR and TDES_DADR can be the same in the value.
    */
    __IO uint32_t TDES2_SADDR;

    /**
     * TDES2_DADDR
     * ===================================================================================================
     * Offset: 0x2AC  TDES/DES DMA Destination Address Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DADDR     |TDES/DES DMA Destination Address
     * |        |          |The TDES/DES accelerator supports DMA function to transfer the cipher text between system memory and embedded FIFO.
     * |        |          |The TDES_DADR keeps the destination address of the data buffer where the engine output's text will be stored.
     * |        |          |Based on the destination address, the TDES/DES accelerator can write the cipher text back to system memory after the TDES/DES operation is finished.
     * |        |          |The start of destination address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of TDES_DADR are ignored.
     * |        |          |TDES_DADR can be read and written.
     * |        |          |Writing to TDES_DADR while the TDES/DES accelerator is operating doesn't affect the current TDES/DES operation.
     * |        |          |But the value of TDES_DADR will be updated later on.
     * |        |          |Consequently, software can prepare the destination address for the next TDES/DES operation.
     * |        |          |In DMA mode, software can update the next TDES_DADR before triggering START.
     * |        |          |TDES_SADR and TDES_DADR can be the same in the value.
    */
    __IO uint32_t TDES2_DADDR;

    /**
     * TDES2_CNT
     * ===================================================================================================
     * Offset: 0x2B0  TDES/DES Byte Count Register for Channel 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CNT       |TDES/DES Byte Count
     * |        |          |The TDES_CNT keeps the byte count of source text that is for the TDES/DES engine operating in DMA mode.
     * |        |          |The TDES_CNT is 32-bit and the maximum of byte count is 4G bytes.
     * |        |          |TDES_CNT can be read and written.
     * |        |          |Writing to TDES_CNT while the TDES/DES accelerator is operating doesn't affect the current TDES/DES operation.
     * |        |          |But the value of TDES_CNT will be updated later on.
     * |        |          |Consequently, software can prepare the byte count of data for the next TDES /DES operation.
     * |        |          |In Non-DMA ECB, CBC, CFB, OFB, and CTR mode, TDES_CNT must be set as byte count for the last block of data before feeding in the last block of data.
    */
    __IO uint32_t TDES2_CNT;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE4[5];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * TDES3_KEY1H
     * ===================================================================================================
     * Offset: 0x2C8  TDES/DES Key 1 High Word Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES3_KEY1H;

    /**
     * TDES3_KEY1L
     * ===================================================================================================
     * Offset: 0x2CC  TDES/DES Key 1 Low Word Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES3_KEY1L;

    /**
     * TDES3_KEY2H
     * ===================================================================================================
     * Offset: 0x2D0  TDES Key 2 High Word Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES3_KEY2H;

    /**
     * TDES3_KEY2L
     * ===================================================================================================
     * Offset: 0x2D4  TDES Key 2 Low Word Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES3_KEY2L;

    /**
     * TDES3_KEY3H
     * ===================================================================================================
     * Offset: 0x2D8  TDES Key 3 High Word Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES3_KEY3H;

    /**
     * TDES3_KEY3L
     * ===================================================================================================
     * Offset: 0x2DC  TDES Key 3 Low Word Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYH_KEYL |TDES/DES Key X High/Low Word
     * |        |          |The key registers for TDES/DES algorithm calculation
     * |        |          |The security key for the TDES/DES accelerator is 64 bits.
     * |        |          |Thus, it needs two 32-bit registers to store a security key.
     * |        |          |The register TDES_KEYxH is used to keep the bit [63:32] of security key for the TDES/DES operation, while the register TDES_KEYxL is used to keep the bit [31:0].
    */
    __IO uint32_t TDES3_KEY3L;

    /**
     * TDES3_IVH
     * ===================================================================================================
     * Offset: 0x2E0  TDES/DES Initial Vector High Word Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IVH_IVL   |TDES/DES Initial Vector High/Low Word
     * |        |          |Initial vector (IV) is for TDES/DES engine in CBC, CFB, and OFB mode.
     * |        |          |IV is Nonce counter for TDES/DES engine in CTR mode.
    */
    __IO uint32_t TDES3_IVH;

    /**
     * TDES3_IVL
     * ===================================================================================================
     * Offset: 0x2E4  TDES/DES Initial Vector Low Word Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |IVH_IVL   |TDES/DES Initial Vector High/Low Word
     * |        |          |Initial vector (IV) is for TDES/DES engine in CBC, CFB, and OFB mode.
     * |        |          |IV is Nonce counter for TDES/DES engine in CTR mode.
    */
    __IO uint32_t TDES3_IVL;

    /**
     * TDES3_SADDR
     * ===================================================================================================
     * Offset: 0x2E8  TDES/DES DMA Source Address Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SADDR     |TDES/DES DMA Source Address
     * |        |          |The TDES/DES accelerator supports DMA function to transfer the plain text between system memory and embedded FIFO.
     * |        |          |The TDES_SADR keeps the source address of the data buffer where the source text is stored.
     * |        |          |Based on the source address, the TDES/DES accelerator can read the plain text from system memory and do TDES/DES operation.
     * |        |          |The start of source address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of TDES_SADR are ignored.
     * |        |          |TDES_SADR can be read and written.
     * |        |          |Writing to TDES_SADR while the TDES/DES accelerator is operating doesn't affect the current TDES/DES operation.
     * |        |          |But the value of TDES_SADR will be updated later on.
     * |        |          |Consequently, software can prepare the DMA source address for the next TDES/DES operation.
     * |        |          |In DMA mode, software can update the next TDES_SADR before triggering START.
     * |        |          |TDES_SADR and TDES_DADR can be the same in the value.
    */
    __IO uint32_t TDES3_SADDR;

    /**
     * TDES3_DADDR
     * ===================================================================================================
     * Offset: 0x2EC  TDES/DES DMA Destination Address Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DADDR     |TDES/DES DMA Destination Address
     * |        |          |The TDES/DES accelerator supports DMA function to transfer the cipher text between system memory and embedded FIFO.
     * |        |          |The TDES_DADR keeps the destination address of the data buffer where the engine output's text will be stored.
     * |        |          |Based on the destination address, the TDES/DES accelerator can write the cipher text back to system memory after the TDES/DES operation is finished.
     * |        |          |The start of destination address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of TDES_DADR are ignored.
     * |        |          |TDES_DADR can be read and written.
     * |        |          |Writing to TDES_DADR while the TDES/DES accelerator is operating doesn't affect the current TDES/DES operation.
     * |        |          |But the value of TDES_DADR will be updated later on.
     * |        |          |Consequently, software can prepare the destination address for the next TDES/DES operation.
     * |        |          |In DMA mode, software can update the next TDES_DADR before triggering START.
     * |        |          |TDES_SADR and TDES_DADR can be the same in the value.
    */
    __IO uint32_t TDES3_DADDR;

    /**
     * TDES3_CNT
     * ===================================================================================================
     * Offset: 0x2F0  TDES/DES Byte Count Register for Channel 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CNT       |TDES/DES Byte Count
     * |        |          |The TDES_CNT keeps the byte count of source text that is for the TDES/DES engine operating in DMA mode.
     * |        |          |The TDES_CNT is 32-bit and the maximum of byte count is 4G bytes.
     * |        |          |TDES_CNT can be read and written.
     * |        |          |Writing to TDES_CNT while the TDES/DES accelerator is operating doesn't affect the current TDES/DES operation.
     * |        |          |But the value of TDES_CNT will be updated later on.
     * |        |          |Consequently, software can prepare the byte count of data for the next TDES /DES operation.
     * |        |          |In Non-DMA ECB, CBC, CFB, OFB, and CTR mode, TDES_CNT must be set as byte count for the last block of data before feeding in the last block of data.
    */
    __IO uint32_t TDES3_CNT;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE5[3];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * SHA_CTL
     * ===================================================================================================
     * Offset: 0x300  SHA Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |START     |SHA Engine Start
     * |        |          |0 = No effect.
     * |        |          |1 = Start SHA engine. BUSY flag will be set.
     * |        |          |Note: This bit is always 0 when it's read back.
     * |[1]     |STOP      |SHA Engine Stop
     * |        |          |0 = No effect.
     * |        |          |1 = Stop SHA engine.
     * |        |          |Note: This bit is always 0 when it's read back.
     * |[5]     |DMALAST   |SHA Last Block
     * |        |          |In DMA mode, this bit must be set as beginning the last DMA cascade round.
     * |        |          |In Non-DMA mode, this bit must be set as feeding in last byte of data.
     * |[7]     |DMAEN     |SHA Engine DMA Enable Control
     * |        |          |0 = SHA_DMA engine Disabled.
     * |        |          |The SHA engine operates in Non-DMA mode, and gets data from the port CRPT_SHA_DATIN.
     * |        |          |1 = SHA_DMA engine Enabled.
     * |        |          |The SHA engine operates in DMA mode, and data movement from/to the engine is done by DMA logic.
     * |[8:10]  |OPMODE    |SHA Engine Operation Modes
     * |        |          |000 = SHA160.
     * |        |          |100 = SHA256.
     * |        |          |101 = SHA224.
     * |        |          |Note: These bits can be read and written, but writing to them wouldn't take effect as BUSY is 1.
     * |[22]    |OUTSWAP   |SHA Engine Output Data Swap
     * |        |          |0 = Keep the original order.
     * |        |          |1 = The order that CPU feeds data to the accelerator will be changed from {byte3, byte2, byte1, byte0} to {byte0, byte1, byte2, byte3}.
     * |[23]    |INSWAP    |SHA Engine Input Data Swap
     * |        |          |0 = Keep the original order.
     * |        |          |1 = The order that CPU feeds data to the accelerator will be changed from {byte3, byte2, byte1, byte0} to {byte0, byte1, byte2, byte3}.
    */
    __IO uint32_t SHA_CTL;

    /**
     * SHA_STS
     * ===================================================================================================
     * Offset: 0x304  SHA Status Flag
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |BUSY      |SHA Engine Busy
     * |        |          |0 = SHA engine is idle or finished.
     * |        |          |1 = SHA engine is busy.
     * |[1]     |DMABUSY   |SHA Engine DMA Busy Flag
     * |        |          |0 = SHA DMA engine is idle or finished.
     * |        |          |1 = SHA DMA engine is busy.
     * |[8]     |DMAERR    |SHA Engine DMA Error Flag
     * |        |          |0 = Show the SHA engine access normal.
     * |        |          |1 = Show the SHA engine access error.
     * |[16]    |DATINREQ  |SHA Non-DMA Mode Data Input Request
     * |        |          |0 = No effect.
     * |        |          |1 = Request SHA Non-DMA mode data input.
    */
    __I  uint32_t SHA_STS;

    /**
     * SHA_DGST0
     * ===================================================================================================
     * Offset: 0x308  SHA Digest Message 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DGST      |SHA Digest Message Word
     * |        |          |For SHA-160, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST4.
     * |        |          |For SHA-224, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST6.
     * |        |          |For SHA-256, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST7.
    */
    __I  uint32_t SHA_DGST0;

    /**
     * SHA_DGST1
     * ===================================================================================================
     * Offset: 0x30C  SHA Digest Message 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DGST      |SHA Digest Message Word
     * |        |          |For SHA-160, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST4.
     * |        |          |For SHA-224, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST6.
     * |        |          |For SHA-256, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST7.
    */
    __I  uint32_t SHA_DGST1;

    /**
     * SHA_DGST2
     * ===================================================================================================
     * Offset: 0x310  SHA Digest Message 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DGST      |SHA Digest Message Word
     * |        |          |For SHA-160, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST4.
     * |        |          |For SHA-224, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST6.
     * |        |          |For SHA-256, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST7.
    */
    __I  uint32_t SHA_DGST2;

    /**
     * SHA_DGST3
     * ===================================================================================================
     * Offset: 0x314  SHA Digest Message 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DGST      |SHA Digest Message Word
     * |        |          |For SHA-160, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST4.
     * |        |          |For SHA-224, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST6.
     * |        |          |For SHA-256, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST7.
    */
    __I  uint32_t SHA_DGST3;

    /**
     * SHA_DGST4
     * ===================================================================================================
     * Offset: 0x318  SHA Digest Message 4
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DGST      |SHA Digest Message Word
     * |        |          |For SHA-160, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST4.
     * |        |          |For SHA-224, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST6.
     * |        |          |For SHA-256, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST7.
    */
    __I  uint32_t SHA_DGST4;

    /**
     * SHA_DGST5
     * ===================================================================================================
     * Offset: 0x31C  SHA Digest Message 5
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DGST      |SHA Digest Message Word
     * |        |          |For SHA-160, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST4.
     * |        |          |For SHA-224, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST6.
     * |        |          |For SHA-256, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST7.
    */
    __I  uint32_t SHA_DGST5;

    /**
     * SHA_DGST6
     * ===================================================================================================
     * Offset: 0x320  SHA Digest Message 6
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DGST      |SHA Digest Message Word
     * |        |          |For SHA-160, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST4.
     * |        |          |For SHA-224, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST6.
     * |        |          |For SHA-256, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST7.
    */
    __I  uint32_t SHA_DGST6;

    /**
     * SHA_DGST7
     * ===================================================================================================
     * Offset: 0x324  SHA Digest Message 7
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DGST      |SHA Digest Message Word
     * |        |          |For SHA-160, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST4.
     * |        |          |For SHA-224, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST6.
     * |        |          |For SHA-256, the digest is stored in CRPT_SHA_DGST0 ~ CRPT_SHA_DGST7.
    */
    __I  uint32_t SHA_DGST7;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE6[8];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * SHA_KEYCNT
     * ===================================================================================================
     * Offset: 0x348  SHA Key Byte Count Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEYCNT    |SHA Key Byte Count
     * |        |          |The CRPT_SHA_KEYCNT keeps the byte count of key that SHA engine operates.
     * |        |          |The register is 32-bit and the maximum byte count is 4G bytes.
     * |        |          |It can be read and written.
     * |        |          |Writing to the register CRPT_SHA_KEYCNT as the SHA accelerator operating doesn't affect the current SHA operation.
     * |        |          |But the value of SHA _KEY_CNT will be updated later on.
     * |        |          |Consequently, software can prepare the key count for the next SHA operation.
    */
    __IO uint32_t SHA_KEYCNT;

    /**
     * SHA_SADDR
     * ===================================================================================================
     * Offset: 0x34C  SHA DMA Source Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SADDR     |SHA DMA Source Address
     * |        |          |The SHA accelerator supports DMA function to transfer the plain text between system memory and embedded FIFO.
     * |        |          |The CRPT_SHA_SADDR keeps the source address of the data buffer where the source text is stored.
     * |        |          |Based on the source address, the SHA accelerator can read the plain text from system memory and do SHA operation.
     * |        |          |The start of source address should be located at word boundary.
     * |        |          |In other words, bit 1 and 0 of CRPT_SHA_SADDR are ignored.
     * |        |          |CRPT_SHA_SADDR can be read and written.
     * |        |          |Writing to CRPT_SHA_SADDR while the SHA accelerator is operating doesn't affect the current SHA operation.
     * |        |          |But the value of CRPT_SHA_SADDR will be updated later on.
     * |        |          |Consequently, software can prepare the DMA source address for the next SHA operation.
     * |        |          |In DMA mode, software can update the next TDES_SADR before triggering START.
     * |        |          |TDES_SADR and TDES_DADR can be the same in the value.
    */
    __IO uint32_t SHA_SADDR;

    /**
     * SHA_DMACNT
     * ===================================================================================================
     * Offset: 0x350  SHA Byte Count Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DMACNT    |SHA Operation Byte Count
     * |        |          |The CRPT_SHA_DMACNT keeps the byte count of source text that is for the SHA engine operating in DMA mode.
     * |        |          |The CRPT_SHA_DMACNT is 32-bit and the maximum of byte count is 4G bytes.
     * |        |          |CRPT_SHA_DMACNT can be read and written.
     * |        |          |Writing to CRPT_SHA_DMACNT while the SHA accelerator is operating doesn't affect the current SHA operation.
     * |        |          |But the value of CRPT_SHA_DMACNT will be updated later on.
     * |        |          |Consequently, software can prepare the byte count of data for the next SHA operation.
     * |        |          |In Non-DMA mode, CRPT_SHA_DMACNT must be set as the byte count of the last block before feeding in the last block of data.
    */
    __IO uint32_t SHA_DMACNT;

    /**
     * SHA_DATIN
     * ===================================================================================================
     * Offset: 0x354  SHA Engine Non-DMA Mode Data Input Port Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |DATIN     |SHA Engine Input Port
     * |        |          |CPU feeds data to SHA engine through this port by checking CRPT_SHA_STS. Feed data as DATINREQ is 1.
    */
    __IO uint32_t SHA_DATIN;

} CRPT_T;

/**
    @addtogroup CRPT_CONST CRPT Bit Field Definition
    Constant Definitions for CRPT Controller
@{ */

#define CRPT_INTEN_AESIEN_Pos            (0)                                               /*!< CRPT_T::INTEN: AESIEN Position            */
#define CRPT_INTEN_AESIEN_Msk            (0x1ul << CRPT_INTEN_AESIEN_Pos)                  /*!< CRPT_T::INTEN: AESIEN Mask                */

#define CRPT_INTEN_AESERRIEN_Pos         (1)                                               /*!< CRPT_T::INTEN: AESERRIEN Position         */
#define CRPT_INTEN_AESERRIEN_Msk         (0x1ul << CRPT_INTEN_AESERRIEN_Pos)               /*!< CRPT_T::INTEN: AESERRIEN Mask             */

#define CRPT_INTEN_TDESIEN_Pos           (8)                                               /*!< CRPT_T::INTEN: TDESIEN Position           */
#define CRPT_INTEN_TDESIEN_Msk           (0x1ul << CRPT_INTEN_TDESIEN_Pos)                 /*!< CRPT_T::INTEN: TDESIEN Mask               */

#define CRPT_INTEN_TDESERRIEN_Pos        (9)                                               /*!< CRPT_T::INTEN: TDESERRIEN Position        */
#define CRPT_INTEN_TDESERRIEN_Msk        (0x1ul << CRPT_INTEN_TDESERRIEN_Pos)              /*!< CRPT_T::INTEN: TDESERRIEN Mask            */

#define CRPT_INTEN_PRNGIEN_Pos           (16)                                              /*!< CRPT_T::INTEN: PRNGIEN Position           */
#define CRPT_INTEN_PRNGIEN_Msk           (0x1ul << CRPT_INTEN_PRNGIEN_Pos)                 /*!< CRPT_T::INTEN: PRNGIEN Mask               */

#define CRPT_INTEN_SHAIEN_Pos            (24)                                              /*!< CRPT_T::INTEN: SHAIEN Position            */
#define CRPT_INTEN_SHAIEN_Msk            (0x1ul << CRPT_INTEN_SHAIEN_Pos)                  /*!< CRPT_T::INTEN: SHAIEN Mask                */

#define CRPT_INTEN_SHAERRIEN_Pos         (25)                                              /*!< CRPT_T::INTEN: SHAERRIEN Position         */
#define CRPT_INTEN_SHAERRIEN_Msk         (0x1ul << CRPT_INTEN_SHAERRIEN_Pos)               /*!< CRPT_T::INTEN: SHAERRIEN Mask             */

#define CRPT_INTSTS_AESIF_Pos            (0)                                               /*!< CRPT_T::INTSTS: AESIF Position            */
#define CRPT_INTSTS_AESIF_Msk            (0x1ul << CRPT_INTSTS_AESIF_Pos)                  /*!< CRPT_T::INTSTS: AESIF Mask                */

#define CRPT_INTSTS_AESERRIF_Pos         (1)                                               /*!< CRPT_T::INTSTS: AESERRIF Position         */
#define CRPT_INTSTS_AESERRIF_Msk         (0x1ul << CRPT_INTSTS_AESERRIF_Pos)               /*!< CRPT_T::INTSTS: AESERRIF Mask             */

#define CRPT_INTSTS_TDESIF_Pos           (8)                                               /*!< CRPT_T::INTSTS: TDESIF Position           */
#define CRPT_INTSTS_TDESIF_Msk           (0x1ul << CRPT_INTSTS_TDESIF_Pos)                 /*!< CRPT_T::INTSTS: TDESIF Mask               */

#define CRPT_INTSTS_TDESERRIF_Pos        (9)                                               /*!< CRPT_T::INTSTS: TDESERRIF Position        */
#define CRPT_INTSTS_TDESERRIF_Msk        (0x1ul << CRPT_INTSTS_TDESERRIF_Pos)              /*!< CRPT_T::INTSTS: TDESERRIF Mask            */

#define CRPT_INTSTS_PRNGIF_Pos           (16)                                              /*!< CRPT_T::INTSTS: PRNGIF Position           */
#define CRPT_INTSTS_PRNGIF_Msk           (0x1ul << CRPT_INTSTS_PRNGIF_Pos)                 /*!< CRPT_T::INTSTS: PRNGIF Mask               */

#define CRPT_INTSTS_SHAIF_Pos            (24)                                              /*!< CRPT_T::INTSTS: SHAIF Position            */
#define CRPT_INTSTS_SHAIF_Msk            (0x1ul << CRPT_INTSTS_SHAIF_Pos)                  /*!< CRPT_T::INTSTS: SHAIF Mask                */

#define CRPT_INTSTS_SHAERRIF_Pos         (25)                                              /*!< CRPT_T::INTSTS: SHAERRIF Position         */
#define CRPT_INTSTS_SHAERRIF_Msk         (0x1ul << CRPT_INTSTS_SHAERRIF_Pos)               /*!< CRPT_T::INTSTS: SHAERRIF Mask             */

#define CRPT_PRNG_CTL_START_Pos          (0)                                               /*!< CRPT_T::PRNG_CTL: START Position          */
#define CRPT_PRNG_CTL_START_Msk          (0x1ul << CRPT_PRNG_CTL_START_Pos)                /*!< CRPT_T::PRNG_CTL: START Mask              */

#define CRPT_PRNG_CTL_SEEDRLD_Pos        (1)                                               /*!< CRPT_T::PRNG_CTL: SEEDRLD Position        */
#define CRPT_PRNG_CTL_SEEDRLD_Msk        (0x1ul << CRPT_PRNG_CTL_SEEDRLD_Pos)              /*!< CRPT_T::PRNG_CTL: SEEDRLD Mask            */

#define CRPT_PRNG_CTL_KEYSZ_Pos          (2)                                               /*!< CRPT_T::PRNG_CTL: KEYSZ Position          */
#define CRPT_PRNG_CTL_KEYSZ_Msk          (0x3ul << CRPT_PRNG_CTL_KEYSZ_Pos)                /*!< CRPT_T::PRNG_CTL: KEYSZ Mask              */

#define CRPT_PRNG_CTL_BUSY_Pos           (8)                                               /*!< CRPT_T::PRNG_CTL: BUSY Position           */
#define CRPT_PRNG_CTL_BUSY_Msk           (0x1ul << CRPT_PRNG_CTL_BUSY_Pos)                 /*!< CRPT_T::PRNG_CTL: BUSY Mask               */

#define CRPT_PRNG_SEED_SEED_Pos          (0)                                               /*!< CRPT_T::PRNG_SEED: SEED Position          */
#define CRPT_PRNG_SEED_SEED_Msk          (0xfffffffful << CRPT_PRNG_SEED_SEED_Pos)         /*!< CRPT_T::PRNG_SEED: SEED Mask              */

#define CRPT_PRNG_KEY0_KEY_Pos           (0)                                               /*!< CRPT_T::PRNG_KEY0: KEY Position           */
#define CRPT_PRNG_KEY0_KEY_Msk           (0xfffffffful << CRPT_PRNG_KEY0_KEY_Pos)          /*!< CRPT_T::PRNG_KEY0: KEY Mask               */

#define CRPT_PRNG_KEY1_KEY_Pos           (0)                                               /*!< CRPT_T::PRNG_KEY1: KEY Position           */
#define CRPT_PRNG_KEY1_KEY_Msk           (0xfffffffful << CRPT_PRNG_KEY1_KEY_Pos)          /*!< CRPT_T::PRNG_KEY1: KEY Mask               */

#define CRPT_PRNG_KEY2_KEY_Pos           (0)                                               /*!< CRPT_T::PRNG_KEY2: KEY Position           */
#define CRPT_PRNG_KEY2_KEY_Msk           (0xfffffffful << CRPT_PRNG_KEY2_KEY_Pos)          /*!< CRPT_T::PRNG_KEY2: KEY Mask               */

#define CRPT_PRNG_KEY3_KEY_Pos           (0)                                               /*!< CRPT_T::PRNG_KEY3: KEY Position           */
#define CRPT_PRNG_KEY3_KEY_Msk           (0xfffffffful << CRPT_PRNG_KEY3_KEY_Pos)          /*!< CRPT_T::PRNG_KEY3: KEY Mask               */

#define CRPT_PRNG_KEY4_KEY_Pos           (0)                                               /*!< CRPT_T::PRNG_KEY4: KEY Position           */
#define CRPT_PRNG_KEY4_KEY_Msk           (0xfffffffful << CRPT_PRNG_KEY4_KEY_Pos)          /*!< CRPT_T::PRNG_KEY4: KEY Mask               */

#define CRPT_PRNG_KEY5_KEY_Pos           (0)                                               /*!< CRPT_T::PRNG_KEY5: KEY Position           */
#define CRPT_PRNG_KEY5_KEY_Msk           (0xfffffffful << CRPT_PRNG_KEY5_KEY_Pos)          /*!< CRPT_T::PRNG_KEY5: KEY Mask               */

#define CRPT_PRNG_KEY6_KEY_Pos           (0)                                               /*!< CRPT_T::PRNG_KEY6: KEY Position           */
#define CRPT_PRNG_KEY6_KEY_Msk           (0xfffffffful << CRPT_PRNG_KEY6_KEY_Pos)          /*!< CRPT_T::PRNG_KEY6: KEY Mask               */

#define CRPT_PRNG_KEY7_KEY_Pos           (0)                                               /*!< CRPT_T::PRNG_KEY7: KEY Position           */
#define CRPT_PRNG_KEY7_KEY_Msk           (0xfffffffful << CRPT_PRNG_KEY7_KEY_Pos)          /*!< CRPT_T::PRNG_KEY7: KEY Mask               */

#define CRPT_AES_FDBCK0_FDBCK_Pos        (0)                                               /*!< CRPT_T::AES_FDBCK0: FDBCK Position        */
#define CRPT_AES_FDBCK0_FDBCK_Msk        (0xfffffffful << CRPT_AES_FDBCK0_FDBCK_Pos)       /*!< CRPT_T::AES_FDBCK0: FDBCK Mask            */

#define CRPT_AES_FDBCK1_FDBCK_Pos        (0)                                               /*!< CRPT_T::AES_FDBCK1: FDBCK Position        */
#define CRPT_AES_FDBCK1_FDBCK_Msk        (0xfffffffful << CRPT_AES_FDBCK1_FDBCK_Pos)       /*!< CRPT_T::AES_FDBCK1: FDBCK Mask            */

#define CRPT_AES_FDBCK2_FDBCK_Pos        (0)                                               /*!< CRPT_T::AES_FDBCK2: FDBCK Position        */
#define CRPT_AES_FDBCK2_FDBCK_Msk        (0xfffffffful << CRPT_AES_FDBCK2_FDBCK_Pos)       /*!< CRPT_T::AES_FDBCK2: FDBCK Mask            */

#define CRPT_AES_FDBCK3_FDBCK_Pos        (0)                                               /*!< CRPT_T::AES_FDBCK3: FDBCK Position        */
#define CRPT_AES_FDBCK3_FDBCK_Msk        (0xfffffffful << CRPT_AES_FDBCK3_FDBCK_Pos)       /*!< CRPT_T::AES_FDBCK3: FDBCK Mask            */

#define CRPT_TDES_FDBCKH_FDBCK_Pos       (0)                                               /*!< CRPT_T::TDES_FDBCKH: FDBCK Position       */
#define CRPT_TDES_FDBCKH_FDBCK_Msk       (0xfffffffful << CRPT_TDES_FDBCKH_FDBCK_Pos)      /*!< CRPT_T::TDES_FDBCKH: FDBCK Mask           */

#define CRPT_TDES_FDBCKL_FDBCK_Pos       (0)                                               /*!< CRPT_T::TDES_FDBCKL: FDBCK Position       */
#define CRPT_TDES_FDBCKL_FDBCK_Msk       (0xfffffffful << CRPT_TDES_FDBCKL_FDBCK_Pos)      /*!< CRPT_T::TDES_FDBCKL: FDBCK Mask           */

#define CRPT_AES_CTL_START_Pos           (0)                                               /*!< CRPT_T::AES_CTL: START Position           */
#define CRPT_AES_CTL_START_Msk           (0x1ul << CRPT_AES_CTL_START_Pos)                 /*!< CRPT_T::AES_CTL: START Mask               */

#define CRPT_AES_CTL_STOP_Pos            (1)                                               /*!< CRPT_T::AES_CTL: STOP Position            */
#define CRPT_AES_CTL_STOP_Msk            (0x1ul << CRPT_AES_CTL_STOP_Pos)                  /*!< CRPT_T::AES_CTL: STOP Mask                */

#define CRPT_AES_CTL_KEYSZ_Pos           (2)                                               /*!< CRPT_T::AES_CTL: KEYSZ Position           */
#define CRPT_AES_CTL_KEYSZ_Msk           (0x3ul << CRPT_AES_CTL_KEYSZ_Pos)                 /*!< CRPT_T::AES_CTL: KEYSZ Mask               */

#define CRPT_AES_CTL_DMALAST_Pos         (5)                                               /*!< CRPT_T::AES_CTL: DMALAST Position         */
#define CRPT_AES_CTL_DMALAST_Msk         (0x1ul << CRPT_AES_CTL_DMALAST_Pos)               /*!< CRPT_T::AES_CTL: DMALAST Mask             */

#define CRPT_AES_CTL_DMACSCAD_Pos        (6)                                               /*!< CRPT_T::AES_CTL: DMACSCAD Position        */
#define CRPT_AES_CTL_DMACSCAD_Msk        (0x1ul << CRPT_AES_CTL_DMACSCAD_Pos)              /*!< CRPT_T::AES_CTL: DMACSCAD Mask            */

#define CRPT_AES_CTL_DMAEN_Pos           (7)                                               /*!< CRPT_T::AES_CTL: DMAEN Position           */
#define CRPT_AES_CTL_DMAEN_Msk           (0x1ul << CRPT_AES_CTL_DMAEN_Pos)                 /*!< CRPT_T::AES_CTL: DMAEN Mask               */

#define CRPT_AES_CTL_OPMODE_Pos          (8)                                               /*!< CRPT_T::AES_CTL: OPMODE Position          */
#define CRPT_AES_CTL_OPMODE_Msk          (0xfful << CRPT_AES_CTL_OPMODE_Pos)               /*!< CRPT_T::AES_CTL: OPMODE Mask              */

#define CRPT_AES_CTL_ENCRPT_Pos          (16)                                              /*!< CRPT_T::AES_CTL: ENCRPT Position          */
#define CRPT_AES_CTL_ENCRPT_Msk          (0x1ul << CRPT_AES_CTL_ENCRPT_Pos)                /*!< CRPT_T::AES_CTL: ENCRPT Mask              */

#define CRPT_AES_CTL_OUTSWAP_Pos         (22)                                              /*!< CRPT_T::AES_CTL: OUTSWAP Position         */
#define CRPT_AES_CTL_OUTSWAP_Msk         (0x1ul << CRPT_AES_CTL_OUTSWAP_Pos)               /*!< CRPT_T::AES_CTL: OUTSWAP Mask             */

#define CRPT_AES_CTL_INSWAP_Pos          (23)                                              /*!< CRPT_T::AES_CTL: INSWAP Position          */
#define CRPT_AES_CTL_INSWAP_Msk          (0x1ul << CRPT_AES_CTL_INSWAP_Pos)                /*!< CRPT_T::AES_CTL: INSWAP Mask              */

#define CRPT_AES_CTL_CHANNEL_Pos         (24)                                              /*!< CRPT_T::AES_CTL: CHANNEL Position         */
#define CRPT_AES_CTL_CHANNEL_Msk         (0x3ul << CRPT_AES_CTL_CHANNEL_Pos)               /*!< CRPT_T::AES_CTL: CHANNEL Mask             */

#define CRPT_AES_CTL_KEYUNPRT_Pos        (26)                                              /*!< CRPT_T::AES_CTL: KEYUNPRT Position        */
#define CRPT_AES_CTL_KEYUNPRT_Msk        (0x1ful << CRPT_AES_CTL_KEYUNPRT_Pos)             /*!< CRPT_T::AES_CTL: KEYUNPRT Mask            */

#define CRPT_AES_CTL_KEYPRT_Pos          (31)                                              /*!< CRPT_T::AES_CTL: KEYPRT Position          */
#define CRPT_AES_CTL_KEYPRT_Msk          (0x1ul << CRPT_AES_CTL_KEYPRT_Pos)                /*!< CRPT_T::AES_CTL: KEYPRT Mask              */

#define CRPT_AES_STS_BUSY_Pos            (0)                                               /*!< CRPT_T::AES_STS: BUSY Position            */
#define CRPT_AES_STS_BUSY_Msk            (0x1ul << CRPT_AES_STS_BUSY_Pos)                  /*!< CRPT_T::AES_STS: BUSY Mask                */

#define CRPT_AES_STS_INBUFEMPTY_Pos      (8)                                               /*!< CRPT_T::AES_STS: INBUFEMPTY Position      */
#define CRPT_AES_STS_INBUFEMPTY_Msk      (0x1ul << CRPT_AES_STS_INBUFEMPTY_Pos)            /*!< CRPT_T::AES_STS: INBUFEMPTY Mask          */

#define CRPT_AES_STS_INBUFFULL_Pos       (9)                                               /*!< CRPT_T::AES_STS: INBUFFULL Position       */
#define CRPT_AES_STS_INBUFFULL_Msk       (0x1ul << CRPT_AES_STS_INBUFFULL_Pos)             /*!< CRPT_T::AES_STS: INBUFFULL Mask           */

#define CRPT_AES_STS_INBUFERR_Pos        (10)                                              /*!< CRPT_T::AES_STS: INBUFERR Position        */
#define CRPT_AES_STS_INBUFERR_Msk        (0x1ul << CRPT_AES_STS_INBUFERR_Pos)              /*!< CRPT_T::AES_STS: INBUFERR Mask            */

#define CRPT_AES_STS_CNTERR_Pos          (12)                                              /*!< CRPT_T::AES_STS: CNTERR Position          */
#define CRPT_AES_STS_CNTERR_Msk          (0x1ul << CRPT_AES_STS_CNTERR_Pos)                /*!< CRPT_T::AES_STS: CNTERR Mask              */

#define CRPT_AES_STS_OUTBUFEMPTY_Pos     (16)                                              /*!< CRPT_T::AES_STS: OUTBUFEMPTY Position     */
#define CRPT_AES_STS_OUTBUFEMPTY_Msk     (0x1ul << CRPT_AES_STS_OUTBUFEMPTY_Pos)           /*!< CRPT_T::AES_STS: OUTBUFEMPTY Mask         */

#define CRPT_AES_STS_OUTBUFFULL_Pos      (17)                                              /*!< CRPT_T::AES_STS: OUTBUFFULL Position      */
#define CRPT_AES_STS_OUTBUFFULL_Msk      (0x1ul << CRPT_AES_STS_OUTBUFFULL_Pos)            /*!< CRPT_T::AES_STS: OUTBUFFULL Mask          */

#define CRPT_AES_STS_OUTBUFERR_Pos       (18)                                              /*!< CRPT_T::AES_STS: OUTBUFERR Position       */
#define CRPT_AES_STS_OUTBUFERR_Msk       (0x1ul << CRPT_AES_STS_OUTBUFERR_Pos)             /*!< CRPT_T::AES_STS: OUTBUFERR Mask           */

#define CRPT_AES_STS_BUSERR_Pos          (20)                                              /*!< CRPT_T::AES_STS: BUSERR Position          */
#define CRPT_AES_STS_BUSERR_Msk          (0x1ul << CRPT_AES_STS_BUSERR_Pos)                /*!< CRPT_T::AES_STS: BUSERR Mask              */

#define CRPT_AES_DATIN_DATIN_Pos         (0)                                               /*!< CRPT_T::AES_DATIN: DATIN Position         */
#define CRPT_AES_DATIN_DATIN_Msk         (0xfffffffful << CRPT_AES_DATIN_DATIN_Pos)        /*!< CRPT_T::AES_DATIN: DATIN Mask             */

#define CRPT_AES_DATOUT_DATOUT_Pos       (0)                                               /*!< CRPT_T::AES_DATOUT: DATOUT Position       */
#define CRPT_AES_DATOUT_DATOUT_Msk       (0xfffffffful << CRPT_AES_DATOUT_DATOUT_Pos)      /*!< CRPT_T::AES_DATOUT: DATOUT Mask           */

#define CRPT_AES0_KEY0_KEY_Pos           (0)                                               /*!< CRPT_T::AES0_KEY0: KEY Position           */
#define CRPT_AES0_KEY0_KEY_Msk           (0xfffffffful << CRPT_AES0_KEY0_KEY_Pos)          /*!< CRPT_T::AES0_KEY0: KEY Mask               */

#define CRPT_AES0_KEY1_KEY_Pos           (0)                                               /*!< CRPT_T::AES0_KEY1: KEY Position           */
#define CRPT_AES0_KEY1_KEY_Msk           (0xfffffffful << CRPT_AES0_KEY1_KEY_Pos)          /*!< CRPT_T::AES0_KEY1: KEY Mask               */

#define CRPT_AES0_KEY2_KEY_Pos           (0)                                               /*!< CRPT_T::AES0_KEY2: KEY Position           */
#define CRPT_AES0_KEY2_KEY_Msk           (0xfffffffful << CRPT_AES0_KEY2_KEY_Pos)          /*!< CRPT_T::AES0_KEY2: KEY Mask               */

#define CRPT_AES0_KEY3_KEY_Pos           (0)                                               /*!< CRPT_T::AES0_KEY3: KEY Position           */
#define CRPT_AES0_KEY3_KEY_Msk           (0xfffffffful << CRPT_AES0_KEY3_KEY_Pos)          /*!< CRPT_T::AES0_KEY3: KEY Mask               */

#define CRPT_AES0_KEY4_KEY_Pos           (0)                                               /*!< CRPT_T::AES0_KEY4: KEY Position           */
#define CRPT_AES0_KEY4_KEY_Msk           (0xfffffffful << CRPT_AES0_KEY4_KEY_Pos)          /*!< CRPT_T::AES0_KEY4: KEY Mask               */

#define CRPT_AES0_KEY5_KEY_Pos           (0)                                               /*!< CRPT_T::AES0_KEY5: KEY Position           */
#define CRPT_AES0_KEY5_KEY_Msk           (0xfffffffful << CRPT_AES0_KEY5_KEY_Pos)          /*!< CRPT_T::AES0_KEY5: KEY Mask               */

#define CRPT_AES0_KEY6_KEY_Pos           (0)                                               /*!< CRPT_T::AES0_KEY6: KEY Position           */
#define CRPT_AES0_KEY6_KEY_Msk           (0xfffffffful << CRPT_AES0_KEY6_KEY_Pos)          /*!< CRPT_T::AES0_KEY6: KEY Mask               */

#define CRPT_AES0_KEY7_KEY_Pos           (0)                                               /*!< CRPT_T::AES0_KEY7: KEY Position           */
#define CRPT_AES0_KEY7_KEY_Msk           (0xfffffffful << CRPT_AES0_KEY7_KEY_Pos)          /*!< CRPT_T::AES0_KEY7: KEY Mask               */

#define CRPT_AES0_IV0_IV_Pos             (0)                                               /*!< CRPT_T::AES0_IV0: IV Position             */
#define CRPT_AES0_IV0_IV_Msk             (0xfffffffful << CRPT_AES0_IV0_IV_Pos)            /*!< CRPT_T::AES0_IV0: IV Mask                 */

#define CRPT_AES0_IV1_IV_Pos             (0)                                               /*!< CRPT_T::AES0_IV1: IV Position             */
#define CRPT_AES0_IV1_IV_Msk             (0xfffffffful << CRPT_AES0_IV1_IV_Pos)            /*!< CRPT_T::AES0_IV1: IV Mask                 */

#define CRPT_AES0_IV2_IV_Pos             (0)                                               /*!< CRPT_T::AES0_IV2: IV Position             */
#define CRPT_AES0_IV2_IV_Msk             (0xfffffffful << CRPT_AES0_IV2_IV_Pos)            /*!< CRPT_T::AES0_IV2: IV Mask                 */

#define CRPT_AES0_IV3_IV_Pos             (0)                                               /*!< CRPT_T::AES0_IV3: IV Position             */
#define CRPT_AES0_IV3_IV_Msk             (0xfffffffful << CRPT_AES0_IV3_IV_Pos)            /*!< CRPT_T::AES0_IV3: IV Mask                 */

#define CRPT_AES0_SADDR_SADDR_Pos        (0)                                               /*!< CRPT_T::AES0_SADDR: SADDR Position        */
#define CRPT_AES0_SADDR_SADDR_Msk        (0xfffffffful << CRPT_AES0_SADDR_SADDR_Pos)       /*!< CRPT_T::AES0_SADDR: SADDR Mask            */

#define CRPT_AES0_DADDR_DADDR_Pos        (0)                                               /*!< CRPT_T::AES0_DADDR: DADDR Position        */
#define CRPT_AES0_DADDR_DADDR_Msk        (0xfffffffful << CRPT_AES0_DADDR_DADDR_Pos)       /*!< CRPT_T::AES0_DADDR: DADDR Mask            */

#define CRPT_AES0_CNT_CNT_Pos            (0)                                               /*!< CRPT_T::AES0_CNT: CNT Position            */
#define CRPT_AES0_CNT_CNT_Msk            (0xfffffffful << CRPT_AES0_CNT_CNT_Pos)           /*!< CRPT_T::AES0_CNT: CNT Mask                */

#define CRPT_AES1_KEY0_KEY_Pos           (0)                                               /*!< CRPT_T::AES1_KEY0: KEY Position           */
#define CRPT_AES1_KEY0_KEY_Msk           (0xfffffffful << CRPT_AES1_KEY0_KEY_Pos)          /*!< CRPT_T::AES1_KEY0: KEY Mask               */

#define CRPT_AES1_KEY1_KEY_Pos           (0)                                               /*!< CRPT_T::AES1_KEY1: KEY Position           */
#define CRPT_AES1_KEY1_KEY_Msk           (0xfffffffful << CRPT_AES1_KEY1_KEY_Pos)          /*!< CRPT_T::AES1_KEY1: KEY Mask               */

#define CRPT_AES1_KEY2_KEY_Pos           (0)                                               /*!< CRPT_T::AES1_KEY2: KEY Position           */
#define CRPT_AES1_KEY2_KEY_Msk           (0xfffffffful << CRPT_AES1_KEY2_KEY_Pos)          /*!< CRPT_T::AES1_KEY2: KEY Mask               */

#define CRPT_AES1_KEY3_KEY_Pos           (0)                                               /*!< CRPT_T::AES1_KEY3: KEY Position           */
#define CRPT_AES1_KEY3_KEY_Msk           (0xfffffffful << CRPT_AES1_KEY3_KEY_Pos)          /*!< CRPT_T::AES1_KEY3: KEY Mask               */

#define CRPT_AES1_KEY4_KEY_Pos           (0)                                               /*!< CRPT_T::AES1_KEY4: KEY Position           */
#define CRPT_AES1_KEY4_KEY_Msk           (0xfffffffful << CRPT_AES1_KEY4_KEY_Pos)          /*!< CRPT_T::AES1_KEY4: KEY Mask               */

#define CRPT_AES1_KEY5_KEY_Pos           (0)                                               /*!< CRPT_T::AES1_KEY5: KEY Position           */
#define CRPT_AES1_KEY5_KEY_Msk           (0xfffffffful << CRPT_AES1_KEY5_KEY_Pos)          /*!< CRPT_T::AES1_KEY5: KEY Mask               */

#define CRPT_AES1_KEY6_KEY_Pos           (0)                                               /*!< CRPT_T::AES1_KEY6: KEY Position           */
#define CRPT_AES1_KEY6_KEY_Msk           (0xfffffffful << CRPT_AES1_KEY6_KEY_Pos)          /*!< CRPT_T::AES1_KEY6: KEY Mask               */

#define CRPT_AES1_KEY7_KEY_Pos           (0)                                               /*!< CRPT_T::AES1_KEY7: KEY Position           */
#define CRPT_AES1_KEY7_KEY_Msk           (0xfffffffful << CRPT_AES1_KEY7_KEY_Pos)          /*!< CRPT_T::AES1_KEY7: KEY Mask               */

#define CRPT_AES1_IV0_IV_Pos             (0)                                               /*!< CRPT_T::AES1_IV0: IV Position             */
#define CRPT_AES1_IV0_IV_Msk             (0xfffffffful << CRPT_AES1_IV0_IV_Pos)            /*!< CRPT_T::AES1_IV0: IV Mask                 */

#define CRPT_AES1_IV1_IV_Pos             (0)                                               /*!< CRPT_T::AES1_IV1: IV Position             */
#define CRPT_AES1_IV1_IV_Msk             (0xfffffffful << CRPT_AES1_IV1_IV_Pos)            /*!< CRPT_T::AES1_IV1: IV Mask                 */

#define CRPT_AES1_IV2_IV_Pos             (0)                                               /*!< CRPT_T::AES1_IV2: IV Position             */
#define CRPT_AES1_IV2_IV_Msk             (0xfffffffful << CRPT_AES1_IV2_IV_Pos)            /*!< CRPT_T::AES1_IV2: IV Mask                 */

#define CRPT_AES1_IV3_IV_Pos             (0)                                               /*!< CRPT_T::AES1_IV3: IV Position             */
#define CRPT_AES1_IV3_IV_Msk             (0xfffffffful << CRPT_AES1_IV3_IV_Pos)            /*!< CRPT_T::AES1_IV3: IV Mask                 */

#define CRPT_AES1_SADDR_SADDR_Pos        (0)                                               /*!< CRPT_T::AES1_SADDR: SADDR Position        */
#define CRPT_AES1_SADDR_SADDR_Msk        (0xfffffffful << CRPT_AES1_SADDR_SADDR_Pos)       /*!< CRPT_T::AES1_SADDR: SADDR Mask            */

#define CRPT_AES1_DADDR_DADDR_Pos        (0)                                               /*!< CRPT_T::AES1_DADDR: DADDR Position        */
#define CRPT_AES1_DADDR_DADDR_Msk        (0xfffffffful << CRPT_AES1_DADDR_DADDR_Pos)       /*!< CRPT_T::AES1_DADDR: DADDR Mask            */

#define CRPT_AES1_CNT_CNT_Pos            (0)                                               /*!< CRPT_T::AES1_CNT: CNT Position            */
#define CRPT_AES1_CNT_CNT_Msk            (0xfffffffful << CRPT_AES1_CNT_CNT_Pos)           /*!< CRPT_T::AES1_CNT: CNT Mask                */

#define CRPT_AES2_KEY0_KEY_Pos           (0)                                               /*!< CRPT_T::AES2_KEY0: KEY Position           */
#define CRPT_AES2_KEY0_KEY_Msk           (0xfffffffful << CRPT_AES2_KEY0_KEY_Pos)          /*!< CRPT_T::AES2_KEY0: KEY Mask               */

#define CRPT_AES2_KEY1_KEY_Pos           (0)                                               /*!< CRPT_T::AES2_KEY1: KEY Position           */
#define CRPT_AES2_KEY1_KEY_Msk           (0xfffffffful << CRPT_AES2_KEY1_KEY_Pos)          /*!< CRPT_T::AES2_KEY1: KEY Mask               */

#define CRPT_AES2_KEY2_KEY_Pos           (0)                                               /*!< CRPT_T::AES2_KEY2: KEY Position           */
#define CRPT_AES2_KEY2_KEY_Msk           (0xfffffffful << CRPT_AES2_KEY2_KEY_Pos)          /*!< CRPT_T::AES2_KEY2: KEY Mask               */

#define CRPT_AES2_KEY3_KEY_Pos           (0)                                               /*!< CRPT_T::AES2_KEY3: KEY Position           */
#define CRPT_AES2_KEY3_KEY_Msk           (0xfffffffful << CRPT_AES2_KEY3_KEY_Pos)          /*!< CRPT_T::AES2_KEY3: KEY Mask               */

#define CRPT_AES2_KEY4_KEY_Pos           (0)                                               /*!< CRPT_T::AES2_KEY4: KEY Position           */
#define CRPT_AES2_KEY4_KEY_Msk           (0xfffffffful << CRPT_AES2_KEY4_KEY_Pos)          /*!< CRPT_T::AES2_KEY4: KEY Mask               */

#define CRPT_AES2_KEY5_KEY_Pos           (0)                                               /*!< CRPT_T::AES2_KEY5: KEY Position           */
#define CRPT_AES2_KEY5_KEY_Msk           (0xfffffffful << CRPT_AES2_KEY5_KEY_Pos)          /*!< CRPT_T::AES2_KEY5: KEY Mask               */

#define CRPT_AES2_KEY6_KEY_Pos           (0)                                               /*!< CRPT_T::AES2_KEY6: KEY Position           */
#define CRPT_AES2_KEY6_KEY_Msk           (0xfffffffful << CRPT_AES2_KEY6_KEY_Pos)          /*!< CRPT_T::AES2_KEY6: KEY Mask               */

#define CRPT_AES2_KEY7_KEY_Pos           (0)                                               /*!< CRPT_T::AES2_KEY7: KEY Position           */
#define CRPT_AES2_KEY7_KEY_Msk           (0xfffffffful << CRPT_AES2_KEY7_KEY_Pos)          /*!< CRPT_T::AES2_KEY7: KEY Mask               */

#define CRPT_AES2_IV0_IV_Pos             (0)                                               /*!< CRPT_T::AES2_IV0: IV Position             */
#define CRPT_AES2_IV0_IV_Msk             (0xfffffffful << CRPT_AES2_IV0_IV_Pos)            /*!< CRPT_T::AES2_IV0: IV Mask                 */

#define CRPT_AES2_IV1_IV_Pos             (0)                                               /*!< CRPT_T::AES2_IV1: IV Position             */
#define CRPT_AES2_IV1_IV_Msk             (0xfffffffful << CRPT_AES2_IV1_IV_Pos)            /*!< CRPT_T::AES2_IV1: IV Mask                 */

#define CRPT_AES2_IV2_IV_Pos             (0)                                               /*!< CRPT_T::AES2_IV2: IV Position             */
#define CRPT_AES2_IV2_IV_Msk             (0xfffffffful << CRPT_AES2_IV2_IV_Pos)            /*!< CRPT_T::AES2_IV2: IV Mask                 */

#define CRPT_AES2_IV3_IV_Pos             (0)                                               /*!< CRPT_T::AES2_IV3: IV Position             */
#define CRPT_AES2_IV3_IV_Msk             (0xfffffffful << CRPT_AES2_IV3_IV_Pos)            /*!< CRPT_T::AES2_IV3: IV Mask                 */

#define CRPT_AES2_SADDR_SADDR_Pos        (0)                                               /*!< CRPT_T::AES2_SADDR: SADDR Position        */
#define CRPT_AES2_SADDR_SADDR_Msk        (0xfffffffful << CRPT_AES2_SADDR_SADDR_Pos)       /*!< CRPT_T::AES2_SADDR: SADDR Mask            */

#define CRPT_AES2_DADDR_DADDR_Pos        (0)                                               /*!< CRPT_T::AES2_DADDR: DADDR Position        */
#define CRPT_AES2_DADDR_DADDR_Msk        (0xfffffffful << CRPT_AES2_DADDR_DADDR_Pos)       /*!< CRPT_T::AES2_DADDR: DADDR Mask            */

#define CRPT_AES2_CNT_CNT_Pos            (0)                                               /*!< CRPT_T::AES2_CNT: CNT Position            */
#define CRPT_AES2_CNT_CNT_Msk            (0xfffffffful << CRPT_AES2_CNT_CNT_Pos)           /*!< CRPT_T::AES2_CNT: CNT Mask                */

#define CRPT_AES3_KEY0_KEY_Pos           (0)                                               /*!< CRPT_T::AES3_KEY0: KEY Position           */
#define CRPT_AES3_KEY0_KEY_Msk           (0xfffffffful << CRPT_AES3_KEY0_KEY_Pos)          /*!< CRPT_T::AES3_KEY0: KEY Mask               */

#define CRPT_AES3_KEY1_KEY_Pos           (0)                                               /*!< CRPT_T::AES3_KEY1: KEY Position           */
#define CRPT_AES3_KEY1_KEY_Msk           (0xfffffffful << CRPT_AES3_KEY1_KEY_Pos)          /*!< CRPT_T::AES3_KEY1: KEY Mask               */

#define CRPT_AES3_KEY2_KEY_Pos           (0)                                               /*!< CRPT_T::AES3_KEY2: KEY Position           */
#define CRPT_AES3_KEY2_KEY_Msk           (0xfffffffful << CRPT_AES3_KEY2_KEY_Pos)          /*!< CRPT_T::AES3_KEY2: KEY Mask               */

#define CRPT_AES3_KEY3_KEY_Pos           (0)                                               /*!< CRPT_T::AES3_KEY3: KEY Position           */
#define CRPT_AES3_KEY3_KEY_Msk           (0xfffffffful << CRPT_AES3_KEY3_KEY_Pos)          /*!< CRPT_T::AES3_KEY3: KEY Mask               */

#define CRPT_AES3_KEY4_KEY_Pos           (0)                                               /*!< CRPT_T::AES3_KEY4: KEY Position           */
#define CRPT_AES3_KEY4_KEY_Msk           (0xfffffffful << CRPT_AES3_KEY4_KEY_Pos)          /*!< CRPT_T::AES3_KEY4: KEY Mask               */

#define CRPT_AES3_KEY5_KEY_Pos           (0)                                               /*!< CRPT_T::AES3_KEY5: KEY Position           */
#define CRPT_AES3_KEY5_KEY_Msk           (0xfffffffful << CRPT_AES3_KEY5_KEY_Pos)          /*!< CRPT_T::AES3_KEY5: KEY Mask               */

#define CRPT_AES3_KEY6_KEY_Pos           (0)                                               /*!< CRPT_T::AES3_KEY6: KEY Position           */
#define CRPT_AES3_KEY6_KEY_Msk           (0xfffffffful << CRPT_AES3_KEY6_KEY_Pos)          /*!< CRPT_T::AES3_KEY6: KEY Mask               */

#define CRPT_AES3_KEY7_KEY_Pos           (0)                                               /*!< CRPT_T::AES3_KEY7: KEY Position           */
#define CRPT_AES3_KEY7_KEY_Msk           (0xfffffffful << CRPT_AES3_KEY7_KEY_Pos)          /*!< CRPT_T::AES3_KEY7: KEY Mask               */

#define CRPT_AES3_IV0_IV_Pos             (0)                                               /*!< CRPT_T::AES3_IV0: IV Position             */
#define CRPT_AES3_IV0_IV_Msk             (0xfffffffful << CRPT_AES3_IV0_IV_Pos)            /*!< CRPT_T::AES3_IV0: IV Mask                 */

#define CRPT_AES3_IV1_IV_Pos             (0)                                               /*!< CRPT_T::AES3_IV1: IV Position             */
#define CRPT_AES3_IV1_IV_Msk             (0xfffffffful << CRPT_AES3_IV1_IV_Pos)            /*!< CRPT_T::AES3_IV1: IV Mask                 */

#define CRPT_AES3_IV2_IV_Pos             (0)                                               /*!< CRPT_T::AES3_IV2: IV Position             */
#define CRPT_AES3_IV2_IV_Msk             (0xfffffffful << CRPT_AES3_IV2_IV_Pos)            /*!< CRPT_T::AES3_IV2: IV Mask                 */

#define CRPT_AES3_IV3_IV_Pos             (0)                                               /*!< CRPT_T::AES3_IV3: IV Position             */
#define CRPT_AES3_IV3_IV_Msk             (0xfffffffful << CRPT_AES3_IV3_IV_Pos)            /*!< CRPT_T::AES3_IV3: IV Mask                 */

#define CRPT_AES3_SADDR_SADDR_Pos        (0)                                               /*!< CRPT_T::AES3_SADDR: SADDR Position        */
#define CRPT_AES3_SADDR_SADDR_Msk        (0xfffffffful << CRPT_AES3_SADDR_SADDR_Pos)       /*!< CRPT_T::AES3_SADDR: SADDR Mask            */

#define CRPT_AES3_DADDR_DADDR_Pos        (0)                                               /*!< CRPT_T::AES3_DADDR: DADDR Position        */
#define CRPT_AES3_DADDR_DADDR_Msk        (0xfffffffful << CRPT_AES3_DADDR_DADDR_Pos)       /*!< CRPT_T::AES3_DADDR: DADDR Mask            */

#define CRPT_AES3_CNT_CNT_Pos            (0)                                               /*!< CRPT_T::AES3_CNT: CNT Position            */
#define CRPT_AES3_CNT_CNT_Msk            (0xfffffffful << CRPT_AES3_CNT_CNT_Pos)           /*!< CRPT_T::AES3_CNT: CNT Mask                */

#define CRPT_TDES_CTL_START_Pos          (0)                                               /*!< CRPT_T::TDES_CTL: START Position          */
#define CRPT_TDES_CTL_START_Msk          (0x1ul << CRPT_TDES_CTL_START_Pos)                /*!< CRPT_T::TDES_CTL: START Mask              */

#define CRPT_TDES_CTL_STOP_Pos           (1)                                               /*!< CRPT_T::TDES_CTL: STOP Position           */
#define CRPT_TDES_CTL_STOP_Msk           (0x1ul << CRPT_TDES_CTL_STOP_Pos)                 /*!< CRPT_T::TDES_CTL: STOP Mask               */

#define CRPT_TDES_CTL_TMODE_Pos          (2)                                               /*!< CRPT_T::TDES_CTL: TMODE Position          */
#define CRPT_TDES_CTL_TMODE_Msk          (0x1ul << CRPT_TDES_CTL_TMODE_Pos)                /*!< CRPT_T::TDES_CTL: TMODE Mask              */

#define CRPT_TDES_CTL_3KEYS_Pos          (3)                                               /*!< CRPT_T::TDES_CTL: 3KEYS Position          */
#define CRPT_TDES_CTL_3KEYS_Msk          (0x1ul << CRPT_TDES_CTL_3KEYS_Pos)                /*!< CRPT_T::TDES_CTL: 3KEYS Mask              */

#define CRPT_TDES_CTL_DMALAST_Pos        (5)                                               /*!< CRPT_T::TDES_CTL: DMALAST Position        */
#define CRPT_TDES_CTL_DMALAST_Msk        (0x1ul << CRPT_TDES_CTL_DMALAST_Pos)              /*!< CRPT_T::TDES_CTL: DMALAST Mask            */

#define CRPT_TDES_CTL_DMACSCAD_Pos       (6)                                               /*!< CRPT_T::TDES_CTL: DMACSCAD Position       */
#define CRPT_TDES_CTL_DMACSCAD_Msk       (0x1ul << CRPT_TDES_CTL_DMACSCAD_Pos)             /*!< CRPT_T::TDES_CTL: DMACSCAD Mask           */

#define CRPT_TDES_CTL_DMAEN_Pos          (7)                                               /*!< CRPT_T::TDES_CTL: DMAEN Position          */
#define CRPT_TDES_CTL_DMAEN_Msk          (0x1ul << CRPT_TDES_CTL_DMAEN_Pos)                /*!< CRPT_T::TDES_CTL: DMAEN Mask              */

#define CRPT_TDES_CTL_OPMODE_Pos         (8)                                               /*!< CRPT_T::TDES_CTL: OPMODE Position         */
#define CRPT_TDES_CTL_OPMODE_Msk         (0x7ul << CRPT_TDES_CTL_OPMODE_Pos)               /*!< CRPT_T::TDES_CTL: OPMODE Mask             */

#define CRPT_TDES_CTL_ENCRPT_Pos         (16)                                              /*!< CRPT_T::TDES_CTL: ENCRPT Position         */
#define CRPT_TDES_CTL_ENCRPT_Msk         (0x1ul << CRPT_TDES_CTL_ENCRPT_Pos)               /*!< CRPT_T::TDES_CTL: ENCRPT Mask             */

#define CRPT_TDES_CTL_BLKSWAP_Pos        (21)                                              /*!< CRPT_T::TDES_CTL: BLKSWAP Position        */
#define CRPT_TDES_CTL_BLKSWAP_Msk        (0x1ul << CRPT_TDES_CTL_BLKSWAP_Pos)              /*!< CRPT_T::TDES_CTL: BLKSWAP Mask            */

#define CRPT_TDES_CTL_OUTSWAP_Pos        (22)                                              /*!< CRPT_T::TDES_CTL: OUTSWAP Position        */
#define CRPT_TDES_CTL_OUTSWAP_Msk        (0x1ul << CRPT_TDES_CTL_OUTSWAP_Pos)              /*!< CRPT_T::TDES_CTL: OUTSWAP Mask            */

#define CRPT_TDES_CTL_INSWAP_Pos         (23)                                              /*!< CRPT_T::TDES_CTL: INSWAP Position         */
#define CRPT_TDES_CTL_INSWAP_Msk         (0x1ul << CRPT_TDES_CTL_INSWAP_Pos)               /*!< CRPT_T::TDES_CTL: INSWAP Mask             */

#define CRPT_TDES_CTL_CHANNEL_Pos        (24)                                              /*!< CRPT_T::TDES_CTL: CHANNEL Position        */
#define CRPT_TDES_CTL_CHANNEL_Msk        (0x3ul << CRPT_TDES_CTL_CHANNEL_Pos)              /*!< CRPT_T::TDES_CTL: CHANNEL Mask            */

#define CRPT_TDES_CTL_KEYUNPRT_Pos       (26)                                              /*!< CRPT_T::TDES_CTL: KEYUNPRT Position       */
#define CRPT_TDES_CTL_KEYUNPRT_Msk       (0x1ful << CRPT_TDES_CTL_KEYUNPRT_Pos)            /*!< CRPT_T::TDES_CTL: KEYUNPRT Mask           */

#define CRPT_TDES_CTL_KEYPRT_Pos         (31)                                              /*!< CRPT_T::TDES_CTL: KEYPRT Position         */
#define CRPT_TDES_CTL_KEYPRT_Msk         (0x1ul << CRPT_TDES_CTL_KEYPRT_Pos)               /*!< CRPT_T::TDES_CTL: KEYPRT Mask             */

#define CRPT_TDES_STS_BUSY_Pos           (0)                                               /*!< CRPT_T::TDES_STS: BUSY Position           */
#define CRPT_TDES_STS_BUSY_Msk           (0x1ul << CRPT_TDES_STS_BUSY_Pos)                 /*!< CRPT_T::TDES_STS: BUSY Mask               */

#define CRPT_TDES_STS_INBUFEMPTY_Pos     (8)                                               /*!< CRPT_T::TDES_STS: INBUFEMPTY Position     */
#define CRPT_TDES_STS_INBUFEMPTY_Msk     (0x1ul << CRPT_TDES_STS_INBUFEMPTY_Pos)           /*!< CRPT_T::TDES_STS: INBUFEMPTY Mask         */

#define CRPT_TDES_STS_INBUFFULL_Pos      (9)                                               /*!< CRPT_T::TDES_STS: INBUFFULL Position      */
#define CRPT_TDES_STS_INBUFFULL_Msk      (0x1ul << CRPT_TDES_STS_INBUFFULL_Pos)            /*!< CRPT_T::TDES_STS: INBUFFULL Mask          */

#define CRPT_TDES_STS_INBUFERR_Pos       (10)                                              /*!< CRPT_T::TDES_STS: INBUFERR Position       */
#define CRPT_TDES_STS_INBUFERR_Msk       (0x1ul << CRPT_TDES_STS_INBUFERR_Pos)             /*!< CRPT_T::TDES_STS: INBUFERR Mask           */

#define CRPT_TDES_STS_OUTBUFEMPTY_Pos    (16)                                              /*!< CRPT_T::TDES_STS: OUTBUFEMPTY Position    */
#define CRPT_TDES_STS_OUTBUFEMPTY_Msk    (0x1ul << CRPT_TDES_STS_OUTBUFEMPTY_Pos)          /*!< CRPT_T::TDES_STS: OUTBUFEMPTY Mask        */

#define CRPT_TDES_STS_OUTBUFFULL_Pos     (17)                                              /*!< CRPT_T::TDES_STS: OUTBUFFULL Position     */
#define CRPT_TDES_STS_OUTBUFFULL_Msk     (0x1ul << CRPT_TDES_STS_OUTBUFFULL_Pos)           /*!< CRPT_T::TDES_STS: OUTBUFFULL Mask         */

#define CRPT_TDES_STS_OUTBUFERR_Pos      (18)                                              /*!< CRPT_T::TDES_STS: OUTBUFERR Position      */
#define CRPT_TDES_STS_OUTBUFERR_Msk      (0x1ul << CRPT_TDES_STS_OUTBUFERR_Pos)            /*!< CRPT_T::TDES_STS: OUTBUFERR Mask          */

#define CRPT_TDES_STS_BUSERR_Pos         (20)                                              /*!< CRPT_T::TDES_STS: BUSERR Position         */
#define CRPT_TDES_STS_BUSERR_Msk         (0x1ul << CRPT_TDES_STS_BUSERR_Pos)               /*!< CRPT_T::TDES_STS: BUSERR Mask             */

#define CRPT_TDES0_KEY1H_KEY_Pos         (0)                                               /*!< CRPT_T::TDES0_KEY1H: KEY Position         */
#define CRPT_TDES0_KEY1H_KEY_Msk         (0xfffffffful << CRPT_TDES0_KEY1H_KEY_Pos)        /*!< CRPT_T::TDES0_KEY1H: KEY Mask             */

#define CRPT_TDES0_KEY1L_KEY_Pos         (0)                                               /*!< CRPT_T::TDES0_KEY1L: KEY Position         */
#define CRPT_TDES0_KEY1L_KEY_Msk         (0xfffffffful << CRPT_TDES0_KEY1L_KEY_Pos)        /*!< CRPT_T::TDES0_KEY1L: KEY Mask             */

#define CRPT_TDES0_KEY2H_KEY_Pos         (0)                                               /*!< CRPT_T::TDES0_KEY2H: KEY Position         */
#define CRPT_TDES0_KEY2H_KEY_Msk         (0xfffffffful << CRPT_TDES0_KEY2H_KEY_Pos)        /*!< CRPT_T::TDES0_KEY2H: KEY Mask             */

#define CRPT_TDES0_KEY2L_KEY_Pos         (0)                                               /*!< CRPT_T::TDES0_KEY2L: KEY Position         */
#define CRPT_TDES0_KEY2L_KEY_Msk         (0xfffffffful << CRPT_TDES0_KEY2L_KEY_Pos)        /*!< CRPT_T::TDES0_KEY2L: KEY Mask             */

#define CRPT_TDES0_KEY3H_KEY_Pos         (0)                                               /*!< CRPT_T::TDES0_KEY3H: KEY Position         */
#define CRPT_TDES0_KEY3H_KEY_Msk         (0xfffffffful << CRPT_TDES0_KEY3H_KEY_Pos)        /*!< CRPT_T::TDES0_KEY3H: KEY Mask             */

#define CRPT_TDES0_KEY3L_KEY_Pos         (0)                                               /*!< CRPT_T::TDES0_KEY3L: KEY Position         */
#define CRPT_TDES0_KEY3L_KEY_Msk         (0xfffffffful << CRPT_TDES0_KEY3L_KEY_Pos)        /*!< CRPT_T::TDES0_KEY3L: KEY Mask             */

#define CRPT_TDES0_IVH_IV_Pos            (0)                                               /*!< CRPT_T::TDES0_IVH: IV Position            */
#define CRPT_TDES0_IVH_IV_Msk            (0xfffffffful << CRPT_TDES0_IVH_IV_Pos)           /*!< CRPT_T::TDES0_IVH: IV Mask                */

#define CRPT_TDES0_IVL_IV_Pos            (0)                                               /*!< CRPT_T::TDES0_IVL: IV Position            */
#define CRPT_TDES0_IVL_IV_Msk            (0xfffffffful << CRPT_TDES0_IVL_IV_Pos)           /*!< CRPT_T::TDES0_IVL: IV Mask                */

#define CRPT_TDES0_SADDR_SADDR_Pos       (0)                                               /*!< CRPT_T::TDES0_SADDR: SADDR Position       */
#define CRPT_TDES0_SADDR_SADDR_Msk       (0xfffffffful << CRPT_TDES0_SADDR_SADDR_Pos)      /*!< CRPT_T::TDES0_SADDR: SADDR Mask           */

#define CRPT_TDES0_DADDR_DADDR_Pos       (0)                                               /*!< CRPT_T::TDES0_DADDR: DADDR Position       */
#define CRPT_TDES0_DADDR_DADDR_Msk       (0xfffffffful << CRPT_TDES0_DADDR_DADDR_Pos)      /*!< CRPT_T::TDES0_DADDR: DADDR Mask           */

#define CRPT_TDES0_CNT_CNT_Pos           (0)                                               /*!< CRPT_T::TDES0_CNT: CNT Position           */
#define CRPT_TDES0_CNT_CNT_Msk           (0xfffffffful << CRPT_TDES0_CNT_CNT_Pos)          /*!< CRPT_T::TDES0_CNT: CNT Mask               */

#define CRPT_TDES_DATIN_DATIN_Pos        (0)                                               /*!< CRPT_T::TDES_DATIN: DATIN Position        */
#define CRPT_TDES_DATIN_DATIN_Msk        (0xfffffffful << CRPT_TDES_DATIN_DATIN_Pos)       /*!< CRPT_T::TDES_DATIN: DATIN Mask            */

#define CRPT_TDES_DATOUT_DATOUT_Pos      (0)                                               /*!< CRPT_T::TDES_DATOUT: DATOUT Position      */
#define CRPT_TDES_DATOUT_DATOUT_Msk      (0xfffffffful << CRPT_TDES_DATOUT_DATOUT_Pos)     /*!< CRPT_T::TDES_DATOUT: DATOUT Mask          */

#define CRPT_TDES1_KEY1H_KEY_Pos         (0)                                               /*!< CRPT_T::TDES1_KEY1H: KEY Position         */
#define CRPT_TDES1_KEY1H_KEY_Msk         (0xfffffffful << CRPT_TDES1_KEY1H_KEY_Pos)        /*!< CRPT_T::TDES1_KEY1H: KEY Mask             */

#define CRPT_TDES1_KEY1L_KEYL_Pos        (0)                                               /*!< CRPT_T::TDES1_KEY1L: KEY Position         */
#define CRPT_TDES1_KEY1L_KEY_Msk         (0xfffffffful << CRPT_TDES1_KEY1L_KEY_Pos)        /*!< CRPT_T::TDES1_KEY1L: KEY Mask             */

#define CRPT_TDES1_KEY2H_KEY_Pos         (0)                                               /*!< CRPT_T::TDES1_KEY2H: KEY Position         */
#define CRPT_TDES1_KEY2H_KEY_Msk         (0xfffffffful << CRPT_TDES1_KEY2H_KEY_Pos)        /*!< CRPT_T::TDES1_KEY2H: KEY Mask             */

#define CRPT_TDES1_KEY2L_KEY_Pos         (0)                                               /*!< CRPT_T::TDES1_KEY2L: KEY Position         */
#define CRPT_TDES1_KEY2L_KEY_Msk         (0xfffffffful << CRPT_TDES1_KEY2L_KEY_Pos)        /*!< CRPT_T::TDES1_KEY2L: KEY Mask             */

#define CRPT_TDES1_KEY3H_KEY_Pos         (0)                                               /*!< CRPT_T::TDES1_KEY3H: KEY Position         */
#define CRPT_TDES1_KEY3H_KEY_Msk         (0xfffffffful << CRPT_TDES1_KEY3H_KEY_Pos)        /*!< CRPT_T::TDES1_KEY3H: KEY Mask             */

#define CRPT_TDES1_KEY3L_KEY_Pos         (0)                                               /*!< CRPT_T::TDES1_KEY3L: KEY Position         */
#define CRPT_TDES1_KEY3L_KEY_Msk         (0xfffffffful << CRPT_TDES1_KEY3L_KEY_Pos)        /*!< CRPT_T::TDES1_KEY3L: KEY Mask             */

#define CRPT_TDES1_IVH_IV_Pos            (0)                                               /*!< CRPT_T::TDES1_IVH: IV Position            */
#define CRPT_TDES1_IVH_IV_Msk            (0xfffffffful << CRPT_TDES1_IVH_IV_Pos)           /*!< CRPT_T::TDES1_IVH: IV Mask                */

#define CRPT_TDES1_IVL_IV_Pos            (0)                                               /*!< CRPT_T::TDES1_IVL: IV Position            */
#define CRPT_TDES1_IVL_IV_Msk            (0xfffffffful << CRPT_TDES1_IVL_IV_Pos)           /*!< CRPT_T::TDES1_IVL: IV Mask                */

#define CRPT_TDES1_SADDR_SADDR_Pos       (0)                                               /*!< CRPT_T::TDES1_SADDR: SADDR Position       */
#define CRPT_TDES1_SADDR_SADDR_Msk       (0xfffffffful << CRPT_TDES1_SADDR_SADDR_Pos)      /*!< CRPT_T::TDES1_SADDR: SADDR Mask           */

#define CRPT_TDES1_DADDR_DADDR_Pos       (0)                                               /*!< CRPT_T::TDES1_DADDR: DADDR Position       */
#define CRPT_TDES1_DADDR_DADDR_Msk       (0xfffffffful << CRPT_TDES1_DADDR_DADDR_Pos)      /*!< CRPT_T::TDES1_DADDR: DADDR Mask           */

#define CRPT_TDES1_CNT_CNT_Pos           (0)                                               /*!< CRPT_T::TDES1_CNT: CNT Position           */
#define CRPT_TDES1_CNT_CNT_Msk           (0xfffffffful << CRPT_TDES1_CNT_CNT_Pos)          /*!< CRPT_T::TDES1_CNT: CNT Mask               */

#define CRPT_TDES2_KEY1H_KEY_Pos         (0)                                               /*!< CRPT_T::TDES2_KEY1H: KEY Position         */
#define CRPT_TDES2_KEY1H_KEY_Msk         (0xfffffffful << CRPT_TDES2_KEY1H_KEY_Pos)        /*!< CRPT_T::TDES2_KEY1H: KEY Mask             */

#define CRPT_TDES2_KEY1L_KEY_Pos         (0)                                               /*!< CRPT_T::TDES2_KEY1L: KEY Position         */
#define CRPT_TDES2_KEY1L_KEY_Msk         (0xfffffffful << CRPT_TDES2_KEY1L_KEY_Pos)        /*!< CRPT_T::TDES2_KEY1L: KEY Mask             */

#define CRPT_TDES2_KEY2H_KEY_Pos         (0)                                               /*!< CRPT_T::TDES2_KEY2H: KEY Position         */
#define CRPT_TDES2_KEY2H_KEY_Msk         (0xfffffffful << CRPT_TDES2_KEY2H_KEY_Pos)        /*!< CRPT_T::TDES2_KEY2H: KEY Mask             */

#define CRPT_TDES2_KEY2L_KEY_Pos         (0)                                               /*!< CRPT_T::TDES2_KEY2L: KEY Position         */
#define CRPT_TDES2_KEY2L_KEY_Msk         (0xfffffffful << CRPT_TDES2_KEY2L_KEY_Pos)        /*!< CRPT_T::TDES2_KEY2L: KEY Mask             */

#define CRPT_TDES2_KEY3H_KEY_Pos         (0)                                               /*!< CRPT_T::TDES2_KEY3H: KEY Position         */
#define CRPT_TDES2_KEY3H_KEY_Msk         (0xfffffffful << CRPT_TDES2_KEY3H_KEY_Pos)        /*!< CRPT_T::TDES2_KEY3H: KEY Mask             */

#define CRPT_TDES2_KEY3L_KEY_Pos         (0)                                               /*!< CRPT_T::TDES2_KEY3L: KEY Position         */
#define CRPT_TDES2_KEY3L_KEY_Msk         (0xfffffffful << CRPT_TDES2_KEY3L_KEY_Pos)        /*!< CRPT_T::TDES2_KEY3L: KEY Mask             */

#define CRPT_TDES2_IVH_IV_Pos            (0)                                               /*!< CRPT_T::TDES2_IVH: IV Position            */
#define CRPT_TDES2_IVH_IV_Msk            (0xfffffffful << CRPT_TDES2_IVH_IV_Pos)           /*!< CRPT_T::TDES2_IVH: IV Mask                */

#define CRPT_TDES2_IVL_IV_Pos            (0)                                               /*!< CRPT_T::TDES2_IVL: IV Position            */
#define CRPT_TDES2_IVL_IV_Msk            (0xfffffffful << CRPT_TDES2_IVL_IV_Pos)           /*!< CRPT_T::TDES2_IVL: IV Mask                */

#define CRPT_TDES2_SADDR_SADDR_Pos       (0)                                               /*!< CRPT_T::TDES2_SADDR: SADDR Position       */
#define CRPT_TDES2_SADDR_SADDR_Msk       (0xfffffffful << CRPT_TDES2_SADDR_SADDR_Pos)      /*!< CRPT_T::TDES2_SADDR: SADDR Mask           */

#define CRPT_TDES2_DADDR_DADDR_Pos       (0)                                               /*!< CRPT_T::TDES2_DADDR: DADDR Position       */
#define CRPT_TDES2_DADDR_DADDR_Msk       (0xfffffffful << CRPT_TDES2_DADDR_DADDR_Pos)      /*!< CRPT_T::TDES2_DADDR: DADDR Mask           */

#define CRPT_TDES2_CNT_CNT_Pos           (0)                                               /*!< CRPT_T::TDES2_CNT: CNT Position           */
#define CRPT_TDES2_CNT_CNT_Msk           (0xfffffffful << CRPT_TDES2_CNT_CNT_Pos)          /*!< CRPT_T::TDES2_CNT: CNT Mask               */

#define CRPT_TDES3_KEY1H_KEY_Pos         (0)                                               /*!< CRPT_T::TDES3_KEY1H: KEY Position         */
#define CRPT_TDES3_KEY1H_KEY_Msk         (0xfffffffful << CRPT_TDES3_KEY1H_KEY_Pos)        /*!< CRPT_T::TDES3_KEY1H: KEY Mask             */

#define CRPT_TDES3_KEY1L_KEY_Pos         (0)                                               /*!< CRPT_T::TDES3_KEY1L: KEY Position         */
#define CRPT_TDES3_KEY1L_KEY_Msk         (0xfffffffful << CRPT_TDES3_KEY1L_KEY_Pos)        /*!< CRPT_T::TDES3_KEY1L: KEY Mask             */

#define CRPT_TDES3_KEY2H_KEY_Pos         (0)                                               /*!< CRPT_T::TDES3_KEY2H: KEY Position         */
#define CRPT_TDES3_KEY2H_KEY_Msk         (0xfffffffful << CRPT_TDES3_KEY2H_KEY_Pos)        /*!< CRPT_T::TDES3_KEY2H: KEY Mask             */

#define CRPT_TDES3_KEY2L_KEY_Pos         (0)                                               /*!< CRPT_T::TDES3_KEY2L: KEY Position         */
#define CRPT_TDES3_KEY2L_KEY_Msk         (0xfffffffful << CRPT_TDES3_KEY2L_KEY_Pos)        /*!< CRPT_T::TDES3_KEY2L: KEY Mask             */

#define CRPT_TDES3_KEY3H_KEY_Pos         (0)                                               /*!< CRPT_T::TDES3_KEY3H: KEY Position         */
#define CRPT_TDES3_KEY3H_KEY_Msk         (0xfffffffful << CRPT_TDES3_KEY3H_KEY_Pos)        /*!< CRPT_T::TDES3_KEY3H: KEY Mask             */

#define CRPT_TDES3_KEY3L_KEY_Pos         (0)                                               /*!< CRPT_T::TDES3_KEY3L: KEY Position         */
#define CRPT_TDES3_KEY3L_KEY_Msk         (0xfffffffful << CRPT_TDES3_KEY3L_KEY_Pos)        /*!< CRPT_T::TDES3_KEY3L: KEY Mask             */

#define CRPT_TDES3_IVH_IV_Pos            (0)                                               /*!< CRPT_T::TDES3_IVH: IV Position            */
#define CRPT_TDES3_IVH_IV_Msk            (0xfffffffful << CRPT_TDES3_IVH_IV_Pos)           /*!< CRPT_T::TDES3_IVH: IV Mask                */

#define CRPT_TDES3_IVL_IV_Pos            (0)                                               /*!< CRPT_T::TDES3_IVL: IV Position            */
#define CRPT_TDES3_IVL_IV_Msk            (0xfffffffful << CRPT_TDES3_IVL_IV_Pos)           /*!< CRPT_T::TDES3_IVL: IV Mask                */

#define CRPT_TDES3_SADDR_SADDR_Pos       (0)                                               /*!< CRPT_T::TDES3_SADDR: SADDR Position       */
#define CRPT_TDES3_SADDR_SADDR_Msk       (0xfffffffful << CRPT_TDES3_SADDR_SADDR_Pos)      /*!< CRPT_T::TDES3_SADDR: SADDR Mask           */

#define CRPT_TDES3_DADDR_DADDR_Pos       (0)                                               /*!< CRPT_T::TDES3_DADDR: DADDR Position       */
#define CRPT_TDES3_DADDR_DADDR_Msk       (0xfffffffful << CRPT_TDES3_DADDR_DADDR_Pos)      /*!< CRPT_T::TDES3_DADDR: DADDR Mask           */

#define CRPT_TDES3_CNT_CNT_Pos           (0)                                               /*!< CRPT_T::TDES3_CNT: CNT Position           */
#define CRPT_TDES3_CNT_CNT_Msk           (0xfffffffful << CRPT_TDES3_CNT_CNT_Pos)          /*!< CRPT_T::TDES3_CNT: CNT Mask               */

#define CRPT_SHA_CTL_START_Pos           (0)                                               /*!< CRPT_T::SHA_CTL: START Position           */
#define CRPT_SHA_CTL_START_Msk           (0x1ul << CRPT_SHA_CTL_START_Pos)                 /*!< CRPT_T::SHA_CTL: START Mask               */

#define CRPT_SHA_CTL_STOP_Pos            (1)                                               /*!< CRPT_T::SHA_CTL: STOP Position            */
#define CRPT_SHA_CTL_STOP_Msk            (0x1ul << CRPT_SHA_CTL_STOP_Pos)                  /*!< CRPT_T::SHA_CTL: STOP Mask                */

#define CRPT_SHA_CTL_DMALAST_Pos         (5)                                               /*!< CRPT_T::SHA_CTL: DMALAST Position         */
#define CRPT_SHA_CTL_DMALAST_Msk         (0x1ul << CRPT_SHA_CTL_DMALAST_Pos)               /*!< CRPT_T::SHA_CTL: DMALAST Mask             */

#define CRPT_SHA_CTL_DMAEN_Pos           (7)                                               /*!< CRPT_T::SHA_CTL: DMAEN Position           */
#define CRPT_SHA_CTL_DMAEN_Msk           (0x1ul << CRPT_SHA_CTL_DMAEN_Pos)                 /*!< CRPT_T::SHA_CTL: DMAEN Mask               */

#define CRPT_SHA_CTL_OPMODE_Pos          (8)                                               /*!< CRPT_T::SHA_CTL: OPMODE Position          */
#define CRPT_SHA_CTL_OPMODE_Msk          (0x7ul << CRPT_SHA_CTL_OPMODE_Pos)                /*!< CRPT_T::SHA_CTL: OPMODE Mask              */

#define CRPT_SHA_CTL_OUTSWAP_Pos         (22)                                              /*!< CRPT_T::SHA_CTL: OUTSWAP Position         */
#define CRPT_SHA_CTL_OUTSWAP_Msk         (0x1ul << CRPT_SHA_CTL_OUTSWAP_Pos)               /*!< CRPT_T::SHA_CTL: OUTSWAP Mask             */

#define CRPT_SHA_CTL_INSWAP_Pos          (23)                                              /*!< CRPT_T::SHA_CTL: INSWAP Position          */
#define CRPT_SHA_CTL_INSWAP_Msk          (0x1ul << CRPT_SHA_CTL_INSWAP_Pos)                /*!< CRPT_T::SHA_CTL: INSWAP Mask              */

#define CRPT_SHA_STS_BUSY_Pos            (0)                                               /*!< CRPT_T::SHA_STS: BUSY Position            */
#define CRPT_SHA_STS_BUSY_Msk            (0x1ul << CRPT_SHA_STS_BUSY_Pos)                  /*!< CRPT_T::SHA_STS: BUSY Mask                */

#define CRPT_SHA_STS_DMABUSY_Pos         (1)                                               /*!< CRPT_T::SHA_STS: DMABUSY Position         */
#define CRPT_SHA_STS_DMABUSY_Msk         (0x1ul << CRPT_SHA_STS_DMABUSY_Pos)               /*!< CRPT_T::SHA_STS: DMABUSY Mask             */

#define CRPT_SHA_STS_DMAERR_Pos          (8)                                               /*!< CRPT_T::SHA_STS: DMAERR Position          */
#define CRPT_SHA_STS_DMAERR_Msk          (0x1ul << CRPT_SHA_STS_DMAERR_Pos)                /*!< CRPT_T::SHA_STS: DMAERR Mask              */

#define CRPT_SHA_STS_DATINREQ_Pos        (16)                                              /*!< CRPT_T::SHA_STS: DATINREQ Position        */
#define CRPT_SHA_STS_DATINREQ_Msk        (0x1ul << CRPT_SHA_STS_DATINREQ_Pos)              /*!< CRPT_T::SHA_STS: DATINREQ Mask            */

#define CRPT_SHA_DGST0_DGST_Pos          (0)                                               /*!< CRPT_T::SHA_DGST0: DGST Position          */
#define CRPT_SHA_DGST0_DGST_Msk          (0xfffffffful << CRPT_SHA_DGST0_DGST_Pos)         /*!< CRPT_T::SHA_DGST0: DGST Mask              */

#define CRPT_SHA_DGST1_DGST_Pos          (0)                                               /*!< CRPT_T::SHA_DGST1: DGST Position          */
#define CRPT_SHA_DGST1_DGST_Msk          (0xfffffffful << CRPT_SHA_DGST1_DGST_Pos)         /*!< CRPT_T::SHA_DGST1: DGST Mask              */

#define CRPT_SHA_DGST2_DGST_Pos          (0)                                               /*!< CRPT_T::SHA_DGST2: DGST Position          */
#define CRPT_SHA_DGST2_DGST_Msk          (0xfffffffful << CRPT_SHA_DGST2_DGST_Pos)         /*!< CRPT_T::SHA_DGST2: DGST Mask              */

#define CRPT_SHA_DGST3_DGST_Pos          (0)                                               /*!< CRPT_T::SHA_DGST3: DGST Position          */
#define CRPT_SHA_DGST3_DGST_Msk          (0xfffffffful << CRPT_SHA_DGST3_DGST_Pos)         /*!< CRPT_T::SHA_DGST3: DGST Mask              */

#define CRPT_SHA_DGST4_DGST_Pos          (0)                                               /*!< CRPT_T::SHA_DGST4: DGST Position          */
#define CRPT_SHA_DGST4_DGST_Msk          (0xfffffffful << CRPT_SHA_DGST4_DGST_Pos)         /*!< CRPT_T::SHA_DGST4: DGST Mask              */

#define CRPT_SHA_DGST5_DGST_Pos          (0)                                               /*!< CRPT_T::SHA_DGST5: DGST Position          */
#define CRPT_SHA_DGST5_DGST_Msk          (0xfffffffful << CRPT_SHA_DGST5_DGST_Pos)         /*!< CRPT_T::SHA_DGST5: DGST Mask              */

#define CRPT_SHA_DGST6_DGST_Pos          (0)                                               /*!< CRPT_T::SHA_DGST6: DGST Position          */
#define CRPT_SHA_DGST6_DGST_Msk          (0xfffffffful << CRPT_SHA_DGST6_DGST_Pos)         /*!< CRPT_T::SHA_DGST6: DGST Mask              */

#define CRPT_SHA_DGST7_DGST_Pos          (0)                                               /*!< CRPT_T::SHA_DGST7: DGST Position          */
#define CRPT_SHA_DGST7_DGST_Msk          (0xfffffffful << CRPT_SHA_DGST7_DGST_Pos)         /*!< CRPT_T::SHA_DGST7: DGST Mask              */

#define CRPT_SHA_KEYCNT_KEYCNT_Pos       (0)                                               /*!< CRPT_T::SHA_KEYCNT: KEYCNT Position       */
#define CRPT_SHA_KEYCNT_KEYCNT_Msk       (0xfffffffful << CRPT_SHA_KEYCNT_KEYCNT_Pos)      /*!< CRPT_T::SHA_KEYCNT: KEYCNT Mask           */

#define CRPT_SHA_SADDR_SADDR_Pos         (0)                                               /*!< CRPT_T::SHA_SADDR: SADDR Position         */
#define CRPT_SHA_SADDR_SADDR_Msk         (0xfffffffful << CRPT_SHA_SADDR_SADDR_Pos)        /*!< CRPT_T::SHA_SADDR: SADDR Mask             */

#define CRPT_SHA_DMACNT_DMACNT_Pos       (0)                                               /*!< CRPT_T::SHA_DMACNT: DMACNT Position       */
#define CRPT_SHA_DMACNT_DMACNT_Msk       (0xfffffffful << CRPT_SHA_DMACNT_DMACNT_Pos)      /*!< CRPT_T::SHA_DMACNT: DMACNT Mask           */

#define CRPT_SHA_DATIN_DATIN_Pos         (0)                                               /*!< CRPT_T::SHA_DATIN: DATIN Position         */
#define CRPT_SHA_DATIN_DATIN_Msk         (0xfffffffful << CRPT_SHA_DATIN_DATIN_Pos)        /*!< CRPT_T::SHA_DATIN: DATIN Mask             */

/**@}*/ /* CRPT_CONST */
/**@}*/ /* end of CRPT register group */


/*---------------------- Enhanced Analog to Digital Converter -------------------------*/
/**
    @addtogroup EADC Enhanced Analog to Digital Converter(EADC)
    Memory Mapped Structure for EADC Controller
@{ */

typedef struct {


    /**
     * AD0DAT0
     * ===================================================================================================
     * Offset: 0x00  A/D Data Register 0 for SAMPLE00
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD0DAT0;

    /**
     * AD0DAT1
     * ===================================================================================================
     * Offset: 0x04  A/D Data Register 1 for SAMPLE01
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD0DAT1;

    /**
     * AD0DAT2
     * ===================================================================================================
     * Offset: 0x08  A/D Data Register 2 for SAMPLE02
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD0DAT2;

    /**
     * AD0DAT3
     * ===================================================================================================
     * Offset: 0x0C  A/D Data Register 3 for SAMPLE03
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD0DAT3;

    /**
     * AD0DAT4
     * ===================================================================================================
     * Offset: 0x10  A/D Data Register 4 for SAMPLE04
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD0DAT4;

    /**
     * AD0DAT5
     * ===================================================================================================
     * Offset: 0x14  A/D Data Register 5 for SAMPLE05
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD0DAT5;

    /**
     * AD0DAT6
     * ===================================================================================================
     * Offset: 0x18  A/D Data Register 6 for SAMPLE06
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD0DAT6;

    /**
     * AD0DAT7
     * ===================================================================================================
     * Offset: 0x1C  A/D Data Register 7 for SAMPLE07
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD0DAT7;

    /**
     * AD1DAT0
     * ===================================================================================================
     * Offset: 0x20  A/D Data Register 8 for SAMPLE10
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD1DAT0;

    /**
     * AD1DAT1
     * ===================================================================================================
     * Offset: 0x24  A/D Data Register 9 for SAMPLE11
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD1DAT1;

    /**
     * AD1DAT2
     * ===================================================================================================
     * Offset: 0x28  A/D Data Register 10 for SAMPLE12
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD1DAT2;

    /**
     * AD1DAT3
     * ===================================================================================================
     * Offset: 0x2C  A/D Data Register 11 for SAMPLE13
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD1DAT3;

    /**
     * AD1DAT4
     * ===================================================================================================
     * Offset: 0x30  A/D Data Register 12 for SAMPLE14
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD1DAT4;

    /**
     * AD1DAT5
     * ===================================================================================================
     * Offset: 0x34  A/D Data Register 13 for SAMPLE15
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD1DAT5;

    /**
     * AD1DAT6
     * ===================================================================================================
     * Offset: 0x38  A/D Data Register 14 for SAMPLE16
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD1DAT6;

    /**
     * AD1DAT7
     * ===================================================================================================
     * Offset: 0x3C  A/D Data Register 15 for SAMPLE17
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |OV        |Overrun Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is recent conversion result.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is overwrite.
     * |        |          |If converted data in RESULT (EADC_ADnDATx[11:0]) has not been read before new conversion result is loaded to this register, OV (EADC_ADnDATx[16]) is set to 1.
     * |        |          |It is cleared by hardware after EADC_ADnDATx register is read.
     * |[17]    |VALID     |Valid Flag
     * |        |          |0 = Data in RESULT (EADC_ADnDATx[11:0]) is not valid.
     * |        |          |1 = Data in RESULT (EADC_ADnDATx[11:0]) is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD1DAT7;

    /**
     * CTL
     * ===================================================================================================
     * Offset: 0x40  A/D Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |ADCEN     |A/D Converter Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |        |          |Before starting A/D conversion function, this bit should be set to 1.
     * |        |          |Clear it to 0 to disable A/D converter analog circuit power consumption.
     * |[1]     |ADCRST    |ADC0, ADC1 A/D Converter Control Circuits Reset
     * |        |          |0 = No effect.
     * |        |          |1 = Cause ADC control circuits reset to initial state, but not change the ADC registers value.
     * |        |          |The ADCRST (EADC_CTL [1]) bit remains 1 during ADC reset, when ADC reset end, the ADCRST (EADC_CTL [1]) bit is automatically cleared to 0.
     * |[2]     |ADCIEN0   |Specific SAMPLE A/D ADINT0 Interrupt Enable Control
     * |        |          |0 = Specific SAMPLE A/D ADINT0 interrupt function Disabled.
     * |        |          |1 = Specific SAMPLE A/D ADINT0 interrupt function Enabled.
     * |        |          |The A/D converter generates a conversion end ADIF0 (EADC_STATUS1 [0]) flag upon the end of specific SAMPLE A/D conversion.
     * |        |          |If ADCIEN0 (EADC_CTL [2]) bit is set then conversion end interrupt request ADINT0 is generated.
     * |[3]     |ADCIEN1   |Specific SAMPLE A/D ADINT1 Interrupt Enable Control
     * |        |          |0 = Specific SAMPLE A/D ADINT1 interrupt function Disabled.
     * |        |          |1 = Specific SAMPLE A/D ADINT1 interrupt function Enabled.
     * |        |          |The A/D converter generates a conversion end ADIF0 (EADC_STATUS1 [1]) flag upon the end of specific SAMPLE A/D conversion.
     * |        |          |If ADCIEN1 EADC_CTL [3]) bit is set then conversion end interrupt request ADINT1 is generated.
     * |[4]     |ADCIEN2   |Specific SAMPLE A/D ADINT2 Interrupt Enable Control
     * |        |          |0 = Specific SAMPLE A/D ADINT2 interrupt function Disabled.
     * |        |          |1 = Specific SAMPLE A/D ADINT2 interrupt function Enabled.
     * |        |          |The A/D converter generates a conversion end ADIF2 (EADC_STATUS1 [2]) flag upon the end of specific SAMPLE A/D conversion.
     * |        |          |If ADCIEN2 (EADC_CTL [4]) bit is set then conversion end interrupt request ADINT2 is generated.
     * |[5]     |ADCIEN3   |Specific SAMPLE A/D ADINT3 Interrupt Enable Control
     * |        |          |0 = Specific SAMPLE A/D ADINT3 interrupt function Disabled.
     * |        |          |1 = Specific SAMPLE A/D ADINT3 interrupt function Enabled.
     * |        |          |The A/D converter generates a conversion end ADIF3 (EADC_STATUS1 [3]) flag upon the end of specific SAMPLE A/D conversion.
     * |        |          |If ADCIEN3 (EADC_CTL [5]) bit is set then conversion end interrupt request ADINT3 is generated.
    */
    __IO uint32_t CTL;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE0[1];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * SWTRG
     * ===================================================================================================
     * Offset: 0x48  A/D SAMPLE Software Start Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |SWTRG7_0  |A/D SAMPLE07~SAMPLE00 Software Force To Start ADC Conversion
     * |        |          |0 = No effect.
     * |        |          |1 = Start an ADC conversion when the priority is given to SAMPLE0x.
     * |        |          |Note: x = 0~7.
     * |[8:15]  |SWTRG15_8 |A/D SAMPLE17~SAMPLE10 Software Force To Start ADC Conversion
     * |        |          |0 = No effect.
     * |        |          |1 = Start an ADC conversion when the priority is given to SAMPLE1x.
     * |        |          |Note: x = 0~7.
    */
    __O  uint32_t SWTRG;

    /**
     * PENDSTS
     * ===================================================================================================
     * Offset: 0x4C  A/D Start of Conversion Pending Flag Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |STPF7_0   |A/D SAMPLE07~SAMPLE00 Start Of Conversion Pending Flag
     * |        |          |0 = There is no pending conversion for SAMPLE0x.
     * |        |          |1 = SAMPLE0x ADC start of conversion is pending.
     * |        |          |Note: This bit remains 1 during pending state, when the respective ADC conversion is started, the STPF bit is automatically cleared to 0.
     * |        |          |Note: x = 0~7.
     * |[8:15]  |STPF15_8  |A/D SAMPLE17~SAMPLE10 Start Of Conversion Pending Flag
     * |        |          |0 = There is no pending conversion for SAMPLE1x.
     * |        |          |1 = SAMPLE1x ADC start of conversion is pending.
     * |        |          |Note: This bit remains 1 during pending state, when the respective ADC conversion is started, the STPF bit is automatically cleared to 0.
     * |        |          |Note: x = 0~7.
    */
    __I  uint32_t PENDSTS;

    /**
     * ADIFOV
     * ===================================================================================================
     * Offset: 0x50  A/D ADINT3~0 Interrupt Flag Overrun Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |ADFOV0    |A/D ADINT0 Interrupt Flag Overrun
     * |        |          |0 = ADINT0 interrupt flag is not overwritten to 1.
     * |        |          |1 = ADINT0 interrupt flag is overwritten to 1.
     * |        |          |Note: This bit is cleared by writing 1 to it.
     * |[1]     |ADFOV1    |A/D ADINT1 Interrupt Flag Overrun
     * |        |          |0 = ADINT1 interrupt flag is not overwritten to 1.
     * |        |          |1 = ADINT1 interrupt flag is overwritten to 1.
     * |        |          |Note: This bit is cleared by writing 1 to it.
     * |[2]     |ADFOV2    |A/D ADINT2 Interrupt Flag Overrun
     * |        |          |0 = ADINT2 interrupt flag is not overwritten to 1.
     * |        |          |1 = ADINT2 interrupt flag is overwritten to 1.
     * |        |          |Note: This bit is cleared by writing 1 to it.
     * |[3]     |ADFOV3    |A/D ADINT3 Interrupt Flag Overrun
     * |        |          |0 = ADINT3 interrupt flag is not overwritten to 1.
     * |        |          |1 = ADINT3 interrupt flag is overwritten to 1.
     * |        |          |Note: This bit is cleared by writing 1 to it.
    */
    __IO uint32_t ADIFOV;

    /**
     * OVSTS
     * ===================================================================================================
     * Offset: 0x54  A/D SAMPLE Start of Conversion Overrun Flag Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |SPOVF7_0  |A/D SAMPLE07~SAMPLE00 Start Of Conversion Overrun Flag
     * |        |          |0 = No SAMPLE0x event overrun.
     * |        |          |1 = Indicates a new SAMPLE0x event is generated while an old one event is pending.
     * |        |          |If there is a new trigger event comes when the SAMPLE is pending for the last trigger event, the overrun is happened and the SPOVF bit will be set as 1.
     * |        |          |Note: This bit is cleared by writing 1 to it.
     * |        |          |Note: x = 0~7.
     * |[8:15]  |SPOVF15_8 |A/D SAMPLE17~SAMPLE10 Start Of Conversion Overrun Flag
     * |        |          |0 = No SAMPLE1x event overrun.
     * |        |          |1 = Indicates a new SAMPLE1x event is generated while an old one event is pending.
     * |        |          |If there is a new trigger event comes when the SAMPLE is pending for the last trigger event, the overrun is happened and the SPOVF bit will be set as 1.
     * |        |          |Note: This bit is cleared by writing 1 to it.
     * |        |          |Note: x = 0~7.
    */
    __IO uint32_t OVSTS;

    /**
     * AD0SPCTL0
     * ===================================================================================================
     * Offset: 0x58  A/D SAMPLE00 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:7]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |0000 = Disable hardware trigger.
     * |        |          |0001 = External pin (STADC) trigger.
     * |        |          |0010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |0011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |0100 = Timer0 overflow pulse trigger.
     * |        |          |0101 = Timer1 overflow pulse trigger.
     * |        |          |0110 = Timer2 overflow pulse trigger.
     * |        |          |0111 = Timer3 overflow pulse trigger.
     * |        |          |1000 = EPWM0_CH0 trigger.
     * |        |          |1001 = EPWM0_CH2 trigger.
     * |        |          |1010 = EPWM0_CH4 trigger.
     * |        |          |1011 = EPWM1_CH0 trigger.
     * |        |          |1100 = EPWM1_CH2 trigger.
     * |        |          |1101 = EPWM1_CH4 trigger.
     * |        |          |1110 = PWM0_CH0 trigger.
     * |        |          |1111 = PWM0_CH1 trigger.
     * |[8:15]  |TRGDLYCNT |A/D SAMPLE Start Of Conversion Trigger Delay Time
     * |        |          |Trigger delay time = (TRGDLYCNT + 4) x Trigger delay clock period.
     * |[16:17] |TRGDLYDIV |A/D SAMPLE Start Of Conversion Trigger Delay Clock Divider Selection
     * |        |          |Trigger delay clock frequency:
     * |        |          |00 = ADC_CLK/1.
     * |        |          |01 = ADC_CLK/2.
     * |        |          |10 = ADC_CLK/4.
     * |        |          |11 = ADC_CLK/16.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD0SPCTL0;

    /**
     * AD0SPCTL1
     * ===================================================================================================
     * Offset: 0x5C  A/D SAMPLE01 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:7]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |0000 = Disable hardware trigger.
     * |        |          |0001 = External pin (STADC) trigger.
     * |        |          |0010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |0011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |0100 = Timer0 overflow pulse trigger.
     * |        |          |0101 = Timer1 overflow pulse trigger.
     * |        |          |0110 = Timer2 overflow pulse trigger.
     * |        |          |0111 = Timer3 overflow pulse trigger.
     * |        |          |1000 = EPWM0_CH0 trigger.
     * |        |          |1001 = EPWM0_CH2 trigger.
     * |        |          |1010 = EPWM0_CH4 trigger.
     * |        |          |1011 = EPWM1_CH0 trigger.
     * |        |          |1100 = EPWM1_CH2 trigger.
     * |        |          |1101 = EPWM1_CH4 trigger.
     * |        |          |1110 = PWM0_CH0 trigger.
     * |        |          |1111 = PWM0_CH1 trigger.
     * |[8:15]  |TRGDLYCNT |A/D SAMPLE Start Of Conversion Trigger Delay Time
     * |        |          |Trigger delay time = (TRGDLYCNT + 4) x Trigger delay clock period.
     * |[16:17] |TRGDLYDIV |A/D SAMPLE Start Of Conversion Trigger Delay Clock Divider Selection
     * |        |          |Trigger delay clock frequency:
     * |        |          |00 = ADC_CLK/1.
     * |        |          |01 = ADC_CLK/2.
     * |        |          |10 = ADC_CLK/4.
     * |        |          |11 = ADC_CLK/16.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD0SPCTL1;

    /**
     * AD0SPCTL2
     * ===================================================================================================
     * Offset: 0x60  A/D SAMPLE02 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:7]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |0000 = Disable hardware trigger.
     * |        |          |0001 = External pin (STADC) trigger.
     * |        |          |0010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |0011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |0100 = Timer0 overflow pulse trigger.
     * |        |          |0101 = Timer1 overflow pulse trigger.
     * |        |          |0110 = Timer2 overflow pulse trigger.
     * |        |          |0111 = Timer3 overflow pulse trigger.
     * |        |          |1000 = EPWM0_CH0 trigger.
     * |        |          |1001 = EPWM0_CH2 trigger.
     * |        |          |1010 = EPWM0_CH4 trigger.
     * |        |          |1011 = EPWM1_CH0 trigger.
     * |        |          |1100 = EPWM1_CH2 trigger.
     * |        |          |1101 = EPWM1_CH4 trigger.
     * |        |          |1110 = PWM0_CH0 trigger.
     * |        |          |1111 = PWM0_CH1 trigger.
     * |[8:15]  |TRGDLYCNT |A/D SAMPLE Start Of Conversion Trigger Delay Time
     * |        |          |Trigger delay time = (TRGDLYCNT + 4) x Trigger delay clock period.
     * |[16:17] |TRGDLYDIV |A/D SAMPLE Start Of Conversion Trigger Delay Clock Divider Selection
     * |        |          |Trigger delay clock frequency:
     * |        |          |00 = ADC_CLK/1.
     * |        |          |01 = ADC_CLK/2.
     * |        |          |10 = ADC_CLK/4.
     * |        |          |11 = ADC_CLK/16.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD0SPCTL2;

    /**
     * AD0SPCTL3
     * ===================================================================================================
     * Offset: 0x64  A/D SAMPLE03 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:7]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |0000 = Disable hardware trigger.
     * |        |          |0001 = External pin (STADC) trigger.
     * |        |          |0010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |0011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |0100 = Timer0 overflow pulse trigger.
     * |        |          |0101 = Timer1 overflow pulse trigger.
     * |        |          |0110 = Timer2 overflow pulse trigger.
     * |        |          |0111 = Timer3 overflow pulse trigger.
     * |        |          |1000 = EPWM0_CH0 trigger.
     * |        |          |1001 = EPWM0_CH2 trigger.
     * |        |          |1010 = EPWM0_CH4 trigger.
     * |        |          |1011 = EPWM1_CH0 trigger.
     * |        |          |1100 = EPWM1_CH2 trigger.
     * |        |          |1101 = EPWM1_CH4 trigger.
     * |        |          |1110 = PWM0_CH0 trigger.
     * |        |          |1111 = PWM0_CH1 trigger.
     * |[8:15]  |TRGDLYCNT |A/D SAMPLE Start Of Conversion Trigger Delay Time
     * |        |          |Trigger delay time = (TRGDLYCNT + 4) x Trigger delay clock period.
     * |[16:17] |TRGDLYDIV |A/D SAMPLE Start Of Conversion Trigger Delay Clock Divider Selection
     * |        |          |Trigger delay clock frequency:
     * |        |          |00 = ADC_CLK/1.
     * |        |          |01 = ADC_CLK/2.
     * |        |          |10 = ADC_CLK/4.
     * |        |          |11 = ADC_CLK/16.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD0SPCTL3;

    /**
     * AD0SPCTL4
     * ===================================================================================================
     * Offset: 0x68  A/D SAMPLE04 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:6]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |000 = Disable hardware trigger.
     * |        |          |001 = External pin (STADC) trigger.
     * |        |          |010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |100 = Timer0 overflow pulse trigger.
     * |        |          |101 = Timer1 overflow pulse trigger.
     * |        |          |110 = Timer2 overflow pulse trigger.
     * |        |          |111 = Timer3 overflow pulse trigger.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD0SPCTL4;

    /**
     * AD0SPCTL5
     * ===================================================================================================
     * Offset: 0x6C  A/D SAMPLE05 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:6]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |000 = Disable hardware trigger.
     * |        |          |001 = External pin (STADC) trigger.
     * |        |          |010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |100 = Timer0 overflow pulse trigger.
     * |        |          |101 = Timer1 overflow pulse trigger.
     * |        |          |110 = Timer2 overflow pulse trigger.
     * |        |          |111 = Timer3 overflow pulse trigger.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD0SPCTL5;

    /**
     * AD0SPCTL6
     * ===================================================================================================
     * Offset: 0x70  A/D SAMPLE06 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:6]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |000 = Disable hardware trigger.
     * |        |          |001 = External pin (STADC) trigger.
     * |        |          |010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |100 = Timer0 overflow pulse trigger.
     * |        |          |101 = Timer1 overflow pulse trigger.
     * |        |          |110 = Timer2 overflow pulse trigger.
     * |        |          |111 = Timer3 overflow pulse trigger.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD0SPCTL6;

    /**
     * AD0SPCTL7
     * ===================================================================================================
     * Offset: 0x74  A/D SAMPLE07 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:6]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |000 = Disable hardware trigger.
     * |        |          |001 = External pin (STADC) trigger.
     * |        |          |010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |100 = Timer0 overflow pulse trigger.
     * |        |          |101 = Timer1 overflow pulse trigger.
     * |        |          |110 = Timer2 overflow pulse trigger.
     * |        |          |111 = Timer3 overflow pulse trigger.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD0SPCTL7;

    /**
     * AD1SPCTL0
     * ===================================================================================================
     * Offset: 0x78  A/D SAMPLE10 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:7]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |0000 = Disable hardware trigger.
     * |        |          |0001 = External pin (STADC) trigger.
     * |        |          |0010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |0011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |0100 = Timer0 overflow pulse trigger.
     * |        |          |0101 = Timer1 overflow pulse trigger.
     * |        |          |0110 = Timer2 overflow pulse trigger.
     * |        |          |0111 = Timer3 overflow pulse trigger.
     * |        |          |1000 = EPWM0_CH0 trigger.
     * |        |          |1001 = EPWM0_CH2 trigger.
     * |        |          |1010 = EPWM0_CH4 trigger.
     * |        |          |1011 = EPWM1_CH0 trigger.
     * |        |          |1100 = EPWM1_CH2 trigger.
     * |        |          |1101 = EPWM1_CH4 trigger.
     * |        |          |1110 = PWM0_CH0 trigger.
     * |        |          |1111 = PWM0_CH1 trigger.
     * |[8:15]  |TRGDLYCNT |A/D SAMPLE Start Of Conversion Trigger Delay Time
     * |        |          |Trigger delay time = (TRGDLYCNT + 4) x Trigger delay clock period.
     * |[16:17] |TRGDLYDIV |A/D SAMPLE Start Of Conversion Trigger Delay Clock Divider Selection
     * |        |          |Trigger delay clock frequency:
     * |        |          |00 = ADC_CLK/1.
     * |        |          |01 = ADC_CLK/2.
     * |        |          |10 = ADC_CLK/4.
     * |        |          |11 = ADC_CLK/16.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD1SPCTL0;

    /**
     * AD1SPCTL1
     * ===================================================================================================
     * Offset: 0x7C  A/D SAMPLE11 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:7]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |0000 = Disable hardware trigger.
     * |        |          |0001 = External pin (STADC) trigger.
     * |        |          |0010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |0011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |0100 = Timer0 overflow pulse trigger.
     * |        |          |0101 = Timer1 overflow pulse trigger.
     * |        |          |0110 = Timer2 overflow pulse trigger.
     * |        |          |0111 = Timer3 overflow pulse trigger.
     * |        |          |1000 = EPWM0_CH0 trigger.
     * |        |          |1001 = EPWM0_CH2 trigger.
     * |        |          |1010 = EPWM0_CH4 trigger.
     * |        |          |1011 = EPWM1_CH0 trigger.
     * |        |          |1100 = EPWM1_CH2 trigger.
     * |        |          |1101 = EPWM1_CH4 trigger.
     * |        |          |1110 = PWM0_CH0 trigger.
     * |        |          |1111 = PWM0_CH1 trigger.
     * |[8:15]  |TRGDLYCNT |A/D SAMPLE Start Of Conversion Trigger Delay Time
     * |        |          |Trigger delay time = (TRGDLYCNT + 4) x Trigger delay clock period.
     * |[16:17] |TRGDLYDIV |A/D SAMPLE Start Of Conversion Trigger Delay Clock Divider Selection
     * |        |          |Trigger delay clock frequency:
     * |        |          |00 = ADC_CLK/1.
     * |        |          |01 = ADC_CLK/2.
     * |        |          |10 = ADC_CLK/4.
     * |        |          |11 = ADC_CLK/16.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD1SPCTL1;

    /**
     * AD1SPCTL2
     * ===================================================================================================
     * Offset: 0x80  A/D SAMPLE12 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:7]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |0000 = Disable hardware trigger.
     * |        |          |0001 = External pin (STADC) trigger.
     * |        |          |0010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |0011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |0100 = Timer0 overflow pulse trigger.
     * |        |          |0101 = Timer1 overflow pulse trigger.
     * |        |          |0110 = Timer2 overflow pulse trigger.
     * |        |          |0111 = Timer3 overflow pulse trigger.
     * |        |          |1000 = EPWM0_CH0 trigger.
     * |        |          |1001 = EPWM0_CH2 trigger.
     * |        |          |1010 = EPWM0_CH4 trigger.
     * |        |          |1011 = EPWM1_CH0 trigger.
     * |        |          |1100 = EPWM1_CH2 trigger.
     * |        |          |1101 = EPWM1_CH4 trigger.
     * |        |          |1110 = PWM0_CH0 trigger.
     * |        |          |1111 = PWM0_CH1 trigger.
     * |[8:15]  |TRGDLYCNT |A/D SAMPLE Start Of Conversion Trigger Delay Time
     * |        |          |Trigger delay time = (TRGDLYCNT + 4) x Trigger delay clock period.
     * |[16:17] |TRGDLYDIV |A/D SAMPLE Start Of Conversion Trigger Delay Clock Divider Selection
     * |        |          |Trigger delay clock frequency:
     * |        |          |00 = ADC_CLK/1.
     * |        |          |01 = ADC_CLK/2.
     * |        |          |10 = ADC_CLK/4.
     * |        |          |11 = ADC_CLK/16.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD1SPCTL2;

    /**
     * AD1SPCTL3
     * ===================================================================================================
     * Offset: 0x84  A/D SAMPLE13 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:7]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |0000 = Disable hardware trigger.
     * |        |          |0001 = External pin (STADC) trigger.
     * |        |          |0010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |0011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |0100 = Timer0 overflow pulse trigger.
     * |        |          |0101 = Timer1 overflow pulse trigger.
     * |        |          |0110 = Timer2 overflow pulse trigger.
     * |        |          |0111 = Timer3 overflow pulse trigger.
     * |        |          |1000 = EPWM0_CH0 trigger.
     * |        |          |1001 = EPWM0_CH2 trigger.
     * |        |          |1010 = EPWM0_CH4 trigger.
     * |        |          |1011 = EPWM1_CH0 trigger.
     * |        |          |1100 = EPWM1_CH2 trigger.
     * |        |          |1101 = EPWM1_CH4 trigger.
     * |        |          |1110 = PWM0_CH0 trigger.
     * |        |          |1111 = PWM0_CH1 trigger.
     * |[8:15]  |TRGDLYCNT |A/D SAMPLE Start Of Conversion Trigger Delay Time
     * |        |          |Trigger delay time = (TRGDLYCNT + 4) x Trigger delay clock period.
     * |[16:17] |TRGDLYDIV |A/D SAMPLE Start Of Conversion Trigger Delay Clock Divider Selection
     * |        |          |Trigger delay clock frequency:
     * |        |          |00 = ADC_CLK/1.
     * |        |          |01 = ADC_CLK/2.
     * |        |          |10 = ADC_CLK/4.
     * |        |          |11 = ADC_CLK/16.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD1SPCTL3;

    /**
     * AD1SPCTL4
     * ===================================================================================================
     * Offset: 0x88  A/D SAMPLE14 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:6]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |000 = Disable hardware trigger.
     * |        |          |001 = External pin (STADC) trigger.
     * |        |          |010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |100 = Timer0 overflow pulse trigger.
     * |        |          |101 = Timer1 overflow pulse trigger.
     * |        |          |110 = Timer2 overflow pulse trigger.
     * |        |          |111 = Timer3 overflow pulse trigger.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD1SPCTL4;

    /**
     * AD1SPCTL5
     * ===================================================================================================
     * Offset: 0x8C  A/D SAMPLE15 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:6]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |000 = Disable hardware trigger.
     * |        |          |001 = External pin (STADC) trigger.
     * |        |          |010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |100 = Timer0 overflow pulse trigger.
     * |        |          |101 = Timer1 overflow pulse trigger.
     * |        |          |110 = Timer2 overflow pulse trigger.
     * |        |          |111 = Timer3 overflow pulse trigger.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD1SPCTL5;

    /**
     * AD1SPCTL6
     * ===================================================================================================
     * Offset: 0x90  A/D SAMPLE16 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:6]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |000 = Disable hardware trigger.
     * |        |          |001 = External pin (STADC) trigger.
     * |        |          |010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |100 = Timer0 overflow pulse trigger.
     * |        |          |101 = Timer1 overflow pulse trigger.
     * |        |          |110 = Timer2 overflow pulse trigger.
     * |        |          |111 = Timer3 overflow pulse trigger.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD1SPCTL6;

    /**
     * AD1SPCTL7
     * ===================================================================================================
     * Offset: 0x94  A/D SAMPLE17 Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:3]   |CHSEL     |A/D SAMPLE0,1 Channel Selection
     * |        |          |0000 = ADCn_CH0.
     * |        |          |0001 = ADCn_CH1.
     * |        |          |0010 = ADCn_CH2.
     * |        |          |0011 = ADCn_CH3.
     * |        |          |0100 = ADCn_CH4.
     * |        |          |0101 = ADCn_CH5.
     * |        |          |0110 = ADCn_CH6.
     * |        |          |0111 = ADCn_CH7.
     * |        |          |For SAMPLE0
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OP0.
     * |        |          |For SAMPLE1
     * |        |          |1000= OP1.
     * |[4:6]   |TRGSEL    |A/D SAMPLE Start Of Conversion Trigger Source Selection
     * |        |          |000 = Disable hardware trigger.
     * |        |          |001 = External pin (STADC) trigger.
     * |        |          |010 = ADC ADINT0 interrupt EOC pulse trigger.
     * |        |          |011 = ADC ADINT1 interrupt EOC pulse trigger.
     * |        |          |100 = Timer0 overflow pulse trigger.
     * |        |          |101 = Timer1 overflow pulse trigger.
     * |        |          |110 = Timer2 overflow pulse trigger.
     * |        |          |111 = Timer3 overflow pulse trigger.
     * |[20]    |EXTREN    |A/D External Pin Rising Edge Trigger Enable Control
     * |        |          |0 = A/D external pin rising edge trigger Disabled.
     * |        |          |1 = A/D external pin rising edge trigger Enabled.
     * |[21]    |EXTFEN    |A/D External Pin Falling Edge Trigger Enable Control
     * |        |          |0 = A/D external pin falling edge trigger Disabled.
     * |        |          |1 = A/D external pin falling edge trigger Enabled.
    */
    __IO uint32_t AD1SPCTL7;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE1[3];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * SIMUSEL
     * ===================================================================================================
     * Offset: 0xA4  A/D SAMPLE Simultaneous Sampling Mode Select Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |SIMUSEL0  |A/D SAMPLE00, SAMPLE10 Simultaneous Sampling Mode Selection
     * |        |          |0 = SAMPLE00, SAMPLE10 are in single sampling mode, both SAMPLE00 and SAMPLE10's 3 bits of CHSEL define the ADC channels to be converted.
     * |        |          |1 = SAMPLE00, SAMPLE10 are in simultaneous sampling mode, Only SAMPLE00 can trigger the both ADC conversions of SAMPLE00 and SAMPLE10, SAMPLE10 trigger select TRGSEL is ignored.
     * |        |          |If SAMPLE00's CHSEL = 1, and SAMPLE10's CHSEL = 3, the pair of channels are ADC0_CH1, ADC1_CH3, they will do the ADC conversion at the same time to reach the simulataneous sampling goal.
     * |[1]     |SIMUSEL1  |A/D SAMPLE01, SAMPLE11 Simultaneous Sampling Mode Selection
     * |        |          |0 = SAMPLE01, SAMPLE11 are in single sampling mode, both SAMPLE01 and SAMPLE11's 3 bits of CHSEL define the ADC channels to be converted.
     * |        |          |1 = SAMPLE01, SAMPLE11 are in simultaneous sampling mode, Only SAMPLE01 can trigger the both ADC conversions of SAMPLE01 and SAMPLE11, SAMPLE11 trigger select TRGSEL is ignored.
     * |        |          |If SAMPLE01's CHSEL = 1, and SAMPLE11's CHSEL = 3, the pair of channels are ADC0_CH1, ADC1_CH3, they will do the ADC conversion at the same time to reach the simulataneous sampling goal.
     * |[2]     |SIMUSEL2  |A/D SAMPLE02, SAMPLE12 Simultaneous Sampling Mode Selection
     * |        |          |0 = SAMPLE02, SAMPLE12 are in single sampling mode, both SAMPLE02 and SAMPLE12's 3 bits of CHSEL define the ADC channels to be converted.
     * |        |          |1 = SAMPLE02, SAMPLE12 are in simultaneous sampling mode, Only SAMPLE02 can trigger the both ADC conversions of SAMPLE02 and SAMPLE12, SAMPLE12 trigger select TRGSEL is ignored.
     * |        |          |If SAMPLE02's CHSEL = 1, and SAMPLE12's CHSEL = 3, the pair of channels are ADC0_CH1, ADC1_CH3, they will do the ADC conversion at the same time to reach the simulataneous sampling goal.
     * |[3]     |SIMUSEL3  |A/D SAMPLE03, SAMPLE13 Simultaneous Sampling Mode Selection
     * |        |          |0 = SAMPLE03, SAMPLE13 are in single sampling mode, both SAMPLE03 and SAMPLE13's 3 bits of CHSEL define the ADC channels to be converted.
     * |        |          |1 = SAMPLE03, SAMPLE13 are in simultaneous sampling mode, Only SAMPLE03 can trigger the both ADC conversions of SAMPLE03 and SAMPLE13, SAMPLE13 trigger select TRGSEL is ignored.
     * |        |          |If SAMPLE03's CHSEL = 1, and SAMPLE13's CHSEL = 3, the pair of channels are ADC0_CH1, ADC1_CH3, they will do the ADC conversion at the same time to reach the simulataneous sampling goal.
     * |[4]     |SIMUSEL4  |A/D SAMPLE04, SAMPLE14 Simultaneous Sampling Mode Selection
     * |        |          |0 = SAMPLE04, SAMPLE14 are in single sampling mode, both SAMPLE04 and SAMPLE14's 3 bits of CHSEL define the ADC channels to be converted.
     * |        |          |1 = SAMPLE04, SAMPLE14 are in simultaneous sampling mode, Only SAMPLE04 can trigger the both ADC conversions of SAMPLE04 and SAMPLE14, SAMPLE14 trigger select TRGSEL is ignored.
     * |        |          |If SAMPLE04's CHSEL = 1, and SAMPLE14's CHSEL = 3, the pair of channels are ADC0_CH1, ADC1_CH3, they will do the ADC conversion at the same time to reach the simulataneous sampling goal.
     * |[5]     |SIMUSEL5  |A/D SAMPLE05, SAMPLE15 Simultaneous Sampling Mode Selection
     * |        |          |0 = SAMPLE05, SAMPLE15 are in single sampling mode, both SAMPLE05 and SAMPLE15's 3 bits of CHSEL define the ADC channels to be converted.
     * |        |          |1 = SAMPLE05, SAMPLE15 are in simultaneous sampling mode, Only SAMPLE05 can trigger the both ADC conversions of SAMPLE05 and SAMPLE15, SAMPLE15 trigger select TRGSEL is ignored.
     * |        |          |if SAMPLE05's CHSEL = 1, and SAMPLE15's CHSEL = 3, the pair of channels are ADC0_CH1, ADC1_CH3, they will do the ADC conversion at the same time to reach the simulataneous sampling goal.
     * |[6]     |SIMUSEL6  |A/D SAMPLE06, SAMPLE16 Simultaneous Sampling Mode Selection
     * |        |          |0 = SAMPLE06, SAMPLE16 are in single sampling mode, both SAMPLE06 and SAMPLE16's 3 bits of CHSEL define the ADC channels to be converted.
     * |        |          |1 = SAMPLE06, SAMPLE16 are in simultaneous sampling mode, Only SAMPLE06 can trigger the both ADC conversions of SAMPLE06 and SAMPLE16, SAMPLE16 trigger select TRGSEL is ignored.
     * |        |          |If SAMPLE06's CHSEL = 1, and SAMPLE16's CHSEL = 3, the pair of channels are ADC0_CH1, ADC1_CH3, they will do the ADC conversion at the same time to reach the simulataneous sampling goal.
     * |[7]     |SIMUSEL7  |A/D SAMPLE07, SAMPLE17 Simultaneous Sampling Mode Selection
     * |        |          |0 = SAMPLE07, SAMPLE17 are in single sampling mode, both SAMPLE07 and SAMPLE17's 3 bits of CHSEL define the ADC channels to be converted.
     * |        |          |1 = SAMPLE07, SAMPLE17 are in simultaneous sampling mode, Only SAMPLE07 can trigger the both ADC conversions of SAMPLE07 and SAMPLE17, SAMPLE17 trigger select TRGSEL is ignored.
     * |        |          |If SAMPLE07's CHSEL = 1, SAMPLE17's CHSEL = 3, the pair of channels are ADC0_CH1, ADC1_CH3, they will do the ADC conversion at the same time to reach the simulataneous sampling goal.
    */
    __IO uint32_t SIMUSEL;

    /**
     * CMP0/1
     * ===================================================================================================
     * Offset: 0xA8  A/D Result Compare Register 0
     * Offset: 0xAC  A/D Result Compare Register 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |ADCMPEN   |A/D Result Compare Enable Control
     * |        |          |0 = Compare Disabled.
     * |        |          |1 = Compare Enabled.
     * |        |          |Set this bit to 1 to enable compare CMPDAT (EADC_CMPx[27:16]) with specified SAMPLE conversion result when converted data is loaded into ADDR register.
     * |[1]     |ADCMPIE   |A/D Result Compare Interrupt Enable Control
     * |        |          |0 = Compare function interrupt Disabled.
     * |        |          |1 = Compare function interrupt Enabled.
     * |        |          |If the compare function is enabled and the compare condition matches the setting of CMPCOND (EADC_CMPx[2]) and CMPMCNT (EADC_CMPx[11:8]), ADCMPF (EADC_STATUS1 [7:6]) bit will be asserted, in the meanwhile, if ADCMPIE (EADC_CMPx[1]) is set to 1, a compare interrupt request is generated.
     * |[2]     |CMPCOND   |Compare Condition
     * |        |          |0= Set the compare condition as that when a 12-bit A/D conversion result is less than the 12-bit CMPDAT (EADC_CMPx[27:16]), the internal match counter will increase one.
     * |        |          |1= Set the compare condition as that when a 12-bit A/D conversion result is greater or equal to the 12-bit CMPDAT (EADC_CMPx[27:16]), the internal match counter will increase one.
     * |        |          |Note: When the internal counter reaches the value to CMPMCNT (EADC_CMPx[11:8]) + 1, the CMPF bit will be set.
     * |[3:5]   |CMPSPL    |Compare SAMPLE Selection
     * |        |          |000 = SAMPLE00 conversion result EADC_AD0DAT0 is selected to be compared.
     * |        |          |001 = SAMPLE01 conversion result EADC_AD0DAT1 is selected to be compared.
     * |        |          |010 = SAMPLE02 conversion result EADC_AD0DAT2 is selected to be compared.
     * |        |          |011 = SAMPLE03 conversion result EADC_AD0DAT3 is selected to be compared.
     * |        |          |100 = SAMPLE10 conversion result EADC_AD1DAT0 is selected to be compared.
     * |        |          |101 = SAMPLE11 conversion result EADC_AD1DAT1 is selected to be compared.
     * |        |          |110 = SAMPLE12 conversion result EADC_AD1DAT2 is selected to be compared.
     * |        |          |111 = SAMPLE13 conversion result EADC_AD1DAT3 is selected to be compared.
     * |[8:11]  |CMPMCNT   |Compare Match Count
     * |        |          |When the specified A/D SAMPLE analog conversion result matches the compare condition defined by CMPCOND (EADC_CMPx[2]), the internal match counter will increase 1.
     * |        |          |When the internal counter reaches the value to CMPMCNT (EADC_CMPx[11:8] + 1, the ADCMPF (EADC_STATUS1 [7:6]) bit will be set.
     * |[16:27] |CMPDAT    |Compared Data
     * |        |          |The 12 bits data is used to compare with conversion result of specified SAMPLE.
     * |        |          |Software can use it to monitor the external analog input pin voltage transition without imposing a load on software.
    */
    __IO uint32_t CMP[2];

    /**
     * STATUS0
     * ===================================================================================================
     * Offset: 0xB0  A/D Status Register 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |VALID7_0  |ADDR07~ ADDR00 Data Valid Flag (Read Only)
     * |        |          |It is a mirror of VALID bit in SAMPLE0 A/D result data register EADC_AD0DAT0x.
     * |        |          |Note: x = 0~7.
     * |[8:15]  |VALID15_8 |ADDR17~ ADDR10 Data Valid Flag (Read Only)
     * |        |          |It is a mirror of VALID bit in SAMPLE1 A/D result data register EADC_AD0DAT1x.
     * |        |          |Note: x = 0~7.
     * |[16:23] |OV7_0     |ADDR07~ ADDR00 Overrun Flag (Read Only)
     * |        |          |It is a mirror to OV bit in SAMPLE0 A/D result data register EADC_AD0DAT0x.
     * |        |          |Note: x = 0~7.
     * |[24:31] |OV15_8    |ADDR17~ADDR10 Overrun Flag (Read Only)
     * |        |          |It is a mirror to OV bit in SAMPLE1 A/D result data register EADC_AD0DAT1x.
     * |        |          |Note: x = 0~7.
    */
    __I  uint32_t STATUS0;

    /**
     * STATUS1
     * ===================================================================================================
     * Offset: 0xB4  A/D Status Register 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |ADIF0     |A/D ADINT0 Interrupt Flag
     * |        |          |0 = No ADINT0 interrupt pulse received.
     * |        |          |1 = ADINT0 interrupt pulse has been received.
     * |        |          |Note1: This bit is cleared by writing 1 to it.
     * |        |          |Note2:This bit indicates whether an A/D conversion of specific SAMPLE has been completed
     * |[1]     |ADIF1     |A/D ADINT1 Interrupt Flag
     * |        |          |0 = No ADINT1 interrupt pulse received.
     * |        |          |1 = ADINT1 interrupt pulse has been received.
     * |        |          |Note1: This bit is cleared by writing 1 to it.
     * |        |          |Note2:This bit indicates whether an A/D conversion of specific SAMPLE has been completed
     * |[2]     |ADIF2     |A/D ADINT2 Interrupt Flag
     * |        |          |0 = no ADINT2 interrupt pulse received.
     * |        |          |1 = ADINT2 interrupt pulse has been received.
     * |        |          |Note1: This bit is cleared by writing 1 to it.
     * |        |          |Note2:This bit indicates whether an A/D conversion of specific SAMPLE has been completed
     * |[3]     |ADIF3     |A/D ADINT3 Interrupt Flag
     * |        |          |0 = No ADINT3 interrupt pulse received.
     * |        |          |1 = ADINT3 interrupt pulse has been received.
     * |        |          |Note1: This bit is cleared by writing 1 to it.
     * |        |          |Note2:This bit indicates whether an A/D conversion of specific SAMPLE has been completed
     * |[4]     |ADCMPO0   |ADC Compare 0 Output Status
     * |        |          |The 12 bits compare0 data CMPDAT EADC_CMP0 [27:16]) is used to compare with conversion result of specified SAMPLE.
     * |        |          |Software can use it to monitor the external analog input pin voltage status.
     * |        |          |0 = Conversion result in ADDR less than CMPDAT (EADC_CMP0 [27:16]) setting.
     * |        |          |1 = Conversion result in ADDR great than or equal CMPDAT (EADC_CMP0 [27:16]) setting.
     * |[5]     |ADCMPO1   |ADC Compare 1 Output Status
     * |        |          |The 12 bits compare1 data CMPDAT (EADC_CMP1 [27:16]) is used to compare with conversion result of specified SAMPLE.
     * |        |          |Software can use it to monitor the external analog input pin voltage status.
     * |        |          |0 = Conversion result in ADDR less than CMPDAT EADC_CMP1 [27:16]) setting.
     * |        |          |1 = Conversion result in ADDR great than or equal CMPDAT (EADC_CMP1 [27:16]) setting.
     * |[6]     |ADCMPF0   |ADC Compare 0 Flag
     * |        |          |When the specific SAMPLE A/D conversion result meets setting condition in EADC_CMP0 then this bit is set to 1.
     * |        |          |0 = Conversion result in ADDR does not meet EADC_CMP0 setting.
     * |        |          |1 = Conversion result in ADDR meets EADC_CMP0 setting.
     * |        |          |Note: This bit is cleared by writing 1 to it.
     * |[7]     |ADCMPF1   |ADC Compare 1 Flag
     * |        |          |When the specific SAMPLE A/D conversion result meets setting condition in EADC_CMP1 then this bit is set to 1.
     * |        |          |0 = Conversion result in ADDR does not meet EADC_CMP1 setting.
     * |        |          |1 = Conversion result in ADDR meets EADC_CMP1 setting.
     * |        |          |Note: This bit is cleared by writing 1 to it.
     * |[8]     |BUSY0     |Busy/Idle (Read Only)
     * |        |          |0 = A/D converter 0 (ADC0) is in idle state.
     * |        |          |1 = A/D converter 0 (ADC0) is doing conversion.
     * |[12:15] |CHANNEL0  |Current Conversion Channel (Read Only)
     * |        |          |This filed reflects ADC0 current conversion channel when BUSY0 (EADC_STATUS1 [8]) = 1.
     * |        |          |When BUSY0 (EADC_STATUS1 [8]) = 0, it shows the last converted channel.
     * |        |          |0000 = ADC0_CH0.
     * |        |          |0001 = ADC0_CH1.
     * |        |          |0010 = ADC0_CH2.
     * |        |          |0011 = ADC0_CH3.
     * |        |          |0100 = ADC0_CH4.
     * |        |          |0100 = ADC0_CH5.
     * |        |          |0110 = ADC0_CH6.
     * |        |          |0111 = ADC0_CH7.
     * |        |          |1000 = VBG.
     * |        |          |1001 = VTEMP.
     * |        |          |1010 = AVSS.
     * |        |          |1011 = OPA0_O.
     * |        |          |Other = reserved.
     * |[16]    |BUSY1     |Busy/Idle
     * |        |          |0 = A/D converter 1 (ADC1) is in idle state.
     * |        |          |1 = A/D converter 1 (ADC1) is doing conversion.
     * |[20:23] |CHANNEL1  |Current Conversion Channel (Read Only)
     * |        |          |This filed reflects ADC1 current conversion channel when BUSY1 (EADC_STATUS1 [16]) = 1.
     * |        |          |When BUSY1 (EADC_STATUS1 [16]) = 0, it shows the last converted channel.
     * |        |          |0000 = ADC1_CH0.
     * |        |          |0001 = ADC1_CH1.
     * |        |          |0010 = ADC1_CH2.
     * |        |          |0011 = ADC1_CH3.
     * |        |          |0100 = ADC1_CH4.
     * |        |          |0101 = ADC1_CH5.
     * |        |          |0110 = ADC1_CH6.
     * |        |          |0111 = ADC1_CH7.
     * |        |          |1000 = OPA1_O.
     * |        |          |Other = reversed.
     * |[24]    |ADOVIF    |All A/D Interrupt Flag Overrun Bits Check
     * |        |          |0 = None of ADINT interrupt flag ADFOVx (ADIFOVR [15:0]) is overwritten to 1.
     * |        |          |1 = Any one of ADINT interrupt flag ADFOVx (ADIFOVR [15:0]) is overwritten to 1.
     * |        |          |Note: This bit will keep 1 when any ADFOVx (ADIFOVR [15:0]) Flag is equal to 1.
     * |[25]    |STOVF     |For All A/D SAMPLE Start Of Conversion Overrun Flags Check
     * |        |          |0 = None of SAMPLE event overrun flag SPOVFx (ADSPOVFR [15:0]) is set to 1.
     * |        |          |1 = Any one of SAMPLE event overrun flag SPOVFx (ADSPOVFR [15:0]) is set to 1.
     * |        |          |Note: This bit will keep 1 when any SPOVFx (ADSPOVFR [15:0]) Flag is equal to 1.
     * |[26]    |AVALID    |For All SAMPLE A/D Result Data Register ADDR Data Valid Flag Check
     * |        |          |0 = None of SAMPLE data register valid flag VALIDx (EADC_ADnDATx[17]) is set to 1.
     * |        |          |1 = Any one of SAMPLE data register valid flag VALIDx (EADC_ADnDATx[17]) is set to 1.
     * |        |          |Note: This bit will keep 1 when any VALIDx (EADC_ADnDATx[17]) Flag is equal to 1.
     * |[27]    |AOV       |For All SAMPLE A/D Result Data Register Overrun Flags Check
     * |        |          |0 = None of SAMPLE data register overrun flag OVx (EADC_ADnDATx[16]) is set to 1.
     * |        |          |1 = Any one of SAMPLE data register overrun flag OVx (EADC_ADnDATx[16]) is set to 1.
     * |        |          |Note: This bit will keep 1 when any OVx (EADC_ADnDATx[16]) Flag is equal to 1.
    */
    __IO uint32_t STATUS1;

    /**
     * EXTSMPT
     * ===================================================================================================
     * Offset: 0xB8  A/D Timing Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |EXTSMPT0  |ADC0 Extend Sampling Time
     * |        |          |When A/D converting at high conversion rate, the sampling time of analog input voltage may not enough if input channel loading is heavy, SW can extend A/D sampling time after trigger source is coming to get enough sampling time.
     * |        |          |The range of start delay time is from 0~255 ADC clock.
     * |[16:23] |EXTSMPT1  |ADC1 Extend Sampling Time
     * |        |          |When A/D converting at high conversion rate, the sampling time of analog input voltage may not enough if input channel loading is heavy, SW can extend A/D sampling time after trigger source is coming to get enough sampling time.
     * |        |          |The range of start delay time is from 0~255 ADC clock.
    */
    __IO uint32_t EXTSMPT;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE2[17];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * AD0DDAT0
     * ===================================================================================================
     * Offset: 0x100  A/D double Data Register 0 for SAMPLE00
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |VALID     |Valid Flag
     * |        |          |0 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is not valid.
     * |        |          |1 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD0DDAT0;

    /**
     * AD0DDAT1
     * ===================================================================================================
     * Offset: 0x104  A/D double Data Register 1 for SAMPLE01
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |VALID     |Valid Flag
     * |        |          |0 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is not valid.
     * |        |          |1 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD0DDAT1;

    /**
     * AD0DDAT2
     * ===================================================================================================
     * Offset: 0x108  A/D double Data Register 2 for SAMPLE02
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |VALID     |Valid Flag
     * |        |          |0 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is not valid.
     * |        |          |1 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD0DDAT2;

    /**
     * AD0DDAT3
     * ===================================================================================================
     * Offset: 0x10C  A/D double Data Register 3 for SAMPLE03
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |VALID     |Valid Flag
     * |        |          |0 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is not valid.
     * |        |          |1 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD0DDAT3;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE3[4];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * AD1DDAT0
     * ===================================================================================================
     * Offset: 0x120  A/D double Data Register 0 for SAMPLE10
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |VALID     |Valid Flag
     * |        |          |0 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is not valid.
     * |        |          |1 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD1DDAT0;

    /**
     * AD1DDAT1
     * ===================================================================================================
     * Offset: 0x124  A/D double Data Register 1 for SAMPLE11
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |VALID     |Valid Flag
     * |        |          |0 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is not valid.
     * |        |          |1 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD1DDAT1;

    /**
     * AD1DDAT2
     * ===================================================================================================
     * Offset: 0x128  A/D double Data Register 2 for SAMPLE12
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |VALID     |Valid Flag
     * |        |          |0 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is not valid.
     * |        |          |1 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD1DDAT2;

    /**
     * AD1DDAT3
     * ===================================================================================================
     * Offset: 0x12C  A/D double Data Register 3 for SAMPLE13
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:11]  |RESULT    |A/D Conversion Result
     * |        |          |This field contains 12 bits conversion result.
     * |[16]    |VALID     |Valid Flag
     * |        |          |0 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is not valid.
     * |        |          |1 = Double buffer data in RESULT (EADC_ADnDATx[11:0]) bits is valid.
     * |        |          |This bit is set to 1 when corresponding SAMPLE channel analog input conversion is completed and cleared by hardware after EADC_ADnDATx register is read.
    */
    __I  uint32_t AD1DDAT3;

    /**
     * DBMEN
     * ===================================================================================================
     * Offset: 0x130  A/D Double Buffer Mode select
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |AD0DBM0   |Double Buffer Mode For SAMPLE00
     * |        |          |0 = SAMPLE00 has one sample result register. (default).
     * |        |          |1 =SAMPLE00 has two sample result registers.
     * |[1]     |AD0DBM1   |Double Buffer Mode For SAMPLE01
     * |        |          |0 = SAMPLE01 has one sample result register. (default).
     * |        |          |1 = SAMPLE01 has two sample result registers.
     * |[2]     |AD0DBM2   |Double Buffer Mode For SAMPLE02
     * |        |          |0 = SAMPLE02 has one sample result register. (default).
     * |        |          |1 =SAMPLE02 has two sample result registers.
     * |[3]     |AD0DBM3   |Double Buffer Mode For SAMPLE03
     * |        |          |0 = SAMPLE03 has one sample result register. (default).
     * |        |          |1 =SAMPLE03 has two sample result registers.
     * |[8]     |AD1DBM0   |Double Buffer Mode For SAMPLE10
     * |        |          |0 = SAMPLE10 has one sample result register. (default)
     * |        |          |1 =SAMPLE10 has two sample result registers.
     * |[9]     |AD1DBM1   |Double Buffer Mode For SAMPLE11
     * |        |          |0 = SAMPLE11 has one sample result register. (default).
     * |        |          |1 =SAMPLE11 has two sample result registers.
     * |[10]    |AD1DBM2   |Double Buffer Mode For SAMPLE12
     * |        |          |0 = SAMPLE12 has one sample result register. (default).
     * |        |          |1 =SAMPLE12 has two sample result registers.
     * |[11]    |AD1DBM3   |Double Buffer Mode For SAMPLE13
     * |        |          |0 = SAMPLE13 has one sample result register. (default)
     * |        |          |1 =SAMPLE13 has two sample result registers.
    */
    __IO uint32_t DBMEN;

    /**
     * INTSRC0
     * ===================================================================================================
     * Offset: 0x134  A/D Interrupt 0 Source Enable Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |AD0SPIE0  |SAMPLE00 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE00 interrupt mask Disabled.
     * |        |          |1 = SAMPLE00 interrupt mask Enabled.
     * |[1]     |AD0SPIE1  |SAMPLE01 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE01 interrupt mask Disabled.
     * |        |          |1 = SAMPLE01 interrupt mask Enabled.
     * |[2]     |AD0SPIE2  |SAMPLE02 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE02 interrupt mask Disabled.
     * |        |          |1 = SAMPLE02 interrupt mask Enabled.
     * |[3]     |AD0SPIE3  |SAMPLE03 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE03 interrupt mask Disabled.
     * |        |          |1 = SAMPLE03 interrupt mask Enabled.
     * |[4]     |AD0SPIE4  |SAMPLE04 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE04 interrupt mask Disabled.
     * |        |          |1 = SAMPLE04 interrupt mask Enabled.
     * |[5]     |AD0SPIE5  |SAMPLE05 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE05 interrupt mask Disabled.
     * |        |          |1 = SAMPLE05 interrupt mask Enabled.
     * |[6]     |AD0SPIE6  |SAMPLE06 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE06 interrupt mask Disabled.
     * |        |          |1 = SAMPLE06 interrupt mask Enabled.
     * |[7]     |AD0SPIE7  |SAMPLE07 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE07 interrupt mask Disabled.
     * |        |          |1 = SAMPLE07 interrupt mask Enabled.
     * |[8]     |AD1SPIE0  |SAMPLE10 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE10 interrupt mask Disabled.
     * |        |          |1 = SAMPLE10 interrupt mask Enabled.
     * |[9]     |AD1SPIE1  |SAMPLE11 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE11 interrupt mask Disabled.
     * |        |          |1 = SAMPLE11 interrupt mask Enabled.
     * |[10]    |AD1SPIE2  |SAMPLE12 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE12 interrupt mask Disabled.
     * |        |          |1 = SAMPLE12 interrupt mask Enabled.
     * |[11]    |AD1SPIE3  |SAMPLE13 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE13 interrupt mask Disabled.
     * |        |          |1 = SAMPLE13 interrupt mask Enabled.
     * |[12]    |AD1SPIE4  |SAMPLE14 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE14 interrupt mask Disabled.
     * |        |          |1 = SAMPLE14 interrupt mask Enabled.
     * |[13]    |AD1SPIE5  |SAMPLE15 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE15 interrupt mask Disabled.
     * |        |          |1 = SAMPLE15 interrupt mask Enabled.
     * |[14]    |AD1SPIE6  |SAMPLE16 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE16 interrupt mask Disabled.
     * |        |          |1 = SAMPLE16 interrupt mask Enabled.
     * |[15]    |AD1SPIE7  |SAMPLE17 Interrupt Mask Enable Control
     * |        |          |0 = SAMPLE17 interrupt mask Disabled.
     * |        |          |1 = SAMPLE17 interrupt mask Enabled.
    */
    __IO uint32_t INTSRC[4];

    /**
     * AD0TRGEN0
     * ===================================================================================================
     * Offset: 0x144  A/D trigger condition for SAMPLE00
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |EPWM00REN |EPWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[1]     |EPWM00FEN |EPWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[2]     |EPWM00PEN |EPWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[3]     |EPWM00CEN |EPWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[4]     |EPWM02REN |EPWM0_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[5]     |EPWM02FEN |EPWM0_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[6]     |EPWM02PEN |EPWM0_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[7]     |EPWM02CEN |EPWM0_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[8]     |EPWM04REN |EPWM0_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[9]     |EPWM04FEN |EPWM0_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[10]    |EPWM04PEN |EPWM0_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[11]    |EPWM04CEN |EPWM0_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[12]    |EPWM10REN |EPWM1_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[13]    |EPWM10FEN |EPWM1_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[14]    |EPWM10PEN |EPWM1_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[15]    |EPWM10CEN |EPWM1_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[16]    |EPWM12REN |EPWM1_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[17]    |EPWM120FEN|EPWM1_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[18]    |EPWM12PEN |EPWM1_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[19]    |EPWM12CEN |EPWM1_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[20]    |EPWM14REN |EPWM1_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[21]    |EPWM14FEN |EPWM1_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[22]    |EPWM14PEN |EPWM1_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[23]    |EPWM14CEN |EPWM1_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[24]    |PWM00REN  |PWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[25]    |PWM00FEN  |PWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[26]    |PWM00PEN  |PWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[27]    |PWM00CEN  |PWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[28]    |PWM01REN  |PWM0_CH1 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[29]    |PWM01FEN  |PWM0_CH1 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[30]    |PWM01PEN  |PWM0_CH1 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[31]    |PWM01CEN  |PWM0_CH1 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
    */
    __IO uint32_t AD0TRGEN0;

    /**
     * AD0TRGEN1
     * ===================================================================================================
     * Offset: 0x148  A/D trigger condition for SAMPLE01
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |EPWM00REN |EPWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[1]     |EPWM00FEN |EPWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[2]     |EPWM00PEN |EPWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[3]     |EPWM00CEN |EPWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[4]     |EPWM02REN |EPWM0_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[5]     |EPWM02FEN |EPWM0_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[6]     |EPWM02PEN |EPWM0_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[7]     |EPWM02CEN |EPWM0_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[8]     |EPWM04REN |EPWM0_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[9]     |EPWM04FEN |EPWM0_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[10]    |EPWM04PEN |EPWM0_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[11]    |EPWM04CEN |EPWM0_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[12]    |EPWM10REN |EPWM1_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[13]    |EPWM10FEN |EPWM1_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[14]    |EPWM10PEN |EPWM1_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[15]    |EPWM10CEN |EPWM1_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[16]    |EPWM12REN |EPWM1_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[17]    |EPWM120FEN|EPWM1_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[18]    |EPWM12PEN |EPWM1_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[19]    |EPWM12CEN |EPWM1_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[20]    |EPWM14REN |EPWM1_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[21]    |EPWM14FEN |EPWM1_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[22]    |EPWM14PEN |EPWM1_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[23]    |EPWM14CEN |EPWM1_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[24]    |PWM00REN  |PWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[25]    |PWM00FEN  |PWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[26]    |PWM00PEN  |PWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[27]    |PWM00CEN  |PWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[28]    |PWM01REN  |PWM0_CH1 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[29]    |PWM01FEN  |PWM0_CH1 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[30]    |PWM01PEN  |PWM0_CH1 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[31]    |PWM01CEN  |PWM0_CH1 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
    */
    __IO uint32_t AD0TRGEN1;

    /**
     * AD0TRGEN2
     * ===================================================================================================
     * Offset: 0x14C  A/D trigger condition for SAMPLE02
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |EPWM00REN |EPWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[1]     |EPWM00FEN |EPWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[2]     |EPWM00PEN |EPWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[3]     |EPWM00CEN |EPWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[4]     |EPWM02REN |EPWM0_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[5]     |EPWM02FEN |EPWM0_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[6]     |EPWM02PEN |EPWM0_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[7]     |EPWM02CEN |EPWM0_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[8]     |EPWM04REN |EPWM0_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[9]     |EPWM04FEN |EPWM0_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[10]    |EPWM04PEN |EPWM0_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[11]    |EPWM04CEN |EPWM0_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[12]    |EPWM10REN |EPWM1_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[13]    |EPWM10FEN |EPWM1_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[14]    |EPWM10PEN |EPWM1_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[15]    |EPWM10CEN |EPWM1_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[16]    |EPWM12REN |EPWM1_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[17]    |EPWM120FEN|EPWM1_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[18]    |EPWM12PEN |EPWM1_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[19]    |EPWM12CEN |EPWM1_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[20]    |EPWM14REN |EPWM1_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[21]    |EPWM14FEN |EPWM1_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[22]    |EPWM14PEN |EPWM1_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[23]    |EPWM14CEN |EPWM1_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[24]    |PWM00REN  |PWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[25]    |PWM00FEN  |PWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[26]    |PWM00PEN  |PWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[27]    |PWM00CEN  |PWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[28]    |PWM01REN  |PWM0_CH1 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[29]    |PWM01FEN  |PWM0_CH1 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[30]    |PWM01PEN  |PWM0_CH1 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[31]    |PWM01CEN  |PWM0_CH1 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
    */
    __IO uint32_t AD0TRGEN2;

    /**
     * AD0TRGEN3
     * ===================================================================================================
     * Offset: 0x150  A/D trigger condition for SAMPLE03
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |EPWM00REN |EPWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[1]     |EPWM00FEN |EPWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[2]     |EPWM00PEN |EPWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[3]     |EPWM00CEN |EPWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[4]     |EPWM02REN |EPWM0_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[5]     |EPWM02FEN |EPWM0_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[6]     |EPWM02PEN |EPWM0_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[7]     |EPWM02CEN |EPWM0_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[8]     |EPWM04REN |EPWM0_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[9]     |EPWM04FEN |EPWM0_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[10]    |EPWM04PEN |EPWM0_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[11]    |EPWM04CEN |EPWM0_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[12]    |EPWM10REN |EPWM1_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[13]    |EPWM10FEN |EPWM1_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[14]    |EPWM10PEN |EPWM1_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[15]    |EPWM10CEN |EPWM1_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[16]    |EPWM12REN |EPWM1_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[17]    |EPWM120FEN|EPWM1_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[18]    |EPWM12PEN |EPWM1_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[19]    |EPWM12CEN |EPWM1_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[20]    |EPWM14REN |EPWM1_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[21]    |EPWM14FEN |EPWM1_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[22]    |EPWM14PEN |EPWM1_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[23]    |EPWM14CEN |EPWM1_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[24]    |PWM00REN  |PWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[25]    |PWM00FEN  |PWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[26]    |PWM00PEN  |PWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[27]    |PWM00CEN  |PWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[28]    |PWM01REN  |PWM0_CH1 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[29]    |PWM01FEN  |PWM0_CH1 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[30]    |PWM01PEN  |PWM0_CH1 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[31]    |PWM01CEN  |PWM0_CH1 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
    */
    __IO uint32_t AD0TRGEN3;

    /**
     * AD1TRGEN0
     * ===================================================================================================
     * Offset: 0x154  A/D trigger condition for SAMPLE10
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |EPWM00REN |EPWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[1]     |EPWM00FEN |EPWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[2]     |EPWM00PEN |EPWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[3]     |EPWM00CEN |EPWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[4]     |EPWM02REN |EPWM0_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[5]     |EPWM02FEN |EPWM0_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[6]     |EPWM02PEN |EPWM0_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[7]     |EPWM02CEN |EPWM0_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[8]     |EPWM04REN |EPWM0_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[9]     |EPWM04FEN |EPWM0_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[10]    |EPWM04PEN |EPWM0_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[11]    |EPWM04CEN |EPWM0_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[12]    |EPWM10REN |EPWM1_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[13]    |EPWM10FEN |EPWM1_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[14]    |EPWM10PEN |EPWM1_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[15]    |EPWM10CEN |EPWM1_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[16]    |EPWM12REN |EPWM1_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[17]    |EPWM120FEN|EPWM1_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[18]    |EPWM12PEN |EPWM1_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[19]    |EPWM12CEN |EPWM1_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[20]    |EPWM14REN |EPWM1_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[21]    |EPWM14FEN |EPWM1_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[22]    |EPWM14PEN |EPWM1_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[23]    |EPWM14CEN |EPWM1_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[24]    |PWM00REN  |PWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[25]    |PWM00FEN  |PWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[26]    |PWM00PEN  |PWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[27]    |PWM00CEN  |PWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[28]    |PWM01REN  |PWM0_CH1 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[29]    |PWM01FEN  |PWM0_CH1 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[30]    |PWM01PEN  |PWM0_CH1 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[31]    |PWM01CEN  |PWM0_CH1 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
    */
    __IO uint32_t AD1TRGEN0;

    /**
     * AD1TRGEN1
     * ===================================================================================================
     * Offset: 0x158  A/D trigger condition for SAMPLE11
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |EPWM00REN |EPWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[1]     |EPWM00FEN |EPWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[2]     |EPWM00PEN |EPWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[3]     |EPWM00CEN |EPWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[4]     |EPWM02REN |EPWM0_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[5]     |EPWM02FEN |EPWM0_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[6]     |EPWM02PEN |EPWM0_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[7]     |EPWM02CEN |EPWM0_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[8]     |EPWM04REN |EPWM0_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[9]     |EPWM04FEN |EPWM0_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[10]    |EPWM04PEN |EPWM0_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[11]    |EPWM04CEN |EPWM0_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[12]    |EPWM10REN |EPWM1_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[13]    |EPWM10FEN |EPWM1_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[14]    |EPWM10PEN |EPWM1_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[15]    |EPWM10CEN |EPWM1_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[16]    |EPWM12REN |EPWM1_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[17]    |EPWM120FEN|EPWM1_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[18]    |EPWM12PEN |EPWM1_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[19]    |EPWM12CEN |EPWM1_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[20]    |EPWM14REN |EPWM1_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[21]    |EPWM14FEN |EPWM1_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[22]    |EPWM14PEN |EPWM1_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[23]    |EPWM14CEN |EPWM1_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[24]    |PWM00REN  |PWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[25]    |PWM00FEN  |PWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[26]    |PWM00PEN  |PWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[27]    |PWM00CEN  |PWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[28]    |PWM01REN  |PWM0_CH1 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[29]    |PWM01FEN  |PWM0_CH1 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[30]    |PWM01PEN  |PWM0_CH1 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[31]    |PWM01CEN  |PWM0_CH1 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
    */
    __IO uint32_t AD1TRGEN1;

    /**
     * AD1TRGEN2
     * ===================================================================================================
     * Offset: 0x15C  A/D trigger condition for SAMPLE12
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |EPWM00REN |EPWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[1]     |EPWM00FEN |EPWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[2]     |EPWM00PEN |EPWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[3]     |EPWM00CEN |EPWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[4]     |EPWM02REN |EPWM0_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[5]     |EPWM02FEN |EPWM0_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[6]     |EPWM02PEN |EPWM0_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[7]     |EPWM02CEN |EPWM0_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[8]     |EPWM04REN |EPWM0_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[9]     |EPWM04FEN |EPWM0_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[10]    |EPWM04PEN |EPWM0_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[11]    |EPWM04CEN |EPWM0_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[12]    |EPWM10REN |EPWM1_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[13]    |EPWM10FEN |EPWM1_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[14]    |EPWM10PEN |EPWM1_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[15]    |EPWM10CEN |EPWM1_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[16]    |EPWM12REN |EPWM1_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[17]    |EPWM120FEN|EPWM1_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[18]    |EPWM12PEN |EPWM1_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[19]    |EPWM12CEN |EPWM1_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[20]    |EPWM14REN |EPWM1_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[21]    |EPWM14FEN |EPWM1_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[22]    |EPWM14PEN |EPWM1_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[23]    |EPWM14CEN |EPWM1_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[24]    |PWM00REN  |PWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[25]    |PWM00FEN  |PWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[26]    |PWM00PEN  |PWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[27]    |PWM00CEN  |PWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[28]    |PWM01REN  |PWM0_CH1 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[29]    |PWM01FEN  |PWM0_CH1 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[30]    |PWM01PEN  |PWM0_CH1 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[31]    |PWM01CEN  |PWM0_CH1 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
    */
    __IO uint32_t AD1TRGEN2;

    /**
     * AD1TRGEN3
     * ===================================================================================================
     * Offset: 0x160  A/D trigger condition for SAMPLE13
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |EPWM00REN |EPWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[1]     |EPWM00FEN |EPWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[2]     |EPWM00PEN |EPWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[3]     |EPWM00CEN |EPWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[4]     |EPWM02REN |EPWM0_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[5]     |EPWM02FEN |EPWM0_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[6]     |EPWM02PEN |EPWM0_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[7]     |EPWM02CEN |EPWM0_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[8]     |EPWM04REN |EPWM0_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[9]     |EPWM04FEN |EPWM0_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[10]    |EPWM04PEN |EPWM0_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[11]    |EPWM04CEN |EPWM0_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[12]    |EPWM10REN |EPWM1_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[13]    |EPWM10FEN |EPWM1_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[14]    |EPWM10PEN |EPWM1_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[15]    |EPWM10CEN |EPWM1_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[16]    |EPWM12REN |EPWM1_CH2 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[17]    |EPWM120FEN|EPWM1_CH2 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[18]    |EPWM12PEN |EPWM1_CH2 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[19]    |EPWM12CEN |EPWM1_CH2 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[20]    |EPWM14REN |EPWM1_CH4 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[21]    |EPWM14FEN |EPWM1_CH4 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[22]    |EPWM14PEN |EPWM1_CH4 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[23]    |EPWM14CEN |EPWM1_CH4 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[24]    |PWM00REN  |PWM0_CH0 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[25]    |PWM00FEN  |PWM0_CH0 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[26]    |PWM00PEN  |PWM0_CH0 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[27]    |PWM00CEN  |PWM0_CH0 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[28]    |PWM01REN  |PWM0_CH1 Rising Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[29]    |PWM01FEN  |PWM0_CH1 Falling Edge Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[30]    |PWM01PEN  |PWM0_CH1 Period Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
     * |[31]    |PWM01CEN  |PWM0_CH1 Center Trigger Enable Control
     * |        |          |0 = Disabled.
     * |        |          |1 = Enabled.
    */
    __IO uint32_t AD1TRGEN3;

} EADC_T;

/**
    @addtogroup EADC_CONST EADC Bit Field Definition
    Constant Definitions for EADC Controller
@{ */

#define EADC_AD0DAT0_RESULT_Pos          (0)                                               /*!< EADC_T::AD0DAT0: RESULT Position          */
#define EADC_AD0DAT0_RESULT_Msk          (0xffful << EADC_AD0DAT0_RESULT_Pos)              /*!< EADC_T::AD0DAT0: RESULT Mask              */

#define EADC_AD0DAT0_OV_Pos              (16)                                              /*!< EADC_T::AD0DAT0: OV Position              */
#define EADC_AD0DAT0_OV_Msk              (0x1ul << EADC_AD0DAT0_OV_Pos)                    /*!< EADC_T::AD0DAT0: OV Mask                  */

#define EADC_AD0DAT0_VALID_Pos           (17)                                              /*!< EADC_T::AD0DAT0: VALID Position           */
#define EADC_AD0DAT0_VALID_Msk           (0x1ul << EADC_AD0DAT0_VALID_Pos)                 /*!< EADC_T::AD0DAT0: VALID Mask               */

#define EADC_AD0DAT1_RESULT_Pos          (0)                                               /*!< EADC_T::AD0DAT1: RESULT Position          */
#define EADC_AD0DAT1_RESULT_Msk          (0xffful << EADC_AD0DAT1_RESULT_Pos)              /*!< EADC_T::AD0DAT1: RESULT Mask              */

#define EADC_AD0DAT1_OV_Pos              (16)                                              /*!< EADC_T::AD0DAT1: OV Position              */
#define EADC_AD0DAT1_OV_Msk              (0x1ul << EADC_AD0DAT1_OV_Pos)                    /*!< EADC_T::AD0DAT1: OV Mask                  */

#define EADC_AD0DAT1_VALID_Pos           (17)                                              /*!< EADC_T::AD0DAT1: VALID Position           */
#define EADC_AD0DAT1_VALID_Msk           (0x1ul << EADC_AD0DAT1_VALID_Pos)                 /*!< EADC_T::AD0DAT1: VALID Mask               */

#define EADC_AD0DAT2_RESULT_Pos          (0)                                               /*!< EADC_T::AD0DAT2: RESULT Position          */
#define EADC_AD0DAT2_RESULT_Msk          (0xffful << EADC_AD0DAT2_RESULT_Pos)              /*!< EADC_T::AD0DAT2: RESULT Mask              */

#define EADC_AD0DAT2_OV_Pos              (16)                                              /*!< EADC_T::AD0DAT2: OV Position              */
#define EADC_AD0DAT2_OV_Msk              (0x1ul << EADC_AD0DAT2_OV_Pos)                    /*!< EADC_T::AD0DAT2: OV Mask                  */

#define EADC_AD0DAT2_VALID_Pos           (17)                                              /*!< EADC_T::AD0DAT2: VALID Position           */
#define EADC_AD0DAT2_VALID_Msk           (0x1ul << EADC_AD0DAT2_VALID_Pos)                 /*!< EADC_T::AD0DAT2: VALID Mask               */

#define EADC_AD0DAT3_RESULT_Pos          (0)                                               /*!< EADC_T::AD0DAT3: RESULT Position          */
#define EADC_AD0DAT3_RESULT_Msk          (0xffful << EADC_AD0DAT3_RESULT_Pos)              /*!< EADC_T::AD0DAT3: RESULT Mask              */

#define EADC_AD0DAT3_OV_Pos              (16)                                              /*!< EADC_T::AD0DAT3: OV Position              */
#define EADC_AD0DAT3_OV_Msk              (0x1ul << EADC_AD0DAT3_OV_Pos)                    /*!< EADC_T::AD0DAT3: OV Mask                  */

#define EADC_AD0DAT3_VALID_Pos           (17)                                              /*!< EADC_T::AD0DAT3: VALID Position           */
#define EADC_AD0DAT3_VALID_Msk           (0x1ul << EADC_AD0DAT3_VALID_Pos)                 /*!< EADC_T::AD0DAT3: VALID Mask               */

#define EADC_AD0DAT4_RESULT_Pos          (0)                                               /*!< EADC_T::AD0DAT4: RESULT Position          */
#define EADC_AD0DAT4_RESULT_Msk          (0xffful << EADC_AD0DAT4_RESULT_Pos)              /*!< EADC_T::AD0DAT4: RESULT Mask              */

#define EADC_AD0DAT4_OV_Pos              (16)                                              /*!< EADC_T::AD0DAT4: OV Position              */
#define EADC_AD0DAT4_OV_Msk              (0x1ul << EADC_AD0DAT4_OV_Pos)                    /*!< EADC_T::AD0DAT4: OV Mask                  */

#define EADC_AD0DAT4_VALID_Pos           (17)                                              /*!< EADC_T::AD0DAT4: VALID Position           */
#define EADC_AD0DAT4_VALID_Msk           (0x1ul << EADC_AD0DAT4_VALID_Pos)                 /*!< EADC_T::AD0DAT4: VALID Mask               */

#define EADC_AD0DAT5_RESULT_Pos          (0)                                               /*!< EADC_T::AD0DAT5: RESULT Position          */
#define EADC_AD0DAT5_RESULT_Msk          (0xffful << EADC_AD0DAT5_RESULT_Pos)              /*!< EADC_T::AD0DAT5: RESULT Mask              */

#define EADC_AD0DAT5_OV_Pos              (16)                                              /*!< EADC_T::AD0DAT5: OV Position              */
#define EADC_AD0DAT5_OV_Msk              (0x1ul << EADC_AD0DAT5_OV_Pos)                    /*!< EADC_T::AD0DAT5: OV Mask                  */

#define EADC_AD0DAT5_VALID_Pos           (17)                                              /*!< EADC_T::AD0DAT5: VALID Position           */
#define EADC_AD0DAT5_VALID_Msk           (0x1ul << EADC_AD0DAT5_VALID_Pos)                 /*!< EADC_T::AD0DAT5: VALID Mask               */

#define EADC_AD0DAT6_RESULT_Pos          (0)                                               /*!< EADC_T::AD0DAT6: RESULT Position          */
#define EADC_AD0DAT6_RESULT_Msk          (0xffful << EADC_AD0DAT6_RESULT_Pos)              /*!< EADC_T::AD0DAT6: RESULT Mask              */

#define EADC_AD0DAT6_OV_Pos              (16)                                              /*!< EADC_T::AD0DAT6: OV Position              */
#define EADC_AD0DAT6_OV_Msk              (0x1ul << EADC_AD0DAT6_OV_Pos)                    /*!< EADC_T::AD0DAT6: OV Mask                  */

#define EADC_AD0DAT6_VALID_Pos           (17)                                              /*!< EADC_T::AD0DAT6: VALID Position           */
#define EADC_AD0DAT6_VALID_Msk           (0x1ul << EADC_AD0DAT6_VALID_Pos)                 /*!< EADC_T::AD0DAT6: VALID Mask               */

#define EADC_AD0DAT7_RESULT_Pos          (0)                                               /*!< EADC_T::AD0DAT7: RESULT Position          */
#define EADC_AD0DAT7_RESULT_Msk          (0xffful << EADC_AD0DAT7_RESULT_Pos)              /*!< EADC_T::AD0DAT7: RESULT Mask              */

#define EADC_AD0DAT7_OV_Pos              (16)                                              /*!< EADC_T::AD0DAT7: OV Position              */
#define EADC_AD0DAT7_OV_Msk              (0x1ul << EADC_AD0DAT7_OV_Pos)                    /*!< EADC_T::AD0DAT7: OV Mask                  */

#define EADC_AD0DAT7_VALID_Pos           (17)                                              /*!< EADC_T::AD0DAT7: VALID Position           */
#define EADC_AD0DAT7_VALID_Msk           (0x1ul << EADC_AD0DAT7_VALID_Pos)                 /*!< EADC_T::AD0DAT7: VALID Mask               */

#define EADC_AD1DAT0_RESULT_Pos          (0)                                               /*!< EADC_T::AD1DAT0: RESULT Position          */
#define EADC_AD1DAT0_RESULT_Msk          (0xffful << EADC_AD1DAT0_RESULT_Pos)              /*!< EADC_T::AD1DAT0: RESULT Mask              */

#define EADC_AD1DAT0_OV_Pos              (16)                                              /*!< EADC_T::AD1DAT0: OV Position              */
#define EADC_AD1DAT0_OV_Msk              (0x1ul << EADC_AD1DAT0_OV_Pos)                    /*!< EADC_T::AD1DAT0: OV Mask                  */

#define EADC_AD1DAT0_VALID_Pos           (17)                                              /*!< EADC_T::AD1DAT0: VALID Position           */
#define EADC_AD1DAT0_VALID_Msk           (0x1ul << EADC_AD1DAT0_VALID_Pos)                 /*!< EADC_T::AD1DAT0: VALID Mask               */

#define EADC_AD1DAT1_RESULT_Pos          (0)                                               /*!< EADC_T::AD1DAT1: RESULT Position          */
#define EADC_AD1DAT1_RESULT_Msk          (0xffful << EADC_AD1DAT1_RESULT_Pos)              /*!< EADC_T::AD1DAT1: RESULT Mask              */

#define EADC_AD1DAT1_OV_Pos              (16)                                              /*!< EADC_T::AD1DAT1: OV Position              */
#define EADC_AD1DAT1_OV_Msk              (0x1ul << EADC_AD1DAT1_OV_Pos)                    /*!< EADC_T::AD1DAT1: OV Mask                  */

#define EADC_AD1DAT1_VALID_Pos           (17)                                              /*!< EADC_T::AD1DAT1: VALID Position           */
#define EADC_AD1DAT1_VALID_Msk           (0x1ul << EADC_AD1DAT1_VALID_Pos)                 /*!< EADC_T::AD1DAT1: VALID Mask               */

#define EADC_AD1DAT2_RESULT_Pos          (0)                                               /*!< EADC_T::AD1DAT2: RESULT Position          */
#define EADC_AD1DAT2_RESULT_Msk          (0xffful << EADC_AD1DAT2_RESULT_Pos)              /*!< EADC_T::AD1DAT2: RESULT Mask              */

#define EADC_AD1DAT2_OV_Pos              (16)                                              /*!< EADC_T::AD1DAT2: OV Position              */
#define EADC_AD1DAT2_OV_Msk              (0x1ul << EADC_AD1DAT2_OV_Pos)                    /*!< EADC_T::AD1DAT2: OV Mask                  */

#define EADC_AD1DAT2_VALID_Pos           (17)                                              /*!< EADC_T::AD1DAT2: VALID Position           */
#define EADC_AD1DAT2_VALID_Msk           (0x1ul << EADC_AD1DAT2_VALID_Pos)                 /*!< EADC_T::AD1DAT2: VALID Mask               */

#define EADC_AD1DAT3_RESULT_Pos          (0)                                               /*!< EADC_T::AD1DAT3: RESULT Position          */
#define EADC_AD1DAT3_RESULT_Msk          (0xffful << EADC_AD1DAT3_RESULT_Pos)              /*!< EADC_T::AD1DAT3: RESULT Mask              */

#define EADC_AD1DAT3_OV_Pos              (16)                                              /*!< EADC_T::AD1DAT3: OV Position              */
#define EADC_AD1DAT3_OV_Msk              (0x1ul << EADC_AD1DAT3_OV_Pos)                    /*!< EADC_T::AD1DAT3: OV Mask                  */

#define EADC_AD1DAT3_VALID_Pos           (17)                                              /*!< EADC_T::AD1DAT3: VALID Position           */
#define EADC_AD1DAT3_VALID_Msk           (0x1ul << EADC_AD1DAT3_VALID_Pos)                 /*!< EADC_T::AD1DAT3: VALID Mask               */

#define EADC_AD1DAT4_RESULT_Pos          (0)                                               /*!< EADC_T::AD1DAT4: RESULT Position          */
#define EADC_AD1DAT4_RESULT_Msk          (0xffful << EADC_AD1DAT4_RESULT_Pos)              /*!< EADC_T::AD1DAT4: RESULT Mask              */

#define EADC_AD1DAT4_OV_Pos              (16)                                              /*!< EADC_T::AD1DAT4: OV Position              */
#define EADC_AD1DAT4_OV_Msk              (0x1ul << EADC_AD1DAT4_OV_Pos)                    /*!< EADC_T::AD1DAT4: OV Mask                  */

#define EADC_AD1DAT4_VALID_Pos           (17)                                              /*!< EADC_T::AD1DAT4: VALID Position           */
#define EADC_AD1DAT4_VALID_Msk           (0x1ul << EADC_AD1DAT4_VALID_Pos)                 /*!< EADC_T::AD1DAT4: VALID Mask               */

#define EADC_AD1DAT5_RESULT_Pos          (0)                                               /*!< EADC_T::AD1DAT5: RESULT Position          */
#define EADC_AD1DAT5_RESULT_Msk          (0xffful << EADC_AD1DAT5_RESULT_Pos)              /*!< EADC_T::AD1DAT5: RESULT Mask              */

#define EADC_AD1DAT5_OV_Pos              (16)                                              /*!< EADC_T::AD1DAT5: OV Position              */
#define EADC_AD1DAT5_OV_Msk              (0x1ul << EADC_AD1DAT5_OV_Pos)                    /*!< EADC_T::AD1DAT5: OV Mask                  */

#define EADC_AD1DAT5_VALID_Pos           (17)                                              /*!< EADC_T::AD1DAT5: VALID Position           */
#define EADC_AD1DAT5_VALID_Msk           (0x1ul << EADC_AD1DAT5_VALID_Pos)                 /*!< EADC_T::AD1DAT5: VALID Mask               */

#define EADC_AD1DAT6_RESULT_Pos          (0)                                               /*!< EADC_T::AD1DAT6: RESULT Position          */
#define EADC_AD1DAT6_RESULT_Msk          (0xffful << EADC_AD1DAT6_RESULT_Pos)              /*!< EADC_T::AD1DAT6: RESULT Mask              */

#define EADC_AD1DAT6_OV_Pos              (16)                                              /*!< EADC_T::AD1DAT6: OV Position              */
#define EADC_AD1DAT6_OV_Msk              (0x1ul << EADC_AD1DAT6_OV_Pos)                    /*!< EADC_T::AD1DAT6: OV Mask                  */

#define EADC_AD1DAT6_VALID_Pos           (17)                                              /*!< EADC_T::AD1DAT6: VALID Position           */
#define EADC_AD1DAT6_VALID_Msk           (0x1ul << EADC_AD1DAT6_VALID_Pos)                 /*!< EADC_T::AD1DAT6: VALID Mask               */

#define EADC_AD1DAT7_RESULT_Pos          (0)                                               /*!< EADC_T::AD1DAT7: RESULT Position          */
#define EADC_AD1DAT7_RESULT_Msk          (0xffful << EADC_AD1DAT7_RESULT_Pos)              /*!< EADC_T::AD1DAT7: RESULT Mask              */

#define EADC_AD1DAT7_OV_Pos              (16)                                              /*!< EADC_T::AD1DAT7: OV Position              */
#define EADC_AD1DAT7_OV_Msk              (0x1ul << EADC_AD1DAT7_OV_Pos)                    /*!< EADC_T::AD1DAT7: OV Mask                  */

#define EADC_AD1DAT7_VALID_Pos           (17)                                              /*!< EADC_T::AD1DAT7: VALID Position           */
#define EADC_AD1DAT7_VALID_Msk           (0x1ul << EADC_AD1DAT7_VALID_Pos)                 /*!< EADC_T::AD1DAT7: VALID Mask               */

#define EADC_CTL_ADCEN_Pos               (0)                                               /*!< EADC_T::CTL: ADCEN Position               */
#define EADC_CTL_ADCEN_Msk               (0x1ul << EADC_CTL_ADCEN_Pos)                     /*!< EADC_T::CTL: ADCEN Mask                   */

#define EADC_CTL_ADCRST_Pos              (1)                                               /*!< EADC_T::CTL: ADCRST Position              */
#define EADC_CTL_ADCRST_Msk              (0x1ul << EADC_CTL_ADCRST_Pos)                    /*!< EADC_T::CTL: ADCRST Mask                  */

#define EADC_CTL_ADCIEN0_Pos             (2)                                               /*!< EADC_T::CTL: ADCIEN0 Position             */
#define EADC_CTL_ADCIEN0_Msk             (0x1ul << EADC_CTL_ADCIEN0_Pos)                   /*!< EADC_T::CTL: ADCIEN0 Mask                 */

#define EADC_CTL_ADCIEN1_Pos             (3)                                               /*!< EADC_T::CTL: ADCIEN1 Position             */
#define EADC_CTL_ADCIEN1_Msk             (0x1ul << EADC_CTL_ADCIEN1_Pos)                   /*!< EADC_T::CTL: ADCIEN1 Mask                 */

#define EADC_CTL_ADCIEN2_Pos             (4)                                               /*!< EADC_T::CTL: ADCIEN2 Position             */
#define EADC_CTL_ADCIEN2_Msk             (0x1ul << EADC_CTL_ADCIEN2_Pos)                   /*!< EADC_T::CTL: ADCIEN2 Mask                 */

#define EADC_CTL_ADCIEN3_Pos             (5)                                               /*!< EADC_T::CTL: ADCIEN3 Position             */
#define EADC_CTL_ADCIEN3_Msk             (0x1ul << EADC_CTL_ADCIEN3_Pos)                   /*!< EADC_T::CTL: ADCIEN3 Mask                 */

#define EADC_SWTRG_SWTRG7_0_Pos          (0)                                               /*!< EADC_T::SWTRG: SWTRG7_0 Position          */
#define EADC_SWTRG_SWTRG7_0_Msk          (0xfful << EADC_SWTRG_SWTRG7_0_Pos)               /*!< EADC_T::SWTRG: SWTRG7_0 Mask              */

#define EADC_SWTRG_SWTRG15_8_Pos         (8)                                               /*!< EADC_T::SWTRG: SWTRG15_8 Position         */
#define EADC_SWTRG_SWTRG15_8_Msk         (0xfful << EADC_SWTRG_SWTRG15_8_Pos)              /*!< EADC_T::SWTRG: SWTRG15_8 Mask             */

#define EADC_PENDSTS_STPF7_0_Pos         (0)                                               /*!< EADC_T::PENDSTS: STPF7_0 Position         */
#define EADC_PENDSTS_STPF7_0_Msk         (0xfful << EADC_PENDSTS_STPF7_0_Pos)              /*!< EADC_T::PENDSTS: STPF7_0 Mask             */

#define EADC_PENDSTS_STPF15_8_Pos        (8)                                               /*!< EADC_T::PENDSTS: STPF15_8 Position        */
#define EADC_PENDSTS_STPF15_8_Msk        (0xfful << EADC_PENDSTS_STPF15_8_Pos)             /*!< EADC_T::PENDSTS: STPF15_8 Mask            */

#define EADC_ADIFOV_ADFOV0_Pos           (0)                                               /*!< EADC_T::ADIFOV: ADFOV0 Position           */
#define EADC_ADIFOV_ADFOV0_Msk           (0x1ul << EADC_ADIFOV_ADFOV0_Pos)                 /*!< EADC_T::ADIFOV: ADFOV0 Mask               */

#define EADC_ADIFOV_ADFOV1_Pos           (1)                                               /*!< EADC_T::ADIFOV: ADFOV1 Position           */
#define EADC_ADIFOV_ADFOV1_Msk           (0x1ul << EADC_ADIFOV_ADFOV1_Pos)                 /*!< EADC_T::ADIFOV: ADFOV1 Mask               */

#define EADC_ADIFOV_ADFOV2_Pos           (2)                                               /*!< EADC_T::ADIFOV: ADFOV2 Position           */
#define EADC_ADIFOV_ADFOV2_Msk           (0x1ul << EADC_ADIFOV_ADFOV2_Pos)                 /*!< EADC_T::ADIFOV: ADFOV2 Mask               */

#define EADC_ADIFOV_ADFOV3_Pos           (3)                                               /*!< EADC_T::ADIFOV: ADFOV3 Position           */
#define EADC_ADIFOV_ADFOV3_Msk           (0x1ul << EADC_ADIFOV_ADFOV3_Pos)                 /*!< EADC_T::ADIFOV: ADFOV3 Mask               */

#define EADC_OVSTS_SPOVF7_0_Pos          (0)                                               /*!< EADC_T::OVSTS: SPOVF7_0 Position          */
#define EADC_OVSTS_SPOVF7_0_Msk          (0xfful << EADC_OVSTS_SPOVF7_0_Pos)               /*!< EADC_T::OVSTS: SPOVF7_0 Mask              */

#define EADC_OVSTS_SPOVF15_8_Pos         (8)                                               /*!< EADC_T::OVSTS: SPOVF15_8 Position         */
#define EADC_OVSTS_SPOVF15_8_Msk         (0xfful << EADC_OVSTS_SPOVF15_8_Pos)              /*!< EADC_T::OVSTS: SPOVF15_8 Mask             */

#define EADC_AD0SPCTL0_CHSEL_Pos         (0)                                               /*!< EADC_T::AD0SPCTL0: CHSEL Position         */
#define EADC_AD0SPCTL0_CHSEL_Msk         (0xful << EADC_AD0SPCTL0_CHSEL_Pos)               /*!< EADC_T::AD0SPCTL0: CHSEL Mask             */

#define EADC_AD0SPCTL0_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD0SPCTL0: TRGSEL Position        */
#define EADC_AD0SPCTL0_TRGSEL_Msk        (0xful << EADC_AD0SPCTL0_TRGSEL_Pos)              /*!< EADC_T::AD0SPCTL0: TRGSEL Mask            */

#define EADC_AD0SPCTL0_TRGDLYCNT_Pos     (8)                                               /*!< EADC_T::AD0SPCTL0: TRGDLYCNT Position     */
#define EADC_AD0SPCTL0_TRGDLYCNT_Msk     (0xfful << EADC_AD0SPCTL0_TRGDLYCNT_Pos)          /*!< EADC_T::AD0SPCTL0: TRGDLYCNT Mask         */

#define EADC_AD0SPCTL0_TRGDLYDIV_Pos     (16)                                              /*!< EADC_T::AD0SPCTL0: TRGDLYDIV Position     */
#define EADC_AD0SPCTL0_TRGDLYDIV_Msk     (0x3ul << EADC_AD0SPCTL0_TRGDLYDIV_Pos)           /*!< EADC_T::AD0SPCTL0: TRGDLYDIV Mask         */

#define EADC_AD0SPCTL0_EXTREN_Pos        (20)                                              /*!< EADC_T::AD0SPCTL0: EXTREN Position        */
#define EADC_AD0SPCTL0_EXTREN_Msk        (0x1ul << EADC_AD0SPCTL0_EXTREN_Pos)              /*!< EADC_T::AD0SPCTL0: EXTREN Mask            */

#define EADC_AD0SPCTL0_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD0SPCTL0: EXTFEN Position        */
#define EADC_AD0SPCTL0_EXTFEN_Msk        (0x1ul << EADC_AD0SPCTL0_EXTFEN_Pos)              /*!< EADC_T::AD0SPCTL0: EXTFEN Mask            */

#define EADC_AD0SPCTL1_CHSEL_Pos         (0)                                               /*!< EADC_T::AD0SPCTL1: CHSEL Position         */
#define EADC_AD0SPCTL1_CHSEL_Msk         (0xful << EADC_AD0SPCTL1_CHSEL_Pos)               /*!< EADC_T::AD0SPCTL1: CHSEL Mask             */

#define EADC_AD0SPCTL1_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD0SPCTL1: TRGSEL Position        */
#define EADC_AD0SPCTL1_TRGSEL_Msk        (0xful << EADC_AD0SPCTL1_TRGSEL_Pos)              /*!< EADC_T::AD0SPCTL1: TRGSEL Mask            */

#define EADC_AD0SPCTL1_TRGDLYCNT_Pos     (8)                                               /*!< EADC_T::AD0SPCTL1: TRGDLYCNT Position     */
#define EADC_AD0SPCTL1_TRGDLYCNT_Msk     (0xfful << EADC_AD0SPCTL1_TRGDLYCNT_Pos)          /*!< EADC_T::AD0SPCTL1: TRGDLYCNT Mask         */

#define EADC_AD0SPCTL1_TRGDLYDIV_Pos     (16)                                              /*!< EADC_T::AD0SPCTL1: TRGDLYDIV Position     */
#define EADC_AD0SPCTL1_TRGDLYDIV_Msk     (0x3ul << EADC_AD0SPCTL1_TRGDLYDIV_Pos)           /*!< EADC_T::AD0SPCTL1: TRGDLYDIV Mask         */

#define EADC_AD0SPCTL1_EXTREN_Pos        (20)                                              /*!< EADC_T::AD0SPCTL1: EXTREN Position        */
#define EADC_AD0SPCTL1_EXTREN_Msk        (0x1ul << EADC_AD0SPCTL1_EXTREN_Pos)              /*!< EADC_T::AD0SPCTL1: EXTREN Mask            */

#define EADC_AD0SPCTL1_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD0SPCTL1: EXTFEN Position        */
#define EADC_AD0SPCTL1_EXTFEN_Msk        (0x1ul << EADC_AD0SPCTL1_EXTFEN_Pos)              /*!< EADC_T::AD0SPCTL1: EXTFEN Mask            */

#define EADC_AD0SPCTL2_CHSEL_Pos         (0)                                               /*!< EADC_T::AD0SPCTL2: CHSEL Position         */
#define EADC_AD0SPCTL2_CHSEL_Msk         (0xful << EADC_AD0SPCTL2_CHSEL_Pos)               /*!< EADC_T::AD0SPCTL2: CHSEL Mask             */

#define EADC_AD0SPCTL2_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD0SPCTL2: TRGSEL Position        */
#define EADC_AD0SPCTL2_TRGSEL_Msk        (0xful << EADC_AD0SPCTL2_TRGSEL_Pos)              /*!< EADC_T::AD0SPCTL2: TRGSEL Mask            */

#define EADC_AD0SPCTL2_TRGDLYCNT_Pos     (8)                                               /*!< EADC_T::AD0SPCTL2: TRGDLYCNT Position     */
#define EADC_AD0SPCTL2_TRGDLYCNT_Msk     (0xfful << EADC_AD0SPCTL2_TRGDLYCNT_Pos)          /*!< EADC_T::AD0SPCTL2: TRGDLYCNT Mask         */

#define EADC_AD0SPCTL2_TRGDLYDIV_Pos     (16)                                              /*!< EADC_T::AD0SPCTL2: TRGDLYDIV Position     */
#define EADC_AD0SPCTL2_TRGDLYDIV_Msk     (0x3ul << EADC_AD0SPCTL2_TRGDLYDIV_Pos)           /*!< EADC_T::AD0SPCTL2: TRGDLYDIV Mask         */

#define EADC_AD0SPCTL2_EXTREN_Pos        (20)                                              /*!< EADC_T::AD0SPCTL2: EXTREN Position        */
#define EADC_AD0SPCTL2_EXTREN_Msk        (0x1ul << EADC_AD0SPCTL2_EXTREN_Pos)              /*!< EADC_T::AD0SPCTL2: EXTREN Mask            */

#define EADC_AD0SPCTL2_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD0SPCTL2: EXTFEN Position        */
#define EADC_AD0SPCTL2_EXTFEN_Msk        (0x1ul << EADC_AD0SPCTL2_EXTFEN_Pos)              /*!< EADC_T::AD0SPCTL2: EXTFEN Mask            */

#define EADC_AD0SPCTL3_CHSEL_Pos         (0)                                               /*!< EADC_T::AD0SPCTL3: CHSEL Position         */
#define EADC_AD0SPCTL3_CHSEL_Msk         (0xful << EADC_AD0SPCTL3_CHSEL_Pos)               /*!< EADC_T::AD0SPCTL3: CHSEL Mask             */

#define EADC_AD0SPCTL3_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD0SPCTL3: TRGSEL Position        */
#define EADC_AD0SPCTL3_TRGSEL_Msk        (0xful << EADC_AD0SPCTL3_TRGSEL_Pos)              /*!< EADC_T::AD0SPCTL3: TRGSEL Mask            */

#define EADC_AD0SPCTL3_TRGDLYCNT_Pos     (8)                                               /*!< EADC_T::AD0SPCTL3: TRGDLYCNT Position     */
#define EADC_AD0SPCTL3_TRGDLYCNT_Msk     (0xfful << EADC_AD0SPCTL3_TRGDLYCNT_Pos)          /*!< EADC_T::AD0SPCTL3: TRGDLYCNT Mask         */

#define EADC_AD0SPCTL3_TRGDLYDIV_Pos     (16)                                              /*!< EADC_T::AD0SPCTL3: TRGDLYDIV Position     */
#define EADC_AD0SPCTL3_TRGDLYDIV_Msk     (0x3ul << EADC_AD0SPCTL3_TRGDLYDIV_Pos)           /*!< EADC_T::AD0SPCTL3: TRGDLYDIV Mask         */

#define EADC_AD0SPCTL3_EXTREN_Pos        (20)                                              /*!< EADC_T::AD0SPCTL3: EXTREN Position        */
#define EADC_AD0SPCTL3_EXTREN_Msk        (0x1ul << EADC_AD0SPCTL3_EXTREN_Pos)              /*!< EADC_T::AD0SPCTL3: EXTREN Mask            */

#define EADC_AD0SPCTL3_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD0SPCTL3: EXTFEN Position        */
#define EADC_AD0SPCTL3_EXTFEN_Msk        (0x1ul << EADC_AD0SPCTL3_EXTFEN_Pos)              /*!< EADC_T::AD0SPCTL3: EXTFEN Mask            */

#define EADC_AD0SPCTL4_CHSEL_Pos         (0)                                               /*!< EADC_T::AD0SPCTL4: CHSEL Position         */
#define EADC_AD0SPCTL4_CHSEL_Msk         (0xful << EADC_AD0SPCTL4_CHSEL_Pos)               /*!< EADC_T::AD0SPCTL4: CHSEL Mask             */

#define EADC_AD0SPCTL4_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD0SPCTL4: TRGSEL Position        */
#define EADC_AD0SPCTL4_TRGSEL_Msk        (0x7ul << EADC_AD0SPCTL4_TRGSEL_Pos)              /*!< EADC_T::AD0SPCTL4: TRGSEL Mask            */

#define EADC_AD0SPCTL4_EXTREN_Pos        (20)                                              /*!< EADC_T::AD0SPCTL4: EXTREN Position        */
#define EADC_AD0SPCTL4_EXTREN_Msk        (0x1ul << EADC_AD0SPCTL4_EXTREN_Pos)              /*!< EADC_T::AD0SPCTL4: EXTREN Mask            */

#define EADC_AD0SPCTL4_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD0SPCTL4: EXTFEN Position        */
#define EADC_AD0SPCTL4_EXTFEN_Msk        (0x1ul << EADC_AD0SPCTL4_EXTFEN_Pos)              /*!< EADC_T::AD0SPCTL4: EXTFEN Mask            */

#define EADC_AD0SPCTL5_CHSEL_Pos         (0)                                               /*!< EADC_T::AD0SPCTL5: CHSEL Position         */
#define EADC_AD0SPCTL5_CHSEL_Msk         (0xful << EADC_AD0SPCTL5_CHSEL_Pos)               /*!< EADC_T::AD0SPCTL5: CHSEL Mask             */

#define EADC_AD0SPCTL5_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD0SPCTL5: TRGSEL Position        */
#define EADC_AD0SPCTL5_TRGSEL_Msk        (0x7ul << EADC_AD0SPCTL5_TRGSEL_Pos)              /*!< EADC_T::AD0SPCTL5: TRGSEL Mask            */

#define EADC_AD0SPCTL5_EXTREN_Pos        (20)                                              /*!< EADC_T::AD0SPCTL5: EXTREN Position        */
#define EADC_AD0SPCTL5_EXTREN_Msk        (0x1ul << EADC_AD0SPCTL5_EXTREN_Pos)              /*!< EADC_T::AD0SPCTL5: EXTREN Mask            */

#define EADC_AD0SPCTL5_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD0SPCTL5: EXTFEN Position        */
#define EADC_AD0SPCTL5_EXTFEN_Msk        (0x1ul << EADC_AD0SPCTL5_EXTFEN_Pos)              /*!< EADC_T::AD0SPCTL5: EXTFEN Mask            */

#define EADC_AD0SPCTL6_CHSEL_Pos         (0)                                               /*!< EADC_T::AD0SPCTL6: CHSEL Position         */
#define EADC_AD0SPCTL6_CHSEL_Msk         (0xful << EADC_AD0SPCTL6_CHSEL_Pos)               /*!< EADC_T::AD0SPCTL6: CHSEL Mask             */

#define EADC_AD0SPCTL6_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD0SPCTL6: TRGSEL Position        */
#define EADC_AD0SPCTL6_TRGSEL_Msk        (0x7ul << EADC_AD0SPCTL6_TRGSEL_Pos)              /*!< EADC_T::AD0SPCTL6: TRGSEL Mask            */

#define EADC_AD0SPCTL6_EXTREN_Pos        (20)                                              /*!< EADC_T::AD0SPCTL6: EXTREN Position        */
#define EADC_AD0SPCTL6_EXTREN_Msk        (0x1ul << EADC_AD0SPCTL6_EXTREN_Pos)              /*!< EADC_T::AD0SPCTL6: EXTREN Mask            */

#define EADC_AD0SPCTL6_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD0SPCTL6: EXTFEN Position        */
#define EADC_AD0SPCTL6_EXTFEN_Msk        (0x1ul << EADC_AD0SPCTL6_EXTFEN_Pos)              /*!< EADC_T::AD0SPCTL6: EXTFEN Mask            */

#define EADC_AD0SPCTL7_CHSEL_Pos         (0)                                               /*!< EADC_T::AD0SPCTL7: CHSEL Position         */
#define EADC_AD0SPCTL7_CHSEL_Msk         (0xful << EADC_AD0SPCTL7_CHSEL_Pos)               /*!< EADC_T::AD0SPCTL7: CHSEL Mask             */

#define EADC_AD0SPCTL7_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD0SPCTL7: TRGSEL Position        */
#define EADC_AD0SPCTL7_TRGSEL_Msk        (0x7ul << EADC_AD0SPCTL7_TRGSEL_Pos)              /*!< EADC_T::AD0SPCTL7: TRGSEL Mask            */

#define EADC_AD0SPCTL7_EXTREN_Pos        (20)                                              /*!< EADC_T::AD0SPCTL7: EXTREN Position        */
#define EADC_AD0SPCTL7_EXTREN_Msk        (0x1ul << EADC_AD0SPCTL7_EXTREN_Pos)              /*!< EADC_T::AD0SPCTL7: EXTREN Mask            */

#define EADC_AD0SPCTL7_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD0SPCTL7: EXTFEN Position        */
#define EADC_AD0SPCTL7_EXTFEN_Msk        (0x1ul << EADC_AD0SPCTL7_EXTFEN_Pos)              /*!< EADC_T::AD0SPCTL7: EXTFEN Mask            */

#define EADC_AD1SPCTL0_CHSEL_Pos         (0)                                               /*!< EADC_T::AD1SPCTL0: CHSEL Position         */
#define EADC_AD1SPCTL0_CHSEL_Msk         (0xful << EADC_AD1SPCTL0_CHSEL_Pos)               /*!< EADC_T::AD1SPCTL0: CHSEL Mask             */

#define EADC_AD1SPCTL0_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD1SPCTL0: TRGSEL Position        */
#define EADC_AD1SPCTL0_TRGSEL_Msk        (0xful << EADC_AD1SPCTL0_TRGSEL_Pos)              /*!< EADC_T::AD1SPCTL0: TRGSEL Mask            */

#define EADC_AD1SPCTL0_TRGDLYCNT_Pos     (8)                                               /*!< EADC_T::AD1SPCTL0: TRGDLYCNT Position     */
#define EADC_AD1SPCTL0_TRGDLYCNT_Msk     (0xfful << EADC_AD1SPCTL0_TRGDLYCNT_Pos)          /*!< EADC_T::AD1SPCTL0: TRGDLYCNT Mask         */

#define EADC_AD1SPCTL0_TRGDLYDIV_Pos     (16)                                              /*!< EADC_T::AD1SPCTL0: TRGDLYDIV Position     */
#define EADC_AD1SPCTL0_TRGDLYDIV_Msk     (0x3ul << EADC_AD1SPCTL0_TRGDLYDIV_Pos)           /*!< EADC_T::AD1SPCTL0: TRGDLYDIV Mask         */

#define EADC_AD1SPCTL0_EXTREN_Pos        (20)                                              /*!< EADC_T::AD1SPCTL0: EXTREN Position        */
#define EADC_AD1SPCTL0_EXTREN_Msk        (0x1ul << EADC_AD1SPCTL0_EXTREN_Pos)              /*!< EADC_T::AD1SPCTL0: EXTREN Mask            */

#define EADC_AD1SPCTL0_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD1SPCTL0: EXTFEN Position        */
#define EADC_AD1SPCTL0_EXTFEN_Msk        (0x1ul << EADC_AD1SPCTL0_EXTFEN_Pos)              /*!< EADC_T::AD1SPCTL0: EXTFEN Mask            */

#define EADC_AD1SPCTL1_CHSEL_Pos         (0)                                               /*!< EADC_T::AD1SPCTL1: CHSEL Position         */
#define EADC_AD1SPCTL1_CHSEL_Msk         (0xful << EADC_AD1SPCTL1_CHSEL_Pos)               /*!< EADC_T::AD1SPCTL1: CHSEL Mask             */

#define EADC_AD1SPCTL1_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD1SPCTL1: TRGSEL Position        */
#define EADC_AD1SPCTL1_TRGSEL_Msk        (0xful << EADC_AD1SPCTL1_TRGSEL_Pos)              /*!< EADC_T::AD1SPCTL1: TRGSEL Mask            */

#define EADC_AD1SPCTL1_TRGDLYCNT_Pos     (8)                                               /*!< EADC_T::AD1SPCTL1: TRGDLYCNT Position     */
#define EADC_AD1SPCTL1_TRGDLYCNT_Msk     (0xfful << EADC_AD1SPCTL1_TRGDLYCNT_Pos)          /*!< EADC_T::AD1SPCTL1: TRGDLYCNT Mask         */

#define EADC_AD1SPCTL1_TRGDLYDIV_Pos     (16)                                              /*!< EADC_T::AD1SPCTL1: TRGDLYDIV Position     */
#define EADC_AD1SPCTL1_TRGDLYDIV_Msk     (0x3ul << EADC_AD1SPCTL1_TRGDLYDIV_Pos)           /*!< EADC_T::AD1SPCTL1: TRGDLYDIV Mask         */

#define EADC_AD1SPCTL1_EXTREN_Pos        (20)                                              /*!< EADC_T::AD1SPCTL1: EXTREN Position        */
#define EADC_AD1SPCTL1_EXTREN_Msk        (0x1ul << EADC_AD1SPCTL1_EXTREN_Pos)              /*!< EADC_T::AD1SPCTL1: EXTREN Mask            */

#define EADC_AD1SPCTL1_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD1SPCTL1: EXTFEN Position        */
#define EADC_AD1SPCTL1_EXTFEN_Msk        (0x1ul << EADC_AD1SPCTL1_EXTFEN_Pos)              /*!< EADC_T::AD1SPCTL1: EXTFEN Mask            */

#define EADC_AD1SPCTL2_CHSEL_Pos         (0)                                               /*!< EADC_T::AD1SPCTL2: CHSEL Position         */
#define EADC_AD1SPCTL2_CHSEL_Msk         (0xful << EADC_AD1SPCTL2_CHSEL_Pos)               /*!< EADC_T::AD1SPCTL2: CHSEL Mask             */

#define EADC_AD1SPCTL2_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD1SPCTL2: TRGSEL Position        */
#define EADC_AD1SPCTL2_TRGSEL_Msk        (0xful << EADC_AD1SPCTL2_TRGSEL_Pos)              /*!< EADC_T::AD1SPCTL2: TRGSEL Mask            */

#define EADC_AD1SPCTL2_TRGDLYCNT_Pos     (8)                                               /*!< EADC_T::AD1SPCTL2: TRGDLYCNT Position     */
#define EADC_AD1SPCTL2_TRGDLYCNT_Msk     (0xfful << EADC_AD1SPCTL2_TRGDLYCNT_Pos)          /*!< EADC_T::AD1SPCTL2: TRGDLYCNT Mask         */

#define EADC_AD1SPCTL2_TRGDLYDIV_Pos     (16)                                              /*!< EADC_T::AD1SPCTL2: TRGDLYDIV Position     */
#define EADC_AD1SPCTL2_TRGDLYDIV_Msk     (0x3ul << EADC_AD1SPCTL2_TRGDLYDIV_Pos)           /*!< EADC_T::AD1SPCTL2: TRGDLYDIV Mask         */

#define EADC_AD1SPCTL2_EXTREN_Pos        (20)                                              /*!< EADC_T::AD1SPCTL2: EXTREN Position        */
#define EADC_AD1SPCTL2_EXTREN_Msk        (0x1ul << EADC_AD1SPCTL2_EXTREN_Pos)              /*!< EADC_T::AD1SPCTL2: EXTREN Mask            */

#define EADC_AD1SPCTL2_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD1SPCTL2: EXTFEN Position        */
#define EADC_AD1SPCTL2_EXTFEN_Msk        (0x1ul << EADC_AD1SPCTL2_EXTFEN_Pos)              /*!< EADC_T::AD1SPCTL2: EXTFEN Mask            */

#define EADC_AD1SPCTL3_CHSEL_Pos         (0)                                               /*!< EADC_T::AD1SPCTL3: CHSEL Position         */
#define EADC_AD1SPCTL3_CHSEL_Msk         (0xful << EADC_AD1SPCTL3_CHSEL_Pos)               /*!< EADC_T::AD1SPCTL3: CHSEL Mask             */

#define EADC_AD1SPCTL3_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD1SPCTL3: TRGSEL Position        */
#define EADC_AD1SPCTL3_TRGSEL_Msk        (0xful << EADC_AD1SPCTL3_TRGSEL_Pos)              /*!< EADC_T::AD1SPCTL3: TRGSEL Mask            */

#define EADC_AD1SPCTL3_TRGDLYCNT_Pos     (8)                                               /*!< EADC_T::AD1SPCTL3: TRGDLYCNT Position     */
#define EADC_AD1SPCTL3_TRGDLYCNT_Msk     (0xfful << EADC_AD1SPCTL3_TRGDLYCNT_Pos)          /*!< EADC_T::AD1SPCTL3: TRGDLYCNT Mask         */

#define EADC_AD1SPCTL3_TRGDLYDIV_Pos     (16)                                              /*!< EADC_T::AD1SPCTL3: TRGDLYDIV Position     */
#define EADC_AD1SPCTL3_TRGDLYDIV_Msk     (0x3ul << EADC_AD1SPCTL3_TRGDLYDIV_Pos)           /*!< EADC_T::AD1SPCTL3: TRGDLYDIV Mask         */

#define EADC_AD1SPCTL3_EXTREN_Pos        (20)                                              /*!< EADC_T::AD1SPCTL3: EXTREN Position        */
#define EADC_AD1SPCTL3_EXTREN_Msk        (0x1ul << EADC_AD1SPCTL3_EXTREN_Pos)              /*!< EADC_T::AD1SPCTL3: EXTREN Mask            */

#define EADC_AD1SPCTL3_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD1SPCTL3: EXTFEN Position        */
#define EADC_AD1SPCTL3_EXTFEN_Msk        (0x1ul << EADC_AD1SPCTL3_EXTFEN_Pos)              /*!< EADC_T::AD1SPCTL3: EXTFEN Mask            */

#define EADC_AD1SPCTL4_CHSEL_Pos         (0)                                               /*!< EADC_T::AD1SPCTL4: CHSEL Position         */
#define EADC_AD1SPCTL4_CHSEL_Msk         (0xful << EADC_AD1SPCTL4_CHSEL_Pos)               /*!< EADC_T::AD1SPCTL4: CHSEL Mask             */

#define EADC_AD1SPCTL4_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD1SPCTL4: TRGSEL Position        */
#define EADC_AD1SPCTL4_TRGSEL_Msk        (0x7ul << EADC_AD1SPCTL4_TRGSEL_Pos)              /*!< EADC_T::AD1SPCTL4: TRGSEL Mask            */

#define EADC_AD1SPCTL4_EXTREN_Pos        (20)                                              /*!< EADC_T::AD1SPCTL4: EXTREN Position        */
#define EADC_AD1SPCTL4_EXTREN_Msk        (0x1ul << EADC_AD1SPCTL4_EXTREN_Pos)              /*!< EADC_T::AD1SPCTL4: EXTREN Mask            */

#define EADC_AD1SPCTL4_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD1SPCTL4: EXTFEN Position        */
#define EADC_AD1SPCTL4_EXTFEN_Msk        (0x1ul << EADC_AD1SPCTL4_EXTFEN_Pos)              /*!< EADC_T::AD1SPCTL4: EXTFEN Mask            */

#define EADC_AD1SPCTL5_CHSEL_Pos         (0)                                               /*!< EADC_T::AD1SPCTL5: CHSEL Position         */
#define EADC_AD1SPCTL5_CHSEL_Msk         (0xful << EADC_AD1SPCTL5_CHSEL_Pos)               /*!< EADC_T::AD1SPCTL5: CHSEL Mask             */

#define EADC_AD1SPCTL5_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD1SPCTL5: TRGSEL Position        */
#define EADC_AD1SPCTL5_TRGSEL_Msk        (0x7ul << EADC_AD1SPCTL5_TRGSEL_Pos)              /*!< EADC_T::AD1SPCTL5: TRGSEL Mask            */

#define EADC_AD1SPCTL5_EXTREN_Pos        (20)                                              /*!< EADC_T::AD1SPCTL5: EXTREN Position        */
#define EADC_AD1SPCTL5_EXTREN_Msk        (0x1ul << EADC_AD1SPCTL5_EXTREN_Pos)              /*!< EADC_T::AD1SPCTL5: EXTREN Mask            */

#define EADC_AD1SPCTL5_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD1SPCTL5: EXTFEN Position        */
#define EADC_AD1SPCTL5_EXTFEN_Msk        (0x1ul << EADC_AD1SPCTL5_EXTFEN_Pos)              /*!< EADC_T::AD1SPCTL5: EXTFEN Mask            */

#define EADC_AD1SPCTL6_CHSEL_Pos         (0)                                               /*!< EADC_T::AD1SPCTL6: CHSEL Position         */
#define EADC_AD1SPCTL6_CHSEL_Msk         (0xful << EADC_AD1SPCTL6_CHSEL_Pos)               /*!< EADC_T::AD1SPCTL6: CHSEL Mask             */

#define EADC_AD1SPCTL6_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD1SPCTL6: TRGSEL Position        */
#define EADC_AD1SPCTL6_TRGSEL_Msk        (0x7ul << EADC_AD1SPCTL6_TRGSEL_Pos)              /*!< EADC_T::AD1SPCTL6: TRGSEL Mask            */

#define EADC_AD1SPCTL6_EXTREN_Pos        (20)                                              /*!< EADC_T::AD1SPCTL6: EXTREN Position        */
#define EADC_AD1SPCTL6_EXTREN_Msk        (0x1ul << EADC_AD1SPCTL6_EXTREN_Pos)              /*!< EADC_T::AD1SPCTL6: EXTREN Mask            */

#define EADC_AD1SPCTL6_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD1SPCTL6: EXTFEN Position        */
#define EADC_AD1SPCTL6_EXTFEN_Msk        (0x1ul << EADC_AD1SPCTL6_EXTFEN_Pos)              /*!< EADC_T::AD1SPCTL6: EXTFEN Mask            */

#define EADC_AD1SPCTL7_CHSEL_Pos         (0)                                               /*!< EADC_T::AD1SPCTL7: CHSEL Position         */
#define EADC_AD1SPCTL7_CHSEL_Msk         (0xful << EADC_AD1SPCTL7_CHSEL_Pos)               /*!< EADC_T::AD1SPCTL7: CHSEL Mask             */

#define EADC_AD1SPCTL7_TRGSEL_Pos        (4)                                               /*!< EADC_T::AD1SPCTL7: TRGSEL Position        */
#define EADC_AD1SPCTL7_TRGSEL_Msk        (0x7ul << EADC_AD1SPCTL7_TRGSEL_Pos)              /*!< EADC_T::AD1SPCTL7: TRGSEL Mask            */

#define EADC_AD1SPCTL7_EXTREN_Pos        (20)                                              /*!< EADC_T::AD1SPCTL7: EXTREN Position        */
#define EADC_AD1SPCTL7_EXTREN_Msk        (0x1ul << EADC_AD1SPCTL7_EXTREN_Pos)              /*!< EADC_T::AD1SPCTL7: EXTREN Mask            */

#define EADC_AD1SPCTL7_EXTFEN_Pos        (21)                                              /*!< EADC_T::AD1SPCTL7: EXTFEN Position        */
#define EADC_AD1SPCTL7_EXTFEN_Msk        (0x1ul << EADC_AD1SPCTL7_EXTFEN_Pos)              /*!< EADC_T::AD1SPCTL7: EXTFEN Mask            */

#define EADC_SIMUSEL_SIMUSEL0_Pos        (0)                                               /*!< EADC_T::SIMUSEL: SIMUSEL0 Position        */
#define EADC_SIMUSEL_SIMUSEL0_Msk        (0x1ul << EADC_SIMUSEL_SIMUSEL0_Pos)              /*!< EADC_T::SIMUSEL: SIMUSEL0 Mask            */

#define EADC_SIMUSEL_SIMUSEL1_Pos        (1)                                               /*!< EADC_T::SIMUSEL: SIMUSEL1 Position        */
#define EADC_SIMUSEL_SIMUSEL1_Msk        (0x1ul << EADC_SIMUSEL_SIMUSEL1_Pos)              /*!< EADC_T::SIMUSEL: SIMUSEL1 Mask            */

#define EADC_SIMUSEL_SIMUSEL2_Pos        (2)                                               /*!< EADC_T::SIMUSEL: SIMUSEL2 Position        */
#define EADC_SIMUSEL_SIMUSEL2_Msk        (0x1ul << EADC_SIMUSEL_SIMUSEL2_Pos)              /*!< EADC_T::SIMUSEL: SIMUSEL2 Mask            */

#define EADC_SIMUSEL_SIMUSEL3_Pos        (3)                                               /*!< EADC_T::SIMUSEL: SIMUSEL3 Position        */
#define EADC_SIMUSEL_SIMUSEL3_Msk        (0x1ul << EADC_SIMUSEL_SIMUSEL3_Pos)              /*!< EADC_T::SIMUSEL: SIMUSEL3 Mask            */

#define EADC_SIMUSEL_SIMUSEL4_Pos        (4)                                               /*!< EADC_T::SIMUSEL: SIMUSEL4 Position        */
#define EADC_SIMUSEL_SIMUSEL4_Msk        (0x1ul << EADC_SIMUSEL_SIMUSEL4_Pos)              /*!< EADC_T::SIMUSEL: SIMUSEL4 Mask            */

#define EADC_SIMUSEL_SIMUSEL5_Pos        (5)                                               /*!< EADC_T::SIMUSEL: SIMUSEL5 Position        */
#define EADC_SIMUSEL_SIMUSEL5_Msk        (0x1ul << EADC_SIMUSEL_SIMUSEL5_Pos)              /*!< EADC_T::SIMUSEL: SIMUSEL5 Mask            */

#define EADC_SIMUSEL_SIMUSEL6_Pos        (6)                                               /*!< EADC_T::SIMUSEL: SIMUSEL6 Position        */
#define EADC_SIMUSEL_SIMUSEL6_Msk        (0x1ul << EADC_SIMUSEL_SIMUSEL6_Pos)              /*!< EADC_T::SIMUSEL: SIMUSEL6 Mask            */

#define EADC_SIMUSEL_SIMUSEL7_Pos        (7)                                               /*!< EADC_T::SIMUSEL: SIMUSEL7 Position        */
#define EADC_SIMUSEL_SIMUSEL7_Msk        (0x1ul << EADC_SIMUSEL_SIMUSEL7_Pos)              /*!< EADC_T::SIMUSEL: SIMUSEL7 Mask            */

#define EADC_CMP0_ADCMPEN_Pos            (0)                                               /*!< EADC_T::CMP: ADCMPEN Position            */
#define EADC_CMP0_ADCMPEN_Msk            (0x1ul << EADC_CMP0_ADCMPEN_Pos)                  /*!< EADC_T::CMP: ADCMPEN Mask                */

#define EADC_CMP0_ADCMPIE_Pos            (1)                                               /*!< EADC_T::CMP: ADCMPIE Position            */
#define EADC_CMP0_ADCMPIE_Msk            (0x1ul << EADC_CMP0_ADCMPIE_Pos)                  /*!< EADC_T::CMP: ADCMPIE Mask                */

#define EADC_CMP0_CMPCOND_Pos            (2)                                               /*!< EADC_T::CMP: CMPCOND Position            */
#define EADC_CMP0_CMPCOND_Msk            (0x1ul << EADC_CMP0_CMPCOND_Pos)                  /*!< EADC_T::CMP: CMPCOND Mask                */

#define EADC_CMP0_CMPSPL_Pos             (3)                                               /*!< EADC_T::CMP: CMPSPL Position             */
#define EADC_CMP0_CMPSPL_Msk             (0x7ul << EADC_CMP0_CMPSPL_Pos)                   /*!< EADC_T::CMP: CMPSPL Mask                 */

#define EADC_CMP0_CMPMCNT_Pos            (8)                                               /*!< EADC_T::CMP: CMPMCNT Position            */
#define EADC_CMP0_CMPMCNT_Msk            (0xful << EADC_CMP0_CMPMCNT_Pos)                  /*!< EADC_T::CMP: CMPMCNT Mask                */

#define EADC_CMP0_CMPDAT_Pos             (16)                                              /*!< EADC_T::CMP: CMPDAT Position             */
#define EADC_CMP0_CMPDAT_Msk             (0xffful << EADC_CMP0_CMPDAT_Pos)                 /*!< EADC_T::CMP: CMPDAT Mask                 */

#define EADC_CMP1_ADCMPEN_Pos            (0)                                               /*!< EADC_T::CMP: ADCMPEN Position            */
#define EADC_CMP1_ADCMPEN_Msk            (0x1ul << EADC_CMP1_ADCMPEN_Pos)                  /*!< EADC_T::CMP: ADCMPEN Mask                */

#define EADC_CMP1_ADCMPIE_Pos            (1)                                               /*!< EADC_T::CMP: ADCMPIE Position            */
#define EADC_CMP1_ADCMPIE_Msk            (0x1ul << EADC_CMP1_ADCMPIE_Pos)                  /*!< EADC_T::CMP: ADCMPIE Mask                */

#define EADC_CMP1_CMPCOND_Pos            (2)                                               /*!< EADC_T::CMP: CMPCOND Position            */
#define EADC_CMP1_CMPCOND_Msk            (0x1ul << EADC_CMP1_CMPCOND_Pos)                  /*!< EADC_T::CMP: CMPCOND Mask                */

#define EADC_CMP1_CMPSPL_Pos             (3)                                               /*!< EADC_T::CMP: CMPSPL Position             */
#define EADC_CMP1_CMPSPL_Msk             (0x7ul << EADC_CMP1_CMPSPL_Pos)                   /*!< EADC_T::CMP: CMPSPL Mask                 */

#define EADC_CMP1_CMPMCNT_Pos            (8)                                               /*!< EADC_T::CMP: CMPMCNT Position            */
#define EADC_CMP1_CMPMCNT_Msk            (0xful << EADC_CMP1_CMPMCNT_Pos)                  /*!< EADC_T::CMP: CMPMCNT Mask                */

#define EADC_CMP1_CMPDAT_Pos             (16)                                              /*!< EADC_T::CMP: CMPDAT Position             */
#define EADC_CMP1_CMPDAT_Msk             (0xffful << EADC_CMP1_CMPDAT_Pos)                 /*!< EADC_T::CMP: CMPDAT Mask                 */

#define EADC_STATUS0_VALID_Pos           (0)                                               /*!< EADC_T::STATUS0: VALID Position           */
#define EADC_STATUS0_VALID_Msk           (0xfffful << EADC_STATUS0_VALID_Pos)              /*!< EADC_T::STATUS0: VALID Mask               */

#define EADC_STATUS0_OV_Pos              (16)                                              /*!< EADC_T::STATUS0: OV Position              */
#define EADC_STATUS0_OV_Msk              (0xfffful << EADC_STATUS0_OV_Pos)                 /*!< EADC_T::STATUS0: OV Mask                  */

#define EADC_STATUS1_ADIF0_Pos           (0)                                               /*!< EADC_T::STATUS1: ADIF0 Position           */
#define EADC_STATUS1_ADIF0_Msk           (0x1ul << EADC_STATUS1_ADIF0_Pos)                 /*!< EADC_T::STATUS1: ADIF0 Mask               */

#define EADC_STATUS1_ADIF1_Pos           (1)                                               /*!< EADC_T::STATUS1: ADIF1 Position           */
#define EADC_STATUS1_ADIF1_Msk           (0x1ul << EADC_STATUS1_ADIF1_Pos)                 /*!< EADC_T::STATUS1: ADIF1 Mask               */

#define EADC_STATUS1_ADIF2_Pos           (2)                                               /*!< EADC_T::STATUS1: ADIF2 Position           */
#define EADC_STATUS1_ADIF2_Msk           (0x1ul << EADC_STATUS1_ADIF2_Pos)                 /*!< EADC_T::STATUS1: ADIF2 Mask               */

#define EADC_STATUS1_ADIF3_Pos           (3)                                               /*!< EADC_T::STATUS1: ADIF3 Position           */
#define EADC_STATUS1_ADIF3_Msk           (0x1ul << EADC_STATUS1_ADIF3_Pos)                 /*!< EADC_T::STATUS1: ADIF3 Mask               */

#define EADC_STATUS1_ADCMPO0_Pos         (4)                                               /*!< EADC_T::STATUS1: ADCMPO0 Position         */
#define EADC_STATUS1_ADCMPO0_Msk         (0x1ul << EADC_STATUS1_ADCMPO0_Pos)               /*!< EADC_T::STATUS1: ADCMPO0 Mask             */

#define EADC_STATUS1_ADCMPO1_Pos         (5)                                               /*!< EADC_T::STATUS1: ADCMPO1 Position         */
#define EADC_STATUS1_ADCMPO1_Msk         (0x1ul << EADC_STATUS1_ADCMPO1_Pos)               /*!< EADC_T::STATUS1: ADCMPO1 Mask             */

#define EADC_STATUS1_ADCMPF0_Pos         (6)                                               /*!< EADC_T::STATUS1: ADCMPF0 Position         */
#define EADC_STATUS1_ADCMPF0_Msk         (0x1ul << EADC_STATUS1_ADCMPF0_Pos)               /*!< EADC_T::STATUS1: ADCMPF0 Mask             */

#define EADC_STATUS1_ADCMPF1_Pos         (7)                                               /*!< EADC_T::STATUS1: ADCMPF1 Position         */
#define EADC_STATUS1_ADCMPF1_Msk         (0x1ul << EADC_STATUS1_ADCMPF1_Pos)               /*!< EADC_T::STATUS1: ADCMPF1 Mask             */

#define EADC_STATUS1_BUSY0_Pos           (8)                                               /*!< EADC_T::STATUS1: BUSY0 Position           */
#define EADC_STATUS1_BUSY0_Msk           (0x1ul << EADC_STATUS1_BUSY0_Pos)                 /*!< EADC_T::STATUS1: BUSY0 Mask               */

#define EADC_STATUS1_CHANNEL0_Pos        (12)                                              /*!< EADC_T::STATUS1: CHANNEL0 Position        */
#define EADC_STATUS1_CHANNEL0_Msk        (0xful << EADC_STATUS1_CHANNEL0_Pos)              /*!< EADC_T::STATUS1: CHANNEL0 Mask            */

#define EADC_STATUS1_BUSY1_Pos           (16)                                              /*!< EADC_T::STATUS1: BUSY1 Position           */
#define EADC_STATUS1_BUSY1_Msk           (0x1ul << EADC_STATUS1_BUSY1_Pos)                 /*!< EADC_T::STATUS1: BUSY1 Mask               */

#define EADC_STATUS1_CHANNEL1_Pos        (20)                                              /*!< EADC_T::STATUS1: CHANNEL1 Position        */
#define EADC_STATUS1_CHANNEL1_Msk        (0xful << EADC_STATUS1_CHANNEL1_Pos)              /*!< EADC_T::STATUS1: CHANNEL1 Mask            */

#define EADC_STATUS1_ADOVIF_Pos          (24)                                              /*!< EADC_T::STATUS1: ADOVIF Position          */
#define EADC_STATUS1_ADOVIF_Msk          (0x1ul << EADC_STATUS1_ADOVIF_Pos)                /*!< EADC_T::STATUS1: ADOVIF Mask              */

#define EADC_STATUS1_STOVF_Pos           (25)                                              /*!< EADC_T::STATUS1: STOVF Position           */
#define EADC_STATUS1_STOVF_Msk           (0x1ul << EADC_STATUS1_STOVF_Pos)                 /*!< EADC_T::STATUS1: STOVF Mask               */

#define EADC_STATUS1_AVALID_Pos          (26)                                              /*!< EADC_T::STATUS1: AVALID Position          */
#define EADC_STATUS1_AVALID_Msk          (0x1ul << EADC_STATUS1_AVALID_Pos)                /*!< EADC_T::STATUS1: AVALID Mask              */

#define EADC_STATUS1_AOV_Pos             (27)                                              /*!< EADC_T::STATUS1: AOV Position             */
#define EADC_STATUS1_AOV_Msk             (0x1ul << EADC_STATUS1_AOV_Pos)                   /*!< EADC_T::STATUS1: AOV Mask                 */

#define EADC_EXTSMPT_EXTSMPT0_Pos        (0)                                               /*!< EADC_T::EXTSMPT: EXTSMPT0 Position        */
#define EADC_EXTSMPT_EXTSMPT0_Msk        (0xfful << EADC_EXTSMPT_EXTSMPT0_Pos)             /*!< EADC_T::EXTSMPT: EXTSMPT0 Mask            */

#define EADC_EXTSMPT_EXTSMPT1_Pos        (16)                                              /*!< EADC_T::EXTSMPT: EXTSMPT1 Position        */
#define EADC_EXTSMPT_EXTSMPT1_Msk        (0xfful << EADC_EXTSMPT_EXTSMPT1_Pos)             /*!< EADC_T::EXTSMPT: EXTSMPT1 Mask            */

#define EADC_AD0DDAT0_RESULT_Pos         (0)                                               /*!< EADC_T::AD0DDAT0: RESULT Position         */
#define EADC_AD0DDAT0_RESULT_Msk         (0xffful << EADC_AD0DDAT0_RESULT_Pos)             /*!< EADC_T::AD0DDAT0: RESULT Mask             */

#define EADC_AD0DDAT0_VALID_Pos          (16)                                              /*!< EADC_T::AD0DDAT0: VALID Position          */
#define EADC_AD0DDAT0_VALID_Msk          (0x1ul << EADC_AD0DDAT0_VALID_Pos)                /*!< EADC_T::AD0DDAT0: VALID Mask              */

#define EADC_AD0DDAT1_RESULT_Pos         (0)                                               /*!< EADC_T::AD0DDAT1: RESULT Position         */
#define EADC_AD0DDAT1_RESULT_Msk         (0xffful << EADC_AD0DDAT1_RESULT_Pos)             /*!< EADC_T::AD0DDAT1: RESULT Mask             */

#define EADC_AD0DDAT1_VALID_Pos          (16)                                              /*!< EADC_T::AD0DDAT1: VALID Position          */
#define EADC_AD0DDAT1_VALID_Msk          (0x1ul << EADC_AD0DDAT1_VALID_Pos)                /*!< EADC_T::AD0DDAT1: VALID Mask              */

#define EADC_AD0DDAT2_RESULT_Pos         (0)                                               /*!< EADC_T::AD0DDAT2: RESULT Position         */
#define EADC_AD0DDAT2_RESULT_Msk         (0xffful << EADC_AD0DDAT2_RESULT_Pos)             /*!< EADC_T::AD0DDAT2: RESULT Mask             */

#define EADC_AD0DDAT2_VALID_Pos          (16)                                              /*!< EADC_T::AD0DDAT2: VALID Position          */
#define EADC_AD0DDAT2_VALID_Msk          (0x1ul << EADC_AD0DDAT2_VALID_Pos)                /*!< EADC_T::AD0DDAT2: VALID Mask              */

#define EADC_AD0DDAT3_RESULT_Pos         (0)                                               /*!< EADC_T::AD0DDAT3: RESULT Position         */
#define EADC_AD0DDAT3_RESULT_Msk         (0xffful << EADC_AD0DDAT3_RESULT_Pos)             /*!< EADC_T::AD0DDAT3: RESULT Mask             */

#define EADC_AD0DDAT3_VALID_Pos          (16)                                              /*!< EADC_T::AD0DDAT3: VALID Position          */
#define EADC_AD0DDAT3_VALID_Msk          (0x1ul << EADC_AD0DDAT3_VALID_Pos)                /*!< EADC_T::AD0DDAT3: VALID Mask              */

#define EADC_AD1DDAT0_RESULT_Pos         (0)                                               /*!< EADC_T::AD1DDAT0: RESULT Position         */
#define EADC_AD1DDAT0_RESULT_Msk         (0xffful << EADC_AD1DDAT0_RESULT_Pos)             /*!< EADC_T::AD1DDAT0: RESULT Mask             */

#define EADC_AD1DDAT0_VALID_Pos          (16)                                              /*!< EADC_T::AD1DDAT0: VALID Position          */
#define EADC_AD1DDAT0_VALID_Msk          (0x1ul << EADC_AD1DDAT0_VALID_Pos)                /*!< EADC_T::AD1DDAT0: VALID Mask              */

#define EADC_AD1DDAT1_RESULT_Pos         (0)                                               /*!< EADC_T::AD1DDAT1: RESULT Position         */
#define EADC_AD1DDAT1_RESULT_Msk         (0xffful << EADC_AD1DDAT1_RESULT_Pos)             /*!< EADC_T::AD1DDAT1: RESULT Mask             */

#define EADC_AD1DDAT1_VALID_Pos          (16)                                              /*!< EADC_T::AD1DDAT1: VALID Position          */
#define EADC_AD1DDAT1_VALID_Msk          (0x1ul << EADC_AD1DDAT1_VALID_Pos)                /*!< EADC_T::AD1DDAT1: VALID Mask              */

#define EADC_AD1DDAT2_RESULT_Pos         (0)                                               /*!< EADC_T::AD1DDAT2: RESULT Position         */
#define EADC_AD1DDAT2_RESULT_Msk         (0xffful << EADC_AD1DDAT2_RESULT_Pos)             /*!< EADC_T::AD1DDAT2: RESULT Mask             */

#define EADC_AD1DDAT2_VALID_Pos          (16)                                              /*!< EADC_T::AD1DDAT2: VALID Position          */
#define EADC_AD1DDAT2_VALID_Msk          (0x1ul << EADC_AD1DDAT2_VALID_Pos)                /*!< EADC_T::AD1DDAT2: VALID Mask              */

#define EADC_AD1DDAT3_RESULT_Pos         (0)                                               /*!< EADC_T::AD1DDAT3: RESULT Position         */
#define EADC_AD1DDAT3_RESULT_Msk         (0xffful << EADC_AD1DDAT3_RESULT_Pos)             /*!< EADC_T::AD1DDAT3: RESULT Mask             */

#define EADC_AD1DDAT3_VALID_Pos          (16)                                              /*!< EADC_T::AD1DDAT3: VALID Position          */
#define EADC_AD1DDAT3_VALID_Msk          (0x1ul << EADC_AD1DDAT3_VALID_Pos)                /*!< EADC_T::AD1DDAT3: VALID Mask              */

#define EADC_DBMEN_AD0DBM0_Pos           (0)                                               /*!< EADC_T::DBMEN: AD0DBM0 Position           */
#define EADC_DBMEN_AD0DBM0_Msk           (0x1ul << EADC_DBMEN_AD0DBM0_Pos)                 /*!< EADC_T::DBMEN: AD0DBM0 Mask               */

#define EADC_DBMEN_AD0DBM1_Pos           (1)                                               /*!< EADC_T::DBMEN: AD0DBM1 Position           */
#define EADC_DBMEN_AD0DBM1_Msk           (0x1ul << EADC_DBMEN_AD0DBM1_Pos)                 /*!< EADC_T::DBMEN: AD0DBM1 Mask               */

#define EADC_DBMEN_AD0DBM2_Pos           (2)                                               /*!< EADC_T::DBMEN: AD0DBM2 Position           */
#define EADC_DBMEN_AD0DBM2_Msk           (0x1ul << EADC_DBMEN_AD0DBM2_Pos)                 /*!< EADC_T::DBMEN: AD0DBM2 Mask               */

#define EADC_DBMEN_AD0DBM3_Pos           (3)                                               /*!< EADC_T::DBMEN: AD0DBM3 Position           */
#define EADC_DBMEN_AD0DBM3_Msk           (0x1ul << EADC_DBMEN_AD0DBM3_Pos)                 /*!< EADC_T::DBMEN: AD0DBM3 Mask               */

#define EADC_DBMEN_AD1DBM0_Pos           (8)                                               /*!< EADC_T::DBMEN: AD1DBM0 Position           */
#define EADC_DBMEN_AD1DBM0_Msk           (0x1ul << EADC_DBMEN_AD1DBM0_Pos)                 /*!< EADC_T::DBMEN: AD1DBM0 Mask               */

#define EADC_DBMEN_AD1DBM1_Pos           (9)                                               /*!< EADC_T::DBMEN: AD1DBM1 Position           */
#define EADC_DBMEN_AD1DBM1_Msk           (0x1ul << EADC_DBMEN_AD1DBM1_Pos)                 /*!< EADC_T::DBMEN: AD1DBM1 Mask               */

#define EADC_DBMEN_AD1DBM2_Pos           (10)                                              /*!< EADC_T::DBMEN: AD1DBM2 Position           */
#define EADC_DBMEN_AD1DBM2_Msk           (0x1ul << EADC_DBMEN_AD1DBM2_Pos)                 /*!< EADC_T::DBMEN: AD1DBM2 Mask               */

#define EADC_DBMEN_AD1DBM3_Pos           (11)                                              /*!< EADC_T::DBMEN: AD1DBM3 Position           */
#define EADC_DBMEN_AD1DBM3_Msk           (0x1ul << EADC_DBMEN_AD1DBM3_Pos)                 /*!< EADC_T::DBMEN: AD1DBM3 Mask               */

#define EADC_INTSRC0_AD0SPIE0_Pos        (0)                                               /*!< EADC_T::INTSRC: AD0SPIE0 Position        */
#define EADC_INTSRC0_AD0SPIE0_Msk        (0x1ul << EADC_INTSRC0_AD0SPIE0_Pos)              /*!< EADC_T::INTSRC: AD0SPIE0 Mask            */

#define EADC_INTSRC0_AD0SPIE1_Pos        (1)                                               /*!< EADC_T::INTSRC: AD0SPIE1 Position        */
#define EADC_INTSRC0_AD0SPIE1_Msk        (0x1ul << EADC_INTSRC0_AD0SPIE1_Pos)              /*!< EADC_T::INTSRC: AD0SPIE1 Mask            */

#define EADC_INTSRC0_AD0SPIE2_Pos        (2)                                               /*!< EADC_T::INTSRC: AD0SPIE2 Position        */
#define EADC_INTSRC0_AD0SPIE2_Msk        (0x1ul << EADC_INTSRC0_AD0SPIE2_Pos)              /*!< EADC_T::INTSRC: AD0SPIE2 Mask            */

#define EADC_INTSRC0_AD0SPIE3_Pos        (3)                                               /*!< EADC_T::INTSRC: AD0SPIE3 Position        */
#define EADC_INTSRC0_AD0SPIE3_Msk        (0x1ul << EADC_INTSRC0_AD0SPIE3_Pos)              /*!< EADC_T::INTSRC: AD0SPIE3 Mask            */

#define EADC_INTSRC0_AD0SPIE4_Pos        (4)                                               /*!< EADC_T::INTSRC: AD0SPIE4 Position        */
#define EADC_INTSRC0_AD0SPIE4_Msk        (0x1ul << EADC_INTSRC0_AD0SPIE4_Pos)              /*!< EADC_T::INTSRC: AD0SPIE4 Mask            */

#define EADC_INTSRC0_AD0SPIE5_Pos        (5)                                               /*!< EADC_T::INTSRC: AD0SPIE5 Position        */
#define EADC_INTSRC0_AD0SPIE5_Msk        (0x1ul << EADC_INTSRC0_AD0SPIE5_Pos)              /*!< EADC_T::INTSRC: AD0SPIE5 Mask            */

#define EADC_INTSRC0_AD0SPIE6_Pos        (6)                                               /*!< EADC_T::INTSRC: AD0SPIE6 Position        */
#define EADC_INTSRC0_AD0SPIE6_Msk        (0x1ul << EADC_INTSRC0_AD0SPIE6_Pos)              /*!< EADC_T::INTSRC: AD0SPIE6 Mask            */

#define EADC_INTSRC0_AD0SPIE7_Pos        (7)                                               /*!< EADC_T::INTSRC: AD0SPIE7 Position        */
#define EADC_INTSRC0_AD0SPIE7_Msk        (0x1ul << EADC_INTSRC0_AD0SPIE7_Pos)              /*!< EADC_T::INTSRC: AD0SPIE7 Mask            */

#define EADC_INTSRC0_AD1SPIE0_Pos        (8)                                               /*!< EADC_T::INTSRC: AD1SPIE0 Position        */
#define EADC_INTSRC0_AD1SPIE0_Msk        (0x1ul << EADC_INTSRC0_AD1SPIE0_Pos)              /*!< EADC_T::INTSRC: AD1SPIE0 Mask            */

#define EADC_INTSRC0_AD1SPIE1_Pos        (9)                                               /*!< EADC_T::INTSRC: AD1SPIE1 Position        */
#define EADC_INTSRC0_AD1SPIE1_Msk        (0x1ul << EADC_INTSRC0_AD1SPIE1_Pos)              /*!< EADC_T::INTSRC: AD1SPIE1 Mask            */

#define EADC_INTSRC0_AD1SPIE2_Pos        (10)                                              /*!< EADC_T::INTSRC: AD1SPIE2 Position        */
#define EADC_INTSRC0_AD1SPIE2_Msk        (0x1ul << EADC_INTSRC0_AD1SPIE2_Pos)              /*!< EADC_T::INTSRC: AD1SPIE2 Mask            */

#define EADC_INTSRC0_AD1SPIE3_Pos        (11)                                              /*!< EADC_T::INTSRC: AD1SPIE3 Position        */
#define EADC_INTSRC0_AD1SPIE3_Msk        (0x1ul << EADC_INTSRC0_AD1SPIE3_Pos)              /*!< EADC_T::INTSRC: AD1SPIE3 Mask            */

#define EADC_INTSRC0_AD1SPIE4_Pos        (12)                                              /*!< EADC_T::INTSRC: AD1SPIE4 Position        */
#define EADC_INTSRC0_AD1SPIE4_Msk        (0x1ul << EADC_INTSRC0_AD1SPIE4_Pos)              /*!< EADC_T::INTSRC: AD1SPIE4 Mask            */

#define EADC_INTSRC0_AD1SPIE5_Pos        (13)                                              /*!< EADC_T::INTSRC: AD1SPIE5 Position        */
#define EADC_INTSRC0_AD1SPIE5_Msk        (0x1ul << EADC_INTSRC0_AD1SPIE5_Pos)              /*!< EADC_T::INTSRC: AD1SPIE5 Mask            */

#define EADC_INTSRC0_AD1SPIE6_Pos        (14)                                              /*!< EADC_T::INTSRC: AD1SPIE6 Position        */
#define EADC_INTSRC0_AD1SPIE6_Msk        (0x1ul << EADC_INTSRC0_AD1SPIE6_Pos)              /*!< EADC_T::INTSRC: AD1SPIE6 Mask            */

#define EADC_INTSRC0_AD1SPIE7_Pos        (15)                                              /*!< EADC_T::INTSRC: AD1SPIE7 Position        */
#define EADC_INTSRC0_AD1SPIE7_Msk        (0x1ul << EADC_INTSRC0_AD1SPIE7_Pos)              /*!< EADC_T::INTSRC: AD1SPIE7 Mask            */

#define EADC_INTSRC1_AD0SPIE0_Pos        (0)                                               /*!< EADC_T::INTSRC: AD0SPIE0 Position        */
#define EADC_INTSRC1_AD0SPIE0_Msk        (0x1ul << EADC_INTSRC1_AD0SPIE0_Pos)              /*!< EADC_T::INTSRC: AD0SPIE0 Mask            */

#define EADC_INTSRC1_AD0SPIE1_Pos        (1)                                               /*!< EADC_T::INTSRC: AD0SPIE1 Position        */
#define EADC_INTSRC1_AD0SPIE1_Msk        (0x1ul << EADC_INTSRC1_AD0SPIE1_Pos)              /*!< EADC_T::INTSRC: AD0SPIE1 Mask            */

#define EADC_INTSRC1_AD0SPIE2_Pos        (2)                                               /*!< EADC_T::INTSRC: AD0SPIE2 Position        */
#define EADC_INTSRC1_AD0SPIE2_Msk        (0x1ul << EADC_INTSRC1_AD0SPIE2_Pos)              /*!< EADC_T::INTSRC: AD0SPIE2 Mask            */

#define EADC_INTSRC1_AD0SPIE3_Pos        (3)                                               /*!< EADC_T::INTSRC: AD0SPIE3 Position        */
#define EADC_INTSRC1_AD0SPIE3_Msk        (0x1ul << EADC_INTSRC1_AD0SPIE3_Pos)              /*!< EADC_T::INTSRC: AD0SPIE3 Mask            */

#define EADC_INTSRC1_AD0SPIE4_Pos        (4)                                               /*!< EADC_T::INTSRC: AD0SPIE4 Position        */
#define EADC_INTSRC1_AD0SPIE4_Msk        (0x1ul << EADC_INTSRC1_AD0SPIE4_Pos)              /*!< EADC_T::INTSRC: AD0SPIE4 Mask            */

#define EADC_INTSRC1_AD0SPIE5_Pos        (5)                                               /*!< EADC_T::INTSRC: AD0SPIE5 Position        */
#define EADC_INTSRC1_AD0SPIE5_Msk        (0x1ul << EADC_INTSRC1_AD0SPIE5_Pos)              /*!< EADC_T::INTSRC: AD0SPIE5 Mask            */

#define EADC_INTSRC1_AD0SPIE6_Pos        (6)                                               /*!< EADC_T::INTSRC: AD0SPIE6 Position        */
#define EADC_INTSRC1_AD0SPIE6_Msk        (0x1ul << EADC_INTSRC1_AD0SPIE6_Pos)              /*!< EADC_T::INTSRC: AD0SPIE6 Mask            */

#define EADC_INTSRC1_AD0SPIE7_Pos        (7)                                               /*!< EADC_T::INTSRC: AD0SPIE7 Position        */
#define EADC_INTSRC1_AD0SPIE7_Msk        (0x1ul << EADC_INTSRC1_AD0SPIE7_Pos)              /*!< EADC_T::INTSRC: AD0SPIE7 Mask            */

#define EADC_INTSRC1_AD1SPIE0_Pos        (8)                                               /*!< EADC_T::INTSRC: AD1SPIE0 Position        */
#define EADC_INTSRC1_AD1SPIE0_Msk        (0x1ul << EADC_INTSRC1_AD1SPIE0_Pos)              /*!< EADC_T::INTSRC: AD1SPIE0 Mask            */

#define EADC_INTSRC1_AD1SPIE1_Pos        (9)                                               /*!< EADC_T::INTSRC: AD1SPIE1 Position        */
#define EADC_INTSRC1_AD1SPIE1_Msk        (0x1ul << EADC_INTSRC1_AD1SPIE1_Pos)              /*!< EADC_T::INTSRC: AD1SPIE1 Mask            */

#define EADC_INTSRC1_AD1SPIE2_Pos        (10)                                              /*!< EADC_T::INTSRC: AD1SPIE2 Position        */
#define EADC_INTSRC1_AD1SPIE2_Msk        (0x1ul << EADC_INTSRC1_AD1SPIE2_Pos)              /*!< EADC_T::INTSRC: AD1SPIE2 Mask            */

#define EADC_INTSRC1_AD1SPIE3_Pos        (11)                                              /*!< EADC_T::INTSRC: AD1SPIE3 Position        */
#define EADC_INTSRC1_AD1SPIE3_Msk        (0x1ul << EADC_INTSRC1_AD1SPIE3_Pos)              /*!< EADC_T::INTSRC: AD1SPIE3 Mask            */

#define EADC_INTSRC1_AD1SPIE4_Pos        (12)                                              /*!< EADC_T::INTSRC: AD1SPIE4 Position        */
#define EADC_INTSRC1_AD1SPIE4_Msk        (0x1ul << EADC_INTSRC1_AD1SPIE4_Pos)              /*!< EADC_T::INTSRC: AD1SPIE4 Mask            */

#define EADC_INTSRC1_AD1SPIE5_Pos        (13)                                              /*!< EADC_T::INTSRC: AD1SPIE5 Position        */
#define EADC_INTSRC1_AD1SPIE5_Msk        (0x1ul << EADC_INTSRC1_AD1SPIE5_Pos)              /*!< EADC_T::INTSRC: AD1SPIE5 Mask            */

#define EADC_INTSRC1_AD1SPIE6_Pos        (14)                                              /*!< EADC_T::INTSRC: AD1SPIE6 Position        */
#define EADC_INTSRC1_AD1SPIE6_Msk        (0x1ul << EADC_INTSRC1_AD1SPIE6_Pos)              /*!< EADC_T::INTSRC: AD1SPIE6 Mask            */

#define EADC_INTSRC1_AD1SPIE7_Pos        (15)                                              /*!< EADC_T::INTSRC: AD1SPIE7 Position        */
#define EADC_INTSRC1_AD1SPIE7_Msk        (0x1ul << EADC_INTSRC1_AD1SPIE7_Pos)              /*!< EADC_T::INTSRC: AD1SPIE7 Mask            */

#define EADC_INTSRC2_AD0SPIE0_Pos        (0)                                               /*!< EADC_T::INTSRC: AD0SPIE0 Position        */
#define EADC_INTSRC2_AD0SPIE0_Msk        (0x1ul << EADC_INTSRC2_AD0SPIE0_Pos)              /*!< EADC_T::INTSRC: AD0SPIE0 Mask            */

#define EADC_INTSRC2_AD0SPIE1_Pos        (1)                                               /*!< EADC_T::INTSRC: AD0SPIE1 Position        */
#define EADC_INTSRC2_AD0SPIE1_Msk        (0x1ul << EADC_INTSRC2_AD0SPIE1_Pos)              /*!< EADC_T::INTSRC: AD0SPIE1 Mask            */

#define EADC_INTSRC2_AD0SPIE2_Pos        (2)                                               /*!< EADC_T::INTSRC: AD0SPIE2 Position        */
#define EADC_INTSRC2_AD0SPIE2_Msk        (0x1ul << EADC_INTSRC2_AD0SPIE2_Pos)              /*!< EADC_T::INTSRC: AD0SPIE2 Mask            */

#define EADC_INTSRC2_AD0SPIE3_Pos        (3)                                               /*!< EADC_T::INTSRC: AD0SPIE3 Position        */
#define EADC_INTSRC2_AD0SPIE3_Msk        (0x1ul << EADC_INTSRC2_AD0SPIE3_Pos)              /*!< EADC_T::INTSRC: AD0SPIE3 Mask            */

#define EADC_INTSRC2_AD0SPIE4_Pos        (4)                                               /*!< EADC_T::INTSRC: AD0SPIE4 Position        */
#define EADC_INTSRC2_AD0SPIE4_Msk        (0x1ul << EADC_INTSRC2_AD0SPIE4_Pos)              /*!< EADC_T::INTSRC: AD0SPIE4 Mask            */

#define EADC_INTSRC2_AD0SPIE5_Pos        (5)                                               /*!< EADC_T::INTSRC: AD0SPIE5 Position        */
#define EADC_INTSRC2_AD0SPIE5_Msk        (0x1ul << EADC_INTSRC2_AD0SPIE5_Pos)              /*!< EADC_T::INTSRC: AD0SPIE5 Mask            */

#define EADC_INTSRC2_AD0SPIE6_Pos        (6)                                               /*!< EADC_T::INTSRC: AD0SPIE6 Position        */
#define EADC_INTSRC2_AD0SPIE6_Msk        (0x1ul << EADC_INTSRC2_AD0SPIE6_Pos)              /*!< EADC_T::INTSRC: AD0SPIE6 Mask            */

#define EADC_INTSRC2_AD0SPIE7_Pos        (7)                                               /*!< EADC_T::INTSRC: AD0SPIE7 Position        */
#define EADC_INTSRC2_AD0SPIE7_Msk        (0x1ul << EADC_INTSRC2_AD0SPIE7_Pos)              /*!< EADC_T::INTSRC: AD0SPIE7 Mask            */

#define EADC_INTSRC2_AD1SPIE0_Pos        (8)                                               /*!< EADC_T::INTSRC: AD1SPIE0 Position        */
#define EADC_INTSRC2_AD1SPIE0_Msk        (0x1ul << EADC_INTSRC2_AD1SPIE0_Pos)              /*!< EADC_T::INTSRC: AD1SPIE0 Mask            */

#define EADC_INTSRC2_AD1SPIE1_Pos        (9)                                               /*!< EADC_T::INTSRC: AD1SPIE1 Position        */
#define EADC_INTSRC2_AD1SPIE1_Msk        (0x1ul << EADC_INTSRC2_AD1SPIE1_Pos)              /*!< EADC_T::INTSRC: AD1SPIE1 Mask            */

#define EADC_INTSRC2_AD1SPIE2_Pos        (10)                                              /*!< EADC_T::INTSRC: AD1SPIE2 Position        */
#define EADC_INTSRC2_AD1SPIE2_Msk        (0x1ul << EADC_INTSRC2_AD1SPIE2_Pos)              /*!< EADC_T::INTSRC: AD1SPIE2 Mask            */

#define EADC_INTSRC2_AD1SPIE3_Pos        (11)                                              /*!< EADC_T::INTSRC: AD1SPIE3 Position        */
#define EADC_INTSRC2_AD1SPIE3_Msk        (0x1ul << EADC_INTSRC2_AD1SPIE3_Pos)              /*!< EADC_T::INTSRC: AD1SPIE3 Mask            */

#define EADC_INTSRC2_AD1SPIE4_Pos        (12)                                              /*!< EADC_T::INTSRC: AD1SPIE4 Position        */
#define EADC_INTSRC2_AD1SPIE4_Msk        (0x1ul << EADC_INTSRC2_AD1SPIE4_Pos)              /*!< EADC_T::INTSRC: AD1SPIE4 Mask            */

#define EADC_INTSRC2_AD1SPIE5_Pos        (13)                                              /*!< EADC_T::INTSRC: AD1SPIE5 Position        */
#define EADC_INTSRC2_AD1SPIE5_Msk        (0x1ul << EADC_INTSRC2_AD1SPIE5_Pos)              /*!< EADC_T::INTSRC: AD1SPIE5 Mask            */

#define EADC_INTSRC2_AD1SPIE6_Pos        (14)                                              /*!< EADC_T::INTSRC: AD1SPIE6 Position        */
#define EADC_INTSRC2_AD1SPIE6_Msk        (0x1ul << EADC_INTSRC2_AD1SPIE6_Pos)              /*!< EADC_T::INTSRC: AD1SPIE6 Mask            */

#define EADC_INTSRC2_AD1SPIE7_Pos        (15)                                              /*!< EADC_T::INTSRC: AD1SPIE7 Position        */
#define EADC_INTSRC2_AD1SPIE7_Msk        (0x1ul << EADC_INTSRC2_AD1SPIE7_Pos)              /*!< EADC_T::INTSRC: AD1SPIE7 Mask            */

#define EADC_INTSRC3_AD0SPIE0_Pos        (0)                                               /*!< EADC_T::INTSRC: AD0SPIE0 Position        */
#define EADC_INTSRC3_AD0SPIE0_Msk        (0x1ul << EADC_INTSRC3_AD0SPIE0_Pos)              /*!< EADC_T::INTSRC: AD0SPIE0 Mask            */

#define EADC_INTSRC3_AD0SPIE1_Pos        (1)                                               /*!< EADC_T::INTSRC: AD0SPIE1 Position        */
#define EADC_INTSRC3_AD0SPIE1_Msk        (0x1ul << EADC_INTSRC3_AD0SPIE1_Pos)              /*!< EADC_T::INTSRC: AD0SPIE1 Mask            */

#define EADC_INTSRC3_AD0SPIE2_Pos        (2)                                               /*!< EADC_T::INTSRC: AD0SPIE2 Position        */
#define EADC_INTSRC3_AD0SPIE2_Msk        (0x1ul << EADC_INTSRC3_AD0SPIE2_Pos)              /*!< EADC_T::INTSRC: AD0SPIE2 Mask            */

#define EADC_INTSRC3_AD0SPIE3_Pos        (3)                                               /*!< EADC_T::INTSRC: AD0SPIE3 Position        */
#define EADC_INTSRC3_AD0SPIE3_Msk        (0x1ul << EADC_INTSRC3_AD0SPIE3_Pos)              /*!< EADC_T::INTSRC: AD0SPIE3 Mask            */

#define EADC_INTSRC3_AD0SPIE4_Pos        (4)                                               /*!< EADC_T::INTSRC: AD0SPIE4 Position        */
#define EADC_INTSRC3_AD0SPIE4_Msk        (0x1ul << EADC_INTSRC3_AD0SPIE4_Pos)              /*!< EADC_T::INTSRC: AD0SPIE4 Mask            */

#define EADC_INTSRC3_AD0SPIE5_Pos        (5)                                               /*!< EADC_T::INTSRC: AD0SPIE5 Position        */
#define EADC_INTSRC3_AD0SPIE5_Msk        (0x1ul << EADC_INTSRC3_AD0SPIE5_Pos)              /*!< EADC_T::INTSRC: AD0SPIE5 Mask            */

#define EADC_INTSRC3_AD0SPIE6_Pos        (6)                                               /*!< EADC_T::INTSRC: AD0SPIE6 Position        */
#define EADC_INTSRC3_AD0SPIE6_Msk        (0x1ul << EADC_INTSRC3_AD0SPIE6_Pos)              /*!< EADC_T::INTSRC: AD0SPIE6 Mask            */

#define EADC_INTSRC3_AD0SPIE7_Pos        (7)                                               /*!< EADC_T::INTSRC: AD0SPIE7 Position        */
#define EADC_INTSRC3_AD0SPIE7_Msk        (0x1ul << EADC_INTSRC3_AD0SPIE7_Pos)              /*!< EADC_T::INTSRC: AD0SPIE7 Mask            */

#define EADC_INTSRC3_AD1SPIE0_Pos        (8)                                               /*!< EADC_T::INTSRC: AD1SPIE0 Position        */
#define EADC_INTSRC3_AD1SPIE0_Msk        (0x1ul << EADC_INTSRC3_AD1SPIE0_Pos)              /*!< EADC_T::INTSRC: AD1SPIE0 Mask            */

#define EADC_INTSRC3_AD1SPIE1_Pos        (9)                                               /*!< EADC_T::INTSRC: AD1SPIE1 Position        */
#define EADC_INTSRC3_AD1SPIE1_Msk        (0x1ul << EADC_INTSRC3_AD1SPIE1_Pos)              /*!< EADC_T::INTSRC: AD1SPIE1 Mask            */

#define EADC_INTSRC3_AD1SPIE2_Pos        (10)                                              /*!< EADC_T::INTSRC: AD1SPIE2 Position        */
#define EADC_INTSRC3_AD1SPIE2_Msk        (0x1ul << EADC_INTSRC3_AD1SPIE2_Pos)              /*!< EADC_T::INTSRC: AD1SPIE2 Mask            */

#define EADC_INTSRC3_AD1SPIE3_Pos        (11)                                              /*!< EADC_T::INTSRC: AD1SPIE3 Position        */
#define EADC_INTSRC3_AD1SPIE3_Msk        (0x1ul << EADC_INTSRC3_AD1SPIE3_Pos)              /*!< EADC_T::INTSRC: AD1SPIE3 Mask            */

#define EADC_INTSRC3_AD1SPIE4_Pos        (12)                                              /*!< EADC_T::INTSRC: AD1SPIE4 Position        */
#define EADC_INTSRC3_AD1SPIE4_Msk        (0x1ul << EADC_INTSRC3_AD1SPIE4_Pos)              /*!< EADC_T::INTSRC: AD1SPIE4 Mask            */

#define EADC_INTSRC3_AD1SPIE5_Pos        (13)                                              /*!< EADC_T::INTSRC: AD1SPIE5 Position        */
#define EADC_INTSRC3_AD1SPIE5_Msk        (0x1ul << EADC_INTSRC3_AD1SPIE5_Pos)              /*!< EADC_T::INTSRC: AD1SPIE5 Mask            */

#define EADC_INTSRC3_AD1SPIE6_Pos        (14)                                              /*!< EADC_T::INTSRC: AD1SPIE6 Position        */
#define EADC_INTSRC3_AD1SPIE6_Msk        (0x1ul << EADC_INTSRC3_AD1SPIE6_Pos)              /*!< EADC_T::INTSRC: AD1SPIE6 Mask            */

#define EADC_INTSRC3_AD1SPIE7_Pos        (15)                                              /*!< EADC_T::INTSRC: AD1SPIE7 Position        */
#define EADC_INTSRC3_AD1SPIE7_Msk        (0x1ul << EADC_INTSRC3_AD1SPIE7_Pos)              /*!< EADC_T::INTSRC: AD1SPIE7 Mask            */

#define EADC_AD0TRGEN0_EPWM00REN_Pos     (0)                                               /*!< EADC_T::AD0TRGEN0: EPWM00REN Position     */
#define EADC_AD0TRGEN0_EPWM00REN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM00REN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM00REN Mask         */

#define EADC_AD0TRGEN0_EPWM00FEN_Pos     (1)                                               /*!< EADC_T::AD0TRGEN0: EPWM00FEN Position     */
#define EADC_AD0TRGEN0_EPWM00FEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM00FEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM00FEN Mask         */

#define EADC_AD0TRGEN0_EPWM00PEN_Pos     (2)                                               /*!< EADC_T::AD0TRGEN0: EPWM00PEN Position     */
#define EADC_AD0TRGEN0_EPWM00PEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM00PEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM00PEN Mask         */

#define EADC_AD0TRGEN0_EPWM00CEN_Pos     (3)                                               /*!< EADC_T::AD0TRGEN0: EPWM00CEN Position     */
#define EADC_AD0TRGEN0_EPWM00CEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM00CEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM00CEN Mask         */

#define EADC_AD0TRGEN0_EPWM02REN_Pos     (4)                                               /*!< EADC_T::AD0TRGEN0: EPWM02REN Position     */
#define EADC_AD0TRGEN0_EPWM02REN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM02REN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM02REN Mask         */

#define EADC_AD0TRGEN0_EPWM02FEN_Pos     (5)                                               /*!< EADC_T::AD0TRGEN0: EPWM02FEN Position     */
#define EADC_AD0TRGEN0_EPWM02FEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM02FEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM02FEN Mask         */

#define EADC_AD0TRGEN0_EPWM02PEN_Pos     (6)                                               /*!< EADC_T::AD0TRGEN0: EPWM02PEN Position     */
#define EADC_AD0TRGEN0_EPWM02PEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM02PEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM02PEN Mask         */

#define EADC_AD0TRGEN0_EPWM02CEN_Pos     (7)                                               /*!< EADC_T::AD0TRGEN0: EPWM02CEN Position     */
#define EADC_AD0TRGEN0_EPWM02CEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM02CEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM02CEN Mask         */

#define EADC_AD0TRGEN0_EPWM04REN_Pos     (8)                                               /*!< EADC_T::AD0TRGEN0: EPWM04REN Position     */
#define EADC_AD0TRGEN0_EPWM04REN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM04REN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM04REN Mask         */

#define EADC_AD0TRGEN0_EPWM04FEN_Pos     (9)                                               /*!< EADC_T::AD0TRGEN0: EPWM04FEN Position     */
#define EADC_AD0TRGEN0_EPWM04FEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM04FEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM04FEN Mask         */

#define EADC_AD0TRGEN0_EPWM04PEN_Pos     (10)                                              /*!< EADC_T::AD0TRGEN0: EPWM04PEN Position     */
#define EADC_AD0TRGEN0_EPWM04PEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM04PEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM04PEN Mask         */

#define EADC_AD0TRGEN0_EPWM04CEN_Pos     (11)                                              /*!< EADC_T::AD0TRGEN0: EPWM04CEN Position     */
#define EADC_AD0TRGEN0_EPWM04CEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM04CEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM04CEN Mask         */

#define EADC_AD0TRGEN0_EPWM10REN_Pos     (12)                                              /*!< EADC_T::AD0TRGEN0: EPWM10REN Position     */
#define EADC_AD0TRGEN0_EPWM10REN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM10REN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM10REN Mask         */

#define EADC_AD0TRGEN0_EPWM10FEN_Pos     (13)                                              /*!< EADC_T::AD0TRGEN0: EPWM10FEN Position     */
#define EADC_AD0TRGEN0_EPWM10FEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM10FEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM10FEN Mask         */

#define EADC_AD0TRGEN0_EPWM10PEN_Pos     (14)                                              /*!< EADC_T::AD0TRGEN0: EPWM10PEN Position     */
#define EADC_AD0TRGEN0_EPWM10PEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM10PEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM10PEN Mask         */

#define EADC_AD0TRGEN0_EPWM10CEN_Pos     (15)                                              /*!< EADC_T::AD0TRGEN0: EPWM10CEN Position     */
#define EADC_AD0TRGEN0_EPWM10CEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM10CEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM10CEN Mask         */

#define EADC_AD0TRGEN0_EPWM12REN_Pos     (16)                                              /*!< EADC_T::AD0TRGEN0: EPWM12REN Position     */
#define EADC_AD0TRGEN0_EPWM12REN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM12REN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM12REN Mask         */

#define EADC_AD0TRGEN0_EPWM120FEN_Pos    (17)                                              /*!< EADC_T::AD0TRGEN0: EPWM120FEN Position    */
#define EADC_AD0TRGEN0_EPWM120FEN_Msk    (0x1ul << EADC_AD0TRGEN0_EPWM120FEN_Pos)          /*!< EADC_T::AD0TRGEN0: EPWM120FEN Mask        */

#define EADC_AD0TRGEN0_EPWM12PEN_Pos     (18)                                              /*!< EADC_T::AD0TRGEN0: EPWM12PEN Position     */
#define EADC_AD0TRGEN0_EPWM12PEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM12PEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM12PEN Mask         */

#define EADC_AD0TRGEN0_EPWM12CEN_Pos     (19)                                              /*!< EADC_T::AD0TRGEN0: EPWM12CEN Position     */
#define EADC_AD0TRGEN0_EPWM12CEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM12CEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM12CEN Mask         */

#define EADC_AD0TRGEN0_EPWM14REN_Pos     (20)                                              /*!< EADC_T::AD0TRGEN0: EPWM14REN Position     */
#define EADC_AD0TRGEN0_EPWM14REN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM14REN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM14REN Mask         */

#define EADC_AD0TRGEN0_EPWM14FEN_Pos     (21)                                              /*!< EADC_T::AD0TRGEN0: EPWM14FEN Position     */
#define EADC_AD0TRGEN0_EPWM14FEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM14FEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM14FEN Mask         */

#define EADC_AD0TRGEN0_EPWM14PEN_Pos     (22)                                              /*!< EADC_T::AD0TRGEN0: EPWM14PEN Position     */
#define EADC_AD0TRGEN0_EPWM14PEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM14PEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM14PEN Mask         */

#define EADC_AD0TRGEN0_EPWM14CEN_Pos     (23)                                              /*!< EADC_T::AD0TRGEN0: EPWM14CEN Position     */
#define EADC_AD0TRGEN0_EPWM14CEN_Msk     (0x1ul << EADC_AD0TRGEN0_EPWM14CEN_Pos)           /*!< EADC_T::AD0TRGEN0: EPWM14CEN Mask         */

#define EADC_AD0TRGEN0_PWM00REN_Pos      (24)                                              /*!< EADC_T::AD0TRGEN0: PWM00REN Position      */
#define EADC_AD0TRGEN0_PWM00REN_Msk      (0x1ul << EADC_AD0TRGEN0_PWM00REN_Pos)            /*!< EADC_T::AD0TRGEN0: PWM00REN Mask          */

#define EADC_AD0TRGEN0_PWM00FEN_Pos      (25)                                              /*!< EADC_T::AD0TRGEN0: PWM00FEN Position      */
#define EADC_AD0TRGEN0_PWM00FEN_Msk      (0x1ul << EADC_AD0TRGEN0_PWM00FEN_Pos)            /*!< EADC_T::AD0TRGEN0: PWM00FEN Mask          */

#define EADC_AD0TRGEN0_PWM00PEN_Pos      (26)                                              /*!< EADC_T::AD0TRGEN0: PWM00PEN Position      */
#define EADC_AD0TRGEN0_PWM00PEN_Msk      (0x1ul << EADC_AD0TRGEN0_PWM00PEN_Pos)            /*!< EADC_T::AD0TRGEN0: PWM00PEN Mask          */

#define EADC_AD0TRGEN0_PWM00CEN_Pos      (27)                                              /*!< EADC_T::AD0TRGEN0: PWM00CEN Position      */
#define EADC_AD0TRGEN0_PWM00CEN_Msk      (0x1ul << EADC_AD0TRGEN0_PWM00CEN_Pos)            /*!< EADC_T::AD0TRGEN0: PWM00CEN Mask          */

#define EADC_AD0TRGEN0_PWM01REN_Pos      (28)                                              /*!< EADC_T::AD0TRGEN0: PWM01REN Position      */
#define EADC_AD0TRGEN0_PWM01REN_Msk      (0x1ul << EADC_AD0TRGEN0_PWM01REN_Pos)            /*!< EADC_T::AD0TRGEN0: PWM01REN Mask          */

#define EADC_AD0TRGEN0_PWM01FEN_Pos      (29)                                              /*!< EADC_T::AD0TRGEN0: PWM01FEN Position      */
#define EADC_AD0TRGEN0_PWM01FEN_Msk      (0x1ul << EADC_AD0TRGEN0_PWM01FEN_Pos)            /*!< EADC_T::AD0TRGEN0: PWM01FEN Mask          */

#define EADC_AD0TRGEN0_PWM01PEN_Pos      (30)                                              /*!< EADC_T::AD0TRGEN0: PWM01PEN Position      */
#define EADC_AD0TRGEN0_PWM01PEN_Msk      (0x1ul << EADC_AD0TRGEN0_PWM01PEN_Pos)            /*!< EADC_T::AD0TRGEN0: PWM01PEN Mask          */

#define EADC_AD0TRGEN0_PWM01CEN_Pos      (31)                                              /*!< EADC_T::AD0TRGEN0: PWM01CEN Position      */
#define EADC_AD0TRGEN0_PWM01CEN_Msk      (0x1ul << EADC_AD0TRGEN0_PWM01CEN_Pos)            /*!< EADC_T::AD0TRGEN0: PWM01CEN Mask          */

#define EADC_AD0TRGEN1_EPWM00REN_Pos     (0)                                               /*!< EADC_T::AD0TRGEN1: EPWM00REN Position     */
#define EADC_AD0TRGEN1_EPWM00REN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM00REN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM00REN Mask         */

#define EADC_AD0TRGEN1_EPWM00FEN_Pos     (1)                                               /*!< EADC_T::AD0TRGEN1: EPWM00FEN Position     */
#define EADC_AD0TRGEN1_EPWM00FEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM00FEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM00FEN Mask         */

#define EADC_AD0TRGEN1_EPWM00PEN_Pos     (2)                                               /*!< EADC_T::AD0TRGEN1: EPWM00PEN Position     */
#define EADC_AD0TRGEN1_EPWM00PEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM00PEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM00PEN Mask         */

#define EADC_AD0TRGEN1_EPWM00CEN_Pos     (3)                                               /*!< EADC_T::AD0TRGEN1: EPWM00CEN Position     */
#define EADC_AD0TRGEN1_EPWM00CEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM00CEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM00CEN Mask         */

#define EADC_AD0TRGEN1_EPWM02REN_Pos     (4)                                               /*!< EADC_T::AD0TRGEN1: EPWM02REN Position     */
#define EADC_AD0TRGEN1_EPWM02REN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM02REN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM02REN Mask         */

#define EADC_AD0TRGEN1_EPWM02FEN_Pos     (5)                                               /*!< EADC_T::AD0TRGEN1: EPWM02FEN Position     */
#define EADC_AD0TRGEN1_EPWM02FEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM02FEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM02FEN Mask         */

#define EADC_AD0TRGEN1_EPWM02PEN_Pos     (6)                                               /*!< EADC_T::AD0TRGEN1: EPWM02PEN Position     */
#define EADC_AD0TRGEN1_EPWM02PEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM02PEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM02PEN Mask         */

#define EADC_AD0TRGEN1_EPWM02CEN_Pos     (7)                                               /*!< EADC_T::AD0TRGEN1: EPWM02CEN Position     */
#define EADC_AD0TRGEN1_EPWM02CEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM02CEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM02CEN Mask         */

#define EADC_AD0TRGEN1_EPWM04REN_Pos     (8)                                               /*!< EADC_T::AD0TRGEN1: EPWM04REN Position     */
#define EADC_AD0TRGEN1_EPWM04REN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM04REN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM04REN Mask         */

#define EADC_AD0TRGEN1_EPWM04FEN_Pos     (9)                                               /*!< EADC_T::AD0TRGEN1: EPWM04FEN Position     */
#define EADC_AD0TRGEN1_EPWM04FEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM04FEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM04FEN Mask         */

#define EADC_AD0TRGEN1_EPWM04PEN_Pos     (10)                                              /*!< EADC_T::AD0TRGEN1: EPWM04PEN Position     */
#define EADC_AD0TRGEN1_EPWM04PEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM04PEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM04PEN Mask         */

#define EADC_AD0TRGEN1_EPWM04CEN_Pos     (11)                                              /*!< EADC_T::AD0TRGEN1: EPWM04CEN Position     */
#define EADC_AD0TRGEN1_EPWM04CEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM04CEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM04CEN Mask         */

#define EADC_AD0TRGEN1_EPWM10REN_Pos     (12)                                              /*!< EADC_T::AD0TRGEN1: EPWM10REN Position     */
#define EADC_AD0TRGEN1_EPWM10REN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM10REN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM10REN Mask         */

#define EADC_AD0TRGEN1_EPWM10FEN_Pos     (13)                                              /*!< EADC_T::AD0TRGEN1: EPWM10FEN Position     */
#define EADC_AD0TRGEN1_EPWM10FEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM10FEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM10FEN Mask         */

#define EADC_AD0TRGEN1_EPWM10PEN_Pos     (14)                                              /*!< EADC_T::AD0TRGEN1: EPWM10PEN Position     */
#define EADC_AD0TRGEN1_EPWM10PEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM10PEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM10PEN Mask         */

#define EADC_AD0TRGEN1_EPWM10CEN_Pos     (15)                                              /*!< EADC_T::AD0TRGEN1: EPWM10CEN Position     */
#define EADC_AD0TRGEN1_EPWM10CEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM10CEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM10CEN Mask         */

#define EADC_AD0TRGEN1_EPWM12REN_Pos     (16)                                              /*!< EADC_T::AD0TRGEN1: EPWM12REN Position     */
#define EADC_AD0TRGEN1_EPWM12REN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM12REN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM12REN Mask         */

#define EADC_AD0TRGEN1_EPWM120FEN_Pos    (17)                                              /*!< EADC_T::AD0TRGEN1: EPWM120FEN Position    */
#define EADC_AD0TRGEN1_EPWM120FEN_Msk    (0x1ul << EADC_AD0TRGEN1_EPWM120FEN_Pos)          /*!< EADC_T::AD0TRGEN1: EPWM120FEN Mask        */

#define EADC_AD0TRGEN1_EPWM12PEN_Pos     (18)                                              /*!< EADC_T::AD0TRGEN1: EPWM12PEN Position     */
#define EADC_AD0TRGEN1_EPWM12PEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM12PEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM12PEN Mask         */

#define EADC_AD0TRGEN1_EPWM12CEN_Pos     (19)                                              /*!< EADC_T::AD0TRGEN1: EPWM12CEN Position     */
#define EADC_AD0TRGEN1_EPWM12CEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM12CEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM12CEN Mask         */

#define EADC_AD0TRGEN1_EPWM14REN_Pos     (20)                                              /*!< EADC_T::AD0TRGEN1: EPWM14REN Position     */
#define EADC_AD0TRGEN1_EPWM14REN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM14REN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM14REN Mask         */

#define EADC_AD0TRGEN1_EPWM14FEN_Pos     (21)                                              /*!< EADC_T::AD0TRGEN1: EPWM14FEN Position     */
#define EADC_AD0TRGEN1_EPWM14FEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM14FEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM14FEN Mask         */

#define EADC_AD0TRGEN1_EPWM14PEN_Pos     (22)                                              /*!< EADC_T::AD0TRGEN1: EPWM14PEN Position     */
#define EADC_AD0TRGEN1_EPWM14PEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM14PEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM14PEN Mask         */

#define EADC_AD0TRGEN1_EPWM14CEN_Pos     (23)                                              /*!< EADC_T::AD0TRGEN1: EPWM14CEN Position     */
#define EADC_AD0TRGEN1_EPWM14CEN_Msk     (0x1ul << EADC_AD0TRGEN1_EPWM14CEN_Pos)           /*!< EADC_T::AD0TRGEN1: EPWM14CEN Mask         */

#define EADC_AD0TRGEN1_PWM00REN_Pos      (24)                                              /*!< EADC_T::AD0TRGEN1: PWM00REN Position      */
#define EADC_AD0TRGEN1_PWM00REN_Msk      (0x1ul << EADC_AD0TRGEN1_PWM00REN_Pos)            /*!< EADC_T::AD0TRGEN1: PWM00REN Mask          */

#define EADC_AD0TRGEN1_PWM00FEN_Pos      (25)                                              /*!< EADC_T::AD0TRGEN1: PWM00FEN Position      */
#define EADC_AD0TRGEN1_PWM00FEN_Msk      (0x1ul << EADC_AD0TRGEN1_PWM00FEN_Pos)            /*!< EADC_T::AD0TRGEN1: PWM00FEN Mask          */

#define EADC_AD0TRGEN1_PWM00PEN_Pos      (26)                                              /*!< EADC_T::AD0TRGEN1: PWM00PEN Position      */
#define EADC_AD0TRGEN1_PWM00PEN_Msk      (0x1ul << EADC_AD0TRGEN1_PWM00PEN_Pos)            /*!< EADC_T::AD0TRGEN1: PWM00PEN Mask          */

#define EADC_AD0TRGEN1_PWM00CEN_Pos      (27)                                              /*!< EADC_T::AD0TRGEN1: PWM00CEN Position      */
#define EADC_AD0TRGEN1_PWM00CEN_Msk      (0x1ul << EADC_AD0TRGEN1_PWM00CEN_Pos)            /*!< EADC_T::AD0TRGEN1: PWM00CEN Mask          */

#define EADC_AD0TRGEN1_PWM01REN_Pos      (28)                                              /*!< EADC_T::AD0TRGEN1: PWM01REN Position      */
#define EADC_AD0TRGEN1_PWM01REN_Msk      (0x1ul << EADC_AD0TRGEN1_PWM01REN_Pos)            /*!< EADC_T::AD0TRGEN1: PWM01REN Mask          */

#define EADC_AD0TRGEN1_PWM01FEN_Pos      (29)                                              /*!< EADC_T::AD0TRGEN1: PWM01FEN Position      */
#define EADC_AD0TRGEN1_PWM01FEN_Msk      (0x1ul << EADC_AD0TRGEN1_PWM01FEN_Pos)            /*!< EADC_T::AD0TRGEN1: PWM01FEN Mask          */

#define EADC_AD0TRGEN1_PWM01PEN_Pos      (30)                                              /*!< EADC_T::AD0TRGEN1: PWM01PEN Position      */
#define EADC_AD0TRGEN1_PWM01PEN_Msk      (0x1ul << EADC_AD0TRGEN1_PWM01PEN_Pos)            /*!< EADC_T::AD0TRGEN1: PWM01PEN Mask          */

#define EADC_AD0TRGEN1_PWM01CEN_Pos      (31)                                              /*!< EADC_T::AD0TRGEN1: PWM01CEN Position      */
#define EADC_AD0TRGEN1_PWM01CEN_Msk      (0x1ul << EADC_AD0TRGEN1_PWM01CEN_Pos)            /*!< EADC_T::AD0TRGEN1: PWM01CEN Mask          */

#define EADC_AD0TRGEN2_EPWM00REN_Pos     (0)                                               /*!< EADC_T::AD0TRGEN2: EPWM00REN Position     */
#define EADC_AD0TRGEN2_EPWM00REN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM00REN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM00REN Mask         */

#define EADC_AD0TRGEN2_EPWM00FEN_Pos     (1)                                               /*!< EADC_T::AD0TRGEN2: EPWM00FEN Position     */
#define EADC_AD0TRGEN2_EPWM00FEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM00FEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM00FEN Mask         */

#define EADC_AD0TRGEN2_EPWM00PEN_Pos     (2)                                               /*!< EADC_T::AD0TRGEN2: EPWM00PEN Position     */
#define EADC_AD0TRGEN2_EPWM00PEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM00PEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM00PEN Mask         */

#define EADC_AD0TRGEN2_EPWM00CEN_Pos     (3)                                               /*!< EADC_T::AD0TRGEN2: EPWM00CEN Position     */
#define EADC_AD0TRGEN2_EPWM00CEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM00CEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM00CEN Mask         */

#define EADC_AD0TRGEN2_EPWM02REN_Pos     (4)                                               /*!< EADC_T::AD0TRGEN2: EPWM02REN Position     */
#define EADC_AD0TRGEN2_EPWM02REN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM02REN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM02REN Mask         */

#define EADC_AD0TRGEN2_EPWM02FEN_Pos     (5)                                               /*!< EADC_T::AD0TRGEN2: EPWM02FEN Position     */
#define EADC_AD0TRGEN2_EPWM02FEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM02FEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM02FEN Mask         */

#define EADC_AD0TRGEN2_EPWM02PEN_Pos     (6)                                               /*!< EADC_T::AD0TRGEN2: EPWM02PEN Position     */
#define EADC_AD0TRGEN2_EPWM02PEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM02PEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM02PEN Mask         */

#define EADC_AD0TRGEN2_EPWM02CEN_Pos     (7)                                               /*!< EADC_T::AD0TRGEN2: EPWM02CEN Position     */
#define EADC_AD0TRGEN2_EPWM02CEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM02CEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM02CEN Mask         */

#define EADC_AD0TRGEN2_EPWM04REN_Pos     (8)                                               /*!< EADC_T::AD0TRGEN2: EPWM04REN Position     */
#define EADC_AD0TRGEN2_EPWM04REN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM04REN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM04REN Mask         */

#define EADC_AD0TRGEN2_EPWM04FEN_Pos     (9)                                               /*!< EADC_T::AD0TRGEN2: EPWM04FEN Position     */
#define EADC_AD0TRGEN2_EPWM04FEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM04FEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM04FEN Mask         */

#define EADC_AD0TRGEN2_EPWM04PEN_Pos     (10)                                              /*!< EADC_T::AD0TRGEN2: EPWM04PEN Position     */
#define EADC_AD0TRGEN2_EPWM04PEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM04PEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM04PEN Mask         */

#define EADC_AD0TRGEN2_EPWM04CEN_Pos     (11)                                              /*!< EADC_T::AD0TRGEN2: EPWM04CEN Position     */
#define EADC_AD0TRGEN2_EPWM04CEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM04CEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM04CEN Mask         */

#define EADC_AD0TRGEN2_EPWM10REN_Pos     (12)                                              /*!< EADC_T::AD0TRGEN2: EPWM10REN Position     */
#define EADC_AD0TRGEN2_EPWM10REN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM10REN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM10REN Mask         */

#define EADC_AD0TRGEN2_EPWM10FEN_Pos     (13)                                              /*!< EADC_T::AD0TRGEN2: EPWM10FEN Position     */
#define EADC_AD0TRGEN2_EPWM10FEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM10FEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM10FEN Mask         */

#define EADC_AD0TRGEN2_EPWM10PEN_Pos     (14)                                              /*!< EADC_T::AD0TRGEN2: EPWM10PEN Position     */
#define EADC_AD0TRGEN2_EPWM10PEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM10PEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM10PEN Mask         */

#define EADC_AD0TRGEN2_EPWM10CEN_Pos     (15)                                              /*!< EADC_T::AD0TRGEN2: EPWM10CEN Position     */
#define EADC_AD0TRGEN2_EPWM10CEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM10CEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM10CEN Mask         */

#define EADC_AD0TRGEN2_EPWM12REN_Pos     (16)                                              /*!< EADC_T::AD0TRGEN2: EPWM12REN Position     */
#define EADC_AD0TRGEN2_EPWM12REN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM12REN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM12REN Mask         */

#define EADC_AD0TRGEN2_EPWM120FEN_Pos    (17)                                              /*!< EADC_T::AD0TRGEN2: EPWM120FEN Position    */
#define EADC_AD0TRGEN2_EPWM120FEN_Msk    (0x1ul << EADC_AD0TRGEN2_EPWM120FEN_Pos)          /*!< EADC_T::AD0TRGEN2: EPWM120FEN Mask        */

#define EADC_AD0TRGEN2_EPWM12PEN_Pos     (18)                                              /*!< EADC_T::AD0TRGEN2: EPWM12PEN Position     */
#define EADC_AD0TRGEN2_EPWM12PEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM12PEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM12PEN Mask         */

#define EADC_AD0TRGEN2_EPWM12CEN_Pos     (19)                                              /*!< EADC_T::AD0TRGEN2: EPWM12CEN Position     */
#define EADC_AD0TRGEN2_EPWM12CEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM12CEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM12CEN Mask         */

#define EADC_AD0TRGEN2_EPWM14REN_Pos     (20)                                              /*!< EADC_T::AD0TRGEN2: EPWM14REN Position     */
#define EADC_AD0TRGEN2_EPWM14REN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM14REN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM14REN Mask         */

#define EADC_AD0TRGEN2_EPWM14FEN_Pos     (21)                                              /*!< EADC_T::AD0TRGEN2: EPWM14FEN Position     */
#define EADC_AD0TRGEN2_EPWM14FEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM14FEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM14FEN Mask         */

#define EADC_AD0TRGEN2_EPWM14PEN_Pos     (22)                                              /*!< EADC_T::AD0TRGEN2: EPWM14PEN Position     */
#define EADC_AD0TRGEN2_EPWM14PEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM14PEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM14PEN Mask         */

#define EADC_AD0TRGEN2_EPWM14CEN_Pos     (23)                                              /*!< EADC_T::AD0TRGEN2: EPWM14CEN Position     */
#define EADC_AD0TRGEN2_EPWM14CEN_Msk     (0x1ul << EADC_AD0TRGEN2_EPWM14CEN_Pos)           /*!< EADC_T::AD0TRGEN2: EPWM14CEN Mask         */

#define EADC_AD0TRGEN2_PWM00REN_Pos      (24)                                              /*!< EADC_T::AD0TRGEN2: PWM00REN Position      */
#define EADC_AD0TRGEN2_PWM00REN_Msk      (0x1ul << EADC_AD0TRGEN2_PWM00REN_Pos)            /*!< EADC_T::AD0TRGEN2: PWM00REN Mask          */

#define EADC_AD0TRGEN2_PWM00FEN_Pos      (25)                                              /*!< EADC_T::AD0TRGEN2: PWM00FEN Position      */
#define EADC_AD0TRGEN2_PWM00FEN_Msk      (0x1ul << EADC_AD0TRGEN2_PWM00FEN_Pos)            /*!< EADC_T::AD0TRGEN2: PWM00FEN Mask          */

#define EADC_AD0TRGEN2_PWM00PEN_Pos      (26)                                              /*!< EADC_T::AD0TRGEN2: PWM00PEN Position      */
#define EADC_AD0TRGEN2_PWM00PEN_Msk      (0x1ul << EADC_AD0TRGEN2_PWM00PEN_Pos)            /*!< EADC_T::AD0TRGEN2: PWM00PEN Mask          */

#define EADC_AD0TRGEN2_PWM00CEN_Pos      (27)                                              /*!< EADC_T::AD0TRGEN2: PWM00CEN Position      */
#define EADC_AD0TRGEN2_PWM00CEN_Msk      (0x1ul << EADC_AD0TRGEN2_PWM00CEN_Pos)            /*!< EADC_T::AD0TRGEN2: PWM00CEN Mask          */

#define EADC_AD0TRGEN2_PWM01REN_Pos      (28)                                              /*!< EADC_T::AD0TRGEN2: PWM01REN Position      */
#define EADC_AD0TRGEN2_PWM01REN_Msk      (0x1ul << EADC_AD0TRGEN2_PWM01REN_Pos)            /*!< EADC_T::AD0TRGEN2: PWM01REN Mask          */

#define EADC_AD0TRGEN2_PWM01FEN_Pos      (29)                                              /*!< EADC_T::AD0TRGEN2: PWM01FEN Position      */
#define EADC_AD0TRGEN2_PWM01FEN_Msk      (0x1ul << EADC_AD0TRGEN2_PWM01FEN_Pos)            /*!< EADC_T::AD0TRGEN2: PWM01FEN Mask          */

#define EADC_AD0TRGEN2_PWM01PEN_Pos      (30)                                              /*!< EADC_T::AD0TRGEN2: PWM01PEN Position      */
#define EADC_AD0TRGEN2_PWM01PEN_Msk      (0x1ul << EADC_AD0TRGEN2_PWM01PEN_Pos)            /*!< EADC_T::AD0TRGEN2: PWM01PEN Mask          */

#define EADC_AD0TRGEN2_PWM01CEN_Pos      (31)                                              /*!< EADC_T::AD0TRGEN2: PWM01CEN Position      */
#define EADC_AD0TRGEN2_PWM01CEN_Msk      (0x1ul << EADC_AD0TRGEN2_PWM01CEN_Pos)            /*!< EADC_T::AD0TRGEN2: PWM01CEN Mask          */

#define EADC_AD0TRGEN3_EPWM00REN_Pos     (0)                                               /*!< EADC_T::AD0TRGEN3: EPWM00REN Position     */
#define EADC_AD0TRGEN3_EPWM00REN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM00REN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM00REN Mask         */

#define EADC_AD0TRGEN3_EPWM00FEN_Pos     (1)                                               /*!< EADC_T::AD0TRGEN3: EPWM00FEN Position     */
#define EADC_AD0TRGEN3_EPWM00FEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM00FEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM00FEN Mask         */

#define EADC_AD0TRGEN3_EPWM00PEN_Pos     (2)                                               /*!< EADC_T::AD0TRGEN3: EPWM00PEN Position     */
#define EADC_AD0TRGEN3_EPWM00PEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM00PEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM00PEN Mask         */

#define EADC_AD0TRGEN3_EPWM00CEN_Pos     (3)                                               /*!< EADC_T::AD0TRGEN3: EPWM00CEN Position     */
#define EADC_AD0TRGEN3_EPWM00CEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM00CEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM00CEN Mask         */

#define EADC_AD0TRGEN3_EPWM02REN_Pos     (4)                                               /*!< EADC_T::AD0TRGEN3: EPWM02REN Position     */
#define EADC_AD0TRGEN3_EPWM02REN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM02REN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM02REN Mask         */

#define EADC_AD0TRGEN3_EPWM02FEN_Pos     (5)                                               /*!< EADC_T::AD0TRGEN3: EPWM02FEN Position     */
#define EADC_AD0TRGEN3_EPWM02FEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM02FEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM02FEN Mask         */

#define EADC_AD0TRGEN3_EPWM02PEN_Pos     (6)                                               /*!< EADC_T::AD0TRGEN3: EPWM02PEN Position     */
#define EADC_AD0TRGEN3_EPWM02PEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM02PEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM02PEN Mask         */

#define EADC_AD0TRGEN3_EPWM02CEN_Pos     (7)                                               /*!< EADC_T::AD0TRGEN3: EPWM02CEN Position     */
#define EADC_AD0TRGEN3_EPWM02CEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM02CEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM02CEN Mask         */

#define EADC_AD0TRGEN3_EPWM04REN_Pos     (8)                                               /*!< EADC_T::AD0TRGEN3: EPWM04REN Position     */
#define EADC_AD0TRGEN3_EPWM04REN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM04REN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM04REN Mask         */

#define EADC_AD0TRGEN3_EPWM04FEN_Pos     (9)                                               /*!< EADC_T::AD0TRGEN3: EPWM04FEN Position     */
#define EADC_AD0TRGEN3_EPWM04FEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM04FEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM04FEN Mask         */

#define EADC_AD0TRGEN3_EPWM04PEN_Pos     (10)                                              /*!< EADC_T::AD0TRGEN3: EPWM04PEN Position     */
#define EADC_AD0TRGEN3_EPWM04PEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM04PEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM04PEN Mask         */

#define EADC_AD0TRGEN3_EPWM04CEN_Pos     (11)                                              /*!< EADC_T::AD0TRGEN3: EPWM04CEN Position     */
#define EADC_AD0TRGEN3_EPWM04CEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM04CEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM04CEN Mask         */

#define EADC_AD0TRGEN3_EPWM10REN_Pos     (12)                                              /*!< EADC_T::AD0TRGEN3: EPWM10REN Position     */
#define EADC_AD0TRGEN3_EPWM10REN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM10REN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM10REN Mask         */

#define EADC_AD0TRGEN3_EPWM10FEN_Pos     (13)                                              /*!< EADC_T::AD0TRGEN3: EPWM10FEN Position     */
#define EADC_AD0TRGEN3_EPWM10FEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM10FEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM10FEN Mask         */

#define EADC_AD0TRGEN3_EPWM10PEN_Pos     (14)                                              /*!< EADC_T::AD0TRGEN3: EPWM10PEN Position     */
#define EADC_AD0TRGEN3_EPWM10PEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM10PEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM10PEN Mask         */

#define EADC_AD0TRGEN3_EPWM10CEN_Pos     (15)                                              /*!< EADC_T::AD0TRGEN3: EPWM10CEN Position     */
#define EADC_AD0TRGEN3_EPWM10CEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM10CEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM10CEN Mask         */

#define EADC_AD0TRGEN3_EPWM12REN_Pos     (16)                                              /*!< EADC_T::AD0TRGEN3: EPWM12REN Position     */
#define EADC_AD0TRGEN3_EPWM12REN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM12REN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM12REN Mask         */

#define EADC_AD0TRGEN3_EPWM120FEN_Pos    (17)                                              /*!< EADC_T::AD0TRGEN3: EPWM120FEN Position    */
#define EADC_AD0TRGEN3_EPWM120FEN_Msk    (0x1ul << EADC_AD0TRGEN3_EPWM120FEN_Pos)          /*!< EADC_T::AD0TRGEN3: EPWM120FEN Mask        */

#define EADC_AD0TRGEN3_EPWM12PEN_Pos     (18)                                              /*!< EADC_T::AD0TRGEN3: EPWM12PEN Position     */
#define EADC_AD0TRGEN3_EPWM12PEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM12PEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM12PEN Mask         */

#define EADC_AD0TRGEN3_EPWM12CEN_Pos     (19)                                              /*!< EADC_T::AD0TRGEN3: EPWM12CEN Position     */
#define EADC_AD0TRGEN3_EPWM12CEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM12CEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM12CEN Mask         */

#define EADC_AD0TRGEN3_EPWM14REN_Pos     (20)                                              /*!< EADC_T::AD0TRGEN3: EPWM14REN Position     */
#define EADC_AD0TRGEN3_EPWM14REN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM14REN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM14REN Mask         */

#define EADC_AD0TRGEN3_EPWM14FEN_Pos     (21)                                              /*!< EADC_T::AD0TRGEN3: EPWM14FEN Position     */
#define EADC_AD0TRGEN3_EPWM14FEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM14FEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM14FEN Mask         */

#define EADC_AD0TRGEN3_EPWM14PEN_Pos     (22)                                              /*!< EADC_T::AD0TRGEN3: EPWM14PEN Position     */
#define EADC_AD0TRGEN3_EPWM14PEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM14PEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM14PEN Mask         */

#define EADC_AD0TRGEN3_EPWM14CEN_Pos     (23)                                              /*!< EADC_T::AD0TRGEN3: EPWM14CEN Position     */
#define EADC_AD0TRGEN3_EPWM14CEN_Msk     (0x1ul << EADC_AD0TRGEN3_EPWM14CEN_Pos)           /*!< EADC_T::AD0TRGEN3: EPWM14CEN Mask         */

#define EADC_AD0TRGEN3_PWM00REN_Pos      (24)                                              /*!< EADC_T::AD0TRGEN3: PWM00REN Position      */
#define EADC_AD0TRGEN3_PWM00REN_Msk      (0x1ul << EADC_AD0TRGEN3_PWM00REN_Pos)            /*!< EADC_T::AD0TRGEN3: PWM00REN Mask          */

#define EADC_AD0TRGEN3_PWM00FEN_Pos      (25)                                              /*!< EADC_T::AD0TRGEN3: PWM00FEN Position      */
#define EADC_AD0TRGEN3_PWM00FEN_Msk      (0x1ul << EADC_AD0TRGEN3_PWM00FEN_Pos)            /*!< EADC_T::AD0TRGEN3: PWM00FEN Mask          */

#define EADC_AD0TRGEN3_PWM00PEN_Pos      (26)                                              /*!< EADC_T::AD0TRGEN3: PWM00PEN Position      */
#define EADC_AD0TRGEN3_PWM00PEN_Msk      (0x1ul << EADC_AD0TRGEN3_PWM00PEN_Pos)            /*!< EADC_T::AD0TRGEN3: PWM00PEN Mask          */

#define EADC_AD0TRGEN3_PWM00CEN_Pos      (27)                                              /*!< EADC_T::AD0TRGEN3: PWM00CEN Position      */
#define EADC_AD0TRGEN3_PWM00CEN_Msk      (0x1ul << EADC_AD0TRGEN3_PWM00CEN_Pos)            /*!< EADC_T::AD0TRGEN3: PWM00CEN Mask          */

#define EADC_AD0TRGEN3_PWM01REN_Pos      (28)                                              /*!< EADC_T::AD0TRGEN3: PWM01REN Position      */
#define EADC_AD0TRGEN3_PWM01REN_Msk      (0x1ul << EADC_AD0TRGEN3_PWM01REN_Pos)            /*!< EADC_T::AD0TRGEN3: PWM01REN Mask          */

#define EADC_AD0TRGEN3_PWM01FEN_Pos      (29)                                              /*!< EADC_T::AD0TRGEN3: PWM01FEN Position      */
#define EADC_AD0TRGEN3_PWM01FEN_Msk      (0x1ul << EADC_AD0TRGEN3_PWM01FEN_Pos)            /*!< EADC_T::AD0TRGEN3: PWM01FEN Mask          */

#define EADC_AD0TRGEN3_PWM01PEN_Pos      (30)                                              /*!< EADC_T::AD0TRGEN3: PWM01PEN Position      */
#define EADC_AD0TRGEN3_PWM01PEN_Msk      (0x1ul << EADC_AD0TRGEN3_PWM01PEN_Pos)            /*!< EADC_T::AD0TRGEN3: PWM01PEN Mask          */

#define EADC_AD0TRGEN3_PWM01CEN_Pos      (31)                                              /*!< EADC_T::AD0TRGEN3: PWM01CEN Position      */
#define EADC_AD0TRGEN3_PWM01CEN_Msk      (0x1ul << EADC_AD0TRGEN3_PWM01CEN_Pos)            /*!< EADC_T::AD0TRGEN3: PWM01CEN Mask          */

#define EADC_AD1TRGEN0_EPWM00REN_Pos     (0)                                               /*!< EADC_T::AD1TRGEN0: EPWM00REN Position     */
#define EADC_AD1TRGEN0_EPWM00REN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM00REN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM00REN Mask         */

#define EADC_AD1TRGEN0_EPWM00FEN_Pos     (1)                                               /*!< EADC_T::AD1TRGEN0: EPWM00FEN Position     */
#define EADC_AD1TRGEN0_EPWM00FEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM00FEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM00FEN Mask         */

#define EADC_AD1TRGEN0_EPWM00PEN_Pos     (2)                                               /*!< EADC_T::AD1TRGEN0: EPWM00PEN Position     */
#define EADC_AD1TRGEN0_EPWM00PEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM00PEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM00PEN Mask         */

#define EADC_AD1TRGEN0_EPWM00CEN_Pos     (3)                                               /*!< EADC_T::AD1TRGEN0: EPWM00CEN Position     */
#define EADC_AD1TRGEN0_EPWM00CEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM00CEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM00CEN Mask         */

#define EADC_AD1TRGEN0_EPWM02REN_Pos     (4)                                               /*!< EADC_T::AD1TRGEN0: EPWM02REN Position     */
#define EADC_AD1TRGEN0_EPWM02REN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM02REN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM02REN Mask         */

#define EADC_AD1TRGEN0_EPWM02FEN_Pos     (5)                                               /*!< EADC_T::AD1TRGEN0: EPWM02FEN Position     */
#define EADC_AD1TRGEN0_EPWM02FEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM02FEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM02FEN Mask         */

#define EADC_AD1TRGEN0_EPWM02PEN_Pos     (6)                                               /*!< EADC_T::AD1TRGEN0: EPWM02PEN Position     */
#define EADC_AD1TRGEN0_EPWM02PEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM02PEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM02PEN Mask         */

#define EADC_AD1TRGEN0_EPWM02CEN_Pos     (7)                                               /*!< EADC_T::AD1TRGEN0: EPWM02CEN Position     */
#define EADC_AD1TRGEN0_EPWM02CEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM02CEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM02CEN Mask         */

#define EADC_AD1TRGEN0_EPWM04REN_Pos     (8)                                               /*!< EADC_T::AD1TRGEN0: EPWM04REN Position     */
#define EADC_AD1TRGEN0_EPWM04REN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM04REN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM04REN Mask         */

#define EADC_AD1TRGEN0_EPWM04FEN_Pos     (9)                                               /*!< EADC_T::AD1TRGEN0: EPWM04FEN Position     */
#define EADC_AD1TRGEN0_EPWM04FEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM04FEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM04FEN Mask         */

#define EADC_AD1TRGEN0_EPWM04PEN_Pos     (10)                                              /*!< EADC_T::AD1TRGEN0: EPWM04PEN Position     */
#define EADC_AD1TRGEN0_EPWM04PEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM04PEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM04PEN Mask         */

#define EADC_AD1TRGEN0_EPWM04CEN_Pos     (11)                                              /*!< EADC_T::AD1TRGEN0: EPWM04CEN Position     */
#define EADC_AD1TRGEN0_EPWM04CEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM04CEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM04CEN Mask         */

#define EADC_AD1TRGEN0_EPWM10REN_Pos     (12)                                              /*!< EADC_T::AD1TRGEN0: EPWM10REN Position     */
#define EADC_AD1TRGEN0_EPWM10REN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM10REN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM10REN Mask         */

#define EADC_AD1TRGEN0_EPWM10FEN_Pos     (13)                                              /*!< EADC_T::AD1TRGEN0: EPWM10FEN Position     */
#define EADC_AD1TRGEN0_EPWM10FEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM10FEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM10FEN Mask         */

#define EADC_AD1TRGEN0_EPWM10PEN_Pos     (14)                                              /*!< EADC_T::AD1TRGEN0: EPWM10PEN Position     */
#define EADC_AD1TRGEN0_EPWM10PEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM10PEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM10PEN Mask         */

#define EADC_AD1TRGEN0_EPWM10CEN_Pos     (15)                                              /*!< EADC_T::AD1TRGEN0: EPWM10CEN Position     */
#define EADC_AD1TRGEN0_EPWM10CEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM10CEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM10CEN Mask         */

#define EADC_AD1TRGEN0_EPWM12REN_Pos     (16)                                              /*!< EADC_T::AD1TRGEN0: EPWM12REN Position     */
#define EADC_AD1TRGEN0_EPWM12REN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM12REN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM12REN Mask         */

#define EADC_AD1TRGEN0_EPWM120FEN_Pos    (17)                                              /*!< EADC_T::AD1TRGEN0: EPWM120FEN Position    */
#define EADC_AD1TRGEN0_EPWM120FEN_Msk    (0x1ul << EADC_AD1TRGEN0_EPWM120FEN_Pos)          /*!< EADC_T::AD1TRGEN0: EPWM120FEN Mask        */

#define EADC_AD1TRGEN0_EPWM12PEN_Pos     (18)                                              /*!< EADC_T::AD1TRGEN0: EPWM12PEN Position     */
#define EADC_AD1TRGEN0_EPWM12PEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM12PEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM12PEN Mask         */

#define EADC_AD1TRGEN0_EPWM12CEN_Pos     (19)                                              /*!< EADC_T::AD1TRGEN0: EPWM12CEN Position     */
#define EADC_AD1TRGEN0_EPWM12CEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM12CEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM12CEN Mask         */

#define EADC_AD1TRGEN0_EPWM14REN_Pos     (20)                                              /*!< EADC_T::AD1TRGEN0: EPWM14REN Position     */
#define EADC_AD1TRGEN0_EPWM14REN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM14REN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM14REN Mask         */

#define EADC_AD1TRGEN0_EPWM14FEN_Pos     (21)                                              /*!< EADC_T::AD1TRGEN0: EPWM14FEN Position     */
#define EADC_AD1TRGEN0_EPWM14FEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM14FEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM14FEN Mask         */

#define EADC_AD1TRGEN0_EPWM14PEN_Pos     (22)                                              /*!< EADC_T::AD1TRGEN0: EPWM14PEN Position     */
#define EADC_AD1TRGEN0_EPWM14PEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM14PEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM14PEN Mask         */

#define EADC_AD1TRGEN0_EPWM14CEN_Pos     (23)                                              /*!< EADC_T::AD1TRGEN0: EPWM14CEN Position     */
#define EADC_AD1TRGEN0_EPWM14CEN_Msk     (0x1ul << EADC_AD1TRGEN0_EPWM14CEN_Pos)           /*!< EADC_T::AD1TRGEN0: EPWM14CEN Mask         */

#define EADC_AD1TRGEN0_PWM00REN_Pos      (24)                                              /*!< EADC_T::AD1TRGEN0: PWM00REN Position      */
#define EADC_AD1TRGEN0_PWM00REN_Msk      (0x1ul << EADC_AD1TRGEN0_PWM00REN_Pos)            /*!< EADC_T::AD1TRGEN0: PWM00REN Mask          */

#define EADC_AD1TRGEN0_PWM00FEN_Pos      (25)                                              /*!< EADC_T::AD1TRGEN0: PWM00FEN Position      */
#define EADC_AD1TRGEN0_PWM00FEN_Msk      (0x1ul << EADC_AD1TRGEN0_PWM00FEN_Pos)            /*!< EADC_T::AD1TRGEN0: PWM00FEN Mask          */

#define EADC_AD1TRGEN0_PWM00PEN_Pos      (26)                                              /*!< EADC_T::AD1TRGEN0: PWM00PEN Position      */
#define EADC_AD1TRGEN0_PWM00PEN_Msk      (0x1ul << EADC_AD1TRGEN0_PWM00PEN_Pos)            /*!< EADC_T::AD1TRGEN0: PWM00PEN Mask          */

#define EADC_AD1TRGEN0_PWM00CEN_Pos      (27)                                              /*!< EADC_T::AD1TRGEN0: PWM00CEN Position      */
#define EADC_AD1TRGEN0_PWM00CEN_Msk      (0x1ul << EADC_AD1TRGEN0_PWM00CEN_Pos)            /*!< EADC_T::AD1TRGEN0: PWM00CEN Mask          */

#define EADC_AD1TRGEN0_PWM01REN_Pos      (28)                                              /*!< EADC_T::AD1TRGEN0: PWM01REN Position      */
#define EADC_AD1TRGEN0_PWM01REN_Msk      (0x1ul << EADC_AD1TRGEN0_PWM01REN_Pos)            /*!< EADC_T::AD1TRGEN0: PWM01REN Mask          */

#define EADC_AD1TRGEN0_PWM01FEN_Pos      (29)                                              /*!< EADC_T::AD1TRGEN0: PWM01FEN Position      */
#define EADC_AD1TRGEN0_PWM01FEN_Msk      (0x1ul << EADC_AD1TRGEN0_PWM01FEN_Pos)            /*!< EADC_T::AD1TRGEN0: PWM01FEN Mask          */

#define EADC_AD1TRGEN0_PWM01PEN_Pos      (30)                                              /*!< EADC_T::AD1TRGEN0: PWM01PEN Position      */
#define EADC_AD1TRGEN0_PWM01PEN_Msk      (0x1ul << EADC_AD1TRGEN0_PWM01PEN_Pos)            /*!< EADC_T::AD1TRGEN0: PWM01PEN Mask          */

#define EADC_AD1TRGEN0_PWM01CEN_Pos      (31)                                              /*!< EADC_T::AD1TRGEN0: PWM01CEN Position      */
#define EADC_AD1TRGEN0_PWM01CEN_Msk      (0x1ul << EADC_AD1TRGEN0_PWM01CEN_Pos)            /*!< EADC_T::AD1TRGEN0: PWM01CEN Mask          */

#define EADC_AD1TRGEN1_EPWM00REN_Pos     (0)                                               /*!< EADC_T::AD1TRGEN1: EPWM00REN Position     */
#define EADC_AD1TRGEN1_EPWM00REN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM00REN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM00REN Mask         */

#define EADC_AD1TRGEN1_EPWM00FEN_Pos     (1)                                               /*!< EADC_T::AD1TRGEN1: EPWM00FEN Position     */
#define EADC_AD1TRGEN1_EPWM00FEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM00FEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM00FEN Mask         */

#define EADC_AD1TRGEN1_EPWM00PEN_Pos     (2)                                               /*!< EADC_T::AD1TRGEN1: EPWM00PEN Position     */
#define EADC_AD1TRGEN1_EPWM00PEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM00PEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM00PEN Mask         */

#define EADC_AD1TRGEN1_EPWM00CEN_Pos     (3)                                               /*!< EADC_T::AD1TRGEN1: EPWM00CEN Position     */
#define EADC_AD1TRGEN1_EPWM00CEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM00CEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM00CEN Mask         */

#define EADC_AD1TRGEN1_EPWM02REN_Pos     (4)                                               /*!< EADC_T::AD1TRGEN1: EPWM02REN Position     */
#define EADC_AD1TRGEN1_EPWM02REN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM02REN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM02REN Mask         */

#define EADC_AD1TRGEN1_EPWM02FEN_Pos     (5)                                               /*!< EADC_T::AD1TRGEN1: EPWM02FEN Position     */
#define EADC_AD1TRGEN1_EPWM02FEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM02FEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM02FEN Mask         */

#define EADC_AD1TRGEN1_EPWM02PEN_Pos     (6)                                               /*!< EADC_T::AD1TRGEN1: EPWM02PEN Position     */
#define EADC_AD1TRGEN1_EPWM02PEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM02PEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM02PEN Mask         */

#define EADC_AD1TRGEN1_EPWM02CEN_Pos     (7)                                               /*!< EADC_T::AD1TRGEN1: EPWM02CEN Position     */
#define EADC_AD1TRGEN1_EPWM02CEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM02CEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM02CEN Mask         */

#define EADC_AD1TRGEN1_EPWM04REN_Pos     (8)                                               /*!< EADC_T::AD1TRGEN1: EPWM04REN Position     */
#define EADC_AD1TRGEN1_EPWM04REN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM04REN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM04REN Mask         */

#define EADC_AD1TRGEN1_EPWM04FEN_Pos     (9)                                               /*!< EADC_T::AD1TRGEN1: EPWM04FEN Position     */
#define EADC_AD1TRGEN1_EPWM04FEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM04FEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM04FEN Mask         */

#define EADC_AD1TRGEN1_EPWM04PEN_Pos     (10)                                              /*!< EADC_T::AD1TRGEN1: EPWM04PEN Position     */
#define EADC_AD1TRGEN1_EPWM04PEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM04PEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM04PEN Mask         */

#define EADC_AD1TRGEN1_EPWM04CEN_Pos     (11)                                              /*!< EADC_T::AD1TRGEN1: EPWM04CEN Position     */
#define EADC_AD1TRGEN1_EPWM04CEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM04CEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM04CEN Mask         */

#define EADC_AD1TRGEN1_EPWM10REN_Pos     (12)                                              /*!< EADC_T::AD1TRGEN1: EPWM10REN Position     */
#define EADC_AD1TRGEN1_EPWM10REN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM10REN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM10REN Mask         */

#define EADC_AD1TRGEN1_EPWM10FEN_Pos     (13)                                              /*!< EADC_T::AD1TRGEN1: EPWM10FEN Position     */
#define EADC_AD1TRGEN1_EPWM10FEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM10FEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM10FEN Mask         */

#define EADC_AD1TRGEN1_EPWM10PEN_Pos     (14)                                              /*!< EADC_T::AD1TRGEN1: EPWM10PEN Position     */
#define EADC_AD1TRGEN1_EPWM10PEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM10PEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM10PEN Mask         */

#define EADC_AD1TRGEN1_EPWM10CEN_Pos     (15)                                              /*!< EADC_T::AD1TRGEN1: EPWM10CEN Position     */
#define EADC_AD1TRGEN1_EPWM10CEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM10CEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM10CEN Mask         */

#define EADC_AD1TRGEN1_EPWM12REN_Pos     (16)                                              /*!< EADC_T::AD1TRGEN1: EPWM12REN Position     */
#define EADC_AD1TRGEN1_EPWM12REN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM12REN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM12REN Mask         */

#define EADC_AD1TRGEN1_EPWM120FEN_Pos    (17)                                              /*!< EADC_T::AD1TRGEN1: EPWM120FEN Position    */
#define EADC_AD1TRGEN1_EPWM120FEN_Msk    (0x1ul << EADC_AD1TRGEN1_EPWM120FEN_Pos)          /*!< EADC_T::AD1TRGEN1: EPWM120FEN Mask        */

#define EADC_AD1TRGEN1_EPWM12PEN_Pos     (18)                                              /*!< EADC_T::AD1TRGEN1: EPWM12PEN Position     */
#define EADC_AD1TRGEN1_EPWM12PEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM12PEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM12PEN Mask         */

#define EADC_AD1TRGEN1_EPWM12CEN_Pos     (19)                                              /*!< EADC_T::AD1TRGEN1: EPWM12CEN Position     */
#define EADC_AD1TRGEN1_EPWM12CEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM12CEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM12CEN Mask         */

#define EADC_AD1TRGEN1_EPWM14REN_Pos     (20)                                              /*!< EADC_T::AD1TRGEN1: EPWM14REN Position     */
#define EADC_AD1TRGEN1_EPWM14REN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM14REN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM14REN Mask         */

#define EADC_AD1TRGEN1_EPWM14FEN_Pos     (21)                                              /*!< EADC_T::AD1TRGEN1: EPWM14FEN Position     */
#define EADC_AD1TRGEN1_EPWM14FEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM14FEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM14FEN Mask         */

#define EADC_AD1TRGEN1_EPWM14PEN_Pos     (22)                                              /*!< EADC_T::AD1TRGEN1: EPWM14PEN Position     */
#define EADC_AD1TRGEN1_EPWM14PEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM14PEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM14PEN Mask         */

#define EADC_AD1TRGEN1_EPWM14CEN_Pos     (23)                                              /*!< EADC_T::AD1TRGEN1: EPWM14CEN Position     */
#define EADC_AD1TRGEN1_EPWM14CEN_Msk     (0x1ul << EADC_AD1TRGEN1_EPWM14CEN_Pos)           /*!< EADC_T::AD1TRGEN1: EPWM14CEN Mask         */

#define EADC_AD1TRGEN1_PWM00REN_Pos      (24)                                              /*!< EADC_T::AD1TRGEN1: PWM00REN Position      */
#define EADC_AD1TRGEN1_PWM00REN_Msk      (0x1ul << EADC_AD1TRGEN1_PWM00REN_Pos)            /*!< EADC_T::AD1TRGEN1: PWM00REN Mask          */

#define EADC_AD1TRGEN1_PWM00FEN_Pos      (25)                                              /*!< EADC_T::AD1TRGEN1: PWM00FEN Position      */
#define EADC_AD1TRGEN1_PWM00FEN_Msk      (0x1ul << EADC_AD1TRGEN1_PWM00FEN_Pos)            /*!< EADC_T::AD1TRGEN1: PWM00FEN Mask          */

#define EADC_AD1TRGEN1_PWM00PEN_Pos      (26)                                              /*!< EADC_T::AD1TRGEN1: PWM00PEN Position      */
#define EADC_AD1TRGEN1_PWM00PEN_Msk      (0x1ul << EADC_AD1TRGEN1_PWM00PEN_Pos)            /*!< EADC_T::AD1TRGEN1: PWM00PEN Mask          */

#define EADC_AD1TRGEN1_PWM00CEN_Pos      (27)                                              /*!< EADC_T::AD1TRGEN1: PWM00CEN Position      */
#define EADC_AD1TRGEN1_PWM00CEN_Msk      (0x1ul << EADC_AD1TRGEN1_PWM00CEN_Pos)            /*!< EADC_T::AD1TRGEN1: PWM00CEN Mask          */

#define EADC_AD1TRGEN1_PWM01REN_Pos      (28)                                              /*!< EADC_T::AD1TRGEN1: PWM01REN Position      */
#define EADC_AD1TRGEN1_PWM01REN_Msk      (0x1ul << EADC_AD1TRGEN1_PWM01REN_Pos)            /*!< EADC_T::AD1TRGEN1: PWM01REN Mask          */

#define EADC_AD1TRGEN1_PWM01FEN_Pos      (29)                                              /*!< EADC_T::AD1TRGEN1: PWM01FEN Position      */
#define EADC_AD1TRGEN1_PWM01FEN_Msk      (0x1ul << EADC_AD1TRGEN1_PWM01FEN_Pos)            /*!< EADC_T::AD1TRGEN1: PWM01FEN Mask          */

#define EADC_AD1TRGEN1_PWM01PEN_Pos      (30)                                              /*!< EADC_T::AD1TRGEN1: PWM01PEN Position      */
#define EADC_AD1TRGEN1_PWM01PEN_Msk      (0x1ul << EADC_AD1TRGEN1_PWM01PEN_Pos)            /*!< EADC_T::AD1TRGEN1: PWM01PEN Mask          */

#define EADC_AD1TRGEN1_PWM01CEN_Pos      (31)                                              /*!< EADC_T::AD1TRGEN1: PWM01CEN Position      */
#define EADC_AD1TRGEN1_PWM01CEN_Msk      (0x1ul << EADC_AD1TRGEN1_PWM01CEN_Pos)            /*!< EADC_T::AD1TRGEN1: PWM01CEN Mask          */

#define EADC_AD1TRGEN2_EPWM00REN_Pos     (0)                                               /*!< EADC_T::AD1TRGEN2: EPWM00REN Position     */
#define EADC_AD1TRGEN2_EPWM00REN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM00REN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM00REN Mask         */

#define EADC_AD1TRGEN2_EPWM00FEN_Pos     (1)                                               /*!< EADC_T::AD1TRGEN2: EPWM00FEN Position     */
#define EADC_AD1TRGEN2_EPWM00FEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM00FEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM00FEN Mask         */

#define EADC_AD1TRGEN2_EPWM00PEN_Pos     (2)                                               /*!< EADC_T::AD1TRGEN2: EPWM00PEN Position     */
#define EADC_AD1TRGEN2_EPWM00PEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM00PEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM00PEN Mask         */

#define EADC_AD1TRGEN2_EPWM00CEN_Pos     (3)                                               /*!< EADC_T::AD1TRGEN2: EPWM00CEN Position     */
#define EADC_AD1TRGEN2_EPWM00CEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM00CEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM00CEN Mask         */

#define EADC_AD1TRGEN2_EPWM02REN_Pos     (4)                                               /*!< EADC_T::AD1TRGEN2: EPWM02REN Position     */
#define EADC_AD1TRGEN2_EPWM02REN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM02REN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM02REN Mask         */

#define EADC_AD1TRGEN2_EPWM02FEN_Pos     (5)                                               /*!< EADC_T::AD1TRGEN2: EPWM02FEN Position     */
#define EADC_AD1TRGEN2_EPWM02FEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM02FEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM02FEN Mask         */

#define EADC_AD1TRGEN2_EPWM02PEN_Pos     (6)                                               /*!< EADC_T::AD1TRGEN2: EPWM02PEN Position     */
#define EADC_AD1TRGEN2_EPWM02PEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM02PEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM02PEN Mask         */

#define EADC_AD1TRGEN2_EPWM02CEN_Pos     (7)                                               /*!< EADC_T::AD1TRGEN2: EPWM02CEN Position     */
#define EADC_AD1TRGEN2_EPWM02CEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM02CEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM02CEN Mask         */

#define EADC_AD1TRGEN2_EPWM04REN_Pos     (8)                                               /*!< EADC_T::AD1TRGEN2: EPWM04REN Position     */
#define EADC_AD1TRGEN2_EPWM04REN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM04REN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM04REN Mask         */

#define EADC_AD1TRGEN2_EPWM04FEN_Pos     (9)                                               /*!< EADC_T::AD1TRGEN2: EPWM04FEN Position     */
#define EADC_AD1TRGEN2_EPWM04FEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM04FEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM04FEN Mask         */

#define EADC_AD1TRGEN2_EPWM04PEN_Pos     (10)                                              /*!< EADC_T::AD1TRGEN2: EPWM04PEN Position     */
#define EADC_AD1TRGEN2_EPWM04PEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM04PEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM04PEN Mask         */

#define EADC_AD1TRGEN2_EPWM04CEN_Pos     (11)                                              /*!< EADC_T::AD1TRGEN2: EPWM04CEN Position     */
#define EADC_AD1TRGEN2_EPWM04CEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM04CEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM04CEN Mask         */

#define EADC_AD1TRGEN2_EPWM10REN_Pos     (12)                                              /*!< EADC_T::AD1TRGEN2: EPWM10REN Position     */
#define EADC_AD1TRGEN2_EPWM10REN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM10REN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM10REN Mask         */

#define EADC_AD1TRGEN2_EPWM10FEN_Pos     (13)                                              /*!< EADC_T::AD1TRGEN2: EPWM10FEN Position     */
#define EADC_AD1TRGEN2_EPWM10FEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM10FEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM10FEN Mask         */

#define EADC_AD1TRGEN2_EPWM10PEN_Pos     (14)                                              /*!< EADC_T::AD1TRGEN2: EPWM10PEN Position     */
#define EADC_AD1TRGEN2_EPWM10PEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM10PEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM10PEN Mask         */

#define EADC_AD1TRGEN2_EPWM10CEN_Pos     (15)                                              /*!< EADC_T::AD1TRGEN2: EPWM10CEN Position     */
#define EADC_AD1TRGEN2_EPWM10CEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM10CEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM10CEN Mask         */

#define EADC_AD1TRGEN2_EPWM12REN_Pos     (16)                                              /*!< EADC_T::AD1TRGEN2: EPWM12REN Position     */
#define EADC_AD1TRGEN2_EPWM12REN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM12REN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM12REN Mask         */

#define EADC_AD1TRGEN2_EPWM120FEN_Pos    (17)                                              /*!< EADC_T::AD1TRGEN2: EPWM120FEN Position    */
#define EADC_AD1TRGEN2_EPWM120FEN_Msk    (0x1ul << EADC_AD1TRGEN2_EPWM120FEN_Pos)          /*!< EADC_T::AD1TRGEN2: EPWM120FEN Mask        */

#define EADC_AD1TRGEN2_EPWM12PEN_Pos     (18)                                              /*!< EADC_T::AD1TRGEN2: EPWM12PEN Position     */
#define EADC_AD1TRGEN2_EPWM12PEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM12PEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM12PEN Mask         */

#define EADC_AD1TRGEN2_EPWM12CEN_Pos     (19)                                              /*!< EADC_T::AD1TRGEN2: EPWM12CEN Position     */
#define EADC_AD1TRGEN2_EPWM12CEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM12CEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM12CEN Mask         */

#define EADC_AD1TRGEN2_EPWM14REN_Pos     (20)                                              /*!< EADC_T::AD1TRGEN2: EPWM14REN Position     */
#define EADC_AD1TRGEN2_EPWM14REN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM14REN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM14REN Mask         */

#define EADC_AD1TRGEN2_EPWM14FEN_Pos     (21)                                              /*!< EADC_T::AD1TRGEN2: EPWM14FEN Position     */
#define EADC_AD1TRGEN2_EPWM14FEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM14FEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM14FEN Mask         */

#define EADC_AD1TRGEN2_EPWM14PEN_Pos     (22)                                              /*!< EADC_T::AD1TRGEN2: EPWM14PEN Position     */
#define EADC_AD1TRGEN2_EPWM14PEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM14PEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM14PEN Mask         */

#define EADC_AD1TRGEN2_EPWM14CEN_Pos     (23)                                              /*!< EADC_T::AD1TRGEN2: EPWM14CEN Position     */
#define EADC_AD1TRGEN2_EPWM14CEN_Msk     (0x1ul << EADC_AD1TRGEN2_EPWM14CEN_Pos)           /*!< EADC_T::AD1TRGEN2: EPWM14CEN Mask         */

#define EADC_AD1TRGEN2_PWM00REN_Pos      (24)                                              /*!< EADC_T::AD1TRGEN2: PWM00REN Position      */
#define EADC_AD1TRGEN2_PWM00REN_Msk      (0x1ul << EADC_AD1TRGEN2_PWM00REN_Pos)            /*!< EADC_T::AD1TRGEN2: PWM00REN Mask          */

#define EADC_AD1TRGEN2_PWM00FEN_Pos      (25)                                              /*!< EADC_T::AD1TRGEN2: PWM00FEN Position      */
#define EADC_AD1TRGEN2_PWM00FEN_Msk      (0x1ul << EADC_AD1TRGEN2_PWM00FEN_Pos)            /*!< EADC_T::AD1TRGEN2: PWM00FEN Mask          */

#define EADC_AD1TRGEN2_PWM00PEN_Pos      (26)                                              /*!< EADC_T::AD1TRGEN2: PWM00PEN Position      */
#define EADC_AD1TRGEN2_PWM00PEN_Msk      (0x1ul << EADC_AD1TRGEN2_PWM00PEN_Pos)            /*!< EADC_T::AD1TRGEN2: PWM00PEN Mask          */

#define EADC_AD1TRGEN2_PWM00CEN_Pos      (27)                                              /*!< EADC_T::AD1TRGEN2: PWM00CEN Position      */
#define EADC_AD1TRGEN2_PWM00CEN_Msk      (0x1ul << EADC_AD1TRGEN2_PWM00CEN_Pos)            /*!< EADC_T::AD1TRGEN2: PWM00CEN Mask          */

#define EADC_AD1TRGEN2_PWM01REN_Pos      (28)                                              /*!< EADC_T::AD1TRGEN2: PWM01REN Position      */
#define EADC_AD1TRGEN2_PWM01REN_Msk      (0x1ul << EADC_AD1TRGEN2_PWM01REN_Pos)            /*!< EADC_T::AD1TRGEN2: PWM01REN Mask          */

#define EADC_AD1TRGEN2_PWM01FEN_Pos      (29)                                              /*!< EADC_T::AD1TRGEN2: PWM01FEN Position      */
#define EADC_AD1TRGEN2_PWM01FEN_Msk      (0x1ul << EADC_AD1TRGEN2_PWM01FEN_Pos)            /*!< EADC_T::AD1TRGEN2: PWM01FEN Mask          */

#define EADC_AD1TRGEN2_PWM01PEN_Pos      (30)                                              /*!< EADC_T::AD1TRGEN2: PWM01PEN Position      */
#define EADC_AD1TRGEN2_PWM01PEN_Msk      (0x1ul << EADC_AD1TRGEN2_PWM01PEN_Pos)            /*!< EADC_T::AD1TRGEN2: PWM01PEN Mask          */

#define EADC_AD1TRGEN2_PWM01CEN_Pos      (31)                                              /*!< EADC_T::AD1TRGEN2: PWM01CEN Position      */
#define EADC_AD1TRGEN2_PWM01CEN_Msk      (0x1ul << EADC_AD1TRGEN2_PWM01CEN_Pos)            /*!< EADC_T::AD1TRGEN2: PWM01CEN Mask          */

#define EADC_AD1TRGEN3_EPWM00REN_Pos     (0)                                               /*!< EADC_T::AD1TRGEN3: EPWM00REN Position     */
#define EADC_AD1TRGEN3_EPWM00REN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM00REN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM00REN Mask         */

#define EADC_AD1TRGEN3_EPWM00FEN_Pos     (1)                                               /*!< EADC_T::AD1TRGEN3: EPWM00FEN Position     */
#define EADC_AD1TRGEN3_EPWM00FEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM00FEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM00FEN Mask         */

#define EADC_AD1TRGEN3_EPWM00PEN_Pos     (2)                                               /*!< EADC_T::AD1TRGEN3: EPWM00PEN Position     */
#define EADC_AD1TRGEN3_EPWM00PEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM00PEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM00PEN Mask         */

#define EADC_AD1TRGEN3_EPWM00CEN_Pos     (3)                                               /*!< EADC_T::AD1TRGEN3: EPWM00CEN Position     */
#define EADC_AD1TRGEN3_EPWM00CEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM00CEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM00CEN Mask         */

#define EADC_AD1TRGEN3_EPWM02REN_Pos     (4)                                               /*!< EADC_T::AD1TRGEN3: EPWM02REN Position     */
#define EADC_AD1TRGEN3_EPWM02REN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM02REN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM02REN Mask         */

#define EADC_AD1TRGEN3_EPWM02FEN_Pos     (5)                                               /*!< EADC_T::AD1TRGEN3: EPWM02FEN Position     */
#define EADC_AD1TRGEN3_EPWM02FEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM02FEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM02FEN Mask         */

#define EADC_AD1TRGEN3_EPWM02PEN_Pos     (6)                                               /*!< EADC_T::AD1TRGEN3: EPWM02PEN Position     */
#define EADC_AD1TRGEN3_EPWM02PEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM02PEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM02PEN Mask         */

#define EADC_AD1TRGEN3_EPWM02CEN_Pos     (7)                                               /*!< EADC_T::AD1TRGEN3: EPWM02CEN Position     */
#define EADC_AD1TRGEN3_EPWM02CEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM02CEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM02CEN Mask         */

#define EADC_AD1TRGEN3_EPWM04REN_Pos     (8)                                               /*!< EADC_T::AD1TRGEN3: EPWM04REN Position     */
#define EADC_AD1TRGEN3_EPWM04REN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM04REN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM04REN Mask         */

#define EADC_AD1TRGEN3_EPWM04FEN_Pos     (9)                                               /*!< EADC_T::AD1TRGEN3: EPWM04FEN Position     */
#define EADC_AD1TRGEN3_EPWM04FEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM04FEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM04FEN Mask         */

#define EADC_AD1TRGEN3_EPWM04PEN_Pos     (10)                                              /*!< EADC_T::AD1TRGEN3: EPWM04PEN Position     */
#define EADC_AD1TRGEN3_EPWM04PEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM04PEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM04PEN Mask         */

#define EADC_AD1TRGEN3_EPWM04CEN_Pos     (11)                                              /*!< EADC_T::AD1TRGEN3: EPWM04CEN Position     */
#define EADC_AD1TRGEN3_EPWM04CEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM04CEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM04CEN Mask         */

#define EADC_AD1TRGEN3_EPWM10REN_Pos     (12)                                              /*!< EADC_T::AD1TRGEN3: EPWM10REN Position     */
#define EADC_AD1TRGEN3_EPWM10REN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM10REN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM10REN Mask         */

#define EADC_AD1TRGEN3_EPWM10FEN_Pos     (13)                                              /*!< EADC_T::AD1TRGEN3: EPWM10FEN Position     */
#define EADC_AD1TRGEN3_EPWM10FEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM10FEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM10FEN Mask         */

#define EADC_AD1TRGEN3_EPWM10PEN_Pos     (14)                                              /*!< EADC_T::AD1TRGEN3: EPWM10PEN Position     */
#define EADC_AD1TRGEN3_EPWM10PEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM10PEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM10PEN Mask         */

#define EADC_AD1TRGEN3_EPWM10CEN_Pos     (15)                                              /*!< EADC_T::AD1TRGEN3: EPWM10CEN Position     */
#define EADC_AD1TRGEN3_EPWM10CEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM10CEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM10CEN Mask         */

#define EADC_AD1TRGEN3_EPWM12REN_Pos     (16)                                              /*!< EADC_T::AD1TRGEN3: EPWM12REN Position     */
#define EADC_AD1TRGEN3_EPWM12REN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM12REN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM12REN Mask         */

#define EADC_AD1TRGEN3_EPWM120FEN_Pos    (17)                                              /*!< EADC_T::AD1TRGEN3: EPWM120FEN Position    */
#define EADC_AD1TRGEN3_EPWM120FEN_Msk    (0x1ul << EADC_AD1TRGEN3_EPWM120FEN_Pos)          /*!< EADC_T::AD1TRGEN3: EPWM120FEN Mask        */

#define EADC_AD1TRGEN3_EPWM12PEN_Pos     (18)                                              /*!< EADC_T::AD1TRGEN3: EPWM12PEN Position     */
#define EADC_AD1TRGEN3_EPWM12PEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM12PEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM12PEN Mask         */

#define EADC_AD1TRGEN3_EPWM12CEN_Pos     (19)                                              /*!< EADC_T::AD1TRGEN3: EPWM12CEN Position     */
#define EADC_AD1TRGEN3_EPWM12CEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM12CEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM12CEN Mask         */

#define EADC_AD1TRGEN3_EPWM14REN_Pos     (20)                                              /*!< EADC_T::AD1TRGEN3: EPWM14REN Position     */
#define EADC_AD1TRGEN3_EPWM14REN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM14REN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM14REN Mask         */

#define EADC_AD1TRGEN3_EPWM14FEN_Pos     (21)                                              /*!< EADC_T::AD1TRGEN3: EPWM14FEN Position     */
#define EADC_AD1TRGEN3_EPWM14FEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM14FEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM14FEN Mask         */

#define EADC_AD1TRGEN3_EPWM14PEN_Pos     (22)                                              /*!< EADC_T::AD1TRGEN3: EPWM14PEN Position     */
#define EADC_AD1TRGEN3_EPWM14PEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM14PEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM14PEN Mask         */

#define EADC_AD1TRGEN3_EPWM14CEN_Pos     (23)                                              /*!< EADC_T::AD1TRGEN3: EPWM14CEN Position     */
#define EADC_AD1TRGEN3_EPWM14CEN_Msk     (0x1ul << EADC_AD1TRGEN3_EPWM14CEN_Pos)           /*!< EADC_T::AD1TRGEN3: EPWM14CEN Mask         */

#define EADC_AD1TRGEN3_PWM00REN_Pos      (24)                                              /*!< EADC_T::AD1TRGEN3: PWM00REN Position      */
#define EADC_AD1TRGEN3_PWM00REN_Msk      (0x1ul << EADC_AD1TRGEN3_PWM00REN_Pos)            /*!< EADC_T::AD1TRGEN3: PWM00REN Mask          */

#define EADC_AD1TRGEN3_PWM00FEN_Pos      (25)                                              /*!< EADC_T::AD1TRGEN3: PWM00FEN Position      */
#define EADC_AD1TRGEN3_PWM00FEN_Msk      (0x1ul << EADC_AD1TRGEN3_PWM00FEN_Pos)            /*!< EADC_T::AD1TRGEN3: PWM00FEN Mask          */

#define EADC_AD1TRGEN3_PWM00PEN_Pos      (26)                                              /*!< EADC_T::AD1TRGEN3: PWM00PEN Position      */
#define EADC_AD1TRGEN3_PWM00PEN_Msk      (0x1ul << EADC_AD1TRGEN3_PWM00PEN_Pos)            /*!< EADC_T::AD1TRGEN3: PWM00PEN Mask          */

#define EADC_AD1TRGEN3_PWM00CEN_Pos      (27)                                              /*!< EADC_T::AD1TRGEN3: PWM00CEN Position      */
#define EADC_AD1TRGEN3_PWM00CEN_Msk      (0x1ul << EADC_AD1TRGEN3_PWM00CEN_Pos)            /*!< EADC_T::AD1TRGEN3: PWM00CEN Mask          */

#define EADC_AD1TRGEN3_PWM01REN_Pos      (28)                                              /*!< EADC_T::AD1TRGEN3: PWM01REN Position      */
#define EADC_AD1TRGEN3_PWM01REN_Msk      (0x1ul << EADC_AD1TRGEN3_PWM01REN_Pos)            /*!< EADC_T::AD1TRGEN3: PWM01REN Mask          */

#define EADC_AD1TRGEN3_PWM01FEN_Pos      (29)                                              /*!< EADC_T::AD1TRGEN3: PWM01FEN Position      */
#define EADC_AD1TRGEN3_PWM01FEN_Msk      (0x1ul << EADC_AD1TRGEN3_PWM01FEN_Pos)            /*!< EADC_T::AD1TRGEN3: PWM01FEN Mask          */

#define EADC_AD1TRGEN3_PWM01PEN_Pos      (30)                                              /*!< EADC_T::AD1TRGEN3: PWM01PEN Position      */
#define EADC_AD1TRGEN3_PWM01PEN_Msk      (0x1ul << EADC_AD1TRGEN3_PWM01PEN_Pos)            /*!< EADC_T::AD1TRGEN3: PWM01PEN Mask          */

#define EADC_AD1TRGEN3_PWM01CEN_Pos      (31)                                              /*!< EADC_T::AD1TRGEN3: PWM01CEN Position      */
#define EADC_AD1TRGEN3_PWM01CEN_Msk      (0x1ul << EADC_AD1TRGEN3_PWM01CEN_Pos)            /*!< EADC_T::AD1TRGEN3: PWM01CEN Mask          */

/**@}*/ /* EADC_CONST */
/**@}*/ /* end of EADC register group */


/*---------------------- External Bus Interface Controller -------------------------*/
/**
    @addtogroup EBI External Bus Interface Controller(EBI)
    Memory Mapped Structure for EBI Controller
@{ */

typedef struct {


    /**
     * CTL
     * ===================================================================================================
     * Offset: 0x00  External Bus Interface General Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[8:10]  |MCLKDIV   |External Output Clock Divider
     * |        |          |The frequency of EBI output clock is controlled by MCLKDIV as below:
     * |        |          |000 = HCLK/1.
     * |        |          |001 = HCLK/2.
     * |        |          |010 = HCLK/4.
     * |        |          |011 = HCLK/8.
     * |        |          |100 = HCLK/16.
     * |        |          |101 = HCLK/32.
     * |        |          |11x = Default.
     * |        |          |Note: Default value of output clock is HCLK/1
     * |[24:27] |CRYPTOEN  |Encrypt/Decrypt Function Enable Control (For 4 Individual Chip Select)
     * |        |          |0 = Encrypt/Decrypt function Disabled.
     * |        |          |1 = Encrypt/Decrypt function Enabled.
     * |[28:31] |CSPOLINV  |Reverse Chip Select
     * |        |          |The original design Chip Select is active low nCS.
     * |        |          |"Chip Select Active High" can be specified by customers-Bit[28+n] is for nCS[n], where n=0~3.
     * |        |          |0 = nCS (chip select active low).
     * |        |          |1 = CS (chip select active high).
    */
    __IO uint32_t CTL;

    /**
     * TCTL
     * ===================================================================================================
     * Offset: 0x04 - 0x10  External Bus Interface Bank0~3 Timing Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:2]   |TALE      |Bank Expand Time Of ALE
     * |        |          |The ALE width (tALE) to latch the address can be controlled by TALE.
     * |        |          |tALE = (TALE+1)*MCLK.
     * |[3:7]   |TACC      |EBI Bank Data Access Time
     * |        |          |TACC define data access time (tACC).
     * |        |          |tACC = (TACC +1) * MCLK.
     * |[8:10]  |TAHD      |EBI Bank Data Access Hold Time
     * |        |          |TAHD define data access hold time (tAHD).
     * |        |          |tAHD = (TAHD +1) * MCLK.
     * |[12:15] |W2X       |Bank Idle State Cycle After Write
     * |        |          |When write action is finish, idle state is inserted and nCS[0] return to high if W2X is not zero.
     * |        |          |Idle state cycle = (W2X*MCLK).
     * |        |          |0 = reserved.
     * |[16:19] |R2W       |Bank Idle State Cycle Between Read-Write
     * |        |          |When read action is finish and next action is going to write, idle state is inserted and nCS[0] return to high if R2W is not zero.
     * |        |          |Idle state cycle = (R2W*MCLK).
     * |        |          |0 = reserved.
     * |[24:27] |R2R       |Bank Idle State Cycle Between Read-Read
     * |        |          |When read action is finish and next action is going to read, idle state is inserted and nCS[0] return to high if R2R is not zero.
     * |        |          |Idle state cycle = (R2R*MCLK).
     * |        |          |0 = reserved.
     * |[28]    |CSEN      |EBI Bank Enable Control
     * |        |          |This bit is the functional enable bit for EBI.
     * |        |          |0 = EBI function Disabled.
     * |        |          |1 = EBI function Enabled.
     * |[29]    |DW16      |EBI Bank Data Width 16-Bit
     * |        |          |This bit defines if the data bus is 8-bit or 16-bit.
     * |        |          |0 = EBI data width is 8-bit.
     * |        |          |1 = EBI data width is 16-bit.
     * |[30]    |SEPEN     |EBI Bank Address/Data Bus Separating Enable Control
     * |        |          |0 = Address/Data Bus Separating Disabled.
     * |        |          |1 = Address/Data Bus Separating Enabled.
    */
    __IO uint32_t TCTL[4];

    /**
     * KEY0
     * ===================================================================================================
     * Offset: 0x14  External Bus Interface Crypto Key Word 0
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY0      |Crypto Key Word 0 (key[31:0]).
    */
    __IO uint32_t KEY0;

    /**
     * KEY1
     * ===================================================================================================
     * Offset: 0x18  External Bus Interface Crypto Key Word 1
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |Crypto Key Word 1 (key[63:32]).
    */
    __IO uint32_t KEY1;

    /**
     * KEY2
     * ===================================================================================================
     * Offset: 0x1C  External Bus Interface Crypto Key Word 2
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |Crypto Key Word 2 (key[95:64]).
    */
    __IO uint32_t KEY2;

    /**
     * KEY3
     * ===================================================================================================
     * Offset: 0x20  External Bus Interface Crypto Key Word 3
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |KEY       |Crypto Key Word 3 (key[127:96]).
    */
    __IO uint32_t KEY3;

} EBI_T;

/**
    @addtogroup EBI_CONST EBI Bit Field Definition
    Constant Definitions for EBI Controller
@{ */

#define EBI_CTL_MCLKDIV_Pos              (8)                                               /*!< EBI_T::CTL: MCLKDIV Position              */
#define EBI_CTL_MCLKDIV_Msk              (0x7ul << EBI_CTL_MCLKDIV_Pos)                    /*!< EBI_T::CTL: MCLKDIV Mask                  */

#define EBI_CTL_CRYPTOEN_Pos             (24)                                              /*!< EBI_T::CTL: CRYPTOEN Position             */
#define EBI_CTL_CRYPTOEN_Msk             (0xful << EBI_CTL_CRYPTOEN_Pos)                   /*!< EBI_T::CTL: CRYPTOEN Mask                 */

#define EBI_CTL_CSPOLINV_Pos             (28)                                              /*!< EBI_T::CTL: CSPOLINV Position             */
#define EBI_CTL_CSPOLINV_Msk             (0xful << EBI_CTL_CSPOLINV_Pos)                   /*!< EBI_T::CTL: CSPOLINV Mask                 */

#define EBI_TCTL_TALE_Pos                (0)                                               /*!< EBI_T::TCTL: TALE Position                */
#define EBI_TCTL_TALE_Msk                (0x7ul << EBI_TCTL_TALE_Pos)                      /*!< EBI_T::TCTL: TALE Mask                    */

#define EBI_TCTL_TACC_Pos                (3)                                               /*!< EBI_T::TCTL: TACC Position                */
#define EBI_TCTL_TACC_Msk                (0x1ful << EBI_TCTL_TACC_Pos)                     /*!< EBI_T::TCTL: TACC Mask                    */

#define EBI_TCTL_TAHD_Pos                (8)                                               /*!< EBI_T::TCTL: TAHD Position                */
#define EBI_TCTL_TAHD_Msk                (0x7ul << EBI_TCTL_TAHD_Pos)                      /*!< EBI_T::TCTL: TAHD Mask                    */

#define EBI_TCTL_W2X_Pos                 (12)                                              /*!< EBI_T::TCTL: W2X Position                 */
#define EBI_TCTL_W2X_Msk                 (0xful << EBI_TCTL_W2X_Pos)                       /*!< EBI_T::TCTL: W2X Mask                     */

#define EBI_TCTL_R2W_Pos                 (16)                                              /*!< EBI_T::TCTL: R2W Position                 */
#define EBI_TCTL_R2W_Msk                 (0xful << EBI_TCTL_R2W_Pos)                       /*!< EBI_T::TCTL: R2W Mask                     */

#define EBI_TCTL_R2R_Pos                 (24)                                              /*!< EBI_T::TCTL: R2R Position                 */
#define EBI_TCTL_R2R_Msk                 (0xful << EBI_TCTL_R2R_Pos)                       /*!< EBI_T::TCTL: R2R Mask                     */

#define EBI_TCTL_CSEN_Pos                (28)                                              /*!< EBI_T::TCTL: CSEN Position                */
#define EBI_TCTL_CSEN_Msk                (0x1ul << EBI_TCTL_CSEN_Pos)                      /*!< EBI_T::TCTL: CSEN Mask                    */

#define EBI_TCTL_DW16_Pos                (29)                                              /*!< EBI_T::TCTL: DW16 Position                */
#define EBI_TCTL_DW16_Msk                (0x1ul << EBI_TCTL_DW16_Pos)                      /*!< EBI_T::TCTL: DW16 Mask                    */

#define EBI_TCTL_SEPEN_Pos               (30)                                              /*!< EBI_T::TCTL: SEPEN Position               */
#define EBI_TCTL_SEPEN_Msk               (0x1ul << EBI_TCTL_SEPEN_Pos)                     /*!< EBI_T::TCTL: SEPEN Mask                   */

#define EBI_KEY0_KEY_Pos                 (0)                                               /*!< EBI_T::KEY0: KEY Position                 */
#define EBI_KEY0_KEY_Msk                 (0xfffffffful << EBI_KEY0_KEY_Pos)                /*!< EBI_T::KEY0: KEY Mask                     */

#define EBI_KEY1_KEY_Pos                 (0)                                               /*!< EBI_T::KEY1: KEY Position                 */
#define EBI_KEY1_KEY_Msk                 (0xfffffffful << EBI_KEY1_KEY_Pos)                /*!< EBI_T::KEY1: KEY Mask                     */

#define EBI_KEY2_KEY_Pos                 (0)                                               /*!< EBI_T::KEY2: KEY Position                 */
#define EBI_KEY2_KEY_Msk                 (0xfffffffful << EBI_KEY2_KEY_Pos)                /*!< EBI_T::KEY2: KEY Mask                     */

#define EBI_KEY3_KEY_Pos                 (0)                                               /*!< EBI_T::KEY3: KEY Position                 */
#define EBI_KEY3_KEY_Msk                 (0xfffffffful << EBI_KEY3_KEY_Pos)                /*!< EBI_T::KEY3: KEY Mask                     */

/**@}*/ /* EBI_CONST */
/**@}*/ /* end of EBI register group */


/*---------------------- Ethernet MAC Controller -------------------------*/
/**
    @addtogroup EMAC Ethernet MAC Controller(EMAC)
    Memory Mapped Structure for EMAC Controller
@{ */

typedef struct {


    /**
     * CAMCTL
     * ===================================================================================================
     * Offset: 0x00  CAM Comparison Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |AUP       |Accept Unicast Packet
     * |        |          |The AUP controls the unicast packet reception.
     * |        |          |If AUP is enabled, EMAC receives all incoming packet its destination MAC address is a unicast address.
     * |        |          |0 = EMAC receives packet depends on the CAM comparison result.
     * |        |          |1 = EMAC receives all unicast packets.
     * |[1]     |AMP       |Accept Multicast Packet
     * |        |          |The AMP controls the multicast packet reception.
     * |        |          |If AMP is enabled, EMAC receives all incoming packet its destination MAC address is a multicast address.
     * |        |          |0 = EMAC receives packet depends on the CAM comparison result.
     * |        |          |1 = EMAC receives all multicast packets.
     * |[2]     |ABP       |Accept Broadcast Packet
     * |        |          |The ABP controls the broadcast packet reception.
     * |        |          |If ABP is enabled, EMAC receives all incoming packet its destination MAC address is a broadcast address.
     * |        |          |0 = EMAC receives packet depends on the CAM comparison result.
     * |        |          |1 = EMAC receives all broadcast packets.
     * |[3]     |COMPEN    |Complement CAM Comparison Enable
     * |        |          |The COMPEN controls the complement of the CAM comparison result.
     * |        |          |If the CMPEN and COMPEN are both enabled, the incoming packet with specific destination MAC address configured in CAM entry will be dropped.
     * |        |          |And the incoming packet with destination MAC address does not configured in any CAM entry will be received.
     * |        |          |0 = The CAM comparison result does not complement.
     * |        |          |1 = The CAM comparison result complemented.
     * |[4]     |CMPEN     |CAM Compare Enable
     * |        |          |The CMPEN controls the enable of CAM comparison function for destination MAC address recognition.
     * |        |          |If software wants to receive a packet with specific destination MAC address, configures the MAC address into CAM 12~0, then enables that CAM entry and set CMPEN to 1.
     * |        |          |0 = CAM comparison function for destination MAC address recognition disabled.
     * |        |          |1 = CAM comparison function for destination MAC address recognition enabled.
    */
    __IO uint32_t CAMCTL;

    /**
     * CAMEN
     * ===================================================================================================
     * Offset: 0x04  CAM Enable Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |CAMxEN    |CAM Entry X Enable Control
     * |        |          |The CAMxEN controls the validation of CAM entry x.
     * |        |          |The CAM entry 13, 14 and 15 are for PAUSE control frame transmission.
     * |        |          |If software wants to transmit a PAUSE control frame out to network, the enable bits of these three CAM entries all must be enabled first.
     * |        |          |0 = CAM entry x Disabled.
     * |        |          |1 = CAM entry x Enabled.
    */
    __IO uint32_t CAMEN;

    /**
     * CAM0M
     * ===================================================================================================
     * Offset: 0x08  CAM0 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM0M;

    /**
     * CAM0L
     * ===================================================================================================
     * Offset: 0x0C  CAM0 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM0L;

    /**
     * CAM1M
     * ===================================================================================================
     * Offset: 0x10  CAM1 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM1M;

    /**
     * CAM1L
     * ===================================================================================================
     * Offset: 0x14  CAM1 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM1L;

    /**
     * CAM2M
     * ===================================================================================================
     * Offset: 0x18  CAM2 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM2M;

    /**
     * CAM2L
     * ===================================================================================================
     * Offset: 0x1C  CAM2 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM2L;

    /**
     * CAM3M
     * ===================================================================================================
     * Offset: 0x20  CAM3 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM3M;

    /**
     * CAM3L
     * ===================================================================================================
     * Offset: 0x24  CAM3 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM3L;

    /**
     * CAM4M
     * ===================================================================================================
     * Offset: 0x28  CAM4 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM4M;

    /**
     * CAM4L
     * ===================================================================================================
     * Offset: 0x2C  CAM4 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM4L;

    /**
     * CAM5M
     * ===================================================================================================
     * Offset: 0x30  CAM5 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM5M;

    /**
     * CAM5L
     * ===================================================================================================
     * Offset: 0x34  CAM5 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM5L;

    /**
     * CAM6M
     * ===================================================================================================
     * Offset: 0x38  CAM6 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM6M;

    /**
     * CAM6L
     * ===================================================================================================
     * Offset: 0x3C  CAM6 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM6L;

    /**
     * CAM7M
     * ===================================================================================================
     * Offset: 0x40  CAM7 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM7M;

    /**
     * CAM7L
     * ===================================================================================================
     * Offset: 0x44  CAM7 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM7L;

    /**
     * CAM8M
     * ===================================================================================================
     * Offset: 0x48  CAM8 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM8M;

    /**
     * CAM8L
     * ===================================================================================================
     * Offset: 0x4C  CAM8 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM8L;

    /**
     * CAM9M
     * ===================================================================================================
     * Offset: 0x50  CAM9 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM9M;

    /**
     * CAM9L
     * ===================================================================================================
     * Offset: 0x54  CAM9 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM9L;

    /**
     * CAM10M
     * ===================================================================================================
     * Offset: 0x58  CAM10 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM10M;

    /**
     * CAM10L
     * ===================================================================================================
     * Offset: 0x5C  CAM10 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM10L;

    /**
     * CAM11M
     * ===================================================================================================
     * Offset: 0x60  CAM11 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM11M;

    /**
     * CAM11L
     * ===================================================================================================
     * Offset: 0x64  CAM11 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM11L;

    /**
     * CAM12M
     * ===================================================================================================
     * Offset: 0x68  CAM12 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM12M;

    /**
     * CAM12L
     * ===================================================================================================
     * Offset: 0x6C  CAM12 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM12L;

    /**
     * CAM13M
     * ===================================================================================================
     * Offset: 0x70  CAM13 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM13M;

    /**
     * CAM13L
     * ===================================================================================================
     * Offset: 0x74  CAM13 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM13L;

    /**
     * CAM14M
     * ===================================================================================================
     * Offset: 0x78  CAM14 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |MACADDR2  |MAC Address Byte 2
     * |[8:15]  |MACADDR3  |MAC Address Byte 3
     * |[16:23] |MACADDR4  |MAC Address Byte 4
     * |[24:31] |MACADDR5  |MAC Address Byte 5
     * |        |          |The CAMxM keeps the bit 47~16 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM14M;

    /**
     * CAM14L
     * ===================================================================================================
     * Offset: 0x7C  CAM14 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[16:23] |MACADDR0  |MAC Address Byte 0
     * |[24:31] |MACADDR1  |MAC Address Byte 1
     * |        |          |The CAMxL keeps the bit 15~0 of MAC address.
     * |        |          |The x can be the 0~14.
     * |        |          |The register pair {EMAC_CAMxMSB, EMAC_CAMxLSB} represents a CAM entry and keeps a MAC address.
     * |        |          |For example, if the MAC address 00-50-BA-33-BA-44 kept in CAM entry 1, the register EMAC_CAM1M is 0x0050_BA33 and EMAC_CAM1L is 0xBA44_0000.
    */
    __IO uint32_t CAM14L;

    /**
     * CAM15MSB
     * ===================================================================================================
     * Offset: 0x80  CAM15 Most Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |OPCODE    |OP Code Field of PAUSE Control Frame
     * |        |          |In the PAUSE control frame, an op code field defined and is 0x0001.
     * |[16:31] |LENGTH    |LENGTH Field of PAUSE Control Frame
     * |        |          |In the PAUSE control frame, a LENGTH field defined and is 0x8808.
    */
    __IO uint32_t CAM15MSB;

    /**
     * CAM15LSB
     * ===================================================================================================
     * Offset: 0x84  CAM15 Least Significant Word Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[24:31] |OPERAND   |Pause Parameter
     * |        |          |In the PAUSE control frame, an OPERAND field defined and controls how much time the destination Ethernet MAC Controller paused.
     * |        |          |The unit of the OPERAND is a slot time, the 512 bits time.
    */
    __IO uint32_t CAM15LSB;

    /**
     * TXDSA
     * ===================================================================================================
     * Offset: 0x88  Transmit Descriptor Link List Start Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |TXDSA     |Transmit Descriptor Link-List Start Address
     * |        |          |The TXDSA keeps the start address of transmit descriptor link-list.
     * |        |          |If the software enables the bit TXON (EMAC_CTL[8]), the content of TXDSA will be loaded into the current transmit descriptor start address register (EMAC_CTXDSA).
     * |        |          |The TXDSA does not be updated by EMAC.
     * |        |          |During the operation, EMAC will ignore the bits [1:0] of TXDSA.
     * |        |          |This means that each TX descriptor always must locate at word boundary memory address.
    */
    __IO uint32_t TXDSA;

    /**
     * RXDSA
     * ===================================================================================================
     * Offset: 0x8C  Receive Descriptor Link List Start Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |RXDSA     |Receive Descriptor Link-List Start Address
     * |        |          |The RXDSA keeps the start address of receive descriptor link-list.
     * |        |          |If the S/W enables the bit RXON (EMAC_CTL[0]), the content of RXDSA will be loaded into the current receive descriptor start address register (EMAC_CRXDSA).
     * |        |          |The RXDSA does not be updated by EMAC.
     * |        |          |During the operation, EMAC will ignore the bits [1:0] of RXDSA.
     * |        |          |This means that each RX descriptor always must locate at word boundary memory address.
    */
    __IO uint32_t RXDSA;

    /**
     * CTL
     * ===================================================================================================
     * Offset: 0x90  MAC Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |RXON      |Frame Reception ON
     * |        |          |The RXON controls the normal packet reception of EMAC.
     * |        |          |If the RXON is set to high, the EMAC starts the packet reception process, including the RX descriptor fetching, packet reception and RX descriptor modification.
     * |        |          |It is necessary to finish EMAC initial sequence before enable RXON.
     * |        |          |Otherwise, the EMAC operation is undefined.
     * |        |          |If the RXON is disabled during EMAC is receiving an incoming packet, the EMAC stops the packet reception process after the current packet reception finished.
     * |        |          |0 = Packet reception process stopped.
     * |        |          |1 = Packet reception process started.
     * |[1]     |ALP       |Accept Long Packet
     * |        |          |The ALP controls the long packet, which packet length is greater than 1518 bytes, reception.
     * |        |          |If the ALP is set to high, the EMAC will accept the long packet.
     * |        |          |Otherwise, the long packet will be dropped.
     * |        |          |0 = Ethernet MAC controller dropped the long packet.
     * |        |          |1 = Ethernet MAC controller received the long packet.
     * |[2]     |ARP       |Accept Runt Packet
     * |        |          |The ARP controls the runt packet, which length is less than 64 bytes, reception.
     * |        |          |If the ARP is set to high, the EMAC will accept the runt packet.
     * |        |          |Otherwise, the runt packet will be dropped.
     * |        |          |0 = Ethernet MAC controller dropped the runt packet.
     * |        |          |1 = Ethernet MAC controller received the runt packet.
     * |[3]     |ACP       |Accept Control Packet
     * |        |          |The ACP controls the control frame reception.
     * |        |          |If the ACP is set to high, the EMAC will accept the control frame.
     * |        |          |Otherwise, the control frame will be dropped.
     * |        |          |It is recommended that S/W only enable ACP while EMAC is operating on full duplex mode.
     * |        |          |0 = Ethernet MAC controller dropped the control frame.
     * |        |          |1 = Ethernet MAC controller received the control frame.
     * |[4]     |AEP       |Accept CRC Error Packet
     * |        |          |The AEP controls the EMAC accepts or drops the CRC error packet.
     * |        |          |If the AEP is set to high, the incoming packet with CRC error will be received by EMAC as a good packet.
     * |        |          |0 = Ethernet MAC controller dropped the CRC error packet.
     * |        |          |1 = Ethernet MAC controller received the CRC error packet.
     * |[5]     |STRIPCRC  |Strip CRC Checksum
     * |        |          |The STRIPCRC controls if the length of incoming packet is calculated with 4 bytes CRC checksum.
     * |        |          |If the STRIPCRC is set to high, 4 bytes CRC checksum is excluded from length calculation of incoming packet.
     * |        |          |0 = The 4 bytes CRC checksum is included in packet length calculation.
     * |        |          |1 = The 4 bytes CRC checksum is excluded in packet length calculation.
     * |[6]     |WOLEN     |Wake On LAN Enable
     * |        |          |The WOLEN high enables the functionality that Ethernet MAC controller checked if the incoming packet is Magic Packet and wakeup system from Power-down mode.
     * |        |          |If incoming packet was a Magic Packet and the system was in Power-down, the Ethernet MAC controller would generate a wakeup event to wake system up from Power-down mode.
     * |        |          |0 = Wake-up by Magic Packet function Disabled.
     * |        |          |1 = Wake-up by Magic Packet function Enabled.
     * |[8]     |TXON      |Frame Transmission ON
     * |        |          |The TXON controls the normal packet transmission of EMAC.
     * |        |          |If the TXON is set to high, the EMAC starts the packet transmission process, including the TX descriptor fetching, packet transmission and TX descriptor modification.
     * |        |          |It is must to finish EMAC initial sequence before enable TXON.
     * |        |          |Otherwise, the EMAC operation is undefined.
     * |        |          |If the TXON is disabled during EMAC is transmitting a packet out, the EMAC stops the packet transmission process after the current packet transmission finished.
     * |        |          |0 = Packet transmission process stopped.
     * |        |          |1 = Packet transmission process started.
     * |[9]     |NODEF     |No Deferral
     * |        |          |The NODEF controls the enable of deferral exceed counter.
     * |        |          |If NODEF is set to high, the deferral exceed counter is disabled.
     * |        |          |The NODEF is only useful while EMAC is operating on half duplex mode.
     * |        |          |0 = The deferral exceed counter Enabled.
     * |        |          |1 = The deferral exceed counter Disabled.
     * |[16]    |SDPZ      |Send PAUSE Frame
     * |        |          |The SDPZ controls the PAUSE control frame transmission.
     * |        |          |If S/W wants to send a PAUSE control frame out, the CAM entry 13, 14 and 15 must be configured first and the corresponding CAM enable bit of CAMEN register also must be set.
     * |        |          |Then, set SDPZ to 1 enables the PAUSE control frame transmission.
     * |        |          |The SDPZ is a self-clear bit.
     * |        |          |This means after the PAUSE control frame transmission has completed, the SDPZ will be cleared automatically.
     * |        |          |It is recommended that only enabling SNDPAUSE while EMAC is operating in Full Duplex mode.
     * |        |          |0 = PAUSE control frame transmission completed.
     * |        |          |1 = PAUSE control frame transmission Enabled.
     * |[17]    |SQECHKEN  |SQE Checking Enable
     * |        |          |The SQECHKEN controls the enable of SQE checking.
     * |        |          |The SQE checking is only available while EMAC is operating on 10M bps and half duplex mode.
     * |        |          |In other words, the SQECHKEN cannot affect EMAC operation, if the EMAC is operating on 100M bps or full duplex mode.
     * |        |          |0 = SQE checking Disabled while EMAC is operating in 10Mbps and Half Duplex mode.
     * |        |          |1 = SQE checking Enabled while EMAC is operating in 10Mbps and Half Duplex mode.
     * |[18]    |FUDUP     |Full Duplex Mode Selection
     * |        |          |The FUDUP controls that if EMAC is operating on full or half duplex mode.
     * |        |          |0 = EMAC operates in half duplex mode.
     * |        |          |1 = EMAC operates in full duplex mode.
     * |[19]    |RMIIRXCTL |RMII RX Control
     * |        |          |The RMIIRXCTL control the receive data sample in RMII mode.
     * |        |          |It's necessary to set this bit high when RMIIEN (EMAC_CTL[ [22]) is high.
     * |        |          |0 = RMII RX control disabled.
     * |        |          |1 = RMII RX control enabled.
     * |[20]    |OPMODE    |Operation Mode Selection
     * |        |          |The OPMODE defines that if the EMAC is operating on 10M or 100M bps mode.
     * |        |          |The RST (EMAC_CTL[24]) would not affect OPMODE value.
     * |        |          |0 = EMAC operates in 10Mbps mode.
     * |        |          |1 = EMAC operates in 100Mbps mode.
     * |[22]    |RMIIEN    |RMII Mode Enable
     * |        |          |This bit controls if Ethernet MAC controller connected with off-chip Ethernet PHY by MII interface or RMII interface.
     * |        |          |The RST (EMAC_CTL[24]) would not affect RMIIEN value.
     * |        |          |0 = Ethernet MAC controller MII mode Enabled.
     * |        |          |1 = Ethernet MAC controller RMII mode Enabled.
     * |[24]    |RST       |Software Reset
     * |        |          |The RST implements a reset function to make the EMAC return default state.
     * |        |          |The RST is a self-clear bit.
     * |        |          |This means after the software reset finished, the RST will be cleared automatically.
     * |        |          |Enable RST can also reset all control and status registers, exclusive of the control bits RMIIEN (EMAC_CTL[22]), LOOPBK (EMAC_CTL[21]) and OPMODE (EMAC_CTL[20]).
     * |        |          |The EMAC re-initial is necessary after the software reset completed.
     * |        |          |0 = Software reset completed.
     * |        |          |1 = Software reset Enabled.
    */
    __IO uint32_t CTL;

    /**
     * MIIMDAT
     * ===================================================================================================
     * Offset: 0x94  MII Management Data Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |DATA      |MII Management Data
     * |        |          |The DATA is the 16 bits data that will be written into the registers of external PHY for MII Management write command or the data from the registers of external PHY for MII Management read command.
    */
    __IO uint32_t MIIMDAT;

    /**
     * MIIMCTL
     * ===================================================================================================
     * Offset: 0x98  MII Management Control and Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:4]   |PHYREG    |PHY Register Address
     * |        |          |The PHYREG keeps the address to indicate which register of external PHY is the target of the MII management command.
     * |[8:12]  |PHYADDR   |PHY Address
     * |        |          |The PHYADDR keeps the address to differentiate which external PHY is the target of the MII management command.
     * |[16]    |WRITE     |Write Command
     * |        |          |The Write defines the MII management command is a read or write.
     * |        |          |0 = MII management command is a read command.
     * |        |          |1 = MII management command is a write command.
     * |[17]    |BUSY      |Busy Bit
     * |        |          |The BUSY controls the enable of the MII management frame generation.
     * |        |          |If S/W wants to access registers of external PHY, it set BUSY to high and EMAC generates the MII management frame to external PHY through MII Management I/F.
     * |        |          |The BUSY is a self-clear bit.
     * |        |          |This means the BUSY will be cleared automatically after the MII management command finished.
     * |        |          |0 = MII management command generation finished.
     * |        |          |1 = MII management command generation Enabled.
     * |[18]    |PREAMSP   |Preamble Suppress
     * |        |          |The PREAMSP controls the preamble field generation of MII management frame.
     * |        |          |If the PREAMSP is set to high, the preamble field generation of MII management frame is skipped.
     * |        |          |0 = Preamble field generation of MII management frame not skipped.
     * |        |          |1 = Preamble field generation of MII management frame skipped.
     * |[19]    |MDCON     |MDC Clock ON Always
     * |        |          |The MDC controls the MDC clock generation.
     * |        |          |If the MDCON is set to high, the MDC clock actives always.
     * |        |          |Otherwise, the MDC will only active while S/W issues a MII management command.
     * |        |          |0 = MDC clock only actives while S/W issues a MII management command.
     * |        |          |1 = MDC clock actives always.
    */
    __IO uint32_t MIIMCTL;

    /**
     * FIFOCTL
     * ===================================================================================================
     * Offset: 0x9C  FIFO Threshold Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:1]   |RXFIFOTH  |RXFIFO Low Threshold
     * |        |          |The RXFIFOTH controls when RXDMA requests internal arbiter for data transfer between RXFIFO and system memory.
     * |        |          |The RXFIFOTH defines not only the high threshold of RXFIFO, but also the low threshold.
     * |        |          |The low threshold is the half of high threshold always.
     * |        |          |During the packet reception, if the RXFIFO reaches the high threshold, the RXDMA starts to transfer frame data from RXFIFO to system memory.
     * |        |          |If the frame data in RXFIFO is less than low threshold, RXDMA stops to transfer the frame data to system memory.
     * |        |          |00 = Depend on the burst length setting.
     * |        |          |If the burst length is 8 words, high threshold is 8 words, too.
     * |        |          |01 = RXFIFO high threshold is 64B and low threshold is 32B.
     * |        |          |10 = RXFIFO high threshold is 128B and low threshold is 64B.
     * |        |          |11 = RXFIFO high threshold is 192B and low threshold is 96B.
     * |[8:9]   |TXFIFOTH  |TXFIFO Low Threshold
     * |        |          |The TXFIFOTH controls when TXDMA requests internal arbiter for data transfer between system memory and TXFIFO.
     * |        |          |The TXFIFOTH defines not only the low threshold of TXFIFO, but also the high threshold.
     * |        |          |The high threshold is the twice of low threshold always.During the packet transmission, if the TXFIFO reaches the high threshold, the TXDMA stops generate request to transfer frame data from system memory to TXFIFO.
     * |        |          |If the frame data in TXFIFO is less than low threshold, TXDMA starts to transfer frame data from system memory to TXFIFO.
     * |        |          |The TXFIFOTH also defines when the TXMAC starts to transmit frame out to network.
     * |        |          |The TXMAC starts to transmit the frame out while the TXFIFO first time reaches the high threshold during the transmission of the frame.
     * |        |          |If the frame data length is less than TXFIFO high threshold, the TXMAC starts to transmit the frame out after the frame data are all inside the TXFIFO.
     * |        |          |00 = Undefined.
     * |        |          |01 = TXFIFO low threshold is 64B and high threshold is 128B.
     * |        |          |10 = TXFIFO low threshold is 80B and high threshold is 160B.
     * |        |          |11 = TXFIFO low threshold is 96B and high threshold is 192B.
     * |[20:21] |BURSTLEN  |DMA Burst Length
     * |        |          |This defines the burst length of AHB bus cycle while EMAC accesses system memory.
     * |        |          |00 = 16 words.
     * |        |          |01 = 16 words.
     * |        |          |10 = 8 words.
     * |        |          |11 = 4 words.
    */
    __IO uint32_t FIFOCTL;

    /**
     * TXST
     * ===================================================================================================
     * Offset: 0xA0  Transmit Start Demand Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |TXST      |Transmit Start Demand
     * |        |          |If the TX descriptor is not available for use of TXDMA after the TXON (EMAC_CTL[8]) is enabled, the FSM (Finite State Machine) of TXDMA enters the Halt state and the frame transmission is halted.
     * |        |          |After the S/W has prepared the new TX descriptor for frame transmission, it must issue a write command to EMAC_TXST register to make TXDMA to leave Halt state and continue the frame transmission.
     * |        |          |The EMAC_TXST is a write only register and read from this register is undefined.
     * |        |          |The write to EMAC_TXST register takes effect only when TXDMA stayed at Halt state.
    */
    __O  uint32_t TXST;

    /**
     * RXST
     * ===================================================================================================
     * Offset: 0xA4  Receive Start Demand Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |RXST      |Receive Start Demand
     * |        |          |If the RX descriptor is not available for use of RXDMA after the RXON (EMAC_CTL[0]) is enabled, the FSM (Finite State Machine) of RXDMA enters the Halt state and the frame reception is halted.
     * |        |          |After the S/W has prepared the new RX descriptor for frame reception, it must issue a write command to EMAC_RXST register to make RXDMA to leave Halt state and continue the frame reception.
     * |        |          |The EMAC_RXST is a write only register and read from this register is undefined.
     * |        |          |The write to EMAC_RXST register take effect only when RXDMA stayed at Halt state.
    */
    __O  uint32_t RXST;

    /**
     * MRFL
     * ===================================================================================================
     * Offset: 0xA8  Maximum Receive Frame Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |MRFL      |Maximum Receive Frame Length
     * |        |          |The MRFL defines the maximum frame length for received frame.
     * |        |          |If the frame length of received frame is greater than MRFL, and bit MFLEIEN (EMAC_INTEN[8]) is also enabled, the bit MFLEIF (EMAC_INTSTS[8]) is set and the RX interrupt is triggered.
     * |        |          |It is recommended that only use MRFL to qualify the length of received frame while S/W wants to receive a frame which length is greater than 1518 bytes.
    */
    __IO uint32_t MRFL;

    /**
     * INTEN
     * ===================================================================================================
     * Offset: 0xAC  MAC Interrupt Enable Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |RXIEN     |Receive Interrupt Enable Control
     * |        |          |The RXIEN controls the RX interrupt generation.
     * |        |          |If RXIEN is enabled and RXIF (EMAC_INTSTS[0]) is high, EMAC generates the RX interrupt to CPU.
     * |        |          |If RXIEN is disabled, no RX interrupt is generated to CPU even any status bit EMAC_INTSTS[15:1] is set and the corresponding bit of EMAC_INTEN is enabled.
     * |        |          |In other words, if S/W wants to receive RX interrupt from EMAC, this bit must be enabled.
     * |        |          |And, if S/W doesn't want to receive any RX interrupt from EMAC, disables this bit.
     * |        |          |0 = RXIF (EMAC_INTSTS[0]) is masked and RX interrupt generation Disabled.
     * |        |          |1 = RXIF (EMAC_INTSTS[0]) is not masked and RX interrupt generation Enabled.
     * |[1]     |CRCEIEN   |CRC Error Interrupt Enable Control
     * |        |          |The CRCEIEN controls the CRCEIF (EMAC_INTSTS[1]) interrupt generation.
     * |        |          |If CRCEIF (EMAC_INTSTS[1]) is set, and both CRCEIEN and RXIEN (EMAC_INTEN[0]) are enabled, the EMAC generates the RX interrupt to CPU.
     * |        |          |If CRCEIEN or RXIEN (EMAC_INTEN[0]) is disabled, no RX interrupt is generated to CPU even the CRCEIF (EMAC_INTSTS[1]) is set.
     * |        |          |0 = CRCEIF (EMAC_INTSTS[1]) trigger RX interrupt Disabled.
     * |        |          |1 = CRCEIF (EMAC_INTSTS[1]) trigger RX interrupt Enabled.
     * |[2]     |RXOVIEN   |Receive FIFO Overflow Interrupt Enable Control
     * |        |          |The RXOVIEN controls the RXOVIF (EMAC_INTSTS[2]) interrupt generation.
     * |        |          |If RXOVIF (EMAC_INTSTS[2]) is set, and both RXOVIEN and RXIEN (EMAC_INTEN[0]) are enabled, the EMAC generates the RX interrupt to CPU.
     * |        |          |If RXOVIEN or RXIEN (EMAC_INTEN[0]) is disabled, no RX interrupt is generated to CPU even the RXOVIF (EMAC_INTSTS[2]) is set.
     * |        |          |0 = RXOVIF (EMAC_INTSTS[2]) trigger RX interrupt Disabled.
     * |        |          |1 = RXOVIF (EMAC_INTSTS[2]) trigger RX interrupt Enabled.
     * |[3]     |LPIEN     |Long Packet Interrupt Enable
     * |        |          |The LPIEN controls the LPIF (EMAC_INTSTS[3]) interrupt generation.
     * |        |          |If LPIF (EMAC_INTSTS[3]) is set, and both LPIEN and RXIEN (EMAC_INTEN[0]) are enabled, the EMAC generates the RX interrupt to CPU.
     * |        |          |If LPIEN or RXIEN (EMAC_INTEN[0]) is disabled, no RX interrupt is generated to CPU even the LPIF (EMAC_INTSTS[3]) is set.
     * |        |          |0 = LPIF (EMAC_INTSTS[3]) trigger RX interrupt Disabled.
     * |        |          |1 = LPIF (EMAC_INTSTS[3]) trigger RX interrupt Enabled.
     * |[4]     |RXGDIEN   |Receive Good Interrupt Enable Control
     * |        |          |The RXGDIEN controls the RXGDIF (EMAC_INTSTS[4]) interrupt generation.
     * |        |          |If RXGDIF (EMAC_INTSTS[4]) is set, and both RXGDIEN and RXIEN (EMAC_INTEN[0]) are enabled, the EMAC generates the RX interrupt to CPU.
     * |        |          |If RXGDIEN or RXIEN (EMAC_INTEN[0]) is disabled, no RX interrupt is generated to CPU even the RXGDIF (EMAC_INTSTS[4]) is set.
     * |        |          |0 = RXGDIF (EMAC_INTSTS[4]) trigger RX interrupt Disabled.
     * |        |          |1 = RXGDIF (EMAC_INTSTS[4]) trigger RX interrupt Enabled.
     * |[5]     |ALIEIEN   |Alignment Error Interrupt Enable Control
     * |        |          |The ALIEIEN controls the ALIEIF (EMAC_INTSTS[5]) interrupt generation.
     * |        |          |If ALIEIF (EMAC_INTSTS[5]) is set, and both ALIEIEN and RXIEN (EMAC_INTEN[0]) are enabled, the EMAC generates the RX interrupt to CPU.
     * |        |          |If ALIEIEN or RXIEN (EMAC_INTEN[0]) is disabled, no RX interrupt is generated to CPU even the ALIEIF (EMAC_INTSTS[5]) is set.
     * |        |          |0 = ALIEIF (EMAC_INTSTS[5]) trigger RX interrupt Disabled.
     * |        |          |1 = ALIEIF (EMAC_INTSTS[5]) trigger RX interrupt Enabled.
     * |[6]     |RPIEN     |Runt Packet Interrupt Enable Control
     * |        |          |The RPIEN controls the RPIF (EMAC_INTSTS[6]) interrupt generation.
     * |        |          |If RPIF (EMAC_INTSTS[6]) is set, and both RPIEN and RXIEN (EMAC_INTEN[0]) are enabled, the EMAC generates the RX interrupt to CPU.
     * |        |          |If RPIEN or RXIEN (EMAC_INTEN[0]) is disabled, no RX interrupt is generated to CPU even the RPIF (EMAC_INTSTS[6]) is set.
     * |        |          |0 = RPIF (EMAC_INTSTS[6]) trigger RX interrupt Disabled.
     * |        |          |1 = RPIF (EMAC_INTSTS[6]) trigger RX interrupt Enabled.
     * |[7]     |MPCOVIEN  |Miss Packet Counter Overrun Interrupt Enable
     * |        |          |The MPCOVIEN controls the MPCOVIF (EMAC_INTSTS[7]) interrupt generation.
     * |        |          |If MPCOVIF (EMAC_INTSTS[7]) is set, and both MPCOVIEN and RXIEN (EMAC_INTEN[0]) are enabled, the EMAC generates the RX interrupt to CPU.
     * |        |          |If MPCOVIEN or RXIEN (EMAC_INTEN[0]) is disabled, no RX interrupt is generated to CPU even the MPCOVIF (EMAC_INTSTS[7]) is set.
     * |        |          |0 = MPCOVIF (EMAC_INTSTS[7]) trigger RX interrupt Disabled.
     * |        |          |1 = MPCOVIF (EMAC_INTSTS[7]) trigger RX interrupt Enabled.
     * |[8]     |MFLEIEN   |Maximum Frame Length Exceed Interrupt Enable
     * |        |          |The MFLEIEN controls the MFLEIF (EMAC_INTSTS[8]) interrupt generation.
     * |        |          |If MFLEIF (EMAC_INTSTS[8]) is set, and both MFLEIEN and RXIEN (EMAC_INTEN[0]) are enabled, the EMAC generates the RX interrupt to CPU.
     * |        |          |If MFLEIEN or RXIEN (EMAC_INTEN[0]) is disabled, no RX interrupt is generated to CPU even the MFLEIF (EMAC_INTSTS[8]) is set.
     * |        |          |0 = MFLEIF (EMAC_INTSTS[8]) trigger RX interrupt Disabled.
     * |        |          |1 = MFLEIF (EMAC_INTSTS[8]) trigger RX interrupt Enabled.
     * |[9]     |DENIEN    |DMA Early Notification Interrupt Enable Control
     * |        |          |The DENIEN controls the DENIF (EMAC_INTSTS[9]) interrupt generation.
     * |        |          |If DENIF (EMAC_INTSTS[9]) is set, and both DENIEN and RXIEN (EMAC_INTEN[0]) are enabled, the EMAC generates the RX interrupt to CPU.
     * |        |          |If DENIEN or RXIEN (EMAC_INTEN[0]) is disabled, no RX interrupt is generated to CPU even the DENIF (EMAC_INTSTS[9]) is set.
     * |        |          |0 = TDENIF (EMAC_INTSTS[9]) trigger RX interrupt Disabled.
     * |        |          |1 = TDENIF (EMAC_INTSTS[9]) trigger RX interrupt Enabled.
     * |[10]    |RDUIEN    |Receive Descriptor Unavailable Interrupt Enable Control
     * |        |          |The RDUIEN controls the RDUIF (EMAC_INTSTS[10]) interrupt generation.
     * |        |          |If RDUIF (EMAC_INTSTS[10]) is set, and both RDUIEN and RXIEN (EMAC_INTEN[0]) are enabled, the EMAC generates the RX interrupt to CPU.
     * |        |          |If RDUIEN or RXIEN (EMAC_INTEN[0]) is disabled, no RX interrupt is generated to CPU even the RDUIF (EMAC_MIOSTA[10]) register is set.
     * |        |          |0 = RDUIF (EMAC_INTSTS[10]) trigger RX interrupt Disabled.
     * |        |          |1 = RDUIF (EMAC_INTSTS[10]) trigger RX interrupt Enabled.
     * |[11]    |RXBEIEN   |Receive Bus Error Interrupt Enable Control
     * |        |          |The RXBEIEN controls the RXBEIF (EMAC_INTSTS[11]) interrupt generation.
     * |        |          |If RXBEIF (EMAC_INTSTS[11]) is set, and both RXBEIEN and RXIEN (EMAC_INTEN[0]) are enabled, the EMAC generates the RX interrupt to CPU.
     * |        |          |If RXBEIEN or RXIEN (EMAC_INTEN[0]) is disabled, no RX interrupt is generated to CPU even the RXBEIF (EMAC_INTSTS[11]) is set.
     * |        |          |0 = RXBEIF (EMAC_INTSTS[11]) trigger RX interrupt Disabled.
     * |        |          |1 = RXBEIF (EMAC_INTSTS[11]) trigger RX interrupt Enabled.
     * |[14]    |CFRIEN    |Control Frame Receive Interrupt Enable Control
     * |        |          |The CFRIEN controls the CFRIF (EMAC_INTSTS[14]) interrupt generation.
     * |        |          |If CFRIF (EMAC_INTSTS[14]) is set, and both CFRIEN and RXIEN (EMAC_INTEN[0]) are enabled, the EMAC generates the RX interrupt to CPU.
     * |        |          |If CFRIEN or RXIEN (EMAC_INTEN[0]) is disabled, no RX interrupt is generated to CPU even the CFRIF (EMAC_INTSTS[14]) register is set.
     * |        |          |0 = CFRIF (EMAC_INTSTS[14]) trigger RX interrupt Disabled.
     * |        |          |1 = CFRIF (EMAC_INTSTS[14]) trigger RX interrupt Enabled.
     * |[15]    |WOLIEN    |Wake On LAN Interrupt Enable
     * |        |          |The WOLIEN controls the WOLIF (EMAC_INTSTS[15]) interrupt generation.
     * |        |          |If WOLIF (EMAC_INTSTS[15]) is set, and both WOLIEN and RXIEN (EMAC_INTEN[0]) are enabled, the EMAC generates the RX interrupt to CPU.
     * |        |          |If WOLIEN or RXIEN (EMAC_INTEN[0]) is disabled, no RX interrupt is generated to CPU even the WOLIF (EMAC_INTSTS[15]) is set.
     * |        |          |0 = WOLIF (EMAC_INTSTS[15]) trigger RX interrupt Disabled.
     * |        |          |1 = WOLIF (EMAC_INTSTS[15]) trigger RX interrupt Enabled.
     * |[16]    |TXIEN     |Transmit Interrupt Enable Control
     * |        |          |The TXIEN controls the TX interrupt generation.
     * |        |          |If TXIEN is enabled and TXIF (EMAC_INTSTS[16]) is high, EMAC generates the TX interrupt to CPU.
     * |        |          |If TXIEN is disabled, no TX interrupt is generated to CPU even any status bit of EMAC_INTSTS[24:17] set and the corresponding bit of EMAC_INTEN is enabled.
     * |        |          |In other words, if S/W wants to receive TX interrupt from EMAC, this bit must be enabled.
     * |        |          |And, if S/W doesn't want to receive any TX interrupt from EMAC, disables this bit.
     * |        |          |0 = TXIF (EMAC_INTSTS[16]) is masked and TX interrupt generation Disabled.
     * |        |          |1 = TXIF (EMAC_INTSTS[16]) is not masked and TX interrupt generation Enabled.
     * |[17]    |TXUDIEN   |Transmit FIFO Underflow Interrupt Enable Control
     * |        |          |The TXUDIEN controls the TXUDIF (EMAC_INTSTS[17]) interrupt generation.
     * |        |          |If TXUDIF (EMAC_INTSTS[17]) is set, and both TXUDIEN and TXIEN (EMAC_INTEN[16]) are enabled, the EMAC generates the TX interrupt to CPU.
     * |        |          |If TXUDIEN or TXIEN (EMAC_INTEN[16]) is disabled, no TX interrupt is generated to CPU even the TXUDIF (EMAC_INTSTS[17]) is set.
     * |        |          |0 = TXUDIF (EMAC_INTSTS[17]) TX interrupt Disabled.
     * |        |          |1 = TXUDIF (EMAC_INTSTS[17]) TX interrupt Enabled.
     * |[18]    |TXCPIEN   |Transmit Completion Interrupt Enable Control
     * |        |          |The TXCPIEN controls the TXCPIF (EMAC_INTSTS[18]) interrupt generation.
     * |        |          |If TXCPIF (EMAC_INTSTS[18]) is set, and both TXCPIEN and TXIEN (EMAC_INTEN[16]) are enabled, the EMAC generates the TX interrupt to CPU.
     * |        |          |If TXCPIEN or TXIEN (EMAC_INTEN[16]) is disabled, no TX interrupt is generated to CPU even the TXCPIF (EMAC_INTSTS[18]) is set.
     * |        |          |0 = TXCPIF (EMAC_INTSTS[18]) trigger TX interrupt Disabled.
     * |        |          |1 = TXCPIF (EMAC_INTSTS[18]) trigger TX interrupt Enabled.
     * |[19]    |EXDEFIEN  |Defer Exceed Interrupt Enable Control
     * |        |          |The EXDEFIEN controls the EXDEFIF (EMAC_INTSTS[19]) interrupt generation.
     * |        |          |If EXDEFIF (EMAC_INTSTS[19]) is set, and both EXDEFIEN and TXIEN (EMAC_INTEN[16]) are enabled, the EMAC generates the TX interrupt to CPU.
     * |        |          |If EXDEFIEN or TXIEN (EMAC_INTEN[16]) is disabled, no TX interrupt is generated to CPU even the EXDEFIF (EMAC_INTSTS[19]) is set.
     * |        |          |0 = EXDEFIF (EMAC_INTSTS[19]) trigger TX interrupt Disabled.
     * |        |          |1 = EXDEFIF (EMAC_INTSTS[19]) trigger TX interrupt Enabled.
     * |[20]    |NCSIEN    |No Carrier Sense Interrupt Enable Control
     * |        |          |The NCSIEN controls the NCSIF (EMAC_INTSTS[20]) interrupt generation.
     * |        |          |If NCSIF (EMAC_INTSTS[20]) is set, and both NCSIEN and TXIEN (EMAC_INTEN[16]) are enabled, the EMAC generates the TX interrupt to CPU.
     * |        |          |If NCSIEN or TXIEN (EMAC_INTEN[16]) is disabled, no TX interrupt is generated to CPU even the NCSIF (EMAC_INTSTS[20]) is set.
     * |        |          |0 = NCSIF (EMAC_INTSTS[20]) trigger TX interrupt Disabled.
     * |        |          |1 = NCSIF (EMAC_INTSTS[20]) trigger TX interrupt Enabled.
     * |[21]    |TXABTIEN  |Transmit Abort Interrupt Enable Control
     * |        |          |The TXABTIEN controls the TXABTIF (EMAC_INTSTS[21]) interrupt generation.
     * |        |          |If TXABTIF (EMAC_INTSTS[21]) is set, and both TXABTIEN and TXIEN (EMAC_INTEN[16]) are enabled, the EMAC generates the TX interrupt to CPU.
     * |        |          |If TXABTIEN or TXIEN (EMAC_INTEN[16]) is disabled, no TX interrupt is generated to CPU even the TXABTIF (EMAC_INTSTS[21]) is set.
     * |        |          |0 = TXABTIF (EMAC_INTSTS[21]) trigger TX interrupt Disabled.
     * |        |          |1 = TXABTIF (EMAC_INTSTS[21]) trigger TX interrupt Enabled.
     * |[22]    |LCIEN     |Late Collision Interrupt Enable Control
     * |        |          |The LCIEN controls the LCIF (EMAC_INTSTS[22]) interrupt generation.
     * |        |          |If LCIF (EMAC_INTSTS[22]) is set, and both LCIEN and TXIEN (EMAC_INTEN[16]) are enabled, the EMAC generates the TX interrupt to CPU.
     * |        |          |If LCIEN or TXIEN (EMAC_INTEN[16]) is disabled, no TX interrupt is generated to CPU even the LCIF (EMAC_INTSTS[22]) is set.
     * |        |          |0 = LCIF (EMAC_INTSTS[22]) trigger TX interrupt Disabled.
     * |        |          |1 = LCIF (EMAC_INTSTS[22]) trigger TX interrupt Enabled.
     * |[23]    |TDUIEN    |Transmit Descriptor Unavailable Interrupt Enable Control
     * |        |          |The TDUIEN controls the TDUIF (EMAC_INTSTS[23]) interrupt generation.
     * |        |          |If TDUIF (EMAC_INTSTS[23]) is set, and both TDUIEN and TXIEN (EMAC_INTEN[16]) are enabled, the EMAC generates the TX interrupt to CPU.
     * |        |          |If TDUIEN or TXIEN (EMAC_INTEN[16]) is disabled, no TX interrupt is generated to CPU even the TDUIF (EMAC_INTSTS[23]) is set.
     * |        |          |0 = TDUIF (EMAC_INTSTS[23]) trigger TX interrupt Disabled.
     * |        |          |1 = TDUIF (EMAC_INTSTS[23]) trigger TX interrupt Enabled.
     * |[24]    |TXBEIEN   |Transmit Bus Error Interrupt Enable Control
     * |        |          |The TXBEIEN controls the TXBEIF (EMAC_INTSTS[24]) interrupt generation.
     * |        |          |If TXBEIF (EMAC_INTSTS[24]) is set, and both TXBEIEN and TXIEN (EMAC_INTEN[16]) are enabled, the EMAC generates the TX interrupt to CPU.
     * |        |          |If TXBEIEN or TXIEN (EMAC_INTEN[16]) is disabled, no TX interrupt is generated to CPU even the TXBEIF (EMAC_INTSTS[24]) is set.
     * |        |          |0 = TXBEIF (EMAC_INTSTS[24]) trigger TX interrupt Disabled.
     * |        |          |1 = TXBEIF (EMAC_INTSTS[24]) trigger TX interrupt Enabled.
     * |[28]    |TSALMIEN  |Time Stamp Alarm Interrupt Enable Control
     * |        |          |The TSALMIEN controls the TSALMIF (EMAC_INTSTS[28]) interrupt generation.
     * |        |          |If TSALMIF (EMAC_INTSTS[28]) is set, and both TSALMIEN and TXIEN (EMAC_INTEN[16]) enabled, the EMAC generates the TX interrupt to CPU.
     * |        |          |If TSALMIEN or TXIEN (EMAC_INTEN[16]) disabled, no TX interrupt generated to CPU even the TXTSALMIF (EMAC_INTEN[28]) is set.
     * |        |          |0 = TXTSALMIF (EMAC_INTSTS[28]) trigger TX interrupt Disabled.
     * |        |          |1 = TXTSALMIF (EMAC_INTSTS[28]) trigger TX interrupt Enabled.
    */
    __IO uint32_t INTEN;

    /**
     * INTSTS
     * ===================================================================================================
     * Offset: 0xB0  MAC Interrupt Status Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |RXIF      |Receive Interrupt
     * |        |          |The RXIF indicates the RX interrupt status.
     * |        |          |If RXIF high and its corresponding enable bit, RXIEN (EMAC_INTEN[0]), is also high indicates the EMAC generates RX interrupt to CPU.
     * |        |          |If RXIF is high but RXIEN (EMAC_INTEN[0]) is disabled, no RX interrupt is generated.
     * |        |          |The RXIF is logic OR result of bit logic AND result of EMAC_INTSTS[15:1] and EMAC_INTEN[15:1].
     * |        |          |In other words, if any bit of EMAC_INTSTS[15:1] is high and its corresponding enable bit in EMAC_INTEN[15:1] is also enabled, the RXIF will be high.
     * |        |          |Because the RXIF is a logic OR result, clears EMAC_INTSTS[15:1] makes RXIF be cleared, too.
     * |        |          |0 = No status bit in EMAC_INTSTS[15:1] is set or no enable bit in EMAC_INTEN[15:1] is enabled.
     * |        |          |1 = At least one status in EMAC_INTSTS[15:1] is set and its corresponding enable bit in EMAC_INTEN[15:1] is enabled, too.
     * |[1]     |CRCEIF    |CRC Error Interrupt
     * |        |          |The CRCEIF high indicates the incoming packet incurred the CRC error and the packet is dropped.
     * |        |          |If the AEP (EMAC_CTL[4]) is set, the CRC error packet will be regarded as a good packet and CRCEIF will not be set.
     * |        |          |If the CRCEIF is high and CRCEIEN (EMAC_INTEN[1]) is enabled, the RXIF will be high.
     * |        |          |Write 1 to this bit clears the CRCEIF status.
     * |        |          |0 = The frame does not incur CRC error.
     * |        |          |1 = The frame incurred CRC error.
     * |[2]     |RXOVIF    |Receive FIFO Overflow Interrupt
     * |        |          |The RXOVIF high indicates the RXFIFO overflow occurred during packet reception.
     * |        |          |While the RXFIFO overflow occurred, the EMAC drops the current receiving packer.
     * |        |          |If the RXFIFO overflow occurred often, it is recommended that modify RXFIFO threshold control, the RXFIFOTH of FFTCR register, to higher level.
     * |        |          |If the RXOVIF is high and RXOVIEN (EMAC_INTEN[2]) is enabled, the RXIF will be high.
     * |        |          |Write 1 to this bit clears the RXOVIF status.
     * |        |          |0 = No RXFIFO overflow occurred during packet reception.
     * |        |          |1 = RXFIFO overflow occurred during packet reception.
     * |[3]     |LPIF      |Long Packet Interrupt Flag
     * |        |          |The LPIF high indicates the length of the incoming packet is greater than 1518 bytes and the incoming packet is dropped.
     * |        |          |If the ALP (EMAC_CTL[1]) is set, the long packet will be regarded as a good packet and LPIF will not be set.
     * |        |          |If the LPIF is high and LPIEN (EMAC_INTEN[3]) is enabled, the RXIF will be high.
     * |        |          |Write 1 to this bit clears the LPIF status.
     * |        |          |0 = The incoming frame is not a long frame or S/W wants to receive a long frame.
     * |        |          |1 = The incoming frame is a long frame and dropped.
     * |[4]     |RXGDIF    |Receive Good Interrupt
     * |        |          |The RXGDIF high indicates the frame reception has completed.
     * |        |          |If the RXGDIF is high and RXGDIEN (EAMC_MIEN[4]) is enabled, the RXIF will be high.
     * |        |          |Write 1 to this bit clears the RXGDIF status.
     * |        |          |0 = The frame reception has not complete yet.
     * |        |          |1 = The frame reception has completed.
     * |[5]     |ALIEIF    |Alignment Error Interrupt
     * |        |          |The ALIEIF high indicates the length of the incoming frame is not a multiple of byte.
     * |        |          |If the ALIEIF is high and ALIEIEN (EMAC_INTEN[5]) is enabled, the RXIF will be high.
     * |        |          |Write 1 to this bit clears the ALIEIF status.
     * |        |          |0 = The frame length is a multiple of byte.
     * |        |          |1 = The frame length is not a multiple of byte.
     * |[6]     |RPIF      |Runt Packet Interrupt
     * |        |          |The RPIF high indicates the length of the incoming packet is less than 64 bytes and the packet is dropped.
     * |        |          |If the ARP (EMAC_CTL[2]) is set, the short packet is regarded as a good packet and RPIF will not be set.
     * |        |          |If the RPIF is high and RPIEN (EMAC_INTEN[6]) is enabled, the RXIF will be high.
     * |        |          |Write 1 to this bit clears the RPIF status.
     * |        |          |0 = The incoming frame is not a short frame or S/W wants to receive a short frame.
     * |        |          |1 = The incoming frame is a short frame and dropped.
     * |[7]     |MPCOVIF   |Missed Packet Counter Overrun Interrupt Flag
     * |        |          |The MPCOVIF high indicates the MPCNT, Missed Packet Count, has overflow.
     * |        |          |If the MPCOVIF is high and MPCOVIEN (EMAC_INTEN[7]) is enabled, the RXIF will be high.
     * |        |          |Write 1 to this bit clears the MPCOVIF status.
     * |        |          |0 = The MPCNT has not rolled over yet.
     * |        |          |1 = The MPCNT has rolled over yet.
     * |[8]     |MFLEIF    |Maximum Frame Length Exceed Interrupt Flag
     * |        |          |The MFLEIF high indicates the length of the incoming packet has exceeded the length limitation configured in DMARFC register and the incoming packet is dropped.
     * |        |          |If the MFLEIF is high and MFLEIEN (EMAC_INTEN[8]) is enabled, the RXIF will be high.
     * |        |          |Write 1 to this bit clears the MFLEIF status.
     * |        |          |0 = The length of the incoming packet does not exceed the length limitation configured in DMARFC.
     * |        |          |1 = The length of the incoming packet has exceeded the length limitation configured in DMARFC.
     * |[9]     |DENIF     |DMA Early Notification Interrupt
     * |        |          |The DENIF high indicates the EMAC has received the LENGTH field of the incoming packet.
     * |        |          |If the DENIF is high and DENIENI (EMAC_INTEN[9]) is enabled, the RXIF will be high.
     * |        |          |Write 1 to this bit clears the DENIF status.
     * |        |          |0 = The LENGTH field of incoming packet has not received yet.
     * |        |          |1 = The LENGTH field of incoming packet has received.
     * |[10]    |RDUIF     |Receive Descriptor Unavailable Interrupt
     * |        |          |The RDUIF high indicates that there is no available RX descriptor for packet reception and RXDMA will stay at Halt state.
     * |        |          |Once, the RXDMA enters the Halt state, S/W must issues a write command to RSDR register to make RXDMA leave Halt state while new RX descriptor is available.
     * |        |          |If the RDUIF is high and RDUIEN (EMAC_INTEN[10]) is enabled, the RXIF will be high.
     * |        |          |Write 1 to this bit clears the RDUIF status.
     * |        |          |0 = RX descriptor is available.
     * |        |          |1 = RX descriptor is unavailable.
     * |[11]    |RXBEIF    |Receive Bus Error Interrupt
     * |        |          |The RXBEIF high indicates the memory controller replies ERROR response while EMAC access system memory through RXDMA during packet reception process.
     * |        |          |Reset EMAC is recommended while RXBEIF status is high.
     * |        |          |If the RXBEIF is high and RXBEIEN (EMAC_INTEN[11]) is enabled, the RXIF will be high.
     * |        |          |Write 1 to this bit clears the RXBEIF status.
     * |        |          |0 = No ERROR response is received.
     * |        |          |1 = ERROR response is received.
     * |[14]    |CFRIF     |Control Frame Receive Interrupt
     * |        |          |The CFRIF high indicates EMAC receives a flow control frame.
     * |        |          |The CFRIF only available while EMAC is operating on full duplex mode.
     * |        |          |If the CFRIF is high and CFRIEN (EMAC_INTEN[14]) is enabled, the RXIF will be high.
     * |        |          |Write 1 to this bit clears the CFRIF status.
     * |        |          |0 = The EMAC does not receive the flow control frame.
     * |        |          |1 = The EMAC receives a flow control frame.
     * |[15]    |WOLIF     |Wake On LAN Interrupt Flag
     * |        |          |The WOLIF high indicates EMAC receives a Magic Packet.
     * |        |          |The CFRIF only available while system is in power down mode and WOLEN is set high.
     * |        |          |If the WOLIF is high and WOLIEN (EMAC_INTEN[15]) is enabled, the RXIF will be high.
     * |        |          |Write 1 to this bit clears the WOLIF status.
     * |        |          |0 = The EMAC does not receive the Magic Packet.
     * |        |          |1 = The EMAC receives a Magic Packet.
     * |[16]    |TXIF      |Transmit Interrupt
     * |        |          |The TXIF indicates the TX interrupt status.
     * |        |          |If TXIF high and its corresponding enable bit, TXIEN (EMAC_INTEN[16]), is also high indicates the EMAC generates TX interrupt to CPU.
     * |        |          |If TXIF is high but TXIEN (EMAC_INTEN[16]) is disabled, no TX interrupt is generated.
     * |        |          |The TXIF is logic OR result of bit logic AND result of EMAC_INTSTS[28:17] and EMAC_INTEN[28:17].
     * |        |          |In other words, if any bit of EMAC_INTSTS[28:17] is high and its corresponding enable bit in EMAC_INTEN[28:17] is also enabled, the TXIF will be high.
     * |        |          |Because the TXIF is a logic OR result, clears EMAC_INTSTS[28:17] makes TXIF be cleared, too.
     * |        |          |0 = No status bit in EMAC_INTSTS[28:17] is set or no enable bit in EMAC_INTEN[28:17] is enabled.
     * |        |          |1 = At least one status in EMAC_INTSTS[28:17] is set and its corresponding enable bit in EMAC_INTEN[28:17] is enabled, too.
     * |[17]    |TXUDIF    |Transmit FIFO Underflow Interrupt
     * |        |          |The TXUDIF high indicates the TXFIFO underflow occurred during packet transmission.
     * |        |          |While the TXFIFO underflow occurred, the EMAC will retransmit the packet automatically without S/W intervention.
     * |        |          |If the TXFIFO underflow occurred often, it is recommended that modify TXFIFO threshold control, the TXFIFOTH of FFTCR register, to higher level.
     * |        |          |If the TXUDIF is high and TXUDIEN (EMAC_INTEN[17]) is enabled, the TXIF will be high.
     * |        |          |Write 1 to this bit clears the TXUDIF status.
     * |        |          |0 = No TXFIFO underflow occurred during packet transmission.
     * |        |          |1 = TXFIFO underflow occurred during packet transmission.
     * |[18]    |TXCPIF    |Transmit Completion Interrupt
     * |        |          |The TXCPIF indicates the packet transmission has completed correctly.
     * |        |          |If the TXCPIF is high and TXCPIEN (EMAC_INTEN[18]) is enabled, the TXIF will be high.
     * |        |          |Write 1 to this bit clears the TXCPIF status.
     * |        |          |0 = The packet transmission not completed.
     * |        |          |1 = The packet transmission has completed.
     * |[19]    |EXDEFIF   |Defer Exceed Interrupt
     * |        |          |The EXDEFIF high indicates the frame waiting for transmission has deferred over 0.32768ms on 100Mbps mode, or 3.2768ms on 10Mbps mode.
     * |        |          |The deferral exceed check will only be done while bit NODEF of MCMDR is disabled, and EMAC is operating on half-duplex mode.
     * |        |          |If the EXDEFIF is high and EXDEFIEN (EMAC_INTEN[19]) is enabled, the TXIF will be high.
     * |        |          |Write 1 to this bit clears the EXDEFIF status.
     * |        |          |0 = Frame waiting for transmission has not deferred over 0.32768ms (100Mbps) or 3.2768ms (10Mbps).
     * |        |          |1 = Frame waiting for transmission has deferred over 0.32768ms (100Mbps) or 3.2768ms (10Mbps).
     * |[20]    |NCSIF     |No Carrier Sense Interrupt
     * |        |          |The NCSIF high indicates the MII I/F signal CRS does not active at the start of or during the packet transmission.
     * |        |          |The NCSIF is only available while EMAC is operating on half-duplex mode.
     * |        |          |If the NCSIF is high and NCSIEN (EMAC_INTEN[20]) is enabled, the TXIF will be high.
     * |        |          |Write 1 to this bit clears the NCSIF status.
     * |        |          |0 = CRS signal actives correctly.
     * |        |          |1 = CRS signal does not active at the start of or during the packet transmission.
     * |[21]    |TXABTIF   |Transmit Abort Interrupt
     * |        |          |The TXABTIF high indicates the packet incurred 16 consecutive collisions during transmission, and then the transmission process for this packet is aborted.
     * |        |          |The transmission abort is only available while EMAC is operating on half-duplex mode.
     * |        |          |If the TXABTIF is high and TXABTIEN (EMAC_INTEN[21]) is enabled, the TXIF will be high.
     * |        |          |Write 1 to this bit clears the TXABTIF status.
     * |        |          |0 = Packet does not incur 16 consecutive collisions during transmission.
     * |        |          |1 = Packet incurred 16 consecutive collisions during transmission.
     * |[22]    |LCIF      |Late Collision Interrupt
     * |        |          |The LCIF high indicates the collision occurred in the outside of 64 bytes collision window.
     * |        |          |This means after the 64 bytes of a frame has been transmitted out to the network, the collision still occurred.
     * |        |          |The late collision check will only be done while EMAC is operating on half-duplex mode.
     * |        |          |If the LCIF is high and LCIEN (EMAC_INTEN[22]) is enabled, the TXIF will be high.
     * |        |          |Write 1 to this bit clears the LCIF status.
     * |        |          |0 = No collision occurred in the outside of 64 bytes collision window.
     * |        |          |1 = Collision occurred in the outside of 64 bytes collision window.
     * |[23]    |TDUIF     |Transmit Descriptor Unavailable Interrupt
     * |        |          |The TDUIF high indicates that there is no available TX descriptor for packet transmission and TXDMA will stay at Halt state.
     * |        |          |Once, the TXDMA enters the Halt state, S/W must issues a write command to TSDR register to make TXDMA leave Halt state while new TX descriptor is available.
     * |        |          |If the TDUIF is high and TDUIEN (EMAC_INTEN[23]) is enabled, the TXIF will be high.
     * |        |          |Write 1 to this bit clears the TDUIF status.
     * |        |          |0 = TX descriptor is available.
     * |        |          |1 = TX descriptor is unavailable.
     * |[24]    |TXBEIF    |Transmit Bus Error Interrupt
     * |        |          |The TXBEIF high indicates the memory controller replies ERROR response while EMAC access system memory through TXDMA during packet transmission process.
     * |        |          |Reset EMAC is recommended while TXBEIF status is high.
     * |        |          |If the TXBEIF is high and TXBEIEN (EMAC_INTEN[24]) is enabled, the TXIF will be high.
     * |        |          |Write 1 to this bit clears the TXBEIF status.
     * |        |          |0 = No ERROR response is received.
     * |        |          |1 = ERROR response is received.
     * |[28]    |TSALMIF   |Time Stamp Alarm Interrupt
     * |        |          |The TSALMIF high indicates the EMAC_TSSEC register value equals to EMAC_ALMSEC register and EMAC_TSSUBSEC register value equals to register EMAC_TSMLSR.
     * |        |          |If TSALMIF is high and TSALMIEN (EMAC_INTEN[28]) enabled, the TXIF will be high.
     * |        |          |Write 1 to this bit clears the TSALMIF status.
     * |        |          |0 = EMAC_TSSEC did not equal EMAC_ALMSEC or EMAC_TSSUBSEC did not equal EMAC_ALMSUBSEC.
     * |        |          |1 = EMAC_TSSEC equals EMAC_ALMSEC and EMAC_TSSUBSEC equals EMAC_ALMSUBSEC.
    */
    __IO uint32_t INTSTS;

    /**
     * GENSTS
     * ===================================================================================================
     * Offset: 0xB4  MAC General Status Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |CFRIF     |Control Frame Received
     * |        |          |The CFRIF high indicates EMAC receives a flow control frame.
     * |        |          |The CFRIF only available while EMAC is operating on full duplex mode.
     * |        |          |0 = The EMAC does not receive the flow control frame.
     * |        |          |1 = The EMAC receives a flow control frame.
     * |[1]     |RXHALT    |Receive Halted
     * |        |          |The RXHALT high indicates the next normal packet reception process will be halted because the bit RXON of MCMDR is disabled be S/W.
     * |        |          |0 = Next normal packet reception process will go on.
     * |        |          |1 = Next normal packet reception process will be halted.
     * |[2]     |RXFFULL   |RXFIFO Full
     * |        |          |The RXFFULL indicates the RXFIFO is full due to four 64-byte packets are kept in RXFIFO and the following incoming packet will be dropped.
     * |        |          |0 = The RXFIFO is not full.
     * |        |          |1 = The RXFIFO is full and the following incoming packet will be dropped.
     * |[4:7]   |COLCNT    |Collision Count
     * |        |          |The COLCNT indicates that how many collisions occurred consecutively during a packet transmission.
     * |        |          |If the packet incurred 16 consecutive collisions during transmission, the COLCNT will be 0 and bit TXABTIF will be set to 1.
     * |[8]     |DEF       |Deferred Transmission
     * |        |          |The DEF high indicates the packet transmission has deferred once.
     * |        |          |The DEF is only available while EMAC is operating on half-duplex mode.
     * |        |          |0 = Packet transmission does not defer.
     * |        |          |1 = Packet transmission has deferred once.
     * |[9]     |TXPAUSED  |Transmission Paused
     * |        |          |The TXPAUSED high indicates the next normal packet transmission process will be paused temporally because EMAC received a PAUSE control frame.
     * |        |          |0 = Next normal packet transmission process will go on.
     * |        |          |1 = Next normal packet transmission process will be paused.
     * |[10]    |SQE       |Signal Quality Error
     * |        |          |The SQE high indicates the SQE error found at end of packet transmission on 10Mbps half-duplex mode.
     * |        |          |The SQE error check will only be done while both bit SQECHKEN (EMAC_CTL[17]) is enabled and EMAC is operating on 10Mbps half-duplex mode.
     * |        |          |0 = No SQE error found at end of packet transmission.
     * |        |          |1 = SQE error found at end of packet transmission.
     * |[11]    |TXHALT    |Transmission Halted
     * |        |          |The TXHALT high indicates the next normal packet transmission process will be halted because the bit TXON (EMAC_CTL[8]) is disabled be S/W.
     * |        |          |0 = Next normal packet transmission process will go on.
     * |        |          |1 = Next normal packet transmission process will be halted.
     * |[12]    |RPSTS     |Remote Pause Status
     * |        |          |The RPSTS indicates that remote pause counter down counting actives.
     * |        |          |After Ethernet MAC controller sent PAUSE frame out successfully, it starts the remote pause counter down counting.
     * |        |          |When this bit high, it's predictable that remote Ethernet MAC controller wouldn't start the packet transmission until the down counting done.
     * |        |          |0 = Remote pause counter down counting done.
     * |        |          |1 = Remote pause counter down counting actives.
    */
    __IO uint32_t GENSTS;

    /**
     * MPCNT
     * ===================================================================================================
     * Offset: 0xB8  Missed Packet Count Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |MPCNT     |Miss Packet Count
     * |        |          |The MPCNT indicates the number of packets that were dropped due to various types of receive errors.
     * |        |          |The following type of receiving error makes missed packet counter increase:.
     * |        |          |1. Incoming packet is incurred RXFIFO overflow.
     * |        |          |2. Incoming packet is dropped due to RXON is disabled.
     * |        |          |3. Incoming packet is incurred CRC error.
    */
    __IO uint32_t MPCNT;

    /**
     * RPCNT
     * ===================================================================================================
     * Offset: 0xBC  MAC Receive Pause Count Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |RPCNT     |MAC Receive Pause Count
     * |        |          |The RPCNT keeps the OPERAND field of the PAUSE control frame.
     * |        |          |It indicates how many slot time (512 bit time) the TX of EMAC will be paused.
    */
    __I  uint32_t RPCNT;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE0[2];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * FRSTS
     * ===================================================================================================
     * Offset: 0xC8  DMA Receive Frame Status Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:15]  |RXFLT     |Receive Frame LENGTH
     * |        |          |The RXFLT keeps the LENGTH field of each incoming Ethernet packet.
     * |        |          |If the bit DENIEN (EMAC_INTEN[9]) is enabled and the LENGTH field of incoming packet has received, the bit DENIF (EMAC_INTSTS[9]) will be set and trigger interrupt.
     * |        |          |And, the content of LENGTH field will be stored in RXFLT.
    */
    __IO uint32_t FRSTS;

    /**
     * CTXDSA
     * ===================================================================================================
     * Offset: 0xCC  Current Transmit Descriptor Start Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CTXDSA    |Current Transmit Descriptor Start Address
     * |        |          |The CTXDSA keeps the start address of TX descriptor that is used by TXDMA currently.
     * |        |          |The CTXDSA is read only and write to this register has no effect.
    */
    __I  uint32_t CTXDSA;

    /**
     * CTXBSA
     * ===================================================================================================
     * Offset: 0xD0  Current Transmit Buffer Start Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CTXBSA    |Current Transmit Buffer Start Address
     * |        |          |The CTXDSA keeps the start address of TX frame buffer that is used by TXDMA currently.
     * |        |          |The CTXBSA is read only and write to this register has no effect.
    */
    __I  uint32_t CTXBSA;

    /**
     * CRXDSA
     * ===================================================================================================
     * Offset: 0xD4  Current Receive Descriptor Start Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CRXDSA    |Current Receive Descriptor Start Address
     * |        |          |The CRXDSA keeps the start address of RX descriptor that is used by RXDMA currently.
     * |        |          |The CRXDSA is read only and write to this register has no effect.
    */
    __I  uint32_t CRXDSA;

    /**
     * CRXBSA
     * ===================================================================================================
     * Offset: 0xD8  Current Receive Buffer Start Address Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |CRXBSA    |Current Receive Buffer Start Address
     * |        |          |The CRXBSA keeps the start address of RX frame buffer that is used by RXDMA currently.
     * |        |          |The CRXBSA is read only and write to this register has no effect.
    */
    __I  uint32_t CRXBSA;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE1[9];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * TSCTL
     * ===================================================================================================
     * Offset: 0x100  Time Stamp Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0]     |TSEN      |Time Stamp Function Enable Control
     * |        |          |This bit controls if the IEEE 1588 PTP time stamp function is enabled or not.
     * |        |          |Set this bit high to enable IEEE 1588 PTP time stamp function while set this bit low to disable IEEE 1588 PTP time stamp function.
     * |        |          |0 = I EEE 1588 PTP time stamp function Disabled.
     * |        |          |1 = IEEE 1588 PTP time stamp function Enabled.
     * |[1]     |TSIEN     |Time Stamp Counter Initialization Enable Control
     * |        |          |Set this bit high enables Ethernet MAC controller to load value of register EMAC_UPDSEC and EMAC_UPDSUBSEC to PTP time stamp counter.
     * |        |          |After the load operation finished, Ethernet MAC controller clear this bit to low automatically.
     * |        |          |0 = Time stamp counter initialization done.
     * |        |          |1 = Time stamp counter initialization Enabled.
     * |[2]     |TSMODE    |Time Stamp Fine Update Enable Control
     * |        |          |This bit chooses the time stamp counter update mode.
     * |        |          |0 = Time stamp counter is in coarse update mode.
     * |        |          |1 = Time stamp counter is in fine update mode.
     * |[3]     |TSUPDATE  |Time Stamp Counter Time Update Enable Control
     * |        |          |Set this bit high enables Ethernet MAC controller to add value of register EMAC_UPDSEC and EMAC_UPDSUBSEC to PTP time stamp counter.
     * |        |          |After the add operation finished, Ethernet MAC controller clear this bit to low automatically.
     * |        |          |0 = No action.
     * |        |          |1 = EMAC_UPDSEC updated to EMAC_TSSEC and EMAC_UPDSUBSEC updated to EMAC_TSSUBSEC.
     * |[5]     |TSALMEN   |Time Stamp Alarm Enable Control
     * |        |          |Set this bit high enable Ethernet MAC controller to set TSALMIF (EMAC_INTSTS[28]) high when EMAC_TSSEC equals to EMAC_ALMSEC and EMAC_TSSUBSEC equals to EMAC_ALMSUBSEC.
     * |        |          |0 = Alarm disabled when EMAC_TSSEC equals to EMAC_ALMSEC and EMAC_TSSUBSEC equals to EMAC_ALMSUBSEC.
     * |        |          |1 = Alarm enabled when EMAC_TSSEC equals to EMAC_ALMSEC and EMAC_TSSUBSEC equals to EMAC_ALMSUBSEC.
    */
    __IO uint32_t TSCTL;
    /// @cond HIDDEN_SYMBOLS
    uint32_t RESERVE2[3];
    /// @endcond //HIDDEN_SYMBOLS


    /**
     * TSSEC
     * ===================================================================================================
     * Offset: 0x110  Time Stamp Most Significant Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SEC       |Time Stamp Counter Second
     * |        |          |This register reflects the bit [63:32] value of 64-bit reference timing counter.
     * |        |          |This 32-bit value is used as the second part of time stamp when TSEN (EMAC_TSCTL[0]) is high.
    */
    __I  uint32_t TSSEC;

    /**
     * TSSUBSEC
     * ===================================================================================================
     * Offset: 0x114  Time Stamp Least Significant Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SUBSEC    |Time Stamp Counter Sub-Second
     * |        |          |This register reflects the bit [31:0] value of 64-bit reference timing counter.
     * |        |          |This 32-bit value is used as the sub-second part of time stamp when TSEN (EMAC_TSCTL[0]) is high.
    */
    __I  uint32_t TSSUBSEC;

    /**
     * TSINC
     * ===================================================================================================
     * Offset: 0x118  Time Stamp Increment Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:7]   |CNTINC    |Time Stamp Counter Increment
     * |        |          |Time stamp counter increment value.
     * |        |          |If TSEN (EMAC_TSCTL[0]) is high, EMAC adds EMAC_TSSUBSEC with this 8-bit value every time when it wants to increase the EMAC_TSSUBSEC value.
    */
    __IO uint32_t TSINC;

    /**
     * TSADDEND
     * ===================================================================================================
     * Offset: 0x11C  Time Stamp Addend Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |ADDEND    |Time Stamp Counter Addend
     * |        |          |This register keeps a 32-bit value for accumulator to enable increment of EMAC_TSSUBSEC.
     * |        |          |If TSEN (EMAC_TSCTL[0]) and TSMODE (EMAC_TSCTL[2]) are both high, EMAC increases accumulator with this 32-bit value in each HCLK.
     * |        |          |Once the accumulator is overflow, it generates a enable to increase EMAC_TSSUBSEC with an 8-bit value kept in register EMAC_TSINC.
    */
    __IO uint32_t TSADDEND;

    /**
     * UPDSEC
     * ===================================================================================================
     * Offset: 0x120  Time Stamp Most Significant Update Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SEC       |Time Stamp Counter Second Update
     * |        |          |When TSIEN (EMAC_TSCTL[1]) is high.
     * |        |          |EMAC loads this 32-bit value to EMAC_TSSEC directly.
     * |        |          |When TSUPDATE (EMAC_TSCTL[3]) is high, EMAC increases EMAC_TSSEC with this 32-bit value.
    */
    __IO uint32_t UPDSEC;

    /**
     * UPDSUBSEC
     * ===================================================================================================
     * Offset: 0x124  Time Stamp Least Significant Update Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SUBSEC    |Time Stamp Counter Sub-Second Update
     * |        |          |When TSIEN (EMAC_TSCTL[1]) is high.
     * |        |          |EMAC loads this 32-bit value to EMAC_TSSUBSEC directly.
     * |        |          |When TSUPDATE (EMAC_TSCTL[3]) is high, EMAC increases EMAC_TSSUBSEC with this 32-bit value.
    */
    __IO uint32_t UPDSUBSEC;

    /**
     * ALMSEC
     * ===================================================================================================
     * Offset: 0x128  Time Stamp Most Significant Alarm Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SEC       |Time Stamp Counter Second Alarm
     * |        |          |Time stamp counter second part alarm value.
     * |        |          |This value is only useful when ALMEN (EMAC_TSCTL[5]) high.
     * |        |          |If ALMEN (EMAC_TSCTL[5]) is high, EMAC_TSSEC equals to EMAC_ALMSEC and EMAC_TSSUBSEC equals to EMAC_ALMSUBSEC, Ethernet MAC controller set TSALMIF (EMAC_INTSTS[28]) high.
    */
    __IO uint32_t ALMSEC;

    /**
     * ALMSUBSEC
     * ===================================================================================================
     * Offset: 0x12C  Time Stamp Least Significant Alarm Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:31]  |SUBSEC    |Time Stamp Counter Sub-Second Alarm
     * |        |          |Time stamp counter sub-second part alarm value.
     * |        |          |This value is only useful when ALMEN (EMAC_TSCTL[5]) high.
     * |        |          |If ALMEN (EMAC_TSCTL[5]) is high, EMAC_TSSEC equals to EMAC_ALMSEC and EMAC_TSSUBSEC equals to EMAC_ALMSUBSEC, Ethernet MAC controller set TSALMIF (EMAC_INTSTS[28]) high.
    */
    __IO uint32_t ALMSUBSEC;

} EMAC_T;

/**
    @addtogroup EMAC_CONST EMAC Bit Field Definition
    Constant Definitions for EMAC Controller
@{ */

#define EMAC_CAMCTL_AUP_Pos              (0)                                               /*!< EMAC_T::CAMCTL: AUP Position              */
#define EMAC_CAMCTL_AUP_Msk              (0x1ul << EMAC_CAMCTL_AUP_Pos)                    /*!< EMAC_T::CAMCTL: AUP Mask                  */

#define EMAC_CAMCTL_AMP_Pos              (1)                                               /*!< EMAC_T::CAMCTL: AMP Position              */
#define EMAC_CAMCTL_AMP_Msk              (0x1ul << EMAC_CAMCTL_AMP_Pos)                    /*!< EMAC_T::CAMCTL: AMP Mask                  */

#define EMAC_CAMCTL_ABP_Pos              (2)                                               /*!< EMAC_T::CAMCTL: ABP Position              */
#define EMAC_CAMCTL_ABP_Msk              (0x1ul << EMAC_CAMCTL_ABP_Pos)                    /*!< EMAC_T::CAMCTL: ABP Mask                  */

#define EMAC_CAMCTL_COMPEN_Pos           (3)                                               /*!< EMAC_T::CAMCTL: COMPEN Position           */
#define EMAC_CAMCTL_COMPEN_Msk           (0x1ul << EMAC_CAMCTL_COMPEN_Pos)                 /*!< EMAC_T::CAMCTL: COMPEN Mask               */

#define EMAC_CAMCTL_CMPEN_Pos            (4)                                               /*!< EMAC_T::CAMCTL: CMPEN Position            */
#define EMAC_CAMCTL_CMPEN_Msk            (0x1ul << EMAC_CAMCTL_CMPEN_Pos)                  /*!< EMAC_T::CAMCTL: CMPEN Mask                */

#define EMAC_CAMEN_CAMxEN_Pos            (0)                                               /*!< EMAC_T::CAMEN: CAMxEN Position            */
#define EMAC_CAMEN_CAMxEN_Msk            (0x1ul << EMAC_CAMEN_CAMxEN_Pos)                  /*!< EMAC_T::CAMEN: CAMxEN Mask                */

#define EMAC_CAM0M_MACADDR2_Pos          (0)                                               /*!< EMAC_T::CAM0M: MACADDR2 Position          */
#define EMAC_CAM0M_MACADDR2_Msk          (0xfful << EMAC_CAM0M_MACADDR2_Pos)               /*!< EMAC_T::CAM0M: MACADDR2 Mask              */

#define EMAC_CAM0M_MACADDR3_Pos          (8)                                               /*!< EMAC_T::CAM0M: MACADDR3 Position          */
#define EMAC_CAM0M_MACADDR3_Msk          (0xfful << EMAC_CAM0M_MACADDR3_Pos)               /*!< EMAC_T::CAM0M: MACADDR3 Mask              */

#define EMAC_CAM0M_MACADDR4_Pos          (16)                                              /*!< EMAC_T::CAM0M: MACADDR4 Position          */
#define EMAC_CAM0M_MACADDR4_Msk          (0xfful << EMAC_CAM0M_MACADDR4_Pos)               /*!< EMAC_T::CAM0M: MACADDR4 Mask              */

#define EMAC_CAM0M_MACADDR5_Pos          (24)                                              /*!< EMAC_T::CAM0M: MACADDR5 Position          */
#define EMAC_CAM0M_MACADDR5_Msk          (0xfful << EMAC_CAM0M_MACADDR5_Pos)               /*!< EMAC_T::CAM0M: MACADDR5 Mask              */

#define EMAC_CAM0L_Rserved_Pos           (0)                                               /*!< EMAC_T::CAM0L: Rserved Position           */
#define EMAC_CAM0L_Rserved_Msk           (0xfffful << EMAC_CAM0L_Rserved_Pos)              /*!< EMAC_T::CAM0L: Rserved Mask               */

#define EMAC_CAM0L_MACADDR0_Pos          (16)                                              /*!< EMAC_T::CAM0L: MACADDR0 Position          */
#define EMAC_CAM0L_MACADDR0_Msk          (0xfful << EMAC_CAM0L_MACADDR0_Pos)               /*!< EMAC_T::CAM0L: MACADDR0 Mask              */

#define EMAC_CAM0L_MACADDR1_Pos          (24)                                              /*!< EMAC_T::CAM0L: MACADDR1 Position          */
#define EMAC_CAM0L_MACADDR1_Msk          (0xfful << EMAC_CAM0L_MACADDR1_Pos)               /*!< EMAC_T::CAM0L: MACADDR1 Mask              */

#define EMAC_CAM1M_MACADDR2_Pos          (0)                                               /*!< EMAC_T::CAM1M: MACADDR2 Position          */
#define EMAC_CAM1M_MACADDR2_Msk          (0xfful << EMAC_CAM1M_MACADDR2_Pos)               /*!< EMAC_T::CAM1M: MACADDR2 Mask              */

#define EMAC_CAM1M_MACADDR3_Pos          (8)                                               /*!< EMAC_T::CAM1M: MACADDR3 Position          */
#define EMAC_CAM1M_MACADDR3_Msk          (0xfful << EMAC_CAM1M_MACADDR3_Pos)               /*!< EMAC_T::CAM1M: MACADDR3 Mask              */

#define EMAC_CAM1M_MACADDR4_Pos          (16)                                              /*!< EMAC_T::CAM1M: MACADDR4 Position          */
#define EMAC_CAM1M_MACADDR4_Msk          (0xfful << EMAC_CAM1M_MACADDR4_Pos)               /*!< EMAC_T::CAM1M: MACADDR4 Mask              */

#define EMAC_CAM1M_MACADDR5_Pos          (24)                                              /*!< EMAC_T::CAM1M: MACADDR5 Position          */
#define EMAC_CAM1M_MACADDR5_Msk          (0xfful << EMAC_CAM1M_MACADDR5_Pos)               /*!< EMAC_T::CAM1M: MACADDR5 Mask              */

#define EMAC_CAM1L_Rserved_Pos           (0)                                               /*!< EMAC_T::CAM1L: Rserved Position           */
#define EMAC_CAM1L_Rserved_Msk           (0xfffful << EMAC_CAM1L_Rserved_Pos)              /*!< EMAC_T::CAM1L: Rserved Mask               */

#define EMAC_CAM1L_MACADDR0_Pos          (16)                                              /*!< EMAC_T::CAM1L: MACADDR0 Position          */
#define EMAC_CAM1L_MACADDR0_Msk          (0xfful << EMAC_CAM1L_MACADDR0_Pos)               /*!< EMAC_T::CAM1L: MACADDR0 Mask              */

#define EMAC_CAM1L_MACADDR1_Pos          (24)                                              /*!< EMAC_T::CAM1L: MACADDR1 Position          */
#define EMAC_CAM1L_MACADDR1_Msk          (0xfful << EMAC_CAM1L_MACADDR1_Pos)               /*!< EMAC_T::CAM1L: MACADDR1 Mask              */

#define EMAC_CAM2M_MACADDR2_Pos          (0)                                               /*!< EMAC_T::CAM2M: MACADDR2 Position          */
#define EMAC_CAM2M_MACADDR2_Msk          (0xfful << EMAC_CAM2M_MACADDR2_Pos)               /*!< EMAC_T::CAM2M: MACADDR2 Mask              */

#define EMAC_CAM2M_MACADDR3_Pos          (8)                                               /*!< EMAC_T::CAM2M: MACADDR3 Position          */
#define EMAC_CAM2M_MACADDR3_Msk          (0xfful << EMAC_CAM2M_MACADDR3_Pos)               /*!< EMAC_T::CAM2M: MACADDR3 Mask              */

#define EMAC_CAM2M_MACADDR4_Pos          (16)                                              /*!< EMAC_T::CAM2M: MACADDR4 Position          */
#define EMAC_CAM2M_MACADDR4_Msk          (0xfful << EMAC_CAM2M_MACADDR4_Pos)               /*!< EMAC_T::CAM2M: MACADDR4 Mask              */

#define EMAC_CAM2M_MACADDR5_Pos          (24)                                              /*!< EMAC_T::CAM2M: MACADDR5 Position          */
#define EMAC_CAM2M_MACADDR5_Msk          (0xfful << EMAC_CAM2M_MACADDR5_Pos)               /*!< EMAC_T::CAM2M: MACADDR5 Mask              */

#define EMAC_CAM2L_Rserved_Pos           (0)                                               /*!< EMAC_T::CAM2L: Rserved Position           */
#define EMAC_CAM2L_Rserved_Msk           (0xfffful << EMAC_CAM2L_Rserved_Pos)              /*!< EMAC_T::CAM2L: Rserved Mask               */

#define EMAC_CAM2L_MACADDR0_Pos          (16)                                              /*!< EMAC_T::CAM2L: MACADDR0 Position          */
#define EMAC_CAM2L_MACADDR0_Msk          (0xfful << EMAC_CAM2L_MACADDR0_Pos)               /*!< EMAC_T::CAM2L: MACADDR0 Mask              */

#define EMAC_CAM2L_MACADDR1_Pos          (24)                                              /*!< EMAC_T::CAM2L: MACADDR1 Position          */
#define EMAC_CAM2L_MACADDR1_Msk          (0xfful << EMAC_CAM2L_MACADDR1_Pos)               /*!< EMAC_T::CAM2L: MACADDR1 Mask              */

#define EMAC_CAM3M_MACADDR2_Pos          (0)                                               /*!< EMAC_T::CAM3M: MACADDR2 Position          */
#define EMAC_CAM3M_MACADDR2_Msk          (0xfful << EMAC_CAM3M_MACADDR2_Pos)               /*!< EMAC_T::CAM3M: MACADDR2 Mask              */

#define EMAC_CAM3M_MACADDR3_Pos          (8)                                               /*!< EMAC_T::CAM3M: MACADDR3 Position          */
#define EMAC_CAM3M_MACADDR3_Msk          (0xfful << EMAC_CAM3M_MACADDR3_Pos)               /*!< EMAC_T::CAM3M: MACADDR3 Mask              */

#define EMAC_CAM3M_MACADDR4_Pos          (16)                                              /*!< EMAC_T::CAM3M: MACADDR4 Position          */
#define EMAC_CAM3M_MACADDR4_Msk          (0xfful << EMAC_CAM3M_MACADDR4_Pos)               /*!< EMAC_T::CAM3M: MACADDR4 Mask              */

#define EMAC_CAM3M_MACADDR5_Pos          (24)                                              /*!< EMAC_T::CAM3M: MACADDR5 Position          */
#define EMAC_CAM3M_MACADDR5_Msk          (0xfful << EMAC_CAM3M_MACADDR5_Pos)               /*!< EMAC_T::CAM3M: MACADDR5 Mask              */

#define EMAC_CAM3L_Rserved_Pos           (0)                                               /*!< EMAC_T::CAM3L: Rserved Position           */
#define EMAC_CAM3L_Rserved_Msk           (0xfffful << EMAC_CAM3L_Rserved_Pos)              /*!< EMAC_T::CAM3L: Rserved Mask               */

#define EMAC_CAM3L_MACADDR0_Pos          (16)                                              /*!< EMAC_T::CAM3L: MACADDR0 Position          */
#define EMAC_CAM3L_MACADDR0_Msk          (0xfful << EMAC_CAM3L_MACADDR0_Pos)               /*!< EMAC_T::CAM3L: MACADDR0 Mask              */

#define EMAC_CAM3L_MACADDR1_Pos          (24)                                              /*!< EMAC_T::CAM3L: MACADDR1 Position          */
#define EMAC_CAM3L_MACADDR1_Msk          (0xfful << EMAC_CAM3L_MACADDR1_Pos)               /*!< EMAC_T::CAM3L: MACADDR1 Mask              */

#define EMAC_CAM4M_MACADDR2_Pos          (0)                                               /*!< EMAC_T::CAM4M: MACADDR2 Position          */
#define EMAC_CAM4M_MACADDR2_Msk          (0xfful << EMAC_CAM4M_MACADDR2_Pos)               /*!< EMAC_T::CAM4M: MACADDR2 Mask              */

#define EMAC_CAM4M_MACADDR3_Pos          (8)                                               /*!< EMAC_T::CAM4M: MACADDR3 Position          */
#define EMAC_CAM4M_MACADDR3_Msk          (0xfful << EMAC_CAM4M_MACADDR3_Pos)               /*!< EMAC_T::CAM4M: MACADDR3 Mask              */

#define EMAC_CAM4M_MACADDR4_Pos          (16)                                              /*!< EMAC_T::CAM4M: MACADDR4 Position          */
#define EMAC_CAM4M_MACADDR4_Msk          (0xfful << EMAC_CAM4M_MACADDR4_Pos)               /*!< EMAC_T::CAM4M: MACADDR4 Mask              */

#define EMAC_CAM4M_MACADDR5_Pos          (24)                                              /*!< EMAC_T::CAM4M: MACADDR5 Position          */
#define EMAC_CAM4M_MACADDR5_Msk          (0xfful << EMAC_CAM4M_MACADDR5_Pos)               /*!< EMAC_T::CAM4M: MACADDR5 Mask              */

#define EMAC_CAM4L_Rserved_Pos           (0)                                               /*!< EMAC_T::CAM4L: Rserved Position           */
#define EMAC_CAM4L_Rserved_Msk           (0xfffful << EMAC_CAM4L_Rserved_Pos)              /*!< EMAC_T::CAM4L: Rserved Mask               */

#define EMAC_CAM4L_MACADDR0_Pos          (16)                                              /*!< EMAC_T::CAM4L: MACADDR0 Position          */
#define EMAC_CAM4L_MACADDR0_Msk          (0xfful << EMAC_CAM4L_MACADDR0_Pos)               /*!< EMAC_T::CAM4L: MACADDR0 Mask              */

#define EMAC_CAM4L_MACADDR1_Pos          (24)                                              /*!< EMAC_T::CAM4L: MACADDR1 Position          */
#define EMAC_CAM4L_MACADDR1_Msk          (0xfful << EMAC_CAM4L_MACADDR1_Pos)               /*!< EMAC_T::CAM4L: MACADDR1 Mask              */

#define EMAC_CAM5M_MACADDR2_Pos          (0)                                               /*!< EMAC_T::CAM5M: MACADDR2 Position          */
#define EMAC_CAM5M_MACADDR2_Msk          (0xfful << EMAC_CAM5M_MACADDR2_Pos)               /*!< EMAC_T::CAM5M: MACADDR2 Mask              */

#define EMAC_CAM5M_MACADDR3_Pos          (8)                                               /*!< EMAC_T::CAM5M: MACADDR3 Position          */
#define EMAC_CAM5M_MACADDR3_Msk          (0xfful << EMAC_CAM5M_MACADDR3_Pos)               /*!< EMAC_T::CAM5M: MACADDR3 Mask              */

#define EMAC_CAM5M_MACADDR4_Pos          (16)                                              /*!< EMAC_T::CAM5M: MACADDR4 Position          */
#define EMAC_CAM5M_MACADDR4_Msk          (0xfful << EMAC_CAM5M_MACADDR4_Pos)               /*!< EMAC_T::CAM5M: MACADDR4 Mask              */

#define EMAC_CAM5M_MACADDR5_Pos          (24)                                              /*!< EMAC_T::CAM5M: MACADDR5 Position          */
#define EMAC_CAM5M_MACADDR5_Msk          (0xfful << EMAC_CAM5M_MACADDR5_Pos)               /*!< EMAC_T::CAM5M: MACADDR5 Mask              */

#define EMAC_CAM5L_Rserved_Pos           (0)                                               /*!< EMAC_T::CAM5L: Rserved Position           */
#define EMAC_CAM5L_Rserved_Msk           (0xfffful << EMAC_CAM5L_Rserved_Pos)              /*!< EMAC_T::CAM5L: Rserved Mask               */

#define EMAC_CAM5L_MACADDR0_Pos          (16)                                              /*!< EMAC_T::CAM5L: MACADDR0 Position          */
#define EMAC_CAM5L_MACADDR0_Msk          (0xfful << EMAC_CAM5L_MACADDR0_Pos)               /*!< EMAC_T::CAM5L: MACADDR0 Mask              */

#define EMAC_CAM5L_MACADDR1_Pos          (24)                                              /*!< EMAC_T::CAM5L: MACADDR1 Position          */
#define EMAC_CAM5L_MACADDR1_Msk          (0xfful << EMAC_CAM5L_MACADDR1_Pos)               /*!< EMAC_T::CAM5L: MACADDR1 Mask              */

#define EMAC_CAM6M_MACADDR2_Pos          (0)                                               /*!< EMAC_T::CAM6M: MACADDR2 Position          */
#define EMAC_CAM6M_MACADDR2_Msk          (0xfful << EMAC_CAM6M_MACADDR2_Pos)               /*!< EMAC_T::CAM6M: MACADDR2 Mask              */

#define EMAC_CAM6M_MACADDR3_Pos          (8)                                               /*!< EMAC_T::CAM6M: MACADDR3 Position          */
#define EMAC_CAM6M_MACADDR3_Msk          (0xfful << EMAC_CAM6M_MACADDR3_Pos)               /*!< EMAC_T::CAM6M: MACADDR3 Mask              */

#define EMAC_CAM6M_MACADDR4_Pos          (16)                                              /*!< EMAC_T::CAM6M: MACADDR4 Position          */
#define EMAC_CAM6M_MACADDR4_Msk          (0xfful << EMAC_CAM6M_MACADDR4_Pos)               /*!< EMAC_T::CAM6M: MACADDR4 Mask              */

#define EMAC_CAM6M_MACADDR5_Pos          (24)                                              /*!< EMAC_T::CAM6M: MACADDR5 Position          */
#define EMAC_CAM6M_MACADDR5_Msk          (0xfful << EMAC_CAM6M_MACADDR5_Pos)               /*!< EMAC_T::CAM6M: MACADDR5 Mask              */

#define EMAC_CAM6L_Rserved_Pos           (0)                                               /*!< EMAC_T::CAM6L: Rserved Position           */
#define EMAC_CAM6L_Rserved_Msk           (0xfffful << EMAC_CAM6L_Rserved_Pos)              /*!< EMAC_T::CAM6L: Rserved Mask               */

#define EMAC_CAM6L_MACADDR0_Pos          (16)                                              /*!< EMAC_T::CAM6L: MACADDR0 Position          */
#define EMAC_CAM6L_MACADDR0_Msk          (0xfful << EMAC_CAM6L_MACADDR0_Pos)               /*!< EMAC_T::CAM6L: MACADDR0 Mask              */

#define EMAC_CAM6L_MACADDR1_Pos          (24)                                              /*!< EMAC_T::CAM6L: MACADDR1 Position          */
#define EMAC_CAM6L_MACADDR1_Msk          (0xfful << EMAC_CAM6L_MACADDR1_Pos)               /*!< EMAC_T::CAM6L: MACADDR1 Mask              */

#define EMAC_CAM7M_MACADDR2_Pos          (0)                                               /*!< EMAC_T::CAM7M: MACADDR2 Position          */
#define EMAC_CAM7M_MACADDR2_Msk          (0xfful << EMAC_CAM7M_MACADDR2_Pos)               /*!< EMAC_T::CAM7M: MACADDR2 Mask              */

#define EMAC_CAM7M_MACADDR3_Pos          (8)                                               /*!< EMAC_T::CAM7M: MACADDR3 Position          */
#define EMAC_CAM7M_MACADDR3_Msk          (0xfful << EMAC_CAM7M_MACADDR3_Pos)               /*!< EMAC_T::CAM7M: MACADDR3 Mask              */

#define EMAC_CAM7M_MACADDR4_Pos          (16)                                              /*!< EMAC_T::CAM7M: MACADDR4 Position          */
#define EMAC_CAM7M_MACADDR4_Msk          (0xfful << EMAC_CAM7M_MACADDR4_Pos)               /*!< EMAC_T::CAM7M: MACADDR4 Mask              */

#define EMAC_CAM7M_MACADDR5_Pos          (24)                                              /*!< EMAC_T::CAM7M: MACADDR5 Position          */
#define EMAC_CAM7M_MACADDR5_Msk          (0xfful << EMAC_CAM7M_MACADDR5_Pos)               /*!< EMAC_T::CAM7M: MACADDR5 Mask              */

#define EMAC_CAM7L_Rserved_Pos           (0)                                               /*!< EMAC_T::CAM7L: Rserved Position           */
#define EMAC_CAM7L_Rserved_Msk           (0xfffful << EMAC_CAM7L_Rserved_Pos)              /*!< EMAC_T::CAM7L: Rserved Mask               */

#define EMAC_CAM7L_MACADDR0_Pos          (16)                                              /*!< EMAC_T::CAM7L: MACADDR0 Position          */
#define EMAC_CAM7L_MACADDR0_Msk          (0xfful << EMAC_CAM7L_MACADDR0_Pos)               /*!< EMAC_T::CAM7L: MACADDR0 Mask              */

#define EMAC_CAM7L_MACADDR1_Pos          (24)                                              /*!< EMAC_T::CAM7L: MACADDR1 Position          */
#define EMAC_CAM7L_MACADDR1_Msk          (0xfful << EMAC_CAM7L_MACADDR1_Pos)               /*!< EMAC_T::CAM7L: MACADDR1 Mask              */

#define EMAC_CAM8M_MACADDR2_Pos          (0)                                               /*!< EMAC_T::CAM8M: MACADDR2 Position          */
#define EMAC_CAM8M_MACADDR2_Msk          (0xfful << EMAC_CAM8M_MACADDR2_Pos)               /*!< EMAC_T::CAM8M: MACADDR2 Mask              */

#define EMAC_CAM8M_MACADDR3_Pos          (8)                                               /*!< EMAC_T::CAM8M: MACADDR3 Position          */
#define EMAC_CAM8M_MACADDR3_Msk          (0xfful << EMAC_CAM8M_MACADDR3_Pos)               /*!< EMAC_T::CAM8M: MACADDR3 Mask              */

#define EMAC_CAM8M_MACADDR4_Pos          (16)                                              /*!< EMAC_T::CAM8M: MACADDR4 Position          */
#define EMAC_CAM8M_MACADDR4_Msk          (0xfful << EMAC_CAM8M_MACADDR4_Pos)               /*!< EMAC_T::CAM8M: MACADDR4 Mask              */

#define EMAC_CAM8M_MACADDR5_Pos          (24)                                              /*!< EMAC_T::CAM8M: MACADDR5 Position          */
#define EMAC_CAM8M_MACADDR5_Msk          (0xfful << EMAC_CAM8M_MACADDR5_Pos)               /*!< EMAC_T::CAM8M: MACADDR5 Mask              */

#define EMAC_CAM8L_Rserved_Pos           (0)                                               /*!< EMAC_T::CAM8L: Rserved Position           */
#define EMAC_CAM8L_Rserved_Msk           (0xfffful << EMAC_CAM8L_Rserved_Pos)              /*!< EMAC_T::CAM8L: Rserved Mask               */

#define EMAC_CAM8L_MACADDR0_Pos          (16)                                              /*!< EMAC_T::CAM8L: MACADDR0 Position          */
#define EMAC_CAM8L_MACADDR0_Msk          (0xfful << EMAC_CAM8L_MACADDR0_Pos)               /*!< EMAC_T::CAM8L: MACADDR0 Mask              */

#define EMAC_CAM8L_MACADDR1_Pos          (24)                                              /*!< EMAC_T::CAM8L: MACADDR1 Position          */
#define EMAC_CAM8L_MACADDR1_Msk          (0xfful << EMAC_CAM8L_MACADDR1_Pos)               /*!< EMAC_T::CAM8L: MACADDR1 Mask              */

#define EMAC_CAM9M_MACADDR2_Pos          (0)                                               /*!< EMAC_T::CAM9M: MACADDR2 Position          */
#define EMAC_CAM9M_MACADDR2_Msk          (0xfful << EMAC_CAM9M_MACADDR2_Pos)               /*!< EMAC_T::CAM9M: MACADDR2 Mask              */

#define EMAC_CAM9M_MACADDR3_Pos          (8)                                               /*!< EMAC_T::CAM9M: MACADDR3 Position          */
#define EMAC_CAM9M_MACADDR3_Msk          (0xfful << EMAC_CAM9M_MACADDR3_Pos)               /*!< EMAC_T::CAM9M: MACADDR3 Mask              */

#define EMAC_CAM9M_MACADDR4_Pos          (16)                                              /*!< EMAC_T::CAM9M: MACADDR4 Position          */
#define EMAC_CAM9M_MACADDR4_Msk          (0xfful << EMAC_CAM9M_MACADDR4_Pos)               /*!< EMAC_T::CAM9M: MACADDR4 Mask              */

#define EMAC_CAM9M_MACADDR5_Pos          (24)                                              /*!< EMAC_T::CAM9M: MACADDR5 Position          */
#define EMAC_CAM9M_MACADDR5_Msk          (0xfful << EMAC_CAM9M_MACADDR5_Pos)               /*!< EMAC_T::CAM9M: MACADDR5 Mask              */

#define EMAC_CAM9L_Rserved_Pos           (0)                                               /*!< EMAC_T::CAM9L: Rserved Position           */
#define EMAC_CAM9L_Rserved_Msk           (0xfffful << EMAC_CAM9L_Rserved_Pos)              /*!< EMAC_T::CAM9L: Rserved Mask               */

#define EMAC_CAM9L_MACADDR0_Pos          (16)                                              /*!< EMAC_T::CAM9L: MACADDR0 Position          */
#define EMAC_CAM9L_MACADDR0_Msk          (0xfful << EMAC_CAM9L_MACADDR0_Pos)               /*!< EMAC_T::CAM9L: MACADDR0 Mask              */

#define EMAC_CAM9L_MACADDR1_Pos          (24)                                              /*!< EMAC_T::CAM9L: MACADDR1 Position          */
#define EMAC_CAM9L_MACADDR1_Msk          (0xfful << EMAC_CAM9L_MACADDR1_Pos)               /*!< EMAC_T::CAM9L: MACADDR1 Mask              */

#define EMAC_CAM10M_MACADDR2_Pos         (0)                                               /*!< EMAC_T::CAM10M: MACADDR2 Position         */
#define EMAC_CAM10M_MACADDR2_Msk         (0xfful << EMAC_CAM10M_MACADDR2_Pos)              /*!< EMAC_T::CAM10M: MACADDR2 Mask             */

#define EMAC_CAM10M_MACADDR3_Pos         (8)                                               /*!< EMAC_T::CAM10M: MACADDR3 Position         */
#define EMAC_CAM10M_MACADDR3_Msk         (0xfful << EMAC_CAM10M_MACADDR3_Pos)              /*!< EMAC_T::CAM10M: MACADDR3 Mask             */

#define EMAC_CAM10M_MACADDR4_Pos         (16)                                              /*!< EMAC_T::CAM10M: MACADDR4 Position         */
#define EMAC_CAM10M_MACADDR4_Msk         (0xfful << EMAC_CAM10M_MACADDR4_Pos)              /*!< EMAC_T::CAM10M: MACADDR4 Mask             */

#define EMAC_CAM10M_MACADDR5_Pos         (24)                                              /*!< EMAC_T::CAM10M: MACADDR5 Position         */
#define EMAC_CAM10M_MACADDR5_Msk         (0xfful << EMAC_CAM10M_MACADDR5_Pos)              /*!< EMAC_T::CAM10M: MACADDR5 Mask             */

#define EMAC_CAM10L_Rserved_Pos          (0)                                               /*!< EMAC_T::CAM10L: Rserved Position          */
#define EMAC_CAM10L_Rserved_Msk          (0xfffful << EMAC_CAM10L_Rserved_Pos)             /*!< EMAC_T::CAM10L: Rserved Mask              */

#define EMAC_CAM10L_MACADDR0_Pos         (16)                                              /*!< EMAC_T::CAM10L: MACADDR0 Position         */
#define EMAC_CAM10L_MACADDR0_Msk         (0xfful << EMAC_CAM10L_MACADDR0_Pos)              /*!< EMAC_T::CAM10L: MACADDR0 Mask             */

#define EMAC_CAM10L_MACADDR1_Pos         (24)                                              /*!< EMAC_T::CAM10L: MACADDR1 Position         */
#define EMAC_CAM10L_MACADDR1_Msk         (0xfful << EMAC_CAM10L_MACADDR1_Pos)              /*!< EMAC_T::CAM10L: MACADDR1 Mask             */

#define EMAC_CAM11M_MACADDR2_Pos         (0)                                               /*!< EMAC_T::CAM11M: MACADDR2 Position         */
#define EMAC_CAM11M_MACADDR2_Msk         (0xfful << EMAC_CAM11M_MACADDR2_Pos)              /*!< EMAC_T::CAM11M: MACADDR2 Mask             */

#define EMAC_CAM11M_MACADDR3_Pos         (8)                                               /*!< EMAC_T::CAM11M: MACADDR3 Position         */
#define EMAC_CAM11M_MACADDR3_Msk         (0xfful << EMAC_CAM11M_MACADDR3_Pos)              /*!< EMAC_T::CAM11M: MACADDR3 Mask             */

#define EMAC_CAM11M_MACADDR4_Pos         (16)                                              /*!< EMAC_T::CAM11M: MACADDR4 Position         */
#define EMAC_CAM11M_MACADDR4_Msk         (0xfful << EMAC_CAM11M_MACADDR4_Pos)              /*!< EMAC_T::CAM11M: MACADDR4 Mask             */

#define EMAC_CAM11M_MACADDR5_Pos         (24)                                              /*!< EMAC_T::CAM11M: MACADDR5 Position         */
#define EMAC_CAM11M_MACADDR5_Msk         (0xfful << EMAC_CAM11M_MACADDR5_Pos)              /*!< EMAC_T::CAM11M: MACADDR5 Mask             */

#define EMAC_CAM11L_Rserved_Pos          (0)                                               /*!< EMAC_T::CAM11L: Rserved Position          */
#define EMAC_CAM11L_Rserved_Msk          (0xfffful << EMAC_CAM11L_Rserved_Pos)             /*!< EMAC_T::CAM11L: Rserved Mask              */

#define EMAC_CAM11L_MACADDR0_Pos         (16)                                              /*!< EMAC_T::CAM11L: MACADDR0 Position         */
#define EMAC_CAM11L_MACADDR0_Msk         (0xfful << EMAC_CAM11L_MACADDR0_Pos)              /*!< EMAC_T::CAM11L: MACADDR0 Mask             */

#define EMAC_CAM11L_MACADDR1_Pos         (24)                                              /*!< EMAC_T::CAM11L: MACADDR1 Position         */
#define EMAC_CAM11L_MACADDR1_Msk         (0xfful << EMAC_CAM11L_MACADDR1_Pos)              /*!< EMAC_T::CAM11L: MACADDR1 Mask             */

#define EMAC_CAM12M_MACADDR2_Pos         (0)                                               /*!< EMAC_T::CAM12M: MACADDR2 Position         */
#define EMAC_CAM12M_MACADDR2_Msk         (0xfful << EMAC_CAM12M_MACADDR2_Pos)              /*!< EMAC_T::CAM12M: MACADDR2 Mask             */

#define EMAC_CAM12M_MACADDR3_Pos         (8)                                               /*!< EMAC_T::CAM12M: MACADDR3 Position         */
#define EMAC_CAM12M_MACADDR3_Msk         (0xfful << EMAC_CAM12M_MACADDR3_Pos)              /*!< EMAC_T::CAM12M: MACADDR3 Mask             */

#define EMAC_CAM12M_MACADDR4_Pos         (16)                                              /*!< EMAC_T::CAM12M: MACADDR4 Position         */
#define EMAC_CAM12M_MACADDR4_Msk         (0xfful << EMAC_CAM12M_MACADDR4_Pos)              /*!< EMAC_T::CAM12M: MACADDR4 Mask             */

#define EMAC_CAM12M_MACADDR5_Pos         (24)                                              /*!< EMAC_T::CAM12M: MACADDR5 Position         */
#define EMAC_CAM12M_MACADDR5_Msk         (0xfful << EMAC_CAM12M_MACADDR5_Pos)              /*!< EMAC_T::CAM12M: MACADDR5 Mask             */

#define EMAC_CAM12L_Rserved_Pos          (0)                                               /*!< EMAC_T::CAM12L: Rserved Position          */
#define EMAC_CAM12L_Rserved_Msk          (0xfffful << EMAC_CAM12L_Rserved_Pos)             /*!< EMAC_T::CAM12L: Rserved Mask              */

#define EMAC_CAM12L_MACADDR0_Pos         (16)                                              /*!< EMAC_T::CAM12L: MACADDR0 Position         */
#define EMAC_CAM12L_MACADDR0_Msk         (0xfful << EMAC_CAM12L_MACADDR0_Pos)              /*!< EMAC_T::CAM12L: MACADDR0 Mask             */

#define EMAC_CAM12L_MACADDR1_Pos         (24)                                              /*!< EMAC_T::CAM12L: MACADDR1 Position         */
#define EMAC_CAM12L_MACADDR1_Msk         (0xfful << EMAC_CAM12L_MACADDR1_Pos)              /*!< EMAC_T::CAM12L: MACADDR1 Mask             */

#define EMAC_CAM13M_MACADDR2_Pos         (0)                                               /*!< EMAC_T::CAM13M: MACADDR2 Position         */
#define EMAC_CAM13M_MACADDR2_Msk         (0xfful << EMAC_CAM13M_MACADDR2_Pos)              /*!< EMAC_T::CAM13M: MACADDR2 Mask             */

#define EMAC_CAM13M_MACADDR3_Pos         (8)                                               /*!< EMAC_T::CAM13M: MACADDR3 Position         */
#define EMAC_CAM13M_MACADDR3_Msk         (0xfful << EMAC_CAM13M_MACADDR3_Pos)              /*!< EMAC_T::CAM13M: MACADDR3 Mask             */

#define EMAC_CAM13M_MACADDR4_Pos         (16)                                              /*!< EMAC_T::CAM13M: MACADDR4 Position         */
#define EMAC_CAM13M_MACADDR4_Msk         (0xfful << EMAC_CAM13M_MACADDR4_Pos)              /*!< EMAC_T::CAM13M: MACADDR4 Mask             */

#define EMAC_CAM13M_MACADDR5_Pos         (24)                                              /*!< EMAC_T::CAM13M: MACADDR5 Position         */
#define EMAC_CAM13M_MACADDR5_Msk         (0xfful << EMAC_CAM13M_MACADDR5_Pos)              /*!< EMAC_T::CAM13M: MACADDR5 Mask             */

#define EMAC_CAM13L_Rserved_Pos          (0)                                               /*!< EMAC_T::CAM13L: Rserved Position          */
#define EMAC_CAM13L_Rserved_Msk          (0xfffful << EMAC_CAM13L_Rserved_Pos)             /*!< EMAC_T::CAM13L: Rserved Mask              */

#define EMAC_CAM13L_MACADDR0_Pos         (16)                                              /*!< EMAC_T::CAM13L: MACADDR0 Position         */
#define EMAC_CAM13L_MACADDR0_Msk         (0xfful << EMAC_CAM13L_MACADDR0_Pos)              /*!< EMAC_T::CAM13L: MACADDR0 Mask             */

#define EMAC_CAM13L_MACADDR1_Pos         (24)                                              /*!< EMAC_T::CAM13L: MACADDR1 Position         */
#define EMAC_CAM13L_MACADDR1_Msk         (0xfful << EMAC_CAM13L_MACADDR1_Pos)              /*!< EMAC_T::CAM13L: MACADDR1 Mask             */

#define EMAC_CAM14M_MACADDR2_Pos         (0)                                               /*!< EMAC_T::CAM14M: MACADDR2 Position         */
#define EMAC_CAM14M_MACADDR2_Msk         (0xfful << EMAC_CAM14M_MACADDR2_Pos)              /*!< EMAC_T::CAM14M: MACADDR2 Mask             */

#define EMAC_CAM14M_MACADDR3_Pos         (8)                                               /*!< EMAC_T::CAM14M: MACADDR3 Position         */
#define EMAC_CAM14M_MACADDR3_Msk         (0xfful << EMAC_CAM14M_MACADDR3_Pos)              /*!< EMAC_T::CAM14M: MACADDR3 Mask             */

#define EMAC_CAM14M_MACADDR4_Pos         (16)                                              /*!< EMAC_T::CAM14M: MACADDR4 Position         */
#define EMAC_CAM14M_MACADDR4_Msk         (0xfful << EMAC_CAM14M_MACADDR4_Pos)              /*!< EMAC_T::CAM14M: MACADDR4 Mask             */

#define EMAC_CAM14M_MACADDR5_Pos         (24)                                              /*!< EMAC_T::CAM14M: MACADDR5 Position         */
#define EMAC_CAM14M_MACADDR5_Msk         (0xfful << EMAC_CAM14M_MACADDR5_Pos)              /*!< EMAC_T::CAM14M: MACADDR5 Mask             */

#define EMAC_CAM14L_Rserved_Pos          (0)                                               /*!< EMAC_T::CAM14L: Rserved Position          */
#define EMAC_CAM14L_Rserved_Msk          (0xfffful << EMAC_CAM14L_Rserved_Pos)             /*!< EMAC_T::CAM14L: Rserved Mask              */

#define EMAC_CAM14L_MACADDR0_Pos         (16)                                              /*!< EMAC_T::CAM14L: MACADDR0 Position         */
#define EMAC_CAM14L_MACADDR0_Msk         (0xfful << EMAC_CAM14L_MACADDR0_Pos)              /*!< EMAC_T::CAM14L: MACADDR0 Mask             */

#define EMAC_CAM14L_MACADDR1_Pos         (24)                                              /*!< EMAC_T::CAM14L: MACADDR1 Position         */
#define EMAC_CAM14L_MACADDR1_Msk         (0xfful << EMAC_CAM14L_MACADDR1_Pos)              /*!< EMAC_T::CAM14L: MACADDR1 Mask             */

#define EMAC_CAM15MSB_OPCODE_Pos         (0)                                               /*!< EMAC_T::CAM15MSB: OPCODE Position         */
#define EMAC_CAM15MSB_OPCODE_Msk         (0xfffful << EMAC_CAM15MSB_OPCODE_Pos)            /*!< EMAC_T::CAM15MSB: OPCODE Mask             */

#define EMAC_CAM15MSB_LENGTH_Pos         (16)                                              /*!< EMAC_T::CAM15MSB: LENGTH Position         */
#define EMAC_CAM15MSB_LENGTH_Msk         (0xfffful << EMAC_CAM15MSB_LENGTH_Pos)            /*!< EMAC_T::CAM15MSB: LENGTH Mask             */

#define EMAC_CAM15LSB_OPERAND_Pos        (24)                                              /*!< EMAC_T::CAM15LSB: OPERAND Position        */
#define EMAC_CAM15LSB_OPERAND_Msk        (0xfful << EMAC_CAM15LSB_OPERAND_Pos)             /*!< EMAC_T::CAM15LSB: OPERAND Mask            */

#define EMAC_TXDSA_TXDSA_Pos             (0)                                               /*!< EMAC_T::TXDSA: TXDSA Position             */
#define EMAC_TXDSA_TXDSA_Msk             (0xfffffffful << EMAC_TXDSA_TXDSA_Pos)            /*!< EMAC_T::TXDSA: TXDSA Mask                 */

#define EMAC_RXDSA_RXDSA_Pos             (0)                                               /*!< EMAC_T::RXDSA: RXDSA Position             */
#define EMAC_RXDSA_RXDSA_Msk             (0xfffffffful << EMAC_RXDSA_RXDSA_Pos)            /*!< EMAC_T::RXDSA: RXDSA Mask                 */

#define EMAC_CTL_RXON_Pos                (0)                                               /*!< EMAC_T::CTL: RXON Position                */
#define EMAC_CTL_RXON_Msk                (0x1ul << EMAC_CTL_RXON_Pos)                      /*!< EMAC_T::CTL: RXON Mask                    */

#define EMAC_CTL_ALP_Pos                 (1)                                               /*!< EMAC_T::CTL: ALP Position                 */
#define EMAC_CTL_ALP_Msk                 (0x1ul << EMAC_CTL_ALP_Pos)                       /*!< EMAC_T::CTL: ALP Mask                     */

#define EMAC_CTL_ARP_Pos                 (2)                                               /*!< EMAC_T::CTL: ARP Position                 */
#define EMAC_CTL_ARP_Msk                 (0x1ul << EMAC_CTL_ARP_Pos)                       /*!< EMAC_T::CTL: ARP Mask                     */

#define EMAC_CTL_ACP_Pos                 (3)                                               /*!< EMAC_T::CTL: ACP Position                 */
#define EMAC_CTL_ACP_Msk                 (0x1ul << EMAC_CTL_ACP_Pos)                       /*!< EMAC_T::CTL: ACP Mask                     */

#define EMAC_CTL_AEP_Pos                 (4)                                               /*!< EMAC_T::CTL: AEP Position                 */
#define EMAC_CTL_AEP_Msk                 (0x1ul << EMAC_CTL_AEP_Pos)                       /*!< EMAC_T::CTL: AEP Mask                     */

#define EMAC_CTL_STRIPCRC_Pos            (5)                                               /*!< EMAC_T::CTL: STRIPCRC Position            */
#define EMAC_CTL_STRIPCRC_Msk            (0x1ul << EMAC_CTL_STRIPCRC_Pos)                  /*!< EMAC_T::CTL: STRIPCRC Mask                */

#define EMAC_CTL_WOLEN_Pos               (6)                                               /*!< EMAC_T::CTL: WOLEN Position               */
#define EMAC_CTL_WOLEN_Msk               (0x1ul << EMAC_CTL_WOLEN_Pos)                     /*!< EMAC_T::CTL: WOLEN Mask                   */

#define EMAC_CTL_TXON_Pos                (8)                                               /*!< EMAC_T::CTL: TXON Position                */
#define EMAC_CTL_TXON_Msk                (0x1ul << EMAC_CTL_TXON_Pos)                      /*!< EMAC_T::CTL: TXON Mask                    */

#define EMAC_CTL_NODEF_Pos               (9)                                               /*!< EMAC_T::CTL: NODEF Position               */
#define EMAC_CTL_NODEF_Msk               (0x1ul << EMAC_CTL_NODEF_Pos)                     /*!< EMAC_T::CTL: NODEF Mask                   */

#define EMAC_CTL_SDPZ_Pos                (16)                                              /*!< EMAC_T::CTL: SDPZ Position                */
#define EMAC_CTL_SDPZ_Msk                (0x1ul << EMAC_CTL_SDPZ_Pos)                      /*!< EMAC_T::CTL: SDPZ Mask                    */

#define EMAC_CTL_SQECHKEN_Pos            (17)                                              /*!< EMAC_T::CTL: SQECHKEN Position            */
#define EMAC_CTL_SQECHKEN_Msk            (0x1ul << EMAC_CTL_SQECHKEN_Pos)                  /*!< EMAC_T::CTL: SQECHKEN Mask                */

#define EMAC_CTL_FUDUP_Pos               (18)                                              /*!< EMAC_T::CTL: FUDUP Position               */
#define EMAC_CTL_FUDUP_Msk               (0x1ul << EMAC_CTL_FUDUP_Pos)                     /*!< EMAC_T::CTL: FUDUP Mask                   */

#define EMAC_CTL_RMIIRXCTL_Pos           (19)                                              /*!< EMAC_T::CTL: RMIIRXCTL Position           */
#define EMAC_CTL_RMIIRXCTL_Msk           (0x1ul << EMAC_CTL_RMIIRXCTL_Pos)                 /*!< EMAC_T::CTL: RMIIRXCTL Mask               */

#define EMAC_CTL_OPMODE_Pos              (20)                                              /*!< EMAC_T::CTL: OPMODE Position              */
#define EMAC_CTL_OPMODE_Msk              (0x1ul << EMAC_CTL_OPMODE_Pos)                    /*!< EMAC_T::CTL: OPMODE Mask                  */

#define EMAC_CTL_RMIIEN_Pos              (22)                                              /*!< EMAC_T::CTL: RMIIEN Position              */
#define EMAC_CTL_RMIIEN_Msk              (0x1ul << EMAC_CTL_RMIIEN_Pos)                    /*!< EMAC_T::CTL: RMIIEN Mask                  */

#define EMAC_CTL_RST_Pos                 (24)                                              /*!< EMAC_T::CTL: RST Position                 */
#define EMAC_CTL_RST_Msk                 (0x1ul << EMAC_CTL_RST_Pos)                       /*!< EMAC_T::CTL: RST Mask                     */

#define EMAC_MIIMDAT_DATA_Pos            (0)                                               /*!< EMAC_T::MIIMDAT: DATA Position            */
#define EMAC_MIIMDAT_DATA_Msk            (0xfffful << EMAC_MIIMDAT_DATA_Pos)               /*!< EMAC_T::MIIMDAT: DATA Mask                */

#define EMAC_MIIMCTL_PHYREG_Pos          (0)                                               /*!< EMAC_T::MIIMCTL: PHYREG Position          */
#define EMAC_MIIMCTL_PHYREG_Msk          (0x1ful << EMAC_MIIMCTL_PHYREG_Pos)               /*!< EMAC_T::MIIMCTL: PHYREG Mask              */

#define EMAC_MIIMCTL_PHYADDR_Pos         (8)                                               /*!< EMAC_T::MIIMCTL: PHYADDR Position         */
#define EMAC_MIIMCTL_PHYADDR_Msk         (0x1ful << EMAC_MIIMCTL_PHYADDR_Pos)              /*!< EMAC_T::MIIMCTL: PHYADDR Mask             */

#define EMAC_MIIMCTL_WRITE_Pos           (16)                                              /*!< EMAC_T::MIIMCTL: WRITE Position           */
#define EMAC_MIIMCTL_WRITE_Msk           (0x1ul << EMAC_MIIMCTL_WRITE_Pos)                 /*!< EMAC_T::MIIMCTL: WRITE Mask               */

#define EMAC_MIIMCTL_BUSY_Pos            (17)                                              /*!< EMAC_T::MIIMCTL: BUSY Position            */
#define EMAC_MIIMCTL_BUSY_Msk            (0x1ul << EMAC_MIIMCTL_BUSY_Pos)                  /*!< EMAC_T::MIIMCTL: BUSY Mask                */

#define EMAC_MIIMCTL_PREAMSP_Pos         (18)                                              /*!< EMAC_T::MIIMCTL: PREAMSP Position         */
#define EMAC_MIIMCTL_PREAMSP_Msk         (0x1ul << EMAC_MIIMCTL_PREAMSP_Pos)               /*!< EMAC_T::MIIMCTL: PREAMSP Mask             */

#define EMAC_MIIMCTL_MDCON_Pos           (19)                                              /*!< EMAC_T::MIIMCTL: MDCON Position           */
#define EMAC_MIIMCTL_MDCON_Msk           (0x1ul << EMAC_MIIMCTL_MDCON_Pos)                 /*!< EMAC_T::MIIMCTL: MDCON Mask               */

#define EMAC_FIFOCTL_RXFIFOTH_Pos        (0)                                               /*!< EMAC_T::FIFOCTL: RXFIFOTH Position        */
#define EMAC_FIFOCTL_RXFIFOTH_Msk        (0x3ul << EMAC_FIFOCTL_RXFIFOTH_Pos)              /*!< EMAC_T::FIFOCTL: RXFIFOTH Mask            */

#define EMAC_FIFOCTL_TXFIFOTH_Pos        (8)                                               /*!< EMAC_T::FIFOCTL: TXFIFOTH Position        */
#define EMAC_FIFOCTL_TXFIFOTH_Msk        (0x3ul << EMAC_FIFOCTL_TXFIFOTH_Pos)              /*!< EMAC_T::FIFOCTL: TXFIFOTH Mask            */

#define EMAC_FIFOCTL_BURSTLEN_Pos        (20)                                              /*!< EMAC_T::FIFOCTL: BURSTLEN Position        */
#define EMAC_FIFOCTL_BURSTLEN_Msk        (0x3ul << EMAC_FIFOCTL_BURSTLEN_Pos)              /*!< EMAC_T::FIFOCTL: BURSTLEN Mask            */

#define EMAC_TXST_TXST_Pos               (0)                                               /*!< EMAC_T::TXST: TXST Position               */
#define EMAC_TXST_TXST_Msk               (0xfffffffful << EMAC_TXST_TXST_Pos)              /*!< EMAC_T::TXST: TXST Mask                   */

#define EMAC_RXST_RXST_Pos               (0)                                               /*!< EMAC_T::RXST: RXST Position               */
#define EMAC_RXST_RXST_Msk               (0xfffffffful << EMAC_RXST_RXST_Pos)              /*!< EMAC_T::RXST: RXST Mask                   */

#define EMAC_MRFL_MRFL_Pos               (0)                                               /*!< EMAC_T::MRFL: MRFL Position               */
#define EMAC_MRFL_MRFL_Msk               (0xfffful << EMAC_MRFL_MRFL_Pos)                  /*!< EMAC_T::MRFL: MRFL Mask                   */

#define EMAC_INTEN_RXIEN_Pos             (0)                                               /*!< EMAC_T::INTEN: RXIEN Position             */
#define EMAC_INTEN_RXIEN_Msk             (0x1ul << EMAC_INTEN_RXIEN_Pos)                   /*!< EMAC_T::INTEN: RXIEN Mask                 */

#define EMAC_INTEN_CRCEIEN_Pos           (1)                                               /*!< EMAC_T::INTEN: CRCEIEN Position           */
#define EMAC_INTEN_CRCEIEN_Msk           (0x1ul << EMAC_INTEN_CRCEIEN_Pos)                 /*!< EMAC_T::INTEN: CRCEIEN Mask               */

#define EMAC_INTEN_RXOVIEN_Pos           (2)                                               /*!< EMAC_T::INTEN: RXOVIEN Position           */
#define EMAC_INTEN_RXOVIEN_Msk           (0x1ul << EMAC_INTEN_RXOVIEN_Pos)                 /*!< EMAC_T::INTEN: RXOVIEN Mask               */

#define EMAC_INTEN_LPIEN_Pos             (3)                                               /*!< EMAC_T::INTEN: LPIEN Position             */
#define EMAC_INTEN_LPIEN_Msk             (0x1ul << EMAC_INTEN_LPIEN_Pos)                   /*!< EMAC_T::INTEN: LPIEN Mask                 */

#define EMAC_INTEN_RXGDIEN_Pos           (4)                                               /*!< EMAC_T::INTEN: RXGDIEN Position           */
#define EMAC_INTEN_RXGDIEN_Msk           (0x1ul << EMAC_INTEN_RXGDIEN_Pos)                 /*!< EMAC_T::INTEN: RXGDIEN Mask               */

#define EMAC_INTEN_ALIEIEN_Pos           (5)                                               /*!< EMAC_T::INTEN: ALIEIEN Position           */
#define EMAC_INTEN_ALIEIEN_Msk           (0x1ul << EMAC_INTEN_ALIEIEN_Pos)                 /*!< EMAC_T::INTEN: ALIEIEN Mask               */

#define EMAC_INTEN_RPIEN_Pos             (6)                                               /*!< EMAC_T::INTEN: RPIEN Position             */
#define EMAC_INTEN_RPIEN_Msk             (0x1ul << EMAC_INTEN_RPIEN_Pos)                   /*!< EMAC_T::INTEN: RPIEN Mask                 */

#define EMAC_INTEN_MPCOVIEN_Pos          (7)                                               /*!< EMAC_T::INTEN: MPCOVIEN Position          */
#define EMAC_INTEN_MPCOVIEN_Msk          (0x1ul << EMAC_INTEN_MPCOVIEN_Pos)                /*!< EMAC_T::INTEN: MPCOVIEN Mask              */

#define EMAC_INTEN_MFLEIEN_Pos           (8)                                               /*!< EMAC_T::INTEN: MFLEIEN Position           */
#define EMAC_INTEN_MFLEIEN_Msk           (0x1ul << EMAC_INTEN_MFLEIEN_Pos)                 /*!< EMAC_T::INTEN: MFLEIEN Mask               */

#define EMAC_INTEN_DENIEN_Pos            (9)                                               /*!< EMAC_T::INTEN: DENIEN Position            */
#define EMAC_INTEN_DENIEN_Msk            (0x1ul << EMAC_INTEN_DENIEN_Pos)                  /*!< EMAC_T::INTEN: DENIEN Mask                */

#define EMAC_INTEN_RDUIEN_Pos            (10)                                              /*!< EMAC_T::INTEN: RDUIEN Position            */
#define EMAC_INTEN_RDUIEN_Msk            (0x1ul << EMAC_INTEN_RDUIEN_Pos)                  /*!< EMAC_T::INTEN: RDUIEN Mask                */

#define EMAC_INTEN_RXBEIEN_Pos           (11)                                              /*!< EMAC_T::INTEN: RXBEIEN Position           */
#define EMAC_INTEN_RXBEIEN_Msk           (0x1ul << EMAC_INTEN_RXBEIEN_Pos)                 /*!< EMAC_T::INTEN: RXBEIEN Mask               */

#define EMAC_INTEN_CFRIEN_Pos            (14)                                              /*!< EMAC_T::INTEN: CFRIEN Position            */
#define EMAC_INTEN_CFRIEN_Msk            (0x1ul << EMAC_INTEN_CFRIEN_Pos)                  /*!< EMAC_T::INTEN: CFRIEN Mask                */

#define EMAC_INTEN_WOLIEN_Pos            (15)                                              /*!< EMAC_T::INTEN: WOLIEN Position            */
#define EMAC_INTEN_WOLIEN_Msk            (0x1ul << EMAC_INTEN_WOLIEN_Pos)                  /*!< EMAC_T::INTEN: WOLIEN Mask                */

#define EMAC_INTEN_TXIEN_Pos             (16)                                              /*!< EMAC_T::INTEN: TXIEN Position             */
#define EMAC_INTEN_TXIEN_Msk             (0x1ul << EMAC_INTEN_TXIEN_Pos)                   /*!< EMAC_T::INTEN: TXIEN Mask                 */

#define EMAC_INTEN_TXUDIEN_Pos           (17)                                              /*!< EMAC_T::INTEN: TXUDIEN Position           */
#define EMAC_INTEN_TXUDIEN_Msk           (0x1ul << EMAC_INTEN_TXUDIEN_Pos)                 /*!< EMAC_T::INTEN: TXUDIEN Mask               */

#define EMAC_INTEN_TXCPIEN_Pos           (18)                                              /*!< EMAC_T::INTEN: TXCPIEN Position           */
#define EMAC_INTEN_TXCPIEN_Msk           (0x1ul << EMAC_INTEN_TXCPIEN_Pos)                 /*!< EMAC_T::INTEN: TXCPIEN Mask               */

#define EMAC_INTEN_EXDEFIEN_Pos          (19)                                              /*!< EMAC_T::INTEN: EXDEFIEN Position          */
#define EMAC_INTEN_EXDEFIEN_Msk          (0x1ul << EMAC_INTEN_EXDEFIEN_Pos)                /*!< EMAC_T::INTEN: EXDEFIEN Mask              */

#define EMAC_INTEN_NCSIEN_Pos            (20)                                              /*!< EMAC_T::INTEN: NCSIEN Position            */
#define EMAC_INTEN_NCSIEN_Msk            (0x1ul << EMAC_INTEN_NCSIEN_Pos)                  /*!< EMAC_T::INTEN: NCSIEN Mask                */

#define EMAC_INTEN_TXABTIEN_Pos          (21)                                              /*!< EMAC_T::INTEN: TXABTIEN Position          */
#define EMAC_INTEN_TXABTIEN_Msk          (0x1ul << EMAC_INTEN_TXABTIEN_Pos)                /*!< EMAC_T::INTEN: TXABTIEN Mask              */

#define EMAC_INTEN_LCIEN_Pos             (22)                                              /*!< EMAC_T::INTEN: LCIEN Position             */
#define EMAC_INTEN_LCIEN_Msk             (0x1ul << EMAC_INTEN_LCIEN_Pos)                   /*!< EMAC_T::INTEN: LCIEN Mask                 */

#define EMAC_INTEN_TDUIEN_Pos            (23)                                              /*!< EMAC_T::INTEN: TDUIEN Position            */
#define EMAC_INTEN_TDUIEN_Msk            (0x1ul << EMAC_INTEN_TDUIEN_Pos)                  /*!< EMAC_T::INTEN: TDUIEN Mask                */

#define EMAC_INTEN_TXBEIEN_Pos           (24)                                              /*!< EMAC_T::INTEN: TXBEIEN Position           */
#define EMAC_INTEN_TXBEIEN_Msk           (0x1ul << EMAC_INTEN_TXBEIEN_Pos)                 /*!< EMAC_T::INTEN: TXBEIEN Mask               */

#define EMAC_INTEN_TSALMIEN_Pos          (28)                                              /*!< EMAC_T::INTEN: TSALMIEN Position          */
#define EMAC_INTEN_TSALMIEN_Msk          (0x1ul << EMAC_INTEN_TSALMIEN_Pos)                /*!< EMAC_T::INTEN: TSALMIEN Mask              */

#define EMAC_INTSTS_RXIF_Pos             (0)                                               /*!< EMAC_T::INTSTS: RXIF Position             */
#define EMAC_INTSTS_RXIF_Msk             (0x1ul << EMAC_INTSTS_RXIF_Pos)                   /*!< EMAC_T::INTSTS: RXIF Mask                 */

#define EMAC_INTSTS_CRCEIF_Pos           (1)                                               /*!< EMAC_T::INTSTS: CRCEIF Position           */
#define EMAC_INTSTS_CRCEIF_Msk           (0x1ul << EMAC_INTSTS_CRCEIF_Pos)                 /*!< EMAC_T::INTSTS: CRCEIF Mask               */

#define EMAC_INTSTS_RXOVIF_Pos           (2)                                               /*!< EMAC_T::INTSTS: RXOVIF Position           */
#define EMAC_INTSTS_RXOVIF_Msk           (0x1ul << EMAC_INTSTS_RXOVIF_Pos)                 /*!< EMAC_T::INTSTS: RXOVIF Mask               */

#define EMAC_INTSTS_LPIF_Pos             (3)                                               /*!< EMAC_T::INTSTS: LPIF Position             */
#define EMAC_INTSTS_LPIF_Msk             (0x1ul << EMAC_INTSTS_LPIF_Pos)                   /*!< EMAC_T::INTSTS: LPIF Mask                 */

#define EMAC_INTSTS_RXGDIF_Pos           (4)                                               /*!< EMAC_T::INTSTS: RXGDIF Position           */
#define EMAC_INTSTS_RXGDIF_Msk           (0x1ul << EMAC_INTSTS_RXGDIF_Pos)                 /*!< EMAC_T::INTSTS: RXGDIF Mask               */

#define EMAC_INTSTS_ALIEIF_Pos           (5)                                               /*!< EMAC_T::INTSTS: ALIEIF Position           */
#define EMAC_INTSTS_ALIEIF_Msk           (0x1ul << EMAC_INTSTS_ALIEIF_Pos)                 /*!< EMAC_T::INTSTS: ALIEIF Mask               */

#define EMAC_INTSTS_RPIF_Pos             (6)                                               /*!< EMAC_T::INTSTS: RPIF Position             */
#define EMAC_INTSTS_RPIF_Msk             (0x1ul << EMAC_INTSTS_RPIF_Pos)                   /*!< EMAC_T::INTSTS: RPIF Mask                 */

#define EMAC_INTSTS_MPCOVIF_Pos          (7)                                               /*!< EMAC_T::INTSTS: MPCOVIF Position          */
#define EMAC_INTSTS_MPCOVIF_Msk          (0x1ul << EMAC_INTSTS_MPCOVIF_Pos)                /*!< EMAC_T::INTSTS: MPCOVIF Mask              */

#define EMAC_INTSTS_MFLEIF_Pos           (8)                                               /*!< EMAC_T::INTSTS: MFLEIF Position           */
#define EMAC_INTSTS_MFLEIF_Msk           (0x1ul << EMAC_INTSTS_MFLEIF_Pos)                 /*!< EMAC_T::INTSTS: MFLEIF Mask               */

#define EMAC_INTSTS_DENIF_Pos            (9)                                               /*!< EMAC_T::INTSTS: DENIF Position            */
#define EMAC_INTSTS_DENIF_Msk            (0x1ul << EMAC_INTSTS_DENIF_Pos)                  /*!< EMAC_T::INTSTS: DENIF Mask                */

#define EMAC_INTSTS_RDUIF_Pos            (10)                                              /*!< EMAC_T::INTSTS: RDUIF Position            */
#define EMAC_INTSTS_RDUIF_Msk            (0x1ul << EMAC_INTSTS_RDUIF_Pos)                  /*!< EMAC_T::INTSTS: RDUIF Mask                */

#define EMAC_INTSTS_RXBEIF_Pos           (11)                                              /*!< EMAC_T::INTSTS: RXBEIF Position           */
#define EMAC_INTSTS_RXBEIF_Msk           (0x1ul << EMAC_INTSTS_RXBEIF_Pos)                 /*!< EMAC_T::INTSTS: RXBEIF Mask               */

#define EMAC_INTSTS_CFRIF_Pos            (14)                                              /*!< EMAC_T::INTSTS: CFRIF Position            */
#define EMAC_INTSTS_CFRIF_Msk            (0x1ul << EMAC_INTSTS_CFRIF_Pos)                  /*!< EMAC_T::INTSTS: CFRIF Mask                */

#define EMAC_INTSTS_WOLIF_Pos            (15)                                              /*!< EMAC_T::INTSTS: WOLIF Position            */
#define EMAC_INTSTS_WOLIF_Msk            (0x1ul << EMAC_INTSTS_WOLIF_Pos)                  /*!< EMAC_T::INTSTS: WOLIF Mask                */

#define EMAC_INTSTS_TXIF_Pos             (16)                                              /*!< EMAC_T::INTSTS: TXIF Position             */
#define EMAC_INTSTS_TXIF_Msk             (0x1ul << EMAC_INTSTS_TXIF_Pos)                   /*!< EMAC_T::INTSTS: TXIF Mask                 */

#define EMAC_INTSTS_TXUDIF_Pos           (17)                                              /*!< EMAC_T::INTSTS: TXUDIF Position           */
#define EMAC_INTSTS_TXUDIF_Msk           (0x1ul << EMAC_INTSTS_TXUDIF_Pos)                 /*!< EMAC_T::INTSTS: TXUDIF Mask               */

#define EMAC_INTSTS_TXCPIF_Pos           (18)                                              /*!< EMAC_T::INTSTS: TXCPIF Position           */
#define EMAC_INTSTS_TXCPIF_Msk           (0x1ul << EMAC_INTSTS_TXCPIF_Pos)                 /*!< EMAC_T::INTSTS: TXCPIF Mask               */

#define EMAC_INTSTS_EXDEFIF_Pos          (19)                                              /*!< EMAC_T::INTSTS: EXDEFIF Position          */
#define EMAC_INTSTS_EXDEFIF_Msk          (0x1ul << EMAC_INTSTS_EXDEFIF_Pos)                /*!< EMAC_T::INTSTS: EXDEFIF Mask              */

#define EMAC_INTSTS_NCSIF_Pos            (20)                                              /*!< EMAC_T::INTSTS: NCSIF Position            */
#define EMAC_INTSTS_NCSIF_Msk            (0x1ul << EMAC_INTSTS_NCSIF_Pos)                  /*!< EMAC_T::INTSTS: NCSIF Mask                */

#define EMAC_INTSTS_TXABTIF_Pos          (21)                                              /*!< EMAC_T::INTSTS: TXABTIF Position          */
#define EMAC_INTSTS_TXABTIF_Msk          (0x1ul << EMAC_INTSTS_TXABTIF_Pos)                /*!< EMAC_T::INTSTS: TXABTIF Mask              */

#define EMAC_INTSTS_LCIF_Pos             (22)                                              /*!< EMAC_T::INTSTS: LCIF Position             */
#define EMAC_INTSTS_LCIF_Msk             (0x1ul << EMAC_INTSTS_LCIF_Pos)                   /*!< EMAC_T::INTSTS: LCIF Mask                 */

#define EMAC_INTSTS_TDUIF_Pos            (23)                                              /*!< EMAC_T::INTSTS: TDUIF Position            */
#define EMAC_INTSTS_TDUIF_Msk            (0x1ul << EMAC_INTSTS_TDUIF_Pos)                  /*!< EMAC_T::INTSTS: TDUIF Mask                */

#define EMAC_INTSTS_TXBEIF_Pos           (24)                                              /*!< EMAC_T::INTSTS: TXBEIF Position           */
#define EMAC_INTSTS_TXBEIF_Msk           (0x1ul << EMAC_INTSTS_TXBEIF_Pos)                 /*!< EMAC_T::INTSTS: TXBEIF Mask               */

#define EMAC_INTSTS_TSALMIF_Pos          (28)                                              /*!< EMAC_T::INTSTS: TSALMIF Position          */
#define EMAC_INTSTS_TSALMIF_Msk          (0x1ul << EMAC_INTSTS_TSALMIF_Pos)                /*!< EMAC_T::INTSTS: TSALMIF Mask              */

#define EMAC_GENSTS_CFRIF_Pos            (0)                                               /*!< EMAC_T::GENSTS: CFRIF Position            */
#define EMAC_GENSTS_CFRIF_Msk            (0x1ul << EMAC_GENSTS_CFRIF_Pos)                  /*!< EMAC_T::GENSTS: CFRIF Mask                */

#define EMAC_GENSTS_RXHALT_Pos           (1)                                               /*!< EMAC_T::GENSTS: RXHALT Position           */
#define EMAC_GENSTS_RXHALT_Msk           (0x1ul << EMAC_GENSTS_RXHALT_Pos)                 /*!< EMAC_T::GENSTS: RXHALT Mask               */

#define EMAC_GENSTS_RXFFULL_Pos          (2)                                               /*!< EMAC_T::GENSTS: RXFFULL Position          */
#define EMAC_GENSTS_RXFFULL_Msk          (0x1ul << EMAC_GENSTS_RXFFULL_Pos)                /*!< EMAC_T::GENSTS: RXFFULL Mask              */

#define EMAC_GENSTS_COLCNT_Pos           (4)                                               /*!< EMAC_T::GENSTS: COLCNT Position           */
#define EMAC_GENSTS_COLCNT_Msk           (0xful << EMAC_GENSTS_COLCNT_Pos)                 /*!< EMAC_T::GENSTS: COLCNT Mask               */

#define EMAC_GENSTS_DEF_Pos              (8)                                               /*!< EMAC_T::GENSTS: DEF Position              */
#define EMAC_GENSTS_DEF_Msk              (0x1ul << EMAC_GENSTS_DEF_Pos)                    /*!< EMAC_T::GENSTS: DEF Mask                  */

#define EMAC_GENSTS_TXPAUSED_Pos         (9)                                               /*!< EMAC_T::GENSTS: TXPAUSED Position         */
#define EMAC_GENSTS_TXPAUSED_Msk         (0x1ul << EMAC_GENSTS_TXPAUSED_Pos)               /*!< EMAC_T::GENSTS: TXPAUSED Mask             */

#define EMAC_GENSTS_SQE_Pos              (10)                                              /*!< EMAC_T::GENSTS: SQE Position              */
#define EMAC_GENSTS_SQE_Msk              (0x1ul << EMAC_GENSTS_SQE_Pos)                    /*!< EMAC_T::GENSTS: SQE Mask                  */

#define EMAC_GENSTS_TXHALT_Pos           (11)                                              /*!< EMAC_T::GENSTS: TXHALT Position           */
#define EMAC_GENSTS_TXHALT_Msk           (0x1ul << EMAC_GENSTS_TXHALT_Pos)                 /*!< EMAC_T::GENSTS: TXHALT Mask               */

#define EMAC_GENSTS_RPSTS_Pos            (12)                                              /*!< EMAC_T::GENSTS: RPSTS Position            */
#define EMAC_GENSTS_RPSTS_Msk            (0x1ul << EMAC_GENSTS_RPSTS_Pos)                  /*!< EMAC_T::GENSTS: RPSTS Mask                */

#define EMAC_MPCNT_MPCNT_Pos             (0)                                               /*!< EMAC_T::MPCNT: MPCNT Position             */
#define EMAC_MPCNT_MPCNT_Msk             (0xfffful << EMAC_MPCNT_MPCNT_Pos)                /*!< EMAC_T::MPCNT: MPCNT Mask                 */

#define EMAC_RPCNT_RPCNT_Pos             (0)                                               /*!< EMAC_T::RPCNT: RPCNT Position             */
#define EMAC_RPCNT_RPCNT_Msk             (0xfffful << EMAC_RPCNT_RPCNT_Pos)                /*!< EMAC_T::RPCNT: RPCNT Mask                 */

#define EMAC_FRSTS_RXFLT_Pos             (0)                                               /*!< EMAC_T::FRSTS: RXFLT Position             */
#define EMAC_FRSTS_RXFLT_Msk             (0xfffful << EMAC_FRSTS_RXFLT_Pos)                /*!< EMAC_T::FRSTS: RXFLT Mask                 */

#define EMAC_CTXDSA_CTXDSA_Pos           (0)                                               /*!< EMAC_T::CTXDSA: CTXDSA Position           */
#define EMAC_CTXDSA_CTXDSA_Msk           (0xfffffffful << EMAC_CTXDSA_CTXDSA_Pos)          /*!< EMAC_T::CTXDSA: CTXDSA Mask               */

#define EMAC_CTXBSA_CTXBSA_Pos           (0)                                               /*!< EMAC_T::CTXBSA: CTXBSA Position           */
#define EMAC_CTXBSA_CTXBSA_Msk           (0xfffffffful << EMAC_CTXBSA_CTXBSA_Pos)          /*!< EMAC_T::CTXBSA: CTXBSA Mask               */

#define EMAC_CRXDSA_CRXDSA_Pos           (0)                                               /*!< EMAC_T::CRXDSA: CRXDSA Position           */
#define EMAC_CRXDSA_CRXDSA_Msk           (0xfffffffful << EMAC_CRXDSA_CRXDSA_Pos)          /*!< EMAC_T::CRXDSA: CRXDSA Mask               */

#define EMAC_CRXBSA_CRXBSA_Pos           (0)                                               /*!< EMAC_T::CRXBSA: CRXBSA Position           */
#define EMAC_CRXBSA_CRXBSA_Msk           (0xfffffffful << EMAC_CRXBSA_CRXBSA_Pos)          /*!< EMAC_T::CRXBSA: CRXBSA Mask               */

#define EMAC_TSCTL_TSEN_Pos              (0)                                               /*!< EMAC_T::TSCTL: TSEN Position              */
#define EMAC_TSCTL_TSEN_Msk              (0x1ul << EMAC_TSCTL_TSEN_Pos)                    /*!< EMAC_T::TSCTL: TSEN Mask                  */

#define EMAC_TSCTL_TSIEN_Pos             (1)                                               /*!< EMAC_T::TSCTL: TSIEN Position             */
#define EMAC_TSCTL_TSIEN_Msk             (0x1ul << EMAC_TSCTL_TSIEN_Pos)                   /*!< EMAC_T::TSCTL: TSIEN Mask                 */

#define EMAC_TSCTL_TSMODE_Pos            (2)                                               /*!< EMAC_T::TSCTL: TSMODE Position            */
#define EMAC_TSCTL_TSMODE_Msk            (0x1ul << EMAC_TSCTL_TSMODE_Pos)                  /*!< EMAC_T::TSCTL: TSMODE Mask                */

#define EMAC_TSCTL_TSUPDATE_Pos          (3)                                               /*!< EMAC_T::TSCTL: TSUPDATE Position          */
#define EMAC_TSCTL_TSUPDATE_Msk          (0x1ul << EMAC_TSCTL_TSUPDATE_Pos)                /*!< EMAC_T::TSCTL: TSUPDATE Mask              */

#define EMAC_TSCTL_TSALMEN_Pos           (5)                                               /*!< EMAC_T::TSCTL: TSALMEN Position           */
#define EMAC_TSCTL_TSALMEN_Msk           (0x1ul << EMAC_TSCTL_TSALMEN_Pos)                 /*!< EMAC_T::TSCTL: TSALMEN Mask               */

#define EMAC_TSSEC_SEC_Pos               (0)                                               /*!< EMAC_T::TSSEC: SEC Position               */
#define EMAC_TSSEC_SEC_Msk               (0xfffffffful << EMAC_TSSEC_SEC_Pos)              /*!< EMAC_T::TSSEC: SEC Mask                   */

#define EMAC_TSSUBSEC_SUBSEC_Pos         (0)                                               /*!< EMAC_T::TSSUBSEC: SUBSEC Position         */
#define EMAC_TSSUBSEC_SUBSEC_Msk         (0xfffffffful << EMAC_TSSUBSEC_SUBSEC_Pos)        /*!< EMAC_T::TSSUBSEC: SUBSEC Mask             */

#define EMAC_TSINC_CNTINC_Pos            (0)                                               /*!< EMAC_T::TSINC: CNTINC Position            */
#define EMAC_TSINC_CNTINC_Msk            (0xfful << EMAC_TSINC_CNTINC_Pos)                 /*!< EMAC_T::TSINC: CNTINC Mask                */

#define EMAC_TSADDEND_ADDEND_Pos         (0)                                               /*!< EMAC_T::TSADDEND: ADDEND Position         */
#define EMAC_TSADDEND_ADDEND_Msk         (0xfffffffful << EMAC_TSADDEND_ADDEND_Pos)        /*!< EMAC_T::TSADDEND: ADDEND Mask             */

#define EMAC_UPDSEC_SEC_Pos              (0)                                               /*!< EMAC_T::UPDSEC: SEC Position              */
#define EMAC_UPDSEC_SEC_Msk              (0xfffffffful << EMAC_UPDSEC_SEC_Pos)             /*!< EMAC_T::UPDSEC: SEC Mask                  */

#define EMAC_UPDSUBSEC_SUBSEC_Pos        (0)                                               /*!< EMAC_T::UPDSUBSEC: SUBSEC Position        */
#define EMAC_UPDSUBSEC_SUBSEC_Msk        (0xfffffffful << EMAC_UPDSUBSEC_SUBSEC_Pos)       /*!< EMAC_T::UPDSUBSEC: SUBSEC Mask            */

#define EMAC_ALMSEC_SEC_Pos              (0)                                               /*!< EMAC_T::ALMSEC: SEC Position              */
#define EMAC_ALMSEC_SEC_Msk              (0xfffffffful << EMAC_ALMSEC_SEC_Pos)             /*!< EMAC_T::ALMSEC: SEC Mask                  */

#define EMAC_ALMSUBSEC_SUBSEC_Pos        (0)                                               /*!< EMAC_T::ALMSUBSEC: SUBSEC Position        */
#define EMAC_ALMSUBSEC_SUBSEC_Msk        (0xfffffffful << EMAC_ALMSUBSEC_SUBSEC_Pos)       /*!< EMAC_T::ALMSUBSEC: SUBSEC Mask            */

/**@}*/ /* EMAC_CONST */
/**@}*/ /* end of EMAC register group */


/*---------------------- Enhanced PWM Generator -------------------------*/
/**
    @addtogroup EPWM Enhanced PWM Generator(EPWM)
    Memory Mapped Structure for EPWM Controller
@{ */

typedef struct {


    /**
     * CTL
     * ===================================================================================================
     * Offset: 0x00  PWM Control Register
     * ---------------------------------------------------------------------------------------------------
     * |Bits    |Field     |Descriptions
     * | :----: | :----:   | :---- |
     * |[0:1]   |MODE      |PWM Mode Selection
     * |        |          |00 = Independent mode.
     * |        |          |01 = Pair/Complementary mode.
     * |        |          |10 = Synchronized mode.
     * |        |          |11 = Reserved.
     * |[2:3]   |CLKDIV    |PWM Clock Pre-Divider Selection
     * |        |          |00 = PWM clock = EPWMx_CLK.
     * |        |          |01 = PWM clock = EPWMx_CLK/2.
     * |        |          |10 = PWM clock = EPWMx_CLK/4.
     * |        |          |11 = PWM clock = EPWMx_CLK/16.
     * |[4]     |PWMIEN    |PWM Interrupt Enable Control
     * |        |          |0 = Disabling flag PIF to trigger PWM interrupt.
     * |        |          |1 = Enabling flag PIF can trigger PWM interrupt.
     * |[5]     |BRKIEN    |Brake0 And Brak1 Interrupt Enable Control
     * |        |          |0 = Disabling flags BFK0 and BFK1 to trigger PWM interrupt.
     * |        |          |1 = Enabling flags BRKIF0 and BRKIF1 can trigger PWM interrupt.
     * |[6]     |LOAD      |Re-Load PWM Period Registers (EPWM_PERIOD) And PWM Duty Registers (PWM0~3) Control
     * |        |          |0 = No action if written with 0.
     * |        |          |The value of PWM period register (EPWM_PERIOD) and PWM duty registers (PWMn_CH0~PWMn_CH3) are not loaded to PWM counter and Comparator registers.
     * |        |          |1 = Hardware will update the value of PWM period register (EPWM_PERIOD) and PWM duty registers (PWMn_CH0~PWMn_CH3) to PWM Counter and Comparator register at the time of PWM Counter matches PERIOD in edge and central aligned modes or at the time of PWM Counter down counts with underflow in central aligned mode.
     * |        |          |Note1: n=0-1 for PWM unit0-1.
     * |        |          |Note2: This bit is software write, hardware clear and always read zero.
     * |[7]     |CNTEN     |Start CNTEN Control
     * |        |          |0 = The PWM stops running.
     * |        |          |1 = The PWM counter starts running.
     * |[8]     |INTTYPE   |PWM Interrupt Type Selection
     * |        |          |0 = PIF will be set if PWM counter underflow.
     * |        |          |1 = PIF will be set if PWM counter matches EPWM_PERIOD register.
     * |        |          |Note: This bit is effective when PWM in central align mode only.
     * |[9]     |PINV      |Inverse PWM Comparator Output
     *