/*
 * Copyright 2017-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v8.0
processor: LPC55S69
package_id: LPC55S69JBD100
mcu_data: ksdk2_0
processor_version: 0.9.7
board: LPCXpresso55S69
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_gpio.h"
#include "fsl_iocon.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitDEBUG_UARTPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitDEBUG_UARTPins:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '92', peripheral: FLEXCOMM0, signal: RXD_SDA_MOSI_DATA, pin_signal: PIO0_29/FC0_RXD_SDA_MOSI_DATA/SD1_D2/CTIMER2_MAT3/SCT0_OUT8/CMP0_OUT/PLU_OUT2/SECURE_GPIO0_29,
    mode: inactive, slew_rate: standard, invert: disabled, open_drain: disabled}
  - {pin_num: '94', peripheral: FLEXCOMM0, signal: TXD_SCL_MISO_WS, pin_signal: PIO0_30/FC0_TXD_SCL_MISO_WS/SD1_D3/CTIMER0_MAT0/SCT0_OUT9/SECURE_GPIO0_30, mode: inactive,
    slew_rate: standard, invert: disabled, open_drain: disabled}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitDEBUG_UARTPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitDEBUG_UARTPins(void)
{
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    const uint32_t DEBUG_UART_RX = (/* Pin is configured as FC0_RXD_SDA_MOSI_DATA */
                                    IOCON_PIO_FUNC1 |
                                    /* No addition pin function */
                                    IOCON_PIO_MODE_INACT |
                                    /* Standard mode, output slew rate control is enabled */
                                    IOCON_PIO_SLEW_STANDARD |
                                    /* Input function is not inverted */
                                    IOCON_PIO_INV_DI |
                                    /* Enables digital function */
                                    IOCON_PIO_DIGITAL_EN |
                                    /* Open drain is disabled */
                                    IOCON_PIO_OPENDRAIN_DI);
    /* PORT0 PIN29 (coords: 92) is configured as FC0_RXD_SDA_MOSI_DATA */
    IOCON_PinMuxSet(IOCON, BOARD_INITDEBUG_UARTPINS_DEBUG_UART_RX_PORT, BOARD_INITDEBUG_UARTPINS_DEBUG_UART_RX_PIN, DEBUG_UART_RX);

    const uint32_t DEBUG_UART_TX = (/* Pin is configured as FC0_TXD_SCL_MISO_WS */
                                    IOCON_PIO_FUNC1 |
                                    /* No addition pin function */
                                    IOCON_PIO_MODE_INACT |
                                    /* Standard mode, output slew rate control is enabled */
                                    IOCON_PIO_SLEW_STANDARD |
                                    /* Input function is not inverted */
                                    IOCON_PIO_INV_DI |
                                    /* Enables digital function */
                                    IOCON_PIO_DIGITAL_EN |
                                    /* Open drain is disabled */
                                    IOCON_PIO_OPENDRAIN_DI);
    /* PORT0 PIN30 (coords: 94) is configured as FC0_TXD_SCL_MISO_WS */
    IOCON_PinMuxSet(IOCON, BOARD_INITDEBUG_UARTPINS_DEBUG_UART_TX_PORT, BOARD_INITDEBUG_UARTPINS_DEBUG_UART_TX_PIN, DEBUG_UART_TX);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitSWD_DEBUGPins:
- options: {callFromInitBoot: 'false', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '13', peripheral: SWD, signal: SWCLK, pin_signal: PIO0_11/FC6_RXD_SDA_MOSI_DATA/CTIMER2_MAT2/FREQME_GPIO_CLK_A/SWCLK/SECURE_GPIO0_11/ADC0_9, mode: pullDown,
    slew_rate: standard, invert: disabled, open_drain: disabled, asw: enabled}
  - {pin_num: '12', peripheral: SWD, signal: SWDIO, pin_signal: PIO0_12/FC3_TXD_SCL_MISO_WS/SD1_BACKEND_PWR/FREQME_GPIO_CLK_B/SCT_GPI7/SD0_POW_EN/SWDIO/FC6_TXD_SCL_MISO_WS/SECURE_GPIO0_12/ADC0_10,
    mode: pullUp, slew_rate: standard, invert: disabled, open_drain: disabled, asw: enabled}
  - {pin_num: '21', peripheral: SWD, signal: SWO, pin_signal: PIO0_10/FC6_SCK/CT_INP10/CTIMER2_MAT0/FC1_TXD_SCL_MISO_WS/SCT0_OUT2/SWO/SECURE_GPIO0_10/ADC0_1, identifier: DEBUG_SWD_SWO,
    mode: inactive, slew_rate: standard, invert: disabled, open_drain: disabled, asw: disabled}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitSWD_DEBUGPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitSWD_DEBUGPins(void)
{
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    const uint32_t DEBUG_SWD_SWO = (/* Pin is configured as SWO */
                                    IOCON_PIO_FUNC6 |
                                    /* No addition pin function */
                                    IOCON_PIO_MODE_INACT |
                                    /* Standard mode, output slew rate control is enabled */
                                    IOCON_PIO_SLEW_STANDARD |
                                    /* Input function is not inverted */
                                    IOCON_PIO_INV_DI |
                                    /* Enables digital function */
                                    IOCON_PIO_DIGITAL_EN |
                                    /* Open drain is disabled */
                                    IOCON_PIO_OPENDRAIN_DI |
                                    /* Analog switch is open (disabled) */
                                    IOCON_PIO_ASW_DI);
    /* PORT0 PIN10 (coords: 21) is configured as SWO */
    IOCON_PinMuxSet(IOCON, BOARD_INITSWD_DEBUGPINS_DEBUG_SWD_SWO_PORT, BOARD_INITSWD_DEBUGPINS_DEBUG_SWD_SWO_PIN, DEBUG_SWD_SWO);

    if (Chip_GetVersion()==1)
    {
        const uint32_t DEBUG_SWD_SWDCLK = (/* Pin is configured as SWCLK */
                                           IOCON_PIO_FUNC6 |
                                           /* Selects pull-down function */
                                           IOCON_PIO_MODE_PULLDOWN |
                                           /* Standard mode, output slew rate control is enabled */
                                           IOCON_PIO_SLEW_STANDARD |
                                           /* Input function is not inverted */
                                           IOCON_PIO_INV_DI |
                                           /* Enables digital function */
                                           IOCON_PIO_DIGITAL_EN |
                                           /* Open drain is disabled */
                                           IOCON_PIO_OPENDRAIN_DI |
                                           /* Analog switch is closed (enabled) */
                                           IOCON_PIO_ASW_EN);
        /* PORT0 PIN11 (coords: 13) is configured as SWCLK */
        IOCON_PinMuxSet(IOCON, BOARD_INITSWD_DEBUGPINS_DEBUG_SWD_SWDCLK_PORT, BOARD_INITSWD_DEBUGPINS_DEBUG_SWD_SWDCLK_PIN, DEBUG_SWD_SWDCLK);
    }
    else
    {
        const uint32_t DEBUG_SWD_SWDCLK = (/* Pin is configured as SWCLK */
                                           IOCON_PIO_FUNC6 |
                                           /* Selects pull-down function */
                                           IOCON_PIO_MODE_PULLDOWN |
                                           /* Standard mode, output slew rate control is enabled */
                                           IOCON_PIO_SLEW_STANDARD |
                                           /* Input function is not inverted */
                                           IOCON_PIO_INV_DI |
                                           /* Enables digital function */
                                           IOCON_PIO_DIGITAL_EN |
                                           /* Open drain is disabled */
                                           IOCON_PIO_OPENDRAIN_DI |
                                           /* Analog switch is closed (enabled), only for A0 version */
                                           IOCON_PIO_ASW_DIS_EN);
        /* PORT0 PIN11 (coords: 13) is configured as SWCLK */
        IOCON_PinMuxSet(IOCON, BOARD_INITSWD_DEBUGPINS_DEBUG_SWD_SWDCLK_PORT, BOARD_INITSWD_DEBUGPINS_DEBUG_SWD_SWDCLK_PIN, DEBUG_SWD_SWDCLK);
    }

    if (Chip_GetVersion()==1)
    {
        const uint32_t DEBUG_SWD_SWDIO = (/* Pin is configured as SWDIO */
                                          IOCON_PIO_FUNC6 |
                                          /* Selects pull-up function */
                                          IOCON_PIO_MODE_PULLUP |
                                          /* Standard mode, output slew rate control is enabled */
                                          IOCON_PIO_SLEW_STANDARD |
                                          /* Input function is not inverted */
                                          IOCON_PIO_INV_DI |
                                          /* Enables digital function */
                                          IOCON_PIO_DIGITAL_EN |
                                          /* Open drain is disabled */
                                          IOCON_PIO_OPENDRAIN_DI |
                                          /* Analog switch is closed (enabled) */
                                          IOCON_PIO_ASW_EN);
        /* PORT0 PIN12 (coords: 12) is configured as SWDIO */
        IOCON_PinMuxSet(IOCON, BOARD_INITSWD_DEBUGPINS_DEBUG_SWD_SWDIO_PORT, BOARD_INITSWD_DEBUGPINS_DEBUG_SWD_SWDIO_PIN, DEBUG_SWD_SWDIO);
    }
    else
    {
        const uint32_t DEBUG_SWD_SWDIO = (/* Pin is configured as SWDIO */
                                          IOCON_PIO_FUNC6 |
                                          /* Selects pull-up function */
                                          IOCON_PIO_MODE_PULLUP |
                                          /* Standard mode, output slew rate control is enabled */
                                          IOCON_PIO_SLEW_STANDARD |
                                          /* Input function is not inverted */
                                          IOCON_PIO_INV_DI |
                                          /* Enables digital function */
                                          IOCON_PIO_DIGITAL_EN |
                                          /* Open drain is disabled */
                                          IOCON_PIO_OPENDRAIN_DI |
                                          /* Analog switch is closed (enabled), only for A0 version */
                                          IOCON_PIO_ASW_DIS_EN);
        /* PORT0 PIN12 (coords: 12) is configured as SWDIO */
        IOCON_PinMuxSet(IOCON, BOARD_INITSWD_DEBUGPINS_DEBUG_SWD_SWDIO_PORT, BOARD_INITSWD_DEBUGPINS_DEBUG_SWD_SWDIO_PIN, DEBUG_SWD_SWDIO);
    }
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitUSBPins:
- options: {callFromInitBoot: 'false', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '97', peripheral: USBFSH, signal: USB_DP, pin_signal: USB0_DP}
  - {pin_num: '98', peripheral: USBFSH, signal: USB_DM, pin_signal: USB0_DM}
  - {pin_num: '78', peripheral: USBFSH, signal: USB_VBUS, pin_signal: PIO0_22/FC6_TXD_SCL_MISO_WS/UTICK_CAP1/CT_INP15/SCT0_OUT3/USB0_VBUS/SD1_D0/PLU_OUT7/SECURE_GPIO0_22,
    mode: inactive, slew_rate: standard, invert: disabled, open_drain: disabled}
  - {pin_num: '35', peripheral: USBHSH, signal: USB_DM, pin_signal: USB1_DM}
  - {pin_num: '34', peripheral: USBHSH, signal: USB_DP, pin_signal: USB1_DP}
  - {pin_num: '36', peripheral: USBHSH, signal: USB_VBUS, pin_signal: USB1_VBUS}
  - {pin_num: '65', peripheral: USBHSH, signal: USB_OVERCURRENTN, pin_signal: PIO1_30/FC7_TXD_SCL_MISO_WS/SD0_D7/SCT_GPI7/USB1_OVERCURRENTN/USB1_LEDN/PLU_IN1, mode: pullUp,
    slew_rate: standard, invert: disabled, open_drain: disabled}
  - {pin_num: '66', peripheral: USBFSH, signal: USB_OVERCURRENTN, pin_signal: PIO0_28/FC0_SCK/SD1_CMD/CT_INP11/SCT0_OUT7/USB0_OVERCURRENTN/PLU_OUT1/SECURE_GPIO0_28,
    mode: pullUp, slew_rate: standard, invert: disabled, open_drain: disabled}
  - {pin_num: '67', peripheral: USBFSH, signal: USB_PORTPWRN, pin_signal: PIO1_12/FC6_SCK/CTIMER1_MAT1/USB0_PORTPWRN/HS_SPI_SSEL2, mode: pullUp, slew_rate: standard,
    invert: disabled, open_drain: disabled}
  - {pin_num: '80', peripheral: USBHSH, signal: USB_PORTPWRN, pin_signal: PIO1_29/FC7_RXD_SDA_MOSI_DATA/SD0_D6/SCT_GPI6/USB1_PORTPWRN/USB1_FRAME/PLU_IN2, mode: pullUp,
    slew_rate: standard, invert: disabled, open_drain: disabled}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitUSBPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitUSBPins(void)
{
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    const uint32_t USB0_VBUS = (/* Pin is configured as USB0_VBUS */
                                IOCON_PIO_FUNC7 |
                                /* No addition pin function */
                                IOCON_PIO_MODE_INACT |
                                /* Standard mode, output slew rate control is enabled */
                                IOCON_PIO_SLEW_STANDARD |
                                /* Input function is not inverted */
                                IOCON_PIO_INV_DI |
                                /* Enables digital function */
                                IOCON_PIO_DIGITAL_EN |
                                /* Open drain is disabled */
                                IOCON_PIO_OPENDRAIN_DI);
    /* PORT0 PIN22 (coords: 78) is configured as USB0_VBUS */
    IOCON_PinMuxSet(IOCON, BOARD_INITUSBPINS_USB0_VBUS_PORT, BOARD_INITUSBPINS_USB0_VBUS_PIN, USB0_VBUS);

    const uint32_t port0_pin28_config = (/* Pin is configured as USB0_OVERCURRENTN */
                                         IOCON_PIO_FUNC7 |
                                         /* Selects pull-up function */
                                         IOCON_PIO_MODE_PULLUP |
                                         /* Standard mode, output slew rate control is enabled */
                                         IOCON_PIO_SLEW_STANDARD |
                                         /* Input function is not inverted */
                                         IOCON_PIO_INV_DI |
                                         /* Enables digital function */
                                         IOCON_PIO_DIGITAL_EN |
                                         /* Open drain is disabled */
                                         IOCON_PIO_OPENDRAIN_DI);
    /* PORT0 PIN28 (coords: 66) is configured as USB0_OVERCURRENTN */
    IOCON_PinMuxSet(IOCON, 0U, 28U, port0_pin28_config);

    const uint32_t port1_pin12_config = (/* Pin is configured as USB0_PORTPWRN */
                                         IOCON_PIO_FUNC4 |
                                         /* Selects pull-up function */
                                         IOCON_PIO_MODE_PULLUP |
                                         /* Standard mode, output slew rate control is enabled */
                                         IOCON_PIO_SLEW_STANDARD |
                                         /* Input function is not inverted */
                                         IOCON_PIO_INV_DI |
                                         /* Enables digital function */
                                         IOCON_PIO_DIGITAL_EN |
                                         /* Open drain is disabled */
                                         IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN12 (coords: 67) is configured as USB0_PORTPWRN */
    IOCON_PinMuxSet(IOCON, 1U, 12U, port1_pin12_config);

    const uint32_t port1_pin29_config = (/* Pin is configured as USB1_PORTPWRN */
                                         IOCON_PIO_FUNC4 |
                                         /* Selects pull-up function */
                                         IOCON_PIO_MODE_PULLUP |
                                         /* Standard mode, output slew rate control is enabled */
                                         IOCON_PIO_SLEW_STANDARD |
                                         /* Input function is not inverted */
                                         IOCON_PIO_INV_DI |
                                         /* Enables digital function */
                                         IOCON_PIO_DIGITAL_EN |
                                         /* Open drain is disabled */
                                         IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN29 (coords: 80) is configured as USB1_PORTPWRN */
    IOCON_PinMuxSet(IOCON, 1U, 29U, port1_pin29_config);

    const uint32_t port1_pin30_config = (/* Pin is configured as USB1_OVERCURRENTN */
                                         IOCON_PIO_FUNC4 |
                                         /* Selects pull-up function */
                                         IOCON_PIO_MODE_PULLUP |
                                         /* Standard mode, output slew rate control is enabled */
                                         IOCON_PIO_SLEW_STANDARD |
                                         /* Input function is not inverted */
                                         IOCON_PIO_INV_DI |
                                         /* Enables digital function */
                                         IOCON_PIO_DIGITAL_EN |
                                         /* Open drain is disabled */
                                         IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN30 (coords: 65) is configured as USB1_OVERCURRENTN */
    IOCON_PinMuxSet(IOCON, 1U, 30U, port1_pin30_config);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitLEDsPins:
- options: {callFromInitBoot: 'false', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '1', peripheral: GPIO, signal: 'PIO1, 4', pin_signal: PIO1_4/FC0_SCK/SD0_D0/CTIMER2_MAT1/SCT0_OUT0/FREQME_GPIO_CLK_A, direction: OUTPUT, gpio_init_state: 'true',
    mode: pullUp, slew_rate: standard, invert: disabled, open_drain: disabled}
  - {pin_num: '5', peripheral: GPIO, signal: 'PIO1, 6', pin_signal: PIO1_6/FC0_TXD_SCL_MISO_WS/SD0_D3/CTIMER2_MAT1/SCT_GPI3, direction: OUTPUT, gpio_init_state: 'true',
    mode: pullUp, slew_rate: standard, invert: disabled, open_drain: disabled}
  - {pin_num: '9', peripheral: GPIO, signal: 'PIO1, 7', pin_signal: PIO1_7/FC0_RTS_SCL_SSEL1/SD0_D1/CTIMER2_MAT2/SCT_GPI4, direction: OUTPUT, gpio_init_state: 'true',
    mode: pullUp, slew_rate: standard, invert: disabled, open_drain: disabled}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitLEDsPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitLEDsPins(void)
{
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    /* Enables the clock for the GPIO1 module */
    CLOCK_EnableClock(kCLOCK_Gpio1);

    gpio_pin_config_t LED_BULE_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO1_4 (pin 1)  */
    GPIO_PinInit(BOARD_INITLEDSPINS_LED_BULE_GPIO, BOARD_INITLEDSPINS_LED_BULE_PORT, BOARD_INITLEDSPINS_LED_BULE_PIN, &LED_BULE_config);

    gpio_pin_config_t LED_RED_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO1_6 (pin 5)  */
    GPIO_PinInit(BOARD_INITLEDSPINS_LED_RED_GPIO, BOARD_INITLEDSPINS_LED_RED_PORT, BOARD_INITLEDSPINS_LED_RED_PIN, &LED_RED_config);

    gpio_pin_config_t LED_GREEN_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO1_7 (pin 9)  */
    GPIO_PinInit(BOARD_INITLEDSPINS_LED_GREEN_GPIO, BOARD_INITLEDSPINS_LED_GREEN_PORT, BOARD_INITLEDSPINS_LED_GREEN_PIN, &LED_GREEN_config);

    const uint32_t LED_BULE = (/* Pin is configured as PIO1_4 */
                               IOCON_PIO_FUNC0 |
                               /* Selects pull-up function */
                               IOCON_PIO_MODE_PULLUP |
                               /* Standard mode, output slew rate control is enabled */
                               IOCON_PIO_SLEW_STANDARD |
                               /* Input function is not inverted */
                               IOCON_PIO_INV_DI |
                               /* Enables digital function */
                               IOCON_PIO_DIGITAL_EN |
                               /* Open drain is disabled */
                               IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN4 (coords: 1) is configured as PIO1_4 */
    IOCON_PinMuxSet(IOCON, BOARD_INITLEDSPINS_LED_BULE_PORT, BOARD_INITLEDSPINS_LED_BULE_PIN, LED_BULE);

    const uint32_t LED_RED = (/* Pin is configured as PIO1_6 */
                              IOCON_PIO_FUNC0 |
                              /* Selects pull-up function */
                              IOCON_PIO_MODE_PULLUP |
                              /* Standard mode, output slew rate control is enabled */
                              IOCON_PIO_SLEW_STANDARD |
                              /* Input function is not inverted */
                              IOCON_PIO_INV_DI |
                              /* Enables digital function */
                              IOCON_PIO_DIGITAL_EN |
                              /* Open drain is disabled */
                              IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN6 (coords: 5) is configured as PIO1_6 */
    IOCON_PinMuxSet(IOCON, BOARD_INITLEDSPINS_LED_RED_PORT, BOARD_INITLEDSPINS_LED_RED_PIN, LED_RED);

    const uint32_t LED_GREEN = (/* Pin is configured as PIO1_7 */
                                IOCON_PIO_FUNC0 |
                                /* Selects pull-up function */
                                IOCON_PIO_MODE_PULLUP |
                                /* Standard mode, output slew rate control is enabled */
                                IOCON_PIO_SLEW_STANDARD |
                                /* Input function is not inverted */
                                IOCON_PIO_INV_DI |
                                /* Enables digital function */
                                IOCON_PIO_DIGITAL_EN |
                                /* Open drain is disabled */
                                IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN7 (coords: 9) is configured as PIO1_7 */
    IOCON_PinMuxSet(IOCON, BOARD_INITLEDSPINS_LED_GREEN_PORT, BOARD_INITLEDSPINS_LED_GREEN_PIN, LED_GREEN);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitBUTTONsPins:
- options: {callFromInitBoot: 'false', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '88', peripheral: GPIO, signal: 'PIO0, 5', pin_signal: PIO0_5/FC4_RXD_SDA_MOSI_DATA/CTIMER3_MAT0/SCT_GPI5/FC3_RTS_SCL_SSEL1/MCLK/SECURE_GPIO0_5, direction: INPUT,
    mode: pullUp, slew_rate: standard, invert: disabled, open_drain: disabled}
  - {pin_num: '64', peripheral: GPIO, signal: 'PIO1, 18', pin_signal: PIO1_18/SD1_POW_EN/SCT0_OUT5/PLU_OUT0, direction: INPUT, mode: pullUp, slew_rate: standard,
    invert: disabled, open_drain: disabled}
  - {pin_num: '10', peripheral: GPIO, signal: 'PIO1, 9', pin_signal: PIO1_9/FC1_SCK/CT_INP4/SCT0_OUT2/FC4_CTS_SDA_SSEL0/ADC0_12, direction: INPUT, mode: pullUp, slew_rate: standard,
    invert: disabled, open_drain: disabled, asw: enabled}
  - {pin_num: '32', peripheral: SYSCON, signal: RESET, pin_signal: RESETN}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBUTTONsPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitBUTTONsPins(void)
{
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    /* Enables the clock for the GPIO0 module */
    CLOCK_EnableClock(kCLOCK_Gpio0);

    /* Enables the clock for the GPIO1 module */
    CLOCK_EnableClock(kCLOCK_Gpio1);

    gpio_pin_config_t S1_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_5 (pin 88)  */
    GPIO_PinInit(BOARD_INITBUTTONSPINS_S1_GPIO, BOARD_INITBUTTONSPINS_S1_PORT, BOARD_INITBUTTONSPINS_S1_PIN, &S1_config);

    gpio_pin_config_t S3_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO1_9 (pin 10)  */
    GPIO_PinInit(BOARD_INITBUTTONSPINS_S3_GPIO, BOARD_INITBUTTONSPINS_S3_PORT, BOARD_INITBUTTONSPINS_S3_PIN, &S3_config);

    gpio_pin_config_t S2_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO1_18 (pin 64)  */
    GPIO_PinInit(BOARD_INITBUTTONSPINS_S2_GPIO, BOARD_INITBUTTONSPINS_S2_PORT, BOARD_INITBUTTONSPINS_S2_PIN, &S2_config);

    const uint32_t S1 = (/* Pin is configured as PIO0_5 */
                         IOCON_PIO_FUNC0 |
                         /* Selects pull-up function */
                         IOCON_PIO_MODE_PULLUP |
                         /* Standard mode, output slew rate control is enabled */
                         IOCON_PIO_SLEW_STANDARD |
                         /* Input function is not inverted */
                         IOCON_PIO_INV_DI |
                         /* Enables digital function */
                         IOCON_PIO_DIGITAL_EN |
                         /* Open drain is disabled */
                         IOCON_PIO_OPENDRAIN_DI);
    /* PORT0 PIN5 (coords: 88) is configured as PIO0_5 */
    IOCON_PinMuxSet(IOCON, BOARD_INITBUTTONSPINS_S1_PORT, BOARD_INITBUTTONSPINS_S1_PIN, S1);

    const uint32_t S2 = (/* Pin is configured as PIO1_18 */
                         IOCON_PIO_FUNC0 |
                         /* Selects pull-up function */
                         IOCON_PIO_MODE_PULLUP |
                         /* Standard mode, output slew rate control is enabled */
                         IOCON_PIO_SLEW_STANDARD |
                         /* Input function is not inverted */
                         IOCON_PIO_INV_DI |
                         /* Enables digital function */
                         IOCON_PIO_DIGITAL_EN |
                         /* Open drain is disabled */
                         IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN18 (coords: 64) is configured as PIO1_18 */
    IOCON_PinMuxSet(IOCON, BOARD_INITBUTTONSPINS_S2_PORT, BOARD_INITBUTTONSPINS_S2_PIN, S2);

    if (Chip_GetVersion()==1)
    {
        const uint32_t S3 = (/* Pin is configured as PIO1_9 */
                             IOCON_PIO_FUNC0 |
                             /* Selects pull-up function */
                             IOCON_PIO_MODE_PULLUP |
                             /* Standard mode, output slew rate control is enabled */
                             IOCON_PIO_SLEW_STANDARD |
                             /* Input function is not inverted */
                             IOCON_PIO_INV_DI |
                             /* Enables digital function */
                             IOCON_PIO_DIGITAL_EN |
                             /* Open drain is disabled */
                             IOCON_PIO_OPENDRAIN_DI |
                             /* Analog switch is closed (enabled) */
                             IOCON_PIO_ASW_EN);
        /* PORT1 PIN9 (coords: 10) is configured as PIO1_9 */
        IOCON_PinMuxSet(IOCON, BOARD_INITBUTTONSPINS_S3_PORT, BOARD_INITBUTTONSPINS_S3_PIN, S3);
    }
    else
    {
        const uint32_t S3 = (/* Pin is configured as PIO1_9 */
                             IOCON_PIO_FUNC0 |
                             /* Selects pull-up function */
                             IOCON_PIO_MODE_PULLUP |
                             /* Standard mode, output slew rate control is enabled */
                             IOCON_PIO_SLEW_STANDARD |
                             /* Input function is not inverted */
                             IOCON_PIO_INV_DI |
                             /* Enables digital function */
                             IOCON_PIO_DIGITAL_EN |
                             /* Open drain is disabled */
                             IOCON_PIO_OPENDRAIN_DI |
                             /* Analog switch is closed (enabled), only for A0 version */
                             IOCON_PIO_ASW_DIS_EN);
        /* PORT1 PIN9 (coords: 10) is configured as PIO1_9 */
        IOCON_PinMuxSet(IOCON, BOARD_INITBUTTONSPINS_S3_PORT, BOARD_INITBUTTONSPINS_S3_PIN, S3);
    }
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitI2SPins:
- options: {callFromInitBoot: 'false', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '4', peripheral: FLEXCOMM4, signal: TXD_SCL_MISO_WS, pin_signal: PIO1_20/FC7_RTS_SCL_SSEL1/CT_INP14/FC4_TXD_SCL_MISO_WS/PLU_OUT2, mode: pullUp, slew_rate: standard,
    invert: disabled, open_drain: disabled}
  - {pin_num: '30', peripheral: FLEXCOMM4, signal: RXD_SDA_MOSI_DATA, pin_signal: PIO1_21/FC7_CTS_SDA_SSEL0/CTIMER3_MAT2/FC4_RXD_SDA_MOSI_DATA/PLU_OUT3, mode: pullUp,
    slew_rate: standard, invert: disabled, open_drain: disabled}
  - {pin_num: '91', peripheral: SYSCON, signal: MCLK, pin_signal: PIO1_31/MCLK/SD1_CLK/CTIMER0_MAT2/SCT0_OUT6/PLU_IN0, mode: inactive, slew_rate: standard, invert: disabled,
    open_drain: disabled}
  - {pin_num: '76', peripheral: FLEXCOMM7, signal: SCK, pin_signal: PIO0_21/FC3_RTS_SCL_SSEL1/UTICK_CAP3/CTIMER3_MAT3/SCT_GPI3/FC7_SCK/PLU_CLKIN/SECURE_GPIO0_21,
    mode: pullUp, slew_rate: standard, invert: disabled, open_drain: disabled}
  - {pin_num: '74', peripheral: FLEXCOMM7, signal: RXD_SDA_MOSI_DATA, pin_signal: PIO0_20/FC3_CTS_SDA_SSEL0/CTIMER1_MAT1/CT_INP15/SCT_GPI2/FC7_RXD_SDA_MOSI_DATA/HS_SPI_SSEL0/PLU_IN5/SECURE_GPIO0_20/FC4_TXD_SCL_MISO_WS,
    mode: pullUp, slew_rate: standard, invert: disabled, open_drain: disabled}
  - {pin_num: '90', peripheral: FLEXCOMM7, signal: TXD_SCL_MISO_WS, pin_signal: PIO0_19/FC4_RTS_SCL_SSEL1/UTICK_CAP0/CTIMER0_MAT2/SCT0_OUT2/FC7_TXD_SCL_MISO_WS/PLU_IN4/SECURE_GPIO0_19,
    mode: pullUp, slew_rate: standard, invert: disabled, open_drain: disabled}
  - {pin_num: '21', peripheral: FLEXCOMM6, signal: SCK, pin_signal: PIO0_10/FC6_SCK/CT_INP10/CTIMER2_MAT0/FC1_TXD_SCL_MISO_WS/SCT0_OUT2/SWO/SECURE_GPIO0_10/ADC0_1,
    identifier: FC6_I2S_CLK, mode: pullUp, slew_rate: standard, invert: disabled, open_drain: disabled, asw: enabled}
  - {pin_num: '2', peripheral: FLEXCOMM6, signal: RXD_SDA_MOSI_DATA, pin_signal: PIO1_13/FC6_RXD_SDA_MOSI_DATA/CT_INP6/USB0_OVERCURRENTN/USB0_FRAME/SD0_CARD_DET_N,
    mode: pullUp, slew_rate: standard, invert: disabled, open_drain: disabled}
  - {pin_num: '87', peripheral: FLEXCOMM6, signal: TXD_SCL_MISO_WS, pin_signal: PIO1_16/FC6_TXD_SCL_MISO_WS/CTIMER1_MAT3/SD0_CMD, mode: pullUp, slew_rate: standard,
    invert: disabled, open_drain: disabled}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitI2SPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitI2SPins(void)
{
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    const uint32_t FC6_I2S_CLK = (/* Pin is configured as FC6_SCK */
                                  IOCON_PIO_FUNC1 |
                                  /* Selects pull-up function */
                                  IOCON_PIO_MODE_PULLUP |
                                  /* Standard mode, output slew rate control is enabled */
                                  IOCON_PIO_SLEW_STANDARD |
                                  /* Input function is not inverted */
                                  IOCON_PIO_INV_DI |
                                  /* Enables digital function */
                                  IOCON_PIO_DIGITAL_EN |
                                  /* Open drain is disabled */
                                  IOCON_PIO_OPENDRAIN_DI |
                                  /* Analog switch is closed (enabled) */
                                  IOCON_PIO_ASW_EN);
    /* PORT0 PIN10 (coords: 21) is configured as FC6_SCK */
    IOCON_PinMuxSet(IOCON, BOARD_INITI2SPINS_FC6_I2S_CLK_PORT, BOARD_INITI2SPINS_FC6_I2S_CLK_PIN, FC6_I2S_CLK);

    const uint32_t FC7_I2S_WS = (/* Pin is configured as FC7_TXD_SCL_MISO_WS */
                                 IOCON_PIO_FUNC7 |
                                 /* Selects pull-up function */
                                 IOCON_PIO_MODE_PULLUP |
                                 /* Standard mode, output slew rate control is enabled */
                                 IOCON_PIO_SLEW_STANDARD |
                                 /* Input function is not inverted */
                                 IOCON_PIO_INV_DI |
                                 /* Enables digital function */
                                 IOCON_PIO_DIGITAL_EN |
                                 /* Open drain is disabled */
                                 IOCON_PIO_OPENDRAIN_DI);
    /* PORT0 PIN19 (coords: 90) is configured as FC7_TXD_SCL_MISO_WS */
    IOCON_PinMuxSet(IOCON, BOARD_INITI2SPINS_FC7_I2S_WS_PORT, BOARD_INITI2SPINS_FC7_I2S_WS_PIN, FC7_I2S_WS);

    const uint32_t FC7_I2S_TX = (/* Pin is configured as FC7_RXD_SDA_MOSI_DATA */
                                 IOCON_PIO_FUNC7 |
                                 /* Selects pull-up function */
                                 IOCON_PIO_MODE_PULLUP |
                                 /* Standard mode, output slew rate control is enabled */
                                 IOCON_PIO_SLEW_STANDARD |
                                 /* Input function is not inverted */
                                 IOCON_PIO_INV_DI |
                                 /* Enables digital function */
                                 IOCON_PIO_DIGITAL_EN |
                                 /* Open drain is disabled */
                                 IOCON_PIO_OPENDRAIN_DI);
    /* PORT0 PIN20 (coords: 74) is configured as FC7_RXD_SDA_MOSI_DATA */
    IOCON_PinMuxSet(IOCON, BOARD_INITI2SPINS_FC7_I2S_TX_PORT, BOARD_INITI2SPINS_FC7_I2S_TX_PIN, FC7_I2S_TX);

    const uint32_t FC7_I2S_SCK = (/* Pin is configured as FC7_SCK */
                                  IOCON_PIO_FUNC7 |
                                  /* Selects pull-up function */
                                  IOCON_PIO_MODE_PULLUP |
                                  /* Standard mode, output slew rate control is enabled */
                                  IOCON_PIO_SLEW_STANDARD |
                                  /* Input function is not inverted */
                                  IOCON_PIO_INV_DI |
                                  /* Enables digital function */
                                  IOCON_PIO_DIGITAL_EN |
                                  /* Open drain is disabled */
                                  IOCON_PIO_OPENDRAIN_DI);
    /* PORT0 PIN21 (coords: 76) is configured as FC7_SCK */
    IOCON_PinMuxSet(IOCON, BOARD_INITI2SPINS_FC7_I2S_SCK_PORT, BOARD_INITI2SPINS_FC7_I2S_SCK_PIN, FC7_I2S_SCK);

    const uint32_t FC6_I2S_RX = (/* Pin is configured as FC6_RXD_SDA_MOSI_DATA */
                                 IOCON_PIO_FUNC2 |
                                 /* Selects pull-up function */
                                 IOCON_PIO_MODE_PULLUP |
                                 /* Standard mode, output slew rate control is enabled */
                                 IOCON_PIO_SLEW_STANDARD |
                                 /* Input function is not inverted */
                                 IOCON_PIO_INV_DI |
                                 /* Enables digital function */
                                 IOCON_PIO_DIGITAL_EN |
                                 /* Open drain is disabled */
                                 IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN13 (coords: 2) is configured as FC6_RXD_SDA_MOSI_DATA */
    IOCON_PinMuxSet(IOCON, BOARD_INITI2SPINS_FC6_I2S_RX_PORT, BOARD_INITI2SPINS_FC6_I2S_RX_PIN, FC6_I2S_RX);

    const uint32_t FC6_I2S_WS = (/* Pin is configured as FC6_TXD_SCL_MISO_WS */
                                 IOCON_PIO_FUNC2 |
                                 /* Selects pull-up function */
                                 IOCON_PIO_MODE_PULLUP |
                                 /* Standard mode, output slew rate control is enabled */
                                 IOCON_PIO_SLEW_STANDARD |
                                 /* Input function is not inverted */
                                 IOCON_PIO_INV_DI |
                                 /* Enables digital function */
                                 IOCON_PIO_DIGITAL_EN |
                                 /* Open drain is disabled */
                                 IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN16 (coords: 87) is configured as FC6_TXD_SCL_MISO_WS */
    IOCON_PinMuxSet(IOCON, BOARD_INITI2SPINS_FC6_I2S_WS_PORT, BOARD_INITI2SPINS_FC6_I2S_WS_PIN, FC6_I2S_WS);

    const uint32_t FC4_I2C_SCL = (/* Pin is configured as FC4_TXD_SCL_MISO_WS */
                                  IOCON_PIO_FUNC5 |
                                  /* Selects pull-up function */
                                  IOCON_PIO_MODE_PULLUP |
                                  /* Standard mode, output slew rate control is enabled */
                                  IOCON_PIO_SLEW_STANDARD |
                                  /* Input function is not inverted */
                                  IOCON_PIO_INV_DI |
                                  /* Enables digital function */
                                  IOCON_PIO_DIGITAL_EN |
                                  /* Open drain is disabled */
                                  IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN20 (coords: 4) is configured as FC4_TXD_SCL_MISO_WS */
    IOCON_PinMuxSet(IOCON, BOARD_INITI2SPINS_FC4_I2C_SCL_PORT, BOARD_INITI2SPINS_FC4_I2C_SCL_PIN, FC4_I2C_SCL);

    const uint32_t FC4_I2C_SDA = (/* Pin is configured as FC4_RXD_SDA_MOSI_DATA */
                                  IOCON_PIO_FUNC5 |
                                  /* Selects pull-up function */
                                  IOCON_PIO_MODE_PULLUP |
                                  /* Standard mode, output slew rate control is enabled */
                                  IOCON_PIO_SLEW_STANDARD |
                                  /* Input function is not inverted */
                                  IOCON_PIO_INV_DI |
                                  /* Enables digital function */
                                  IOCON_PIO_DIGITAL_EN |
                                  /* Open drain is disabled */
                                  IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN21 (coords: 30) is configured as FC4_RXD_SDA_MOSI_DATA */
    IOCON_PinMuxSet(IOCON, BOARD_INITI2SPINS_FC4_I2C_SDA_PORT, BOARD_INITI2SPINS_FC4_I2C_SDA_PIN, FC4_I2C_SDA);

    const uint32_t MCLK = (/* Pin is configured as MCLK */
                           IOCON_PIO_FUNC1 |
                           /* No addition pin function */
                           IOCON_PIO_MODE_INACT |
                           /* Standard mode, output slew rate control is enabled */
                           IOCON_PIO_SLEW_STANDARD |
                           /* Input function is not inverted */
                           IOCON_PIO_INV_DI |
                           /* Enables digital function */
                           IOCON_PIO_DIGITAL_EN |
                           /* Open drain is disabled */
                           IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN31 (coords: 91) is configured as MCLK */
    IOCON_PinMuxSet(IOCON, BOARD_INITI2SPINS_MCLK_PORT, BOARD_INITI2SPINS_MCLK_PIN, MCLK);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitACCELPins:
- options: {callFromInitBoot: 'false', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '30', peripheral: FLEXCOMM4, signal: RXD_SDA_MOSI_DATA, pin_signal: PIO1_21/FC7_CTS_SDA_SSEL0/CTIMER3_MAT2/FC4_RXD_SDA_MOSI_DATA/PLU_OUT3, mode: pullUp,
    slew_rate: standard, invert: disabled, open_drain: disabled}
  - {pin_num: '4', peripheral: FLEXCOMM4, signal: TXD_SCL_MISO_WS, pin_signal: PIO1_20/FC7_RTS_SCL_SSEL1/CT_INP14/FC4_TXD_SCL_MISO_WS/PLU_OUT2, mode: pullUp, slew_rate: standard,
    invert: disabled, open_drain: disabled}
  - {pin_num: '58', peripheral: GPIO, signal: 'PIO1, 19', pin_signal: PIO1_19/SCT0_OUT7/CTIMER3_MAT1/SCT_GPI7/FC4_SCK/PLU_OUT1/ACMPVREF, direction: INPUT, mode: inactive,
    slew_rate: standard, invert: disabled, open_drain: disabled, asw: disabled}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitACCELPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitACCELPins(void)
{
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    /* Enables the clock for the GPIO1 module */
    CLOCK_EnableClock(kCLOCK_Gpio1);

    gpio_pin_config_t ACCL_INTR_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO1_19 (pin 58)  */
    GPIO_PinInit(BOARD_INITACCELPINS_ACCL_INTR_GPIO, BOARD_INITACCELPINS_ACCL_INTR_PORT, BOARD_INITACCELPINS_ACCL_INTR_PIN, &ACCL_INTR_config);

    const uint32_t ACCL_INTR = (/* Pin is configured as PIO1_19 */
                                IOCON_PIO_FUNC0 |
                                /* No addition pin function */
                                IOCON_PIO_MODE_INACT |
                                /* Standard mode, output slew rate control is enabled */
                                IOCON_PIO_SLEW_STANDARD |
                                /* Input function is not inverted */
                                IOCON_PIO_INV_DI |
                                /* Enables digital function */
                                IOCON_PIO_DIGITAL_EN |
                                /* Open drain is disabled */
                                IOCON_PIO_OPENDRAIN_DI |
                                /* Analog switch is open (disabled) */
                                IOCON_PIO_ASW_DI);
    /* PORT1 PIN19 (coords: 58) is configured as PIO1_19 */
    IOCON_PinMuxSet(IOCON, BOARD_INITACCELPINS_ACCL_INTR_PORT, BOARD_INITACCELPINS_ACCL_INTR_PIN, ACCL_INTR);

    const uint32_t FC4_I2C_SCL = (/* Pin is configured as FC4_TXD_SCL_MISO_WS */
                                  IOCON_PIO_FUNC5 |
                                  /* Selects pull-up function */
                                  IOCON_PIO_MODE_PULLUP |
                                  /* Standard mode, output slew rate control is enabled */
                                  IOCON_PIO_SLEW_STANDARD |
                                  /* Input function is not inverted */
                                  IOCON_PIO_INV_DI |
                                  /* Enables digital function */
                                  IOCON_PIO_DIGITAL_EN |
                                  /* Open drain is disabled */
                                  IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN20 (coords: 4) is configured as FC4_TXD_SCL_MISO_WS */
    IOCON_PinMuxSet(IOCON, BOARD_INITACCELPINS_FC4_I2C_SCL_PORT, BOARD_INITACCELPINS_FC4_I2C_SCL_PIN, FC4_I2C_SCL);

    const uint32_t FC4_I2C_SDA = (/* Pin is configured as FC4_RXD_SDA_MOSI_DATA */
                                  IOCON_PIO_FUNC5 |
                                  /* Selects pull-up function */
                                  IOCON_PIO_MODE_PULLUP |
                                  /* Standard mode, output slew rate control is enabled */
                                  IOCON_PIO_SLEW_STANDARD |
                                  /* Input function is not inverted */
                                  IOCON_PIO_INV_DI |
                                  /* Enables digital function */
                                  IOCON_PIO_DIGITAL_EN |
                                  /* Open drain is disabled */
                                  IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN21 (coords: 30) is configured as FC4_RXD_SDA_MOSI_DATA */
    IOCON_PinMuxSet(IOCON, BOARD_INITACCELPINS_FC4_I2C_SDA_PORT, BOARD_INITACCELPINS_FC4_I2C_SDA_PIN, FC4_I2C_SDA);
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
