/**
 * @file winc1500_config.h
 * @brief WINC1500 configuration
 *
 * @section License
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Copyright (C) 2010-2023 Oryx Embedded SARL. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.2.2
 **/

#ifndef _WINC1500_CONFIG_H
#define _WINC1500_CONFIG_H

//Dependencies
#include <stdint.h>

//SPI interface
#define CONF_WINC_USE_SPI               1

//Debug logs
#define CONF_WINC_DEBUG                 1
//Debug output redirection
#define CONF_WINC_PRINTF                TRACE_PRINTF

//RST pin (PB14)
#define CONF_WINC_RST_PIN               PIN_PB14
#define CONF_WINC_RST_MASK              PORT_PB14

//CE pin (unused)
#define CONF_WINC_CE_PIN                PIN_PB14
#define CONF_WINC_CE_MASK               PORT_PB14

//WAKE pin (unused)
#define CONF_WINC_WAKE_PIN              PIN_PB14
#define CONF_WINC_WAKE_MASK             PORT_PB14

//CS pin (PA18)
#define CONF_WINC_CS_PIN                PIN_PA18
#define CONF_WINC_CS_MASK               PORT_PA18

//IRQ pin (PB12)
#define CONF_WINC_IRQ_PIN               PIN_PB12
#define CONF_WINC_IRQ_MASK              PORT_PB12
#define CONF_WINC_IRQ_MUX()             PORT_REGS->GROUP[1].PORT_PMUX[6] = \
                                           (PORT_REGS->GROUP[1].PORT_PMUX[6] & ~PORT_PMUX_PMUXE_Msk) | \
                                           PORT_PMUX_PMUXE(MUX_PB12A_EIC_EXTINT12)
#define CONF_WINC_IRQ_CONFIG()          EIC_REGS->EIC_CONFIG[1] = \
                                           (EIC_REGS->EIC_CONFIG[1] & ~EIC_CONFIG_SENSE4_Msk) | \
                                           EIC_CONFIG_SENSE4_LOW

//SCK pin (PA13)
#define CONF_WINC_SCK_PIN               PIN_PA13
#define CONF_WINC_SCK_MASK              PORT_PA13
#define CONF_WINC_SCK_PAD               1
#define CONF_WINC_SCK_MUX()             PORT_REGS->GROUP[0].PORT_PMUX[6] = \
                                           (PORT_REGS->GROUP[0].PORT_PMUX[6] & ~PORT_PMUX_PMUXO_Msk) | \
                                           PORT_PMUX_PMUXO(MUX_PA13C_SERCOM2_PAD1)

//MOSI pin (PA12)
#define CONF_WINC_MOSI_PIN              PIN_PA12
#define CONF_WINC_MOSI_MASK             PORT_PA12
#define CONF_WINC_MOSI_PAD              0
#define CONF_WINC_MOSI_MUX()            PORT_REGS->GROUP[0].PORT_PMUX[6] = \
                                           (PORT_REGS->GROUP[0].PORT_PMUX[6] & ~PORT_PMUX_PMUXE_Msk) | \
                                           PORT_PMUX_PMUXE(MUX_PA12C_SERCOM2_PAD0)

//MISO pin (PA14)
#define CONF_WINC_MISO_PIN              PIN_PA14
#define CONF_WINC_MISO_MASK             PORT_PA14
#define CONF_WINC_MISO_PAD              2
#define CONF_WINC_MISO_MUX()            PORT_REGS->GROUP[0].PORT_PMUX[7] = \
                                           (PORT_REGS->GROUP[0].PORT_PMUX[7] & ~PORT_PMUX_PMUXE_Msk) | \
                                           PORT_PMUX_PMUXE(MUX_PA14C_SERCOM2_PAD2)

//SERCOM instance
#define CONF_WINC_SERCOM                SERCOM2_REGS
#define CONF_WINC_SERCOM_GCLK_ID_CORE   SERCOM2_GCLK_ID_CORE
#define CONF_WINC_SERCOM_APB_CLK_EN()   MCLK_REGS->MCLK_APBBMASK |= MCLK_APBBMASK_SERCOM2_Msk

//SPI clock
#define CONF_WINC_SPI_CLOCK             20000000

//IRQ number
#define CONF_WINC_IRQn                  EIC_EXTINT_12_IRQn
//IRQ handler
#define CONF_WINC_IRQHandler            EIC_EXTINT_12_Handler

//Interrupt priority grouping
#define CONF_WINC_IRQ_PRIORITY_GROUPING 4
//Interrupt group priority
#define CONF_WINC_IRQ_GROUP_PRIORITY    7
//Interrupt subpriority
#define CONF_WINC_IRQ_SUB_PRIORITY      0

//Forward function declaration
extern void winc1500EventHook(uint8_t msgType, void *msg);

//Callback function that processes Wi-Fi event notifications
#define CONF_WINC_EVENT_HOOK(msgType, msg) winc1500EventHook(msgType, msg)

#endif
