/**
 * @file system_ra6m2.c
 * @brief System configuration for Renesas RA6M2 device
 *
 * @section License
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Copyright (C) 2010-2023 Oryx Embedded SARL. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.2.2
 **/

#include "bsp_api.h"

//System clock frequency (120MHz)
uint32_t SystemCoreClock = 120000000;


/**
 * @brief Setup the system clock
 **/

void SystemInit(void)
{
   uint32_t temp;

   //Enable FPU
#if (__FPU_PRESENT == 1) && (__FPU_USED == 1)
   SCB->CPACR |= ((3UL << 10 * 2) | (3UL << 11 * 2));
#endif

   //Redirect the desired events to the NVIC
#if (BSP_IRQ_CFG_ICU_IRQ0 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ0_IRQn] = ELC_EVENT_ICU_IRQ0;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ1 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ1_IRQn] = ELC_EVENT_ICU_IRQ1;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ2 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ2_IRQn] = ELC_EVENT_ICU_IRQ2;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ3 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ3_IRQn] = ELC_EVENT_ICU_IRQ3;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ4 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ4_IRQn] = ELC_EVENT_ICU_IRQ4;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ5 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ5_IRQn] = ELC_EVENT_ICU_IRQ5;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ6 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ6_IRQn] = ELC_EVENT_ICU_IRQ6;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ7 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ7_IRQn] = ELC_EVENT_ICU_IRQ7;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ8 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ8_IRQn] = ELC_EVENT_ICU_IRQ8;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ9 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ9_IRQn] = ELC_EVENT_ICU_IRQ9;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ10 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ10_IRQn] = ELC_EVENT_ICU_IRQ10;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ11 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ11_IRQn] = ELC_EVENT_ICU_IRQ11;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ12 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ12_IRQn] = ELC_EVENT_ICU_IRQ12;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ13 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ13_IRQn] = ELC_EVENT_ICU_IRQ13;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ14 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ14_IRQn] = ELC_EVENT_ICU_IRQ14;
#endif
#if (BSP_IRQ_CFG_ICU_IRQ15 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_IRQ15_IRQn] = ELC_EVENT_ICU_IRQ15;
#endif
#if (BSP_IRQ_CFG_DMAC0_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[DMAC0_INT_IRQn] = ELC_EVENT_DMAC0_INT;
#endif
#if (BSP_IRQ_CFG_DMAC1_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[DMAC1_INT_IRQn] = ELC_EVENT_DMAC1_INT;
#endif
#if (BSP_IRQ_CFG_DMAC2_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[DMAC2_INT_IRQn] = ELC_EVENT_DMAC2_INT;
#endif
#if (BSP_IRQ_CFG_DMAC3_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[DMAC3_INT_IRQn] = ELC_EVENT_DMAC3_INT;
#endif
#if (BSP_IRQ_CFG_DMAC4_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[DMAC4_INT_IRQn] = ELC_EVENT_DMAC4_INT;
#endif
#if (BSP_IRQ_CFG_DMAC5_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[DMAC5_INT_IRQn] = ELC_EVENT_DMAC5_INT;
#endif
#if (BSP_IRQ_CFG_DMAC6_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[DMAC6_INT_IRQn] = ELC_EVENT_DMAC6_INT;
#endif
#if (BSP_IRQ_CFG_DMAC7_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[DMAC7_INT_IRQn] = ELC_EVENT_DMAC7_INT;
#endif
#if (BSP_IRQ_CFG_DTC_COMPLETE != BSP_IRQ_DISABLED)
   R_ICU->IELSR[DTC_COMPLETE_IRQn] = ELC_EVENT_DTC_COMPLETE;
#endif
#if (BSP_IRQ_CFG_DTC_END != BSP_IRQ_DISABLED)
   R_ICU->IELSR[DTC_END_IRQn] = ELC_EVENT_DTC_END;
#endif
#if (BSP_IRQ_CFG_ICU_SNOOZE_CANCEL != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ICU_SNOOZE_CANCEL_IRQn] = ELC_EVENT_ICU_SNOOZE_CANCEL;
#endif
#if (BSP_IRQ_CFG_FCU_FIFERR != BSP_IRQ_DISABLED)
   R_ICU->IELSR[FCU_FIFERR_IRQn] = ELC_EVENT_FCU_FIFERR;
#endif
#if (BSP_IRQ_CFG_FCU_FRDYI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[FCU_FRDYI_IRQn] = ELC_EVENT_FCU_FRDYI;
#endif
#if (BSP_IRQ_CFG_LVD_LVD1 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[LVD_LVD1_IRQn] = ELC_EVENT_LVD_LVD1;
#endif
#if (BSP_IRQ_CFG_LVD_LVD2 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[LVD_LVD2_IRQn] = ELC_EVENT_LVD_LVD2;
#endif
#if (BSP_IRQ_CFG_CGC_MOSC_STOP != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CGC_MOSC_STOP_IRQn] = ELC_EVENT_CGC_MOSC_STOP;
#endif
#if (BSP_IRQ_CFG_LPM_SNOOZE_REQUEST != BSP_IRQ_DISABLED)
   R_ICU->IELSR[LPM_SNOOZE_REQUEST_IRQn] = ELC_EVENT_LPM_SNOOZE_REQUEST;
#endif
#if (BSP_IRQ_CFG_AGT0_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[AGT0_INT_IRQn] = ELC_EVENT_AGT0_INT;
#endif
#if (BSP_IRQ_CFG_AGT0_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[AGT0_COMPARE_A_IRQn] = ELC_EVENT_AGT0_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_AGT0_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[AGT0_COMPARE_B_IRQn] = ELC_EVENT_AGT0_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_AGT1_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[AGT1_INT_IRQn] = ELC_EVENT_AGT1_INT;
#endif
#if (BSP_IRQ_CFG_AGT1_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[AGT1_COMPARE_A_IRQn] = ELC_EVENT_AGT1_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_AGT1_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[AGT1_COMPARE_B_IRQn] = ELC_EVENT_AGT1_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_IWDT_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IWDT_UNDERFLOW_IRQn] = ELC_EVENT_IWDT_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_WDT_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[WDT_UNDERFLOW_IRQn] = ELC_EVENT_WDT_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_RTC_ALARM != BSP_IRQ_DISABLED)
   R_ICU->IELSR[RTC_ALARM_IRQn] = ELC_EVENT_RTC_ALARM;
#endif
#if (BSP_IRQ_CFG_RTC_PERIOD != BSP_IRQ_DISABLED)
   R_ICU->IELSR[RTC_PERIOD_IRQn] = ELC_EVENT_RTC_PERIOD;
#endif
#if (BSP_IRQ_CFG_RTC_CARRY != BSP_IRQ_DISABLED)
   R_ICU->IELSR[RTC_CARRY_IRQn] = ELC_EVENT_RTC_CARRY;
#endif
#if (BSP_IRQ_CFG_ADC0_SCAN_END != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ADC0_SCAN_END_IRQn] = ELC_EVENT_ADC0_SCAN_END;
#endif
#if (BSP_IRQ_CFG_ADC0_SCAN_END_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ADC0_SCAN_END_B_IRQn] = ELC_EVENT_ADC0_SCAN_END_B;
#endif
#if (BSP_IRQ_CFG_ADC0_WINDOW_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ADC0_WINDOW_A_IRQn] = ELC_EVENT_ADC0_WINDOW_A;
#endif
#if (BSP_IRQ_CFG_ADC0_WINDOW_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ADC0_WINDOW_B_IRQn] = ELC_EVENT_ADC0_WINDOW_B;
#endif
#if (BSP_IRQ_CFG_ADC0_COMPARE_MATCH != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ADC0_COMPARE_MATCH_IRQn] = ELC_EVENT_ADC0_COMPARE_MATCH;
#endif
#if (BSP_IRQ_CFG_ADC0_COMPARE_MISMATCH != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ADC0_COMPARE_MISMATCH_IRQn] = ELC_EVENT_ADC0_COMPARE_MISMATCH;
#endif
#if (BSP_IRQ_CFG_ADC1_SCAN_END != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ADC1_SCAN_END_IRQn] = ELC_EVENT_ADC1_SCAN_END;
#endif
#if (BSP_IRQ_CFG_ADC1_SCAN_END_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ADC1_SCAN_END_B_IRQn] = ELC_EVENT_ADC1_SCAN_END_B;
#endif
#if (BSP_IRQ_CFG_ADC1_WINDOW_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ADC1_WINDOW_A_IRQn] = ELC_EVENT_ADC1_WINDOW_A;
#endif
#if (BSP_IRQ_CFG_ADC1_WINDOW_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ADC1_WINDOW_B_IRQn] = ELC_EVENT_ADC1_WINDOW_B;
#endif
#if (BSP_IRQ_CFG_ADC1_COMPARE_MATCH != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ADC1_COMPARE_MATCH_IRQn] = ELC_EVENT_ADC1_COMPARE_MATCH;
#endif
#if (BSP_IRQ_CFG_ADC1_COMPARE_MISMATCH != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ADC1_COMPARE_MISMATCH_IRQn] = ELC_EVENT_ADC1_COMPARE_MISMATCH;
#endif
#if (BSP_IRQ_CFG_ACMPHS0_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ACMPHS0_INT_IRQn] = ELC_EVENT_ACMPHS0_INT;
#endif
#if (BSP_IRQ_CFG_ACMPHS1_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ACMPHS1_INT_IRQn] = ELC_EVENT_ACMPHS1_INT;
#endif
#if (BSP_IRQ_CFG_ACMPHS2_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ACMPHS2_INT_IRQn] = ELC_EVENT_ACMPHS2_INT;
#endif
#if (BSP_IRQ_CFG_ACMPHS3_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ACMPHS3_INT_IRQn] = ELC_EVENT_ACMPHS3_INT;
#endif
#if (BSP_IRQ_CFG_ACMPHS4_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ACMPHS4_INT_IRQn] = ELC_EVENT_ACMPHS4_INT;
#endif
#if (BSP_IRQ_CFG_ACMPHS5_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ACMPHS5_INT_IRQn] = ELC_EVENT_ACMPHS5_INT;
#endif
#if (BSP_IRQ_CFG_USBFS_FIFO_0 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[USBFS_FIFO_0_IRQn] = ELC_EVENT_USBFS_FIFO_0;
#endif
#if (BSP_IRQ_CFG_USBFS_FIFO_1 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[USBFS_FIFO_1_IRQn] = ELC_EVENT_USBFS_FIFO_1;
#endif
#if (BSP_IRQ_CFG_USBFS_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[USBFS_INT_IRQn] = ELC_EVENT_USBFS_INT;
#endif
#if (BSP_IRQ_CFG_USBFS_RESUME != BSP_IRQ_DISABLED)
   R_ICU->IELSR[USBFS_RESUME_IRQn] = ELC_EVENT_USBFS_RESUME;
#endif
#if (BSP_IRQ_CFG_IIC0_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IIC0_RXI_IRQn] = ELC_EVENT_IIC0_RXI;
#endif
#if (BSP_IRQ_CFG_IIC0_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IIC0_TXI_IRQn] = ELC_EVENT_IIC0_TXI;
#endif
#if (BSP_IRQ_CFG_IIC0_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IIC0_TEI_IRQn] = ELC_EVENT_IIC0_TEI;
#endif
#if (BSP_IRQ_CFG_IIC0_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IIC0_ERI_IRQn] = ELC_EVENT_IIC0_ERI;
#endif
#if (BSP_IRQ_CFG_IIC0_WUI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IIC0_WUI_IRQn] = ELC_EVENT_IIC0_WUI;
#endif
#if (BSP_IRQ_CFG_IIC1_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IIC1_RXI_IRQn] = ELC_EVENT_IIC1_RXI;
#endif
#if (BSP_IRQ_CFG_IIC1_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IIC1_TXI_IRQn] = ELC_EVENT_IIC1_TXI;
#endif
#if (BSP_IRQ_CFG_IIC1_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IIC1_TEI_IRQn] = ELC_EVENT_IIC1_TEI;
#endif
#if (BSP_IRQ_CFG_IIC1_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IIC1_ERI_IRQn] = ELC_EVENT_IIC1_ERI;
#endif
#if (BSP_IRQ_CFG_IIC2_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IIC2_RXI_IRQn] = ELC_EVENT_IIC2_RXI;
#endif
#if (BSP_IRQ_CFG_IIC2_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IIC2_TXI_IRQn] = ELC_EVENT_IIC2_TXI;
#endif
#if (BSP_IRQ_CFG_IIC2_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IIC2_TEI_IRQn] = ELC_EVENT_IIC2_TEI;
#endif
#if (BSP_IRQ_CFG_IIC2_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IIC2_ERI_IRQn] = ELC_EVENT_IIC2_ERI;
#endif
#if (BSP_IRQ_CFG_SSI0_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SSI0_TXI_IRQn] = ELC_EVENT_SSI0_TXI;
#endif
#if (BSP_IRQ_CFG_SSI0_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SSI0_RXI_IRQn] = ELC_EVENT_SSI0_RXI;
#endif
#if (BSP_IRQ_CFG_SSI0_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SSI0_INT_IRQn] = ELC_EVENT_SSI0_INT;
#endif
#if (BSP_IRQ_CFG_SRC_INPUT_FIFO_EMPTY != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SRC_INPUT_FIFO_EMPTY_IRQn] = ELC_EVENT_SRC_INPUT_FIFO_EMPTY;
#endif
#if (BSP_IRQ_CFG_SRC_OUTPUT_FIFO_FULL != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SRC_OUTPUT_FIFO_FULL_IRQn] = ELC_EVENT_SRC_OUTPUT_FIFO_FULL;
#endif
#if (BSP_IRQ_CFG_SRC_OUTPUT_FIFO_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SRC_OUTPUT_FIFO_OVERFLOW_IRQn] = ELC_EVENT_SRC_OUTPUT_FIFO_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_SRC_OUTPUT_FIFO_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SRC_OUTPUT_FIFO_UNDERFLOW_IRQn] = ELC_EVENT_SRC_OUTPUT_FIFO_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_SRC_CONVERSION_END != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SRC_CONVERSION_END_IRQn] = ELC_EVENT_SRC_CONVERSION_END;
#endif
#if (BSP_IRQ_CFG_PDC_RECEIVE_DATA_READY != BSP_IRQ_DISABLED)
   R_ICU->IELSR[PDC_RECEIVE_DATA_READY_IRQn] = ELC_EVENT_PDC_RECEIVE_DATA_READY;
#endif
#if (BSP_IRQ_CFG_PDC_FRAME_END != BSP_IRQ_DISABLED)
   R_ICU->IELSR[PDC_FRAME_END_IRQn] = ELC_EVENT_PDC_FRAME_END;
#endif
#if (BSP_IRQ_CFG_PDC_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[PDC_INT_IRQn] = ELC_EVENT_PDC_INT;
#endif
#if (BSP_IRQ_CFG_CTSU_WRITE != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CTSU_WRITE_IRQn] = ELC_EVENT_CTSU_WRITE;
#endif
#if (BSP_IRQ_CFG_CTSU_READ != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CTSU_READ_IRQn] = ELC_EVENT_CTSU_READ;
#endif
#if (BSP_IRQ_CFG_CTSU_END != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CTSU_END_IRQn] = ELC_EVENT_CTSU_END;
#endif
#if (BSP_IRQ_CFG_KEY_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[KEY_INT_IRQn] = ELC_EVENT_KEY_INT;
#endif
#if (BSP_IRQ_CFG_DOC_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[DOC_INT_IRQn] = ELC_EVENT_DOC_INT;
#endif
#if (BSP_IRQ_CFG_CAC_FREQUENCY_ERROR != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CAC_FREQUENCY_ERROR_IRQn] = ELC_EVENT_CAC_FREQUENCY_ERROR;
#endif
#if (BSP_IRQ_CFG_CAC_MEASUREMENT_END != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CAC_MEASUREMENT_END_IRQn] = ELC_EVENT_CAC_MEASUREMENT_END;
#endif
#if (BSP_IRQ_CFG_CAC_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CAC_OVERFLOW_IRQn] = ELC_EVENT_CAC_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_CAN0_ERROR != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CAN0_ERROR_IRQn] = ELC_EVENT_CAN0_ERROR;
#endif
#if (BSP_IRQ_CFG_CAN0_FIFO_RX != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CAN0_FIFO_RX_IRQn] = ELC_EVENT_CAN0_FIFO_RX;
#endif
#if (BSP_IRQ_CFG_CAN0_FIFO_TX != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CAN0_FIFO_TX_IRQn] = ELC_EVENT_CAN0_FIFO_TX;
#endif
#if (BSP_IRQ_CFG_CAN0_MAILBOX_RX != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CAN0_MAILBOX_RX_IRQn] = ELC_EVENT_CAN0_MAILBOX_RX;
#endif
#if (BSP_IRQ_CFG_CAN0_MAILBOX_TX != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CAN0_MAILBOX_TX_IRQn] = ELC_EVENT_CAN0_MAILBOX_TX;
#endif
#if (BSP_IRQ_CFG_CAN1_ERROR != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CAN1_ERROR_IRQn] = ELC_EVENT_CAN1_ERROR;
#endif
#if (BSP_IRQ_CFG_CAN1_FIFO_RX != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CAN1_FIFO_RX_IRQn] = ELC_EVENT_CAN1_FIFO_RX;
#endif
#if (BSP_IRQ_CFG_CAN1_FIFO_TX != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CAN1_FIFO_TX_IRQn] = ELC_EVENT_CAN1_FIFO_TX;
#endif
#if (BSP_IRQ_CFG_CAN1_MAILBOX_RX != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CAN1_MAILBOX_RX_IRQn] = ELC_EVENT_CAN1_MAILBOX_RX;
#endif
#if (BSP_IRQ_CFG_CAN1_MAILBOX_TX != BSP_IRQ_DISABLED)
   R_ICU->IELSR[CAN1_MAILBOX_TX_IRQn] = ELC_EVENT_CAN1_MAILBOX_TX;
#endif
#if (BSP_IRQ_CFG_IOPORT_EVENT_1 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IOPORT_EVENT_1_IRQn] = ELC_EVENT_IOPORT_EVENT_1;
#endif
#if (BSP_IRQ_CFG_IOPORT_EVENT_2 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IOPORT_EVENT_2_IRQn] = ELC_EVENT_IOPORT_EVENT_2;
#endif
#if (BSP_IRQ_CFG_IOPORT_EVENT_3 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IOPORT_EVENT_3_IRQn] = ELC_EVENT_IOPORT_EVENT_3;
#endif
#if (BSP_IRQ_CFG_IOPORT_EVENT_4 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[IOPORT_EVENT_4_IRQn] = ELC_EVENT_IOPORT_EVENT_4;
#endif
#if (BSP_IRQ_CFG_ELC_SOFTWARE_EVENT_0 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ELC_SOFTWARE_EVENT_0_IRQn] = ELC_EVENT_ELC_SOFTWARE_EVENT_0;
#endif
#if (BSP_IRQ_CFG_ELC_SOFTWARE_EVENT_1 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[ELC_SOFTWARE_EVENT_1_IRQn] = ELC_EVENT_ELC_SOFTWARE_EVENT_1;
#endif
#if (BSP_IRQ_CFG_POEG0_EVENT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[POEG0_EVENT_IRQn] = ELC_EVENT_POEG0_EVENT;
#endif
#if (BSP_IRQ_CFG_POEG1_EVENT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[POEG1_EVENT_IRQn] = ELC_EVENT_POEG1_EVENT;
#endif
#if (BSP_IRQ_CFG_POEG2_EVENT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[POEG2_EVENT_IRQn] = ELC_EVENT_POEG2_EVENT;
#endif
#if (BSP_IRQ_CFG_POEG3_EVENT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[POEG3_EVENT_IRQn] = ELC_EVENT_POEG3_EVENT;
#endif
#if (BSP_IRQ_CFG_GPT0_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT0_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT0_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT0_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT0_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT0_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT0_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT0_COMPARE_C_IRQn] = ELC_EVENT_GPT0_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT0_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT0_COMPARE_D_IRQn] = ELC_EVENT_GPT0_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT0_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT0_COMPARE_E_IRQn] = ELC_EVENT_GPT0_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT0_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT0_COMPARE_F_IRQn] = ELC_EVENT_GPT0_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT0_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT0_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT0_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT0_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT0_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT0_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT0_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT0_AD_TRIG_A_IRQn] = ELC_EVENT_GPT0_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT0_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT0_AD_TRIG_B_IRQn] = ELC_EVENT_GPT0_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT1_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT1_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT1_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT1_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT1_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT1_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT1_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT1_COMPARE_C_IRQn] = ELC_EVENT_GPT1_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT1_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT1_COMPARE_D_IRQn] = ELC_EVENT_GPT1_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT1_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT1_COMPARE_E_IRQn] = ELC_EVENT_GPT1_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT1_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT1_COMPARE_F_IRQn] = ELC_EVENT_GPT1_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT1_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT1_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT1_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT1_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT1_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT1_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT1_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT1_AD_TRIG_A_IRQn] = ELC_EVENT_GPT1_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT1_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT1_AD_TRIG_B_IRQn] = ELC_EVENT_GPT1_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT2_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT2_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT2_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT2_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT2_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT2_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT2_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT2_COMPARE_C_IRQn] = ELC_EVENT_GPT2_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT2_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT2_COMPARE_D_IRQn] = ELC_EVENT_GPT2_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT2_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT2_COMPARE_E_IRQn] = ELC_EVENT_GPT2_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT2_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT2_COMPARE_F_IRQn] = ELC_EVENT_GPT2_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT2_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT2_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT2_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT2_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT2_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT2_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT2_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT2_AD_TRIG_A_IRQn] = ELC_EVENT_GPT2_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT2_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT2_AD_TRIG_B_IRQn] = ELC_EVENT_GPT2_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT3_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT3_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT3_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT3_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT3_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT3_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT3_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT3_COMPARE_C_IRQn] = ELC_EVENT_GPT3_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT3_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT3_COMPARE_D_IRQn] = ELC_EVENT_GPT3_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT3_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT3_COMPARE_E_IRQn] = ELC_EVENT_GPT3_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT3_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT3_COMPARE_F_IRQn] = ELC_EVENT_GPT3_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT3_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT3_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT3_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT3_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT3_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT3_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT3_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT3_AD_TRIG_A_IRQn] = ELC_EVENT_GPT3_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT3_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT3_AD_TRIG_B_IRQn] = ELC_EVENT_GPT3_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT4_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT4_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT4_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT4_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT4_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT4_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT4_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT4_COMPARE_C_IRQn] = ELC_EVENT_GPT4_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT4_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT4_COMPARE_D_IRQn] = ELC_EVENT_GPT4_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT4_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT4_COMPARE_E_IRQn] = ELC_EVENT_GPT4_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT4_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT4_COMPARE_F_IRQn] = ELC_EVENT_GPT4_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT4_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT4_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT4_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT4_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT4_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT4_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT4_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT4_AD_TRIG_A_IRQn] = ELC_EVENT_GPT4_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT4_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT4_AD_TRIG_B_IRQn] = ELC_EVENT_GPT4_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT5_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT5_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT5_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT5_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT5_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT5_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT5_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT5_COMPARE_C_IRQn] = ELC_EVENT_GPT5_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT5_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT5_COMPARE_D_IRQn] = ELC_EVENT_GPT5_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT5_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT5_COMPARE_E_IRQn] = ELC_EVENT_GPT5_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT5_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT5_COMPARE_F_IRQn] = ELC_EVENT_GPT5_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT5_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT5_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT5_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT5_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT5_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT5_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT5_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT5_AD_TRIG_A_IRQn] = ELC_EVENT_GPT5_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT5_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT5_AD_TRIG_B_IRQn] = ELC_EVENT_GPT5_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT6_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT6_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT6_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT6_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT6_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT6_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT6_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT6_COMPARE_C_IRQn] = ELC_EVENT_GPT6_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT6_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT6_COMPARE_D_IRQn] = ELC_EVENT_GPT6_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT6_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT6_COMPARE_E_IRQn] = ELC_EVENT_GPT6_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT6_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT6_COMPARE_F_IRQn] = ELC_EVENT_GPT6_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT6_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT6_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT6_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT6_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT6_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT6_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT6_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT6_AD_TRIG_A_IRQn] = ELC_EVENT_GPT6_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT6_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT6_AD_TRIG_B_IRQn] = ELC_EVENT_GPT6_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT7_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT7_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT7_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT7_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT7_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT7_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT7_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT7_COMPARE_C_IRQn] = ELC_EVENT_GPT7_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT7_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT7_COMPARE_D_IRQn] = ELC_EVENT_GPT7_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT7_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT7_COMPARE_E_IRQn] = ELC_EVENT_GPT7_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT7_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT7_COMPARE_F_IRQn] = ELC_EVENT_GPT7_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT7_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT7_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT7_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT7_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT7_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT7_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT7_AD_TRIG_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT7_AD_TRIG_A_IRQn] = ELC_EVENT_GPT7_AD_TRIG_A;
#endif
#if (BSP_IRQ_CFG_GPT7_AD_TRIG_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT7_AD_TRIG_B_IRQn] = ELC_EVENT_GPT7_AD_TRIG_B;
#endif
#if (BSP_IRQ_CFG_GPT8_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT8_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT8_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT8_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT8_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT8_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT8_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT8_COMPARE_C_IRQn] = ELC_EVENT_GPT8_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT8_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT8_COMPARE_D_IRQn] = ELC_EVENT_GPT8_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT8_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT8_COMPARE_E_IRQn] = ELC_EVENT_GPT8_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT8_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT8_COMPARE_F_IRQn] = ELC_EVENT_GPT8_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT8_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT8_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT8_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT8_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT8_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT8_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT9_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT9_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT9_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT9_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT9_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT9_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT9_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT9_COMPARE_C_IRQn] = ELC_EVENT_GPT9_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT9_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT9_COMPARE_D_IRQn] = ELC_EVENT_GPT9_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT9_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT9_COMPARE_E_IRQn] = ELC_EVENT_GPT9_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT9_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT9_COMPARE_F_IRQn] = ELC_EVENT_GPT9_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT9_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT9_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT9_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT9_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT9_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT9_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT10_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT10_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT10_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT10_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT10_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT10_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT10_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT10_COMPARE_C_IRQn] = ELC_EVENT_GPT10_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT10_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT10_COMPARE_D_IRQn] = ELC_EVENT_GPT10_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT10_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT10_COMPARE_E_IRQn] = ELC_EVENT_GPT10_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT10_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT10_COMPARE_F_IRQn] = ELC_EVENT_GPT10_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT10_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT10_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT10_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT10_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT10_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT10_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT11_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT11_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT11_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT11_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT11_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT11_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT11_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT11_COMPARE_C_IRQn] = ELC_EVENT_GPT11_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT11_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT11_COMPARE_D_IRQn] = ELC_EVENT_GPT11_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT11_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT11_COMPARE_E_IRQn] = ELC_EVENT_GPT11_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT11_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT11_COMPARE_F_IRQn] = ELC_EVENT_GPT11_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT11_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT11_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT11_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT11_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT11_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT11_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT12_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT12_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT12_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT12_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT12_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT12_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT12_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT12_COMPARE_C_IRQn] = ELC_EVENT_GPT12_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT12_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT12_COMPARE_D_IRQn] = ELC_EVENT_GPT12_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT12_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT12_COMPARE_E_IRQn] = ELC_EVENT_GPT12_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT12_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT12_COMPARE_F_IRQn] = ELC_EVENT_GPT12_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT12_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT12_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT12_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT12_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT12_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT12_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT13_CAPTURE_COMPARE_A != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT13_CAPTURE_COMPARE_A_IRQn] = ELC_EVENT_GPT13_CAPTURE_COMPARE_A;
#endif
#if (BSP_IRQ_CFG_GPT13_CAPTURE_COMPARE_B != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT13_CAPTURE_COMPARE_B_IRQn] = ELC_EVENT_GPT13_CAPTURE_COMPARE_B;
#endif
#if (BSP_IRQ_CFG_GPT13_COMPARE_C != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT13_COMPARE_C_IRQn] = ELC_EVENT_GPT13_COMPARE_C;
#endif
#if (BSP_IRQ_CFG_GPT13_COMPARE_D != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT13_COMPARE_D_IRQn] = ELC_EVENT_GPT13_COMPARE_D;
#endif
#if (BSP_IRQ_CFG_GPT13_COMPARE_E != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT13_COMPARE_E_IRQn] = ELC_EVENT_GPT13_COMPARE_E;
#endif
#if (BSP_IRQ_CFG_GPT13_COMPARE_F != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT13_COMPARE_F_IRQn] = ELC_EVENT_GPT13_COMPARE_F;
#endif
#if (BSP_IRQ_CFG_GPT13_COUNTER_OVERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT13_COUNTER_OVERFLOW_IRQn] = ELC_EVENT_GPT13_COUNTER_OVERFLOW;
#endif
#if (BSP_IRQ_CFG_GPT13_COUNTER_UNDERFLOW != BSP_IRQ_DISABLED)
   R_ICU->IELSR[GPT13_COUNTER_UNDERFLOW_IRQn] = ELC_EVENT_GPT13_COUNTER_UNDERFLOW;
#endif
#if (BSP_IRQ_CFG_OPS_UVW_EDGE != BSP_IRQ_DISABLED)
   R_ICU->IELSR[OPS_UVW_EDGE_IRQn] = ELC_EVENT_OPS_UVW_EDGE;
#endif
#if (BSP_IRQ_CFG_EDMAC0_EINT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[EDMAC0_EINT_IRQn] = ELC_EVENT_EDMAC0_EINT;
#endif
#if (BSP_IRQ_CFG_SCI0_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI0_RXI_IRQn] = ELC_EVENT_SCI0_RXI;
#endif
#if (BSP_IRQ_CFG_SCI0_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI0_TXI_IRQn] = ELC_EVENT_SCI0_TXI;
#endif
#if (BSP_IRQ_CFG_SCI0_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI0_TEI_IRQn] = ELC_EVENT_SCI0_TEI;
#endif
#if (BSP_IRQ_CFG_SCI0_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI0_ERI_IRQn] = ELC_EVENT_SCI0_ERI;
#endif
#if (BSP_IRQ_CFG_SCI0_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI0_AM_IRQn] = ELC_EVENT_SCI0_AM;
#endif
#if (BSP_IRQ_CFG_SCI0_RXI_OR_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI0_RXI_OR_ERI_IRQn] = ELC_EVENT_SCI0_RXI_OR_ERI;
#endif
#if (BSP_IRQ_CFG_SCI1_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI1_RXI_IRQn] = ELC_EVENT_SCI1_RXI;
#endif
#if (BSP_IRQ_CFG_SCI1_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI1_TXI_IRQn] = ELC_EVENT_SCI1_TXI;
#endif
#if (BSP_IRQ_CFG_SCI1_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI1_TEI_IRQn] = ELC_EVENT_SCI1_TEI;
#endif
#if (BSP_IRQ_CFG_SCI1_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI1_ERI_IRQn] = ELC_EVENT_SCI1_ERI;
#endif
#if (BSP_IRQ_CFG_SCI1_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI1_AM_IRQn] = ELC_EVENT_SCI1_AM;
#endif
#if (BSP_IRQ_CFG_SCI2_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI2_RXI_IRQn] = ELC_EVENT_SCI2_RXI;
#endif
#if (BSP_IRQ_CFG_SCI2_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI2_TXI_IRQn] = ELC_EVENT_SCI2_TXI;
#endif
#if (BSP_IRQ_CFG_SCI2_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI2_TEI_IRQn] = ELC_EVENT_SCI2_TEI;
#endif
#if (BSP_IRQ_CFG_SCI2_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI2_ERI_IRQn] = ELC_EVENT_SCI2_ERI;
#endif
#if (BSP_IRQ_CFG_SCI2_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI2_AM_IRQn] = ELC_EVENT_SCI2_AM;
#endif
#if (BSP_IRQ_CFG_SCI3_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI3_RXI_IRQn] = ELC_EVENT_SCI3_RXI;
#endif
#if (BSP_IRQ_CFG_SCI3_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI3_TXI_IRQn] = ELC_EVENT_SCI3_TXI;
#endif
#if (BSP_IRQ_CFG_SCI3_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI3_TEI_IRQn] = ELC_EVENT_SCI3_TEI;
#endif
#if (BSP_IRQ_CFG_SCI3_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI3_ERI_IRQn] = ELC_EVENT_SCI3_ERI;
#endif
#if (BSP_IRQ_CFG_SCI3_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI3_AM_IRQn] = ELC_EVENT_SCI3_AM;
#endif
#if (BSP_IRQ_CFG_SCI4_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI4_RXI_IRQn] = ELC_EVENT_SCI4_RXI;
#endif
#if (BSP_IRQ_CFG_SCI4_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI4_TXI_IRQn] = ELC_EVENT_SCI4_TXI;
#endif
#if (BSP_IRQ_CFG_SCI4_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI4_TEI_IRQn] = ELC_EVENT_SCI4_TEI;
#endif
#if (BSP_IRQ_CFG_SCI4_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI4_ERI_IRQn] = ELC_EVENT_SCI4_ERI;
#endif
#if (BSP_IRQ_CFG_SCI4_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI4_AM_IRQn] = ELC_EVENT_SCI4_AM;
#endif
#if (BSP_IRQ_CFG_SCI5_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI5_RXI_IRQn] = ELC_EVENT_SCI5_RXI;
#endif
#if (BSP_IRQ_CFG_SCI5_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI5_TXI_IRQn] = ELC_EVENT_SCI5_TXI;
#endif
#if (BSP_IRQ_CFG_SCI5_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI5_TEI_IRQn] = ELC_EVENT_SCI5_TEI;
#endif
#if (BSP_IRQ_CFG_SCI5_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI5_ERI_IRQn] = ELC_EVENT_SCI5_ERI;
#endif
#if (BSP_IRQ_CFG_SCI5_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI5_AM_IRQn] = ELC_EVENT_SCI5_AM;
#endif
#if (BSP_IRQ_CFG_SCI6_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI6_RXI_IRQn] = ELC_EVENT_SCI6_RXI;
#endif
#if (BSP_IRQ_CFG_SCI6_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI6_TXI_IRQn] = ELC_EVENT_SCI6_TXI;
#endif
#if (BSP_IRQ_CFG_SCI6_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI6_TEI_IRQn] = ELC_EVENT_SCI6_TEI;
#endif
#if (BSP_IRQ_CFG_SCI6_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI6_ERI_IRQn] = ELC_EVENT_SCI6_ERI;
#endif
#if (BSP_IRQ_CFG_SCI6_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI6_AM_IRQn] = ELC_EVENT_SCI6_AM;
#endif
#if (BSP_IRQ_CFG_SCI7_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI7_RXI_IRQn] = ELC_EVENT_SCI7_RXI;
#endif
#if (BSP_IRQ_CFG_SCI7_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI7_TXI_IRQn] = ELC_EVENT_SCI7_TXI;
#endif
#if (BSP_IRQ_CFG_SCI7_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI7_TEI_IRQn] = ELC_EVENT_SCI7_TEI;
#endif
#if (BSP_IRQ_CFG_SCI7_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI7_ERI_IRQn] = ELC_EVENT_SCI7_ERI;
#endif
#if (BSP_IRQ_CFG_SCI7_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI7_AM_IRQn] = ELC_EVENT_SCI7_AM;
#endif
#if (BSP_IRQ_CFG_SCI8_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI8_RXI_IRQn] = ELC_EVENT_SCI8_RXI;
#endif
#if (BSP_IRQ_CFG_SCI8_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI8_TXI_IRQn] = ELC_EVENT_SCI8_TXI;
#endif
#if (BSP_IRQ_CFG_SCI8_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI8_TEI_IRQn] = ELC_EVENT_SCI8_TEI;
#endif
#if (BSP_IRQ_CFG_SCI8_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI8_ERI_IRQn] = ELC_EVENT_SCI8_ERI;
#endif
#if (BSP_IRQ_CFG_SCI8_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI8_AM_IRQn] = ELC_EVENT_SCI8_AM;
#endif
#if (BSP_IRQ_CFG_SCI9_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI9_RXI_IRQn] = ELC_EVENT_SCI9_RXI;
#endif
#if (BSP_IRQ_CFG_SCI9_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI9_TXI_IRQn] = ELC_EVENT_SCI9_TXI;
#endif
#if (BSP_IRQ_CFG_SCI9_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI9_TEI_IRQn] = ELC_EVENT_SCI9_TEI;
#endif
#if (BSP_IRQ_CFG_SCI9_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI9_ERI_IRQn] = ELC_EVENT_SCI9_ERI;
#endif
#if (BSP_IRQ_CFG_SCI9_AM != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCI9_AM_IRQn] = ELC_EVENT_SCI9_AM;
#endif
#if (BSP_IRQ_CFG_SPI0_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SPI0_RXI_IRQn] = ELC_EVENT_SPI0_RXI;
#endif
#if (BSP_IRQ_CFG_SPI0_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SPI0_TXI_IRQn] = ELC_EVENT_SPI0_TXI;
#endif
#if (BSP_IRQ_CFG_SPI0_IDLE != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SPI0_IDLE_IRQn] = ELC_EVENT_SPI0_IDLE;
#endif
#if (BSP_IRQ_CFG_SPI0_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SPI0_ERI_IRQn] = ELC_EVENT_SPI0_ERI;
#endif
#if (BSP_IRQ_CFG_SPI0_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SPI0_TEI_IRQn] = ELC_EVENT_SPI0_TEI;
#endif
#if (BSP_IRQ_CFG_SPI1_RXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SPI1_RXI_IRQn] = ELC_EVENT_SPI1_RXI;
#endif
#if (BSP_IRQ_CFG_SPI1_TXI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SPI1_TXI_IRQn] = ELC_EVENT_SPI1_TXI;
#endif
#if (BSP_IRQ_CFG_SPI1_IDLE != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SPI1_IDLE_IRQn] = ELC_EVENT_SPI1_IDLE;
#endif
#if (BSP_IRQ_CFG_SPI1_ERI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SPI1_ERI_IRQn] = ELC_EVENT_SPI1_ERI;
#endif
#if (BSP_IRQ_CFG_SPI1_TEI != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SPI1_TEI_IRQn] = ELC_EVENT_SPI1_TEI;
#endif
#if (BSP_IRQ_CFG_QSPI_INT != BSP_IRQ_DISABLED)
   R_ICU->IELSR[QSPI_INT_IRQn] = ELC_EVENT_QSPI_INT;
#endif
#if (BSP_IRQ_CFG_SDHIMMC0_ACCS != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SDHIMMC0_ACCS_IRQn] = ELC_EVENT_SDHIMMC0_ACCS;
#endif
#if (BSP_IRQ_CFG_SDHIMMC0_SDIO != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SDHIMMC0_SDIO_IRQn] = ELC_EVENT_SDHIMMC0_SDIO;
#endif
#if (BSP_IRQ_CFG_SDHIMMC0_CARD != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SDHIMMC0_CARD_IRQn] = ELC_EVENT_SDHIMMC0_CARD;
#endif
#if (BSP_IRQ_CFG_SDHIMMC0_DMA_REQ != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SDHIMMC0_DMA_REQ_IRQn] = ELC_EVENT_SDHIMMC0_DMA_REQ;
#endif
#if (BSP_IRQ_CFG_SDHIMMC1_ACCS != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SDHIMMC1_ACCS_IRQn] = ELC_EVENT_SDHIMMC1_ACCS;
#endif
#if (BSP_IRQ_CFG_SDHIMMC1_SDIO != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SDHIMMC1_SDIO_IRQn] = ELC_EVENT_SDHIMMC1_SDIO;
#endif
#if (BSP_IRQ_CFG_SDHIMMC1_CARD != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SDHIMMC1_CARD_IRQn] = ELC_EVENT_SDHIMMC1_CARD;
#endif
#if (BSP_IRQ_CFG_SDHIMMC1_DMA_REQ != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SDHIMMC1_DMA_REQ_IRQn] = ELC_EVENT_SDHIMMC1_DMA_REQ;
#endif
#if (BSP_IRQ_CFG_SCE_PROC_BUSY != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCE_PROC_BUSY_IRQn] = ELC_EVENT_SCE_PROC_BUSY;
#endif
#if (BSP_IRQ_CFG_SCE_ROMOK != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCE_ROMOK_IRQn] = ELC_EVENT_SCE_ROMOK;
#endif
#if (BSP_IRQ_CFG_SCE_LONG_PLG != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCE_LONG_PLG_IRQn] = ELC_EVENT_SCE_LONG_PLG;
#endif
#if (BSP_IRQ_CFG_SCE_TEST_BUSY != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCE_TEST_BUSY_IRQn] = ELC_EVENT_SCE_TEST_BUSY;
#endif
#if (BSP_IRQ_CFG_SCE_WRRDY_0 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCE_WRRDY_0_IRQn] = ELC_EVENT_SCE_WRRDY_0;
#endif
#if (BSP_IRQ_CFG_SCE_WRRDY_1 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCE_WRRDY_1_IRQn] = ELC_EVENT_SCE_WRRDY_1;
#endif
#if (BSP_IRQ_CFG_SCE_WRRDY_4 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCE_WRRDY_4_IRQn] = ELC_EVENT_SCE_WRRDY_4;
#endif
#if (BSP_IRQ_CFG_SCE_RDRDY_0 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCE_RDRDY_0_IRQn] = ELC_EVENT_SCE_RDRDY_0;
#endif
#if (BSP_IRQ_CFG_SCE_RDRDY_1 != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCE_RDRDY_1_IRQn] = ELC_EVENT_SCE_RDRDY_1;
#endif
#if (BSP_IRQ_CFG_SCE_INTEGRATE_WRRDY != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCE_INTEGRATE_WRRDY_IRQn] = ELC_EVENT_SCE_INTEGRATE_WRRDY;
#endif
#if (BSP_IRQ_CFG_SCE_INTEGRATE_RDRDY != BSP_IRQ_DISABLED)
   R_ICU->IELSR[SCE_INTEGRATE_RDRDY_IRQn] = ELC_EVENT_SCE_INTEGRATE_RDRDY;
#endif

   //Disable write protection
   R_SYSTEM->PRCR = 0xA50B;

#if BSP_FEATURE_BSP_FLASH_CACHE
   //Invalidate the Flash cache
   R_FCACHE->FCACHEIV = R_FCACHE_FCACHEIV_FCACHEIV_Msk;

   //Wait until the Flash cache is invalidated
   while((R_FCACHE->FCACHEIV & R_FCACHE_FCACHEIV_FCACHEIV_Msk) != 0)
   {
   }

   //Enable Flash cache
   R_FCACHE->FCACHEE = R_FCACHE_FCACHEE_FCACHEEN_Msk;
#endif

#if BSP_FEATURE_BSP_HAS_CODE_SYSTEM_CACHE
   //Configure C-Cache line size (32 bytes)
   R_CACHE->CCALCF = (1 << R_CACHE_CCALCF_CC_Pos);
   //Enable C-Cache
   R_CACHE->CCACTL = R_CACHE_CCACTL_ENC_Msk;
#endif

   //Select main clock
   R_SYSTEM->MOMCR &= ~R_SYSTEM_MOMCR_MOSEL_Msk;

   //Set main clock oscillator drive capability (8 to 16MHz)
   temp = R_SYSTEM->MOMCR & ~R_SYSTEM_MOMCR_MODRV0_Msk;
   R_SYSTEM->MOMCR = temp | (2 << R_SYSTEM_MOMCR_MODRV0_Pos);

   //Start main clock operation
   R_SYSTEM->MOSCCR &= ~R_SYSTEM_MOSCCR_MOSTP_Msk;

   //Wait for the main clock to stabilize
   while((R_SYSTEM->OSCSF & R_SYSTEM_OSCSF_MOSCSF_Msk) == 0)
   {
   }

   //Configure PLL source (main clock), PLL multiplication ratio (x20) and
   //PLL input division ratio (/1)
   R_SYSTEM->PLLCCR = (0 << R_SYSTEM_PLLCCR_PLSRCSEL_Pos) |
      (39 << R_SYSTEM_PLLCCR_PLLMUL_Pos) | (0 << R_SYSTEM_PLLCCR_PLIDIV_Pos);

   //Start PLL
   R_SYSTEM->PLLCR &= ~R_SYSTEM_PLLCR_PLLSTP_Msk;

   //Wait for the PLL to stabilize
   while((R_SYSTEM->OSCSF & R_SYSTEM_OSCSF_PLLSF_Msk) == 0)
   {
   }

   //Set Flash wait states
   R_FCACHE->FLWT = 2;

   //Set FCK, ICK, BCK, PCKA, PCKB, PCKC and PCKD clock divisors
   R_SYSTEM->SCKDIVCR = (2 << R_SYSTEM_SCKDIVCR_FCK_Pos) |
      (1 << R_SYSTEM_SCKDIVCR_ICK_Pos) | (1 << R_SYSTEM_SCKDIVCR_BCK_Pos) |
      (1 << R_SYSTEM_SCKDIVCR_PCKA_Pos) | (2 << R_SYSTEM_SCKDIVCR_PCKB_Pos) |
      (2 << R_SYSTEM_SCKDIVCR_PCKC_Pos) | (1 << R_SYSTEM_SCKDIVCR_PCKD_Pos);

   //Set ULCK clock divisor (1/5)
   R_SYSTEM->SCKDIVCR2 = (4 << R_SYSTEM_SCKDIVCR2_UCK_Pos);

   //Switch from MOCO clock to PLL
   R_SYSTEM->SCKSCR = (5 << R_SYSTEM_SCKSCR_CKSEL_Pos);

   //Enable write protection
   R_SYSTEM->PRCR = 0xA500;
}


/**
 * @brief Update the variable SystemCoreClock
 **/

void SystemCoreClockUpdate(void)
{
}
