/*********************************************************************************************************************
 * Copyright (c) 2011-2017, Infineon Technologies AG
 * All rights reserved.                        
 *                                             
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the 
 * following conditions are met:   
 *                                                                              
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following 
 * disclaimer.                        
 * 
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials provided with the distribution.                       
 * 
 * Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote 
 * products derived from this software without specific prior written permission.                                           
 *                                                                              
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE  
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR  
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                  
 *                                                                              
 * To improve the quality of the software, users are encouraged to share modifications, enhancements or bug fixes with 
 * Infineon Technologies AG dave@infineon.com).                                                          
 *********************************************************************************************************************/


/****************************************************************************************************//**
 * @file     XMC4400.h
 *
 * @brief    CMSIS Cortex-M4 Peripheral Access Layer Header File for
 *           XMC4400 from Infineon.
 *
 * @version  V1.6.1 (Reference Manual v1.6)
 * @date     19. June 2017
 *
 * @note     Generated with SVDConv V2.87l 
 *           from CMSIS SVD File 'XMC4400_Processed_SVD.xml' Version 1.6.0 (Reference Manual v1.6),
 *           added support for ARM Compiler 6 (armclang) 
 *******************************************************************************************************/



/** @addtogroup Infineon
  * @{
  */

/** @addtogroup XMC4400
  * @{
  */

#ifndef XMC4400_H
#define XMC4400_H

#ifdef __cplusplus
extern "C" {
#endif


/* -------------------------  Interrupt Number Definition  ------------------------ */

typedef enum {
/* -------------------  Cortex-M4 Processor Exceptions Numbers  ------------------- */
  Reset_IRQn                    = -15,              /*!<   1  Reset Vector, invoked on Power up and warm reset                 */
  NonMaskableInt_IRQn           = -14,              /*!<   2  Non maskable Interrupt, cannot be stopped or preempted           */
  HardFault_IRQn                = -13,              /*!<   3  Hard Fault, all classes of Fault                                 */
  MemoryManagement_IRQn         = -12,              /*!<   4  Memory Management, MPU mismatch, including Access Violation
                                                         and No Match                                                          */
  BusFault_IRQn                 = -11,              /*!<   5  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                         related Fault                                                         */
  UsageFault_IRQn               = -10,              /*!<   6  Usage Fault, i.e. Undef Instruction, Illegal State Transition    */
  SVCall_IRQn                   =  -5,              /*!<  11  System Service Call via SVC instruction                          */
  DebugMonitor_IRQn             =  -4,              /*!<  12  Debug Monitor                                                    */
  PendSV_IRQn                   =  -2,              /*!<  14  Pendable request for system service                              */
  SysTick_IRQn                  =  -1,              /*!<  15  System Tick Timer                                                */
/* ---------------------  XMC4400 Specific Interrupt Numbers  --------------------- */
  SCU_0_IRQn                    =   0,              /*!<   0  System Control                                                   */
  ERU0_0_IRQn                   =   1,              /*!<   1  External Request Unit 0                                          */
  ERU0_1_IRQn                   =   2,              /*!<   2  External Request Unit 0                                          */
  ERU0_2_IRQn                   =   3,              /*!<   3  External Request Unit 0                                          */
  ERU0_3_IRQn                   =   4,              /*!<   4  External Request Unit 0                                          */
  ERU1_0_IRQn                   =   5,              /*!<   5  External Request Unit 1                                          */
  ERU1_1_IRQn                   =   6,              /*!<   6  External Request Unit 1                                          */
  ERU1_2_IRQn                   =   7,              /*!<   7  External Request Unit 1                                          */
  ERU1_3_IRQn                   =   8,              /*!<   8  External Request Unit 1                                          */
  PMU0_0_IRQn                   =  12,              /*!<  12  Program Management Unit                                          */
  VADC0_C0_0_IRQn               =  14,              /*!<  14  Analog to Digital Converter Common Block 0                       */
  VADC0_C0_1_IRQn               =  15,              /*!<  15  Analog to Digital Converter Common Block 0                       */
  VADC0_C0_2_IRQn               =  16,              /*!<  16  Analog to Digital Converter Common Block 0                       */
  VADC0_C0_3_IRQn               =  17,              /*!<  17  Analog to Digital Converter Common Block 0                       */
  VADC0_G0_0_IRQn               =  18,              /*!<  18  Analog to Digital Converter Group 0                              */
  VADC0_G0_1_IRQn               =  19,              /*!<  19  Analog to Digital Converter Group 0                              */
  VADC0_G0_2_IRQn               =  20,              /*!<  20  Analog to Digital Converter Group 0                              */
  VADC0_G0_3_IRQn               =  21,              /*!<  21  Analog to Digital Converter Group 0                              */
  VADC0_G1_0_IRQn               =  22,              /*!<  22  Analog to Digital Converter Group 1                              */
  VADC0_G1_1_IRQn               =  23,              /*!<  23  Analog to Digital Converter Group 1                              */
  VADC0_G1_2_IRQn               =  24,              /*!<  24  Analog to Digital Converter Group 1                              */
  VADC0_G1_3_IRQn               =  25,              /*!<  25  Analog to Digital Converter Group 1                              */
  VADC0_G2_0_IRQn               =  26,              /*!<  26  Analog to Digital Converter Group 2                              */
  VADC0_G2_1_IRQn               =  27,              /*!<  27  Analog to Digital Converter Group 2                              */
  VADC0_G2_2_IRQn               =  28,              /*!<  28  Analog to Digital Converter Group 2                              */
  VADC0_G2_3_IRQn               =  29,              /*!<  29  Analog to Digital Converter Group 2                              */
  VADC0_G3_0_IRQn               =  30,              /*!<  30  Analog to Digital Converter Group 3                              */
  VADC0_G3_1_IRQn               =  31,              /*!<  31  Analog to Digital Converter Group 3                              */
  VADC0_G3_2_IRQn               =  32,              /*!<  32  Analog to Digital Converter Group 3                              */
  VADC0_G3_3_IRQn               =  33,              /*!<  33  Analog to Digital Converter Group 3                              */
  DSD0_M_0_IRQn                 =  34,              /*!<  34  Delta Sigma Demodulator Main                                     */
  DSD0_M_1_IRQn                 =  35,              /*!<  35  Delta Sigma Demodulator Main                                     */
  DSD0_M_2_IRQn                 =  36,              /*!<  36  Delta Sigma Demodulator Main                                     */
  DSD0_M_3_IRQn                 =  37,              /*!<  37  Delta Sigma Demodulator Main                                     */
  DSD0_A_4_IRQn                 =  38,              /*!<  38  Delta Sigma Demodulator Auxiliary                                */
  DSD0_A_5_IRQn                 =  39,              /*!<  39  Delta Sigma Demodulator Auxiliary                                */
  DSD0_A_6_IRQn                 =  40,              /*!<  40  Delta Sigma Demodulator Auxiliary                                */
  DSD0_A_7_IRQn                 =  41,              /*!<  41  Delta Sigma Demodulator Auxiliary                                */
  DAC0_0_IRQn                   =  42,              /*!<  42  Digital to Analog Converter                                      */
  DAC0_1_IRQn                   =  43,              /*!<  43  Digital to Analog Converter                                      */
  CCU40_0_IRQn                  =  44,              /*!<  44  Capture Compare Unit 4 (Module 0)                                */
  CCU40_1_IRQn                  =  45,              /*!<  45  Capture Compare Unit 4 (Module 0)                                */
  CCU40_2_IRQn                  =  46,              /*!<  46  Capture Compare Unit 4 (Module 0)                                */
  CCU40_3_IRQn                  =  47,              /*!<  47  Capture Compare Unit 4 (Module 0)                                */
  CCU41_0_IRQn                  =  48,              /*!<  48  Capture Compare Unit 4 (Module 1)                                */
  CCU41_1_IRQn                  =  49,              /*!<  49  Capture Compare Unit 4 (Module 1)                                */
  CCU41_2_IRQn                  =  50,              /*!<  50  Capture Compare Unit 4 (Module 1)                                */
  CCU41_3_IRQn                  =  51,              /*!<  51  Capture Compare Unit 4 (Module 1)                                */
  CCU42_0_IRQn                  =  52,              /*!<  52  Capture Compare Unit 4 (Module 2)                                */
  CCU42_1_IRQn                  =  53,              /*!<  53  Capture Compare Unit 4 (Module 2)                                */
  CCU42_2_IRQn                  =  54,              /*!<  54  Capture Compare Unit 4 (Module 2)                                */
  CCU42_3_IRQn                  =  55,              /*!<  55  Capture Compare Unit 4 (Module 2)                                */
  CCU43_0_IRQn                  =  56,              /*!<  56  Capture Compare Unit 4 (Module 3)                                */
  CCU43_1_IRQn                  =  57,              /*!<  57  Capture Compare Unit 4 (Module 3)                                */
  CCU43_2_IRQn                  =  58,              /*!<  58  Capture Compare Unit 4 (Module 3)                                */
  CCU43_3_IRQn                  =  59,              /*!<  59  Capture Compare Unit 4 (Module 3)                                */
  CCU80_0_IRQn                  =  60,              /*!<  60  Capture Compare Unit 8 (Module 0)                                */
  CCU80_1_IRQn                  =  61,              /*!<  61  Capture Compare Unit 8 (Module 0)                                */
  CCU80_2_IRQn                  =  62,              /*!<  62  Capture Compare Unit 8 (Module 0)                                */
  CCU80_3_IRQn                  =  63,              /*!<  63  Capture Compare Unit 8 (Module 0)                                */
  CCU81_0_IRQn                  =  64,              /*!<  64  Capture Compare Unit 8 (Module 1)                                */
  CCU81_1_IRQn                  =  65,              /*!<  65  Capture Compare Unit 8 (Module 1)                                */
  CCU81_2_IRQn                  =  66,              /*!<  66  Capture Compare Unit 8 (Module 1)                                */
  CCU81_3_IRQn                  =  67,              /*!<  67  Capture Compare Unit 8 (Module 1)                                */
  POSIF0_0_IRQn                 =  68,              /*!<  68  Position Interface (Module 0)                                    */
  POSIF0_1_IRQn                 =  69,              /*!<  69  Position Interface (Module 0)                                    */
  POSIF1_0_IRQn                 =  70,              /*!<  70  Position Interface (Module 1)                                    */
  POSIF1_1_IRQn                 =  71,              /*!<  71  Position Interface (Module 1)                                    */
  HRPWM_0_IRQn                  =  72,              /*!<  72  High Resolution Pulse Width Modulation (Module 0)                */
  HRPWM_1_IRQn                  =  73,              /*!<  73  High Resolution Pulse Width Modulation (Module 0)                */
  HRPWM_2_IRQn                  =  74,              /*!<  74  High Resolution Pulse Width Modulation (Module 0)                */
  HRPWM_3_IRQn                  =  75,              /*!<  75  High Resolution Pulse Width Modulation (Module 0)                */
  CAN0_0_IRQn                   =  76,              /*!<  76  MultiCAN                                                         */
  CAN0_1_IRQn                   =  77,              /*!<  77  MultiCAN                                                         */
  CAN0_2_IRQn                   =  78,              /*!<  78  MultiCAN                                                         */
  CAN0_3_IRQn                   =  79,              /*!<  79  MultiCAN                                                         */
  CAN0_4_IRQn                   =  80,              /*!<  80  MultiCAN                                                         */
  CAN0_5_IRQn                   =  81,              /*!<  81  MultiCAN                                                         */
  CAN0_6_IRQn                   =  82,              /*!<  82  MultiCAN                                                         */
  CAN0_7_IRQn                   =  83,              /*!<  83  MultiCAN                                                         */
  USIC0_0_IRQn                  =  84,              /*!<  84  Universal Serial Interface Channel (Module 0)                    */
  USIC0_1_IRQn                  =  85,              /*!<  85  Universal Serial Interface Channel (Module 0)                    */
  USIC0_2_IRQn                  =  86,              /*!<  86  Universal Serial Interface Channel (Module 0)                    */
  USIC0_3_IRQn                  =  87,              /*!<  87  Universal Serial Interface Channel (Module 0)                    */
  USIC0_4_IRQn                  =  88,              /*!<  88  Universal Serial Interface Channel (Module 0)                    */
  USIC0_5_IRQn                  =  89,              /*!<  89  Universal Serial Interface Channel (Module 0)                    */
  USIC1_0_IRQn                  =  90,              /*!<  90  Universal Serial Interface Channel (Module 1)                    */
  USIC1_1_IRQn                  =  91,              /*!<  91  Universal Serial Interface Channel (Module 1)                    */
  USIC1_2_IRQn                  =  92,              /*!<  92  Universal Serial Interface Channel (Module 1)                    */
  USIC1_3_IRQn                  =  93,              /*!<  93  Universal Serial Interface Channel (Module 1)                    */
  USIC1_4_IRQn                  =  94,              /*!<  94  Universal Serial Interface Channel (Module 1)                    */
  USIC1_5_IRQn                  =  95,              /*!<  95  Universal Serial Interface Channel (Module 1)                    */
  LEDTS0_0_IRQn                 = 102,              /*!< 102  LED and Touch Sense Control Unit (Module 0)                      */
  FCE0_0_IRQn                   = 104,              /*!< 104  Flexible CRC Engine                                              */
  GPDMA0_0_IRQn                 = 105,              /*!< 105  General Purpose DMA Unit 0                                       */
  USB0_0_IRQn                   = 107,              /*!< 107  Universal Serial Bus (Module 0)                                  */
  ETH0_0_IRQn                   = 108               /*!< 108  Ethernet (Module 0)                                              */
} IRQn_Type;


/** @addtogroup Configuration_of_CMSIS
  * @{
  */


/* ================================================================================ */
/* ================      Processor and Core Peripheral Section     ================ */
/* ================================================================================ */

/* ----------------Configuration of the Cortex-M4 Processor and Core Peripherals---------------- */
#define __CM4_REV                 0x0200            /*!< Cortex-M4 Core Revision                                               */
#define __MPU_PRESENT                  1            /*!< MPU present or not                                                    */
#define __NVIC_PRIO_BITS               6            /*!< Number of Bits used for Priority Levels                               */
#define __Vendor_SysTickConfig         0            /*!< Set to 1 if different SysTick Config is used                          */
#define __FPU_PRESENT                  1            /*!< FPU present or not                                                    */
/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm4.h"                               /*!< Cortex-M4 processor and core peripherals                              */
#include "system_XMC4400.h"                         /*!< XMC4400 System                                                        */


/* ================================================================================ */
/* ================       Device Specific Peripheral Section       ================ */
/* ================================================================================ */
/* Macro to modify desired bitfields of a register */
#define WR_REG(reg, mask, pos, val) reg = (((uint32_t)val << pos) & \
		                                         ((uint32_t)mask)) | \
                                          (reg & ((uint32_t)~((uint32_t)mask)))

/* Macro to modify desired bitfields of a register */
#define WR_REG_SIZE(reg, mask, pos, val, size) {  \
uint##size##_t VAL1 = (uint##size##_t)((uint##size##_t)val << pos); \
uint##size##_t VAL2 = (uint##size##_t) (VAL1 & (uint##size##_t)mask); \
uint##size##_t VAL3 = (uint##size##_t)~((uint##size##_t)mask); \
uint##size##_t VAL4 = (uint##size##_t) ((uint##size##_t)reg & VAL3); \
reg = (uint##size##_t) (VAL2 | VAL4);\
}

/** Macro to read bitfields from a register */
#define RD_REG(reg, mask, pos) (((uint32_t)reg & (uint32_t)mask) >> pos)

/** Macro to read bitfields from a register */
#define RD_REG_SIZE(reg, mask, pos,size) ((uint##size##_t)(((uint32_t)reg & \
                                                      (uint32_t)mask) >> pos) )

/** Macro to set a bit in register */
#define SET_BIT(reg, pos)     (reg |= ((uint32_t)1<<pos))

/** Macro to clear a bit in register */
#define CLR_BIT(reg, pos)     (reg = reg & (uint32_t)(~((uint32_t)1<<pos)) )
/*
* ==========================================================================
* ---------- Interrupt Handler Definition ----------------------------------
* ==========================================================================
*/
#define IRQ_Hdlr_0   SCU_0_IRQHandler
#define IRQ_Hdlr_1   ERU0_0_IRQHandler
#define IRQ_Hdlr_2   ERU0_1_IRQHandler
#define IRQ_Hdlr_3   ERU0_2_IRQHandler
#define IRQ_Hdlr_4   ERU0_3_IRQHandler
#define IRQ_Hdlr_5   ERU1_0_IRQHandler
#define IRQ_Hdlr_6   ERU1_1_IRQHandler
#define IRQ_Hdlr_7   ERU1_2_IRQHandler
#define IRQ_Hdlr_8   ERU1_3_IRQHandler
#define IRQ_Hdlr_12  PMU0_0_IRQHandler
#define IRQ_Hdlr_14  VADC0_C0_0_IRQHandler
#define IRQ_Hdlr_15  VADC0_C0_1_IRQHandler
#define IRQ_Hdlr_16  VADC0_C0_2_IRQHandler
#define IRQ_Hdlr_17  VADC0_C0_3_IRQHandler
#define IRQ_Hdlr_18  VADC0_G0_0_IRQHandler
#define IRQ_Hdlr_19  VADC0_G0_1_IRQHandler
#define IRQ_Hdlr_20  VADC0_G0_2_IRQHandler
#define IRQ_Hdlr_21  VADC0_G0_3_IRQHandler
#define IRQ_Hdlr_22  VADC0_G1_0_IRQHandler
#define IRQ_Hdlr_23  VADC0_G1_1_IRQHandler
#define IRQ_Hdlr_24  VADC0_G1_2_IRQHandler
#define IRQ_Hdlr_25  VADC0_G1_3_IRQHandler
#define IRQ_Hdlr_26  VADC0_G2_0_IRQHandler
#define IRQ_Hdlr_27  VADC0_G2_1_IRQHandler
#define IRQ_Hdlr_28  VADC0_G2_2_IRQHandler
#define IRQ_Hdlr_29  VADC0_G2_3_IRQHandler
#define IRQ_Hdlr_30  VADC0_G3_0_IRQHandler
#define IRQ_Hdlr_31  VADC0_G3_1_IRQHandler
#define IRQ_Hdlr_32  VADC0_G3_2_IRQHandler
#define IRQ_Hdlr_33  VADC0_G3_3_IRQHandler
#define IRQ_Hdlr_34  DSD0_0_IRQHandler
#define IRQ_Hdlr_35  DSD0_1_IRQHandler
#define IRQ_Hdlr_36  DSD0_2_IRQHandler
#define IRQ_Hdlr_37  DSD0_3_IRQHandler
#define IRQ_Hdlr_38  DSD0_4_IRQHandler
#define IRQ_Hdlr_39  DSD0_5_IRQHandler
#define IRQ_Hdlr_40  DSD0_6_IRQHandler
#define IRQ_Hdlr_41  DSD0_7_IRQHandler
#define IRQ_Hdlr_42  DAC0_0_IRQHandler
#define IRQ_Hdlr_43  DAC0_1_IRQHandler
#define IRQ_Hdlr_44  CCU40_0_IRQHandler
#define IRQ_Hdlr_45  CCU40_1_IRQHandler
#define IRQ_Hdlr_46  CCU40_2_IRQHandler
#define IRQ_Hdlr_47  CCU40_3_IRQHandler
#define IRQ_Hdlr_48  CCU41_0_IRQHandler
#define IRQ_Hdlr_49  CCU41_1_IRQHandler
#define IRQ_Hdlr_50  CCU41_2_IRQHandler
#define IRQ_Hdlr_51  CCU41_3_IRQHandler
#define IRQ_Hdlr_52  CCU42_0_IRQHandler
#define IRQ_Hdlr_53  CCU42_1_IRQHandler
#define IRQ_Hdlr_54  CCU42_2_IRQHandler
#define IRQ_Hdlr_55  CCU42_3_IRQHandler
#define IRQ_Hdlr_56  CCU43_0_IRQHandler
#define IRQ_Hdlr_57  CCU43_1_IRQHandler
#define IRQ_Hdlr_58  CCU43_2_IRQHandler
#define IRQ_Hdlr_59  CCU43_3_IRQHandler
#define IRQ_Hdlr_60  CCU80_0_IRQHandler
#define IRQ_Hdlr_61  CCU80_1_IRQHandler
#define IRQ_Hdlr_62  CCU80_2_IRQHandler
#define IRQ_Hdlr_63  CCU80_3_IRQHandler
#define IRQ_Hdlr_64  CCU81_0_IRQHandler
#define IRQ_Hdlr_65  CCU81_1_IRQHandler
#define IRQ_Hdlr_66  CCU81_2_IRQHandler
#define IRQ_Hdlr_67  CCU81_3_IRQHandler
#define IRQ_Hdlr_68  POSIF0_0_IRQHandler
#define IRQ_Hdlr_69  POSIF0_1_IRQHandler
#define IRQ_Hdlr_70  POSIF1_0_IRQHandler
#define IRQ_Hdlr_71  POSIF1_1_IRQHandler
#define IRQ_Hdlr_72  HRPWM_0_IRQHandler
#define IRQ_Hdlr_73  HRPWM_1_IRQHandler
#define IRQ_Hdlr_74  HRPWM_2_IRQHandler
#define IRQ_Hdlr_75  HRPWM_3_IRQHandler
#define IRQ_Hdlr_76  CAN0_0_IRQHandler
#define IRQ_Hdlr_77  CAN0_1_IRQHandler
#define IRQ_Hdlr_78  CAN0_2_IRQHandler
#define IRQ_Hdlr_79  CAN0_3_IRQHandler
#define IRQ_Hdlr_80  CAN0_4_IRQHandler
#define IRQ_Hdlr_81  CAN0_5_IRQHandler
#define IRQ_Hdlr_82  CAN0_6_IRQHandler
#define IRQ_Hdlr_83  CAN0_7_IRQHandler
#define IRQ_Hdlr_84  USIC0_0_IRQHandler
#define IRQ_Hdlr_85  USIC0_1_IRQHandler
#define IRQ_Hdlr_86  USIC0_2_IRQHandler
#define IRQ_Hdlr_87  USIC0_3_IRQHandler
#define IRQ_Hdlr_88  USIC0_4_IRQHandler
#define IRQ_Hdlr_89  USIC0_5_IRQHandler
#define IRQ_Hdlr_90  USIC1_0_IRQHandler
#define IRQ_Hdlr_91  USIC1_1_IRQHandler
#define IRQ_Hdlr_92  USIC1_2_IRQHandler
#define IRQ_Hdlr_93  USIC1_3_IRQHandler
#define IRQ_Hdlr_94  USIC1_4_IRQHandler
#define IRQ_Hdlr_95  USIC1_5_IRQHandler
#define IRQ_Hdlr_102 LEDTS0_0_IRQHandler
#define IRQ_Hdlr_104 FCE0_0_IRQHandler
#define IRQ_Hdlr_105 GPDMA0_0_IRQHandler
#define IRQ_Hdlr_107 USB0_0_IRQHandler
#define IRQ_Hdlr_108 ETH0_0_IRQHandler

/*
* ==========================================================================
* ---------- Interrupt Handler retrieval macro -----------------------------
* ==========================================================================
*/
#define GET_IRQ_HANDLER(N) IRQ_Hdlr_##N

/** @addtogroup Device_Peripheral_Registers
  * @{
  */


/* -------------------  Start of section using anonymous unions  ------------------ */
#if defined(__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
#elif defined(__ICCARM__)
  #pragma language=extended
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__TMS470__)
/* anonymous unions are enabled by default */
#elif defined(__TASKING__)
  #pragma warning 586
#else
  #warning Not supported compiler type
#endif



/* ================================================================================ */
/* ================                       PPB                      ================ */
/* ================================================================================ */


/**
  * @brief Cortex-M4 Private Peripheral Block (PPB)
  */

typedef struct {                                    /*!< (@ 0xE000E000) PPB Structure                                          */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  ACTLR;                             /*!< (@ 0xE000E008) Auxiliary Control Register                             */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  SYST_CSR;                          /*!< (@ 0xE000E010) SysTick Control and Status Register                    */
  __IO uint32_t  SYST_RVR;                          /*!< (@ 0xE000E014) SysTick Reload Value Register                          */
  __IO uint32_t  SYST_CVR;                          /*!< (@ 0xE000E018) SysTick Current Value Register                         */
  __IO uint32_t  SYST_CALIB;                        /*!< (@ 0xE000E01C) SysTick Calibration Value Register r                   */
  __I  uint32_t  RESERVED2[56];
  __IO uint32_t  NVIC_ISER0;                        /*!< (@ 0xE000E100) Interrupt Set-enable Register 0                        */
  __IO uint32_t  NVIC_ISER1;                        /*!< (@ 0xE000E104) Interrupt Set-enable Register 1                        */
  __IO uint32_t  NVIC_ISER2;                        /*!< (@ 0xE000E108) Interrupt Set-enable Register 2                        */
  __IO uint32_t  NVIC_ISER3;                        /*!< (@ 0xE000E10C) Interrupt Set-enable Register 3                        */
  __I  uint32_t  RESERVED3[28];
  __IO uint32_t  NVIC_ICER0;                        /*!< (@ 0xE000E180) Interrupt Clear-enable Register 0                      */
  __IO uint32_t  NVIC_ICER1;                        /*!< (@ 0xE000E184) Interrupt Clear-enable Register 1                      */
  __IO uint32_t  NVIC_ICER2;                        /*!< (@ 0xE000E188) Interrupt Clear-enable Register 2                      */
  __IO uint32_t  NVIC_ICER3;                        /*!< (@ 0xE000E18C) Interrupt Clear-enable Register 3                      */
  __I  uint32_t  RESERVED4[28];
  __IO uint32_t  NVIC_ISPR0;                        /*!< (@ 0xE000E200) Interrupt Set-pending Register 0                       */
  __IO uint32_t  NVIC_ISPR1;                        /*!< (@ 0xE000E204) Interrupt Set-pending Register 1                       */
  __IO uint32_t  NVIC_ISPR2;                        /*!< (@ 0xE000E208) Interrupt Set-pending Register 2                       */
  __IO uint32_t  NVIC_ISPR3;                        /*!< (@ 0xE000E20C) Interrupt Set-pending Register 3                       */
  __I  uint32_t  RESERVED5[28];
  __IO uint32_t  NVIC_ICPR0;                        /*!< (@ 0xE000E280) Interrupt Clear-pending Register 0                     */
  __IO uint32_t  NVIC_ICPR1;                        /*!< (@ 0xE000E284) Interrupt Clear-pending Register 1                     */
  __IO uint32_t  NVIC_ICPR2;                        /*!< (@ 0xE000E288) Interrupt Clear-pending Register 2                     */
  __IO uint32_t  NVIC_ICPR3;                        /*!< (@ 0xE000E28C) Interrupt Clear-pending Register 3                     */
  __I  uint32_t  RESERVED6[28];
  __IO uint32_t  NVIC_IABR0;                        /*!< (@ 0xE000E300) Interrupt Active Bit Register 0                        */
  __IO uint32_t  NVIC_IABR1;                        /*!< (@ 0xE000E304) Interrupt Active Bit Register 1                        */
  __IO uint32_t  NVIC_IABR2;                        /*!< (@ 0xE000E308) Interrupt Active Bit Register 2                        */
  __IO uint32_t  NVIC_IABR3;                        /*!< (@ 0xE000E30C) Interrupt Active Bit Register 3                        */
  __I  uint32_t  RESERVED7[60];
  __IO uint32_t  NVIC_IPR0;                         /*!< (@ 0xE000E400) Interrupt Priority Register 0                          */
  __IO uint32_t  NVIC_IPR1;                         /*!< (@ 0xE000E404) Interrupt Priority Register 1                          */
  __IO uint32_t  NVIC_IPR2;                         /*!< (@ 0xE000E408) Interrupt Priority Register 2                          */
  __IO uint32_t  NVIC_IPR3;                         /*!< (@ 0xE000E40C) Interrupt Priority Register 3                          */
  __IO uint32_t  NVIC_IPR4;                         /*!< (@ 0xE000E410) Interrupt Priority Register 4                          */
  __IO uint32_t  NVIC_IPR5;                         /*!< (@ 0xE000E414) Interrupt Priority Register 5                          */
  __IO uint32_t  NVIC_IPR6;                         /*!< (@ 0xE000E418) Interrupt Priority Register 6                          */
  __IO uint32_t  NVIC_IPR7;                         /*!< (@ 0xE000E41C) Interrupt Priority Register 7                          */
  __IO uint32_t  NVIC_IPR8;                         /*!< (@ 0xE000E420) Interrupt Priority Register 8                          */
  __IO uint32_t  NVIC_IPR9;                         /*!< (@ 0xE000E424) Interrupt Priority Register 9                          */
  __IO uint32_t  NVIC_IPR10;                        /*!< (@ 0xE000E428) Interrupt Priority Register 10                         */
  __IO uint32_t  NVIC_IPR11;                        /*!< (@ 0xE000E42C) Interrupt Priority Register 11                         */
  __IO uint32_t  NVIC_IPR12;                        /*!< (@ 0xE000E430) Interrupt Priority Register 12                         */
  __IO uint32_t  NVIC_IPR13;                        /*!< (@ 0xE000E434) Interrupt Priority Register 13                         */
  __IO uint32_t  NVIC_IPR14;                        /*!< (@ 0xE000E438) Interrupt Priority Register 14                         */
  __IO uint32_t  NVIC_IPR15;                        /*!< (@ 0xE000E43C) Interrupt Priority Register 15                         */
  __IO uint32_t  NVIC_IPR16;                        /*!< (@ 0xE000E440) Interrupt Priority Register 16                         */
  __IO uint32_t  NVIC_IPR17;                        /*!< (@ 0xE000E444) Interrupt Priority Register 17                         */
  __IO uint32_t  NVIC_IPR18;                        /*!< (@ 0xE000E448) Interrupt Priority Register 18                         */
  __IO uint32_t  NVIC_IPR19;                        /*!< (@ 0xE000E44C) Interrupt Priority Register 19                         */
  __IO uint32_t  NVIC_IPR20;                        /*!< (@ 0xE000E450) Interrupt Priority Register 20                         */
  __IO uint32_t  NVIC_IPR21;                        /*!< (@ 0xE000E454) Interrupt Priority Register 21                         */
  __IO uint32_t  NVIC_IPR22;                        /*!< (@ 0xE000E458) Interrupt Priority Register 22                         */
  __IO uint32_t  NVIC_IPR23;                        /*!< (@ 0xE000E45C) Interrupt Priority Register 23                         */
  __IO uint32_t  NVIC_IPR24;                        /*!< (@ 0xE000E460) Interrupt Priority Register 24                         */
  __IO uint32_t  NVIC_IPR25;                        /*!< (@ 0xE000E464) Interrupt Priority Register 25                         */
  __IO uint32_t  NVIC_IPR26;                        /*!< (@ 0xE000E468) Interrupt Priority Register 26                         */
  __IO uint32_t  NVIC_IPR27;                        /*!< (@ 0xE000E46C) Interrupt Priority Register 27                         */
  __I  uint32_t  RESERVED8[548];
  __I  uint32_t  CPUID;                             /*!< (@ 0xE000ED00) CPUID Base Register                                    */
  __IO uint32_t  ICSR;                              /*!< (@ 0xE000ED04) Interrupt Control and State Register                   */
  __IO uint32_t  VTOR;                              /*!< (@ 0xE000ED08) Vector Table Offset Register                           */
  __IO uint32_t  AIRCR;                             /*!< (@ 0xE000ED0C) Application Interrupt and Reset Control Register       */
  __IO uint32_t  SCR;                               /*!< (@ 0xE000ED10) System Control Register                                */
  __IO uint32_t  CCR;                               /*!< (@ 0xE000ED14) Configuration and Control Register                     */
  __IO uint32_t  SHPR1;                             /*!< (@ 0xE000ED18) System Handler Priority Register 1                     */
  __IO uint32_t  SHPR2;                             /*!< (@ 0xE000ED1C) System Handler Priority Register 2                     */
  __IO uint32_t  SHPR3;                             /*!< (@ 0xE000ED20) System Handler Priority Register 3                     */
  __IO uint32_t  SHCSR;                             /*!< (@ 0xE000ED24) System Handler Control and State Register              */
  __IO uint32_t  CFSR;                              /*!< (@ 0xE000ED28) Configurable Fault Status Register                     */
  __IO uint32_t  HFSR;                              /*!< (@ 0xE000ED2C) HardFault Status Register                              */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  MMFAR;                             /*!< (@ 0xE000ED34) MemManage Fault Address Register                       */
  __IO uint32_t  BFAR;                              /*!< (@ 0xE000ED38) BusFault Address Register                              */
  __IO uint32_t  AFSR;                              /*!< (@ 0xE000ED3C) Auxiliary Fault Status Register                        */
  __I  uint32_t  RESERVED10[18];
  __IO uint32_t  CPACR;                             /*!< (@ 0xE000ED88) Coprocessor Access Control Register                    */
  __I  uint32_t  RESERVED11;
  __I  uint32_t  MPU_TYPE;                          /*!< (@ 0xE000ED90) MPU Type Register                                      */
  __IO uint32_t  MPU_CTRL;                          /*!< (@ 0xE000ED94) MPU Control Register                                   */
  __IO uint32_t  MPU_RNR;                           /*!< (@ 0xE000ED98) MPU Region Number Register                             */
  __IO uint32_t  MPU_RBAR;                          /*!< (@ 0xE000ED9C) MPU Region Base Address Register                       */
  __IO uint32_t  MPU_RASR;                          /*!< (@ 0xE000EDA0) MPU Region Attribute and Size Register                 */
  __IO uint32_t  MPU_RBAR_A1;                       /*!< (@ 0xE000EDA4) MPU Region Base Address Register A1                    */
  __IO uint32_t  MPU_RASR_A1;                       /*!< (@ 0xE000EDA8) MPU Region Attribute and Size Register A1              */
  __IO uint32_t  MPU_RBAR_A2;                       /*!< (@ 0xE000EDAC) MPU Region Base Address Register A2                    */
  __IO uint32_t  MPU_RASR_A2;                       /*!< (@ 0xE000EDB0) MPU Region Attribute and Size Register A2              */
  __IO uint32_t  MPU_RBAR_A3;                       /*!< (@ 0xE000EDB4) MPU Region Base Address Register A3                    */
  __IO uint32_t  MPU_RASR_A3;                       /*!< (@ 0xE000EDB8) MPU Region Attribute and Size Register A3              */
  __I  uint32_t  RESERVED12[81];
  __O  uint32_t  STIR;                              /*!< (@ 0xE000EF00) Software Trigger Interrupt Register                    */
  __I  uint32_t  RESERVED13[12];
  __IO uint32_t  FPCCR;                             /*!< (@ 0xE000EF34) Floating-point Context Control Register                */
  __IO uint32_t  FPCAR;                             /*!< (@ 0xE000EF38) Floating-point Context Address Register                */
  __IO uint32_t  FPDSCR;                            /*!< (@ 0xE000EF3C) Floating-point Default Status Control Register         */
} PPB_Type;


/* ================================================================================ */
/* ================                       DLR                      ================ */
/* ================================================================================ */


/**
  * @brief DMA Line Router (DLR)
  */

typedef struct {                                    /*!< (@ 0x50004900) DLR Structure                                          */
  __I  uint32_t  OVRSTAT;                           /*!< (@ 0x50004900) Overrun Status                                         */
  __O  uint32_t  OVRCLR;                            /*!< (@ 0x50004904) Overrun Clear                                          */
  __IO uint32_t  SRSEL0;                            /*!< (@ 0x50004908) Service Request Selection 0                            */
  __I  uint32_t  RESERVED;
  __IO uint32_t  LNEN;                              /*!< (@ 0x50004910) Line Enable                                            */
} DLR_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                   ERU [ERU0]                   ================ */
/* ================================================================================ */


/**
  * @brief Event Request Unit 0 (ERU)
  */

typedef struct {                                    /*!< (@ 0x50004800) ERU Structure                                          */
  __IO uint32_t  EXISEL;                            /*!< (@ 0x50004800) Event Input Select                                     */
  __I  uint32_t  RESERVED[3];
  __IO uint32_t  EXICON[4];                         /*!< (@ 0x50004810) Event Input Control                                    */
  __IO uint32_t  EXOCON[4];                         /*!< (@ 0x50004820) Event Output Trigger Control                           */
} ERU_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                     GPDMA0                     ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA Unit 0 (GPDMA0)
  */

typedef struct {                                    /*!< (@ 0x500142C0) GPDMA0 Structure                                       */
  __IO uint32_t  RAWTFR;                            /*!< (@ 0x500142C0) Raw IntTfr Status                                      */
  __I  uint32_t  RESERVED;
  __IO uint32_t  RAWBLOCK;                          /*!< (@ 0x500142C8) Raw IntBlock Status                                    */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  RAWSRCTRAN;                        /*!< (@ 0x500142D0) Raw IntSrcTran Status                                  */
  __I  uint32_t  RESERVED2;
  __IO uint32_t  RAWDSTTRAN;                        /*!< (@ 0x500142D8) Raw IntBlock Status                                    */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  RAWERR;                            /*!< (@ 0x500142E0) Raw IntErr Status                                      */
  __I  uint32_t  RESERVED4;
  __I  uint32_t  STATUSTFR;                         /*!< (@ 0x500142E8) IntTfr Status                                          */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  STATUSBLOCK;                       /*!< (@ 0x500142F0) IntBlock Status                                        */
  __I  uint32_t  RESERVED6;
  __I  uint32_t  STATUSSRCTRAN;                     /*!< (@ 0x500142F8) IntSrcTran Status                                      */
  __I  uint32_t  RESERVED7;
  __I  uint32_t  STATUSDSTTRAN;                     /*!< (@ 0x50014300) IntBlock Status                                        */
  __I  uint32_t  RESERVED8;
  __I  uint32_t  STATUSERR;                         /*!< (@ 0x50014308) IntErr Status                                          */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  MASKTFR;                           /*!< (@ 0x50014310) Mask for Raw IntTfr Status                             */
  __I  uint32_t  RESERVED10;
  __IO uint32_t  MASKBLOCK;                         /*!< (@ 0x50014318) Mask for Raw IntBlock Status                           */
  __I  uint32_t  RESERVED11;
  __IO uint32_t  MASKSRCTRAN;                       /*!< (@ 0x50014320) Mask for Raw IntSrcTran Status                         */
  __I  uint32_t  RESERVED12;
  __IO uint32_t  MASKDSTTRAN;                       /*!< (@ 0x50014328) Mask for Raw IntBlock Status                           */
  __I  uint32_t  RESERVED13;
  __IO uint32_t  MASKERR;                           /*!< (@ 0x50014330) Mask for Raw IntErr Status                             */
  __I  uint32_t  RESERVED14;
  __O  uint32_t  CLEARTFR;                          /*!< (@ 0x50014338) IntTfr Status                                          */
  __I  uint32_t  RESERVED15;
  __O  uint32_t  CLEARBLOCK;                        /*!< (@ 0x50014340) IntBlock Status                                        */
  __I  uint32_t  RESERVED16;
  __O  uint32_t  CLEARSRCTRAN;                      /*!< (@ 0x50014348) IntSrcTran Status                                      */
  __I  uint32_t  RESERVED17;
  __O  uint32_t  CLEARDSTTRAN;                      /*!< (@ 0x50014350) IntBlock Status                                        */
  __I  uint32_t  RESERVED18;
  __O  uint32_t  CLEARERR;                          /*!< (@ 0x50014358) IntErr Status                                          */
  __I  uint32_t  RESERVED19;
  __I  uint32_t  STATUSINT;                         /*!< (@ 0x50014360) Combined Interrupt Status Register                     */
  __I  uint32_t  RESERVED20;
  __IO uint32_t  REQSRCREG;                         /*!< (@ 0x50014368) Source Software Transaction Request Register           */
  __I  uint32_t  RESERVED21;
  __IO uint32_t  REQDSTREG;                         /*!< (@ 0x50014370) Destination Software Transaction Request Register      */
  __I  uint32_t  RESERVED22;
  __IO uint32_t  SGLREQSRCREG;                      /*!< (@ 0x50014378) Single Source Transaction Request Register             */
  __I  uint32_t  RESERVED23;
  __IO uint32_t  SGLREQDSTREG;                      /*!< (@ 0x50014380) Single Destination Transaction Request Register        */
  __I  uint32_t  RESERVED24;
  __IO uint32_t  LSTSRCREG;                         /*!< (@ 0x50014388) Last Source Transaction Request Register               */
  __I  uint32_t  RESERVED25;
  __IO uint32_t  LSTDSTREG;                         /*!< (@ 0x50014390) Last Destination Transaction Request Register          */
  __I  uint32_t  RESERVED26;
  __IO uint32_t  DMACFGREG;                         /*!< (@ 0x50014398) GPDMA Configuration Register                           */
  __I  uint32_t  RESERVED27;
  __IO uint32_t  CHENREG;                           /*!< (@ 0x500143A0) GPDMA Channel Enable Register                          */
  __I  uint32_t  RESERVED28;
  __I  uint32_t  ID;                                /*!< (@ 0x500143A8) GPDMA0 ID Register                                     */
  __I  uint32_t  RESERVED29[19];
  __I  uint32_t  TYPE;                              /*!< (@ 0x500143F8) GPDMA Component Type                                   */
  __I  uint32_t  VERSION;                           /*!< (@ 0x500143FC) DMA Component Version                                  */
} GPDMA0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================            GPDMA0_CH0_1 [GPDMA0_CH0]           ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA Unit 0 (GPDMA0_CH0_1)
  */

typedef struct {                                    /*!< (@ 0x50014000) GPDMA0_CH0_1 Structure                                 */
  __IO uint32_t  SAR;                               /*!< (@ 0x50014000) Source Address Register                                */
  __I  uint32_t  RESERVED;
  __IO uint32_t  DAR;                               /*!< (@ 0x50014008) Destination Address Register                           */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  LLP;                               /*!< (@ 0x50014010) Linked List Pointer Register                           */
  __I  uint32_t  RESERVED2;
  __IO uint32_t  CTLL;                              /*!< (@ 0x50014018) Control Register Low                                   */
  __IO uint32_t  CTLH;                              /*!< (@ 0x5001401C) Control Register High                                  */
  __IO uint32_t  SSTAT;                             /*!< (@ 0x50014020) Source Status Register                                 */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  DSTAT;                             /*!< (@ 0x50014028) Destination Status Register                            */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  SSTATAR;                           /*!< (@ 0x50014030) Source Status Address Register                         */
  __I  uint32_t  RESERVED5;
  __IO uint32_t  DSTATAR;                           /*!< (@ 0x50014038) Destination Status Address Register                    */
  __I  uint32_t  RESERVED6;
  __IO uint32_t  CFGL;                              /*!< (@ 0x50014040) Configuration Register Low                             */
  __IO uint32_t  CFGH;                              /*!< (@ 0x50014044) Configuration Register High                            */
  __IO uint32_t  SGR;                               /*!< (@ 0x50014048) Source Gather Register                                 */
  __I  uint32_t  RESERVED7;
  __IO uint32_t  DSR;                               /*!< (@ 0x50014050) Destination Scatter Register                           */
} GPDMA0_CH_TypeDef;


/* ================================================================================ */
/* ================            GPDMA0_CH2_7 [GPDMA0_CH2]           ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA Unit 0 (GPDMA0_CH2_7)
  */

typedef struct {                                    /*!< (@ 0x500140B0) GPDMA0_CH2_7 Structure                                 */
  __IO uint32_t  SAR;                               /*!< (@ 0x500140B0) Source Address Register                                */
  __I  uint32_t  RESERVED;
  __IO uint32_t  DAR;                               /*!< (@ 0x500140B8) Destination Address Register                           */
  __I  uint32_t  RESERVED1[3];
  __IO uint32_t  CTLL;                              /*!< (@ 0x500140C8) Control Register Low                                   */
  __IO uint32_t  CTLH;                              /*!< (@ 0x500140CC) Control Register High                                  */
  __I  uint32_t  RESERVED2[8];
  __IO uint32_t  CFGL;                              /*!< (@ 0x500140F0) Configuration Register Low                             */
  __IO uint32_t  CFGH;                              /*!< (@ 0x500140F4) Configuration Register High                            */
} GPDMA0_CH2_7_Type;


/* ================================================================================ */
/* ================                       FCE                      ================ */
/* ================================================================================ */


/**
  * @brief Flexible CRC Engine (FCE)
  */

typedef struct {                                    /*!< (@ 0x50020000) FCE Structure                                          */
  __IO uint32_t  CLC;                               /*!< (@ 0x50020000) Clock Control Register                                 */
  __I  uint32_t  RESERVED;
  __I  uint32_t  ID;                                /*!< (@ 0x50020008) Module Identification Register                         */
} FCE_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                FCE_KE [FCE_KE0]                ================ */
/* ================================================================================ */


/**
  * @brief Flexible CRC Engine (FCE_KE)
  */

typedef struct {                                    /*!< (@ 0x50020020) FCE_KE Structure                                       */
  __IO uint32_t  IR;                                /*!< (@ 0x50020020) Input Register                                         */
  __I  uint32_t  RES;                               /*!< (@ 0x50020024) CRC Result Register                                    */
  __IO uint32_t  CFG;                               /*!< (@ 0x50020028) CRC Configuration Register                             */
  __IO uint32_t  STS;                               /*!< (@ 0x5002002C) CRC Status Register                                    */
  __IO uint32_t  LENGTH;                            /*!< (@ 0x50020030) CRC Length Register                                    */
  __IO uint32_t  CHECK;                             /*!< (@ 0x50020034) CRC Check Register                                     */
  __IO uint32_t  CRC;                               /*!< (@ 0x50020038) CRC Register                                           */
  __IO uint32_t  CTR;                               /*!< (@ 0x5002003C) CRC Test Register                                      */
} FCE_KE_TypeDef;


/* ================================================================================ */
/* ================                   PBA [PBA0]                   ================ */
/* ================================================================================ */


/**
  * @brief Peripheral Bridge AHB 0 (PBA)
  */

typedef struct {                                    /*!< (@ 0x40000000) PBA Structure                                          */
  __IO uint32_t  STS;                               /*!< (@ 0x40000000) Peripheral Bridge Status Register                      */
  __I  uint32_t  WADDR;                             /*!< (@ 0x40000004) PBA Write Error Address Register                       */
} PBA_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                 FLASH [FLASH0]                 ================ */
/* ================================================================================ */


/**
  * @brief Flash Memory Controller (FLASH)
  */

typedef struct {                                    /*!< (@ 0x58001000) FLASH Structure                                        */
  __I  uint32_t  RESERVED[1026];
  __I  uint32_t  ID;                                /*!< (@ 0x58002008) Flash Module Identification Register                   */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  FSR;                               /*!< (@ 0x58002010) Flash Status Register                                  */
  __IO uint32_t  FCON;                              /*!< (@ 0x58002014) Flash Configuration Register                           */
  __IO uint32_t  MARP;                              /*!< (@ 0x58002018) Margin Control Register PFLASH                         */
  __I  uint32_t  RESERVED2;
  __I  uint32_t  PROCON0;                           /*!< (@ 0x58002020) Flash Protection Configuration Register User
                                                         0                                                                     */
  __I  uint32_t  PROCON1;                           /*!< (@ 0x58002024) Flash Protection Configuration Register User
                                                         1                                                                     */
  __I  uint32_t  PROCON2;                           /*!< (@ 0x58002028) Flash Protection Configuration Register User
                                                         2                                                                     */
} FLASH0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                      PREF                      ================ */
/* ================================================================================ */


/**
  * @brief Prefetch Unit (PREF)
  */

typedef struct {                                    /*!< (@ 0x58004000) PREF Structure                                         */
  __IO uint32_t  PCON;                              /*!< (@ 0x58004000) Prefetch Configuration Register                        */
} PREF_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                   PMU [PMU0]                   ================ */
/* ================================================================================ */


/**
  * @brief Program Management Unit (PMU)
  */

typedef struct {                                    /*!< (@ 0x58000508) PMU Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x58000508) PMU0 Identification Register                           */
} PMU0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                       WDT                      ================ */
/* ================================================================================ */


/**
  * @brief Watch Dog Timer (WDT)
  */

typedef struct {                                    /*!< (@ 0x50008000) WDT Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x50008000) WDT ID Register                                        */
  __IO uint32_t  CTR;                               /*!< (@ 0x50008004) WDT Control Register                                   */
  __O  uint32_t  SRV;                               /*!< (@ 0x50008008) WDT Service Register                                   */
  __I  uint32_t  TIM;                               /*!< (@ 0x5000800C) WDT Timer Register                                     */
  __IO uint32_t  WLB;                               /*!< (@ 0x50008010) WDT Window Lower Bound Register                        */
  __IO uint32_t  WUB;                               /*!< (@ 0x50008014) WDT Window Upper Bound Register                        */
  __I  uint32_t  WDTSTS;                            /*!< (@ 0x50008018) WDT Status Register                                    */
  __O  uint32_t  WDTCLR;                            /*!< (@ 0x5000801C) WDT Clear Register                                     */
} WDT_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                       RTC                      ================ */
/* ================================================================================ */


/**
  * @brief Real Time Clock (RTC)
  */

typedef struct {                                    /*!< (@ 0x50004A00) RTC Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x50004A00) RTC ID Register                                        */
  __IO uint32_t  CTR;                               /*!< (@ 0x50004A04) RTC Control Register                                   */
  __I  uint32_t  RAWSTAT;                           /*!< (@ 0x50004A08) RTC Raw Service Request Register                       */
  __I  uint32_t  STSSR;                             /*!< (@ 0x50004A0C) RTC Service Request Status Register                    */
  __IO uint32_t  MSKSR;                             /*!< (@ 0x50004A10) RTC Service Request Mask Register                      */
  __O  uint32_t  CLRSR;                             /*!< (@ 0x50004A14) RTC Clear Service Request Register                     */
  __IO uint32_t  ATIM0;                             /*!< (@ 0x50004A18) RTC Alarm Time Register 0                              */
  __IO uint32_t  ATIM1;                             /*!< (@ 0x50004A1C) RTC Alarm Time Register 1                              */
  __IO uint32_t  TIM0;                              /*!< (@ 0x50004A20) RTC Time Register 0                                    */
  __IO uint32_t  TIM1;                              /*!< (@ 0x50004A24) RTC Time Register 1                                    */
} RTC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                     SCU_CLK                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_CLK)
  */

typedef struct {                                    /*!< (@ 0x50004600) SCU_CLK Structure                                      */
  __I  uint32_t  CLKSTAT;                           /*!< (@ 0x50004600) Clock Status Register                                  */
  __O  uint32_t  CLKSET;                            /*!< (@ 0x50004604) CLK Set Register                                       */
  __O  uint32_t  CLKCLR;                            /*!< (@ 0x50004608) CLK Clear Register                                     */
  __IO uint32_t  SYSCLKCR;                          /*!< (@ 0x5000460C) System Clock Control Register                          */
  __IO uint32_t  CPUCLKCR;                          /*!< (@ 0x50004610) CPU Clock Control Register                             */
  __IO uint32_t  PBCLKCR;                           /*!< (@ 0x50004614) Peripheral Bus Clock Control Register                  */
  __IO uint32_t  USBCLKCR;                          /*!< (@ 0x50004618) USB Clock Control Register                             */
  __I  uint32_t  RESERVED;
  __IO uint32_t  CCUCLKCR;                          /*!< (@ 0x50004620) CCU Clock Control Register                             */
  __IO uint32_t  WDTCLKCR;                          /*!< (@ 0x50004624) WDT Clock Control Register                             */
  __IO uint32_t  EXTCLKCR;                          /*!< (@ 0x50004628) External Clock Control                                 */
  __IO uint32_t  MLINKCLKCR;                        /*!< (@ 0x5000462C) Multi-Link Clock Control                               */
  __IO uint32_t  SLEEPCR;                           /*!< (@ 0x50004630) Sleep Control Register                                 */
  __IO uint32_t  DSLEEPCR;                          /*!< (@ 0x50004634) Deep Sleep Control Register                            */
  __I  uint32_t  RESERVED1[2];
  __I  uint32_t  CGATSTAT0;                         /*!< (@ 0x50004640) Peripheral 0 Clock Gating Status                       */
  __O  uint32_t  CGATSET0;                          /*!< (@ 0x50004644) Peripheral 0 Clock Gating Set                          */
  __O  uint32_t  CGATCLR0;                          /*!< (@ 0x50004648) Peripheral 0 Clock Gating Clear                        */
  __I  uint32_t  CGATSTAT1;                         /*!< (@ 0x5000464C) Peripheral 1 Clock Gating Status                       */
  __O  uint32_t  CGATSET1;                          /*!< (@ 0x50004650) Peripheral 1 Clock Gating Set                          */
  __O  uint32_t  CGATCLR1;                          /*!< (@ 0x50004654) Peripheral 1 Clock Gating Clear                        */
  __I  uint32_t  CGATSTAT2;                         /*!< (@ 0x50004658) Peripheral 2 Clock Gating Status                       */
  __O  uint32_t  CGATSET2;                          /*!< (@ 0x5000465C) Peripheral 2 Clock Gating Set                          */
  __O  uint32_t  CGATCLR2;                          /*!< (@ 0x50004660) Peripheral 2 Clock Gating Clear                        */
} SCU_CLK_TypeDef;


/* ================================================================================ */
/* ================                     SCU_OSC                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_OSC)
  */

typedef struct {                                    /*!< (@ 0x50004700) SCU_OSC Structure                                      */
  __I  uint32_t  OSCHPSTAT;                         /*!< (@ 0x50004700) OSC_HP Status Register                                 */
  __IO uint32_t  OSCHPCTRL;                         /*!< (@ 0x50004704) OSC_HP Control Register                                */
  __I  uint32_t  RESERVED;
  __IO uint32_t  CLKCALCONST;                       /*!< (@ 0x5000470C) Clock Calibration Constant Register                    */
} SCU_OSC_TypeDef;


/* ================================================================================ */
/* ================                     SCU_PLL                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_PLL)
  */

typedef struct {                                    /*!< (@ 0x50004710) SCU_PLL Structure                                      */
  __I  uint32_t  PLLSTAT;                           /*!< (@ 0x50004710) PLL Status Register                                    */
  __IO uint32_t  PLLCON0;                           /*!< (@ 0x50004714) PLL Configuration 0 Register                           */
  __IO uint32_t  PLLCON1;                           /*!< (@ 0x50004718) PLL Configuration 1 Register                           */
  __IO uint32_t  PLLCON2;                           /*!< (@ 0x5000471C) PLL Configuration 2 Register                           */
  __I  uint32_t  USBPLLSTAT;                        /*!< (@ 0x50004720) USB PLL Status Register                                */
  __IO uint32_t  USBPLLCON;                         /*!< (@ 0x50004724) USB PLL Configuration Register                         */
  __I  uint32_t  RESERVED[4];
  __I  uint32_t  CLKMXSTAT;                         /*!< (@ 0x50004738) Clock Multiplexing Status Register                     */
} SCU_PLL_TypeDef;


/* ================================================================================ */
/* ================                   SCU_GENERAL                  ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_GENERAL)
  */

typedef struct {                                    /*!< (@ 0x50004000) SCU_GENERAL Structure                                  */
  __I  uint32_t  ID;                                /*!< (@ 0x50004000) SCU Module ID Register                                 */
  __I  uint32_t  IDCHIP;                            /*!< (@ 0x50004004) Chip ID Register                                       */
  __I  uint32_t  IDMANUF;                           /*!< (@ 0x50004008) Manufactory ID Register                                */
  __I  uint32_t  RESERVED;
  __IO uint32_t  STCON;                             /*!< (@ 0x50004010) Startup Configuration Register                         */
  __I  uint32_t  RESERVED1[6];
  __IO uint32_t  GPR[2];                            /*!< (@ 0x5000402C) General Purpose Register 0                             */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  CCUCON;                            /*!< (@ 0x5000404C) CCU Control Register                                   */
  __I  uint32_t  RESERVED3[15];
  __IO uint32_t  DTSCON;                            /*!< (@ 0x5000408C) Die Temperature Sensor Control Register                */
  __I  uint32_t  DTSSTAT;                           /*!< (@ 0x50004090) Die Temperature Sensor Status Register                 */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  GORCEN[2];                         /*!< (@ 0x500040A0) Out of Range Comparator Enable Register 0              */
  __IO uint32_t  DTEMPLIM;                          /*!< (@ 0x500040A8) Die Temperature Sensor Limit Register                  */
  __I  uint32_t  DTEMPALARM;                        /*!< (@ 0x500040AC) Die Temperature Sensor Alarm Register                  */
  __I  uint32_t  RESERVED5[5];
  __I  uint32_t  MIRRSTS;                           /*!< (@ 0x500040C4) Mirror Write Status Register                           */
  __IO uint32_t  RMACR;                             /*!< (@ 0x500040C8) Retention Memory Access Control Register               */
  __IO uint32_t  RMDATA;                            /*!< (@ 0x500040CC) Retention Memory Access Data Register                  */
  __I  uint32_t  MIRRALLSTAT;                       /*!< (@ 0x500040D0) Mirror All Status                                      */
  __O  uint32_t  MIRRALLREQ;                        /*!< (@ 0x500040D4) Mirror All Request                                     */
} SCU_GENERAL_TypeDef;


/* ================================================================================ */
/* ================                  SCU_INTERRUPT                 ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_INTERRUPT)
  */

typedef struct {                                    /*!< (@ 0x50004074) SCU_INTERRUPT Structure                                */
  __I  uint32_t  SRSTAT;                            /*!< (@ 0x50004074) SCU Service Request Status                             */
  __I  uint32_t  SRRAW;                             /*!< (@ 0x50004078) SCU Raw Service Request Status                         */
  __IO uint32_t  SRMSK;                             /*!< (@ 0x5000407C) SCU Service Request Mask                               */
  __O  uint32_t  SRCLR;                             /*!< (@ 0x50004080) SCU Service Request Clear                              */
  __O  uint32_t  SRSET;                             /*!< (@ 0x50004084) SCU Service Request Set                                */
  __IO uint32_t  NMIREQEN;                          /*!< (@ 0x50004088) SCU Service Request Mask                               */
} SCU_INTERRUPT_TypeDef;


/* ================================================================================ */
/* ================                   SCU_PARITY                   ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_PARITY)
  */

typedef struct {                                    /*!< (@ 0x5000413C) SCU_PARITY Structure                                   */
  __IO uint32_t  PEEN;                              /*!< (@ 0x5000413C) Parity Error Enable Register                           */
  __IO uint32_t  MCHKCON;                           /*!< (@ 0x50004140) Memory Checking Control Register                       */
  __IO uint32_t  PETE;                              /*!< (@ 0x50004144) Parity Error Trap Enable Register                      */
  __IO uint32_t  PERSTEN;                           /*!< (@ 0x50004148) Parity Error Reset Enable Register                     */
  __I  uint32_t  RESERVED;
  __IO uint32_t  PEFLAG;                            /*!< (@ 0x50004150) Parity Error Flag Register                             */
  __IO uint32_t  PMTPR;                             /*!< (@ 0x50004154) Parity Memory Test Pattern Register                    */
  __IO uint32_t  PMTSR;                             /*!< (@ 0x50004158) Parity Memory Test Select Register                     */
} SCU_PARITY_TypeDef;


/* ================================================================================ */
/* ================                    SCU_TRAP                    ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_TRAP)
  */

typedef struct {                                    /*!< (@ 0x50004160) SCU_TRAP Structure                                     */
  __I  uint32_t  TRAPSTAT;                          /*!< (@ 0x50004160) Trap Status Register                                   */
  __I  uint32_t  TRAPRAW;                           /*!< (@ 0x50004164) Trap Raw Status Register                               */
  __IO uint32_t  TRAPDIS;                           /*!< (@ 0x50004168) Trap Disable Register                                  */
  __O  uint32_t  TRAPCLR;                           /*!< (@ 0x5000416C) Trap Clear Register                                    */
  __O  uint32_t  TRAPSET;                           /*!< (@ 0x50004170) Trap Set Register                                      */
} SCU_TRAP_TypeDef;


/* ================================================================================ */
/* ================                  SCU_HIBERNATE                 ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_HIBERNATE)
  */

typedef struct {                                    /*!< (@ 0x50004300) SCU_HIBERNATE Structure                                */
  __I  uint32_t  HDSTAT;                            /*!< (@ 0x50004300) Hibernate Domain Status Register                       */
  __O  uint32_t  HDCLR;                             /*!< (@ 0x50004304) Hibernate Domain Status Clear Register                 */
  __O  uint32_t  HDSET;                             /*!< (@ 0x50004308) Hibernate Domain Status Set Register                   */
  __IO uint32_t  HDCR;                              /*!< (@ 0x5000430C) Hibernate Domain Control Register                      */
  __I  uint32_t  RESERVED;
  __IO uint32_t  OSCSICTRL;                         /*!< (@ 0x50004314) fOSI Control Register                                  */
  __I  uint32_t  OSCULSTAT;                         /*!< (@ 0x50004318) OSC_ULP Status Register                                */
  __IO uint32_t  OSCULCTRL;                         /*!< (@ 0x5000431C) OSC_ULP Control Register                               */
  __IO uint32_t  LPACCONF;                          /*!< (@ 0x50004320) Analog Wake-up Configuration Register                  */
  __IO uint32_t  LPACTH0;                           /*!< (@ 0x50004324) LPAC Threshold Register 0                              */
  __IO uint32_t  LPACTH1;                           /*!< (@ 0x50004328) LPAC Threshold Register 1                              */
  __I  uint32_t  LPACST;                            /*!< (@ 0x5000432C) Hibernate Analog Control State Register                */
  __O  uint32_t  LPACCLR;                           /*!< (@ 0x50004330) LPAC Control Clear Register                            */
  __O  uint32_t  LPACSET;                           /*!< (@ 0x50004334) LPAC Control Set Register                              */
  __I  uint32_t  HINTST;                            /*!< (@ 0x50004338) Hibernate Internal Control State Register              */
  __O  uint32_t  HINTCLR;                           /*!< (@ 0x5000433C) Hibernate Internal Control Clear Register              */
  __O  uint32_t  HINTSET;                           /*!< (@ 0x50004340) Hibernate Internal Control Set Register                */
} SCU_HIBERNATE_TypeDef;


/* ================================================================================ */
/* ================                    SCU_POWER                   ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_POWER)
  */

typedef struct {                                    /*!< (@ 0x50004200) SCU_POWER Structure                                    */
  __I  uint32_t  PWRSTAT;                           /*!< (@ 0x50004200) PCU Status Register                                    */
  __O  uint32_t  PWRSET;                            /*!< (@ 0x50004204) PCU Set Control Register                               */
  __O  uint32_t  PWRCLR;                            /*!< (@ 0x50004208) PCU Clear Control Register                             */
  __I  uint32_t  RESERVED;
  __I  uint32_t  EVRSTAT;                           /*!< (@ 0x50004210) EVR Status Register                                    */
  __I  uint32_t  EVRVADCSTAT;                       /*!< (@ 0x50004214) EVR VADC Status Register                               */
  __I  uint32_t  RESERVED1[5];
  __IO uint32_t  PWRMON;                            /*!< (@ 0x5000422C) Power Monitor Control                                  */
} SCU_POWER_TypeDef;


/* ================================================================================ */
/* ================                    SCU_RESET                   ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU_RESET)
  */

typedef struct {                                    /*!< (@ 0x50004400) SCU_RESET Structure                                    */
  __I  uint32_t  RSTSTAT;                           /*!< (@ 0x50004400) RCU Reset Status                                       */
  __O  uint32_t  RSTSET;                            /*!< (@ 0x50004404) RCU Reset Set Register                                 */
  __O  uint32_t  RSTCLR;                            /*!< (@ 0x50004408) RCU Reset Clear Register                               */
  __I  uint32_t  PRSTAT0;                           /*!< (@ 0x5000440C) RCU Peripheral 0 Reset Status                          */
  __O  uint32_t  PRSET0;                            /*!< (@ 0x50004410) RCU Peripheral 0 Reset Set                             */
  __O  uint32_t  PRCLR0;                            /*!< (@ 0x50004414) RCU Peripheral 0 Reset Clear                           */
  __I  uint32_t  PRSTAT1;                           /*!< (@ 0x50004418) RCU Peripheral 1 Reset Status                          */
  __O  uint32_t  PRSET1;                            /*!< (@ 0x5000441C) RCU Peripheral 1 Reset Set                             */
  __O  uint32_t  PRCLR1;                            /*!< (@ 0x50004420) RCU Peripheral 1 Reset Clear                           */
  __I  uint32_t  PRSTAT2;                           /*!< (@ 0x50004424) RCU Peripheral 2 Reset Status                          */
  __O  uint32_t  PRSET2;                            /*!< (@ 0x50004428) RCU Peripheral 2 Reset Set                             */
  __O  uint32_t  PRCLR2;                            /*!< (@ 0x5000442C) RCU Peripheral 2 Reset Clear                           */
} SCU_RESET_TypeDef;


/* ================================================================================ */
/* ================                 LEDTS [LEDTS0]                 ================ */
/* ================================================================================ */


/**
  * @brief LED and Touch Sense Unit 0 (LEDTS)
  */

typedef struct {                                    /*!< (@ 0x48010000) LEDTS Structure                                        */
  __I  uint32_t  ID;                                /*!< (@ 0x48010000) Module Identification Register                         */
  __IO uint32_t  GLOBCTL;                           /*!< (@ 0x48010004) Global Control Register                                */
  __IO uint32_t  FNCTL;                             /*!< (@ 0x48010008) Function Control Register                              */
  __O  uint32_t  EVFR;                              /*!< (@ 0x4801000C) Event Flag Register                                    */
  __IO uint32_t  TSVAL;                             /*!< (@ 0x48010010) Touch-sense TS-Counter Value                           */
  __IO uint32_t  LINE0;                             /*!< (@ 0x48010014) Line Pattern Register 0                                */
  __IO uint32_t  LINE1;                             /*!< (@ 0x48010018) Line Pattern Register 1                                */
  __IO uint32_t  LDCMP0;                            /*!< (@ 0x4801001C) LED Compare Register 0                                 */
  __IO uint32_t  LDCMP1;                            /*!< (@ 0x48010020) LED Compare Register 1                                 */
  __IO uint32_t  TSCMP0;                            /*!< (@ 0x48010024) Touch-sense Compare Register 0                         */
  __IO uint32_t  TSCMP1;                            /*!< (@ 0x48010028) Touch-sense Compare Register 1                         */
} LEDTS0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                    ETH0_CON                    ================ */
/* ================================================================================ */


/**
  * @brief Ethernet Control Register (ETH0_CON)
  */

typedef struct {                                    /*!< (@ 0x50004040) ETH0_CON Structure                                     */
  __IO uint32_t  CON;                          /*!< (@ 0x50004040) Ethernet 0 Port Control Register                       */
} ETH0_CON_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                   ETH [ETH0]                   ================ */
/* ================================================================================ */


/**
  * @brief Ethernet Unit 0 (ETH)
  */

typedef struct {                                    /*!< (@ 0x5000C000) ETH Structure                                          */
  __IO uint32_t  MAC_CONFIGURATION;                 /*!< (@ 0x5000C000) MAC Configuration Register                             */
  __IO uint32_t  MAC_FRAME_FILTER;                  /*!< (@ 0x5000C004) MAC Frame Filter                                       */
  __IO uint32_t  HASH_TABLE_HIGH;                   /*!< (@ 0x5000C008) Hash Table High Register                               */
  __IO uint32_t  HASH_TABLE_LOW;                    /*!< (@ 0x5000C00C) Hash Table Low Register                                */
  __IO uint32_t  GMII_ADDRESS;                      /*!< (@ 0x5000C010) MII Address Register                                   */
  __IO uint32_t  GMII_DATA;                         /*!< (@ 0x5000C014) MII Data Register                                      */
  __IO uint32_t  FLOW_CONTROL;                      /*!< (@ 0x5000C018) Flow Control Register                                  */
  __IO uint32_t  VLAN_TAG;                          /*!< (@ 0x5000C01C) VLAN Tag Register                                      */
  __I  uint32_t  VERSION;                           /*!< (@ 0x5000C020) Version Register                                       */
  __I  uint32_t  DEBUG;                             /*!< (@ 0x5000C024) Debug Register                                         */
  __IO uint32_t  REMOTE_WAKE_UP_FRAME_FILTER;       /*!< (@ 0x5000C028) Remote Wake Up Frame Filter Register                   */
  __IO uint32_t  PMT_CONTROL_STATUS;                /*!< (@ 0x5000C02C) PMT Control and Status Register                        */
  __I  uint32_t  RESERVED[2];
  __I  uint32_t  INTERRUPT_STATUS;                  /*!< (@ 0x5000C038) Interrupt Register                                     */
  __IO uint32_t  INTERRUPT_MASK;                    /*!< (@ 0x5000C03C) Interrupt Mask Register                                */
  __IO uint32_t  MAC_ADDRESS0_HIGH;                 /*!< (@ 0x5000C040) MAC Address0 High Register                             */
  __IO uint32_t  MAC_ADDRESS0_LOW;                  /*!< (@ 0x5000C044) MAC Address0 Low Register                              */
  __IO uint32_t  MAC_ADDRESS1_HIGH;                 /*!< (@ 0x5000C048) MAC Address1 High Register                             */
  __IO uint32_t  MAC_ADDRESS1_LOW;                  /*!< (@ 0x5000C04C) MAC Address1 Low Register                              */
  __IO uint32_t  MAC_ADDRESS2_HIGH;                 /*!< (@ 0x5000C050) MAC Address2 High Register                             */
  __IO uint32_t  MAC_ADDRESS2_LOW;                  /*!< (@ 0x5000C054) MAC Address2 Low Register                              */
  __IO uint32_t  MAC_ADDRESS3_HIGH;                 /*!< (@ 0x5000C058) MAC Address3 High Register                             */
  __IO uint32_t  MAC_ADDRESS3_LOW;                  /*!< (@ 0x5000C05C) MAC Address3 Low Register                              */
  __I  uint32_t  RESERVED1[40];
  __IO uint32_t  MMC_CONTROL;                       /*!< (@ 0x5000C100) MMC Control Register                                   */
  __I  uint32_t  MMC_RECEIVE_INTERRUPT;             /*!< (@ 0x5000C104) MMC Receive Interrupt Register                         */
  __I  uint32_t  MMC_TRANSMIT_INTERRUPT;            /*!< (@ 0x5000C108) MMC Transmit Interrupt Register                        */
  __IO uint32_t  MMC_RECEIVE_INTERRUPT_MASK;        /*!< (@ 0x5000C10C) MMC Reveive Interrupt Mask Register                    */
  __IO uint32_t  MMC_TRANSMIT_INTERRUPT_MASK;       /*!< (@ 0x5000C110) MMC Transmit Interrupt Mask Register                   */
  __I  uint32_t  TX_OCTET_COUNT_GOOD_BAD;           /*!< (@ 0x5000C114) Transmit Octet Count for Good and Bad Frames
                                                         Register                                                              */
  __I  uint32_t  TX_FRAME_COUNT_GOOD_BAD;           /*!< (@ 0x5000C118) Transmit Frame Count for Goodand Bad Frames Register   */
  __I  uint32_t  TX_BROADCAST_FRAMES_GOOD;          /*!< (@ 0x5000C11C) Transmit Frame Count for Good Broadcast Frames         */
  __I  uint32_t  TX_MULTICAST_FRAMES_GOOD;          /*!< (@ 0x5000C120) Transmit Frame Count for Good Multicast Frames         */
  __I  uint32_t  TX_64OCTETS_FRAMES_GOOD_BAD;       /*!< (@ 0x5000C124) Transmit Octet Count for Good and Bad 64 Byte
                                                         Frames                                                                */
  __I  uint32_t  TX_65TO127OCTETS_FRAMES_GOOD_BAD;  /*!< (@ 0x5000C128) Transmit Octet Count for Good and Bad 65 to 127
                                                         Bytes Frames                                                          */
  __I  uint32_t  TX_128TO255OCTETS_FRAMES_GOOD_BAD; /*!< (@ 0x5000C12C) Transmit Octet Count for Good and Bad 128 to
                                                         255 Bytes Frames                                                      */
  __I  uint32_t  TX_256TO511OCTETS_FRAMES_GOOD_BAD; /*!< (@ 0x5000C130) Transmit Octet Count for Good and Bad 256 to
                                                         511 Bytes Frames                                                      */
  __I  uint32_t  TX_512TO1023OCTETS_FRAMES_GOOD_BAD;/*!< (@ 0x5000C134) Transmit Octet Count for Good and Bad 512 to
                                                         1023 Bytes Frames                                                     */
  __I  uint32_t  TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD;/*!< (@ 0x5000C138) Transmit Octet Count for Good and Bad 1024 to
                                                         Maxsize Bytes Frames                                                  */
  __I  uint32_t  TX_UNICAST_FRAMES_GOOD_BAD;        /*!< (@ 0x5000C13C) Transmit Frame Count for Good and Bad Unicast
                                                         Frames                                                                */
  __I  uint32_t  TX_MULTICAST_FRAMES_GOOD_BAD;      /*!< (@ 0x5000C140) Transmit Frame Count for Good and Bad Multicast
                                                         Frames                                                                */
  __I  uint32_t  TX_BROADCAST_FRAMES_GOOD_BAD;      /*!< (@ 0x5000C144) Transmit Frame Count for Good and Bad Broadcast
                                                         Frames                                                                */
  __I  uint32_t  TX_UNDERFLOW_ERROR_FRAMES;         /*!< (@ 0x5000C148) Transmit Frame Count for Underflow Error Frames        */
  __I  uint32_t  TX_SINGLE_COLLISION_GOOD_FRAMES;   /*!< (@ 0x5000C14C) Transmit Frame Count for Frames Transmitted after
                                                         Single Collision                                                      */
  __I  uint32_t  TX_MULTIPLE_COLLISION_GOOD_FRAMES; /*!< (@ 0x5000C150) Transmit Frame Count for Frames Transmitted after
                                                         Multiple Collision                                                    */
  __I  uint32_t  TX_DEFERRED_FRAMES;                /*!< (@ 0x5000C154) Tx Deferred Frames Register                            */
  __I  uint32_t  TX_LATE_COLLISION_FRAMES;          /*!< (@ 0x5000C158) Transmit Frame Count for Late Collision Error
                                                         Frames                                                                */
  __I  uint32_t  TX_EXCESSIVE_COLLISION_FRAMES;     /*!< (@ 0x5000C15C) Transmit Frame Count for Excessive Collision
                                                         Error Frames                                                          */
  __I  uint32_t  TX_CARRIER_ERROR_FRAMES;           /*!< (@ 0x5000C160) Transmit Frame Count for Carrier Sense Error
                                                         Frames                                                                */
  __I  uint32_t  TX_OCTET_COUNT_GOOD;               /*!< (@ 0x5000C164) Tx Octet Count Good Register                           */
  __I  uint32_t  TX_FRAME_COUNT_GOOD;               /*!< (@ 0x5000C168) Tx Frame Count Good Register                           */
  __I  uint32_t  TX_EXCESSIVE_DEFERRAL_ERROR;       /*!< (@ 0x5000C16C) Transmit Frame Count for Excessive Deferral Error
                                                         Frames                                                                */
  __I  uint32_t  TX_PAUSE_FRAMES;                   /*!< (@ 0x5000C170) Transmit Frame Count for Good PAUSE Frames             */
  __I  uint32_t  TX_VLAN_FRAMES_GOOD;               /*!< (@ 0x5000C174) Transmit Frame Count for Good VLAN Frames              */
  __I  uint32_t  TX_OSIZE_FRAMES_GOOD;              /*!< (@ 0x5000C178) Transmit Frame Count for Good Oversize Frames          */
  __I  uint32_t  RESERVED2;
  __I  uint32_t  RX_FRAMES_COUNT_GOOD_BAD;          /*!< (@ 0x5000C180) Receive Frame Count for Good and Bad Frames            */
  __I  uint32_t  RX_OCTET_COUNT_GOOD_BAD;           /*!< (@ 0x5000C184) Receive Octet Count for Good and Bad Frames            */
  __I  uint32_t  RX_OCTET_COUNT_GOOD;               /*!< (@ 0x5000C188) Rx Octet Count Good Register                           */
  __I  uint32_t  RX_BROADCAST_FRAMES_GOOD;          /*!< (@ 0x5000C18C) Receive Frame Count for Good Broadcast Frames          */
  __I  uint32_t  RX_MULTICAST_FRAMES_GOOD;          /*!< (@ 0x5000C190) Receive Frame Count for Good Multicast Frames          */
  __I  uint32_t  RX_CRC_ERROR_FRAMES;               /*!< (@ 0x5000C194) Receive Frame Count for CRC Error Frames               */
  __I  uint32_t  RX_ALIGNMENT_ERROR_FRAMES;         /*!< (@ 0x5000C198) Receive Frame Count for Alignment Error Frames         */
  __I  uint32_t  RX_RUNT_ERROR_FRAMES;              /*!< (@ 0x5000C19C) Receive Frame Count for Runt Error Frames              */
  __I  uint32_t  RX_JABBER_ERROR_FRAMES;            /*!< (@ 0x5000C1A0) Receive Frame Count for Jabber Error Frames            */
  __I  uint32_t  RX_UNDERSIZE_FRAMES_GOOD;          /*!< (@ 0x5000C1A4) Receive Frame Count for Undersize Frames               */
  __I  uint32_t  RX_OVERSIZE_FRAMES_GOOD;           /*!< (@ 0x5000C1A8) Rx Oversize Frames Good Register                       */
  __I  uint32_t  RX_64OCTETS_FRAMES_GOOD_BAD;       /*!< (@ 0x5000C1AC) Receive Frame Count for Good and Bad 64 Byte
                                                         Frames                                                                */
  __I  uint32_t  RX_65TO127OCTETS_FRAMES_GOOD_BAD;  /*!< (@ 0x5000C1B0) Receive Frame Count for Good and Bad 65 to 127
                                                         Bytes Frames                                                          */
  __I  uint32_t  RX_128TO255OCTETS_FRAMES_GOOD_BAD; /*!< (@ 0x5000C1B4) Receive Frame Count for Good and Bad 128 to 255
                                                         Bytes Frames                                                          */
  __I  uint32_t  RX_256TO511OCTETS_FRAMES_GOOD_BAD; /*!< (@ 0x5000C1B8) Receive Frame Count for Good and Bad 256 to 511
                                                         Bytes Frames                                                          */
  __I  uint32_t  RX_512TO1023OCTETS_FRAMES_GOOD_BAD;/*!< (@ 0x5000C1BC) Receive Frame Count for Good and Bad 512 to 1,023
                                                         Bytes Frames                                                          */
  __I  uint32_t  RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD;/*!< (@ 0x5000C1C0) Receive Frame Count for Good and Bad 1,024 to
                                                         Maxsize Bytes Frames                                                  */
  __I  uint32_t  RX_UNICAST_FRAMES_GOOD;            /*!< (@ 0x5000C1C4) Receive Frame Count for Good Unicast Frames            */
  __I  uint32_t  RX_LENGTH_ERROR_FRAMES;            /*!< (@ 0x5000C1C8) Receive Frame Count for Length Error Frames            */
  __I  uint32_t  RX_OUT_OF_RANGE_TYPE_FRAMES;       /*!< (@ 0x5000C1CC) Receive Frame Count for Out of Range Frames            */
  __I  uint32_t  RX_PAUSE_FRAMES;                   /*!< (@ 0x5000C1D0) Receive Frame Count for PAUSE Frames                   */
  __I  uint32_t  RX_FIFO_OVERFLOW_FRAMES;           /*!< (@ 0x5000C1D4) Receive Frame Count for FIFO Overflow Frames           */
  __I  uint32_t  RX_VLAN_FRAMES_GOOD_BAD;           /*!< (@ 0x5000C1D8) Receive Frame Count for Good and Bad VLAN Frames       */
  __I  uint32_t  RX_WATCHDOG_ERROR_FRAMES;          /*!< (@ 0x5000C1DC) Receive Frame Count for Watchdog Error Frames          */
  __I  uint32_t  RX_RECEIVE_ERROR_FRAMES;           /*!< (@ 0x5000C1E0) Receive Frame Count for Receive Error Frames           */
  __I  uint32_t  RX_CONTROL_FRAMES_GOOD;            /*!< (@ 0x5000C1E4) Receive Frame Count for Good Control Frames Frames     */
  __I  uint32_t  RESERVED3[6];
  __IO uint32_t  MMC_IPC_RECEIVE_INTERRUPT_MASK;    /*!< (@ 0x5000C200) MMC Receive Checksum Offload Interrupt Mask Register   */
  __I  uint32_t  RESERVED4;
  __I  uint32_t  MMC_IPC_RECEIVE_INTERRUPT;         /*!< (@ 0x5000C208) MMC Receive Checksum Offload Interrupt Register        */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  RXIPV4_GOOD_FRAMES;                /*!< (@ 0x5000C210) RxIPv4 Good Frames Register                            */
  __I  uint32_t  RXIPV4_HEADER_ERROR_FRAMES;        /*!< (@ 0x5000C214) Receive IPV4 Header Error Frame Counter Register       */
  __I  uint32_t  RXIPV4_NO_PAYLOAD_FRAMES;          /*!< (@ 0x5000C218) Receive IPV4 No Payload Frame Counter Register         */
  __I  uint32_t  RXIPV4_FRAGMENTED_FRAMES;          /*!< (@ 0x5000C21C) Receive IPV4 Fragmented Frame Counter Register         */
  __I  uint32_t  RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES;/*!< (@ 0x5000C220) Receive IPV4 UDP Checksum Disabled Frame Counter
                                                         Register                                                              */
  __I  uint32_t  RXIPV6_GOOD_FRAMES;                /*!< (@ 0x5000C224) RxIPv6 Good Frames Register                            */
  __I  uint32_t  RXIPV6_HEADER_ERROR_FRAMES;        /*!< (@ 0x5000C228) Receive IPV6 Header Error Frame Counter Register       */
  __I  uint32_t  RXIPV6_NO_PAYLOAD_FRAMES;          /*!< (@ 0x5000C22C) Receive IPV6 No Payload Frame Counter Register         */
  __I  uint32_t  RXUDP_GOOD_FRAMES;                 /*!< (@ 0x5000C230) RxUDP Good Frames Register                             */
  __I  uint32_t  RXUDP_ERROR_FRAMES;                /*!< (@ 0x5000C234) RxUDP Error Frames Register                            */
  __I  uint32_t  RXTCP_GOOD_FRAMES;                 /*!< (@ 0x5000C238) RxTCP Good Frames Register                             */
  __I  uint32_t  RXTCP_ERROR_FRAMES;                /*!< (@ 0x5000C23C) RxTCP Error Frames Register                            */
  __I  uint32_t  RXICMP_GOOD_FRAMES;                /*!< (@ 0x5000C240) RxICMP Good Frames Register                            */
  __I  uint32_t  RXICMP_ERROR_FRAMES;               /*!< (@ 0x5000C244) RxICMP Error Frames Register                           */
  __I  uint32_t  RESERVED6[2];
  __I  uint32_t  RXIPV4_GOOD_OCTETS;                /*!< (@ 0x5000C250) RxIPv4 Good Octets Register                            */
  __I  uint32_t  RXIPV4_HEADER_ERROR_OCTETS;        /*!< (@ 0x5000C254) Receive IPV4 Header Error Octet Counter Register       */
  __I  uint32_t  RXIPV4_NO_PAYLOAD_OCTETS;          /*!< (@ 0x5000C258) Receive IPV4 No Payload Octet Counter Register         */
  __I  uint32_t  RXIPV4_FRAGMENTED_OCTETS;          /*!< (@ 0x5000C25C) Receive IPV4 Fragmented Octet Counter Register         */
  __I  uint32_t  RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS;/*!< (@ 0x5000C260) Receive IPV4 Fragmented Octet Counter Register         */
  __I  uint32_t  RXIPV6_GOOD_OCTETS;                /*!< (@ 0x5000C264) RxIPv6 Good Octets Register                            */
  __I  uint32_t  RXIPV6_HEADER_ERROR_OCTETS;        /*!< (@ 0x5000C268) Receive IPV6 Header Error Octet Counter Register       */
  __I  uint32_t  RXIPV6_NO_PAYLOAD_OCTETS;          /*!< (@ 0x5000C26C) Receive IPV6 No Payload Octet Counter Register         */
  __I  uint32_t  RXUDP_GOOD_OCTETS;                 /*!< (@ 0x5000C270) Receive UDP Good Octets Register                       */
  __I  uint32_t  RXUDP_ERROR_OCTETS;                /*!< (@ 0x5000C274) Receive UDP Error Octets Register                      */
  __I  uint32_t  RXTCP_GOOD_OCTETS;                 /*!< (@ 0x5000C278) Receive TCP Good Octets Register                       */
  __I  uint32_t  RXTCP_ERROR_OCTETS;                /*!< (@ 0x5000C27C) Receive TCP Error Octets Register                      */
  __I  uint32_t  RXICMP_GOOD_OCTETS;                /*!< (@ 0x5000C280) Receive ICMP Good Octets Register                      */
  __I  uint32_t  RXICMP_ERROR_OCTETS;               /*!< (@ 0x5000C284) Receive ICMP Error Octets Register                     */
  __I  uint32_t  RESERVED7[286];
  __IO uint32_t  TIMESTAMP_CONTROL;                 /*!< (@ 0x5000C700) Timestamp Control Register                             */
  __IO uint32_t  SUB_SECOND_INCREMENT;              /*!< (@ 0x5000C704) Sub-Second Increment Register                          */
  __I  uint32_t  SYSTEM_TIME_SECONDS;               /*!< (@ 0x5000C708) System Time - Seconds Register                         */
  __I  uint32_t  SYSTEM_TIME_NANOSECONDS;           /*!< (@ 0x5000C70C) System Time Nanoseconds Register                       */
  __IO uint32_t  SYSTEM_TIME_SECONDS_UPDATE;        /*!< (@ 0x5000C710) System Time - Seconds Update Register                  */
  __IO uint32_t  SYSTEM_TIME_NANOSECONDS_UPDATE;    /*!< (@ 0x5000C714) System Time Nanoseconds Update Register                */
  __IO uint32_t  TIMESTAMP_ADDEND;                  /*!< (@ 0x5000C718) Timestamp Addend Register                              */
  __IO uint32_t  TARGET_TIME_SECONDS;               /*!< (@ 0x5000C71C) Target Time Seconds Register                           */
  __IO uint32_t  TARGET_TIME_NANOSECONDS;           /*!< (@ 0x5000C720) Target Time Nanoseconds Register                       */
  __IO uint32_t  SYSTEM_TIME_HIGHER_WORD_SECONDS;   /*!< (@ 0x5000C724) System Time - Higher Word Seconds Register             */
  __I  uint32_t  TIMESTAMP_STATUS;                  /*!< (@ 0x5000C728) Timestamp Status Register                              */
  __IO uint32_t  PPS_CONTROL;                       /*!< (@ 0x5000C72C) PPS Control Register                                   */
  __I  uint32_t  RESERVED8[564];
  __IO uint32_t  BUS_MODE;                          /*!< (@ 0x5000D000) Bus Mode Register                                      */
  __IO uint32_t  TRANSMIT_POLL_DEMAND;              /*!< (@ 0x5000D004) Transmit Poll Demand Register                          */
  __IO uint32_t  RECEIVE_POLL_DEMAND;               /*!< (@ 0x5000D008) Receive Poll Demand Register                           */
  __IO uint32_t  RECEIVE_DESCRIPTOR_LIST_ADDRESS;   /*!< (@ 0x5000D00C) Receive Descriptor Address Register                    */
  __IO uint32_t  TRANSMIT_DESCRIPTOR_LIST_ADDRESS;  /*!< (@ 0x5000D010) Transmit descripter Address Register                   */
  __IO uint32_t  STATUS;                            /*!< (@ 0x5000D014) Status Register                                        */
  __IO uint32_t  OPERATION_MODE;                    /*!< (@ 0x5000D018) Operation Mode Register                                */
  __IO uint32_t  INTERRUPT_ENABLE;                  /*!< (@ 0x5000D01C) Interrupt Enable Register                              */
  __I  uint32_t  MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER;/*!< (@ 0x5000D020) Missed Frame and Buffer Overflow Counter Register */
  __IO uint32_t  RECEIVE_INTERRUPT_WATCHDOG_TIMER;  /*!< (@ 0x5000D024) Receive Interrupt Watchdog Timer Register              */
  __I  uint32_t  RESERVED9;
  __I  uint32_t  AHB_STATUS;                        /*!< (@ 0x5000D02C) AHB Status Register                                    */
  __I  uint32_t  RESERVED10[6];
  __I  uint32_t  CURRENT_HOST_TRANSMIT_DESCRIPTOR;  /*!< (@ 0x5000D048) Current Host Transmit Descriptor Register              */
  __I  uint32_t  CURRENT_HOST_RECEIVE_DESCRIPTOR;   /*!< (@ 0x5000D04C) Current Host Receive Descriptor Register               */
  __I  uint32_t  CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS;/*!< (@ 0x5000D050) Current Host Transmit Buffer Address Register        */
  __I  uint32_t  CURRENT_HOST_RECEIVE_BUFFER_ADDRESS;/*!< (@ 0x5000D054) Current Host Receive Buffer Address Register          */
  __IO uint32_t  HW_FEATURE;                        /*!< (@ 0x5000D058) HW Feature Register                                    */
} ETH_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                   USB [USB0]                   ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB)
  */

typedef struct {                                    /*!< (@ 0x50040000) USB Structure                                          */
  __IO uint32_t  GOTGCTL;                           /*!< (@ 0x50040000) Control and Status Register                            */
  __IO uint32_t  GOTGINT;                           /*!< (@ 0x50040004) OTG Interrupt Register                                 */
  __IO uint32_t  GAHBCFG;                           /*!< (@ 0x50040008) AHB Configuration Register                             */
  __IO uint32_t  GUSBCFG;                           /*!< (@ 0x5004000C) USB Configuration Register                             */
  __IO uint32_t  GRSTCTL;                           /*!< (@ 0x50040010) Reset Register                                         */
  
  union {
    __IO uint32_t  GINTSTS_DEVICEMODE;              /*!< (@ 0x50040014) Interrupt Register [DEVICEMODE]                        */
    __IO uint32_t  GINTSTS_HOSTMODE;                /*!< (@ 0x50040014) Interrupt Register [HOSTMODE]                          */
  };
  
  union {
    __IO uint32_t  GINTMSK_DEVICEMODE;              /*!< (@ 0x50040018) Interrupt Mask Register [DEVICEMODE]                   */
    __IO uint32_t  GINTMSK_HOSTMODE;                /*!< (@ 0x50040018) Interrupt Mask Register [HOSTMODE]                     */
  };
  
  union {
    __I  uint32_t  GRXSTSR_DEVICEMODE;              /*!< (@ 0x5004001C) Receive Status Debug Read Register [DEVICEMODE]        */
    __I  uint32_t  GRXSTSR_HOSTMODE;                /*!< (@ 0x5004001C) Receive Status Debug Read Register [HOSTMODE]          */
  };
  
  union {
    __I  uint32_t  GRXSTSP_HOSTMODE;                /*!< (@ 0x50040020) Receive Status Read and Pop Register [HOSTMODE]        */
    __I  uint32_t  GRXSTSP_DEVICEMODE;              /*!< (@ 0x50040020) Receive Status Read and Pop Register [DEVICEMODE]      */
  };
  __IO uint32_t  GRXFSIZ;                           /*!< (@ 0x50040024) Receive FIFO Size Register                             */
  
  union {
    __IO uint32_t  GNPTXFSIZ_DEVICEMODE;            /*!< (@ 0x50040028) Non-Periodic Transmit FIFO Size Register [DEVICEMODE]  */
    __IO uint32_t  GNPTXFSIZ_HOSTMODE;              /*!< (@ 0x50040028) Non-Periodic Transmit FIFO Size Register [HOSTMODE]    */
  };
  __I  uint32_t  GNPTXSTS;                          /*!< (@ 0x5004002C) Non-Periodic Transmit FIFO/Queue Status Register       */
  __I  uint32_t  RESERVED[3];
  __IO uint32_t  GUID;                              /*!< (@ 0x5004003C) USB Module Identification Register                     */
  __I  uint32_t  RESERVED1[7];
  __IO uint32_t  GDFIFOCFG;                         /*!< (@ 0x5004005C) Global DFIFO Software Config Register                  */
  __I  uint32_t  RESERVED2[40];
  __IO uint32_t  HPTXFSIZ;                          /*!< (@ 0x50040100) Host Periodic Transmit FIFO Size Register              */
  __IO uint32_t  DIEPTXF1;                          /*!< (@ 0x50040104) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF2;                          /*!< (@ 0x50040108) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF3;                          /*!< (@ 0x5004010C) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF4;                          /*!< (@ 0x50040110) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF5;                          /*!< (@ 0x50040114) Device IN Endpoint Transmit FIFO Size Register         */
  __IO uint32_t  DIEPTXF6;                          /*!< (@ 0x50040118) Device IN Endpoint Transmit FIFO Size Register         */
  __I  uint32_t  RESERVED3[185];
  __IO uint32_t  HCFG;                              /*!< (@ 0x50040400) Host Configuration Register                            */
  __IO uint32_t  HFIR;                              /*!< (@ 0x50040404) Host Frame Interval Register                           */
  __IO uint32_t  HFNUM;                             /*!< (@ 0x50040408) Host Frame Number/Frame Time Remaining Register        */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  HPTXSTS;                           /*!< (@ 0x50040410) Host Periodic Transmit FIFO/ Queue Status Register     */
  __I  uint32_t  HAINT;                             /*!< (@ 0x50040414) Host All Channels Interrupt Register                   */
  __IO uint32_t  HAINTMSK;                          /*!< (@ 0x50040418) Host All Channels Interrupt Mask Register              */
  __IO uint32_t  HFLBADDR;                          /*!< (@ 0x5004041C) Host Frame List Base Address Register                  */
  __I  uint32_t  RESERVED5[8];
  __IO uint32_t  HPRT;                              /*!< (@ 0x50040440) Host Port Control and Status Register                  */
  __I  uint32_t  RESERVED6[239];
  __IO uint32_t  DCFG;                              /*!< (@ 0x50040800) Device Configuration Register                          */
  __IO uint32_t  DCTL;                              /*!< (@ 0x50040804) Device Control Register                                */
  __I  uint32_t  DSTS;                              /*!< (@ 0x50040808) Device Status Register                                 */
  __I  uint32_t  RESERVED7;
  __IO uint32_t  DIEPMSK;                           /*!< (@ 0x50040810) Device IN Endpoint Common Interrupt Mask Register      */
  __IO uint32_t  DOEPMSK;                           /*!< (@ 0x50040814) Device OUT Endpoint Common Interrupt Mask Register     */
  __I  uint32_t  DAINT;                             /*!< (@ 0x50040818) Device All Endpoints Interrupt Register                */
  __IO uint32_t  DAINTMSK;                          /*!< (@ 0x5004081C) Device All Endpoints Interrupt Mask Register           */
  __I  uint32_t  RESERVED8[2];
  __IO uint32_t  DVBUSDIS;                          /*!< (@ 0x50040828) Device VBUS Discharge Time Register                    */
  __IO uint32_t  DVBUSPULSE;                        /*!< (@ 0x5004082C) Device VBUS Pulsing Time Register                      */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  DIEPEMPMSK;                        /*!< (@ 0x50040834) Device IN Endpoint FIFO Empty Interrupt Mask
                                                         Register                                                              */
  __I  uint32_t  RESERVED10[370];
  __IO uint32_t  PCGCCTL;                           /*!< (@ 0x50040E00) Power and Clock Gating Control Register                */
} USB0_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                    USB0_EP0                    ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB0_EP0)
  */

typedef struct {                                    /*!< (@ 0x50040900) USB0_EP0 Structure                                     */
  __IO uint32_t  DIEPCTL0;                          /*!< (@ 0x50040900) Device Control IN Endpoint Control Register            */
  __I  uint32_t  RESERVED;
  __IO uint32_t  DIEPINT0;                          /*!< (@ 0x50040908) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  DIEPTSIZ0;                         /*!< (@ 0x50040910) Device IN Endpoint Transfer Size Register              */
  __IO uint32_t  DIEPDMA0;                          /*!< (@ 0x50040914) Device Endpoint DMA Address Register                   */
  __I  uint32_t  DTXFSTS0;                          /*!< (@ 0x50040918) Device IN Endpoint Transmit FIFO Status Register       */
  __I  uint32_t  DIEPDMAB0;                         /*!< (@ 0x5004091C) Device Endpoint DMA Buffer Address Register            */
  __I  uint32_t  RESERVED2[120];
  __IO uint32_t  DOEPCTL0;                          /*!< (@ 0x50040B00) Device Control OUT Endpoint Control Register           */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  DOEPINT0;                          /*!< (@ 0x50040B08) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  DOEPTSIZ0;                         /*!< (@ 0x50040B10) Device OUT Endpoint Transfer Size Register             */
  __IO uint32_t  DOEPDMA0;                          /*!< (@ 0x50040B14) Device Endpoint DMA Address Register                   */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  DOEPDMAB0;                         /*!< (@ 0x50040B1C) Device Endpoint DMA Buffer Address Register            */
} USB0_EP0_TypeDef;


/* ================================================================================ */
/* ================                USB_EP [USB0_EP1]               ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB_EP)
  */

typedef struct {                                    /*!< (@ 0x50040920) USB_EP Structure                                       */
  
  union {
    __IO uint32_t  DIEPCTL_INTBULK;                 /*!< (@ 0x50040920) Device Endpoint Control Register [INTBULK]             */
    __IO uint32_t  DIEPCTL_ISOCONT;                 /*!< (@ 0x50040920) Device Endpoint Control Register [ISOCONT]             */
  };
  __I  uint32_t  RESERVED;
  __IO uint32_t  DIEPINT;                           /*!< (@ 0x50040928) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  DIEPTSIZ;                          /*!< (@ 0x50040930) Device Endpoint Transfer Size Register                 */
  __IO uint32_t  DIEPDMA;                           /*!< (@ 0x50040934) Device Endpoint DMA Address Register                   */
  __I  uint32_t  DTXFSTS;                           /*!< (@ 0x50040938) Device IN Endpoint Transmit FIFO Status Register       */
  __I  uint32_t  DIEPDMAB;                          /*!< (@ 0x5004093C) Device Endpoint DMA Buffer Address Register            */
  __I  uint32_t  RESERVED2[120];
  
  union {
    __IO uint32_t  DOEPCTL_INTBULK;                 /*!< (@ 0x50040B20) Device Endpoint Control Register [INTBULK]             */
    __IO uint32_t  DOEPCTL_ISOCONT;                 /*!< (@ 0x50040B20) Device Endpoint Control Register [ISOCONT]             */
  };
  __I  uint32_t  RESERVED3;
  __IO uint32_t  DOEPINT;                           /*!< (@ 0x50040B28) Device Endpoint Interrupt Register                     */
  __I  uint32_t  RESERVED4;
  
  union {
    __IO uint32_t  DOEPTSIZ_CONTROL;                /*!< (@ 0x50040B30) Device Endpoint Transfer Size Register [CONT]          */
    __IO uint32_t  DOEPTSIZ_ISO;                    /*!< (@ 0x50040B30) Device Endpoint Transfer Size Register [ISO]           */
  };
  __IO uint32_t  DOEPDMA;                           /*!< (@ 0x50040B34) Device Endpoint DMA Address Register                   */
  __I  uint32_t  RESERVED5;
  __I  uint32_t  DOEPDMAB;                          /*!< (@ 0x50040B3C) Device Endpoint DMA Buffer Address Register            */
} USB0_EP_TypeDef;


/* ================================================================================ */
/* ================                USB_CH [USB0_CH0]               ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Bus (USB_CH)
  */

typedef struct {                                    /*!< (@ 0x50040500) USB_CH Structure                                       */
  __IO uint32_t  HCCHAR;                            /*!< (@ 0x50040500) Host Channel Characteristics Register                  */
  __I  uint32_t  RESERVED;
  __IO uint32_t  HCINT;                             /*!< (@ 0x50040508) Host Channel Interrupt Register                        */
  __IO uint32_t  HCINTMSK;                          /*!< (@ 0x5004050C) Host Channel Interrupt Mask Register                   */
  
  union {
    __IO uint32_t  HCTSIZ_SCATGATHER;               /*!< (@ 0x50040510) Host Channel Transfer Size Register [SCATGATHER]       */
    __IO uint32_t  HCTSIZ_BUFFERMODE;               /*!< (@ 0x50040510) Host Channel Transfer Size Register [BUFFERMODE]       */
  };
  
  union {
    __IO uint32_t  HCDMA_SCATGATHER;                /*!< (@ 0x50040514) Host Channel DMA Address Register [SCATGATHER]         */
    __IO uint32_t  HCDMA_BUFFERMODE;                /*!< (@ 0x50040514) Host Channel DMA Address Register [BUFFERMODE]         */
  };
  __I  uint32_t  RESERVED1;
  __I  uint32_t  HCDMAB;                            /*!< (@ 0x5004051C) Host Channel DMA Buffer Address Register               */
} USB0_CH_TypeDef;


/* ================================================================================ */
/* ================                  USIC [USIC0]                  ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Interface Controller 0 (USIC)
  */

typedef struct {                                    /*!< (@ 0x40030008) USIC Structure                                         */
  __I  uint32_t  ID;                                /*!< (@ 0x40030008) Module Identification Register                         */
} USIC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================               USIC_CH [USIC0_CH0]              ================ */
/* ================================================================================ */


/**
  * @brief Universal Serial Interface Controller 0 (USIC_CH)
  */

typedef struct {                                    /*!< (@ 0x40030000) USIC_CH Structure                                      */
  __I  uint32_t  RESERVED;
  __I  uint32_t  CCFG;                              /*!< (@ 0x40030004) Channel Configuration Register                         */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  KSCFG;                             /*!< (@ 0x4003000C) Kernel State Configuration Register                    */
  __IO uint32_t  FDR;                               /*!< (@ 0x40030010) Fractional Divider Register                            */
  __IO uint32_t  BRG;                               /*!< (@ 0x40030014) Baud Rate Generator Register                           */
  __IO uint32_t  INPR;                              /*!< (@ 0x40030018) Interrupt Node Pointer Register                        */
  __IO uint32_t  DX0CR;                             /*!< (@ 0x4003001C) Input Control Register 0                               */
  __IO uint32_t  DX1CR;                             /*!< (@ 0x40030020) Input Control Register 1                               */
  __IO uint32_t  DX2CR;                             /*!< (@ 0x40030024) Input Control Register 2                               */
  __IO uint32_t  DX3CR;                             /*!< (@ 0x40030028) Input Control Register 3                               */
  __IO uint32_t  DX4CR;                             /*!< (@ 0x4003002C) Input Control Register 4                               */
  __IO uint32_t  DX5CR;                             /*!< (@ 0x40030030) Input Control Register 5                               */
  __IO uint32_t  SCTR;                              /*!< (@ 0x40030034) Shift Control Register                                 */
  __IO uint32_t  TCSR;                              /*!< (@ 0x40030038) Transmit Control/Status Register                       */
  
  union {
    __IO uint32_t  PCR_IICMode;                     /*!< (@ 0x4003003C) Protocol Control Register [IIC Mode]                   */
    __IO uint32_t  PCR_IISMode;                     /*!< (@ 0x4003003C) Protocol Control Register [IIS Mode]                   */
    __IO uint32_t  PCR_SSCMode;                     /*!< (@ 0x4003003C) Protocol Control Register [SSC Mode]                   */
    __IO uint32_t  PCR;                             /*!< (@ 0x4003003C) Protocol Control Register                              */
    __IO uint32_t  PCR_ASCMode;                     /*!< (@ 0x4003003C) Protocol Control Register [ASC Mode]                   */
  };
  __IO uint32_t  CCR;                               /*!< (@ 0x40030040) Channel Control Register                               */
  __IO uint32_t  CMTR;                              /*!< (@ 0x40030044) Capture Mode Timer Register                            */
  
  union {
    __IO uint32_t  PSR_IICMode;                     /*!< (@ 0x40030048) Protocol Status Register [IIC Mode]                    */
    __IO uint32_t  PSR_IISMode;                     /*!< (@ 0x40030048) Protocol Status Register [IIS Mode]                    */
    __IO uint32_t  PSR_SSCMode;                     /*!< (@ 0x40030048) Protocol Status Register [SSC Mode]                    */
    __IO uint32_t  PSR;                             /*!< (@ 0x40030048) Protocol Status Register                               */
    __IO uint32_t  PSR_ASCMode;                     /*!< (@ 0x40030048) Protocol Status Register [ASC Mode]                    */
  };
  __O  uint32_t  PSCR;                              /*!< (@ 0x4003004C) Protocol Status Clear Register                         */
  __I  uint32_t  RBUFSR;                            /*!< (@ 0x40030050) Receiver Buffer Status Register                        */
  __I  uint32_t  RBUF;                              /*!< (@ 0x40030054) Receiver Buffer Register                               */
  __I  uint32_t  RBUFD;                             /*!< (@ 0x40030058) Receiver Buffer Register for Debugger                  */
  __I  uint32_t  RBUF0;                             /*!< (@ 0x4003005C) Receiver Buffer Register 0                             */
  __I  uint32_t  RBUF1;                             /*!< (@ 0x40030060) Receiver Buffer Register 1                             */
  __I  uint32_t  RBUF01SR;                          /*!< (@ 0x40030064) Receiver Buffer 01 Status Register                     */
  __O  uint32_t  FMR;                               /*!< (@ 0x40030068) Flag Modification Register                             */
  __I  uint32_t  RESERVED2[5];
  __IO uint32_t  TBUF[32];                          /*!< (@ 0x40030080) Transmit Buffer                                        */
  __IO uint32_t  BYP;                               /*!< (@ 0x40030100) Bypass Data Register                                   */
  __IO uint32_t  BYPCR;                             /*!< (@ 0x40030104) Bypass Control Register                                */
  __IO uint32_t  TBCTR;                             /*!< (@ 0x40030108) Transmitter Buffer Control Register                    */
  __IO uint32_t  RBCTR;                             /*!< (@ 0x4003010C) Receiver Buffer Control Register                       */
  __I  uint32_t  TRBPTR;                            /*!< (@ 0x40030110) Transmit/Receive Buffer Pointer Register               */
  __IO uint32_t  TRBSR;                             /*!< (@ 0x40030114) Transmit/Receive Buffer Status Register                */
  __O  uint32_t  TRBSCR;                            /*!< (@ 0x40030118) Transmit/Receive Buffer Status Clear Register          */
  __I  uint32_t  OUTR;                              /*!< (@ 0x4003011C) Receiver Buffer Output Register                        */
  __I  uint32_t  OUTDR;                             /*!< (@ 0x40030120) Receiver Buffer Output Register L for Debugger         */
  __I  uint32_t  RESERVED3[23];
  __O  uint32_t  IN[32];                            /*!< (@ 0x40030180) Transmit FIFO Buffer                                   */
} USIC_CH_TypeDef;


/* ================================================================================ */
/* ================                       CAN                      ================ */
/* ================================================================================ */


/**
  * @brief Controller Area Networks (CAN)
  */

typedef struct {                                    /*!< (@ 0x48014000) CAN Structure                                          */
  __IO uint32_t  CLC;                               /*!< (@ 0x48014000) CAN Clock Control Register                             */
  __I  uint32_t  RESERVED;
  __I  uint32_t  ID;                                /*!< (@ 0x48014008) Module Identification Register                         */
  __IO uint32_t  FDR;                               /*!< (@ 0x4801400C) CAN Fractional Divider Register                        */
  __I  uint32_t  RESERVED1[60];
  __I  uint32_t  LIST[8];                           /*!< (@ 0x48014100) List Register                                          */
  __I  uint32_t  RESERVED2[8];
  __IO uint32_t  MSPND[8];                          /*!< (@ 0x48014140) Message Pending Register                               */
  __I  uint32_t  RESERVED3[8];
  __I  uint32_t  MSID[8];                           /*!< (@ 0x48014180) Message Index Register                                 */
  __I  uint32_t  RESERVED4[8];
  __IO uint32_t  MSIMASK;                           /*!< (@ 0x480141C0) Message Index Mask Register                            */
  __IO uint32_t  PANCTR;                            /*!< (@ 0x480141C4) Panel Control Register                                 */
  __IO uint32_t  MCR;                               /*!< (@ 0x480141C8) Module Control Register                                */
  __O  uint32_t  MITR;                              /*!< (@ 0x480141CC) Module Interrupt Trigger Register                      */
} CAN_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================              CAN_NODE [CAN_NODE0]              ================ */
/* ================================================================================ */


/**
  * @brief Controller Area Networks (CAN_NODE)
  */

typedef struct {                                    /*!< (@ 0x48014200) CAN_NODE Structure                                     */
  __IO uint32_t  NCR;                               /*!< (@ 0x48014200) Node Control Register                                  */
  __IO uint32_t  NSR;                               /*!< (@ 0x48014204) Node Status Register                                   */
  __IO uint32_t  NIPR;                              /*!< (@ 0x48014208) Node Interrupt Pointer Register                        */
  __IO uint32_t  NPCR;                              /*!< (@ 0x4801420C) Node Port Control Register                             */
  __IO uint32_t  NBTR;                              /*!< (@ 0x48014210) Node Bit Timing Register                               */
  __IO uint32_t  NECNT;                             /*!< (@ 0x48014214) Node Error Counter Register                            */
  __IO uint32_t  NFCR;                              /*!< (@ 0x48014218) Node Frame Counter Register                            */
} CAN_NODE_TypeDef;


/* ================================================================================ */
/* ================                CAN_MO [CAN_MO0]                ================ */
/* ================================================================================ */


/**
  * @brief Controller Area Networks (CAN_MO)
  */

typedef struct {                                    /*!< (@ 0x48015000) CAN_MO Structure                                       */
  __IO uint32_t  MOFCR;                             /*!< (@ 0x48015000) Message Object Function Control Register               */
  __IO uint32_t  MOFGPR;                            /*!< (@ 0x48015004) Message Object FIFO/Gateway Pointer Register           */
  __IO uint32_t  MOIPR;                             /*!< (@ 0x48015008) Message Object Interrupt Pointer Register              */
  __IO uint32_t  MOAMR;                             /*!< (@ 0x4801500C) Message Object Acceptance Mask Register                */
  __IO uint32_t  MODATAL;                           /*!< (@ 0x48015010) Message Object Data Register Low                       */
  __IO uint32_t  MODATAH;                           /*!< (@ 0x48015014) Message Object Data Register High                      */
  __IO uint32_t  MOAR;                              /*!< (@ 0x48015018) Message Object Arbitration Register                    */
  
  union {
    __I  uint32_t  MOSTAT;                          /*!< (@ 0x4801501C) Message Object Status Register                         */
    __O  uint32_t  MOCTR;                           /*!< (@ 0x4801501C) Message Object Control Register                        */
  };
} CAN_MO_TypeDef;


/* ================================================================================ */
/* ================                      VADC                      ================ */
/* ================================================================================ */


/**
  * @brief Analog to Digital Converter (VADC)
  */

typedef struct {                                    /*!< (@ 0x40004000) VADC Structure                                         */
  __IO uint32_t  CLC;                               /*!< (@ 0x40004000) Clock Control Register                                 */
  __I  uint32_t  RESERVED;
  __I  uint32_t  ID;                                /*!< (@ 0x40004008) Module Identification Register                         */
  __I  uint32_t  RESERVED1[7];
  __IO uint32_t  OCS;                               /*!< (@ 0x40004028) OCDS Control and Status Register                       */
  __I  uint32_t  RESERVED2[21];
  __IO uint32_t  GLOBCFG;                           /*!< (@ 0x40004080) Global Configuration Register                          */
  __I  uint32_t  RESERVED3[7];
  __IO uint32_t  GLOBICLASS[2];                     /*!< (@ 0x400040A0) Input Class Register, Global                           */
  __I  uint32_t  RESERVED4[4];
  __IO uint32_t  GLOBBOUND;                         /*!< (@ 0x400040B8) Global Boundary Select Register                        */
  __I  uint32_t  RESERVED5[9];
  __IO uint32_t  GLOBEFLAG;                         /*!< (@ 0x400040E0) Global Event Flag Register                             */
  __I  uint32_t  RESERVED6[23];
  __IO uint32_t  GLOBEVNP;                          /*!< (@ 0x40004140) Global Event Node Pointer Register                     */
  __I  uint32_t  RESERVED7[7];
  __IO uint32_t  GLOBTF;                            /*!< (@ 0x40004160) Global Test Functions Register                         */
  __I  uint32_t  RESERVED8[7];
  __IO uint32_t  BRSSEL[4];                         /*!< (@ 0x40004180) Background Request Source Channel Select Register      */
  __I  uint32_t  RESERVED9[12];
  __IO uint32_t  BRSPND[4];                         /*!< (@ 0x400041C0) Background Request Source Pending Register             */
  __I  uint32_t  RESERVED10[12];
  __IO uint32_t  BRSCTRL;                           /*!< (@ 0x40004200) Background Request Source Control Register             */
  __IO uint32_t  BRSMR;                             /*!< (@ 0x40004204) Background Request Source Mode Register                */
  __I  uint32_t  RESERVED11[30];
  __IO uint32_t  GLOBRCR;                           /*!< (@ 0x40004280) Global Result Control Register                         */
  __I  uint32_t  RESERVED12[31];
  __IO uint32_t  GLOBRES;                           /*!< (@ 0x40004300) Global Result Register                                 */
  __I  uint32_t  RESERVED13[31];
  __IO uint32_t  GLOBRESD;                          /*!< (@ 0x40004380) Global Result Register, Debug                          */
  __I  uint32_t  RESERVED14[27];
  __IO uint32_t  EMUXSEL;                           /*!< (@ 0x400043F0) External Multiplexer Select Register                   */
} VADC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                VADC_G [VADC_G0]                ================ */
/* ================================================================================ */


/**
  * @brief Analog to Digital Converter (VADC_G)
  */

typedef struct {                                    /*!< (@ 0x40004400) VADC_G Structure                                       */
  __I  uint32_t  RESERVED[32];
  __IO uint32_t  ARBCFG;                            /*!< (@ 0x40004480) Arbitration Configuration Register                     */
  __IO uint32_t  ARBPR;                             /*!< (@ 0x40004484) Arbitration Priority Register                          */
  __IO uint32_t  CHASS;                             /*!< (@ 0x40004488) Channel Assignment Register                            */
  __I  uint32_t  RESERVED1[5];
  __IO uint32_t  ICLASS[2];                         /*!< (@ 0x400044A0) Input Class Register                                   */
  __I  uint32_t  RESERVED2[2];
  __IO uint32_t  ALIAS;                             /*!< (@ 0x400044B0) Alias Register                                         */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  BOUND;                             /*!< (@ 0x400044B8) Boundary Select Register                               */
  __I  uint32_t  RESERVED4;
  __IO uint32_t  SYNCTR;                            /*!< (@ 0x400044C0) Synchronization Control Register                       */
  __I  uint32_t  RESERVED5;
  __IO uint32_t  BFL;                               /*!< (@ 0x400044C8) Boundary Flag Register                                 */
  __O  uint32_t  BFLS;                              /*!< (@ 0x400044CC) Boundary Flag Software Register                        */
  __IO uint32_t  BFLC;                              /*!< (@ 0x400044D0) Boundary Flag Control Register                         */
  __IO uint32_t  BFLNP;                             /*!< (@ 0x400044D4) Boundary Flag Node Pointer Register                    */
  __I  uint32_t  RESERVED6[10];
  __IO uint32_t  QCTRL0;                            /*!< (@ 0x40004500) Queue 0 Source Control Register                        */
  __IO uint32_t  QMR0;                              /*!< (@ 0x40004504) Queue 0 Mode Register                                  */
  __I  uint32_t  QSR0;                              /*!< (@ 0x40004508) Queue 0 Status Register                                */
  __I  uint32_t  Q0R0;                              /*!< (@ 0x4000450C) Queue 0 Register 0                                     */
  
  union {
    __I  uint32_t  QBUR0;                           /*!< (@ 0x40004510) Queue 0 Backup Register                                */
    __O  uint32_t  QINR0;                           /*!< (@ 0x40004510) Queue 0 Input Register                                 */
  };
  __I  uint32_t  RESERVED7[3];
  __IO uint32_t  ASCTRL;                            /*!< (@ 0x40004520) Autoscan Source Control Register                       */
  __IO uint32_t  ASMR;                              /*!< (@ 0x40004524) Autoscan Source Mode Register                          */
  __IO uint32_t  ASSEL;                             /*!< (@ 0x40004528) Autoscan Source Channel Select Register                */
  __IO uint32_t  ASPND;                             /*!< (@ 0x4000452C) Autoscan Source Pending Register                       */
  __I  uint32_t  RESERVED8[20];
  __IO uint32_t  CEFLAG;                            /*!< (@ 0x40004580) Channel Event Flag Register                            */
  __IO uint32_t  REFLAG;                            /*!< (@ 0x40004584) Result Event Flag Register                             */
  __IO uint32_t  SEFLAG;                            /*!< (@ 0x40004588) Source Event Flag Register                             */
  __I  uint32_t  RESERVED9;
  __O  uint32_t  CEFCLR;                            /*!< (@ 0x40004590) Channel Event Flag Clear Register                      */
  __O  uint32_t  REFCLR;                            /*!< (@ 0x40004594) Result Event Flag Clear Register                       */
  __O  uint32_t  SEFCLR;                            /*!< (@ 0x40004598) Source Event Flag Clear Register                       */
  __I  uint32_t  RESERVED10;
  __IO uint32_t  CEVNP0;                            /*!< (@ 0x400045A0) Channel Event Node Pointer Register 0                  */
  __I  uint32_t  RESERVED11[3];
  __IO uint32_t  REVNP0;                            /*!< (@ 0x400045B0) Result Event Node Pointer Register 0                   */
  __IO uint32_t  REVNP1;                            /*!< (@ 0x400045B4) Result Event Node Pointer Register 1                   */
  __I  uint32_t  RESERVED12[2];
  __IO uint32_t  SEVNP;                             /*!< (@ 0x400045C0) Source Event Node Pointer Register                     */
  __I  uint32_t  RESERVED13;
  __O  uint32_t  SRACT;                             /*!< (@ 0x400045C8) Service Request Software Activation Trigger            */
  __I  uint32_t  RESERVED14[9];
  __IO uint32_t  EMUXCTR;                           /*!< (@ 0x400045F0) E0ternal Multiplexer Control Register                  */
  __I  uint32_t  RESERVED15;
  __IO uint32_t  VFR;                               /*!< (@ 0x400045F8) Valid Flag Register                                    */
  __I  uint32_t  RESERVED16;
  __IO uint32_t  CHCTR[8];                          /*!< (@ 0x40004600) Channel Ctrl. Reg.                                     */
  __I  uint32_t  RESERVED17[24];
  __IO uint32_t  RCR[16];                           /*!< (@ 0x40004680) Result Control Register                                */
  __I  uint32_t  RESERVED18[16];
  __IO uint32_t  RES[16];                           /*!< (@ 0x40004700) Result Register                                        */
  __I  uint32_t  RESERVED19[16];
  __I  uint32_t  RESD[16];                          /*!< (@ 0x40004780) Result Register, Debug                                 */
} VADC_G_TypeDef;


/* ================================================================================ */
/* ================                       DSD                      ================ */
/* ================================================================================ */


/**
  * @brief Delta Sigma Demodulator (DSD)
  */

typedef struct {                                    /*!< (@ 0x40008000) DSD Structure                                          */
  __IO uint32_t  CLC;                               /*!< (@ 0x40008000) Clock Control Register                                 */
  __I  uint32_t  RESERVED;
  __I  uint32_t  ID;                                /*!< (@ 0x40008008) Module Identification Register                         */
  __I  uint32_t  RESERVED1[7];
  __IO uint32_t  OCS;                               /*!< (@ 0x40008028) OCDS Control and Status Register                       */
  __I  uint32_t  RESERVED2[21];
  __IO uint32_t  GLOBCFG;                           /*!< (@ 0x40008080) Global Configuration Register                          */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  GLOBRC;                            /*!< (@ 0x40008088) Global Run Control Register                            */
  __I  uint32_t  RESERVED4[5];
  __IO uint32_t  CGCFG;                             /*!< (@ 0x400080A0) Carrier Generator Configuration Register               */
  __I  uint32_t  RESERVED5[15];
  __IO uint32_t  EVFLAG;                            /*!< (@ 0x400080E0) Event Flag Register                                    */
  __O  uint32_t  EVFLAGCLR;                         /*!< (@ 0x400080E4) Event Flag Clear Register                              */
} DSD_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                DSD_CH [DSD_CH0]                ================ */
/* ================================================================================ */


/**
  * @brief Delta Sigma Demodulator (DSD_CH)
  */

typedef struct {                                    /*!< (@ 0x40008100) DSD_CH Structure                                       */
  __IO uint32_t  MODCFG;                            /*!< (@ 0x40008100) Modulator Configuration Register                       */
  __I  uint32_t  RESERVED;
  __IO uint32_t  DICFG;                             /*!< (@ 0x40008108) Demodulator Input Configuration Register               */
  __I  uint32_t  RESERVED1[2];
  __IO uint32_t  FCFGC;                             /*!< (@ 0x40008114) Filter Configuration Register, Main CIC Filter         */
  __IO uint32_t  FCFGA;                             /*!< (@ 0x40008118) Filter Configuration Register, Auxiliary Filter        */
  __I  uint32_t  RESERVED2;
  __IO uint32_t  IWCTR;                             /*!< (@ 0x40008120) Integration Window Control Register                    */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  BOUNDSEL;                          /*!< (@ 0x40008128) Boundary Select Register                               */
  __I  uint32_t  RESERVED4;
  __I  uint32_t  RESM;                              /*!< (@ 0x40008130) Result Register, Main Filter                           */
  __I  uint32_t  RESERVED5;
  __IO uint32_t  OFFM;                              /*!< (@ 0x40008138) Offset Register, Main Filter                           */
  __I  uint32_t  RESERVED6;
  __I  uint32_t  RESA;                              /*!< (@ 0x40008140) Result Register, Auxiliary Filter                      */
  __I  uint32_t  RESERVED7[3];
  __I  uint32_t  TSTMP;                             /*!< (@ 0x40008150) Time-Stamp Register                                    */
  __I  uint32_t  RESERVED8[19];
  __IO uint32_t  CGSYNC;                            /*!< (@ 0x400081A0) Carrier Generator Synchronization Register             */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  RECTCFG;                           /*!< (@ 0x400081A8) Rectification Configuration Register                   */
} DSD_CH_TypeDef;


/* ================================================================================ */
/* ================                       DAC                      ================ */
/* ================================================================================ */


/**
  * @brief Digital to Analog Converter (DAC)
  */

typedef struct {                                    /*!< (@ 0x48018000) DAC Structure                                          */
  __I  uint32_t  ID;                                /*!< (@ 0x48018000) Module Identification Register                         */
  __IO uint32_t  DAC0CFG0;                          /*!< (@ 0x48018004) DAC0 Configuration Register 0                          */
  __IO uint32_t  DAC0CFG1;                          /*!< (@ 0x48018008) DAC0 Configuration Register 1                          */
  __IO uint32_t  DAC1CFG0;                          /*!< (@ 0x4801800C) DAC1 Configuration Register 0                          */
  __IO uint32_t  DAC1CFG1;                          /*!< (@ 0x48018010) DAC1 Configuration Register 1                          */
  __IO uint32_t  DAC0DATA;                          /*!< (@ 0x48018014) DAC0 Data Register                                     */
  __IO uint32_t  DAC1DATA;                          /*!< (@ 0x48018018) DAC1 Data Register                                     */
  __IO uint32_t  DAC01DATA;                         /*!< (@ 0x4801801C) DAC01 Data Register                                    */
  __IO uint32_t  DAC0PATL;                          /*!< (@ 0x48018020) DAC0 Lower Pattern Register                            */
  __IO uint32_t  DAC0PATH;                          /*!< (@ 0x48018024) DAC0 Higher Pattern Register                           */
  __IO uint32_t  DAC1PATL;                          /*!< (@ 0x48018028) DAC1 Lower Pattern Register                            */
  __IO uint32_t  DAC1PATH;                          /*!< (@ 0x4801802C) DAC1 Higher Pattern Register                           */
} DAC_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                  CCU4 [CCU40]                  ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 4 - Unit 0 (CCU4)
  */

typedef struct {                                    /*!< (@ 0x4000C000) CCU4 Structure                                         */
  __IO uint32_t  GCTRL;                             /*!< (@ 0x4000C000) Global Control Register                                */
  __I  uint32_t  GSTAT;                             /*!< (@ 0x4000C004) Global Status Register                                 */
  __O  uint32_t  GIDLS;                             /*!< (@ 0x4000C008) Global Idle Set                                        */
  __O  uint32_t  GIDLC;                             /*!< (@ 0x4000C00C) Global Idle Clear                                      */
  __O  uint32_t  GCSS;                              /*!< (@ 0x4000C010) Global Channel Set                                     */
  __O  uint32_t  GCSC;                              /*!< (@ 0x4000C014) Global Channel Clear                                   */
  __I  uint32_t  GCST;                              /*!< (@ 0x4000C018) Global Channel Status                                  */
  __I  uint32_t  RESERVED[13];
  __I  uint32_t  ECRD;                              /*!< (@ 0x4000C050) Extended Capture Mode Read                             */
  __I  uint32_t  RESERVED1[11];
  __I  uint32_t  MIDR;                              /*!< (@ 0x4000C080) Module Identification                                  */
} CCU4_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================              CCU4_CC4 [CCU40_CC40]             ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 4 - Unit 0 (CCU4_CC4)
  */

typedef struct {                                    /*!< (@ 0x4000C100) CCU4_CC4 Structure                                     */
  __IO uint32_t  INS;                               /*!< (@ 0x4000C100) Input Selector Configuration                           */
  __IO uint32_t  CMC;                               /*!< (@ 0x4000C104) Connection Matrix Control                              */
  __I  uint32_t  TCST;                              /*!< (@ 0x4000C108) Slice Timer Status                                     */
  __O  uint32_t  TCSET;                             /*!< (@ 0x4000C10C) Slice Timer Run Set                                    */
  __O  uint32_t  TCCLR;                             /*!< (@ 0x4000C110) Slice Timer Clear                                      */
  __IO uint32_t  TC;                                /*!< (@ 0x4000C114) Slice Timer Control                                    */
  __IO uint32_t  PSL;                               /*!< (@ 0x4000C118) Passive Level Config                                   */
  __I  uint32_t  DIT;                               /*!< (@ 0x4000C11C) Dither Config                                          */
  __IO uint32_t  DITS;                              /*!< (@ 0x4000C120) Dither Shadow Register                                 */
  __IO uint32_t  PSC;                               /*!< (@ 0x4000C124) Prescaler Control                                      */
  __IO uint32_t  FPC;                               /*!< (@ 0x4000C128) Floating Prescaler Control                             */
  __IO uint32_t  FPCS;                              /*!< (@ 0x4000C12C) Floating Prescaler Shadow                              */
  __I  uint32_t  PR;                                /*!< (@ 0x4000C130) Timer Period Value                                     */
  __IO uint32_t  PRS;                               /*!< (@ 0x4000C134) Timer Shadow Period Value                              */
  __I  uint32_t  CR;                                /*!< (@ 0x4000C138) Timer Compare Value                                    */
  __IO uint32_t  CRS;                               /*!< (@ 0x4000C13C) Timer Shadow Compare Value                             */
  __I  uint32_t  RESERVED[12];
  __IO uint32_t  TIMER;                             /*!< (@ 0x4000C170) Timer Value                                            */
  __I  uint32_t  CV[4];                             /*!< (@ 0x4000C174) Capture Register 0                                     */
  __I  uint32_t  RESERVED1[7];
  __I  uint32_t  INTS;                              /*!< (@ 0x4000C1A0) Interrupt Status                                       */
  __IO uint32_t  INTE;                              /*!< (@ 0x4000C1A4) Interrupt Enable Control                               */
  __IO uint32_t  SRS;                               /*!< (@ 0x4000C1A8) Service Request Selector                               */
  __O  uint32_t  SWS;                               /*!< (@ 0x4000C1AC) Interrupt Status Set                                   */
  __O  uint32_t  SWR;                               /*!< (@ 0x4000C1B0) Interrupt Status Clear                                 */
} CCU4_CC4_TypeDef;


/* ================================================================================ */
/* ================                  CCU8 [CCU80]                  ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 8 - Unit 0 (CCU8)
  */

typedef struct {                                    /*!< (@ 0x40020000) CCU8 Structure                                         */
  __IO uint32_t  GCTRL;                             /*!< (@ 0x40020000) Global Control Register                                */
  __I  uint32_t  GSTAT;                             /*!< (@ 0x40020004) Global Status Register                                 */
  __O  uint32_t  GIDLS;                             /*!< (@ 0x40020008) Global Idle Set                                        */
  __O  uint32_t  GIDLC;                             /*!< (@ 0x4002000C) Global Idle Clear                                      */
  __O  uint32_t  GCSS;                              /*!< (@ 0x40020010) Global Channel Set                                     */
  __O  uint32_t  GCSC;                              /*!< (@ 0x40020014) Global Channel Clear                                   */
  __I  uint32_t  GCST;                              /*!< (@ 0x40020018) Global Channel status                                  */
  __IO uint32_t  GPCHK;                             /*!< (@ 0x4002001C) Parity Checker Configuration                           */
  __I  uint32_t  RESERVED[12];
  __I  uint32_t  ECRD;                              /*!< (@ 0x40020050) Extended Capture Mode Read                             */
  __I  uint32_t  RESERVED1[11];
  __I  uint32_t  MIDR;                              /*!< (@ 0x40020080) Module Identification                                  */
} CCU8_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================              CCU8_CC8 [CCU80_CC80]             ================ */
/* ================================================================================ */


/**
  * @brief Capture Compare Unit 8 - Unit 0 (CCU8_CC8)
  */

typedef struct {                                    /*!< (@ 0x40020100) CCU8_CC8 Structure                                     */
  __IO uint32_t  INS;                               /*!< (@ 0x40020100) Input Selector Configuration                           */
  __IO uint32_t  CMC;                               /*!< (@ 0x40020104) Connection Matrix Control                              */
  __I  uint32_t  TCST;                              /*!< (@ 0x40020108) Slice Timer Status                                     */
  __O  uint32_t  TCSET;                             /*!< (@ 0x4002010C) Slice Timer Run Set                                    */
  __O  uint32_t  TCCLR;                             /*!< (@ 0x40020110) Slice Timer Clear                                      */
  __IO uint32_t  TC;                                /*!< (@ 0x40020114) Slice Timer Control                                    */
  __IO uint32_t  PSL;                               /*!< (@ 0x40020118) Passive Level Config                                   */
  __I  uint32_t  DIT;                               /*!< (@ 0x4002011C) Dither Config                                          */
  __IO uint32_t  DITS;                              /*!< (@ 0x40020120) Dither Shadow Register                                 */
  __IO uint32_t  PSC;                               /*!< (@ 0x40020124) Prescaler Control                                      */
  __IO uint32_t  FPC;                               /*!< (@ 0x40020128) Floating Prescaler Control                             */
  __IO uint32_t  FPCS;                              /*!< (@ 0x4002012C) Floating Prescaler Shadow                              */
  __I  uint32_t  PR;                                /*!< (@ 0x40020130) Timer Period Value                                     */
  __IO uint32_t  PRS;                               /*!< (@ 0x40020134) Timer Shadow Period Value                              */
  __I  uint32_t  CR1;                               /*!< (@ 0x40020138) Channel 1 Compare Value                                */
  __IO uint32_t  CR1S;                              /*!< (@ 0x4002013C) Channel 1 Compare Shadow Value                         */
  __I  uint32_t  CR2;                               /*!< (@ 0x40020140) Channel 2 Compare Value                                */
  __IO uint32_t  CR2S;                              /*!< (@ 0x40020144) Channel 2 Compare Shadow Value                         */
  __IO uint32_t  CHC;                               /*!< (@ 0x40020148) Channel Control                                        */
  __IO uint32_t  DTC;                               /*!< (@ 0x4002014C) Dead Time Control                                      */
  __IO uint32_t  DC1R;                              /*!< (@ 0x40020150) Channel 1 Dead Time Values                             */
  __IO uint32_t  DC2R;                              /*!< (@ 0x40020154) Channel 2 Dead Time Values                             */
  __I  uint32_t  RESERVED[6];
  __IO uint32_t  TIMER;                             /*!< (@ 0x40020170) Timer Value                                            */
  __I  uint32_t  CV[4];                             /*!< (@ 0x40020174) Capture Register 0                                     */
  __I  uint32_t  RESERVED1[7];
  __I  uint32_t  INTS;                              /*!< (@ 0x400201A0) Interrupt Status                                       */
  __IO uint32_t  INTE;                              /*!< (@ 0x400201A4) Interrupt Enable Control                               */
  __IO uint32_t  SRS;                               /*!< (@ 0x400201A8) Service Request Selector                               */
  __O  uint32_t  SWS;                               /*!< (@ 0x400201AC) Interrupt Status Set                                   */
  __O  uint32_t  SWR;                               /*!< (@ 0x400201B0) Interrupt Status Clear                                 */
  __IO uint32_t  STC;                               /*!< (@ 0x400201B4) Shadow transfer control                                */
} CCU8_CC8_TypeDef;


/* ================================================================================ */
/* ================                     HRPWM0                     ================ */
/* ================================================================================ */


/**
  * @brief High Resolution PWM Unit (HRPWM0)
  */

typedef struct {                                    /*!< (@ 0x40020900) HRPWM0 Structure                                       */
  __IO uint32_t  HRBSC;                             /*!< (@ 0x40020900) Bias and suspend configuration                         */
  __I  uint32_t  RESERVED;
  __I  uint32_t  MIDR;                              /*!< (@ 0x40020908) Module identification register                         */
  __I  uint32_t  RESERVED1[2];
  __IO uint32_t  GLBANA;                            /*!< (@ 0x40020914) Global Analog Configuration                            */
  __I  uint32_t  RESERVED2[2];
  __IO uint32_t  CSGCFG;                            /*!< (@ 0x40020920) Global CSG configuration                               */
  __O  uint32_t  CSGSETG;                           /*!< (@ 0x40020924) Global CSG run bit set                                 */
  __O  uint32_t  CSGCLRG;                           /*!< (@ 0x40020928) Global CSG run bit clear                               */
  __I  uint32_t  CSGSTATG;                          /*!< (@ 0x4002092C) Global CSG run bit status                              */
  __O  uint32_t  CSGFCG;                            /*!< (@ 0x40020930) Global CSG slope/prescaler control                     */
  __I  uint32_t  CSGFSG;                            /*!< (@ 0x40020934) Global CSG slope/prescaler status                      */
  __O  uint32_t  CSGTRG;                            /*!< (@ 0x40020938) Global CSG shadow/switch trigger                       */
  __O  uint32_t  CSGTRC;                            /*!< (@ 0x4002093C) Global CSG shadow trigger clear                        */
  __I  uint32_t  CSGTRSG;                           /*!< (@ 0x40020940) Global CSG shadow/switch status                        */
  __I  uint32_t  RESERVED3[7];
  __IO uint32_t  HRCCFG;                            /*!< (@ 0x40020960) Global HRC configuration                               */
  __O  uint32_t  HRCSTRG;                           /*!< (@ 0x40020964) Global HRC shadow trigger set                          */
  __O  uint32_t  HRCCTRG;                           /*!< (@ 0x40020968) Global HRC shadow trigger clear                        */
  __I  uint32_t  HRCSTSG;                           /*!< (@ 0x4002096C) Global HRC shadow transfer status                      */
  __I  uint32_t  HRGHRS;                            /*!< (@ 0x40020970) High Resolution Generation Status                      */
} HRPWM0_Type;


/* ================================================================================ */
/* ================            HRPWM0_CSG [HRPWM0_CSG0]            ================ */
/* ================================================================================ */


/**
  * @brief High Resolution PWM Unit (HRPWM0_CSG)
  */

typedef struct {                                    /*!< (@ 0x40020A00) HRPWM0_CSG Structure                                   */
  __IO uint32_t  DCI;                               /*!< (@ 0x40020A00) External input selection                               */
  __IO uint32_t  IES;                               /*!< (@ 0x40020A04) External input selection                               */
  __IO uint32_t  SC;                                /*!< (@ 0x40020A08) Slope generation control                               */
  __I  uint32_t  PC;                                /*!< (@ 0x40020A0C) Pulse swallow configuration                            */
  __I  uint32_t  DSV1;                              /*!< (@ 0x40020A10) DAC reference value 1                                  */
  __IO uint32_t  DSV2;                              /*!< (@ 0x40020A14) DAC reference value 1                                  */
  __IO uint32_t  SDSV1;                             /*!< (@ 0x40020A18) Shadow reference value 1                               */
  __IO uint32_t  SPC;                               /*!< (@ 0x40020A1C) Shadow Pulse swallow value                             */
  __IO uint32_t  CC;                                /*!< (@ 0x40020A20) Comparator configuration                               */
  __IO uint32_t  PLC;                               /*!< (@ 0x40020A24) Passive level configuration                            */
  __IO uint32_t  BLV;                               /*!< (@ 0x40020A28) Comparator blanking value                              */
  __IO uint32_t  SRE;                               /*!< (@ 0x40020A2C) Service request enable                                 */
  __IO uint32_t  SRS;                               /*!< (@ 0x40020A30) Service request line selector                          */
  __O  uint32_t  SWS;                               /*!< (@ 0x40020A34) Service request SW set                                 */
  __O  uint32_t  SWC;                               /*!< (@ 0x40020A38) Service request SW clear                               */
  __I  uint32_t  ISTAT;                             /*!< (@ 0x40020A3C) Service request status                                 */
} HRPWM0_CSG_Type;


/* ================================================================================ */
/* ================            HRPWM0_HRC [HRPWM0_HRC0]            ================ */
/* ================================================================================ */


/**
  * @brief High Resolution PWM Unit (HRPWM0_HRC)
  */

typedef struct {                                    /*!< (@ 0x40021300) HRPWM0_HRC Structure                                   */
  __IO uint32_t  GC;                                /*!< (@ 0x40021300) HRC mode configuration                                 */
  __IO uint32_t  PL;                                /*!< (@ 0x40021304) HRC output passive level                               */
  __IO uint32_t  GSEL;                              /*!< (@ 0x40021308) HRC global control selection                           */
  __IO uint32_t  TSEL;                              /*!< (@ 0x4002130C) HRC timer selection                                    */
  __I  uint32_t  SC;                                /*!< (@ 0x40021310) HRC current source for shadow                          */
  __I  uint32_t  DCR;                               /*!< (@ 0x40021314) HRC dead time rising value                             */
  __I  uint32_t  DCF;                               /*!< (@ 0x40021318) HRC dead time falling value                            */
  __I  uint32_t  CR1;                               /*!< (@ 0x4002131C) HRC rising edge value                                  */
  __I  uint32_t  CR2;                               /*!< (@ 0x40021320) HRC falling edge value                                 */
  __IO uint32_t  SSC;                               /*!< (@ 0x40021324) HRC next source for shadow                             */
  __IO uint32_t  SDCR;                              /*!< (@ 0x40021328) HRC shadow dead time rising                            */
  __IO uint32_t  SDCF;                              /*!< (@ 0x4002132C) HRC shadow dead time falling                           */
  __IO uint32_t  SCR1;                              /*!< (@ 0x40021330) HRC shadow rising edge value                           */
  __IO uint32_t  SCR2;                              /*!< (@ 0x40021334) HRC shadow falling edge value                          */
} HRPWM0_HRC_Type;


/* ================================================================================ */
/* ================                 POSIF [POSIF0]                 ================ */
/* ================================================================================ */


/**
  * @brief Position Interface 0 (POSIF)
  */

typedef struct {                                    /*!< (@ 0x40028000) POSIF Structure                                        */
  __IO uint32_t  PCONF;                             /*!< (@ 0x40028000) Service Request Processing configuration               */
  __IO uint32_t  PSUS;                              /*!< (@ 0x40028004) Service Request Processing Suspend Config              */
  __O  uint32_t  PRUNS;                             /*!< (@ 0x40028008) Service Request Processing Run Bit Set                 */
  __O  uint32_t  PRUNC;                             /*!< (@ 0x4002800C) Service Request Processing Run Bit Clear               */
  __I  uint32_t  PRUN;                              /*!< (@ 0x40028010) Service Request Processing Run Bit Status              */
  __I  uint32_t  RESERVED[3];
  __I  uint32_t  MIDR;                              /*!< (@ 0x40028020) Module Identification register                         */
  __I  uint32_t  RESERVED1[3];
  __I  uint32_t  HALP;                              /*!< (@ 0x40028030) Hall Sensor Patterns                                   */
  __IO uint32_t  HALPS;                             /*!< (@ 0x40028034) Hall Sensor Shadow Patterns                            */
  __I  uint32_t  RESERVED2[2];
  __I  uint32_t  MCM;                               /*!< (@ 0x40028040) Multi-Channel Pattern                                  */
  __IO uint32_t  MCSM;                              /*!< (@ 0x40028044) Multi-Channel Shadow Pattern                           */
  __O  uint32_t  MCMS;                              /*!< (@ 0x40028048) Multi-Channel Pattern Control set                      */
  __O  uint32_t  MCMC;                              /*!< (@ 0x4002804C) Multi-Channel Pattern Control clear                    */
  __I  uint32_t  MCMF;                              /*!< (@ 0x40028050) Multi-Channel Pattern Control flag                     */
  __I  uint32_t  RESERVED3[3];
  __IO uint32_t  QDC;                               /*!< (@ 0x40028060) Quadrature Decoder Control                             */
  __I  uint32_t  RESERVED4[3];
  __I  uint32_t  PFLG;                              /*!< (@ 0x40028070) Service Request Processing Interrupt Flags             */
  __IO uint32_t  PFLGE;                             /*!< (@ 0x40028074) Service Request Processing Interrupt Enable            */
  __O  uint32_t  SPFLG;                             /*!< (@ 0x40028078) Service Request Processing Interrupt Set               */
  __O  uint32_t  RPFLG;                             /*!< (@ 0x4002807C) Service Request Processing Interrupt Clear             */
  __I  uint32_t  RESERVED5[32];
  __I  uint32_t  PDBG;                              /*!< (@ 0x40028100) POSIF Debug register                                   */
} POSIF_GLOBAL_TypeDef;


/* ================================================================================ */
/* ================                      PORT0                     ================ */
/* ================================================================================ */


/**
  * @brief Port 0 (PORT0)
  */

typedef struct {                                    /*!< (@ 0x48028000) PORT0 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028000) Port 0 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028004) Port 0 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028010) Port 0 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028014) Port 0 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028018) Port 0 Input/Output Control Register 8                 */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x4802801C) Port 0 Input/Output Control Register 12                */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028024) Port 0 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028040) Port 0 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028044) Port 0 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028060) Port 0 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028070) Port 0 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028074) Port 0 Pin Hardware Select Register                    */
} PORT0_Type;


/* ================================================================================ */
/* ================                      PORT1                     ================ */
/* ================================================================================ */


/**
  * @brief Port 1 (PORT1)
  */

typedef struct {                                    /*!< (@ 0x48028100) PORT1 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028100) Port 1 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028104) Port 1 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028110) Port 1 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028114) Port 1 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028118) Port 1 Input/Output Control Register 8                 */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x4802811C) Port 1 Input/Output Control Register 12                */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028124) Port 1 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028140) Port 1 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028144) Port 1 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028160) Port 1 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028170) Port 1 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028174) Port 1 Pin Hardware Select Register                    */
} PORT1_Type;


/* ================================================================================ */
/* ================                      PORT2                     ================ */
/* ================================================================================ */


/**
  * @brief Port 2 (PORT2)
  */

typedef struct {                                    /*!< (@ 0x48028200) PORT2 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028200) Port 2 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028204) Port 2 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028210) Port 2 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028214) Port 2 Input/Output Control Register 4                 */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028218) Port 2 Input/Output Control Register 8                 */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x4802821C) Port 2 Input/Output Control Register 12                */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028224) Port 2 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028240) Port 2 Pad Driver Mode 0 Register                      */
  __IO uint32_t  PDR1;                              /*!< (@ 0x48028244) Port 2 Pad Driver Mode 1 Register                      */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028260) Port 2 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028270) Port 2 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028274) Port 2 Pin Hardware Select Register                    */
} PORT2_Type;


/* ================================================================================ */
/* ================                      PORT3                     ================ */
/* ================================================================================ */


/**
  * @brief Port 3 (PORT3)
  */

typedef struct {                                    /*!< (@ 0x48028300) PORT3 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028300) Port 3 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028304) Port 3 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028310) Port 3 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028314) Port 3 Input/Output Control Register 4                 */
  __I  uint32_t  RESERVED1[3];
  __I  uint32_t  IN;                                /*!< (@ 0x48028324) Port 3 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028340) Port 3 Pad Driver Mode 0 Register                      */
  __I  uint32_t  RESERVED3[7];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028360) Port 3 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028370) Port 3 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028374) Port 3 Pin Hardware Select Register                    */
} PORT3_Type;


/* ================================================================================ */
/* ================                      PORT4                     ================ */
/* ================================================================================ */


/**
  * @brief Port 4 (PORT4)
  */

typedef struct {                                    /*!< (@ 0x48028400) PORT4 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028400) Port 4 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028404) Port 4 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028410) Port 4 Input/Output Control Register 0                 */
  __I  uint32_t  RESERVED1[4];
  __I  uint32_t  IN;                                /*!< (@ 0x48028424) Port 4 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028440) Port 4 Pad Driver Mode 0 Register                      */
  __I  uint32_t  RESERVED3[7];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028460) Port 4 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028470) Port 4 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028474) Port 4 Pin Hardware Select Register                    */
} PORT4_Type;


/* ================================================================================ */
/* ================                      PORT5                     ================ */
/* ================================================================================ */


/**
  * @brief Port 5 (PORT5)
  */

typedef struct {                                    /*!< (@ 0x48028500) PORT5 Structure                                        */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028500) Port 5 Output Register                                 */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028504) Port 5 Output Modification Register                    */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028510) Port 5 Input/Output Control Register 0                 */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028514) Port 5 Input/Output Control Register 4                 */
  __I  uint32_t  RESERVED1[3];
  __I  uint32_t  IN;                                /*!< (@ 0x48028524) Port 5 Input Register                                  */
  __I  uint32_t  RESERVED2[6];
  __IO uint32_t  PDR0;                              /*!< (@ 0x48028540) Port 5 Pad Driver Mode 0 Register                      */
  __I  uint32_t  RESERVED3[7];
  __I  uint32_t  PDISC;                             /*!< (@ 0x48028560) Port 5 Pin Function Decision Control Register          */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028570) Port 5 Pin Power Save Register                         */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028574) Port 5 Pin Hardware Select Register                    */
} PORT5_Type;


/* ================================================================================ */
/* ================                     PORT14                     ================ */
/* ================================================================================ */


/**
  * @brief Port 14 (PORT14)
  */

typedef struct {                                    /*!< (@ 0x48028E00) PORT14 Structure                                       */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028E00) Port 14 Output Register                                */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028E04) Port 14 Output Modification Register                   */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028E10) Port 14 Input/Output Control Register 0                */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028E14) Port 14 Input/Output Control Register 4                */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028E18) Port 14 Input/Output Control Register 8                */
  __IO uint32_t  IOCR12;                            /*!< (@ 0x48028E1C) Port 14 Input/Output Control Register 12               */
  __I  uint32_t  RESERVED1;
  __I  uint32_t  IN;                                /*!< (@ 0x48028E24) Port 14 Input Register                                 */
  __I  uint32_t  RESERVED2[14];
  __IO uint32_t  PDISC;                             /*!< (@ 0x48028E60) Port 14 Pin Function Decision Control Register         */
  __I  uint32_t  RESERVED3[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028E70) Port 14 Pin Power Save Register                        */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028E74) Port 14 Pin Hardware Select Register                   */
} PORT14_Type;


/* ================================================================================ */
/* ================                     PORT15                     ================ */
/* ================================================================================ */


/**
  * @brief Port 15 (PORT15)
  */

typedef struct {                                    /*!< (@ 0x48028F00) PORT15 Structure                                       */
  __IO uint32_t  OUT;                               /*!< (@ 0x48028F00) Port 15 Output Register                                */
  __O  uint32_t  OMR;                               /*!< (@ 0x48028F04) Port 15 Output Modification Register                   */
  __I  uint32_t  RESERVED[2];
  __IO uint32_t  IOCR0;                             /*!< (@ 0x48028F10) Port 15 Input/Output Control Register 0                */
  __IO uint32_t  IOCR4;                             /*!< (@ 0x48028F14) Port 15 Input/Output Control Register 4                */
  __IO uint32_t  IOCR8;                             /*!< (@ 0x48028F18) Port 15 Input/Output Control Register 8                */
  __I  uint32_t  RESERVED1[2];
  __I  uint32_t  IN;                                /*!< (@ 0x48028F24) Port 15 Input Register                                 */
  __I  uint32_t  RESERVED2[14];
  __IO uint32_t  PDISC;                             /*!< (@ 0x48028F60) Port 15 Pin Function Decision Control Register         */
  __I  uint32_t  RESERVED3[3];
  __IO uint32_t  PPS;                               /*!< (@ 0x48028F70) Port 15 Pin Power Save Register                        */
  __IO uint32_t  HWSEL;                             /*!< (@ 0x48028F74) Port 15 Pin Hardware Select Register                   */
} PORT15_Type;


/* --------------------  End of section using anonymous unions  ------------------- */
#if defined(__CC_ARM)
  #pragma pop
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined(__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined(__TASKING__)
  #pragma warning restore
#else
  #warning Not supported compiler type
#endif



/* ================================================================================ */
/* ================          struct 'PPB' Position & Mask          ================ */
/* ================================================================================ */


/* ----------------------------------  PPB_ACTLR  --------------------------------- */
#define PPB_ACTLR_DISMCYCINT_Pos              (0UL)                     /*!< PPB ACTLR: DISMCYCINT (Bit 0)                               */
#define PPB_ACTLR_DISMCYCINT_Msk              (0x1UL)                   /*!< PPB ACTLR: DISMCYCINT (Bitfield-Mask: 0x01)                 */
#define PPB_ACTLR_DISDEFWBUF_Pos              (1UL)                     /*!< PPB ACTLR: DISDEFWBUF (Bit 1)                               */
#define PPB_ACTLR_DISDEFWBUF_Msk              (0x2UL)                   /*!< PPB ACTLR: DISDEFWBUF (Bitfield-Mask: 0x01)                 */
#define PPB_ACTLR_DISFOLD_Pos                 (2UL)                     /*!< PPB ACTLR: DISFOLD (Bit 2)                                  */
#define PPB_ACTLR_DISFOLD_Msk                 (0x4UL)                   /*!< PPB ACTLR: DISFOLD (Bitfield-Mask: 0x01)                    */
#define PPB_ACTLR_DISFPCA_Pos                 (8UL)                     /*!< PPB ACTLR: DISFPCA (Bit 8)                                  */
#define PPB_ACTLR_DISFPCA_Msk                 (0x100UL)                 /*!< PPB ACTLR: DISFPCA (Bitfield-Mask: 0x01)                    */
#define PPB_ACTLR_DISOOFP_Pos                 (9UL)                     /*!< PPB ACTLR: DISOOFP (Bit 9)                                  */
#define PPB_ACTLR_DISOOFP_Msk                 (0x200UL)                 /*!< PPB ACTLR: DISOOFP (Bitfield-Mask: 0x01)                    */

/* --------------------------------  PPB_SYST_CSR  -------------------------------- */
#define PPB_SYST_CSR_ENABLE_Pos               (0UL)                     /*!< PPB SYST_CSR: ENABLE (Bit 0)                                */
#define PPB_SYST_CSR_ENABLE_Msk               (0x1UL)                   /*!< PPB SYST_CSR: ENABLE (Bitfield-Mask: 0x01)                  */
#define PPB_SYST_CSR_TICKINT_Pos              (1UL)                     /*!< PPB SYST_CSR: TICKINT (Bit 1)                               */
#define PPB_SYST_CSR_TICKINT_Msk              (0x2UL)                   /*!< PPB SYST_CSR: TICKINT (Bitfield-Mask: 0x01)                 */
#define PPB_SYST_CSR_CLKSOURCE_Pos            (2UL)                     /*!< PPB SYST_CSR: CLKSOURCE (Bit 2)                             */
#define PPB_SYST_CSR_CLKSOURCE_Msk            (0x4UL)                   /*!< PPB SYST_CSR: CLKSOURCE (Bitfield-Mask: 0x01)               */
#define PPB_SYST_CSR_COUNTFLAG_Pos            (16UL)                    /*!< PPB SYST_CSR: COUNTFLAG (Bit 16)                            */
#define PPB_SYST_CSR_COUNTFLAG_Msk            (0x10000UL)               /*!< PPB SYST_CSR: COUNTFLAG (Bitfield-Mask: 0x01)               */

/* --------------------------------  PPB_SYST_RVR  -------------------------------- */
#define PPB_SYST_RVR_RELOAD_Pos               (0UL)                     /*!< PPB SYST_RVR: RELOAD (Bit 0)                                */
#define PPB_SYST_RVR_RELOAD_Msk               (0xffffffUL)              /*!< PPB SYST_RVR: RELOAD (Bitfield-Mask: 0xffffff)              */

/* --------------------------------  PPB_SYST_CVR  -------------------------------- */
#define PPB_SYST_CVR_CURRENT_Pos              (0UL)                     /*!< PPB SYST_CVR: CURRENT (Bit 0)                               */
#define PPB_SYST_CVR_CURRENT_Msk              (0xffffffUL)              /*!< PPB SYST_CVR: CURRENT (Bitfield-Mask: 0xffffff)             */

/* -------------------------------  PPB_SYST_CALIB  ------------------------------- */
#define PPB_SYST_CALIB_TENMS_Pos              (0UL)                     /*!< PPB SYST_CALIB: TENMS (Bit 0)                               */
#define PPB_SYST_CALIB_TENMS_Msk              (0xffffffUL)              /*!< PPB SYST_CALIB: TENMS (Bitfield-Mask: 0xffffff)             */
#define PPB_SYST_CALIB_SKEW_Pos               (30UL)                    /*!< PPB SYST_CALIB: SKEW (Bit 30)                               */
#define PPB_SYST_CALIB_SKEW_Msk               (0x40000000UL)            /*!< PPB SYST_CALIB: SKEW (Bitfield-Mask: 0x01)                  */
#define PPB_SYST_CALIB_NOREF_Pos              (31UL)                    /*!< PPB SYST_CALIB: NOREF (Bit 31)                              */
#define PPB_SYST_CALIB_NOREF_Msk              (0x80000000UL)            /*!< PPB SYST_CALIB: NOREF (Bitfield-Mask: 0x01)                 */

/* -------------------------------  PPB_NVIC_ISER0  ------------------------------- */
#define PPB_NVIC_ISER0_SETENA_Pos             (0UL)                     /*!< PPB NVIC_ISER0: SETENA (Bit 0)                              */
#define PPB_NVIC_ISER0_SETENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ISER0: SETENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ISER1  ------------------------------- */
#define PPB_NVIC_ISER1_SETENA_Pos             (0UL)                     /*!< PPB NVIC_ISER1: SETENA (Bit 0)                              */
#define PPB_NVIC_ISER1_SETENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ISER1: SETENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ISER2  ------------------------------- */
#define PPB_NVIC_ISER2_SETENA_Pos             (0UL)                     /*!< PPB NVIC_ISER2: SETENA (Bit 0)                              */
#define PPB_NVIC_ISER2_SETENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ISER2: SETENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ISER3  ------------------------------- */
#define PPB_NVIC_ISER3_SETENA_Pos             (0UL)                     /*!< PPB NVIC_ISER3: SETENA (Bit 0)                              */
#define PPB_NVIC_ISER3_SETENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ISER3: SETENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ICER0  ------------------------------- */
#define PPB_NVIC_ICER0_CLRENA_Pos             (0UL)                     /*!< PPB NVIC_ICER0: CLRENA (Bit 0)                              */
#define PPB_NVIC_ICER0_CLRENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ICER0: CLRENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ICER1  ------------------------------- */
#define PPB_NVIC_ICER1_CLRENA_Pos             (0UL)                     /*!< PPB NVIC_ICER1: CLRENA (Bit 0)                              */
#define PPB_NVIC_ICER1_CLRENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ICER1: CLRENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ICER2  ------------------------------- */
#define PPB_NVIC_ICER2_CLRENA_Pos             (0UL)                     /*!< PPB NVIC_ICER2: CLRENA (Bit 0)                              */
#define PPB_NVIC_ICER2_CLRENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ICER2: CLRENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ICER3  ------------------------------- */
#define PPB_NVIC_ICER3_CLRENA_Pos             (0UL)                     /*!< PPB NVIC_ICER3: CLRENA (Bit 0)                              */
#define PPB_NVIC_ICER3_CLRENA_Msk             (0xffffffffUL)            /*!< PPB NVIC_ICER3: CLRENA (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_ISPR0  ------------------------------- */
#define PPB_NVIC_ISPR0_SETPEND_Pos            (0UL)                     /*!< PPB NVIC_ISPR0: SETPEND (Bit 0)                             */
#define PPB_NVIC_ISPR0_SETPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ISPR0: SETPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_ISPR1  ------------------------------- */
#define PPB_NVIC_ISPR1_SETPEND_Pos            (0UL)                     /*!< PPB NVIC_ISPR1: SETPEND (Bit 0)                             */
#define PPB_NVIC_ISPR1_SETPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ISPR1: SETPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_ISPR2  ------------------------------- */
#define PPB_NVIC_ISPR2_SETPEND_Pos            (0UL)                     /*!< PPB NVIC_ISPR2: SETPEND (Bit 0)                             */
#define PPB_NVIC_ISPR2_SETPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ISPR2: SETPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_ISPR3  ------------------------------- */
#define PPB_NVIC_ISPR3_SETPEND_Pos            (0UL)                     /*!< PPB NVIC_ISPR3: SETPEND (Bit 0)                             */
#define PPB_NVIC_ISPR3_SETPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ISPR3: SETPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_ICPR0  ------------------------------- */
#define PPB_NVIC_ICPR0_CLRPEND_Pos            (0UL)                     /*!< PPB NVIC_ICPR0: CLRPEND (Bit 0)                             */
#define PPB_NVIC_ICPR0_CLRPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ICPR0: CLRPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_ICPR1  ------------------------------- */
#define PPB_NVIC_ICPR1_CLRPEND_Pos            (0UL)                     /*!< PPB NVIC_ICPR1: CLRPEND (Bit 0)                             */
#define PPB_NVIC_ICPR1_CLRPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ICPR1: CLRPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_ICPR2  ------------------------------- */
#define PPB_NVIC_ICPR2_CLRPEND_Pos            (0UL)                     /*!< PPB NVIC_ICPR2: CLRPEND (Bit 0)                             */
#define PPB_NVIC_ICPR2_CLRPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ICPR2: CLRPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_ICPR3  ------------------------------- */
#define PPB_NVIC_ICPR3_CLRPEND_Pos            (0UL)                     /*!< PPB NVIC_ICPR3: CLRPEND (Bit 0)                             */
#define PPB_NVIC_ICPR3_CLRPEND_Msk            (0xffffffffUL)            /*!< PPB NVIC_ICPR3: CLRPEND (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  PPB_NVIC_IABR0  ------------------------------- */
#define PPB_NVIC_IABR0_ACTIVE_Pos             (0UL)                     /*!< PPB NVIC_IABR0: ACTIVE (Bit 0)                              */
#define PPB_NVIC_IABR0_ACTIVE_Msk             (0xffffffffUL)            /*!< PPB NVIC_IABR0: ACTIVE (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_IABR1  ------------------------------- */
#define PPB_NVIC_IABR1_ACTIVE_Pos             (0UL)                     /*!< PPB NVIC_IABR1: ACTIVE (Bit 0)                              */
#define PPB_NVIC_IABR1_ACTIVE_Msk             (0xffffffffUL)            /*!< PPB NVIC_IABR1: ACTIVE (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_IABR2  ------------------------------- */
#define PPB_NVIC_IABR2_ACTIVE_Pos             (0UL)                     /*!< PPB NVIC_IABR2: ACTIVE (Bit 0)                              */
#define PPB_NVIC_IABR2_ACTIVE_Msk             (0xffffffffUL)            /*!< PPB NVIC_IABR2: ACTIVE (Bitfield-Mask: 0xffffffff)          */

/* -------------------------------  PPB_NVIC_IABR3  ------------------------------- */
#define PPB_NVIC_IABR3_ACTIVE_Pos             (0UL)                     /*!< PPB NVIC_IABR3: ACTIVE (Bit 0)                              */
#define PPB_NVIC_IABR3_ACTIVE_Msk             (0xffffffffUL)            /*!< PPB NVIC_IABR3: ACTIVE (Bitfield-Mask: 0xffffffff)          */

/* --------------------------------  PPB_NVIC_IPR0  ------------------------------- */
#define PPB_NVIC_IPR0_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR0: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR0_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR0: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR0_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR0: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR0_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR0: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR0_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR0: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR0_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR0: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR0_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR0: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR0_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR0: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR1  ------------------------------- */
#define PPB_NVIC_IPR1_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR1: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR1_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR1: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR1_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR1: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR1_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR1: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR1_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR1: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR1_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR1: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR1_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR1: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR1_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR1: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR2  ------------------------------- */
#define PPB_NVIC_IPR2_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR2: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR2_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR2: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR2_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR2: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR2_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR2: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR2_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR2: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR2_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR2: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR2_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR2: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR2_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR2: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR3  ------------------------------- */
#define PPB_NVIC_IPR3_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR3: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR3_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR3: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR3_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR3: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR3_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR3: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR3_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR3: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR3_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR3: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR3_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR3: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR3_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR3: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR4  ------------------------------- */
#define PPB_NVIC_IPR4_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR4: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR4_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR4: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR4_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR4: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR4_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR4: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR4_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR4: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR4_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR4: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR4_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR4: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR4_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR4: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR5  ------------------------------- */
#define PPB_NVIC_IPR5_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR5: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR5_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR5: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR5_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR5: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR5_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR5: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR5_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR5: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR5_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR5: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR5_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR5: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR5_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR5: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR6  ------------------------------- */
#define PPB_NVIC_IPR6_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR6: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR6_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR6: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR6_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR6: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR6_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR6: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR6_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR6: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR6_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR6: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR6_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR6: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR6_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR6: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR7  ------------------------------- */
#define PPB_NVIC_IPR7_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR7: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR7_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR7: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR7_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR7: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR7_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR7: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR7_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR7: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR7_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR7: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR7_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR7: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR7_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR7: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR8  ------------------------------- */
#define PPB_NVIC_IPR8_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR8: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR8_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR8: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR8_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR8: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR8_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR8: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR8_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR8: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR8_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR8: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR8_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR8: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR8_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR8: PRI_3 (Bitfield-Mask: 0xff)                  */

/* --------------------------------  PPB_NVIC_IPR9  ------------------------------- */
#define PPB_NVIC_IPR9_PRI_0_Pos               (0UL)                     /*!< PPB NVIC_IPR9: PRI_0 (Bit 0)                                */
#define PPB_NVIC_IPR9_PRI_0_Msk               (0xffUL)                  /*!< PPB NVIC_IPR9: PRI_0 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR9_PRI_1_Pos               (8UL)                     /*!< PPB NVIC_IPR9: PRI_1 (Bit 8)                                */
#define PPB_NVIC_IPR9_PRI_1_Msk               (0xff00UL)                /*!< PPB NVIC_IPR9: PRI_1 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR9_PRI_2_Pos               (16UL)                    /*!< PPB NVIC_IPR9: PRI_2 (Bit 16)                               */
#define PPB_NVIC_IPR9_PRI_2_Msk               (0xff0000UL)              /*!< PPB NVIC_IPR9: PRI_2 (Bitfield-Mask: 0xff)                  */
#define PPB_NVIC_IPR9_PRI_3_Pos               (24UL)                    /*!< PPB NVIC_IPR9: PRI_3 (Bit 24)                               */
#define PPB_NVIC_IPR9_PRI_3_Msk               (0xff000000UL)            /*!< PPB NVIC_IPR9: PRI_3 (Bitfield-Mask: 0xff)                  */

/* -------------------------------  PPB_NVIC_IPR10  ------------------------------- */
#define PPB_NVIC_IPR10_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR10: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR10_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR10: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR10_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR10: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR10_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR10: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR10_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR10: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR10_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR10: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR10_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR10: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR10_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR10: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR11  ------------------------------- */
#define PPB_NVIC_IPR11_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR11: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR11_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR11: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR11_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR11: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR11_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR11: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR11_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR11: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR11_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR11: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR11_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR11: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR11_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR11: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR12  ------------------------------- */
#define PPB_NVIC_IPR12_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR12: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR12_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR12: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR12_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR12: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR12_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR12: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR12_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR12: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR12_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR12: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR12_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR12: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR12_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR12: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR13  ------------------------------- */
#define PPB_NVIC_IPR13_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR13: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR13_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR13: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR13_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR13: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR13_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR13: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR13_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR13: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR13_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR13: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR13_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR13: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR13_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR13: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR14  ------------------------------- */
#define PPB_NVIC_IPR14_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR14: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR14_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR14: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR14_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR14: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR14_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR14: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR14_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR14: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR14_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR14: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR14_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR14: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR14_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR14: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR15  ------------------------------- */
#define PPB_NVIC_IPR15_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR15: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR15_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR15: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR15_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR15: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR15_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR15: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR15_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR15: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR15_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR15: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR15_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR15: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR15_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR15: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR16  ------------------------------- */
#define PPB_NVIC_IPR16_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR16: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR16_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR16: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR16_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR16: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR16_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR16: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR16_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR16: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR16_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR16: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR16_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR16: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR16_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR16: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR17  ------------------------------- */
#define PPB_NVIC_IPR17_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR17: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR17_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR17: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR17_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR17: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR17_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR17: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR17_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR17: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR17_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR17: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR17_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR17: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR17_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR17: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR18  ------------------------------- */
#define PPB_NVIC_IPR18_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR18: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR18_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR18: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR18_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR18: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR18_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR18: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR18_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR18: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR18_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR18: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR18_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR18: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR18_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR18: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR19  ------------------------------- */
#define PPB_NVIC_IPR19_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR19: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR19_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR19: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR19_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR19: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR19_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR19: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR19_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR19: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR19_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR19: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR19_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR19: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR19_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR19: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR20  ------------------------------- */
#define PPB_NVIC_IPR20_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR20: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR20_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR20: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR20_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR20: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR20_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR20: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR20_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR20: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR20_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR20: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR20_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR20: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR20_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR20: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR21  ------------------------------- */
#define PPB_NVIC_IPR21_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR21: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR21_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR21: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR21_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR21: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR21_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR21: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR21_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR21: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR21_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR21: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR21_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR21: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR21_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR21: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR22  ------------------------------- */
#define PPB_NVIC_IPR22_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR22: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR22_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR22: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR22_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR22: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR22_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR22: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR22_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR22: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR22_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR22: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR22_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR22: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR22_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR22: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR23  ------------------------------- */
#define PPB_NVIC_IPR23_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR23: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR23_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR23: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR23_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR23: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR23_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR23: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR23_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR23: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR23_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR23: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR23_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR23: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR23_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR23: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR24  ------------------------------- */
#define PPB_NVIC_IPR24_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR24: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR24_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR24: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR24_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR24: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR24_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR24: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR24_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR24: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR24_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR24: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR24_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR24: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR24_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR24: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR25  ------------------------------- */
#define PPB_NVIC_IPR25_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR25: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR25_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR25: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR25_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR25: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR25_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR25: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR25_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR25: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR25_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR25: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR25_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR25: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR25_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR25: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR26  ------------------------------- */
#define PPB_NVIC_IPR26_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR26: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR26_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR26: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR26_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR26: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR26_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR26: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR26_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR26: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR26_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR26: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR26_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR26: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR26_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR26: PRI_3 (Bitfield-Mask: 0xff)                 */

/* -------------------------------  PPB_NVIC_IPR27  ------------------------------- */
#define PPB_NVIC_IPR27_PRI_0_Pos              (0UL)                     /*!< PPB NVIC_IPR27: PRI_0 (Bit 0)                               */
#define PPB_NVIC_IPR27_PRI_0_Msk              (0xffUL)                  /*!< PPB NVIC_IPR27: PRI_0 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR27_PRI_1_Pos              (8UL)                     /*!< PPB NVIC_IPR27: PRI_1 (Bit 8)                               */
#define PPB_NVIC_IPR27_PRI_1_Msk              (0xff00UL)                /*!< PPB NVIC_IPR27: PRI_1 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR27_PRI_2_Pos              (16UL)                    /*!< PPB NVIC_IPR27: PRI_2 (Bit 16)                              */
#define PPB_NVIC_IPR27_PRI_2_Msk              (0xff0000UL)              /*!< PPB NVIC_IPR27: PRI_2 (Bitfield-Mask: 0xff)                 */
#define PPB_NVIC_IPR27_PRI_3_Pos              (24UL)                    /*!< PPB NVIC_IPR27: PRI_3 (Bit 24)                              */
#define PPB_NVIC_IPR27_PRI_3_Msk              (0xff000000UL)            /*!< PPB NVIC_IPR27: PRI_3 (Bitfield-Mask: 0xff)                 */

/* ----------------------------------  PPB_CPUID  --------------------------------- */
#define PPB_CPUID_Revision_Pos                (0UL)                     /*!< PPB CPUID: Revision (Bit 0)                                 */
#define PPB_CPUID_Revision_Msk                (0xfUL)                   /*!< PPB CPUID: Revision (Bitfield-Mask: 0x0f)                   */
#define PPB_CPUID_PartNo_Pos                  (4UL)                     /*!< PPB CPUID: PartNo (Bit 4)                                   */
#define PPB_CPUID_PartNo_Msk                  (0xfff0UL)                /*!< PPB CPUID: PartNo (Bitfield-Mask: 0xfff)                    */
#define PPB_CPUID_Constant_Pos                (16UL)                    /*!< PPB CPUID: Constant (Bit 16)                                */
#define PPB_CPUID_Constant_Msk                (0xf0000UL)               /*!< PPB CPUID: Constant (Bitfield-Mask: 0x0f)                   */
#define PPB_CPUID_Variant_Pos                 (20UL)                    /*!< PPB CPUID: Variant (Bit 20)                                 */
#define PPB_CPUID_Variant_Msk                 (0xf00000UL)              /*!< PPB CPUID: Variant (Bitfield-Mask: 0x0f)                    */
#define PPB_CPUID_Implementer_Pos             (24UL)                    /*!< PPB CPUID: Implementer (Bit 24)                             */
#define PPB_CPUID_Implementer_Msk             (0xff000000UL)            /*!< PPB CPUID: Implementer (Bitfield-Mask: 0xff)                */

/* ----------------------------------  PPB_ICSR  ---------------------------------- */
#define PPB_ICSR_VECTACTIVE_Pos               (0UL)                     /*!< PPB ICSR: VECTACTIVE (Bit 0)                                */
#define PPB_ICSR_VECTACTIVE_Msk               (0x1ffUL)                 /*!< PPB ICSR: VECTACTIVE (Bitfield-Mask: 0x1ff)                 */
#define PPB_ICSR_RETTOBASE_Pos                (11UL)                    /*!< PPB ICSR: RETTOBASE (Bit 11)                                */
#define PPB_ICSR_RETTOBASE_Msk                (0x800UL)                 /*!< PPB ICSR: RETTOBASE (Bitfield-Mask: 0x01)                   */
#define PPB_ICSR_VECTPENDING_Pos              (12UL)                    /*!< PPB ICSR: VECTPENDING (Bit 12)                              */
#define PPB_ICSR_VECTPENDING_Msk              (0x3f000UL)               /*!< PPB ICSR: VECTPENDING (Bitfield-Mask: 0x3f)                 */
#define PPB_ICSR_ISRPENDING_Pos               (22UL)                    /*!< PPB ICSR: ISRPENDING (Bit 22)                               */
#define PPB_ICSR_ISRPENDING_Msk               (0x400000UL)              /*!< PPB ICSR: ISRPENDING (Bitfield-Mask: 0x01)                  */
#define PPB_ICSR_PENDSTCLR_Pos                (25UL)                    /*!< PPB ICSR: PENDSTCLR (Bit 25)                                */
#define PPB_ICSR_PENDSTCLR_Msk                (0x2000000UL)             /*!< PPB ICSR: PENDSTCLR (Bitfield-Mask: 0x01)                   */
#define PPB_ICSR_PENDSTSET_Pos                (26UL)                    /*!< PPB ICSR: PENDSTSET (Bit 26)                                */
#define PPB_ICSR_PENDSTSET_Msk                (0x4000000UL)             /*!< PPB ICSR: PENDSTSET (Bitfield-Mask: 0x01)                   */
#define PPB_ICSR_PENDSVCLR_Pos                (27UL)                    /*!< PPB ICSR: PENDSVCLR (Bit 27)                                */
#define PPB_ICSR_PENDSVCLR_Msk                (0x8000000UL)             /*!< PPB ICSR: PENDSVCLR (Bitfield-Mask: 0x01)                   */
#define PPB_ICSR_PENDSVSET_Pos                (28UL)                    /*!< PPB ICSR: PENDSVSET (Bit 28)                                */
#define PPB_ICSR_PENDSVSET_Msk                (0x10000000UL)            /*!< PPB ICSR: PENDSVSET (Bitfield-Mask: 0x01)                   */
#define PPB_ICSR_NMIPENDSET_Pos               (31UL)                    /*!< PPB ICSR: NMIPENDSET (Bit 31)                               */
#define PPB_ICSR_NMIPENDSET_Msk               (0x80000000UL)            /*!< PPB ICSR: NMIPENDSET (Bitfield-Mask: 0x01)                  */

/* ----------------------------------  PPB_VTOR  ---------------------------------- */
#define PPB_VTOR_TBLOFF_Pos                   (10UL)                    /*!< PPB VTOR: TBLOFF (Bit 10)                                   */
#define PPB_VTOR_TBLOFF_Msk                   (0xfffffc00UL)            /*!< PPB VTOR: TBLOFF (Bitfield-Mask: 0x3fffff)                  */

/* ----------------------------------  PPB_AIRCR  --------------------------------- */
#define PPB_AIRCR_VECTRESET_Pos               (0UL)                     /*!< PPB AIRCR: VECTRESET (Bit 0)                                */
#define PPB_AIRCR_VECTRESET_Msk               (0x1UL)                   /*!< PPB AIRCR: VECTRESET (Bitfield-Mask: 0x01)                  */
#define PPB_AIRCR_VECTCLRACTIVE_Pos           (1UL)                     /*!< PPB AIRCR: VECTCLRACTIVE (Bit 1)                            */
#define PPB_AIRCR_VECTCLRACTIVE_Msk           (0x2UL)                   /*!< PPB AIRCR: VECTCLRACTIVE (Bitfield-Mask: 0x01)              */
#define PPB_AIRCR_SYSRESETREQ_Pos             (2UL)                     /*!< PPB AIRCR: SYSRESETREQ (Bit 2)                              */
#define PPB_AIRCR_SYSRESETREQ_Msk             (0x4UL)                   /*!< PPB AIRCR: SYSRESETREQ (Bitfield-Mask: 0x01)                */
#define PPB_AIRCR_PRIGROUP_Pos                (8UL)                     /*!< PPB AIRCR: PRIGROUP (Bit 8)                                 */
#define PPB_AIRCR_PRIGROUP_Msk                (0x700UL)                 /*!< PPB AIRCR: PRIGROUP (Bitfield-Mask: 0x07)                   */
#define PPB_AIRCR_ENDIANNESS_Pos              (15UL)                    /*!< PPB AIRCR: ENDIANNESS (Bit 15)                              */
#define PPB_AIRCR_ENDIANNESS_Msk              (0x8000UL)                /*!< PPB AIRCR: ENDIANNESS (Bitfield-Mask: 0x01)                 */
#define PPB_AIRCR_VECTKEY_Pos                 (16UL)                    /*!< PPB AIRCR: VECTKEY (Bit 16)                                 */
#define PPB_AIRCR_VECTKEY_Msk                 (0xffff0000UL)            /*!< PPB AIRCR: VECTKEY (Bitfield-Mask: 0xffff)                  */

/* -----------------------------------  PPB_SCR  ---------------------------------- */
#define PPB_SCR_SLEEPONEXIT_Pos               (1UL)                     /*!< PPB SCR: SLEEPONEXIT (Bit 1)                                */
#define PPB_SCR_SLEEPONEXIT_Msk               (0x2UL)                   /*!< PPB SCR: SLEEPONEXIT (Bitfield-Mask: 0x01)                  */
#define PPB_SCR_SLEEPDEEP_Pos                 (2UL)                     /*!< PPB SCR: SLEEPDEEP (Bit 2)                                  */
#define PPB_SCR_SLEEPDEEP_Msk                 (0x4UL)                   /*!< PPB SCR: SLEEPDEEP (Bitfield-Mask: 0x01)                    */
#define PPB_SCR_SEVONPEND_Pos                 (4UL)                     /*!< PPB SCR: SEVONPEND (Bit 4)                                  */
#define PPB_SCR_SEVONPEND_Msk                 (0x10UL)                  /*!< PPB SCR: SEVONPEND (Bitfield-Mask: 0x01)                    */

/* -----------------------------------  PPB_CCR  ---------------------------------- */
#define PPB_CCR_NONBASETHRDENA_Pos            (0UL)                     /*!< PPB CCR: NONBASETHRDENA (Bit 0)                             */
#define PPB_CCR_NONBASETHRDENA_Msk            (0x1UL)                   /*!< PPB CCR: NONBASETHRDENA (Bitfield-Mask: 0x01)               */
#define PPB_CCR_USERSETMPEND_Pos              (1UL)                     /*!< PPB CCR: USERSETMPEND (Bit 1)                               */
#define PPB_CCR_USERSETMPEND_Msk              (0x2UL)                   /*!< PPB CCR: USERSETMPEND (Bitfield-Mask: 0x01)                 */
#define PPB_CCR_UNALIGN_TRP_Pos               (3UL)                     /*!< PPB CCR: UNALIGN_TRP (Bit 3)                                */
#define PPB_CCR_UNALIGN_TRP_Msk               (0x8UL)                   /*!< PPB CCR: UNALIGN_TRP (Bitfield-Mask: 0x01)                  */
#define PPB_CCR_DIV_0_TRP_Pos                 (4UL)                     /*!< PPB CCR: DIV_0_TRP (Bit 4)                                  */
#define PPB_CCR_DIV_0_TRP_Msk                 (0x10UL)                  /*!< PPB CCR: DIV_0_TRP (Bitfield-Mask: 0x01)                    */
#define PPB_CCR_BFHFNMIGN_Pos                 (8UL)                     /*!< PPB CCR: BFHFNMIGN (Bit 8)                                  */
#define PPB_CCR_BFHFNMIGN_Msk                 (0x100UL)                 /*!< PPB CCR: BFHFNMIGN (Bitfield-Mask: 0x01)                    */
#define PPB_CCR_STKALIGN_Pos                  (9UL)                     /*!< PPB CCR: STKALIGN (Bit 9)                                   */
#define PPB_CCR_STKALIGN_Msk                  (0x200UL)                 /*!< PPB CCR: STKALIGN (Bitfield-Mask: 0x01)                     */

/* ----------------------------------  PPB_SHPR1  --------------------------------- */
#define PPB_SHPR1_PRI_4_Pos                   (0UL)                     /*!< PPB SHPR1: PRI_4 (Bit 0)                                    */
#define PPB_SHPR1_PRI_4_Msk                   (0xffUL)                  /*!< PPB SHPR1: PRI_4 (Bitfield-Mask: 0xff)                      */
#define PPB_SHPR1_PRI_5_Pos                   (8UL)                     /*!< PPB SHPR1: PRI_5 (Bit 8)                                    */
#define PPB_SHPR1_PRI_5_Msk                   (0xff00UL)                /*!< PPB SHPR1: PRI_5 (Bitfield-Mask: 0xff)                      */
#define PPB_SHPR1_PRI_6_Pos                   (16UL)                    /*!< PPB SHPR1: PRI_6 (Bit 16)                                   */
#define PPB_SHPR1_PRI_6_Msk                   (0xff0000UL)              /*!< PPB SHPR1: PRI_6 (Bitfield-Mask: 0xff)                      */

/* ----------------------------------  PPB_SHPR2  --------------------------------- */
#define PPB_SHPR2_PRI_11_Pos                  (24UL)                    /*!< PPB SHPR2: PRI_11 (Bit 24)                                  */
#define PPB_SHPR2_PRI_11_Msk                  (0xff000000UL)            /*!< PPB SHPR2: PRI_11 (Bitfield-Mask: 0xff)                     */

/* ----------------------------------  PPB_SHPR3  --------------------------------- */
#define PPB_SHPR3_PRI_14_Pos                  (16UL)                    /*!< PPB SHPR3: PRI_14 (Bit 16)                                  */
#define PPB_SHPR3_PRI_14_Msk                  (0xff0000UL)              /*!< PPB SHPR3: PRI_14 (Bitfield-Mask: 0xff)                     */
#define PPB_SHPR3_PRI_15_Pos                  (24UL)                    /*!< PPB SHPR3: PRI_15 (Bit 24)                                  */
#define PPB_SHPR3_PRI_15_Msk                  (0xff000000UL)            /*!< PPB SHPR3: PRI_15 (Bitfield-Mask: 0xff)                     */

/* ----------------------------------  PPB_SHCSR  --------------------------------- */
#define PPB_SHCSR_MEMFAULTACT_Pos             (0UL)                     /*!< PPB SHCSR: MEMFAULTACT (Bit 0)                              */
#define PPB_SHCSR_MEMFAULTACT_Msk             (0x1UL)                   /*!< PPB SHCSR: MEMFAULTACT (Bitfield-Mask: 0x01)                */
#define PPB_SHCSR_BUSFAULTACT_Pos             (1UL)                     /*!< PPB SHCSR: BUSFAULTACT (Bit 1)                              */
#define PPB_SHCSR_BUSFAULTACT_Msk             (0x2UL)                   /*!< PPB SHCSR: BUSFAULTACT (Bitfield-Mask: 0x01)                */
#define PPB_SHCSR_USGFAULTACT_Pos             (3UL)                     /*!< PPB SHCSR: USGFAULTACT (Bit 3)                              */
#define PPB_SHCSR_USGFAULTACT_Msk             (0x8UL)                   /*!< PPB SHCSR: USGFAULTACT (Bitfield-Mask: 0x01)                */
#define PPB_SHCSR_SVCALLACT_Pos               (7UL)                     /*!< PPB SHCSR: SVCALLACT (Bit 7)                                */
#define PPB_SHCSR_SVCALLACT_Msk               (0x80UL)                  /*!< PPB SHCSR: SVCALLACT (Bitfield-Mask: 0x01)                  */
#define PPB_SHCSR_MONITORACT_Pos              (8UL)                     /*!< PPB SHCSR: MONITORACT (Bit 8)                               */
#define PPB_SHCSR_MONITORACT_Msk              (0x100UL)                 /*!< PPB SHCSR: MONITORACT (Bitfield-Mask: 0x01)                 */
#define PPB_SHCSR_PENDSVACT_Pos               (10UL)                    /*!< PPB SHCSR: PENDSVACT (Bit 10)                               */
#define PPB_SHCSR_PENDSVACT_Msk               (0x400UL)                 /*!< PPB SHCSR: PENDSVACT (Bitfield-Mask: 0x01)                  */
#define PPB_SHCSR_SYSTICKACT_Pos              (11UL)                    /*!< PPB SHCSR: SYSTICKACT (Bit 11)                              */
#define PPB_SHCSR_SYSTICKACT_Msk              (0x800UL)                 /*!< PPB SHCSR: SYSTICKACT (Bitfield-Mask: 0x01)                 */
#define PPB_SHCSR_USGFAULTPENDED_Pos          (12UL)                    /*!< PPB SHCSR: USGFAULTPENDED (Bit 12)                          */
#define PPB_SHCSR_USGFAULTPENDED_Msk          (0x1000UL)                /*!< PPB SHCSR: USGFAULTPENDED (Bitfield-Mask: 0x01)             */
#define PPB_SHCSR_MEMFAULTPENDED_Pos          (13UL)                    /*!< PPB SHCSR: MEMFAULTPENDED (Bit 13)                          */
#define PPB_SHCSR_MEMFAULTPENDED_Msk          (0x2000UL)                /*!< PPB SHCSR: MEMFAULTPENDED (Bitfield-Mask: 0x01)             */
#define PPB_SHCSR_BUSFAULTPENDED_Pos          (14UL)                    /*!< PPB SHCSR: BUSFAULTPENDED (Bit 14)                          */
#define PPB_SHCSR_BUSFAULTPENDED_Msk          (0x4000UL)                /*!< PPB SHCSR: BUSFAULTPENDED (Bitfield-Mask: 0x01)             */
#define PPB_SHCSR_SVCALLPENDED_Pos            (15UL)                    /*!< PPB SHCSR: SVCALLPENDED (Bit 15)                            */
#define PPB_SHCSR_SVCALLPENDED_Msk            (0x8000UL)                /*!< PPB SHCSR: SVCALLPENDED (Bitfield-Mask: 0x01)               */
#define PPB_SHCSR_MEMFAULTENA_Pos             (16UL)                    /*!< PPB SHCSR: MEMFAULTENA (Bit 16)                             */
#define PPB_SHCSR_MEMFAULTENA_Msk             (0x10000UL)               /*!< PPB SHCSR: MEMFAULTENA (Bitfield-Mask: 0x01)                */
#define PPB_SHCSR_BUSFAULTENA_Pos             (17UL)                    /*!< PPB SHCSR: BUSFAULTENA (Bit 17)                             */
#define PPB_SHCSR_BUSFAULTENA_Msk             (0x20000UL)               /*!< PPB SHCSR: BUSFAULTENA (Bitfield-Mask: 0x01)                */
#define PPB_SHCSR_USGFAULTENA_Pos             (18UL)                    /*!< PPB SHCSR: USGFAULTENA (Bit 18)                             */
#define PPB_SHCSR_USGFAULTENA_Msk             (0x40000UL)               /*!< PPB SHCSR: USGFAULTENA (Bitfield-Mask: 0x01)                */

/* ----------------------------------  PPB_CFSR  ---------------------------------- */
#define PPB_CFSR_IACCVIOL_Pos                 (0UL)                     /*!< PPB CFSR: IACCVIOL (Bit 0)                                  */
#define PPB_CFSR_IACCVIOL_Msk                 (0x1UL)                   /*!< PPB CFSR: IACCVIOL (Bitfield-Mask: 0x01)                    */
#define PPB_CFSR_DACCVIOL_Pos                 (1UL)                     /*!< PPB CFSR: DACCVIOL (Bit 1)                                  */
#define PPB_CFSR_DACCVIOL_Msk                 (0x2UL)                   /*!< PPB CFSR: DACCVIOL (Bitfield-Mask: 0x01)                    */
#define PPB_CFSR_MUNSTKERR_Pos                (3UL)                     /*!< PPB CFSR: MUNSTKERR (Bit 3)                                 */
#define PPB_CFSR_MUNSTKERR_Msk                (0x8UL)                   /*!< PPB CFSR: MUNSTKERR (Bitfield-Mask: 0x01)                   */
#define PPB_CFSR_MSTKERR_Pos                  (4UL)                     /*!< PPB CFSR: MSTKERR (Bit 4)                                   */
#define PPB_CFSR_MSTKERR_Msk                  (0x10UL)                  /*!< PPB CFSR: MSTKERR (Bitfield-Mask: 0x01)                     */
#define PPB_CFSR_MLSPERR_Pos                  (5UL)                     /*!< PPB CFSR: MLSPERR (Bit 5)                                   */
#define PPB_CFSR_MLSPERR_Msk                  (0x20UL)                  /*!< PPB CFSR: MLSPERR (Bitfield-Mask: 0x01)                     */
#define PPB_CFSR_MMARVALID_Pos                (7UL)                     /*!< PPB CFSR: MMARVALID (Bit 7)                                 */
#define PPB_CFSR_MMARVALID_Msk                (0x80UL)                  /*!< PPB CFSR: MMARVALID (Bitfield-Mask: 0x01)                   */
#define PPB_CFSR_IBUSERR_Pos                  (8UL)                     /*!< PPB CFSR: IBUSERR (Bit 8)                                   */
#define PPB_CFSR_IBUSERR_Msk                  (0x100UL)                 /*!< PPB CFSR: IBUSERR (Bitfield-Mask: 0x01)                     */
#define PPB_CFSR_PRECISERR_Pos                (9UL)                     /*!< PPB CFSR: PRECISERR (Bit 9)                                 */
#define PPB_CFSR_PRECISERR_Msk                (0x200UL)                 /*!< PPB CFSR: PRECISERR (Bitfield-Mask: 0x01)                   */
#define PPB_CFSR_IMPRECISERR_Pos              (10UL)                    /*!< PPB CFSR: IMPRECISERR (Bit 10)                              */
#define PPB_CFSR_IMPRECISERR_Msk              (0x400UL)                 /*!< PPB CFSR: IMPRECISERR (Bitfield-Mask: 0x01)                 */
#define PPB_CFSR_UNSTKERR_Pos                 (11UL)                    /*!< PPB CFSR: UNSTKERR (Bit 11)                                 */
#define PPB_CFSR_UNSTKERR_Msk                 (0x800UL)                 /*!< PPB CFSR: UNSTKERR (Bitfield-Mask: 0x01)                    */
#define PPB_CFSR_STKERR_Pos                   (12UL)                    /*!< PPB CFSR: STKERR (Bit 12)                                   */
#define PPB_CFSR_STKERR_Msk                   (0x1000UL)                /*!< PPB CFSR: STKERR (Bitfield-Mask: 0x01)                      */
#define PPB_CFSR_LSPERR_Pos                   (13UL)                    /*!< PPB CFSR: LSPERR (Bit 13)                                   */
#define PPB_CFSR_LSPERR_Msk                   (0x2000UL)                /*!< PPB CFSR: LSPERR (Bitfield-Mask: 0x01)                      */
#define PPB_CFSR_BFARVALID_Pos                (15UL)                    /*!< PPB CFSR: BFARVALID (Bit 15)                                */
#define PPB_CFSR_BFARVALID_Msk                (0x8000UL)                /*!< PPB CFSR: BFARVALID (Bitfield-Mask: 0x01)                   */
#define PPB_CFSR_UNDEFINSTR_Pos               (16UL)                    /*!< PPB CFSR: UNDEFINSTR (Bit 16)                               */
#define PPB_CFSR_UNDEFINSTR_Msk               (0x10000UL)               /*!< PPB CFSR: UNDEFINSTR (Bitfield-Mask: 0x01)                  */
#define PPB_CFSR_INVSTATE_Pos                 (17UL)                    /*!< PPB CFSR: INVSTATE (Bit 17)                                 */
#define PPB_CFSR_INVSTATE_Msk                 (0x20000UL)               /*!< PPB CFSR: INVSTATE (Bitfield-Mask: 0x01)                    */
#define PPB_CFSR_INVPC_Pos                    (18UL)                    /*!< PPB CFSR: INVPC (Bit 18)                                    */
#define PPB_CFSR_INVPC_Msk                    (0x40000UL)               /*!< PPB CFSR: INVPC (Bitfield-Mask: 0x01)                       */
#define PPB_CFSR_NOCP_Pos                     (19UL)                    /*!< PPB CFSR: NOCP (Bit 19)                                     */
#define PPB_CFSR_NOCP_Msk                     (0x80000UL)               /*!< PPB CFSR: NOCP (Bitfield-Mask: 0x01)                        */
#define PPB_CFSR_UNALIGNED_Pos                (24UL)                    /*!< PPB CFSR: UNALIGNED (Bit 24)                                */
#define PPB_CFSR_UNALIGNED_Msk                (0x1000000UL)             /*!< PPB CFSR: UNALIGNED (Bitfield-Mask: 0x01)                   */
#define PPB_CFSR_DIVBYZERO_Pos                (25UL)                    /*!< PPB CFSR: DIVBYZERO (Bit 25)                                */
#define PPB_CFSR_DIVBYZERO_Msk                (0x2000000UL)             /*!< PPB CFSR: DIVBYZERO (Bitfield-Mask: 0x01)                   */

/* ----------------------------------  PPB_HFSR  ---------------------------------- */
#define PPB_HFSR_VECTTBL_Pos                  (1UL)                     /*!< PPB HFSR: VECTTBL (Bit 1)                                   */
#define PPB_HFSR_VECTTBL_Msk                  (0x2UL)                   /*!< PPB HFSR: VECTTBL (Bitfield-Mask: 0x01)                     */
#define PPB_HFSR_FORCED_Pos                   (30UL)                    /*!< PPB HFSR: FORCED (Bit 30)                                   */
#define PPB_HFSR_FORCED_Msk                   (0x40000000UL)            /*!< PPB HFSR: FORCED (Bitfield-Mask: 0x01)                      */
#define PPB_HFSR_DEBUGEVT_Pos                 (31UL)                    /*!< PPB HFSR: DEBUGEVT (Bit 31)                                 */
#define PPB_HFSR_DEBUGEVT_Msk                 (0x80000000UL)            /*!< PPB HFSR: DEBUGEVT (Bitfield-Mask: 0x01)                    */

/* ----------------------------------  PPB_MMFAR  --------------------------------- */
#define PPB_MMFAR_ADDRESS_Pos                 (0UL)                     /*!< PPB MMFAR: ADDRESS (Bit 0)                                  */
#define PPB_MMFAR_ADDRESS_Msk                 (0xffffffffUL)            /*!< PPB MMFAR: ADDRESS (Bitfield-Mask: 0xffffffff)              */

/* ----------------------------------  PPB_BFAR  ---------------------------------- */
#define PPB_BFAR_ADDRESS_Pos                  (0UL)                     /*!< PPB BFAR: ADDRESS (Bit 0)                                   */
#define PPB_BFAR_ADDRESS_Msk                  (0xffffffffUL)            /*!< PPB BFAR: ADDRESS (Bitfield-Mask: 0xffffffff)               */

/* ----------------------------------  PPB_AFSR  ---------------------------------- */
#define PPB_AFSR_VALUE_Pos                    (0UL)                     /*!< PPB AFSR: VALUE (Bit 0)                                     */
#define PPB_AFSR_VALUE_Msk                    (0xffffffffUL)            /*!< PPB AFSR: VALUE (Bitfield-Mask: 0xffffffff)                 */

/* ----------------------------------  PPB_CPACR  --------------------------------- */
#define PPB_CPACR_CP10_Pos                    (20UL)                    /*!< PPB CPACR: CP10 (Bit 20)                                    */
#define PPB_CPACR_CP10_Msk                    (0x300000UL)              /*!< PPB CPACR: CP10 (Bitfield-Mask: 0x03)                       */
#define PPB_CPACR_CP11_Pos                    (22UL)                    /*!< PPB CPACR: CP11 (Bit 22)                                    */
#define PPB_CPACR_CP11_Msk                    (0xc00000UL)              /*!< PPB CPACR: CP11 (Bitfield-Mask: 0x03)                       */

/* --------------------------------  PPB_MPU_TYPE  -------------------------------- */
#define PPB_MPU_TYPE_SEPARATE_Pos             (0UL)                     /*!< PPB MPU_TYPE: SEPARATE (Bit 0)                              */
#define PPB_MPU_TYPE_SEPARATE_Msk             (0x1UL)                   /*!< PPB MPU_TYPE: SEPARATE (Bitfield-Mask: 0x01)                */
#define PPB_MPU_TYPE_DREGION_Pos              (8UL)                     /*!< PPB MPU_TYPE: DREGION (Bit 8)                               */
#define PPB_MPU_TYPE_DREGION_Msk              (0xff00UL)                /*!< PPB MPU_TYPE: DREGION (Bitfield-Mask: 0xff)                 */
#define PPB_MPU_TYPE_IREGION_Pos              (16UL)                    /*!< PPB MPU_TYPE: IREGION (Bit 16)                              */
#define PPB_MPU_TYPE_IREGION_Msk              (0xff0000UL)              /*!< PPB MPU_TYPE: IREGION (Bitfield-Mask: 0xff)                 */

/* --------------------------------  PPB_MPU_CTRL  -------------------------------- */
#define PPB_MPU_CTRL_ENABLE_Pos               (0UL)                     /*!< PPB MPU_CTRL: ENABLE (Bit 0)                                */
#define PPB_MPU_CTRL_ENABLE_Msk               (0x1UL)                   /*!< PPB MPU_CTRL: ENABLE (Bitfield-Mask: 0x01)                  */
#define PPB_MPU_CTRL_HFNMIENA_Pos             (1UL)                     /*!< PPB MPU_CTRL: HFNMIENA (Bit 1)                              */
#define PPB_MPU_CTRL_HFNMIENA_Msk             (0x2UL)                   /*!< PPB MPU_CTRL: HFNMIENA (Bitfield-Mask: 0x01)                */
#define PPB_MPU_CTRL_PRIVDEFENA_Pos           (2UL)                     /*!< PPB MPU_CTRL: PRIVDEFENA (Bit 2)                            */
#define PPB_MPU_CTRL_PRIVDEFENA_Msk           (0x4UL)                   /*!< PPB MPU_CTRL: PRIVDEFENA (Bitfield-Mask: 0x01)              */

/* ---------------------------------  PPB_MPU_RNR  -------------------------------- */
#define PPB_MPU_RNR_REGION_Pos                (0UL)                     /*!< PPB MPU_RNR: REGION (Bit 0)                                 */
#define PPB_MPU_RNR_REGION_Msk                (0xffUL)                  /*!< PPB MPU_RNR: REGION (Bitfield-Mask: 0xff)                   */

/* --------------------------------  PPB_MPU_RBAR  -------------------------------- */
#define PPB_MPU_RBAR_REGION_Pos               (0UL)                     /*!< PPB MPU_RBAR: REGION (Bit 0)                                */
#define PPB_MPU_RBAR_REGION_Msk               (0xfUL)                   /*!< PPB MPU_RBAR: REGION (Bitfield-Mask: 0x0f)                  */
#define PPB_MPU_RBAR_VALID_Pos                (4UL)                     /*!< PPB MPU_RBAR: VALID (Bit 4)                                 */
#define PPB_MPU_RBAR_VALID_Msk                (0x10UL)                  /*!< PPB MPU_RBAR: VALID (Bitfield-Mask: 0x01)                   */
#define PPB_MPU_RBAR_ADDR_Pos                 (9UL)                     /*!< PPB MPU_RBAR: ADDR (Bit 9)                                  */
#define PPB_MPU_RBAR_ADDR_Msk                 (0xfffffe00UL)            /*!< PPB MPU_RBAR: ADDR (Bitfield-Mask: 0x7fffff)                */

/* --------------------------------  PPB_MPU_RASR  -------------------------------- */
#define PPB_MPU_RASR_ENABLE_Pos               (0UL)                     /*!< PPB MPU_RASR: ENABLE (Bit 0)                                */
#define PPB_MPU_RASR_ENABLE_Msk               (0x1UL)                   /*!< PPB MPU_RASR: ENABLE (Bitfield-Mask: 0x01)                  */
#define PPB_MPU_RASR_SIZE_Pos                 (1UL)                     /*!< PPB MPU_RASR: SIZE (Bit 1)                                  */
#define PPB_MPU_RASR_SIZE_Msk                 (0x3eUL)                  /*!< PPB MPU_RASR: SIZE (Bitfield-Mask: 0x1f)                    */
#define PPB_MPU_RASR_SRD_Pos                  (8UL)                     /*!< PPB MPU_RASR: SRD (Bit 8)                                   */
#define PPB_MPU_RASR_SRD_Msk                  (0xff00UL)                /*!< PPB MPU_RASR: SRD (Bitfield-Mask: 0xff)                     */
#define PPB_MPU_RASR_B_Pos                    (16UL)                    /*!< PPB MPU_RASR: B (Bit 16)                                    */
#define PPB_MPU_RASR_B_Msk                    (0x10000UL)               /*!< PPB MPU_RASR: B (Bitfield-Mask: 0x01)                       */
#define PPB_MPU_RASR_C_Pos                    (17UL)                    /*!< PPB MPU_RASR: C (Bit 17)                                    */
#define PPB_MPU_RASR_C_Msk                    (0x20000UL)               /*!< PPB MPU_RASR: C (Bitfield-Mask: 0x01)                       */
#define PPB_MPU_RASR_S_Pos                    (18UL)                    /*!< PPB MPU_RASR: S (Bit 18)                                    */
#define PPB_MPU_RASR_S_Msk                    (0x40000UL)               /*!< PPB MPU_RASR: S (Bitfield-Mask: 0x01)                       */
#define PPB_MPU_RASR_TEX_Pos                  (19UL)                    /*!< PPB MPU_RASR: TEX (Bit 19)                                  */
#define PPB_MPU_RASR_TEX_Msk                  (0x380000UL)              /*!< PPB MPU_RASR: TEX (Bitfield-Mask: 0x07)                     */
#define PPB_MPU_RASR_AP_Pos                   (24UL)                    /*!< PPB MPU_RASR: AP (Bit 24)                                   */
#define PPB_MPU_RASR_AP_Msk                   (0x7000000UL)             /*!< PPB MPU_RASR: AP (Bitfield-Mask: 0x07)                      */
#define PPB_MPU_RASR_XN_Pos                   (28UL)                    /*!< PPB MPU_RASR: XN (Bit 28)                                   */
#define PPB_MPU_RASR_XN_Msk                   (0x10000000UL)            /*!< PPB MPU_RASR: XN (Bitfield-Mask: 0x01)                      */

/* -------------------------------  PPB_MPU_RBAR_A1  ------------------------------ */
#define PPB_MPU_RBAR_A1_REGION_Pos            (0UL)                     /*!< PPB MPU_RBAR_A1: REGION (Bit 0)                             */
#define PPB_MPU_RBAR_A1_REGION_Msk            (0xfUL)                   /*!< PPB MPU_RBAR_A1: REGION (Bitfield-Mask: 0x0f)               */
#define PPB_MPU_RBAR_A1_VALID_Pos             (4UL)                     /*!< PPB MPU_RBAR_A1: VALID (Bit 4)                              */
#define PPB_MPU_RBAR_A1_VALID_Msk             (0x10UL)                  /*!< PPB MPU_RBAR_A1: VALID (Bitfield-Mask: 0x01)                */
#define PPB_MPU_RBAR_A1_ADDR_Pos              (9UL)                     /*!< PPB MPU_RBAR_A1: ADDR (Bit 9)                               */
#define PPB_MPU_RBAR_A1_ADDR_Msk              (0xfffffe00UL)            /*!< PPB MPU_RBAR_A1: ADDR (Bitfield-Mask: 0x7fffff)             */

/* -------------------------------  PPB_MPU_RASR_A1  ------------------------------ */
#define PPB_MPU_RASR_A1_ENABLE_Pos            (0UL)                     /*!< PPB MPU_RASR_A1: ENABLE (Bit 0)                             */
#define PPB_MPU_RASR_A1_ENABLE_Msk            (0x1UL)                   /*!< PPB MPU_RASR_A1: ENABLE (Bitfield-Mask: 0x01)               */
#define PPB_MPU_RASR_A1_SIZE_Pos              (1UL)                     /*!< PPB MPU_RASR_A1: SIZE (Bit 1)                               */
#define PPB_MPU_RASR_A1_SIZE_Msk              (0x3eUL)                  /*!< PPB MPU_RASR_A1: SIZE (Bitfield-Mask: 0x1f)                 */
#define PPB_MPU_RASR_A1_SRD_Pos               (8UL)                     /*!< PPB MPU_RASR_A1: SRD (Bit 8)                                */
#define PPB_MPU_RASR_A1_SRD_Msk               (0xff00UL)                /*!< PPB MPU_RASR_A1: SRD (Bitfield-Mask: 0xff)                  */
#define PPB_MPU_RASR_A1_B_Pos                 (16UL)                    /*!< PPB MPU_RASR_A1: B (Bit 16)                                 */
#define PPB_MPU_RASR_A1_B_Msk                 (0x10000UL)               /*!< PPB MPU_RASR_A1: B (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A1_C_Pos                 (17UL)                    /*!< PPB MPU_RASR_A1: C (Bit 17)                                 */
#define PPB_MPU_RASR_A1_C_Msk                 (0x20000UL)               /*!< PPB MPU_RASR_A1: C (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A1_S_Pos                 (18UL)                    /*!< PPB MPU_RASR_A1: S (Bit 18)                                 */
#define PPB_MPU_RASR_A1_S_Msk                 (0x40000UL)               /*!< PPB MPU_RASR_A1: S (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A1_TEX_Pos               (19UL)                    /*!< PPB MPU_RASR_A1: TEX (Bit 19)                               */
#define PPB_MPU_RASR_A1_TEX_Msk               (0x380000UL)              /*!< PPB MPU_RASR_A1: TEX (Bitfield-Mask: 0x07)                  */
#define PPB_MPU_RASR_A1_AP_Pos                (24UL)                    /*!< PPB MPU_RASR_A1: AP (Bit 24)                                */
#define PPB_MPU_RASR_A1_AP_Msk                (0x7000000UL)             /*!< PPB MPU_RASR_A1: AP (Bitfield-Mask: 0x07)                   */
#define PPB_MPU_RASR_A1_XN_Pos                (28UL)                    /*!< PPB MPU_RASR_A1: XN (Bit 28)                                */
#define PPB_MPU_RASR_A1_XN_Msk                (0x10000000UL)            /*!< PPB MPU_RASR_A1: XN (Bitfield-Mask: 0x01)                   */

/* -------------------------------  PPB_MPU_RBAR_A2  ------------------------------ */
#define PPB_MPU_RBAR_A2_REGION_Pos            (0UL)                     /*!< PPB MPU_RBAR_A2: REGION (Bit 0)                             */
#define PPB_MPU_RBAR_A2_REGION_Msk            (0xfUL)                   /*!< PPB MPU_RBAR_A2: REGION (Bitfield-Mask: 0x0f)               */
#define PPB_MPU_RBAR_A2_VALID_Pos             (4UL)                     /*!< PPB MPU_RBAR_A2: VALID (Bit 4)                              */
#define PPB_MPU_RBAR_A2_VALID_Msk             (0x10UL)                  /*!< PPB MPU_RBAR_A2: VALID (Bitfield-Mask: 0x01)                */
#define PPB_MPU_RBAR_A2_ADDR_Pos              (9UL)                     /*!< PPB MPU_RBAR_A2: ADDR (Bit 9)                               */
#define PPB_MPU_RBAR_A2_ADDR_Msk              (0xfffffe00UL)            /*!< PPB MPU_RBAR_A2: ADDR (Bitfield-Mask: 0x7fffff)             */

/* -------------------------------  PPB_MPU_RASR_A2  ------------------------------ */
#define PPB_MPU_RASR_A2_ENABLE_Pos            (0UL)                     /*!< PPB MPU_RASR_A2: ENABLE (Bit 0)                             */
#define PPB_MPU_RASR_A2_ENABLE_Msk            (0x1UL)                   /*!< PPB MPU_RASR_A2: ENABLE (Bitfield-Mask: 0x01)               */
#define PPB_MPU_RASR_A2_SIZE_Pos              (1UL)                     /*!< PPB MPU_RASR_A2: SIZE (Bit 1)                               */
#define PPB_MPU_RASR_A2_SIZE_Msk              (0x3eUL)                  /*!< PPB MPU_RASR_A2: SIZE (Bitfield-Mask: 0x1f)                 */
#define PPB_MPU_RASR_A2_SRD_Pos               (8UL)                     /*!< PPB MPU_RASR_A2: SRD (Bit 8)                                */
#define PPB_MPU_RASR_A2_SRD_Msk               (0xff00UL)                /*!< PPB MPU_RASR_A2: SRD (Bitfield-Mask: 0xff)                  */
#define PPB_MPU_RASR_A2_B_Pos                 (16UL)                    /*!< PPB MPU_RASR_A2: B (Bit 16)                                 */
#define PPB_MPU_RASR_A2_B_Msk                 (0x10000UL)               /*!< PPB MPU_RASR_A2: B (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A2_C_Pos                 (17UL)                    /*!< PPB MPU_RASR_A2: C (Bit 17)                                 */
#define PPB_MPU_RASR_A2_C_Msk                 (0x20000UL)               /*!< PPB MPU_RASR_A2: C (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A2_S_Pos                 (18UL)                    /*!< PPB MPU_RASR_A2: S (Bit 18)                                 */
#define PPB_MPU_RASR_A2_S_Msk                 (0x40000UL)               /*!< PPB MPU_RASR_A2: S (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A2_TEX_Pos               (19UL)                    /*!< PPB MPU_RASR_A2: TEX (Bit 19)                               */
#define PPB_MPU_RASR_A2_TEX_Msk               (0x380000UL)              /*!< PPB MPU_RASR_A2: TEX (Bitfield-Mask: 0x07)                  */
#define PPB_MPU_RASR_A2_AP_Pos                (24UL)                    /*!< PPB MPU_RASR_A2: AP (Bit 24)                                */
#define PPB_MPU_RASR_A2_AP_Msk                (0x7000000UL)             /*!< PPB MPU_RASR_A2: AP (Bitfield-Mask: 0x07)                   */
#define PPB_MPU_RASR_A2_XN_Pos                (28UL)                    /*!< PPB MPU_RASR_A2: XN (Bit 28)                                */
#define PPB_MPU_RASR_A2_XN_Msk                (0x10000000UL)            /*!< PPB MPU_RASR_A2: XN (Bitfield-Mask: 0x01)                   */

/* -------------------------------  PPB_MPU_RBAR_A3  ------------------------------ */
#define PPB_MPU_RBAR_A3_REGION_Pos            (0UL)                     /*!< PPB MPU_RBAR_A3: REGION (Bit 0)                             */
#define PPB_MPU_RBAR_A3_REGION_Msk            (0xfUL)                   /*!< PPB MPU_RBAR_A3: REGION (Bitfield-Mask: 0x0f)               */
#define PPB_MPU_RBAR_A3_VALID_Pos             (4UL)                     /*!< PPB MPU_RBAR_A3: VALID (Bit 4)                              */
#define PPB_MPU_RBAR_A3_VALID_Msk             (0x10UL)                  /*!< PPB MPU_RBAR_A3: VALID (Bitfield-Mask: 0x01)                */
#define PPB_MPU_RBAR_A3_ADDR_Pos              (9UL)                     /*!< PPB MPU_RBAR_A3: ADDR (Bit 9)                               */
#define PPB_MPU_RBAR_A3_ADDR_Msk              (0xfffffe00UL)            /*!< PPB MPU_RBAR_A3: ADDR (Bitfield-Mask: 0x7fffff)             */

/* -------------------------------  PPB_MPU_RASR_A3  ------------------------------ */
#define PPB_MPU_RASR_A3_ENABLE_Pos            (0UL)                     /*!< PPB MPU_RASR_A3: ENABLE (Bit 0)                             */
#define PPB_MPU_RASR_A3_ENABLE_Msk            (0x1UL)                   /*!< PPB MPU_RASR_A3: ENABLE (Bitfield-Mask: 0x01)               */
#define PPB_MPU_RASR_A3_SIZE_Pos              (1UL)                     /*!< PPB MPU_RASR_A3: SIZE (Bit 1)                               */
#define PPB_MPU_RASR_A3_SIZE_Msk              (0x3eUL)                  /*!< PPB MPU_RASR_A3: SIZE (Bitfield-Mask: 0x1f)                 */
#define PPB_MPU_RASR_A3_SRD_Pos               (8UL)                     /*!< PPB MPU_RASR_A3: SRD (Bit 8)                                */
#define PPB_MPU_RASR_A3_SRD_Msk               (0xff00UL)                /*!< PPB MPU_RASR_A3: SRD (Bitfield-Mask: 0xff)                  */
#define PPB_MPU_RASR_A3_B_Pos                 (16UL)                    /*!< PPB MPU_RASR_A3: B (Bit 16)                                 */
#define PPB_MPU_RASR_A3_B_Msk                 (0x10000UL)               /*!< PPB MPU_RASR_A3: B (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A3_C_Pos                 (17UL)                    /*!< PPB MPU_RASR_A3: C (Bit 17)                                 */
#define PPB_MPU_RASR_A3_C_Msk                 (0x20000UL)               /*!< PPB MPU_RASR_A3: C (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A3_S_Pos                 (18UL)                    /*!< PPB MPU_RASR_A3: S (Bit 18)                                 */
#define PPB_MPU_RASR_A3_S_Msk                 (0x40000UL)               /*!< PPB MPU_RASR_A3: S (Bitfield-Mask: 0x01)                    */
#define PPB_MPU_RASR_A3_TEX_Pos               (19UL)                    /*!< PPB MPU_RASR_A3: TEX (Bit 19)                               */
#define PPB_MPU_RASR_A3_TEX_Msk               (0x380000UL)              /*!< PPB MPU_RASR_A3: TEX (Bitfield-Mask: 0x07)                  */
#define PPB_MPU_RASR_A3_AP_Pos                (24UL)                    /*!< PPB MPU_RASR_A3: AP (Bit 24)                                */
#define PPB_MPU_RASR_A3_AP_Msk                (0x7000000UL)             /*!< PPB MPU_RASR_A3: AP (Bitfield-Mask: 0x07)                   */
#define PPB_MPU_RASR_A3_XN_Pos                (28UL)                    /*!< PPB MPU_RASR_A3: XN (Bit 28)                                */
#define PPB_MPU_RASR_A3_XN_Msk                (0x10000000UL)            /*!< PPB MPU_RASR_A3: XN (Bitfield-Mask: 0x01)                   */

/* ----------------------------------  PPB_STIR  ---------------------------------- */
#define PPB_STIR_INTID_Pos                    (0UL)                     /*!< PPB STIR: INTID (Bit 0)                                     */
#define PPB_STIR_INTID_Msk                    (0x1ffUL)                 /*!< PPB STIR: INTID (Bitfield-Mask: 0x1ff)                      */

/* ----------------------------------  PPB_FPCCR  --------------------------------- */
#define PPB_FPCCR_LSPACT_Pos                  (0UL)                     /*!< PPB FPCCR: LSPACT (Bit 0)                                   */
#define PPB_FPCCR_LSPACT_Msk                  (0x1UL)                   /*!< PPB FPCCR: LSPACT (Bitfield-Mask: 0x01)                     */
#define PPB_FPCCR_USER_Pos                    (1UL)                     /*!< PPB FPCCR: USER (Bit 1)                                     */
#define PPB_FPCCR_USER_Msk                    (0x2UL)                   /*!< PPB FPCCR: USER (Bitfield-Mask: 0x01)                       */
#define PPB_FPCCR_THREAD_Pos                  (3UL)                     /*!< PPB FPCCR: THREAD (Bit 3)                                   */
#define PPB_FPCCR_THREAD_Msk                  (0x8UL)                   /*!< PPB FPCCR: THREAD (Bitfield-Mask: 0x01)                     */
#define PPB_FPCCR_HFRDY_Pos                   (4UL)                     /*!< PPB FPCCR: HFRDY (Bit 4)                                    */
#define PPB_FPCCR_HFRDY_Msk                   (0x10UL)                  /*!< PPB FPCCR: HFRDY (Bitfield-Mask: 0x01)                      */
#define PPB_FPCCR_MMRDY_Pos                   (5UL)                     /*!< PPB FPCCR: MMRDY (Bit 5)                                    */
#define PPB_FPCCR_MMRDY_Msk                   (0x20UL)                  /*!< PPB FPCCR: MMRDY (Bitfield-Mask: 0x01)                      */
#define PPB_FPCCR_BFRDY_Pos                   (6UL)                     /*!< PPB FPCCR: BFRDY (Bit 6)                                    */
#define PPB_FPCCR_BFRDY_Msk                   (0x40UL)                  /*!< PPB FPCCR: BFRDY (Bitfield-Mask: 0x01)                      */
#define PPB_FPCCR_MONRDY_Pos                  (8UL)                     /*!< PPB FPCCR: MONRDY (Bit 8)                                   */
#define PPB_FPCCR_MONRDY_Msk                  (0x100UL)                 /*!< PPB FPCCR: MONRDY (Bitfield-Mask: 0x01)                     */
#define PPB_FPCCR_LSPEN_Pos                   (30UL)                    /*!< PPB FPCCR: LSPEN (Bit 30)                                   */
#define PPB_FPCCR_LSPEN_Msk                   (0x40000000UL)            /*!< PPB FPCCR: LSPEN (Bitfield-Mask: 0x01)                      */
#define PPB_FPCCR_ASPEN_Pos                   (31UL)                    /*!< PPB FPCCR: ASPEN (Bit 31)                                   */
#define PPB_FPCCR_ASPEN_Msk                   (0x80000000UL)            /*!< PPB FPCCR: ASPEN (Bitfield-Mask: 0x01)                      */

/* ----------------------------------  PPB_FPCAR  --------------------------------- */
#define PPB_FPCAR_ADDRESS_Pos                 (3UL)                     /*!< PPB FPCAR: ADDRESS (Bit 3)                                  */
#define PPB_FPCAR_ADDRESS_Msk                 (0xfffffff8UL)            /*!< PPB FPCAR: ADDRESS (Bitfield-Mask: 0x1fffffff)              */

/* ---------------------------------  PPB_FPDSCR  --------------------------------- */
#define PPB_FPDSCR_RMode_Pos                  (22UL)                    /*!< PPB FPDSCR: RMode (Bit 22)                                  */
#define PPB_FPDSCR_RMode_Msk                  (0xc00000UL)              /*!< PPB FPDSCR: RMode (Bitfield-Mask: 0x03)                     */
#define PPB_FPDSCR_FZ_Pos                     (24UL)                    /*!< PPB FPDSCR: FZ (Bit 24)                                     */
#define PPB_FPDSCR_FZ_Msk                     (0x1000000UL)             /*!< PPB FPDSCR: FZ (Bitfield-Mask: 0x01)                        */
#define PPB_FPDSCR_DN_Pos                     (25UL)                    /*!< PPB FPDSCR: DN (Bit 25)                                     */
#define PPB_FPDSCR_DN_Msk                     (0x2000000UL)             /*!< PPB FPDSCR: DN (Bitfield-Mask: 0x01)                        */
#define PPB_FPDSCR_AHP_Pos                    (26UL)                    /*!< PPB FPDSCR: AHP (Bit 26)                                    */
#define PPB_FPDSCR_AHP_Msk                    (0x4000000UL)             /*!< PPB FPDSCR: AHP (Bitfield-Mask: 0x01)                       */


/* ================================================================================ */
/* ================          struct 'DLR' Position & Mask          ================ */
/* ================================================================================ */


/* ---------------------------------  DLR_OVRSTAT  -------------------------------- */
#define DLR_OVRSTAT_LN0_Pos                   (0UL)                     /*!< DLR OVRSTAT: LN0 (Bit 0)                                    */
#define DLR_OVRSTAT_LN0_Msk                   (0x1UL)                   /*!< DLR OVRSTAT: LN0 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN1_Pos                   (1UL)                     /*!< DLR OVRSTAT: LN1 (Bit 1)                                    */
#define DLR_OVRSTAT_LN1_Msk                   (0x2UL)                   /*!< DLR OVRSTAT: LN1 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN2_Pos                   (2UL)                     /*!< DLR OVRSTAT: LN2 (Bit 2)                                    */
#define DLR_OVRSTAT_LN2_Msk                   (0x4UL)                   /*!< DLR OVRSTAT: LN2 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN3_Pos                   (3UL)                     /*!< DLR OVRSTAT: LN3 (Bit 3)                                    */
#define DLR_OVRSTAT_LN3_Msk                   (0x8UL)                   /*!< DLR OVRSTAT: LN3 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN4_Pos                   (4UL)                     /*!< DLR OVRSTAT: LN4 (Bit 4)                                    */
#define DLR_OVRSTAT_LN4_Msk                   (0x10UL)                  /*!< DLR OVRSTAT: LN4 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN5_Pos                   (5UL)                     /*!< DLR OVRSTAT: LN5 (Bit 5)                                    */
#define DLR_OVRSTAT_LN5_Msk                   (0x20UL)                  /*!< DLR OVRSTAT: LN5 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN6_Pos                   (6UL)                     /*!< DLR OVRSTAT: LN6 (Bit 6)                                    */
#define DLR_OVRSTAT_LN6_Msk                   (0x40UL)                  /*!< DLR OVRSTAT: LN6 (Bitfield-Mask: 0x01)                      */
#define DLR_OVRSTAT_LN7_Pos                   (7UL)                     /*!< DLR OVRSTAT: LN7 (Bit 7)                                    */
#define DLR_OVRSTAT_LN7_Msk                   (0x80UL)                  /*!< DLR OVRSTAT: LN7 (Bitfield-Mask: 0x01)                      */

/* ---------------------------------  DLR_OVRCLR  --------------------------------- */
#define DLR_OVRCLR_LN0_Pos                    (0UL)                     /*!< DLR OVRCLR: LN0 (Bit 0)                                     */
#define DLR_OVRCLR_LN0_Msk                    (0x1UL)                   /*!< DLR OVRCLR: LN0 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN1_Pos                    (1UL)                     /*!< DLR OVRCLR: LN1 (Bit 1)                                     */
#define DLR_OVRCLR_LN1_Msk                    (0x2UL)                   /*!< DLR OVRCLR: LN1 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN2_Pos                    (2UL)                     /*!< DLR OVRCLR: LN2 (Bit 2)                                     */
#define DLR_OVRCLR_LN2_Msk                    (0x4UL)                   /*!< DLR OVRCLR: LN2 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN3_Pos                    (3UL)                     /*!< DLR OVRCLR: LN3 (Bit 3)                                     */
#define DLR_OVRCLR_LN3_Msk                    (0x8UL)                   /*!< DLR OVRCLR: LN3 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN4_Pos                    (4UL)                     /*!< DLR OVRCLR: LN4 (Bit 4)                                     */
#define DLR_OVRCLR_LN4_Msk                    (0x10UL)                  /*!< DLR OVRCLR: LN4 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN5_Pos                    (5UL)                     /*!< DLR OVRCLR: LN5 (Bit 5)                                     */
#define DLR_OVRCLR_LN5_Msk                    (0x20UL)                  /*!< DLR OVRCLR: LN5 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN6_Pos                    (6UL)                     /*!< DLR OVRCLR: LN6 (Bit 6)                                     */
#define DLR_OVRCLR_LN6_Msk                    (0x40UL)                  /*!< DLR OVRCLR: LN6 (Bitfield-Mask: 0x01)                       */
#define DLR_OVRCLR_LN7_Pos                    (7UL)                     /*!< DLR OVRCLR: LN7 (Bit 7)                                     */
#define DLR_OVRCLR_LN7_Msk                    (0x80UL)                  /*!< DLR OVRCLR: LN7 (Bitfield-Mask: 0x01)                       */

/* ---------------------------------  DLR_SRSEL0  --------------------------------- */
#define DLR_SRSEL0_RS0_Pos                    (0UL)                     /*!< DLR SRSEL0: RS0 (Bit 0)                                     */
#define DLR_SRSEL0_RS0_Msk                    (0xfUL)                   /*!< DLR SRSEL0: RS0 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL0_RS1_Pos                    (4UL)                     /*!< DLR SRSEL0: RS1 (Bit 4)                                     */
#define DLR_SRSEL0_RS1_Msk                    (0xf0UL)                  /*!< DLR SRSEL0: RS1 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL0_RS2_Pos                    (8UL)                     /*!< DLR SRSEL0: RS2 (Bit 8)                                     */
#define DLR_SRSEL0_RS2_Msk                    (0xf00UL)                 /*!< DLR SRSEL0: RS2 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL0_RS3_Pos                    (12UL)                    /*!< DLR SRSEL0: RS3 (Bit 12)                                    */
#define DLR_SRSEL0_RS3_Msk                    (0xf000UL)                /*!< DLR SRSEL0: RS3 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL0_RS4_Pos                    (16UL)                    /*!< DLR SRSEL0: RS4 (Bit 16)                                    */
#define DLR_SRSEL0_RS4_Msk                    (0xf0000UL)               /*!< DLR SRSEL0: RS4 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL0_RS5_Pos                    (20UL)                    /*!< DLR SRSEL0: RS5 (Bit 20)                                    */
#define DLR_SRSEL0_RS5_Msk                    (0xf00000UL)              /*!< DLR SRSEL0: RS5 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL0_RS6_Pos                    (24UL)                    /*!< DLR SRSEL0: RS6 (Bit 24)                                    */
#define DLR_SRSEL0_RS6_Msk                    (0xf000000UL)             /*!< DLR SRSEL0: RS6 (Bitfield-Mask: 0x0f)                       */
#define DLR_SRSEL0_RS7_Pos                    (28UL)                    /*!< DLR SRSEL0: RS7 (Bit 28)                                    */
#define DLR_SRSEL0_RS7_Msk                    (0xf0000000UL)            /*!< DLR SRSEL0: RS7 (Bitfield-Mask: 0x0f)                       */

/* ----------------------------------  DLR_LNEN  ---------------------------------- */
#define DLR_LNEN_LN0_Pos                      (0UL)                     /*!< DLR LNEN: LN0 (Bit 0)                                       */
#define DLR_LNEN_LN0_Msk                      (0x1UL)                   /*!< DLR LNEN: LN0 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN1_Pos                      (1UL)                     /*!< DLR LNEN: LN1 (Bit 1)                                       */
#define DLR_LNEN_LN1_Msk                      (0x2UL)                   /*!< DLR LNEN: LN1 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN2_Pos                      (2UL)                     /*!< DLR LNEN: LN2 (Bit 2)                                       */
#define DLR_LNEN_LN2_Msk                      (0x4UL)                   /*!< DLR LNEN: LN2 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN3_Pos                      (3UL)                     /*!< DLR LNEN: LN3 (Bit 3)                                       */
#define DLR_LNEN_LN3_Msk                      (0x8UL)                   /*!< DLR LNEN: LN3 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN4_Pos                      (4UL)                     /*!< DLR LNEN: LN4 (Bit 4)                                       */
#define DLR_LNEN_LN4_Msk                      (0x10UL)                  /*!< DLR LNEN: LN4 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN5_Pos                      (5UL)                     /*!< DLR LNEN: LN5 (Bit 5)                                       */
#define DLR_LNEN_LN5_Msk                      (0x20UL)                  /*!< DLR LNEN: LN5 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN6_Pos                      (6UL)                     /*!< DLR LNEN: LN6 (Bit 6)                                       */
#define DLR_LNEN_LN6_Msk                      (0x40UL)                  /*!< DLR LNEN: LN6 (Bitfield-Mask: 0x01)                         */
#define DLR_LNEN_LN7_Pos                      (7UL)                     /*!< DLR LNEN: LN7 (Bit 7)                                       */
#define DLR_LNEN_LN7_Msk                      (0x80UL)                  /*!< DLR LNEN: LN7 (Bitfield-Mask: 0x01)                         */


/* ================================================================================ */
/* ================           Group 'ERU' Position & Mask          ================ */
/* ================================================================================ */


/* ---------------------------------  ERU_EXISEL  --------------------------------- */
#define ERU_EXISEL_EXS0A_Pos                  (0UL)                     /*!< ERU EXISEL: EXS0A (Bit 0)                                   */
#define ERU_EXISEL_EXS0A_Msk                  (0x3UL)                   /*!< ERU EXISEL: EXS0A (Bitfield-Mask: 0x03)                     */
#define ERU_EXISEL_EXS0B_Pos                  (2UL)                     /*!< ERU EXISEL: EXS0B (Bit 2)                                   */
#define ERU_EXISEL_EXS0B_Msk                  (0xcUL)                   /*!< ERU EXISEL: EXS0B (Bitfield-Mask: 0x03)                     */
#define ERU_EXISEL_EXS1A_Pos                  (4UL)                     /*!< ERU EXISEL: EXS1A (Bit 4)                                   */
#define ERU_EXISEL_EXS1A_Msk                  (0x30UL)                  /*!< ERU EXISEL: EXS1A (Bitfield-Mask: 0x03)                     */
#define ERU_EXISEL_EXS1B_Pos                  (6UL)                     /*!< ERU EXISEL: EXS1B (Bit 6)                                   */
#define ERU_EXISEL_EXS1B_Msk                  (0xc0UL)                  /*!< ERU EXISEL: EXS1B (Bitfield-Mask: 0x03)                     */
#define ERU_EXISEL_EXS2A_Pos                  (8UL)                     /*!< ERU EXISEL: EXS2A (Bit 8)                                   */
#define ERU_EXISEL_EXS2A_Msk                  (0x300UL)                 /*!< ERU EXISEL: EXS2A (Bitfield-Mask: 0x03)                     */
#define ERU_EXISEL_EXS2B_Pos                  (10UL)                    /*!< ERU EXISEL: EXS2B (Bit 10)                                  */
#define ERU_EXISEL_EXS2B_Msk                  (0xc00UL)                 /*!< ERU EXISEL: EXS2B (Bitfield-Mask: 0x03)                     */
#define ERU_EXISEL_EXS3A_Pos                  (12UL)                    /*!< ERU EXISEL: EXS3A (Bit 12)                                  */
#define ERU_EXISEL_EXS3A_Msk                  (0x3000UL)                /*!< ERU EXISEL: EXS3A (Bitfield-Mask: 0x03)                     */
#define ERU_EXISEL_EXS3B_Pos                  (14UL)                    /*!< ERU EXISEL: EXS3B (Bit 14)                                  */
#define ERU_EXISEL_EXS3B_Msk                  (0xc000UL)                /*!< ERU EXISEL: EXS3B (Bitfield-Mask: 0x03)                     */

/* ---------------------------------  ERU_EXICON  --------------------------------- */
#define ERU_EXICON_PE_Pos                     (0UL)                     /*!< ERU EXICON: PE (Bit 0)                                      */
#define ERU_EXICON_PE_Msk                     (0x1UL)                   /*!< ERU EXICON: PE (Bitfield-Mask: 0x01)                        */
#define ERU_EXICON_LD_Pos                     (1UL)                     /*!< ERU EXICON: LD (Bit 1)                                      */
#define ERU_EXICON_LD_Msk                     (0x2UL)                   /*!< ERU EXICON: LD (Bitfield-Mask: 0x01)                        */
#define ERU_EXICON_RE_Pos                     (2UL)                     /*!< ERU EXICON: RE (Bit 2)                                      */
#define ERU_EXICON_RE_Msk                     (0x4UL)                   /*!< ERU EXICON: RE (Bitfield-Mask: 0x01)                        */
#define ERU_EXICON_FE_Pos                     (3UL)                     /*!< ERU EXICON: FE (Bit 3)                                      */
#define ERU_EXICON_FE_Msk                     (0x8UL)                   /*!< ERU EXICON: FE (Bitfield-Mask: 0x01)                        */
#define ERU_EXICON_OCS_Pos                    (4UL)                     /*!< ERU EXICON: OCS (Bit 4)                                     */
#define ERU_EXICON_OCS_Msk                    (0x70UL)                  /*!< ERU EXICON: OCS (Bitfield-Mask: 0x07)                       */
#define ERU_EXICON_FL_Pos                     (7UL)                     /*!< ERU EXICON: FL (Bit 7)                                      */
#define ERU_EXICON_FL_Msk                     (0x80UL)                  /*!< ERU EXICON: FL (Bitfield-Mask: 0x01)                        */
#define ERU_EXICON_SS_Pos                     (8UL)                     /*!< ERU EXICON: SS (Bit 8)                                      */
#define ERU_EXICON_SS_Msk                     (0x300UL)                 /*!< ERU EXICON: SS (Bitfield-Mask: 0x03)                        */
#define ERU_EXICON_NA_Pos                     (10UL)                    /*!< ERU EXICON: NA (Bit 10)                                     */
#define ERU_EXICON_NA_Msk                     (0x400UL)                 /*!< ERU EXICON: NA (Bitfield-Mask: 0x01)                        */
#define ERU_EXICON_NB_Pos                     (11UL)                    /*!< ERU EXICON: NB (Bit 11)                                     */
#define ERU_EXICON_NB_Msk                     (0x800UL)                 /*!< ERU EXICON: NB (Bitfield-Mask: 0x01)                        */

/* ---------------------------------  ERU_EXOCON  --------------------------------- */
#define ERU_EXOCON_ISS_Pos                    (0UL)                     /*!< ERU EXOCON: ISS (Bit 0)                                     */
#define ERU_EXOCON_ISS_Msk                    (0x3UL)                   /*!< ERU EXOCON: ISS (Bitfield-Mask: 0x03)                       */
#define ERU_EXOCON_GEEN_Pos                   (2UL)                     /*!< ERU EXOCON: GEEN (Bit 2)                                    */
#define ERU_EXOCON_GEEN_Msk                   (0x4UL)                   /*!< ERU EXOCON: GEEN (Bitfield-Mask: 0x01)                      */
#define ERU_EXOCON_PDR_Pos                    (3UL)                     /*!< ERU EXOCON: PDR (Bit 3)                                     */
#define ERU_EXOCON_PDR_Msk                    (0x8UL)                   /*!< ERU EXOCON: PDR (Bitfield-Mask: 0x01)                       */
#define ERU_EXOCON_GP_Pos                     (4UL)                     /*!< ERU EXOCON: GP (Bit 4)                                      */
#define ERU_EXOCON_GP_Msk                     (0x30UL)                  /*!< ERU EXOCON: GP (Bitfield-Mask: 0x03)                        */
#define ERU_EXOCON_IPEN0_Pos                  (12UL)                    /*!< ERU EXOCON: IPEN0 (Bit 12)                                  */
#define ERU_EXOCON_IPEN0_Msk                  (0x1000UL)                /*!< ERU EXOCON: IPEN0 (Bitfield-Mask: 0x01)                     */
#define ERU_EXOCON_IPEN1_Pos                  (13UL)                    /*!< ERU EXOCON: IPEN1 (Bit 13)                                  */
#define ERU_EXOCON_IPEN1_Msk                  (0x2000UL)                /*!< ERU EXOCON: IPEN1 (Bitfield-Mask: 0x01)                     */
#define ERU_EXOCON_IPEN2_Pos                  (14UL)                    /*!< ERU EXOCON: IPEN2 (Bit 14)                                  */
#define ERU_EXOCON_IPEN2_Msk                  (0x4000UL)                /*!< ERU EXOCON: IPEN2 (Bitfield-Mask: 0x01)                     */
#define ERU_EXOCON_IPEN3_Pos                  (15UL)                    /*!< ERU EXOCON: IPEN3 (Bit 15)                                  */
#define ERU_EXOCON_IPEN3_Msk                  (0x8000UL)                /*!< ERU EXOCON: IPEN3 (Bitfield-Mask: 0x01)                     */


/* ================================================================================ */
/* ================         struct 'GPDMA0' Position & Mask        ================ */
/* ================================================================================ */


/* --------------------------------  GPDMA0_RAWTFR  ------------------------------- */
#define GPDMA0_RAWTFR_CH0_Pos                 (0UL)                     /*!< GPDMA0 RAWTFR: CH0 (Bit 0)                                  */
#define GPDMA0_RAWTFR_CH0_Msk                 (0x1UL)                   /*!< GPDMA0 RAWTFR: CH0 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWTFR_CH1_Pos                 (1UL)                     /*!< GPDMA0 RAWTFR: CH1 (Bit 1)                                  */
#define GPDMA0_RAWTFR_CH1_Msk                 (0x2UL)                   /*!< GPDMA0 RAWTFR: CH1 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWTFR_CH2_Pos                 (2UL)                     /*!< GPDMA0 RAWTFR: CH2 (Bit 2)                                  */
#define GPDMA0_RAWTFR_CH2_Msk                 (0x4UL)                   /*!< GPDMA0 RAWTFR: CH2 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWTFR_CH3_Pos                 (3UL)                     /*!< GPDMA0 RAWTFR: CH3 (Bit 3)                                  */
#define GPDMA0_RAWTFR_CH3_Msk                 (0x8UL)                   /*!< GPDMA0 RAWTFR: CH3 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWTFR_CH4_Pos                 (4UL)                     /*!< GPDMA0 RAWTFR: CH4 (Bit 4)                                  */
#define GPDMA0_RAWTFR_CH4_Msk                 (0x10UL)                  /*!< GPDMA0 RAWTFR: CH4 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWTFR_CH5_Pos                 (5UL)                     /*!< GPDMA0 RAWTFR: CH5 (Bit 5)                                  */
#define GPDMA0_RAWTFR_CH5_Msk                 (0x20UL)                  /*!< GPDMA0 RAWTFR: CH5 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWTFR_CH6_Pos                 (6UL)                     /*!< GPDMA0 RAWTFR: CH6 (Bit 6)                                  */
#define GPDMA0_RAWTFR_CH6_Msk                 (0x40UL)                  /*!< GPDMA0 RAWTFR: CH6 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWTFR_CH7_Pos                 (7UL)                     /*!< GPDMA0 RAWTFR: CH7 (Bit 7)                                  */
#define GPDMA0_RAWTFR_CH7_Msk                 (0x80UL)                  /*!< GPDMA0 RAWTFR: CH7 (Bitfield-Mask: 0x01)                    */

/* -------------------------------  GPDMA0_RAWBLOCK  ------------------------------ */
#define GPDMA0_RAWBLOCK_CH0_Pos               (0UL)                     /*!< GPDMA0 RAWBLOCK: CH0 (Bit 0)                                */
#define GPDMA0_RAWBLOCK_CH0_Msk               (0x1UL)                   /*!< GPDMA0 RAWBLOCK: CH0 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_RAWBLOCK_CH1_Pos               (1UL)                     /*!< GPDMA0 RAWBLOCK: CH1 (Bit 1)                                */
#define GPDMA0_RAWBLOCK_CH1_Msk               (0x2UL)                   /*!< GPDMA0 RAWBLOCK: CH1 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_RAWBLOCK_CH2_Pos               (2UL)                     /*!< GPDMA0 RAWBLOCK: CH2 (Bit 2)                                */
#define GPDMA0_RAWBLOCK_CH2_Msk               (0x4UL)                   /*!< GPDMA0 RAWBLOCK: CH2 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_RAWBLOCK_CH3_Pos               (3UL)                     /*!< GPDMA0 RAWBLOCK: CH3 (Bit 3)                                */
#define GPDMA0_RAWBLOCK_CH3_Msk               (0x8UL)                   /*!< GPDMA0 RAWBLOCK: CH3 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_RAWBLOCK_CH4_Pos               (4UL)                     /*!< GPDMA0 RAWBLOCK: CH4 (Bit 4)                                */
#define GPDMA0_RAWBLOCK_CH4_Msk               (0x10UL)                  /*!< GPDMA0 RAWBLOCK: CH4 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_RAWBLOCK_CH5_Pos               (5UL)                     /*!< GPDMA0 RAWBLOCK: CH5 (Bit 5)                                */
#define GPDMA0_RAWBLOCK_CH5_Msk               (0x20UL)                  /*!< GPDMA0 RAWBLOCK: CH5 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_RAWBLOCK_CH6_Pos               (6UL)                     /*!< GPDMA0 RAWBLOCK: CH6 (Bit 6)                                */
#define GPDMA0_RAWBLOCK_CH6_Msk               (0x40UL)                  /*!< GPDMA0 RAWBLOCK: CH6 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_RAWBLOCK_CH7_Pos               (7UL)                     /*!< GPDMA0 RAWBLOCK: CH7 (Bit 7)                                */
#define GPDMA0_RAWBLOCK_CH7_Msk               (0x80UL)                  /*!< GPDMA0 RAWBLOCK: CH7 (Bitfield-Mask: 0x01)                  */

/* ------------------------------  GPDMA0_RAWSRCTRAN  ----------------------------- */
#define GPDMA0_RAWSRCTRAN_CH0_Pos             (0UL)                     /*!< GPDMA0 RAWSRCTRAN: CH0 (Bit 0)                              */
#define GPDMA0_RAWSRCTRAN_CH0_Msk             (0x1UL)                   /*!< GPDMA0 RAWSRCTRAN: CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWSRCTRAN_CH1_Pos             (1UL)                     /*!< GPDMA0 RAWSRCTRAN: CH1 (Bit 1)                              */
#define GPDMA0_RAWSRCTRAN_CH1_Msk             (0x2UL)                   /*!< GPDMA0 RAWSRCTRAN: CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWSRCTRAN_CH2_Pos             (2UL)                     /*!< GPDMA0 RAWSRCTRAN: CH2 (Bit 2)                              */
#define GPDMA0_RAWSRCTRAN_CH2_Msk             (0x4UL)                   /*!< GPDMA0 RAWSRCTRAN: CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWSRCTRAN_CH3_Pos             (3UL)                     /*!< GPDMA0 RAWSRCTRAN: CH3 (Bit 3)                              */
#define GPDMA0_RAWSRCTRAN_CH3_Msk             (0x8UL)                   /*!< GPDMA0 RAWSRCTRAN: CH3 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWSRCTRAN_CH4_Pos             (4UL)                     /*!< GPDMA0 RAWSRCTRAN: CH4 (Bit 4)                              */
#define GPDMA0_RAWSRCTRAN_CH4_Msk             (0x10UL)                  /*!< GPDMA0 RAWSRCTRAN: CH4 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWSRCTRAN_CH5_Pos             (5UL)                     /*!< GPDMA0 RAWSRCTRAN: CH5 (Bit 5)                              */
#define GPDMA0_RAWSRCTRAN_CH5_Msk             (0x20UL)                  /*!< GPDMA0 RAWSRCTRAN: CH5 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWSRCTRAN_CH6_Pos             (6UL)                     /*!< GPDMA0 RAWSRCTRAN: CH6 (Bit 6)                              */
#define GPDMA0_RAWSRCTRAN_CH6_Msk             (0x40UL)                  /*!< GPDMA0 RAWSRCTRAN: CH6 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWSRCTRAN_CH7_Pos             (7UL)                     /*!< GPDMA0 RAWSRCTRAN: CH7 (Bit 7)                              */
#define GPDMA0_RAWSRCTRAN_CH7_Msk             (0x80UL)                  /*!< GPDMA0 RAWSRCTRAN: CH7 (Bitfield-Mask: 0x01)                */

/* ------------------------------  GPDMA0_RAWDSTTRAN  ----------------------------- */
#define GPDMA0_RAWDSTTRAN_CH0_Pos             (0UL)                     /*!< GPDMA0 RAWDSTTRAN: CH0 (Bit 0)                              */
#define GPDMA0_RAWDSTTRAN_CH0_Msk             (0x1UL)                   /*!< GPDMA0 RAWDSTTRAN: CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWDSTTRAN_CH1_Pos             (1UL)                     /*!< GPDMA0 RAWDSTTRAN: CH1 (Bit 1)                              */
#define GPDMA0_RAWDSTTRAN_CH1_Msk             (0x2UL)                   /*!< GPDMA0 RAWDSTTRAN: CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWDSTTRAN_CH2_Pos             (2UL)                     /*!< GPDMA0 RAWDSTTRAN: CH2 (Bit 2)                              */
#define GPDMA0_RAWDSTTRAN_CH2_Msk             (0x4UL)                   /*!< GPDMA0 RAWDSTTRAN: CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWDSTTRAN_CH3_Pos             (3UL)                     /*!< GPDMA0 RAWDSTTRAN: CH3 (Bit 3)                              */
#define GPDMA0_RAWDSTTRAN_CH3_Msk             (0x8UL)                   /*!< GPDMA0 RAWDSTTRAN: CH3 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWDSTTRAN_CH4_Pos             (4UL)                     /*!< GPDMA0 RAWDSTTRAN: CH4 (Bit 4)                              */
#define GPDMA0_RAWDSTTRAN_CH4_Msk             (0x10UL)                  /*!< GPDMA0 RAWDSTTRAN: CH4 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWDSTTRAN_CH5_Pos             (5UL)                     /*!< GPDMA0 RAWDSTTRAN: CH5 (Bit 5)                              */
#define GPDMA0_RAWDSTTRAN_CH5_Msk             (0x20UL)                  /*!< GPDMA0 RAWDSTTRAN: CH5 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWDSTTRAN_CH6_Pos             (6UL)                     /*!< GPDMA0 RAWDSTTRAN: CH6 (Bit 6)                              */
#define GPDMA0_RAWDSTTRAN_CH6_Msk             (0x40UL)                  /*!< GPDMA0 RAWDSTTRAN: CH6 (Bitfield-Mask: 0x01)                */
#define GPDMA0_RAWDSTTRAN_CH7_Pos             (7UL)                     /*!< GPDMA0 RAWDSTTRAN: CH7 (Bit 7)                              */
#define GPDMA0_RAWDSTTRAN_CH7_Msk             (0x80UL)                  /*!< GPDMA0 RAWDSTTRAN: CH7 (Bitfield-Mask: 0x01)                */

/* --------------------------------  GPDMA0_RAWERR  ------------------------------- */
#define GPDMA0_RAWERR_CH0_Pos                 (0UL)                     /*!< GPDMA0 RAWERR: CH0 (Bit 0)                                  */
#define GPDMA0_RAWERR_CH0_Msk                 (0x1UL)                   /*!< GPDMA0 RAWERR: CH0 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWERR_CH1_Pos                 (1UL)                     /*!< GPDMA0 RAWERR: CH1 (Bit 1)                                  */
#define GPDMA0_RAWERR_CH1_Msk                 (0x2UL)                   /*!< GPDMA0 RAWERR: CH1 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWERR_CH2_Pos                 (2UL)                     /*!< GPDMA0 RAWERR: CH2 (Bit 2)                                  */
#define GPDMA0_RAWERR_CH2_Msk                 (0x4UL)                   /*!< GPDMA0 RAWERR: CH2 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWERR_CH3_Pos                 (3UL)                     /*!< GPDMA0 RAWERR: CH3 (Bit 3)                                  */
#define GPDMA0_RAWERR_CH3_Msk                 (0x8UL)                   /*!< GPDMA0 RAWERR: CH3 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWERR_CH4_Pos                 (4UL)                     /*!< GPDMA0 RAWERR: CH4 (Bit 4)                                  */
#define GPDMA0_RAWERR_CH4_Msk                 (0x10UL)                  /*!< GPDMA0 RAWERR: CH4 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWERR_CH5_Pos                 (5UL)                     /*!< GPDMA0 RAWERR: CH5 (Bit 5)                                  */
#define GPDMA0_RAWERR_CH5_Msk                 (0x20UL)                  /*!< GPDMA0 RAWERR: CH5 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWERR_CH6_Pos                 (6UL)                     /*!< GPDMA0 RAWERR: CH6 (Bit 6)                                  */
#define GPDMA0_RAWERR_CH6_Msk                 (0x40UL)                  /*!< GPDMA0 RAWERR: CH6 (Bitfield-Mask: 0x01)                    */
#define GPDMA0_RAWERR_CH7_Pos                 (7UL)                     /*!< GPDMA0 RAWERR: CH7 (Bit 7)                                  */
#define GPDMA0_RAWERR_CH7_Msk                 (0x80UL)                  /*!< GPDMA0 RAWERR: CH7 (Bitfield-Mask: 0x01)                    */

/* ------------------------------  GPDMA0_STATUSTFR  ------------------------------ */
#define GPDMA0_STATUSTFR_CH0_Pos              (0UL)                     /*!< GPDMA0 STATUSTFR: CH0 (Bit 0)                               */
#define GPDMA0_STATUSTFR_CH0_Msk              (0x1UL)                   /*!< GPDMA0 STATUSTFR: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSTFR_CH1_Pos              (1UL)                     /*!< GPDMA0 STATUSTFR: CH1 (Bit 1)                               */
#define GPDMA0_STATUSTFR_CH1_Msk              (0x2UL)                   /*!< GPDMA0 STATUSTFR: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSTFR_CH2_Pos              (2UL)                     /*!< GPDMA0 STATUSTFR: CH2 (Bit 2)                               */
#define GPDMA0_STATUSTFR_CH2_Msk              (0x4UL)                   /*!< GPDMA0 STATUSTFR: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSTFR_CH3_Pos              (3UL)                     /*!< GPDMA0 STATUSTFR: CH3 (Bit 3)                               */
#define GPDMA0_STATUSTFR_CH3_Msk              (0x8UL)                   /*!< GPDMA0 STATUSTFR: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSTFR_CH4_Pos              (4UL)                     /*!< GPDMA0 STATUSTFR: CH4 (Bit 4)                               */
#define GPDMA0_STATUSTFR_CH4_Msk              (0x10UL)                  /*!< GPDMA0 STATUSTFR: CH4 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSTFR_CH5_Pos              (5UL)                     /*!< GPDMA0 STATUSTFR: CH5 (Bit 5)                               */
#define GPDMA0_STATUSTFR_CH5_Msk              (0x20UL)                  /*!< GPDMA0 STATUSTFR: CH5 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSTFR_CH6_Pos              (6UL)                     /*!< GPDMA0 STATUSTFR: CH6 (Bit 6)                               */
#define GPDMA0_STATUSTFR_CH6_Msk              (0x40UL)                  /*!< GPDMA0 STATUSTFR: CH6 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSTFR_CH7_Pos              (7UL)                     /*!< GPDMA0 STATUSTFR: CH7 (Bit 7)                               */
#define GPDMA0_STATUSTFR_CH7_Msk              (0x80UL)                  /*!< GPDMA0 STATUSTFR: CH7 (Bitfield-Mask: 0x01)                 */

/* -----------------------------  GPDMA0_STATUSBLOCK  ----------------------------- */
#define GPDMA0_STATUSBLOCK_CH0_Pos            (0UL)                     /*!< GPDMA0 STATUSBLOCK: CH0 (Bit 0)                             */
#define GPDMA0_STATUSBLOCK_CH0_Msk            (0x1UL)                   /*!< GPDMA0 STATUSBLOCK: CH0 (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSBLOCK_CH1_Pos            (1UL)                     /*!< GPDMA0 STATUSBLOCK: CH1 (Bit 1)                             */
#define GPDMA0_STATUSBLOCK_CH1_Msk            (0x2UL)                   /*!< GPDMA0 STATUSBLOCK: CH1 (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSBLOCK_CH2_Pos            (2UL)                     /*!< GPDMA0 STATUSBLOCK: CH2 (Bit 2)                             */
#define GPDMA0_STATUSBLOCK_CH2_Msk            (0x4UL)                   /*!< GPDMA0 STATUSBLOCK: CH2 (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSBLOCK_CH3_Pos            (3UL)                     /*!< GPDMA0 STATUSBLOCK: CH3 (Bit 3)                             */
#define GPDMA0_STATUSBLOCK_CH3_Msk            (0x8UL)                   /*!< GPDMA0 STATUSBLOCK: CH3 (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSBLOCK_CH4_Pos            (4UL)                     /*!< GPDMA0 STATUSBLOCK: CH4 (Bit 4)                             */
#define GPDMA0_STATUSBLOCK_CH4_Msk            (0x10UL)                  /*!< GPDMA0 STATUSBLOCK: CH4 (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSBLOCK_CH5_Pos            (5UL)                     /*!< GPDMA0 STATUSBLOCK: CH5 (Bit 5)                             */
#define GPDMA0_STATUSBLOCK_CH5_Msk            (0x20UL)                  /*!< GPDMA0 STATUSBLOCK: CH5 (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSBLOCK_CH6_Pos            (6UL)                     /*!< GPDMA0 STATUSBLOCK: CH6 (Bit 6)                             */
#define GPDMA0_STATUSBLOCK_CH6_Msk            (0x40UL)                  /*!< GPDMA0 STATUSBLOCK: CH6 (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSBLOCK_CH7_Pos            (7UL)                     /*!< GPDMA0 STATUSBLOCK: CH7 (Bit 7)                             */
#define GPDMA0_STATUSBLOCK_CH7_Msk            (0x80UL)                  /*!< GPDMA0 STATUSBLOCK: CH7 (Bitfield-Mask: 0x01)               */

/* ----------------------------  GPDMA0_STATUSSRCTRAN  ---------------------------- */
#define GPDMA0_STATUSSRCTRAN_CH0_Pos          (0UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH0 (Bit 0)                           */
#define GPDMA0_STATUSSRCTRAN_CH0_Msk          (0x1UL)                   /*!< GPDMA0 STATUSSRCTRAN: CH0 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSSRCTRAN_CH1_Pos          (1UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH1 (Bit 1)                           */
#define GPDMA0_STATUSSRCTRAN_CH1_Msk          (0x2UL)                   /*!< GPDMA0 STATUSSRCTRAN: CH1 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSSRCTRAN_CH2_Pos          (2UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH2 (Bit 2)                           */
#define GPDMA0_STATUSSRCTRAN_CH2_Msk          (0x4UL)                   /*!< GPDMA0 STATUSSRCTRAN: CH2 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSSRCTRAN_CH3_Pos          (3UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH3 (Bit 3)                           */
#define GPDMA0_STATUSSRCTRAN_CH3_Msk          (0x8UL)                   /*!< GPDMA0 STATUSSRCTRAN: CH3 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSSRCTRAN_CH4_Pos          (4UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH4 (Bit 4)                           */
#define GPDMA0_STATUSSRCTRAN_CH4_Msk          (0x10UL)                  /*!< GPDMA0 STATUSSRCTRAN: CH4 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSSRCTRAN_CH5_Pos          (5UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH5 (Bit 5)                           */
#define GPDMA0_STATUSSRCTRAN_CH5_Msk          (0x20UL)                  /*!< GPDMA0 STATUSSRCTRAN: CH5 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSSRCTRAN_CH6_Pos          (6UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH6 (Bit 6)                           */
#define GPDMA0_STATUSSRCTRAN_CH6_Msk          (0x40UL)                  /*!< GPDMA0 STATUSSRCTRAN: CH6 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSSRCTRAN_CH7_Pos          (7UL)                     /*!< GPDMA0 STATUSSRCTRAN: CH7 (Bit 7)                           */
#define GPDMA0_STATUSSRCTRAN_CH7_Msk          (0x80UL)                  /*!< GPDMA0 STATUSSRCTRAN: CH7 (Bitfield-Mask: 0x01)             */

/* ----------------------------  GPDMA0_STATUSDSTTRAN  ---------------------------- */
#define GPDMA0_STATUSDSTTRAN_CH0_Pos          (0UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH0 (Bit 0)                           */
#define GPDMA0_STATUSDSTTRAN_CH0_Msk          (0x1UL)                   /*!< GPDMA0 STATUSDSTTRAN: CH0 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSDSTTRAN_CH1_Pos          (1UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH1 (Bit 1)                           */
#define GPDMA0_STATUSDSTTRAN_CH1_Msk          (0x2UL)                   /*!< GPDMA0 STATUSDSTTRAN: CH1 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSDSTTRAN_CH2_Pos          (2UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH2 (Bit 2)                           */
#define GPDMA0_STATUSDSTTRAN_CH2_Msk          (0x4UL)                   /*!< GPDMA0 STATUSDSTTRAN: CH2 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSDSTTRAN_CH3_Pos          (3UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH3 (Bit 3)                           */
#define GPDMA0_STATUSDSTTRAN_CH3_Msk          (0x8UL)                   /*!< GPDMA0 STATUSDSTTRAN: CH3 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSDSTTRAN_CH4_Pos          (4UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH4 (Bit 4)                           */
#define GPDMA0_STATUSDSTTRAN_CH4_Msk          (0x10UL)                  /*!< GPDMA0 STATUSDSTTRAN: CH4 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSDSTTRAN_CH5_Pos          (5UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH5 (Bit 5)                           */
#define GPDMA0_STATUSDSTTRAN_CH5_Msk          (0x20UL)                  /*!< GPDMA0 STATUSDSTTRAN: CH5 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSDSTTRAN_CH6_Pos          (6UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH6 (Bit 6)                           */
#define GPDMA0_STATUSDSTTRAN_CH6_Msk          (0x40UL)                  /*!< GPDMA0 STATUSDSTTRAN: CH6 (Bitfield-Mask: 0x01)             */
#define GPDMA0_STATUSDSTTRAN_CH7_Pos          (7UL)                     /*!< GPDMA0 STATUSDSTTRAN: CH7 (Bit 7)                           */
#define GPDMA0_STATUSDSTTRAN_CH7_Msk          (0x80UL)                  /*!< GPDMA0 STATUSDSTTRAN: CH7 (Bitfield-Mask: 0x01)             */

/* ------------------------------  GPDMA0_STATUSERR  ------------------------------ */
#define GPDMA0_STATUSERR_CH0_Pos              (0UL)                     /*!< GPDMA0 STATUSERR: CH0 (Bit 0)                               */
#define GPDMA0_STATUSERR_CH0_Msk              (0x1UL)                   /*!< GPDMA0 STATUSERR: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSERR_CH1_Pos              (1UL)                     /*!< GPDMA0 STATUSERR: CH1 (Bit 1)                               */
#define GPDMA0_STATUSERR_CH1_Msk              (0x2UL)                   /*!< GPDMA0 STATUSERR: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSERR_CH2_Pos              (2UL)                     /*!< GPDMA0 STATUSERR: CH2 (Bit 2)                               */
#define GPDMA0_STATUSERR_CH2_Msk              (0x4UL)                   /*!< GPDMA0 STATUSERR: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSERR_CH3_Pos              (3UL)                     /*!< GPDMA0 STATUSERR: CH3 (Bit 3)                               */
#define GPDMA0_STATUSERR_CH3_Msk              (0x8UL)                   /*!< GPDMA0 STATUSERR: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSERR_CH4_Pos              (4UL)                     /*!< GPDMA0 STATUSERR: CH4 (Bit 4)                               */
#define GPDMA0_STATUSERR_CH4_Msk              (0x10UL)                  /*!< GPDMA0 STATUSERR: CH4 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSERR_CH5_Pos              (5UL)                     /*!< GPDMA0 STATUSERR: CH5 (Bit 5)                               */
#define GPDMA0_STATUSERR_CH5_Msk              (0x20UL)                  /*!< GPDMA0 STATUSERR: CH5 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSERR_CH6_Pos              (6UL)                     /*!< GPDMA0 STATUSERR: CH6 (Bit 6)                               */
#define GPDMA0_STATUSERR_CH6_Msk              (0x40UL)                  /*!< GPDMA0 STATUSERR: CH6 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSERR_CH7_Pos              (7UL)                     /*!< GPDMA0 STATUSERR: CH7 (Bit 7)                               */
#define GPDMA0_STATUSERR_CH7_Msk              (0x80UL)                  /*!< GPDMA0 STATUSERR: CH7 (Bitfield-Mask: 0x01)                 */

/* -------------------------------  GPDMA0_MASKTFR  ------------------------------- */
#define GPDMA0_MASKTFR_CH0_Pos                (0UL)                     /*!< GPDMA0 MASKTFR: CH0 (Bit 0)                                 */
#define GPDMA0_MASKTFR_CH0_Msk                (0x1UL)                   /*!< GPDMA0 MASKTFR: CH0 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_CH1_Pos                (1UL)                     /*!< GPDMA0 MASKTFR: CH1 (Bit 1)                                 */
#define GPDMA0_MASKTFR_CH1_Msk                (0x2UL)                   /*!< GPDMA0 MASKTFR: CH1 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_CH2_Pos                (2UL)                     /*!< GPDMA0 MASKTFR: CH2 (Bit 2)                                 */
#define GPDMA0_MASKTFR_CH2_Msk                (0x4UL)                   /*!< GPDMA0 MASKTFR: CH2 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_CH3_Pos                (3UL)                     /*!< GPDMA0 MASKTFR: CH3 (Bit 3)                                 */
#define GPDMA0_MASKTFR_CH3_Msk                (0x8UL)                   /*!< GPDMA0 MASKTFR: CH3 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_CH4_Pos                (4UL)                     /*!< GPDMA0 MASKTFR: CH4 (Bit 4)                                 */
#define GPDMA0_MASKTFR_CH4_Msk                (0x10UL)                  /*!< GPDMA0 MASKTFR: CH4 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_CH5_Pos                (5UL)                     /*!< GPDMA0 MASKTFR: CH5 (Bit 5)                                 */
#define GPDMA0_MASKTFR_CH5_Msk                (0x20UL)                  /*!< GPDMA0 MASKTFR: CH5 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_CH6_Pos                (6UL)                     /*!< GPDMA0 MASKTFR: CH6 (Bit 6)                                 */
#define GPDMA0_MASKTFR_CH6_Msk                (0x40UL)                  /*!< GPDMA0 MASKTFR: CH6 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_CH7_Pos                (7UL)                     /*!< GPDMA0 MASKTFR: CH7 (Bit 7)                                 */
#define GPDMA0_MASKTFR_CH7_Msk                (0x80UL)                  /*!< GPDMA0 MASKTFR: CH7 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKTFR_WE_CH0_Pos             (8UL)                     /*!< GPDMA0 MASKTFR: WE_CH0 (Bit 8)                              */
#define GPDMA0_MASKTFR_WE_CH0_Msk             (0x100UL)                 /*!< GPDMA0 MASKTFR: WE_CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKTFR_WE_CH1_Pos             (9UL)                     /*!< GPDMA0 MASKTFR: WE_CH1 (Bit 9)                              */
#define GPDMA0_MASKTFR_WE_CH1_Msk             (0x200UL)                 /*!< GPDMA0 MASKTFR: WE_CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKTFR_WE_CH2_Pos             (10UL)                    /*!< GPDMA0 MASKTFR: WE_CH2 (Bit 10)                             */
#define GPDMA0_MASKTFR_WE_CH2_Msk             (0x400UL)                 /*!< GPDMA0 MASKTFR: WE_CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKTFR_WE_CH3_Pos             (11UL)                    /*!< GPDMA0 MASKTFR: WE_CH3 (Bit 11)                             */
#define GPDMA0_MASKTFR_WE_CH3_Msk             (0x800UL)                 /*!< GPDMA0 MASKTFR: WE_CH3 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKTFR_WE_CH4_Pos             (12UL)                    /*!< GPDMA0 MASKTFR: WE_CH4 (Bit 12)                             */
#define GPDMA0_MASKTFR_WE_CH4_Msk             (0x1000UL)                /*!< GPDMA0 MASKTFR: WE_CH4 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKTFR_WE_CH5_Pos             (13UL)                    /*!< GPDMA0 MASKTFR: WE_CH5 (Bit 13)                             */
#define GPDMA0_MASKTFR_WE_CH5_Msk             (0x2000UL)                /*!< GPDMA0 MASKTFR: WE_CH5 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKTFR_WE_CH6_Pos             (14UL)                    /*!< GPDMA0 MASKTFR: WE_CH6 (Bit 14)                             */
#define GPDMA0_MASKTFR_WE_CH6_Msk             (0x4000UL)                /*!< GPDMA0 MASKTFR: WE_CH6 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKTFR_WE_CH7_Pos             (15UL)                    /*!< GPDMA0 MASKTFR: WE_CH7 (Bit 15)                             */
#define GPDMA0_MASKTFR_WE_CH7_Msk             (0x8000UL)                /*!< GPDMA0 MASKTFR: WE_CH7 (Bitfield-Mask: 0x01)                */

/* ------------------------------  GPDMA0_MASKBLOCK  ------------------------------ */
#define GPDMA0_MASKBLOCK_CH0_Pos              (0UL)                     /*!< GPDMA0 MASKBLOCK: CH0 (Bit 0)                               */
#define GPDMA0_MASKBLOCK_CH0_Msk              (0x1UL)                   /*!< GPDMA0 MASKBLOCK: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_CH1_Pos              (1UL)                     /*!< GPDMA0 MASKBLOCK: CH1 (Bit 1)                               */
#define GPDMA0_MASKBLOCK_CH1_Msk              (0x2UL)                   /*!< GPDMA0 MASKBLOCK: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_CH2_Pos              (2UL)                     /*!< GPDMA0 MASKBLOCK: CH2 (Bit 2)                               */
#define GPDMA0_MASKBLOCK_CH2_Msk              (0x4UL)                   /*!< GPDMA0 MASKBLOCK: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_CH3_Pos              (3UL)                     /*!< GPDMA0 MASKBLOCK: CH3 (Bit 3)                               */
#define GPDMA0_MASKBLOCK_CH3_Msk              (0x8UL)                   /*!< GPDMA0 MASKBLOCK: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_CH4_Pos              (4UL)                     /*!< GPDMA0 MASKBLOCK: CH4 (Bit 4)                               */
#define GPDMA0_MASKBLOCK_CH4_Msk              (0x10UL)                  /*!< GPDMA0 MASKBLOCK: CH4 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_CH5_Pos              (5UL)                     /*!< GPDMA0 MASKBLOCK: CH5 (Bit 5)                               */
#define GPDMA0_MASKBLOCK_CH5_Msk              (0x20UL)                  /*!< GPDMA0 MASKBLOCK: CH5 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_CH6_Pos              (6UL)                     /*!< GPDMA0 MASKBLOCK: CH6 (Bit 6)                               */
#define GPDMA0_MASKBLOCK_CH6_Msk              (0x40UL)                  /*!< GPDMA0 MASKBLOCK: CH6 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_CH7_Pos              (7UL)                     /*!< GPDMA0 MASKBLOCK: CH7 (Bit 7)                               */
#define GPDMA0_MASKBLOCK_CH7_Msk              (0x80UL)                  /*!< GPDMA0 MASKBLOCK: CH7 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_MASKBLOCK_WE_CH0_Pos           (8UL)                     /*!< GPDMA0 MASKBLOCK: WE_CH0 (Bit 8)                            */
#define GPDMA0_MASKBLOCK_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA0 MASKBLOCK: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_MASKBLOCK_WE_CH1_Pos           (9UL)                     /*!< GPDMA0 MASKBLOCK: WE_CH1 (Bit 9)                            */
#define GPDMA0_MASKBLOCK_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA0 MASKBLOCK: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_MASKBLOCK_WE_CH2_Pos           (10UL)                    /*!< GPDMA0 MASKBLOCK: WE_CH2 (Bit 10)                           */
#define GPDMA0_MASKBLOCK_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA0 MASKBLOCK: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_MASKBLOCK_WE_CH3_Pos           (11UL)                    /*!< GPDMA0 MASKBLOCK: WE_CH3 (Bit 11)                           */
#define GPDMA0_MASKBLOCK_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA0 MASKBLOCK: WE_CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_MASKBLOCK_WE_CH4_Pos           (12UL)                    /*!< GPDMA0 MASKBLOCK: WE_CH4 (Bit 12)                           */
#define GPDMA0_MASKBLOCK_WE_CH4_Msk           (0x1000UL)                /*!< GPDMA0 MASKBLOCK: WE_CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_MASKBLOCK_WE_CH5_Pos           (13UL)                    /*!< GPDMA0 MASKBLOCK: WE_CH5 (Bit 13)                           */
#define GPDMA0_MASKBLOCK_WE_CH5_Msk           (0x2000UL)                /*!< GPDMA0 MASKBLOCK: WE_CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_MASKBLOCK_WE_CH6_Pos           (14UL)                    /*!< GPDMA0 MASKBLOCK: WE_CH6 (Bit 14)                           */
#define GPDMA0_MASKBLOCK_WE_CH6_Msk           (0x4000UL)                /*!< GPDMA0 MASKBLOCK: WE_CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_MASKBLOCK_WE_CH7_Pos           (15UL)                    /*!< GPDMA0 MASKBLOCK: WE_CH7 (Bit 15)                           */
#define GPDMA0_MASKBLOCK_WE_CH7_Msk           (0x8000UL)                /*!< GPDMA0 MASKBLOCK: WE_CH7 (Bitfield-Mask: 0x01)              */

/* -----------------------------  GPDMA0_MASKSRCTRAN  ----------------------------- */
#define GPDMA0_MASKSRCTRAN_CH0_Pos            (0UL)                     /*!< GPDMA0 MASKSRCTRAN: CH0 (Bit 0)                             */
#define GPDMA0_MASKSRCTRAN_CH0_Msk            (0x1UL)                   /*!< GPDMA0 MASKSRCTRAN: CH0 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_CH1_Pos            (1UL)                     /*!< GPDMA0 MASKSRCTRAN: CH1 (Bit 1)                             */
#define GPDMA0_MASKSRCTRAN_CH1_Msk            (0x2UL)                   /*!< GPDMA0 MASKSRCTRAN: CH1 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_CH2_Pos            (2UL)                     /*!< GPDMA0 MASKSRCTRAN: CH2 (Bit 2)                             */
#define GPDMA0_MASKSRCTRAN_CH2_Msk            (0x4UL)                   /*!< GPDMA0 MASKSRCTRAN: CH2 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_CH3_Pos            (3UL)                     /*!< GPDMA0 MASKSRCTRAN: CH3 (Bit 3)                             */
#define GPDMA0_MASKSRCTRAN_CH3_Msk            (0x8UL)                   /*!< GPDMA0 MASKSRCTRAN: CH3 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_CH4_Pos            (4UL)                     /*!< GPDMA0 MASKSRCTRAN: CH4 (Bit 4)                             */
#define GPDMA0_MASKSRCTRAN_CH4_Msk            (0x10UL)                  /*!< GPDMA0 MASKSRCTRAN: CH4 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_CH5_Pos            (5UL)                     /*!< GPDMA0 MASKSRCTRAN: CH5 (Bit 5)                             */
#define GPDMA0_MASKSRCTRAN_CH5_Msk            (0x20UL)                  /*!< GPDMA0 MASKSRCTRAN: CH5 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_CH6_Pos            (6UL)                     /*!< GPDMA0 MASKSRCTRAN: CH6 (Bit 6)                             */
#define GPDMA0_MASKSRCTRAN_CH6_Msk            (0x40UL)                  /*!< GPDMA0 MASKSRCTRAN: CH6 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_CH7_Pos            (7UL)                     /*!< GPDMA0 MASKSRCTRAN: CH7 (Bit 7)                             */
#define GPDMA0_MASKSRCTRAN_CH7_Msk            (0x80UL)                  /*!< GPDMA0 MASKSRCTRAN: CH7 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKSRCTRAN_WE_CH0_Pos         (8UL)                     /*!< GPDMA0 MASKSRCTRAN: WE_CH0 (Bit 8)                          */
#define GPDMA0_MASKSRCTRAN_WE_CH0_Msk         (0x100UL)                 /*!< GPDMA0 MASKSRCTRAN: WE_CH0 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKSRCTRAN_WE_CH1_Pos         (9UL)                     /*!< GPDMA0 MASKSRCTRAN: WE_CH1 (Bit 9)                          */
#define GPDMA0_MASKSRCTRAN_WE_CH1_Msk         (0x200UL)                 /*!< GPDMA0 MASKSRCTRAN: WE_CH1 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKSRCTRAN_WE_CH2_Pos         (10UL)                    /*!< GPDMA0 MASKSRCTRAN: WE_CH2 (Bit 10)                         */
#define GPDMA0_MASKSRCTRAN_WE_CH2_Msk         (0x400UL)                 /*!< GPDMA0 MASKSRCTRAN: WE_CH2 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKSRCTRAN_WE_CH3_Pos         (11UL)                    /*!< GPDMA0 MASKSRCTRAN: WE_CH3 (Bit 11)                         */
#define GPDMA0_MASKSRCTRAN_WE_CH3_Msk         (0x800UL)                 /*!< GPDMA0 MASKSRCTRAN: WE_CH3 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKSRCTRAN_WE_CH4_Pos         (12UL)                    /*!< GPDMA0 MASKSRCTRAN: WE_CH4 (Bit 12)                         */
#define GPDMA0_MASKSRCTRAN_WE_CH4_Msk         (0x1000UL)                /*!< GPDMA0 MASKSRCTRAN: WE_CH4 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKSRCTRAN_WE_CH5_Pos         (13UL)                    /*!< GPDMA0 MASKSRCTRAN: WE_CH5 (Bit 13)                         */
#define GPDMA0_MASKSRCTRAN_WE_CH5_Msk         (0x2000UL)                /*!< GPDMA0 MASKSRCTRAN: WE_CH5 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKSRCTRAN_WE_CH6_Pos         (14UL)                    /*!< GPDMA0 MASKSRCTRAN: WE_CH6 (Bit 14)                         */
#define GPDMA0_MASKSRCTRAN_WE_CH6_Msk         (0x4000UL)                /*!< GPDMA0 MASKSRCTRAN: WE_CH6 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKSRCTRAN_WE_CH7_Pos         (15UL)                    /*!< GPDMA0 MASKSRCTRAN: WE_CH7 (Bit 15)                         */
#define GPDMA0_MASKSRCTRAN_WE_CH7_Msk         (0x8000UL)                /*!< GPDMA0 MASKSRCTRAN: WE_CH7 (Bitfield-Mask: 0x01)            */

/* -----------------------------  GPDMA0_MASKDSTTRAN  ----------------------------- */
#define GPDMA0_MASKDSTTRAN_CH0_Pos            (0UL)                     /*!< GPDMA0 MASKDSTTRAN: CH0 (Bit 0)                             */
#define GPDMA0_MASKDSTTRAN_CH0_Msk            (0x1UL)                   /*!< GPDMA0 MASKDSTTRAN: CH0 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_CH1_Pos            (1UL)                     /*!< GPDMA0 MASKDSTTRAN: CH1 (Bit 1)                             */
#define GPDMA0_MASKDSTTRAN_CH1_Msk            (0x2UL)                   /*!< GPDMA0 MASKDSTTRAN: CH1 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_CH2_Pos            (2UL)                     /*!< GPDMA0 MASKDSTTRAN: CH2 (Bit 2)                             */
#define GPDMA0_MASKDSTTRAN_CH2_Msk            (0x4UL)                   /*!< GPDMA0 MASKDSTTRAN: CH2 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_CH3_Pos            (3UL)                     /*!< GPDMA0 MASKDSTTRAN: CH3 (Bit 3)                             */
#define GPDMA0_MASKDSTTRAN_CH3_Msk            (0x8UL)                   /*!< GPDMA0 MASKDSTTRAN: CH3 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_CH4_Pos            (4UL)                     /*!< GPDMA0 MASKDSTTRAN: CH4 (Bit 4)                             */
#define GPDMA0_MASKDSTTRAN_CH4_Msk            (0x10UL)                  /*!< GPDMA0 MASKDSTTRAN: CH4 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_CH5_Pos            (5UL)                     /*!< GPDMA0 MASKDSTTRAN: CH5 (Bit 5)                             */
#define GPDMA0_MASKDSTTRAN_CH5_Msk            (0x20UL)                  /*!< GPDMA0 MASKDSTTRAN: CH5 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_CH6_Pos            (6UL)                     /*!< GPDMA0 MASKDSTTRAN: CH6 (Bit 6)                             */
#define GPDMA0_MASKDSTTRAN_CH6_Msk            (0x40UL)                  /*!< GPDMA0 MASKDSTTRAN: CH6 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_CH7_Pos            (7UL)                     /*!< GPDMA0 MASKDSTTRAN: CH7 (Bit 7)                             */
#define GPDMA0_MASKDSTTRAN_CH7_Msk            (0x80UL)                  /*!< GPDMA0 MASKDSTTRAN: CH7 (Bitfield-Mask: 0x01)               */
#define GPDMA0_MASKDSTTRAN_WE_CH0_Pos         (8UL)                     /*!< GPDMA0 MASKDSTTRAN: WE_CH0 (Bit 8)                          */
#define GPDMA0_MASKDSTTRAN_WE_CH0_Msk         (0x100UL)                 /*!< GPDMA0 MASKDSTTRAN: WE_CH0 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKDSTTRAN_WE_CH1_Pos         (9UL)                     /*!< GPDMA0 MASKDSTTRAN: WE_CH1 (Bit 9)                          */
#define GPDMA0_MASKDSTTRAN_WE_CH1_Msk         (0x200UL)                 /*!< GPDMA0 MASKDSTTRAN: WE_CH1 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKDSTTRAN_WE_CH2_Pos         (10UL)                    /*!< GPDMA0 MASKDSTTRAN: WE_CH2 (Bit 10)                         */
#define GPDMA0_MASKDSTTRAN_WE_CH2_Msk         (0x400UL)                 /*!< GPDMA0 MASKDSTTRAN: WE_CH2 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKDSTTRAN_WE_CH3_Pos         (11UL)                    /*!< GPDMA0 MASKDSTTRAN: WE_CH3 (Bit 11)                         */
#define GPDMA0_MASKDSTTRAN_WE_CH3_Msk         (0x800UL)                 /*!< GPDMA0 MASKDSTTRAN: WE_CH3 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKDSTTRAN_WE_CH4_Pos         (12UL)                    /*!< GPDMA0 MASKDSTTRAN: WE_CH4 (Bit 12)                         */
#define GPDMA0_MASKDSTTRAN_WE_CH4_Msk         (0x1000UL)                /*!< GPDMA0 MASKDSTTRAN: WE_CH4 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKDSTTRAN_WE_CH5_Pos         (13UL)                    /*!< GPDMA0 MASKDSTTRAN: WE_CH5 (Bit 13)                         */
#define GPDMA0_MASKDSTTRAN_WE_CH5_Msk         (0x2000UL)                /*!< GPDMA0 MASKDSTTRAN: WE_CH5 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKDSTTRAN_WE_CH6_Pos         (14UL)                    /*!< GPDMA0 MASKDSTTRAN: WE_CH6 (Bit 14)                         */
#define GPDMA0_MASKDSTTRAN_WE_CH6_Msk         (0x4000UL)                /*!< GPDMA0 MASKDSTTRAN: WE_CH6 (Bitfield-Mask: 0x01)            */
#define GPDMA0_MASKDSTTRAN_WE_CH7_Pos         (15UL)                    /*!< GPDMA0 MASKDSTTRAN: WE_CH7 (Bit 15)                         */
#define GPDMA0_MASKDSTTRAN_WE_CH7_Msk         (0x8000UL)                /*!< GPDMA0 MASKDSTTRAN: WE_CH7 (Bitfield-Mask: 0x01)            */

/* -------------------------------  GPDMA0_MASKERR  ------------------------------- */
#define GPDMA0_MASKERR_CH0_Pos                (0UL)                     /*!< GPDMA0 MASKERR: CH0 (Bit 0)                                 */
#define GPDMA0_MASKERR_CH0_Msk                (0x1UL)                   /*!< GPDMA0 MASKERR: CH0 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_CH1_Pos                (1UL)                     /*!< GPDMA0 MASKERR: CH1 (Bit 1)                                 */
#define GPDMA0_MASKERR_CH1_Msk                (0x2UL)                   /*!< GPDMA0 MASKERR: CH1 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_CH2_Pos                (2UL)                     /*!< GPDMA0 MASKERR: CH2 (Bit 2)                                 */
#define GPDMA0_MASKERR_CH2_Msk                (0x4UL)                   /*!< GPDMA0 MASKERR: CH2 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_CH3_Pos                (3UL)                     /*!< GPDMA0 MASKERR: CH3 (Bit 3)                                 */
#define GPDMA0_MASKERR_CH3_Msk                (0x8UL)                   /*!< GPDMA0 MASKERR: CH3 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_CH4_Pos                (4UL)                     /*!< GPDMA0 MASKERR: CH4 (Bit 4)                                 */
#define GPDMA0_MASKERR_CH4_Msk                (0x10UL)                  /*!< GPDMA0 MASKERR: CH4 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_CH5_Pos                (5UL)                     /*!< GPDMA0 MASKERR: CH5 (Bit 5)                                 */
#define GPDMA0_MASKERR_CH5_Msk                (0x20UL)                  /*!< GPDMA0 MASKERR: CH5 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_CH6_Pos                (6UL)                     /*!< GPDMA0 MASKERR: CH6 (Bit 6)                                 */
#define GPDMA0_MASKERR_CH6_Msk                (0x40UL)                  /*!< GPDMA0 MASKERR: CH6 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_CH7_Pos                (7UL)                     /*!< GPDMA0 MASKERR: CH7 (Bit 7)                                 */
#define GPDMA0_MASKERR_CH7_Msk                (0x80UL)                  /*!< GPDMA0 MASKERR: CH7 (Bitfield-Mask: 0x01)                   */
#define GPDMA0_MASKERR_WE_CH0_Pos             (8UL)                     /*!< GPDMA0 MASKERR: WE_CH0 (Bit 8)                              */
#define GPDMA0_MASKERR_WE_CH0_Msk             (0x100UL)                 /*!< GPDMA0 MASKERR: WE_CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKERR_WE_CH1_Pos             (9UL)                     /*!< GPDMA0 MASKERR: WE_CH1 (Bit 9)                              */
#define GPDMA0_MASKERR_WE_CH1_Msk             (0x200UL)                 /*!< GPDMA0 MASKERR: WE_CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKERR_WE_CH2_Pos             (10UL)                    /*!< GPDMA0 MASKERR: WE_CH2 (Bit 10)                             */
#define GPDMA0_MASKERR_WE_CH2_Msk             (0x400UL)                 /*!< GPDMA0 MASKERR: WE_CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKERR_WE_CH3_Pos             (11UL)                    /*!< GPDMA0 MASKERR: WE_CH3 (Bit 11)                             */
#define GPDMA0_MASKERR_WE_CH3_Msk             (0x800UL)                 /*!< GPDMA0 MASKERR: WE_CH3 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKERR_WE_CH4_Pos             (12UL)                    /*!< GPDMA0 MASKERR: WE_CH4 (Bit 12)                             */
#define GPDMA0_MASKERR_WE_CH4_Msk             (0x1000UL)                /*!< GPDMA0 MASKERR: WE_CH4 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKERR_WE_CH5_Pos             (13UL)                    /*!< GPDMA0 MASKERR: WE_CH5 (Bit 13)                             */
#define GPDMA0_MASKERR_WE_CH5_Msk             (0x2000UL)                /*!< GPDMA0 MASKERR: WE_CH5 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKERR_WE_CH6_Pos             (14UL)                    /*!< GPDMA0 MASKERR: WE_CH6 (Bit 14)                             */
#define GPDMA0_MASKERR_WE_CH6_Msk             (0x4000UL)                /*!< GPDMA0 MASKERR: WE_CH6 (Bitfield-Mask: 0x01)                */
#define GPDMA0_MASKERR_WE_CH7_Pos             (15UL)                    /*!< GPDMA0 MASKERR: WE_CH7 (Bit 15)                             */
#define GPDMA0_MASKERR_WE_CH7_Msk             (0x8000UL)                /*!< GPDMA0 MASKERR: WE_CH7 (Bitfield-Mask: 0x01)                */

/* -------------------------------  GPDMA0_CLEARTFR  ------------------------------ */
#define GPDMA0_CLEARTFR_CH0_Pos               (0UL)                     /*!< GPDMA0 CLEARTFR: CH0 (Bit 0)                                */
#define GPDMA0_CLEARTFR_CH0_Msk               (0x1UL)                   /*!< GPDMA0 CLEARTFR: CH0 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARTFR_CH1_Pos               (1UL)                     /*!< GPDMA0 CLEARTFR: CH1 (Bit 1)                                */
#define GPDMA0_CLEARTFR_CH1_Msk               (0x2UL)                   /*!< GPDMA0 CLEARTFR: CH1 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARTFR_CH2_Pos               (2UL)                     /*!< GPDMA0 CLEARTFR: CH2 (Bit 2)                                */
#define GPDMA0_CLEARTFR_CH2_Msk               (0x4UL)                   /*!< GPDMA0 CLEARTFR: CH2 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARTFR_CH3_Pos               (3UL)                     /*!< GPDMA0 CLEARTFR: CH3 (Bit 3)                                */
#define GPDMA0_CLEARTFR_CH3_Msk               (0x8UL)                   /*!< GPDMA0 CLEARTFR: CH3 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARTFR_CH4_Pos               (4UL)                     /*!< GPDMA0 CLEARTFR: CH4 (Bit 4)                                */
#define GPDMA0_CLEARTFR_CH4_Msk               (0x10UL)                  /*!< GPDMA0 CLEARTFR: CH4 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARTFR_CH5_Pos               (5UL)                     /*!< GPDMA0 CLEARTFR: CH5 (Bit 5)                                */
#define GPDMA0_CLEARTFR_CH5_Msk               (0x20UL)                  /*!< GPDMA0 CLEARTFR: CH5 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARTFR_CH6_Pos               (6UL)                     /*!< GPDMA0 CLEARTFR: CH6 (Bit 6)                                */
#define GPDMA0_CLEARTFR_CH6_Msk               (0x40UL)                  /*!< GPDMA0 CLEARTFR: CH6 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARTFR_CH7_Pos               (7UL)                     /*!< GPDMA0 CLEARTFR: CH7 (Bit 7)                                */
#define GPDMA0_CLEARTFR_CH7_Msk               (0x80UL)                  /*!< GPDMA0 CLEARTFR: CH7 (Bitfield-Mask: 0x01)                  */

/* ------------------------------  GPDMA0_CLEARBLOCK  ----------------------------- */
#define GPDMA0_CLEARBLOCK_CH0_Pos             (0UL)                     /*!< GPDMA0 CLEARBLOCK: CH0 (Bit 0)                              */
#define GPDMA0_CLEARBLOCK_CH0_Msk             (0x1UL)                   /*!< GPDMA0 CLEARBLOCK: CH0 (Bitfield-Mask: 0x01)                */
#define GPDMA0_CLEARBLOCK_CH1_Pos             (1UL)                     /*!< GPDMA0 CLEARBLOCK: CH1 (Bit 1)                              */
#define GPDMA0_CLEARBLOCK_CH1_Msk             (0x2UL)                   /*!< GPDMA0 CLEARBLOCK: CH1 (Bitfield-Mask: 0x01)                */
#define GPDMA0_CLEARBLOCK_CH2_Pos             (2UL)                     /*!< GPDMA0 CLEARBLOCK: CH2 (Bit 2)                              */
#define GPDMA0_CLEARBLOCK_CH2_Msk             (0x4UL)                   /*!< GPDMA0 CLEARBLOCK: CH2 (Bitfield-Mask: 0x01)                */
#define GPDMA0_CLEARBLOCK_CH3_Pos             (3UL)                     /*!< GPDMA0 CLEARBLOCK: CH3 (Bit 3)                              */
#define GPDMA0_CLEARBLOCK_CH3_Msk             (0x8UL)                   /*!< GPDMA0 CLEARBLOCK: CH3 (Bitfield-Mask: 0x01)                */
#define GPDMA0_CLEARBLOCK_CH4_Pos             (4UL)                     /*!< GPDMA0 CLEARBLOCK: CH4 (Bit 4)                              */
#define GPDMA0_CLEARBLOCK_CH4_Msk             (0x10UL)                  /*!< GPDMA0 CLEARBLOCK: CH4 (Bitfield-Mask: 0x01)                */
#define GPDMA0_CLEARBLOCK_CH5_Pos             (5UL)                     /*!< GPDMA0 CLEARBLOCK: CH5 (Bit 5)                              */
#define GPDMA0_CLEARBLOCK_CH5_Msk             (0x20UL)                  /*!< GPDMA0 CLEARBLOCK: CH5 (Bitfield-Mask: 0x01)                */
#define GPDMA0_CLEARBLOCK_CH6_Pos             (6UL)                     /*!< GPDMA0 CLEARBLOCK: CH6 (Bit 6)                              */
#define GPDMA0_CLEARBLOCK_CH6_Msk             (0x40UL)                  /*!< GPDMA0 CLEARBLOCK: CH6 (Bitfield-Mask: 0x01)                */
#define GPDMA0_CLEARBLOCK_CH7_Pos             (7UL)                     /*!< GPDMA0 CLEARBLOCK: CH7 (Bit 7)                              */
#define GPDMA0_CLEARBLOCK_CH7_Msk             (0x80UL)                  /*!< GPDMA0 CLEARBLOCK: CH7 (Bitfield-Mask: 0x01)                */

/* -----------------------------  GPDMA0_CLEARSRCTRAN  ---------------------------- */
#define GPDMA0_CLEARSRCTRAN_CH0_Pos           (0UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH0 (Bit 0)                            */
#define GPDMA0_CLEARSRCTRAN_CH0_Msk           (0x1UL)                   /*!< GPDMA0 CLEARSRCTRAN: CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARSRCTRAN_CH1_Pos           (1UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH1 (Bit 1)                            */
#define GPDMA0_CLEARSRCTRAN_CH1_Msk           (0x2UL)                   /*!< GPDMA0 CLEARSRCTRAN: CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARSRCTRAN_CH2_Pos           (2UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH2 (Bit 2)                            */
#define GPDMA0_CLEARSRCTRAN_CH2_Msk           (0x4UL)                   /*!< GPDMA0 CLEARSRCTRAN: CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARSRCTRAN_CH3_Pos           (3UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH3 (Bit 3)                            */
#define GPDMA0_CLEARSRCTRAN_CH3_Msk           (0x8UL)                   /*!< GPDMA0 CLEARSRCTRAN: CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARSRCTRAN_CH4_Pos           (4UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH4 (Bit 4)                            */
#define GPDMA0_CLEARSRCTRAN_CH4_Msk           (0x10UL)                  /*!< GPDMA0 CLEARSRCTRAN: CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARSRCTRAN_CH5_Pos           (5UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH5 (Bit 5)                            */
#define GPDMA0_CLEARSRCTRAN_CH5_Msk           (0x20UL)                  /*!< GPDMA0 CLEARSRCTRAN: CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARSRCTRAN_CH6_Pos           (6UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH6 (Bit 6)                            */
#define GPDMA0_CLEARSRCTRAN_CH6_Msk           (0x40UL)                  /*!< GPDMA0 CLEARSRCTRAN: CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARSRCTRAN_CH7_Pos           (7UL)                     /*!< GPDMA0 CLEARSRCTRAN: CH7 (Bit 7)                            */
#define GPDMA0_CLEARSRCTRAN_CH7_Msk           (0x80UL)                  /*!< GPDMA0 CLEARSRCTRAN: CH7 (Bitfield-Mask: 0x01)              */

/* -----------------------------  GPDMA0_CLEARDSTTRAN  ---------------------------- */
#define GPDMA0_CLEARDSTTRAN_CH0_Pos           (0UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH0 (Bit 0)                            */
#define GPDMA0_CLEARDSTTRAN_CH0_Msk           (0x1UL)                   /*!< GPDMA0 CLEARDSTTRAN: CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARDSTTRAN_CH1_Pos           (1UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH1 (Bit 1)                            */
#define GPDMA0_CLEARDSTTRAN_CH1_Msk           (0x2UL)                   /*!< GPDMA0 CLEARDSTTRAN: CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARDSTTRAN_CH2_Pos           (2UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH2 (Bit 2)                            */
#define GPDMA0_CLEARDSTTRAN_CH2_Msk           (0x4UL)                   /*!< GPDMA0 CLEARDSTTRAN: CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARDSTTRAN_CH3_Pos           (3UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH3 (Bit 3)                            */
#define GPDMA0_CLEARDSTTRAN_CH3_Msk           (0x8UL)                   /*!< GPDMA0 CLEARDSTTRAN: CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARDSTTRAN_CH4_Pos           (4UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH4 (Bit 4)                            */
#define GPDMA0_CLEARDSTTRAN_CH4_Msk           (0x10UL)                  /*!< GPDMA0 CLEARDSTTRAN: CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARDSTTRAN_CH5_Pos           (5UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH5 (Bit 5)                            */
#define GPDMA0_CLEARDSTTRAN_CH5_Msk           (0x20UL)                  /*!< GPDMA0 CLEARDSTTRAN: CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARDSTTRAN_CH6_Pos           (6UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH6 (Bit 6)                            */
#define GPDMA0_CLEARDSTTRAN_CH6_Msk           (0x40UL)                  /*!< GPDMA0 CLEARDSTTRAN: CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_CLEARDSTTRAN_CH7_Pos           (7UL)                     /*!< GPDMA0 CLEARDSTTRAN: CH7 (Bit 7)                            */
#define GPDMA0_CLEARDSTTRAN_CH7_Msk           (0x80UL)                  /*!< GPDMA0 CLEARDSTTRAN: CH7 (Bitfield-Mask: 0x01)              */

/* -------------------------------  GPDMA0_CLEARERR  ------------------------------ */
#define GPDMA0_CLEARERR_CH0_Pos               (0UL)                     /*!< GPDMA0 CLEARERR: CH0 (Bit 0)                                */
#define GPDMA0_CLEARERR_CH0_Msk               (0x1UL)                   /*!< GPDMA0 CLEARERR: CH0 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARERR_CH1_Pos               (1UL)                     /*!< GPDMA0 CLEARERR: CH1 (Bit 1)                                */
#define GPDMA0_CLEARERR_CH1_Msk               (0x2UL)                   /*!< GPDMA0 CLEARERR: CH1 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARERR_CH2_Pos               (2UL)                     /*!< GPDMA0 CLEARERR: CH2 (Bit 2)                                */
#define GPDMA0_CLEARERR_CH2_Msk               (0x4UL)                   /*!< GPDMA0 CLEARERR: CH2 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARERR_CH3_Pos               (3UL)                     /*!< GPDMA0 CLEARERR: CH3 (Bit 3)                                */
#define GPDMA0_CLEARERR_CH3_Msk               (0x8UL)                   /*!< GPDMA0 CLEARERR: CH3 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARERR_CH4_Pos               (4UL)                     /*!< GPDMA0 CLEARERR: CH4 (Bit 4)                                */
#define GPDMA0_CLEARERR_CH4_Msk               (0x10UL)                  /*!< GPDMA0 CLEARERR: CH4 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARERR_CH5_Pos               (5UL)                     /*!< GPDMA0 CLEARERR: CH5 (Bit 5)                                */
#define GPDMA0_CLEARERR_CH5_Msk               (0x20UL)                  /*!< GPDMA0 CLEARERR: CH5 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARERR_CH6_Pos               (6UL)                     /*!< GPDMA0 CLEARERR: CH6 (Bit 6)                                */
#define GPDMA0_CLEARERR_CH6_Msk               (0x40UL)                  /*!< GPDMA0 CLEARERR: CH6 (Bitfield-Mask: 0x01)                  */
#define GPDMA0_CLEARERR_CH7_Pos               (7UL)                     /*!< GPDMA0 CLEARERR: CH7 (Bit 7)                                */
#define GPDMA0_CLEARERR_CH7_Msk               (0x80UL)                  /*!< GPDMA0 CLEARERR: CH7 (Bitfield-Mask: 0x01)                  */

/* ------------------------------  GPDMA0_STATUSINT  ------------------------------ */
#define GPDMA0_STATUSINT_TFR_Pos              (0UL)                     /*!< GPDMA0 STATUSINT: TFR (Bit 0)                               */
#define GPDMA0_STATUSINT_TFR_Msk              (0x1UL)                   /*!< GPDMA0 STATUSINT: TFR (Bitfield-Mask: 0x01)                 */
#define GPDMA0_STATUSINT_BLOCK_Pos            (1UL)                     /*!< GPDMA0 STATUSINT: BLOCK (Bit 1)                             */
#define GPDMA0_STATUSINT_BLOCK_Msk            (0x2UL)                   /*!< GPDMA0 STATUSINT: BLOCK (Bitfield-Mask: 0x01)               */
#define GPDMA0_STATUSINT_SRCT_Pos             (2UL)                     /*!< GPDMA0 STATUSINT: SRCT (Bit 2)                              */
#define GPDMA0_STATUSINT_SRCT_Msk             (0x4UL)                   /*!< GPDMA0 STATUSINT: SRCT (Bitfield-Mask: 0x01)                */
#define GPDMA0_STATUSINT_DSTT_Pos             (3UL)                     /*!< GPDMA0 STATUSINT: DSTT (Bit 3)                              */
#define GPDMA0_STATUSINT_DSTT_Msk             (0x8UL)                   /*!< GPDMA0 STATUSINT: DSTT (Bitfield-Mask: 0x01)                */
#define GPDMA0_STATUSINT_ERR_Pos              (4UL)                     /*!< GPDMA0 STATUSINT: ERR (Bit 4)                               */
#define GPDMA0_STATUSINT_ERR_Msk              (0x10UL)                  /*!< GPDMA0 STATUSINT: ERR (Bitfield-Mask: 0x01)                 */

/* ------------------------------  GPDMA0_REQSRCREG  ------------------------------ */
#define GPDMA0_REQSRCREG_CH0_Pos              (0UL)                     /*!< GPDMA0 REQSRCREG: CH0 (Bit 0)                               */
#define GPDMA0_REQSRCREG_CH0_Msk              (0x1UL)                   /*!< GPDMA0 REQSRCREG: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_CH1_Pos              (1UL)                     /*!< GPDMA0 REQSRCREG: CH1 (Bit 1)                               */
#define GPDMA0_REQSRCREG_CH1_Msk              (0x2UL)                   /*!< GPDMA0 REQSRCREG: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_CH2_Pos              (2UL)                     /*!< GPDMA0 REQSRCREG: CH2 (Bit 2)                               */
#define GPDMA0_REQSRCREG_CH2_Msk              (0x4UL)                   /*!< GPDMA0 REQSRCREG: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_CH3_Pos              (3UL)                     /*!< GPDMA0 REQSRCREG: CH3 (Bit 3)                               */
#define GPDMA0_REQSRCREG_CH3_Msk              (0x8UL)                   /*!< GPDMA0 REQSRCREG: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_CH4_Pos              (4UL)                     /*!< GPDMA0 REQSRCREG: CH4 (Bit 4)                               */
#define GPDMA0_REQSRCREG_CH4_Msk              (0x10UL)                  /*!< GPDMA0 REQSRCREG: CH4 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_CH5_Pos              (5UL)                     /*!< GPDMA0 REQSRCREG: CH5 (Bit 5)                               */
#define GPDMA0_REQSRCREG_CH5_Msk              (0x20UL)                  /*!< GPDMA0 REQSRCREG: CH5 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_CH6_Pos              (6UL)                     /*!< GPDMA0 REQSRCREG: CH6 (Bit 6)                               */
#define GPDMA0_REQSRCREG_CH6_Msk              (0x40UL)                  /*!< GPDMA0 REQSRCREG: CH6 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_CH7_Pos              (7UL)                     /*!< GPDMA0 REQSRCREG: CH7 (Bit 7)                               */
#define GPDMA0_REQSRCREG_CH7_Msk              (0x80UL)                  /*!< GPDMA0 REQSRCREG: CH7 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQSRCREG_WE_CH0_Pos           (8UL)                     /*!< GPDMA0 REQSRCREG: WE_CH0 (Bit 8)                            */
#define GPDMA0_REQSRCREG_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA0 REQSRCREG: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQSRCREG_WE_CH1_Pos           (9UL)                     /*!< GPDMA0 REQSRCREG: WE_CH1 (Bit 9)                            */
#define GPDMA0_REQSRCREG_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA0 REQSRCREG: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQSRCREG_WE_CH2_Pos           (10UL)                    /*!< GPDMA0 REQSRCREG: WE_CH2 (Bit 10)                           */
#define GPDMA0_REQSRCREG_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA0 REQSRCREG: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQSRCREG_WE_CH3_Pos           (11UL)                    /*!< GPDMA0 REQSRCREG: WE_CH3 (Bit 11)                           */
#define GPDMA0_REQSRCREG_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA0 REQSRCREG: WE_CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQSRCREG_WE_CH4_Pos           (12UL)                    /*!< GPDMA0 REQSRCREG: WE_CH4 (Bit 12)                           */
#define GPDMA0_REQSRCREG_WE_CH4_Msk           (0x1000UL)                /*!< GPDMA0 REQSRCREG: WE_CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQSRCREG_WE_CH5_Pos           (13UL)                    /*!< GPDMA0 REQSRCREG: WE_CH5 (Bit 13)                           */
#define GPDMA0_REQSRCREG_WE_CH5_Msk           (0x2000UL)                /*!< GPDMA0 REQSRCREG: WE_CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQSRCREG_WE_CH6_Pos           (14UL)                    /*!< GPDMA0 REQSRCREG: WE_CH6 (Bit 14)                           */
#define GPDMA0_REQSRCREG_WE_CH6_Msk           (0x4000UL)                /*!< GPDMA0 REQSRCREG: WE_CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQSRCREG_WE_CH7_Pos           (15UL)                    /*!< GPDMA0 REQSRCREG: WE_CH7 (Bit 15)                           */
#define GPDMA0_REQSRCREG_WE_CH7_Msk           (0x8000UL)                /*!< GPDMA0 REQSRCREG: WE_CH7 (Bitfield-Mask: 0x01)              */

/* ------------------------------  GPDMA0_REQDSTREG  ------------------------------ */
#define GPDMA0_REQDSTREG_CH0_Pos              (0UL)                     /*!< GPDMA0 REQDSTREG: CH0 (Bit 0)                               */
#define GPDMA0_REQDSTREG_CH0_Msk              (0x1UL)                   /*!< GPDMA0 REQDSTREG: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_CH1_Pos              (1UL)                     /*!< GPDMA0 REQDSTREG: CH1 (Bit 1)                               */
#define GPDMA0_REQDSTREG_CH1_Msk              (0x2UL)                   /*!< GPDMA0 REQDSTREG: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_CH2_Pos              (2UL)                     /*!< GPDMA0 REQDSTREG: CH2 (Bit 2)                               */
#define GPDMA0_REQDSTREG_CH2_Msk              (0x4UL)                   /*!< GPDMA0 REQDSTREG: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_CH3_Pos              (3UL)                     /*!< GPDMA0 REQDSTREG: CH3 (Bit 3)                               */
#define GPDMA0_REQDSTREG_CH3_Msk              (0x8UL)                   /*!< GPDMA0 REQDSTREG: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_CH4_Pos              (4UL)                     /*!< GPDMA0 REQDSTREG: CH4 (Bit 4)                               */
#define GPDMA0_REQDSTREG_CH4_Msk              (0x10UL)                  /*!< GPDMA0 REQDSTREG: CH4 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_CH5_Pos              (5UL)                     /*!< GPDMA0 REQDSTREG: CH5 (Bit 5)                               */
#define GPDMA0_REQDSTREG_CH5_Msk              (0x20UL)                  /*!< GPDMA0 REQDSTREG: CH5 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_CH6_Pos              (6UL)                     /*!< GPDMA0 REQDSTREG: CH6 (Bit 6)                               */
#define GPDMA0_REQDSTREG_CH6_Msk              (0x40UL)                  /*!< GPDMA0 REQDSTREG: CH6 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_CH7_Pos              (7UL)                     /*!< GPDMA0 REQDSTREG: CH7 (Bit 7)                               */
#define GPDMA0_REQDSTREG_CH7_Msk              (0x80UL)                  /*!< GPDMA0 REQDSTREG: CH7 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_REQDSTREG_WE_CH0_Pos           (8UL)                     /*!< GPDMA0 REQDSTREG: WE_CH0 (Bit 8)                            */
#define GPDMA0_REQDSTREG_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA0 REQDSTREG: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQDSTREG_WE_CH1_Pos           (9UL)                     /*!< GPDMA0 REQDSTREG: WE_CH1 (Bit 9)                            */
#define GPDMA0_REQDSTREG_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA0 REQDSTREG: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQDSTREG_WE_CH2_Pos           (10UL)                    /*!< GPDMA0 REQDSTREG: WE_CH2 (Bit 10)                           */
#define GPDMA0_REQDSTREG_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA0 REQDSTREG: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQDSTREG_WE_CH3_Pos           (11UL)                    /*!< GPDMA0 REQDSTREG: WE_CH3 (Bit 11)                           */
#define GPDMA0_REQDSTREG_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA0 REQDSTREG: WE_CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQDSTREG_WE_CH4_Pos           (12UL)                    /*!< GPDMA0 REQDSTREG: WE_CH4 (Bit 12)                           */
#define GPDMA0_REQDSTREG_WE_CH4_Msk           (0x1000UL)                /*!< GPDMA0 REQDSTREG: WE_CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQDSTREG_WE_CH5_Pos           (13UL)                    /*!< GPDMA0 REQDSTREG: WE_CH5 (Bit 13)                           */
#define GPDMA0_REQDSTREG_WE_CH5_Msk           (0x2000UL)                /*!< GPDMA0 REQDSTREG: WE_CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQDSTREG_WE_CH6_Pos           (14UL)                    /*!< GPDMA0 REQDSTREG: WE_CH6 (Bit 14)                           */
#define GPDMA0_REQDSTREG_WE_CH6_Msk           (0x4000UL)                /*!< GPDMA0 REQDSTREG: WE_CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_REQDSTREG_WE_CH7_Pos           (15UL)                    /*!< GPDMA0 REQDSTREG: WE_CH7 (Bit 15)                           */
#define GPDMA0_REQDSTREG_WE_CH7_Msk           (0x8000UL)                /*!< GPDMA0 REQDSTREG: WE_CH7 (Bitfield-Mask: 0x01)              */

/* -----------------------------  GPDMA0_SGLREQSRCREG  ---------------------------- */
#define GPDMA0_SGLREQSRCREG_CH0_Pos           (0UL)                     /*!< GPDMA0 SGLREQSRCREG: CH0 (Bit 0)                            */
#define GPDMA0_SGLREQSRCREG_CH0_Msk           (0x1UL)                   /*!< GPDMA0 SGLREQSRCREG: CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_CH1_Pos           (1UL)                     /*!< GPDMA0 SGLREQSRCREG: CH1 (Bit 1)                            */
#define GPDMA0_SGLREQSRCREG_CH1_Msk           (0x2UL)                   /*!< GPDMA0 SGLREQSRCREG: CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_CH2_Pos           (2UL)                     /*!< GPDMA0 SGLREQSRCREG: CH2 (Bit 2)                            */
#define GPDMA0_SGLREQSRCREG_CH2_Msk           (0x4UL)                   /*!< GPDMA0 SGLREQSRCREG: CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_CH3_Pos           (3UL)                     /*!< GPDMA0 SGLREQSRCREG: CH3 (Bit 3)                            */
#define GPDMA0_SGLREQSRCREG_CH3_Msk           (0x8UL)                   /*!< GPDMA0 SGLREQSRCREG: CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_CH4_Pos           (4UL)                     /*!< GPDMA0 SGLREQSRCREG: CH4 (Bit 4)                            */
#define GPDMA0_SGLREQSRCREG_CH4_Msk           (0x10UL)                  /*!< GPDMA0 SGLREQSRCREG: CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_CH5_Pos           (5UL)                     /*!< GPDMA0 SGLREQSRCREG: CH5 (Bit 5)                            */
#define GPDMA0_SGLREQSRCREG_CH5_Msk           (0x20UL)                  /*!< GPDMA0 SGLREQSRCREG: CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_CH6_Pos           (6UL)                     /*!< GPDMA0 SGLREQSRCREG: CH6 (Bit 6)                            */
#define GPDMA0_SGLREQSRCREG_CH6_Msk           (0x40UL)                  /*!< GPDMA0 SGLREQSRCREG: CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_CH7_Pos           (7UL)                     /*!< GPDMA0 SGLREQSRCREG: CH7 (Bit 7)                            */
#define GPDMA0_SGLREQSRCREG_CH7_Msk           (0x80UL)                  /*!< GPDMA0 SGLREQSRCREG: CH7 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQSRCREG_WE_CH0_Pos        (8UL)                     /*!< GPDMA0 SGLREQSRCREG: WE_CH0 (Bit 8)                         */
#define GPDMA0_SGLREQSRCREG_WE_CH0_Msk        (0x100UL)                 /*!< GPDMA0 SGLREQSRCREG: WE_CH0 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQSRCREG_WE_CH1_Pos        (9UL)                     /*!< GPDMA0 SGLREQSRCREG: WE_CH1 (Bit 9)                         */
#define GPDMA0_SGLREQSRCREG_WE_CH1_Msk        (0x200UL)                 /*!< GPDMA0 SGLREQSRCREG: WE_CH1 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQSRCREG_WE_CH2_Pos        (10UL)                    /*!< GPDMA0 SGLREQSRCREG: WE_CH2 (Bit 10)                        */
#define GPDMA0_SGLREQSRCREG_WE_CH2_Msk        (0x400UL)                 /*!< GPDMA0 SGLREQSRCREG: WE_CH2 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQSRCREG_WE_CH3_Pos        (11UL)                    /*!< GPDMA0 SGLREQSRCREG: WE_CH3 (Bit 11)                        */
#define GPDMA0_SGLREQSRCREG_WE_CH3_Msk        (0x800UL)                 /*!< GPDMA0 SGLREQSRCREG: WE_CH3 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQSRCREG_WE_CH4_Pos        (12UL)                    /*!< GPDMA0 SGLREQSRCREG: WE_CH4 (Bit 12)                        */
#define GPDMA0_SGLREQSRCREG_WE_CH4_Msk        (0x1000UL)                /*!< GPDMA0 SGLREQSRCREG: WE_CH4 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQSRCREG_WE_CH5_Pos        (13UL)                    /*!< GPDMA0 SGLREQSRCREG: WE_CH5 (Bit 13)                        */
#define GPDMA0_SGLREQSRCREG_WE_CH5_Msk        (0x2000UL)                /*!< GPDMA0 SGLREQSRCREG: WE_CH5 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQSRCREG_WE_CH6_Pos        (14UL)                    /*!< GPDMA0 SGLREQSRCREG: WE_CH6 (Bit 14)                        */
#define GPDMA0_SGLREQSRCREG_WE_CH6_Msk        (0x4000UL)                /*!< GPDMA0 SGLREQSRCREG: WE_CH6 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQSRCREG_WE_CH7_Pos        (15UL)                    /*!< GPDMA0 SGLREQSRCREG: WE_CH7 (Bit 15)                        */
#define GPDMA0_SGLREQSRCREG_WE_CH7_Msk        (0x8000UL)                /*!< GPDMA0 SGLREQSRCREG: WE_CH7 (Bitfield-Mask: 0x01)           */

/* -----------------------------  GPDMA0_SGLREQDSTREG  ---------------------------- */
#define GPDMA0_SGLREQDSTREG_CH0_Pos           (0UL)                     /*!< GPDMA0 SGLREQDSTREG: CH0 (Bit 0)                            */
#define GPDMA0_SGLREQDSTREG_CH0_Msk           (0x1UL)                   /*!< GPDMA0 SGLREQDSTREG: CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_CH1_Pos           (1UL)                     /*!< GPDMA0 SGLREQDSTREG: CH1 (Bit 1)                            */
#define GPDMA0_SGLREQDSTREG_CH1_Msk           (0x2UL)                   /*!< GPDMA0 SGLREQDSTREG: CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_CH2_Pos           (2UL)                     /*!< GPDMA0 SGLREQDSTREG: CH2 (Bit 2)                            */
#define GPDMA0_SGLREQDSTREG_CH2_Msk           (0x4UL)                   /*!< GPDMA0 SGLREQDSTREG: CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_CH3_Pos           (3UL)                     /*!< GPDMA0 SGLREQDSTREG: CH3 (Bit 3)                            */
#define GPDMA0_SGLREQDSTREG_CH3_Msk           (0x8UL)                   /*!< GPDMA0 SGLREQDSTREG: CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_CH4_Pos           (4UL)                     /*!< GPDMA0 SGLREQDSTREG: CH4 (Bit 4)                            */
#define GPDMA0_SGLREQDSTREG_CH4_Msk           (0x10UL)                  /*!< GPDMA0 SGLREQDSTREG: CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_CH5_Pos           (5UL)                     /*!< GPDMA0 SGLREQDSTREG: CH5 (Bit 5)                            */
#define GPDMA0_SGLREQDSTREG_CH5_Msk           (0x20UL)                  /*!< GPDMA0 SGLREQDSTREG: CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_CH6_Pos           (6UL)                     /*!< GPDMA0 SGLREQDSTREG: CH6 (Bit 6)                            */
#define GPDMA0_SGLREQDSTREG_CH6_Msk           (0x40UL)                  /*!< GPDMA0 SGLREQDSTREG: CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_CH7_Pos           (7UL)                     /*!< GPDMA0 SGLREQDSTREG: CH7 (Bit 7)                            */
#define GPDMA0_SGLREQDSTREG_CH7_Msk           (0x80UL)                  /*!< GPDMA0 SGLREQDSTREG: CH7 (Bitfield-Mask: 0x01)              */
#define GPDMA0_SGLREQDSTREG_WE_CH0_Pos        (8UL)                     /*!< GPDMA0 SGLREQDSTREG: WE_CH0 (Bit 8)                         */
#define GPDMA0_SGLREQDSTREG_WE_CH0_Msk        (0x100UL)                 /*!< GPDMA0 SGLREQDSTREG: WE_CH0 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQDSTREG_WE_CH1_Pos        (9UL)                     /*!< GPDMA0 SGLREQDSTREG: WE_CH1 (Bit 9)                         */
#define GPDMA0_SGLREQDSTREG_WE_CH1_Msk        (0x200UL)                 /*!< GPDMA0 SGLREQDSTREG: WE_CH1 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQDSTREG_WE_CH2_Pos        (10UL)                    /*!< GPDMA0 SGLREQDSTREG: WE_CH2 (Bit 10)                        */
#define GPDMA0_SGLREQDSTREG_WE_CH2_Msk        (0x400UL)                 /*!< GPDMA0 SGLREQDSTREG: WE_CH2 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQDSTREG_WE_CH3_Pos        (11UL)                    /*!< GPDMA0 SGLREQDSTREG: WE_CH3 (Bit 11)                        */
#define GPDMA0_SGLREQDSTREG_WE_CH3_Msk        (0x800UL)                 /*!< GPDMA0 SGLREQDSTREG: WE_CH3 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQDSTREG_WE_CH4_Pos        (12UL)                    /*!< GPDMA0 SGLREQDSTREG: WE_CH4 (Bit 12)                        */
#define GPDMA0_SGLREQDSTREG_WE_CH4_Msk        (0x1000UL)                /*!< GPDMA0 SGLREQDSTREG: WE_CH4 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQDSTREG_WE_CH5_Pos        (13UL)                    /*!< GPDMA0 SGLREQDSTREG: WE_CH5 (Bit 13)                        */
#define GPDMA0_SGLREQDSTREG_WE_CH5_Msk        (0x2000UL)                /*!< GPDMA0 SGLREQDSTREG: WE_CH5 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQDSTREG_WE_CH6_Pos        (14UL)                    /*!< GPDMA0 SGLREQDSTREG: WE_CH6 (Bit 14)                        */
#define GPDMA0_SGLREQDSTREG_WE_CH6_Msk        (0x4000UL)                /*!< GPDMA0 SGLREQDSTREG: WE_CH6 (Bitfield-Mask: 0x01)           */
#define GPDMA0_SGLREQDSTREG_WE_CH7_Pos        (15UL)                    /*!< GPDMA0 SGLREQDSTREG: WE_CH7 (Bit 15)                        */
#define GPDMA0_SGLREQDSTREG_WE_CH7_Msk        (0x8000UL)                /*!< GPDMA0 SGLREQDSTREG: WE_CH7 (Bitfield-Mask: 0x01)           */

/* ------------------------------  GPDMA0_LSTSRCREG  ------------------------------ */
#define GPDMA0_LSTSRCREG_CH0_Pos              (0UL)                     /*!< GPDMA0 LSTSRCREG: CH0 (Bit 0)                               */
#define GPDMA0_LSTSRCREG_CH0_Msk              (0x1UL)                   /*!< GPDMA0 LSTSRCREG: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_CH1_Pos              (1UL)                     /*!< GPDMA0 LSTSRCREG: CH1 (Bit 1)                               */
#define GPDMA0_LSTSRCREG_CH1_Msk              (0x2UL)                   /*!< GPDMA0 LSTSRCREG: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_CH2_Pos              (2UL)                     /*!< GPDMA0 LSTSRCREG: CH2 (Bit 2)                               */
#define GPDMA0_LSTSRCREG_CH2_Msk              (0x4UL)                   /*!< GPDMA0 LSTSRCREG: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_CH3_Pos              (3UL)                     /*!< GPDMA0 LSTSRCREG: CH3 (Bit 3)                               */
#define GPDMA0_LSTSRCREG_CH3_Msk              (0x8UL)                   /*!< GPDMA0 LSTSRCREG: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_CH4_Pos              (4UL)                     /*!< GPDMA0 LSTSRCREG: CH4 (Bit 4)                               */
#define GPDMA0_LSTSRCREG_CH4_Msk              (0x10UL)                  /*!< GPDMA0 LSTSRCREG: CH4 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_CH5_Pos              (5UL)                     /*!< GPDMA0 LSTSRCREG: CH5 (Bit 5)                               */
#define GPDMA0_LSTSRCREG_CH5_Msk              (0x20UL)                  /*!< GPDMA0 LSTSRCREG: CH5 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_CH6_Pos              (6UL)                     /*!< GPDMA0 LSTSRCREG: CH6 (Bit 6)                               */
#define GPDMA0_LSTSRCREG_CH6_Msk              (0x40UL)                  /*!< GPDMA0 LSTSRCREG: CH6 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_CH7_Pos              (7UL)                     /*!< GPDMA0 LSTSRCREG: CH7 (Bit 7)                               */
#define GPDMA0_LSTSRCREG_CH7_Msk              (0x80UL)                  /*!< GPDMA0 LSTSRCREG: CH7 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTSRCREG_WE_CH0_Pos           (8UL)                     /*!< GPDMA0 LSTSRCREG: WE_CH0 (Bit 8)                            */
#define GPDMA0_LSTSRCREG_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA0 LSTSRCREG: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTSRCREG_WE_CH1_Pos           (9UL)                     /*!< GPDMA0 LSTSRCREG: WE_CH1 (Bit 9)                            */
#define GPDMA0_LSTSRCREG_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA0 LSTSRCREG: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTSRCREG_WE_CH2_Pos           (10UL)                    /*!< GPDMA0 LSTSRCREG: WE_CH2 (Bit 10)                           */
#define GPDMA0_LSTSRCREG_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA0 LSTSRCREG: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTSRCREG_WE_CH3_Pos           (11UL)                    /*!< GPDMA0 LSTSRCREG: WE_CH3 (Bit 11)                           */
#define GPDMA0_LSTSRCREG_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA0 LSTSRCREG: WE_CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTSRCREG_WE_CH4_Pos           (12UL)                    /*!< GPDMA0 LSTSRCREG: WE_CH4 (Bit 12)                           */
#define GPDMA0_LSTSRCREG_WE_CH4_Msk           (0x1000UL)                /*!< GPDMA0 LSTSRCREG: WE_CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTSRCREG_WE_CH5_Pos           (13UL)                    /*!< GPDMA0 LSTSRCREG: WE_CH5 (Bit 13)                           */
#define GPDMA0_LSTSRCREG_WE_CH5_Msk           (0x2000UL)                /*!< GPDMA0 LSTSRCREG: WE_CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTSRCREG_WE_CH6_Pos           (14UL)                    /*!< GPDMA0 LSTSRCREG: WE_CH6 (Bit 14)                           */
#define GPDMA0_LSTSRCREG_WE_CH6_Msk           (0x4000UL)                /*!< GPDMA0 LSTSRCREG: WE_CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTSRCREG_WE_CH7_Pos           (15UL)                    /*!< GPDMA0 LSTSRCREG: WE_CH7 (Bit 15)                           */
#define GPDMA0_LSTSRCREG_WE_CH7_Msk           (0x8000UL)                /*!< GPDMA0 LSTSRCREG: WE_CH7 (Bitfield-Mask: 0x01)              */

/* ------------------------------  GPDMA0_LSTDSTREG  ------------------------------ */
#define GPDMA0_LSTDSTREG_CH0_Pos              (0UL)                     /*!< GPDMA0 LSTDSTREG: CH0 (Bit 0)                               */
#define GPDMA0_LSTDSTREG_CH0_Msk              (0x1UL)                   /*!< GPDMA0 LSTDSTREG: CH0 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_CH1_Pos              (1UL)                     /*!< GPDMA0 LSTDSTREG: CH1 (Bit 1)                               */
#define GPDMA0_LSTDSTREG_CH1_Msk              (0x2UL)                   /*!< GPDMA0 LSTDSTREG: CH1 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_CH2_Pos              (2UL)                     /*!< GPDMA0 LSTDSTREG: CH2 (Bit 2)                               */
#define GPDMA0_LSTDSTREG_CH2_Msk              (0x4UL)                   /*!< GPDMA0 LSTDSTREG: CH2 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_CH3_Pos              (3UL)                     /*!< GPDMA0 LSTDSTREG: CH3 (Bit 3)                               */
#define GPDMA0_LSTDSTREG_CH3_Msk              (0x8UL)                   /*!< GPDMA0 LSTDSTREG: CH3 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_CH4_Pos              (4UL)                     /*!< GPDMA0 LSTDSTREG: CH4 (Bit 4)                               */
#define GPDMA0_LSTDSTREG_CH4_Msk              (0x10UL)                  /*!< GPDMA0 LSTDSTREG: CH4 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_CH5_Pos              (5UL)                     /*!< GPDMA0 LSTDSTREG: CH5 (Bit 5)                               */
#define GPDMA0_LSTDSTREG_CH5_Msk              (0x20UL)                  /*!< GPDMA0 LSTDSTREG: CH5 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_CH6_Pos              (6UL)                     /*!< GPDMA0 LSTDSTREG: CH6 (Bit 6)                               */
#define GPDMA0_LSTDSTREG_CH6_Msk              (0x40UL)                  /*!< GPDMA0 LSTDSTREG: CH6 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_CH7_Pos              (7UL)                     /*!< GPDMA0 LSTDSTREG: CH7 (Bit 7)                               */
#define GPDMA0_LSTDSTREG_CH7_Msk              (0x80UL)                  /*!< GPDMA0 LSTDSTREG: CH7 (Bitfield-Mask: 0x01)                 */
#define GPDMA0_LSTDSTREG_WE_CH0_Pos           (8UL)                     /*!< GPDMA0 LSTDSTREG: WE_CH0 (Bit 8)                            */
#define GPDMA0_LSTDSTREG_WE_CH0_Msk           (0x100UL)                 /*!< GPDMA0 LSTDSTREG: WE_CH0 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTDSTREG_WE_CH1_Pos           (9UL)                     /*!< GPDMA0 LSTDSTREG: WE_CH1 (Bit 9)                            */
#define GPDMA0_LSTDSTREG_WE_CH1_Msk           (0x200UL)                 /*!< GPDMA0 LSTDSTREG: WE_CH1 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTDSTREG_WE_CH2_Pos           (10UL)                    /*!< GPDMA0 LSTDSTREG: WE_CH2 (Bit 10)                           */
#define GPDMA0_LSTDSTREG_WE_CH2_Msk           (0x400UL)                 /*!< GPDMA0 LSTDSTREG: WE_CH2 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTDSTREG_WE_CH3_Pos           (11UL)                    /*!< GPDMA0 LSTDSTREG: WE_CH3 (Bit 11)                           */
#define GPDMA0_LSTDSTREG_WE_CH3_Msk           (0x800UL)                 /*!< GPDMA0 LSTDSTREG: WE_CH3 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTDSTREG_WE_CH4_Pos           (12UL)                    /*!< GPDMA0 LSTDSTREG: WE_CH4 (Bit 12)                           */
#define GPDMA0_LSTDSTREG_WE_CH4_Msk           (0x1000UL)                /*!< GPDMA0 LSTDSTREG: WE_CH4 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTDSTREG_WE_CH5_Pos           (13UL)                    /*!< GPDMA0 LSTDSTREG: WE_CH5 (Bit 13)                           */
#define GPDMA0_LSTDSTREG_WE_CH5_Msk           (0x2000UL)                /*!< GPDMA0 LSTDSTREG: WE_CH5 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTDSTREG_WE_CH6_Pos           (14UL)                    /*!< GPDMA0 LSTDSTREG: WE_CH6 (Bit 14)                           */
#define GPDMA0_LSTDSTREG_WE_CH6_Msk           (0x4000UL)                /*!< GPDMA0 LSTDSTREG: WE_CH6 (Bitfield-Mask: 0x01)              */
#define GPDMA0_LSTDSTREG_WE_CH7_Pos           (15UL)                    /*!< GPDMA0 LSTDSTREG: WE_CH7 (Bit 15)                           */
#define GPDMA0_LSTDSTREG_WE_CH7_Msk           (0x8000UL)                /*!< GPDMA0 LSTDSTREG: WE_CH7 (Bitfield-Mask: 0x01)              */

/* ------------------------------  GPDMA0_DMACFGREG  ------------------------------ */
#define GPDMA0_DMACFGREG_DMA_EN_Pos           (0UL)                     /*!< GPDMA0 DMACFGREG: DMA_EN (Bit 0)                            */
#define GPDMA0_DMACFGREG_DMA_EN_Msk           (0x1UL)                   /*!< GPDMA0 DMACFGREG: DMA_EN (Bitfield-Mask: 0x01)              */

/* -------------------------------  GPDMA0_CHENREG  ------------------------------- */
#define GPDMA0_CHENREG_CH_Pos                 (0UL)                     /*!< GPDMA0 CHENREG: CH (Bit 0)                                  */
#define GPDMA0_CHENREG_CH_Msk                 (0xffUL)                  /*!< GPDMA0 CHENREG: CH (Bitfield-Mask: 0xff)                    */
#define GPDMA0_CHENREG_WE_CH_Pos              (8UL)                     /*!< GPDMA0 CHENREG: WE_CH (Bit 8)                               */
#define GPDMA0_CHENREG_WE_CH_Msk              (0xff00UL)                /*!< GPDMA0 CHENREG: WE_CH (Bitfield-Mask: 0xff)                 */

/* ----------------------------------  GPDMA0_ID  --------------------------------- */
#define GPDMA0_ID_VALUE_Pos                   (0UL)                     /*!< GPDMA0 ID: VALUE (Bit 0)                                    */
#define GPDMA0_ID_VALUE_Msk                   (0xffffffffUL)            /*!< GPDMA0 ID: VALUE (Bitfield-Mask: 0xffffffff)                */

/* ---------------------------------  GPDMA0_TYPE  -------------------------------- */
#define GPDMA0_TYPE_VALUE_Pos                 (0UL)                     /*!< GPDMA0 TYPE: VALUE (Bit 0)                                  */
#define GPDMA0_TYPE_VALUE_Msk                 (0xffffffffUL)            /*!< GPDMA0 TYPE: VALUE (Bitfield-Mask: 0xffffffff)              */

/* -------------------------------  GPDMA0_VERSION  ------------------------------- */
#define GPDMA0_VERSION_VALUE_Pos              (0UL)                     /*!< GPDMA0 VERSION: VALUE (Bit 0)                               */
#define GPDMA0_VERSION_VALUE_Msk              (0xffffffffUL)            /*!< GPDMA0 VERSION: VALUE (Bitfield-Mask: 0xffffffff)           */


/* ================================================================================ */
/* ================      Group 'GPDMA0_CH0_1' Position & Mask      ================ */
/* ================================================================================ */


/* ------------------------------  GPDMA0_CH_SAR  ------------------------------ */
#define GPDMA0_CH_SAR_SAR_Pos              (0UL)                     /*!< GPDMA0_CH0_1 SAR: SAR (Bit 0)                               */
#define GPDMA0_CH_SAR_SAR_Msk              (0xffffffffUL)            /*!< GPDMA0_CH0_1 SAR: SAR (Bitfield-Mask: 0xffffffff)           */

/* ------------------------------  GPDMA0_CH_DAR  ------------------------------ */
#define GPDMA0_CH_DAR_DAR_Pos              (0UL)                     /*!< GPDMA0_CH0_1 DAR: DAR (Bit 0)                               */
#define GPDMA0_CH_DAR_DAR_Msk              (0xffffffffUL)            /*!< GPDMA0_CH0_1 DAR: DAR (Bitfield-Mask: 0xffffffff)           */

/* ------------------------------  GPDMA0_CH_LLP  ------------------------------ */
#define GPDMA0_CH_LLP_LOC_Pos              (2UL)                     /*!< GPDMA0_CH0_1 LLP: LOC (Bit 2)                               */
#define GPDMA0_CH_LLP_LOC_Msk              (0xfffffffcUL)            /*!< GPDMA0_CH0_1 LLP: LOC (Bitfield-Mask: 0x3fffffff)           */

/* ------------------------------  GPDMA0_CH_CTLL  ----------------------------- */
#define GPDMA0_CH_CTLL_INT_EN_Pos          (0UL)                     /*!< GPDMA0_CH0_1 CTLL: INT_EN (Bit 0)                           */
#define GPDMA0_CH_CTLL_INT_EN_Msk          (0x1UL)                   /*!< GPDMA0_CH0_1 CTLL: INT_EN (Bitfield-Mask: 0x01)             */
#define GPDMA0_CH_CTLL_DST_TR_WIDTH_Pos    (1UL)                     /*!< GPDMA0_CH0_1 CTLL: DST_TR_WIDTH (Bit 1)                     */
#define GPDMA0_CH_CTLL_DST_TR_WIDTH_Msk    (0xeUL)                   /*!< GPDMA0_CH0_1 CTLL: DST_TR_WIDTH (Bitfield-Mask: 0x07)       */
#define GPDMA0_CH_CTLL_SRC_TR_WIDTH_Pos    (4UL)                     /*!< GPDMA0_CH0_1 CTLL: SRC_TR_WIDTH (Bit 4)                     */
#define GPDMA0_CH_CTLL_SRC_TR_WIDTH_Msk    (0x70UL)                  /*!< GPDMA0_CH0_1 CTLL: SRC_TR_WIDTH (Bitfield-Mask: 0x07)       */
#define GPDMA0_CH_CTLL_DINC_Pos            (7UL)                     /*!< GPDMA0_CH0_1 CTLL: DINC (Bit 7)                             */
#define GPDMA0_CH_CTLL_DINC_Msk            (0x180UL)                 /*!< GPDMA0_CH0_1 CTLL: DINC (Bitfield-Mask: 0x03)               */
#define GPDMA0_CH_CTLL_SINC_Pos            (9UL)                     /*!< GPDMA0_CH0_1 CTLL: SINC (Bit 9)                             */
#define GPDMA0_CH_CTLL_SINC_Msk            (0x600UL)                 /*!< GPDMA0_CH0_1 CTLL: SINC (Bitfield-Mask: 0x03)               */
#define GPDMA0_CH_CTLL_DEST_MSIZE_Pos      (11UL)                    /*!< GPDMA0_CH0_1 CTLL: DEST_MSIZE (Bit 11)                      */
#define GPDMA0_CH_CTLL_DEST_MSIZE_Msk      (0x3800UL)                /*!< GPDMA0_CH0_1 CTLL: DEST_MSIZE (Bitfield-Mask: 0x07)         */
#define GPDMA0_CH_CTLL_SRC_MSIZE_Pos       (14UL)                    /*!< GPDMA0_CH0_1 CTLL: SRC_MSIZE (Bit 14)                       */
#define GPDMA0_CH_CTLL_SRC_MSIZE_Msk       (0x1c000UL)               /*!< GPDMA0_CH0_1 CTLL: SRC_MSIZE (Bitfield-Mask: 0x07)          */
#define GPDMA0_CH_CTLL_SRC_GATHER_EN_Pos   (17UL)                    /*!< GPDMA0_CH0_1 CTLL: SRC_GATHER_EN (Bit 17)                   */
#define GPDMA0_CH_CTLL_SRC_GATHER_EN_Msk   (0x20000UL)               /*!< GPDMA0_CH0_1 CTLL: SRC_GATHER_EN (Bitfield-Mask: 0x01)      */
#define GPDMA0_CH_CTLL_DST_SCATTER_EN_Pos  (18UL)                    /*!< GPDMA0_CH0_1 CTLL: DST_SCATTER_EN (Bit 18)                  */
#define GPDMA0_CH_CTLL_DST_SCATTER_EN_Msk  (0x40000UL)               /*!< GPDMA0_CH0_1 CTLL: DST_SCATTER_EN (Bitfield-Mask: 0x01)     */
#define GPDMA0_CH_CTLL_TT_FC_Pos           (20UL)                    /*!< GPDMA0_CH0_1 CTLL: TT_FC (Bit 20)                           */
#define GPDMA0_CH_CTLL_TT_FC_Msk           (0x700000UL)              /*!< GPDMA0_CH0_1 CTLL: TT_FC (Bitfield-Mask: 0x07)              */
#define GPDMA0_CH_CTLL_LLP_DST_EN_Pos      (27UL)                    /*!< GPDMA0_CH0_1 CTLL: LLP_DST_EN (Bit 27)                      */
#define GPDMA0_CH_CTLL_LLP_DST_EN_Msk      (0x8000000UL)             /*!< GPDMA0_CH0_1 CTLL: LLP_DST_EN (Bitfield-Mask: 0x01)         */
#define GPDMA0_CH_CTLL_LLP_SRC_EN_Pos      (28UL)                    /*!< GPDMA0_CH0_1 CTLL: LLP_SRC_EN (Bit 28)                      */
#define GPDMA0_CH_CTLL_LLP_SRC_EN_Msk      (0x10000000UL)            /*!< GPDMA0_CH0_1 CTLL: LLP_SRC_EN (Bitfield-Mask: 0x01)         */

/* ------------------------------  GPDMA0_CH_CTLH  ----------------------------- */
#define GPDMA0_CH_CTLH_BLOCK_TS_Pos        (0UL)                     /*!< GPDMA0_CH0_1 CTLH: BLOCK_TS (Bit 0)                         */
#define GPDMA0_CH_CTLH_BLOCK_TS_Msk        (0xfffUL)                 /*!< GPDMA0_CH0_1 CTLH: BLOCK_TS (Bitfield-Mask: 0xfff)          */
#define GPDMA0_CH_CTLH_DONE_Pos            (12UL)                    /*!< GPDMA0_CH0_1 CTLH: DONE (Bit 12)                            */
#define GPDMA0_CH_CTLH_DONE_Msk            (0x1000UL)                /*!< GPDMA0_CH0_1 CTLH: DONE (Bitfield-Mask: 0x01)               */

/* -----------------------------  GPDMA0_CH_SSTAT  ----------------------------- */
#define GPDMA0_CH_SSTAT_SSTAT_Pos          (0UL)                     /*!< GPDMA0_CH0_1 SSTAT: SSTAT (Bit 0)                           */
#define GPDMA0_CH_SSTAT_SSTAT_Msk          (0xffffffffUL)            /*!< GPDMA0_CH0_1 SSTAT: SSTAT (Bitfield-Mask: 0xffffffff)       */

/* -----------------------------  GPDMA0_CH_DSTAT  ----------------------------- */
#define GPDMA0_CH_DSTAT_DSTAT_Pos          (0UL)                     /*!< GPDMA0_CH0_1 DSTAT: DSTAT (Bit 0)                           */
#define GPDMA0_CH_DSTAT_DSTAT_Msk          (0xffffffffUL)            /*!< GPDMA0_CH0_1 DSTAT: DSTAT (Bitfield-Mask: 0xffffffff)       */

/* ----------------------------  GPDMA0_CH_SSTATAR  ---------------------------- */
#define GPDMA0_CH_SSTATAR_SSTATAR_Pos      (0UL)                     /*!< GPDMA0_CH0_1 SSTATAR: SSTATAR (Bit 0)                       */
#define GPDMA0_CH_SSTATAR_SSTATAR_Msk      (0xffffffffUL)            /*!< GPDMA0_CH0_1 SSTATAR: SSTATAR (Bitfield-Mask: 0xffffffff)   */

/* ----------------------------  GPDMA0_CH_DSTATAR  ---------------------------- */
#define GPDMA0_CH_DSTATAR_DSTATAR_Pos      (0UL)                     /*!< GPDMA0_CH0_1 DSTATAR: DSTATAR (Bit 0)                       */
#define GPDMA0_CH_DSTATAR_DSTATAR_Msk      (0xffffffffUL)            /*!< GPDMA0_CH0_1 DSTATAR: DSTATAR (Bitfield-Mask: 0xffffffff)   */

/* ------------------------------  GPDMA0_CH_CFGL  ----------------------------- */
#define GPDMA0_CH_CFGL_CH_PRIOR_Pos        (5UL)                     /*!< GPDMA0_CH0_1 CFGL: CH_PRIOR (Bit 5)                         */
#define GPDMA0_CH_CFGL_CH_PRIOR_Msk        (0xe0UL)                  /*!< GPDMA0_CH0_1 CFGL: CH_PRIOR (Bitfield-Mask: 0x07)           */
#define GPDMA0_CH_CFGL_CH_SUSP_Pos         (8UL)                     /*!< GPDMA0_CH0_1 CFGL: CH_SUSP (Bit 8)                          */
#define GPDMA0_CH_CFGL_CH_SUSP_Msk         (0x100UL)                 /*!< GPDMA0_CH0_1 CFGL: CH_SUSP (Bitfield-Mask: 0x01)            */
#define GPDMA0_CH_CFGL_FIFO_EMPTY_Pos      (9UL)                     /*!< GPDMA0_CH0_1 CFGL: FIFO_EMPTY (Bit 9)                       */
#define GPDMA0_CH_CFGL_FIFO_EMPTY_Msk      (0x200UL)                 /*!< GPDMA0_CH0_1 CFGL: FIFO_EMPTY (Bitfield-Mask: 0x01)         */
#define GPDMA0_CH_CFGL_HS_SEL_DST_Pos      (10UL)                    /*!< GPDMA0_CH0_1 CFGL: HS_SEL_DST (Bit 10)                      */
#define GPDMA0_CH_CFGL_HS_SEL_DST_Msk      (0x400UL)                 /*!< GPDMA0_CH0_1 CFGL: HS_SEL_DST (Bitfield-Mask: 0x01)         */
#define GPDMA0_CH_CFGL_HS_SEL_SRC_Pos      (11UL)                    /*!< GPDMA0_CH0_1 CFGL: HS_SEL_SRC (Bit 11)                      */
#define GPDMA0_CH_CFGL_HS_SEL_SRC_Msk      (0x800UL)                 /*!< GPDMA0_CH0_1 CFGL: HS_SEL_SRC (Bitfield-Mask: 0x01)         */
#define GPDMA0_CH_CFGL_LOCK_CH_L_Pos       (12UL)                    /*!< GPDMA0_CH0_1 CFGL: LOCK_CH_L (Bit 12)                       */
#define GPDMA0_CH_CFGL_LOCK_CH_L_Msk       (0x3000UL)                /*!< GPDMA0_CH0_1 CFGL: LOCK_CH_L (Bitfield-Mask: 0x03)          */
#define GPDMA0_CH_CFGL_LOCK_B_L_Pos        (14UL)                    /*!< GPDMA0_CH0_1 CFGL: LOCK_B_L (Bit 14)                        */
#define GPDMA0_CH_CFGL_LOCK_B_L_Msk        (0xc000UL)                /*!< GPDMA0_CH0_1 CFGL: LOCK_B_L (Bitfield-Mask: 0x03)           */
#define GPDMA0_CH_CFGL_LOCK_CH_Pos         (16UL)                    /*!< GPDMA0_CH0_1 CFGL: LOCK_CH (Bit 16)                         */
#define GPDMA0_CH_CFGL_LOCK_CH_Msk         (0x10000UL)               /*!< GPDMA0_CH0_1 CFGL: LOCK_CH (Bitfield-Mask: 0x01)            */
#define GPDMA0_CH_CFGL_LOCK_B_Pos          (17UL)                    /*!< GPDMA0_CH0_1 CFGL: LOCK_B (Bit 17)                          */
#define GPDMA0_CH_CFGL_LOCK_B_Msk          (0x20000UL)               /*!< GPDMA0_CH0_1 CFGL: LOCK_B (Bitfield-Mask: 0x01)             */
#define GPDMA0_CH_CFGL_DST_HS_POL_Pos      (18UL)                    /*!< GPDMA0_CH0_1 CFGL: DST_HS_POL (Bit 18)                      */
#define GPDMA0_CH_CFGL_DST_HS_POL_Msk      (0x40000UL)               /*!< GPDMA0_CH0_1 CFGL: DST_HS_POL (Bitfield-Mask: 0x01)         */
#define GPDMA0_CH_CFGL_SRC_HS_POL_Pos      (19UL)                    /*!< GPDMA0_CH0_1 CFGL: SRC_HS_POL (Bit 19)                      */
#define GPDMA0_CH_CFGL_SRC_HS_POL_Msk      (0x80000UL)               /*!< GPDMA0_CH0_1 CFGL: SRC_HS_POL (Bitfield-Mask: 0x01)         */
#define GPDMA0_CH_CFGL_MAX_ABRST_Pos       (20UL)                    /*!< GPDMA0_CH0_1 CFGL: MAX_ABRST (Bit 20)                       */
#define GPDMA0_CH_CFGL_MAX_ABRST_Msk       (0x3ff00000UL)            /*!< GPDMA0_CH0_1 CFGL: MAX_ABRST (Bitfield-Mask: 0x3ff)         */
#define GPDMA0_CH_CFGL_RELOAD_SRC_Pos      (30UL)                    /*!< GPDMA0_CH0_1 CFGL: RELOAD_SRC (Bit 30)                      */
#define GPDMA0_CH_CFGL_RELOAD_SRC_Msk      (0x40000000UL)            /*!< GPDMA0_CH0_1 CFGL: RELOAD_SRC (Bitfield-Mask: 0x01)         */
#define GPDMA0_CH_CFGL_RELOAD_DST_Pos      (31UL)                    /*!< GPDMA0_CH0_1 CFGL: RELOAD_DST (Bit 31)                      */
#define GPDMA0_CH_CFGL_RELOAD_DST_Msk      (0x80000000UL)            /*!< GPDMA0_CH0_1 CFGL: RELOAD_DST (Bitfield-Mask: 0x01)         */

/* ------------------------------  GPDMA0_CH_CFGH  ----------------------------- */
#define GPDMA0_CH_CFGH_FCMODE_Pos          (0UL)                     /*!< GPDMA0_CH0_1 CFGH: FCMODE (Bit 0)                           */
#define GPDMA0_CH_CFGH_FCMODE_Msk          (0x1UL)                   /*!< GPDMA0_CH0_1 CFGH: FCMODE (Bitfield-Mask: 0x01)             */
#define GPDMA0_CH_CFGH_FIFO_MODE_Pos       (1UL)                     /*!< GPDMA0_CH0_1 CFGH: FIFO_MODE (Bit 1)                        */
#define GPDMA0_CH_CFGH_FIFO_MODE_Msk       (0x2UL)                   /*!< GPDMA0_CH0_1 CFGH: FIFO_MODE (Bitfield-Mask: 0x01)          */
#define GPDMA0_CH_CFGH_PROTCTL_Pos         (2UL)                     /*!< GPDMA0_CH0_1 CFGH: PROTCTL (Bit 2)                          */
#define GPDMA0_CH_CFGH_PROTCTL_Msk         (0x1cUL)                  /*!< GPDMA0_CH0_1 CFGH: PROTCTL (Bitfield-Mask: 0x07)            */
#define GPDMA0_CH_CFGH_DS_UPD_EN_Pos       (5UL)                     /*!< GPDMA0_CH0_1 CFGH: DS_UPD_EN (Bit 5)                        */
#define GPDMA0_CH_CFGH_DS_UPD_EN_Msk       (0x20UL)                  /*!< GPDMA0_CH0_1 CFGH: DS_UPD_EN (Bitfield-Mask: 0x01)          */
#define GPDMA0_CH_CFGH_SS_UPD_EN_Pos       (6UL)                     /*!< GPDMA0_CH0_1 CFGH: SS_UPD_EN (Bit 6)                        */
#define GPDMA0_CH_CFGH_SS_UPD_EN_Msk       (0x40UL)                  /*!< GPDMA0_CH0_1 CFGH: SS_UPD_EN (Bitfield-Mask: 0x01)          */
#define GPDMA0_CH_CFGH_SRC_PER_Pos         (7UL)                     /*!< GPDMA0_CH0_1 CFGH: SRC_PER (Bit 7)                          */
#define GPDMA0_CH_CFGH_SRC_PER_Msk         (0x780UL)                 /*!< GPDMA0_CH0_1 CFGH: SRC_PER (Bitfield-Mask: 0x0f)            */
#define GPDMA0_CH_CFGH_DEST_PER_Pos        (11UL)                    /*!< GPDMA0_CH0_1 CFGH: DEST_PER (Bit 11)                        */
#define GPDMA0_CH_CFGH_DEST_PER_Msk        (0x7800UL)                /*!< GPDMA0_CH0_1 CFGH: DEST_PER (Bitfield-Mask: 0x0f)           */

/* ------------------------------  GPDMA0_CH_SGR  ------------------------------ */
#define GPDMA0_CH_SGR_SGI_Pos              (0UL)                     /*!< GPDMA0_CH0_1 SGR: SGI (Bit 0)                               */
#define GPDMA0_CH_SGR_SGI_Msk              (0xfffffUL)               /*!< GPDMA0_CH0_1 SGR: SGI (Bitfield-Mask: 0xfffff)              */
#define GPDMA0_CH_SGR_SGC_Pos              (20UL)                    /*!< GPDMA0_CH0_1 SGR: SGC (Bit 20)                              */
#define GPDMA0_CH_SGR_SGC_Msk              (0xfff00000UL)            /*!< GPDMA0_CH0_1 SGR: SGC (Bitfield-Mask: 0xfff)                */

/* ------------------------------  GPDMA0_CH_DSR  ------------------------------ */
#define GPDMA0_CH_DSR_DSI_Pos              (0UL)                     /*!< GPDMA0_CH0_1 DSR: DSI (Bit 0)                               */
#define GPDMA0_CH_DSR_DSI_Msk              (0xfffffUL)               /*!< GPDMA0_CH0_1 DSR: DSI (Bitfield-Mask: 0xfffff)              */
#define GPDMA0_CH_DSR_DSC_Pos              (20UL)                    /*!< GPDMA0_CH0_1 DSR: DSC (Bit 20)                              */
#define GPDMA0_CH_DSR_DSC_Msk              (0xfff00000UL)            /*!< GPDMA0_CH0_1 DSR: DSC (Bitfield-Mask: 0xfff)                */


/* ================================================================================ */
/* ================          struct 'FCE' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  FCE_CLC  ---------------------------------- */
#define FCE_CLC_DISR_Pos                      (0UL)                     /*!< FCE CLC: DISR (Bit 0)                                       */
#define FCE_CLC_DISR_Msk                      (0x1UL)                   /*!< FCE CLC: DISR (Bitfield-Mask: 0x01)                         */
#define FCE_CLC_DISS_Pos                      (1UL)                     /*!< FCE CLC: DISS (Bit 1)                                       */
#define FCE_CLC_DISS_Msk                      (0x2UL)                   /*!< FCE CLC: DISS (Bitfield-Mask: 0x01)                         */

/* -----------------------------------  FCE_ID  ----------------------------------- */
#define FCE_ID_MOD_REV_Pos                    (0UL)                     /*!< FCE ID: MOD_REV (Bit 0)                                     */
#define FCE_ID_MOD_REV_Msk                    (0xffUL)                  /*!< FCE ID: MOD_REV (Bitfield-Mask: 0xff)                       */
#define FCE_ID_MOD_TYPE_Pos                   (8UL)                     /*!< FCE ID: MOD_TYPE (Bit 8)                                    */
#define FCE_ID_MOD_TYPE_Msk                   (0xff00UL)                /*!< FCE ID: MOD_TYPE (Bitfield-Mask: 0xff)                      */
#define FCE_ID_MOD_NUMBER_Pos                 (16UL)                    /*!< FCE ID: MOD_NUMBER (Bit 16)                                 */
#define FCE_ID_MOD_NUMBER_Msk                 (0xffff0000UL)            /*!< FCE ID: MOD_NUMBER (Bitfield-Mask: 0xffff)                  */


/* ================================================================================ */
/* ================         Group 'FCE_KE' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  FCE_KE_IR  --------------------------------- */
#define FCE_KE_IR_IR_Pos                      (0UL)                     /*!< FCE_KE IR: IR (Bit 0)                                       */
#define FCE_KE_IR_IR_Msk                      (0xffffffffUL)            /*!< FCE_KE IR: IR (Bitfield-Mask: 0xffffffff)                   */

/* ---------------------------------  FCE_KE_RES  --------------------------------- */
#define FCE_KE_RES_RES_Pos                    (0UL)                     /*!< FCE_KE RES: RES (Bit 0)                                     */
#define FCE_KE_RES_RES_Msk                    (0xffffffffUL)            /*!< FCE_KE RES: RES (Bitfield-Mask: 0xffffffff)                 */

/* ---------------------------------  FCE_KE_CFG  --------------------------------- */
#define FCE_KE_CFG_CMI_Pos                    (0UL)                     /*!< FCE_KE CFG: CMI (Bit 0)                                     */
#define FCE_KE_CFG_CMI_Msk                    (0x1UL)                   /*!< FCE_KE CFG: CMI (Bitfield-Mask: 0x01)                       */
#define FCE_KE_CFG_CEI_Pos                    (1UL)                     /*!< FCE_KE CFG: CEI (Bit 1)                                     */
#define FCE_KE_CFG_CEI_Msk                    (0x2UL)                   /*!< FCE_KE CFG: CEI (Bitfield-Mask: 0x01)                       */
#define FCE_KE_CFG_LEI_Pos                    (2UL)                     /*!< FCE_KE CFG: LEI (Bit 2)                                     */
#define FCE_KE_CFG_LEI_Msk                    (0x4UL)                   /*!< FCE_KE CFG: LEI (Bitfield-Mask: 0x01)                       */
#define FCE_KE_CFG_BEI_Pos                    (3UL)                     /*!< FCE_KE CFG: BEI (Bit 3)                                     */
#define FCE_KE_CFG_BEI_Msk                    (0x8UL)                   /*!< FCE_KE CFG: BEI (Bitfield-Mask: 0x01)                       */
#define FCE_KE_CFG_CCE_Pos                    (4UL)                     /*!< FCE_KE CFG: CCE (Bit 4)                                     */
#define FCE_KE_CFG_CCE_Msk                    (0x10UL)                  /*!< FCE_KE CFG: CCE (Bitfield-Mask: 0x01)                       */
#define FCE_KE_CFG_ALR_Pos                    (5UL)                     /*!< FCE_KE CFG: ALR (Bit 5)                                     */
#define FCE_KE_CFG_ALR_Msk                    (0x20UL)                  /*!< FCE_KE CFG: ALR (Bitfield-Mask: 0x01)                       */
#define FCE_KE_CFG_REFIN_Pos                  (8UL)                     /*!< FCE_KE CFG: REFIN (Bit 8)                                   */
#define FCE_KE_CFG_REFIN_Msk                  (0x100UL)                 /*!< FCE_KE CFG: REFIN (Bitfield-Mask: 0x01)                     */
#define FCE_KE_CFG_REFOUT_Pos                 (9UL)                     /*!< FCE_KE CFG: REFOUT (Bit 9)                                  */
#define FCE_KE_CFG_REFOUT_Msk                 (0x200UL)                 /*!< FCE_KE CFG: REFOUT (Bitfield-Mask: 0x01)                    */
#define FCE_KE_CFG_XSEL_Pos                   (10UL)                    /*!< FCE_KE CFG: XSEL (Bit 10)                                   */
#define FCE_KE_CFG_XSEL_Msk                   (0x400UL)                 /*!< FCE_KE CFG: XSEL (Bitfield-Mask: 0x01)                      */

/* ---------------------------------  FCE_KE_STS  --------------------------------- */
#define FCE_KE_STS_CMF_Pos                    (0UL)                     /*!< FCE_KE STS: CMF (Bit 0)                                     */
#define FCE_KE_STS_CMF_Msk                    (0x1UL)                   /*!< FCE_KE STS: CMF (Bitfield-Mask: 0x01)                       */
#define FCE_KE_STS_CEF_Pos                    (1UL)                     /*!< FCE_KE STS: CEF (Bit 1)                                     */
#define FCE_KE_STS_CEF_Msk                    (0x2UL)                   /*!< FCE_KE STS: CEF (Bitfield-Mask: 0x01)                       */
#define FCE_KE_STS_LEF_Pos                    (2UL)                     /*!< FCE_KE STS: LEF (Bit 2)                                     */
#define FCE_KE_STS_LEF_Msk                    (0x4UL)                   /*!< FCE_KE STS: LEF (Bitfield-Mask: 0x01)                       */
#define FCE_KE_STS_BEF_Pos                    (3UL)                     /*!< FCE_KE STS: BEF (Bit 3)                                     */
#define FCE_KE_STS_BEF_Msk                    (0x8UL)                   /*!< FCE_KE STS: BEF (Bitfield-Mask: 0x01)                       */

/* --------------------------------  FCE_KE_LENGTH  ------------------------------- */
#define FCE_KE_LENGTH_LENGTH_Pos              (0UL)                     /*!< FCE_KE LENGTH: LENGTH (Bit 0)                               */
#define FCE_KE_LENGTH_LENGTH_Msk              (0xffffUL)                /*!< FCE_KE LENGTH: LENGTH (Bitfield-Mask: 0xffff)               */

/* --------------------------------  FCE_KE_CHECK  -------------------------------- */
#define FCE_KE_CHECK_CHECK_Pos                (0UL)                     /*!< FCE_KE CHECK: CHECK (Bit 0)                                 */
#define FCE_KE_CHECK_CHECK_Msk                (0xffffffffUL)            /*!< FCE_KE CHECK: CHECK (Bitfield-Mask: 0xffffffff)             */

/* ---------------------------------  FCE_KE_CRC  --------------------------------- */
#define FCE_KE_CRC_CRC_Pos                    (0UL)                     /*!< FCE_KE CRC: CRC (Bit 0)                                     */
#define FCE_KE_CRC_CRC_Msk                    (0xffffffffUL)            /*!< FCE_KE CRC: CRC (Bitfield-Mask: 0xffffffff)                 */

/* ---------------------------------  FCE_KE_CTR  --------------------------------- */
#define FCE_KE_CTR_FCM_Pos                    (0UL)                     /*!< FCE_KE CTR: FCM (Bit 0)                                     */
#define FCE_KE_CTR_FCM_Msk                    (0x1UL)                   /*!< FCE_KE CTR: FCM (Bitfield-Mask: 0x01)                       */
#define FCE_KE_CTR_FRM_CFG_Pos                (1UL)                     /*!< FCE_KE CTR: FRM_CFG (Bit 1)                                 */
#define FCE_KE_CTR_FRM_CFG_Msk                (0x2UL)                   /*!< FCE_KE CTR: FRM_CFG (Bitfield-Mask: 0x01)                   */
#define FCE_KE_CTR_FRM_CHECK_Pos              (2UL)                     /*!< FCE_KE CTR: FRM_CHECK (Bit 2)                               */
#define FCE_KE_CTR_FRM_CHECK_Msk              (0x4UL)                   /*!< FCE_KE CTR: FRM_CHECK (Bitfield-Mask: 0x01)                 */


/* ================================================================================ */
/* ================           Group 'PBA' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  PBA_STS  ---------------------------------- */
#define PBA_STS_WERR_Pos                      (0UL)                     /*!< PBA STS: WERR (Bit 0)                                       */
#define PBA_STS_WERR_Msk                      (0x1UL)                   /*!< PBA STS: WERR (Bitfield-Mask: 0x01)                         */

/* ----------------------------------  PBA_WADDR  --------------------------------- */
#define PBA_WADDR_WADDR_Pos                   (0UL)                     /*!< PBA WADDR: WADDR (Bit 0)                                    */
#define PBA_WADDR_WADDR_Msk                   (0xffffffffUL)            /*!< PBA WADDR: WADDR (Bitfield-Mask: 0xffffffff)                */


/* ================================================================================ */
/* ================          Group 'FLASH' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  FLASH_ID  ---------------------------------- */
#define FLASH_ID_MOD_REV_Pos                  (0UL)                     /*!< FLASH ID: MOD_REV (Bit 0)                                   */
#define FLASH_ID_MOD_REV_Msk                  (0xffUL)                  /*!< FLASH ID: MOD_REV (Bitfield-Mask: 0xff)                     */
#define FLASH_ID_MOD_TYPE_Pos                 (8UL)                     /*!< FLASH ID: MOD_TYPE (Bit 8)                                  */
#define FLASH_ID_MOD_TYPE_Msk                 (0xff00UL)                /*!< FLASH ID: MOD_TYPE (Bitfield-Mask: 0xff)                    */
#define FLASH_ID_MOD_NUMBER_Pos               (16UL)                    /*!< FLASH ID: MOD_NUMBER (Bit 16)                               */
#define FLASH_ID_MOD_NUMBER_Msk               (0xffff0000UL)            /*!< FLASH ID: MOD_NUMBER (Bitfield-Mask: 0xffff)                */

/* ----------------------------------  FLASH_FSR  --------------------------------- */
#define FLASH_FSR_PBUSY_Pos                   (0UL)                     /*!< FLASH FSR: PBUSY (Bit 0)                                    */
#define FLASH_FSR_PBUSY_Msk                   (0x1UL)                   /*!< FLASH FSR: PBUSY (Bitfield-Mask: 0x01)                      */
#define FLASH_FSR_FABUSY_Pos                  (1UL)                     /*!< FLASH FSR: FABUSY (Bit 1)                                   */
#define FLASH_FSR_FABUSY_Msk                  (0x2UL)                   /*!< FLASH FSR: FABUSY (Bitfield-Mask: 0x01)                     */
#define FLASH_FSR_PROG_Pos                    (4UL)                     /*!< FLASH FSR: PROG (Bit 4)                                     */
#define FLASH_FSR_PROG_Msk                    (0x10UL)                  /*!< FLASH FSR: PROG (Bitfield-Mask: 0x01)                       */
#define FLASH_FSR_ERASE_Pos                   (5UL)                     /*!< FLASH FSR: ERASE (Bit 5)                                    */
#define FLASH_FSR_ERASE_Msk                   (0x20UL)                  /*!< FLASH FSR: ERASE (Bitfield-Mask: 0x01)                      */
#define FLASH_FSR_PFPAGE_Pos                  (6UL)                     /*!< FLASH FSR: PFPAGE (Bit 6)                                   */
#define FLASH_FSR_PFPAGE_Msk                  (0x40UL)                  /*!< FLASH FSR: PFPAGE (Bitfield-Mask: 0x01)                     */
#define FLASH_FSR_PFOPER_Pos                  (8UL)                     /*!< FLASH FSR: PFOPER (Bit 8)                                   */
#define FLASH_FSR_PFOPER_Msk                  (0x100UL)                 /*!< FLASH FSR: PFOPER (Bitfield-Mask: 0x01)                     */
#define FLASH_FSR_SQER_Pos                    (10UL)                    /*!< FLASH FSR: SQER (Bit 10)                                    */
#define FLASH_FSR_SQER_Msk                    (0x400UL)                 /*!< FLASH FSR: SQER (Bitfield-Mask: 0x01)                       */
#define FLASH_FSR_PROER_Pos                   (11UL)                    /*!< FLASH FSR: PROER (Bit 11)                                   */
#define FLASH_FSR_PROER_Msk                   (0x800UL)                 /*!< FLASH FSR: PROER (Bitfield-Mask: 0x01)                      */
#define FLASH_FSR_PFSBER_Pos                  (12UL)                    /*!< FLASH FSR: PFSBER (Bit 12)                                  */
#define FLASH_FSR_PFSBER_Msk                  (0x1000UL)                /*!< FLASH FSR: PFSBER (Bitfield-Mask: 0x01)                     */
#define FLASH_FSR_PFDBER_Pos                  (14UL)                    /*!< FLASH FSR: PFDBER (Bit 14)                                  */
#define FLASH_FSR_PFDBER_Msk                  (0x4000UL)                /*!< FLASH FSR: PFDBER (Bitfield-Mask: 0x01)                     */
#define FLASH_FSR_PROIN_Pos                   (16UL)                    /*!< FLASH FSR: PROIN (Bit 16)                                   */
#define FLASH_FSR_PROIN_Msk                   (0x10000UL)               /*!< FLASH FSR: PROIN (Bitfield-Mask: 0x01)                      */
#define FLASH_FSR_RPROIN_Pos                  (18UL)                    /*!< FLASH FSR: RPROIN (Bit 18)                                  */
#define FLASH_FSR_RPROIN_Msk                  (0x40000UL)               /*!< FLASH FSR: RPROIN (Bitfield-Mask: 0x01)                     */
#define FLASH_FSR_RPRODIS_Pos                 (19UL)                    /*!< FLASH FSR: RPRODIS (Bit 19)                                 */
#define FLASH_FSR_RPRODIS_Msk                 (0x80000UL)               /*!< FLASH FSR: RPRODIS (Bitfield-Mask: 0x01)                    */
#define FLASH_FSR_WPROIN0_Pos                 (21UL)                    /*!< FLASH FSR: WPROIN0 (Bit 21)                                 */
#define FLASH_FSR_WPROIN0_Msk                 (0x200000UL)              /*!< FLASH FSR: WPROIN0 (Bitfield-Mask: 0x01)                    */
#define FLASH_FSR_WPROIN1_Pos                 (22UL)                    /*!< FLASH FSR: WPROIN1 (Bit 22)                                 */
#define FLASH_FSR_WPROIN1_Msk                 (0x400000UL)              /*!< FLASH FSR: WPROIN1 (Bitfield-Mask: 0x01)                    */
#define FLASH_FSR_WPROIN2_Pos                 (23UL)                    /*!< FLASH FSR: WPROIN2 (Bit 23)                                 */
#define FLASH_FSR_WPROIN2_Msk                 (0x800000UL)              /*!< FLASH FSR: WPROIN2 (Bitfield-Mask: 0x01)                    */
#define FLASH_FSR_WPRODIS0_Pos                (25UL)                    /*!< FLASH FSR: WPRODIS0 (Bit 25)                                */
#define FLASH_FSR_WPRODIS0_Msk                (0x2000000UL)             /*!< FLASH FSR: WPRODIS0 (Bitfield-Mask: 0x01)                   */
#define FLASH_FSR_WPRODIS1_Pos                (26UL)                    /*!< FLASH FSR: WPRODIS1 (Bit 26)                                */
#define FLASH_FSR_WPRODIS1_Msk                (0x4000000UL)             /*!< FLASH FSR: WPRODIS1 (Bitfield-Mask: 0x01)                   */
#define FLASH_FSR_SLM_Pos                     (28UL)                    /*!< FLASH FSR: SLM (Bit 28)                                     */
#define FLASH_FSR_SLM_Msk                     (0x10000000UL)            /*!< FLASH FSR: SLM (Bitfield-Mask: 0x01)                        */
#define FLASH_FSR_VER_Pos                     (31UL)                    /*!< FLASH FSR: VER (Bit 31)                                     */
#define FLASH_FSR_VER_Msk                     (0x80000000UL)            /*!< FLASH FSR: VER (Bitfield-Mask: 0x01)                        */

/* ---------------------------------  FLASH_FCON  --------------------------------- */
#define FLASH_FCON_WSPFLASH_Pos               (0UL)                     /*!< FLASH FCON: WSPFLASH (Bit 0)                                */
#define FLASH_FCON_WSPFLASH_Msk               (0xfUL)                   /*!< FLASH FCON: WSPFLASH (Bitfield-Mask: 0x0f)                  */
#define FLASH_FCON_WSECPF_Pos                 (4UL)                     /*!< FLASH FCON: WSECPF (Bit 4)                                  */
#define FLASH_FCON_WSECPF_Msk                 (0x10UL)                  /*!< FLASH FCON: WSECPF (Bitfield-Mask: 0x01)                    */
#define FLASH_FCON_IDLE_Pos                   (13UL)                    /*!< FLASH FCON: IDLE (Bit 13)                                   */
#define FLASH_FCON_IDLE_Msk                   (0x2000UL)                /*!< FLASH FCON: IDLE (Bitfield-Mask: 0x01)                      */
#define FLASH_FCON_ESLDIS_Pos                 (14UL)                    /*!< FLASH FCON: ESLDIS (Bit 14)                                 */
#define FLASH_FCON_ESLDIS_Msk                 (0x4000UL)                /*!< FLASH FCON: ESLDIS (Bitfield-Mask: 0x01)                    */
#define FLASH_FCON_SLEEP_Pos                  (15UL)                    /*!< FLASH FCON: SLEEP (Bit 15)                                  */
#define FLASH_FCON_SLEEP_Msk                  (0x8000UL)                /*!< FLASH FCON: SLEEP (Bitfield-Mask: 0x01)                     */
#define FLASH_FCON_RPA_Pos                    (16UL)                    /*!< FLASH FCON: RPA (Bit 16)                                    */
#define FLASH_FCON_RPA_Msk                    (0x10000UL)               /*!< FLASH FCON: RPA (Bitfield-Mask: 0x01)                       */
#define FLASH_FCON_DCF_Pos                    (17UL)                    /*!< FLASH FCON: DCF (Bit 17)                                    */
#define FLASH_FCON_DCF_Msk                    (0x20000UL)               /*!< FLASH FCON: DCF (Bitfield-Mask: 0x01)                       */
#define FLASH_FCON_DDF_Pos                    (18UL)                    /*!< FLASH FCON: DDF (Bit 18)                                    */
#define FLASH_FCON_DDF_Msk                    (0x40000UL)               /*!< FLASH FCON: DDF (Bitfield-Mask: 0x01)                       */
#define FLASH_FCON_VOPERM_Pos                 (24UL)                    /*!< FLASH FCON: VOPERM (Bit 24)                                 */
#define FLASH_FCON_VOPERM_Msk                 (0x1000000UL)             /*!< FLASH FCON: VOPERM (Bitfield-Mask: 0x01)                    */
#define FLASH_FCON_SQERM_Pos                  (25UL)                    /*!< FLASH FCON: SQERM (Bit 25)                                  */
#define FLASH_FCON_SQERM_Msk                  (0x2000000UL)             /*!< FLASH FCON: SQERM (Bitfield-Mask: 0x01)                     */
#define FLASH_FCON_PROERM_Pos                 (26UL)                    /*!< FLASH FCON: PROERM (Bit 26)                                 */
#define FLASH_FCON_PROERM_Msk                 (0x4000000UL)             /*!< FLASH FCON: PROERM (Bitfield-Mask: 0x01)                    */
#define FLASH_FCON_PFSBERM_Pos                (27UL)                    /*!< FLASH FCON: PFSBERM (Bit 27)                                */
#define FLASH_FCON_PFSBERM_Msk                (0x8000000UL)             /*!< FLASH FCON: PFSBERM (Bitfield-Mask: 0x01)                   */
#define FLASH_FCON_PFDBERM_Pos                (29UL)                    /*!< FLASH FCON: PFDBERM (Bit 29)                                */
#define FLASH_FCON_PFDBERM_Msk                (0x20000000UL)            /*!< FLASH FCON: PFDBERM (Bitfield-Mask: 0x01)                   */
#define FLASH_FCON_EOBM_Pos                   (31UL)                    /*!< FLASH FCON: EOBM (Bit 31)                                   */
#define FLASH_FCON_EOBM_Msk                   (0x80000000UL)            /*!< FLASH FCON: EOBM (Bitfield-Mask: 0x01)                      */

/* ---------------------------------  FLASH_MARP  --------------------------------- */
#define FLASH_MARP_MARGIN_Pos                 (0UL)                     /*!< FLASH MARP: MARGIN (Bit 0)                                  */
#define FLASH_MARP_MARGIN_Msk                 (0xfUL)                   /*!< FLASH MARP: MARGIN (Bitfield-Mask: 0x0f)                    */
#define FLASH_MARP_TRAPDIS_Pos                (15UL)                    /*!< FLASH MARP: TRAPDIS (Bit 15)                                */
#define FLASH_MARP_TRAPDIS_Msk                (0x8000UL)                /*!< FLASH MARP: TRAPDIS (Bitfield-Mask: 0x01)                   */

/* --------------------------------  FLASH_PROCON0  ------------------------------- */
#define FLASH_PROCON0_S0L_Pos                 (0UL)                     /*!< FLASH PROCON0: S0L (Bit 0)                                  */
#define FLASH_PROCON0_S0L_Msk                 (0x1UL)                   /*!< FLASH PROCON0: S0L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S1L_Pos                 (1UL)                     /*!< FLASH PROCON0: S1L (Bit 1)                                  */
#define FLASH_PROCON0_S1L_Msk                 (0x2UL)                   /*!< FLASH PROCON0: S1L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S2L_Pos                 (2UL)                     /*!< FLASH PROCON0: S2L (Bit 2)                                  */
#define FLASH_PROCON0_S2L_Msk                 (0x4UL)                   /*!< FLASH PROCON0: S2L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S3L_Pos                 (3UL)                     /*!< FLASH PROCON0: S3L (Bit 3)                                  */
#define FLASH_PROCON0_S3L_Msk                 (0x8UL)                   /*!< FLASH PROCON0: S3L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S4L_Pos                 (4UL)                     /*!< FLASH PROCON0: S4L (Bit 4)                                  */
#define FLASH_PROCON0_S4L_Msk                 (0x10UL)                  /*!< FLASH PROCON0: S4L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S5L_Pos                 (5UL)                     /*!< FLASH PROCON0: S5L (Bit 5)                                  */
#define FLASH_PROCON0_S5L_Msk                 (0x20UL)                  /*!< FLASH PROCON0: S5L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S6L_Pos                 (6UL)                     /*!< FLASH PROCON0: S6L (Bit 6)                                  */
#define FLASH_PROCON0_S6L_Msk                 (0x40UL)                  /*!< FLASH PROCON0: S6L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S7L_Pos                 (7UL)                     /*!< FLASH PROCON0: S7L (Bit 7)                                  */
#define FLASH_PROCON0_S7L_Msk                 (0x80UL)                  /*!< FLASH PROCON0: S7L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S8L_Pos                 (8UL)                     /*!< FLASH PROCON0: S8L (Bit 8)                                  */
#define FLASH_PROCON0_S8L_Msk                 (0x100UL)                 /*!< FLASH PROCON0: S8L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_S9L_Pos                 (9UL)                     /*!< FLASH PROCON0: S9L (Bit 9)                                  */
#define FLASH_PROCON0_S9L_Msk                 (0x200UL)                 /*!< FLASH PROCON0: S9L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON0_RPRO_Pos                (15UL)                    /*!< FLASH PROCON0: RPRO (Bit 15)                                */
#define FLASH_PROCON0_RPRO_Msk                (0x8000UL)                /*!< FLASH PROCON0: RPRO (Bitfield-Mask: 0x01)                   */

/* --------------------------------  FLASH_PROCON1  ------------------------------- */
#define FLASH_PROCON1_S0L_Pos                 (0UL)                     /*!< FLASH PROCON1: S0L (Bit 0)                                  */
#define FLASH_PROCON1_S0L_Msk                 (0x1UL)                   /*!< FLASH PROCON1: S0L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S1L_Pos                 (1UL)                     /*!< FLASH PROCON1: S1L (Bit 1)                                  */
#define FLASH_PROCON1_S1L_Msk                 (0x2UL)                   /*!< FLASH PROCON1: S1L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S2L_Pos                 (2UL)                     /*!< FLASH PROCON1: S2L (Bit 2)                                  */
#define FLASH_PROCON1_S2L_Msk                 (0x4UL)                   /*!< FLASH PROCON1: S2L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S3L_Pos                 (3UL)                     /*!< FLASH PROCON1: S3L (Bit 3)                                  */
#define FLASH_PROCON1_S3L_Msk                 (0x8UL)                   /*!< FLASH PROCON1: S3L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S4L_Pos                 (4UL)                     /*!< FLASH PROCON1: S4L (Bit 4)                                  */
#define FLASH_PROCON1_S4L_Msk                 (0x10UL)                  /*!< FLASH PROCON1: S4L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S5L_Pos                 (5UL)                     /*!< FLASH PROCON1: S5L (Bit 5)                                  */
#define FLASH_PROCON1_S5L_Msk                 (0x20UL)                  /*!< FLASH PROCON1: S5L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S6L_Pos                 (6UL)                     /*!< FLASH PROCON1: S6L (Bit 6)                                  */
#define FLASH_PROCON1_S6L_Msk                 (0x40UL)                  /*!< FLASH PROCON1: S6L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S7L_Pos                 (7UL)                     /*!< FLASH PROCON1: S7L (Bit 7)                                  */
#define FLASH_PROCON1_S7L_Msk                 (0x80UL)                  /*!< FLASH PROCON1: S7L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S8L_Pos                 (8UL)                     /*!< FLASH PROCON1: S8L (Bit 8)                                  */
#define FLASH_PROCON1_S8L_Msk                 (0x100UL)                 /*!< FLASH PROCON1: S8L (Bitfield-Mask: 0x01)                    */
#define FLASH_PROCON1_S9L_Pos                 (9UL)                     /*!< FLASH PROCON1: S9L (Bit 9)                                  */
#define FLASH_PROCON1_S9L_Msk                 (0x200UL)                 /*!< FLASH PROCON1: S9L (Bitfield-Mask: 0x01)                    */

/* --------------------------------  FLASH_PROCON2  ------------------------------- */
#define FLASH_PROCON2_S0ROM_Pos               (0UL)                     /*!< FLASH PROCON2: S0ROM (Bit 0)                                */
#define FLASH_PROCON2_S0ROM_Msk               (0x1UL)                   /*!< FLASH PROCON2: S0ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S1ROM_Pos               (1UL)                     /*!< FLASH PROCON2: S1ROM (Bit 1)                                */
#define FLASH_PROCON2_S1ROM_Msk               (0x2UL)                   /*!< FLASH PROCON2: S1ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S2ROM_Pos               (2UL)                     /*!< FLASH PROCON2: S2ROM (Bit 2)                                */
#define FLASH_PROCON2_S2ROM_Msk               (0x4UL)                   /*!< FLASH PROCON2: S2ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S3ROM_Pos               (3UL)                     /*!< FLASH PROCON2: S3ROM (Bit 3)                                */
#define FLASH_PROCON2_S3ROM_Msk               (0x8UL)                   /*!< FLASH PROCON2: S3ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S4ROM_Pos               (4UL)                     /*!< FLASH PROCON2: S4ROM (Bit 4)                                */
#define FLASH_PROCON2_S4ROM_Msk               (0x10UL)                  /*!< FLASH PROCON2: S4ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S5ROM_Pos               (5UL)                     /*!< FLASH PROCON2: S5ROM (Bit 5)                                */
#define FLASH_PROCON2_S5ROM_Msk               (0x20UL)                  /*!< FLASH PROCON2: S5ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S6ROM_Pos               (6UL)                     /*!< FLASH PROCON2: S6ROM (Bit 6)                                */
#define FLASH_PROCON2_S6ROM_Msk               (0x40UL)                  /*!< FLASH PROCON2: S6ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S7ROM_Pos               (7UL)                     /*!< FLASH PROCON2: S7ROM (Bit 7)                                */
#define FLASH_PROCON2_S7ROM_Msk               (0x80UL)                  /*!< FLASH PROCON2: S7ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S8ROM_Pos               (8UL)                     /*!< FLASH PROCON2: S8ROM (Bit 8)                                */
#define FLASH_PROCON2_S8ROM_Msk               (0x100UL)                 /*!< FLASH PROCON2: S8ROM (Bitfield-Mask: 0x01)                  */
#define FLASH_PROCON2_S9ROM_Pos               (9UL)                     /*!< FLASH PROCON2: S9ROM (Bit 9)                                */
#define FLASH_PROCON2_S9ROM_Msk               (0x200UL)                 /*!< FLASH PROCON2: S9ROM (Bitfield-Mask: 0x01)                  */


/* ================================================================================ */
/* ================          struct 'PREF' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  PREF_PCON  --------------------------------- */
#define PREF_PCON_IBYP_Pos                    (0UL)                     /*!< PREF PCON: IBYP (Bit 0)                                     */
#define PREF_PCON_IBYP_Msk                    (0x1UL)                   /*!< PREF PCON: IBYP (Bitfield-Mask: 0x01)                       */
#define PREF_PCON_IINV_Pos                    (1UL)                     /*!< PREF PCON: IINV (Bit 1)                                     */
#define PREF_PCON_IINV_Msk                    (0x2UL)                   /*!< PREF PCON: IINV (Bitfield-Mask: 0x01)                       */


/* ================================================================================ */
/* ================           Group 'PMU' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  PMU_ID  ----------------------------------- */
#define PMU_ID_MOD_REV_Pos                    (0UL)                     /*!< PMU ID: MOD_REV (Bit 0)                                     */
#define PMU_ID_MOD_REV_Msk                    (0xffUL)                  /*!< PMU ID: MOD_REV (Bitfield-Mask: 0xff)                       */
#define PMU_ID_MOD_TYPE_Pos                   (8UL)                     /*!< PMU ID: MOD_TYPE (Bit 8)                                    */
#define PMU_ID_MOD_TYPE_Msk                   (0xff00UL)                /*!< PMU ID: MOD_TYPE (Bitfield-Mask: 0xff)                      */
#define PMU_ID_MOD_NUMBER_Pos                 (16UL)                    /*!< PMU ID: MOD_NUMBER (Bit 16)                                 */
#define PMU_ID_MOD_NUMBER_Msk                 (0xffff0000UL)            /*!< PMU ID: MOD_NUMBER (Bitfield-Mask: 0xffff)                  */


/* ================================================================================ */
/* ================          struct 'WDT' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  WDT_ID  ----------------------------------- */
#define WDT_ID_MOD_REV_Pos                    (0UL)                     /*!< WDT ID: MOD_REV (Bit 0)                                     */
#define WDT_ID_MOD_REV_Msk                    (0xffUL)                  /*!< WDT ID: MOD_REV (Bitfield-Mask: 0xff)                       */
#define WDT_ID_MOD_TYPE_Pos                   (8UL)                     /*!< WDT ID: MOD_TYPE (Bit 8)                                    */
#define WDT_ID_MOD_TYPE_Msk                   (0xff00UL)                /*!< WDT ID: MOD_TYPE (Bitfield-Mask: 0xff)                      */
#define WDT_ID_MOD_NUMBER_Pos                 (16UL)                    /*!< WDT ID: MOD_NUMBER (Bit 16)                                 */
#define WDT_ID_MOD_NUMBER_Msk                 (0xffff0000UL)            /*!< WDT ID: MOD_NUMBER (Bitfield-Mask: 0xffff)                  */

/* -----------------------------------  WDT_CTR  ---------------------------------- */
#define WDT_CTR_ENB_Pos                       (0UL)                     /*!< WDT CTR: ENB (Bit 0)                                        */
#define WDT_CTR_ENB_Msk                       (0x1UL)                   /*!< WDT CTR: ENB (Bitfield-Mask: 0x01)                          */
#define WDT_CTR_PRE_Pos                       (1UL)                     /*!< WDT CTR: PRE (Bit 1)                                        */
#define WDT_CTR_PRE_Msk                       (0x2UL)                   /*!< WDT CTR: PRE (Bitfield-Mask: 0x01)                          */
#define WDT_CTR_DSP_Pos                       (4UL)                     /*!< WDT CTR: DSP (Bit 4)                                        */
#define WDT_CTR_DSP_Msk                       (0x10UL)                  /*!< WDT CTR: DSP (Bitfield-Mask: 0x01)                          */
#define WDT_CTR_SPW_Pos                       (8UL)                     /*!< WDT CTR: SPW (Bit 8)                                        */
#define WDT_CTR_SPW_Msk                       (0xff00UL)                /*!< WDT CTR: SPW (Bitfield-Mask: 0xff)                          */

/* -----------------------------------  WDT_SRV  ---------------------------------- */
#define WDT_SRV_SRV_Pos                       (0UL)                     /*!< WDT SRV: SRV (Bit 0)                                        */
#define WDT_SRV_SRV_Msk                       (0xffffffffUL)            /*!< WDT SRV: SRV (Bitfield-Mask: 0xffffffff)                    */

/* -----------------------------------  WDT_TIM  ---------------------------------- */
#define WDT_TIM_TIM_Pos                       (0UL)                     /*!< WDT TIM: TIM (Bit 0)                                        */
#define WDT_TIM_TIM_Msk                       (0xffffffffUL)            /*!< WDT TIM: TIM (Bitfield-Mask: 0xffffffff)                    */

/* -----------------------------------  WDT_WLB  ---------------------------------- */
#define WDT_WLB_WLB_Pos                       (0UL)                     /*!< WDT WLB: WLB (Bit 0)                                        */
#define WDT_WLB_WLB_Msk                       (0xffffffffUL)            /*!< WDT WLB: WLB (Bitfield-Mask: 0xffffffff)                    */

/* -----------------------------------  WDT_WUB  ---------------------------------- */
#define WDT_WUB_WUB_Pos                       (0UL)                     /*!< WDT WUB: WUB (Bit 0)                                        */
#define WDT_WUB_WUB_Msk                       (0xffffffffUL)            /*!< WDT WUB: WUB (Bitfield-Mask: 0xffffffff)                    */

/* ---------------------------------  WDT_WDTSTS  --------------------------------- */
#define WDT_WDTSTS_ALMS_Pos                   (0UL)                     /*!< WDT WDTSTS: ALMS (Bit 0)                                    */
#define WDT_WDTSTS_ALMS_Msk                   (0x1UL)                   /*!< WDT WDTSTS: ALMS (Bitfield-Mask: 0x01)                      */

/* ---------------------------------  WDT_WDTCLR  --------------------------------- */
#define WDT_WDTCLR_ALMC_Pos                   (0UL)                     /*!< WDT WDTCLR: ALMC (Bit 0)                                    */
#define WDT_WDTCLR_ALMC_Msk                   (0x1UL)                   /*!< WDT WDTCLR: ALMC (Bitfield-Mask: 0x01)                      */


/* ================================================================================ */
/* ================          struct 'RTC' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  RTC_ID  ----------------------------------- */
#define RTC_ID_MOD_REV_Pos                    (0UL)                     /*!< RTC ID: MOD_REV (Bit 0)                                     */
#define RTC_ID_MOD_REV_Msk                    (0xffUL)                  /*!< RTC ID: MOD_REV (Bitfield-Mask: 0xff)                       */
#define RTC_ID_MOD_TYPE_Pos                   (8UL)                     /*!< RTC ID: MOD_TYPE (Bit 8)                                    */
#define RTC_ID_MOD_TYPE_Msk                   (0xff00UL)                /*!< RTC ID: MOD_TYPE (Bitfield-Mask: 0xff)                      */
#define RTC_ID_MOD_NUMBER_Pos                 (16UL)                    /*!< RTC ID: MOD_NUMBER (Bit 16)                                 */
#define RTC_ID_MOD_NUMBER_Msk                 (0xffff0000UL)            /*!< RTC ID: MOD_NUMBER (Bitfield-Mask: 0xffff)                  */

/* -----------------------------------  RTC_CTR  ---------------------------------- */
#define RTC_CTR_ENB_Pos                       (0UL)                     /*!< RTC CTR: ENB (Bit 0)                                        */
#define RTC_CTR_ENB_Msk                       (0x1UL)                   /*!< RTC CTR: ENB (Bitfield-Mask: 0x01)                          */
#define RTC_CTR_TAE_Pos                       (2UL)                     /*!< RTC CTR: TAE (Bit 2)                                        */
#define RTC_CTR_TAE_Msk                       (0x4UL)                   /*!< RTC CTR: TAE (Bitfield-Mask: 0x01)                          */
#define RTC_CTR_ESEC_Pos                      (8UL)                     /*!< RTC CTR: ESEC (Bit 8)                                       */
#define RTC_CTR_ESEC_Msk                      (0x100UL)                 /*!< RTC CTR: ESEC (Bitfield-Mask: 0x01)                         */
#define RTC_CTR_EMIC_Pos                      (9UL)                     /*!< RTC CTR: EMIC (Bit 9)                                       */
#define RTC_CTR_EMIC_Msk                      (0x200UL)                 /*!< RTC CTR: EMIC (Bitfield-Mask: 0x01)                         */
#define RTC_CTR_EHOC_Pos                      (10UL)                    /*!< RTC CTR: EHOC (Bit 10)                                      */
#define RTC_CTR_EHOC_Msk                      (0x400UL)                 /*!< RTC CTR: EHOC (Bitfield-Mask: 0x01)                         */
#define RTC_CTR_EDAC_Pos                      (11UL)                    /*!< RTC CTR: EDAC (Bit 11)                                      */
#define RTC_CTR_EDAC_Msk                      (0x800UL)                 /*!< RTC CTR: EDAC (Bitfield-Mask: 0x01)                         */
#define RTC_CTR_EMOC_Pos                      (13UL)                    /*!< RTC CTR: EMOC (Bit 13)                                      */
#define RTC_CTR_EMOC_Msk                      (0x2000UL)                /*!< RTC CTR: EMOC (Bitfield-Mask: 0x01)                         */
#define RTC_CTR_EYEC_Pos                      (14UL)                    /*!< RTC CTR: EYEC (Bit 14)                                      */
#define RTC_CTR_EYEC_Msk                      (0x4000UL)                /*!< RTC CTR: EYEC (Bitfield-Mask: 0x01)                         */
#define RTC_CTR_DIV_Pos                       (16UL)                    /*!< RTC CTR: DIV (Bit 16)                                       */
#define RTC_CTR_DIV_Msk                       (0xffff0000UL)            /*!< RTC CTR: DIV (Bitfield-Mask: 0xffff)                        */

/* ---------------------------------  RTC_RAWSTAT  -------------------------------- */
#define RTC_RAWSTAT_RPSE_Pos                  (0UL)                     /*!< RTC RAWSTAT: RPSE (Bit 0)                                   */
#define RTC_RAWSTAT_RPSE_Msk                  (0x1UL)                   /*!< RTC RAWSTAT: RPSE (Bitfield-Mask: 0x01)                     */
#define RTC_RAWSTAT_RPMI_Pos                  (1UL)                     /*!< RTC RAWSTAT: RPMI (Bit 1)                                   */
#define RTC_RAWSTAT_RPMI_Msk                  (0x2UL)                   /*!< RTC RAWSTAT: RPMI (Bitfield-Mask: 0x01)                     */
#define RTC_RAWSTAT_RPHO_Pos                  (2UL)                     /*!< RTC RAWSTAT: RPHO (Bit 2)                                   */
#define RTC_RAWSTAT_RPHO_Msk                  (0x4UL)                   /*!< RTC RAWSTAT: RPHO (Bitfield-Mask: 0x01)                     */
#define RTC_RAWSTAT_RPDA_Pos                  (3UL)                     /*!< RTC RAWSTAT: RPDA (Bit 3)                                   */
#define RTC_RAWSTAT_RPDA_Msk                  (0x8UL)                   /*!< RTC RAWSTAT: RPDA (Bitfield-Mask: 0x01)                     */
#define RTC_RAWSTAT_RPMO_Pos                  (5UL)                     /*!< RTC RAWSTAT: RPMO (Bit 5)                                   */
#define RTC_RAWSTAT_RPMO_Msk                  (0x20UL)                  /*!< RTC RAWSTAT: RPMO (Bitfield-Mask: 0x01)                     */
#define RTC_RAWSTAT_RPYE_Pos                  (6UL)                     /*!< RTC RAWSTAT: RPYE (Bit 6)                                   */
#define RTC_RAWSTAT_RPYE_Msk                  (0x40UL)                  /*!< RTC RAWSTAT: RPYE (Bitfield-Mask: 0x01)                     */
#define RTC_RAWSTAT_RAI_Pos                   (8UL)                     /*!< RTC RAWSTAT: RAI (Bit 8)                                    */
#define RTC_RAWSTAT_RAI_Msk                   (0x100UL)                 /*!< RTC RAWSTAT: RAI (Bitfield-Mask: 0x01)                      */

/* ----------------------------------  RTC_STSSR  --------------------------------- */
#define RTC_STSSR_SPSE_Pos                    (0UL)                     /*!< RTC STSSR: SPSE (Bit 0)                                     */
#define RTC_STSSR_SPSE_Msk                    (0x1UL)                   /*!< RTC STSSR: SPSE (Bitfield-Mask: 0x01)                       */
#define RTC_STSSR_SPMI_Pos                    (1UL)                     /*!< RTC STSSR: SPMI (Bit 1)                                     */
#define RTC_STSSR_SPMI_Msk                    (0x2UL)                   /*!< RTC STSSR: SPMI (Bitfield-Mask: 0x01)                       */
#define RTC_STSSR_SPHO_Pos                    (2UL)                     /*!< RTC STSSR: SPHO (Bit 2)                                     */
#define RTC_STSSR_SPHO_Msk                    (0x4UL)                   /*!< RTC STSSR: SPHO (Bitfield-Mask: 0x01)                       */
#define RTC_STSSR_SPDA_Pos                    (3UL)                     /*!< RTC STSSR: SPDA (Bit 3)                                     */
#define RTC_STSSR_SPDA_Msk                    (0x8UL)                   /*!< RTC STSSR: SPDA (Bitfield-Mask: 0x01)                       */
#define RTC_STSSR_SPMO_Pos                    (5UL)                     /*!< RTC STSSR: SPMO (Bit 5)                                     */
#define RTC_STSSR_SPMO_Msk                    (0x20UL)                  /*!< RTC STSSR: SPMO (Bitfield-Mask: 0x01)                       */
#define RTC_STSSR_SPYE_Pos                    (6UL)                     /*!< RTC STSSR: SPYE (Bit 6)                                     */
#define RTC_STSSR_SPYE_Msk                    (0x40UL)                  /*!< RTC STSSR: SPYE (Bitfield-Mask: 0x01)                       */
#define RTC_STSSR_SAI_Pos                     (8UL)                     /*!< RTC STSSR: SAI (Bit 8)                                      */
#define RTC_STSSR_SAI_Msk                     (0x100UL)                 /*!< RTC STSSR: SAI (Bitfield-Mask: 0x01)                        */

/* ----------------------------------  RTC_MSKSR  --------------------------------- */
#define RTC_MSKSR_MPSE_Pos                    (0UL)                     /*!< RTC MSKSR: MPSE (Bit 0)                                     */
#define RTC_MSKSR_MPSE_Msk                    (0x1UL)                   /*!< RTC MSKSR: MPSE (Bitfield-Mask: 0x01)                       */
#define RTC_MSKSR_MPMI_Pos                    (1UL)                     /*!< RTC MSKSR: MPMI (Bit 1)                                     */
#define RTC_MSKSR_MPMI_Msk                    (0x2UL)                   /*!< RTC MSKSR: MPMI (Bitfield-Mask: 0x01)                       */
#define RTC_MSKSR_MPHO_Pos                    (2UL)                     /*!< RTC MSKSR: MPHO (Bit 2)                                     */
#define RTC_MSKSR_MPHO_Msk                    (0x4UL)                   /*!< RTC MSKSR: MPHO (Bitfield-Mask: 0x01)                       */
#define RTC_MSKSR_MPDA_Pos                    (3UL)                     /*!< RTC MSKSR: MPDA (Bit 3)                                     */
#define RTC_MSKSR_MPDA_Msk                    (0x8UL)                   /*!< RTC MSKSR: MPDA (Bitfield-Mask: 0x01)                       */
#define RTC_MSKSR_MPMO_Pos                    (5UL)                     /*!< RTC MSKSR: MPMO (Bit 5)                                     */
#define RTC_MSKSR_MPMO_Msk                    (0x20UL)                  /*!< RTC MSKSR: MPMO (Bitfield-Mask: 0x01)                       */
#define RTC_MSKSR_MPYE_Pos                    (6UL)                     /*!< RTC MSKSR: MPYE (Bit 6)                                     */
#define RTC_MSKSR_MPYE_Msk                    (0x40UL)                  /*!< RTC MSKSR: MPYE (Bitfield-Mask: 0x01)                       */
#define RTC_MSKSR_MAI_Pos                     (8UL)                     /*!< RTC MSKSR: MAI (Bit 8)                                      */
#define RTC_MSKSR_MAI_Msk                     (0x100UL)                 /*!< RTC MSKSR: MAI (Bitfield-Mask: 0x01)                        */

/* ----------------------------------  RTC_CLRSR  --------------------------------- */
#define RTC_CLRSR_RPSE_Pos                    (0UL)                     /*!< RTC CLRSR: RPSE (Bit 0)                                     */
#define RTC_CLRSR_RPSE_Msk                    (0x1UL)                   /*!< RTC CLRSR: RPSE (Bitfield-Mask: 0x01)                       */
#define RTC_CLRSR_RPMI_Pos                    (1UL)                     /*!< RTC CLRSR: RPMI (Bit 1)                                     */
#define RTC_CLRSR_RPMI_Msk                    (0x2UL)                   /*!< RTC CLRSR: RPMI (Bitfield-Mask: 0x01)                       */
#define RTC_CLRSR_RPHO_Pos                    (2UL)                     /*!< RTC CLRSR: RPHO (Bit 2)                                     */
#define RTC_CLRSR_RPHO_Msk                    (0x4UL)                   /*!< RTC CLRSR: RPHO (Bitfield-Mask: 0x01)                       */
#define RTC_CLRSR_RPDA_Pos                    (3UL)                     /*!< RTC CLRSR: RPDA (Bit 3)                                     */
#define RTC_CLRSR_RPDA_Msk                    (0x8UL)                   /*!< RTC CLRSR: RPDA (Bitfield-Mask: 0x01)                       */
#define RTC_CLRSR_RPMO_Pos                    (5UL)                     /*!< RTC CLRSR: RPMO (Bit 5)                                     */
#define RTC_CLRSR_RPMO_Msk                    (0x20UL)                  /*!< RTC CLRSR: RPMO (Bitfield-Mask: 0x01)                       */
#define RTC_CLRSR_RPYE_Pos                    (6UL)                     /*!< RTC CLRSR: RPYE (Bit 6)                                     */
#define RTC_CLRSR_RPYE_Msk                    (0x40UL)                  /*!< RTC CLRSR: RPYE (Bitfield-Mask: 0x01)                       */
#define RTC_CLRSR_RAI_Pos                     (8UL)                     /*!< RTC CLRSR: RAI (Bit 8)                                      */
#define RTC_CLRSR_RAI_Msk                     (0x100UL)                 /*!< RTC CLRSR: RAI (Bitfield-Mask: 0x01)                        */

/* ----------------------------------  RTC_ATIM0  --------------------------------- */
#define RTC_ATIM0_ASE_Pos                     (0UL)                     /*!< RTC ATIM0: ASE (Bit 0)                                      */
#define RTC_ATIM0_ASE_Msk                     (0x3fUL)                  /*!< RTC ATIM0: ASE (Bitfield-Mask: 0x3f)                        */
#define RTC_ATIM0_AMI_Pos                     (8UL)                     /*!< RTC ATIM0: AMI (Bit 8)                                      */
#define RTC_ATIM0_AMI_Msk                     (0x3f00UL)                /*!< RTC ATIM0: AMI (Bitfield-Mask: 0x3f)                        */
#define RTC_ATIM0_AHO_Pos                     (16UL)                    /*!< RTC ATIM0: AHO (Bit 16)                                     */
#define RTC_ATIM0_AHO_Msk                     (0x1f0000UL)              /*!< RTC ATIM0: AHO (Bitfield-Mask: 0x1f)                        */
#define RTC_ATIM0_ADA_Pos                     (24UL)                    /*!< RTC ATIM0: ADA (Bit 24)                                     */
#define RTC_ATIM0_ADA_Msk                     (0x1f000000UL)            /*!< RTC ATIM0: ADA (Bitfield-Mask: 0x1f)                        */

/* ----------------------------------  RTC_ATIM1  --------------------------------- */
#define RTC_ATIM1_AMO_Pos                     (8UL)                     /*!< RTC ATIM1: AMO (Bit 8)                                      */
#define RTC_ATIM1_AMO_Msk                     (0xf00UL)                 /*!< RTC ATIM1: AMO (Bitfield-Mask: 0x0f)                        */
#define RTC_ATIM1_AYE_Pos                     (16UL)                    /*!< RTC ATIM1: AYE (Bit 16)                                     */
#define RTC_ATIM1_AYE_Msk                     (0xffff0000UL)            /*!< RTC ATIM1: AYE (Bitfield-Mask: 0xffff)                      */

/* ----------------------------------  RTC_TIM0  ---------------------------------- */
#define RTC_TIM0_SE_Pos                       (0UL)                     /*!< RTC TIM0: SE (Bit 0)                                        */
#define RTC_TIM0_SE_Msk                       (0x3fUL)                  /*!< RTC TIM0: SE (Bitfield-Mask: 0x3f)                          */
#define RTC_TIM0_MI_Pos                       (8UL)                     /*!< RTC TIM0: MI (Bit 8)                                        */
#define RTC_TIM0_MI_Msk                       (0x3f00UL)                /*!< RTC TIM0: MI (Bitfield-Mask: 0x3f)                          */
#define RTC_TIM0_HO_Pos                       (16UL)                    /*!< RTC TIM0: HO (Bit 16)                                       */
#define RTC_TIM0_HO_Msk                       (0x1f0000UL)              /*!< RTC TIM0: HO (Bitfield-Mask: 0x1f)                          */
#define RTC_TIM0_DA_Pos                       (24UL)                    /*!< RTC TIM0: DA (Bit 24)                                       */
#define RTC_TIM0_DA_Msk                       (0x1f000000UL)            /*!< RTC TIM0: DA (Bitfield-Mask: 0x1f)                          */

/* ----------------------------------  RTC_TIM1  ---------------------------------- */
#define RTC_TIM1_DAWE_Pos                     (0UL)                     /*!< RTC TIM1: DAWE (Bit 0)                                      */
#define RTC_TIM1_DAWE_Msk                     (0x7UL)                   /*!< RTC TIM1: DAWE (Bitfield-Mask: 0x07)                        */
#define RTC_TIM1_MO_Pos                       (8UL)                     /*!< RTC TIM1: MO (Bit 8)                                        */
#define RTC_TIM1_MO_Msk                       (0xf00UL)                 /*!< RTC TIM1: MO (Bitfield-Mask: 0x0f)                          */
#define RTC_TIM1_YE_Pos                       (16UL)                    /*!< RTC TIM1: YE (Bit 16)                                       */
#define RTC_TIM1_YE_Msk                       (0xffff0000UL)            /*!< RTC TIM1: YE (Bitfield-Mask: 0xffff)                        */


/* ================================================================================ */
/* ================        struct 'SCU_CLK' Position & Mask        ================ */
/* ================================================================================ */


/* -------------------------------  SCU_CLK_CLKSTAT  ------------------------------ */
#define SCU_CLK_CLKSTAT_USBCST_Pos            (0UL)                     /*!< SCU_CLK CLKSTAT: USBCST (Bit 0)                             */
#define SCU_CLK_CLKSTAT_USBCST_Msk            (0x1UL)                   /*!< SCU_CLK CLKSTAT: USBCST (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CLKSTAT_ETH0CST_Pos           (2UL)                     /*!< SCU_CLK CLKSTAT: ETH0CST (Bit 2)                            */
#define SCU_CLK_CLKSTAT_ETH0CST_Msk           (0x4UL)                   /*!< SCU_CLK CLKSTAT: ETH0CST (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CLKSTAT_CCUCST_Pos            (4UL)                     /*!< SCU_CLK CLKSTAT: CCUCST (Bit 4)                             */
#define SCU_CLK_CLKSTAT_CCUCST_Msk            (0x10UL)                  /*!< SCU_CLK CLKSTAT: CCUCST (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CLKSTAT_WDTCST_Pos            (5UL)                     /*!< SCU_CLK CLKSTAT: WDTCST (Bit 5)                             */
#define SCU_CLK_CLKSTAT_WDTCST_Msk            (0x20UL)                  /*!< SCU_CLK CLKSTAT: WDTCST (Bitfield-Mask: 0x01)               */

/* -------------------------------  SCU_CLK_CLKSET  ------------------------------- */
#define SCU_CLK_CLKSET_USBCEN_Pos             (0UL)                     /*!< SCU_CLK CLKSET: USBCEN (Bit 0)                              */
#define SCU_CLK_CLKSET_USBCEN_Msk             (0x1UL)                   /*!< SCU_CLK CLKSET: USBCEN (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CLKSET_ETH0CEN_Pos            (2UL)                     /*!< SCU_CLK CLKSET: ETH0CEN (Bit 2)                             */
#define SCU_CLK_CLKSET_ETH0CEN_Msk            (0x4UL)                   /*!< SCU_CLK CLKSET: ETH0CEN (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CLKSET_CCUCEN_Pos             (4UL)                     /*!< SCU_CLK CLKSET: CCUCEN (Bit 4)                              */
#define SCU_CLK_CLKSET_CCUCEN_Msk             (0x10UL)                  /*!< SCU_CLK CLKSET: CCUCEN (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CLKSET_WDTCEN_Pos             (5UL)                     /*!< SCU_CLK CLKSET: WDTCEN (Bit 5)                              */
#define SCU_CLK_CLKSET_WDTCEN_Msk             (0x20UL)                  /*!< SCU_CLK CLKSET: WDTCEN (Bitfield-Mask: 0x01)                */

/* -------------------------------  SCU_CLK_CLKCLR  ------------------------------- */
#define SCU_CLK_CLKCLR_USBCDI_Pos             (0UL)                     /*!< SCU_CLK CLKCLR: USBCDI (Bit 0)                              */
#define SCU_CLK_CLKCLR_USBCDI_Msk             (0x1UL)                   /*!< SCU_CLK CLKCLR: USBCDI (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CLKCLR_ETH0CDI_Pos            (2UL)                     /*!< SCU_CLK CLKCLR: ETH0CDI (Bit 2)                             */
#define SCU_CLK_CLKCLR_ETH0CDI_Msk            (0x4UL)                   /*!< SCU_CLK CLKCLR: ETH0CDI (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CLKCLR_CCUCDI_Pos             (4UL)                     /*!< SCU_CLK CLKCLR: CCUCDI (Bit 4)                              */
#define SCU_CLK_CLKCLR_CCUCDI_Msk             (0x10UL)                  /*!< SCU_CLK CLKCLR: CCUCDI (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CLKCLR_WDTCDI_Pos             (5UL)                     /*!< SCU_CLK CLKCLR: WDTCDI (Bit 5)                              */
#define SCU_CLK_CLKCLR_WDTCDI_Msk             (0x20UL)                  /*!< SCU_CLK CLKCLR: WDTCDI (Bitfield-Mask: 0x01)                */

/* ------------------------------  SCU_CLK_SYSCLKCR  ------------------------------ */
#define SCU_CLK_SYSCLKCR_SYSDIV_Pos           (0UL)                     /*!< SCU_CLK SYSCLKCR: SYSDIV (Bit 0)                            */
#define SCU_CLK_SYSCLKCR_SYSDIV_Msk           (0xffUL)                  /*!< SCU_CLK SYSCLKCR: SYSDIV (Bitfield-Mask: 0xff)              */
#define SCU_CLK_SYSCLKCR_SYSSEL_Pos           (16UL)                    /*!< SCU_CLK SYSCLKCR: SYSSEL (Bit 16)                           */
#define SCU_CLK_SYSCLKCR_SYSSEL_Msk           (0x10000UL)               /*!< SCU_CLK SYSCLKCR: SYSSEL (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_CLK_CPUCLKCR  ------------------------------ */
#define SCU_CLK_CPUCLKCR_CPUDIV_Pos           (0UL)                     /*!< SCU_CLK CPUCLKCR: CPUDIV (Bit 0)                            */
#define SCU_CLK_CPUCLKCR_CPUDIV_Msk           (0x1UL)                   /*!< SCU_CLK CPUCLKCR: CPUDIV (Bitfield-Mask: 0x01)              */

/* -------------------------------  SCU_CLK_PBCLKCR  ------------------------------ */
#define SCU_CLK_PBCLKCR_PBDIV_Pos             (0UL)                     /*!< SCU_CLK PBCLKCR: PBDIV (Bit 0)                              */
#define SCU_CLK_PBCLKCR_PBDIV_Msk             (0x1UL)                   /*!< SCU_CLK PBCLKCR: PBDIV (Bitfield-Mask: 0x01)                */

/* ------------------------------  SCU_CLK_USBCLKCR  ------------------------------ */
#define SCU_CLK_USBCLKCR_USBDIV_Pos           (0UL)                     /*!< SCU_CLK USBCLKCR: USBDIV (Bit 0)                            */
#define SCU_CLK_USBCLKCR_USBDIV_Msk           (0x7UL)                   /*!< SCU_CLK USBCLKCR: USBDIV (Bitfield-Mask: 0x07)              */
#define SCU_CLK_USBCLKCR_USBSEL_Pos           (16UL)                    /*!< SCU_CLK USBCLKCR: USBSEL (Bit 16)                           */
#define SCU_CLK_USBCLKCR_USBSEL_Msk           (0x10000UL)               /*!< SCU_CLK USBCLKCR: USBSEL (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_CLK_CCUCLKCR  ------------------------------ */
#define SCU_CLK_CCUCLKCR_CCUDIV_Pos           (0UL)                     /*!< SCU_CLK CCUCLKCR: CCUDIV (Bit 0)                            */
#define SCU_CLK_CCUCLKCR_CCUDIV_Msk           (0x1UL)                   /*!< SCU_CLK CCUCLKCR: CCUDIV (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_CLK_WDTCLKCR  ------------------------------ */
#define SCU_CLK_WDTCLKCR_WDTDIV_Pos           (0UL)                     /*!< SCU_CLK WDTCLKCR: WDTDIV (Bit 0)                            */
#define SCU_CLK_WDTCLKCR_WDTDIV_Msk           (0xffUL)                  /*!< SCU_CLK WDTCLKCR: WDTDIV (Bitfield-Mask: 0xff)              */
#define SCU_CLK_WDTCLKCR_WDTSEL_Pos           (16UL)                    /*!< SCU_CLK WDTCLKCR: WDTSEL (Bit 16)                           */
#define SCU_CLK_WDTCLKCR_WDTSEL_Msk           (0x30000UL)               /*!< SCU_CLK WDTCLKCR: WDTSEL (Bitfield-Mask: 0x03)              */

/* ------------------------------  SCU_CLK_EXTCLKCR  ------------------------------ */
#define SCU_CLK_EXTCLKCR_ECKSEL_Pos           (0UL)                     /*!< SCU_CLK EXTCLKCR: ECKSEL (Bit 0)                            */
#define SCU_CLK_EXTCLKCR_ECKSEL_Msk           (0x7UL)                   /*!< SCU_CLK EXTCLKCR: ECKSEL (Bitfield-Mask: 0x07)              */
#define SCU_CLK_EXTCLKCR_ECKDIV_Pos           (16UL)                    /*!< SCU_CLK EXTCLKCR: ECKDIV (Bit 16)                           */
#define SCU_CLK_EXTCLKCR_ECKDIV_Msk           (0x1ff0000UL)             /*!< SCU_CLK EXTCLKCR: ECKDIV (Bitfield-Mask: 0x1ff)             */

/* -----------------------------  SCU_CLK_MLINKCLKCR  ----------------------------- */
#define SCU_CLK_MLINKCLKCR_SYSDIV_Pos         (0UL)                     /*!< SCU_CLK MLINKCLKCR: SYSDIV (Bit 0)                          */
#define SCU_CLK_MLINKCLKCR_SYSDIV_Msk         (0xffUL)                  /*!< SCU_CLK MLINKCLKCR: SYSDIV (Bitfield-Mask: 0xff)            */
#define SCU_CLK_MLINKCLKCR_SYSSEL_Pos         (8UL)                     /*!< SCU_CLK MLINKCLKCR: SYSSEL (Bit 8)                          */
#define SCU_CLK_MLINKCLKCR_SYSSEL_Msk         (0x100UL)                 /*!< SCU_CLK MLINKCLKCR: SYSSEL (Bitfield-Mask: 0x01)            */
#define SCU_CLK_MLINKCLKCR_CPUDIV_Pos         (10UL)                    /*!< SCU_CLK MLINKCLKCR: CPUDIV (Bit 10)                         */
#define SCU_CLK_MLINKCLKCR_CPUDIV_Msk         (0x400UL)                 /*!< SCU_CLK MLINKCLKCR: CPUDIV (Bitfield-Mask: 0x01)            */
#define SCU_CLK_MLINKCLKCR_PBDIV_Pos          (12UL)                    /*!< SCU_CLK MLINKCLKCR: PBDIV (Bit 12)                          */
#define SCU_CLK_MLINKCLKCR_PBDIV_Msk          (0x1000UL)                /*!< SCU_CLK MLINKCLKCR: PBDIV (Bitfield-Mask: 0x01)             */
#define SCU_CLK_MLINKCLKCR_CCUDIV_Pos         (14UL)                    /*!< SCU_CLK MLINKCLKCR: CCUDIV (Bit 14)                         */
#define SCU_CLK_MLINKCLKCR_CCUDIV_Msk         (0x4000UL)                /*!< SCU_CLK MLINKCLKCR: CCUDIV (Bitfield-Mask: 0x01)            */
#define SCU_CLK_MLINKCLKCR_WDTDIV_Pos         (16UL)                    /*!< SCU_CLK MLINKCLKCR: WDTDIV (Bit 16)                         */
#define SCU_CLK_MLINKCLKCR_WDTDIV_Msk         (0xff0000UL)              /*!< SCU_CLK MLINKCLKCR: WDTDIV (Bitfield-Mask: 0xff)            */
#define SCU_CLK_MLINKCLKCR_WDTSEL_Pos         (24UL)                    /*!< SCU_CLK MLINKCLKCR: WDTSEL (Bit 24)                         */
#define SCU_CLK_MLINKCLKCR_WDTSEL_Msk         (0x3000000UL)             /*!< SCU_CLK MLINKCLKCR: WDTSEL (Bitfield-Mask: 0x03)            */

/* -------------------------------  SCU_CLK_SLEEPCR  ------------------------------ */
#define SCU_CLK_SLEEPCR_SYSSEL_Pos            (0UL)                     /*!< SCU_CLK SLEEPCR: SYSSEL (Bit 0)                             */
#define SCU_CLK_SLEEPCR_SYSSEL_Msk            (0x1UL)                   /*!< SCU_CLK SLEEPCR: SYSSEL (Bitfield-Mask: 0x01)               */
#define SCU_CLK_SLEEPCR_USBCR_Pos             (16UL)                    /*!< SCU_CLK SLEEPCR: USBCR (Bit 16)                             */
#define SCU_CLK_SLEEPCR_USBCR_Msk             (0x10000UL)               /*!< SCU_CLK SLEEPCR: USBCR (Bitfield-Mask: 0x01)                */
#define SCU_CLK_SLEEPCR_ETH0CR_Pos            (18UL)                    /*!< SCU_CLK SLEEPCR: ETH0CR (Bit 18)                            */
#define SCU_CLK_SLEEPCR_ETH0CR_Msk            (0x40000UL)               /*!< SCU_CLK SLEEPCR: ETH0CR (Bitfield-Mask: 0x01)               */
#define SCU_CLK_SLEEPCR_CCUCR_Pos             (20UL)                    /*!< SCU_CLK SLEEPCR: CCUCR (Bit 20)                             */
#define SCU_CLK_SLEEPCR_CCUCR_Msk             (0x100000UL)              /*!< SCU_CLK SLEEPCR: CCUCR (Bitfield-Mask: 0x01)                */
#define SCU_CLK_SLEEPCR_WDTCR_Pos             (21UL)                    /*!< SCU_CLK SLEEPCR: WDTCR (Bit 21)                             */
#define SCU_CLK_SLEEPCR_WDTCR_Msk             (0x200000UL)              /*!< SCU_CLK SLEEPCR: WDTCR (Bitfield-Mask: 0x01)                */

/* ------------------------------  SCU_CLK_DSLEEPCR  ------------------------------ */
#define SCU_CLK_DSLEEPCR_SYSSEL_Pos           (0UL)                     /*!< SCU_CLK DSLEEPCR: SYSSEL (Bit 0)                            */
#define SCU_CLK_DSLEEPCR_SYSSEL_Msk           (0x1UL)                   /*!< SCU_CLK DSLEEPCR: SYSSEL (Bitfield-Mask: 0x01)              */
#define SCU_CLK_DSLEEPCR_FPDN_Pos             (11UL)                    /*!< SCU_CLK DSLEEPCR: FPDN (Bit 11)                             */
#define SCU_CLK_DSLEEPCR_FPDN_Msk             (0x800UL)                 /*!< SCU_CLK DSLEEPCR: FPDN (Bitfield-Mask: 0x01)                */
#define SCU_CLK_DSLEEPCR_PLLPDN_Pos           (12UL)                    /*!< SCU_CLK DSLEEPCR: PLLPDN (Bit 12)                           */
#define SCU_CLK_DSLEEPCR_PLLPDN_Msk           (0x1000UL)                /*!< SCU_CLK DSLEEPCR: PLLPDN (Bitfield-Mask: 0x01)              */
#define SCU_CLK_DSLEEPCR_VCOPDN_Pos           (13UL)                    /*!< SCU_CLK DSLEEPCR: VCOPDN (Bit 13)                           */
#define SCU_CLK_DSLEEPCR_VCOPDN_Msk           (0x2000UL)                /*!< SCU_CLK DSLEEPCR: VCOPDN (Bitfield-Mask: 0x01)              */
#define SCU_CLK_DSLEEPCR_USBCR_Pos            (16UL)                    /*!< SCU_CLK DSLEEPCR: USBCR (Bit 16)                            */
#define SCU_CLK_DSLEEPCR_USBCR_Msk            (0x10000UL)               /*!< SCU_CLK DSLEEPCR: USBCR (Bitfield-Mask: 0x01)               */
#define SCU_CLK_DSLEEPCR_ETH0CR_Pos           (18UL)                    /*!< SCU_CLK DSLEEPCR: ETH0CR (Bit 18)                           */
#define SCU_CLK_DSLEEPCR_ETH0CR_Msk           (0x40000UL)               /*!< SCU_CLK DSLEEPCR: ETH0CR (Bitfield-Mask: 0x01)              */
#define SCU_CLK_DSLEEPCR_CCUCR_Pos            (20UL)                    /*!< SCU_CLK DSLEEPCR: CCUCR (Bit 20)                            */
#define SCU_CLK_DSLEEPCR_CCUCR_Msk            (0x100000UL)              /*!< SCU_CLK DSLEEPCR: CCUCR (Bitfield-Mask: 0x01)               */
#define SCU_CLK_DSLEEPCR_WDTCR_Pos            (21UL)                    /*!< SCU_CLK DSLEEPCR: WDTCR (Bit 21)                            */
#define SCU_CLK_DSLEEPCR_WDTCR_Msk            (0x200000UL)              /*!< SCU_CLK DSLEEPCR: WDTCR (Bitfield-Mask: 0x01)               */

/* ------------------------------  SCU_CLK_CGATSTAT0  ----------------------------- */
#define SCU_CLK_CGATSTAT0_VADC_Pos            (0UL)                     /*!< SCU_CLK CGATSTAT0: VADC (Bit 0)                             */
#define SCU_CLK_CGATSTAT0_VADC_Msk            (0x1UL)                   /*!< SCU_CLK CGATSTAT0: VADC (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSTAT0_DSD_Pos             (1UL)                     /*!< SCU_CLK CGATSTAT0: DSD (Bit 1)                              */
#define SCU_CLK_CGATSTAT0_DSD_Msk             (0x2UL)                   /*!< SCU_CLK CGATSTAT0: DSD (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSTAT0_CCU40_Pos           (2UL)                     /*!< SCU_CLK CGATSTAT0: CCU40 (Bit 2)                            */
#define SCU_CLK_CGATSTAT0_CCU40_Msk           (0x4UL)                   /*!< SCU_CLK CGATSTAT0: CCU40 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT0_CCU41_Pos           (3UL)                     /*!< SCU_CLK CGATSTAT0: CCU41 (Bit 3)                            */
#define SCU_CLK_CGATSTAT0_CCU41_Msk           (0x8UL)                   /*!< SCU_CLK CGATSTAT0: CCU41 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT0_CCU42_Pos           (4UL)                     /*!< SCU_CLK CGATSTAT0: CCU42 (Bit 4)                            */
#define SCU_CLK_CGATSTAT0_CCU42_Msk           (0x10UL)                  /*!< SCU_CLK CGATSTAT0: CCU42 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT0_CCU80_Pos           (7UL)                     /*!< SCU_CLK CGATSTAT0: CCU80 (Bit 7)                            */
#define SCU_CLK_CGATSTAT0_CCU80_Msk           (0x80UL)                  /*!< SCU_CLK CGATSTAT0: CCU80 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT0_CCU81_Pos           (8UL)                     /*!< SCU_CLK CGATSTAT0: CCU81 (Bit 8)                            */
#define SCU_CLK_CGATSTAT0_CCU81_Msk           (0x100UL)                 /*!< SCU_CLK CGATSTAT0: CCU81 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT0_POSIF0_Pos          (9UL)                     /*!< SCU_CLK CGATSTAT0: POSIF0 (Bit 9)                           */
#define SCU_CLK_CGATSTAT0_POSIF0_Msk          (0x200UL)                 /*!< SCU_CLK CGATSTAT0: POSIF0 (Bitfield-Mask: 0x01)             */
#define SCU_CLK_CGATSTAT0_POSIF1_Pos          (10UL)                    /*!< SCU_CLK CGATSTAT0: POSIF1 (Bit 10)                          */
#define SCU_CLK_CGATSTAT0_POSIF1_Msk          (0x400UL)                 /*!< SCU_CLK CGATSTAT0: POSIF1 (Bitfield-Mask: 0x01)             */
#define SCU_CLK_CGATSTAT0_USIC0_Pos           (11UL)                    /*!< SCU_CLK CGATSTAT0: USIC0 (Bit 11)                           */
#define SCU_CLK_CGATSTAT0_USIC0_Msk           (0x800UL)                 /*!< SCU_CLK CGATSTAT0: USIC0 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT0_ERU1_Pos            (16UL)                    /*!< SCU_CLK CGATSTAT0: ERU1 (Bit 16)                            */
#define SCU_CLK_CGATSTAT0_ERU1_Msk            (0x10000UL)               /*!< SCU_CLK CGATSTAT0: ERU1 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSTAT0_HRPWM0_Pos          (23UL)                    /*!< SCU_CLK CGATSTAT0: HRPWM0 (Bit 23)                          */
#define SCU_CLK_CGATSTAT0_HRPWM0_Msk          (0x800000UL)              /*!< SCU_CLK CGATSTAT0: HRPWM0 (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_CLK_CGATSET0  ------------------------------ */
#define SCU_CLK_CGATSET0_VADC_Pos             (0UL)                     /*!< SCU_CLK CGATSET0: VADC (Bit 0)                              */
#define SCU_CLK_CGATSET0_VADC_Msk             (0x1UL)                   /*!< SCU_CLK CGATSET0: VADC (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSET0_DSD_Pos              (1UL)                     /*!< SCU_CLK CGATSET0: DSD (Bit 1)                               */
#define SCU_CLK_CGATSET0_DSD_Msk              (0x2UL)                   /*!< SCU_CLK CGATSET0: DSD (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATSET0_CCU40_Pos            (2UL)                     /*!< SCU_CLK CGATSET0: CCU40 (Bit 2)                             */
#define SCU_CLK_CGATSET0_CCU40_Msk            (0x4UL)                   /*!< SCU_CLK CGATSET0: CCU40 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET0_CCU41_Pos            (3UL)                     /*!< SCU_CLK CGATSET0: CCU41 (Bit 3)                             */
#define SCU_CLK_CGATSET0_CCU41_Msk            (0x8UL)                   /*!< SCU_CLK CGATSET0: CCU41 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET0_CCU42_Pos            (4UL)                     /*!< SCU_CLK CGATSET0: CCU42 (Bit 4)                             */
#define SCU_CLK_CGATSET0_CCU42_Msk            (0x10UL)                  /*!< SCU_CLK CGATSET0: CCU42 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET0_CCU80_Pos            (7UL)                     /*!< SCU_CLK CGATSET0: CCU80 (Bit 7)                             */
#define SCU_CLK_CGATSET0_CCU80_Msk            (0x80UL)                  /*!< SCU_CLK CGATSET0: CCU80 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET0_CCU81_Pos            (8UL)                     /*!< SCU_CLK CGATSET0: CCU81 (Bit 8)                             */
#define SCU_CLK_CGATSET0_CCU81_Msk            (0x100UL)                 /*!< SCU_CLK CGATSET0: CCU81 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET0_POSIF0_Pos           (9UL)                     /*!< SCU_CLK CGATSET0: POSIF0 (Bit 9)                            */
#define SCU_CLK_CGATSET0_POSIF0_Msk           (0x200UL)                 /*!< SCU_CLK CGATSET0: POSIF0 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSET0_POSIF1_Pos           (10UL)                    /*!< SCU_CLK CGATSET0: POSIF1 (Bit 10)                           */
#define SCU_CLK_CGATSET0_POSIF1_Msk           (0x400UL)                 /*!< SCU_CLK CGATSET0: POSIF1 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSET0_USIC0_Pos            (11UL)                    /*!< SCU_CLK CGATSET0: USIC0 (Bit 11)                            */
#define SCU_CLK_CGATSET0_USIC0_Msk            (0x800UL)                 /*!< SCU_CLK CGATSET0: USIC0 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET0_ERU1_Pos             (16UL)                    /*!< SCU_CLK CGATSET0: ERU1 (Bit 16)                             */
#define SCU_CLK_CGATSET0_ERU1_Msk             (0x10000UL)               /*!< SCU_CLK CGATSET0: ERU1 (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSET0_HRPWM0_Pos           (23UL)                    /*!< SCU_CLK CGATSET0: HRPWM0 (Bit 23)                           */
#define SCU_CLK_CGATSET0_HRPWM0_Msk           (0x800000UL)              /*!< SCU_CLK CGATSET0: HRPWM0 (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_CLK_CGATCLR0  ------------------------------ */
#define SCU_CLK_CGATCLR0_VADC_Pos             (0UL)                     /*!< SCU_CLK CGATCLR0: VADC (Bit 0)                              */
#define SCU_CLK_CGATCLR0_VADC_Msk             (0x1UL)                   /*!< SCU_CLK CGATCLR0: VADC (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATCLR0_DSD_Pos              (1UL)                     /*!< SCU_CLK CGATCLR0: DSD (Bit 1)                               */
#define SCU_CLK_CGATCLR0_DSD_Msk              (0x2UL)                   /*!< SCU_CLK CGATCLR0: DSD (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATCLR0_CCU40_Pos            (2UL)                     /*!< SCU_CLK CGATCLR0: CCU40 (Bit 2)                             */
#define SCU_CLK_CGATCLR0_CCU40_Msk            (0x4UL)                   /*!< SCU_CLK CGATCLR0: CCU40 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR0_CCU41_Pos            (3UL)                     /*!< SCU_CLK CGATCLR0: CCU41 (Bit 3)                             */
#define SCU_CLK_CGATCLR0_CCU41_Msk            (0x8UL)                   /*!< SCU_CLK CGATCLR0: CCU41 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR0_CCU42_Pos            (4UL)                     /*!< SCU_CLK CGATCLR0: CCU42 (Bit 4)                             */
#define SCU_CLK_CGATCLR0_CCU42_Msk            (0x10UL)                  /*!< SCU_CLK CGATCLR0: CCU42 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR0_CCU80_Pos            (7UL)                     /*!< SCU_CLK CGATCLR0: CCU80 (Bit 7)                             */
#define SCU_CLK_CGATCLR0_CCU80_Msk            (0x80UL)                  /*!< SCU_CLK CGATCLR0: CCU80 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR0_CCU81_Pos            (8UL)                     /*!< SCU_CLK CGATCLR0: CCU81 (Bit 8)                             */
#define SCU_CLK_CGATCLR0_CCU81_Msk            (0x100UL)                 /*!< SCU_CLK CGATCLR0: CCU81 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR0_POSIF0_Pos           (9UL)                     /*!< SCU_CLK CGATCLR0: POSIF0 (Bit 9)                            */
#define SCU_CLK_CGATCLR0_POSIF0_Msk           (0x200UL)                 /*!< SCU_CLK CGATCLR0: POSIF0 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATCLR0_POSIF1_Pos           (10UL)                    /*!< SCU_CLK CGATCLR0: POSIF1 (Bit 10)                           */
#define SCU_CLK_CGATCLR0_POSIF1_Msk           (0x400UL)                 /*!< SCU_CLK CGATCLR0: POSIF1 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATCLR0_USIC0_Pos            (11UL)                    /*!< SCU_CLK CGATCLR0: USIC0 (Bit 11)                            */
#define SCU_CLK_CGATCLR0_USIC0_Msk            (0x800UL)                 /*!< SCU_CLK CGATCLR0: USIC0 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR0_ERU1_Pos             (16UL)                    /*!< SCU_CLK CGATCLR0: ERU1 (Bit 16)                             */
#define SCU_CLK_CGATCLR0_ERU1_Msk             (0x10000UL)               /*!< SCU_CLK CGATCLR0: ERU1 (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATCLR0_HRPWM0_Pos           (23UL)                    /*!< SCU_CLK CGATCLR0: HRPWM0 (Bit 23)                           */
#define SCU_CLK_CGATCLR0_HRPWM0_Msk           (0x800000UL)              /*!< SCU_CLK CGATCLR0: HRPWM0 (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_CLK_CGATSTAT1  ----------------------------- */
#define SCU_CLK_CGATSTAT1_CCU43_Pos           (0UL)                     /*!< SCU_CLK CGATSTAT1: CCU43 (Bit 0)                            */
#define SCU_CLK_CGATSTAT1_CCU43_Msk           (0x1UL)                   /*!< SCU_CLK CGATSTAT1: CCU43 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT1_LEDTSCU0_Pos        (3UL)                     /*!< SCU_CLK CGATSTAT1: LEDTSCU0 (Bit 3)                         */
#define SCU_CLK_CGATSTAT1_LEDTSCU0_Msk        (0x8UL)                   /*!< SCU_CLK CGATSTAT1: LEDTSCU0 (Bitfield-Mask: 0x01)           */
#define SCU_CLK_CGATSTAT1_MCAN0_Pos           (4UL)                     /*!< SCU_CLK CGATSTAT1: MCAN0 (Bit 4)                            */
#define SCU_CLK_CGATSTAT1_MCAN0_Msk           (0x10UL)                  /*!< SCU_CLK CGATSTAT1: MCAN0 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT1_DAC_Pos             (5UL)                     /*!< SCU_CLK CGATSTAT1: DAC (Bit 5)                              */
#define SCU_CLK_CGATSTAT1_DAC_Msk             (0x20UL)                  /*!< SCU_CLK CGATSTAT1: DAC (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSTAT1_USIC1_Pos           (7UL)                     /*!< SCU_CLK CGATSTAT1: USIC1 (Bit 7)                            */
#define SCU_CLK_CGATSTAT1_USIC1_Msk           (0x80UL)                  /*!< SCU_CLK CGATSTAT1: USIC1 (Bitfield-Mask: 0x01)              */
#define SCU_CLK_CGATSTAT1_PPORTS_Pos          (9UL)                     /*!< SCU_CLK CGATSTAT1: PPORTS (Bit 9)                           */
#define SCU_CLK_CGATSTAT1_PPORTS_Msk          (0x200UL)                 /*!< SCU_CLK CGATSTAT1: PPORTS (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_CLK_CGATSET1  ------------------------------ */
#define SCU_CLK_CGATSET1_CCU43_Pos            (0UL)                     /*!< SCU_CLK CGATSET1: CCU43 (Bit 0)                             */
#define SCU_CLK_CGATSET1_CCU43_Msk            (0x1UL)                   /*!< SCU_CLK CGATSET1: CCU43 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET1_LEDTSCU0_Pos         (3UL)                     /*!< SCU_CLK CGATSET1: LEDTSCU0 (Bit 3)                          */
#define SCU_CLK_CGATSET1_LEDTSCU0_Msk         (0x8UL)                   /*!< SCU_CLK CGATSET1: LEDTSCU0 (Bitfield-Mask: 0x01)            */
#define SCU_CLK_CGATSET1_MCAN0_Pos            (4UL)                     /*!< SCU_CLK CGATSET1: MCAN0 (Bit 4)                             */
#define SCU_CLK_CGATSET1_MCAN0_Msk            (0x10UL)                  /*!< SCU_CLK CGATSET1: MCAN0 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET1_DAC_Pos              (5UL)                     /*!< SCU_CLK CGATSET1: DAC (Bit 5)                               */
#define SCU_CLK_CGATSET1_DAC_Msk              (0x20UL)                  /*!< SCU_CLK CGATSET1: DAC (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATSET1_USIC1_Pos            (7UL)                     /*!< SCU_CLK CGATSET1: USIC1 (Bit 7)                             */
#define SCU_CLK_CGATSET1_USIC1_Msk            (0x80UL)                  /*!< SCU_CLK CGATSET1: USIC1 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSET1_PPORTS_Pos           (9UL)                     /*!< SCU_CLK CGATSET1: PPORTS (Bit 9)                            */
#define SCU_CLK_CGATSET1_PPORTS_Msk           (0x200UL)                 /*!< SCU_CLK CGATSET1: PPORTS (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_CLK_CGATCLR1  ------------------------------ */
#define SCU_CLK_CGATCLR1_CCU43_Pos            (0UL)                     /*!< SCU_CLK CGATCLR1: CCU43 (Bit 0)                             */
#define SCU_CLK_CGATCLR1_CCU43_Msk            (0x1UL)                   /*!< SCU_CLK CGATCLR1: CCU43 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR1_LEDTSCU0_Pos         (3UL)                     /*!< SCU_CLK CGATCLR1: LEDTSCU0 (Bit 3)                          */
#define SCU_CLK_CGATCLR1_LEDTSCU0_Msk         (0x8UL)                   /*!< SCU_CLK CGATCLR1: LEDTSCU0 (Bitfield-Mask: 0x01)            */
#define SCU_CLK_CGATCLR1_MCAN0_Pos            (4UL)                     /*!< SCU_CLK CGATCLR1: MCAN0 (Bit 4)                             */
#define SCU_CLK_CGATCLR1_MCAN0_Msk            (0x10UL)                  /*!< SCU_CLK CGATCLR1: MCAN0 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR1_DAC_Pos              (5UL)                     /*!< SCU_CLK CGATCLR1: DAC (Bit 5)                               */
#define SCU_CLK_CGATCLR1_DAC_Msk              (0x20UL)                  /*!< SCU_CLK CGATCLR1: DAC (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATCLR1_USIC1_Pos            (7UL)                     /*!< SCU_CLK CGATCLR1: USIC1 (Bit 7)                             */
#define SCU_CLK_CGATCLR1_USIC1_Msk            (0x80UL)                  /*!< SCU_CLK CGATCLR1: USIC1 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATCLR1_PPORTS_Pos           (9UL)                     /*!< SCU_CLK CGATCLR1: PPORTS (Bit 9)                            */
#define SCU_CLK_CGATCLR1_PPORTS_Msk           (0x200UL)                 /*!< SCU_CLK CGATCLR1: PPORTS (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_CLK_CGATSTAT2  ----------------------------- */
#define SCU_CLK_CGATSTAT2_WDT_Pos             (1UL)                     /*!< SCU_CLK CGATSTAT2: WDT (Bit 1)                              */
#define SCU_CLK_CGATSTAT2_WDT_Msk             (0x2UL)                   /*!< SCU_CLK CGATSTAT2: WDT (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSTAT2_ETH0_Pos            (2UL)                     /*!< SCU_CLK CGATSTAT2: ETH0 (Bit 2)                             */
#define SCU_CLK_CGATSTAT2_ETH0_Msk            (0x4UL)                   /*!< SCU_CLK CGATSTAT2: ETH0 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSTAT2_DMA0_Pos            (4UL)                     /*!< SCU_CLK CGATSTAT2: DMA0 (Bit 4)                             */
#define SCU_CLK_CGATSTAT2_DMA0_Msk            (0x10UL)                  /*!< SCU_CLK CGATSTAT2: DMA0 (Bitfield-Mask: 0x01)               */
#define SCU_CLK_CGATSTAT2_FCE_Pos             (6UL)                     /*!< SCU_CLK CGATSTAT2: FCE (Bit 6)                              */
#define SCU_CLK_CGATSTAT2_FCE_Msk             (0x40UL)                  /*!< SCU_CLK CGATSTAT2: FCE (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSTAT2_USB_Pos             (7UL)                     /*!< SCU_CLK CGATSTAT2: USB (Bit 7)                              */
#define SCU_CLK_CGATSTAT2_USB_Msk             (0x80UL)                  /*!< SCU_CLK CGATSTAT2: USB (Bitfield-Mask: 0x01)                */

/* ------------------------------  SCU_CLK_CGATSET2  ------------------------------ */
#define SCU_CLK_CGATSET2_WDT_Pos              (1UL)                     /*!< SCU_CLK CGATSET2: WDT (Bit 1)                               */
#define SCU_CLK_CGATSET2_WDT_Msk              (0x2UL)                   /*!< SCU_CLK CGATSET2: WDT (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATSET2_ETH0_Pos             (2UL)                     /*!< SCU_CLK CGATSET2: ETH0 (Bit 2)                              */
#define SCU_CLK_CGATSET2_ETH0_Msk             (0x4UL)                   /*!< SCU_CLK CGATSET2: ETH0 (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSET2_DMA0_Pos             (4UL)                     /*!< SCU_CLK CGATSET2: DMA0 (Bit 4)                              */
#define SCU_CLK_CGATSET2_DMA0_Msk             (0x10UL)                  /*!< SCU_CLK CGATSET2: DMA0 (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATSET2_FCE_Pos              (6UL)                     /*!< SCU_CLK CGATSET2: FCE (Bit 6)                               */
#define SCU_CLK_CGATSET2_FCE_Msk              (0x40UL)                  /*!< SCU_CLK CGATSET2: FCE (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATSET2_USB_Pos              (7UL)                     /*!< SCU_CLK CGATSET2: USB (Bit 7)                               */
#define SCU_CLK_CGATSET2_USB_Msk              (0x80UL)                  /*!< SCU_CLK CGATSET2: USB (Bitfield-Mask: 0x01)                 */

/* ------------------------------  SCU_CLK_CGATCLR2  ------------------------------ */
#define SCU_CLK_CGATCLR2_WDT_Pos              (1UL)                     /*!< SCU_CLK CGATCLR2: WDT (Bit 1)                               */
#define SCU_CLK_CGATCLR2_WDT_Msk              (0x2UL)                   /*!< SCU_CLK CGATCLR2: WDT (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATCLR2_ETH0_Pos             (2UL)                     /*!< SCU_CLK CGATCLR2: ETH0 (Bit 2)                              */
#define SCU_CLK_CGATCLR2_ETH0_Msk             (0x4UL)                   /*!< SCU_CLK CGATCLR2: ETH0 (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATCLR2_DMA0_Pos             (4UL)                     /*!< SCU_CLK CGATCLR2: DMA0 (Bit 4)                              */
#define SCU_CLK_CGATCLR2_DMA0_Msk             (0x10UL)                  /*!< SCU_CLK CGATCLR2: DMA0 (Bitfield-Mask: 0x01)                */
#define SCU_CLK_CGATCLR2_FCE_Pos              (6UL)                     /*!< SCU_CLK CGATCLR2: FCE (Bit 6)                               */
#define SCU_CLK_CGATCLR2_FCE_Msk              (0x40UL)                  /*!< SCU_CLK CGATCLR2: FCE (Bitfield-Mask: 0x01)                 */
#define SCU_CLK_CGATCLR2_USB_Pos              (7UL)                     /*!< SCU_CLK CGATCLR2: USB (Bit 7)                               */
#define SCU_CLK_CGATCLR2_USB_Msk              (0x80UL)                  /*!< SCU_CLK CGATCLR2: USB (Bitfield-Mask: 0x01)                 */


/* ================================================================================ */
/* ================        struct 'SCU_OSC' Position & Mask        ================ */
/* ================================================================================ */


/* ------------------------------  SCU_OSC_OSCHPSTAT  ----------------------------- */
#define SCU_OSC_OSCHPSTAT_X1D_Pos             (0UL)                     /*!< SCU_OSC OSCHPSTAT: X1D (Bit 0)                              */
#define SCU_OSC_OSCHPSTAT_X1D_Msk             (0x1UL)                   /*!< SCU_OSC OSCHPSTAT: X1D (Bitfield-Mask: 0x01)                */

/* ------------------------------  SCU_OSC_OSCHPCTRL  ----------------------------- */
#define SCU_OSC_OSCHPCTRL_X1DEN_Pos           (0UL)                     /*!< SCU_OSC OSCHPCTRL: X1DEN (Bit 0)                            */
#define SCU_OSC_OSCHPCTRL_X1DEN_Msk           (0x1UL)                   /*!< SCU_OSC OSCHPCTRL: X1DEN (Bitfield-Mask: 0x01)              */
#define SCU_OSC_OSCHPCTRL_SHBY_Pos            (1UL)                     /*!< SCU_OSC OSCHPCTRL: SHBY (Bit 1)                             */
#define SCU_OSC_OSCHPCTRL_SHBY_Msk            (0x2UL)                   /*!< SCU_OSC OSCHPCTRL: SHBY (Bitfield-Mask: 0x01)               */
#define SCU_OSC_OSCHPCTRL_MODE_Pos            (4UL)                     /*!< SCU_OSC OSCHPCTRL: MODE (Bit 4)                             */
#define SCU_OSC_OSCHPCTRL_MODE_Msk            (0x30UL)                  /*!< SCU_OSC OSCHPCTRL: MODE (Bitfield-Mask: 0x03)               */
#define SCU_OSC_OSCHPCTRL_OSCVAL_Pos          (16UL)                    /*!< SCU_OSC OSCHPCTRL: OSCVAL (Bit 16)                          */
#define SCU_OSC_OSCHPCTRL_OSCVAL_Msk          (0xf0000UL)               /*!< SCU_OSC OSCHPCTRL: OSCVAL (Bitfield-Mask: 0x0f)             */

/* -----------------------------  SCU_OSC_CLKCALCONST  ---------------------------- */
#define SCU_OSC_CLKCALCONST_CALIBCONST_Pos    (0UL)                     /*!< SCU_OSC CLKCALCONST: CALIBCONST (Bit 0)                     */
#define SCU_OSC_CLKCALCONST_CALIBCONST_Msk    (0xfUL)                   /*!< SCU_OSC CLKCALCONST: CALIBCONST (Bitfield-Mask: 0x0f)       */


/* ================================================================================ */
/* ================        struct 'SCU_PLL' Position & Mask        ================ */
/* ================================================================================ */


/* -------------------------------  SCU_PLL_PLLSTAT  ------------------------------ */
#define SCU_PLL_PLLSTAT_VCOBYST_Pos           (0UL)                     /*!< SCU_PLL PLLSTAT: VCOBYST (Bit 0)                            */
#define SCU_PLL_PLLSTAT_VCOBYST_Msk           (0x1UL)                   /*!< SCU_PLL PLLSTAT: VCOBYST (Bitfield-Mask: 0x01)              */
#define SCU_PLL_PLLSTAT_PWDSTAT_Pos           (1UL)                     /*!< SCU_PLL PLLSTAT: PWDSTAT (Bit 1)                            */
#define SCU_PLL_PLLSTAT_PWDSTAT_Msk           (0x2UL)                   /*!< SCU_PLL PLLSTAT: PWDSTAT (Bitfield-Mask: 0x01)              */
#define SCU_PLL_PLLSTAT_VCOLOCK_Pos           (2UL)                     /*!< SCU_PLL PLLSTAT: VCOLOCK (Bit 2)                            */
#define SCU_PLL_PLLSTAT_VCOLOCK_Msk           (0x4UL)                   /*!< SCU_PLL PLLSTAT: VCOLOCK (Bitfield-Mask: 0x01)              */
#define SCU_PLL_PLLSTAT_K1RDY_Pos             (4UL)                     /*!< SCU_PLL PLLSTAT: K1RDY (Bit 4)                              */
#define SCU_PLL_PLLSTAT_K1RDY_Msk             (0x10UL)                  /*!< SCU_PLL PLLSTAT: K1RDY (Bitfield-Mask: 0x01)                */
#define SCU_PLL_PLLSTAT_K2RDY_Pos             (5UL)                     /*!< SCU_PLL PLLSTAT: K2RDY (Bit 5)                              */
#define SCU_PLL_PLLSTAT_K2RDY_Msk             (0x20UL)                  /*!< SCU_PLL PLLSTAT: K2RDY (Bitfield-Mask: 0x01)                */
#define SCU_PLL_PLLSTAT_BY_Pos                (6UL)                     /*!< SCU_PLL PLLSTAT: BY (Bit 6)                                 */
#define SCU_PLL_PLLSTAT_BY_Msk                (0x40UL)                  /*!< SCU_PLL PLLSTAT: BY (Bitfield-Mask: 0x01)                   */
#define SCU_PLL_PLLSTAT_PLLLV_Pos             (7UL)                     /*!< SCU_PLL PLLSTAT: PLLLV (Bit 7)                              */
#define SCU_PLL_PLLSTAT_PLLLV_Msk             (0x80UL)                  /*!< SCU_PLL PLLSTAT: PLLLV (Bitfield-Mask: 0x01)                */
#define SCU_PLL_PLLSTAT_PLLHV_Pos             (8UL)                     /*!< SCU_PLL PLLSTAT: PLLHV (Bit 8)                              */
#define SCU_PLL_PLLSTAT_PLLHV_Msk             (0x100UL)                 /*!< SCU_PLL PLLSTAT: PLLHV (Bitfield-Mask: 0x01)                */
#define SCU_PLL_PLLSTAT_PLLSP_Pos             (9UL)                     /*!< SCU_PLL PLLSTAT: PLLSP (Bit 9)                              */
#define SCU_PLL_PLLSTAT_PLLSP_Msk             (0x200UL)                 /*!< SCU_PLL PLLSTAT: PLLSP (Bitfield-Mask: 0x01)                */

/* -------------------------------  SCU_PLL_PLLCON0  ------------------------------ */
#define SCU_PLL_PLLCON0_VCOBYP_Pos            (0UL)                     /*!< SCU_PLL PLLCON0: VCOBYP (Bit 0)                             */
#define SCU_PLL_PLLCON0_VCOBYP_Msk            (0x1UL)                   /*!< SCU_PLL PLLCON0: VCOBYP (Bitfield-Mask: 0x01)               */
#define SCU_PLL_PLLCON0_VCOPWD_Pos            (1UL)                     /*!< SCU_PLL PLLCON0: VCOPWD (Bit 1)                             */
#define SCU_PLL_PLLCON0_VCOPWD_Msk            (0x2UL)                   /*!< SCU_PLL PLLCON0: VCOPWD (Bitfield-Mask: 0x01)               */
#define SCU_PLL_PLLCON0_VCOTR_Pos             (2UL)                     /*!< SCU_PLL PLLCON0: VCOTR (Bit 2)                              */
#define SCU_PLL_PLLCON0_VCOTR_Msk             (0x4UL)                   /*!< SCU_PLL PLLCON0: VCOTR (Bitfield-Mask: 0x01)                */
#define SCU_PLL_PLLCON0_FINDIS_Pos            (4UL)                     /*!< SCU_PLL PLLCON0: FINDIS (Bit 4)                             */
#define SCU_PLL_PLLCON0_FINDIS_Msk            (0x10UL)                  /*!< SCU_PLL PLLCON0: FINDIS (Bitfield-Mask: 0x01)               */
#define SCU_PLL_PLLCON0_OSCDISCDIS_Pos        (6UL)                     /*!< SCU_PLL PLLCON0: OSCDISCDIS (Bit 6)                         */
#define SCU_PLL_PLLCON0_OSCDISCDIS_Msk        (0x40UL)                  /*!< SCU_PLL PLLCON0: OSCDISCDIS (Bitfield-Mask: 0x01)           */
#define SCU_PLL_PLLCON0_PLLPWD_Pos            (16UL)                    /*!< SCU_PLL PLLCON0: PLLPWD (Bit 16)                            */
#define SCU_PLL_PLLCON0_PLLPWD_Msk            (0x10000UL)               /*!< SCU_PLL PLLCON0: PLLPWD (Bitfield-Mask: 0x01)               */
#define SCU_PLL_PLLCON0_OSCRES_Pos            (17UL)                    /*!< SCU_PLL PLLCON0: OSCRES (Bit 17)                            */
#define SCU_PLL_PLLCON0_OSCRES_Msk            (0x20000UL)               /*!< SCU_PLL PLLCON0: OSCRES (Bitfield-Mask: 0x01)               */
#define SCU_PLL_PLLCON0_RESLD_Pos             (18UL)                    /*!< SCU_PLL PLLCON0: RESLD (Bit 18)                             */
#define SCU_PLL_PLLCON0_RESLD_Msk             (0x40000UL)               /*!< SCU_PLL PLLCON0: RESLD (Bitfield-Mask: 0x01)                */
#define SCU_PLL_PLLCON0_AOTREN_Pos            (19UL)                    /*!< SCU_PLL PLLCON0: AOTREN (Bit 19)                            */
#define SCU_PLL_PLLCON0_AOTREN_Msk            (0x80000UL)               /*!< SCU_PLL PLLCON0: AOTREN (Bitfield-Mask: 0x01)               */
#define SCU_PLL_PLLCON0_FOTR_Pos              (20UL)                    /*!< SCU_PLL PLLCON0: FOTR (Bit 20)                              */
#define SCU_PLL_PLLCON0_FOTR_Msk              (0x100000UL)              /*!< SCU_PLL PLLCON0: FOTR (Bitfield-Mask: 0x01)                 */

/* -------------------------------  SCU_PLL_PLLCON1  ------------------------------ */
#define SCU_PLL_PLLCON1_K1DIV_Pos             (0UL)                     /*!< SCU_PLL PLLCON1: K1DIV (Bit 0)                              */
#define SCU_PLL_PLLCON1_K1DIV_Msk             (0x7fUL)                  /*!< SCU_PLL PLLCON1: K1DIV (Bitfield-Mask: 0x7f)                */
#define SCU_PLL_PLLCON1_NDIV_Pos              (8UL)                     /*!< SCU_PLL PLLCON1: NDIV (Bit 8)                               */
#define SCU_PLL_PLLCON1_NDIV_Msk              (0x7f00UL)                /*!< SCU_PLL PLLCON1: NDIV (Bitfield-Mask: 0x7f)                 */
#define SCU_PLL_PLLCON1_K2DIV_Pos             (16UL)                    /*!< SCU_PLL PLLCON1: K2DIV (Bit 16)                             */
#define SCU_PLL_PLLCON1_K2DIV_Msk             (0x7f0000UL)              /*!< SCU_PLL PLLCON1: K2DIV (Bitfield-Mask: 0x7f)                */
#define SCU_PLL_PLLCON1_PDIV_Pos              (24UL)                    /*!< SCU_PLL PLLCON1: PDIV (Bit 24)                              */
#define SCU_PLL_PLLCON1_PDIV_Msk              (0xf000000UL)             /*!< SCU_PLL PLLCON1: PDIV (Bitfield-Mask: 0x0f)                 */

/* -------------------------------  SCU_PLL_PLLCON2  ------------------------------ */
#define SCU_PLL_PLLCON2_PINSEL_Pos            (0UL)                     /*!< SCU_PLL PLLCON2: PINSEL (Bit 0)                             */
#define SCU_PLL_PLLCON2_PINSEL_Msk            (0x1UL)                   /*!< SCU_PLL PLLCON2: PINSEL (Bitfield-Mask: 0x01)               */
#define SCU_PLL_PLLCON2_K1INSEL_Pos           (8UL)                     /*!< SCU_PLL PLLCON2: K1INSEL (Bit 8)                            */
#define SCU_PLL_PLLCON2_K1INSEL_Msk           (0x100UL)                 /*!< SCU_PLL PLLCON2: K1INSEL (Bitfield-Mask: 0x01)              */

/* -----------------------------  SCU_PLL_USBPLLSTAT  ----------------------------- */
#define SCU_PLL_USBPLLSTAT_VCOBYST_Pos        (0UL)                     /*!< SCU_PLL USBPLLSTAT: VCOBYST (Bit 0)                         */
#define SCU_PLL_USBPLLSTAT_VCOBYST_Msk        (0x1UL)                   /*!< SCU_PLL USBPLLSTAT: VCOBYST (Bitfield-Mask: 0x01)           */
#define SCU_PLL_USBPLLSTAT_PWDSTAT_Pos        (1UL)                     /*!< SCU_PLL USBPLLSTAT: PWDSTAT (Bit 1)                         */
#define SCU_PLL_USBPLLSTAT_PWDSTAT_Msk        (0x2UL)                   /*!< SCU_PLL USBPLLSTAT: PWDSTAT (Bitfield-Mask: 0x01)           */
#define SCU_PLL_USBPLLSTAT_VCOLOCK_Pos        (2UL)                     /*!< SCU_PLL USBPLLSTAT: VCOLOCK (Bit 2)                         */
#define SCU_PLL_USBPLLSTAT_VCOLOCK_Msk        (0x4UL)                   /*!< SCU_PLL USBPLLSTAT: VCOLOCK (Bitfield-Mask: 0x01)           */
#define SCU_PLL_USBPLLSTAT_BY_Pos             (6UL)                     /*!< SCU_PLL USBPLLSTAT: BY (Bit 6)                              */
#define SCU_PLL_USBPLLSTAT_BY_Msk             (0x40UL)                  /*!< SCU_PLL USBPLLSTAT: BY (Bitfield-Mask: 0x01)                */
#define SCU_PLL_USBPLLSTAT_VCOLOCKED_Pos      (7UL)                     /*!< SCU_PLL USBPLLSTAT: VCOLOCKED (Bit 7)                       */
#define SCU_PLL_USBPLLSTAT_VCOLOCKED_Msk      (0x80UL)                  /*!< SCU_PLL USBPLLSTAT: VCOLOCKED (Bitfield-Mask: 0x01)         */

/* ------------------------------  SCU_PLL_USBPLLCON  ----------------------------- */
#define SCU_PLL_USBPLLCON_VCOBYP_Pos          (0UL)                     /*!< SCU_PLL USBPLLCON: VCOBYP (Bit 0)                           */
#define SCU_PLL_USBPLLCON_VCOBYP_Msk          (0x1UL)                   /*!< SCU_PLL USBPLLCON: VCOBYP (Bitfield-Mask: 0x01)             */
#define SCU_PLL_USBPLLCON_VCOPWD_Pos          (1UL)                     /*!< SCU_PLL USBPLLCON: VCOPWD (Bit 1)                           */
#define SCU_PLL_USBPLLCON_VCOPWD_Msk          (0x2UL)                   /*!< SCU_PLL USBPLLCON: VCOPWD (Bitfield-Mask: 0x01)             */
#define SCU_PLL_USBPLLCON_VCOTR_Pos           (2UL)                     /*!< SCU_PLL USBPLLCON: VCOTR (Bit 2)                            */
#define SCU_PLL_USBPLLCON_VCOTR_Msk           (0x4UL)                   /*!< SCU_PLL USBPLLCON: VCOTR (Bitfield-Mask: 0x01)              */
#define SCU_PLL_USBPLLCON_FINDIS_Pos          (4UL)                     /*!< SCU_PLL USBPLLCON: FINDIS (Bit 4)                           */
#define SCU_PLL_USBPLLCON_FINDIS_Msk          (0x10UL)                  /*!< SCU_PLL USBPLLCON: FINDIS (Bitfield-Mask: 0x01)             */
#define SCU_PLL_USBPLLCON_OSCDISCDIS_Pos      (6UL)                     /*!< SCU_PLL USBPLLCON: OSCDISCDIS (Bit 6)                       */
#define SCU_PLL_USBPLLCON_OSCDISCDIS_Msk      (0x40UL)                  /*!< SCU_PLL USBPLLCON: OSCDISCDIS (Bitfield-Mask: 0x01)         */
#define SCU_PLL_USBPLLCON_NDIV_Pos            (8UL)                     /*!< SCU_PLL USBPLLCON: NDIV (Bit 8)                             */
#define SCU_PLL_USBPLLCON_NDIV_Msk            (0x7f00UL)                /*!< SCU_PLL USBPLLCON: NDIV (Bitfield-Mask: 0x7f)               */
#define SCU_PLL_USBPLLCON_PLLPWD_Pos          (16UL)                    /*!< SCU_PLL USBPLLCON: PLLPWD (Bit 16)                          */
#define SCU_PLL_USBPLLCON_PLLPWD_Msk          (0x10000UL)               /*!< SCU_PLL USBPLLCON: PLLPWD (Bitfield-Mask: 0x01)             */
#define SCU_PLL_USBPLLCON_RESLD_Pos           (18UL)                    /*!< SCU_PLL USBPLLCON: RESLD (Bit 18)                           */
#define SCU_PLL_USBPLLCON_RESLD_Msk           (0x40000UL)               /*!< SCU_PLL USBPLLCON: RESLD (Bitfield-Mask: 0x01)              */
#define SCU_PLL_USBPLLCON_PDIV_Pos            (24UL)                    /*!< SCU_PLL USBPLLCON: PDIV (Bit 24)                            */
#define SCU_PLL_USBPLLCON_PDIV_Msk            (0xf000000UL)             /*!< SCU_PLL USBPLLCON: PDIV (Bitfield-Mask: 0x0f)               */

/* ------------------------------  SCU_PLL_CLKMXSTAT  ----------------------------- */
#define SCU_PLL_CLKMXSTAT_SYSCLKMUX_Pos       (0UL)                     /*!< SCU_PLL CLKMXSTAT: SYSCLKMUX (Bit 0)                        */
#define SCU_PLL_CLKMXSTAT_SYSCLKMUX_Msk       (0x3UL)                   /*!< SCU_PLL CLKMXSTAT: SYSCLKMUX (Bitfield-Mask: 0x03)          */


/* ================================================================================ */
/* ================      struct 'SCU_GENERAL' Position & Mask      ================ */
/* ================================================================================ */


/* -------------------------------  SCU_GENERAL_ID  ------------------------------- */
#define SCU_GENERAL_ID_MOD_REV_Pos            (0UL)                     /*!< SCU_GENERAL ID: MOD_REV (Bit 0)                             */
#define SCU_GENERAL_ID_MOD_REV_Msk            (0xffUL)                  /*!< SCU_GENERAL ID: MOD_REV (Bitfield-Mask: 0xff)               */
#define SCU_GENERAL_ID_MOD_TYPE_Pos           (8UL)                     /*!< SCU_GENERAL ID: MOD_TYPE (Bit 8)                            */
#define SCU_GENERAL_ID_MOD_TYPE_Msk           (0xff00UL)                /*!< SCU_GENERAL ID: MOD_TYPE (Bitfield-Mask: 0xff)              */
#define SCU_GENERAL_ID_MOD_NUMBER_Pos         (16UL)                    /*!< SCU_GENERAL ID: MOD_NUMBER (Bit 16)                         */
#define SCU_GENERAL_ID_MOD_NUMBER_Msk         (0xffff0000UL)            /*!< SCU_GENERAL ID: MOD_NUMBER (Bitfield-Mask: 0xffff)          */

/* -----------------------------  SCU_GENERAL_IDCHIP  ----------------------------- */
#define SCU_GENERAL_IDCHIP_IDCHIP_Pos         (0UL)                     /*!< SCU_GENERAL IDCHIP: IDCHIP (Bit 0)                          */
#define SCU_GENERAL_IDCHIP_IDCHIP_Msk         (0xffffffffUL)            /*!< SCU_GENERAL IDCHIP: IDCHIP (Bitfield-Mask: 0xffffffff)      */

/* -----------------------------  SCU_GENERAL_IDMANUF  ---------------------------- */
#define SCU_GENERAL_IDMANUF_DEPT_Pos          (0UL)                     /*!< SCU_GENERAL IDMANUF: DEPT (Bit 0)                           */
#define SCU_GENERAL_IDMANUF_DEPT_Msk          (0x1fUL)                  /*!< SCU_GENERAL IDMANUF: DEPT (Bitfield-Mask: 0x1f)             */
#define SCU_GENERAL_IDMANUF_MANUF_Pos         (5UL)                     /*!< SCU_GENERAL IDMANUF: MANUF (Bit 5)                          */
#define SCU_GENERAL_IDMANUF_MANUF_Msk         (0xffe0UL)                /*!< SCU_GENERAL IDMANUF: MANUF (Bitfield-Mask: 0x7ff)           */

/* ------------------------------  SCU_GENERAL_STCON  ----------------------------- */
#define SCU_GENERAL_STCON_HWCON_Pos           (0UL)                     /*!< SCU_GENERAL STCON: HWCON (Bit 0)                            */
#define SCU_GENERAL_STCON_HWCON_Msk           (0x3UL)                   /*!< SCU_GENERAL STCON: HWCON (Bitfield-Mask: 0x03)              */
#define SCU_GENERAL_STCON_SWCON_Pos           (8UL)                     /*!< SCU_GENERAL STCON: SWCON (Bit 8)                            */
#define SCU_GENERAL_STCON_SWCON_Msk           (0xf00UL)                 /*!< SCU_GENERAL STCON: SWCON (Bitfield-Mask: 0x0f)              */

/* -------------------------------  SCU_GENERAL_GPR  ------------------------------ */
#define SCU_GENERAL_GPR_DAT_Pos               (0UL)                     /*!< SCU_GENERAL GPR: DAT (Bit 0)                                */
#define SCU_GENERAL_GPR_DAT_Msk               (0xffffffffUL)            /*!< SCU_GENERAL GPR: DAT (Bitfield-Mask: 0xffffffff)            */

/* -----------------------------  SCU_GENERAL_CCUCON  ----------------------------- */
#define SCU_GENERAL_CCUCON_GSC40_Pos          (0UL)                     /*!< SCU_GENERAL CCUCON: GSC40 (Bit 0)                           */
#define SCU_GENERAL_CCUCON_GSC40_Msk          (0x1UL)                   /*!< SCU_GENERAL CCUCON: GSC40 (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_CCUCON_GSC41_Pos          (1UL)                     /*!< SCU_GENERAL CCUCON: GSC41 (Bit 1)                           */
#define SCU_GENERAL_CCUCON_GSC41_Msk          (0x2UL)                   /*!< SCU_GENERAL CCUCON: GSC41 (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_CCUCON_GSC42_Pos          (2UL)                     /*!< SCU_GENERAL CCUCON: GSC42 (Bit 2)                           */
#define SCU_GENERAL_CCUCON_GSC42_Msk          (0x4UL)                   /*!< SCU_GENERAL CCUCON: GSC42 (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_CCUCON_GSC43_Pos          (3UL)                     /*!< SCU_GENERAL CCUCON: GSC43 (Bit 3)                           */
#define SCU_GENERAL_CCUCON_GSC43_Msk          (0x8UL)                   /*!< SCU_GENERAL CCUCON: GSC43 (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_CCUCON_GSC80_Pos          (8UL)                     /*!< SCU_GENERAL CCUCON: GSC80 (Bit 8)                           */
#define SCU_GENERAL_CCUCON_GSC80_Msk          (0x100UL)                 /*!< SCU_GENERAL CCUCON: GSC80 (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_CCUCON_GSC81_Pos          (9UL)                     /*!< SCU_GENERAL CCUCON: GSC81 (Bit 9)                           */
#define SCU_GENERAL_CCUCON_GSC81_Msk          (0x200UL)                 /*!< SCU_GENERAL CCUCON: GSC81 (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_CCUCON_GSHR0_Pos          (24UL)                    /*!< SCU_GENERAL CCUCON: GSHR0 (Bit 24)                          */
#define SCU_GENERAL_CCUCON_GSHR0_Msk          (0x1000000UL)             /*!< SCU_GENERAL CCUCON: GSHR0 (Bitfield-Mask: 0x01)             */

/* -----------------------------  SCU_GENERAL_DTSCON  ----------------------------- */
#define SCU_GENERAL_DTSCON_PWD_Pos            (0UL)                     /*!< SCU_GENERAL DTSCON: PWD (Bit 0)                             */
#define SCU_GENERAL_DTSCON_PWD_Msk            (0x1UL)                   /*!< SCU_GENERAL DTSCON: PWD (Bitfield-Mask: 0x01)               */
#define SCU_GENERAL_DTSCON_START_Pos          (1UL)                     /*!< SCU_GENERAL DTSCON: START (Bit 1)                           */
#define SCU_GENERAL_DTSCON_START_Msk          (0x2UL)                   /*!< SCU_GENERAL DTSCON: START (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_DTSCON_OFFSET_Pos         (4UL)                     /*!< SCU_GENERAL DTSCON: OFFSET (Bit 4)                          */
#define SCU_GENERAL_DTSCON_OFFSET_Msk         (0x7f0UL)                 /*!< SCU_GENERAL DTSCON: OFFSET (Bitfield-Mask: 0x7f)            */
#define SCU_GENERAL_DTSCON_GAIN_Pos           (11UL)                    /*!< SCU_GENERAL DTSCON: GAIN (Bit 11)                           */
#define SCU_GENERAL_DTSCON_GAIN_Msk           (0x1f800UL)               /*!< SCU_GENERAL DTSCON: GAIN (Bitfield-Mask: 0x3f)              */
#define SCU_GENERAL_DTSCON_REFTRIM_Pos        (17UL)                    /*!< SCU_GENERAL DTSCON: REFTRIM (Bit 17)                        */
#define SCU_GENERAL_DTSCON_REFTRIM_Msk        (0xe0000UL)               /*!< SCU_GENERAL DTSCON: REFTRIM (Bitfield-Mask: 0x07)           */
#define SCU_GENERAL_DTSCON_BGTRIM_Pos         (20UL)                    /*!< SCU_GENERAL DTSCON: BGTRIM (Bit 20)                         */
#define SCU_GENERAL_DTSCON_BGTRIM_Msk         (0xf00000UL)              /*!< SCU_GENERAL DTSCON: BGTRIM (Bitfield-Mask: 0x0f)            */

/* -----------------------------  SCU_GENERAL_DTSSTAT  ---------------------------- */
#define SCU_GENERAL_DTSSTAT_RESULT_Pos        (0UL)                     /*!< SCU_GENERAL DTSSTAT: RESULT (Bit 0)                         */
#define SCU_GENERAL_DTSSTAT_RESULT_Msk        (0x3ffUL)                 /*!< SCU_GENERAL DTSSTAT: RESULT (Bitfield-Mask: 0x3ff)          */
#define SCU_GENERAL_DTSSTAT_RDY_Pos           (14UL)                    /*!< SCU_GENERAL DTSSTAT: RDY (Bit 14)                           */
#define SCU_GENERAL_DTSSTAT_RDY_Msk           (0x4000UL)                /*!< SCU_GENERAL DTSSTAT: RDY (Bitfield-Mask: 0x01)              */
#define SCU_GENERAL_DTSSTAT_BUSY_Pos          (15UL)                    /*!< SCU_GENERAL DTSSTAT: BUSY (Bit 15)                          */
#define SCU_GENERAL_DTSSTAT_BUSY_Msk          (0x8000UL)                /*!< SCU_GENERAL DTSSTAT: BUSY (Bitfield-Mask: 0x01)             */

/* -----------------------------  SCU_GENERAL_GORCEN  ----------------------------- */
#define SCU_GENERAL_GORCEN_ENORC6_Pos         (6UL)                     /*!< SCU_GENERAL GORCEN: ENORC6 (Bit 6)                          */
#define SCU_GENERAL_GORCEN_ENORC6_Msk         (0x40UL)                  /*!< SCU_GENERAL GORCEN: ENORC6 (Bitfield-Mask: 0x01)            */
#define SCU_GENERAL_GORCEN_ENORC7_Pos         (7UL)                     /*!< SCU_GENERAL GORCEN: ENORC7 (Bit 7)                          */
#define SCU_GENERAL_GORCEN_ENORC7_Msk         (0x80UL)                  /*!< SCU_GENERAL GORCEN: ENORC7 (Bitfield-Mask: 0x01)            */

/* ----------------------------  SCU_GENERAL_DTEMPLIM  ---------------------------- */
#define SCU_GENERAL_DTEMPLIM_LOWER_Pos        (0UL)                     /*!< SCU_GENERAL DTEMPLIM: LOWER (Bit 0)                         */
#define SCU_GENERAL_DTEMPLIM_LOWER_Msk        (0x3ffUL)                 /*!< SCU_GENERAL DTEMPLIM: LOWER (Bitfield-Mask: 0x3ff)          */
#define SCU_GENERAL_DTEMPLIM_UPPER_Pos        (16UL)                    /*!< SCU_GENERAL DTEMPLIM: UPPER (Bit 16)                        */
#define SCU_GENERAL_DTEMPLIM_UPPER_Msk        (0x3ff0000UL)             /*!< SCU_GENERAL DTEMPLIM: UPPER (Bitfield-Mask: 0x3ff)          */

/* ---------------------------  SCU_GENERAL_DTEMPALARM  --------------------------- */
#define SCU_GENERAL_DTEMPALARM_UNDERFL_Pos    (0UL)                     /*!< SCU_GENERAL DTEMPALARM: UNDERFL (Bit 0)                     */
#define SCU_GENERAL_DTEMPALARM_UNDERFL_Msk    (0x1UL)                   /*!< SCU_GENERAL DTEMPALARM: UNDERFL (Bitfield-Mask: 0x01)       */
#define SCU_GENERAL_DTEMPALARM_OVERFL_Pos     (16UL)                    /*!< SCU_GENERAL DTEMPALARM: OVERFL (Bit 16)                     */
#define SCU_GENERAL_DTEMPALARM_OVERFL_Msk     (0x10000UL)               /*!< SCU_GENERAL DTEMPALARM: OVERFL (Bitfield-Mask: 0x01)        */

/* -----------------------------  SCU_GENERAL_MIRRSTS  ---------------------------- */
#define SCU_GENERAL_MIRRSTS_HDCLR_Pos         (1UL)                     /*!< SCU_GENERAL MIRRSTS: HDCLR (Bit 1)                          */
#define SCU_GENERAL_MIRRSTS_HDCLR_Msk         (0x2UL)                   /*!< SCU_GENERAL MIRRSTS: HDCLR (Bitfield-Mask: 0x01)            */
#define SCU_GENERAL_MIRRSTS_HDSET_Pos         (2UL)                     /*!< SCU_GENERAL MIRRSTS: HDSET (Bit 2)                          */
#define SCU_GENERAL_MIRRSTS_HDSET_Msk         (0x4UL)                   /*!< SCU_GENERAL MIRRSTS: HDSET (Bitfield-Mask: 0x01)            */
#define SCU_GENERAL_MIRRSTS_HDCR_Pos          (3UL)                     /*!< SCU_GENERAL MIRRSTS: HDCR (Bit 3)                           */
#define SCU_GENERAL_MIRRSTS_HDCR_Msk          (0x8UL)                   /*!< SCU_GENERAL MIRRSTS: HDCR (Bitfield-Mask: 0x01)             */
#define SCU_GENERAL_MIRRSTS_OSCSICTRL_Pos     (5UL)                     /*!< SCU_GENERAL MIRRSTS: OSCSICTRL (Bit 5)                      */
#define SCU_GENERAL_MIRRSTS_OSCSICTRL_Msk     (0x20UL)                  /*!< SCU_GENERAL MIRRSTS: OSCSICTRL (Bitfield-Mask: 0x01)        */
#define SCU_GENERAL_MIRRSTS_OSCULCTRL_Pos     (7UL)                     /*!< SCU_GENERAL MIRRSTS: OSCULCTRL (Bit 7)                      */
#define SCU_GENERAL_MIRRSTS_OSCULCTRL_Msk     (0x80UL)                  /*!< SCU_GENERAL MIRRSTS: OSCULCTRL (Bitfield-Mask: 0x01)        */
#define SCU_GENERAL_MIRRSTS_RTC_CTR_Pos       (8UL)                     /*!< SCU_GENERAL MIRRSTS: RTC_CTR (Bit 8)                        */
#define SCU_GENERAL_MIRRSTS_RTC_CTR_Msk       (0x100UL)                 /*!< SCU_GENERAL MIRRSTS: RTC_CTR (Bitfield-Mask: 0x01)          */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM0_Pos     (9UL)                     /*!< SCU_GENERAL MIRRSTS: RTC_ATIM0 (Bit 9)                      */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM0_Msk     (0x200UL)                 /*!< SCU_GENERAL MIRRSTS: RTC_ATIM0 (Bitfield-Mask: 0x01)        */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM1_Pos     (10UL)                    /*!< SCU_GENERAL MIRRSTS: RTC_ATIM1 (Bit 10)                     */
#define SCU_GENERAL_MIRRSTS_RTC_ATIM1_Msk     (0x400UL)                 /*!< SCU_GENERAL MIRRSTS: RTC_ATIM1 (Bitfield-Mask: 0x01)        */
#define SCU_GENERAL_MIRRSTS_RTC_TIM0_Pos      (11UL)                    /*!< SCU_GENERAL MIRRSTS: RTC_TIM0 (Bit 11)                      */
#define SCU_GENERAL_MIRRSTS_RTC_TIM0_Msk      (0x800UL)                 /*!< SCU_GENERAL MIRRSTS: RTC_TIM0 (Bitfield-Mask: 0x01)         */
#define SCU_GENERAL_MIRRSTS_RTC_TIM1_Pos      (12UL)                    /*!< SCU_GENERAL MIRRSTS: RTC_TIM1 (Bit 12)                      */
#define SCU_GENERAL_MIRRSTS_RTC_TIM1_Msk      (0x1000UL)                /*!< SCU_GENERAL MIRRSTS: RTC_TIM1 (Bitfield-Mask: 0x01)         */
#define SCU_GENERAL_MIRRSTS_RMX_Pos           (13UL)                    /*!< SCU_GENERAL MIRRSTS: RMX (Bit 13)                           */
#define SCU_GENERAL_MIRRSTS_RMX_Msk           (0x2000UL)                /*!< SCU_GENERAL MIRRSTS: RMX (Bitfield-Mask: 0x01)              */
#define SCU_GENERAL_MIRRSTS_RTC_MSKSR_Pos     (14UL)                    /*!< SCU_GENERAL MIRRSTS: RTC_MSKSR (Bit 14)                     */
#define SCU_GENERAL_MIRRSTS_RTC_MSKSR_Msk     (0x4000UL)                /*!< SCU_GENERAL MIRRSTS: RTC_MSKSR (Bitfield-Mask: 0x01)        */
#define SCU_GENERAL_MIRRSTS_RTC_CLRSR_Pos     (15UL)                    /*!< SCU_GENERAL MIRRSTS: RTC_CLRSR (Bit 15)                     */
#define SCU_GENERAL_MIRRSTS_RTC_CLRSR_Msk     (0x8000UL)                /*!< SCU_GENERAL MIRRSTS: RTC_CLRSR (Bitfield-Mask: 0x01)        */
#define SCU_GENERAL_MIRRSTS_LPACCONF_Pos      (16UL)                    /*!< SCU_GENERAL MIRRSTS: LPACCONF (Bit 16)                      */
#define SCU_GENERAL_MIRRSTS_LPACCONF_Msk      (0x10000UL)               /*!< SCU_GENERAL MIRRSTS: LPACCONF (Bitfield-Mask: 0x01)         */
#define SCU_GENERAL_MIRRSTS_LPACTH0_Pos       (17UL)                    /*!< SCU_GENERAL MIRRSTS: LPACTH0 (Bit 17)                       */
#define SCU_GENERAL_MIRRSTS_LPACTH0_Msk       (0x20000UL)               /*!< SCU_GENERAL MIRRSTS: LPACTH0 (Bitfield-Mask: 0x01)          */
#define SCU_GENERAL_MIRRSTS_LPACTH1_Pos       (18UL)                    /*!< SCU_GENERAL MIRRSTS: LPACTH1 (Bit 18)                       */
#define SCU_GENERAL_MIRRSTS_LPACTH1_Msk       (0x40000UL)               /*!< SCU_GENERAL MIRRSTS: LPACTH1 (Bitfield-Mask: 0x01)          */
#define SCU_GENERAL_MIRRSTS_LPACCLR_Pos       (20UL)                    /*!< SCU_GENERAL MIRRSTS: LPACCLR (Bit 20)                       */
#define SCU_GENERAL_MIRRSTS_LPACCLR_Msk       (0x100000UL)              /*!< SCU_GENERAL MIRRSTS: LPACCLR (Bitfield-Mask: 0x01)          */
#define SCU_GENERAL_MIRRSTS_LPACSET_Pos       (21UL)                    /*!< SCU_GENERAL MIRRSTS: LPACSET (Bit 21)                       */
#define SCU_GENERAL_MIRRSTS_LPACSET_Msk       (0x200000UL)              /*!< SCU_GENERAL MIRRSTS: LPACSET (Bitfield-Mask: 0x01)          */
#define SCU_GENERAL_MIRRSTS_HINTCLR_Pos       (23UL)                    /*!< SCU_GENERAL MIRRSTS: HINTCLR (Bit 23)                       */
#define SCU_GENERAL_MIRRSTS_HINTCLR_Msk       (0x800000UL)              /*!< SCU_GENERAL MIRRSTS: HINTCLR (Bitfield-Mask: 0x01)          */
#define SCU_GENERAL_MIRRSTS_HINTSET_Pos       (24UL)                    /*!< SCU_GENERAL MIRRSTS: HINTSET (Bit 24)                       */
#define SCU_GENERAL_MIRRSTS_HINTSET_Msk       (0x1000000UL)             /*!< SCU_GENERAL MIRRSTS: HINTSET (Bitfield-Mask: 0x01)          */

/* ------------------------------  SCU_GENERAL_RMACR  ----------------------------- */
#define SCU_GENERAL_RMACR_RDWR_Pos            (0UL)                     /*!< SCU_GENERAL RMACR: RDWR (Bit 0)                             */
#define SCU_GENERAL_RMACR_RDWR_Msk            (0x1UL)                   /*!< SCU_GENERAL RMACR: RDWR (Bitfield-Mask: 0x01)               */
#define SCU_GENERAL_RMACR_ADDR_Pos            (16UL)                    /*!< SCU_GENERAL RMACR: ADDR (Bit 16)                            */
#define SCU_GENERAL_RMACR_ADDR_Msk            (0xf0000UL)               /*!< SCU_GENERAL RMACR: ADDR (Bitfield-Mask: 0x0f)               */

/* -----------------------------  SCU_GENERAL_RMDATA  ----------------------------- */
#define SCU_GENERAL_RMDATA_DATA_Pos           (0UL)                     /*!< SCU_GENERAL RMDATA: DATA (Bit 0)                            */
#define SCU_GENERAL_RMDATA_DATA_Msk           (0xffffffffUL)            /*!< SCU_GENERAL RMDATA: DATA (Bitfield-Mask: 0xffffffff)        */

/* ---------------------------  SCU_GENERAL_MIRRALLSTAT  -------------------------- */
#define SCU_GENERAL_MIRRALLSTAT_BUSY_Pos      (0UL)                     /*!< SCU_GENERAL MIRRALLSTAT: BUSY (Bit 0)                       */
#define SCU_GENERAL_MIRRALLSTAT_BUSY_Msk      (0x1UL)                   /*!< SCU_GENERAL MIRRALLSTAT: BUSY (Bitfield-Mask: 0x01)         */

/* ---------------------------  SCU_GENERAL_MIRRALLREQ  --------------------------- */
#define SCU_GENERAL_MIRRALLREQ_REQ_Pos        (0UL)                     /*!< SCU_GENERAL MIRRALLREQ: REQ (Bit 0)                         */
#define SCU_GENERAL_MIRRALLREQ_REQ_Msk        (0x1UL)                   /*!< SCU_GENERAL MIRRALLREQ: REQ (Bitfield-Mask: 0x01)           */


/* ================================================================================ */
/* ================     struct 'SCU_INTERRUPT' Position & Mask     ================ */
/* ================================================================================ */


/* ----------------------------  SCU_INTERRUPT_SRSTAT  ---------------------------- */
#define SCU_INTERRUPT_SRSTAT_PRWARN_Pos       (0UL)                     /*!< SCU_INTERRUPT SRSTAT: PRWARN (Bit 0)                        */
#define SCU_INTERRUPT_SRSTAT_PRWARN_Msk       (0x1UL)                   /*!< SCU_INTERRUPT SRSTAT: PRWARN (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSTAT_PI_Pos           (1UL)                     /*!< SCU_INTERRUPT SRSTAT: PI (Bit 1)                            */
#define SCU_INTERRUPT_SRSTAT_PI_Msk           (0x2UL)                   /*!< SCU_INTERRUPT SRSTAT: PI (Bitfield-Mask: 0x01)              */
#define SCU_INTERRUPT_SRSTAT_AI_Pos           (2UL)                     /*!< SCU_INTERRUPT SRSTAT: AI (Bit 2)                            */
#define SCU_INTERRUPT_SRSTAT_AI_Msk           (0x4UL)                   /*!< SCU_INTERRUPT SRSTAT: AI (Bitfield-Mask: 0x01)              */
#define SCU_INTERRUPT_SRSTAT_DLROVR_Pos       (3UL)                     /*!< SCU_INTERRUPT SRSTAT: DLROVR (Bit 3)                        */
#define SCU_INTERRUPT_SRSTAT_DLROVR_Msk       (0x8UL)                   /*!< SCU_INTERRUPT SRSTAT: DLROVR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSTAT_LPACCR_Pos       (6UL)                     /*!< SCU_INTERRUPT SRSTAT: LPACCR (Bit 6)                        */
#define SCU_INTERRUPT_SRSTAT_LPACCR_Msk       (0x40UL)                  /*!< SCU_INTERRUPT SRSTAT: LPACCR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSTAT_LPACTH0_Pos      (7UL)                     /*!< SCU_INTERRUPT SRSTAT: LPACTH0 (Bit 7)                       */
#define SCU_INTERRUPT_SRSTAT_LPACTH0_Msk      (0x80UL)                  /*!< SCU_INTERRUPT SRSTAT: LPACTH0 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRSTAT_LPACTH1_Pos      (8UL)                     /*!< SCU_INTERRUPT SRSTAT: LPACTH1 (Bit 8)                       */
#define SCU_INTERRUPT_SRSTAT_LPACTH1_Msk      (0x100UL)                 /*!< SCU_INTERRUPT SRSTAT: LPACTH1 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRSTAT_LPACST_Pos       (9UL)                     /*!< SCU_INTERRUPT SRSTAT: LPACST (Bit 9)                        */
#define SCU_INTERRUPT_SRSTAT_LPACST_Msk       (0x200UL)                 /*!< SCU_INTERRUPT SRSTAT: LPACST (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSTAT_LPACCLR_Pos      (10UL)                    /*!< SCU_INTERRUPT SRSTAT: LPACCLR (Bit 10)                      */
#define SCU_INTERRUPT_SRSTAT_LPACCLR_Msk      (0x400UL)                 /*!< SCU_INTERRUPT SRSTAT: LPACCLR (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRSTAT_LPACSET_Pos      (11UL)                    /*!< SCU_INTERRUPT SRSTAT: LPACSET (Bit 11)                      */
#define SCU_INTERRUPT_SRSTAT_LPACSET_Msk      (0x800UL)                 /*!< SCU_INTERRUPT SRSTAT: LPACSET (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRSTAT_HINTST_Pos       (12UL)                    /*!< SCU_INTERRUPT SRSTAT: HINTST (Bit 12)                       */
#define SCU_INTERRUPT_SRSTAT_HINTST_Msk       (0x1000UL)                /*!< SCU_INTERRUPT SRSTAT: HINTST (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSTAT_HINTCLR_Pos      (13UL)                    /*!< SCU_INTERRUPT SRSTAT: HINTCLR (Bit 13)                      */
#define SCU_INTERRUPT_SRSTAT_HINTCLR_Msk      (0x2000UL)                /*!< SCU_INTERRUPT SRSTAT: HINTCLR (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRSTAT_HINTSET_Pos      (14UL)                    /*!< SCU_INTERRUPT SRSTAT: HINTSET (Bit 14)                      */
#define SCU_INTERRUPT_SRSTAT_HINTSET_Msk      (0x4000UL)                /*!< SCU_INTERRUPT SRSTAT: HINTSET (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRSTAT_HDCLR_Pos        (17UL)                    /*!< SCU_INTERRUPT SRSTAT: HDCLR (Bit 17)                        */
#define SCU_INTERRUPT_SRSTAT_HDCLR_Msk        (0x20000UL)               /*!< SCU_INTERRUPT SRSTAT: HDCLR (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRSTAT_HDSET_Pos        (18UL)                    /*!< SCU_INTERRUPT SRSTAT: HDSET (Bit 18)                        */
#define SCU_INTERRUPT_SRSTAT_HDSET_Msk        (0x40000UL)               /*!< SCU_INTERRUPT SRSTAT: HDSET (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRSTAT_HDCR_Pos         (19UL)                    /*!< SCU_INTERRUPT SRSTAT: HDCR (Bit 19)                         */
#define SCU_INTERRUPT_SRSTAT_HDCR_Msk         (0x80000UL)               /*!< SCU_INTERRUPT SRSTAT: HDCR (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_SRSTAT_OSCSICTRL_Pos    (21UL)                    /*!< SCU_INTERRUPT SRSTAT: OSCSICTRL (Bit 21)                    */
#define SCU_INTERRUPT_SRSTAT_OSCSICTRL_Msk    (0x200000UL)              /*!< SCU_INTERRUPT SRSTAT: OSCSICTRL (Bitfield-Mask: 0x01)       */
#define SCU_INTERRUPT_SRSTAT_OSCULCTRL_Pos    (23UL)                    /*!< SCU_INTERRUPT SRSTAT: OSCULCTRL (Bit 23)                    */
#define SCU_INTERRUPT_SRSTAT_OSCULCTRL_Msk    (0x800000UL)              /*!< SCU_INTERRUPT SRSTAT: OSCULCTRL (Bitfield-Mask: 0x01)       */
#define SCU_INTERRUPT_SRSTAT_RTC_CTR_Pos      (24UL)                    /*!< SCU_INTERRUPT SRSTAT: RTC_CTR (Bit 24)                      */
#define SCU_INTERRUPT_SRSTAT_RTC_CTR_Msk      (0x1000000UL)             /*!< SCU_INTERRUPT SRSTAT: RTC_CTR (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM0_Pos    (25UL)                    /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM0 (Bit 25)                    */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM0_Msk    (0x2000000UL)             /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM0 (Bitfield-Mask: 0x01)       */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM1_Pos    (26UL)                    /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM1 (Bit 26)                    */
#define SCU_INTERRUPT_SRSTAT_RTC_ATIM1_Msk    (0x4000000UL)             /*!< SCU_INTERRUPT SRSTAT: RTC_ATIM1 (Bitfield-Mask: 0x01)       */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM0_Pos     (27UL)                    /*!< SCU_INTERRUPT SRSTAT: RTC_TIM0 (Bit 27)                     */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM0_Msk     (0x8000000UL)             /*!< SCU_INTERRUPT SRSTAT: RTC_TIM0 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM1_Pos     (28UL)                    /*!< SCU_INTERRUPT SRSTAT: RTC_TIM1 (Bit 28)                     */
#define SCU_INTERRUPT_SRSTAT_RTC_TIM1_Msk     (0x10000000UL)            /*!< SCU_INTERRUPT SRSTAT: RTC_TIM1 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRSTAT_RMX_Pos          (29UL)                    /*!< SCU_INTERRUPT SRSTAT: RMX (Bit 29)                          */
#define SCU_INTERRUPT_SRSTAT_RMX_Msk          (0x20000000UL)            /*!< SCU_INTERRUPT SRSTAT: RMX (Bitfield-Mask: 0x01)             */

/* -----------------------------  SCU_INTERRUPT_SRRAW  ---------------------------- */
#define SCU_INTERRUPT_SRRAW_PRWARN_Pos        (0UL)                     /*!< SCU_INTERRUPT SRRAW: PRWARN (Bit 0)                         */
#define SCU_INTERRUPT_SRRAW_PRWARN_Msk        (0x1UL)                   /*!< SCU_INTERRUPT SRRAW: PRWARN (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRRAW_PI_Pos            (1UL)                     /*!< SCU_INTERRUPT SRRAW: PI (Bit 1)                             */
#define SCU_INTERRUPT_SRRAW_PI_Msk            (0x2UL)                   /*!< SCU_INTERRUPT SRRAW: PI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRRAW_AI_Pos            (2UL)                     /*!< SCU_INTERRUPT SRRAW: AI (Bit 2)                             */
#define SCU_INTERRUPT_SRRAW_AI_Msk            (0x4UL)                   /*!< SCU_INTERRUPT SRRAW: AI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRRAW_DLROVR_Pos        (3UL)                     /*!< SCU_INTERRUPT SRRAW: DLROVR (Bit 3)                         */
#define SCU_INTERRUPT_SRRAW_DLROVR_Msk        (0x8UL)                   /*!< SCU_INTERRUPT SRRAW: DLROVR (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRRAW_LPACCR_Pos        (6UL)                     /*!< SCU_INTERRUPT SRRAW: LPACCR (Bit 6)                         */
#define SCU_INTERRUPT_SRRAW_LPACCR_Msk        (0x40UL)                  /*!< SCU_INTERRUPT SRRAW: LPACCR (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRRAW_LPACTH0_Pos       (7UL)                     /*!< SCU_INTERRUPT SRRAW: LPACTH0 (Bit 7)                        */
#define SCU_INTERRUPT_SRRAW_LPACTH0_Msk       (0x80UL)                  /*!< SCU_INTERRUPT SRRAW: LPACTH0 (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRRAW_LPACTH1_Pos       (8UL)                     /*!< SCU_INTERRUPT SRRAW: LPACTH1 (Bit 8)                        */
#define SCU_INTERRUPT_SRRAW_LPACTH1_Msk       (0x100UL)                 /*!< SCU_INTERRUPT SRRAW: LPACTH1 (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRRAW_LPACST_Pos        (9UL)                     /*!< SCU_INTERRUPT SRRAW: LPACST (Bit 9)                         */
#define SCU_INTERRUPT_SRRAW_LPACST_Msk        (0x200UL)                 /*!< SCU_INTERRUPT SRRAW: LPACST (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRRAW_LPACCLR_Pos       (10UL)                    /*!< SCU_INTERRUPT SRRAW: LPACCLR (Bit 10)                       */
#define SCU_INTERRUPT_SRRAW_LPACCLR_Msk       (0x400UL)                 /*!< SCU_INTERRUPT SRRAW: LPACCLR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRRAW_LPACSET_Pos       (11UL)                    /*!< SCU_INTERRUPT SRRAW: LPACSET (Bit 11)                       */
#define SCU_INTERRUPT_SRRAW_LPACSET_Msk       (0x800UL)                 /*!< SCU_INTERRUPT SRRAW: LPACSET (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRRAW_HINTST_Pos        (12UL)                    /*!< SCU_INTERRUPT SRRAW: HINTST (Bit 12)                        */
#define SCU_INTERRUPT_SRRAW_HINTST_Msk        (0x1000UL)                /*!< SCU_INTERRUPT SRRAW: HINTST (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRRAW_HINTCLR_Pos       (13UL)                    /*!< SCU_INTERRUPT SRRAW: HINTCLR (Bit 13)                       */
#define SCU_INTERRUPT_SRRAW_HINTCLR_Msk       (0x2000UL)                /*!< SCU_INTERRUPT SRRAW: HINTCLR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRRAW_HINTSET_Pos       (14UL)                    /*!< SCU_INTERRUPT SRRAW: HINTSET (Bit 14)                       */
#define SCU_INTERRUPT_SRRAW_HINTSET_Msk       (0x4000UL)                /*!< SCU_INTERRUPT SRRAW: HINTSET (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRRAW_HDCLR_Pos         (17UL)                    /*!< SCU_INTERRUPT SRRAW: HDCLR (Bit 17)                         */
#define SCU_INTERRUPT_SRRAW_HDCLR_Msk         (0x20000UL)               /*!< SCU_INTERRUPT SRRAW: HDCLR (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_SRRAW_HDSET_Pos         (18UL)                    /*!< SCU_INTERRUPT SRRAW: HDSET (Bit 18)                         */
#define SCU_INTERRUPT_SRRAW_HDSET_Msk         (0x40000UL)               /*!< SCU_INTERRUPT SRRAW: HDSET (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_SRRAW_HDCR_Pos          (19UL)                    /*!< SCU_INTERRUPT SRRAW: HDCR (Bit 19)                          */
#define SCU_INTERRUPT_SRRAW_HDCR_Msk          (0x80000UL)               /*!< SCU_INTERRUPT SRRAW: HDCR (Bitfield-Mask: 0x01)             */
#define SCU_INTERRUPT_SRRAW_OSCSICTRL_Pos     (21UL)                    /*!< SCU_INTERRUPT SRRAW: OSCSICTRL (Bit 21)                     */
#define SCU_INTERRUPT_SRRAW_OSCSICTRL_Msk     (0x200000UL)              /*!< SCU_INTERRUPT SRRAW: OSCSICTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRRAW_OSCULCTRL_Pos     (23UL)                    /*!< SCU_INTERRUPT SRRAW: OSCULCTRL (Bit 23)                     */
#define SCU_INTERRUPT_SRRAW_OSCULCTRL_Msk     (0x800000UL)              /*!< SCU_INTERRUPT SRRAW: OSCULCTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRRAW_RTC_CTR_Pos       (24UL)                    /*!< SCU_INTERRUPT SRRAW: RTC_CTR (Bit 24)                       */
#define SCU_INTERRUPT_SRRAW_RTC_CTR_Msk       (0x1000000UL)             /*!< SCU_INTERRUPT SRRAW: RTC_CTR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM0_Pos     (25UL)                    /*!< SCU_INTERRUPT SRRAW: RTC_ATIM0 (Bit 25)                     */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM0_Msk     (0x2000000UL)             /*!< SCU_INTERRUPT SRRAW: RTC_ATIM0 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM1_Pos     (26UL)                    /*!< SCU_INTERRUPT SRRAW: RTC_ATIM1 (Bit 26)                     */
#define SCU_INTERRUPT_SRRAW_RTC_ATIM1_Msk     (0x4000000UL)             /*!< SCU_INTERRUPT SRRAW: RTC_ATIM1 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRRAW_RTC_TIM0_Pos      (27UL)                    /*!< SCU_INTERRUPT SRRAW: RTC_TIM0 (Bit 27)                      */
#define SCU_INTERRUPT_SRRAW_RTC_TIM0_Msk      (0x8000000UL)             /*!< SCU_INTERRUPT SRRAW: RTC_TIM0 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRRAW_RTC_TIM1_Pos      (28UL)                    /*!< SCU_INTERRUPT SRRAW: RTC_TIM1 (Bit 28)                      */
#define SCU_INTERRUPT_SRRAW_RTC_TIM1_Msk      (0x10000000UL)            /*!< SCU_INTERRUPT SRRAW: RTC_TIM1 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRRAW_RMX_Pos           (29UL)                    /*!< SCU_INTERRUPT SRRAW: RMX (Bit 29)                           */
#define SCU_INTERRUPT_SRRAW_RMX_Msk           (0x20000000UL)            /*!< SCU_INTERRUPT SRRAW: RMX (Bitfield-Mask: 0x01)              */

/* -----------------------------  SCU_INTERRUPT_SRMSK  ---------------------------- */
#define SCU_INTERRUPT_SRMSK_PRWARN_Pos        (0UL)                     /*!< SCU_INTERRUPT SRMSK: PRWARN (Bit 0)                         */
#define SCU_INTERRUPT_SRMSK_PRWARN_Msk        (0x1UL)                   /*!< SCU_INTERRUPT SRMSK: PRWARN (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRMSK_PI_Pos            (1UL)                     /*!< SCU_INTERRUPT SRMSK: PI (Bit 1)                             */
#define SCU_INTERRUPT_SRMSK_PI_Msk            (0x2UL)                   /*!< SCU_INTERRUPT SRMSK: PI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRMSK_AI_Pos            (2UL)                     /*!< SCU_INTERRUPT SRMSK: AI (Bit 2)                             */
#define SCU_INTERRUPT_SRMSK_AI_Msk            (0x4UL)                   /*!< SCU_INTERRUPT SRMSK: AI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRMSK_DLROVR_Pos        (3UL)                     /*!< SCU_INTERRUPT SRMSK: DLROVR (Bit 3)                         */
#define SCU_INTERRUPT_SRMSK_DLROVR_Msk        (0x8UL)                   /*!< SCU_INTERRUPT SRMSK: DLROVR (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRMSK_LPACCR_Pos        (6UL)                     /*!< SCU_INTERRUPT SRMSK: LPACCR (Bit 6)                         */
#define SCU_INTERRUPT_SRMSK_LPACCR_Msk        (0x40UL)                  /*!< SCU_INTERRUPT SRMSK: LPACCR (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRMSK_LPACTH0_Pos       (7UL)                     /*!< SCU_INTERRUPT SRMSK: LPACTH0 (Bit 7)                        */
#define SCU_INTERRUPT_SRMSK_LPACTH0_Msk       (0x80UL)                  /*!< SCU_INTERRUPT SRMSK: LPACTH0 (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRMSK_LPACTH1_Pos       (8UL)                     /*!< SCU_INTERRUPT SRMSK: LPACTH1 (Bit 8)                        */
#define SCU_INTERRUPT_SRMSK_LPACTH1_Msk       (0x100UL)                 /*!< SCU_INTERRUPT SRMSK: LPACTH1 (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRMSK_LPACST_Pos        (9UL)                     /*!< SCU_INTERRUPT SRMSK: LPACST (Bit 9)                         */
#define SCU_INTERRUPT_SRMSK_LPACST_Msk        (0x200UL)                 /*!< SCU_INTERRUPT SRMSK: LPACST (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRMSK_LPACCLR_Pos       (10UL)                    /*!< SCU_INTERRUPT SRMSK: LPACCLR (Bit 10)                       */
#define SCU_INTERRUPT_SRMSK_LPACCLR_Msk       (0x400UL)                 /*!< SCU_INTERRUPT SRMSK: LPACCLR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRMSK_LPACSET_Pos       (11UL)                    /*!< SCU_INTERRUPT SRMSK: LPACSET (Bit 11)                       */
#define SCU_INTERRUPT_SRMSK_LPACSET_Msk       (0x800UL)                 /*!< SCU_INTERRUPT SRMSK: LPACSET (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRMSK_HINTST_Pos        (12UL)                    /*!< SCU_INTERRUPT SRMSK: HINTST (Bit 12)                        */
#define SCU_INTERRUPT_SRMSK_HINTST_Msk        (0x1000UL)                /*!< SCU_INTERRUPT SRMSK: HINTST (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRMSK_HINTCLR_Pos       (13UL)                    /*!< SCU_INTERRUPT SRMSK: HINTCLR (Bit 13)                       */
#define SCU_INTERRUPT_SRMSK_HINTCLR_Msk       (0x2000UL)                /*!< SCU_INTERRUPT SRMSK: HINTCLR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRMSK_HINTSET_Pos       (14UL)                    /*!< SCU_INTERRUPT SRMSK: HINTSET (Bit 14)                       */
#define SCU_INTERRUPT_SRMSK_HINTSET_Msk       (0x4000UL)                /*!< SCU_INTERRUPT SRMSK: HINTSET (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRMSK_HDCLR_Pos         (17UL)                    /*!< SCU_INTERRUPT SRMSK: HDCLR (Bit 17)                         */
#define SCU_INTERRUPT_SRMSK_HDCLR_Msk         (0x20000UL)               /*!< SCU_INTERRUPT SRMSK: HDCLR (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_SRMSK_HDSET_Pos         (18UL)                    /*!< SCU_INTERRUPT SRMSK: HDSET (Bit 18)                         */
#define SCU_INTERRUPT_SRMSK_HDSET_Msk         (0x40000UL)               /*!< SCU_INTERRUPT SRMSK: HDSET (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_SRMSK_HDCR_Pos          (19UL)                    /*!< SCU_INTERRUPT SRMSK: HDCR (Bit 19)                          */
#define SCU_INTERRUPT_SRMSK_HDCR_Msk          (0x80000UL)               /*!< SCU_INTERRUPT SRMSK: HDCR (Bitfield-Mask: 0x01)             */
#define SCU_INTERRUPT_SRMSK_OSCSICTRL_Pos     (21UL)                    /*!< SCU_INTERRUPT SRMSK: OSCSICTRL (Bit 21)                     */
#define SCU_INTERRUPT_SRMSK_OSCSICTRL_Msk     (0x200000UL)              /*!< SCU_INTERRUPT SRMSK: OSCSICTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRMSK_OSCULCTRL_Pos     (23UL)                    /*!< SCU_INTERRUPT SRMSK: OSCULCTRL (Bit 23)                     */
#define SCU_INTERRUPT_SRMSK_OSCULCTRL_Msk     (0x800000UL)              /*!< SCU_INTERRUPT SRMSK: OSCULCTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRMSK_RTC_CTR_Pos       (24UL)                    /*!< SCU_INTERRUPT SRMSK: RTC_CTR (Bit 24)                       */
#define SCU_INTERRUPT_SRMSK_RTC_CTR_Msk       (0x1000000UL)             /*!< SCU_INTERRUPT SRMSK: RTC_CTR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM0_Pos     (25UL)                    /*!< SCU_INTERRUPT SRMSK: RTC_ATIM0 (Bit 25)                     */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM0_Msk     (0x2000000UL)             /*!< SCU_INTERRUPT SRMSK: RTC_ATIM0 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM1_Pos     (26UL)                    /*!< SCU_INTERRUPT SRMSK: RTC_ATIM1 (Bit 26)                     */
#define SCU_INTERRUPT_SRMSK_RTC_ATIM1_Msk     (0x4000000UL)             /*!< SCU_INTERRUPT SRMSK: RTC_ATIM1 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRMSK_RTC_TIM0_Pos      (27UL)                    /*!< SCU_INTERRUPT SRMSK: RTC_TIM0 (Bit 27)                      */
#define SCU_INTERRUPT_SRMSK_RTC_TIM0_Msk      (0x8000000UL)             /*!< SCU_INTERRUPT SRMSK: RTC_TIM0 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRMSK_RTC_TIM1_Pos      (28UL)                    /*!< SCU_INTERRUPT SRMSK: RTC_TIM1 (Bit 28)                      */
#define SCU_INTERRUPT_SRMSK_RTC_TIM1_Msk      (0x10000000UL)            /*!< SCU_INTERRUPT SRMSK: RTC_TIM1 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRMSK_RMX_Pos           (29UL)                    /*!< SCU_INTERRUPT SRMSK: RMX (Bit 29)                           */
#define SCU_INTERRUPT_SRMSK_RMX_Msk           (0x20000000UL)            /*!< SCU_INTERRUPT SRMSK: RMX (Bitfield-Mask: 0x01)              */

/* -----------------------------  SCU_INTERRUPT_SRCLR  ---------------------------- */
#define SCU_INTERRUPT_SRCLR_PRWARN_Pos        (0UL)                     /*!< SCU_INTERRUPT SRCLR: PRWARN (Bit 0)                         */
#define SCU_INTERRUPT_SRCLR_PRWARN_Msk        (0x1UL)                   /*!< SCU_INTERRUPT SRCLR: PRWARN (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRCLR_PI_Pos            (1UL)                     /*!< SCU_INTERRUPT SRCLR: PI (Bit 1)                             */
#define SCU_INTERRUPT_SRCLR_PI_Msk            (0x2UL)                   /*!< SCU_INTERRUPT SRCLR: PI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRCLR_AI_Pos            (2UL)                     /*!< SCU_INTERRUPT SRCLR: AI (Bit 2)                             */
#define SCU_INTERRUPT_SRCLR_AI_Msk            (0x4UL)                   /*!< SCU_INTERRUPT SRCLR: AI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRCLR_DLROVR_Pos        (3UL)                     /*!< SCU_INTERRUPT SRCLR: DLROVR (Bit 3)                         */
#define SCU_INTERRUPT_SRCLR_DLROVR_Msk        (0x8UL)                   /*!< SCU_INTERRUPT SRCLR: DLROVR (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRCLR_LPACCR_Pos        (6UL)                     /*!< SCU_INTERRUPT SRCLR: LPACCR (Bit 6)                         */
#define SCU_INTERRUPT_SRCLR_LPACCR_Msk        (0x40UL)                  /*!< SCU_INTERRUPT SRCLR: LPACCR (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRCLR_LPACTH0_Pos       (7UL)                     /*!< SCU_INTERRUPT SRCLR: LPACTH0 (Bit 7)                        */
#define SCU_INTERRUPT_SRCLR_LPACTH0_Msk       (0x80UL)                  /*!< SCU_INTERRUPT SRCLR: LPACTH0 (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRCLR_LPACTH1_Pos       (8UL)                     /*!< SCU_INTERRUPT SRCLR: LPACTH1 (Bit 8)                        */
#define SCU_INTERRUPT_SRCLR_LPACTH1_Msk       (0x100UL)                 /*!< SCU_INTERRUPT SRCLR: LPACTH1 (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRCLR_LPACST_Pos        (9UL)                     /*!< SCU_INTERRUPT SRCLR: LPACST (Bit 9)                         */
#define SCU_INTERRUPT_SRCLR_LPACST_Msk        (0x200UL)                 /*!< SCU_INTERRUPT SRCLR: LPACST (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRCLR_LPACCLR_Pos       (10UL)                    /*!< SCU_INTERRUPT SRCLR: LPACCLR (Bit 10)                       */
#define SCU_INTERRUPT_SRCLR_LPACCLR_Msk       (0x400UL)                 /*!< SCU_INTERRUPT SRCLR: LPACCLR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRCLR_LPACSET_Pos       (11UL)                    /*!< SCU_INTERRUPT SRCLR: LPACSET (Bit 11)                       */
#define SCU_INTERRUPT_SRCLR_LPACSET_Msk       (0x800UL)                 /*!< SCU_INTERRUPT SRCLR: LPACSET (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRCLR_HINTST_Pos        (12UL)                    /*!< SCU_INTERRUPT SRCLR: HINTST (Bit 12)                        */
#define SCU_INTERRUPT_SRCLR_HINTST_Msk        (0x1000UL)                /*!< SCU_INTERRUPT SRCLR: HINTST (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRCLR_HINTCLR_Pos       (13UL)                    /*!< SCU_INTERRUPT SRCLR: HINTCLR (Bit 13)                       */
#define SCU_INTERRUPT_SRCLR_HINTCLR_Msk       (0x2000UL)                /*!< SCU_INTERRUPT SRCLR: HINTCLR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRCLR_HINTSET_Pos       (14UL)                    /*!< SCU_INTERRUPT SRCLR: HINTSET (Bit 14)                       */
#define SCU_INTERRUPT_SRCLR_HINTSET_Msk       (0x4000UL)                /*!< SCU_INTERRUPT SRCLR: HINTSET (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRCLR_HDCLR_Pos         (17UL)                    /*!< SCU_INTERRUPT SRCLR: HDCLR (Bit 17)                         */
#define SCU_INTERRUPT_SRCLR_HDCLR_Msk         (0x20000UL)               /*!< SCU_INTERRUPT SRCLR: HDCLR (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_SRCLR_HDSET_Pos         (18UL)                    /*!< SCU_INTERRUPT SRCLR: HDSET (Bit 18)                         */
#define SCU_INTERRUPT_SRCLR_HDSET_Msk         (0x40000UL)               /*!< SCU_INTERRUPT SRCLR: HDSET (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_SRCLR_HDCR_Pos          (19UL)                    /*!< SCU_INTERRUPT SRCLR: HDCR (Bit 19)                          */
#define SCU_INTERRUPT_SRCLR_HDCR_Msk          (0x80000UL)               /*!< SCU_INTERRUPT SRCLR: HDCR (Bitfield-Mask: 0x01)             */
#define SCU_INTERRUPT_SRCLR_OSCSICTRL_Pos     (21UL)                    /*!< SCU_INTERRUPT SRCLR: OSCSICTRL (Bit 21)                     */
#define SCU_INTERRUPT_SRCLR_OSCSICTRL_Msk     (0x200000UL)              /*!< SCU_INTERRUPT SRCLR: OSCSICTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRCLR_OSCULCTRL_Pos     (23UL)                    /*!< SCU_INTERRUPT SRCLR: OSCULCTRL (Bit 23)                     */
#define SCU_INTERRUPT_SRCLR_OSCULCTRL_Msk     (0x800000UL)              /*!< SCU_INTERRUPT SRCLR: OSCULCTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRCLR_RTC_CTR_Pos       (24UL)                    /*!< SCU_INTERRUPT SRCLR: RTC_CTR (Bit 24)                       */
#define SCU_INTERRUPT_SRCLR_RTC_CTR_Msk       (0x1000000UL)             /*!< SCU_INTERRUPT SRCLR: RTC_CTR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM0_Pos     (25UL)                    /*!< SCU_INTERRUPT SRCLR: RTC_ATIM0 (Bit 25)                     */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM0_Msk     (0x2000000UL)             /*!< SCU_INTERRUPT SRCLR: RTC_ATIM0 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM1_Pos     (26UL)                    /*!< SCU_INTERRUPT SRCLR: RTC_ATIM1 (Bit 26)                     */
#define SCU_INTERRUPT_SRCLR_RTC_ATIM1_Msk     (0x4000000UL)             /*!< SCU_INTERRUPT SRCLR: RTC_ATIM1 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRCLR_RTC_TIM0_Pos      (27UL)                    /*!< SCU_INTERRUPT SRCLR: RTC_TIM0 (Bit 27)                      */
#define SCU_INTERRUPT_SRCLR_RTC_TIM0_Msk      (0x8000000UL)             /*!< SCU_INTERRUPT SRCLR: RTC_TIM0 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRCLR_RTC_TIM1_Pos      (28UL)                    /*!< SCU_INTERRUPT SRCLR: RTC_TIM1 (Bit 28)                      */
#define SCU_INTERRUPT_SRCLR_RTC_TIM1_Msk      (0x10000000UL)            /*!< SCU_INTERRUPT SRCLR: RTC_TIM1 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRCLR_RMX_Pos           (29UL)                    /*!< SCU_INTERRUPT SRCLR: RMX (Bit 29)                           */
#define SCU_INTERRUPT_SRCLR_RMX_Msk           (0x20000000UL)            /*!< SCU_INTERRUPT SRCLR: RMX (Bitfield-Mask: 0x01)              */

/* -----------------------------  SCU_INTERRUPT_SRSET  ---------------------------- */
#define SCU_INTERRUPT_SRSET_PRWARN_Pos        (0UL)                     /*!< SCU_INTERRUPT SRSET: PRWARN (Bit 0)                         */
#define SCU_INTERRUPT_SRSET_PRWARN_Msk        (0x1UL)                   /*!< SCU_INTERRUPT SRSET: PRWARN (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRSET_PI_Pos            (1UL)                     /*!< SCU_INTERRUPT SRSET: PI (Bit 1)                             */
#define SCU_INTERRUPT_SRSET_PI_Msk            (0x2UL)                   /*!< SCU_INTERRUPT SRSET: PI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRSET_AI_Pos            (2UL)                     /*!< SCU_INTERRUPT SRSET: AI (Bit 2)                             */
#define SCU_INTERRUPT_SRSET_AI_Msk            (0x4UL)                   /*!< SCU_INTERRUPT SRSET: AI (Bitfield-Mask: 0x01)               */
#define SCU_INTERRUPT_SRSET_DLROVR_Pos        (3UL)                     /*!< SCU_INTERRUPT SRSET: DLROVR (Bit 3)                         */
#define SCU_INTERRUPT_SRSET_DLROVR_Msk        (0x8UL)                   /*!< SCU_INTERRUPT SRSET: DLROVR (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRSET_LPACCR_Pos        (6UL)                     /*!< SCU_INTERRUPT SRSET: LPACCR (Bit 6)                         */
#define SCU_INTERRUPT_SRSET_LPACCR_Msk        (0x40UL)                  /*!< SCU_INTERRUPT SRSET: LPACCR (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRSET_LPACTH0_Pos       (7UL)                     /*!< SCU_INTERRUPT SRSET: LPACTH0 (Bit 7)                        */
#define SCU_INTERRUPT_SRSET_LPACTH0_Msk       (0x80UL)                  /*!< SCU_INTERRUPT SRSET: LPACTH0 (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSET_LPACTH1_Pos       (8UL)                     /*!< SCU_INTERRUPT SRSET: LPACTH1 (Bit 8)                        */
#define SCU_INTERRUPT_SRSET_LPACTH1_Msk       (0x100UL)                 /*!< SCU_INTERRUPT SRSET: LPACTH1 (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSET_LPACST_Pos        (9UL)                     /*!< SCU_INTERRUPT SRSET: LPACST (Bit 9)                         */
#define SCU_INTERRUPT_SRSET_LPACST_Msk        (0x200UL)                 /*!< SCU_INTERRUPT SRSET: LPACST (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRSET_LPACCLR_Pos       (10UL)                    /*!< SCU_INTERRUPT SRSET: LPACCLR (Bit 10)                       */
#define SCU_INTERRUPT_SRSET_LPACCLR_Msk       (0x400UL)                 /*!< SCU_INTERRUPT SRSET: LPACCLR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSET_LPACSET_Pos       (11UL)                    /*!< SCU_INTERRUPT SRSET: LPACSET (Bit 11)                       */
#define SCU_INTERRUPT_SRSET_LPACSET_Msk       (0x800UL)                 /*!< SCU_INTERRUPT SRSET: LPACSET (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSET_HINTST_Pos        (12UL)                    /*!< SCU_INTERRUPT SRSET: HINTST (Bit 12)                        */
#define SCU_INTERRUPT_SRSET_HINTST_Msk        (0x1000UL)                /*!< SCU_INTERRUPT SRSET: HINTST (Bitfield-Mask: 0x01)           */
#define SCU_INTERRUPT_SRSET_HINTCLR_Pos       (13UL)                    /*!< SCU_INTERRUPT SRSET: HINTCLR (Bit 13)                       */
#define SCU_INTERRUPT_SRSET_HINTCLR_Msk       (0x2000UL)                /*!< SCU_INTERRUPT SRSET: HINTCLR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSET_HINTSET_Pos       (14UL)                    /*!< SCU_INTERRUPT SRSET: HINTSET (Bit 14)                       */
#define SCU_INTERRUPT_SRSET_HINTSET_Msk       (0x4000UL)                /*!< SCU_INTERRUPT SRSET: HINTSET (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSET_HDCRCLR_Pos       (17UL)                    /*!< SCU_INTERRUPT SRSET: HDCRCLR (Bit 17)                       */
#define SCU_INTERRUPT_SRSET_HDCRCLR_Msk       (0x20000UL)               /*!< SCU_INTERRUPT SRSET: HDCRCLR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSET_HDCRSET_Pos       (18UL)                    /*!< SCU_INTERRUPT SRSET: HDCRSET (Bit 18)                       */
#define SCU_INTERRUPT_SRSET_HDCRSET_Msk       (0x40000UL)               /*!< SCU_INTERRUPT SRSET: HDCRSET (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSET_HDCR_Pos          (19UL)                    /*!< SCU_INTERRUPT SRSET: HDCR (Bit 19)                          */
#define SCU_INTERRUPT_SRSET_HDCR_Msk          (0x80000UL)               /*!< SCU_INTERRUPT SRSET: HDCR (Bitfield-Mask: 0x01)             */
#define SCU_INTERRUPT_SRSET_OSCSICTRL_Pos     (21UL)                    /*!< SCU_INTERRUPT SRSET: OSCSICTRL (Bit 21)                     */
#define SCU_INTERRUPT_SRSET_OSCSICTRL_Msk     (0x200000UL)              /*!< SCU_INTERRUPT SRSET: OSCSICTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRSET_OSCULCTRL_Pos     (23UL)                    /*!< SCU_INTERRUPT SRSET: OSCULCTRL (Bit 23)                     */
#define SCU_INTERRUPT_SRSET_OSCULCTRL_Msk     (0x800000UL)              /*!< SCU_INTERRUPT SRSET: OSCULCTRL (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRSET_RTC_CTR_Pos       (24UL)                    /*!< SCU_INTERRUPT SRSET: RTC_CTR (Bit 24)                       */
#define SCU_INTERRUPT_SRSET_RTC_CTR_Msk       (0x1000000UL)             /*!< SCU_INTERRUPT SRSET: RTC_CTR (Bitfield-Mask: 0x01)          */
#define SCU_INTERRUPT_SRSET_RTC_ATIM0_Pos     (25UL)                    /*!< SCU_INTERRUPT SRSET: RTC_ATIM0 (Bit 25)                     */
#define SCU_INTERRUPT_SRSET_RTC_ATIM0_Msk     (0x2000000UL)             /*!< SCU_INTERRUPT SRSET: RTC_ATIM0 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRSET_RTC_ATIM1_Pos     (26UL)                    /*!< SCU_INTERRUPT SRSET: RTC_ATIM1 (Bit 26)                     */
#define SCU_INTERRUPT_SRSET_RTC_ATIM1_Msk     (0x4000000UL)             /*!< SCU_INTERRUPT SRSET: RTC_ATIM1 (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_SRSET_RTC_TIM0_Pos      (27UL)                    /*!< SCU_INTERRUPT SRSET: RTC_TIM0 (Bit 27)                      */
#define SCU_INTERRUPT_SRSET_RTC_TIM0_Msk      (0x8000000UL)             /*!< SCU_INTERRUPT SRSET: RTC_TIM0 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRSET_RTC_TIM1_Pos      (28UL)                    /*!< SCU_INTERRUPT SRSET: RTC_TIM1 (Bit 28)                      */
#define SCU_INTERRUPT_SRSET_RTC_TIM1_Msk      (0x10000000UL)            /*!< SCU_INTERRUPT SRSET: RTC_TIM1 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_SRSET_RMX_Pos           (29UL)                    /*!< SCU_INTERRUPT SRSET: RMX (Bit 29)                           */
#define SCU_INTERRUPT_SRSET_RMX_Msk           (0x20000000UL)            /*!< SCU_INTERRUPT SRSET: RMX (Bitfield-Mask: 0x01)              */

/* ---------------------------  SCU_INTERRUPT_NMIREQEN  --------------------------- */
#define SCU_INTERRUPT_NMIREQEN_PRWARN_Pos     (0UL)                     /*!< SCU_INTERRUPT NMIREQEN: PRWARN (Bit 0)                      */
#define SCU_INTERRUPT_NMIREQEN_PRWARN_Msk     (0x1UL)                   /*!< SCU_INTERRUPT NMIREQEN: PRWARN (Bitfield-Mask: 0x01)        */
#define SCU_INTERRUPT_NMIREQEN_PI_Pos         (1UL)                     /*!< SCU_INTERRUPT NMIREQEN: PI (Bit 1)                          */
#define SCU_INTERRUPT_NMIREQEN_PI_Msk         (0x2UL)                   /*!< SCU_INTERRUPT NMIREQEN: PI (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_NMIREQEN_AI_Pos         (2UL)                     /*!< SCU_INTERRUPT NMIREQEN: AI (Bit 2)                          */
#define SCU_INTERRUPT_NMIREQEN_AI_Msk         (0x4UL)                   /*!< SCU_INTERRUPT NMIREQEN: AI (Bitfield-Mask: 0x01)            */
#define SCU_INTERRUPT_NMIREQEN_ERU00_Pos      (16UL)                    /*!< SCU_INTERRUPT NMIREQEN: ERU00 (Bit 16)                      */
#define SCU_INTERRUPT_NMIREQEN_ERU00_Msk      (0x10000UL)               /*!< SCU_INTERRUPT NMIREQEN: ERU00 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_NMIREQEN_ERU01_Pos      (17UL)                    /*!< SCU_INTERRUPT NMIREQEN: ERU01 (Bit 17)                      */
#define SCU_INTERRUPT_NMIREQEN_ERU01_Msk      (0x20000UL)               /*!< SCU_INTERRUPT NMIREQEN: ERU01 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_NMIREQEN_ERU02_Pos      (18UL)                    /*!< SCU_INTERRUPT NMIREQEN: ERU02 (Bit 18)                      */
#define SCU_INTERRUPT_NMIREQEN_ERU02_Msk      (0x40000UL)               /*!< SCU_INTERRUPT NMIREQEN: ERU02 (Bitfield-Mask: 0x01)         */
#define SCU_INTERRUPT_NMIREQEN_ERU03_Pos      (19UL)                    /*!< SCU_INTERRUPT NMIREQEN: ERU03 (Bit 19)                      */
#define SCU_INTERRUPT_NMIREQEN_ERU03_Msk      (0x80000UL)               /*!< SCU_INTERRUPT NMIREQEN: ERU03 (Bitfield-Mask: 0x01)         */


/* ================================================================================ */
/* ================       struct 'SCU_PARITY' Position & Mask      ================ */
/* ================================================================================ */


/* -------------------------------  SCU_PARITY_PEEN  ------------------------------ */
#define SCU_PARITY_PEEN_PEENPS_Pos            (0UL)                     /*!< SCU_PARITY PEEN: PEENPS (Bit 0)                             */
#define SCU_PARITY_PEEN_PEENPS_Msk            (0x1UL)                   /*!< SCU_PARITY PEEN: PEENPS (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PEEN_PEENDS1_Pos           (1UL)                     /*!< SCU_PARITY PEEN: PEENDS1 (Bit 1)                            */
#define SCU_PARITY_PEEN_PEENDS1_Msk           (0x2UL)                   /*!< SCU_PARITY PEEN: PEENDS1 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEEN_PEENDS2_Pos           (2UL)                     /*!< SCU_PARITY PEEN: PEENDS2 (Bit 2)                            */
#define SCU_PARITY_PEEN_PEENDS2_Msk           (0x4UL)                   /*!< SCU_PARITY PEEN: PEENDS2 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEEN_PEENU0_Pos            (8UL)                     /*!< SCU_PARITY PEEN: PEENU0 (Bit 8)                             */
#define SCU_PARITY_PEEN_PEENU0_Msk            (0x100UL)                 /*!< SCU_PARITY PEEN: PEENU0 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PEEN_PEENU1_Pos            (9UL)                     /*!< SCU_PARITY PEEN: PEENU1 (Bit 9)                             */
#define SCU_PARITY_PEEN_PEENU1_Msk            (0x200UL)                 /*!< SCU_PARITY PEEN: PEENU1 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PEEN_PEENMC_Pos            (12UL)                    /*!< SCU_PARITY PEEN: PEENMC (Bit 12)                            */
#define SCU_PARITY_PEEN_PEENMC_Msk            (0x1000UL)                /*!< SCU_PARITY PEEN: PEENMC (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PEEN_PEENPPRF_Pos          (13UL)                    /*!< SCU_PARITY PEEN: PEENPPRF (Bit 13)                          */
#define SCU_PARITY_PEEN_PEENPPRF_Msk          (0x2000UL)                /*!< SCU_PARITY PEEN: PEENPPRF (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_PEEN_PEENUSB_Pos           (16UL)                    /*!< SCU_PARITY PEEN: PEENUSB (Bit 16)                           */
#define SCU_PARITY_PEEN_PEENUSB_Msk           (0x10000UL)               /*!< SCU_PARITY PEEN: PEENUSB (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEEN_PEENETH0TX_Pos        (17UL)                    /*!< SCU_PARITY PEEN: PEENETH0TX (Bit 17)                        */
#define SCU_PARITY_PEEN_PEENETH0TX_Msk        (0x20000UL)               /*!< SCU_PARITY PEEN: PEENETH0TX (Bitfield-Mask: 0x01)           */
#define SCU_PARITY_PEEN_PEENETH0RX_Pos        (18UL)                    /*!< SCU_PARITY PEEN: PEENETH0RX (Bit 18)                        */
#define SCU_PARITY_PEEN_PEENETH0RX_Msk        (0x40000UL)               /*!< SCU_PARITY PEEN: PEENETH0RX (Bitfield-Mask: 0x01)           */

/* -----------------------------  SCU_PARITY_MCHKCON  ----------------------------- */
#define SCU_PARITY_MCHKCON_SELPS_Pos          (0UL)                     /*!< SCU_PARITY MCHKCON: SELPS (Bit 0)                           */
#define SCU_PARITY_MCHKCON_SELPS_Msk          (0x1UL)                   /*!< SCU_PARITY MCHKCON: SELPS (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_MCHKCON_SELDS1_Pos         (1UL)                     /*!< SCU_PARITY MCHKCON: SELDS1 (Bit 1)                          */
#define SCU_PARITY_MCHKCON_SELDS1_Msk         (0x2UL)                   /*!< SCU_PARITY MCHKCON: SELDS1 (Bitfield-Mask: 0x01)            */
#define SCU_PARITY_MCHKCON_SELDS2_Pos         (2UL)                     /*!< SCU_PARITY MCHKCON: SELDS2 (Bit 2)                          */
#define SCU_PARITY_MCHKCON_SELDS2_Msk         (0x4UL)                   /*!< SCU_PARITY MCHKCON: SELDS2 (Bitfield-Mask: 0x01)            */
#define SCU_PARITY_MCHKCON_USIC0DRA_Pos       (8UL)                     /*!< SCU_PARITY MCHKCON: USIC0DRA (Bit 8)                        */
#define SCU_PARITY_MCHKCON_USIC0DRA_Msk       (0x100UL)                 /*!< SCU_PARITY MCHKCON: USIC0DRA (Bitfield-Mask: 0x01)          */
#define SCU_PARITY_MCHKCON_USIC1DRA_Pos       (9UL)                     /*!< SCU_PARITY MCHKCON: USIC1DRA (Bit 9)                        */
#define SCU_PARITY_MCHKCON_USIC1DRA_Msk       (0x200UL)                 /*!< SCU_PARITY MCHKCON: USIC1DRA (Bitfield-Mask: 0x01)          */
#define SCU_PARITY_MCHKCON_MCANDRA_Pos        (12UL)                    /*!< SCU_PARITY MCHKCON: MCANDRA (Bit 12)                        */
#define SCU_PARITY_MCHKCON_MCANDRA_Msk        (0x1000UL)                /*!< SCU_PARITY MCHKCON: MCANDRA (Bitfield-Mask: 0x01)           */
#define SCU_PARITY_MCHKCON_PPRFDRA_Pos        (13UL)                    /*!< SCU_PARITY MCHKCON: PPRFDRA (Bit 13)                        */
#define SCU_PARITY_MCHKCON_PPRFDRA_Msk        (0x2000UL)                /*!< SCU_PARITY MCHKCON: PPRFDRA (Bitfield-Mask: 0x01)           */
#define SCU_PARITY_MCHKCON_SELUSB_Pos         (16UL)                    /*!< SCU_PARITY MCHKCON: SELUSB (Bit 16)                         */
#define SCU_PARITY_MCHKCON_SELUSB_Msk         (0x10000UL)               /*!< SCU_PARITY MCHKCON: SELUSB (Bitfield-Mask: 0x01)            */
#define SCU_PARITY_MCHKCON_SELETH0TX_Pos      (17UL)                    /*!< SCU_PARITY MCHKCON: SELETH0TX (Bit 17)                      */
#define SCU_PARITY_MCHKCON_SELETH0TX_Msk      (0x20000UL)               /*!< SCU_PARITY MCHKCON: SELETH0TX (Bitfield-Mask: 0x01)         */
#define SCU_PARITY_MCHKCON_SELETH0RX_Pos      (18UL)                    /*!< SCU_PARITY MCHKCON: SELETH0RX (Bit 18)                      */
#define SCU_PARITY_MCHKCON_SELETH0RX_Msk      (0x40000UL)               /*!< SCU_PARITY MCHKCON: SELETH0RX (Bitfield-Mask: 0x01)         */

/* -------------------------------  SCU_PARITY_PETE  ------------------------------ */
#define SCU_PARITY_PETE_PETEPS_Pos            (0UL)                     /*!< SCU_PARITY PETE: PETEPS (Bit 0)                             */
#define SCU_PARITY_PETE_PETEPS_Msk            (0x1UL)                   /*!< SCU_PARITY PETE: PETEPS (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PETE_PETEDS1_Pos           (1UL)                     /*!< SCU_PARITY PETE: PETEDS1 (Bit 1)                            */
#define SCU_PARITY_PETE_PETEDS1_Msk           (0x2UL)                   /*!< SCU_PARITY PETE: PETEDS1 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PETE_PETEDS2_Pos           (2UL)                     /*!< SCU_PARITY PETE: PETEDS2 (Bit 2)                            */
#define SCU_PARITY_PETE_PETEDS2_Msk           (0x4UL)                   /*!< SCU_PARITY PETE: PETEDS2 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PETE_PETEU0_Pos            (8UL)                     /*!< SCU_PARITY PETE: PETEU0 (Bit 8)                             */
#define SCU_PARITY_PETE_PETEU0_Msk            (0x100UL)                 /*!< SCU_PARITY PETE: PETEU0 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PETE_PETEU1_Pos            (9UL)                     /*!< SCU_PARITY PETE: PETEU1 (Bit 9)                             */
#define SCU_PARITY_PETE_PETEU1_Msk            (0x200UL)                 /*!< SCU_PARITY PETE: PETEU1 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PETE_PETEMC_Pos            (12UL)                    /*!< SCU_PARITY PETE: PETEMC (Bit 12)                            */
#define SCU_PARITY_PETE_PETEMC_Msk            (0x1000UL)                /*!< SCU_PARITY PETE: PETEMC (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PETE_PETEPPRF_Pos          (13UL)                    /*!< SCU_PARITY PETE: PETEPPRF (Bit 13)                          */
#define SCU_PARITY_PETE_PETEPPRF_Msk          (0x2000UL)                /*!< SCU_PARITY PETE: PETEPPRF (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_PETE_PETEUSB_Pos           (16UL)                    /*!< SCU_PARITY PETE: PETEUSB (Bit 16)                           */
#define SCU_PARITY_PETE_PETEUSB_Msk           (0x10000UL)               /*!< SCU_PARITY PETE: PETEUSB (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PETE_PETEETH0TX_Pos        (17UL)                    /*!< SCU_PARITY PETE: PETEETH0TX (Bit 17)                        */
#define SCU_PARITY_PETE_PETEETH0TX_Msk        (0x20000UL)               /*!< SCU_PARITY PETE: PETEETH0TX (Bitfield-Mask: 0x01)           */
#define SCU_PARITY_PETE_PETEETH0RX_Pos        (18UL)                    /*!< SCU_PARITY PETE: PETEETH0RX (Bit 18)                        */
#define SCU_PARITY_PETE_PETEETH0RX_Msk        (0x40000UL)               /*!< SCU_PARITY PETE: PETEETH0RX (Bitfield-Mask: 0x01)           */

/* -----------------------------  SCU_PARITY_PERSTEN  ----------------------------- */
#define SCU_PARITY_PERSTEN_RSEN_Pos           (0UL)                     /*!< SCU_PARITY PERSTEN: RSEN (Bit 0)                            */
#define SCU_PARITY_PERSTEN_RSEN_Msk           (0x1UL)                   /*!< SCU_PARITY PERSTEN: RSEN (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_PARITY_PEFLAG  ----------------------------- */
#define SCU_PARITY_PEFLAG_PEFPS_Pos           (0UL)                     /*!< SCU_PARITY PEFLAG: PEFPS (Bit 0)                            */
#define SCU_PARITY_PEFLAG_PEFPS_Msk           (0x1UL)                   /*!< SCU_PARITY PEFLAG: PEFPS (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEFLAG_PEFDS1_Pos          (1UL)                     /*!< SCU_PARITY PEFLAG: PEFDS1 (Bit 1)                           */
#define SCU_PARITY_PEFLAG_PEFDS1_Msk          (0x2UL)                   /*!< SCU_PARITY PEFLAG: PEFDS1 (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_PEFLAG_PEFDS2_Pos          (2UL)                     /*!< SCU_PARITY PEFLAG: PEFDS2 (Bit 2)                           */
#define SCU_PARITY_PEFLAG_PEFDS2_Msk          (0x4UL)                   /*!< SCU_PARITY PEFLAG: PEFDS2 (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_PEFLAG_PEFU0_Pos           (8UL)                     /*!< SCU_PARITY PEFLAG: PEFU0 (Bit 8)                            */
#define SCU_PARITY_PEFLAG_PEFU0_Msk           (0x100UL)                 /*!< SCU_PARITY PEFLAG: PEFU0 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEFLAG_PEFU1_Pos           (9UL)                     /*!< SCU_PARITY PEFLAG: PEFU1 (Bit 9)                            */
#define SCU_PARITY_PEFLAG_PEFU1_Msk           (0x200UL)                 /*!< SCU_PARITY PEFLAG: PEFU1 (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEFLAG_PEFMC_Pos           (12UL)                    /*!< SCU_PARITY PEFLAG: PEFMC (Bit 12)                           */
#define SCU_PARITY_PEFLAG_PEFMC_Msk           (0x1000UL)                /*!< SCU_PARITY PEFLAG: PEFMC (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEFLAG_PEFPPRF_Pos         (13UL)                    /*!< SCU_PARITY PEFLAG: PEFPPRF (Bit 13)                         */
#define SCU_PARITY_PEFLAG_PEFPPRF_Msk         (0x2000UL)                /*!< SCU_PARITY PEFLAG: PEFPPRF (Bitfield-Mask: 0x01)            */
#define SCU_PARITY_PEFLAG_PEUSB_Pos           (16UL)                    /*!< SCU_PARITY PEFLAG: PEUSB (Bit 16)                           */
#define SCU_PARITY_PEFLAG_PEUSB_Msk           (0x10000UL)               /*!< SCU_PARITY PEFLAG: PEUSB (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PEFLAG_PEETH0TX_Pos        (17UL)                    /*!< SCU_PARITY PEFLAG: PEETH0TX (Bit 17)                        */
#define SCU_PARITY_PEFLAG_PEETH0TX_Msk        (0x20000UL)               /*!< SCU_PARITY PEFLAG: PEETH0TX (Bitfield-Mask: 0x01)           */
#define SCU_PARITY_PEFLAG_PEETH0RX_Pos        (18UL)                    /*!< SCU_PARITY PEFLAG: PEETH0RX (Bit 18)                        */
#define SCU_PARITY_PEFLAG_PEETH0RX_Msk        (0x40000UL)               /*!< SCU_PARITY PEFLAG: PEETH0RX (Bitfield-Mask: 0x01)           */

/* ------------------------------  SCU_PARITY_PMTPR  ------------------------------ */
#define SCU_PARITY_PMTPR_PWR_Pos              (0UL)                     /*!< SCU_PARITY PMTPR: PWR (Bit 0)                               */
#define SCU_PARITY_PMTPR_PWR_Msk              (0xffUL)                  /*!< SCU_PARITY PMTPR: PWR (Bitfield-Mask: 0xff)                 */
#define SCU_PARITY_PMTPR_PRD_Pos              (8UL)                     /*!< SCU_PARITY PMTPR: PRD (Bit 8)                               */
#define SCU_PARITY_PMTPR_PRD_Msk              (0xff00UL)                /*!< SCU_PARITY PMTPR: PRD (Bitfield-Mask: 0xff)                 */

/* ------------------------------  SCU_PARITY_PMTSR  ------------------------------ */
#define SCU_PARITY_PMTSR_MTENPS_Pos           (0UL)                     /*!< SCU_PARITY PMTSR: MTENPS (Bit 0)                            */
#define SCU_PARITY_PMTSR_MTENPS_Msk           (0x1UL)                   /*!< SCU_PARITY PMTSR: MTENPS (Bitfield-Mask: 0x01)              */
#define SCU_PARITY_PMTSR_MTENDS1_Pos          (1UL)                     /*!< SCU_PARITY PMTSR: MTENDS1 (Bit 1)                           */
#define SCU_PARITY_PMTSR_MTENDS1_Msk          (0x2UL)                   /*!< SCU_PARITY PMTSR: MTENDS1 (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_PMTSR_MTENDS2_Pos          (2UL)                     /*!< SCU_PARITY PMTSR: MTENDS2 (Bit 2)                           */
#define SCU_PARITY_PMTSR_MTENDS2_Msk          (0x4UL)                   /*!< SCU_PARITY PMTSR: MTENDS2 (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_PMTSR_MTEU0_Pos            (8UL)                     /*!< SCU_PARITY PMTSR: MTEU0 (Bit 8)                             */
#define SCU_PARITY_PMTSR_MTEU0_Msk            (0x100UL)                 /*!< SCU_PARITY PMTSR: MTEU0 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PMTSR_MTEU1_Pos            (9UL)                     /*!< SCU_PARITY PMTSR: MTEU1 (Bit 9)                             */
#define SCU_PARITY_PMTSR_MTEU1_Msk            (0x200UL)                 /*!< SCU_PARITY PMTSR: MTEU1 (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PMTSR_MTEMC_Pos            (12UL)                    /*!< SCU_PARITY PMTSR: MTEMC (Bit 12)                            */
#define SCU_PARITY_PMTSR_MTEMC_Msk            (0x1000UL)                /*!< SCU_PARITY PMTSR: MTEMC (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PMTSR_MTEPPRF_Pos          (13UL)                    /*!< SCU_PARITY PMTSR: MTEPPRF (Bit 13)                          */
#define SCU_PARITY_PMTSR_MTEPPRF_Msk          (0x2000UL)                /*!< SCU_PARITY PMTSR: MTEPPRF (Bitfield-Mask: 0x01)             */
#define SCU_PARITY_PMTSR_MTUSB_Pos            (16UL)                    /*!< SCU_PARITY PMTSR: MTUSB (Bit 16)                            */
#define SCU_PARITY_PMTSR_MTUSB_Msk            (0x10000UL)               /*!< SCU_PARITY PMTSR: MTUSB (Bitfield-Mask: 0x01)               */
#define SCU_PARITY_PMTSR_MTETH0TX_Pos         (17UL)                    /*!< SCU_PARITY PMTSR: MTETH0TX (Bit 17)                         */
#define SCU_PARITY_PMTSR_MTETH0TX_Msk         (0x20000UL)               /*!< SCU_PARITY PMTSR: MTETH0TX (Bitfield-Mask: 0x01)            */
#define SCU_PARITY_PMTSR_MTETH0RX_Pos         (18UL)                    /*!< SCU_PARITY PMTSR: MTETH0RX (Bit 18)                         */
#define SCU_PARITY_PMTSR_MTETH0RX_Msk         (0x40000UL)               /*!< SCU_PARITY PMTSR: MTETH0RX (Bitfield-Mask: 0x01)            */


/* ================================================================================ */
/* ================        struct 'SCU_TRAP' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  SCU_TRAP_TRAPSTAT  ----------------------------- */
#define SCU_TRAP_TRAPSTAT_SOSCWDGT_Pos        (0UL)                     /*!< SCU_TRAP TRAPSTAT: SOSCWDGT (Bit 0)                         */
#define SCU_TRAP_TRAPSTAT_SOSCWDGT_Msk        (0x1UL)                   /*!< SCU_TRAP TRAPSTAT: SOSCWDGT (Bitfield-Mask: 0x01)           */
#define SCU_TRAP_TRAPSTAT_SVCOLCKT_Pos        (2UL)                     /*!< SCU_TRAP TRAPSTAT: SVCOLCKT (Bit 2)                         */
#define SCU_TRAP_TRAPSTAT_SVCOLCKT_Msk        (0x4UL)                   /*!< SCU_TRAP TRAPSTAT: SVCOLCKT (Bitfield-Mask: 0x01)           */
#define SCU_TRAP_TRAPSTAT_UVCOLCKT_Pos        (3UL)                     /*!< SCU_TRAP TRAPSTAT: UVCOLCKT (Bit 3)                         */
#define SCU_TRAP_TRAPSTAT_UVCOLCKT_Msk        (0x8UL)                   /*!< SCU_TRAP TRAPSTAT: UVCOLCKT (Bitfield-Mask: 0x01)           */
#define SCU_TRAP_TRAPSTAT_PET_Pos             (4UL)                     /*!< SCU_TRAP TRAPSTAT: PET (Bit 4)                              */
#define SCU_TRAP_TRAPSTAT_PET_Msk             (0x10UL)                  /*!< SCU_TRAP TRAPSTAT: PET (Bitfield-Mask: 0x01)                */
#define SCU_TRAP_TRAPSTAT_BRWNT_Pos           (5UL)                     /*!< SCU_TRAP TRAPSTAT: BRWNT (Bit 5)                            */
#define SCU_TRAP_TRAPSTAT_BRWNT_Msk           (0x20UL)                  /*!< SCU_TRAP TRAPSTAT: BRWNT (Bitfield-Mask: 0x01)              */
#define SCU_TRAP_TRAPSTAT_ULPWDGT_Pos         (6UL)                     /*!< SCU_TRAP TRAPSTAT: ULPWDGT (Bit 6)                          */
#define SCU_TRAP_TRAPSTAT_ULPWDGT_Msk         (0x40UL)                  /*!< SCU_TRAP TRAPSTAT: ULPWDGT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPSTAT_BWERR0T_Pos         (7UL)                     /*!< SCU_TRAP TRAPSTAT: BWERR0T (Bit 7)                          */
#define SCU_TRAP_TRAPSTAT_BWERR0T_Msk         (0x80UL)                  /*!< SCU_TRAP TRAPSTAT: BWERR0T (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPSTAT_BWERR1T_Pos         (8UL)                     /*!< SCU_TRAP TRAPSTAT: BWERR1T (Bit 8)                          */
#define SCU_TRAP_TRAPSTAT_BWERR1T_Msk         (0x100UL)                 /*!< SCU_TRAP TRAPSTAT: BWERR1T (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPSTAT_TEMPHIT_Pos         (12UL)                    /*!< SCU_TRAP TRAPSTAT: TEMPHIT (Bit 12)                         */
#define SCU_TRAP_TRAPSTAT_TEMPHIT_Msk         (0x1000UL)                /*!< SCU_TRAP TRAPSTAT: TEMPHIT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPSTAT_TEMPLOT_Pos         (13UL)                    /*!< SCU_TRAP TRAPSTAT: TEMPLOT (Bit 13)                         */
#define SCU_TRAP_TRAPSTAT_TEMPLOT_Msk         (0x2000UL)                /*!< SCU_TRAP TRAPSTAT: TEMPLOT (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_TRAP_TRAPRAW  ------------------------------ */
#define SCU_TRAP_TRAPRAW_SOSCWDGT_Pos         (0UL)                     /*!< SCU_TRAP TRAPRAW: SOSCWDGT (Bit 0)                          */
#define SCU_TRAP_TRAPRAW_SOSCWDGT_Msk         (0x1UL)                   /*!< SCU_TRAP TRAPRAW: SOSCWDGT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPRAW_SVCOLCKT_Pos         (2UL)                     /*!< SCU_TRAP TRAPRAW: SVCOLCKT (Bit 2)                          */
#define SCU_TRAP_TRAPRAW_SVCOLCKT_Msk         (0x4UL)                   /*!< SCU_TRAP TRAPRAW: SVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPRAW_UVCOLCKT_Pos         (3UL)                     /*!< SCU_TRAP TRAPRAW: UVCOLCKT (Bit 3)                          */
#define SCU_TRAP_TRAPRAW_UVCOLCKT_Msk         (0x8UL)                   /*!< SCU_TRAP TRAPRAW: UVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPRAW_PET_Pos              (4UL)                     /*!< SCU_TRAP TRAPRAW: PET (Bit 4)                               */
#define SCU_TRAP_TRAPRAW_PET_Msk              (0x10UL)                  /*!< SCU_TRAP TRAPRAW: PET (Bitfield-Mask: 0x01)                 */
#define SCU_TRAP_TRAPRAW_BRWNT_Pos            (5UL)                     /*!< SCU_TRAP TRAPRAW: BRWNT (Bit 5)                             */
#define SCU_TRAP_TRAPRAW_BRWNT_Msk            (0x20UL)                  /*!< SCU_TRAP TRAPRAW: BRWNT (Bitfield-Mask: 0x01)               */
#define SCU_TRAP_TRAPRAW_ULPWDGT_Pos          (6UL)                     /*!< SCU_TRAP TRAPRAW: ULPWDGT (Bit 6)                           */
#define SCU_TRAP_TRAPRAW_ULPWDGT_Msk          (0x40UL)                  /*!< SCU_TRAP TRAPRAW: ULPWDGT (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPRAW_BWERR0T_Pos          (7UL)                     /*!< SCU_TRAP TRAPRAW: BWERR0T (Bit 7)                           */
#define SCU_TRAP_TRAPRAW_BWERR0T_Msk          (0x80UL)                  /*!< SCU_TRAP TRAPRAW: BWERR0T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPRAW_BWERR1T_Pos          (8UL)                     /*!< SCU_TRAP TRAPRAW: BWERR1T (Bit 8)                           */
#define SCU_TRAP_TRAPRAW_BWERR1T_Msk          (0x100UL)                 /*!< SCU_TRAP TRAPRAW: BWERR1T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPRAW_TEMPHIT_Pos          (12UL)                    /*!< SCU_TRAP TRAPRAW: TEMPHIT (Bit 12)                          */
#define SCU_TRAP_TRAPRAW_TEMPHIT_Msk          (0x1000UL)                /*!< SCU_TRAP TRAPRAW: TEMPHIT (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPRAW_TEMPLOT_Pos          (13UL)                    /*!< SCU_TRAP TRAPRAW: TEMPLOT (Bit 13)                          */
#define SCU_TRAP_TRAPRAW_TEMPLOT_Msk          (0x2000UL)                /*!< SCU_TRAP TRAPRAW: TEMPLOT (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_TRAP_TRAPDIS  ------------------------------ */
#define SCU_TRAP_TRAPDIS_SOSCWDGT_Pos         (0UL)                     /*!< SCU_TRAP TRAPDIS: SOSCWDGT (Bit 0)                          */
#define SCU_TRAP_TRAPDIS_SOSCWDGT_Msk         (0x1UL)                   /*!< SCU_TRAP TRAPDIS: SOSCWDGT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPDIS_SVCOLCKT_Pos         (2UL)                     /*!< SCU_TRAP TRAPDIS: SVCOLCKT (Bit 2)                          */
#define SCU_TRAP_TRAPDIS_SVCOLCKT_Msk         (0x4UL)                   /*!< SCU_TRAP TRAPDIS: SVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPDIS_UVCOLCKT_Pos         (3UL)                     /*!< SCU_TRAP TRAPDIS: UVCOLCKT (Bit 3)                          */
#define SCU_TRAP_TRAPDIS_UVCOLCKT_Msk         (0x8UL)                   /*!< SCU_TRAP TRAPDIS: UVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPDIS_PET_Pos              (4UL)                     /*!< SCU_TRAP TRAPDIS: PET (Bit 4)                               */
#define SCU_TRAP_TRAPDIS_PET_Msk              (0x10UL)                  /*!< SCU_TRAP TRAPDIS: PET (Bitfield-Mask: 0x01)                 */
#define SCU_TRAP_TRAPDIS_BRWNT_Pos            (5UL)                     /*!< SCU_TRAP TRAPDIS: BRWNT (Bit 5)                             */
#define SCU_TRAP_TRAPDIS_BRWNT_Msk            (0x20UL)                  /*!< SCU_TRAP TRAPDIS: BRWNT (Bitfield-Mask: 0x01)               */
#define SCU_TRAP_TRAPDIS_ULPWDGT_Pos          (6UL)                     /*!< SCU_TRAP TRAPDIS: ULPWDGT (Bit 6)                           */
#define SCU_TRAP_TRAPDIS_ULPWDGT_Msk          (0x40UL)                  /*!< SCU_TRAP TRAPDIS: ULPWDGT (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPDIS_BWERR0T_Pos          (7UL)                     /*!< SCU_TRAP TRAPDIS: BWERR0T (Bit 7)                           */
#define SCU_TRAP_TRAPDIS_BWERR0T_Msk          (0x80UL)                  /*!< SCU_TRAP TRAPDIS: BWERR0T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPDIS_BWERR1T_Pos          (8UL)                     /*!< SCU_TRAP TRAPDIS: BWERR1T (Bit 8)                           */
#define SCU_TRAP_TRAPDIS_BWERR1T_Msk          (0x100UL)                 /*!< SCU_TRAP TRAPDIS: BWERR1T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPDIS_TEMPHIT_Pos          (12UL)                    /*!< SCU_TRAP TRAPDIS: TEMPHIT (Bit 12)                          */
#define SCU_TRAP_TRAPDIS_TEMPHIT_Msk          (0x1000UL)                /*!< SCU_TRAP TRAPDIS: TEMPHIT (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPDIS_TEMPLOT_Pos          (13UL)                    /*!< SCU_TRAP TRAPDIS: TEMPLOT (Bit 13)                          */
#define SCU_TRAP_TRAPDIS_TEMPLOT_Msk          (0x2000UL)                /*!< SCU_TRAP TRAPDIS: TEMPLOT (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_TRAP_TRAPCLR  ------------------------------ */
#define SCU_TRAP_TRAPCLR_SOSCWDGT_Pos         (0UL)                     /*!< SCU_TRAP TRAPCLR: SOSCWDGT (Bit 0)                          */
#define SCU_TRAP_TRAPCLR_SOSCWDGT_Msk         (0x1UL)                   /*!< SCU_TRAP TRAPCLR: SOSCWDGT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPCLR_SVCOLCKT_Pos         (2UL)                     /*!< SCU_TRAP TRAPCLR: SVCOLCKT (Bit 2)                          */
#define SCU_TRAP_TRAPCLR_SVCOLCKT_Msk         (0x4UL)                   /*!< SCU_TRAP TRAPCLR: SVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPCLR_UVCOLCKT_Pos         (3UL)                     /*!< SCU_TRAP TRAPCLR: UVCOLCKT (Bit 3)                          */
#define SCU_TRAP_TRAPCLR_UVCOLCKT_Msk         (0x8UL)                   /*!< SCU_TRAP TRAPCLR: UVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPCLR_PET_Pos              (4UL)                     /*!< SCU_TRAP TRAPCLR: PET (Bit 4)                               */
#define SCU_TRAP_TRAPCLR_PET_Msk              (0x10UL)                  /*!< SCU_TRAP TRAPCLR: PET (Bitfield-Mask: 0x01)                 */
#define SCU_TRAP_TRAPCLR_BRWNT_Pos            (5UL)                     /*!< SCU_TRAP TRAPCLR: BRWNT (Bit 5)                             */
#define SCU_TRAP_TRAPCLR_BRWNT_Msk            (0x20UL)                  /*!< SCU_TRAP TRAPCLR: BRWNT (Bitfield-Mask: 0x01)               */
#define SCU_TRAP_TRAPCLR_ULPWDGT_Pos          (6UL)                     /*!< SCU_TRAP TRAPCLR: ULPWDGT (Bit 6)                           */
#define SCU_TRAP_TRAPCLR_ULPWDGT_Msk          (0x40UL)                  /*!< SCU_TRAP TRAPCLR: ULPWDGT (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPCLR_BWERR0T_Pos          (7UL)                     /*!< SCU_TRAP TRAPCLR: BWERR0T (Bit 7)                           */
#define SCU_TRAP_TRAPCLR_BWERR0T_Msk          (0x80UL)                  /*!< SCU_TRAP TRAPCLR: BWERR0T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPCLR_BWERR1T_Pos          (8UL)                     /*!< SCU_TRAP TRAPCLR: BWERR1T (Bit 8)                           */
#define SCU_TRAP_TRAPCLR_BWERR1T_Msk          (0x100UL)                 /*!< SCU_TRAP TRAPCLR: BWERR1T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPCLR_TEMPHIT_Pos          (12UL)                    /*!< SCU_TRAP TRAPCLR: TEMPHIT (Bit 12)                          */
#define SCU_TRAP_TRAPCLR_TEMPHIT_Msk          (0x1000UL)                /*!< SCU_TRAP TRAPCLR: TEMPHIT (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPCLR_TEMPLOT_Pos          (13UL)                    /*!< SCU_TRAP TRAPCLR: TEMPLOT (Bit 13)                          */
#define SCU_TRAP_TRAPCLR_TEMPLOT_Msk          (0x2000UL)                /*!< SCU_TRAP TRAPCLR: TEMPLOT (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_TRAP_TRAPSET  ------------------------------ */
#define SCU_TRAP_TRAPSET_SOSCWDGT_Pos         (0UL)                     /*!< SCU_TRAP TRAPSET: SOSCWDGT (Bit 0)                          */
#define SCU_TRAP_TRAPSET_SOSCWDGT_Msk         (0x1UL)                   /*!< SCU_TRAP TRAPSET: SOSCWDGT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPSET_SVCOLCKT_Pos         (2UL)                     /*!< SCU_TRAP TRAPSET: SVCOLCKT (Bit 2)                          */
#define SCU_TRAP_TRAPSET_SVCOLCKT_Msk         (0x4UL)                   /*!< SCU_TRAP TRAPSET: SVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPSET_UVCOLCKT_Pos         (3UL)                     /*!< SCU_TRAP TRAPSET: UVCOLCKT (Bit 3)                          */
#define SCU_TRAP_TRAPSET_UVCOLCKT_Msk         (0x8UL)                   /*!< SCU_TRAP TRAPSET: UVCOLCKT (Bitfield-Mask: 0x01)            */
#define SCU_TRAP_TRAPSET_PET_Pos              (4UL)                     /*!< SCU_TRAP TRAPSET: PET (Bit 4)                               */
#define SCU_TRAP_TRAPSET_PET_Msk              (0x10UL)                  /*!< SCU_TRAP TRAPSET: PET (Bitfield-Mask: 0x01)                 */
#define SCU_TRAP_TRAPSET_BRWNT_Pos            (5UL)                     /*!< SCU_TRAP TRAPSET: BRWNT (Bit 5)                             */
#define SCU_TRAP_TRAPSET_BRWNT_Msk            (0x20UL)                  /*!< SCU_TRAP TRAPSET: BRWNT (Bitfield-Mask: 0x01)               */
#define SCU_TRAP_TRAPSET_ULPWDT_Pos           (6UL)                     /*!< SCU_TRAP TRAPSET: ULPWDT (Bit 6)                            */
#define SCU_TRAP_TRAPSET_ULPWDT_Msk           (0x40UL)                  /*!< SCU_TRAP TRAPSET: ULPWDT (Bitfield-Mask: 0x01)              */
#define SCU_TRAP_TRAPSET_BWERR0T_Pos          (7UL)                     /*!< SCU_TRAP TRAPSET: BWERR0T (Bit 7)                           */
#define SCU_TRAP_TRAPSET_BWERR0T_Msk          (0x80UL)                  /*!< SCU_TRAP TRAPSET: BWERR0T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPSET_BWERR1T_Pos          (8UL)                     /*!< SCU_TRAP TRAPSET: BWERR1T (Bit 8)                           */
#define SCU_TRAP_TRAPSET_BWERR1T_Msk          (0x100UL)                 /*!< SCU_TRAP TRAPSET: BWERR1T (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPSET_TEMPHIT_Pos          (12UL)                    /*!< SCU_TRAP TRAPSET: TEMPHIT (Bit 12)                          */
#define SCU_TRAP_TRAPSET_TEMPHIT_Msk          (0x1000UL)                /*!< SCU_TRAP TRAPSET: TEMPHIT (Bitfield-Mask: 0x01)             */
#define SCU_TRAP_TRAPSET_TEMPLOT_Pos          (13UL)                    /*!< SCU_TRAP TRAPSET: TEMPLOT (Bit 13)                          */
#define SCU_TRAP_TRAPSET_TEMPLOT_Msk          (0x2000UL)                /*!< SCU_TRAP TRAPSET: TEMPLOT (Bitfield-Mask: 0x01)             */


/* ================================================================================ */
/* ================     struct 'SCU_HIBERNATE' Position & Mask     ================ */
/* ================================================================================ */


/* ----------------------------  SCU_HIBERNATE_HDSTAT  ---------------------------- */
#define SCU_HIBERNATE_HDSTAT_EPEV_Pos         (0UL)                     /*!< SCU_HIBERNATE HDSTAT: EPEV (Bit 0)                          */
#define SCU_HIBERNATE_HDSTAT_EPEV_Msk         (0x1UL)                   /*!< SCU_HIBERNATE HDSTAT: EPEV (Bitfield-Mask: 0x01)            */
#define SCU_HIBERNATE_HDSTAT_ENEV_Pos         (1UL)                     /*!< SCU_HIBERNATE HDSTAT: ENEV (Bit 1)                          */
#define SCU_HIBERNATE_HDSTAT_ENEV_Msk         (0x2UL)                   /*!< SCU_HIBERNATE HDSTAT: ENEV (Bitfield-Mask: 0x01)            */
#define SCU_HIBERNATE_HDSTAT_RTCEV_Pos        (2UL)                     /*!< SCU_HIBERNATE HDSTAT: RTCEV (Bit 2)                         */
#define SCU_HIBERNATE_HDSTAT_RTCEV_Msk        (0x4UL)                   /*!< SCU_HIBERNATE HDSTAT: RTCEV (Bitfield-Mask: 0x01)           */
#define SCU_HIBERNATE_HDSTAT_ULPWDG_Pos       (3UL)                     /*!< SCU_HIBERNATE HDSTAT: ULPWDG (Bit 3)                        */
#define SCU_HIBERNATE_HDSTAT_ULPWDG_Msk       (0x8UL)                   /*!< SCU_HIBERNATE HDSTAT: ULPWDG (Bitfield-Mask: 0x01)          */
#define SCU_HIBERNATE_HDSTAT_HIBNOUT_Pos      (4UL)                     /*!< SCU_HIBERNATE HDSTAT: HIBNOUT (Bit 4)                       */
#define SCU_HIBERNATE_HDSTAT_HIBNOUT_Msk      (0x10UL)                  /*!< SCU_HIBERNATE HDSTAT: HIBNOUT (Bitfield-Mask: 0x01)         */
#define SCU_HIBERNATE_HDSTAT_VBATPEV_Pos      (8UL)                     /*!< SCU_HIBERNATE HDSTAT: VBATPEV (Bit 8)                       */
#define SCU_HIBERNATE_HDSTAT_VBATPEV_Msk      (0x100UL)                 /*!< SCU_HIBERNATE HDSTAT: VBATPEV (Bitfield-Mask: 0x01)         */
#define SCU_HIBERNATE_HDSTAT_VBATNEV_Pos      (9UL)                     /*!< SCU_HIBERNATE HDSTAT: VBATNEV (Bit 9)                       */
#define SCU_HIBERNATE_HDSTAT_VBATNEV_Msk      (0x200UL)                 /*!< SCU_HIBERNATE HDSTAT: VBATNEV (Bitfield-Mask: 0x01)         */
#define SCU_HIBERNATE_HDSTAT_AHIBIO0PEV_Pos   (10UL)                    /*!< SCU_HIBERNATE HDSTAT: AHIBIO0PEV (Bit 10)                   */
#define SCU_HIBERNATE_HDSTAT_AHIBIO0PEV_Msk   (0x400UL)                 /*!< SCU_HIBERNATE HDSTAT: AHIBIO0PEV (Bitfield-Mask: 0x01)      */
#define SCU_HIBERNATE_HDSTAT_AHIBIO0NEV_Pos   (11UL)                    /*!< SCU_HIBERNATE HDSTAT: AHIBIO0NEV (Bit 11)                   */
#define SCU_HIBERNATE_HDSTAT_AHIBIO0NEV_Msk   (0x800UL)                 /*!< SCU_HIBERNATE HDSTAT: AHIBIO0NEV (Bitfield-Mask: 0x01)      */
#define SCU_HIBERNATE_HDSTAT_AHIBIO1PEV_Pos   (12UL)                    /*!< SCU_HIBERNATE HDSTAT: AHIBIO1PEV (Bit 12)                   */
#define SCU_HIBERNATE_HDSTAT_AHIBIO1PEV_Msk   (0x1000UL)                /*!< SCU_HIBERNATE HDSTAT: AHIBIO1PEV (Bitfield-Mask: 0x01)      */
#define SCU_HIBERNATE_HDSTAT_AHIBIO1NEV_Pos   (13UL)                    /*!< SCU_HIBERNATE HDSTAT: AHIBIO1NEV (Bit 13)                   */
#define SCU_HIBERNATE_HDSTAT_AHIBIO1NEV_Msk   (0x2000UL)                /*!< SCU_HIBERNATE HDSTAT: AHIBIO1NEV (Bitfield-Mask: 0x01)      */

/* -----------------------------  SCU_HIBERNATE_HDCLR  ---------------------------- */
#define SCU_HIBERNATE_HDCLR_EPEV_Pos          (0UL)                     /*!< SCU_HIBERNATE HDCLR: EPEV (Bit 0)                           */
#define SCU_HIBERNATE_HDCLR_EPEV_Msk          (0x1UL)                   /*!< SCU_HIBERNATE HDCLR: EPEV (Bitfield-Mask: 0x01)             */
#define SCU_HIBERNATE_HDCLR_ENEV_Pos          (1UL)                     /*!< SCU_HIBERNATE HDCLR: ENEV (Bit 1)                           */
#define SCU_HIBERNATE_HDCLR_ENEV_Msk          (0x2UL)                   /*!< SCU_HIBERNATE HDCLR: ENEV (Bitfield-Mask: 0x01)             */
#define SCU_HIBERNATE_HDCLR_RTCEV_Pos         (2UL)                     /*!< SCU_HIBERNATE HDCLR: RTCEV (Bit 2)                          */
#define SCU_HIBERNATE_HDCLR_RTCEV_Msk         (0x4UL)                   /*!< SCU_HIBERNATE HDCLR: RTCEV (Bitfield-Mask: 0x01)            */
#define SCU_HIBERNATE_HDCLR_ULPWDG_Pos        (3UL)                     /*!< SCU_HIBERNATE HDCLR: ULPWDG (Bit 3)                         */
#define SCU_HIBERNATE_HDCLR_ULPWDG_Msk        (0x8UL)                   /*!< SCU_HIBERNATE HDCLR: ULPWDG (Bitfield-Mask: 0x01)           */
#define SCU_HIBERNATE_HDCLR_VBATPEV_Pos       (8UL)                     /*!< SCU_HIBERNATE HDCLR: VBATPEV (Bit 8)                        */
#define SCU_HIBERNATE_HDCLR_VBATPEV_Msk       (0x100UL)                 /*!< SCU_HIBERNATE HDCLR: VBATPEV (Bitfield-Mask: 0x01)          */
#define SCU_HIBERNATE_HDCLR_VBATNEV_Pos       (9UL)                     /*!< SCU_HIBERNATE HDCLR: VBATNEV (Bit 9)                        */
#define SCU_HIBERNATE_HDCLR_VBATNEV_Msk       (0x200UL)                 /*!< SCU_HIBERNATE HDCLR: VBATNEV (Bitfield-Mask: 0x01)          */
#define SCU_HIBERNATE_HDCLR_AHIBIO0PEV_Pos    (10UL)                    /*!< SCU_HIBERNATE HDCLR: AHIBIO0PEV (Bit 10)                    */
#define SCU_HIBERNATE_HDCLR_AHIBIO0PEV_Msk    (0x400UL)                 /*!< SCU_HIBERNATE HDCLR: AHIBIO0PEV (Bitfield-Mask: 0x01)       */
#define SCU_HIBERNATE_HDCLR_AHIBIO0NEV_Pos    (11UL)                    /*!< SCU_HIBERNATE HDCLR: AHIBIO0NEV (Bit 11)                    */
#define SCU_HIBERNATE_HDCLR_AHIBIO0NEV_Msk    (0x800UL)                 /*!< SCU_HIBERNATE HDCLR: AHIBIO0NEV (Bitfield-Mask: 0x01)       */
#define SCU_HIBERNATE_HDCLR_AHIBIO1PEV_Pos    (12UL)                    /*!< SCU_HIBERNATE HDCLR: AHIBIO1PEV (Bit 12)                    */
#define SCU_HIBERNATE_HDCLR_AHIBIO1PEV_Msk    (0x1000UL)                /*!< SCU_HIBERNATE HDCLR: AHIBIO1PEV (Bitfield-Mask: 0x01)       */
#define SCU_HIBERNATE_HDCLR_AHIBIO1NEV_Pos    (13UL)                    /*!< SCU_HIBERNATE HDCLR: AHIBIO1NEV (Bit 13)                    */
#define SCU_HIBERNATE_HDCLR_AHIBIO1NEV_Msk    (0x2000UL)                /*!< SCU_HIBERNATE HDCLR: AHIBIO1NEV (Bitfield-Mask: 0x01)       */

/* -----------------------------  SCU_HIBERNATE_HDSET  ---------------------------- */
#define SCU_HIBERNATE_HDSET_EPEV_Pos          (0UL)                     /*!< SCU_HIBERNATE HDSET: EPEV (Bit 0)                           */
#define SCU_HIBERNATE_HDSET_EPEV_Msk          (0x1UL)                   /*!< SCU_HIBERNATE HDSET: EPEV (Bitfield-Mask: 0x01)             */
#define SCU_HIBERNATE_HDSET_ENEV_Pos          (1UL)                     /*!< SCU_HIBERNATE HDSET: ENEV (Bit 1)                           */
#define SCU_HIBERNATE_HDSET_ENEV_Msk          (0x2UL)                   /*!< SCU_HIBERNATE HDSET: ENEV (Bitfield-Mask: 0x01)             */
#define SCU_HIBERNATE_HDSET_RTCEV_Pos         (2UL)                     /*!< SCU_HIBERNATE HDSET: RTCEV (Bit 2)                          */
#define SCU_HIBERNATE_HDSET_RTCEV_Msk         (0x4UL)                   /*!< SCU_HIBERNATE HDSET: RTCEV (Bitfield-Mask: 0x01)            */
#define SCU_HIBERNATE_HDSET_ULPWDG_Pos        (3UL)                     /*!< SCU_HIBERNATE HDSET: ULPWDG (Bit 3)                         */
#define SCU_HIBERNATE_HDSET_ULPWDG_Msk        (0x8UL)                   /*!< SCU_HIBERNATE HDSET: ULPWDG (Bitfield-Mask: 0x01)           */
#define SCU_HIBERNATE_HDSET_VBATPEV_Pos       (8UL)                     /*!< SCU_HIBERNATE HDSET: VBATPEV (Bit 8)                        */
#define SCU_HIBERNATE_HDSET_VBATPEV_Msk       (0x100UL)                 /*!< SCU_HIBERNATE HDSET: VBATPEV (Bitfield-Mask: 0x01)          */
#define SCU_HIBERNATE_HDSET_VBATNEV_Pos       (9UL)                     /*!< SCU_HIBERNATE HDSET: VBATNEV (Bit 9)                        */
#define SCU_HIBERNATE_HDSET_VBATNEV_Msk       (0x200UL)                 /*!< SCU_HIBERNATE HDSET: VBATNEV (Bitfield-Mask: 0x01)          */
#define SCU_HIBERNATE_HDSET_AHIBIO0PEV_Pos    (10UL)                    /*!< SCU_HIBERNATE HDSET: AHIBIO0PEV (Bit 10)                    */
#define SCU_HIBERNATE_HDSET_AHIBIO0PEV_Msk    (0x400UL)                 /*!< SCU_HIBERNATE HDSET: AHIBIO0PEV (Bitfield-Mask: 0x01)       */
#define SCU_HIBERNATE_HDSET_AHIBIO0NEV_Pos    (11UL)                    /*!< SCU_HIBERNATE HDSET: AHIBIO0NEV (Bit 11)                    */
#define SCU_HIBERNATE_HDSET_AHIBIO0NEV_Msk    (0x800UL)                 /*!< SCU_HIBERNATE HDSET: AHIBIO0NEV (Bitfield-Mask: 0x01)       */
#define SCU_HIBERNATE_HDSET_AHIBIO1PEV_Pos    (12UL)                    /*!< SCU_HIBERNATE HDSET: AHIBIO1PEV (Bit 12)                    */
#define SCU_HIBERNATE_HDSET_AHIBIO1PEV_Msk    (0x1000UL)                /*!< SCU_HIBERNATE HDSET: AHIBIO1PEV (Bitfield-Mask: 0x01)       */
#define SCU_HIBERNATE_HDSET_AHIBIO1NEV_Pos    (13UL)                    /*!< SCU_HIBERNATE HDSET: AHIBIO1NEV (Bit 13)                    */
#define SCU_HIBERNATE_HDSET_AHIBIO1NEV_Msk    (0x2000UL)                /*!< SCU_HIBERNATE HDSET: AHIBIO1NEV (Bitfield-Mask: 0x01)       */

/* -----------------------------  SCU_HIBERNATE_HDCR  ----------------------------- */
#define SCU_HIBERNATE_HDCR_WKPEP_Pos          (0UL)                     /*!< SCU_HIBERNATE HDCR: WKPEP (Bit 0)                           */
#define SCU_HIBERNATE_HDCR_WKPEP_Msk          (0x1UL)                   /*!< SCU_HIBERNATE HDCR: WKPEP (Bitfield-Mask: 0x01)             */
#define SCU_HIBERNATE_HDCR_WKPEN_Pos          (1UL)                     /*!< SCU_HIBERNATE HDCR: WKPEN (Bit 1)                           */
#define SCU_HIBERNATE_HDCR_WKPEN_Msk          (0x2UL)                   /*!< SCU_HIBERNATE HDCR: WKPEN (Bitfield-Mask: 0x01)             */
#define SCU_HIBERNATE_HDCR_RTCE_Pos           (2UL)                     /*!< SCU_HIBERNATE HDCR: RTCE (Bit 2)                            */
#define SCU_HIBERNATE_HDCR_RTCE_Msk           (0x4UL)                   /*!< SCU_HIBERNATE HDCR: RTCE (Bitfield-Mask: 0x01)              */
#define SCU_HIBERNATE_HDCR_ULPWDGEN_Pos       (3UL)                     /*!< SCU_HIBERNATE HDCR: ULPWDGEN (Bit 3)                        */
#define SCU_HIBERNATE_HDCR_ULPWDGEN_Msk       (0x8UL)                   /*!< SCU_HIBERNATE HDCR: ULPWDGEN (Bitfield-Mask: 0x01)          */
#define SCU_HIBERNATE_HDCR_HIB_Pos            (4UL)                     /*!< SCU_HIBERNATE HDCR: HIB (Bit 4)                             */
#define SCU_HIBERNATE_HDCR_HIB_Msk            (0x10UL)                  /*!< SCU_HIBERNATE HDCR: HIB (Bitfield-Mask: 0x01)               */
#define SCU_HIBERNATE_HDCR_XTALGPI1SEL_Pos    (5UL)                     /*!< SCU_HIBERNATE HDCR: XTALGPI1SEL (Bit 5)                     */
#define SCU_HIBERNATE_HDCR_XTALGPI1SEL_Msk    (0x20UL)                  /*!< SCU_HIBERNATE HDCR: XTALGPI1SEL (Bitfield-Mask: 0x01)       */
#define SCU_HIBERNATE_HDCR_RCS_Pos            (6UL)                     /*!< SCU_HIBERNATE HDCR: RCS (Bit 6)                             */
#define SCU_HIBERNATE_HDCR_RCS_Msk            (0x40UL)                  /*!< SCU_HIBERNATE HDCR: RCS (Bitfield-Mask: 0x01)               */
#define SCU_HIBERNATE_HDCR_STDBYSEL_Pos       (7UL)                     /*!< SCU_HIBERNATE HDCR: STDBYSEL (Bit 7)                        */
#define SCU_HIBERNATE_HDCR_STDBYSEL_Msk       (0x80UL)                  /*!< SCU_HIBERNATE HDCR: STDBYSEL (Bitfield-Mask: 0x01)          */
#define SCU_HIBERNATE_HDCR_WKUPSEL_Pos        (8UL)                     /*!< SCU_HIBERNATE HDCR: WKUPSEL (Bit 8)                         */
#define SCU_HIBERNATE_HDCR_WKUPSEL_Msk        (0x100UL)                 /*!< SCU_HIBERNATE HDCR: WKUPSEL (Bitfield-Mask: 0x01)           */
#define SCU_HIBERNATE_HDCR_GPI0SEL_Pos        (10UL)                    /*!< SCU_HIBERNATE HDCR: GPI0SEL (Bit 10)                        */
#define SCU_HIBERNATE_HDCR_GPI0SEL_Msk        (0x400UL)                 /*!< SCU_HIBERNATE HDCR: GPI0SEL (Bitfield-Mask: 0x01)           */
#define SCU_HIBERNATE_HDCR_GPI1SEL_Pos        (11UL)                    /*!< SCU_HIBERNATE HDCR: GPI1SEL (Bit 11)                        */
#define SCU_HIBERNATE_HDCR_GPI1SEL_Msk        (0x800UL)                 /*!< SCU_HIBERNATE HDCR: GPI1SEL (Bitfield-Mask: 0x01)           */
#define SCU_HIBERNATE_HDCR_HIBIO0POL_Pos      (12UL)                    /*!< SCU_HIBERNATE HDCR: HIBIO0POL (Bit 12)                      */
#define SCU_HIBERNATE_HDCR_HIBIO0POL_Msk      (0x1000UL)                /*!< SCU_HIBERNATE HDCR: HIBIO0POL (Bitfield-Mask: 0x01)         */
#define SCU_HIBERNATE_HDCR_HIBIO1POL_Pos      (13UL)                    /*!< SCU_HIBERNATE HDCR: HIBIO1POL (Bit 13)                      */
#define SCU_HIBERNATE_HDCR_HIBIO1POL_Msk      (0x2000UL)                /*!< SCU_HIBERNATE HDCR: HIBIO1POL (Bitfield-Mask: 0x01)         */
#define SCU_HIBERNATE_HDCR_ADIG0SEL_Pos       (14UL)                    /*!< SCU_HIBERNATE HDCR: ADIG0SEL (Bit 14)                       */
#define SCU_HIBERNATE_HDCR_ADIG0SEL_Msk       (0x4000UL)                /*!< SCU_HIBERNATE HDCR: ADIG0SEL (Bitfield-Mask: 0x01)          */
#define SCU_HIBERNATE_HDCR_ADIG1SEL_Pos       (15UL)                    /*!< SCU_HIBERNATE HDCR: ADIG1SEL (Bit 15)                       */
#define SCU_HIBERNATE_HDCR_ADIG1SEL_Msk       (0x8000UL)                /*!< SCU_HIBERNATE HDCR: ADIG1SEL (Bitfield-Mask: 0x01)          */
#define SCU_HIBERNATE_HDCR_HIBIO0SEL_Pos      (16UL)                    /*!< SCU_HIBERNATE HDCR: HIBIO0SEL (Bit 16)                      */
#define SCU_HIBERNATE_HDCR_HIBIO0SEL_Msk      (0xf0000UL)               /*!< SCU_HIBERNATE HDCR: HIBIO0SEL (Bitfield-Mask: 0x0f)         */
#define SCU_HIBERNATE_HDCR_HIBIO1SEL_Pos      (20UL)                    /*!< SCU_HIBERNATE HDCR: HIBIO1SEL (Bit 20)                      */
#define SCU_HIBERNATE_HDCR_HIBIO1SEL_Msk      (0xf00000UL)              /*!< SCU_HIBERNATE HDCR: HIBIO1SEL (Bitfield-Mask: 0x0f)         */
#define SCU_HIBERNATE_HDCR_VBATLO_Pos         (24UL)                    /*!< SCU_HIBERNATE HDCR: VBATLO (Bit 24)                         */
#define SCU_HIBERNATE_HDCR_VBATLO_Msk         (0x1000000UL)             /*!< SCU_HIBERNATE HDCR: VBATLO (Bitfield-Mask: 0x01)            */
#define SCU_HIBERNATE_HDCR_VBATHI_Pos         (25UL)                    /*!< SCU_HIBERNATE HDCR: VBATHI (Bit 25)                         */
#define SCU_HIBERNATE_HDCR_VBATHI_Msk         (0x2000000UL)             /*!< SCU_HIBERNATE HDCR: VBATHI (Bitfield-Mask: 0x01)            */
#define SCU_HIBERNATE_HDCR_AHIBIO0LO_Pos      (26UL)                    /*!< SCU_HIBERNATE HDCR: AHIBIO0LO (Bit 26)                      */
#define SCU_HIBERNATE_HDCR_AHIBIO0LO_Msk      (0x4000000UL)             /*!< SCU_HIBERNATE HDCR: AHIBIO0LO (Bitfield-Mask: 0x01)         */
#define SCU_HIBERNATE_HDCR_AHIBIO0HI_Pos      (27UL)                    /*!< SCU_HIBERNATE HDCR: AHIBIO0HI (Bit 27)                      */
#define SCU_HIBERNATE_HDCR_AHIBIO0HI_Msk      (0x8000000UL)             /*!< SCU_HIBERNATE HDCR: AHIBIO0HI (Bitfield-Mask: 0x01)         */
#define SCU_HIBERNATE_HDCR_AHIBIO1LO_Pos      (28UL)                    /*!< SCU_HIBERNATE HDCR: AHIBIO1LO (Bit 28)                      */
#define SCU_HIBERNATE_HDCR_AHIBIO1LO_Msk      (0x10000000UL)            /*!< SCU_HIBERNATE HDCR: AHIBIO1LO (Bitfield-Mask: 0x01)         */
#define SCU_HIBERNATE_HDCR_AHIBIO1HI_Pos      (29UL)                    /*!< SCU_HIBERNATE HDCR: AHIBIO1HI (Bit 29)                      */
#define SCU_HIBERNATE_HDCR_AHIBIO1HI_Msk      (0x20000000UL)            /*!< SCU_HIBERNATE HDCR: AHIBIO1HI (Bitfield-Mask: 0x01)         */

/* ---------------------------  SCU_HIBERNATE_OSCSICTRL  -------------------------- */
#define SCU_HIBERNATE_OSCSICTRL_PWD_Pos       (0UL)                     /*!< SCU_HIBERNATE OSCSICTRL: PWD (Bit 0)                        */
#define SCU_HIBERNATE_OSCSICTRL_PWD_Msk       (0x1UL)                   /*!< SCU_HIBERNATE OSCSICTRL: PWD (Bitfield-Mask: 0x01)          */

/* ---------------------------  SCU_HIBERNATE_OSCULSTAT  -------------------------- */
#define SCU_HIBERNATE_OSCULSTAT_X1D_Pos       (0UL)                     /*!< SCU_HIBERNATE OSCULSTAT: X1D (Bit 0)                        */
#define SCU_HIBERNATE_OSCULSTAT_X1D_Msk       (0x1UL)                   /*!< SCU_HIBERNATE OSCULSTAT: X1D (Bitfield-Mask: 0x01)          */

/* ---------------------------  SCU_HIBERNATE_OSCULCTRL  -------------------------- */
#define SCU_HIBERNATE_OSCULCTRL_X1DEN_Pos     (0UL)                     /*!< SCU_HIBERNATE OSCULCTRL: X1DEN (Bit 0)                      */
#define SCU_HIBERNATE_OSCULCTRL_X1DEN_Msk     (0x1UL)                   /*!< SCU_HIBERNATE OSCULCTRL: X1DEN (Bitfield-Mask: 0x01)        */
#define SCU_HIBERNATE_OSCULCTRL_MODE_Pos      (4UL)                     /*!< SCU_HIBERNATE OSCULCTRL: MODE (Bit 4)                       */
#define SCU_HIBERNATE_OSCULCTRL_MODE_Msk      (0x30UL)                  /*!< SCU_HIBERNATE OSCULCTRL: MODE (Bitfield-Mask: 0x03)         */

/* ---------------------------  SCU_HIBERNATE_LPACCONF  --------------------------- */
#define SCU_HIBERNATE_LPACCONF_CMPEN_Pos      (0UL)                     /*!< SCU_HIBERNATE LPACCONF: CMPEN (Bit 0)                       */
#define SCU_HIBERNATE_LPACCONF_CMPEN_Msk      (0x7UL)                   /*!< SCU_HIBERNATE LPACCONF: CMPEN (Bitfield-Mask: 0x07)         */
#define SCU_HIBERNATE_LPACCONF_TRIGSEL_Pos    (4UL)                     /*!< SCU_HIBERNATE LPACCONF: TRIGSEL (Bit 4)                     */
#define SCU_HIBERNATE_LPACCONF_TRIGSEL_Msk    (0x70UL)                  /*!< SCU_HIBERNATE LPACCONF: TRIGSEL (Bitfield-Mask: 0x07)       */
#define SCU_HIBERNATE_LPACCONF_CONVDEL_Pos    (12UL)                    /*!< SCU_HIBERNATE LPACCONF: CONVDEL (Bit 12)                    */
#define SCU_HIBERNATE_LPACCONF_CONVDEL_Msk    (0x1000UL)                /*!< SCU_HIBERNATE LPACCONF: CONVDEL (Bitfield-Mask: 0x01)       */
#define SCU_HIBERNATE_LPACCONF_INTERVCNT_Pos  (16UL)                    /*!< SCU_HIBERNATE LPACCONF: INTERVCNT (Bit 16)                  */
#define SCU_HIBERNATE_LPACCONF_INTERVCNT_Msk  (0xfff0000UL)             /*!< SCU_HIBERNATE LPACCONF: INTERVCNT (Bitfield-Mask: 0xfff)    */
#define SCU_HIBERNATE_LPACCONF_SETTLECNT_Pos  (28UL)                    /*!< SCU_HIBERNATE LPACCONF: SETTLECNT (Bit 28)                  */
#define SCU_HIBERNATE_LPACCONF_SETTLECNT_Msk  (0xf0000000UL)            /*!< SCU_HIBERNATE LPACCONF: SETTLECNT (Bitfield-Mask: 0x0f)     */

/* ----------------------------  SCU_HIBERNATE_LPACTH0  --------------------------- */
#define SCU_HIBERNATE_LPACTH0_VBATLO_Pos      (0UL)                     /*!< SCU_HIBERNATE LPACTH0: VBATLO (Bit 0)                       */
#define SCU_HIBERNATE_LPACTH0_VBATLO_Msk      (0x3fUL)                  /*!< SCU_HIBERNATE LPACTH0: VBATLO (Bitfield-Mask: 0x3f)         */
#define SCU_HIBERNATE_LPACTH0_VBATHI_Pos      (8UL)                     /*!< SCU_HIBERNATE LPACTH0: VBATHI (Bit 8)                       */
#define SCU_HIBERNATE_LPACTH0_VBATHI_Msk      (0x3f00UL)                /*!< SCU_HIBERNATE LPACTH0: VBATHI (Bitfield-Mask: 0x3f)         */

/* ----------------------------  SCU_HIBERNATE_LPACTH1  --------------------------- */
#define SCU_HIBERNATE_LPACTH1_AHIBIO0LO_Pos   (0UL)                     /*!< SCU_HIBERNATE LPACTH1: AHIBIO0LO (Bit 0)                    */
#define SCU_HIBERNATE_LPACTH1_AHIBIO0LO_Msk   (0x3fUL)                  /*!< SCU_HIBERNATE LPACTH1: AHIBIO0LO (Bitfield-Mask: 0x3f)      */
#define SCU_HIBERNATE_LPACTH1_AHIBIO0HI_Pos   (8UL)                     /*!< SCU_HIBERNATE LPACTH1: AHIBIO0HI (Bit 8)                    */
#define SCU_HIBERNATE_LPACTH1_AHIBIO0HI_Msk   (0x3f00UL)                /*!< SCU_HIBERNATE LPACTH1: AHIBIO0HI (Bitfield-Mask: 0x3f)      */
#define SCU_HIBERNATE_LPACTH1_AHIBIO1LO_Pos   (16UL)                    /*!< SCU_HIBERNATE LPACTH1: AHIBIO1LO (Bit 16)                   */
#define SCU_HIBERNATE_LPACTH1_AHIBIO1LO_Msk   (0x3f0000UL)              /*!< SCU_HIBERNATE LPACTH1: AHIBIO1LO (Bitfield-Mask: 0x3f)      */
#define SCU_HIBERNATE_LPACTH1_AHIBIO1HI_Pos   (24UL)                    /*!< SCU_HIBERNATE LPACTH1: AHIBIO1HI (Bit 24)                   */
#define SCU_HIBERNATE_LPACTH1_AHIBIO1HI_Msk   (0x3f000000UL)            /*!< SCU_HIBERNATE LPACTH1: AHIBIO1HI (Bitfield-Mask: 0x3f)      */

/* ----------------------------  SCU_HIBERNATE_LPACST  ---------------------------- */
#define SCU_HIBERNATE_LPACST_VBATSCMP_Pos     (0UL)                     /*!< SCU_HIBERNATE LPACST: VBATSCMP (Bit 0)                      */
#define SCU_HIBERNATE_LPACST_VBATSCMP_Msk     (0x1UL)                   /*!< SCU_HIBERNATE LPACST: VBATSCMP (Bitfield-Mask: 0x01)        */
#define SCU_HIBERNATE_LPACST_AHIBIO0SCMP_Pos  (1UL)                     /*!< SCU_HIBERNATE LPACST: AHIBIO0SCMP (Bit 1)                   */
#define SCU_HIBERNATE_LPACST_AHIBIO0SCMP_Msk  (0x2UL)                   /*!< SCU_HIBERNATE LPACST: AHIBIO0SCMP (Bitfield-Mask: 0x01)     */
#define SCU_HIBERNATE_LPACST_AHIBIO1SCMP_Pos  (2UL)                     /*!< SCU_HIBERNATE LPACST: AHIBIO1SCMP (Bit 2)                   */
#define SCU_HIBERNATE_LPACST_AHIBIO1SCMP_Msk  (0x4UL)                   /*!< SCU_HIBERNATE LPACST: AHIBIO1SCMP (Bitfield-Mask: 0x01)     */
#define SCU_HIBERNATE_LPACST_VBATVAL_Pos      (16UL)                    /*!< SCU_HIBERNATE LPACST: VBATVAL (Bit 16)                      */
#define SCU_HIBERNATE_LPACST_VBATVAL_Msk      (0x10000UL)               /*!< SCU_HIBERNATE LPACST: VBATVAL (Bitfield-Mask: 0x01)         */
#define SCU_HIBERNATE_LPACST_AHIBIO0VAL_Pos   (17UL)                    /*!< SCU_HIBERNATE LPACST: AHIBIO0VAL (Bit 17)                   */
#define SCU_HIBERNATE_LPACST_AHIBIO0VAL_Msk   (0x20000UL)               /*!< SCU_HIBERNATE LPACST: AHIBIO0VAL (Bitfield-Mask: 0x01)      */
#define SCU_HIBERNATE_LPACST_AHIBIO1VAL_Pos   (18UL)                    /*!< SCU_HIBERNATE LPACST: AHIBIO1VAL (Bit 18)                   */
#define SCU_HIBERNATE_LPACST_AHIBIO1VAL_Msk   (0x40000UL)               /*!< SCU_HIBERNATE LPACST: AHIBIO1VAL (Bitfield-Mask: 0x01)      */

/* ----------------------------  SCU_HIBERNATE_LPACCLR  --------------------------- */
#define SCU_HIBERNATE_LPACCLR_VBATSCMP_Pos    (0UL)                     /*!< SCU_HIBERNATE LPACCLR: VBATSCMP (Bit 0)                     */
#define SCU_HIBERNATE_LPACCLR_VBATSCMP_Msk    (0x1UL)                   /*!< SCU_HIBERNATE LPACCLR: VBATSCMP (Bitfield-Mask: 0x01)       */
#define SCU_HIBERNATE_LPACCLR_AHIBIO0SCMP_Pos (1UL)                     /*!< SCU_HIBERNATE LPACCLR: AHIBIO0SCMP (Bit 1)                  */
#define SCU_HIBERNATE_LPACCLR_AHIBIO0SCMP_Msk (0x2UL)                   /*!< SCU_HIBERNATE LPACCLR: AHIBIO0SCMP (Bitfield-Mask: 0x01)    */
#define SCU_HIBERNATE_LPACCLR_AHIBIO1SCMP_Pos (2UL)                     /*!< SCU_HIBERNATE LPACCLR: AHIBIO1SCMP (Bit 2)                  */
#define SCU_HIBERNATE_LPACCLR_AHIBIO1SCMP_Msk (0x4UL)                   /*!< SCU_HIBERNATE LPACCLR: AHIBIO1SCMP (Bitfield-Mask: 0x01)    */
#define SCU_HIBERNATE_LPACCLR_VBATVAL_Pos     (16UL)                    /*!< SCU_HIBERNATE LPACCLR: VBATVAL (Bit 16)                     */
#define SCU_HIBERNATE_LPACCLR_VBATVAL_Msk     (0x10000UL)               /*!< SCU_HIBERNATE LPACCLR: VBATVAL (Bitfield-Mask: 0x01)        */
#define SCU_HIBERNATE_LPACCLR_AHIBIO0VAL_Pos  (17UL)                    /*!< SCU_HIBERNATE LPACCLR: AHIBIO0VAL (Bit 17)                  */
#define SCU_HIBERNATE_LPACCLR_AHIBIO0VAL_Msk  (0x20000UL)               /*!< SCU_HIBERNATE LPACCLR: AHIBIO0VAL (Bitfield-Mask: 0x01)     */
#define SCU_HIBERNATE_LPACCLR_AHIBIO1VAL_Pos  (18UL)                    /*!< SCU_HIBERNATE LPACCLR: AHIBIO1VAL (Bit 18)                  */
#define SCU_HIBERNATE_LPACCLR_AHIBIO1VAL_Msk  (0x40000UL)               /*!< SCU_HIBERNATE LPACCLR: AHIBIO1VAL (Bitfield-Mask: 0x01)     */

/* ----------------------------  SCU_HIBERNATE_LPACSET  --------------------------- */
#define SCU_HIBERNATE_LPACSET_VBATSCMP_Pos    (0UL)                     /*!< SCU_HIBERNATE LPACSET: VBATSCMP (Bit 0)                     */
#define SCU_HIBERNATE_LPACSET_VBATSCMP_Msk    (0x1UL)                   /*!< SCU_HIBERNATE LPACSET: VBATSCMP (Bitfield-Mask: 0x01)       */
#define SCU_HIBERNATE_LPACSET_AHIBIO0SCMP_Pos (1UL)                     /*!< SCU_HIBERNATE LPACSET: AHIBIO0SCMP (Bit 1)                  */
#define SCU_HIBERNATE_LPACSET_AHIBIO0SCMP_Msk (0x2UL)                   /*!< SCU_HIBERNATE LPACSET: AHIBIO0SCMP (Bitfield-Mask: 0x01)    */
#define SCU_HIBERNATE_LPACSET_AHIBIO1SCMP_Pos (2UL)                     /*!< SCU_HIBERNATE LPACSET: AHIBIO1SCMP (Bit 2)                  */
#define SCU_HIBERNATE_LPACSET_AHIBIO1SCMP_Msk (0x4UL)                   /*!< SCU_HIBERNATE LPACSET: AHIBIO1SCMP (Bitfield-Mask: 0x01)    */
#define SCU_HIBERNATE_LPACSET_VBATVAL_Pos     (16UL)                    /*!< SCU_HIBERNATE LPACSET: VBATVAL (Bit 16)                     */
#define SCU_HIBERNATE_LPACSET_VBATVAL_Msk     (0x10000UL)               /*!< SCU_HIBERNATE LPACSET: VBATVAL (Bitfield-Mask: 0x01)        */
#define SCU_HIBERNATE_LPACSET_AHIBIO0VAL_Pos  (17UL)                    /*!< SCU_HIBERNATE LPACSET: AHIBIO0VAL (Bit 17)                  */
#define SCU_HIBERNATE_LPACSET_AHIBIO0VAL_Msk  (0x20000UL)               /*!< SCU_HIBERNATE LPACSET: AHIBIO0VAL (Bitfield-Mask: 0x01)     */
#define SCU_HIBERNATE_LPACSET_AHIBIO1VAL_Pos  (18UL)                    /*!< SCU_HIBERNATE LPACSET: AHIBIO1VAL (Bit 18)                  */
#define SCU_HIBERNATE_LPACSET_AHIBIO1VAL_Msk  (0x40000UL)               /*!< SCU_HIBERNATE LPACSET: AHIBIO1VAL (Bitfield-Mask: 0x01)     */

/* ----------------------------  SCU_HIBERNATE_HINTST  ---------------------------- */
#define SCU_HIBERNATE_HINTST_HIBNINT_Pos      (0UL)                     /*!< SCU_HIBERNATE HINTST: HIBNINT (Bit 0)                       */
#define SCU_HIBERNATE_HINTST_HIBNINT_Msk      (0x1UL)                   /*!< SCU_HIBERNATE HINTST: HIBNINT (Bitfield-Mask: 0x01)         */
#define SCU_HIBERNATE_HINTST_FLASHOFF_Pos     (2UL)                     /*!< SCU_HIBERNATE HINTST: FLASHOFF (Bit 2)                      */
#define SCU_HIBERNATE_HINTST_FLASHOFF_Msk     (0x4UL)                   /*!< SCU_HIBERNATE HINTST: FLASHOFF (Bitfield-Mask: 0x01)        */
#define SCU_HIBERNATE_HINTST_FLASHPD_Pos      (3UL)                     /*!< SCU_HIBERNATE HINTST: FLASHPD (Bit 3)                       */
#define SCU_HIBERNATE_HINTST_FLASHPD_Msk      (0x8UL)                   /*!< SCU_HIBERNATE HINTST: FLASHPD (Bitfield-Mask: 0x01)         */
#define SCU_HIBERNATE_HINTST_POFFD_Pos        (4UL)                     /*!< SCU_HIBERNATE HINTST: POFFD (Bit 4)                         */
#define SCU_HIBERNATE_HINTST_POFFD_Msk        (0x10UL)                  /*!< SCU_HIBERNATE HINTST: POFFD (Bitfield-Mask: 0x01)           */
#define SCU_HIBERNATE_HINTST_PPODEL_Pos       (16UL)                    /*!< SCU_HIBERNATE HINTST: PPODEL (Bit 16)                       */
#define SCU_HIBERNATE_HINTST_PPODEL_Msk       (0x30000UL)               /*!< SCU_HIBERNATE HINTST: PPODEL (Bitfield-Mask: 0x03)          */
#define SCU_HIBERNATE_HINTST_POFFH_Pos        (20UL)                    /*!< SCU_HIBERNATE HINTST: POFFH (Bit 20)                        */
#define SCU_HIBERNATE_HINTST_POFFH_Msk        (0x100000UL)              /*!< SCU_HIBERNATE HINTST: POFFH (Bitfield-Mask: 0x01)           */

/* ----------------------------  SCU_HIBERNATE_HINTCLR  --------------------------- */
#define SCU_HIBERNATE_HINTCLR_HIBNINT_Pos     (0UL)                     /*!< SCU_HIBERNATE HINTCLR: HIBNINT (Bit 0)                      */
#define SCU_HIBERNATE_HINTCLR_HIBNINT_Msk     (0x1UL)                   /*!< SCU_HIBERNATE HINTCLR: HIBNINT (Bitfield-Mask: 0x01)        */
#define SCU_HIBERNATE_HINTCLR_FLASHOFF_Pos    (2UL)                     /*!< SCU_HIBERNATE HINTCLR: FLASHOFF (Bit 2)                     */
#define SCU_HIBERNATE_HINTCLR_FLASHOFF_Msk    (0x4UL)                   /*!< SCU_HIBERNATE HINTCLR: FLASHOFF (Bitfield-Mask: 0x01)       */
#define SCU_HIBERNATE_HINTCLR_FLASHPD_Pos     (3UL)                     /*!< SCU_HIBERNATE HINTCLR: FLASHPD (Bit 3)                      */
#define SCU_HIBERNATE_HINTCLR_FLASHPD_Msk     (0x8UL)                   /*!< SCU_HIBERNATE HINTCLR: FLASHPD (Bitfield-Mask: 0x01)        */
#define SCU_HIBERNATE_HINTCLR_POFFD_Pos       (4UL)                     /*!< SCU_HIBERNATE HINTCLR: POFFD (Bit 4)                        */
#define SCU_HIBERNATE_HINTCLR_POFFD_Msk       (0x10UL)                  /*!< SCU_HIBERNATE HINTCLR: POFFD (Bitfield-Mask: 0x01)          */
#define SCU_HIBERNATE_HINTCLR_PPODEL_Pos      (16UL)                    /*!< SCU_HIBERNATE HINTCLR: PPODEL (Bit 16)                      */
#define SCU_HIBERNATE_HINTCLR_PPODEL_Msk      (0x30000UL)               /*!< SCU_HIBERNATE HINTCLR: PPODEL (Bitfield-Mask: 0x03)         */
#define SCU_HIBERNATE_HINTCLR_POFFH_Pos       (20UL)                    /*!< SCU_HIBERNATE HINTCLR: POFFH (Bit 20)                       */
#define SCU_HIBERNATE_HINTCLR_POFFH_Msk       (0x100000UL)              /*!< SCU_HIBERNATE HINTCLR: POFFH (Bitfield-Mask: 0x01)          */

/* ----------------------------  SCU_HIBERNATE_HINTSET  --------------------------- */
#define SCU_HIBERNATE_HINTSET_HIBNINT_Pos     (0UL)                     /*!< SCU_HIBERNATE HINTSET: HIBNINT (Bit 0)                      */
#define SCU_HIBERNATE_HINTSET_HIBNINT_Msk     (0x1UL)                   /*!< SCU_HIBERNATE HINTSET: HIBNINT (Bitfield-Mask: 0x01)        */
#define SCU_HIBERNATE_HINTSET_VCOREOFF_Pos    (1UL)                     /*!< SCU_HIBERNATE HINTSET: VCOREOFF (Bit 1)                     */
#define SCU_HIBERNATE_HINTSET_VCOREOFF_Msk    (0x2UL)                   /*!< SCU_HIBERNATE HINTSET: VCOREOFF (Bitfield-Mask: 0x01)       */
#define SCU_HIBERNATE_HINTSET_FLASHOFF_Pos    (2UL)                     /*!< SCU_HIBERNATE HINTSET: FLASHOFF (Bit 2)                     */
#define SCU_HIBERNATE_HINTSET_FLASHOFF_Msk    (0x4UL)                   /*!< SCU_HIBERNATE HINTSET: FLASHOFF (Bitfield-Mask: 0x01)       */
#define SCU_HIBERNATE_HINTSET_FLASHPD_Pos     (3UL)                     /*!< SCU_HIBERNATE HINTSET: FLASHPD (Bit 3)                      */
#define SCU_HIBERNATE_HINTSET_FLASHPD_Msk     (0x8UL)                   /*!< SCU_HIBERNATE HINTSET: FLASHPD (Bitfield-Mask: 0x01)        */
#define SCU_HIBERNATE_HINTSET_POFFD_Pos       (4UL)                     /*!< SCU_HIBERNATE HINTSET: POFFD (Bit 4)                        */
#define SCU_HIBERNATE_HINTSET_POFFD_Msk       (0x10UL)                  /*!< SCU_HIBERNATE HINTSET: POFFD (Bitfield-Mask: 0x01)          */
#define SCU_HIBERNATE_HINTSET_PPODEL_Pos      (16UL)                    /*!< SCU_HIBERNATE HINTSET: PPODEL (Bit 16)                      */
#define SCU_HIBERNATE_HINTSET_PPODEL_Msk      (0x30000UL)               /*!< SCU_HIBERNATE HINTSET: PPODEL (Bitfield-Mask: 0x03)         */
#define SCU_HIBERNATE_HINTSET_POFFH_Pos       (20UL)                    /*!< SCU_HIBERNATE HINTSET: POFFH (Bit 20)                       */
#define SCU_HIBERNATE_HINTSET_POFFH_Msk       (0x100000UL)              /*!< SCU_HIBERNATE HINTSET: POFFH (Bitfield-Mask: 0x01)          */


/* ================================================================================ */
/* ================       struct 'SCU_POWER' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  SCU_POWER_PWRSTAT  ----------------------------- */
#define SCU_POWER_PWRSTAT_HIBEN_Pos           (0UL)                     /*!< SCU_POWER PWRSTAT: HIBEN (Bit 0)                            */
#define SCU_POWER_PWRSTAT_HIBEN_Msk           (0x1UL)                   /*!< SCU_POWER PWRSTAT: HIBEN (Bitfield-Mask: 0x01)              */
#define SCU_POWER_PWRSTAT_USBPHYPDQ_Pos       (16UL)                    /*!< SCU_POWER PWRSTAT: USBPHYPDQ (Bit 16)                       */
#define SCU_POWER_PWRSTAT_USBPHYPDQ_Msk       (0x10000UL)               /*!< SCU_POWER PWRSTAT: USBPHYPDQ (Bitfield-Mask: 0x01)          */
#define SCU_POWER_PWRSTAT_USBOTGEN_Pos        (17UL)                    /*!< SCU_POWER PWRSTAT: USBOTGEN (Bit 17)                        */
#define SCU_POWER_PWRSTAT_USBOTGEN_Msk        (0x20000UL)               /*!< SCU_POWER PWRSTAT: USBOTGEN (Bitfield-Mask: 0x01)           */
#define SCU_POWER_PWRSTAT_USBPUWQ_Pos         (18UL)                    /*!< SCU_POWER PWRSTAT: USBPUWQ (Bit 18)                         */
#define SCU_POWER_PWRSTAT_USBPUWQ_Msk         (0x40000UL)               /*!< SCU_POWER PWRSTAT: USBPUWQ (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_POWER_PWRSET  ------------------------------ */
#define SCU_POWER_PWRSET_HIB_Pos              (0UL)                     /*!< SCU_POWER PWRSET: HIB (Bit 0)                               */
#define SCU_POWER_PWRSET_HIB_Msk              (0x1UL)                   /*!< SCU_POWER PWRSET: HIB (Bitfield-Mask: 0x01)                 */
#define SCU_POWER_PWRSET_USBPHYPDQ_Pos        (16UL)                    /*!< SCU_POWER PWRSET: USBPHYPDQ (Bit 16)                        */
#define SCU_POWER_PWRSET_USBPHYPDQ_Msk        (0x10000UL)               /*!< SCU_POWER PWRSET: USBPHYPDQ (Bitfield-Mask: 0x01)           */
#define SCU_POWER_PWRSET_USBOTGEN_Pos         (17UL)                    /*!< SCU_POWER PWRSET: USBOTGEN (Bit 17)                         */
#define SCU_POWER_PWRSET_USBOTGEN_Msk         (0x20000UL)               /*!< SCU_POWER PWRSET: USBOTGEN (Bitfield-Mask: 0x01)            */
#define SCU_POWER_PWRSET_USBPUWQ_Pos          (18UL)                    /*!< SCU_POWER PWRSET: USBPUWQ (Bit 18)                          */
#define SCU_POWER_PWRSET_USBPUWQ_Msk          (0x40000UL)               /*!< SCU_POWER PWRSET: USBPUWQ (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_POWER_PWRCLR  ------------------------------ */
#define SCU_POWER_PWRCLR_HIB_Pos              (0UL)                     /*!< SCU_POWER PWRCLR: HIB (Bit 0)                               */
#define SCU_POWER_PWRCLR_HIB_Msk              (0x1UL)                   /*!< SCU_POWER PWRCLR: HIB (Bitfield-Mask: 0x01)                 */
#define SCU_POWER_PWRCLR_USBPHYPDQ_Pos        (16UL)                    /*!< SCU_POWER PWRCLR: USBPHYPDQ (Bit 16)                        */
#define SCU_POWER_PWRCLR_USBPHYPDQ_Msk        (0x10000UL)               /*!< SCU_POWER PWRCLR: USBPHYPDQ (Bitfield-Mask: 0x01)           */
#define SCU_POWER_PWRCLR_USBOTGEN_Pos         (17UL)                    /*!< SCU_POWER PWRCLR: USBOTGEN (Bit 17)                         */
#define SCU_POWER_PWRCLR_USBOTGEN_Msk         (0x20000UL)               /*!< SCU_POWER PWRCLR: USBOTGEN (Bitfield-Mask: 0x01)            */
#define SCU_POWER_PWRCLR_USBPUWQ_Pos          (18UL)                    /*!< SCU_POWER PWRCLR: USBPUWQ (Bit 18)                          */
#define SCU_POWER_PWRCLR_USBPUWQ_Msk          (0x40000UL)               /*!< SCU_POWER PWRCLR: USBPUWQ (Bitfield-Mask: 0x01)             */

/* ------------------------------  SCU_POWER_EVRSTAT  ----------------------------- */
#define SCU_POWER_EVRSTAT_OV13_Pos            (1UL)                     /*!< SCU_POWER EVRSTAT: OV13 (Bit 1)                             */
#define SCU_POWER_EVRSTAT_OV13_Msk            (0x2UL)                   /*!< SCU_POWER EVRSTAT: OV13 (Bitfield-Mask: 0x01)               */

/* ----------------------------  SCU_POWER_EVRVADCSTAT  --------------------------- */
#define SCU_POWER_EVRVADCSTAT_VADC13V_Pos     (0UL)                     /*!< SCU_POWER EVRVADCSTAT: VADC13V (Bit 0)                      */
#define SCU_POWER_EVRVADCSTAT_VADC13V_Msk     (0xffUL)                  /*!< SCU_POWER EVRVADCSTAT: VADC13V (Bitfield-Mask: 0xff)        */
#define SCU_POWER_EVRVADCSTAT_VADC33V_Pos     (8UL)                     /*!< SCU_POWER EVRVADCSTAT: VADC33V (Bit 8)                      */
#define SCU_POWER_EVRVADCSTAT_VADC33V_Msk     (0xff00UL)                /*!< SCU_POWER EVRVADCSTAT: VADC33V (Bitfield-Mask: 0xff)        */

/* ------------------------------  SCU_POWER_PWRMON  ------------------------------ */
#define SCU_POWER_PWRMON_THRS_Pos             (0UL)                     /*!< SCU_POWER PWRMON: THRS (Bit 0)                              */
#define SCU_POWER_PWRMON_THRS_Msk             (0xffUL)                  /*!< SCU_POWER PWRMON: THRS (Bitfield-Mask: 0xff)                */
#define SCU_POWER_PWRMON_INTV_Pos             (8UL)                     /*!< SCU_POWER PWRMON: INTV (Bit 8)                              */
#define SCU_POWER_PWRMON_INTV_Msk             (0xff00UL)                /*!< SCU_POWER PWRMON: INTV (Bitfield-Mask: 0xff)                */
#define SCU_POWER_PWRMON_ENB_Pos              (16UL)                    /*!< SCU_POWER PWRMON: ENB (Bit 16)                              */
#define SCU_POWER_PWRMON_ENB_Msk              (0x10000UL)               /*!< SCU_POWER PWRMON: ENB (Bitfield-Mask: 0x01)                 */


/* ================================================================================ */
/* ================       struct 'SCU_RESET' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  SCU_RESET_RSTSTAT  ----------------------------- */
#define SCU_RESET_RSTSTAT_RSTSTAT_Pos         (0UL)                     /*!< SCU_RESET RSTSTAT: RSTSTAT (Bit 0)                          */
#define SCU_RESET_RSTSTAT_RSTSTAT_Msk         (0xffUL)                  /*!< SCU_RESET RSTSTAT: RSTSTAT (Bitfield-Mask: 0xff)            */
#define SCU_RESET_RSTSTAT_HIBWK_Pos           (8UL)                     /*!< SCU_RESET RSTSTAT: HIBWK (Bit 8)                            */
#define SCU_RESET_RSTSTAT_HIBWK_Msk           (0x100UL)                 /*!< SCU_RESET RSTSTAT: HIBWK (Bitfield-Mask: 0x01)              */
#define SCU_RESET_RSTSTAT_HIBRS_Pos           (9UL)                     /*!< SCU_RESET RSTSTAT: HIBRS (Bit 9)                            */
#define SCU_RESET_RSTSTAT_HIBRS_Msk           (0x200UL)                 /*!< SCU_RESET RSTSTAT: HIBRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_RSTSTAT_LCKEN_Pos           (10UL)                    /*!< SCU_RESET RSTSTAT: LCKEN (Bit 10)                           */
#define SCU_RESET_RSTSTAT_LCKEN_Msk           (0x400UL)                 /*!< SCU_RESET RSTSTAT: LCKEN (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_RESET_RSTSET  ------------------------------ */
#define SCU_RESET_RSTSET_HIBWK_Pos            (8UL)                     /*!< SCU_RESET RSTSET: HIBWK (Bit 8)                             */
#define SCU_RESET_RSTSET_HIBWK_Msk            (0x100UL)                 /*!< SCU_RESET RSTSET: HIBWK (Bitfield-Mask: 0x01)               */
#define SCU_RESET_RSTSET_HIBRS_Pos            (9UL)                     /*!< SCU_RESET RSTSET: HIBRS (Bit 9)                             */
#define SCU_RESET_RSTSET_HIBRS_Msk            (0x200UL)                 /*!< SCU_RESET RSTSET: HIBRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_RSTSET_LCKEN_Pos            (10UL)                    /*!< SCU_RESET RSTSET: LCKEN (Bit 10)                            */
#define SCU_RESET_RSTSET_LCKEN_Msk            (0x400UL)                 /*!< SCU_RESET RSTSET: LCKEN (Bitfield-Mask: 0x01)               */

/* ------------------------------  SCU_RESET_RSTCLR  ------------------------------ */
#define SCU_RESET_RSTCLR_RSCLR_Pos            (0UL)                     /*!< SCU_RESET RSTCLR: RSCLR (Bit 0)                             */
#define SCU_RESET_RSTCLR_RSCLR_Msk            (0x1UL)                   /*!< SCU_RESET RSTCLR: RSCLR (Bitfield-Mask: 0x01)               */
#define SCU_RESET_RSTCLR_HIBWK_Pos            (8UL)                     /*!< SCU_RESET RSTCLR: HIBWK (Bit 8)                             */
#define SCU_RESET_RSTCLR_HIBWK_Msk            (0x100UL)                 /*!< SCU_RESET RSTCLR: HIBWK (Bitfield-Mask: 0x01)               */
#define SCU_RESET_RSTCLR_HIBRS_Pos            (9UL)                     /*!< SCU_RESET RSTCLR: HIBRS (Bit 9)                             */
#define SCU_RESET_RSTCLR_HIBRS_Msk            (0x200UL)                 /*!< SCU_RESET RSTCLR: HIBRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_RSTCLR_LCKEN_Pos            (10UL)                    /*!< SCU_RESET RSTCLR: LCKEN (Bit 10)                            */
#define SCU_RESET_RSTCLR_LCKEN_Msk            (0x400UL)                 /*!< SCU_RESET RSTCLR: LCKEN (Bitfield-Mask: 0x01)               */

/* ------------------------------  SCU_RESET_PRSTAT0  ----------------------------- */
#define SCU_RESET_PRSTAT0_VADCRS_Pos          (0UL)                     /*!< SCU_RESET PRSTAT0: VADCRS (Bit 0)                           */
#define SCU_RESET_PRSTAT0_VADCRS_Msk          (0x1UL)                   /*!< SCU_RESET PRSTAT0: VADCRS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSTAT0_DSDRS_Pos           (1UL)                     /*!< SCU_RESET PRSTAT0: DSDRS (Bit 1)                            */
#define SCU_RESET_PRSTAT0_DSDRS_Msk           (0x2UL)                   /*!< SCU_RESET PRSTAT0: DSDRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSTAT0_CCU40RS_Pos         (2UL)                     /*!< SCU_RESET PRSTAT0: CCU40RS (Bit 2)                          */
#define SCU_RESET_PRSTAT0_CCU40RS_Msk         (0x4UL)                   /*!< SCU_RESET PRSTAT0: CCU40RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT0_CCU41RS_Pos         (3UL)                     /*!< SCU_RESET PRSTAT0: CCU41RS (Bit 3)                          */
#define SCU_RESET_PRSTAT0_CCU41RS_Msk         (0x8UL)                   /*!< SCU_RESET PRSTAT0: CCU41RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT0_CCU42RS_Pos         (4UL)                     /*!< SCU_RESET PRSTAT0: CCU42RS (Bit 4)                          */
#define SCU_RESET_PRSTAT0_CCU42RS_Msk         (0x10UL)                  /*!< SCU_RESET PRSTAT0: CCU42RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT0_CCU80RS_Pos         (7UL)                     /*!< SCU_RESET PRSTAT0: CCU80RS (Bit 7)                          */
#define SCU_RESET_PRSTAT0_CCU80RS_Msk         (0x80UL)                  /*!< SCU_RESET PRSTAT0: CCU80RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT0_CCU81RS_Pos         (8UL)                     /*!< SCU_RESET PRSTAT0: CCU81RS (Bit 8)                          */
#define SCU_RESET_PRSTAT0_CCU81RS_Msk         (0x100UL)                 /*!< SCU_RESET PRSTAT0: CCU81RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT0_POSIF0RS_Pos        (9UL)                     /*!< SCU_RESET PRSTAT0: POSIF0RS (Bit 9)                         */
#define SCU_RESET_PRSTAT0_POSIF0RS_Msk        (0x200UL)                 /*!< SCU_RESET PRSTAT0: POSIF0RS (Bitfield-Mask: 0x01)           */
#define SCU_RESET_PRSTAT0_POSIF1RS_Pos        (10UL)                    /*!< SCU_RESET PRSTAT0: POSIF1RS (Bit 10)                        */
#define SCU_RESET_PRSTAT0_POSIF1RS_Msk        (0x400UL)                 /*!< SCU_RESET PRSTAT0: POSIF1RS (Bitfield-Mask: 0x01)           */
#define SCU_RESET_PRSTAT0_USIC0RS_Pos         (11UL)                    /*!< SCU_RESET PRSTAT0: USIC0RS (Bit 11)                         */
#define SCU_RESET_PRSTAT0_USIC0RS_Msk         (0x800UL)                 /*!< SCU_RESET PRSTAT0: USIC0RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT0_ERU1RS_Pos          (16UL)                    /*!< SCU_RESET PRSTAT0: ERU1RS (Bit 16)                          */
#define SCU_RESET_PRSTAT0_ERU1RS_Msk          (0x10000UL)               /*!< SCU_RESET PRSTAT0: ERU1RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSTAT0_HRPWM0RS_Pos        (23UL)                    /*!< SCU_RESET PRSTAT0: HRPWM0RS (Bit 23)                        */
#define SCU_RESET_PRSTAT0_HRPWM0RS_Msk        (0x800000UL)              /*!< SCU_RESET PRSTAT0: HRPWM0RS (Bitfield-Mask: 0x01)           */

/* ------------------------------  SCU_RESET_PRSET0  ------------------------------ */
#define SCU_RESET_PRSET0_VADCRS_Pos           (0UL)                     /*!< SCU_RESET PRSET0: VADCRS (Bit 0)                            */
#define SCU_RESET_PRSET0_VADCRS_Msk           (0x1UL)                   /*!< SCU_RESET PRSET0: VADCRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSET0_DSDRS_Pos            (1UL)                     /*!< SCU_RESET PRSET0: DSDRS (Bit 1)                             */
#define SCU_RESET_PRSET0_DSDRS_Msk            (0x2UL)                   /*!< SCU_RESET PRSET0: DSDRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRSET0_CCU40RS_Pos          (2UL)                     /*!< SCU_RESET PRSET0: CCU40RS (Bit 2)                           */
#define SCU_RESET_PRSET0_CCU40RS_Msk          (0x4UL)                   /*!< SCU_RESET PRSET0: CCU40RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET0_CCU41RS_Pos          (3UL)                     /*!< SCU_RESET PRSET0: CCU41RS (Bit 3)                           */
#define SCU_RESET_PRSET0_CCU41RS_Msk          (0x8UL)                   /*!< SCU_RESET PRSET0: CCU41RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET0_CCU42RS_Pos          (4UL)                     /*!< SCU_RESET PRSET0: CCU42RS (Bit 4)                           */
#define SCU_RESET_PRSET0_CCU42RS_Msk          (0x10UL)                  /*!< SCU_RESET PRSET0: CCU42RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET0_CCU80RS_Pos          (7UL)                     /*!< SCU_RESET PRSET0: CCU80RS (Bit 7)                           */
#define SCU_RESET_PRSET0_CCU80RS_Msk          (0x80UL)                  /*!< SCU_RESET PRSET0: CCU80RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET0_CCU81RS_Pos          (8UL)                     /*!< SCU_RESET PRSET0: CCU81RS (Bit 8)                           */
#define SCU_RESET_PRSET0_CCU81RS_Msk          (0x100UL)                 /*!< SCU_RESET PRSET0: CCU81RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET0_POSIF0RS_Pos         (9UL)                     /*!< SCU_RESET PRSET0: POSIF0RS (Bit 9)                          */
#define SCU_RESET_PRSET0_POSIF0RS_Msk         (0x200UL)                 /*!< SCU_RESET PRSET0: POSIF0RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSET0_POSIF1RS_Pos         (10UL)                    /*!< SCU_RESET PRSET0: POSIF1RS (Bit 10)                         */
#define SCU_RESET_PRSET0_POSIF1RS_Msk         (0x400UL)                 /*!< SCU_RESET PRSET0: POSIF1RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSET0_USIC0RS_Pos          (11UL)                    /*!< SCU_RESET PRSET0: USIC0RS (Bit 11)                          */
#define SCU_RESET_PRSET0_USIC0RS_Msk          (0x800UL)                 /*!< SCU_RESET PRSET0: USIC0RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET0_ERU1RS_Pos           (16UL)                    /*!< SCU_RESET PRSET0: ERU1RS (Bit 16)                           */
#define SCU_RESET_PRSET0_ERU1RS_Msk           (0x10000UL)               /*!< SCU_RESET PRSET0: ERU1RS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSET0_HRPWM0RS_Pos         (23UL)                    /*!< SCU_RESET PRSET0: HRPWM0RS (Bit 23)                         */
#define SCU_RESET_PRSET0_HRPWM0RS_Msk         (0x800000UL)              /*!< SCU_RESET PRSET0: HRPWM0RS (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_RESET_PRCLR0  ------------------------------ */
#define SCU_RESET_PRCLR0_VADCRS_Pos           (0UL)                     /*!< SCU_RESET PRCLR0: VADCRS (Bit 0)                            */
#define SCU_RESET_PRCLR0_VADCRS_Msk           (0x1UL)                   /*!< SCU_RESET PRCLR0: VADCRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRCLR0_DSDRS_Pos            (1UL)                     /*!< SCU_RESET PRCLR0: DSDRS (Bit 1)                             */
#define SCU_RESET_PRCLR0_DSDRS_Msk            (0x2UL)                   /*!< SCU_RESET PRCLR0: DSDRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRCLR0_CCU40RS_Pos          (2UL)                     /*!< SCU_RESET PRCLR0: CCU40RS (Bit 2)                           */
#define SCU_RESET_PRCLR0_CCU40RS_Msk          (0x4UL)                   /*!< SCU_RESET PRCLR0: CCU40RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR0_CCU41RS_Pos          (3UL)                     /*!< SCU_RESET PRCLR0: CCU41RS (Bit 3)                           */
#define SCU_RESET_PRCLR0_CCU41RS_Msk          (0x8UL)                   /*!< SCU_RESET PRCLR0: CCU41RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR0_CCU42RS_Pos          (4UL)                     /*!< SCU_RESET PRCLR0: CCU42RS (Bit 4)                           */
#define SCU_RESET_PRCLR0_CCU42RS_Msk          (0x10UL)                  /*!< SCU_RESET PRCLR0: CCU42RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR0_CCU80RS_Pos          (7UL)                     /*!< SCU_RESET PRCLR0: CCU80RS (Bit 7)                           */
#define SCU_RESET_PRCLR0_CCU80RS_Msk          (0x80UL)                  /*!< SCU_RESET PRCLR0: CCU80RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR0_CCU81RS_Pos          (8UL)                     /*!< SCU_RESET PRCLR0: CCU81RS (Bit 8)                           */
#define SCU_RESET_PRCLR0_CCU81RS_Msk          (0x100UL)                 /*!< SCU_RESET PRCLR0: CCU81RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR0_POSIF0RS_Pos         (9UL)                     /*!< SCU_RESET PRCLR0: POSIF0RS (Bit 9)                          */
#define SCU_RESET_PRCLR0_POSIF0RS_Msk         (0x200UL)                 /*!< SCU_RESET PRCLR0: POSIF0RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRCLR0_POSIF1RS_Pos         (10UL)                    /*!< SCU_RESET PRCLR0: POSIF1RS (Bit 10)                         */
#define SCU_RESET_PRCLR0_POSIF1RS_Msk         (0x400UL)                 /*!< SCU_RESET PRCLR0: POSIF1RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRCLR0_USIC0RS_Pos          (11UL)                    /*!< SCU_RESET PRCLR0: USIC0RS (Bit 11)                          */
#define SCU_RESET_PRCLR0_USIC0RS_Msk          (0x800UL)                 /*!< SCU_RESET PRCLR0: USIC0RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR0_ERU1RS_Pos           (16UL)                    /*!< SCU_RESET PRCLR0: ERU1RS (Bit 16)                           */
#define SCU_RESET_PRCLR0_ERU1RS_Msk           (0x10000UL)               /*!< SCU_RESET PRCLR0: ERU1RS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRCLR0_HRPWM0RS_Pos         (23UL)                    /*!< SCU_RESET PRCLR0: HRPWM0RS (Bit 23)                         */
#define SCU_RESET_PRCLR0_HRPWM0RS_Msk         (0x800000UL)              /*!< SCU_RESET PRCLR0: HRPWM0RS (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_RESET_PRSTAT1  ----------------------------- */
#define SCU_RESET_PRSTAT1_CCU43RS_Pos         (0UL)                     /*!< SCU_RESET PRSTAT1: CCU43RS (Bit 0)                          */
#define SCU_RESET_PRSTAT1_CCU43RS_Msk         (0x1UL)                   /*!< SCU_RESET PRSTAT1: CCU43RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT1_LEDTSCU0RS_Pos      (3UL)                     /*!< SCU_RESET PRSTAT1: LEDTSCU0RS (Bit 3)                       */
#define SCU_RESET_PRSTAT1_LEDTSCU0RS_Msk      (0x8UL)                   /*!< SCU_RESET PRSTAT1: LEDTSCU0RS (Bitfield-Mask: 0x01)         */
#define SCU_RESET_PRSTAT1_MCAN0RS_Pos         (4UL)                     /*!< SCU_RESET PRSTAT1: MCAN0RS (Bit 4)                          */
#define SCU_RESET_PRSTAT1_MCAN0RS_Msk         (0x10UL)                  /*!< SCU_RESET PRSTAT1: MCAN0RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT1_DACRS_Pos           (5UL)                     /*!< SCU_RESET PRSTAT1: DACRS (Bit 5)                            */
#define SCU_RESET_PRSTAT1_DACRS_Msk           (0x20UL)                  /*!< SCU_RESET PRSTAT1: DACRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSTAT1_USIC1RS_Pos         (7UL)                     /*!< SCU_RESET PRSTAT1: USIC1RS (Bit 7)                          */
#define SCU_RESET_PRSTAT1_USIC1RS_Msk         (0x80UL)                  /*!< SCU_RESET PRSTAT1: USIC1RS (Bitfield-Mask: 0x01)            */
#define SCU_RESET_PRSTAT1_PPORTSRS_Pos        (9UL)                     /*!< SCU_RESET PRSTAT1: PPORTSRS (Bit 9)                         */
#define SCU_RESET_PRSTAT1_PPORTSRS_Msk        (0x200UL)                 /*!< SCU_RESET PRSTAT1: PPORTSRS (Bitfield-Mask: 0x01)           */

/* ------------------------------  SCU_RESET_PRSET1  ------------------------------ */
#define SCU_RESET_PRSET1_CCU43RS_Pos          (0UL)                     /*!< SCU_RESET PRSET1: CCU43RS (Bit 0)                           */
#define SCU_RESET_PRSET1_CCU43RS_Msk          (0x1UL)                   /*!< SCU_RESET PRSET1: CCU43RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET1_LEDTSCU0RS_Pos       (3UL)                     /*!< SCU_RESET PRSET1: LEDTSCU0RS (Bit 3)                        */
#define SCU_RESET_PRSET1_LEDTSCU0RS_Msk       (0x8UL)                   /*!< SCU_RESET PRSET1: LEDTSCU0RS (Bitfield-Mask: 0x01)          */
#define SCU_RESET_PRSET1_MCAN0RS_Pos          (4UL)                     /*!< SCU_RESET PRSET1: MCAN0RS (Bit 4)                           */
#define SCU_RESET_PRSET1_MCAN0RS_Msk          (0x10UL)                  /*!< SCU_RESET PRSET1: MCAN0RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET1_DACRS_Pos            (5UL)                     /*!< SCU_RESET PRSET1: DACRS (Bit 5)                             */
#define SCU_RESET_PRSET1_DACRS_Msk            (0x20UL)                  /*!< SCU_RESET PRSET1: DACRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRSET1_USIC1RS_Pos          (7UL)                     /*!< SCU_RESET PRSET1: USIC1RS (Bit 7)                           */
#define SCU_RESET_PRSET1_USIC1RS_Msk          (0x80UL)                  /*!< SCU_RESET PRSET1: USIC1RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSET1_PPORTSRS_Pos         (9UL)                     /*!< SCU_RESET PRSET1: PPORTSRS (Bit 9)                          */
#define SCU_RESET_PRSET1_PPORTSRS_Msk         (0x200UL)                 /*!< SCU_RESET PRSET1: PPORTSRS (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_RESET_PRCLR1  ------------------------------ */
#define SCU_RESET_PRCLR1_CCU43RS_Pos          (0UL)                     /*!< SCU_RESET PRCLR1: CCU43RS (Bit 0)                           */
#define SCU_RESET_PRCLR1_CCU43RS_Msk          (0x1UL)                   /*!< SCU_RESET PRCLR1: CCU43RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR1_LEDTSCU0RS_Pos       (3UL)                     /*!< SCU_RESET PRCLR1: LEDTSCU0RS (Bit 3)                        */
#define SCU_RESET_PRCLR1_LEDTSCU0RS_Msk       (0x8UL)                   /*!< SCU_RESET PRCLR1: LEDTSCU0RS (Bitfield-Mask: 0x01)          */
#define SCU_RESET_PRCLR1_MCAN0RS_Pos          (4UL)                     /*!< SCU_RESET PRCLR1: MCAN0RS (Bit 4)                           */
#define SCU_RESET_PRCLR1_MCAN0RS_Msk          (0x10UL)                  /*!< SCU_RESET PRCLR1: MCAN0RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR1_DACRS_Pos            (5UL)                     /*!< SCU_RESET PRCLR1: DACRS (Bit 5)                             */
#define SCU_RESET_PRCLR1_DACRS_Msk            (0x20UL)                  /*!< SCU_RESET PRCLR1: DACRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRCLR1_USIC1RS_Pos          (7UL)                     /*!< SCU_RESET PRCLR1: USIC1RS (Bit 7)                           */
#define SCU_RESET_PRCLR1_USIC1RS_Msk          (0x80UL)                  /*!< SCU_RESET PRCLR1: USIC1RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRCLR1_PPORTSRS_Pos         (9UL)                     /*!< SCU_RESET PRCLR1: PPORTSRS (Bit 9)                          */
#define SCU_RESET_PRCLR1_PPORTSRS_Msk         (0x200UL)                 /*!< SCU_RESET PRCLR1: PPORTSRS (Bitfield-Mask: 0x01)            */

/* ------------------------------  SCU_RESET_PRSTAT2  ----------------------------- */
#define SCU_RESET_PRSTAT2_WDTRS_Pos           (1UL)                     /*!< SCU_RESET PRSTAT2: WDTRS (Bit 1)                            */
#define SCU_RESET_PRSTAT2_WDTRS_Msk           (0x2UL)                   /*!< SCU_RESET PRSTAT2: WDTRS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSTAT2_ETH0RS_Pos          (2UL)                     /*!< SCU_RESET PRSTAT2: ETH0RS (Bit 2)                           */
#define SCU_RESET_PRSTAT2_ETH0RS_Msk          (0x4UL)                   /*!< SCU_RESET PRSTAT2: ETH0RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSTAT2_DMA0RS_Pos          (4UL)                     /*!< SCU_RESET PRSTAT2: DMA0RS (Bit 4)                           */
#define SCU_RESET_PRSTAT2_DMA0RS_Msk          (0x10UL)                  /*!< SCU_RESET PRSTAT2: DMA0RS (Bitfield-Mask: 0x01)             */
#define SCU_RESET_PRSTAT2_FCERS_Pos           (6UL)                     /*!< SCU_RESET PRSTAT2: FCERS (Bit 6)                            */
#define SCU_RESET_PRSTAT2_FCERS_Msk           (0x40UL)                  /*!< SCU_RESET PRSTAT2: FCERS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSTAT2_USBRS_Pos           (7UL)                     /*!< SCU_RESET PRSTAT2: USBRS (Bit 7)                            */
#define SCU_RESET_PRSTAT2_USBRS_Msk           (0x80UL)                  /*!< SCU_RESET PRSTAT2: USBRS (Bitfield-Mask: 0x01)              */

/* ------------------------------  SCU_RESET_PRSET2  ------------------------------ */
#define SCU_RESET_PRSET2_WDTRS_Pos            (1UL)                     /*!< SCU_RESET PRSET2: WDTRS (Bit 1)                             */
#define SCU_RESET_PRSET2_WDTRS_Msk            (0x2UL)                   /*!< SCU_RESET PRSET2: WDTRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRSET2_ETH0RS_Pos           (2UL)                     /*!< SCU_RESET PRSET2: ETH0RS (Bit 2)                            */
#define SCU_RESET_PRSET2_ETH0RS_Msk           (0x4UL)                   /*!< SCU_RESET PRSET2: ETH0RS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSET2_DMA0RS_Pos           (4UL)                     /*!< SCU_RESET PRSET2: DMA0RS (Bit 4)                            */
#define SCU_RESET_PRSET2_DMA0RS_Msk           (0x10UL)                  /*!< SCU_RESET PRSET2: DMA0RS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRSET2_FCERS_Pos            (6UL)                     /*!< SCU_RESET PRSET2: FCERS (Bit 6)                             */
#define SCU_RESET_PRSET2_FCERS_Msk            (0x40UL)                  /*!< SCU_RESET PRSET2: FCERS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRSET2_USBRS_Pos            (7UL)                     /*!< SCU_RESET PRSET2: USBRS (Bit 7)                             */
#define SCU_RESET_PRSET2_USBRS_Msk            (0x80UL)                  /*!< SCU_RESET PRSET2: USBRS (Bitfield-Mask: 0x01)               */

/* ------------------------------  SCU_RESET_PRCLR2  ------------------------------ */
#define SCU_RESET_PRCLR2_WDTRS_Pos            (1UL)                     /*!< SCU_RESET PRCLR2: WDTRS (Bit 1)                             */
#define SCU_RESET_PRCLR2_WDTRS_Msk            (0x2UL)                   /*!< SCU_RESET PRCLR2: WDTRS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRCLR2_ETH0RS_Pos           (2UL)                     /*!< SCU_RESET PRCLR2: ETH0RS (Bit 2)                            */
#define SCU_RESET_PRCLR2_ETH0RS_Msk           (0x4UL)                   /*!< SCU_RESET PRCLR2: ETH0RS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRCLR2_DMA0RS_Pos           (4UL)                     /*!< SCU_RESET PRCLR2: DMA0RS (Bit 4)                            */
#define SCU_RESET_PRCLR2_DMA0RS_Msk           (0x10UL)                  /*!< SCU_RESET PRCLR2: DMA0RS (Bitfield-Mask: 0x01)              */
#define SCU_RESET_PRCLR2_FCERS_Pos            (6UL)                     /*!< SCU_RESET PRCLR2: FCERS (Bit 6)                             */
#define SCU_RESET_PRCLR2_FCERS_Msk            (0x40UL)                  /*!< SCU_RESET PRCLR2: FCERS (Bitfield-Mask: 0x01)               */
#define SCU_RESET_PRCLR2_USBRS_Pos            (7UL)                     /*!< SCU_RESET PRCLR2: USBRS (Bit 7)                             */
#define SCU_RESET_PRCLR2_USBRS_Msk            (0x80UL)                  /*!< SCU_RESET PRCLR2: USBRS (Bitfield-Mask: 0x01)               */


/* ================================================================================ */
/* ================          Group 'LEDTS' Position & Mask         ================ */
/* ================================================================================ */


/* ----------------------------------  LEDTS_ID  ---------------------------------- */
#define LEDTS_ID_MOD_REV_Pos                  (0UL)                     /*!< LEDTS ID: MOD_REV (Bit 0)                                   */
#define LEDTS_ID_MOD_REV_Msk                  (0xffUL)                  /*!< LEDTS ID: MOD_REV (Bitfield-Mask: 0xff)                     */
#define LEDTS_ID_MOD_TYPE_Pos                 (8UL)                     /*!< LEDTS ID: MOD_TYPE (Bit 8)                                  */
#define LEDTS_ID_MOD_TYPE_Msk                 (0xff00UL)                /*!< LEDTS ID: MOD_TYPE (Bitfield-Mask: 0xff)                    */
#define LEDTS_ID_MOD_NUMBER_Pos               (16UL)                    /*!< LEDTS ID: MOD_NUMBER (Bit 16)                               */
#define LEDTS_ID_MOD_NUMBER_Msk               (0xffff0000UL)            /*!< LEDTS ID: MOD_NUMBER (Bitfield-Mask: 0xffff)                */

/* --------------------------------  LEDTS_GLOBCTL  ------------------------------- */
#define LEDTS_GLOBCTL_TS_EN_Pos               (0UL)                     /*!< LEDTS GLOBCTL: TS_EN (Bit 0)                                */
#define LEDTS_GLOBCTL_TS_EN_Msk               (0x1UL)                   /*!< LEDTS GLOBCTL: TS_EN (Bitfield-Mask: 0x01)                  */
#define LEDTS_GLOBCTL_LD_EN_Pos               (1UL)                     /*!< LEDTS GLOBCTL: LD_EN (Bit 1)                                */
#define LEDTS_GLOBCTL_LD_EN_Msk               (0x2UL)                   /*!< LEDTS GLOBCTL: LD_EN (Bitfield-Mask: 0x01)                  */
#define LEDTS_GLOBCTL_CMTR_Pos                (2UL)                     /*!< LEDTS GLOBCTL: CMTR (Bit 2)                                 */
#define LEDTS_GLOBCTL_CMTR_Msk                (0x4UL)                   /*!< LEDTS GLOBCTL: CMTR (Bitfield-Mask: 0x01)                   */
#define LEDTS_GLOBCTL_ENSYNC_Pos              (3UL)                     /*!< LEDTS GLOBCTL: ENSYNC (Bit 3)                               */
#define LEDTS_GLOBCTL_ENSYNC_Msk              (0x8UL)                   /*!< LEDTS GLOBCTL: ENSYNC (Bitfield-Mask: 0x01)                 */
#define LEDTS_GLOBCTL_SUSCFG_Pos              (8UL)                     /*!< LEDTS GLOBCTL: SUSCFG (Bit 8)                               */
#define LEDTS_GLOBCTL_SUSCFG_Msk              (0x100UL)                 /*!< LEDTS GLOBCTL: SUSCFG (Bitfield-Mask: 0x01)                 */
#define LEDTS_GLOBCTL_MASKVAL_Pos             (9UL)                     /*!< LEDTS GLOBCTL: MASKVAL (Bit 9)                              */
#define LEDTS_GLOBCTL_MASKVAL_Msk             (0xe00UL)                 /*!< LEDTS GLOBCTL: MASKVAL (Bitfield-Mask: 0x07)                */
#define LEDTS_GLOBCTL_FENVAL_Pos              (12UL)                    /*!< LEDTS GLOBCTL: FENVAL (Bit 12)                              */
#define LEDTS_GLOBCTL_FENVAL_Msk              (0x1000UL)                /*!< LEDTS GLOBCTL: FENVAL (Bitfield-Mask: 0x01)                 */
#define LEDTS_GLOBCTL_ITS_EN_Pos              (13UL)                    /*!< LEDTS GLOBCTL: ITS_EN (Bit 13)                              */
#define LEDTS_GLOBCTL_ITS_EN_Msk              (0x2000UL)                /*!< LEDTS GLOBCTL: ITS_EN (Bitfield-Mask: 0x01)                 */
#define LEDTS_GLOBCTL_ITF_EN_Pos              (14UL)                    /*!< LEDTS GLOBCTL: ITF_EN (Bit 14)                              */
#define LEDTS_GLOBCTL_ITF_EN_Msk              (0x4000UL)                /*!< LEDTS GLOBCTL: ITF_EN (Bitfield-Mask: 0x01)                 */
#define LEDTS_GLOBCTL_ITP_EN_Pos              (15UL)                    /*!< LEDTS GLOBCTL: ITP_EN (Bit 15)                              */
#define LEDTS_GLOBCTL_ITP_EN_Msk              (0x8000UL)                /*!< LEDTS GLOBCTL: ITP_EN (Bitfield-Mask: 0x01)                 */
#define LEDTS_GLOBCTL_CLK_PS_Pos              (16UL)                    /*!< LEDTS GLOBCTL: CLK_PS (Bit 16)                              */
#define LEDTS_GLOBCTL_CLK_PS_Msk              (0xffff0000UL)            /*!< LEDTS GLOBCTL: CLK_PS (Bitfield-Mask: 0xffff)               */

/* ---------------------------------  LEDTS_FNCTL  -------------------------------- */
#define LEDTS_FNCTL_PADT_Pos                  (0UL)                     /*!< LEDTS FNCTL: PADT (Bit 0)                                   */
#define LEDTS_FNCTL_PADT_Msk                  (0x7UL)                   /*!< LEDTS FNCTL: PADT (Bitfield-Mask: 0x07)                     */
#define LEDTS_FNCTL_PADTSW_Pos                (3UL)                     /*!< LEDTS FNCTL: PADTSW (Bit 3)                                 */
#define LEDTS_FNCTL_PADTSW_Msk                (0x8UL)                   /*!< LEDTS FNCTL: PADTSW (Bitfield-Mask: 0x01)                   */
#define LEDTS_FNCTL_EPULL_Pos                 (4UL)                     /*!< LEDTS FNCTL: EPULL (Bit 4)                                  */
#define LEDTS_FNCTL_EPULL_Msk                 (0x10UL)                  /*!< LEDTS FNCTL: EPULL (Bitfield-Mask: 0x01)                    */
#define LEDTS_FNCTL_FNCOL_Pos                 (5UL)                     /*!< LEDTS FNCTL: FNCOL (Bit 5)                                  */
#define LEDTS_FNCTL_FNCOL_Msk                 (0xe0UL)                  /*!< LEDTS FNCTL: FNCOL (Bitfield-Mask: 0x07)                    */
#define LEDTS_FNCTL_ACCCNT_Pos                (16UL)                    /*!< LEDTS FNCTL: ACCCNT (Bit 16)                                */
#define LEDTS_FNCTL_ACCCNT_Msk                (0xf0000UL)               /*!< LEDTS FNCTL: ACCCNT (Bitfield-Mask: 0x0f)                   */
#define LEDTS_FNCTL_TSCCMP_Pos                (20UL)                    /*!< LEDTS FNCTL: TSCCMP (Bit 20)                                */
#define LEDTS_FNCTL_TSCCMP_Msk                (0x100000UL)              /*!< LEDTS FNCTL: TSCCMP (Bitfield-Mask: 0x01)                   */
#define LEDTS_FNCTL_TSOEXT_Pos                (21UL)                    /*!< LEDTS FNCTL: TSOEXT (Bit 21)                                */
#define LEDTS_FNCTL_TSOEXT_Msk                (0x600000UL)              /*!< LEDTS FNCTL: TSOEXT (Bitfield-Mask: 0x03)                   */
#define LEDTS_FNCTL_TSCTRR_Pos                (23UL)                    /*!< LEDTS FNCTL: TSCTRR (Bit 23)                                */
#define LEDTS_FNCTL_TSCTRR_Msk                (0x800000UL)              /*!< LEDTS FNCTL: TSCTRR (Bitfield-Mask: 0x01)                   */
#define LEDTS_FNCTL_TSCTRSAT_Pos              (24UL)                    /*!< LEDTS FNCTL: TSCTRSAT (Bit 24)                              */
#define LEDTS_FNCTL_TSCTRSAT_Msk              (0x1000000UL)             /*!< LEDTS FNCTL: TSCTRSAT (Bitfield-Mask: 0x01)                 */
#define LEDTS_FNCTL_NR_TSIN_Pos               (25UL)                    /*!< LEDTS FNCTL: NR_TSIN (Bit 25)                               */
#define LEDTS_FNCTL_NR_TSIN_Msk               (0xe000000UL)             /*!< LEDTS FNCTL: NR_TSIN (Bitfield-Mask: 0x07)                  */
#define LEDTS_FNCTL_COLLEV_Pos                (28UL)                    /*!< LEDTS FNCTL: COLLEV (Bit 28)                                */
#define LEDTS_FNCTL_COLLEV_Msk                (0x10000000UL)            /*!< LEDTS FNCTL: COLLEV (Bitfield-Mask: 0x01)                   */
#define LEDTS_FNCTL_NR_LEDCOL_Pos             (29UL)                    /*!< LEDTS FNCTL: NR_LEDCOL (Bit 29)                             */
#define LEDTS_FNCTL_NR_LEDCOL_Msk             (0xe0000000UL)            /*!< LEDTS FNCTL: NR_LEDCOL (Bitfield-Mask: 0x07)                */

/* ---------------------------------  LEDTS_EVFR  --------------------------------- */
#define LEDTS_EVFR_TSF_Pos                    (0UL)                     /*!< LEDTS EVFR: TSF (Bit 0)                                     */
#define LEDTS_EVFR_TSF_Msk                    (0x1UL)                   /*!< LEDTS EVFR: TSF (Bitfield-Mask: 0x01)                       */
#define LEDTS_EVFR_TFF_Pos                    (1UL)                     /*!< LEDTS EVFR: TFF (Bit 1)                                     */
#define LEDTS_EVFR_TFF_Msk                    (0x2UL)                   /*!< LEDTS EVFR: TFF (Bitfield-Mask: 0x01)                       */
#define LEDTS_EVFR_TPF_Pos                    (2UL)                     /*!< LEDTS EVFR: TPF (Bit 2)                                     */
#define LEDTS_EVFR_TPF_Msk                    (0x4UL)                   /*!< LEDTS EVFR: TPF (Bitfield-Mask: 0x01)                       */
#define LEDTS_EVFR_TSCTROVF_Pos               (3UL)                     /*!< LEDTS EVFR: TSCTROVF (Bit 3)                                */
#define LEDTS_EVFR_TSCTROVF_Msk               (0x8UL)                   /*!< LEDTS EVFR: TSCTROVF (Bitfield-Mask: 0x01)                  */
#define LEDTS_EVFR_CTSF_Pos                   (16UL)                    /*!< LEDTS EVFR: CTSF (Bit 16)                                   */
#define LEDTS_EVFR_CTSF_Msk                   (0x10000UL)               /*!< LEDTS EVFR: CTSF (Bitfield-Mask: 0x01)                      */
#define LEDTS_EVFR_CTFF_Pos                   (17UL)                    /*!< LEDTS EVFR: CTFF (Bit 17)                                   */
#define LEDTS_EVFR_CTFF_Msk                   (0x20000UL)               /*!< LEDTS EVFR: CTFF (Bitfield-Mask: 0x01)                      */
#define LEDTS_EVFR_CTPF_Pos                   (18UL)                    /*!< LEDTS EVFR: CTPF (Bit 18)                                   */
#define LEDTS_EVFR_CTPF_Msk                   (0x40000UL)               /*!< LEDTS EVFR: CTPF (Bitfield-Mask: 0x01)                      */

/* ---------------------------------  LEDTS_TSVAL  -------------------------------- */
#define LEDTS_TSVAL_TSCTRVALR_Pos             (0UL)                     /*!< LEDTS TSVAL: TSCTRVALR (Bit 0)                              */
#define LEDTS_TSVAL_TSCTRVALR_Msk             (0xffffUL)                /*!< LEDTS TSVAL: TSCTRVALR (Bitfield-Mask: 0xffff)              */
#define LEDTS_TSVAL_TSCTRVAL_Pos              (16UL)                    /*!< LEDTS TSVAL: TSCTRVAL (Bit 16)                              */
#define LEDTS_TSVAL_TSCTRVAL_Msk              (0xffff0000UL)            /*!< LEDTS TSVAL: TSCTRVAL (Bitfield-Mask: 0xffff)               */

/* ---------------------------------  LEDTS_LINE0  -------------------------------- */
#define LEDTS_LINE0_LINE_0_Pos                (0UL)                     /*!< LEDTS LINE0: LINE_0 (Bit 0)                                 */
#define LEDTS_LINE0_LINE_0_Msk                (0xffUL)                  /*!< LEDTS LINE0: LINE_0 (Bitfield-Mask: 0xff)                   */
#define LEDTS_LINE0_LINE_1_Pos                (8UL)                     /*!< LEDTS LINE0: LINE_1 (Bit 8)                                 */
#define LEDTS_LINE0_LINE_1_Msk                (0xff00UL)                /*!< LEDTS LINE0: LINE_1 (Bitfield-Mask: 0xff)                   */
#define LEDTS_LINE0_LINE_2_Pos                (16UL)                    /*!< LEDTS LINE0: LINE_2 (Bit 16)                                */
#define LEDTS_LINE0_LINE_2_Msk                (0xff0000UL)              /*!< LEDTS LINE0: LINE_2 (Bitfield-Mask: 0xff)                   */
#define LEDTS_LINE0_LINE_3_Pos                (24UL)                    /*!< LEDTS LINE0: LINE_3 (Bit 24)                                */
#define LEDTS_LINE0_LINE_3_Msk                (0xff000000UL)            /*!< LEDTS LINE0: LINE_3 (Bitfield-Mask: 0xff)                   */

/* ---------------------------------  LEDTS_LINE1  -------------------------------- */
#define LEDTS_LINE1_LINE_4_Pos                (0UL)                     /*!< LEDTS LINE1: LINE_4 (Bit 0)                                 */
#define LEDTS_LINE1_LINE_4_Msk                (0xffUL)                  /*!< LEDTS LINE1: LINE_4 (Bitfield-Mask: 0xff)                   */
#define LEDTS_LINE1_LINE_5_Pos                (8UL)                     /*!< LEDTS LINE1: LINE_5 (Bit 8)                                 */
#define LEDTS_LINE1_LINE_5_Msk                (0xff00UL)                /*!< LEDTS LINE1: LINE_5 (Bitfield-Mask: 0xff)                   */
#define LEDTS_LINE1_LINE_6_Pos                (16UL)                    /*!< LEDTS LINE1: LINE_6 (Bit 16)                                */
#define LEDTS_LINE1_LINE_6_Msk                (0xff0000UL)              /*!< LEDTS LINE1: LINE_6 (Bitfield-Mask: 0xff)                   */
#define LEDTS_LINE1_LINE_A_Pos                (24UL)                    /*!< LEDTS LINE1: LINE_A (Bit 24)                                */
#define LEDTS_LINE1_LINE_A_Msk                (0xff000000UL)            /*!< LEDTS LINE1: LINE_A (Bitfield-Mask: 0xff)                   */

/* --------------------------------  LEDTS_LDCMP0  -------------------------------- */
#define LEDTS_LDCMP0_CMP_LD0_Pos              (0UL)                     /*!< LEDTS LDCMP0: CMP_LD0 (Bit 0)                               */
#define LEDTS_LDCMP0_CMP_LD0_Msk              (0xffUL)                  /*!< LEDTS LDCMP0: CMP_LD0 (Bitfield-Mask: 0xff)                 */
#define LEDTS_LDCMP0_CMP_LD1_Pos              (8UL)                     /*!< LEDTS LDCMP0: CMP_LD1 (Bit 8)                               */
#define LEDTS_LDCMP0_CMP_LD1_Msk              (0xff00UL)                /*!< LEDTS LDCMP0: CMP_LD1 (Bitfield-Mask: 0xff)                 */
#define LEDTS_LDCMP0_CMP_LD2_Pos              (16UL)                    /*!< LEDTS LDCMP0: CMP_LD2 (Bit 16)                              */
#define LEDTS_LDCMP0_CMP_LD2_Msk              (0xff0000UL)              /*!< LEDTS LDCMP0: CMP_LD2 (Bitfield-Mask: 0xff)                 */
#define LEDTS_LDCMP0_CMP_LD3_Pos              (24UL)                    /*!< LEDTS LDCMP0: CMP_LD3 (Bit 24)                              */
#define LEDTS_LDCMP0_CMP_LD3_Msk              (0xff000000UL)            /*!< LEDTS LDCMP0: CMP_LD3 (Bitfield-Mask: 0xff)                 */

/* --------------------------------  LEDTS_LDCMP1  -------------------------------- */
#define LEDTS_LDCMP1_CMP_LD4_Pos              (0UL)                     /*!< LEDTS LDCMP1: CMP_LD4 (Bit 0)                               */
#define LEDTS_LDCMP1_CMP_LD4_Msk              (0xffUL)                  /*!< LEDTS LDCMP1: CMP_LD4 (Bitfield-Mask: 0xff)                 */
#define LEDTS_LDCMP1_CMP_LD5_Pos              (8UL)                     /*!< LEDTS LDCMP1: CMP_LD5 (Bit 8)                               */
#define LEDTS_LDCMP1_CMP_LD5_Msk              (0xff00UL)                /*!< LEDTS LDCMP1: CMP_LD5 (Bitfield-Mask: 0xff)                 */
#define LEDTS_LDCMP1_CMP_LD6_Pos              (16UL)                    /*!< LEDTS LDCMP1: CMP_LD6 (Bit 16)                              */
#define LEDTS_LDCMP1_CMP_LD6_Msk              (0xff0000UL)              /*!< LEDTS LDCMP1: CMP_LD6 (Bitfield-Mask: 0xff)                 */
#define LEDTS_LDCMP1_CMP_LDA_TSCOM_Pos        (24UL)                    /*!< LEDTS LDCMP1: CMP_LDA_TSCOM (Bit 24)                        */
#define LEDTS_LDCMP1_CMP_LDA_TSCOM_Msk        (0xff000000UL)            /*!< LEDTS LDCMP1: CMP_LDA_TSCOM (Bitfield-Mask: 0xff)           */

/* --------------------------------  LEDTS_TSCMP0  -------------------------------- */
#define LEDTS_TSCMP0_CMP_TS0_Pos              (0UL)                     /*!< LEDTS TSCMP0: CMP_TS0 (Bit 0)                               */
#define LEDTS_TSCMP0_CMP_TS0_Msk              (0xffUL)                  /*!< LEDTS TSCMP0: CMP_TS0 (Bitfield-Mask: 0xff)                 */
#define LEDTS_TSCMP0_CMP_TS1_Pos              (8UL)                     /*!< LEDTS TSCMP0: CMP_TS1 (Bit 8)                               */
#define LEDTS_TSCMP0_CMP_TS1_Msk              (0xff00UL)                /*!< LEDTS TSCMP0: CMP_TS1 (Bitfield-Mask: 0xff)                 */
#define LEDTS_TSCMP0_CMP_TS2_Pos              (16UL)                    /*!< LEDTS TSCMP0: CMP_TS2 (Bit 16)                              */
#define LEDTS_TSCMP0_CMP_TS2_Msk              (0xff0000UL)              /*!< LEDTS TSCMP0: CMP_TS2 (Bitfield-Mask: 0xff)                 */
#define LEDTS_TSCMP0_CMP_TS3_Pos              (24UL)                    /*!< LEDTS TSCMP0: CMP_TS3 (Bit 24)                              */
#define LEDTS_TSCMP0_CMP_TS3_Msk              (0xff000000UL)            /*!< LEDTS TSCMP0: CMP_TS3 (Bitfield-Mask: 0xff)                 */

/* --------------------------------  LEDTS_TSCMP1  -------------------------------- */
#define LEDTS_TSCMP1_CMP_TS4_Pos              (0UL)                     /*!< LEDTS TSCMP1: CMP_TS4 (Bit 0)                               */
#define LEDTS_TSCMP1_CMP_TS4_Msk              (0xffUL)                  /*!< LEDTS TSCMP1: CMP_TS4 (Bitfield-Mask: 0xff)                 */
#define LEDTS_TSCMP1_CMP_TS5_Pos              (8UL)                     /*!< LEDTS TSCMP1: CMP_TS5 (Bit 8)                               */
#define LEDTS_TSCMP1_CMP_TS5_Msk              (0xff00UL)                /*!< LEDTS TSCMP1: CMP_TS5 (Bitfield-Mask: 0xff)                 */
#define LEDTS_TSCMP1_CMP_TS6_Pos              (16UL)                    /*!< LEDTS TSCMP1: CMP_TS6 (Bit 16)                              */
#define LEDTS_TSCMP1_CMP_TS6_Msk              (0xff0000UL)              /*!< LEDTS TSCMP1: CMP_TS6 (Bitfield-Mask: 0xff)                 */
#define LEDTS_TSCMP1_CMP_TS7_Pos              (24UL)                    /*!< LEDTS TSCMP1: CMP_TS7 (Bit 24)                              */
#define LEDTS_TSCMP1_CMP_TS7_Msk              (0xff000000UL)            /*!< LEDTS TSCMP1: CMP_TS7 (Bitfield-Mask: 0xff)                 */


/* ================================================================================ */
/* ================        struct 'ETH0_CON' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  ETH0_CON_ETH0_CON  ----------------------------- */
#define ETH_CON_RXD0_Pos            (0UL)                     /*!< ETH0_CON ETH0_CON: RXD0 (Bit 0)                             */
#define ETH_CON_RXD0_Msk            (0x3UL)                   /*!< ETH0_CON ETH0_CON: RXD0 (Bitfield-Mask: 0x03)               */
#define ETH_CON_RXD1_Pos            (2UL)                     /*!< ETH0_CON ETH0_CON: RXD1 (Bit 2)                             */
#define ETH_CON_RXD1_Msk            (0xcUL)                   /*!< ETH0_CON ETH0_CON: RXD1 (Bitfield-Mask: 0x03)               */
#define ETH_CON_RXD2_Pos            (4UL)                     /*!< ETH0_CON ETH0_CON: RXD2 (Bit 4)                             */
#define ETH_CON_RXD2_Msk            (0x30UL)                  /*!< ETH0_CON ETH0_CON: RXD2 (Bitfield-Mask: 0x03)               */
#define ETH_CON_RXD3_Pos            (6UL)                     /*!< ETH0_CON ETH0_CON: RXD3 (Bit 6)                             */
#define ETH_CON_RXD3_Msk            (0xc0UL)                  /*!< ETH0_CON ETH0_CON: RXD3 (Bitfield-Mask: 0x03)               */
#define ETH_CON_CLK_RMII_Pos        (8UL)                     /*!< ETH0_CON ETH0_CON: CLK_RMII (Bit 8)                         */
#define ETH_CON_CLK_RMII_Msk        (0x300UL)                 /*!< ETH0_CON ETH0_CON: CLK_RMII (Bitfield-Mask: 0x03)           */
#define ETH_CON_CRS_DV_Pos          (10UL)                    /*!< ETH0_CON ETH0_CON: CRS_DV (Bit 10)                          */
#define ETH_CON_CRS_DV_Msk          (0xc00UL)                 /*!< ETH0_CON ETH0_CON: CRS_DV (Bitfield-Mask: 0x03)             */
#define ETH_CON_CRS_Pos             (12UL)                    /*!< ETH0_CON ETH0_CON: CRS (Bit 12)                             */
#define ETH_CON_CRS_Msk             (0x3000UL)                /*!< ETH0_CON ETH0_CON: CRS (Bitfield-Mask: 0x03)                */
#define ETH_CON_RXER_Pos            (14UL)                    /*!< ETH0_CON ETH0_CON: RXER (Bit 14)                            */
#define ETH_CON_RXER_Msk            (0xc000UL)                /*!< ETH0_CON ETH0_CON: RXER (Bitfield-Mask: 0x03)               */
#define ETH_CON_COL_Pos             (16UL)                    /*!< ETH0_CON ETH0_CON: COL (Bit 16)                             */
#define ETH_CON_COL_Msk             (0x30000UL)               /*!< ETH0_CON ETH0_CON: COL (Bitfield-Mask: 0x03)                */
#define ETH_CON_CLK_TX_Pos          (18UL)                    /*!< ETH0_CON ETH0_CON: CLK_TX (Bit 18)                          */
#define ETH_CON_CLK_TX_Msk          (0xc0000UL)               /*!< ETH0_CON ETH0_CON: CLK_TX (Bitfield-Mask: 0x03)             */
#define ETH_CON_MDIO_Pos            (22UL)                    /*!< ETH0_CON ETH0_CON: MDIO (Bit 22)                            */
#define ETH_CON_MDIO_Msk            (0xc00000UL)              /*!< ETH0_CON ETH0_CON: MDIO (Bitfield-Mask: 0x03)               */
#define ETH_CON_INFSEL_Pos          (26UL)                    /*!< ETH0_CON ETH0_CON: INFSEL (Bit 26)                          */
#define ETH_CON_INFSEL_Msk          (0x4000000UL)             /*!< ETH0_CON ETH0_CON: INFSEL (Bitfield-Mask: 0x01)             */


/* ================================================================================ */
/* ================           Group 'ETH' Position & Mask          ================ */
/* ================================================================================ */


/* ----------------------------  ETH_MAC_CONFIGURATION  --------------------------- */
#define ETH_MAC_CONFIGURATION_PRELEN_Pos      (0UL)                     /*!< ETH MAC_CONFIGURATION: PRELEN (Bit 0)                       */
#define ETH_MAC_CONFIGURATION_PRELEN_Msk      (0x3UL)                   /*!< ETH MAC_CONFIGURATION: PRELEN (Bitfield-Mask: 0x03)         */
#define ETH_MAC_CONFIGURATION_RE_Pos          (2UL)                     /*!< ETH MAC_CONFIGURATION: RE (Bit 2)                           */
#define ETH_MAC_CONFIGURATION_RE_Msk          (0x4UL)                   /*!< ETH MAC_CONFIGURATION: RE (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_TE_Pos          (3UL)                     /*!< ETH MAC_CONFIGURATION: TE (Bit 3)                           */
#define ETH_MAC_CONFIGURATION_TE_Msk          (0x8UL)                   /*!< ETH MAC_CONFIGURATION: TE (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_DC_Pos          (4UL)                     /*!< ETH MAC_CONFIGURATION: DC (Bit 4)                           */
#define ETH_MAC_CONFIGURATION_DC_Msk          (0x10UL)                  /*!< ETH MAC_CONFIGURATION: DC (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_BL_Pos          (5UL)                     /*!< ETH MAC_CONFIGURATION: BL (Bit 5)                           */
#define ETH_MAC_CONFIGURATION_BL_Msk          (0x60UL)                  /*!< ETH MAC_CONFIGURATION: BL (Bitfield-Mask: 0x03)             */
#define ETH_MAC_CONFIGURATION_ACS_Pos         (7UL)                     /*!< ETH MAC_CONFIGURATION: ACS (Bit 7)                          */
#define ETH_MAC_CONFIGURATION_ACS_Msk         (0x80UL)                  /*!< ETH MAC_CONFIGURATION: ACS (Bitfield-Mask: 0x01)            */
#define ETH_MAC_CONFIGURATION_DR_Pos          (9UL)                     /*!< ETH MAC_CONFIGURATION: DR (Bit 9)                           */
#define ETH_MAC_CONFIGURATION_DR_Msk          (0x200UL)                 /*!< ETH MAC_CONFIGURATION: DR (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_IPC_Pos         (10UL)                    /*!< ETH MAC_CONFIGURATION: IPC (Bit 10)                         */
#define ETH_MAC_CONFIGURATION_IPC_Msk         (0x400UL)                 /*!< ETH MAC_CONFIGURATION: IPC (Bitfield-Mask: 0x01)            */
#define ETH_MAC_CONFIGURATION_DM_Pos          (11UL)                    /*!< ETH MAC_CONFIGURATION: DM (Bit 11)                          */
#define ETH_MAC_CONFIGURATION_DM_Msk          (0x800UL)                 /*!< ETH MAC_CONFIGURATION: DM (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_LM_Pos          (12UL)                    /*!< ETH MAC_CONFIGURATION: LM (Bit 12)                          */
#define ETH_MAC_CONFIGURATION_LM_Msk          (0x1000UL)                /*!< ETH MAC_CONFIGURATION: LM (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_DO_Pos          (13UL)                    /*!< ETH MAC_CONFIGURATION: DO (Bit 13)                          */
#define ETH_MAC_CONFIGURATION_DO_Msk          (0x2000UL)                /*!< ETH MAC_CONFIGURATION: DO (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_FES_Pos         (14UL)                    /*!< ETH MAC_CONFIGURATION: FES (Bit 14)                         */
#define ETH_MAC_CONFIGURATION_FES_Msk         (0x4000UL)                /*!< ETH MAC_CONFIGURATION: FES (Bitfield-Mask: 0x01)            */
#define ETH_MAC_CONFIGURATION_DCRS_Pos        (16UL)                    /*!< ETH MAC_CONFIGURATION: DCRS (Bit 16)                        */
#define ETH_MAC_CONFIGURATION_DCRS_Msk        (0x10000UL)               /*!< ETH MAC_CONFIGURATION: DCRS (Bitfield-Mask: 0x01)           */
#define ETH_MAC_CONFIGURATION_IFG_Pos         (17UL)                    /*!< ETH MAC_CONFIGURATION: IFG (Bit 17)                         */
#define ETH_MAC_CONFIGURATION_IFG_Msk         (0xe0000UL)               /*!< ETH MAC_CONFIGURATION: IFG (Bitfield-Mask: 0x07)            */
#define ETH_MAC_CONFIGURATION_JE_Pos          (20UL)                    /*!< ETH MAC_CONFIGURATION: JE (Bit 20)                          */
#define ETH_MAC_CONFIGURATION_JE_Msk          (0x100000UL)              /*!< ETH MAC_CONFIGURATION: JE (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_BE_Pos          (21UL)                    /*!< ETH MAC_CONFIGURATION: BE (Bit 21)                          */
#define ETH_MAC_CONFIGURATION_BE_Msk          (0x200000UL)              /*!< ETH MAC_CONFIGURATION: BE (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_JD_Pos          (22UL)                    /*!< ETH MAC_CONFIGURATION: JD (Bit 22)                          */
#define ETH_MAC_CONFIGURATION_JD_Msk          (0x400000UL)              /*!< ETH MAC_CONFIGURATION: JD (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_WD_Pos          (23UL)                    /*!< ETH MAC_CONFIGURATION: WD (Bit 23)                          */
#define ETH_MAC_CONFIGURATION_WD_Msk          (0x800000UL)              /*!< ETH MAC_CONFIGURATION: WD (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_TC_Pos          (24UL)                    /*!< ETH MAC_CONFIGURATION: TC (Bit 24)                          */
#define ETH_MAC_CONFIGURATION_TC_Msk          (0x1000000UL)             /*!< ETH MAC_CONFIGURATION: TC (Bitfield-Mask: 0x01)             */
#define ETH_MAC_CONFIGURATION_CST_Pos         (25UL)                    /*!< ETH MAC_CONFIGURATION: CST (Bit 25)                         */
#define ETH_MAC_CONFIGURATION_CST_Msk         (0x2000000UL)             /*!< ETH MAC_CONFIGURATION: CST (Bitfield-Mask: 0x01)            */
#define ETH_MAC_CONFIGURATION_TWOKPE_Pos      (27UL)                    /*!< ETH MAC_CONFIGURATION: TWOKPE (Bit 27)                      */
#define ETH_MAC_CONFIGURATION_TWOKPE_Msk      (0x8000000UL)             /*!< ETH MAC_CONFIGURATION: TWOKPE (Bitfield-Mask: 0x01)         */
#define ETH_MAC_CONFIGURATION_SARC_Pos        (28UL)                    /*!< ETH MAC_CONFIGURATION: SARC (Bit 28)                        */
#define ETH_MAC_CONFIGURATION_SARC_Msk        (0x70000000UL)            /*!< ETH MAC_CONFIGURATION: SARC (Bitfield-Mask: 0x07)           */

/* ----------------------------  ETH_MAC_FRAME_FILTER  ---------------------------- */
#define ETH_MAC_FRAME_FILTER_PR_Pos           (0UL)                     /*!< ETH MAC_FRAME_FILTER: PR (Bit 0)                            */
#define ETH_MAC_FRAME_FILTER_PR_Msk           (0x1UL)                   /*!< ETH MAC_FRAME_FILTER: PR (Bitfield-Mask: 0x01)              */
#define ETH_MAC_FRAME_FILTER_HUC_Pos          (1UL)                     /*!< ETH MAC_FRAME_FILTER: HUC (Bit 1)                           */
#define ETH_MAC_FRAME_FILTER_HUC_Msk          (0x2UL)                   /*!< ETH MAC_FRAME_FILTER: HUC (Bitfield-Mask: 0x01)             */
#define ETH_MAC_FRAME_FILTER_HMC_Pos          (2UL)                     /*!< ETH MAC_FRAME_FILTER: HMC (Bit 2)                           */
#define ETH_MAC_FRAME_FILTER_HMC_Msk          (0x4UL)                   /*!< ETH MAC_FRAME_FILTER: HMC (Bitfield-Mask: 0x01)             */
#define ETH_MAC_FRAME_FILTER_DAIF_Pos         (3UL)                     /*!< ETH MAC_FRAME_FILTER: DAIF (Bit 3)                          */
#define ETH_MAC_FRAME_FILTER_DAIF_Msk         (0x8UL)                   /*!< ETH MAC_FRAME_FILTER: DAIF (Bitfield-Mask: 0x01)            */
#define ETH_MAC_FRAME_FILTER_PM_Pos           (4UL)                     /*!< ETH MAC_FRAME_FILTER: PM (Bit 4)                            */
#define ETH_MAC_FRAME_FILTER_PM_Msk           (0x10UL)                  /*!< ETH MAC_FRAME_FILTER: PM (Bitfield-Mask: 0x01)              */
#define ETH_MAC_FRAME_FILTER_DBF_Pos          (5UL)                     /*!< ETH MAC_FRAME_FILTER: DBF (Bit 5)                           */
#define ETH_MAC_FRAME_FILTER_DBF_Msk          (0x20UL)                  /*!< ETH MAC_FRAME_FILTER: DBF (Bitfield-Mask: 0x01)             */
#define ETH_MAC_FRAME_FILTER_PCF_Pos          (6UL)                     /*!< ETH MAC_FRAME_FILTER: PCF (Bit 6)                           */
#define ETH_MAC_FRAME_FILTER_PCF_Msk          (0xc0UL)                  /*!< ETH MAC_FRAME_FILTER: PCF (Bitfield-Mask: 0x03)             */
#define ETH_MAC_FRAME_FILTER_SAIF_Pos         (8UL)                     /*!< ETH MAC_FRAME_FILTER: SAIF (Bit 8)                          */
#define ETH_MAC_FRAME_FILTER_SAIF_Msk         (0x100UL)                 /*!< ETH MAC_FRAME_FILTER: SAIF (Bitfield-Mask: 0x01)            */
#define ETH_MAC_FRAME_FILTER_SAF_Pos          (9UL)                     /*!< ETH MAC_FRAME_FILTER: SAF (Bit 9)                           */
#define ETH_MAC_FRAME_FILTER_SAF_Msk          (0x200UL)                 /*!< ETH MAC_FRAME_FILTER: SAF (Bitfield-Mask: 0x01)             */
#define ETH_MAC_FRAME_FILTER_HPF_Pos          (10UL)                    /*!< ETH MAC_FRAME_FILTER: HPF (Bit 10)                          */
#define ETH_MAC_FRAME_FILTER_HPF_Msk          (0x400UL)                 /*!< ETH MAC_FRAME_FILTER: HPF (Bitfield-Mask: 0x01)             */
#define ETH_MAC_FRAME_FILTER_VTFE_Pos         (16UL)                    /*!< ETH MAC_FRAME_FILTER: VTFE (Bit 16)                         */
#define ETH_MAC_FRAME_FILTER_VTFE_Msk         (0x10000UL)               /*!< ETH MAC_FRAME_FILTER: VTFE (Bitfield-Mask: 0x01)            */
#define ETH_MAC_FRAME_FILTER_IPFE_Pos         (20UL)                    /*!< ETH MAC_FRAME_FILTER: IPFE (Bit 20)                         */
#define ETH_MAC_FRAME_FILTER_IPFE_Msk         (0x100000UL)              /*!< ETH MAC_FRAME_FILTER: IPFE (Bitfield-Mask: 0x01)            */
#define ETH_MAC_FRAME_FILTER_DNTU_Pos         (21UL)                    /*!< ETH MAC_FRAME_FILTER: DNTU (Bit 21)                         */
#define ETH_MAC_FRAME_FILTER_DNTU_Msk         (0x200000UL)              /*!< ETH MAC_FRAME_FILTER: DNTU (Bitfield-Mask: 0x01)            */
#define ETH_MAC_FRAME_FILTER_RA_Pos           (31UL)                    /*!< ETH MAC_FRAME_FILTER: RA (Bit 31)                           */
#define ETH_MAC_FRAME_FILTER_RA_Msk           (0x80000000UL)            /*!< ETH MAC_FRAME_FILTER: RA (Bitfield-Mask: 0x01)              */

/* -----------------------------  ETH_HASH_TABLE_HIGH  ---------------------------- */
#define ETH_HASH_TABLE_HIGH_HTH_Pos           (0UL)                     /*!< ETH HASH_TABLE_HIGH: HTH (Bit 0)                            */
#define ETH_HASH_TABLE_HIGH_HTH_Msk           (0xffffffffUL)            /*!< ETH HASH_TABLE_HIGH: HTH (Bitfield-Mask: 0xffffffff)        */

/* -----------------------------  ETH_HASH_TABLE_LOW  ----------------------------- */
#define ETH_HASH_TABLE_LOW_HTL_Pos            (0UL)                     /*!< ETH HASH_TABLE_LOW: HTL (Bit 0)                             */
#define ETH_HASH_TABLE_LOW_HTL_Msk            (0xffffffffUL)            /*!< ETH HASH_TABLE_LOW: HTL (Bitfield-Mask: 0xffffffff)         */

/* ------------------------------  ETH_GMII_ADDRESS  ------------------------------ */
#define ETH_GMII_ADDRESS_MB_Pos               (0UL)                     /*!< ETH GMII_ADDRESS: MB (Bit 0)                                */
#define ETH_GMII_ADDRESS_MB_Msk               (0x1UL)                   /*!< ETH GMII_ADDRESS: MB (Bitfield-Mask: 0x01)                  */
#define ETH_GMII_ADDRESS_MW_Pos               (1UL)                     /*!< ETH GMII_ADDRESS: MW (Bit 1)                                */
#define ETH_GMII_ADDRESS_MW_Msk               (0x2UL)                   /*!< ETH GMII_ADDRESS: MW (Bitfield-Mask: 0x01)                  */
#define ETH_GMII_ADDRESS_CR_Pos               (2UL)                     /*!< ETH GMII_ADDRESS: CR (Bit 2)                                */
#define ETH_GMII_ADDRESS_CR_Msk               (0x3cUL)                  /*!< ETH GMII_ADDRESS: CR (Bitfield-Mask: 0x0f)                  */
#define ETH_GMII_ADDRESS_MR_Pos               (6UL)                     /*!< ETH GMII_ADDRESS: MR (Bit 6)                                */
#define ETH_GMII_ADDRESS_MR_Msk               (0x7c0UL)                 /*!< ETH GMII_ADDRESS: MR (Bitfield-Mask: 0x1f)                  */
#define ETH_GMII_ADDRESS_PA_Pos               (11UL)                    /*!< ETH GMII_ADDRESS: PA (Bit 11)                               */
#define ETH_GMII_ADDRESS_PA_Msk               (0xf800UL)                /*!< ETH GMII_ADDRESS: PA (Bitfield-Mask: 0x1f)                  */

/* --------------------------------  ETH_GMII_DATA  ------------------------------- */
#define ETH_GMII_DATA_MD_Pos                  (0UL)                     /*!< ETH GMII_DATA: MD (Bit 0)                                   */
#define ETH_GMII_DATA_MD_Msk                  (0xffffUL)                /*!< ETH GMII_DATA: MD (Bitfield-Mask: 0xffff)                   */

/* ------------------------------  ETH_FLOW_CONTROL  ------------------------------ */
#define ETH_FLOW_CONTROL_FCA_BPA_Pos          (0UL)                     /*!< ETH FLOW_CONTROL: FCA_BPA (Bit 0)                           */
#define ETH_FLOW_CONTROL_FCA_BPA_Msk          (0x1UL)                   /*!< ETH FLOW_CONTROL: FCA_BPA (Bitfield-Mask: 0x01)             */
#define ETH_FLOW_CONTROL_TFE_Pos              (1UL)                     /*!< ETH FLOW_CONTROL: TFE (Bit 1)                               */
#define ETH_FLOW_CONTROL_TFE_Msk              (0x2UL)                   /*!< ETH FLOW_CONTROL: TFE (Bitfield-Mask: 0x01)                 */
#define ETH_FLOW_CONTROL_RFE_Pos              (2UL)                     /*!< ETH FLOW_CONTROL: RFE (Bit 2)                               */
#define ETH_FLOW_CONTROL_RFE_Msk              (0x4UL)                   /*!< ETH FLOW_CONTROL: RFE (Bitfield-Mask: 0x01)                 */
#define ETH_FLOW_CONTROL_UP_Pos               (3UL)                     /*!< ETH FLOW_CONTROL: UP (Bit 3)                                */
#define ETH_FLOW_CONTROL_UP_Msk               (0x8UL)                   /*!< ETH FLOW_CONTROL: UP (Bitfield-Mask: 0x01)                  */
#define ETH_FLOW_CONTROL_PLT_Pos              (4UL)                     /*!< ETH FLOW_CONTROL: PLT (Bit 4)                               */
#define ETH_FLOW_CONTROL_PLT_Msk              (0x30UL)                  /*!< ETH FLOW_CONTROL: PLT (Bitfield-Mask: 0x03)                 */
#define ETH_FLOW_CONTROL_DZPQ_Pos             (7UL)                     /*!< ETH FLOW_CONTROL: DZPQ (Bit 7)                              */
#define ETH_FLOW_CONTROL_DZPQ_Msk             (0x80UL)                  /*!< ETH FLOW_CONTROL: DZPQ (Bitfield-Mask: 0x01)                */
#define ETH_FLOW_CONTROL_PT_Pos               (16UL)                    /*!< ETH FLOW_CONTROL: PT (Bit 16)                               */
#define ETH_FLOW_CONTROL_PT_Msk               (0xffff0000UL)            /*!< ETH FLOW_CONTROL: PT (Bitfield-Mask: 0xffff)                */

/* --------------------------------  ETH_VLAN_TAG  -------------------------------- */
#define ETH_VLAN_TAG_VL_Pos                   (0UL)                     /*!< ETH VLAN_TAG: VL (Bit 0)                                    */
#define ETH_VLAN_TAG_VL_Msk                   (0xffffUL)                /*!< ETH VLAN_TAG: VL (Bitfield-Mask: 0xffff)                    */
#define ETH_VLAN_TAG_ETV_Pos                  (16UL)                    /*!< ETH VLAN_TAG: ETV (Bit 16)                                  */
#define ETH_VLAN_TAG_ETV_Msk                  (0x10000UL)               /*!< ETH VLAN_TAG: ETV (Bitfield-Mask: 0x01)                     */
#define ETH_VLAN_TAG_VTIM_Pos                 (17UL)                    /*!< ETH VLAN_TAG: VTIM (Bit 17)                                 */
#define ETH_VLAN_TAG_VTIM_Msk                 (0x20000UL)               /*!< ETH VLAN_TAG: VTIM (Bitfield-Mask: 0x01)                    */
#define ETH_VLAN_TAG_ESVL_Pos                 (18UL)                    /*!< ETH VLAN_TAG: ESVL (Bit 18)                                 */
#define ETH_VLAN_TAG_ESVL_Msk                 (0x40000UL)               /*!< ETH VLAN_TAG: ESVL (Bitfield-Mask: 0x01)                    */
#define ETH_VLAN_TAG_VTHM_Pos                 (19UL)                    /*!< ETH VLAN_TAG: VTHM (Bit 19)                                 */
#define ETH_VLAN_TAG_VTHM_Msk                 (0x80000UL)               /*!< ETH VLAN_TAG: VTHM (Bitfield-Mask: 0x01)                    */

/* ---------------------------------  ETH_VERSION  -------------------------------- */
#define ETH_VERSION_SNPSVER_Pos               (0UL)                     /*!< ETH VERSION: SNPSVER (Bit 0)                                */
#define ETH_VERSION_SNPSVER_Msk               (0xffUL)                  /*!< ETH VERSION: SNPSVER (Bitfield-Mask: 0xff)                  */
#define ETH_VERSION_USERVER_Pos               (8UL)                     /*!< ETH VERSION: USERVER (Bit 8)                                */
#define ETH_VERSION_USERVER_Msk               (0xff00UL)                /*!< ETH VERSION: USERVER (Bitfield-Mask: 0xff)                  */

/* ----------------------------------  ETH_DEBUG  --------------------------------- */
#define ETH_DEBUG_RPESTS_Pos                  (0UL)                     /*!< ETH DEBUG: RPESTS (Bit 0)                                   */
#define ETH_DEBUG_RPESTS_Msk                  (0x1UL)                   /*!< ETH DEBUG: RPESTS (Bitfield-Mask: 0x01)                     */
#define ETH_DEBUG_RFCFCSTS_Pos                (1UL)                     /*!< ETH DEBUG: RFCFCSTS (Bit 1)                                 */
#define ETH_DEBUG_RFCFCSTS_Msk                (0x6UL)                   /*!< ETH DEBUG: RFCFCSTS (Bitfield-Mask: 0x03)                   */
#define ETH_DEBUG_RWCSTS_Pos                  (4UL)                     /*!< ETH DEBUG: RWCSTS (Bit 4)                                   */
#define ETH_DEBUG_RWCSTS_Msk                  (0x10UL)                  /*!< ETH DEBUG: RWCSTS (Bitfield-Mask: 0x01)                     */
#define ETH_DEBUG_RRCSTS_Pos                  (5UL)                     /*!< ETH DEBUG: RRCSTS (Bit 5)                                   */
#define ETH_DEBUG_RRCSTS_Msk                  (0x60UL)                  /*!< ETH DEBUG: RRCSTS (Bitfield-Mask: 0x03)                     */
#define ETH_DEBUG_RXFSTS_Pos                  (8UL)                     /*!< ETH DEBUG: RXFSTS (Bit 8)                                   */
#define ETH_DEBUG_RXFSTS_Msk                  (0x300UL)                 /*!< ETH DEBUG: RXFSTS (Bitfield-Mask: 0x03)                     */
#define ETH_DEBUG_TPESTS_Pos                  (16UL)                    /*!< ETH DEBUG: TPESTS (Bit 16)                                  */
#define ETH_DEBUG_TPESTS_Msk                  (0x10000UL)               /*!< ETH DEBUG: TPESTS (Bitfield-Mask: 0x01)                     */
#define ETH_DEBUG_TFCSTS_Pos                  (17UL)                    /*!< ETH DEBUG: TFCSTS (Bit 17)                                  */
#define ETH_DEBUG_TFCSTS_Msk                  (0x60000UL)               /*!< ETH DEBUG: TFCSTS (Bitfield-Mask: 0x03)                     */
#define ETH_DEBUG_TXPAUSED_Pos                (19UL)                    /*!< ETH DEBUG: TXPAUSED (Bit 19)                                */
#define ETH_DEBUG_TXPAUSED_Msk                (0x80000UL)               /*!< ETH DEBUG: TXPAUSED (Bitfield-Mask: 0x01)                   */
#define ETH_DEBUG_TRCSTS_Pos                  (20UL)                    /*!< ETH DEBUG: TRCSTS (Bit 20)                                  */
#define ETH_DEBUG_TRCSTS_Msk                  (0x300000UL)              /*!< ETH DEBUG: TRCSTS (Bitfield-Mask: 0x03)                     */
#define ETH_DEBUG_TWCSTS_Pos                  (22UL)                    /*!< ETH DEBUG: TWCSTS (Bit 22)                                  */
#define ETH_DEBUG_TWCSTS_Msk                  (0x400000UL)              /*!< ETH DEBUG: TWCSTS (Bitfield-Mask: 0x01)                     */
#define ETH_DEBUG_TXFSTS_Pos                  (24UL)                    /*!< ETH DEBUG: TXFSTS (Bit 24)                                  */
#define ETH_DEBUG_TXFSTS_Msk                  (0x1000000UL)             /*!< ETH DEBUG: TXFSTS (Bitfield-Mask: 0x01)                     */
#define ETH_DEBUG_TXSTSFSTS_Pos               (25UL)                    /*!< ETH DEBUG: TXSTSFSTS (Bit 25)                               */
#define ETH_DEBUG_TXSTSFSTS_Msk               (0x2000000UL)             /*!< ETH DEBUG: TXSTSFSTS (Bitfield-Mask: 0x01)                  */

/* -----------------------  ETH_REMOTE_WAKE_UP_FRAME_FILTER  ---------------------- */
#define ETH_REMOTE_WAKE_UP_FRAME_FILTER_WKUPFRMFTR_Pos (0UL)            /*!< ETH REMOTE_WAKE_UP_FRAME_FILTER: WKUPFRMFTR (Bit 0)         */
#define ETH_REMOTE_WAKE_UP_FRAME_FILTER_WKUPFRMFTR_Msk (0xffffffffUL)   /*!< ETH REMOTE_WAKE_UP_FRAME_FILTER: WKUPFRMFTR (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_PMT_CONTROL_STATUS  --------------------------- */
#define ETH_PMT_CONTROL_STATUS_PWRDWN_Pos     (0UL)                     /*!< ETH PMT_CONTROL_STATUS: PWRDWN (Bit 0)                      */
#define ETH_PMT_CONTROL_STATUS_PWRDWN_Msk     (0x1UL)                   /*!< ETH PMT_CONTROL_STATUS: PWRDWN (Bitfield-Mask: 0x01)        */
#define ETH_PMT_CONTROL_STATUS_MGKPKTEN_Pos   (1UL)                     /*!< ETH PMT_CONTROL_STATUS: MGKPKTEN (Bit 1)                    */
#define ETH_PMT_CONTROL_STATUS_MGKPKTEN_Msk   (0x2UL)                   /*!< ETH PMT_CONTROL_STATUS: MGKPKTEN (Bitfield-Mask: 0x01)      */
#define ETH_PMT_CONTROL_STATUS_RWKPKTEN_Pos   (2UL)                     /*!< ETH PMT_CONTROL_STATUS: RWKPKTEN (Bit 2)                    */
#define ETH_PMT_CONTROL_STATUS_RWKPKTEN_Msk   (0x4UL)                   /*!< ETH PMT_CONTROL_STATUS: RWKPKTEN (Bitfield-Mask: 0x01)      */
#define ETH_PMT_CONTROL_STATUS_MGKPRCVD_Pos   (5UL)                     /*!< ETH PMT_CONTROL_STATUS: MGKPRCVD (Bit 5)                    */
#define ETH_PMT_CONTROL_STATUS_MGKPRCVD_Msk   (0x20UL)                  /*!< ETH PMT_CONTROL_STATUS: MGKPRCVD (Bitfield-Mask: 0x01)      */
#define ETH_PMT_CONTROL_STATUS_RWKPRCVD_Pos   (6UL)                     /*!< ETH PMT_CONTROL_STATUS: RWKPRCVD (Bit 6)                    */
#define ETH_PMT_CONTROL_STATUS_RWKPRCVD_Msk   (0x40UL)                  /*!< ETH PMT_CONTROL_STATUS: RWKPRCVD (Bitfield-Mask: 0x01)      */
#define ETH_PMT_CONTROL_STATUS_GLBLUCAST_Pos  (9UL)                     /*!< ETH PMT_CONTROL_STATUS: GLBLUCAST (Bit 9)                   */
#define ETH_PMT_CONTROL_STATUS_GLBLUCAST_Msk  (0x200UL)                 /*!< ETH PMT_CONTROL_STATUS: GLBLUCAST (Bitfield-Mask: 0x01)     */
#define ETH_PMT_CONTROL_STATUS_RWKFILTRST_Pos (31UL)                    /*!< ETH PMT_CONTROL_STATUS: RWKFILTRST (Bit 31)                 */
#define ETH_PMT_CONTROL_STATUS_RWKFILTRST_Msk (0x80000000UL)            /*!< ETH PMT_CONTROL_STATUS: RWKFILTRST (Bitfield-Mask: 0x01)    */

/* ----------------------------  ETH_INTERRUPT_STATUS  ---------------------------- */
#define ETH_INTERRUPT_STATUS_PMTIS_Pos        (3UL)                     /*!< ETH INTERRUPT_STATUS: PMTIS (Bit 3)                         */
#define ETH_INTERRUPT_STATUS_PMTIS_Msk        (0x8UL)                   /*!< ETH INTERRUPT_STATUS: PMTIS (Bitfield-Mask: 0x01)           */
#define ETH_INTERRUPT_STATUS_MMCIS_Pos        (4UL)                     /*!< ETH INTERRUPT_STATUS: MMCIS (Bit 4)                         */
#define ETH_INTERRUPT_STATUS_MMCIS_Msk        (0x10UL)                  /*!< ETH INTERRUPT_STATUS: MMCIS (Bitfield-Mask: 0x01)           */
#define ETH_INTERRUPT_STATUS_MMCRXIS_Pos      (5UL)                     /*!< ETH INTERRUPT_STATUS: MMCRXIS (Bit 5)                       */
#define ETH_INTERRUPT_STATUS_MMCRXIS_Msk      (0x20UL)                  /*!< ETH INTERRUPT_STATUS: MMCRXIS (Bitfield-Mask: 0x01)         */
#define ETH_INTERRUPT_STATUS_MMCTXIS_Pos      (6UL)                     /*!< ETH INTERRUPT_STATUS: MMCTXIS (Bit 6)                       */
#define ETH_INTERRUPT_STATUS_MMCTXIS_Msk      (0x40UL)                  /*!< ETH INTERRUPT_STATUS: MMCTXIS (Bitfield-Mask: 0x01)         */
#define ETH_INTERRUPT_STATUS_MMCRXIPIS_Pos    (7UL)                     /*!< ETH INTERRUPT_STATUS: MMCRXIPIS (Bit 7)                     */
#define ETH_INTERRUPT_STATUS_MMCRXIPIS_Msk    (0x80UL)                  /*!< ETH INTERRUPT_STATUS: MMCRXIPIS (Bitfield-Mask: 0x01)       */
#define ETH_INTERRUPT_STATUS_TSIS_Pos         (9UL)                     /*!< ETH INTERRUPT_STATUS: TSIS (Bit 9)                          */
#define ETH_INTERRUPT_STATUS_TSIS_Msk         (0x200UL)                 /*!< ETH INTERRUPT_STATUS: TSIS (Bitfield-Mask: 0x01)            */

/* -----------------------------  ETH_INTERRUPT_MASK  ----------------------------- */
#define ETH_INTERRUPT_MASK_PMTIM_Pos          (3UL)                     /*!< ETH INTERRUPT_MASK: PMTIM (Bit 3)                           */
#define ETH_INTERRUPT_MASK_PMTIM_Msk          (0x8UL)                   /*!< ETH INTERRUPT_MASK: PMTIM (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_MASK_TSIM_Pos           (9UL)                     /*!< ETH INTERRUPT_MASK: TSIM (Bit 9)                            */
#define ETH_INTERRUPT_MASK_TSIM_Msk           (0x200UL)                 /*!< ETH INTERRUPT_MASK: TSIM (Bitfield-Mask: 0x01)              */

/* ----------------------------  ETH_MAC_ADDRESS0_HIGH  --------------------------- */
#define ETH_MAC_ADDRESS0_HIGH_ADDRHI_Pos      (0UL)                     /*!< ETH MAC_ADDRESS0_HIGH: ADDRHI (Bit 0)                       */
#define ETH_MAC_ADDRESS0_HIGH_ADDRHI_Msk      (0xffffUL)                /*!< ETH MAC_ADDRESS0_HIGH: ADDRHI (Bitfield-Mask: 0xffff)       */
#define ETH_MAC_ADDRESS0_HIGH_AE_Pos          (31UL)                    /*!< ETH MAC_ADDRESS0_HIGH: AE (Bit 31)                          */
#define ETH_MAC_ADDRESS0_HIGH_AE_Msk          (0x80000000UL)            /*!< ETH MAC_ADDRESS0_HIGH: AE (Bitfield-Mask: 0x01)             */

/* ----------------------------  ETH_MAC_ADDRESS0_LOW  ---------------------------- */
#define ETH_MAC_ADDRESS0_LOW_ADDRLO_Pos       (0UL)                     /*!< ETH MAC_ADDRESS0_LOW: ADDRLO (Bit 0)                        */
#define ETH_MAC_ADDRESS0_LOW_ADDRLO_Msk       (0xffffffffUL)            /*!< ETH MAC_ADDRESS0_LOW: ADDRLO (Bitfield-Mask: 0xffffffff)    */

/* ----------------------------  ETH_MAC_ADDRESS1_HIGH  --------------------------- */
#define ETH_MAC_ADDRESS1_HIGH_ADDRHI_Pos      (0UL)                     /*!< ETH MAC_ADDRESS1_HIGH: ADDRHI (Bit 0)                       */
#define ETH_MAC_ADDRESS1_HIGH_ADDRHI_Msk      (0xffffUL)                /*!< ETH MAC_ADDRESS1_HIGH: ADDRHI (Bitfield-Mask: 0xffff)       */
#define ETH_MAC_ADDRESS1_HIGH_MBC_Pos         (24UL)                    /*!< ETH MAC_ADDRESS1_HIGH: MBC (Bit 24)                         */
#define ETH_MAC_ADDRESS1_HIGH_MBC_Msk         (0x3f000000UL)            /*!< ETH MAC_ADDRESS1_HIGH: MBC (Bitfield-Mask: 0x3f)            */
#define ETH_MAC_ADDRESS1_HIGH_SA_Pos          (30UL)                    /*!< ETH MAC_ADDRESS1_HIGH: SA (Bit 30)                          */
#define ETH_MAC_ADDRESS1_HIGH_SA_Msk          (0x40000000UL)            /*!< ETH MAC_ADDRESS1_HIGH: SA (Bitfield-Mask: 0x01)             */
#define ETH_MAC_ADDRESS1_HIGH_AE_Pos          (31UL)                    /*!< ETH MAC_ADDRESS1_HIGH: AE (Bit 31)                          */
#define ETH_MAC_ADDRESS1_HIGH_AE_Msk          (0x80000000UL)            /*!< ETH MAC_ADDRESS1_HIGH: AE (Bitfield-Mask: 0x01)             */

/* ----------------------------  ETH_MAC_ADDRESS1_LOW  ---------------------------- */
#define ETH_MAC_ADDRESS1_LOW_ADDRLO_Pos       (0UL)                     /*!< ETH MAC_ADDRESS1_LOW: ADDRLO (Bit 0)                        */
#define ETH_MAC_ADDRESS1_LOW_ADDRLO_Msk       (0xffffffffUL)            /*!< ETH MAC_ADDRESS1_LOW: ADDRLO (Bitfield-Mask: 0xffffffff)    */

/* ----------------------------  ETH_MAC_ADDRESS2_HIGH  --------------------------- */
#define ETH_MAC_ADDRESS2_HIGH_ADDRHI_Pos      (0UL)                     /*!< ETH MAC_ADDRESS2_HIGH: ADDRHI (Bit 0)                       */
#define ETH_MAC_ADDRESS2_HIGH_ADDRHI_Msk      (0xffffUL)                /*!< ETH MAC_ADDRESS2_HIGH: ADDRHI (Bitfield-Mask: 0xffff)       */
#define ETH_MAC_ADDRESS2_HIGH_MBC_Pos         (24UL)                    /*!< ETH MAC_ADDRESS2_HIGH: MBC (Bit 24)                         */
#define ETH_MAC_ADDRESS2_HIGH_MBC_Msk         (0x3f000000UL)            /*!< ETH MAC_ADDRESS2_HIGH: MBC (Bitfield-Mask: 0x3f)            */
#define ETH_MAC_ADDRESS2_HIGH_SA_Pos          (30UL)                    /*!< ETH MAC_ADDRESS2_HIGH: SA (Bit 30)                          */
#define ETH_MAC_ADDRESS2_HIGH_SA_Msk          (0x40000000UL)            /*!< ETH MAC_ADDRESS2_HIGH: SA (Bitfield-Mask: 0x01)             */
#define ETH_MAC_ADDRESS2_HIGH_AE_Pos          (31UL)                    /*!< ETH MAC_ADDRESS2_HIGH: AE (Bit 31)                          */
#define ETH_MAC_ADDRESS2_HIGH_AE_Msk          (0x80000000UL)            /*!< ETH MAC_ADDRESS2_HIGH: AE (Bitfield-Mask: 0x01)             */

/* ----------------------------  ETH_MAC_ADDRESS2_LOW  ---------------------------- */
#define ETH_MAC_ADDRESS2_LOW_ADDRLO_Pos       (0UL)                     /*!< ETH MAC_ADDRESS2_LOW: ADDRLO (Bit 0)                        */
#define ETH_MAC_ADDRESS2_LOW_ADDRLO_Msk       (0xffffffffUL)            /*!< ETH MAC_ADDRESS2_LOW: ADDRLO (Bitfield-Mask: 0xffffffff)    */

/* ----------------------------  ETH_MAC_ADDRESS3_HIGH  --------------------------- */
#define ETH_MAC_ADDRESS3_HIGH_ADDRHI_Pos      (0UL)                     /*!< ETH MAC_ADDRESS3_HIGH: ADDRHI (Bit 0)                       */
#define ETH_MAC_ADDRESS3_HIGH_ADDRHI_Msk      (0xffffUL)                /*!< ETH MAC_ADDRESS3_HIGH: ADDRHI (Bitfield-Mask: 0xffff)       */
#define ETH_MAC_ADDRESS3_HIGH_MBC_Pos         (24UL)                    /*!< ETH MAC_ADDRESS3_HIGH: MBC (Bit 24)                         */
#define ETH_MAC_ADDRESS3_HIGH_MBC_Msk         (0x3f000000UL)            /*!< ETH MAC_ADDRESS3_HIGH: MBC (Bitfield-Mask: 0x3f)            */
#define ETH_MAC_ADDRESS3_HIGH_SA_Pos          (30UL)                    /*!< ETH MAC_ADDRESS3_HIGH: SA (Bit 30)                          */
#define ETH_MAC_ADDRESS3_HIGH_SA_Msk          (0x40000000UL)            /*!< ETH MAC_ADDRESS3_HIGH: SA (Bitfield-Mask: 0x01)             */
#define ETH_MAC_ADDRESS3_HIGH_AE_Pos          (31UL)                    /*!< ETH MAC_ADDRESS3_HIGH: AE (Bit 31)                          */
#define ETH_MAC_ADDRESS3_HIGH_AE_Msk          (0x80000000UL)            /*!< ETH MAC_ADDRESS3_HIGH: AE (Bitfield-Mask: 0x01)             */

/* ----------------------------  ETH_MAC_ADDRESS3_LOW  ---------------------------- */
#define ETH_MAC_ADDRESS3_LOW_ADDRLO_Pos       (0UL)                     /*!< ETH MAC_ADDRESS3_LOW: ADDRLO (Bit 0)                        */
#define ETH_MAC_ADDRESS3_LOW_ADDRLO_Msk       (0xffffffffUL)            /*!< ETH MAC_ADDRESS3_LOW: ADDRLO (Bitfield-Mask: 0xffffffff)    */

/* -------------------------------  ETH_MMC_CONTROL  ------------------------------ */
#define ETH_MMC_CONTROL_CNTRST_Pos            (0UL)                     /*!< ETH MMC_CONTROL: CNTRST (Bit 0)                             */
#define ETH_MMC_CONTROL_CNTRST_Msk            (0x1UL)                   /*!< ETH MMC_CONTROL: CNTRST (Bitfield-Mask: 0x01)               */
#define ETH_MMC_CONTROL_CNTSTOPRO_Pos         (1UL)                     /*!< ETH MMC_CONTROL: CNTSTOPRO (Bit 1)                          */
#define ETH_MMC_CONTROL_CNTSTOPRO_Msk         (0x2UL)                   /*!< ETH MMC_CONTROL: CNTSTOPRO (Bitfield-Mask: 0x01)            */
#define ETH_MMC_CONTROL_RSTONRD_Pos           (2UL)                     /*!< ETH MMC_CONTROL: RSTONRD (Bit 2)                            */
#define ETH_MMC_CONTROL_RSTONRD_Msk           (0x4UL)                   /*!< ETH MMC_CONTROL: RSTONRD (Bitfield-Mask: 0x01)              */
#define ETH_MMC_CONTROL_CNTFREEZ_Pos          (3UL)                     /*!< ETH MMC_CONTROL: CNTFREEZ (Bit 3)                           */
#define ETH_MMC_CONTROL_CNTFREEZ_Msk          (0x8UL)                   /*!< ETH MMC_CONTROL: CNTFREEZ (Bitfield-Mask: 0x01)             */
#define ETH_MMC_CONTROL_CNTPRST_Pos           (4UL)                     /*!< ETH MMC_CONTROL: CNTPRST (Bit 4)                            */
#define ETH_MMC_CONTROL_CNTPRST_Msk           (0x10UL)                  /*!< ETH MMC_CONTROL: CNTPRST (Bitfield-Mask: 0x01)              */
#define ETH_MMC_CONTROL_CNTPRSTLVL_Pos        (5UL)                     /*!< ETH MMC_CONTROL: CNTPRSTLVL (Bit 5)                         */
#define ETH_MMC_CONTROL_CNTPRSTLVL_Msk        (0x20UL)                  /*!< ETH MMC_CONTROL: CNTPRSTLVL (Bitfield-Mask: 0x01)           */
#define ETH_MMC_CONTROL_UCDBC_Pos             (8UL)                     /*!< ETH MMC_CONTROL: UCDBC (Bit 8)                              */
#define ETH_MMC_CONTROL_UCDBC_Msk             (0x100UL)                 /*!< ETH MMC_CONTROL: UCDBC (Bitfield-Mask: 0x01)                */

/* --------------------------  ETH_MMC_RECEIVE_INTERRUPT  ------------------------- */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGBFRMIS_Pos (0UL)                   /*!< ETH MMC_RECEIVE_INTERRUPT: RXGBFRMIS (Bit 0)                */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGBFRMIS_Msk (0x1UL)                 /*!< ETH MMC_RECEIVE_INTERRUPT: RXGBFRMIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGBOCTIS_Pos (1UL)                   /*!< ETH MMC_RECEIVE_INTERRUPT: RXGBOCTIS (Bit 1)                */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGBOCTIS_Msk (0x2UL)                 /*!< ETH MMC_RECEIVE_INTERRUPT: RXGBOCTIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGOCTIS_Pos (2UL)                    /*!< ETH MMC_RECEIVE_INTERRUPT: RXGOCTIS (Bit 2)                 */
#define ETH_MMC_RECEIVE_INTERRUPT_RXGOCTIS_Msk (0x4UL)                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXGOCTIS (Bitfield-Mask: 0x01)   */
#define ETH_MMC_RECEIVE_INTERRUPT_RXBCGFIS_Pos (3UL)                    /*!< ETH MMC_RECEIVE_INTERRUPT: RXBCGFIS (Bit 3)                 */
#define ETH_MMC_RECEIVE_INTERRUPT_RXBCGFIS_Msk (0x8UL)                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXBCGFIS (Bitfield-Mask: 0x01)   */
#define ETH_MMC_RECEIVE_INTERRUPT_RXMCGFIS_Pos (4UL)                    /*!< ETH MMC_RECEIVE_INTERRUPT: RXMCGFIS (Bit 4)                 */
#define ETH_MMC_RECEIVE_INTERRUPT_RXMCGFIS_Msk (0x10UL)                 /*!< ETH MMC_RECEIVE_INTERRUPT: RXMCGFIS (Bitfield-Mask: 0x01)   */
#define ETH_MMC_RECEIVE_INTERRUPT_RXCRCERFIS_Pos (5UL)                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXCRCERFIS (Bit 5)               */
#define ETH_MMC_RECEIVE_INTERRUPT_RXCRCERFIS_Msk (0x20UL)               /*!< ETH MMC_RECEIVE_INTERRUPT: RXCRCERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXALGNERFIS_Pos (6UL)                 /*!< ETH MMC_RECEIVE_INTERRUPT: RXALGNERFIS (Bit 6)              */
#define ETH_MMC_RECEIVE_INTERRUPT_RXALGNERFIS_Msk (0x40UL)              /*!< ETH MMC_RECEIVE_INTERRUPT: RXALGNERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXRUNTFIS_Pos (7UL)                   /*!< ETH MMC_RECEIVE_INTERRUPT: RXRUNTFIS (Bit 7)                */
#define ETH_MMC_RECEIVE_INTERRUPT_RXRUNTFIS_Msk (0x80UL)                /*!< ETH MMC_RECEIVE_INTERRUPT: RXRUNTFIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_RECEIVE_INTERRUPT_RXJABERFIS_Pos (8UL)                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXJABERFIS (Bit 8)               */
#define ETH_MMC_RECEIVE_INTERRUPT_RXJABERFIS_Msk (0x100UL)              /*!< ETH MMC_RECEIVE_INTERRUPT: RXJABERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXUSIZEGFIS_Pos (9UL)                 /*!< ETH MMC_RECEIVE_INTERRUPT: RXUSIZEGFIS (Bit 9)              */
#define ETH_MMC_RECEIVE_INTERRUPT_RXUSIZEGFIS_Msk (0x200UL)             /*!< ETH MMC_RECEIVE_INTERRUPT: RXUSIZEGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXOSIZEGFIS_Pos (10UL)                /*!< ETH MMC_RECEIVE_INTERRUPT: RXOSIZEGFIS (Bit 10)             */
#define ETH_MMC_RECEIVE_INTERRUPT_RXOSIZEGFIS_Msk (0x400UL)             /*!< ETH MMC_RECEIVE_INTERRUPT: RXOSIZEGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RX64OCTGBFIS_Pos (11UL)               /*!< ETH MMC_RECEIVE_INTERRUPT: RX64OCTGBFIS (Bit 11)            */
#define ETH_MMC_RECEIVE_INTERRUPT_RX64OCTGBFIS_Msk (0x800UL)            /*!< ETH MMC_RECEIVE_INTERRUPT: RX64OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RX65T127OCTGBFIS_Pos (12UL)           /*!< ETH MMC_RECEIVE_INTERRUPT: RX65T127OCTGBFIS (Bit 12)        */
#define ETH_MMC_RECEIVE_INTERRUPT_RX65T127OCTGBFIS_Msk (0x1000UL)       /*!< ETH MMC_RECEIVE_INTERRUPT: RX65T127OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RX128T255OCTGBFIS_Pos (13UL)          /*!< ETH MMC_RECEIVE_INTERRUPT: RX128T255OCTGBFIS (Bit 13)       */
#define ETH_MMC_RECEIVE_INTERRUPT_RX128T255OCTGBFIS_Msk (0x2000UL)      /*!< ETH MMC_RECEIVE_INTERRUPT: RX128T255OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RX256T511OCTGBFIS_Pos (14UL)          /*!< ETH MMC_RECEIVE_INTERRUPT: RX256T511OCTGBFIS (Bit 14)       */
#define ETH_MMC_RECEIVE_INTERRUPT_RX256T511OCTGBFIS_Msk (0x4000UL)      /*!< ETH MMC_RECEIVE_INTERRUPT: RX256T511OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RX512T1023OCTGBFIS_Pos (15UL)         /*!< ETH MMC_RECEIVE_INTERRUPT: RX512T1023OCTGBFIS (Bit 15)      */
#define ETH_MMC_RECEIVE_INTERRUPT_RX512T1023OCTGBFIS_Msk (0x8000UL)     /*!< ETH MMC_RECEIVE_INTERRUPT: RX512T1023OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RX1024TMAXOCTGBFIS_Pos (16UL)         /*!< ETH MMC_RECEIVE_INTERRUPT: RX1024TMAXOCTGBFIS (Bit 16)      */
#define ETH_MMC_RECEIVE_INTERRUPT_RX1024TMAXOCTGBFIS_Msk (0x10000UL)    /*!< ETH MMC_RECEIVE_INTERRUPT: RX1024TMAXOCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXUCGFIS_Pos (17UL)                   /*!< ETH MMC_RECEIVE_INTERRUPT: RXUCGFIS (Bit 17)                */
#define ETH_MMC_RECEIVE_INTERRUPT_RXUCGFIS_Msk (0x20000UL)              /*!< ETH MMC_RECEIVE_INTERRUPT: RXUCGFIS (Bitfield-Mask: 0x01)   */
#define ETH_MMC_RECEIVE_INTERRUPT_RXLENERFIS_Pos (18UL)                 /*!< ETH MMC_RECEIVE_INTERRUPT: RXLENERFIS (Bit 18)              */
#define ETH_MMC_RECEIVE_INTERRUPT_RXLENERFIS_Msk (0x40000UL)            /*!< ETH MMC_RECEIVE_INTERRUPT: RXLENERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXORANGEFIS_Pos (19UL)                /*!< ETH MMC_RECEIVE_INTERRUPT: RXORANGEFIS (Bit 19)             */
#define ETH_MMC_RECEIVE_INTERRUPT_RXORANGEFIS_Msk (0x80000UL)           /*!< ETH MMC_RECEIVE_INTERRUPT: RXORANGEFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXPAUSFIS_Pos (20UL)                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXPAUSFIS (Bit 20)               */
#define ETH_MMC_RECEIVE_INTERRUPT_RXPAUSFIS_Msk (0x100000UL)            /*!< ETH MMC_RECEIVE_INTERRUPT: RXPAUSFIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_RECEIVE_INTERRUPT_RXFOVFIS_Pos (21UL)                   /*!< ETH MMC_RECEIVE_INTERRUPT: RXFOVFIS (Bit 21)                */
#define ETH_MMC_RECEIVE_INTERRUPT_RXFOVFIS_Msk (0x200000UL)             /*!< ETH MMC_RECEIVE_INTERRUPT: RXFOVFIS (Bitfield-Mask: 0x01)   */
#define ETH_MMC_RECEIVE_INTERRUPT_RXVLANGBFIS_Pos (22UL)                /*!< ETH MMC_RECEIVE_INTERRUPT: RXVLANGBFIS (Bit 22)             */
#define ETH_MMC_RECEIVE_INTERRUPT_RXVLANGBFIS_Msk (0x400000UL)          /*!< ETH MMC_RECEIVE_INTERRUPT: RXVLANGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXWDOGFIS_Pos (23UL)                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXWDOGFIS (Bit 23)               */
#define ETH_MMC_RECEIVE_INTERRUPT_RXWDOGFIS_Msk (0x800000UL)            /*!< ETH MMC_RECEIVE_INTERRUPT: RXWDOGFIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_RECEIVE_INTERRUPT_RXRCVERRFIS_Pos (24UL)                /*!< ETH MMC_RECEIVE_INTERRUPT: RXRCVERRFIS (Bit 24)             */
#define ETH_MMC_RECEIVE_INTERRUPT_RXRCVERRFIS_Msk (0x1000000UL)         /*!< ETH MMC_RECEIVE_INTERRUPT: RXRCVERRFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_RXCTRLFIS_Pos (25UL)                  /*!< ETH MMC_RECEIVE_INTERRUPT: RXCTRLFIS (Bit 25)               */
#define ETH_MMC_RECEIVE_INTERRUPT_RXCTRLFIS_Msk (0x2000000UL)           /*!< ETH MMC_RECEIVE_INTERRUPT: RXCTRLFIS (Bitfield-Mask: 0x01)  */

/* -------------------------  ETH_MMC_TRANSMIT_INTERRUPT  ------------------------- */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGBOCTIS_Pos (0UL)                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGBOCTIS (Bit 0)               */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGBOCTIS_Msk (0x1UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGBOCTIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGBFRMIS_Pos (1UL)                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGBFRMIS (Bit 1)               */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGBFRMIS_Msk (0x2UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGBFRMIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXBCGFIS_Pos (2UL)                   /*!< ETH MMC_TRANSMIT_INTERRUPT: TXBCGFIS (Bit 2)                */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXBCGFIS_Msk (0x4UL)                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TXBCGFIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCGFIS_Pos (3UL)                   /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCGFIS (Bit 3)                */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCGFIS_Msk (0x8UL)                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCGFIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX64OCTGBFIS_Pos (4UL)               /*!< ETH MMC_TRANSMIT_INTERRUPT: TX64OCTGBFIS (Bit 4)            */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX64OCTGBFIS_Msk (0x10UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT: TX64OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX65T127OCTGBFIS_Pos (5UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT: TX65T127OCTGBFIS (Bit 5)        */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX65T127OCTGBFIS_Msk (0x20UL)        /*!< ETH MMC_TRANSMIT_INTERRUPT: TX65T127OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX128T255OCTGBFIS_Pos (6UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT: TX128T255OCTGBFIS (Bit 6)       */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX128T255OCTGBFIS_Msk (0x40UL)       /*!< ETH MMC_TRANSMIT_INTERRUPT: TX128T255OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX256T511OCTGBFIS_Pos (7UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT: TX256T511OCTGBFIS (Bit 7)       */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX256T511OCTGBFIS_Msk (0x80UL)       /*!< ETH MMC_TRANSMIT_INTERRUPT: TX256T511OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX512T1023OCTGBFIS_Pos (8UL)         /*!< ETH MMC_TRANSMIT_INTERRUPT: TX512T1023OCTGBFIS (Bit 8)      */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX512T1023OCTGBFIS_Msk (0x100UL)     /*!< ETH MMC_TRANSMIT_INTERRUPT: TX512T1023OCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX1024TMAXOCTGBFIS_Pos (9UL)         /*!< ETH MMC_TRANSMIT_INTERRUPT: TX1024TMAXOCTGBFIS (Bit 9)      */
#define ETH_MMC_TRANSMIT_INTERRUPT_TX1024TMAXOCTGBFIS_Msk (0x200UL)     /*!< ETH MMC_TRANSMIT_INTERRUPT: TX1024TMAXOCTGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXUCGBFIS_Pos (10UL)                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TXUCGBFIS (Bit 10)              */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXUCGBFIS_Msk (0x400UL)              /*!< ETH MMC_TRANSMIT_INTERRUPT: TXUCGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCGBFIS_Pos (11UL)                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCGBFIS (Bit 11)              */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCGBFIS_Msk (0x800UL)              /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXBCGBFIS_Pos (12UL)                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TXBCGBFIS (Bit 12)              */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXBCGBFIS_Msk (0x1000UL)             /*!< ETH MMC_TRANSMIT_INTERRUPT: TXBCGBFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXUFLOWERFIS_Pos (13UL)              /*!< ETH MMC_TRANSMIT_INTERRUPT: TXUFLOWERFIS (Bit 13)           */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXUFLOWERFIS_Msk (0x2000UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT: TXUFLOWERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXSCOLGFIS_Pos (14UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXSCOLGFIS (Bit 14)             */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXSCOLGFIS_Msk (0x4000UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT: TXSCOLGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCOLGFIS_Pos (15UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCOLGFIS (Bit 15)             */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXMCOLGFIS_Msk (0x8000UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT: TXMCOLGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXDEFFIS_Pos (16UL)                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXDEFFIS (Bit 16)               */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXDEFFIS_Msk (0x10000UL)             /*!< ETH MMC_TRANSMIT_INTERRUPT: TXDEFFIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXLATCOLFIS_Pos (17UL)               /*!< ETH MMC_TRANSMIT_INTERRUPT: TXLATCOLFIS (Bit 17)            */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXLATCOLFIS_Msk (0x20000UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT: TXLATCOLFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXEXCOLFIS_Pos (18UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXEXCOLFIS (Bit 18)             */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXEXCOLFIS_Msk (0x40000UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT: TXEXCOLFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXCARERFIS_Pos (19UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXCARERFIS (Bit 19)             */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXCARERFIS_Msk (0x80000UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT: TXCARERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGOCTIS_Pos (20UL)                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGOCTIS (Bit 20)               */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGOCTIS_Msk (0x100000UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGOCTIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGFRMIS_Pos (21UL)                  /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGFRMIS (Bit 21)               */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXGFRMIS_Msk (0x200000UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT: TXGFRMIS (Bitfield-Mask: 0x01)  */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXEXDEFFIS_Pos (22UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXEXDEFFIS (Bit 22)             */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXEXDEFFIS_Msk (0x400000UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT: TXEXDEFFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXPAUSFIS_Pos (23UL)                 /*!< ETH MMC_TRANSMIT_INTERRUPT: TXPAUSFIS (Bit 23)              */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXPAUSFIS_Msk (0x800000UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT: TXPAUSFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXVLANGFIS_Pos (24UL)                /*!< ETH MMC_TRANSMIT_INTERRUPT: TXVLANGFIS (Bit 24)             */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXVLANGFIS_Msk (0x1000000UL)         /*!< ETH MMC_TRANSMIT_INTERRUPT: TXVLANGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXOSIZEGFIS_Pos (25UL)               /*!< ETH MMC_TRANSMIT_INTERRUPT: TXOSIZEGFIS (Bit 25)            */
#define ETH_MMC_TRANSMIT_INTERRUPT_TXOSIZEGFIS_Msk (0x2000000UL)        /*!< ETH MMC_TRANSMIT_INTERRUPT: TXOSIZEGFIS (Bitfield-Mask: 0x01) */

/* -----------------------  ETH_MMC_RECEIVE_INTERRUPT_MASK  ----------------------- */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGBFRMIM_Pos (0UL)              /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGBFRMIM (Bit 0)           */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGBFRMIM_Msk (0x1UL)            /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGBFRMIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGBOCTIM_Pos (1UL)              /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGBOCTIM (Bit 1)           */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGBOCTIM_Msk (0x2UL)            /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGBOCTIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGOCTIM_Pos (2UL)               /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGOCTIM (Bit 2)            */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXGOCTIM_Msk (0x4UL)             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXGOCTIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXBCGFIM_Pos (3UL)               /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXBCGFIM (Bit 3)            */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXBCGFIM_Msk (0x8UL)             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXBCGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXMCGFIM_Pos (4UL)               /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXMCGFIM (Bit 4)            */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXMCGFIM_Msk (0x10UL)            /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXMCGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXCRCERFIM_Pos (5UL)             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXCRCERFIM (Bit 5)          */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXCRCERFIM_Msk (0x20UL)          /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXCRCERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXALGNERFIM_Pos (6UL)            /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXALGNERFIM (Bit 6)         */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXALGNERFIM_Msk (0x40UL)         /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXALGNERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXRUNTFIM_Pos (7UL)              /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXRUNTFIM (Bit 7)           */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXRUNTFIM_Msk (0x80UL)           /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXRUNTFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXJABERFIM_Pos (8UL)             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXJABERFIM (Bit 8)          */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXJABERFIM_Msk (0x100UL)         /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXJABERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXUSIZEGFIM_Pos (9UL)            /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXUSIZEGFIM (Bit 9)         */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXUSIZEGFIM_Msk (0x200UL)        /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXUSIZEGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXOSIZEGFIM_Pos (10UL)           /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXOSIZEGFIM (Bit 10)        */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXOSIZEGFIM_Msk (0x400UL)        /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXOSIZEGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX64OCTGBFIM_Pos (11UL)          /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX64OCTGBFIM (Bit 11)       */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX64OCTGBFIM_Msk (0x800UL)       /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX64OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX65T127OCTGBFIM_Pos (12UL)      /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX65T127OCTGBFIM (Bit 12)   */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX65T127OCTGBFIM_Msk (0x1000UL)  /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX65T127OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX128T255OCTGBFIM_Pos (13UL)     /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX128T255OCTGBFIM (Bit 13)  */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX128T255OCTGBFIM_Msk (0x2000UL) /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX128T255OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX256T511OCTGBFIM_Pos (14UL)     /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX256T511OCTGBFIM (Bit 14)  */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX256T511OCTGBFIM_Msk (0x4000UL) /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX256T511OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX512T1023OCTGBFIM_Pos (15UL)    /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX512T1023OCTGBFIM (Bit 15) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX512T1023OCTGBFIM_Msk (0x8000UL) /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX512T1023OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX1024TMAXOCTGBFIM_Pos (16UL)    /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX1024TMAXOCTGBFIM (Bit 16) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RX1024TMAXOCTGBFIM_Msk (0x10000UL) /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RX1024TMAXOCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXUCGFIM_Pos (17UL)              /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXUCGFIM (Bit 17)           */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXUCGFIM_Msk (0x20000UL)         /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXUCGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXLENERFIM_Pos (18UL)            /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXLENERFIM (Bit 18)         */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXLENERFIM_Msk (0x40000UL)       /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXLENERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXORANGEFIM_Pos (19UL)           /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXORANGEFIM (Bit 19)        */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXORANGEFIM_Msk (0x80000UL)      /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXORANGEFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXPAUSFIM_Pos (20UL)             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXPAUSFIM (Bit 20)          */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXPAUSFIM_Msk (0x100000UL)       /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXPAUSFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXFOVFIM_Pos (21UL)              /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXFOVFIM (Bit 21)           */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXFOVFIM_Msk (0x200000UL)        /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXFOVFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXVLANGBFIM_Pos (22UL)           /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXVLANGBFIM (Bit 22)        */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXVLANGBFIM_Msk (0x400000UL)     /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXVLANGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXWDOGFIM_Pos (23UL)             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXWDOGFIM (Bit 23)          */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXWDOGFIM_Msk (0x800000UL)       /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXWDOGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXRCVERRFIM_Pos (24UL)           /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXRCVERRFIM (Bit 24)        */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXRCVERRFIM_Msk (0x1000000UL)    /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXRCVERRFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXCTRLFIM_Pos (25UL)             /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXCTRLFIM (Bit 25)          */
#define ETH_MMC_RECEIVE_INTERRUPT_MASK_RXCTRLFIM_Msk (0x2000000UL)      /*!< ETH MMC_RECEIVE_INTERRUPT_MASK: RXCTRLFIM (Bitfield-Mask: 0x01) */

/* -----------------------  ETH_MMC_TRANSMIT_INTERRUPT_MASK  ---------------------- */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGBOCTIM_Pos (0UL)             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGBOCTIM (Bit 0)          */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGBOCTIM_Msk (0x1UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGBOCTIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGBFRMIM_Pos (1UL)             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGBFRMIM (Bit 1)          */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGBFRMIM_Msk (0x2UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGBFRMIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXBCGFIM_Pos (2UL)              /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXBCGFIM (Bit 2)           */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXBCGFIM_Msk (0x4UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXBCGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCGFIM_Pos (3UL)              /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCGFIM (Bit 3)           */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCGFIM_Msk (0x8UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX64OCTGBFIM_Pos (4UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX64OCTGBFIM (Bit 4)       */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX64OCTGBFIM_Msk (0x10UL)       /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX64OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX65T127OCTGBFIM_Pos (5UL)      /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX65T127OCTGBFIM (Bit 5)   */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX65T127OCTGBFIM_Msk (0x20UL)   /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX65T127OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX128T255OCTGBFIM_Pos (6UL)     /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX128T255OCTGBFIM (Bit 6)  */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX128T255OCTGBFIM_Msk (0x40UL)  /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX128T255OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX256T511OCTGBFIM_Pos (7UL)     /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX256T511OCTGBFIM (Bit 7)  */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX256T511OCTGBFIM_Msk (0x80UL)  /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX256T511OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX512T1023OCTGBFIM_Pos (8UL)    /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX512T1023OCTGBFIM (Bit 8) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX512T1023OCTGBFIM_Msk (0x100UL) /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX512T1023OCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX1024TMAXOCTGBFIM_Pos (9UL)    /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX1024TMAXOCTGBFIM (Bit 9) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TX1024TMAXOCTGBFIM_Msk (0x200UL) /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TX1024TMAXOCTGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXUCGBFIM_Pos (10UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXUCGBFIM (Bit 10)         */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXUCGBFIM_Msk (0x400UL)         /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXUCGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCGBFIM_Pos (11UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCGBFIM (Bit 11)         */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCGBFIM_Msk (0x800UL)         /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXBCGBFIM_Pos (12UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXBCGBFIM (Bit 12)         */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXBCGBFIM_Msk (0x1000UL)        /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXBCGBFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXUFLOWERFIM_Pos (13UL)         /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXUFLOWERFIM (Bit 13)      */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXUFLOWERFIM_Msk (0x2000UL)     /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXUFLOWERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXSCOLGFIM_Pos (14UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXSCOLGFIM (Bit 14)        */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXSCOLGFIM_Msk (0x4000UL)       /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXSCOLGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCOLGFIM_Pos (15UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCOLGFIM (Bit 15)        */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXMCOLGFIM_Msk (0x8000UL)       /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXMCOLGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXDEFFIM_Pos (16UL)             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXDEFFIM (Bit 16)          */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXDEFFIM_Msk (0x10000UL)        /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXDEFFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXLATCOLFIM_Pos (17UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXLATCOLFIM (Bit 17)       */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXLATCOLFIM_Msk (0x20000UL)     /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXLATCOLFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXEXCOLFIM_Pos (18UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXEXCOLFIM (Bit 18)        */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXEXCOLFIM_Msk (0x40000UL)      /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXEXCOLFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXCARERFIM_Pos (19UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXCARERFIM (Bit 19)        */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXCARERFIM_Msk (0x80000UL)      /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXCARERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGOCTIM_Pos (20UL)             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGOCTIM (Bit 20)          */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGOCTIM_Msk (0x100000UL)       /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGOCTIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGFRMIM_Pos (21UL)             /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGFRMIM (Bit 21)          */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXGFRMIM_Msk (0x200000UL)       /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXGFRMIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXEXDEFFIM_Pos (22UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXEXDEFFIM (Bit 22)        */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXEXDEFFIM_Msk (0x400000UL)     /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXEXDEFFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXPAUSFIM_Pos (23UL)            /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXPAUSFIM (Bit 23)         */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXPAUSFIM_Msk (0x800000UL)      /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXPAUSFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXVLANGFIM_Pos (24UL)           /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXVLANGFIM (Bit 24)        */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXVLANGFIM_Msk (0x1000000UL)    /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXVLANGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXOSIZEGFIM_Pos (25UL)          /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXOSIZEGFIM (Bit 25)       */
#define ETH_MMC_TRANSMIT_INTERRUPT_MASK_TXOSIZEGFIM_Msk (0x2000000UL)   /*!< ETH MMC_TRANSMIT_INTERRUPT_MASK: TXOSIZEGFIM (Bitfield-Mask: 0x01) */

/* -------------------------  ETH_TX_OCTET_COUNT_GOOD_BAD  ------------------------ */
#define ETH_TX_OCTET_COUNT_GOOD_BAD_TXOCTGB_Pos (0UL)                   /*!< ETH TX_OCTET_COUNT_GOOD_BAD: TXOCTGB (Bit 0)                */
#define ETH_TX_OCTET_COUNT_GOOD_BAD_TXOCTGB_Msk (0xffffffffUL)          /*!< ETH TX_OCTET_COUNT_GOOD_BAD: TXOCTGB (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_TX_FRAME_COUNT_GOOD_BAD  ------------------------ */
#define ETH_TX_FRAME_COUNT_GOOD_BAD_TXFRMGB_Pos (0UL)                   /*!< ETH TX_FRAME_COUNT_GOOD_BAD: TXFRMGB (Bit 0)                */
#define ETH_TX_FRAME_COUNT_GOOD_BAD_TXFRMGB_Msk (0xffffffffUL)          /*!< ETH TX_FRAME_COUNT_GOOD_BAD: TXFRMGB (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_TX_BROADCAST_FRAMES_GOOD  ------------------------ */
#define ETH_TX_BROADCAST_FRAMES_GOOD_TXBCASTG_Pos (0UL)                 /*!< ETH TX_BROADCAST_FRAMES_GOOD: TXBCASTG (Bit 0)              */
#define ETH_TX_BROADCAST_FRAMES_GOOD_TXBCASTG_Msk (0xffffffffUL)        /*!< ETH TX_BROADCAST_FRAMES_GOOD: TXBCASTG (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_TX_MULTICAST_FRAMES_GOOD  ------------------------ */
#define ETH_TX_MULTICAST_FRAMES_GOOD_TXMCASTG_Pos (0UL)                 /*!< ETH TX_MULTICAST_FRAMES_GOOD: TXMCASTG (Bit 0)              */
#define ETH_TX_MULTICAST_FRAMES_GOOD_TXMCASTG_Msk (0xffffffffUL)        /*!< ETH TX_MULTICAST_FRAMES_GOOD: TXMCASTG (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_TX_64OCTETS_FRAMES_GOOD_BAD  ---------------------- */
#define ETH_TX_64OCTETS_FRAMES_GOOD_BAD_TX64OCTGB_Pos (0UL)             /*!< ETH TX_64OCTETS_FRAMES_GOOD_BAD: TX64OCTGB (Bit 0)          */
#define ETH_TX_64OCTETS_FRAMES_GOOD_BAD_TX64OCTGB_Msk (0xffffffffUL)    /*!< ETH TX_64OCTETS_FRAMES_GOOD_BAD: TX64OCTGB (Bitfield-Mask: 0xffffffff) */

/* --------------------  ETH_TX_65TO127OCTETS_FRAMES_GOOD_BAD  -------------------- */
#define ETH_TX_65TO127OCTETS_FRAMES_GOOD_BAD_TX65_127OCTGB_Pos (0UL)    /*!< ETH TX_65TO127OCTETS_FRAMES_GOOD_BAD: TX65_127OCTGB (Bit 0) */
#define ETH_TX_65TO127OCTETS_FRAMES_GOOD_BAD_TX65_127OCTGB_Msk (0xffffffffUL) /*!< ETH TX_65TO127OCTETS_FRAMES_GOOD_BAD: TX65_127OCTGB (Bitfield-Mask: 0xffffffff) */

/* --------------------  ETH_TX_128TO255OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_TX_128TO255OCTETS_FRAMES_GOOD_BAD_TX128_255OCTGB_Pos (0UL)  /*!< ETH TX_128TO255OCTETS_FRAMES_GOOD_BAD: TX128_255OCTGB (Bit 0) */
#define ETH_TX_128TO255OCTETS_FRAMES_GOOD_BAD_TX128_255OCTGB_Msk (0xffffffffUL) /*!< ETH TX_128TO255OCTETS_FRAMES_GOOD_BAD: TX128_255OCTGB (Bitfield-Mask: 0xffffffff) */

/* --------------------  ETH_TX_256TO511OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_TX_256TO511OCTETS_FRAMES_GOOD_BAD_TX256_511OCTGB_Pos (0UL)  /*!< ETH TX_256TO511OCTETS_FRAMES_GOOD_BAD: TX256_511OCTGB (Bit 0) */
#define ETH_TX_256TO511OCTETS_FRAMES_GOOD_BAD_TX256_511OCTGB_Msk (0xffffffffUL) /*!< ETH TX_256TO511OCTETS_FRAMES_GOOD_BAD: TX256_511OCTGB (Bitfield-Mask: 0xffffffff) */

/* -------------------  ETH_TX_512TO1023OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_TX_512TO1023OCTETS_FRAMES_GOOD_BAD_TX512_1023OCTGB_Pos (0UL) /*!< ETH TX_512TO1023OCTETS_FRAMES_GOOD_BAD: TX512_1023OCTGB (Bit 0) */
#define ETH_TX_512TO1023OCTETS_FRAMES_GOOD_BAD_TX512_1023OCTGB_Msk (0xffffffffUL) /*!< ETH TX_512TO1023OCTETS_FRAMES_GOOD_BAD: TX512_1023OCTGB (Bitfield-Mask: 0xffffffff) */

/* -------------------  ETH_TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD_TX1024_MAXOCTGB_Pos (0UL) /*!< ETH TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD: TX1024_MAXOCTGB (Bit 0) */
#define ETH_TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD_TX1024_MAXOCTGB_Msk (0xffffffffUL) /*!< ETH TX_1024TOMAXOCTETS_FRAMES_GOOD_BAD: TX1024_MAXOCTGB (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_TX_UNICAST_FRAMES_GOOD_BAD  ----------------------- */
#define ETH_TX_UNICAST_FRAMES_GOOD_BAD_TXUCASTGB_Pos (0UL)              /*!< ETH TX_UNICAST_FRAMES_GOOD_BAD: TXUCASTGB (Bit 0)           */
#define ETH_TX_UNICAST_FRAMES_GOOD_BAD_TXUCASTGB_Msk (0xffffffffUL)     /*!< ETH TX_UNICAST_FRAMES_GOOD_BAD: TXUCASTGB (Bitfield-Mask: 0xffffffff) */

/* ----------------------  ETH_TX_MULTICAST_FRAMES_GOOD_BAD  ---------------------- */
#define ETH_TX_MULTICAST_FRAMES_GOOD_BAD_TXMCASTGB_Pos (0UL)            /*!< ETH TX_MULTICAST_FRAMES_GOOD_BAD: TXMCASTGB (Bit 0)         */
#define ETH_TX_MULTICAST_FRAMES_GOOD_BAD_TXMCASTGB_Msk (0xffffffffUL)   /*!< ETH TX_MULTICAST_FRAMES_GOOD_BAD: TXMCASTGB (Bitfield-Mask: 0xffffffff) */

/* ----------------------  ETH_TX_BROADCAST_FRAMES_GOOD_BAD  ---------------------- */
#define ETH_TX_BROADCAST_FRAMES_GOOD_BAD_TXBCASTGB_Pos (0UL)            /*!< ETH TX_BROADCAST_FRAMES_GOOD_BAD: TXBCASTGB (Bit 0)         */
#define ETH_TX_BROADCAST_FRAMES_GOOD_BAD_TXBCASTGB_Msk (0xffffffffUL)   /*!< ETH TX_BROADCAST_FRAMES_GOOD_BAD: TXBCASTGB (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_TX_UNDERFLOW_ERROR_FRAMES  ----------------------- */
#define ETH_TX_UNDERFLOW_ERROR_FRAMES_TXUNDRFLW_Pos (0UL)               /*!< ETH TX_UNDERFLOW_ERROR_FRAMES: TXUNDRFLW (Bit 0)            */
#define ETH_TX_UNDERFLOW_ERROR_FRAMES_TXUNDRFLW_Msk (0xffffffffUL)      /*!< ETH TX_UNDERFLOW_ERROR_FRAMES: TXUNDRFLW (Bitfield-Mask: 0xffffffff) */

/* ---------------------  ETH_TX_SINGLE_COLLISION_GOOD_FRAMES  -------------------- */
#define ETH_TX_SINGLE_COLLISION_GOOD_FRAMES_TXSNGLCOLG_Pos (0UL)        /*!< ETH TX_SINGLE_COLLISION_GOOD_FRAMES: TXSNGLCOLG (Bit 0)     */
#define ETH_TX_SINGLE_COLLISION_GOOD_FRAMES_TXSNGLCOLG_Msk (0xffffffffUL) /*!< ETH TX_SINGLE_COLLISION_GOOD_FRAMES: TXSNGLCOLG (Bitfield-Mask: 0xffffffff) */

/* --------------------  ETH_TX_MULTIPLE_COLLISION_GOOD_FRAMES  ------------------- */
#define ETH_TX_MULTIPLE_COLLISION_GOOD_FRAMES_TXMULTCOLG_Pos (0UL)      /*!< ETH TX_MULTIPLE_COLLISION_GOOD_FRAMES: TXMULTCOLG (Bit 0)   */
#define ETH_TX_MULTIPLE_COLLISION_GOOD_FRAMES_TXMULTCOLG_Msk (0xffffffffUL) /*!< ETH TX_MULTIPLE_COLLISION_GOOD_FRAMES: TXMULTCOLG (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_TX_DEFERRED_FRAMES  --------------------------- */
#define ETH_TX_DEFERRED_FRAMES_TXDEFRD_Pos    (0UL)                     /*!< ETH TX_DEFERRED_FRAMES: TXDEFRD (Bit 0)                     */
#define ETH_TX_DEFERRED_FRAMES_TXDEFRD_Msk    (0xffffffffUL)            /*!< ETH TX_DEFERRED_FRAMES: TXDEFRD (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_TX_LATE_COLLISION_FRAMES  ------------------------ */
#define ETH_TX_LATE_COLLISION_FRAMES_TXLATECOL_Pos (0UL)                /*!< ETH TX_LATE_COLLISION_FRAMES: TXLATECOL (Bit 0)             */
#define ETH_TX_LATE_COLLISION_FRAMES_TXLATECOL_Msk (0xffffffffUL)       /*!< ETH TX_LATE_COLLISION_FRAMES: TXLATECOL (Bitfield-Mask: 0xffffffff) */

/* ----------------------  ETH_TX_EXCESSIVE_COLLISION_FRAMES  --------------------- */
#define ETH_TX_EXCESSIVE_COLLISION_FRAMES_TXEXSCOL_Pos (0UL)            /*!< ETH TX_EXCESSIVE_COLLISION_FRAMES: TXEXSCOL (Bit 0)         */
#define ETH_TX_EXCESSIVE_COLLISION_FRAMES_TXEXSCOL_Msk (0xffffffffUL)   /*!< ETH TX_EXCESSIVE_COLLISION_FRAMES: TXEXSCOL (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_TX_CARRIER_ERROR_FRAMES  ------------------------ */
#define ETH_TX_CARRIER_ERROR_FRAMES_TXCARR_Pos (0UL)                    /*!< ETH TX_CARRIER_ERROR_FRAMES: TXCARR (Bit 0)                 */
#define ETH_TX_CARRIER_ERROR_FRAMES_TXCARR_Msk (0xffffffffUL)           /*!< ETH TX_CARRIER_ERROR_FRAMES: TXCARR (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_TX_OCTET_COUNT_GOOD  -------------------------- */
#define ETH_TX_OCTET_COUNT_GOOD_TXOCTG_Pos    (0UL)                     /*!< ETH TX_OCTET_COUNT_GOOD: TXOCTG (Bit 0)                     */
#define ETH_TX_OCTET_COUNT_GOOD_TXOCTG_Msk    (0xffffffffUL)            /*!< ETH TX_OCTET_COUNT_GOOD: TXOCTG (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_TX_FRAME_COUNT_GOOD  -------------------------- */
#define ETH_TX_FRAME_COUNT_GOOD_TXFRMG_Pos    (0UL)                     /*!< ETH TX_FRAME_COUNT_GOOD: TXFRMG (Bit 0)                     */
#define ETH_TX_FRAME_COUNT_GOOD_TXFRMG_Msk    (0xffffffffUL)            /*!< ETH TX_FRAME_COUNT_GOOD: TXFRMG (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_TX_EXCESSIVE_DEFERRAL_ERROR  ---------------------- */
#define ETH_TX_EXCESSIVE_DEFERRAL_ERROR_TXEXSDEF_Pos (0UL)              /*!< ETH TX_EXCESSIVE_DEFERRAL_ERROR: TXEXSDEF (Bit 0)           */
#define ETH_TX_EXCESSIVE_DEFERRAL_ERROR_TXEXSDEF_Msk (0xffffffffUL)     /*!< ETH TX_EXCESSIVE_DEFERRAL_ERROR: TXEXSDEF (Bitfield-Mask: 0xffffffff) */

/* -----------------------------  ETH_TX_PAUSE_FRAMES  ---------------------------- */
#define ETH_TX_PAUSE_FRAMES_TXPAUSE_Pos       (0UL)                     /*!< ETH TX_PAUSE_FRAMES: TXPAUSE (Bit 0)                        */
#define ETH_TX_PAUSE_FRAMES_TXPAUSE_Msk       (0xffffffffUL)            /*!< ETH TX_PAUSE_FRAMES: TXPAUSE (Bitfield-Mask: 0xffffffff)    */

/* ---------------------------  ETH_TX_VLAN_FRAMES_GOOD  -------------------------- */
#define ETH_TX_VLAN_FRAMES_GOOD_TXVLANG_Pos   (0UL)                     /*!< ETH TX_VLAN_FRAMES_GOOD: TXVLANG (Bit 0)                    */
#define ETH_TX_VLAN_FRAMES_GOOD_TXVLANG_Msk   (0xffffffffUL)            /*!< ETH TX_VLAN_FRAMES_GOOD: TXVLANG (Bitfield-Mask: 0xffffffff) */

/* --------------------------  ETH_TX_OSIZE_FRAMES_GOOD  -------------------------- */
#define ETH_TX_OSIZE_FRAMES_GOOD_TXOSIZG_Pos  (0UL)                     /*!< ETH TX_OSIZE_FRAMES_GOOD: TXOSIZG (Bit 0)                   */
#define ETH_TX_OSIZE_FRAMES_GOOD_TXOSIZG_Msk  (0xffffffffUL)            /*!< ETH TX_OSIZE_FRAMES_GOOD: TXOSIZG (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RX_FRAMES_COUNT_GOOD_BAD  ------------------------ */
#define ETH_RX_FRAMES_COUNT_GOOD_BAD_RXFRMGB_Pos (0UL)                  /*!< ETH RX_FRAMES_COUNT_GOOD_BAD: RXFRMGB (Bit 0)               */
#define ETH_RX_FRAMES_COUNT_GOOD_BAD_RXFRMGB_Msk (0xffffffffUL)         /*!< ETH RX_FRAMES_COUNT_GOOD_BAD: RXFRMGB (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_OCTET_COUNT_GOOD_BAD  ------------------------ */
#define ETH_RX_OCTET_COUNT_GOOD_BAD_RXOCTGB_Pos (0UL)                   /*!< ETH RX_OCTET_COUNT_GOOD_BAD: RXOCTGB (Bit 0)                */
#define ETH_RX_OCTET_COUNT_GOOD_BAD_RXOCTGB_Msk (0xffffffffUL)          /*!< ETH RX_OCTET_COUNT_GOOD_BAD: RXOCTGB (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RX_OCTET_COUNT_GOOD  -------------------------- */
#define ETH_RX_OCTET_COUNT_GOOD_RXOCTG_Pos    (0UL)                     /*!< ETH RX_OCTET_COUNT_GOOD: RXOCTG (Bit 0)                     */
#define ETH_RX_OCTET_COUNT_GOOD_RXOCTG_Msk    (0xffffffffUL)            /*!< ETH RX_OCTET_COUNT_GOOD: RXOCTG (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RX_BROADCAST_FRAMES_GOOD  ------------------------ */
#define ETH_RX_BROADCAST_FRAMES_GOOD_RXBCASTG_Pos (0UL)                 /*!< ETH RX_BROADCAST_FRAMES_GOOD: RXBCASTG (Bit 0)              */
#define ETH_RX_BROADCAST_FRAMES_GOOD_RXBCASTG_Msk (0xffffffffUL)        /*!< ETH RX_BROADCAST_FRAMES_GOOD: RXBCASTG (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RX_MULTICAST_FRAMES_GOOD  ------------------------ */
#define ETH_RX_MULTICAST_FRAMES_GOOD_RXMCASTG_Pos (0UL)                 /*!< ETH RX_MULTICAST_FRAMES_GOOD: RXMCASTG (Bit 0)              */
#define ETH_RX_MULTICAST_FRAMES_GOOD_RXMCASTG_Msk (0xffffffffUL)        /*!< ETH RX_MULTICAST_FRAMES_GOOD: RXMCASTG (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RX_CRC_ERROR_FRAMES  -------------------------- */
#define ETH_RX_CRC_ERROR_FRAMES_RXCRCERR_Pos  (0UL)                     /*!< ETH RX_CRC_ERROR_FRAMES: RXCRCERR (Bit 0)                   */
#define ETH_RX_CRC_ERROR_FRAMES_RXCRCERR_Msk  (0xffffffffUL)            /*!< ETH RX_CRC_ERROR_FRAMES: RXCRCERR (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RX_ALIGNMENT_ERROR_FRAMES  ----------------------- */
#define ETH_RX_ALIGNMENT_ERROR_FRAMES_RXALGNERR_Pos (0UL)               /*!< ETH RX_ALIGNMENT_ERROR_FRAMES: RXALGNERR (Bit 0)            */
#define ETH_RX_ALIGNMENT_ERROR_FRAMES_RXALGNERR_Msk (0xffffffffUL)      /*!< ETH RX_ALIGNMENT_ERROR_FRAMES: RXALGNERR (Bitfield-Mask: 0xffffffff) */

/* --------------------------  ETH_RX_RUNT_ERROR_FRAMES  -------------------------- */
#define ETH_RX_RUNT_ERROR_FRAMES_RXRUNTERR_Pos (0UL)                    /*!< ETH RX_RUNT_ERROR_FRAMES: RXRUNTERR (Bit 0)                 */
#define ETH_RX_RUNT_ERROR_FRAMES_RXRUNTERR_Msk (0xffffffffUL)           /*!< ETH RX_RUNT_ERROR_FRAMES: RXRUNTERR (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_JABBER_ERROR_FRAMES  ------------------------- */
#define ETH_RX_JABBER_ERROR_FRAMES_RXJABERR_Pos (0UL)                   /*!< ETH RX_JABBER_ERROR_FRAMES: RXJABERR (Bit 0)                */
#define ETH_RX_JABBER_ERROR_FRAMES_RXJABERR_Msk (0xffffffffUL)          /*!< ETH RX_JABBER_ERROR_FRAMES: RXJABERR (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RX_UNDERSIZE_FRAMES_GOOD  ------------------------ */
#define ETH_RX_UNDERSIZE_FRAMES_GOOD_RXUNDERSZG_Pos (0UL)               /*!< ETH RX_UNDERSIZE_FRAMES_GOOD: RXUNDERSZG (Bit 0)            */
#define ETH_RX_UNDERSIZE_FRAMES_GOOD_RXUNDERSZG_Msk (0xffffffffUL)      /*!< ETH RX_UNDERSIZE_FRAMES_GOOD: RXUNDERSZG (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_OVERSIZE_FRAMES_GOOD  ------------------------ */
#define ETH_RX_OVERSIZE_FRAMES_GOOD_RXOVERSZG_Pos (0UL)                 /*!< ETH RX_OVERSIZE_FRAMES_GOOD: RXOVERSZG (Bit 0)              */
#define ETH_RX_OVERSIZE_FRAMES_GOOD_RXOVERSZG_Msk (0xffffffffUL)        /*!< ETH RX_OVERSIZE_FRAMES_GOOD: RXOVERSZG (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_RX_64OCTETS_FRAMES_GOOD_BAD  ---------------------- */
#define ETH_RX_64OCTETS_FRAMES_GOOD_BAD_RX64OCTGB_Pos (0UL)             /*!< ETH RX_64OCTETS_FRAMES_GOOD_BAD: RX64OCTGB (Bit 0)          */
#define ETH_RX_64OCTETS_FRAMES_GOOD_BAD_RX64OCTGB_Msk (0xffffffffUL)    /*!< ETH RX_64OCTETS_FRAMES_GOOD_BAD: RX64OCTGB (Bitfield-Mask: 0xffffffff) */

/* --------------------  ETH_RX_65TO127OCTETS_FRAMES_GOOD_BAD  -------------------- */
#define ETH_RX_65TO127OCTETS_FRAMES_GOOD_BAD_RX65_127OCTGB_Pos (0UL)    /*!< ETH RX_65TO127OCTETS_FRAMES_GOOD_BAD: RX65_127OCTGB (Bit 0) */
#define ETH_RX_65TO127OCTETS_FRAMES_GOOD_BAD_RX65_127OCTGB_Msk (0xffffffffUL) /*!< ETH RX_65TO127OCTETS_FRAMES_GOOD_BAD: RX65_127OCTGB (Bitfield-Mask: 0xffffffff) */

/* --------------------  ETH_RX_128TO255OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_RX_128TO255OCTETS_FRAMES_GOOD_BAD_RX128_255OCTGB_Pos (0UL)  /*!< ETH RX_128TO255OCTETS_FRAMES_GOOD_BAD: RX128_255OCTGB (Bit 0) */
#define ETH_RX_128TO255OCTETS_FRAMES_GOOD_BAD_RX128_255OCTGB_Msk (0xffffffffUL) /*!< ETH RX_128TO255OCTETS_FRAMES_GOOD_BAD: RX128_255OCTGB (Bitfield-Mask: 0xffffffff) */

/* --------------------  ETH_RX_256TO511OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_RX_256TO511OCTETS_FRAMES_GOOD_BAD_RX256_511OCTGB_Pos (0UL)  /*!< ETH RX_256TO511OCTETS_FRAMES_GOOD_BAD: RX256_511OCTGB (Bit 0) */
#define ETH_RX_256TO511OCTETS_FRAMES_GOOD_BAD_RX256_511OCTGB_Msk (0xffffffffUL) /*!< ETH RX_256TO511OCTETS_FRAMES_GOOD_BAD: RX256_511OCTGB (Bitfield-Mask: 0xffffffff) */

/* -------------------  ETH_RX_512TO1023OCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_RX_512TO1023OCTETS_FRAMES_GOOD_BAD_RX512_1023OCTGB_Pos (0UL) /*!< ETH RX_512TO1023OCTETS_FRAMES_GOOD_BAD: RX512_1023OCTGB (Bit 0) */
#define ETH_RX_512TO1023OCTETS_FRAMES_GOOD_BAD_RX512_1023OCTGB_Msk (0xffffffffUL) /*!< ETH RX_512TO1023OCTETS_FRAMES_GOOD_BAD: RX512_1023OCTGB (Bitfield-Mask: 0xffffffff) */

/* -------------------  ETH_RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD  ------------------- */
#define ETH_RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD_RX1024_MAXOCTGB_Pos (0UL) /*!< ETH RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD: RX1024_MAXOCTGB (Bit 0) */
#define ETH_RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD_RX1024_MAXOCTGB_Msk (0xffffffffUL) /*!< ETH RX_1024TOMAXOCTETS_FRAMES_GOOD_BAD: RX1024_MAXOCTGB (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_UNICAST_FRAMES_GOOD  ------------------------- */
#define ETH_RX_UNICAST_FRAMES_GOOD_RXUCASTG_Pos (0UL)                   /*!< ETH RX_UNICAST_FRAMES_GOOD: RXUCASTG (Bit 0)                */
#define ETH_RX_UNICAST_FRAMES_GOOD_RXUCASTG_Msk (0xffffffffUL)          /*!< ETH RX_UNICAST_FRAMES_GOOD: RXUCASTG (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_LENGTH_ERROR_FRAMES  ------------------------- */
#define ETH_RX_LENGTH_ERROR_FRAMES_RXLENERR_Pos (0UL)                   /*!< ETH RX_LENGTH_ERROR_FRAMES: RXLENERR (Bit 0)                */
#define ETH_RX_LENGTH_ERROR_FRAMES_RXLENERR_Msk (0xffffffffUL)          /*!< ETH RX_LENGTH_ERROR_FRAMES: RXLENERR (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_RX_OUT_OF_RANGE_TYPE_FRAMES  ---------------------- */
#define ETH_RX_OUT_OF_RANGE_TYPE_FRAMES_RXOUTOFRNG_Pos (0UL)            /*!< ETH RX_OUT_OF_RANGE_TYPE_FRAMES: RXOUTOFRNG (Bit 0)         */
#define ETH_RX_OUT_OF_RANGE_TYPE_FRAMES_RXOUTOFRNG_Msk (0xffffffffUL)   /*!< ETH RX_OUT_OF_RANGE_TYPE_FRAMES: RXOUTOFRNG (Bitfield-Mask: 0xffffffff) */

/* -----------------------------  ETH_RX_PAUSE_FRAMES  ---------------------------- */
#define ETH_RX_PAUSE_FRAMES_RXPAUSEFRM_Pos    (0UL)                     /*!< ETH RX_PAUSE_FRAMES: RXPAUSEFRM (Bit 0)                     */
#define ETH_RX_PAUSE_FRAMES_RXPAUSEFRM_Msk    (0xffffffffUL)            /*!< ETH RX_PAUSE_FRAMES: RXPAUSEFRM (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_FIFO_OVERFLOW_FRAMES  ------------------------ */
#define ETH_RX_FIFO_OVERFLOW_FRAMES_RXFIFOOVFL_Pos (0UL)                /*!< ETH RX_FIFO_OVERFLOW_FRAMES: RXFIFOOVFL (Bit 0)             */
#define ETH_RX_FIFO_OVERFLOW_FRAMES_RXFIFOOVFL_Msk (0xffffffffUL)       /*!< ETH RX_FIFO_OVERFLOW_FRAMES: RXFIFOOVFL (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_VLAN_FRAMES_GOOD_BAD  ------------------------ */
#define ETH_RX_VLAN_FRAMES_GOOD_BAD_RXVLANFRGB_Pos (0UL)                /*!< ETH RX_VLAN_FRAMES_GOOD_BAD: RXVLANFRGB (Bit 0)             */
#define ETH_RX_VLAN_FRAMES_GOOD_BAD_RXVLANFRGB_Msk (0xffffffffUL)       /*!< ETH RX_VLAN_FRAMES_GOOD_BAD: RXVLANFRGB (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RX_WATCHDOG_ERROR_FRAMES  ------------------------ */
#define ETH_RX_WATCHDOG_ERROR_FRAMES_RXWDGERR_Pos (0UL)                 /*!< ETH RX_WATCHDOG_ERROR_FRAMES: RXWDGERR (Bit 0)              */
#define ETH_RX_WATCHDOG_ERROR_FRAMES_RXWDGERR_Msk (0xffffffffUL)        /*!< ETH RX_WATCHDOG_ERROR_FRAMES: RXWDGERR (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_RECEIVE_ERROR_FRAMES  ------------------------ */
#define ETH_RX_RECEIVE_ERROR_FRAMES_RXRCVERR_Pos (0UL)                  /*!< ETH RX_RECEIVE_ERROR_FRAMES: RXRCVERR (Bit 0)               */
#define ETH_RX_RECEIVE_ERROR_FRAMES_RXRCVERR_Msk (0xffffffffUL)         /*!< ETH RX_RECEIVE_ERROR_FRAMES: RXRCVERR (Bitfield-Mask: 0xffffffff) */

/* -------------------------  ETH_RX_CONTROL_FRAMES_GOOD  ------------------------- */
#define ETH_RX_CONTROL_FRAMES_GOOD_RXCTRLG_Pos (0UL)                    /*!< ETH RX_CONTROL_FRAMES_GOOD: RXCTRLG (Bit 0)                 */
#define ETH_RX_CONTROL_FRAMES_GOOD_RXCTRLG_Msk (0xffffffffUL)           /*!< ETH RX_CONTROL_FRAMES_GOOD: RXCTRLG (Bitfield-Mask: 0xffffffff) */

/* ---------------------  ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK  --------------------- */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4GFIM_Pos (0UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4GFIM (Bit 0)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4GFIM_Msk (0x1UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4GFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4HERFIM_Pos (1UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4HERFIM (Bit 1)    */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4HERFIM_Msk (0x2UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4HERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4NOPAYFIM_Pos (2UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4NOPAYFIM (Bit 2)  */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4NOPAYFIM_Msk (0x4UL)   /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4NOPAYFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4FRAGFIM_Pos (3UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4FRAGFIM (Bit 3)   */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4FRAGFIM_Msk (0x8UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4FRAGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4UDSBLFIM_Pos (4UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4UDSBLFIM (Bit 4)  */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4UDSBLFIM_Msk (0x10UL)  /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4UDSBLFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6GFIM_Pos (5UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6GFIM (Bit 5)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6GFIM_Msk (0x20UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6GFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6HERFIM_Pos (6UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6HERFIM (Bit 6)    */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6HERFIM_Msk (0x40UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6HERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6NOPAYFIM_Pos (7UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6NOPAYFIM (Bit 7)  */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6NOPAYFIM_Msk (0x80UL)  /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6NOPAYFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPGFIM_Pos (8UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPGFIM (Bit 8)       */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPGFIM_Msk (0x100UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPERFIM_Pos (9UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPERFIM (Bit 9)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPERFIM_Msk (0x200UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPGFIM_Pos (10UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPGFIM (Bit 10)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPGFIM_Msk (0x400UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPERFIM_Pos (11UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPERFIM (Bit 11)     */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPERFIM_Msk (0x800UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPGFIM_Pos (12UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPGFIM (Bit 12)     */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPGFIM_Msk (0x1000UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPGFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPERFIM_Pos (13UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPERFIM (Bit 13)    */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPERFIM_Msk (0x2000UL)   /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPERFIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4GOIM_Pos (16UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4GOIM (Bit 16)     */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4GOIM_Msk (0x10000UL)   /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4GOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4HEROIM_Pos (17UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4HEROIM (Bit 17)   */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4HEROIM_Msk (0x20000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4HEROIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4NOPAYOIM_Pos (18UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4NOPAYOIM (Bit 18) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4NOPAYOIM_Msk (0x40000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4NOPAYOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4FRAGOIM_Pos (19UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4FRAGOIM (Bit 19)  */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4FRAGOIM_Msk (0x80000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4FRAGOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4UDSBLOIM_Pos (20UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4UDSBLOIM (Bit 20) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV4UDSBLOIM_Msk (0x100000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV4UDSBLOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6GOIM_Pos (21UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6GOIM (Bit 21)     */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6GOIM_Msk (0x200000UL)  /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6GOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6HEROIM_Pos (22UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6HEROIM (Bit 22)   */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6HEROIM_Msk (0x400000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6HEROIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6NOPAYOIM_Pos (23UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6NOPAYOIM (Bit 23) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXIPV6NOPAYOIM_Msk (0x800000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXIPV6NOPAYOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPGOIM_Pos (24UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPGOIM (Bit 24)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPGOIM_Msk (0x1000000UL)  /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPGOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPEROIM_Pos (25UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPEROIM (Bit 25)     */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXUDPEROIM_Msk (0x2000000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXUDPEROIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPGOIM_Pos (26UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPGOIM (Bit 26)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPGOIM_Msk (0x4000000UL)  /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPGOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPEROIM_Pos (27UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPEROIM (Bit 27)     */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXTCPEROIM_Msk (0x8000000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXTCPEROIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPGOIM_Pos (28UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPGOIM (Bit 28)     */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPGOIM_Msk (0x10000000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPGOIM (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPEROIM_Pos (29UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPEROIM (Bit 29)    */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_MASK_RXICMPEROIM_Msk (0x20000000UL) /*!< ETH MMC_IPC_RECEIVE_INTERRUPT_MASK: RXICMPEROIM (Bitfield-Mask: 0x01) */

/* ------------------------  ETH_MMC_IPC_RECEIVE_INTERRUPT  ----------------------- */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4GFIS_Pos (0UL)              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4GFIS (Bit 0)           */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4GFIS_Msk (0x1UL)            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4GFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4HERFIS_Pos (1UL)            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4HERFIS (Bit 1)         */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4HERFIS_Msk (0x2UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4HERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4NOPAYFIS_Pos (2UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4NOPAYFIS (Bit 2)       */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4NOPAYFIS_Msk (0x4UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4NOPAYFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4FRAGFIS_Pos (3UL)           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4FRAGFIS (Bit 3)        */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4FRAGFIS_Msk (0x8UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4FRAGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4UDSBLFIS_Pos (4UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4UDSBLFIS (Bit 4)       */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4UDSBLFIS_Msk (0x10UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4UDSBLFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6GFIS_Pos (5UL)              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6GFIS (Bit 5)           */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6GFIS_Msk (0x20UL)           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6GFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6HERFIS_Pos (6UL)            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6HERFIS (Bit 6)         */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6HERFIS_Msk (0x40UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6HERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6NOPAYFIS_Pos (7UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6NOPAYFIS (Bit 7)       */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6NOPAYFIS_Msk (0x80UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6NOPAYFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPGFIS_Pos (8UL)               /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPGFIS (Bit 8)            */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPGFIS_Msk (0x100UL)           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPERFIS_Pos (9UL)              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPERFIS (Bit 9)           */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPERFIS_Msk (0x200UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPGFIS_Pos (10UL)              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPGFIS (Bit 10)           */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPGFIS_Msk (0x400UL)           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPERFIS_Pos (11UL)             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPERFIS (Bit 11)          */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPERFIS_Msk (0x800UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPGFIS_Pos (12UL)             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPGFIS (Bit 12)          */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPGFIS_Msk (0x1000UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPGFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPERFIS_Pos (13UL)            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPERFIS (Bit 13)         */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPERFIS_Msk (0x2000UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPERFIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4GOIS_Pos (16UL)             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4GOIS (Bit 16)          */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4GOIS_Msk (0x10000UL)        /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4GOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4HEROIS_Pos (17UL)           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4HEROIS (Bit 17)        */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4HEROIS_Msk (0x20000UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4HEROIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4NOPAYOIS_Pos (18UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4NOPAYOIS (Bit 18)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4NOPAYOIS_Msk (0x40000UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4NOPAYOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4FRAGOIS_Pos (19UL)          /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4FRAGOIS (Bit 19)       */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4FRAGOIS_Msk (0x80000UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4FRAGOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4UDSBLOIS_Pos (20UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4UDSBLOIS (Bit 20)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV4UDSBLOIS_Msk (0x100000UL)   /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV4UDSBLOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6GOIS_Pos (21UL)             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6GOIS (Bit 21)          */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6GOIS_Msk (0x200000UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6GOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6HEROIS_Pos (22UL)           /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6HEROIS (Bit 22)        */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6HEROIS_Msk (0x400000UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6HEROIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6NOPAYOIS_Pos (23UL)         /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6NOPAYOIS (Bit 23)      */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXIPV6NOPAYOIS_Msk (0x800000UL)   /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXIPV6NOPAYOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPGOIS_Pos (24UL)              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPGOIS (Bit 24)           */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPGOIS_Msk (0x1000000UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPGOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPEROIS_Pos (25UL)             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPEROIS (Bit 25)          */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXUDPEROIS_Msk (0x2000000UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXUDPEROIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPGOIS_Pos (26UL)              /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPGOIS (Bit 26)           */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPGOIS_Msk (0x4000000UL)       /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPGOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPEROIS_Pos (27UL)             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPEROIS (Bit 27)          */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXTCPEROIS_Msk (0x8000000UL)      /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXTCPEROIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPGOIS_Pos (28UL)             /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPGOIS (Bit 28)          */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPGOIS_Msk (0x10000000UL)     /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPGOIS (Bitfield-Mask: 0x01) */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPEROIS_Pos (29UL)            /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPEROIS (Bit 29)         */
#define ETH_MMC_IPC_RECEIVE_INTERRUPT_RXICMPEROIS_Msk (0x20000000UL)    /*!< ETH MMC_IPC_RECEIVE_INTERRUPT: RXICMPEROIS (Bitfield-Mask: 0x01) */

/* ---------------------------  ETH_RXIPV4_GOOD_FRAMES  --------------------------- */
#define ETH_RXIPV4_GOOD_FRAMES_RXIPV4GDFRM_Pos (0UL)                    /*!< ETH RXIPV4_GOOD_FRAMES: RXIPV4GDFRM (Bit 0)                 */
#define ETH_RXIPV4_GOOD_FRAMES_RXIPV4GDFRM_Msk (0xffffffffUL)           /*!< ETH RXIPV4_GOOD_FRAMES: RXIPV4GDFRM (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_RXIPV4_HEADER_ERROR_FRAMES  ----------------------- */
#define ETH_RXIPV4_HEADER_ERROR_FRAMES_RXIPV4HDRERRFRM_Pos (0UL)        /*!< ETH RXIPV4_HEADER_ERROR_FRAMES: RXIPV4HDRERRFRM (Bit 0)     */
#define ETH_RXIPV4_HEADER_ERROR_FRAMES_RXIPV4HDRERRFRM_Msk (0xffffffffUL) /*!< ETH RXIPV4_HEADER_ERROR_FRAMES: RXIPV4HDRERRFRM (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RXIPV4_NO_PAYLOAD_FRAMES  ------------------------ */
#define ETH_RXIPV4_NO_PAYLOAD_FRAMES_RXIPV4NOPAYFRM_Pos (0UL)           /*!< ETH RXIPV4_NO_PAYLOAD_FRAMES: RXIPV4NOPAYFRM (Bit 0)        */
#define ETH_RXIPV4_NO_PAYLOAD_FRAMES_RXIPV4NOPAYFRM_Msk (0xffffffffUL)  /*!< ETH RXIPV4_NO_PAYLOAD_FRAMES: RXIPV4NOPAYFRM (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RXIPV4_FRAGMENTED_FRAMES  ------------------------ */
#define ETH_RXIPV4_FRAGMENTED_FRAMES_RXIPV4FRAGFRM_Pos (0UL)            /*!< ETH RXIPV4_FRAGMENTED_FRAMES: RXIPV4FRAGFRM (Bit 0)         */
#define ETH_RXIPV4_FRAGMENTED_FRAMES_RXIPV4FRAGFRM_Msk (0xffffffffUL)   /*!< ETH RXIPV4_FRAGMENTED_FRAMES: RXIPV4FRAGFRM (Bitfield-Mask: 0xffffffff) */

/* -------------------  ETH_RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES  ------------------ */
#define ETH_RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES_RXIPV4UDSBLFRM_Pos (0UL) /*!< ETH RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES: RXIPV4UDSBLFRM (Bit 0) */
#define ETH_RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES_RXIPV4UDSBLFRM_Msk (0xffffffffUL) /*!< ETH RXIPV4_UDP_CHECKSUM_DISABLED_FRAMES: RXIPV4UDSBLFRM (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXIPV6_GOOD_FRAMES  --------------------------- */
#define ETH_RXIPV6_GOOD_FRAMES_RXIPV6GDFRM_Pos (0UL)                    /*!< ETH RXIPV6_GOOD_FRAMES: RXIPV6GDFRM (Bit 0)                 */
#define ETH_RXIPV6_GOOD_FRAMES_RXIPV6GDFRM_Msk (0xffffffffUL)           /*!< ETH RXIPV6_GOOD_FRAMES: RXIPV6GDFRM (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_RXIPV6_HEADER_ERROR_FRAMES  ----------------------- */
#define ETH_RXIPV6_HEADER_ERROR_FRAMES_RXIPV6HDRERRFRM_Pos (0UL)        /*!< ETH RXIPV6_HEADER_ERROR_FRAMES: RXIPV6HDRERRFRM (Bit 0)     */
#define ETH_RXIPV6_HEADER_ERROR_FRAMES_RXIPV6HDRERRFRM_Msk (0xffffffffUL) /*!< ETH RXIPV6_HEADER_ERROR_FRAMES: RXIPV6HDRERRFRM (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RXIPV6_NO_PAYLOAD_FRAMES  ------------------------ */
#define ETH_RXIPV6_NO_PAYLOAD_FRAMES_RXIPV6NOPAYFRM_Pos (0UL)           /*!< ETH RXIPV6_NO_PAYLOAD_FRAMES: RXIPV6NOPAYFRM (Bit 0)        */
#define ETH_RXIPV6_NO_PAYLOAD_FRAMES_RXIPV6NOPAYFRM_Msk (0xffffffffUL)  /*!< ETH RXIPV6_NO_PAYLOAD_FRAMES: RXIPV6NOPAYFRM (Bitfield-Mask: 0xffffffff) */

/* ----------------------------  ETH_RXUDP_GOOD_FRAMES  --------------------------- */
#define ETH_RXUDP_GOOD_FRAMES_RXUDPGDFRM_Pos  (0UL)                     /*!< ETH RXUDP_GOOD_FRAMES: RXUDPGDFRM (Bit 0)                   */
#define ETH_RXUDP_GOOD_FRAMES_RXUDPGDFRM_Msk  (0xffffffffUL)            /*!< ETH RXUDP_GOOD_FRAMES: RXUDPGDFRM (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXUDP_ERROR_FRAMES  --------------------------- */
#define ETH_RXUDP_ERROR_FRAMES_RXUDPERRFRM_Pos (0UL)                    /*!< ETH RXUDP_ERROR_FRAMES: RXUDPERRFRM (Bit 0)                 */
#define ETH_RXUDP_ERROR_FRAMES_RXUDPERRFRM_Msk (0xffffffffUL)           /*!< ETH RXUDP_ERROR_FRAMES: RXUDPERRFRM (Bitfield-Mask: 0xffffffff) */

/* ----------------------------  ETH_RXTCP_GOOD_FRAMES  --------------------------- */
#define ETH_RXTCP_GOOD_FRAMES_RXTCPGDFRM_Pos  (0UL)                     /*!< ETH RXTCP_GOOD_FRAMES: RXTCPGDFRM (Bit 0)                   */
#define ETH_RXTCP_GOOD_FRAMES_RXTCPGDFRM_Msk  (0xffffffffUL)            /*!< ETH RXTCP_GOOD_FRAMES: RXTCPGDFRM (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXTCP_ERROR_FRAMES  --------------------------- */
#define ETH_RXTCP_ERROR_FRAMES_RXTCPERRFRM_Pos (0UL)                    /*!< ETH RXTCP_ERROR_FRAMES: RXTCPERRFRM (Bit 0)                 */
#define ETH_RXTCP_ERROR_FRAMES_RXTCPERRFRM_Msk (0xffffffffUL)           /*!< ETH RXTCP_ERROR_FRAMES: RXTCPERRFRM (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXICMP_GOOD_FRAMES  --------------------------- */
#define ETH_RXICMP_GOOD_FRAMES_RXICMPGDFRM_Pos (0UL)                    /*!< ETH RXICMP_GOOD_FRAMES: RXICMPGDFRM (Bit 0)                 */
#define ETH_RXICMP_GOOD_FRAMES_RXICMPGDFRM_Msk (0xffffffffUL)           /*!< ETH RXICMP_GOOD_FRAMES: RXICMPGDFRM (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXICMP_ERROR_FRAMES  -------------------------- */
#define ETH_RXICMP_ERROR_FRAMES_RXICMPERRFRM_Pos (0UL)                  /*!< ETH RXICMP_ERROR_FRAMES: RXICMPERRFRM (Bit 0)               */
#define ETH_RXICMP_ERROR_FRAMES_RXICMPERRFRM_Msk (0xffffffffUL)         /*!< ETH RXICMP_ERROR_FRAMES: RXICMPERRFRM (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXIPV4_GOOD_OCTETS  --------------------------- */
#define ETH_RXIPV4_GOOD_OCTETS_RXIPV4GDOCT_Pos (0UL)                    /*!< ETH RXIPV4_GOOD_OCTETS: RXIPV4GDOCT (Bit 0)                 */
#define ETH_RXIPV4_GOOD_OCTETS_RXIPV4GDOCT_Msk (0xffffffffUL)           /*!< ETH RXIPV4_GOOD_OCTETS: RXIPV4GDOCT (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_RXIPV4_HEADER_ERROR_OCTETS  ----------------------- */
#define ETH_RXIPV4_HEADER_ERROR_OCTETS_RXIPV4HDRERROCT_Pos (0UL)        /*!< ETH RXIPV4_HEADER_ERROR_OCTETS: RXIPV4HDRERROCT (Bit 0)     */
#define ETH_RXIPV4_HEADER_ERROR_OCTETS_RXIPV4HDRERROCT_Msk (0xffffffffUL) /*!< ETH RXIPV4_HEADER_ERROR_OCTETS: RXIPV4HDRERROCT (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RXIPV4_NO_PAYLOAD_OCTETS  ------------------------ */
#define ETH_RXIPV4_NO_PAYLOAD_OCTETS_RXIPV4NOPAYOCT_Pos (0UL)           /*!< ETH RXIPV4_NO_PAYLOAD_OCTETS: RXIPV4NOPAYOCT (Bit 0)        */
#define ETH_RXIPV4_NO_PAYLOAD_OCTETS_RXIPV4NOPAYOCT_Msk (0xffffffffUL)  /*!< ETH RXIPV4_NO_PAYLOAD_OCTETS: RXIPV4NOPAYOCT (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RXIPV4_FRAGMENTED_OCTETS  ------------------------ */
#define ETH_RXIPV4_FRAGMENTED_OCTETS_RXIPV4FRAGOCT_Pos (0UL)            /*!< ETH RXIPV4_FRAGMENTED_OCTETS: RXIPV4FRAGOCT (Bit 0)         */
#define ETH_RXIPV4_FRAGMENTED_OCTETS_RXIPV4FRAGOCT_Msk (0xffffffffUL)   /*!< ETH RXIPV4_FRAGMENTED_OCTETS: RXIPV4FRAGOCT (Bitfield-Mask: 0xffffffff) */

/* -------------------  ETH_RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS  ------------------- */
#define ETH_RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS_RXIPV4UDSBLOCT_Pos (0UL) /*!< ETH RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS: RXIPV4UDSBLOCT (Bit 0) */
#define ETH_RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS_RXIPV4UDSBLOCT_Msk (0xffffffffUL) /*!< ETH RXIPV4_UDP_CHECKSUM_DISABLE_OCTETS: RXIPV4UDSBLOCT (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXIPV6_GOOD_OCTETS  --------------------------- */
#define ETH_RXIPV6_GOOD_OCTETS_RXIPV6GDOCT_Pos (0UL)                    /*!< ETH RXIPV6_GOOD_OCTETS: RXIPV6GDOCT (Bit 0)                 */
#define ETH_RXIPV6_GOOD_OCTETS_RXIPV6GDOCT_Msk (0xffffffffUL)           /*!< ETH RXIPV6_GOOD_OCTETS: RXIPV6GDOCT (Bitfield-Mask: 0xffffffff) */

/* -----------------------  ETH_RXIPV6_HEADER_ERROR_OCTETS  ----------------------- */
#define ETH_RXIPV6_HEADER_ERROR_OCTETS_RXIPV6HDRERROCT_Pos (0UL)        /*!< ETH RXIPV6_HEADER_ERROR_OCTETS: RXIPV6HDRERROCT (Bit 0)     */
#define ETH_RXIPV6_HEADER_ERROR_OCTETS_RXIPV6HDRERROCT_Msk (0xffffffffUL) /*!< ETH RXIPV6_HEADER_ERROR_OCTETS: RXIPV6HDRERROCT (Bitfield-Mask: 0xffffffff) */

/* ------------------------  ETH_RXIPV6_NO_PAYLOAD_OCTETS  ------------------------ */
#define ETH_RXIPV6_NO_PAYLOAD_OCTETS_RXIPV6NOPAYOCT_Pos (0UL)           /*!< ETH RXIPV6_NO_PAYLOAD_OCTETS: RXIPV6NOPAYOCT (Bit 0)        */
#define ETH_RXIPV6_NO_PAYLOAD_OCTETS_RXIPV6NOPAYOCT_Msk (0xffffffffUL)  /*!< ETH RXIPV6_NO_PAYLOAD_OCTETS: RXIPV6NOPAYOCT (Bitfield-Mask: 0xffffffff) */

/* ----------------------------  ETH_RXUDP_GOOD_OCTETS  --------------------------- */
#define ETH_RXUDP_GOOD_OCTETS_RXUDPGDOCT_Pos  (0UL)                     /*!< ETH RXUDP_GOOD_OCTETS: RXUDPGDOCT (Bit 0)                   */
#define ETH_RXUDP_GOOD_OCTETS_RXUDPGDOCT_Msk  (0xffffffffUL)            /*!< ETH RXUDP_GOOD_OCTETS: RXUDPGDOCT (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXUDP_ERROR_OCTETS  --------------------------- */
#define ETH_RXUDP_ERROR_OCTETS_RXUDPERROCT_Pos (0UL)                    /*!< ETH RXUDP_ERROR_OCTETS: RXUDPERROCT (Bit 0)                 */
#define ETH_RXUDP_ERROR_OCTETS_RXUDPERROCT_Msk (0xffffffffUL)           /*!< ETH RXUDP_ERROR_OCTETS: RXUDPERROCT (Bitfield-Mask: 0xffffffff) */

/* ----------------------------  ETH_RXTCP_GOOD_OCTETS  --------------------------- */
#define ETH_RXTCP_GOOD_OCTETS_RXTCPGDOCT_Pos  (0UL)                     /*!< ETH RXTCP_GOOD_OCTETS: RXTCPGDOCT (Bit 0)                   */
#define ETH_RXTCP_GOOD_OCTETS_RXTCPGDOCT_Msk  (0xffffffffUL)            /*!< ETH RXTCP_GOOD_OCTETS: RXTCPGDOCT (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXTCP_ERROR_OCTETS  --------------------------- */
#define ETH_RXTCP_ERROR_OCTETS_RXTCPERROCT_Pos (0UL)                    /*!< ETH RXTCP_ERROR_OCTETS: RXTCPERROCT (Bit 0)                 */
#define ETH_RXTCP_ERROR_OCTETS_RXTCPERROCT_Msk (0xffffffffUL)           /*!< ETH RXTCP_ERROR_OCTETS: RXTCPERROCT (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXICMP_GOOD_OCTETS  --------------------------- */
#define ETH_RXICMP_GOOD_OCTETS_RXICMPGDOCT_Pos (0UL)                    /*!< ETH RXICMP_GOOD_OCTETS: RXICMPGDOCT (Bit 0)                 */
#define ETH_RXICMP_GOOD_OCTETS_RXICMPGDOCT_Msk (0xffffffffUL)           /*!< ETH RXICMP_GOOD_OCTETS: RXICMPGDOCT (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  ETH_RXICMP_ERROR_OCTETS  -------------------------- */
#define ETH_RXICMP_ERROR_OCTETS_RXICMPERROCT_Pos (0UL)                  /*!< ETH RXICMP_ERROR_OCTETS: RXICMPERROCT (Bit 0)               */
#define ETH_RXICMP_ERROR_OCTETS_RXICMPERROCT_Msk (0xffffffffUL)         /*!< ETH RXICMP_ERROR_OCTETS: RXICMPERROCT (Bitfield-Mask: 0xffffffff) */

/* ----------------------------  ETH_TIMESTAMP_CONTROL  --------------------------- */
#define ETH_TIMESTAMP_CONTROL_TSENA_Pos       (0UL)                     /*!< ETH TIMESTAMP_CONTROL: TSENA (Bit 0)                        */
#define ETH_TIMESTAMP_CONTROL_TSENA_Msk       (0x1UL)                   /*!< ETH TIMESTAMP_CONTROL: TSENA (Bitfield-Mask: 0x01)          */
#define ETH_TIMESTAMP_CONTROL_TSCFUPDT_Pos    (1UL)                     /*!< ETH TIMESTAMP_CONTROL: TSCFUPDT (Bit 1)                     */
#define ETH_TIMESTAMP_CONTROL_TSCFUPDT_Msk    (0x2UL)                   /*!< ETH TIMESTAMP_CONTROL: TSCFUPDT (Bitfield-Mask: 0x01)       */
#define ETH_TIMESTAMP_CONTROL_TSINIT_Pos      (2UL)                     /*!< ETH TIMESTAMP_CONTROL: TSINIT (Bit 2)                       */
#define ETH_TIMESTAMP_CONTROL_TSINIT_Msk      (0x4UL)                   /*!< ETH TIMESTAMP_CONTROL: TSINIT (Bitfield-Mask: 0x01)         */
#define ETH_TIMESTAMP_CONTROL_TSUPDT_Pos      (3UL)                     /*!< ETH TIMESTAMP_CONTROL: TSUPDT (Bit 3)                       */
#define ETH_TIMESTAMP_CONTROL_TSUPDT_Msk      (0x8UL)                   /*!< ETH TIMESTAMP_CONTROL: TSUPDT (Bitfield-Mask: 0x01)         */
#define ETH_TIMESTAMP_CONTROL_TSTRIG_Pos      (4UL)                     /*!< ETH TIMESTAMP_CONTROL: TSTRIG (Bit 4)                       */
#define ETH_TIMESTAMP_CONTROL_TSTRIG_Msk      (0x10UL)                  /*!< ETH TIMESTAMP_CONTROL: TSTRIG (Bitfield-Mask: 0x01)         */
#define ETH_TIMESTAMP_CONTROL_TSADDREG_Pos    (5UL)                     /*!< ETH TIMESTAMP_CONTROL: TSADDREG (Bit 5)                     */
#define ETH_TIMESTAMP_CONTROL_TSADDREG_Msk    (0x20UL)                  /*!< ETH TIMESTAMP_CONTROL: TSADDREG (Bitfield-Mask: 0x01)       */
#define ETH_TIMESTAMP_CONTROL_TSENALL_Pos     (8UL)                     /*!< ETH TIMESTAMP_CONTROL: TSENALL (Bit 8)                      */
#define ETH_TIMESTAMP_CONTROL_TSENALL_Msk     (0x100UL)                 /*!< ETH TIMESTAMP_CONTROL: TSENALL (Bitfield-Mask: 0x01)        */
#define ETH_TIMESTAMP_CONTROL_TSCTRLSSR_Pos   (9UL)                     /*!< ETH TIMESTAMP_CONTROL: TSCTRLSSR (Bit 9)                    */
#define ETH_TIMESTAMP_CONTROL_TSCTRLSSR_Msk   (0x200UL)                 /*!< ETH TIMESTAMP_CONTROL: TSCTRLSSR (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_CONTROL_TSVER2ENA_Pos   (10UL)                    /*!< ETH TIMESTAMP_CONTROL: TSVER2ENA (Bit 10)                   */
#define ETH_TIMESTAMP_CONTROL_TSVER2ENA_Msk   (0x400UL)                 /*!< ETH TIMESTAMP_CONTROL: TSVER2ENA (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_CONTROL_TSIPENA_Pos     (11UL)                    /*!< ETH TIMESTAMP_CONTROL: TSIPENA (Bit 11)                     */
#define ETH_TIMESTAMP_CONTROL_TSIPENA_Msk     (0x800UL)                 /*!< ETH TIMESTAMP_CONTROL: TSIPENA (Bitfield-Mask: 0x01)        */
#define ETH_TIMESTAMP_CONTROL_TSIPV6ENA_Pos   (12UL)                    /*!< ETH TIMESTAMP_CONTROL: TSIPV6ENA (Bit 12)                   */
#define ETH_TIMESTAMP_CONTROL_TSIPV6ENA_Msk   (0x1000UL)                /*!< ETH TIMESTAMP_CONTROL: TSIPV6ENA (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_CONTROL_TSIPV4ENA_Pos   (13UL)                    /*!< ETH TIMESTAMP_CONTROL: TSIPV4ENA (Bit 13)                   */
#define ETH_TIMESTAMP_CONTROL_TSIPV4ENA_Msk   (0x2000UL)                /*!< ETH TIMESTAMP_CONTROL: TSIPV4ENA (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_CONTROL_TSEVNTENA_Pos   (14UL)                    /*!< ETH TIMESTAMP_CONTROL: TSEVNTENA (Bit 14)                   */
#define ETH_TIMESTAMP_CONTROL_TSEVNTENA_Msk   (0x4000UL)                /*!< ETH TIMESTAMP_CONTROL: TSEVNTENA (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_CONTROL_TSMSTRENA_Pos   (15UL)                    /*!< ETH TIMESTAMP_CONTROL: TSMSTRENA (Bit 15)                   */
#define ETH_TIMESTAMP_CONTROL_TSMSTRENA_Msk   (0x8000UL)                /*!< ETH TIMESTAMP_CONTROL: TSMSTRENA (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_CONTROL_SNAPTYPSEL_Pos  (16UL)                    /*!< ETH TIMESTAMP_CONTROL: SNAPTYPSEL (Bit 16)                  */
#define ETH_TIMESTAMP_CONTROL_SNAPTYPSEL_Msk  (0x30000UL)               /*!< ETH TIMESTAMP_CONTROL: SNAPTYPSEL (Bitfield-Mask: 0x03)     */
#define ETH_TIMESTAMP_CONTROL_TSENMACADDR_Pos (18UL)                    /*!< ETH TIMESTAMP_CONTROL: TSENMACADDR (Bit 18)                 */
#define ETH_TIMESTAMP_CONTROL_TSENMACADDR_Msk (0x40000UL)               /*!< ETH TIMESTAMP_CONTROL: TSENMACADDR (Bitfield-Mask: 0x01)    */

/* --------------------------  ETH_SUB_SECOND_INCREMENT  -------------------------- */
#define ETH_SUB_SECOND_INCREMENT_SSINC_Pos    (0UL)                     /*!< ETH SUB_SECOND_INCREMENT: SSINC (Bit 0)                     */
#define ETH_SUB_SECOND_INCREMENT_SSINC_Msk    (0xffUL)                  /*!< ETH SUB_SECOND_INCREMENT: SSINC (Bitfield-Mask: 0xff)       */

/* ---------------------------  ETH_SYSTEM_TIME_SECONDS  -------------------------- */
#define ETH_SYSTEM_TIME_SECONDS_TSS_Pos       (0UL)                     /*!< ETH SYSTEM_TIME_SECONDS: TSS (Bit 0)                        */
#define ETH_SYSTEM_TIME_SECONDS_TSS_Msk       (0xffffffffUL)            /*!< ETH SYSTEM_TIME_SECONDS: TSS (Bitfield-Mask: 0xffffffff)    */

/* -------------------------  ETH_SYSTEM_TIME_NANOSECONDS  ------------------------ */
#define ETH_SYSTEM_TIME_NANOSECONDS_TSSS_Pos  (0UL)                     /*!< ETH SYSTEM_TIME_NANOSECONDS: TSSS (Bit 0)                   */
#define ETH_SYSTEM_TIME_NANOSECONDS_TSSS_Msk  (0x7fffffffUL)            /*!< ETH SYSTEM_TIME_NANOSECONDS: TSSS (Bitfield-Mask: 0x7fffffff) */

/* -----------------------  ETH_SYSTEM_TIME_SECONDS_UPDATE  ----------------------- */
#define ETH_SYSTEM_TIME_SECONDS_UPDATE_TSS_Pos (0UL)                    /*!< ETH SYSTEM_TIME_SECONDS_UPDATE: TSS (Bit 0)                 */
#define ETH_SYSTEM_TIME_SECONDS_UPDATE_TSS_Msk (0xffffffffUL)           /*!< ETH SYSTEM_TIME_SECONDS_UPDATE: TSS (Bitfield-Mask: 0xffffffff) */

/* ---------------------  ETH_SYSTEM_TIME_NANOSECONDS_UPDATE  --------------------- */
#define ETH_SYSTEM_TIME_NANOSECONDS_UPDATE_TSSS_Pos (0UL)               /*!< ETH SYSTEM_TIME_NANOSECONDS_UPDATE: TSSS (Bit 0)            */
#define ETH_SYSTEM_TIME_NANOSECONDS_UPDATE_TSSS_Msk (0x7fffffffUL)      /*!< ETH SYSTEM_TIME_NANOSECONDS_UPDATE: TSSS (Bitfield-Mask: 0x7fffffff) */
#define ETH_SYSTEM_TIME_NANOSECONDS_UPDATE_ADDSUB_Pos (31UL)            /*!< ETH SYSTEM_TIME_NANOSECONDS_UPDATE: ADDSUB (Bit 31)         */
#define ETH_SYSTEM_TIME_NANOSECONDS_UPDATE_ADDSUB_Msk (0x80000000UL)    /*!< ETH SYSTEM_TIME_NANOSECONDS_UPDATE: ADDSUB (Bitfield-Mask: 0x01) */

/* ----------------------------  ETH_TIMESTAMP_ADDEND  ---------------------------- */
#define ETH_TIMESTAMP_ADDEND_TSAR_Pos         (0UL)                     /*!< ETH TIMESTAMP_ADDEND: TSAR (Bit 0)                          */
#define ETH_TIMESTAMP_ADDEND_TSAR_Msk         (0xffffffffUL)            /*!< ETH TIMESTAMP_ADDEND: TSAR (Bitfield-Mask: 0xffffffff)      */

/* ---------------------------  ETH_TARGET_TIME_SECONDS  -------------------------- */
#define ETH_TARGET_TIME_SECONDS_TSTR_Pos      (0UL)                     /*!< ETH TARGET_TIME_SECONDS: TSTR (Bit 0)                       */
#define ETH_TARGET_TIME_SECONDS_TSTR_Msk      (0xffffffffUL)            /*!< ETH TARGET_TIME_SECONDS: TSTR (Bitfield-Mask: 0xffffffff)   */

/* -------------------------  ETH_TARGET_TIME_NANOSECONDS  ------------------------ */
#define ETH_TARGET_TIME_NANOSECONDS_TTSLO_Pos (0UL)                     /*!< ETH TARGET_TIME_NANOSECONDS: TTSLO (Bit 0)                  */
#define ETH_TARGET_TIME_NANOSECONDS_TTSLO_Msk (0x7fffffffUL)            /*!< ETH TARGET_TIME_NANOSECONDS: TTSLO (Bitfield-Mask: 0x7fffffff) */
#define ETH_TARGET_TIME_NANOSECONDS_TRGTBUSY_Pos (31UL)                 /*!< ETH TARGET_TIME_NANOSECONDS: TRGTBUSY (Bit 31)              */
#define ETH_TARGET_TIME_NANOSECONDS_TRGTBUSY_Msk (0x80000000UL)         /*!< ETH TARGET_TIME_NANOSECONDS: TRGTBUSY (Bitfield-Mask: 0x01) */

/* ---------------------  ETH_SYSTEM_TIME_HIGHER_WORD_SECONDS  -------------------- */
#define ETH_SYSTEM_TIME_HIGHER_WORD_SECONDS_TSHWR_Pos (0UL)             /*!< ETH SYSTEM_TIME_HIGHER_WORD_SECONDS: TSHWR (Bit 0)          */
#define ETH_SYSTEM_TIME_HIGHER_WORD_SECONDS_TSHWR_Msk (0xffffUL)        /*!< ETH SYSTEM_TIME_HIGHER_WORD_SECONDS: TSHWR (Bitfield-Mask: 0xffff) */

/* ----------------------------  ETH_TIMESTAMP_STATUS  ---------------------------- */
#define ETH_TIMESTAMP_STATUS_TSSOVF_Pos       (0UL)                     /*!< ETH TIMESTAMP_STATUS: TSSOVF (Bit 0)                        */
#define ETH_TIMESTAMP_STATUS_TSSOVF_Msk       (0x1UL)                   /*!< ETH TIMESTAMP_STATUS: TSSOVF (Bitfield-Mask: 0x01)          */
#define ETH_TIMESTAMP_STATUS_TSTARGT_Pos      (1UL)                     /*!< ETH TIMESTAMP_STATUS: TSTARGT (Bit 1)                       */
#define ETH_TIMESTAMP_STATUS_TSTARGT_Msk      (0x2UL)                   /*!< ETH TIMESTAMP_STATUS: TSTARGT (Bitfield-Mask: 0x01)         */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR_Pos    (3UL)                     /*!< ETH TIMESTAMP_STATUS: TSTRGTERR (Bit 3)                     */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR_Msk    (0x8UL)                   /*!< ETH TIMESTAMP_STATUS: TSTRGTERR (Bitfield-Mask: 0x01)       */
#define ETH_TIMESTAMP_STATUS_TSTARGT1_Pos     (4UL)                     /*!< ETH TIMESTAMP_STATUS: TSTARGT1 (Bit 4)                      */
#define ETH_TIMESTAMP_STATUS_TSTARGT1_Msk     (0x10UL)                  /*!< ETH TIMESTAMP_STATUS: TSTARGT1 (Bitfield-Mask: 0x01)        */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR1_Pos   (5UL)                     /*!< ETH TIMESTAMP_STATUS: TSTRGTERR1 (Bit 5)                    */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR1_Msk   (0x20UL)                  /*!< ETH TIMESTAMP_STATUS: TSTRGTERR1 (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_STATUS_TSTARGT2_Pos     (6UL)                     /*!< ETH TIMESTAMP_STATUS: TSTARGT2 (Bit 6)                      */
#define ETH_TIMESTAMP_STATUS_TSTARGT2_Msk     (0x40UL)                  /*!< ETH TIMESTAMP_STATUS: TSTARGT2 (Bitfield-Mask: 0x01)        */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR2_Pos   (7UL)                     /*!< ETH TIMESTAMP_STATUS: TSTRGTERR2 (Bit 7)                    */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR2_Msk   (0x80UL)                  /*!< ETH TIMESTAMP_STATUS: TSTRGTERR2 (Bitfield-Mask: 0x01)      */
#define ETH_TIMESTAMP_STATUS_TSTARGT3_Pos     (8UL)                     /*!< ETH TIMESTAMP_STATUS: TSTARGT3 (Bit 8)                      */
#define ETH_TIMESTAMP_STATUS_TSTARGT3_Msk     (0x100UL)                 /*!< ETH TIMESTAMP_STATUS: TSTARGT3 (Bitfield-Mask: 0x01)        */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR3_Pos   (9UL)                     /*!< ETH TIMESTAMP_STATUS: TSTRGTERR3 (Bit 9)                    */
#define ETH_TIMESTAMP_STATUS_TSTRGTERR3_Msk   (0x200UL)                 /*!< ETH TIMESTAMP_STATUS: TSTRGTERR3 (Bitfield-Mask: 0x01)      */

/* -------------------------------  ETH_PPS_CONTROL  ------------------------------ */
#define ETH_PPS_CONTROL_PPSCTRL_PPSCMD_Pos    (0UL)                     /*!< ETH PPS_CONTROL: PPSCTRL_PPSCMD (Bit 0)                     */
#define ETH_PPS_CONTROL_PPSCTRL_PPSCMD_Msk    (0xfUL)                   /*!< ETH PPS_CONTROL: PPSCTRL_PPSCMD (Bitfield-Mask: 0x0f)       */
#define ETH_PPS_CONTROL_PPSEN0_Pos            (4UL)                     /*!< ETH PPS_CONTROL: PPSEN0 (Bit 4)                             */
#define ETH_PPS_CONTROL_PPSEN0_Msk            (0x10UL)                  /*!< ETH PPS_CONTROL: PPSEN0 (Bitfield-Mask: 0x01)               */
#define ETH_PPS_CONTROL_TRGTMODSEL0_Pos       (5UL)                     /*!< ETH PPS_CONTROL: TRGTMODSEL0 (Bit 5)                        */
#define ETH_PPS_CONTROL_TRGTMODSEL0_Msk       (0x60UL)                  /*!< ETH PPS_CONTROL: TRGTMODSEL0 (Bitfield-Mask: 0x03)          */
#define ETH_PPS_CONTROL_PPSCMD1_Pos           (8UL)                     /*!< ETH PPS_CONTROL: PPSCMD1 (Bit 8)                            */
#define ETH_PPS_CONTROL_PPSCMD1_Msk           (0x700UL)                 /*!< ETH PPS_CONTROL: PPSCMD1 (Bitfield-Mask: 0x07)              */
#define ETH_PPS_CONTROL_TRGTMODSEL1_Pos       (13UL)                    /*!< ETH PPS_CONTROL: TRGTMODSEL1 (Bit 13)                       */
#define ETH_PPS_CONTROL_TRGTMODSEL1_Msk       (0x6000UL)                /*!< ETH PPS_CONTROL: TRGTMODSEL1 (Bitfield-Mask: 0x03)          */
#define ETH_PPS_CONTROL_PPSCMD2_Pos           (16UL)                    /*!< ETH PPS_CONTROL: PPSCMD2 (Bit 16)                           */
#define ETH_PPS_CONTROL_PPSCMD2_Msk           (0x70000UL)               /*!< ETH PPS_CONTROL: PPSCMD2 (Bitfield-Mask: 0x07)              */
#define ETH_PPS_CONTROL_TRGTMODSEL2_Pos       (21UL)                    /*!< ETH PPS_CONTROL: TRGTMODSEL2 (Bit 21)                       */
#define ETH_PPS_CONTROL_TRGTMODSEL2_Msk       (0x600000UL)              /*!< ETH PPS_CONTROL: TRGTMODSEL2 (Bitfield-Mask: 0x03)          */
#define ETH_PPS_CONTROL_PPSCMD3_Pos           (24UL)                    /*!< ETH PPS_CONTROL: PPSCMD3 (Bit 24)                           */
#define ETH_PPS_CONTROL_PPSCMD3_Msk           (0x7000000UL)             /*!< ETH PPS_CONTROL: PPSCMD3 (Bitfield-Mask: 0x07)              */
#define ETH_PPS_CONTROL_TRGTMODSEL3_Pos       (29UL)                    /*!< ETH PPS_CONTROL: TRGTMODSEL3 (Bit 29)                       */
#define ETH_PPS_CONTROL_TRGTMODSEL3_Msk       (0x60000000UL)            /*!< ETH PPS_CONTROL: TRGTMODSEL3 (Bitfield-Mask: 0x03)          */

/* --------------------------------  ETH_BUS_MODE  -------------------------------- */
#define ETH_BUS_MODE_SWR_Pos                  (0UL)                     /*!< ETH BUS_MODE: SWR (Bit 0)                                   */
#define ETH_BUS_MODE_SWR_Msk                  (0x1UL)                   /*!< ETH BUS_MODE: SWR (Bitfield-Mask: 0x01)                     */
#define ETH_BUS_MODE_DA_Pos                   (1UL)                     /*!< ETH BUS_MODE: DA (Bit 1)                                    */
#define ETH_BUS_MODE_DA_Msk                   (0x2UL)                   /*!< ETH BUS_MODE: DA (Bitfield-Mask: 0x01)                      */
#define ETH_BUS_MODE_DSL_Pos                  (2UL)                     /*!< ETH BUS_MODE: DSL (Bit 2)                                   */
#define ETH_BUS_MODE_DSL_Msk                  (0x7cUL)                  /*!< ETH BUS_MODE: DSL (Bitfield-Mask: 0x1f)                     */
#define ETH_BUS_MODE_ATDS_Pos                 (7UL)                     /*!< ETH BUS_MODE: ATDS (Bit 7)                                  */
#define ETH_BUS_MODE_ATDS_Msk                 (0x80UL)                  /*!< ETH BUS_MODE: ATDS (Bitfield-Mask: 0x01)                    */
#define ETH_BUS_MODE_PBL_Pos                  (8UL)                     /*!< ETH BUS_MODE: PBL (Bit 8)                                   */
#define ETH_BUS_MODE_PBL_Msk                  (0x3f00UL)                /*!< ETH BUS_MODE: PBL (Bitfield-Mask: 0x3f)                     */
#define ETH_BUS_MODE_PR_Pos                   (14UL)                    /*!< ETH BUS_MODE: PR (Bit 14)                                   */
#define ETH_BUS_MODE_PR_Msk                   (0xc000UL)                /*!< ETH BUS_MODE: PR (Bitfield-Mask: 0x03)                      */
#define ETH_BUS_MODE_FB_Pos                   (16UL)                    /*!< ETH BUS_MODE: FB (Bit 16)                                   */
#define ETH_BUS_MODE_FB_Msk                   (0x10000UL)               /*!< ETH BUS_MODE: FB (Bitfield-Mask: 0x01)                      */
#define ETH_BUS_MODE_RPBL_Pos                 (17UL)                    /*!< ETH BUS_MODE: RPBL (Bit 17)                                 */
#define ETH_BUS_MODE_RPBL_Msk                 (0x7e0000UL)              /*!< ETH BUS_MODE: RPBL (Bitfield-Mask: 0x3f)                    */
#define ETH_BUS_MODE_USP_Pos                  (23UL)                    /*!< ETH BUS_MODE: USP (Bit 23)                                  */
#define ETH_BUS_MODE_USP_Msk                  (0x800000UL)              /*!< ETH BUS_MODE: USP (Bitfield-Mask: 0x01)                     */
#define ETH_BUS_MODE_EIGHTxPBL_Pos            (24UL)                    /*!< ETH BUS_MODE: EIGHTxPBL (Bit 24)                            */
#define ETH_BUS_MODE_EIGHTxPBL_Msk            (0x1000000UL)             /*!< ETH BUS_MODE: EIGHTxPBL (Bitfield-Mask: 0x01)               */
#define ETH_BUS_MODE_AAL_Pos                  (25UL)                    /*!< ETH BUS_MODE: AAL (Bit 25)                                  */
#define ETH_BUS_MODE_AAL_Msk                  (0x2000000UL)             /*!< ETH BUS_MODE: AAL (Bitfield-Mask: 0x01)                     */
#define ETH_BUS_MODE_MB_Pos                   (26UL)                    /*!< ETH BUS_MODE: MB (Bit 26)                                   */
#define ETH_BUS_MODE_MB_Msk                   (0x4000000UL)             /*!< ETH BUS_MODE: MB (Bitfield-Mask: 0x01)                      */
#define ETH_BUS_MODE_TXPR_Pos                 (27UL)                    /*!< ETH BUS_MODE: TXPR (Bit 27)                                 */
#define ETH_BUS_MODE_TXPR_Msk                 (0x8000000UL)             /*!< ETH BUS_MODE: TXPR (Bitfield-Mask: 0x01)                    */
#define ETH_BUS_MODE_PRWG_Pos                 (28UL)                    /*!< ETH BUS_MODE: PRWG (Bit 28)                                 */
#define ETH_BUS_MODE_PRWG_Msk                 (0x30000000UL)            /*!< ETH BUS_MODE: PRWG (Bitfield-Mask: 0x03)                    */

/* --------------------------  ETH_TRANSMIT_POLL_DEMAND  -------------------------- */
#define ETH_TRANSMIT_POLL_DEMAND_TPD_Pos      (0UL)                     /*!< ETH TRANSMIT_POLL_DEMAND: TPD (Bit 0)                       */
#define ETH_TRANSMIT_POLL_DEMAND_TPD_Msk      (0xffffffffUL)            /*!< ETH TRANSMIT_POLL_DEMAND: TPD (Bitfield-Mask: 0xffffffff)   */

/* ---------------------------  ETH_RECEIVE_POLL_DEMAND  -------------------------- */
#define ETH_RECEIVE_POLL_DEMAND_RPD_Pos       (0UL)                     /*!< ETH RECEIVE_POLL_DEMAND: RPD (Bit 0)                        */
#define ETH_RECEIVE_POLL_DEMAND_RPD_Msk       (0xffffffffUL)            /*!< ETH RECEIVE_POLL_DEMAND: RPD (Bitfield-Mask: 0xffffffff)    */

/* ---------------------  ETH_RECEIVE_DESCRIPTOR_LIST_ADDRESS  -------------------- */
#define ETH_RECEIVE_DESCRIPTOR_LIST_ADDRESS_RDESLA_32bit_Pos (2UL)      /*!< ETH RECEIVE_DESCRIPTOR_LIST_ADDRESS: RDESLA_32bit (Bit 2)   */
#define ETH_RECEIVE_DESCRIPTOR_LIST_ADDRESS_RDESLA_32bit_Msk (0xfffffffcUL) /*!< ETH RECEIVE_DESCRIPTOR_LIST_ADDRESS: RDESLA_32bit (Bitfield-Mask: 0x3fffffff) */

/* --------------------  ETH_TRANSMIT_DESCRIPTOR_LIST_ADDRESS  -------------------- */
#define ETH_TRANSMIT_DESCRIPTOR_LIST_ADDRESS_TDESLA_32bit_Pos (2UL)     /*!< ETH TRANSMIT_DESCRIPTOR_LIST_ADDRESS: TDESLA_32bit (Bit 2)  */
#define ETH_TRANSMIT_DESCRIPTOR_LIST_ADDRESS_TDESLA_32bit_Msk (0xfffffffcUL) /*!< ETH TRANSMIT_DESCRIPTOR_LIST_ADDRESS: TDESLA_32bit (Bitfield-Mask: 0x3fffffff) */

/* ---------------------------------  ETH_STATUS  --------------------------------- */
#define ETH_STATUS_TI_Pos                     (0UL)                     /*!< ETH STATUS: TI (Bit 0)                                      */
#define ETH_STATUS_TI_Msk                     (0x1UL)                   /*!< ETH STATUS: TI (Bitfield-Mask: 0x01)                        */
#define ETH_STATUS_TPS_Pos                    (1UL)                     /*!< ETH STATUS: TPS (Bit 1)                                     */
#define ETH_STATUS_TPS_Msk                    (0x2UL)                   /*!< ETH STATUS: TPS (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_TU_Pos                     (2UL)                     /*!< ETH STATUS: TU (Bit 2)                                      */
#define ETH_STATUS_TU_Msk                     (0x4UL)                   /*!< ETH STATUS: TU (Bitfield-Mask: 0x01)                        */
#define ETH_STATUS_TJT_Pos                    (3UL)                     /*!< ETH STATUS: TJT (Bit 3)                                     */
#define ETH_STATUS_TJT_Msk                    (0x8UL)                   /*!< ETH STATUS: TJT (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_OVF_Pos                    (4UL)                     /*!< ETH STATUS: OVF (Bit 4)                                     */
#define ETH_STATUS_OVF_Msk                    (0x10UL)                  /*!< ETH STATUS: OVF (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_UNF_Pos                    (5UL)                     /*!< ETH STATUS: UNF (Bit 5)                                     */
#define ETH_STATUS_UNF_Msk                    (0x20UL)                  /*!< ETH STATUS: UNF (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_RI_Pos                     (6UL)                     /*!< ETH STATUS: RI (Bit 6)                                      */
#define ETH_STATUS_RI_Msk                     (0x40UL)                  /*!< ETH STATUS: RI (Bitfield-Mask: 0x01)                        */
#define ETH_STATUS_RU_Pos                     (7UL)                     /*!< ETH STATUS: RU (Bit 7)                                      */
#define ETH_STATUS_RU_Msk                     (0x80UL)                  /*!< ETH STATUS: RU (Bitfield-Mask: 0x01)                        */
#define ETH_STATUS_RPS_Pos                    (8UL)                     /*!< ETH STATUS: RPS (Bit 8)                                     */
#define ETH_STATUS_RPS_Msk                    (0x100UL)                 /*!< ETH STATUS: RPS (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_RWT_Pos                    (9UL)                     /*!< ETH STATUS: RWT (Bit 9)                                     */
#define ETH_STATUS_RWT_Msk                    (0x200UL)                 /*!< ETH STATUS: RWT (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_ETI_Pos                    (10UL)                    /*!< ETH STATUS: ETI (Bit 10)                                    */
#define ETH_STATUS_ETI_Msk                    (0x400UL)                 /*!< ETH STATUS: ETI (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_FBI_Pos                    (13UL)                    /*!< ETH STATUS: FBI (Bit 13)                                    */
#define ETH_STATUS_FBI_Msk                    (0x2000UL)                /*!< ETH STATUS: FBI (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_ERI_Pos                    (14UL)                    /*!< ETH STATUS: ERI (Bit 14)                                    */
#define ETH_STATUS_ERI_Msk                    (0x4000UL)                /*!< ETH STATUS: ERI (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_AIS_Pos                    (15UL)                    /*!< ETH STATUS: AIS (Bit 15)                                    */
#define ETH_STATUS_AIS_Msk                    (0x8000UL)                /*!< ETH STATUS: AIS (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_NIS_Pos                    (16UL)                    /*!< ETH STATUS: NIS (Bit 16)                                    */
#define ETH_STATUS_NIS_Msk                    (0x10000UL)               /*!< ETH STATUS: NIS (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_RS_Pos                     (17UL)                    /*!< ETH STATUS: RS (Bit 17)                                     */
#define ETH_STATUS_RS_Msk                     (0xe0000UL)               /*!< ETH STATUS: RS (Bitfield-Mask: 0x07)                        */
#define ETH_STATUS_TS_Pos                     (20UL)                    /*!< ETH STATUS: TS (Bit 20)                                     */
#define ETH_STATUS_TS_Msk                     (0x700000UL)              /*!< ETH STATUS: TS (Bitfield-Mask: 0x07)                        */
#define ETH_STATUS_EB_Pos                     (23UL)                    /*!< ETH STATUS: EB (Bit 23)                                     */
#define ETH_STATUS_EB_Msk                     (0x3800000UL)             /*!< ETH STATUS: EB (Bitfield-Mask: 0x07)                        */
#define ETH_STATUS_EMI_Pos                    (27UL)                    /*!< ETH STATUS: EMI (Bit 27)                                    */
#define ETH_STATUS_EMI_Msk                    (0x8000000UL)             /*!< ETH STATUS: EMI (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_EPI_Pos                    (28UL)                    /*!< ETH STATUS: EPI (Bit 28)                                    */
#define ETH_STATUS_EPI_Msk                    (0x10000000UL)            /*!< ETH STATUS: EPI (Bitfield-Mask: 0x01)                       */
#define ETH_STATUS_TTI_Pos                    (29UL)                    /*!< ETH STATUS: TTI (Bit 29)                                    */
#define ETH_STATUS_TTI_Msk                    (0x20000000UL)            /*!< ETH STATUS: TTI (Bitfield-Mask: 0x01)                       */

/* -----------------------------  ETH_OPERATION_MODE  ----------------------------- */
#define ETH_OPERATION_MODE_SR_Pos             (1UL)                     /*!< ETH OPERATION_MODE: SR (Bit 1)                              */
#define ETH_OPERATION_MODE_SR_Msk             (0x2UL)                   /*!< ETH OPERATION_MODE: SR (Bitfield-Mask: 0x01)                */
#define ETH_OPERATION_MODE_OSF_Pos            (2UL)                     /*!< ETH OPERATION_MODE: OSF (Bit 2)                             */
#define ETH_OPERATION_MODE_OSF_Msk            (0x4UL)                   /*!< ETH OPERATION_MODE: OSF (Bitfield-Mask: 0x01)               */
#define ETH_OPERATION_MODE_RTC_Pos            (3UL)                     /*!< ETH OPERATION_MODE: RTC (Bit 3)                             */
#define ETH_OPERATION_MODE_RTC_Msk            (0x18UL)                  /*!< ETH OPERATION_MODE: RTC (Bitfield-Mask: 0x03)               */
#define ETH_OPERATION_MODE_FUF_Pos            (6UL)                     /*!< ETH OPERATION_MODE: FUF (Bit 6)                             */
#define ETH_OPERATION_MODE_FUF_Msk            (0x40UL)                  /*!< ETH OPERATION_MODE: FUF (Bitfield-Mask: 0x01)               */
#define ETH_OPERATION_MODE_FEF_Pos            (7UL)                     /*!< ETH OPERATION_MODE: FEF (Bit 7)                             */
#define ETH_OPERATION_MODE_FEF_Msk            (0x80UL)                  /*!< ETH OPERATION_MODE: FEF (Bitfield-Mask: 0x01)               */
#define ETH_OPERATION_MODE_ST_Pos             (13UL)                    /*!< ETH OPERATION_MODE: ST (Bit 13)                             */
#define ETH_OPERATION_MODE_ST_Msk             (0x2000UL)                /*!< ETH OPERATION_MODE: ST (Bitfield-Mask: 0x01)                */
#define ETH_OPERATION_MODE_TTC_Pos            (14UL)                    /*!< ETH OPERATION_MODE: TTC (Bit 14)                            */
#define ETH_OPERATION_MODE_TTC_Msk            (0x1c000UL)               /*!< ETH OPERATION_MODE: TTC (Bitfield-Mask: 0x07)               */
#define ETH_OPERATION_MODE_FTF_Pos            (20UL)                    /*!< ETH OPERATION_MODE: FTF (Bit 20)                            */
#define ETH_OPERATION_MODE_FTF_Msk            (0x100000UL)              /*!< ETH OPERATION_MODE: FTF (Bitfield-Mask: 0x01)               */
#define ETH_OPERATION_MODE_TSF_Pos            (21UL)                    /*!< ETH OPERATION_MODE: TSF (Bit 21)                            */
#define ETH_OPERATION_MODE_TSF_Msk            (0x200000UL)              /*!< ETH OPERATION_MODE: TSF (Bitfield-Mask: 0x01)               */
#define ETH_OPERATION_MODE_DFF_Pos            (24UL)                    /*!< ETH OPERATION_MODE: DFF (Bit 24)                            */
#define ETH_OPERATION_MODE_DFF_Msk            (0x1000000UL)             /*!< ETH OPERATION_MODE: DFF (Bitfield-Mask: 0x01)               */
#define ETH_OPERATION_MODE_RSF_Pos            (25UL)                    /*!< ETH OPERATION_MODE: RSF (Bit 25)                            */
#define ETH_OPERATION_MODE_RSF_Msk            (0x2000000UL)             /*!< ETH OPERATION_MODE: RSF (Bitfield-Mask: 0x01)               */
#define ETH_OPERATION_MODE_DT_Pos             (26UL)                    /*!< ETH OPERATION_MODE: DT (Bit 26)                             */
#define ETH_OPERATION_MODE_DT_Msk             (0x4000000UL)             /*!< ETH OPERATION_MODE: DT (Bitfield-Mask: 0x01)                */

/* ----------------------------  ETH_INTERRUPT_ENABLE  ---------------------------- */
#define ETH_INTERRUPT_ENABLE_TIE_Pos          (0UL)                     /*!< ETH INTERRUPT_ENABLE: TIE (Bit 0)                           */
#define ETH_INTERRUPT_ENABLE_TIE_Msk          (0x1UL)                   /*!< ETH INTERRUPT_ENABLE: TIE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_TSE_Pos          (1UL)                     /*!< ETH INTERRUPT_ENABLE: TSE (Bit 1)                           */
#define ETH_INTERRUPT_ENABLE_TSE_Msk          (0x2UL)                   /*!< ETH INTERRUPT_ENABLE: TSE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_TUE_Pos          (2UL)                     /*!< ETH INTERRUPT_ENABLE: TUE (Bit 2)                           */
#define ETH_INTERRUPT_ENABLE_TUE_Msk          (0x4UL)                   /*!< ETH INTERRUPT_ENABLE: TUE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_TJE_Pos          (3UL)                     /*!< ETH INTERRUPT_ENABLE: TJE (Bit 3)                           */
#define ETH_INTERRUPT_ENABLE_TJE_Msk          (0x8UL)                   /*!< ETH INTERRUPT_ENABLE: TJE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_OVE_Pos          (4UL)                     /*!< ETH INTERRUPT_ENABLE: OVE (Bit 4)                           */
#define ETH_INTERRUPT_ENABLE_OVE_Msk          (0x10UL)                  /*!< ETH INTERRUPT_ENABLE: OVE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_UNE_Pos          (5UL)                     /*!< ETH INTERRUPT_ENABLE: UNE (Bit 5)                           */
#define ETH_INTERRUPT_ENABLE_UNE_Msk          (0x20UL)                  /*!< ETH INTERRUPT_ENABLE: UNE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_RIE_Pos          (6UL)                     /*!< ETH INTERRUPT_ENABLE: RIE (Bit 6)                           */
#define ETH_INTERRUPT_ENABLE_RIE_Msk          (0x40UL)                  /*!< ETH INTERRUPT_ENABLE: RIE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_RUE_Pos          (7UL)                     /*!< ETH INTERRUPT_ENABLE: RUE (Bit 7)                           */
#define ETH_INTERRUPT_ENABLE_RUE_Msk          (0x80UL)                  /*!< ETH INTERRUPT_ENABLE: RUE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_RSE_Pos          (8UL)                     /*!< ETH INTERRUPT_ENABLE: RSE (Bit 8)                           */
#define ETH_INTERRUPT_ENABLE_RSE_Msk          (0x100UL)                 /*!< ETH INTERRUPT_ENABLE: RSE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_RWE_Pos          (9UL)                     /*!< ETH INTERRUPT_ENABLE: RWE (Bit 9)                           */
#define ETH_INTERRUPT_ENABLE_RWE_Msk          (0x200UL)                 /*!< ETH INTERRUPT_ENABLE: RWE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_ETE_Pos          (10UL)                    /*!< ETH INTERRUPT_ENABLE: ETE (Bit 10)                          */
#define ETH_INTERRUPT_ENABLE_ETE_Msk          (0x400UL)                 /*!< ETH INTERRUPT_ENABLE: ETE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_FBE_Pos          (13UL)                    /*!< ETH INTERRUPT_ENABLE: FBE (Bit 13)                          */
#define ETH_INTERRUPT_ENABLE_FBE_Msk          (0x2000UL)                /*!< ETH INTERRUPT_ENABLE: FBE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_ERE_Pos          (14UL)                    /*!< ETH INTERRUPT_ENABLE: ERE (Bit 14)                          */
#define ETH_INTERRUPT_ENABLE_ERE_Msk          (0x4000UL)                /*!< ETH INTERRUPT_ENABLE: ERE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_AIE_Pos          (15UL)                    /*!< ETH INTERRUPT_ENABLE: AIE (Bit 15)                          */
#define ETH_INTERRUPT_ENABLE_AIE_Msk          (0x8000UL)                /*!< ETH INTERRUPT_ENABLE: AIE (Bitfield-Mask: 0x01)             */
#define ETH_INTERRUPT_ENABLE_NIE_Pos          (16UL)                    /*!< ETH INTERRUPT_ENABLE: NIE (Bit 16)                          */
#define ETH_INTERRUPT_ENABLE_NIE_Msk          (0x10000UL)               /*!< ETH INTERRUPT_ENABLE: NIE (Bitfield-Mask: 0x01)             */

/* ----------------  ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER  ---------------- */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_MISFRMCNT_Pos (0UL) /*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: MISFRMCNT (Bit 0) */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_MISFRMCNT_Msk (0xffffUL) /*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: MISFRMCNT (Bitfield-Mask: 0xffff) */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_MISCNTOVF_Pos (16UL) /*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: MISCNTOVF (Bit 16) */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_MISCNTOVF_Msk (0x10000UL) /*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: MISCNTOVF (Bitfield-Mask: 0x01) */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_OVFFRMCNT_Pos (17UL) /*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: OVFFRMCNT (Bit 17) */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_OVFFRMCNT_Msk (0xffe0000UL) /*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: OVFFRMCNT (Bitfield-Mask: 0x7ff) */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_OVFCNTOVF_Pos (28UL) /*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: OVFCNTOVF (Bit 28) */
#define ETH_MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER_OVFCNTOVF_Msk (0x10000000UL) /*!< ETH MISSED_FRAME_AND_BUFFER_OVERFLOW_COUNTER: OVFCNTOVF (Bitfield-Mask: 0x01) */

/* --------------------  ETH_RECEIVE_INTERRUPT_WATCHDOG_TIMER  -------------------- */
#define ETH_RECEIVE_INTERRUPT_WATCHDOG_TIMER_RIWT_Pos (0UL)             /*!< ETH RECEIVE_INTERRUPT_WATCHDOG_TIMER: RIWT (Bit 0)          */
#define ETH_RECEIVE_INTERRUPT_WATCHDOG_TIMER_RIWT_Msk (0xffUL)          /*!< ETH RECEIVE_INTERRUPT_WATCHDOG_TIMER: RIWT (Bitfield-Mask: 0xff) */

/* -------------------------------  ETH_AHB_STATUS  ------------------------------- */
#define ETH_AHB_STATUS_AHBMS_Pos              (0UL)                     /*!< ETH AHB_STATUS: AHBMS (Bit 0)                               */
#define ETH_AHB_STATUS_AHBMS_Msk              (0x1UL)                   /*!< ETH AHB_STATUS: AHBMS (Bitfield-Mask: 0x01)                 */

/* --------------------  ETH_CURRENT_HOST_TRANSMIT_DESCRIPTOR  -------------------- */
#define ETH_CURRENT_HOST_TRANSMIT_DESCRIPTOR_CURTDESAPTR_Pos (0UL)      /*!< ETH CURRENT_HOST_TRANSMIT_DESCRIPTOR: CURTDESAPTR (Bit 0)   */
#define ETH_CURRENT_HOST_TRANSMIT_DESCRIPTOR_CURTDESAPTR_Msk (0xffffffffUL) /*!< ETH CURRENT_HOST_TRANSMIT_DESCRIPTOR: CURTDESAPTR (Bitfield-Mask: 0xffffffff) */

/* ---------------------  ETH_CURRENT_HOST_RECEIVE_DESCRIPTOR  -------------------- */
#define ETH_CURRENT_HOST_RECEIVE_DESCRIPTOR_CURRDESAPTR_Pos (0UL)       /*!< ETH CURRENT_HOST_RECEIVE_DESCRIPTOR: CURRDESAPTR (Bit 0)    */
#define ETH_CURRENT_HOST_RECEIVE_DESCRIPTOR_CURRDESAPTR_Msk (0xffffffffUL) /*!< ETH CURRENT_HOST_RECEIVE_DESCRIPTOR: CURRDESAPTR (Bitfield-Mask: 0xffffffff) */

/* ------------------  ETH_CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS  ------------------ */
#define ETH_CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS_CURTBUFAPTR_Pos (0UL)  /*!< ETH CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS: CURTBUFAPTR (Bit 0) */
#define ETH_CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS_CURTBUFAPTR_Msk (0xffffffffUL) /*!< ETH CURRENT_HOST_TRANSMIT_BUFFER_ADDRESS: CURTBUFAPTR (Bitfield-Mask: 0xffffffff) */

/* -------------------  ETH_CURRENT_HOST_RECEIVE_BUFFER_ADDRESS  ------------------ */
#define ETH_CURRENT_HOST_RECEIVE_BUFFER_ADDRESS_CURRBUFAPTR_Pos (0UL)   /*!< ETH CURRENT_HOST_RECEIVE_BUFFER_ADDRESS: CURRBUFAPTR (Bit 0) */
#define ETH_CURRENT_HOST_RECEIVE_BUFFER_ADDRESS_CURRBUFAPTR_Msk (0xffffffffUL) /*!< ETH CURRENT_HOST_RECEIVE_BUFFER_ADDRESS: CURRBUFAPTR (Bitfield-Mask: 0xffffffff) */

/* -------------------------------  ETH_HW_FEATURE  ------------------------------- */
#define ETH_HW_FEATURE_MIISEL_Pos             (0UL)                     /*!< ETH HW_FEATURE: MIISEL (Bit 0)                              */
#define ETH_HW_FEATURE_MIISEL_Msk             (0x1UL)                   /*!< ETH HW_FEATURE: MIISEL (Bitfield-Mask: 0x01)                */
#define ETH_HW_FEATURE_GMIISEL_Pos            (1UL)                     /*!< ETH HW_FEATURE: GMIISEL (Bit 1)                             */
#define ETH_HW_FEATURE_GMIISEL_Msk            (0x2UL)                   /*!< ETH HW_FEATURE: GMIISEL (Bitfield-Mask: 0x01)               */
#define ETH_HW_FEATURE_HDSEL_Pos              (2UL)                     /*!< ETH HW_FEATURE: HDSEL (Bit 2)                               */
#define ETH_HW_FEATURE_HDSEL_Msk              (0x4UL)                   /*!< ETH HW_FEATURE: HDSEL (Bitfield-Mask: 0x01)                 */
#define ETH_HW_FEATURE_EXTHASHEN_Pos          (3UL)                     /*!< ETH HW_FEATURE: EXTHASHEN (Bit 3)                           */
#define ETH_HW_FEATURE_EXTHASHEN_Msk          (0x8UL)                   /*!< ETH HW_FEATURE: EXTHASHEN (Bitfield-Mask: 0x01)             */
#define ETH_HW_FEATURE_HASHSEL_Pos            (4UL)                     /*!< ETH HW_FEATURE: HASHSEL (Bit 4)                             */
#define ETH_HW_FEATURE_HASHSEL_Msk            (0x10UL)                  /*!< ETH HW_FEATURE: HASHSEL (Bitfield-Mask: 0x01)               */
#define ETH_HW_FEATURE_ADDMACADRSEL_Pos       (5UL)                     /*!< ETH HW_FEATURE: ADDMACADRSEL (Bit 5)                        */
#define ETH_HW_FEATURE_ADDMACADRSEL_Msk       (0x20UL)                  /*!< ETH HW_FEATURE: ADDMACADRSEL (Bitfield-Mask: 0x01)          */
#define ETH_HW_FEATURE_PCSSEL_Pos             (6UL)                     /*!< ETH HW_FEATURE: PCSSEL (Bit 6)                              */
#define ETH_HW_FEATURE_PCSSEL_Msk             (0x40UL)                  /*!< ETH HW_FEATURE: PCSSEL (Bitfield-Mask: 0x01)                */
#define ETH_HW_FEATURE_L3L4FLTREN_Pos         (7UL)                     /*!< ETH HW_FEATURE: L3L4FLTREN (Bit 7)                          */
#define ETH_HW_FEATURE_L3L4FLTREN_Msk         (0x80UL)                  /*!< ETH HW_FEATURE: L3L4FLTREN (Bitfield-Mask: 0x01)            */
#define ETH_HW_FEATURE_SMASEL_Pos             (8UL)                     /*!< ETH HW_FEATURE: SMASEL (Bit 8)                              */
#define ETH_HW_FEATURE_SMASEL_Msk             (0x100UL)                 /*!< ETH HW_FEATURE: SMASEL (Bitfield-Mask: 0x01)                */
#define ETH_HW_FEATURE_RWKSEL_Pos             (9UL)                     /*!< ETH HW_FEATURE: RWKSEL (Bit 9)                              */
#define ETH_HW_FEATURE_RWKSEL_Msk             (0x200UL)                 /*!< ETH HW_FEATURE: RWKSEL (Bitfield-Mask: 0x01)                */
#define ETH_HW_FEATURE_MGKSEL_Pos             (10UL)                    /*!< ETH HW_FEATURE: MGKSEL (Bit 10)                             */
#define ETH_HW_FEATURE_MGKSEL_Msk             (0x400UL)                 /*!< ETH HW_FEATURE: MGKSEL (Bitfield-Mask: 0x01)                */
#define ETH_HW_FEATURE_MMCSEL_Pos             (11UL)                    /*!< ETH HW_FEATURE: MMCSEL (Bit 11)                             */
#define ETH_HW_FEATURE_MMCSEL_Msk             (0x800UL)                 /*!< ETH HW_FEATURE: MMCSEL (Bitfield-Mask: 0x01)                */
#define ETH_HW_FEATURE_TSVER1SEL_Pos          (12UL)                    /*!< ETH HW_FEATURE: TSVER1SEL (Bit 12)                          */
#define ETH_HW_FEATURE_TSVER1SEL_Msk          (0x1000UL)                /*!< ETH HW_FEATURE: TSVER1SEL (Bitfield-Mask: 0x01)             */
#define ETH_HW_FEATURE_TSVER2SEL_Pos          (13UL)                    /*!< ETH HW_FEATURE: TSVER2SEL (Bit 13)                          */
#define ETH_HW_FEATURE_TSVER2SEL_Msk          (0x2000UL)                /*!< ETH HW_FEATURE: TSVER2SEL (Bitfield-Mask: 0x01)             */
#define ETH_HW_FEATURE_EEESEL_Pos             (14UL)                    /*!< ETH HW_FEATURE: EEESEL (Bit 14)                             */
#define ETH_HW_FEATURE_EEESEL_Msk             (0x4000UL)                /*!< ETH HW_FEATURE: EEESEL (Bitfield-Mask: 0x01)                */
#define ETH_HW_FEATURE_AVSEL_Pos              (15UL)                    /*!< ETH HW_FEATURE: AVSEL (Bit 15)                              */
#define ETH_HW_FEATURE_AVSEL_Msk              (0x8000UL)                /*!< ETH HW_FEATURE: AVSEL (Bitfield-Mask: 0x01)                 */
#define ETH_HW_FEATURE_TXCOESEL_Pos           (16UL)                    /*!< ETH HW_FEATURE: TXCOESEL (Bit 16)                           */
#define ETH_HW_FEATURE_TXCOESEL_Msk           (0x10000UL)               /*!< ETH HW_FEATURE: TXCOESEL (Bitfield-Mask: 0x01)              */
#define ETH_HW_FEATURE_RXTYP1COE_Pos          (17UL)                    /*!< ETH HW_FEATURE: RXTYP1COE (Bit 17)                          */
#define ETH_HW_FEATURE_RXTYP1COE_Msk          (0x20000UL)               /*!< ETH HW_FEATURE: RXTYP1COE (Bitfield-Mask: 0x01)             */
#define ETH_HW_FEATURE_RXTYP2COE_Pos          (18UL)                    /*!< ETH HW_FEATURE: RXTYP2COE (Bit 18)                          */
#define ETH_HW_FEATURE_RXTYP2COE_Msk          (0x40000UL)               /*!< ETH HW_FEATURE: RXTYP2COE (Bitfield-Mask: 0x01)             */
#define ETH_HW_FEATURE_RXFIFOSIZE_Pos         (19UL)                    /*!< ETH HW_FEATURE: RXFIFOSIZE (Bit 19)                         */
#define ETH_HW_FEATURE_RXFIFOSIZE_Msk         (0x80000UL)               /*!< ETH HW_FEATURE: RXFIFOSIZE (Bitfield-Mask: 0x01)            */
#define ETH_HW_FEATURE_RXCHCNT_Pos            (20UL)                    /*!< ETH HW_FEATURE: RXCHCNT (Bit 20)                            */
#define ETH_HW_FEATURE_RXCHCNT_Msk            (0x300000UL)              /*!< ETH HW_FEATURE: RXCHCNT (Bitfield-Mask: 0x03)               */
#define ETH_HW_FEATURE_TXCHCNT_Pos            (22UL)                    /*!< ETH HW_FEATURE: TXCHCNT (Bit 22)                            */
#define ETH_HW_FEATURE_TXCHCNT_Msk            (0xc00000UL)              /*!< ETH HW_FEATURE: TXCHCNT (Bitfield-Mask: 0x03)               */
#define ETH_HW_FEATURE_ENHDESSEL_Pos          (24UL)                    /*!< ETH HW_FEATURE: ENHDESSEL (Bit 24)                          */
#define ETH_HW_FEATURE_ENHDESSEL_Msk          (0x1000000UL)             /*!< ETH HW_FEATURE: ENHDESSEL (Bitfield-Mask: 0x01)             */
#define ETH_HW_FEATURE_INTTSEN_Pos            (25UL)                    /*!< ETH HW_FEATURE: INTTSEN (Bit 25)                            */
#define ETH_HW_FEATURE_INTTSEN_Msk            (0x2000000UL)             /*!< ETH HW_FEATURE: INTTSEN (Bitfield-Mask: 0x01)               */
#define ETH_HW_FEATURE_FLEXIPPSEN_Pos         (26UL)                    /*!< ETH HW_FEATURE: FLEXIPPSEN (Bit 26)                         */
#define ETH_HW_FEATURE_FLEXIPPSEN_Msk         (0x4000000UL)             /*!< ETH HW_FEATURE: FLEXIPPSEN (Bitfield-Mask: 0x01)            */
#define ETH_HW_FEATURE_SAVLANINS_Pos          (27UL)                    /*!< ETH HW_FEATURE: SAVLANINS (Bit 27)                          */
#define ETH_HW_FEATURE_SAVLANINS_Msk          (0x8000000UL)             /*!< ETH HW_FEATURE: SAVLANINS (Bitfield-Mask: 0x01)             */
#define ETH_HW_FEATURE_ACTPHYIF_Pos           (28UL)                    /*!< ETH HW_FEATURE: ACTPHYIF (Bit 28)                           */
#define ETH_HW_FEATURE_ACTPHYIF_Msk           (0x70000000UL)            /*!< ETH HW_FEATURE: ACTPHYIF (Bitfield-Mask: 0x07)              */


/* ================================================================================ */
/* ================           Group 'USB' Position & Mask          ================ */
/* ================================================================================ */


/* ---------------------------------  USB_GOTGCTL  -------------------------------- */
#define USB_GOTGCTL_SesReqScs_Pos             (0UL)                     /*!< USB GOTGCTL: SesReqScs (Bit 0)                              */
#define USB_GOTGCTL_SesReqScs_Msk             (0x1UL)                   /*!< USB GOTGCTL: SesReqScs (Bitfield-Mask: 0x01)                */
#define USB_GOTGCTL_SesReq_Pos                (1UL)                     /*!< USB GOTGCTL: SesReq (Bit 1)                                 */
#define USB_GOTGCTL_SesReq_Msk                (0x2UL)                   /*!< USB GOTGCTL: SesReq (Bitfield-Mask: 0x01)                   */
#define USB_GOTGCTL_VbvalidOvEn_Pos           (2UL)                     /*!< USB GOTGCTL: VbvalidOvEn (Bit 2)                            */
#define USB_GOTGCTL_VbvalidOvEn_Msk           (0x4UL)                   /*!< USB GOTGCTL: VbvalidOvEn (Bitfield-Mask: 0x01)              */
#define USB_GOTGCTL_VbvalidOvVal_Pos          (3UL)                     /*!< USB GOTGCTL: VbvalidOvVal (Bit 3)                           */
#define USB_GOTGCTL_VbvalidOvVal_Msk          (0x8UL)                   /*!< USB GOTGCTL: VbvalidOvVal (Bitfield-Mask: 0x01)             */
#define USB_GOTGCTL_AvalidOvEn_Pos            (4UL)                     /*!< USB GOTGCTL: AvalidOvEn (Bit 4)                             */
#define USB_GOTGCTL_AvalidOvEn_Msk            (0x10UL)                  /*!< USB GOTGCTL: AvalidOvEn (Bitfield-Mask: 0x01)               */
#define USB_GOTGCTL_AvalidOvVal_Pos           (5UL)                     /*!< USB GOTGCTL: AvalidOvVal (Bit 5)                            */
#define USB_GOTGCTL_AvalidOvVal_Msk           (0x20UL)                  /*!< USB GOTGCTL: AvalidOvVal (Bitfield-Mask: 0x01)              */
#define USB_GOTGCTL_BvalidOvEn_Pos            (6UL)                     /*!< USB GOTGCTL: BvalidOvEn (Bit 6)                             */
#define USB_GOTGCTL_BvalidOvEn_Msk            (0x40UL)                  /*!< USB GOTGCTL: BvalidOvEn (Bitfield-Mask: 0x01)               */
#define USB_GOTGCTL_BvalidOvVal_Pos           (7UL)                     /*!< USB GOTGCTL: BvalidOvVal (Bit 7)                            */
#define USB_GOTGCTL_BvalidOvVal_Msk           (0x80UL)                  /*!< USB GOTGCTL: BvalidOvVal (Bitfield-Mask: 0x01)              */
#define USB_GOTGCTL_HstNegScs_Pos             (8UL)                     /*!< USB GOTGCTL: HstNegScs (Bit 8)                              */
#define USB_GOTGCTL_HstNegScs_Msk             (0x100UL)                 /*!< USB GOTGCTL: HstNegScs (Bitfield-Mask: 0x01)                */
#define USB_GOTGCTL_HNPReq_Pos                (9UL)                     /*!< USB GOTGCTL: HNPReq (Bit 9)                                 */
#define USB_GOTGCTL_HNPReq_Msk                (0x200UL)                 /*!< USB GOTGCTL: HNPReq (Bitfield-Mask: 0x01)                   */
#define USB_GOTGCTL_HstSetHNPEn_Pos           (10UL)                    /*!< USB GOTGCTL: HstSetHNPEn (Bit 10)                           */
#define USB_GOTGCTL_HstSetHNPEn_Msk           (0x400UL)                 /*!< USB GOTGCTL: HstSetHNPEn (Bitfield-Mask: 0x01)              */
#define USB_GOTGCTL_DevHNPEn_Pos              (11UL)                    /*!< USB GOTGCTL: DevHNPEn (Bit 11)                              */
#define USB_GOTGCTL_DevHNPEn_Msk              (0x800UL)                 /*!< USB GOTGCTL: DevHNPEn (Bitfield-Mask: 0x01)                 */
#define USB_GOTGCTL_ConlDSts_Pos              (16UL)                    /*!< USB GOTGCTL: ConlDSts (Bit 16)                              */
#define USB_GOTGCTL_ConlDSts_Msk              (0x10000UL)               /*!< USB GOTGCTL: ConlDSts (Bitfield-Mask: 0x01)                 */
#define USB_GOTGCTL_DbncTime_Pos              (17UL)                    /*!< USB GOTGCTL: DbncTime (Bit 17)                              */
#define USB_GOTGCTL_DbncTime_Msk              (0x20000UL)               /*!< USB GOTGCTL: DbncTime (Bitfield-Mask: 0x01)                 */
#define USB_GOTGCTL_ASesVId_Pos               (18UL)                    /*!< USB GOTGCTL: ASesVId (Bit 18)                               */
#define USB_GOTGCTL_ASesVId_Msk               (0x40000UL)               /*!< USB GOTGCTL: ASesVId (Bitfield-Mask: 0x01)                  */
#define USB_GOTGCTL_BSesVld_Pos               (19UL)                    /*!< USB GOTGCTL: BSesVld (Bit 19)                               */
#define USB_GOTGCTL_BSesVld_Msk               (0x80000UL)               /*!< USB GOTGCTL: BSesVld (Bitfield-Mask: 0x01)                  */
#define USB_GOTGCTL_OTGVer_Pos                (20UL)                    /*!< USB GOTGCTL: OTGVer (Bit 20)                                */
#define USB_GOTGCTL_OTGVer_Msk                (0x100000UL)              /*!< USB GOTGCTL: OTGVer (Bitfield-Mask: 0x01)                   */

/* ---------------------------------  USB_GOTGINT  -------------------------------- */
#define USB_GOTGINT_SesEndDet_Pos             (2UL)                     /*!< USB GOTGINT: SesEndDet (Bit 2)                              */
#define USB_GOTGINT_SesEndDet_Msk             (0x4UL)                   /*!< USB GOTGINT: SesEndDet (Bitfield-Mask: 0x01)                */
#define USB_GOTGINT_SesReqSucStsChng_Pos      (8UL)                     /*!< USB GOTGINT: SesReqSucStsChng (Bit 8)                       */
#define USB_GOTGINT_SesReqSucStsChng_Msk      (0x100UL)                 /*!< USB GOTGINT: SesReqSucStsChng (Bitfield-Mask: 0x01)         */
#define USB_GOTGINT_HstNegSucStsChng_Pos      (9UL)                     /*!< USB GOTGINT: HstNegSucStsChng (Bit 9)                       */
#define USB_GOTGINT_HstNegSucStsChng_Msk      (0x200UL)                 /*!< USB GOTGINT: HstNegSucStsChng (Bitfield-Mask: 0x01)         */
#define USB_GOTGINT_HstNegDet_Pos             (17UL)                    /*!< USB GOTGINT: HstNegDet (Bit 17)                             */
#define USB_GOTGINT_HstNegDet_Msk             (0x20000UL)               /*!< USB GOTGINT: HstNegDet (Bitfield-Mask: 0x01)                */
#define USB_GOTGINT_ADevTOUTChg_Pos           (18UL)                    /*!< USB GOTGINT: ADevTOUTChg (Bit 18)                           */
#define USB_GOTGINT_ADevTOUTChg_Msk           (0x40000UL)               /*!< USB GOTGINT: ADevTOUTChg (Bitfield-Mask: 0x01)              */
#define USB_GOTGINT_DbnceDone_Pos             (19UL)                    /*!< USB GOTGINT: DbnceDone (Bit 19)                             */
#define USB_GOTGINT_DbnceDone_Msk             (0x80000UL)               /*!< USB GOTGINT: DbnceDone (Bitfield-Mask: 0x01)                */

/* ---------------------------------  USB_GAHBCFG  -------------------------------- */
#define USB_GAHBCFG_GlblIntrMsk_Pos           (0UL)                     /*!< USB GAHBCFG: GlblIntrMsk (Bit 0)                            */
#define USB_GAHBCFG_GlblIntrMsk_Msk           (0x1UL)                   /*!< USB GAHBCFG: GlblIntrMsk (Bitfield-Mask: 0x01)              */
#define USB_GAHBCFG_HBstLen_Pos               (1UL)                     /*!< USB GAHBCFG: HBstLen (Bit 1)                                */
#define USB_GAHBCFG_HBstLen_Msk               (0x1eUL)                  /*!< USB GAHBCFG: HBstLen (Bitfield-Mask: 0x0f)                  */
#define USB_GAHBCFG_DMAEn_Pos                 (5UL)                     /*!< USB GAHBCFG: DMAEn (Bit 5)                                  */
#define USB_GAHBCFG_DMAEn_Msk                 (0x20UL)                  /*!< USB GAHBCFG: DMAEn (Bitfield-Mask: 0x01)                    */
#define USB_GAHBCFG_NPTxFEmpLvl_Pos           (7UL)                     /*!< USB GAHBCFG: NPTxFEmpLvl (Bit 7)                            */
#define USB_GAHBCFG_NPTxFEmpLvl_Msk           (0x80UL)                  /*!< USB GAHBCFG: NPTxFEmpLvl (Bitfield-Mask: 0x01)              */
#define USB_GAHBCFG_PTxFEmpLvl_Pos            (8UL)                     /*!< USB GAHBCFG: PTxFEmpLvl (Bit 8)                             */
#define USB_GAHBCFG_PTxFEmpLvl_Msk            (0x100UL)                 /*!< USB GAHBCFG: PTxFEmpLvl (Bitfield-Mask: 0x01)               */
#define USB_GAHBCFG_AHBSingle_Pos             (23UL)                    /*!< USB GAHBCFG: AHBSingle (Bit 23)                             */
#define USB_GAHBCFG_AHBSingle_Msk             (0x800000UL)              /*!< USB GAHBCFG: AHBSingle (Bitfield-Mask: 0x01)                */

/* ---------------------------------  USB_GUSBCFG  -------------------------------- */
#define USB_GUSBCFG_TOutCal_Pos               (0UL)                     /*!< USB GUSBCFG: TOutCal (Bit 0)                                */
#define USB_GUSBCFG_TOutCal_Msk               (0x7UL)                   /*!< USB GUSBCFG: TOutCal (Bitfield-Mask: 0x07)                  */
#define USB_GUSBCFG_PHYSel_Pos                (6UL)                     /*!< USB GUSBCFG: PHYSel (Bit 6)                                 */
#define USB_GUSBCFG_PHYSel_Msk                (0x40UL)                  /*!< USB GUSBCFG: PHYSel (Bitfield-Mask: 0x01)                   */
#define USB_GUSBCFG_SRPCap_Pos                (8UL)                     /*!< USB GUSBCFG: SRPCap (Bit 8)                                 */
#define USB_GUSBCFG_SRPCap_Msk                (0x100UL)                 /*!< USB GUSBCFG: SRPCap (Bitfield-Mask: 0x01)                   */
#define USB_GUSBCFG_HNPCap_Pos                (9UL)                     /*!< USB GUSBCFG: HNPCap (Bit 9)                                 */
#define USB_GUSBCFG_HNPCap_Msk                (0x200UL)                 /*!< USB GUSBCFG: HNPCap (Bitfield-Mask: 0x01)                   */
#define USB_GUSBCFG_USBTrdTim_Pos             (10UL)                    /*!< USB GUSBCFG: USBTrdTim (Bit 10)                             */
#define USB_GUSBCFG_USBTrdTim_Msk             (0x3c00UL)                /*!< USB GUSBCFG: USBTrdTim (Bitfield-Mask: 0x0f)                */
#define USB_GUSBCFG_OtgI2CSel_Pos             (16UL)                    /*!< USB GUSBCFG: OtgI2CSel (Bit 16)                             */
#define USB_GUSBCFG_OtgI2CSel_Msk             (0x10000UL)               /*!< USB GUSBCFG: OtgI2CSel (Bitfield-Mask: 0x01)                */
#define USB_GUSBCFG_TxEndDelay_Pos            (28UL)                    /*!< USB GUSBCFG: TxEndDelay (Bit 28)                            */
#define USB_GUSBCFG_TxEndDelay_Msk            (0x10000000UL)            /*!< USB GUSBCFG: TxEndDelay (Bitfield-Mask: 0x01)               */
#define USB_GUSBCFG_ForceHstMode_Pos          (29UL)                    /*!< USB GUSBCFG: ForceHstMode (Bit 29)                          */
#define USB_GUSBCFG_ForceHstMode_Msk          (0x20000000UL)            /*!< USB GUSBCFG: ForceHstMode (Bitfield-Mask: 0x01)             */
#define USB_GUSBCFG_ForceDevMode_Pos          (30UL)                    /*!< USB GUSBCFG: ForceDevMode (Bit 30)                          */
#define USB_GUSBCFG_ForceDevMode_Msk          (0x40000000UL)            /*!< USB GUSBCFG: ForceDevMode (Bitfield-Mask: 0x01)             */
#define USB_GUSBCFG_CTP_Pos                   (31UL)                    /*!< USB GUSBCFG: CTP (Bit 31)                                   */
#define USB_GUSBCFG_CTP_Msk                   (0x80000000UL)            /*!< USB GUSBCFG: CTP (Bitfield-Mask: 0x01)                      */

/* ---------------------------------  USB_GRSTCTL  -------------------------------- */
#define USB_GRSTCTL_CSftRst_Pos               (0UL)                     /*!< USB GRSTCTL: CSftRst (Bit 0)                                */
#define USB_GRSTCTL_CSftRst_Msk               (0x1UL)                   /*!< USB GRSTCTL: CSftRst (Bitfield-Mask: 0x01)                  */
#define USB_GRSTCTL_FrmCntrRst_Pos            (2UL)                     /*!< USB GRSTCTL: FrmCntrRst (Bit 2)                             */
#define USB_GRSTCTL_FrmCntrRst_Msk            (0x4UL)                   /*!< USB GRSTCTL: FrmCntrRst (Bitfield-Mask: 0x01)               */
#define USB_GRSTCTL_RxFFlsh_Pos               (4UL)                     /*!< USB GRSTCTL: RxFFlsh (Bit 4)                                */
#define USB_GRSTCTL_RxFFlsh_Msk               (0x10UL)                  /*!< USB GRSTCTL: RxFFlsh (Bitfield-Mask: 0x01)                  */
#define USB_GRSTCTL_TxFFlsh_Pos               (5UL)                     /*!< USB GRSTCTL: TxFFlsh (Bit 5)                                */
#define USB_GRSTCTL_TxFFlsh_Msk               (0x20UL)                  /*!< USB GRSTCTL: TxFFlsh (Bitfield-Mask: 0x01)                  */
#define USB_GRSTCTL_TxFNum_Pos                (6UL)                     /*!< USB GRSTCTL: TxFNum (Bit 6)                                 */
#define USB_GRSTCTL_TxFNum_Msk                (0x7c0UL)                 /*!< USB GRSTCTL: TxFNum (Bitfield-Mask: 0x1f)                   */
#define USB_GRSTCTL_DMAReq_Pos                (30UL)                    /*!< USB GRSTCTL: DMAReq (Bit 30)                                */
#define USB_GRSTCTL_DMAReq_Msk                (0x40000000UL)            /*!< USB GRSTCTL: DMAReq (Bitfield-Mask: 0x01)                   */
#define USB_GRSTCTL_AHBIdle_Pos               (31UL)                    /*!< USB GRSTCTL: AHBIdle (Bit 31)                               */
#define USB_GRSTCTL_AHBIdle_Msk               (0x80000000UL)            /*!< USB GRSTCTL: AHBIdle (Bitfield-Mask: 0x01)                  */

/* ----------------------------  USB_GINTSTS_HOSTMODE  ---------------------------- */
#define USB_GINTSTS_HOSTMODE_CurMod_Pos       (0UL)                     /*!< USB GINTSTS_HOSTMODE: CurMod (Bit 0)                        */
#define USB_GINTSTS_HOSTMODE_CurMod_Msk       (0x1UL)                   /*!< USB GINTSTS_HOSTMODE: CurMod (Bitfield-Mask: 0x01)          */
#define USB_GINTSTS_HOSTMODE_ModeMis_Pos      (1UL)                     /*!< USB GINTSTS_HOSTMODE: ModeMis (Bit 1)                       */
#define USB_GINTSTS_HOSTMODE_ModeMis_Msk      (0x2UL)                   /*!< USB GINTSTS_HOSTMODE: ModeMis (Bitfield-Mask: 0x01)         */
#define USB_GINTSTS_HOSTMODE_OTGInt_Pos       (2UL)                     /*!< USB GINTSTS_HOSTMODE: OTGInt (Bit 2)                        */
#define USB_GINTSTS_HOSTMODE_OTGInt_Msk       (0x4UL)                   /*!< USB GINTSTS_HOSTMODE: OTGInt (Bitfield-Mask: 0x01)          */
#define USB_GINTSTS_HOSTMODE_Sof_Pos          (3UL)                     /*!< USB GINTSTS_HOSTMODE: Sof (Bit 3)                           */
#define USB_GINTSTS_HOSTMODE_Sof_Msk          (0x8UL)                   /*!< USB GINTSTS_HOSTMODE: Sof (Bitfield-Mask: 0x01)             */
#define USB_GINTSTS_HOSTMODE_RxFLvl_Pos       (4UL)                     /*!< USB GINTSTS_HOSTMODE: RxFLvl (Bit 4)                        */
#define USB_GINTSTS_HOSTMODE_RxFLvl_Msk       (0x10UL)                  /*!< USB GINTSTS_HOSTMODE: RxFLvl (Bitfield-Mask: 0x01)          */
#define USB_GINTSTS_HOSTMODE_incomplP_Pos     (21UL)                    /*!< USB GINTSTS_HOSTMODE: incomplP (Bit 21)                     */
#define USB_GINTSTS_HOSTMODE_incomplP_Msk     (0x200000UL)              /*!< USB GINTSTS_HOSTMODE: incomplP (Bitfield-Mask: 0x01)        */
#define USB_GINTSTS_HOSTMODE_PrtInt_Pos       (24UL)                    /*!< USB GINTSTS_HOSTMODE: PrtInt (Bit 24)                       */
#define USB_GINTSTS_HOSTMODE_PrtInt_Msk       (0x1000000UL)             /*!< USB GINTSTS_HOSTMODE: PrtInt (Bitfield-Mask: 0x01)          */
#define USB_GINTSTS_HOSTMODE_HChInt_Pos       (25UL)                    /*!< USB GINTSTS_HOSTMODE: HChInt (Bit 25)                       */
#define USB_GINTSTS_HOSTMODE_HChInt_Msk       (0x2000000UL)             /*!< USB GINTSTS_HOSTMODE: HChInt (Bitfield-Mask: 0x01)          */
#define USB_GINTSTS_HOSTMODE_PTxFEmp_Pos      (26UL)                    /*!< USB GINTSTS_HOSTMODE: PTxFEmp (Bit 26)                      */
#define USB_GINTSTS_HOSTMODE_PTxFEmp_Msk      (0x4000000UL)             /*!< USB GINTSTS_HOSTMODE: PTxFEmp (Bitfield-Mask: 0x01)         */
#define USB_GINTSTS_HOSTMODE_ConIDStsChng_Pos (28UL)                    /*!< USB GINTSTS_HOSTMODE: ConIDStsChng (Bit 28)                 */
#define USB_GINTSTS_HOSTMODE_ConIDStsChng_Msk (0x10000000UL)            /*!< USB GINTSTS_HOSTMODE: ConIDStsChng (Bitfield-Mask: 0x01)    */
#define USB_GINTSTS_HOSTMODE_DisconnInt_Pos   (29UL)                    /*!< USB GINTSTS_HOSTMODE: DisconnInt (Bit 29)                   */
#define USB_GINTSTS_HOSTMODE_DisconnInt_Msk   (0x20000000UL)            /*!< USB GINTSTS_HOSTMODE: DisconnInt (Bitfield-Mask: 0x01)      */
#define USB_GINTSTS_HOSTMODE_SessReqInt_Pos   (30UL)                    /*!< USB GINTSTS_HOSTMODE: SessReqInt (Bit 30)                   */
#define USB_GINTSTS_HOSTMODE_SessReqInt_Msk   (0x40000000UL)            /*!< USB GINTSTS_HOSTMODE: SessReqInt (Bitfield-Mask: 0x01)      */
#define USB_GINTSTS_HOSTMODE_WkUpInt_Pos      (31UL)                    /*!< USB GINTSTS_HOSTMODE: WkUpInt (Bit 31)                      */
#define USB_GINTSTS_HOSTMODE_WkUpInt_Msk      (0x80000000UL)            /*!< USB GINTSTS_HOSTMODE: WkUpInt (Bitfield-Mask: 0x01)         */

/* ---------------------------  USB_GINTSTS_DEVICEMODE  --------------------------- */
#define USB_GINTSTS_DEVICEMODE_CurMod_Pos     (0UL)                     /*!< USB GINTSTS_DEVICEMODE: CurMod (Bit 0)                      */
#define USB_GINTSTS_DEVICEMODE_CurMod_Msk     (0x1UL)                   /*!< USB GINTSTS_DEVICEMODE: CurMod (Bitfield-Mask: 0x01)        */
#define USB_GINTSTS_DEVICEMODE_ModeMis_Pos    (1UL)                     /*!< USB GINTSTS_DEVICEMODE: ModeMis (Bit 1)                     */
#define USB_GINTSTS_DEVICEMODE_ModeMis_Msk    (0x2UL)                   /*!< USB GINTSTS_DEVICEMODE: ModeMis (Bitfield-Mask: 0x01)       */
#define USB_GINTSTS_DEVICEMODE_OTGInt_Pos     (2UL)                     /*!< USB GINTSTS_DEVICEMODE: OTGInt (Bit 2)                      */
#define USB_GINTSTS_DEVICEMODE_OTGInt_Msk     (0x4UL)                   /*!< USB GINTSTS_DEVICEMODE: OTGInt (Bitfield-Mask: 0x01)        */
#define USB_GINTSTS_DEVICEMODE_Sof_Pos        (3UL)                     /*!< USB GINTSTS_DEVICEMODE: Sof (Bit 3)                         */
#define USB_GINTSTS_DEVICEMODE_Sof_Msk        (0x8UL)                   /*!< USB GINTSTS_DEVICEMODE: Sof (Bitfield-Mask: 0x01)           */
#define USB_GINTSTS_DEVICEMODE_RxFLvl_Pos     (4UL)                     /*!< USB GINTSTS_DEVICEMODE: RxFLvl (Bit 4)                      */
#define USB_GINTSTS_DEVICEMODE_RxFLvl_Msk     (0x10UL)                  /*!< USB GINTSTS_DEVICEMODE: RxFLvl (Bitfield-Mask: 0x01)        */
#define USB_GINTSTS_DEVICEMODE_GINNakEff_Pos  (6UL)                     /*!< USB GINTSTS_DEVICEMODE: GINNakEff (Bit 6)                   */
#define USB_GINTSTS_DEVICEMODE_GINNakEff_Msk  (0x40UL)                  /*!< USB GINTSTS_DEVICEMODE: GINNakEff (Bitfield-Mask: 0x01)     */
#define USB_GINTSTS_DEVICEMODE_GOUTNakEff_Pos (7UL)                     /*!< USB GINTSTS_DEVICEMODE: GOUTNakEff (Bit 7)                  */
#define USB_GINTSTS_DEVICEMODE_GOUTNakEff_Msk (0x80UL)                  /*!< USB GINTSTS_DEVICEMODE: GOUTNakEff (Bitfield-Mask: 0x01)    */
#define USB_GINTSTS_DEVICEMODE_ErlySusp_Pos   (10UL)                    /*!< USB GINTSTS_DEVICEMODE: ErlySusp (Bit 10)                   */
#define USB_GINTSTS_DEVICEMODE_ErlySusp_Msk   (0x400UL)                 /*!< USB GINTSTS_DEVICEMODE: ErlySusp (Bitfield-Mask: 0x01)      */
#define USB_GINTSTS_DEVICEMODE_USBSusp_Pos    (11UL)                    /*!< USB GINTSTS_DEVICEMODE: USBSusp (Bit 11)                    */
#define USB_GINTSTS_DEVICEMODE_USBSusp_Msk    (0x800UL)                 /*!< USB GINTSTS_DEVICEMODE: USBSusp (Bitfield-Mask: 0x01)       */
#define USB_GINTSTS_DEVICEMODE_USBRst_Pos     (12UL)                    /*!< USB GINTSTS_DEVICEMODE: USBRst (Bit 12)                     */
#define USB_GINTSTS_DEVICEMODE_USBRst_Msk     (0x1000UL)                /*!< USB GINTSTS_DEVICEMODE: USBRst (Bitfield-Mask: 0x01)        */
#define USB_GINTSTS_DEVICEMODE_EnumDone_Pos   (13UL)                    /*!< USB GINTSTS_DEVICEMODE: EnumDone (Bit 13)                   */
#define USB_GINTSTS_DEVICEMODE_EnumDone_Msk   (0x2000UL)                /*!< USB GINTSTS_DEVICEMODE: EnumDone (Bitfield-Mask: 0x01)      */
#define USB_GINTSTS_DEVICEMODE_ISOOutDrop_Pos (14UL)                    /*!< USB GINTSTS_DEVICEMODE: ISOOutDrop (Bit 14)                 */
#define USB_GINTSTS_DEVICEMODE_ISOOutDrop_Msk (0x4000UL)                /*!< USB GINTSTS_DEVICEMODE: ISOOutDrop (Bitfield-Mask: 0x01)    */
#define USB_GINTSTS_DEVICEMODE_EOPF_Pos       (15UL)                    /*!< USB GINTSTS_DEVICEMODE: EOPF (Bit 15)                       */
#define USB_GINTSTS_DEVICEMODE_EOPF_Msk       (0x8000UL)                /*!< USB GINTSTS_DEVICEMODE: EOPF (Bitfield-Mask: 0x01)          */
#define USB_GINTSTS_DEVICEMODE_IEPInt_Pos     (18UL)                    /*!< USB GINTSTS_DEVICEMODE: IEPInt (Bit 18)                     */
#define USB_GINTSTS_DEVICEMODE_IEPInt_Msk     (0x40000UL)               /*!< USB GINTSTS_DEVICEMODE: IEPInt (Bitfield-Mask: 0x01)        */
#define USB_GINTSTS_DEVICEMODE_OEPInt_Pos     (19UL)                    /*!< USB GINTSTS_DEVICEMODE: OEPInt (Bit 19)                     */
#define USB_GINTSTS_DEVICEMODE_OEPInt_Msk     (0x80000UL)               /*!< USB GINTSTS_DEVICEMODE: OEPInt (Bitfield-Mask: 0x01)        */
#define USB_GINTSTS_DEVICEMODE_incompISOIN_Pos (20UL)                   /*!< USB GINTSTS_DEVICEMODE: incompISOIN (Bit 20)                */
#define USB_GINTSTS_DEVICEMODE_incompISOIN_Msk (0x100000UL)             /*!< USB GINTSTS_DEVICEMODE: incompISOIN (Bitfield-Mask: 0x01)   */
#define USB_GINTSTS_DEVICEMODE_incomplSOOUT_Pos (21UL)                  /*!< USB GINTSTS_DEVICEMODE: incomplSOOUT (Bit 21)               */
#define USB_GINTSTS_DEVICEMODE_incomplSOOUT_Msk (0x200000UL)            /*!< USB GINTSTS_DEVICEMODE: incomplSOOUT (Bitfield-Mask: 0x01)  */
#define USB_GINTSTS_DEVICEMODE_ConIDStsChng_Pos (28UL)                  /*!< USB GINTSTS_DEVICEMODE: ConIDStsChng (Bit 28)               */
#define USB_GINTSTS_DEVICEMODE_ConIDStsChng_Msk (0x10000000UL)          /*!< USB GINTSTS_DEVICEMODE: ConIDStsChng (Bitfield-Mask: 0x01)  */
#define USB_GINTSTS_DEVICEMODE_SessReqInt_Pos (30UL)                    /*!< USB GINTSTS_DEVICEMODE: SessReqInt (Bit 30)                 */
#define USB_GINTSTS_DEVICEMODE_SessReqInt_Msk (0x40000000UL)            /*!< USB GINTSTS_DEVICEMODE: SessReqInt (Bitfield-Mask: 0x01)    */
#define USB_GINTSTS_DEVICEMODE_WkUpInt_Pos    (31UL)                    /*!< USB GINTSTS_DEVICEMODE: WkUpInt (Bit 31)                    */
#define USB_GINTSTS_DEVICEMODE_WkUpInt_Msk    (0x80000000UL)            /*!< USB GINTSTS_DEVICEMODE: WkUpInt (Bitfield-Mask: 0x01)       */

/* ----------------------------  USB_GINTMSK_HOSTMODE  ---------------------------- */
#define USB_GINTMSK_HOSTMODE_ModeMisMsk_Pos   (1UL)                     /*!< USB GINTMSK_HOSTMODE: ModeMisMsk (Bit 1)                    */
#define USB_GINTMSK_HOSTMODE_ModeMisMsk_Msk   (0x2UL)                   /*!< USB GINTMSK_HOSTMODE: ModeMisMsk (Bitfield-Mask: 0x01)      */
#define USB_GINTMSK_HOSTMODE_OTGIntMsk_Pos    (2UL)                     /*!< USB GINTMSK_HOSTMODE: OTGIntMsk (Bit 2)                     */
#define USB_GINTMSK_HOSTMODE_OTGIntMsk_Msk    (0x4UL)                   /*!< USB GINTMSK_HOSTMODE: OTGIntMsk (Bitfield-Mask: 0x01)       */
#define USB_GINTMSK_HOSTMODE_SofMsk_Pos       (3UL)                     /*!< USB GINTMSK_HOSTMODE: SofMsk (Bit 3)                        */
#define USB_GINTMSK_HOSTMODE_SofMsk_Msk       (0x8UL)                   /*!< USB GINTMSK_HOSTMODE: SofMsk (Bitfield-Mask: 0x01)          */
#define USB_GINTMSK_HOSTMODE_RxFLvlMsk_Pos    (4UL)                     /*!< USB GINTMSK_HOSTMODE: RxFLvlMsk (Bit 4)                     */
#define USB_GINTMSK_HOSTMODE_RxFLvlMsk_Msk    (0x10UL)                  /*!< USB GINTMSK_HOSTMODE: RxFLvlMsk (Bitfield-Mask: 0x01)       */
#define USB_GINTMSK_HOSTMODE_incomplPMsk_Pos  (21UL)                    /*!< USB GINTMSK_HOSTMODE: incomplPMsk (Bit 21)                  */
#define USB_GINTMSK_HOSTMODE_incomplPMsk_Msk  (0x200000UL)              /*!< USB GINTMSK_HOSTMODE: incomplPMsk (Bitfield-Mask: 0x01)     */
#define USB_GINTMSK_HOSTMODE_PrtIntMsk_Pos    (24UL)                    /*!< USB GINTMSK_HOSTMODE: PrtIntMsk (Bit 24)                    */
#define USB_GINTMSK_HOSTMODE_PrtIntMsk_Msk    (0x1000000UL)             /*!< USB GINTMSK_HOSTMODE: PrtIntMsk (Bitfield-Mask: 0x01)       */
#define USB_GINTMSK_HOSTMODE_HChIntMsk_Pos    (25UL)                    /*!< USB GINTMSK_HOSTMODE: HChIntMsk (Bit 25)                    */
#define USB_GINTMSK_HOSTMODE_HChIntMsk_Msk    (0x2000000UL)             /*!< USB GINTMSK_HOSTMODE: HChIntMsk (Bitfield-Mask: 0x01)       */
#define USB_GINTMSK_HOSTMODE_PTxFEmpMsk_Pos   (26UL)                    /*!< USB GINTMSK_HOSTMODE: PTxFEmpMsk (Bit 26)                   */
#define USB_GINTMSK_HOSTMODE_PTxFEmpMsk_Msk   (0x4000000UL)             /*!< USB GINTMSK_HOSTMODE: PTxFEmpMsk (Bitfield-Mask: 0x01)      */
#define USB_GINTMSK_HOSTMODE_ConIDStsChngMsk_Pos (28UL)                 /*!< USB GINTMSK_HOSTMODE: ConIDStsChngMsk (Bit 28)              */
#define USB_GINTMSK_HOSTMODE_ConIDStsChngMsk_Msk (0x10000000UL)         /*!< USB GINTMSK_HOSTMODE: ConIDStsChngMsk (Bitfield-Mask: 0x01) */
#define USB_GINTMSK_HOSTMODE_DisconnIntMsk_Pos (29UL)                   /*!< USB GINTMSK_HOSTMODE: DisconnIntMsk (Bit 29)                */
#define USB_GINTMSK_HOSTMODE_DisconnIntMsk_Msk (0x20000000UL)           /*!< USB GINTMSK_HOSTMODE: DisconnIntMsk (Bitfield-Mask: 0x01)   */
#define USB_GINTMSK_HOSTMODE_SessReqIntMsk_Pos (30UL)                   /*!< USB GINTMSK_HOSTMODE: SessReqIntMsk (Bit 30)                */
#define USB_GINTMSK_HOSTMODE_SessReqIntMsk_Msk (0x40000000UL)           /*!< USB GINTMSK_HOSTMODE: SessReqIntMsk (Bitfield-Mask: 0x01)   */
#define USB_GINTMSK_HOSTMODE_WkUpIntMsk_Pos   (31UL)                    /*!< USB GINTMSK_HOSTMODE: WkUpIntMsk (Bit 31)                   */
#define USB_GINTMSK_HOSTMODE_WkUpIntMsk_Msk   (0x80000000UL)            /*!< USB GINTMSK_HOSTMODE: WkUpIntMsk (Bitfield-Mask: 0x01)      */

/* ---------------------------  USB_GINTMSK_DEVICEMODE  --------------------------- */
#define USB_GINTMSK_DEVICEMODE_ModeMisMsk_Pos (1UL)                     /*!< USB GINTMSK_DEVICEMODE: ModeMisMsk (Bit 1)                  */
#define USB_GINTMSK_DEVICEMODE_ModeMisMsk_Msk (0x2UL)                   /*!< USB GINTMSK_DEVICEMODE: ModeMisMsk (Bitfield-Mask: 0x01)    */
#define USB_GINTMSK_DEVICEMODE_OTGIntMsk_Pos  (2UL)                     /*!< USB GINTMSK_DEVICEMODE: OTGIntMsk (Bit 2)                   */
#define USB_GINTMSK_DEVICEMODE_OTGIntMsk_Msk  (0x4UL)                   /*!< USB GINTMSK_DEVICEMODE: OTGIntMsk (Bitfield-Mask: 0x01)     */
#define USB_GINTMSK_DEVICEMODE_SofMsk_Pos     (3UL)                     /*!< USB GINTMSK_DEVICEMODE: SofMsk (Bit 3)                      */
#define USB_GINTMSK_DEVICEMODE_SofMsk_Msk     (0x8UL)                   /*!< USB GINTMSK_DEVICEMODE: SofMsk (Bitfield-Mask: 0x01)        */
#define USB_GINTMSK_DEVICEMODE_RxFLvlMsk_Pos  (4UL)                     /*!< USB GINTMSK_DEVICEMODE: RxFLvlMsk (Bit 4)                   */
#define USB_GINTMSK_DEVICEMODE_RxFLvlMsk_Msk  (0x10UL)                  /*!< USB GINTMSK_DEVICEMODE: RxFLvlMsk (Bitfield-Mask: 0x01)     */
#define USB_GINTMSK_DEVICEMODE_GINNakEffMsk_Pos (6UL)                   /*!< USB GINTMSK_DEVICEMODE: GINNakEffMsk (Bit 6)                */
#define USB_GINTMSK_DEVICEMODE_GINNakEffMsk_Msk (0x40UL)                /*!< USB GINTMSK_DEVICEMODE: GINNakEffMsk (Bitfield-Mask: 0x01)  */
#define USB_GINTMSK_DEVICEMODE_GOUTNakEffMsk_Pos (7UL)                  /*!< USB GINTMSK_DEVICEMODE: GOUTNakEffMsk (Bit 7)               */
#define USB_GINTMSK_DEVICEMODE_GOUTNakEffMsk_Msk (0x80UL)               /*!< USB GINTMSK_DEVICEMODE: GOUTNakEffMsk (Bitfield-Mask: 0x01) */
#define USB_GINTMSK_DEVICEMODE_ErlySuspMsk_Pos (10UL)                   /*!< USB GINTMSK_DEVICEMODE: ErlySuspMsk (Bit 10)                */
#define USB_GINTMSK_DEVICEMODE_ErlySuspMsk_Msk (0x400UL)                /*!< USB GINTMSK_DEVICEMODE: ErlySuspMsk (Bitfield-Mask: 0x01)   */
#define USB_GINTMSK_DEVICEMODE_USBSuspMsk_Pos (11UL)                    /*!< USB GINTMSK_DEVICEMODE: USBSuspMsk (Bit 11)                 */
#define USB_GINTMSK_DEVICEMODE_USBSuspMsk_Msk (0x800UL)                 /*!< USB GINTMSK_DEVICEMODE: USBSuspMsk (Bitfield-Mask: 0x01)    */
#define USB_GINTMSK_DEVICEMODE_USBRstMsk_Pos  (12UL)                    /*!< USB GINTMSK_DEVICEMODE: USBRstMsk (Bit 12)                  */
#define USB_GINTMSK_DEVICEMODE_USBRstMsk_Msk  (0x1000UL)                /*!< USB GINTMSK_DEVICEMODE: USBRstMsk (Bitfield-Mask: 0x01)     */
#define USB_GINTMSK_DEVICEMODE_EnumDoneMsk_Pos (13UL)                   /*!< USB GINTMSK_DEVICEMODE: EnumDoneMsk (Bit 13)                */
#define USB_GINTMSK_DEVICEMODE_EnumDoneMsk_Msk (0x2000UL)               /*!< USB GINTMSK_DEVICEMODE: EnumDoneMsk (Bitfield-Mask: 0x01)   */
#define USB_GINTMSK_DEVICEMODE_ISOOutDropMsk_Pos (14UL)                 /*!< USB GINTMSK_DEVICEMODE: ISOOutDropMsk (Bit 14)              */
#define USB_GINTMSK_DEVICEMODE_ISOOutDropMsk_Msk (0x4000UL)             /*!< USB GINTMSK_DEVICEMODE: ISOOutDropMsk (Bitfield-Mask: 0x01) */
#define USB_GINTMSK_DEVICEMODE_EOPFMsk_Pos    (15UL)                    /*!< USB GINTMSK_DEVICEMODE: EOPFMsk (Bit 15)                    */
#define USB_GINTMSK_DEVICEMODE_EOPFMsk_Msk    (0x8000UL)                /*!< USB GINTMSK_DEVICEMODE: EOPFMsk (Bitfield-Mask: 0x01)       */
#define USB_GINTMSK_DEVICEMODE_IEPIntMsk_Pos  (18UL)                    /*!< USB GINTMSK_DEVICEMODE: IEPIntMsk (Bit 18)                  */
#define USB_GINTMSK_DEVICEMODE_IEPIntMsk_Msk  (0x40000UL)               /*!< USB GINTMSK_DEVICEMODE: IEPIntMsk (Bitfield-Mask: 0x01)     */
#define USB_GINTMSK_DEVICEMODE_OEPIntMsk_Pos  (19UL)                    /*!< USB GINTMSK_DEVICEMODE: OEPIntMsk (Bit 19)                  */
#define USB_GINTMSK_DEVICEMODE_OEPIntMsk_Msk  (0x80000UL)               /*!< USB GINTMSK_DEVICEMODE: OEPIntMsk (Bitfield-Mask: 0x01)     */
#define USB_GINTMSK_DEVICEMODE_incompISOINMsk_Pos (20UL)                /*!< USB GINTMSK_DEVICEMODE: incompISOINMsk (Bit 20)             */
#define USB_GINTMSK_DEVICEMODE_incompISOINMsk_Msk (0x100000UL)          /*!< USB GINTMSK_DEVICEMODE: incompISOINMsk (Bitfield-Mask: 0x01) */
#define USB_GINTMSK_DEVICEMODE_incomplSOOUTMsk_Pos (21UL)               /*!< USB GINTMSK_DEVICEMODE: incomplSOOUTMsk (Bit 21)            */
#define USB_GINTMSK_DEVICEMODE_incomplSOOUTMsk_Msk (0x200000UL)         /*!< USB GINTMSK_DEVICEMODE: incomplSOOUTMsk (Bitfield-Mask: 0x01) */
#define USB_GINTMSK_DEVICEMODE_ConIDStsChngMsk_Pos (28UL)               /*!< USB GINTMSK_DEVICEMODE: ConIDStsChngMsk (Bit 28)            */
#define USB_GINTMSK_DEVICEMODE_ConIDStsChngMsk_Msk (0x10000000UL)       /*!< USB GINTMSK_DEVICEMODE: ConIDStsChngMsk (Bitfield-Mask: 0x01) */
#define USB_GINTMSK_DEVICEMODE_DisconnIntMsk_Pos (29UL)                 /*!< USB GINTMSK_DEVICEMODE: DisconnIntMsk (Bit 29)              */
#define USB_GINTMSK_DEVICEMODE_DisconnIntMsk_Msk (0x20000000UL)         /*!< USB GINTMSK_DEVICEMODE: DisconnIntMsk (Bitfield-Mask: 0x01) */
#define USB_GINTMSK_DEVICEMODE_SessReqIntMsk_Pos (30UL)                 /*!< USB GINTMSK_DEVICEMODE: SessReqIntMsk (Bit 30)              */
#define USB_GINTMSK_DEVICEMODE_SessReqIntMsk_Msk (0x40000000UL)         /*!< USB GINTMSK_DEVICEMODE: SessReqIntMsk (Bitfield-Mask: 0x01) */
#define USB_GINTMSK_DEVICEMODE_WkUpIntMsk_Pos (31UL)                    /*!< USB GINTMSK_DEVICEMODE: WkUpIntMsk (Bit 31)                 */
#define USB_GINTMSK_DEVICEMODE_WkUpIntMsk_Msk (0x80000000UL)            /*!< USB GINTMSK_DEVICEMODE: WkUpIntMsk (Bitfield-Mask: 0x01)    */

/* ----------------------------  USB_GRXSTSR_HOSTMODE  ---------------------------- */
#define USB_GRXSTSR_HOSTMODE_ChNum_Pos        (0UL)                     /*!< USB GRXSTSR_HOSTMODE: ChNum (Bit 0)                         */
#define USB_GRXSTSR_HOSTMODE_ChNum_Msk        (0xfUL)                   /*!< USB GRXSTSR_HOSTMODE: ChNum (Bitfield-Mask: 0x0f)           */
#define USB_GRXSTSR_HOSTMODE_BCnt_Pos         (4UL)                     /*!< USB GRXSTSR_HOSTMODE: BCnt (Bit 4)                          */
#define USB_GRXSTSR_HOSTMODE_BCnt_Msk         (0x7ff0UL)                /*!< USB GRXSTSR_HOSTMODE: BCnt (Bitfield-Mask: 0x7ff)           */
#define USB_GRXSTSR_HOSTMODE_DPID_Pos         (15UL)                    /*!< USB GRXSTSR_HOSTMODE: DPID (Bit 15)                         */
#define USB_GRXSTSR_HOSTMODE_DPID_Msk         (0x18000UL)               /*!< USB GRXSTSR_HOSTMODE: DPID (Bitfield-Mask: 0x03)            */
#define USB_GRXSTSR_HOSTMODE_PktSts_Pos       (17UL)                    /*!< USB GRXSTSR_HOSTMODE: PktSts (Bit 17)                       */
#define USB_GRXSTSR_HOSTMODE_PktSts_Msk       (0x1e0000UL)              /*!< USB GRXSTSR_HOSTMODE: PktSts (Bitfield-Mask: 0x0f)          */

/* ---------------------------  USB_GRXSTSR_DEVICEMODE  --------------------------- */
#define USB_GRXSTSR_DEVICEMODE_EPNum_Pos      (0UL)                     /*!< USB GRXSTSR_DEVICEMODE: EPNum (Bit 0)                       */
#define USB_GRXSTSR_DEVICEMODE_EPNum_Msk      (0xfUL)                   /*!< USB GRXSTSR_DEVICEMODE: EPNum (Bitfield-Mask: 0x0f)         */
#define USB_GRXSTSR_DEVICEMODE_BCnt_Pos       (4UL)                     /*!< USB GRXSTSR_DEVICEMODE: BCnt (Bit 4)                        */
#define USB_GRXSTSR_DEVICEMODE_BCnt_Msk       (0x7ff0UL)                /*!< USB GRXSTSR_DEVICEMODE: BCnt (Bitfield-Mask: 0x7ff)         */
#define USB_GRXSTSR_DEVICEMODE_DPID_Pos       (15UL)                    /*!< USB GRXSTSR_DEVICEMODE: DPID (Bit 15)                       */
#define USB_GRXSTSR_DEVICEMODE_DPID_Msk       (0x18000UL)               /*!< USB GRXSTSR_DEVICEMODE: DPID (Bitfield-Mask: 0x03)          */
#define USB_GRXSTSR_DEVICEMODE_PktSts_Pos     (17UL)                    /*!< USB GRXSTSR_DEVICEMODE: PktSts (Bit 17)                     */
#define USB_GRXSTSR_DEVICEMODE_PktSts_Msk     (0x1e0000UL)              /*!< USB GRXSTSR_DEVICEMODE: PktSts (Bitfield-Mask: 0x0f)        */
#define USB_GRXSTSR_DEVICEMODE_FN_Pos         (21UL)                    /*!< USB GRXSTSR_DEVICEMODE: FN (Bit 21)                         */
#define USB_GRXSTSR_DEVICEMODE_FN_Msk         (0x1e00000UL)             /*!< USB GRXSTSR_DEVICEMODE: FN (Bitfield-Mask: 0x0f)            */

/* ---------------------------  USB_GRXSTSP_DEVICEMODE  --------------------------- */
#define USB_GRXSTSP_DEVICEMODE_EPNum_Pos      (0UL)                     /*!< USB GRXSTSP_DEVICEMODE: EPNum (Bit 0)                       */
#define USB_GRXSTSP_DEVICEMODE_EPNum_Msk      (0xfUL)                   /*!< USB GRXSTSP_DEVICEMODE: EPNum (Bitfield-Mask: 0x0f)         */
#define USB_GRXSTSP_DEVICEMODE_BCnt_Pos       (4UL)                     /*!< USB GRXSTSP_DEVICEMODE: BCnt (Bit 4)                        */
#define USB_GRXSTSP_DEVICEMODE_BCnt_Msk       (0x7ff0UL)                /*!< USB GRXSTSP_DEVICEMODE: BCnt (Bitfield-Mask: 0x7ff)         */
#define USB_GRXSTSP_DEVICEMODE_DPID_Pos       (15UL)                    /*!< USB GRXSTSP_DEVICEMODE: DPID (Bit 15)                       */
#define USB_GRXSTSP_DEVICEMODE_DPID_Msk       (0x18000UL)               /*!< USB GRXSTSP_DEVICEMODE: DPID (Bitfield-Mask: 0x03)          */
#define USB_GRXSTSP_DEVICEMODE_PktSts_Pos     (17UL)                    /*!< USB GRXSTSP_DEVICEMODE: PktSts (Bit 17)                     */
#define USB_GRXSTSP_DEVICEMODE_PktSts_Msk     (0x1e0000UL)              /*!< USB GRXSTSP_DEVICEMODE: PktSts (Bitfield-Mask: 0x0f)        */
#define USB_GRXSTSP_DEVICEMODE_FN_Pos         (21UL)                    /*!< USB GRXSTSP_DEVICEMODE: FN (Bit 21)                         */
#define USB_GRXSTSP_DEVICEMODE_FN_Msk         (0x1e00000UL)             /*!< USB GRXSTSP_DEVICEMODE: FN (Bitfield-Mask: 0x0f)            */

/* ----------------------------  USB_GRXSTSP_HOSTMODE  ---------------------------- */
#define USB_GRXSTSP_HOSTMODE_ChNum_Pos        (0UL)                     /*!< USB GRXSTSP_HOSTMODE: ChNum (Bit 0)                         */
#define USB_GRXSTSP_HOSTMODE_ChNum_Msk        (0xfUL)                   /*!< USB GRXSTSP_HOSTMODE: ChNum (Bitfield-Mask: 0x0f)           */
#define USB_GRXSTSP_HOSTMODE_BCnt_Pos         (4UL)                     /*!< USB GRXSTSP_HOSTMODE: BCnt (Bit 4)                          */
#define USB_GRXSTSP_HOSTMODE_BCnt_Msk         (0x7ff0UL)                /*!< USB GRXSTSP_HOSTMODE: BCnt (Bitfield-Mask: 0x7ff)           */
#define USB_GRXSTSP_HOSTMODE_DPID_Pos         (15UL)                    /*!< USB GRXSTSP_HOSTMODE: DPID (Bit 15)                         */
#define USB_GRXSTSP_HOSTMODE_DPID_Msk         (0x18000UL)               /*!< USB GRXSTSP_HOSTMODE: DPID (Bitfield-Mask: 0x03)            */
#define USB_GRXSTSP_HOSTMODE_PktSts_Pos       (17UL)                    /*!< USB GRXSTSP_HOSTMODE: PktSts (Bit 17)                       */
#define USB_GRXSTSP_HOSTMODE_PktSts_Msk       (0x1e0000UL)              /*!< USB GRXSTSP_HOSTMODE: PktSts (Bitfield-Mask: 0x0f)          */

/* ---------------------------------  USB_GRXFSIZ  -------------------------------- */
#define USB_GRXFSIZ_RxFDep_Pos                (0UL)                     /*!< USB GRXFSIZ: RxFDep (Bit 0)                                 */
#define USB_GRXFSIZ_RxFDep_Msk                (0xffffUL)                /*!< USB GRXFSIZ: RxFDep (Bitfield-Mask: 0xffff)                 */

/* ---------------------------  USB_GNPTXFSIZ_HOSTMODE  --------------------------- */
#define USB_GNPTXFSIZ_HOSTMODE_NPTxFStAddr_Pos (0UL)                    /*!< USB GNPTXFSIZ_HOSTMODE: NPTxFStAddr (Bit 0)                 */
#define USB_GNPTXFSIZ_HOSTMODE_NPTxFStAddr_Msk (0xffffUL)               /*!< USB GNPTXFSIZ_HOSTMODE: NPTxFStAddr (Bitfield-Mask: 0xffff) */
#define USB_GNPTXFSIZ_HOSTMODE_NPTxFDep_Pos   (16UL)                    /*!< USB GNPTXFSIZ_HOSTMODE: NPTxFDep (Bit 16)                   */
#define USB_GNPTXFSIZ_HOSTMODE_NPTxFDep_Msk   (0xffff0000UL)            /*!< USB GNPTXFSIZ_HOSTMODE: NPTxFDep (Bitfield-Mask: 0xffff)    */

/* --------------------------  USB_GNPTXFSIZ_DEVICEMODE  -------------------------- */
#define USB_GNPTXFSIZ_DEVICEMODE_INEPTxF0StAddr_Pos (0UL)               /*!< USB GNPTXFSIZ_DEVICEMODE: INEPTxF0StAddr (Bit 0)            */
#define USB_GNPTXFSIZ_DEVICEMODE_INEPTxF0StAddr_Msk (0xffffUL)          /*!< USB GNPTXFSIZ_DEVICEMODE: INEPTxF0StAddr (Bitfield-Mask: 0xffff) */
#define USB_GNPTXFSIZ_DEVICEMODE_INEPTxF0Dep_Pos (16UL)                 /*!< USB GNPTXFSIZ_DEVICEMODE: INEPTxF0Dep (Bit 16)              */
#define USB_GNPTXFSIZ_DEVICEMODE_INEPTxF0Dep_Msk (0xffff0000UL)         /*!< USB GNPTXFSIZ_DEVICEMODE: INEPTxF0Dep (Bitfield-Mask: 0xffff) */

/* --------------------------------  USB_GNPTXSTS  -------------------------------- */
#define USB_GNPTXSTS_NPTxFSpcAvail_Pos        (0UL)                     /*!< USB GNPTXSTS: NPTxFSpcAvail (Bit 0)                         */
#define USB_GNPTXSTS_NPTxFSpcAvail_Msk        (0xffffUL)                /*!< USB GNPTXSTS: NPTxFSpcAvail (Bitfield-Mask: 0xffff)         */
#define USB_GNPTXSTS_NPTxQSpcAvail_Pos        (16UL)                    /*!< USB GNPTXSTS: NPTxQSpcAvail (Bit 16)                        */
#define USB_GNPTXSTS_NPTxQSpcAvail_Msk        (0xff0000UL)              /*!< USB GNPTXSTS: NPTxQSpcAvail (Bitfield-Mask: 0xff)           */
#define USB_GNPTXSTS_NPTxQTop_Pos             (24UL)                    /*!< USB GNPTXSTS: NPTxQTop (Bit 24)                             */
#define USB_GNPTXSTS_NPTxQTop_Msk             (0x7f000000UL)            /*!< USB GNPTXSTS: NPTxQTop (Bitfield-Mask: 0x7f)                */

/* ----------------------------------  USB_GUID  ---------------------------------- */
#define USB_GUID_MOD_REV_Pos                  (0UL)                     /*!< USB GUID: MOD_REV (Bit 0)                                   */
#define USB_GUID_MOD_REV_Msk                  (0xffUL)                  /*!< USB GUID: MOD_REV (Bitfield-Mask: 0xff)                     */
#define USB_GUID_MOD_TYPE_Pos                 (8UL)                     /*!< USB GUID: MOD_TYPE (Bit 8)                                  */
#define USB_GUID_MOD_TYPE_Msk                 (0xff00UL)                /*!< USB GUID: MOD_TYPE (Bitfield-Mask: 0xff)                    */
#define USB_GUID_MOD_NUMBER_Pos               (16UL)                    /*!< USB GUID: MOD_NUMBER (Bit 16)                               */
#define USB_GUID_MOD_NUMBER_Msk               (0xffff0000UL)            /*!< USB GUID: MOD_NUMBER (Bitfield-Mask: 0xffff)                */

/* --------------------------------  USB_GDFIFOCFG  ------------------------------- */
#define USB_GDFIFOCFG_GDFIFOCfg_Pos           (0UL)                     /*!< USB GDFIFOCFG: GDFIFOCfg (Bit 0)                            */
#define USB_GDFIFOCFG_GDFIFOCfg_Msk           (0xffffUL)                /*!< USB GDFIFOCFG: GDFIFOCfg (Bitfield-Mask: 0xffff)            */
#define USB_GDFIFOCFG_EPInfoBaseAddr_Pos      (16UL)                    /*!< USB GDFIFOCFG: EPInfoBaseAddr (Bit 16)                      */
#define USB_GDFIFOCFG_EPInfoBaseAddr_Msk      (0xffff0000UL)            /*!< USB GDFIFOCFG: EPInfoBaseAddr (Bitfield-Mask: 0xffff)       */

/* --------------------------------  USB_HPTXFSIZ  -------------------------------- */
#define USB_HPTXFSIZ_PTxFStAddr_Pos           (0UL)                     /*!< USB HPTXFSIZ: PTxFStAddr (Bit 0)                            */
#define USB_HPTXFSIZ_PTxFStAddr_Msk           (0xffffUL)                /*!< USB HPTXFSIZ: PTxFStAddr (Bitfield-Mask: 0xffff)            */
#define USB_HPTXFSIZ_PTxFSize_Pos             (16UL)                    /*!< USB HPTXFSIZ: PTxFSize (Bit 16)                             */
#define USB_HPTXFSIZ_PTxFSize_Msk             (0xffff0000UL)            /*!< USB HPTXFSIZ: PTxFSize (Bitfield-Mask: 0xffff)              */

/* --------------------------------  USB_DIEPTXF1  -------------------------------- */
#define USB_DIEPTXF1_INEPnTxFStAddr_Pos       (0UL)                     /*!< USB DIEPTXF1: INEPnTxFStAddr (Bit 0)                        */
#define USB_DIEPTXF1_INEPnTxFStAddr_Msk       (0xffffUL)                /*!< USB DIEPTXF1: INEPnTxFStAddr (Bitfield-Mask: 0xffff)        */
#define USB_DIEPTXF1_INEPnTxFDep_Pos          (16UL)                    /*!< USB DIEPTXF1: INEPnTxFDep (Bit 16)                          */
#define USB_DIEPTXF1_INEPnTxFDep_Msk          (0xffff0000UL)            /*!< USB DIEPTXF1: INEPnTxFDep (Bitfield-Mask: 0xffff)           */

/* --------------------------------  USB_DIEPTXF2  -------------------------------- */
#define USB_DIEPTXF2_INEPnTxFStAddr_Pos       (0UL)                     /*!< USB DIEPTXF2: INEPnTxFStAddr (Bit 0)                        */
#define USB_DIEPTXF2_INEPnTxFStAddr_Msk       (0xffffUL)                /*!< USB DIEPTXF2: INEPnTxFStAddr (Bitfield-Mask: 0xffff)        */
#define USB_DIEPTXF2_INEPnTxFDep_Pos          (16UL)                    /*!< USB DIEPTXF2: INEPnTxFDep (Bit 16)                          */
#define USB_DIEPTXF2_INEPnTxFDep_Msk          (0xffff0000UL)            /*!< USB DIEPTXF2: INEPnTxFDep (Bitfield-Mask: 0xffff)           */

/* --------------------------------  USB_DIEPTXF3  -------------------------------- */
#define USB_DIEPTXF3_INEPnTxFStAddr_Pos       (0UL)                     /*!< USB DIEPTXF3: INEPnTxFStAddr (Bit 0)                        */
#define USB_DIEPTXF3_INEPnTxFStAddr_Msk       (0xffffUL)                /*!< USB DIEPTXF3: INEPnTxFStAddr (Bitfield-Mask: 0xffff)        */
#define USB_DIEPTXF3_INEPnTxFDep_Pos          (16UL)                    /*!< USB DIEPTXF3: INEPnTxFDep (Bit 16)                          */
#define USB_DIEPTXF3_INEPnTxFDep_Msk          (0xffff0000UL)            /*!< USB DIEPTXF3: INEPnTxFDep (Bitfield-Mask: 0xffff)           */

/* --------------------------------  USB_DIEPTXF4  -------------------------------- */
#define USB_DIEPTXF4_INEPnTxFStAddr_Pos       (0UL)                     /*!< USB DIEPTXF4: INEPnTxFStAddr (Bit 0)                        */
#define USB_DIEPTXF4_INEPnTxFStAddr_Msk       (0xffffUL)                /*!< USB DIEPTXF4: INEPnTxFStAddr (Bitfield-Mask: 0xffff)        */
#define USB_DIEPTXF4_INEPnTxFDep_Pos          (16UL)                    /*!< USB DIEPTXF4: INEPnTxFDep (Bit 16)                          */
#define USB_DIEPTXF4_INEPnTxFDep_Msk          (0xffff0000UL)            /*!< USB DIEPTXF4: INEPnTxFDep (Bitfield-Mask: 0xffff)           */

/* --------------------------------  USB_DIEPTXF5  -------------------------------- */
#define USB_DIEPTXF5_INEPnTxFStAddr_Pos       (0UL)                     /*!< USB DIEPTXF5: INEPnTxFStAddr (Bit 0)                        */
#define USB_DIEPTXF5_INEPnTxFStAddr_Msk       (0xffffUL)                /*!< USB DIEPTXF5: INEPnTxFStAddr (Bitfield-Mask: 0xffff)        */
#define USB_DIEPTXF5_INEPnTxFDep_Pos          (16UL)                    /*!< USB DIEPTXF5: INEPnTxFDep (Bit 16)                          */
#define USB_DIEPTXF5_INEPnTxFDep_Msk          (0xffff0000UL)            /*!< USB DIEPTXF5: INEPnTxFDep (Bitfield-Mask: 0xffff)           */

/* --------------------------------  USB_DIEPTXF6  -------------------------------- */
#define USB_DIEPTXF6_INEPnTxFStAddr_Pos       (0UL)                     /*!< USB DIEPTXF6: INEPnTxFStAddr (Bit 0)                        */
#define USB_DIEPTXF6_INEPnTxFStAddr_Msk       (0xffffUL)                /*!< USB DIEPTXF6: INEPnTxFStAddr (Bitfield-Mask: 0xffff)        */
#define USB_DIEPTXF6_INEPnTxFDep_Pos          (16UL)                    /*!< USB DIEPTXF6: INEPnTxFDep (Bit 16)                          */
#define USB_DIEPTXF6_INEPnTxFDep_Msk          (0xffff0000UL)            /*!< USB DIEPTXF6: INEPnTxFDep (Bitfield-Mask: 0xffff)           */

/* ----------------------------------  USB_HCFG  ---------------------------------- */
#define USB_HCFG_FSLSPclkSel_Pos              (0UL)                     /*!< USB HCFG: FSLSPclkSel (Bit 0)                               */
#define USB_HCFG_FSLSPclkSel_Msk              (0x3UL)                   /*!< USB HCFG: FSLSPclkSel (Bitfield-Mask: 0x03)                 */
#define USB_HCFG_FSLSSupp_Pos                 (2UL)                     /*!< USB HCFG: FSLSSupp (Bit 2)                                  */
#define USB_HCFG_FSLSSupp_Msk                 (0x4UL)                   /*!< USB HCFG: FSLSSupp (Bitfield-Mask: 0x01)                    */
#define USB_HCFG_DescDMA_Pos                  (23UL)                    /*!< USB HCFG: DescDMA (Bit 23)                                  */
#define USB_HCFG_DescDMA_Msk                  (0x800000UL)              /*!< USB HCFG: DescDMA (Bitfield-Mask: 0x01)                     */
#define USB_HCFG_FrListEn_Pos                 (24UL)                    /*!< USB HCFG: FrListEn (Bit 24)                                 */
#define USB_HCFG_FrListEn_Msk                 (0x3000000UL)             /*!< USB HCFG: FrListEn (Bitfield-Mask: 0x03)                    */
#define USB_HCFG_PerSchedEna_Pos              (26UL)                    /*!< USB HCFG: PerSchedEna (Bit 26)                              */
#define USB_HCFG_PerSchedEna_Msk              (0x4000000UL)             /*!< USB HCFG: PerSchedEna (Bitfield-Mask: 0x01)                 */

/* ----------------------------------  USB_HFIR  ---------------------------------- */
#define USB_HFIR_FrInt_Pos                    (0UL)                     /*!< USB HFIR: FrInt (Bit 0)                                     */
#define USB_HFIR_FrInt_Msk                    (0xffffUL)                /*!< USB HFIR: FrInt (Bitfield-Mask: 0xffff)                     */
#define USB_HFIR_HFIRRldCtrl_Pos              (16UL)                    /*!< USB HFIR: HFIRRldCtrl (Bit 16)                              */
#define USB_HFIR_HFIRRldCtrl_Msk              (0x10000UL)               /*!< USB HFIR: HFIRRldCtrl (Bitfield-Mask: 0x01)                 */

/* ----------------------------------  USB_HFNUM  --------------------------------- */
#define USB_HFNUM_FrNum_Pos                   (0UL)                     /*!< USB HFNUM: FrNum (Bit 0)                                    */
#define USB_HFNUM_FrNum_Msk                   (0xffffUL)                /*!< USB HFNUM: FrNum (Bitfield-Mask: 0xffff)                    */
#define USB_HFNUM_FrRem_Pos                   (16UL)                    /*!< USB HFNUM: FrRem (Bit 16)                                   */
#define USB_HFNUM_FrRem_Msk                   (0xffff0000UL)            /*!< USB HFNUM: FrRem (Bitfield-Mask: 0xffff)                    */

/* ---------------------------------  USB_HPTXSTS  -------------------------------- */
#define USB_HPTXSTS_PTxFSpcAvail_Pos          (0UL)                     /*!< USB HPTXSTS: PTxFSpcAvail (Bit 0)                           */
#define USB_HPTXSTS_PTxFSpcAvail_Msk          (0xffffUL)                /*!< USB HPTXSTS: PTxFSpcAvail (Bitfield-Mask: 0xffff)           */
#define USB_HPTXSTS_PTxQSpcAvail_Pos          (16UL)                    /*!< USB HPTXSTS: PTxQSpcAvail (Bit 16)                          */
#define USB_HPTXSTS_PTxQSpcAvail_Msk          (0xff0000UL)              /*!< USB HPTXSTS: PTxQSpcAvail (Bitfield-Mask: 0xff)             */
#define USB_HPTXSTS_PTxQTop_Pos               (24UL)                    /*!< USB HPTXSTS: PTxQTop (Bit 24)                               */
#define USB_HPTXSTS_PTxQTop_Msk               (0xff000000UL)            /*!< USB HPTXSTS: PTxQTop (Bitfield-Mask: 0xff)                  */

/* ----------------------------------  USB_HAINT  --------------------------------- */
#define USB_HAINT_HAINT_Pos                   (0UL)                     /*!< USB HAINT: HAINT (Bit 0)                                    */
#define USB_HAINT_HAINT_Msk                   (0x3fffUL)                /*!< USB HAINT: HAINT (Bitfield-Mask: 0x3fff)                    */

/* --------------------------------  USB_HAINTMSK  -------------------------------- */
#define USB_HAINTMSK_HAINTMsk_Pos             (0UL)                     /*!< USB HAINTMSK: HAINTMsk (Bit 0)                              */
#define USB_HAINTMSK_HAINTMsk_Msk             (0x3fffUL)                /*!< USB HAINTMSK: HAINTMsk (Bitfield-Mask: 0x3fff)              */

/* --------------------------------  USB_HFLBADDR  -------------------------------- */
#define USB_HFLBADDR_Starting_Address_Pos     (0UL)                     /*!< USB HFLBADDR: Starting_Address (Bit 0)                      */
#define USB_HFLBADDR_Starting_Address_Msk     (0xffffffffUL)            /*!< USB HFLBADDR: Starting_Address (Bitfield-Mask: 0xffffffff)  */

/* ----------------------------------  USB_HPRT  ---------------------------------- */
#define USB_HPRT_PrtConnSts_Pos               (0UL)                     /*!< USB HPRT: PrtConnSts (Bit 0)                                */
#define USB_HPRT_PrtConnSts_Msk               (0x1UL)                   /*!< USB HPRT: PrtConnSts (Bitfield-Mask: 0x01)                  */
#define USB_HPRT_PrtConnDet_Pos               (1UL)                     /*!< USB HPRT: PrtConnDet (Bit 1)                                */
#define USB_HPRT_PrtConnDet_Msk               (0x2UL)                   /*!< USB HPRT: PrtConnDet (Bitfield-Mask: 0x01)                  */
#define USB_HPRT_PrtEna_Pos                   (2UL)                     /*!< USB HPRT: PrtEna (Bit 2)                                    */
#define USB_HPRT_PrtEna_Msk                   (0x4UL)                   /*!< USB HPRT: PrtEna (Bitfield-Mask: 0x01)                      */
#define USB_HPRT_PrtEnChng_Pos                (3UL)                     /*!< USB HPRT: PrtEnChng (Bit 3)                                 */
#define USB_HPRT_PrtEnChng_Msk                (0x8UL)                   /*!< USB HPRT: PrtEnChng (Bitfield-Mask: 0x01)                   */
#define USB_HPRT_PrtOvrCurrAct_Pos            (4UL)                     /*!< USB HPRT: PrtOvrCurrAct (Bit 4)                             */
#define USB_HPRT_PrtOvrCurrAct_Msk            (0x10UL)                  /*!< USB HPRT: PrtOvrCurrAct (Bitfield-Mask: 0x01)               */
#define USB_HPRT_PrtOvrCurrChng_Pos           (5UL)                     /*!< USB HPRT: PrtOvrCurrChng (Bit 5)                            */
#define USB_HPRT_PrtOvrCurrChng_Msk           (0x20UL)                  /*!< USB HPRT: PrtOvrCurrChng (Bitfield-Mask: 0x01)              */
#define USB_HPRT_PrtRes_Pos                   (6UL)                     /*!< USB HPRT: PrtRes (Bit 6)                                    */
#define USB_HPRT_PrtRes_Msk                   (0x40UL)                  /*!< USB HPRT: PrtRes (Bitfield-Mask: 0x01)                      */
#define USB_HPRT_PrtSusp_Pos                  (7UL)                     /*!< USB HPRT: PrtSusp (Bit 7)                                   */
#define USB_HPRT_PrtSusp_Msk                  (0x80UL)                  /*!< USB HPRT: PrtSusp (Bitfield-Mask: 0x01)                     */
#define USB_HPRT_PrtRst_Pos                   (8UL)                     /*!< USB HPRT: PrtRst (Bit 8)                                    */
#define USB_HPRT_PrtRst_Msk                   (0x100UL)                 /*!< USB HPRT: PrtRst (Bitfield-Mask: 0x01)                      */
#define USB_HPRT_PrtLnSts_Pos                 (10UL)                    /*!< USB HPRT: PrtLnSts (Bit 10)                                 */
#define USB_HPRT_PrtLnSts_Msk                 (0xc00UL)                 /*!< USB HPRT: PrtLnSts (Bitfield-Mask: 0x03)                    */
#define USB_HPRT_PrtPwr_Pos                   (12UL)                    /*!< USB HPRT: PrtPwr (Bit 12)                                   */
#define USB_HPRT_PrtPwr_Msk                   (0x1000UL)                /*!< USB HPRT: PrtPwr (Bitfield-Mask: 0x01)                      */
#define USB_HPRT_PrtSpd_Pos                   (17UL)                    /*!< USB HPRT: PrtSpd (Bit 17)                                   */
#define USB_HPRT_PrtSpd_Msk                   (0x60000UL)               /*!< USB HPRT: PrtSpd (Bitfield-Mask: 0x03)                      */

/* ----------------------------------  USB_DCFG  ---------------------------------- */
#define USB_DCFG_DevSpd_Pos                   (0UL)                     /*!< USB DCFG: DevSpd (Bit 0)                                    */
#define USB_DCFG_DevSpd_Msk                   (0x3UL)                   /*!< USB DCFG: DevSpd (Bitfield-Mask: 0x03)                      */
#define USB_DCFG_NZStsOUTHShk_Pos             (2UL)                     /*!< USB DCFG: NZStsOUTHShk (Bit 2)                              */
#define USB_DCFG_NZStsOUTHShk_Msk             (0x4UL)                   /*!< USB DCFG: NZStsOUTHShk (Bitfield-Mask: 0x01)                */
#define USB_DCFG_DevAddr_Pos                  (4UL)                     /*!< USB DCFG: DevAddr (Bit 4)                                   */
#define USB_DCFG_DevAddr_Msk                  (0x7f0UL)                 /*!< USB DCFG: DevAddr (Bitfield-Mask: 0x7f)                     */
#define USB_DCFG_PerFrInt_Pos                 (11UL)                    /*!< USB DCFG: PerFrInt (Bit 11)                                 */
#define USB_DCFG_PerFrInt_Msk                 (0x1800UL)                /*!< USB DCFG: PerFrInt (Bitfield-Mask: 0x03)                    */
#define USB_DCFG_DescDMA_Pos                  (23UL)                    /*!< USB DCFG: DescDMA (Bit 23)                                  */
#define USB_DCFG_DescDMA_Msk                  (0x800000UL)              /*!< USB DCFG: DescDMA (Bitfield-Mask: 0x01)                     */
#define USB_DCFG_PerSchIntvl_Pos              (24UL)                    /*!< USB DCFG: PerSchIntvl (Bit 24)                              */
#define USB_DCFG_PerSchIntvl_Msk              (0x3000000UL)             /*!< USB DCFG: PerSchIntvl (Bitfield-Mask: 0x03)                 */

/* ----------------------------------  USB_DCTL  ---------------------------------- */
#define USB_DCTL_RmtWkUpSig_Pos               (0UL)                     /*!< USB DCTL: RmtWkUpSig (Bit 0)                                */
#define USB_DCTL_RmtWkUpSig_Msk               (0x1UL)                   /*!< USB DCTL: RmtWkUpSig (Bitfield-Mask: 0x01)                  */
#define USB_DCTL_SftDiscon_Pos                (1UL)                     /*!< USB DCTL: SftDiscon (Bit 1)                                 */
#define USB_DCTL_SftDiscon_Msk                (0x2UL)                   /*!< USB DCTL: SftDiscon (Bitfield-Mask: 0x01)                   */
#define USB_DCTL_GNPINNakSts_Pos              (2UL)                     /*!< USB DCTL: GNPINNakSts (Bit 2)                               */
#define USB_DCTL_GNPINNakSts_Msk              (0x4UL)                   /*!< USB DCTL: GNPINNakSts (Bitfield-Mask: 0x01)                 */
#define USB_DCTL_GOUTNakSts_Pos               (3UL)                     /*!< USB DCTL: GOUTNakSts (Bit 3)                                */
#define USB_DCTL_GOUTNakSts_Msk               (0x8UL)                   /*!< USB DCTL: GOUTNakSts (Bitfield-Mask: 0x01)                  */
#define USB_DCTL_SGNPInNak_Pos                (7UL)                     /*!< USB DCTL: SGNPInNak (Bit 7)                                 */
#define USB_DCTL_SGNPInNak_Msk                (0x80UL)                  /*!< USB DCTL: SGNPInNak (Bitfield-Mask: 0x01)                   */
#define USB_DCTL_CGNPInNak_Pos                (8UL)                     /*!< USB DCTL: CGNPInNak (Bit 8)                                 */
#define USB_DCTL_CGNPInNak_Msk                (0x100UL)                 /*!< USB DCTL: CGNPInNak (Bitfield-Mask: 0x01)                   */
#define USB_DCTL_SGOUTNak_Pos                 (9UL)                     /*!< USB DCTL: SGOUTNak (Bit 9)                                  */
#define USB_DCTL_SGOUTNak_Msk                 (0x200UL)                 /*!< USB DCTL: SGOUTNak (Bitfield-Mask: 0x01)                    */
#define USB_DCTL_CGOUTNak_Pos                 (10UL)                    /*!< USB DCTL: CGOUTNak (Bit 10)                                 */
#define USB_DCTL_CGOUTNak_Msk                 (0x400UL)                 /*!< USB DCTL: CGOUTNak (Bitfield-Mask: 0x01)                    */
#define USB_DCTL_GMC_Pos                      (13UL)                    /*!< USB DCTL: GMC (Bit 13)                                      */
#define USB_DCTL_GMC_Msk                      (0x6000UL)                /*!< USB DCTL: GMC (Bitfield-Mask: 0x03)                         */
#define USB_DCTL_IgnrFrmNum_Pos               (15UL)                    /*!< USB DCTL: IgnrFrmNum (Bit 15)                               */
#define USB_DCTL_IgnrFrmNum_Msk               (0x8000UL)                /*!< USB DCTL: IgnrFrmNum (Bitfield-Mask: 0x01)                  */
#define USB_DCTL_NakOnBble_Pos                (16UL)                    /*!< USB DCTL: NakOnBble (Bit 16)                                */
#define USB_DCTL_NakOnBble_Msk                (0x10000UL)               /*!< USB DCTL: NakOnBble (Bitfield-Mask: 0x01)                   */
#define USB_DCTL_EnContOnBNA_Pos              (17UL)                    /*!< USB DCTL: EnContOnBNA (Bit 17)                              */
#define USB_DCTL_EnContOnBNA_Msk              (0x20000UL)               /*!< USB DCTL: EnContOnBNA (Bitfield-Mask: 0x01)                 */

/* ----------------------------------  USB_DSTS  ---------------------------------- */
#define USB_DSTS_SuspSts_Pos                  (0UL)                     /*!< USB DSTS: SuspSts (Bit 0)                                   */
#define USB_DSTS_SuspSts_Msk                  (0x1UL)                   /*!< USB DSTS: SuspSts (Bitfield-Mask: 0x01)                     */
#define USB_DSTS_EnumSpd_Pos                  (1UL)                     /*!< USB DSTS: EnumSpd (Bit 1)                                   */
#define USB_DSTS_EnumSpd_Msk                  (0x6UL)                   /*!< USB DSTS: EnumSpd (Bitfield-Mask: 0x03)                     */
#define USB_DSTS_ErrticErr_Pos                (3UL)                     /*!< USB DSTS: ErrticErr (Bit 3)                                 */
#define USB_DSTS_ErrticErr_Msk                (0x8UL)                   /*!< USB DSTS: ErrticErr (Bitfield-Mask: 0x01)                   */
#define USB_DSTS_SOFFN_Pos                    (8UL)                     /*!< USB DSTS: SOFFN (Bit 8)                                     */
#define USB_DSTS_SOFFN_Msk                    (0x3fff00UL)              /*!< USB DSTS: SOFFN (Bitfield-Mask: 0x3fff)                     */

/* ---------------------------------  USB_DIEPMSK  -------------------------------- */
#define USB_DIEPMSK_XferComplMsk_Pos          (0UL)                     /*!< USB DIEPMSK: XferComplMsk (Bit 0)                           */
#define USB_DIEPMSK_XferComplMsk_Msk          (0x1UL)                   /*!< USB DIEPMSK: XferComplMsk (Bitfield-Mask: 0x01)             */
#define USB_DIEPMSK_EPDisbldMsk_Pos           (1UL)                     /*!< USB DIEPMSK: EPDisbldMsk (Bit 1)                            */
#define USB_DIEPMSK_EPDisbldMsk_Msk           (0x2UL)                   /*!< USB DIEPMSK: EPDisbldMsk (Bitfield-Mask: 0x01)              */
#define USB_DIEPMSK_AHBErrMsk_Pos             (2UL)                     /*!< USB DIEPMSK: AHBErrMsk (Bit 2)                              */
#define USB_DIEPMSK_AHBErrMsk_Msk             (0x4UL)                   /*!< USB DIEPMSK: AHBErrMsk (Bitfield-Mask: 0x01)                */
#define USB_DIEPMSK_TimeOUTMsk_Pos            (3UL)                     /*!< USB DIEPMSK: TimeOUTMsk (Bit 3)                             */
#define USB_DIEPMSK_TimeOUTMsk_Msk            (0x8UL)                   /*!< USB DIEPMSK: TimeOUTMsk (Bitfield-Mask: 0x01)               */
#define USB_DIEPMSK_INTknTXFEmpMsk_Pos        (4UL)                     /*!< USB DIEPMSK: INTknTXFEmpMsk (Bit 4)                         */
#define USB_DIEPMSK_INTknTXFEmpMsk_Msk        (0x10UL)                  /*!< USB DIEPMSK: INTknTXFEmpMsk (Bitfield-Mask: 0x01)           */
#define USB_DIEPMSK_INEPNakEffMsk_Pos         (6UL)                     /*!< USB DIEPMSK: INEPNakEffMsk (Bit 6)                          */
#define USB_DIEPMSK_INEPNakEffMsk_Msk         (0x40UL)                  /*!< USB DIEPMSK: INEPNakEffMsk (Bitfield-Mask: 0x01)            */
#define USB_DIEPMSK_TxfifoUndrnMsk_Pos        (8UL)                     /*!< USB DIEPMSK: TxfifoUndrnMsk (Bit 8)                         */
#define USB_DIEPMSK_TxfifoUndrnMsk_Msk        (0x100UL)                 /*!< USB DIEPMSK: TxfifoUndrnMsk (Bitfield-Mask: 0x01)           */
#define USB_DIEPMSK_BNAInIntrMsk_Pos          (9UL)                     /*!< USB DIEPMSK: BNAInIntrMsk (Bit 9)                           */
#define USB_DIEPMSK_BNAInIntrMsk_Msk          (0x200UL)                 /*!< USB DIEPMSK: BNAInIntrMsk (Bitfield-Mask: 0x01)             */
#define USB_DIEPMSK_NAKMsk_Pos                (13UL)                    /*!< USB DIEPMSK: NAKMsk (Bit 13)                                */
#define USB_DIEPMSK_NAKMsk_Msk                (0x2000UL)                /*!< USB DIEPMSK: NAKMsk (Bitfield-Mask: 0x01)                   */

/* ---------------------------------  USB_DOEPMSK  -------------------------------- */
#define USB_DOEPMSK_XferComplMsk_Pos          (0UL)                     /*!< USB DOEPMSK: XferComplMsk (Bit 0)                           */
#define USB_DOEPMSK_XferComplMsk_Msk          (0x1UL)                   /*!< USB DOEPMSK: XferComplMsk (Bitfield-Mask: 0x01)             */
#define USB_DOEPMSK_EPDisbldMsk_Pos           (1UL)                     /*!< USB DOEPMSK: EPDisbldMsk (Bit 1)                            */
#define USB_DOEPMSK_EPDisbldMsk_Msk           (0x2UL)                   /*!< USB DOEPMSK: EPDisbldMsk (Bitfield-Mask: 0x01)              */
#define USB_DOEPMSK_AHBErrMsk_Pos             (2UL)                     /*!< USB DOEPMSK: AHBErrMsk (Bit 2)                              */
#define USB_DOEPMSK_AHBErrMsk_Msk             (0x4UL)                   /*!< USB DOEPMSK: AHBErrMsk (Bitfield-Mask: 0x01)                */
#define USB_DOEPMSK_SetUPMsk_Pos              (3UL)                     /*!< USB DOEPMSK: SetUPMsk (Bit 3)                               */
#define USB_DOEPMSK_SetUPMsk_Msk              (0x8UL)                   /*!< USB DOEPMSK: SetUPMsk (Bitfield-Mask: 0x01)                 */
#define USB_DOEPMSK_OUTTknEPdisMsk_Pos        (4UL)                     /*!< USB DOEPMSK: OUTTknEPdisMsk (Bit 4)                         */
#define USB_DOEPMSK_OUTTknEPdisMsk_Msk        (0x10UL)                  /*!< USB DOEPMSK: OUTTknEPdisMsk (Bitfield-Mask: 0x01)           */
#define USB_DOEPMSK_Back2BackSETup_Pos        (6UL)                     /*!< USB DOEPMSK: Back2BackSETup (Bit 6)                         */
#define USB_DOEPMSK_Back2BackSETup_Msk        (0x40UL)                  /*!< USB DOEPMSK: Back2BackSETup (Bitfield-Mask: 0x01)           */
#define USB_DOEPMSK_OutPktErrMsk_Pos          (8UL)                     /*!< USB DOEPMSK: OutPktErrMsk (Bit 8)                           */
#define USB_DOEPMSK_OutPktErrMsk_Msk          (0x100UL)                 /*!< USB DOEPMSK: OutPktErrMsk (Bitfield-Mask: 0x01)             */
#define USB_DOEPMSK_BnaOutIntrMsk_Pos         (9UL)                     /*!< USB DOEPMSK: BnaOutIntrMsk (Bit 9)                          */
#define USB_DOEPMSK_BnaOutIntrMsk_Msk         (0x200UL)                 /*!< USB DOEPMSK: BnaOutIntrMsk (Bitfield-Mask: 0x01)            */
#define USB_DOEPMSK_BbleErrMsk_Pos            (12UL)                    /*!< USB DOEPMSK: BbleErrMsk (Bit 12)                            */
#define USB_DOEPMSK_BbleErrMsk_Msk            (0x1000UL)                /*!< USB DOEPMSK: BbleErrMsk (Bitfield-Mask: 0x01)               */
#define USB_DOEPMSK_NAKMsk_Pos                (13UL)                    /*!< USB DOEPMSK: NAKMsk (Bit 13)                                */
#define USB_DOEPMSK_NAKMsk_Msk                (0x2000UL)                /*!< USB DOEPMSK: NAKMsk (Bitfield-Mask: 0x01)                   */
#define USB_DOEPMSK_NYETMsk_Pos               (14UL)                    /*!< USB DOEPMSK: NYETMsk (Bit 14)                               */
#define USB_DOEPMSK_NYETMsk_Msk               (0x4000UL)                /*!< USB DOEPMSK: NYETMsk (Bitfield-Mask: 0x01)                  */

/* ----------------------------------  USB_DAINT  --------------------------------- */
#define USB_DAINT_InEpInt_Pos                 (0UL)                     /*!< USB DAINT: InEpInt (Bit 0)                                  */
#define USB_DAINT_InEpInt_Msk                 (0xffffUL)                /*!< USB DAINT: InEpInt (Bitfield-Mask: 0xffff)                  */
#define USB_DAINT_OutEPInt_Pos                (16UL)                    /*!< USB DAINT: OutEPInt (Bit 16)                                */
#define USB_DAINT_OutEPInt_Msk                (0xffff0000UL)            /*!< USB DAINT: OutEPInt (Bitfield-Mask: 0xffff)                 */

/* --------------------------------  USB_DAINTMSK  -------------------------------- */
#define USB_DAINTMSK_InEpMsk_Pos              (0UL)                     /*!< USB DAINTMSK: InEpMsk (Bit 0)                               */
#define USB_DAINTMSK_InEpMsk_Msk              (0xffffUL)                /*!< USB DAINTMSK: InEpMsk (Bitfield-Mask: 0xffff)               */
#define USB_DAINTMSK_OutEpMsk_Pos             (16UL)                    /*!< USB DAINTMSK: OutEpMsk (Bit 16)                             */
#define USB_DAINTMSK_OutEpMsk_Msk             (0xffff0000UL)            /*!< USB DAINTMSK: OutEpMsk (Bitfield-Mask: 0xffff)              */

/* --------------------------------  USB_DVBUSDIS  -------------------------------- */
#define USB_DVBUSDIS_DVBUSDis_Pos             (0UL)                     /*!< USB DVBUSDIS: DVBUSDis (Bit 0)                              */
#define USB_DVBUSDIS_DVBUSDis_Msk             (0xffffUL)                /*!< USB DVBUSDIS: DVBUSDis (Bitfield-Mask: 0xffff)              */

/* -------------------------------  USB_DVBUSPULSE  ------------------------------- */
#define USB_DVBUSPULSE_DVBUSPulse_Pos         (0UL)                     /*!< USB DVBUSPULSE: DVBUSPulse (Bit 0)                          */
#define USB_DVBUSPULSE_DVBUSPulse_Msk         (0xfffUL)                 /*!< USB DVBUSPULSE: DVBUSPulse (Bitfield-Mask: 0xfff)           */

/* -------------------------------  USB_DIEPEMPMSK  ------------------------------- */
#define USB_DIEPEMPMSK_InEpTxfEmpMsk_Pos      (0UL)                     /*!< USB DIEPEMPMSK: InEpTxfEmpMsk (Bit 0)                       */
#define USB_DIEPEMPMSK_InEpTxfEmpMsk_Msk      (0xffffUL)                /*!< USB DIEPEMPMSK: InEpTxfEmpMsk (Bitfield-Mask: 0xffff)       */

/* ---------------------------------  USB_PCGCCTL  -------------------------------- */
#define USB_PCGCCTL_StopPclk_Pos              (0UL)                     /*!< USB PCGCCTL: StopPclk (Bit 0)                               */
#define USB_PCGCCTL_StopPclk_Msk              (0x1UL)                   /*!< USB PCGCCTL: StopPclk (Bitfield-Mask: 0x01)                 */
#define USB_PCGCCTL_GateHclk_Pos              (1UL)                     /*!< USB PCGCCTL: GateHclk (Bit 1)                               */
#define USB_PCGCCTL_GateHclk_Msk              (0x2UL)                   /*!< USB PCGCCTL: GateHclk (Bitfield-Mask: 0x01)                 */


/* ================================================================================ */
/* ================        struct 'USB0_EP0' Position & Mask       ================ */
/* ================================================================================ */


/* ------------------------------  USB_EP_DIEPCTL0  ----------------------------- */
#define USB_EP_DIEPCTL0_MPS_Pos             (0UL)                     /*!< USB0_EP0 DIEPCTL0: MPS (Bit 0)                              */
#define USB_EP_DIEPCTL0_MPS_Msk             (0x3UL)                   /*!< USB0_EP0 DIEPCTL0: MPS (Bitfield-Mask: 0x03)                */
#define USB_EP_DIEPCTL0_USBActEP_Pos        (15UL)                    /*!< USB0_EP0 DIEPCTL0: USBActEP (Bit 15)                        */
#define USB_EP_DIEPCTL0_USBActEP_Msk        (0x8000UL)                /*!< USB0_EP0 DIEPCTL0: USBActEP (Bitfield-Mask: 0x01)           */
#define USB_EP_DIEPCTL0_NAKSts_Pos          (17UL)                    /*!< USB0_EP0 DIEPCTL0: NAKSts (Bit 17)                          */
#define USB_EP_DIEPCTL0_NAKSts_Msk          (0x20000UL)               /*!< USB0_EP0 DIEPCTL0: NAKSts (Bitfield-Mask: 0x01)             */
#define USB_EP_DIEPCTL0_EPType_Pos          (18UL)                    /*!< USB0_EP0 DIEPCTL0: EPType (Bit 18)                          */
#define USB_EP_DIEPCTL0_EPType_Msk          (0xc0000UL)               /*!< USB0_EP0 DIEPCTL0: EPType (Bitfield-Mask: 0x03)             */
#define USB_EP_DIEPCTL0_Stall_Pos           (21UL)                    /*!< USB0_EP0 DIEPCTL0: Stall (Bit 21)                           */
#define USB_EP_DIEPCTL0_Stall_Msk           (0x200000UL)              /*!< USB0_EP0 DIEPCTL0: Stall (Bitfield-Mask: 0x01)              */
#define USB_EP_DIEPCTL0_TxFNum_Pos          (22UL)                    /*!< USB0_EP0 DIEPCTL0: TxFNum (Bit 22)                          */
#define USB_EP_DIEPCTL0_TxFNum_Msk          (0x3c00000UL)             /*!< USB0_EP0 DIEPCTL0: TxFNum (Bitfield-Mask: 0x0f)             */
#define USB_EP_DIEPCTL0_CNAK_Pos            (26UL)                    /*!< USB0_EP0 DIEPCTL0: CNAK (Bit 26)                            */
#define USB_EP_DIEPCTL0_CNAK_Msk            (0x4000000UL)             /*!< USB0_EP0 DIEPCTL0: CNAK (Bitfield-Mask: 0x01)               */
#define USB_EP_DIEPCTL0_SNAK_Pos            (27UL)                    /*!< USB0_EP0 DIEPCTL0: SNAK (Bit 27)                            */
#define USB_EP_DIEPCTL0_SNAK_Msk            (0x8000000UL)             /*!< USB0_EP0 DIEPCTL0: SNAK (Bitfield-Mask: 0x01)               */
#define USB_EP_DIEPCTL0_EPDis_Pos           (30UL)                    /*!< USB0_EP0 DIEPCTL0: EPDis (Bit 30)                           */
#define USB_EP_DIEPCTL0_EPDis_Msk           (0x40000000UL)            /*!< USB0_EP0 DIEPCTL0: EPDis (Bitfield-Mask: 0x01)              */
#define USB_EP_DIEPCTL0_EPEna_Pos           (31UL)                    /*!< USB0_EP0 DIEPCTL0: EPEna (Bit 31)                           */
#define USB_EP_DIEPCTL0_EPEna_Msk           (0x80000000UL)            /*!< USB0_EP0 DIEPCTL0: EPEna (Bitfield-Mask: 0x01)              */

/* ------------------------------  USB_EP_DIEPINT0  ----------------------------- */
#define USB_EP_DIEPINT0_XferCompl_Pos       (0UL)                     /*!< USB0_EP0 DIEPINT0: XferCompl (Bit 0)                        */
#define USB_EP_DIEPINT0_XferCompl_Msk       (0x1UL)                   /*!< USB0_EP0 DIEPINT0: XferCompl (Bitfield-Mask: 0x01)          */
#define USB_EP_DIEPINT0_EPDisbld_Pos        (1UL)                     /*!< USB0_EP0 DIEPINT0: EPDisbld (Bit 1)                         */
#define USB_EP_DIEPINT0_EPDisbld_Msk        (0x2UL)                   /*!< USB0_EP0 DIEPINT0: EPDisbld (Bitfield-Mask: 0x01)           */
#define USB_EP_DIEPINT0_AHBErr_Pos          (2UL)                     /*!< USB0_EP0 DIEPINT0: AHBErr (Bit 2)                           */
#define USB_EP_DIEPINT0_AHBErr_Msk          (0x4UL)                   /*!< USB0_EP0 DIEPINT0: AHBErr (Bitfield-Mask: 0x01)             */
#define USB_EP_DIEPINT0_TimeOUT_Pos         (3UL)                     /*!< USB0_EP0 DIEPINT0: TimeOUT (Bit 3)                          */
#define USB_EP_DIEPINT0_TimeOUT_Msk         (0x8UL)                   /*!< USB0_EP0 DIEPINT0: TimeOUT (Bitfield-Mask: 0x01)            */
#define USB_EP_DIEPINT0_INTknTXFEmp_Pos     (4UL)                     /*!< USB0_EP0 DIEPINT0: INTknTXFEmp (Bit 4)                      */
#define USB_EP_DIEPINT0_INTknTXFEmp_Msk     (0x10UL)                  /*!< USB0_EP0 DIEPINT0: INTknTXFEmp (Bitfield-Mask: 0x01)        */
#define USB_EP_DIEPINT0_INEPNakEff_Pos      (6UL)                     /*!< USB0_EP0 DIEPINT0: INEPNakEff (Bit 6)                       */
#define USB_EP_DIEPINT0_INEPNakEff_Msk      (0x40UL)                  /*!< USB0_EP0 DIEPINT0: INEPNakEff (Bitfield-Mask: 0x01)         */
#define USB_EP_DIEPINT0_TxFEmp_Pos          (7UL)                     /*!< USB0_EP0 DIEPINT0: TxFEmp (Bit 7)                           */
#define USB_EP_DIEPINT0_TxFEmp_Msk          (0x80UL)                  /*!< USB0_EP0 DIEPINT0: TxFEmp (Bitfield-Mask: 0x01)             */
#define USB_EP_DIEPINT0_BNAIntr_Pos         (9UL)                     /*!< USB0_EP0 DIEPINT0: BNAIntr (Bit 9)                          */
#define USB_EP_DIEPINT0_BNAIntr_Msk         (0x200UL)                 /*!< USB0_EP0 DIEPINT0: BNAIntr (Bitfield-Mask: 0x01)            */

/* -----------------------------  USB_EP_DIEPTSIZ0  ----------------------------- */
#define USB_EP_DIEPTSIZ0_XferSize_Pos       (0UL)                     /*!< USB0_EP0 DIEPTSIZ0: XferSize (Bit 0)                        */
#define USB_EP_DIEPTSIZ0_XferSize_Msk       (0x7fUL)                  /*!< USB0_EP0 DIEPTSIZ0: XferSize (Bitfield-Mask: 0x7f)          */
#define USB_EP_DIEPTSIZ0_PktCnt_Pos         (19UL)                    /*!< USB0_EP0 DIEPTSIZ0: PktCnt (Bit 19)                         */
#define USB_EP_DIEPTSIZ0_PktCnt_Msk         (0x180000UL)              /*!< USB0_EP0 DIEPTSIZ0: PktCnt (Bitfield-Mask: 0x03)            */

/* ------------------------------  USB_EP_DIEPDMA0  ----------------------------- */
#define USB_EP_DIEPDMA0_DMAAddr_Pos         (0UL)                     /*!< USB0_EP0 DIEPDMA0: DMAAddr (Bit 0)                          */
#define USB_EP_DIEPDMA0_DMAAddr_Msk         (0xffffffffUL)            /*!< USB0_EP0 DIEPDMA0: DMAAddr (Bitfield-Mask: 0xffffffff)      */

/* ------------------------------  USB_EP_DTXFSTS0  ----------------------------- */
#define USB_EP_DTXFSTS0_INEPTxFSpcAvail_Pos (0UL)                     /*!< USB0_EP0 DTXFSTS0: INEPTxFSpcAvail (Bit 0)                  */
#define USB_EP_DTXFSTS0_INEPTxFSpcAvail_Msk (0xffffUL)                /*!< USB0_EP0 DTXFSTS0: INEPTxFSpcAvail (Bitfield-Mask: 0xffff)  */

/* -----------------------------  USB_EP_DIEPDMAB0  ----------------------------- */
#define USB_EP_DIEPDMAB0_DMABufferAddr_Pos  (0UL)                     /*!< USB0_EP0 DIEPDMAB0: DMABufferAddr (Bit 0)                   */
#define USB_EP_DIEPDMAB0_DMABufferAddr_Msk  (0xffffffffUL)            /*!< USB0_EP0 DIEPDMAB0: DMABufferAddr (Bitfield-Mask: 0xffffffff) */

/* ------------------------------  USB_EP_DOEPCTL0  ----------------------------- */
#define USB_EP_DOEPCTL0_MPS_Pos             (0UL)                     /*!< USB0_EP0 DOEPCTL0: MPS (Bit 0)                              */
#define USB_EP_DOEPCTL0_MPS_Msk             (0x3UL)                   /*!< USB0_EP0 DOEPCTL0: MPS (Bitfield-Mask: 0x03)                */
#define USB_EP_DOEPCTL0_USBActEP_Pos        (15UL)                    /*!< USB0_EP0 DOEPCTL0: USBActEP (Bit 15)                        */
#define USB_EP_DOEPCTL0_USBActEP_Msk        (0x8000UL)                /*!< USB0_EP0 DOEPCTL0: USBActEP (Bitfield-Mask: 0x01)           */
#define USB_EP_DOEPCTL0_NAKSts_Pos          (17UL)                    /*!< USB0_EP0 DOEPCTL0: NAKSts (Bit 17)                          */
#define USB_EP_DOEPCTL0_NAKSts_Msk          (0x20000UL)               /*!< USB0_EP0 DOEPCTL0: NAKSts (Bitfield-Mask: 0x01)             */
#define USB_EP_DOEPCTL0_EPType_Pos          (18UL)                    /*!< USB0_EP0 DOEPCTL0: EPType (Bit 18)                          */
#define USB_EP_DOEPCTL0_EPType_Msk          (0xc0000UL)               /*!< USB0_EP0 DOEPCTL0: EPType (Bitfield-Mask: 0x03)             */
#define USB_EP_DOEPCTL0_Snp_Pos             (20UL)                    /*!< USB0_EP0 DOEPCTL0: Snp (Bit 20)                             */
#define USB_EP_DOEPCTL0_Snp_Msk             (0x100000UL)              /*!< USB0_EP0 DOEPCTL0: Snp (Bitfield-Mask: 0x01)                */
#define USB_EP_DOEPCTL0_Stall_Pos           (21UL)                    /*!< USB0_EP0 DOEPCTL0: Stall (Bit 21)                           */
#define USB_EP_DOEPCTL0_Stall_Msk           (0x200000UL)              /*!< USB0_EP0 DOEPCTL0: Stall (Bitfield-Mask: 0x01)              */
#define USB_EP_DOEPCTL0_CNAK_Pos            (26UL)                    /*!< USB0_EP0 DOEPCTL0: CNAK (Bit 26)                            */
#define USB_EP_DOEPCTL0_CNAK_Msk            (0x4000000UL)             /*!< USB0_EP0 DOEPCTL0: CNAK (Bitfield-Mask: 0x01)               */
#define USB_EP_DOEPCTL0_SNAK_Pos            (27UL)                    /*!< USB0_EP0 DOEPCTL0: SNAK (Bit 27)                            */
#define USB_EP_DOEPCTL0_SNAK_Msk            (0x8000000UL)             /*!< USB0_EP0 DOEPCTL0: SNAK (Bitfield-Mask: 0x01)               */
#define USB_EP_DOEPCTL0_EPDis_Pos           (30UL)                    /*!< USB0_EP0 DOEPCTL0: EPDis (Bit 30)                           */
#define USB_EP_DOEPCTL0_EPDis_Msk           (0x40000000UL)            /*!< USB0_EP0 DOEPCTL0: EPDis (Bitfield-Mask: 0x01)              */
#define USB_EP_DOEPCTL0_EPEna_Pos           (31UL)                    /*!< USB0_EP0 DOEPCTL0: EPEna (Bit 31)                           */
#define USB_EP_DOEPCTL0_EPEna_Msk           (0x80000000UL)            /*!< USB0_EP0 DOEPCTL0: EPEna (Bitfield-Mask: 0x01)              */

/* ------------------------------  USB_EP_DOEPINT0  ----------------------------- */
#define USB_EP_DOEPINT0_XferCompl_Pos       (0UL)                     /*!< USB0_EP0 DOEPINT0: XferCompl (Bit 0)                        */
#define USB_EP_DOEPINT0_XferCompl_Msk       (0x1UL)                   /*!< USB0_EP0 DOEPINT0: XferCompl (Bitfield-Mask: 0x01)          */
#define USB_EP_DOEPINT0_EPDisbld_Pos        (1UL)                     /*!< USB0_EP0 DOEPINT0: EPDisbld (Bit 1)                         */
#define USB_EP_DOEPINT0_EPDisbld_Msk        (0x2UL)                   /*!< USB0_EP0 DOEPINT0: EPDisbld (Bitfield-Mask: 0x01)           */
#define USB_EP_DOEPINT0_AHBErr_Pos          (2UL)                     /*!< USB0_EP0 DOEPINT0: AHBErr (Bit 2)                           */
#define USB_EP_DOEPINT0_AHBErr_Msk          (0x4UL)                   /*!< USB0_EP0 DOEPINT0: AHBErr (Bitfield-Mask: 0x01)             */
#define USB_EP_DOEPINT0_SetUp_Pos           (3UL)                     /*!< USB0_EP0 DOEPINT0: SetUp (Bit 3)                            */
#define USB_EP_DOEPINT0_SetUp_Msk           (0x8UL)                   /*!< USB0_EP0 DOEPINT0: SetUp (Bitfield-Mask: 0x01)              */
#define USB_EP_DOEPINT0_OUTTknEPdis_Pos     (4UL)                     /*!< USB0_EP0 DOEPINT0: OUTTknEPdis (Bit 4)                      */
#define USB_EP_DOEPINT0_OUTTknEPdis_Msk     (0x10UL)                  /*!< USB0_EP0 DOEPINT0: OUTTknEPdis (Bitfield-Mask: 0x01)        */
#define USB_EP_DOEPINT0_StsPhseRcvd_Pos     (5UL)                     /*!< USB0_EP0 DOEPINT0: StsPhseRcvd (Bit 5)                      */
#define USB_EP_DOEPINT0_StsPhseRcvd_Msk     (0x20UL)                  /*!< USB0_EP0 DOEPINT0: StsPhseRcvd (Bitfield-Mask: 0x01)        */
#define USB_EP_DOEPINT0_Back2BackSETup_Pos  (6UL)                     /*!< USB0_EP0 DOEPINT0: Back2BackSETup (Bit 6)                   */
#define USB_EP_DOEPINT0_Back2BackSETup_Msk  (0x40UL)                  /*!< USB0_EP0 DOEPINT0: Back2BackSETup (Bitfield-Mask: 0x01)     */
#define USB_EP_DOEPINT0_BNAIntr_Pos         (9UL)                     /*!< USB0_EP0 DOEPINT0: BNAIntr (Bit 9)                          */
#define USB_EP_DOEPINT0_BNAIntr_Msk         (0x200UL)                 /*!< USB0_EP0 DOEPINT0: BNAIntr (Bitfield-Mask: 0x01)            */
#define USB_EP_DOEPINT0_PktDrpSts_Pos       (11UL)                    /*!< USB0_EP0 DOEPINT0: PktDrpSts (Bit 11)                       */
#define USB_EP_DOEPINT0_PktDrpSts_Msk       (0x800UL)                 /*!< USB0_EP0 DOEPINT0: PktDrpSts (Bitfield-Mask: 0x01)          */
#define USB_EP_DOEPINT0_BbleErrIntrpt_Pos   (12UL)                    /*!< USB0_EP0 DOEPINT0: BbleErrIntrpt (Bit 12)                   */
#define USB_EP_DOEPINT0_BbleErrIntrpt_Msk   (0x1000UL)                /*!< USB0_EP0 DOEPINT0: BbleErrIntrpt (Bitfield-Mask: 0x01)      */
#define USB_EP_DOEPINT0_NAKIntrpt_Pos       (13UL)                    /*!< USB0_EP0 DOEPINT0: NAKIntrpt (Bit 13)                       */
#define USB_EP_DOEPINT0_NAKIntrpt_Msk       (0x2000UL)                /*!< USB0_EP0 DOEPINT0: NAKIntrpt (Bitfield-Mask: 0x01)          */
#define USB_EP_DOEPINT0_NYETIntrpt_Pos      (14UL)                    /*!< USB0_EP0 DOEPINT0: NYETIntrpt (Bit 14)                      */
#define USB_EP_DOEPINT0_NYETIntrpt_Msk      (0x4000UL)                /*!< USB0_EP0 DOEPINT0: NYETIntrpt (Bitfield-Mask: 0x01)         */

/* -----------------------------  USB_EP_DOEPTSIZ0  ----------------------------- */
#define USB_EP_DOEPTSIZ0_XferSize_Pos       (0UL)                     /*!< USB0_EP0 DOEPTSIZ0: XferSize (Bit 0)                        */
#define USB_EP_DOEPTSIZ0_XferSize_Msk       (0x7fUL)                  /*!< USB0_EP0 DOEPTSIZ0: XferSize (Bitfield-Mask: 0x7f)          */
#define USB_EP_DOEPTSIZ0_PktCnt_Pos         (19UL)                    /*!< USB0_EP0 DOEPTSIZ0: PktCnt (Bit 19)                         */
#define USB_EP_DOEPTSIZ0_PktCnt_Msk         (0x180000UL)              /*!< USB0_EP0 DOEPTSIZ0: PktCnt (Bitfield-Mask: 0x03)            */
#define USB_EP_DOEPTSIZ0_SUPCnt_Pos         (29UL)                    /*!< USB0_EP0 DOEPTSIZ0: SUPCnt (Bit 29)                         */
#define USB_EP_DOEPTSIZ0_SUPCnt_Msk         (0x60000000UL)            /*!< USB0_EP0 DOEPTSIZ0: SUPCnt (Bitfield-Mask: 0x03)            */

/* ------------------------------  USB_EP_DOEPDMA0  ----------------------------- */
#define USB_EP_DOEPDMA0_DMAAddr_Pos         (0UL)                     /*!< USB0_EP0 DOEPDMA0: DMAAddr (Bit 0)                          */
#define USB_EP_DOEPDMA0_DMAAddr_Msk         (0xffffffffUL)            /*!< USB0_EP0 DOEPDMA0: DMAAddr (Bitfield-Mask: 0xffffffff)      */

/* -----------------------------  USB_EP_DOEPDMAB0  ----------------------------- */
#define USB_EP_DOEPDMAB0_DMABufferAddr_Pos  (0UL)                     /*!< USB0_EP0 DOEPDMAB0: DMABufferAddr (Bit 0)                   */
#define USB_EP_DOEPDMAB0_DMABufferAddr_Msk  (0xffffffffUL)            /*!< USB0_EP0 DOEPDMAB0: DMABufferAddr (Bitfield-Mask: 0xffffffff) */


/* ================================================================================ */
/* ================         Group 'USB_EP' Position & Mask         ================ */
/* ================================================================================ */


/* ---------------------------  USB_EP_DIEPCTL_ISOCONT  --------------------------- */
#define USB_EP_DIEPCTL_ISOCONT_MPS_Pos        (0UL)                     /*!< USB_EP DIEPCTL_ISOCONT: MPS (Bit 0)                         */
#define USB_EP_DIEPCTL_ISOCONT_MPS_Msk        (0x7ffUL)                 /*!< USB_EP DIEPCTL_ISOCONT: MPS (Bitfield-Mask: 0x7ff)          */
#define USB_EP_DIEPCTL_ISOCONT_USBActEP_Pos   (15UL)                    /*!< USB_EP DIEPCTL_ISOCONT: USBActEP (Bit 15)                   */
#define USB_EP_DIEPCTL_ISOCONT_USBActEP_Msk   (0x8000UL)                /*!< USB_EP DIEPCTL_ISOCONT: USBActEP (Bitfield-Mask: 0x01)      */
#define USB_EP_DIEPCTL_ISOCONT_EO_FrNum_Pos   (16UL)                    /*!< USB_EP DIEPCTL_ISOCONT: EO_FrNum (Bit 16)                   */
#define USB_EP_DIEPCTL_ISOCONT_EO_FrNum_Msk   (0x10000UL)               /*!< USB_EP DIEPCTL_ISOCONT: EO_FrNum (Bitfield-Mask: 0x01)      */
#define USB_EP_DIEPCTL_ISOCONT_NAKSts_Pos     (17UL)                    /*!< USB_EP DIEPCTL_ISOCONT: NAKSts (Bit 17)                     */
#define USB_EP_DIEPCTL_ISOCONT_NAKSts_Msk     (0x20000UL)               /*!< USB_EP DIEPCTL_ISOCONT: NAKSts (Bitfield-Mask: 0x01)        */
#define USB_EP_DIEPCTL_ISOCONT_EPType_Pos     (18UL)                    /*!< USB_EP DIEPCTL_ISOCONT: EPType (Bit 18)                     */
#define USB_EP_DIEPCTL_ISOCONT_EPType_Msk     (0xc0000UL)               /*!< USB_EP DIEPCTL_ISOCONT: EPType (Bitfield-Mask: 0x03)        */
#define USB_EP_DIEPCTL_ISOCONT_Snp_Pos        (20UL)                    /*!< USB_EP DIEPCTL_ISOCONT: Snp (Bit 20)                        */
#define USB_EP_DIEPCTL_ISOCONT_Snp_Msk        (0x100000UL)              /*!< USB_EP DIEPCTL_ISOCONT: Snp (Bitfield-Mask: 0x01)           */
#define USB_EP_DIEPCTL_ISOCONT_Stall_Pos      (21UL)                    /*!< USB_EP DIEPCTL_ISOCONT: Stall (Bit 21)                      */
#define USB_EP_DIEPCTL_ISOCONT_Stall_Msk      (0x200000UL)              /*!< USB_EP DIEPCTL_ISOCONT: Stall (Bitfield-Mask: 0x01)         */
#define USB_EP_DIEPCTL_ISOCONT_TxFNum_Pos     (22UL)                    /*!< USB_EP DIEPCTL_ISOCONT: TxFNum (Bit 22)                     */
#define USB_EP_DIEPCTL_ISOCONT_TxFNum_Msk     (0x3c00000UL)             /*!< USB_EP DIEPCTL_ISOCONT: TxFNum (Bitfield-Mask: 0x0f)        */
#define USB_EP_DIEPCTL_ISOCONT_CNAK_Pos       (26UL)                    /*!< USB_EP DIEPCTL_ISOCONT: CNAK (Bit 26)                       */
#define USB_EP_DIEPCTL_ISOCONT_CNAK_Msk       (0x4000000UL)             /*!< USB_EP DIEPCTL_ISOCONT: CNAK (Bitfield-Mask: 0x01)          */
#define USB_EP_DIEPCTL_ISOCONT_SNAK_Pos       (27UL)                    /*!< USB_EP DIEPCTL_ISOCONT: SNAK (Bit 27)                       */
#define USB_EP_DIEPCTL_ISOCONT_SNAK_Msk       (0x8000000UL)             /*!< USB_EP DIEPCTL_ISOCONT: SNAK (Bitfield-Mask: 0x01)          */
#define USB_EP_DIEPCTL_ISOCONT_SetEvenFr_Pos  (28UL)                    /*!< USB_EP DIEPCTL_ISOCONT: SetEvenFr (Bit 28)                  */
#define USB_EP_DIEPCTL_ISOCONT_SetEvenFr_Msk  (0x10000000UL)            /*!< USB_EP DIEPCTL_ISOCONT: SetEvenFr (Bitfield-Mask: 0x01)     */
#define USB_EP_DIEPCTL_ISOCONT_SetOddFr_Pos   (29UL)                    /*!< USB_EP DIEPCTL_ISOCONT: SetOddFr (Bit 29)                   */
#define USB_EP_DIEPCTL_ISOCONT_SetOddFr_Msk   (0x20000000UL)            /*!< USB_EP DIEPCTL_ISOCONT: SetOddFr (Bitfield-Mask: 0x01)      */
#define USB_EP_DIEPCTL_ISOCONT_EPDis_Pos      (30UL)                    /*!< USB_EP DIEPCTL_ISOCONT: EPDis (Bit 30)                      */
#define USB_EP_DIEPCTL_ISOCONT_EPDis_Msk      (0x40000000UL)            /*!< USB_EP DIEPCTL_ISOCONT: EPDis (Bitfield-Mask: 0x01)         */
#define USB_EP_DIEPCTL_ISOCONT_EPEna_Pos      (31UL)                    /*!< USB_EP DIEPCTL_ISOCONT: EPEna (Bit 31)                      */
#define USB_EP_DIEPCTL_ISOCONT_EPEna_Msk      (0x80000000UL)            /*!< USB_EP DIEPCTL_ISOCONT: EPEna (Bitfield-Mask: 0x01)         */

/* ---------------------------  USB_EP_DIEPCTL_INTBULK  --------------------------- */
#define USB_EP_DIEPCTL_INTBULK_MPS_Pos        (0UL)                     /*!< USB_EP DIEPCTL_INTBULK: MPS (Bit 0)                         */
#define USB_EP_DIEPCTL_INTBULK_MPS_Msk        (0x7ffUL)                 /*!< USB_EP DIEPCTL_INTBULK: MPS (Bitfield-Mask: 0x7ff)          */
#define USB_EP_DIEPCTL_INTBULK_USBActEP_Pos   (15UL)                    /*!< USB_EP DIEPCTL_INTBULK: USBActEP (Bit 15)                   */
#define USB_EP_DIEPCTL_INTBULK_USBActEP_Msk   (0x8000UL)                /*!< USB_EP DIEPCTL_INTBULK: USBActEP (Bitfield-Mask: 0x01)      */
#define USB_EP_DIEPCTL_INTBULK_DPID_Pos       (16UL)                    /*!< USB_EP DIEPCTL_INTBULK: DPID (Bit 16)                       */
#define USB_EP_DIEPCTL_INTBULK_DPID_Msk       (0x10000UL)               /*!< USB_EP DIEPCTL_INTBULK: DPID (Bitfield-Mask: 0x01)          */
#define USB_EP_DIEPCTL_INTBULK_NAKSts_Pos     (17UL)                    /*!< USB_EP DIEPCTL_INTBULK: NAKSts (Bit 17)                     */
#define USB_EP_DIEPCTL_INTBULK_NAKSts_Msk     (0x20000UL)               /*!< USB_EP DIEPCTL_INTBULK: NAKSts (Bitfield-Mask: 0x01)        */
#define USB_EP_DIEPCTL_INTBULK_EPType_Pos     (18UL)                    /*!< USB_EP DIEPCTL_INTBULK: EPType (Bit 18)                     */
#define USB_EP_DIEPCTL_INTBULK_EPType_Msk     (0xc0000UL)               /*!< USB_EP DIEPCTL_INTBULK: EPType (Bitfield-Mask: 0x03)        */
#define USB_EP_DIEPCTL_INTBULK_Snp_Pos        (20UL)                    /*!< USB_EP DIEPCTL_INTBULK: Snp (Bit 20)                        */
#define USB_EP_DIEPCTL_INTBULK_Snp_Msk        (0x100000UL)              /*!< USB_EP DIEPCTL_INTBULK: Snp (Bitfield-Mask: 0x01)           */
#define USB_EP_DIEPCTL_INTBULK_Stall_Pos      (21UL)                    /*!< USB_EP DIEPCTL_INTBULK: Stall (Bit 21)                      */
#define USB_EP_DIEPCTL_INTBULK_Stall_Msk      (0x200000UL)              /*!< USB_EP DIEPCTL_INTBULK: Stall (Bitfield-Mask: 0x01)         */
#define USB_EP_DIEPCTL_INTBULK_TxFNum_Pos     (22UL)                    /*!< USB_EP DIEPCTL_INTBULK: TxFNum (Bit 22)                     */
#define USB_EP_DIEPCTL_INTBULK_TxFNum_Msk     (0x3c00000UL)             /*!< USB_EP DIEPCTL_INTBULK: TxFNum (Bitfield-Mask: 0x0f)        */
#define USB_EP_DIEPCTL_INTBULK_CNAK_Pos       (26UL)                    /*!< USB_EP DIEPCTL_INTBULK: CNAK (Bit 26)                       */
#define USB_EP_DIEPCTL_INTBULK_CNAK_Msk       (0x4000000UL)             /*!< USB_EP DIEPCTL_INTBULK: CNAK (Bitfield-Mask: 0x01)          */
#define USB_EP_DIEPCTL_INTBULK_SNAK_Pos       (27UL)                    /*!< USB_EP DIEPCTL_INTBULK: SNAK (Bit 27)                       */
#define USB_EP_DIEPCTL_INTBULK_SNAK_Msk       (0x8000000UL)             /*!< USB_EP DIEPCTL_INTBULK: SNAK (Bitfield-Mask: 0x01)          */
#define USB_EP_DIEPCTL_INTBULK_SetD0PID_Pos   (28UL)                    /*!< USB_EP DIEPCTL_INTBULK: SetD0PID (Bit 28)                   */
#define USB_EP_DIEPCTL_INTBULK_SetD0PID_Msk   (0x10000000UL)            /*!< USB_EP DIEPCTL_INTBULK: SetD0PID (Bitfield-Mask: 0x01)      */
#define USB_EP_DIEPCTL_INTBULK_SetD1PID_Pos   (29UL)                    /*!< USB_EP DIEPCTL_INTBULK: SetD1PID (Bit 29)                   */
#define USB_EP_DIEPCTL_INTBULK_SetD1PID_Msk   (0x20000000UL)            /*!< USB_EP DIEPCTL_INTBULK: SetD1PID (Bitfield-Mask: 0x01)      */
#define USB_EP_DIEPCTL_INTBULK_EPDis_Pos      (30UL)                    /*!< USB_EP DIEPCTL_INTBULK: EPDis (Bit 30)                      */
#define USB_EP_DIEPCTL_INTBULK_EPDis_Msk      (0x40000000UL)            /*!< USB_EP DIEPCTL_INTBULK: EPDis (Bitfield-Mask: 0x01)         */
#define USB_EP_DIEPCTL_INTBULK_EPEna_Pos      (31UL)                    /*!< USB_EP DIEPCTL_INTBULK: EPEna (Bit 31)                      */
#define USB_EP_DIEPCTL_INTBULK_EPEna_Msk      (0x80000000UL)            /*!< USB_EP DIEPCTL_INTBULK: EPEna (Bitfield-Mask: 0x01)         */

/* -------------------------------  USB_EP_DIEPINT  ------------------------------- */
#define USB_EP_DIEPINT_XferCompl_Pos          (0UL)                     /*!< USB_EP DIEPINT: XferCompl (Bit 0)                           */
#define USB_EP_DIEPINT_XferCompl_Msk          (0x1UL)                   /*!< USB_EP DIEPINT: XferCompl (Bitfield-Mask: 0x01)             */
#define USB_EP_DIEPINT_EPDisbld_Pos           (1UL)                     /*!< USB_EP DIEPINT: EPDisbld (Bit 1)                            */
#define USB_EP_DIEPINT_EPDisbld_Msk           (0x2UL)                   /*!< USB_EP DIEPINT: EPDisbld (Bitfield-Mask: 0x01)              */
#define USB_EP_DIEPINT_AHBErr_Pos             (2UL)                     /*!< USB_EP DIEPINT: AHBErr (Bit 2)                              */
#define USB_EP_DIEPINT_AHBErr_Msk             (0x4UL)                   /*!< USB_EP DIEPINT: AHBErr (Bitfield-Mask: 0x01)                */
#define USB_EP_DIEPINT_TimeOUT_Pos            (3UL)                     /*!< USB_EP DIEPINT: TimeOUT (Bit 3)                             */
#define USB_EP_DIEPINT_TimeOUT_Msk            (0x8UL)                   /*!< USB_EP DIEPINT: TimeOUT (Bitfield-Mask: 0x01)               */
#define USB_EP_DIEPINT_INTknTXFEmp_Pos        (4UL)                     /*!< USB_EP DIEPINT: INTknTXFEmp (Bit 4)                         */
#define USB_EP_DIEPINT_INTknTXFEmp_Msk        (0x10UL)                  /*!< USB_EP DIEPINT: INTknTXFEmp (Bitfield-Mask: 0x01)           */
#define USB_EP_DIEPINT_INEPNakEff_Pos         (6UL)                     /*!< USB_EP DIEPINT: INEPNakEff (Bit 6)                          */
#define USB_EP_DIEPINT_INEPNakEff_Msk         (0x40UL)                  /*!< USB_EP DIEPINT: INEPNakEff (Bitfield-Mask: 0x01)            */
#define USB_EP_DIEPINT_TxFEmp_Pos             (7UL)                     /*!< USB_EP DIEPINT: TxFEmp (Bit 7)                              */
#define USB_EP_DIEPINT_TxFEmp_Msk             (0x80UL)                  /*!< USB_EP DIEPINT: TxFEmp (Bitfield-Mask: 0x01)                */
#define USB_EP_DIEPINT_BNAIntr_Pos            (9UL)                     /*!< USB_EP DIEPINT: BNAIntr (Bit 9)                             */
#define USB_EP_DIEPINT_BNAIntr_Msk            (0x200UL)                 /*!< USB_EP DIEPINT: BNAIntr (Bitfield-Mask: 0x01)               */

/* -------------------------------  USB_EP_DIEPTSIZ  ------------------------------ */
#define USB_EP_DIEPTSIZ_XferSize_Pos          (0UL)                     /*!< USB_EP DIEPTSIZ: XferSize (Bit 0)                           */
#define USB_EP_DIEPTSIZ_XferSize_Msk          (0x7ffffUL)               /*!< USB_EP DIEPTSIZ: XferSize (Bitfield-Mask: 0x7ffff)          */
#define USB_EP_DIEPTSIZ_PktCnt_Pos            (19UL)                    /*!< USB_EP DIEPTSIZ: PktCnt (Bit 19)                            */
#define USB_EP_DIEPTSIZ_PktCnt_Msk            (0x1ff80000UL)            /*!< USB_EP DIEPTSIZ: PktCnt (Bitfield-Mask: 0x3ff)              */

/* -------------------------------  USB_EP_DIEPDMA  ------------------------------- */
#define USB_EP_DIEPDMA_DMAAddr_Pos            (0UL)                     /*!< USB_EP DIEPDMA: DMAAddr (Bit 0)                             */
#define USB_EP_DIEPDMA_DMAAddr_Msk            (0xffffffffUL)            /*!< USB_EP DIEPDMA: DMAAddr (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  USB_EP_DTXFSTS  ------------------------------- */
#define USB_EP_DTXFSTS_INEPTxFSpcAvail_Pos    (0UL)                     /*!< USB_EP DTXFSTS: INEPTxFSpcAvail (Bit 0)                     */
#define USB_EP_DTXFSTS_INEPTxFSpcAvail_Msk    (0xffffUL)                /*!< USB_EP DTXFSTS: INEPTxFSpcAvail (Bitfield-Mask: 0xffff)     */

/* -------------------------------  USB_EP_DIEPDMAB  ------------------------------ */
#define USB_EP_DIEPDMAB_DMABufferAddr_Pos     (0UL)                     /*!< USB_EP DIEPDMAB: DMABufferAddr (Bit 0)                      */
#define USB_EP_DIEPDMAB_DMABufferAddr_Msk     (0xffffffffUL)            /*!< USB_EP DIEPDMAB: DMABufferAddr (Bitfield-Mask: 0xffffffff)  */

/* ---------------------------  USB_EP_DOEPCTL_ISOCONT  --------------------------- */
#define USB_EP_DOEPCTL_ISOCONT_MPS_Pos        (0UL)                     /*!< USB_EP DOEPCTL_ISOCONT: MPS (Bit 0)                         */
#define USB_EP_DOEPCTL_ISOCONT_MPS_Msk        (0x7ffUL)                 /*!< USB_EP DOEPCTL_ISOCONT: MPS (Bitfield-Mask: 0x7ff)          */
#define USB_EP_DOEPCTL_ISOCONT_USBActEP_Pos   (15UL)                    /*!< USB_EP DOEPCTL_ISOCONT: USBActEP (Bit 15)                   */
#define USB_EP_DOEPCTL_ISOCONT_USBActEP_Msk   (0x8000UL)                /*!< USB_EP DOEPCTL_ISOCONT: USBActEP (Bitfield-Mask: 0x01)      */
#define USB_EP_DOEPCTL_ISOCONT_EO_FrNum_Pos   (16UL)                    /*!< USB_EP DOEPCTL_ISOCONT: EO_FrNum (Bit 16)                   */
#define USB_EP_DOEPCTL_ISOCONT_EO_FrNum_Msk   (0x10000UL)               /*!< USB_EP DOEPCTL_ISOCONT: EO_FrNum (Bitfield-Mask: 0x01)      */
#define USB_EP_DOEPCTL_ISOCONT_NAKSts_Pos     (17UL)                    /*!< USB_EP DOEPCTL_ISOCONT: NAKSts (Bit 17)                     */
#define USB_EP_DOEPCTL_ISOCONT_NAKSts_Msk     (0x20000UL)               /*!< USB_EP DOEPCTL_ISOCONT: NAKSts (Bitfield-Mask: 0x01)        */
#define USB_EP_DOEPCTL_ISOCONT_EPType_Pos     (18UL)                    /*!< USB_EP DOEPCTL_ISOCONT: EPType (Bit 18)                     */
#define USB_EP_DOEPCTL_ISOCONT_EPType_Msk     (0xc0000UL)               /*!< USB_EP DOEPCTL_ISOCONT: EPType (Bitfield-Mask: 0x03)        */
#define USB_EP_DOEPCTL_ISOCONT_Snp_Pos        (20UL)                    /*!< USB_EP DOEPCTL_ISOCONT: Snp (Bit 20)                        */
#define USB_EP_DOEPCTL_ISOCONT_Snp_Msk        (0x100000UL)              /*!< USB_EP DOEPCTL_ISOCONT: Snp (Bitfield-Mask: 0x01)           */
#define USB_EP_DOEPCTL_ISOCONT_Stall_Pos      (21UL)                    /*!< USB_EP DOEPCTL_ISOCONT: Stall (Bit 21)                      */
#define USB_EP_DOEPCTL_ISOCONT_Stall_Msk      (0x200000UL)              /*!< USB_EP DOEPCTL_ISOCONT: Stall (Bitfield-Mask: 0x01)         */
#define USB_EP_DOEPCTL_ISOCONT_TxFNum_Pos     (22UL)                    /*!< USB_EP DOEPCTL_ISOCONT: TxFNum (Bit 22)                     */
#define USB_EP_DOEPCTL_ISOCONT_TxFNum_Msk     (0x3c00000UL)             /*!< USB_EP DOEPCTL_ISOCONT: TxFNum (Bitfield-Mask: 0x0f)        */
#define USB_EP_DOEPCTL_ISOCONT_CNAK_Pos       (26UL)                    /*!< USB_EP DOEPCTL_ISOCONT: CNAK (Bit 26)                       */
#define USB_EP_DOEPCTL_ISOCONT_CNAK_Msk       (0x4000000UL)             /*!< USB_EP DOEPCTL_ISOCONT: CNAK (Bitfield-Mask: 0x01)          */
#define USB_EP_DOEPCTL_ISOCONT_SNAK_Pos       (27UL)                    /*!< USB_EP DOEPCTL_ISOCONT: SNAK (Bit 27)                       */
#define USB_EP_DOEPCTL_ISOCONT_SNAK_Msk       (0x8000000UL)             /*!< USB_EP DOEPCTL_ISOCONT: SNAK (Bitfield-Mask: 0x01)          */
#define USB_EP_DOEPCTL_ISOCONT_SetEvenFr_Pos  (28UL)                    /*!< USB_EP DOEPCTL_ISOCONT: SetEvenFr (Bit 28)                  */
#define USB_EP_DOEPCTL_ISOCONT_SetEvenFr_Msk  (0x10000000UL)            /*!< USB_EP DOEPCTL_ISOCONT: SetEvenFr (Bitfield-Mask: 0x01)     */
#define USB_EP_DOEPCTL_ISOCONT_SetOddFr_Pos   (29UL)                    /*!< USB_EP DOEPCTL_ISOCONT: SetOddFr (Bit 29)                   */
#define USB_EP_DOEPCTL_ISOCONT_SetOddFr_Msk   (0x20000000UL)            /*!< USB_EP DOEPCTL_ISOCONT: SetOddFr (Bitfield-Mask: 0x01)      */
#define USB_EP_DOEPCTL_ISOCONT_EPDis_Pos      (30UL)                    /*!< USB_EP DOEPCTL_ISOCONT: EPDis (Bit 30)                      */
#define USB_EP_DOEPCTL_ISOCONT_EPDis_Msk      (0x40000000UL)            /*!< USB_EP DOEPCTL_ISOCONT: EPDis (Bitfield-Mask: 0x01)         */
#define USB_EP_DOEPCTL_ISOCONT_EPEna_Pos      (31UL)                    /*!< USB_EP DOEPCTL_ISOCONT: EPEna (Bit 31)                      */
#define USB_EP_DOEPCTL_ISOCONT_EPEna_Msk      (0x80000000UL)            /*!< USB_EP DOEPCTL_ISOCONT: EPEna (Bitfield-Mask: 0x01)         */

/* ---------------------------  USB_EP_DOEPCTL_INTBULK  --------------------------- */
#define USB_EP_DOEPCTL_INTBULK_MPS_Pos        (0UL)                     /*!< USB_EP DOEPCTL_INTBULK: MPS (Bit 0)                         */
#define USB_EP_DOEPCTL_INTBULK_MPS_Msk        (0x7ffUL)                 /*!< USB_EP DOEPCTL_INTBULK: MPS (Bitfield-Mask: 0x7ff)          */
#define USB_EP_DOEPCTL_INTBULK_USBActEP_Pos   (15UL)                    /*!< USB_EP DOEPCTL_INTBULK: USBActEP (Bit 15)                   */
#define USB_EP_DOEPCTL_INTBULK_USBActEP_Msk   (0x8000UL)                /*!< USB_EP DOEPCTL_INTBULK: USBActEP (Bitfield-Mask: 0x01)      */
#define USB_EP_DOEPCTL_INTBULK_DPID_Pos       (16UL)                    /*!< USB_EP DOEPCTL_INTBULK: DPID (Bit 16)                       */
#define USB_EP_DOEPCTL_INTBULK_DPID_Msk       (0x10000UL)               /*!< USB_EP DOEPCTL_INTBULK: DPID (Bitfield-Mask: 0x01)          */
#define USB_EP_DOEPCTL_INTBULK_NAKSts_Pos     (17UL)                    /*!< USB_EP DOEPCTL_INTBULK: NAKSts (Bit 17)                     */
#define USB_EP_DOEPCTL_INTBULK_NAKSts_Msk     (0x20000UL)               /*!< USB_EP DOEPCTL_INTBULK: NAKSts (Bitfield-Mask: 0x01)        */
#define USB_EP_DOEPCTL_INTBULK_EPType_Pos     (18UL)                    /*!< USB_EP DOEPCTL_INTBULK: EPType (Bit 18)                     */
#define USB_EP_DOEPCTL_INTBULK_EPType_Msk     (0xc0000UL)               /*!< USB_EP DOEPCTL_INTBULK: EPType (Bitfield-Mask: 0x03)        */
#define USB_EP_DOEPCTL_INTBULK_Snp_Pos        (20UL)                    /*!< USB_EP DOEPCTL_INTBULK: Snp (Bit 20)                        */
#define USB_EP_DOEPCTL_INTBULK_Snp_Msk        (0x100000UL)              /*!< USB_EP DOEPCTL_INTBULK: Snp (Bitfield-Mask: 0x01)           */
#define USB_EP_DOEPCTL_INTBULK_Stall_Pos      (21UL)                    /*!< USB_EP DOEPCTL_INTBULK: Stall (Bit 21)                      */
#define USB_EP_DOEPCTL_INTBULK_Stall_Msk      (0x200000UL)              /*!< USB_EP DOEPCTL_INTBULK: Stall (Bitfield-Mask: 0x01)         */
#define USB_EP_DOEPCTL_INTBULK_TxFNum_Pos     (22UL)                    /*!< USB_EP DOEPCTL_INTBULK: TxFNum (Bit 22)                     */
#define USB_EP_DOEPCTL_INTBULK_TxFNum_Msk     (0x3c00000UL)             /*!< USB_EP DOEPCTL_INTBULK: TxFNum (Bitfield-Mask: 0x0f)        */
#define USB_EP_DOEPCTL_INTBULK_CNAK_Pos       (26UL)                    /*!< USB_EP DOEPCTL_INTBULK: CNAK (Bit 26)                       */
#define USB_EP_DOEPCTL_INTBULK_CNAK_Msk       (0x4000000UL)             /*!< USB_EP DOEPCTL_INTBULK: CNAK (Bitfield-Mask: 0x01)          */
#define USB_EP_DOEPCTL_INTBULK_SNAK_Pos       (27UL)                    /*!< USB_EP DOEPCTL_INTBULK: SNAK (Bit 27)                       */
#define USB_EP_DOEPCTL_INTBULK_SNAK_Msk       (0x8000000UL)             /*!< USB_EP DOEPCTL_INTBULK: SNAK (Bitfield-Mask: 0x01)          */
#define USB_EP_DOEPCTL_INTBULK_SetD0PID_Pos   (28UL)                    /*!< USB_EP DOEPCTL_INTBULK: SetD0PID (Bit 28)                   */
#define USB_EP_DOEPCTL_INTBULK_SetD0PID_Msk   (0x10000000UL)            /*!< USB_EP DOEPCTL_INTBULK: SetD0PID (Bitfield-Mask: 0x01)      */
#define USB_EP_DOEPCTL_INTBULK_SetD1PID_Pos   (29UL)                    /*!< USB_EP DOEPCTL_INTBULK: SetD1PID (Bit 29)                   */
#define USB_EP_DOEPCTL_INTBULK_SetD1PID_Msk   (0x20000000UL)            /*!< USB_EP DOEPCTL_INTBULK: SetD1PID (Bitfield-Mask: 0x01)      */
#define USB_EP_DOEPCTL_INTBULK_EPDis_Pos      (30UL)                    /*!< USB_EP DOEPCTL_INTBULK: EPDis (Bit 30)                      */
#define USB_EP_DOEPCTL_INTBULK_EPDis_Msk      (0x40000000UL)            /*!< USB_EP DOEPCTL_INTBULK: EPDis (Bitfield-Mask: 0x01)         */
#define USB_EP_DOEPCTL_INTBULK_EPEna_Pos      (31UL)                    /*!< USB_EP DOEPCTL_INTBULK: EPEna (Bit 31)                      */
#define USB_EP_DOEPCTL_INTBULK_EPEna_Msk      (0x80000000UL)            /*!< USB_EP DOEPCTL_INTBULK: EPEna (Bitfield-Mask: 0x01)         */

/* -------------------------------  USB_EP_DOEPINT  ------------------------------- */
#define USB_EP_DOEPINT_XferCompl_Pos          (0UL)                     /*!< USB_EP DOEPINT: XferCompl (Bit 0)                           */
#define USB_EP_DOEPINT_XferCompl_Msk          (0x1UL)                   /*!< USB_EP DOEPINT: XferCompl (Bitfield-Mask: 0x01)             */
#define USB_EP_DOEPINT_EPDisbld_Pos           (1UL)                     /*!< USB_EP DOEPINT: EPDisbld (Bit 1)                            */
#define USB_EP_DOEPINT_EPDisbld_Msk           (0x2UL)                   /*!< USB_EP DOEPINT: EPDisbld (Bitfield-Mask: 0x01)              */
#define USB_EP_DOEPINT_AHBErr_Pos             (2UL)                     /*!< USB_EP DOEPINT: AHBErr (Bit 2)                              */
#define USB_EP_DOEPINT_AHBErr_Msk             (0x4UL)                   /*!< USB_EP DOEPINT: AHBErr (Bitfield-Mask: 0x01)                */
#define USB_EP_DOEPINT_SetUp_Pos              (3UL)                     /*!< USB_EP DOEPINT: SetUp (Bit 3)                               */
#define USB_EP_DOEPINT_SetUp_Msk              (0x8UL)                   /*!< USB_EP DOEPINT: SetUp (Bitfield-Mask: 0x01)                 */
#define USB_EP_DOEPINT_OUTTknEPdis_Pos        (4UL)                     /*!< USB_EP DOEPINT: OUTTknEPdis (Bit 4)                         */
#define USB_EP_DOEPINT_OUTTknEPdis_Msk        (0x10UL)                  /*!< USB_EP DOEPINT: OUTTknEPdis (Bitfield-Mask: 0x01)           */
#define USB_EP_DOEPINT_StsPhseRcvd_Pos        (5UL)                     /*!< USB_EP DOEPINT: StsPhseRcvd (Bit 5)                         */
#define USB_EP_DOEPINT_StsPhseRcvd_Msk        (0x20UL)                  /*!< USB_EP DOEPINT: StsPhseRcvd (Bitfield-Mask: 0x01)           */
#define USB_EP_DOEPINT_Back2BackSETup_Pos     (6UL)                     /*!< USB_EP DOEPINT: Back2BackSETup (Bit 6)                      */
#define USB_EP_DOEPINT_Back2BackSETup_Msk     (0x40UL)                  /*!< USB_EP DOEPINT: Back2BackSETup (Bitfield-Mask: 0x01)        */
#define USB_EP_DOEPINT_BNAIntr_Pos            (9UL)                     /*!< USB_EP DOEPINT: BNAIntr (Bit 9)                             */
#define USB_EP_DOEPINT_BNAIntr_Msk            (0x200UL)                 /*!< USB_EP DOEPINT: BNAIntr (Bitfield-Mask: 0x01)               */
#define USB_EP_DOEPINT_PktDrpSts_Pos          (11UL)                    /*!< USB_EP DOEPINT: PktDrpSts (Bit 11)                          */
#define USB_EP_DOEPINT_PktDrpSts_Msk          (0x800UL)                 /*!< USB_EP DOEPINT: PktDrpSts (Bitfield-Mask: 0x01)             */
#define USB_EP_DOEPINT_BbleErrIntrpt_Pos      (12UL)                    /*!< USB_EP DOEPINT: BbleErrIntrpt (Bit 12)                      */
#define USB_EP_DOEPINT_BbleErrIntrpt_Msk      (0x1000UL)                /*!< USB_EP DOEPINT: BbleErrIntrpt (Bitfield-Mask: 0x01)         */
#define USB_EP_DOEPINT_NAKIntrpt_Pos          (13UL)                    /*!< USB_EP DOEPINT: NAKIntrpt (Bit 13)                          */
#define USB_EP_DOEPINT_NAKIntrpt_Msk          (0x2000UL)                /*!< USB_EP DOEPINT: NAKIntrpt (Bitfield-Mask: 0x01)             */
#define USB_EP_DOEPINT_NYETIntrpt_Pos         (14UL)                    /*!< USB_EP DOEPINT: NYETIntrpt (Bit 14)                         */
#define USB_EP_DOEPINT_NYETIntrpt_Msk         (0x4000UL)                /*!< USB_EP DOEPINT: NYETIntrpt (Bitfield-Mask: 0x01)            */

/* -----------------------------  USB_EP_DOEPTSIZ_ISO  ---------------------------- */
#define USB_EP_DOEPTSIZ_ISO_XferSize_Pos      (0UL)                     /*!< USB_EP DOEPTSIZ_ISO: XferSize (Bit 0)                       */
#define USB_EP_DOEPTSIZ_ISO_XferSize_Msk      (0x7ffffUL)               /*!< USB_EP DOEPTSIZ_ISO: XferSize (Bitfield-Mask: 0x7ffff)      */
#define USB_EP_DOEPTSIZ_ISO_PktCnt_Pos        (19UL)                    /*!< USB_EP DOEPTSIZ_ISO: PktCnt (Bit 19)                        */
#define USB_EP_DOEPTSIZ_ISO_PktCnt_Msk        (0x1ff80000UL)            /*!< USB_EP DOEPTSIZ_ISO: PktCnt (Bitfield-Mask: 0x3ff)          */
#define USB_EP_DOEPTSIZ_ISO_RxDPID_Pos        (29UL)                    /*!< USB_EP DOEPTSIZ_ISO: RxDPID (Bit 29)                        */
#define USB_EP_DOEPTSIZ_ISO_RxDPID_Msk        (0x60000000UL)            /*!< USB_EP DOEPTSIZ_ISO: RxDPID (Bitfield-Mask: 0x03)           */

/* ---------------------------  USB_EP_DOEPTSIZ_CONTROL  -------------------------- */
#define USB_EP_DOEPTSIZ_CONTROL_XferSize_Pos  (0UL)                     /*!< USB_EP DOEPTSIZ_CONTROL: XferSize (Bit 0)                   */
#define USB_EP_DOEPTSIZ_CONTROL_XferSize_Msk  (0x7ffffUL)               /*!< USB_EP DOEPTSIZ_CONTROL: XferSize (Bitfield-Mask: 0x7ffff)  */
#define USB_EP_DOEPTSIZ_CONTROL_PktCnt_Pos    (19UL)                    /*!< USB_EP DOEPTSIZ_CONTROL: PktCnt (Bit 19)                    */
#define USB_EP_DOEPTSIZ_CONTROL_PktCnt_Msk    (0x1ff80000UL)            /*!< USB_EP DOEPTSIZ_CONTROL: PktCnt (Bitfield-Mask: 0x3ff)      */
#define USB_EP_DOEPTSIZ_CONTROL_SUPCnt_Pos    (29UL)                    /*!< USB_EP DOEPTSIZ_CONTROL: SUPCnt (Bit 29)                    */
#define USB_EP_DOEPTSIZ_CONTROL_SUPCnt_Msk    (0x60000000UL)            /*!< USB_EP DOEPTSIZ_CONTROL: SUPCnt (Bitfield-Mask: 0x03)       */

/* -------------------------------  USB_EP_DOEPDMA  ------------------------------- */
#define USB_EP_DOEPDMA_DMAAddr_Pos            (0UL)                     /*!< USB_EP DOEPDMA: DMAAddr (Bit 0)                             */
#define USB_EP_DOEPDMA_DMAAddr_Msk            (0xffffffffUL)            /*!< USB_EP DOEPDMA: DMAAddr (Bitfield-Mask: 0xffffffff)         */

/* -------------------------------  USB_EP_DOEPDMAB  ------------------------------ */
#define USB_EP_DOEPDMAB_DMABufferAddr_Pos     (0UL)                     /*!< USB_EP DOEPDMAB: DMABufferAddr (Bit 0)                      */
#define USB_EP_DOEPDMAB_DMABufferAddr_Msk     (0xffffffffUL)            /*!< USB_EP DOEPDMAB: DMABufferAddr (Bitfield-Mask: 0xffffffff)  */


/* ================================================================================ */
/* ================         Group 'USB_CH' Position & Mask         ================ */
/* ================================================================================ */


/* --------------------------------  USB_CH_HCCHAR  ------------------------------- */
#define USB_CH_HCCHAR_MPS_Pos                 (0UL)                     /*!< USB_CH HCCHAR: MPS (Bit 0)                                  */
#define USB_CH_HCCHAR_MPS_Msk                 (0x7ffUL)                 /*!< USB_CH HCCHAR: MPS (Bitfield-Mask: 0x7ff)                   */
#define USB_CH_HCCHAR_EPNum_Pos               (11UL)                    /*!< USB_CH HCCHAR: EPNum (Bit 11)                               */
#define USB_CH_HCCHAR_EPNum_Msk               (0x7800UL)                /*!< USB_CH HCCHAR: EPNum (Bitfield-Mask: 0x0f)                  */
#define USB_CH_HCCHAR_EPDir_Pos               (15UL)                    /*!< USB_CH HCCHAR: EPDir (Bit 15)                               */
#define USB_CH_HCCHAR_EPDir_Msk               (0x8000UL)                /*!< USB_CH HCCHAR: EPDir (Bitfield-Mask: 0x01)                  */
#define USB_CH_HCCHAR_EPType_Pos              (18UL)                    /*!< USB_CH HCCHAR: EPType (Bit 18)                              */
#define USB_CH_HCCHAR_EPType_Msk              (0xc0000UL)               /*!< USB_CH HCCHAR: EPType (Bitfield-Mask: 0x03)                 */
#define USB_CH_HCCHAR_MC_EC_Pos               (20UL)                    /*!< USB_CH HCCHAR: MC_EC (Bit 20)                               */
#define USB_CH_HCCHAR_MC_EC_Msk               (0x300000UL)              /*!< USB_CH HCCHAR: MC_EC (Bitfield-Mask: 0x03)                  */
#define USB_CH_HCCHAR_DevAddr_Pos             (22UL)                    /*!< USB_CH HCCHAR: DevAddr (Bit 22)                             */
#define USB_CH_HCCHAR_DevAddr_Msk             (0x1fc00000UL)            /*!< USB_CH HCCHAR: DevAddr (Bitfield-Mask: 0x7f)                */
#define USB_CH_HCCHAR_OddFrm_Pos              (29UL)                    /*!< USB_CH HCCHAR: OddFrm (Bit 29)                              */
#define USB_CH_HCCHAR_OddFrm_Msk              (0x20000000UL)            /*!< USB_CH HCCHAR: OddFrm (Bitfield-Mask: 0x01)                 */
#define USB_CH_HCCHAR_ChDis_Pos               (30UL)                    /*!< USB_CH HCCHAR: ChDis (Bit 30)                               */
#define USB_CH_HCCHAR_ChDis_Msk               (0x40000000UL)            /*!< USB_CH HCCHAR: ChDis (Bitfield-Mask: 0x01)                  */
#define USB_CH_HCCHAR_ChEna_Pos               (31UL)                    /*!< USB_CH HCCHAR: ChEna (Bit 31)                               */
#define USB_CH_HCCHAR_ChEna_Msk               (0x80000000UL)            /*!< USB_CH HCCHAR: ChEna (Bitfield-Mask: 0x01)                  */

/* --------------------------------  USB_CH_HCINT  -------------------------------- */
#define USB_CH_HCINT_XferCompl_Pos            (0UL)                     /*!< USB_CH HCINT: XferCompl (Bit 0)                             */
#define USB_CH_HCINT_XferCompl_Msk            (0x1UL)                   /*!< USB_CH HCINT: XferCompl (Bitfield-Mask: 0x01)               */
#define USB_CH_HCINT_ChHltd_Pos               (1UL)                     /*!< USB_CH HCINT: ChHltd (Bit 1)                                */
#define USB_CH_HCINT_ChHltd_Msk               (0x2UL)                   /*!< USB_CH HCINT: ChHltd (Bitfield-Mask: 0x01)                  */
#define USB_CH_HCINT_AHBErr_Pos               (2UL)                     /*!< USB_CH HCINT: AHBErr (Bit 2)                                */
#define USB_CH_HCINT_AHBErr_Msk               (0x4UL)                   /*!< USB_CH HCINT: AHBErr (Bitfield-Mask: 0x01)                  */
#define USB_CH_HCINT_STALL_Pos                (3UL)                     /*!< USB_CH HCINT: STALL (Bit 3)                                 */
#define USB_CH_HCINT_STALL_Msk                (0x8UL)                   /*!< USB_CH HCINT: STALL (Bitfield-Mask: 0x01)                   */
#define USB_CH_HCINT_NAK_Pos                  (4UL)                     /*!< USB_CH HCINT: NAK (Bit 4)                                   */
#define USB_CH_HCINT_NAK_Msk                  (0x10UL)                  /*!< USB_CH HCINT: NAK (Bitfield-Mask: 0x01)                     */
#define USB_CH_HCINT_ACK_Pos                  (5UL)                     /*!< USB_CH HCINT: ACK (Bit 5)                                   */
#define USB_CH_HCINT_ACK_Msk                  (0x20UL)                  /*!< USB_CH HCINT: ACK (Bitfield-Mask: 0x01)                     */
#define USB_CH_HCINT_NYET_Pos                 (6UL)                     /*!< USB_CH HCINT: NYET (Bit 6)                                  */
#define USB_CH_HCINT_NYET_Msk                 (0x40UL)                  /*!< USB_CH HCINT: NYET (Bitfield-Mask: 0x01)                    */
#define USB_CH_HCINT_XactErr_Pos              (7UL)                     /*!< USB_CH HCINT: XactErr (Bit 7)                               */
#define USB_CH_HCINT_XactErr_Msk              (0x80UL)                  /*!< USB_CH HCINT: XactErr (Bitfield-Mask: 0x01)                 */
#define USB_CH_HCINT_BblErr_Pos               (8UL)                     /*!< USB_CH HCINT: BblErr (Bit 8)                                */
#define USB_CH_HCINT_BblErr_Msk               (0x100UL)                 /*!< USB_CH HCINT: BblErr (Bitfield-Mask: 0x01)                  */
#define USB_CH_HCINT_FrmOvrun_Pos             (9UL)                     /*!< USB_CH HCINT: FrmOvrun (Bit 9)                              */
#define USB_CH_HCINT_FrmOvrun_Msk             (0x200UL)                 /*!< USB_CH HCINT: FrmOvrun (Bitfield-Mask: 0x01)                */
#define USB_CH_HCINT_DataTglErr_Pos           (10UL)                    /*!< USB_CH HCINT: DataTglErr (Bit 10)                           */
#define USB_CH_HCINT_DataTglErr_Msk           (0x400UL)                 /*!< USB_CH HCINT: DataTglErr (Bitfield-Mask: 0x01)              */
#define USB_CH_HCINT_BNAIntr_Pos              (11UL)                    /*!< USB_CH HCINT: BNAIntr (Bit 11)                              */
#define USB_CH_HCINT_BNAIntr_Msk              (0x800UL)                 /*!< USB_CH HCINT: BNAIntr (Bitfield-Mask: 0x01)                 */
#define USB_CH_HCINT_XCS_XACT_ERR_Pos         (12UL)                    /*!< USB_CH HCINT: XCS_XACT_ERR (Bit 12)                         */
#define USB_CH_HCINT_XCS_XACT_ERR_Msk         (0x1000UL)                /*!< USB_CH HCINT: XCS_XACT_ERR (Bitfield-Mask: 0x01)            */
#define USB_CH_HCINT_DESC_LST_ROLLIntr_Pos    (13UL)                    /*!< USB_CH HCINT: DESC_LST_ROLLIntr (Bit 13)                    */
#define USB_CH_HCINT_DESC_LST_ROLLIntr_Msk    (0x2000UL)                /*!< USB_CH HCINT: DESC_LST_ROLLIntr (Bitfield-Mask: 0x01)       */

/* -------------------------------  USB_CH_HCINTMSK  ------------------------------ */
#define USB_CH_HCINTMSK_XferComplMsk_Pos      (0UL)                     /*!< USB_CH HCINTMSK: XferComplMsk (Bit 0)                       */
#define USB_CH_HCINTMSK_XferComplMsk_Msk      (0x1UL)                   /*!< USB_CH HCINTMSK: XferComplMsk (Bitfield-Mask: 0x01)         */
#define USB_CH_HCINTMSK_ChHltdMsk_Pos         (1UL)                     /*!< USB_CH HCINTMSK: ChHltdMsk (Bit 1)                          */
#define USB_CH_HCINTMSK_ChHltdMsk_Msk         (0x2UL)                   /*!< USB_CH HCINTMSK: ChHltdMsk (Bitfield-Mask: 0x01)            */
#define USB_CH_HCINTMSK_AHBErrMsk_Pos         (2UL)                     /*!< USB_CH HCINTMSK: AHBErrMsk (Bit 2)                          */
#define USB_CH_HCINTMSK_AHBErrMsk_Msk         (0x4UL)                   /*!< USB_CH HCINTMSK: AHBErrMsk (Bitfield-Mask: 0x01)            */
#define USB_CH_HCINTMSK_StallMsk_Pos          (3UL)                     /*!< USB_CH HCINTMSK: StallMsk (Bit 3)                           */
#define USB_CH_HCINTMSK_StallMsk_Msk          (0x8UL)                   /*!< USB_CH HCINTMSK: StallMsk (Bitfield-Mask: 0x01)             */
#define USB_CH_HCINTMSK_NakMsk_Pos            (4UL)                     /*!< USB_CH HCINTMSK: NakMsk (Bit 4)                             */
#define USB_CH_HCINTMSK_NakMsk_Msk            (0x10UL)                  /*!< USB_CH HCINTMSK: NakMsk (Bitfield-Mask: 0x01)               */
#define USB_CH_HCINTMSK_AckMsk_Pos            (5UL)                     /*!< USB_CH HCINTMSK: AckMsk (Bit 5)                             */
#define USB_CH_HCINTMSK_AckMsk_Msk            (0x20UL)                  /*!< USB_CH HCINTMSK: AckMsk (Bitfield-Mask: 0x01)               */
#define USB_CH_HCINTMSK_NyetMsk_Pos           (6UL)                     /*!< USB_CH HCINTMSK: NyetMsk (Bit 6)                            */
#define USB_CH_HCINTMSK_NyetMsk_Msk           (0x40UL)                  /*!< USB_CH HCINTMSK: NyetMsk (Bitfield-Mask: 0x01)              */
#define USB_CH_HCINTMSK_XactErrMsk_Pos        (7UL)                     /*!< USB_CH HCINTMSK: XactErrMsk (Bit 7)                         */
#define USB_CH_HCINTMSK_XactErrMsk_Msk        (0x80UL)                  /*!< USB_CH HCINTMSK: XactErrMsk (Bitfield-Mask: 0x01)           */
#define USB_CH_HCINTMSK_BblErrMsk_Pos         (8UL)                     /*!< USB_CH HCINTMSK: BblErrMsk (Bit 8)                          */
#define USB_CH_HCINTMSK_BblErrMsk_Msk         (0x100UL)                 /*!< USB_CH HCINTMSK: BblErrMsk (Bitfield-Mask: 0x01)            */
#define USB_CH_HCINTMSK_FrmOvrunMsk_Pos       (9UL)                     /*!< USB_CH HCINTMSK: FrmOvrunMsk (Bit 9)                        */
#define USB_CH_HCINTMSK_FrmOvrunMsk_Msk       (0x200UL)                 /*!< USB_CH HCINTMSK: FrmOvrunMsk (Bitfield-Mask: 0x01)          */
#define USB_CH_HCINTMSK_DataTglErrMsk_Pos     (10UL)                    /*!< USB_CH HCINTMSK: DataTglErrMsk (Bit 10)                     */
#define USB_CH_HCINTMSK_DataTglErrMsk_Msk     (0x400UL)                 /*!< USB_CH HCINTMSK: DataTglErrMsk (Bitfield-Mask: 0x01)        */
#define USB_CH_HCINTMSK_BNAIntrMsk_Pos        (11UL)                    /*!< USB_CH HCINTMSK: BNAIntrMsk (Bit 11)                        */
#define USB_CH_HCINTMSK_BNAIntrMsk_Msk        (0x800UL)                 /*!< USB_CH HCINTMSK: BNAIntrMsk (Bitfield-Mask: 0x01)           */
#define USB_CH_HCINTMSK_DESC_LST_ROLLIntrMsk_Pos (13UL)                 /*!< USB_CH HCINTMSK: DESC_LST_ROLLIntrMsk (Bit 13)              */
#define USB_CH_HCINTMSK_DESC_LST_ROLLIntrMsk_Msk (0x2000UL)             /*!< USB_CH HCINTMSK: DESC_LST_ROLLIntrMsk (Bitfield-Mask: 0x01) */

/* --------------------------  USB_CH_HCTSIZ_BUFFERMODE  -------------------------- */
#define USB_CH_HCTSIZ_BUFFERMODE_XferSize_Pos (0UL)                     /*!< USB_CH HCTSIZ_BUFFERMODE: XferSize (Bit 0)                  */
#define USB_CH_HCTSIZ_BUFFERMODE_XferSize_Msk (0x7ffffUL)               /*!< USB_CH HCTSIZ_BUFFERMODE: XferSize (Bitfield-Mask: 0x7ffff) */
#define USB_CH_HCTSIZ_BUFFERMODE_PktCnt_Pos   (19UL)                    /*!< USB_CH HCTSIZ_BUFFERMODE: PktCnt (Bit 19)                   */
#define USB_CH_HCTSIZ_BUFFERMODE_PktCnt_Msk   (0x1ff80000UL)            /*!< USB_CH HCTSIZ_BUFFERMODE: PktCnt (Bitfield-Mask: 0x3ff)     */
#define USB_CH_HCTSIZ_BUFFERMODE_Pid_Pos      (29UL)                    /*!< USB_CH HCTSIZ_BUFFERMODE: Pid (Bit 29)                      */
#define USB_CH_HCTSIZ_BUFFERMODE_Pid_Msk      (0x60000000UL)            /*!< USB_CH HCTSIZ_BUFFERMODE: Pid (Bitfield-Mask: 0x03)         */

/* --------------------------  USB_CH_HCTSIZ_SCATGATHER  -------------------------- */
#define USB_CH_HCTSIZ_SCATGATHER_SCHED_INFO_Pos (0UL)                   /*!< USB_CH HCTSIZ_SCATGATHER: SCHED_INFO (Bit 0)                */
#define USB_CH_HCTSIZ_SCATGATHER_SCHED_INFO_Msk (0xffUL)                /*!< USB_CH HCTSIZ_SCATGATHER: SCHED_INFO (Bitfield-Mask: 0xff)  */
#define USB_CH_HCTSIZ_SCATGATHER_NTD_Pos      (8UL)                     /*!< USB_CH HCTSIZ_SCATGATHER: NTD (Bit 8)                       */
#define USB_CH_HCTSIZ_SCATGATHER_NTD_Msk      (0xff00UL)                /*!< USB_CH HCTSIZ_SCATGATHER: NTD (Bitfield-Mask: 0xff)         */
#define USB_CH_HCTSIZ_SCATGATHER_Pid_Pos      (29UL)                    /*!< USB_CH HCTSIZ_SCATGATHER: Pid (Bit 29)                      */
#define USB_CH_HCTSIZ_SCATGATHER_Pid_Msk      (0x60000000UL)            /*!< USB_CH HCTSIZ_SCATGATHER: Pid (Bitfield-Mask: 0x03)         */

/* ---------------------------  USB_CH_HCDMA_BUFFERMODE  -------------------------- */
#define USB_CH_HCDMA_BUFFERMODE_DMAAddr_Pos   (0UL)                     /*!< USB_CH HCDMA_BUFFERMODE: DMAAddr (Bit 0)                    */
#define USB_CH_HCDMA_BUFFERMODE_DMAAddr_Msk   (0xffffffffUL)            /*!< USB_CH HCDMA_BUFFERMODE: DMAAddr (Bitfield-Mask: 0xffffffff) */

/* ---------------------------  USB_CH_HCDMA_SCATGATHER  -------------------------- */
#define USB_CH_HCDMA_SCATGATHER_CTD_Pos       (3UL)                     /*!< USB_CH HCDMA_SCATGATHER: CTD (Bit 3)                        */
#define USB_CH_HCDMA_SCATGATHER_CTD_Msk       (0x1f8UL)                 /*!< USB_CH HCDMA_SCATGATHER: CTD (Bitfield-Mask: 0x3f)          */
#define USB_CH_HCDMA_SCATGATHER_DMAAddr_Pos   (9UL)                     /*!< USB_CH HCDMA_SCATGATHER: DMAAddr (Bit 9)                    */
#define USB_CH_HCDMA_SCATGATHER_DMAAddr_Msk   (0xfffffe00UL)            /*!< USB_CH HCDMA_SCATGATHER: DMAAddr (Bitfield-Mask: 0x7fffff)  */

/* --------------------------------  USB_CH_HCDMAB  ------------------------------- */
#define USB_CH_HCDMAB_Buffer_Address_Pos      (0UL)                     /*!< USB_CH HCDMAB: Buffer_Address (Bit 0)                       */
#define USB_CH_HCDMAB_Buffer_Address_Msk      (0xffffffffUL)            /*!< USB_CH HCDMAB: Buffer_Address (Bitfield-Mask: 0xffffffff)   */


/* ================================================================================ */
/* ================          Group 'USIC' Position & Mask          ================ */
/* ================================================================================ */


/* -----------------------------------  USIC_ID  ---------------------------------- */
#define USIC_ID_MOD_REV_Pos                   (0UL)                     /*!< USIC ID: MOD_REV (Bit 0)                                    */
#define USIC_ID_MOD_REV_Msk                   (0xffUL)                  /*!< USIC ID: MOD_REV (Bitfield-Mask: 0xff)                      */
#define USIC_ID_MOD_TYPE_Pos                  (8UL)                     /*!< USIC ID: MOD_TYPE (Bit 8)                                   */
#define USIC_ID_MOD_TYPE_Msk                  (0xff00UL)                /*!< USIC ID: MOD_TYPE (Bitfield-Mask: 0xff)                     */
#define USIC_ID_MOD_NUMBER_Pos                (16UL)                    /*!< USIC ID: MOD_NUMBER (Bit 16)                                */
#define USIC_ID_MOD_NUMBER_Msk                (0xffff0000UL)            /*!< USIC ID: MOD_NUMBER (Bitfield-Mask: 0xffff)                 */


/* ================================================================================ */
/* ================         Group 'USIC_CH' Position & Mask        ================ */
/* ================================================================================ */


/* --------------------------------  USIC_CH_CCFG  -------------------------------- */
#define USIC_CH_CCFG_SSC_Pos                  (0UL)                     /*!< USIC_CH CCFG: SSC (Bit 0)                                   */
#define USIC_CH_CCFG_SSC_Msk                  (0x1UL)                   /*!< USIC_CH CCFG: SSC (Bitfield-Mask: 0x01)                     */
#define USIC_CH_CCFG_ASC_Pos                  (1UL)                     /*!< USIC_CH CCFG: ASC (Bit 1)                                   */
#define USIC_CH_CCFG_ASC_Msk                  (0x2UL)                   /*!< USIC_CH CCFG: ASC (Bitfield-Mask: 0x01)                     */
#define USIC_CH_CCFG_IIC_Pos                  (2UL)                     /*!< USIC_CH CCFG: IIC (Bit 2)                                   */
#define USIC_CH_CCFG_IIC_Msk                  (0x4UL)                   /*!< USIC_CH CCFG: IIC (Bitfield-Mask: 0x01)                     */
#define USIC_CH_CCFG_IIS_Pos                  (3UL)                     /*!< USIC_CH CCFG: IIS (Bit 3)                                   */
#define USIC_CH_CCFG_IIS_Msk                  (0x8UL)                   /*!< USIC_CH CCFG: IIS (Bitfield-Mask: 0x01)                     */
#define USIC_CH_CCFG_RB_Pos                   (6UL)                     /*!< USIC_CH CCFG: RB (Bit 6)                                    */
#define USIC_CH_CCFG_RB_Msk                   (0x40UL)                  /*!< USIC_CH CCFG: RB (Bitfield-Mask: 0x01)                      */
#define USIC_CH_CCFG_TB_Pos                   (7UL)                     /*!< USIC_CH CCFG: TB (Bit 7)                                    */
#define USIC_CH_CCFG_TB_Msk                   (0x80UL)                  /*!< USIC_CH CCFG: TB (Bitfield-Mask: 0x01)                      */

/* --------------------------------  USIC_CH_KSCFG  ------------------------------- */
#define USIC_CH_KSCFG_MODEN_Pos               (0UL)                     /*!< USIC_CH KSCFG: MODEN (Bit 0)                                */
#define USIC_CH_KSCFG_MODEN_Msk               (0x1UL)                   /*!< USIC_CH KSCFG: MODEN (Bitfield-Mask: 0x01)                  */
#define USIC_CH_KSCFG_BPMODEN_Pos             (1UL)                     /*!< USIC_CH KSCFG: BPMODEN (Bit 1)                              */
#define USIC_CH_KSCFG_BPMODEN_Msk             (0x2UL)                   /*!< USIC_CH KSCFG: BPMODEN (Bitfield-Mask: 0x01)                */
#define USIC_CH_KSCFG_NOMCFG_Pos              (4UL)                     /*!< USIC_CH KSCFG: NOMCFG (Bit 4)                               */
#define USIC_CH_KSCFG_NOMCFG_Msk              (0x30UL)                  /*!< USIC_CH KSCFG: NOMCFG (Bitfield-Mask: 0x03)                 */
#define USIC_CH_KSCFG_BPNOM_Pos               (7UL)                     /*!< USIC_CH KSCFG: BPNOM (Bit 7)                                */
#define USIC_CH_KSCFG_BPNOM_Msk               (0x80UL)                  /*!< USIC_CH KSCFG: BPNOM (Bitfield-Mask: 0x01)                  */
#define USIC_CH_KSCFG_SUMCFG_Pos              (8UL)                     /*!< USIC_CH KSCFG: SUMCFG (Bit 8)                               */
#define USIC_CH_KSCFG_SUMCFG_Msk              (0x300UL)                 /*!< USIC_CH KSCFG: SUMCFG (Bitfield-Mask: 0x03)                 */
#define USIC_CH_KSCFG_BPSUM_Pos               (11UL)                    /*!< USIC_CH KSCFG: BPSUM (Bit 11)                               */
#define USIC_CH_KSCFG_BPSUM_Msk               (0x800UL)                 /*!< USIC_CH KSCFG: BPSUM (Bitfield-Mask: 0x01)                  */

/* ---------------------------------  USIC_CH_FDR  -------------------------------- */
#define USIC_CH_FDR_STEP_Pos                  (0UL)                     /*!< USIC_CH FDR: STEP (Bit 0)                                   */
#define USIC_CH_FDR_STEP_Msk                  (0x3ffUL)                 /*!< USIC_CH FDR: STEP (Bitfield-Mask: 0x3ff)                    */
#define USIC_CH_FDR_DM_Pos                    (14UL)                    /*!< USIC_CH FDR: DM (Bit 14)                                    */
#define USIC_CH_FDR_DM_Msk                    (0xc000UL)                /*!< USIC_CH FDR: DM (Bitfield-Mask: 0x03)                       */
#define USIC_CH_FDR_RESULT_Pos                (16UL)                    /*!< USIC_CH FDR: RESULT (Bit 16)                                */
#define USIC_CH_FDR_RESULT_Msk                (0x3ff0000UL)             /*!< USIC_CH FDR: RESULT (Bitfield-Mask: 0x3ff)                  */

/* ---------------------------------  USIC_CH_BRG  -------------------------------- */
#define USIC_CH_BRG_CLKSEL_Pos                (0UL)                     /*!< USIC_CH BRG: CLKSEL (Bit 0)                                 */
#define USIC_CH_BRG_CLKSEL_Msk                (0x3UL)                   /*!< USIC_CH BRG: CLKSEL (Bitfield-Mask: 0x03)                   */
#define USIC_CH_BRG_TMEN_Pos                  (3UL)                     /*!< USIC_CH BRG: TMEN (Bit 3)                                   */
#define USIC_CH_BRG_TMEN_Msk                  (0x8UL)                   /*!< USIC_CH BRG: TMEN (Bitfield-Mask: 0x01)                     */
#define USIC_CH_BRG_PPPEN_Pos                 (4UL)                     /*!< USIC_CH BRG: PPPEN (Bit 4)                                  */
#define USIC_CH_BRG_PPPEN_Msk                 (0x10UL)                  /*!< USIC_CH BRG: PPPEN (Bitfield-Mask: 0x01)                    */
#define USIC_CH_BRG_CTQSEL_Pos                (6UL)                     /*!< USIC_CH BRG: CTQSEL (Bit 6)                                 */
#define USIC_CH_BRG_CTQSEL_Msk                (0xc0UL)                  /*!< USIC_CH BRG: CTQSEL (Bitfield-Mask: 0x03)                   */
#define USIC_CH_BRG_PCTQ_Pos                  (8UL)                     /*!< USIC_CH BRG: PCTQ (Bit 8)                                   */
#define USIC_CH_BRG_PCTQ_Msk                  (0x300UL)                 /*!< USIC_CH BRG: PCTQ (Bitfield-Mask: 0x03)                     */
#define USIC_CH_BRG_DCTQ_Pos                  (10UL)                    /*!< USIC_CH BRG: DCTQ (Bit 10)                                  */
#define USIC_CH_BRG_DCTQ_Msk                  (0x7c00UL)                /*!< USIC_CH BRG: DCTQ (Bitfield-Mask: 0x1f)                     */
#define USIC_CH_BRG_PDIV_Pos                  (16UL)                    /*!< USIC_CH BRG: PDIV (Bit 16)                                  */
#define USIC_CH_BRG_PDIV_Msk                  (0x3ff0000UL)             /*!< USIC_CH BRG: PDIV (Bitfield-Mask: 0x3ff)                    */
#define USIC_CH_BRG_SCLKOSEL_Pos              (28UL)                    /*!< USIC_CH BRG: SCLKOSEL (Bit 28)                              */
#define USIC_CH_BRG_SCLKOSEL_Msk              (0x10000000UL)            /*!< USIC_CH BRG: SCLKOSEL (Bitfield-Mask: 0x01)                 */
#define USIC_CH_BRG_MCLKCFG_Pos               (29UL)                    /*!< USIC_CH BRG: MCLKCFG (Bit 29)                               */
#define USIC_CH_BRG_MCLKCFG_Msk               (0x20000000UL)            /*!< USIC_CH BRG: MCLKCFG (Bitfield-Mask: 0x01)                  */
#define USIC_CH_BRG_SCLKCFG_Pos               (30UL)                    /*!< USIC_CH BRG: SCLKCFG (Bit 30)                               */
#define USIC_CH_BRG_SCLKCFG_Msk               (0xc0000000UL)            /*!< USIC_CH BRG: SCLKCFG (Bitfield-Mask: 0x03)                  */

/* --------------------------------  USIC_CH_INPR  -------------------------------- */
#define USIC_CH_INPR_TSINP_Pos                (0UL)                     /*!< USIC_CH INPR: TSINP (Bit 0)                                 */
#define USIC_CH_INPR_TSINP_Msk                (0x7UL)                   /*!< USIC_CH INPR: TSINP (Bitfield-Mask: 0x07)                   */
#define USIC_CH_INPR_TBINP_Pos                (4UL)                     /*!< USIC_CH INPR: TBINP (Bit 4)                                 */
#define USIC_CH_INPR_TBINP_Msk                (0x70UL)                  /*!< USIC_CH INPR: TBINP (Bitfield-Mask: 0x07)                   */
#define USIC_CH_INPR_RINP_Pos                 (8UL)                     /*!< USIC_CH INPR: RINP (Bit 8)                                  */
#define USIC_CH_INPR_RINP_Msk                 (0x700UL)                 /*!< USIC_CH INPR: RINP (Bitfield-Mask: 0x07)                    */
#define USIC_CH_INPR_AINP_Pos                 (12UL)                    /*!< USIC_CH INPR: AINP (Bit 12)                                 */
#define USIC_CH_INPR_AINP_Msk                 (0x7000UL)                /*!< USIC_CH INPR: AINP (Bitfield-Mask: 0x07)                    */
#define USIC_CH_INPR_PINP_Pos                 (16UL)                    /*!< USIC_CH INPR: PINP (Bit 16)                                 */
#define USIC_CH_INPR_PINP_Msk                 (0x70000UL)               /*!< USIC_CH INPR: PINP (Bitfield-Mask: 0x07)                    */

/* --------------------------------  USIC_CH_DX0CR  ------------------------------- */
#define USIC_CH_DX0CR_DSEL_Pos                (0UL)                     /*!< USIC_CH DX0CR: DSEL (Bit 0)                                 */
#define USIC_CH_DX0CR_DSEL_Msk                (0x7UL)                   /*!< USIC_CH DX0CR: DSEL (Bitfield-Mask: 0x07)                   */
#define USIC_CH_DX0CR_INSW_Pos                (4UL)                     /*!< USIC_CH DX0CR: INSW (Bit 4)                                 */
#define USIC_CH_DX0CR_INSW_Msk                (0x10UL)                  /*!< USIC_CH DX0CR: INSW (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX0CR_DFEN_Pos                (5UL)                     /*!< USIC_CH DX0CR: DFEN (Bit 5)                                 */
#define USIC_CH_DX0CR_DFEN_Msk                (0x20UL)                  /*!< USIC_CH DX0CR: DFEN (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX0CR_DSEN_Pos                (6UL)                     /*!< USIC_CH DX0CR: DSEN (Bit 6)                                 */
#define USIC_CH_DX0CR_DSEN_Msk                (0x40UL)                  /*!< USIC_CH DX0CR: DSEN (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX0CR_DPOL_Pos                (8UL)                     /*!< USIC_CH DX0CR: DPOL (Bit 8)                                 */
#define USIC_CH_DX0CR_DPOL_Msk                (0x100UL)                 /*!< USIC_CH DX0CR: DPOL (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX0CR_SFSEL_Pos               (9UL)                     /*!< USIC_CH DX0CR: SFSEL (Bit 9)                                */
#define USIC_CH_DX0CR_SFSEL_Msk               (0x200UL)                 /*!< USIC_CH DX0CR: SFSEL (Bitfield-Mask: 0x01)                  */
#define USIC_CH_DX0CR_CM_Pos                  (10UL)                    /*!< USIC_CH DX0CR: CM (Bit 10)                                  */
#define USIC_CH_DX0CR_CM_Msk                  (0xc00UL)                 /*!< USIC_CH DX0CR: CM (Bitfield-Mask: 0x03)                     */
#define USIC_CH_DX0CR_DXS_Pos                 (15UL)                    /*!< USIC_CH DX0CR: DXS (Bit 15)                                 */
#define USIC_CH_DX0CR_DXS_Msk                 (0x8000UL)                /*!< USIC_CH DX0CR: DXS (Bitfield-Mask: 0x01)                    */

/* --------------------------------  USIC_CH_DX1CR  ------------------------------- */
#define USIC_CH_DX1CR_DSEL_Pos                (0UL)                     /*!< USIC_CH DX1CR: DSEL (Bit 0)                                 */
#define USIC_CH_DX1CR_DSEL_Msk                (0x7UL)                   /*!< USIC_CH DX1CR: DSEL (Bitfield-Mask: 0x07)                   */
#define USIC_CH_DX1CR_DCEN_Pos                (3UL)                     /*!< USIC_CH DX1CR: DCEN (Bit 3)                                 */
#define USIC_CH_DX1CR_DCEN_Msk                (0x8UL)                   /*!< USIC_CH DX1CR: DCEN (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX1CR_INSW_Pos                (4UL)                     /*!< USIC_CH DX1CR: INSW (Bit 4)                                 */
#define USIC_CH_DX1CR_INSW_Msk                (0x10UL)                  /*!< USIC_CH DX1CR: INSW (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX1CR_DFEN_Pos                (5UL)                     /*!< USIC_CH DX1CR: DFEN (Bit 5)                                 */
#define USIC_CH_DX1CR_DFEN_Msk                (0x20UL)                  /*!< USIC_CH DX1CR: DFEN (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX1CR_DSEN_Pos                (6UL)                     /*!< USIC_CH DX1CR: DSEN (Bit 6)                                 */
#define USIC_CH_DX1CR_DSEN_Msk                (0x40UL)                  /*!< USIC_CH DX1CR: DSEN (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX1CR_DPOL_Pos                (8UL)                     /*!< USIC_CH DX1CR: DPOL (Bit 8)                                 */
#define USIC_CH_DX1CR_DPOL_Msk                (0x100UL)                 /*!< USIC_CH DX1CR: DPOL (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX1CR_SFSEL_Pos               (9UL)                     /*!< USIC_CH DX1CR: SFSEL (Bit 9)                                */
#define USIC_CH_DX1CR_SFSEL_Msk               (0x200UL)                 /*!< USIC_CH DX1CR: SFSEL (Bitfield-Mask: 0x01)                  */
#define USIC_CH_DX1CR_CM_Pos                  (10UL)                    /*!< USIC_CH DX1CR: CM (Bit 10)                                  */
#define USIC_CH_DX1CR_CM_Msk                  (0xc00UL)                 /*!< USIC_CH DX1CR: CM (Bitfield-Mask: 0x03)                     */
#define USIC_CH_DX1CR_DXS_Pos                 (15UL)                    /*!< USIC_CH DX1CR: DXS (Bit 15)                                 */
#define USIC_CH_DX1CR_DXS_Msk                 (0x8000UL)                /*!< USIC_CH DX1CR: DXS (Bitfield-Mask: 0x01)                    */

/* --------------------------------  USIC_CH_DX2CR  ------------------------------- */
#define USIC_CH_DX2CR_DSEL_Pos                (0UL)                     /*!< USIC_CH DX2CR: DSEL (Bit 0)                                 */
#define USIC_CH_DX2CR_DSEL_Msk                (0x7UL)                   /*!< USIC_CH DX2CR: DSEL (Bitfield-Mask: 0x07)                   */
#define USIC_CH_DX2CR_INSW_Pos                (4UL)                     /*!< USIC_CH DX2CR: INSW (Bit 4)                                 */
#define USIC_CH_DX2CR_INSW_Msk                (0x10UL)                  /*!< USIC_CH DX2CR: INSW (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX2CR_DFEN_Pos                (5UL)                     /*!< USIC_CH DX2CR: DFEN (Bit 5)                                 */
#define USIC_CH_DX2CR_DFEN_Msk                (0x20UL)                  /*!< USIC_CH DX2CR: DFEN (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX2CR_DSEN_Pos                (6UL)                     /*!< USIC_CH DX2CR: DSEN (Bit 6)                                 */
#define USIC_CH_DX2CR_DSEN_Msk                (0x40UL)                  /*!< USIC_CH DX2CR: DSEN (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX2CR_DPOL_Pos                (8UL)                     /*!< USIC_CH DX2CR: DPOL (Bit 8)                                 */
#define USIC_CH_DX2CR_DPOL_Msk                (0x100UL)                 /*!< USIC_CH DX2CR: DPOL (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX2CR_SFSEL_Pos               (9UL)                     /*!< USIC_CH DX2CR: SFSEL (Bit 9)                                */
#define USIC_CH_DX2CR_SFSEL_Msk               (0x200UL)                 /*!< USIC_CH DX2CR: SFSEL (Bitfield-Mask: 0x01)                  */
#define USIC_CH_DX2CR_CM_Pos                  (10UL)                    /*!< USIC_CH DX2CR: CM (Bit 10)                                  */
#define USIC_CH_DX2CR_CM_Msk                  (0xc00UL)                 /*!< USIC_CH DX2CR: CM (Bitfield-Mask: 0x03)                     */
#define USIC_CH_DX2CR_DXS_Pos                 (15UL)                    /*!< USIC_CH DX2CR: DXS (Bit 15)                                 */
#define USIC_CH_DX2CR_DXS_Msk                 (0x8000UL)                /*!< USIC_CH DX2CR: DXS (Bitfield-Mask: 0x01)                    */

/* --------------------------------  USIC_CH_DX3CR  ------------------------------- */
#define USIC_CH_DX3CR_DSEL_Pos                (0UL)                     /*!< USIC_CH DX3CR: DSEL (Bit 0)                                 */
#define USIC_CH_DX3CR_DSEL_Msk                (0x7UL)                   /*!< USIC_CH DX3CR: DSEL (Bitfield-Mask: 0x07)                   */
#define USIC_CH_DX3CR_INSW_Pos                (4UL)                     /*!< USIC_CH DX3CR: INSW (Bit 4)                                 */
#define USIC_CH_DX3CR_INSW_Msk                (0x10UL)                  /*!< USIC_CH DX3CR: INSW (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX3CR_DFEN_Pos                (5UL)                     /*!< USIC_CH DX3CR: DFEN (Bit 5)                                 */
#define USIC_CH_DX3CR_DFEN_Msk                (0x20UL)                  /*!< USIC_CH DX3CR: DFEN (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX3CR_DSEN_Pos                (6UL)                     /*!< USIC_CH DX3CR: DSEN (Bit 6)                                 */
#define USIC_CH_DX3CR_DSEN_Msk                (0x40UL)                  /*!< USIC_CH DX3CR: DSEN (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX3CR_DPOL_Pos                (8UL)                     /*!< USIC_CH DX3CR: DPOL (Bit 8)                                 */
#define USIC_CH_DX3CR_DPOL_Msk                (0x100UL)                 /*!< USIC_CH DX3CR: DPOL (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX3CR_SFSEL_Pos               (9UL)                     /*!< USIC_CH DX3CR: SFSEL (Bit 9)                                */
#define USIC_CH_DX3CR_SFSEL_Msk               (0x200UL)                 /*!< USIC_CH DX3CR: SFSEL (Bitfield-Mask: 0x01)                  */
#define USIC_CH_DX3CR_CM_Pos                  (10UL)                    /*!< USIC_CH DX3CR: CM (Bit 10)                                  */
#define USIC_CH_DX3CR_CM_Msk                  (0xc00UL)                 /*!< USIC_CH DX3CR: CM (Bitfield-Mask: 0x03)                     */
#define USIC_CH_DX3CR_DXS_Pos                 (15UL)                    /*!< USIC_CH DX3CR: DXS (Bit 15)                                 */
#define USIC_CH_DX3CR_DXS_Msk                 (0x8000UL)                /*!< USIC_CH DX3CR: DXS (Bitfield-Mask: 0x01)                    */

/* --------------------------------  USIC_CH_DX4CR  ------------------------------- */
#define USIC_CH_DX4CR_DSEL_Pos                (0UL)                     /*!< USIC_CH DX4CR: DSEL (Bit 0)                                 */
#define USIC_CH_DX4CR_DSEL_Msk                (0x7UL)                   /*!< USIC_CH DX4CR: DSEL (Bitfield-Mask: 0x07)                   */
#define USIC_CH_DX4CR_INSW_Pos                (4UL)                     /*!< USIC_CH DX4CR: INSW (Bit 4)                                 */
#define USIC_CH_DX4CR_INSW_Msk                (0x10UL)                  /*!< USIC_CH DX4CR: INSW (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX4CR_DFEN_Pos                (5UL)                     /*!< USIC_CH DX4CR: DFEN (Bit 5)                                 */
#define USIC_CH_DX4CR_DFEN_Msk                (0x20UL)                  /*!< USIC_CH DX4CR: DFEN (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX4CR_DSEN_Pos                (6UL)                     /*!< USIC_CH DX4CR: DSEN (Bit 6)                                 */
#define USIC_CH_DX4CR_DSEN_Msk                (0x40UL)                  /*!< USIC_CH DX4CR: DSEN (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX4CR_DPOL_Pos                (8UL)                     /*!< USIC_CH DX4CR: DPOL (Bit 8)                                 */
#define USIC_CH_DX4CR_DPOL_Msk                (0x100UL)                 /*!< USIC_CH DX4CR: DPOL (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX4CR_SFSEL_Pos               (9UL)                     /*!< USIC_CH DX4CR: SFSEL (Bit 9)                                */
#define USIC_CH_DX4CR_SFSEL_Msk               (0x200UL)                 /*!< USIC_CH DX4CR: SFSEL (Bitfield-Mask: 0x01)                  */
#define USIC_CH_DX4CR_CM_Pos                  (10UL)                    /*!< USIC_CH DX4CR: CM (Bit 10)                                  */
#define USIC_CH_DX4CR_CM_Msk                  (0xc00UL)                 /*!< USIC_CH DX4CR: CM (Bitfield-Mask: 0x03)                     */
#define USIC_CH_DX4CR_DXS_Pos                 (15UL)                    /*!< USIC_CH DX4CR: DXS (Bit 15)                                 */
#define USIC_CH_DX4CR_DXS_Msk                 (0x8000UL)                /*!< USIC_CH DX4CR: DXS (Bitfield-Mask: 0x01)                    */

/* --------------------------------  USIC_CH_DX5CR  ------------------------------- */
#define USIC_CH_DX5CR_DSEL_Pos                (0UL)                     /*!< USIC_CH DX5CR: DSEL (Bit 0)                                 */
#define USIC_CH_DX5CR_DSEL_Msk                (0x7UL)                   /*!< USIC_CH DX5CR: DSEL (Bitfield-Mask: 0x07)                   */
#define USIC_CH_DX5CR_INSW_Pos                (4UL)                     /*!< USIC_CH DX5CR: INSW (Bit 4)                                 */
#define USIC_CH_DX5CR_INSW_Msk                (0x10UL)                  /*!< USIC_CH DX5CR: INSW (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX5CR_DFEN_Pos                (5UL)                     /*!< USIC_CH DX5CR: DFEN (Bit 5)                                 */
#define USIC_CH_DX5CR_DFEN_Msk                (0x20UL)                  /*!< USIC_CH DX5CR: DFEN (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX5CR_DSEN_Pos                (6UL)                     /*!< USIC_CH DX5CR: DSEN (Bit 6)                                 */
#define USIC_CH_DX5CR_DSEN_Msk                (0x40UL)                  /*!< USIC_CH DX5CR: DSEN (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX5CR_DPOL_Pos                (8UL)                     /*!< USIC_CH DX5CR: DPOL (Bit 8)                                 */
#define USIC_CH_DX5CR_DPOL_Msk                (0x100UL)                 /*!< USIC_CH DX5CR: DPOL (Bitfield-Mask: 0x01)                   */
#define USIC_CH_DX5CR_SFSEL_Pos               (9UL)                     /*!< USIC_CH DX5CR: SFSEL (Bit 9)                                */
#define USIC_CH_DX5CR_SFSEL_Msk               (0x200UL)                 /*!< USIC_CH DX5CR: SFSEL (Bitfield-Mask: 0x01)                  */
#define USIC_CH_DX5CR_CM_Pos                  (10UL)                    /*!< USIC_CH DX5CR: CM (Bit 10)                                  */
#define USIC_CH_DX5CR_CM_Msk                  (0xc00UL)                 /*!< USIC_CH DX5CR: CM (Bitfield-Mask: 0x03)                     */
#define USIC_CH_DX5CR_DXS_Pos                 (15UL)                    /*!< USIC_CH DX5CR: DXS (Bit 15)                                 */
#define USIC_CH_DX5CR_DXS_Msk                 (0x8000UL)                /*!< USIC_CH DX5CR: DXS (Bitfield-Mask: 0x01)                    */

/* --------------------------------  USIC_CH_SCTR  -------------------------------- */
#define USIC_CH_SCTR_SDIR_Pos                 (0UL)                     /*!< USIC_CH SCTR: SDIR (Bit 0)                                  */
#define USIC_CH_SCTR_SDIR_Msk                 (0x1UL)                   /*!< USIC_CH SCTR: SDIR (Bitfield-Mask: 0x01)                    */
#define USIC_CH_SCTR_PDL_Pos                  (1UL)                     /*!< USIC_CH SCTR: PDL (Bit 1)                                   */
#define USIC_CH_SCTR_PDL_Msk                  (0x2UL)                   /*!< USIC_CH SCTR: PDL (Bitfield-Mask: 0x01)                     */
#define USIC_CH_SCTR_DSM_Pos                  (2UL)                     /*!< USIC_CH SCTR: DSM (Bit 2)                                   */
#define USIC_CH_SCTR_DSM_Msk                  (0xcUL)                   /*!< USIC_CH SCTR: DSM (Bitfield-Mask: 0x03)                     */
#define USIC_CH_SCTR_HPCDIR_Pos               (4UL)                     /*!< USIC_CH SCTR: HPCDIR (Bit 4)                                */
#define USIC_CH_SCTR_HPCDIR_Msk               (0x10UL)                  /*!< USIC_CH SCTR: HPCDIR (Bitfield-Mask: 0x01)                  */
#define USIC_CH_SCTR_DOCFG_Pos                (6UL)                     /*!< USIC_CH SCTR: DOCFG (Bit 6)                                 */
#define USIC_CH_SCTR_DOCFG_Msk                (0xc0UL)                  /*!< USIC_CH SCTR: DOCFG (Bitfield-Mask: 0x03)                   */
#define USIC_CH_SCTR_TRM_Pos                  (8UL)                     /*!< USIC_CH SCTR: TRM (Bit 8)                                   */
#define USIC_CH_SCTR_TRM_Msk                  (0x300UL)                 /*!< USIC_CH SCTR: TRM (Bitfield-Mask: 0x03)                     */
#define USIC_CH_SCTR_FLE_Pos                  (16UL)                    /*!< USIC_CH SCTR: FLE (Bit 16)                                  */
#define USIC_CH_SCTR_FLE_Msk                  (0x3f0000UL)              /*!< USIC_CH SCTR: FLE (Bitfield-Mask: 0x3f)                     */
#define USIC_CH_SCTR_WLE_Pos                  (24UL)                    /*!< USIC_CH SCTR: WLE (Bit 24)                                  */
#define USIC_CH_SCTR_WLE_Msk                  (0xf000000UL)             /*!< USIC_CH SCTR: WLE (Bitfield-Mask: 0x0f)                     */

/* --------------------------------  USIC_CH_TCSR  -------------------------------- */
#define USIC_CH_TCSR_WLEMD_Pos                (0UL)                     /*!< USIC_CH TCSR: WLEMD (Bit 0)                                 */
#define USIC_CH_TCSR_WLEMD_Msk                (0x1UL)                   /*!< USIC_CH TCSR: WLEMD (Bitfield-Mask: 0x01)                   */
#define USIC_CH_TCSR_SELMD_Pos                (1UL)                     /*!< USIC_CH TCSR: SELMD (Bit 1)                                 */
#define USIC_CH_TCSR_SELMD_Msk                (0x2UL)                   /*!< USIC_CH TCSR: SELMD (Bitfield-Mask: 0x01)                   */
#define USIC_CH_TCSR_FLEMD_Pos                (2UL)                     /*!< USIC_CH TCSR: FLEMD (Bit 2)                                 */
#define USIC_CH_TCSR_FLEMD_Msk                (0x4UL)                   /*!< USIC_CH TCSR: FLEMD (Bitfield-Mask: 0x01)                   */
#define USIC_CH_TCSR_WAMD_Pos                 (3UL)                     /*!< USIC_CH TCSR: WAMD (Bit 3)                                  */
#define USIC_CH_TCSR_WAMD_Msk                 (0x8UL)                   /*!< USIC_CH TCSR: WAMD (Bitfield-Mask: 0x01)                    */
#define USIC_CH_TCSR_HPCMD_Pos                (4UL)                     /*!< USIC_CH TCSR: HPCMD (Bit 4)                                 */
#define USIC_CH_TCSR_HPCMD_Msk                (0x10UL)                  /*!< USIC_CH TCSR: HPCMD (Bitfield-Mask: 0x01)                   */
#define USIC_CH_TCSR_SOF_Pos                  (5UL)                     /*!< USIC_CH TCSR: SOF (Bit 5)                                   */
#define USIC_CH_TCSR_SOF_Msk                  (0x20UL)                  /*!< USIC_CH TCSR: SOF (Bitfield-Mask: 0x01)                     */
#define USIC_CH_TCSR_EOF_Pos                  (6UL)                     /*!< USIC_CH TCSR: EOF (Bit 6)                                   */
#define USIC_CH_TCSR_EOF_Msk                  (0x40UL)                  /*!< USIC_CH TCSR: EOF (Bitfield-Mask: 0x01)                     */
#define USIC_CH_TCSR_TDV_Pos                  (7UL)                     /*!< USIC_CH TCSR: TDV (Bit 7)                                   */
#define USIC_CH_TCSR_TDV_Msk                  (0x80UL)                  /*!< USIC_CH TCSR: TDV (Bitfield-Mask: 0x01)                     */
#define USIC_CH_TCSR_TDSSM_Pos                (8UL)                     /*!< USIC_CH TCSR: TDSSM (Bit 8)                                 */
#define USIC_CH_TCSR_TDSSM_Msk                (0x100UL)                 /*!< USIC_CH TCSR: TDSSM (Bitfield-Mask: 0x01)                   */
#define USIC_CH_TCSR_TDEN_Pos                 (10UL)                    /*!< USIC_CH TCSR: TDEN (Bit 10)                                 */
#define USIC_CH_TCSR_TDEN_Msk                 (0xc00UL)                 /*!< USIC_CH TCSR: TDEN (Bitfield-Mask: 0x03)                    */
#define USIC_CH_TCSR_TDVTR_Pos                (12UL)                    /*!< USIC_CH TCSR: TDVTR (Bit 12)                                */
#define USIC_CH_TCSR_TDVTR_Msk                (0x1000UL)                /*!< USIC_CH TCSR: TDVTR (Bitfield-Mask: 0x01)                   */
#define USIC_CH_TCSR_WA_Pos                   (13UL)                    /*!< USIC_CH TCSR: WA (Bit 13)                                   */
#define USIC_CH_TCSR_WA_Msk                   (0x2000UL)                /*!< USIC_CH TCSR: WA (Bitfield-Mask: 0x01)                      */
#define USIC_CH_TCSR_TSOF_Pos                 (24UL)                    /*!< USIC_CH TCSR: TSOF (Bit 24)                                 */
#define USIC_CH_TCSR_TSOF_Msk                 (0x1000000UL)             /*!< USIC_CH TCSR: TSOF (Bitfield-Mask: 0x01)                    */
#define USIC_CH_TCSR_TV_Pos                   (26UL)                    /*!< USIC_CH TCSR: TV (Bit 26)                                   */
#define USIC_CH_TCSR_TV_Msk                   (0x4000000UL)             /*!< USIC_CH TCSR: TV (Bitfield-Mask: 0x01)                      */
#define USIC_CH_TCSR_TVC_Pos                  (27UL)                    /*!< USIC_CH TCSR: TVC (Bit 27)                                  */
#define USIC_CH_TCSR_TVC_Msk                  (0x8000000UL)             /*!< USIC_CH TCSR: TVC (Bitfield-Mask: 0x01)                     */
#define USIC_CH_TCSR_TE_Pos                   (28UL)                    /*!< USIC_CH TCSR: TE (Bit 28)                                   */
#define USIC_CH_TCSR_TE_Msk                   (0x10000000UL)            /*!< USIC_CH TCSR: TE (Bitfield-Mask: 0x01)                      */

/* ---------------------------------  USIC_CH_PCR  -------------------------------- */
#define USIC_CH_PCR_CTR0_Pos                  (0UL)                     /*!< USIC_CH PCR: CTR0 (Bit 0)                                   */
#define USIC_CH_PCR_CTR0_Msk                  (0x1UL)                   /*!< USIC_CH PCR: CTR0 (Bitfield-Mask: 0x01)                     */
#define USIC_CH_PCR_CTR1_Pos                  (1UL)                     /*!< USIC_CH PCR: CTR1 (Bit 1)                                   */
#define USIC_CH_PCR_CTR1_Msk                  (0x2UL)                   /*!< USIC_CH PCR: CTR1 (Bitfield-Mask: 0x01)                     */
#define USIC_CH_PCR_CTR2_Pos                  (2UL)                     /*!< USIC_CH PCR: CTR2 (Bit 2)                                   */
#define USIC_CH_PCR_CTR2_Msk                  (0x4UL)                   /*!< USIC_CH PCR: CTR2 (Bitfield-Mask: 0x01)                     */
#define USIC_CH_PCR_CTR3_Pos                  (3UL)                     /*!< USIC_CH PCR: CTR3 (Bit 3)                                   */
#define USIC_CH_PCR_CTR3_Msk                  (0x8UL)                   /*!< USIC_CH PCR: CTR3 (Bitfield-Mask: 0x01)                     */
#define USIC_CH_PCR_CTR4_Pos                  (4UL)                     /*!< USIC_CH PCR: CTR4 (Bit 4)                                   */
#define USIC_CH_PCR_CTR4_Msk                  (0x10UL)                  /*!< USIC_CH PCR: CTR4 (Bitfield-Mask: 0x01)                     */
#define USIC_CH_PCR_CTR5_Pos                  (5UL)                     /*!< USIC_CH PCR: CTR5 (Bit 5)                                   */
#define USIC_CH_PCR_CTR5_Msk                  (0x20UL)                  /*!< USIC_CH PCR: CTR5 (Bitfield-Mask: 0x01)                     */
#define USIC_CH_PCR_CTR6_Pos                  (6UL)                     /*!< USIC_CH PCR: CTR6 (Bit 6)                                   */
#define USIC_CH_PCR_CTR6_Msk                  (0x40UL)                  /*!< USIC_CH PCR: CTR6 (Bitfield-Mask: 0x01)                     */
#define USIC_CH_PCR_CTR7_Pos                  (7UL)                     /*!< USIC_CH PCR: CTR7 (Bit 7)                                   */
#define USIC_CH_PCR_CTR7_Msk                  (0x80UL)                  /*!< USIC_CH PCR: CTR7 (Bitfield-Mask: 0x01)                     */
#define USIC_CH_PCR_CTR8_Pos                  (8UL)                     /*!< USIC_CH PCR: CTR8 (Bit 8)                                   */
#define USIC_CH_PCR_CTR8_Msk                  (0x100UL)                 /*!< USIC_CH PCR: CTR8 (Bitfield-Mask: 0x01)                     */
#define USIC_CH_PCR_CTR9_Pos                  (9UL)                     /*!< USIC_CH PCR: CTR9 (Bit 9)                                   */
#define USIC_CH_PCR_CTR9_Msk                  (0x200UL)                 /*!< USIC_CH PCR: CTR9 (Bitfield-Mask: 0x01)                     */
#define USIC_CH_PCR_CTR10_Pos                 (10UL)                    /*!< USIC_CH PCR: CTR10 (Bit 10)                                 */
#define USIC_CH_PCR_CTR10_Msk                 (0x400UL)                 /*!< USIC_CH PCR: CTR10 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR11_Pos                 (11UL)                    /*!< USIC_CH PCR: CTR11 (Bit 11)                                 */
#define USIC_CH_PCR_CTR11_Msk                 (0x800UL)                 /*!< USIC_CH PCR: CTR11 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR12_Pos                 (12UL)                    /*!< USIC_CH PCR: CTR12 (Bit 12)                                 */
#define USIC_CH_PCR_CTR12_Msk                 (0x1000UL)                /*!< USIC_CH PCR: CTR12 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR13_Pos                 (13UL)                    /*!< USIC_CH PCR: CTR13 (Bit 13)                                 */
#define USIC_CH_PCR_CTR13_Msk                 (0x2000UL)                /*!< USIC_CH PCR: CTR13 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR14_Pos                 (14UL)                    /*!< USIC_CH PCR: CTR14 (Bit 14)                                 */
#define USIC_CH_PCR_CTR14_Msk                 (0x4000UL)                /*!< USIC_CH PCR: CTR14 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR15_Pos                 (15UL)                    /*!< USIC_CH PCR: CTR15 (Bit 15)                                 */
#define USIC_CH_PCR_CTR15_Msk                 (0x8000UL)                /*!< USIC_CH PCR: CTR15 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR16_Pos                 (16UL)                    /*!< USIC_CH PCR: CTR16 (Bit 16)                                 */
#define USIC_CH_PCR_CTR16_Msk                 (0x10000UL)               /*!< USIC_CH PCR: CTR16 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR17_Pos                 (17UL)                    /*!< USIC_CH PCR: CTR17 (Bit 17)                                 */
#define USIC_CH_PCR_CTR17_Msk                 (0x20000UL)               /*!< USIC_CH PCR: CTR17 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR18_Pos                 (18UL)                    /*!< USIC_CH PCR: CTR18 (Bit 18)                                 */
#define USIC_CH_PCR_CTR18_Msk                 (0x40000UL)               /*!< USIC_CH PCR: CTR18 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR19_Pos                 (19UL)                    /*!< USIC_CH PCR: CTR19 (Bit 19)                                 */
#define USIC_CH_PCR_CTR19_Msk                 (0x80000UL)               /*!< USIC_CH PCR: CTR19 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR20_Pos                 (20UL)                    /*!< USIC_CH PCR: CTR20 (Bit 20)                                 */
#define USIC_CH_PCR_CTR20_Msk                 (0x100000UL)              /*!< USIC_CH PCR: CTR20 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR21_Pos                 (21UL)                    /*!< USIC_CH PCR: CTR21 (Bit 21)                                 */
#define USIC_CH_PCR_CTR21_Msk                 (0x200000UL)              /*!< USIC_CH PCR: CTR21 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR22_Pos                 (22UL)                    /*!< USIC_CH PCR: CTR22 (Bit 22)                                 */
#define USIC_CH_PCR_CTR22_Msk                 (0x400000UL)              /*!< USIC_CH PCR: CTR22 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR23_Pos                 (23UL)                    /*!< USIC_CH PCR: CTR23 (Bit 23)                                 */
#define USIC_CH_PCR_CTR23_Msk                 (0x800000UL)              /*!< USIC_CH PCR: CTR23 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR24_Pos                 (24UL)                    /*!< USIC_CH PCR: CTR24 (Bit 24)                                 */
#define USIC_CH_PCR_CTR24_Msk                 (0x1000000UL)             /*!< USIC_CH PCR: CTR24 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR25_Pos                 (25UL)                    /*!< USIC_CH PCR: CTR25 (Bit 25)                                 */
#define USIC_CH_PCR_CTR25_Msk                 (0x2000000UL)             /*!< USIC_CH PCR: CTR25 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR26_Pos                 (26UL)                    /*!< USIC_CH PCR: CTR26 (Bit 26)                                 */
#define USIC_CH_PCR_CTR26_Msk                 (0x4000000UL)             /*!< USIC_CH PCR: CTR26 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR27_Pos                 (27UL)                    /*!< USIC_CH PCR: CTR27 (Bit 27)                                 */
#define USIC_CH_PCR_CTR27_Msk                 (0x8000000UL)             /*!< USIC_CH PCR: CTR27 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR28_Pos                 (28UL)                    /*!< USIC_CH PCR: CTR28 (Bit 28)                                 */
#define USIC_CH_PCR_CTR28_Msk                 (0x10000000UL)            /*!< USIC_CH PCR: CTR28 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR29_Pos                 (29UL)                    /*!< USIC_CH PCR: CTR29 (Bit 29)                                 */
#define USIC_CH_PCR_CTR29_Msk                 (0x20000000UL)            /*!< USIC_CH PCR: CTR29 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR30_Pos                 (30UL)                    /*!< USIC_CH PCR: CTR30 (Bit 30)                                 */
#define USIC_CH_PCR_CTR30_Msk                 (0x40000000UL)            /*!< USIC_CH PCR: CTR30 (Bitfield-Mask: 0x01)                    */
#define USIC_CH_PCR_CTR31_Pos                 (31UL)                    /*!< USIC_CH PCR: CTR31 (Bit 31)                                 */
#define USIC_CH_PCR_CTR31_Msk                 (0x80000000UL)            /*!< USIC_CH PCR: CTR31 (Bitfield-Mask: 0x01)                    */

/* -----------------------------  USIC_CH_PCR_ASCMode  ---------------------------- */
#define USIC_CH_PCR_ASCMode_SMD_Pos           (0UL)                     /*!< USIC_CH PCR_ASCMode: SMD (Bit 0)                            */
#define USIC_CH_PCR_ASCMode_SMD_Msk           (0x1UL)                   /*!< USIC_CH PCR_ASCMode: SMD (Bitfield-Mask: 0x01)              */
#define USIC_CH_PCR_ASCMode_STPB_Pos          (1UL)                     /*!< USIC_CH PCR_ASCMode: STPB (Bit 1)                           */
#define USIC_CH_PCR_ASCMode_STPB_Msk          (0x2UL)                   /*!< USIC_CH PCR_ASCMode: STPB (Bitfield-Mask: 0x01)             */
#define USIC_CH_PCR_ASCMode_IDM_Pos           (2UL)                     /*!< USIC_CH PCR_ASCMode: IDM (Bit 2)                            */
#define USIC_CH_PCR_ASCMode_IDM_Msk           (0x4UL)                   /*!< USIC_CH PCR_ASCMode: IDM (Bitfield-Mask: 0x01)              */
#define USIC_CH_PCR_ASCMode_SBIEN_Pos         (3UL)                     /*!< USIC_CH PCR_ASCMode: SBIEN (Bit 3)                          */
#define USIC_CH_PCR_ASCMode_SBIEN_Msk         (0x8UL)                   /*!< USIC_CH PCR_ASCMode: SBIEN (Bitfield-Mask: 0x01)            */
#define USIC_CH_PCR_ASCMode_CDEN_Pos          (4UL)                     /*!< USIC_CH PCR_ASCMode: CDEN (Bit 4)                           */
#define USIC_CH_PCR_ASCMode_CDEN_Msk          (0x10UL)                  /*!< USIC_CH PCR_ASCMode: CDEN (Bitfield-Mask: 0x01)             */
#define USIC_CH_PCR_ASCMode_RNIEN_Pos         (5UL)                     /*!< USIC_CH PCR_ASCMode: RNIEN (Bit 5)                          */
#define USIC_CH_PCR_ASCMode_RNIEN_Msk         (0x20UL)                  /*!< USIC_CH PCR_ASCMode: RNIEN (Bitfield-Mask: 0x01)            */
#define USIC_CH_PCR_ASCMode_FEIEN_Pos         (6UL)                     /*!< USIC_CH PCR_ASCMode: FEIEN (Bit 6)                          */
#define USIC_CH_PCR_ASCMode_FEIEN_Msk         (0x40UL)                  /*!< USIC_CH PCR_ASCMode: FEIEN (Bitfield-Mask: 0x01)            */
#define USIC_CH_PCR_ASCMode_FFIEN_Pos         (7UL)                     /*!< USIC_CH PCR_ASCMode: FFIEN (Bit 7)                          */
#define USIC_CH_PCR_ASCMode_FFIEN_Msk         (0x80UL)                  /*!< USIC_CH PCR_ASCMode: FFIEN (Bitfield-Mask: 0x01)            */
#define USIC_CH_PCR_ASCMode_SP_Pos            (8UL)                     /*!< USIC_CH PCR_ASCMode: SP (Bit 8)                             */
#define USIC_CH_PCR_ASCMode_SP_Msk            (0x1f00UL)                /*!< USIC_CH PCR_ASCMode: SP (Bitfield-Mask: 0x1f)               */
#define USIC_CH_PCR_ASCMode_PL_Pos            (13UL)                    /*!< USIC_CH PCR_ASCMode: PL (Bit 13)                            */
#define USIC_CH_PCR_ASCMode_PL_Msk            (0xe000UL)                /*!< USIC_CH PCR_ASCMode: PL (Bitfield-Mask: 0x07)               */
#define USIC_CH_PCR_ASCMode_RSTEN_Pos         (16UL)                    /*!< USIC_CH PCR_ASCMode: RSTEN (Bit 16)                         */
#define USIC_CH_PCR_ASCMode_RSTEN_Msk         (0x10000UL)               /*!< USIC_CH PCR_ASCMode: RSTEN (Bitfield-Mask: 0x01)            */
#define USIC_CH_PCR_ASCMode_TSTEN_Pos         (17UL)                    /*!< USIC_CH PCR_ASCMode: TSTEN (Bit 17)                         */
#define USIC_CH_PCR_ASCMode_TSTEN_Msk         (0x20000UL)               /*!< USIC_CH PCR_ASCMode: TSTEN (Bitfield-Mask: 0x01)            */
#define USIC_CH_PCR_ASCMode_MCLK_Pos          (31UL)                    /*!< USIC_CH PCR_ASCMode: MCLK (Bit 31)                          */
#define USIC_CH_PCR_ASCMode_MCLK_Msk          (0x80000000UL)            /*!< USIC_CH PCR_ASCMode: MCLK (Bitfield-Mask: 0x01)             */

/* -----------------------------  USIC_CH_PCR_SSCMode  ---------------------------- */
#define USIC_CH_PCR_SSCMode_MSLSEN_Pos        (0UL)                     /*!< USIC_CH PCR_SSCMode: MSLSEN (Bit 0)                         */
#define USIC_CH_PCR_SSCMode_MSLSEN_Msk        (0x1UL)                   /*!< USIC_CH PCR_SSCMode: MSLSEN (Bitfield-Mask: 0x01)           */
#define USIC_CH_PCR_SSCMode_SELCTR_Pos        (1UL)                     /*!< USIC_CH PCR_SSCMode: SELCTR (Bit 1)                         */
#define USIC_CH_PCR_SSCMode_SELCTR_Msk        (0x2UL)                   /*!< USIC_CH PCR_SSCMode: SELCTR (Bitfield-Mask: 0x01)           */
#define USIC_CH_PCR_SSCMode_SELINV_Pos        (2UL)                     /*!< USIC_CH PCR_SSCMode: SELINV (Bit 2)                         */
#define USIC_CH_PCR_SSCMode_SELINV_Msk        (0x4UL)                   /*!< USIC_CH PCR_SSCMode: SELINV (Bitfield-Mask: 0x01)           */
#define USIC_CH_PCR_SSCMode_FEM_Pos           (3UL)                     /*!< USIC_CH PCR_SSCMode: FEM (Bit 3)                            */
#define USIC_CH_PCR_SSCMode_FEM_Msk           (0x8UL)                   /*!< USIC_CH PCR_SSCMode: FEM (Bitfield-Mask: 0x01)              */
#define USIC_CH_PCR_SSCMode_CTQSEL1_Pos       (4UL)                     /*!< USIC_CH PCR_SSCMode: CTQSEL1 (Bit 4)                        */
#define USIC_CH_PCR_SSCMode_CTQSEL1_Msk       (0x30UL)                  /*!< USIC_CH PCR_SSCMode: CTQSEL1 (Bitfield-Mask: 0x03)          */
#define USIC_CH_PCR_SSCMode_PCTQ1_Pos         (6UL)                     /*!< USIC_CH PCR_SSCMode: PCTQ1 (Bit 6)                          */
#define USIC_CH_PCR_SSCMode_PCTQ1_Msk         (0xc0UL)                  /*!< USIC_CH PCR_SSCMode: PCTQ1 (Bitfield-Mask: 0x03)            */
#define USIC_CH_PCR_SSCMode_DCTQ1_Pos         (8UL)                     /*!< USIC_CH PCR_SSCMode: DCTQ1 (Bit 8)                          */
#define USIC_CH_PCR_SSCMode_DCTQ1_Msk         (0x1f00UL)                /*!< USIC_CH PCR_SSCMode: DCTQ1 (Bitfield-Mask: 0x1f)            */
#define USIC_CH_PCR_SSCMode_PARIEN_Pos        (13UL)                    /*!< USIC_CH PCR_SSCMode: PARIEN (Bit 13)                        */
#define USIC_CH_PCR_SSCMode_PARIEN_Msk        (0x2000UL)                /*!< USIC_CH PCR_SSCMode: PARIEN (Bitfield-Mask: 0x01)           */
#define USIC_CH_PCR_SSCMode_MSLSIEN_Pos       (14UL)                    /*!< USIC_CH PCR_SSCMode: MSLSIEN (Bit 14)                       */
#define USIC_CH_PCR_SSCMode_MSLSIEN_Msk       (0x4000UL)                /*!< USIC_CH PCR_SSCMode: MSLSIEN (Bitfield-Mask: 0x01)          */
#define USIC_CH_PCR_SSCMode_DX2TIEN_Pos       (15UL)                    /*!< USIC_CH PCR_SSCMode: DX2TIEN (Bit 15)                       */
#define USIC_CH_PCR_SSCMode_DX2TIEN_Msk       (0x8000UL)                /*!< USIC_CH PCR_SSCMode: DX2TIEN (Bitfield-Mask: 0x01)          */
#define USIC_CH_PCR_SSCMode_SELO_Pos          (16UL)                    /*!< USIC_CH PCR_SSCMode: SELO (Bit 16)                          */
#define USIC_CH_PCR_SSCMode_SELO_Msk          (0xff0000UL)              /*!< USIC_CH PCR_SSCMode: SELO (Bitfield-Mask: 0xff)             */
#define USIC_CH_PCR_SSCMode_TIWEN_Pos         (24UL)                    /*!< USIC_CH PCR_SSCMode: TIWEN (Bit 24)                         */
#define USIC_CH_PCR_SSCMode_TIWEN_Msk         (0x1000000UL)             /*!< USIC_CH PCR_SSCMode: TIWEN (Bitfield-Mask: 0x01)            */
#define USIC_CH_PCR_SSCMode_SLPHSEL_Pos       (25UL)                    /*!< USIC_CH PCR_SSCMode: SLPHSEL (Bit 25)                       */
#define USIC_CH_PCR_SSCMode_SLPHSEL_Msk       (0x2000000UL)             /*!< USIC_CH PCR_SSCMode: SLPHSEL (Bitfield-Mask: 0x01)          */
#define USIC_CH_PCR_SSCMode_MCLK_Pos          (31UL)                    /*!< USIC_CH PCR_SSCMode: MCLK (Bit 31)                          */
#define USIC_CH_PCR_SSCMode_MCLK_Msk          (0x80000000UL)            /*!< USIC_CH PCR_SSCMode: MCLK (Bitfield-Mask: 0x01)             */

/* -----------------------------  USIC_CH_PCR_IICMode  ---------------------------- */
#define USIC_CH_PCR_IICMode_SLAD_Pos          (0UL)                     /*!< USIC_CH PCR_IICMode: SLAD (Bit 0)                           */
#define USIC_CH_PCR_IICMode_SLAD_Msk          (0xffffUL)                /*!< USIC_CH PCR_IICMode: SLAD (Bitfield-Mask: 0xffff)           */
#define USIC_CH_PCR_IICMode_ACK00_Pos         (16UL)                    /*!< USIC_CH PCR_IICMode: ACK00 (Bit 16)                         */
#define USIC_CH_PCR_IICMode_ACK00_Msk         (0x10000UL)               /*!< USIC_CH PCR_IICMode: ACK00 (Bitfield-Mask: 0x01)            */
#define USIC_CH_PCR_IICMode_STIM_Pos          (17UL)                    /*!< USIC_CH PCR_IICMode: STIM (Bit 17)                          */
#define USIC_CH_PCR_IICMode_STIM_Msk          (0x20000UL)               /*!< USIC_CH PCR_IICMode: STIM (Bitfield-Mask: 0x01)             */
#define USIC_CH_PCR_IICMode_SCRIEN_Pos        (18UL)                    /*!< USIC_CH PCR_IICMode: SCRIEN (Bit 18)                        */
#define USIC_CH_PCR_IICMode_SCRIEN_Msk        (0x40000UL)               /*!< USIC_CH PCR_IICMode: SCRIEN (Bitfield-Mask: 0x01)           */
#define USIC_CH_PCR_IICMode_RSCRIEN_Pos       (19UL)                    /*!< USIC_CH PCR_IICMode: RSCRIEN (Bit 19)                       */
#define USIC_CH_PCR_IICMode_RSCRIEN_Msk       (0x80000UL)               /*!< USIC_CH PCR_IICMode: RSCRIEN (Bitfield-Mask: 0x01)          */
#define USIC_CH_PCR_IICMode_PCRIEN_Pos        (20UL)                    /*!< USIC_CH PCR_IICMode: PCRIEN (Bit 20)                        */
#define USIC_CH_PCR_IICMode_PCRIEN_Msk        (0x100000UL)              /*!< USIC_CH PCR_IICMode: PCRIEN (Bitfield-Mask: 0x01)           */
#define USIC_CH_PCR_IICMode_NACKIEN_Pos       (21UL)                    /*!< USIC_CH PCR_IICMode: NACKIEN (Bit 21)                       */
#define USIC_CH_PCR_IICMode_NACKIEN_Msk       (0x200000UL)              /*!< USIC_CH PCR_IICMode: NACKIEN (Bitfield-Mask: 0x01)          */
#define USIC_CH_PCR_IICMode_ARLIEN_Pos        (22UL)                    /*!< USIC_CH PCR_IICMode: ARLIEN (Bit 22)                        */
#define USIC_CH_PCR_IICMode_ARLIEN_Msk        (0x400000UL)              /*!< USIC_CH PCR_IICMode: ARLIEN (Bitfield-Mask: 0x01)           */
#define USIC_CH_PCR_IICMode_SRRIEN_Pos        (23UL)                    /*!< USIC_CH PCR_IICMode: SRRIEN (Bit 23)                        */
#define USIC_CH_PCR_IICMode_SRRIEN_Msk        (0x800000UL)              /*!< USIC_CH PCR_IICMode: SRRIEN (Bitfield-Mask: 0x01)           */
#define USIC_CH_PCR_IICMode_ERRIEN_Pos        (24UL)                    /*!< USIC_CH PCR_IICMode: ERRIEN (Bit 24)                        */
#define USIC_CH_PCR_IICMode_ERRIEN_Msk        (0x1000000UL)             /*!< USIC_CH PCR_IICMode: ERRIEN (Bitfield-Mask: 0x01)           */
#define USIC_CH_PCR_IICMode_SACKDIS_Pos       (25UL)                    /*!< USIC_CH PCR_IICMode: SACKDIS (Bit 25)                       */
#define USIC_CH_PCR_IICMode_SACKDIS_Msk       (0x2000000UL)             /*!< USIC_CH PCR_IICMode: SACKDIS (Bitfield-Mask: 0x01)          */
#define USIC_CH_PCR_IICMode_HDEL_Pos          (26UL)                    /*!< USIC_CH PCR_IICMode: HDEL (Bit 26)                          */
#define USIC_CH_PCR_IICMode_HDEL_Msk          (0x3c000000UL)            /*!< USIC_CH PCR_IICMode: HDEL (Bitfield-Mask: 0x0f)             */
#define USIC_CH_PCR_IICMode_ACKIEN_Pos        (30UL)                    /*!< USIC_CH PCR_IICMode: ACKIEN (Bit 30)                        */
#define USIC_CH_PCR_IICMode_ACKIEN_Msk        (0x40000000UL)            /*!< USIC_CH PCR_IICMode: ACKIEN (Bitfield-Mask: 0x01)           */
#define USIC_CH_PCR_IICMode_MCLK_Pos          (31UL)                    /*!< USIC_CH PCR_IICMode: MCLK (Bit 31)                          */
#define USIC_CH_PCR_IICMode_MCLK_Msk          (0x80000000UL)            /*!< USIC_CH PCR_IICMode: MCLK (Bitfield-Mask: 0x01)             */

/* -----------------------------  USIC_CH_PCR_IISMode  ---------------------------- */
#define USIC_CH_PCR_IISMode_WAGEN_Pos         (0UL)                     /*!< USIC_CH PCR_IISMode: WAGEN (Bit 0)                          */
#define USIC_CH_PCR_IISMode_WAGEN_Msk         (0x1UL)                   /*!< USIC_CH PCR_IISMode: WAGEN (Bitfield-Mask: 0x01)            */
#define USIC_CH_PCR_IISMode_DTEN_Pos          (1UL)                     /*!< USIC_CH PCR_IISMode: DTEN (Bit 1)                           */
#define USIC_CH_PCR_IISMode_DTEN_Msk          (0x2UL)                   /*!< USIC_CH PCR_IISMode: DTEN (Bitfield-Mask: 0x01)             */
#define USIC_CH_PCR_IISMode_SELINV_Pos        (2UL)                     /*!< USIC_CH PCR_IISMode: SELINV (Bit 2)                         */
#define USIC_CH_PCR_IISMode_SELINV_Msk        (0x4UL)                   /*!< USIC_CH PCR_IISMode: SELINV (Bitfield-Mask: 0x01)           */
#define USIC_CH_PCR_IISMode_WAFEIEN_Pos       (4UL)                     /*!< USIC_CH PCR_IISMode: WAFEIEN (Bit 4)                        */
#define USIC_CH_PCR_IISMode_WAFEIEN_Msk       (0x10UL)                  /*!< USIC_CH PCR_IISMode: WAFEIEN (Bitfield-Mask: 0x01)          */
#define USIC_CH_PCR_IISMode_WAREIEN_Pos       (5UL)                     /*!< USIC_CH PCR_IISMode: WAREIEN (Bit 5)                        */
#define USIC_CH_PCR_IISMode_WAREIEN_Msk       (0x20UL)                  /*!< USIC_CH PCR_IISMode: WAREIEN (Bitfield-Mask: 0x01)          */
#define USIC_CH_PCR_IISMode_ENDIEN_Pos        (6UL)                     /*!< USIC_CH PCR_IISMode: ENDIEN (Bit 6)                         */
#define USIC_CH_PCR_IISMode_ENDIEN_Msk        (0x40UL)                  /*!< USIC_CH PCR_IISMode: ENDIEN (Bitfield-Mask: 0x01)           */
#define USIC_CH_PCR_IISMode_DX2TIEN_Pos       (15UL)                    /*!< USIC_CH PCR_IISMode: DX2TIEN (Bit 15)                       */
#define USIC_CH_PCR_IISMode_DX2TIEN_Msk       (0x8000UL)                /*!< USIC_CH PCR_IISMode: DX2TIEN (Bitfield-Mask: 0x01)          */
#define USIC_CH_PCR_IISMode_TDEL_Pos          (16UL)                    /*!< USIC_CH PCR_IISMode: TDEL (Bit 16)                          */
#define USIC_CH_PCR_IISMode_TDEL_Msk          (0x3f0000UL)              /*!< USIC_CH PCR_IISMode: TDEL (Bitfield-Mask: 0x3f)             */
#define USIC_CH_PCR_IISMode_MCLK_Pos          (31UL)                    /*!< USIC_CH PCR_IISMode: MCLK (Bit 31)                          */
#define USIC_CH_PCR_IISMode_MCLK_Msk          (0x80000000UL)            /*!< USIC_CH PCR_IISMode: MCLK (Bitfield-Mask: 0x01)             */

/* ---------------------------------  USIC_CH_CCR  -------------------------------- */
#define USIC_CH_CCR_MODE_Pos                  (0UL)                     /*!< USIC_CH CCR: MODE (Bit 0)                                   */
#define USIC_CH_CCR_MODE_Msk                  (0xfUL)                   /*!< USIC_CH CCR: MODE (Bitfield-Mask: 0x0f)                     */
#define USIC_CH_CCR_HPCEN_Pos                 (6UL)                     /*!< USIC_CH CCR: HPCEN (Bit 6)                                  */
#define USIC_CH_CCR_HPCEN_Msk                 (0xc0UL)                  /*!< USIC_CH CCR: HPCEN (Bitfield-Mask: 0x03)                    */
#define USIC_CH_CCR_PM_Pos                    (8UL)                     /*!< USIC_CH CCR: PM (Bit 8)                                     */
#define USIC_CH_CCR_PM_Msk                    (0x300UL)                 /*!< USIC_CH CCR: PM (Bitfield-Mask: 0x03)                       */
#define USIC_CH_CCR_RSIEN_Pos                 (10UL)                    /*!< USIC_CH CCR: RSIEN (Bit 10)                                 */
#define USIC_CH_CCR_RSIEN_Msk                 (0x400UL)                 /*!< USIC_CH CCR: RSIEN (Bitfield-Mask: 0x01)                    */
#define USIC_CH_CCR_DLIEN_Pos                 (11UL)                    /*!< USIC_CH CCR: DLIEN (Bit 11)                                 */
#define USIC_CH_CCR_DLIEN_Msk                 (0x800UL)                 /*!< USIC_CH CCR: DLIEN (Bitfield-Mask: 0x01)                    */
#define USIC_CH_CCR_TSIEN_Pos                 (12UL)                    /*!< USIC_CH CCR: TSIEN (Bit 12)                                 */
#define USIC_CH_CCR_TSIEN_Msk                 (0x1000UL)                /*!< USIC_CH CCR: TSIEN (Bitfield-Mask: 0x01)                    */
#define USIC_CH_CCR_TBIEN_Pos                 (13UL)                    /*!< USIC_CH CCR: TBIEN (Bit 13)                                 */
#define USIC_CH_CCR_TBIEN_Msk                 (0x2000UL)                /*!< USIC_CH CCR: TBIEN (Bitfield-Mask: 0x01)                    */
#define USIC_CH_CCR_RIEN_Pos                  (14UL)                    /*!< USIC_CH CCR: RIEN (Bit 14)                                  */
#define USIC_CH_CCR_RIEN_Msk                  (0x4000UL)                /*!< USIC_CH CCR: RIEN (Bitfield-Mask: 0x01)                     */
#define USIC_CH_CCR_AIEN_Pos                  (15UL)                    /*!< USIC_CH CCR: AIEN (Bit 15)                                  */
#define USIC_CH_CCR_AIEN_Msk                  (0x8000UL)                /*!< USIC_CH CCR: AIEN (Bitfield-Mask: 0x01)                     */
#define USIC_CH_CCR_BRGIEN_Pos                (16UL)                    /*!< USIC_CH CCR: BRGIEN (Bit 16)                                */
#define USIC_CH_CCR_BRGIEN_Msk                (0x10000UL)               /*!< USIC_CH CCR: BRGIEN (Bitfield-Mask: 0x01)                   */

/* --------------------------------  USIC_CH_CMTR  -------------------------------- */
#define USIC_CH_CMTR_CTV_Pos                  (0UL)                     /*!< USIC_CH CMTR: CTV (Bit 0)                                   */
#define USIC_CH_CMTR_CTV_Msk                  (0x3ffUL)                 /*!< USIC_CH CMTR: CTV (Bitfield-Mask: 0x3ff)                    */

/* ---------------------------------  USIC_CH_PSR  -------------------------------- */
#define USIC_CH_PSR_ST0_Pos                   (0UL)                     /*!< USIC_CH PSR: ST0 (Bit 0)                                    */
#define USIC_CH_PSR_ST0_Msk                   (0x1UL)                   /*!< USIC_CH PSR: ST0 (Bitfield-Mask: 0x01)                      */
#define USIC_CH_PSR_ST1_Pos                   (1UL)                     /*!< USIC_CH PSR: ST1 (Bit 1)                                    */
#define USIC_CH_PSR_ST1_Msk                   (0x2UL)                   /*!< USIC_CH PSR: ST1 (Bitfield-Mask: 0x01)                      */
#define USIC_CH_PSR_ST2_Pos                   (2UL)                     /*!< USIC_CH PSR: ST2 (Bit 2)                                    */
#define USIC_CH_PSR_ST2_Msk                   (0x4UL)                   /*!< USIC_CH PSR: ST2 (Bitfield-Mask: 0x01)                      */
#define USIC_CH_PSR_ST3_Pos                   (3UL)                     /*!< USIC_CH PSR: ST3 (Bit 3)                                    */
#define USIC_CH_PSR_ST3_Msk                   (0x8UL)                   /*!< USIC_CH PSR: ST3 (Bitfield-Mask: 0x01)                      */
#define USIC_CH_PSR_ST4_Pos                   (4UL)                     /*!< USIC_CH PSR: ST4 (Bit 4)                                    */
#define USIC_CH_PSR_ST4_Msk                   (0x10UL)                  /*!< USIC_CH PSR: ST4 (Bitfield-Mask: 0x01)                      */
#define USIC_CH_PSR_ST5_Pos                   (5UL)                     /*!< USIC_CH PSR: ST5 (Bit 5)                                    */
#define USIC_CH_PSR_ST5_Msk                   (0x20UL)                  /*!< USIC_CH PSR: ST5 (Bitfield-Mask: 0x01)                      */
#define USIC_CH_PSR_ST6_Pos                   (6UL)                     /*!< USIC_CH PSR: ST6 (Bit 6)                                    */
#define USIC_CH_PSR_ST6_Msk                   (0x40UL)                  /*!< USIC_CH PSR: ST6 (Bitfield-Mask: 0x01)                      */
#define USIC_CH_PSR_ST7_Pos                   (7UL)                     /*!< USIC_CH PSR: ST7 (Bit 7)                                    */
#define USIC_CH_PSR_ST7_Msk                   (0x80UL)                  /*!< USIC_CH PSR: ST7 (Bitfield-Mask: 0x01)                      */
#define USIC_CH_PSR_ST8_Pos                   (8UL)                     /*!< USIC_CH PSR: ST8 (Bit 8)                                    */
#define USIC_CH_PSR_ST8_Msk                   (0x100UL)                 /*!< USIC_CH PSR: ST8 (Bitfield-Mask: 0x01)                      */
#define USIC_CH_PSR_ST9_Pos                   (9UL)                     /*!< USIC_CH PSR: ST9 (Bit 9)                                    */
#define USIC_CH_PSR_ST9_Msk                   (0x200UL)                 /*!< USIC_CH PSR: ST9 (Bitfield-Mask: 0x01)                      */
#define USIC_CH_PSR_RSIF_Pos                  (10UL)                    /*!< USIC_CH PSR: RSIF (Bit 10)                                  */
#define USIC_CH_PSR_RSIF_Msk                  (0x400UL)                 /*!< USIC_CH PSR: RSIF (Bitfield-Mask: 0x01)                     */
#define USIC_CH_PSR_DLIF_Pos                  (11UL)                    /*!< USIC_CH PSR: DLIF (Bit 11)                                  */
#define USIC_CH_PSR_DLIF_Msk                  (0x800UL)                 /*!< USIC_CH PSR: DLIF (Bitfield-Mask: 0x01)                     */
#define USIC_CH_PSR_TSIF_Pos                  (12UL)                    /*!< USIC_CH PSR: TSIF (Bit 12)                                  */
#define USIC_CH_PSR_TSIF_Msk                  (0x1000UL)                /*!< USIC_CH PSR: TSIF (Bitfield-Mask: 0x01)                     */
#define USIC_CH_PSR_TBIF_Pos                  (13UL)                    /*!< USIC_CH PSR: TBIF (Bit 13)                                  */
#define USIC_CH_PSR_TBIF_Msk                  (0x2000UL)                /*!< USIC_CH PSR: TBIF (Bitfield-Mask: 0x01)                     */
#define USIC_CH_PSR_RIF_Pos                   (14UL)                    /*!< USIC_CH PSR: RIF (Bit 14)                                   */
#define USIC_CH_PSR_RIF_Msk                   (0x4000UL)                /*!< USIC_CH PSR: RIF (Bitfield-Mask: 0x01)                      */
#define USIC_CH_PSR_AIF_Pos                   (15UL)                    /*!< USIC_CH PSR: AIF (Bit 15)                                   */
#define USIC_CH_PSR_AIF_Msk                   (0x8000UL)                /*!< USIC_CH PSR: AIF (Bitfield-Mask: 0x01)                      */
#define USIC_CH_PSR_BRGIF_Pos                 (16UL)                    /*!< USIC_CH PSR: BRGIF (Bit 16)                                 */
#define USIC_CH_PSR_BRGIF_Msk                 (0x10000UL)               /*!< USIC_CH PSR: BRGIF (Bitfield-Mask: 0x01)                    */

/* -----------------------------  USIC_CH_PSR_ASCMode  ---------------------------- */
#define USIC_CH_PSR_ASCMode_TXIDLE_Pos        (0UL)                     /*!< USIC_CH PSR_ASCMode: TXIDLE (Bit 0)                         */
#define USIC_CH_PSR_ASCMode_TXIDLE_Msk        (0x1UL)                   /*!< USIC_CH PSR_ASCMode: TXIDLE (Bitfield-Mask: 0x01)           */
#define USIC_CH_PSR_ASCMode_RXIDLE_Pos        (1UL)                     /*!< USIC_CH PSR_ASCMode: RXIDLE (Bit 1)                         */
#define USIC_CH_PSR_ASCMode_RXIDLE_Msk        (0x2UL)                   /*!< USIC_CH PSR_ASCMode: RXIDLE (Bitfield-Mask: 0x01)           */
#define USIC_CH_PSR_ASCMode_SBD_Pos           (2UL)                     /*!< USIC_CH PSR_ASCMode: SBD (Bit 2)                            */
#define USIC_CH_PSR_ASCMode_SBD_Msk           (0x4UL)                   /*!< USIC_CH PSR_ASCMode: SBD (Bitfield-Mask: 0x01)              */
#define USIC_CH_PSR_ASCMode_COL_Pos           (3UL)                     /*!< USIC_CH PSR_ASCMode: COL (Bit 3)                            */
#define USIC_CH_PSR_ASCMode_COL_Msk           (0x8UL)                   /*!< USIC_CH PSR_ASCMode: COL (Bitfield-Mask: 0x01)              */
#define USIC_CH_PSR_ASCMode_RNS_Pos           (4UL)                     /*!< USIC_CH PSR_ASCMode: RNS (Bit 4)                            */
#define USIC_CH_PSR_ASCMode_RNS_Msk           (0x10UL)                  /*!< USIC_CH PSR_ASCMode: RNS (Bitfield-Mask: 0x01)              */
#define USIC_CH_PSR_ASCMode_FER0_Pos          (5UL)                     /*!< USIC_CH PSR_ASCMode: FER0 (Bit 5)                           */
#define USIC_CH_PSR_ASCMode_FER0_Msk          (0x20UL)                  /*!< USIC_CH PSR_ASCMode: FER0 (Bitfield-Mask: 0x01)             */
#define USIC_CH_PSR_ASCMode_FER1_Pos          (6UL)                     /*!< USIC_CH PSR_ASCMode: FER1 (Bit 6)                           */
#define USIC_CH_PSR_ASCMode_FER1_Msk          (0x40UL)                  /*!< USIC_CH PSR_ASCMode: FER1 (Bitfield-Mask: 0x01)             */
#define USIC_CH_PSR_ASCMode_RFF_Pos           (7UL)                     /*!< USIC_CH PSR_ASCMode: RFF (Bit 7)                            */
#define USIC_CH_PSR_ASCMode_RFF_Msk           (0x80UL)                  /*!< USIC_CH PSR_ASCMode: RFF (Bitfield-Mask: 0x01)              */
#define USIC_CH_PSR_ASCMode_TFF_Pos           (8UL)                     /*!< USIC_CH PSR_ASCMode: TFF (Bit 8)                            */
#define USIC_CH_PSR_ASCMode_TFF_Msk           (0x100UL)                 /*!< USIC_CH PSR_ASCMode: TFF (Bitfield-Mask: 0x01)              */
#define USIC_CH_PSR_ASCMode_BUSY_Pos          (9UL)                     /*!< USIC_CH PSR_ASCMode: BUSY (Bit 9)                           */
#define USIC_CH_PSR_ASCMode_BUSY_Msk          (0x200UL)                 /*!< USIC_CH PSR_ASCMode: BUSY (Bitfield-Mask: 0x01)          