
/****************************************************************************************************//**
 * @file     LPC18xx.h
 *
 * @status   RELEASE
 *
 * @brief    CMSIS Cortex-M3 Core Peripheral Access Layer Header File for
 *           default LPC18xx Device Series
 *
 * @version  V19
 * @date     9. December 2011
 *
 * @note     Generated with SVDConv V2.6 Build 6c  on Friday, 09.12.2011 13:49:19
 *
 *           from CMSIS SVD File 'LPC18xxv19.xml' Version 19,
 *           created on Friday, 09.12.2011 21:49:13, last modified on Friday, 09.12.2011 21:49:13
 *
 *                                                      modified by KEIL
 *******************************************************************************************************/



/** @addtogroup Template
  * @{
  */

#ifndef __LPC18XX_H__
#define __LPC18XX_H__

#ifdef __cplusplus
extern "C" {
#endif



/********************************************
** Start of section using anonymous unions **
*********************************************/

#if defined(__ARMCC_VERSION)
  #pragma push
  #pragma anon_unions
#elif defined(__CWCC__)
  #pragma push
  #pragma cpp_extensions on
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  //#pragma push
  #pragma language=extended
#else
  #error Not supported compiler type
#endif


 /* Interrupt Number Definition */

typedef enum {
// -------------------------  Cortex-M3 Processor Exceptions Numbers  -----------------------------
  Reset_IRQn                        = -15,
  NonMaskableInt_IRQn               = -14,
  HardFault_IRQn                    = -13,
  MemoryManagement_IRQn             = -12,
  BusFault_IRQn                     = -11,
  UsageFault_IRQn                   = -10,
  SVCall_IRQn                       = -5,
  DebugMonitor_IRQn                 = -4,
  PendSV_IRQn                       = -2,
  SysTick_IRQn                      = -1,
// ---------------------------  LPC18xx Specific Interrupt Numbers  -------------------------------
  DAC_IRQn                          = 0,
  RESERVED0_IRQn                    = 1,
  DMA_IRQn                          = 2,
  RESERVED1_IRQn                    = 3,
  FLASHEEPROM_IRQn                  = 4,
  ETHERNET_IRQn                     = 5,
  SDIO_IRQn                         = 6,
  LCD_IRQn                          = 7,
  USB0_IRQn                         = 8,
  USB1_IRQn                         = 9,
  SCT_IRQn                          = 10,
  RITIMER_IRQn                      = 11,
  TIMER0_IRQn                       = 12,
  TIMER1_IRQn                       = 13,
  TIMER2_IRQn                       = 14,
  TIMER3_IRQn                       = 15,
  MCPWM_IRQn                        = 16,
  ADC0_IRQn                         = 17,
  I2C0_IRQn                         = 18,
  I2C1_IRQn                         = 19,
  RESERVED3_IRQn                    = 20,
  ADC1_IRQn                         = 21,
  SSP0_IRQn                         = 22,
  SSP1_IRQn                         = 23,
  USART0_IRQn                       = 24,
  UART1_IRQn                        = 25,
  USART2_IRQn                       = 26,
  USART3_IRQn                       = 27,
  I2S0_IRQn                         = 28,
  I2S1_IRQn                         = 29,
  RESERVED4_IRQn                    = 30,
  RESERVED5_IRQn                    = 31,
  PIN_INT0_IRQn                     = 32,
  PIN_INT1_IRQn                     = 33,
  PIN_INT2_IRQn                     = 34,
  PIN_INT3_IRQn                     = 35,
  PIN_INT4_IRQn                     = 36,
  PIN_INT5_IRQn                     = 37,
  PIN_INT6_IRQn                     = 38,
  PIN_INT7_IRQn                     = 39,
  GINT0_IRQn                        = 40,
  GINT1_IRQn                        = 41,
  EVENTROUTER_IRQn                  = 42,
  C_CAN1_IRQn                       = 43,
  RESERVED6_IRQn                    = 44,
  RESERVED7_IRQn                    = 45,
  ATIMER_IRQn                       = 46,
  RTC_IRQn                          = 47,
  RESERVED8_IRQn                    = 48,
  WWDT_IRQn                         = 49,
  RESERVED9_IRQn                    = 50,
  C_CAN0_IRQn                       = 51,
  QEI_IRQn                          = 52,
} IRQn_Type;

 /* Event Router Input (ERI) Number Definitions */
typedef enum {
  WAKEUP0_ERIn                      = 0,
  WAKEUP1_ERIn                      = 1,
  WAKEUP2_ERIn                      = 2,
  WAKEUP3_ERIn                      = 3,
  ATIMER_ERIn                       = 4,
  RTC_ERIn                          = 5,
  BOD1_ERIn                         = 6,  /* Bod trip 1 */
  WWDT_ERIn                         = 7,
  ETH_ERIn                          = 8,
  USB0_ERIn                         = 9,
  USB1_ERIn                         = 10,
  SDIO_ERIn                         = 11,
  CAN_ERIn                          = 12, /* CAN0/1 or'ed */
  TIM2_ERIn                         = 13,
  TIM6_ERIn                         = 14,
  QEI_ERIn                          = 15,
  TIM14_ERIn                        = 16,
  RESERVED0_ERIn                    = 17, /* M0s */
  RESERVED1_ERIn                    = 18, /* M3/M4 */
  RESET_ERIn                        = 19
}ERIn_Type;

/** @addtogroup Configuration_of_CMSIS
  * @{
  */

/* Processor and Core Peripheral Section */ /* Configuration of the Template Processor and Core Peripherals */

#define __CM3_REV              		0x0101
#define __MPU_PRESENT           	1
#define __NVIC_PRIO_BITS          	3
#define __Vendor_SysTickConfig    	0
/** @} */ /* End of group Configuration_of_CMSIS */

#include <core_cm3.h>
#include "system_LPC18xx.h"

/** @addtogroup Device_Peripheral_Registers
  * @{
  */


// ------------------------------------------------------------------------------------------------
// -----                                          SCT                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx State Configurable Timer (SCT) Modification date=1/18/2011 Major revision=0 Minor revision=7  (SCT)
  */

#define CONFIG_SCT_nEV   (16)            /* Number of events */
#define CONFIG_SCT_nRG   (16)            /* Number of match/compare registers */
#define CONFIG_SCT_nOU   (16)            /* Number of outputs */

typedef struct
{
    __IO  uint32_t CONFIG;              /* 0x000 Configuration Register */
    union {
        __IO uint32_t CTRL_U;           /* 0x004 Control Register */
        struct {
            __IO uint16_t CTRL_L;       /* 0x004 low control register */
            __IO uint16_t CTRL_H;       /* 0x006 high control register */
        };
    };
    __IO uint16_t LIMIT_L;              /* 0x008 limit register for counter L */
    __IO uint16_t LIMIT_H;              /* 0x00A limit register for counter H */
    __IO uint16_t HALT_L;               /* 0x00C halt register for counter L */
    __IO uint16_t HALT_H;               /* 0x00E halt register for counter H */
    __IO uint16_t STOP_L;               /* 0x010 stop register for counter L */
    __IO uint16_t STOP_H;               /* 0x012 stop register for counter H */
    __IO uint16_t START_L;              /* 0x014 start register for counter L */
    __IO uint16_t START_H;              /* 0x016 start register for counter H */
         uint32_t RESERVED1[10];        /* 0x018-0x03C reserved */
    union {
        __IO uint32_t COUNT_U;          /* 0x040 counter register */
        struct {
            __IO uint16_t COUNT_L;      /* 0x040 counter register for counter L */
            __IO uint16_t COUNT_H;      /* 0x042 counter register for counter H */
        };
    };
    __IO uint16_t STATE_L;              /* 0x044 state register for counter L */
    __IO uint16_t STATE_H;              /* 0x046 state register for counter H */
    __I  uint32_t INPUT;                /* 0x048 input register */
    __IO uint16_t REGMODE_L;            /* 0x04C match - capture registers mode register L */
    __IO uint16_t REGMODE_H;            /* 0x04E match - capture registers mode register H */
    __IO uint32_t OUTPUT;               /* 0x050 output register */
    __IO uint32_t OUTPUTDIRCTRL;        /* 0x054 Output counter direction Control Register */
    __IO uint32_t RES;                  /* 0x058 conflict resolution register */
    __IO uint32_t DMA0REQUEST;          /* 0x05C DMA0 Request Register */
    __IO uint32_t DMA1REQUEST;          /* 0x060 DMA1 Request Register */
         uint32_t RESERVED2[35];        /* 0x064-0x0EC reserved */
    __IO uint32_t EVEN;                 /* 0x0F0 event enable register */
    __IO uint32_t EVFLAG;               /* 0x0F4 event flag register */
    __IO uint32_t CONEN;                /* 0x0F8 conflict enable register */
    __IO uint32_t CONFLAG;              /* 0x0FC conflict flag register */

    union {
        __IO union {                    /* 0x100-... Match / Capture value */
            uint32_t U;                 /*       SCTMATCH[i].U  Unified 32-bit register */
            struct {
                uint16_t L;             /*       SCTMATCH[i].L  Access to L value */
                uint16_t H;             /*       SCTMATCH[i].H  Access to H value */
            };
        } MATCH[CONFIG_SCT_nRG];
        __I union {
            uint32_t U;                 /*       SCTCAP[i].U  Unified 32-bit register */
            struct {
                uint16_t L;             /*       SCTCAP[i].L  Access to H value */
                uint16_t H;             /*       SCTCAP[i].H  Access to H value */
            };
        } CAP[CONFIG_SCT_nRG];
    };

         uint32_t RESERVED3[32-CONFIG_SCT_nRG];      /* ...-0x17C reserved */

    union {
        __IO uint16_t MATCH_L[CONFIG_SCT_nRG];       /* 0x180-... Match Value L counter */
        __I  uint16_t CAP_L[CONFIG_SCT_nRG];         /* 0x180-... Capture Value L counter */
    };
         uint16_t RESERVED4[32-CONFIG_SCT_nRG];      /* ...-0x1BE reserved */
    union {
        __IO uint16_t MATCH_H[CONFIG_SCT_nRG];       /* 0x1C0-... Match Value H counter */
        __I  uint16_t CAP_H[CONFIG_SCT_nRG];         /* 0x1C0-... Capture Value H counter */
    };
         uint16_t RESERVED5[32-CONFIG_SCT_nRG];      /* ...-0x1FE reserved */

    union {
        __IO union {                    /* 0x200-... Match Reload / Capture Control value */
            uint32_t U;                 /*       SCTMATCHREL[i].U  Unified 32-bit register */
            struct {
                uint16_t L;             /*       SCTMATCHREL[i].L  Access to L value */
                uint16_t H;             /*       SCTMATCHREL[i].H  Access to H value */
            };
        } MATCHREL[CONFIG_SCT_nRG];
        __IO union {
            uint32_t U;                 /*       SCTCAPCTRL[i].U  Unified 32-bit register */
            struct {
                uint16_t L;             /*       SCTCAPCTRL[i].L  Access to H value */
                uint16_t H;             /*       SCTCAPCTRL[i].H  Access to H value */
            };
        } CAPCTRL[CONFIG_SCT_nRG];
    };

         uint32_t RESERVED6[32-CONFIG_SCT_nRG];      /* ...-0x27C reserved */

    union {
        __IO uint16_t MATCHREL_L[CONFIG_SCT_nRG];    /* 0x280-... Match Reload value L counter */
        __IO uint16_t CAPCTRL_L[CONFIG_SCT_nRG];     /* 0x280-... Capture Control value L counter */
    };
         uint16_t RESERVED7[32-CONFIG_SCT_nRG];      /* ...-0x2BE reserved */
    union {
        __IO uint16_t MATCHREL_H[CONFIG_SCT_nRG];    /* 0x2C0-... Match Reload value H counter */
        __IO uint16_t CAPCTRL_H[CONFIG_SCT_nRG];     /* 0x2C0-... Capture Control value H counter */
    };
         uint16_t RESERVED8[32-CONFIG_SCT_nRG];      /* ...-0x2FE reserved */

    __IO struct {                       /* 0x300-0x3FC  SCTEVENT[i].STATE / SCTEVENT[i].CTRL*/
        uint32_t STATE;                 /* Event State Register */
        uint32_t CTRL;                  /* Event Control Register */
    } EVENT[CONFIG_SCT_nEV];

         uint32_t RESERVED9[128-2*CONFIG_SCT_nEV];   /* ...-0x4FC reserved */

    __IO struct {                       /* 0x500-0x57C  SCTOUT[i].SET / SCTOUT[i].CLR */
        uint32_t SET;                   /* Output n Set Register */
        uint32_t CLR;                   /* Output n Clear Register */
    } OUT[CONFIG_SCT_nOU];

         uint32_t RESERVED10[191-2*CONFIG_SCT_nOU];  /* ...-0x7F8 reserved */

    __I  uint32_t MODULECONTENT;        /* 0x7FC Module Content */

} LPC_SCT_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         GPDMA                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx General Purpose DMA (GPDMA) controller Modification date=1/19/2011 Major revision=0 Minor revision=7  (GPDMA)
  */

typedef struct {
  __I  uint32_t INTSTAT;
  __I  uint32_t INTTCSTAT;
  __O  uint32_t INTTCCLEAR;
  __I  uint32_t INTERRSTAT;
  __O  uint32_t INTERRCLR;
  __I  uint32_t RAWINTTCSTAT;
  __I  uint32_t RAWINTERRSTAT;
  __I  uint32_t ENBLDCHNS;
  __IO uint32_t SOFTBREQ;
  __IO uint32_t SOFTSREQ;
  __IO uint32_t SOFTLBREQ;
  __IO uint32_t SOFTLSREQ;
  __IO uint32_t CONFIG;
  __IO uint32_t SYNC;
  __I  uint32_t RESERVED0[50];
  __IO uint32_t C0SRCADDR;
  __IO uint32_t C0DESTADDR;
  __IO uint32_t C0LLI;
  __IO uint32_t C0CONTROL;
  __IO uint32_t C0CONFIG;
  __I  uint32_t RESERVED1[3];
  __IO uint32_t C1SRCADDR;
  __IO uint32_t C1DESTADDR;
  __IO uint32_t C1LLI;
  __IO uint32_t C1CONTROL;
  __IO uint32_t C1CONFIG;
  __I  uint32_t RESERVED2[3];
  __IO uint32_t C2SRCADDR;
  __IO uint32_t C2DESTADDR;
  __IO uint32_t C2LLI;
  __IO uint32_t C2CONTROL;
  __IO uint32_t C2CONFIG;
  __I  uint32_t RESERVED3[3];
  __IO uint32_t C3SRCADDR;
  __IO uint32_t C3DESTADDR;
  __IO uint32_t C3LLI;
  __IO uint32_t C3CONTROL;
  __IO uint32_t C3CONFIG;
  __I  uint32_t RESERVED4[3];
  __IO uint32_t C4SRCADDR;
  __IO uint32_t C4DESTADDR;
  __IO uint32_t C4LLI;
  __IO uint32_t C4CONTROL;
  __IO uint32_t C4CONFIG;
  __I  uint32_t RESERVED5[3];
  __IO uint32_t C5SRCADDR;
  __IO uint32_t C5DESTADDR;
  __IO uint32_t C5LLI;
  __IO uint32_t C5CONTROL;
  __IO uint32_t C5CONFIG;
  __I  uint32_t RESERVED6[3];
  __IO uint32_t C6SRCADDR;
  __IO uint32_t C6DESTADDR;
  __IO uint32_t C6LLI;
  __IO uint32_t C6CONTROL;
  __IO uint32_t C6CONFIG;
  __I  uint32_t RESERVED7[3];
  __IO uint32_t C7SRCADDR;
  __IO uint32_t C7DESTADDR;
  __IO uint32_t C7LLI;
  __IO uint32_t C7CONTROL;
  __IO uint32_t C7CONFIG;
} LPC_GPDMA_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         SDMMC                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx SD/MMC Modification date=n/a Major revision=n/a Minor revision=n/a  (SDMMC)
  */

typedef struct {
  __IO uint32_t CTRL;
  __IO uint32_t PWREN;
  __IO uint32_t CLKDIV;
  __IO uint32_t CLKSRC;
  __IO uint32_t CLKENA;
  __IO uint32_t TMOUT;
  __IO uint32_t CTYPE;
  __IO uint32_t BLKSIZ;
  __IO uint32_t BYTCNT;
  __IO uint32_t INTMASK;
  __IO uint32_t CMDARG;
  __IO uint32_t CMD;
  __I  uint32_t RESP0;
  __I  uint32_t RESP1;
  __I  uint32_t RESP2;
  __I  uint32_t RESP3;
  __I  uint32_t MINTSTS;
  __IO uint32_t RINTSTS;
  __I  uint32_t STATUS;
  __IO uint32_t FIFOTH;
  __I  uint32_t CDETECT;
  __I  uint32_t WRTPRT;
  __IO uint32_t GPIO;
  __I  uint32_t TCBCNT;
  __I  uint32_t TBBCNT;
  __IO uint32_t DEBNCE;
  __IO uint32_t USRID;
  __I  uint32_t VERID;
  __I  uint32_t RESERVED0;
  __IO uint32_t UHS_REG;
  __IO uint32_t RST_N;
  __I  uint32_t RESERVED1;
  __IO uint32_t BMOD;
  __O  uint32_t PLDMND;
  __IO uint32_t DBADDR;
  __IO uint32_t IDSTS;
  __IO uint32_t IDINTEN;
  __I  uint32_t DSCADDR;
  __I  uint32_t BUFADDR;
} LPC_SDMMC_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          EMC                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx External Memory Controller (EMC) Modification date=1/19/2011 Major revision=0 Minor revision=7  (EMC)
  */

typedef struct {
  __IO uint32_t CONTROL;
  __I  uint32_t STATUS;
  __IO uint32_t CONFIG;
  __I  uint32_t RESERVED0[5];
  __IO uint32_t DYNAMICCONTROL;
  __IO uint32_t DYNAMICREFRESH;
  __IO uint32_t DYNAMICREADCONFIG;
  __I  uint32_t RESERVED1;
  __IO uint32_t DYNAMICRP;
  __IO uint32_t DYNAMICRAS;
  __IO uint32_t DYNAMICSREX;
  __IO uint32_t DYNAMICAPR;
  __IO uint32_t DYNAMICDAL;
  __IO uint32_t DYNAMICWR;
  __IO uint32_t DYNAMICRC;
  __IO uint32_t DYNAMICRFC;
  __IO uint32_t DYNAMICXSR;
  __IO uint32_t DYNAMICRRD;
  __IO uint32_t DYNAMICMRD;
  __I  uint32_t RESERVED2[9];
  __IO uint32_t STATICEXTENDEDWAIT;
  __I  uint32_t RESERVED3[31];
  __IO uint32_t DYNAMICCONFIG0;
  __IO uint32_t DYNAMICRASCAS0;
  __I  uint32_t RESERVED4[6];
  __IO uint32_t DYNAMICCONFIG1;
  __IO uint32_t DYNAMICRASCAS1;
  __I  uint32_t RESERVED5[6];
  __IO uint32_t DYNAMICCONFIG2;
  __IO uint32_t DYNAMICRASCAS2;
  __I  uint32_t RESERVED6[6];
  __IO uint32_t DYNAMICCONFIG3;
  __IO uint32_t DYNAMICRASCAS3;
  __I  uint32_t RESERVED7[38];
  __IO uint32_t STATICCONFIG0;
  __IO uint32_t STATICWAITWEN0;
  __IO uint32_t STATICWAITOEN0;
  __IO uint32_t STATICWAITRD0;
  __IO uint32_t STATICWAITPAG0;
  __IO uint32_t STATICWAITWR0;
  __IO uint32_t STATICWAITTURN0;
  __I  uint32_t  RESERVED8;
  __IO uint32_t STATICCONFIG1;
  __IO uint32_t STATICWAITWEN1;
  __IO uint32_t STATICWAITOEN1;
  __IO uint32_t STATICWAITRD1;
  __IO uint32_t STATICWAITPAG1;
  __IO uint32_t STATICWAITWR1;
  __IO uint32_t  STATICWAITTURN1;
  __I  uint32_t  RESERVED9;
  __IO uint32_t STATICCONFIG2;
  __IO uint32_t STATICWAITWEN2;
  __IO uint32_t STATICWAITOEN2;
  __IO uint32_t STATICWAITRD2;
  __IO uint32_t STATICWAITPAG2;
  __IO uint32_t STATICWAITWR2;
  __IO uint32_t  STATICWAITTURN2;
  __I  uint32_t  RESERVED10;
  __IO uint32_t STATICCONFIG3;
  __IO uint32_t STATICWAITWEN3;
  __IO uint32_t STATICWAITOEN3;
  __IO uint32_t STATICWAITRD3;
  __IO uint32_t STATICWAITPAG3;
  __IO uint32_t STATICWAITWR3;
  __IO uint32_t  STATICWAITTURN3;
} LPC_EMC_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         USB0                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx USB0 Host/Device/OTG controller Modification date=1/19/2011 Major revision=0 Minor revision=7  (USB0)
  */

typedef struct {
  __I  uint32_t RESERVED0[64];
  __I  uint32_t CAPLENGTH;
  __I  uint32_t HCSPARAMS;
  __I  uint32_t HCCPARAMS;
  __I  uint32_t RESERVED1[5];
  __I  uint32_t DCIVERSION;
  __I  uint32_t RESERVED2[7];

  union {
    __IO uint32_t USBCMD_H;
    __IO uint32_t USBCMD_D;
  };

  union {
    __IO uint32_t USBSTS_H;
    __IO uint32_t USBSTS_D;
  };

  union {
    __IO uint32_t USBINTR_H;
    __IO uint32_t USBINTR_D;
  };

  union {
    __IO uint32_t FRINDEX_H;
    __IO uint32_t FRINDEX_D;
  };
  __I  uint32_t RESERVED3;

  union {
    __IO uint32_t PERIODICLISTBASE;
    __IO uint32_t DEVICEADDR;
  };

  union {
    __IO uint32_t ASYNCLISTADDR;
    __IO uint32_t ENDPOINTLISTADDR;
  };
  __IO uint32_t TTCTRL;
  __IO uint32_t BURSTSIZE;
  __IO uint32_t TXFILLTUNING;
  __I  uint32_t RESERVED4[3];
  __IO uint32_t BINTERVAL;
  __IO uint32_t ENDPTNAK;
  __IO uint32_t ENDPTNAKEN;
  __I  uint32_t RESERVED5;

  union {
    __IO uint32_t PORTSC1_H;
    __IO uint32_t PORTSC1_D;
  };
  __I  uint32_t RESERVED6[7];
  __IO uint32_t OTGSC;

  union {
    __IO uint32_t USBMODE_H;
    __IO uint32_t USBMODE_D;
  };
  __IO uint32_t ENDPTSETUPSTAT;
  __IO uint32_t ENDPTPRIME;
  __IO uint32_t ENDPTFLUSH;
  __I  uint32_t ENDPTSTAT;
  __IO uint32_t ENDPTCOMPLETE;
  __IO uint32_t ENDPTCTRL0;
  __IO uint32_t ENDPTCTRL1;
  __IO uint32_t ENDPTCTRL2;
  __IO uint32_t ENDPTCTRL3;
  __IO uint32_t ENDPTCTRL4;
  __IO uint32_t ENDPTCTRL5;
} LPC_USB0_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         USB1                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx USB1 Host/Device controller Modification date=1/19/2011 Major revision=0 Minor revision=7  (USB1)
  */

typedef struct {
  __I  uint32_t RESERVED0[64];
  __I  uint32_t CAPLENGTH;
  __I  uint32_t HCSPARAMS;
  __I  uint32_t HCCPARAMS;
  __I  uint32_t RESERVED1[5];
  __I  uint32_t DCIVERSION;
  __I  uint32_t RESERVED2[7];

  union {
    __IO uint32_t USBCMD_H;
    __IO uint32_t USBCMD_D;
  };

  union {
    __IO uint32_t USBSTS_H;
    __IO uint32_t USBSTS_D;
  };

  union {
    __IO uint32_t USBINTR_H;
    __IO uint32_t USBINTR_D;
  };

  union {
    __IO uint32_t FRINDEX_H;
    __I  uint32_t FRINDEX_D;
  };
  __I  uint32_t RESERVED3;

  union {
    __IO uint32_t PERIODICLISTBASE;
    __IO uint32_t DEVICEADDR;
  };

  union {
    __IO uint32_t ASYNCLISTADDR;
    __IO uint32_t ENDPOINTLISTADDR;
  };
  __IO uint32_t TTCTRL;
  __IO uint32_t BURSTSIZE;
  __IO uint32_t TXFILLTUNING;
  __I  uint32_t RESERVED4[2];
  __IO uint32_t ULPIVIEWPORT;
  __IO uint32_t BINTERVAL;
  __IO uint32_t ENDPTNAK;
  __IO uint32_t ENDPTNAKEN;
  __I  uint32_t RESERVED5;

  union {
    __IO uint32_t PORTSC1_H;
    __IO uint32_t PORTSC1_D;
  };
  __I  uint32_t RESERVED6[8];

  union {
    __IO uint32_t USBMODE_H;
    __IO uint32_t USBMODE_D;
  };
  __IO uint32_t ENDPTSETUPSTAT;
  __IO uint32_t ENDPTPRIME;
  __IO uint32_t ENDPTFLUSH;
  __I  uint32_t ENDPTSTAT;
  __IO uint32_t ENDPTCOMPLETE;
  __IO uint32_t ENDPTCTRL0;
  __IO uint32_t ENDPTCTRL1;
  __IO uint32_t ENDPTCTRL2;
  __IO uint32_t ENDPTCTRL3;
} LPC_USB1_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          LCD                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx LCD Modification date=1/19/2011 Major revision=0 Minor revision=7  (LCD)
  */

typedef struct {
  __IO uint32_t TIMH;
  __IO uint32_t TIMV;
  __IO uint32_t POL;
  __IO uint32_t LE;
  __IO uint32_t UPBASE;
  __IO uint32_t LPBASE;
  __IO uint32_t CTRL;
  __IO uint32_t INTMSK;
  __I  uint32_t INTRAW;
  __I  uint32_t INTSTAT;
  __O  uint32_t INTCLR;
  __I  uint32_t UPCURR;
  __I  uint32_t LPCURR;
  __I  uint32_t RESERVED0[115];
  __IO uint32_t PAL[256];
  __I  uint32_t RESERVED1[128];
  __IO uint32_t CRSR_IMG[256];
  __IO uint32_t CRSR_CTRL;
  __IO uint32_t CRSR_CFG;
  __IO uint32_t CRSR_PAL0;
  __IO uint32_t CRSR_PAL1;
  __IO uint32_t CRSR_XY;
  __IO uint32_t CRSR_CLIP;
  __I  uint32_t RESERVED2[2];
  __IO uint32_t CRSR_INTMSK;
  __O  uint32_t CRSR_INTCLR;
  __I  uint32_t CRSR_INTRAW;
  __I  uint32_t CRSR_INTSTAT;
} LPC_LCD_Type;


// ------------------------------------------------------------------------------------------------
// -----                                       ETHERNET                                       -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Ethernet Modification date=12/9/2011 Major revision=1.1 Minor revision=not available  (ETHERNET)
  */

typedef struct {
  __IO uint32_t MAC_CONFIG;
  __IO uint32_t MAC_FRAME_FILTER;
  __IO uint32_t MAC_HASHTABLE_HIGH;
  __IO uint32_t MAC_HASHTABLE_LOW;
  __IO uint32_t MAC_MII_ADDR;
  __IO uint32_t MAC_MII_DATA;
  __IO uint32_t MAC_FLOW_CTRL;
  __IO uint32_t MAC_VLAN_TAG;
  __I  uint32_t RESERVED0;
  __I  uint32_t MAC_DEBUG;
  __IO uint32_t MAC_RWAKE_FRFLT;
  __IO uint32_t MAC_PMT_CTRL_STAT;
  __I  uint32_t RESERVED1[2];
  __I  uint32_t MAC_INTR;
  __IO uint32_t MAC_INTR_MASK;
  __IO uint32_t MAC_ADDR0_HIGH;
  __IO uint32_t MAC_ADDR0_LOW;
  __I  uint32_t RESERVED2[430];
  __IO uint32_t MAC_TIMESTP_CTRL;
  __IO uint32_t SUBSECOND_INCR;
  __I  uint32_t SECONDS;
  __I  uint32_t NANOSECONDS;
  __IO uint32_t SECONDSUPDATE;
  __IO uint32_t NANOSECONDSUPDATE;
  __IO uint32_t ADDEND;
  __IO uint32_t TARGETSECONDS;
  __IO uint32_t TARGETNANOSECONDS;
  __IO uint32_t HIGHWORD;
  __I  uint32_t TIMESTAMPSTAT;
  __IO uint32_t PPSCTRL;
  __I  uint32_t AUXNANOSECONDS;
  __I  uint32_t AUXSECONDS;
  __I  uint32_t RESERVED3[562];
  __IO uint32_t DMA_BUS_MODE;
  __IO uint32_t DMA_TRANS_POLL_DEMAND;
  __IO uint32_t DMA_REC_POLL_DEMAND;
  __IO uint32_t DMA_REC_DES_ADDR;
  __IO uint32_t DMA_TRANS_DES_ADDR;
  __IO uint32_t DMA_STAT;
  __IO uint32_t DMA_OP_MODE;
  __IO uint32_t DMA_INT_EN;
  __I  uint32_t DMA_MFRM_BUFOF;
  __IO uint32_t DMA_REC_INT_WDT;
  __I  uint32_t RESERVED4[8];
  __I  uint32_t DMA_CURHOST_TRANS_DES;
  __I  uint32_t DMA_CURHOST_REC_DES;
  __I  uint32_t DMA_CURHOST_TRANS_BUF;
  __I  uint32_t DMA_CURHOST_REC_BUF;
} LPC_ETHERNET_Type;


// ------------------------------------------------------------------------------------------------
// -----                                        ATIMER                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Alarm timer Modification date=1/7/2011 Major revision=0 Minor revision=6  (ATIMER)
  */

typedef struct {
  __IO uint32_t DOWNCOUNTER;
  __IO uint32_t PRESET;
  __I  uint32_t RESERVED0[1012];
  __O  uint32_t CLR_EN;
  __O  uint32_t SET_EN;
  __I  uint32_t STATUS;
  __I  uint32_t ENABLE;
  __O  uint32_t CLR_STAT;
  __O  uint32_t SET_STAT;
} LPC_ATIMER_Type;


// ------------------------------------------------------------------------------------------------
// -----                                        REGFILE                                       -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx rtc/REGFILE date=1/20/2011 Major revision=0 Minor revision=7  (REGFILE)
  */

typedef struct {
  __IO uint32_t REGFILE[64];
} LPC_REGFILE_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          PMC                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Power Management Controller (PMC) Modification date=1/20/2011 Major revision=0 Minor revision=7  (PMC)
  */

typedef struct {
  __IO uint32_t PD0_SLEEP0_HW_ENA;
  __I  uint32_t  RESERVED0[6];
  __IO uint32_t PD0_SLEEP0_MODE;
} LPC_PMC_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         CREG                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Configuration Registers (CREG) Modification date=8/19/2011 Major revision=0 Minor revision=14  (CREG)
  */

typedef struct {
  __I  uint32_t  IRCTRM;
  __IO uint32_t CREG0;
  __I  uint32_t  RESERVED0[62];
  __IO uint32_t M3MEMMAP;
  __I  uint32_t  RESERVED1[5];
  __IO uint32_t CREG5;
  __IO uint32_t DMAMUX;
  __I  uint32_t  RESERVED2[2];
  __IO uint32_t ETBCFG;
  __IO uint32_t CREG6;
  __I  uint32_t  RESERVED3[52];
  __I  uint32_t CHIPID;
} LPC_CREG_Type;


// ------------------------------------------------------------------------------------------------
// -----                                      EVENTROUTER                                     -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Event router Modification date=1/20/2011 Major revision=0 Minor revision=7  (EVENTROUTER)
  */

typedef struct {
  __IO uint32_t HILO;
  __IO uint32_t EDGE;
  __I  uint32_t RESERVED0[1012];
  __O  uint32_t CLR_EN;
  __O  uint32_t SET_EN;
  __I  uint32_t STATUS;
  __I  uint32_t ENABLE;
  __O  uint32_t CLR_STAT;
  __O  uint32_t SET_STAT;
} LPC_EVENTROUTER_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          RTC                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Real-Time Clock (RTC) Modification date=1/20/2011 Major revision=0 Minor revision=7  (RTC)
  */

typedef struct {
  __O  uint32_t ILR;
  __I  uint32_t RESERVED0;
  __IO uint32_t CCR;
  __IO uint32_t CIIR;
  __IO uint32_t AMR;
  __I  uint32_t CTIME0;
  __I  uint32_t CTIME1;
  __I  uint32_t CTIME2;
  __IO uint32_t SEC;
  __IO uint32_t MIN;
  __IO uint32_t HRS;
  __IO uint32_t DOM;
  __IO uint32_t DOW;
  __IO uint32_t DOY;
  __IO uint32_t MONTH;
  __IO uint32_t YEAR;
  __IO uint32_t CALIBRATION;
  __I  uint32_t RESERVED1[7];
  __IO uint32_t ASEC;
  __IO uint32_t AMIN;
  __IO uint32_t AHRS;
  __IO uint32_t ADOM;
  __IO uint32_t ADOW;
  __IO uint32_t ADOY;
  __IO uint32_t AMON;
  __IO uint32_t AYRS;
} LPC_RTC_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          CGU                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10462 Chapter title=LPC18xx Clock Generation Unit (CGU) Modification date=6/1/2011 Major revision=0 Minor revision=1  (CGU)
  */

typedef struct {
  __I  uint32_t RESERVED0[5];
  __IO uint32_t FREQ_MON;
  __IO uint32_t XTAL_OSC_CTRL;
  __I  uint32_t PLL0USB_STAT;
  __IO uint32_t PLL0USB_CTRL;
  __IO uint32_t PLL0USB_MDIV;
  __IO uint32_t PLL0USB_NP_DIV;
  __I  uint32_t PLL0AUDIO_STAT;
  __IO uint32_t PLL0AUDIO_CTRL;
  __IO uint32_t PLL0AUDIO_MDIV;
  __IO uint32_t PLL0AUDIO_NP_DIV;
  __IO uint32_t PLL0AUDIO_FRAC;
  __I  uint32_t PLL1_STAT;
  __IO uint32_t PLL1_CTRL;
  __IO uint32_t IDIVA_CTRL;
  __IO uint32_t IDIVB_CTRL;
  __IO uint32_t IDIVC_CTRL;
  __IO uint32_t IDIVD_CTRL;
  __IO uint32_t IDIVE_CTRL;
  __IO uint32_t BASE_SAFE_CLK;
  __IO uint32_t BASE_USB0_CLK;
  __IO uint32_t BASE_PERIPH_CLK;
  __IO uint32_t BASE_USB1_CLK;
  __IO uint32_t BASE_M3_CLK;
  __IO uint32_t BASE_SPIFI_CLK;
  __IO uint32_t RESERVED2;
  __IO uint32_t BASE_PHY_RX_CLK;
  __IO uint32_t BASE_PHY_TX_CLK;
  __IO uint32_t BASE_APB1_CLK;
  __IO uint32_t BASE_APB3_CLK;
  __IO uint32_t BASE_LCD_CLK;
  __IO uint32_t RESERVED3;
  __IO uint32_t BASE_SDIO_CLK;
  __IO uint32_t BASE_SSP0_CLK;
  __IO uint32_t BASE_SSP1_CLK;
  __IO uint32_t BASE_UART0_CLK;
  __IO uint32_t BASE_UART1_CLK;
  __IO uint32_t BASE_UART2_CLK;
  __IO uint32_t BASE_UART3_CLK;
  __IO uint32_t BASE_OUT_CLK;
  __I  uint32_t RESERVED4[4];
  __IO uint32_t BASE_APLL_CLK;
  __IO uint32_t BASE_CGU_OUT0_CLK;
  __IO uint32_t BASE_CGU_OUT1_CLK;
} LPC_CGU_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         CCU1                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Clock Control Unit (CCU) Modification date=1/21/2011 Major revision=0 Minor revision=7  (CCU1)
  */

typedef struct {
  __IO uint32_t PM;
  __I  uint32_t BASE_STAT;
  __I  uint32_t RESERVED0[62];
  __IO uint32_t CLK_APB3_BUS_CFG;
  __I  uint32_t CLK_APB3_BUS_STAT;
  __IO uint32_t CLK_APB3_I2C1_CFG;
  __I  uint32_t CLK_APB3_I2C1_STAT;
  __IO uint32_t CLK_APB3_DAC_CFG;
  __I  uint32_t CLK_APB3_DAC_STAT;
  __IO uint32_t CLK_APB3_ADC0_CFG;
  __I  uint32_t CLK_APB3_ADC0_STAT;
  __IO uint32_t CLK_APB3_ADC1_CFG;
  __I  uint32_t CLK_APB3_ADC1_STAT;
  __IO uint32_t CLK_APB3_CAN0_CFG;
  __I  uint32_t CLK_APB3_CAN0_STAT;
  __I  uint32_t  RESERVED1[52];
  __IO uint32_t CLK_APB1_BUS_CFG;
  __I  uint32_t CLK_APB1_BUS_STAT;
  __IO uint32_t CLK_APB1_MOTOCONPWM_CFG;
  __I  uint32_t CLK_APB1_MOTOCONPWM_STAT;
  __IO uint32_t CLK_APB1_I2C0_CFG;
  __I  uint32_t CLK_APB1_I2C0_STAT;
  __IO uint32_t CLK_APB1_I2S_CFG;
  __I  uint32_t CLK_APB1_I2S_STAT;
  __IO uint32_t CLK_APB1_CAN1_CFG;
  __I  uint32_t CLK_APB1_CAN1_STAT;
  __I  uint32_t  RESERVED2[54];
  __IO uint32_t CLK_SPIFI_CFG;
  __I  uint32_t CLK_SPIFI_STAT;
  __I  uint32_t RESERVED3[62];
  __IO uint32_t CLK_M3_BUS_CFG;
  __I  uint32_t CLK_M3_BUS_STAT;
  __IO uint32_t CLK_M3_SPIFI_CFG;
  __I  uint32_t CLK_M3_SPIFI_STAT;
  __IO uint32_t CLK_M3_GPIO_CFG;
  __I  uint32_t CLK_M3_GPIO_STAT;
  __IO uint32_t CLK_M3_LCD_CFG;
  __I  uint32_t CLK_M3_LCD_STAT;
  __IO uint32_t CLK_M3_ETHERNET_CFG;
  __I  uint32_t CLK_M3_ETHERNET_STAT;
  __IO uint32_t CLK_M3_USB0_CFG;
  __I  uint32_t CLK_M3_USB0_STAT;
  __IO uint32_t CLK_M3_EMC_CFG;
  __I  uint32_t CLK_M3_EMC_STAT;
  __IO uint32_t CLK_M3_SDIO_CFG;
  __I  uint32_t CLK_M3_SDIO_STAT;
  __IO uint32_t CLK_M3_DMA_CFG;
  __I  uint32_t CLK_M3_DMA_STAT;
  __IO uint32_t CLK_M3_M3CORE_CFG;
  __I  uint32_t CLK_M3_M3CORE_STAT;
  __I  uint32_t  RESERVED4[6];
  __IO uint32_t CLK_M3_SCT_CFG;
  __I  uint32_t CLK_M3_SCT_STAT;
  __IO uint32_t CLK_M3_USB1_CFG;
  __I  uint32_t CLK_M3_USB1_STAT;
  __IO uint32_t CLK_M3_EMCDIV_CFG;
  __I  uint32_t CLK_M3_EMCDIV_STAT;
  __I  uint32_t  RESERVED5[32];
  __IO uint32_t CLK_M3_WWDT_CFG;
  __I  uint32_t CLK_M3_WWDT_STAT;
  __IO uint32_t CLK_M3_USART0_CFG;
  __I  uint32_t CLK_M3_USART0_STAT;
  __IO uint32_t CLK_M3_UART1_CFG;
  __I  uint32_t CLK_M3_UART1_STAT;
  __IO uint32_t CLK_M3_SSP0_CFG;
  __I  uint32_t CLK_M3_SSP0_STAT;
  __IO uint32_t CLK_M3_TIMER0_CFG;
  __I  uint32_t CLK_M3_TIMER0_STAT;
  __IO uint32_t CLK_M3_TIMER1_CFG;
  __I  uint32_t CLK_M3_TIMER1_STAT;
  __IO uint32_t CLK_M3_SCU_CFG;
  __I  uint32_t CLK_M3_SCU_STAT;
  __IO uint32_t CLK_M3_CREG_CFG;
  __I  uint32_t CLK_M3_CREG_STAT;
  __I  uint32_t  RESERVED6[48];
  __IO uint32_t CLK_M3_RITIMER_CFG;
  __I  uint32_t CLK_M3_RITIMER_STAT;
  __IO uint32_t CLK_M3_USART2_CFG;
  __I  uint32_t CLK_M3_USART2_STAT;
  __IO uint32_t CLK_M3_USART3_CFG;
  __I  uint32_t CLK_M3_USART3_STAT;
  __IO uint32_t CLK_M3_TIMER2_CFG;
  __I  uint32_t CLK_M3_TIMER2_STAT;
  __IO uint32_t CLK_M3_TIMER3_CFG;
  __I  uint32_t CLK_M3_TIMER3_STAT;
  __IO uint32_t CLK_M3_SSP1_CFG;
  __I  uint32_t CLK_M3_SSP1_STAT;
  __IO uint32_t CLK_M3_QEI_CFG;
  __I  uint32_t CLK_M3_QEI_STAT;
  __I  uint32_t  RESERVED7[114];
  __IO uint32_t CLK_USB0_CFG;
  __I  uint32_t CLK_USB0_STAT;
  __I  uint32_t RESERVED8[62];
  __IO uint32_t CLK_USB1_CFG;
  __I  uint32_t CLK_USB1_STAT;
  __I  uint32_t RESERVED9[126];
  __IO uint32_t CLK_VADC_CFG;
  __I  uint32_t CLK_VADC_STAT;
} LPC_CCU1_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         CCU2                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Clock Control Unit (CCU) Modification date=1/21/2011 Major revision=0 Minor revision=7  (CCU2)
  */

typedef struct {
  __IO uint32_t PM;
  __I  uint32_t BASE_STAT;
  __I  uint32_t RESERVED0[62];
  __IO uint32_t CLK_APLL_CFG;
  __I  uint32_t CLK_APLL_STAT;
  __I  uint32_t RESERVED1[62];
  __IO uint32_t CLK_APB2_USART3_CFG;
  __I  uint32_t CLK_APB2_USART3_STAT;
  __I  uint32_t RESERVED2[62];
  __IO uint32_t CLK_APB2_USART2_CFG;
  __I  uint32_t CLK_APB2_USART2_STAT;
  __I  uint32_t RESERVED3[62];
  __IO uint32_t CLK_APB0_UART1_CFG;
  __I  uint32_t CLK_APB0_UART1_STAT;
  __I  uint32_t RESERVED4[62];
  __IO uint32_t CLK_APB0_USART0_CFG;
  __I  uint32_t CLK_APB0_USART0_STAT;
  __I  uint32_t RESERVED5[62];
  __IO uint32_t CLK_APB2_SSP1_CFG;
  __I  uint32_t CLK_APB2_SSP1_STAT;
  __I  uint32_t RESERVED6[62];
  __IO uint32_t CLK_APB0_SSP0_CFG;
  __I  uint32_t CLK_APB0_SSP0_STAT;
  __I  uint32_t RESERVED7[62];
  __IO uint32_t CLK_SDIO_CFG;
  __I  uint32_t CLK_SDIO_STAT;
} LPC_CCU2_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          RGU                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Reset GenerationUnit (RGU) Modification date=7/20/2011 Major revision=0 Minor revision=13  (RGU)
  */

typedef struct {
  __I  uint32_t RESERVED0[64];
  __O  uint32_t RESET_CTRL0;
  __O  uint32_t RESET_CTRL1;
  __I  uint32_t RESERVED1[2];
  __IO uint32_t RESET_STATUS0;
  __IO uint32_t RESET_STATUS1;
  __IO uint32_t RESET_STATUS2;
  __IO uint32_t RESET_STATUS3;
  __I  uint32_t RESERVED2[12];
  __I  uint32_t RESET_ACTIVE_STATUS0;
  __I  uint32_t RESET_ACTIVE_STATUS1;
  __I  uint32_t RESERVED3[170];
  __IO uint32_t RESET_EXT_STAT0;
  __IO uint32_t RESET_EXT_STAT1;
  __IO uint32_t RESET_EXT_STAT2;
  __I  uint32_t RESERVED4;
  __IO uint32_t RESET_EXT_STAT4;
  __IO uint32_t RESET_EXT_STAT5;
  __I  uint32_t RESERVED5[2];
  __IO uint32_t RESET_EXT_STAT8;
  __IO uint32_t RESET_EXT_STAT9;
  __I  uint32_t RESERVED6[3];
  __IO uint32_t RESET_EXT_STAT13;
  __I  uint32_t RESERVED7[2];
  __IO uint32_t RESET_EXT_STAT16;
  __IO uint32_t RESET_EXT_STAT17;
  __IO uint32_t RESET_EXT_STAT18;
  __IO uint32_t RESET_EXT_STAT19;
  __IO uint32_t RESET_EXT_STAT20;
  __IO uint32_t RESET_EXT_STAT21;
  __IO uint32_t RESET_EXT_STAT22;
  __IO uint32_t RESET_EXT_STAT23;
  __I  uint32_t RESERVED8[4];
  __IO uint32_t RESET_EXT_STAT28;
  __I  uint32_t RESERVED9[3];
  __IO uint32_t RESET_EXT_STAT32;
  __IO uint32_t RESET_EXT_STAT33;
  __IO uint32_t RESET_EXT_STAT34;
  __IO uint32_t RESET_EXT_STAT35;
  __IO uint32_t RESET_EXT_STAT36;
  __IO uint32_t RESET_EXT_STAT37;
  __IO uint32_t RESET_EXT_STAT38;
  __IO uint32_t RESET_EXT_STAT39;
  __IO uint32_t RESET_EXT_STAT40;
  __IO uint32_t RESET_EXT_STAT41;
  __IO uint32_t RESET_EXT_STAT42;
  __I  uint32_t RESERVED10;
  __IO uint32_t RESET_EXT_STAT44;
  __IO uint32_t RESET_EXT_STAT45;
  __IO uint32_t RESET_EXT_STAT46;
  __IO uint32_t RESET_EXT_STAT47;
  __IO uint32_t RESET_EXT_STAT48;
  __IO uint32_t RESET_EXT_STAT49;
  __IO uint32_t RESET_EXT_STAT50;
  __IO uint32_t RESET_EXT_STAT51;
  __IO uint32_t RESET_EXT_STAT52;
  __IO uint32_t RESET_EXT_STAT53;
  __IO uint32_t  RESET_EXT_STAT54;
  __IO uint32_t RESET_EXT_STAT55;
} LPC_RGU_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         WWDT                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Windowed Watchdog timer (WWDT) Modification date=1/14/2011 Major revision=0 Minor revision=7  (WWDT)
  */

typedef struct {
  __IO uint32_t MOD;
  __IO uint32_t TC;
  __O  uint32_t FEED;
  __I  uint32_t TV;
  __I  uint32_t RESERVED0;
  __IO uint32_t WARNINT;
  __IO uint32_t WINDOW;
} LPC_WWDT_Type;


// ------------------------------------------------------------------------------------------------
// -----                                        USARTn                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx USART0_2_3 Modification date=1/14/2011 Major revision=0 Minor revision=7  (USARTn)
  */

typedef struct {

  union {
    __IO uint32_t DLL;
    __O  uint32_t THR;
    __I  uint32_t RBR;
  };

  union {
    __IO uint32_t IER;
    __IO uint32_t DLM;
  };

  union {
    __O  uint32_t FCR;
    __I  uint32_t IIR;
  };
  __IO uint32_t LCR;
  __I  uint32_t RESERVED0[1];
  __I  uint32_t LSR;
  __I  uint32_t RESERVED1[1];
  __IO uint32_t SCR;
  __IO uint32_t ACR;
  __IO uint32_t ICR;
  __IO uint32_t FDR;
  __IO uint32_t OSR;
  __I  uint32_t RESERVED2[4];
  __IO uint32_t HDEN;
  __I  uint32_t RESERVED3[1];
  __IO uint32_t SCICTRL;
  __IO uint32_t RS485CTRL;
  __IO uint32_t RS485ADRMATCH;
  __IO uint32_t RS485DLY;
  __IO uint32_t SYNCCTRL;
  __IO uint32_t TER;
} LPC_USARTn_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         UART1                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx UART1 Modification date=1/14/2011 Major revision=0 Minor revision=7  (UART1)
  */

typedef struct {

  union {
    __IO uint32_t DLL;
    __O  uint32_t THR;
    __I  uint32_t RBR;
  };

  union {
    __IO uint32_t IER;
    __IO uint32_t DLM;
  };

  union {
    __O  uint32_t FCR;
    __I  uint32_t IIR;
  };
  __IO uint32_t LCR;
  __IO uint32_t MCR;
  __I  uint32_t LSR;
  __I  uint32_t MSR;
  __IO uint32_t SCR;
  __IO uint32_t ACR;
  __I  uint32_t  RESERVED0;
  __IO uint32_t FDR;
  __I  uint32_t  RESERVED1;
  __IO uint32_t TER;
  __I  uint32_t RESERVED2[6];
  __IO uint32_t RS485CTRL;
  __IO uint32_t RS485ADRMATCH;
  __IO uint32_t RS485DLY;
  __I  uint32_t FIFOLVL;
} LPC_UART1_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         SSPn                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx SSP0/1 Modification date=1/14/2011 Major revision=0 Minor revision=7  (SSP0)
  */

typedef struct {
  __IO uint32_t CR0;
  __IO uint32_t CR1;
  __IO uint32_t DR;
  __I  uint32_t SR;
  __IO uint32_t CPSR;
  __IO uint32_t IMSC;
  __I  uint32_t RIS;
  __I  uint32_t MIS;
  __O  uint32_t ICR;
  __IO uint32_t DMACR;
} LPC_SSPn_Type;


// ------------------------------------------------------------------------------------------------
// -----                                        TIMERn                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Timer0/1/2/3 Modification date=1/14/2011 Major revision=0 Minor revision=7  (TIMERn)
  */

typedef struct {
  __IO uint32_t IR;
  __IO uint32_t TCR;
  __IO uint32_t TC;
  __IO uint32_t PR;
  __IO uint32_t PC;
  __IO uint32_t MCR;
  __IO uint32_t MR[4];
  __IO uint32_t CCR;
  __IO uint32_t CR[4];
  __IO uint32_t EMR;
  __I  uint32_t RESERVED0[12];
  __IO uint32_t CTCR;
} LPC_TIMERn_Type;




// ------------------------------------------------------------------------------------------------
// -----                                          SCU                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx System Control Unit (SCU) Modification date=6/8/2011 Major revision=0 Minor revision=10  (SCU)
  */

typedef struct {
  __IO uint32_t SFSP0_0;
  __IO uint32_t SFSP0_1;
  __I  uint32_t RESERVED0[30];
  __IO uint32_t SFSP1_0;
  __IO uint32_t SFSP1_1;
  __IO uint32_t SFSP1_2;
  __IO uint32_t SFSP1_3;
  __IO uint32_t SFSP1_4;
  __IO uint32_t SFSP1_5;
  __IO uint32_t SFSP1_6;
  __IO uint32_t SFSP1_7;
  __IO uint32_t SFSP1_8;
  __IO uint32_t SFSP1_9;
  __IO uint32_t SFSP1_10;
  __IO uint32_t SFSP1_11;
  __IO uint32_t SFSP1_12;
  __IO uint32_t SFSP1_13;
  __IO uint32_t SFSP1_14;
  __IO uint32_t SFSP1_15;
  __IO uint32_t SFSP1_16;
  __IO uint32_t SFSP1_17;
  __IO uint32_t SFSP1_18;
  __IO uint32_t SFSP1_19;
  __IO uint32_t SFSP1_20;
  __I  uint32_t RESERVED1[11];
  __IO uint32_t SFSP2_0;
  __IO uint32_t SFSP2_1;
  __IO uint32_t SFSP2_2;
  __IO uint32_t SFSP2_3;
  __IO uint32_t SFSP2_4;
  __IO uint32_t SFSP2_5;
  __IO uint32_t SFSP2_6;
  __IO uint32_t SFSP2_7;
  __IO uint32_t SFSP2_8;
  __IO uint32_t SFSP2_9;
  __IO uint32_t SFSP2_10;
  __IO uint32_t SFSP2_11;
  __IO uint32_t SFSP2_12;
  __IO uint32_t SFSP2_13;
  __I  uint32_t RESERVED2[18];
  __IO uint32_t SFSP3_0;
  __IO uint32_t SFSP3_1;
  __IO uint32_t SFSP3_2;
  __IO uint32_t SFSP3_3;
  __IO uint32_t SFSP3_4;
  __IO uint32_t SFSP3_5;
  __IO uint32_t SFSP3_6;
  __IO uint32_t SFSP3_7;
  __IO uint32_t SFSP3_8;
  __I  uint32_t RESERVED3[23];
  __IO uint32_t SFSP4_0;
  __IO uint32_t SFSP4_1;
  __IO uint32_t SFSP4_2;
  __IO uint32_t SFSP4_3;
  __IO uint32_t SFSP4_4;
  __IO uint32_t SFSP4_5;
  __IO uint32_t SFSP4_6;
  __IO uint32_t SFSP4_7;
  __IO uint32_t SFSP4_8;
  __IO uint32_t SFSP4_9;
  __IO uint32_t SFSP4_10;
  __I  uint32_t RESERVED4[21];
  __IO uint32_t SFSP5_0;
  __IO uint32_t SFSP5_1;
  __IO uint32_t SFSP5_2;
  __IO uint32_t SFSP5_3;
  __IO uint32_t SFSP5_4;
  __IO uint32_t SFSP5_5;
  __IO uint32_t SFSP5_6;
  __IO uint32_t SFSP5_7;
  __I  uint32_t RESERVED5[24];
  __IO uint32_t SFSP6_0;
  __IO uint32_t SFSP6_1;
  __IO uint32_t SFSP6_2;
  __IO uint32_t SFSP6_3;
  __IO uint32_t SFSP6_4;
  __IO uint32_t SFSP6_5;
  __IO uint32_t SFSP6_6;
  __IO uint32_t SFSP6_7;
  __IO uint32_t SFSP6_8;
  __IO uint32_t SFSP6_9;
  __IO uint32_t SFSP6_10;
  __IO uint32_t SFSP6_11;
  __IO uint32_t SFSP6_12;
  __I  uint32_t RESERVED6[19];
  __IO uint32_t SFSP7_0;
  __IO uint32_t SFSP7_1;
  __IO uint32_t SFSP7_2;
  __IO uint32_t SFSP7_3;
  __IO uint32_t SFSP7_4;
  __IO uint32_t SFSP7_5;
  __IO uint32_t SFSP7_6;
  __IO uint32_t SFSP7_7;
  __I  uint32_t RESERVED7[24];
  __IO uint32_t SFSP8_0;
  __IO uint32_t SFSP8_1;
  __IO uint32_t SFSP8_2;
  __IO uint32_t SFSP8_3;
  __IO uint32_t SFSP8_4;
  __IO uint32_t SFSP8_5;
  __IO uint32_t SFSP8_6;
  __IO uint32_t SFSP8_7;
  __IO uint32_t SFSP8_8;
  __I  uint32_t RESERVED8[23];
  __IO uint32_t SFSP9_0;
  __IO uint32_t SFSP9_1;
  __IO uint32_t SFSP9_2;
  __IO uint32_t SFSP9_3;
  __IO uint32_t SFSP9_4;
  __IO uint32_t SFSP9_5;
  __IO uint32_t SFSP9_6;
  __I  uint32_t RESERVED9[25];
  __IO uint32_t SFSPA_0;
  __IO uint32_t SFSPA_1;
  __IO uint32_t SFSPA_2;
  __IO uint32_t SFSPA_3;
  __IO uint32_t SFSPA_4;
  __I  uint32_t RESERVED10[27];
  __IO uint32_t SFSPB_0;
  __IO uint32_t SFSPB_1;
  __IO uint32_t SFSPB_2;
  __IO uint32_t SFSPB_3;
  __IO uint32_t SFSPB_4;
  __IO uint32_t SFSPB_5;
  __IO uint32_t SFSPB_6;
  __I  uint32_t RESERVED11[25];
  __IO uint32_t SFSPC_0;
  __IO uint32_t SFSPC_1;
  __IO uint32_t SFSPC_2;
  __IO uint32_t SFSPC_3;
  __IO uint32_t SFSPC_4;
  __IO uint32_t SFSPC_5;
  __IO uint32_t SFSPC_6;
  __IO uint32_t SFSPC_7;
  __IO uint32_t SFSPC_8;
  __IO uint32_t SFSPC_9;
  __IO uint32_t SFSPC_10;
  __IO uint32_t SFSPC_11;
  __IO uint32_t SFSPC_12;
  __IO uint32_t SFSPC_13;
  __IO uint32_t SFSPC_14;
  __I  uint32_t RESERVED12[17];
  __IO uint32_t SFSPD_0;
  __IO uint32_t SFSPD_1;
  __IO uint32_t SFSPD_2;
  __IO uint32_t SFSPD_3;
  __IO uint32_t SFSPD_4;
  __IO uint32_t SFSPD_5;
  __IO uint32_t SFSPD_6;
  __IO uint32_t SFSPD_7;
  __IO uint32_t SFSPD_8;
  __IO uint32_t SFSPD_9;
  __IO uint32_t SFSPD_10;
  __IO uint32_t SFSPD_11;
  __IO uint32_t SFSPD_12;
  __IO uint32_t SFSPD_13;
  __IO uint32_t SFSPD_14;
  __IO uint32_t SFSPD_15;
  __IO uint32_t SFSPD_16;
  __I  uint32_t RESERVED13[15];
  __IO uint32_t SFSPE_0;
  __IO uint32_t SFSPE_1;
  __IO uint32_t SFSPE_2;
  __IO uint32_t SFSPE_3;
  __IO uint32_t SFSPE_4;
  __IO uint32_t SFSPE_5;
  __IO uint32_t SFSPE_6;
  __IO uint32_t SFSPE_7;
  __IO uint32_t SFSPE_8;
  __IO uint32_t SFSPE_9;
  __IO uint32_t SFSPE_10;
  __IO uint32_t SFSPE_11;
  __IO uint32_t SFSPE_12;
  __IO uint32_t SFSPE_13;
  __IO uint32_t SFSPE_14;
  __IO uint32_t SFSPE_15;
  __I  uint32_t RESERVED14[16];
  __IO uint32_t SFSPF_0;
  __IO uint32_t SFSPF_1;
  __IO uint32_t SFSPF_2;
  __IO uint32_t SFSPF_3;
  __IO uint32_t SFSPF_4;
  __IO uint32_t SFSPF_5;
  __IO uint32_t SFSPF_6;
  __IO uint32_t SFSPF_7;
  __IO uint32_t SFSPF_8;
  __IO uint32_t SFSPF_9;
  __IO uint32_t SFSPF_10;
  __IO uint32_t SFSPF_11;
  __I  uint32_t RESERVED15[276];
  __IO uint32_t SFSCLK_0;
  __IO uint32_t SFSCLK_1;
  __IO uint32_t SFSCLK_2;
  __IO uint32_t SFSCLK_3;
  __I  uint32_t RESERVED16[28];
  __IO uint32_t SFSUSB;
  __IO uint32_t SFSI2C0;
  __IO uint32_t ENAIO0;
  __IO uint32_t ENAIO1;
  __IO uint32_t ENAIO2;
  __I  uint32_t RESERVED17[27];
  __IO uint32_t  EMCDELAYCLK;
  __I  uint32_t  RESERVED18[63];
  __IO uint32_t PINTSEL0;
  __IO uint32_t PINTSEL1;
} LPC_SCU_Type;


// ------------------------------------------------------------------------------------------------
// -----                                     GPIO_PIN_INT                                     -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief GPIO pin interrupt (GPIO_PIN_INT)
  */

typedef struct {
  __IO uint32_t  ISEL;
  __IO uint32_t  IENR;
  __O  uint32_t  SIENR;
  __O  uint32_t  CIENR;
  __IO uint32_t  IENF;
  __O  uint32_t  SIENF;
  __O  uint32_t  CIENF;
  __IO uint32_t  RISE;
  __IO uint32_t  FALL;
  __IO uint32_t  IST;
} LPC_GPIO_PIN_INT_Type;


// ------------------------------------------------------------------------------------------------
// -----                                    GPIO_GROUP_INTn                                   -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief GPIO group interrupt 0 (GPIO_GROUP_INTn)
  */

typedef struct {
  __IO uint32_t  CTRL;
  __I  uint32_t  RESERVED0[7];
  __IO uint32_t  PORT_POL0;
  __IO uint32_t  PORT_POL1;
  __IO uint32_t  PORT_POL2;
  __IO uint32_t  PORT_POL3;
  __IO uint32_t  PORT_POL4;
  __IO uint32_t  PORT_POL5;
  __IO uint32_t  PORT_POL6;
  __IO uint32_t  PORT_POL7;
  __IO uint32_t  PORT_ENA0;
  __IO uint32_t  PORT_ENA1;
  __IO uint32_t  PORT_ENA2;
  __IO uint32_t  PORT_ENA3;
  __IO uint32_t  PORT_ENA4;
  __IO uint32_t  PORT_ENA5;
  __IO uint32_t  PORT_ENA6;
  __IO uint32_t  PORT_ENA7;
} LPC_GPIO_GROUP_INTn_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         MCPWM                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Motor Control PWM (MOTOCONPWM) Modification date=1/14/2011 Major revision=0 Minor revision=7  (MCPWM)
  */

typedef struct {
  __I  uint32_t CON;
  __O  uint32_t CON_SET;
  __O  uint32_t CON_CLR;
  __I  uint32_t CAPCON;
  __O  uint32_t CAPCON_SET;
  __O  uint32_t CAPCON_CLR;
  __IO uint32_t TC[3];
  __IO uint32_t LIM[3];
  __IO uint32_t MAT[3];
  __IO uint32_t DT;
  __IO uint32_t CCP;
  __I  uint32_t CAP[3];
  __I  uint32_t INTEN;
  __O  uint32_t INTEN_SET;
  __O  uint32_t INTEN_CLR;
  __I  uint32_t CNTCON;
  __O  uint32_t CNTCON_SET;
  __O  uint32_t CNTCON_CLR;
  __I  uint32_t INTF;
  __O  uint32_t INTF_SET;
  __O  uint32_t INTF_CLR;
  __O  uint32_t CAP_CLR;
} LPC_MCPWM_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         I2C0                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx I2C0/1-bus interface Modification date=1/14/2011 Major revision=0 Minor revision=7  (I2Cn)
  */

typedef struct {
  __IO uint32_t CONSET;
  __I  uint32_t STAT;
  __IO uint32_t DAT;
  __IO uint32_t ADR0;
  __IO uint32_t SCLH;
  __IO uint32_t SCLL;
  __O  uint32_t CONCLR;
  __IO uint32_t MMCTRL;
  __IO uint32_t ADR1;
  __IO uint32_t ADR2;
  __IO uint32_t ADR3;
  __I  uint32_t DATA_BUFFER;
  __IO uint32_t MASK[4];
} LPC_I2Cn_Type;

// ------------------------------------------------------------------------------------------------
// -----                                         I2Sn                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx I2S interface Modification date=1/14/2011 Major revision=0 Minor revision=7  (I2Sn)
    0x400A2000 / 0x400A3000
  */

typedef struct {
  __IO uint32_t DAO;
  __IO uint32_t DAI;
  __O  uint32_t TXFIFO;
  __I  uint32_t RXFIFO;
  __I  uint32_t STATE;
  __IO uint32_t DMA1;
  __IO uint32_t DMA2;
  __IO uint32_t IRQ;
  __IO uint32_t TXRATE;
  __IO uint32_t RXRATE;
  __IO uint32_t TXBITRATE;
  __IO uint32_t RXBITRATE;
  __IO uint32_t TXMODE;
  __IO uint32_t RXMODE;
} LPC_I2Sn_Type;

// ------------------------------------------------------------------------------------------------
// -----                                        C_CANn                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx C_CAN Modification date=1/18/2011 Major revision=0 Minor revision=7  (C_CANn)
    0x400A4000 / 0x400E2000
  */

typedef struct {
  __IO uint32_t CNTL;
  __IO uint32_t STAT;
  __I  uint32_t EC;
  __IO uint32_t BT;
  __I  uint32_t INT;
  __IO uint32_t TEST;
  __IO uint32_t BRPE;
  __I  uint32_t RESERVED0;
  __IO uint32_t IF1_CMDREQ;

  union {
    __IO uint32_t IF1_CMDMSK_R;
    __IO uint32_t IF1_CMDMSK_W;
  };
  __IO uint32_t IF1_MSK1;
  __IO uint32_t IF1_MSK2;
  __IO uint32_t IF1_ARB1;
  __IO uint32_t IF1_ARB2;
  __IO uint32_t IF1_MCTRL;
  __IO uint32_t IF1_DA1;
  __IO uint32_t IF1_DA2;
  __IO uint32_t IF1_DB1;
  __IO uint32_t IF1_DB2;
  __I  uint32_t RESERVED1[13];
  __IO uint32_t IF2_CMDREQ;

  union {
    __IO uint32_t IF2_CMDMSK_R;
    __IO uint32_t IF2_CMDMSK_W;
  };
  __IO uint32_t IF2_MSK1;
  __IO uint32_t IF2_MSK2;
  __IO uint32_t IF2_ARB1;
  __IO uint32_t IF2_ARB2;
  __IO uint32_t IF2_MCTRL;
  __IO uint32_t IF2_DA1;
  __IO uint32_t IF2_DA2;
  __IO uint32_t IF2_DB1;
  __IO uint32_t IF2_DB2;
  __I  uint32_t RESERVED2[21];
  __I  uint32_t TXREQ1;
  __I  uint32_t TXREQ2;
  __I  uint32_t RESERVED3[6];
  __I  uint32_t ND1;
  __I  uint32_t ND2;
  __I  uint32_t RESERVED4[6];
  __I  uint32_t IR1;
  __I  uint32_t IR2;
  __I  uint32_t RESERVED5[6];
  __I  uint32_t MSGV1;
  __I  uint32_t MSGV2;
  __I  uint32_t RESERVED6[6];
  __IO uint32_t CLKDIV;
} LPC_C_CANn_Type;


// ------------------------------------------------------------------------------------------------
// -----                                        RITIMER                                       -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Repetitive Interrupt Timer (RIT) Modification date=1/14/2011 Major revision=0 Minor revision=7  (RITIMER)
  */

typedef struct {
  __IO uint32_t COMPVAL;
  __IO uint32_t MASK;
  __IO uint32_t CTRL;
  __IO uint32_t COUNTER;
} LPC_RITIMER_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          QEI                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx Quadrature Encoder Interface (QEI) Modification date=1/18/2011 Major revision=0 Minor revision=7  (QEI)
  */

typedef struct {
  __O  uint32_t CON;
  __I  uint32_t STAT;
  __IO uint32_t CONF;
  __I  uint32_t POS;
  __IO uint32_t MAXPOS;
  __IO uint32_t CMPOS0;
  __IO uint32_t CMPOS1;
  __IO uint32_t CMPOS2;
  __I  uint32_t INXCNT;
  __IO uint32_t INXCMP0;
  __IO uint32_t LOAD;
  __I  uint32_t TIME;
  __I  uint32_t VEL;
  __I  uint32_t CAP;
  __IO uint32_t VELCOMP;
  __IO uint32_t FILTERPHA;
  __IO uint32_t FILTERPHB;
  __IO uint32_t FILTERINX;
  __IO uint32_t WINDOW;
  __IO uint32_t INXCMP1;
  __IO uint32_t INXCMP2;
  __I  uint32_t RESERVED0[993];
  __O  uint32_t IEC;
  __O  uint32_t IES;
  __I  uint32_t INTSTAT;
  __I  uint32_t IE;
  __O  uint32_t CLR;
  __O  uint32_t SET;
} LPC_QEI_Type;


// ------------------------------------------------------------------------------------------------
// -----                                         GIMA                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=Falcon Chapter title=Global Input Multiplexer Array (GIMA) Modification date=3/25/2011 Major revision=0 Minor revision=4  (GIMA)
  */

typedef struct {
  __IO uint32_t  CAP0_0_IN;
  __IO uint32_t  CAP0_1_IN;
  __IO uint32_t  CAP0_2_IN;
  __IO uint32_t  CAP0_3_IN;
  __IO uint32_t  CAP1_0_IN;
  __IO uint32_t  CAP1_1_IN;
  __IO uint32_t  CAP1_2_IN;
  __IO uint32_t  CAP1_3_IN;
  __IO uint32_t  CAP2_0_IN;
  __IO uint32_t  CAP2_1_IN;
  __IO uint32_t  CAP2_2_IN;
  __IO uint32_t  CAP2_3_IN;
  __IO uint32_t  CAP3_0_IN;
  __IO uint32_t  CAP3_1_IN;
  __IO uint32_t  CAP3_2_IN;
  __IO uint32_t  CAP3_3_IN;
  __IO uint32_t  CTIN_0_IN;
  __IO uint32_t  CTIN_1_IN;
  __IO uint32_t  CTIN_2_IN;
  __IO uint32_t  CTIN_3_IN;
  __IO uint32_t  CTIN_4_IN;
  __IO uint32_t  CTIN_5_IN;
  __IO uint32_t  CTIN_6_IN;
  __IO uint32_t  CTIN_7_IN;
  __IO uint32_t  VADC_TRIGGER_IN;
  __IO uint32_t  EVENTROUTER_13_IN;
  __IO uint32_t  EVENTROUTER_14_IN;
  __IO uint32_t  EVENTROUTER_16_IN;
  __IO uint32_t  ADCSTART0_IN;
  __IO uint32_t  ADCSTART1_IN;
} LPC_GIMA_Type;


// ------------------------------------------------------------------------------------------------
// -----                                          DAC                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx DAC Modification date=1/18/2011 Major revision=0 Minor revision=7  (DAC)
  */

typedef struct {
  __IO uint32_t CR;
  __IO uint32_t CTRL;
  __IO uint32_t CNTVAL;
} LPC_DAC_Type;



// ------------------------------------------------------------------------------------------------
// -----                                         ADCn                                         -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief Product name title=UM10430 Chapter title=LPC18xx 10-bit ADC0/1 Modification date=1/18/2011 Major revision=0 Minor revision=7  (ADCn)
    0x400E3000 / 0x400E4000
  */

typedef struct {
  __IO uint32_t CR;
  __I  uint32_t GDR;
  __I  uint32_t RESERVED0;
  __IO uint32_t INTEN;
  __I  uint32_t DR[8];
  __I  uint32_t STAT;
} LPC_ADCn_Type;


// ------------------------------------------------------------------------------------------------
// -----                                       GPIO_PORT                                      -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief GPIO port  (GPIO_PORT)
  */

typedef struct {
  __IO uint8_t B[256];
  __I  uint32_t RESERVED0[960];
  __IO uint32_t W[256];
  __I  uint32_t RESERVED1[768];
  __IO uint32_t DIR[8];
  __I  uint32_t RESERVED2[24];
  __IO uint32_t MASK[8];
  __I  uint32_t RESERVED3[24];
  __IO uint32_t PIN[8];
  __I  uint32_t RESERVED4[24];
  __IO uint32_t MPIN[8];
  __I  uint32_t RESERVED5[24];
  __IO uint32_t SET[8];
  __I  uint32_t RESERVED6[24];
  __O  uint32_t CLR[8];
  __I  uint32_t RESERVED7[24];
  __O  uint32_t NOT[8];
} LPC_GPIO_PORT_Type;


// ------------------------------------------------------------------------------------------------
// -----                                        EEPROM                                        -----
// ------------------------------------------------------------------------------------------------


/**
  * @brief EEPROM (EEPROM)
  */

typedef struct {
  __IO uint32_t  CMD;
  __I  uint32_t  RESERVED0;
  __IO uint32_t  RWSTATE;
  __IO uint32_t  AUTOPROG;
  __IO uint32_t  WSTATE;
  __IO uint32_t  CLKDIV;
  __IO uint32_t  PWRDWN;
  __I  uint32_t  RESERVED1[1007];
  __O  uint32_t  INTENCLR;
  __O  uint32_t  INTENSET;
  __I  uint32_t  INTSTAT;
  __I  uint32_t  INTEN;
  __O  uint32_t  INTSTATCLR;
  __O  uint32_t  INTSTATSET;
} LPC_EEPROM_Type;




/********************************************
** End of section using anonymous unions   **
*********************************************/

#if defined(__ARMCC_VERSION)
  #pragma pop
#elif defined(__CWCC__)
  #pragma pop
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  //#pragma pop
#else
  #error Not supported compiler type
#endif


#ifdef CMSIS_BITPOSITIONS
// ------------------------------------------------------------------------------------------------
// -----                                  SCT Position & Mask                                 -----
// ------------------------------------------------------------------------------------------------


// ---------------------------------------  SCT_CONFIG  -------------------------------------------
#define SCT_CONFIG_UNIFY_Pos                                  0
#define SCT_CONFIG_UNIFY_Msk                                  (0x01UL << SCT_CONFIG_UNIFY_Pos)
#define SCT_CONFIG_CLKMODE_Pos                                1
#define SCT_CONFIG_CLKMODE_Msk                                (0x03UL << SCT_CONFIG_CLKMODE_Pos)
#define SCT_CONFIG_CLKSEL_Pos                                 3
#define SCT_CONFIG_CLKSEL_Msk                                 (0x0fUL << SCT_CONFIG_CLKSEL_Pos)
#define SCT_CONFIG_NORELAODL_NORELOADU_Pos                    7
#define SCT_CONFIG_NORELAODL_NORELOADU_Msk                    (0x01UL << SCT_CONFIG_NORELAODL_NORELOADU_Pos)
#define SCT_CONFIG_NORELOADH_Pos                              8
#define SCT_CONFIG_NORELOADH_Msk                              (0x01UL << SCT_CONFIG_NORELOADH_Pos)
#define SCT_CONFIG_INSYNCn_Pos                                9
#define SCT_CONFIG_INSYNCn_Msk                                (0x000000ffUL << SCT_CONFIG_INSYNCn_Pos)

// ----------------------------------------  SCT_CTRL  --------------------------------------------
#define SCT_CTRL_DOWN_L_Pos                                   0
#define SCT_CTRL_DOWN_L_Msk                                   (0x01UL << SCT_CTRL_DOWN_L_Pos)
#define SCT_CTRL_STOP_L_Pos                                   1
#define SCT_CTRL_STOP_L_Msk                                   (0x01UL << SCT_CTRL_STOP_L_Pos)
#define SCT_CTRL_HALT_L_Pos                                   2
#define SCT_CTRL_HALT_L_Msk                                   (0x01UL << SCT_CTRL_HALT_L_Pos)
#define SCT_CTRL_CLRCTR_L_Pos                                 3
#define SCT_CTRL_CLRCTR_L_Msk                                 (0x01UL << SCT_CTRL_CLRCTR_L_Pos)
#define SCT_CTRL_BIDIR_L_Pos                                  4
#define SCT_CTRL_BIDIR_L_Msk                                  (0x01UL << SCT_CTRL_BIDIR_L_Pos)
#define SCT_CTRL_PRE_L_Pos                                    5
#define SCT_CTRL_PRE_L_Msk                                    (0x000000ffUL << SCT_CTRL_PRE_L_Pos)
#define SCT_CTRL_DOWN_H_Pos                                   16
#define SCT_CTRL_DOWN_H_Msk                                   (0x01UL << SCT_CTRL_DOWN_H_Pos)
#define SCT_CTRL_STOP_H_Pos                                   17
#define SCT_CTRL_STOP_H_Msk                                   (0x01UL << SCT_CTRL_STOP_H_Pos)
#define SCT_CTRL_HALT_H_Pos                                   18
#define SCT_CTRL_HALT_H_Msk                                   (0x01UL << SCT_CTRL_HALT_H_Pos)
#define SCT_CTRL_CLRCTR_H_Pos                                 19
#define SCT_CTRL_CLRCTR_H_Msk                                 (0x01UL << SCT_CTRL_CLRCTR_H_Pos)
#define SCT_CTRL_BIDIR_H_Pos                                  20
#define SCT_CTRL_BIDIR_H_Msk                                  (0x01UL << SCT_CTRL_BIDIR_H_Pos)
#define SCT_CTRL_PRE_H_Pos                                    21
#define SCT_CTRL_PRE_H_Msk                                    (0x000000ffUL << SCT_CTRL_PRE_H_Pos)

// ----------------------------------------  SCT_LIMIT  -------------------------------------------
#define SCT_LIMIT_LIMMSK_L_Pos                                0
#define SCT_LIMIT_LIMMSK_L_Msk                                (0x0000ffffUL << SCT_LIMIT_LIMMSK_L_Pos)
#define SCT_LIMIT_LIMMSK_H_Pos                                16
#define SCT_LIMIT_LIMMSK_H_Msk                                (0x0000ffffUL << SCT_LIMIT_LIMMSK_H_Pos)

// ----------------------------------------  SCT_HALT  --------------------------------------------
#define SCT_HALT_HALTMSK_L_Pos                                0
#define SCT_HALT_HALTMSK_L_Msk                                (0x0000ffffUL << SCT_HALT_HALTMSK_L_Pos)
#define SCT_HALT_HALTMSK_H_Pos                                16
#define SCT_HALT_HALTMSK_H_Msk                                (0x0000ffffUL << SCT_HALT_HALTMSK_H_Pos)

// ----------------------------------------  SCT_STOP  --------------------------------------------
#define SCT_STOP_STOPMSK_L_Pos                                0
#define SCT_STOP_STOPMSK_L_Msk                                (0x0000ffffUL << SCT_STOP_STOPMSK_L_Pos)
#define SCT_STOP_STOPMSK_H_Pos                                16
#define SCT_STOP_STOPMSK_H_Msk                                (0x0000ffffUL << SCT_STOP_STOPMSK_H_Pos)

// ----------------------------------------  SCT_START  -------------------------------------------
#define SCT_START_STARTMSK_L_Pos                              0
#define SCT_START_STARTMSK_L_Msk                              (0x0000ffffUL << SCT_START_STARTMSK_L_Pos)
#define SCT_START_STARTMSK_H_Pos                              16
#define SCT_START_STARTMSK_H_Msk                              (0x0000ffffUL << SCT_START_STARTMSK_H_Pos)

// ----------------------------------------  SCT_COUNT  -------------------------------------------
#define SCT_COUNT_CTR_L_Pos                                   0
#define SCT_COUNT_CTR_L_Msk                                   (0x0000ffffUL << SCT_COUNT_CTR_L_Pos)
#define SCT_COUNT_CTR_H_Pos                                   16
#define SCT_COUNT_CTR_H_Msk                                   (0x0000ffffUL << SCT_COUNT_CTR_H_Pos)

// ----------------------------------------  SCT_STATE  -------------------------------------------
#define SCT_STATE_STATE_L_Pos                                 0
#define SCT_STATE_STATE_L_Msk                                 (0x1fUL << SCT_STATE_STATE_L_Pos)
#define SCT_STATE_STATE_H_Pos                                 16
#define SCT_STATE_STATE_H_Msk                                 (0x1fUL << SCT_STATE_STATE_H_Pos)

// ----------------------------------------  SCT_INPUT  -------------------------------------------
#define SCT_INPUT_AIN0_Pos                                    0
#define SCT_INPUT_AIN0_Msk                                    (0x01UL << SCT_INPUT_AIN0_Pos)
#define SCT_INPUT_AIN1_Pos                                    1
#define SCT_INPUT_AIN1_Msk                                    (0x01UL << SCT_INPUT_AIN1_Pos)
#define SCT_INPUT_AIN2_Pos                                    2
#define SCT_INPUT_AIN2_Msk                                    (0x01UL << SCT_INPUT_AIN2_Pos)
#define SCT_INPUT_AIN3_Pos                                    3
#define SCT_INPUT_AIN3_Msk                                    (0x01UL << SCT_INPUT_AIN3_Pos)
#define SCT_INPUT_AIN4_Pos                                    4
#define SCT_INPUT_AIN4_Msk                                    (0x01UL << SCT_INPUT_AIN4_Pos)
#define SCT_INPUT_AIN5_Pos                                    5
#define SCT_INPUT_AIN5_Msk                                    (0x01UL << SCT_INPUT_AIN5_Pos)
#define SCT_INPUT_AIN6_Pos                                    6
#define SCT_INPUT_AIN6_Msk                                    (0x01UL << SCT_INPUT_AIN6_Pos)
#define SCT_INPUT_AIN7_Pos                                    7
#define SCT_INPUT_AIN7_Msk                                    (0x01UL << SCT_INPUT_AIN7_Pos)
#define SCT_INPUT_SIN0_Pos                                    16
#define SCT_INPUT_SIN0_Msk                                    (0x01UL << SCT_INPUT_SIN0_Pos)
#define SCT_INPUT_SIN1_Pos                                    17
#define SCT_INPUT_SIN1_Msk                                    (0x01UL << SCT_INPUT_SIN1_Pos)
#define SCT_INPUT_SIN2_Pos                                    18
#define SCT_INPUT_SIN2_Msk                                    (0x01UL << SCT_INPUT_SIN2_Pos)
#define SCT_INPUT_SIN3_Pos                                    19
#define SCT_INPUT_SIN3_Msk                                    (0x01UL << SCT_INPUT_SIN3_Pos)
#define SCT_INPUT_SIN4_Pos                                    20
#define SCT_INPUT_SIN4_Msk                                    (0x01UL << SCT_INPUT_SIN4_Pos)
#define SCT_INPUT_SIN5_Pos                                    21
#define SCT_INPUT_SIN5_Msk                                    (0x01UL << SCT_INPUT_SIN5_Pos)
#define SCT_INPUT_SIN6_Pos                                    22
#define SCT_INPUT_SIN6_Msk                                    (0x01UL << SCT_INPUT_SIN6_Pos)
#define SCT_INPUT_SIN7_Pos                                    23
#define SCT_INPUT_SIN7_Msk                                    (0x01UL << SCT_INPUT_SIN7_Pos)

// ---------------------------------------  SCT_REGMODE  ------------------------------------------
#define SCT_REGMODE_REGMOD_L0_Pos                             0
#define SCT_REGMODE_REGMOD_L0_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L0_Pos)
#define SCT_REGMODE_REGMOD_L1_Pos                             1
#define SCT_REGMODE_REGMOD_L1_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L1_Pos)
#define SCT_REGMODE_REGMOD_L2_Pos                             2
#define SCT_REGMODE_REGMOD_L2_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L2_Pos)
#define SCT_REGMODE_REGMOD_L3_Pos                             3
#define SCT_REGMODE_REGMOD_L3_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L3_Pos)
#define SCT_REGMODE_REGMOD_L4_Pos                             4
#define SCT_REGMODE_REGMOD_L4_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L4_Pos)
#define SCT_REGMODE_REGMOD_L5_Pos                             5
#define SCT_REGMODE_REGMOD_L5_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L5_Pos)
#define SCT_REGMODE_REGMOD_L6_Pos                             6
#define SCT_REGMODE_REGMOD_L6_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L6_Pos)
#define SCT_REGMODE_REGMOD_L7_Pos                             7
#define SCT_REGMODE_REGMOD_L7_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L7_Pos)
#define SCT_REGMODE_REGMOD_L8_Pos                             8
#define SCT_REGMODE_REGMOD_L8_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L8_Pos)
#define SCT_REGMODE_REGMOD_L9_Pos                             9
#define SCT_REGMODE_REGMOD_L9_Msk                             (0x01UL << SCT_REGMODE_REGMOD_L9_Pos)
#define SCT_REGMODE_REGMOD_L10_Pos                            10
#define SCT_REGMODE_REGMOD_L10_Msk                            (0x01UL << SCT_REGMODE_REGMOD_L10_Pos)
#define SCT_REGMODE_REGMOD_L11_Pos                            11
#define SCT_REGMODE_REGMOD_L11_Msk                            (0x01UL << SCT_REGMODE_REGMOD_L11_Pos)
#define SCT_REGMODE_REGMOD_L12_Pos                            12
#define SCT_REGMODE_REGMOD_L12_Msk                            (0x01UL << SCT_REGMODE_REGMOD_L12_Pos)
#define SCT_REGMODE_REGMOD_L13_Pos                            13
#define SCT_REGMODE_REGMOD_L13_Msk                            (0x01UL << SCT_REGMODE_REGMOD_L13_Pos)
#define SCT_REGMODE_REGMOD_L14_Pos                            14
#define SCT_REGMODE_REGMOD_L14_Msk                            (0x01UL << SCT_REGMODE_REGMOD_L14_Pos)
#define SCT_REGMODE_REGMOD_L15_Pos                            15
#define SCT_REGMODE_REGMOD_L15_Msk                            (0x01UL << SCT_REGMODE_REGMOD_L15_Pos)
#define SCT_REGMODE_REGMOD_H16_Pos                            16
#define SCT_REGMODE_REGMOD_H16_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H16_Pos)
#define SCT_REGMODE_REGMOD_H17_Pos                            17
#define SCT_REGMODE_REGMOD_H17_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H17_Pos)
#define SCT_REGMODE_REGMOD_H18_Pos                            18
#define SCT_REGMODE_REGMOD_H18_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H18_Pos)
#define SCT_REGMODE_REGMOD_H19_Pos                            19
#define SCT_REGMODE_REGMOD_H19_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H19_Pos)
#define SCT_REGMODE_REGMOD_H20_Pos                            20
#define SCT_REGMODE_REGMOD_H20_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H20_Pos)
#define SCT_REGMODE_REGMOD_H21_Pos                            21
#define SCT_REGMODE_REGMOD_H21_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H21_Pos)
#define SCT_REGMODE_REGMOD_H22_Pos                            22
#define SCT_REGMODE_REGMOD_H22_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H22_Pos)
#define SCT_REGMODE_REGMOD_H23_Pos                            23
#define SCT_REGMODE_REGMOD_H23_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H23_Pos)
#define SCT_REGMODE_REGMOD_H24_Pos                            24
#define SCT_REGMODE_REGMOD_H24_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H24_Pos)
#define SCT_REGMODE_REGMOD_H25_Pos                            25
#define SCT_REGMODE_REGMOD_H25_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H25_Pos)
#define SCT_REGMODE_REGMOD_H26_Pos                            26
#define SCT_REGMODE_REGMOD_H26_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H26_Pos)
#define SCT_REGMODE_REGMOD_H27_Pos                            27
#define SCT_REGMODE_REGMOD_H27_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H27_Pos)
#define SCT_REGMODE_REGMOD_H28_Pos                            28
#define SCT_REGMODE_REGMOD_H28_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H28_Pos)
#define SCT_REGMODE_REGMOD_H29_Pos                            29
#define SCT_REGMODE_REGMOD_H29_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H29_Pos)
#define SCT_REGMODE_REGMOD_H30_Pos                            30
#define SCT_REGMODE_REGMOD_H30_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H30_Pos)
#define SCT_REGMODE_REGMOD_H31_Pos                            31
#define SCT_REGMODE_REGMOD_H31_Msk                            (0x01UL << SCT_REGMODE_REGMOD_H31_Pos)

// ---------------------------------------  SCT_OUTPUT  -------------------------------------------
#define SCT_OUTPUT_OUT0_Pos                                   0
#define SCT_OUTPUT_OUT0_Msk                                   (0x01UL << SCT_OUTPUT_OUT0_Pos)
#define SCT_OUTPUT_OUT1_Pos                                   1
#define SCT_OUTPUT_OUT1_Msk                                   (0x01UL << SCT_OUTPUT_OUT1_Pos)
#define SCT_OUTPUT_OUT2_Pos                                   2
#define SCT_OUTPUT_OUT2_Msk                                   (0x01UL << SCT_OUTPUT_OUT2_Pos)
#define SCT_OUTPUT_OUT3_Pos                                   3
#define SCT_OUTPUT_OUT3_Msk                                   (0x01UL << SCT_OUTPUT_OUT3_Pos)
#define SCT_OUTPUT_OUT4_Pos                                   4
#define SCT_OUTPUT_OUT4_Msk                                   (0x01UL << SCT_OUTPUT_OUT4_Pos)
#define SCT_OUTPUT_OUT5_Pos                                   5
#define SCT_OUTPUT_OUT5_Msk                                   (0x01UL << SCT_OUTPUT_OUT5_Pos)
#define SCT_OUTPUT_OUT6_Pos                                   6
#define SCT_OUTPUT_OUT6_Msk                                   (0x01UL << SCT_OUTPUT_OUT6_Pos)
#define SCT_OUTPUT_OUT7_Pos                                   7
#define SCT_OUTPUT_OUT7_Msk                                   (0x01UL << SCT_OUTPUT_OUT7_Pos)
#define SCT_OUTPUT_OUT8_Pos                                   8
#define SCT_OUTPUT_OUT8_Msk                                   (0x01UL << SCT_OUTPUT_OUT8_Pos)
#define SCT_OUTPUT_OUT9_Pos                                   9
#define SCT_OUTPUT_OUT9_Msk                                   (0x01UL << SCT_OUTPUT_OUT9_Pos)
#define SCT_OUTPUT_OUT10_Pos                                  10
#define SCT_OUTPUT_OUT10_Msk                                  (0x01UL << SCT_OUTPUT_OUT10_Pos)
#define SCT_OUTPUT_OUT11_Pos                                  11
#define SCT_OUTPUT_OUT11_Msk                                  (0x01UL << SCT_OUTPUT_OUT11_Pos)
#define SCT_OUTPUT_OUT12_Pos                                  12
#define SCT_OUTPUT_OUT12_Msk                                  (0x01UL << SCT_OUTPUT_OUT12_Pos)
#define SCT_OUTPUT_OUT13_Pos                                  13
#define SCT_OUTPUT_OUT13_Msk                                  (0x01UL << SCT_OUTPUT_OUT13_Pos)
#define SCT_OUTPUT_OUT14_Pos                                  14
#define SCT_OUTPUT_OUT14_Msk                                  (0x01UL << SCT_OUTPUT_OUT14_Pos)
#define SCT_OUTPUT_OUT15_Pos                                  15
#define SCT_OUTPUT_OUT15_Msk                                  (0x01UL << SCT_OUTPUT_OUT15_Pos)

// ------------------------------------  SCT_OUTPUTDIRCTRL  ---------------------------------------
#define SCT_OUTPUTDIRCTRL_SETCLR0_Pos                         0
#define SCT_OUTPUTDIRCTRL_SETCLR0_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR0_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR1_Pos                         2
#define SCT_OUTPUTDIRCTRL_SETCLR1_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR1_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR2_Pos                         4
#define SCT_OUTPUTDIRCTRL_SETCLR2_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR2_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR3_Pos                         6
#define SCT_OUTPUTDIRCTRL_SETCLR3_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR3_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR4_Pos                         8
#define SCT_OUTPUTDIRCTRL_SETCLR4_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR4_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR5_Pos                         10
#define SCT_OUTPUTDIRCTRL_SETCLR5_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR5_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR6_Pos                         12
#define SCT_OUTPUTDIRCTRL_SETCLR6_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR6_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR7_Pos                         14
#define SCT_OUTPUTDIRCTRL_SETCLR7_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR7_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR8_Pos                         16
#define SCT_OUTPUTDIRCTRL_SETCLR8_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR8_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR9_Pos                         18
#define SCT_OUTPUTDIRCTRL_SETCLR9_Msk                         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR9_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR10_Pos                        20
#define SCT_OUTPUTDIRCTRL_SETCLR10_Msk                        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR10_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR11_Pos                        22
#define SCT_OUTPUTDIRCTRL_SETCLR11_Msk                        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR11_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR12_Pos                        24
#define SCT_OUTPUTDIRCTRL_SETCLR12_Msk                        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR12_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR13_Pos                        26
#define SCT_OUTPUTDIRCTRL_SETCLR13_Msk                        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR13_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR14_Pos                        28
#define SCT_OUTPUTDIRCTRL_SETCLR14_Msk                        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR14_Pos)
#define SCT_OUTPUTDIRCTRL_SETCLR15_Pos                        30
#define SCT_OUTPUTDIRCTRL_SETCLR15_Msk                        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR15_Pos)

// -----------------------------------------  SCT_RES  --------------------------------------------
#define SCT_RES_O0RES_Pos                                     0
#define SCT_RES_O0RES_Msk                                     (0x03UL << SCT_RES_O0RES_Pos)
#define SCT_RES_O1RES_Pos                                     2
#define SCT_RES_O1RES_Msk                                     (0x03UL << SCT_RES_O1RES_Pos)
#define SCT_RES_O2RES_Pos                                     4
#define SCT_RES_O2RES_Msk                                     (0x03UL << SCT_RES_O2RES_Pos)
#define SCT_RES_O3RES_Pos                                     6
#define SCT_RES_O3RES_Msk                                     (0x03UL << SCT_RES_O3RES_Pos)
#define SCT_RES_O4RES_Pos                                     8
#define SCT_RES_O4RES_Msk                                     (0x03UL << SCT_RES_O4RES_Pos)
#define SCT_RES_O5RES_Pos                                     10
#define SCT_RES_O5RES_Msk                                     (0x03UL << SCT_RES_O5RES_Pos)
#define SCT_RES_O6RES_Pos                                     12
#define SCT_RES_O6RES_Msk                                     (0x03UL << SCT_RES_O6RES_Pos)
#define SCT_RES_O7RES_Pos                                     14
#define SCT_RES_O7RES_Msk                                     (0x03UL << SCT_RES_O7RES_Pos)
#define SCT_RES_O8RES_Pos                                     16
#define SCT_RES_O8RES_Msk                                     (0x03UL << SCT_RES_O8RES_Pos)
#define SCT_RES_O9RES_Pos                                     18
#define SCT_RES_O9RES_Msk                                     (0x03UL << SCT_RES_O9RES_Pos)
#define SCT_RES_O10RES_Pos                                    20
#define SCT_RES_O10RES_Msk                                    (0x03UL << SCT_RES_O10RES_Pos)
#define SCT_RES_O11RES_Pos                                    22
#define SCT_RES_O11RES_Msk                                    (0x03UL << SCT_RES_O11RES_Pos)
#define SCT_RES_O12RES_Pos                                    24
#define SCT_RES_O12RES_Msk                                    (0x03UL << SCT_RES_O12RES_Pos)
#define SCT_RES_O13RES_Pos                                    26
#define SCT_RES_O13RES_Msk                                    (0x03UL << SCT_RES_O13RES_Pos)
#define SCT_RES_O14RES_Pos                                    28
#define SCT_RES_O14RES_Msk                                    (0x03UL << SCT_RES_O14RES_Pos)
#define SCT_RES_O15RES_Pos                                    30
#define SCT_RES_O15RES_Msk                                    (0x03UL << SCT_RES_O15RES_Pos)

// ---------------------------------------  SCT_DMAREQ0  ------------------------------------------
#define SCT_DMAREQ0_DEV_0_0_Pos                               0
#define SCT_DMAREQ0_DEV_0_0_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_0_Pos)
#define SCT_DMAREQ0_DEV_0_1_Pos                               1
#define SCT_DMAREQ0_DEV_0_1_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_1_Pos)
#define SCT_DMAREQ0_DEV_0_2_Pos                               2
#define SCT_DMAREQ0_DEV_0_2_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_2_Pos)
#define SCT_DMAREQ0_DEV_0_3_Pos                               3
#define SCT_DMAREQ0_DEV_0_3_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_3_Pos)
#define SCT_DMAREQ0_DEV_0_4_Pos                               4
#define SCT_DMAREQ0_DEV_0_4_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_4_Pos)
#define SCT_DMAREQ0_DEV_0_5_Pos                               5
#define SCT_DMAREQ0_DEV_0_5_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_5_Pos)
#define SCT_DMAREQ0_DEV_0_6_Pos                               6
#define SCT_DMAREQ0_DEV_0_6_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_6_Pos)
#define SCT_DMAREQ0_DEV_0_7_Pos                               7
#define SCT_DMAREQ0_DEV_0_7_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_7_Pos)
#define SCT_DMAREQ0_DEV_0_8_Pos                               8
#define SCT_DMAREQ0_DEV_0_8_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_8_Pos)
#define SCT_DMAREQ0_DEV_0_9_Pos                               9
#define SCT_DMAREQ0_DEV_0_9_Msk                               (0x01UL << SCT_DMAREQ0_DEV_0_9_Pos)
#define SCT_DMAREQ0_DEV_0_10_Pos                              10
#define SCT_DMAREQ0_DEV_0_10_Msk                              (0x01UL << SCT_DMAREQ0_DEV_0_10_Pos)
#define SCT_DMAREQ0_DEV_0_11_Pos                              11
#define SCT_DMAREQ0_DEV_0_11_Msk                              (0x01UL << SCT_DMAREQ0_DEV_0_11_Pos)
#define SCT_DMAREQ0_DEV_0_12_Pos                              12
#define SCT_DMAREQ0_DEV_0_12_Msk                              (0x01UL << SCT_DMAREQ0_DEV_0_12_Pos)
#define SCT_DMAREQ0_DEV_0_13_Pos                              13
#define SCT_DMAREQ0_DEV_0_13_Msk                              (0x01UL << SCT_DMAREQ0_DEV_0_13_Pos)
#define SCT_DMAREQ0_DEV_0_14_Pos                              14
#define SCT_DMAREQ0_DEV_0_14_Msk                              (0x01UL << SCT_DMAREQ0_DEV_0_14_Pos)
#define SCT_DMAREQ0_DEV_0_15_Pos                              15
#define SCT_DMAREQ0_DEV_0_15_Msk                              (0x01UL << SCT_DMAREQ0_DEV_0_15_Pos)
#define SCT_DMAREQ0_DRL0_Pos                                  30
#define SCT_DMAREQ0_DRL0_Msk                                  (0x01UL << SCT_DMAREQ0_DRL0_Pos)
#define SCT_DMAREQ0_DRQ0_Pos                                  31
#define SCT_DMAREQ0_DRQ0_Msk                                  (0x01UL << SCT_DMAREQ0_DRQ0_Pos)

// ---------------------------------------  SCT_DMAREQ1  ------------------------------------------
#define SCT_DMAREQ1_DEV_1_0_Pos                               0
#define SCT_DMAREQ1_DEV_1_0_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_0_Pos)
#define SCT_DMAREQ1_DEV_1_1_Pos                               1
#define SCT_DMAREQ1_DEV_1_1_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_1_Pos)
#define SCT_DMAREQ1_DEV_1_2_Pos                               2
#define SCT_DMAREQ1_DEV_1_2_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_2_Pos)
#define SCT_DMAREQ1_DEV_1_3_Pos                               3
#define SCT_DMAREQ1_DEV_1_3_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_3_Pos)
#define SCT_DMAREQ1_DEV_1_4_Pos                               4
#define SCT_DMAREQ1_DEV_1_4_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_4_Pos)
#define SCT_DMAREQ1_DEV_1_5_Pos                               5
#define SCT_DMAREQ1_DEV_1_5_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_5_Pos)
#define SCT_DMAREQ1_DEV_1_6_Pos                               6
#define SCT_DMAREQ1_DEV_1_6_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_6_Pos)
#define SCT_DMAREQ1_DEV_1_7_Pos                               7
#define SCT_DMAREQ1_DEV_1_7_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_7_Pos)
#define SCT_DMAREQ1_DEV_1_8_Pos                               8
#define SCT_DMAREQ1_DEV_1_8_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_8_Pos)
#define SCT_DMAREQ1_DEV_1_9_Pos                               9
#define SCT_DMAREQ1_DEV_1_9_Msk                               (0x01UL << SCT_DMAREQ1_DEV_1_9_Pos)
#define SCT_DMAREQ1_DEV_1_10_Pos                              10
#define SCT_DMAREQ1_DEV_1_10_Msk                              (0x01UL << SCT_DMAREQ1_DEV_1_10_Pos)
#define SCT_DMAREQ1_DEV_1_11_Pos                              11
#define SCT_DMAREQ1_DEV_1_11_Msk                              (0x01UL << SCT_DMAREQ1_DEV_1_11_Pos)
#define SCT_DMAREQ1_DEV_1_12_Pos                              12
#define SCT_DMAREQ1_DEV_1_12_Msk                              (0x01UL << SCT_DMAREQ1_DEV_1_12_Pos)
#define SCT_DMAREQ1_DEV_1_13_Pos                              13
#define SCT_DMAREQ1_DEV_1_13_Msk                              (0x01UL << SCT_DMAREQ1_DEV_1_13_Pos)
#define SCT_DMAREQ1_DEV_1_14_Pos                              14
#define SCT_DMAREQ1_DEV_1_14_Msk                              (0x01UL << SCT_DMAREQ1_DEV_1_14_Pos)
#define SCT_DMAREQ1_DEV_1_15_Pos                              15
#define SCT_DMAREQ1_DEV_1_15_Msk                              (0x01UL << SCT_DMAREQ1_DEV_1_15_Pos)
#define SCT_DMAREQ1_DRL1_Pos                                  30
#define SCT_DMAREQ1_DRL1_Msk                                  (0x01UL << SCT_DMAREQ1_DRL1_Pos)
#define SCT_DMAREQ1_DRQ1_Pos                                  31
#define SCT_DMAREQ1_DRQ1_Msk                                  (0x01UL << SCT_DMAREQ1_DRQ1_Pos)

// ----------------------------------------  SCT_EVEN  --------------------------------------------
#define SCT_EVEN_IEN0_Pos                                     0
#define SCT_EVEN_IEN0_Msk                                     (0x01UL << SCT_EVEN_IEN0_Pos)
#define SCT_EVEN_IEN1_Pos                                     1
#define SCT_EVEN_IEN1_Msk                                     (0x01UL << SCT_EVEN_IEN1_Pos)
#define SCT_EVEN_IEN2_Pos                                     2
#define SCT_EVEN_IEN2_Msk                                     (0x01UL << SCT_EVEN_IEN2_Pos)
#define SCT_EVEN_IEN3_Pos                                     3
#define SCT_EVEN_IEN3_Msk                                     (0x01UL << SCT_EVEN_IEN3_Pos)
#define SCT_EVEN_IEN4_Pos                                     4
#define SCT_EVEN_IEN4_Msk                                     (0x01UL << SCT_EVEN_IEN4_Pos)
#define SCT_EVEN_IEN5_Pos                                     5
#define SCT_EVEN_IEN5_Msk                                     (0x01UL << SCT_EVEN_IEN5_Pos)
#define SCT_EVEN_IEN6_Pos                                     6
#define SCT_EVEN_IEN6_Msk                                     (0x01UL << SCT_EVEN_IEN6_Pos)
#define SCT_EVEN_IEN7_Pos                                     7
#define SCT_EVEN_IEN7_Msk                                     (0x01UL << SCT_EVEN_IEN7_Pos)
#define SCT_EVEN_IEN8_Pos                                     8
#define SCT_EVEN_IEN8_Msk                                     (0x01UL << SCT_EVEN_IEN8_Pos)
#define SCT_EVEN_IEN9_Pos                                     9
#define SCT_EVEN_IEN9_Msk                                     (0x01UL << SCT_EVEN_IEN9_Pos)
#define SCT_EVEN_IEN10_Pos                                    10
#define SCT_EVEN_IEN10_Msk                                    (0x01UL << SCT_EVEN_IEN10_Pos)
#define SCT_EVEN_IEN11_Pos                                    11
#define SCT_EVEN_IEN11_Msk                                    (0x01UL << SCT_EVEN_IEN11_Pos)
#define SCT_EVEN_IEN12_Pos                                    12
#define SCT_EVEN_IEN12_Msk                                    (0x01UL << SCT_EVEN_IEN12_Pos)
#define SCT_EVEN_IEN13_Pos                                    13
#define SCT_EVEN_IEN13_Msk                                    (0x01UL << SCT_EVEN_IEN13_Pos)
#define SCT_EVEN_IEN14_Pos                                    14
#define SCT_EVEN_IEN14_Msk                                    (0x01UL << SCT_EVEN_IEN14_Pos)
#define SCT_EVEN_IEN15_Pos                                    15
#define SCT_EVEN_IEN15_Msk                                    (0x01UL << SCT_EVEN_IEN15_Pos)

// ---------------------------------------  SCT_EVFLAG  -------------------------------------------
#define SCT_EVFLAG_FLAG0_Pos                                  0
#define SCT_EVFLAG_FLAG0_Msk                                  (0x01UL << SCT_EVFLAG_FLAG0_Pos)
#define SCT_EVFLAG_FLAG1_Pos                                  1
#define SCT_EVFLAG_FLAG1_Msk                                  (0x01UL << SCT_EVFLAG_FLAG1_Pos)
#define SCT_EVFLAG_FLAG2_Pos                                  2
#define SCT_EVFLAG_FLAG2_Msk                                  (0x01UL << SCT_EVFLAG_FLAG2_Pos)
#define SCT_EVFLAG_FLAG3_Pos                                  3
#define SCT_EVFLAG_FLAG3_Msk                                  (0x01UL << SCT_EVFLAG_FLAG3_Pos)
#define SCT_EVFLAG_FLAG4_Pos                                  4
#define SCT_EVFLAG_FLAG4_Msk                                  (0x01UL << SCT_EVFLAG_FLAG4_Pos)
#define SCT_EVFLAG_FLAG5_Pos                                  5
#define SCT_EVFLAG_FLAG5_Msk                                  (0x01UL << SCT_EVFLAG_FLAG5_Pos)
#define SCT_EVFLAG_FLAG6_Pos                                  6
#define SCT_EVFLAG_FLAG6_Msk                                  (0x01UL << SCT_EVFLAG_FLAG6_Pos)
#define SCT_EVFLAG_FLAG7_Pos                                  7
#define SCT_EVFLAG_FLAG7_Msk                                  (0x01UL << SCT_EVFLAG_FLAG7_Pos)
#define SCT_EVFLAG_FLAG8_Pos                                  8
#define SCT_EVFLAG_FLAG8_Msk                                  (0x01UL << SCT_EVFLAG_FLAG8_Pos)
#define SCT_EVFLAG_FLAG9_Pos                                  9
#define SCT_EVFLAG_FLAG9_Msk                                  (0x01UL << SCT_EVFLAG_FLAG9_Pos)
#define SCT_EVFLAG_FLAG10_Pos                                 10
#define SCT_EVFLAG_FLAG10_Msk                                 (0x01UL << SCT_EVFLAG_FLAG10_Pos)
#define SCT_EVFLAG_FLAG11_Pos                                 11
#define SCT_EVFLAG_FLAG11_Msk                                 (0x01UL << SCT_EVFLAG_FLAG11_Pos)
#define SCT_EVFLAG_FLAG12_Pos                                 12
#define SCT_EVFLAG_FLAG12_Msk                                 (0x01UL << SCT_EVFLAG_FLAG12_Pos)
#define SCT_EVFLAG_FLAG13_Pos                                 13
#define SCT_EVFLAG_FLAG13_Msk                                 (0x01UL << SCT_EVFLAG_FLAG13_Pos)
#define SCT_EVFLAG_FLAG14_Pos                                 14
#define SCT_EVFLAG_FLAG14_Msk                                 (0x01UL << SCT_EVFLAG_FLAG14_Pos)
#define SCT_EVFLAG_FLAG15_Pos                                 15
#define SCT_EVFLAG_FLAG15_Msk                                 (0x01UL << SCT_EVFLAG_FLAG15_Pos)

// ----------------------------------------  SCT_CONEN  -------------------------------------------
#define SCT_CONEN_NCEN0_Pos                                   0
#define SCT_CONEN_NCEN0_Msk                                   (0x01UL << SCT_CONEN_NCEN0_Pos)
#define SCT_CONEN_NCEN1_Pos                                   1
#define SCT_CONEN_NCEN1_Msk                                   (0x01UL << SCT_CONEN_NCEN1_Pos)
#define SCT_CONEN_NCEN2_Pos                                   2
#define SCT_CONEN_NCEN2_Msk                                   (0x01UL << SCT_CONEN_NCEN2_Pos)
#define SCT_CONEN_NCEN3_Pos                                   3
#define SCT_CONEN_NCEN3_Msk                                   (0x01UL << SCT_CONEN_NCEN3_Pos)
#define SCT_CONEN_NCEN4_Pos                                   4
#define SCT_CONEN_NCEN4_Msk                                   (0x01UL << SCT_CONEN_NCEN4_Pos)
#define SCT_CONEN_NCEN5_Pos                                   5
#define SCT_CONEN_NCEN5_Msk                                   (0x01UL << SCT_CONEN_NCEN5_Pos)
#define SCT_CONEN_NCEN6_Pos                                   6
#define SCT_CONEN_NCEN6_Msk                                   (0x01UL << SCT_CONEN_NCEN6_Pos)
#define SCT_CONEN_NCEN7_Pos                                   7
#define SCT_CONEN_NCEN7_Msk                                   (0x01UL << SCT_CONEN_NCEN7_Pos)
#define SCT_CONEN_NCEN8_Pos                                   8
#define SCT_CONEN_NCEN8_Msk                                   (0x01UL << SCT_CONEN_NCEN8_Pos)
#define SCT_CONEN_NCEN9_Pos                                   9
#define SCT_CONEN_NCEN9_Msk                                   (0x01UL << SCT_CONEN_NCEN9_Pos)
#define SCT_CONEN_NCEN10_Pos                                  10
#define SCT_CONEN_NCEN10_Msk                                  (0x01UL << SCT_CONEN_NCEN10_Pos)
#define SCT_CONEN_NCEN11_Pos                                  11
#define SCT_CONEN_NCEN11_Msk                                  (0x01UL << SCT_CONEN_NCEN11_Pos)
#define SCT_CONEN_NCEN12_Pos                                  12
#define SCT_CONEN_NCEN12_Msk                                  (0x01UL << SCT_CONEN_NCEN12_Pos)
#define SCT_CONEN_NCEN13_Pos                                  13
#define SCT_CONEN_NCEN13_Msk                                  (0x01UL << SCT_CONEN_NCEN13_Pos)
#define SCT_CONEN_NCEN14_Pos                                  14
#define SCT_CONEN_NCEN14_Msk                                  (0x01UL << SCT_CONEN_NCEN14_Pos)
#define SCT_CONEN_NCEN15_Pos                                  15
#define SCT_CONEN_NCEN15_Msk                                  (0x01UL << SCT_CONEN_NCEN15_Pos)

// ---------------------------------------  SCT_CONFLAG  ------------------------------------------
#define SCT_CONFLAG_NCFLAG0_Pos                               0
#define SCT_CONFLAG_NCFLAG0_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG0_Pos)
#define SCT_CONFLAG_NCFLAG1_Pos                               1
#define SCT_CONFLAG_NCFLAG1_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG1_Pos)
#define SCT_CONFLAG_NCFLAG2_Pos                               2
#define SCT_CONFLAG_NCFLAG2_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG2_Pos)
#define SCT_CONFLAG_NCFLAG3_Pos                               3
#define SCT_CONFLAG_NCFLAG3_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG3_Pos)
#define SCT_CONFLAG_NCFLAG4_Pos                               4
#define SCT_CONFLAG_NCFLAG4_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG4_Pos)
#define SCT_CONFLAG_NCFLAG5_Pos                               5
#define SCT_CONFLAG_NCFLAG5_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG5_Pos)
#define SCT_CONFLAG_NCFLAG6_Pos                               6
#define SCT_CONFLAG_NCFLAG6_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG6_Pos)
#define SCT_CONFLAG_NCFLAG7_Pos                               7
#define SCT_CONFLAG_NCFLAG7_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG7_Pos)
#define SCT_CONFLAG_NCFLAG8_Pos                               8
#define SCT_CONFLAG_NCFLAG8_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG8_Pos)
#define SCT_CONFLAG_NCFLAG9_Pos                               9
#define SCT_CONFLAG_NCFLAG9_Msk                               (0x01UL << SCT_CONFLAG_NCFLAG9_Pos)
#define SCT_CONFLAG_NCFLAG10_Pos                              10
#define SCT_CONFLAG_NCFLAG10_Msk                              (0x01UL << SCT_CONFLAG_NCFLAG10_Pos)
#define SCT_CONFLAG_NCFLAG11_Pos                              11
#define SCT_CONFLAG_NCFLAG11_Msk                              (0x01UL << SCT_CONFLAG_NCFLAG11_Pos)
#define SCT_CONFLAG_NCFLAG12_Pos                              12
#define SCT_CONFLAG_NCFLAG12_Msk                              (0x01UL << SCT_CONFLAG_NCFLAG12_Pos)
#define SCT_CONFLAG_NCFLAG13_Pos                              13
#define SCT_CONFLAG_NCFLAG13_Msk                              (0x01UL << SCT_CONFLAG_NCFLAG13_Pos)
#define SCT_CONFLAG_NCFLAG14_Pos                              14
#define SCT_CONFLAG_NCFLAG14_Msk                              (0x01UL << SCT_CONFLAG_NCFLAG14_Pos)
#define SCT_CONFLAG_NCFLAG15_Pos                              15
#define SCT_CONFLAG_NCFLAG15_Msk                              (0x01UL << SCT_CONFLAG_NCFLAG15_Pos)
#define SCT_CONFLAG_BUSERRL_Pos                               30
#define SCT_CONFLAG_BUSERRL_Msk                               (0x01UL << SCT_CONFLAG_BUSERRL_Pos)
#define SCT_CONFLAG_BUSERRH_Pos                               31
#define SCT_CONFLAG_BUSERRH_Msk                               (0x01UL << SCT_CONFLAG_BUSERRH_Pos)

// ---------------------------------------  SCT_MATCH0  -------------------------------------------
#define SCT_MATCH0_MATCHn_L_Pos                               0
#define SCT_MATCH0_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH0_MATCHn_L_Pos)
#define SCT_MATCH0_MATCHn_H_Pos                               16
#define SCT_MATCH0_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH0_MATCHn_H_Pos)

// ----------------------------------------  SCT_CAP0  --------------------------------------------
#define SCT_CAP0_CAPn_L_Pos                                   0
#define SCT_CAP0_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP0_CAPn_L_Pos)
#define SCT_CAP0_CAPn_H_Pos                                   16
#define SCT_CAP0_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP0_CAPn_H_Pos)

// ---------------------------------------  SCT_MATCH1  -------------------------------------------
#define SCT_MATCH1_MATCHn_L_Pos                               0
#define SCT_MATCH1_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH1_MATCHn_L_Pos)
#define SCT_MATCH1_MATCHn_H_Pos                               16
#define SCT_MATCH1_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH1_MATCHn_H_Pos)

// ----------------------------------------  SCT_CAP1  --------------------------------------------
#define SCT_CAP1_CAPn_L_Pos                                   0
#define SCT_CAP1_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP1_CAPn_L_Pos)
#define SCT_CAP1_CAPn_H_Pos                                   16
#define SCT_CAP1_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP1_CAPn_H_Pos)

// ---------------------------------------  SCT_MATCH2  -------------------------------------------
#define SCT_MATCH2_MATCHn_L_Pos                               0
#define SCT_MATCH2_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH2_MATCHn_L_Pos)
#define SCT_MATCH2_MATCHn_H_Pos                               16
#define SCT_MATCH2_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH2_MATCHn_H_Pos)

// ----------------------------------------  SCT_CAP2  --------------------------------------------
#define SCT_CAP2_CAPn_L_Pos                                   0
#define SCT_CAP2_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP2_CAPn_L_Pos)
#define SCT_CAP2_CAPn_H_Pos                                   16
#define SCT_CAP2_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP2_CAPn_H_Pos)

// ----------------------------------------  SCT_CAP3  --------------------------------------------
#define SCT_CAP3_CAPn_L_Pos                                   0
#define SCT_CAP3_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP3_CAPn_L_Pos)
#define SCT_CAP3_CAPn_H_Pos                                   16
#define SCT_CAP3_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP3_CAPn_H_Pos)

// ---------------------------------------  SCT_MATCH3  -------------------------------------------
#define SCT_MATCH3_MATCHn_L_Pos                               0
#define SCT_MATCH3_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH3_MATCHn_L_Pos)
#define SCT_MATCH3_MATCHn_H_Pos                               16
#define SCT_MATCH3_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH3_MATCHn_H_Pos)

// ---------------------------------------  SCT_MATCH4  -------------------------------------------
#define SCT_MATCH4_MATCHn_L_Pos                               0
#define SCT_MATCH4_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH4_MATCHn_L_Pos)
#define SCT_MATCH4_MATCHn_H_Pos                               16
#define SCT_MATCH4_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH4_MATCHn_H_Pos)

// ----------------------------------------  SCT_CAP4  --------------------------------------------
#define SCT_CAP4_CAPn_L_Pos                                   0
#define SCT_CAP4_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP4_CAPn_L_Pos)
#define SCT_CAP4_CAPn_H_Pos                                   16
#define SCT_CAP4_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP4_CAPn_H_Pos)

// ---------------------------------------  SCT_MATCH5  -------------------------------------------
#define SCT_MATCH5_MATCHn_L_Pos                               0
#define SCT_MATCH5_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH5_MATCHn_L_Pos)
#define SCT_MATCH5_MATCHn_H_Pos                               16
#define SCT_MATCH5_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH5_MATCHn_H_Pos)

// ----------------------------------------  SCT_CAP5  --------------------------------------------
#define SCT_CAP5_CAPn_L_Pos                                   0
#define SCT_CAP5_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP5_CAPn_L_Pos)
#define SCT_CAP5_CAPn_H_Pos                                   16
#define SCT_CAP5_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP5_CAPn_H_Pos)

// ---------------------------------------  SCT_MATCH6  -------------------------------------------
#define SCT_MATCH6_MATCHn_L_Pos                               0
#define SCT_MATCH6_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH6_MATCHn_L_Pos)
#define SCT_MATCH6_MATCHn_H_Pos                               16
#define SCT_MATCH6_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH6_MATCHn_H_Pos)

// ----------------------------------------  SCT_CAP6  --------------------------------------------
#define SCT_CAP6_CAPn_L_Pos                                   0
#define SCT_CAP6_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP6_CAPn_L_Pos)
#define SCT_CAP6_CAPn_H_Pos                                   16
#define SCT_CAP6_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP6_CAPn_H_Pos)

// ----------------------------------------  SCT_CAP7  --------------------------------------------
#define SCT_CAP7_CAPn_L_Pos                                   0
#define SCT_CAP7_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP7_CAPn_L_Pos)
#define SCT_CAP7_CAPn_H_Pos                                   16
#define SCT_CAP7_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP7_CAPn_H_Pos)

// ---------------------------------------  SCT_MATCH7  -------------------------------------------
#define SCT_MATCH7_MATCHn_L_Pos                               0
#define SCT_MATCH7_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH7_MATCHn_L_Pos)
#define SCT_MATCH7_MATCHn_H_Pos                               16
#define SCT_MATCH7_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH7_MATCHn_H_Pos)

// ----------------------------------------  SCT_CAP8  --------------------------------------------
#define SCT_CAP8_CAPn_L_Pos                                   0
#define SCT_CAP8_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP8_CAPn_L_Pos)
#define SCT_CAP8_CAPn_H_Pos                                   16
#define SCT_CAP8_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP8_CAPn_H_Pos)

// ---------------------------------------  SCT_MATCH8  -------------------------------------------
#define SCT_MATCH8_MATCHn_L_Pos                               0
#define SCT_MATCH8_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH8_MATCHn_L_Pos)
#define SCT_MATCH8_MATCHn_H_Pos                               16
#define SCT_MATCH8_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH8_MATCHn_H_Pos)

// ---------------------------------------  SCT_MATCH9  -------------------------------------------
#define SCT_MATCH9_MATCHn_L_Pos                               0
#define SCT_MATCH9_MATCHn_L_Msk                               (0x0000ffffUL << SCT_MATCH9_MATCHn_L_Pos)
#define SCT_MATCH9_MATCHn_H_Pos                               16
#define SCT_MATCH9_MATCHn_H_Msk                               (0x0000ffffUL << SCT_MATCH9_MATCHn_H_Pos)

// ----------------------------------------  SCT_CAP9  --------------------------------------------
#define SCT_CAP9_CAPn_L_Pos                                   0
#define SCT_CAP9_CAPn_L_Msk                                   (0x0000ffffUL << SCT_CAP9_CAPn_L_Pos)
#define SCT_CAP9_CAPn_H_Pos                                   16
#define SCT_CAP9_CAPn_H_Msk                                   (0x0000ffffUL << SCT_CAP9_CAPn_H_Pos)

// ----------------------------------------  SCT_CAP10  -------------------------------------------
#define SCT_CAP10_CAPn_L_Pos                                  0
#define SCT_CAP10_CAPn_L_Msk                                  (0x0000ffffUL << SCT_CAP10_CAPn_L_Pos)
#define SCT_CAP10_CAPn_H_Pos                                  16
#define SCT_CAP10_CAPn_H_Msk                                  (0x0000ffffUL << SCT_CAP10_CAPn_H_Pos)

// ---------------------------------------  SCT_MATCH10  ------------------------------------------
#define SCT_MATCH10_MATCHn_L_Pos                              0
#define SCT_MATCH10_MATCHn_L_Msk                              (0x0000ffffUL << SCT_MATCH10_MATCHn_L_Pos)
#define SCT_MATCH10_MATCHn_H_Pos                              16
#define SCT_MATCH10_MATCHn_H_Msk                              (0x0000ffffUL << SCT_MATCH10_MATCHn_H_Pos)

// ----------------------------------------  SCT_CAP11  -------------------------------------------
#define SCT_CAP11_CAPn_L_Pos                                  0
#define SCT_CAP11_CAPn_L_Msk                                  (0x0000ffffUL << SCT_CAP11_CAPn_L_Pos)
#define SCT_CAP11_CAPn_H_Pos                                  16
#define SCT_CAP11_CAPn_H_Msk                                  (0x0000ffffUL << SCT_CAP11_CAPn_H_Pos)

// ---------------------------------------  SCT_MATCH11  ------------------------------------------
#define SCT_MATCH11_MATCHn_L_Pos                              0
#define SCT_MATCH11_MATCHn_L_Msk                              (0x0000ffffUL << SCT_MATCH11_MATCHn_L_Pos)
#define SCT_MATCH11_MATCHn_H_Pos                              16
#define SCT_MATCH11_MATCHn_H_Msk                              (0x0000ffffUL << SCT_MATCH11_MATCHn_H_Pos)

// ---------------------------------------  SCT_MATCH12  ------------------------------------------
#define SCT_MATCH12_MATCHn_L_Pos                              0
#define SCT_MATCH12_MATCHn_L_Msk                              (0x0000ffffUL << SCT_MATCH12_MATCHn_L_Pos)
#define SCT_MATCH12_MATCHn_H_Pos                              16
#define SCT_MATCH12_MATCHn_H_Msk                              (0x0000ffffUL << SCT_MATCH12_MATCHn_H_Pos)

// ----------------------------------------  SCT_CAP12  -------------------------------------------
#define SCT_CAP12_CAPn_L_Pos                                  0
#define SCT_CAP12_CAPn_L_Msk                                  (0x0000ffffUL << SCT_CAP12_CAPn_L_Pos)
#define SCT_CAP12_CAPn_H_Pos                                  16
#define SCT_CAP12_CAPn_H_Msk                                  (0x0000ffffUL << SCT_CAP12_CAPn_H_Pos)

// ----------------------------------------  SCT_CAP13  -------------------------------------------
#define SCT_CAP13_CAPn_L_Pos                                  0
#define SCT_CAP13_CAPn_L_Msk                                  (0x0000ffffUL << SCT_CAP13_CAPn_L_Pos)
#define SCT_CAP13_CAPn_H_Pos                                  16
#define SCT_CAP13_CAPn_H_Msk                                  (0x0000ffffUL << SCT_CAP13_CAPn_H_Pos)

// ---------------------------------------  SCT_MATCH13  ------------------------------------------
#define SCT_MATCH13_MATCHn_L_Pos                              0
#define SCT_MATCH13_MATCHn_L_Msk                              (0x0000ffffUL << SCT_MATCH13_MATCHn_L_Pos)
#define SCT_MATCH13_MATCHn_H_Pos                              16
#define SCT_MATCH13_MATCHn_H_Msk                              (0x0000ffffUL << SCT_MATCH13_MATCHn_H_Pos)

// ---------------------------------------  SCT_MATCH14  ------------------------------------------
#define SCT_MATCH14_MATCHn_L_Pos                              0
#define SCT_MATCH14_MATCHn_L_Msk                              (0x0000ffffUL << SCT_MATCH14_MATCHn_L_Pos)
#define SCT_MATCH14_MATCHn_H_Pos                              16
#define SCT_MATCH14_MATCHn_H_Msk                              (0x0000ffffUL << SCT_MATCH14_MATCHn_H_Pos)

// ----------------------------------------  SCT_CAP14  -------------------------------------------
#define SCT_CAP14_CAPn_L_Pos                                  0
#define SCT_CAP14_CAPn_L_Msk                                  (0x0000ffffUL << SCT_CAP14_CAPn_L_Pos)
#define SCT_CAP14_CAPn_H_Pos                                  16
#define SCT_CAP14_CAPn_H_Msk                                  (0x0000ffffUL << SCT_CAP14_CAPn_H_Pos)

// ---------------------------------------  SCT_MATCH15  ------------------------------------------
#define SCT_MATCH15_MATCHn_L_Pos                              0
#define SCT_MATCH15_MATCHn_L_Msk                              (0x0000ffffUL << SCT_MATCH15_MATCHn_L_Pos)
#define SCT_MATCH15_MATCHn_H_Pos                              16
#define SCT_MATCH15_MATCHn_H_Msk                              (0x0000ffffUL << SCT_MATCH15_MATCHn_H_Pos)

// ----------------------------------------  SCT_CAP15  -------------------------------------------
#define SCT_CAP15_CAPn_L_Pos                                  0
#define SCT_CAP15_CAPn_L_Msk                                  (0x0000ffffUL << SCT_CAP15_CAPn_L_Pos)
#define SCT_CAP15_CAPn_H_Pos                                  16
#define SCT_CAP15_CAPn_H_Msk                                  (0x0000ffffUL << SCT_CAP15_CAPn_H_Pos)

// --------------------------------------  SCT_MATCHREL0  -----------------------------------------
#define SCT_MATCHREL0_RELOADn_L_Pos                           0
#define SCT_MATCHREL0_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL0_RELOADn_L_Pos)
#define SCT_MATCHREL0_RELOADn_H_Pos                           16
#define SCT_MATCHREL0_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL0_RELOADn_H_Pos)

// --------------------------------------  SCT_CAPCTRL0  ------------------------------------------
#define SCT_CAPCTRL0_CAPCONn_L0_Pos                           0
#define SCT_CAPCTRL0_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L0_Pos)
#define SCT_CAPCTRL0_CAPCONn_L1_Pos                           1
#define SCT_CAPCTRL0_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L1_Pos)
#define SCT_CAPCTRL0_CAPCONn_L2_Pos                           2
#define SCT_CAPCTRL0_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L2_Pos)
#define SCT_CAPCTRL0_CAPCONn_L3_Pos                           3
#define SCT_CAPCTRL0_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L3_Pos)
#define SCT_CAPCTRL0_CAPCONn_L4_Pos                           4
#define SCT_CAPCTRL0_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L4_Pos)
#define SCT_CAPCTRL0_CAPCONn_L5_Pos                           5
#define SCT_CAPCTRL0_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L5_Pos)
#define SCT_CAPCTRL0_CAPCONn_L6_Pos                           6
#define SCT_CAPCTRL0_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L6_Pos)
#define SCT_CAPCTRL0_CAPCONn_L7_Pos                           7
#define SCT_CAPCTRL0_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L7_Pos)
#define SCT_CAPCTRL0_CAPCONn_L8_Pos                           8
#define SCT_CAPCTRL0_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L8_Pos)
#define SCT_CAPCTRL0_CAPCONn_L9_Pos                           9
#define SCT_CAPCTRL0_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL0_CAPCONn_L9_Pos)
#define SCT_CAPCTRL0_CAPCONn_L10_Pos                          10
#define SCT_CAPCTRL0_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL0_CAPCONn_L10_Pos)
#define SCT_CAPCTRL0_CAPCONn_L11_Pos                          11
#define SCT_CAPCTRL0_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL0_CAPCONn_L11_Pos)
#define SCT_CAPCTRL0_CAPCONn_L12_Pos                          12
#define SCT_CAPCTRL0_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL0_CAPCONn_L12_Pos)
#define SCT_CAPCTRL0_CAPCONn_L13_Pos                          13
#define SCT_CAPCTRL0_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL0_CAPCONn_L13_Pos)
#define SCT_CAPCTRL0_CAPCONn_L14_Pos                          14
#define SCT_CAPCTRL0_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL0_CAPCONn_L14_Pos)
#define SCT_CAPCTRL0_CAPCONn_L15_Pos                          15
#define SCT_CAPCTRL0_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL0_CAPCONn_L15_Pos)
#define SCT_CAPCTRL0_CAPCONn_H_Pos                            16
#define SCT_CAPCTRL0_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL0_CAPCONn_H_Pos)

// --------------------------------------  SCT_MATCHREL1  -----------------------------------------
#define SCT_MATCHREL1_RELOADn_L_Pos                           0
#define SCT_MATCHREL1_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL1_RELOADn_L_Pos)
#define SCT_MATCHREL1_RELOADn_H_Pos                           16
#define SCT_MATCHREL1_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL1_RELOADn_H_Pos)

// --------------------------------------  SCT_CAPCTRL1  ------------------------------------------
#define SCT_CAPCTRL1_CAPCONn_L0_Pos                           0
#define SCT_CAPCTRL1_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L0_Pos)
#define SCT_CAPCTRL1_CAPCONn_L1_Pos                           1
#define SCT_CAPCTRL1_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L1_Pos)
#define SCT_CAPCTRL1_CAPCONn_L2_Pos                           2
#define SCT_CAPCTRL1_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L2_Pos)
#define SCT_CAPCTRL1_CAPCONn_L3_Pos                           3
#define SCT_CAPCTRL1_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L3_Pos)
#define SCT_CAPCTRL1_CAPCONn_L4_Pos                           4
#define SCT_CAPCTRL1_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L4_Pos)
#define SCT_CAPCTRL1_CAPCONn_L5_Pos                           5
#define SCT_CAPCTRL1_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L5_Pos)
#define SCT_CAPCTRL1_CAPCONn_L6_Pos                           6
#define SCT_CAPCTRL1_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L6_Pos)
#define SCT_CAPCTRL1_CAPCONn_L7_Pos                           7
#define SCT_CAPCTRL1_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L7_Pos)
#define SCT_CAPCTRL1_CAPCONn_L8_Pos                           8
#define SCT_CAPCTRL1_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L8_Pos)
#define SCT_CAPCTRL1_CAPCONn_L9_Pos                           9
#define SCT_CAPCTRL1_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL1_CAPCONn_L9_Pos)
#define SCT_CAPCTRL1_CAPCONn_L10_Pos                          10
#define SCT_CAPCTRL1_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL1_CAPCONn_L10_Pos)
#define SCT_CAPCTRL1_CAPCONn_L11_Pos                          11
#define SCT_CAPCTRL1_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL1_CAPCONn_L11_Pos)
#define SCT_CAPCTRL1_CAPCONn_L12_Pos                          12
#define SCT_CAPCTRL1_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL1_CAPCONn_L12_Pos)
#define SCT_CAPCTRL1_CAPCONn_L13_Pos                          13
#define SCT_CAPCTRL1_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL1_CAPCONn_L13_Pos)
#define SCT_CAPCTRL1_CAPCONn_L14_Pos                          14
#define SCT_CAPCTRL1_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL1_CAPCONn_L14_Pos)
#define SCT_CAPCTRL1_CAPCONn_L15_Pos                          15
#define SCT_CAPCTRL1_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL1_CAPCONn_L15_Pos)
#define SCT_CAPCTRL1_CAPCONn_H_Pos                            16
#define SCT_CAPCTRL1_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL1_CAPCONn_H_Pos)

// --------------------------------------  SCT_MATCHREL2  -----------------------------------------
#define SCT_MATCHREL2_RELOADn_L_Pos                           0
#define SCT_MATCHREL2_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL2_RELOADn_L_Pos)
#define SCT_MATCHREL2_RELOADn_H_Pos                           16
#define SCT_MATCHREL2_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL2_RELOADn_H_Pos)

// --------------------------------------  SCT_CAPCTRL2  ------------------------------------------
#define SCT_CAPCTRL2_CAPCONn_L0_Pos                           0
#define SCT_CAPCTRL2_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L0_Pos)
#define SCT_CAPCTRL2_CAPCONn_L1_Pos                           1
#define SCT_CAPCTRL2_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L1_Pos)
#define SCT_CAPCTRL2_CAPCONn_L2_Pos                           2
#define SCT_CAPCTRL2_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L2_Pos)
#define SCT_CAPCTRL2_CAPCONn_L3_Pos                           3
#define SCT_CAPCTRL2_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L3_Pos)
#define SCT_CAPCTRL2_CAPCONn_L4_Pos                           4
#define SCT_CAPCTRL2_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L4_Pos)
#define SCT_CAPCTRL2_CAPCONn_L5_Pos                           5
#define SCT_CAPCTRL2_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L5_Pos)
#define SCT_CAPCTRL2_CAPCONn_L6_Pos                           6
#define SCT_CAPCTRL2_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L6_Pos)
#define SCT_CAPCTRL2_CAPCONn_L7_Pos                           7
#define SCT_CAPCTRL2_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L7_Pos)
#define SCT_CAPCTRL2_CAPCONn_L8_Pos                           8
#define SCT_CAPCTRL2_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L8_Pos)
#define SCT_CAPCTRL2_CAPCONn_L9_Pos                           9
#define SCT_CAPCTRL2_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL2_CAPCONn_L9_Pos)
#define SCT_CAPCTRL2_CAPCONn_L10_Pos                          10
#define SCT_CAPCTRL2_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL2_CAPCONn_L10_Pos)
#define SCT_CAPCTRL2_CAPCONn_L11_Pos                          11
#define SCT_CAPCTRL2_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL2_CAPCONn_L11_Pos)
#define SCT_CAPCTRL2_CAPCONn_L12_Pos                          12
#define SCT_CAPCTRL2_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL2_CAPCONn_L12_Pos)
#define SCT_CAPCTRL2_CAPCONn_L13_Pos                          13
#define SCT_CAPCTRL2_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL2_CAPCONn_L13_Pos)
#define SCT_CAPCTRL2_CAPCONn_L14_Pos                          14
#define SCT_CAPCTRL2_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL2_CAPCONn_L14_Pos)
#define SCT_CAPCTRL2_CAPCONn_L15_Pos                          15
#define SCT_CAPCTRL2_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL2_CAPCONn_L15_Pos)
#define SCT_CAPCTRL2_CAPCONn_H_Pos                            16
#define SCT_CAPCTRL2_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL2_CAPCONn_H_Pos)

// --------------------------------------  SCT_MATCHREL3  -----------------------------------------
#define SCT_MATCHREL3_RELOADn_L_Pos                           0
#define SCT_MATCHREL3_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL3_RELOADn_L_Pos)
#define SCT_MATCHREL3_RELOADn_H_Pos                           16
#define SCT_MATCHREL3_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL3_RELOADn_H_Pos)

// --------------------------------------  SCT_CAPCTRL3  ------------------------------------------
#define SCT_CAPCTRL3_CAPCONn_L0_Pos                           0
#define SCT_CAPCTRL3_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L0_Pos)
#define SCT_CAPCTRL3_CAPCONn_L1_Pos                           1
#define SCT_CAPCTRL3_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L1_Pos)
#define SCT_CAPCTRL3_CAPCONn_L2_Pos                           2
#define SCT_CAPCTRL3_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L2_Pos)
#define SCT_CAPCTRL3_CAPCONn_L3_Pos                           3
#define SCT_CAPCTRL3_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L3_Pos)
#define SCT_CAPCTRL3_CAPCONn_L4_Pos                           4
#define SCT_CAPCTRL3_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L4_Pos)
#define SCT_CAPCTRL3_CAPCONn_L5_Pos                           5
#define SCT_CAPCTRL3_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L5_Pos)
#define SCT_CAPCTRL3_CAPCONn_L6_Pos                           6
#define SCT_CAPCTRL3_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L6_Pos)
#define SCT_CAPCTRL3_CAPCONn_L7_Pos                           7
#define SCT_CAPCTRL3_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L7_Pos)
#define SCT_CAPCTRL3_CAPCONn_L8_Pos                           8
#define SCT_CAPCTRL3_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L8_Pos)
#define SCT_CAPCTRL3_CAPCONn_L9_Pos                           9
#define SCT_CAPCTRL3_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL3_CAPCONn_L9_Pos)
#define SCT_CAPCTRL3_CAPCONn_L10_Pos                          10
#define SCT_CAPCTRL3_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL3_CAPCONn_L10_Pos)
#define SCT_CAPCTRL3_CAPCONn_L11_Pos                          11
#define SCT_CAPCTRL3_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL3_CAPCONn_L11_Pos)
#define SCT_CAPCTRL3_CAPCONn_L12_Pos                          12
#define SCT_CAPCTRL3_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL3_CAPCONn_L12_Pos)
#define SCT_CAPCTRL3_CAPCONn_L13_Pos                          13
#define SCT_CAPCTRL3_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL3_CAPCONn_L13_Pos)
#define SCT_CAPCTRL3_CAPCONn_L14_Pos                          14
#define SCT_CAPCTRL3_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL3_CAPCONn_L14_Pos)
#define SCT_CAPCTRL3_CAPCONn_L15_Pos                          15
#define SCT_CAPCTRL3_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL3_CAPCONn_L15_Pos)
#define SCT_CAPCTRL3_CAPCONn_H_Pos                            16
#define SCT_CAPCTRL3_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL3_CAPCONn_H_Pos)

// --------------------------------------  SCT_CAPCTRL4  ------------------------------------------
#define SCT_CAPCTRL4_CAPCONn_L0_Pos                           0
#define SCT_CAPCTRL4_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L0_Pos)
#define SCT_CAPCTRL4_CAPCONn_L1_Pos                           1
#define SCT_CAPCTRL4_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L1_Pos)
#define SCT_CAPCTRL4_CAPCONn_L2_Pos                           2
#define SCT_CAPCTRL4_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L2_Pos)
#define SCT_CAPCTRL4_CAPCONn_L3_Pos                           3
#define SCT_CAPCTRL4_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L3_Pos)
#define SCT_CAPCTRL4_CAPCONn_L4_Pos                           4
#define SCT_CAPCTRL4_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L4_Pos)
#define SCT_CAPCTRL4_CAPCONn_L5_Pos                           5
#define SCT_CAPCTRL4_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L5_Pos)
#define SCT_CAPCTRL4_CAPCONn_L6_Pos                           6
#define SCT_CAPCTRL4_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L6_Pos)
#define SCT_CAPCTRL4_CAPCONn_L7_Pos                           7
#define SCT_CAPCTRL4_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L7_Pos)
#define SCT_CAPCTRL4_CAPCONn_L8_Pos                           8
#define SCT_CAPCTRL4_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L8_Pos)
#define SCT_CAPCTRL4_CAPCONn_L9_Pos                           9
#define SCT_CAPCTRL4_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL4_CAPCONn_L9_Pos)
#define SCT_CAPCTRL4_CAPCONn_L10_Pos                          10
#define SCT_CAPCTRL4_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL4_CAPCONn_L10_Pos)
#define SCT_CAPCTRL4_CAPCONn_L11_Pos                          11
#define SCT_CAPCTRL4_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL4_CAPCONn_L11_Pos)
#define SCT_CAPCTRL4_CAPCONn_L12_Pos                          12
#define SCT_CAPCTRL4_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL4_CAPCONn_L12_Pos)
#define SCT_CAPCTRL4_CAPCONn_L13_Pos                          13
#define SCT_CAPCTRL4_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL4_CAPCONn_L13_Pos)
#define SCT_CAPCTRL4_CAPCONn_L14_Pos                          14
#define SCT_CAPCTRL4_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL4_CAPCONn_L14_Pos)
#define SCT_CAPCTRL4_CAPCONn_L15_Pos                          15
#define SCT_CAPCTRL4_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL4_CAPCONn_L15_Pos)
#define SCT_CAPCTRL4_CAPCONn_H_Pos                            16
#define SCT_CAPCTRL4_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL4_CAPCONn_H_Pos)

// --------------------------------------  SCT_MATCHREL4  -----------------------------------------
#define SCT_MATCHREL4_RELOADn_L_Pos                           0
#define SCT_MATCHREL4_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL4_RELOADn_L_Pos)
#define SCT_MATCHREL4_RELOADn_H_Pos                           16
#define SCT_MATCHREL4_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL4_RELOADn_H_Pos)

// --------------------------------------  SCT_CAPCTRL5  ------------------------------------------
#define SCT_CAPCTRL5_CAPCONn_L0_Pos                           0
#define SCT_CAPCTRL5_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L0_Pos)
#define SCT_CAPCTRL5_CAPCONn_L1_Pos                           1
#define SCT_CAPCTRL5_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L1_Pos)
#define SCT_CAPCTRL5_CAPCONn_L2_Pos                           2
#define SCT_CAPCTRL5_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L2_Pos)
#define SCT_CAPCTRL5_CAPCONn_L3_Pos                           3
#define SCT_CAPCTRL5_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L3_Pos)
#define SCT_CAPCTRL5_CAPCONn_L4_Pos                           4
#define SCT_CAPCTRL5_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L4_Pos)
#define SCT_CAPCTRL5_CAPCONn_L5_Pos                           5
#define SCT_CAPCTRL5_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L5_Pos)
#define SCT_CAPCTRL5_CAPCONn_L6_Pos                           6
#define SCT_CAPCTRL5_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L6_Pos)
#define SCT_CAPCTRL5_CAPCONn_L7_Pos                           7
#define SCT_CAPCTRL5_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L7_Pos)
#define SCT_CAPCTRL5_CAPCONn_L8_Pos                           8
#define SCT_CAPCTRL5_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L8_Pos)
#define SCT_CAPCTRL5_CAPCONn_L9_Pos                           9
#define SCT_CAPCTRL5_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL5_CAPCONn_L9_Pos)
#define SCT_CAPCTRL5_CAPCONn_L10_Pos                          10
#define SCT_CAPCTRL5_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL5_CAPCONn_L10_Pos)
#define SCT_CAPCTRL5_CAPCONn_L11_Pos                          11
#define SCT_CAPCTRL5_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL5_CAPCONn_L11_Pos)
#define SCT_CAPCTRL5_CAPCONn_L12_Pos                          12
#define SCT_CAPCTRL5_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL5_CAPCONn_L12_Pos)
#define SCT_CAPCTRL5_CAPCONn_L13_Pos                          13
#define SCT_CAPCTRL5_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL5_CAPCONn_L13_Pos)
#define SCT_CAPCTRL5_CAPCONn_L14_Pos                          14
#define SCT_CAPCTRL5_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL5_CAPCONn_L14_Pos)
#define SCT_CAPCTRL5_CAPCONn_L15_Pos                          15
#define SCT_CAPCTRL5_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL5_CAPCONn_L15_Pos)
#define SCT_CAPCTRL5_CAPCONn_H_Pos                            16
#define SCT_CAPCTRL5_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL5_CAPCONn_H_Pos)

// --------------------------------------  SCT_MATCHREL5  -----------------------------------------
#define SCT_MATCHREL5_RELOADn_L_Pos                           0
#define SCT_MATCHREL5_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL5_RELOADn_L_Pos)
#define SCT_MATCHREL5_RELOADn_H_Pos                           16
#define SCT_MATCHREL5_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL5_RELOADn_H_Pos)

// --------------------------------------  SCT_MATCHREL6  -----------------------------------------
#define SCT_MATCHREL6_RELOADn_L_Pos                           0
#define SCT_MATCHREL6_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL6_RELOADn_L_Pos)
#define SCT_MATCHREL6_RELOADn_H_Pos                           16
#define SCT_MATCHREL6_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL6_RELOADn_H_Pos)

// --------------------------------------  SCT_CAPCTRL6  ------------------------------------------
#define SCT_CAPCTRL6_CAPCONn_L0_Pos                           0
#define SCT_CAPCTRL6_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L0_Pos)
#define SCT_CAPCTRL6_CAPCONn_L1_Pos                           1
#define SCT_CAPCTRL6_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L1_Pos)
#define SCT_CAPCTRL6_CAPCONn_L2_Pos                           2
#define SCT_CAPCTRL6_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L2_Pos)
#define SCT_CAPCTRL6_CAPCONn_L3_Pos                           3
#define SCT_CAPCTRL6_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L3_Pos)
#define SCT_CAPCTRL6_CAPCONn_L4_Pos                           4
#define SCT_CAPCTRL6_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L4_Pos)
#define SCT_CAPCTRL6_CAPCONn_L5_Pos                           5
#define SCT_CAPCTRL6_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L5_Pos)
#define SCT_CAPCTRL6_CAPCONn_L6_Pos                           6
#define SCT_CAPCTRL6_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L6_Pos)
#define SCT_CAPCTRL6_CAPCONn_L7_Pos                           7
#define SCT_CAPCTRL6_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L7_Pos)
#define SCT_CAPCTRL6_CAPCONn_L8_Pos                           8
#define SCT_CAPCTRL6_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L8_Pos)
#define SCT_CAPCTRL6_CAPCONn_L9_Pos                           9
#define SCT_CAPCTRL6_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL6_CAPCONn_L9_Pos)
#define SCT_CAPCTRL6_CAPCONn_L10_Pos                          10
#define SCT_CAPCTRL6_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL6_CAPCONn_L10_Pos)
#define SCT_CAPCTRL6_CAPCONn_L11_Pos                          11
#define SCT_CAPCTRL6_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL6_CAPCONn_L11_Pos)
#define SCT_CAPCTRL6_CAPCONn_L12_Pos                          12
#define SCT_CAPCTRL6_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL6_CAPCONn_L12_Pos)
#define SCT_CAPCTRL6_CAPCONn_L13_Pos                          13
#define SCT_CAPCTRL6_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL6_CAPCONn_L13_Pos)
#define SCT_CAPCTRL6_CAPCONn_L14_Pos                          14
#define SCT_CAPCTRL6_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL6_CAPCONn_L14_Pos)
#define SCT_CAPCTRL6_CAPCONn_L15_Pos                          15
#define SCT_CAPCTRL6_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL6_CAPCONn_L15_Pos)
#define SCT_CAPCTRL6_CAPCONn_H_Pos                            16
#define SCT_CAPCTRL6_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL6_CAPCONn_H_Pos)

// --------------------------------------  SCT_CAPCTRL7  ------------------------------------------
#define SCT_CAPCTRL7_CAPCONn_L0_Pos                           0
#define SCT_CAPCTRL7_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L0_Pos)
#define SCT_CAPCTRL7_CAPCONn_L1_Pos                           1
#define SCT_CAPCTRL7_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L1_Pos)
#define SCT_CAPCTRL7_CAPCONn_L2_Pos                           2
#define SCT_CAPCTRL7_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L2_Pos)
#define SCT_CAPCTRL7_CAPCONn_L3_Pos                           3
#define SCT_CAPCTRL7_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L3_Pos)
#define SCT_CAPCTRL7_CAPCONn_L4_Pos                           4
#define SCT_CAPCTRL7_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L4_Pos)
#define SCT_CAPCTRL7_CAPCONn_L5_Pos                           5
#define SCT_CAPCTRL7_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L5_Pos)
#define SCT_CAPCTRL7_CAPCONn_L6_Pos                           6
#define SCT_CAPCTRL7_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L6_Pos)
#define SCT_CAPCTRL7_CAPCONn_L7_Pos                           7
#define SCT_CAPCTRL7_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L7_Pos)
#define SCT_CAPCTRL7_CAPCONn_L8_Pos                           8
#define SCT_CAPCTRL7_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L8_Pos)
#define SCT_CAPCTRL7_CAPCONn_L9_Pos                           9
#define SCT_CAPCTRL7_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL7_CAPCONn_L9_Pos)
#define SCT_CAPCTRL7_CAPCONn_L10_Pos                          10
#define SCT_CAPCTRL7_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL7_CAPCONn_L10_Pos)
#define SCT_CAPCTRL7_CAPCONn_L11_Pos                          11
#define SCT_CAPCTRL7_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL7_CAPCONn_L11_Pos)
#define SCT_CAPCTRL7_CAPCONn_L12_Pos                          12
#define SCT_CAPCTRL7_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL7_CAPCONn_L12_Pos)
#define SCT_CAPCTRL7_CAPCONn_L13_Pos                          13
#define SCT_CAPCTRL7_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL7_CAPCONn_L13_Pos)
#define SCT_CAPCTRL7_CAPCONn_L14_Pos                          14
#define SCT_CAPCTRL7_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL7_CAPCONn_L14_Pos)
#define SCT_CAPCTRL7_CAPCONn_L15_Pos                          15
#define SCT_CAPCTRL7_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL7_CAPCONn_L15_Pos)
#define SCT_CAPCTRL7_CAPCONn_H_Pos                            16
#define SCT_CAPCTRL7_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL7_CAPCONn_H_Pos)

// --------------------------------------  SCT_MATCHREL7  -----------------------------------------
#define SCT_MATCHREL7_RELOADn_L_Pos                           0
#define SCT_MATCHREL7_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL7_RELOADn_L_Pos)
#define SCT_MATCHREL7_RELOADn_H_Pos                           16
#define SCT_MATCHREL7_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL7_RELOADn_H_Pos)

// --------------------------------------  SCT_CAPCTRL8  ------------------------------------------
#define SCT_CAPCTRL8_CAPCONn_L0_Pos                           0
#define SCT_CAPCTRL8_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L0_Pos)
#define SCT_CAPCTRL8_CAPCONn_L1_Pos                           1
#define SCT_CAPCTRL8_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L1_Pos)
#define SCT_CAPCTRL8_CAPCONn_L2_Pos                           2
#define SCT_CAPCTRL8_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L2_Pos)
#define SCT_CAPCTRL8_CAPCONn_L3_Pos                           3
#define SCT_CAPCTRL8_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L3_Pos)
#define SCT_CAPCTRL8_CAPCONn_L4_Pos                           4
#define SCT_CAPCTRL8_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L4_Pos)
#define SCT_CAPCTRL8_CAPCONn_L5_Pos                           5
#define SCT_CAPCTRL8_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L5_Pos)
#define SCT_CAPCTRL8_CAPCONn_L6_Pos                           6
#define SCT_CAPCTRL8_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L6_Pos)
#define SCT_CAPCTRL8_CAPCONn_L7_Pos                           7
#define SCT_CAPCTRL8_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L7_Pos)
#define SCT_CAPCTRL8_CAPCONn_L8_Pos                           8
#define SCT_CAPCTRL8_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L8_Pos)
#define SCT_CAPCTRL8_CAPCONn_L9_Pos                           9
#define SCT_CAPCTRL8_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL8_CAPCONn_L9_Pos)
#define SCT_CAPCTRL8_CAPCONn_L10_Pos                          10
#define SCT_CAPCTRL8_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL8_CAPCONn_L10_Pos)
#define SCT_CAPCTRL8_CAPCONn_L11_Pos                          11
#define SCT_CAPCTRL8_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL8_CAPCONn_L11_Pos)
#define SCT_CAPCTRL8_CAPCONn_L12_Pos                          12
#define SCT_CAPCTRL8_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL8_CAPCONn_L12_Pos)
#define SCT_CAPCTRL8_CAPCONn_L13_Pos                          13
#define SCT_CAPCTRL8_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL8_CAPCONn_L13_Pos)
#define SCT_CAPCTRL8_CAPCONn_L14_Pos                          14
#define SCT_CAPCTRL8_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL8_CAPCONn_L14_Pos)
#define SCT_CAPCTRL8_CAPCONn_L15_Pos                          15
#define SCT_CAPCTRL8_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL8_CAPCONn_L15_Pos)
#define SCT_CAPCTRL8_CAPCONn_H_Pos                            16
#define SCT_CAPCTRL8_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL8_CAPCONn_H_Pos)

// --------------------------------------  SCT_MATCHREL8  -----------------------------------------
#define SCT_MATCHREL8_RELOADn_L_Pos                           0
#define SCT_MATCHREL8_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL8_RELOADn_L_Pos)
#define SCT_MATCHREL8_RELOADn_H_Pos                           16
#define SCT_MATCHREL8_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL8_RELOADn_H_Pos)

// --------------------------------------  SCT_MATCHREL9  -----------------------------------------
#define SCT_MATCHREL9_RELOADn_L_Pos                           0
#define SCT_MATCHREL9_RELOADn_L_Msk                           (0x0000ffffUL << SCT_MATCHREL9_RELOADn_L_Pos)
#define SCT_MATCHREL9_RELOADn_H_Pos                           16
#define SCT_MATCHREL9_RELOADn_H_Msk                           (0x0000ffffUL << SCT_MATCHREL9_RELOADn_H_Pos)

// --------------------------------------  SCT_CAPCTRL9  ------------------------------------------
#define SCT_CAPCTRL9_CAPCONn_L0_Pos                           0
#define SCT_CAPCTRL9_CAPCONn_L0_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L0_Pos)
#define SCT_CAPCTRL9_CAPCONn_L1_Pos                           1
#define SCT_CAPCTRL9_CAPCONn_L1_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L1_Pos)
#define SCT_CAPCTRL9_CAPCONn_L2_Pos                           2
#define SCT_CAPCTRL9_CAPCONn_L2_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L2_Pos)
#define SCT_CAPCTRL9_CAPCONn_L3_Pos                           3
#define SCT_CAPCTRL9_CAPCONn_L3_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L3_Pos)
#define SCT_CAPCTRL9_CAPCONn_L4_Pos                           4
#define SCT_CAPCTRL9_CAPCONn_L4_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L4_Pos)
#define SCT_CAPCTRL9_CAPCONn_L5_Pos                           5
#define SCT_CAPCTRL9_CAPCONn_L5_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L5_Pos)
#define SCT_CAPCTRL9_CAPCONn_L6_Pos                           6
#define SCT_CAPCTRL9_CAPCONn_L6_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L6_Pos)
#define SCT_CAPCTRL9_CAPCONn_L7_Pos                           7
#define SCT_CAPCTRL9_CAPCONn_L7_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L7_Pos)
#define SCT_CAPCTRL9_CAPCONn_L8_Pos                           8
#define SCT_CAPCTRL9_CAPCONn_L8_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L8_Pos)
#define SCT_CAPCTRL9_CAPCONn_L9_Pos                           9
#define SCT_CAPCTRL9_CAPCONn_L9_Msk                           (0x01UL << SCT_CAPCTRL9_CAPCONn_L9_Pos)
#define SCT_CAPCTRL9_CAPCONn_L10_Pos                          10
#define SCT_CAPCTRL9_CAPCONn_L10_Msk                          (0x01UL << SCT_CAPCTRL9_CAPCONn_L10_Pos)
#define SCT_CAPCTRL9_CAPCONn_L11_Pos                          11
#define SCT_CAPCTRL9_CAPCONn_L11_Msk                          (0x01UL << SCT_CAPCTRL9_CAPCONn_L11_Pos)
#define SCT_CAPCTRL9_CAPCONn_L12_Pos                          12
#define SCT_CAPCTRL9_CAPCONn_L12_Msk                          (0x01UL << SCT_CAPCTRL9_CAPCONn_L12_Pos)
#define SCT_CAPCTRL9_CAPCONn_L13_Pos                          13
#define SCT_CAPCTRL9_CAPCONn_L13_Msk                          (0x01UL << SCT_CAPCTRL9_CAPCONn_L13_Pos)
#define SCT_CAPCTRL9_CAPCONn_L14_Pos                          14
#define SCT_CAPCTRL9_CAPCONn_L14_Msk                          (0x01UL << SCT_CAPCTRL9_CAPCONn_L14_Pos)
#define SCT_CAPCTRL9_CAPCONn_L15_Pos                          15
#define SCT_CAPCTRL9_CAPCONn_L15_Msk                          (0x01UL << SCT_CAPCTRL9_CAPCONn_L15_Pos)
#define SCT_CAPCTRL9_CAPCONn_H_Pos                            16
#define SCT_CAPCTRL9_CAPCONn_H_Msk                            (0x0000ffffUL << SCT_CAPCTRL9_CAPCONn_H_Pos)

// -------------------------------------  SCT_MATCHREL10  -----------------------------------------
#define SCT_MATCHREL10_RELOADn_L_Pos                          0
#define SCT_MATCHREL10_RELOADn_L_Msk                          (0x0000ffffUL << SCT_MATCHREL10_RELOADn_L_Pos)
#define SCT_MATCHREL10_RELOADn_H_Pos                          16
#define SCT_MATCHREL10_RELOADn_H_Msk                          (0x0000ffffUL << SCT_MATCHREL10_RELOADn_H_Pos)

// --------------------------------------  SCT_CAPCTRL10  -----------------------------------------
#define SCT_CAPCTRL10_CAPCONn_L0_Pos                          0
#define SCT_CAPCTRL10_CAPCONn_L0_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L0_Pos)
#define SCT_CAPCTRL10_CAPCONn_L1_Pos                          1
#define SCT_CAPCTRL10_CAPCONn_L1_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L1_Pos)
#define SCT_CAPCTRL10_CAPCONn_L2_Pos                          2
#define SCT_CAPCTRL10_CAPCONn_L2_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L2_Pos)
#define SCT_CAPCTRL10_CAPCONn_L3_Pos                          3
#define SCT_CAPCTRL10_CAPCONn_L3_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L3_Pos)
#define SCT_CAPCTRL10_CAPCONn_L4_Pos                          4
#define SCT_CAPCTRL10_CAPCONn_L4_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L4_Pos)
#define SCT_CAPCTRL10_CAPCONn_L5_Pos                          5
#define SCT_CAPCTRL10_CAPCONn_L5_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L5_Pos)
#define SCT_CAPCTRL10_CAPCONn_L6_Pos                          6
#define SCT_CAPCTRL10_CAPCONn_L6_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L6_Pos)
#define SCT_CAPCTRL10_CAPCONn_L7_Pos                          7
#define SCT_CAPCTRL10_CAPCONn_L7_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L7_Pos)
#define SCT_CAPCTRL10_CAPCONn_L8_Pos                          8
#define SCT_CAPCTRL10_CAPCONn_L8_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L8_Pos)
#define SCT_CAPCTRL10_CAPCONn_L9_Pos                          9
#define SCT_CAPCTRL10_CAPCONn_L9_Msk                          (0x01UL << SCT_CAPCTRL10_CAPCONn_L9_Pos)
#define SCT_CAPCTRL10_CAPCONn_L10_Pos                         10
#define SCT_CAPCTRL10_CAPCONn_L10_Msk                         (0x01UL << SCT_CAPCTRL10_CAPCONn_L10_Pos)
#define SCT_CAPCTRL10_CAPCONn_L11_Pos                         11
#define SCT_CAPCTRL10_CAPCONn_L11_Msk                         (0x01UL << SCT_CAPCTRL10_CAPCONn_L11_Pos)
#define SCT_CAPCTRL10_CAPCONn_L12_Pos                         12
#define SCT_CAPCTRL10_CAPCONn_L12_Msk                         (0x01UL << SCT_CAPCTRL10_CAPCONn_L12_Pos)
#define SCT_CAPCTRL10_CAPCONn_L13_Pos                         13
#define SCT_CAPCTRL10_CAPCONn_L13_Msk                         (0x01UL << SCT_CAPCTRL10_CAPCONn_L13_Pos)
#define SCT_CAPCTRL10_CAPCONn_L14_Pos                         14
#define SCT_CAPCTRL10_CAPCONn_L14_Msk                         (0x01UL << SCT_CAPCTRL10_CAPCONn_L14_Pos)
#define SCT_CAPCTRL10_CAPCONn_L15_Pos                         15
#define SCT_CAPCTRL10_CAPCONn_L15_Msk                         (0x01UL << SCT_CAPCTRL10_CAPCONn_L15_Pos)
#define SCT_CAPCTRL10_CAPCONn_H_Pos                           16
#define SCT_CAPCTRL10_CAPCONn_H_Msk                           (0x0000ffffUL << SCT_CAPCTRL10_CAPCONn_H_Pos)

// -------------------------------------  SCT_MATCHREL11  -----------------------------------------
#define SCT_MATCHREL11_RELOADn_L_Pos                          0
#define SCT_MATCHREL11_RELOADn_L_Msk                          (0x0000ffffUL << SCT_MATCHREL11_RELOADn_L_Pos)
#define SCT_MATCHREL11_RELOADn_H_Pos                          16
#define SCT_MATCHREL11_RELOADn_H_Msk                          (0x0000ffffUL << SCT_MATCHREL11_RELOADn_H_Pos)

// --------------------------------------  SCT_CAPCTRL11  -----------------------------------------
#define SCT_CAPCTRL11_CAPCONn_L0_Pos                          0
#define SCT_CAPCTRL11_CAPCONn_L0_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L0_Pos)
#define SCT_CAPCTRL11_CAPCONn_L1_Pos                          1
#define SCT_CAPCTRL11_CAPCONn_L1_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L1_Pos)
#define SCT_CAPCTRL11_CAPCONn_L2_Pos                          2
#define SCT_CAPCTRL11_CAPCONn_L2_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L2_Pos)
#define SCT_CAPCTRL11_CAPCONn_L3_Pos                          3
#define SCT_CAPCTRL11_CAPCONn_L3_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L3_Pos)
#define SCT_CAPCTRL11_CAPCONn_L4_Pos                          4
#define SCT_CAPCTRL11_CAPCONn_L4_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L4_Pos)
#define SCT_CAPCTRL11_CAPCONn_L5_Pos                          5
#define SCT_CAPCTRL11_CAPCONn_L5_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L5_Pos)
#define SCT_CAPCTRL11_CAPCONn_L6_Pos                          6
#define SCT_CAPCTRL11_CAPCONn_L6_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L6_Pos)
#define SCT_CAPCTRL11_CAPCONn_L7_Pos                          7
#define SCT_CAPCTRL11_CAPCONn_L7_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L7_Pos)
#define SCT_CAPCTRL11_CAPCONn_L8_Pos                          8
#define SCT_CAPCTRL11_CAPCONn_L8_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L8_Pos)
#define SCT_CAPCTRL11_CAPCONn_L9_Pos                          9
#define SCT_CAPCTRL11_CAPCONn_L9_Msk                          (0x01UL << SCT_CAPCTRL11_CAPCONn_L9_Pos)
#define SCT_CAPCTRL11_CAPCONn_L10_Pos                         10
#define SCT_CAPCTRL11_CAPCONn_L10_Msk                         (0x01UL << SCT_CAPCTRL11_CAPCONn_L10_Pos)
#define SCT_CAPCTRL11_CAPCONn_L11_Pos                         11
#define SCT_CAPCTRL11_CAPCONn_L11_Msk                         (0x01UL << SCT_CAPCTRL11_CAPCONn_L11_Pos)
#define SCT_CAPCTRL11_CAPCONn_L12_Pos                         12
#define SCT_CAPCTRL11_CAPCONn_L12_Msk                         (0x01UL << SCT_CAPCTRL11_CAPCONn_L12_Pos)
#define SCT_CAPCTRL11_CAPCONn_L13_Pos                         13
#define SCT_CAPCTRL11_CAPCONn_L13_Msk                         (0x01UL << SCT_CAPCTRL11_CAPCONn_L13_Pos)
#define SCT_CAPCTRL11_CAPCONn_L14_Pos                         14
#define SCT_CAPCTRL11_CAPCONn_L14_Msk                         (0x01UL << SCT_CAPCTRL11_CAPCONn_L14_Pos)
#define SCT_CAPCTRL11_CAPCONn_L15_Pos                         15
#define SCT_CAPCTRL11_CAPCONn_L15_Msk                         (0x01UL << SCT_CAPCTRL11_CAPCONn_L15_Pos)
#define SCT_CAPCTRL11_CAPCONn_H_Pos                           16
#define SCT_CAPCTRL11_CAPCONn_H_Msk                           (0x0000ffffUL << SCT_CAPCTRL11_CAPCONn_H_Pos)

// -------------------------------------  SCT_MATCHREL12  -----------------------------------------
#define SCT_MATCHREL12_RELOADn_L_Pos                          0
#define SCT_MATCHREL12_RELOADn_L_Msk                          (0x0000ffffUL << SCT_MATCHREL12_RELOADn_L_Pos)
#define SCT_MATCHREL12_RELOADn_H_Pos                          16
#define SCT_MATCHREL12_RELOADn_H_Msk                          (0x0000ffffUL << SCT_MATCHREL12_RELOADn_H_Pos)

// --------------------------------------  SCT_CAPCTRL12  -----------------------------------------
#define SCT_CAPCTRL12_CAPCONn_L0_Pos                          0
#define SCT_CAPCTRL12_CAPCONn_L0_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L0_Pos)
#define SCT_CAPCTRL12_CAPCONn_L1_Pos                          1
#define SCT_CAPCTRL12_CAPCONn_L1_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L1_Pos)
#define SCT_CAPCTRL12_CAPCONn_L2_Pos                          2
#define SCT_CAPCTRL12_CAPCONn_L2_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L2_Pos)
#define SCT_CAPCTRL12_CAPCONn_L3_Pos                          3
#define SCT_CAPCTRL12_CAPCONn_L3_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L3_Pos)
#define SCT_CAPCTRL12_CAPCONn_L4_Pos                          4
#define SCT_CAPCTRL12_CAPCONn_L4_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L4_Pos)
#define SCT_CAPCTRL12_CAPCONn_L5_Pos                          5
#define SCT_CAPCTRL12_CAPCONn_L5_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L5_Pos)
#define SCT_CAPCTRL12_CAPCONn_L6_Pos                          6
#define SCT_CAPCTRL12_CAPCONn_L6_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L6_Pos)
#define SCT_CAPCTRL12_CAPCONn_L7_Pos                          7
#define SCT_CAPCTRL12_CAPCONn_L7_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L7_Pos)
#define SCT_CAPCTRL12_CAPCONn_L8_Pos                          8
#define SCT_CAPCTRL12_CAPCONn_L8_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L8_Pos)
#define SCT_CAPCTRL12_CAPCONn_L9_Pos                          9
#define SCT_CAPCTRL12_CAPCONn_L9_Msk                          (0x01UL << SCT_CAPCTRL12_CAPCONn_L9_Pos)
#define SCT_CAPCTRL12_CAPCONn_L10_Pos                         10
#define SCT_CAPCTRL12_CAPCONn_L10_Msk                         (0x01UL << SCT_CAPCTRL12_CAPCONn_L10_Pos)
#define SCT_CAPCTRL12_CAPCONn_L11_Pos                         11
#define SCT_CAPCTRL12_CAPCONn_L11_Msk                         (0x01UL << SCT_CAPCTRL12_CAPCONn_L11_Pos)
#define SCT_CAPCTRL12_CAPCONn_L12_Pos                         12
#define SCT_CAPCTRL12_CAPCONn_L12_Msk                         (0x01UL << SCT_CAPCTRL12_CAPCONn_L12_Pos)
#define SCT_CAPCTRL12_CAPCONn_L13_Pos                         13
#define SCT_CAPCTRL12_CAPCONn_L13_Msk                         (0x01UL << SCT_CAPCTRL12_CAPCONn_L13_Pos)
#define SCT_CAPCTRL12_CAPCONn_L14_Pos                         14
#define SCT_CAPCTRL12_CAPCONn_L14_Msk                         (0x01UL << SCT_CAPCTRL12_CAPCONn_L14_Pos)
#define SCT_CAPCTRL12_CAPCONn_L15_Pos                         15
#define SCT_CAPCTRL12_CAPCONn_L15_Msk                         (0x01UL << SCT_CAPCTRL12_CAPCONn_L15_Pos)
#define SCT_CAPCTRL12_CAPCONn_H_Pos                           16
#define SCT_CAPCTRL12_CAPCONn_H_Msk                           (0x0000ffffUL << SCT_CAPCTRL12_CAPCONn_H_Pos)

// -------------------------------------  SCT_MATCHREL13  -----------------------------------------
#define SCT_MATCHREL13_RELOADn_L_Pos                          0
#define SCT_MATCHREL13_RELOADn_L_Msk                          (0x0000ffffUL << SCT_MATCHREL13_RELOADn_L_Pos)
#define SCT_MATCHREL13_RELOADn_H_Pos                          16
#define SCT_MATCHREL13_RELOADn_H_Msk                          (0x0000ffffUL << SCT_MATCHREL13_RELOADn_H_Pos)

// --------------------------------------  SCT_CAPCTRL13  -----------------------------------------
#define SCT_CAPCTRL13_CAPCONn_L0_Pos                          0
#define SCT_CAPCTRL13_CAPCONn_L0_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L0_Pos)
#define SCT_CAPCTRL13_CAPCONn_L1_Pos                          1
#define SCT_CAPCTRL13_CAPCONn_L1_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L1_Pos)
#define SCT_CAPCTRL13_CAPCONn_L2_Pos                          2
#define SCT_CAPCTRL13_CAPCONn_L2_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L2_Pos)
#define SCT_CAPCTRL13_CAPCONn_L3_Pos                          3
#define SCT_CAPCTRL13_CAPCONn_L3_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L3_Pos)
#define SCT_CAPCTRL13_CAPCONn_L4_Pos                          4
#define SCT_CAPCTRL13_CAPCONn_L4_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L4_Pos)
#define SCT_CAPCTRL13_CAPCONn_L5_Pos                          5
#define SCT_CAPCTRL13_CAPCONn_L5_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L5_Pos)
#define SCT_CAPCTRL13_CAPCONn_L6_Pos                          6
#define SCT_CAPCTRL13_CAPCONn_L6_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L6_Pos)
#define SCT_CAPCTRL13_CAPCONn_L7_Pos                          7
#define SCT_CAPCTRL13_CAPCONn_L7_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L7_Pos)
#define SCT_CAPCTRL13_CAPCONn_L8_Pos                          8
#define SCT_CAPCTRL13_CAPCONn_L8_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L8_Pos)
#define SCT_CAPCTRL13_CAPCONn_L9_Pos                          9
#define SCT_CAPCTRL13_CAPCONn_L9_Msk                          (0x01UL << SCT_CAPCTRL13_CAPCONn_L9_Pos)
#define SCT_CAPCTRL13_CAPCONn_L10_Pos                         10
#define SCT_CAPCTRL13_CAPCONn_L10_Msk                         (0x01UL << SCT_CAPCTRL13_CAPCONn_L10_Pos)
#define SCT_CAPCTRL13_CAPCONn_L11_Pos                         11
#define SCT_CAPCTRL13_CAPCONn_L11_Msk                         (0x01UL << SCT_CAPCTRL13_CAPCONn_L11_Pos)
#define SCT_CAPCTRL13_CAPCONn_L12_Pos                         12
#define SCT_CAPCTRL13_CAPCONn_L12_Msk                         (0x01UL << SCT_CAPCTRL13_CAPCONn_L12_Pos)
#define SCT_CAPCTRL13_CAPCONn_L13_Pos                         13
#define SCT_CAPCTRL13_CAPCONn_L13_Msk                         (0x01UL << SCT_CAPCTRL13_CAPCONn_L13_Pos)
#define SCT_CAPCTRL13_CAPCONn_L14_Pos                         14
#define SCT_CAPCTRL13_CAPCONn_L14_Msk                         (0x01UL << SCT_CAPCTRL13_CAPCONn_L14_Pos)
#define SCT_CAPCTRL13_CAPCONn_L15_Pos                         15
#define SCT_CAPCTRL13_CAPCONn_L15_Msk                         (0x01UL << SCT_CAPCTRL13_CAPCONn_L15_Pos)
#define SCT_CAPCTRL13_CAPCONn_H_Pos                           16
#define SCT_CAPCTRL13_CAPCONn_H_Msk                           (0x0000ffffUL << SCT_CAPCTRL13_CAPCONn_H_Pos)

// -------------------------------------  SCT_MATCHREL14  -----------------------------------------
#define SCT_MATCHREL14_RELOADn_L_Pos                          0
#define SCT_MATCHREL14_RELOADn_L_Msk                          (0x0000ffffUL << SCT_MATCHREL14_RELOADn_L_Pos)
#define SCT_MATCHREL14_RELOADn_H_Pos                          16
#define SCT_MATCHREL14_RELOADn_H_Msk                          (0x0000ffffUL << SCT_MATCHREL14_RELOADn_H_Pos)

// --------------------------------------  SCT_CAPCTRL14  -----------------------------------------
#define SCT_CAPCTRL14_CAPCONn_L0_Pos                          0
#define SCT_CAPCTRL14_CAPCONn_L0_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L0_Pos)
#define SCT_CAPCTRL14_CAPCONn_L1_Pos                          1
#define SCT_CAPCTRL14_CAPCONn_L1_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L1_Pos)
#define SCT_CAPCTRL14_CAPCONn_L2_Pos                          2
#define SCT_CAPCTRL14_CAPCONn_L2_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L2_Pos)
#define SCT_CAPCTRL14_CAPCONn_L3_Pos                          3
#define SCT_CAPCTRL14_CAPCONn_L3_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L3_Pos)
#define SCT_CAPCTRL14_CAPCONn_L4_Pos                          4
#define SCT_CAPCTRL14_CAPCONn_L4_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L4_Pos)
#define SCT_CAPCTRL14_CAPCONn_L5_Pos                          5
#define SCT_CAPCTRL14_CAPCONn_L5_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L5_Pos)
#define SCT_CAPCTRL14_CAPCONn_L6_Pos                          6
#define SCT_CAPCTRL14_CAPCONn_L6_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L6_Pos)
#define SCT_CAPCTRL14_CAPCONn_L7_Pos                          7
#define SCT_CAPCTRL14_CAPCONn_L7_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L7_Pos)
#define SCT_CAPCTRL14_CAPCONn_L8_Pos                          8
#define SCT_CAPCTRL14_CAPCONn_L8_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L8_Pos)
#define SCT_CAPCTRL14_CAPCONn_L9_Pos                          9
#define SCT_CAPCTRL14_CAPCONn_L9_Msk                          (0x01UL << SCT_CAPCTRL14_CAPCONn_L9_Pos)
#define SCT_CAPCTRL14_CAPCONn_L10_Pos                         10
#define SCT_CAPCTRL14_CAPCONn_L10_Msk                         (0x01UL << SCT_CAPCTRL14_CAPCONn_L10_Pos)
#define SCT_CAPCTRL14_CAPCONn_L11_Pos                         11
#define SCT_CAPCTRL14_CAPCONn_L11_Msk                         (0x01UL << SCT_CAPCTRL14_CAPCONn_L11_Pos)
#define SCT_CAPCTRL14_CAPCONn_L12_Pos                         12
#define SCT_CAPCTRL14_CAPCONn_L12_Msk                         (0x01UL << SCT_CAPCTRL14_CAPCONn_L12_Pos)
#define SCT_CAPCTRL14_CAPCONn_L13_Pos                         13
#define SCT_CAPCTRL14_CAPCONn_L13_Msk                         (0x01UL << SCT_CAPCTRL14_CAPCONn_L13_Pos)
#define SCT_CAPCTRL14_CAPCONn_L14_Pos                         14
#define SCT_CAPCTRL14_CAPCONn_L14_Msk                         (0x01UL << SCT_CAPCTRL14_CAPCONn_L14_Pos)
#define SCT_CAPCTRL14_CAPCONn_L15_Pos                         15
#define SCT_CAPCTRL14_CAPCONn_L15_Msk                         (0x01UL << SCT_CAPCTRL14_CAPCONn_L15_Pos)
#define SCT_CAPCTRL14_CAPCONn_H_Pos                           16
#define SCT_CAPCTRL14_CAPCONn_H_Msk                           (0x0000ffffUL << SCT_CAPCTRL14_CAPCONn_H_Pos)

// -------------------------------------  SCT_MATCHREL15  -----------------------------------------
#define SCT_MATCHREL15_RELOADn_L_Pos                          0
#define SCT_MATCHREL15_RELOADn_L_Msk                          (0x0000ffffUL << SCT_MATCHREL15_RELOADn_L_Pos)
#define SCT_MATCHREL15_RELOADn_H_Pos                          16
#define SCT_MATCHREL15_RELOADn_H_Msk                          (0x0000ffffUL << SCT_MATCHREL15_RELOADn_H_Pos)

// --------------------------------------  SCT_CAPCTRL15  -----------------------------------------
#define SCT_CAPCTRL15_CAPCONn_L0_Pos                          0
#define SCT_CAPCTRL15_CAPCONn_L0_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L0_Pos)
#define SCT_CAPCTRL15_CAPCONn_L1_Pos                          1
#define SCT_CAPCTRL15_CAPCONn_L1_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L1_Pos)
#define SCT_CAPCTRL15_CAPCONn_L2_Pos                          2
#define SCT_CAPCTRL15_CAPCONn_L2_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L2_Pos)
#define SCT_CAPCTRL15_CAPCONn_L3_Pos                          3
#define SCT_CAPCTRL15_CAPCONn_L3_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L3_Pos)
#define SCT_CAPCTRL15_CAPCONn_L4_Pos                          4
#define SCT_CAPCTRL15_CAPCONn_L4_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L4_Pos)
#define SCT_CAPCTRL15_CAPCONn_L5_Pos                          5
#define SCT_CAPCTRL15_CAPCONn_L5_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L5_Pos)
#define SCT_CAPCTRL15_CAPCONn_L6_Pos                          6
#define SCT_CAPCTRL15_CAPCONn_L6_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L6_Pos)
#define SCT_CAPCTRL15_CAPCONn_L7_Pos                          7
#define SCT_CAPCTRL15_CAPCONn_L7_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L7_Pos)
#define SCT_CAPCTRL15_CAPCONn_L8_Pos                          8
#define SCT_CAPCTRL15_CAPCONn_L8_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L8_Pos)
#define SCT_CAPCTRL15_CAPCONn_L9_Pos                          9
#define SCT_CAPCTRL15_CAPCONn_L9_Msk                          (0x01UL << SCT_CAPCTRL15_CAPCONn_L9_Pos)
#define SCT_CAPCTRL15_CAPCONn_L10_Pos                         10
#define SCT_CAPCTRL15_CAPCONn_L10_Msk                         (0x01UL << SCT_CAPCTRL15_CAPCONn_L10_Pos)
#define SCT_CAPCTRL15_CAPCONn_L11_Pos                         11
#define SCT_CAPCTRL15_CAPCONn_L11_Msk                         (0x01UL << SCT_CAPCTRL15_CAPCONn_L11_Pos)
#define SCT_CAPCTRL15_CAPCONn_L12_Pos                         12
#define SCT_CAPCTRL15_CAPCONn_L12_Msk                         (0x01UL << SCT_CAPCTRL15_CAPCONn_L12_Pos)
#define SCT_CAPCTRL15_CAPCONn_L13_Pos                         13
#define SCT_CAPCTRL15_CAPCONn_L13_Msk                         (0x01UL << SCT_CAPCTRL15_CAPCONn_L13_Pos)
#define SCT_CAPCTRL15_CAPCONn_L14_Pos                         14
#define SCT_CAPCTRL15_CAPCONn_L14_Msk                         (0x01UL << SCT_CAPCTRL15_CAPCONn_L14_Pos)
#define SCT_CAPCTRL15_CAPCONn_L15_Pos                         15
#define SCT_CAPCTRL15_CAPCONn_L15_Msk                         (0x01UL << SCT_CAPCTRL15_CAPCONn_L15_Pos)
#define SCT_CAPCTRL15_CAPCONn_H_Pos                           16
#define SCT_CAPCTRL15_CAPCONn_H_Msk                           (0x0000ffffUL << SCT_CAPCTRL15_CAPCONn_H_Pos)

// -------------------------------------  SCT_EVSTATEMSK0  ----------------------------------------
#define SCT_EVSTATEMSK0_STATEMSKn0_Pos                        0
#define SCT_EVSTATEMSK0_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn1_Pos                        1
#define SCT_EVSTATEMSK0_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn2_Pos                        2
#define SCT_EVSTATEMSK0_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn3_Pos                        3
#define SCT_EVSTATEMSK0_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn4_Pos                        4
#define SCT_EVSTATEMSK0_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn5_Pos                        5
#define SCT_EVSTATEMSK0_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn6_Pos                        6
#define SCT_EVSTATEMSK0_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn7_Pos                        7
#define SCT_EVSTATEMSK0_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn8_Pos                        8
#define SCT_EVSTATEMSK0_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn9_Pos                        9
#define SCT_EVSTATEMSK0_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK0_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn10_Pos                       10
#define SCT_EVSTATEMSK0_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn11_Pos                       11
#define SCT_EVSTATEMSK0_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn12_Pos                       12
#define SCT_EVSTATEMSK0_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn13_Pos                       13
#define SCT_EVSTATEMSK0_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn14_Pos                       14
#define SCT_EVSTATEMSK0_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn15_Pos                       15
#define SCT_EVSTATEMSK0_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn16_Pos                       16
#define SCT_EVSTATEMSK0_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn17_Pos                       17
#define SCT_EVSTATEMSK0_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn18_Pos                       18
#define SCT_EVSTATEMSK0_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn19_Pos                       19
#define SCT_EVSTATEMSK0_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn20_Pos                       20
#define SCT_EVSTATEMSK0_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn21_Pos                       21
#define SCT_EVSTATEMSK0_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn22_Pos                       22
#define SCT_EVSTATEMSK0_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn23_Pos                       23
#define SCT_EVSTATEMSK0_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn24_Pos                       24
#define SCT_EVSTATEMSK0_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn25_Pos                       25
#define SCT_EVSTATEMSK0_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn26_Pos                       26
#define SCT_EVSTATEMSK0_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn27_Pos                       27
#define SCT_EVSTATEMSK0_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn28_Pos                       28
#define SCT_EVSTATEMSK0_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn29_Pos                       29
#define SCT_EVSTATEMSK0_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn30_Pos                       30
#define SCT_EVSTATEMSK0_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK0_STATEMSKn31_Pos                       31
#define SCT_EVSTATEMSK0_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK0_STATEMSKn31_Pos)

// ---------------------------------------  SCT_EVCTRL0  ------------------------------------------
#define SCT_EVCTRL0_MATCHSEL_Pos                              0
#define SCT_EVCTRL0_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL0_MATCHSEL_Pos)
#define SCT_EVCTRL0_HEVENT_Pos                                4
#define SCT_EVCTRL0_HEVENT_Msk                                (0x01UL << SCT_EVCTRL0_HEVENT_Pos)
#define SCT_EVCTRL0_OUTSEL_Pos                                5
#define SCT_EVCTRL0_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL0_OUTSEL_Pos)
#define SCT_EVCTRL0_IOSEL_Pos                                 6
#define SCT_EVCTRL0_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL0_IOSEL_Pos)
#define SCT_EVCTRL0_IOCOND_Pos                                10
#define SCT_EVCTRL0_IOCOND_Msk                                (0x03UL << SCT_EVCTRL0_IOCOND_Pos)
#define SCT_EVCTRL0_COMBMODE_Pos                              12
#define SCT_EVCTRL0_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL0_COMBMODE_Pos)
#define SCT_EVCTRL0_STATELD_Pos                               14
#define SCT_EVCTRL0_STATELD_Msk                               (0x01UL << SCT_EVCTRL0_STATELD_Pos)
#define SCT_EVCTRL0_STATEV_Pos                                15
#define SCT_EVCTRL0_STATEV_Msk                                (0x1fUL << SCT_EVCTRL0_STATEV_Pos)

// -------------------------------------  SCT_EVSTATEMSK1  ----------------------------------------
#define SCT_EVSTATEMSK1_STATEMSKn0_Pos                        0
#define SCT_EVSTATEMSK1_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn1_Pos                        1
#define SCT_EVSTATEMSK1_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn2_Pos                        2
#define SCT_EVSTATEMSK1_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn3_Pos                        3
#define SCT_EVSTATEMSK1_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn4_Pos                        4
#define SCT_EVSTATEMSK1_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn5_Pos                        5
#define SCT_EVSTATEMSK1_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn6_Pos                        6
#define SCT_EVSTATEMSK1_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn7_Pos                        7
#define SCT_EVSTATEMSK1_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn8_Pos                        8
#define SCT_EVSTATEMSK1_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn9_Pos                        9
#define SCT_EVSTATEMSK1_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK1_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn10_Pos                       10
#define SCT_EVSTATEMSK1_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn11_Pos                       11
#define SCT_EVSTATEMSK1_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn12_Pos                       12
#define SCT_EVSTATEMSK1_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn13_Pos                       13
#define SCT_EVSTATEMSK1_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn14_Pos                       14
#define SCT_EVSTATEMSK1_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn15_Pos                       15
#define SCT_EVSTATEMSK1_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn16_Pos                       16
#define SCT_EVSTATEMSK1_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn17_Pos                       17
#define SCT_EVSTATEMSK1_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn18_Pos                       18
#define SCT_EVSTATEMSK1_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn19_Pos                       19
#define SCT_EVSTATEMSK1_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn20_Pos                       20
#define SCT_EVSTATEMSK1_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn21_Pos                       21
#define SCT_EVSTATEMSK1_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn22_Pos                       22
#define SCT_EVSTATEMSK1_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn23_Pos                       23
#define SCT_EVSTATEMSK1_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn24_Pos                       24
#define SCT_EVSTATEMSK1_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn25_Pos                       25
#define SCT_EVSTATEMSK1_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn26_Pos                       26
#define SCT_EVSTATEMSK1_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn27_Pos                       27
#define SCT_EVSTATEMSK1_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn28_Pos                       28
#define SCT_EVSTATEMSK1_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn29_Pos                       29
#define SCT_EVSTATEMSK1_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn30_Pos                       30
#define SCT_EVSTATEMSK1_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK1_STATEMSKn31_Pos                       31
#define SCT_EVSTATEMSK1_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK1_STATEMSKn31_Pos)

// ---------------------------------------  SCT_EVCTRL1  ------------------------------------------
#define SCT_EVCTRL1_MATCHSEL_Pos                              0
#define SCT_EVCTRL1_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL1_MATCHSEL_Pos)
#define SCT_EVCTRL1_HEVENT_Pos                                4
#define SCT_EVCTRL1_HEVENT_Msk                                (0x01UL << SCT_EVCTRL1_HEVENT_Pos)
#define SCT_EVCTRL1_OUTSEL_Pos                                5
#define SCT_EVCTRL1_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL1_OUTSEL_Pos)
#define SCT_EVCTRL1_IOSEL_Pos                                 6
#define SCT_EVCTRL1_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL1_IOSEL_Pos)
#define SCT_EVCTRL1_IOCOND_Pos                                10
#define SCT_EVCTRL1_IOCOND_Msk                                (0x03UL << SCT_EVCTRL1_IOCOND_Pos)
#define SCT_EVCTRL1_COMBMODE_Pos                              12
#define SCT_EVCTRL1_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL1_COMBMODE_Pos)
#define SCT_EVCTRL1_STATELD_Pos                               14
#define SCT_EVCTRL1_STATELD_Msk                               (0x01UL << SCT_EVCTRL1_STATELD_Pos)
#define SCT_EVCTRL1_STATEV_Pos                                15
#define SCT_EVCTRL1_STATEV_Msk                                (0x1fUL << SCT_EVCTRL1_STATEV_Pos)

// -------------------------------------  SCT_EVSTATEMSK2  ----------------------------------------
#define SCT_EVSTATEMSK2_STATEMSKn0_Pos                        0
#define SCT_EVSTATEMSK2_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn1_Pos                        1
#define SCT_EVSTATEMSK2_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn2_Pos                        2
#define SCT_EVSTATEMSK2_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn3_Pos                        3
#define SCT_EVSTATEMSK2_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn4_Pos                        4
#define SCT_EVSTATEMSK2_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn5_Pos                        5
#define SCT_EVSTATEMSK2_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn6_Pos                        6
#define SCT_EVSTATEMSK2_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn7_Pos                        7
#define SCT_EVSTATEMSK2_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn8_Pos                        8
#define SCT_EVSTATEMSK2_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn9_Pos                        9
#define SCT_EVSTATEMSK2_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK2_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn10_Pos                       10
#define SCT_EVSTATEMSK2_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn11_Pos                       11
#define SCT_EVSTATEMSK2_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn12_Pos                       12
#define SCT_EVSTATEMSK2_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn13_Pos                       13
#define SCT_EVSTATEMSK2_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn14_Pos                       14
#define SCT_EVSTATEMSK2_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn15_Pos                       15
#define SCT_EVSTATEMSK2_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn16_Pos                       16
#define SCT_EVSTATEMSK2_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn17_Pos                       17
#define SCT_EVSTATEMSK2_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn18_Pos                       18
#define SCT_EVSTATEMSK2_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn19_Pos                       19
#define SCT_EVSTATEMSK2_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn20_Pos                       20
#define SCT_EVSTATEMSK2_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn21_Pos                       21
#define SCT_EVSTATEMSK2_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn22_Pos                       22
#define SCT_EVSTATEMSK2_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn23_Pos                       23
#define SCT_EVSTATEMSK2_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn24_Pos                       24
#define SCT_EVSTATEMSK2_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn25_Pos                       25
#define SCT_EVSTATEMSK2_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn26_Pos                       26
#define SCT_EVSTATEMSK2_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn27_Pos                       27
#define SCT_EVSTATEMSK2_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn28_Pos                       28
#define SCT_EVSTATEMSK2_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn29_Pos                       29
#define SCT_EVSTATEMSK2_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn30_Pos                       30
#define SCT_EVSTATEMSK2_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK2_STATEMSKn31_Pos                       31
#define SCT_EVSTATEMSK2_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK2_STATEMSKn31_Pos)

// ---------------------------------------  SCT_EVCTRL2  ------------------------------------------
#define SCT_EVCTRL2_MATCHSEL_Pos                              0
#define SCT_EVCTRL2_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL2_MATCHSEL_Pos)
#define SCT_EVCTRL2_HEVENT_Pos                                4
#define SCT_EVCTRL2_HEVENT_Msk                                (0x01UL << SCT_EVCTRL2_HEVENT_Pos)
#define SCT_EVCTRL2_OUTSEL_Pos                                5
#define SCT_EVCTRL2_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL2_OUTSEL_Pos)
#define SCT_EVCTRL2_IOSEL_Pos                                 6
#define SCT_EVCTRL2_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL2_IOSEL_Pos)
#define SCT_EVCTRL2_IOCOND_Pos                                10
#define SCT_EVCTRL2_IOCOND_Msk                                (0x03UL << SCT_EVCTRL2_IOCOND_Pos)
#define SCT_EVCTRL2_COMBMODE_Pos                              12
#define SCT_EVCTRL2_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL2_COMBMODE_Pos)
#define SCT_EVCTRL2_STATELD_Pos                               14
#define SCT_EVCTRL2_STATELD_Msk                               (0x01UL << SCT_EVCTRL2_STATELD_Pos)
#define SCT_EVCTRL2_STATEV_Pos                                15
#define SCT_EVCTRL2_STATEV_Msk                                (0x1fUL << SCT_EVCTRL2_STATEV_Pos)

// -------------------------------------  SCT_EVSTATEMSK3  ----------------------------------------
#define SCT_EVSTATEMSK3_STATEMSKn0_Pos                        0
#define SCT_EVSTATEMSK3_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn1_Pos                        1
#define SCT_EVSTATEMSK3_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn2_Pos                        2
#define SCT_EVSTATEMSK3_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn3_Pos                        3
#define SCT_EVSTATEMSK3_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn4_Pos                        4
#define SCT_EVSTATEMSK3_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn5_Pos                        5
#define SCT_EVSTATEMSK3_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn6_Pos                        6
#define SCT_EVSTATEMSK3_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn7_Pos                        7
#define SCT_EVSTATEMSK3_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn8_Pos                        8
#define SCT_EVSTATEMSK3_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn9_Pos                        9
#define SCT_EVSTATEMSK3_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK3_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn10_Pos                       10
#define SCT_EVSTATEMSK3_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn11_Pos                       11
#define SCT_EVSTATEMSK3_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn12_Pos                       12
#define SCT_EVSTATEMSK3_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn13_Pos                       13
#define SCT_EVSTATEMSK3_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn14_Pos                       14
#define SCT_EVSTATEMSK3_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn15_Pos                       15
#define SCT_EVSTATEMSK3_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn16_Pos                       16
#define SCT_EVSTATEMSK3_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn17_Pos                       17
#define SCT_EVSTATEMSK3_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn18_Pos                       18
#define SCT_EVSTATEMSK3_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn19_Pos                       19
#define SCT_EVSTATEMSK3_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn20_Pos                       20
#define SCT_EVSTATEMSK3_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn21_Pos                       21
#define SCT_EVSTATEMSK3_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn22_Pos                       22
#define SCT_EVSTATEMSK3_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn23_Pos                       23
#define SCT_EVSTATEMSK3_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn24_Pos                       24
#define SCT_EVSTATEMSK3_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn25_Pos                       25
#define SCT_EVSTATEMSK3_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn26_Pos                       26
#define SCT_EVSTATEMSK3_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn27_Pos                       27
#define SCT_EVSTATEMSK3_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn28_Pos                       28
#define SCT_EVSTATEMSK3_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn29_Pos                       29
#define SCT_EVSTATEMSK3_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn30_Pos                       30
#define SCT_EVSTATEMSK3_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK3_STATEMSKn31_Pos                       31
#define SCT_EVSTATEMSK3_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK3_STATEMSKn31_Pos)

// ---------------------------------------  SCT_EVCTRL3  ------------------------------------------
#define SCT_EVCTRL3_MATCHSEL_Pos                              0
#define SCT_EVCTRL3_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL3_MATCHSEL_Pos)
#define SCT_EVCTRL3_HEVENT_Pos                                4
#define SCT_EVCTRL3_HEVENT_Msk                                (0x01UL << SCT_EVCTRL3_HEVENT_Pos)
#define SCT_EVCTRL3_OUTSEL_Pos                                5
#define SCT_EVCTRL3_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL3_OUTSEL_Pos)
#define SCT_EVCTRL3_IOSEL_Pos                                 6
#define SCT_EVCTRL3_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL3_IOSEL_Pos)
#define SCT_EVCTRL3_IOCOND_Pos                                10
#define SCT_EVCTRL3_IOCOND_Msk                                (0x03UL << SCT_EVCTRL3_IOCOND_Pos)
#define SCT_EVCTRL3_COMBMODE_Pos                              12
#define SCT_EVCTRL3_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL3_COMBMODE_Pos)
#define SCT_EVCTRL3_STATELD_Pos                               14
#define SCT_EVCTRL3_STATELD_Msk                               (0x01UL << SCT_EVCTRL3_STATELD_Pos)
#define SCT_EVCTRL3_STATEV_Pos                                15
#define SCT_EVCTRL3_STATEV_Msk                                (0x1fUL << SCT_EVCTRL3_STATEV_Pos)

// -------------------------------------  SCT_EVSTATEMSK4  ----------------------------------------
#define SCT_EVSTATEMSK4_STATEMSKn0_Pos                        0
#define SCT_EVSTATEMSK4_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn1_Pos                        1
#define SCT_EVSTATEMSK4_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn2_Pos                        2
#define SCT_EVSTATEMSK4_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn3_Pos                        3
#define SCT_EVSTATEMSK4_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn4_Pos                        4
#define SCT_EVSTATEMSK4_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn5_Pos                        5
#define SCT_EVSTATEMSK4_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn6_Pos                        6
#define SCT_EVSTATEMSK4_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn7_Pos                        7
#define SCT_EVSTATEMSK4_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn8_Pos                        8
#define SCT_EVSTATEMSK4_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn9_Pos                        9
#define SCT_EVSTATEMSK4_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK4_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn10_Pos                       10
#define SCT_EVSTATEMSK4_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn11_Pos                       11
#define SCT_EVSTATEMSK4_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn12_Pos                       12
#define SCT_EVSTATEMSK4_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn13_Pos                       13
#define SCT_EVSTATEMSK4_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn14_Pos                       14
#define SCT_EVSTATEMSK4_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn15_Pos                       15
#define SCT_EVSTATEMSK4_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn16_Pos                       16
#define SCT_EVSTATEMSK4_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn17_Pos                       17
#define SCT_EVSTATEMSK4_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn18_Pos                       18
#define SCT_EVSTATEMSK4_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn19_Pos                       19
#define SCT_EVSTATEMSK4_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn20_Pos                       20
#define SCT_EVSTATEMSK4_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn21_Pos                       21
#define SCT_EVSTATEMSK4_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn22_Pos                       22
#define SCT_EVSTATEMSK4_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn23_Pos                       23
#define SCT_EVSTATEMSK4_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn24_Pos                       24
#define SCT_EVSTATEMSK4_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn25_Pos                       25
#define SCT_EVSTATEMSK4_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn26_Pos                       26
#define SCT_EVSTATEMSK4_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn27_Pos                       27
#define SCT_EVSTATEMSK4_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn28_Pos                       28
#define SCT_EVSTATEMSK4_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn29_Pos                       29
#define SCT_EVSTATEMSK4_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn30_Pos                       30
#define SCT_EVSTATEMSK4_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK4_STATEMSKn31_Pos                       31
#define SCT_EVSTATEMSK4_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK4_STATEMSKn31_Pos)

// ---------------------------------------  SCT_EVCTRL4  ------------------------------------------
#define SCT_EVCTRL4_MATCHSEL_Pos                              0
#define SCT_EVCTRL4_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL4_MATCHSEL_Pos)
#define SCT_EVCTRL4_HEVENT_Pos                                4
#define SCT_EVCTRL4_HEVENT_Msk                                (0x01UL << SCT_EVCTRL4_HEVENT_Pos)
#define SCT_EVCTRL4_OUTSEL_Pos                                5
#define SCT_EVCTRL4_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL4_OUTSEL_Pos)
#define SCT_EVCTRL4_IOSEL_Pos                                 6
#define SCT_EVCTRL4_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL4_IOSEL_Pos)
#define SCT_EVCTRL4_IOCOND_Pos                                10
#define SCT_EVCTRL4_IOCOND_Msk                                (0x03UL << SCT_EVCTRL4_IOCOND_Pos)
#define SCT_EVCTRL4_COMBMODE_Pos                              12
#define SCT_EVCTRL4_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL4_COMBMODE_Pos)
#define SCT_EVCTRL4_STATELD_Pos                               14
#define SCT_EVCTRL4_STATELD_Msk                               (0x01UL << SCT_EVCTRL4_STATELD_Pos)
#define SCT_EVCTRL4_STATEV_Pos                                15
#define SCT_EVCTRL4_STATEV_Msk                                (0x1fUL << SCT_EVCTRL4_STATEV_Pos)

// -------------------------------------  SCT_EVSTATEMSK5  ----------------------------------------
#define SCT_EVSTATEMSK5_STATEMSKn0_Pos                        0
#define SCT_EVSTATEMSK5_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn1_Pos                        1
#define SCT_EVSTATEMSK5_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn2_Pos                        2
#define SCT_EVSTATEMSK5_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn3_Pos                        3
#define SCT_EVSTATEMSK5_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn4_Pos                        4
#define SCT_EVSTATEMSK5_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn5_Pos                        5
#define SCT_EVSTATEMSK5_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn6_Pos                        6
#define SCT_EVSTATEMSK5_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn7_Pos                        7
#define SCT_EVSTATEMSK5_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn8_Pos                        8
#define SCT_EVSTATEMSK5_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn9_Pos                        9
#define SCT_EVSTATEMSK5_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK5_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn10_Pos                       10
#define SCT_EVSTATEMSK5_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn11_Pos                       11
#define SCT_EVSTATEMSK5_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn12_Pos                       12
#define SCT_EVSTATEMSK5_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn13_Pos                       13
#define SCT_EVSTATEMSK5_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn14_Pos                       14
#define SCT_EVSTATEMSK5_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn15_Pos                       15
#define SCT_EVSTATEMSK5_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn16_Pos                       16
#define SCT_EVSTATEMSK5_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn17_Pos                       17
#define SCT_EVSTATEMSK5_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn18_Pos                       18
#define SCT_EVSTATEMSK5_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn19_Pos                       19
#define SCT_EVSTATEMSK5_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn20_Pos                       20
#define SCT_EVSTATEMSK5_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn21_Pos                       21
#define SCT_EVSTATEMSK5_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn22_Pos                       22
#define SCT_EVSTATEMSK5_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn23_Pos                       23
#define SCT_EVSTATEMSK5_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn24_Pos                       24
#define SCT_EVSTATEMSK5_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn25_Pos                       25
#define SCT_EVSTATEMSK5_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn26_Pos                       26
#define SCT_EVSTATEMSK5_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn27_Pos                       27
#define SCT_EVSTATEMSK5_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn28_Pos                       28
#define SCT_EVSTATEMSK5_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn29_Pos                       29
#define SCT_EVSTATEMSK5_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn30_Pos                       30
#define SCT_EVSTATEMSK5_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK5_STATEMSKn31_Pos                       31
#define SCT_EVSTATEMSK5_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK5_STATEMSKn31_Pos)

// ---------------------------------------  SCT_EVCTRL5  ------------------------------------------
#define SCT_EVCTRL5_MATCHSEL_Pos                              0
#define SCT_EVCTRL5_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL5_MATCHSEL_Pos)
#define SCT_EVCTRL5_HEVENT_Pos                                4
#define SCT_EVCTRL5_HEVENT_Msk                                (0x01UL << SCT_EVCTRL5_HEVENT_Pos)
#define SCT_EVCTRL5_OUTSEL_Pos                                5
#define SCT_EVCTRL5_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL5_OUTSEL_Pos)
#define SCT_EVCTRL5_IOSEL_Pos                                 6
#define SCT_EVCTRL5_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL5_IOSEL_Pos)
#define SCT_EVCTRL5_IOCOND_Pos                                10
#define SCT_EVCTRL5_IOCOND_Msk                                (0x03UL << SCT_EVCTRL5_IOCOND_Pos)
#define SCT_EVCTRL5_COMBMODE_Pos                              12
#define SCT_EVCTRL5_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL5_COMBMODE_Pos)
#define SCT_EVCTRL5_STATELD_Pos                               14
#define SCT_EVCTRL5_STATELD_Msk                               (0x01UL << SCT_EVCTRL5_STATELD_Pos)
#define SCT_EVCTRL5_STATEV_Pos                                15
#define SCT_EVCTRL5_STATEV_Msk                                (0x1fUL << SCT_EVCTRL5_STATEV_Pos)

// -------------------------------------  SCT_EVSTATEMSK6  ----------------------------------------
#define SCT_EVSTATEMSK6_STATEMSKn0_Pos                        0
#define SCT_EVSTATEMSK6_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn1_Pos                        1
#define SCT_EVSTATEMSK6_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn2_Pos                        2
#define SCT_EVSTATEMSK6_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn3_Pos                        3
#define SCT_EVSTATEMSK6_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn4_Pos                        4
#define SCT_EVSTATEMSK6_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn5_Pos                        5
#define SCT_EVSTATEMSK6_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn6_Pos                        6
#define SCT_EVSTATEMSK6_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn7_Pos                        7
#define SCT_EVSTATEMSK6_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn8_Pos                        8
#define SCT_EVSTATEMSK6_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn9_Pos                        9
#define SCT_EVSTATEMSK6_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK6_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn10_Pos                       10
#define SCT_EVSTATEMSK6_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn11_Pos                       11
#define SCT_EVSTATEMSK6_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn12_Pos                       12
#define SCT_EVSTATEMSK6_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn13_Pos                       13
#define SCT_EVSTATEMSK6_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn14_Pos                       14
#define SCT_EVSTATEMSK6_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn15_Pos                       15
#define SCT_EVSTATEMSK6_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn16_Pos                       16
#define SCT_EVSTATEMSK6_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn17_Pos                       17
#define SCT_EVSTATEMSK6_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn18_Pos                       18
#define SCT_EVSTATEMSK6_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn19_Pos                       19
#define SCT_EVSTATEMSK6_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn20_Pos                       20
#define SCT_EVSTATEMSK6_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn21_Pos                       21
#define SCT_EVSTATEMSK6_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn22_Pos                       22
#define SCT_EVSTATEMSK6_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn23_Pos                       23
#define SCT_EVSTATEMSK6_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn24_Pos                       24
#define SCT_EVSTATEMSK6_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn25_Pos                       25
#define SCT_EVSTATEMSK6_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn26_Pos                       26
#define SCT_EVSTATEMSK6_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn27_Pos                       27
#define SCT_EVSTATEMSK6_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn28_Pos                       28
#define SCT_EVSTATEMSK6_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn29_Pos                       29
#define SCT_EVSTATEMSK6_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn30_Pos                       30
#define SCT_EVSTATEMSK6_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK6_STATEMSKn31_Pos                       31
#define SCT_EVSTATEMSK6_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK6_STATEMSKn31_Pos)

// ---------------------------------------  SCT_EVCTRL6  ------------------------------------------
#define SCT_EVCTRL6_MATCHSEL_Pos                              0
#define SCT_EVCTRL6_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL6_MATCHSEL_Pos)
#define SCT_EVCTRL6_HEVENT_Pos                                4
#define SCT_EVCTRL6_HEVENT_Msk                                (0x01UL << SCT_EVCTRL6_HEVENT_Pos)
#define SCT_EVCTRL6_OUTSEL_Pos                                5
#define SCT_EVCTRL6_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL6_OUTSEL_Pos)
#define SCT_EVCTRL6_IOSEL_Pos                                 6
#define SCT_EVCTRL6_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL6_IOSEL_Pos)
#define SCT_EVCTRL6_IOCOND_Pos                                10
#define SCT_EVCTRL6_IOCOND_Msk                                (0x03UL << SCT_EVCTRL6_IOCOND_Pos)
#define SCT_EVCTRL6_COMBMODE_Pos                              12
#define SCT_EVCTRL6_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL6_COMBMODE_Pos)
#define SCT_EVCTRL6_STATELD_Pos                               14
#define SCT_EVCTRL6_STATELD_Msk                               (0x01UL << SCT_EVCTRL6_STATELD_Pos)
#define SCT_EVCTRL6_STATEV_Pos                                15
#define SCT_EVCTRL6_STATEV_Msk                                (0x1fUL << SCT_EVCTRL6_STATEV_Pos)

// -------------------------------------  SCT_EVSTATEMSK7  ----------------------------------------
#define SCT_EVSTATEMSK7_STATEMSKn0_Pos                        0
#define SCT_EVSTATEMSK7_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn1_Pos                        1
#define SCT_EVSTATEMSK7_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn2_Pos                        2
#define SCT_EVSTATEMSK7_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn3_Pos                        3
#define SCT_EVSTATEMSK7_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn4_Pos                        4
#define SCT_EVSTATEMSK7_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn5_Pos                        5
#define SCT_EVSTATEMSK7_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn6_Pos                        6
#define SCT_EVSTATEMSK7_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn7_Pos                        7
#define SCT_EVSTATEMSK7_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn8_Pos                        8
#define SCT_EVSTATEMSK7_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn9_Pos                        9
#define SCT_EVSTATEMSK7_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK7_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn10_Pos                       10
#define SCT_EVSTATEMSK7_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn11_Pos                       11
#define SCT_EVSTATEMSK7_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn12_Pos                       12
#define SCT_EVSTATEMSK7_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn13_Pos                       13
#define SCT_EVSTATEMSK7_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn14_Pos                       14
#define SCT_EVSTATEMSK7_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn15_Pos                       15
#define SCT_EVSTATEMSK7_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn16_Pos                       16
#define SCT_EVSTATEMSK7_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn17_Pos                       17
#define SCT_EVSTATEMSK7_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn18_Pos                       18
#define SCT_EVSTATEMSK7_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn19_Pos                       19
#define SCT_EVSTATEMSK7_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn20_Pos                       20
#define SCT_EVSTATEMSK7_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn21_Pos                       21
#define SCT_EVSTATEMSK7_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn22_Pos                       22
#define SCT_EVSTATEMSK7_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn23_Pos                       23
#define SCT_EVSTATEMSK7_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn24_Pos                       24
#define SCT_EVSTATEMSK7_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn25_Pos                       25
#define SCT_EVSTATEMSK7_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn26_Pos                       26
#define SCT_EVSTATEMSK7_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn27_Pos                       27
#define SCT_EVSTATEMSK7_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn28_Pos                       28
#define SCT_EVSTATEMSK7_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn29_Pos                       29
#define SCT_EVSTATEMSK7_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn30_Pos                       30
#define SCT_EVSTATEMSK7_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK7_STATEMSKn31_Pos                       31
#define SCT_EVSTATEMSK7_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK7_STATEMSKn31_Pos)

// ---------------------------------------  SCT_EVCTRL7  ------------------------------------------
#define SCT_EVCTRL7_MATCHSEL_Pos                              0
#define SCT_EVCTRL7_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL7_MATCHSEL_Pos)
#define SCT_EVCTRL7_HEVENT_Pos                                4
#define SCT_EVCTRL7_HEVENT_Msk                                (0x01UL << SCT_EVCTRL7_HEVENT_Pos)
#define SCT_EVCTRL7_OUTSEL_Pos                                5
#define SCT_EVCTRL7_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL7_OUTSEL_Pos)
#define SCT_EVCTRL7_IOSEL_Pos                                 6
#define SCT_EVCTRL7_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL7_IOSEL_Pos)
#define SCT_EVCTRL7_IOCOND_Pos                                10
#define SCT_EVCTRL7_IOCOND_Msk                                (0x03UL << SCT_EVCTRL7_IOCOND_Pos)
#define SCT_EVCTRL7_COMBMODE_Pos                              12
#define SCT_EVCTRL7_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL7_COMBMODE_Pos)
#define SCT_EVCTRL7_STATELD_Pos                               14
#define SCT_EVCTRL7_STATELD_Msk                               (0x01UL << SCT_EVCTRL7_STATELD_Pos)
#define SCT_EVCTRL7_STATEV_Pos                                15
#define SCT_EVCTRL7_STATEV_Msk                                (0x1fUL << SCT_EVCTRL7_STATEV_Pos)

// -------------------------------------  SCT_EVSTATEMSK8  ----------------------------------------
#define SCT_EVSTATEMSK8_STATEMSKn0_Pos                        0
#define SCT_EVSTATEMSK8_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn1_Pos                        1
#define SCT_EVSTATEMSK8_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn2_Pos                        2
#define SCT_EVSTATEMSK8_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn3_Pos                        3
#define SCT_EVSTATEMSK8_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn4_Pos                        4
#define SCT_EVSTATEMSK8_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn5_Pos                        5
#define SCT_EVSTATEMSK8_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn6_Pos                        6
#define SCT_EVSTATEMSK8_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn7_Pos                        7
#define SCT_EVSTATEMSK8_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn8_Pos                        8
#define SCT_EVSTATEMSK8_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn9_Pos                        9
#define SCT_EVSTATEMSK8_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK8_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn10_Pos                       10
#define SCT_EVSTATEMSK8_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn11_Pos                       11
#define SCT_EVSTATEMSK8_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn12_Pos                       12
#define SCT_EVSTATEMSK8_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn13_Pos                       13
#define SCT_EVSTATEMSK8_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn14_Pos                       14
#define SCT_EVSTATEMSK8_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn15_Pos                       15
#define SCT_EVSTATEMSK8_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn16_Pos                       16
#define SCT_EVSTATEMSK8_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn17_Pos                       17
#define SCT_EVSTATEMSK8_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn18_Pos                       18
#define SCT_EVSTATEMSK8_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn19_Pos                       19
#define SCT_EVSTATEMSK8_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn20_Pos                       20
#define SCT_EVSTATEMSK8_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn21_Pos                       21
#define SCT_EVSTATEMSK8_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn22_Pos                       22
#define SCT_EVSTATEMSK8_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn23_Pos                       23
#define SCT_EVSTATEMSK8_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn24_Pos                       24
#define SCT_EVSTATEMSK8_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn25_Pos                       25
#define SCT_EVSTATEMSK8_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn26_Pos                       26
#define SCT_EVSTATEMSK8_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn27_Pos                       27
#define SCT_EVSTATEMSK8_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn28_Pos                       28
#define SCT_EVSTATEMSK8_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn29_Pos                       29
#define SCT_EVSTATEMSK8_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn30_Pos                       30
#define SCT_EVSTATEMSK8_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK8_STATEMSKn31_Pos                       31
#define SCT_EVSTATEMSK8_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK8_STATEMSKn31_Pos)

// ---------------------------------------  SCT_EVCTRL8  ------------------------------------------
#define SCT_EVCTRL8_MATCHSEL_Pos                              0
#define SCT_EVCTRL8_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL8_MATCHSEL_Pos)
#define SCT_EVCTRL8_HEVENT_Pos                                4
#define SCT_EVCTRL8_HEVENT_Msk                                (0x01UL << SCT_EVCTRL8_HEVENT_Pos)
#define SCT_EVCTRL8_OUTSEL_Pos                                5
#define SCT_EVCTRL8_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL8_OUTSEL_Pos)
#define SCT_EVCTRL8_IOSEL_Pos                                 6
#define SCT_EVCTRL8_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL8_IOSEL_Pos)
#define SCT_EVCTRL8_IOCOND_Pos                                10
#define SCT_EVCTRL8_IOCOND_Msk                                (0x03UL << SCT_EVCTRL8_IOCOND_Pos)
#define SCT_EVCTRL8_COMBMODE_Pos                              12
#define SCT_EVCTRL8_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL8_COMBMODE_Pos)
#define SCT_EVCTRL8_STATELD_Pos                               14
#define SCT_EVCTRL8_STATELD_Msk                               (0x01UL << SCT_EVCTRL8_STATELD_Pos)
#define SCT_EVCTRL8_STATEV_Pos                                15
#define SCT_EVCTRL8_STATEV_Msk                                (0x1fUL << SCT_EVCTRL8_STATEV_Pos)

// -------------------------------------  SCT_EVSTATEMSK9  ----------------------------------------
#define SCT_EVSTATEMSK9_STATEMSKn0_Pos                        0
#define SCT_EVSTATEMSK9_STATEMSKn0_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn1_Pos                        1
#define SCT_EVSTATEMSK9_STATEMSKn1_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn2_Pos                        2
#define SCT_EVSTATEMSK9_STATEMSKn2_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn3_Pos                        3
#define SCT_EVSTATEMSK9_STATEMSKn3_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn4_Pos                        4
#define SCT_EVSTATEMSK9_STATEMSKn4_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn5_Pos                        5
#define SCT_EVSTATEMSK9_STATEMSKn5_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn6_Pos                        6
#define SCT_EVSTATEMSK9_STATEMSKn6_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn7_Pos                        7
#define SCT_EVSTATEMSK9_STATEMSKn7_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn8_Pos                        8
#define SCT_EVSTATEMSK9_STATEMSKn8_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn9_Pos                        9
#define SCT_EVSTATEMSK9_STATEMSKn9_Msk                        (0x01UL << SCT_EVSTATEMSK9_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn10_Pos                       10
#define SCT_EVSTATEMSK9_STATEMSKn10_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn11_Pos                       11
#define SCT_EVSTATEMSK9_STATEMSKn11_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn12_Pos                       12
#define SCT_EVSTATEMSK9_STATEMSKn12_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn13_Pos                       13
#define SCT_EVSTATEMSK9_STATEMSKn13_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn14_Pos                       14
#define SCT_EVSTATEMSK9_STATEMSKn14_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn15_Pos                       15
#define SCT_EVSTATEMSK9_STATEMSKn15_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn16_Pos                       16
#define SCT_EVSTATEMSK9_STATEMSKn16_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn17_Pos                       17
#define SCT_EVSTATEMSK9_STATEMSKn17_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn18_Pos                       18
#define SCT_EVSTATEMSK9_STATEMSKn18_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn19_Pos                       19
#define SCT_EVSTATEMSK9_STATEMSKn19_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn20_Pos                       20
#define SCT_EVSTATEMSK9_STATEMSKn20_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn21_Pos                       21
#define SCT_EVSTATEMSK9_STATEMSKn21_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn22_Pos                       22
#define SCT_EVSTATEMSK9_STATEMSKn22_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn23_Pos                       23
#define SCT_EVSTATEMSK9_STATEMSKn23_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn24_Pos                       24
#define SCT_EVSTATEMSK9_STATEMSKn24_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn25_Pos                       25
#define SCT_EVSTATEMSK9_STATEMSKn25_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn26_Pos                       26
#define SCT_EVSTATEMSK9_STATEMSKn26_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn27_Pos                       27
#define SCT_EVSTATEMSK9_STATEMSKn27_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn28_Pos                       28
#define SCT_EVSTATEMSK9_STATEMSKn28_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn29_Pos                       29
#define SCT_EVSTATEMSK9_STATEMSKn29_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn30_Pos                       30
#define SCT_EVSTATEMSK9_STATEMSKn30_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK9_STATEMSKn31_Pos                       31
#define SCT_EVSTATEMSK9_STATEMSKn31_Msk                       (0x01UL << SCT_EVSTATEMSK9_STATEMSKn31_Pos)

// ---------------------------------------  SCT_EVCTRL9  ------------------------------------------
#define SCT_EVCTRL9_MATCHSEL_Pos                              0
#define SCT_EVCTRL9_MATCHSEL_Msk                              (0x0fUL << SCT_EVCTRL9_MATCHSEL_Pos)
#define SCT_EVCTRL9_HEVENT_Pos                                4
#define SCT_EVCTRL9_HEVENT_Msk                                (0x01UL << SCT_EVCTRL9_HEVENT_Pos)
#define SCT_EVCTRL9_OUTSEL_Pos                                5
#define SCT_EVCTRL9_OUTSEL_Msk                                (0x01UL << SCT_EVCTRL9_OUTSEL_Pos)
#define SCT_EVCTRL9_IOSEL_Pos                                 6
#define SCT_EVCTRL9_IOSEL_Msk                                 (0x0fUL << SCT_EVCTRL9_IOSEL_Pos)
#define SCT_EVCTRL9_IOCOND_Pos                                10
#define SCT_EVCTRL9_IOCOND_Msk                                (0x03UL << SCT_EVCTRL9_IOCOND_Pos)
#define SCT_EVCTRL9_COMBMODE_Pos                              12
#define SCT_EVCTRL9_COMBMODE_Msk                              (0x03UL << SCT_EVCTRL9_COMBMODE_Pos)
#define SCT_EVCTRL9_STATELD_Pos                               14
#define SCT_EVCTRL9_STATELD_Msk                               (0x01UL << SCT_EVCTRL9_STATELD_Pos)
#define SCT_EVCTRL9_STATEV_Pos                                15
#define SCT_EVCTRL9_STATEV_Msk                                (0x1fUL << SCT_EVCTRL9_STATEV_Pos)

// ------------------------------------  SCT_EVSTATEMSK10  ----------------------------------------
#define SCT_EVSTATEMSK10_STATEMSKn0_Pos                       0
#define SCT_EVSTATEMSK10_STATEMSKn0_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn1_Pos                       1
#define SCT_EVSTATEMSK10_STATEMSKn1_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn2_Pos                       2
#define SCT_EVSTATEMSK10_STATEMSKn2_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn3_Pos                       3
#define SCT_EVSTATEMSK10_STATEMSKn3_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn4_Pos                       4
#define SCT_EVSTATEMSK10_STATEMSKn4_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn5_Pos                       5
#define SCT_EVSTATEMSK10_STATEMSKn5_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn6_Pos                       6
#define SCT_EVSTATEMSK10_STATEMSKn6_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn7_Pos                       7
#define SCT_EVSTATEMSK10_STATEMSKn7_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn8_Pos                       8
#define SCT_EVSTATEMSK10_STATEMSKn8_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn9_Pos                       9
#define SCT_EVSTATEMSK10_STATEMSKn9_Msk                       (0x01UL << SCT_EVSTATEMSK10_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn10_Pos                      10
#define SCT_EVSTATEMSK10_STATEMSKn10_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn11_Pos                      11
#define SCT_EVSTATEMSK10_STATEMSKn11_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn12_Pos                      12
#define SCT_EVSTATEMSK10_STATEMSKn12_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn13_Pos                      13
#define SCT_EVSTATEMSK10_STATEMSKn13_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn14_Pos                      14
#define SCT_EVSTATEMSK10_STATEMSKn14_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn15_Pos                      15
#define SCT_EVSTATEMSK10_STATEMSKn15_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn16_Pos                      16
#define SCT_EVSTATEMSK10_STATEMSKn16_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn17_Pos                      17
#define SCT_EVSTATEMSK10_STATEMSKn17_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn18_Pos                      18
#define SCT_EVSTATEMSK10_STATEMSKn18_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn19_Pos                      19
#define SCT_EVSTATEMSK10_STATEMSKn19_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn20_Pos                      20
#define SCT_EVSTATEMSK10_STATEMSKn20_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn21_Pos                      21
#define SCT_EVSTATEMSK10_STATEMSKn21_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn22_Pos                      22
#define SCT_EVSTATEMSK10_STATEMSKn22_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn23_Pos                      23
#define SCT_EVSTATEMSK10_STATEMSKn23_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn24_Pos                      24
#define SCT_EVSTATEMSK10_STATEMSKn24_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn25_Pos                      25
#define SCT_EVSTATEMSK10_STATEMSKn25_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn26_Pos                      26
#define SCT_EVSTATEMSK10_STATEMSKn26_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn27_Pos                      27
#define SCT_EVSTATEMSK10_STATEMSKn27_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn28_Pos                      28
#define SCT_EVSTATEMSK10_STATEMSKn28_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn29_Pos                      29
#define SCT_EVSTATEMSK10_STATEMSKn29_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn30_Pos                      30
#define SCT_EVSTATEMSK10_STATEMSKn30_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK10_STATEMSKn31_Pos                      31
#define SCT_EVSTATEMSK10_STATEMSKn31_Msk                      (0x01UL << SCT_EVSTATEMSK10_STATEMSKn31_Pos)

// --------------------------------------  SCT_EVCTRL10  ------------------------------------------
#define SCT_EVCTRL10_MATCHSEL_Pos                             0
#define SCT_EVCTRL10_MATCHSEL_Msk                             (0x0fUL << SCT_EVCTRL10_MATCHSEL_Pos)
#define SCT_EVCTRL10_HEVENT_Pos                               4
#define SCT_EVCTRL10_HEVENT_Msk                               (0x01UL << SCT_EVCTRL10_HEVENT_Pos)
#define SCT_EVCTRL10_OUTSEL_Pos                               5
#define SCT_EVCTRL10_OUTSEL_Msk                               (0x01UL << SCT_EVCTRL10_OUTSEL_Pos)
#define SCT_EVCTRL10_IOSEL_Pos                                6
#define SCT_EVCTRL10_IOSEL_Msk                                (0x0fUL << SCT_EVCTRL10_IOSEL_Pos)
#define SCT_EVCTRL10_IOCOND_Pos                               10
#define SCT_EVCTRL10_IOCOND_Msk                               (0x03UL << SCT_EVCTRL10_IOCOND_Pos)
#define SCT_EVCTRL10_COMBMODE_Pos                             12
#define SCT_EVCTRL10_COMBMODE_Msk                             (0x03UL << SCT_EVCTRL10_COMBMODE_Pos)
#define SCT_EVCTRL10_STATELD_Pos                              14
#define SCT_EVCTRL10_STATELD_Msk                              (0x01UL << SCT_EVCTRL10_STATELD_Pos)
#define SCT_EVCTRL10_STATEV_Pos                               15
#define SCT_EVCTRL10_STATEV_Msk                               (0x1fUL << SCT_EVCTRL10_STATEV_Pos)

// ------------------------------------  SCT_EVSTATEMSK11  ----------------------------------------
#define SCT_EVSTATEMSK11_STATEMSKn0_Pos                       0
#define SCT_EVSTATEMSK11_STATEMSKn0_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn1_Pos                       1
#define SCT_EVSTATEMSK11_STATEMSKn1_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn2_Pos                       2
#define SCT_EVSTATEMSK11_STATEMSKn2_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn3_Pos                       3
#define SCT_EVSTATEMSK11_STATEMSKn3_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn4_Pos                       4
#define SCT_EVSTATEMSK11_STATEMSKn4_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn5_Pos                       5
#define SCT_EVSTATEMSK11_STATEMSKn5_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn6_Pos                       6
#define SCT_EVSTATEMSK11_STATEMSKn6_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn7_Pos                       7
#define SCT_EVSTATEMSK11_STATEMSKn7_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn8_Pos                       8
#define SCT_EVSTATEMSK11_STATEMSKn8_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn9_Pos                       9
#define SCT_EVSTATEMSK11_STATEMSKn9_Msk                       (0x01UL << SCT_EVSTATEMSK11_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn10_Pos                      10
#define SCT_EVSTATEMSK11_STATEMSKn10_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn11_Pos                      11
#define SCT_EVSTATEMSK11_STATEMSKn11_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn12_Pos                      12
#define SCT_EVSTATEMSK11_STATEMSKn12_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn13_Pos                      13
#define SCT_EVSTATEMSK11_STATEMSKn13_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn14_Pos                      14
#define SCT_EVSTATEMSK11_STATEMSKn14_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn15_Pos                      15
#define SCT_EVSTATEMSK11_STATEMSKn15_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn16_Pos                      16
#define SCT_EVSTATEMSK11_STATEMSKn16_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn17_Pos                      17
#define SCT_EVSTATEMSK11_STATEMSKn17_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn18_Pos                      18
#define SCT_EVSTATEMSK11_STATEMSKn18_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn19_Pos                      19
#define SCT_EVSTATEMSK11_STATEMSKn19_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn20_Pos                      20
#define SCT_EVSTATEMSK11_STATEMSKn20_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn21_Pos                      21
#define SCT_EVSTATEMSK11_STATEMSKn21_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn22_Pos                      22
#define SCT_EVSTATEMSK11_STATEMSKn22_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn23_Pos                      23
#define SCT_EVSTATEMSK11_STATEMSKn23_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn24_Pos                      24
#define SCT_EVSTATEMSK11_STATEMSKn24_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn25_Pos                      25
#define SCT_EVSTATEMSK11_STATEMSKn25_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn26_Pos                      26
#define SCT_EVSTATEMSK11_STATEMSKn26_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn27_Pos                      27
#define SCT_EVSTATEMSK11_STATEMSKn27_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn28_Pos                      28
#define SCT_EVSTATEMSK11_STATEMSKn28_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn29_Pos                      29
#define SCT_EVSTATEMSK11_STATEMSKn29_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn30_Pos                      30
#define SCT_EVSTATEMSK11_STATEMSKn30_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK11_STATEMSKn31_Pos                      31
#define SCT_EVSTATEMSK11_STATEMSKn31_Msk                      (0x01UL << SCT_EVSTATEMSK11_STATEMSKn31_Pos)

// --------------------------------------  SCT_EVCTRL11  ------------------------------------------
#define SCT_EVCTRL11_MATCHSEL_Pos                             0
#define SCT_EVCTRL11_MATCHSEL_Msk                             (0x0fUL << SCT_EVCTRL11_MATCHSEL_Pos)
#define SCT_EVCTRL11_HEVENT_Pos                               4
#define SCT_EVCTRL11_HEVENT_Msk                               (0x01UL << SCT_EVCTRL11_HEVENT_Pos)
#define SCT_EVCTRL11_OUTSEL_Pos                               5
#define SCT_EVCTRL11_OUTSEL_Msk                               (0x01UL << SCT_EVCTRL11_OUTSEL_Pos)
#define SCT_EVCTRL11_IOSEL_Pos                                6
#define SCT_EVCTRL11_IOSEL_Msk                                (0x0fUL << SCT_EVCTRL11_IOSEL_Pos)
#define SCT_EVCTRL11_IOCOND_Pos                               10
#define SCT_EVCTRL11_IOCOND_Msk                               (0x03UL << SCT_EVCTRL11_IOCOND_Pos)
#define SCT_EVCTRL11_COMBMODE_Pos                             12
#define SCT_EVCTRL11_COMBMODE_Msk                             (0x03UL << SCT_EVCTRL11_COMBMODE_Pos)
#define SCT_EVCTRL11_STATELD_Pos                              14
#define SCT_EVCTRL11_STATELD_Msk                              (0x01UL << SCT_EVCTRL11_STATELD_Pos)
#define SCT_EVCTRL11_STATEV_Pos                               15
#define SCT_EVCTRL11_STATEV_Msk                               (0x1fUL << SCT_EVCTRL11_STATEV_Pos)

// ------------------------------------  SCT_EVSTATEMSK12  ----------------------------------------
#define SCT_EVSTATEMSK12_STATEMSKn0_Pos                       0
#define SCT_EVSTATEMSK12_STATEMSKn0_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn1_Pos                       1
#define SCT_EVSTATEMSK12_STATEMSKn1_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn2_Pos                       2
#define SCT_EVSTATEMSK12_STATEMSKn2_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn3_Pos                       3
#define SCT_EVSTATEMSK12_STATEMSKn3_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn4_Pos                       4
#define SCT_EVSTATEMSK12_STATEMSKn4_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn5_Pos                       5
#define SCT_EVSTATEMSK12_STATEMSKn5_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn6_Pos                       6
#define SCT_EVSTATEMSK12_STATEMSKn6_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn7_Pos                       7
#define SCT_EVSTATEMSK12_STATEMSKn7_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn8_Pos                       8
#define SCT_EVSTATEMSK12_STATEMSKn8_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn9_Pos                       9
#define SCT_EVSTATEMSK12_STATEMSKn9_Msk                       (0x01UL << SCT_EVSTATEMSK12_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn10_Pos                      10
#define SCT_EVSTATEMSK12_STATEMSKn10_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn11_Pos                      11
#define SCT_EVSTATEMSK12_STATEMSKn11_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn12_Pos                      12
#define SCT_EVSTATEMSK12_STATEMSKn12_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn13_Pos                      13
#define SCT_EVSTATEMSK12_STATEMSKn13_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn14_Pos                      14
#define SCT_EVSTATEMSK12_STATEMSKn14_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn15_Pos                      15
#define SCT_EVSTATEMSK12_STATEMSKn15_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn16_Pos                      16
#define SCT_EVSTATEMSK12_STATEMSKn16_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn17_Pos                      17
#define SCT_EVSTATEMSK12_STATEMSKn17_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn18_Pos                      18
#define SCT_EVSTATEMSK12_STATEMSKn18_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn19_Pos                      19
#define SCT_EVSTATEMSK12_STATEMSKn19_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn20_Pos                      20
#define SCT_EVSTATEMSK12_STATEMSKn20_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn21_Pos                      21
#define SCT_EVSTATEMSK12_STATEMSKn21_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn22_Pos                      22
#define SCT_EVSTATEMSK12_STATEMSKn22_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn23_Pos                      23
#define SCT_EVSTATEMSK12_STATEMSKn23_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn24_Pos                      24
#define SCT_EVSTATEMSK12_STATEMSKn24_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn25_Pos                      25
#define SCT_EVSTATEMSK12_STATEMSKn25_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn26_Pos                      26
#define SCT_EVSTATEMSK12_STATEMSKn26_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn27_Pos                      27
#define SCT_EVSTATEMSK12_STATEMSKn27_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn28_Pos                      28
#define SCT_EVSTATEMSK12_STATEMSKn28_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn29_Pos                      29
#define SCT_EVSTATEMSK12_STATEMSKn29_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn30_Pos                      30
#define SCT_EVSTATEMSK12_STATEMSKn30_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK12_STATEMSKn31_Pos                      31
#define SCT_EVSTATEMSK12_STATEMSKn31_Msk                      (0x01UL << SCT_EVSTATEMSK12_STATEMSKn31_Pos)

// --------------------------------------  SCT_EVCTRL12  ------------------------------------------
#define SCT_EVCTRL12_MATCHSEL_Pos                             0
#define SCT_EVCTRL12_MATCHSEL_Msk                             (0x0fUL << SCT_EVCTRL12_MATCHSEL_Pos)
#define SCT_EVCTRL12_HEVENT_Pos                               4
#define SCT_EVCTRL12_HEVENT_Msk                               (0x01UL << SCT_EVCTRL12_HEVENT_Pos)
#define SCT_EVCTRL12_OUTSEL_Pos                               5
#define SCT_EVCTRL12_OUTSEL_Msk                               (0x01UL << SCT_EVCTRL12_OUTSEL_Pos)
#define SCT_EVCTRL12_IOSEL_Pos                                6
#define SCT_EVCTRL12_IOSEL_Msk                                (0x0fUL << SCT_EVCTRL12_IOSEL_Pos)
#define SCT_EVCTRL12_IOCOND_Pos                               10
#define SCT_EVCTRL12_IOCOND_Msk                               (0x03UL << SCT_EVCTRL12_IOCOND_Pos)
#define SCT_EVCTRL12_COMBMODE_Pos                             12
#define SCT_EVCTRL12_COMBMODE_Msk                             (0x03UL << SCT_EVCTRL12_COMBMODE_Pos)
#define SCT_EVCTRL12_STATELD_Pos                              14
#define SCT_EVCTRL12_STATELD_Msk                              (0x01UL << SCT_EVCTRL12_STATELD_Pos)
#define SCT_EVCTRL12_STATEV_Pos                               15
#define SCT_EVCTRL12_STATEV_Msk                               (0x1fUL << SCT_EVCTRL12_STATEV_Pos)

// ------------------------------------  SCT_EVSTATEMSK13  ----------------------------------------
#define SCT_EVSTATEMSK13_STATEMSKn0_Pos                       0
#define SCT_EVSTATEMSK13_STATEMSKn0_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn1_Pos                       1
#define SCT_EVSTATEMSK13_STATEMSKn1_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn2_Pos                       2
#define SCT_EVSTATEMSK13_STATEMSKn2_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn3_Pos                       3
#define SCT_EVSTATEMSK13_STATEMSKn3_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn4_Pos                       4
#define SCT_EVSTATEMSK13_STATEMSKn4_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn5_Pos                       5
#define SCT_EVSTATEMSK13_STATEMSKn5_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn6_Pos                       6
#define SCT_EVSTATEMSK13_STATEMSKn6_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn7_Pos                       7
#define SCT_EVSTATEMSK13_STATEMSKn7_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn8_Pos                       8
#define SCT_EVSTATEMSK13_STATEMSKn8_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn9_Pos                       9
#define SCT_EVSTATEMSK13_STATEMSKn9_Msk                       (0x01UL << SCT_EVSTATEMSK13_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn10_Pos                      10
#define SCT_EVSTATEMSK13_STATEMSKn10_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn11_Pos                      11
#define SCT_EVSTATEMSK13_STATEMSKn11_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn12_Pos                      12
#define SCT_EVSTATEMSK13_STATEMSKn12_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn13_Pos                      13
#define SCT_EVSTATEMSK13_STATEMSKn13_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn14_Pos                      14
#define SCT_EVSTATEMSK13_STATEMSKn14_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn15_Pos                      15
#define SCT_EVSTATEMSK13_STATEMSKn15_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn16_Pos                      16
#define SCT_EVSTATEMSK13_STATEMSKn16_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn17_Pos                      17
#define SCT_EVSTATEMSK13_STATEMSKn17_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn18_Pos                      18
#define SCT_EVSTATEMSK13_STATEMSKn18_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn19_Pos                      19
#define SCT_EVSTATEMSK13_STATEMSKn19_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn20_Pos                      20
#define SCT_EVSTATEMSK13_STATEMSKn20_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn21_Pos                      21
#define SCT_EVSTATEMSK13_STATEMSKn21_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn22_Pos                      22
#define SCT_EVSTATEMSK13_STATEMSKn22_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn23_Pos                      23
#define SCT_EVSTATEMSK13_STATEMSKn23_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn24_Pos                      24
#define SCT_EVSTATEMSK13_STATEMSKn24_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn25_Pos                      25
#define SCT_EVSTATEMSK13_STATEMSKn25_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn26_Pos                      26
#define SCT_EVSTATEMSK13_STATEMSKn26_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn27_Pos                      27
#define SCT_EVSTATEMSK13_STATEMSKn27_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn28_Pos                      28
#define SCT_EVSTATEMSK13_STATEMSKn28_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn29_Pos                      29
#define SCT_EVSTATEMSK13_STATEMSKn29_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn30_Pos                      30
#define SCT_EVSTATEMSK13_STATEMSKn30_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK13_STATEMSKn31_Pos                      31
#define SCT_EVSTATEMSK13_STATEMSKn31_Msk                      (0x01UL << SCT_EVSTATEMSK13_STATEMSKn31_Pos)

// --------------------------------------  SCT_EVCTRL13  ------------------------------------------
#define SCT_EVCTRL13_MATCHSEL_Pos                             0
#define SCT_EVCTRL13_MATCHSEL_Msk                             (0x0fUL << SCT_EVCTRL13_MATCHSEL_Pos)
#define SCT_EVCTRL13_HEVENT_Pos                               4
#define SCT_EVCTRL13_HEVENT_Msk                               (0x01UL << SCT_EVCTRL13_HEVENT_Pos)
#define SCT_EVCTRL13_OUTSEL_Pos                               5
#define SCT_EVCTRL13_OUTSEL_Msk                               (0x01UL << SCT_EVCTRL13_OUTSEL_Pos)
#define SCT_EVCTRL13_IOSEL_Pos                                6
#define SCT_EVCTRL13_IOSEL_Msk                                (0x0fUL << SCT_EVCTRL13_IOSEL_Pos)
#define SCT_EVCTRL13_IOCOND_Pos                               10
#define SCT_EVCTRL13_IOCOND_Msk                               (0x03UL << SCT_EVCTRL13_IOCOND_Pos)
#define SCT_EVCTRL13_COMBMODE_Pos                             12
#define SCT_EVCTRL13_COMBMODE_Msk                             (0x03UL << SCT_EVCTRL13_COMBMODE_Pos)
#define SCT_EVCTRL13_STATELD_Pos                              14
#define SCT_EVCTRL13_STATELD_Msk                              (0x01UL << SCT_EVCTRL13_STATELD_Pos)
#define SCT_EVCTRL13_STATEV_Pos                               15
#define SCT_EVCTRL13_STATEV_Msk                               (0x1fUL << SCT_EVCTRL13_STATEV_Pos)

// ------------------------------------  SCT_EVSTATEMSK14  ----------------------------------------
#define SCT_EVSTATEMSK14_STATEMSKn0_Pos                       0
#define SCT_EVSTATEMSK14_STATEMSKn0_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn1_Pos                       1
#define SCT_EVSTATEMSK14_STATEMSKn1_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn2_Pos                       2
#define SCT_EVSTATEMSK14_STATEMSKn2_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn3_Pos                       3
#define SCT_EVSTATEMSK14_STATEMSKn3_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn4_Pos                       4
#define SCT_EVSTATEMSK14_STATEMSKn4_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn5_Pos                       5
#define SCT_EVSTATEMSK14_STATEMSKn5_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn6_Pos                       6
#define SCT_EVSTATEMSK14_STATEMSKn6_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn7_Pos                       7
#define SCT_EVSTATEMSK14_STATEMSKn7_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn8_Pos                       8
#define SCT_EVSTATEMSK14_STATEMSKn8_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn9_Pos                       9
#define SCT_EVSTATEMSK14_STATEMSKn9_Msk                       (0x01UL << SCT_EVSTATEMSK14_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn10_Pos                      10
#define SCT_EVSTATEMSK14_STATEMSKn10_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn11_Pos                      11
#define SCT_EVSTATEMSK14_STATEMSKn11_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn12_Pos                      12
#define SCT_EVSTATEMSK14_STATEMSKn12_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn13_Pos                      13
#define SCT_EVSTATEMSK14_STATEMSKn13_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn14_Pos                      14
#define SCT_EVSTATEMSK14_STATEMSKn14_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn15_Pos                      15
#define SCT_EVSTATEMSK14_STATEMSKn15_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn16_Pos                      16
#define SCT_EVSTATEMSK14_STATEMSKn16_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn17_Pos                      17
#define SCT_EVSTATEMSK14_STATEMSKn17_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn18_Pos                      18
#define SCT_EVSTATEMSK14_STATEMSKn18_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn19_Pos                      19
#define SCT_EVSTATEMSK14_STATEMSKn19_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn20_Pos                      20
#define SCT_EVSTATEMSK14_STATEMSKn20_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn21_Pos                      21
#define SCT_EVSTATEMSK14_STATEMSKn21_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn22_Pos                      22
#define SCT_EVSTATEMSK14_STATEMSKn22_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn23_Pos                      23
#define SCT_EVSTATEMSK14_STATEMSKn23_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn24_Pos                      24
#define SCT_EVSTATEMSK14_STATEMSKn24_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn25_Pos                      25
#define SCT_EVSTATEMSK14_STATEMSKn25_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn26_Pos                      26
#define SCT_EVSTATEMSK14_STATEMSKn26_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn27_Pos                      27
#define SCT_EVSTATEMSK14_STATEMSKn27_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn28_Pos                      28
#define SCT_EVSTATEMSK14_STATEMSKn28_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn29_Pos                      29
#define SCT_EVSTATEMSK14_STATEMSKn29_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn30_Pos                      30
#define SCT_EVSTATEMSK14_STATEMSKn30_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK14_STATEMSKn31_Pos                      31
#define SCT_EVSTATEMSK14_STATEMSKn31_Msk                      (0x01UL << SCT_EVSTATEMSK14_STATEMSKn31_Pos)

// --------------------------------------  SCT_EVCTRL14  ------------------------------------------
#define SCT_EVCTRL14_MATCHSEL_Pos                             0
#define SCT_EVCTRL14_MATCHSEL_Msk                             (0x0fUL << SCT_EVCTRL14_MATCHSEL_Pos)
#define SCT_EVCTRL14_HEVENT_Pos                               4
#define SCT_EVCTRL14_HEVENT_Msk                               (0x01UL << SCT_EVCTRL14_HEVENT_Pos)
#define SCT_EVCTRL14_OUTSEL_Pos                               5
#define SCT_EVCTRL14_OUTSEL_Msk                               (0x01UL << SCT_EVCTRL14_OUTSEL_Pos)
#define SCT_EVCTRL14_IOSEL_Pos                                6
#define SCT_EVCTRL14_IOSEL_Msk                                (0x0fUL << SCT_EVCTRL14_IOSEL_Pos)
#define SCT_EVCTRL14_IOCOND_Pos                               10
#define SCT_EVCTRL14_IOCOND_Msk                               (0x03UL << SCT_EVCTRL14_IOCOND_Pos)
#define SCT_EVCTRL14_COMBMODE_Pos                             12
#define SCT_EVCTRL14_COMBMODE_Msk                             (0x03UL << SCT_EVCTRL14_COMBMODE_Pos)
#define SCT_EVCTRL14_STATELD_Pos                              14
#define SCT_EVCTRL14_STATELD_Msk                              (0x01UL << SCT_EVCTRL14_STATELD_Pos)
#define SCT_EVCTRL14_STATEV_Pos                               15
#define SCT_EVCTRL14_STATEV_Msk                               (0x1fUL << SCT_EVCTRL14_STATEV_Pos)

// ------------------------------------  SCT_EVSTATEMSK15  ----------------------------------------
#define SCT_EVSTATEMSK15_STATEMSKn0_Pos                       0
#define SCT_EVSTATEMSK15_STATEMSKn0_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn0_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn1_Pos                       1
#define SCT_EVSTATEMSK15_STATEMSKn1_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn1_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn2_Pos                       2
#define SCT_EVSTATEMSK15_STATEMSKn2_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn2_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn3_Pos                       3
#define SCT_EVSTATEMSK15_STATEMSKn3_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn3_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn4_Pos                       4
#define SCT_EVSTATEMSK15_STATEMSKn4_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn4_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn5_Pos                       5
#define SCT_EVSTATEMSK15_STATEMSKn5_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn5_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn6_Pos                       6
#define SCT_EVSTATEMSK15_STATEMSKn6_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn6_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn7_Pos                       7
#define SCT_EVSTATEMSK15_STATEMSKn7_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn7_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn8_Pos                       8
#define SCT_EVSTATEMSK15_STATEMSKn8_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn8_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn9_Pos                       9
#define SCT_EVSTATEMSK15_STATEMSKn9_Msk                       (0x01UL << SCT_EVSTATEMSK15_STATEMSKn9_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn10_Pos                      10
#define SCT_EVSTATEMSK15_STATEMSKn10_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn10_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn11_Pos                      11
#define SCT_EVSTATEMSK15_STATEMSKn11_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn11_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn12_Pos                      12
#define SCT_EVSTATEMSK15_STATEMSKn12_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn12_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn13_Pos                      13
#define SCT_EVSTATEMSK15_STATEMSKn13_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn13_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn14_Pos                      14
#define SCT_EVSTATEMSK15_STATEMSKn14_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn14_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn15_Pos                      15
#define SCT_EVSTATEMSK15_STATEMSKn15_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn15_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn16_Pos                      16
#define SCT_EVSTATEMSK15_STATEMSKn16_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn16_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn17_Pos                      17
#define SCT_EVSTATEMSK15_STATEMSKn17_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn17_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn18_Pos                      18
#define SCT_EVSTATEMSK15_STATEMSKn18_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn18_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn19_Pos                      19
#define SCT_EVSTATEMSK15_STATEMSKn19_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn19_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn20_Pos                      20
#define SCT_EVSTATEMSK15_STATEMSKn20_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn20_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn21_Pos                      21
#define SCT_EVSTATEMSK15_STATEMSKn21_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn21_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn22_Pos                      22
#define SCT_EVSTATEMSK15_STATEMSKn22_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn22_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn23_Pos                      23
#define SCT_EVSTATEMSK15_STATEMSKn23_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn23_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn24_Pos                      24
#define SCT_EVSTATEMSK15_STATEMSKn24_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn24_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn25_Pos                      25
#define SCT_EVSTATEMSK15_STATEMSKn25_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn25_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn26_Pos                      26
#define SCT_EVSTATEMSK15_STATEMSKn26_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn26_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn27_Pos                      27
#define SCT_EVSTATEMSK15_STATEMSKn27_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn27_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn28_Pos                      28
#define SCT_EVSTATEMSK15_STATEMSKn28_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn28_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn29_Pos                      29
#define SCT_EVSTATEMSK15_STATEMSKn29_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn29_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn30_Pos                      30
#define SCT_EVSTATEMSK15_STATEMSKn30_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn30_Pos)
#define SCT_EVSTATEMSK15_STATEMSKn31_Pos                      31
#define SCT_EVSTATEMSK15_STATEMSKn31_Msk                      (0x01UL << SCT_EVSTATEMSK15_STATEMSKn31_Pos)

// --------------------------------------  SCT_EVCTRL15  ------------------------------------------
#define SCT_EVCTRL15_MATCHSEL_Pos                             0
#define SCT_EVCTRL15_MATCHSEL_Msk                             (0x0fUL << SCT_EVCTRL15_MATCHSEL_Pos)
#define SCT_EVCTRL15_HEVENT_Pos                               4
#define SCT_EVCTRL15_HEVENT_Msk                               (0x01UL << SCT_EVCTRL15_HEVENT_Pos)
#define SCT_EVCTRL15_OUTSEL_Pos                               5
#define SCT_EVCTRL15_OUTSEL_Msk                               (0x01UL << SCT_EVCTRL15_OUTSEL_Pos)
#define SCT_EVCTRL15_IOSEL_Pos                                6
#define SCT_EVCTRL15_IOSEL_Msk                                (0x0fUL << SCT_EVCTRL15_IOSEL_Pos)
#define SCT_EVCTRL15_IOCOND_Pos                               10
#define SCT_EVCTRL15_IOCOND_Msk                               (0x03UL << SCT_EVCTRL15_IOCOND_Pos)
#define SCT_EVCTRL15_COMBMODE_Pos                             12
#define SCT_EVCTRL15_COMBMODE_Msk                             (0x03UL << SCT_EVCTRL15_COMBMODE_Pos)
#define SCT_EVCTRL15_STATELD_Pos                              14
#define SCT_EVCTRL15_STATELD_Msk                              (0x01UL << SCT_EVCTRL15_STATELD_Pos)
#define SCT_EVCTRL15_STATEV_Pos                               15
#define SCT_EVCTRL15_STATEV_Msk                               (0x1fUL << SCT_EVCTRL15_STATEV_Pos)

// -------------------------------------  SCT_OUTPUTSET0  -----------------------------------------
#define SCT_OUTPUTSET0_SETn0_Pos                              0
#define SCT_OUTPUTSET0_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn0_Pos)
#define SCT_OUTPUTSET0_SETn1_Pos                              1
#define SCT_OUTPUTSET0_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn1_Pos)
#define SCT_OUTPUTSET0_SETn2_Pos                              2
#define SCT_OUTPUTSET0_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn2_Pos)
#define SCT_OUTPUTSET0_SETn3_Pos                              3
#define SCT_OUTPUTSET0_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn3_Pos)
#define SCT_OUTPUTSET0_SETn4_Pos                              4
#define SCT_OUTPUTSET0_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn4_Pos)
#define SCT_OUTPUTSET0_SETn5_Pos                              5
#define SCT_OUTPUTSET0_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn5_Pos)
#define SCT_OUTPUTSET0_SETn6_Pos                              6
#define SCT_OUTPUTSET0_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn6_Pos)
#define SCT_OUTPUTSET0_SETn7_Pos                              7
#define SCT_OUTPUTSET0_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn7_Pos)
#define SCT_OUTPUTSET0_SETn8_Pos                              8
#define SCT_OUTPUTSET0_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn8_Pos)
#define SCT_OUTPUTSET0_SETn9_Pos                              9
#define SCT_OUTPUTSET0_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET0_SETn9_Pos)
#define SCT_OUTPUTSET0_SETn10_Pos                             10
#define SCT_OUTPUTSET0_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET0_SETn10_Pos)
#define SCT_OUTPUTSET0_SETn11_Pos                             11
#define SCT_OUTPUTSET0_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET0_SETn11_Pos)
#define SCT_OUTPUTSET0_SETn12_Pos                             12
#define SCT_OUTPUTSET0_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET0_SETn12_Pos)
#define SCT_OUTPUTSET0_SETn13_Pos                             13
#define SCT_OUTPUTSET0_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET0_SETn13_Pos)
#define SCT_OUTPUTSET0_SETn14_Pos                             14
#define SCT_OUTPUTSET0_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET0_SETn14_Pos)
#define SCT_OUTPUTSET0_SETn15_Pos                             15
#define SCT_OUTPUTSET0_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET0_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR0  -----------------------------------------
#define SCT_OUTPUTCLR0_CLRn0_Pos                              0
#define SCT_OUTPUTCLR0_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn0_Pos)
#define SCT_OUTPUTCLR0_CLRn1_Pos                              1
#define SCT_OUTPUTCLR0_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn1_Pos)
#define SCT_OUTPUTCLR0_CLRn2_Pos                              2
#define SCT_OUTPUTCLR0_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn2_Pos)
#define SCT_OUTPUTCLR0_CLRn3_Pos                              3
#define SCT_OUTPUTCLR0_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn3_Pos)
#define SCT_OUTPUTCLR0_CLRn4_Pos                              4
#define SCT_OUTPUTCLR0_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn4_Pos)
#define SCT_OUTPUTCLR0_CLRn5_Pos                              5
#define SCT_OUTPUTCLR0_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn5_Pos)
#define SCT_OUTPUTCLR0_CLRn6_Pos                              6
#define SCT_OUTPUTCLR0_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn6_Pos)
#define SCT_OUTPUTCLR0_CLRn7_Pos                              7
#define SCT_OUTPUTCLR0_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn7_Pos)
#define SCT_OUTPUTCLR0_CLRn8_Pos                              8
#define SCT_OUTPUTCLR0_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn8_Pos)
#define SCT_OUTPUTCLR0_CLRn9_Pos                              9
#define SCT_OUTPUTCLR0_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR0_CLRn9_Pos)
#define SCT_OUTPUTCLR0_CLRn10_Pos                             10
#define SCT_OUTPUTCLR0_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR0_CLRn10_Pos)
#define SCT_OUTPUTCLR0_CLRn11_Pos                             11
#define SCT_OUTPUTCLR0_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR0_CLRn11_Pos)
#define SCT_OUTPUTCLR0_CLRn12_Pos                             12
#define SCT_OUTPUTCLR0_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR0_CLRn12_Pos)
#define SCT_OUTPUTCLR0_CLRn13_Pos                             13
#define SCT_OUTPUTCLR0_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR0_CLRn13_Pos)
#define SCT_OUTPUTCLR0_CLRn14_Pos                             14
#define SCT_OUTPUTCLR0_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR0_CLRn14_Pos)
#define SCT_OUTPUTCLR0_CLRn15_Pos                             15
#define SCT_OUTPUTCLR0_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR0_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET1  -----------------------------------------
#define SCT_OUTPUTSET1_SETn0_Pos                              0
#define SCT_OUTPUTSET1_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn0_Pos)
#define SCT_OUTPUTSET1_SETn1_Pos                              1
#define SCT_OUTPUTSET1_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn1_Pos)
#define SCT_OUTPUTSET1_SETn2_Pos                              2
#define SCT_OUTPUTSET1_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn2_Pos)
#define SCT_OUTPUTSET1_SETn3_Pos                              3
#define SCT_OUTPUTSET1_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn3_Pos)
#define SCT_OUTPUTSET1_SETn4_Pos                              4
#define SCT_OUTPUTSET1_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn4_Pos)
#define SCT_OUTPUTSET1_SETn5_Pos                              5
#define SCT_OUTPUTSET1_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn5_Pos)
#define SCT_OUTPUTSET1_SETn6_Pos                              6
#define SCT_OUTPUTSET1_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn6_Pos)
#define SCT_OUTPUTSET1_SETn7_Pos                              7
#define SCT_OUTPUTSET1_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn7_Pos)
#define SCT_OUTPUTSET1_SETn8_Pos                              8
#define SCT_OUTPUTSET1_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn8_Pos)
#define SCT_OUTPUTSET1_SETn9_Pos                              9
#define SCT_OUTPUTSET1_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET1_SETn9_Pos)
#define SCT_OUTPUTSET1_SETn10_Pos                             10
#define SCT_OUTPUTSET1_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET1_SETn10_Pos)
#define SCT_OUTPUTSET1_SETn11_Pos                             11
#define SCT_OUTPUTSET1_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET1_SETn11_Pos)
#define SCT_OUTPUTSET1_SETn12_Pos                             12
#define SCT_OUTPUTSET1_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET1_SETn12_Pos)
#define SCT_OUTPUTSET1_SETn13_Pos                             13
#define SCT_OUTPUTSET1_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET1_SETn13_Pos)
#define SCT_OUTPUTSET1_SETn14_Pos                             14
#define SCT_OUTPUTSET1_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET1_SETn14_Pos)
#define SCT_OUTPUTSET1_SETn15_Pos                             15
#define SCT_OUTPUTSET1_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET1_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR1  -----------------------------------------
#define SCT_OUTPUTCLR1_CLRn0_Pos                              0
#define SCT_OUTPUTCLR1_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn0_Pos)
#define SCT_OUTPUTCLR1_CLRn1_Pos                              1
#define SCT_OUTPUTCLR1_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn1_Pos)
#define SCT_OUTPUTCLR1_CLRn2_Pos                              2
#define SCT_OUTPUTCLR1_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn2_Pos)
#define SCT_OUTPUTCLR1_CLRn3_Pos                              3
#define SCT_OUTPUTCLR1_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn3_Pos)
#define SCT_OUTPUTCLR1_CLRn4_Pos                              4
#define SCT_OUTPUTCLR1_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn4_Pos)
#define SCT_OUTPUTCLR1_CLRn5_Pos                              5
#define SCT_OUTPUTCLR1_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn5_Pos)
#define SCT_OUTPUTCLR1_CLRn6_Pos                              6
#define SCT_OUTPUTCLR1_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn6_Pos)
#define SCT_OUTPUTCLR1_CLRn7_Pos                              7
#define SCT_OUTPUTCLR1_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn7_Pos)
#define SCT_OUTPUTCLR1_CLRn8_Pos                              8
#define SCT_OUTPUTCLR1_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn8_Pos)
#define SCT_OUTPUTCLR1_CLRn9_Pos                              9
#define SCT_OUTPUTCLR1_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR1_CLRn9_Pos)
#define SCT_OUTPUTCLR1_CLRn10_Pos                             10
#define SCT_OUTPUTCLR1_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR1_CLRn10_Pos)
#define SCT_OUTPUTCLR1_CLRn11_Pos                             11
#define SCT_OUTPUTCLR1_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR1_CLRn11_Pos)
#define SCT_OUTPUTCLR1_CLRn12_Pos                             12
#define SCT_OUTPUTCLR1_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR1_CLRn12_Pos)
#define SCT_OUTPUTCLR1_CLRn13_Pos                             13
#define SCT_OUTPUTCLR1_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR1_CLRn13_Pos)
#define SCT_OUTPUTCLR1_CLRn14_Pos                             14
#define SCT_OUTPUTCLR1_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR1_CLRn14_Pos)
#define SCT_OUTPUTCLR1_CLRn15_Pos                             15
#define SCT_OUTPUTCLR1_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR1_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET2  -----------------------------------------
#define SCT_OUTPUTSET2_SETn0_Pos                              0
#define SCT_OUTPUTSET2_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn0_Pos)
#define SCT_OUTPUTSET2_SETn1_Pos                              1
#define SCT_OUTPUTSET2_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn1_Pos)
#define SCT_OUTPUTSET2_SETn2_Pos                              2
#define SCT_OUTPUTSET2_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn2_Pos)
#define SCT_OUTPUTSET2_SETn3_Pos                              3
#define SCT_OUTPUTSET2_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn3_Pos)
#define SCT_OUTPUTSET2_SETn4_Pos                              4
#define SCT_OUTPUTSET2_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn4_Pos)
#define SCT_OUTPUTSET2_SETn5_Pos                              5
#define SCT_OUTPUTSET2_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn5_Pos)
#define SCT_OUTPUTSET2_SETn6_Pos                              6
#define SCT_OUTPUTSET2_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn6_Pos)
#define SCT_OUTPUTSET2_SETn7_Pos                              7
#define SCT_OUTPUTSET2_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn7_Pos)
#define SCT_OUTPUTSET2_SETn8_Pos                              8
#define SCT_OUTPUTSET2_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn8_Pos)
#define SCT_OUTPUTSET2_SETn9_Pos                              9
#define SCT_OUTPUTSET2_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET2_SETn9_Pos)
#define SCT_OUTPUTSET2_SETn10_Pos                             10
#define SCT_OUTPUTSET2_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET2_SETn10_Pos)
#define SCT_OUTPUTSET2_SETn11_Pos                             11
#define SCT_OUTPUTSET2_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET2_SETn11_Pos)
#define SCT_OUTPUTSET2_SETn12_Pos                             12
#define SCT_OUTPUTSET2_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET2_SETn12_Pos)
#define SCT_OUTPUTSET2_SETn13_Pos                             13
#define SCT_OUTPUTSET2_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET2_SETn13_Pos)
#define SCT_OUTPUTSET2_SETn14_Pos                             14
#define SCT_OUTPUTSET2_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET2_SETn14_Pos)
#define SCT_OUTPUTSET2_SETn15_Pos                             15
#define SCT_OUTPUTSET2_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET2_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR2  -----------------------------------------
#define SCT_OUTPUTCLR2_CLRn0_Pos                              0
#define SCT_OUTPUTCLR2_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn0_Pos)
#define SCT_OUTPUTCLR2_CLRn1_Pos                              1
#define SCT_OUTPUTCLR2_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn1_Pos)
#define SCT_OUTPUTCLR2_CLRn2_Pos                              2
#define SCT_OUTPUTCLR2_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn2_Pos)
#define SCT_OUTPUTCLR2_CLRn3_Pos                              3
#define SCT_OUTPUTCLR2_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn3_Pos)
#define SCT_OUTPUTCLR2_CLRn4_Pos                              4
#define SCT_OUTPUTCLR2_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn4_Pos)
#define SCT_OUTPUTCLR2_CLRn5_Pos                              5
#define SCT_OUTPUTCLR2_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn5_Pos)
#define SCT_OUTPUTCLR2_CLRn6_Pos                              6
#define SCT_OUTPUTCLR2_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn6_Pos)
#define SCT_OUTPUTCLR2_CLRn7_Pos                              7
#define SCT_OUTPUTCLR2_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn7_Pos)
#define SCT_OUTPUTCLR2_CLRn8_Pos                              8
#define SCT_OUTPUTCLR2_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn8_Pos)
#define SCT_OUTPUTCLR2_CLRn9_Pos                              9
#define SCT_OUTPUTCLR2_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR2_CLRn9_Pos)
#define SCT_OUTPUTCLR2_CLRn10_Pos                             10
#define SCT_OUTPUTCLR2_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR2_CLRn10_Pos)
#define SCT_OUTPUTCLR2_CLRn11_Pos                             11
#define SCT_OUTPUTCLR2_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR2_CLRn11_Pos)
#define SCT_OUTPUTCLR2_CLRn12_Pos                             12
#define SCT_OUTPUTCLR2_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR2_CLRn12_Pos)
#define SCT_OUTPUTCLR2_CLRn13_Pos                             13
#define SCT_OUTPUTCLR2_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR2_CLRn13_Pos)
#define SCT_OUTPUTCLR2_CLRn14_Pos                             14
#define SCT_OUTPUTCLR2_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR2_CLRn14_Pos)
#define SCT_OUTPUTCLR2_CLRn15_Pos                             15
#define SCT_OUTPUTCLR2_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR2_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET3  -----------------------------------------
#define SCT_OUTPUTSET3_SETn0_Pos                              0
#define SCT_OUTPUTSET3_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn0_Pos)
#define SCT_OUTPUTSET3_SETn1_Pos                              1
#define SCT_OUTPUTSET3_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn1_Pos)
#define SCT_OUTPUTSET3_SETn2_Pos                              2
#define SCT_OUTPUTSET3_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn2_Pos)
#define SCT_OUTPUTSET3_SETn3_Pos                              3
#define SCT_OUTPUTSET3_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn3_Pos)
#define SCT_OUTPUTSET3_SETn4_Pos                              4
#define SCT_OUTPUTSET3_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn4_Pos)
#define SCT_OUTPUTSET3_SETn5_Pos                              5
#define SCT_OUTPUTSET3_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn5_Pos)
#define SCT_OUTPUTSET3_SETn6_Pos                              6
#define SCT_OUTPUTSET3_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn6_Pos)
#define SCT_OUTPUTSET3_SETn7_Pos                              7
#define SCT_OUTPUTSET3_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn7_Pos)
#define SCT_OUTPUTSET3_SETn8_Pos                              8
#define SCT_OUTPUTSET3_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn8_Pos)
#define SCT_OUTPUTSET3_SETn9_Pos                              9
#define SCT_OUTPUTSET3_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET3_SETn9_Pos)
#define SCT_OUTPUTSET3_SETn10_Pos                             10
#define SCT_OUTPUTSET3_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET3_SETn10_Pos)
#define SCT_OUTPUTSET3_SETn11_Pos                             11
#define SCT_OUTPUTSET3_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET3_SETn11_Pos)
#define SCT_OUTPUTSET3_SETn12_Pos                             12
#define SCT_OUTPUTSET3_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET3_SETn12_Pos)
#define SCT_OUTPUTSET3_SETn13_Pos                             13
#define SCT_OUTPUTSET3_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET3_SETn13_Pos)
#define SCT_OUTPUTSET3_SETn14_Pos                             14
#define SCT_OUTPUTSET3_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET3_SETn14_Pos)
#define SCT_OUTPUTSET3_SETn15_Pos                             15
#define SCT_OUTPUTSET3_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET3_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR3  -----------------------------------------
#define SCT_OUTPUTCLR3_CLRn0_Pos                              0
#define SCT_OUTPUTCLR3_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn0_Pos)
#define SCT_OUTPUTCLR3_CLRn1_Pos                              1
#define SCT_OUTPUTCLR3_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn1_Pos)
#define SCT_OUTPUTCLR3_CLRn2_Pos                              2
#define SCT_OUTPUTCLR3_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn2_Pos)
#define SCT_OUTPUTCLR3_CLRn3_Pos                              3
#define SCT_OUTPUTCLR3_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn3_Pos)
#define SCT_OUTPUTCLR3_CLRn4_Pos                              4
#define SCT_OUTPUTCLR3_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn4_Pos)
#define SCT_OUTPUTCLR3_CLRn5_Pos                              5
#define SCT_OUTPUTCLR3_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn5_Pos)
#define SCT_OUTPUTCLR3_CLRn6_Pos                              6
#define SCT_OUTPUTCLR3_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn6_Pos)
#define SCT_OUTPUTCLR3_CLRn7_Pos                              7
#define SCT_OUTPUTCLR3_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn7_Pos)
#define SCT_OUTPUTCLR3_CLRn8_Pos                              8
#define SCT_OUTPUTCLR3_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn8_Pos)
#define SCT_OUTPUTCLR3_CLRn9_Pos                              9
#define SCT_OUTPUTCLR3_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR3_CLRn9_Pos)
#define SCT_OUTPUTCLR3_CLRn10_Pos                             10
#define SCT_OUTPUTCLR3_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR3_CLRn10_Pos)
#define SCT_OUTPUTCLR3_CLRn11_Pos                             11
#define SCT_OUTPUTCLR3_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR3_CLRn11_Pos)
#define SCT_OUTPUTCLR3_CLRn12_Pos                             12
#define SCT_OUTPUTCLR3_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR3_CLRn12_Pos)
#define SCT_OUTPUTCLR3_CLRn13_Pos                             13
#define SCT_OUTPUTCLR3_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR3_CLRn13_Pos)
#define SCT_OUTPUTCLR3_CLRn14_Pos                             14
#define SCT_OUTPUTCLR3_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR3_CLRn14_Pos)
#define SCT_OUTPUTCLR3_CLRn15_Pos                             15
#define SCT_OUTPUTCLR3_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR3_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET4  -----------------------------------------
#define SCT_OUTPUTSET4_SETn0_Pos                              0
#define SCT_OUTPUTSET4_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn0_Pos)
#define SCT_OUTPUTSET4_SETn1_Pos                              1
#define SCT_OUTPUTSET4_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn1_Pos)
#define SCT_OUTPUTSET4_SETn2_Pos                              2
#define SCT_OUTPUTSET4_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn2_Pos)
#define SCT_OUTPUTSET4_SETn3_Pos                              3
#define SCT_OUTPUTSET4_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn3_Pos)
#define SCT_OUTPUTSET4_SETn4_Pos                              4
#define SCT_OUTPUTSET4_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn4_Pos)
#define SCT_OUTPUTSET4_SETn5_Pos                              5
#define SCT_OUTPUTSET4_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn5_Pos)
#define SCT_OUTPUTSET4_SETn6_Pos                              6
#define SCT_OUTPUTSET4_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn6_Pos)
#define SCT_OUTPUTSET4_SETn7_Pos                              7
#define SCT_OUTPUTSET4_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn7_Pos)
#define SCT_OUTPUTSET4_SETn8_Pos                              8
#define SCT_OUTPUTSET4_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn8_Pos)
#define SCT_OUTPUTSET4_SETn9_Pos                              9
#define SCT_OUTPUTSET4_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET4_SETn9_Pos)
#define SCT_OUTPUTSET4_SETn10_Pos                             10
#define SCT_OUTPUTSET4_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET4_SETn10_Pos)
#define SCT_OUTPUTSET4_SETn11_Pos                             11
#define SCT_OUTPUTSET4_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET4_SETn11_Pos)
#define SCT_OUTPUTSET4_SETn12_Pos                             12
#define SCT_OUTPUTSET4_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET4_SETn12_Pos)
#define SCT_OUTPUTSET4_SETn13_Pos                             13
#define SCT_OUTPUTSET4_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET4_SETn13_Pos)
#define SCT_OUTPUTSET4_SETn14_Pos                             14
#define SCT_OUTPUTSET4_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET4_SETn14_Pos)
#define SCT_OUTPUTSET4_SETn15_Pos                             15
#define SCT_OUTPUTSET4_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET4_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR4  -----------------------------------------
#define SCT_OUTPUTCLR4_CLRn0_Pos                              0
#define SCT_OUTPUTCLR4_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn0_Pos)
#define SCT_OUTPUTCLR4_CLRn1_Pos                              1
#define SCT_OUTPUTCLR4_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn1_Pos)
#define SCT_OUTPUTCLR4_CLRn2_Pos                              2
#define SCT_OUTPUTCLR4_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn2_Pos)
#define SCT_OUTPUTCLR4_CLRn3_Pos                              3
#define SCT_OUTPUTCLR4_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn3_Pos)
#define SCT_OUTPUTCLR4_CLRn4_Pos                              4
#define SCT_OUTPUTCLR4_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn4_Pos)
#define SCT_OUTPUTCLR4_CLRn5_Pos                              5
#define SCT_OUTPUTCLR4_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn5_Pos)
#define SCT_OUTPUTCLR4_CLRn6_Pos                              6
#define SCT_OUTPUTCLR4_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn6_Pos)
#define SCT_OUTPUTCLR4_CLRn7_Pos                              7
#define SCT_OUTPUTCLR4_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn7_Pos)
#define SCT_OUTPUTCLR4_CLRn8_Pos                              8
#define SCT_OUTPUTCLR4_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn8_Pos)
#define SCT_OUTPUTCLR4_CLRn9_Pos                              9
#define SCT_OUTPUTCLR4_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR4_CLRn9_Pos)
#define SCT_OUTPUTCLR4_CLRn10_Pos                             10
#define SCT_OUTPUTCLR4_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR4_CLRn10_Pos)
#define SCT_OUTPUTCLR4_CLRn11_Pos                             11
#define SCT_OUTPUTCLR4_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR4_CLRn11_Pos)
#define SCT_OUTPUTCLR4_CLRn12_Pos                             12
#define SCT_OUTPUTCLR4_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR4_CLRn12_Pos)
#define SCT_OUTPUTCLR4_CLRn13_Pos                             13
#define SCT_OUTPUTCLR4_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR4_CLRn13_Pos)
#define SCT_OUTPUTCLR4_CLRn14_Pos                             14
#define SCT_OUTPUTCLR4_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR4_CLRn14_Pos)
#define SCT_OUTPUTCLR4_CLRn15_Pos                             15
#define SCT_OUTPUTCLR4_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR4_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET5  -----------------------------------------
#define SCT_OUTPUTSET5_SETn0_Pos                              0
#define SCT_OUTPUTSET5_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn0_Pos)
#define SCT_OUTPUTSET5_SETn1_Pos                              1
#define SCT_OUTPUTSET5_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn1_Pos)
#define SCT_OUTPUTSET5_SETn2_Pos                              2
#define SCT_OUTPUTSET5_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn2_Pos)
#define SCT_OUTPUTSET5_SETn3_Pos                              3
#define SCT_OUTPUTSET5_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn3_Pos)
#define SCT_OUTPUTSET5_SETn4_Pos                              4
#define SCT_OUTPUTSET5_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn4_Pos)
#define SCT_OUTPUTSET5_SETn5_Pos                              5
#define SCT_OUTPUTSET5_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn5_Pos)
#define SCT_OUTPUTSET5_SETn6_Pos                              6
#define SCT_OUTPUTSET5_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn6_Pos)
#define SCT_OUTPUTSET5_SETn7_Pos                              7
#define SCT_OUTPUTSET5_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn7_Pos)
#define SCT_OUTPUTSET5_SETn8_Pos                              8
#define SCT_OUTPUTSET5_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn8_Pos)
#define SCT_OUTPUTSET5_SETn9_Pos                              9
#define SCT_OUTPUTSET5_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET5_SETn9_Pos)
#define SCT_OUTPUTSET5_SETn10_Pos                             10
#define SCT_OUTPUTSET5_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET5_SETn10_Pos)
#define SCT_OUTPUTSET5_SETn11_Pos                             11
#define SCT_OUTPUTSET5_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET5_SETn11_Pos)
#define SCT_OUTPUTSET5_SETn12_Pos                             12
#define SCT_OUTPUTSET5_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET5_SETn12_Pos)
#define SCT_OUTPUTSET5_SETn13_Pos                             13
#define SCT_OUTPUTSET5_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET5_SETn13_Pos)
#define SCT_OUTPUTSET5_SETn14_Pos                             14
#define SCT_OUTPUTSET5_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET5_SETn14_Pos)
#define SCT_OUTPUTSET5_SETn15_Pos                             15
#define SCT_OUTPUTSET5_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET5_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR5  -----------------------------------------
#define SCT_OUTPUTCLR5_CLRn0_Pos                              0
#define SCT_OUTPUTCLR5_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn0_Pos)
#define SCT_OUTPUTCLR5_CLRn1_Pos                              1
#define SCT_OUTPUTCLR5_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn1_Pos)
#define SCT_OUTPUTCLR5_CLRn2_Pos                              2
#define SCT_OUTPUTCLR5_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn2_Pos)
#define SCT_OUTPUTCLR5_CLRn3_Pos                              3
#define SCT_OUTPUTCLR5_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn3_Pos)
#define SCT_OUTPUTCLR5_CLRn4_Pos                              4
#define SCT_OUTPUTCLR5_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn4_Pos)
#define SCT_OUTPUTCLR5_CLRn5_Pos                              5
#define SCT_OUTPUTCLR5_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn5_Pos)
#define SCT_OUTPUTCLR5_CLRn6_Pos                              6
#define SCT_OUTPUTCLR5_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn6_Pos)
#define SCT_OUTPUTCLR5_CLRn7_Pos                              7
#define SCT_OUTPUTCLR5_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn7_Pos)
#define SCT_OUTPUTCLR5_CLRn8_Pos                              8
#define SCT_OUTPUTCLR5_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn8_Pos)
#define SCT_OUTPUTCLR5_CLRn9_Pos                              9
#define SCT_OUTPUTCLR5_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR5_CLRn9_Pos)
#define SCT_OUTPUTCLR5_CLRn10_Pos                             10
#define SCT_OUTPUTCLR5_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR5_CLRn10_Pos)
#define SCT_OUTPUTCLR5_CLRn11_Pos                             11
#define SCT_OUTPUTCLR5_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR5_CLRn11_Pos)
#define SCT_OUTPUTCLR5_CLRn12_Pos                             12
#define SCT_OUTPUTCLR5_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR5_CLRn12_Pos)
#define SCT_OUTPUTCLR5_CLRn13_Pos                             13
#define SCT_OUTPUTCLR5_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR5_CLRn13_Pos)
#define SCT_OUTPUTCLR5_CLRn14_Pos                             14
#define SCT_OUTPUTCLR5_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR5_CLRn14_Pos)
#define SCT_OUTPUTCLR5_CLRn15_Pos                             15
#define SCT_OUTPUTCLR5_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR5_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET6  -----------------------------------------
#define SCT_OUTPUTSET6_SETn0_Pos                              0
#define SCT_OUTPUTSET6_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn0_Pos)
#define SCT_OUTPUTSET6_SETn1_Pos                              1
#define SCT_OUTPUTSET6_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn1_Pos)
#define SCT_OUTPUTSET6_SETn2_Pos                              2
#define SCT_OUTPUTSET6_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn2_Pos)
#define SCT_OUTPUTSET6_SETn3_Pos                              3
#define SCT_OUTPUTSET6_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn3_Pos)
#define SCT_OUTPUTSET6_SETn4_Pos                              4
#define SCT_OUTPUTSET6_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn4_Pos)
#define SCT_OUTPUTSET6_SETn5_Pos                              5
#define SCT_OUTPUTSET6_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn5_Pos)
#define SCT_OUTPUTSET6_SETn6_Pos                              6
#define SCT_OUTPUTSET6_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn6_Pos)
#define SCT_OUTPUTSET6_SETn7_Pos                              7
#define SCT_OUTPUTSET6_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn7_Pos)
#define SCT_OUTPUTSET6_SETn8_Pos                              8
#define SCT_OUTPUTSET6_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn8_Pos)
#define SCT_OUTPUTSET6_SETn9_Pos                              9
#define SCT_OUTPUTSET6_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET6_SETn9_Pos)
#define SCT_OUTPUTSET6_SETn10_Pos                             10
#define SCT_OUTPUTSET6_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET6_SETn10_Pos)
#define SCT_OUTPUTSET6_SETn11_Pos                             11
#define SCT_OUTPUTSET6_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET6_SETn11_Pos)
#define SCT_OUTPUTSET6_SETn12_Pos                             12
#define SCT_OUTPUTSET6_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET6_SETn12_Pos)
#define SCT_OUTPUTSET6_SETn13_Pos                             13
#define SCT_OUTPUTSET6_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET6_SETn13_Pos)
#define SCT_OUTPUTSET6_SETn14_Pos                             14
#define SCT_OUTPUTSET6_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET6_SETn14_Pos)
#define SCT_OUTPUTSET6_SETn15_Pos                             15
#define SCT_OUTPUTSET6_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET6_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR6  -----------------------------------------
#define SCT_OUTPUTCLR6_CLRn0_Pos                              0
#define SCT_OUTPUTCLR6_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn0_Pos)
#define SCT_OUTPUTCLR6_CLRn1_Pos                              1
#define SCT_OUTPUTCLR6_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn1_Pos)
#define SCT_OUTPUTCLR6_CLRn2_Pos                              2
#define SCT_OUTPUTCLR6_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn2_Pos)
#define SCT_OUTPUTCLR6_CLRn3_Pos                              3
#define SCT_OUTPUTCLR6_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn3_Pos)
#define SCT_OUTPUTCLR6_CLRn4_Pos                              4
#define SCT_OUTPUTCLR6_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn4_Pos)
#define SCT_OUTPUTCLR6_CLRn5_Pos                              5
#define SCT_OUTPUTCLR6_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn5_Pos)
#define SCT_OUTPUTCLR6_CLRn6_Pos                              6
#define SCT_OUTPUTCLR6_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn6_Pos)
#define SCT_OUTPUTCLR6_CLRn7_Pos                              7
#define SCT_OUTPUTCLR6_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn7_Pos)
#define SCT_OUTPUTCLR6_CLRn8_Pos                              8
#define SCT_OUTPUTCLR6_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn8_Pos)
#define SCT_OUTPUTCLR6_CLRn9_Pos                              9
#define SCT_OUTPUTCLR6_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR6_CLRn9_Pos)
#define SCT_OUTPUTCLR6_CLRn10_Pos                             10
#define SCT_OUTPUTCLR6_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR6_CLRn10_Pos)
#define SCT_OUTPUTCLR6_CLRn11_Pos                             11
#define SCT_OUTPUTCLR6_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR6_CLRn11_Pos)
#define SCT_OUTPUTCLR6_CLRn12_Pos                             12
#define SCT_OUTPUTCLR6_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR6_CLRn12_Pos)
#define SCT_OUTPUTCLR6_CLRn13_Pos                             13
#define SCT_OUTPUTCLR6_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR6_CLRn13_Pos)
#define SCT_OUTPUTCLR6_CLRn14_Pos                             14
#define SCT_OUTPUTCLR6_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR6_CLRn14_Pos)
#define SCT_OUTPUTCLR6_CLRn15_Pos                             15
#define SCT_OUTPUTCLR6_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR6_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET7  -----------------------------------------
#define SCT_OUTPUTSET7_SETn0_Pos                              0
#define SCT_OUTPUTSET7_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn0_Pos)
#define SCT_OUTPUTSET7_SETn1_Pos                              1
#define SCT_OUTPUTSET7_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn1_Pos)
#define SCT_OUTPUTSET7_SETn2_Pos                              2
#define SCT_OUTPUTSET7_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn2_Pos)
#define SCT_OUTPUTSET7_SETn3_Pos                              3
#define SCT_OUTPUTSET7_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn3_Pos)
#define SCT_OUTPUTSET7_SETn4_Pos                              4
#define SCT_OUTPUTSET7_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn4_Pos)
#define SCT_OUTPUTSET7_SETn5_Pos                              5
#define SCT_OUTPUTSET7_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn5_Pos)
#define SCT_OUTPUTSET7_SETn6_Pos                              6
#define SCT_OUTPUTSET7_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn6_Pos)
#define SCT_OUTPUTSET7_SETn7_Pos                              7
#define SCT_OUTPUTSET7_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn7_Pos)
#define SCT_OUTPUTSET7_SETn8_Pos                              8
#define SCT_OUTPUTSET7_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn8_Pos)
#define SCT_OUTPUTSET7_SETn9_Pos                              9
#define SCT_OUTPUTSET7_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET7_SETn9_Pos)
#define SCT_OUTPUTSET7_SETn10_Pos                             10
#define SCT_OUTPUTSET7_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET7_SETn10_Pos)
#define SCT_OUTPUTSET7_SETn11_Pos                             11
#define SCT_OUTPUTSET7_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET7_SETn11_Pos)
#define SCT_OUTPUTSET7_SETn12_Pos                             12
#define SCT_OUTPUTSET7_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET7_SETn12_Pos)
#define SCT_OUTPUTSET7_SETn13_Pos                             13
#define SCT_OUTPUTSET7_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET7_SETn13_Pos)
#define SCT_OUTPUTSET7_SETn14_Pos                             14
#define SCT_OUTPUTSET7_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET7_SETn14_Pos)
#define SCT_OUTPUTSET7_SETn15_Pos                             15
#define SCT_OUTPUTSET7_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET7_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR7  -----------------------------------------
#define SCT_OUTPUTCLR7_CLRn0_Pos                              0
#define SCT_OUTPUTCLR7_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn0_Pos)
#define SCT_OUTPUTCLR7_CLRn1_Pos                              1
#define SCT_OUTPUTCLR7_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn1_Pos)
#define SCT_OUTPUTCLR7_CLRn2_Pos                              2
#define SCT_OUTPUTCLR7_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn2_Pos)
#define SCT_OUTPUTCLR7_CLRn3_Pos                              3
#define SCT_OUTPUTCLR7_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn3_Pos)
#define SCT_OUTPUTCLR7_CLRn4_Pos                              4
#define SCT_OUTPUTCLR7_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn4_Pos)
#define SCT_OUTPUTCLR7_CLRn5_Pos                              5
#define SCT_OUTPUTCLR7_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn5_Pos)
#define SCT_OUTPUTCLR7_CLRn6_Pos                              6
#define SCT_OUTPUTCLR7_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn6_Pos)
#define SCT_OUTPUTCLR7_CLRn7_Pos                              7
#define SCT_OUTPUTCLR7_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn7_Pos)
#define SCT_OUTPUTCLR7_CLRn8_Pos                              8
#define SCT_OUTPUTCLR7_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn8_Pos)
#define SCT_OUTPUTCLR7_CLRn9_Pos                              9
#define SCT_OUTPUTCLR7_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR7_CLRn9_Pos)
#define SCT_OUTPUTCLR7_CLRn10_Pos                             10
#define SCT_OUTPUTCLR7_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR7_CLRn10_Pos)
#define SCT_OUTPUTCLR7_CLRn11_Pos                             11
#define SCT_OUTPUTCLR7_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR7_CLRn11_Pos)
#define SCT_OUTPUTCLR7_CLRn12_Pos                             12
#define SCT_OUTPUTCLR7_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR7_CLRn12_Pos)
#define SCT_OUTPUTCLR7_CLRn13_Pos                             13
#define SCT_OUTPUTCLR7_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR7_CLRn13_Pos)
#define SCT_OUTPUTCLR7_CLRn14_Pos                             14
#define SCT_OUTPUTCLR7_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR7_CLRn14_Pos)
#define SCT_OUTPUTCLR7_CLRn15_Pos                             15
#define SCT_OUTPUTCLR7_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR7_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET8  -----------------------------------------
#define SCT_OUTPUTSET8_SETn0_Pos                              0
#define SCT_OUTPUTSET8_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn0_Pos)
#define SCT_OUTPUTSET8_SETn1_Pos                              1
#define SCT_OUTPUTSET8_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn1_Pos)
#define SCT_OUTPUTSET8_SETn2_Pos                              2
#define SCT_OUTPUTSET8_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn2_Pos)
#define SCT_OUTPUTSET8_SETn3_Pos                              3
#define SCT_OUTPUTSET8_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn3_Pos)
#define SCT_OUTPUTSET8_SETn4_Pos                              4
#define SCT_OUTPUTSET8_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn4_Pos)
#define SCT_OUTPUTSET8_SETn5_Pos                              5
#define SCT_OUTPUTSET8_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn5_Pos)
#define SCT_OUTPUTSET8_SETn6_Pos                              6
#define SCT_OUTPUTSET8_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn6_Pos)
#define SCT_OUTPUTSET8_SETn7_Pos                              7
#define SCT_OUTPUTSET8_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn7_Pos)
#define SCT_OUTPUTSET8_SETn8_Pos                              8
#define SCT_OUTPUTSET8_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn8_Pos)
#define SCT_OUTPUTSET8_SETn9_Pos                              9
#define SCT_OUTPUTSET8_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET8_SETn9_Pos)
#define SCT_OUTPUTSET8_SETn10_Pos                             10
#define SCT_OUTPUTSET8_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET8_SETn10_Pos)
#define SCT_OUTPUTSET8_SETn11_Pos                             11
#define SCT_OUTPUTSET8_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET8_SETn11_Pos)
#define SCT_OUTPUTSET8_SETn12_Pos                             12
#define SCT_OUTPUTSET8_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET8_SETn12_Pos)
#define SCT_OUTPUTSET8_SETn13_Pos                             13
#define SCT_OUTPUTSET8_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET8_SETn13_Pos)
#define SCT_OUTPUTSET8_SETn14_Pos                             14
#define SCT_OUTPUTSET8_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET8_SETn14_Pos)
#define SCT_OUTPUTSET8_SETn15_Pos                             15
#define SCT_OUTPUTSET8_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET8_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR8  -----------------------------------------
#define SCT_OUTPUTCLR8_CLRn0_Pos                              0
#define SCT_OUTPUTCLR8_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn0_Pos)
#define SCT_OUTPUTCLR8_CLRn1_Pos                              1
#define SCT_OUTPUTCLR8_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn1_Pos)
#define SCT_OUTPUTCLR8_CLRn2_Pos                              2
#define SCT_OUTPUTCLR8_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn2_Pos)
#define SCT_OUTPUTCLR8_CLRn3_Pos                              3
#define SCT_OUTPUTCLR8_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn3_Pos)
#define SCT_OUTPUTCLR8_CLRn4_Pos                              4
#define SCT_OUTPUTCLR8_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn4_Pos)
#define SCT_OUTPUTCLR8_CLRn5_Pos                              5
#define SCT_OUTPUTCLR8_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn5_Pos)
#define SCT_OUTPUTCLR8_CLRn6_Pos                              6
#define SCT_OUTPUTCLR8_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn6_Pos)
#define SCT_OUTPUTCLR8_CLRn7_Pos                              7
#define SCT_OUTPUTCLR8_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn7_Pos)
#define SCT_OUTPUTCLR8_CLRn8_Pos                              8
#define SCT_OUTPUTCLR8_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn8_Pos)
#define SCT_OUTPUTCLR8_CLRn9_Pos                              9
#define SCT_OUTPUTCLR8_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR8_CLRn9_Pos)
#define SCT_OUTPUTCLR8_CLRn10_Pos                             10
#define SCT_OUTPUTCLR8_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR8_CLRn10_Pos)
#define SCT_OUTPUTCLR8_CLRn11_Pos                             11
#define SCT_OUTPUTCLR8_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR8_CLRn11_Pos)
#define SCT_OUTPUTCLR8_CLRn12_Pos                             12
#define SCT_OUTPUTCLR8_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR8_CLRn12_Pos)
#define SCT_OUTPUTCLR8_CLRn13_Pos                             13
#define SCT_OUTPUTCLR8_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR8_CLRn13_Pos)
#define SCT_OUTPUTCLR8_CLRn14_Pos                             14
#define SCT_OUTPUTCLR8_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR8_CLRn14_Pos)
#define SCT_OUTPUTCLR8_CLRn15_Pos                             15
#define SCT_OUTPUTCLR8_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR8_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET9  -----------------------------------------
#define SCT_OUTPUTSET9_SETn0_Pos                              0
#define SCT_OUTPUTSET9_SETn0_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn0_Pos)
#define SCT_OUTPUTSET9_SETn1_Pos                              1
#define SCT_OUTPUTSET9_SETn1_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn1_Pos)
#define SCT_OUTPUTSET9_SETn2_Pos                              2
#define SCT_OUTPUTSET9_SETn2_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn2_Pos)
#define SCT_OUTPUTSET9_SETn3_Pos                              3
#define SCT_OUTPUTSET9_SETn3_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn3_Pos)
#define SCT_OUTPUTSET9_SETn4_Pos                              4
#define SCT_OUTPUTSET9_SETn4_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn4_Pos)
#define SCT_OUTPUTSET9_SETn5_Pos                              5
#define SCT_OUTPUTSET9_SETn5_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn5_Pos)
#define SCT_OUTPUTSET9_SETn6_Pos                              6
#define SCT_OUTPUTSET9_SETn6_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn6_Pos)
#define SCT_OUTPUTSET9_SETn7_Pos                              7
#define SCT_OUTPUTSET9_SETn7_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn7_Pos)
#define SCT_OUTPUTSET9_SETn8_Pos                              8
#define SCT_OUTPUTSET9_SETn8_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn8_Pos)
#define SCT_OUTPUTSET9_SETn9_Pos                              9
#define SCT_OUTPUTSET9_SETn9_Msk                              (0x01UL << SCT_OUTPUTSET9_SETn9_Pos)
#define SCT_OUTPUTSET9_SETn10_Pos                             10
#define SCT_OUTPUTSET9_SETn10_Msk                             (0x01UL << SCT_OUTPUTSET9_SETn10_Pos)
#define SCT_OUTPUTSET9_SETn11_Pos                             11
#define SCT_OUTPUTSET9_SETn11_Msk                             (0x01UL << SCT_OUTPUTSET9_SETn11_Pos)
#define SCT_OUTPUTSET9_SETn12_Pos                             12
#define SCT_OUTPUTSET9_SETn12_Msk                             (0x01UL << SCT_OUTPUTSET9_SETn12_Pos)
#define SCT_OUTPUTSET9_SETn13_Pos                             13
#define SCT_OUTPUTSET9_SETn13_Msk                             (0x01UL << SCT_OUTPUTSET9_SETn13_Pos)
#define SCT_OUTPUTSET9_SETn14_Pos                             14
#define SCT_OUTPUTSET9_SETn14_Msk                             (0x01UL << SCT_OUTPUTSET9_SETn14_Pos)
#define SCT_OUTPUTSET9_SETn15_Pos                             15
#define SCT_OUTPUTSET9_SETn15_Msk                             (0x01UL << SCT_OUTPUTSET9_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR9  -----------------------------------------
#define SCT_OUTPUTCLR9_CLRn0_Pos                              0
#define SCT_OUTPUTCLR9_CLRn0_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn0_Pos)
#define SCT_OUTPUTCLR9_CLRn1_Pos                              1
#define SCT_OUTPUTCLR9_CLRn1_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn1_Pos)
#define SCT_OUTPUTCLR9_CLRn2_Pos                              2
#define SCT_OUTPUTCLR9_CLRn2_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn2_Pos)
#define SCT_OUTPUTCLR9_CLRn3_Pos                              3
#define SCT_OUTPUTCLR9_CLRn3_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn3_Pos)
#define SCT_OUTPUTCLR9_CLRn4_Pos                              4
#define SCT_OUTPUTCLR9_CLRn4_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn4_Pos)
#define SCT_OUTPUTCLR9_CLRn5_Pos                              5
#define SCT_OUTPUTCLR9_CLRn5_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn5_Pos)
#define SCT_OUTPUTCLR9_CLRn6_Pos                              6
#define SCT_OUTPUTCLR9_CLRn6_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn6_Pos)
#define SCT_OUTPUTCLR9_CLRn7_Pos                              7
#define SCT_OUTPUTCLR9_CLRn7_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn7_Pos)
#define SCT_OUTPUTCLR9_CLRn8_Pos                              8
#define SCT_OUTPUTCLR9_CLRn8_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn8_Pos)
#define SCT_OUTPUTCLR9_CLRn9_Pos                              9
#define SCT_OUTPUTCLR9_CLRn9_Msk                              (0x01UL << SCT_OUTPUTCLR9_CLRn9_Pos)
#define SCT_OUTPUTCLR9_CLRn10_Pos                             10
#define SCT_OUTPUTCLR9_CLRn10_Msk                             (0x01UL << SCT_OUTPUTCLR9_CLRn10_Pos)
#define SCT_OUTPUTCLR9_CLRn11_Pos                             11
#define SCT_OUTPUTCLR9_CLRn11_Msk                             (0x01UL << SCT_OUTPUTCLR9_CLRn11_Pos)
#define SCT_OUTPUTCLR9_CLRn12_Pos                             12
#define SCT_OUTPUTCLR9_CLRn12_Msk                             (0x01UL << SCT_OUTPUTCLR9_CLRn12_Pos)
#define SCT_OUTPUTCLR9_CLRn13_Pos                             13
#define SCT_OUTPUTCLR9_CLRn13_Msk                             (0x01UL << SCT_OUTPUTCLR9_CLRn13_Pos)
#define SCT_OUTPUTCLR9_CLRn14_Pos                             14
#define SCT_OUTPUTCLR9_CLRn14_Msk                             (0x01UL << SCT_OUTPUTCLR9_CLRn14_Pos)
#define SCT_OUTPUTCLR9_CLRn15_Pos                             15
#define SCT_OUTPUTCLR9_CLRn15_Msk                             (0x01UL << SCT_OUTPUTCLR9_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET10  ----------------------------------------
#define SCT_OUTPUTSET10_SETn0_Pos                             0
#define SCT_OUTPUTSET10_SETn0_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn0_Pos)
#define SCT_OUTPUTSET10_SETn1_Pos                             1
#define SCT_OUTPUTSET10_SETn1_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn1_Pos)
#define SCT_OUTPUTSET10_SETn2_Pos                             2
#define SCT_OUTPUTSET10_SETn2_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn2_Pos)
#define SCT_OUTPUTSET10_SETn3_Pos                             3
#define SCT_OUTPUTSET10_SETn3_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn3_Pos)
#define SCT_OUTPUTSET10_SETn4_Pos                             4
#define SCT_OUTPUTSET10_SETn4_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn4_Pos)
#define SCT_OUTPUTSET10_SETn5_Pos                             5
#define SCT_OUTPUTSET10_SETn5_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn5_Pos)
#define SCT_OUTPUTSET10_SETn6_Pos                             6
#define SCT_OUTPUTSET10_SETn6_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn6_Pos)
#define SCT_OUTPUTSET10_SETn7_Pos                             7
#define SCT_OUTPUTSET10_SETn7_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn7_Pos)
#define SCT_OUTPUTSET10_SETn8_Pos                             8
#define SCT_OUTPUTSET10_SETn8_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn8_Pos)
#define SCT_OUTPUTSET10_SETn9_Pos                             9
#define SCT_OUTPUTSET10_SETn9_Msk                             (0x01UL << SCT_OUTPUTSET10_SETn9_Pos)
#define SCT_OUTPUTSET10_SETn10_Pos                            10
#define SCT_OUTPUTSET10_SETn10_Msk                            (0x01UL << SCT_OUTPUTSET10_SETn10_Pos)
#define SCT_OUTPUTSET10_SETn11_Pos                            11
#define SCT_OUTPUTSET10_SETn11_Msk                            (0x01UL << SCT_OUTPUTSET10_SETn11_Pos)
#define SCT_OUTPUTSET10_SETn12_Pos                            12
#define SCT_OUTPUTSET10_SETn12_Msk                            (0x01UL << SCT_OUTPUTSET10_SETn12_Pos)
#define SCT_OUTPUTSET10_SETn13_Pos                            13
#define SCT_OUTPUTSET10_SETn13_Msk                            (0x01UL << SCT_OUTPUTSET10_SETn13_Pos)
#define SCT_OUTPUTSET10_SETn14_Pos                            14
#define SCT_OUTPUTSET10_SETn14_Msk                            (0x01UL << SCT_OUTPUTSET10_SETn14_Pos)
#define SCT_OUTPUTSET10_SETn15_Pos                            15
#define SCT_OUTPUTSET10_SETn15_Msk                            (0x01UL << SCT_OUTPUTSET10_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR10  ----------------------------------------
#define SCT_OUTPUTCLR10_CLRn0_Pos                             0
#define SCT_OUTPUTCLR10_CLRn0_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn0_Pos)
#define SCT_OUTPUTCLR10_CLRn1_Pos                             1
#define SCT_OUTPUTCLR10_CLRn1_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn1_Pos)
#define SCT_OUTPUTCLR10_CLRn2_Pos                             2
#define SCT_OUTPUTCLR10_CLRn2_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn2_Pos)
#define SCT_OUTPUTCLR10_CLRn3_Pos                             3
#define SCT_OUTPUTCLR10_CLRn3_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn3_Pos)
#define SCT_OUTPUTCLR10_CLRn4_Pos                             4
#define SCT_OUTPUTCLR10_CLRn4_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn4_Pos)
#define SCT_OUTPUTCLR10_CLRn5_Pos                             5
#define SCT_OUTPUTCLR10_CLRn5_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn5_Pos)
#define SCT_OUTPUTCLR10_CLRn6_Pos                             6
#define SCT_OUTPUTCLR10_CLRn6_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn6_Pos)
#define SCT_OUTPUTCLR10_CLRn7_Pos                             7
#define SCT_OUTPUTCLR10_CLRn7_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn7_Pos)
#define SCT_OUTPUTCLR10_CLRn8_Pos                             8
#define SCT_OUTPUTCLR10_CLRn8_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn8_Pos)
#define SCT_OUTPUTCLR10_CLRn9_Pos                             9
#define SCT_OUTPUTCLR10_CLRn9_Msk                             (0x01UL << SCT_OUTPUTCLR10_CLRn9_Pos)
#define SCT_OUTPUTCLR10_CLRn10_Pos                            10
#define SCT_OUTPUTCLR10_CLRn10_Msk                            (0x01UL << SCT_OUTPUTCLR10_CLRn10_Pos)
#define SCT_OUTPUTCLR10_CLRn11_Pos                            11
#define SCT_OUTPUTCLR10_CLRn11_Msk                            (0x01UL << SCT_OUTPUTCLR10_CLRn11_Pos)
#define SCT_OUTPUTCLR10_CLRn12_Pos                            12
#define SCT_OUTPUTCLR10_CLRn12_Msk                            (0x01UL << SCT_OUTPUTCLR10_CLRn12_Pos)
#define SCT_OUTPUTCLR10_CLRn13_Pos                            13
#define SCT_OUTPUTCLR10_CLRn13_Msk                            (0x01UL << SCT_OUTPUTCLR10_CLRn13_Pos)
#define SCT_OUTPUTCLR10_CLRn14_Pos                            14
#define SCT_OUTPUTCLR10_CLRn14_Msk                            (0x01UL << SCT_OUTPUTCLR10_CLRn14_Pos)
#define SCT_OUTPUTCLR10_CLRn15_Pos                            15
#define SCT_OUTPUTCLR10_CLRn15_Msk                            (0x01UL << SCT_OUTPUTCLR10_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET11  ----------------------------------------
#define SCT_OUTPUTSET11_SETn0_Pos                             0
#define SCT_OUTPUTSET11_SETn0_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn0_Pos)
#define SCT_OUTPUTSET11_SETn1_Pos                             1
#define SCT_OUTPUTSET11_SETn1_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn1_Pos)
#define SCT_OUTPUTSET11_SETn2_Pos                             2
#define SCT_OUTPUTSET11_SETn2_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn2_Pos)
#define SCT_OUTPUTSET11_SETn3_Pos                             3
#define SCT_OUTPUTSET11_SETn3_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn3_Pos)
#define SCT_OUTPUTSET11_SETn4_Pos                             4
#define SCT_OUTPUTSET11_SETn4_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn4_Pos)
#define SCT_OUTPUTSET11_SETn5_Pos                             5
#define SCT_OUTPUTSET11_SETn5_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn5_Pos)
#define SCT_OUTPUTSET11_SETn6_Pos                             6
#define SCT_OUTPUTSET11_SETn6_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn6_Pos)
#define SCT_OUTPUTSET11_SETn7_Pos                             7
#define SCT_OUTPUTSET11_SETn7_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn7_Pos)
#define SCT_OUTPUTSET11_SETn8_Pos                             8
#define SCT_OUTPUTSET11_SETn8_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn8_Pos)
#define SCT_OUTPUTSET11_SETn9_Pos                             9
#define SCT_OUTPUTSET11_SETn9_Msk                             (0x01UL << SCT_OUTPUTSET11_SETn9_Pos)
#define SCT_OUTPUTSET11_SETn10_Pos                            10
#define SCT_OUTPUTSET11_SETn10_Msk                            (0x01UL << SCT_OUTPUTSET11_SETn10_Pos)
#define SCT_OUTPUTSET11_SETn11_Pos                            11
#define SCT_OUTPUTSET11_SETn11_Msk                            (0x01UL << SCT_OUTPUTSET11_SETn11_Pos)
#define SCT_OUTPUTSET11_SETn12_Pos                            12
#define SCT_OUTPUTSET11_SETn12_Msk                            (0x01UL << SCT_OUTPUTSET11_SETn12_Pos)
#define SCT_OUTPUTSET11_SETn13_Pos                            13
#define SCT_OUTPUTSET11_SETn13_Msk                            (0x01UL << SCT_OUTPUTSET11_SETn13_Pos)
#define SCT_OUTPUTSET11_SETn14_Pos                            14
#define SCT_OUTPUTSET11_SETn14_Msk                            (0x01UL << SCT_OUTPUTSET11_SETn14_Pos)
#define SCT_OUTPUTSET11_SETn15_Pos                            15
#define SCT_OUTPUTSET11_SETn15_Msk                            (0x01UL << SCT_OUTPUTSET11_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR11  ----------------------------------------
#define SCT_OUTPUTCLR11_CLRn0_Pos                             0
#define SCT_OUTPUTCLR11_CLRn0_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn0_Pos)
#define SCT_OUTPUTCLR11_CLRn1_Pos                             1
#define SCT_OUTPUTCLR11_CLRn1_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn1_Pos)
#define SCT_OUTPUTCLR11_CLRn2_Pos                             2
#define SCT_OUTPUTCLR11_CLRn2_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn2_Pos)
#define SCT_OUTPUTCLR11_CLRn3_Pos                             3
#define SCT_OUTPUTCLR11_CLRn3_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn3_Pos)
#define SCT_OUTPUTCLR11_CLRn4_Pos                             4
#define SCT_OUTPUTCLR11_CLRn4_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn4_Pos)
#define SCT_OUTPUTCLR11_CLRn5_Pos                             5
#define SCT_OUTPUTCLR11_CLRn5_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn5_Pos)
#define SCT_OUTPUTCLR11_CLRn6_Pos                             6
#define SCT_OUTPUTCLR11_CLRn6_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn6_Pos)
#define SCT_OUTPUTCLR11_CLRn7_Pos                             7
#define SCT_OUTPUTCLR11_CLRn7_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn7_Pos)
#define SCT_OUTPUTCLR11_CLRn8_Pos                             8
#define SCT_OUTPUTCLR11_CLRn8_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn8_Pos)
#define SCT_OUTPUTCLR11_CLRn9_Pos                             9
#define SCT_OUTPUTCLR11_CLRn9_Msk                             (0x01UL << SCT_OUTPUTCLR11_CLRn9_Pos)
#define SCT_OUTPUTCLR11_CLRn10_Pos                            10
#define SCT_OUTPUTCLR11_CLRn10_Msk                            (0x01UL << SCT_OUTPUTCLR11_CLRn10_Pos)
#define SCT_OUTPUTCLR11_CLRn11_Pos                            11
#define SCT_OUTPUTCLR11_CLRn11_Msk                            (0x01UL << SCT_OUTPUTCLR11_CLRn11_Pos)
#define SCT_OUTPUTCLR11_CLRn12_Pos                            12
#define SCT_OUTPUTCLR11_CLRn12_Msk                            (0x01UL << SCT_OUTPUTCLR11_CLRn12_Pos)
#define SCT_OUTPUTCLR11_CLRn13_Pos                            13
#define SCT_OUTPUTCLR11_CLRn13_Msk                            (0x01UL << SCT_OUTPUTCLR11_CLRn13_Pos)
#define SCT_OUTPUTCLR11_CLRn14_Pos                            14
#define SCT_OUTPUTCLR11_CLRn14_Msk                            (0x01UL << SCT_OUTPUTCLR11_CLRn14_Pos)
#define SCT_OUTPUTCLR11_CLRn15_Pos                            15
#define SCT_OUTPUTCLR11_CLRn15_Msk                            (0x01UL << SCT_OUTPUTCLR11_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET12  ----------------------------------------
#define SCT_OUTPUTSET12_SETn0_Pos                             0
#define SCT_OUTPUTSET12_SETn0_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn0_Pos)
#define SCT_OUTPUTSET12_SETn1_Pos                             1
#define SCT_OUTPUTSET12_SETn1_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn1_Pos)
#define SCT_OUTPUTSET12_SETn2_Pos                             2
#define SCT_OUTPUTSET12_SETn2_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn2_Pos)
#define SCT_OUTPUTSET12_SETn3_Pos                             3
#define SCT_OUTPUTSET12_SETn3_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn3_Pos)
#define SCT_OUTPUTSET12_SETn4_Pos                             4
#define SCT_OUTPUTSET12_SETn4_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn4_Pos)
#define SCT_OUTPUTSET12_SETn5_Pos                             5
#define SCT_OUTPUTSET12_SETn5_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn5_Pos)
#define SCT_OUTPUTSET12_SETn6_Pos                             6
#define SCT_OUTPUTSET12_SETn6_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn6_Pos)
#define SCT_OUTPUTSET12_SETn7_Pos                             7
#define SCT_OUTPUTSET12_SETn7_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn7_Pos)
#define SCT_OUTPUTSET12_SETn8_Pos                             8
#define SCT_OUTPUTSET12_SETn8_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn8_Pos)
#define SCT_OUTPUTSET12_SETn9_Pos                             9
#define SCT_OUTPUTSET12_SETn9_Msk                             (0x01UL << SCT_OUTPUTSET12_SETn9_Pos)
#define SCT_OUTPUTSET12_SETn10_Pos                            10
#define SCT_OUTPUTSET12_SETn10_Msk                            (0x01UL << SCT_OUTPUTSET12_SETn10_Pos)
#define SCT_OUTPUTSET12_SETn11_Pos                            11
#define SCT_OUTPUTSET12_SETn11_Msk                            (0x01UL << SCT_OUTPUTSET12_SETn11_Pos)
#define SCT_OUTPUTSET12_SETn12_Pos                            12
#define SCT_OUTPUTSET12_SETn12_Msk                            (0x01UL << SCT_OUTPUTSET12_SETn12_Pos)
#define SCT_OUTPUTSET12_SETn13_Pos                            13
#define SCT_OUTPUTSET12_SETn13_Msk                            (0x01UL << SCT_OUTPUTSET12_SETn13_Pos)
#define SCT_OUTPUTSET12_SETn14_Pos                            14
#define SCT_OUTPUTSET12_SETn14_Msk                            (0x01UL << SCT_OUTPUTSET12_SETn14_Pos)
#define SCT_OUTPUTSET12_SETn15_Pos                            15
#define SCT_OUTPUTSET12_SETn15_Msk                            (0x01UL << SCT_OUTPUTSET12_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR12  ----------------------------------------
#define SCT_OUTPUTCLR12_CLRn0_Pos                             0
#define SCT_OUTPUTCLR12_CLRn0_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn0_Pos)
#define SCT_OUTPUTCLR12_CLRn1_Pos                             1
#define SCT_OUTPUTCLR12_CLRn1_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn1_Pos)
#define SCT_OUTPUTCLR12_CLRn2_Pos                             2
#define SCT_OUTPUTCLR12_CLRn2_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn2_Pos)
#define SCT_OUTPUTCLR12_CLRn3_Pos                             3
#define SCT_OUTPUTCLR12_CLRn3_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn3_Pos)
#define SCT_OUTPUTCLR12_CLRn4_Pos                             4
#define SCT_OUTPUTCLR12_CLRn4_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn4_Pos)
#define SCT_OUTPUTCLR12_CLRn5_Pos                             5
#define SCT_OUTPUTCLR12_CLRn5_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn5_Pos)
#define SCT_OUTPUTCLR12_CLRn6_Pos                             6
#define SCT_OUTPUTCLR12_CLRn6_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn6_Pos)
#define SCT_OUTPUTCLR12_CLRn7_Pos                             7
#define SCT_OUTPUTCLR12_CLRn7_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn7_Pos)
#define SCT_OUTPUTCLR12_CLRn8_Pos                             8
#define SCT_OUTPUTCLR12_CLRn8_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn8_Pos)
#define SCT_OUTPUTCLR12_CLRn9_Pos                             9
#define SCT_OUTPUTCLR12_CLRn9_Msk                             (0x01UL << SCT_OUTPUTCLR12_CLRn9_Pos)
#define SCT_OUTPUTCLR12_CLRn10_Pos                            10
#define SCT_OUTPUTCLR12_CLRn10_Msk                            (0x01UL << SCT_OUTPUTCLR12_CLRn10_Pos)
#define SCT_OUTPUTCLR12_CLRn11_Pos                            11
#define SCT_OUTPUTCLR12_CLRn11_Msk                            (0x01UL << SCT_OUTPUTCLR12_CLRn11_Pos)
#define SCT_OUTPUTCLR12_CLRn12_Pos                            12
#define SCT_OUTPUTCLR12_CLRn12_Msk                            (0x01UL << SCT_OUTPUTCLR12_CLRn12_Pos)
#define SCT_OUTPUTCLR12_CLRn13_Pos                            13
#define SCT_OUTPUTCLR12_CLRn13_Msk                            (0x01UL << SCT_OUTPUTCLR12_CLRn13_Pos)
#define SCT_OUTPUTCLR12_CLRn14_Pos                            14
#define SCT_OUTPUTCLR12_CLRn14_Msk                            (0x01UL << SCT_OUTPUTCLR12_CLRn14_Pos)
#define SCT_OUTPUTCLR12_CLRn15_Pos                            15
#define SCT_OUTPUTCLR12_CLRn15_Msk                            (0x01UL << SCT_OUTPUTCLR12_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET13  ----------------------------------------
#define SCT_OUTPUTSET13_SETn0_Pos                             0
#define SCT_OUTPUTSET13_SETn0_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn0_Pos)
#define SCT_OUTPUTSET13_SETn1_Pos                             1
#define SCT_OUTPUTSET13_SETn1_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn1_Pos)
#define SCT_OUTPUTSET13_SETn2_Pos                             2
#define SCT_OUTPUTSET13_SETn2_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn2_Pos)
#define SCT_OUTPUTSET13_SETn3_Pos                             3
#define SCT_OUTPUTSET13_SETn3_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn3_Pos)
#define SCT_OUTPUTSET13_SETn4_Pos                             4
#define SCT_OUTPUTSET13_SETn4_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn4_Pos)
#define SCT_OUTPUTSET13_SETn5_Pos                             5
#define SCT_OUTPUTSET13_SETn5_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn5_Pos)
#define SCT_OUTPUTSET13_SETn6_Pos                             6
#define SCT_OUTPUTSET13_SETn6_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn6_Pos)
#define SCT_OUTPUTSET13_SETn7_Pos                             7
#define SCT_OUTPUTSET13_SETn7_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn7_Pos)
#define SCT_OUTPUTSET13_SETn8_Pos                             8
#define SCT_OUTPUTSET13_SETn8_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn8_Pos)
#define SCT_OUTPUTSET13_SETn9_Pos                             9
#define SCT_OUTPUTSET13_SETn9_Msk                             (0x01UL << SCT_OUTPUTSET13_SETn9_Pos)
#define SCT_OUTPUTSET13_SETn10_Pos                            10
#define SCT_OUTPUTSET13_SETn10_Msk                            (0x01UL << SCT_OUTPUTSET13_SETn10_Pos)
#define SCT_OUTPUTSET13_SETn11_Pos                            11
#define SCT_OUTPUTSET13_SETn11_Msk                            (0x01UL << SCT_OUTPUTSET13_SETn11_Pos)
#define SCT_OUTPUTSET13_SETn12_Pos                            12
#define SCT_OUTPUTSET13_SETn12_Msk                            (0x01UL << SCT_OUTPUTSET13_SETn12_Pos)
#define SCT_OUTPUTSET13_SETn13_Pos                            13
#define SCT_OUTPUTSET13_SETn13_Msk                            (0x01UL << SCT_OUTPUTSET13_SETn13_Pos)
#define SCT_OUTPUTSET13_SETn14_Pos                            14
#define SCT_OUTPUTSET13_SETn14_Msk                            (0x01UL << SCT_OUTPUTSET13_SETn14_Pos)
#define SCT_OUTPUTSET13_SETn15_Pos                            15
#define SCT_OUTPUTSET13_SETn15_Msk                            (0x01UL << SCT_OUTPUTSET13_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR13  ----------------------------------------
#define SCT_OUTPUTCLR13_CLRn0_Pos                             0
#define SCT_OUTPUTCLR13_CLRn0_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn0_Pos)
#define SCT_OUTPUTCLR13_CLRn1_Pos                             1
#define SCT_OUTPUTCLR13_CLRn1_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn1_Pos)
#define SCT_OUTPUTCLR13_CLRn2_Pos                             2
#define SCT_OUTPUTCLR13_CLRn2_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn2_Pos)
#define SCT_OUTPUTCLR13_CLRn3_Pos                             3
#define SCT_OUTPUTCLR13_CLRn3_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn3_Pos)
#define SCT_OUTPUTCLR13_CLRn4_Pos                             4
#define SCT_OUTPUTCLR13_CLRn4_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn4_Pos)
#define SCT_OUTPUTCLR13_CLRn5_Pos                             5
#define SCT_OUTPUTCLR13_CLRn5_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn5_Pos)
#define SCT_OUTPUTCLR13_CLRn6_Pos                             6
#define SCT_OUTPUTCLR13_CLRn6_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn6_Pos)
#define SCT_OUTPUTCLR13_CLRn7_Pos                             7
#define SCT_OUTPUTCLR13_CLRn7_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn7_Pos)
#define SCT_OUTPUTCLR13_CLRn8_Pos                             8
#define SCT_OUTPUTCLR13_CLRn8_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn8_Pos)
#define SCT_OUTPUTCLR13_CLRn9_Pos                             9
#define SCT_OUTPUTCLR13_CLRn9_Msk                             (0x01UL << SCT_OUTPUTCLR13_CLRn9_Pos)
#define SCT_OUTPUTCLR13_CLRn10_Pos                            10
#define SCT_OUTPUTCLR13_CLRn10_Msk                            (0x01UL << SCT_OUTPUTCLR13_CLRn10_Pos)
#define SCT_OUTPUTCLR13_CLRn11_Pos                            11
#define SCT_OUTPUTCLR13_CLRn11_Msk                            (0x01UL << SCT_OUTPUTCLR13_CLRn11_Pos)
#define SCT_OUTPUTCLR13_CLRn12_Pos                            12
#define SCT_OUTPUTCLR13_CLRn12_Msk                            (0x01UL << SCT_OUTPUTCLR13_CLRn12_Pos)
#define SCT_OUTPUTCLR13_CLRn13_Pos                            13
#define SCT_OUTPUTCLR13_CLRn13_Msk                            (0x01UL << SCT_OUTPUTCLR13_CLRn13_Pos)
#define SCT_OUTPUTCLR13_CLRn14_Pos                            14
#define SCT_OUTPUTCLR13_CLRn14_Msk                            (0x01UL << SCT_OUTPUTCLR13_CLRn14_Pos)
#define SCT_OUTPUTCLR13_CLRn15_Pos                            15
#define SCT_OUTPUTCLR13_CLRn15_Msk                            (0x01UL << SCT_OUTPUTCLR13_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET14  ----------------------------------------
#define SCT_OUTPUTSET14_SETn0_Pos                             0
#define SCT_OUTPUTSET14_SETn0_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn0_Pos)
#define SCT_OUTPUTSET14_SETn1_Pos                             1
#define SCT_OUTPUTSET14_SETn1_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn1_Pos)
#define SCT_OUTPUTSET14_SETn2_Pos                             2
#define SCT_OUTPUTSET14_SETn2_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn2_Pos)
#define SCT_OUTPUTSET14_SETn3_Pos                             3
#define SCT_OUTPUTSET14_SETn3_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn3_Pos)
#define SCT_OUTPUTSET14_SETn4_Pos                             4
#define SCT_OUTPUTSET14_SETn4_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn4_Pos)
#define SCT_OUTPUTSET14_SETn5_Pos                             5
#define SCT_OUTPUTSET14_SETn5_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn5_Pos)
#define SCT_OUTPUTSET14_SETn6_Pos                             6
#define SCT_OUTPUTSET14_SETn6_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn6_Pos)
#define SCT_OUTPUTSET14_SETn7_Pos                             7
#define SCT_OUTPUTSET14_SETn7_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn7_Pos)
#define SCT_OUTPUTSET14_SETn8_Pos                             8
#define SCT_OUTPUTSET14_SETn8_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn8_Pos)
#define SCT_OUTPUTSET14_SETn9_Pos                             9
#define SCT_OUTPUTSET14_SETn9_Msk                             (0x01UL << SCT_OUTPUTSET14_SETn9_Pos)
#define SCT_OUTPUTSET14_SETn10_Pos                            10
#define SCT_OUTPUTSET14_SETn10_Msk                            (0x01UL << SCT_OUTPUTSET14_SETn10_Pos)
#define SCT_OUTPUTSET14_SETn11_Pos                            11
#define SCT_OUTPUTSET14_SETn11_Msk                            (0x01UL << SCT_OUTPUTSET14_SETn11_Pos)
#define SCT_OUTPUTSET14_SETn12_Pos                            12
#define SCT_OUTPUTSET14_SETn12_Msk                            (0x01UL << SCT_OUTPUTSET14_SETn12_Pos)
#define SCT_OUTPUTSET14_SETn13_Pos                            13
#define SCT_OUTPUTSET14_SETn13_Msk                            (0x01UL << SCT_OUTPUTSET14_SETn13_Pos)
#define SCT_OUTPUTSET14_SETn14_Pos                            14
#define SCT_OUTPUTSET14_SETn14_Msk                            (0x01UL << SCT_OUTPUTSET14_SETn14_Pos)
#define SCT_OUTPUTSET14_SETn15_Pos                            15
#define SCT_OUTPUTSET14_SETn15_Msk                            (0x01UL << SCT_OUTPUTSET14_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR14  ----------------------------------------
#define SCT_OUTPUTCLR14_CLRn0_Pos                             0
#define SCT_OUTPUTCLR14_CLRn0_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn0_Pos)
#define SCT_OUTPUTCLR14_CLRn1_Pos                             1
#define SCT_OUTPUTCLR14_CLRn1_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn1_Pos)
#define SCT_OUTPUTCLR14_CLRn2_Pos                             2
#define SCT_OUTPUTCLR14_CLRn2_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn2_Pos)
#define SCT_OUTPUTCLR14_CLRn3_Pos                             3
#define SCT_OUTPUTCLR14_CLRn3_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn3_Pos)
#define SCT_OUTPUTCLR14_CLRn4_Pos                             4
#define SCT_OUTPUTCLR14_CLRn4_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn4_Pos)
#define SCT_OUTPUTCLR14_CLRn5_Pos                             5
#define SCT_OUTPUTCLR14_CLRn5_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn5_Pos)
#define SCT_OUTPUTCLR14_CLRn6_Pos                             6
#define SCT_OUTPUTCLR14_CLRn6_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn6_Pos)
#define SCT_OUTPUTCLR14_CLRn7_Pos                             7
#define SCT_OUTPUTCLR14_CLRn7_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn7_Pos)
#define SCT_OUTPUTCLR14_CLRn8_Pos                             8
#define SCT_OUTPUTCLR14_CLRn8_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn8_Pos)
#define SCT_OUTPUTCLR14_CLRn9_Pos                             9
#define SCT_OUTPUTCLR14_CLRn9_Msk                             (0x01UL << SCT_OUTPUTCLR14_CLRn9_Pos)
#define SCT_OUTPUTCLR14_CLRn10_Pos                            10
#define SCT_OUTPUTCLR14_CLRn10_Msk                            (0x01UL << SCT_OUTPUTCLR14_CLRn10_Pos)
#define SCT_OUTPUTCLR14_CLRn11_Pos                            11
#define SCT_OUTPUTCLR14_CLRn11_Msk                            (0x01UL << SCT_OUTPUTCLR14_CLRn11_Pos)
#define SCT_OUTPUTCLR14_CLRn12_Pos                            12
#define SCT_OUTPUTCLR14_CLRn12_Msk                            (0x01UL << SCT_OUTPUTCLR14_CLRn12_Pos)
#define SCT_OUTPUTCLR14_CLRn13_Pos                            13
#define SCT_OUTPUTCLR14_CLRn13_Msk                            (0x01UL << SCT_OUTPUTCLR14_CLRn13_Pos)
#define SCT_OUTPUTCLR14_CLRn14_Pos                            14
#define SCT_OUTPUTCLR14_CLRn14_Msk                            (0x01UL << SCT_OUTPUTCLR14_CLRn14_Pos)
#define SCT_OUTPUTCLR14_CLRn15_Pos                            15
#define SCT_OUTPUTCLR14_CLRn15_Msk                            (0x01UL << SCT_OUTPUTCLR14_CLRn15_Pos)

// -------------------------------------  SCT_OUTPUTSET15  ----------------------------------------
#define SCT_OUTPUTSET15_SETn0_Pos                             0
#define SCT_OUTPUTSET15_SETn0_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn0_Pos)
#define SCT_OUTPUTSET15_SETn1_Pos                             1
#define SCT_OUTPUTSET15_SETn1_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn1_Pos)
#define SCT_OUTPUTSET15_SETn2_Pos                             2
#define SCT_OUTPUTSET15_SETn2_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn2_Pos)
#define SCT_OUTPUTSET15_SETn3_Pos                             3
#define SCT_OUTPUTSET15_SETn3_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn3_Pos)
#define SCT_OUTPUTSET15_SETn4_Pos                             4
#define SCT_OUTPUTSET15_SETn4_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn4_Pos)
#define SCT_OUTPUTSET15_SETn5_Pos                             5
#define SCT_OUTPUTSET15_SETn5_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn5_Pos)
#define SCT_OUTPUTSET15_SETn6_Pos                             6
#define SCT_OUTPUTSET15_SETn6_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn6_Pos)
#define SCT_OUTPUTSET15_SETn7_Pos                             7
#define SCT_OUTPUTSET15_SETn7_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn7_Pos)
#define SCT_OUTPUTSET15_SETn8_Pos                             8
#define SCT_OUTPUTSET15_SETn8_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn8_Pos)
#define SCT_OUTPUTSET15_SETn9_Pos                             9
#define SCT_OUTPUTSET15_SETn9_Msk                             (0x01UL << SCT_OUTPUTSET15_SETn9_Pos)
#define SCT_OUTPUTSET15_SETn10_Pos                            10
#define SCT_OUTPUTSET15_SETn10_Msk                            (0x01UL << SCT_OUTPUTSET15_SETn10_Pos)
#define SCT_OUTPUTSET15_SETn11_Pos                            11
#define SCT_OUTPUTSET15_SETn11_Msk                            (0x01UL << SCT_OUTPUTSET15_SETn11_Pos)
#define SCT_OUTPUTSET15_SETn12_Pos                            12
#define SCT_OUTPUTSET15_SETn12_Msk                            (0x01UL << SCT_OUTPUTSET15_SETn12_Pos)
#define SCT_OUTPUTSET15_SETn13_Pos                            13
#define SCT_OUTPUTSET15_SETn13_Msk                            (0x01UL << SCT_OUTPUTSET15_SETn13_Pos)
#define SCT_OUTPUTSET15_SETn14_Pos                            14
#define SCT_OUTPUTSET15_SETn14_Msk                            (0x01UL << SCT_OUTPUTSET15_SETn14_Pos)
#define SCT_OUTPUTSET15_SETn15_Pos                            15
#define SCT_OUTPUTSET15_SETn15_Msk                            (0x01UL << SCT_OUTPUTSET15_SETn15_Pos)

// -------------------------------------  SCT_OUTPUTCLR15  ----------------------------------------
#define SCT_OUTPUTCLR15_CLRn0_Pos                             0
#define SCT_OUTPUTCLR15_CLRn0_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn0_Pos)
#define SCT_OUTPUTCLR15_CLRn1_Pos                             1
#define SCT_OUTPUTCLR15_CLRn1_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn1_Pos)
#define SCT_OUTPUTCLR15_CLRn2_Pos                             2
#define SCT_OUTPUTCLR15_CLRn2_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn2_Pos)
#define SCT_OUTPUTCLR15_CLRn3_Pos                             3
#define SCT_OUTPUTCLR15_CLRn3_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn3_Pos)
#define SCT_OUTPUTCLR15_CLRn4_Pos                             4
#define SCT_OUTPUTCLR15_CLRn4_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn4_Pos)
#define SCT_OUTPUTCLR15_CLRn5_Pos                             5
#define SCT_OUTPUTCLR15_CLRn5_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn5_Pos)
#define SCT_OUTPUTCLR15_CLRn6_Pos                             6
#define SCT_OUTPUTCLR15_CLRn6_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn6_Pos)
#define SCT_OUTPUTCLR15_CLRn7_Pos                             7
#define SCT_OUTPUTCLR15_CLRn7_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn7_Pos)
#define SCT_OUTPUTCLR15_CLRn8_Pos                             8
#define SCT_OUTPUTCLR15_CLRn8_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn8_Pos)
#define SCT_OUTPUTCLR15_CLRn9_Pos                             9
#define SCT_OUTPUTCLR15_CLRn9_Msk                             (0x01UL << SCT_OUTPUTCLR15_CLRn9_Pos)
#define SCT_OUTPUTCLR15_CLRn10_Pos                            10
#define SCT_OUTPUTCLR15_CLRn10_Msk                            (0x01UL << SCT_OUTPUTCLR15_CLRn10_Pos)
#define SCT_OUTPUTCLR15_CLRn11_Pos                            11
#define SCT_OUTPUTCLR15_CLRn11_Msk                            (0x01UL << SCT_OUTPUTCLR15_CLRn11_Pos)
#define SCT_OUTPUTCLR15_CLRn12_Pos                            12
#define SCT_OUTPUTCLR15_CLRn12_Msk                            (0x01UL << SCT_OUTPUTCLR15_CLRn12_Pos)
#define SCT_OUTPUTCLR15_CLRn13_Pos                            13
#define SCT_OUTPUTCLR15_CLRn13_Msk                            (0x01UL << SCT_OUTPUTCLR15_CLRn13_Pos)
#define SCT_OUTPUTCLR15_CLRn14_Pos                            14
#define SCT_OUTPUTCLR15_CLRn14_Msk                            (0x01UL << SCT_OUTPUTCLR15_CLRn14_Pos)
#define SCT_OUTPUTCLR15_CLRn15_Pos                            15
#define SCT_OUTPUTCLR15_CLRn15_Msk                            (0x01UL << SCT_OUTPUTCLR15_CLRn15_Pos)


// ------------------------------------------------------------------------------------------------
// -----                                 GPDMA Position & Mask                                -----
// ------------------------------------------------------------------------------------------------


// --------------------------------------  GPDMA_INTSTAT  -----------------------------------------
#define GPDMA_INTSTAT_INTSTAT0_Pos                            0
#define GPDMA_INTSTAT_INTSTAT0_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT0_Pos)
#define GPDMA_INTSTAT_INTSTAT1_Pos                            1
#define GPDMA_INTSTAT_INTSTAT1_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT1_Pos)
#define GPDMA_INTSTAT_INTSTAT2_Pos                            2
#define GPDMA_INTSTAT_INTSTAT2_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT2_Pos)
#define GPDMA_INTSTAT_INTSTAT3_Pos                            3
#define GPDMA_INTSTAT_INTSTAT3_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT3_Pos)
#define GPDMA_INTSTAT_INTSTAT4_Pos                            4
#define GPDMA_INTSTAT_INTSTAT4_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT4_Pos)
#define GPDMA_INTSTAT_INTSTAT5_Pos                            5
#define GPDMA_INTSTAT_INTSTAT5_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT5_Pos)
#define GPDMA_INTSTAT_INTSTAT6_Pos                            6
#define GPDMA_INTSTAT_INTSTAT6_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT6_Pos)
#define GPDMA_INTSTAT_INTSTAT7_Pos                            7
#define GPDMA_INTSTAT_INTSTAT7_Msk                            (0x01UL << GPDMA_INTSTAT_INTSTAT7_Pos)

// -------------------------------------  GPDMA_INTTCSTAT  ----------------------------------------
#define GPDMA_INTTCSTAT_INTTCSTAT0_Pos                        0
#define GPDMA_INTTCSTAT_INTTCSTAT0_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT0_Pos)
#define GPDMA_INTTCSTAT_INTTCSTAT1_Pos                        1
#define GPDMA_INTTCSTAT_INTTCSTAT1_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT1_Pos)
#define GPDMA_INTTCSTAT_INTTCSTAT2_Pos                        2
#define GPDMA_INTTCSTAT_INTTCSTAT2_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT2_Pos)
#define GPDMA_INTTCSTAT_INTTCSTAT3_Pos                        3
#define GPDMA_INTTCSTAT_INTTCSTAT3_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT3_Pos)
#define GPDMA_INTTCSTAT_INTTCSTAT4_Pos                        4
#define GPDMA_INTTCSTAT_INTTCSTAT4_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT4_Pos)
#define GPDMA_INTTCSTAT_INTTCSTAT5_Pos                        5
#define GPDMA_INTTCSTAT_INTTCSTAT5_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT5_Pos)
#define GPDMA_INTTCSTAT_INTTCSTAT6_Pos                        6
#define GPDMA_INTTCSTAT_INTTCSTAT6_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT6_Pos)
#define GPDMA_INTTCSTAT_INTTCSTAT7_Pos                        7
#define GPDMA_INTTCSTAT_INTTCSTAT7_Msk                        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT7_Pos)

// ------------------------------------  GPDMA_INTTCCLEAR  ----------------------------------------
#define GPDMA_INTTCCLEAR_INTTCCLEAR0_Pos                      0
#define GPDMA_INTTCCLEAR_INTTCCLEAR0_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR0_Pos)
#define GPDMA_INTTCCLEAR_INTTCCLEAR1_Pos                      1
#define GPDMA_INTTCCLEAR_INTTCCLEAR1_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR1_Pos)
#define GPDMA_INTTCCLEAR_INTTCCLEAR2_Pos                      2
#define GPDMA_INTTCCLEAR_INTTCCLEAR2_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR2_Pos)
#define GPDMA_INTTCCLEAR_INTTCCLEAR3_Pos                      3
#define GPDMA_INTTCCLEAR_INTTCCLEAR3_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR3_Pos)
#define GPDMA_INTTCCLEAR_INTTCCLEAR4_Pos                      4
#define GPDMA_INTTCCLEAR_INTTCCLEAR4_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR4_Pos)
#define GPDMA_INTTCCLEAR_INTTCCLEAR5_Pos                      5
#define GPDMA_INTTCCLEAR_INTTCCLEAR5_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR5_Pos)
#define GPDMA_INTTCCLEAR_INTTCCLEAR6_Pos                      6
#define GPDMA_INTTCCLEAR_INTTCCLEAR6_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR6_Pos)
#define GPDMA_INTTCCLEAR_INTTCCLEAR7_Pos                      7
#define GPDMA_INTTCCLEAR_INTTCCLEAR7_Msk                      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR7_Pos)

// ------------------------------------  GPDMA_INTERRSTAT  ----------------------------------------
#define GPDMA_INTERRSTAT_INTERRSTAT0_Pos                      0
#define GPDMA_INTERRSTAT_INTERRSTAT0_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT0_Pos)
#define GPDMA_INTERRSTAT_INTERRSTAT1_Pos                      1
#define GPDMA_INTERRSTAT_INTERRSTAT1_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT1_Pos)
#define GPDMA_INTERRSTAT_INTERRSTAT2_Pos                      2
#define GPDMA_INTERRSTAT_INTERRSTAT2_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT2_Pos)
#define GPDMA_INTERRSTAT_INTERRSTAT3_Pos                      3
#define GPDMA_INTERRSTAT_INTERRSTAT3_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT3_Pos)
#define GPDMA_INTERRSTAT_INTERRSTAT4_Pos                      4
#define GPDMA_INTERRSTAT_INTERRSTAT4_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT4_Pos)
#define GPDMA_INTERRSTAT_INTERRSTAT5_Pos                      5
#define GPDMA_INTERRSTAT_INTERRSTAT5_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT5_Pos)
#define GPDMA_INTERRSTAT_INTERRSTAT6_Pos                      6
#define GPDMA_INTERRSTAT_INTERRSTAT6_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT6_Pos)
#define GPDMA_INTERRSTAT_INTERRSTAT7_Pos                      7
#define GPDMA_INTERRSTAT_INTERRSTAT7_Msk                      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT7_Pos)

// -------------------------------------  GPDMA_INTERRCLR  ----------------------------------------
#define GPDMA_INTERRCLR_INTERRCLR0_Pos                        0
#define GPDMA_INTERRCLR_INTERRCLR0_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR0_Pos)
#define GPDMA_INTERRCLR_INTERRCLR1_Pos                        1
#define GPDMA_INTERRCLR_INTERRCLR1_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR1_Pos)
#define GPDMA_INTERRCLR_INTERRCLR2_Pos                        2
#define GPDMA_INTERRCLR_INTERRCLR2_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR2_Pos)
#define GPDMA_INTERRCLR_INTERRCLR3_Pos                        3
#define GPDMA_INTERRCLR_INTERRCLR3_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR3_Pos)
#define GPDMA_INTERRCLR_INTERRCLR4_Pos                        4
#define GPDMA_INTERRCLR_INTERRCLR4_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR4_Pos)
#define GPDMA_INTERRCLR_INTERRCLR5_Pos                        5
#define GPDMA_INTERRCLR_INTERRCLR5_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR5_Pos)
#define GPDMA_INTERRCLR_INTERRCLR6_Pos                        6
#define GPDMA_INTERRCLR_INTERRCLR6_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR6_Pos)
#define GPDMA_INTERRCLR_INTERRCLR7_Pos                        7
#define GPDMA_INTERRCLR_INTERRCLR7_Msk                        (0x01UL << GPDMA_INTERRCLR_INTERRCLR7_Pos)

// -----------------------------------  GPDMA_RAWINTTCSTAT  ---------------------------------------
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Pos                  0
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Pos)
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Pos                  1
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Pos)
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Pos                  2
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Pos)
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Pos                  3
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Pos)
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Pos                  4
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Pos)
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Pos                  5
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Pos)
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Pos                  6
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Pos)
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Pos                  7
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Msk                  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Pos)

// -----------------------------------  GPDMA_RAWINTERRSTAT  --------------------------------------
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Pos                0
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Pos)
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Pos                1
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Pos)
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Pos                2
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Pos)
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Pos                3
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Pos)
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Pos                4
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Pos)
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Pos                5
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Pos)
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Pos                6
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Pos)
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Pos                7
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Msk                (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Pos)

// -------------------------------------  GPDMA_ENBLDCHNS  ----------------------------------------
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Pos                  0
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Pos)
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Pos                  1
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Pos)
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Pos                  2
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Pos)
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Pos                  3
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Pos)
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Pos                  4
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Pos)
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Pos                  5
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Pos)
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Pos                  6
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Pos)
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Pos                  7
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Msk                  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Pos)

// -------------------------------------  GPDMA_SOFTBREQ  -----------------------------------------
#define GPDMA_SOFTBREQ_SOFTBREQ0_Pos                          0
#define GPDMA_SOFTBREQ_SOFTBREQ0_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ0_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ1_Pos                          1
#define GPDMA_SOFTBREQ_SOFTBREQ1_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ1_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ2_Pos                          2
#define GPDMA_SOFTBREQ_SOFTBREQ2_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ2_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ3_Pos                          3
#define GPDMA_SOFTBREQ_SOFTBREQ3_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ3_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ4_Pos                          4
#define GPDMA_SOFTBREQ_SOFTBREQ4_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ4_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ5_Pos                          5
#define GPDMA_SOFTBREQ_SOFTBREQ5_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ5_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ6_Pos                          6
#define GPDMA_SOFTBREQ_SOFTBREQ6_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ6_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ7_Pos                          7
#define GPDMA_SOFTBREQ_SOFTBREQ7_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ7_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ8_Pos                          8
#define GPDMA_SOFTBREQ_SOFTBREQ8_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ8_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ9_Pos                          9
#define GPDMA_SOFTBREQ_SOFTBREQ9_Msk                          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ9_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ10_Pos                         10
#define GPDMA_SOFTBREQ_SOFTBREQ10_Msk                         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ10_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ11_Pos                         11
#define GPDMA_SOFTBREQ_SOFTBREQ11_Msk                         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ11_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ12_Pos                         12
#define GPDMA_SOFTBREQ_SOFTBREQ12_Msk                         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ12_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ13_Pos                         13
#define GPDMA_SOFTBREQ_SOFTBREQ13_Msk                         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ13_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ14_Pos                         14
#define GPDMA_SOFTBREQ_SOFTBREQ14_Msk                         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ14_Pos)
#define GPDMA_SOFTBREQ_SOFTBREQ15_Pos                         15
#define GPDMA_SOFTBREQ_SOFTBREQ15_Msk                         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ15_Pos)

// -------------------------------------  GPDMA_SOFTSREQ  -----------------------------------------
#define GPDMA_SOFTSREQ_SOFTSREQ0_Pos                          0
#define GPDMA_SOFTSREQ_SOFTSREQ0_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ0_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ1_Pos                          1
#define GPDMA_SOFTSREQ_SOFTSREQ1_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ1_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ2_Pos                          2
#define GPDMA_SOFTSREQ_SOFTSREQ2_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ2_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ3_Pos                          3
#define GPDMA_SOFTSREQ_SOFTSREQ3_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ3_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ4_Pos                          4
#define GPDMA_SOFTSREQ_SOFTSREQ4_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ4_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ5_Pos                          5
#define GPDMA_SOFTSREQ_SOFTSREQ5_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ5_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ6_Pos                          6
#define GPDMA_SOFTSREQ_SOFTSREQ6_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ6_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ7_Pos                          7
#define GPDMA_SOFTSREQ_SOFTSREQ7_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ7_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ8_Pos                          8
#define GPDMA_SOFTSREQ_SOFTSREQ8_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ8_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ9_Pos                          9
#define GPDMA_SOFTSREQ_SOFTSREQ9_Msk                          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ9_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ10_Pos                         10
#define GPDMA_SOFTSREQ_SOFTSREQ10_Msk                         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ10_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ11_Pos                         11
#define GPDMA_SOFTSREQ_SOFTSREQ11_Msk                         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ11_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ12_Pos                         12
#define GPDMA_SOFTSREQ_SOFTSREQ12_Msk                         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ12_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ13_Pos                         13
#define GPDMA_SOFTSREQ_SOFTSREQ13_Msk                         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ13_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ14_Pos                         14
#define GPDMA_SOFTSREQ_SOFTSREQ14_Msk                         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ14_Pos)
#define GPDMA_SOFTSREQ_SOFTSREQ15_Pos                         15
#define GPDMA_SOFTSREQ_SOFTSREQ15_Msk                         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ15_Pos)

// -------------------------------------  GPDMA_SOFTLBREQ  ----------------------------------------
#define GPDMA_SOFTLBREQ_SOFTLBREQ0_Pos                        0
#define GPDMA_SOFTLBREQ_SOFTLBREQ0_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ0_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ1_Pos                        1
#define GPDMA_SOFTLBREQ_SOFTLBREQ1_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ1_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ2_Pos                        2
#define GPDMA_SOFTLBREQ_SOFTLBREQ2_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ2_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ3_Pos                        3
#define GPDMA_SOFTLBREQ_SOFTLBREQ3_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ3_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ4_Pos                        4
#define GPDMA_SOFTLBREQ_SOFTLBREQ4_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ4_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ5_Pos                        5
#define GPDMA_SOFTLBREQ_SOFTLBREQ5_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ5_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ6_Pos                        6
#define GPDMA_SOFTLBREQ_SOFTLBREQ6_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ6_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ7_Pos                        7
#define GPDMA_SOFTLBREQ_SOFTLBREQ7_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ7_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ8_Pos                        8
#define GPDMA_SOFTLBREQ_SOFTLBREQ8_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ8_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ9_Pos                        9
#define GPDMA_SOFTLBREQ_SOFTLBREQ9_Msk                        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ9_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ10_Pos                       10
#define GPDMA_SOFTLBREQ_SOFTLBREQ10_Msk                       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ10_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ11_Pos                       11
#define GPDMA_SOFTLBREQ_SOFTLBREQ11_Msk                       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ11_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ12_Pos                       12
#define GPDMA_SOFTLBREQ_SOFTLBREQ12_Msk                       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ12_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ13_Pos                       13
#define GPDMA_SOFTLBREQ_SOFTLBREQ13_Msk                       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ13_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ14_Pos                       14
#define GPDMA_SOFTLBREQ_SOFTLBREQ14_Msk                       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ14_Pos)
#define GPDMA_SOFTLBREQ_SOFTLBREQ15_Pos                       15
#define GPDMA_SOFTLBREQ_SOFTLBREQ15_Msk                       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ15_Pos)

// -------------------------------------  GPDMA_SOFTLSREQ  ----------------------------------------
#define GPDMA_SOFTLSREQ_SOFTLSREQ0_Pos                        0
#define GPDMA_SOFTLSREQ_SOFTLSREQ0_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ0_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ1_Pos                        1
#define GPDMA_SOFTLSREQ_SOFTLSREQ1_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ1_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ2_Pos                        2
#define GPDMA_SOFTLSREQ_SOFTLSREQ2_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ2_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ3_Pos                        3
#define GPDMA_SOFTLSREQ_SOFTLSREQ3_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ3_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ4_Pos                        4
#define GPDMA_SOFTLSREQ_SOFTLSREQ4_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ4_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ5_Pos                        5
#define GPDMA_SOFTLSREQ_SOFTLSREQ5_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ5_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ6_Pos                        6
#define GPDMA_SOFTLSREQ_SOFTLSREQ6_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ6_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ7_Pos                        7
#define GPDMA_SOFTLSREQ_SOFTLSREQ7_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ7_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ8_Pos                        8
#define GPDMA_SOFTLSREQ_SOFTLSREQ8_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ8_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ9_Pos                        9
#define GPDMA_SOFTLSREQ_SOFTLSREQ9_Msk                        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ9_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ10_Pos                       10
#define GPDMA_SOFTLSREQ_SOFTLSREQ10_Msk                       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ10_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ11_Pos                       11
#define GPDMA_SOFTLSREQ_SOFTLSREQ11_Msk                       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ11_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ12_Pos                       12
#define GPDMA_SOFTLSREQ_SOFTLSREQ12_Msk                       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ12_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ13_Pos                       13
#define GPDMA_SOFTLSREQ_SOFTLSREQ13_Msk                       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ13_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ14_Pos                       14
#define GPDMA_SOFTLSREQ_SOFTLSREQ14_Msk                       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ14_Pos)
#define GPDMA_SOFTLSREQ_SOFTLSREQ15_Pos                       15
#define GPDMA_SOFTLSREQ_SOFTLSREQ15_Msk                       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ15_Pos)

// --------------------------------------  GPDMA_CONFIG  ------------------------------------------
#define GPDMA_CONFIG_E_Pos                                    0
#define GPDMA_CONFIG_E_Msk                                    (0x01UL << GPDMA_CONFIG_E_Pos)
#define GPDMA_CONFIG_M0_Pos                                   1
#define GPDMA_CONFIG_M0_Msk                                   (0x01UL << GPDMA_CONFIG_M0_Pos)
#define GPDMA_CONFIG_M1_Pos                                   2
#define GPDMA_CONFIG_M1_Msk                                   (0x01UL << GPDMA_CONFIG_M1_Pos)

// ---------------------------------------  GPDMA_SYNC  -------------------------------------------
#define GPDMA_SYNC_DMACSYNC0_Pos                              0
#define GPDMA_SYNC_DMACSYNC0_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC0_Pos)
#define GPDMA_SYNC_DMACSYNC1_Pos                              1
#define GPDMA_SYNC_DMACSYNC1_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC1_Pos)
#define GPDMA_SYNC_DMACSYNC2_Pos                              2
#define GPDMA_SYNC_DMACSYNC2_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC2_Pos)
#define GPDMA_SYNC_DMACSYNC3_Pos                              3
#define GPDMA_SYNC_DMACSYNC3_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC3_Pos)
#define GPDMA_SYNC_DMACSYNC4_Pos                              4
#define GPDMA_SYNC_DMACSYNC4_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC4_Pos)
#define GPDMA_SYNC_DMACSYNC5_Pos                              5
#define GPDMA_SYNC_DMACSYNC5_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC5_Pos)
#define GPDMA_SYNC_DMACSYNC6_Pos                              6
#define GPDMA_SYNC_DMACSYNC6_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC6_Pos)
#define GPDMA_SYNC_DMACSYNC7_Pos                              7
#define GPDMA_SYNC_DMACSYNC7_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC7_Pos)
#define GPDMA_SYNC_DMACSYNC8_Pos                              8
#define GPDMA_SYNC_DMACSYNC8_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC8_Pos)
#define GPDMA_SYNC_DMACSYNC9_Pos                              9
#define GPDMA_SYNC_DMACSYNC9_Msk                              (0x01UL << GPDMA_SYNC_DMACSYNC9_Pos)
#define GPDMA_SYNC_DMACSYNC10_Pos                             10
#define GPDMA_SYNC_DMACSYNC10_Msk                             (0x01UL << GPDMA_SYNC_DMACSYNC10_Pos)
#define GPDMA_SYNC_DMACSYNC11_Pos                             11
#define GPDMA_SYNC_DMACSYNC11_Msk                             (0x01UL << GPDMA_SYNC_DMACSYNC11_Pos)
#define GPDMA_SYNC_DMACSYNC12_Pos                             12
#define GPDMA_SYNC_DMACSYNC12_Msk                             (0x01UL << GPDMA_SYNC_DMACSYNC12_Pos)
#define GPDMA_SYNC_DMACSYNC13_Pos                             13
#define GPDMA_SYNC_DMACSYNC13_Msk                             (0x01UL << GPDMA_SYNC_DMACSYNC13_Pos)
#define GPDMA_SYNC_DMACSYNC14_Pos                             14
#define GPDMA_SYNC_DMACSYNC14_Msk                             (0x01UL << GPDMA_SYNC_DMACSYNC14_Pos)
#define GPDMA_SYNC_DMACSYNC15_Pos                             15
#define GPDMA_SYNC_DMACSYNC15_Msk                             (0x01UL << GPDMA_SYNC_DMACSYNC15_Pos)

// -------------------------------------  GPDMA_C0SRCADDR  ----------------------------------------
#define GPDMA_C0SRCADDR_SRCADDR_Pos                           0
#define GPDMA_C0SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C0SRCADDR_SRCADDR_Pos)

// ------------------------------------  GPDMA_C0DESTADDR  ----------------------------------------
#define GPDMA_C0DESTADDR_DESTADDR_Pos                         0
#define GPDMA_C0DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C0DESTADDR_DESTADDR_Pos)

// ---------------------------------------  GPDMA_C0LLI  ------------------------------------------
#define GPDMA_C0LLI_LM_Pos                                    0
#define GPDMA_C0LLI_LM_Msk                                    (0x01UL << GPDMA_C0LLI_LM_Pos)
#define GPDMA_C0LLI_R_Pos                                     1
#define GPDMA_C0LLI_R_Msk                                     (0x01UL << GPDMA_C0LLI_R_Pos)
#define GPDMA_C0LLI_LLI_Pos                                   2
#define GPDMA_C0LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C0LLI_LLI_Pos)

// -------------------------------------  GPDMA_C0CONTROL  ----------------------------------------
#define GPDMA_C0CONTROL_TRANSFERSIZE_Pos                      0
#define GPDMA_C0CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C0CONTROL_TRANSFERSIZE_Pos)
#define GPDMA_C0CONTROL_SBSIZE_Pos                            12
#define GPDMA_C0CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C0CONTROL_SBSIZE_Pos)
#define GPDMA_C0CONTROL_DBSIZE_Pos                            15
#define GPDMA_C0CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C0CONTROL_DBSIZE_Pos)
#define GPDMA_C0CONTROL_SWIDTH_Pos                            18
#define GPDMA_C0CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C0CONTROL_SWIDTH_Pos)
#define GPDMA_C0CONTROL_DWIDTH_Pos                            21
#define GPDMA_C0CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C0CONTROL_DWIDTH_Pos)
#define GPDMA_C0CONTROL_S_Pos                                 24
#define GPDMA_C0CONTROL_S_Msk                                 (0x01UL << GPDMA_C0CONTROL_S_Pos)
#define GPDMA_C0CONTROL_D_Pos                                 25
#define GPDMA_C0CONTROL_D_Msk                                 (0x01UL << GPDMA_C0CONTROL_D_Pos)
#define GPDMA_C0CONTROL_SI_Pos                                26
#define GPDMA_C0CONTROL_SI_Msk                                (0x01UL << GPDMA_C0CONTROL_SI_Pos)
#define GPDMA_C0CONTROL_DI_Pos                                27
#define GPDMA_C0CONTROL_DI_Msk                                (0x01UL << GPDMA_C0CONTROL_DI_Pos)
#define GPDMA_C0CONTROL_PROT1_Pos                             28
#define GPDMA_C0CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C0CONTROL_PROT1_Pos)
#define GPDMA_C0CONTROL_PROT2_Pos                             29
#define GPDMA_C0CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C0CONTROL_PROT2_Pos)
#define GPDMA_C0CONTROL_PROT3_Pos                             30
#define GPDMA_C0CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C0CONTROL_PROT3_Pos)
#define GPDMA_C0CONTROL_I_Pos                                 31
#define GPDMA_C0CONTROL_I_Msk                                 (0x01UL << GPDMA_C0CONTROL_I_Pos)

// -------------------------------------  GPDMA_C0CONFIG  -----------------------------------------
#define GPDMA_C0CONFIG_E_Pos                                  0
#define GPDMA_C0CONFIG_E_Msk                                  (0x01UL << GPDMA_C0CONFIG_E_Pos)
#define GPDMA_C0CONFIG_SRCPERIPHERAL_Pos                      1
#define GPDMA_C0CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C0CONFIG_SRCPERIPHERAL_Pos)
#define GPDMA_C0CONFIG_DESTPERIPHERAL_Pos                     6
#define GPDMA_C0CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C0CONFIG_DESTPERIPHERAL_Pos)
#define GPDMA_C0CONFIG_FLOWCNTRL_Pos                          11
#define GPDMA_C0CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C0CONFIG_FLOWCNTRL_Pos)
#define GPDMA_C0CONFIG_IE_Pos                                 14
#define GPDMA_C0CONFIG_IE_Msk                                 (0x01UL << GPDMA_C0CONFIG_IE_Pos)
#define GPDMA_C0CONFIG_ITC_Pos                                15
#define GPDMA_C0CONFIG_ITC_Msk                                (0x01UL << GPDMA_C0CONFIG_ITC_Pos)
#define GPDMA_C0CONFIG_L_Pos                                  16
#define GPDMA_C0CONFIG_L_Msk                                  (0x01UL << GPDMA_C0CONFIG_L_Pos)
#define GPDMA_C0CONFIG_A_Pos                                  17
#define GPDMA_C0CONFIG_A_Msk                                  (0x01UL << GPDMA_C0CONFIG_A_Pos)
#define GPDMA_C0CONFIG_H_Pos                                  18
#define GPDMA_C0CONFIG_H_Msk                                  (0x01UL << GPDMA_C0CONFIG_H_Pos)

// -------------------------------------  GPDMA_C1SRCADDR  ----------------------------------------
#define GPDMA_C1SRCADDR_SRCADDR_Pos                           0
#define GPDMA_C1SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C1SRCADDR_SRCADDR_Pos)

// ------------------------------------  GPDMA_C1DESTADDR  ----------------------------------------
#define GPDMA_C1DESTADDR_DESTADDR_Pos                         0
#define GPDMA_C1DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C1DESTADDR_DESTADDR_Pos)

// ---------------------------------------  GPDMA_C1LLI  ------------------------------------------
#define GPDMA_C1LLI_LM_Pos                                    0
#define GPDMA_C1LLI_LM_Msk                                    (0x01UL << GPDMA_C1LLI_LM_Pos)
#define GPDMA_C1LLI_R_Pos                                     1
#define GPDMA_C1LLI_R_Msk                                     (0x01UL << GPDMA_C1LLI_R_Pos)
#define GPDMA_C1LLI_LLI_Pos                                   2
#define GPDMA_C1LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C1LLI_LLI_Pos)

// -------------------------------------  GPDMA_C1CONTROL  ----------------------------------------
#define GPDMA_C1CONTROL_TRANSFERSIZE_Pos                      0
#define GPDMA_C1CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C1CONTROL_TRANSFERSIZE_Pos)
#define GPDMA_C1CONTROL_SBSIZE_Pos                            12
#define GPDMA_C1CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C1CONTROL_SBSIZE_Pos)
#define GPDMA_C1CONTROL_DBSIZE_Pos                            15
#define GPDMA_C1CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C1CONTROL_DBSIZE_Pos)
#define GPDMA_C1CONTROL_SWIDTH_Pos                            18
#define GPDMA_C1CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C1CONTROL_SWIDTH_Pos)
#define GPDMA_C1CONTROL_DWIDTH_Pos                            21
#define GPDMA_C1CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C1CONTROL_DWIDTH_Pos)
#define GPDMA_C1CONTROL_S_Pos                                 24
#define GPDMA_C1CONTROL_S_Msk                                 (0x01UL << GPDMA_C1CONTROL_S_Pos)
#define GPDMA_C1CONTROL_D_Pos                                 25
#define GPDMA_C1CONTROL_D_Msk                                 (0x01UL << GPDMA_C1CONTROL_D_Pos)
#define GPDMA_C1CONTROL_SI_Pos                                26
#define GPDMA_C1CONTROL_SI_Msk                                (0x01UL << GPDMA_C1CONTROL_SI_Pos)
#define GPDMA_C1CONTROL_DI_Pos                                27
#define GPDMA_C1CONTROL_DI_Msk                                (0x01UL << GPDMA_C1CONTROL_DI_Pos)
#define GPDMA_C1CONTROL_PROT1_Pos                             28
#define GPDMA_C1CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C1CONTROL_PROT1_Pos)
#define GPDMA_C1CONTROL_PROT2_Pos                             29
#define GPDMA_C1CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C1CONTROL_PROT2_Pos)
#define GPDMA_C1CONTROL_PROT3_Pos                             30
#define GPDMA_C1CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C1CONTROL_PROT3_Pos)
#define GPDMA_C1CONTROL_I_Pos                                 31
#define GPDMA_C1CONTROL_I_Msk                                 (0x01UL << GPDMA_C1CONTROL_I_Pos)

// -------------------------------------  GPDMA_C1CONFIG  -----------------------------------------
#define GPDMA_C1CONFIG_E_Pos                                  0
#define GPDMA_C1CONFIG_E_Msk                                  (0x01UL << GPDMA_C1CONFIG_E_Pos)
#define GPDMA_C1CONFIG_SRCPERIPHERAL_Pos                      1
#define GPDMA_C1CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C1CONFIG_SRCPERIPHERAL_Pos)
#define GPDMA_C1CONFIG_DESTPERIPHERAL_Pos                     6
#define GPDMA_C1CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C1CONFIG_DESTPERIPHERAL_Pos)
#define GPDMA_C1CONFIG_FLOWCNTRL_Pos                          11
#define GPDMA_C1CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C1CONFIG_FLOWCNTRL_Pos)
#define GPDMA_C1CONFIG_IE_Pos                                 14
#define GPDMA_C1CONFIG_IE_Msk                                 (0x01UL << GPDMA_C1CONFIG_IE_Pos)
#define GPDMA_C1CONFIG_ITC_Pos                                15
#define GPDMA_C1CONFIG_ITC_Msk                                (0x01UL << GPDMA_C1CONFIG_ITC_Pos)
#define GPDMA_C1CONFIG_L_Pos                                  16
#define GPDMA_C1CONFIG_L_Msk                                  (0x01UL << GPDMA_C1CONFIG_L_Pos)
#define GPDMA_C1CONFIG_A_Pos                                  17
#define GPDMA_C1CONFIG_A_Msk                                  (0x01UL << GPDMA_C1CONFIG_A_Pos)
#define GPDMA_C1CONFIG_H_Pos                                  18
#define GPDMA_C1CONFIG_H_Msk                                  (0x01UL << GPDMA_C1CONFIG_H_Pos)

// -------------------------------------  GPDMA_C2SRCADDR  ----------------------------------------
#define GPDMA_C2SRCADDR_SRCADDR_Pos                           0
#define GPDMA_C2SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C2SRCADDR_SRCADDR_Pos)

// ------------------------------------  GPDMA_C2DESTADDR  ----------------------------------------
#define GPDMA_C2DESTADDR_DESTADDR_Pos                         0
#define GPDMA_C2DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C2DESTADDR_DESTADDR_Pos)

// ---------------------------------------  GPDMA_C2LLI  ------------------------------------------
#define GPDMA_C2LLI_LM_Pos                                    0
#define GPDMA_C2LLI_LM_Msk                                    (0x01UL << GPDMA_C2LLI_LM_Pos)
#define GPDMA_C2LLI_R_Pos                                     1
#define GPDMA_C2LLI_R_Msk                                     (0x01UL << GPDMA_C2LLI_R_Pos)
#define GPDMA_C2LLI_LLI_Pos                                   2
#define GPDMA_C2LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C2LLI_LLI_Pos)

// -------------------------------------  GPDMA_C2CONTROL  ----------------------------------------
#define GPDMA_C2CONTROL_TRANSFERSIZE_Pos                      0
#define GPDMA_C2CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C2CONTROL_TRANSFERSIZE_Pos)
#define GPDMA_C2CONTROL_SBSIZE_Pos                            12
#define GPDMA_C2CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C2CONTROL_SBSIZE_Pos)
#define GPDMA_C2CONTROL_DBSIZE_Pos                            15
#define GPDMA_C2CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C2CONTROL_DBSIZE_Pos)
#define GPDMA_C2CONTROL_SWIDTH_Pos                            18
#define GPDMA_C2CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C2CONTROL_SWIDTH_Pos)
#define GPDMA_C2CONTROL_DWIDTH_Pos                            21
#define GPDMA_C2CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C2CONTROL_DWIDTH_Pos)
#define GPDMA_C2CONTROL_S_Pos                                 24
#define GPDMA_C2CONTROL_S_Msk                                 (0x01UL << GPDMA_C2CONTROL_S_Pos)
#define GPDMA_C2CONTROL_D_Pos                                 25
#define GPDMA_C2CONTROL_D_Msk                                 (0x01UL << GPDMA_C2CONTROL_D_Pos)
#define GPDMA_C2CONTROL_SI_Pos                                26
#define GPDMA_C2CONTROL_SI_Msk                                (0x01UL << GPDMA_C2CONTROL_SI_Pos)
#define GPDMA_C2CONTROL_DI_Pos                                27
#define GPDMA_C2CONTROL_DI_Msk                                (0x01UL << GPDMA_C2CONTROL_DI_Pos)
#define GPDMA_C2CONTROL_PROT1_Pos                             28
#define GPDMA_C2CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C2CONTROL_PROT1_Pos)
#define GPDMA_C2CONTROL_PROT2_Pos                             29
#define GPDMA_C2CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C2CONTROL_PROT2_Pos)
#define GPDMA_C2CONTROL_PROT3_Pos                             30
#define GPDMA_C2CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C2CONTROL_PROT3_Pos)
#define GPDMA_C2CONTROL_I_Pos                                 31
#define GPDMA_C2CONTROL_I_Msk                                 (0x01UL << GPDMA_C2CONTROL_I_Pos)

// -------------------------------------  GPDMA_C2CONFIG  -----------------------------------------
#define GPDMA_C2CONFIG_E_Pos                                  0
#define GPDMA_C2CONFIG_E_Msk                                  (0x01UL << GPDMA_C2CONFIG_E_Pos)
#define GPDMA_C2CONFIG_SRCPERIPHERAL_Pos                      1
#define GPDMA_C2CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C2CONFIG_SRCPERIPHERAL_Pos)
#define GPDMA_C2CONFIG_DESTPERIPHERAL_Pos                     6
#define GPDMA_C2CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C2CONFIG_DESTPERIPHERAL_Pos)
#define GPDMA_C2CONFIG_FLOWCNTRL_Pos                          11
#define GPDMA_C2CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C2CONFIG_FLOWCNTRL_Pos)
#define GPDMA_C2CONFIG_IE_Pos                                 14
#define GPDMA_C2CONFIG_IE_Msk                                 (0x01UL << GPDMA_C2CONFIG_IE_Pos)
#define GPDMA_C2CONFIG_ITC_Pos                                15
#define GPDMA_C2CONFIG_ITC_Msk                                (0x01UL << GPDMA_C2CONFIG_ITC_Pos)
#define GPDMA_C2CONFIG_L_Pos                                  16
#define GPDMA_C2CONFIG_L_Msk                                  (0x01UL << GPDMA_C2CONFIG_L_Pos)
#define GPDMA_C2CONFIG_A_Pos                                  17
#define GPDMA_C2CONFIG_A_Msk                                  (0x01UL << GPDMA_C2CONFIG_A_Pos)
#define GPDMA_C2CONFIG_H_Pos                                  18
#define GPDMA_C2CONFIG_H_Msk                                  (0x01UL << GPDMA_C2CONFIG_H_Pos)

// -------------------------------------  GPDMA_C3SRCADDR  ----------------------------------------
#define GPDMA_C3SRCADDR_SRCADDR_Pos                           0
#define GPDMA_C3SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C3SRCADDR_SRCADDR_Pos)

// ------------------------------------  GPDMA_C3DESTADDR  ----------------------------------------
#define GPDMA_C3DESTADDR_DESTADDR_Pos                         0
#define GPDMA_C3DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C3DESTADDR_DESTADDR_Pos)

// ---------------------------------------  GPDMA_C3LLI  ------------------------------------------
#define GPDMA_C3LLI_LM_Pos                                    0
#define GPDMA_C3LLI_LM_Msk                                    (0x01UL << GPDMA_C3LLI_LM_Pos)
#define GPDMA_C3LLI_R_Pos                                     1
#define GPDMA_C3LLI_R_Msk                                     (0x01UL << GPDMA_C3LLI_R_Pos)
#define GPDMA_C3LLI_LLI_Pos                                   2
#define GPDMA_C3LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C3LLI_LLI_Pos)

// -------------------------------------  GPDMA_C3CONTROL  ----------------------------------------
#define GPDMA_C3CONTROL_TRANSFERSIZE_Pos                      0
#define GPDMA_C3CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C3CONTROL_TRANSFERSIZE_Pos)
#define GPDMA_C3CONTROL_SBSIZE_Pos                            12
#define GPDMA_C3CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C3CONTROL_SBSIZE_Pos)
#define GPDMA_C3CONTROL_DBSIZE_Pos                            15
#define GPDMA_C3CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C3CONTROL_DBSIZE_Pos)
#define GPDMA_C3CONTROL_SWIDTH_Pos                            18
#define GPDMA_C3CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C3CONTROL_SWIDTH_Pos)
#define GPDMA_C3CONTROL_DWIDTH_Pos                            21
#define GPDMA_C3CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C3CONTROL_DWIDTH_Pos)
#define GPDMA_C3CONTROL_S_Pos                                 24
#define GPDMA_C3CONTROL_S_Msk                                 (0x01UL << GPDMA_C3CONTROL_S_Pos)
#define GPDMA_C3CONTROL_D_Pos                                 25
#define GPDMA_C3CONTROL_D_Msk                                 (0x01UL << GPDMA_C3CONTROL_D_Pos)
#define GPDMA_C3CONTROL_SI_Pos                                26
#define GPDMA_C3CONTROL_SI_Msk                                (0x01UL << GPDMA_C3CONTROL_SI_Pos)
#define GPDMA_C3CONTROL_DI_Pos                                27
#define GPDMA_C3CONTROL_DI_Msk                                (0x01UL << GPDMA_C3CONTROL_DI_Pos)
#define GPDMA_C3CONTROL_PROT1_Pos                             28
#define GPDMA_C3CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C3CONTROL_PROT1_Pos)
#define GPDMA_C3CONTROL_PROT2_Pos                             29
#define GPDMA_C3CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C3CONTROL_PROT2_Pos)
#define GPDMA_C3CONTROL_PROT3_Pos                             30
#define GPDMA_C3CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C3CONTROL_PROT3_Pos)
#define GPDMA_C3CONTROL_I_Pos                                 31
#define GPDMA_C3CONTROL_I_Msk                                 (0x01UL << GPDMA_C3CONTROL_I_Pos)

// -------------------------------------  GPDMA_C3CONFIG  -----------------------------------------
#define GPDMA_C3CONFIG_E_Pos                                  0
#define GPDMA_C3CONFIG_E_Msk                                  (0x01UL << GPDMA_C3CONFIG_E_Pos)
#define GPDMA_C3CONFIG_SRCPERIPHERAL_Pos                      1
#define GPDMA_C3CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C3CONFIG_SRCPERIPHERAL_Pos)
#define GPDMA_C3CONFIG_DESTPERIPHERAL_Pos                     6
#define GPDMA_C3CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C3CONFIG_DESTPERIPHERAL_Pos)
#define GPDMA_C3CONFIG_FLOWCNTRL_Pos                          11
#define GPDMA_C3CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C3CONFIG_FLOWCNTRL_Pos)
#define GPDMA_C3CONFIG_IE_Pos                                 14
#define GPDMA_C3CONFIG_IE_Msk                                 (0x01UL << GPDMA_C3CONFIG_IE_Pos)
#define GPDMA_C3CONFIG_ITC_Pos                                15
#define GPDMA_C3CONFIG_ITC_Msk                                (0x01UL << GPDMA_C3CONFIG_ITC_Pos)
#define GPDMA_C3CONFIG_L_Pos                                  16
#define GPDMA_C3CONFIG_L_Msk                                  (0x01UL << GPDMA_C3CONFIG_L_Pos)
#define GPDMA_C3CONFIG_A_Pos                                  17
#define GPDMA_C3CONFIG_A_Msk                                  (0x01UL << GPDMA_C3CONFIG_A_Pos)
#define GPDMA_C3CONFIG_H_Pos                                  18
#define GPDMA_C3CONFIG_H_Msk                                  (0x01UL << GPDMA_C3CONFIG_H_Pos)

// -------------------------------------  GPDMA_C4SRCADDR  ----------------------------------------
#define GPDMA_C4SRCADDR_SRCADDR_Pos                           0
#define GPDMA_C4SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C4SRCADDR_SRCADDR_Pos)

// ------------------------------------  GPDMA_C4DESTADDR  ----------------------------------------
#define GPDMA_C4DESTADDR_DESTADDR_Pos                         0
#define GPDMA_C4DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C4DESTADDR_DESTADDR_Pos)

// ---------------------------------------  GPDMA_C4LLI  ------------------------------------------
#define GPDMA_C4LLI_LM_Pos                                    0
#define GPDMA_C4LLI_LM_Msk                                    (0x01UL << GPDMA_C4LLI_LM_Pos)
#define GPDMA_C4LLI_R_Pos                                     1
#define GPDMA_C4LLI_R_Msk                                     (0x01UL << GPDMA_C4LLI_R_Pos)
#define GPDMA_C4LLI_LLI_Pos                                   2
#define GPDMA_C4LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C4LLI_LLI_Pos)

// -------------------------------------  GPDMA_C4CONTROL  ----------------------------------------
#define GPDMA_C4CONTROL_TRANSFERSIZE_Pos                      0
#define GPDMA_C4CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C4CONTROL_TRANSFERSIZE_Pos)
#define GPDMA_C4CONTROL_SBSIZE_Pos                            12
#define GPDMA_C4CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C4CONTROL_SBSIZE_Pos)
#define GPDMA_C4CONTROL_DBSIZE_Pos                            15
#define GPDMA_C4CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C4CONTROL_DBSIZE_Pos)
#define GPDMA_C4CONTROL_SWIDTH_Pos                            18
#define GPDMA_C4CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C4CONTROL_SWIDTH_Pos)
#define GPDMA_C4CONTROL_DWIDTH_Pos                            21
#define GPDMA_C4CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C4CONTROL_DWIDTH_Pos)
#define GPDMA_C4CONTROL_S_Pos                                 24
#define GPDMA_C4CONTROL_S_Msk                                 (0x01UL << GPDMA_C4CONTROL_S_Pos)
#define GPDMA_C4CONTROL_D_Pos                                 25
#define GPDMA_C4CONTROL_D_Msk                                 (0x01UL << GPDMA_C4CONTROL_D_Pos)
#define GPDMA_C4CONTROL_SI_Pos                                26
#define GPDMA_C4CONTROL_SI_Msk                                (0x01UL << GPDMA_C4CONTROL_SI_Pos)
#define GPDMA_C4CONTROL_DI_Pos                                27
#define GPDMA_C4CONTROL_DI_Msk                                (0x01UL << GPDMA_C4CONTROL_DI_Pos)
#define GPDMA_C4CONTROL_PROT1_Pos                             28
#define GPDMA_C4CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C4CONTROL_PROT1_Pos)
#define GPDMA_C4CONTROL_PROT2_Pos                             29
#define GPDMA_C4CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C4CONTROL_PROT2_Pos)
#define GPDMA_C4CONTROL_PROT3_Pos                             30
#define GPDMA_C4CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C4CONTROL_PROT3_Pos)
#define GPDMA_C4CONTROL_I_Pos                                 31
#define GPDMA_C4CONTROL_I_Msk                                 (0x01UL << GPDMA_C4CONTROL_I_Pos)

// -------------------------------------  GPDMA_C4CONFIG  -----------------------------------------
#define GPDMA_C4CONFIG_E_Pos                                  0
#define GPDMA_C4CONFIG_E_Msk                                  (0x01UL << GPDMA_C4CONFIG_E_Pos)
#define GPDMA_C4CONFIG_SRCPERIPHERAL_Pos                      1
#define GPDMA_C4CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C4CONFIG_SRCPERIPHERAL_Pos)
#define GPDMA_C4CONFIG_DESTPERIPHERAL_Pos                     6
#define GPDMA_C4CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C4CONFIG_DESTPERIPHERAL_Pos)
#define GPDMA_C4CONFIG_FLOWCNTRL_Pos                          11
#define GPDMA_C4CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C4CONFIG_FLOWCNTRL_Pos)
#define GPDMA_C4CONFIG_IE_Pos                                 14
#define GPDMA_C4CONFIG_IE_Msk                                 (0x01UL << GPDMA_C4CONFIG_IE_Pos)
#define GPDMA_C4CONFIG_ITC_Pos                                15
#define GPDMA_C4CONFIG_ITC_Msk                                (0x01UL << GPDMA_C4CONFIG_ITC_Pos)
#define GPDMA_C4CONFIG_L_Pos                                  16
#define GPDMA_C4CONFIG_L_Msk                                  (0x01UL << GPDMA_C4CONFIG_L_Pos)
#define GPDMA_C4CONFIG_A_Pos                                  17
#define GPDMA_C4CONFIG_A_Msk                                  (0x01UL << GPDMA_C4CONFIG_A_Pos)
#define GPDMA_C4CONFIG_H_Pos                                  18
#define GPDMA_C4CONFIG_H_Msk                                  (0x01UL << GPDMA_C4CONFIG_H_Pos)

// -------------------------------------  GPDMA_C5SRCADDR  ----------------------------------------
#define GPDMA_C5SRCADDR_SRCADDR_Pos                           0
#define GPDMA_C5SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C5SRCADDR_SRCADDR_Pos)

// ------------------------------------  GPDMA_C5DESTADDR  ----------------------------------------
#define GPDMA_C5DESTADDR_DESTADDR_Pos                         0
#define GPDMA_C5DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C5DESTADDR_DESTADDR_Pos)

// ---------------------------------------  GPDMA_C5LLI  ------------------------------------------
#define GPDMA_C5LLI_LM_Pos                                    0
#define GPDMA_C5LLI_LM_Msk                                    (0x01UL << GPDMA_C5LLI_LM_Pos)
#define GPDMA_C5LLI_R_Pos                                     1
#define GPDMA_C5LLI_R_Msk                                     (0x01UL << GPDMA_C5LLI_R_Pos)
#define GPDMA_C5LLI_LLI_Pos                                   2
#define GPDMA_C5LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C5LLI_LLI_Pos)

// -------------------------------------  GPDMA_C5CONTROL  ----------------------------------------
#define GPDMA_C5CONTROL_TRANSFERSIZE_Pos                      0
#define GPDMA_C5CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C5CONTROL_TRANSFERSIZE_Pos)
#define GPDMA_C5CONTROL_SBSIZE_Pos                            12
#define GPDMA_C5CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C5CONTROL_SBSIZE_Pos)
#define GPDMA_C5CONTROL_DBSIZE_Pos                            15
#define GPDMA_C5CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C5CONTROL_DBSIZE_Pos)
#define GPDMA_C5CONTROL_SWIDTH_Pos                            18
#define GPDMA_C5CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C5CONTROL_SWIDTH_Pos)
#define GPDMA_C5CONTROL_DWIDTH_Pos                            21
#define GPDMA_C5CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C5CONTROL_DWIDTH_Pos)
#define GPDMA_C5CONTROL_S_Pos                                 24
#define GPDMA_C5CONTROL_S_Msk                                 (0x01UL << GPDMA_C5CONTROL_S_Pos)
#define GPDMA_C5CONTROL_D_Pos                                 25
#define GPDMA_C5CONTROL_D_Msk                                 (0x01UL << GPDMA_C5CONTROL_D_Pos)
#define GPDMA_C5CONTROL_SI_Pos                                26
#define GPDMA_C5CONTROL_SI_Msk                                (0x01UL << GPDMA_C5CONTROL_SI_Pos)
#define GPDMA_C5CONTROL_DI_Pos                                27
#define GPDMA_C5CONTROL_DI_Msk                                (0x01UL << GPDMA_C5CONTROL_DI_Pos)
#define GPDMA_C5CONTROL_PROT1_Pos                             28
#define GPDMA_C5CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C5CONTROL_PROT1_Pos)
#define GPDMA_C5CONTROL_PROT2_Pos                             29
#define GPDMA_C5CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C5CONTROL_PROT2_Pos)
#define GPDMA_C5CONTROL_PROT3_Pos                             30
#define GPDMA_C5CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C5CONTROL_PROT3_Pos)
#define GPDMA_C5CONTROL_I_Pos                                 31
#define GPDMA_C5CONTROL_I_Msk                                 (0x01UL << GPDMA_C5CONTROL_I_Pos)

// -------------------------------------  GPDMA_C5CONFIG  -----------------------------------------
#define GPDMA_C5CONFIG_E_Pos                                  0
#define GPDMA_C5CONFIG_E_Msk                                  (0x01UL << GPDMA_C5CONFIG_E_Pos)
#define GPDMA_C5CONFIG_SRCPERIPHERAL_Pos                      1
#define GPDMA_C5CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C5CONFIG_SRCPERIPHERAL_Pos)
#define GPDMA_C5CONFIG_DESTPERIPHERAL_Pos                     6
#define GPDMA_C5CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C5CONFIG_DESTPERIPHERAL_Pos)
#define GPDMA_C5CONFIG_FLOWCNTRL_Pos                          11
#define GPDMA_C5CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C5CONFIG_FLOWCNTRL_Pos)
#define GPDMA_C5CONFIG_IE_Pos                                 14
#define GPDMA_C5CONFIG_IE_Msk                                 (0x01UL << GPDMA_C5CONFIG_IE_Pos)
#define GPDMA_C5CONFIG_ITC_Pos                                15
#define GPDMA_C5CONFIG_ITC_Msk                                (0x01UL << GPDMA_C5CONFIG_ITC_Pos)
#define GPDMA_C5CONFIG_L_Pos                                  16
#define GPDMA_C5CONFIG_L_Msk                                  (0x01UL << GPDMA_C5CONFIG_L_Pos)
#define GPDMA_C5CONFIG_A_Pos                                  17
#define GPDMA_C5CONFIG_A_Msk                                  (0x01UL << GPDMA_C5CONFIG_A_Pos)
#define GPDMA_C5CONFIG_H_Pos                                  18
#define GPDMA_C5CONFIG_H_Msk                                  (0x01UL << GPDMA_C5CONFIG_H_Pos)

// -------------------------------------  GPDMA_C6SRCADDR  ----------------------------------------
#define GPDMA_C6SRCADDR_SRCADDR_Pos                           0
#define GPDMA_C6SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C6SRCADDR_SRCADDR_Pos)

// ------------------------------------  GPDMA_C6DESTADDR  ----------------------------------------
#define GPDMA_C6DESTADDR_DESTADDR_Pos                         0
#define GPDMA_C6DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C6DESTADDR_DESTADDR_Pos)

// ---------------------------------------  GPDMA_C6LLI  ------------------------------------------
#define GPDMA_C6LLI_LM_Pos                                    0
#define GPDMA_C6LLI_LM_Msk                                    (0x01UL << GPDMA_C6LLI_LM_Pos)
#define GPDMA_C6LLI_R_Pos                                     1
#define GPDMA_C6LLI_R_Msk                                     (0x01UL << GPDMA_C6LLI_R_Pos)
#define GPDMA_C6LLI_LLI_Pos                                   2
#define GPDMA_C6LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C6LLI_LLI_Pos)

// -------------------------------------  GPDMA_C6CONTROL  ----------------------------------------
#define GPDMA_C6CONTROL_TRANSFERSIZE_Pos                      0
#define GPDMA_C6CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C6CONTROL_TRANSFERSIZE_Pos)
#define GPDMA_C6CONTROL_SBSIZE_Pos                            12
#define GPDMA_C6CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C6CONTROL_SBSIZE_Pos)
#define GPDMA_C6CONTROL_DBSIZE_Pos                            15
#define GPDMA_C6CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C6CONTROL_DBSIZE_Pos)
#define GPDMA_C6CONTROL_SWIDTH_Pos                            18
#define GPDMA_C6CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C6CONTROL_SWIDTH_Pos)
#define GPDMA_C6CONTROL_DWIDTH_Pos                            21
#define GPDMA_C6CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C6CONTROL_DWIDTH_Pos)
#define GPDMA_C6CONTROL_S_Pos                                 24
#define GPDMA_C6CONTROL_S_Msk                                 (0x01UL << GPDMA_C6CONTROL_S_Pos)
#define GPDMA_C6CONTROL_D_Pos                                 25
#define GPDMA_C6CONTROL_D_Msk                                 (0x01UL << GPDMA_C6CONTROL_D_Pos)
#define GPDMA_C6CONTROL_SI_Pos                                26
#define GPDMA_C6CONTROL_SI_Msk                                (0x01UL << GPDMA_C6CONTROL_SI_Pos)
#define GPDMA_C6CONTROL_DI_Pos                                27
#define GPDMA_C6CONTROL_DI_Msk                                (0x01UL << GPDMA_C6CONTROL_DI_Pos)
#define GPDMA_C6CONTROL_PROT1_Pos                             28
#define GPDMA_C6CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C6CONTROL_PROT1_Pos)
#define GPDMA_C6CONTROL_PROT2_Pos                             29
#define GPDMA_C6CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C6CONTROL_PROT2_Pos)
#define GPDMA_C6CONTROL_PROT3_Pos                             30
#define GPDMA_C6CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C6CONTROL_PROT3_Pos)
#define GPDMA_C6CONTROL_I_Pos                                 31
#define GPDMA_C6CONTROL_I_Msk                                 (0x01UL << GPDMA_C6CONTROL_I_Pos)

// -------------------------------------  GPDMA_C6CONFIG  -----------------------------------------
#define GPDMA_C6CONFIG_E_Pos                                  0
#define GPDMA_C6CONFIG_E_Msk                                  (0x01UL << GPDMA_C6CONFIG_E_Pos)
#define GPDMA_C6CONFIG_SRCPERIPHERAL_Pos                      1
#define GPDMA_C6CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C6CONFIG_SRCPERIPHERAL_Pos)
#define GPDMA_C6CONFIG_DESTPERIPHERAL_Pos                     6
#define GPDMA_C6CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C6CONFIG_DESTPERIPHERAL_Pos)
#define GPDMA_C6CONFIG_FLOWCNTRL_Pos                          11
#define GPDMA_C6CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C6CONFIG_FLOWCNTRL_Pos)
#define GPDMA_C6CONFIG_IE_Pos                                 14
#define GPDMA_C6CONFIG_IE_Msk                                 (0x01UL << GPDMA_C6CONFIG_IE_Pos)
#define GPDMA_C6CONFIG_ITC_Pos                                15
#define GPDMA_C6CONFIG_ITC_Msk                                (0x01UL << GPDMA_C6CONFIG_ITC_Pos)
#define GPDMA_C6CONFIG_L_Pos                                  16
#define GPDMA_C6CONFIG_L_Msk                                  (0x01UL << GPDMA_C6CONFIG_L_Pos)
#define GPDMA_C6CONFIG_A_Pos                                  17
#define GPDMA_C6CONFIG_A_Msk                                  (0x01UL << GPDMA_C6CONFIG_A_Pos)
#define GPDMA_C6CONFIG_H_Pos                                  18
#define GPDMA_C6CONFIG_H_Msk                                  (0x01UL << GPDMA_C6CONFIG_H_Pos)

// -------------------------------------  GPDMA_C7SRCADDR  ----------------------------------------
#define GPDMA_C7SRCADDR_SRCADDR_Pos                           0
#define GPDMA_C7SRCADDR_SRCADDR_Msk                           (0xffffffffUL << GPDMA_C7SRCADDR_SRCADDR_Pos)

// ------------------------------------  GPDMA_C7DESTADDR  ----------------------------------------
#define GPDMA_C7DESTADDR_DESTADDR_Pos                         0
#define GPDMA_C7DESTADDR_DESTADDR_Msk                         (0xffffffffUL << GPDMA_C7DESTADDR_DESTADDR_Pos)

// ---------------------------------------  GPDMA_C7LLI  ------------------------------------------
#define GPDMA_C7LLI_LM_Pos                                    0
#define GPDMA_C7LLI_LM_Msk                                    (0x01UL << GPDMA_C7LLI_LM_Pos)
#define GPDMA_C7LLI_R_Pos                                     1
#define GPDMA_C7LLI_R_Msk                                     (0x01UL << GPDMA_C7LLI_R_Pos)
#define GPDMA_C7LLI_LLI_Pos                                   2
#define GPDMA_C7LLI_LLI_Msk                                   (0x3fffffffUL << GPDMA_C7LLI_LLI_Pos)

// -------------------------------------  GPDMA_C7CONTROL  ----------------------------------------
#define GPDMA_C7CONTROL_TRANSFERSIZE_Pos                      0
#define GPDMA_C7CONTROL_TRANSFERSIZE_Msk                      (0x00000fffUL << GPDMA_C7CONTROL_TRANSFERSIZE_Pos)
#define GPDMA_C7CONTROL_SBSIZE_Pos                            12
#define GPDMA_C7CONTROL_SBSIZE_Msk                            (0x07UL << GPDMA_C7CONTROL_SBSIZE_Pos)
#define GPDMA_C7CONTROL_DBSIZE_Pos                            15
#define GPDMA_C7CONTROL_DBSIZE_Msk                            (0x07UL << GPDMA_C7CONTROL_DBSIZE_Pos)
#define GPDMA_C7CONTROL_SWIDTH_Pos                            18
#define GPDMA_C7CONTROL_SWIDTH_Msk                            (0x07UL << GPDMA_C7CONTROL_SWIDTH_Pos)
#define GPDMA_C7CONTROL_DWIDTH_Pos                            21
#define GPDMA_C7CONTROL_DWIDTH_Msk                            (0x07UL << GPDMA_C7CONTROL_DWIDTH_Pos)
#define GPDMA_C7CONTROL_S_Pos                                 24
#define GPDMA_C7CONTROL_S_Msk                                 (0x01UL << GPDMA_C7CONTROL_S_Pos)
#define GPDMA_C7CONTROL_D_Pos                                 25
#define GPDMA_C7CONTROL_D_Msk                                 (0x01UL << GPDMA_C7CONTROL_D_Pos)
#define GPDMA_C7CONTROL_SI_Pos                                26
#define GPDMA_C7CONTROL_SI_Msk                                (0x01UL << GPDMA_C7CONTROL_SI_Pos)
#define GPDMA_C7CONTROL_DI_Pos                                27
#define GPDMA_C7CONTROL_DI_Msk                                (0x01UL << GPDMA_C7CONTROL_DI_Pos)
#define GPDMA_C7CONTROL_PROT1_Pos                             28
#define GPDMA_C7CONTROL_PROT1_Msk                             (0x01UL << GPDMA_C7CONTROL_PROT1_Pos)
#define GPDMA_C7CONTROL_PROT2_Pos                             29
#define GPDMA_C7CONTROL_PROT2_Msk                             (0x01UL << GPDMA_C7CONTROL_PROT2_Pos)
#define GPDMA_C7CONTROL_PROT3_Pos                             30
#define GPDMA_C7CONTROL_PROT3_Msk                             (0x01UL << GPDMA_C7CONTROL_PROT3_Pos)
#define GPDMA_C7CONTROL_I_Pos                                 31
#define GPDMA_C7CONTROL_I_Msk                                 (0x01UL << GPDMA_C7CONTROL_I_Pos)

// -------------------------------------  GPDMA_C7CONFIG  -----------------------------------------
#define GPDMA_C7CONFIG_E_Pos                                  0
#define GPDMA_C7CONFIG_E_Msk                                  (0x01UL << GPDMA_C7CONFIG_E_Pos)
#define GPDMA_C7CONFIG_SRCPERIPHERAL_Pos                      1
#define GPDMA_C7CONFIG_SRCPERIPHERAL_Msk                      (0x1fUL << GPDMA_C7CONFIG_SRCPERIPHERAL_Pos)
#define GPDMA_C7CONFIG_DESTPERIPHERAL_Pos                     6
#define GPDMA_C7CONFIG_DESTPERIPHERAL_Msk                     (0x1fUL << GPDMA_C7CONFIG_DESTPERIPHERAL_Pos)
#define GPDMA_C7CONFIG_FLOWCNTRL_Pos                          11
#define GPDMA_C7CONFIG_FLOWCNTRL_Msk                          (0x07UL << GPDMA_C7CONFIG_FLOWCNTRL_Pos)
#define GPDMA_C7CONFIG_IE_Pos                                 14
#define GPDMA_C7CONFIG_IE_Msk                                 (0x01UL << GPDMA_C7CONFIG_IE_Pos)
#define GPDMA_C7CONFIG_ITC_Pos                                15
#define GPDMA_C7CONFIG_ITC_Msk                                (0x01UL << GPDMA_C7CONFIG_ITC_Pos)
#define GPDMA_C7CONFIG_L_Pos                                  16
#define GPDMA_C7CONFIG_L_Msk                                  (0x01UL << GPDMA_C7CONFIG_L_Pos)
#define GPDMA_C7CONFIG_A_Pos                                  17
#define GPDMA_C7CONFIG_A_Msk                                  (0x01UL << GPDMA_C7CONFIG_A_Pos)
#define GPDMA_C7CONFIG_H_Pos                                  18
#define GPDMA_C7CONFIG_H_Msk                                  (0x01UL << GPDMA_C7CONFIG_H_Pos)


// ------------------------------------------------------------------------------------------------
// -----                                 SDMMC Position & Mask                                -----
// ------------------------------------------------------------------------------------------------


// ---------------------------------------  SDMMC_CTRL  -------------------------------------------
#define SDMMC_CTRL_CONTROLLER_RESET_Pos                       0
#define SDMMC_CTRL_CONTROLLER_RESET_Msk                       (0x01UL << SDMMC_CTRL_CONTROLLER_RESET_Pos)
#define SDMMC_CTRL_FIFO_RESET_Pos                             1
#define SDMMC_CTRL_FIFO_RESET_Msk                             (0x01UL << SDMMC_CTRL_FIFO_RESET_Pos)
#define SDMMC_CTRL_DMA_RESET_Pos                              2
#define SDMMC_CTRL_DMA_RESET_Msk                              (0x01UL << SDMMC_CTRL_DMA_RESET_Pos)
#define SDMMC_CTRL_INT_ENABLE_Pos                             4
#define SDMMC_CTRL_INT_ENABLE_Msk                             (0x01UL << SDMMC_CTRL_INT_ENABLE_Pos)
#define SDMMC_CTRL_DMA_ENABLE_Pos                             5
#define SDMMC_CTRL_DMA_ENABLE_Msk                             (0x01UL << SDMMC_CTRL_DMA_ENABLE_Pos)
#define SDMMC_CTRL_READ_WAIT_Pos                              6
#define SDMMC_CTRL_READ_WAIT_Msk                              (0x01UL << SDMMC_CTRL_READ_WAIT_Pos)
#define SDMMC_CTRL_SEND_IRQ_RESPONSE_Pos                      7
#define SDMMC_CTRL_SEND_IRQ_RESPONSE_Msk                      (0x01UL << SDMMC_CTRL_SEND_IRQ_RESPONSE_Pos)
#define SDMMC_CTRL_ABORT_READ_DATA_Pos                        8
#define SDMMC_CTRL_ABORT_READ_DATA_Msk                        (0x01UL << SDMMC_CTRL_ABORT_READ_DATA_Pos)
#define SDMMC_CTRL_SEND_CCSD_Pos                              9
#define SDMMC_CTRL_SEND_CCSD_Msk                              (0x01UL << SDMMC_CTRL_SEND_CCSD_Pos)
#define SDMMC_CTRL_SEND_AUTO_STOP_CCSD_Pos                    10
#define SDMMC_CTRL_SEND_AUTO_STOP_CCSD_Msk                    (0x01UL << SDMMC_CTRL_SEND_AUTO_STOP_CCSD_Pos)
#define SDMMC_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_Pos          11
#define SDMMC_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_Msk          (0x01UL << SDMMC_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_Pos)
#define SDMMC_CTRL_CARD_VOLTAGE_A_Pos                         16
#define SDMMC_CTRL_CARD_VOLTAGE_A_Msk                         (0x0fUL << SDMMC_CTRL_CARD_VOLTAGE_A_Pos)
#define SDMMC_CTRL_CARD_VOLTAGE_B_Pos                         20
#define SDMMC_CTRL_CARD_VOLTAGE_B_Msk                         (0x0fUL << SDMMC_CTRL_CARD_VOLTAGE_B_Pos)
#define SDMMC_CTRL_ENABLE_OD_PULLUP_Pos                       24
#define SDMMC_CTRL_ENABLE_OD_PULLUP_Msk                       (0x01UL << SDMMC_CTRL_ENABLE_OD_PULLUP_Pos)
#define SDMMC_CTRL_USE_INTERNAL_DMAC_Pos                      25
#define SDMMC_CTRL_USE_INTERNAL_DMAC_Msk                      (0x01UL << SDMMC_CTRL_USE_INTERNAL_DMAC_Pos)

// ---------------------------------------  SDMMC_PWREN  ------------------------------------------
#define SDMMC_PWREN_POWER_ENABLE_Pos                          0
#define SDMMC_PWREN_POWER_ENABLE_Msk                          (0x3fffffffUL << SDMMC_PWREN_POWER_ENABLE_Pos)

// --------------------------------------  SDMMC_CLKDIV  ------------------------------------------
#define SDMMC_CLKDIV_CLK_DIVIDER0_Pos                         0
#define SDMMC_CLKDIV_CLK_DIVIDER0_Msk                         (0x000000ffUL << SDMMC_CLKDIV_CLK_DIVIDER0_Pos)
#define SDMMC_CLKDIV_CLK_DIVIDER1_Pos                         8
#define SDMMC_CLKDIV_CLK_DIVIDER1_Msk                         (0x000000ffUL << SDMMC_CLKDIV_CLK_DIVIDER1_Pos)
#define SDMMC_CLKDIV_CLK_DIVIDER2_Pos                         16
#define SDMMC_CLKDIV_CLK_DIVIDER2_Msk                         (0x000000ffUL << SDMMC_CLKDIV_CLK_DIVIDER2_Pos)
#define SDMMC_CLKDIV_CLK_DIVIDER3_Pos                         24
#define SDMMC_CLKDIV_CLK_DIVIDER3_Msk                         (0x000000ffUL << SDMMC_CLKDIV_CLK_DIVIDER3_Pos)

// --------------------------------------  SDMMC_CLKSRC  ------------------------------------------
#define SDMMC_CLKSRC_CLK_SOURCE_Pos                           0
#define SDMMC_CLKSRC_CLK_SOURCE_Msk                           (0xffffffffUL << SDMMC_CLKSRC_CLK_SOURCE_Pos)

// --------------------------------------  SDMMC_CLKENA  ------------------------------------------
#define SDMMC_CLKENA_CCLK_ENABLE_Pos                          0
#define SDMMC_CLKENA_CCLK_ENABLE_Msk                          (0x0000ffffUL << SDMMC_CLKENA_CCLK_ENABLE_Pos)
#define SDMMC_CLKENA_CCLK_LOW_POWER_Pos                       16
#define SDMMC_CLKENA_CCLK_LOW_POWER_Msk                       (0x0000ffffUL << SDMMC_CLKENA_CCLK_LOW_POWER_Pos)

// ---------------------------------------  SDMMC_TMOUT  ------------------------------------------
#define SDMMC_TMOUT_RESPONSE_TIMEOUT_Pos                      0
#define SDMMC_TMOUT_RESPONSE_TIMEOUT_Msk                      (0x000000ffUL << SDMMC_TMOUT_RESPONSE_TIMEOUT_Pos)
#define SDMMC_TMOUT_DATA_TIMEOUT_Pos                          8
#define SDMMC_TMOUT_DATA_TIMEOUT_Msk                          (0x00ffffffUL << SDMMC_TMOUT_DATA_TIMEOUT_Pos)

// ---------------------------------------  SDMMC_CTYPE  ------------------------------------------
#define SDMMC_CTYPE_CARD_WIDTH0_Pos                           0
#define SDMMC_CTYPE_CARD_WIDTH0_Msk                           (0x0000ffffUL << SDMMC_CTYPE_CARD_WIDTH0_Pos)
#define SDMMC_CTYPE_CARD_WIDTH1_Pos                           16
#define SDMMC_CTYPE_CARD_WIDTH1_Msk                           (0x0000ffffUL << SDMMC_CTYPE_CARD_WIDTH1_Pos)

// --------------------------------------  SDMMC_BLKSIZ  ------------------------------------------
#define SDMMC_BLKSIZ_BLOCK_SIZE_Pos                           0
#define SDMMC_BLKSIZ_BLOCK_SIZE_Msk                           (0x0000ffffUL << SDMMC_BLKSIZ_BLOCK_SIZE_Pos)

// --------------------------------------  SDMMC_BYTCNT  ------------------------------------------
#define SDMMC_BYTCNT_BYTE_COUNT_Pos                           0
#define SDMMC_BYTCNT_BYTE_COUNT_Msk                           (0xffffffffUL << SDMMC_BYTCNT_BYTE_COUNT_Pos)

// --------------------------------------  SDMMC_INTMASK  -----------------------------------------
#define SDMMC_INTMASK_CDET_Pos                                0
#define SDMMC_INTMASK_CDET_Msk                                (0x01UL << SDMMC_INTMASK_CDET_Pos)
#define SDMMC_INTMASK_RE_Pos                                  1
#define SDMMC_INTMASK_RE_Msk                                  (0x01UL << SDMMC_INTMASK_RE_Pos)
#define SDMMC_INTMASK_CDONE_Pos                               2
#define SDMMC_INTMASK_CDONE_Msk                               (0x01UL << SDMMC_INTMASK_CDONE_Pos)
#define SDMMC_INTMASK_DTO_Pos                                 3
#define SDMMC_INTMASK_DTO_Msk                                 (0x01UL << SDMMC_INTMASK_DTO_Pos)
#define SDMMC_INTMASK_TXDR_Pos                                4
#define SDMMC_INTMASK_TXDR_Msk                                (0x01UL << SDMMC_INTMASK_TXDR_Pos)
#define SDMMC_INTMASK_RXDR_Pos                                5
#define SDMMC_INTMASK_RXDR_Msk                                (0x01UL << SDMMC_INTMASK_RXDR_Pos)
#define SDMMC_INTMASK_RCRC_Pos                                6
#define SDMMC_INTMASK_RCRC_Msk                                (0x01UL << SDMMC_INTMASK_RCRC_Pos)
#define SDMMC_INTMASK_DCRC_Pos                                7
#define SDMMC_INTMASK_DCRC_Msk                                (0x01UL << SDMMC_INTMASK_DCRC_Pos)
#define SDMMC_INTMASK_RTO_Pos                                 8
#define SDMMC_INTMASK_RTO_Msk                                 (0x01UL << SDMMC_INTMASK_RTO_Pos)
#define SDMMC_INTMASK_DRTO_Pos                                9
#define SDMMC_INTMASK_DRTO_Msk                                (0x01UL << SDMMC_INTMASK_DRTO_Pos)
#define SDMMC_INTMASK_HTO_Pos                                 10
#define SDMMC_INTMASK_HTO_Msk                                 (0x01UL << SDMMC_INTMASK_HTO_Pos)
#define SDMMC_INTMASK_FRUN_Pos                                11
#define SDMMC_INTMASK_FRUN_Msk                                (0x01UL << SDMMC_INTMASK_FRUN_Pos)
#define SDMMC_INTMASK_HLE_Pos                                 12
#define SDMMC_INTMASK_HLE_Msk                                 (0x01UL << SDMMC_INTMASK_HLE_Pos)
#define SDMMC_INTMASK_SBE_Pos                                 13
#define SDMMC_INTMASK_SBE_Msk                                 (0x01UL << SDMMC_INTMASK_SBE_Pos)
#define SDMMC_INTMASK_ACD_Pos                                 14
#define SDMMC_INTMASK_ACD_Msk                                 (0x01UL << SDMMC_INTMASK_ACD_Pos)
#define SDMMC_INTMASK_EBE_Pos                                 15
#define SDMMC_INTMASK_EBE_Msk                                 (0x01UL << SDMMC_INTMASK_EBE_Pos)
#define SDMMC_INTMASK_SDIO_INT_MASK_Pos                       16
#define SDMMC_INTMASK_SDIO_INT_MASK_Msk                       (0x0000ffffUL << SDMMC_INTMASK_SDIO_INT_MASK_Pos)

// --------------------------------------  SDMMC_CMDARG  ------------------------------------------
#define SDMMC_CMDARG_CMD_ARG_Pos                              0
#define SDMMC_CMDARG_CMD_ARG_Msk                              (0xffffffffUL << SDMMC_CMDARG_CMD_ARG_Pos)

// ----------------------------------------  SDMMC_CMD  -------------------------------------------
#define SDMMC_CMD_CMD_INDEX_Pos                               0
#define SDMMC_CMD_CMD_INDEX_Msk                               (0x3fUL << SDMMC_CMD_CMD_INDEX_Pos)
#define SDMMC_CMD_RESPONSE_EXPECT_Pos                         6
#define SDMMC_CMD_RESPONSE_EXPECT_Msk                         (0x01UL << SDMMC_CMD_RESPONSE_EXPECT_Pos)
#define SDMMC_CMD_RESPONSE_LENGTH_Pos                         7
#define SDMMC_CMD_RESPONSE_LENGTH_Msk                         (0x01UL << SDMMC_CMD_RESPONSE_LENGTH_Pos)
#define SDMMC_CMD_CHECK_RESPONSE_CRC_Pos                      8
#define SDMMC_CMD_CHECK_RESPONSE_CRC_Msk                      (0x01UL << SDMMC_CMD_CHECK_RESPONSE_CRC_Pos)
#define SDMMC_CMD_DATA_EXPECTED_Pos                           9
#define SDMMC_CMD_DATA_EXPECTED_Msk                           (0x01UL << SDMMC_CMD_DATA_EXPECTED_Pos)
#define SDMMC_CMD_READ_WRITE_Pos                              10
#define SDMMC_CMD_READ_WRITE_Msk                              (0x01UL << SDMMC_CMD_READ_WRITE_Pos)
#define SDMMC_CMD_TRANSFER_MODE_Pos                           11
#define SDMMC_CMD_TRANSFER_MODE_Msk                           (0x01UL << SDMMC_CMD_TRANSFER_MODE_Pos)
#define SDMMC_CMD_SEND_AUTO_STOP_Pos                          12
#define SDMMC_CMD_SEND_AUTO_STOP_Msk                          (0x01UL << SDMMC_CMD_SEND_AUTO_STOP_Pos)
#define SDMMC_CMD_WAIT_PRVDATA_COMPLETE_Pos                   13
#define SDMMC_CMD_WAIT_PRVDATA_COMPLETE_Msk                   (0x01UL << SDMMC_CMD_WAIT_PRVDATA_COMPLETE_Pos)
#define SDMMC_CMD_STOP_ABORT_CMd_Pos                          14
#define SDMMC_CMD_STOP_ABORT_CMd_Msk                          (0x01UL << SDMMC_CMD_STOP_ABORT_CMd_Pos)
#define SDMMC_CMD_SEND_INITIALIZATION_Pos                     15
#define SDMMC_CMD_SEND_INITIALIZATION_Msk                     (0x01UL << SDMMC_CMD_SEND_INITIALIZATION_Pos)
#define SDMMC_CMD_CARD_NUMBER_Pos                             16
#define SDMMC_CMD_CARD_NUMBER_Msk                             (0x1fUL << SDMMC_CMD_CARD_NUMBER_Pos)
#define SDMMC_CMD_UPDATE_CLOCK_REGISTERS_ONLY_Pos             21
#define SDMMC_CMD_UPDATE_CLOCK_REGISTERS_ONLY_Msk             (0x01UL << SDMMC_CMD_UPDATE_CLOCK_REGISTERS_ONLY_Pos)
#define SDMMC_CMD_READ_CEATA_DEVICE_Pos                       22
#define SDMMC_CMD_READ_CEATA_DEVICE_Msk                       (0x01UL << SDMMC_CMD_READ_CEATA_DEVICE_Pos)
#define SDMMC_CMD_CCS_EXPECTED_Pos                            23
#define SDMMC_CMD_CCS_EXPECTED_Msk                            (0x01UL << SDMMC_CMD_CCS_EXPECTED_Pos)
#define SDMMC_CMD_ENABLE_BOOT_Pos                             24
#define SDMMC_CMD_ENABLE_BOOT_Msk                             (0x01UL << SDMMC_CMD_ENABLE_BOOT_Pos)
#define SDMMC_CMD_EXPECT_BOOT_ACK_Pos                         25
#define SDMMC_CMD_EXPECT_BOOT_ACK_Msk                         (0x01UL << SDMMC_CMD_EXPECT_BOOT_ACK_Pos)
#define SDMMC_CMD_DISABLE_BOOT_Pos                            26
#define SDMMC_CMD_DISABLE_BOOT_Msk                            (0x01UL << SDMMC_CMD_DISABLE_BOOT_Pos)
#define SDMMC_CMD_BOOT_MODE_Pos                               27
#define SDMMC_CMD_BOOT_MODE_Msk                               (0x01UL << SDMMC_CMD_BOOT_MODE_Pos)
#define SDMMC_CMD_VOLT_SWITCH_Pos                             28
#define SDMMC_CMD_VOLT_SWITCH_Msk                             (0x01UL << SDMMC_CMD_VOLT_SWITCH_Pos)
#define SDMMC_CMD_START_CMD_Pos                               31
#define SDMMC_CMD_START_CMD_Msk                               (0x01UL << SDMMC_CMD_START_CMD_Pos)

// ---------------------------------------  SDMMC_RESP0  ------------------------------------------
#define SDMMC_RESP0_RESPONSE0_Pos                             0
#define SDMMC_RESP0_RESPONSE0_Msk                             (0xffffffffUL << SDMMC_RESP0_RESPONSE0_Pos)

// ---------------------------------------  SDMMC_RESP1  ------------------------------------------
#define SDMMC_RESP1_RESPONSE1_Pos                             0
#define SDMMC_RESP1_RESPONSE1_Msk                             (0xffffffffUL << SDMMC_RESP1_RESPONSE1_Pos)

// ---------------------------------------  SDMMC_RESP2  ------------------------------------------
#define SDMMC_RESP2_RESPONSE2_Pos                             0
#define SDMMC_RESP2_RESPONSE2_Msk                             (0xffffffffUL << SDMMC_RESP2_RESPONSE2_Pos)

// ---------------------------------------  SDMMC_RESP3  ------------------------------------------
#define SDMMC_RESP3_RESPONSE3_Pos                             0
#define SDMMC_RESP3_RESPONSE3_Msk                             (0xffffffffUL << SDMMC_RESP3_RESPONSE3_Pos)

// --------------------------------------  SDMMC_MINTSTS  -----------------------------------------
#define SDMMC_MINTSTS_CDET_Pos                                0
#define SDMMC_MINTSTS_CDET_Msk                                (0x01UL << SDMMC_MINTSTS_CDET_Pos)
#define SDMMC_MINTSTS_RE_Pos                                  1
#define SDMMC_MINTSTS_RE_Msk                                  (0x01UL << SDMMC_MINTSTS_RE_Pos)
#define SDMMC_MINTSTS_CDONE_Pos                               2
#define SDMMC_MINTSTS_CDONE_Msk                               (0x01UL << SDMMC_MINTSTS_CDONE_Pos)
#define SDMMC_MINTSTS_DTO_Pos                                 3
#define SDMMC_MINTSTS_DTO_Msk                                 (0x01UL << SDMMC_MINTSTS_DTO_Pos)
#define SDMMC_MINTSTS_TXDR_Pos                                4
#define SDMMC_MINTSTS_TXDR_Msk                                (0x01UL << SDMMC_MINTSTS_TXDR_Pos)
#define SDMMC_MINTSTS_RXDR_Pos                                5
#define SDMMC_MINTSTS_RXDR_Msk                                (0x01UL << SDMMC_MINTSTS_RXDR_Pos)
#define SDMMC_MINTSTS_RCRC_Pos                                6
#define SDMMC_MINTSTS_RCRC_Msk                                (0x01UL << SDMMC_MINTSTS_RCRC_Pos)
#define SDMMC_MINTSTS_DCRC_Pos                                7
#define SDMMC_MINTSTS_DCRC_Msk                                (0x01UL << SDMMC_MINTSTS_DCRC_Pos)
#define SDMMC_MINTSTS_RTO_Pos                                 8
#define SDMMC_MINTSTS_RTO_Msk                                 (0x01UL << SDMMC_MINTSTS_RTO_Pos)
#define SDMMC_MINTSTS_DRTO_Pos                                9
#define SDMMC_MINTSTS_DRTO_Msk                                (0x01UL << SDMMC_MINTSTS_DRTO_Pos)
#define SDMMC_MINTSTS_HTO_Pos                                 10
#define SDMMC_MINTSTS_HTO_Msk                                 (0x01UL << SDMMC_MINTSTS_HTO_Pos)
#define SDMMC_MINTSTS_FRUN_Pos                                11
#define SDMMC_MINTSTS_FRUN_Msk                                (0x01UL << SDMMC_MINTSTS_FRUN_Pos)
#define SDMMC_MINTSTS_HLE_Pos                                 12
#define SDMMC_MINTSTS_HLE_Msk                                 (0x01UL << SDMMC_MINTSTS_HLE_Pos)
#define SDMMC_MINTSTS_SBE_Pos                                 13
#define SDMMC_MINTSTS_SBE_Msk                                 (0x01UL << SDMMC_MINTSTS_SBE_Pos)
#define SDMMC_MINTSTS_ACD_Pos                                 14
#define SDMMC_MINTSTS_ACD_Msk                                 (0x01UL << SDMMC_MINTSTS_ACD_Pos)
#define SDMMC_MINTSTS_EBE_Pos                                 15
#define SDMMC_MINTSTS_EBE_Msk                                 (0x01UL << SDMMC_MINTSTS_EBE_Pos)
#define SDMMC_MINTSTS_SDIO_INTERRUPT_Pos                      16
#define SDMMC_MINTSTS_SDIO_INTERRUPT_Msk                      (0x0000ffffUL << SDMMC_MINTSTS_SDIO_INTERRUPT_Pos)

// --------------------------------------  SDMMC_RINTSTS  -----------------------------------------
#define SDMMC_RINTSTS_CDET_Pos                                0
#define SDMMC_RINTSTS_CDET_Msk                                (0x01UL << SDMMC_RINTSTS_CDET_Pos)
#define SDMMC_RINTSTS_RE_Pos                                  1
#define SDMMC_RINTSTS_RE_Msk                                  (0x01UL << SDMMC_RINTSTS_RE_Pos)
#define SDMMC_RINTSTS_CDONE_Pos                               2
#define SDMMC_RINTSTS_CDONE_Msk                               (0x01UL << SDMMC_RINTSTS_CDONE_Pos)
#define SDMMC_RINTSTS_DTO_Pos                                 3
#define SDMMC_RINTSTS_DTO_Msk                                 (0x01UL << SDMMC_RINTSTS_DTO_Pos)
#define SDMMC_RINTSTS_TXDR_Pos                                4
#define SDMMC_RINTSTS_TXDR_Msk                                (0x01UL << SDMMC_RINTSTS_TXDR_Pos)
#define SDMMC_RINTSTS_RXDR_Pos                                5
#define SDMMC_RINTSTS_RXDR_Msk                                (0x01UL << SDMMC_RINTSTS_RXDR_Pos)
#define SDMMC_RINTSTS_RCRC_Pos                                6
#define SDMMC_RINTSTS_RCRC_Msk                                (0x01UL << SDMMC_RINTSTS_RCRC_Pos)
#define SDMMC_RINTSTS_DCRC_Pos                                7
#define SDMMC_RINTSTS_DCRC_Msk                                (0x01UL << SDMMC_RINTSTS_DCRC_Pos)
#define SDMMC_RINTSTS_RTO_BAR_Pos                             8
#define SDMMC_RINTSTS_RTO_BAR_Msk                             (0x01UL << SDMMC_RINTSTS_RTO_BAR_Pos)
#define SDMMC_RINTSTS_DRTO_BDS_Pos                            9
#define SDMMC_RINTSTS_DRTO_BDS_Msk                            (0x01UL << SDMMC_RINTSTS_DRTO_BDS_Pos)
#define SDMMC_RINTSTS_HTO_Pos                                 10
#define SDMMC_RINTSTS_HTO_Msk                                 (0x01UL << SDMMC_RINTSTS_HTO_Pos)
#define SDMMC_RINTSTS_FRUN_Pos                                11
#define SDMMC_RINTSTS_FRUN_Msk                                (0x01UL << SDMMC_RINTSTS_FRUN_Pos)
#define SDMMC_RINTSTS_HLE_Pos                                 12
#define SDMMC_RINTSTS_HLE_Msk                                 (0x01UL << SDMMC_RINTSTS_HLE_Pos)
#define SDMMC_RINTSTS_SBE_Pos                                 13
#define SDMMC_RINTSTS_SBE_Msk                                 (0x01UL << SDMMC_RINTSTS_SBE_Pos)
#define SDMMC_RINTSTS_ACD_Pos                                 14
#define SDMMC_RINTSTS_ACD_Msk                                 (0x01UL << SDMMC_RINTSTS_ACD_Pos)
#define SDMMC_RINTSTS_EBE_Pos                                 15
#define SDMMC_RINTSTS_EBE_Msk                                 (0x01UL << SDMMC_RINTSTS_EBE_Pos)
#define SDMMC_RINTSTS_SDIO_INTERRUPT_Pos                      16
#define SDMMC_RINTSTS_SDIO_INTERRUPT_Msk                      (0x0000ffffUL << SDMMC_RINTSTS_SDIO_INTERRUPT_Pos)

// --------------------------------------  SDMMC_STATUS  ------------------------------------------
#define SDMMC_STATUS_FIFO_RX_WATERMARK_Pos                    0
#define SDMMC_STATUS_FIFO_RX_WATERMARK_Msk                    (0x01UL << SDMMC_STATUS_FIFO_RX_WATERMARK_Pos)
#define SDMMC_STATUS_FIFO_TX_WATERMARK_Pos                    1
#define SDMMC_STATUS_FIFO_TX_WATERMARK_Msk                    (0x01UL << SDMMC_STATUS_FIFO_TX_WATERMARK_Pos)
#define SDMMC_STATUS_FIFO_EMPTY_Pos                           2
#define SDMMC_STATUS_FIFO_EMPTY_Msk                           (0x01UL << SDMMC_STATUS_FIFO_EMPTY_Pos)
#define SDMMC_STATUS_FIFO_FULL_Pos                            3
#define SDMMC_STATUS_FIFO_FULL_Msk                            (0x01UL << SDMMC_STATUS_FIFO_FULL_Pos)
#define SDMMC_STATUS_CMDFSMSTATES_Pos                         4
#define SDMMC_STATUS_CMDFSMSTATES_Msk                         (0x0fUL << SDMMC_STATUS_CMDFSMSTATES_Pos)
#define SDMMC_STATUS_DATA_3_STATUS_Pos                        8
#define SDMMC_STATUS_DATA_3_STATUS_Msk                        (0x01UL << SDMMC_STATUS_DATA_3_STATUS_Pos)
#define SDMMC_STATUS_DATA_BUSY_Pos                            9
#define SDMMC_STATUS_DATA_BUSY_Msk                            (0x01UL << SDMMC_STATUS_DATA_BUSY_Pos)
#define SDMMC_STATUS_DATA_STATE_MC_BUSY_Pos                   10
#define SDMMC_STATUS_DATA_STATE_MC_BUSY_Msk                   (0x01UL << SDMMC_STATUS_DATA_STATE_MC_BUSY_Pos)
#define SDMMC_STATUS_RESPONSE_INDEX_Pos                       11
#define SDMMC_STATUS_RESPONSE_INDEX_Msk                       (0x3fUL << SDMMC_STATUS_RESPONSE_INDEX_Pos)
#define SDMMC_STATUS_FIFO_COUNT_Pos                           17
#define SDMMC_STATUS_FIFO_COUNT_Msk                           (0x00001fffUL << SDMMC_STATUS_FIFO_COUNT_Pos)
#define SDMMC_STATUS_DMA_ACK_Pos                              30
#define SDMMC_STATUS_DMA_ACK_Msk                              (0x01UL << SDMMC_STATUS_DMA_ACK_Pos)
#define SDMMC_STATUS_DMA_REQ_Pos                              31
#define SDMMC_STATUS_DMA_REQ_Msk                              (0x01UL << SDMMC_STATUS_DMA_REQ_Pos)

// --------------------------------------  SDMMC_FIFOTH  ------------------------------------------
#define SDMMC_FIFOTH_TX_WMARK_Pos                             0
#define SDMMC_FIFOTH_TX_WMARK_Msk                             (0x00000fffUL << SDMMC_FIFOTH_TX_WMARK_Pos)
#define SDMMC_FIFOTH_RX_WMARK_Pos                             16
#define SDMMC_FIFOTH_RX_WMARK_Msk                             (0x00000fffUL << SDMMC_FIFOTH_RX_WMARK_Pos)
#define SDMMC_FIFOTH_DW_DMA_MUTIPLE_TRANSACTION_SIZE_Pos      28
#define SDMMC_FIFOTH_DW_DMA_MUTIPLE_TRANSACTION_SIZE_Msk      (0x07UL << SDMMC_FIFOTH_DW_DMA_MUTIPLE_TRANSACTION_SIZE_Pos)/*!< SDMMC FIFOTH: DW_DMA_MUTIPLE_TRANSACTION_SIZE Mask */

// --------------------------------------  SDMMC_CDETECT  -----------------------------------------
#define SDMMC_CDETECT_CARD_DETECT_N_Pos                       0
#define SDMMC_CDETECT_CARD_DETECT_N_Msk                       (0x3fffffffUL << SDMMC_CDETECT_CARD_DETECT_N_Pos)

// --------------------------------------  SDMMC_WRTPRT  ------------------------------------------
#define SDMMC_WRTPRT_WRITE_PROTECT_Pos                        0
#define SDMMC_WRTPRT_WRITE_PROTECT_Msk                        (0x3fffffffUL << SDMMC_WRTPRT_WRITE_PROTECT_Pos)

// ---------------------------------------  SDMMC_GPIO  -------------------------------------------
#define SDMMC_GPIO_GPI_Pos                                    0
#define SDMMC_GPIO_GPI_Msk                                    (0x000000ffUL << SDMMC_GPIO_GPI_Pos)
#define SDMMC_GPIO_GPO_Pos                                    8
#define SDMMC_GPIO_GPO_Msk                                    (0x0000ffffUL << SDMMC_GPIO_GPO_Pos)

// --------------------------------------  SDMMC_TCBCNT  ------------------------------------------
#define SDMMC_TCBCNT_TRANS_CARD_BYTE_COUNT_Pos                0
#define SDMMC_TCBCNT_TRANS_CARD_BYTE_COUNT_Msk                (0xffffffffUL << SDMMC_TCBCNT_TRANS_CARD_BYTE_COUNT_Pos)

// --------------------------------------  SDMMC_TBBCNT  ------------------------------------------
#define SDMMC_TBBCNT_TRANS_FIFO_BYTE_COUNT_Pos                0
#define SDMMC_TBBCNT_TRANS_FIFO_BYTE_COUNT_Msk                (0xffffffffUL << SDMMC_TBBCNT_TRANS_FIFO_BYTE_COUNT_Pos)

// --------------------------------------  SDMMC_DEBNCE  ------------------------------------------
#define SDMMC_DEBNCE_DEBOUNCE_COUNT_Pos                       0
#define SDMMC_DEBNCE_DEBOUNCE_COUNT_Msk                       (0x00ffffffUL << SDMMC_DEBNCE_DEBOUNCE_COUNT_Pos)

// ---------------------------------------  SDMMC_USRID  ------------------------------------------
#define SDMMC_USRID_USRID_Pos                                 0
#define SDMMC_USRID_USRID_Msk                                 (0xffffffffUL << SDMMC_USRID_USRID_Pos)

// ---------------------------------------  SDMMC_VERID  ------------------------------------------
#define SDMMC_VERID_VERID_Pos                                 0
#define SDMMC_VERID_VERID_Msk                                 (0xffffffffUL << SDMMC_VERID_VERID_Pos)

// --------------------------------------  SDMMC_UHS_REG  -----------------------------------------
#define SDMMC_UHS_REG_VOLT_REG_Pos                            0
#define SDMMC_UHS_REG_VOLT_REG_Msk                            (0x0000ffffUL << SDMMC_UHS_REG_VOLT_REG_Pos)
#define SDMMC_UHS_REG_DDR_REG_Pos                             16
#define SDMMC_UHS_REG_DDR_REG_Msk                             (0x0000ffffUL << SDMMC_UHS_REG_DDR_REG_Pos)

// ---------------------------------------  SDMMC_RST_N  ------------------------------------------
#define SDMMC_RST_N_CARD_RESET_Pos                            0
#define SDMMC_RST_N_CARD_RESET_Msk                            (0x0000ffffUL << SDMMC_RST_N_CARD_RESET_Pos)

// ---------------------------------------  SDMMC_BMOD  -------------------------------------------
#define SDMMC_BMOD_SWR_Pos                                    0
#define SDMMC_BMOD_SWR_Msk                                    (0x01UL << SDMMC_BMOD_SWR_Pos)
#define SDMMC_BMOD_FB_Pos                                     1
#define SDMMC_BMOD_FB_Msk                                     (0x01UL << SDMMC_BMOD_FB_Pos)
#define SDMMC_BMOD_DSL_Pos                                    2
#define SDMMC_BMOD_DSL_Msk                                    (0x1fUL << SDMMC_BMOD_DSL_Pos)
#define SDMMC_BMOD_DE_Pos                                     7
#define SDMMC_BMOD_DE_Msk                                     (0x01UL << SDMMC_BMOD_DE_Pos)
#define SDMMC_BMOD_PBL_Pos                                    8
#define SDMMC_BMOD_PBL_Msk                                    (0x07UL << SDMMC_BMOD_PBL_Pos)

// --------------------------------------  SDMMC_PLDMND  ------------------------------------------
#define SDMMC_PLDMND_PD_Pos                                   0
#define SDMMC_PLDMND_PD_Msk                                   (0xffffffffUL << SDMMC_PLDMND_PD_Pos)

// --------------------------------------  SDMMC_DBADDR  ------------------------------------------
#define SDMMC_DBADDR_SDL_Pos                                  0
#define SDMMC_DBADDR_SDL_Msk                                  (0xffffffffUL << SDMMC_DBADDR_SDL_Pos)

// ---------------------------------------  SDMMC_IDSTS  ------------------------------------------
#define SDMMC_IDSTS_TI_Pos                                    0
#define SDMMC_IDSTS_TI_Msk                                    (0x01UL << SDMMC_IDSTS_TI_Pos)
#define SDMMC_IDSTS_RI_Pos                                    1
#define SDMMC_IDSTS_RI_Msk                                    (0x01UL << SDMMC_IDSTS_RI_Pos)
#define SDMMC_IDSTS_FBE_Pos                                   2
#define SDMMC_IDSTS_FBE_Msk                                   (0x01UL << SDMMC_IDSTS_FBE_Pos)
#define SDMMC_IDSTS_DU_Pos                                    4
#define SDMMC_IDSTS_DU_Msk                                    (0x01UL << SDMMC_IDSTS_DU_Pos)
#define SDMMC_IDSTS_CES_Pos                                   5
#define SDMMC_IDSTS_CES_Msk                                   (0x01UL << SDMMC_IDSTS_CES_Pos)
#define SDMMC_IDSTS_NIS_Pos                                   8
#define SDMMC_IDSTS_NIS_Msk                                   (0x01UL << SDMMC_IDSTS_NIS_Pos)
#define SDMMC_IDSTS_AIS_Pos                                   9
#define SDMMC_IDSTS_AIS_Msk                                   (0x01UL << SDMMC_IDSTS_AIS_Pos)
#define SDMMC_IDSTS_EB_Pos                                    10
#define SDMMC_IDSTS_EB_Msk                                    (0x07UL << SDMMC_IDSTS_EB_Pos)
#define SDMMC_IDSTS_FSM_Pos                                   13
#define SDMMC_IDSTS_FSM_Msk                                   (0x0fUL << SDMMC_IDSTS_FSM_Pos)

// --------------------------------------  SDMMC_IDINTEN  -----------------------------------------
#define SDMMC_IDINTEN_TI_Pos                                  0
#define SDMMC_IDINTEN_TI_Msk                                  (0x01UL << SDMMC_IDINTEN_TI_Pos)
#define SDMMC_IDINTEN_RI_Pos                                  1
#define SDMMC_IDINTEN_RI_Msk                                  (0x01UL << SDMMC_IDINTEN_RI_Pos)
#define SDMMC_IDINTEN_FBE_Pos                                 2
#define SDMMC_IDINTEN_FBE_Msk                                 (0x01UL << SDMMC_IDINTEN_FBE_Pos)
#define SDMMC_IDINTEN_DU_Pos                                  4
#define SDMMC_IDINTEN_DU_Msk                                  (0x01UL << SDMMC_IDINTEN_DU_Pos)
#define SDMMC_IDINTEN_CES_Pos                                 5
#define SDMMC_IDINTEN_CES_Msk                                 (0x01UL << SDMMC_IDINTEN_CES_Pos)
#define SDMMC_IDINTEN_NIS_Pos                                 8
#define SDMMC_IDINTEN_NIS_Msk                                 (0x01UL << SDMMC_IDINTEN_NIS_Pos)
#define SDMMC_IDINTEN_AIS_Pos                                 9
#define SDMMC_IDINTEN_AIS_Msk                                 (0x01UL << SDMMC_IDINTEN_AIS_Pos)

// --------------------------------------  SDMMC_DSCADDR  -----------------------------------------
#define SDMMC_DSCADDR_HDA_Pos                                 0
#define SDMMC_DSCADDR_HDA_Msk                                 (0xffffffffUL << SDMMC_DSCADDR_HDA_Pos)

// --------------------------------------  SDMMC_BUFADDR  -----------------------------------------
#define SDMMC_BUFADDR_HBA_Pos                                 0
#define SDMMC_BUFADDR_HBA_Msk                                 (0xffffffffUL << SDMMC_BUFADDR_HBA_Pos)


// ------------------------------------------------------------------------------------------------
// -----                                  EMC Position & Mask                                 -----
// ------------------------------------------------------------------------------------------------


// ---------------------------------------  EMC_CONTROL  ------------------------------------------
#define EMC_CONTROL_E_Pos                                     0
#define EMC_CONTROL_E_Msk                                     (0x01UL << EMC_CONTROL_E_Pos)
#define EMC_CONTROL_M_Pos                                     1
#define EMC_CONTROL_M_Msk                                     (0x01UL << EMC_CONTROL_M_Pos)
#define EMC_CONTROL_L_Pos                                     2
#define EMC_CONTROL_L_Msk                                     (0x01UL << EMC_CONTROL_L_Pos)

// ---------------------------------------  EMC_STATUS  -------------------------------------------
#define EMC_STATUS_B_Pos                                      0
#define EMC_STATUS_B_Msk                                      (0x01UL << EMC_STATUS_B_Pos)
#define EMC_STATUS_S_Pos                                      1
#define EMC_STATUS_S_Msk                                      (0x01UL << EMC_STATUS_S_Pos)
#define EMC_STATUS_SA_Pos                                     2
#define EMC_STATUS_SA_Msk                                     (0x01UL << EMC_STATUS_SA_Pos)

// ---------------------------------------  EMC_CONFIG  -------------------------------------------
#define EMC_CONFIG_EM_Pos                                     0
#define EMC_CONFIG_EM_Msk                                     (0x01UL << EMC_CONFIG_EM_Pos)
#define EMC_CONFIG_CR_Pos                                     8
#define EMC_CONFIG_CR_Msk                                     (0x01UL << EMC_CONFIG_CR_Pos)

// -----------------------------------  EMC_DYNAMICCONTROL  ---------------------------------------
#define EMC_DYNAMICCONTROL_CE_Pos                             0
#define EMC_DYNAMICCONTROL_CE_Msk                             (0x01UL << EMC_DYNAMICCONTROL_CE_Pos)
#define EMC_DYNAMICCONTROL_CS_Pos                             1
#define EMC_DYNAMICCONTROL_CS_Msk                             (0x01UL << EMC_DYNAMICCONTROL_CS_Pos)
#define EMC_DYNAMICCONTROL_SR_Pos                             2
#define EMC_DYNAMICCONTROL_SR_Msk                             (0x01UL << EMC_DYNAMICCONTROL_SR_Pos)
#define EMC_DYNAMICCONTROL_MMC_Pos                            5
#define EMC_DYNAMICCONTROL_MMC_Msk                            (0x01UL << EMC_DYNAMICCONTROL_MMC_Pos)
#define EMC_DYNAMICCONTROL_I_Pos                              7
#define EMC_DYNAMICCONTROL_I_Msk                              (0x03UL << EMC_DYNAMICCONTROL_I_Pos)
#define EMC_DYNAMICCONTROL_DP_Pos                             13
#define EMC_DYNAMICCONTROL_DP_Msk                             (0x01UL << EMC_DYNAMICCONTROL_DP_Pos)

// -----------------------------------  EMC_DYNAMICREFRESH  ---------------------------------------
#define EMC_DYNAMICREFRESH_REFRESH_Pos                        0
#define EMC_DYNAMICREFRESH_REFRESH_Msk                        (0x000007ffUL << EMC_DYNAMICREFRESH_REFRESH_Pos)

// ----------------------------------  EMC_DYNAMICREADCONFIG  -------------------------------------
#define EMC_DYNAMICREADCONFIG_RD_Pos                          0
#define EMC_DYNAMICREADCONFIG_RD_Msk                          (0x03UL << EMC_DYNAMICREADCONFIG_RD_Pos)

// --------------------------------------  EMC_DYNAMICRP  -----------------------------------------
#define EMC_DYNAMICRP_tRP_Pos                                 0
#define EMC_DYNAMICRP_tRP_Msk                                 (0x0fUL << EMC_DYNAMICRP_tRP_Pos)

// -------------------------------------  EMC_DYNAMICRAS  -----------------------------------------
#define EMC_DYNAMICRAS_tRAS_Pos                               0
#define EMC_DYNAMICRAS_tRAS_Msk                               (0x0fUL << EMC_DYNAMICRAS_tRAS_Pos)

// -------------------------------------  EMC_DYNAMICSREX  ----------------------------------------
#define EMC_DYNAMICSREX_tSREX_Pos                             0
#define EMC_DYNAMICSREX_tSREX_Msk                             (0x0fUL << EMC_DYNAMICSREX_tSREX_Pos)

// -------------------------------------  EMC_DYNAMICAPR  -----------------------------------------
#define EMC_DYNAMICAPR_tAPR_Pos                               0
#define EMC_DYNAMICAPR_tAPR_Msk                               (0x0fUL << EMC_DYNAMICAPR_tAPR_Pos)

// -------------------------------------  EMC_DYNAMICDAL  -----------------------------------------
#define EMC_DYNAMICDAL_tDAL_Pos                               0
#define EMC_DYNAMICDAL_tDAL_Msk                               (0x0fUL << EMC_DYNAMICDAL_tDAL_Pos)

// --------------------------------------  EMC_DYNAMICWR  -----------------------------------------
#define EMC_DYNAMICWR_tWR_Pos                                 0
#define EMC_DYNAMICWR_tWR_Msk                                 (0x0fUL << EMC_DYNAMICWR_tWR_Pos)

// --------------------------------------  EMC_DYNAMICRC  -----------------------------------------
#define EMC_DYNAMICRC_tRC_Pos                                 0
#define EMC_DYNAMICRC_tRC_Msk                                 (0x1fUL << EMC_DYNAMICRC_tRC_Pos)

// -------------------------------------  EMC_DYNAMICRFC  -----------------------------------------
#define EMC_DYNAMICRFC_tRFC_Pos                               0
#define EMC_DYNAMICRFC_tRFC_Msk                               (0x1fUL << EMC_DYNAMICRFC_tRFC_Pos)

// -------------------------------------  EMC_DYNAMICXSR  -----------------------------------------
#define EMC_DYNAMICXSR_tXSR_Pos                               0
#define EMC_DYNAMICXSR_tXSR_Msk                               (0x1fUL << EMC_DYNAMICXSR_tXSR_Pos)

// -------------------------------------  EMC_DYNAMICRRD  -----------------------------------------
#define EMC_DYNAMICRRD_tRRD_Pos                               0
#define EMC_DYNAMICRRD_tRRD_Msk                               (0x0fUL << EMC_DYNAMICRRD_tRRD_Pos)

// -------------------------------------  EMC_DYNAMICMRD  -----------------------------------------
#define EMC_DYNAMICMRD_tMRD_Pos                               0
#define EMC_DYNAMICMRD_tMRD_Msk                               (0x0fUL << EMC_DYNAMICMRD_tMRD_Pos)

// ---------------------------------  EMC_STATICEXTENDEDWAIT  -------------------------------------
#define EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_Pos               0
#define EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_Msk               (0x000003ffUL << EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_Pos)

// -----------------------------------  EMC_DYNAMICCONFIG0  ---------------------------------------
#define EMC_DYNAMICCONFIG0_MD_Pos                             3
#define EMC_DYNAMICCONFIG0_MD_Msk                             (0x03UL << EMC_DYNAMICCONFIG0_MD_Pos)
#define EMC_DYNAMICCONFIG0_AM0_Pos                            7
#define EMC_DYNAMICCONFIG0_AM0_Msk                            (0x3fUL << EMC_DYNAMICCONFIG0_AM0_Pos)
#define EMC_DYNAMICCONFIG0_AM1_Pos                            14
#define EMC_DYNAMICCONFIG0_AM1_Msk                            (0x01UL << EMC_DYNAMICCONFIG0_AM1_Pos)
#define EMC_DYNAMICCONFIG0_B_Pos                              19
#define EMC_DYNAMICCONFIG0_B_Msk                              (0x01UL << EMC_DYNAMICCONFIG0_B_Pos)
#define EMC_DYNAMICCONFIG0_P_Pos                              20
#define EMC_DYNAMICCONFIG0_P_Msk                              (0x01UL << EMC_DYNAMICCONFIG0_P_Pos)

// -----------------------------------  EMC_DYNAMICRASCAS0  ---------------------------------------
#define EMC_DYNAMICRASCAS0_RAS_Pos                            0
#define EMC_DYNAMICRASCAS0_RAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS0_RAS_Pos)
#define EMC_DYNAMICRASCAS0_CAS_Pos                            8
#define EMC_DYNAMICRASCAS0_CAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS0_CAS_Pos)

// -----------------------------------  EMC_DYNAMICCONFIG1  ---------------------------------------
#define EMC_DYNAMICCONFIG1_MD_Pos                             3
#define EMC_DYNAMICCONFIG1_MD_Msk                             (0x03UL << EMC_DYNAMICCONFIG1_MD_Pos)
#define EMC_DYNAMICCONFIG1_AM0_Pos                            7
#define EMC_DYNAMICCONFIG1_AM0_Msk                            (0x3fUL << EMC_DYNAMICCONFIG1_AM0_Pos)
#define EMC_DYNAMICCONFIG1_AM1_Pos                            14
#define EMC_DYNAMICCONFIG1_AM1_Msk                            (0x01UL << EMC_DYNAMICCONFIG1_AM1_Pos)
#define EMC_DYNAMICCONFIG1_B_Pos                              19
#define EMC_DYNAMICCONFIG1_B_Msk                              (0x01UL << EMC_DYNAMICCONFIG1_B_Pos)
#define EMC_DYNAMICCONFIG1_P_Pos                              20
#define EMC_DYNAMICCONFIG1_P_Msk                              (0x01UL << EMC_DYNAMICCONFIG1_P_Pos)

// -----------------------------------  EMC_DYNAMICRASCAS1  ---------------------------------------
#define EMC_DYNAMICRASCAS1_RAS_Pos                            0
#define EMC_DYNAMICRASCAS1_RAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS1_RAS_Pos)
#define EMC_DYNAMICRASCAS1_CAS_Pos                            8
#define EMC_DYNAMICRASCAS1_CAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS1_CAS_Pos)

// -----------------------------------  EMC_DYNAMICCONFIG2  ---------------------------------------
#define EMC_DYNAMICCONFIG2_MD_Pos                             3
#define EMC_DYNAMICCONFIG2_MD_Msk                             (0x03UL << EMC_DYNAMICCONFIG2_MD_Pos)
#define EMC_DYNAMICCONFIG2_AM0_Pos                            7
#define EMC_DYNAMICCONFIG2_AM0_Msk                            (0x3fUL << EMC_DYNAMICCONFIG2_AM0_Pos)
#define EMC_DYNAMICCONFIG2_AM1_Pos                            14
#define EMC_DYNAMICCONFIG2_AM1_Msk                            (0x01UL << EMC_DYNAMICCONFIG2_AM1_Pos)
#define EMC_DYNAMICCONFIG2_B_Pos                              19
#define EMC_DYNAMICCONFIG2_B_Msk                              (0x01UL << EMC_DYNAMICCONFIG2_B_Pos)
#define EMC_DYNAMICCONFIG2_P_Pos                              20
#define EMC_DYNAMICCONFIG2_P_Msk                              (0x01UL << EMC_DYNAMICCONFIG2_P_Pos)

// -----------------------------------  EMC_DYNAMICRASCAS2  ---------------------------------------
#define EMC_DYNAMICRASCAS2_RAS_Pos                            0
#define EMC_DYNAMICRASCAS2_RAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS2_RAS_Pos)
#define EMC_DYNAMICRASCAS2_CAS_Pos                            8
#define EMC_DYNAMICRASCAS2_CAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS2_CAS_Pos)

// -----------------------------------  EMC_DYNAMICCONFIG3  ---------------------------------------
#define EMC_DYNAMICCONFIG3_MD_Pos                             3
#define EMC_DYNAMICCONFIG3_MD_Msk                             (0x03UL << EMC_DYNAMICCONFIG3_MD_Pos)
#define EMC_DYNAMICCONFIG3_AM0_Pos                            7
#define EMC_DYNAMICCONFIG3_AM0_Msk                            (0x3fUL << EMC_DYNAMICCONFIG3_AM0_Pos)
#define EMC_DYNAMICCONFIG3_AM1_Pos                            14
#define EMC_DYNAMICCONFIG3_AM1_Msk                            (0x01UL << EMC_DYNAMICCONFIG3_AM1_Pos)
#define EMC_DYNAMICCONFIG3_B_Pos                              19
#define EMC_DYNAMICCONFIG3_B_Msk                              (0x01UL << EMC_DYNAMICCONFIG3_B_Pos)
#define EMC_DYNAMICCONFIG3_P_Pos                              20
#define EMC_DYNAMICCONFIG3_P_Msk                              (0x01UL << EMC_DYNAMICCONFIG3_P_Pos)

// -----------------------------------  EMC_DYNAMICRASCAS3  ---------------------------------------
#define EMC_DYNAMICRASCAS3_RAS_Pos                            0
#define EMC_DYNAMICRASCAS3_RAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS3_RAS_Pos)
#define EMC_DYNAMICRASCAS3_CAS_Pos                            8
#define EMC_DYNAMICRASCAS3_CAS_Msk                            (0x03UL << EMC_DYNAMICRASCAS3_CAS_Pos)

// ------------------------------------  EMC_STATICCONFIG0  ---------------------------------------
#define EMC_STATICCONFIG0_MW_Pos                              0
#define EMC_STATICCONFIG0_MW_Msk                              (0x03UL << EMC_STATICCONFIG0_MW_Pos)
#define EMC_STATICCONFIG0_PM_Pos                              3
#define EMC_STATICCONFIG0_PM_Msk                              (0x01UL << EMC_STATICCONFIG0_PM_Pos)
#define EMC_STATICCONFIG0_PC_Pos                              6
#define EMC_STATICCONFIG0_PC_Msk                              (0x01UL << EMC_STATICCONFIG0_PC_Pos)
#define EMC_STATICCONFIG0_PB_Pos                              7
#define EMC_STATICCONFIG0_PB_Msk                              (0x01UL << EMC_STATICCONFIG0_PB_Pos)
#define EMC_STATICCONFIG0_EW_Pos                              8
#define EMC_STATICCONFIG0_EW_Msk                              (0x01UL << EMC_STATICCONFIG0_EW_Pos)
#define EMC_STATICCONFIG0_B_Pos                               19
#define EMC_STATICCONFIG0_B_Msk                               (0x01UL << EMC_STATICCONFIG0_B_Pos)
#define EMC_STATICCONFIG0_P_Pos                               20
#define EMC_STATICCONFIG0_P_Msk                               (0x01UL << EMC_STATICCONFIG0_P_Pos)

// -----------------------------------  EMC_STATICWAITWEN0  ---------------------------------------
#define EMC_STATICWAITWEN0_WAITWEN_Pos                        0
#define EMC_STATICWAITWEN0_WAITWEN_Msk                        (0x0fUL << EMC_STATICWAITWEN0_WAITWEN_Pos)

// -----------------------------------  EMC_STATICWAITOEN0  ---------------------------------------
#define EMC_STATICWAITOEN0_WAITOEN_Pos                        0
#define EMC_STATICWAITOEN0_WAITOEN_Msk                        (0x0fUL << EMC_STATICWAITOEN0_WAITOEN_Pos)

// ------------------------------------  EMC_STATICWAITRD0  ---------------------------------------
#define EMC_STATICWAITRD0_WAITRD_Pos                          0
#define EMC_STATICWAITRD0_WAITRD_Msk                          (0x1fUL << EMC_STATICWAITRD0_WAITRD_Pos)

// -----------------------------------  EMC_STATICWAITPAG0  ---------------------------------------
#define EMC_STATICWAITPAG0_WAITPAGE_Pos                       0
#define EMC_STATICWAITPAG0_WAITPAGE_Msk                       (0x1fUL << EMC_STATICWAITPAG0_WAITPAGE_Pos)

// ------------------------------------  EMC_STATICWAITWR0  ---------------------------------------
#define EMC_STATICWAITWR0_WAITWR_Pos                          0
#define EMC_STATICWAITWR0_WAITWR_Msk                          (0x1fUL << EMC_STATICWAITWR0_WAITWR_Pos)

// -----------------------------------  EMC_STATICWAITTURN0  --------------------------------------
#define EMC_STATICWAITTURN0_WAITTURN_Pos                      0
#define EMC_STATICWAITTURN0_WAITTURN_Msk                      (0x0fUL << EMC_STATICWAITTURN0_WAITTURN_Pos)

// ------------------------------------  EMC_STATICCONFIG1  ---------------------------------------
#define EMC_STATICCONFIG1_MW_Pos                              0
#define EMC_STATICCONFIG1_MW_Msk                              (0x03UL << EMC_STATICCONFIG1_MW_Pos)
#define EMC_STATICCONFIG1_PM_Pos                              3
#define EMC_STATICCONFIG1_PM_Msk                              (0x01UL << EMC_STATICCONFIG1_PM_Pos)
#define EMC_STATICCONFIG1_PC_Pos                              6
#define EMC_STATICCONFIG1_PC_Msk                              (0x01UL << EMC_STATICCONFIG1_PC_Pos)
#define EMC_STATICCONFIG1_PB_Pos                              7
#define EMC_STATICCONFIG1_PB_Msk                              (0x01UL << EMC_STATICCONFIG1_PB_Pos)
#define EMC_STATICCONFIG1_EW_Pos                              8
#define EMC_STATICCONFIG1_EW_Msk                              (0x01UL << EMC_STATICCONFIG1_EW_Pos)
#define EMC_STATICCONFIG1_B_Pos                               19
#define EMC_STATICCONFIG1_B_Msk                               (0x01UL << EMC_STATICCONFIG1_B_Pos)
#define EMC_STATICCONFIG1_P_Pos                               20
#define EMC_STATICCONFIG1_P_Msk                               (0x01UL << EMC_STATICCONFIG1_P_Pos)

// -----------------------------------  EMC_STATICWAITWEN1  ---------------------------------------
#define EMC_STATICWAITWEN1_WAITWEN_Pos                        0
#define EMC_STATICWAITWEN1_WAITWEN_Msk                        (0x0fUL << EMC_STATICWAITWEN1_WAITWEN_Pos)

// -----------------------------------  EMC_STATICWAITOEN1  ---------------------------------------
#define EMC_STATICWAITOEN1_WAITOEN_Pos                        0
#define EMC_STATICWAITOEN1_WAITOEN_Msk                        (0x0fUL << EMC_STATICWAITOEN1_WAITOEN_Pos)

// ------------------------------------  EMC_STATICWAITRD1  ---------------------------------------
#define EMC_STATICWAITRD1_WAITRD_Pos                          0
#define EMC_STATICWAITRD1_WAITRD_Msk                          (0x1fUL << EMC_STATICWAITRD1_WAITRD_Pos)

// -----------------------------------  EMC_STATICWAITPAG1  ---------------------------------------
#define EMC_STATICWAITPAG1_WAITPAGE_Pos                       0
#define EMC_STATICWAITPAG1_WAITPAGE_Msk                       (0x1fUL << EMC_STATICWAITPAG1_WAITPAGE_Pos)

// ------------------------------------  EMC_STATICWAITWR1  ---------------------------------------
#define EMC_STATICWAITWR1_WAITWR_Pos                          0
#define EMC_STATICWAITWR1_WAITWR_Msk                          (0x1fUL << EMC_STATICWAITWR1_WAITWR_Pos)

// -----------------------------------  EMC_STATICWAITTURN1  --------------------------------------
#define EMC_STATICWAITTURN1_WAITTURN_Pos                      0
#define EMC_STATICWAITTURN1_WAITTURN_Msk                      (0x0fUL << EMC_STATICWAITTURN1_WAITTURN_Pos)

// ------------------------------------  EMC_STATICCONFIG2  ---------------------------------------
#define EMC_STATICCONFIG2_MW_Pos                              0
#define EMC_STATICCONFIG2_MW_Msk                              (0x03UL << EMC_STATICCONFIG2_MW_Pos)
#define EMC_STATICCONFIG2_PM_Pos                              3
#define EMC_STATICCONFIG2_PM_Msk                              (0x01UL << EMC_STATICCONFIG2_PM_Pos)
#define EMC_STATICCONFIG2_PC_Pos                              6
#define EMC_STATICCONFIG2_PC_Msk                              (0x01UL << EMC_STATICCONFIG2_PC_Pos)
#define EMC_STATICCONFIG2_PB_Pos                              7
#define EMC_STATICCONFIG2_PB_Msk                              (0x01UL << EMC_STATICCONFIG2_PB_Pos)
#define EMC_STATICCONFIG2_EW_Pos                              8
#define EMC_STATICCONFIG2_EW_Msk                              (0x01UL << EMC_STATICCONFIG2_EW_Pos)
#define EMC_STATICCONFIG2_B_Pos                               19
#define EMC_STATICCONFIG2_B_Msk                               (0x01UL << EMC_STATICCONFIG2_B_Pos)
#define EMC_STATICCONFIG2_P_Pos                               20
#define EMC_STATICCONFIG2_P_Msk                               (0x01UL << EMC_STATICCONFIG2_P_Pos)

// -----------------------------------  EMC_STATICWAITWEN2  ---------------------------------------
#define EMC_STATICWAITWEN2_WAITWEN_Pos                        0
#define EMC_STATICWAITWEN2_WAITWEN_Msk                        (0x0fUL << EMC_STATICWAITWEN2_WAITWEN_Pos)

// -----------------------------------  EMC_STATICWAITOEN2  ---------------------------------------
#define EMC_STATICWAITOEN2_WAITOEN_Pos                        0
#define EMC_STATICWAITOEN2_WAITOEN_Msk                        (0x0fUL << EMC_STATICWAITOEN2_WAITOEN_Pos)

// ------------------------------------  EMC_STATICWAITRD2  ---------------------------------------
#define EMC_STATICWAITRD2_WAITRD_Pos                          0
#define EMC_STATICWAITRD2_WAITRD_Msk                          (0x1fUL << EMC_STATICWAITRD2_WAITRD_Pos)

// -----------------------------------  EMC_STATICWAITPAG2  ---------------------------------------
#define EMC_STATICWAITPAG2_WAITPAGE_Pos                       0
#define EMC_STATICWAITPAG2_WAITPAGE_Msk                       (0x1fUL << EMC_STATICWAITPAG2_WAITPAGE_Pos)

// ------------------------------------  EMC_STATICWAITWR2  ---------------------------------------
#define EMC_STATICWAITWR2_WAITWR_Pos                          0
#define EMC_STATICWAITWR2_WAITWR_Msk                          (0x1fUL << EMC_STATICWAITWR2_WAITWR_Pos)

// -----------------------------------  EMC_STATICWAITTURN2  --------------------------------------
#define EMC_STATICWAITTURN2_WAITTURN_Pos                      0
#define EMC_STATICWAITTURN2_WAITTURN_Msk                      (0x0fUL << EMC_STATICWAITTURN2_WAITTURN_Pos)

// ------------------------------------  EMC_STATICCONFIG3  ---------------------------------------
#define EMC_STATICCONFIG3_MW_Pos                              0
#define EMC_STATICCONFIG3_MW_Msk                              (0x03UL << EMC_STATICCONFIG3_MW_Pos)
#define EMC_STATICCONFIG3_PM_Pos                              3
#define EMC_STATICCONFIG3_PM_Msk                              (0x01UL << EMC_STATICCONFIG3_PM_Pos)
#define EMC_STATICCONFIG3_PC_Pos                              6
#define EMC_STATICCONFIG3_PC_Msk                              (0x01UL << EMC_STATICCONFIG3_PC_Pos)
#define EMC_STATICCONFIG3_PB_Pos                              7
#define EMC_STATICCONFIG3_PB_Msk                              (0x01UL << EMC_STATICCONFIG3_PB_Pos)
#define EMC_STATICCONFIG3_EW_Pos                              8
#define EMC_STATICCONFIG3_EW_Msk                              (0x01UL << EMC_STATICCONFIG3_EW_Pos)
#define EMC_STATICCONFIG3_B_Pos                               19
#define EMC_STATICCONFIG3_B_Msk                               (0x01UL << EMC_STATICCONFIG3_B_Pos)
#define EMC_STATICCONFIG3_P_Pos                               20
#define EMC_STATICCONFIG3_P_Msk                               (0x01UL << EMC_STATICCONFIG3_P_Pos)

// -----------------------------------  EMC_STATICWAITWEN3  ---------------------------------------
#define EMC_STATICWAITWEN3_WAITWEN_Pos                        0
#define EMC_STATICWAITWEN3_WAITWEN_Msk                        (0x0fUL << EMC_STATICWAITWEN3_WAITWEN_Pos)

// -----------------------------------  EMC_STATICWAITOEN3  ---------------------------------------
#define EMC_STATICWAITOEN3_WAITOEN_Pos                        0
#define EMC_STATICWAITOEN3_WAITOEN_Msk                        (0x0fUL << EMC_STATICWAITOEN3_WAITOEN_Pos)

// ------------------------------------  EMC_STATICWAITRD3  ---------------------------------------
#define EMC_STATICWAITRD3_WAITRD_Pos                          0
#define EMC_STATICWAITRD3_WAITRD_Msk                          (0x1fUL << EMC_STATICWAITRD3_WAITRD_Pos)

// -----------------------------------  EMC_STATICWAITPAG3  ---------------------------------------
#define EMC_STATICWAITPAG3_WAITPAGE_Pos                       0
#define EMC_STATICWAITPAG3_WAITPAGE_Msk                       (0x1fUL << EMC_STATICWAITPAG3_WAITPAGE_Pos)

// ------------------------------------  EMC_STATICWAITWR3  ---------------------------------------
#define EMC_STATICWAITWR3_WAITWR_Pos                          0
#define EMC_STATICWAITWR3_WAITWR_Msk                          (0x1fUL << EMC_STATICWAITWR3_WAITWR_Pos)

// -----------------------------------  EMC_STATICWAITTURN3  --------------------------------------
#define EMC_STATICWAITTURN3_WAITTURN_Pos                      0
#define EMC_STATICWAITTURN3_WAITTURN_Msk                      (0x0fUL << EMC_STATICWAITTURN3_WAITTURN_Pos)


// ------------------------------------------------------------------------------------------------
// -----                                 USB0 Position & Mask                                 -----
// ------------------------------------------------------------------------------------------------


// -------------------------------------  USB0_CAPLENGTH  -----------------------------------------
#define USB0_CAPLENGTH_CAPLENGTH_Pos                          0
#define USB0_CAPLENGTH_CAPLENGTH_Msk                          (0x000000ffUL << USB0_CAPLENGTH_CAPLENGTH_Pos)
#define USB0_CAPLENGTH_HCIVERSION_Pos                         8
#define USB0_CAPLENGTH_HCIVERSION_Msk                         (0x0000ffffUL << USB0_CAPLENGTH_HCIVERSION_Pos)

// -------------------------------------  USB0_HCSPARAMS  -----------------------------------------
#define USB0_HCSPARAMS_N_PORTS_Pos                            0
#define USB0_HCSPARAMS_N_PORTS_Msk                            (0x0fUL << USB0_HCSPARAMS_N_PORTS_Pos)
#define USB0_HCSPARAMS_PPC_Pos                                4
#define USB0_HCSPARAMS_PPC_Msk                                (0x01UL << USB0_HCSPARAMS_PPC_Pos)
#define USB0_HCSPARAMS_N_PCC_Pos                              8
#define USB0_HCSPARAMS_N_PCC_Msk                              (0x0fUL << USB0_HCSPARAMS_N_PCC_Pos)
#define USB0_HCSPARAMS_N_CC_Pos                               12
#define USB0_HCSPARAMS_N_CC_Msk                               (0x0fUL << USB0_HCSPARAMS_N_CC_Pos)
#define USB0_HCSPARAMS_PI_Pos                                 16
#define USB0_HCSPARAMS_PI_Msk                                 (0x01UL << USB0_HCSPARAMS_PI_Pos)
#define USB0_HCSPARAMS_N_PTT_Pos                              20
#define USB0_HCSPARAMS_N_PTT_Msk                              (0x0fUL << USB0_HCSPARAMS_N_PTT_Pos)
#define USB0_HCSPARAMS_N_TT_Pos                               24
#define USB0_HCSPARAMS_N_TT_Msk                               (0x0fUL << USB0_HCSPARAMS_N_TT_Pos)

// -------------------------------------  USB0_HCCPARAMS  -----------------------------------------
#define USB0_HCCPARAMS_ADC_Pos                                0
#define USB0_HCCPARAMS_ADC_Msk                                (0x01UL << USB0_HCCPARAMS_ADC_Pos)
#define USB0_HCCPARAMS_PFL_Pos                                1
#define USB0_HCCPARAMS_PFL_Msk                                (0x01UL << USB0_HCCPARAMS_PFL_Pos)
#define USB0_HCCPARAMS_ASP_Pos                                2
#define USB0_HCCPARAMS_ASP_Msk                                (0x01UL << USB0_HCCPARAMS_ASP_Pos)
#define USB0_HCCPARAMS_IST_Pos                                4
#define USB0_HCCPARAMS_IST_Msk                                (0x0fUL << USB0_HCCPARAMS_IST_Pos)
#define USB0_HCCPARAMS_EECP_Pos                               8
#define USB0_HCCPARAMS_EECP_Msk                               (0x000000ffUL << USB0_HCCPARAMS_EECP_Pos)

// -------------------------------------  USB0_DCIVERSION  ----------------------------------------
#define USB0_DCIVERSION_DCIVERSION_Pos                        0
#define USB0_DCIVERSION_DCIVERSION_Msk                        (0x0000ffffUL << USB0_DCIVERSION_DCIVERSION_Pos)

// --------------------------------------  USB0_USBCMD_D  -----------------------------------------
#define USB0_USBCMD_D_RS_Pos                                  0
#define USB0_USBCMD_D_RS_Msk                                  (0x01UL << USB0_USBCMD_D_RS_Pos)
#define USB0_USBCMD_D_RST_Pos                                 1
#define USB0_USBCMD_D_RST_Msk                                 (0x01UL << USB0_USBCMD_D_RST_Pos)
#define USB0_USBCMD_D_SUTW_Pos                                13
#define USB0_USBCMD_D_SUTW_Msk                                (0x01UL << USB0_USBCMD_D_SUTW_Pos)
#define USB0_USBCMD_D_ATDTW_Pos                               14
#define USB0_USBCMD_D_ATDTW_Msk                               (0x01UL << USB0_USBCMD_D_ATDTW_Pos)
#define USB0_USBCMD_D_ITC_Pos                                 16
#define USB0_USBCMD_D_ITC_Msk                                 (0x000000ffUL << USB0_USBCMD_D_ITC_Pos)

// --------------------------------------  USB0_USBCMD_H  -----------------------------------------
#define USB0_USBCMD_H_RS_Pos                                  0
#define USB0_USBCMD_H_RS_Msk                                  (0x01UL << USB0_USBCMD_H_RS_Pos)
#define USB0_USBCMD_H_RST_Pos                                 1
#define USB0_USBCMD_H_RST_Msk                                 (0x01UL << USB0_USBCMD_H_RST_Pos)
#define USB0_USBCMD_H_FS0_Pos                                 2
#define USB0_USBCMD_H_FS0_Msk                                 (0x01UL << USB0_USBCMD_H_FS0_Pos)
#define USB0_USBCMD_H_FS1_Pos                                 3
#define USB0_USBCMD_H_FS1_Msk                                 (0x01UL << USB0_USBCMD_H_FS1_Pos)
#define USB0_USBCMD_H_PSE_Pos                                 4
#define USB0_USBCMD_H_PSE_Msk                                 (0x01UL << USB0_USBCMD_H_PSE_Pos)
#define USB0_USBCMD_H_ASE_Pos                                 5
#define USB0_USBCMD_H_ASE_Msk                                 (0x01UL << USB0_USBCMD_H_ASE_Pos)
#define USB0_USBCMD_H_IAA_Pos                                 6
#define USB0_USBCMD_H_IAA_Msk                                 (0x01UL << USB0_USBCMD_H_IAA_Pos)
#define USB0_USBCMD_H_ASP1_0_Pos                              8
#define USB0_USBCMD_H_ASP1_0_Msk                              (0x03UL << USB0_USBCMD_H_ASP1_0_Pos)
#define USB0_USBCMD_H_ASPE_Pos                                11
#define USB0_USBCMD_H_ASPE_Msk                                (0x01UL << USB0_USBCMD_H_ASPE_Pos)
#define USB0_USBCMD_H_FS2_Pos                                 15
#define USB0_USBCMD_H_FS2_Msk                                 (0x01UL << USB0_USBCMD_H_FS2_Pos)
#define USB0_USBCMD_H_ITC_Pos                                 16
#define USB0_USBCMD_H_ITC_Msk                                 (0x000000ffUL << USB0_USBCMD_H_ITC_Pos)

// --------------------------------------  USB0_USBSTS_D  -----------------------------------------
#define USB0_USBSTS_D_UI_Pos                                  0
#define USB0_USBSTS_D_UI_Msk                                  (0x01UL << USB0_USBSTS_D_UI_Pos)
#define USB0_USBSTS_D_UEI_Pos                                 1
#define USB0_USBSTS_D_UEI_Msk                                 (0x01UL << USB0_USBSTS_D_UEI_Pos)
#define USB0_USBSTS_D_PCI_Pos                                 2
#define USB0_USBSTS_D_PCI_Msk                                 (0x01UL << USB0_USBSTS_D_PCI_Pos)
#define USB0_USBSTS_D_AAI_Pos                                 5
#define USB0_USBSTS_D_AAI_Msk                                 (0x01UL << USB0_USBSTS_D_AAI_Pos)
#define USB0_USBSTS_D_URI_Pos                                 6
#define USB0_USBSTS_D_URI_Msk                                 (0x01UL << USB0_USBSTS_D_URI_Pos)
#define USB0_USBSTS_D_SRI_Pos                                 7
#define USB0_USBSTS_D_SRI_Msk                                 (0x01UL << USB0_USBSTS_D_SRI_Pos)
#define USB0_USBSTS_D_SLI_Pos                                 8
#define USB0_USBSTS_D_SLI_Msk                                 (0x01UL << USB0_USBSTS_D_SLI_Pos)
#define USB0_USBSTS_D_NAKI_Pos                                16
#define USB0_USBSTS_D_NAKI_Msk                                (0x01UL << USB0_USBSTS_D_NAKI_Pos)

// --------------------------------------  USB0_USBSTS_H  -----------------------------------------
#define USB0_USBSTS_H_UI_Pos                                  0
#define USB0_USBSTS_H_UI_Msk                                  (0x01UL << USB0_USBSTS_H_UI_Pos)
#define USB0_USBSTS_H_UEI_Pos                                 1
#define USB0_USBSTS_H_UEI_Msk                                 (0x01UL << USB0_USBSTS_H_UEI_Pos)
#define USB0_USBSTS_H_PCI_Pos                                 2
#define USB0_USBSTS_H_PCI_Msk                                 (0x01UL << USB0_USBSTS_H_PCI_Pos)
#define USB0_USBSTS_H_FRI_Pos                                 3
#define USB0_USBSTS_H_FRI_Msk                                 (0x01UL << USB0_USBSTS_H_FRI_Pos)
#define USB0_USBSTS_H_AAI_Pos                                 5
#define USB0_USBSTS_H_AAI_Msk                                 (0x01UL << USB0_USBSTS_H_AAI_Pos)
#define USB0_USBSTS_H_SRI_Pos                                 7
#define USB0_USBSTS_H_SRI_Msk                                 (0x01UL << USB0_USBSTS_H_SRI_Pos)
#define USB0_USBSTS_H_HCH_Pos                                 12
#define USB0_USBSTS_H_HCH_Msk                                 (0x01UL << USB0_USBSTS_H_HCH_Pos)
#define USB0_USBSTS_H_RCL_Pos                                 13
#define USB0_USBSTS_H_RCL_Msk                                 (0x01UL << USB0_USBSTS_H_RCL_Pos)
#define USB0_USBSTS_H_PS_Pos                                  14
#define USB0_USBSTS_H_PS_Msk                                  (0x01UL << USB0_USBSTS_H_PS_Pos)
#define USB0_USBSTS_H_AS_Pos                                  15
#define USB0_USBSTS_H_AS_Msk                                  (0x01UL << USB0_USBSTS_H_AS_Pos)
#define USB0_USBSTS_H_UAI_Pos                                 18
#define USB0_USBSTS_H_UAI_Msk                                 (0x01UL << USB0_USBSTS_H_UAI_Pos)
#define USB0_USBSTS_H_UPI_Pos                                 19
#define USB0_USBSTS_H_UPI_Msk                                 (0x01UL << USB0_USBSTS_H_UPI_Pos)

// -------------------------------------  USB0_USBINTR_D  -----------------------------------------
#define USB0_USBINTR_D_UE_Pos                                 0
#define USB0_USBINTR_D_UE_Msk                                 (0x01UL << USB0_USBINTR_D_UE_Pos)
#define USB0_USBINTR_D_UEE_Pos                                1
#define USB0_USBINTR_D_UEE_Msk                                (0x01UL << USB0_USBINTR_D_UEE_Pos)
#define USB0_USBINTR_D_PCE_Pos                                2
#define USB0_USBINTR_D_PCE_Msk                                (0x01UL << USB0_USBINTR_D_PCE_Pos)
#define USB0_USBINTR_D_URE_Pos                                6
#define USB0_USBINTR_D_URE_Msk                                (0x01UL << USB0_USBINTR_D_URE_Pos)
#define USB0_USBINTR_D_SRE_Pos                                7
#define USB0_USBINTR_D_SRE_Msk                                (0x01UL << USB0_USBINTR_D_SRE_Pos)
#define USB0_USBINTR_D_SLE_Pos                                8
#define USB0_USBINTR_D_SLE_Msk                                (0x01UL << USB0_USBINTR_D_SLE_Pos)
#define USB0_USBINTR_D_NAKE_Pos                               16
#define USB0_USBINTR_D_NAKE_Msk                               (0x01UL << USB0_USBINTR_D_NAKE_Pos)

// -------------------------------------  USB0_USBINTR_H  -----------------------------------------
#define USB0_USBINTR_H_UE_Pos                                 0
#define USB0_USBINTR_H_UE_Msk                                 (0x01UL << USB0_USBINTR_H_UE_Pos)
#define USB0_USBINTR_H_UEE_Pos                                1
#define USB0_USBINTR_H_UEE_Msk                                (0x01UL << USB0_USBINTR_H_UEE_Pos)
#define USB0_USBINTR_H_PCE_Pos                                2
#define USB0_USBINTR_H_PCE_Msk                                (0x01UL << USB0_USBINTR_H_PCE_Pos)
#define USB0_USBINTR_H_FRE_Pos                                3
#define USB0_USBINTR_H_FRE_Msk                                (0x01UL << USB0_USBINTR_H_FRE_Pos)
#define USB0_USBINTR_H_AAE_Pos                                5
#define USB0_USBINTR_H_AAE_Msk                                (0x01UL << USB0_USBINTR_H_AAE_Pos)
#define USB0_USBINTR_H_SRE_Pos                                7
#define USB0_USBINTR_H_SRE_Msk                                (0x01UL << USB0_USBINTR_H_SRE_Pos)
#define USB0_USBINTR_H_UAIE_Pos                               18
#define USB0_USBINTR_H_UAIE_Msk                               (0x01UL << USB0_USBINTR_H_UAIE_Pos)
#define USB0_USBINTR_H_UPIA_Pos                               19
#define USB0_USBINTR_H_UPIA_Msk                               (0x01UL << USB0_USBINTR_H_UPIA_Pos)

// -------------------------------------  USB0_FRINDEX_D  -----------------------------------------
#define USB0_FRINDEX_D_FRINDEX2_0_Pos                         0
#define USB0_FRINDEX_D_FRINDEX2_0_Msk                         (0x07UL << USB0_FRINDEX_D_FRINDEX2_0_Pos)
#define USB0_FRINDEX_D_FRINDEX13_3_Pos                        3
#define USB0_FRINDEX_D_FRINDEX13_3_Msk                        (0x000007ffUL << USB0_FRINDEX_D_FRINDEX13_3_Pos)

// -------------------------------------  USB0_FRINDEX_H  -----------------------------------------
#define USB0_FRINDEX_H_FRINDEX2_0_Pos                         0
#define USB0_FRINDEX_H_FRINDEX2_0_Msk                         (0x07UL << USB0_FRINDEX_H_FRINDEX2_0_Pos)
#define USB0_FRINDEX_H_FRINDEX12_3_Pos                        3
#define USB0_FRINDEX_H_FRINDEX12_3_Msk                        (0x000003ffUL << USB0_FRINDEX_H_FRINDEX12_3_Pos)

// -------------------------------------  USB0_DEVICEADDR  ----------------------------------------
#define USB0_DEVICEADDR_USBADRA_Pos                           24
#define USB0_DEVICEADDR_USBADRA_Msk                           (0x01UL << USB0_DEVICEADDR_USBADRA_Pos)
#define USB0_DEVICEADDR_USBADR_Pos                            25
#define USB0_DEVICEADDR_USBADR_Msk                            (0x7fUL << USB0_DEVICEADDR_USBADR_Pos)

// ----------------------------------  USB0_PERIODICLISTBASE  -------------------------------------
#define USB0_PERIODICLISTBASE_PERBASE31_12_Pos                12
#define USB0_PERIODICLISTBASE_PERBASE31_12_Msk                (0x000fffffUL << USB0_PERIODICLISTBASE_PERBASE31_12_Pos)

// ----------------------------------  USB0_ENDPOINTLISTADDR  -------------------------------------
#define USB0_ENDPOINTLISTADDR_EPBASE31_11_Pos                 11
#define USB0_ENDPOINTLISTADDR_EPBASE31_11_Msk                 (0x001fffffUL << USB0_ENDPOINTLISTADDR_EPBASE31_11_Pos)

// -----------------------------------  USB0_ASYNCLISTADDR  ---------------------------------------
#define USB0_ASYNCLISTADDR_ASYBASE31_5_Pos                    5
#define USB0_ASYNCLISTADDR_ASYBASE31_5_Msk                    (0x07ffffffUL << USB0_ASYNCLISTADDR_ASYBASE31_5_Pos)

// ---------------------------------------  USB0_TTCTRL  ------------------------------------------
#define USB0_TTCTRL_TTHA_Pos                                  24
#define USB0_TTCTRL_TTHA_Msk                                  (0x7fUL << USB0_TTCTRL_TTHA_Pos)

// -------------------------------------  USB0_BURSTSIZE  -----------------------------------------
#define USB0_BURSTSIZE_RXPBURST_Pos                           0
#define USB0_BURSTSIZE_RXPBURST_Msk                           (0x000000ffUL << USB0_BURSTSIZE_RXPBURST_Pos)
#define USB0_BURSTSIZE_TXPBURST_Pos                           8
#define USB0_BURSTSIZE_TXPBURST_Msk                           (0x000000ffUL << USB0_BURSTSIZE_TXPBURST_Pos)

// ------------------------------------  USB0_TXFILLTUNING  ---------------------------------------
#define USB0_TXFILLTUNING_TXSCHOH_Pos                         0
#define USB0_TXFILLTUNING_TXSCHOH_Msk                         (0x000000ffUL << USB0_TXFILLTUNING_TXSCHOH_Pos)
#define USB0_TXFILLTUNING_TXSCHEATLTH_Pos                     8
#define USB0_TXFILLTUNING_TXSCHEATLTH_Msk                     (0x1fUL << USB0_TXFILLTUNING_TXSCHEATLTH_Pos)
#define USB0_TXFILLTUNING_TXFIFOTHRES_Pos                     16
#define USB0_TXFILLTUNING_TXFIFOTHRES_Msk                     (0x3fUL << USB0_TXFILLTUNING_TXFIFOTHRES_Pos)

// -------------------------------------  USB0_BINTERVAL  -----------------------------------------
#define USB0_BINTERVAL_BINT_Pos                               0
#define USB0_BINTERVAL_BINT_Msk                               (0x0fUL << USB0_BINTERVAL_BINT_Pos)

// --------------------------------------  USB0_ENDPTNAK  -----------------------------------------
#define USB0_ENDPTNAK_EPRN0_Pos                               0
#define USB0_ENDPTNAK_EPRN0_Msk                               (0x01UL << USB0_ENDPTNAK_EPRN0_Pos)
#define USB0_ENDPTNAK_EPRN1_Pos                               1
#define USB0_ENDPTNAK_EPRN1_Msk                               (0x01UL << USB0_ENDPTNAK_EPRN1_Pos)
#define USB0_ENDPTNAK_EPRN2_Pos                               2
#define USB0_ENDPTNAK_EPRN2_Msk                               (0x01UL << USB0_ENDPTNAK_EPRN2_Pos)
#define USB0_ENDPTNAK_EPRN3_Pos                               3
#define USB0_ENDPTNAK_EPRN3_Msk                               (0x01UL << USB0_ENDPTNAK_EPRN3_Pos)
#define USB0_ENDPTNAK_EPRN4_Pos                               4
#define USB0_ENDPTNAK_EPRN4_Msk                               (0x01UL << USB0_ENDPTNAK_EPRN4_Pos)
#define USB0_ENDPTNAK_EPRN5_Pos                               5
#define USB0_ENDPTNAK_EPRN5_Msk                               (0x01UL << USB0_ENDPTNAK_EPRN5_Pos)
#define USB0_ENDPTNAK_EPTN0_Pos                               16
#define USB0_ENDPTNAK_EPTN0_Msk                               (0x01UL << USB0_ENDPTNAK_EPTN0_Pos)
#define USB0_ENDPTNAK_EPTN1_Pos                               17
#define USB0_ENDPTNAK_EPTN1_Msk                               (0x01UL << USB0_ENDPTNAK_EPTN1_Pos)
#define USB0_ENDPTNAK_EPTN2_Pos                               18
#define USB0_ENDPTNAK_EPTN2_Msk                               (0x01UL << USB0_ENDPTNAK_EPTN2_Pos)
#define USB0_ENDPTNAK_EPTN3_Pos                               19
#define USB0_ENDPTNAK_EPTN3_Msk                               (0x01UL << USB0_ENDPTNAK_EPTN3_Pos)
#define USB0_ENDPTNAK_EPTN4_Pos                               20
#define USB0_ENDPTNAK_EPTN4_Msk                               (0x01UL << USB0_ENDPTNAK_EPTN4_Pos)
#define USB0_ENDPTNAK_EPTN5_Pos                               21
#define USB0_ENDPTNAK_EPTN5_Msk                               (0x01UL << USB0_ENDPTNAK_EPTN5_Pos)

// -------------------------------------  USB0_ENDPTNAKEN  ----------------------------------------
#define USB0_ENDPTNAKEN_EPRNE0_Pos                            0
#define USB0_ENDPTNAKEN_EPRNE0_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPRNE0_Pos)
#define USB0_ENDPTNAKEN_EPRNE1_Pos                            1
#define USB0_ENDPTNAKEN_EPRNE1_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPRNE1_Pos)
#define USB0_ENDPTNAKEN_EPRNE2_Pos                            2
#define USB0_ENDPTNAKEN_EPRNE2_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPRNE2_Pos)
#define USB0_ENDPTNAKEN_EPRNE3_Pos                            3
#define USB0_ENDPTNAKEN_EPRNE3_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPRNE3_Pos)
#define USB0_ENDPTNAKEN_EPRNE4_Pos                            4
#define USB0_ENDPTNAKEN_EPRNE4_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPRNE4_Pos)
#define USB0_ENDPTNAKEN_EPRNE5_Pos                            5
#define USB0_ENDPTNAKEN_EPRNE5_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPRNE5_Pos)
#define USB0_ENDPTNAKEN_EPTNE0_Pos                            16
#define USB0_ENDPTNAKEN_EPTNE0_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPTNE0_Pos)
#define USB0_ENDPTNAKEN_EPTNE1_Pos                            17
#define USB0_ENDPTNAKEN_EPTNE1_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPTNE1_Pos)
#define USB0_ENDPTNAKEN_EPTNE2_Pos                            18
#define USB0_ENDPTNAKEN_EPTNE2_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPTNE2_Pos)
#define USB0_ENDPTNAKEN_EPTNE3_Pos                            19
#define USB0_ENDPTNAKEN_EPTNE3_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPTNE3_Pos)
#define USB0_ENDPTNAKEN_EPTNE4_Pos                            20
#define USB0_ENDPTNAKEN_EPTNE4_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPTNE4_Pos)
#define USB0_ENDPTNAKEN_EPTNE5_Pos                            21
#define USB0_ENDPTNAKEN_EPTNE5_Msk                            (0x01UL << USB0_ENDPTNAKEN_EPTNE5_Pos)

// -------------------------------------  USB0_PORTSC1_D  -----------------------------------------
#define USB0_PORTSC1_D_CCS_Pos                                0
#define USB0_PORTSC1_D_CCS_Msk                                (0x01UL << USB0_PORTSC1_D_CCS_Pos)
#define USB0_PORTSC1_D_PE_Pos                                 2
#define USB0_PORTSC1_D_PE_Msk                                 (0x01UL << USB0_PORTSC1_D_PE_Pos)
#define USB0_PORTSC1_D_PEC_Pos                                3
#define USB0_PORTSC1_D_PEC_Msk                                (0x01UL << USB0_PORTSC1_D_PEC_Pos)
#define USB0_PORTSC1_D_FPR_Pos                                6
#define USB0_PORTSC1_D_FPR_Msk                                (0x01UL << USB0_PORTSC1_D_FPR_Pos)
#define USB0_PORTSC1_D_SUSP_Pos                               7
#define USB0_PORTSC1_D_SUSP_Msk                               (0x01UL << USB0_PORTSC1_D_SUSP_Pos)
#define USB0_PORTSC1_D_PR_Pos                                 8
#define USB0_PORTSC1_D_PR_Msk                                 (0x01UL << USB0_PORTSC1_D_PR_Pos)
#define USB0_PORTSC1_D_HSP_Pos                                9
#define USB0_PORTSC1_D_HSP_Msk                                (0x01UL << USB0_PORTSC1_D_HSP_Pos)
#define USB0_PORTSC1_D_PIC1_0_Pos                             14
#define USB0_PORTSC1_D_PIC1_0_Msk                             (0x03UL << USB0_PORTSC1_D_PIC1_0_Pos)
#define USB0_PORTSC1_D_PTC3_0_Pos                             16
#define USB0_PORTSC1_D_PTC3_0_Msk                             (0x0fUL << USB0_PORTSC1_D_PTC3_0_Pos)
#define USB0_PORTSC1_D_PHCD_Pos                               23
#define USB0_PORTSC1_D_PHCD_Msk                               (0x01UL << USB0_PORTSC1_D_PHCD_Pos)
#define USB0_PORTSC1_D_PFSC_Pos                               24
#define USB0_PORTSC1_D_PFSC_Msk                               (0x01UL << USB0_PORTSC1_D_PFSC_Pos)
#define USB0_PORTSC1_D_PSPD_Pos                               26
#define USB0_PORTSC1_D_PSPD_Msk                               (0x03UL << USB0_PORTSC1_D_PSPD_Pos)

// -------------------------------------  USB0_PORTSC1_H  -----------------------------------------
#define USB0_PORTSC1_H_CCS_Pos                                0
#define USB0_PORTSC1_H_CCS_Msk                                (0x01UL << USB0_PORTSC1_H_CCS_Pos)
#define USB0_PORTSC1_H_CSC_Pos                                1
#define USB0_PORTSC1_H_CSC_Msk                                (0x01UL << USB0_PORTSC1_H_CSC_Pos)
#define USB0_PORTSC1_H_PE_Pos                                 2
#define USB0_PORTSC1_H_PE_Msk                                 (0x01UL << USB0_PORTSC1_H_PE_Pos)
#define USB0_PORTSC1_H_PEC_Pos                                3
#define USB0_PORTSC1_H_PEC_Msk                                (0x01UL << USB0_PORTSC1_H_PEC_Pos)
#define USB0_PORTSC1_H_OCA_Pos                                4
#define USB0_PORTSC1_H_OCA_Msk                                (0x01UL << USB0_PORTSC1_H_OCA_Pos)
#define USB0_PORTSC1_H_OCC_Pos                                5
#define USB0_PORTSC1_H_OCC_Msk                                (0x01UL << USB0_PORTSC1_H_OCC_Pos)
#define USB0_PORTSC1_H_FPR_Pos                                6
#define USB0_PORTSC1_H_FPR_Msk                                (0x01UL << USB0_PORTSC1_H_FPR_Pos)
#define USB0_PORTSC1_H_SUSP_Pos                               7
#define USB0_PORTSC1_H_SUSP_Msk                               (0x01UL << USB0_PORTSC1_H_SUSP_Pos)
#define USB0_PORTSC1_H_PR_Pos                                 8
#define USB0_PORTSC1_H_PR_Msk                                 (0x01UL << USB0_PORTSC1_H_PR_Pos)
#define USB0_PORTSC1_H_HSP_Pos                                9
#define USB0_PORTSC1_H_HSP_Msk                                (0x01UL << USB0_PORTSC1_H_HSP_Pos)
#define USB0_PORTSC1_H_LS_Pos                                 10
#define USB0_PORTSC1_H_LS_Msk                                 (0x03UL << USB0_PORTSC1_H_LS_Pos)
#define USB0_PORTSC1_H_PP_Pos                                 12
#define USB0_PORTSC1_H_PP_Msk                                 (0x01UL << USB0_PORTSC1_H_PP_Pos)
#define USB0_PORTSC1_H_PIC1_0_Pos                             14
#define USB0_PORTSC1_H_PIC1_0_Msk                             (0x03UL << USB0_PORTSC1_H_PIC1_0_Pos)
#define USB0_PORTSC1_H_PTC3_0_Pos                             16
#define USB0_PORTSC1_H_PTC3_0_Msk                             (0x0fUL << USB0_PORTSC1_H_PTC3_0_Pos)
#define USB0_PORTSC1_H_WKCN_Pos                               20
#define USB0_PORTSC1_H_WKCN_Msk                               (0x01UL << USB0_PORTSC1_H_WKCN_Pos)
#define USB0_PORTSC1_H_WKDC_Pos                               21
#define USB0_PORTSC1_H_WKDC_Msk                               (0x01UL << USB0_PORTSC1_H_WKDC_Pos)
#define USB0_PORTSC1_H_WKOC_Pos                               22
#define USB0_PORTSC1_H_WKOC_Msk                               (0x01UL << USB0_PORTSC1_H_WKOC_Pos)
#define USB0_PORTSC1_H_PHCD_Pos                               23
#define USB0_PORTSC1_H_PHCD_Msk                               (0x01UL << USB0_PORTSC1_H_PHCD_Pos)
#define USB0_PORTSC1_H_PFSC_Pos                               24
#define USB0_PORTSC1_H_PFSC_Msk                               (0x01UL << USB0_PORTSC1_H_PFSC_Pos)
#define USB0_PORTSC1_H_PSPD_Pos                               26
#define USB0_PORTSC1_H_PSPD_Msk                               (0x03UL << USB0_PORTSC1_H_PSPD_Pos)

// ---------------------------------------  USB0_OTGSC  -------------------------------------------
#define USB0_OTGSC_VD_Pos                                     0
#define USB0_OTGSC_VD_Msk                                     (0x01UL << USB0_OTGSC_VD_Pos)
#define USB0_OTGSC_VC_Pos                                     1
#define USB0_OTGSC_VC_Msk                                     (0x01UL << USB0_OTGSC_VC_Pos)
#define USB0_OTGSC_HAAR_Pos                                   2
#define USB0_OTGSC_HAAR_Msk                                   (0x01UL << USB0_OTGSC_HAAR_Pos)
#define USB0_OTGSC_OT_Pos                                     3
#define USB0_OTGSC_OT_Msk                                     (0x01UL << USB0_OTGSC_OT_Pos)
#define USB0_OTGSC_DP_Pos                                     4
#define USB0_OTGSC_DP_Msk                                     (0x01UL << USB0_OTGSC_DP_Pos)
#define USB0_OTGSC_IDPU_Pos                                   5
#define USB0_OTGSC_IDPU_Msk                                   (0x01UL << USB0_OTGSC_IDPU_Pos)
#define USB0_OTGSC_HADP_Pos                                   6
#define USB0_OTGSC_HADP_Msk                                   (0x01UL << USB0_OTGSC_HADP_Pos)
#define USB0_OTGSC_HABA_Pos                                   7
#define USB0_OTGSC_HABA_Msk                                   (0x01UL << USB0_OTGSC_HABA_Pos)
#define USB0_OTGSC_ID_Pos                                     8
#define USB0_OTGSC_ID_Msk                                     (0x01UL << USB0_OTGSC_ID_Pos)
#define USB0_OTGSC_AVV_Pos                                    9
#define USB0_OTGSC_AVV_Msk                                    (0x01UL << USB0_OTGSC_AVV_Pos)
#define USB0_OTGSC_ASV_Pos                                    10
#define USB0_OTGSC_ASV_Msk                                    (0x01UL << USB0_OTGSC_ASV_Pos)
#define USB0_OTGSC_BSV_Pos                                    11
#define USB0_OTGSC_BSV_Msk                                    (0x01UL << USB0_OTGSC_BSV_Pos)
#define USB0_OTGSC_BSE_Pos                                    12
#define USB0_OTGSC_BSE_Msk                                    (0x01UL << USB0_OTGSC_BSE_Pos)
#define USB0_OTGSC_MS1T_Pos                                   13
#define USB0_OTGSC_MS1T_Msk                                   (0x01UL << USB0_OTGSC_MS1T_Pos)
#define USB0_OTGSC_DPS_Pos                                    14
#define USB0_OTGSC_DPS_Msk                                    (0x01UL << USB0_OTGSC_DPS_Pos)
#define USB0_OTGSC_IDIS_Pos                                   16
#define USB0_OTGSC_IDIS_Msk                                   (0x01UL << USB0_OTGSC_IDIS_Pos)
#define USB0_OTGSC_AVVIS_Pos                                  17
#define USB0_OTGSC_AVVIS_Msk                                  (0x01UL << USB0_OTGSC_AVVIS_Pos)
#define USB0_OTGSC_ASVIS_Pos                                  18
#define USB0_OTGSC_ASVIS_Msk                                  (0x01UL << USB0_OTGSC_ASVIS_Pos)
#define USB0_OTGSC_BSVIS_Pos                                  19
#define USB0_OTGSC_BSVIS_Msk                                  (0x01UL << USB0_OTGSC_BSVIS_Pos)
#define USB0_OTGSC_BSEIS_Pos                                  20
#define USB0_OTGSC_BSEIS_Msk                                  (0x01UL << USB0_OTGSC_BSEIS_Pos)
#define USB0_OTGSC_ms1S_Pos                                   21
#define USB0_OTGSC_ms1S_Msk                                   (0x01UL << USB0_OTGSC_ms1S_Pos)
#define USB0_OTGSC_DPIS_Pos                                   22
#define USB0_OTGSC_DPIS_Msk                                   (0x01UL << USB0_OTGSC_DPIS_Pos)
#define USB0_OTGSC_IDIE_Pos                                   24
#define USB0_OTGSC_IDIE_Msk                                   (0x01UL << USB0_OTGSC_IDIE_Pos)
#define USB0_OTGSC_AVVIE_Pos                                  25
#define USB0_OTGSC_AVVIE_Msk                                  (0x01UL << USB0_OTGSC_AVVIE_Pos)
#define USB0_OTGSC_ASVIE_Pos                                  26
#define USB0_OTGSC_ASVIE_Msk                                  (0x01UL << USB0_OTGSC_ASVIE_Pos)
#define USB0_OTGSC_BSVIE_Pos                                  27
#define USB0_OTGSC_BSVIE_Msk                                  (0x01UL << USB0_OTGSC_BSVIE_Pos)
#define USB0_OTGSC_BSEIE_Pos                                  28
#define USB0_OTGSC_BSEIE_Msk                                  (0x01UL << USB0_OTGSC_BSEIE_Pos)
#define USB0_OTGSC_MS1E_Pos                                   29
#define USB0_OTGSC_MS1E_Msk                                   (0x01UL << USB0_OTGSC_MS1E_Pos)
#define USB0_OTGSC_DPIE_Pos                                   30
#define USB0_OTGSC_DPIE_Msk                                   (0x01UL << USB0_OTGSC_DPIE_Pos)

// -------------------------------------  USB0_USBMODE_D  -----------------------------------------
#define USB0_USBMODE_D_CM1_0_Pos                              0
#define USB0_USBMODE_D_CM1_0_Msk                              (0x03UL << USB0_USBMODE_D_CM1_0_Pos)
#define USB0_USBMODE_D_ES_Pos                                 2
#define USB0_USBMODE_D_ES_Msk                                 (0x01UL << USB0_USBMODE_D_ES_Pos)
#define USB0_USBMODE_D_SLOM_Pos                               3
#define USB0_USBMODE_D_SLOM_Msk                               (0x01UL << USB0_USBMODE_D_SLOM_Pos)
#define USB0_USBMODE_D_SDIS_Pos                               4
#define USB0_USBMODE_D_SDIS_Msk                               (0x01UL << USB0_USBMODE_D_SDIS_Pos)

// -------------------------------------  USB0_USBMODE_H  -----------------------------------------
#define USB0_USBMODE_H_CM_Pos                                 0
#define USB0_USBMODE_H_CM_Msk                                 (0x03UL << USB0_USBMODE_H_CM_Pos)
#define USB0_USBMODE_H_ES_Pos                                 2
#define USB0_USBMODE_H_ES_Msk                                 (0x01UL << USB0_USBMODE_H_ES_Pos)
#define USB0_USBMODE_H_SDIS_Pos                               4
#define USB0_USBMODE_H_SDIS_Msk                               (0x01UL << USB0_USBMODE_H_SDIS_Pos)
#define USB0_USBMODE_H_VBPS_Pos                               5
#define USB0_USBMODE_H_VBPS_Msk                               (0x01UL << USB0_USBMODE_H_VBPS_Pos)

// -----------------------------------  USB0_ENDPTSETUPSTAT  --------------------------------------
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT0_Pos               0
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT0_Msk               (0x01UL << USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT0_Pos)
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT1_Pos               1
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT1_Msk               (0x01UL << USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT1_Pos)
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT2_Pos               2
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT2_Msk               (0x01UL << USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT2_Pos)
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT3_Pos               3
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT3_Msk               (0x01UL << USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT3_Pos)
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT4_Pos               4
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT4_Msk               (0x01UL << USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT4_Pos)
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT5_Pos               5
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT5_Msk               (0x01UL << USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT5_Pos)

// -------------------------------------  USB0_ENDPTPRIME  ----------------------------------------
#define USB0_ENDPTPRIME_PERB0_Pos                             0
#define USB0_ENDPTPRIME_PERB0_Msk                             (0x01UL << USB0_ENDPTPRIME_PERB0_Pos)
#define USB0_ENDPTPRIME_PERB1_Pos                             1
#define USB0_ENDPTPRIME_PERB1_Msk                             (0x01UL << USB0_ENDPTPRIME_PERB1_Pos)
#define USB0_ENDPTPRIME_PERB2_Pos                             2
#define USB0_ENDPTPRIME_PERB2_Msk                             (0x01UL << USB0_ENDPTPRIME_PERB2_Pos)
#define USB0_ENDPTPRIME_PERB3_Pos                             3
#define USB0_ENDPTPRIME_PERB3_Msk                             (0x01UL << USB0_ENDPTPRIME_PERB3_Pos)
#define USB0_ENDPTPRIME_PERB4_Pos                             4
#define USB0_ENDPTPRIME_PERB4_Msk                             (0x01UL << USB0_ENDPTPRIME_PERB4_Pos)
#define USB0_ENDPTPRIME_PERB5_Pos                             5
#define USB0_ENDPTPRIME_PERB5_Msk                             (0x01UL << USB0_ENDPTPRIME_PERB5_Pos)
#define USB0_ENDPTPRIME_PETB0_Pos                             16
#define USB0_ENDPTPRIME_PETB0_Msk                             (0x01UL << USB0_ENDPTPRIME_PETB0_Pos)
#define USB0_ENDPTPRIME_PETB1_Pos                             17
#define USB0_ENDPTPRIME_PETB1_Msk                             (0x01UL << USB0_ENDPTPRIME_PETB1_Pos)
#define USB0_ENDPTPRIME_PETB2_Pos                             18
#define USB0_ENDPTPRIME_PETB2_Msk                             (0x01UL << USB0_ENDPTPRIME_PETB2_Pos)
#define USB0_ENDPTPRIME_PETB3_Pos                             19
#define USB0_ENDPTPRIME_PETB3_Msk                             (0x01UL << USB0_ENDPTPRIME_PETB3_Pos)
#define USB0_ENDPTPRIME_PETB4_Pos                             20
#define USB0_ENDPTPRIME_PETB4_Msk                             (0x01UL << USB0_ENDPTPRIME_PETB4_Pos)
#define USB0_ENDPTPRIME_PETB5_Pos                             21
#define USB0_ENDPTPRIME_PETB5_Msk                             (0x01UL << USB0_ENDPTPRIME_PETB5_Pos)

// -------------------------------------  USB0_ENDPTFLUSH  ----------------------------------------
#define USB0_ENDPTFLUSH_FERB0_Pos                             0
#define USB0_ENDPTFLUSH_FERB0_Msk                             (0x01UL << USB0_ENDPTFLUSH_FERB0_Pos)
#define USB0_ENDPTFLUSH_FERB1_Pos                             1
#define USB0_ENDPTFLUSH_FERB1_Msk                             (0x01UL << USB0_ENDPTFLUSH_FERB1_Pos)
#define USB0_ENDPTFLUSH_FERB2_Pos                             2
#define USB0_ENDPTFLUSH_FERB2_Msk                             (0x01UL << USB0_ENDPTFLUSH_FERB2_Pos)
#define USB0_ENDPTFLUSH_FERB3_Pos                             3
#define USB0_ENDPTFLUSH_FERB3_Msk                             (0x01UL << USB0_ENDPTFLUSH_FERB3_Pos)
#define USB0_ENDPTFLUSH_FERB4_Pos                             4
#define USB0_ENDPTFLUSH_FERB4_Msk                             (0x01UL << USB0_ENDPTFLUSH_FERB4_Pos)
#define USB0_ENDPTFLUSH_FERB5_Pos                             5
#define USB0_ENDPTFLUSH_FERB5_Msk                             (0x01UL << USB0_ENDPTFLUSH_FERB5_Pos)
#define USB0_ENDPTFLUSH_FETB0_Pos                             16
#define USB0_ENDPTFLUSH_FETB0_Msk                             (0x01UL << USB0_ENDPTFLUSH_FETB0_Pos)
#define USB0_ENDPTFLUSH_FETB1_Pos                             17
#define USB0_ENDPTFLUSH_FETB1_Msk                             (0x01UL << USB0_ENDPTFLUSH_FETB1_Pos)
#define USB0_ENDPTFLUSH_FETB2_Pos                             18
#define USB0_ENDPTFLUSH_FETB2_Msk                             (0x01UL << USB0_ENDPTFLUSH_FETB2_Pos)
#define USB0_ENDPTFLUSH_FETB3_Pos                             19
#define USB0_ENDPTFLUSH_FETB3_Msk                             (0x01UL << USB0_ENDPTFLUSH_FETB3_Pos)
#define USB0_ENDPTFLUSH_FETB4_Pos                             20
#define USB0_ENDPTFLUSH_FETB4_Msk                             (0x01UL << USB0_ENDPTFLUSH_FETB4_Pos)
#define USB0_ENDPTFLUSH_FETB5_Pos                             21
#define USB0_ENDPTFLUSH_FETB5_Msk                             (0x01UL << USB0_ENDPTFLUSH_FETB5_Pos)

// -------------------------------------  USB0_ENDPTSTAT  -----------------------------------------
#define USB0_ENDPTSTAT_ERBR0_Pos                              0
#define USB0_ENDPTSTAT_ERBR0_Msk                              (0x01UL << USB0_ENDPTSTAT_ERBR0_Pos)
#define USB0_ENDPTSTAT_ERBR1_Pos                              1
#define USB0_ENDPTSTAT_ERBR1_Msk                              (0x01UL << USB0_ENDPTSTAT_ERBR1_Pos)
#define USB0_ENDPTSTAT_ERBR2_Pos                              2
#define USB0_ENDPTSTAT_ERBR2_Msk                              (0x01UL << USB0_ENDPTSTAT_ERBR2_Pos)
#define USB0_ENDPTSTAT_ERBR3_Pos                              3
#define USB0_ENDPTSTAT_ERBR3_Msk                              (0x01UL << USB0_ENDPTSTAT_ERBR3_Pos)
#define USB0_ENDPTSTAT_ERBR4_Pos                              4
#define USB0_ENDPTSTAT_ERBR4_Msk                              (0x01UL << USB0_ENDPTSTAT_ERBR4_Pos)
#define USB0_ENDPTSTAT_ERBR5_Pos                              5
#define USB0_ENDPTSTAT_ERBR5_Msk                              (0x01UL << USB0_ENDPTSTAT_ERBR5_Pos)
#define USB0_ENDPTSTAT_ETBR0_Pos                              16
#define USB0_ENDPTSTAT_ETBR0_Msk                              (0x01UL << USB0_ENDPTSTAT_ETBR0_Pos)
#define USB0_ENDPTSTAT_ETBR1_Pos                              17
#define USB0_ENDPTSTAT_ETBR1_Msk                              (0x01UL << USB0_ENDPTSTAT_ETBR1_Pos)
#define USB0_ENDPTSTAT_ETBR2_Pos                              18
#define USB0_ENDPTSTAT_ETBR2_Msk                              (0x01UL << USB0_ENDPTSTAT_ETBR2_Pos)
#define USB0_ENDPTSTAT_ETBR3_Pos                              19
#define USB0_ENDPTSTAT_ETBR3_Msk                              (0x01UL << USB0_ENDPTSTAT_ETBR3_Pos)
#define USB0_ENDPTSTAT_ETBR4_Pos                              20
#define USB0_ENDPTSTAT_ETBR4_Msk                              (0x01UL << USB0_ENDPTSTAT_ETBR4_Pos)
#define USB0_ENDPTSTAT_ETBR5_Pos                              21
#define USB0_ENDPTSTAT_ETBR5_Msk                              (0x01UL << USB0_ENDPTSTAT_ETBR5_Pos)

// -----------------------------------  USB0_ENDPTCOMPLETE  ---------------------------------------
#define USB0_ENDPTCOMPLETE_ERCE0_Pos                          0
#define USB0_ENDPTCOMPLETE_ERCE0_Msk                          (0x01UL << USB0_ENDPTCOMPLETE_ERCE0_Pos)
#define USB0_ENDPTCOMPLETE_ERCE1_Pos                          1
#define USB0_ENDPTCOMPLETE_ERCE1_Msk                          (0x01UL << USB0_ENDPTCOMPLETE_ERCE1_Pos)
#define USB0_ENDPTCOMPLETE_ERCE2_Pos                          2
#define USB0_ENDPTCOMPLETE_ERCE2_Msk                          (0x01UL << USB0_ENDPTCOMPLETE_ERCE2_Pos)
#define USB0_ENDPTCOMPLETE_ERCE3_Pos                          3
#define USB0_ENDPTCOMPLETE_ERCE3_Msk                          (0x01UL << USB0_ENDPTCOMPLETE_ERCE3_Pos)
#define USB0_ENDPTCOMPLETE_ERCE4_Pos                          4
#define USB0_ENDPTCOMPLETE_ERCE4_Msk                          (0x01UL << USB0_ENDPTCOMPLETE_ERCE4_Pos)
#define USB0_ENDPTCOMPLETE_ERCE5_Pos                          5
#define USB0_ENDPTCOMPLETE_ERCE5_Msk                          (0x01UL << USB0_ENDPTCOMPLETE_ERCE5_Pos)
#define USB0_ENDPTCOMPLETE_ETCE0_Pos                          16
#define USB0_ENDPTCOMPLETE_ETCE0_Msk                          (0x01UL << USB0_ENDPTCOMPLETE_ETCE0_Pos)
#define USB0_ENDPTCOMPLETE_ETCE1_Pos                          17
#define USB0_ENDPTCOMPLETE_ETCE1_Msk                          (0x01UL << USB0_ENDPTCOMPLETE_ETCE1_Pos)
#define USB0_ENDPTCOMPLETE_ETCE2_Pos                          18
#define USB0_ENDPTCOMPLETE_ETCE2_Msk                          (0x01UL << USB0_ENDPTCOMPLETE_ETCE2_Pos)
#define USB0_ENDPTCOMPLETE_ETCE3_Pos                          19
#define USB0_ENDPTCOMPLETE_ETCE3_Msk                          (0x01UL << USB0_ENDPTCOMPLETE_ETCE3_Pos)
#define USB0_ENDPTCOMPLETE_ETCE4_Pos                          20
#define USB0_ENDPTCOMPLETE_ETCE4_Msk                          (0x01UL << USB0_ENDPTCOMPLETE_ETCE4_Pos)
#define USB0_ENDPTCOMPLETE_ETCE5_Pos                          21
#define USB0_ENDPTCOMPLETE_ETCE5_Msk                          (0x01UL << USB0_ENDPTCOMPLETE_ETCE5_Pos)

// -------------------------------------  USB0_ENDPTCTRL0  ----------------------------------------
#define USB0_ENDPTCTRL0_RXS_Pos                               0
#define USB0_ENDPTCTRL0_RXS_Msk                               (0x01UL << USB0_ENDPTCTRL0_RXS_Pos)
#define USB0_ENDPTCTRL0_RXT1_0_Pos                            2
#define USB0_ENDPTCTRL0_RXT1_0_Msk                            (0x03UL << USB0_ENDPTCTRL0_RXT1_0_Pos)
#define USB0_ENDPTCTRL0_RXE_Pos                               7
#define USB0_ENDPTCTRL0_RXE_Msk                               (0x01UL << USB0_ENDPTCTRL0_RXE_Pos)
#define USB0_ENDPTCTRL0_TXS_Pos                               16
#define USB0_ENDPTCTRL0_TXS_Msk                               (0x01UL << USB0_ENDPTCTRL0_TXS_Pos)
#define USB0_ENDPTCTRL0_TXT1_0_Pos                            18
#define USB0_ENDPTCTRL0_TXT1_0_Msk                            (0x03UL << USB0_ENDPTCTRL0_TXT1_0_Pos)
#define USB0_ENDPTCTRL0_TXE_Pos                               23
#define USB0_ENDPTCTRL0_TXE_Msk                               (0x01UL << USB0_ENDPTCTRL0_TXE_Pos)

// -------------------------------------  USB0_ENDPTCTRL1  ----------------------------------------
#define USB0_ENDPTCTRL1_RXS_Pos                               0
#define USB0_ENDPTCTRL1_RXS_Msk                               (0x01UL << USB0_ENDPTCTRL1_RXS_Pos)
#define USB0_ENDPTCTRL1_RXT_Pos                               2
#define USB0_ENDPTCTRL1_RXT_Msk                               (0x03UL << USB0_ENDPTCTRL1_RXT_Pos)
#define USB0_ENDPTCTRL1_RXI_Pos                               5
#define USB0_ENDPTCTRL1_RXI_Msk                               (0x01UL << USB0_ENDPTCTRL1_RXI_Pos)
#define USB0_ENDPTCTRL1_RXR_Pos                               6
#define USB0_ENDPTCTRL1_RXR_Msk                               (0x01UL << USB0_ENDPTCTRL1_RXR_Pos)
#define USB0_ENDPTCTRL1_RXE_Pos                               7
#define USB0_ENDPTCTRL1_RXE_Msk                               (0x01UL << USB0_ENDPTCTRL1_RXE_Pos)
#define USB0_ENDPTCTRL1_TXS_Pos                               16
#define USB0_ENDPTCTRL1_TXS_Msk                               (0x01UL << USB0_ENDPTCTRL1_TXS_Pos)
#define USB0_ENDPTCTRL1_TXT1_0_Pos                            18
#define USB0_ENDPTCTRL1_TXT1_0_Msk                            (0x03UL << USB0_ENDPTCTRL1_TXT1_0_Pos)
#define USB0_ENDPTCTRL1_TXI_Pos                               21
#define USB0_ENDPTCTRL1_TXI_Msk                               (0x01UL << USB0_ENDPTCTRL1_TXI_Pos)
#define USB0_ENDPTCTRL1_TXR_Pos                               22
#define USB0_ENDPTCTRL1_TXR_Msk                               (0x01UL << USB0_ENDPTCTRL1_TXR_Pos)
#define USB0_ENDPTCTRL1_TXE_Pos                               23
#define USB0_ENDPTCTRL1_TXE_Msk                               (0x01UL << USB0_ENDPTCTRL1_TXE_Pos)

// -------------------------------------  USB0_ENDPTCTRL2  ----------------------------------------
#define USB0_ENDPTCTRL2_RXS_Pos                               0
#define USB0_ENDPTCTRL2_RXS_Msk                               (0x01UL << USB0_ENDPTCTRL2_RXS_Pos)
#define USB0_ENDPTCTRL2_RXT_Pos                               2
#define USB0_ENDPTCTRL2_RXT_Msk                               (0x03UL << USB0_ENDPTCTRL2_RXT_Pos)
#define USB0_ENDPTCTRL2_RXI_Pos                               5
#define USB0_ENDPTCTRL2_RXI_Msk                               (0x01UL << USB0_ENDPTCTRL2_RXI_Pos)
#define USB0_ENDPTCTRL2_RXR_Pos                               6
#define USB0_ENDPTCTRL2_RXR_Msk                               (0x01UL << USB0_ENDPTCTRL2_RXR_Pos)
#define USB0_ENDPTCTRL2_RXE_Pos                               7
#define USB0_ENDPTCTRL2_RXE_Msk                               (0x01UL << USB0_ENDPTCTRL2_RXE_Pos)
#define USB0_ENDPTCTRL2_TXS_Pos                               16
#define USB0_ENDPTCTRL2_TXS_Msk                               (0x01UL << USB0_ENDPTCTRL2_TXS_Pos)
#define USB0_ENDPTCTRL2_TXT1_0_Pos                            18
#define USB0_ENDPTCTRL2_TXT1_0_Msk                            (0x03UL << USB0_ENDPTCTRL2_TXT1_0_Pos)
#define USB0_ENDPTCTRL2_TXI_Pos                               21
#define USB0_ENDPTCTRL2_TXI_Msk                               (0x01UL << USB0_ENDPTCTRL2_TXI_Pos)
#define USB0_ENDPTCTRL2_TXR_Pos                               22
#define USB0_ENDPTCTRL2_TXR_Msk                               (0x01UL << USB0_ENDPTCTRL2_TXR_Pos)
#define USB0_ENDPTCTRL2_TXE_Pos                               23
#define USB0_ENDPTCTRL2_TXE_Msk                               (0x01UL << USB0_ENDPTCTRL2_TXE_Pos)

// -------------------------------------  USB0_ENDPTCTRL3  ----------------------------------------
#define USB0_ENDPTCTRL3_RXS_Pos                               0
#define USB0_ENDPTCTRL3_RXS_Msk                               (0x01UL << USB0_ENDPTCTRL3_RXS_Pos)
#define USB0_ENDPTCTRL3_RXT_Pos                               2
#define USB0_ENDPTCTRL3_RXT_Msk                               (0x03UL << USB0_ENDPTCTRL3_RXT_Pos)
#define USB0_ENDPTCTRL3_RXI_Pos                               5
#define USB0_ENDPTCTRL3_RXI_Msk                               (0x01UL << USB0_ENDPTCTRL3_RXI_Pos)
#define USB0_ENDPTCTRL3_RXR_Pos                               6
#define USB0_ENDPTCTRL3_RXR_Msk                               (0x01UL << USB0_ENDPTCTRL3_RXR_Pos)
#define USB0_ENDPTCTRL3_RXE_Pos                               7
#define USB0_ENDPTCTRL3_RXE_Msk                               (0x01UL << USB0_ENDPTCTRL3_RXE_Pos)
#define USB0_ENDPTCTRL3_TXS_Pos                               16
#define USB0_ENDPTCTRL3_TXS_Msk                               (0x01UL << USB0_ENDPTCTRL3_TXS_Pos)
#define USB0_ENDPTCTRL3_TXT1_0_Pos                            18
#define USB0_ENDPTCTRL3_TXT1_0_Msk                            (0x03UL << USB0_ENDPTCTRL3_TXT1_0_Pos)
#define USB0_ENDPTCTRL3_TXI_Pos                               21
#define USB0_ENDPTCTRL3_TXI_Msk                               (0x01UL << USB0_ENDPTCTRL3_TXI_Pos)
#define USB0_ENDPTCTRL3_TXR_Pos                               22
#define USB0_ENDPTCTRL3_TXR_Msk                               (0x01UL << USB0_ENDPTCTRL3_TXR_Pos)
#define USB0_ENDPTCTRL3_TXE_Pos                               23
#define USB0_ENDPTCTRL3_TXE_Msk                               (0x01UL << USB0_ENDPTCTRL3_TXE_Pos)

// -------------------------------------  USB0_ENDPTCTRL4  ----------------------------------------
#define USB0_ENDPTCTRL4_RXS_Pos                               0
#define USB0_ENDPTCTRL4_RXS_Msk                               (0x01UL << USB0_ENDPTCTRL4_RXS_Pos)
#define USB0_ENDPTCTRL4_RXT_Pos                               2
#define USB0_ENDPTCTRL4_RXT_Msk                               (0x03UL << USB0_ENDPTCTRL4_RXT_Pos)
#define USB0_ENDPTCTRL4_RXI_Pos                               5
#define USB0_ENDPTCTRL4_RXI_Msk                               (0x01UL << USB0_ENDPTCTRL4_RXI_Pos)
#define USB0_ENDPTCTRL4_RXR_Pos                               6
#define USB0_ENDPTCTRL4_RXR_Msk                               (0x01UL << USB0_ENDPTCTRL4_RXR_Pos)
#define USB0_ENDPTCTRL4_RXE_Pos                               7
#define USB0_ENDPTCTRL4_RXE_Msk                               (0x01UL << USB0_ENDPTCTRL4_RXE_Pos)
#define USB0_ENDPTCTRL4_TXS_Pos                               16
#define USB0_ENDPTCTRL4_TXS_Msk                               (0x01UL << USB0_ENDPTCTRL4_TXS_Pos)
#define USB0_ENDPTCTRL4_TXT1_0_Pos                            18
#define USB0_ENDPTCTRL4_TXT1_0_Msk                            (0x03UL << USB0_ENDPTCTRL4_TXT1_0_Pos)
#define USB0_ENDPTCTRL4_TXI_Pos                               21
#define USB0_ENDPTCTRL4_TXI_Msk                               (0x01UL << USB0_ENDPTCTRL4_TXI_Pos)
#define USB0_ENDPTCTRL4_TXR_Pos                               22
#define USB0_ENDPTCTRL4_TXR_Msk                               (0x01UL << USB0_ENDPTCTRL4_TXR_Pos)
#define USB0_ENDPTCTRL4_TXE_Pos                               23
#define USB0_ENDPTCTRL4_TXE_Msk                               (0x01UL << USB0_ENDPTCTRL4_TXE_Pos)

// -------------------------------------  USB0_ENDPTCTRL5  ----------------------------------------
#define USB0_ENDPTCTRL5_RXS_Pos                               0
#define USB0_ENDPTCTRL5_RXS_Msk                               (0x01UL << USB0_ENDPTCTRL5_RXS_Pos)
#define USB0_ENDPTCTRL5_RXT_Pos                               2
#define USB0_ENDPTCTRL5_RXT_Msk                               (0x03UL << USB0_ENDPTCTRL5_RXT_Pos)
#define USB0_ENDPTCTRL5_RXI_Pos                               5
#define USB0_ENDPTCTRL5_RXI_Msk                               (0x01UL << USB0_ENDPTCTRL5_RXI_Pos)
#define USB0_ENDPTCTRL5_RXR_Pos                               6
#define USB0_ENDPTCTRL5_RXR_Msk                               (0x01UL << USB0_ENDPTCTRL5_RXR_Pos)
#define USB0_ENDPTCTRL5_RXE_Pos                               7
#define USB0_ENDPTCTRL5_RXE_Msk                               (0x01UL << USB0_ENDPTCTRL5_RXE_Pos)
#define USB0_ENDPTCTRL5_TXS_Pos                               16
#define USB0_ENDPTCTRL5_TXS_Msk                               (0x01UL << USB0_ENDPTCTRL5_TXS_Pos)
#define USB0_ENDPTCTRL5_TXT1_0_Pos                            18
#define USB0_ENDPTCTRL5_TXT1_0_Msk                            (0x03UL << USB0_ENDPTCTRL5_TXT1_0_Pos)
#define USB0_ENDPTCTRL5_TXI_Pos                               21
#define USB0_ENDPTCTRL5_TXI_Msk                               (0x01UL << USB0_ENDPTCTRL5_TXI_Pos)
#define USB0_ENDPTCTRL5_TXR_Pos                               22
#define USB0_ENDPTCTRL5_TXR_Msk                               (0x01UL << USB0_ENDPTCTRL5_TXR_Pos)
#define USB0_ENDPTCTRL5_TXE_Pos                               23
#define USB0_ENDPTCTRL5_TXE_Msk                               (0x01UL << USB0_ENDPTCTRL5_TXE_Pos)


// ------------------------------------------------------------------------------------------------
// -----                                 USB1 Position & Mask                                 -----
// ------------------------------------------------------------------------------------------------


// -------------------------------------  USB1_CAPLENGTH  -----------------------------------------
#define USB1_CAPLENGTH_CAPLENGTH_Pos                          0
#define USB1_CAPLENGTH_CAPLENGTH_Msk                          (0x000000ffUL << USB1_CAPLENGTH_CAPLENGTH_Pos)
#define USB1_CAPLENGTH_HCIVERSION_Pos                         8
#define USB1_CAPLENGTH_HCIVERSION_Msk                         (0x0000ffffUL << USB1_CAPLENGTH_HCIVERSION_Pos)

// -------------------------------------  USB1_HCSPARAMS  -----------------------------------------
#define USB1_HCSPARAMS_N_PORTS_Pos                            0
#define USB1_HCSPARAMS_N_PORTS_Msk                            (0x0fUL << USB1_HCSPARAMS_N_PORTS_Pos)
#define USB1_HCSPARAMS_PPC_Pos                                4
#define USB1_HCSPARAMS_PPC_Msk                                (0x01UL << USB1_HCSPARAMS_PPC_Pos)
#define USB1_HCSPARAMS_N_PCC_Pos                              8
#define USB1_HCSPARAMS_N_PCC_Msk                              (0x0fUL << USB1_HCSPARAMS_N_PCC_Pos)
#define USB1_HCSPARAMS_N_CC_Pos                               12
#define USB1_HCSPARAMS_N_CC_Msk                               (0x0fUL << USB1_HCSPARAMS_N_CC_Pos)
#define USB1_HCSPARAMS_PI_Pos                                 16
#define USB1_HCSPARAMS_PI_Msk                                 (0x01UL << USB1_HCSPARAMS_PI_Pos)
#define USB1_HCSPARAMS_N_PTT_Pos                              20
#define USB1_HCSPARAMS_N_PTT_Msk                              (0x0fUL << USB1_HCSPARAMS_N_PTT_Pos)
#define USB1_HCSPARAMS_N_TT_Pos                               24
#define USB1_HCSPARAMS_N_TT_Msk                               (0x0fUL << USB1_HCSPARAMS_N_TT_Pos)

// -------------------------------------  USB1_HCCPARAMS  -----------------------------------------
#define USB1_HCCPARAMS_ADC_Pos                                0
#define USB1_HCCPARAMS_ADC_Msk                                (0x01UL << USB1_HCCPARAMS_ADC_Pos)
#define USB1_HCCPARAMS_PFL_Pos                                1
#define USB1_HCCPARAMS_PFL_Msk                                (0x01UL << USB1_HCCPARAMS_PFL_Pos)
#define USB1_HCCPARAMS_ASP_Pos                                2
#define USB1_HCCPARAMS_ASP_Msk                                (0x01UL << USB1_HCCPARAMS_ASP_Pos)
#define USB1_HCCPARAMS_IST_Pos                                4
#define USB1_HCCPARAMS_IST_Msk                                (0x0fUL << USB1_HCCPARAMS_IST_Pos)
#define USB1_HCCPARAMS_EECP_Pos                               8
#define USB1_HCCPARAMS_EECP_Msk                               (0x000000ffUL << USB1_HCCPARAMS_EECP_Pos)

// -------------------------------------  USB1_DCIVERSION  ----------------------------------------
#define USB1_DCIVERSION_DCIVERSION_Pos                        0
#define USB1_DCIVERSION_DCIVERSION_Msk                        (0x0000ffffUL << USB1_DCIVERSION_DCIVERSION_Pos)

// --------------------------------------  USB1_USBCMD_D  -----------------------------------------
#define USB1_USBCMD_D_RS_Pos                                  0
#define USB1_USBCMD_D_RS_Msk                                  (0x01UL << USB1_USBCMD_D_RS_Pos)
#define USB1_USBCMD_D_RST_Pos                                 1
#define USB1_USBCMD_D_RST_Msk                                 (0x01UL << USB1_USBCMD_D_RST_Pos)
#define USB1_USBCMD_D_SUTW_Pos                                13
#define USB1_USBCMD_D_SUTW_Msk                                (0x01UL << USB1_USBCMD_D_SUTW_Pos)
#define USB1_USBCMD_D_ATDTW_Pos                               14
#define USB1_USBCMD_D_ATDTW_Msk                               (0x01UL << USB1_USBCMD_D_ATDTW_Pos)
#define USB1_USBCMD_D_FS2_Pos                                 15
#define USB1_USBCMD_D_FS2_Msk                                 (0x01UL << USB1_USBCMD_D_FS2_Pos)
#define USB1_USBCMD_D_ITC_Pos                                 16
#define USB1_USBCMD_D_ITC_Msk                                 (0x000000ffUL << USB1_USBCMD_D_ITC_Pos)

// --------------------------------------  USB1_USBCMD_H  -----------------------------------------
#define USB1_USBCMD_H_RS_Pos                                  0
#define USB1_USBCMD_H_RS_Msk                                  (0x01UL << USB1_USBCMD_H_RS_Pos)
#define USB1_USBCMD_H_RST_Pos                                 1
#define USB1_USBCMD_H_RST_Msk                                 (0x01UL << USB1_USBCMD_H_RST_Pos)
#define USB1_USBCMD_H_FS0_Pos                                 2
#define USB1_USBCMD_H_FS0_Msk                                 (0x01UL << USB1_USBCMD_H_FS0_Pos)
#define USB1_USBCMD_H_FS1_Pos                                 3
#define USB1_USBCMD_H_FS1_Msk                                 (0x01UL << USB1_USBCMD_H_FS1_Pos)
#define USB1_USBCMD_H_PSE_Pos                                 4
#define USB1_USBCMD_H_PSE_Msk                                 (0x01UL << USB1_USBCMD_H_PSE_Pos)
#define USB1_USBCMD_H_ASE_Pos                                 5
#define USB1_USBCMD_H_ASE_Msk                                 (0x01UL << USB1_USBCMD_H_ASE_Pos)
#define USB1_USBCMD_H_IAA_Pos                                 6
#define USB1_USBCMD_H_IAA_Msk                                 (0x01UL << USB1_USBCMD_H_IAA_Pos)
#define USB1_USBCMD_H_ASP1_0_Pos                              8
#define USB1_USBCMD_H_ASP1_0_Msk                              (0x03UL << USB1_USBCMD_H_ASP1_0_Pos)
#define USB1_USBCMD_H_ASPE_Pos                                11
#define USB1_USBCMD_H_ASPE_Msk                                (0x01UL << USB1_USBCMD_H_ASPE_Pos)
#define USB1_USBCMD_H_FS2_Pos                                 15
#define USB1_USBCMD_H_FS2_Msk                                 (0x01UL << USB1_USBCMD_H_FS2_Pos)
#define USB1_USBCMD_H_ITC_Pos                                 16
#define USB1_USBCMD_H_ITC_Msk                                 (0x000000ffUL << USB1_USBCMD_H_ITC_Pos)

// --------------------------------------  USB1_USBSTS_D  -----------------------------------------
#define USB1_USBSTS_D_UI_Pos                                  0
#define USB1_USBSTS_D_UI_Msk                                  (0x01UL << USB1_USBSTS_D_UI_Pos)
#define USB1_USBSTS_D_UEI_Pos                                 1
#define USB1_USBSTS_D_UEI_Msk                                 (0x01UL << USB1_USBSTS_D_UEI_Pos)
#define USB1_USBSTS_D_PCI_Pos                                 2
#define USB1_USBSTS_D_PCI_Msk                                 (0x01UL << USB1_USBSTS_D_PCI_Pos)
#define USB1_USBSTS_D_URI_Pos                                 6
#define USB1_USBSTS_D_URI_Msk                                 (0x01UL << USB1_USBSTS_D_URI_Pos)
#define USB1_USBSTS_D_SRI_Pos                                 7
#define USB1_USBSTS_D_SRI_Msk                                 (0x01UL << USB1_USBSTS_D_SRI_Pos)
#define USB1_USBSTS_D_SLI_Pos                                 8
#define USB1_USBSTS_D_SLI_Msk                                 (0x01UL << USB1_USBSTS_D_SLI_Pos)
#define USB1_USBSTS_D_NAKI_Pos                                16
#define USB1_USBSTS_D_NAKI_Msk                                (0x01UL << USB1_USBSTS_D_NAKI_Pos)

// --------------------------------------  USB1_USBSTS_H  -----------------------------------------
#define USB1_USBSTS_H_UI_Pos                                  0
#define USB1_USBSTS_H_UI_Msk                                  (0x01UL << USB1_USBSTS_H_UI_Pos)
#define USB1_USBSTS_H_UEI_Pos                                 1
#define USB1_USBSTS_H_UEI_Msk                                 (0x01UL << USB1_USBSTS_H_UEI_Pos)
#define USB1_USBSTS_H_PCI_Pos                                 2
#define USB1_USBSTS_H_PCI_Msk                                 (0x01UL << USB1_USBSTS_H_PCI_Pos)
#define USB1_USBSTS_H_FRI_Pos                                 3
#define USB1_USBSTS_H_FRI_Msk                                 (0x01UL << USB1_USBSTS_H_FRI_Pos)
#define USB1_USBSTS_H_AAI_Pos                                 5
#define USB1_USBSTS_H_AAI_Msk                                 (0x01UL << USB1_USBSTS_H_AAI_Pos)
#define USB1_USBSTS_H_SRI_Pos                                 7
#define USB1_USBSTS_H_SRI_Msk                                 (0x01UL << USB1_USBSTS_H_SRI_Pos)
#define USB1_USBSTS_H_SLI_Pos                                 8
#define USB1_USBSTS_H_SLI_Msk                                 (0x01UL << USB1_USBSTS_H_SLI_Pos)
#define USB1_USBSTS_H_HCH_Pos                                 12
#define USB1_USBSTS_H_HCH_Msk                                 (0x01UL << USB1_USBSTS_H_HCH_Pos)
#define USB1_USBSTS_H_RCL_Pos                                 13
#define USB1_USBSTS_H_RCL_Msk                                 (0x01UL << USB1_USBSTS_H_RCL_Pos)
#define USB1_USBSTS_H_PS_Pos                                  14
#define USB1_USBSTS_H_PS_Msk                                  (0x01UL << USB1_USBSTS_H_PS_Pos)
#define USB1_USBSTS_H_AS_Pos                                  15
#define USB1_USBSTS_H_AS_Msk                                  (0x01UL << USB1_USBSTS_H_AS_Pos)
#define USB1_USBSTS_H_UAI_Pos                                 18
#define USB1_USBSTS_H_UAI_Msk                                 (0x01UL << USB1_USBSTS_H_UAI_Pos)
#define USB1_USBSTS_H_UPI_Pos                                 19
#define USB1_USBSTS_H_UPI_Msk                                 (0x01UL << USB1_USBSTS_H_UPI_Pos)

// -------------------------------------  USB1_USBINTR_D  -----------------------------------------
#define USB1_USBINTR_D_UE_Pos                                 0
#define USB1_USBINTR_D_UE_Msk                                 (0x01UL << USB1_USBINTR_D_UE_Pos)
#define USB1_USBINTR_D_UEE_Pos                                1
#define USB1_USBINTR_D_UEE_Msk                                (0x01UL << USB1_USBINTR_D_UEE_Pos)
#define USB1_USBINTR_D_PCE_Pos                                2
#define USB1_USBINTR_D_PCE_Msk                                (0x01UL << USB1_USBINTR_D_PCE_Pos)
#define USB1_USBINTR_D_URE_Pos                                6
#define USB1_USBINTR_D_URE_Msk                                (0x01UL << USB1_USBINTR_D_URE_Pos)
#define USB1_USBINTR_D_SRE_Pos                                7
#define USB1_USBINTR_D_SRE_Msk                                (0x01UL << USB1_USBINTR_D_SRE_Pos)
#define USB1_USBINTR_D_SLE_Pos                                8
#define USB1_USBINTR_D_SLE_Msk                                (0x01UL << USB1_USBINTR_D_SLE_Pos)
#define USB1_USBINTR_D_NAKE_Pos                               16
#define USB1_USBINTR_D_NAKE_Msk                               (0x01UL << USB1_USBINTR_D_NAKE_Pos)
#define USB1_USBINTR_D_UAIE_Pos                               18
#define USB1_USBINTR_D_UAIE_Msk                               (0x01UL << USB1_USBINTR_D_UAIE_Pos)
#define USB1_USBINTR_D_UPIA_Pos                               19
#define USB1_USBINTR_D_UPIA_Msk                               (0x01UL << USB1_USBINTR_D_UPIA_Pos)

// -------------------------------------  USB1_USBINTR_H  -----------------------------------------
#define USB1_USBINTR_H_UE_Pos                                 0
#define USB1_USBINTR_H_UE_Msk                                 (0x01UL << USB1_USBINTR_H_UE_Pos)
#define USB1_USBINTR_H_UEE_Pos                                1
#define USB1_USBINTR_H_UEE_Msk                                (0x01UL << USB1_USBINTR_H_UEE_Pos)
#define USB1_USBINTR_H_PCE_Pos                                2
#define USB1_USBINTR_H_PCE_Msk                                (0x01UL << USB1_USBINTR_H_PCE_Pos)
#define USB1_USBINTR_H_FRE_Pos                                3
#define USB1_USBINTR_H_FRE_Msk                                (0x01UL << USB1_USBINTR_H_FRE_Pos)
#define USB1_USBINTR_H_AAE_Pos                                5
#define USB1_USBINTR_H_AAE_Msk                                (0x01UL << USB1_USBINTR_H_AAE_Pos)
#define USB1_USBINTR_H_SRE_Pos                                7
#define USB1_USBINTR_H_SRE_Msk                                (0x01UL << USB1_USBINTR_H_SRE_Pos)
#define USB1_USBINTR_H_UAIE_Pos                               18
#define USB1_USBINTR_H_UAIE_Msk                               (0x01UL << USB1_USBINTR_H_UAIE_Pos)
#define USB1_USBINTR_H_UPIA_Pos                               19
#define USB1_USBINTR_H_UPIA_Msk                               (0x01UL << USB1_USBINTR_H_UPIA_Pos)

// -------------------------------------  USB1_FRINDEX_D  -----------------------------------------
#define USB1_FRINDEX_D_FRINDEX2_0_Pos                         0
#define USB1_FRINDEX_D_FRINDEX2_0_Msk                         (0x07UL << USB1_FRINDEX_D_FRINDEX2_0_Pos)
#define USB1_FRINDEX_D_FRINDEX13_3_Pos                        3
#define USB1_FRINDEX_D_FRINDEX13_3_Msk                        (0x000007ffUL << USB1_FRINDEX_D_FRINDEX13_3_Pos)

// -------------------------------------  USB1_FRINDEX_H  -----------------------------------------
#define USB1_FRINDEX_H_FRINDEX2_0_Pos                         0
#define USB1_FRINDEX_H_FRINDEX2_0_Msk                         (0x07UL << USB1_FRINDEX_H_FRINDEX2_0_Pos)
#define USB1_FRINDEX_H_FRINDEX12_3_Pos                        3
#define USB1_FRINDEX_H_FRINDEX12_3_Msk                        (0x000003ffUL << USB1_FRINDEX_H_FRINDEX12_3_Pos)

// -------------------------------------  USB1_DEVICEADDR  ----------------------------------------
#define USB1_DEVICEADDR_USBADRA_Pos                           24
#define USB1_DEVICEADDR_USBADRA_Msk                           (0x01UL << USB1_DEVICEADDR_USBADRA_Pos)
#define USB1_DEVICEADDR_USBADR_Pos                            25
#define USB1_DEVICEADDR_USBADR_Msk                            (0x7fUL << USB1_DEVICEADDR_USBADR_Pos)

// ----------------------------------  USB1_PERIODICLISTBASE  -------------------------------------
#define USB1_PERIODICLISTBASE_PERBASE31_12_Pos                12
#define USB1_PERIODICLISTBASE_PERBASE31_12_Msk                (0x000fffffUL << USB1_PERIODICLISTBASE_PERBASE31_12_Pos)

// ----------------------------------  USB1_ENDPOINTLISTADDR  -------------------------------------
#define USB1_ENDPOINTLISTADDR_EPBASE31_11_Pos                 11
#define USB1_ENDPOINTLISTADDR_EPBASE31_11_Msk                 (0x001fffffUL << USB1_ENDPOINTLISTADDR_EPBASE31_11_Pos)

// -----------------------------------  USB1_ASYNCLISTADDR  ---------------------------------------
#define USB1_ASYNCLISTADDR_ASYBASE31_5_Pos                    5
#define USB1_ASYNCLISTADDR_ASYBASE31_5_Msk                    (0x07ffffffUL << USB1_ASYNCLISTADDR_ASYBASE31_5_Pos)

// ---------------------------------------  USB1_TTCTRL  ------------------------------------------
#define USB1_TTCTRL_TTHA_Pos                                  24
#define USB1_TTCTRL_TTHA_Msk                                  (0x7fUL << USB1_TTCTRL_TTHA_Pos)

// -------------------------------------  USB1_BURSTSIZE  -----------------------------------------
#define USB1_BURSTSIZE_RXPBURST_Pos                           0
#define USB1_BURSTSIZE_RXPBURST_Msk                           (0x000000ffUL << USB1_BURSTSIZE_RXPBURST_Pos)
#define USB1_BURSTSIZE_TXPBURST_Pos                           8
#define USB1_BURSTSIZE_TXPBURST_Msk                           (0x000000ffUL << USB1_BURSTSIZE_TXPBURST_Pos)

// ------------------------------------  USB1_TXFILLTUNING  ---------------------------------------
#define USB1_TXFILLTUNING_TXSCHOH_Pos                         0
#define USB1_TXFILLTUNING_TXSCHOH_Msk                         (0x000000ffUL << USB1_TXFILLTUNING_TXSCHOH_Pos)
#define USB1_TXFILLTUNING_TXSCHEATLTH_Pos                     8
#define USB1_TXFILLTUNING_TXSCHEATLTH_Msk                     (0x1fUL << USB1_TXFILLTUNING_TXSCHEATLTH_Pos)
#define USB1_TXFILLTUNING_TXFIFOTHRES_Pos                     16
#define USB1_TXFILLTUNING_TXFIFOTHRES_Msk                     (0x3fUL << USB1_TXFILLTUNING_TXFIFOTHRES_Pos)

// ------------------------------------  USB1_ULPIVIEWPORT  ---------------------------------------
#define USB1_ULPIVIEWPORT_ULPIDATWR_Pos                       0
#define USB1_ULPIVIEWPORT_ULPIDATWR_Msk                       (0x000000ffUL << USB1_ULPIVIEWPORT_ULPIDATWR_Pos)
#define USB1_ULPIVIEWPORT_ULPIDATRD_Pos                       8
#define USB1_ULPIVIEWPORT_ULPIDATRD_Msk                       (0x000000ffUL << USB1_ULPIVIEWPORT_ULPIDATRD_Pos)
#define USB1_ULPIVIEWPORT_ULPIADDR_Pos                        16
#define USB1_ULPIVIEWPORT_ULPIADDR_Msk                        (0x000000ffUL << USB1_ULPIVIEWPORT_ULPIADDR_Pos)
#define USB1_ULPIVIEWPORT_ULPIPORT_Pos                        24
#define USB1_ULPIVIEWPORT_ULPIPORT_Msk                        (0x07UL << USB1_ULPIVIEWPORT_ULPIPORT_Pos)
#define USB1_ULPIVIEWPORT_ULPISS_Pos                          27
#define USB1_ULPIVIEWPORT_ULPISS_Msk                          (0x01UL << USB1_ULPIVIEWPORT_ULPISS_Pos)
#define USB1_ULPIVIEWPORT_ULPIRW_Pos                          29
#define USB1_ULPIVIEWPORT_ULPIRW_Msk                          (0x01UL << USB1_ULPIVIEWPORT_ULPIRW_Pos)
#define USB1_ULPIVIEWPORT_ULPIRUN_Pos                         30
#define USB1_ULPIVIEWPORT_ULPIRUN_Msk                         (0x01UL << USB1_ULPIVIEWPORT_ULPIRUN_Pos)
#define USB1_ULPIVIEWPORT_ULPIWU_Pos                          31
#define USB1_ULPIVIEWPORT_ULPIWU_Msk                          (0x01UL << USB1_ULPIVIEWPORT_ULPIWU_Pos)

// -------------------------------------  USB1_BINTERVAL  -----------------------------------------
#define USB1_BINTERVAL_BINT_Pos                               0
#define USB1_BINTERVAL_BINT_Msk                               (0x0fUL << USB1_BINTERVAL_BINT_Pos)

// --------------------------------------  USB1_ENDPTNAK  -----------------------------------------
#define USB1_ENDPTNAK_EPRN0_Pos                               0
#define USB1_ENDPTNAK_EPRN0_Msk                               (0x01UL << USB1_ENDPTNAK_EPRN0_Pos)
#define USB1_ENDPTNAK_EPRN1_Pos                               1
#define USB1_ENDPTNAK_EPRN1_Msk                               (0x01UL << USB1_ENDPTNAK_EPRN1_Pos)
#define USB1_ENDPTNAK_EPRN2_Pos                               2
#define USB1_ENDPTNAK_EPRN2_Msk                               (0x01UL << USB1_ENDPTNAK_EPRN2_Pos)
#define USB1_ENDPTNAK_EPRN3_Pos                               3
#define USB1_ENDPTNAK_EPRN3_Msk                               (0x01UL << USB1_ENDPTNAK_EPRN3_Pos)
#define USB1_ENDPTNAK_EPTN16_Pos                              16
#define USB1_ENDPTNAK_EPTN16_Msk                              (0x01UL << USB1_ENDPTNAK_EPTN16_Pos)
#define USB1_ENDPTNAK_EPTN17_Pos                              17
#define USB1_ENDPTNAK_EPTN17_Msk                              (0x01UL << USB1_ENDPTNAK_EPTN17_Pos)
#define USB1_ENDPTNAK_EPTN18_Pos                              18
#define USB1_ENDPTNAK_EPTN18_Msk                              (0x01UL << USB1_ENDPTNAK_EPTN18_Pos)
#define USB1_ENDPTNAK_EPTN19_Pos                              19
#define USB1_ENDPTNAK_EPTN19_Msk                              (0x01UL << USB1_ENDPTNAK_EPTN19_Pos)

// -------------------------------------  USB1_ENDPTNAKEN  ----------------------------------------
#define USB1_ENDPTNAKEN_EPRNE0_Pos                            0
#define USB1_ENDPTNAKEN_EPRNE0_Msk                            (0x01UL << USB1_ENDPTNAKEN_EPRNE0_Pos)
#define USB1_ENDPTNAKEN_EPRNE1_Pos                            1
#define USB1_ENDPTNAKEN_EPRNE1_Msk                            (0x01UL << USB1_ENDPTNAKEN_EPRNE1_Pos)
#define USB1_ENDPTNAKEN_EPRNE2_Pos                            2
#define USB1_ENDPTNAKEN_EPRNE2_Msk                            (0x01UL << USB1_ENDPTNAKEN_EPRNE2_Pos)
#define USB1_ENDPTNAKEN_EPRNE3_Pos                            3
#define USB1_ENDPTNAKEN_EPRNE3_Msk                            (0x01UL << USB1_ENDPTNAKEN_EPRNE3_Pos)
#define USB1_ENDPTNAKEN_EPTNE16_Pos                           16
#define USB1_ENDPTNAKEN_EPTNE16_Msk                           (0x01UL << USB1_ENDPTNAKEN_EPTNE16_Pos)
#define USB1_ENDPTNAKEN_EPTNE17_Pos                           17
#define USB1_ENDPTNAKEN_EPTNE17_Msk                           (0x01UL << USB1_ENDPTNAKEN_EPTNE17_Pos)
#define USB1_ENDPTNAKEN_EPTNE18_Pos                           18
#define USB1_ENDPTNAKEN_EPTNE18_Msk                           (0x01UL << USB1_ENDPTNAKEN_EPTNE18_Pos)
#define USB1_ENDPTNAKEN_EPTNE19_Pos                           19
#define USB1_ENDPTNAKEN_EPTNE19_Msk                           (0x01UL << USB1_ENDPTNAKEN_EPTNE19_Pos)

// -------------------------------------  USB1_PORTSC1_D  -----------------------------------------
#define USB1_PORTSC1_D_CCS_Pos                                0
#define USB1_PORTSC1_D_CCS_Msk                                (0x01UL << USB1_PORTSC1_D_CCS_Pos)
#define USB1_PORTSC1_D_CSC_Pos                                1
#define USB1_PORTSC1_D_CSC_Msk                                (0x01UL << USB1_PORTSC1_D_CSC_Pos)
#define USB1_PORTSC1_D_PE_Pos                                 2
#define USB1_PORTSC1_D_PE_Msk                                 (0x01UL << USB1_PORTSC1_D_PE_Pos)
#define USB1_PORTSC1_D_PEC_Pos                                3
#define USB1_PORTSC1_D_PEC_Msk                                (0x01UL << USB1_PORTSC1_D_PEC_Pos)
#define USB1_PORTSC1_D_FPR_Pos                                6
#define USB1_PORTSC1_D_FPR_Msk                                (0x01UL << USB1_PORTSC1_D_FPR_Pos)
#define USB1_PORTSC1_D_SUSP_Pos                               7
#define USB1_PORTSC1_D_SUSP_Msk                               (0x01UL << USB1_PORTSC1_D_SUSP_Pos)
#define USB1_PORTSC1_D_PR_Pos                                 8
#define USB1_PORTSC1_D_PR_Msk                                 (0x01UL << USB1_PORTSC1_D_PR_Pos)
#define USB1_PORTSC1_D_HSP_Pos                                9
#define USB1_PORTSC1_D_HSP_Msk                                (0x01UL << USB1_PORTSC1_D_HSP_Pos)
#define USB1_PORTSC1_D_LS_Pos                                 10
#define USB1_PORTSC1_D_LS_Msk                                 (0x03UL << USB1_PORTSC1_D_LS_Pos)
#define USB1_PORTSC1_D_PP_Pos                                 12
#define USB1_PORTSC1_D_PP_Msk                                 (0x01UL << USB1_PORTSC1_D_PP_Pos)
#define USB1_PORTSC1_D_PIC1_0_Pos                             14
#define USB1_PORTSC1_D_PIC1_0_Msk                             (0x03UL << USB1_PORTSC1_D_PIC1_0_Pos)
#define USB1_PORTSC1_D_PTC3_0_Pos                             16
#define USB1_PORTSC1_D_PTC3_0_Msk                             (0x0fUL << USB1_PORTSC1_D_PTC3_0_Pos)
#define USB1_PORTSC1_D_PHCD_Pos                               23
#define USB1_PORTSC1_D_PHCD_Msk                               (0x01UL << USB1_PORTSC1_D_PHCD_Pos)
#define USB1_PORTSC1_D_PFSC_Pos                               24
#define USB1_PORTSC1_D_PFSC_Msk                               (0x01UL << USB1_PORTSC1_D_PFSC_Pos)
#define USB1_PORTSC1_D_PSPD_Pos                               26
#define USB1_PORTSC1_D_PSPD_Msk                               (0x03UL << USB1_PORTSC1_D_PSPD_Pos)
#define USB1_PORTSC1_D_PTS_Pos                                30
#define USB1_PORTSC1_D_PTS_Msk                                (0x03UL << USB1_PORTSC1_D_PTS_Pos)

// -------------------------------------  USB1_PORTSC1_H  -----------------------------------------
#define USB1_PORTSC1_H_CCS_Pos                                0
#define USB1_PORTSC1_H_CCS_Msk                                (0x01UL << USB1_PORTSC1_H_CCS_Pos)
#define USB1_PORTSC1_H_CSC_Pos                                1
#define USB1_PORTSC1_H_CSC_Msk                                (0x01UL << USB1_PORTSC1_H_CSC_Pos)
#define USB1_PORTSC1_H_PE_Pos                                 2
#define USB1_PORTSC1_H_PE_Msk                                 (0x01UL << USB1_PORTSC1_H_PE_Pos)
#define USB1_PORTSC1_H_PEC_Pos                                3
#define USB1_PORTSC1_H_PEC_Msk                                (0x01UL << USB1_PORTSC1_H_PEC_Pos)
#define USB1_PORTSC1_H_OCA_Pos                                4
#define USB1_PORTSC1_H_OCA_Msk                                (0x01UL << USB1_PORTSC1_H_OCA_Pos)
#define USB1_PORTSC1_H_OCC_Pos                                5
#define USB1_PORTSC1_H_OCC_Msk                                (0x01UL << USB1_PORTSC1_H_OCC_Pos)
#define USB1_PORTSC1_H_FPR_Pos                                6
#define USB1_PORTSC1_H_FPR_Msk                                (0x01UL << USB1_PORTSC1_H_FPR_Pos)
#define USB1_PORTSC1_H_SUSP_Pos                               7
#define USB1_PORTSC1_H_SUSP_Msk                               (0x01UL << USB1_PORTSC1_H_SUSP_Pos)
#define USB1_PORTSC1_H_PR_Pos                                 8
#define USB1_PORTSC1_H_PR_Msk                                 (0x01UL << USB1_PORTSC1_H_PR_Pos)
#define USB1_PORTSC1_H_HSP_Pos                                9
#define USB1_PORTSC1_H_HSP_Msk                                (0x01UL << USB1_PORTSC1_H_HSP_Pos)
#define USB1_PORTSC1_H_LS_Pos                                 10
#define USB1_PORTSC1_H_LS_Msk                                 (0x03UL << USB1_PORTSC1_H_LS_Pos)
#define USB1_PORTSC1_H_PP_Pos                                 12
#define USB1_PORTSC1_H_PP_Msk                                 (0x01UL << USB1_PORTSC1_H_PP_Pos)
#define USB1_PORTSC1_H_PIC1_0_Pos                             14
#define USB1_PORTSC1_H_PIC1_0_Msk                             (0x03UL << USB1_PORTSC1_H_PIC1_0_Pos)
#define USB1_PORTSC1_H_PTC3_0_Pos                             16
#define USB1_PORTSC1_H_PTC3_0_Msk                             (0x0fUL << USB1_PORTSC1_H_PTC3_0_Pos)
#define USB1_PORTSC1_H_WKCN_Pos                               20
#define USB1_PORTSC1_H_WKCN_Msk                               (0x01UL << USB1_PORTSC1_H_WKCN_Pos)
#define USB1_PORTSC1_H_WKDC_Pos                               21
#define USB1_PORTSC1_H_WKDC_Msk                               (0x01UL << USB1_PORTSC1_H_WKDC_Pos)
#define USB1_PORTSC1_H_WKOC_Pos                               22
#define USB1_PORTSC1_H_WKOC_Msk                               (0x01UL << USB1_PORTSC1_H_WKOC_Pos)
#define USB1_PORTSC1_H_PHCD_Pos                               23
#define USB1_PORTSC1_H_PHCD_Msk                               (0x01UL << USB1_PORTSC1_H_PHCD_Pos)
#define USB1_PORTSC1_H_PFSC_Pos                               24
#define USB1_PORTSC1_H_PFSC_Msk                               (0x01UL << USB1_PORTSC1_H_PFSC_Pos)
#define USB1_PORTSC1_H_PSPD_Pos                               26
#define USB1_PORTSC1_H_PSPD_Msk                               (0x03UL << USB1_PORTSC1_H_PSPD_Pos)
#define USB1_PORTSC1_H_PTS_Pos                                30
#define USB1_PORTSC1_H_PTS_Msk                                (0x03UL << USB1_PORTSC1_H_PTS_Pos)

// -------------------------------------  USB1_USBMODE_D  -----------------------------------------
#define USB1_USBMODE_D_CM1_0_Pos                              0
#define USB1_USBMODE_D_CM1_0_Msk                              (0x03UL << USB1_USBMODE_D_CM1_0_Pos)
#define USB1_USBMODE_D_ES_Pos                                 2
#define USB1_USBMODE_D_ES_Msk                                 (0x01UL << USB1_USBMODE_D_ES_Pos)
#define USB1_USBMODE_D_SLOM_Pos                               3
#define USB1_USBMODE_D_SLOM_Msk                               (0x01UL << USB1_USBMODE_D_SLOM_Pos)
#define USB1_USBMODE_D_SDIS_Pos                               4
#define USB1_USBMODE_D_SDIS_Msk                               (0x01UL << USB1_USBMODE_D_SDIS_Pos)

// -------------------------------------  USB1_USBMODE_H  -----------------------------------------
#define USB1_USBMODE_H_CM1_0_Pos                              0
#define USB1_USBMODE_H_CM1_0_Msk                              (0x03UL << USB1_USBMODE_H_CM1_0_Pos)
#define USB1_USBMODE_H_ES_Pos                                 2
#define USB1_USBMODE_H_ES_Msk                                 (0x01UL << USB1_USBMODE_H_ES_Pos)
#define USB1_USBMODE_H_SDIS_Pos                               4
#define USB1_USBMODE_H_SDIS_Msk                               (0x01UL << USB1_USBMODE_H_SDIS_Pos)
#define USB1_USBMODE_H_VBPS_Pos                               5
#define USB1_USBMODE_H_VBPS_Msk                               (0x01UL << USB1_USBMODE_H_VBPS_Pos)

// -----------------------------------  USB1_ENDPTSETUPSTAT  --------------------------------------
#define USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT0_Pos               0
#define USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT0_Msk               (0x01UL << USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT0_Pos)
#define USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT1_Pos               1
#define USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT1_Msk               (0x01UL << USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT1_Pos)
#define USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT2_Pos               2
#define USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT2_Msk               (0x01UL << USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT2_Pos)
#define USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT3_Pos               3
#define USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT3_Msk               (0x01UL << USB1_ENDPTSETUPSTAT_ENDPTSETUPSTAT3_Pos)

// -------------------------------------  USB1_ENDPTPRIME  ----------------------------------------
#define USB1_ENDPTPRIME_PERB0_Pos                             0
#define USB1_ENDPTPRIME_PERB0_Msk                             (0x01UL << USB1_ENDPTPRIME_PERB0_Pos)
#define USB1_ENDPTPRIME_PERB1_Pos                             1
#define USB1_ENDPTPRIME_PERB1_Msk                             (0x01UL << USB1_ENDPTPRIME_PERB1_Pos)
#define USB1_ENDPTPRIME_PERB2_Pos                             2
#define USB1_ENDPTPRIME_PERB2_Msk                             (0x01UL << USB1_ENDPTPRIME_PERB2_Pos)
#define USB1_ENDPTPRIME_PERB3_Pos                             3
#define USB1_ENDPTPRIME_PERB3_Msk                             (0x01UL << USB1_ENDPTPRIME_PERB3_Pos)
#define USB1_ENDPTPRIME_PETB0_Pos                             16
#define USB1_ENDPTPRIME_PETB0_Msk                             (0x01UL << USB1_ENDPTPRIME_PETB0_Pos)
#define USB1_ENDPTPRIME_PETB1_Pos                             17
#define USB1_ENDPTPRIME_PETB1_Msk                             (0x01UL << USB1_ENDPTPRIME_PETB1_Pos)
#define USB1_ENDPTPRIME_PETB2_Pos                             18
#define USB1_ENDPTPRIME_PETB2_Msk                             (0x01UL << USB1_ENDPTPRIME_PETB2_Pos)
#define USB1_ENDPTPRIME_PETB3_Pos                             19
#define USB1_ENDPTPRIME_PETB3_Msk                             (0x01UL << USB1_ENDPTPRIME_PETB3_Pos)

// -------------------------------------  USB1_ENDPTFLUSH  ----------------------------------------
#define USB1_ENDPTFLUSH_FERB0_Pos                             0
#define USB1_ENDPTFLUSH_FERB0_Msk                             (0x01UL << USB1_ENDPTFLUSH_FERB0_Pos)
#define USB1_ENDPTFLUSH_FERB1_Pos                             1
#define USB1_ENDPTFLUSH_FERB1_Msk                             (0x01UL << USB1_ENDPTFLUSH_FERB1_Pos)
#define USB1_ENDPTFLUSH_FERB2_Pos                             2
#define USB1_ENDPTFLUSH_FERB2_Msk                             (0x01UL << USB1_ENDPTFLUSH_FERB2_Pos)
#define USB1_ENDPTFLUSH_FERB3_Pos                             3
#define USB1_ENDPTFLUSH_FERB3_Msk                             (0x01UL << USB1_ENDPTFLUSH_FERB3_Pos)
#define USB1_ENDPTFLUSH_FETB0_Pos                             16
#define USB1_ENDPTFLUSH_FETB0_Msk                             (0x01UL << USB1_ENDPTFLUSH_FETB0_Pos)
#define USB1_ENDPTFLUSH_FETB1_Pos                             17
#define USB1_ENDPTFLUSH_FETB1_Msk                             (0x01UL << USB1_ENDPTFLUSH_FETB1_Pos)
#define USB1_ENDPTFLUSH_FETB2_Pos                             18
#define USB1_ENDPTFLUSH_FETB2_Msk                             (0x01UL << USB1_ENDPTFLUSH_FETB2_Pos)
#define USB1_ENDPTFLUSH_FETB3_Pos                             19
#define USB1_ENDPTFLUSH_FETB3_Msk                             (0x01UL << USB1_ENDPTFLUSH_FETB3_Pos)

// -------------------------------------  USB1_ENDPTSTAT  -----------------------------------------
#define USB1_ENDPTSTAT_ERBR0_Pos                              0
#define USB1_ENDPTSTAT_ERBR0_Msk                              (0x01UL << USB1_ENDPTSTAT_ERBR0_Pos)
#define USB1_ENDPTSTAT_ERBR1_Pos                              1
#define USB1_ENDPTSTAT_ERBR1_Msk                              (0x01UL << USB1_ENDPTSTAT_ERBR1_Pos)
#define USB1_ENDPTSTAT_ERBR2_Pos                              2
#define USB1_ENDPTSTAT_ERBR2_Msk                              (0x01UL << USB1_ENDPTSTAT_ERBR2_Pos)
#define USB1_ENDPTSTAT_ERBR3_Pos                              3
#define USB1_ENDPTSTAT_ERBR3_Msk                              (0x01UL << USB1_ENDPTSTAT_ERBR3_Pos)
#define USB1_ENDPTSTAT_ETBR0_Pos                              16
#define USB1_ENDPTSTAT_ETBR0_Msk                              (0x01UL << USB1_ENDPTSTAT_ETBR0_Pos)
#define USB1_ENDPTSTAT_ETBR1_Pos                              17
#define USB1_ENDPTSTAT_ETBR1_Msk                              (0x01UL << USB1_ENDPTSTAT_ETBR1_Pos)
#define USB1_ENDPTSTAT_ETBR2_Pos                              18
#define USB1_ENDPTSTAT_ETBR2_Msk                              (0x01UL << USB1_ENDPTSTAT_ETBR2_Pos)
#define USB1_ENDPTSTAT_ETBR3_Pos                              19
#define USB1_ENDPTSTAT_ETBR3_Msk                              (0x01UL << USB1_ENDPTSTAT_ETBR3_Pos)

// -----------------------------------  USB1_ENDPTCOMPLETE  ---------------------------------------
#define USB1_ENDPTCOMPLETE_ERCE0_Pos                          0
#define USB1_ENDPTCOMPLETE_ERCE0_Msk                          (0x01UL << USB1_ENDPTCOMPLETE_ERCE0_Pos)
#define USB1_ENDPTCOMPLETE_ERCE1_Pos                          1
#define USB1_ENDPTCOMPLETE_ERCE1_Msk                          (0x01UL << USB1_ENDPTCOMPLETE_ERCE1_Pos)
#define USB1_ENDPTCOMPLETE_ERCE2_Pos                          2
#define USB1_ENDPTCOMPLETE_ERCE2_Msk                          (0x01UL << USB1_ENDPTCOMPLETE_ERCE2_Pos)
#define USB1_ENDPTCOMPLETE_ERCE3_Pos                          3
#define USB1_ENDPTCOMPLETE_ERCE3_Msk                          (0x01UL << USB1_ENDPTCOMPLETE_ERCE3_Pos)
#define USB1_ENDPTCOMPLETE_ETCE0_Pos                          16
#define USB1_ENDPTCOMPLETE_ETCE0_Msk                          (0x01UL << USB1_ENDPTCOMPLETE_ETCE0_Pos)
#define USB1_ENDPTCOMPLETE_ETCE1_Pos                          17
#define USB1_ENDPTCOMPLETE_ETCE1_Msk                          (0x01UL << USB1_ENDPTCOMPLETE_ETCE1_Pos)
#define USB1_ENDPTCOMPLETE_ETCE2_Pos                          18
#define USB1_ENDPTCOMPLETE_ETCE2_Msk                          (0x01UL << USB1_ENDPTCOMPLETE_ETCE2_Pos)
#define USB1_ENDPTCOMPLETE_ETCE3_Pos                          19
#define USB1_ENDPTCOMPLETE_ETCE3_Msk                          (0x01UL << USB1_ENDPTCOMPLETE_ETCE3_Pos)

// -------------------------------------  USB1_ENDPTCTRL0  ----------------------------------------
#define USB1_ENDPTCTRL0_RXS_Pos                               0
#define USB1_ENDPTCTRL0_RXS_Msk                               (0x01UL << USB1_ENDPTCTRL0_RXS_Pos)
#define USB1_ENDPTCTRL0_RXT_Pos                               2
#define USB1_ENDPTCTRL0_RXT_Msk                               (0x03UL << USB1_ENDPTCTRL0_RXT_Pos)
#define USB1_ENDPTCTRL0_RXE_Pos                               7
#define USB1_ENDPTCTRL0_RXE_Msk                               (0x01UL << USB1_ENDPTCTRL0_RXE_Pos)
#define USB1_ENDPTCTRL0_TXS_Pos                               16
#define USB1_ENDPTCTRL0_TXS_Msk                               (0x01UL << USB1_ENDPTCTRL0_TXS_Pos)
#define USB1_ENDPTCTRL0_TXT_Pos                               18
#define USB1_ENDPTCTRL0_TXT_Msk                               (0x03UL << USB1_ENDPTCTRL0_TXT_Pos)
#define USB1_ENDPTCTRL0_TXE_Pos                               23
#define USB1_ENDPTCTRL0_TXE_Msk                               (0x01UL << USB1_ENDPTCTRL0_TXE_Pos)

// -------------------------------------  USB1_ENDPTCTRL1  ----------------------------------------
#define USB1_ENDPTCTRL1_RXS_Pos                               0
#define USB1_ENDPTCTRL1_RXS_Msk                               (0x01UL << USB1_ENDPTCTRL1_RXS_Pos)
#define USB1_ENDPTCTRL1_RXT_Pos                               2
#define USB1_ENDPTCTRL1_RXT_Msk                               (0x03UL << USB1_ENDPTCTRL1_RXT_Pos)
#define USB1_ENDPTCTRL1_RXI_Pos                               5
#define USB1_ENDPTCTRL1_RXI_Msk                               (0x01UL << USB1_ENDPTCTRL1_RXI_Pos)
#define USB1_ENDPTCTRL1_RXR_Pos                               6
#define USB1_ENDPTCTRL1_RXR_Msk                               (0x01UL << USB1_ENDPTCTRL1_RXR_Pos)
#define USB1_ENDPTCTRL1_RXE_Pos                               7
#define USB1_ENDPTCTRL1_RXE_Msk                               (0x01UL << USB1_ENDPTCTRL1_RXE_Pos)
#define USB1_ENDPTCTRL1_TXS_Pos                               16
#define USB1_ENDPTCTRL1_TXS_Msk                               (0x01UL << USB1_ENDPTCTRL1_TXS_Pos)
#define USB1_ENDPTCTRL1_TXT_Pos                               18
#define USB1_ENDPTCTRL1_TXT_Msk                               (0x03UL << USB1_ENDPTCTRL1_TXT_Pos)
#define USB1_ENDPTCTRL1_TXI_Pos                               21
#define USB1_ENDPTCTRL1_TXI_Msk                               (0x01UL << USB1_ENDPTCTRL1_TXI_Pos)
#define USB1_ENDPTCTRL1_TXR_Pos                               22
#define USB1_ENDPTCTRL1_TXR_Msk                               (0x01UL << USB1_ENDPTCTRL1_TXR_Pos)
#define USB1_ENDPTCTRL1_TXE_Pos                               23
#define USB1_ENDPTCTRL1_TXE_Msk                               (0x01UL << USB1_ENDPTCTRL1_TXE_Pos)

// -------------------------------------  USB1_ENDPTCTRL2  ----------------------------------------
#define USB1_ENDPTCTRL2_RXS_Pos                               0
#define USB1_ENDPTCTRL2_RXS_Msk                               (0x01UL << USB1_ENDPTCTRL2_RXS_Pos)
#define USB1_ENDPTCTRL2_RXT_Pos                               2
#define USB1_ENDPTCTRL2_RXT_Msk                               (0x03UL << USB1_ENDPTCTRL2_RXT_Pos)
#define USB1_ENDPTCTRL2_RXI_Pos                               5
#define USB1_ENDPTCTRL2_RXI_Msk                               (0x01UL << USB1_ENDPTCTRL2_RXI_Pos)
#define USB1_ENDPTCTRL2_RXR_Pos                               6
#define USB1_ENDPTCTRL2_RXR_Msk                               (0x01UL << USB1_ENDPTCTRL2_RXR_Pos)
#define USB1_ENDPTCTRL2_RXE_Pos                               7
#define USB1_ENDPTCTRL2_RXE_Msk                               (0x01UL << USB1_ENDPTCTRL2_RXE_Pos)
#define USB1_ENDPTCTRL2_TXS_Pos                               16
#define USB1_ENDPTCTRL2_TXS_Msk                               (0x01UL << USB1_ENDPTCTRL2_TXS_Pos)
#define USB1_ENDPTCTRL2_TXT_Pos                               18
#define USB1_ENDPTCTRL2_TXT_Msk                               (0x03UL << USB1_ENDPTCTRL2_TXT_Pos)
#define USB1_ENDPTCTRL2_TXI_Pos                               21
#define USB1_ENDPTCTRL2_TXI_Msk                               (0x01UL << USB1_ENDPTCTRL2_TXI_Pos)
#define USB1_ENDPTCTRL2_TXR_Pos                               22
#define USB1_ENDPTCTRL2_TXR_Msk                               (0x01UL << USB1_ENDPTCTRL2_TXR_Pos)
#define USB1_ENDPTCTRL2_TXE_Pos                               23
#define USB1_ENDPTCTRL2_TXE_Msk                               (0x01UL << USB1_ENDPTCTRL2_TXE_Pos)

// -------------------------------------  USB1_ENDPTCTRL3  ----------------------------------------
#define USB1_ENDPTCTRL3_RXS_Pos                               0
#define USB1_ENDPTCTRL3_RXS_Msk                               (0x01UL << USB1_ENDPTCTRL3_RXS_Pos)
#define USB1_ENDPTCTRL3_RXT_Pos                               2
#define USB1_ENDPTCTRL3_RXT_Msk                               (0x03UL << USB1_ENDPTCTRL3_RXT_Pos)
#define USB1_ENDPTCTRL3_RXI_Pos                               5
#define USB1_ENDPTCTRL3_RXI_Msk                               (0x01UL << USB1_ENDPTCTRL3_RXI_Pos)
#define USB1_ENDPTCTRL3_RXR_Pos                               6
#define USB1_ENDPTCTRL3_RXR_Msk                               (0x01UL << USB1_ENDPTCTRL3_RXR_Pos)
#define USB1_ENDPTCTRL3_RXE_Pos                               7
#define USB1_ENDPTCTRL3_RXE_Msk                               (0x01UL << USB1_ENDPTCTRL3_RXE_Pos)
#define USB1_ENDPTCTRL3_TXS_Pos                               16
#define USB1_ENDPTCTRL3_TXS_Msk                               (0x01UL << USB1_ENDPTCTRL3_TXS_Pos)
#define USB1_ENDPTCTRL3_TXT_Pos                               18
#define USB1_ENDPTCTRL3_TXT_Msk                               (0x03UL << USB1_ENDPTCTRL3_TXT_Pos)
#define USB1_ENDPTCTRL3_TXI_Pos                               21
#define USB1_ENDPTCTRL3_TXI_Msk                               (0x01UL << USB1_ENDPTCTRL3_TXI_Pos)
#define USB1_ENDPTCTRL3_TXR_Pos                               22
#define USB1_ENDPTCTRL3_TXR_Msk                               (0x01UL << USB1_ENDPTCTRL3_TXR_Pos)
#define USB1_ENDPTCTRL3_TXE_Pos                               23
#define USB1_ENDPTCTRL3_TXE_Msk                               (0x01UL << USB1_ENDPTCTRL3_TXE_Pos)


// ------------------------------------------------------------------------------------------------
// -----                                  LCD Position & Mask                                 -----
// ------------------------------------------------------------------------------------------------


// ----------------------------------------  LCD_TIMH  --------------------------------------------
#define LCD_TIMH_PPL_Pos                                      2
#define LCD_TIMH_PPL_Msk                                      (0x3fUL << LCD_TIMH_PPL_Pos)
#define LCD_TIMH_HSW_Pos                                      8
#define LCD_TIMH_HSW_Msk                                      (0x000000ffUL << LCD_TIMH_HSW_Pos)
#define LCD_TIMH_HFP_Pos                                      16
#define LCD_TIMH_HFP_Msk                                      (0x000000ffUL << LCD_TIMH_HFP_Pos)
#define LCD_TIMH_HBP_Pos                                      24
#define LCD_TIMH_HBP_Msk                                      (0x000000ffUL << LCD_TIMH_HBP_Pos)

// ----------------------------------------  LCD_TIMV  --------------------------------------------
#define LCD_TIMV_LPP_Pos                                      0
#define LCD_TIMV_LPP_Msk                                      (0x000003ffUL << LCD_TIMV_LPP_Pos)
#define LCD_TIMV_VSW_Pos                                      10
#define LCD_TIMV_VSW_Msk                                      (0x3fUL << LCD_TIMV_VSW_Pos)
#define LCD_TIMV_VFP_Pos                                      16
#define LCD_TIMV_VFP_Msk                                      (0x000000ffUL << LCD_TIMV_VFP_Pos)
#define LCD_TIMV_VBP_Pos                                      24
#define LCD_TIMV_VBP_Msk                                      (0x000000ffUL << LCD_TIMV_VBP_Pos)

// -----------------------------------------  LCD_POL  --------------------------------------------
#define LCD_POL_PCD_LO_Pos                                    0
#define LCD_POL_PCD_LO_Msk                                    (0x1fUL << LCD_POL_PCD_LO_Pos)
#define LCD_POL_CLKSEL_Pos                                    5
#define LCD_POL_CLKSEL_Msk                                    (0x01UL << LCD_POL_CLKSEL_Pos)
#define LCD_POL_ACB_Pos                                       6
#define LCD_POL_ACB_Msk                                       (0x1fUL << LCD_POL_ACB_Pos)
#define LCD_POL_IVS_Pos                                       11
#define LCD_POL_IVS_Msk                                       (0x01UL << LCD_POL_IVS_Pos)
#define LCD_POL_IHS_Pos                                       12
#define LCD_POL_IHS_Msk                                       (0x01UL << LCD_POL_IHS_Pos)
#define LCD_POL_IPC_Pos                                       13
#define LCD_POL_IPC_Msk                                       (0x01UL << LCD_POL_IPC_Pos)
#define LCD_POL_IOE_Pos                                       14
#define LCD_POL_IOE_Msk                                       (0x01UL << LCD_POL_IOE_Pos)
#define LCD_POL_CPL_Pos                                       16
#define LCD_POL_CPL_Msk                                       (0x000003ffUL << LCD_POL_CPL_Pos)
#define LCD_POL_BCD_Pos                                       26
#define LCD_POL_BCD_Msk                                       (0x01UL << LCD_POL_BCD_Pos)
#define LCD_POL_PCD_HI_Pos                                    27
#define LCD_POL_PCD_HI_Msk                                    (0x1fUL << LCD_POL_PCD_HI_Pos)

// -----------------------------------------  LCD_LE  ---------------------------------------------
#define LCD_LE_LED_Pos                                        0
#define LCD_LE_LED_Msk                                        (0x7fUL << LCD_LE_LED_Pos)
#define LCD_LE_LEE_Pos                                        16
#define LCD_LE_LEE_Msk                                        (0x01UL << LCD_LE_LEE_Pos)

// ---------------------------------------  LCD_UPBASE  -------------------------------------------
#define LCD_UPBASE_LCDUPBASE_Pos                              3
#define LCD_UPBASE_LCDUPBASE_Msk                              (0x1fffffffUL << LCD_UPBASE_LCDUPBASE_Pos)

// ---------------------------------------  LCD_LPBASE  -------------------------------------------
#define LCD_LPBASE_LCDLPBASE_Pos                              3
#define LCD_LPBASE_LCDLPBASE_Msk                              (0x1fffffffUL << LCD_LPBASE_LCDLPBASE_Pos)

// ----------------------------------------  LCD_CTRL  --------------------------------------------
#define LCD_CTRL_LCDEN_Pos                                    0
#define LCD_CTRL_LCDEN_Msk                                    (0x01UL << LCD_CTRL_LCDEN_Pos)
#define LCD_CTRL_LCDBPP_Pos                                   1
#define LCD_CTRL_LCDBPP_Msk                                   (0x07UL << LCD_CTRL_LCDBPP_Pos)
#define LCD_CTRL_LCDBW_Pos                                    4
#define LCD_CTRL_LCDBW_Msk                                    (0x01UL << LCD_CTRL_LCDBW_Pos)
#define LCD_CTRL_LCDTFT_Pos                                   5
#define LCD_CTRL_LCDTFT_Msk                                   (0x01UL << LCD_CTRL_LCDTFT_Pos)
#define LCD_CTRL_LCDMONO8_Pos                                 6
#define LCD_CTRL_LCDMONO8_Msk                                 (0x01UL << LCD_CTRL_LCDMONO8_Pos)
#define LCD_CTRL_LCDDUAL_Pos                                  7
#define LCD_CTRL_LCDDUAL_Msk                                  (0x01UL << LCD_CTRL_LCDDUAL_Pos)
#define LCD_CTRL_BGR_Pos                                      8
#define LCD_CTRL_BGR_Msk                                      (0x01UL << LCD_CTRL_BGR_Pos)
#define LCD_CTRL_BEBO_Pos                                     9
#define LCD_CTRL_BEBO_Msk                                     (0x01UL << LCD_CTRL_BEBO_Pos)
#define LCD_CTRL_BEPO_Pos                                     10
#define LCD_CTRL_BEPO_Msk                                     (0x01UL << LCD_CTRL_BEPO_Pos)
#define LCD_CTRL_LCDPWR_Pos                                   11
#define LCD_CTRL_LCDPWR_Msk                                   (0x01UL << LCD_CTRL_LCDPWR_Pos)
#define LCD_CTRL_LCDVCOMP_Pos                                 12
#define LCD_CTRL_LCDVCOMP_Msk                                 (0x03UL << LCD_CTRL_LCDVCOMP_Pos)
#define LCD_CTRL_WATERMARK_Pos                                16
#define LCD_CTRL_WATERMARK_Msk                                (0x01UL << LCD_CTRL_WATERMARK_Pos)

// ---------------------------------------  LCD_INTMSK  -------------------------------------------
#define LCD_INTMSK_FUFIM_Pos                                  1
#define LCD_INTMSK_FUFIM_Msk                                  (0x01UL << LCD_INTMSK_FUFIM_Pos)
#define LCD_INTMSK_LNBUIM_Pos                                 2
#define LCD_INTMSK_LNBUIM_Msk                                 (0x01UL << LCD_INTMSK_LNBUIM_Pos)
#define LCD_INTMSK_VCOMPIM_Pos                                3
#define LCD_INTMSK_VCOMPIM_Msk                                (0x01UL << LCD_INTMSK_VCOMPIM_Pos)
#define LCD_INTMSK_BERIM_Pos                                  4
#define LCD_INTMSK_BERIM_Msk                                  (0x01UL << LCD_INTMSK_BERIM_Pos)

// ---------------------------------------  LCD_INTRAW  -------------------------------------------
#define LCD_INTRAW_FUFRIS_Pos                                 1
#define LCD_INTRAW_FUFRIS_Msk                                 (0x01UL << LCD_INTRAW_FUFRIS_Pos)
#define LCD_INTRAW_LNBURIS_Pos                                2
#define LCD_INTRAW_LNBURIS_Msk                                (0x01UL << LCD_INTRAW_LNBURIS_Pos)
#define LCD_INTRAW_VCOMPRIS_Pos                               3
#define LCD_INTRAW_VCOMPRIS_Msk                               (0x01UL << LCD_INTRAW_VCOMPRIS_Pos)
#define LCD_INTRAW_BERRAW_Pos                                 4
#define LCD_INTRAW_BERRAW_Msk                                 (0x01UL << LCD_INTRAW_BERRAW_Pos)

// ---------------------------------------  LCD_INTSTAT  ------------------------------------------
#define LCD_INTSTAT_FUFMIS_Pos                                1
#define LCD_INTSTAT_FUFMIS_Msk                                (0x01UL << LCD_INTSTAT_FUFMIS_Pos)
#define LCD_INTSTAT_LNBUMIS_Pos                               2
#define LCD_INTSTAT_LNBUMIS_Msk                               (0x01UL << LCD_INTSTAT_LNBUMIS_Pos)
#define LCD_INTSTAT_VCOMPMIS_Pos                              3
#define LCD_INTSTAT_VCOMPMIS_Msk                              (0x01UL << LCD_INTSTAT_VCOMPMIS_Pos)
#define LCD_INTSTAT_BERMIS_Pos                                4
#define LCD_INTSTAT_BERMIS_Msk                                (0x01UL << LCD_INTSTAT_BERMIS_Pos)

// ---------------------------------------  LCD_INTCLR  -------------------------------------------
#define LCD_INTCLR_FUFIC_Pos                                  1
#define LCD_INTCLR_FUFIC_Msk                                  (0x01UL << LCD_INTCLR_FUFIC_Pos)
#define LCD_INTCLR_LNBUIC_Pos                                 2
#define LCD_INTCLR_LNBUIC_Msk                                 (0x01UL << LCD_INTCLR_LNBUIC_Pos)
#define LCD_INTCLR_VCOMPIC_Pos                                3
#define LCD_INTCLR_VCOMPIC_Msk                                (0x01UL << LCD_INTCLR_VCOMPIC_Pos)
#define LCD_INTCLR_BERIC_Pos                                  4
#define LCD_INTCLR_BERIC_Msk                                  (0x01UL << LCD_INTCLR_BERIC_Pos)

// ---------------------------------------  LCD_UPCURR  -------------------------------------------
#define LCD_UPCURR_LCDUPCURR_Pos                              0
#define LCD_UPCURR_LCDUPCURR_Msk                              (0xffffffffUL << LCD_UPCURR_LCDUPCURR_Pos)

// ---------------------------------------  LCD_LPCURR  -------------------------------------------
#define LCD_LPCURR_LCDLPCURR_Pos                              0
#define LCD_LPCURR_LCDLPCURR_Msk                              (0xffffffffUL << LCD_LPCURR_LCDLPCURR_Pos)

// ----------------------------------------  LCD_PAL0  --------------------------------------------
#define LCD_PAL0_R04_0_Pos                                    0
#define LCD_PAL0_R04_0_Msk                                    (0x1fUL << LCD_PAL0_R04_0_Pos)
#define LCD_PAL0_G04_0_Pos                                    5
#define LCD_PAL0_G04_0_Msk                                    (0x1fUL << LCD_PAL0_G04_0_Pos)
#define LCD_PAL0_B04_0_Pos                                    10
#define LCD_PAL0_B04_0_Msk                                    (0x1fUL << LCD_PAL0_B04_0_Pos)
#define LCD_PAL0_I0_Pos                                       15
#define LCD_PAL0_I0_Msk                                       (0x01UL << LCD_PAL0_I0_Pos)
#define LCD_PAL0_R14_0_Pos                                    16
#define LCD_PAL0_R14_0_Msk                                    (0x1fUL << LCD_PAL0_R14_0_Pos)
#define LCD_PAL0_G14_0_Pos                                    21
#define LCD_PAL0_G14_0_Msk                                    (0x1fUL << LCD_PAL0_G14_0_Pos)
#define LCD_PAL0_B14_0_Pos                                    26
#define LCD_PAL0_B14_0_Msk                                    (0x1fUL << LCD_PAL0_B14_0_Pos)
#define LCD_PAL0_I1_Pos                                       31
#define LCD_PAL0_I1_Msk                                       (0x01UL << LCD_PAL0_I1_Pos)

// ----------------------------------------  LCD_PAL1  --------------------------------------------
#define LCD_PAL1_R04_0_Pos                                    0
#define LCD_PAL1_R04_0_Msk                                    (0x1fUL << LCD_PAL1_R04_0_Pos)
#define LCD_PAL1_G04_0_Pos                                    5
#define LCD_PAL1_G04_0_Msk                                    (0x1fUL << LCD_PAL1_G04_0_Pos)
#define LCD_PAL1_B04_0_Pos                                    10
#define LCD_PAL1_B04_0_Msk                                    (0x1fUL << LCD_PAL1_B04_0_Pos)
#define LCD_PAL1_I0_Pos                                       15
#define LCD_PAL1_I0_Msk                                       (0x01UL << LCD_PAL1_I0_Pos)
#define LCD_PAL1_R14_0_Pos                                    16
#define LCD_PAL1_R14_0_Msk                                    (0x1fUL << LCD_PAL1_R14_0_Pos)
#define LCD_PAL1_G14_0_Pos                                    21
#define LCD_PAL1_G14_0_Msk                                    (0x1fUL << LCD_PAL1_G14_0_Pos)
#define LCD_PAL1_B14_0_Pos                                    26
#define LCD_PAL1_B14_0_Msk                                    (0x1fUL << LCD_PAL1_B14_0_Pos)
#define LCD_PAL1_I1_Pos                                       31
#define LCD_PAL1_I1_Msk                                       (0x01UL << LCD_PAL1_I1_Pos)

// ----------------------------------------  LCD_PAL2  --------------------------------------------
#define LCD_PAL2_R04_0_Pos                                    0
#define LCD_PAL2_R04_0_Msk                                    (0x1fUL << LCD_PAL2_R04_0_Pos)
#define LCD_PAL2_G04_0_Pos                                    5
#define LCD_PAL2_G04_0_Msk                                    (0x1fUL << LCD_PAL2_G04_0_Pos)
#define LCD_PAL2_B04_0_Pos                                    10
#define LCD_PAL2_B04_0_Msk                                    (0x1fUL << LCD_PAL2_B04_0_Pos)
#define LCD_PAL2_I0_Pos                                       15
#define LCD_PAL2_I0_Msk                                       (0x01UL << LCD_PAL2_I0_Pos)
#define LCD_PAL2_R14_0_Pos                                    16
#define LCD_PAL2_R14_0_Msk                                    (0x1fUL << LCD_PAL2_R14_0_Pos)
#define LCD_PAL2_G14_0_Pos                                    21
#define LCD_PAL2_G14_0_Msk                                    (0x1fUL << LCD_PAL2_G14_0_Pos)
#define LCD_PAL2_B14_0_Pos                                    26
#define LCD_PAL2_B14_0_Msk                                    (0x1fUL << LCD_PAL2_B14_0_Pos)
#define LCD_PAL2_I1_Pos                                       31
#define LCD_PAL2_I1_Msk                                       (0x01UL << LCD_PAL2_I1_Pos)

// ----------------------------------------  LCD_PAL3  --------------------------------------------
#define LCD_PAL3_R04_0_Pos                                    0
#define LCD_PAL3_R04_0_Msk                                    (0x1fUL << LCD_PAL3_R04_0_Pos)
#define LCD_PAL3_G04_0_Pos                                    5
#define LCD_PAL3_G04_0_Msk                                    (0x1fUL << LCD_PAL3_G04_0_Pos)
#define LCD_PAL3_B04_0_Pos                                    10
#define LCD_PAL3_B04_0_Msk                                    (0x1fUL << LCD_PAL3_B04_0_Pos)
#define LCD_PAL3_I0_Pos                                       15
#define LCD_PAL3_I0_Msk                                       (0x01UL << LCD_PAL3_I0_Pos)
#define LCD_PAL3_R14_0_Pos                                    16
#define LCD_PAL3_R14_0_Msk                                    (0x1fUL << LCD_PAL3_R14_0_Pos)
#define LCD_PAL3_G14_0_Pos                                    21
#define LCD_PAL3_G14_0_Msk                                    (0x1fUL << LCD_PAL3_G14_0_Pos)
#define LCD_PAL3_B14_0_Pos                                    26
#define LCD_PAL3_B14_0_Msk                                    (0x1fUL << LCD_PAL3_B14_0_Pos)
#define LCD_PAL3_I1_Pos                                       31
#define LCD_PAL3_I1_Msk                                       (0x01UL << LCD_PAL3_I1_Pos)

// ----------------------------------------  LCD_PAL4  --------------------------------------------
#define LCD_PAL4_R04_0_Pos                                    0
#define LCD_PAL4_R04_0_Msk                                    (0x1fUL << LCD_PAL4_R04_0_Pos)
#define LCD_PAL4_G04_0_Pos                                    5
#define LCD_PAL4_G04_0_Msk                                    (0x1fUL << LCD_PAL4_G04_0_Pos)
#define LCD_PAL4_B04_0_Pos                                    10
#define LCD_PAL4_B04_0_Msk                                    (0x1fUL << LCD_PAL4_B04_0_Pos)
#define LCD_PAL4_I0_Pos                                       15
#define LCD_PAL4_I0_Msk                                       (0x01UL << LCD_PAL4_I0_Pos)
#define LCD_PAL4_R14_0_Pos                                    16
#define LCD_PAL4_R14_0_Msk                                    (0x1fUL << LCD_PAL4_R14_0_Pos)
#define LCD_PAL4_G14_0_Pos                                    21
#define LCD_PAL4_G14_0_Msk                                    (0x1fUL << LCD_PAL4_G14_0_Pos)
#define LCD_PAL4_B14_0_Pos                                    26
#define LCD_PAL4_B14_0_Msk                                    (0x1fUL << LCD_PAL4_B14_0_Pos)
#define LCD_PAL4_I1_Pos                                       31
#define LCD_PAL4_I1_Msk                                       (0x01UL << LCD_PAL4_I1_Pos)

// ----------------------------------------  LCD_PAL5  --------------------------------------------
#define LCD_PAL5_R04_0_Pos                                    0
#define LCD_PAL5_R04_0_Msk                                    (0x1fUL << LCD_PAL5_R04_0_Pos)
#define LCD_PAL5_G04_0_Pos                                    5
#define LCD_PAL5_G04_0_Msk                                    (0x1fUL << LCD_PAL5_G04_0_Pos)
#define LCD_PAL5_B04_0_Pos                                    10
#define LCD_PAL5_B04_0_Msk                                    (0x1fUL << LCD_PAL5_B04_0_Pos)
#define LCD_PAL5_I0_Pos                                       15
#define LCD_PAL5_I0_Msk                                       (0x01UL << LCD_PAL5_I0_Pos)
#define LCD_PAL5_R14_0_Pos                                    16
#define LCD_PAL5_R14_0_Msk                                    (0x1fUL << LCD_PAL5_R14_0_Pos)
#define LCD_PAL5_G14_0_Pos                                    21
#define LCD_PAL5_G14_0_Msk                                    (0x1fUL << LCD_PAL5_G14_0_Pos)
#define LCD_PAL5_B14_0_Pos                                    26
#define LCD_PAL5_B14_0_Msk                                    (0x1fUL << LCD_PAL5_B14_0_Pos)
#define LCD_PAL5_I1_Pos                                       31
#define LCD_PAL5_I1_Msk                                       (0x01UL << LCD_PAL5_I1_Pos)

// ----------------------------------------  LCD_PAL6  --------------------------------------------
#define LCD_PAL6_R04_0_Pos                                    0
#define LCD_PAL6_R04_0_Msk                                    (0x1fUL << LCD_PAL6_R04_0_Pos)
#define LCD_PAL6_G04_0_Pos                                    5
#define LCD_PAL6_G04_0_Msk                                    (0x1fUL << LCD_PAL6_G04_0_Pos)
#define LCD_PAL6_B04_0_Pos                                    10
#define LCD_PAL6_B04_0_Msk                                    (0x1fUL << LCD_PAL6_B04_0_Pos)
#define LCD_PAL6_I0_Pos                                       15
#define LCD_PAL6_I0_Msk                                       (0x01UL << LCD_PAL6_I0_Pos)
#define LCD_PAL6_R14_0_Pos                                    16
#define LCD_PAL6_R14_0_Msk                                    (0x1fUL << LCD_PAL6_R14_0_Pos)
#define LCD_PAL6_G14_0_Pos                                    21
#define LCD_PAL6_G14_0_Msk                                    (0x1fUL << LCD_PAL6_G14_0_Pos)
#define LCD_PAL6_B14_0_Pos                                    26
#define LCD_PAL6_B14_0_Msk                                    (0x1fUL << LCD_PAL6_B14_0_Pos)
#define LCD_PAL6_I1_Pos                                       31
#define LCD_PAL6_I1_Msk                                       (0x01UL << LCD_PAL6_I1_Pos)

// ----------------------------------------  LCD_PAL7  --------------------------------------------
#define LCD_PAL7_R04_0_Pos                                    0
#define LCD_PAL7_R04_0_Msk                                    (0x1fUL << LCD_PAL7_R04_0_Pos)
#define LCD_PAL7_G04_0_Pos                                    5
#define LCD_PAL7_G04_0_Msk                                    (0x1fUL << LCD_PAL7_G04_0_Pos)
#define LCD_PAL7_B04_0_Pos                                    10
#define LCD_PAL7_B04_0_Msk                                    (0x1fUL << LCD_PAL7_B04_0_Pos)
#define LCD_PAL7_I0_Pos                                       15
#define LCD_PAL7_I0_Msk                                       (0x01UL << LCD_PAL7_I0_Pos)
#define LCD_PAL7_R14_0_Pos                                    16
#define LCD_PAL7_R14_0_Msk                                    (0x1fUL << LCD_PAL7_R14_0_Pos)
#define LCD_PAL7_G14_0_Pos                                    21
#define LCD_PAL7_G14_0_Msk                                    (0x1fUL << LCD_PAL7_G14_0_Pos)
#define LCD_PAL7_B14_0_Pos                                    26
#define LCD_PAL7_B14_0_Msk                                    (0x1fUL << LCD_PAL7_B14_0_Pos)
#define LCD_PAL7_I1_Pos                                       31
#define LCD_PAL7_I1_Msk                                       (0x01UL << LCD_PAL7_I1_Pos)

// ----------------------------------------  LCD_PAL8  --------------------------------------------
#define LCD_PAL8_R04_0_Pos                                    0
#define LCD_PAL8_R04_0_Msk                                    (0x1fUL << LCD_PAL8_R04_0_Pos)
#define LCD_PAL8_G04_0_Pos                                    5
#define LCD_PAL8_G04_0_Msk                                    (0x1fUL << LCD_PAL8_G04_0_Pos)
#define LCD_PAL8_B04_0_Pos                                    10
#define LCD_PAL8_B04_0_Msk                                    (0x1fUL << LCD_PAL8_B04_0_Pos)
#define LCD_PAL8_I0_Pos                                       15
#define LCD_PAL8_I0_Msk                                       (0x01UL << LCD_PAL8_I0_Pos)
#define LCD_PAL8_R14_0_Pos                                    16
#define LCD_PAL8_R14_0_Msk                                    (0x1fUL << LCD_PAL8_R14_0_Pos)
#define LCD_PAL8_G14_0_Pos                                    21
#define LCD_PAL8_G14_0_Msk                                    (0x1fUL << LCD_PAL8_G14_0_Pos)
#define LCD_PAL8_B14_0_Pos                                    26
#define LCD_PAL8_B14_0_Msk                                    (0x1fUL << LCD_PAL8_B14_0_Pos)
#define LCD_PAL8_I1_Pos                                       31
#define LCD_PAL8_I1_Msk                                       (0x01UL << LCD_PAL8_I1_Pos)

// ----------------------------------------  LCD_PAL9  --------------------------------------------
#define LCD_PAL9_R04_0_Pos                                    0
#define LCD_PAL9_R04_0_Msk                                    (0x1fUL << LCD_PAL9_R04_0_Pos)
#define LCD_PAL9_G04_0_Pos                                    5
#define LCD_PAL9_G04_0_Msk                                    (0x1fUL << LCD_PAL9_G04_0_Pos)
#define LCD_PAL9_B04_0_Pos                                    10
#define LCD_PAL9_B04_0_Msk                                    (0x1fUL << LCD_PAL9_B04_0_Pos)
#define LCD_PAL9_I0_Pos                                       15
#define LCD_PAL9_I0_Msk                                       (0x01UL << LCD_PAL9_I0_Pos)
#define LCD_PAL9_R14_0_Pos                                    16
#define LCD_PAL9_R14_0_Msk                                    (0x1fUL << LCD_PAL9_R14_0_Pos)
#define LCD_PAL9_G14_0_Pos                                    21
#define LCD_PAL9_G14_0_Msk                                    (0x1fUL << LCD_PAL9_G14_0_Pos)
#define LCD_PAL9_B14_0_Pos                                    26
#define LCD_PAL9_B14_0_Msk                                    (0x1fUL << LCD_PAL9_B14_0_Pos)
#define LCD_PAL9_I1_Pos                                       31
#define LCD_PAL9_I1_Msk                                       (0x01UL << LCD_PAL9_I1_Pos)

// ----------------------------------------  LCD_PAL10  -------------------------------------------
#define LCD_PAL10_R04_0_Pos                                   0
#define LCD_PAL10_R04_0_Msk                                   (0x1fUL << LCD_PAL10_R04_0_Pos)
#define LCD_PAL10_G04_0_Pos                                   5
#define LCD_PAL10_G04_0_Msk                                   (0x1fUL << LCD_PAL10_G04_0_Pos)
#define LCD_PAL10_B04_0_Pos                                   10
#define LCD_PAL10_B04_0_Msk                                   (0x1fUL << LCD_PAL10_B04_0_Pos)
#define LCD_PAL10_I0_Pos                                      15
#define LCD_PAL10_I0_Msk                                      (0x01UL << LCD_PAL10_I0_Pos)
#define LCD_PAL10_R14_0_Pos                                   16
#define LCD_PAL10_R14_0_Msk                                   (0x1fUL << LCD_PAL10_R14_0_Pos)
#define LCD_PAL10_G14_0_Pos                                   21
#define LCD_PAL10_G14_0_Msk                                   (0x1fUL << LCD_PAL10_G14_0_Pos)
#define LCD_PAL10_B14_0_Pos                                   26
#define LCD_PAL10_B14_0_Msk                                   (0x1fUL << LCD_PAL10_B14_0_Pos)
#define LCD_PAL10_I1_Pos                                      31
#define LCD_PAL10_I1_Msk                                      (0x01UL << LCD_PAL10_I1_Pos)

// ----------------------------------------  LCD_PAL11  -------------------------------------------
#define LCD_PAL11_R04_0_Pos                                   0
#define LCD_PAL11_R04_0_Msk                                   (0x1fUL << LCD_PAL11_R04_0_Pos)
#define LCD_PAL11_G04_0_Pos                                   5
#define LCD_PAL11_G04_0_Msk                                   (0x1fUL << LCD_PAL11_G04_0_Pos)
#define LCD_PAL11_B04_0_Pos                                   10
#define LCD_PAL11_B04_0_Msk                                   (0x1fUL << LCD_PAL11_B04_0_Pos)
#define LCD_PAL11_I0_Pos                                      15
#define LCD_PAL11_I0_Msk                                      (0x01UL << LCD_PAL11_I0_Pos)
#define LCD_PAL11_R14_0_Pos                                   16
#define LCD_PAL11_R14_0_Msk                                   (0x1fUL << LCD_PAL11_R14_0_Pos)
#define LCD_PAL11_G14_0_Pos                                   21
#define LCD_PAL11_G14_0_Msk                                   (0x1fUL << LCD_PAL11_G14_0_Pos)
#define LCD_PAL11_B14_0_Pos                                   26
#define LCD_PAL11_B14_0_Msk                                   (0x1fUL << LCD_PAL11_B14_0_Pos)
#define LCD_PAL11_I1_Pos                                      31
#define LCD_PAL11_I1_Msk                                      (0x01UL << LCD_PAL11_I1_Pos)

// ----------------------------------------  LCD_PAL12  -------------------------------------------
#define LCD_PAL12_R04_0_Pos                                   0
#define LCD_PAL12_R04_0_Msk                                   (0x1fUL << LCD_PAL12_R04_0_Pos)
#define LCD_PAL12_G04_0_Pos                                   5
#define LCD_PAL12_G04_0_Msk                                   (0x1fUL << LCD_PAL12_G04_0_Pos)
#define LCD_PAL12_B04_0_Pos                                   10
#define LCD_PAL12_B04_0_Msk                                   (0x1fUL << LCD_PAL12_B04_0_Pos)
#define LCD_PAL12_I0_Pos                                      15
#define LCD_PAL12_I0_Msk                                      (0x01UL << LCD_PAL12_I0_Pos)
#define LCD_PAL12_R14_0_Pos                                   16
#define LCD_PAL12_R14_0_Msk                                   (0x1fUL << LCD_PAL12_R14_0_Pos)
#define LCD_PAL12_G14_0_Pos                                   21
#define LCD_PAL12_G14_0_Msk                                   (0x1fUL << LCD_PAL12_G14_0_Pos)
#define LCD_PAL12_B14_0_Pos                                   26
#define LCD_PAL12_B14_0_Msk                                   (0x1fUL << LCD_PAL12_B14_0_Pos)
#define LCD_PAL12_I1_Pos                                      31
#define LCD_PAL12_I1_Msk                                      (0x01UL << LCD_PAL12_I1_Pos)

// ----------------------------------------  LCD_PAL13  -------------------------------------------
#define LCD_PAL13_R04_0_Pos                                   0
#define LCD_PAL13_R04_0_Msk                                   (0x1fUL << LCD_PAL13_R04_0_Pos)
#define LCD_PAL13_G04_0_Pos                                   5
#define LCD_PAL13_G04_0_Msk                                   (0x1fUL << LCD_PAL13_G04_0_Pos)
#define LCD_PAL13_B04_0_Pos                                   10
#define LCD_PAL13_B04_0_Msk                                   (0x1fUL << LCD_PAL13_B04_0_Pos)
#define LCD_PAL13_I0_Pos                                      15
#define LCD_PAL13_I0_Msk                                      (0x01UL << LCD_PAL13_I0_Pos)
#define LCD_PAL13_R14_0_Pos                                   16
#define LCD_PAL13_R14_0_Msk                                   (0x1fUL << LCD_PAL13_R14_0_Pos)
#define LCD_PAL13_G14_0_Pos                                   21
#define LCD_PAL13_G14_0_Msk                                   (0x1fUL << LCD_PAL13_G14_0_Pos)
#define LCD_PAL13_B14_0_Pos                                   26
#define LCD_PAL13_B14_0_Msk                                   (0x1fUL << LCD_PAL13_B14_0_Pos)
#define LCD_PAL13_I1_Pos                                      31
#define LCD_PAL13_I1_Msk                                      (0x01UL << LCD_PAL13_I1_Pos)

// ----------------------------------------  LCD_PAL14  -------------------------------------------
#define LCD_PAL14_R04_0_Pos                                   0
#define LCD_PAL14_R04_0_Msk                                   (0x1fUL << LCD_PAL14_R04_0_Pos)
#define LCD_PAL14_G04_0_Pos                                   5
#define LCD_PAL14_G04_0_Msk                                   (0x1fUL << LCD_PAL14_G04_0_Pos)
#define LCD_PAL14_B04_0_Pos                                   10
#define LCD_PAL14_B04_0_Msk                                   (0x1fUL << LCD_PAL14_B04_0_Pos)
#define LCD_PAL14_I0_Pos                                      15
#define LCD_PAL14_I0_Msk                                      (0x01UL << LCD_PAL14_I0_Pos)
#define LCD_PAL14_R14_0_Pos                                   16
#define LCD_PAL14_R14_0_Msk                                   (0x1fUL << LCD_PAL14_R14_0_Pos)
#define LCD_PAL14_G14_0_Pos                                   21
#define LCD_PAL14_G14_0_Msk                                   (0x1fUL << LCD_PAL14_G14_0_Pos)
#define LCD_PAL14_B14_0_Pos                                   26
#define LCD_PAL14_B14_0_Msk                                   (0x1fUL << LCD_PAL14_B14_0_Pos)
#define LCD_PAL14_I1_Pos                                      31
#define LCD_PAL14_I1_Msk                                      (0x01UL << LCD_PAL14_I1_Pos)

// ----------------------------------------  LCD_PAL15  -------------------------------------------
#define LCD_PAL15_R04_0_Pos                                   0
#define LCD_PAL15_R04_0_Msk                                   (0x1fUL << LCD_PAL15_R04_0_Pos)
#define LCD_PAL15_G04_0_Pos                                   5
#define LCD_PAL15_G04_0_Msk                                   (0x1fUL << LCD_PAL15_G04_0_Pos)
#define LCD_PAL15_B04_0_Pos                                   10
#define LCD_PAL15_B04_0_Msk                                   (0x1fUL << LCD_PAL15_B04_0_Pos)
#define LCD_PAL15_I0_Pos                                      15
#define LCD_PAL15_I0_Msk                                      (0x01UL << LCD_PAL15_I0_Pos)
#define LCD_PAL15_R14_0_Pos                                   16
#define LCD_PAL15_R14_0_Msk                                   (0x1fUL << LCD_PAL15_R14_0_Pos)
#define LCD_PAL15_G14_0_Pos                                   21
#define LCD_PAL15_G14_0_Msk                                   (0x1fUL << LCD_PAL15_G14_0_Pos)
#define LCD_PAL15_B14_0_Pos                                   26
#define LCD_PAL15_B14_0_Msk                                   (0x1fUL << LCD_PAL15_B14_0_Pos)
#define LCD_PAL15_I1_Pos                                      31
#define LCD_PAL15_I1_Msk                                      (0x01UL << LCD_PAL15_I1_Pos)

// ----------------------------------------  LCD_PAL16  -------------------------------------------
#define LCD_PAL16_R04_0_Pos                                   0
#define LCD_PAL16_R04_0_Msk                                   (0x1fUL << LCD_PAL16_R04_0_Pos)
#define LCD_PAL16_G04_0_Pos                                   5
#define LCD_PAL16_G04_0_Msk                                   (0x1fUL << LCD_PAL16_G04_0_Pos)
#define LCD_PAL16_B04_0_Pos                                   10
#define LCD_PAL16_B04_0_Msk                                   (0x1fUL << LCD_PAL16_B04_0_Pos)
#define LCD_PAL16_I0_Pos                                      15
#define LCD_PAL16_I0_Msk                                      (0x01UL << LCD_PAL16_I0_Pos)
#define LCD_PAL16_R14_0_Pos                                   16
#define LCD_PAL16_R14_0_Msk                                   (0x1fUL << LCD_PAL16_R14_0_Pos)
#define LCD_PAL16_G14_0_Pos                                   21
#define LCD_PAL16_G14_0_Msk                                   (0x1fUL << LCD_PAL16_G14_0_Pos)
#define LCD_PAL16_B14_0_Pos                                   26
#define LCD_PAL16_B14_0_Msk                                   (0x1fUL << LCD_PAL16_B14_0_Pos)
#define LCD_PAL16_I1_Pos                                      31
#define LCD_PAL16_I1_Msk                                      (0x01UL << LCD_PAL16_I1_Pos)

// ----------------------------------------  LCD_PAL17  -------------------------------------------
#define LCD_PAL17_R04_0_Pos                                   0
#define LCD_PAL17_R04_0_Msk                                   (0x1fUL << LCD_PAL17_R04_0_Pos)
#define LCD_PAL17_G04_0_Pos                                   5
#define LCD_PAL17_G04_0_Msk                                   (0x1fUL << LCD_PAL17_G04_0_Pos)
#define LCD_PAL17_B04_0_Pos                                   10
#define LCD_PAL17_B04_0_Msk                                   (0x1fUL << LCD_PAL17_B04_0_Pos)
#define LCD_PAL17_I0_Pos                                      15
#define LCD_PAL17_I0_Msk                                      (0x01UL << LCD_PAL17_I0_Pos)
#define LCD_PAL17_R14_0_Pos                                   16
#define LCD_PAL17_R14_0_Msk                                   (0x1fUL << LCD_PAL17_R14_0_Pos)
#define LCD_PAL17_G14_0_Pos                                   21
#define LCD_PAL17_G14_0_Msk                                   (0x1fUL << LCD_PAL17_G14_0_Pos)
#define LCD_PAL17_B14_0_Pos                                   26
#define LCD_PAL17_B14_0_Msk                                   (0x1fUL << LCD_PAL17_B14_0_Pos)
#define LCD_PAL17_I1_Pos                                      31
#define LCD_PAL17_I1_Msk                                      (0x01UL << LCD_PAL17_I1_Pos)

// ----------------------------------------  LCD_PAL18  -------------------------------------------
#define LCD_PAL18_R04_0_Pos                                   0
#define LCD_PAL18_R04_0_Msk                                   (0x1fUL << LCD_PAL18_R04_0_Pos)
#define LCD_PAL18_G04_0_Pos                                   5
#define LCD_PAL18_G04_0_Msk                                   (0x1fUL << LCD_PAL18_G04_0_Pos)
#define LCD_PAL18_B04_0_Pos                                   10
#define LCD_PAL18_B04_0_Msk                                   (0x1fUL << LCD_PAL18_B04_0_Pos)
#define LCD_PAL18_I0_Pos                                      15
#define LCD_PAL18_I0_Msk                                      (0x01UL << LCD_PAL18_I0_Pos)
#define LCD_PAL18_R14_0_Pos                                   16
#define LCD_PAL18_R14_0_Msk                                   (0x1fUL << LCD_PAL18_R14_0_Pos)
#define LCD_PAL18_G14_0_Pos                                   21
#define LCD_PAL18_G14_0_Msk                                   (0x1fUL << LCD_PAL18_G14_0_Pos)
#define LCD_PAL18_B14_0_Pos                                   26
#define LCD_PAL18_B14_0_Msk                                   (0x1fUL << LCD_PAL18_B14_0_Pos)
#define LCD_PAL18_I1_Pos                                      31
#define LCD_PAL18_I1_Msk                                      (0x01UL << LCD_PAL18_I1_Pos)

// ----------------------------------------  LCD_PAL19  -------------------------------------------
#define LCD_PAL19_R04_0_Pos                                   0
#define LCD_PAL19_R04_0_Msk                                   (0x1fUL << LCD_PAL19_R04_0_Pos)
#define LCD_PAL19_G04_0_Pos                                   5
#define LCD_PAL19_G04_0_Msk                                   (0x1fUL << LCD_PAL19_G04_0_Pos)
#define LCD_PAL19_B04_0_Pos                                   10
#define LCD_PAL19_B04_0_Msk                                   (0x1fUL << LCD_PAL19_B04_0_Pos)
#define LCD_PAL19_I0_Pos                                      15
#define LCD_PAL19_I0_Msk                                      (0x01UL << LCD_PAL19_I0_Pos)
#define LCD_PAL19_R14_0_Pos                                   16
#define LCD_PAL19_R14_0_Msk                                   (0x1fUL << LCD_PAL19_R14_0_Pos)
#define LCD_PAL19_G14_0_Pos                                   21
#define LCD_PAL19_G14_0_Msk                                   (0x1fUL << LCD_PAL19_G14_0_Pos)
#define LCD_PAL19_B14_0_Pos                                   26
#define LCD_PAL19_B14_0_Msk                                   (0x1fUL << LCD_PAL19_B14_0_Pos)
#define LCD_PAL19_I1_Pos                                      31
#define LCD_PAL19_I1_Msk                                      (0x01UL << LCD_PAL19_I1_Pos)

// ----------------------------------------  LCD_PAL20  -------------------------------------------
#define LCD_PAL20_R04_0_Pos                                   0
#define LCD_PAL20_R04_0_Msk                                   (0x1fUL << LCD_PAL20_R04_0_Pos)
#define LCD_PAL20_G04_0_Pos                                   5
#define LCD_PAL20_G04_0_Msk                                   (0x1fUL << LCD_PAL20_G04_0_Pos)
#define LCD_PAL20_B04_0_Pos                                   10
#define LCD_PAL20_B04_0_Msk                                   (0x1fUL << LCD_PAL20_B04_0_Pos)
#define LCD_PAL20_I0_Pos                                      15
#define LCD_PAL20_I0_Msk                                      (0x01UL << LCD_PAL20_I0_Pos)
#define LCD_PAL20_R14_0_Pos                                   16
#define LCD_PAL20_R14_0_Msk                                   (0x1fUL << LCD_PAL20_R14_0_Pos)
#define LCD_PAL20_G14_0_Pos                                   21
#define LCD_PAL20_G14_0_Msk                                   (0x1fUL << LCD_PAL20_G14_0_Pos)
#define LCD_PAL20_B14_0_Pos                                   26
#define LCD_PAL20_B14_0_Msk                                   (0x1fUL << LCD_PAL20_B14_0_Pos)
#define LCD_PAL20_I1_Pos                                      31
#define LCD_PAL20_I1_Msk                                      (0x01UL << LCD_PAL20_I1_Pos)

// ----------------------------------------  LCD_PAL21  -------------------------------------------
#define LCD_PAL21_R04_0_Pos                                   0
#define LCD_PAL21_R04_0_Msk                                   (0x1fUL << LCD_PAL21_R04_0_Pos)
#define LCD_PAL21_G04_0_Pos                                   5
#define LCD_PAL21_G04_0_Msk                                   (0x1fUL << LCD_PAL21_G04_0_Pos)
#define LCD_PAL21_B04_0_Pos                                   10
#define LCD_PAL21_B04_0_Msk                                   (0x1fUL << LCD_PAL21_B04_0_Pos)
#define LCD_PAL21_I0_Pos                                      15
#define LCD_PAL21_I0_Msk                                      (0x01UL << LCD_PAL21_I0_Pos)
#define LCD_PAL21_R14_0_Pos                                   16
#define LCD_PAL21_R14_0_Msk                                   (0x1fUL << LCD_PAL21_R14_0_Pos)
#define LCD_PAL21_G14_0_Pos                                   21
#define LCD_PAL21_G14_0_Msk                                   (0x1fUL << LCD_PAL21_G14_0_Pos)
#define LCD_PAL21_B14_0_Pos                                   26
#define LCD_PAL21_B14_0_Msk                                   (0x1fUL << LCD_PAL21_B14_0_Pos)
#define LCD_PAL21_I1_Pos                                      31
#define LCD_PAL21_I1_Msk                                      (0x01UL << LCD_PAL21_I1_Pos)

// ----------------------------------------  LCD_PAL22  -------------------------------------------
#define LCD_PAL22_R04_0_Pos                                   0
#define LCD_PAL22_R04_0_Msk                                   (0x1fUL << LCD_PAL22_R04_0_Pos)
#define LCD_PAL22_G04_0_Pos                                   5
#define LCD_PAL22_G04_0_Msk                                   (0x1fUL << LCD_PAL22_G04_0_Pos)
#define LCD_PAL22_B04_0_Pos                                   10
#define LCD_PAL22_B04_0_Msk                                   (0x1fUL << LCD_PAL22_B04_0_Pos)
#define LCD_PAL22_I0_Pos                                      15
#define LCD_PAL22_I0_Msk                                      (0x01UL << LCD_PAL22_I0_Pos)
#define LCD_PAL22_R14_0_Pos                                   16
#define LCD_PAL22_R14_0_Msk                                   (0x1fUL << LCD_PAL22_R14_0_Pos)
#define LCD_PAL22_G14_0_Pos                                   21
#define LCD_PAL22_G14_0_Msk                                   (0x1fUL << LCD_PAL22_G14_0_Pos)
#define LCD_PAL22_B14_0_Pos                                   26
#define LCD_PAL22_B14_0_Msk                                   (0x1fUL << LCD_PAL22_B14_0_Pos)
#define LCD_PAL22_I1_Pos                                      31
#define LCD_PAL22_I1_Msk                                      (0x01UL << LCD_PAL22_I1_Pos)

// ----------------------------------------  LCD_PAL23  -------------------------------------------
#define LCD_PAL23_R04_0_Pos                                   0
#define LCD_PAL23_R04_0_Msk                                   (0x1fUL << LCD_PAL23_R04_0_Pos)
#define LCD_PAL23_G04_0_Pos                                   5
#define LCD_PAL23_G04_0_Msk                                   (0x1fUL << LCD_PAL23_G04_0_Pos)
#define LCD_PAL23_B04_0_Pos                                   10
#define LCD_PAL23_B04_0_Msk                                   (0x1fUL << LCD_PAL23_B04_0_Pos)
#define LCD_PAL23_I0_Pos                                      15
#define LCD_PAL23_I0_Msk                                      (0x01UL << LCD_PAL23_I0_Pos)
#define LCD_PAL23_R14_0_Pos                                   16
#define LCD_PAL23_R14_0_Msk                                   (0x1fUL << LCD_PAL23_R14_0_Pos)
#define LCD_PAL23_G14_0_Pos                                   21
#define LCD_PAL23_G14_0_Msk                                   (0x1fUL << LCD_PAL23_G14_0_Pos)
#define LCD_PAL23_B14_0_Pos                                   26
#define LCD_PAL23_B14_0_Msk                                   (0x1fUL << LCD_PAL23_B14_0_Pos)
#define LCD_PAL23_I1_Pos                                      31
#define LCD_PAL23_I1_Msk                                      (0x01UL << LCD_PAL23_I1_Pos)

// ----------------------------------------  LCD_PAL24  -------------------------------------------
#define LCD_PAL24_R04_0_Pos                                   0
#define LCD_PAL24_R04_0_Msk                                   (0x1fUL << LCD_PAL24_R04_0_Pos)
#define LCD_PAL24_G04_0_Pos                                   5
#define LCD_PAL24_G04_0_Msk                                   (0x1fUL << LCD_PAL24_G04_0_Pos)
#define LCD_PAL24_B04_0_Pos                                   10
#define LCD_PAL24_B04_0_Msk                                   (0x1fUL << LCD_PAL24_B04_0_Pos)
#define LCD_PAL24_I0_Pos                                      15
#define LCD_PAL24_I0_Msk                                      (0x01UL << LCD_PAL24_I0_Pos)
#define LCD_PAL24_R14_0_Pos                                   16
#define LCD_PAL24_R14_0_Msk                                   (0x1fUL << LCD_PAL24_R14_0_Pos)
#define LCD_PAL24_G14_0_Pos                                   21
#define LCD_PAL24_G14_0_Msk                                   (0x1fUL << LCD_PAL24_G14_0_Pos)
#define LCD_PAL24_B14_0_Pos                                   26
#define LCD_PAL24_B14_0_Msk                                   (0x1fUL << LCD_PAL24_B14_0_Pos)
#define LCD_PAL24_I1_Pos                                      31
#define LCD_PAL24_I1_Msk                                      (0x01UL << LCD_PAL24_I1_Pos)

// ----------------------------------------  LCD_PAL25  -------------------------------------------
#define LCD_PAL25_R04_0_Pos                                   0
#define LCD_PAL25_R04_0_Msk                                   (0x1fUL << LCD_PAL25_R04_0_Pos)
#define LCD_PAL25_G04_0_Pos                                   5
#define LCD_PAL25_G04_0_Msk                                   (0x1fUL << LCD_PAL25_G04_0_Pos)
#define LCD_PAL25_B04_0_Pos                                   10
#define LCD_PAL25_B04_0_Msk                                   (0x1fUL << LCD_PAL25_B04_0_Pos)
#define LCD_PAL25_I0_Pos                                      15
#define LCD_PAL25_I0_Msk                                      (0x01UL << LCD_PAL25_I0_Pos)
#define LCD_PAL25_R14_0_Pos                                   16
#define LCD_PAL25_R14_0_Msk                                   (0x1fUL << LCD_PAL25_R14_0_Pos)
#define LCD_PAL25_G14_0_Pos                                   21
#define LCD_PAL25_G14_0_Msk                                   (0x1fUL << LCD_PAL25_G14_0_Pos)
#define LCD_PAL25_B14_0_Pos                                   26
#define LCD_PAL25_B14_0_Msk                                   (0x1fUL << LCD_PAL25_B14_0_Pos)
#define LCD_PAL25_I1_Pos                                      31
#define LCD_PAL25_I1_Msk                                      (0x01UL << LCD_PAL25_I1_Pos)

// ----------------------------------------  LCD_PAL26  -------------------------------------------
#define LCD_PAL26_R04_0_Pos                                   0
#define LCD_PAL26_R04_0_Msk                                   (0x1fUL << LCD_PAL26_R04_0_Pos)
#define LCD_PAL26_G04_0_Pos                                   5
#define LCD_PAL26_G04_0_Msk                                   (0x1fUL << LCD_PAL26_G04_0_Pos)
#define LCD_PAL26_B04_0_Pos                                   10
#define LCD_PAL26_B04_0_Msk                                   (0x1fUL << LCD_PAL26_B04_0_Pos)
#define LCD_PAL26_I0_Pos                                      15
#define LCD_PAL26_I0_Msk                                      (0x01UL << LCD_PAL26_I0_Pos)
#define LCD_PAL26_R14_0_Pos                                   16
#define LCD_PAL26_R14_0_Msk                                   (0x1fUL << LCD_PAL26_R14_0_Pos)
#define LCD_PAL26_G14_0_Pos                                   21
#define LCD_PAL26_G14_0_Msk                                   (0x1fUL << LCD_PAL26_G14_0_Pos)
#define LCD_PAL26_B14_0_Pos                                   26
#define LCD_PAL26_B14_0_Msk                                   (0x1fUL << LCD_PAL26_B14_0_Pos)
#define LCD_PAL26_I1_Pos                                      31
#define LCD_PAL26_I1_Msk                                      (0x01UL << LCD_PAL26_I1_Pos)

// ----------------------------------------  LCD_PAL27  -------------------------------------------
#define LCD_PAL27_R04_0_Pos                                   0
#define LCD_PAL27_R04_0_Msk                                   (0x1fUL << LCD_PAL27_R04_0_Pos)
#define LCD_PAL27_G04_0_Pos                                   5
#define LCD_PAL27_G04_0_Msk                                   (0x1fUL << LCD_PAL27_G04_0_Pos)
#define LCD_PAL27_B04_0_Pos                                   10
#define LCD_PAL27_B04_0_Msk                                   (0x1fUL << LCD_PAL27_B04_0_Pos)
#define LCD_PAL27_I0_Pos                                      15
#define LCD_PAL27_I0_Msk                                      (0x01UL << LCD_PAL27_I0_Pos)
#define LCD_PAL27_R14_0_Pos                                   16
#define LCD_PAL27_R14_0_Msk                                   (0x1fUL << LCD_PAL27_R14_0_Pos)
#define LCD_PAL27_G14_0_Pos                                   21
#define LCD_PAL27_G14_0_Msk                                   (0x1fUL << LCD_PAL27_G14_0_Pos)
#define LCD_PAL27_B14_0_Pos                                   26
#define LCD_PAL27_B14_0_Msk                                   (0x1fUL << LCD_PAL27_B14_0_Pos)
#define LCD_PAL27_I1_Pos                                      31
#define LCD_PAL27_I1_Msk                                      (0x01UL << LCD_PAL27_I1_Pos)

// ----------------------------------------  LCD_PAL28  -------------------------------------------
#define LCD_PAL28_R04_0_Pos                                   0
#define LCD_PAL28_R04_0_Msk                                   (0x1fUL << LCD_PAL28_R04_0_Pos)
#define LCD_PAL28_G04_0_Pos                                   5
#define LCD_PAL28_G04_0_Msk                                   (0x1fUL << LCD_PAL28_G04_0_Pos)
#define LCD_PAL28_B04_0_Pos                                   10
#define LCD_PAL28_B04_0_Msk                                   (0x1fUL << LCD_PAL28_B04_0_Pos)
#define LCD_PAL28_I0_Pos                                      15
#define LCD_PAL28_I0_Msk                                      (0x01UL << LCD_PAL28_I0_Pos)
#define LCD_PAL28_R14_0_Pos                                   16
#define LCD_PAL28_R14_0_Msk                                   (0x1fUL << LCD_PAL28_R14_0_Pos)
#define LCD_PAL28_G14_0_Pos                                   21
#define LCD_PAL28_G14_0_Msk                                   (0x1fUL << LCD_PAL28_G14_0_Pos)
#define LCD_PAL28_B14_0_Pos                                   26
#define LCD_PAL28_B14_0_Msk                                   (0x1fUL << LCD_PAL28_B14_0_Pos)
#define LCD_PAL28_I1_Pos                                      31
#define LCD_PAL28_I1_Msk                                      (0x01UL << LCD_PAL28_I1_Pos)

// ----------------------------------------  LCD_PAL29  -------------------------------------------
#define LCD_PAL29_R04_0_Pos                                   0
#define LCD_PAL29_R04_0_Msk                                   (0x1fUL << LCD_PAL29_R04_0_Pos)
#define LCD_PAL29_G04_0_Pos                                   5
#define LCD_PAL29_G04_0_Msk                                   (0x1fUL << LCD_PAL29_G04_0_Pos)
#define LCD_PAL29_B04_0_Pos                                   10
#define LCD_PAL29_B04_0_Msk                                   (0x1fUL << LCD_PAL29_B04_0_Pos)
#define LCD_PAL29_I0_Pos                                      15
#define LCD_PAL29_I0_Msk                                      (0x01UL << LCD_PAL29_I0_Pos)
#define LCD_PAL29_R14_0_Pos                                   16
#define LCD_PAL29_R14_0_Msk                                   (0x1fUL << LCD_PAL29_R14_0_Pos)
#define LCD_PAL29_G14_0_Pos                                   21
#define LCD_PAL29_G14_0_Msk                                   (0x1fUL << LCD_PAL29_G14_0_Pos)
#define LCD_PAL29_B14_0_Pos                                   26
#define LCD_PAL29_B14_0_Msk                                   (0x1fUL << LCD_PAL29_B14_0_Pos)
#define LCD_PAL29_I1_Pos                                      31
#define LCD_PAL29_I1_Msk                                      (0x01UL << LCD_PAL29_I1_Pos)

// ----------------------------------------  LCD_PAL30  -------------------------------------------
#define LCD_PAL30_R04_0_Pos                                   0
#define LCD_PAL30_R04_0_Msk                                   (0x1fUL << LCD_PAL30_R04_0_Pos)
#define LCD_PAL30_G04_0_Pos                                   5
#define LCD_PAL30_G04_0_Msk                                   (0x1fUL << LCD_PAL30_G04_0_Pos)
#define LCD_PAL30_B04_0_Pos                                   10
#define LCD_PAL30_B04_0_Msk                                   (0x1fUL << LCD_PAL30_B04_0_Pos)
#define LCD_PAL30_I0_Pos                                      15
#define LCD_PAL30_I0_Msk                                      (0x01UL << LCD_PAL30_I0_Pos)
#define LCD_PAL30_R14_0_Pos                                   16
#define LCD_PAL30_R14_0_Msk                                   (0x1fUL << LCD_PAL30_R14_0_Pos)
#define LCD_PAL30_G14_0_Pos                                   21
#define LCD_PAL30_G14_0_Msk                                   (0x1fUL << LCD_PAL30_G14_0_Pos)
#define LCD_PAL30_B14_0_Pos                                   26
#define LCD_PAL30_B14_0_Msk                                   (0x1fUL << LCD_PAL30_B14_0_Pos)
#define LCD_PAL30_I1_Pos                                      31
#define LCD_PAL30_I1_Msk                                      (0x01UL << LCD_PAL30_I1_Pos)

// ----------------------------------------  LCD_PAL31  -------------------------------------------
#define LCD_PAL31_R04_0_Pos                                   0
#define LCD_PAL31_R04_0_Msk                                   (0x1fUL << LCD_PAL31_R04_0_Pos)
#define LCD_PAL31_G04_0_Pos                                   5
#define LCD_PAL31_G04_0_Msk                                   (0x1fUL << LCD_PAL31_G04_0_Pos)
#define LCD_PAL31_B04_0_Pos                                   10
#define LCD_PAL31_B04_0_Msk                                   (0x1fUL << LCD_PAL31_B04_0_Pos)
#define LCD_PAL31_I0_Pos                                      15
#define LCD_PAL31_I0_Msk                                      (0x01UL << LCD_PAL31_I0_Pos)
#define LCD_PAL31_R14_0_Pos                                   16
#define LCD_PAL31_R14_0_Msk                                   (0x1fUL << LCD_PAL31_R14_0_Pos)
#define LCD_PAL31_G14_0_Pos                                   21
#define LCD_PAL31_G14_0_Msk                                   (0x1fUL << LCD_PAL31_G14_0_Pos)
#define LCD_PAL31_B14_0_Pos                                   26
#define LCD_PAL31_B14_0_Msk                                   (0x1fUL << LCD_PAL31_B14_0_Pos)
#define LCD_PAL31_I1_Pos                                      31
#define LCD_PAL31_I1_Msk                                      (0x01UL << LCD_PAL31_I1_Pos)

// ----------------------------------------  LCD_PAL32  -------------------------------------------
#define LCD_PAL32_R04_0_Pos                                   0
#define LCD_PAL32_R04_0_Msk                                   (0x1fUL << LCD_PAL32_R04_0_Pos)
#define LCD_PAL32_G04_0_Pos                                   5
#define LCD_PAL32_G04_0_Msk                                   (0x1fUL << LCD_PAL32_G04_0_Pos)
#define LCD_PAL32_B04_0_Pos                                   10
#define LCD_PAL32_B04_0_Msk                                   (0x1fUL << LCD_PAL32_B04_0_Pos)
#define LCD_PAL32_I0_Pos                                      15
#define LCD_PAL32_I0_Msk                                      (0x01UL << LCD_PAL32_I0_Pos)
#define LCD_PAL32_R14_0_Pos                                   16
#define LCD_PAL32_R14_0_Msk                                   (0x1fUL << LCD_PAL32_R14_0_Pos)
#define LCD_PAL32_G14_0_Pos                                   21
#define LCD_PAL32_G14_0_Msk                                   (0x1fUL << LCD_PAL32_G14_0_Pos)
#define LCD_PAL32_B14_0_Pos                                   26
#define LCD_PAL32_B14_0_Msk                                   (0x1fUL << LCD_PAL32_B14_0_Pos)
#define LCD_PAL32_I1_Pos                                      31
#define LCD_PAL32_I1_Msk                                      (0x01UL << LCD_PAL32_I1_Pos)

// ----------------------------------------  LCD_PAL33  -------------------------------------------
#define LCD_PAL33_R04_0_Pos                                   0
#define LCD_PAL33_R04_0_Msk                                   (0x1fUL << LCD_PAL33_R04_0_Pos)
#define LCD_PAL33_G04_0_Pos                                   5
#define LCD_PAL33_G04_0_Msk                                   (0x1fUL << LCD_PAL33_G04_0_Pos)
#define LCD_PAL33_B04_0_Pos                                   10
#define LCD_PAL33_B04_0_Msk                                   (0x1fUL << LCD_PAL33_B04_0_Pos)
#define LCD_PAL33_I0_Pos                                      15
#define LCD_PAL33_I0_Msk                                      (0x01UL << LCD_PAL33_I0_Pos)
#define LCD_PAL33_R14_0_Pos                                   16
#define LCD_PAL33_R14_0_Msk                                   (0x1fUL << LCD_PAL33_R14_0_Pos)
#define LCD_PAL33_G14_0_Pos                                   21
#define LCD_PAL33_G14_0_Msk                                   (0x1fUL << LCD_PAL33_G14_0_Pos)
#define LCD_PAL33_B14_0_Pos                                   26
#define LCD_PAL33_B14_0_Msk                                   (0x1fUL << LCD_PAL33_B14_0_Pos)
#define LCD_PAL33_I1_Pos                                      31
#define LCD_PAL33_I1_Msk                                      (0x01UL << LCD_PAL33_I1_Pos)

// ----------------------------------------  LCD_PAL34  -------------------------------------------
#define LCD_PAL34_R04_0_Pos                                   0
#define LCD_PAL34_R04_0_Msk                                   (0x1fUL << LCD_PAL34_R04_0_Pos)
#define LCD_PAL34_G04_0_Pos                                   5
#define LCD_PAL34_G04_0_Msk                                   (0x1fUL << LCD_PAL34_G04_0_Pos)
#define LCD_PAL34_B04_0_Pos                                   10
#define LCD_PAL34_B04_0_Msk                                   (0x1fUL << LCD_PAL34_B04_0_Pos)
#define LCD_PAL34_I0_Pos                                      15
#define LCD_PAL34_I0_Msk                                      (0x01UL << LCD_PAL34_I0_Pos)
#define LCD_PAL34_R14_0_Pos                                   16
#define LCD_PAL34_R14_0_Msk                                   (0x1fUL << LCD_PAL34_R14_0_Pos)
#define LCD_PAL34_G14_0_Pos                                   21
#define LCD_PAL34_G14_0_Msk                                   (0x1fUL << LCD_PAL34_G14_0_Pos)
#define LCD_PAL34_B14_0_Pos                                   26
#define LCD_PAL34_B14_0_Msk                                   (0x1fUL << LCD_PAL34_B14_0_Pos)
#define LCD_PAL34_I1_Pos                                      31
#define LCD_PAL34_I1_Msk                                      (0x01UL << LCD_PAL34_I1_Pos)

// ----------------------------------------  LCD_PAL35  -------------------------------------------
#define LCD_PAL35_R04_0_Pos                                   0
#define LCD_PAL35_R04_0_Msk                                   (0x1fUL << LCD_PAL35_R04_0_Pos)
#define LCD_PAL35_G04_0_Pos                                   5
#define LCD_PAL35_G04_0_Msk                                   (0x1fUL << LCD_PAL35_G04_0_Pos)
#define LCD_PAL35_B04_0_Pos                                   10
#define LCD_PAL35_B04_0_Msk                                   (0x1fUL << LCD_PAL35_B04_0_Pos)
#define LCD_PAL35_I0_Pos                                      15
#define LCD_PAL35_I0_Msk                                      (0x01UL << LCD_PAL35_I0_Pos)
#define LCD_PAL35_R14_0_Pos                                   16
#define LCD_PAL35_R14_0_Msk                                   (0x1fUL << LCD_PAL35_R14_0_Pos)
#define LCD_PAL35_G14_0_Pos                                   21
#define LCD_PAL35_G14_0_Msk                                   (0x1fUL << LCD_PAL35_G14_0_Pos)
#define LCD_PAL35_B14_0_Pos                                   26
#define LCD_PAL35_B14_0_Msk                                   (0x1fUL << LCD_PAL35_B14_0_Pos)
#define LCD_PAL35_I1_Pos                                      31
#define LCD_PAL35_I1_Msk                                      (0x01UL << LCD_PAL35_I1_Pos)

// ----------------------------------------  LCD_PAL36  -------------------------------------------
#define LCD_PAL36_R04_0_Pos                                   0
#define LCD_PAL36_R04_0_Msk                                   (0x1fUL << LCD_PAL36_R04_0_Pos)
#define LCD_PAL36_G04_0_Pos                                   5
#define LCD_PAL36_G04_0_Msk                                   (0x1fUL << LCD_PAL36_G04_0_Pos)
#define LCD_PAL36_B04_0_Pos                                   10
#define LCD_PAL36_B04_0_Msk                                   (0x1fUL << LCD_PAL36_B04_0_Pos)
#define LCD_PAL36_I0_Pos                                      15
#define LCD_PAL36_I0_Msk                                      (0x01UL << LCD_PAL36_I0_Pos)
#define LCD_PAL36_R14_0_Pos                                   16
#define LCD_PAL36_R14_0_Msk                                   (0x1fUL << LCD_PAL36_R14_0_Pos)
#define LCD_PAL36_G14_0_Pos                                   21
#define LCD_PAL36_G14_0_Msk                                   (0x1fUL << LCD_PAL36_G14_0_Pos)
#define LCD_PAL36_B14_0_Pos                                   26
#define LCD_PAL36_B14_0_Msk                                   (0x1fUL << LCD_PAL36_B14_0_Pos)
#define LCD_PAL36_I1_Pos                                      31
#define LCD_PAL36_I1_Msk                                      (0x01UL << LCD_PAL36_I1_Pos)

// ----------------------------------------  LCD_PAL37  -------------------------------------------
#define LCD_PAL37_R04_0_Pos                                   0
#define LCD_PAL37_R04_0_Msk                                   (0x1fUL << LCD_PAL37_R04_0_Pos)
#define LCD_PAL37_G04_0_Pos                                   5
#define LCD_PAL37_G04_0_Msk                                   (0x1fUL << LCD_PAL37_G04_0_Pos)
#define LCD_PAL37_B04_0_Pos                                   10
#define LCD_PAL37_B04_0_Msk                                   (0x1fUL << LCD_PAL37_B04_0_Pos)
#define LCD_PAL37_I0_Pos                                      15
#define LCD_PAL37_I0_Msk                                      (0x01UL << LCD_PAL37_I0_Pos)
#define LCD_PAL37_R14_0_Pos                                   16
#define LCD_PAL37_R14_0_Msk                                   (0x1fUL << LCD_PAL37_R14_0_Pos)
#define LCD_PAL37_G14_0_Pos                                   21
#define LCD_PAL37_G14_0_Msk                                   (0x1fUL << LCD_PAL37_G14_0_Pos)
#define LCD_PAL37_B14_0_Pos                                   26
#define LCD_PAL37_B14_0_Msk                                   (0x1fUL << LCD_PAL37_B14_0_Pos)
#define LCD_PAL37_I1_Pos                                      31
#define LCD_PAL37_I1_Msk                                      (0x01UL << LCD_PAL37_I1_Pos)

// ----------------------------------------  LCD_PAL38  -------------------------------------------
#define LCD_PAL38_R04_0_Pos                                   0
#define LCD_PAL38_R04_0_Msk                                   (0x1fUL << LCD_PAL38_R04_0_Pos)
#define LCD_PAL38_G04_0_Pos                                   5
#define LCD_PAL38_G04_0_Msk                                   (0x1fUL << LCD_PAL38_G04_0_Pos)
#define LCD_PAL38_B04_0_Pos                                   10
#define LCD_PAL38_B04_0_Msk                                   (0x1fUL << LCD_PAL38_B04_0_Pos)
#define LCD_PAL38_I0_Pos                                      15
#define LCD_PAL38_I0_Msk                                      (0x01UL << LCD_PAL38_I0_Pos)
#define LCD_PAL38_R14_0_Pos                                   16
#define LCD_PAL38_R14_0_Msk                                   (0x1fUL << LCD_PAL38_R14_0_Pos)
#define LCD_PAL38_G14_0_Pos                                   21
#define LCD_PAL38_G14_0_Msk                                   (0x1fUL << LCD_PAL38_G14_0_Pos)
#define LCD_PAL38_B14_0_Pos                                   26
#define LCD_PAL38_B14_0_Msk                                   (0x1fUL << LCD_PAL38_B14_0_Pos)
#define LCD_PAL38_I1_Pos                                      31
#define LCD_PAL38_I1_Msk                                      (0x01UL << LCD_PAL38_I1_Pos)

// ----------------------------------------  LCD_PAL39  -------------------------------------------
#define LCD_PAL39_R04_0_Pos                                   0
#define LCD_PAL39_R04_0_Msk                                   (0x1fUL << LCD_PAL39_R04_0_Pos)
#define LCD_PAL39_G04_0_Pos                                   5
#define LCD_PAL39_G04_0_Msk                                   (0x1fUL << LCD_PAL39_G04_0_Pos)
#define LCD_PAL39_B04_0_Pos                                   10
#define LCD_PAL39_B04_0_Msk                                   (0x1fUL << LCD_PAL39_B04_0_Pos)
#define LCD_PAL39_I0_Pos                                      15
#define LCD_PAL39_I0_Msk                                      (0x01UL << LCD_PAL39_I0_Pos)
#define LCD_PAL39_R14_0_Pos                                   16
#define LCD_PAL39_R14_0_Msk                                   (0x1fUL << LCD_PAL39_R14_0_Pos)
#define LCD_PAL39_G14_0_Pos                                   21
#define LCD_PAL39_G14_0_Msk                                   (0x1fUL << LCD_PAL39_G14_0_Pos)
#define LCD_PAL39_B14_0_Pos                                   26
#define LCD_PAL39_B14_0_Msk                                   (0x1fUL << LCD_PAL39_B14_0_Pos)
#define LCD_PAL39_I1_Pos                                      31
#define LCD_PAL39_I1_Msk                                      (0x01UL << LCD_PAL39_I1_Pos)

// ----------------------------------------  LCD_PAL40  -------------------------------------------
#define LCD_PAL40_R04_0_Pos                                   0
#define LCD_PAL40_R04_0_Msk                                   (0x1fUL << LCD_PAL40_R04_0_Pos)
#define LCD_PAL40_G04_0_Pos                                   5
#define LCD_PAL40_G04_0_Msk                                   (0x1fUL << LCD_PAL40_G04_0_Pos)
#define LCD_PAL40_B04_0_Pos                                   10
#define LCD_PAL40_B04_0_Msk                                   (0x1fUL << LCD_PAL40_B04_0_Pos)
#define LCD_PAL40_I0_Pos                                      15
#define LCD_PAL40_I0_Msk                                      (0x01UL << LCD_PAL40_I0_Pos)
#define LCD_PAL40_R14_0_Pos                                   16
#define LCD_PAL40_R14_0_Msk                                   (0x1fUL << LCD_PAL40_R14_0_Pos)
#define LCD_PAL40_G14_0_Pos                                   21
#define LCD_PAL40_G14_0_Msk                                   (0x1fUL << LCD_PAL40_G14_0_Pos)
#define LCD_PAL40_B14_0_Pos                                   26
#define LCD_PAL40_B14_0_Msk                                   (0x1fUL << LCD_PAL40_B14_0_Pos)
#define LCD_PAL40_I1_Pos                                      31
#define LCD_PAL40_I1_Msk                                      (0x01UL << LCD_PAL40_I1_Pos)

// ----------------------------------------  LCD_PAL41  -------------------------------------------
#define LCD_PAL41_R04_0_Pos                                   0
#define LCD_PAL41_R04_0_Msk                                   (0x1fUL << LCD_PAL41_R04_0_Pos)
#define LCD_PAL41_G04_0_Pos                                   5
#define LCD_PAL41_G04_0_Msk                                   (0x1fUL << LCD_PAL41_G04_0_Pos)
#define LCD_PAL41_B04_0_Pos                                   10
#define LCD_PAL41_B04_0_Msk                                   (0x1fUL << LCD_PAL41_B04_0_Pos)
#define LCD_PAL41_I0_Pos                                      15
#define LCD_PAL41_I0_Msk                                      (0x01UL << LCD_PAL41_I0_Pos)
#define LCD_PAL41_R14_0_Pos                                   16
#define LCD_PAL41_R14_0_Msk                                   (0x1fUL << LCD_PAL41_R14_0_Pos)
#define LCD_PAL41_G14_0_Pos                                   21
#define LCD_PAL41_G14_0_Msk                                   (0x1fUL << LCD_PAL41_G14_0_Pos)
#define LCD_PAL41_B14_0_Pos                                   26
#define LCD_PAL41_B14_0_Msk                                   (0x1fUL << LCD_PAL41_B14_0_Pos)
#define LCD_PAL41_I1_Pos                                      31
#define LCD_PAL41_I1_Msk                                      (0x01UL << LCD_PAL41_I1_Pos)

// ----------------------------------------  LCD_PAL42  -------------------------------------------
#define LCD_PAL42_R04_0_Pos                                   0
#define LCD_PAL42_R04_0_Msk                                   (0x1fUL << LCD_PAL42_R04_0_Pos)
#define LCD_PAL42_G04_0_Pos                                   5
#define LCD_PAL42_G04_0_Msk                                   (0x1fUL << LCD_PAL42_G04_0_Pos)
#define LCD_PAL42_B04_0_Pos                                   10
#define LCD_PAL42_B04_0_Msk                                   (0x1fUL << LCD_PAL42_B04_0_Pos)
#define LCD_PAL42_I0_Pos                                      15
#define LCD_PAL42_I0_Msk                                      (0x01UL << LCD_PAL42_I0_Pos)
#define LCD_PAL42_R14_0_Pos                                   16
#define LCD_PAL42_R14_0_Msk                                   (0x1fUL << LCD_PAL42_R14_0_Pos)
#define LCD_PAL42_G14_0_Pos                                   21
#define LCD_PAL42_G14_0_Msk                                   (0x1fUL << LCD_PAL42_G14_0_Pos)
#define LCD_PAL42_B14_0_Pos                                   26
#define LCD_PAL42_B14_0_Msk                                   (0x1fUL << LCD_PAL42_B14_0_Pos)
#define LCD_PAL42_I1_Pos                                      31
#define LCD_PAL42_I1_Msk                                      (0x01UL << LCD_PAL42_I1_Pos)

// ----------------------------------------  LCD_PAL43  -------------------------------------------
#define LCD_PAL43_R04_0_Pos                                   0
#define LCD_PAL43_R04_0_Msk                                   (0x1fUL << LCD_PAL43_R04_0_Pos)
#define LCD_PAL43_G04_0_Pos                                   5
#define LCD_PAL43_G04_0_Msk                                   (0x1fUL << LCD_PAL43_G04_0_Pos)
#define LCD_PAL43_B04_0_Pos                                   10
#define LCD_PAL43_B04_0_Msk                                   (0x1fUL << LCD_PAL43_B04_0_Pos)
#define LCD_PAL43_I0_Pos                                      15
#define LCD_PAL43_I0_Msk                                      (0x01UL << LCD_PAL43_I0_Pos)
#define LCD_PAL43_R14_0_Pos                                   16
#define LCD_PAL43_R14_0_Msk                                   (0x1fUL << LCD_PAL43_R14_0_Pos)
#define LCD_PAL43_G14_0_Pos                                   21
#define LCD_PAL43_G14_0_Msk                                   (0x1fUL << LCD_PAL43_G14_0_Pos)
#define LCD_PAL43_B14_0_Pos                                   26
#define LCD_PAL43_B14_0_Msk                                   (0x1fUL << LCD_PAL43_B14_0_Pos)
#define LCD_PAL43_I1_Pos                                      31
#define LCD_PAL43_I1_Msk                                      (0x01UL << LCD_PAL43_I1_Pos)

// ----------------------------------------  LCD_PAL44  -------------------------------------------
#define LCD_PAL44_R04_0_Pos                                   0
#define LCD_PAL44_R04_0_Msk                                   (0x1fUL << LCD_PAL44_R04_0_Pos)
#define LCD_PAL44_G04_0_Pos                                   5
#define LCD_PAL44_G04_0_Msk                                   (0x1fUL << LCD_PAL44_G04_0_Pos)
#define LCD_PAL44_B04_0_Pos                                   10
#define LCD_PAL44_B04_0_Msk                                   (0x1fUL << LCD_PAL44_B04_0_Pos)
#define LCD_PAL44_I0_Pos                                      15
#define LCD_PAL44_I0_Msk                                      (0x01UL << LCD_PAL44_I0_Pos)
#define LCD_PAL44_R14_0_Pos                                   16
#define LCD_PAL44_R14_0_Msk                                   (0x1fUL << LCD_PAL44_R14_0_Pos)
#define LCD_PAL44_G14_0_Pos                                   21
#define LCD_PAL44_G14_0_Msk                                   (0x1fUL << LCD_PAL44_G14_0_Pos)
#define LCD_PAL44_B14_0_Pos                                   26
#define LCD_PAL44_B14_0_Msk                                   (0x1fUL << LCD_PAL44_B14_0_Pos)
#define LCD_PAL44_I1_Pos                                      31
#define LCD_PAL44_I1_Msk                                      (0x01UL << LCD_PAL44_I1_Pos)

// ----------------------------------------  LCD_PAL45  -------------------------------------------
#define LCD_PAL45_R04_0_Pos                                   0
#define LCD_PAL45_R04_0_Msk                                   (0x1fUL << LCD_PAL45_R04_0_Pos)
#define LCD_PAL45_G04_0_Pos                                   5
#define LCD_PAL45_G04_0_Msk                                   (0x1fUL << LCD_PAL45_G04_0_Pos)
#define LCD_PAL45_B04_0_Pos                                   10
#define LCD_PAL45_B04_0_Msk                                   (0x1fUL << LCD_PAL45_B04_0_Pos)
#define LCD_PAL45_I0_Pos                                      15
#define LCD_PAL45_I0_Msk                                      (0x01UL << LCD_PAL45_I0_Pos)
#define LCD_PAL45_R14_0_Pos                                   16
#define LCD_PAL45_R14_0_Msk                                   (0x1fUL << LCD_PAL45_R14_0_Pos)
#define LCD_PAL45_G14_0_Pos                                   21
#define LCD_PAL45_G14_0_Msk                                   (0x1fUL << LCD_PAL45_G14_0_Pos)
#define LCD_PAL45_B14_0_Pos                                   26
#define LCD_PAL45_B14_0_Msk                                   (0x1fUL << LCD_PAL45_B14_0_Pos)
#define LCD_PAL45_I1_Pos                                      31
#define LCD_PAL45_I1_Msk                                      (0x01UL << LCD_PAL45_I1_Pos)

// ----------------------------------------  LCD_PAL46  -------------------------------------------
#define LCD_PAL46_R04_0_Pos                                   0
#define LCD_PAL46_R04_0_Msk                                   (0x1fUL << LCD_PAL46_R04_0_Pos)
#define LCD_PAL46_G04_0_Pos                                   5
#define LCD_PAL46_G04_0_Msk                                   (0x1fUL << LCD_PAL46_G04_0_Pos)
#define LCD_PAL46_B04_0_Pos                                   10
#define LCD_PAL46_B04_0_Msk                                   (0x1fUL << LCD_PAL46_B04_0_Pos)
#define LCD_PAL46_I0_Pos                                      15
#define LCD_PAL46_I0_Msk                                      (0x01UL << LCD_PAL46_I0_Pos)
#define LCD_PAL46_R14_0_Pos                                   16
#define LCD_PAL46_R14_0_Msk                                   (0x1fUL << LCD_PAL46_R14_0_Pos)
#define LCD_PAL46_G14_0_Pos                                   21
#define LCD_PAL46_G14_0_Msk                                   (0x1fUL << LCD_PAL46_G14_0_Pos)
#define LCD_PAL46_B14_0_Pos                                   26
#define LCD_PAL46_B14_0_Msk                                   (0x1fUL << LCD_PAL46_B14_0_Pos)
#define LCD_PAL46_I1_Pos                                      31
#define LCD_PAL46_I1_Msk                                      (0x01UL << LCD_PAL46_I1_Pos)

// ----------------------------------------  LCD_PAL47  -------------------------------------------
#define LCD_PAL47_R04_0_Pos                                   0
#define LCD_PAL47_R04_0_Msk                                   (0x1fUL << LCD_PAL47_R04_0_Pos)
#define LCD_PAL47_G04_0_Pos                                   5
#define LCD_PAL47_G04_0_Msk                                   (0x1fUL << LCD_PAL47_G04_0_Pos)
#define LCD_PAL47_B04_0_Pos                                   10
#define LCD_PAL47_B04_0_Msk                                   (0x1fUL << LCD_PAL47_B04_0_Pos)
#define LCD_PAL47_I0_Pos                                      15
#define LCD_PAL47_I0_Msk                                      (0x01UL << LCD_PAL47_I0_Pos)
#define LCD_PAL47_R14_0_Pos                                   16
#define LCD_PAL47_R14_0_Msk                                   (0x1fUL << LCD_PAL47_R14_0_Pos)
#define LCD_PAL47_G14_0_Pos                                   21
#define LCD_PAL47_G14_0_Msk                                   (0x1fUL << LCD_PAL47_G14_0_Pos)
#define LCD_PAL47_B14_0_Pos                                   26
#define LCD_PAL47_B14_0_Msk                                   (0x1fUL << LCD_PAL47_B14_0_Pos)
#define LCD_PAL47_I1_Pos                                      31
#define LCD_PAL47_I1_Msk                                      (0x01UL << LCD_PAL47_I1_Pos)

// ----------------------------------------  LCD_PAL48  -------------------------------------------
#define LCD_PAL48_R04_0_Pos                                   0
#define LCD_PAL48_R04_0_Msk                                   (0x1fUL << LCD_PAL48_R04_0_Pos)
#define LCD_PAL48_G04_0_Pos                                   5
#define LCD_PAL48_G04_0_Msk                                   (0x1fUL << LCD_PAL48_G04_0_Pos)
#define LCD_PAL48_B04_0_Pos                                   10
#define LCD_PAL48_B04_0_Msk                                   (0x1fUL << LCD_PAL48_B04_0_Pos)
#define LCD_PAL48_I0_Pos                                      15
#define LCD_PAL48_I0_Msk                                      (0x01UL << LCD_PAL48_I0_Pos)
#define LCD_PAL48_R14_0_Pos                                   16
#define LCD_PAL48_R14_0_Msk                                   (0x1fUL << LCD_PAL48_R14_0_Pos)
#define LCD_PAL48_G14_0_Pos                                   21
#define LCD_PAL48_G14_0_Msk                                   (0x1fUL << LCD_PAL48_G14_0_Pos)
#define LCD_PAL48_B14_0_Pos                                   26
#define LCD_PAL48_B14_0_Msk                                   (0x1fUL << LCD_PAL48_B14_0_Pos)
#define LCD_PAL48_I1_Pos                                      31
#define LCD_PAL48_I1_Msk                                      (0x01UL << LCD_PAL48_I1_Pos)

// ----------------------------------------  LCD_PAL49  -------------------------------------------
#define LCD_PAL49_R04_0_Pos                                   0
#define LCD_PAL49_R04_0_Msk                                   (0x1fUL << LCD_PAL49_R04_0_Pos)
#define LCD_PAL49_G04_0_Pos                                   5
#define LCD_PAL49_G04_0_Msk                                   (0x1fUL << LCD_PAL49_G04_0_Pos)
#define LCD_PAL49_B04_0_Pos                                   10
#define LCD_PAL49_B04_0_Msk                                   (0x1fUL << LCD_PAL49_B04_0_Pos)
#define LCD_PAL49_I0_Pos                                      15
#define LCD_PAL49_I0_Msk                                      (0x01UL << LCD_PAL49_I0_Pos)
#define LCD_PAL49_R14_0_Pos                                   16
#define LCD_PAL49_R14_0_Msk                                   (0x1fUL << LCD_PAL49_R14_0_Pos)
#define LCD_PAL49_G14_0_Pos                                   21
#define LCD_PAL49_G14_0_Msk                                   (0x1fUL << LCD_PAL49_G14_0_Pos)
#define LCD_PAL49_B14_0_Pos                                   26
#define LCD_PAL49_B14_0_Msk                                   (0x1fUL << LCD_PAL49_B14_0_Pos)
#define LCD_PAL49_I1_Pos                                      31
#define LCD_PAL49_I1_Msk                                      (0x01UL << LCD_PAL49_I1_Pos)

// ----------------------------------------  LCD_PAL50  -------------------------------------------
#define LCD_PAL50_R04_0_Pos                                   0
#define LCD_PAL50_R04_0_Msk                                   (0x1fUL << LCD_PAL50_R04_0_Pos)
#define LCD_PAL50_G04_0_Pos                                   5
#define LCD_PAL50_G04_0_Msk                                   (0x1fUL << LCD_PAL50_G04_0_Pos)
#define LCD_PAL50_B04_0_Pos                                   10
#define LCD_PAL50_B04_0_Msk                                   (0x1fUL << LCD_PAL50_B04_0_Pos)
#define LCD_PAL50_I0_Pos                                      15
#define LCD_PAL50_I0_Msk                                      (0x01UL << LCD_PAL50_I0_Pos)
#define LCD_PAL50_R14_0_Pos                                   16
#define LCD_PAL50_R14_0_Msk                                   (0x1fUL << LCD_PAL50_R14_0_Pos)
#define LCD_PAL50_G14_0_Pos                                   21
#define LCD_PAL50_G14_0_Msk                                   (0x1fUL << LCD_PAL50_G14_0_Pos)
#define LCD_PAL50_B14_0_Pos                                   26
#define LCD_PAL50_B14_0_Msk                                   (0x1fUL << LCD_PAL50_B14_0_Pos)
#define LCD_PAL50_I1_Pos                                      31
#define LCD_PAL50_I1_Msk                                      (0x01UL << LCD_PAL50_I1_Pos)

// ----------------------------------------  LCD_PAL51  -------------------------------------------
#define LCD_PAL51_R04_0_Pos                                   0
#define LCD_PAL51_R04_0_Msk                                   (0x1fUL << LCD_PAL51_R04_0_Pos)
#define LCD_PAL51_G04_0_Pos                                   5
#define LCD_PAL51_G04_0_Msk                                   (0x1fUL << LCD_PAL51_G04_0_Pos)
#define LCD_PAL51_B04_0_Pos                                   10
#define LCD_PAL51_B04_0_Msk                                   (0x1fUL << LCD_PAL51_B04_0_Pos)
#define LCD_PAL51_I0_Pos                                      15
#define LCD_PAL51_I0_Msk                                      (0x01UL << LCD_PAL51_I0_Pos)
#define LCD_PAL51_R14_0_Pos                                   16
#define LCD_PAL51_R14_0_Msk                                   (0x1fUL << LCD_PAL51_R14_0_Pos)
#define LCD_PAL51_G14_0_Pos                                   21
#define LCD_PAL51_G14_0_Msk                                   (0x1fUL << LCD_PAL51_G14_0_Pos)
#define LCD_PAL51_B14_0_Pos                                   26
#define LCD_PAL51_B14_0_Msk                                   (0x1fUL << LCD_PAL51_B14_0_Pos)
#define LCD_PAL51_I1_Pos                                      31
#define LCD_PAL51_I1_Msk                                      (0x01UL << LCD_PAL51_I1_Pos)

// ----------------------------------------  LCD_PAL52  -------------------------------------------
#define LCD_PAL52_R04_0_Pos                                   0
#define LCD_PAL52_R04_0_Msk                                   (0x1fUL << LCD_PAL52_R04_0_Pos)
#define LCD_PAL52_G04_0_Pos                                   5
#define LCD_PAL52_G04_0_Msk                                   (0x1fUL << LCD_PAL52_G04_0_Pos)
#define LCD_PAL52_B04_0_Pos                                   10
#define LCD_PAL52_B04_0_Msk                                   (0x1fUL << LCD_PAL52_B04_0_Pos)
#define LCD_PAL52_I0_Pos                                      15
#define LCD_PAL52_I0_Msk                                      (0x01UL << LCD_PAL52_I0_Pos)
#define LCD_PAL52_R14_0_Pos                                   16
#define LCD_PAL52_R14_0_Msk                                   (0x1fUL << LCD_PAL52_R14_0_Pos)
#define LCD_PAL52_G14_0_Pos                                   21
#define LCD_PAL52_G14_0_Msk                                   (0x1fUL << LCD_PAL52_G14_0_Pos)
#define LCD_PAL52_B14_0_Pos                                   26
#define LCD_PAL52_B14_0_Msk                                   (0x1fUL << LCD_PAL52_B14_0_Pos)
#define LCD_PAL52_I1_Pos                                      31
#define LCD_PAL52_I1_Msk                                      (0x01UL << LCD_PAL52_I1_Pos)

// ----------------------------------------  LCD_PAL53  -------------------------------------------
#define LCD_PAL53_R04_0_Pos                                   0
#define LCD_PAL53_R04_0_Msk                                   (0x1fUL << LCD_PAL53_R04_0_Pos)
#define LCD_PAL53_G04_0_Pos                                   5
#define LCD_PAL53_G04_0_Msk                                   (0x1fUL << LCD_PAL53_G04_0_Pos)
#define LCD_PAL53_B04_0_Pos                                   10
#define LCD_PAL53_B04_0_Msk                                   (0x1fUL << LCD_PAL53_B04_0_Pos)
#define LCD_PAL53_I0_Pos                                      15
#define LCD_PAL53_I0_Msk                                      (0x01UL << LCD_PAL53_I0_Pos)
#define LCD_PAL53_R14_0_Pos                                   16
#define LCD_PAL53_R14_0_Msk                                   (0x1fUL << LCD_PAL53_R14_0_Pos)
#define LCD_PAL53_G14_0_Pos                                   21
#define LCD_PAL53_G14_0_Msk                                   (0x1fUL << LCD_PAL53_G14_0_Pos)
#define LCD_PAL53_B14_0_Pos                                   26
#define LCD_PAL53_B14_0_Msk                                   (0x1fUL << LCD_PAL53_B14_0_Pos)
#define LCD_PAL53_I1_Pos                                      31
#define LCD_PAL53_I1_Msk                                      (0x01UL << LCD_PAL53_I1_Pos)

// ----------------------------------------  LCD_PAL54  -------------------------------------------
#define LCD_PAL54_R04_0_Pos                                   0
#define LCD_PAL54_R04_0_Msk                                   (0x1fUL << LCD_PAL54_R04_0_Pos)
#define LCD_PAL54_G04_0_Pos                                   5
#define LCD_PAL54_G04_0_Msk                                   (0x1fUL << LCD_PAL54_G04_0_Pos)
#define LCD_PAL54_B04_0_Pos                                   10
#define LCD_PAL54_B04_0_Msk                                   (0x1fUL << LCD_PAL54_B04_0_Pos)
#define LCD_PAL54_I0_Pos                                      15
#define LCD_PAL54_I0_Msk                                      (0x01UL << LCD_PAL54_I0_Pos)
#define LCD_PAL54_R14_0_Pos                                   16
#define LCD_PAL54_R14_0_Msk                                   (0x1fUL << LCD_PAL54_R14_0_Pos)
#define LCD_PAL54_G14_0_Pos                                   21
#define LCD_PAL54_G14_0_Msk                                   (0x1fUL << LCD_PAL54_G14_0_Pos)
#define LCD_PAL54_B14_0_Pos                                   26
#define LCD_PAL54_B14_0_Msk                                   (0x1fUL << LCD_PAL54_B14_0_Pos)
#define LCD_PAL54_I1_Pos                                      31
#define LCD_PAL54_I1_Msk                                      (0x01UL << LCD_PAL54_I1_Pos)

// ----------------------------------------  LCD_PAL55  -------------------------------------------
#define LCD_PAL55_R04_0_Pos                                   0
#define LCD_PAL55_R04_0_Msk                                   (0x1fUL << LCD_PAL55_R04_0_Pos)
#define LCD_PAL55_G04_0_Pos                                   5
#define LCD_PAL55_G04_0_Msk                                   (0x1fUL << LCD_PAL55_G04_0_Pos)
#define LCD_PAL55_B04_0_Pos                                   10
#define LCD_PAL55_B04_0_Msk                                   (0x1fUL << LCD_PAL55_B04_0_Pos)
#define LCD_PAL55_I0_Pos                                      15
#define LCD_PAL55_I0_Msk                                      (0x01UL << LCD_PAL55_I0_Pos)
#define LCD_PAL55_R14_0_Pos                                   16
#define LCD_PAL55_R14_0_Msk                                   (0x1fUL << LCD_PAL55_R14_0_Pos)
#define LCD_PAL55_G14_0_Pos                                   21
#define LCD_PAL55_G14_0_Msk                                   (0x1fUL << LCD_PAL55_G14_0_Pos)
#define LCD_PAL55_B14_0_Pos                                   26
#define LCD_PAL55_B14_0_Msk                                   (0x1fUL << LCD_PAL55_B14_0_Pos)
#define LCD_PAL55_I1_Pos                                      31
#define LCD_PAL55_I1_Msk                                      (0x01UL << LCD_PAL55_I1_Pos)

// ----------------------------------------  LCD_PAL56  -------------------------------------------
#define LCD_PAL56_R04_0_Pos                                   0
#define LCD_PAL56_R04_0_Msk                                   (0x1fUL << LCD_PAL56_R04_0_Pos)
#define LCD_PAL56_G04_0_Pos                                   5
#define LCD_PAL56_G04_0_Msk                                   (0x1fUL << LCD_PAL56_G04_0_Pos)
#define LCD_PAL56_B04_0_Pos                                   10
#define LCD_PAL56_B04_0_Msk                                   (0x1fUL << LCD_PAL56_B04_0_Pos)
#define LCD_PAL56_I0_Pos                                      15
#define LCD_PAL56_I0_Msk                                      (0x01UL << LCD_PAL56_I0_Pos)
#define LCD_PAL56_R14_0_Pos                                   16
#define LCD_PAL56_R14_0_Msk                                   (0x1fUL << LCD_PAL56_R14_0_Pos)
#define LCD_PAL56_G14_0_Pos                                   21
#define LCD_PAL56_G14_0_Msk                                   (0x1fUL << LCD_PAL56_G14_0_Pos)
#define LCD_PAL56_B14_0_Pos                                   26
#define LCD_PAL56_B14_0_Msk                                   (0x1fUL << LCD_PAL56_B14_0_Pos)
#define LCD_PAL56_I1_Pos                                      31
#define LCD_PAL56_I1_Msk                                      (0x01UL << LCD_PAL56_I1_Pos)

// ----------------------------------------  LCD_PAL57  -------------------------------------------
#define LCD_PAL57_R04_0_Pos                                   0
#define LCD_PAL57_R04_0_Msk                                   (0x1fUL << LCD_PAL57_R04_0_Pos)
#define LCD_PAL57_G04_0_Pos                                   5
#define LCD_PAL57_G04_0_Msk                                   (0x1fUL << LCD_PAL57_G04_0_Pos)
#define LCD_PAL57_B04_0_Pos                                   10
#define LCD_PAL57_B04_0_Msk                                   (0x1fUL << LCD_PAL57_B04_0_Pos)
#define LCD_PAL57_I0_Pos                                      15
#define LCD_PAL57_I0_Msk                                      (0x01UL << LCD_PAL57_I0_Pos)
#define LCD_PAL57_R14_0_Pos                                   16
#define LCD_PAL57_R14_0_Msk                                   (0x1fUL << LCD_PAL57_R14_0_Pos)
#define LCD_PAL57_G14_0_Pos                                   21
#define LCD_PAL57_G14_0_Msk                                   (0x1fUL << LCD_PAL57_G14_0_Pos)
#define LCD_PAL57_B14_0_Pos                                   26
#define LCD_PAL57_B14_0_Msk                                   (0x1fUL << LCD_PAL57_B14_0_Pos)
#define LCD_PAL57_I1_Pos                                      31
#define LCD_PAL57_I1_Msk                                      (0x01UL << LCD_PAL57_I1_Pos)

// ----------------------------------------  LCD_PAL58  -------------------------------------------
#define LCD_PAL58_R04_0_Pos                                   0
#define LCD_PAL58_R04_0_Msk                                   (0x1fUL << LCD_PAL58_R04_0_Pos)
#define LCD_PAL58_G04_0_Pos                                   5
#define LCD_PAL58_G04_0_Msk                                   (0x1fUL << LCD_PAL58_G04_0_Pos)
#define LCD_PAL58_B04_0_Pos                                   10
#define LCD_PAL58_B04_0_Msk                                   (0x1fUL << LCD_PAL58_B04_0_Pos)
#define LCD_PAL58_I0_Pos                                      15
#define LCD_PAL58_I0_Msk                                      (0x01UL << LCD_PAL58_I0_Pos)
#define LCD_PAL58_R14_0_Pos                                   16
#define LCD_PAL58_R14_0_Msk                                   (0x1fUL << LCD_PAL58_R14_0_Pos)
#define LCD_PAL58_G14_0_Pos                                   21
#define LCD_PAL58_G14_0_Msk                                   (0x1fUL << LCD_PAL58_G14_0_Pos)
#define LCD_PAL58_B14_0_Pos                                   26
#define LCD_PAL58_B14_0_Msk                                   (0x1fUL << LCD_PAL58_B14_0_Pos)
#define LCD_PAL58_I1_Pos                                      31
#define LCD_PAL58_I1_Msk                                      (0x01UL << LCD_PAL58_I1_Pos)

// ----------------------------------------  LCD_PAL59  -------------------------------------------
#define LCD_PAL59_R04_0_Pos                                   0
#define LCD_PAL59_R04_0_Msk                                   (0x1fUL << LCD_PAL59_R04_0_Pos)
#define LCD_PAL59_G04_0_Pos                                   5
#define LCD_PAL59_G04_0_Msk                                   (0x1fUL << LCD_PAL59_G04_0_Pos)
#define LCD_PAL59_B04_0_Pos                                   10
#define LCD_PAL59_B04_0_Msk                                   (0x1fUL << LCD_PAL59_B04_0_Pos)
#define LCD_PAL59_I0_Pos                                      15
#define LCD_PAL59_I0_Msk                                      (0x01UL << LCD_PAL59_I0_Pos)
#define LCD_PAL59_R14_0_Pos                                   16
#define LCD_PAL59_R14_0_Msk                                   (0x1fUL << LCD_PAL59_R14_0_Pos)
#define LCD_PAL59_G14_0_Pos                                   21
#define LCD_PAL59_G14_0_Msk                                   (0x1fUL << LCD_PAL59_G14_0_Pos)
#define LCD_PAL59_B14_0_Pos                                   26
#define LCD_PAL59_B14_0_Msk                                   (0x1fUL << LCD_PAL59_B14_0_Pos)
#define LCD_PAL59_I1_Pos                                      31
#define LCD_PAL59_I1_Msk                                      (0x01UL << LCD_PAL59_I1_Pos)

// ----------------------------------------  LCD_PAL60  -------------------------------------------
#define LCD_PAL60_R04_0_Pos                                   0
#define LCD_PAL60_R04_0_Msk                                   (0x1fUL << LCD_PAL60_R04_0_Pos)
#define LCD_PAL60_G04_0_Pos                                   5
#define LCD_PAL60_G04_0_Msk                                   (0x1fUL << LCD_PAL60_G04_0_Pos)
#define LCD_PAL60_B04_0_Pos                                   10
#define LCD_PAL60_B04_0_Msk                                   (0x1fUL << LCD_PAL60_B04_0_Pos)
#define LCD_PAL60_I0_Pos                                      15
#define LCD_PAL60_I0_Msk                                      (0x01UL << LCD_PAL60_I0_Pos)
#define LCD_PAL60_R14_0_Pos                                   16
#define LCD_PAL60_R14_0_Msk                                   (0x1fUL << LCD_PAL60_R14_0_Pos)
#define LCD_PAL60_G14_0_Pos                                   21
#define LCD_PAL60_G14_0_Msk                                   (0x1fUL << LCD_PAL60_G14_0_Pos)
#define LCD_PAL60_B14_0_Pos                                   26
#define LCD_PAL60_B14_0_Msk                                   (0x1fUL << LCD_PAL60_B14_0_Pos)
#define LCD_PAL60_I1_Pos                                      31
#define LCD_PAL60_I1_Msk                                      (0x01UL << LCD_PAL60_I1_Pos)

// ----------------------------------------  LCD_PAL61  -------------------------------------------
#define LCD_PAL61_R04_0_Pos                                   0
#define LCD_PAL61_R04_0_Msk                                   (0x1fUL << LCD_PAL61_R04_0_Pos)
#define LCD_PAL61_G04_0_Pos                                   5
#define LCD_PAL61_G04_0_Msk                                   (0x1fUL << LCD_PAL61_G04_0_Pos)
#define LCD_PAL61_B04_0_Pos                                   10
#define LCD_PAL61_B04_0_Msk                                   (0x1fUL << LCD_PAL61_B04_0_Pos)
#define LCD_PAL61_I0_Pos                                      15
#define LCD_PAL61_I0_Msk                                      (0x01UL << LCD_PAL61_I0_Pos)
#define LCD_PAL61_R14_0_Pos                                   16
#define LCD_PAL61_R14_0_Msk                                   (0x1fUL << LCD_PAL61_R14_0_Pos)
#define LCD_PAL61_G14_0_Pos                                   21
#define LCD_PAL61_G14_0_Msk                                   (0x1fUL << LCD_PAL61_G14_0_Pos)
#define LCD_PAL61_B14_0_Pos                                   26
#define LCD_PAL61_B14_0_Msk                                   (0x1fUL << LCD_PAL61_B14_0_Pos)
#define LCD_PAL61_I1_Pos                                      31
#define LCD_PAL61_I1_Msk                                      (0x01UL << LCD_PAL61_I1_Pos)

// ----------------------------------------  LCD_PAL62  -------------------------------------------
#define LCD_PAL62_R04_0_Pos                                   0
#define LCD_PAL62_R04_0_Msk                                   (0x1fUL << LCD_PAL62_R04_0_Pos)
#define LCD_PAL62_G04_0_Pos                                   5
#define LCD_PAL62_G04_0_Msk                                   (0x1fUL << LCD_PAL62_G04_0_Pos)
#define LCD_PAL62_B04_0_Pos                                   10
#define LCD_PAL62_B04_0_Msk                                   (0x1fUL << LCD_PAL62_B04_0_Pos)
#define LCD_PAL62_I0_Pos                                      15
#define LCD_PAL62_I0_Msk                                      (0x01UL << LCD_PAL62_I0_Pos)
#define LCD_PAL62_R14_0_Pos                                   16
#define LCD_PAL62_R14_0_Msk                                   (0x1fUL << LCD_PAL62_R14_0_Pos)
#define LCD_PAL62_G14_0_Pos                                   21
#define LCD_PAL62_G14_0_Msk                                   (0x1fUL << LCD_PAL62_G14_0_Pos)
#define LCD_PAL62_B14_0_Pos                                   26
#define LCD_PAL62_B14_0_Msk                                   (0x1fUL << LCD_PAL62_B14_0_Pos)
#define LCD_PAL62_I1_Pos                                      31
#define LCD_PAL62_I1_Msk                                      (0x01UL << LCD_PAL62_I1_Pos)

// ----------------------------------------  LCD_PAL63  -------------------------------------------
#define LCD_PAL63_R04_0_Pos                                   0
#define LCD_PAL63_R04_0_Msk                                   (0x1fUL << LCD_PAL63_R04_0_Pos)
#define LCD_PAL63_G04_0_Pos                                   5
#define LCD_PAL63_G04_0_Msk                                   (0x1fUL << LCD_PAL63_G04_0_Pos)
#define LCD_PAL63_B04_0_Pos                                   10
#define LCD_PAL63_B04_0_Msk                                   (0x1fUL << LCD_PAL63_B04_0_Pos)
#define LCD_PAL63_I0_Pos                                      15
#define LCD_PAL63_I0_Msk                                      (0x01UL << LCD_PAL63_I0_Pos)
#define LCD_PAL63_R14_0_Pos                                   16
#define LCD_PAL63_R14_0_Msk                                   (0x1fUL << LCD_PAL63_R14_0_Pos)
#define LCD_PAL63_G14_0_Pos                                   21
#define LCD_PAL63_G14_0_Msk                                   (0x1fUL << LCD_PAL63_G14_0_Pos)
#define LCD_PAL63_B14_0_Pos                                   26
#define LCD_PAL63_B14_0_Msk                                   (0x1fUL << LCD_PAL63_B14_0_Pos)
#define LCD_PAL63_I1_Pos                                      31
#define LCD_PAL63_I1_Msk                                      (0x01UL << LCD_PAL63_I1_Pos)

// ----------------------------------------  LCD_PAL64  -------------------------------------------
#define LCD_PAL64_R04_0_Pos                                   0
#define LCD_PAL64_R04_0_Msk                                   (0x1fUL << LCD_PAL64_R04_0_Pos)
#define LCD_PAL64_G04_0_Pos                                   5
#define LCD_PAL64_G04_0_Msk                                   (0x1fUL << LCD_PAL64_G04_0_Pos)
#define LCD_PAL64_B04_0_Pos                                   10
#define LCD_PAL64_B04_0_Msk                                   (0x1fUL << LCD_PAL64_B04_0_Pos)
#define LCD_PAL64_I0_Pos                                      15
#define LCD_PAL64_I0_Msk                                      (0x01UL << LCD_PAL64_I0_Pos)
#define LCD_PAL64_R14_0_Pos                                   16
#define LCD_PAL64_R14_0_Msk                                   (0x1fUL << LCD_PAL64_R14_0_Pos)
#define LCD_PAL64_G14_0_Pos                                   21
#define LCD_PAL64_G14_0_Msk                                   (0x1fUL << LCD_PAL64_G14_0_Pos)
#define LCD_PAL64_B14_0_Pos                                   26
#define LCD_PAL64_B14_0_Msk                                   (0x1fUL << LCD_PAL64_B14_0_Pos)
#define LCD_PAL64_I1_Pos                                      31
#define LCD_PAL64_I1_Msk                                      (0x01UL << LCD_PAL64_I1_Pos)

// ----------------------------------------  LCD_PAL65  -------------------------------------------
#define LCD_PAL65_R04_0_Pos                                   0
#define LCD_PAL65_R04_0_Msk                                   (0x1fUL << LCD_PAL65_R04_0_Pos)
#define LCD_PAL65_G04_0_Pos                                   5
#define LCD_PAL65_G04_0_Msk                                   (0x1fUL << LCD_PAL65_G04_0_Pos)
#define LCD_PAL65_B04_0_Pos                                   10
#define LCD_PAL65_B04_0_Msk                                   (0x1fUL << LCD_PAL65_B04_0_Pos)
#define LCD_PAL65_I0_Pos                                      15
#define LCD_PAL65_I0_Msk                                      (0x01UL << LCD_PAL65_I0_Pos)
#define LCD_PAL65_R14_0_Pos                                   16
#define LCD_PAL65_R14_0_Msk                                   (0x1fUL << LCD_PAL65_R14_0_Pos)
#define LCD_PAL65_G14_0_Pos                                   21
#define LCD_PAL65_G14_0_Msk                                   (0x1fUL << LCD_PAL65_G14_0_Pos)
#define LCD_PAL65_B14_0_Pos                                   26
#define LCD_PAL65_B14_0_Msk                                   (0x1fUL << LCD_PAL65_B14_0_Pos)
#define LCD_PAL65_I1_Pos                                      31
#define LCD_PAL65_I1_Msk                                      (0x01UL << LCD_PAL65_I1_Pos)

// ----------------------------------------  LCD_PAL66  -------------------------------------------
#define LCD_PAL66_R04_0_Pos                                   0
#define LCD_PAL66_R04_0_Msk                                   (0x1fUL << LCD_PAL66_R04_0_Pos)
#define LCD_PAL66_G04_0_Pos                                   5
#define LCD_PAL66_G04_0_Msk                                   (0x1fUL << LCD_PAL66_G04_0_Pos)
#define LCD_PAL66_B04_0_Pos                                   10
#define LCD_PAL66_B04_0_Msk                                   (0x1fUL << LCD_PAL66_B04_0_Pos)
#define LCD_PAL66_I0_Pos                                      15
#define LCD_PAL66_I0_Msk                                      (0x01UL << LCD_PAL66_I0_Pos)
#define LCD_PAL66_R14_0_Pos                                   16
#define LCD_PAL66_R14_0_Msk                                   (0x1fUL << LCD_PAL66_R14_0_Pos)
#define LCD_PAL66_G14_0_Pos                                   21
#define LCD_PAL66_G14_0_Msk                                   (0x1fUL << LCD_PAL66_G14_0_Pos)
#define LCD_PAL66_B14_0_Pos                                   26
#define LCD_PAL66_B14_0_Msk                                   (0x1fUL << LCD_PAL66_B14_0_Pos)
#define LCD_PAL66_I1_Pos                                      31
#define LCD_PAL66_I1_Msk                                      (0x01UL << LCD_PAL66_I1_Pos)

// ----------------------------------------  LCD_PAL67  -------------------------------------------
#define LCD_PAL67_R04_0_Pos                                   0
#define LCD_PAL67_R04_0_Msk                                   (0x1fUL << LCD_PAL67_R04_0_Pos)
#define LCD_PAL67_G04_0_Pos                                   5
#define LCD_PAL67_G04_0_Msk                                   (0x1fUL << LCD_PAL67_G04_0_Pos)
#define LCD_PAL67_B04_0_Pos                                   10
#define LCD_PAL67_B04_0_Msk                                   (0x1fUL << LCD_PAL67_B04_0_Pos)
#define LCD_PAL67_I0_Pos                                      15
#define LCD_PAL67_I0_Msk                                      (0x01UL << LCD_PAL67_I0_Pos)
#define LCD_PAL67_R14_0_Pos                                   16
#define LCD_PAL67_R14_0_Msk                                   (0x1fUL << LCD_PAL67_R14_0_Pos)
#define LCD_PAL67_G14_0_Pos                                   21
#define LCD_PAL67_G14_0_Msk                                   (0x1fUL << LCD_PAL67_G14_0_Pos)
#define LCD_PAL67_B14_0_Pos                                   26
#define LCD_PAL67_B14_0_Msk                                   (0x1fUL << LCD_PAL67_B14_0_Pos)
#define LCD_PAL67_I1_Pos                                      31
#define LCD_PAL67_I1_Msk                                      (0x01UL << LCD_PAL67_I1_Pos)

// ----------------------------------------  LCD_PAL68  -------------------------------------------
#define LCD_PAL68_R04_0_Pos                                   0
#define LCD_PAL68_R04_0_Msk                                   (0x1fUL << LCD_PAL68_R04_0_Pos)
#define LCD_PAL68_G04_0_Pos                                   5
#define LCD_PAL68_G04_0_Msk                                   (0x1fUL << LCD_PAL68_G04_0_Pos)
#define LCD_PAL68_B04_0_Pos                                   10
#define LCD_PAL68_B04_0_Msk                                   (0x1fUL << LCD_PAL68_B04_0_Pos)
#define LCD_PAL68_I0_Pos                                      15
#define LCD_PAL68_I0_Msk                                      (0x01UL << LCD_PAL68_I0_Pos)
#define LCD_PAL68_R14_0_Pos                                   16
#define LCD_PAL68_R14_0_Msk                                   (0x1fUL << LCD_PAL68_R14_0_Pos)
#define LCD_PAL68_G14_0_Pos                                   21
#define LCD_PAL68_G14_0_Msk                                   (0x1fUL << LCD_PAL68_G14_0_Pos)
#define LCD_PAL68_B14_0_Pos                                   26
#define LCD_PAL68_B14_0_Msk                                   (0x1fUL << LCD_PAL68_B14_0_Pos)
#define LCD_PAL68_I1_Pos                                      31
#define LCD_PAL68_I1_Msk                                      (0x01UL << LCD_PAL68_I1_Pos)

// ----------------------------------------  LCD_PAL69  -------------------------------------------
#define LCD_PAL69_R04_0_Pos                                   0
#define LCD_PAL69_R04_0_Msk                                   (0x1fUL << LCD_PAL69_R04_0_Pos)
#define LCD_PAL69_G04_0_Pos                                   5
#define LCD_PAL69_G04_0_Msk                                   (0x1fUL << LCD_PAL69_G04_0_Pos)
#define LCD_PAL69_B04_0_Pos                                   10
#define LCD_PAL69_B04_0_Msk                                   (0x1fUL << LCD_PAL69_B04_0_Pos)
#define LCD_PAL69_I0_Pos                                      15
#define LCD_PAL69_I0_Msk                                      (0x01UL << LCD_PAL69_I0_Pos)
#define LCD_PAL69_R14_0_Pos                                   16
#define LCD_PAL69_R14_0_Msk                                   (0x1fUL << LCD_PAL69_R14_0_Pos)
#define LCD_PAL69_G14_0_Pos                                   21
#define LCD_PAL69_G14_0_Msk                                   (0x1fUL << LCD_PAL69_G14_0_Pos)
#define LCD_PAL69_B14_0_Pos                                   26
#define LCD_PAL69_B14_0_Msk                                   (0x1fUL << LCD_PAL69_B14_0_Pos)
#define LCD_PAL69_I1_Pos                                      31
#define LCD_PAL69_I1_Msk                                      (0x01UL << LCD_PAL69_I1_Pos)

// ----------------------------------------  LCD_PAL70  -------------------------------------------
#define LCD_PAL70_R04_0_Pos                                   0
#define LCD_PAL70_R04_0_Msk                                   (0x1fUL << LCD_PAL70_R04_0_Pos)
#define LCD_PAL70_G04_0_Pos                                   5
#define LCD_PAL70_G04_0_Msk                                   (0x1fUL << LCD_PAL70_G04_0_Pos)
#define LCD_PAL70_B04_0_Pos                                   10
#define LCD_PAL70_B04_0_Msk                                   (0x1fUL << LCD_PAL70_B04_0_Pos)
#define LCD_PAL70_I0_Pos                                      15
#define LCD_PAL70_I0_Msk                                      (0x01UL << LCD_PAL70_I0_Pos)
#define LCD_PAL70_R14_0_Pos                                   16
#define LCD_PAL70_R14_0_Msk                                   (0x1fUL << LCD_PAL70_R14_0_Pos)
#define LCD_PAL70_G14_0_Pos                                   21
#define LCD_PAL70_G14_0_Msk                                   (0x1fUL << LCD_PAL70_G14_0_Pos)
#define LCD_PAL70_B14_0_Pos                                   26
#define LCD_PAL70_B14_0_Msk                                   (0x1fUL << LCD_PAL70_B14_0_Pos)
#define LCD_PAL70_I1_Pos                                      31
#define LCD_PAL70_I1_Msk                                      (0x01UL << LCD_PAL70_I1_Pos)

// ----------------------------------------  LCD_PAL71  -------------------------------------------
#define LCD_PAL71_R04_0_Pos                                   0
#define LCD_PAL71_R04_0_Msk                                   (0x1fUL << LCD_PAL71_R04_0_Pos)
#define LCD_PAL71_G04_0_Pos                                   5
#define LCD_PAL71_G04_0_Msk                                   (0x1fUL << LCD_PAL71_G04_0_Pos)
#define LCD_PAL71_B04_0_Pos                                   10
#define LCD_PAL71_B04_0_Msk                                   (0x1fUL << LCD_PAL71_B04_0_Pos)
#define LCD_PAL71_I0_Pos                                      15
#define LCD_PAL71_I0_Msk                                      (0x01UL << LCD_PAL71_I0_Pos)
#define LCD_PAL71_R14_0_Pos                                   16
#define LCD_PAL71_R14_0_Msk                                   (0x1fUL << LCD_PAL71_R14_0_Pos)
#define LCD_PAL71_G14_0_Pos                                   21
#define LCD_PAL71_G14_0_Msk                                   (0x1fUL << LCD_PAL71_G14_0_Pos)
#define LCD_PAL71_B14_0_Pos                                   26
#define LCD_PAL71_B14_0_Msk                                   (0x1fUL << LCD_PAL71_B14_0_Pos)
#define LCD_PAL71_I1_Pos                                      31
#define LCD_PAL71_I1_Msk                                      (0x01UL << LCD_PAL71_I1_Pos)

// ----------------------------------------  LCD_PAL72  -------------------------------------------
#define LCD_PAL72_R04_0_Pos                                   0
#define LCD_PAL72_R04_0_Msk                                   (0x1fUL << LCD_PAL72_R04_0_Pos)
#define LCD_PAL72_G04_0_Pos                                   5
#define LCD_PAL72_G04_0_Msk                                   (0x1fUL << LCD_PAL72_G04_0_Pos)
#define LCD_PAL72_B04_0_Pos                                   10
#define LCD_PAL72_B04_0_Msk                                   (0x1fUL << LCD_PAL72_B04_0_Pos)
#define LCD_PAL72_I0_Pos                                      15
#define LCD_PAL72_I0_Msk                                      (0x01UL << LCD_PAL72_I0_Pos)
#define LCD_PAL72_R14_0_Pos                                   16
#define LCD_PAL72_R14_0_Msk                                   (0x1fUL << LCD_PAL72_R14_0_Pos)
#define LCD_PAL72_G14_0_Pos                                   21
#define LCD_PAL72_G14_0_Msk                                   (0x1fUL << LCD_PAL72_G14_0_Pos)
#define LCD_PAL72_B14_0_Pos                                   26
#define LCD_PAL72_B14_0_Msk                                   (0x1fUL << LCD_PAL72_B14_0_Pos)
#define LCD_PAL72_I1_Pos                                      31
#define LCD_PAL72_I1_Msk                                      (0x01UL << LCD_PAL72_I1_Pos)

// ----------------------------------------  LCD_PAL73  -------------------------------------------
#define LCD_PAL73_R04_0_Pos                                   0
#define LCD_PAL73_R04_0_Msk                                   (0x1fUL << LCD_PAL73_R04_0_Pos)
#define LCD_PAL73_G04_0_Pos                                   5
#define LCD_PAL73_G04_0_Msk                                   (0x1fUL << LCD_PAL73_G04_0_Pos)
#define LCD_PAL73_B04_0_Pos                                   10
#define LCD_PAL73_B04_0_Msk                                   (0x1fUL << LCD_PAL73_B04_0_Pos)
#define LCD_PAL73_I0_Pos                                      15
#define LCD_PAL73_I0_Msk                                      (0x01UL << LCD_PAL73_I0_Pos)
#define LCD_PAL73_R14_0_Pos                                   16
#define LCD_PAL73_R14_0_Msk                                   (0x1fUL << LCD_PAL73_R14_0_Pos)
#define LCD_PAL73_G14_0_Pos                                   21
#define LCD_PAL73_G14_0_Msk                                   (0x1fUL << LCD_PAL73_G14_0_Pos)
#define LCD_PAL73_B14_0_Pos                                   26
#define LCD_PAL73_B14_0_Msk                                   (0x1fUL << LCD_PAL73_B14_0_Pos)
#define LCD_PAL73_I1_Pos                                      31
#define LCD_PAL73_I1_Msk                                      (0x01UL << LCD_PAL73_I1_Pos)

// ----------------------------------------  LCD_PAL74  -------------------------------------------
#define LCD_PAL74_R04_0_Pos                                   0
#define LCD_PAL74_R04_0_Msk                                   (0x1fUL << LCD_PAL74_R04_0_Pos)
#define LCD_PAL74_G04_0_Pos                                   5
#define LCD_PAL74_G04_0_Msk                                   (0x1fUL << LCD_PAL74_G04_0_Pos)
#define LCD_PAL74_B04_0_Pos                                   10
#define LCD_PAL74_B04_0_Msk                                   (0x1fUL << LCD_PAL74_B04_0_Pos)
#define LCD_PAL74_I0_Pos                                      15
#define LCD_PAL74_I0_Msk                                      (0x01UL << LCD_PAL74_I0_Pos)
#define LCD_PAL74_R14_0_Pos                                   16
#define LCD_PAL74_R14_0_Msk                                   (0x1fUL << LCD_PAL74_R14_0_Pos)
#define LCD_PAL74_G14_0_Pos                                   21
#define LCD_PAL74_G14_0_Msk                                   (0x1fUL << LCD_PAL74_G14_0_Pos)
#define LCD_PAL74_B14_0_Pos                                   26
#define LCD_PAL74_B14_0_Msk                                   (0x1fUL << LCD_PAL74_B14_0_Pos)
#define LCD_PAL74_I1_Pos                                      31
#define LCD_PAL74_I1_Msk                                      (0x01UL << LCD_PAL74_I1_Pos)

// ----------------------------------------  LCD_PAL75  -------------------------------------------
#define LCD_PAL75_R04_0_Pos                                   0
#define LCD_PAL75_R04_0_Msk                                   (0x1fUL << LCD_PAL75_R04_0_Pos)
#define LCD_PAL75_G04_0_Pos                                   5
#define LCD_PAL75_G04_0_Msk                                   (0x1fUL << LCD_PAL75_G04_0_Pos)
#define LCD_PAL75_B04_0_Pos                                   10
#define LCD_PAL75_B04_0_Msk                                   (0x1fUL << LCD_PAL75_B04_0_Pos)
#define LCD_PAL75_I0_Pos                                      15
#define LCD_PAL75_I0_Msk                                      (0x01UL << LCD_PAL75_I0_Pos)
#define LCD_PAL75_R14_0_Pos                                   16
#define LCD_PAL75_R14_0_Msk                                   (0x1fUL << LCD_PAL75_R14_0_Pos)
#define LCD_PAL75_G14_0_Pos                                   21
#define LCD_PAL75_G14_0_Msk                                   (0x1fUL << LCD_PAL75_G14_0_Pos)
#define LCD_PAL75_B14_0_Pos                                   26
#define LCD_PAL75_B14_0_Msk                                   (0x1fUL << LCD_PAL75_B14_0_Pos)
#define LCD_PAL75_I1_Pos                                      31
#define LCD_PAL75_I1_Msk                                      (0x01UL << LCD_PAL75_I1_Pos)

// ----------------------------------------  LCD_PAL76  -------------------------------------------
#define LCD_PAL76_R04_0_Pos                                   0
#define LCD_PAL76_R04_0_Msk                                   (0x1fUL << LCD_PAL76_R04_0_Pos)
#define LCD_PAL76_G04_0_Pos                                   5
#define LCD_PAL76_G04_0_Msk                                   (0x1fUL << LCD_PAL76_G04_0_Pos)
#define LCD_PAL76_B04_0_Pos                                   10
#define LCD_PAL76_B04_0_Msk                                   (0x1fUL << LCD_PAL76_B04_0_Pos)
#define LCD_PAL76_I0_Pos                                      15
#define LCD_PAL76_I0_Msk                                      (0x01UL << LCD_PAL76_I0_Pos)
#define LCD_PAL76_R14_0_Pos                                   16
#define LCD_PAL76_R14_0_Msk                                   (0x1fUL << LCD_PAL76_R14_0_Pos)
#define LCD_PAL76_G14_0_Pos                                   21
#define LCD_PAL76_G14_0_Msk                                   (0x1fUL << LCD_PAL76_G14_0_Pos)
#define LCD_PAL76_B14_0_Pos                                   26
#define LCD_PAL76_B14_0_Msk                                   (0x1fUL << LCD_PAL76_B14_0_Pos)
#define LCD_PAL76_I1_Pos                                      31
#define LCD_PAL76_I1_Msk                                      (0x01UL << LCD_PAL76_I1_Pos)

// ----------------------------------------  LCD_PAL77  -------------------------------------------
#define LCD_PAL77_R04_0_Pos                                   0
#define LCD_PAL77_R04_0_Msk                                   (0x1fUL << LCD_PAL77_R04_0_Pos)
#define LCD_PAL77_G04_0_Pos                                   5
#define LCD_PAL77_G04_0_Msk                                   (0x1fUL << LCD_PAL77_G04_0_Pos)
#define LCD_PAL77_B04_0_Pos                                   10
#define LCD_PAL77_B04_0_Msk                                   (0x1fUL << LCD_PAL77_B04_0_Pos)
#define LCD_PAL77_I0_Pos                                      15
#define LCD_PAL77_I0_Msk                                      (0x01UL << LCD_PAL77_I0_Pos)
#define LCD_PAL77_R14_0_Pos                                   16
#define LCD_PAL77_R14_0_Msk                                   (0x1fUL << LCD_PAL77_R14_0_Pos)
#define LCD_PAL77_G14_0_Pos                                   21
#define LCD_PAL77_G14_0_Msk                                   (0x1fUL << LCD_PAL77_G14_0_Pos)
#define LCD_PAL77_B14_0_Pos                                   26
#define LCD_PAL77_B14_0_Msk                                   (0x1fUL << LCD_PAL77_B14_0_Pos)
#define LCD_PAL77_I1_Pos                                      31
#define LCD_PAL77_I1_Msk                                      (0x01UL << LCD_PAL77_I1_Pos)

// ----------------------------------------  LCD_PAL78  -------------------------------------------
#define LCD_PAL78_R04_0_Pos                                   0
#define LCD_PAL78_R04_0_Msk                                   (0x1fUL << LCD_PAL78_R04_0_Pos)
#define LCD_PAL78_G04_0_Pos                                   5
#define LCD_PAL78_G04_0_Msk                                   (0x1fUL << LCD_PAL78_G04_0_Pos)
#define LCD_PAL78_B04_0_Pos                                   10
#define LCD_PAL78_B04_0_Msk                                   (0x1fUL << LCD_PAL78_B04_0_Pos)
#define LCD_PAL78_I0_Pos                                      15
#define LCD_PAL78_I0_Msk                                      (0x01UL << LCD_PAL78_I0_Pos)
#define LCD_PAL78_R14_0_Pos                                   16
#define LCD_PAL78_R14_0_Msk                                   (0x1fUL << LCD_PAL78_R14_0_Pos)
#define LCD_PAL78_G14_0_Pos                                   21
#define LCD_PAL78_G14_0_Msk                                   (0x1fUL << LCD_PAL78_G14_0_Pos)
#define LCD_PAL78_B14_0_Pos                                   26
#define LCD_PAL78_B14_0_Msk                                   (0x1fUL << LCD_PAL78_B14_0_Pos)
#define LCD_PAL78_I1_Pos                                      31
#define LCD_PAL78_I1_Msk                                      (0x01UL << LCD_PAL78_I1_Pos)

// ----------------------------------------  LCD_PAL79  -------------------------------------------
#define LCD_PAL79_R04_0_Pos                                   0
#define LCD_PAL79_R04_0_Msk                                   (0x1fUL << LCD_PAL79_R04_0_Pos)
#define LCD_PAL79_G04_0_Pos                                   5
#define LCD_PAL79_G04_0_Msk                                   (0x1fUL << LCD_PAL79_G04_0_Pos)
#define LCD_PAL79_B04_0_Pos                                   10
#define LCD_PAL79_B04_0_Msk                                   (0x1fUL << LCD_PAL79_B04_0_Pos)
#define LCD_PAL79_I0_Pos                                      15
#define LCD_PAL79_I0_Msk                                      (0x01UL << LCD_PAL79_I0_Pos)
#define LCD_PAL79_R14_0_Pos                                   16
#define LCD_PAL79_R14_0_Msk                                   (0x1fUL << LCD_PAL79_R14_0_Pos)
#define LCD_PAL79_G14_0_Pos                                   21
#define LCD_PAL79_G14_0_Msk                                   (0x1fUL << LCD_PAL79_G14_0_Pos)
#define LCD_PAL79_B14_0_Pos                                   26
#define LCD_PAL79_B14_0_Msk                                   (0x1fUL << LCD_PAL79_B14_0_Pos)
#define LCD_PAL79_I1_Pos                                      31
#define LCD_PAL79_I1_Msk                                      (0x01UL << LCD_PAL79_I1_Pos)

// ----------------------------------------  LCD_PAL80  -------------------------------------------
#define LCD_PAL80_R04_0_Pos                                   0
#define LCD_PAL80_R04_0_Msk                                   (0x1fUL << LCD_PAL80_R04_0_Pos)
#define LCD_PAL80_G04_0_Pos                                   5
#define LCD_PAL80_G04_0_Msk                                   (0x1fUL << LCD_PAL80_G04_0_Pos)
#define LCD_PAL80_B04_0_Pos                                   10
#define LCD_PAL80_B04_0_Msk                                   (0x1fUL << LCD_PAL80_B04_0_Pos)
#define LCD_PAL80_I0_Pos                                      15
#define LCD_PAL80_I0_Msk                                      (0x01UL << LCD_PAL80_I0_Pos)
#define LCD_PAL80_R14_0_Pos                                   16
#define LCD_PAL80_R14_0_Msk                                   (0x1fUL << LCD_PAL80_R14_0_Pos)
#define LCD_PAL80_G14_0_Pos                                   21
#define LCD_PAL80_G14_0_Msk                                   (0x1fUL << LCD_PAL80_G14_0_Pos)
#define LCD_PAL80_B14_0_Pos                                   26
#define LCD_PAL80_B14_0_Msk                                   (0x1fUL << LCD_PAL80_B14_0_Pos)
#define LCD_PAL80_I1_Pos                                      31
#define LCD_PAL80_I1_Msk                                      (0x01UL << LCD_PAL80_I1_Pos)

// ----------------------------------------  LCD_PAL81  -------------------------------------------
#define LCD_PAL81_R04_0_Pos                                   0
#define LCD_PAL81_R04_0_Msk                                   (0x1fUL << LCD_PAL81_R04_0_Pos)
#define LCD_PAL81_G04_0_Pos                                   5
#define LCD_PAL81_G04_0_Msk                                   (0x1fUL << LCD_PAL81_G04_0_Pos)
#define LCD_PAL81_B04_0_Pos                                   10
#define LCD_PAL81_B04_0_Msk                                   (0x1fUL << LCD_PAL81_B04_0_Pos)
#define LCD_PAL81_I0_Pos                                      15
#define LCD_PAL81_I0_Msk                                      (0x01UL << LCD_PAL81_I0_Pos)
#define LCD_PAL81_R14_0_Pos                                   16
#define LCD_PAL81_R14_0_Msk                                   (0x1fUL << LCD_PAL81_R14_0_Pos)
#define LCD_PAL81_G14_0_Pos                                   21
#define LCD_PAL81_G14_0_Msk                                   (0x1fUL << LCD_PAL81_G14_0_Pos)
#define LCD_PAL81_B14_0_Pos                                   26
#define LCD_PAL81_B14_0_Msk                                   (0x1fUL << LCD_PAL81_B14_0_Pos)
#define LCD_PAL81_I1_Pos                                      31
#define LCD_PAL81_I1_Msk                                      (0x01UL << LCD_PAL81_I1_Pos)

// ----------------------------------------  LCD_PAL82  -------------------------------------------
#define LCD_PAL82_R04_0_Pos                                   0
#define LCD_PAL82_R04_0_Msk                                   (0x1fUL << LCD_PAL82_R04_0_Pos)
#define LCD_PAL82_G04_0_Pos                                   5
#define LCD_PAL82_G04_0_Msk                                   (0x1fUL << LCD_PAL82_G04_0_Pos)
#define LCD_PAL82_B04_0_Pos                                   10
#define LCD_PAL82_B04_0_Msk                                   (0x1fUL << LCD_PAL82_B04_0_Pos)
#define LCD_PAL82_I0_Pos                                      15
#define LCD_PAL82_I0_Msk                                      (0x01UL << LCD_PAL82_I0_Pos)
#define LCD_PAL82_R14_0_Pos                                   16
#define LCD_PAL82_R14_0_Msk                                   (0x1fUL << LCD_PAL82_R14_0_Pos)
#define LCD_PAL82_G14_0_Pos                                   21
#define LCD_PAL82_G14_0_Msk                                   (0x1fUL << LCD_PAL82_G14_0_Pos)
#define LCD_PAL82_B14_0_Pos                                   26
#define LCD_PAL82_B14_0_Msk                                   (0x1fUL << LCD_PAL82_B14_0_Pos)
#define LCD_PAL82_I1_Pos                                      31
#define LCD_PAL82_I1_Msk                                      (0x01UL << LCD_PAL82_I1_Pos)

// ----------------------------------------  LCD_PAL83  -------------------------------------------
#define LCD_PAL83_R04_0_Pos                                   0
#define LCD_PAL83_R04_0_Msk                                   (0x1fUL << LCD_PAL83_R04_0_Pos)
#define LCD_PAL83_G04_0_Pos                                   5
#define LCD_PAL83_G04_0_Msk                                   (0x1fUL << LCD_PAL83_G04_0_Pos)
#define LCD_PAL83_B04_0_Pos                                   10
#define LCD_PAL83_B04_0_Msk                                   (0x1fUL << LCD_PAL83_B04_0_Pos)
#define LCD_PAL83_I0_Pos                                      15
#define LCD_PAL83_I0_Msk                                      (0x01UL << LCD_PAL83_I0_Pos)
#define LCD_PAL83_R14_0_Pos                                   16
#define LCD_PAL83_R14_0_Msk                                   (0x1fUL << LCD_PAL83_R14_0_Pos)
#define LCD_PAL83_G14_0_Pos                                   21
#define LCD_PAL83_G14_0_Msk                                   (0x1fUL << LCD_PAL83_G14_0_Pos)
#define LCD_PAL83_B14_0_Pos                                   26
#define LCD_PAL83_B14_0_Msk                                   (0x1fUL << LCD_PAL83_B14_0_Pos)
#define LCD_PAL83_I1_Pos                                      31
#define LCD_PAL83_I1_Msk                                      (0x01UL << LCD_PAL83_I1_Pos)

// ----------------------------------------  LCD_PAL84  -------------------------------------------
#define LCD_PAL84_R04_0_Pos                                   0
#define LCD_PAL84_R04_0_Msk                                   (0x1fUL << LCD_PAL84_R04_0_Pos)
#define LCD_PAL84_G04_0_Pos                                   5
#define LCD_PAL84_G04_0_Msk                                   (0x1fUL << LCD_PAL84_G04_0_Pos)
#define LCD_PAL84_B04_0_Pos                                   10
#define LCD_PAL84_B04_0_Msk                                   (0x1fUL << LCD_PAL84_B04_0_Pos)
#define LCD_PAL84_I0_Pos                                      15
#define LCD_PAL84_I0_Msk                                      (0x01UL << LCD_PAL84_I0_Pos)
#define LCD_PAL84_R14_0_Pos                                   16
#define LCD_PAL84_R14_0_Msk                                   (0x1fUL << LCD_PAL84_R14_0_Pos)
#define LCD_PAL84_G14_0_Pos                                   21
#define LCD_PAL84_G14_0_Msk                                   (0x1fUL << LCD_PAL84_G14_0_Pos)
#define LCD_PAL84_B14_0_Pos                                   26
#define LCD_PAL84_B14_0_Msk                                   (0x1fUL << LCD_PAL84_B14_0_Pos)
#define LCD_PAL84_I1_Pos                                      31
#define LCD_PAL84_I1_Msk                                      (0x01UL << LCD_PAL84_I1_Pos)

// ----------------------------------------  LCD_PAL85  -------------------------------------------
#define LCD_PAL85_R04_0_Pos                                   0
#define LCD_PAL85_R04_0_Msk                                   (0x1fUL << LCD_PAL85_R04_0_Pos)
#define LCD_PAL85_G04_0_Pos                                   5
#define LCD_PAL85_G04_0_Msk                                   (0x1fUL << LCD_PAL85_G04_0_Pos)
#define LCD_PAL85_B04_0_Pos                                   10
#define LCD_PAL85_B04_0_Msk                                   (0x1fUL << LCD_PAL85_B04_0_Pos)
#define LCD_PAL85_I0_Pos                                      15
#define LCD_PAL85_I0_Msk                                      (0x01UL << LCD_PAL85_I0_Pos)
#define LCD_PAL85_R14_0_Pos                                   16
#define LCD_PAL85_R14_0_Msk                                   (0x1fUL << LCD_PAL85_R14_0_Pos)
#define LCD_PAL85_G14_0_Pos                                   21
#define LCD_PAL85_G14_0_Msk                                   (0x1fUL << LCD_PAL85_G14_0_Pos)
#define LCD_PAL85_B14_0_Pos                                   26
#define LCD_PAL85_B14_0_Msk                                   (0x1fUL << LCD_PAL85_B14_0_Pos)
#define LCD_PAL85_I1_Pos                                      31
#define LCD_PAL85_I1_Msk                                      (0x01UL << LCD_PAL85_I1_Pos)

// ----------------------------------------  LCD_PAL86  -------------------------------------------
#define LCD_PAL86_R04_0_Pos                                   0
#define LCD_PAL86_R04_0_Msk                                   (0x1fUL << LCD_PAL86_R04_0_Pos)
#define LCD_PAL86_G04_0_Pos                                   5
#define LCD_PAL86_G04_0_Msk                                   (0x1fUL << LCD_PAL86_G04_0_Pos)
#define LCD_PAL86_B04_0_Pos                                   10
#define LCD_PAL86_B04_0_Msk                                   (0x1fUL << LCD_PAL86_B04_0_Pos)
#define LCD_PAL86_I0_Pos                                      15
#define LCD_PAL86_I0_Msk                                      (0x01UL << LCD_PAL86_I0_Pos)
#define LCD_PAL86_R14_0_Pos                                   16
#define LCD_PAL86_R14_0_Msk                                   (0x1fUL << LCD_PAL86_R14_0_Pos)
#define LCD_PAL86_G14_0_Pos                                   21
#define LCD_PAL86_G14_0_Msk                                   (0x1fUL << LCD_PAL86_G14_0_Pos)
#define LCD_PAL86_B14_0_Pos                                   26
#define LCD_PAL86_B14_0_Msk                                   (0x1fUL << LCD_PAL86_B14_0_Pos)
#define LCD_PAL86_I1_Pos                                      31
#define LCD_PAL86_I1_Msk                                      (0x01UL << LCD_PAL86_I1_Pos)

// ----------------------------------------  LCD_PAL87  -------------------------------------------
#define LCD_PAL87_R04_0_Pos                                   0
#define LCD_PAL87_R04_0_Msk                                   (0x1fUL << LCD_PAL87_R04_0_Pos)
#define LCD_PAL87_G04_0_Pos                                   5
#define LCD_PAL87_G04_0_Msk                                   (0x1fUL << LCD_PAL87_G04_0_Pos)
#define LCD_PAL87_B04_0_Pos                                   10
#define LCD_PAL87_B04_0_Msk                                   (0x1fUL << LCD_PAL87_B04_0_Pos)
#define LCD_PAL87_I0_Pos                                      15
#define LCD_PAL87_I0_Msk                                      (0x01UL << LCD_PAL87_I0_Pos)
#define LCD_PAL87_R14_0_Pos                                   16
#define LCD_PAL87_R14_0_Msk                                   (0x1fUL << LCD_PAL87_R14_0_Pos)
#define LCD_PAL87_G14_0_Pos                                   21
#define LCD_PAL87_G14_0_Msk                                   (0x1fUL << LCD_PAL87_G14_0_Pos)
#define LCD_PAL87_B14_0_Pos                                   26
#define LCD_PAL87_B14_0_Msk                                   (0x1fUL << LCD_PAL87_B14_0_Pos)
#define LCD_PAL87_I1_Pos                                      31
#define LCD_PAL87_I1_Msk                                      (0x01UL << LCD_PAL87_I1_Pos)

// ----------------------------------------  LCD_PAL88  -------------------------------------------
#define LCD_PAL88_R04_0_Pos                                   0
#define LCD_PAL88_R04_0_Msk                                   (0x1fUL << LCD_PAL88_R04_0_Pos)
#define LCD_PAL88_G04_0_Pos                                   5
#define LCD_PAL88_G04_0_Msk                                   (0x1fUL << LCD_PAL88_G04_0_Pos)
#define LCD_PAL88_B04_0_Pos                                   10
#define LCD_PAL88_B04_0_Msk                                   (0x1fUL << LCD_PAL88_B04_0_Pos)
#define LCD_PAL88_I0_Pos                                      15
#define LCD_PAL88_I0_Msk                                      (0x01UL << LCD_PAL88_I0_Pos)
#define LCD_PAL88_R14_0_Pos                                   16
#define LCD_PAL88_R14_0_Msk                                   (0x1fUL << LCD_PAL88_R14_0_Pos)
#define LCD_PAL88_G14_0_Pos                                   21
#define LCD_PAL88_G14_0_Msk                                   (0x1fUL << LCD_PAL88_G14_0_Pos)
#define LCD_PAL88_B14_0_Pos                                   26
#define LCD_PAL88_B14_0_Msk                                   (0x1fUL << LCD_PAL88_B14_0_Pos)
#define LCD_PAL88_I1_Pos                                      31
#define LCD_PAL88_I1_Msk                                      (0x01UL << LCD_PAL88_I1_Pos)

// ----------------------------------------  LCD_PAL89  -------------------------------------------
#define LCD_PAL89_R04_0_Pos                                   0
#define LCD_PAL89_R04_0_Msk                                   (0x1fUL << LCD_PAL89_R04_0_Pos)
#define LCD_PAL89_G04_0_Pos                                   5
#define LCD_PAL89_G04_0_Msk                                   (0x1fUL << LCD_PAL89_G04_0_Pos)
#define LCD_PAL89_B04_0_Pos                                   10
#define LCD_PAL89_B04_0_Msk                                   (0x1fUL << LCD_PAL89_B04_0_Pos)
#define LCD_PAL89_I0_Pos                                      15
#define LCD_PAL89_I0_Msk                                      (0x01UL << LCD_PAL89_I0_Pos)
#define LCD_PAL89_R14_0_Pos                                   16
#define LCD_PAL89_R14_0_Msk                                   (0x1fUL << LCD_PAL89_R14_0_Pos)
#define LCD_PAL89_G14_0_Pos                                   21
#define LCD_PAL89_G14_0_Msk                                   (0x1fUL << LCD_PAL89_G14_0_Pos)
#define LCD_PAL89_B14_0_Pos                                   26
#define LCD_PAL89_B14_0_Msk                                   (0x1fUL << LCD_PAL89_B14_0_Pos)
#define LCD_PAL89_I1_Pos                                      31
#define LCD_PAL89_I1_Msk                                      (0x01UL << LCD_PAL89_I1_Pos)

// ----------------------------------------  LCD_PAL90  -------------------------------------------
#define LCD_PAL90_R04_0_Pos                                   0
#define LCD_PAL90_R04_0_Msk                                   (0x1fUL << LCD_PAL90_R04_0_Pos)
#define LCD_PAL90_G04_0_Pos                                   5
#define LCD_PAL90_G04_0_Msk                                   (0x1fUL << LCD_PAL90_G04_0_Pos)
#define LCD_PAL90_B04_0_Pos                                   10
#define LCD_PAL90_B04_0_Msk                                   (0x1fUL << LCD_PAL90_B04_0_Pos)
#define LCD_PAL90_I0_Pos                                      15
#define LCD_PAL90_I0_Msk                                      (0x01UL << LCD_PAL90_I0_Pos)
#define LCD_PAL90_R14_0_Pos                                   16
#define LCD_PAL90_R14_0_Msk                                   (0x1fUL << LCD_PAL90_R14_0_Pos)
#define LCD_PAL90_G14_0_Pos                                   21
#define LCD_PAL90_G14_0_Msk                                   (0x1fUL << LCD_PAL90_G14_0_Pos)
#define LCD_PAL90_B14_0_Pos                                   26
#define LCD_PAL90_B14_0_Msk                                   (0x1fUL << LCD_PAL90_B14_0_Pos)
#define LCD_PAL90_I1_Pos                                      31
#define LCD_PAL90_I1_Msk                                      (0x01UL << LCD_PAL90_I1_Pos)

// ----------------------------------------  LCD_PAL91  -------------------------------------------
#define LCD_PAL91_R04_0_Pos                                   0
#define LCD_PAL91_R04_0_Msk                                   (0x1fUL << LCD_PAL91_R04_0_Pos)
#define LCD_PAL91_G04_0_Pos                                   5
#define LCD_PAL91_G04_0_Msk                                   (0x1fUL << LCD_PAL91_G04_0_Pos)
#define LCD_PAL91_B04_0_Pos                                   10
#define LCD_PAL91_B04_0_Msk                                   (0x1fUL << LCD_PAL91_B04_0_Pos)
#define LCD_PAL91_I0_Pos                                      15
#define LCD_PAL91_I0_Msk                                      (0x01UL << LCD_PAL91_I0_Pos)
#define LCD_PAL91_R14_0_Pos                                   16
#define LCD_PAL91_R14_0_Msk                                   (0x1fUL << LCD_PAL91_R14_0_Pos)
#define LCD_PAL91_G14_0_Pos                                   21
#define LCD_PAL91_G14_0_Msk                                   (0x1fUL << LCD_PAL91_G14_0_Pos)
#define LCD_PAL91_B14_0_Pos                                   26
#define LCD_PAL91_B14_0_Msk                                   (0x1fUL << LCD_PAL91_B14_0_Pos)
#define LCD_PAL91_I1_Pos                                      31
#define LCD_PAL91_I1_Msk                                      (0x01UL << LCD_PAL91_I1_Pos)

// ----------------------------------------  LCD_PAL92  -------------------------------------------
#define LCD_PAL92_R04_0_Pos                                   0
#define LCD_PAL92_R04_0_Msk                                   (0x1fUL << LCD_PAL92_R04_0_Pos)
#define LCD_PAL92_G04_0_Pos                                   5
#define LCD_PAL92_G04_0_Msk                                   (0x1fUL << LCD_PAL92_G04_0_Pos)
#define LCD_PAL92_B04_0_Pos                                   10
#define LCD_PAL92_B04_0_Msk                                   (0x1fUL << LCD_PAL92_B04_0_Pos)
#define LCD_PAL92_I0_Pos                                      15
#define LCD_PAL92_I0_Msk                                      (0x01UL << LCD_PAL92_I0_Pos)
#define LCD_PAL92_R14_0_Pos                                   16
#define LCD_PAL92_R14_0_Msk                                   (0x1fUL << LCD_PAL92_R14_0_Pos)
#define LCD_PAL92_G14_0_Pos                                   21
#define LCD_PAL92_G14_0_Msk                                   (0x1fUL << LCD_PAL92_G14_0_Pos)
#define LCD_PAL92_B14_0_Pos                                   26
#define LCD_PAL92_B14_0_Msk                                   (0x1fUL << LCD_PAL92_B14_0_Pos)
#define LCD_PAL92_I1_Pos                                      31
#define LCD_PAL92_I1_Msk                                      (0x01UL << LCD_PAL92_I1_Pos)

// ----------------------------------------  LCD_PAL93  -------------------------------------------
#define LCD_PAL93_R04_0_Pos                                   0
#define LCD_PAL93_R04_0_Msk                                   (0x1fUL << LCD_PAL93_R04_0_Pos)
#define LCD_PAL93_G04_0_Pos                                   5
#define LCD_PAL93_G04_0_Msk                                   (0x1fUL << LCD_PAL93_G04_0_Pos)
#define LCD_PAL93_B04_0_Pos                                   10
#define LCD_PAL93_B04_0_Msk                                   (0x1fUL << LCD_PAL93_B04_0_Pos)
#define LCD_PAL93_I0_Pos                                      15
#define LCD_PAL93_I0_Msk                                      (0x01UL << LCD_PAL93_I0_Pos)
#define LCD_PAL93_R14_0_Pos                                   16
#define LCD_PAL93_R14_0_Msk                                   (0x1fUL << LCD_PAL93_R14_0_Pos)
#define LCD_PAL93_G14_0_Pos                                   21
#define LCD_PAL93_G14_0_Msk                                   (0x1fUL << LCD_PAL93_G14_0_Pos)
#define LCD_PAL93_B14_0_Pos                                   26
#define LCD_PAL93_B14_0_Msk                                   (0x1fUL << LCD_PAL93_B14_0_Pos)
#define LCD_PAL93_I1_Pos                                      31
#define LCD_PAL93_I1_Msk                                      (0x01UL << LCD_PAL93_I1_Pos)

// ----------------------------------------  LCD_PAL94  -------------------------------------------
#define LCD_PAL94_R04_0_Pos                                   0
#define LCD_PAL94_R04_0_Msk                                   (0x1fUL << LCD_PAL94_R04_0_Pos)
#define LCD_PAL94_G04_0_Pos                                   5
#define LCD_PAL94_G04_0_Msk                                   (0x1fUL << LCD_PAL94_G04_0_Pos)
#define LCD_PAL94_B04_0_Pos                                   10
#define LCD_PAL94_B04_0_Msk                                   (0x1fUL << LCD_PAL94_B04_0_Pos)
#define LCD_PAL94_I0_Pos                                      15
#define LCD_PAL94_I0_Msk                                      (0x01UL << LCD_PAL94_I0_Pos)
#define LCD_PAL94_R14_0_Pos                                   16
#define LCD_PAL94_R14_0_Msk                                   (0x1fUL << LCD_PAL94_R14_0_Pos)
#define LCD_PAL94_G14_0_Pos                                   21
#define LCD_PAL94_G14_0_Msk                                   (0x1fUL << LCD_PAL94_G14_0_Pos)
#define LCD_PAL94_B14_0_Pos                                   26
#define LCD_PAL94_B14_0_Msk                                   (0x1fUL << LCD_PAL94_B14_0_Pos)
#define LCD_PAL94_I1_Pos                                      31
#define LCD_PAL94_I1_Msk                                      (0x01UL << LCD_PAL94_I1_Pos)

// ----------------------------------------  LCD_PAL95  -------------------------------------------
#define LCD_PAL95_R04_0_Pos                                   0
#define LCD_PAL95_R04_0_Msk                                   (0x1fUL << LCD_PAL95_R04_0_Pos)
#define LCD_PAL95_G04_0_Pos                                   5
#define LCD_PAL95_G04_0_Msk                                   (0x1fUL << LCD_PAL95_G04_0_Pos)
#define LCD_PAL95_B04_0_Pos                                   10
#define LCD_PAL95_B04_0_Msk                                   (0x1fUL << LCD_PAL95_B04_0_Pos)
#define LCD_PAL95_I0_Pos                                      15
#define LCD_PAL95_I0_Msk                                      (0x01UL << LCD_PAL95_I0_Pos)
#define LCD_PAL95_R14_0_Pos                                   16
#define LCD_PAL95_R14_0_Msk                                   (0x1fUL << LCD_PAL95_R14_0_Pos)
#define LCD_PAL95_G14_0_Pos                                   21
#define LCD_PAL95_G14_0_Msk                                   (0x1fUL << LCD_PAL95_G14_0_Pos)
#define LCD_PAL95_B14_0_Pos                                   26
#define LCD_PAL95_B14_0_Msk                                   (0x1fUL << LCD_PAL95_B14_0_Pos)
#define LCD_PAL95_I1_Pos                                      31
#define LCD_PAL95_I1_Msk                                      (0x01UL << LCD_PAL95_I1_Pos)

// ----------------------------------------  LCD_PAL96  -------------------------------------------
#define LCD_PAL96_R04_0_Pos                                   0
#define LCD_PAL96_R04_0_Msk                                   (0x1fUL << LCD_PAL96_R04_0_Pos)
#define LCD_PAL96_G04_0_Pos                                   5
#define LCD_PAL96_G04_0_Msk                                   (0x1fUL << LCD_PAL96_G04_0_Pos)
#define LCD_PAL96_B04_0_Pos                                   10
#define LCD_PAL96_B04_0_Msk                                   (0x1fUL << LCD_PAL96_B04_0_Pos)
#define LCD_PAL96_I0_Pos                                      15
#define LCD_PAL96_I0_Msk                                      (0x01UL << LCD_PAL96_I0_Pos)
#define LCD_PAL96_R14_0_Pos                                   16
#define LCD_PAL96_R14_0_Msk                                   (0x1fUL << LCD_PAL96_R14_0_Pos)
#define LCD_PAL96_G14_0_Pos                                   21
#define LCD_PAL96_G14_0_Msk                                   (0x1fUL << LCD_PAL96_G14_0_Pos)
#define LCD_PAL96_B14_0_Pos                                   26
#define LCD_PAL96_B14_0_Msk                                   (0x1fUL << LCD_PAL96_B14_0_Pos)
#define LCD_PAL96_I1_Pos                                      31
#define LCD_PAL96_I1_Msk                                      (0x01UL << LCD_PAL96_I1_Pos)

// ----------------------------------------  LCD_PAL97  -------------------------------------------
#define LCD_PAL97_R04_0_Pos                                   0
#define LCD_PAL97_R04_0_Msk                                   (0x1fUL << LCD_PAL97_R04_0_Pos)
#define LCD_PAL97_G04_0_Pos                                   5
#define LCD_PAL97_G04_0_Msk                                   (0x1fUL << LCD_PAL97_G04_0_Pos)
#define LCD_PAL97_B04_0_Pos                                   10
#define LCD_PAL97_B04_0_Msk                                   (0x1fUL << LCD_PAL97_B04_0_Pos)
#define LCD_PAL97_I0_Pos                                      15
#define LCD_PAL97_I0_Msk                                      (0x01UL << LCD_PAL97_I0_Pos)
#define LCD_PAL97_R14_0_Pos                                   16
#define LCD_PAL97_R14_0_Msk                                   (0x1fUL << LCD_PAL97_R14_0_Pos)
#define LCD_PAL97_G14_0_Pos                                   21
#define LCD_PAL97_G14_0_Msk                                   (0x1fUL << LCD_PAL97_G14_0_Pos)
#define LCD_PAL97_B14_0_Pos                                   26
#define LCD_PAL97_B14_0_Msk                                   (0x1fUL << LCD_PAL97_B14_0_Pos)
#define LCD_PAL97_I1_Pos                                      31
#define LCD_PAL97_I1_Msk                                      (0x01UL << LCD_PAL97_I1_Pos)

// ----------------------------------------  LCD_PAL98  -------------------------------------------
#define LCD_PAL98_R04_0_Pos                                   0
#define LCD_PAL98_R04_0_Msk                                   (0x1fUL << LCD_PAL98_R04_0_Pos)
#define LCD_PAL98_G04_0_Pos                                   5
#define LCD_PAL98_G04_0_Msk                                   (0x1fUL << LCD_PAL98_G04_0_Pos)
#define LCD_PAL98_B04_0_Pos                                   10
#define LCD_PAL98_B04_0_Msk                                   (0x1fUL << LCD_PAL98_B04_0_Pos)
#define LCD_PAL98_I0_Pos                                      15
#define LCD_PAL98_I0_Msk                                      (0x01UL << LCD_PAL98_I0_Pos)
#define LCD_PAL98_R14_0_Pos                                   16
#define LCD_PAL98_R14_0_Msk                                   (0x1fUL << LCD_PAL98_R14_0_Pos)
#define LCD_PAL98_G14_0_Pos                                   21
#define LCD_PAL98_G14_0_Msk                                   (0x1fUL << LCD_PAL98_G14_0_Pos)
#define LCD_PAL98_B14_0_Pos                                   26
#define LCD_PAL98_B14_0_Msk                                   (0x1fUL << LCD_PAL98_B14_0_Pos)
#define LCD_PAL98_I1_Pos                                      31
#define LCD_PAL98_I1_Msk                                      (0x01UL << LCD_PAL98_I1_Pos)

// ----------------------------------------  LCD_PAL99  -------------------------------------------
#define LCD_PAL99_R04_0_Pos                                   0
#define LCD_PAL99_R04_0_Msk                                   (0x1fUL << LCD_PAL99_R04_0_Pos)
#define LCD_PAL99_G04_0_Pos                                   5
#define LCD_PAL99_G04_0_Msk                                   (0x1fUL << LCD_PAL99_G04_0_Pos)
#define LCD_PAL99_B04_0_Pos                                   10
#define LCD_PAL99_B04_0_Msk                                   (0x1fUL << LCD_PAL99_B04_0_Pos)
#define LCD_PAL99_I0_Pos                                      15
#define LCD_PAL99_I0_Msk                                      (0x01UL << LCD_PAL99_I0_Pos)
#define LCD_PAL99_R14_0_Pos                                   16
#define LCD_PAL99_R14_0_Msk                                   (0x1fUL << LCD_PAL99_R14_0_Pos)
#define LCD_PAL99_G14_0_Pos                                   21
#define LCD_PAL99_G14_0_Msk                                   (0x1fUL << LCD_PAL99_G14_0_Pos)
#define LCD_PAL99_B14_0_Pos                                   26
#define LCD_PAL99_B14_0_Msk                                   (0x1fUL << LCD_PAL99_B14_0_Pos)
#define LCD_PAL99_I1_Pos                                      31
#define LCD_PAL99_I1_Msk                                      (0x01UL << LCD_PAL99_I1_Pos)

// ---------------------------------------  LCD_PAL100  -------------------------------------------
#define LCD_PAL100_R04_0_Pos                                  0
#define LCD_PAL100_R04_0_Msk                                  (0x1fUL << LCD_PAL100_R04_0_Pos)
#define LCD_PAL100_G04_0_Pos                                  5
#define LCD_PAL100_G04_0_Msk                                  (0x1fUL << LCD_PAL100_G04_0_Pos)
#define LCD_PAL100_B04_0_Pos                                  10
#define LCD_PAL100_B04_0_Msk                                  (0x1fUL << LCD_PAL100_B04_0_Pos)
#define LCD_PAL100_I0_Pos                                     15
#define LCD_PAL100_I0_Msk                                     (0x01UL << LCD_PAL100_I0_Pos)
#define LCD_PAL100_R14_0_Pos                                  16
#define LCD_PAL100_R14_0_Msk                                  (0x1fUL << LCD_PAL100_R14_0_Pos)
#define LCD_PAL100_G14_0_Pos                                  21
#define LCD_PAL100_G14_0_Msk                                  (0x1fUL << LCD_PAL100_G14_0_Pos)
#define LCD_PAL100_B14_0_Pos                                  26
#define LCD_PAL100_B14_0_Msk                                  (0x1fUL << LCD_PAL100_B14_0_Pos)
#define LCD_PAL100_I1_Pos                                     31
#define LCD_PAL100_I1_Msk                                     (0x01UL << LCD_PAL100_I1_Pos)

// ---------------------------------------  LCD_PAL101  -------------------------------------------
#define LCD_PAL101_R04_0_Pos                                  0
#define LCD_PAL101_R04_0_Msk                                  (0x1fUL << LCD_PAL101_R04_0_Pos)
#define LCD_PAL101_G04_0_Pos                                  5
#define LCD_PAL101_G04_0_Msk                                  (0x1fUL << LCD_PAL101_G04_0_Pos)
#define LCD_PAL101_B04_0_Pos                                  10
#define LCD_PAL101_B04_0_Msk                                  (0x1fUL << LCD_PAL101_B04_0_Pos)
#define LCD_PAL101_I0_Pos                                     15
#define LCD_PAL101_I0_Msk                                     (0x01UL << LCD_PAL101_I0_Pos)
#define LCD_PAL101_R14_0_Pos                                  16
#define LCD_PAL101_R14_0_Msk                                  (0x1fUL << LCD_PAL101_R14_0_Pos)
#define LCD_PAL101_G14_0_Pos                                  21
#define LCD_PAL101_G14_0_Msk                                  (0x1fUL << LCD_PAL101_G14_0_Pos)
#define LCD_PAL101_B14_0_Pos                                  26
#define LCD_PAL101_B14_0_Msk                                  (0x1fUL << LCD_PAL101_B14_0_Pos)
#define LCD_PAL101_I1_Pos                                     31
#define LCD_PAL101_I1_Msk                                     (0x01UL << LCD_PAL101_I1_Pos)

// ---------------------------------------  LCD_PAL102  -------------------------------------------
#define LCD_PAL102_R04_0_Pos                                  0
#define LCD_PAL102_R04_0_Msk                                  (0x1fUL << LCD_PAL102_R04_0_Pos)
#define LCD_PAL102_G04_0_Pos                                  5
#define LCD_PAL102_G04_0_Msk                                  (0x1fUL << LCD_PAL102_G04_0_Pos)
#define LCD_PAL102_B04_0_Pos                                  10
#define LCD_PAL102_B04_0_Msk                                  (0x1fUL << LCD_PAL102_B04_0_Pos)
#define LCD_PAL102_I0_Pos                                     15
#define LCD_PAL102_I0_Msk                                     (0x01UL << LCD_PAL102_I0_Pos)
#define LCD_PAL102_R14_0_Pos                                  16
#define LCD_PAL102_R14_0_Msk                                  (0x1fUL << LCD_PAL102_R14_0_Pos)
#define LCD_PAL102_G14_0_Pos                                  21
#define LCD_PAL102_G14_0_Msk                                  (0x1fUL << LCD_PAL102_G14_0_Pos)
#define LCD_PAL102_B14_0_Pos                                  26
#define LCD_PAL102_B14_0_Msk                                  (0x1fUL << LCD_PAL102_B14_0_Pos)
#define LCD_PAL102_I1_Pos                                     31
#define LCD_PAL102_I1_Msk                                     (0x01UL << LCD_PAL102_I1_Pos)

// ---------------------------------------  LCD_PAL103  -------------------------------------------
#define LCD_PAL103_R04_0_Pos                                  0
#define LCD_PAL103_R04_0_Msk                                  (0x1fUL << LCD_PAL103_R04_0_Pos)
#define LCD_PAL103_G04_0_Pos                                  5
#define LCD_PAL103_G04_0_Msk                                  (0x1fUL << LCD_PAL103_G04_0_Pos)
#define LCD_PAL103_B04_0_Pos                                  10
#define LCD_PAL103_B04_0_Msk                                  (0x1fUL << LCD_PAL103_B04_0_Pos)
#define LCD_PAL103_I0_Pos                                     15
#define LCD_PAL103_I0_Msk                                     (0x01UL << LCD_PAL103_I0_Pos)
#define LCD_PAL103_R14_0_Pos                                  16
#define LCD_PAL103_R14_0_Msk                                  (0x1fUL << LCD_PAL103_R14_0_Pos)
#define LCD_PAL103_G14_0_Pos                                  21
#define LCD_PAL103_G14_0_Msk                                  (0x1fUL << LCD_PAL103_G14_0_Pos)
#define LCD_PAL103_B14_0_Pos                                  26
#define LCD_PAL103_B14_0_Msk                                  (0x1fUL << LCD_PAL103_B14_0_Pos)
#define LCD_PAL103_I1_Pos                                     31
#define LCD_PAL103_I1_Msk                                     (0x01UL << LCD_PAL103_I1_Pos)

// ---------------------------------------  LCD_PAL104  -------------------------------------------
#define LCD_PAL104_R04_0_Pos                                  0
#define LCD_PAL104_R04_0_Msk                                  (0x1fUL << LCD_PAL104_R04_0_Pos)
#define LCD_PAL104_G04_0_Pos                                  5
#define LCD_PAL104_G04_0_Msk                                  (0x1fUL << LCD_PAL104_G04_0_Pos)
#define LCD_PAL104_B04_0_Pos                                  10
#define LCD_PAL104_B04_0_Msk                                  (0x1fUL << LCD_PAL104_B04_0_Pos)
#define LCD_PAL104_I0_Pos                                     15
#define LCD_PAL104_I0_Msk                                     (0x01UL << LCD_PAL104_I0_Pos)
#define LCD_PAL104_R14_0_Pos                                  16
#define LCD_PAL104_R14_0_Msk                                  (0x1fUL << LCD_PAL104_R14_0_Pos)
#define LCD_PAL104_G14_0_Pos                                  21
#define LCD_PAL104_G14_0_Msk                                  (0x1fUL << LCD_PAL104_G14_0_Pos)
#define LCD_PAL104_B14_0_Pos                                  26
#define LCD_PAL104_B14_0_Msk                                  (0x1fUL << LCD_PAL104_B14_0_Pos)
#define LCD_PAL104_I1_Pos                                     31
#define LCD_PAL104_I1_Msk                                     (0x01UL << LCD_PAL104_I1_Pos)

// ---------------------------------------  LCD_PAL105  -------------------------------------------
#define LCD_PAL105_R04_0_Pos                                  0
#define LCD_PAL105_R04_0_Msk                                  (0x1fUL << LCD_PAL105_R04_0_Pos)
#define LCD_PAL105_G04_0_Pos                                  5
#define LCD_PAL105_G04_0_Msk                                  (0x1fUL << LCD_PAL105_G04_0_Pos)
#define LCD_PAL105_B04_0_Pos                                  10
#define LCD_PAL105_B04_0_Msk                                  (0x1fUL << LCD_PAL105_B04_0_Pos)
#define LCD_PAL105_I0_Pos                                     15
#define LCD_PAL105_I0_Msk                                     (0x01UL << LCD_PAL105_I0_Pos)
#define LCD_PAL105_R14_0_Pos                                  16
#define LCD_PAL105_R14_0_Msk                                  (0x1fUL << LCD_PAL105_R14_0_Pos)
#define LCD_PAL105_G14_0_Pos                                  21
#define LCD_PAL105_G14_0_Msk                                  (0x1fUL << LCD_PAL105_G14_0_Pos)
#define LCD_PAL105_B14_0_Pos                                  26
#define LCD_PAL105_B14_0_Msk                                  (0x1fUL << LCD_PAL105_B14_0_Pos)
#define LCD_PAL105_I1_Pos                                     31
#define LCD_PAL105_I1_Msk                                     (0x01UL << LCD_PAL105_I1_Pos)

// ---------------------------------------  LCD_PAL106  -------------------------------------------
#define LCD_PAL106_R04_0_Pos                                  0
#define LCD_PAL106_R04_0_Msk                                  (0x1fUL << LCD_PAL106_R04_0_Pos)
#define LCD_PAL106_G04_0_Pos                                  5
#define LCD_PAL106_G04_0_Msk                                  (0x1fUL << LCD_PAL106_G04_0_Pos)
#define LCD_PAL106_B04_0_Pos                                  10
#define LCD_PAL106_B04_0_Msk                                  (0x1fUL << LCD_PAL106_B04_0_Pos)
#define LCD_PAL106_I0_Pos                                     15
#define LCD_PAL106_I0_Msk                                     (0x01UL << LCD_PAL106_I0_Pos)
#define LCD_PAL106_R14_0_Pos                                  16
#define LCD_PAL106_R14_0_Msk                                  (0x1fUL << LCD_PAL106_R14_0_Pos)
#define LCD_PAL106_G14_0_Pos                                  21
#define LCD_PAL106_G14_0_Msk                                  (0x1fUL << LCD_PAL106_G14_0_Pos)
#define LCD_PAL106_B14_0_Pos                                  26
#define LCD_PAL106_B14_0_Msk                                  (0x1fUL << LCD_PAL106_B14_0_Pos)
#define LCD_PAL106_I1_Pos                                     31
#define LCD_PAL106_I1_Msk                                     (0x01UL << LCD_PAL106_I1_Pos)

// ---------------------------------------  LCD_PAL107  -------------------------------------------
#define LCD_PAL107_R04_0_Pos                                  0
#define LCD_PAL107_R04_0_Msk                                  (0x1fUL << LCD_PAL107_R04_0_Pos)
#define LCD_PAL107_G04_0_Pos                                  5
#define LCD_PAL107_G04_0_Msk                                  (0x1fUL << LCD_PAL107_G04_0_Pos)
#define LCD_PAL107_B04_0_Pos                                  10
#define LCD_PAL107_B04_0_Msk                                  (0x1fUL << LCD_PAL107_B04_0_Pos)
#define LCD_PAL107_I0_Pos                                     15
#define LCD_PAL107_I0_Msk                                     (0x01UL << LCD_PAL107_I0_Pos)
#define LCD_PAL107_R14_0_Pos                                  16
#define LCD_PAL107_R14_0_Msk                                  (0x1fUL << LCD_PAL107_R14_0_Pos)
#define LCD_PAL107_G14_0_Pos                                  21
#define LCD_PAL107_G14_0_Msk                                  (0x1fUL << LCD_PAL107_G14_0_Pos)
#define LCD_PAL107_B14_0_Pos                                  26
#define LCD_PAL107_B14_0_Msk                                  (0x1fUL << LCD_PAL107_B14_0_Pos)
#define LCD_PAL107_I1_Pos                                     31
#define LCD_PAL107_I1_Msk                                     (0x01UL << LCD_PAL107_I1_Pos)

// ---------------------------------------  LCD_PAL108  -------------------------------------------
#define LCD_PAL108_R04_0_Pos                                  0
#define LCD_PAL108_R04_0_Msk                                  (0x1fUL << LCD_PAL108_R04_0_Pos)
#define LCD_PAL108_G04_0_Pos                                  5
#define LCD_PAL108_G04_0_Msk                                  (0x1fUL << LCD_PAL108_G04_0_Pos)
#define LCD_PAL108_B04_0_Pos                                  10
#define LCD_PAL108_B04_0_Msk                                  (0x1fUL << LCD_PAL108_B04_0_Pos)
#define LCD_PAL108_I0_Pos                                     15
#define LCD_PAL108_I0_Msk                                     (0x01UL << LCD_PAL108_I0_Pos)
#define LCD_PAL108_R14_0_Pos                                  16
#define LCD_PAL108_R14_0_Msk                                  (0x1fUL << LCD_PAL108_R14_0_Pos)
#define LCD_PAL108_G14_0_Pos                                  21
#define LCD_PAL108_G14_0_Msk                                  (0x1fUL << LCD_PAL108_G14_0_Pos)
#define LCD_PAL108_B14_0_Pos                                  26
#define LCD_PAL108_B14_0_Msk                                  (0x1fUL << LCD_PAL108_B14_0_Pos)
#define LCD_PAL108_I1_Pos                                     31
#define LCD_PAL108_I1_Msk                                     (0x01UL << LCD_PAL108_I1_Pos)

// ---------------------------------------  LCD_PAL109  -------------------------------------------
#define LCD_PAL109_R04_0_Pos                                  0
#define LCD_PAL109_R04_0_Msk                                  (0x1fUL << LCD_PAL109_R04_0_Pos)
#define LCD_PAL109_G04_0_Pos                                  5
#define LCD_PAL109_G04_0_Msk                                  (0x1fUL << LCD_PAL109_G04_0_Pos)
#define LCD_PAL109_B04_0_Pos                                  10
#define LCD_PAL109_B04_0_Msk                                  (0x1fUL << LCD_PAL109_B04_0_Pos)
#define LCD_PAL109_I0_Pos                                     15
#define LCD_PAL109_I0_Msk                                     (0x01UL << LCD_PAL109_I0_Pos)
#define LCD_PAL109_R14_0_Pos                                  16
#define LCD_PAL109_R14_0_Msk                                  (0x1fUL << LCD_PAL109_R14_0_Pos)
#define LCD_PAL109_G14_0_Pos                                  21
#define LCD_PAL109_G14_0_Msk                                  (0x1fUL << LCD_PAL109_G14_0_Pos)
#define LCD_PAL109_B14_0_Pos                                  26
#define LCD_PAL109_B14_0_Msk                                  (0x1fUL << LCD_PAL109_B14_0_Pos)
#define LCD_PAL109_I1_Pos                                     31
#define LCD_PAL109_I1_Msk                                     (0x01UL << LCD_PAL109_I1_Pos)

// ---------------------------------------  LCD_PAL110  -------------------------------------------
#define LCD_PAL110_R04_0_Pos                                  0
#define LCD_PAL110_R04_0_Msk                                  (0x1fUL << LCD_PAL110_R04_0_Pos)
#define LCD_PAL110_G04_0_Pos                                  5
#define LCD_PAL110_G04_0_Msk                                  (0x1fUL << LCD_PAL110_G04_0_Pos)
#define LCD_PAL110_B04_0_Pos                                  10
#define LCD_PAL110_B04_0_Msk                                  (0x1fUL << LCD_PAL110_B04_0_Pos)
#define LCD_PAL110_I0_Pos                                     15
#define LCD_PAL110_I0_Msk                                     (0x01UL << LCD_PAL110_I0_Pos)
#define LCD_PAL110_R14_0_Pos                                  16
#define LCD_PAL110_R14_0_Msk                                  (0x1fUL << LCD_PAL110_R14_0_Pos)
#define LCD_PAL110_G14_0_Pos                                  21
#define LCD_PAL110_G14_0_Msk                                  (0x1fUL << LCD_PAL110_G14_0_Pos)
#define LCD_PAL110_B14_0_Pos                                  26
#define LCD_PAL110_B14_0_Msk                                  (0x1fUL << LCD_PAL110_B14_0_Pos)
#define LCD_PAL110_I1_Pos                                     31
#define LCD_PAL110_I1_Msk                                     (0x01UL << LCD_PAL110_I1_Pos)

// ---------------------------------------  LCD_PAL111  -------------------------------------------
#define LCD_PAL111_R04_0_Pos                                  0
#define LCD_PAL111_R04_0_Msk                                  (0x1fUL << LCD_PAL111_R04_0_Pos)
#define LCD_PAL111_G04_0_Pos                                  5
#define LCD_PAL111_G04_0_Msk                                  (0x1fUL << LCD_PAL111_G04_0_Pos)
#define LCD_PAL111_B04_0_Pos                                  10
#define LCD_PAL111_B04_0_Msk                                  (0x1fUL << LCD_PAL111_B04_0_Pos)
#define LCD_PAL111_I0_Pos                                     15
#define LCD_PAL111_I0_Msk                                     (0x01UL << LCD_PAL111_I0_Pos)
#define LCD_PAL111_R14_0_Pos                                  16
#define LCD_PAL111_R14_0_Msk                                  (0x1fUL << LCD_PAL111_R14_0_Pos)
#define LCD_PAL111_G14_0_Pos                                  21
#define LCD_PAL111_G14_0_Msk                                  (0x1fUL << LCD_PAL111_G14_0_Pos)
#define LCD_PAL111_B14_0_Pos                                  26
#define LCD_PAL111_B14_0_Msk                                  (0x1fUL << LCD_PAL111_B14_0_Pos)
#define LCD_PAL111_I1_Pos                                     31
#define LCD_PAL111_I1_Msk                                     (0x01UL << LCD_PAL111_I1_Pos)

// ---------------------------------------  LCD_PAL112  -------------------------------------------
#define LCD_PAL112_R04_0_Pos                                  0
#define LCD_PAL112_R04_0_Msk                                  (0x1fUL << LCD_PAL112_R04_0_Pos)
#define LCD_PAL112_G04_0_Pos                                  5
#define LCD_PAL112_G04_0_Msk                                  (0x1fUL << LCD_PAL112_G04_0_Pos)
#define LCD_PAL112_B04_0_Pos                                  10
#define LCD_PAL112_B04_0_Msk                                  (0x1fUL << LCD_PAL112_B04_0_Pos)
#define LCD_PAL112_I0_Pos                                     15
#define LCD_PAL112_I0_Msk                                     (0x01UL << LCD_PAL112_I0_Pos)
#define LCD_PAL112_R14_0_Pos                                  16
#define LCD_PAL112_R14_0_Msk                                  (0x1fUL << LCD_PAL112_R14_0_Pos)
#define LCD_PAL112_G14_0_Pos                                  21
#define LCD_PAL112_G14_0_Msk                                  (0x1fUL << LCD_PAL112_G14_0_Pos)
#define LCD_PAL112_B14_0_Pos                                  26
#define LCD_PAL112_B14_0_Msk                                  (0x1fUL << LCD_PAL112_B14_0_Pos)
#define LCD_PAL112_I1_Pos                                     31
#define LCD_PAL112_I1_Msk                                     (0x01UL << LCD_PAL112_I1_Pos)

// ---------------------------------------  LCD_PAL113  -------------------------------------------
#define LCD_PAL113_R04_0_Pos                                  0
#define LCD_PAL113_R04_0_Msk                                  (0x1fUL << LCD_PAL113_R04_0_Pos)
#define LCD_PAL113_G04_0_Pos                                  5
#define LCD_PAL113_G04_0_Msk                                  (0x1fUL << LCD_PAL113_G04_0_Pos)
#define LCD_PAL113_B04_0_Pos                                  10
#define LCD_PAL113_B04_0_Msk                                  (0x1fUL << LCD_PAL113_B04_0_Pos)
#define LCD_PAL113_I0_Pos                                     15
#define LCD_PAL113_I0_Msk                                     (0x01UL << LCD_PAL113_I0_Pos)
#define LCD_PAL113_R14_0_Pos                                  16
#define LCD_PAL113_R14_0_Msk                                  (0x1fUL << LCD_PAL113_R14_0_Pos)
#define LCD_PAL113_G14_0_Pos                                  21
#define LCD_PAL113_G14_0_Msk                                  (0x1fUL << LCD_PAL113_G14_0_Pos)
#define LCD_PAL113_B14_0_Pos                                  26
#define LCD_PAL113_B14_0_Msk                                  (0x1fUL << LCD_PAL113_B14_0_Pos)
#define LCD_PAL113_I1_Pos                                     31
#define LCD_PAL113_I1_Msk                                     (0x01UL << LCD_PAL113_I1_Pos)

// ---------------------------------------  LCD_PAL114  -------------------------------------------
#define LCD_PAL114_R04_0_Pos                                  0
#define LCD_PAL114_R04_0_Msk                                  (0x1fUL << LCD_PAL114_R04_0_Pos)
#define LCD_PAL114_G04_0_Pos                                  5
#define LCD_PAL114_G04_0_Msk                                  (0x1fUL << LCD_PAL114_G04_0_Pos)
#define LCD_PAL114_B04_0_Pos                                  10
#define LCD_PAL114_B04_0_Msk                                  (0x1fUL << LCD_PAL114_B04_0_Pos)
#define LCD_PAL114_I0_Pos                                     15
#define LCD_PAL114_I0_Msk                                     (0x01UL << LCD_PAL114_I0_Pos)
#define LCD_PAL114_R14_0_Pos                                  16
#define LCD_PAL114_R14_0_Msk                                  (0x1fUL << LCD_PAL114_R14_0_Pos)
#define LCD_PAL114_G14_0_Pos                                  21
#define LCD_PAL114_G14_0_Msk                                  (0x1fUL << LCD_PAL114_G14_0_Pos)
#define LCD_PAL114_B14_0_Pos                                  26
#define LCD_PAL114_B14_0_Msk                                  (0x1fUL << LCD_PAL114_B14_0_Pos)
#define LCD_PAL114_I1_Pos                                     31
#define LCD_PAL114_I1_Msk                                     (0x01UL << LCD_PAL114_I1_Pos)

// ---------------------------------------  LCD_PAL115  -------------------------------------------
#define LCD_PAL115_R04_0_Pos                                  0
#define LCD_PAL115_R04_0_Msk                                  (0x1fUL << LCD_PAL115_R04_0_Pos)
#define LCD_PAL115_G04_0_Pos                                  5
#define LCD_PAL115_G04_0_Msk                                  (0x1fUL << LCD_PAL115_G04_0_Pos)
#define LCD_PAL115_B04_0_Pos                                  10
#define LCD_PAL115_B04_0_Msk                                  (0x1fUL << LCD_PAL115_B04_0_Pos)
#define LCD_PAL115_I0_Pos                                     15
#define LCD_PAL115_I0_Msk                                     (0x01UL << LCD_PAL115_I0_Pos)
#define LCD_PAL115_R14_0_Pos                                  16
#define LCD_PAL115_R14_0_Msk                                  (0x1fUL << LCD_PAL115_R14_0_Pos)
#define LCD_PAL115_G14_0_Pos                                  21
#define LCD_PAL115_G14_0_Msk                                  (0x1fUL << LCD_PAL115_G14_0_Pos)
#define LCD_PAL115_B14_0_Pos                                  26
#define LCD_PAL115_B14_0_Msk                                  (0x1fUL << LCD_PAL115_B14_0_Pos)
#define LCD_PAL115_I1_Pos                                     31
#define LCD_PAL115_I1_Msk                                     (0x01UL << LCD_PAL115_I1_Pos)

// ---------------------------------------  LCD_PAL116  -------------------------------------------
#define LCD_PAL116_R04_0_Pos                                  0
#define LCD_PAL116_R04_0_Msk                                  (0x1fUL << LCD_PAL116_R04_0_Pos)
#define LCD_PAL116_G04_0_Pos                                  5
#define LCD_PAL116_G04_0_Msk                                  (0x1fUL << LCD_PAL116_G04_0_Pos)
#define LCD_PAL116_B04_0_Pos                                  10
#define LCD_PAL116_B04_0_Msk                                  (0x1fUL << LCD_PAL116_B04_0_Pos)
#define LCD_PAL116_I0_Pos                                     15
#define LCD_PAL116_I0_Msk                                     (0x01UL << LCD_PAL116_I0_Pos)
#define LCD_PAL116_R14_0_Pos                                  16
#define LCD_PAL116_R14_0_Msk                                  (0x1fUL << LCD_PAL116_R14_0_Pos)
#define LCD_PAL116_G14_0_Pos                                  21
#define LCD_PAL116_G14_0_Msk                                  (0x1fUL << LCD_PAL116_G14_0_Pos)
#define LCD_PAL116_B14_0_Pos                                  26
#define LCD_PAL116_B14_0_Msk                                  (0x1fUL << LCD_PAL116_B14_0_Pos)
#define LCD_PAL116_I1_Pos                                     31
#define LCD_PAL116_I1_Msk                                     (0x01UL << LCD_PAL116_I1_Pos)

// ---------------------------------------  LCD_PAL117  -------------------------------------------
#define LCD_PAL117_R04_0_Pos                                  0
#define LCD_PAL117_R04_0_Msk                                  (0x1fUL << LCD_PAL117_R04_0_Pos)
#define LCD_PAL117_G04_0_Pos                                  5
#define LCD_PAL117_G04_0_Msk                                  (0x1fUL << LCD_PAL117_G04_0_Pos)
#define LCD_PAL117_B04_0_Pos                                  10
#define LCD_PAL117_B04_0_Msk                                  (0x1fUL << LCD_PAL117_B04_0_Pos)
#define LCD_PAL117_I0_Pos                                     15
#define LCD_PAL117_I0_Msk                                     (0x01UL << LCD_PAL117_I0_Pos)
#define LCD_PAL117_R14_0_Pos                                  16
#define LCD_PAL117_R14_0_Msk                                  (0x1fUL << LCD_PAL117_R14_0_Pos)
#define LCD_PAL117_G14_0_Pos                                  21
#define LCD_PAL117_G14_0_Msk                                  (0x1fUL << LCD_PAL117_G14_0_Pos)
#define LCD_PAL117_B14_0_Pos                                  26
#define LCD_PAL117_B14_0_Msk                                  (0x1fUL << LCD_PAL117_B14_0_Pos)
#define LCD_PAL117_I1_Pos                                     31
#define LCD_PAL117_I1_Msk                                     (0x01UL << LCD_PAL117_I1_Pos)

// ---------------------------------------  LCD_PAL118  -------------------------------------------
#define LCD_PAL118_R04_0_Pos                                  0
#define LCD_PAL118_R04_0_Msk                                  (0x1fUL << LCD_PAL118_R04_0_Pos)
#define LCD_PAL118_G04_0_Pos                                  5
#define LCD_PAL118_G04_0_Msk                                  (0x1fUL << LCD_PAL118_G04_0_Pos)
#define LCD_PAL118_B04_0_Pos                                  10
#define LCD_PAL118_B04_0_Msk                                  (0x1fUL << LCD_PAL118_B04_0_Pos)
#define LCD_PAL118_I0_Pos                                     15
#define LCD_PAL118_I0_Msk                                     (0x01UL << LCD_PAL118_I0_Pos)
#define LCD_PAL118_R14_0_Pos                                  16
#define LCD_PAL118_R14_0_Msk                                  (0x1fUL << LCD_PAL118_R14_0_Pos)
#define LCD_PAL118_G14_0_Pos                                  21
#define LCD_PAL118_G14_0_Msk                                  (0x1fUL << LCD_PAL118_G14_0_Pos)
#define LCD_PAL118_B14_0_Pos                                  26
#define LCD_PAL118_B14_0_Msk                                  (0x1fUL << LCD_PAL118_B14_0_Pos)
#define LCD_PAL118_I1_Pos                                     31
#define LCD_PAL118_I1_Msk                                     (0x01UL << LCD_PAL118_I1_Pos)

// ---------------------------------------  LCD_PAL119  -------------------------------------------
#define LCD_PAL119_R04_0_Pos                                  0
#define LCD_PAL119_R04_0_Msk                                  (0x1fUL << LCD_PAL119_R04_0_Pos)
#define LCD_PAL119_G04_0_Pos                                  5
#define LCD_PAL119_G04_0_Msk                                  (0x1fUL << LCD_PAL119_G04_0_Pos)
#define LCD_PAL119_B04_0_Pos                                  10
#define LCD_PAL119_B04_0_Msk                                  (0x1fUL << LCD_PAL119_B04_0_Pos)
#define LCD_PAL119_I0_Pos                                     15
#define LCD_PAL119_I0_Msk                                     (0x01UL << LCD_PAL119_I0_Pos)
#define LCD_PAL119_R14_0_Pos                                  16
#define LCD_PAL119_R14_0_Msk                                  (0x1fUL << LCD_PAL119_R14_0_Pos)
#define LCD_PAL119_G14_0_Pos                                  21
#define LCD_PAL119_G14_0_Msk                                  (0x1fUL << LCD_PAL119_G14_0_Pos)
#define LCD_PAL119_B14_0_Pos                                  26
#define LCD_PAL119_B14_0_Msk                                  (0x1fUL << LCD_PAL119_B14_0_Pos)
#define LCD_PAL119_I1_Pos                                     31
#define LCD_PAL119_I1_Msk                                     (0x01UL << LCD_PAL119_I1_Pos)

// ---------------------------------------  LCD_PAL120  -------------------------------------------
#define LCD_PAL120_R04_0_Pos                                  0
#define LCD_PAL120_R04_0_Msk                                  (0x1fUL << LCD_PAL120_R04_0_Pos)
#define LCD_PAL120_G04_0_Pos                                  5
#define LCD_PAL120_G04_0_Msk                                  (0x1fUL << LCD_PAL120_G04_0_Pos)
#define LCD_PAL120_B04_0_Pos                                  10
#define LCD_PAL120_B04_0_Msk                                  (0x1fUL << LCD_PAL120_B04_0_Pos)
#define LCD_PAL120_I0_Pos                                     15
#define LCD_PAL120_I0_Msk                                     (0x01UL << LCD_PAL120_I0_Pos)
#define LCD_PAL120_R14_0_Pos                                  16
#define LCD_PAL120_R14_0_Msk                                  (0x1fUL << LCD_PAL120_R14_0_Pos)
#define LCD_PAL120_G14_0_Pos                                  21
#define LCD_PAL120_G14_0_Msk                                  (0x1fUL << LCD_PAL120_G14_0_Pos)
#define LCD_PAL120_B14_0_Pos                                  26
#define LCD_PAL120_B14_0_Msk                                  (0x1fUL << LCD_PAL120_B14_0_Pos)
#define LCD_PAL120_I1_Pos                                     31
#define LCD_PAL120_I1_Msk                                     (0x01UL << LCD_PAL120_I1_Pos)

// ---------------------------------------  LCD_PAL121  -------------------------------------------
#define LCD_PAL121_R04_0_Pos                                  0
#define LCD_PAL121_R04_0_Msk                                  (0x1fUL << LCD_PAL121_R04_0_Pos)
#define LCD_PAL121_G04_0_Pos                                  5
#define LCD_PAL121_G04_0_Msk                                  (0x1fUL << LCD_PAL121_G04_0_Pos)
#define LCD_PAL121_B04_0_Pos                                  10
#define LCD_PAL121_B04_0_Msk                                  (0x1fUL << LCD_PAL121_B04_0_Pos)
#define LCD_PAL121_I0_Pos                                     15
#define LCD_PAL121_I0_Msk                                     (0x01UL << LCD_PAL121_I0_Pos)
#define LCD_PAL121_R14_0_Pos                                  16
#define LCD_PAL121_R14_0_Msk                                  (0x1fUL << LCD_PAL121_R14_0_Pos)
#define LCD_PAL121_G14_0_Pos                                  21
#define LCD_PAL121_G14_0_Msk                                  (0x1fUL << LCD_PAL121_G14_0_Pos)
#define LCD_PAL121_B14_0_Pos                                  26
#define LCD_PAL121_B14_0_Msk                                  (0x1fUL << LCD_PAL121_B14_0_Pos)
#define LCD_PAL121_I1_Pos                                     31
#define LCD_PAL121_I1_Msk                                     (0x01UL << LCD_PAL121_I1_Pos)

// ---------------------------------------  LCD_PAL122  -------------------------------------------
#define LCD_PAL122_R04_0_Pos                                  0
#define LCD_PAL122_R04_0_Msk                                  (0x1fUL << LCD_PAL122_R04_0_Pos)
#define LCD_PAL122_G04_0_Pos                                  5
#define LCD_PAL122_G04_0_Msk                                  (0x1fUL << LCD_PAL122_G04_0_Pos)
#define LCD_PAL122_B04_0_Pos                                  10
#define LCD_PAL122_B04_0_Msk                                  (0x1fUL << LCD_PAL122_B04_0_Pos)
#define LCD_PAL122_I0_Pos                                     15
#define LCD_PAL122_I0_Msk                                     (0x01UL << LCD_PAL122_I0_Pos)
#define LCD_PAL122_R14_0_Pos                                  16
#define LCD_PAL122_R14_0_Msk                                  (0x1fUL << LCD_PAL122_R14_0_Pos)
#define LCD_PAL122_G14_0_Pos                                  21
#define LCD_PAL122_G14_0_Msk                                  (0x1fUL << LCD_PAL122_G14_0_Pos)
#define LCD_PAL122_B14_0_Pos                                  26
#define LCD_PAL122_B14_0_Msk                                  (0x1fUL << LCD_PAL122_B14_0_Pos)
#define LCD_PAL122_I1_Pos                                     31
#define LCD_PAL122_I1_Msk                                     (0x01UL << LCD_PAL122_I1_Pos)

// ---------------------------------------  LCD_PAL123  -------------------------------------------
#define LCD_PAL123_R04_0_Pos                                  0
#define LCD_PAL123_R04_0_Msk                                  (0x1fUL << LCD_PAL123_R04_0_Pos)
#define LCD_PAL123_G04_0_Pos                                  5
#define LCD_PAL123_G04_0_Msk                                  (0x1fUL << LCD_PAL123_G04_0_Pos)
#define LCD_PAL123_B04_0_Pos                                  10
#define LCD_PAL123_B04_0_Msk                                  (0x1fUL << LCD_PAL123_B04_0_Pos)
#define LCD_PAL123_I0_Pos                                     15
#define LCD_PAL123_I0_Msk                                     (0x01UL << LCD_PAL123_I0_Pos)
#define LCD_PAL123_R14_0_Pos                                  16
#define LCD_PAL123_R14_0_Msk                                  (0x1fUL << LCD_PAL123_R14_0_Pos)
#define LCD_PAL123_G14_0_Pos                                  21
#define LCD_PAL123_G14_0_Msk                                  (0x1fUL << LCD_PAL123_G14_0_Pos)
#define LCD_PAL123_B14_0_Pos                                  26
#define LCD_PAL123_B14_0_Msk                                  (0x1fUL << LCD_PAL123_B14_0_Pos)
#define LCD_PAL123_I1_Pos                                     31
#define LCD_PAL123_I1_Msk                                     (0x01UL << LCD_PAL123_I1_Pos)

// ---------------------------------------  LCD_PAL124  -------------------------------------------
#define LCD_PAL124_R04_0_Pos                                  0
#define LCD_PAL124_R04_0_Msk                                  (0x1fUL << LCD_PAL124_R04_0_Pos)
#define LCD_PAL124_G04_0_Pos                                  5
#define LCD_PAL124_G04_0_Msk                                  (0x1fUL << LCD_PAL124_G04_0_Pos)
#define LCD_PAL124_B04_0_Pos                                  10
#define LCD_PAL124_B04_0_Msk                                  (0x1fUL << LCD_PAL124_B04_0_Pos)
#define LCD_PAL124_I0_Pos                                     15
#define LCD_PAL124_I0_Msk                                     (0x01UL << LCD_PAL124_I0_Pos)
#define LCD_PAL124_R14_0_Pos                                  16
#define LCD_PAL124_R14_0_Msk                                  (0x1fUL << LCD_PAL124_R14_0_Pos)
#define LCD_PAL124_G14_0_Pos                                  21
#define LCD_PAL124_G14_0_Msk                                  (0x1fUL << LCD_PAL124_G14_0_Pos)
#define LCD_PAL124_B14_0_Pos                                  26
#define LCD_PAL124_B14_0_Msk                                  (0x1fUL << LCD_PAL124_B14_0_Pos)
#define LCD_PAL124_I1_Pos                                     31
#define LCD_PAL124_I1_Msk                                     (0x01UL << LCD_PAL124_I1_Pos)

// ---------------------------------------  LCD_PAL125  -------------------------------------------
#define LCD_PAL125_R04_0_Pos                                  0
#define LCD_PAL125_R04_0_Msk                                  (0x1fUL << LCD_PAL125_R04_0_Pos)
#define LCD_PAL125_G04_0_Pos                                  5
#define LCD_PAL125_G04_0_Msk                                  (0x1fUL << LCD_PAL125_G04_0_Pos)
#define LCD_PAL125_B04_0_Pos                                  10
#define LCD_PAL125_B04_0_Msk                                  (0x1fUL << LCD_PAL125_B04_0_Pos)
#define LCD_PAL125_I0_Pos                                     15
#define LCD_PAL125_I0_Msk                                     (0x01UL << LCD_PAL125_I0_Pos)
#define LCD_PAL125_R14_0_Pos                                  16
#define LCD_PAL125_R14_0_Msk                                  (0x1fUL << LCD_PAL125_R14_0_Pos)
#define LCD_PAL125_G14_0_Pos                                  21
#define LCD_PAL125_G14_0_Msk                                  (0x1fUL << LCD_PAL125_G14_0_Pos)
#define LCD_PAL125_B14_0_Pos                                  26
#define LCD_PAL125_B14_0_Msk                                  (0x1fUL << LCD_PAL125_B14_0_Pos)
#define LCD_PAL125_I1_Pos                                     31
#define LCD_PAL125_I1_Msk                                     (0x01UL << LCD_PAL125_I1_Pos)

// ---------------------------------------  LCD_PAL126  -------------------------------------------
#define LCD_PAL126_R04_0_Pos                                  0
#define LCD_PAL126_R04_0_Msk                                  (0x1fUL << LCD_PAL126_R04_0_Pos)
#define LCD_PAL126_G04_0_Pos                                  5
#define LCD_PAL126_G04_0_Msk                                  (0x1fUL << LCD_PAL126_G04_0_Pos)
#define LCD_PAL126_B04_0_Pos                                  10
#define LCD_PAL126_B04_0_Msk                                  (0x1fUL << LCD_PAL126_B04_0_Pos)
#define LCD_PAL126_I0_Pos                                     15
#define LCD_PAL126_I0_Msk                                     (0x01UL << LCD_PAL126_I0_Pos)
#define LCD_PAL126_R14_0_Pos                                  16
#define LCD_PAL126_R14_0_Msk                                  (0x1fUL << LCD_PAL126_R14_0_Pos)
#define LCD_PAL126_G14_0_Pos                                  21
#define LCD_PAL126_G14_0_Msk                                  (0x1fUL << LCD_PAL126_G14_0_Pos)
#define LCD_PAL126_B14_0_Pos                                  26
#define LCD_PAL126_B14_0_Msk                                  (0x1fUL << LCD_PAL126_B14_0_Pos)
#define LCD_PAL126_I1_Pos                                     31
#define LCD_PAL126_I1_Msk                                     (0x01UL << LCD_PAL126_I1_Pos)

// ---------------------------------------  LCD_PAL127  -------------------------------------------
#define LCD_PAL127_R04_0_Pos                                  0
#define LCD_PAL127_R04_0_Msk                                  (0x1fUL << LCD_PAL127_R04_0_Pos)
#define LCD_PAL127_G04_0_Pos                                  5
#define LCD_PAL127_G04_0_Msk                                  (0x1fUL << LCD_PAL127_G04_0_Pos)
#define LCD_PAL127_B04_0_Pos                                  10
#define LCD_PAL127_B04_0_Msk                                  (0x1fUL << LCD_PAL127_B04_0_Pos)
#define LCD_PAL127_I0_Pos                                     15
#define LCD_PAL127_I0_Msk                                     (0x01UL << LCD_PAL127_I0_Pos)
#define LCD_PAL127_R14_0_Pos                                  16
#define LCD_PAL127_R14_0_Msk                                  (0x1fUL << LCD_PAL127_R14_0_Pos)
#define LCD_PAL127_G14_0_Pos                                  21
#define LCD_PAL127_G14_0_Msk                                  (0x1fUL << LCD_PAL127_G14_0_Pos)
#define LCD_PAL127_B14_0_Pos                                  26
#define LCD_PAL127_B14_0_Msk                                  (0x1fUL << LCD_PAL127_B14_0_Pos)
#define LCD_PAL127_I1_Pos                                     31
#define LCD_PAL127_I1_Msk                                     (0x01UL << LCD_PAL127_I1_Pos)

// ---------------------------------------  LCD_PAL128  -------------------------------------------
#define LCD_PAL128_R04_0_Pos                                  0
#define LCD_PAL128_R04_0_Msk                                  (0x1fUL << LCD_PAL128_R04_0_Pos)
#define LCD_PAL128_G04_0_Pos                                  5
#define LCD_PAL128_G04_0_Msk                                  (0x1fUL << LCD_PAL128_G04_0_Pos)
#define LCD_PAL128_B04_0_Pos                                  10
#define LCD_PAL128_B04_0_Msk                                  (0x1fUL << LCD_PAL128_B04_0_Pos)
#define LCD_PAL128_I0_Pos                                     15
#define LCD_PAL128_I0_Msk                                     (0x01UL << LCD_PAL128_I0_Pos)
#define LCD_PAL128_R14_0_Pos                                  16
#define LCD_PAL128_R14_0_Msk                                  (0x1fUL << LCD_PAL128_R14_0_Pos)
#define LCD_PAL128_G14_0_Pos                                  21
#define LCD_PAL128_G14_0_Msk                                  (0x1fUL << LCD_PAL128_G14_0_Pos)
#define LCD_PAL128_B14_0_Pos                                  26
#define LCD_PAL128_B14_0_Msk                                  (0x1fUL << LCD_PAL128_B14_0_Pos)
#define LCD_PAL128_I1_Pos                                     31
#define LCD_PAL128_I1_Msk                                     (0x01UL << LCD_PAL128_I1_Pos)

// ---------------------------------------  LCD_PAL129  -------------------------------------------
#define LCD_PAL129_R04_0_Pos                                  0
#define LCD_PAL129_R04_0_Msk                                  (0x1fUL << LCD_PAL129_R04_0_Pos)
#define LCD_PAL129_G04_0_Pos                                  5
#define LCD_PAL129_G04_0_Msk                                  (0x1fUL << LCD_PAL129_G04_0_Pos)
#define LCD_PAL129_B04_0_Pos                                  10
#define LCD_PAL129_B04_0_Msk                                  (0x1fUL << LCD_PAL129_B04_0_Pos)
#define LCD_PAL129_I0_Pos                                     15
#define LCD_PAL129_I0_Msk                                     (0x01UL << LCD_PAL129_I0_Pos)
#define LCD_PAL129_R14_0_Pos                                  16
#define LCD_PAL129_R14_0_Msk                                  (0x1fUL << LCD_PAL129_R14_0_Pos)
#define LCD_PAL129_G14_0_Pos                                  21
#define LCD_PAL129_G14_0_Msk                                  (0x1fUL << LCD_PAL129_G14_0_Pos)
#define LCD_PAL129_B14_0_Pos                                  26
#define LCD_PAL129_B14_0_Msk                                  (0x1fUL << LCD_PAL129_B14_0_Pos)
#define LCD_PAL129_I1_Pos                                     31
#define LCD_PAL129_I1_Msk                                     (0x01UL << LCD_PAL129_I1_Pos)

// ---------------------------------------  LCD_PAL130  -------------------------------------------
#define LCD_PAL130_R04_0_Pos                                  0
#define LCD_PAL130_R04_0_Msk                                  (0x1fUL << LCD_PAL130_R04_0_Pos)
#define LCD_PAL130_G04_0_Pos                                  5
#define LCD_PAL130_G04_0_Msk                                  (0x1fUL << LCD_PAL130_G04_0_Pos)
#define LCD_PAL130_B04_0_Pos                                  10
#define LCD_PAL130_B04_0_Msk                                  (0x1fUL << LCD_PAL130_B04_0_Pos)
#define LCD_PAL130_I0_Pos                                     15
#define LCD_PAL130_I0_Msk                                     (0x01UL << LCD_PAL130_I0_Pos)
#define LCD_PAL130_R14_0_Pos                                  16
#define LCD_PAL130_R14_0_Msk                                  (0x1fUL << LCD_PAL130_R14_0_Pos)
#define LCD_PAL130_G14_0_Pos                                  21
#define LCD_PAL130_G14_0_Msk                                  (0x1fUL << LCD_PAL130_G14_0_Pos)
#define LCD_PAL130_B14_0_Pos                                  26
#define LCD_PAL130_B14_0_Msk                                  (0x1fUL << LCD_PAL130_B14_0_Pos)
#define LCD_PAL130_I1_Pos                                     31
#define LCD_PAL130_I1_Msk                                     (0x01UL << LCD_PAL130_I1_Pos)

// ---------------------------------------  LCD_PAL131  -------------------------------------------
#define LCD_PAL131_R04_0_Pos                                  0
#define LCD_PAL131_R04_0_Msk                                  (0x1fUL << LCD_PAL131_R04_0_Pos)
#define LCD_PAL131_G04_0_Pos                                  5
#define LCD_PAL131_G04_0_Msk                                  (0x1fUL << LCD_PAL131_G04_0_Pos)
#define LCD_PAL131_B04_0_Pos                                  10
#define LCD_PAL131_B04_0_Msk                                  (0x1fUL << LCD_PAL131_B04_0_Pos)
#define LCD_PAL131_I0_Pos                                     15
#define LCD_PAL131_I0_Msk                                     (0x01UL << LCD_PAL131_I0_Pos)
#define LCD_PAL131_R14_0_Pos                                  16
#define LCD_PAL131_R14_0_Msk                                  (0x1fUL << LCD_PAL131_R14_0_Pos)
#define LCD_PAL131_G14_0_Pos                                  21
#define LCD_PAL131_G14_0_Msk                                  (0x1fUL << LCD_PAL131_G14_0_Pos)
#define LCD_PAL131_B14_0_Pos                                  26
#define LCD_PAL131_B14_0_Msk                                  (0x1fUL << LCD_PAL131_B14_0_Pos)
#define LCD_PAL131_I1_Pos                                     31
#define LCD_PAL131_I1_Msk                                     (0x01UL << LCD_PAL131_I1_Pos)

// ---------------------------------------  LCD_PAL132  -------------------------------------------
#define LCD_PAL132_R04_0_Pos                                  0
#define LCD_PAL132_R04_0_Msk                                  (0x1fUL << LCD_PAL132_R04_0_Pos)
#define LCD_PAL132_G04_0_Pos                                  5
#define LCD_PAL132_G04_0_Msk                                  (0x1fUL << LCD_PAL132_G04_0_Pos)
#define LCD_PAL132_B04_0_Pos                                  10
#define LCD_PAL132_B04_0_Msk                                  (0x1fUL << LCD_PAL132_B04_0_Pos)
#define LCD_PAL132_I0_Pos                                     15
#define LCD_PAL132_I0_Msk                                     (0x01UL << LCD_PAL132_I0_Pos)
#define LCD_PAL132_R14_0_Pos                                  16
#define LCD_PAL132_R14_0_Msk                                  (0x1fUL << LCD_PAL132_R14_0_Pos)
#define LCD_PAL132_G14_0_Pos                                  21
#define LCD_PAL132_G14_0_Msk                                  (0x1fUL << LCD_PAL132_G14_0_Pos)
#define LCD_PAL132_B14_0_Pos                                  26
#define LCD_PAL132_B14_0_Msk                                  (0x1fUL << LCD_PAL132_B14_0_Pos)
#define LCD_PAL132_I1_Pos                                     31
#define LCD_PAL132_I1_Msk                                     (0x01UL << LCD_PAL132_I1_Pos)

// ---------------------------------------  LCD_PAL133  -------------------------------------------
#define LCD_PAL133_R04_0_Pos                                  0
#define LCD_PAL133_R04_0_Msk                                  (0x1fUL << LCD_PAL133_R04_0_Pos)
#define LCD_PAL133_G04_0_Pos                                  5
#define LCD_PAL133_G04_0_Msk                                  (0x1fUL << LCD_PAL133_G04_0_Pos)
#define LCD_PAL133_B04_0_Pos                                  10
#define LCD_PAL133_B04_0_Msk                                  (0x1fUL << LCD_PAL133_B04_0_Pos)
#define LCD_PAL133_I0_Pos                                     15
#define LCD_PAL133_I0_Msk                                     (0x01UL << LCD_PAL133_I0_Pos)
#define LCD_PAL133_R14_0_Pos                                  16
#define LCD_PAL133_R14_0_Msk                                  (0x1fUL << LCD_PAL133_R14_0_Pos)
#define LCD_PAL133_G14_0_Pos                                  21
#define LCD_PAL133_G14_0_Msk                                  (0x1fUL << LCD_PAL133_G14_0_Pos)
#define LCD_PAL133_B14_0_Pos                                  26
#define LCD_PAL133_B14_0_Msk                                  (0x1fUL << LCD_PAL133_B14_0_Pos)
#define LCD_PAL133_I1_Pos                                     31
#define LCD_PAL133_I1_Msk                                     (0x01UL << LCD_PAL133_I1_Pos)

// ---------------------------------------  LCD_PAL134  -------------------------------------------
#define LCD_PAL134_R04_0_Pos                                  0
#define LCD_PAL134_R04_0_Msk                                  (0x1fUL << LCD_PAL134_R04_0_Pos)
#define LCD_PAL134_G04_0_Pos                                  5
#define LCD_PAL134_G04_0_Msk                                  (0x1fUL << LCD_PAL134_G04_0_Pos)
#define LCD_PAL134_B04_0_Pos                                  10
#define LCD_PAL134_B04_0_Msk                                  (0x1fUL << LCD_PAL134_B04_0_Pos)
#define LCD_PAL134_I0_Pos                                     15
#define LCD_PAL134_I0_Msk                                     (0x01UL << LCD_PAL134_I0_Pos)
#define LCD_PAL134_R14_0_Pos                                  16
#define LCD_PAL134_R14_0_Msk                                  (0x1fUL << LCD_PAL134_R14_0_Pos)
#define LCD_PAL134_G14_0_Pos                                  21
#define LCD_PAL134_G14_0_Msk                                  (0x1fUL << LCD_PAL134_G14_0_Pos)
#define LCD_PAL134_B14_0_Pos                                  26
#define LCD_PAL134_B14_0_Msk                                  (0x1fUL << LCD_PAL134_B14_0_Pos)
#define LCD_PAL134_I1_Pos                                     31
#define LCD_PAL134_I1_Msk                                     (0x01UL << LCD_PAL134_I1_Pos)

// ---------------------------------------  LCD_PAL135  -------------------------------------------
#define LCD_PAL135_R04_0_Pos                                  0
#define LCD_PAL135_R04_0_Msk                                  (0x1fUL << LCD_PAL135_R04_0_Pos)
#define LCD_PAL135_G04_0_Pos                                  5
#define LCD_PAL135_G04_0_Msk                                  (0x1fUL << LCD_PAL135_G04_0_Pos)
#define LCD_PAL135_B04_0_Pos                                  10
#define LCD_PAL135_B04_0_Msk                                  (0x1fUL << LCD_PAL135_B04_0_Pos)
#define LCD_PAL135_I0_Pos                                     15
#define LCD_PAL135_I0_Msk                                     (0x01UL << LCD_PAL135_I0_Pos)
#define LCD_PAL135_R14_0_Pos                                  16
#define LCD_PAL135_R14_0_Msk                                  (0x1fUL << LCD_PAL135_R14_0_Pos)
#define LCD_PAL135_G14_0_Pos                                  21
#define LCD_PAL135_G14_0_Msk                                  (0x1fUL << LCD_PAL135_G14_0_Pos)
#define LCD_PAL135_B14_0_Pos                                  26
#define LCD_PAL135_B14_0_Msk                                  (0x1fUL << LCD_PAL135_B14_0_Pos)
#define LCD_PAL135_I1_Pos                                     31
#define LCD_PAL135_I1_Msk                                     (0x01UL << LCD_PAL135_I1_Pos)

// ---------------------------------------  LCD_PAL136  -------------------------------------------
#define LCD_PAL136_R04_0_Pos                                  0
#define LCD_PAL136_R04_0_Msk                                  (0x1fUL << LCD_PAL136_R04_0_Pos)
#define LCD_PAL136_G04_0_Pos                                  5
#define LCD_PAL136_G04_0_Msk                                  (0x1fUL << LCD_PAL136_G04_0_Pos)
#define LCD_PAL136_B04_0_Pos                                  10
#define LCD_PAL136_B04_0_Msk                                  (0x1fUL << LCD_PAL136_B04_0_Pos)
#define LCD_PAL136_I0_Pos                                     15
#define LCD_PAL136_I0_Msk                                     (0x01UL << LCD_PAL136_I0_Pos)
#define LCD_PAL136_R14_0_Pos                                  16
#define LCD_PAL136_R14_0_Msk                                  (0x1fUL << LCD_PAL136_R14_0_Pos)
#define LCD_PAL136_G14_0_Pos                                  21
#define LCD_PAL136_G14_0_Msk                                  (0x1fUL << LCD_PAL136_G14_0_Pos)
#define LCD_PAL136_B14_0_Pos                                  26
#define LCD_PAL136_B14_0_Msk                                  (0x1fUL << LCD_PAL136_B14_0_Pos)
#define LCD_PAL136_I1_Pos                                     31
#define LCD_PAL136_I1_Msk                                     (0x01UL << LCD_PAL136_I1_Pos)

// ---------------------------------------  LCD_PAL137  -------------------------------------------
#define LCD_PAL137_R04_0_Pos                                  0
#define LCD_PAL137_R04_0_Msk                                  (0x1fUL << LCD_PAL137_R04_0_Pos)
#define LCD_PAL137_G04_0_Pos                                  5
#define LCD_PAL137_G04_0_Msk                                  (0x1fUL << LCD_PAL137_G04_0_Pos)
#define LCD_PAL137_B04_0_Pos                                  10
#define LCD_PAL137_B04_0_Msk                                  (0x1fUL << LCD_PAL137_B04_0_Pos)
#define LCD_PAL137_I0_Pos                                     15
#define LCD_PAL137_I0_Msk                                     (0x01UL << LCD_PAL137_I0_Pos)
#define LCD_PAL137_R14_0_Pos                                  16
#define LCD_PAL137_R14_0_Msk                                  (0x1fUL << LCD_PAL137_R14_0_Pos)
#define LCD_PAL137_G14_0_Pos                                  21
#define LCD_PAL137_G14_0_Msk                                  (0x1fUL << LCD_PAL137_G14_0_Pos)
#define LCD_PAL137_B14_0_Pos                                  26
#define LCD_PAL137_B14_0_Msk                                  (0x1fUL << LCD_PAL137_B14_0_Pos)
#define LCD_PAL137_I1_Pos                                     31
#define LCD_PAL137_I1_Msk                                     (0x01UL << LCD_PAL137_I1_Pos)

// ---------------------------------------  LCD_PAL138  -------------------------------------------
#define LCD_PAL138_R04_0_Pos                                  0
#define LCD_PAL138_R04_0_Msk                                  (0x1fUL << LCD_PAL138_R04_0_Pos)
#define LCD_PAL138_G04_0_Pos                                  5
#define LCD_PAL138_G04_0_Msk                                  (0x1fUL << LCD_PAL138_G04_0_Pos)
#define LCD_PAL138_B04_0_Pos                                  10
#define LCD_PAL138_B04_0_Msk                                  (0x1fUL << LCD_PAL138_B04_0_Pos)
#define LCD_PAL138_I0_Pos                                     15
#define LCD_PAL138_I0_Msk                                     (0x01UL << LCD_PAL138_I0_Pos)
#define LCD_PAL138_R14_0_Pos                                  16
#define LCD_PAL138_R14_0_Msk                                  (0x1fUL << LCD_PAL138_R14_0_Pos)
#define LCD_PAL138_G14_0_Pos                                  21
#define LCD_PAL138_G14_0_Msk                                  (0x1fUL << LCD_PAL138_G14_0_Pos)
#define LCD_PAL138_B14_0_Pos                                  26
#define LCD_PAL138_B14_0_Msk                                  (0x1fUL << LCD_PAL138_B14_0_Pos)
#define LCD_PAL138_I1_Pos                                     31
#define LCD_PAL138_I1_Msk                                     (0x01UL << LCD_PAL138_I1_Pos)

// ---------------------------------------  LCD_PAL139  -------------------------------------------
#define LCD_PAL139_R04_0_Pos                                  0
#define LCD_PAL139_R04_0_Msk                                  (0x1fUL << LCD_PAL139_R04_0_Pos)
#define LCD_PAL139_G04_0_Pos                                  5
#define LCD_PAL139_G04_0_Msk                                  (0x1fUL << LCD_PAL139_G04_0_Pos)
#define LCD_PAL139_B04_0_Pos                                  10
#define LCD_PAL139_B04_0_Msk                                  (0x1fUL << LCD_PAL139_B04_0_Pos)
#define LCD_PAL139_I0_Pos                                     15
#define LCD_PAL139_I0_Msk                                     (0x01UL << LCD_PAL139_I0_Pos)
#define LCD_PAL139_R14_0_Pos                                  16
#define LCD_PAL139_R14_0_Msk                                  (0x1fUL << LCD_PAL139_R14_0_Pos)
#define LCD_PAL139_G14_0_Pos                                  21
#define LCD_PAL139_G14_0_Msk                                  (0x1fUL << LCD_PAL139_G14_0_Pos)
#define LCD_PAL139_B14_0_Pos                                  26
#define LCD_PAL139_B14_0_Msk                                  (0x1fUL << LCD_PAL139_B14_0_Pos)
#define LCD_PAL139_I1_Pos                                     31
#define LCD_PAL139_I1_Msk                                     (0x01UL << LCD_PAL139_I1_Pos)

// ---------------------------------------  LCD_PAL140  -------------------------------------------
#define LCD_PAL140_R04_0_Pos                                  0
#define LCD_PAL140_R04_0_Msk                                  (0x1fUL << LCD_PAL140_R04_0_Pos)
#define LCD_PAL140_G04_0_Pos                                  5
#define LCD_PAL140_G04_0_Msk                                  (0x1fUL << LCD_PAL140_G04_0_Pos)
#define LCD_PAL140_B04_0_Pos                                  10
#define LCD_PAL140_B04_0_Msk                                  (0x1fUL << LCD_PAL140_B04_0_Pos)
#define LCD_PAL140_I0_Pos                                     15
#define LCD_PAL140_I0_Msk                                     (0x01UL << LCD_PAL140_I0_Pos)
#define LCD_PAL140_R14_0_Pos                                  16
#define LCD_PAL140_R14_0_Msk                                  (0x1fUL << LCD_PAL140_R14_0_Pos)
#define LCD_PAL140_G14_0_Pos                                  21
#define LCD_PAL140_G14_0_Msk                                  (0x1fUL << LCD_PAL140_G14_0_Pos)
#define LCD_PAL140_B14_0_Pos                                  26
#define LCD_PAL140_B14_0_Msk                                  (0x1fUL << LCD_PAL140_B14_0_Pos)
#define LCD_PAL140_I1_Pos                                     31
#define LCD_PAL140_I1_Msk                                     (0x01UL << LCD_PAL140_I1_Pos)

// ---------------------------------------  LCD_PAL141  -------------------------------------------
#define LCD_PAL141_R04_0_Pos                                  0
#define LCD_PAL141_R04_0_Msk                                  (0x1fUL << LCD_PAL141_R04_0_Pos)
#define LCD_PAL141_G04_0_Pos                                  5
#define LCD_PAL141_G04_0_Msk                                  (0x1fUL << LCD_PAL141_G04_0_Pos)
#define LCD_PAL141_B04_0_Pos                                  10
#define LCD_PAL141_B04_0_Msk                                  (0x1fUL << LCD_PAL141_B04_0_Pos)
#define LCD_PAL141_I0_Pos                                     15
#define LCD_PAL141_I0_Msk                                     (0x01UL << LCD_PAL141_I0_Pos)
#define LCD_PAL141_R14_0_Pos                                  16
#define LCD_PAL141_R14_0_Msk                                  (0x1fUL << LCD_PAL141_R14_0_Pos)
#define LCD_PAL141_G14_0_Pos                                  21
#define LCD_PAL141_G14_0_Msk                                  (0x1fUL << LCD_PAL141_G14_0_Pos)
#define LCD_PAL141_B14_0_Pos                                  26
#define LCD_PAL141_B14_0_Msk                                  (0x1fUL << LCD_PAL141_B14_0_Pos)
#define LCD_PAL141_I1_Pos                                     31
#define LCD_PAL141_I1_Msk                                     (0x01UL << LCD_PAL141_I1_Pos)

// ---------------------------------------  LCD_PAL142  -------------------------------------------
#define LCD_PAL142_R04_0_Pos                                  0
#define LCD_PAL142_R04_0_Msk                                  (0x1fUL << LCD_PAL142_R04_0_Pos)
#define LCD_PAL142_G04_0_Pos                                  5
#define LCD_PAL142_G04_0_Msk                                  (0x1fUL << LCD_PAL142_G04_0_Pos)
#define LCD_PAL142_B04_0_Pos                                  10
#define LCD_PAL142_B04_0_Msk                                  (0x1fUL << LCD_PAL142_B04_0_Pos)
#define LCD_PAL142_I0_Pos                                     15
#define LCD_PAL142_I0_Msk                                     (0x01UL << LCD_PAL142_I0_Pos)
#define LCD_PAL142_R14_0_Pos                                  16
#define LCD_PAL142_R14_0_Msk                                  (0x1fUL << LCD_PAL142_R14_0_Pos)
#define LCD_PAL142_G14_0_Pos                                  21
#define LCD_PAL142_G14_0_Msk                                  (0x1fUL << LCD_PAL142_G14_0_Pos)
#define LCD_PAL142_B14_0_Pos                                  26
#define LCD_PAL142_B14_0_Msk                                  (0x1fUL << LCD_PAL142_B14_0_Pos)
#define LCD_PAL142_I1_Pos                                     31
#define LCD_PAL142_I1_Msk                                     (0x01UL << LCD_PAL142_I1_Pos)

// ---------------------------------------  LCD_PAL143  -------------------------------------------
#define LCD_PAL143_R04_0_Pos                                  0
#define LCD_PAL143_R04_0_Msk                                  (0x1fUL << LCD_PAL143_R04_0_Pos)
#define LCD_PAL143_G04_0_Pos                                  5
#define LCD_PAL143_G04_0_Msk                                  (0x1fUL << LCD_PAL143_G04_0_Pos)
#define LCD_PAL143_B04_0_Pos                                  10
#define LCD_PAL143_B04_0_Msk                                  (0x1fUL << LCD_PAL143_B04_0_Pos)
#define LCD_PAL143_I0_Pos                                     15
#define LCD_PAL143_I0_Msk                                     (0x01UL << LCD_PAL143_I0_Pos)
#define LCD_PAL143_R14_0_Pos                                  16
#define LCD_PAL143_R14_0_Msk                                  (0x1fUL << LCD_PAL143_R14_0_Pos)
#define LCD_PAL143_G14_0_Pos                                  21
#define LCD_PAL143_G14_0_Msk                                  (0x1fUL << LCD_PAL143_G14_0_Pos)
#define LCD_PAL143_B14_0_Pos                                  26
#define LCD_PAL143_B14_0_Msk                                  (0x1fUL << LCD_PAL143_B14_0_Pos)
#define LCD_PAL143_I1_Pos                                     31
#define LCD_PAL143_I1_Msk                                     (0x01UL << LCD_PAL143_I1_Pos)

// ---------------------------------------  LCD_PAL144  -------------------------------------------
#define LCD_PAL144_R04_0_Pos                                  0
#define LCD_PAL144_R04_0_Msk                                  (0x1fUL << LCD_PAL144_R04_0_Pos)
#define LCD_PAL144_G04_0_Pos                                  5
#define LCD_PAL144_G04_0_Msk                                  (0x1fUL << LCD_PAL144_G04_0_Pos)
#define LCD_PAL144_B04_0_Pos                                  10
#define LCD_PAL144_B04_0_Msk                                  (0x1fUL << LCD_PAL144_B04_0_Pos)
#define LCD_PAL144_I0_Pos                                     15
#define LCD_PAL144_I0_Msk                                     (0x01UL << LCD_PAL144_I0_Pos)
#define LCD_PAL144_R14_0_Pos                                  16
#define LCD_PAL144_R14_0_Msk                                  (0x1fUL << LCD_PAL144_R14_0_Pos)
#define LCD_PAL144_G14_0_Pos                                  21
#define LCD_PAL144_G14_0_Msk                                  (0x1fUL << LCD_PAL144_G14_0_Pos)
#define LCD_PAL144_B14_0_Pos                                  26
#define LCD_PAL144_B14_0_Msk                                  (0x1fUL << LCD_PAL144_B14_0_Pos)
#define LCD_PAL144_I1_Pos                                     31
#define LCD_PAL144_I1_Msk                                     (0x01UL << LCD_PAL144_I1_Pos)

// ---------------------------------------  LCD_PAL145  -------------------------------------------
#define LCD_PAL145_R04_0_Pos                                  0
#define LCD_PAL145_R04_0_Msk                                  (0x1fUL << LCD_PAL145_R04_0_Pos)
#define LCD_PAL145_G04_0_Pos                                  5
#define LCD_PAL145_G04_0_Msk                                  (0x1fUL << LCD_PAL145_G04_0_Pos)
#define LCD_PAL145_B04_0_Pos                                  10
#define LCD_PAL145_B04_0_Msk                                  (0x1fUL << LCD_PAL145_B04_0_Pos)
#define LCD_PAL145_I0_Pos                                     15
#define LCD_PAL145_I0_Msk                                     (0x01UL << LCD_PAL145_I0_Pos)
#define LCD_PAL145_R14_0_Pos                                  16
#define LCD_PAL145_R14_0_Msk                                  (0x1fUL << LCD_PAL145_R14_0_Pos)
#define LCD_PAL145_G14_0_Pos                                  21
#define LCD_PAL145_G14_0_Msk                                  (0x1fUL << LCD_PAL145_G14_0_Pos)
#define LCD_PAL145_B14_0_Pos                                  26
#define LCD_PAL145_B14_0_Msk                                  (0x1fUL << LCD_PAL145_B14_0_Pos)
#define LCD_PAL145_I1_Pos                                     31
#define LCD_PAL145_I1_Msk                                     (0x01UL << LCD_PAL145_I1_Pos)

// ---------------------------------------  LCD_PAL146  -------------------------------------------
#define LCD_PAL146_R04_0_Pos                                  0
#define LCD_PAL146_R04_0_Msk                                  (0x1fUL << LCD_PAL146_R04_0_Pos)
#define LCD_PAL146_G04_0_Pos                                  5
#define LCD_PAL146_G04_0_Msk                                  (0x1fUL << LCD_PAL146_G04_0_Pos)
#define LCD_PAL146_B04_0_Pos                                  10
#define LCD_PAL146_B04_0_Msk                                  (0x1fUL << LCD_PAL146_B04_0_Pos)
#define LCD_PAL146_I0_Pos                                     15
#define LCD_PAL146_I0_Msk                                     (0x01UL << LCD_PAL146_I0_Pos)
#define LCD_PAL146_R14_0_Pos                                  16
#define LCD_PAL146_R14_0_Msk                                  (0x1fUL << LCD_PAL146_R14_0_Pos)
#define LCD_PAL146_G14_0_Pos                                  21
#define LCD_PAL146_G14_0_Msk                                  (0x1fUL << LCD_PAL146_G14_0_Pos)
#define LCD_PAL146_B14_0_Pos                                  26
#define LCD_PAL146_B14_0_Msk                                  (0x1fUL << LCD_PAL146_B14_0_Pos)
#define LCD_PAL146_I1_Pos                                     31
#define LCD_PAL146_I1_Msk                                     (0x01UL << LCD_PAL146_I1_Pos)

// ---------------------------------------  LCD_PAL147  -------------------------------------------
#define LCD_PAL147_R04_0_Pos                                  0
#define LCD_PAL147_R04_0_Msk                                  (0x1fUL << LCD_PAL147_R04_0_Pos)
#define LCD_PAL147_G04_0_Pos                                  5
#define LCD_PAL147_G04_0_Msk                                  (0x1fUL << LCD_PAL147_G04_0_Pos)
#define LCD_PAL147_B04_0_Pos                                  10
#define LCD_PAL147_B04_0_Msk                                  (0x1fUL << LCD_PAL147_B04_0_Pos)
#define LCD_PAL147_I0_Pos                                     15
#define LCD_PAL147_I0_Msk                                     (0x01UL << LCD_PAL147_I0_Pos)
#define LCD_PAL147_R14_0_Pos                                  16
#define LCD_PAL147_R14_0_Msk                                  (0x1fUL << LCD_PAL147_R14_0_Pos)
#define LCD_PAL147_G14_0_Pos                                  21
#define LCD_PAL147_G14_0_Msk                                  (0x1fUL << LCD_PAL147_G14_0_Pos)
#define LCD_PAL147_B14_0_Pos                                  26
#define LCD_PAL147_B14_0_Msk                                  (0x1fUL << LCD_PAL147_B14_0_Pos)
#define LCD_PAL147_I1_Pos                                     31
#define LCD_PAL147_I1_Msk                                     (0x01UL << LCD_PAL147_I1_Pos)

// ---------------------------------------  LCD_PAL148  -------------------------------------------
#define LCD_PAL148_R04_0_Pos                                  0
#define LCD_PAL148_R04_0_Msk                                  (0x1fUL << LCD_PAL148_R04_0_Pos)
#define LCD_PAL148_G04_0_Pos                                  5
#define LCD_PAL148_G04_0_Msk                                  (0x1fUL << LCD_PAL148_G04_0_Pos)
#define LCD_PAL148_B04_0_Pos                                  10
#define LCD_PAL148_B04_0_Msk                                  (0x1fUL << LCD_PAL148_B04_0_Pos)
#define LCD_PAL148_I0_Pos                                     15
#define LCD_PAL148_I0_Msk                                     (0x01UL << LCD_PAL148_I0_Pos)
#define LCD_PAL148_R14_0_Pos                                  16
#define LCD_PAL148_R14_0_Msk                                  (0x1fUL << LCD_PAL148_R14_0_Pos)
#define LCD_PAL148_G14_0_Pos                                  21
#define LCD_PAL148_G14_0_Msk                                  (0x1fUL << LCD_PAL148_G14_0_Pos)
#define LCD_PAL148_B14_0_Pos                                  26
#define LCD_PAL148_B14_0_Msk                                  (0x1fUL << LCD_PAL148_B14_0_Pos)
#define LCD_PAL148_I1_Pos                                     31
#define LCD_PAL148_I1_Msk                                     (0x01UL << LCD_PAL148_I1_Pos)

// ---------------------------------------  LCD_PAL149  -------------------------------------------
#define LCD_PAL149_R04_0_Pos                                  0
#define LCD_PAL149_R04_0_Msk                                  (0x1fUL << LCD_PAL149_R04_0_Pos)
#define LCD_PAL149_G04_0_Pos                                  5
#define LCD_PAL149_G04_0_Msk                                  (0x1fUL << LCD_PAL149_G04_0_Pos)
#define LCD_PAL149_B04_0_Pos                                  10
#define LCD_PAL149_B04_0_Msk                                  (0x1fUL << LCD_PAL149_B04_0_Pos)
#define LCD_PAL149_I0_Pos                                     15
#define LCD_PAL149_I0_Msk                                     (0x01UL << LCD_PAL149_I0_Pos)
#define LCD_PAL149_R14_0_Pos                                  16
#define LCD_PAL149_R14_0_Msk                                  (0x1fUL << LCD_PAL149_R14_0_Pos)
#define LCD_PAL149_G14_0_Pos                                  21
#define LCD_PAL149_G14_0_Msk                                  (0x1fUL << LCD_PAL149_G14_0_Pos)
#define LCD_PAL149_B14_0_Pos                                  26
#define LCD_PAL149_B14_0_Msk                                  (0x1fUL << LCD_PAL149_B14_0_Pos)
#define LCD_PAL149_I1_Pos                                     31
#define LCD_PAL149_I1_Msk                                     (0x01UL << LCD_PAL149_I1_Pos)

// ---------------------------------------  LCD_PAL150  -------------------------------------------
#define LCD_PAL150_R04_0_Pos                                  0
#define LCD_PAL150_R04_0_Msk                                  (0x1fUL << LCD_PAL150_R04_0_Pos)
#define LCD_PAL150_G04_0_Pos                                  5
#define LCD_PAL150_G04_0_Msk                                  (0x1fUL << LCD_PAL150_G04_0_Pos)
#define LCD_PAL150_B04_0_Pos                                  10
#define LCD_PAL150_B04_0_Msk                                  (0x1fUL << LCD_PAL150_B04_0_Pos)
#define LCD_PAL150_I0_Pos                                     15
#define LCD_PAL150_I0_Msk                                     (0x01UL << LCD_PAL150_I0_Pos)
#define LCD_PAL150_R14_0_Pos                                  16
#define LCD_PAL150_R14_0_Msk                                  (0x1fUL << LCD_PAL150_R14_0_Pos)
#define LCD_PAL150_G14_0_Pos                                  21
#define LCD_PAL150_G14_0_Msk                                  (0x1fUL << LCD_PAL150_G14_0_Pos)
#define LCD_PAL150_B14_0_Pos                                  26
#define LCD_PAL150_B14_0_Msk                                  (0x1fUL << LCD_PAL150_B14_0_Pos)
#define LCD_PAL150_I1_Pos                                     31
#define LCD_PAL150_I1_Msk                                     (0x01UL << LCD_PAL150_I1_Pos)

// ---------------------------------------  LCD_PAL151  -------------------------------------------
#define LCD_PAL151_R04_0_Pos                                  0
#define LCD_PAL151_R04_0_Msk                                  (0x1fUL << LCD_PAL151_R04_0_Pos)
#define LCD_PAL151_G04_0_Pos                                  5
#define LCD_PAL151_G04_0_Msk                                  (0x1fUL << LCD_PAL151_G04_0_Pos)
#define LCD_PAL151_B04_0_Pos                                  10
#define LCD_PAL151_B04_0_Msk                                  (0x1fUL << LCD_PAL151_B04_0_Pos)
#define LCD_PAL151_I0_Pos                                     15
#define LCD_PAL151_I0_Msk                                     (0x01UL << LCD_PAL151_I0_Pos)
#define LCD_PAL151_R14_0_Pos                                  16
#define LCD_PAL151_R14_0_Msk                                  (0x1fUL << LCD_PAL151_R14_0_Pos)
#define LCD_PAL151_G14_0_Pos                                  21
#define LCD_PAL151_G14_0_Msk                                  (0x1fUL << LCD_PAL151_G14_0_Pos)
#define LCD_PAL151_B14_0_Pos                                  26
#define LCD_PAL151_B14_0_Msk                                  (0x1fUL << LCD_PAL151_B14_0_Pos)
#define LCD_PAL151_I1_Pos                                     31
#define LCD_PAL151_I1_Msk                                     (0x01UL << LCD_PAL151_I1_Pos)

// ---------------------------------------  LCD_PAL152  -------------------------------------------
#define LCD_PAL152_R04_0_Pos                                  0
#define LCD_PAL152_R04_0_Msk                                  (0x1fUL << LCD_PAL152_R04_0_Pos)
#define LCD_PAL152_G04_0_Pos                                  5
#define LCD_PAL152_G04_0_Msk                                  (0x1fUL << LCD_PAL152_G04_0_Pos)
#define LCD_PAL152_B04_0_Pos                                  10
#define LCD_PAL152_B04_0_Msk                                  (0x1fUL << LCD_PAL152_B04_0_Pos)
#define LCD_PAL152_I0_Pos                                     15
#define LCD_PAL152_I0_Msk                                     (0x01UL << LCD_PAL152_I0_Pos)
#define LCD_PAL152_R14_0_Pos                                  16
#define LCD_PAL152_R14_0_Msk                                  (0x1fUL << LCD_PAL152_R14_0_Pos)
#define LCD_PAL152_G14_0_Pos                                  21
#define LCD_PAL152_G14_0_Msk                                  (0x1fUL << LCD_PAL152_G14_0_Pos)
#define LCD_PAL152_B14_0_Pos                                  26
#define LCD_PAL152_B14_0_Msk                                  (0x1fUL << LCD_PAL152_B14_0_Pos)
#define LCD_PAL152_I1_Pos                                     31
#define LCD_PAL152_I1_Msk                                     (0x01UL << LCD_PAL152_I1_Pos)

// ---------------------------------------  LCD_PAL153  -------------------------------------------
#define LCD_PAL153_R04_0_Pos                                  0
#define LCD_PAL153_R04_0_Msk                                  (0x1fUL << LCD_PAL153_R04_0_Pos)
#define LCD_PAL153_G04_0_Pos                                  5
#define LCD_PAL153_G04_0_Msk                                  (0x1fUL << LCD_PAL153_G04_0_Pos)
#define LCD_PAL153_B04_0_Pos                                  10
#define LCD_PAL153_B04_0_Msk                                  (0x1fUL << LCD_PAL153_B04_0_Pos)
#define LCD_PAL153_I0_Pos                                     15
#define LCD_PAL153_I0_Msk                                     (0x01UL << LCD_PAL153_I0_Pos)
#define LCD_PAL153_R14_0_Pos                                  16
#define LCD_PAL153_R14_0_Msk                                  (0x1fUL << LCD_PAL153_R14_0_Pos)
#define LCD_PAL153_G14_0_Pos                                  21
#define LCD_PAL153_G14_0_Msk                                  (0x1fUL << LCD_PAL153_G14_0_Pos)
#define LCD_PAL153_B14_0_Pos                                  26
#define LCD_PAL153_B14_0_Msk                                  (0x1fUL << LCD_PAL153_B14_0_Pos)
#define LCD_PAL153_I1_Pos                                     31
#define LCD_PAL153_I1_Msk                                     (0x01UL << LCD_PAL153_I1_Pos)

// ---------------------------------------  LCD_PAL154  -------------------------------------------
#define LCD_PAL154_R04_0_Pos                                  0
#define LCD_PAL154_R04_0_Msk                                  (0x1fUL << LCD_PAL154_R04_0_Pos)
#define LCD_PAL154_G04_0_Pos                                  5
#define LCD_PAL154_G04_0_Msk                                  (0x1fUL << LCD_PAL154_G04_0_Pos)
#define LCD_PAL154_B04_0_Pos                                  10
#define LCD_PAL154_B04_0_Msk                                  (0x1fUL << LCD_PAL154_B04_0_Pos)
#define LCD_PAL154_I0_Pos                                     15
#define LCD_PAL154_I0_Msk                                     (0x01UL << LCD_PAL154_I0_Pos)
#define LCD_PAL154_R14_0_Pos                                  16
#define LCD_PAL154_R14_0_Msk                                  (0x1fUL << LCD_PAL154_R14_0_Pos)
#define LCD_PAL154_G14_0_Pos                                  21
#define LCD_PAL154_G14_0_Msk                                  (0x1fUL << LCD_PAL154_G14_0_Pos)
#define LCD_PAL154_B14_0_Pos                                  26
#define LCD_PAL154_B14_0_Msk                                  (0x1fUL << LCD_PAL154_B14_0_Pos)
#define LCD_PAL154_I1_Pos                                     31
#define LCD_PAL154_I1_Msk                                     (0x01UL << LCD_PAL154_I1_Pos)

// ---------------------------------------  LCD_PAL155  -------------------------------------------
#define LCD_PAL155_R04_0_Pos                                  0
#define LCD_PAL155_R04_0_Msk                                  (0x1fUL << LCD_PAL155_R04_0_Pos)
#define LCD_PAL155_G04_0_Pos                                  5
#define LCD_PAL155_G04_0_Msk                                  (0x1fUL << LCD_PAL155_G04_0_Pos)
#define LCD_PAL155_B04_0_Pos                                  10
#define LCD_PAL155_B04_0_Msk                                  (0x1fUL << LCD_PAL155_B04_0_Pos)
#define LCD_PAL155_I0_Pos                                     15
#define LCD_PAL155_I0_Msk                                     (0x01UL << LCD_PAL155_I0_Pos)
#define LCD_PAL155_R14_0_Pos                                  16
#define LCD_PAL155_R14_0_Msk                                  (0x1fUL << LCD_PAL155_R14_0_Pos)
#define LCD_PAL155_G14_0_Pos                                  21
#define LCD_PAL155_G14_0_Msk                                  (0x1fUL << LCD_PAL155_G14_0_Pos)
#define LCD_PAL155_B14_0_Pos                                  26
#define LCD_PAL155_B14_0_Msk                                  (0x1fUL << LCD_PAL155_B14_0_Pos)
#define LCD_PAL155_I1_Pos                                     31
#define LCD_PAL155_I1_Msk                                     (0x01UL << LCD_PAL155_I1_Pos)

// ---------------------------------------  LCD_PAL156  -------------------------------------------
#define LCD_PAL156_R04_0_Pos                                  0
#define LCD_PAL156_R04_0_Msk                                  (0x1fUL << LCD_PAL156_R04_0_Pos)
#define LCD_PAL156_G04_0_Pos                                  5
#define LCD_PAL156_G04_0_Msk                                  (0x1fUL << LCD_PAL156_G04_0_Pos)
#define LCD_PAL156_B04_0_Pos                                  10
#define LCD_PAL156_B04_0_Msk                                  (0x1fUL << LCD_PAL156_B04_0_Pos)
#define LCD_PAL156_I0_Pos                                     15
#define LCD_PAL156_I0_Msk                                     (0x01UL << LCD_PAL156_I0_Pos)
#define LCD_PAL156_R14_0_Pos                                  16
#define LCD_PAL156_R14_0_Msk                                  (0x1fUL << LCD_PAL156_R14_0_Pos)
#define LCD_PAL156_G14_0_Pos                                  21
#define LCD_PAL156_G14_0_Msk                                  (0x1fUL << LCD_PAL156_G14_0_Pos)
#define LCD_PAL156_B14_0_Pos                                  26
#define LCD_PAL156_B14_0_Msk                                  (0x1fUL << LCD_PAL156_B14_0_Pos)
#define LCD_PAL156_I1_Pos                                     31
#define LCD_PAL156_I1_Msk                                     (0x01UL << LCD_PAL156_I1_Pos)

// ---------------------------------------  LCD_PAL157  -------------------------------------------
#define LCD_PAL157_R04_0_Pos                                  0
#define LCD_PAL157_R04_0_Msk                                  (0x1fUL << LCD_PAL157_R04_0_Pos)
#define LCD_PAL157_G04_0_Pos                                  5
#define LCD_PAL157_G04_0_Msk                                  (0x1fUL << LCD_PAL157_G04_0_Pos)
#define LCD_PAL157_B04_0_Pos                                  10
#define LCD_PAL157_B04_0_Msk                                  (0x1fUL << LCD_PAL157_B04_0_Pos)
#define LCD_PAL157_I0_Pos                                     15
#define LCD_PAL157_I0_Msk                                     (0x01UL << LCD_PAL157_I0_Pos)
#define LCD_PAL157_R14_0_Pos                                  16
#define LCD_PAL157_R14_0_Msk                                  (0x1fUL << LCD_PAL157_R14_0_Pos)
#define LCD_PAL157_G14_0_Pos                                  21
#define LCD_PAL157_G14_0_Msk                                  (0x1fUL << LCD_PAL157_G14_0_Pos)
#define LCD_PAL157_B14_0_Pos                                  26
#define LCD_PAL157_B14_0_Msk                                  (0x1fUL << LCD_PAL157_B14_0_Pos)
#define LCD_PAL157_I1_Pos                                     31
#define LCD_PAL157_I1_Msk                                     (0x01UL << LCD_PAL157_I1_Pos)

// ---------------------------------------  LCD_PAL158  -------------------------------------------
#define LCD_PAL158_R04_0_Pos                                  0
#define LCD_PAL158_R04_0_Msk                                  (0x1fUL << LCD_PAL158_R04_0_Pos)
#define LCD_PAL158_G04_0_Pos                                  5
#define LCD_PAL158_G04_0_Msk                                  (0x1fUL << LCD_PAL158_G04_0_Pos)
#define LCD_PAL158_B04_0_Pos                                  10
#define LCD_PAL158_B04_0_Msk                                  (0x1fUL << LCD_PAL158_B04_0_Pos)
#define LCD_PAL158_I0_Pos                                     15
#define LCD_PAL158_I0_Msk                                     (0x01UL << LCD_PAL158_I0_Pos)
#define LCD_PAL158_R14_0_Pos                                  16
#define LCD_PAL158_R14_0_Msk                                  (0x1fUL << LCD_PAL158_R14_0_Pos)
#define LCD_PAL158_G14_0_Pos                                  21
#define LCD_PAL158_G14_0_Msk                                  (0x1fUL << LCD_PAL158_G14_0_Pos)
#define LCD_PAL158_B14_0_Pos                                  26
#define LCD_PAL158_B14_0_Msk                                  (0x1fUL << LCD_PAL158_B14_0_Pos)
#define LCD_PAL158_I1_Pos                                     31
#define LCD_PAL158_I1_Msk                                     (0x01UL << LCD_PAL158_I1_Pos)

// ---------------------------------------  LCD_PAL159  -------------------------------------------
#define LCD_PAL159_R04_0_Pos                                  0
#define LCD_PAL159_R04_0_Msk                                  (0x1fUL << LCD_PAL159_R04_0_Pos)
#define LCD_PAL159_G04_0_Pos                                  5
#define LCD_PAL159_G04_0_Msk                                  (0x1fUL << LCD_PAL159_G04_0_Pos)
#define LCD_PAL159_B04_0_Pos                                  10
#define LCD_PAL159_B04_0_Msk                                  (0x1fUL << LCD_PAL159_B04_0_Pos)
#define LCD_PAL159_I0_Pos                                     15
#define LCD_PAL159_I0_Msk                                     (0x01UL << LCD_PAL159_I0_Pos)
#define LCD_PAL159_R14_0_Pos                                  16
#define LCD_PAL159_R14_0_Msk                                  (0x1fUL << LCD_PAL159_R14_0_Pos)
#define LCD_PAL159_G14_0_Pos                                  21
#define LCD_PAL159_G14_0_Msk                                  (0x1fUL << LCD_PAL159_G14_0_Pos)
#define LCD_PAL159_B14_0_Pos                                  26
#define LCD_PAL159_B14_0_Msk                                  (0x1fUL << LCD_PAL159_B14_0_Pos)
#define LCD_PAL159_I1_Pos                                     31
#define LCD_PAL159_I1_Msk                                     (0x01UL << LCD_PAL159_I1_Pos)

// ---------------------------------------  LCD_PAL160  -------------------------------------------
#define LCD_PAL160_R04_0_Pos                                  0
#define LCD_PAL160_R04_0_Msk                                  (0x1fUL << LCD_PAL160_R04_0_Pos)
#define LCD_PAL160_G04_0_Pos                                  5
#define LCD_PAL160_G04_0_Msk                                  (0x1fUL << LCD_PAL160_G04_0_Pos)
#define LCD_PAL160_B04_0_Pos                                  10
#define LCD_PAL160_B04_0_Msk                                  (0x1fUL << LCD_PAL160_B04_0_Pos)
#define LCD_PAL160_I0_Pos                                     15
#define LCD_PAL160_I0_Msk                                     (0x01UL << LCD_PAL160_I0_Pos)
#define LCD_PAL160_R14_0_Pos                                  16
#define LCD_PAL160_R14_0_Msk                                  (0x1fUL << LCD_PAL160_R14_0_Pos)
#define LCD_PAL160_G14_0_Pos                                  21
#define LCD_PAL160_G14_0_Msk                                  (0x1fUL << LCD_PAL160_G14_0_Pos)
#define LCD_PAL160_B14_0_Pos                                  26
#define LCD_PAL160_B14_0_Msk                                  (0x1fUL << LCD_PAL160_B14_0_Pos)
#define LCD_PAL160_I1_Pos                                     31
#define LCD_PAL160_I1_Msk                                     (0x01UL << LCD_PAL160_I1_Pos)

// ---------------------------------------  LCD_PAL161  -------------------------------------------
#define LCD_PAL161_R04_0_Pos                                  0
#define LCD_PAL161_R04_0_Msk                                  (0x1fUL << LCD_PAL161_R04_0_Pos)
#define LCD_PAL161_G04_0_Pos                                  5
#define LCD_PAL161_G04_0_Msk                                  (0x1fUL << LCD_PAL161_G04_0_Pos)
#define LCD_PAL161_B04_0_Pos                                  10
#define LCD_PAL161_B04_0_Msk                                  (0x1fUL << LCD_PAL161_B04_0_Pos)
#define LCD_PAL161_I0_Pos                                     15
#define LCD_PAL161_I0_Msk                                     (0x01UL << LCD_PAL161_I0_Pos)
#define LCD_PAL161_R14_0_Pos                                  16
#define LCD_PAL161_R14_0_Msk                                  (0x1fUL << LCD_PAL161_R14_0_Pos)
#define LCD_PAL161_G14_0_Pos                                  21
#define LCD_PAL161_G14_0_Msk                                  (0x1fUL << LCD_PAL161_G14_0_Pos)
#define LCD_PAL161_B14_0_Pos                                  26
#define LCD_PAL161_B14_0_Msk                                  (0x1fUL << LCD_PAL161_B14_0_Pos)
#define LCD_PAL161_I1_Pos                                     31
#define LCD_PAL161_I1_Msk                                     (0x01UL << LCD_PAL161_I1_Pos)

// ---------------------------------------  LCD_PAL162  -------------------------------------------
#define LCD_PAL162_R04_0_Pos                                  0
#define LCD_PAL162_R04_0_Msk                                  (0x1fUL << LCD_PAL162_R04_0_Pos)
#define LCD_PAL162_G04_0_Pos                                  5
#define LCD_PAL162_G04_0_Msk                                  (0x1fUL << LCD_PAL162_G04_0_Pos)
#define LCD_PAL162_B04_0_Pos                                  10
#define LCD_PAL162_B04_0_Msk                                  (0x1fUL << LCD_PAL162_B04_0_Pos)
#define LCD_PAL162_I0_Pos                                     15
#define LCD_PAL162_I0_Msk                                     (0x01UL << LCD_PAL162_I0_Pos)
#define LCD_PAL162_R14_0_Pos                                  16
#define LCD_PAL162_R14_0_Msk                                  (0x1fUL << LCD_PAL162_R14_0_Pos)
#define LCD_PAL162_G14_0_Pos                                  21
#define LCD_PAL162_G14_0_Msk                                  (0x1fUL << LCD_PAL162_G14_0_Pos)
#define LCD_PAL162_B14_0_Pos                                  26
#define LCD_PAL162_B14_0_Msk                                  (0x1fUL << LCD_PAL162_B14_0_Pos)
#define LCD_PAL162_I1_Pos                                     31
#define LCD_PAL162_I1_Msk                                     (0x01UL << LCD_PAL162_I1_Pos)

// ---------------------------------------  LCD_PAL163  -------------------------------------------
#define LCD_PAL163_R04_0_Pos                                  0
#define LCD_PAL163_R04_0_Msk                                  (0x1fUL << LCD_PAL163_R04_0_Pos)
#define LCD_PAL163_G04_0_Pos                                  5
#define LCD_PAL163_G04_0_Msk                                  (0x1fUL << LCD_PAL163_G04_0_Pos)
#define LCD_PAL163_B04_0_Pos                                  10
#define LCD_PAL163_B04_0_Msk                                  (0x1fUL << LCD_PAL163_B04_0_Pos)
#define LCD_PAL163_I0_Pos                                     15
#define LCD_PAL163_I0_Msk                                     (0x01UL << LCD_PAL163_I0_Pos)
#define LCD_PAL163_R14_0_Pos                                  16
#define LCD_PAL163_R14_0_Msk                                  (0x1fUL << LCD_PAL163_R14_0_Pos)
#define LCD_PAL163_G14_0_Pos                                  21
#define LCD_PAL163_G14_0_Msk                                  (0x1fUL << LCD_PAL163_G14_0_Pos)
#define LCD_PAL163_B14_0_Pos                                  26
#define LCD_PAL163_B14_0_Msk                                  (0x1fUL << LCD_PAL163_B14_0_Pos)
#define LCD_PAL163_I1_Pos                                     31
#define LCD_PAL163_I1_Msk                                     (0x01UL << LCD_PAL163_I1_Pos)

// ---------------------------------------  LCD_PAL164  -------------------------------------------
#define LCD_PAL164_R04_0_Pos                                  0
#define LCD_PAL164_R04_0_Msk                                  (0x1fUL << LCD_PAL164_R04_0_Pos)
#define LCD_PAL164_G04_0_Pos                                  5
#define LCD_PAL164_G04_0_Msk                                  (0x1fUL << LCD_PAL164_G04_0_Pos)
#define LCD_PAL164_B04_0_Pos                                  10
#define LCD_PAL164_B04_0_Msk                                  (0x1fUL << LCD_PAL164_B04_0_Pos)
#define LCD_PAL164_I0_Pos                                     15
#define LCD_PAL164_I0_Msk                                     (0x01UL << LCD_PAL164_I0_Pos)
#define LCD_PAL164_R14_0_Pos                                  16
#define LCD_PAL164_R14_0_Msk                                  (0x1fUL << LCD_PAL164_R14_0_Pos)
#define LCD_PAL164_G14_0_Pos                                  21
#define LCD_PAL164_G14_0_Msk                                  (0x1fUL << LCD_PAL164_G14_0_Pos)
#define LCD_PAL164_B14_0_Pos                                  26
#define LCD_PAL164_B14_0_Msk                                  (0x1fUL << LCD_PAL164_B14_0_Pos)
#define LCD_PAL164_I1_Pos                                     31
#define LCD_PAL164_I1_Msk                                     (0x01UL << LCD_PAL164_I1_Pos)

// ---------------------------------------  LCD_PAL165  -------------------------------------------
#define LCD_PAL165_R04_0_Pos                                  0
#define LCD_PAL165_R04_0_Msk                                  (0x1fUL << LCD_PAL165_R04_0_Pos)
#define LCD_PAL165_G04_0_Pos                                  5
#define LCD_PAL165_G04_0_Msk                                  (0x1fUL << LCD_PAL165_G04_0_Pos)
#define LCD_PAL165_B04_0_Pos                                  10
#define LCD_PAL165_B04_0_Msk                                  (0x1fUL << LCD_PAL165_B04_0_Pos)
#define LCD_PAL165_I0_Pos                                     15
#define LCD_PAL165_I0_Msk                                     (0x01UL << LCD_PAL165_I0_Pos)
#define LCD_PAL165_R14_0_Pos                                  16
#define LCD_PAL165_R14_0_Msk                                  (0x1fUL << LCD_PAL165_R14_0_Pos)
#define LCD_PAL165_G14_0_Pos                                  21
#define LCD_PAL165_G14_0_Msk                                  (0x1fUL << LCD_PAL165_G14_0_Pos)
#define LCD_PAL165_B14_0_Pos                                  26
#define LCD_PAL165_B14_0_Msk                                  (0x1fUL << LCD_PAL165_B14_0_Pos)
#define LCD_PAL165_I1_Pos                                     31
#define LCD_PAL165_I1_Msk                                     (0x01UL << LCD_PAL165_I1_Pos)

// ---------------------------------------  LCD_PAL166  -------------------------------------------
#define LCD_PAL166_R04_0_Pos                                  0
#define LCD_PAL166_R04_0_Msk                                  (0x1fUL << LCD_PAL166_R04_0_Pos)
#define LCD_PAL166_G04_0_Pos                                  5
#define LCD_PAL166_G04_0_Msk                                  (0x1fUL << LCD_PAL166_G04_0_Pos)
#define LCD_PAL166_B04_0_Pos                                  10
#define LCD_PAL166_B04_0_Msk                                  (0x1fUL << LCD_PAL166_B04_0_Pos)
#define LCD_PAL166_I0_Pos                                     15
#define LCD_PAL166_I0_Msk                                     (0x01UL << LCD_PAL166_I0_Pos)
#define LCD_PAL166_R14_0_Pos                                  16
#define LCD_PAL166_R14_0_Msk                                  (0x1fUL << LCD_PAL166_R14_0_Pos)
#define LCD_PAL166_G14_0_Pos                                  21
#define LCD_PAL166_G14_0_Msk                                  (0x1fUL << LCD_PAL166_G14_0_Pos)
#define LCD_PAL166_B14_0_Pos                                  26
#define LCD_PAL166_B14_0_Msk                                  (0x1fUL << LCD_PAL166_B14_0_Pos)
#define LCD_PAL166_I1_Pos                                     31
#define LCD_PAL166_I1_Msk                                     (0x01UL << LCD_PAL166_I1_Pos)

// ---------------------------------------  LCD_PAL167  -------------------------------------------
#define LCD_PAL167_R04_0_Pos                                  0
#define LCD_PAL167_R04_0_Msk                                  (0x1fUL << LCD_PAL167_R04_0_Pos)
#define LCD_PAL167_G04_0_Pos                                  5
#define LCD_PAL167_G04_0_Msk                                  (0x1fUL << LCD_PAL167_G04_0_Pos)
#define LCD_PAL167_B04_0_Pos                                  10
#define LCD_PAL167_B04_0_Msk                                  (0x1fUL << LCD_PAL167_B04_0_Pos)
#define LCD_PAL167_I0_Pos                                     15
#define LCD_PAL167_I0_Msk                                     (0x01UL << LCD_PAL167_I0_Pos)
#define LCD_PAL167_R14_0_Pos                                  16
#define LCD_PAL167_R14_0_Msk                                  (0x1fUL << LCD_PAL167_R14_0_Pos)
#define LCD_PAL167_G14_0_Pos                                  21
#define LCD_PAL167_G14_0_Msk                                  (0x1fUL << LCD_PAL167_G14_0_Pos)
#define LCD_PAL167_B14_0_Pos                                  26
#define LCD_PAL167_B14_0_Msk                                  (0x1fUL << LCD_PAL167_B14_0_Pos)
#define LCD_PAL167_I1_Pos                                     31
#define LCD_PAL167_I1_Msk                                     (0x01UL << LCD_PAL167_I1_Pos)

// ---------------------------------------  LCD_PAL168  -------------------------------------------
#define LCD_PAL168_R04_0_Pos                                  0
#define LCD_PAL168_R04_0_Msk                                  (0x1fUL << LCD_PAL168_R04_0_Pos)
#define LCD_PAL168_G04_0_Pos                                  5
#define LCD_PAL168_G04_0_Msk                                  (0x1fUL << LCD_PAL168_G04_0_Pos)
#define LCD_PAL168_B04_0_Pos                                  10
#define LCD_PAL168_B04_0_Msk                                  (0x1fUL << LCD_PAL168_B04_0_Pos)
#define LCD_PAL168_I0_Pos                                     15
#define LCD_PAL168_I0_Msk                                     (0x01UL << LCD_PAL168_I0_Pos)
#define LCD_PAL168_R14_0_Pos                                  16
#define LCD_PAL168_R14_0_Msk                                  (0x1fUL << LCD_PAL168_R14_0_Pos)
#define LCD_PAL168_G14_0_Pos                                  21
#define LCD_PAL168_G14_0_Msk                                  (0x1fUL << LCD_PAL168_G14_0_Pos)
#define LCD_PAL168_B14_0_Pos                                  26
#define LCD_PAL168_B14_0_Msk                                  (0x1fUL << LCD_PAL168_B14_0_Pos)
#define LCD_PAL168_I1_Pos                                     31
#define LCD_PAL168_I1_Msk                                     (0x01UL << LCD_PAL168_I1_Pos)

// ---------------------------------------  LCD_PAL169  -------------------------------------------
#define LCD_PAL169_R04_0_Pos                                  0
#define LCD_PAL169_R04_0_Msk                                  (0x1fUL << LCD_PAL169_R04_0_Pos)
#define LCD_PAL169_G04_0_Pos                                  5
#define LCD_PAL169_G04_0_Msk                                  (0x1fUL << LCD_PAL169_G04_0_Pos)
#define LCD_PAL169_B04_0_Pos                                  10
#define LCD_PAL169_B04_0_Msk                                  (0x1fUL << LCD_PAL169_B04_0_Pos)
#define LCD_PAL169_I0_Pos                                     15
#define LCD_PAL169_I0_Msk                                     (0x01UL << LCD_PAL169_I0_Pos)
#define LCD_PAL169_R14_0_Pos                                  16
#define LCD_PAL169_R14_0_Msk                                  (0x1fUL << LCD_PAL169_R14_0_Pos)
#define LCD_PAL169_G14_0_Pos                                  21
#define LCD_PAL169_G14_0_Msk                                  (0x1fUL << LCD_PAL169_G14_0_Pos)
#define LCD_PAL169_B14_0_Pos                                  26
#define LCD_PAL169_B14_0_Msk                                  (0x1fUL << LCD_PAL169_B14_0_Pos)
#define LCD_PAL169_I1_Pos                                     31
#define LCD_PAL169_I1_Msk                                     (0x01UL << LCD_PAL169_I1_Pos)

// ---------------------------------------  LCD_PAL170  -------------------------------------------
#define LCD_PAL170_R04_0_Pos                                  0
#define LCD_PAL170_R04_0_Msk                                  (0x1fUL << LCD_PAL170_R04_0_Pos)
#define LCD_PAL170_G04_0_Pos                                  5
#define LCD_PAL170_G04_0_Msk                                  (0x1fUL << LCD_PAL170_G04_0_Pos)
#define LCD_PAL170_B04_0_Pos                                  10
#define LCD_PAL170_B04_0_Msk                                  (0x1fUL << LCD_PAL170_B04_0_Pos)
#define LCD_PAL170_I0_Pos                                     15
#define LCD_PAL170_I0_Msk                                     (0x01UL << LCD_PAL170_I0_Pos)
#define LCD_PAL170_R14_0_Pos                                  16
#define LCD_PAL170_R14_0_Msk                                  (0x1fUL << LCD_PAL170_R14_0_Pos)
#define LCD_PAL170_G14_0_Pos                                  21
#define LCD_PAL170_G14_0_Msk                                  (0x1fUL << LCD_PAL170_G14_0_Pos)
#define LCD_PAL170_B14_0_Pos                                  26
#define LCD_PAL170_B14_0_Msk                                  (0x1fUL << LCD_PAL170_B14_0_Pos)
#define LCD_PAL170_I1_Pos                                     31
#define LCD_PAL170_I1_Msk                                     (0x01UL << LCD_PAL170_I1_Pos)

// ---------------------------------------  LCD_PAL171  -------------------------------------------
#define LCD_PAL171_R04_0_Pos                                  0
#define LCD_PAL171_R04_0_Msk                                  (0x1fUL << LCD_PAL171_R04_0_Pos)
#define LCD_PAL171_G04_0_Pos                                  5
#define LCD_PAL171_G04_0_Msk                                  (0x1fUL << LCD_PAL171_G04_0_Pos)
#define LCD_PAL171_B04_0_Pos                                  10
#define LCD_PAL171_B04_0_Msk                                  (0x1fUL << LCD_PAL171_B04_0_Pos)
#define LCD_PAL171_I0_Pos                                     15
#define LCD_PAL171_I0_Msk                                     (0x01UL << LCD_PAL171_I0_Pos)
#define LCD_PAL171_R14_0_Pos                                  16
#define LCD_PAL171_R14_0_Msk                                  (0x1fUL << LCD_PAL171_R14_0_Pos)
#define LCD_PAL171_G14_0_Pos                                  21
#define LCD_PAL171_G14_0_Msk                                  (0x1fUL << LCD_PAL171_G14_0_Pos)
#define LCD_PAL171_B14_0_Pos                                  26
#define LCD_PAL171_B14_0_Msk                                  (0x1fUL << LCD_PAL171_B14_0_Pos)
#define LCD_PAL171_I1_Pos                                     31
#define LCD_PAL171_I1_Msk                                     (0x01UL << LCD_PAL171_I1_Pos)

// ---------------------------------------  LCD_PAL172  -------------------------------------------
#define LCD_PAL172_R04_0_Pos                                  0
#define LCD_PAL172_R04_0_Msk                                  (0x1fUL << LCD_PAL172_R04_0_Pos)
#define LCD_PAL172_G04_0_Pos                                  5
#define LCD_PAL172_G04_0_Msk                                  (0x1fUL << LCD_PAL172_G04_0_Pos)
#define LCD_PAL172_B04_0_Pos                                  10
#define LCD_PAL172_B04_0_Msk                                  (0x1fUL << LCD_PAL172_B04_0_Pos)
#define LCD_PAL172_I0_Pos                                     15
#define LCD_PAL172_I0_Msk                                     (0x01UL << LCD_PAL172_I0_Pos)
#define LCD_PAL172_R14_0_Pos                                  16
#define LCD_PAL172_R14_0_Msk                                  (0x1fUL << LCD_PAL172_R14_0_Pos)
#define LCD_PAL172_G14_0_Pos                                  21
#define LCD_PAL172_G14_0_Msk                                  (0x1fUL << LCD_PAL172_G14_0_Pos)
#define LCD_PAL172_B14_0_Pos                                  26
#define LCD_PAL172_B14_0_Msk                                  (0x1fUL << LCD_PAL172_B14_0_Pos)
#define LCD_PAL172_I1_Pos                                     31
#define LCD_PAL172_I1_Msk                                     (0x01UL << LCD_PAL172_I1_Pos)

// ---------------------------------------  LCD_PAL173  -------------------------------------------
#define LCD_PAL173_R04_0_Pos                                  0
#define LCD_PAL173_R04_0_Msk                                  (0x1fUL << LCD_PAL173_R04_0_Pos)
#define LCD_PAL173_G04_0_Pos                                  5
#define LCD_PAL173_G04_0_Msk                                  (0x1fUL << LCD_PAL173_G04_0_Pos)
#define LCD_PAL173_B04_0_Pos                                  10
#define LCD_PAL173_B04_0_Msk                                  (0x1fUL << LCD_PAL173_B04_0_Pos)
#define LCD_PAL173_I0_Pos                                     15
#define LCD_PAL173_I0_Msk                                     (0x01UL << LCD_PAL173_I0_Pos)
#define LCD_PAL173_R14_0_Pos                                  16
#define LCD_PAL173_R14_0_Msk                                  (0x1fUL << LCD_PAL173_R14_0_Pos)
#define LCD_PAL173_G14_0_Pos                                  21
#define LCD_PAL173_G14_0_Msk                                  (0x1fUL << LCD_PAL173_G14_0_Pos)
#define LCD_PAL173_B14_0_Pos                                  26
#define LCD_PAL173_B14_0_Msk                                  (0x1fUL << LCD_PAL173_B14_0_Pos)
#define LCD_PAL173_I1_Pos                                     31
#define LCD_PAL173_I1_Msk                                     (0x01UL << LCD_PAL173_I1_Pos)

// ---------------------------------------  LCD_PAL174  -------------------------------------------
#define LCD_PAL174_R04_0_Pos                                  0
#define LCD_PAL174_R04_0_Msk                                  (0x1fUL << LCD_PAL174_R04_0_Pos)
#define LCD_PAL174_G04_0_Pos                                  5
#define LCD_PAL174_G04_0_Msk                                  (0x1fUL << LCD_PAL174_G04_0_Pos)
#define LCD_PAL174_B04_0_Pos                                  10
#define LCD_PAL174_B04_0_Msk                                  (0x1fUL << LCD_PAL174_B04_0_Pos)
#define LCD_PAL174_I0_Pos                                     15
#define LCD_PAL174_I0_Msk                                     (0x01UL << LCD_PAL174_I0_Pos)
#define LCD_PAL174_R14_0_Pos                                  16
#define LCD_PAL174_R14_0_Msk                                  (0x1fUL << LCD_PAL174_R14_0_Pos)
#define LCD_PAL174_G14_0_Pos                                  21
#define LCD_PAL174_G14_0_Msk                                  (0x1fUL << LCD_PAL174_G14_0_Pos)
#define LCD_PAL174_B14_0_Pos                                  26
#define LCD_PAL174_B14_0_Msk                                  (0x1fUL << LCD_PAL174_B14_0_Pos)
#define LCD_PAL174_I1_Pos                                     31
#define LCD_PAL174_I1_Msk                                     (0x01UL << LCD_PAL174_I1_Pos)

// ---------------------------------------  LCD_PAL175  -------------------------------------------
#define LCD_PAL175_R04_0_Pos                                  0
#define LCD_PAL175_R04_0_Msk                                  (0x1fUL << LCD_PAL175_R04_0_Pos)
#define LCD_PAL175_G04_0_Pos                                  5
#define LCD_PAL175_G04_0_Msk                                  (0x1fUL << LCD_PAL175_G04_0_Pos)
#define LCD_PAL175_B04_0_Pos                                  10
#define LCD_PAL175_B04_0_Msk                                  (0x1fUL << LCD_PAL175_B04_0_Pos)
#define LCD_PAL175_I0_Pos                                     15
#define LCD_PAL175_I0_Msk                                     (0x01UL << LCD_PAL175_I0_Pos)
#define LCD_PAL175_R14_0_Pos                                  16
#define LCD_PAL175_R14_0_Msk                                  (0x1fUL << LCD_PAL175_R14_0_Pos)
#define LCD_PAL175_G14_0_Pos                                  21
#define LCD_PAL175_G14_0_Msk                                  (0x1fUL << LCD_PAL175_G14_0_Pos)
#define LCD_PAL175_B14_0_Pos                                  26
#define LCD_PAL175_B14_0_Msk                                  (0x1fUL << LCD_PAL175_B14_0_Pos)
#define LCD_PAL175_I1_Pos                                     31
#define LCD_PAL175_I1_Msk                                     (0x01UL << LCD_PAL175_I1_Pos)

// ---------------------------------------  LCD_PAL176  -------------------------------------------
#define LCD_PAL176_R04_0_Pos                                  0
#define LCD_PAL176_R04_0_Msk                                  (0x1fUL << LCD_PAL176_R04_0_Pos)
#define LCD_PAL176_G04_0_Pos                                  5
#define LCD_PAL176_G04_0_Msk                                  (0x1fUL << LCD_PAL176_G04_0_Pos)
#define LCD_PAL176_B04_0_Pos                                  10
#define LCD_PAL176_B04_0_Msk                                  (0x1fUL << LCD_PAL176_B04_0_Pos)
#define LCD_PAL176_I0_Pos                                     15
#define LCD_PAL176_I0_Msk                                     (0x01UL << LCD_PAL176_I0_Pos)
#define LCD_PAL176_R14_0_Pos                                  16
#define LCD_PAL176_R14_0_Msk                                  (0x1fUL << LCD_PAL176_R14_0_Pos)
#define LCD_PAL176_G14_0_Pos                                  21
#define LCD_PAL176_G14_0_Msk                                  (0x1fUL << LCD_PAL176_G14_0_Pos)
#define LCD_PAL176_B14_0_Pos                                  26
#define LCD_PAL176_B14_0_Msk                                  (0x1fUL << LCD_PAL176_B14_0_Pos)
#define LCD_PAL176_I1_Pos                                     31
#define LCD_PAL176_I1_Msk                                     (0x01UL << LCD_PAL176_I1_Pos)

// ---------------------------------------  LCD_PAL177  -------------------------------------------
#define LCD_PAL177_R04_0_Pos                                  0
#define LCD_PAL177_R04_0_Msk                                  (0x1fUL << LCD_PAL177_R04_0_Pos)
#define LCD_PAL177_G04_0_Pos                                  5
#define LCD_PAL177_G04_0_Msk                                  (0x1fUL << LCD_PAL177_G04_0_Pos)
#define LCD_PAL177_B04_0_Pos                                  10
#define LCD_PAL177_B04_0_Msk                                  (0x1fUL << LCD_PAL177_B04_0_Pos)
#define LCD_PAL177_I0_Pos                                     15
#define LCD_PAL177_I0_Msk                                     (0x01UL << LCD_PAL177_I0_Pos)
#define LCD_PAL177_R14_0_Pos                                  16
#define LCD_PAL177_R14_0_Msk                                  (0x1fUL << LCD_PAL177_R14_0_Pos)
#define LCD_PAL177_G14_0_Pos                                  21
#define LCD_PAL177_G14_0_Msk                                  (0x1fUL << LCD_PAL177_G14_0_Pos)
#define LCD_PAL177_B14_0_Pos                                  26
#define LCD_PAL177_B14_0_Msk                                  (0x1fUL << LCD_PAL177_B14_0_Pos)
#define LCD_PAL177_I1_Pos                                     31
#define LCD_PAL177_I1_Msk                                     (0x01UL << LCD_PAL177_I1_Pos)

// ---------------------------------------  LCD_PAL178  -------------------------------------------
#define LCD_PAL178_R04_0_Pos                                  0
#define LCD_PAL178_R04_0_Msk                                  (0x1fUL << LCD_PAL178_R04_0_Pos)
#define LCD_PAL178_G04_0_Pos                                  5
#define LCD_PAL178_G04_0_Msk                                  (0x1fUL << LCD_PAL178_G04_0_Pos)
#define LCD_PAL178_B04_0_Pos                                  10
#define LCD_PAL178_B04_0_Msk                                  (0x1fUL << LCD_PAL178_B04_0_Pos)
#define LCD_PAL178_I0_Pos                                     15
#define LCD_PAL178_I0_Msk                                     (0x01UL << LCD_PAL178_I0_Pos)
#define LCD_PAL178_R14_0_Pos                                  16
#define LCD_PAL178_R14_0_Msk                                  (0x1fUL << LCD_PAL178_R14_0_Pos)
#define LCD_PAL178_G14_0_Pos                                  21
#define LCD_PAL178_G14_0_Msk                                  (0x1fUL << LCD_PAL178_G14_0_Pos)
#define LCD_PAL178_B14_0_Pos                                  26
#define LCD_PAL178_B14_0_Msk                                  (0x1fUL << LCD_PAL178_B14_0_Pos)
#define LCD_PAL178_I1_Pos                                     31
#define LCD_PAL178_I1_Msk                                     (0x01UL << LCD_PAL178_I1_Pos)

// ---------------------------------------  LCD_PAL179  -------------------------------------------
#define LCD_PAL179_R04_0_Pos                                  0
#define LCD_PAL179_R04_0_Msk                                  (0x1fUL << LCD_PAL179_R04_0_Pos)
#define LCD_PAL179_G04_0_Pos                                  5
#define LCD_PAL179_G04_0_Msk                                  (0x1fUL << LCD_PAL179_G04_0_Pos)
#define LCD_PAL179_B04_0_Pos                                  10
#define LCD_PAL179_B04_0_Msk                                  (0x1fUL << LCD_PAL179_B04_0_Pos)
#define LCD_PAL179_I0_Pos                                     15
#define LCD_PAL179_I0_Msk                                     (0x01UL << LCD_PAL179_I0_Pos)
#define LCD_PAL179_R14_0_Pos                                  16
#define LCD_PAL179_R14_0_Msk                                  (0x1fUL << LCD_PAL179_R14_0_Pos)
#define LCD_PAL179_G14_0_Pos                                  21
#define LCD_PAL179_G14_0_Msk                                  (0x1fUL << LCD_PAL179_G14_0_Pos)
#define LCD_PAL179_B14_0_Pos                                  26
#define LCD_PAL179_B14_0_Msk                                  (0x1fUL << LCD_PAL179_B14_0_Pos)
#define LCD_PAL179_I1_Pos                                     31
#define LCD_PAL179_I1_Msk                                     (0x01UL << LCD_PAL179_I1_Pos)

// ---------------------------------------  LCD_PAL180  -------------------------------------------
#define LCD_PAL180_R04_0_Pos                                  0
#define LCD_PAL180_R04_0_Msk                                  (0x1fUL << LCD_PAL180_R04_0_Pos)
#define LCD_PAL180_G04_0_Pos                                  5
#define LCD_PAL180_G04_0_Msk                                  (0x1fUL << LCD_PAL180_G04_0_Pos)
#define LCD_PAL180_B04_0_Pos                                  10
#define LCD_PAL180_B04_0_Msk                                  (0x1fUL << LCD_PAL180_B04_0_Pos)
#define LCD_PAL180_I0_Pos                                     15
#define LCD_PAL180_I0_Msk                                     (0x01UL << LCD_PAL180_I0_Pos)
#define LCD_PAL180_R14_0_Pos                                  16
#define LCD_PAL180_R14_0_Msk                                  (0x1fUL << LCD_PAL180_R14_0_Pos)
#define LCD_PAL180_G14_0_Pos                                  21
#define LCD_PAL180_G14_0_Msk                                  (0x1fUL << LCD_PAL180_G14_0_Pos)
#define LCD_PAL180_B14_0_Pos                                  26
#define LCD_PAL180_B14_0_Msk                                  (0x1fUL << LCD_PAL180_B14_0_Pos)
#define LCD_PAL180_I1_Pos                                     31
#define LCD_PAL180_I1_Msk                                     (0x01UL << LCD_PAL180_I1_Pos)

// ---------------------------------------  LCD_PAL181  -------------------------------------------
#define LCD_PAL181_R04_0_Pos                                  0
#define LCD_PAL181_R04_0_Msk                                  (0x1fUL << LCD_PAL181_R04_0_Pos)
#define LCD_PAL181_G04_0_Pos                                  5
#define LCD_PAL181_G04_0_Msk                                  (0x1fUL << LCD_PAL181_G04_0_Pos)
#define LCD_PAL181_B04_0_Pos                                  10
#define LCD_PAL181_B04_0_Msk                                  (0x1fUL << LCD_PAL181_B04_0_Pos)
#define LCD_PAL181_I0_Pos                                     15
#define LCD_PAL181_I0_Msk                                     (0x01UL << LCD_PAL181_I0_Pos)
#define LCD_PAL181_R14_0_Pos                                  16
#define LCD_PAL181_R14_0_Msk                                  (0x1fUL << LCD_PAL181_R14_0_Pos)
#define LCD_PAL181_G14_0_Pos                                  21
#define LCD_PAL181_G14_0_Msk                                  (0x1fUL << LCD_PAL181_G14_0_Pos)
#define LCD_PAL181_B14_0_Pos                                  26
#define LCD_PAL181_B14_0_Msk                                  (0x1fUL << LCD_PAL181_B14_0_Pos)
#define LCD_PAL181_I1_Pos                                     31
#define LCD_PAL181_I1_Msk                                     (0x01UL << LCD_PAL181_I1_Pos)

// ---------------------------------------  LCD_PAL182  -------------------------------------------
#define LCD_PAL182_R04_0_Pos                                  0
#define LCD_PAL182_R04_0_Msk                                  (0x1fUL << LCD_PAL182_R04_0_Pos)
#define LCD_PAL182_G04_0_Pos                                  5
#define LCD_PAL182_G04_0_Msk                                  (0x1fUL << LCD_PAL182_G04_0_Pos)
#define LCD_PAL182_B04_0_Pos                                  10
#define LCD_PAL182_B04_0_Msk                                  (0x1fUL << LCD_PAL182_B04_0_Pos)
#define LCD_PAL182_I0_Pos                                     15
#define LCD_PAL182_I0_Msk                                     (0x01UL << LCD_PAL182_I0_Pos)
#define LCD_PAL182_R14_0_Pos                                  16
#define LCD_PAL182_R14_0_Msk                                  (0x1fUL << LCD_PAL182_R14_0_Pos)
#define LCD_PAL182_G14_0_Pos                                  21
#define LCD_PAL182_G14_0_Msk                                  (0x1fUL << LCD_PAL182_G14_0_Pos)
#define LCD_PAL182_B14_0_Pos                                  26
#define LCD_PAL182_B14_0_Msk                                  (0x1fUL << LCD_PAL182_B14_0_Pos)
#define LCD_PAL182_I1_Pos                                     31
#define LCD_PAL182_I1_Msk                                     (0x01UL << LCD_PAL182_I1_Pos)

// ---------------------------------------  LCD_PAL183  -------------------------------------------
#define LCD_PAL183_R04_0_Pos                                  0
#define LCD_PAL183_R04_0_Msk                                  (0x1fUL << LCD_PAL183_R04_0_Pos)
#define LCD_PAL183_G04_0_Pos                                  5
#define LCD_PAL183_G04_0_Msk                                  (0x1fUL << LCD_PAL183_G04_0_Pos)
#define LCD_PAL183_B04_0_Pos                                  10
#define LCD_PAL183_B04_0_Msk                                  (0x1fUL << LCD_PAL183_B04_0_Pos)
#define LCD_PAL183_I0_Pos                                     15
#define LCD_PAL183_I0_Msk                                     (0x01UL << LCD_PAL183_I0_Pos)
#define LCD_PAL183_R14_0_Pos                                  16
#define LCD_PAL183_R14_0_Msk                                  (0x1fUL << LCD_PAL183_R14_0_Pos)
#define LCD_PAL183_G14_0_Pos                                  21
#define LCD_PAL183_G14_0_Msk                                  (0x1fUL << LCD_PAL183_G14_0_Pos)
#define LCD_PAL183_B14_0_Pos                                  26
#define LCD_PAL183_B14_0_Msk                                  (0x1fUL << LCD_PAL183_B14_0_Pos)
#define LCD_PAL183_I1_Pos                                     31
#define LCD_PAL183_I1_Msk                                     (0x01UL << LCD_PAL183_I1_Pos)

// ---------------------------------------  LCD_PAL184  -------------------------------------------
#define LCD_PAL184_R04_0_Pos                                  0
#define LCD_PAL184_R04_0_Msk                                  (0x1fUL << LCD_PAL184_R04_0_Pos)
#define LCD_PAL184_G04_0_Pos                                  5
#define LCD_PAL184_G04_0_Msk                                  (0x1fUL << LCD_PAL184_G04_0_Pos)
#define LCD_PAL184_B04_0_Pos                                  10
#define LCD_PAL184_B04_0_Msk                                  (0x1fUL << LCD_PAL184_B04_0_Pos)
#define LCD_PAL184_I0_Pos                                     15
#define LCD_PAL184_I0_Msk                                     (0x01UL << LCD_PAL184_I0_Pos)
#define LCD_PAL184_R14_0_Pos                                  16
#define LCD_PAL184_R14_0_Msk                                  (0x1fUL << LCD_PAL184_R14_0_Pos)
#define LCD_PAL184_G14_0_Pos                                  21
#define LCD_PAL184_G14_0_Msk                                  (0x1fUL << LCD_PAL184_G14_0_Pos)
#define LCD_PAL184_B14_0_Pos                                  26
#define LCD_PAL184_B14_0_Msk                                  (0x1fUL << LCD_PAL184_B14_0_Pos)
#define LCD_PAL184_I1_Pos                                     31
#define LCD_PAL184_I1_Msk                                     (0x01UL << LCD_PAL184_I1_Pos)

// ---------------------------------------  LCD_PAL185  -------------------------------------------
#define LCD_PAL185_R04_0_Pos                                  0
#define LCD_PAL185_R04_0_Msk                                  (0x1fUL << LCD_PAL185_R04_0_Pos)
#define LCD_PAL185_G04_0_Pos                                  5
#define LCD_PAL185_G04_0_Msk                                  (0x1fUL << LCD_PAL185_G04_0_Pos)
#define LCD_PAL185_B04_0_Pos                                  10
#define LCD_PAL185_B04_0_Msk                                  (0x1fUL << LCD_PAL185_B04_0_Pos)
#define LCD_PAL185_I0_Pos                                     15
#define LCD_PAL185_I0_Msk                                     (0x01UL << LCD_PAL185_I0_Pos)
#define LCD_PAL185_R14_0_Pos                                  16
#define LCD_PAL185_R14_0_Msk                                  (0x1fUL << LCD_PAL185_R14_0_Pos)
#define LCD_PAL185_G14_0_Pos                                  21
#define LCD_PAL185_G14_0_Msk                                  (0x1fUL << LCD_PAL185_G14_0_Pos)
#define LCD_PAL185_B14_0_Pos                                  26
#define LCD_PAL185_B14_0_Msk                                  (0x1fUL << LCD_PAL185_B14_0_Pos)
#define LCD_PAL185_I1_Pos                                     31
#define LCD_PAL185_I1_Msk                                     (0x01UL << LCD_PAL185_I1_Pos)

// ---------------------------------------  LCD_PAL186  -------------------------------------------
#define LCD_PAL186_R04_0_Pos                                  0
#define LCD_PAL186_R04_0_Msk                                  (0x1fUL << LCD_PAL186_R04_0_Pos)
#define LCD_PAL186_G04_0_Pos                                  5
#define LCD_PAL186_G04_0_Msk                                  (0x1fUL << LCD_PAL186_G04_0_Pos)
#define LCD_PAL186_B04_0_Pos                                  10
#define LCD_PAL186_B04_0_Msk                                  (0x1fUL << LCD_PAL186_B04_0_Pos)
#define LCD_PAL186_I0_Pos                                     15
#define LCD_PAL186_I0_Msk                                     (0x01UL << LCD_PAL186_I0_Pos)
#define LCD_PAL186_R14_0_Pos                                  16
#define LCD_PAL186_R14_0_Msk                                  (0x1fUL << LCD_PAL186_R14_0_Pos)
#define LCD_PAL186_G14_0_Pos                                  21
#define LCD_PAL186_G14_0_Msk                                  (0x1fUL << LCD_PAL186_G14_0_Pos)
#define LCD_PAL186_B14_0_Pos                                  26
#define LCD_PAL186_B14_0_Msk                                  (0x1fUL << LCD_PAL186_B14_0_Pos)
#define LCD_PAL186_I1_Pos                                     31
#define LCD_PAL186_I1_Msk                                     (0x01UL << LCD_PAL186_I1_Pos)

// ---------------------------------------  LCD_PAL187  -------------------------------------------
#define LCD_PAL187_R04_0_Pos                                  0
#define LCD_PAL187_R04_0_Msk                                  (0x1fUL << LCD_PAL187_R04_0_Pos)
#define LCD_PAL187_G04_0_Pos                                  5
#define LCD_PAL187_G04_0_Msk                                  (0x1fUL << LCD_PAL187_G04_0_Pos)
#define LCD_PAL187_B04_0_Pos                                  10
#define LCD_PAL187_B04_0_Msk                                  (0x1fUL << LCD_PAL187_B04_0_Pos)
#define LCD_PAL187_I0_Pos                                     15
#define LCD_PAL187_I0_Msk                                     (0x01UL << LCD_PAL187_I0_Pos)
#define LCD_PAL187_R14_0_Pos                                  16
#define LCD_PAL187_R14_0_Msk                                  (0x1fUL << LCD_PAL187_R14_0_Pos)
#define LCD_PAL187_G14_0_Pos                                  21
#define LCD_PAL187_G14_0_Msk                                  (0x1fUL << LCD_PAL187_G14_0_Pos)
#define LCD_PAL187_B14_0_Pos                                  26
#define LCD_PAL187_B14_0_Msk                                  (0x1fUL << LCD_PAL187_B14_0_Pos)
#define LCD_PAL187_I1_Pos                                     31
#define LCD_PAL187_I1_Msk                                     (0x01UL << LCD_PAL187_I1_Pos)

// ---------------------------------------  LCD_PAL188  -------------------------------------------
#define LCD_PAL188_R04_0_Pos                                  0
#define LCD_PAL188_R04_0_Msk                                  (0x1fUL << LCD_PAL188_R04_0_Pos)
#define LCD_PAL188_G04_0_Pos                                  5
#define LCD_PAL188_G04_0_Msk                                  (0x1fUL << LCD_PAL188_G04_0_Pos)
#define LCD_PAL188_B04_0_Pos                                  10
#define LCD_PAL188_B04_0_Msk                                  (0x1fUL << LCD_PAL188_B04_0_Pos)
#define LCD_PAL188_I0_Pos                                     15
#define LCD_PAL188_I0_Msk                                     (0x01UL << LCD_PAL188_I0_Pos)
#define LCD_PAL188_R14_0_Pos                                  16
#define LCD_PAL188_R14_0_Msk                                  (0x1fUL << LCD_PAL188_R14_0_Pos)
#define LCD_PAL188_G14_0_Pos                                  21
#define LCD_PAL188_G14_0_Msk                                  (0x1fUL << LCD_PAL188_G14_0_Pos)
#define LCD_PAL188_B14_0_Pos                                  26
#define LCD_PAL188_B14_0_Msk                                  (0x1fUL << LCD_PAL188_B14_0_Pos)
#define LCD_PAL188_I1_Pos                                     31
#define LCD_PAL188_I1_Msk                                     (0x01UL << LCD_PAL188_I1_Pos)

// ---------------------------------------  LCD_PAL189  -------------------------------------------
#define LCD_PAL189_R04_0_Pos                                  0
#define LCD_PAL189_R04_0_Msk                                  (0x1fUL << LCD_PAL189_R04_0_Pos)
#define LCD_PAL189_G04_0_Pos                                  5
#define LCD_PAL189_G04_0_Msk                                  (0x1fUL << LCD_PAL189_G04_0_Pos)
#define LCD_PAL189_B04_0_Pos                                  10
#define LCD_PAL189_B04_0_Msk                                  (0x1fUL << LCD_PAL189_B04_0_Pos)
#define LCD_PAL189_I0_Pos                                     15
#define LCD_PAL189_I0_Msk                                     (0x01UL << LCD_PAL189_I0_Pos)
#define LCD_PAL189_R14_0_Pos                                  16
#define LCD_PAL189_R14_0_Msk                                  (0x1fUL << LCD_PAL189_R14_0_Pos)
#define LCD_PAL189_G14_0_Pos                                  21
#define LCD_PAL189_G14_0_Msk                                  (0x1fUL << LCD_PAL189_G14_0_Pos)
#define LCD_PAL189_B14_0_Pos                                  26
#define LCD_PAL189_B14_0_Msk                                  (0x1fUL << LCD_PAL189_B14_0_Pos)
#define LCD_PAL189_I1_Pos                                     31
#define LCD_PAL189_I1_Msk                                     (0x01UL << LCD_PAL189_I1_Pos)

// ---------------------------------------  LCD_PAL190  -------------------------------------------
#define LCD_PAL190_R04_0_Pos                                  0
#define LCD_PAL190_R04_0_Msk                                  (0x1fUL << LCD_PAL190_R04_0_Pos)
#define LCD_PAL190_G04_0_Pos                                  5
#define LCD_PAL190_G04_0_Msk                                  (0x1fUL << LCD_PAL190_G04_0_Pos)
#define LCD_PAL190_B04_0_Pos                                  10
#define LCD_PAL190_B04_0_Msk                                  (0x1fUL << LCD_PAL190_B04_0_Pos)
#define LCD_PAL190_I0_Pos                                     15
#define LCD_PAL190_I0_Msk                                     (0x01UL << LCD_PAL190_I0_Pos)
#define LCD_PAL190_R14_0_Pos                                  16
#define LCD_PAL190_R14_0_Msk                                  (0x1fUL << LCD_PAL190_R14_0_Pos)
#define LCD_PAL190_G14_0_Pos                                  21
#define LCD_PAL190_G14_0_Msk                                  (0x1fUL << LCD_PAL190_G14_0_Pos)
#define LCD_PAL190_B14_0_Pos                                  26
#define LCD_PAL190_B14_0_Msk                                  (0x1fUL << LCD_PAL190_B14_0_Pos)
#define LCD_PAL190_I1_Pos                                     31
#define LCD_PAL190_I1_Msk                                     (0x01UL << LCD_PAL190_I1_Pos)

// ---------------------------------------  LCD_PAL191  -------------------------------------------
#define LCD_PAL191_R04_0_Pos                                  0
#define LCD_PAL191_R04_0_Msk                                  (0x1fUL << LCD_PAL191_R04_0_Pos)
#define LCD_PAL191_G04_0_Pos                                  5
#define LCD_PAL191_G04_0_Msk                                  (0x1fUL << LCD_PAL191_G04_0_Pos)
#define LCD_PAL191_B04_0_Pos                                  10
#define LCD_PAL191_B04_0_Msk                                  (0x1fUL << LCD_PAL191_B04_0_Pos)
#define LCD_PAL191_I0_Pos                                     15
#define LCD_PAL191_I0_Msk                                     (0x01UL << LCD_PAL191_I0_Pos)
#define LCD_PAL191_R14_0_Pos                                  16
#define LCD_PAL191_R14_0_Msk                                  (0x1fUL << LCD_PAL191_R14_0_Pos)
#define LCD_PAL191_G14_0_Pos                                  21
#define LCD_PAL191_G14_0_Msk                                  (0x1fUL << LCD_PAL191_G14_0_Pos)
#define LCD_PAL191_B14_0_Pos                                  26
#define LCD_PAL191_B14_0_Msk                                  (0x1fUL << LCD_PAL191_B14_0_Pos)
#define LCD_PAL191_I1_Pos                                     31
#define LCD_PAL191_I1_Msk                                     (0x01UL << LCD_PAL191_I1_Pos)

// ---------------------------------------  LCD_PAL192  -------------------------------------------
#define LCD_PAL192_R04_0_Pos                                  0
#define LCD_PAL192_R04_0_Msk                                  (0x1fUL << LCD_PAL192_R04_0_Pos)
#define LCD_PAL192_G04_0_Pos                                  5
#define LCD_PAL192_G04_0_Msk                                  (0x1fUL << LCD_PAL192_G04_0_Pos)
#define LCD_PAL192_B04_0_Pos                                  10
#define LCD_PAL192_B04_0_Msk                                  (0x1fUL << LCD_PAL192_B04_0_Pos)
#define LCD_PAL192_I0_Pos                                     15
#define LCD_PAL192_I0_Msk                                     (0x01UL << LCD_PAL192_I0_Pos)
#define LCD_PAL192_R14_0_Pos                                  16
#define LCD_PAL192_R14_0_Msk                                  (0x1fUL << LCD_PAL192_R14_0_Pos)
#define LCD_PAL192_G14_0_Pos                                  21
#define LCD_PAL192_G14_0_Msk                                  (0x1fUL << LCD_PAL192_G14_0_Pos)
#define LCD_PAL192_B14_0_Pos                                  26
#define LCD_PAL192_B14_0_Msk                                  (0x1fUL << LCD_PAL192_B14_0_Pos)
#define LCD_PAL192_I1_Pos                                     31
#define LCD_PAL192_I1_Msk                                     (0x01UL << LCD_PAL192_I1_Pos)

// ---------------------------------------  LCD_PAL193  -------------------------------------------
#define LCD_PAL193_R04_0_Pos                                  0
#define LCD_PAL193_R04_0_Msk                                  (0x1fUL << LCD_PAL193_R04_0_Pos)
#define LCD_PAL193_G04_0_Pos                                  5
#define LCD_PAL193_G04_0_Msk                                  (0x1fUL << LCD_PAL193_G04_0_Pos)
#define LCD_PAL193_B04_0_Pos                                  10
#define LCD_PAL193_B04_0_Msk                                  (0x1fUL << LCD_PAL193_B04_0_Pos)
#define LCD_PAL193_I0_Pos                                     15
#define LCD_PAL193_I0_Msk                                     (0x01UL << LCD_PAL193_I0_Pos)
#define LCD_PAL193_R14_0_Pos                                  16
#define LCD_PAL193_R14_0_Msk                                  (0x1fUL << LCD_PAL193_R14_0_Pos)
#define LCD_PAL193_G14_0_Pos                                  21
#define LCD_PAL193_G14_0_Msk                                  (0x1fUL << LCD_PAL193_G14_0_Pos)
#define LCD_PAL193_B14_0_Pos                                  26
#define LCD_PAL193_B14_0_Msk                                  (0x1fUL << LCD_PAL193_B14_0_Pos)
#define LCD_PAL193_I1_Pos                                     31
#define LCD_PAL193_I1_Msk                                     (0x01UL << LCD_PAL193_I1_Pos)

// ---------------------------------------  LCD_PAL194  -------------------------------------------
#define LCD_PAL194_R04_0_Pos                                  0
#define LCD_PAL194_R04_0_Msk                                  (0x1fUL << LCD_PAL194_R04_0_Pos)
#define LCD_PAL194_G04_0_Pos                                  5
#define LCD_PAL194_G04_0_Msk                                  (0x1fUL << LCD_PAL194_G04_0_Pos)
#define LCD_PAL194_B04_0_Pos                                  10
#define LCD_PAL194_B04_0_Msk                                  (0x1fUL << LCD_PAL194_B04_0_Pos)
#define LCD_PAL194_I0_Pos                                     15
#define LCD_PAL194_I0_Msk                                     (0x01UL << LCD_PAL194_I0_Pos)
#define LCD_PAL194_R14_0_Pos                                  16
#define LCD_PAL194_R14_0_Msk                                  (0x1fUL << LCD_PAL194_R14_0_Pos)
#define LCD_PAL194_G14_0_Pos                                  21
#define LCD_PAL194_G14_0_Msk                                  (0x1fUL << LCD_PAL194_G14_0_Pos)
#define LCD_PAL194_B14_0_Pos                                  26
#define LCD_PAL194_B14_0_Msk                                  (0x1fUL << LCD_PAL194_B14_0_Pos)
#define LCD_PAL194_I1_Pos                                     31
#define LCD_PAL194_I1_Msk                                     (0x01UL << LCD_PAL194_I1_Pos)

// ---------------------------------------  LCD_PAL195  -------------------------------------------
#define LCD_PAL195_R04_0_Pos                                  0
#define LCD_PAL195_R04_0_Msk                                  (0x1fUL << LCD_PAL195_R04_0_Pos)
#define LCD_PAL195_G04_0_Pos                                  5
#define LCD_PAL195_G04_0_Msk                                  (0x1fUL << LCD_PAL195_G04_0_Pos)
#define LCD_PAL195_B04_0_Pos                                  10
#define LCD_PAL195_B04_0_Msk                                  (0x1fUL << LCD_PAL195_B04_0_Pos)
#define LCD_PAL195_I0_Pos                                     15
#define LCD_PAL195_I0_Msk                                     (0x01UL << LCD_PAL195_I0_Pos)
#define LCD_PAL195_R14_0_Pos                                  16
#define LCD_PAL195_R14_0_Msk                                  (0x1fUL << LCD_PAL195_R14_0_Pos)
#define LCD_PAL195_G14_0_Pos                                  21
#define LCD_PAL195_G14_0_Msk                                  (0x1fUL << LCD_PAL195_G14_0_Pos)
#define LCD_PAL195_B14_0_Pos                                  26
#define LCD_PAL195_B14_0_Msk                                  (0x1fUL << LCD_PAL195_B14_0_Pos)
#define LCD_PAL195_I1_Pos                                     31
#define LCD_PAL195_I1_Msk                                     (0x01UL << LCD_PAL195_I1_Pos)

// ---------------------------------------  LCD_PAL196  -------------------------------------------
#define LCD_PAL196_R04_0_Pos                                  0
#define LCD_PAL196_R04_0_Msk                                  (0x1fUL << LCD_PAL196_R04_0_Pos)
#define LCD_PAL196_G04_0_Pos                                  5
#define LCD_PAL196_G04_0_Msk                                  (0x1fUL << LCD_PAL196_G04_0_Pos)
#define LCD_PAL196_B04_0_Pos                                  10
#define LCD_PAL196_B04_0_Msk                                  (0x1fUL << LCD_PAL196_B04_0_Pos)
#define LCD_PAL196_I0_Pos                                     15
#define LCD_PAL196_I0_Msk                                     (0x01UL << LCD_PAL196_I0_Pos)
#define LCD_PAL196_R14_0_Pos                                  16
#define LCD_PAL196_R14_0_Msk                                  (0x1fUL << LCD_PAL196_R14_0_Pos)
#define LCD_PAL196_G14_0_Pos                                  21
#define LCD_PAL196_G14_0_Msk                                  (0x1fUL << LCD_PAL196_G14_0_Pos)
#define LCD_PAL196_B14_0_Pos                                  26
#define LCD_PAL196_B14_0_Msk                                  (0x1fUL << LCD_PAL196_B14_0_Pos)
#define LCD_PAL196_I1_Pos                                     31
#define LCD_PAL196_I1_Msk                                     (0x01UL << LCD_PAL196_I1_Pos)

// ---------------------------------------  LCD_PAL197  -------------------------------------------
#define LCD_PAL197_R04_0_Pos                                  0
#define LCD_PAL197_R04_0_Msk                                  (0x1fUL << LCD_PAL197_R04_0_Pos)
#define LCD_PAL197_G04_0_Pos                                  5
#define LCD_PAL197_G04_0_Msk                                  (0x1fUL << LCD_PAL197_G04_0_Pos)
#define LCD_PAL197_B04_0_Pos                                  10
#define LCD_PAL197_B04_0_Msk                                  (0x1fUL << LCD_PAL197_B04_0_Pos)
#define LCD_PAL197_I0_Pos                                     15
#define LCD_PAL197_I0_Msk                                     (0x01UL << LCD_PAL197_I0_Pos)
#define LCD_PAL197_R14_0_Pos                                  16
#define LCD_PAL197_R14_0_Msk                                  (0x1fUL << LCD_PAL197_R14_0_Pos)
#define LCD_PAL197_G14_0_Pos                                  21
#define LCD_PAL197_G14_0_Msk                                  (0x1fUL << LCD_PAL197_G14_0_Pos)
#define LCD_PAL197_B14_0_Pos                                  26
#define LCD_PAL197_B14_0_Msk                                  (0x1fUL << LCD_PAL197_B14_0_Pos)
#define LCD_PAL197_I1_Pos                                     31
#define LCD_PAL197_I1_Msk                                     (0x01UL << LCD_PAL197_I1_Pos)

// ---------------------------------------  LCD_PAL198  -------------------------------------------
#define LCD_PAL198_R04_0_Pos                                  0
#define LCD_PAL198_R04_0_Msk                                  (0x1fUL << LCD_PAL198_R04_0_Pos)
#define LCD_PAL198_G04_0_Pos                                  5
#define LCD_PAL198_G04_0_Msk                                  (0x1fUL << LCD_PAL198_G04_0_Pos)
#define LCD_PAL198_B04_0_Pos                                  10
#define LCD_PAL198_B04_0_Msk                                  (0x1fUL << LCD_PAL198_B04_0_Pos)
#define LCD_PAL198_I0_Pos                                     15
#define LCD_PAL198_I0_Msk                                     (0x01UL << LCD_PAL198_I0_Pos)
#define LCD_PAL198_R14_0_Pos                                  16
#define LCD_PAL198_R14_0_Msk                                  (0x1fUL << LCD_PAL198_R14_0_Pos)
#define LCD_PAL198_G14_0_Pos                                  21
#define LCD_PAL198_G14_0_Msk                                  (0x1fUL << LCD_PAL198_G14_0_Pos)
#define LCD_PAL198_B14_0_Pos                                  26
#define LCD_PAL198_B14_0_Msk                                  (0x1fUL << LCD_PAL198_B14_0_Pos)
#define LCD_PAL198_I1_Pos                                     31
#define LCD_PAL198_I1_Msk                                     (0x01UL << LCD_PAL198_I1_Pos)

// ---------------------------------------  LCD_PAL199  -------------------------------------------
#define LCD_PAL199_R04_0_Pos                                  0
#define LCD_PAL199_R04_0_Msk                                  (0x1fUL << LCD_PAL199_R04_0_Pos)
#define LCD_PAL199_G04_0_Pos                                  5
#define LCD_PAL199_G04_0_Msk                                  (0x1fUL << LCD_PAL199_G04_0_Pos)
#define LCD_PAL199_B04_0_Pos                                  10
#define LCD_PAL199_B04_0_Msk                                  (0x1fUL << LCD_PAL199_B04_0_Pos)
#define LCD_PAL199_I0_Pos                                     15
#define LCD_PAL199_I0_Msk                                     (0x01UL << LCD_PAL199_I0_Pos)
#define LCD_PAL199_R14_0_Pos                                  16
#define LCD_PAL199_R14_0_Msk                                  (0x1fUL << LCD_PAL199_R14_0_Pos)
#define LCD_PAL199_G14_0_Pos                                  21
#define LCD_PAL199_G14_0_Msk                                  (0x1fUL << LCD_PAL199_G14_0_Pos)
#define LCD_PAL199_B14_0_Pos                                  26
#define LCD_PAL199_B14_0_Msk                                  (0x1fUL << LCD_PAL199_B14_0_Pos)
#define LCD_PAL199_I1_Pos                                     31
#define LCD_PAL199_I1_Msk                                     (0x01UL << LCD_PAL199_I1_Pos)

// ---------------------------------------  LCD_PAL200  -------------------------------------------
#define LCD_PAL200_R04_0_Pos                                  0
#define LCD_PAL200_R04_0_Msk                                  (0x1fUL << LCD_PAL200_R04_0_Pos)
#define LCD_PAL200_G04_0_Pos                                  5
#define LCD_PAL200_G04_0_Msk                                  (0x1fUL << LCD_PAL200_G04_0_Pos)
#define LCD_PAL200_B04_0_Pos                                  10
#define LCD_PAL200_B04_0_Msk                                  (0x1fUL << LCD_PAL200_B04_0_Pos)
#define LCD_PAL200_I0_Pos                                     15
#define LCD_PAL200_I0_Msk                                     (0x01UL << LCD_PAL200_I0_Pos)
#define LCD_PAL200_R14_0_Pos                                  16
#define LCD_PAL200_R14_0_Msk                                  (0x1fUL << LCD_PAL200_R14_0_Pos)
#define LCD_PAL200_G14_0_Pos                                  21
#define LCD_PAL200_G14_0_Msk                                  (0x1fUL << LCD_PAL200_G14_0_Pos)
#define LCD_PAL200_B14_0_Pos                                  26
#define LCD_PAL200_B14_0_Msk                                  (0x1fUL << LCD_PAL200_B14_0_Pos)
#define LCD_PAL200_I1_Pos                                     31
#define LCD_PAL200_I1_Msk                                     (0x01UL << LCD_PAL200_I1_Pos)

// ---------------------------------------  LCD_PAL201  -------------------------------------------
#define LCD_PAL201_R04_0_Pos                                  0
#define LCD_PAL201_R04_0_Msk                                  (0x1fUL << LCD_PAL201_R04_0_Pos)
#define LCD_PAL201_G04_0_Pos                                  5
#define LCD_PAL201_G04_0_Msk                                  (0x1fUL << LCD_PAL201_G04_0_Pos)
#define LCD_PAL201_B04_0_Pos                                  10
#define LCD_PAL201_B04_0_Msk                                  (0x1fUL << LCD_PAL201_B04_0_Pos)
#define LCD_PAL201_I0_Pos                                     15
#define LCD_PAL201_I0_Msk                                     (0x01UL << LCD_PAL201_I0_Pos)
#define LCD_PAL201_R14_0_Pos                                  16
#define LCD_PAL201_R14_0_Msk                                  (0x1fUL << LCD_PAL201_R14_0_Pos)
#define LCD_PAL201_G14_0_Pos                                  21
#define LCD_PAL201_G14_0_Msk                                  (0x1fUL << LCD_PAL201_G14_0_Pos)
#define LCD_PAL201_B14_0_Pos                                  26
#define LCD_PAL201_B14_0_Msk                                  (0x1fUL << LCD_PAL201_B14_0_Pos)
#define LCD_PAL201_I1_Pos                                     31
#define LCD_PAL201_I1_Msk                                     (0x01UL << LCD_PAL201_I1_Pos)

// ---------------------------------------  LCD_PAL202  -------------------------------------------
#define LCD_PAL202_R04_0_Pos                                  0
#define LCD_PAL202_R04_0_Msk                                  (0x1fUL << LCD_PAL202_R04_0_Pos)
#define LCD_PAL202_G04_0_Pos                                  5
#define LCD_PAL202_G04_0_Msk                                  (0x1fUL << LCD_PAL202_G04_0_Pos)
#define LCD_PAL202_B04_0_Pos                                  10
#define LCD_PAL202_B04_0_Msk                                  (0x1fUL << LCD_PAL202_B04_0_Pos)
#define LCD_PAL202_I0_Pos                                     15
#define LCD_PAL202_I0_Msk                                     (0x01UL << LCD_PAL202_I0_Pos)
#define LCD_PAL202_R14_0_Pos                                  16
#define LCD_PAL202_R14_0_Msk                                  (0x1fUL << LCD_PAL202_R14_0_Pos)
#define LCD_PAL202_G14_0_Pos                                  21
#define LCD_PAL202_G14_0_Msk                                  (0x1fUL << LCD_PAL202_G14_0_Pos)
#define LCD_PAL202_B14_0_Pos                                  26
#define LCD_PAL202_B14_0_Msk                                  (0x1fUL << LCD_PAL202_B14_0_Pos)
#define LCD_PAL202_I1_Pos                                     31
#define LCD_PAL202_I1_Msk                                     (0x01UL << LCD_PAL202_I1_Pos)

// ---------------------------------------  LCD_PAL203  -------------------------------------------
#define LCD_PAL203_R04_0_Pos                                  0
#define LCD_PAL203_R04_0_Msk                                  (0x1fUL << LCD_PAL203_R04_0_Pos)
#define LCD_PAL203_G04_0_Pos                                  5
#define LCD_PAL203_G04_0_Msk                                  (0x1fUL << LCD_PAL203_G04_0_Pos)
#define LCD_PAL203_B04_0_Pos                                  10
#define LCD_PAL203_B04_0_Msk                                  (0x1fUL << LCD_PAL203_B04_0_Pos)
#define LCD_PAL203_I0_Pos                                     15
#define LCD_PAL203_I0_Msk                                     (0x01UL << LCD_PAL203_I0_Pos)
#define LCD_PAL203_R14_0_Pos                                  16
#define LCD_PAL203_R14_0_Msk                                  (0x1fUL << LCD_PAL203_R14_0_Pos)
#define LCD_PAL203_G14_0_Pos                                  21
#define LCD_PAL203_G14_0_Msk                                  (0x1fUL << LCD_PAL203_G14_0_Pos)
#define LCD_PAL203_B14_0_Pos                                  26
#define LCD_PAL203_B14_0_Msk                                  (0x1fUL << LCD_PAL203_B14_0_Pos)
#define LCD_PAL203_I1_Pos                                     31
#define LCD_PAL203_I1_Msk                                     (0x01UL << LCD_PAL203_I1_Pos)

// ---------------------------------------  LCD_PAL204  -------------------------------------------
#define LCD_PAL204_R04_0_Pos                                  0
#define LCD_PAL204_R04_0_Msk                                  (0x1fUL << LCD_PAL204_R04_0_Pos)
#define LCD_PAL204_G04_0_Pos                                  5
#define LCD_PAL204_G04_0_Msk                                  (0x1fUL << LCD_PAL204_G04_0_Pos)
#define LCD_PAL204_B04_0_Pos                                  10
#define LCD_PAL204_B04_0_Msk                                  (0x1fUL << LCD_PAL204_B04_0_Pos)
#define LCD_PAL204_I0_Pos                                     15
#define LCD_PAL204_I0_Msk                                     (0x01UL << LCD_PAL204_I0_Pos)
#define LCD_PAL204_R14_0_Pos                                  16
#define LCD_PAL204_R14_0_Msk                                  (0x1fUL << LCD_PAL204_R14_0_Pos)
#define LCD_PAL204_G14_0_Pos                                  21
#define LCD_PAL204_G14_0_Msk                                  (0x1fUL << LCD_PAL204_G14_0_Pos)
#define LCD_PAL204_B14_0_Pos                                  26
#define LCD_PAL204_B14_0_Msk                                  (0x1fUL << LCD_PAL204_B14_0_Pos)
#define LCD_PAL204_I1_Pos                                     31
#define LCD_PAL204_I1_Msk                                     (0x01UL << LCD_PAL204_I1_Pos)

// ---------------------------------------  LCD_PAL205  -------------------------------------------
#define LCD_PAL205_R04_0_Pos                                  0
#define LCD_PAL205_R04_0_Msk                                  (0x1fUL << LCD_PAL205_R04_0_Pos)
#define LCD_PAL205_G04_0_Pos                                  5
#define LCD_PAL205_G04_0_Msk                                  (0x1fUL << LCD_PAL205_G04_0_Pos)
#define LCD_PAL205_B04_0_Pos                                  10
#define LCD_PAL205_B04_0_Msk                                  (0x1fUL << LCD_PAL205_B04_0_Pos)
#define LCD_PAL205_I0_Pos                                     15
#define LCD_PAL205_I0_Msk                                     (0x01UL << LCD_PAL205_I0_Pos)
#define LCD_PAL205_R14_0_Pos                                  16
#define LCD_PAL205_R14_0_Msk                                  (0x1fUL << LCD_PAL205_R14_0_Pos)
#define LCD_PAL205_G14_0_Pos                                  21
#define LCD_PAL205_G14_0_Msk                                  (0x1fUL << LCD_PAL205_G14_0_Pos)
#define LCD_PAL205_B14_0_Pos                                  26
#define LCD_PAL205_B14_0_Msk                                  (0x1fUL << LCD_PAL205_B14_0_Pos)
#define LCD_PAL205_I1_Pos                                     31
#define LCD_PAL205_I1_Msk                                     (0x01UL << LCD_PAL205_I1_Pos)

// ---------------------------------------  LCD_PAL206  -------------------------------------------
#define LCD_PAL206_R04_0_Pos                                  0
#define LCD_PAL206_R04_0_Msk                                  (0x1fUL << LCD_PAL206_R04_0_Pos)
#define LCD_PAL206_G04_0_Pos                                  5
#define LCD_PAL206_G04_0_Msk                                  (0x1fUL << LCD_PAL206_G04_0_Pos)
#define LCD_PAL206_B04_0_Pos                                  10
#define LCD_PAL206_B04_0_Msk                                  (0x1fUL << LCD_PAL206_B04_0_Pos)
#define LCD_PAL206_I0_Pos                                     15
#define LCD_PAL206_I0_Msk                                     (0x01UL << LCD_PAL206_I0_Pos)
#define LCD_PAL206_R14_0_Pos                                  16
#define LCD_PAL206_R14_0_Msk                                  (0x1fUL << LCD_PAL206_R14_0_Pos)
#define LCD_PAL206_G14_0_Pos                                  21
#define LCD_PAL206_G14_0_Msk                                  (0x1fUL << LCD_PAL206_G14_0_Pos)
#define LCD_PAL206_B14_0_Pos                                  26
#define LCD_PAL206_B14_0_Msk                                  (0x1fUL << LCD_PAL206_B14_0_Pos)
#define LCD_PAL206_I1_Pos                                     31
#define LCD_PAL206_I1_Msk                                     (0x01UL << LCD_PAL206_I1_Pos)

// ---------------------------------------  LCD_PAL207  -------------------------------------------
#define LCD_PAL207_R04_0_Pos                                  0
#define LCD_PAL207_R04_0_Msk                                  (0x1fUL << LCD_PAL207_R04_0_Pos)
#define LCD_PAL207_G04_0_Pos                                  5
#define LCD_PAL207_G04_0_Msk                                  (0x1fUL << LCD_PAL207_G04_0_Pos)
#define LCD_PAL207_B04_0_Pos                                  10
#define LCD_PAL207_B04_0_Msk                                  (0x1fUL << LCD_PAL207_B04_0_Pos)
#define LCD_PAL207_I0_Pos                                     15
#define LCD_PAL207_I0_Msk                                     (0x01UL << LCD_PAL207_I0_Pos)
#define LCD_PAL207_R14_0_Pos                                  16
#define LCD_PAL207_R14_0_Msk                                  (0x1fUL << LCD_PAL207_R14_0_Pos)
#define LCD_PAL207_G14_0_Pos                                  21
#define LCD_PAL207_G14_0_Msk                                  (0x1fUL << LCD_PAL207_G14_0_Pos)
#define LCD_PAL207_B14_0_Pos                                  26
#define LCD_PAL207_B14_0_Msk                                  (0x1fUL << LCD_PAL207_B14_0_Pos)
#define LCD_PAL207_I1_Pos                                     31
#define LCD_PAL207_I1_Msk                                     (0x01UL << LCD_PAL207_I1_Pos)

// ---------------------------------------  LCD_PAL208  -------------------------------------------
#define LCD_PAL208_R04_0_Pos                                  0
#define LCD_PAL208_R04_0_Msk                                  (0x1fUL << LCD_PAL208_R04_0_Pos)
#define LCD_PAL208_G04_0_Pos                                  5
#define LCD_PAL208_G04_0_Msk                                  (0x1fUL << LCD_PAL208_G04_0_Pos)
#define LCD_PAL208_B04_0_Pos                                  10
#define LCD_PAL208_B04_0_Msk                                  (0x1fUL << LCD_PAL208_B04_0_Pos)
#define LCD_PAL208_I0_Pos                                     15
#define LCD_PAL208_I0_Msk                                     (0x01UL << LCD_PAL208_I0_Pos)
#define LCD_PAL208_R14_0_Pos                                  16
#define LCD_PAL208_R14_0_Msk                                  (0x1fUL << LCD_PAL208_R14_0_Pos)
#define LCD_PAL208_G14_0_Pos                                  21
#define LCD_PAL208_G14_0_Msk                                  (0x1fUL << LCD_PAL208_G14_0_Pos)
#define LCD_PAL208_B14_0_Pos                                  26
#define LCD_PAL208_B14_0_Msk                                  (0x1fUL << LCD_PAL208_B14_0_Pos)
#define LCD_PAL208_I1_Pos                                     31
#define LCD_PAL208_I1_Msk                                     (0x01UL << LCD_PAL208_I1_Pos)

// ---------------------------------------  LCD_PAL209  -------------------------------------------
#define LCD_PAL209_R04_0_Pos                                  0
#define LCD_PAL209_R04_0_Msk                                  (0x1fUL << LCD_PAL209_R04_0_Pos)
#define LCD_PAL209_G04_0_Pos                                  5
#define LCD_PAL209_G04_0_Msk                                  (0x1fUL << LCD_PAL209_G04_0_Pos)
#define LCD_PAL209_B04_0_Pos                                  10
#define LCD_PAL209_B04_0_Msk                                  (0x1fUL << LCD_PAL209_B04_0_Pos)
#define LCD_PAL209_I0_Pos                                     15
#define LCD_PAL209_I0_Msk                                     (0x01UL << LCD_PAL209_I0_Pos)
#define LCD_PAL209_R14_0_Pos                                  16
#define LCD_PAL209_R14_0_Msk                                  (0x1fUL << LCD_PAL209_R14_0_Pos)
#define LCD_PAL209_G14_0_Pos                                  21
#define LCD_PAL209_G14_0_Msk                                  (0x1fUL << LCD_PAL209_G14_0_Pos)
#define LCD_PAL209_B14_0_Pos                                  26
#define LCD_PAL209_B14_0_Msk                                  (0x1fUL << LCD_PAL209_B14_0_Pos)
#define LCD_PAL209_I1_Pos                                     31
#define LCD_PAL209_I1_Msk                                     (0x01UL << LCD_PAL209_I1_Pos)

// ---------------------------------------  LCD_PAL210  -------------------------------------------
#define LCD_PAL210_R04_0_Pos                                  0
#define LCD_PAL210_R04_0_Msk                                  (0x1fUL << LCD_PAL210_R04_0_Pos)
#define LCD_PAL210_G04_0_Pos                                  5
#define LCD_PAL210_G04_0_Msk                                  (0x1fUL << LCD_PAL210_G04_0_Pos)
#define LCD_PAL210_B04_0_Pos                                  10
#define LCD_PAL210_B04_0_Msk                                  (0x1fUL << LCD_PAL210_B04_0_Pos)
#define LCD_PAL210_I0_Pos                                     15
#define LCD_PAL210_I0_Msk                                     (0x01UL << LCD_PAL210_I0_Pos)
#define LCD_PAL210_R14_0_Pos                                  16
#define LCD_PAL210_R14_0_Msk                                  (0x1fUL << LCD_PAL210_R14_0_Pos)
#define LCD_PAL210_G14_0_Pos                                  21
#define LCD_PAL210_G14_0_Msk                                  (0x1fUL << LCD_PAL210_G14_0_Pos)
#define LCD_PAL210_B14_0_Pos                                  26
#define LCD_PAL210_B14_0_Msk                                  (0x1fUL << LCD_PAL210_B14_0_Pos)
#define LCD_PAL210_I1_Pos                                     31
#define LCD_PAL210_I1_Msk                                     (0x01UL << LCD_PAL210_I1_Pos)

// ---------------------------------------  LCD_PAL211  -------------------------------------------
#define LCD_PAL211_R04_0_Pos                                  0
#define LCD_PAL211_R04_0_Msk                                  (0x1fUL << LCD_PAL211_R04_0_Pos)
#define LCD_PAL211_G04_0_Pos                                  5
#define LCD_PAL211_G04_0_Msk                                  (0x1fUL << LCD_PAL211_G04_0_Pos)
#define LCD_PAL211_B04_0_Pos                                  10
#define LCD_PAL211_B04_0_Msk                                  (0x1fUL << LCD_PAL211_B04_0_Pos)
#define LCD_PAL211_I0_Pos                                     15
#define LCD_PAL211_I0_Msk                                     (0x01UL << LCD_PAL211_I0_Pos)
#define LCD_PAL211_R14_0_Pos                                  16
#define LCD_PAL211_R14_0_Msk                                  (0x1fUL << LCD_PAL211_R14_0_Pos)
#define LCD_PAL211_G14_0_Pos                                  21
#define LCD_PAL211_G14_0_Msk                                  (0x1fUL << LCD_PAL211_G14_0_Pos)
#define LCD_PAL211_B14_0_Pos                                  26
#define LCD_PAL211_B14_0_Msk                                  (0x1fUL << LCD_PAL211_B14_0_Pos)
#define LCD_PAL211_I1_Pos                                     31
#define LCD_PAL211_I1_Msk                                     (0x01UL << LCD_PAL211_I1_Pos)

// ---------------------------------------  LCD_PAL212  -------------------------------------------
#define LCD_PAL212_R04_0_Pos                                  0
#define LCD_PAL212_R04_0_Msk                                  (0x1fUL << LCD_PAL212_R04_0_Pos)
#define LCD_PAL212_G04_0_Pos                                  5
#define LCD_PAL212_G04_0_Msk                                  (0x1fUL << LCD_PAL212_G04_0_Pos)
#define LCD_PAL212_B04_0_Pos                                  10
#define LCD_PAL212_B04_0_Msk                                  (0x1fUL << LCD_PAL212_B04_0_Pos)
#define LCD_PAL212_I0_Pos                                     15
#define LCD_PAL212_I0_Msk                                     (0x01UL << LCD_PAL212_I0_Pos)
#define LCD_PAL212_R14_0_Pos                                  16
#define LCD_PAL212_R14_0_Msk                                  (0x1fUL << LCD_PAL212_R14_0_Pos)
#define LCD_PAL212_G14_0_Pos                                  21
#define LCD_PAL212_G14_0_Msk                                  (0x1fUL << LCD_PAL212_G14_0_Pos)
#define LCD_PAL212_B14_0_Pos                                  26
#define LCD_PAL212_B14_0_Msk                                  (0x1fUL << LCD_PAL212_B14_0_Pos)
#define LCD_PAL212_I1_Pos                                     31
#define LCD_PAL212_I1_Msk                                     (0x01UL << LCD_PAL212_I1_Pos)

// ---------------------------------------  LCD_PAL213  -------------------------------------------
#define LCD_PAL213_R04_0_Pos                                  0
#define LCD_PAL213_R04_0_Msk                                  (0x1fUL << LCD_PAL213_R04_0_Pos)
#define LCD_PAL213_G04_0_Pos                                  5
#define LCD_PAL213_G04_0_Msk                                  (0x1fUL << LCD_PAL213_G04_0_Pos)
#define LCD_PAL213_B04_0_Pos                                  10
#define LCD_PAL213_B04_0_Msk                                  (0x1fUL << LCD_PAL213_B04_0_Pos)
#define LCD_PAL213_I0_Pos                                     15
#define LCD_PAL213_I0_Msk                                     (0x01UL << LCD_PAL213_I0_Pos)
#define LCD_PAL213_R14_0_Pos                                  16
#define LCD_PAL213_R14_0_Msk                                  (0x1fUL << LCD_PAL213_R14_0_Pos)
#define LCD_PAL213_G14_0_Pos                                  21
#define LCD_PAL213_G14_0_Msk                                  (0x1fUL << LCD_PAL213_G14_0_Pos)
#define LCD_PAL213_B14_0_Pos                                  26
#define LCD_PAL213_B14_0_Msk                                  (0x1fUL << LCD_PAL213_B14_0_Pos)
#define LCD_PAL213_I1_Pos                                     31
#define LCD_PAL213_I1_Msk                                     (0x01UL << LCD_PAL213_I1_Pos)

// ---------------------------------------  LCD_PAL214  -------------------------------------------
#define LCD_PAL214_R04_0_Pos                                  0
#define LCD_PAL214_R04_0_Msk                                  (0x1fUL << LCD_PAL214_R04_0_Pos)
#define LCD_PAL214_G04_0_Pos                                  5
#define LCD_PAL214_G04_0_Msk                                  (0x1fUL << LCD_PAL214_G04_0_Pos)
#define LCD_PAL214_B04_0_Pos                                  10
#define LCD_PAL214_B04_0_Msk                                  (0x1fUL << LCD_PAL214_B04_0_Pos)
#define LCD_PAL214_I0_Pos                                     15
#define LCD_PAL214_I0_Msk                                     (0x01UL << LCD_PAL214_I0_Pos)
#define LCD_PAL214_R14_0_Pos                                  16
#define LCD_PAL214_R14_0_Msk                                  (0x1fUL << LCD_PAL214_R14_0_Pos)
#define LCD_PAL214_G14_0_Pos                                  21
#define LCD_PAL214_G14_0_Msk                                  (0x1fUL << LCD_PAL214_G14_0_Pos)
#define LCD_PAL214_B14_0_Pos                                  26
#define LCD_PAL214_B14_0_Msk                                  (0x1fUL << LCD_PAL214_B14_0_Pos)
#define LCD_PAL214_I1_Pos                                     31
#define LCD_PAL214_I1_Msk                                     (0x01UL << LCD_PAL214_I1_Pos)

// ---------------------------------------  LCD_PAL215  -------------------------------------------
#define LCD_PAL215_R04_0_Pos                                  0
#define LCD_PAL215_R04_0_Msk                                  (0x1fUL << LCD_PAL215_R04_0_Pos)
#define LCD_PAL215_G04_0_Pos                                  5
#define LCD_PAL215_G04_0_Msk                                  (0x1fUL << LCD_PAL215_G04_0_Pos)
#define LCD_PAL215_B04_0_Pos                                  10
#define LCD_PAL215_B04_0_Msk                                  (0x1fUL << LCD_PAL215_B04_0_Pos)
#define LCD_PAL215_I0_Pos                                     15
#define LCD_PAL215_I0_Msk                                     (0x01UL << LCD_PAL215_I0_Pos)
#define LCD_PAL215_R14_0_Pos                                  16
#define LCD_PAL215_R14_0_Msk                                  (0x1fUL << LCD_PAL215_R14_0_Pos)
#define LCD_PAL215_G14_0_Pos                                  21
#define LCD_PAL215_G14_0_Msk                                  (0x1fUL << LCD_PAL215_G14_0_Pos)
#define LCD_PAL215_B14_0_Pos                                  26
#define LCD_PAL215_B14_0_Msk                                  (0x1fUL << LCD_PAL215_B14_0_Pos)
#define LCD_PAL215_I1_Pos                                     31
#define LCD_PAL215_I1_Msk                                     (0x01UL << LCD_PAL215_I1_Pos)

// ---------------------------------------  LCD_PAL216  -------------------------------------------
#define LCD_PAL216_R04_0_Pos                                  0
#define LCD_PAL216_R04_0_Msk                                  (0x1fUL << LCD_PAL216_R04_0_Pos)
#define LCD_PAL216_G04_0_Pos                                  5
#define LCD_PAL216_G04_0_Msk                                  (0x1fUL << LCD_PAL216_G04_0_Pos)
#define LCD_PAL216_B04_0_Pos                                  10
#define LCD_PAL216_B04_0_Msk                                  (0x1fUL << LCD_PAL216_B04_0_Pos)
#define LCD_PAL216_I0_Pos                                     15
#define LCD_PAL216_I0_Msk                                     (0x01UL << LCD_PAL216_I0_Pos)
#define LCD_PAL216_R14_0_Pos                                  16
#define LCD_PAL216_R14_0_Msk                                  (0x1fUL << LCD_PAL216_R14_0_Pos)
#define LCD_PAL216_G14_0_Pos                                  21
#define LCD_PAL216_G14_0_Msk                                  (0x1fUL << LCD_PAL216_G14_0_Pos)
#define LCD_PAL216_B14_0_Pos                                  26
#define LCD_PAL216_B14_0_Msk                                  (0x1fUL << LCD_PAL216_B14_0_Pos)
#define LCD_PAL216_I1_Pos                                     31
#define LCD_PAL216_I1_Msk                                     (0x01UL << LCD_PAL216_I1_Pos)

// ---------------------------------------  LCD_PAL217  -------------------------------------------
#define LCD_PAL217_R04_0_Pos                                  0
#define LCD_PAL217_R04_0_Msk                                  (0x1fUL << LCD_PAL217_R04_0_Pos)
#define LCD_PAL217_G04_0_Pos                                  5
#define LCD_PAL217_G04_0_Msk                                  (0x1fUL << LCD_PAL217_G04_0_Pos)
#define LCD_PAL217_B04_0_Pos                                  10
#define LCD_PAL217_B04_0_Msk                                  (0x1fUL << LCD_PAL217_B04_0_Pos)
#define LCD_PAL217_I0_Pos                                     15
#define LCD_PAL217_I0_Msk                                     (0x01UL << LCD_PAL217_I0_Pos)
#define LCD_PAL217_R14_0_Pos                                  16
#define LCD_PAL217_R14_0_Msk                                  (0x1fUL << LCD_PAL217_R14_0_Pos)
#define LCD_PAL217_G14_0_Pos                                  21
#define LCD_PAL217_G14_0_Msk                                  (0x1fUL << LCD_PAL217_G14_0_Pos)
#define LCD_PAL217_B14_0_Pos                                  26
#define LCD_PAL217_B14_0_Msk                                  (0x1fUL << LCD_PAL217_B14_0_Pos)
#define LCD_PAL217_I1_Pos                                     31
#define LCD_PAL217_I1_Msk                                     (0x01UL << LCD_PAL217_I1_Pos)

// ---------------------------------------  LCD_PAL218  -------------------------------------------
#define LCD_PAL218_R04_0_Pos                                  0
#define LCD_PAL218_R04_0_Msk                                  (0x1fUL << LCD_PAL218_R04_0_Pos)
#define LCD_PAL218_G04_0_Pos                                  5
#define LCD_PAL218_G04_0_Msk                                  (0x1fUL << LCD_PAL218_G04_0_Pos)
#define LCD_PAL218_B04_0_Pos                                  10
#define LCD_PAL218_B04_0_Msk                                  (0x1fUL << LCD_PAL218_B04_0_Pos)
#define LCD_PAL218_I0_Pos                                     15
#define LCD_PAL218_I0_Msk                                     (0x01UL << LCD_PAL218_I0_Pos)
#define LCD_PAL218_R14_0_Pos                                  16
#define LCD_PAL218_R14_0_Msk                                  (0x1fUL << LCD_PAL218_R14_0_Pos)
#define LCD_PAL218_G14_0_Pos                                  21
#define LCD_PAL218_G14_0_Msk                                  (0x1fUL << LCD_PAL218_G14_0_Pos)
#define LCD_PAL218_B14_0_Pos                                  26
#define LCD_PAL218_B14_0_Msk                                  (0x1fUL << LCD_PAL218_B14_0_Pos)
#define LCD_PAL218_I1_Pos                                     31
#define LCD_PAL218_I1_Msk                                     (0x01UL << LCD_PAL218_I1_Pos)

// ---------------------------------------  LCD_PAL219  -------------------------------------------
#define LCD_PAL219_R04_0_Pos                                  0
#define LCD_PAL219_R04_0_Msk                                  (0x1fUL << LCD_PAL219_R04_0_Pos)
#define LCD_PAL219_G04_0_Pos                                  5
#define LCD_PAL219_G04_0_Msk                                  (0x1fUL << LCD_PAL219_G04_0_Pos)
#define LCD_PAL219_B04_0_Pos                                  10
#define LCD_PAL219_B04_0_Msk                                  (0x1fUL << LCD_PAL219_B04_0_Pos)
#define LCD_PAL219_I0_Pos                                     15
#define LCD_PAL219_I0_Msk                                     (0x01UL << LCD_PAL219_I0_Pos)
#define LCD_PAL219_R14_0_Pos                                  16
#define LCD_PAL219_R14_0_Msk                                  (0x1fUL << LCD_PAL219_R14_0_Pos)
#define LCD_PAL219_G14_0_Pos                                  21
#define LCD_PAL219_G14_0_Msk                                  (0x1fUL << LCD_PAL219_G14_0_Pos)
#define LCD_PAL219_B14_0_Pos                                  26
#define LCD_PAL219_B14_0_Msk                                  (0x1fUL << LCD_PAL219_B14_0_Pos)
#define LCD_PAL219_I1_Pos                                     31
#define LCD_PAL219_I1_Msk                                     (0x01UL << LCD_PAL219_I1_Pos)

// ---------------------------------------  LCD_PAL220  -------------------------------------------
#define LCD_PAL220_R04_0_Pos                                  0
#define LCD_PAL220_R04_0_Msk                                  (0x1fUL << LCD_PAL220_R04_0_Pos)
#define LCD_PAL220_G04_0_Pos                                  5
#define LCD_PAL220_G04_0_Msk                                  (0x1fUL << LCD_PAL220_G04_0_Pos)
#define LCD_PAL220_B04_0_Pos                                  10
#define LCD_PAL220_B04_0_Msk                                  (0x1fUL << LCD_PAL220_B04_0_Pos)
#define LCD_PAL220_I0_Pos                                     15
#define LCD_PAL220_I0_Msk                                     (0x01UL << LCD_PAL220_I0_Pos)
#define LCD_PAL220_R14_0_Pos                                  16
#define LCD_PAL220_R14_0_Msk                                  (0x1fUL << LCD_PAL220_R14_0_Pos)
#define LCD_PAL220_G14_0_Pos                                  21
#define LCD_PAL220_G14_0_Msk                                  (0x1fUL << LCD_PAL220_G14_0_Pos)
#define LCD_PAL220_B14_0_Pos                                  26
#define LCD_PAL220_B14_0_Msk                                  (0x1fUL << LCD_PAL220_B14_0_Pos)
#define LCD_PAL220_I1_Pos                                     31
#define LCD_PAL220_I1_Msk                                     (0x01UL << LCD_PAL220_I1_Pos)

// ---------------------------------------  LCD_PAL221  -------------------------------------------
#define LCD_PAL221_R04_0_Pos                                  0
#define LCD_PAL221_R04_0_Msk                                  (0x1fUL << LCD_PAL221_R04_0_Pos)
#define LCD_PAL221_G04_0_Pos                                  5
#define LCD_PAL221_G04_0_Msk                                  (0x1fUL << LCD_PAL221_G04_0_Pos)
#define LCD_PAL221_B04_0_Pos                                  10
#define LCD_PAL221_B04_0_Msk                                  (0x1fUL << LCD_PAL221_B04_0_Pos)
#define LCD_PAL221_I0_Pos                                     15
#define LCD_PAL221_I0_Msk                                     (0x01UL << LCD_PAL221_I0_Pos)
#define LCD_PAL221_R14_0_Pos                                  16
#define LCD_PAL221_R14_0_Msk                                  (0x1fUL << LCD_PAL221_R14_0_Pos)
#define LCD_PAL221_G14_0_Pos                                  21
#define LCD_PAL221_G14_0_Msk                                  (0x1fUL << LCD_PAL221_G14_0_Pos)
#define LCD_PAL221_B14_0_Pos                                  26
#define LCD_PAL221_B14_0_Msk                                  (0x1fUL << LCD_PAL221_B14_0_Pos)
#define LCD_PAL221_I1_Pos                                     31
#define LCD_PAL221_I1_Msk                                     (0x01UL << LCD_PAL221_I1_Pos)

// ---------------------------------------  LCD_PAL222  -------------------------------------------
#define LCD_PAL222_R04_0_Pos                                  0
#define LCD_PAL222_R04_0_Msk                                  (0x1fUL << LCD_PAL222_R04_0_Pos)
#define LCD_PAL222_G04_0_Pos                                  5
#define LCD_PAL222_G04_0_Msk                                  (0x1fUL << LCD_PAL222_G04_0_Pos)
#define LCD_PAL222_B04_0_Pos                                  10
#define LCD_PAL222_B04_0_Msk                                  (0x1fUL << LCD_PAL222_B04_0_Pos)
#define LCD_PAL222_I0_Pos                                     15
#define LCD_PAL222_I0_Msk                                     (0x01UL << LCD_PAL222_I0_Pos)
#define LCD_PAL222_R14_0_Pos                                  16
#define LCD_PAL222_R14_0_Msk                                  (0x1fUL << LCD_PAL222_R14_0_Pos)
#define LCD_PAL222_G14_0_Pos                                  21
#define LCD_PAL222_G14_0_Msk                                  (0x1fUL << LCD_PAL222_G14_0_Pos)
#define LCD_PAL222_B14_0_Pos                                  26
#define LCD_PAL222_B14_0_Msk                                  (0x1fUL << LCD_PAL222_B14_0_Pos)
#define LCD_PAL222_I1_Pos                                     31
#define LCD_PAL222_I1_Msk                                     (0x01UL << LCD_PAL222_I1_Pos)

// ---------------------------------------  LCD_PAL223  -------------------------------------------
#define LCD_PAL223_R04_0_Pos                                  0
#define LCD_PAL223_R04_0_Msk                                  (0x1fUL << LCD_PAL223_R04_0_Pos)
#define LCD_PAL223_G04_0_Pos                                  5
#define LCD_PAL223_G04_0_Msk                                  (0x1fUL << LCD_PAL223_G04_0_Pos)
#define LCD_PAL223_B04_0_Pos                                  10
#define LCD_PAL223_B04_0_Msk                                  (0x1fUL << LCD_PAL223_B04_0_Pos)
#define LCD_PAL223_I0_Pos                                     15
#define LCD_PAL223_I0_Msk                                     (0x01UL << LCD_PAL223_I0_Pos)
#define LCD_PAL223_R14_0_Pos                                  16
#define LCD_PAL223_R14_0_Msk                                  (0x1fUL << LCD_PAL223_R14_0_Pos)
#define LCD_PAL223_G14_0_Pos                                  21
#define LCD_PAL223_G14_0_Msk                                  (0x1fUL << LCD_PAL223_G14_0_Pos)
#define LCD_PAL223_B14_0_Pos                                  26
#define LCD_PAL223_B14_0_Msk                                  (0x1fUL << LCD_PAL223_B14_0_Pos)
#define LCD_PAL223_I1_Pos                                     31
#define LCD_PAL223_I1_Msk                                     (0x01UL << LCD_PAL223_I1_Pos)

// ---------------------------------------  LCD_PAL224  -------------------------------------------
#define LCD_PAL224_R04_0_Pos                                  0
#define LCD_PAL224_R04_0_Msk                                  (0x1fUL << LCD_PAL224_R04_0_Pos)
#define LCD_PAL224_G04_0_Pos                                  5
#define LCD_PAL224_G04_0_Msk                                  (0x1fUL << LCD_PAL224_G04_0_Pos)
#define LCD_PAL224_B04_0_Pos                                  10
#define LCD_PAL224_B04_0_Msk                                  (0x1fUL << LCD_PAL224_B04_0_Pos)
#define LCD_PAL224_I0_Pos                                     15
#define LCD_PAL224_I0_Msk                                     (0x01UL << LCD_PAL224_I0_Pos)
#define LCD_PAL224_R14_0_Pos                                  16
#define LCD_PAL224_R14_0_Msk                                  (0x1fUL << LCD_PAL224_R14_0_Pos)
#define LCD_PAL224_G14_0_Pos                                  21
#define LCD_PAL224_G14_0_Msk                                  (0x1fUL << LCD_PAL224_G14_0_Pos)
#define LCD_PAL224_B14_0_Pos                                  26
#define LCD_PAL224_B14_0_Msk                                  (0x1fUL << LCD_PAL224_B14_0_Pos)
#define LCD_PAL224_I1_Pos                                     31
#define LCD_PAL224_I1_Msk                                     (0x01UL << LCD_PAL224_I1_Pos)

// ---------------------------------------  LCD_PAL225  -------------------------------------------
#define LCD_PAL225_R04_0_Pos                                  0
#define LCD_PAL225_R04_0_Msk                                  (0x1fUL << LCD_PAL225_R04_0_Pos)
#define LCD_PAL225_G04_0_Pos                                  5
#define LCD_PAL225_G04_0_Msk                                  (0x1fUL << LCD_PAL225_G04_0_Pos)
#define LCD_PAL225_B04_0_Pos                                  10
#define LCD_PAL225_B04_0_Msk                                  (0x1fUL << LCD_PAL225_B04_0_Pos)
#define LCD_PAL225_I0_Pos                                     15
#define LCD_PAL225_I0_Msk                                     (0x01UL << LCD_PAL225_I0_Pos)
#define LCD_PAL225_R14_0_Pos                                  16
#define LCD_PAL225_R14_0_Msk                                  (0x1fUL << LCD_PAL225_R14_0_Pos)
#define LCD_PAL225_G14_0_Pos                                  21
#define LCD_PAL225_G14_0_Msk                                  (0x1fUL << LCD_PAL225_G14_0_Pos)
#define LCD_PAL225_B14_0_Pos                                  26
#define LCD_PAL225_B14_0_Msk                                  (0x1fUL << LCD_PAL225_B14_0_Pos)
#define LCD_PAL225_I1_Pos                                     31
#define LCD_PAL225_I1_Msk                                     (0x01UL << LCD_PAL225_I1_Pos)

// ---------------------------------------  LCD_PAL226  -------------------------------------------
#define LCD_PAL226_R04_0_Pos                                  0
#define LCD_PAL226_R04_0_Msk                                  (0x1fUL << LCD_PAL226_R04_0_Pos)
#define LCD_PAL226_G04_0_Pos                                  5
#define LCD_PAL226_G04_0_Msk                                  (0x1fUL << LCD_PAL226_G04_0_Pos)
#define LCD_PAL226_B04_0_Pos                                  10
#define LCD_PAL226_B04_0_Msk                                  (0x1fUL << LCD_PAL226_B04_0_Pos)
#define LCD_PAL226_I0_Pos                                     15
#define LCD_PAL226_I0_Msk                                     (0x01UL << LCD_PAL226_I0_Pos)
#define LCD_PAL226_R14_0_Pos                                  16
#define LCD_PAL226_R14_0_Msk                                  (0x1fUL << LCD_PAL226_R14_0_Pos)
#define LCD_PAL226_G14_0_Pos                                  21
#define LCD_PAL226_G14_0_Msk                                  (0x1fUL << LCD_PAL226_G14_0_Pos)
#define LCD_PAL226_B14_0_Pos                                  26
#define LCD_PAL226_B14_0_Msk                                  (0x1fUL << LCD_PAL226_B14_0_Pos)
#define LCD_PAL226_I1_Pos                                     31
#define LCD_PAL226_I1_Msk                                     (0x01UL << LCD_PAL226_I1_Pos)

// ---------------------------------------  LCD_PAL227  -------------------------------------------
#define LCD_PAL227_R04_0_Pos                                  0
#define LCD_PAL227_R04_0_Msk                                  (0x1fUL << LCD_PAL227_R04_0_Pos)
#define LCD_PAL227_G04_0_Pos                                  5
#define LCD_PAL227_G04_0_Msk                                  (0x1fUL << LCD_PAL227_G04_0_Pos)
#define LCD_PAL227_B04_0_Pos                                  10
#define LCD_PAL227_B04_0_Msk                                  (0x1fUL << LCD_PAL227_B04_0_Pos)
#define LCD_PAL227_I0_Pos                                     15
#define LCD_PAL227_I0_Msk                                     (0x01UL << LCD_PAL227_I0_Pos)
#define LCD_PAL227_R14_0_Pos                                  16
#define LCD_PAL227_R14_0_Msk                                  (0x1fUL << LCD_PAL227_R14_0_Pos)
#define LCD_PAL227_G14_0_Pos                                  21
#define LCD_PAL227_G14_0_Msk                                  (0x1fUL << LCD_PAL227_G14_0_Pos)
#define LCD_PAL227_B14_0_Pos                                  26
#define LCD_PAL227_B14_0_Msk                                  (0x1fUL << LCD_PAL227_B14_0_Pos)
#define LCD_PAL227_I1_Pos                                     31
#define LCD_PAL227_I1_Msk                                     (0x01UL << LCD_PAL227_I1_Pos)

// ---------------------------------------  LCD_PAL228  -------------------------------------------
#define LCD_PAL228_R04_0_Pos                                  0
#define LCD_PAL228_R04_0_Msk                                  (0x1fUL << LCD_PAL228_R04_0_Pos)
#define LCD_PAL228_G04_0_Pos                                  5
#define LCD_PAL228_G04_0_Msk                                  (0x1fUL << LCD_PAL228_G04_0_Pos)
#define LCD_PAL228_B04_0_Pos                                  10
#define LCD_PAL228_B04_0_Msk                                  (0x1fUL << LCD_PAL228_B04_0_Pos)
#define LCD_PAL228_I0_Pos                                     15
#define LCD_PAL228_I0_Msk                                     (0x01UL << LCD_PAL228_I0_Pos)
#define LCD_PAL228_R14_0_Pos                                  16
#define LCD_PAL228_R14_0_Msk                                  (0x1fUL << LCD_PAL228_R14_0_Pos)
#define LCD_PAL228_G14_0_Pos                                  21
#define LCD_PAL228_G14_0_Msk                                  (0x1fUL << LCD_PAL228_G14_0_Pos)
#define LCD_PAL228_B14_0_Pos                                  26
#define LCD_PAL228_B14_0_Msk                                  (0x1fUL << LCD_PAL228_B14_0_Pos)
#define LCD_PAL228_I1_Pos                                     31
#define LCD_PAL228_I1_Msk                                     (0x01UL << LCD_PAL228_I1_Pos)

// ---------------------------------------  LCD_PAL229  -------------------------------------------
#define LCD_PAL229_R04_0_Pos                                  0
#define LCD_PAL229_R04_0_Msk                                  (0x1fUL << LCD_PAL229_R04_0_Pos)
#define LCD_PAL229_G04_0_Pos                                  5
#define LCD_PAL229_G04_0_Msk                                  (0x1fUL << LCD_PAL229_G04_0_Pos)
#define LCD_PAL229_B04_0_Pos                                  10
#define LCD_PAL229_B04_0_Msk                                  (0x1fUL << LCD_PAL229_B04_0_Pos)
#define LCD_PAL229_I0_Pos                                     15
#define LCD_PAL229_I0_Msk                                     (0x01UL << LCD_PAL229_I0_Pos)
#define LCD_PAL229_R14_0_Pos                                  16
#define LCD_PAL229_R14_0_Msk                                  (0x1fUL << LCD_PAL229_R14_0_Pos)
#define LCD_PAL229_G14_0_Pos                                  21
#define LCD_PAL229_G14_0_Msk                                  (0x1fUL << LCD_PAL229_G14_0_Pos)
#define LCD_PAL229_B14_0_Pos                                  26
#define LCD_PAL229_B14_0_Msk                                  (0x1fUL << LCD_PAL229_B14_0_Pos)
#define LCD_PAL229_I1_Pos                                     31
#define LCD_PAL229_I1_Msk                                     (0x01UL << LCD_PAL229_I1_Pos)

// ---------------------------------------  LCD_PAL230  -------------------------------------------
#define LCD_PAL230_R04_0_Pos                                  0
#define LCD_PAL230_R04_0_Msk                                  (0x1fUL << LCD_PAL230_R04_0_Pos)
#define LCD_PAL230_G04_0_Pos                                  5
#define LCD_PAL230_G04_0_Msk                                  (0x1fUL << LCD_PAL230_G04_0_Pos)
#define LCD_PAL230_B04_0_Pos                                  10
#define LCD_PAL230_B04_0_Msk                                  (0x1fUL << LCD_PAL230_B04_0_Pos)
#define LCD_PAL230_I0_Pos                                     15
#define LCD_PAL230_I0_Msk                                     (0x01UL << LCD_PAL230_I0_Pos)
#define LCD_PAL230_R14_0_Pos                                  16
#define LCD_PAL230_R14_0_Msk                                  (0x1fUL << LCD_PAL230_R14_0_Pos)
#define LCD_PAL230_G14_0_Pos                                  21
#define LCD_PAL230_G14_0_Msk                                  (0x1fUL << LCD_PAL230_G14_0_Pos)
#define LCD_PAL230_B14_0_Pos                                  26
#define LCD_PAL230_B14_0_Msk                                  (0x1fUL << LCD_PAL230_B14_0_Pos)
#define LCD_PAL230_I1_Pos                                     31
#define LCD_PAL230_I1_Msk                                     (0x01UL << LCD_PAL230_I1_Pos)

// ---------------------------------------  LCD_PAL231  -------------------------------------------
#define LCD_PAL231_R04_0_Pos                                  0
#define LCD_PAL231_R04_0_Msk                                  (0x1fUL << LCD_PAL231_R04_0_Pos)
#define LCD_PAL231_G04_0_Pos                                  5
#define LCD_PAL231_G04_0_Msk                                  (0x1fUL << LCD_PAL231_G04_0_Pos)
#define LCD_PAL231_B04_0_Pos                                  10
#define LCD_PAL231_B04_0_Msk                                  (0x1fUL << LCD_PAL231_B04_0_Pos)
#define LCD_PAL231_I0_Pos                                     15
#define LCD_PAL231_I0_Msk                                     (0x01UL << LCD_PAL231_I0_Pos)
#define LCD_PAL231_R14_0_Pos                                  16
#define LCD_PAL231_R14_0_Msk                                  (0x1fUL << LCD_PAL231_R14_0_Pos)
#define LCD_PAL231_G14_0_Pos                                  21
#define LCD_PAL231_G14_0_Msk                                  (0x1fUL << LCD_PAL231_G14_0_Pos)
#define LCD_PAL231_B14_0_Pos                                  26
#define LCD_PAL231_B14_0_Msk                                  (0x1fUL << LCD_PAL231_B14_0_Pos)
#define LCD_PAL231_I1_Pos                                     31
#define LCD_PAL231_I1_Msk                                     (0x01UL << LCD_PAL231_I1_Pos)

// ---------------------------------------  LCD_PAL232  -------------------------------------------
#define LCD_PAL232_R04_0_Pos                                  0
#define LCD_PAL232_R04_0_Msk                                  (0x1fUL << LCD_PAL232_R04_0_Pos)
#define LCD_PAL232_G04_0_Pos                                  5
#define LCD_PAL232_G04_0_Msk                                  (0x1fUL << LCD_PAL232_G04_0_Pos)
#define LCD_PAL232_B04_0_Pos                                  10
#define LCD_PAL232_B04_0_Msk                                  (0x1fUL << LCD_PAL232_B04_0_Pos)
#define LCD_PAL232_I0_Pos                                     15
#define LCD_PAL232_I0_Msk                                     (0x01UL << LCD_PAL232_I0_Pos)
#define LCD_PAL232_R14_0_Pos                                  16
#define LCD_PAL232_R14_0_Msk                                  (0x1fUL << LCD_PAL232_R14_0_Pos)
#define LCD_PAL232_G14_0_Pos                                  21
#define LCD_PAL232_G14_0_Msk                                  (0x1fUL << LCD_PAL232_G14_0_Pos)
#define LCD_PAL232_B14_0_Pos                                  26
#define LCD_PAL232_B14_0_Msk                                  (0x1fUL << LCD_PAL232_B14_0_Pos)
#define LCD_PAL232_I1_Pos                                     31
#define LCD_PAL232_I1_Msk                                     (0x01UL << LCD_PAL232_I1_Pos)

// ---------------------------------------  LCD_PAL233  -------------------------------------------
#define LCD_PAL233_R04_0_Pos                                  0
#define LCD_PAL233_R04_0_Msk                                  (0x1fUL << LCD_PAL233_R04_0_Pos)
#define LCD_PAL233_G04_0_Pos                                  5
#define LCD_PAL233_G04_0_Msk                                  (0x1fUL << LCD_PAL233_G04_0_Pos)
#define LCD_PAL233_B04_0_Pos                                  10
#define LCD_PAL233_B04_0_Msk                                  (0x1fUL << LCD_PAL233_B04_0_Pos)
#define LCD_PAL233_I0_Pos                                     15
#define LCD_PAL233_I0_Msk                                     (0x01UL << LCD_PAL233_I0_Pos)
#define LCD_PAL233_R14_0_Pos                                  16
#define LCD_PAL233_R14_0_Msk                                  (0x1fUL << LCD_PAL233_R14_0_Pos)
#define LCD_PAL233_G14_0_Pos                                  21
#define LCD_PAL233_G14_0_Msk                                  (0x1fUL << LCD_PAL233_G14_0_Pos)
#define LCD_PAL233_B14_0_Pos                                  26
#define LCD_PAL233_B14_0_Msk                                  (0x1fUL << LCD_PAL233_B14_0_Pos)
#define LCD_PAL233_I1_Pos                                     31
#define LCD_PAL233_I1_Msk                                     (0x01UL << LCD_PAL233_I1_Pos)

// ---------------------------------------  LCD_PAL234  -------------------------------------------
#define LCD_PAL234_R04_0_Pos                                  0
#define LCD_PAL234_R04_0_Msk                                  (0x1fUL << LCD_PAL234_R04_0_Pos)
#define LCD_PAL234_G04_0_Pos                                  5
#define LCD_PAL234_G04_0_Msk                                  (0x1fUL << LCD_PAL234_G04_0_Pos)
#define LCD_PAL234_B04_0_Pos                                  10
#define LCD_PAL234_B04_0_Msk                                  (0x1fUL << LCD_PAL234_B04_0_Pos)
#define LCD_PAL234_I0_Pos                                     15
#define LCD_PAL234_I0_Msk                                     (0x01UL << LCD_PAL234_I0_Pos)
#define LCD_PAL234_R14_0_Pos                                  16
#define LCD_PAL234_R14_0_Msk                                  (0x1fUL << LCD_PAL234_R14_0_Pos)
#define LCD_PAL234_G14_0_Pos                                  21
#define LCD_PAL234_G14_0_Msk                                  (0x1fUL << LCD_PAL234_G14_0_Pos)
#define LCD_PAL234_B14_0_Pos                                  26
#define LCD_PAL234_B14_0_Msk                                  (0x1fUL << LCD_PAL234_B14_0_Pos)
#define LCD_PAL234_I1_Pos                                     31
#define LCD_PAL234_I1_Msk                                     (0x01UL << LCD_PAL234_I1_Pos)

// ---------------------------------------  LCD_PAL235  -------------------------------------------
#define LCD_PAL235_R04_0_Pos                                  0
#define LCD_PAL235_R04_0_Msk                                  (0x1fUL << LCD_PAL235_R04_0_Pos)
#define LCD_PAL235_G04_0_Pos                                  5
#define LCD_PAL235_G04_0_Msk                                  (0x1fUL << LCD_PAL235_G04_0_Pos)
#define LCD_PAL235_B04_0_Pos                                  10
#define LCD_PAL235_B04_0_Msk                                  (0x1fUL << LCD_PAL235_B04_0_Pos)
#define LCD_PAL235_I0_Pos                                     15
#define LCD_PAL235_I0_Msk                                     (0x01UL << LCD_PAL235_I0_Pos)
#define LCD_PAL235_R14_0_Pos                                  16
#define LCD_PAL235_R14_0_Msk                                  (0x1fUL << LCD_PAL235_R14_0_Pos)
#define LCD_PAL235_G14_0_Pos                                  21
#define LCD_PAL235_G14_0_Msk                                  (0x1fUL << LCD_PAL235_G14_0_Pos)
#define LCD_PAL235_B14_0_Pos                                  26
#define LCD_PAL235_B14_0_Msk                                  (0x1fUL << LCD_PAL235_B14_0_Pos)
#define LCD_PAL235_I1_Pos                                     31
#define LCD_PAL235_I1_Msk                                     (0x01UL << LCD_PAL235_I1_Pos)

// ---------------------------------------  LCD_PAL236  -------------------------------------------
#define LCD_PAL236_R04_0_Pos                                  0
#define LCD_PAL236_R04_0_Msk                                  (0x1fUL << LCD_PAL236_R04_0_Pos)
#define LCD_PAL236_G04_0_Pos                                  5
#define LCD_PAL236_G04_0_Msk                                  (0x1fUL << LCD_PAL236_G04_0_Pos)
#define LCD_PAL236_B04_0_Pos                                  10
#define LCD_PAL236_B04_0_Msk                                  (0x1fUL << LCD_PAL236_B04_0_Pos)
#define LCD_PAL236_I0_Pos                                     15
#define LCD_PAL236_I0_Msk                                     (0x01UL << LCD_PAL236_I0_Pos)
#define LCD_PAL236_R14_0_Pos                                  16
#define LCD_PAL236_R14_0_Msk                                  (0x1fUL << LCD_PAL236_R14_0_Pos)
#define LCD_PAL236_G14_0_Pos                                  21
#define LCD_PAL236_G14_0_Msk                                  (0x1fUL << LCD_PAL236_G14_0_Pos)
#define LCD_PAL236_B14_0_Pos                                  26
#define LCD_PAL236_B14_0_Msk                                  (0x1fUL << LCD_PAL236_B14_0_Pos)
#define LCD_PAL236_I1_Pos                                     31
#define LCD_PAL236_I1_Msk                                     (0x01UL << LCD_PAL236_I1_Pos)

// ---------------------------------------  LCD_PAL237  -------------------------------------------
#define LCD_PAL237_R04_0_Pos                                  0
#define LCD_PAL237_R04_0_Msk                                  (0x1fUL << LCD_PAL237_R04_0_Pos)
#define LCD_PAL237_G04_0_Pos                                  5
#define LCD_PAL237_G04_0_Msk                                  (0x1fUL << LCD_PAL237_G04_0_Pos)
#define LCD_PAL237_B04_0_Pos                                  10
#define LCD_PAL237_B04_0_Msk                                  (0x1fUL << LCD_PAL237_B04_0_Pos)
#define LCD_PAL237_I0_Pos                                     15
#define LCD_PAL237_I0_Msk                                     (0x01UL << LCD_PAL237_I0_Pos)
#define LCD_PAL237_R14_0_Pos                                  16
#define LCD_PAL237_R14_0_Msk                                  (0x1fUL << LCD_PAL237_R14_0_Pos)
#define LCD_PAL237_G14_0_Pos                                  21
#define LCD_PAL237_G14_0_Msk                                  (0x1fUL << LCD_PAL237_G14_0_Pos)
#define LCD_PAL237_B14_0_Pos                                  26
#define LCD_PAL237_B14_0_Msk                                  (0x1fUL << LCD_PAL237_B14_0_Pos)
#define LCD_PAL237_I1_Pos                                     31
#define LCD_PAL237_I1_Msk                                     (0x01UL << LCD_PAL237_I1_Pos)

// ---------------------------------------  LCD_PAL238  -------------------------------------------
#define LCD_PAL238_R04_0_Pos                                  0
#define LCD_PAL238_R04_0_Msk                                  (0x1fUL << LCD_PAL238_R04_0_Pos)
#define LCD_PAL238_G04_0_Pos                                  5
#define LCD_PAL238_G04_0_Msk                                  (0x1fUL << LCD_PAL238_G04_0_Pos)
#define LCD_PAL238_B04_0_Pos                                  10
#define LCD_PAL238_B04_0_Msk                                  (0x1fUL << LCD_PAL238_B04_0_Pos)
#define LCD_PAL238_I0_Pos                                     15
#define LCD_PAL238_I0_Msk                                     (0x01UL << LCD_PAL238_I0_Pos)
#define LCD_PAL238_R14_0_Pos                                  16
#define LCD_PAL238_R14_0_Msk                                  (0x1fUL << LCD_PAL238_R14_0_Pos)
#define LCD_PAL238_G14_0_Pos                                  21
#define LCD_PAL238_G14_0_Msk                                  (0x1fUL << LCD_PAL238_G14_0_Pos)
#define LCD_PAL238_B14_0_Pos                                  26
#define LCD_PAL238_B14_0_Msk                                  (0x1fUL << LCD_PAL238_B14_0_Pos)
#define LCD_PAL238_I1_Pos                                     31
#define LCD_PAL238_I1_Msk                                     (0x01UL << LCD_PAL238_I1_Pos)

// ---------------------------------------  LCD_PAL239  -------------------------------------------
#define LCD_PAL239_R04_0_Pos                                  0
#define LCD_PAL239_R04_0_Msk                                  (0x1fUL << LCD_PAL239_R04_0_Pos)
#define LCD_PAL239_G04_0_Pos                                  5
#define LCD_PAL239_G04_0_Msk                                  (0x1fUL << LCD_PAL239_G04_0_Pos)
#define LCD_PAL239_B04_0_Pos                                  10
#define LCD_PAL239_B04_0_Msk                                  (0x1fUL << LCD_PAL239_B04_0_Pos)
#define LCD_PAL239_I0_Pos                                     15
#define LCD_PAL239_I0_Msk                                     (0x01UL << LCD_PAL239_I0_Pos)
#define LCD_PAL239_R14_0_Pos                                  16
#define LCD_PAL239_R14_0_Msk                                  (0x1fUL << LCD_PAL239_R14_0_Pos)
#define LCD_PAL239_G14_0_Pos                                  21
#define LCD_PAL239_G14_0_Msk                                  (0x1fUL << LCD_PAL239_G14_0_Pos)
#define LCD_PAL239_B14_0_Pos                                  26
#define LCD_PAL239_B14_0_Msk                                  (0x1fUL << LCD_PAL239_B14_0_Pos)
#define LCD_PAL239_I1_Pos                                     31
#define LCD_PAL239_I1_Msk                                     (0x01UL << LCD_PAL239_I1_Pos)

// ---------------------------------------  LCD_PAL240  -------------------------------------------
#define LCD_PAL240_R04_0_Pos                                  0
#define LCD_PAL240_R04_0_Msk                                  (0x1fUL << LCD_PAL240_R04_0_Pos)
#define LCD_PAL240_G04_0_Pos                                  5
#define LCD_PAL240_G04_0_Msk                                  (0x1fUL << LCD_PAL240_G04_0_Pos)
#define LCD_PAL240_B04_0_Pos                                  10
#define LCD_PAL240_B04_0_Msk                                  (0x1fUL << LCD_PAL240_B04_0_Pos)
#define LCD_PAL240_I0_Pos                                     15
#define LCD_PAL240_I0_Msk                                     (0x01UL << LCD_PAL240_I0_Pos)
#define LCD_PAL240_R14_0_Pos                                  16
#define LCD_PAL240_R14_0_Msk                                  (0x1fUL << LCD_PAL240_R14_0_Pos)
#define LCD_PAL240_G14_0_Pos                                  21
#define LCD_PAL240_G14_0_Msk                                  (0x1fUL << LCD_PAL240_G14_0_Pos)
#define LCD_PAL240_B14_0_Pos                                  26
#define LCD_PAL240_B14_0_Msk                                  (0x1fUL << LCD_PAL240_B14_0_Pos)
#define LCD_PAL240_I1_Pos                                     31
#define LCD_PAL240_I1_Msk                                     (0x01UL << LCD_PAL240_I1_Pos)

// ---------------------------------------  LCD_PAL241  -------------------------------------------
#define LCD_PAL241_R04_0_Pos                                  0
#define LCD_PAL241_R04_0_Msk                                  (0x1fUL << LCD_PAL241_R04_0_Pos)
#define LCD_PAL241_G04_0_Pos                                  5
#define LCD_PAL241_G04_0_Msk                                  (0x1fUL << LCD_PAL241_G04_0_Pos)
#define LCD_PAL241_B04_0_Pos                                  10
#define LCD_PAL241_B04_0_Msk                                  (0x1fUL << LCD_PAL241_B04_0_Pos)
#define LCD_PAL241_I0_Pos                                     15
#define LCD_PAL241_I0_Msk                                     (0x01UL << LCD_PAL241_I0_Pos)
#define LCD_PAL241_R14_0_Pos                                  16
#define LCD_PAL241_R14_0_Msk                                  (0x1fUL << LCD_PAL241_R14_0_Pos)
#define LCD_PAL241_G14_0_Pos                                  21
#define LCD_PAL241_G14_0_Msk                                  (0x1fUL << LCD_PAL241_G14_0_Pos)
#define LCD_PAL241_B14_0_Pos                                  26
#define LCD_PAL241_B14_0_Msk                                  (0x1fUL << LCD_PAL241_B14_0_Pos)
#define LCD_PAL241_I1_Pos                                     31
#define LCD_PAL241_I1_Msk                                     (0x01UL << LCD_PAL241_I1_Pos)

// ---------------------------------------  LCD_PAL242  -------------------------------------------
#define LCD_PAL242_R04_0_Pos                                  0
#define LCD_PAL242_R04_0_Msk                                  (0x1fUL << LCD_PAL242_R04_0_Pos)
#define LCD_PAL242_G04_0_Pos                                  5
#define LCD_PAL242_G04_0_Msk                                  (0x1fUL << LCD_PAL242_G04_0_Pos)
#define LCD_PAL242_B04_0_Pos                                  10
#define LCD_PAL242_B04_0_Msk                                  (0x1fUL << LCD_PAL242_B04_0_Pos)
#define LCD_PAL242_I0_Pos                                     15
#define LCD_PAL242_I0_Msk                                     (0x01UL << LCD_PAL242_I0_Pos)
#define LCD_PAL242_R14_0_Pos                                  16
#define LCD_PAL242_R14_0_Msk                                  (0x1fUL << LCD_PAL242_R14_0_Pos)
#define LCD_PAL242_G14_0_Pos                                  21
#define LCD_PAL242_G14_0_Msk                                  (0x1fUL << LCD_PAL242_G14_0_Pos)
#define LCD_PAL242_B14_0_Pos                                  26
#define LCD_PAL242_B14_0_Msk                                  (0x1fUL << LCD_PAL242_B14_0_Pos)
#define LCD_PAL242_I1_Pos                                     31
#define LCD_PAL242_I1_Msk                                     (0x01UL << LCD_PAL242_I1_Pos)

// ---------------------------------------  LCD_PAL243  -------------------------------------------
#define LCD_PAL243_R04_0_Pos                                  0
#define LCD_PAL243_R04_0_Msk                                  (0x1fUL << LCD_PAL243_R04_0_Pos)
#define LCD_PAL243_G04_0_Pos                                  5
#define LCD_PAL243_G04_0_Msk                                  (0x1fUL << LCD_PAL243_G04_0_Pos)
#define LCD_PAL243_B04_0_Pos                                  10
#define LCD_PAL243_B04_0_Msk                                  (0x1fUL << LCD_PAL243_B04_0_Pos)
#define LCD_PAL243_I0_Pos                                     15
#define LCD_PAL243_I0_Msk                                     (0x01UL << LCD_PAL243_I0_Pos)
#define LCD_PAL243_R14_0_Pos                                  16
#define LCD_PAL243_R14_0_Msk                                  (0x1fUL << LCD_PAL243_R14_0_Pos)
#define LCD_PAL243_G14_0_Pos                                  21
#define LCD_PAL243_G14_0_Msk                                  (0x1fUL << LCD_PAL243_G14_0_Pos)
#define LCD_PAL243_B14_0_Pos                                  26
#define LCD_PAL243_B14_0_Msk                                  (0x1fUL << LCD_PAL243_B14_0_Pos)
#define LCD_PAL243_I1_Pos                                     31
#define LCD_PAL243_I1_Msk                                     (0x01UL << LCD_PAL243_I1_Pos)

// ---------------------------------------  LCD_PAL244  -------------------------------------------
#define LCD_PAL244_R04_0_Pos                                  0
#define LCD_PAL244_R04_0_Msk                                  (0x1fUL << LCD_PAL244_R04_0_Pos)
#define LCD_PAL244_G04_0_Pos                                  5
#define LCD_PAL244_G04_0_Msk                                  (0x1fUL << LCD_PAL244_G04_0_Pos)
#define LCD_PAL244_B04_0_Pos                                  10
#define LCD_PAL244_B04_0_Msk                                  (0x1fUL << LCD_PAL244_B04_0_Pos)
#define LCD_PAL244_I0_Pos                                     15
#define LCD_PAL244_I0_Msk                                     (0x01UL << LCD_PAL244_I0_Pos)
#define LCD_PAL244_R14_0_Pos                                  16
#define LCD_PAL244_R14_0_Msk                                  (0x1fUL << LCD_PAL244_R14_0_Pos)
#define LCD_PAL244_G14_0_Pos                                  21
#define LCD_PAL244_G14_0_Msk                                  (0x1fUL << LCD_PAL244_G14_0_Pos)
#define LCD_PAL244_B14_0_Pos                                  26
#define LCD_PAL244_B14_0_Msk                                  (0x1fUL << LCD_PAL244_B14_0_Pos)
#define LCD_PAL244_I1_Pos                                     31
#define LCD_PAL244_I1_Msk                                     (0x01UL << LCD_PAL244_I1_Pos)

// ---------------------------------------  LCD_PAL245  -------------------------------------------
#define LCD_PAL245_R04_0_Pos                                  0
#define LCD_PAL245_R04_0_Msk                                  (0x1fUL << LCD_PAL245_R04_0_Pos)
#define LCD_PAL245_G04_0_Pos                                  5
#define LCD_PAL245_G04_0_Msk                                  (0x1fUL << LCD_PAL245_G04_0_Pos)
#define LCD_PAL245_B04_0_Pos                                  10
#define LCD_PAL245_B04_0_Msk                                  (0x1fUL << LCD_PAL245_B04_0_Pos)
#define LCD_PAL245_I0_Pos                                     15
#define LCD_PAL245_I0_Msk                                     (0x01UL << LCD_PAL245_I0_Pos)
#define LCD_PAL245_R14_0_Pos                                  16
#define LCD_PAL245_R14_0_Msk                                  (0x1fUL << LCD_PAL245_R14_0_Pos)
#define LCD_PAL245_G14_0_Pos                                  21
#define LCD_PAL245_G14_0_Msk                                  (0x1fUL << LCD_PAL245_G14_0_Pos)
#define LCD_PAL245_B14_0_Pos                                  26
#define LCD_PAL245_B14_0_Msk                                  (0x1fUL << LCD_PAL245_B14_0_Pos)
#define LCD_PAL245_I1_Pos                                     31
#define LCD_PAL245_I1_Msk                                     (0x01UL << LCD_PAL245_I1_Pos)

// ---------------------------------------  LCD_PAL246  -------------------------------------------
#define LCD_PAL246_R04_0_Pos                                  0
#define LCD_PAL246_R04_0_Msk                                  (0x1fUL << LCD_PAL246_R04_0_Pos)
#define LCD_PAL246_G04_0_Pos                                  5
#define LCD_PAL246_G04_0_Msk                                  (0x1fUL << LCD_PAL246_G04_0_Pos)
#define LCD_PAL246_B04_0_Pos                                  10
#define LCD_PAL246_B04_0_Msk                                  (0x1fUL << LCD_PAL246_B04_0_Pos)
#define LCD_PAL246_I0_Pos                                     15
#define LCD_PAL246_I0_Msk                                     (0x01UL << LCD_PAL246_I0_Pos)
#define LCD_PAL246_R14_0_Pos                                  16
#define LCD_PAL246_R14_0_Msk                                  (0x1fUL << LCD_PAL246_R14_0_Pos)
#define LCD_PAL246_G14_0_Pos                                  21
#define LCD_PAL246_G14_0_Msk                                  (0x1fUL << LCD_PAL246_G14_0_Pos)
#define LCD_PAL246_B14_0_Pos                                  26
#define LCD_PAL246_B14_0_Msk                                  (0x1fUL << LCD_PAL246_B14_0_Pos)
#define LCD_PAL246_I1_Pos                                     31
#define LCD_PAL246_I1_Msk                                     (0x01UL << LCD_PAL246_I1_Pos)

// ---------------------------------------  LCD_PAL247  -------------------------------------------
#define LCD_PAL247_R04_0_Pos                                  0
#define LCD_PAL247_R04_0_Msk                                  (0x1fUL << LCD_PAL247_R04_0_Pos)
#define LCD_PAL247_G04_0_Pos                                  5
#define LCD_PAL247_G04_0_Msk                                  (0x1fUL << LCD_PAL247_G04_0_Pos)
#define LCD_PAL247_B04_0_Pos                                  10
#define LCD_PAL247_B04_0_Msk                                  (0x1fUL << LCD_PAL247_B04_0_Pos)
#define LCD_PAL247_I0_Pos                                     15
#define LCD_PAL247_I0_Msk                                     (0x01UL << LCD_PAL247_I0_Pos)
#define LCD_PAL247_R14_0_Pos                                  16
#define LCD_PAL247_R14_0_Msk                                  (0x1fUL << LCD_PAL247_R14_0_Pos)
#define LCD_PAL247_G14_0_Pos                                  21
#define LCD_PAL247_G14_0_Msk                                  (0x1fUL << LCD_PAL247_G14_0_Pos)
#define LCD_PAL247_B14_0_Pos                                  26
#define LCD_PAL247_B14_0_Msk                                  (0x1fUL << LCD_PAL247_B14_0_Pos)
#define LCD_PAL247_I1_Pos                                     31
#define LCD_PAL247_I1_Msk                                     (0x01UL << LCD_PAL247_I1_Pos)

// ---------------------------------------  LCD_PAL248  -------------------------------------------
#define LCD_PAL248_R04_0_Pos                                  0
#define LCD_PAL248_R04_0_Msk                                  (0x1fUL << LCD_PAL248_R04_0_Pos)
#define LCD_PAL248_G04_0_Pos                                  5
#define LCD_PAL248_G04_0_Msk                                  (0x1fUL << LCD_PAL248_G04_0_Pos)
#define LCD_PAL248_B04_0_Pos                                  10
#define LCD_PAL248_B04_0_Msk                                  (0x1fUL << LCD_PAL248_B04_0_Pos)
#define LCD_PAL248_I0_Pos                                     15
#define LCD_PAL248_I0_Msk                                     (0x01UL << LCD_PAL248_I0_Pos)
#define LCD_PAL248_R14_0_Pos                                  16
#define LCD_PAL248_R14_0_Msk                                  (0x1fUL << LCD_PAL248_R14_0_Pos)
#define LCD_PAL248_G14_0_Pos                                  21
#define LCD_PAL248_G14_0_Msk                                  (0x1fUL << LCD_PAL248_G14_0_Pos)
#define LCD_PAL248_B14_0_Pos                                  26
#define LCD_PAL248_B14_0_Msk                                  (0x1fUL << LCD_PAL248_B14_0_Pos)
#define LCD_PAL248_I1_Pos                                     31
#define LCD_PAL248_I1_Msk                                     (0x01UL << LCD_PAL248_I1_Pos)

// ---------------------------------------  LCD_PAL249  -------------------------------------------
#define LCD_PAL249_R04_0_Pos                                  0
#define LCD_PAL249_R04_0_Msk                                  (0x1fUL << LCD_PAL249_R04_0_Pos)
#define LCD_PAL249_G04_0_Pos                                  5
#define LCD_PAL249_G04_0_Msk                                  (0x1fUL << LCD_PAL249_G04_0_Pos)
#define LCD_PAL249_B04_0_Pos                                  10
#define LCD_PAL249_B04_0_Msk                                  (0x1fUL << LCD_PAL249_B04_0_Pos)
#define LCD_PAL249_I0_Pos                                     15
#define LCD_PAL249_I0_Msk                                     (0x01UL << LCD_PAL249_I0_Pos)
#define LCD_PAL249_R14_0_Pos                                  16
#define LCD_PAL249_R14_0_Msk                                  (0x1fUL << LCD_PAL249_R14_0_Pos)
#define LCD_PAL249_G14_0_Pos                                  21
#define LCD_PAL249_G14_0_Msk                                  (0x1fUL << LCD_PAL249_G14_0_Pos)
#define LCD_PAL249_B14_0_Pos                                  26
#define LCD_PAL249_B14_0_Msk                                  (0x1fUL << LCD_PAL249_B14_0_Pos)
#define LCD_PAL249_I1_Pos                                     31
#define LCD_PAL249_I1_Msk                                     (0x01UL << LCD_PAL249_I1_Pos)

// ---------------------------------------  LCD_PAL250  -------------------------------------------
#define LCD_PAL250_R04_0_Pos                                  0
#define LCD_PAL250_R04_0_Msk                                  (0x1fUL << LCD_PAL250_R04_0_Pos)
#define LCD_PAL250_G04_0_Pos                                  5
#define LCD_PAL250_G04_0_Msk                                  (0x1fUL << LCD_PAL250_G04_0_Pos)
#define LCD_PAL250_B04_0_Pos                                  10
#define LCD_PAL250_B04_0_Msk                                  (0x1fUL << LCD_PAL250_B04_0_Pos)
#define LCD_PAL250_I0_Pos                                     15
#define LCD_PAL250_I0_Msk                                     (0x01UL << LCD_PAL250_I0_Pos)
#define LCD_PAL250_R14_0_Pos                                  16
#define LCD_PAL250_R14_0_Msk                                  (0x1fUL << LCD_PAL250_R14_0_Pos)
#define LCD_PAL250_G14_0_Pos                                  21
#define LCD_PAL250_G14_0_Msk                                  (0x1fUL << LCD_PAL250_G14_0_Pos)
#define LCD_PAL250_B14_0_Pos                                  26
#define LCD_PAL250_B14_0_Msk                                  (0x1fUL << LCD_PAL250_B14_0_Pos)
#define LCD_PAL250_I1_Pos                                     31
#define LCD_PAL250_I1_Msk                                     (0x01UL << LCD_PAL250_I1_Pos)

// ---------------------------------------  LCD_PAL251  -------------------------------------------
#define LCD_PAL251_R04_0_Pos                                  0
#define LCD_PAL251_R04_0_Msk                                  (0x1fUL << LCD_PAL251_R04_0_Pos)
#define LCD_PAL251_G04_0_Pos                                  5
#define LCD_PAL251_G04_0_Msk                                  (0x1fUL << LCD_PAL251_G04_0_Pos)
#define LCD_PAL251_B04_0_Pos                                  10
#define LCD_PAL251_B04_0_Msk                                  (0x1fUL << LCD_PAL251_B04_0_Pos)
#define LCD_PAL251_I0_Pos                                     15
#define LCD_PAL251_I0_Msk                                     (0x01UL << LCD_PAL251_I0_Pos)
#define LCD_PAL251_R14_0_Pos                                  16
#define LCD_PAL251_R14_0_Msk                                  (0x1fUL << LCD_PAL251_R14_0_Pos)
#define LCD_PAL251_G14_0_Pos                                  21
#define LCD_PAL251_G14_0_Msk                                  (0x1fUL << LCD_PAL251_G14_0_Pos)
#define LCD_PAL251_B14_0_Pos                                  26
#define LCD_PAL251_B14_0_Msk                                  (0x1fUL << LCD_PAL251_B14_0_Pos)
#define LCD_PAL251_I1_Pos                                     31
#define LCD_PAL251_I1_Msk                                     (0x01UL << LCD_PAL251_I1_Pos)

// ---------------------------------------  LCD_PAL252  -------------------------------------------
#define LCD_PAL252_R04_0_Pos                                  0
#define LCD_PAL252_R04_0_Msk                                  (0x1fUL << LCD_PAL252_R04_0_Pos)
#define LCD_PAL252_G04_0_Pos                                  5
#define LCD_PAL252_G04_0_Msk                                  (0x1fUL << LCD_PAL252_G04_0_Pos)
#define LCD_PAL252_B04_0_Pos                                  10
#define LCD_PAL252_B04_0_Msk                                  (0x1fUL << LCD_PAL252_B04_0_Pos)
#define LCD_PAL252_I0_Pos                                     15
#define LCD_PAL252_I0_Msk                                     (0x01UL << LCD_PAL252_I0_Pos)
#define LCD_PAL252_R14_0_Pos                                  16
#define LCD_PAL252_R14_0_Msk                                  (0x1fUL << LCD_PAL252_R14_0_Pos)
#define LCD_PAL252_G14_0_Pos                                  21
#define LCD_PAL252_G14_0_Msk                                  (0x1fUL << LCD_PAL252_G14_0_Pos)
#define LCD_PAL252_B14_0_Pos                                  26
#define LCD_PAL252_B14_0_Msk                                  (0x1fUL << LCD_PAL252_B14_0_Pos)
#define LCD_PAL252_I1_Pos                                     31
#define LCD_PAL252_I1_Msk                                     (0x01UL << LCD_PAL252_I1_Pos)

// ---------------------------------------  LCD_PAL253  -------------------------------------------
#define LCD_PAL253_R04_0_Pos                                  0
#define LCD_PAL253_R04_0_Msk                                  (0x1fUL << LCD_PAL253_R04_0_Pos)
#define LCD_PAL253_G04_0_Pos                                  5
#define LCD_PAL253_G04_0_Msk                                  (0x1fUL << LCD_PAL253_G04_0_Pos)
#define LCD_PAL253_B04_0_Pos                                  10
#define LCD_PAL253_B04_0_Msk                                  (0x1fUL << LCD_PAL253_B04_0_Pos)
#define LCD_PAL253_I0_Pos                                     15
#define LCD_PAL253_I0_Msk                                     (0x01UL << LCD_PAL253_I0_Pos)
#define LCD_PAL253_R14_0_Pos                                  16
#define LCD_PAL253_R14_0_Msk                                  (0x1fUL << LCD_PAL253_R14_0_Pos)
#define LCD_PAL253_G14_0_Pos                                  21
#define LCD_PAL253_G14_0_Msk                                  (0x1fUL << LCD_PAL253_G14_0_Pos)
#define LCD_PAL253_B14_0_Pos                                  26
#define LCD_PAL253_B14_0_Msk                                  (0x1fUL << LCD_PAL253_B14_0_Pos)
#define LCD_PAL253_I1_Pos                                     31
#define LCD_PAL253_I1_Msk                                     (0x01UL << LCD_PAL253_I1_Pos)

// ---------------------------------------  LCD_PAL254  -------------------------------------------
#define LCD_PAL254_R04_0_Pos                                  0
#define LCD_PAL254_R04_0_Msk                                  (0x1fUL << LCD_PAL254_R04_0_Pos)
#define LCD_PAL254_G04_0_Pos                                  5
#define LCD_PAL254_G04_0_Msk                                  (0x1fUL << LCD_PAL254_G04_0_Pos)
#define LCD_PAL254_B04_0_Pos                                  10
#define LCD_PAL254_B04_0_Msk                                  (0x1fUL << LCD_PAL254_B04_0_Pos)
#define LCD_PAL254_I0_Pos                                     15
#define LCD_PAL254_I0_Msk                                     (0x01UL << LCD_PAL254_I0_Pos)
#define LCD_PAL254_R14_0_Pos                                  16
#define LCD_PAL254_R14_0_Msk                                  (0x1fUL << LCD_PAL254_R14_0_Pos)
#define LCD_PAL254_G14_0_Pos                                  21
#define LCD_PAL254_G14_0_Msk                                  (0x1fUL << LCD_PAL254_G14_0_Pos)
#define LCD_PAL254_B14_0_Pos                                  26
#define LCD_PAL254_B14_0_Msk                                  (0x1fUL << LCD_PAL254_B14_0_Pos)
#define LCD_PAL254_I1_Pos                                     31
#define LCD_PAL254_I1_Msk                                     (0x01UL << LCD_PAL254_I1_Pos)

// ---------------------------------------  LCD_PAL255  -------------------------------------------
#define LCD_PAL255_R04_0_Pos                                  0
#define LCD_PAL255_R04_0_Msk                                  (0x1fUL << LCD_PAL255_R04_0_Pos)
#define LCD_PAL255_G04_0_Pos                                  5
#define LCD_PAL255_G04_0_Msk                                  (0x1fUL << LCD_PAL255_G04_0_Pos)
#define LCD_PAL255_B04_0_Pos                                  10
#define LCD_PAL255_B04_0_Msk                                  (0x1fUL << LCD_PAL255_B04_0_Pos)
#define LCD_PAL255_I0_Pos                                     15
#define LCD_PAL255_I0_Msk                                     (0x01UL << LCD_PAL255_I0_Pos)
#define LCD_PAL255_R14_0_Pos                                  16
#define LCD_PAL255_R14_0_Msk                                  (0x1fUL << LCD_PAL255_R14_0_Pos)
#define LCD_PAL255_G14_0_Pos                                  21
#define LCD_PAL255_G14_0_Msk                                  (0x1fUL << LCD_PAL255_G14_0_Pos)
#define LCD_PAL255_B14_0_Pos                                  26
#define LCD_PAL255_B14_0_Msk                                  (0x1fUL << LCD_PAL255_B14_0_Pos)
#define LCD_PAL255_I1_Pos                                     31
#define LCD_PAL255_I1_Msk                                     (0x01UL << LCD_PAL255_I1_Pos)

// --------------------------------------  LCD_CRSR_IMG0  -----------------------------------------
#define LCD_CRSR_IMG0_CRSR_IMG_Pos                            0
#define LCD_CRSR_IMG0_CRSR_IMG_Msk                            (0xffffffffUL << LCD_CRSR_IMG0_CRSR_IMG_Pos)

// --------------------------------------  LCD_CRSR_IMG1  -----------------------------------------
#define LCD_CRSR_IMG1_CRSR_IMG_Pos                            0
#define LCD_CRSR_IMG1_CRSR_IMG_Msk                            (0xffffffffUL << LCD_CRSR_IMG1_CRSR_IMG_Pos)

// --------------------------------------  LCD_CRSR_IMG2  -----------------------------------------
#define LCD_CRSR_IMG2_CRSR_IMG_Pos                            0
#define LCD_CRSR_IMG2_CRSR_IMG_Msk                            (0xffffffffUL << LCD_CRSR_IMG2_CRSR_IMG_Pos)

// --------------------------------------  LCD_CRSR_IMG3  -----------------------------------------
#define LCD_CRSR_IMG3_CRSR_IMG_Pos                            0
#define LCD_CRSR_IMG3_CRSR_IMG_Msk                            (0xffffffffUL << LCD_CRSR_IMG3_CRSR_IMG_Pos)

// --------------------------------------  LCD_CRSR_IMG4  -----------------------------------------
#define LCD_CRSR_IMG4_CRSR_IMG_Pos                            0
#define LCD_CRSR_IMG4_CRSR_IMG_Msk                            (0xffffffffUL << LCD_CRSR_IMG4_CRSR_IMG_Pos)

// --------------------------------------  LCD_CRSR_IMG5  -----------------------------------------
#define LCD_CRSR_IMG5_CRSR_IMG_Pos                            0
#define LCD_CRSR_IMG5_CRSR_IMG_Msk                            (0xffffffffUL << LCD_CRSR_IMG5_CRSR_IMG_Pos)

// --------------------------------------  LCD_CRSR_IMG6  -----------------------------------------
#define LCD_CRSR_IMG6_CRSR_IMG_Pos                            0
#define LCD_CRSR_IMG6_CRSR_IMG_Msk                            (0xffffffffUL << LCD_CRSR_IMG6_CRSR_IMG_Pos)

// --------------------------------------  LCD_CRSR_IMG7  -----------------------------------------
#define LCD_CRSR_IMG7_CRSR_IMG_Pos                            0
#define LCD_CRSR_IMG7_CRSR_IMG_Msk                            (0xffffffffUL << LCD_CRSR_IMG7_CRSR_IMG_Pos)

// --------------------------------------  LCD_CRSR_IMG8  -----------------------------------------
#define LCD_CRSR_IMG8_CRSR_IMG_Pos                            0
#define LCD_CRSR_IMG8_CRSR_IMG_Msk                            (0xffffffffUL << LCD_CRSR_IMG8_CRSR_IMG_Pos)

// --------------------------------------  LCD_CRSR_IMG9  -----------------------------------------
#define LCD_CRSR_IMG9_CRSR_IMG_Pos                            0
#define LCD_CRSR_IMG9_CRSR_IMG_Msk                            (0xffffffffUL << LCD_CRSR_IMG9_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG10  -----------------------------------------
#define LCD_CRSR_IMG10_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG10_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG10_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG11  -----------------------------------------
#define LCD_CRSR_IMG11_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG11_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG11_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG12  -----------------------------------------
#define LCD_CRSR_IMG12_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG12_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG12_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG13  -----------------------------------------
#define LCD_CRSR_IMG13_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG13_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG13_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG14  -----------------------------------------
#define LCD_CRSR_IMG14_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG14_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG14_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG15  -----------------------------------------
#define LCD_CRSR_IMG15_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG15_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG15_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG16  -----------------------------------------
#define LCD_CRSR_IMG16_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG16_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG16_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG17  -----------------------------------------
#define LCD_CRSR_IMG17_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG17_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG17_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG18  -----------------------------------------
#define LCD_CRSR_IMG18_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG18_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG18_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG19  -----------------------------------------
#define LCD_CRSR_IMG19_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG19_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG19_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG20  -----------------------------------------
#define LCD_CRSR_IMG20_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG20_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG20_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG21  -----------------------------------------
#define LCD_CRSR_IMG21_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG21_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG21_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG22  -----------------------------------------
#define LCD_CRSR_IMG22_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG22_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG22_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG23  -----------------------------------------
#define LCD_CRSR_IMG23_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG23_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG23_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG24  -----------------------------------------
#define LCD_CRSR_IMG24_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG24_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG24_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG25  -----------------------------------------
#define LCD_CRSR_IMG25_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG25_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG25_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG26  -----------------------------------------
#define LCD_CRSR_IMG26_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG26_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG26_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG27  -----------------------------------------
#define LCD_CRSR_IMG27_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG27_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG27_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG28  -----------------------------------------
#define LCD_CRSR_IMG28_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG28_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG28_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG29  -----------------------------------------
#define LCD_CRSR_IMG29_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG29_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG29_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG30  -----------------------------------------
#define LCD_CRSR_IMG30_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG30_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG30_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG31  -----------------------------------------
#define LCD_CRSR_IMG31_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG31_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG31_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG32  -----------------------------------------
#define LCD_CRSR_IMG32_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG32_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG32_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG33  -----------------------------------------
#define LCD_CRSR_IMG33_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG33_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG33_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG34  -----------------------------------------
#define LCD_CRSR_IMG34_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG34_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG34_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG35  -----------------------------------------
#define LCD_CRSR_IMG35_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG35_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG35_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG36  -----------------------------------------
#define LCD_CRSR_IMG36_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG36_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG36_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG37  -----------------------------------------
#define LCD_CRSR_IMG37_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG37_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG37_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG38  -----------------------------------------
#define LCD_CRSR_IMG38_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG38_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG38_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG39  -----------------------------------------
#define LCD_CRSR_IMG39_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG39_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG39_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG40  -----------------------------------------
#define LCD_CRSR_IMG40_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG40_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG40_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG41  -----------------------------------------
#define LCD_CRSR_IMG41_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG41_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG41_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG42  -----------------------------------------
#define LCD_CRSR_IMG42_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG42_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG42_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG43  -----------------------------------------
#define LCD_CRSR_IMG43_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG43_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG43_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG44  -----------------------------------------
#define LCD_CRSR_IMG44_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG44_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG44_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG45  -----------------------------------------
#define LCD_CRSR_IMG45_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG45_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG45_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG46  -----------------------------------------
#define LCD_CRSR_IMG46_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG46_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG46_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG47  -----------------------------------------
#define LCD_CRSR_IMG47_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG47_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG47_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG48  -----------------------------------------
#define LCD_CRSR_IMG48_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG48_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG48_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG49  -----------------------------------------
#define LCD_CRSR_IMG49_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG49_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG49_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG50  -----------------------------------------
#define LCD_CRSR_IMG50_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG50_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG50_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG51  -----------------------------------------
#define LCD_CRSR_IMG51_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG51_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG51_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG52  -----------------------------------------
#define LCD_CRSR_IMG52_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG52_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG52_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG53  -----------------------------------------
#define LCD_CRSR_IMG53_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG53_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG53_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG54  -----------------------------------------
#define LCD_CRSR_IMG54_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG54_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG54_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG55  -----------------------------------------
#define LCD_CRSR_IMG55_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG55_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG55_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG56  -----------------------------------------
#define LCD_CRSR_IMG56_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG56_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG56_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG57  -----------------------------------------
#define LCD_CRSR_IMG57_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG57_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG57_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG58  -----------------------------------------
#define LCD_CRSR_IMG58_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG58_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG58_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG59  -----------------------------------------
#define LCD_CRSR_IMG59_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG59_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG59_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG60  -----------------------------------------
#define LCD_CRSR_IMG60_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG60_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG60_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG61  -----------------------------------------
#define LCD_CRSR_IMG61_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG61_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG61_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG62  -----------------------------------------
#define LCD_CRSR_IMG62_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG62_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG62_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG63  -----------------------------------------
#define LCD_CRSR_IMG63_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG63_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG63_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG64  -----------------------------------------
#define LCD_CRSR_IMG64_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG64_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG64_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG65  -----------------------------------------
#define LCD_CRSR_IMG65_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG65_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG65_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG66  -----------------------------------------
#define LCD_CRSR_IMG66_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG66_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG66_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG67  -----------------------------------------
#define LCD_CRSR_IMG67_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG67_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG67_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG68  -----------------------------------------
#define LCD_CRSR_IMG68_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG68_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG68_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG69  -----------------------------------------
#define LCD_CRSR_IMG69_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG69_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG69_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG70  -----------------------------------------
#define LCD_CRSR_IMG70_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG70_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG70_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG71  -----------------------------------------
#define LCD_CRSR_IMG71_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG71_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG71_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG72  -----------------------------------------
#define LCD_CRSR_IMG72_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG72_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG72_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG73  -----------------------------------------
#define LCD_CRSR_IMG73_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG73_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG73_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG74  -----------------------------------------
#define LCD_CRSR_IMG74_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG74_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG74_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG75  -----------------------------------------
#define LCD_CRSR_IMG75_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG75_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG75_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG76  -----------------------------------------
#define LCD_CRSR_IMG76_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG76_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG76_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG77  -----------------------------------------
#define LCD_CRSR_IMG77_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG77_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG77_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG78  -----------------------------------------
#define LCD_CRSR_IMG78_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG78_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG78_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG79  -----------------------------------------
#define LCD_CRSR_IMG79_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG79_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG79_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG80  -----------------------------------------
#define LCD_CRSR_IMG80_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG80_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG80_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG81  -----------------------------------------
#define LCD_CRSR_IMG81_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG81_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG81_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG82  -----------------------------------------
#define LCD_CRSR_IMG82_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG82_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG82_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG83  -----------------------------------------
#define LCD_CRSR_IMG83_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG83_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG83_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG84  -----------------------------------------
#define LCD_CRSR_IMG84_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG84_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG84_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG85  -----------------------------------------
#define LCD_CRSR_IMG85_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG85_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG85_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG86  -----------------------------------------
#define LCD_CRSR_IMG86_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG86_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG86_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG87  -----------------------------------------
#define LCD_CRSR_IMG87_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG87_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG87_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG88  -----------------------------------------
#define LCD_CRSR_IMG88_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG88_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG88_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG89  -----------------------------------------
#define LCD_CRSR_IMG89_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG89_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG89_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG90  -----------------------------------------
#define LCD_CRSR_IMG90_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG90_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG90_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG91  -----------------------------------------
#define LCD_CRSR_IMG91_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG91_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG91_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG92  -----------------------------------------
#define LCD_CRSR_IMG92_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG92_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG92_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG93  -----------------------------------------
#define LCD_CRSR_IMG93_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG93_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG93_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG94  -----------------------------------------
#define LCD_CRSR_IMG94_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG94_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG94_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG95  -----------------------------------------
#define LCD_CRSR_IMG95_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG95_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG95_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG96  -----------------------------------------
#define LCD_CRSR_IMG96_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG96_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG96_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG97  -----------------------------------------
#define LCD_CRSR_IMG97_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG97_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG97_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG98  -----------------------------------------
#define LCD_CRSR_IMG98_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG98_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG98_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG99  -----------------------------------------
#define LCD_CRSR_IMG99_CRSR_IMG_Pos                           0
#define LCD_CRSR_IMG99_CRSR_IMG_Msk                           (0xffffffffUL << LCD_CRSR_IMG99_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG100  ----------------------------------------
#define LCD_CRSR_IMG100_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG100_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG100_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG101  ----------------------------------------
#define LCD_CRSR_IMG101_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG101_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG101_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG102  ----------------------------------------
#define LCD_CRSR_IMG102_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG102_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG102_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG103  ----------------------------------------
#define LCD_CRSR_IMG103_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG103_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG103_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG104  ----------------------------------------
#define LCD_CRSR_IMG104_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG104_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG104_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG105  ----------------------------------------
#define LCD_CRSR_IMG105_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG105_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG105_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG106  ----------------------------------------
#define LCD_CRSR_IMG106_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG106_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG106_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG107  ----------------------------------------
#define LCD_CRSR_IMG107_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG107_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG107_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG108  ----------------------------------------
#define LCD_CRSR_IMG108_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG108_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG108_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG109  ----------------------------------------
#define LCD_CRSR_IMG109_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG109_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG109_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG110  ----------------------------------------
#define LCD_CRSR_IMG110_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG110_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG110_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG111  ----------------------------------------
#define LCD_CRSR_IMG111_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG111_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG111_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG112  ----------------------------------------
#define LCD_CRSR_IMG112_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG112_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG112_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG113  ----------------------------------------
#define LCD_CRSR_IMG113_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG113_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG113_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG114  ----------------------------------------
#define LCD_CRSR_IMG114_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG114_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG114_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG115  ----------------------------------------
#define LCD_CRSR_IMG115_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG115_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG115_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG116  ----------------------------------------
#define LCD_CRSR_IMG116_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG116_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG116_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG117  ----------------------------------------
#define LCD_CRSR_IMG117_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG117_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG117_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG118  ----------------------------------------
#define LCD_CRSR_IMG118_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG118_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG118_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG119  ----------------------------------------
#define LCD_CRSR_IMG119_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG119_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG119_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG120  ----------------------------------------
#define LCD_CRSR_IMG120_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG120_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG120_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG121  ----------------------------------------
#define LCD_CRSR_IMG121_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG121_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG121_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG122  ----------------------------------------
#define LCD_CRSR_IMG122_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG122_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG122_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG123  ----------------------------------------
#define LCD_CRSR_IMG123_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG123_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG123_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG124  ----------------------------------------
#define LCD_CRSR_IMG124_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG124_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG124_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG125  ----------------------------------------
#define LCD_CRSR_IMG125_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG125_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG125_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG126  ----------------------------------------
#define LCD_CRSR_IMG126_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG126_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG126_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG127  ----------------------------------------
#define LCD_CRSR_IMG127_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG127_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG127_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG128  ----------------------------------------
#define LCD_CRSR_IMG128_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG128_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG128_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG129  ----------------------------------------
#define LCD_CRSR_IMG129_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG129_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG129_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG130  ----------------------------------------
#define LCD_CRSR_IMG130_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG130_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG130_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG131  ----------------------------------------
#define LCD_CRSR_IMG131_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG131_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG131_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG132  ----------------------------------------
#define LCD_CRSR_IMG132_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG132_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG132_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG133  ----------------------------------------
#define LCD_CRSR_IMG133_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG133_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG133_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG134  ----------------------------------------
#define LCD_CRSR_IMG134_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG134_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG134_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG135  ----------------------------------------
#define LCD_CRSR_IMG135_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG135_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG135_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG136  ----------------------------------------
#define LCD_CRSR_IMG136_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG136_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG136_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG137  ----------------------------------------
#define LCD_CRSR_IMG137_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG137_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG137_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG138  ----------------------------------------
#define LCD_CRSR_IMG138_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG138_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG138_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG139  ----------------------------------------
#define LCD_CRSR_IMG139_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG139_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG139_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG140  ----------------------------------------
#define LCD_CRSR_IMG140_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG140_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG140_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG141  ----------------------------------------
#define LCD_CRSR_IMG141_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG141_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG141_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG142  ----------------------------------------
#define LCD_CRSR_IMG142_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG142_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG142_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG143  ----------------------------------------
#define LCD_CRSR_IMG143_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG143_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG143_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG144  ----------------------------------------
#define LCD_CRSR_IMG144_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG144_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG144_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG145  ----------------------------------------
#define LCD_CRSR_IMG145_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG145_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG145_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG146  ----------------------------------------
#define LCD_CRSR_IMG146_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG146_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG146_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG147  ----------------------------------------
#define LCD_CRSR_IMG147_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG147_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG147_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG148  ----------------------------------------
#define LCD_CRSR_IMG148_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG148_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG148_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG149  ----------------------------------------
#define LCD_CRSR_IMG149_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG149_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG149_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG150  ----------------------------------------
#define LCD_CRSR_IMG150_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG150_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG150_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG151  ----------------------------------------
#define LCD_CRSR_IMG151_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG151_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG151_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG152  ----------------------------------------
#define LCD_CRSR_IMG152_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG152_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG152_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG153  ----------------------------------------
#define LCD_CRSR_IMG153_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG153_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG153_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG154  ----------------------------------------
#define LCD_CRSR_IMG154_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG154_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG154_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG155  ----------------------------------------
#define LCD_CRSR_IMG155_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG155_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG155_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG156  ----------------------------------------
#define LCD_CRSR_IMG156_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG156_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG156_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG157  ----------------------------------------
#define LCD_CRSR_IMG157_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG157_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG157_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG158  ----------------------------------------
#define LCD_CRSR_IMG158_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG158_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG158_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG159  ----------------------------------------
#define LCD_CRSR_IMG159_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG159_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG159_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG160  ----------------------------------------
#define LCD_CRSR_IMG160_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG160_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG160_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG161  ----------------------------------------
#define LCD_CRSR_IMG161_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG161_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG161_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG162  ----------------------------------------
#define LCD_CRSR_IMG162_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG162_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG162_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG163  ----------------------------------------
#define LCD_CRSR_IMG163_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG163_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG163_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG164  ----------------------------------------
#define LCD_CRSR_IMG164_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG164_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG164_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG165  ----------------------------------------
#define LCD_CRSR_IMG165_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG165_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG165_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG166  ----------------------------------------
#define LCD_CRSR_IMG166_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG166_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG166_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG167  ----------------------------------------
#define LCD_CRSR_IMG167_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG167_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG167_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG168  ----------------------------------------
#define LCD_CRSR_IMG168_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG168_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG168_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG169  ----------------------------------------
#define LCD_CRSR_IMG169_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG169_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG169_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG170  ----------------------------------------
#define LCD_CRSR_IMG170_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG170_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG170_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG171  ----------------------------------------
#define LCD_CRSR_IMG171_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG171_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG171_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG172  ----------------------------------------
#define LCD_CRSR_IMG172_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG172_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG172_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG173  ----------------------------------------
#define LCD_CRSR_IMG173_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG173_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG173_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG174  ----------------------------------------
#define LCD_CRSR_IMG174_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG174_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG174_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG175  ----------------------------------------
#define LCD_CRSR_IMG175_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG175_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG175_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG176  ----------------------------------------
#define LCD_CRSR_IMG176_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG176_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG176_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG177  ----------------------------------------
#define LCD_CRSR_IMG177_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG177_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG177_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG178  ----------------------------------------
#define LCD_CRSR_IMG178_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG178_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG178_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG179  ----------------------------------------
#define LCD_CRSR_IMG179_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG179_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG179_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG180  ----------------------------------------
#define LCD_CRSR_IMG180_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG180_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG180_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG181  ----------------------------------------
#define LCD_CRSR_IMG181_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG181_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG181_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG182  ----------------------------------------
#define LCD_CRSR_IMG182_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG182_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG182_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG183  ----------------------------------------
#define LCD_CRSR_IMG183_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG183_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG183_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG184  ----------------------------------------
#define LCD_CRSR_IMG184_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG184_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG184_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG185  ----------------------------------------
#define LCD_CRSR_IMG185_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG185_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG185_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG186  ----------------------------------------
#define LCD_CRSR_IMG186_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG186_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG186_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG187  ----------------------------------------
#define LCD_CRSR_IMG187_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG187_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG187_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG188  ----------------------------------------
#define LCD_CRSR_IMG188_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG188_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG188_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG189  ----------------------------------------
#define LCD_CRSR_IMG189_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG189_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG189_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG190  ----------------------------------------
#define LCD_CRSR_IMG190_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG190_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG190_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG191  ----------------------------------------
#define LCD_CRSR_IMG191_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG191_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG191_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG192  ----------------------------------------
#define LCD_CRSR_IMG192_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG192_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG192_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG193  ----------------------------------------
#define LCD_CRSR_IMG193_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG193_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG193_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG194  ----------------------------------------
#define LCD_CRSR_IMG194_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG194_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG194_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG195  ----------------------------------------
#define LCD_CRSR_IMG195_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG195_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG195_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG196  ----------------------------------------
#define LCD_CRSR_IMG196_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG196_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG196_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG197  ----------------------------------------
#define LCD_CRSR_IMG197_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG197_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG197_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG198  ----------------------------------------
#define LCD_CRSR_IMG198_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG198_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG198_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG199  ----------------------------------------
#define LCD_CRSR_IMG199_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG199_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG199_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG200  ----------------------------------------
#define LCD_CRSR_IMG200_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG200_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG200_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG201  ----------------------------------------
#define LCD_CRSR_IMG201_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG201_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG201_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG202  ----------------------------------------
#define LCD_CRSR_IMG202_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG202_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG202_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG203  ----------------------------------------
#define LCD_CRSR_IMG203_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG203_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG203_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG204  ----------------------------------------
#define LCD_CRSR_IMG204_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG204_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG204_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG205  ----------------------------------------
#define LCD_CRSR_IMG205_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG205_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG205_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG206  ----------------------------------------
#define LCD_CRSR_IMG206_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG206_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG206_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG207  ----------------------------------------
#define LCD_CRSR_IMG207_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG207_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG207_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG208  ----------------------------------------
#define LCD_CRSR_IMG208_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG208_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG208_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG209  ----------------------------------------
#define LCD_CRSR_IMG209_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG209_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG209_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG210  ----------------------------------------
#define LCD_CRSR_IMG210_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG210_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG210_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG211  ----------------------------------------
#define LCD_CRSR_IMG211_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG211_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG211_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG212  ----------------------------------------
#define LCD_CRSR_IMG212_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG212_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG212_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG213  ----------------------------------------
#define LCD_CRSR_IMG213_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG213_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG213_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG214  ----------------------------------------
#define LCD_CRSR_IMG214_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG214_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG214_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG215  ----------------------------------------
#define LCD_CRSR_IMG215_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG215_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG215_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG216  ----------------------------------------
#define LCD_CRSR_IMG216_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG216_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG216_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG217  ----------------------------------------
#define LCD_CRSR_IMG217_CRSR_IMG_Pos                          0
#define LCD_CRSR_IMG217_CRSR_IMG_Msk                          (0xffffffffUL << LCD_CRSR_IMG217_CRSR_IMG_Pos)

// -------------------------------------  LCD_CRSR_IMG218  ----------