/*
** ###################################################################
**     Processors:          LPC54S018J2MET180
**                          LPC54S018J4MET180
**
**     Compilers:           GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**                          Keil ARM C/C++ Compiler
**                          MCUXpresso Compiler
**
**     Reference manual:    LPC54018JxM/LPC54S018JxM User manual Rev.1.0 20 September 2018
**     Version:             rev. 1.0, 2018-04-20
**     Build:               b200304
**
**     Abstract:
**         CMSIS Peripheral Access Layer for LPC54S018M
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2020 NXP
**     All rights reserved.
**
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2018-04-20)
**         Initial version.
**
** ###################################################################
*/

/*!
 * @file LPC54S018M.h
 * @version 1.0
 * @date 2018-04-20
 * @brief CMSIS Peripheral Access Layer for LPC54S018M
 *
 * CMSIS Peripheral Access Layer for LPC54S018M
 */

#ifndef _LPC54S018M_H_
#define _LPC54S018M_H_                           /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0100U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0000U


/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 75                 /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Auxiliary constants */
  NotAvail_IRQn                = -128,             /**< Not available device specific interrupt */

  /* Core interrupts */
  NonMaskableInt_IRQn          = -14,              /**< Non Maskable Interrupt */
  HardFault_IRQn               = -13,              /**< Cortex-M4 SV Hard Fault Interrupt */
  MemoryManagement_IRQn        = -12,              /**< Cortex-M4 Memory Management Interrupt */
  BusFault_IRQn                = -11,              /**< Cortex-M4 Bus Fault Interrupt */
  UsageFault_IRQn              = -10,              /**< Cortex-M4 Usage Fault Interrupt */
  SVCall_IRQn                  = -5,               /**< Cortex-M4 SV Call Interrupt */
  DebugMonitor_IRQn            = -4,               /**< Cortex-M4 Debug Monitor Interrupt */
  PendSV_IRQn                  = -2,               /**< Cortex-M4 Pend SV Interrupt */
  SysTick_IRQn                 = -1,               /**< Cortex-M4 System Tick Interrupt */

  /* Device specific interrupts */
  WDT_BOD_IRQn                 = 0,                /**< Windowed watchdog timer, Brownout detect */
  DMA0_IRQn                    = 1,                /**< DMA controller */
  GINT0_IRQn                   = 2,                /**< GPIO group 0 */
  GINT1_IRQn                   = 3,                /**< GPIO group 1 */
  PIN_INT0_IRQn                = 4,                /**< Pin interrupt 0 or pattern match engine slice 0 */
  PIN_INT1_IRQn                = 5,                /**< Pin interrupt 1or pattern match engine slice 1 */
  PIN_INT2_IRQn                = 6,                /**< Pin interrupt 2 or pattern match engine slice 2 */
  PIN_INT3_IRQn                = 7,                /**< Pin interrupt 3 or pattern match engine slice 3 */
  UTICK0_IRQn                  = 8,                /**< Micro-tick Timer */
  MRT0_IRQn                    = 9,                /**< Multi-rate timer */
  CTIMER0_IRQn                 = 10,               /**< Standard counter/timer CTIMER0 */
  CTIMER1_IRQn                 = 11,               /**< Standard counter/timer CTIMER1 */
  SCT0_IRQn                    = 12,               /**< SCTimer/PWM */
  CTIMER3_IRQn                 = 13,               /**< Standard counter/timer CTIMER3 */
  FLEXCOMM0_IRQn               = 14,               /**< Flexcomm Interface 0 (USART, SPI, I2C, FLEXCOMM) */
  FLEXCOMM1_IRQn               = 15,               /**< Flexcomm Interface 1 (USART, SPI, I2C, FLEXCOMM) */
  FLEXCOMM2_IRQn               = 16,               /**< Flexcomm Interface 2 (USART, SPI, I2C, FLEXCOMM) */
  FLEXCOMM3_IRQn               = 17,               /**< Flexcomm Interface 3 (USART, SPI, I2C, FLEXCOMM) */
  FLEXCOMM4_IRQn               = 18,               /**< Flexcomm Interface 4 (USART, SPI, I2C, FLEXCOMM) */
  FLEXCOMM5_IRQn               = 19,               /**< Flexcomm Interface 5 (USART, SPI, I2C,, FLEXCOMM) */
  FLEXCOMM6_IRQn               = 20,               /**< Flexcomm Interface 6 (USART, SPI, I2C, I2S,, FLEXCOMM) */
  FLEXCOMM7_IRQn               = 21,               /**< Flexcomm Interface 7 (USART, SPI, I2C, I2S,, FLEXCOMM) */
  ADC0_SEQA_IRQn               = 22,               /**< ADC0 sequence A completion. */
  ADC0_SEQB_IRQn               = 23,               /**< ADC0 sequence B completion. */
  ADC0_THCMP_IRQn              = 24,               /**< ADC0 threshold compare and error. */
  DMIC0_IRQn                   = 25,               /**< Digital microphone and DMIC subsystem */
  HWVAD0_IRQn                  = 26,               /**< Hardware Voice Activity Detector */
  USB0_NEEDCLK_IRQn            = 27,               /**< USB Activity Wake-up Interrupt */
  USB0_IRQn                    = 28,               /**< USB device */
  RTC_IRQn                     = 29,               /**< RTC alarm and wake-up interrupts */
  FLEXCOMM10_IRQn              = 30,               /**< Flexcomm Interface 10 (SPI, FLEXCOMM) */
  Reserved47_IRQn              = 31,               /**< Reserved interrupt */
  PIN_INT4_IRQn                = 32,               /**< Pin interrupt 4 or pattern match engine slice 4 int */
  PIN_INT5_IRQn                = 33,               /**< Pin interrupt 5 or pattern match engine slice 5 int */
  PIN_INT6_IRQn                = 34,               /**< Pin interrupt 6 or pattern match engine slice 6 int */
  PIN_INT7_IRQn                = 35,               /**< Pin interrupt 7 or pattern match engine slice 7 int */
  CTIMER2_IRQn                 = 36,               /**< Standard counter/timer CTIMER2 */
  CTIMER4_IRQn                 = 37,               /**< Standard counter/timer CTIMER4 */
  RIT_IRQn                     = 38,               /**< Repetitive Interrupt Timer */
  SPIFI0_IRQn                  = 39,               /**< SPI flash interface */
  FLEXCOMM8_IRQn               = 40,               /**< Flexcomm Interface 8 (USART, SPI, I2C, FLEXCOMM) */
  FLEXCOMM9_IRQn               = 41,               /**< Flexcomm Interface 9 (USART, SPI, I2C, FLEXCOMM) */
  SDIO_IRQn                    = 42,               /**< SD/MMC  */
  CAN0_IRQ0_IRQn               = 43,               /**< CAN0 interrupt0 */
  CAN0_IRQ1_IRQn               = 44,               /**< CAN0 interrupt1 */
  CAN1_IRQ0_IRQn               = 45,               /**< CAN1 interrupt0 */
  CAN1_IRQ1_IRQn               = 46,               /**< CAN1 interrupt1 */
  USB1_IRQn                    = 47,               /**< USB1 interrupt */
  USB1_NEEDCLK_IRQn            = 48,               /**< USB1 activity */
  ETHERNET_IRQn                = 49,               /**< Ethernet */
  ETHERNET_PMT_IRQn            = 50,               /**< Ethernet power management interrupt */
  ETHERNET_MACLP_IRQn          = 51,               /**< Ethernet MAC interrupt */
  Reserved68_IRQn              = 52,               /**< Reserved interrupt */
  LCD_IRQn                     = 53,               /**< LCD interrupt */
  SHA_IRQn                     = 54,               /**< SHA interrupt */
  SMARTCARD0_IRQn              = 55,               /**< Smart card 0 interrupt */
  SMARTCARD1_IRQn              = 56,               /**< Smart card 1 interrupt */
  Reserved73_IRQn              = 57,               /**< Reserved interrupt */
  PUF_IRQn                     = 58                /**< PUF interrupt */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Cortex M4 Core Configuration
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Cortex M4 Core Configuration
 * @{
 */

#define __MPU_PRESENT                  1         /**< Defines if an MPU is present or not */
#define __NVIC_PRIO_BITS               3         /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig         0         /**< Vendor specific implementation of SysTickConfig is defined */
#define __FPU_PRESENT                  1         /**< Defines if an FPU is present or not */

#include "core_cm4.h"                  /* Core Peripheral Access Layer */
#include "system_LPC54S018M.h"         /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */


/* ----------------------------------------------------------------------------
   -- Mapping Information
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Mapping_Information Mapping Information
 * @{
 */

/** Mapping Information */
/*!
 * @addtogroup dma_request
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the DMA hardware request
 *
 * Defines the structure for the DMA hardware request collections. The user can configure the
 * hardware request to trigger the DMA transfer accordingly. The index
 * of the hardware request varies according  to the to SoC.
 */
typedef enum _dma_request_source
{
    kDmaRequestFlexcomm0Rx          = 0U,          /**< Flexcomm Interface 0 RX/I2C Slave */
    kDmaRequestFlexcomm0Tx          = 1U,          /**< Flexcomm Interface 0 TX/I2C Master */
    kDmaRequestFlexcomm1Rx          = 2U,          /**< Flexcomm Interface 1 RX/I2C Slave */
    kDmaRequestFlexcomm1Tx          = 3U,          /**< Flexcomm Interface 1 TX/I2C Master */
    kDmaRequestFlexcomm2Rx          = 4U,          /**< Flexcomm Interface 2 RX/I2C Slave */
    kDmaRequestFlexcomm2Tx          = 5U,          /**< Flexcomm Interface 2 TX/I2C Master */
    kDmaRequestFlexcomm3Rx          = 6U,          /**< Flexcomm Interface 3 RX/I2C Slave */
    kDmaRequestFlexcomm3Tx          = 7U,          /**< Flexcomm Interface 3 TX/I2C Master */
    kDmaRequestFlexcomm4Rx          = 8U,          /**< Flexcomm Interface 4 RX/I2C Slave */
    kDmaRequestFlexcomm4Tx          = 9U,          /**< Flexcomm Interface 4 TX/I2C Master */
    kDmaRequestFlexcomm5Rx          = 10U,         /**< Flexcomm Interface 5 RX/I2C Slave */
    kDmaRequestFlexcomm5Tx          = 11U,         /**< Flexcomm Interface 5 TX/I2C Master */
    kDmaRequestFlexcomm6Rx          = 12U,         /**< Flexcomm Interface 6 RX/I2C Slave */
    kDmaRequestFlexcomm6Tx          = 13U,         /**< Flexcomm Interface 6 TX/I2C Master */
    kDmaRequestFlexcomm7Rx          = 14U,         /**< Flexcomm Interface 7 RX/I2C Slave */
    kDmaRequestFlexcomm7Tx          = 15U,         /**< Flexcomm Interface 7 TX/I2C Master */
    kDmaRequestDMIC0                = 16U,         /**< Digital microphone interface 0 channel 0 */
    kDmaRequestDMIC1                = 17U,         /**< Digital microphone interface 0 channel 1 */
    kDmaRequestSPIFI                = 18U,         /**< SPI Flash Interface */
    kDmaRequestSHA                  = 19U,         /**< Secure Hash Algorithm */
    kDmaRequestFlexcomm8Rx          = 20U,         /**< Flexcomm Interface 8 RX/I2C Slave */
    kDmaRequestFlexcomm8Tx          = 21U,         /**< Flexcomm Interface 8 TX/I2C Slave */
    kDmaRequestFlexcomm9Rx          = 22U,         /**< Flexcomm Interface 9 RX/I2C Slave */
    kDmaRequestFlexcomm9Tx          = 23U,         /**< Flexcomm Interface 9 TX/I2C Slave */
    kDmaRequestSMARTCARD0_RX        = 24U,         /**< SMARTCARD0 RX */
    kDmaRequestSMARTCARD0_TX        = 25U,         /**< SMARTCARD0 TX */
    kDmaRequestSMARTCARD1_RX        = 26U,         /**< SMARTCARD1 RX */
    kDmaRequestSMARTCARD1_TX        = 27U,         /**< SMARTCARD1 TX */
    kDmaRequestFlexcomm10Rx         = 28U,         /**< Flexcomm Interface 10 RX */
    kDmaRequestFlexcomm10Tx         = 29U,         /**< Flexcomm Interface 10 TX */
} dma_request_source_t;

/* @} */


/*!
 * @}
 */ /* end of group Mapping_Information */


/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< ADC Control register. Contains the clock divide value, resolution selection, sampling time selection, and mode controls., offset: 0x0 */
  __IO uint32_t INSEL;                             /**< Input Select. Allows selection of the temperature sensor as an alternate input to ADC channel 0., offset: 0x4 */
  __IO uint32_t SEQ_CTRL[2];                       /**< ADC Conversion Sequence-n control register: Controls triggering and channel selection for conversion sequence-n. Also specifies interrupt mode for sequence-n., array offset: 0x8, array step: 0x4 */
  __I  uint32_t SEQ_GDAT[2];                       /**< ADC Sequence-n Global Data register. This register contains the result of the most recent ADC conversion performed under sequence-n., array offset: 0x10, array step: 0x4 */
       uint8_t RESERVED_0[8];
  __I  uint32_t DAT[12];                           /**< ADC Channel 0 Data register. This register contains the result of the most recent conversion completed on channel 0., array offset: 0x20, array step: 0x4 */
  __IO uint32_t THR0_LOW;                          /**< ADC Low Compare Threshold register 0: Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 0., offset: 0x50 */
  __IO uint32_t THR1_LOW;                          /**< ADC Low Compare Threshold register 1: Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 1., offset: 0x54 */
  __IO uint32_t THR0_HIGH;                         /**< ADC High Compare Threshold register 0: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 0., offset: 0x58 */
  __IO uint32_t THR1_HIGH;                         /**< ADC High Compare Threshold register 1: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 1., offset: 0x5C */
  __IO uint32_t CHAN_THRSEL;                       /**< ADC Channel-Threshold Select register. Specifies which set of threshold compare registers are to be used for each channel, offset: 0x60 */
  __IO uint32_t INTEN;                             /**< ADC Interrupt Enable register. This register contains enable bits that enable the sequence-A, sequence-B, threshold compare and data overrun interrupts to be generated., offset: 0x64 */
  __IO uint32_t FLAGS;                             /**< ADC Flags register. Contains the four interrupt/DMA trigger flags and the individual component overrun and threshold-compare flags. (The overrun bits replicate information stored in the result registers)., offset: 0x68 */
  __IO uint32_t STARTUP;                           /**< ADC Startup register., offset: 0x6C */
  __IO uint32_t CALIB;                             /**< ADC Calibration register., offset: 0x70 */
} ADC_Type;

/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name CTRL - ADC Control register. Contains the clock divide value, resolution selection, sampling time selection, and mode controls. */
/*! @{ */
#define ADC_CTRL_CLKDIV_MASK                     (0xFFU)
#define ADC_CTRL_CLKDIV_SHIFT                    (0U)
/*! CLKDIV - In synchronous mode only, the system clock is divided by this value plus one to produce
 *    the clock for the ADC converter, which should be less than or equal to 72 MHz. Typically,
 *    software should program the smallest value in this field that yields this maximum clock rate or
 *    slightly less, but in certain cases (such as a high-impedance analog source) a slower clock may
 *    be desirable. This field is ignored in the asynchronous operating mode.
 */
#define ADC_CTRL_CLKDIV(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CLKDIV_SHIFT)) & ADC_CTRL_CLKDIV_MASK)
#define ADC_CTRL_ASYNMODE_MASK                   (0x100U)
#define ADC_CTRL_ASYNMODE_SHIFT                  (8U)
/*! ASYNMODE - Select clock mode.
 *  0b0..Synchronous mode. The ADC clock is derived from the system clock based on the divide value selected in
 *       the CLKDIV field. The ADC clock will be started in a controlled fashion in response to a trigger to
 *       eliminate any uncertainty in the launching of an ADC conversion in response to any synchronous (on-chip) trigger.
 *       In Synchronous mode with the SYNCBYPASS bit (in a sequence control register) set, sampling of the ADC
 *       input and start of conversion will initiate 2 system clocks after the leading edge of a (synchronous) trigger
 *       pulse.
 *  0b1..Asynchronous mode. The ADC clock is based on the output of the ADC clock divider ADCCLKSEL in the SYSCON block.
 */
#define ADC_CTRL_ASYNMODE(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_ASYNMODE_SHIFT)) & ADC_CTRL_ASYNMODE_MASK)
#define ADC_CTRL_RESOL_MASK                      (0x600U)
#define ADC_CTRL_RESOL_SHIFT                     (9U)
/*! RESOL - The number of bits of ADC resolution. Accuracy can be reduced to achieve higher
 *    conversion rates. A single conversion (including one conversion in a burst or sequence) requires the
 *    selected number of bits of resolution plus 3 ADC clocks. This field must only be altered when
 *    the ADC is fully idle. Changing it during any kind of ADC operation may have unpredictable
 *    results. ADC clock frequencies for various resolutions must not exceed: - 5x the system clock rate
 *    for 12-bit resolution - 4.3x the system clock rate for 10-bit resolution - 3.6x the system
 *    clock for 8-bit resolution - 3x the bus clock rate for 6-bit resolution
 *  0b00..6-bit resolution. An ADC conversion requires 9 ADC clocks, plus any clocks specified by the TSAMP field.
 *  0b01..8-bit resolution. An ADC conversion requires 11 ADC clocks, plus any clocks specified by the TSAMP field.
 *  0b10..10-bit resolution. An ADC conversion requires 13 ADC clocks, plus any clocks specified by the TSAMP field.
 *  0b11..12-bit resolution. An ADC conversion requires 15 ADC clocks, plus any clocks specified by the TSAMP field.
 */
#define ADC_CTRL_RESOL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RESOL_SHIFT)) & ADC_CTRL_RESOL_MASK)
#define ADC_CTRL_BYPASSCAL_MASK                  (0x800U)
#define ADC_CTRL_BYPASSCAL_SHIFT                 (11U)
/*! BYPASSCAL - Bypass Calibration. This bit may be set to avoid the need to calibrate if offset
 *    error is not a concern in the application.
 *  0b0..Calibrate. The stored calibration value will be applied to the ADC during conversions to compensated for
 *       offset error. A calibration cycle must be performed each time the chip is powered-up. Re-calibration may
 *       be warranted periodically - especially if operating conditions have changed.
 *  0b1..Bypass calibration. Calibration is not utilized. Less time is required when enabling the ADC -
 *       particularly following chip power-up. Attempts to launch a calibration cycle are blocked when this bit is set.
 */
#define ADC_CTRL_BYPASSCAL(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_BYPASSCAL_SHIFT)) & ADC_CTRL_BYPASSCAL_MASK)
#define ADC_CTRL_TSAMP_MASK                      (0x7000U)
#define ADC_CTRL_TSAMP_SHIFT                     (12U)
/*! TSAMP - Sample Time. The default sampling period (TSAMP = '000') at the start of each conversion
 *    is 2.5 ADC clock periods. Depending on a variety of factors, including operating conditions
 *    and the output impedance of the analog source, longer sampling times may be required. See
 *    Section 28.7.10. The TSAMP field specifies the number of additional ADC clock cycles, from zero to
 *    seven, by which the sample period will be extended. The total conversion time will increase by
 *    the same number of clocks. 000 - The sample period will be the default 2.5 ADC clocks. A
 *    complete conversion with 12-bits of accuracy will require 15 clocks. 001- The sample period will
 *    be extended by one ADC clock to a total of 3.5 clock periods. A complete 12-bit conversion will
 *    require 16 clocks. 010 - The sample period will be extended by two clocks to 4.5 ADC clock
 *    cycles. A complete 12-bit conversion will require 17 ADC clocks. 111 - The sample period will be
 *    extended by seven clocks to 9.5 ADC clock cycles. A complete 12-bit conversion will require
 *    22 ADC clocks.
 */
#define ADC_CTRL_TSAMP(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_TSAMP_SHIFT)) & ADC_CTRL_TSAMP_MASK)
/*! @} */

/*! @name INSEL - Input Select. Allows selection of the temperature sensor as an alternate input to ADC channel 0. */
/*! @{ */
#define ADC_INSEL_SEL_MASK                       (0x3U)
#define ADC_INSEL_SEL_SHIFT                      (0U)
/*! SEL - Selects the input source for channel 0. All other values are reserved.
 *  0b00..ADC0_IN0 function.
 *  0b11..Internal temperature sensor.
 */
#define ADC_INSEL_SEL(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_INSEL_SEL_SHIFT)) & ADC_INSEL_SEL_MASK)
/*! @} */

/*! @name SEQ_CTRL - ADC Conversion Sequence-n control register: Controls triggering and channel selection for conversion sequence-n. Also specifies interrupt mode for sequence-n. */
/*! @{ */
#define ADC_SEQ_CTRL_CHANNELS_MASK               (0xFFFU)
#define ADC_SEQ_CTRL_CHANNELS_SHIFT              (0U)
/*! CHANNELS - Selects which one or more of the ADC channels will be sampled and converted when this
 *    sequence is launched. A 1 in any bit of this field will cause the corresponding channel to be
 *    included in the conversion sequence, where bit 0 corresponds to channel 0, bit 1 to channel 1
 *    and so forth. When this conversion sequence is triggered, either by a hardware trigger or via
 *    software command, ADC conversions will be performed on each enabled channel, in sequence,
 *    beginning with the lowest-ordered channel. This field can ONLY be changed while SEQA_ENA (bit 31)
 *    is LOW. It is allowed to change this field and set bit 31 in the same write.
 */
#define ADC_SEQ_CTRL_CHANNELS(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_CTRL_CHANNELS_SHIFT)) & ADC_SEQ_CTRL_CHANNELS_MASK)
#define ADC_SEQ_CTRL_TRIGGER_MASK                (0x3F000U)
#define ADC_SEQ_CTRL_TRIGGER_SHIFT               (12U)
/*! TRIGGER - Selects which of the available hardware trigger sources will cause this conversion
 *    sequence to be initiated. Program the trigger input number in this field. See Table 476. In order
 *    to avoid generating a spurious trigger, it is recommended writing to this field only when
 *    SEQA_ENA (bit 31) is low. It is safe to change this field and set bit 31 in the same write.
 */
#define ADC_SEQ_CTRL_TRIGGER(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_CTRL_TRIGGER_SHIFT)) & ADC_SEQ_CTRL_TRIGGER_MASK)
#define ADC_SEQ_CTRL_TRIGPOL_MASK                (0x40000U)
#define ADC_SEQ_CTRL_TRIGPOL_SHIFT               (18U)
/*! TRIGPOL - Select the polarity of the selected input trigger for this conversion sequence. In
 *    order to avoid generating a spurious trigger, it is recommended writing to this field only when
 *    SEQA_ENA (bit 31) is low. It is safe to change this field and set bit 31 in the same write.
 *  0b0..Negative edge. A negative edge launches the conversion sequence on the selected trigger input.
 *  0b1..Positive edge. A positive edge launches the conversion sequence on the selected trigger input.
 */
#define ADC_SEQ_CTRL_TRIGPOL(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_CTRL_TRIGPOL_SHIFT)) & ADC_SEQ_CTRL_TRIGPOL_MASK)
#define ADC_SEQ_CTRL_SYNCBYPASS_MASK             (0x80000U)
#define ADC_SEQ_CTRL_SYNCBYPASS_SHIFT            (19U)
/*! SYNCBYPASS - Setting this bit allows the hardware trigger input to bypass synchronization
 *    flip-flop stages and therefore shorten the time between the trigger input signal and the start of a
 *    conversion. There are slightly different criteria for whether or not this bit can be set
 *    depending on the clock operating mode: Synchronous mode (the ASYNMODE in the CTRL register = 0):
 *    Synchronization may be bypassed (this bit may be set) if the selected trigger source is already
 *    synchronous with the main system clock (eg. coming from an on-chip, system-clock-based timer).
 *    Whether this bit is set or not, a trigger pulse must be maintained for at least one system
 *    clock period. Asynchronous mode (the ASYNMODE in the CTRL register = 1): Synchronization may be
 *    bypassed (this bit may be set) if it is certain that the duration of a trigger input pulse
 *    will be at least one cycle of the ADC clock (regardless of whether the trigger comes from and
 *    on-chip or off-chip source). If this bit is NOT set, the trigger pulse must at least be
 *    maintained for one system clock period.
 *  0b0..Enable trigger synchronization. The hardware trigger bypass is not enabled.
 *  0b1..Bypass trigger synchronization. The hardware trigger bypass is enabled.
 */
#define ADC_SEQ_CTRL_SYNCBYPASS(x)               (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_CTRL_SYNCBYPASS_SHIFT)) & ADC_SEQ_CTRL_SYNCBYPASS_MASK)
#define ADC_SEQ_CTRL_START_MASK                  (0x4000000U)
#define ADC_SEQ_CTRL_START_SHIFT                 (26U)
/*! START - Writing a 1 to this field will launch one pass through this conversion sequence. The
 *    behavior will be identical to a sequence triggered by a hardware trigger. Do not write 1 to this
 *    bit if the BURST bit is set. This bit is only set to a 1 momentarily when written to launch a
 *    conversion sequence. It will consequently always read back as a zero.
 */
#define ADC_SEQ_CTRL_START(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_CTRL_START_SHIFT)) & ADC_SEQ_CTRL_START_MASK)
#define ADC_SEQ_CTRL_BURST_MASK                  (0x8000000U)
#define ADC_SEQ_CTRL_BURST_SHIFT                 (27U)
/*! BURST - Writing a 1 to this bit will cause this conversion sequence to be continuously cycled
 *    through. Other sequence A triggers will be ignored while this bit is set. Repeated conversions
 *    can be halted by clearing this bit. The sequence currently in progress will be completed before
 *    conversions are terminated. Note that a new sequence could begin just before BURST is cleared.
 */
#define ADC_SEQ_CTRL_BURST(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_CTRL_BURST_SHIFT)) & ADC_SEQ_CTRL_BURST_MASK)
#define ADC_SEQ_CTRL_SINGLESTEP_MASK             (0x10000000U)
#define ADC_SEQ_CTRL_SINGLESTEP_SHIFT            (28U)
/*! SINGLESTEP - When this bit is set, a hardware trigger or a write to the START bit will launch a
 *    single conversion on the next channel in the sequence instead of the default response of
 *    launching an entire sequence of conversions. Once all of the channels comprising a sequence have
 *    been converted, a subsequent trigger will repeat the sequence beginning with the first enabled
 *    channel. Interrupt generation will still occur either after each individual conversion or at
 *    the end of the entire sequence, depending on the state of the MODE bit.
 */
#define ADC_SEQ_CTRL_SINGLESTEP(x)               (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_CTRL_SINGLESTEP_SHIFT)) & ADC_SEQ_CTRL_SINGLESTEP_MASK)
#define ADC_SEQ_CTRL_LOWPRIO_MASK                (0x20000000U)
#define ADC_SEQ_CTRL_LOWPRIO_SHIFT               (29U)
/*! LOWPRIO - Set priority for sequence A.
 *  0b0..Low priority. Any B trigger which occurs while an A conversion sequence is active will be ignored and lost.
 *  0b1..High priority. Setting this bit to a 1 will permit any enabled B sequence trigger (including a B sequence
 *       software start) to immediately interrupt sequence A and launch a B sequence in it's place. The conversion
 *       currently in progress will be terminated. The A sequence that was interrupted will automatically resume
 *       after the B sequence completes. The channel whose conversion was terminated will be re-sampled and the
 *       conversion sequence will resume from that point.
 */
#define ADC_SEQ_CTRL_LOWPRIO(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_CTRL_LOWPRIO_SHIFT)) & ADC_SEQ_CTRL_LOWPRIO_MASK)
#define ADC_SEQ_CTRL_MODE_MASK                   (0x40000000U)
#define ADC_SEQ_CTRL_MODE_SHIFT                  (30U)
/*! MODE - Indicates whether the primary method for retrieving conversion results for this sequence
 *    will be accomplished via reading the global data register (SEQA_GDAT) at the end of each
 *    conversion, or the individual channel result registers at the end of the entire sequence. Impacts
 *    when conversion-complete interrupt/DMA trigger for sequence-A will be generated and which
 *    overrun conditions contribute to an overrun interrupt as described below.
 *  0b0..End of conversion. The sequence A interrupt/DMA trigger will be set at the end of each individual ADC
 *       conversion performed under sequence A. This flag will mirror the DATAVALID bit in the SEQA_GDAT register. The
 *       OVERRUN bit in the SEQA_GDAT register will contribute to generation of an overrun interrupt/DMA trigger
 *       if enabled.
 *  0b1..End of sequence. The sequence A interrupt/DMA trigger will be set when the entire set of sequence-A
 *       conversions completes. This flag will need to be explicitly cleared by software or by the DMA-clear signal in
 *       this mode. The OVERRUN bit in the SEQA_GDAT register will NOT contribute to generation of an overrun
 *       interrupt/DMA trigger since it is assumed this register may not be utilized in this mode.
 */
#define ADC_SEQ_CTRL_MODE(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_CTRL_MODE_SHIFT)) & ADC_SEQ_CTRL_MODE_MASK)
#define ADC_SEQ_CTRL_SEQ_ENA_MASK                (0x80000000U)
#define ADC_SEQ_CTRL_SEQ_ENA_SHIFT               (31U)
/*! SEQ_ENA - Sequence Enable. In order to avoid spuriously triggering the sequence, care should be
 *    taken to only set the SEQn_ENA bit when the selected trigger input is in its INACTIVE state
 *    (as defined by the TRIGPOL bit). If this condition is not met, the sequence will be triggered
 *    immediately upon being enabled. In order to avoid spuriously triggering the sequence, care
 *    should be taken to only set the SEQn_ENA bit when the selected trigger input is in its INACTIVE
 *    state (as defined by the TRIGPOL bit). If this condition is not met, the sequence will be
 *    triggered immediately upon being enabled.
 *  0b0..Disabled. Sequence n is disabled. Sequence n triggers are ignored. If this bit is cleared while sequence
 *       n is in progress, the sequence will be halted at the end of the current conversion. After the sequence is
 *       re-enabled, a new trigger will be required to restart the sequence beginning with the next enabled channel.
 *  0b1..Enabled. Sequence n is enabled.
 */
#define ADC_SEQ_CTRL_SEQ_ENA(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_CTRL_SEQ_ENA_SHIFT)) & ADC_SEQ_CTRL_SEQ_ENA_MASK)
/*! @} */

/* The count of ADC_SEQ_CTRL */
#define ADC_SEQ_CTRL_COUNT                       (2U)

/*! @name SEQ_GDAT - ADC Sequence-n Global Data register. This register contains the result of the most recent ADC conversion performed under sequence-n. */
/*! @{ */
#define ADC_SEQ_GDAT_RESULT_MASK                 (0xFFF0U)
#define ADC_SEQ_GDAT_RESULT_SHIFT                (4U)
/*! RESULT - This field contains the 12-bit ADC conversion result from the most recent conversion
 *    performed under conversion sequence associated with this register. The result is a binary
 *    fraction representing the voltage on the currently-selected input channel as it falls within the
 *    range of VREFP to VREFN. Zero in the field indicates that the voltage on the input pin was less
 *    than, equal to, or close to that on VREFN, while 0xFFF indicates that the voltage on the input
 *    was close to, equal to, or greater than that on VREFP. DATAVALID = 1 indicates that this
 *    result has not yet been read.
 */
#define ADC_SEQ_GDAT_RESULT(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_GDAT_RESULT_SHIFT)) & ADC_SEQ_GDAT_RESULT_MASK)
#define ADC_SEQ_GDAT_THCMPRANGE_MASK             (0x30000U)
#define ADC_SEQ_GDAT_THCMPRANGE_SHIFT            (16U)
/*! THCMPRANGE - Indicates whether the result of the last conversion performed was above, below or
 *    within the range established by the designated threshold comparison registers (THRn_LOW and
 *    THRn_HIGH).
 */
#define ADC_SEQ_GDAT_THCMPRANGE(x)               (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_GDAT_THCMPRANGE_SHIFT)) & ADC_SEQ_GDAT_THCMPRANGE_MASK)
#define ADC_SEQ_GDAT_THCMPCROSS_MASK             (0xC0000U)
#define ADC_SEQ_GDAT_THCMPCROSS_SHIFT            (18U)
/*! THCMPCROSS - Indicates whether the result of the last conversion performed represented a
 *    crossing of the threshold level established by the designated LOW threshold comparison register
 *    (THRn_LOW) and, if so, in what direction the crossing occurred.
 */
#define ADC_SEQ_GDAT_THCMPCROSS(x)               (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_GDAT_THCMPCROSS_SHIFT)) & ADC_SEQ_GDAT_THCMPCROSS_MASK)
#define ADC_SEQ_GDAT_CHN_MASK                    (0x3C000000U)
#define ADC_SEQ_GDAT_CHN_SHIFT                   (26U)
/*! CHN - These bits contain the channel from which the RESULT bits were converted (e.g. 0000
 *    identifies channel 0, 0001 channel 1, etc.).
 */
#define ADC_SEQ_GDAT_CHN(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_GDAT_CHN_SHIFT)) & ADC_SEQ_GDAT_CHN_MASK)
#define ADC_SEQ_GDAT_OVERRUN_MASK                (0x40000000U)
#define ADC_SEQ_GDAT_OVERRUN_SHIFT               (30U)
/*! OVERRUN - This bit is set if a new conversion result is loaded into the RESULT field before a
 *    previous result has been read - i.e. while the DATAVALID bit is set. This bit is cleared, along
 *    with the DATAVALID bit, whenever this register is read. This bit will contribute to an overrun
 *    interrupt/DMA trigger if the MODE bit (in SEQAA_CTRL) for the corresponding sequence is set
 *    to '0' (and if the overrun interrupt is enabled).
 */
#define ADC_SEQ_GDAT_OVERRUN(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_GDAT_OVERRUN_SHIFT)) & ADC_SEQ_GDAT_OVERRUN_MASK)
#define ADC_SEQ_GDAT_DATAVALID_MASK              (0x80000000U)
#define ADC_SEQ_GDAT_DATAVALID_SHIFT             (31U)
/*! DATAVALID - This bit is set to '1' at the end of each conversion when a new result is loaded
 *    into the RESULT field. It is cleared whenever this register is read. This bit will cause a
 *    conversion-complete interrupt for the corresponding sequence if the MODE bit (in SEQA_CTRL) for that
 *    sequence is set to 0 (and if the interrupt is enabled).
 */
#define ADC_SEQ_GDAT_DATAVALID(x)                (((uint32_t)(((uint32_t)(x)) << ADC_SEQ_GDAT_DATAVALID_SHIFT)) & ADC_SEQ_GDAT_DATAVALID_MASK)
/*! @} */

/* The count of ADC_SEQ_GDAT */
#define ADC_SEQ_GDAT_COUNT                       (2U)

/*! @name DAT - ADC Channel 0 Data register. This register contains the result of the most recent conversion completed on channel 0. */
/*! @{ */
#define ADC_DAT_RESULT_MASK                      (0xFFF0U)
#define ADC_DAT_RESULT_SHIFT                     (4U)
/*! RESULT - This field contains the 12-bit ADC conversion result from the last conversion performed
 *    on this channel. This will be a binary fraction representing the voltage on the AD0[n] pin,
 *    as it falls within the range of VREFP to VREFN. Zero in the field indicates that the voltage on
 *    the input pin was less than, equal to, or close to that on VREFN, while 0xFFF indicates that
 *    the voltage on the input was close to, equal to, or greater than that on VREFP.
 */
#define ADC_DAT_RESULT(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_DAT_RESULT_SHIFT)) & ADC_DAT_RESULT_MASK)
#define ADC_DAT_THCMPRANGE_MASK                  (0x30000U)
#define ADC_DAT_THCMPRANGE_SHIFT                 (16U)
/*! THCMPRANGE - Threshold Range Comparison result. 0x0 = In Range: The last completed conversion
 *    was greater than or equal to the value programmed into the designated LOW threshold register
 *    (THRn_LOW) but less than or equal to the value programmed into the designated HIGH threshold
 *    register (THRn_HIGH). 0x1 = Below Range: The last completed conversion on was less than the value
 *    programmed into the designated LOW threshold register (THRn_LOW). 0x2 = Above Range: The last
 *    completed conversion was greater than the value programmed into the designated HIGH threshold
 *    register (THRn_HIGH). 0x3 = Reserved.
 */
#define ADC_DAT_THCMPRANGE(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_DAT_THCMPRANGE_SHIFT)) & ADC_DAT_THCMPRANGE_MASK)
#define ADC_DAT_THCMPCROSS_MASK                  (0xC0000U)
#define ADC_DAT_THCMPCROSS_SHIFT                 (18U)
/*! THCMPCROSS - Threshold Crossing Comparison result. 0x0 = No threshold Crossing detected: The
 *    most recent completed conversion on this channel had the same relationship (above or below) to
 *    the threshold value established by the designated LOW threshold register (THRn_LOW) as did the
 *    previous conversion on this channel. 0x1 = Reserved. 0x2 = Downward Threshold Crossing
 *    Detected. Indicates that a threshold crossing in the downward direction has occurred - i.e. the
 *    previous sample on this channel was above the threshold value established by the designated LOW
 *    threshold register (THRn_LOW) and the current sample is below that threshold. 0x3 = Upward
 *    Threshold Crossing Detected. Indicates that a threshold crossing in the upward direction has occurred
 *    - i.e. the previous sample on this channel was below the threshold value established by the
 *    designated LOW threshold register (THRn_LOW) and the current sample is above that threshold.
 */
#define ADC_DAT_THCMPCROSS(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_DAT_THCMPCROSS_SHIFT)) & ADC_DAT_THCMPCROSS_MASK)
#define ADC_DAT_CHANNEL_MASK                     (0x3C000000U)
#define ADC_DAT_CHANNEL_SHIFT                    (26U)
/*! CHANNEL - This field is hard-coded to contain the channel number that this particular register
 *    relates to (i.e. this field will contain 0b0000 for the DAT0 register, 0b0001 for the DAT1
 *    register, etc)
 */
#define ADC_DAT_CHANNEL(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_DAT_CHANNEL_SHIFT)) & ADC_DAT_CHANNEL_MASK)
#define ADC_DAT_OVERRUN_MASK                     (0x40000000U)
#define ADC_DAT_OVERRUN_SHIFT                    (30U)
/*! OVERRUN - This bit will be set to a 1 if a new conversion on this channel completes and
 *    overwrites the previous contents of the RESULT field before it has been read - i.e. while the DONE bit
 *    is set. This bit is cleared, along with the DONE bit, whenever this register is read or when
 *    the data related to this channel is read from either of the global SEQn_GDAT registers. This
 *    bit (in any of the 12 registers) will cause an overrun interrupt/DMA trigger to be asserted if
 *    the overrun interrupt is enabled. While it is allowed to include the same channels in both
 *    conversion sequences, doing so may cause erratic behavior of the DONE and OVERRUN bits in the
 *    data registers associated with any of the channels that are shared between the two sequences. Any
 *    erratic OVERRUN behavior will also affect overrun interrupt generation, if enabled.
 */
#define ADC_DAT_OVERRUN(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_DAT_OVERRUN_SHIFT)) & ADC_DAT_OVERRUN_MASK)
#define ADC_DAT_DATAVALID_MASK                   (0x80000000U)
#define ADC_DAT_DATAVALID_SHIFT                  (31U)
/*! DATAVALID - This bit is set to 1 when an ADC conversion on this channel completes. This bit is
 *    cleared whenever this register is read or when the data related to this channel is read from
 *    either of the global SEQn_GDAT registers. While it is allowed to include the same channels in
 *    both conversion sequences, doing so may cause erratic behavior of the DONE and OVERRUN bits in
 *    the data registers associated with any of the channels that are shared between the two
 *    sequences. Any erratic OVERRUN behavior will also affect overrun interrupt generation, if enabled.
 */
#define ADC_DAT_DATAVALID(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_DAT_DATAVALID_SHIFT)) & ADC_DAT_DATAVALID_MASK)
/*! @} */

/* The count of ADC_DAT */
#define ADC_DAT_COUNT                            (12U)

/*! @name THR0_LOW - ADC Low Compare Threshold register 0: Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 0. */
/*! @{ */
#define ADC_THR0_LOW_THRLOW_MASK                 (0xFFF0U)
#define ADC_THR0_LOW_THRLOW_SHIFT                (4U)
/*! THRLOW - Low threshold value against which ADC results will be compared
 */
#define ADC_THR0_LOW_THRLOW(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_THR0_LOW_THRLOW_SHIFT)) & ADC_THR0_LOW_THRLOW_MASK)
/*! @} */

/*! @name THR1_LOW - ADC Low Compare Threshold register 1: Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 1. */
/*! @{ */
#define ADC_THR1_LOW_THRLOW_MASK                 (0xFFF0U)
#define ADC_THR1_LOW_THRLOW_SHIFT                (4U)
/*! THRLOW - Low threshold value against which ADC results will be compared
 */
#define ADC_THR1_LOW_THRLOW(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_THR1_LOW_THRLOW_SHIFT)) & ADC_THR1_LOW_THRLOW_MASK)
/*! @} */

/*! @name THR0_HIGH - ADC High Compare Threshold register 0: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 0. */
/*! @{ */
#define ADC_THR0_HIGH_THRHIGH_MASK               (0xFFF0U)
#define ADC_THR0_HIGH_THRHIGH_SHIFT              (4U)
/*! THRHIGH - High threshold value against which ADC results will be compared
 */
#define ADC_THR0_HIGH_THRHIGH(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_THR0_HIGH_THRHIGH_SHIFT)) & ADC_THR0_HIGH_THRHIGH_MASK)
/*! @} */

/*! @name THR1_HIGH - ADC High Compare Threshold register 1: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 1. */
/*! @{ */
#define ADC_THR1_HIGH_THRHIGH_MASK               (0xFFF0U)
#define ADC_THR1_HIGH_THRHIGH_SHIFT              (4U)
/*! THRHIGH - High threshold value against which ADC results will be compared
 */
#define ADC_THR1_HIGH_THRHIGH(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_THR1_HIGH_THRHIGH_SHIFT)) & ADC_THR1_HIGH_THRHIGH_MASK)
/*! @} */

/*! @name CHAN_THRSEL - ADC Channel-Threshold Select register. Specifies which set of threshold compare registers are to be used for each channel */
/*! @{ */
#define ADC_CHAN_THRSEL_CH0_THRSEL_MASK          (0x1U)
#define ADC_CHAN_THRSEL_CH0_THRSEL_SHIFT         (0U)
/*! CH0_THRSEL - Threshold select for channel 0.
 *  0b0..Threshold 0. Results for this channel will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers.
 *  0b1..Threshold 1. Results for this channel will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers.
 */
#define ADC_CHAN_THRSEL_CH0_THRSEL(x)            (((uint32_t)(((uint32_t)(x)) << ADC_CHAN_THRSEL_CH0_THRSEL_SHIFT)) & ADC_CHAN_THRSEL_CH0_THRSEL_MASK)
#define ADC_CHAN_THRSEL_CH1_THRSEL_MASK          (0x2U)
#define ADC_CHAN_THRSEL_CH1_THRSEL_SHIFT         (1U)
/*! CH1_THRSEL - Threshold select for channel 1. See description for channel 0.
 */
#define ADC_CHAN_THRSEL_CH1_THRSEL(x)            (((uint32_t)(((uint32_t)(x)) << ADC_CHAN_THRSEL_CH1_THRSEL_SHIFT)) & ADC_CHAN_THRSEL_CH1_THRSEL_MASK)
#define ADC_CHAN_THRSEL_CH2_THRSEL_MASK          (0x4U)
#define ADC_CHAN_THRSEL_CH2_THRSEL_SHIFT         (2U)
/*! CH2_THRSEL - Threshold select for channel 2. See description for channel 0.
 */
#define ADC_CHAN_THRSEL_CH2_THRSEL(x)            (((uint32_t)(((uint32_t)(x)) << ADC_CHAN_THRSEL_CH2_THRSEL_SHIFT)) & ADC_CHAN_THRSEL_CH2_THRSEL_MASK)
#define ADC_CHAN_THRSEL_CH3_THRSEL_MASK          (0x8U)
#define ADC_CHAN_THRSEL_CH3_THRSEL_SHIFT         (3U)
/*! CH3_THRSEL - Threshold select for channel 3. See description for channel 0.
 */
#define ADC_CHAN_THRSEL_CH3_THRSEL(x)            (((uint32_t)(((uint32_t)(x)) << ADC_CHAN_THRSEL_CH3_THRSEL_SHIFT)) & ADC_CHAN_THRSEL_CH3_THRSEL_MASK)
#define ADC_CHAN_THRSEL_CH4_THRSEL_MASK          (0x10U)
#define ADC_CHAN_THRSEL_CH4_THRSEL_SHIFT         (4U)
/*! CH4_THRSEL - Threshold select for channel 4. See description for channel 0.
 */
#define ADC_CHAN_THRSEL_CH4_THRSEL(x)            (((uint32_t)(((uint32_t)(x)) << ADC_CHAN_THRSEL_CH4_THRSEL_SHIFT)) & ADC_CHAN_THRSEL_CH4_THRSEL_MASK)
#define ADC_CHAN_THRSEL_CH5_THRSEL_MASK          (0x20U)
#define ADC_CHAN_THRSEL_CH5_THRSEL_SHIFT         (5U)
/*! CH5_THRSEL - Threshold select for channel 5. See description for channel 0.
 */
#define ADC_CHAN_THRSEL_CH5_THRSEL(x)            (((uint32_t)(((uint32_t)(x)) << ADC_CHAN_THRSEL_CH5_THRSEL_SHIFT)) & ADC_CHAN_THRSEL_CH5_THRSEL_MASK)
#define ADC_CHAN_THRSEL_CH6_THRSEL_MASK          (0x40U)
#define ADC_CHAN_THRSEL_CH6_THRSEL_SHIFT         (6U)
/*! CH6_THRSEL - Threshold select for channel 6. See description for channel 0.
 */
#define ADC_CHAN_THRSEL_CH6_THRSEL(x)            (((uint32_t)(((uint32_t)(x)) << ADC_CHAN_THRSEL_CH6_THRSEL_SHIFT)) & ADC_CHAN_THRSEL_CH6_THRSEL_MASK)
#define ADC_CHAN_THRSEL_CH7_THRSEL_MASK          (0x80U)
#define ADC_CHAN_THRSEL_CH7_THRSEL_SHIFT         (7U)
/*! CH7_THRSEL - Threshold select for channel 7. See description for channel 0.
 */
#define ADC_CHAN_THRSEL_CH7_THRSEL(x)            (((uint32_t)(((uint32_t)(x)) << ADC_CHAN_THRSEL_CH7_THRSEL_SHIFT)) & ADC_CHAN_THRSEL_CH7_THRSEL_MASK)
#define ADC_CHAN_THRSEL_CH8_THRSEL_MASK          (0x100U)
#define ADC_CHAN_THRSEL_CH8_THRSEL_SHIFT         (8U)
/*! CH8_THRSEL - Threshold select for channel 8. See description for channel 0.
 */
#define ADC_CHAN_THRSEL_CH8_THRSEL(x)            (((uint32_t)(((uint32_t)(x)) << ADC_CHAN_THRSEL_CH8_THRSEL_SHIFT)) & ADC_CHAN_THRSEL_CH8_THRSEL_MASK)
#define ADC_CHAN_THRSEL_CH9_THRSEL_MASK          (0x200U)
#define ADC_CHAN_THRSEL_CH9_THRSEL_SHIFT         (9U)
/*! CH9_THRSEL - Threshold select for channel 9. See description for channel 0.
 */
#define ADC_CHAN_THRSEL_CH9_THRSEL(x)            (((uint32_t)(((uint32_t)(x)) << ADC_CHAN_THRSEL_CH9_THRSEL_SHIFT)) & ADC_CHAN_THRSEL_CH9_THRSEL_MASK)
#define ADC_CHAN_THRSEL_CH10_THRSEL_MASK         (0x400U)
#define ADC_CHAN_THRSEL_CH10_THRSEL_SHIFT        (10U)
/*! CH10_THRSEL - Threshold select for channel 10. See description for channel 0.
 */
#define ADC_CHAN_THRSEL_CH10_THRSEL(x)           (((uint32_t)(((uint32_t)(x)) << ADC_CHAN_THRSEL_CH10_THRSEL_SHIFT)) & ADC_CHAN_THRSEL_CH10_THRSEL_MASK)
#define ADC_CHAN_THRSEL_CH11_THRSEL_MASK         (0x800U)
#define ADC_CHAN_THRSEL_CH11_THRSEL_SHIFT        (11U)
/*! CH11_THRSEL - Threshold select for channel 11. See description for channel 0.
 */
#define ADC_CHAN_THRSEL_CH11_THRSEL(x)           (((uint32_t)(((uint32_t)(x)) << ADC_CHAN_THRSEL_CH11_THRSEL_SHIFT)) & ADC_CHAN_THRSEL_CH11_THRSEL_MASK)
/*! @} */

/*! @name INTEN - ADC Interrupt Enable register. This register contains enable bits that enable the sequence-A, sequence-B, threshold compare and data overrun interrupts to be generated. */
/*! @{ */
#define ADC_INTEN_SEQA_INTEN_MASK                (0x1U)
#define ADC_INTEN_SEQA_INTEN_SHIFT               (0U)
/*! SEQA_INTEN - Sequence A interrupt enable.
 *  0b0..Disabled. The sequence A interrupt/DMA trigger is disabled.
 *  0b1..Enabled. The sequence A interrupt/DMA trigger is enabled and will be asserted either upon completion of
 *       each individual conversion performed as part of sequence A, or upon completion of the entire A sequence of
 *       conversions, depending on the MODE bit in the SEQA_CTRL register.
 */
#define ADC_INTEN_SEQA_INTEN(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_SEQA_INTEN_SHIFT)) & ADC_INTEN_SEQA_INTEN_MASK)
#define ADC_INTEN_SEQB_INTEN_MASK                (0x2U)
#define ADC_INTEN_SEQB_INTEN_SHIFT               (1U)
/*! SEQB_INTEN - Sequence B interrupt enable.
 *  0b0..Disabled. The sequence B interrupt/DMA trigger is disabled.
 *  0b1..Enabled. The sequence B interrupt/DMA trigger is enabled and will be asserted either upon completion of
 *       each individual conversion performed as part of sequence B, or upon completion of the entire B sequence of
 *       conversions, depending on the MODE bit in the SEQB_CTRL register.
 */
#define ADC_INTEN_SEQB_INTEN(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_SEQB_INTEN_SHIFT)) & ADC_INTEN_SEQB_INTEN_MASK)
#define ADC_INTEN_OVR_INTEN_MASK                 (0x4U)
#define ADC_INTEN_OVR_INTEN_SHIFT                (2U)
/*! OVR_INTEN - Overrun interrupt enable.
 *  0b0..Disabled. The overrun interrupt is disabled.
 *  0b1..Enabled. The overrun interrupt is enabled. Detection of an overrun condition on any of the 12 channel
 *       data registers will cause an overrun interrupt/DMA trigger. In addition, if the MODE bit for a particular
 *       sequence is 0, then an overrun in the global data register for that sequence will also cause this
 *       interrupt/DMA trigger to be asserted.
 */
#define ADC_INTEN_OVR_INTEN(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_OVR_INTEN_SHIFT)) & ADC_INTEN_OVR_INTEN_MASK)
#define ADC_INTEN_ADCMPINTEN0_MASK               (0x18U)
#define ADC_INTEN_ADCMPINTEN0_SHIFT              (3U)
/*! ADCMPINTEN0 - Threshold comparison interrupt enable for channel 0.
 *  0b00..Disabled.
 *  0b01..Outside threshold.
 *  0b10..Crossing threshold.
 *  0b11..Reserved
 */
#define ADC_INTEN_ADCMPINTEN0(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_ADCMPINTEN0_SHIFT)) & ADC_INTEN_ADCMPINTEN0_MASK)
#define ADC_INTEN_ADCMPINTEN1_MASK               (0x60U)
#define ADC_INTEN_ADCMPINTEN1_SHIFT              (5U)
/*! ADCMPINTEN1 - Channel 1 threshold comparison interrupt enable. See description for channel 0.
 */
#define ADC_INTEN_ADCMPINTEN1(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_ADCMPINTEN1_SHIFT)) & ADC_INTEN_ADCMPINTEN1_MASK)
#define ADC_INTEN_ADCMPINTEN2_MASK               (0x180U)
#define ADC_INTEN_ADCMPINTEN2_SHIFT              (7U)
/*! ADCMPINTEN2 - Channel 2 threshold comparison interrupt enable. See description for channel 0.
 */
#define ADC_INTEN_ADCMPINTEN2(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_ADCMPINTEN2_SHIFT)) & ADC_INTEN_ADCMPINTEN2_MASK)
#define ADC_INTEN_ADCMPINTEN3_MASK               (0x600U)
#define ADC_INTEN_ADCMPINTEN3_SHIFT              (9U)
/*! ADCMPINTEN3 - Channel 3 threshold comparison interrupt enable. See description for channel 0.
 */
#define ADC_INTEN_ADCMPINTEN3(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_ADCMPINTEN3_SHIFT)) & ADC_INTEN_ADCMPINTEN3_MASK)
#define ADC_INTEN_ADCMPINTEN4_MASK               (0x1800U)
#define ADC_INTEN_ADCMPINTEN4_SHIFT              (11U)
/*! ADCMPINTEN4 - Channel 4 threshold comparison interrupt enable. See description for channel 0.
 */
#define ADC_INTEN_ADCMPINTEN4(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_ADCMPINTEN4_SHIFT)) & ADC_INTEN_ADCMPINTEN4_MASK)
#define ADC_INTEN_ADCMPINTEN5_MASK               (0x6000U)
#define ADC_INTEN_ADCMPINTEN5_SHIFT              (13U)
/*! ADCMPINTEN5 - Channel 5 threshold comparison interrupt enable. See description for channel 0.
 */
#define ADC_INTEN_ADCMPINTEN5(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_ADCMPINTEN5_SHIFT)) & ADC_INTEN_ADCMPINTEN5_MASK)
#define ADC_INTEN_ADCMPINTEN6_MASK               (0x18000U)
#define ADC_INTEN_ADCMPINTEN6_SHIFT              (15U)
/*! ADCMPINTEN6 - Channel 6 threshold comparison interrupt enable. See description for channel 0.
 */
#define ADC_INTEN_ADCMPINTEN6(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_ADCMPINTEN6_SHIFT)) & ADC_INTEN_ADCMPINTEN6_MASK)
#define ADC_INTEN_ADCMPINTEN7_MASK               (0x60000U)
#define ADC_INTEN_ADCMPINTEN7_SHIFT              (17U)
/*! ADCMPINTEN7 - Channel 7 threshold comparison interrupt enable. See description for channel 0.
 */
#define ADC_INTEN_ADCMPINTEN7(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_ADCMPINTEN7_SHIFT)) & ADC_INTEN_ADCMPINTEN7_MASK)
#define ADC_INTEN_ADCMPINTEN8_MASK               (0x180000U)
#define ADC_INTEN_ADCMPINTEN8_SHIFT              (19U)
/*! ADCMPINTEN8 - Channel 8 threshold comparison interrupt enable. See description for channel 0.
 */
#define ADC_INTEN_ADCMPINTEN8(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_ADCMPINTEN8_SHIFT)) & ADC_INTEN_ADCMPINTEN8_MASK)
#define ADC_INTEN_ADCMPINTEN9_MASK               (0x600000U)
#define ADC_INTEN_ADCMPINTEN9_SHIFT              (21U)
/*! ADCMPINTEN9 - Channel 9 threshold comparison interrupt enable. See description for channel 0.
 */
#define ADC_INTEN_ADCMPINTEN9(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_ADCMPINTEN9_SHIFT)) & ADC_INTEN_ADCMPINTEN9_MASK)
#define ADC_INTEN_ADCMPINTEN10_MASK              (0x1800000U)
#define ADC_INTEN_ADCMPINTEN10_SHIFT             (23U)
/*! ADCMPINTEN10 - Channel 10 threshold comparison interrupt enable. See description for channel 0.
 */
#define ADC_INTEN_ADCMPINTEN10(x)                (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_ADCMPINTEN10_SHIFT)) & ADC_INTEN_ADCMPINTEN10_MASK)
#define ADC_INTEN_ADCMPINTEN11_MASK              (0x6000000U)
#define ADC_INTEN_ADCMPINTEN11_SHIFT             (25U)
/*! ADCMPINTEN11 - Channel 21 threshold comparison interrupt enable. See description for channel 0.
 */
#define ADC_INTEN_ADCMPINTEN11(x)                (((uint32_t)(((uint32_t)(x)) << ADC_INTEN_ADCMPINTEN11_SHIFT)) & ADC_INTEN_ADCMPINTEN11_MASK)
/*! @} */

/*! @name FLAGS - ADC Flags register. Contains the four interrupt/DMA trigger flags and the individual component overrun and threshold-compare flags. (The overrun bits replicate information stored in the result registers). */
/*! @{ */
#define ADC_FLAGS_THCMP0_MASK                    (0x1U)
#define ADC_FLAGS_THCMP0_SHIFT                   (0U)
/*! THCMP0 - Threshold comparison event on Channel 0. Set to 1 upon either an out-of-range result or
 *    a threshold-crossing result if enabled to do so in the INTEN register. This bit is cleared by
 *    writing a 1.
 */
#define ADC_FLAGS_THCMP0(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_THCMP0_SHIFT)) & ADC_FLAGS_THCMP0_MASK)
#define ADC_FLAGS_THCMP1_MASK                    (0x2U)
#define ADC_FLAGS_THCMP1_SHIFT                   (1U)
/*! THCMP1 - Threshold comparison event on Channel 1. See description for channel 0.
 */
#define ADC_FLAGS_THCMP1(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_THCMP1_SHIFT)) & ADC_FLAGS_THCMP1_MASK)
#define ADC_FLAGS_THCMP2_MASK                    (0x4U)
#define ADC_FLAGS_THCMP2_SHIFT                   (2U)
/*! THCMP2 - Threshold comparison event on Channel 2. See description for channel 0.
 */
#define ADC_FLAGS_THCMP2(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_THCMP2_SHIFT)) & ADC_FLAGS_THCMP2_MASK)
#define ADC_FLAGS_THCMP3_MASK                    (0x8U)
#define ADC_FLAGS_THCMP3_SHIFT                   (3U)
/*! THCMP3 - Threshold comparison event on Channel 3. See description for channel 0.
 */
#define ADC_FLAGS_THCMP3(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_THCMP3_SHIFT)) & ADC_FLAGS_THCMP3_MASK)
#define ADC_FLAGS_THCMP4_MASK                    (0x10U)
#define ADC_FLAGS_THCMP4_SHIFT                   (4U)
/*! THCMP4 - Threshold comparison event on Channel 4. See description for channel 0.
 */
#define ADC_FLAGS_THCMP4(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_THCMP4_SHIFT)) & ADC_FLAGS_THCMP4_MASK)
#define ADC_FLAGS_THCMP5_MASK                    (0x20U)
#define ADC_FLAGS_THCMP5_SHIFT                   (5U)
/*! THCMP5 - Threshold comparison event on Channel 5. See description for channel 0.
 */
#define ADC_FLAGS_THCMP5(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_THCMP5_SHIFT)) & ADC_FLAGS_THCMP5_MASK)
#define ADC_FLAGS_THCMP6_MASK                    (0x40U)
#define ADC_FLAGS_THCMP6_SHIFT                   (6U)
/*! THCMP6 - Threshold comparison event on Channel 6. See description for channel 0.
 */
#define ADC_FLAGS_THCMP6(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_THCMP6_SHIFT)) & ADC_FLAGS_THCMP6_MASK)
#define ADC_FLAGS_THCMP7_MASK                    (0x80U)
#define ADC_FLAGS_THCMP7_SHIFT                   (7U)
/*! THCMP7 - Threshold comparison event on Channel 7. See description for channel 0.
 */
#define ADC_FLAGS_THCMP7(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_THCMP7_SHIFT)) & ADC_FLAGS_THCMP7_MASK)
#define ADC_FLAGS_THCMP8_MASK                    (0x100U)
#define ADC_FLAGS_THCMP8_SHIFT                   (8U)
/*! THCMP8 - Threshold comparison event on Channel 8. See description for channel 0.
 */
#define ADC_FLAGS_THCMP8(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_THCMP8_SHIFT)) & ADC_FLAGS_THCMP8_MASK)
#define ADC_FLAGS_THCMP9_MASK                    (0x200U)
#define ADC_FLAGS_THCMP9_SHIFT                   (9U)
/*! THCMP9 - Threshold comparison event on Channel 9. See description for channel 0.
 */
#define ADC_FLAGS_THCMP9(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_THCMP9_SHIFT)) & ADC_FLAGS_THCMP9_MASK)
#define ADC_FLAGS_THCMP10_MASK                   (0x400U)
#define ADC_FLAGS_THCMP10_SHIFT                  (10U)
/*! THCMP10 - Threshold comparison event on Channel 10. See description for channel 0.
 */
#define ADC_FLAGS_THCMP10(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_THCMP10_SHIFT)) & ADC_FLAGS_THCMP10_MASK)
#define ADC_FLAGS_THCMP11_MASK                   (0x800U)
#define ADC_FLAGS_THCMP11_SHIFT                  (11U)
/*! THCMP11 - Threshold comparison event on Channel 11. See description for channel 0.
 */
#define ADC_FLAGS_THCMP11(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_THCMP11_SHIFT)) & ADC_FLAGS_THCMP11_MASK)
#define ADC_FLAGS_OVERRUN0_MASK                  (0x1000U)
#define ADC_FLAGS_OVERRUN0_SHIFT                 (12U)
/*! OVERRUN0 - Mirrors the OVERRRUN status flag from the result register for ADC channel 0
 */
#define ADC_FLAGS_OVERRUN0(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_OVERRUN0_SHIFT)) & ADC_FLAGS_OVERRUN0_MASK)
#define ADC_FLAGS_OVERRUN1_MASK                  (0x2000U)
#define ADC_FLAGS_OVERRUN1_SHIFT                 (13U)
/*! OVERRUN1 - Mirrors the OVERRRUN status flag from the result register for ADC channel 1
 */
#define ADC_FLAGS_OVERRUN1(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_OVERRUN1_SHIFT)) & ADC_FLAGS_OVERRUN1_MASK)
#define ADC_FLAGS_OVERRUN2_MASK                  (0x4000U)
#define ADC_FLAGS_OVERRUN2_SHIFT                 (14U)
/*! OVERRUN2 - Mirrors the OVERRRUN status flag from the result register for ADC channel 2
 */
#define ADC_FLAGS_OVERRUN2(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_OVERRUN2_SHIFT)) & ADC_FLAGS_OVERRUN2_MASK)
#define ADC_FLAGS_OVERRUN3_MASK                  (0x8000U)
#define ADC_FLAGS_OVERRUN3_SHIFT                 (15U)
/*! OVERRUN3 - Mirrors the OVERRRUN status flag from the result register for ADC channel 3
 */
#define ADC_FLAGS_OVERRUN3(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_OVERRUN3_SHIFT)) & ADC_FLAGS_OVERRUN3_MASK)
#define ADC_FLAGS_OVERRUN4_MASK                  (0x10000U)
#define ADC_FLAGS_OVERRUN4_SHIFT                 (16U)
/*! OVERRUN4 - Mirrors the OVERRRUN status flag from the result register for ADC channel 4
 */
#define ADC_FLAGS_OVERRUN4(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_OVERRUN4_SHIFT)) & ADC_FLAGS_OVERRUN4_MASK)
#define ADC_FLAGS_OVERRUN5_MASK                  (0x20000U)
#define ADC_FLAGS_OVERRUN5_SHIFT                 (17U)
/*! OVERRUN5 - Mirrors the OVERRRUN status flag from the result register for ADC channel 5
 */
#define ADC_FLAGS_OVERRUN5(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_OVERRUN5_SHIFT)) & ADC_FLAGS_OVERRUN5_MASK)
#define ADC_FLAGS_OVERRUN6_MASK                  (0x40000U)
#define ADC_FLAGS_OVERRUN6_SHIFT                 (18U)
/*! OVERRUN6 - Mirrors the OVERRRUN status flag from the result register for ADC channel 6
 */
#define ADC_FLAGS_OVERRUN6(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_OVERRUN6_SHIFT)) & ADC_FLAGS_OVERRUN6_MASK)
#define ADC_FLAGS_OVERRUN7_MASK                  (0x80000U)
#define ADC_FLAGS_OVERRUN7_SHIFT                 (19U)
/*! OVERRUN7 - Mirrors the OVERRRUN status flag from the result register for ADC channel 7
 */
#define ADC_FLAGS_OVERRUN7(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_OVERRUN7_SHIFT)) & ADC_FLAGS_OVERRUN7_MASK)
#define ADC_FLAGS_OVERRUN8_MASK                  (0x100000U)
#define ADC_FLAGS_OVERRUN8_SHIFT                 (20U)
/*! OVERRUN8 - Mirrors the OVERRRUN status flag from the result register for ADC channel 8
 */
#define ADC_FLAGS_OVERRUN8(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_OVERRUN8_SHIFT)) & ADC_FLAGS_OVERRUN8_MASK)
#define ADC_FLAGS_OVERRUN9_MASK                  (0x200000U)
#define ADC_FLAGS_OVERRUN9_SHIFT                 (21U)
/*! OVERRUN9 - Mirrors the OVERRRUN status flag from the result register for ADC channel 9
 */
#define ADC_FLAGS_OVERRUN9(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_OVERRUN9_SHIFT)) & ADC_FLAGS_OVERRUN9_MASK)
#define ADC_FLAGS_OVERRUN10_MASK                 (0x400000U)
#define ADC_FLAGS_OVERRUN10_SHIFT                (22U)
/*! OVERRUN10 - Mirrors the OVERRRUN status flag from the result register for ADC channel 10
 */
#define ADC_FLAGS_OVERRUN10(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_OVERRUN10_SHIFT)) & ADC_FLAGS_OVERRUN10_MASK)
#define ADC_FLAGS_OVERRUN11_MASK                 (0x800000U)
#define ADC_FLAGS_OVERRUN11_SHIFT                (23U)
/*! OVERRUN11 - Mirrors the OVERRRUN status flag from the result register for ADC channel 11
 */
#define ADC_FLAGS_OVERRUN11(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_OVERRUN11_SHIFT)) & ADC_FLAGS_OVERRUN11_MASK)
#define ADC_FLAGS_SEQA_OVR_MASK                  (0x1000000U)
#define ADC_FLAGS_SEQA_OVR_SHIFT                 (24U)
/*! SEQA_OVR - Mirrors the global OVERRUN status flag in the SEQA_GDAT register
 */
#define ADC_FLAGS_SEQA_OVR(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_SEQA_OVR_SHIFT)) & ADC_FLAGS_SEQA_OVR_MASK)
#define ADC_FLAGS_SEQB_OVR_MASK                  (0x2000000U)
#define ADC_FLAGS_SEQB_OVR_SHIFT                 (25U)
/*! SEQB_OVR - Mirrors the global OVERRUN status flag in the SEQB_GDAT register
 */
#define ADC_FLAGS_SEQB_OVR(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_SEQB_OVR_SHIFT)) & ADC_FLAGS_SEQB_OVR_MASK)
#define ADC_FLAGS_SEQA_INT_MASK                  (0x10000000U)
#define ADC_FLAGS_SEQA_INT_SHIFT                 (28U)
/*! SEQA_INT - Sequence A interrupt/DMA trigger. If the MODE bit in the SEQA_CTRL register is 0,
 *    this flag will mirror the DATAVALID bit in the sequence A global data register (SEQA_GDAT), which
 *    is set at the end of every ADC conversion performed as part of sequence A. It will be cleared
 *    automatically when the SEQA_GDAT register is read. If the MODE bit in the SEQA_CTRL register
 *    is 1, this flag will be set upon completion of an entire A sequence. In this case it must be
 *    cleared by writing a 1 to this SEQA_INT bit. This interrupt must be enabled in the INTEN
 *    register.
 */
#define ADC_FLAGS_SEQA_INT(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_SEQA_INT_SHIFT)) & ADC_FLAGS_SEQA_INT_MASK)
#define ADC_FLAGS_SEQB_INT_MASK                  (0x20000000U)
#define ADC_FLAGS_SEQB_INT_SHIFT                 (29U)
/*! SEQB_INT - Sequence A interrupt/DMA trigger. If the MODE bit in the SEQB_CTRL register is 0,
 *    this flag will mirror the DATAVALID bit in the sequence A global data register (SEQB_GDAT), which
 *    is set at the end of every ADC conversion performed as part of sequence B. It will be cleared
 *    automatically when the SEQB_GDAT register is read. If the MODE bit in the SEQB_CTRL register
 *    is 1, this flag will be set upon completion of an entire B sequence. In this case it must be
 *    cleared by writing a 1 to this SEQB_INT bit. This interrupt must be enabled in the INTEN
 *    register.
 */
#define ADC_FLAGS_SEQB_INT(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_SEQB_INT_SHIFT)) & ADC_FLAGS_SEQB_INT_MASK)
#define ADC_FLAGS_THCMP_INT_MASK                 (0x40000000U)
#define ADC_FLAGS_THCMP_INT_SHIFT                (30U)
/*! THCMP_INT - Threshold Comparison Interrupt. This bit will be set if any of the THCMP flags in
 *    the lower bits of this register are set to 1 (due to an enabled out-of-range or
 *    threshold-crossing event on any channel). Each type of threshold comparison interrupt on each channel must be
 *    individually enabled in the INTEN register to cause this interrupt. This bit will be cleared
 *    when all of the individual threshold flags are cleared via writing 1s to those bits.
 */
#define ADC_FLAGS_THCMP_INT(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_THCMP_INT_SHIFT)) & ADC_FLAGS_THCMP_INT_MASK)
#define ADC_FLAGS_OVR_INT_MASK                   (0x80000000U)
#define ADC_FLAGS_OVR_INT_SHIFT                  (31U)
/*! OVR_INT - Overrun Interrupt flag. Any overrun bit in any of the individual channel data
 *    registers will cause this interrupt. In addition, if the MODE bit in either of the SEQn_CTRL registers
 *    is 0 then the OVERRUN bit in the corresponding SEQn_GDAT register will also cause this
 *    interrupt. This interrupt must be enabled in the INTEN register. This bit will be cleared when all
 *    of the individual overrun bits have been cleared via reading the corresponding data registers.
 */
#define ADC_FLAGS_OVR_INT(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_FLAGS_OVR_INT_SHIFT)) & ADC_FLAGS_OVR_INT_MASK)
/*! @} */

/*! @name STARTUP - ADC Startup register. */
/*! @{ */
#define ADC_STARTUP_ADC_ENA_MASK                 (0x1U)
#define ADC_STARTUP_ADC_ENA_SHIFT                (0U)
/*! ADC_ENA - ADC Enable bit. This bit can only be set to a 1 by software. It is cleared
 *    automatically whenever the ADC is powered down. This bit must not be set until at least 10 microseconds
 *    after the ADC is powered up (typically by altering a system-level ADC power control bit).
 */
#define ADC_STARTUP_ADC_ENA(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_STARTUP_ADC_ENA_SHIFT)) & ADC_STARTUP_ADC_ENA_MASK)
#define ADC_STARTUP_ADC_INIT_MASK                (0x2U)
#define ADC_STARTUP_ADC_INIT_SHIFT               (1U)
/*! ADC_INIT - ADC Initialization. After enabling the ADC (setting the ADC_ENA bit), the API routine
 *    will EITHER set this bit or the CALIB bit in the CALIB register, depending on whether or not
 *    calibration is required. Setting this bit will launch the 'dummy' conversion cycle that is
 *    required if a calibration is not performed. It will also reload the stored calibration value from
 *    a previous calibration unless the BYPASSCAL bit is set. This bit should only be set AFTER the
 *    ADC_ENA bit is set and after the CALIREQD bit is tested to determine whether a calibration or
 *    an ADC dummy conversion cycle is required. It should not be set during the same write that
 *    sets the ADC_ENA bit. This bit can only be set to a '1' by software. It is cleared automatically
 *    when the 'dummy' conversion cycle completes.
 */
#define ADC_STARTUP_ADC_INIT(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_STARTUP_ADC_INIT_SHIFT)) & ADC_STARTUP_ADC_INIT_MASK)
/*! @} */

/*! @name CALIB - ADC Calibration register. */
/*! @{ */
#define ADC_CALIB_CALIB_MASK                     (0x1U)
#define ADC_CALIB_CALIB_SHIFT                    (0U)
/*! CALIB - Calibration request. Setting this bit will launch an ADC calibration cycle. This bit can
 *    only be set to a '1' by software. It is cleared automatically when the calibration cycle
 *    completes.
 */
#define ADC_CALIB_CALIB(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CALIB_CALIB_SHIFT)) & ADC_CALIB_CALIB_MASK)
#define ADC_CALIB_CALREQD_MASK                   (0x2U)
#define ADC_CALIB_CALREQD_SHIFT                  (1U)
/*! CALREQD - Calibration required. This read-only bit indicates if calibration is required when
 *    enabling the ADC. CALREQD will be '1' if no calibration has been run since the chip was
 *    powered-up and if the BYPASSCAL bit in the CTRL register is low. Software will test this bit to
 *    determine whether to initiate a calibration cycle or whether to set the ADC_INIT bit (in the STARTUP
 *    register) to launch the ADC initialization process which includes a 'dummy' conversion cycle.
 *    Note: A 'dummy' conversion cycle requires approximately 6 ADC clocks as opposed to 81 clocks
 *    required for calibration.
 */
#define ADC_CALIB_CALREQD(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CALIB_CALREQD_SHIFT)) & ADC_CALIB_CALREQD_MASK)
#define ADC_CALIB_CALVALUE_MASK                  (0x1FCU)
#define ADC_CALIB_CALVALUE_SHIFT                 (2U)
/*! CALVALUE - Calibration Value. This read-only field displays the calibration value established
 *    during last calibration cycle. This value is not typically of any use to the user.
 */
#define ADC_CALIB_CALVALUE(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_CALIB_CALVALUE_SHIFT)) & ADC_CALIB_CALVALUE_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
/** Peripheral ADC0 base address */
#define ADC0_BASE                                (0x400A0000u)
/** Peripheral ADC0 base pointer */
#define ADC0                                     ((ADC_Type *)ADC0_BASE)
/** Array initializer of ADC peripheral base addresses */
#define ADC_BASE_ADDRS                           { ADC0_BASE }
/** Array initializer of ADC peripheral base pointers */
#define ADC_BASE_PTRS                            { ADC0 }
/** Interrupt vectors for the ADC peripheral type */
#define ADC_SEQ_IRQS                             { ADC0_SEQA_IRQn, ADC0_SEQB_IRQn }
#define ADC_THCMP_IRQS                           { ADC0_THCMP_IRQn }

/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AES Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AES_Peripheral_Access_Layer AES Peripheral Access Layer
 * @{
 */

/** AES - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    __IO uint32_t CFG;                               /**< AES Configuration register, offset: 0x0 */
    struct {                                         /* offset: 0x0 */
      union {                                          /* offset: 0x0 */
        __IO uint16_t CFG0_15;                           /**< AES Configuration register 0:15, offset: 0x0 */
        struct {                                         /* offset: 0x0 */
          __IO uint8_t CFG0_7;                             /**< AES Configuration register 0:7, offset: 0x0 */
          __IO uint8_t CFG8_15;                            /**< AES Configuration register 8:15, offset: 0x1 */
        } CFGL;
      };
      __IO uint16_t CFG16_31;                          /**< AES Configuration register 16:31, offset: 0x2 */
    } CFG0_32;
  };
  __IO uint32_t CMD;                               /**< AES Command register, offset: 0x4 */
  __IO uint32_t STAT;                              /**< AES Status register, offset: 0x8 */
  __IO uint32_t CTR_INCR;                          /**< Counter Increment, offset: 0xC */
       uint8_t RESERVED_0[16];
  __O  uint32_t KEY[8];                            /**< Bits of the AES key, array offset: 0x20, array step: 0x4 */
  __O  uint32_t INTEXT[4];                         /**< Input text bits, array offset: 0x40, array step: 0x4 */
  __O  uint32_t HOLDING[4];                        /**< Holding register bits, array offset: 0x50, array step: 0x4 */
  __I  uint32_t OUTTEXT[4];                        /**< Output text bits, array offset: 0x60, array step: 0x4 */
  __O  uint32_t GF128_Y[4];                        /**< Y bits input of GF128 hash, array offset: 0x70, array step: 0x4 */
  __I  uint32_t GF128_Z[4];                        /**< Result bits of GF128 hash, array offset: 0x80, array step: 0x4 */
  __I  uint32_t GCM_TAG[4];                        /**< GCM Tag bits, array offset: 0x90, array step: 0x4 */
} AES_Type;

/* ----------------------------------------------------------------------------
   -- AES Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AES_Register_Masks AES Register Masks
 * @{
 */

/*! @name CFG - AES Configuration register */
/*! @{ */
#define AES_CFG_PROC_EN_MASK                     (0x3U)
#define AES_CFG_PROC_EN_SHIFT                    (0U)
/*! PROC_EN - Process type enable.
 */
#define AES_CFG_PROC_EN(x)                       (((uint32_t)(((uint32_t)(x)) << AES_CFG_PROC_EN_SHIFT)) & AES_CFG_PROC_EN_MASK)
#define AES_CFG_GF128_SEL_MASK                   (0x4U)
#define AES_CFG_GF128_SEL_SHIFT                  (2U)
/*! GF128_SEL - GF128 hash selection.
 */
#define AES_CFG_GF128_SEL(x)                     (((uint32_t)(((uint32_t)(x)) << AES_CFG_GF128_SEL_SHIFT)) & AES_CFG_GF128_SEL_MASK)
#define AES_CFG_INTEXT_BSWAP_MASK                (0x10U)
#define AES_CFG_INTEXT_BSWAP_SHIFT               (4U)
/*! INTEXT_BSWAP - Byte swap input text.
 */
#define AES_CFG_INTEXT_BSWAP(x)                  (((uint32_t)(((uint32_t)(x)) << AES_CFG_INTEXT_BSWAP_SHIFT)) & AES_CFG_INTEXT_BSWAP_MASK)
#define AES_CFG_INTEXT_WSWAP_MASK                (0x20U)
#define AES_CFG_INTEXT_WSWAP_SHIFT               (5U)
/*! INTEXT_WSWAP - Word swap input text.
 */
#define AES_CFG_INTEXT_WSWAP(x)                  (((uint32_t)(((uint32_t)(x)) << AES_CFG_INTEXT_WSWAP_SHIFT)) & AES_CFG_INTEXT_WSWAP_MASK)
#define AES_CFG_OUTTEXT_BSWAP_MASK               (0x40U)
#define AES_CFG_OUTTEXT_BSWAP_SHIFT              (6U)
/*! OUTTEXT_BSWAP - Byte swap output text.
 */
#define AES_CFG_OUTTEXT_BSWAP(x)                 (((uint32_t)(((uint32_t)(x)) << AES_CFG_OUTTEXT_BSWAP_SHIFT)) & AES_CFG_OUTTEXT_BSWAP_MASK)
#define AES_CFG_OUTTEXT_WSWAP_MASK               (0x80U)
#define AES_CFG_OUTTEXT_WSWAP_SHIFT              (7U)
/*! OUTTEXT_WSWAP - Word swap output text.
 */
#define AES_CFG_OUTTEXT_WSWAP(x)                 (((uint32_t)(((uint32_t)(x)) << AES_CFG_OUTTEXT_WSWAP_SHIFT)) & AES_CFG_OUTTEXT_WSWAP_MASK)
#define AES_CFG_KEY_CFG_MASK                     (0x300U)
#define AES_CFG_KEY_CFG_SHIFT                    (8U)
/*! KEY_CFG - Key Configuration.
 */
#define AES_CFG_KEY_CFG(x)                       (((uint32_t)(((uint32_t)(x)) << AES_CFG_KEY_CFG_SHIFT)) & AES_CFG_KEY_CFG_MASK)
#define AES_CFG_INBLK_SEL_MASK                   (0x30000U)
#define AES_CFG_INBLK_SEL_SHIFT                  (16U)
/*! INBLK_SEL - Input block select.
 */
#define AES_CFG_INBLK_SEL(x)                     (((uint32_t)(((uint32_t)(x)) << AES_CFG_INBLK_SEL_SHIFT)) & AES_CFG_INBLK_SEL_MASK)
#define AES_CFG_HOLD_SEL_MASK                    (0x300000U)
#define AES_CFG_HOLD_SEL_SHIFT                   (20U)
/*! HOLD_SEL - Holding register source select.
 */
#define AES_CFG_HOLD_SEL(x)                      (((uint32_t)(((uint32_t)(x)) << AES_CFG_HOLD_SEL_SHIFT)) & AES_CFG_HOLD_SEL_MASK)
#define AES_CFG_OUTTEXT_SEL_MASK                 (0x3000000U)
#define AES_CFG_OUTTEXT_SEL_SHIFT                (24U)
/*! OUTTEXT_SEL - Output text source select.
 */
#define AES_CFG_OUTTEXT_SEL(x)                   (((uint32_t)(((uint32_t)(x)) << AES_CFG_OUTTEXT_SEL_SHIFT)) & AES_CFG_OUTTEXT_SEL_MASK)
/*! @} */

/*! @name CFG0_15 - AES Configuration register 0:15 */
/*! @{ */
#define AES_CFG0_15_PROC_EN_MASK                 (0x3U)
#define AES_CFG0_15_PROC_EN_SHIFT                (0U)
/*! PROC_EN - Process type enable.
 */
#define AES_CFG0_15_PROC_EN(x)                   (((uint16_t)(((uint16_t)(x)) << AES_CFG0_15_PROC_EN_SHIFT)) & AES_CFG0_15_PROC_EN_MASK)
#define AES_CFG0_15_GF128_SEL_MASK               (0x4U)
#define AES_CFG0_15_GF128_SEL_SHIFT              (2U)
/*! GF128_SEL - GF128 hash selection.
 */
#define AES_CFG0_15_GF128_SEL(x)                 (((uint16_t)(((uint16_t)(x)) << AES_CFG0_15_GF128_SEL_SHIFT)) & AES_CFG0_15_GF128_SEL_MASK)
#define AES_CFG0_15_INTEXT_BSWAP_MASK            (0x10U)
#define AES_CFG0_15_INTEXT_BSWAP_SHIFT           (4U)
/*! INTEXT_BSWAP - Byte swap input text.
 */
#define AES_CFG0_15_INTEXT_BSWAP(x)              (((uint16_t)(((uint16_t)(x)) << AES_CFG0_15_INTEXT_BSWAP_SHIFT)) & AES_CFG0_15_INTEXT_BSWAP_MASK)
#define AES_CFG0_15_INTEXT_WSWAP_MASK            (0x20U)
#define AES_CFG0_15_INTEXT_WSWAP_SHIFT           (5U)
/*! INTEXT_WSWAP - Word swap input text.
 */
#define AES_CFG0_15_INTEXT_WSWAP(x)              (((uint16_t)(((uint16_t)(x)) << AES_CFG0_15_INTEXT_WSWAP_SHIFT)) & AES_CFG0_15_INTEXT_WSWAP_MASK)
#define AES_CFG0_15_OUTTEXT_BSWAP_MASK           (0x40U)
#define AES_CFG0_15_OUTTEXT_BSWAP_SHIFT          (6U)
/*! OUTTEXT_BSWAP - Byte swap output text.
 */
#define AES_CFG0_15_OUTTEXT_BSWAP(x)             (((uint16_t)(((uint16_t)(x)) << AES_CFG0_15_OUTTEXT_BSWAP_SHIFT)) & AES_CFG0_15_OUTTEXT_BSWAP_MASK)
#define AES_CFG0_15_OUTTEXT_WSWAP_MASK           (0x80U)
#define AES_CFG0_15_OUTTEXT_WSWAP_SHIFT          (7U)
/*! OUTTEXT_WSWAP - Word swap output text.
 */
#define AES_CFG0_15_OUTTEXT_WSWAP(x)             (((uint16_t)(((uint16_t)(x)) << AES_CFG0_15_OUTTEXT_WSWAP_SHIFT)) & AES_CFG0_15_OUTTEXT_WSWAP_MASK)
#define AES_CFG0_15_KEY_CFG_MASK                 (0x300U)
#define AES_CFG0_15_KEY_CFG_SHIFT                (8U)
/*! KEY_CFG - Key Configuration.
 */
#define AES_CFG0_15_KEY_CFG(x)                   (((uint16_t)(((uint16_t)(x)) << AES_CFG0_15_KEY_CFG_SHIFT)) & AES_CFG0_15_KEY_CFG_MASK)
/*! @} */

/*! @name CFG0_7 - AES Configuration register 0:7 */
/*! @{ */
#define AES_CFG0_7_PROC_EN_MASK                  (0x3U)
#define AES_CFG0_7_PROC_EN_SHIFT                 (0U)
/*! PROC_EN - Process type enable.
 */
#define AES_CFG0_7_PROC_EN(x)                    (((uint8_t)(((uint8_t)(x)) << AES_CFG0_7_PROC_EN_SHIFT)) & AES_CFG0_7_PROC_EN_MASK)
#define AES_CFG0_7_GF128_SEL_MASK                (0x4U)
#define AES_CFG0_7_GF128_SEL_SHIFT               (2U)
/*! GF128_SEL - GF128 hash selection.
 */
#define AES_CFG0_7_GF128_SEL(x)                  (((uint8_t)(((uint8_t)(x)) << AES_CFG0_7_GF128_SEL_SHIFT)) & AES_CFG0_7_GF128_SEL_MASK)
#define AES_CFG0_7_INTEXT_BSWAP_MASK             (0x10U)
#define AES_CFG0_7_INTEXT_BSWAP_SHIFT            (4U)
/*! INTEXT_BSWAP - Byte swap input text.
 */
#define AES_CFG0_7_INTEXT_BSWAP(x)               (((uint8_t)(((uint8_t)(x)) << AES_CFG0_7_INTEXT_BSWAP_SHIFT)) & AES_CFG0_7_INTEXT_BSWAP_MASK)
#define AES_CFG0_7_INTEXT_WSWAP_MASK             (0x20U)
#define AES_CFG0_7_INTEXT_WSWAP_SHIFT            (5U)
/*! INTEXT_WSWAP - Word swap input text.
 */
#define AES_CFG0_7_INTEXT_WSWAP(x)               (((uint8_t)(((uint8_t)(x)) << AES_CFG0_7_INTEXT_WSWAP_SHIFT)) & AES_CFG0_7_INTEXT_WSWAP_MASK)
#define AES_CFG0_7_OUTTEXT_BSWAP_MASK            (0x40U)
#define AES_CFG0_7_OUTTEXT_BSWAP_SHIFT           (6U)
/*! OUTTEXT_BSWAP - Byte swap output text.
 */
#define AES_CFG0_7_OUTTEXT_BSWAP(x)              (((uint8_t)(((uint8_t)(x)) << AES_CFG0_7_OUTTEXT_BSWAP_SHIFT)) & AES_CFG0_7_OUTTEXT_BSWAP_MASK)
#define AES_CFG0_7_OUTTEXT_WSWAP_MASK            (0x80U)
#define AES_CFG0_7_OUTTEXT_WSWAP_SHIFT           (7U)
/*! OUTTEXT_WSWAP - Word swap output text.
 */
#define AES_CFG0_7_OUTTEXT_WSWAP(x)              (((uint8_t)(((uint8_t)(x)) << AES_CFG0_7_OUTTEXT_WSWAP_SHIFT)) & AES_CFG0_7_OUTTEXT_WSWAP_MASK)
/*! @} */

/*! @name CFG8_15 - AES Configuration register 8:15 */
/*! @{ */
#define AES_CFG8_15_KEY_CFG_MASK                 (0x3U)
#define AES_CFG8_15_KEY_CFG_SHIFT                (0U)
/*! KEY_CFG - Key Configuration.
 */
#define AES_CFG8_15_KEY_CFG(x)                   (((uint8_t)(((uint8_t)(x)) << AES_CFG8_15_KEY_CFG_SHIFT)) & AES_CFG8_15_KEY_CFG_MASK)
/*! @} */

/*! @name CFG16_31 - AES Configuration register 16:31 */
/*! @{ */
#define AES_CFG16_31_INBLK_SEL_MASK              (0x3U)
#define AES_CFG16_31_INBLK_SEL_SHIFT             (0U)
/*! INBLK_SEL - Input block select.
 */
#define AES_CFG16_31_INBLK_SEL(x)                (((uint16_t)(((uint16_t)(x)) << AES_CFG16_31_INBLK_SEL_SHIFT)) & AES_CFG16_31_INBLK_SEL_MASK)
#define AES_CFG16_31_HOLD_SEL_MASK               (0x30U)
#define AES_CFG16_31_HOLD_SEL_SHIFT              (4U)
/*! HOLD_SEL - Holding register source select.
 */
#define AES_CFG16_31_HOLD_SEL(x)                 (((uint16_t)(((uint16_t)(x)) << AES_CFG16_31_HOLD_SEL_SHIFT)) & AES_CFG16_31_HOLD_SEL_MASK)
#define AES_CFG16_31_OUTTEXT_SEL_MASK            (0x300U)
#define AES_CFG16_31_OUTTEXT_SEL_SHIFT           (8U)
/*! OUTTEXT_SEL - Output text source select.
 */
#define AES_CFG16_31_OUTTEXT_SEL(x)              (((uint16_t)(((uint16_t)(x)) << AES_CFG16_31_OUTTEXT_SEL_SHIFT)) & AES_CFG16_31_OUTTEXT_SEL_MASK)
/*! @} */

/*! @name CMD - AES Command register */
/*! @{ */
#define AES_CMD_COPY_TO_Y_MASK                   (0x2U)
#define AES_CMD_COPY_TO_Y_SHIFT                  (1U)
/*! COPY_TO_Y - Copy output text to GF128Y.
 */
#define AES_CMD_COPY_TO_Y(x)                     (((uint32_t)(((uint32_t)(x)) << AES_CMD_COPY_TO_Y_SHIFT)) & AES_CMD_COPY_TO_Y_MASK)
#define AES_CMD_SWITCH_MODE_MASK                 (0x10U)
#define AES_CMD_SWITCH_MODE_SHIFT                (4U)
/*! SWITCH_MODE - When this bit is set the mode switches from forward mode (encryption) to reverse
 *    mode (decryption) or reverse mode to forward mode.
 */
#define AES_CMD_SWITCH_MODE(x)                   (((uint32_t)(((uint32_t)(x)) << AES_CMD_SWITCH_MODE_SHIFT)) & AES_CMD_SWITCH_MODE_MASK)
#define AES_CMD_ABORT_MASK                       (0x100U)
#define AES_CMD_ABORT_SHIFT                      (8U)
/*! ABORT - Aborts Encrypt/Decrypt and GF128 Hash operation.
 */
#define AES_CMD_ABORT(x)                         (((uint32_t)(((uint32_t)(x)) << AES_CMD_ABORT_SHIFT)) & AES_CMD_ABORT_MASK)
#define AES_CMD_WIPE_MASK                        (0x200U)
#define AES_CMD_WIPE_SHIFT                       (9U)
/*! WIPE - When set this bit performs abort, clears KEY and GF128_Y registers and disables cipher.
 */
#define AES_CMD_WIPE(x)                          (((uint32_t)(((uint32_t)(x)) << AES_CMD_WIPE_SHIFT)) & AES_CMD_WIPE_MASK)
/*! @} */

/*! @name STAT - AES Status register */
/*! @{ */
#define AES_STAT_IDLE_MASK                       (0x1U)
#define AES_STAT_IDLE_SHIFT                      (0U)
/*! IDLE - AES engine Idle.
 */
#define AES_STAT_IDLE(x)                         (((uint32_t)(((uint32_t)(x)) << AES_STAT_IDLE_SHIFT)) & AES_STAT_IDLE_MASK)
#define AES_STAT_IN_READY_MASK                   (0x2U)
#define AES_STAT_IN_READY_SHIFT                  (1U)
/*! IN_READY - Input text ready.
 */
#define AES_STAT_IN_READY(x)                     (((uint32_t)(((uint32_t)(x)) << AES_STAT_IN_READY_SHIFT)) & AES_STAT_IN_READY_MASK)
#define AES_STAT_OUT_READY_MASK                  (0x4U)
#define AES_STAT_OUT_READY_SHIFT                 (2U)
/*! OUT_READY - Output text ready.
 */
#define AES_STAT_OUT_READY(x)                    (((uint32_t)(((uint32_t)(x)) << AES_STAT_OUT_READY_SHIFT)) & AES_STAT_OUT_READY_MASK)
#define AES_STAT_REVERSE_MASK                    (0x10U)
#define AES_STAT_REVERSE_SHIFT                   (4U)
/*! REVERSE - Reverse mode.
 */
#define AES_STAT_REVERSE(x)                      (((uint32_t)(((uint32_t)(x)) << AES_STAT_REVERSE_SHIFT)) & AES_STAT_REVERSE_MASK)
#define AES_STAT_KEY_VALID_MASK                  (0x20U)
#define AES_STAT_KEY_VALID_SHIFT                 (5U)
/*! KEY_VALID - Key valid.
 */
#define AES_STAT_KEY_VALID(x)                    (((uint32_t)(((uint32_t)(x)) << AES_STAT_KEY_VALID_SHIFT)) & AES_STAT_KEY_VALID_MASK)
/*! @} */

/*! @name CTR_INCR - Counter Increment */
/*! @{ */
#define AES_CTR_INCR_CTR_INCR_MASK               (0xFFFFFFFFU)
#define AES_CTR_INCR_CTR_INCR_SHIFT              (0U)
/*! CTR_INCR - Increment value for HOLDING register when in counter modes.
 */
#define AES_CTR_INCR_CTR_INCR(x)                 (((uint32_t)(((uint32_t)(x)) << AES_CTR_INCR_CTR_INCR_SHIFT)) & AES_CTR_INCR_CTR_INCR_MASK)
/*! @} */

/*! @name KEY - Bits of the AES key */
/*! @{ */
#define AES_KEY_KEY_MASK                         (0xFFFFFFFFU)
#define AES_KEY_KEY_SHIFT                        (0U)
/*! KEY - Contains the bits of the AES key.
 */
#define AES_KEY_KEY(x)                           (((uint32_t)(((uint32_t)(x)) << AES_KEY_KEY_SHIFT)) & AES_KEY_KEY_MASK)
/*! @} */

/* The count of AES_KEY */
#define AES_KEY_COUNT                            (8U)

/*! @name INTEXT - Input text bits */
/*! @{ */
#define AES_INTEXT_INTEXT_MASK                   (0xFFFFFFFFU)
#define AES_INTEXT_INTEXT_SHIFT                  (0U)
/*! INTEXT - Contains bits of the AES key.
 */
#define AES_INTEXT_INTEXT(x)                     (((uint32_t)(((uint32_t)(x)) << AES_INTEXT_INTEXT_SHIFT)) & AES_INTEXT_INTEXT_MASK)
/*! @} */

/* The count of AES_INTEXT */
#define AES_INTEXT_COUNT                         (4U)

/*! @name HOLDING - Holding register bits */
/*! @{ */
#define AES_HOLDING_HOLDING_MASK                 (0xFFFFFFFFU)
#define AES_HOLDING_HOLDING_SHIFT                (0U)
/*! HOLDING - Contains the first word (bits 31:0) of the 128 bit Holding value.
 */
#define AES_HOLDING_HOLDING(x)                   (((uint32_t)(((uint32_t)(x)) << AES_HOLDING_HOLDING_SHIFT)) & AES_HOLDING_HOLDING_MASK)
/*! @} */

/* The count of AES_HOLDING */
#define AES_HOLDING_COUNT                        (4U)

/*! @name OUTTEXT - Output text bits */
/*! @{ */
#define AES_OUTTEXT_OUTTEXT_MASK                 (0xFFFFFFFFU)
#define AES_OUTTEXT_OUTTEXT_SHIFT                (0U)
/*! OUTTEXT - Contains the bits of the 128 bit Output text data.
 */
#define AES_OUTTEXT_OUTTEXT(x)                   (((uint32_t)(((uint32_t)(x)) << AES_OUTTEXT_OUTTEXT_SHIFT)) & AES_OUTTEXT_OUTTEXT_MASK)
/*! @} */

/* The count of AES_OUTTEXT */
#define AES_OUTTEXT_COUNT                        (4U)

/*! @name GF128_Y - Y bits input of GF128 hash */
/*! @{ */
#define AES_GF128_Y_GF128_Y_MASK                 (0xFFFFFFFFU)
#define AES_GF128_Y_GF128_Y_SHIFT                (0U)
/*! GF128_Y - Contains the bits of the Y input of GF128 hash.
 */
#define AES_GF128_Y_GF128_Y(x)                   (((uint32_t)(((uint32_t)(x)) << AES_GF128_Y_GF128_Y_SHIFT)) & AES_GF128_Y_GF128_Y_MASK)
/*! @} */

/* The count of AES_GF128_Y */
#define AES_GF128_Y_COUNT                        (4U)

/*! @name GF128_Z - Result bits of GF128 hash */
/*! @{ */
#define AES_GF128_Z_GF128_Z_MASK                 (0xFFFFFFFFU)
#define AES_GF128_Z_GF128_Z_SHIFT                (0U)
/*! GF128_Z - Contains bits of the result of GF128 hash.
 */
#define AES_GF128_Z_GF128_Z(x)                   (((uint32_t)(((uint32_t)(x)) << AES_GF128_Z_GF128_Z_SHIFT)) & AES_GF128_Z_GF128_Z_MASK)
/*! @} */

/* The count of AES_GF128_Z */
#define AES_GF128_Z_COUNT                        (4U)

/*! @name GCM_TAG - GCM Tag bits */
/*! @{ */
#define AES_GCM_TAG_GCM_TAG_MASK                 (0xFFFFFFFFU)
#define AES_GCM_TAG_GCM_TAG_SHIFT                (0U)
/*! GCM_TAG - Contains bits of the 128 bit GCM tag.
 */
#define AES_GCM_TAG_GCM_TAG(x)                   (((uint32_t)(((uint32_t)(x)) << AES_GCM_TAG_GCM_TAG_SHIFT)) & AES_GCM_TAG_GCM_TAG_MASK)
/*! @} */

/* The count of AES_GCM_TAG */
#define AES_GCM_TAG_COUNT                        (4U)


/*!
 * @}
 */ /* end of group AES_Register_Masks */


/* AES - Peripheral instance base addresses */
/** Peripheral AES0 base address */
#define AES0_BASE                                (0x400A1000u)
/** Peripheral AES0 base pointer */
#define AES0                                     ((AES_Type *)AES0_BASE)
/** Array initializer of AES peripheral base addresses */
#define AES_BASE_ADDRS                           { AES0_BASE }
/** Array initializer of AES peripheral base pointers */
#define AES_BASE_PTRS                            { AES0 }

/*!
 * @}
 */ /* end of group AES_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ASYNC_SYSCON Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ASYNC_SYSCON_Peripheral_Access_Layer ASYNC_SYSCON Peripheral Access Layer
 * @{
 */

/** ASYNC_SYSCON - Register Layout Typedef */
typedef struct {
  __IO uint32_t ASYNCPRESETCTRL;                   /**< Async peripheral reset control, offset: 0x0 */
  __O  uint32_t ASYNCPRESETCTRLSET;                /**< Set bits in ASYNCPRESETCTRL, offset: 0x4 */
  __O  uint32_t ASYNCPRESETCTRLCLR;                /**< Clear bits in ASYNCPRESETCTRL, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __IO uint32_t ASYNCAPBCLKCTRL;                   /**< Async peripheral clock control, offset: 0x10 */
  __O  uint32_t ASYNCAPBCLKCTRLSET;                /**< Set bits in ASYNCAPBCLKCTRL, offset: 0x14 */
  __O  uint32_t ASYNCAPBCLKCTRLCLR;                /**< Clear bits in ASYNCAPBCLKCTRL, offset: 0x18 */
       uint8_t RESERVED_1[4];
  __IO uint32_t ASYNCAPBCLKSELA;                   /**< Async APB clock source select A, offset: 0x20 */
} ASYNC_SYSCON_Type;

/* ----------------------------------------------------------------------------
   -- ASYNC_SYSCON Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ASYNC_SYSCON_Register_Masks ASYNC_SYSCON Register Masks
 * @{
 */

/*! @name ASYNCPRESETCTRL - Async peripheral reset control */
/*! @{ */
#define ASYNC_SYSCON_ASYNCPRESETCTRL_CTIMER3_MASK (0x2000U)
#define ASYNC_SYSCON_ASYNCPRESETCTRL_CTIMER3_SHIFT (13U)
/*! CTIMER3 - Standard counter/timer CTIMER3 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define ASYNC_SYSCON_ASYNCPRESETCTRL_CTIMER3(x)  (((uint32_t)(((uint32_t)(x)) << ASYNC_SYSCON_ASYNCPRESETCTRL_CTIMER3_SHIFT)) & ASYNC_SYSCON_ASYNCPRESETCTRL_CTIMER3_MASK)
#define ASYNC_SYSCON_ASYNCPRESETCTRL_CTIMER4_MASK (0x4000U)
#define ASYNC_SYSCON_ASYNCPRESETCTRL_CTIMER4_SHIFT (14U)
/*! CTIMER4 - Standard counter/timer CTIMER4 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define ASYNC_SYSCON_ASYNCPRESETCTRL_CTIMER4(x)  (((uint32_t)(((uint32_t)(x)) << ASYNC_SYSCON_ASYNCPRESETCTRL_CTIMER4_SHIFT)) & ASYNC_SYSCON_ASYNCPRESETCTRL_CTIMER4_MASK)
/*! @} */

/*! @name ASYNCPRESETCTRLSET - Set bits in ASYNCPRESETCTRL */
/*! @{ */
#define ASYNC_SYSCON_ASYNCPRESETCTRLSET_ARST_SET_MASK (0xFFFFFFFFU)
#define ASYNC_SYSCON_ASYNCPRESETCTRLSET_ARST_SET_SHIFT (0U)
/*! ARST_SET - Writing ones to this register sets the corresponding bit or bits in the
 *    ASYNCPRESETCTRL register, if they are implemented. Bits that do not correspond to defined bits in
 *    ASYNCPRESETCTRL are reserved and only zeroes should be written to them.
 */
#define ASYNC_SYSCON_ASYNCPRESETCTRLSET_ARST_SET(x) (((uint32_t)(((uint32_t)(x)) << ASYNC_SYSCON_ASYNCPRESETCTRLSET_ARST_SET_SHIFT)) & ASYNC_SYSCON_ASYNCPRESETCTRLSET_ARST_SET_MASK)
/*! @} */

/*! @name ASYNCPRESETCTRLCLR - Clear bits in ASYNCPRESETCTRL */
/*! @{ */
#define ASYNC_SYSCON_ASYNCPRESETCTRLCLR_ARST_CLR_MASK (0xFFFFFFFFU)
#define ASYNC_SYSCON_ASYNCPRESETCTRLCLR_ARST_CLR_SHIFT (0U)
/*! ARST_CLR - Writing ones to this register clears the corresponding bit or bits in the
 *    ASYNCPRESETCTRL register, if they are implemented. Bits that do not correspond to defined bits in
 *    ASYNCPRESETCTRL are reserved and only zeroes should be written to them.
 */
#define ASYNC_SYSCON_ASYNCPRESETCTRLCLR_ARST_CLR(x) (((uint32_t)(((uint32_t)(x)) << ASYNC_SYSCON_ASYNCPRESETCTRLCLR_ARST_CLR_SHIFT)) & ASYNC_SYSCON_ASYNCPRESETCTRLCLR_ARST_CLR_MASK)
/*! @} */

/*! @name ASYNCAPBCLKCTRL - Async peripheral clock control */
/*! @{ */
#define ASYNC_SYSCON_ASYNCAPBCLKCTRL_CTIMER3_MASK (0x2000U)
#define ASYNC_SYSCON_ASYNCAPBCLKCTRL_CTIMER3_SHIFT (13U)
/*! CTIMER3 - Controls the clock for CTIMER3. 0 = Disable; 1 = Enable.
 */
#define ASYNC_SYSCON_ASYNCAPBCLKCTRL_CTIMER3(x)  (((uint32_t)(((uint32_t)(x)) << ASYNC_SYSCON_ASYNCAPBCLKCTRL_CTIMER3_SHIFT)) & ASYNC_SYSCON_ASYNCAPBCLKCTRL_CTIMER3_MASK)
#define ASYNC_SYSCON_ASYNCAPBCLKCTRL_CTIMER4_MASK (0x4000U)
#define ASYNC_SYSCON_ASYNCAPBCLKCTRL_CTIMER4_SHIFT (14U)
/*! CTIMER4 - Controls the clock for CTIMER4. 0 = Disable; 1 = Enable.
 */
#define ASYNC_SYSCON_ASYNCAPBCLKCTRL_CTIMER4(x)  (((uint32_t)(((uint32_t)(x)) << ASYNC_SYSCON_ASYNCAPBCLKCTRL_CTIMER4_SHIFT)) & ASYNC_SYSCON_ASYNCAPBCLKCTRL_CTIMER4_MASK)
/*! @} */

/*! @name ASYNCAPBCLKCTRLSET - Set bits in ASYNCAPBCLKCTRL */
/*! @{ */
#define ASYNC_SYSCON_ASYNCAPBCLKCTRLSET_ACLK_SET_MASK (0xFFFFFFFFU)
#define ASYNC_SYSCON_ASYNCAPBCLKCTRLSET_ACLK_SET_SHIFT (0U)
/*! ACLK_SET - Writing ones to this register sets the corresponding bit or bits in the
 *    ASYNCAPBCLKCTRL register, if they are implemented. Bits that do not correspond to defined bits in
 *    ASYNCPRESETCTRL are reserved and only zeroes should be written to them.
 */
#define ASYNC_SYSCON_ASYNCAPBCLKCTRLSET_ACLK_SET(x) (((uint32_t)(((uint32_t)(x)) << ASYNC_SYSCON_ASYNCAPBCLKCTRLSET_ACLK_SET_SHIFT)) & ASYNC_SYSCON_ASYNCAPBCLKCTRLSET_ACLK_SET_MASK)
/*! @} */

/*! @name ASYNCAPBCLKCTRLCLR - Clear bits in ASYNCAPBCLKCTRL */
/*! @{ */
#define ASYNC_SYSCON_ASYNCAPBCLKCTRLCLR_ACLK_CLR_MASK (0xFFFFFFFFU)
#define ASYNC_SYSCON_ASYNCAPBCLKCTRLCLR_ACLK_CLR_SHIFT (0U)
/*! ACLK_CLR - Writing ones to this register clears the corresponding bit or bits in the
 *    ASYNCAPBCLKCTRL register, if they are implemented. Bits that do not correspond to defined bits in
 *    ASYNCAPBCLKCTRL are reserved and only zeroes should be written to them.
 */
#define ASYNC_SYSCON_ASYNCAPBCLKCTRLCLR_ACLK_CLR(x) (((uint32_t)(((uint32_t)(x)) << ASYNC_SYSCON_ASYNCAPBCLKCTRLCLR_ACLK_CLR_SHIFT)) & ASYNC_SYSCON_ASYNCAPBCLKCTRLCLR_ACLK_CLR_MASK)
/*! @} */

/*! @name ASYNCAPBCLKSELA - Async APB clock source select A */
/*! @{ */
#define ASYNC_SYSCON_ASYNCAPBCLKSELA_SEL_MASK    (0x3U)
#define ASYNC_SYSCON_ASYNCAPBCLKSELA_SEL_SHIFT   (0U)
/*! SEL - Clock source for asynchronous clock source selector A
 *  0b00..Main clock (main_clk)
 *  0b01..FRO 12 MHz (fro_12m)
 *  0b10..Audio PLL clock.(AUDPLL_BYPASS)
 *  0b11..fc6 fclk (fc6_fclk)
 */
#define ASYNC_SYSCON_ASYNCAPBCLKSELA_SEL(x)      (((uint32_t)(((uint32_t)(x)) << ASYNC_SYSCON_ASYNCAPBCLKSELA_SEL_SHIFT)) & ASYNC_SYSCON_ASYNCAPBCLKSELA_SEL_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ASYNC_SYSCON_Register_Masks */


/* ASYNC_SYSCON - Peripheral instance base addresses */
/** Peripheral ASYNC_SYSCON base address */
#define ASYNC_SYSCON_BASE                        (0x40040000u)
/** Peripheral ASYNC_SYSCON base pointer */
#define ASYNC_SYSCON                             ((ASYNC_SYSCON_Type *)ASYNC_SYSCON_BASE)
/** Array initializer of ASYNC_SYSCON peripheral base addresses */
#define ASYNC_SYSCON_BASE_ADDRS                  { ASYNC_SYSCON_BASE }
/** Array initializer of ASYNC_SYSCON peripheral base pointers */
#define ASYNC_SYSCON_BASE_PTRS                   { ASYNC_SYSCON }

/*!
 * @}
 */ /* end of group ASYNC_SYSCON_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CAN Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Peripheral_Access_Layer CAN Peripheral Access Layer
 * @{
 */

/** CAN - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[12];
  __IO uint32_t DBTP;                              /**< Data Bit Timing Prescaler Register, offset: 0xC */
  __IO uint32_t TEST;                              /**< Test Register, offset: 0x10 */
       uint8_t RESERVED_1[4];
  __IO uint32_t CCCR;                              /**< CC Control Register, offset: 0x18 */
  __IO uint32_t NBTP;                              /**< Nominal Bit Timing and Prescaler Register, offset: 0x1C */
  __IO uint32_t TSCC;                              /**< Timestamp Counter Configuration, offset: 0x20 */
  __I  uint32_t TSCV;                              /**< Timestamp Counter Value, offset: 0x24 */
  __IO uint32_t TOCC;                              /**< Timeout Counter Configuration, offset: 0x28 */
  __I  uint32_t TOCV;                              /**< Timeout Counter Value, offset: 0x2C */
       uint8_t RESERVED_2[16];
  __I  uint32_t ECR;                               /**< Error Counter Register, offset: 0x40 */
  __I  uint32_t PSR;                               /**< Protocol Status Register, offset: 0x44 */
  __IO uint32_t TDCR;                              /**< Transmitter Delay Compensator Register, offset: 0x48 */
       uint8_t RESERVED_3[4];
  __IO uint32_t IR;                                /**< Interrupt Register, offset: 0x50 */
  __IO uint32_t IE;                                /**< Interrupt Enable, offset: 0x54 */
  __IO uint32_t ILS;                               /**< Interrupt Line Select, offset: 0x58 */
  __IO uint32_t ILE;                               /**< Interrupt Line Enable, offset: 0x5C */
       uint8_t RESERVED_4[32];
  __IO uint32_t GFC;                               /**< Global Filter Configuration, offset: 0x80 */
  __IO uint32_t SIDFC;                             /**< Standard ID Filter Configuration, offset: 0x84 */
  __IO uint32_t XIDFC;                             /**< Extended ID Filter Configuration, offset: 0x88 */
       uint8_t RESERVED_5[4];
  __IO uint32_t XIDAM;                             /**< Extended ID AND Mask, offset: 0x90 */
  __I  uint32_t HPMS;                              /**< High Priority Message Status, offset: 0x94 */
  __IO uint32_t NDAT1;                             /**< New Data 1, offset: 0x98 */
  __IO uint32_t NDAT2;                             /**< New Data 2, offset: 0x9C */
  __IO uint32_t RXF0C;                             /**< Rx FIFO 0 Configuration, offset: 0xA0 */
  __I  uint32_t RXF0S;                             /**< Rx FIFO 0 Status, offset: 0xA4 */
  __IO uint32_t RXF0A;                             /**< Rx FIFO 0 Acknowledge, offset: 0xA8 */
  __IO uint32_t RXBC;                              /**< Rx Buffer Configuration, offset: 0xAC */
  __IO uint32_t RXF1C;                             /**< Rx FIFO 1 Configuration, offset: 0xB0 */
  __I  uint32_t RXF1S;                             /**< Rx FIFO 1 Status, offset: 0xB4 */
  __IO uint32_t RXF1A;                             /**< Rx FIFO 1 Acknowledge, offset: 0xB8 */
  __IO uint32_t RXESC;                             /**< Rx Buffer and FIFO Element Size Configuration, offset: 0xBC */
  __IO uint32_t TXBC;                              /**< Tx Buffer Configuration, offset: 0xC0 */
  __IO uint32_t TXFQS;                             /**< Tx FIFO/Queue Status, offset: 0xC4 */
  __IO uint32_t TXESC;                             /**< Tx Buffer Element Size Configuration, offset: 0xC8 */
  __I  uint32_t TXBRP;                             /**< Tx Buffer Request Pending, offset: 0xCC */
  __IO uint32_t TXBAR;                             /**< Tx Buffer Add Request, offset: 0xD0 */
  __IO uint32_t TXBCR;                             /**< Tx Buffer Cancellation Request, offset: 0xD4 */
  __I  uint32_t TXBTO;                             /**< Tx Buffer Transmission Occurred, offset: 0xD8 */
  __I  uint32_t TXBCF;                             /**< Tx Buffer Cancellation Finished, offset: 0xDC */
  __IO uint32_t TXBTIE;                            /**< Tx Buffer Transmission Interrupt Enable, offset: 0xE0 */
  __IO uint32_t TXBCIE;                            /**< Tx Buffer Cancellation Finished Interrupt Enable, offset: 0xE4 */
       uint8_t RESERVED_6[8];
  __IO uint32_t TXEFC;                             /**< Tx Event FIFO Configuration, offset: 0xF0 */
  __I  uint32_t TXEFS;                             /**< Tx Event FIFO Status, offset: 0xF4 */
  __IO uint32_t TXEFA;                             /**< Tx Event FIFO Acknowledge, offset: 0xF8 */
       uint8_t RESERVED_7[260];
  __IO uint32_t MRBA;                              /**< CAN Message RAM Base Address, offset: 0x200 */
       uint8_t RESERVED_8[508];
  __IO uint32_t ETSCC;                             /**< External Timestamp Counter Configuration, offset: 0x400 */
       uint8_t RESERVED_9[508];
  __IO uint32_t ETSCV;                             /**< External Timestamp Counter Value, offset: 0x600 */
} CAN_Type;

/* ----------------------------------------------------------------------------
   -- CAN Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Masks CAN Register Masks
 * @{
 */

/*! @name DBTP - Data Bit Timing Prescaler Register */
/*! @{ */
#define CAN_DBTP_DSJW_MASK                       (0xFU)
#define CAN_DBTP_DSJW_SHIFT                      (0U)
/*! DSJW - Data (re)synchronization jump width.
 */
#define CAN_DBTP_DSJW(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_DBTP_DSJW_SHIFT)) & CAN_DBTP_DSJW_MASK)
#define CAN_DBTP_DTSEG2_MASK                     (0xF0U)
#define CAN_DBTP_DTSEG2_SHIFT                    (4U)
/*! DTSEG2 - Data time segment after sample point.
 */
#define CAN_DBTP_DTSEG2(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_DBTP_DTSEG2_SHIFT)) & CAN_DBTP_DTSEG2_MASK)
#define CAN_DBTP_DTSEG1_MASK                     (0x1F00U)
#define CAN_DBTP_DTSEG1_SHIFT                    (8U)
/*! DTSEG1 - Data time segment before sample point.
 */
#define CAN_DBTP_DTSEG1(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_DBTP_DTSEG1_SHIFT)) & CAN_DBTP_DTSEG1_MASK)
#define CAN_DBTP_DBRP_MASK                       (0x1F0000U)
#define CAN_DBTP_DBRP_SHIFT                      (16U)
/*! DBRP - Data bit rate prescaler.
 */
#define CAN_DBTP_DBRP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_DBTP_DBRP_SHIFT)) & CAN_DBTP_DBRP_MASK)
#define CAN_DBTP_TDC_MASK                        (0x800000U)
#define CAN_DBTP_TDC_SHIFT                       (23U)
/*! TDC - Transmitter delay compensation.
 */
#define CAN_DBTP_TDC(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_DBTP_TDC_SHIFT)) & CAN_DBTP_TDC_MASK)
/*! @} */

/*! @name TEST - Test Register */
/*! @{ */
#define CAN_TEST_LBCK_MASK                       (0x10U)
#define CAN_TEST_LBCK_SHIFT                      (4U)
/*! LBCK - Loop back mode.
 */
#define CAN_TEST_LBCK(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TEST_LBCK_SHIFT)) & CAN_TEST_LBCK_MASK)
#define CAN_TEST_TX_MASK                         (0x60U)
#define CAN_TEST_TX_SHIFT                        (5U)
/*! TX - Control of transmit pin.
 */
#define CAN_TEST_TX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_TEST_TX_SHIFT)) & CAN_TEST_TX_MASK)
#define CAN_TEST_RX_MASK                         (0x80U)
#define CAN_TEST_RX_SHIFT                        (7U)
/*! RX - Monitors the actual value of the CAN_RXD.
 */
#define CAN_TEST_RX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_TEST_RX_SHIFT)) & CAN_TEST_RX_MASK)
/*! @} */

/*! @name CCCR - CC Control Register */
/*! @{ */
#define CAN_CCCR_INIT_MASK                       (0x1U)
#define CAN_CCCR_INIT_SHIFT                      (0U)
/*! INIT - Initialization.
 */
#define CAN_CCCR_INIT(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_INIT_SHIFT)) & CAN_CCCR_INIT_MASK)
#define CAN_CCCR_CCE_MASK                        (0x2U)
#define CAN_CCCR_CCE_SHIFT                       (1U)
/*! CCE - Configuration change enable.
 */
#define CAN_CCCR_CCE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_CCE_SHIFT)) & CAN_CCCR_CCE_MASK)
#define CAN_CCCR_ASM_MASK                        (0x4U)
#define CAN_CCCR_ASM_SHIFT                       (2U)
/*! ASM - Restricted operational mode.
 */
#define CAN_CCCR_ASM(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_ASM_SHIFT)) & CAN_CCCR_ASM_MASK)
#define CAN_CCCR_CSA_MASK                        (0x8U)
#define CAN_CCCR_CSA_SHIFT                       (3U)
/*! CSA - Clock Stop Acknowledge.
 */
#define CAN_CCCR_CSA(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_CSA_SHIFT)) & CAN_CCCR_CSA_MASK)
#define CAN_CCCR_CSR_MASK                        (0x10U)
#define CAN_CCCR_CSR_SHIFT                       (4U)
/*! CSR - Clock Stop Request.
 */
#define CAN_CCCR_CSR(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_CSR_SHIFT)) & CAN_CCCR_CSR_MASK)
#define CAN_CCCR_MON_MASK                        (0x20U)
#define CAN_CCCR_MON_SHIFT                       (5U)
/*! MON - Bus monitoring mode.
 */
#define CAN_CCCR_MON(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_MON_SHIFT)) & CAN_CCCR_MON_MASK)
#define CAN_CCCR_DAR_MASK                        (0x40U)
#define CAN_CCCR_DAR_SHIFT                       (6U)
/*! DAR - Disable automatic retransmission.
 */
#define CAN_CCCR_DAR(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_DAR_SHIFT)) & CAN_CCCR_DAR_MASK)
#define CAN_CCCR_TEST_MASK                       (0x80U)
#define CAN_CCCR_TEST_SHIFT                      (7U)
/*! TEST - Test mode enable.
 */
#define CAN_CCCR_TEST(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_TEST_SHIFT)) & CAN_CCCR_TEST_MASK)
#define CAN_CCCR_FDOE_MASK                       (0x100U)
#define CAN_CCCR_FDOE_SHIFT                      (8U)
/*! FDOE - CAN FD operation enable.
 */
#define CAN_CCCR_FDOE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_FDOE_SHIFT)) & CAN_CCCR_FDOE_MASK)
#define CAN_CCCR_BRSE_MASK                       (0x200U)
#define CAN_CCCR_BRSE_SHIFT                      (9U)
/*! BRSE - When CAN FD operation is disabled, this bit is not evaluated.
 */
#define CAN_CCCR_BRSE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_BRSE_SHIFT)) & CAN_CCCR_BRSE_MASK)
#define CAN_CCCR_PXHD_MASK                       (0x1000U)
#define CAN_CCCR_PXHD_SHIFT                      (12U)
/*! PXHD - Protocol exception handling disable.
 */
#define CAN_CCCR_PXHD(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_PXHD_SHIFT)) & CAN_CCCR_PXHD_MASK)
#define CAN_CCCR_EFBI_MASK                       (0x2000U)
#define CAN_CCCR_EFBI_SHIFT                      (13U)
/*! EFBI - Edge filtering during bus integration.
 */
#define CAN_CCCR_EFBI(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_EFBI_SHIFT)) & CAN_CCCR_EFBI_MASK)
#define CAN_CCCR_TXP_MASK                        (0x4000U)
#define CAN_CCCR_TXP_SHIFT                       (14U)
/*! TXP - Transmit pause.
 */
#define CAN_CCCR_TXP(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_TXP_SHIFT)) & CAN_CCCR_TXP_MASK)
#define CAN_CCCR_NISO_MASK                       (0x8000U)
#define CAN_CCCR_NISO_SHIFT                      (15U)
/*! NISO - Non ISO operation.
 */
#define CAN_CCCR_NISO(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_NISO_SHIFT)) & CAN_CCCR_NISO_MASK)
/*! @} */

/*! @name NBTP - Nominal Bit Timing and Prescaler Register */
/*! @{ */
#define CAN_NBTP_NTSEG2_MASK                     (0x7FU)
#define CAN_NBTP_NTSEG2_SHIFT                    (0U)
/*! NTSEG2 - Nominal time segment after sample point.
 */
#define CAN_NBTP_NTSEG2(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_NBTP_NTSEG2_SHIFT)) & CAN_NBTP_NTSEG2_MASK)
#define CAN_NBTP_NTSEG1_MASK                     (0xFF00U)
#define CAN_NBTP_NTSEG1_SHIFT                    (8U)
/*! NTSEG1 - Nominal time segment before sample point.
 */
#define CAN_NBTP_NTSEG1(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_NBTP_NTSEG1_SHIFT)) & CAN_NBTP_NTSEG1_MASK)
#define CAN_NBTP_NBRP_MASK                       (0x1FF0000U)
#define CAN_NBTP_NBRP_SHIFT                      (16U)
/*! NBRP - Nominal bit rate prescaler.
 */
#define CAN_NBTP_NBRP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_NBTP_NBRP_SHIFT)) & CAN_NBTP_NBRP_MASK)
#define CAN_NBTP_NSJW_MASK                       (0xFE000000U)
#define CAN_NBTP_NSJW_SHIFT                      (25U)
/*! NSJW - Nominal (re)synchronization jump width.
 */
#define CAN_NBTP_NSJW(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_NBTP_NSJW_SHIFT)) & CAN_NBTP_NSJW_MASK)
/*! @} */

/*! @name TSCC - Timestamp Counter Configuration */
/*! @{ */
#define CAN_TSCC_TSS_MASK                        (0x3U)
#define CAN_TSCC_TSS_SHIFT                       (0U)
/*! TSS - Timestamp select.
 */
#define CAN_TSCC_TSS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TSCC_TSS_SHIFT)) & CAN_TSCC_TSS_MASK)
#define CAN_TSCC_TCP_MASK                        (0xF0000U)
#define CAN_TSCC_TCP_SHIFT                       (16U)
/*! TCP - Timestamp counter prescaler Configures the timestamp and timeout counters time unit in multiple of CAN bit times.
 */
#define CAN_TSCC_TCP(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TSCC_TCP_SHIFT)) & CAN_TSCC_TCP_MASK)
/*! @} */

/*! @name TSCV - Timestamp Counter Value */
/*! @{ */
#define CAN_TSCV_TSC_MASK                        (0xFFFFU)
#define CAN_TSCV_TSC_SHIFT                       (0U)
/*! TSC - Timestamp counter.
 */
#define CAN_TSCV_TSC(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TSCV_TSC_SHIFT)) & CAN_TSCV_TSC_MASK)
/*! @} */

/*! @name TOCC - Timeout Counter Configuration */
/*! @{ */
#define CAN_TOCC_ETOC_MASK                       (0x1U)
#define CAN_TOCC_ETOC_SHIFT                      (0U)
/*! ETOC - Enable timeout counter.
 */
#define CAN_TOCC_ETOC(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TOCC_ETOC_SHIFT)) & CAN_TOCC_ETOC_MASK)
#define CAN_TOCC_TOS_MASK                        (0x6U)
#define CAN_TOCC_TOS_SHIFT                       (1U)
/*! TOS - Timeout select.
 */
#define CAN_TOCC_TOS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TOCC_TOS_SHIFT)) & CAN_TOCC_TOS_MASK)
#define CAN_TOCC_TOP_MASK                        (0xFFFF0000U)
#define CAN_TOCC_TOP_SHIFT                       (16U)
/*! TOP - Timeout period.
 */
#define CAN_TOCC_TOP(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TOCC_TOP_SHIFT)) & CAN_TOCC_TOP_MASK)
/*! @} */

/*! @name TOCV - Timeout Counter Value */
/*! @{ */
#define CAN_TOCV_TOC_MASK                        (0xFFFFU)
#define CAN_TOCV_TOC_SHIFT                       (0U)
/*! TOC - Timeout counter.
 */
#define CAN_TOCV_TOC(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TOCV_TOC_SHIFT)) & CAN_TOCV_TOC_MASK)
/*! @} */

/*! @name ECR - Error Counter Register */
/*! @{ */
#define CAN_ECR_TEC_MASK                         (0xFFU)
#define CAN_ECR_TEC_SHIFT                        (0U)
/*! TEC - Transmit error counter.
 */
#define CAN_ECR_TEC(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TEC_SHIFT)) & CAN_ECR_TEC_MASK)
#define CAN_ECR_REC_MASK                         (0x7F00U)
#define CAN_ECR_REC_SHIFT                        (8U)
/*! REC - Receive error counter.
 */
#define CAN_ECR_REC(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ECR_REC_SHIFT)) & CAN_ECR_REC_MASK)
#define CAN_ECR_RP_MASK                          (0x8000U)
#define CAN_ECR_RP_SHIFT                         (15U)
/*! RP - Receive error passive.
 */
#define CAN_ECR_RP(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RP_SHIFT)) & CAN_ECR_RP_MASK)
#define CAN_ECR_CEL_MASK                         (0xFF0000U)
#define CAN_ECR_CEL_SHIFT                        (16U)
/*! CEL - CAN error logging.
 */
#define CAN_ECR_CEL(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ECR_CEL_SHIFT)) & CAN_ECR_CEL_MASK)
/*! @} */

/*! @name PSR - Protocol Status Register */
/*! @{ */
#define CAN_PSR_LEC_MASK                         (0x7U)
#define CAN_PSR_LEC_SHIFT                        (0U)
/*! LEC - Last error code.
 */
#define CAN_PSR_LEC(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_PSR_LEC_SHIFT)) & CAN_PSR_LEC_MASK)
#define CAN_PSR_ACT_MASK                         (0x18U)
#define CAN_PSR_ACT_SHIFT                        (3U)
/*! ACT - Activity.
 */
#define CAN_PSR_ACT(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_PSR_ACT_SHIFT)) & CAN_PSR_ACT_MASK)
#define CAN_PSR_EP_MASK                          (0x20U)
#define CAN_PSR_EP_SHIFT                         (5U)
/*! EP - Error Passive.
 */
#define CAN_PSR_EP(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_PSR_EP_SHIFT)) & CAN_PSR_EP_MASK)
#define CAN_PSR_EW_MASK                          (0x40U)
#define CAN_PSR_EW_SHIFT                         (6U)
/*! EW - Warning status.
 */
#define CAN_PSR_EW(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_PSR_EW_SHIFT)) & CAN_PSR_EW_MASK)
#define CAN_PSR_BO_MASK                          (0x80U)
#define CAN_PSR_BO_SHIFT                         (7U)
/*! BO - Bus Off Status.
 */
#define CAN_PSR_BO(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_PSR_BO_SHIFT)) & CAN_PSR_BO_MASK)
#define CAN_PSR_DLEC_MASK                        (0x700U)
#define CAN_PSR_DLEC_SHIFT                       (8U)
/*! DLEC - Data phase last error code.
 */
#define CAN_PSR_DLEC(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_PSR_DLEC_SHIFT)) & CAN_PSR_DLEC_MASK)
#define CAN_PSR_RESI_MASK                        (0x800U)
#define CAN_PSR_RESI_SHIFT                       (11U)
/*! RESI - ESI flag of the last received CAN FD message.
 */
#define CAN_PSR_RESI(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_PSR_RESI_SHIFT)) & CAN_PSR_RESI_MASK)
#define CAN_PSR_RBRS_MASK                        (0x1000U)
#define CAN_PSR_RBRS_SHIFT                       (12U)
/*! RBRS - BRS flag of last received CAN FD message.
 */
#define CAN_PSR_RBRS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_PSR_RBRS_SHIFT)) & CAN_PSR_RBRS_MASK)
#define CAN_PSR_RFDF_MASK                        (0x2000U)
#define CAN_PSR_RFDF_SHIFT                       (13U)
/*! RFDF - Received a CAN FD message.
 */
#define CAN_PSR_RFDF(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_PSR_RFDF_SHIFT)) & CAN_PSR_RFDF_MASK)
#define CAN_PSR_PXE_MASK                         (0x4000U)
#define CAN_PSR_PXE_SHIFT                        (14U)
/*! PXE - Protocol exception event.
 */
#define CAN_PSR_PXE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_PSR_PXE_SHIFT)) & CAN_PSR_PXE_MASK)
#define CAN_PSR_TDCV_MASK                        (0x7F0000U)
#define CAN_PSR_TDCV_SHIFT                       (16U)
/*! TDCV - Transmitter delay compensation value.
 */
#define CAN_PSR_TDCV(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_PSR_TDCV_SHIFT)) & CAN_PSR_TDCV_MASK)
/*! @} */

/*! @name TDCR - Transmitter Delay Compensator Register */
/*! @{ */
#define CAN_TDCR_TDCF_MASK                       (0x7FU)
#define CAN_TDCR_TDCF_SHIFT                      (0U)
/*! TDCF - Transmitter delay compensation filter window length.
 */
#define CAN_TDCR_TDCF(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TDCR_TDCF_SHIFT)) & CAN_TDCR_TDCF_MASK)
#define CAN_TDCR_TDCO_MASK                       (0x7F00U)
#define CAN_TDCR_TDCO_SHIFT                      (8U)
/*! TDCO - Transmitter delay compensation offset.
 */
#define CAN_TDCR_TDCO(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TDCR_TDCO_SHIFT)) & CAN_TDCR_TDCO_MASK)
/*! @} */

/*! @name IR - Interrupt Register */
/*! @{ */
#define CAN_IR_RF0N_MASK                         (0x1U)
#define CAN_IR_RF0N_SHIFT                        (0U)
/*! RF0N - Rx FIFO 0 new message.
 */
#define CAN_IR_RF0N(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF0N_SHIFT)) & CAN_IR_RF0N_MASK)
#define CAN_IR_RF0W_MASK                         (0x2U)
#define CAN_IR_RF0W_SHIFT                        (1U)
/*! RF0W - Rx FIFO 0 watermark reached.
 */
#define CAN_IR_RF0W(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF0W_SHIFT)) & CAN_IR_RF0W_MASK)
#define CAN_IR_RF0F_MASK                         (0x4U)
#define CAN_IR_RF0F_SHIFT                        (2U)
/*! RF0F - Rx FIFO 0 full.
 */
#define CAN_IR_RF0F(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF0F_SHIFT)) & CAN_IR_RF0F_MASK)
#define CAN_IR_RF0L_MASK                         (0x8U)
#define CAN_IR_RF0L_SHIFT                        (3U)
/*! RF0L - Rx FIFO 0 message lost.
 */
#define CAN_IR_RF0L(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF0L_SHIFT)) & CAN_IR_RF0L_MASK)
#define CAN_IR_RF1N_MASK                         (0x10U)
#define CAN_IR_RF1N_SHIFT                        (4U)
/*! RF1N - Rx FIFO 1 new message.
 */
#define CAN_IR_RF1N(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF1N_SHIFT)) & CAN_IR_RF1N_MASK)
#define CAN_IR_RF1W_MASK                         (0x20U)
#define CAN_IR_RF1W_SHIFT                        (5U)
/*! RF1W - Rx FIFO 1 watermark reached.
 */
#define CAN_IR_RF1W(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF1W_SHIFT)) & CAN_IR_RF1W_MASK)
#define CAN_IR_RF1F_MASK                         (0x40U)
#define CAN_IR_RF1F_SHIFT                        (6U)
/*! RF1F - Rx FIFO 1 full.
 */
#define CAN_IR_RF1F(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF1F_SHIFT)) & CAN_IR_RF1F_MASK)
#define CAN_IR_RF1L_MASK                         (0x80U)
#define CAN_IR_RF1L_SHIFT                        (7U)
/*! RF1L - Rx FIFO 1 message lost.
 */
#define CAN_IR_RF1L(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF1L_SHIFT)) & CAN_IR_RF1L_MASK)
#define CAN_IR_HPM_MASK                          (0x100U)
#define CAN_IR_HPM_SHIFT                         (8U)
/*! HPM - High priority message.
 */
#define CAN_IR_HPM(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_HPM_SHIFT)) & CAN_IR_HPM_MASK)
#define CAN_IR_TC_MASK                           (0x200U)
#define CAN_IR_TC_SHIFT                          (9U)
/*! TC - Transmission completed.
 */
#define CAN_IR_TC(x)                             (((uint32_t)(((uint32_t)(x)) << CAN_IR_TC_SHIFT)) & CAN_IR_TC_MASK)
#define CAN_IR_TCF_MASK                          (0x400U)
#define CAN_IR_TCF_SHIFT                         (10U)
/*! TCF - Transmission cancellation finished.
 */
#define CAN_IR_TCF(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_TCF_SHIFT)) & CAN_IR_TCF_MASK)
#define CAN_IR_TFE_MASK                          (0x800U)
#define CAN_IR_TFE_SHIFT                         (11U)
/*! TFE - Tx FIFO empty.
 */
#define CAN_IR_TFE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_TFE_SHIFT)) & CAN_IR_TFE_MASK)
#define CAN_IR_TEFN_MASK                         (0x1000U)
#define CAN_IR_TEFN_SHIFT                        (12U)
/*! TEFN - Tx event FIFO new entry.
 */
#define CAN_IR_TEFN(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_TEFN_SHIFT)) & CAN_IR_TEFN_MASK)
#define CAN_IR_TEFW_MASK                         (0x2000U)
#define CAN_IR_TEFW_SHIFT                        (13U)
/*! TEFW - Tx event FIFO watermark reached.
 */
#define CAN_IR_TEFW(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_TEFW_SHIFT)) & CAN_IR_TEFW_MASK)
#define CAN_IR_TEFF_MASK                         (0x4000U)
#define CAN_IR_TEFF_SHIFT                        (14U)
/*! TEFF - Tx event FIFO full.
 */
#define CAN_IR_TEFF(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_TEFF_SHIFT)) & CAN_IR_TEFF_MASK)
#define CAN_IR_TEFL_MASK                         (0x8000U)
#define CAN_IR_TEFL_SHIFT                        (15U)
/*! TEFL - Tx event FIFO element lost.
 */
#define CAN_IR_TEFL(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_TEFL_SHIFT)) & CAN_IR_TEFL_MASK)
#define CAN_IR_TSW_MASK                          (0x10000U)
#define CAN_IR_TSW_SHIFT                         (16U)
/*! TSW - Timestamp wraparound.
 */
#define CAN_IR_TSW(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_TSW_SHIFT)) & CAN_IR_TSW_MASK)
#define CAN_IR_MRAF_MASK                         (0x20000U)
#define CAN_IR_MRAF_SHIFT                        (17U)
/*! MRAF - Message RAM access failure.
 */
#define CAN_IR_MRAF(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_MRAF_SHIFT)) & CAN_IR_MRAF_MASK)
#define CAN_IR_TOO_MASK                          (0x40000U)
#define CAN_IR_TOO_SHIFT                         (18U)
/*! TOO - Timeout occurred.
 */
#define CAN_IR_TOO(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_TOO_SHIFT)) & CAN_IR_TOO_MASK)
#define CAN_IR_DRX_MASK                          (0x80000U)
#define CAN_IR_DRX_SHIFT                         (19U)
/*! DRX - Message stored in dedicated Rx buffer.
 */
#define CAN_IR_DRX(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_DRX_SHIFT)) & CAN_IR_DRX_MASK)
#define CAN_IR_BEC_MASK                          (0x100000U)
#define CAN_IR_BEC_SHIFT                         (20U)
/*! BEC - Bit error corrected.
 */
#define CAN_IR_BEC(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_BEC_SHIFT)) & CAN_IR_BEC_MASK)
#define CAN_IR_BEU_MASK                          (0x200000U)
#define CAN_IR_BEU_SHIFT                         (21U)
/*! BEU - Bit error uncorrected.
 */
#define CAN_IR_BEU(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_BEU_SHIFT)) & CAN_IR_BEU_MASK)
#define CAN_IR_ELO_MASK                          (0x400000U)
#define CAN_IR_ELO_SHIFT                         (22U)
/*! ELO - Error logging overflow.
 */
#define CAN_IR_ELO(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_ELO_SHIFT)) & CAN_IR_ELO_MASK)
#define CAN_IR_EP_MASK                           (0x800000U)
#define CAN_IR_EP_SHIFT                          (23U)
/*! EP - Error passive.
 */
#define CAN_IR_EP(x)                             (((uint32_t)(((uint32_t)(x)) << CAN_IR_EP_SHIFT)) & CAN_IR_EP_MASK)
#define CAN_IR_EW_MASK                           (0x1000000U)
#define CAN_IR_EW_SHIFT                          (24U)
/*! EW - Warning status.
 */
#define CAN_IR_EW(x)                             (((uint32_t)(((uint32_t)(x)) << CAN_IR_EW_SHIFT)) & CAN_IR_EW_MASK)
#define CAN_IR_BO_MASK                           (0x2000000U)
#define CAN_IR_BO_SHIFT                          (25U)
/*! BO - Bus_Off Status.
 */
#define CAN_IR_BO(x)                             (((uint32_t)(((uint32_t)(x)) << CAN_IR_BO_SHIFT)) & CAN_IR_BO_MASK)
#define CAN_IR_WDI_MASK                          (0x4000000U)
#define CAN_IR_WDI_SHIFT                         (26U)
/*! WDI - Watchdog interrupt.
 */
#define CAN_IR_WDI(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_WDI_SHIFT)) & CAN_IR_WDI_MASK)
#define CAN_IR_PEA_MASK                          (0x8000000U)
#define CAN_IR_PEA_SHIFT                         (27U)
/*! PEA - Protocol error in arbitration phase.
 */
#define CAN_IR_PEA(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_PEA_SHIFT)) & CAN_IR_PEA_MASK)
#define CAN_IR_PED_MASK                          (0x10000000U)
#define CAN_IR_PED_SHIFT                         (28U)
/*! PED - Protocol error in data phase.
 */
#define CAN_IR_PED(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_PED_SHIFT)) & CAN_IR_PED_MASK)
#define CAN_IR_ARA_MASK                          (0x20000000U)
#define CAN_IR_ARA_SHIFT                         (29U)
/*! ARA - Access to reserved address.
 */
#define CAN_IR_ARA(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_ARA_SHIFT)) & CAN_IR_ARA_MASK)
/*! @} */

/*! @name IE - Interrupt Enable */
/*! @{ */
#define CAN_IE_RF0NE_MASK                        (0x1U)
#define CAN_IE_RF0NE_SHIFT                       (0U)
/*! RF0NE - Rx FIFO 0 new message interrupt enable.
 */
#define CAN_IE_RF0NE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF0NE_SHIFT)) & CAN_IE_RF0NE_MASK)
#define CAN_IE_RF0WE_MASK                        (0x2U)
#define CAN_IE_RF0WE_SHIFT                       (1U)
/*! RF0WE - Rx FIFO 0 watermark reached interrupt enable.
 */
#define CAN_IE_RF0WE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF0WE_SHIFT)) & CAN_IE_RF0WE_MASK)
#define CAN_IE_RF0FE_MASK                        (0x4U)
#define CAN_IE_RF0FE_SHIFT                       (2U)
/*! RF0FE - Rx FIFO 0 full interrupt enable.
 */
#define CAN_IE_RF0FE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF0FE_SHIFT)) & CAN_IE_RF0FE_MASK)
#define CAN_IE_RF0LE_MASK                        (0x8U)
#define CAN_IE_RF0LE_SHIFT                       (3U)
/*! RF0LE - Rx FIFO 0 message lost interrupt enable.
 */
#define CAN_IE_RF0LE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF0LE_SHIFT)) & CAN_IE_RF0LE_MASK)
#define CAN_IE_RF1NE_MASK                        (0x10U)
#define CAN_IE_RF1NE_SHIFT                       (4U)
/*! RF1NE - Rx FIFO 1 new message interrupt enable.
 */
#define CAN_IE_RF1NE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF1NE_SHIFT)) & CAN_IE_RF1NE_MASK)
#define CAN_IE_RF1WE_MASK                        (0x20U)
#define CAN_IE_RF1WE_SHIFT                       (5U)
/*! RF1WE - Rx FIFO 1 watermark reached interrupt enable.
 */
#define CAN_IE_RF1WE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF1WE_SHIFT)) & CAN_IE_RF1WE_MASK)
#define CAN_IE_RF1FE_MASK                        (0x40U)
#define CAN_IE_RF1FE_SHIFT                       (6U)
/*! RF1FE - Rx FIFO 1 full interrupt enable.
 */
#define CAN_IE_RF1FE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF1FE_SHIFT)) & CAN_IE_RF1FE_MASK)
#define CAN_IE_RF1LE_MASK                        (0x80U)
#define CAN_IE_RF1LE_SHIFT                       (7U)
/*! RF1LE - Rx FIFO 1 message lost interrupt enable.
 */
#define CAN_IE_RF1LE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF1LE_SHIFT)) & CAN_IE_RF1LE_MASK)
#define CAN_IE_HPME_MASK                         (0x100U)
#define CAN_IE_HPME_SHIFT                        (8U)
/*! HPME - High priority message interrupt enable.
 */
#define CAN_IE_HPME(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_HPME_SHIFT)) & CAN_IE_HPME_MASK)
#define CAN_IE_TCE_MASK                          (0x200U)
#define CAN_IE_TCE_SHIFT                         (9U)
/*! TCE - Transmission completed interrupt enable.
 */
#define CAN_IE_TCE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IE_TCE_SHIFT)) & CAN_IE_TCE_MASK)
#define CAN_IE_TCFE_MASK                         (0x400U)
#define CAN_IE_TCFE_SHIFT                        (10U)
/*! TCFE - Transmission cancellation finished interrupt enable.
 */
#define CAN_IE_TCFE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_TCFE_SHIFT)) & CAN_IE_TCFE_MASK)
#define CAN_IE_TFEE_MASK                         (0x800U)
#define CAN_IE_TFEE_SHIFT                        (11U)
/*! TFEE - Tx FIFO empty interrupt enable.
 */
#define CAN_IE_TFEE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_TFEE_SHIFT)) & CAN_IE_TFEE_MASK)
#define CAN_IE_TEFNE_MASK                        (0x1000U)
#define CAN_IE_TEFNE_SHIFT                       (12U)
/*! TEFNE - Tx event FIFO new entry interrupt enable.
 */
#define CAN_IE_TEFNE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_TEFNE_SHIFT)) & CAN_IE_TEFNE_MASK)
#define CAN_IE_TEFWE_MASK                        (0x2000U)
#define CAN_IE_TEFWE_SHIFT                       (13U)
/*! TEFWE - Tx event FIFO watermark reached interrupt enable.
 */
#define CAN_IE_TEFWE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_TEFWE_SHIFT)) & CAN_IE_TEFWE_MASK)
#define CAN_IE_TEFFE_MASK                        (0x4000U)
#define CAN_IE_TEFFE_SHIFT                       (14U)
/*! TEFFE - Tx event FIFO full interrupt enable.
 */
#define CAN_IE_TEFFE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_TEFFE_SHIFT)) & CAN_IE_TEFFE_MASK)
#define CAN_IE_TEFLE_MASK                        (0x8000U)
#define CAN_IE_TEFLE_SHIFT                       (15U)
/*! TEFLE - Tx event FIFO element lost interrupt enable.
 */
#define CAN_IE_TEFLE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_TEFLE_SHIFT)) & CAN_IE_TEFLE_MASK)
#define CAN_IE_TSWE_MASK                         (0x10000U)
#define CAN_IE_TSWE_SHIFT                        (16U)
/*! TSWE - Timestamp wraparound interrupt enable.
 */
#define CAN_IE_TSWE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_TSWE_SHIFT)) & CAN_IE_TSWE_MASK)
#define CAN_IE_MRAFE_MASK                        (0x20000U)
#define CAN_IE_MRAFE_SHIFT                       (17U)
/*! MRAFE - Message RAM access failure interrupt enable.
 */
#define CAN_IE_MRAFE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_MRAFE_SHIFT)) & CAN_IE_MRAFE_MASK)
#define CAN_IE_TOOE_MASK                         (0x40000U)
#define CAN_IE_TOOE_SHIFT                        (18U)
/*! TOOE - Timeout occurred interrupt enable.
 */
#define CAN_IE_TOOE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_TOOE_SHIFT)) & CAN_IE_TOOE_MASK)
#define CAN_IE_DRXE_MASK                         (0x80000U)
#define CAN_IE_DRXE_SHIFT                        (19U)
/*! DRXE - Message stored in dedicated Rx buffer interrupt enable.
 */
#define CAN_IE_DRXE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_DRXE_SHIFT)) & CAN_IE_DRXE_MASK)
#define CAN_IE_BECE_MASK                         (0x100000U)
#define CAN_IE_BECE_SHIFT                        (20U)
/*! BECE - Bit error corrected interrupt enable.
 */
#define CAN_IE_BECE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_BECE_SHIFT)) & CAN_IE_BECE_MASK)
#define CAN_IE_BEUE_MASK                         (0x200000U)
#define CAN_IE_BEUE_SHIFT                        (21U)
/*! BEUE - Bit error uncorrected interrupt enable.
 */
#define CAN_IE_BEUE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_BEUE_SHIFT)) & CAN_IE_BEUE_MASK)
#define CAN_IE_ELOE_MASK                         (0x400000U)
#define CAN_IE_ELOE_SHIFT                        (22U)
/*! ELOE - Error logging overflow interrupt enable.
 */
#define CAN_IE_ELOE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_ELOE_SHIFT)) & CAN_IE_ELOE_MASK)
#define CAN_IE_EPE_MASK                          (0x800000U)
#define CAN_IE_EPE_SHIFT                         (23U)
/*! EPE - Error passive interrupt enable.
 */
#define CAN_IE_EPE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IE_EPE_SHIFT)) & CAN_IE_EPE_MASK)
#define CAN_IE_EWE_MASK                          (0x1000000U)
#define CAN_IE_EWE_SHIFT                         (24U)
/*! EWE - Warning status interrupt enable.
 */
#define CAN_IE_EWE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IE_EWE_SHIFT)) & CAN_IE_EWE_MASK)
#define CAN_IE_BOE_MASK                          (0x2000000U)
#define CAN_IE_BOE_SHIFT                         (25U)
/*! BOE - Bus_Off Status interrupt enable.
 */
#define CAN_IE_BOE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IE_BOE_SHIFT)) & CAN_IE_BOE_MASK)
#define CAN_IE_WDIE_MASK                         (0x4000000U)
#define CAN_IE_WDIE_SHIFT                        (26U)
/*! WDIE - Watchdog interrupt enable.
 */
#define CAN_IE_WDIE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_WDIE_SHIFT)) & CAN_IE_WDIE_MASK)
#define CAN_IE_PEAE_MASK                         (0x8000000U)
#define CAN_IE_PEAE_SHIFT                        (27U)
/*! PEAE - Protocol error in arbitration phase interrupt enable.
 */
#define CAN_IE_PEAE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_PEAE_SHIFT)) & CAN_IE_PEAE_MASK)
#define CAN_IE_PEDE_MASK                         (0x10000000U)
#define CAN_IE_PEDE_SHIFT                        (28U)
/*! PEDE - Protocol error in data phase interrupt enable.
 */
#define CAN_IE_PEDE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_PEDE_SHIFT)) & CAN_IE_PEDE_MASK)
#define CAN_IE_ARAE_MASK                         (0x20000000U)
#define CAN_IE_ARAE_SHIFT                        (29U)
/*! ARAE - Access to reserved address interrupt enable.
 */
#define CAN_IE_ARAE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_ARAE_SHIFT)) & CAN_IE_ARAE_MASK)
/*! @} */

/*! @name ILS - Interrupt Line Select */
/*! @{ */
#define CAN_ILS_RF0NL_MASK                       (0x1U)
#define CAN_ILS_RF0NL_SHIFT                      (0U)
/*! RF0NL - Rx FIFO 0 new message interrupt line.
 */
#define CAN_ILS_RF0NL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF0NL_SHIFT)) & CAN_ILS_RF0NL_MASK)
#define CAN_ILS_RF0WL_MASK                       (0x2U)
#define CAN_ILS_RF0WL_SHIFT                      (1U)
/*! RF0WL - Rx FIFO 0 watermark reached interrupt line.
 */
#define CAN_ILS_RF0WL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF0WL_SHIFT)) & CAN_ILS_RF0WL_MASK)
#define CAN_ILS_RF0FL_MASK                       (0x4U)
#define CAN_ILS_RF0FL_SHIFT                      (2U)
/*! RF0FL - Rx FIFO 0 full interrupt line.
 */
#define CAN_ILS_RF0FL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF0FL_SHIFT)) & CAN_ILS_RF0FL_MASK)
#define CAN_ILS_RF0LL_MASK                       (0x8U)
#define CAN_ILS_RF0LL_SHIFT                      (3U)
/*! RF0LL - Rx FIFO 0 message lost interrupt line.
 */
#define CAN_ILS_RF0LL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF0LL_SHIFT)) & CAN_ILS_RF0LL_MASK)
#define CAN_ILS_RF1NL_MASK                       (0x10U)
#define CAN_ILS_RF1NL_SHIFT                      (4U)
/*! RF1NL - Rx FIFO 1 new message interrupt line.
 */
#define CAN_ILS_RF1NL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF1NL_SHIFT)) & CAN_ILS_RF1NL_MASK)
#define CAN_ILS_RF1WL_MASK                       (0x20U)
#define CAN_ILS_RF1WL_SHIFT                      (5U)
/*! RF1WL - Rx FIFO 1 watermark reached interrupt line.
 */
#define CAN_ILS_RF1WL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF1WL_SHIFT)) & CAN_ILS_RF1WL_MASK)
#define CAN_ILS_RF1FL_MASK                       (0x40U)
#define CAN_ILS_RF1FL_SHIFT                      (6U)
/*! RF1FL - Rx FIFO 1 full interrupt line.
 */
#define CAN_ILS_RF1FL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF1FL_SHIFT)) & CAN_ILS_RF1FL_MASK)
#define CAN_ILS_RF1LL_MASK                       (0x80U)
#define CAN_ILS_RF1LL_SHIFT                      (7U)
/*! RF1LL - Rx FIFO 1 message lost interrupt line.
 */
#define CAN_ILS_RF1LL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF1LL_SHIFT)) & CAN_ILS_RF1LL_MASK)
#define CAN_ILS_HPML_MASK                        (0x100U)
#define CAN_ILS_HPML_SHIFT                       (8U)
/*! HPML - High priority message interrupt line.
 */
#define CAN_ILS_HPML(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_HPML_SHIFT)) & CAN_ILS_HPML_MASK)
#define CAN_ILS_TCL_MASK                         (0x200U)
#define CAN_ILS_TCL_SHIFT                        (9U)
/*! TCL - Transmission completed interrupt line.
 */
#define CAN_ILS_TCL(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TCL_SHIFT)) & CAN_ILS_TCL_MASK)
#define CAN_ILS_TCFL_MASK                        (0x400U)
#define CAN_ILS_TCFL_SHIFT                       (10U)
/*! TCFL - Transmission cancellation finished interrupt line.
 */
#define CAN_ILS_TCFL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TCFL_SHIFT)) & CAN_ILS_TCFL_MASK)
#define CAN_ILS_TFEL_MASK                        (0x800U)
#define CAN_ILS_TFEL_SHIFT                       (11U)
/*! TFEL - Tx FIFO empty interrupt line.
 */
#define CAN_ILS_TFEL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TFEL_SHIFT)) & CAN_ILS_TFEL_MASK)
#define CAN_ILS_TEFNL_MASK                       (0x1000U)
#define CAN_ILS_TEFNL_SHIFT                      (12U)
/*! TEFNL - Tx event FIFO new entry interrupt line.
 */
#define CAN_ILS_TEFNL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TEFNL_SHIFT)) & CAN_ILS_TEFNL_MASK)
#define CAN_ILS_TEFWL_MASK                       (0x2000U)
#define CAN_ILS_TEFWL_SHIFT                      (13U)
/*! TEFWL - Tx event FIFO watermark reached interrupt line.
 */
#define CAN_ILS_TEFWL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TEFWL_SHIFT)) & CAN_ILS_TEFWL_MASK)
#define CAN_ILS_TEFFL_MASK                       (0x4000U)
#define CAN_ILS_TEFFL_SHIFT                      (14U)
/*! TEFFL - Tx event FIFO full interrupt line.
 */
#define CAN_ILS_TEFFL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TEFFL_SHIFT)) & CAN_ILS_TEFFL_MASK)
#define CAN_ILS_TEFLL_MASK                       (0x8000U)
#define CAN_ILS_TEFLL_SHIFT                      (15U)
/*! TEFLL - Tx event FIFO element lost interrupt line.
 */
#define CAN_ILS_TEFLL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TEFLL_SHIFT)) & CAN_ILS_TEFLL_MASK)
#define CAN_ILS_TSWL_MASK                        (0x10000U)
#define CAN_ILS_TSWL_SHIFT                       (16U)
/*! TSWL - Timestamp wraparound interrupt line.
 */
#define CAN_ILS_TSWL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TSWL_SHIFT)) & CAN_ILS_TSWL_MASK)
#define CAN_ILS_MRAFL_MASK                       (0x20000U)
#define CAN_ILS_MRAFL_SHIFT                      (17U)
/*! MRAFL - Message RAM access failure interrupt line.
 */
#define CAN_ILS_MRAFL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_MRAFL_SHIFT)) & CAN_ILS_MRAFL_MASK)
#define CAN_ILS_TOOL_MASK                        (0x40000U)
#define CAN_ILS_TOOL_SHIFT                       (18U)
/*! TOOL - Timeout occurred interrupt line.
 */
#define CAN_ILS_TOOL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TOOL_SHIFT)) & CAN_ILS_TOOL_MASK)
#define CAN_ILS_DRXL_MASK                        (0x80000U)
#define CAN_ILS_DRXL_SHIFT                       (19U)
/*! DRXL - Message stored in dedicated Rx buffer interrupt line.
 */
#define CAN_ILS_DRXL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_DRXL_SHIFT)) & CAN_ILS_DRXL_MASK)
#define CAN_ILS_BECL_MASK                        (0x100000U)
#define CAN_ILS_BECL_SHIFT                       (20U)
/*! BECL - Bit error corrected interrupt line.
 */
#define CAN_ILS_BECL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_BECL_SHIFT)) & CAN_ILS_BECL_MASK)
#define CAN_ILS_BEUL_MASK                        (0x200000U)
#define CAN_ILS_BEUL_SHIFT                       (21U)
/*! BEUL - Bit error uncorrected interrupt line.
 */
#define CAN_ILS_BEUL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_BEUL_SHIFT)) & CAN_ILS_BEUL_MASK)
#define CAN_ILS_ELOL_MASK                        (0x400000U)
#define CAN_ILS_ELOL_SHIFT                       (22U)
/*! ELOL - Error logging overflow interrupt line.
 */
#define CAN_ILS_ELOL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_ELOL_SHIFT)) & CAN_ILS_ELOL_MASK)
#define CAN_ILS_EPL_MASK                         (0x800000U)
#define CAN_ILS_EPL_SHIFT                        (23U)
/*! EPL - Error passive interrupt line.
 */
#define CAN_ILS_EPL(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ILS_EPL_SHIFT)) & CAN_ILS_EPL_MASK)
#define CAN_ILS_EWL_MASK                         (0x1000000U)
#define CAN_ILS_EWL_SHIFT                        (24U)
/*! EWL - Warning status interrupt line.
 */
#define CAN_ILS_EWL(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ILS_EWL_SHIFT)) & CAN_ILS_EWL_MASK)
#define CAN_ILS_BOL_MASK                         (0x2000000U)
#define CAN_ILS_BOL_SHIFT                        (25U)
/*! BOL - Bus_Off Status interrupt line.
 */
#define CAN_ILS_BOL(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ILS_BOL_SHIFT)) & CAN_ILS_BOL_MASK)
#define CAN_ILS_WDIL_MASK                        (0x4000000U)
#define CAN_ILS_WDIL_SHIFT                       (26U)
/*! WDIL - Watchdog interrupt line.
 */
#define CAN_ILS_WDIL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_WDIL_SHIFT)) & CAN_ILS_WDIL_MASK)
#define CAN_ILS_PEAL_MASK                        (0x8000000U)
#define CAN_ILS_PEAL_SHIFT                       (27U)
/*! PEAL - Protocol error in arbitration phase interrupt line.
 */
#define CAN_ILS_PEAL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_PEAL_SHIFT)) & CAN_ILS_PEAL_MASK)
#define CAN_ILS_PEDL_MASK                        (0x10000000U)
#define CAN_ILS_PEDL_SHIFT                       (28U)
/*! PEDL - Protocol error in data phase interrupt line.
 */
#define CAN_ILS_PEDL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_PEDL_SHIFT)) & CAN_ILS_PEDL_MASK)
#define CAN_ILS_ARAL_MASK                        (0x20000000U)
#define CAN_ILS_ARAL_SHIFT                       (29U)
/*! ARAL - Access to reserved address interrupt line.
 */
#define CAN_ILS_ARAL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_ARAL_SHIFT)) & CAN_ILS_ARAL_MASK)
/*! @} */

/*! @name ILE - Interrupt Line Enable */
/*! @{ */
#define CAN_ILE_EINT0_MASK                       (0x1U)
#define CAN_ILE_EINT0_SHIFT                      (0U)
/*! EINT0 - Enable interrupt line 0.
 */
#define CAN_ILE_EINT0(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILE_EINT0_SHIFT)) & CAN_ILE_EINT0_MASK)
#define CAN_ILE_EINT1_MASK                       (0x2U)
#define CAN_ILE_EINT1_SHIFT                      (1U)
/*! EINT1 - Enable interrupt line 1.
 */
#define CAN_ILE_EINT1(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILE_EINT1_SHIFT)) & CAN_ILE_EINT1_MASK)
/*! @} */

/*! @name GFC - Global Filter Configuration */
/*! @{ */
#define CAN_GFC_RRFE_MASK                        (0x1U)
#define CAN_GFC_RRFE_SHIFT                       (0U)
/*! RRFE - Reject remote frames extended.
 */
#define CAN_GFC_RRFE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_GFC_RRFE_SHIFT)) & CAN_GFC_RRFE_MASK)
#define CAN_GFC_RRFS_MASK                        (0x2U)
#define CAN_GFC_RRFS_SHIFT                       (1U)
/*! RRFS - Reject remote frames standard.
 */
#define CAN_GFC_RRFS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_GFC_RRFS_SHIFT)) & CAN_GFC_RRFS_MASK)
#define CAN_GFC_ANFE_MASK                        (0xCU)
#define CAN_GFC_ANFE_SHIFT                       (2U)
/*! ANFE - Accept non-matching frames extended.
 */
#define CAN_GFC_ANFE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_GFC_ANFE_SHIFT)) & CAN_GFC_ANFE_MASK)
#define CAN_GFC_ANFS_MASK                        (0x30U)
#define CAN_GFC_ANFS_SHIFT                       (4U)
/*! ANFS - Accept non-matching frames standard.
 */
#define CAN_GFC_ANFS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_GFC_ANFS_SHIFT)) & CAN_GFC_ANFS_MASK)
/*! @} */

/*! @name SIDFC - Standard ID Filter Configuration */
/*! @{ */
#define CAN_SIDFC_FLSSA_MASK                     (0xFFFCU)
#define CAN_SIDFC_FLSSA_SHIFT                    (2U)
/*! FLSSA - Filter list standard start address.
 */
#define CAN_SIDFC_FLSSA(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_SIDFC_FLSSA_SHIFT)) & CAN_SIDFC_FLSSA_MASK)
#define CAN_SIDFC_LSS_MASK                       (0xFF0000U)
#define CAN_SIDFC_LSS_SHIFT                      (16U)
/*! LSS - List size standard 0 = No standard message ID filter.
 */
#define CAN_SIDFC_LSS(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_SIDFC_LSS_SHIFT)) & CAN_SIDFC_LSS_MASK)
/*! @} */

/*! @name XIDFC - Extended ID Filter Configuration */
/*! @{ */
#define CAN_XIDFC_FLESA_MASK                     (0xFFFCU)
#define CAN_XIDFC_FLESA_SHIFT                    (2U)
/*! FLESA - Filter list extended start address.
 */
#define CAN_XIDFC_FLESA(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_XIDFC_FLESA_SHIFT)) & CAN_XIDFC_FLESA_MASK)
#define CAN_XIDFC_LSE_MASK                       (0xFF0000U)
#define CAN_XIDFC_LSE_SHIFT                      (16U)
/*! LSE - List size extended 0 = No extended message ID filter.
 */
#define CAN_XIDFC_LSE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_XIDFC_LSE_SHIFT)) & CAN_XIDFC_LSE_MASK)
/*! @} */

/*! @name XIDAM - Extended ID AND Mask */
/*! @{ */
#define CAN_XIDAM_EIDM_MASK                      (0x1FFFFFFFU)
#define CAN_XIDAM_EIDM_SHIFT                     (0U)
/*! EIDM - Extended ID mask.
 */
#define CAN_XIDAM_EIDM(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_XIDAM_EIDM_SHIFT)) & CAN_XIDAM_EIDM_MASK)
/*! @} */

/*! @name HPMS - High Priority Message Status */
/*! @{ */
#define CAN_HPMS_BIDX_MASK                       (0x3FU)
#define CAN_HPMS_BIDX_SHIFT                      (0U)
/*! BIDX - Buffer index.
 */
#define CAN_HPMS_BIDX(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_HPMS_BIDX_SHIFT)) & CAN_HPMS_BIDX_MASK)
#define CAN_HPMS_MSI_MASK                        (0xC0U)
#define CAN_HPMS_MSI_SHIFT                       (6U)
/*! MSI - Message storage indicator.
 */
#define CAN_HPMS_MSI(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_HPMS_MSI_SHIFT)) & CAN_HPMS_MSI_MASK)
#define CAN_HPMS_FIDX_MASK                       (0x7F00U)
#define CAN_HPMS_FIDX_SHIFT                      (8U)
/*! FIDX - Filter index.
 */
#define CAN_HPMS_FIDX(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_HPMS_FIDX_SHIFT)) & CAN_HPMS_FIDX_MASK)
#define CAN_HPMS_FLST_MASK                       (0x8000U)
#define CAN_HPMS_FLST_SHIFT                      (15U)
/*! FLST - Filter list.
 */
#define CAN_HPMS_FLST(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_HPMS_FLST_SHIFT)) & CAN_HPMS_FLST_MASK)
/*! @} */

/*! @name NDAT1 - New Data 1 */
/*! @{ */
#define CAN_NDAT1_ND_MASK                        (0xFFFFFFFFU)
#define CAN_NDAT1_ND_SHIFT                       (0U)
/*! ND - New Data.
 */
#define CAN_NDAT1_ND(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_NDAT1_ND_SHIFT)) & CAN_NDAT1_ND_MASK)
/*! @} */

/*! @name NDAT2 - New Data 2 */
/*! @{ */
#define CAN_NDAT2_ND_MASK                        (0xFFFFFFFFU)
#define CAN_NDAT2_ND_SHIFT                       (0U)
/*! ND - New Data.
 */
#define CAN_NDAT2_ND(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_NDAT2_ND_SHIFT)) & CAN_NDAT2_ND_MASK)
/*! @} */

/*! @name RXF0C - Rx FIFO 0 Configuration */
/*! @{ */
#define CAN_RXF0C_F0SA_MASK                      (0xFFFCU)
#define CAN_RXF0C_F0SA_SHIFT                     (2U)
/*! F0SA - Rx FIFO 0 start address.
 */
#define CAN_RXF0C_F0SA(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0C_F0SA_SHIFT)) & CAN_RXF0C_F0SA_MASK)
#define CAN_RXF0C_F0S_MASK                       (0x7F0000U)
#define CAN_RXF0C_F0S_SHIFT                      (16U)
/*! F0S - Rx FIFO 0 size.
 */
#define CAN_RXF0C_F0S(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_RXF0C_F0S_SHIFT)) & CAN_RXF0C_F0S_MASK)
#define CAN_RXF0C_F0WM_MASK                      (0x7F000000U)
#define CAN_RXF0C_F0WM_SHIFT                     (24U)
/*! F0WM - Rx FIFO 0 watermark 0 = Watermark interrupt disabled.
 */
#define CAN_RXF0C_F0WM(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0C_F0WM_SHIFT)) & CAN_RXF0C_F0WM_MASK)
#define CAN_RXF0C_F0OM_MASK                      (0x80000000U)
#define CAN_RXF0C_F0OM_SHIFT                     (31U)
/*! F0OM - FIFO 0 operation mode.
 */
#define CAN_RXF0C_F0OM(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0C_F0OM_SHIFT)) & CAN_RXF0C_F0OM_MASK)
/*! @} */

/*! @name RXF0S - Rx FIFO 0 Status */
/*! @{ */
#define CAN_RXF0S_F0FL_MASK                      (0x7FU)
#define CAN_RXF0S_F0FL_SHIFT                     (0U)
/*! F0FL - Rx FIFO 0 fill level.
 */
#define CAN_RXF0S_F0FL(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0S_F0FL_SHIFT)) & CAN_RXF0S_F0FL_MASK)
#define CAN_RXF0S_F0GI_MASK                      (0x3F00U)
#define CAN_RXF0S_F0GI_SHIFT                     (8U)
/*! F0GI - Rx FIFO 0 get index.
 */
#define CAN_RXF0S_F0GI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0S_F0GI_SHIFT)) & CAN_RXF0S_F0GI_MASK)
#define CAN_RXF0S_F0PI_MASK                      (0x3F0000U)
#define CAN_RXF0S_F0PI_SHIFT                     (16U)
/*! F0PI - Rx FIFO 0 put index.
 */
#define CAN_RXF0S_F0PI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0S_F0PI_SHIFT)) & CAN_RXF0S_F0PI_MASK)
#define CAN_RXF0S_F0F_MASK                       (0x1000000U)
#define CAN_RXF0S_F0F_SHIFT                      (24U)
/*! F0F - Rx FIFO 0 full.
 */
#define CAN_RXF0S_F0F(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_RXF0S_F0F_SHIFT)) & CAN_RXF0S_F0F_MASK)
#define CAN_RXF0S_RF0L_MASK                      (0x2000000U)
#define CAN_RXF0S_RF0L_SHIFT                     (25U)
/*! RF0L - Rx FIFO 0 message lost.
 */
#define CAN_RXF0S_RF0L(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0S_RF0L_SHIFT)) & CAN_RXF0S_RF0L_MASK)
/*! @} */

/*! @name RXF0A - Rx FIFO 0 Acknowledge */
/*! @{ */
#define CAN_RXF0A_F0AI_MASK                      (0x3FU)
#define CAN_RXF0A_F0AI_SHIFT                     (0U)
/*! F0AI - Rx FIFO 0 acknowledge index.
 */
#define CAN_RXF0A_F0AI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0A_F0AI_SHIFT)) & CAN_RXF0A_F0AI_MASK)
/*! @} */

/*! @name RXBC - Rx Buffer Configuration */
/*! @{ */
#define CAN_RXBC_RBSA_MASK                       (0xFFFCU)
#define CAN_RXBC_RBSA_SHIFT                      (2U)
/*! RBSA - Rx buffer start address.
 */
#define CAN_RXBC_RBSA(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_RXBC_RBSA_SHIFT)) & CAN_RXBC_RBSA_MASK)
/*! @} */

/*! @name RXF1C - Rx FIFO 1 Configuration */
/*! @{ */
#define CAN_RXF1C_F1SA_MASK                      (0xFFFCU)
#define CAN_RXF1C_F1SA_SHIFT                     (2U)
/*! F1SA - Rx FIFO 1 start address.
 */
#define CAN_RXF1C_F1SA(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1C_F1SA_SHIFT)) & CAN_RXF1C_F1SA_MASK)
#define CAN_RXF1C_F1S_MASK                       (0x7F0000U)
#define CAN_RXF1C_F1S_SHIFT                      (16U)
/*! F1S - Rx FIFO 1 size 0 = No Rx FIFO 1.
 */
#define CAN_RXF1C_F1S(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_RXF1C_F1S_SHIFT)) & CAN_RXF1C_F1S_MASK)
#define CAN_RXF1C_F1WM_MASK                      (0x7F000000U)
#define CAN_RXF1C_F1WM_SHIFT                     (24U)
/*! F1WM - Rx FIFO 1 watermark 0 = Watermark interrupt disabled.
 */
#define CAN_RXF1C_F1WM(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1C_F1WM_SHIFT)) & CAN_RXF1C_F1WM_MASK)
#define CAN_RXF1C_F1OM_MASK                      (0x80000000U)
#define CAN_RXF1C_F1OM_SHIFT                     (31U)
/*! F1OM - FIFO 1 operation mode.
 */
#define CAN_RXF1C_F1OM(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1C_F1OM_SHIFT)) & CAN_RXF1C_F1OM_MASK)
/*! @} */

/*! @name RXF1S - Rx FIFO 1 Status */
/*! @{ */
#define CAN_RXF1S_F1FL_MASK                      (0x7FU)
#define CAN_RXF1S_F1FL_SHIFT                     (0U)
/*! F1FL - Rx FIFO 1 fill level.
 */
#define CAN_RXF1S_F1FL(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1S_F1FL_SHIFT)) & CAN_RXF1S_F1FL_MASK)
#define CAN_RXF1S_F1GI_MASK                      (0x3F00U)
#define CAN_RXF1S_F1GI_SHIFT                     (8U)
/*! F1GI - Rx FIFO 1 get index.
 */
#define CAN_RXF1S_F1GI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1S_F1GI_SHIFT)) & CAN_RXF1S_F1GI_MASK)
#define CAN_RXF1S_F1PI_MASK                      (0x3F0000U)
#define CAN_RXF1S_F1PI_SHIFT                     (16U)
/*! F1PI - Rx FIFO 1 put index.
 */
#define CAN_RXF1S_F1PI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1S_F1PI_SHIFT)) & CAN_RXF1S_F1PI_MASK)
#define CAN_RXF1S_F1F_MASK                       (0x1000000U)
#define CAN_RXF1S_F1F_SHIFT                      (24U)
/*! F1F - Rx FIFO 1 full.
 */
#define CAN_RXF1S_F1F(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_RXF1S_F1F_SHIFT)) & CAN_RXF1S_F1F_MASK)
#define CAN_RXF1S_RF1L_MASK                      (0x2000000U)
#define CAN_RXF1S_RF1L_SHIFT                     (25U)
/*! RF1L - Rx FIFO 1 message lost.
 */
#define CAN_RXF1S_RF1L(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1S_RF1L_SHIFT)) & CAN_RXF1S_RF1L_MASK)
/*! @} */

/*! @name RXF1A - Rx FIFO 1 Acknowledge */
/*! @{ */
#define CAN_RXF1A_F1AI_MASK                      (0x3FU)
#define CAN_RXF1A_F1AI_SHIFT                     (0U)
/*! F1AI - Rx FIFO 1 acknowledge index.
 */
#define CAN_RXF1A_F1AI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1A_F1AI_SHIFT)) & CAN_RXF1A_F1AI_MASK)
/*! @} */

/*! @name RXESC - Rx Buffer and FIFO Element Size Configuration */
/*! @{ */
#define CAN_RXESC_F0DS_MASK                      (0x7U)
#define CAN_RXESC_F0DS_SHIFT                     (0U)
/*! F0DS - Rx FIFO 0 data field size.
 */
#define CAN_RXESC_F0DS(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXESC_F0DS_SHIFT)) & CAN_RXESC_F0DS_MASK)
#define CAN_RXESC_F1DS_MASK                      (0x70U)
#define CAN_RXESC_F1DS_SHIFT                     (4U)
/*! F1DS - Rx FIFO 1 data field size.
 */
#define CAN_RXESC_F1DS(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXESC_F1DS_SHIFT)) & CAN_RXESC_F1DS_MASK)
#define CAN_RXESC_RBDS_MASK                      (0x700U)
#define CAN_RXESC_RBDS_SHIFT                     (8U)
/*! RBDS - .
 */
#define CAN_RXESC_RBDS(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXESC_RBDS_SHIFT)) & CAN_RXESC_RBDS_MASK)
/*! @} */

/*! @name TXBC - Tx Buffer Configuration */
/*! @{ */
#define CAN_TXBC_TBSA_MASK                       (0xFFFCU)
#define CAN_TXBC_TBSA_SHIFT                      (2U)
/*! TBSA - Tx buffers start address.
 */
#define CAN_TXBC_TBSA(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TXBC_TBSA_SHIFT)) & CAN_TXBC_TBSA_MASK)
#define CAN_TXBC_NDTB_MASK                       (0x3F0000U)
#define CAN_TXBC_NDTB_SHIFT                      (16U)
/*! NDTB - Number of dedicated transmit buffers 0 = No dedicated Tx buffers.
 */
#define CAN_TXBC_NDTB(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TXBC_NDTB_SHIFT)) & CAN_TXBC_NDTB_MASK)
#define CAN_TXBC_TFQS_MASK                       (0x3F000000U)
#define CAN_TXBC_TFQS_SHIFT                      (24U)
/*! TFQS - Transmit FIFO/queue size 0 = No tx FIFO/Queue.
 */
#define CAN_TXBC_TFQS(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TXBC_TFQS_SHIFT)) & CAN_TXBC_TFQS_MASK)
#define CAN_TXBC_TFQM_MASK                       (0x40000000U)
#define CAN_TXBC_TFQM_SHIFT                      (30U)
/*! TFQM - Tx FIFO/queue mode.
 */
#define CAN_TXBC_TFQM(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TXBC_TFQM_SHIFT)) & CAN_TXBC_TFQM_MASK)
/*! @} */

/*! @name TXFQS - Tx FIFO/Queue Status */
/*! @{ */
#define CAN_TXFQS_TFGI_MASK                      (0x1F00U)
#define CAN_TXFQS_TFGI_SHIFT                     (8U)
/*! TFGI - Tx FIFO get index.
 */
#define CAN_TXFQS_TFGI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXFQS_TFGI_SHIFT)) & CAN_TXFQS_TFGI_MASK)
#define CAN_TXFQS_TFQPI_MASK                     (0x1F0000U)
#define CAN_TXFQS_TFQPI_SHIFT                    (16U)
/*! TFQPI - Tx FIFO/queue put index.
 */
#define CAN_TXFQS_TFQPI(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_TXFQS_TFQPI_SHIFT)) & CAN_TXFQS_TFQPI_MASK)
#define CAN_TXFQS_TFQF_MASK                      (0x200000U)
#define CAN_TXFQS_TFQF_SHIFT                     (21U)
/*! TFQF - Tx FIFO/queue full.
 */
#define CAN_TXFQS_TFQF(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXFQS_TFQF_SHIFT)) & CAN_TXFQS_TFQF_MASK)
/*! @} */

/*! @name TXESC - Tx Buffer Element Size Configuration */
/*! @{ */
#define CAN_TXESC_TBDS_MASK                      (0x7U)
#define CAN_TXESC_TBDS_SHIFT                     (0U)
/*! TBDS - Tx buffer data field size.
 */
#define CAN_TXESC_TBDS(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXESC_TBDS_SHIFT)) & CAN_TXESC_TBDS_MASK)
/*! @} */

/*! @name TXBRP - Tx Buffer Request Pending */
/*! @{ */
#define CAN_TXBRP_TRP_MASK                       (0xFFFFFFFFU)
#define CAN_TXBRP_TRP_SHIFT                      (0U)
/*! TRP - Transmission request pending.
 */
#define CAN_TXBRP_TRP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TXBRP_TRP_SHIFT)) & CAN_TXBRP_TRP_MASK)
/*! @} */

/*! @name TXBAR - Tx Buffer Add Request */
/*! @{ */
#define CAN_TXBAR_AR_MASK                        (0xFFFFFFFFU)
#define CAN_TXBAR_AR_SHIFT                       (0U)
/*! AR - Add request.
 */
#define CAN_TXBAR_AR(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TXBAR_AR_SHIFT)) & CAN_TXBAR_AR_MASK)
/*! @} */

/*! @name TXBCR - Tx Buffer Cancellation Request */
/*! @{ */
#define CAN_TXBCR_CR_MASK                        (0xFFFFFFFFU)
#define CAN_TXBCR_CR_SHIFT                       (0U)
/*! CR - Cancellation request.
 */
#define CAN_TXBCR_CR(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TXBCR_CR_SHIFT)) & CAN_TXBCR_CR_MASK)
/*! @} */

/*! @name TXBTO - Tx Buffer Transmission Occurred */
/*! @{ */
#define CAN_TXBTO_TO_MASK                        (0xFFFFFFFFU)
#define CAN_TXBTO_TO_SHIFT                       (0U)
/*! TO - Transmission occurred.
 */
#define CAN_TXBTO_TO(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TXBTO_TO_SHIFT)) & CAN_TXBTO_TO_MASK)
/*! @} */

/*! @name TXBCF - Tx Buffer Cancellation Finished */
/*! @{ */
#define CAN_TXBCF_TO_MASK                        (0xFFFFFFFFU)
#define CAN_TXBCF_TO_SHIFT                       (0U)
/*! TO - Cancellation finished.
 */
#define CAN_TXBCF_TO(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TXBCF_TO_SHIFT)) & CAN_TXBCF_TO_MASK)
/*! @} */

/*! @name TXBTIE - Tx Buffer Transmission Interrupt Enable */
/*! @{ */
#define CAN_TXBTIE_TIE_MASK                      (0xFFFFFFFFU)
#define CAN_TXBTIE_TIE_SHIFT                     (0U)
/*! TIE - Transmission interrupt enable.
 */
#define CAN_TXBTIE_TIE(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXBTIE_TIE_SHIFT)) & CAN_TXBTIE_TIE_MASK)
/*! @} */

/*! @name TXBCIE - Tx Buffer Cancellation Finished Interrupt Enable */
/*! @{ */
#define CAN_TXBCIE_CFIE_MASK                     (0xFFFFFFFFU)
#define CAN_TXBCIE_CFIE_SHIFT                    (0U)
/*! CFIE - Cancellation finished interrupt enable.
 */
#define CAN_TXBCIE_CFIE(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_TXBCIE_CFIE_SHIFT)) & CAN_TXBCIE_CFIE_MASK)
/*! @} */

/*! @name TXEFC - Tx Event FIFO Configuration */
/*! @{ */
#define CAN_TXEFC_EFSA_MASK                      (0xFFFCU)
#define CAN_TXEFC_EFSA_SHIFT                     (2U)
/*! EFSA - Event FIFO start address.
 */
#define CAN_TXEFC_EFSA(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXEFC_EFSA_SHIFT)) & CAN_TXEFC_EFSA_MASK)
#define CAN_TXEFC_EFS_MASK                       (0x3F0000U)
#define CAN_TXEFC_EFS_SHIFT                      (16U)
/*! EFS - Event FIFO size 0 = Tx event FIFO disabled.
 */
#define CAN_TXEFC_EFS(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TXEFC_EFS_SHIFT)) & CAN_TXEFC_EFS_MASK)
#define CAN_TXEFC_EFWM_MASK                      (0x3F000000U)
#define CAN_TXEFC_EFWM_SHIFT                     (24U)
/*! EFWM - Event FIFO watermark 0 = Watermark interrupt disabled.
 */
#define CAN_TXEFC_EFWM(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXEFC_EFWM_SHIFT)) & CAN_TXEFC_EFWM_MASK)
/*! @} */

/*! @name TXEFS - Tx Event FIFO Status */
/*! @{ */
#define CAN_TXEFS_EFFL_MASK                      (0x3FU)
#define CAN_TXEFS_EFFL_SHIFT                     (0U)
/*! EFFL - Event FIFO fill level.
 */
#define CAN_TXEFS_EFFL(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXEFS_EFFL_SHIFT)) & CAN_TXEFS_EFFL_MASK)
#define CAN_TXEFS_EFGI_MASK                      (0x1F00U)
#define CAN_TXEFS_EFGI_SHIFT                     (8U)
/*! EFGI - Event FIFO get index.
 */
#define CAN_TXEFS_EFGI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXEFS_EFGI_SHIFT)) & CAN_TXEFS_EFGI_MASK)
#define CAN_TXEFS_EFPI_MASK                      (0x3F0000U)
#define CAN_TXEFS_EFPI_SHIFT                     (16U)
/*! EFPI - Event FIFO put index.
 */
#define CAN_TXEFS_EFPI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXEFS_EFPI_SHIFT)) & CAN_TXEFS_EFPI_MASK)
#define CAN_TXEFS_EFF_MASK                       (0x1000000U)
#define CAN_TXEFS_EFF_SHIFT                      (24U)
/*! EFF - Event FIFO full.
 */
#define CAN_TXEFS_EFF(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TXEFS_EFF_SHIFT)) & CAN_TXEFS_EFF_MASK)
#define CAN_TXEFS_TEFL_MASK                      (0x2000000U)
#define CAN_TXEFS_TEFL_SHIFT                     (25U)
/*! TEFL - Tx event FIFO element lost.
 */
#define CAN_TXEFS_TEFL(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXEFS_TEFL_SHIFT)) & CAN_TXEFS_TEFL_MASK)
/*! @} */

/*! @name TXEFA - Tx Event FIFO Acknowledge */
/*! @{ */
#define CAN_TXEFA_EFAI_MASK                      (0x1FU)
#define CAN_TXEFA_EFAI_SHIFT                     (0U)
/*! EFAI - Event FIFO acknowledge index.
 */
#define CAN_TXEFA_EFAI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXEFA_EFAI_SHIFT)) & CAN_TXEFA_EFAI_MASK)
/*! @} */

/*! @name MRBA - CAN Message RAM Base Address */
/*! @{ */
#define CAN_MRBA_BA_MASK                         (0xFFFF0000U)
#define CAN_MRBA_BA_SHIFT                        (16U)
/*! BA - Base address for the message RAM in the chip memory map.
 */
#define CAN_MRBA_BA(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MRBA_BA_SHIFT)) & CAN_MRBA_BA_MASK)
/*! @} */

/*! @name ETSCC - External Timestamp Counter Configuration */
/*! @{ */
#define CAN_ETSCC_ETCP_MASK                      (0x7FFU)
#define CAN_ETSCC_ETCP_SHIFT                     (0U)
/*! ETCP - External timestamp prescaler value.
 */
#define CAN_ETSCC_ETCP(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ETSCC_ETCP_SHIFT)) & CAN_ETSCC_ETCP_MASK)
#define CAN_ETSCC_ETCE_MASK                      (0x80000000U)
#define CAN_ETSCC_ETCE_SHIFT                     (31U)
/*! ETCE - External timestamp counter enable.
 */
#define CAN_ETSCC_ETCE(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ETSCC_ETCE_SHIFT)) & CAN_ETSCC_ETCE_MASK)
/*! @} */

/*! @name ETSCV - External Timestamp Counter Value */
/*! @{ */
#define CAN_ETSCV_ETSC_MASK                      (0xFFFFU)
#define CAN_ETSCV_ETSC_SHIFT                     (0U)
/*! ETSC - External timestamp counter.
 */
#define CAN_ETSCV_ETSC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ETSCV_ETSC_SHIFT)) & CAN_ETSCV_ETSC_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CAN_Register_Masks */


/* CAN - Peripheral instance base addresses */
/** Peripheral CAN0 base address */
#define CAN0_BASE                                (0x4009D000u)
/** Peripheral CAN0 base pointer */
#define CAN0                                     ((CAN_Type *)CAN0_BASE)
/** Peripheral CAN1 base address */
#define CAN1_BASE                                (0x4009E000u)
/** Peripheral CAN1 base pointer */
#define CAN1                                     ((CAN_Type *)CAN1_BASE)
/** Array initializer of CAN peripheral base addresses */
#define CAN_BASE_ADDRS                           { CAN0_BASE, CAN1_BASE }
/** Array initializer of CAN peripheral base pointers */
#define CAN_BASE_PTRS                            { CAN0, CAN1 }
/** Interrupt vectors for the CAN peripheral type */
#define CAN_IRQS                                 { { CAN0_IRQ0_IRQn, CAN0_IRQ1_IRQn }, { CAN1_IRQ0_IRQn, CAN1_IRQ1_IRQn } }

/*!
 * @}
 */ /* end of group CAN_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Peripheral_Access_Layer CRC Peripheral Access Layer
 * @{
 */

/** CRC - Register Layout Typedef */
typedef struct {
  __IO uint32_t MODE;                              /**< CRC mode register, offset: 0x0 */
  __IO uint32_t SEED;                              /**< CRC seed register, offset: 0x4 */
  union {                                          /* offset: 0x8 */
    __I  uint32_t SUM;                               /**< CRC checksum register, offset: 0x8 */
    __O  uint32_t WR_DATA;                           /**< CRC data register, offset: 0x8 */
  };
} CRC_Type;

/* ----------------------------------------------------------------------------
   -- CRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Masks CRC Register Masks
 * @{
 */

/*! @name MODE - CRC mode register */
/*! @{ */
#define CRC_MODE_CRC_POLY_MASK                   (0x3U)
#define CRC_MODE_CRC_POLY_SHIFT                  (0U)
/*! CRC_POLY - CRC polynomial: 1X = CRC-32 polynomial 01 = CRC-16 polynomial 00 = CRC-CCITT polynomial
 */
#define CRC_MODE_CRC_POLY(x)                     (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CRC_POLY_SHIFT)) & CRC_MODE_CRC_POLY_MASK)
#define CRC_MODE_BIT_RVS_WR_MASK                 (0x4U)
#define CRC_MODE_BIT_RVS_WR_SHIFT                (2U)
/*! BIT_RVS_WR - Data bit order: 1 = Bit order reverse for CRC_WR_DATA (per byte) 0 = No bit order reverse for CRC_WR_DATA (per byte)
 */
#define CRC_MODE_BIT_RVS_WR(x)                   (((uint32_t)(((uint32_t)(x)) << CRC_MODE_BIT_RVS_WR_SHIFT)) & CRC_MODE_BIT_RVS_WR_MASK)
#define CRC_MODE_CMPL_WR_MASK                    (0x8U)
#define CRC_MODE_CMPL_WR_SHIFT                   (3U)
/*! CMPL_WR - Data complement: 1 = 1's complement for CRC_WR_DATA 0 = No 1's complement for CRC_WR_DATA
 */
#define CRC_MODE_CMPL_WR(x)                      (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CMPL_WR_SHIFT)) & CRC_MODE_CMPL_WR_MASK)
#define CRC_MODE_BIT_RVS_SUM_MASK                (0x10U)
#define CRC_MODE_BIT_RVS_SUM_SHIFT               (4U)
/*! BIT_RVS_SUM - CRC sum bit order: 1 = Bit order reverse for CRC_SUM 0 = No bit order reverse for CRC_SUM
 */
#define CRC_MODE_BIT_RVS_SUM(x)                  (((uint32_t)(((uint32_t)(x)) << CRC_MODE_BIT_RVS_SUM_SHIFT)) & CRC_MODE_BIT_RVS_SUM_MASK)
#define CRC_MODE_CMPL_SUM_MASK                   (0x20U)
#define CRC_MODE_CMPL_SUM_SHIFT                  (5U)
/*! CMPL_SUM - CRC sum complement: 1 = 1's complement for CRC_SUM 0 = No 1's complement for CRC_SUM
 */
#define CRC_MODE_CMPL_SUM(x)                     (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CMPL_SUM_SHIFT)) & CRC_MODE_CMPL_SUM_MASK)
/*! @} */

/*! @name SEED - CRC seed register */
/*! @{ */
#define CRC_SEED_CRC_SEED_MASK                   (0xFFFFFFFFU)
#define CRC_SEED_CRC_SEED_SHIFT                  (0U)
/*! CRC_SEED - A write access to this register will load CRC seed value to CRC_SUM register with
 *    selected bit order and 1's complement pre-processes. A write access to this register will
 *    overrule the CRC calculation in progresses.
 */
#define CRC_SEED_CRC_SEED(x)                     (((uint32_t)(((uint32_t)(x)) << CRC_SEED_CRC_SEED_SHIFT)) & CRC_SEED_CRC_SEED_MASK)
/*! @} */

/*! @name SUM - CRC checksum register */
/*! @{ */
#define CRC_SUM_CRC_SUM_MASK                     (0xFFFFFFFFU)
#define CRC_SUM_CRC_SUM_SHIFT                    (0U)
/*! CRC_SUM - The most recent CRC sum can be read through this register with selected bit order and 1's complement post-processes.
 */
#define CRC_SUM_CRC_SUM(x)                       (((uint32_t)(((uint32_t)(x)) << CRC_SUM_CRC_SUM_SHIFT)) & CRC_SUM_CRC_SUM_MASK)
/*! @} */

/*! @name WR_DATA - CRC data register */
/*! @{ */
#define CRC_WR_DATA_CRC_WR_DATA_MASK             (0xFFFFFFFFU)
#define CRC_WR_DATA_CRC_WR_DATA_SHIFT            (0U)
/*! CRC_WR_DATA - Data written to this register will be taken to perform CRC calculation with
 *    selected bit order and 1's complement pre-process. Any write size 8, 16 or 32-bit are allowed and
 *    accept back-to-back transactions.
 */
#define CRC_WR_DATA_CRC_WR_DATA(x)               (((uint32_t)(((uint32_t)(x)) << CRC_WR_DATA_CRC_WR_DATA_SHIFT)) & CRC_WR_DATA_CRC_WR_DATA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CRC_Register_Masks */


/* CRC - Peripheral instance base addresses */
/** Peripheral CRC_ENGINE base address */
#define CRC_ENGINE_BASE                          (0x40095000u)
/** Peripheral CRC_ENGINE base pointer */
#define CRC_ENGINE                               ((CRC_Type *)CRC_ENGINE_BASE)
/** Array initializer of CRC peripheral base addresses */
#define CRC_BASE_ADDRS                           { CRC_ENGINE_BASE }
/** Array initializer of CRC peripheral base pointers */
#define CRC_BASE_PTRS                            { CRC_ENGINE }

/*!
 * @}
 */ /* end of group CRC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CTIMER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Peripheral_Access_Layer CTIMER Peripheral Access Layer
 * @{
 */

/** CTIMER - Register Layout Typedef */
typedef struct {
  __IO uint32_t IR;                                /**< Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending., offset: 0x0 */
  __IO uint32_t TCR;                               /**< Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR., offset: 0x4 */
  __IO uint32_t TC;                                /**< Timer Counter, offset: 0x8 */
  __IO uint32_t PR;                                /**< Prescale Register, offset: 0xC */
  __IO uint32_t PC;                                /**< Prescale Counter, offset: 0x10 */
  __IO uint32_t MCR;                               /**< Match Control Register, offset: 0x14 */
  __IO uint32_t MR[4];                             /**< Match Register . MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC., array offset: 0x18, array step: 0x4 */
  __IO uint32_t CCR;                               /**< Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place., offset: 0x28 */
  __I  uint32_t CR[4];                             /**< Capture Register . CR is loaded with the value of TC when there is an event on the CAPn. input., array offset: 0x2C, array step: 0x4 */
  __IO uint32_t EMR;                               /**< External Match Register. The EMR controls the match function and the external match pins., offset: 0x3C */
       uint8_t RESERVED_0[48];
  __IO uint32_t CTCR;                              /**< Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting., offset: 0x70 */
  __IO uint32_t PWMC;                              /**< PWM Control Register. The PWMCON enables PWM mode for the external match pins., offset: 0x74 */
  __IO uint32_t MSR[4];                            /**< Match Shadow Register, array offset: 0x78, array step: 0x4 */
} CTIMER_Type;

/* ----------------------------------------------------------------------------
   -- CTIMER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Register_Masks CTIMER Register Masks
 * @{
 */

/*! @name IR - Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending. */
/*! @{ */
#define CTIMER_IR_MR0INT_MASK                    (0x1U)
#define CTIMER_IR_MR0INT_SHIFT                   (0U)
/*! MR0INT - Interrupt flag for match channel 0.
 */
#define CTIMER_IR_MR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR0INT_SHIFT)) & CTIMER_IR_MR0INT_MASK)
#define CTIMER_IR_MR1INT_MASK                    (0x2U)
#define CTIMER_IR_MR1INT_SHIFT                   (1U)
/*! MR1INT - Interrupt flag for match channel 1.
 */
#define CTIMER_IR_MR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR1INT_SHIFT)) & CTIMER_IR_MR1INT_MASK)
#define CTIMER_IR_MR2INT_MASK                    (0x4U)
#define CTIMER_IR_MR2INT_SHIFT                   (2U)
/*! MR2INT - Interrupt flag for match channel 2.
 */
#define CTIMER_IR_MR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR2INT_SHIFT)) & CTIMER_IR_MR2INT_MASK)
#define CTIMER_IR_MR3INT_MASK                    (0x8U)
#define CTIMER_IR_MR3INT_SHIFT                   (3U)
/*! MR3INT - Interrupt flag for match channel 3.
 */
#define CTIMER_IR_MR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR3INT_SHIFT)) & CTIMER_IR_MR3INT_MASK)
#define CTIMER_IR_CR0INT_MASK                    (0x10U)
#define CTIMER_IR_CR0INT_SHIFT                   (4U)
/*! CR0INT - Interrupt flag for capture channel 0 event.
 */
#define CTIMER_IR_CR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR0INT_SHIFT)) & CTIMER_IR_CR0INT_MASK)
#define CTIMER_IR_CR1INT_MASK                    (0x20U)
#define CTIMER_IR_CR1INT_SHIFT                   (5U)
/*! CR1INT - Interrupt flag for capture channel 1 event.
 */
#define CTIMER_IR_CR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR1INT_SHIFT)) & CTIMER_IR_CR1INT_MASK)
#define CTIMER_IR_CR2INT_MASK                    (0x40U)
#define CTIMER_IR_CR2INT_SHIFT                   (6U)
/*! CR2INT - Interrupt flag for capture channel 2 event.
 */
#define CTIMER_IR_CR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR2INT_SHIFT)) & CTIMER_IR_CR2INT_MASK)
#define CTIMER_IR_CR3INT_MASK                    (0x80U)
#define CTIMER_IR_CR3INT_SHIFT                   (7U)
/*! CR3INT - Interrupt flag for capture channel 3 event.
 */
#define CTIMER_IR_CR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR3INT_SHIFT)) & CTIMER_IR_CR3INT_MASK)
/*! @} */

/*! @name TCR - Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR. */
/*! @{ */
#define CTIMER_TCR_CEN_MASK                      (0x1U)
#define CTIMER_TCR_CEN_SHIFT                     (0U)
/*! CEN - Counter enable.
 *  0b0..Disabled.The counters are disabled.
 *  0b1..Enabled. The Timer Counter and Prescale Counter are enabled.
 */
#define CTIMER_TCR_CEN(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CEN_SHIFT)) & CTIMER_TCR_CEN_MASK)
#define CTIMER_TCR_CRST_MASK                     (0x2U)
#define CTIMER_TCR_CRST_SHIFT                    (1U)
/*! CRST - Counter reset.
 *  0b0..Disabled. Do nothing.
 *  0b1..Enabled. The Timer Counter and the Prescale Counter are synchronously reset on the next positive edge of
 *       the APB bus clock. The counters remain reset until TCR[1] is returned to zero.
 */
#define CTIMER_TCR_CRST(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CRST_SHIFT)) & CTIMER_TCR_CRST_MASK)
/*! @} */

/*! @name TC - Timer Counter */
/*! @{ */
#define CTIMER_TC_TCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_TC_TCVAL_SHIFT                    (0U)
/*! TCVAL - Timer counter value.
 */
#define CTIMER_TC_TCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TC_TCVAL_SHIFT)) & CTIMER_TC_TCVAL_MASK)
/*! @} */

/*! @name PR - Prescale Register */
/*! @{ */
#define CTIMER_PR_PRVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PR_PRVAL_SHIFT                    (0U)
/*! PRVAL - Prescale counter value.
 */
#define CTIMER_PR_PRVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PR_PRVAL_SHIFT)) & CTIMER_PR_PRVAL_MASK)
/*! @} */

/*! @name PC - Prescale Counter */
/*! @{ */
#define CTIMER_PC_PCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PC_PCVAL_SHIFT                    (0U)
/*! PCVAL - Prescale counter value.
 */
#define CTIMER_PC_PCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PC_PCVAL_SHIFT)) & CTIMER_PC_PCVAL_MASK)
/*! @} */

/*! @name MCR - Match Control Register */
/*! @{ */
#define CTIMER_MCR_MR0I_MASK                     (0x1U)
#define CTIMER_MCR_MR0I_SHIFT                    (0U)
/*! MR0I - Interrupt on MR0: an interrupt is generated when MR0 matches the value in the TC.
 */
#define CTIMER_MCR_MR0I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0I_SHIFT)) & CTIMER_MCR_MR0I_MASK)
#define CTIMER_MCR_MR0R_MASK                     (0x2U)
#define CTIMER_MCR_MR0R_SHIFT                    (1U)
/*! MR0R - Reset on MR0: the TC will be reset if MR0 matches it.
 */
#define CTIMER_MCR_MR0R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0R_SHIFT)) & CTIMER_MCR_MR0R_MASK)
#define CTIMER_MCR_MR0S_MASK                     (0x4U)
#define CTIMER_MCR_MR0S_SHIFT                    (2U)
/*! MR0S - Stop on MR0: the TC and PC will be stopped and TCR[0] will be set to 0 if MR0 matches the TC.
 */
#define CTIMER_MCR_MR0S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0S_SHIFT)) & CTIMER_MCR_MR0S_MASK)
#define CTIMER_MCR_MR1I_MASK                     (0x8U)
#define CTIMER_MCR_MR1I_SHIFT                    (3U)
/*! MR1I - Interrupt on MR1: an interrupt is generated when MR1 matches the value in the TC.
 */
#define CTIMER_MCR_MR1I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1I_SHIFT)) & CTIMER_MCR_MR1I_MASK)
#define CTIMER_MCR_MR1R_MASK                     (0x10U)
#define CTIMER_MCR_MR1R_SHIFT                    (4U)
/*! MR1R - Reset on MR1: the TC will be reset if MR1 matches it.
 */
#define CTIMER_MCR_MR1R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1R_SHIFT)) & CTIMER_MCR_MR1R_MASK)
#define CTIMER_MCR_MR1S_MASK                     (0x20U)
#define CTIMER_MCR_MR1S_SHIFT                    (5U)
/*! MR1S - Stop on MR1: the TC and PC will be stopped and TCR[0] will be set to 0 if MR1 matches the TC.
 */
#define CTIMER_MCR_MR1S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1S_SHIFT)) & CTIMER_MCR_MR1S_MASK)
#define CTIMER_MCR_MR2I_MASK                     (0x40U)
#define CTIMER_MCR_MR2I_SHIFT                    (6U)
/*! MR2I - Interrupt on MR2: an interrupt is generated when MR2 matches the value in the TC.
 */
#define CTIMER_MCR_MR2I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2I_SHIFT)) & CTIMER_MCR_MR2I_MASK)
#define CTIMER_MCR_MR2R_MASK                     (0x80U)
#define CTIMER_MCR_MR2R_SHIFT                    (7U)
/*! MR2R - Reset on MR2: the TC will be reset if MR2 matches it.
 */
#define CTIMER_MCR_MR2R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2R_SHIFT)) & CTIMER_MCR_MR2R_MASK)
#define CTIMER_MCR_MR2S_MASK                     (0x100U)
#define CTIMER_MCR_MR2S_SHIFT                    (8U)
/*! MR2S - Stop on MR2: the TC and PC will be stopped and TCR[0] will be set to 0 if MR2 matches the TC.
 */
#define CTIMER_MCR_MR2S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2S_SHIFT)) & CTIMER_MCR_MR2S_MASK)
#define CTIMER_MCR_MR3I_MASK                     (0x200U)
#define CTIMER_MCR_MR3I_SHIFT                    (9U)
/*! MR3I - Interrupt on MR3: an interrupt is generated when MR3 matches the value in the TC.
 */
#define CTIMER_MCR_MR3I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3I_SHIFT)) & CTIMER_MCR_MR3I_MASK)
#define CTIMER_MCR_MR3R_MASK                     (0x400U)
#define CTIMER_MCR_MR3R_SHIFT                    (10U)
/*! MR3R - Reset on MR3: the TC will be reset if MR3 matches it.
 */
#define CTIMER_MCR_MR3R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3R_SHIFT)) & CTIMER_MCR_MR3R_MASK)
#define CTIMER_MCR_MR3S_MASK                     (0x800U)
#define CTIMER_MCR_MR3S_SHIFT                    (11U)
/*! MR3S - Stop on MR3: the TC and PC will be stopped and TCR[0] will be set to 0 if MR3 matches the TC.
 */
#define CTIMER_MCR_MR3S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3S_SHIFT)) & CTIMER_MCR_MR3S_MASK)
#define CTIMER_MCR_MR0RL_MASK                    (0x1000000U)
#define CTIMER_MCR_MR0RL_SHIFT                   (24U)
/*! MR0RL - Reload MR0 with the contents of the Match 0 Shadow Register when the TC is reset to zero
 *    (either via a match event or a write to bit 1 of the TCR).
 */
#define CTIMER_MCR_MR0RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0RL_SHIFT)) & CTIMER_MCR_MR0RL_MASK)
#define CTIMER_MCR_MR1RL_MASK                    (0x2000000U)
#define CTIMER_MCR_MR1RL_SHIFT                   (25U)
/*! MR1RL - Reload MR1 with the contents of the Match 1 Shadow Register when the TC is reset to zero
 *    (either via a match event or a write to bit 1 of the TCR).
 */
#define CTIMER_MCR_MR1RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1RL_SHIFT)) & CTIMER_MCR_MR1RL_MASK)
#define CTIMER_MCR_MR2RL_MASK                    (0x4000000U)
#define CTIMER_MCR_MR2RL_SHIFT                   (26U)
/*! MR2RL - Reload MR2 with the contents of the Match 2 Shadow Register when the TC is reset to zero
 *    (either via a match event or a write to bit 1 of the TCR).
 */
#define CTIMER_MCR_MR2RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2RL_SHIFT)) & CTIMER_MCR_MR2RL_MASK)
#define CTIMER_MCR_MR3RL_MASK                    (0x8000000U)
#define CTIMER_MCR_MR3RL_SHIFT                   (27U)
/*! MR3RL - Reload MR3 with the contents of the Match 3 Shadow Register when the TC is reset to zero
 *    (either via a match event or a write to bit 1 of the TCR).
 */
#define CTIMER_MCR_MR3RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3RL_SHIFT)) & CTIMER_MCR_MR3RL_MASK)
/*! @} */

/*! @name MR - Match Register . MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC. */
/*! @{ */
#define CTIMER_MR_MATCH_MASK                     (0xFFFFFFFFU)
#define CTIMER_MR_MATCH_SHIFT                    (0U)
/*! MATCH - Timer counter match value.
 */
#define CTIMER_MR_MATCH(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MR_MATCH_SHIFT)) & CTIMER_MR_MATCH_MASK)
/*! @} */

/* The count of CTIMER_MR */
#define CTIMER_MR_COUNT                          (4U)

/*! @name CCR - Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place. */
/*! @{ */
#define CTIMER_CCR_CAP0RE_MASK                   (0x1U)
#define CTIMER_CCR_CAP0RE_SHIFT                  (0U)
/*! CAP0RE - Rising edge of capture channel 0: a sequence of 0 then 1 causes CR0 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP0RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0RE_SHIFT)) & CTIMER_CCR_CAP0RE_MASK)
#define CTIMER_CCR_CAP0FE_MASK                   (0x2U)
#define CTIMER_CCR_CAP0FE_SHIFT                  (1U)
/*! CAP0FE - Falling edge of capture channel 0: a sequence of 1 then 0 causes CR0 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP0FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0FE_SHIFT)) & CTIMER_CCR_CAP0FE_MASK)
#define CTIMER_CCR_CAP0I_MASK                    (0x4U)
#define CTIMER_CCR_CAP0I_SHIFT                   (2U)
/*! CAP0I - Generate interrupt on channel 0 capture event: a CR0 load generates an interrupt.
 */
#define CTIMER_CCR_CAP0I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0I_SHIFT)) & CTIMER_CCR_CAP0I_MASK)
#define CTIMER_CCR_CAP1RE_MASK                   (0x8U)
#define CTIMER_CCR_CAP1RE_SHIFT                  (3U)
/*! CAP1RE - Rising edge of capture channel 1: a sequence of 0 then 1 causes CR1 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP1RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1RE_SHIFT)) & CTIMER_CCR_CAP1RE_MASK)
#define CTIMER_CCR_CAP1FE_MASK                   (0x10U)
#define CTIMER_CCR_CAP1FE_SHIFT                  (4U)
/*! CAP1FE - Falling edge of capture channel 1: a sequence of 1 then 0 causes CR1 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP1FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1FE_SHIFT)) & CTIMER_CCR_CAP1FE_MASK)
#define CTIMER_CCR_CAP1I_MASK                    (0x20U)
#define CTIMER_CCR_CAP1I_SHIFT                   (5U)
/*! CAP1I - Generate interrupt on channel 1 capture event: a CR1 load generates an interrupt.
 */
#define CTIMER_CCR_CAP1I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1I_SHIFT)) & CTIMER_CCR_CAP1I_MASK)
#define CTIMER_CCR_CAP2RE_MASK                   (0x40U)
#define CTIMER_CCR_CAP2RE_SHIFT                  (6U)
/*! CAP2RE - Rising edge of capture channel 2: a sequence of 0 then 1 causes CR2 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP2RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2RE_SHIFT)) & CTIMER_CCR_CAP2RE_MASK)
#define CTIMER_CCR_CAP2FE_MASK                   (0x80U)
#define CTIMER_CCR_CAP2FE_SHIFT                  (7U)
/*! CAP2FE - Falling edge of capture channel 2: a sequence of 1 then 0 causes CR2 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP2FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2FE_SHIFT)) & CTIMER_CCR_CAP2FE_MASK)
#define CTIMER_CCR_CAP2I_MASK                    (0x100U)
#define CTIMER_CCR_CAP2I_SHIFT                   (8U)
/*! CAP2I - Generate interrupt on channel 2 capture event: a CR2 load generates an interrupt.
 */
#define CTIMER_CCR_CAP2I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2I_SHIFT)) & CTIMER_CCR_CAP2I_MASK)
#define CTIMER_CCR_CAP3RE_MASK                   (0x200U)
#define CTIMER_CCR_CAP3RE_SHIFT                  (9U)
/*! CAP3RE - Rising edge of capture channel 3: a sequence of 0 then 1 causes CR3 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP3RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3RE_SHIFT)) & CTIMER_CCR_CAP3RE_MASK)
#define CTIMER_CCR_CAP3FE_MASK                   (0x400U)
#define CTIMER_CCR_CAP3FE_SHIFT                  (10U)
/*! CAP3FE - Falling edge of capture channel 3: a sequence of 1 then 0 causes CR3 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP3FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3FE_SHIFT)) & CTIMER_CCR_CAP3FE_MASK)
#define CTIMER_CCR_CAP3I_MASK                    (0x800U)
#define CTIMER_CCR_CAP3I_SHIFT                   (11U)
/*! CAP3I - Generate interrupt on channel 3 capture event: a CR3 load generates an interrupt.
 */
#define CTIMER_CCR_CAP3I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3I_SHIFT)) & CTIMER_CCR_CAP3I_MASK)
/*! @} */

/*! @name CR - Capture Register . CR is loaded with the value of TC when there is an event on the CAPn. input. */
/*! @{ */
#define CTIMER_CR_CAP_MASK                       (0xFFFFFFFFU)
#define CTIMER_CR_CAP_SHIFT                      (0U)
/*! CAP - Timer counter capture value.
 */
#define CTIMER_CR_CAP(x)                         (((uint32_t)(((uint32_t)(x)) << CTIMER_CR_CAP_SHIFT)) & CTIMER_CR_CAP_MASK)
/*! @} */

/* The count of CTIMER_CR */
#define CTIMER_CR_COUNT                          (4U)

/*! @name EMR - External Match Register. The EMR controls the match function and the external match pins. */
/*! @{ */
#define CTIMER_EMR_EM0_MASK                      (0x1U)
#define CTIMER_EMR_EM0_SHIFT                     (0U)
/*! EM0 - External Match 0. This bit reflects the state of output MAT0, whether or not this output
 *    is connected to a pin. When a match occurs between the TC and MR0, this bit can either toggle,
 *    go LOW, go HIGH, or do nothing, as selected by EMR[5:4]. This bit is driven to the MAT pins if
 *    the match function is selected via IOCON. 0 = LOW. 1 = HIGH.
 */
#define CTIMER_EMR_EM0(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM0_SHIFT)) & CTIMER_EMR_EM0_MASK)
#define CTIMER_EMR_EM1_MASK                      (0x2U)
#define CTIMER_EMR_EM1_SHIFT                     (1U)
/*! EM1 - External Match 1. This bit reflects the state of output MAT1, whether or not this output
 *    is connected to a pin. When a match occurs between the TC and MR1, this bit can either toggle,
 *    go LOW, go HIGH, or do nothing, as selected by EMR[7:6]. This bit is driven to the MAT pins if
 *    the match function is selected via IOCON. 0 = LOW. 1 = HIGH.
 */
#define CTIMER_EMR_EM1(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM1_SHIFT)) & CTIMER_EMR_EM1_MASK)
#define CTIMER_EMR_EM2_MASK                      (0x4U)
#define CTIMER_EMR_EM2_SHIFT                     (2U)
/*! EM2 - External Match 2. This bit reflects the state of output MAT2, whether or not this output
 *    is connected to a pin. When a match occurs between the TC and MR2, this bit can either toggle,
 *    go LOW, go HIGH, or do nothing, as selected by EMR[9:8]. This bit is driven to the MAT pins if
 *    the match function is selected via IOCON. 0 = LOW. 1 = HIGH.
 */
#define CTIMER_EMR_EM2(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM2_SHIFT)) & CTIMER_EMR_EM2_MASK)
#define CTIMER_EMR_EM3_MASK                      (0x8U)
#define CTIMER_EMR_EM3_SHIFT                     (3U)
/*! EM3 - External Match 3. This bit reflects the state of output MAT3, whether or not this output
 *    is connected to a pin. When a match occurs between the TC and MR3, this bit can either toggle,
 *    go LOW, go HIGH, or do nothing, as selected by MR[11:10]. This bit is driven to the MAT pins
 *    if the match function is selected via IOCON. 0 = LOW. 1 = HIGH.
 */
#define CTIMER_EMR_EM3(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM3_SHIFT)) & CTIMER_EMR_EM3_MASK)
#define CTIMER_EMR_EMC0_MASK                     (0x30U)
#define CTIMER_EMR_EMC0_SHIFT                    (4U)
/*! EMC0 - External Match Control 0. Determines the functionality of External Match 0.
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT0 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT0 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC0(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC0_SHIFT)) & CTIMER_EMR_EMC0_MASK)
#define CTIMER_EMR_EMC1_MASK                     (0xC0U)
#define CTIMER_EMR_EMC1_SHIFT                    (6U)
/*! EMC1 - External Match Control 1. Determines the functionality of External Match 1.
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT1 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT1 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC1(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC1_SHIFT)) & CTIMER_EMR_EMC1_MASK)
#define CTIMER_EMR_EMC2_MASK                     (0x300U)
#define CTIMER_EMR_EMC2_SHIFT                    (8U)
/*! EMC2 - External Match Control 2. Determines the functionality of External Match 2.
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT2 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT2 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC2(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC2_SHIFT)) & CTIMER_EMR_EMC2_MASK)
#define CTIMER_EMR_EMC3_MASK                     (0xC00U)
#define CTIMER_EMR_EMC3_SHIFT                    (10U)
/*! EMC3 - External Match Control 3. Determines the functionality of External Match 3.
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT3 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT3 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC3(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC3_SHIFT)) & CTIMER_EMR_EMC3_MASK)
/*! @} */

/*! @name CTCR - Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting. */
/*! @{ */
#define CTIMER_CTCR_CTMODE_MASK                  (0x3U)
#define CTIMER_CTCR_CTMODE_SHIFT                 (0U)
/*! CTMODE - Counter/Timer Mode This field selects which rising APB bus clock edges can increment
 *    Timer's Prescale Counter (PC), or clear PC and increment Timer Counter (TC). Timer Mode: the TC
 *    is incremented when the Prescale Counter matches the Prescale Register.
 *  0b00..Timer Mode. Incremented every rising APB bus clock edge.
 *  0b01..Counter Mode rising edge. TC is incremented on rising edges on the CAP input selected by bits 3:2.
 *  0b10..Counter Mode falling edge. TC is incremented on falling edges on the CAP input selected by bits 3:2.
 *  0b11..Counter Mode dual edge. TC is incremented on both edges on the CAP input selected by bits 3:2.
 */
#define CTIMER_CTCR_CTMODE(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CTMODE_SHIFT)) & CTIMER_CTCR_CTMODE_MASK)
#define CTIMER_CTCR_CINSEL_MASK                  (0xCU)
#define CTIMER_CTCR_CINSEL_SHIFT                 (2U)
/*! CINSEL - Count Input Select When bits 1:0 in this register are not 00, these bits select which
 *    CAP pin is sampled for clocking. Note: If Counter mode is selected for a particular CAPn input
 *    in the CTCR, the 3 bits for that input in the Capture Control Register (CCR) must be
 *    programmed as 000. However, capture and/or interrupt can be selected for the other 3 CAPn inputs in the
 *    same timer.
 *  0b00..Channel 0. CAPn.0 for CTIMERn
 *  0b01..Channel 1. CAPn.1 for CTIMERn
 *  0b10..Channel 2. CAPn.2 for CTIMERn
 *  0b11..Channel 3. CAPn.3 for CTIMERn
 */
#define CTIMER_CTCR_CINSEL(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CINSEL_SHIFT)) & CTIMER_CTCR_CINSEL_MASK)
#define CTIMER_CTCR_ENCC_MASK                    (0x10U)
#define CTIMER_CTCR_ENCC_SHIFT                   (4U)
/*! ENCC - Setting this bit to 1 enables clearing of the timer and the prescaler when the
 *    capture-edge event specified in bits 7:5 occurs.
 */
#define CTIMER_CTCR_ENCC(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_ENCC_SHIFT)) & CTIMER_CTCR_ENCC_MASK)
#define CTIMER_CTCR_SELCC_MASK                   (0xE0U)
#define CTIMER_CTCR_SELCC_SHIFT                  (5U)
/*! SELCC - Edge select. When bit 4 is 1, these bits select which capture input edge will cause the
 *    timer and prescaler to be cleared. These bits have no effect when bit 4 is low. Values 0x2 to
 *    0x3 and 0x6 to 0x7 are reserved.
 *  0b000..Channel 0 Rising Edge. Rising edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
 *  0b001..Channel 0 Falling Edge. Falling edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
 *  0b010..Channel 1 Rising Edge. Rising edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
 *  0b011..Channel 1 Falling Edge. Falling edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
 *  0b100..Channel 2 Rising Edge. Rising edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
 *  0b101..Channel 2 Falling Edge. Falling edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
 */
#define CTIMER_CTCR_SELCC(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_SELCC_SHIFT)) & CTIMER_CTCR_SELCC_MASK)
/*! @} */

/*! @name PWMC - PWM Control Register. The PWMCON enables PWM mode for the external match pins. */
/*! @{ */
#define CTIMER_PWMC_PWMEN0_MASK                  (0x1U)
#define CTIMER_PWMC_PWMEN0_SHIFT                 (0U)
/*! PWMEN0 - PWM mode enable for channel0.
 *  0b0..Match. CTIMERn_MAT0 is controlled by EM0.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT0.
 */
#define CTIMER_PWMC_PWMEN0(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN0_SHIFT)) & CTIMER_PWMC_PWMEN0_MASK)
#define CTIMER_PWMC_PWMEN1_MASK                  (0x2U)
#define CTIMER_PWMC_PWMEN1_SHIFT                 (1U)
/*! PWMEN1 - PWM mode enable for channel1.
 *  0b0..Match. CTIMERn_MAT01 is controlled by EM1.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT1.
 */
#define CTIMER_PWMC_PWMEN1(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN1_SHIFT)) & CTIMER_PWMC_PWMEN1_MASK)
#define CTIMER_PWMC_PWMEN2_MASK                  (0x4U)
#define CTIMER_PWMC_PWMEN2_SHIFT                 (2U)
/*! PWMEN2 - PWM mode enable for channel2.
 *  0b0..Match. CTIMERn_MAT2 is controlled by EM2.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT2.
 */
#define CTIMER_PWMC_PWMEN2(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN2_SHIFT)) & CTIMER_PWMC_PWMEN2_MASK)
#define CTIMER_PWMC_PWMEN3_MASK                  (0x8U)
#define CTIMER_PWMC_PWMEN3_SHIFT                 (3U)
/*! PWMEN3 - PWM mode enable for channel3. Note: It is recommended to use match channel 3 to set the PWM cycle.
 *  0b0..Match. CTIMERn_MAT3 is controlled by EM3.
 *  0b1..PWM. PWM mode is enabled for CT132Bn_MAT3.
 */
#define CTIMER_PWMC_PWMEN3(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN3_SHIFT)) & CTIMER_PWMC_PWMEN3_MASK)
/*! @} */

/*! @name MSR - Match Shadow Register */
/*! @{ */
#define CTIMER_MSR_SHADOWW_MASK                  (0xFFFFFFFFU)
#define CTIMER_MSR_SHADOWW_SHIFT                 (0U)
/*! SHADOWW - Timer counter match shadow value.
 */
#define CTIMER_MSR_SHADOWW(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_MSR_SHADOWW_SHIFT)) & CTIMER_MSR_SHADOWW_MASK)
/*! @} */

/* The count of CTIMER_MSR */
#define CTIMER_MSR_COUNT                         (4U)


/*!
 * @}
 */ /* end of group CTIMER_Register_Masks */


/* CTIMER - Peripheral instance base addresses */
/** Peripheral CTIMER0 base address */
#define CTIMER0_BASE                             (0x40008000u)
/** Peripheral CTIMER0 base pointer */
#define CTIMER0                                  ((CTIMER_Type *)CTIMER0_BASE)
/** Peripheral CTIMER1 base address */
#define CTIMER1_BASE                             (0x40009000u)
/** Peripheral CTIMER1 base pointer */
#define CTIMER1                                  ((CTIMER_Type *)CTIMER1_BASE)
/** Peripheral CTIMER2 base address */
#define CTIMER2_BASE                             (0x40028000u)
/** Peripheral CTIMER2 base pointer */
#define CTIMER2                                  ((CTIMER_Type *)CTIMER2_BASE)
/** Peripheral CTIMER3 base address */
#define CTIMER3_BASE                             (0x40048000u)
/** Peripheral CTIMER3 base pointer */
#define CTIMER3                                  ((CTIMER_Type *)CTIMER3_BASE)
/** Peripheral CTIMER4 base address */
#define CTIMER4_BASE                             (0x40049000u)
/** Peripheral CTIMER4 base pointer */
#define CTIMER4                                  ((CTIMER_Type *)CTIMER4_BASE)
/** Array initializer of CTIMER peripheral base addresses */
#define CTIMER_BASE_ADDRS                        { CTIMER0_BASE, CTIMER1_BASE, CTIMER2_BASE, CTIMER3_BASE, CTIMER4_BASE }
/** Array initializer of CTIMER peripheral base pointers */
#define CTIMER_BASE_PTRS                         { CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4 }
/** Interrupt vectors for the CTIMER peripheral type */
#define CTIMER_IRQS                              { CTIMER0_IRQn, CTIMER1_IRQn, CTIMER2_IRQn, CTIMER3_IRQn, CTIMER4_IRQn }

/*!
 * @}
 */ /* end of group CTIMER_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Peripheral_Access_Layer DMA Peripheral Access Layer
 * @{
 */

/** DMA - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< DMA control., offset: 0x0 */
  __I  uint32_t INTSTAT;                           /**< Interrupt status., offset: 0x4 */
  __IO uint32_t SRAMBASE;                          /**< SRAM address of the channel configuration table., offset: 0x8 */
       uint8_t RESERVED_0[20];
  struct {                                         /* offset: 0x20, array step: 0x5C */
    __IO uint32_t ENABLESET;                         /**< Channel Enable read and Set for all DMA channels., array offset: 0x20, array step: 0x5C */
         uint8_t RESERVED_0[4];
    __O  uint32_t ENABLECLR;                         /**< Channel Enable Clear for all DMA channels., array offset: 0x28, array step: 0x5C */
         uint8_t RESERVED_1[4];
    __I  uint32_t ACTIVE;                            /**< Channel Active status for all DMA channels., array offset: 0x30, array step: 0x5C */
         uint8_t RESERVED_2[4];
    __I  uint32_t BUSY;                              /**< Channel Busy status for all DMA channels., array offset: 0x38, array step: 0x5C */
         uint8_t RESERVED_3[4];
    __IO uint32_t ERRINT;                            /**< Error Interrupt status for all DMA channels., array offset: 0x40, array step: 0x5C */
         uint8_t RESERVED_4[4];
    __IO uint32_t INTENSET;                          /**< Interrupt Enable read and Set for all DMA channels., array offset: 0x48, array step: 0x5C */
         uint8_t RESERVED_5[4];
    __O  uint32_t INTENCLR;                          /**< Interrupt Enable Clear for all DMA channels., array offset: 0x50, array step: 0x5C */
         uint8_t RESERVED_6[4];
    __IO uint32_t INTA;                              /**< Interrupt A status for all DMA channels., array offset: 0x58, array step: 0x5C */
         uint8_t RESERVED_7[4];
    __IO uint32_t INTB;                              /**< Interrupt B status for all DMA channels., array offset: 0x60, array step: 0x5C */
         uint8_t RESERVED_8[4];
    __O  uint32_t SETVALID;                          /**< Set ValidPending control bits for all DMA channels., array offset: 0x68, array step: 0x5C */
         uint8_t RESERVED_9[4];
    __O  uint32_t SETTRIG;                           /**< Set Trigger control bits for all DMA channels., array offset: 0x70, array step: 0x5C */
         uint8_t RESERVED_10[4];
    __O  uint32_t ABORT;                             /**< Channel Abort control for all DMA channels., array offset: 0x78, array step: 0x5C */
  } COMMON[1];
       uint8_t RESERVED_1[900];
  struct {                                         /* offset: 0x400, array step: 0x10 */
    __IO uint32_t CFG;                               /**< Configuration register for DMA channel ., array offset: 0x400, array step: 0x10 */
    __I  uint32_t CTLSTAT;                           /**< Control and status register for DMA channel ., array offset: 0x404, array step: 0x10 */
    __IO uint32_t XFERCFG;                           /**< Transfer configuration register for DMA channel ., array offset: 0x408, array step: 0x10 */
         uint8_t RESERVED_0[4];
  } CHANNEL[32];
} DMA_Type;

/* ----------------------------------------------------------------------------
   -- DMA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Masks DMA Register Masks
 * @{
 */

/*! @name CTRL - DMA control. */
/*! @{ */
#define DMA_CTRL_ENABLE_MASK                     (0x1U)
#define DMA_CTRL_ENABLE_SHIFT                    (0U)
/*! ENABLE - DMA controller master enable.
 *  0b0..Disabled. The DMA controller is disabled. This clears any triggers that were asserted at the point when
 *       disabled, but does not prevent re-triggering when the DMA controller is re-enabled.
 *  0b1..Enabled. The DMA controller is enabled.
 */
#define DMA_CTRL_ENABLE(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_CTRL_ENABLE_SHIFT)) & DMA_CTRL_ENABLE_MASK)
/*! @} */

/*! @name INTSTAT - Interrupt status. */
/*! @{ */
#define DMA_INTSTAT_ACTIVEINT_MASK               (0x2U)
#define DMA_INTSTAT_ACTIVEINT_SHIFT              (1U)
/*! ACTIVEINT - Summarizes whether any enabled interrupts (other than error interrupts) are pending.
 *  0b0..Not pending. No enabled interrupts are pending.
 *  0b1..Pending. At least one enabled interrupt is pending.
 */
#define DMA_INTSTAT_ACTIVEINT(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_INTSTAT_ACTIVEINT_SHIFT)) & DMA_INTSTAT_ACTIVEINT_MASK)
#define DMA_INTSTAT_ACTIVEERRINT_MASK            (0x4U)
#define DMA_INTSTAT_ACTIVEERRINT_SHIFT           (2U)
/*! ACTIVEERRINT - Summarizes whether any error interrupts are pending.
 *  0b0..Not pending. No error interrupts are pending.
 *  0b1..Pending. At least one error interrupt is pending.
 */
#define DMA_INTSTAT_ACTIVEERRINT(x)              (((uint32_t)(((uint32_t)(x)) << DMA_INTSTAT_ACTIVEERRINT_SHIFT)) & DMA_INTSTAT_ACTIVEERRINT_MASK)
/*! @} */

/*! @name SRAMBASE - SRAM address of the channel configuration table. */
/*! @{ */
#define DMA_SRAMBASE_OFFSET_MASK                 (0xFFFFFE00U)
#define DMA_SRAMBASE_OFFSET_SHIFT                (9U)
/*! OFFSET - Address bits 31:9 of the beginning of the DMA descriptor table. For 18 channels, the
 *    table must begin on a 512 byte boundary.
 */
#define DMA_SRAMBASE_OFFSET(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_SRAMBASE_OFFSET_SHIFT)) & DMA_SRAMBASE_OFFSET_MASK)
/*! @} */

/*! @name COMMON_ENABLESET - Channel Enable read and Set for all DMA channels. */
/*! @{ */
#define DMA_COMMON_ENABLESET_ENA_MASK            (0xFFFFFFFFU)
#define DMA_COMMON_ENABLESET_ENA_SHIFT           (0U)
/*! ENA - Enable for DMA channels. Bit n enables or disables DMA channel n. The number of bits =
 *    number of DMA channels in this device. Other bits are reserved. 0 = disabled. 1 = enabled.
 */
#define DMA_COMMON_ENABLESET_ENA(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENA_SHIFT)) & DMA_COMMON_ENABLESET_ENA_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLESET */
#define DMA_COMMON_ENABLESET_COUNT               (1U)

/*! @name COMMON_ENABLECLR - Channel Enable Clear for all DMA channels. */
/*! @{ */
#define DMA_COMMON_ENABLECLR_CLR_MASK            (0xFFFFFFFFU)
#define DMA_COMMON_ENABLECLR_CLR_SHIFT           (0U)
/*! CLR - Writing ones to this register clears the corresponding bits in ENABLESET0. Bit n clears
 *    the channel enable bit n. The number of bits = number of DMA channels in this device. Other bits
 *    are reserved.
 */
#define DMA_COMMON_ENABLECLR_CLR(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR_SHIFT)) & DMA_COMMON_ENABLECLR_CLR_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLECLR */
#define DMA_COMMON_ENABLECLR_COUNT               (1U)

/*! @name COMMON_ACTIVE - Channel Active status for all DMA channels. */
/*! @{ */
#define DMA_COMMON_ACTIVE_ACT_MASK               (0xFFFFFFFFU)
#define DMA_COMMON_ACTIVE_ACT_SHIFT              (0U)
/*! ACT - Active flag for DMA channel n. Bit n corresponds to DMA channel n. The number of bits =
 *    number of DMA channels in this device. Other bits are reserved. 0 = not active. 1 = active.
 */
#define DMA_COMMON_ACTIVE_ACT(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACT_SHIFT)) & DMA_COMMON_ACTIVE_ACT_MASK)
/*! @} */

/* The count of DMA_COMMON_ACTIVE */
#define DMA_COMMON_ACTIVE_COUNT                  (1U)

/*! @name COMMON_BUSY - Channel Busy status for all DMA channels. */
/*! @{ */
#define DMA_COMMON_BUSY_BSY_MASK                 (0xFFFFFFFFU)
#define DMA_COMMON_BUSY_BSY_SHIFT                (0U)
/*! BSY - Busy flag for DMA channel n. Bit n corresponds to DMA channel n. The number of bits =
 *    number of DMA channels in this device. Other bits are reserved. 0 = not busy. 1 = busy.
 */
#define DMA_COMMON_BUSY_BSY(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BSY_SHIFT)) & DMA_COMMON_BUSY_BSY_MASK)
/*! @} */

/* The count of DMA_COMMON_BUSY */
#define DMA_COMMON_BUSY_COUNT                    (1U)

/*! @name COMMON_ERRINT - Error Interrupt status for all DMA channels. */
/*! @{ */
#define DMA_COMMON_ERRINT_ERR_MASK               (0xFFFFFFFFU)
#define DMA_COMMON_ERRINT_ERR_SHIFT              (0U)
/*! ERR - Error Interrupt flag for DMA channel n. Bit n corresponds to DMA channel n. The number of
 *    bits = number of DMA channels in this device. Other bits are reserved. 0 = error interrupt is
 *    not active. 1 = error interrupt is active.
 */
#define DMA_COMMON_ERRINT_ERR(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR_SHIFT)) & DMA_COMMON_ERRINT_ERR_MASK)
/*! @} */

/* The count of DMA_COMMON_ERRINT */
#define DMA_COMMON_ERRINT_COUNT                  (1U)

/*! @name COMMON_INTENSET - Interrupt Enable read and Set for all DMA channels. */
/*! @{ */
#define DMA_COMMON_INTENSET_INTEN_MASK           (0xFFFFFFFFU)
#define DMA_COMMON_INTENSET_INTEN_SHIFT          (0U)
/*! INTEN - Interrupt Enable read and set for DMA channel n. Bit n corresponds to DMA channel n. The
 *    number of bits = number of DMA channels in this device. Other bits are reserved. 0 =
 *    interrupt for DMA channel is disabled. 1 = interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN_SHIFT)) & DMA_COMMON_INTENSET_INTEN_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENSET */
#define DMA_COMMON_INTENSET_COUNT                (1U)

/*! @name COMMON_INTENCLR - Interrupt Enable Clear for all DMA channels. */
/*! @{ */
#define DMA_COMMON_INTENCLR_CLR_MASK             (0xFFFFFFFFU)
#define DMA_COMMON_INTENCLR_CLR_SHIFT            (0U)
/*! CLR - Writing ones to this register clears corresponding bits in the INTENSET0. Bit n
 *    corresponds to DMA channel n. The number of bits = number of DMA channels in this device. Other bits are
 *    reserved.
 */
#define DMA_COMMON_INTENCLR_CLR(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR_SHIFT)) & DMA_COMMON_INTENCLR_CLR_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENCLR */
#define DMA_COMMON_INTENCLR_COUNT                (1U)

/*! @name COMMON_INTA - Interrupt A status for all DMA channels. */
/*! @{ */
#define DMA_COMMON_INTA_IA_MASK                  (0xFFFFFFFFU)
#define DMA_COMMON_INTA_IA_SHIFT                 (0U)
/*! IA - Interrupt A status for DMA channel n. Bit n corresponds to DMA channel n. The number of
 *    bits = number of DMA channels in this device. Other bits are reserved. 0 = the DMA channel
 *    interrupt A is not active. 1 = the DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_IA(x)                    (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_IA_SHIFT)) & DMA_COMMON_INTA_IA_MASK)
/*! @} */

/* The count of DMA_COMMON_INTA */
#define DMA_COMMON_INTA_COUNT                    (1U)

/*! @name COMMON_INTB - Interrupt B status for all DMA channels. */
/*! @{ */
#define DMA_COMMON_INTB_IB_MASK                  (0xFFFFFFFFU)
#define DMA_COMMON_INTB_IB_SHIFT                 (0U)
/*! IB - Interrupt B status for DMA channel n. Bit n corresponds to DMA channel n. The number of
 *    bits = number of DMA channels in this device. Other bits are reserved. 0 = the DMA channel
 *    interrupt B is not active. 1 = the DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_IB(x)                    (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_IB_SHIFT)) & DMA_COMMON_INTB_IB_MASK)
/*! @} */

/* The count of DMA_COMMON_INTB */
#define DMA_COMMON_INTB_COUNT                    (1U)

/*! @name COMMON_SETVALID - Set ValidPending control bits for all DMA channels. */
/*! @{ */
#define DMA_COMMON_SETVALID_SV_MASK              (0xFFFFFFFFU)
#define DMA_COMMON_SETVALID_SV_SHIFT             (0U)
/*! SV - SETVALID control for DMA channel n. Bit n corresponds to DMA channel n. The number of bits
 *    = number of DMA channels in this device. Other bits are reserved. 0 = no effect. 1 = sets the
 *    VALIDPENDING control bit for DMA channel n
 */
#define DMA_COMMON_SETVALID_SV(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SV_SHIFT)) & DMA_COMMON_SETVALID_SV_MASK)
/*! @} */

/* The count of DMA_COMMON_SETVALID */
#define DMA_COMMON_SETVALID_COUNT                (1U)

/*! @name COMMON_SETTRIG - Set Trigger control bits for all DMA channels. */
/*! @{ */
#define DMA_COMMON_SETTRIG_TRIG_MASK             (0xFFFFFFFFU)
#define DMA_COMMON_SETTRIG_TRIG_SHIFT            (0U)
/*! TRIG - Set Trigger control bit for DMA channel 0. Bit n corresponds to DMA channel n. The number
 *    of bits = number of DMA channels in this device. Other bits are reserved. 0 = no effect. 1 =
 *    sets the TRIG bit for DMA channel n.
 */
#define DMA_COMMON_SETTRIG_TRIG(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_TRIG_SHIFT)) & DMA_COMMON_SETTRIG_TRIG_MASK)
/*! @} */

/* The count of DMA_COMMON_SETTRIG */
#define DMA_COMMON_SETTRIG_COUNT                 (1U)

/*! @name COMMON_ABORT - Channel Abort control for all DMA channels. */
/*! @{ */
#define DMA_COMMON_ABORT_ABORTCTRL_MASK          (0xFFFFFFFFU)
#define DMA_COMMON_ABORT_ABORTCTRL_SHIFT         (0U)
/*! ABORTCTRL - Abort control for DMA channel 0. Bit n corresponds to DMA channel n. 0 = no effect.
 *    1 = aborts DMA operations on channel n.
 */
#define DMA_COMMON_ABORT_ABORTCTRL(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORTCTRL_SHIFT)) & DMA_COMMON_ABORT_ABORTCTRL_MASK)
/*! @} */

/* The count of DMA_COMMON_ABORT */
#define DMA_COMMON_ABORT_COUNT                   (1U)

/*! @name CHANNEL_CFG - Configuration register for DMA channel . */
/*! @{ */
#define DMA_CHANNEL_CFG_PERIPHREQEN_MASK         (0x1U)
#define DMA_CHANNEL_CFG_PERIPHREQEN_SHIFT        (0U)
/*! PERIPHREQEN - Peripheral request Enable. If a DMA channel is used to perform a memory-to-memory
 *    move, any peripheral DMA request associated with that channel can be disabled to prevent any
 *    interaction between the peripheral and the DMA controller.
 *  0b0..Disabled. Peripheral DMA requests are disabled.
 *  0b1..Enabled. Peripheral DMA requests are enabled.
 */
#define DMA_CHANNEL_CFG_PERIPHREQEN(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_PERIPHREQEN_SHIFT)) & DMA_CHANNEL_CFG_PERIPHREQEN_MASK)
#define DMA_CHANNEL_CFG_HWTRIGEN_MASK            (0x2U)
#define DMA_CHANNEL_CFG_HWTRIGEN_SHIFT           (1U)
/*! HWTRIGEN - Hardware Triggering Enable for this channel.
 *  0b0..Disabled. Hardware triggering is not used.
 *  0b1..Enabled. Use hardware triggering.
 */
#define DMA_CHANNEL_CFG_HWTRIGEN(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_HWTRIGEN_SHIFT)) & DMA_CHANNEL_CFG_HWTRIGEN_MASK)
#define DMA_CHANNEL_CFG_TRIGPOL_MASK             (0x10U)
#define DMA_CHANNEL_CFG_TRIGPOL_SHIFT            (4U)
/*! TRIGPOL - Trigger Polarity. Selects the polarity of a hardware trigger for this channel.
 *  0b0..Active low - falling edge. Hardware trigger is active low or falling edge triggered, based on TRIGTYPE.
 *  0b1..Active high - rising edge. Hardware trigger is active high or rising edge triggered, based on TRIGTYPE.
 */
#define DMA_CHANNEL_CFG_TRIGPOL(x)               (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGPOL_SHIFT)) & DMA_CHANNEL_CFG_TRIGPOL_MASK)
#define DMA_CHANNEL_CFG_TRIGTYPE_MASK            (0x20U)
#define DMA_CHANNEL_CFG_TRIGTYPE_SHIFT           (5U)
/*! TRIGTYPE - Trigger Type. Selects hardware trigger as edge triggered or level triggered.
 *  0b0..Edge. Hardware trigger is edge triggered. Transfers will be initiated and completed, as specified for a single trigger.
 *  0b1..Level. Hardware trigger is level triggered. Note that when level triggering without burst (BURSTPOWER =
 *       0) is selected, only hardware triggers should be used on that channel. Transfers continue as long as the
 *       trigger level is asserted. Once the trigger is de-asserted, the transfer will be paused until the trigger
 *       is, again, asserted. However, the transfer will not be paused until any remaining transfers within the
 *       current BURSTPOWER length are completed.
 */
#define DMA_CHANNEL_CFG_TRIGTYPE(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGTYPE_SHIFT)) & DMA_CHANNEL_CFG_TRIGTYPE_MASK)
#define DMA_CHANNEL_CFG_TRIGBURST_MASK           (0x40U)
#define DMA_CHANNEL_CFG_TRIGBURST_SHIFT          (6U)
/*! TRIGBURST - Trigger Burst. Selects whether hardware triggers cause a single or burst transfer.
 *  0b0..Single transfer. Hardware trigger causes a single transfer.
 *  0b1..Burst transfer. When the trigger for this channel is set to edge triggered, a hardware trigger causes a
 *       burst transfer, as defined by BURSTPOWER. When the trigger for this channel is set to level triggered, a
 *       hardware trigger causes transfers to continue as long as the trigger is asserted, unless the transfer is
 *       complete.
 */
#define DMA_CHANNEL_CFG_TRIGBURST(x)             (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGBURST_SHIFT)) & DMA_CHANNEL_CFG_TRIGBURST_MASK)
#define DMA_CHANNEL_CFG_BURSTPOWER_MASK          (0xF00U)
#define DMA_CHANNEL_CFG_BURSTPOWER_SHIFT         (8U)
/*! BURSTPOWER - Burst Power is used in two ways. It always selects the address wrap size when
 *    SRCBURSTWRAP and/or DSTBURSTWRAP modes are selected (see descriptions elsewhere in this register).
 *    When the TRIGBURST field elsewhere in this register = 1, Burst Power selects how many
 *    transfers are performed for each DMA trigger. This can be used, for example, with peripherals that
 *    contain a FIFO that can initiate a DMA operation when the FIFO reaches a certain level. 0000:
 *    Burst size = 1 (20). 0001: Burst size = 2 (21). 0010: Burst size = 4 (22). 1010: Burst size =
 *    1024 (210). This corresponds to the maximum supported transfer count. others: not supported. The
 *    total transfer length as defined in the XFERCOUNT bits in the XFERCFG register must be an even
 *    multiple of the burst size.
 */
#define DMA_CHANNEL_CFG_BURSTPOWER(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_BURSTPOWER_SHIFT)) & DMA_CHANNEL_CFG_BURSTPOWER_MASK)
#define DMA_CHANNEL_CFG_SRCBURSTWRAP_MASK        (0x4000U)
#define DMA_CHANNEL_CFG_SRCBURSTWRAP_SHIFT       (14U)
/*! SRCBURSTWRAP - Source Burst Wrap. When enabled, the source data address for the DMA is
 *    'wrapped', meaning that the source address range for each burst will be the same. As an example, this
 *    could be used to read several sequential registers from a peripheral for each DMA burst,
 *    reading the same registers again for each burst.
 *  0b0..Disabled. Source burst wrapping is not enabled for this DMA channel.
 *  0b1..Enabled. Source burst wrapping is enabled for this DMA channel.
 */
#define DMA_CHANNEL_CFG_SRCBURSTWRAP(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_SRCBURSTWRAP_SHIFT)) & DMA_CHANNEL_CFG_SRCBURSTWRAP_MASK)
#define DMA_CHANNEL_CFG_DSTBURSTWRAP_MASK        (0x8000U)
#define DMA_CHANNEL_CFG_DSTBURSTWRAP_SHIFT       (15U)
/*! DSTBURSTWRAP - Destination Burst Wrap. When enabled, the destination data address for the DMA is
 *    'wrapped', meaning that the destination address range for each burst will be the same. As an
 *    example, this could be used to write several sequential registers to a peripheral for each DMA
 *    burst, writing the same registers again for each burst.
 *  0b0..Disabled. Destination burst wrapping is not enabled for this DMA channel.
 *  0b1..Enabled. Destination burst wrapping is enabled for this DMA channel.
 */
#define DMA_CHANNEL_CFG_DSTBURSTWRAP(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_DSTBURSTWRAP_SHIFT)) & DMA_CHANNEL_CFG_DSTBURSTWRAP_MASK)
#define DMA_CHANNEL_CFG_CHPRIORITY_MASK          (0x70000U)
#define DMA_CHANNEL_CFG_CHPRIORITY_SHIFT         (16U)
/*! CHPRIORITY - Priority of this channel when multiple DMA requests are pending. Eight priority
 *    levels are supported: 0x0 = highest priority. 0x7 = lowest priority.
 */
#define DMA_CHANNEL_CFG_CHPRIORITY(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_CHPRIORITY_SHIFT)) & DMA_CHANNEL_CFG_CHPRIORITY_MASK)
/*! @} */

/* The count of DMA_CHANNEL_CFG */
#define DMA_CHANNEL_CFG_COUNT                    (32U)

/*! @name CHANNEL_CTLSTAT - Control and status register for DMA channel . */
/*! @{ */
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING_MASK    (0x1U)
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING_SHIFT   (0U)
/*! VALIDPENDING - Valid pending flag for this channel. This bit is set when a 1 is written to the
 *    corresponding bit in the related SETVALID register when CFGVALID = 1 for the same channel.
 *  0b0..No effect. No effect on DMA operation.
 *  0b1..Valid pending.
 */
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING(x)      (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CTLSTAT_VALIDPENDING_SHIFT)) & DMA_CHANNEL_CTLSTAT_VALIDPENDING_MASK)
#define DMA_CHANNEL_CTLSTAT_TRIG_MASK            (0x4U)
#define DMA_CHANNEL_CTLSTAT_TRIG_SHIFT           (2U)
/*! TRIG - Trigger flag. Indicates that the trigger for this channel is currently set. This bit is
 *    cleared at the end of an entire transfer or upon reload when CLRTRIG = 1.
 *  0b0..Not triggered. The trigger for this DMA channel is not set. DMA operations will not be carried out.
 *  0b1..Triggered. The trigger for this DMA channel is set. DMA operations will be carried out.
 */
#define DMA_CHANNEL_CTLSTAT_TRIG(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CTLSTAT_TRIG_SHIFT)) & DMA_CHANNEL_CTLSTAT_TRIG_MASK)
/*! @} */

/* The count of DMA_CHANNEL_CTLSTAT */
#define DMA_CHANNEL_CTLSTAT_COUNT                (32U)

/*! @name CHANNEL_XFERCFG - Transfer configuration register for DMA channel . */
/*! @{ */
#define DMA_CHANNEL_XFERCFG_CFGVALID_MASK        (0x1U)
#define DMA_CHANNEL_XFERCFG_CFGVALID_SHIFT       (0U)
/*! CFGVALID - Configuration Valid flag. This bit indicates whether the current channel descriptor
 *    is valid and can potentially be acted upon, if all other activation criteria are fulfilled.
 *  0b0..Not valid. The channel descriptor is not considered valid until validated by an associated SETVALID0 setting.
 *  0b1..Valid. The current channel descriptor is considered valid.
 */
#define DMA_CHANNEL_XFERCFG_CFGVALID(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_CFGVALID_SHIFT)) & DMA_CHANNEL_XFERCFG_CFGVALID_MASK)
#define DMA_CHANNEL_XFERCFG_RELOAD_MASK          (0x2U)
#define DMA_CHANNEL_XFERCFG_RELOAD_SHIFT         (1U)
/*! RELOAD - Indicates whether the channel's control structure will be reloaded when the current
 *    descriptor is exhausted. Reloading allows ping-pong and linked transfers.
 *  0b0..Disabled. Do not reload the channels' control structure when the current descriptor is exhausted.
 *  0b1..Enabled. Reload the channels' control structure when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_RELOAD(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_RELOAD_SHIFT)) & DMA_CHANNEL_XFERCFG_RELOAD_MASK)
#define DMA_CHANNEL_XFERCFG_SWTRIG_MASK          (0x4U)
#define DMA_CHANNEL_XFERCFG_SWTRIG_SHIFT         (2U)
/*! SWTRIG - Software Trigger.
 *  0b0..Not set. When written by software, the trigger for this channel is not set. A new trigger, as defined by
 *       the HWTRIGEN, TRIGPOL, and TRIGTYPE will be needed to start the channel.
 *  0b1..Set. When written by software, the trigger for this channel is set immediately. This feature should not
 *       be used with level triggering when TRIGBURST = 0.
 */
#define DMA_CHANNEL_XFERCFG_SWTRIG(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SWTRIG_SHIFT)) & DMA_CHANNEL_XFERCFG_SWTRIG_MASK)
#define DMA_CHANNEL_XFERCFG_CLRTRIG_MASK         (0x8U)
#define DMA_CHANNEL_XFERCFG_CLRTRIG_SHIFT        (3U)
/*! CLRTRIG - Clear Trigger.
 *  0b0..Not cleared. The trigger is not cleared when this descriptor is exhausted. If there is a reload, the next descriptor will be started.
 *  0b1..Cleared. The trigger is cleared when this descriptor is exhausted
 */
#define DMA_CHANNEL_XFERCFG_CLRTRIG(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_CLRTRIG_SHIFT)) & DMA_CHANNEL_XFERCFG_CLRTRIG_MASK)
#define DMA_CHANNEL_XFERCFG_SETINTA_MASK         (0x10U)
#define DMA_CHANNEL_XFERCFG_SETINTA_SHIFT        (4U)
/*! SETINTA - Set Interrupt flag A for this channel. There is no hardware distinction between
 *    interrupt A and B. They can be used by software to assist with more complex descriptor usage. By
 *    convention, interrupt A may be used when only one interrupt flag is needed.
 *  0b0..No effect.
 *  0b1..Set. The INTA flag for this channel will be set when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_SETINTA(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SETINTA_SHIFT)) & DMA_CHANNEL_XFERCFG_SETINTA_MASK)
#define DMA_CHANNEL_XFERCFG_SETINTB_MASK         (0x20U)
#define DMA_CHANNEL_XFERCFG_SETINTB_SHIFT        (5U)
/*! SETINTB - Set Interrupt flag B for this channel. There is no hardware distinction between
 *    interrupt A and B. They can be used by software to assist with more complex descriptor usage. By
 *    convention, interrupt A may be used when only one interrupt flag is needed.
 *  0b0..No effect.
 *  0b1..Set. The INTB flag for this channel will be set when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_SETINTB(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SETINTB_SHIFT)) & DMA_CHANNEL_XFERCFG_SETINTB_MASK)
#define DMA_CHANNEL_XFERCFG_WIDTH_MASK           (0x300U)
#define DMA_CHANNEL_XFERCFG_WIDTH_SHIFT          (8U)
/*! WIDTH - Transfer width used for this DMA channel.
 *  0b00..8-bit. 8-bit transfers are performed (8-bit source reads and destination writes).
 *  0b01..16-bit. 6-bit transfers are performed (16-bit source reads and destination writes).
 *  0b10..32-bit. 32-bit transfers are performed (32-bit source reads and destination writes).
 *  0b11..Reserved. Reserved setting, do not use.
 */
#define DMA_CHANNEL_XFERCFG_WIDTH(x)             (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_WIDTH_SHIFT)) & DMA_CHANNEL_XFERCFG_WIDTH_MASK)
#define DMA_CHANNEL_XFERCFG_SRCINC_MASK          (0x3000U)
#define DMA_CHANNEL_XFERCFG_SRCINC_SHIFT         (12U)
/*! SRCINC - Determines whether the source address is incremented for each DMA transfer.
 *  0b00..No increment. The source address is not incremented for each transfer. This is the usual case when the source is a peripheral device.
 *  0b01..1 x width. The source address is incremented by the amount specified by Width for each transfer. This is
 *        the usual case when the source is memory.
 *  0b10..2 x width. The source address is incremented by 2 times the amount specified by Width for each transfer.
 *  0b11..4 x width. The source address is incremented by 4 times the amount specified by Width for each transfer.
 */
#define DMA_CHANNEL_XFERCFG_SRCINC(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SRCINC_SHIFT)) & DMA_CHANNEL_XFERCFG_SRCINC_MASK)
#define DMA_CHANNEL_XFERCFG_DSTINC_MASK          (0xC000U)
#define DMA_CHANNEL_XFERCFG_DSTINC_SHIFT         (14U)
/*! DSTINC - Determines whether the destination address is incremented for each DMA transfer.
 *  0b00..No increment. The destination address is not incremented for each transfer. This is the usual case when
 *        the destination is a peripheral device.
 *  0b01..1 x width. The destination address is incremented by the amount specified by Width for each transfer.
 *        This is the usual case when the destination is memory.
 *  0b10..2 x width. The destination address is incremented by 2 times the amount specified by Width for each transfer.
 *  0b11..4 x width. The destination address is incremented by 4 times the amount specified by Width for each transfer.
 */
#define DMA_CHANNEL_XFERCFG_DSTINC(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_DSTINC_SHIFT)) & DMA_CHANNEL_XFERCFG_DSTINC_MASK)
#define DMA_CHANNEL_XFERCFG_XFERCOUNT_MASK       (0x3FF0000U)
#define DMA_CHANNEL_XFERCFG_XFERCOUNT_SHIFT      (16U)
/*! XFERCOUNT - Total number of transfers to be performed, minus 1 encoded. The number of bytes
 *    transferred is: (XFERCOUNT + 1) x data width (as defined by the WIDTH field). The DMA controller
 *    uses this bit field during transfer to count down. Hence, it cannot be used by software to read
 *    back the size of the transfer, for instance, in an interrupt handler. 0x0 = a total of 1
 *    transfer will be performed. 0x1 = a total of 2 transfers will be performed. 0x3FF = a total of
 *    1,024 transfers will be performed.
 */
#define DMA_CHANNEL_XFERCFG_XFERCOUNT(x)         (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_XFERCOUNT_SHIFT)) & DMA_CHANNEL_XFERCFG_XFERCOUNT_MASK)
/*! @} */

/* The count of DMA_CHANNEL_XFERCFG */
#define DMA_CHANNEL_XFERCFG_COUNT                (32U)


/*!
 * @}
 */ /* end of group DMA_Register_Masks */


/* DMA - Peripheral instance base addresses */
/** Peripheral DMA0 base address */
#define DMA0_BASE                                (0x40082000u)
/** Peripheral DMA0 base pointer */
#define DMA0                                     ((DMA_Type *)DMA0_BASE)
/** Array initializer of DMA peripheral base addresses */
#define DMA_BASE_ADDRS                           { DMA0_BASE }
/** Array initializer of DMA peripheral base pointers */
#define DMA_BASE_PTRS                            { DMA0 }
/** Interrupt vectors for the DMA peripheral type */
#define DMA_IRQS                                 { DMA0_IRQn }

/*!
 * @}
 */ /* end of group DMA_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMIC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMIC_Peripheral_Access_Layer DMIC Peripheral Access Layer
 * @{
 */

/** DMIC - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x100 */
    __IO uint32_t OSR;                               /**< Oversample Rate register 0, array offset: 0x0, array step: 0x100 */
    __IO uint32_t DIVHFCLK;                          /**< DMIC Clock Register 0, array offset: 0x4, array step: 0x100 */
    __IO uint32_t PREAC2FSCOEF;                      /**< Pre-Emphasis Filter Coefficient for 2 FS register, array offset: 0x8, array step: 0x100 */
    __IO uint32_t PREAC4FSCOEF;                      /**< Pre-Emphasis Filter Coefficient for 4 FS register, array offset: 0xC, array step: 0x100 */
    __IO uint32_t GAINSHIFT;                         /**< Decimator Gain Shift register, array offset: 0x10, array step: 0x100 */
         uint8_t RESERVED_0[108];
    __IO uint32_t FIFO_CTRL;                         /**< FIFO Control register 0, array offset: 0x80, array step: 0x100 */
    __IO uint32_t FIFO_STATUS;                       /**< FIFO Status register 0, array offset: 0x84, array step: 0x100 */
    __IO uint32_t FIFO_DATA;                         /**< FIFO Data Register 0, array offset: 0x88, array step: 0x100 */
    __IO uint32_t PHY_CTRL;                          /**< PDM Source Configuration register 0, array offset: 0x8C, array step: 0x100 */
    __IO uint32_t DC_CTRL;                           /**< DC Control register 0, array offset: 0x90, array step: 0x100 */
         uint8_t RESERVED_1[108];
  } CHANNEL[2];
       uint8_t RESERVED_0[3328];
  __IO uint32_t CHANEN;                            /**< Channel Enable register, offset: 0xF00 */
       uint8_t RESERVED_1[8];
  __IO uint32_t IOCFG;                             /**< I/O Configuration register, offset: 0xF0C */
  __IO uint32_t USE2FS;                            /**< Use 2FS register, offset: 0xF10 */
       uint8_t RESERVED_2[108];
  __IO uint32_t HWVADGAIN;                         /**< HWVAD input gain register, offset: 0xF80 */
  __IO uint32_t HWVADHPFS;                         /**< HWVAD filter control register, offset: 0xF84 */
  __IO uint32_t HWVADST10;                         /**< HWVAD control register, offset: 0xF88 */
  __IO uint32_t HWVADRSTT;                         /**< HWVAD filter reset register, offset: 0xF8C */
  __IO uint32_t HWVADTHGN;                         /**< HWVAD noise estimator gain register, offset: 0xF90 */
  __IO uint32_t HWVADTHGS;                         /**< HWVAD signal estimator gain register, offset: 0xF94 */
  __I  uint32_t HWVADLOWZ;                         /**< HWVAD noise envelope estimator register, offset: 0xF98 */
       uint8_t RESERVED_3[96];
  __I  uint32_t ID;                                /**< Module Identification register, offset: 0xFFC */
} DMIC_Type;

/* ----------------------------------------------------------------------------
   -- DMIC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMIC_Register_Masks DMIC Register Masks
 * @{
 */

/*! @name CHANNEL_OSR - Oversample Rate register 0 */
/*! @{ */
#define DMIC_CHANNEL_OSR_OSR_MASK                (0xFFU)
#define DMIC_CHANNEL_OSR_OSR_SHIFT               (0U)
/*! OSR - Selects the oversample rate for the related input channel.
 */
#define DMIC_CHANNEL_OSR_OSR(x)                  (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_OSR_OSR_SHIFT)) & DMIC_CHANNEL_OSR_OSR_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_OSR */
#define DMIC_CHANNEL_OSR_COUNT                   (2U)

/*! @name CHANNEL_DIVHFCLK - DMIC Clock Register 0 */
/*! @{ */
#define DMIC_CHANNEL_DIVHFCLK_PDMDIV_MASK        (0xFU)
#define DMIC_CHANNEL_DIVHFCLK_PDMDIV_SHIFT       (0U)
/*! PDMDIV - PDM clock divider value. 0 = divide by 1 1 = divide by 2 2 = divide by 3 3 = divide by
 *    4 4 = divide by 6 5 = divide by 8 6 = divide by 12 7 = divide by 16 8 = divide by 24 9 =
 *    divide by 32 10 = divide by 48 11 = divide by 64 12 = divide by 96 13 = divide by 128 others =
 *    reserved.
 */
#define DMIC_CHANNEL_DIVHFCLK_PDMDIV(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DIVHFCLK_PDMDIV_SHIFT)) & DMIC_CHANNEL_DIVHFCLK_PDMDIV_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_DIVHFCLK */
#define DMIC_CHANNEL_DIVHFCLK_COUNT              (2U)

/*! @name CHANNEL_PREAC2FSCOEF - Pre-Emphasis Filter Coefficient for 2 FS register */
/*! @{ */
#define DMIC_CHANNEL_PREAC2FSCOEF_COMP_MASK      (0x3U)
#define DMIC_CHANNEL_PREAC2FSCOEF_COMP_SHIFT     (0U)
/*! COMP - Pre-emphasis filer coefficient for 2 FS mode. 0 = Compensation = 0 1 = Compensation = 16
 *    2 = Compensation = 15 3 = Compensation = 13
 */
#define DMIC_CHANNEL_PREAC2FSCOEF_COMP(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PREAC2FSCOEF_COMP_SHIFT)) & DMIC_CHANNEL_PREAC2FSCOEF_COMP_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PREAC2FSCOEF */
#define DMIC_CHANNEL_PREAC2FSCOEF_COUNT          (2U)

/*! @name CHANNEL_PREAC4FSCOEF - Pre-Emphasis Filter Coefficient for 4 FS register */
/*! @{ */
#define DMIC_CHANNEL_PREAC4FSCOEF_COMP_MASK      (0x3U)
#define DMIC_CHANNEL_PREAC4FSCOEF_COMP_SHIFT     (0U)
/*! COMP - Pre-emphasis filer coefficient for 4 FS mode. 0 = Compensation = 0 1 = Compensation = 16
 *    2 = Compensation = 15 3 = Compensation = 13
 */
#define DMIC_CHANNEL_PREAC4FSCOEF_COMP(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PREAC4FSCOEF_COMP_SHIFT)) & DMIC_CHANNEL_PREAC4FSCOEF_COMP_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PREAC4FSCOEF */
#define DMIC_CHANNEL_PREAC4FSCOEF_COUNT          (2U)

/*! @name CHANNEL_GAINSHIFT - Decimator Gain Shift register */
/*! @{ */
#define DMIC_CHANNEL_GAINSHIFT_GAIN_MASK         (0x3FU)
#define DMIC_CHANNEL_GAINSHIFT_GAIN_SHIFT        (0U)
/*! GAIN - Gain control, as a positive or negative (two's complement) number of bits to shift.
 */
#define DMIC_CHANNEL_GAINSHIFT_GAIN(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_GAINSHIFT_GAIN_SHIFT)) & DMIC_CHANNEL_GAINSHIFT_GAIN_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_GAINSHIFT */
#define DMIC_CHANNEL_GAINSHIFT_COUNT             (2U)

/*! @name CHANNEL_FIFO_CTRL - FIFO Control register 0 */
/*! @{ */
#define DMIC_CHANNEL_FIFO_CTRL_ENABLE_MASK       (0x1U)
#define DMIC_CHANNEL_FIFO_CTRL_ENABLE_SHIFT      (0U)
/*! ENABLE - FIFO enable.
 *  0b0..FIFO is not enabled. Enabling a DMIC channel with the FIFO disabled could be useful while data is being
 *       streamed to the I2S, or in order to avoid a filter settling delay when a channel is re-enabled after a
 *       period when the data was not needed.
 *  0b1..FIFO is enabled. The FIFO must be enabled in order for the CPU or DMA to read data from the DMIC via the FIFODATA register.
 */
#define DMIC_CHANNEL_FIFO_CTRL_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_ENABLE_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_ENABLE_MASK)
#define DMIC_CHANNEL_FIFO_CTRL_RESETN_MASK       (0x2U)
#define DMIC_CHANNEL_FIFO_CTRL_RESETN_SHIFT      (1U)
/*! RESETN - FIFO reset.
 *  0b0..Reset the FIFO.
 *  0b1..Normal operation
 */
#define DMIC_CHANNEL_FIFO_CTRL_RESETN(x)         (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_RESETN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_RESETN_MASK)
#define DMIC_CHANNEL_FIFO_CTRL_INTEN_MASK        (0x4U)
#define DMIC_CHANNEL_FIFO_CTRL_INTEN_SHIFT       (2U)
/*! INTEN - Interrupt enable.
 *  0b0..FIFO level interrupts are not enabled.
 *  0b1..FIFO level interrupts are enabled.
 */
#define DMIC_CHANNEL_FIFO_CTRL_INTEN(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_INTEN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_INTEN_MASK)
#define DMIC_CHANNEL_FIFO_CTRL_DMAEN_MASK        (0x8U)
#define DMIC_CHANNEL_FIFO_CTRL_DMAEN_SHIFT       (3U)
/*! DMAEN - DMA enable
 *  0b0..DMA requests are not enabled.
 *  0b1..DMA requests based on FIFO level are enabled.
 */
#define DMIC_CHANNEL_FIFO_CTRL_DMAEN(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_DMAEN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_DMAEN_MASK)
#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_MASK      (0x1F0000U)
#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_SHIFT     (16U)
/*! TRIGLVL - FIFO trigger level. Selects the data trigger level for interrupt or DMA operation. If
 *    enabled to do so, the FIFO level can wake up the device just enough to perform DMA, then
 *    return to the reduced power mode See Section 4.5.66 'Hardware Wake-up control register'. 0 =
 *    trigger when the FIFO has received one entry (is no longer empty). 1 = trigger when the FIFO has
 *    received two entries. 15 = trigger when the FIFO has received 16 entries (has become full).
 */
#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_CTRL */
#define DMIC_CHANNEL_FIFO_CTRL_COUNT             (2U)

/*! @name CHANNEL_FIFO_STATUS - FIFO Status register 0 */
/*! @{ */
#define DMIC_CHANNEL_FIFO_STATUS_INT_MASK        (0x1U)
#define DMIC_CHANNEL_FIFO_STATUS_INT_SHIFT       (0U)
/*! INT - Interrupt flag. Asserted when FIFO data reaches the level specified in the FIFOCTRL
 *    register. Writing a one to this bit clears the flag. Remark: note that the bus clock to the DMIC
 *    subsystem must be running in order for an interrupt to occur.
 */
#define DMIC_CHANNEL_FIFO_STATUS_INT(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_INT_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_INT_MASK)
#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN_MASK    (0x2U)
#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN_SHIFT   (1U)
/*! OVERRUN - Overrun flag. Indicates that a FIFO overflow has occurred at some point. Writing a one
 *    to this bit clears the flag. This flag does not cause an interrupt.
 */
#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN(x)      (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_OVERRUN_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_OVERRUN_MASK)
#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_MASK   (0x4U)
#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_SHIFT  (2U)
/*! UNDERRUN - Underrun flag. Indicates that a FIFO underflow has occurred at some point. Writing a one to this bit clears the flag.
 */
#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN(x)     (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_STATUS */
#define DMIC_CHANNEL_FIFO_STATUS_COUNT           (2U)

/*! @name CHANNEL_FIFO_DATA - FIFO Data Register 0 */
/*! @{ */
#define DMIC_CHANNEL_FIFO_DATA_DATA_MASK         (0xFFFFFFU)
#define DMIC_CHANNEL_FIFO_DATA_DATA_SHIFT        (0U)
/*! DATA - Data from the top of the input filter FIFO.
 */
#define DMIC_CHANNEL_FIFO_DATA_DATA(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_DATA_DATA_SHIFT)) & DMIC_CHANNEL_FIFO_DATA_DATA_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_DATA */
#define DMIC_CHANNEL_FIFO_DATA_COUNT             (2U)

/*! @name CHANNEL_PHY_CTRL - PDM Source Configuration register 0 */
/*! @{ */
#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL_MASK      (0x1U)
#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL_SHIFT     (0U)
/*! PHY_FALL - Capture PDM_DATA
 *  0b0..Capture PDM_DATA on the rising edge of PDM_CLK.
 *  0b1..Capture PDM_DATA on the falling edge of PDM_CLK.
 */
#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PHY_CTRL_PHY_FALL_SHIFT)) & DMIC_CHANNEL_PHY_CTRL_PHY_FALL_MASK)
#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF_MASK      (0x2U)
#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF_SHIFT     (1U)
/*! PHY_HALF - Half rate sampling
 *  0b0..Standard half rate sampling. The clock to the DMIC is sent at the same rate as the decimator is providing.
 *  0b1..Use half rate sampling. The clock to the DMIC is sent at half the rate as the decimator is providing.
 */
#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PHY_CTRL_PHY_HALF_SHIFT)) & DMIC_CHANNEL_PHY_CTRL_PHY_HALF_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PHY_CTRL */
#define DMIC_CHANNEL_PHY_CTRL_COUNT              (2U)

/*! @name CHANNEL_DC_CTRL - DC Control register 0 */
/*! @{ */
#define DMIC_CHANNEL_DC_CTRL_DCPOLE_MASK         (0x3U)
#define DMIC_CHANNEL_DC_CTRL_DCPOLE_SHIFT        (0U)
/*! DCPOLE - DC block filter
 *  0b00..Flat response, no filter.
 *  0b01..155 Hz.
 *  0b10..78 Hz.
 *  0b11..39 Hz
 */
#define DMIC_CHANNEL_DC_CTRL_DCPOLE(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_DCPOLE_SHIFT)) & DMIC_CHANNEL_DC_CTRL_DCPOLE_MASK)
#define DMIC_CHANNEL_DC_CTRL_DCGAIN_MASK         (0xF0U)
#define DMIC_CHANNEL_DC_CTRL_DCGAIN_SHIFT        (4U)
/*! DCGAIN - Fine gain adjustment in the form of a number of bits to downshift.
 */
#define DMIC_CHANNEL_DC_CTRL_DCGAIN(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_DCGAIN_SHIFT)) & DMIC_CHANNEL_DC_CTRL_DCGAIN_MASK)
#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_MASK (0x100U)
#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_SHIFT (8U)
/*! SATURATEAT16BIT - Selects 16-bit saturation.
 *  0b0..Results roll over if out range and do not saturate.
 *  0b1..If the result overflows, it saturates at 0xFFFF for positive overflow and 0x8000 for negative overflow.
 */
#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT(x)  (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_SHIFT)) & DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_DC_CTRL */
#define DMIC_CHANNEL_DC_CTRL_COUNT               (2U)

/*! @name CHANEN - Channel Enable register */
/*! @{ */
#define DMIC_CHANEN_EN_CH0_MASK                  (0x1U)
#define DMIC_CHANEN_EN_CH0_SHIFT                 (0U)
/*! EN_CH0 - Enable channel 0. When 1, PDM channel 0 is enabled.
 */
#define DMIC_CHANEN_EN_CH0(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH0_SHIFT)) & DMIC_CHANEN_EN_CH0_MASK)
#define DMIC_CHANEN_EN_CH1_MASK                  (0x2U)
#define DMIC_CHANEN_EN_CH1_SHIFT                 (1U)
/*! EN_CH1 - Enable channel 1. When 1, PDM channel 1 is enabled.
 */
#define DMIC_CHANEN_EN_CH1(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH1_SHIFT)) & DMIC_CHANEN_EN_CH1_MASK)
/*! @} */

/*! @name IOCFG - I/O Configuration register */
/*! @{ */
#define DMIC_IOCFG_CLK_BYPASS0_MASK              (0x1U)
#define DMIC_IOCFG_CLK_BYPASS0_SHIFT             (0U)
/*! CLK_BYPASS0 - Bypass CLK0. When 1, PDM_DATA1 becomes the clock for PDM channel 0. This provides
 *    for the possibility of an external codec taking over the PDM bus.
 */
#define DMIC_IOCFG_CLK_BYPASS0(x)                (((uint32_t)(((uint32_t)(x)) << DMIC_IOCFG_CLK_BYPASS0_SHIFT)) & DMIC_IOCFG_CLK_BYPASS0_MASK)
#define DMIC_IOCFG_CLK_BYPASS1_MASK              (0x2U)
#define DMIC_IOCFG_CLK_BYPASS1_SHIFT             (1U)
/*! CLK_BYPASS1 - Bypass CLK1. When 1, PDM_DATA1 becomes the clock for PDM channel 1. This provides
 *    for the possibility of an external codec taking over the PDM bus.
 */
#define DMIC_IOCFG_CLK_BYPASS1(x)                (((uint32_t)(((uint32_t)(x)) << DMIC_IOCFG_CLK_BYPASS1_SHIFT)) & DMIC_IOCFG_CLK_BYPASS1_MASK)
#define DMIC_IOCFG_STEREO_DATA0_MASK             (0x4U)
#define DMIC_IOCFG_STEREO_DATA0_SHIFT            (2U)
/*! STEREO_DATA0 - Stereo PDM select. When 1, PDM_DATA0 is routed to both PDM channels in a
 *    configuration that supports a single stereo digital microphone.
 */
#define DMIC_IOCFG_STEREO_DATA0(x)               (((uint32_t)(((uint32_t)(x)) << DMIC_IOCFG_STEREO_DATA0_SHIFT)) & DMIC_IOCFG_STEREO_DATA0_MASK)
/*! @} */

/*! @name USE2FS - Use 2FS register */
/*! @{ */
#define DMIC_USE2FS_USE2FS_MASK                  (0x1U)
#define DMIC_USE2FS_USE2FS_SHIFT                 (0U)
/*! USE2FS - Use 2FS register
 *  0b0..Use 1FS output for PCM data.
 *  0b1..Use 2FS output for PCM data.
 */
#define DMIC_USE2FS_USE2FS(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_USE2FS_USE2FS_SHIFT)) & DMIC_USE2FS_USE2FS_MASK)
/*! @} */

/*! @name HWVADGAIN - HWVAD input gain register */
/*! @{ */
#define DMIC_HWVADGAIN_INPUTGAIN_MASK            (0xFU)
#define DMIC_HWVADGAIN_INPUTGAIN_SHIFT           (0U)
/*! INPUTGAIN - Shift value for input bits 0x00 -10 bits 0x01 -8 bits 0x02 -6 bits 0x03 -4 bits 0x04
 *    -2 bits 0x05 0 bits (default) 0x06 +2 bits 0x07 +4 bits 0x08 +6 bits 0x09 +8 bits 0x0A +10
 *    bits 0x0B +12 bits 0x0C +14 bits 0x0D to 0x0F Reserved.
 */
#define DMIC_HWVADGAIN_INPUTGAIN(x)              (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADGAIN_INPUTGAIN_SHIFT)) & DMIC_HWVADGAIN_INPUTGAIN_MASK)
/*! @} */

/*! @name HWVADHPFS - HWVAD filter control register */
/*! @{ */
#define DMIC_HWVADHPFS_HPFS_MASK                 (0x3U)
#define DMIC_HWVADHPFS_HPFS_SHIFT                (0U)
/*! HPFS - High pass filter
 *  0b00..First filter by-pass.
 *  0b01..High pass filter with -3dB cut-off at 1750Hz.
 *  0b10..High pass filter with -3dB cut-off at 215Hz.
 *  0b11..Reserved.
 */
#define DMIC_HWVADHPFS_HPFS(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADHPFS_HPFS_SHIFT)) & DMIC_HWVADHPFS_HPFS_MASK)
/*! @} */

/*! @name HWVADST10 - HWVAD control register */
/*! @{ */
#define DMIC_HWVADST10_ST10_MASK                 (0x1U)
#define DMIC_HWVADST10_ST10_SHIFT                (0U)
/*! ST10 - Stage 0
 *  0b0..Normal operation, waiting for HWVAD trigger event (stage 0).
 *  0b1..Reset internal interrupt flag by writing a '1' pulse.
 */
#define DMIC_HWVADST10_ST10(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADST10_ST10_SHIFT)) & DMIC_HWVADST10_ST10_MASK)
/*! @} */

/*! @name HWVADRSTT - HWVAD filter reset register */
/*! @{ */
#define DMIC_HWVADRSTT_RSTT_MASK                 (0x1U)
#define DMIC_HWVADRSTT_RSTT_SHIFT                (0U)
/*! RSTT - Writing a 1 resets all filter values
 */
#define DMIC_HWVADRSTT_RSTT(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADRSTT_RSTT_SHIFT)) & DMIC_HWVADRSTT_RSTT_MASK)
/*! @} */

/*! @name HWVADTHGN - HWVAD noise estimator gain register */
/*! @{ */
#define DMIC_HWVADTHGN_THGN_MASK                 (0xFU)
#define DMIC_HWVADTHGN_THGN_SHIFT                (0U)
/*! THGN - Gain value for the noise estimator. Values 0 to 14. 0 corresponds to a gain of 1.
 */
#define DMIC_HWVADTHGN_THGN(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADTHGN_THGN_SHIFT)) & DMIC_HWVADTHGN_THGN_MASK)
/*! @} */

/*! @name HWVADTHGS - HWVAD signal estimator gain register */
/*! @{ */
#define DMIC_HWVADTHGS_THGS_MASK                 (0xFU)
#define DMIC_HWVADTHGS_THGS_SHIFT                (0U)
/*! THGS - Gain value for the signal estimator. Values 0 to 14. 0 corresponds to a gain of 1.
 */
#define DMIC_HWVADTHGS_THGS(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADTHGS_THGS_SHIFT)) & DMIC_HWVADTHGS_THGS_MASK)
/*! @} */

/*! @name HWVADLOWZ - HWVAD noise envelope estimator register */
/*! @{ */
#define DMIC_HWVADLOWZ_LOWZ_MASK                 (0xFFFFU)
#define DMIC_HWVADLOWZ_LOWZ_SHIFT                (0U)
/*! LOWZ - Noise envelope estimator value.
 */
#define DMIC_HWVADLOWZ_LOWZ(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADLOWZ_LOWZ_SHIFT)) & DMIC_HWVADLOWZ_LOWZ_MASK)
/*! @} */

/*! @name ID - Module Identification register */
/*! @{ */
#define DMIC_ID_ID_MASK                          (0xFFFFFFFFU)
#define DMIC_ID_ID_SHIFT                         (0U)
/*! ID - Indicates module ID and the number of channels in this DMIC interface.
 */
#define DMIC_ID_ID(x)                            (((uint32_t)(((uint32_t)(x)) << DMIC_ID_ID_SHIFT)) & DMIC_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group DMIC_Register_Masks */


/* DMIC - Peripheral instance base addresses */
/** Peripheral DMIC0 base address */
#define DMIC0_BASE                               (0x40090000u)
/** Peripheral DMIC0 base pointer */
#define DMIC0                                    ((DMIC_Type *)DMIC0_BASE)
/** Array initializer of DMIC peripheral base addresses */
#define DMIC_BASE_ADDRS                          { DMIC0_BASE }
/** Array initializer of DMIC peripheral base pointers */
#define DMIC_BASE_PTRS                           { DMIC0 }
/** Interrupt vectors for the DMIC peripheral type */
#define DMIC_IRQS                                { DMIC0_IRQn }
#define DMIC_HWVAD_IRQS                          { HWVAD0_IRQn }

/*!
 * @}
 */ /* end of group DMIC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- EMC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EMC_Peripheral_Access_Layer EMC Peripheral Access Layer
 * @{
 */

/** EMC - Register Layout Typedef */
typedef struct {
  __IO uint32_t CONTROL;                           /**< Controls operation of the memory controller, offset: 0x0 */
  __I  uint32_t STATUS;                            /**< Provides EMC status information, offset: 0x4 */
  __IO uint32_t CONFIG;                            /**< Configures operation of the memory controller, offset: 0x8 */
       uint8_t RESERVED_0[20];
  __IO uint32_t DYNAMICCONTROL;                    /**< Controls dynamic memory operation, offset: 0x20 */
  __IO uint32_t DYNAMICREFRESH;                    /**< Configures dynamic memory refresh, offset: 0x24 */
  __IO uint32_t DYNAMICREADCONFIG;                 /**< Configures dynamic memory read strategy, offset: 0x28 */
       uint8_t RESERVED_1[4];
  __IO uint32_t DYNAMICRP;                         /**< Precharge command period, offset: 0x30 */
  __IO uint32_t DYNAMICRAS;                        /**< Active to precharge command period, offset: 0x34 */
  __IO uint32_t DYNAMICSREX;                       /**< Self-refresh exit time, offset: 0x38 */
  __IO uint32_t DYNAMICAPR;                        /**< Last-data-out to active command time, offset: 0x3C */
  __IO uint32_t DYNAMICDAL;                        /**< Data-in to active command time, offset: 0x40 */
  __IO uint32_t DYNAMICWR;                         /**< Write recovery time, offset: 0x44 */
  __IO uint32_t DYNAMICRC;                         /**< Selects the active to active command period, offset: 0x48 */
  __IO uint32_t DYNAMICRFC;                        /**< Selects the auto-refresh period, offset: 0x4C */
  __IO uint32_t DYNAMICXSR;                        /**< Time for exit self-refresh to active command, offset: 0x50 */
  __IO uint32_t DYNAMICRRD;                        /**< Latency for active bank A to active bank B, offset: 0x54 */
  __IO uint32_t DYNAMICMRD;                        /**< Time for load mode register to active command, offset: 0x58 */
       uint8_t RESERVED_2[36];
  __IO uint32_t STATICEXTENDEDWAIT;                /**< Time for long static memory read and write transfers, offset: 0x80 */
       uint8_t RESERVED_3[124];
  struct {                                         /* offset: 0x100, array step: 0x20 */
    __IO uint32_t DYNAMICCONFIG;                     /**< Configuration information for EMC_DYCSx, array offset: 0x100, array step: 0x20 */
    __IO uint32_t DYNAMICRASCAS;                     /**< RAS and CAS latencies for EMC_DYCSx, array offset: 0x104, array step: 0x20 */
         uint8_t RESERVED_0[24];
  } DYNAMIC[4];
       uint8_t RESERVED_4[128];
  struct {                                         /* offset: 0x200, array step: 0x20 */
    __IO uint32_t STATICCONFIG;                      /**< Configuration for EMC_CSx, array offset: 0x200, array step: 0x20 */
    __IO uint32_t STATICWAITWEN;                     /**< Delay from EMC_CSx to write enable, array offset: 0x204, array step: 0x20 */
    __IO uint32_t STATICWAITOEN;                     /**< Delay from EMC_CSx or address change, whichever is later, to output enable, array offset: 0x208, array step: 0x20 */
    __IO uint32_t STATICWAITRD;                      /**< Delay from EMC_CSx to a read access, array offset: 0x20C, array step: 0x20 */
    __IO uint32_t STATICWAITPAGE;                    /**< Delay for asynchronous page mode sequential accesses for EMC_CSx, array offset: 0x210, array step: 0x20 */
    __IO uint32_t STATICWAITWR;                      /**< Delay from EMC_CSx to a write access, array offset: 0x214, array step: 0x20 */
    __IO uint32_t STATICWAITTURN;                    /**< Number of bus turnaround cycles EMC_CSx, array offset: 0x218, array step: 0x20 */
         uint8_t RESERVED_0[4];
  } STATIC[4];
} EMC_Type;

/* ----------------------------------------------------------------------------
   -- EMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EMC_Register_Masks EMC Register Masks
 * @{
 */

/*! @name CONTROL - Controls operation of the memory controller */
/*! @{ */
#define EMC_CONTROL_E_MASK                       (0x1U)
#define EMC_CONTROL_E_SHIFT                      (0U)
/*! E - EMC Enable.
 */
#define EMC_CONTROL_E(x)                         (((uint32_t)(((uint32_t)(x)) << EMC_CONTROL_E_SHIFT)) & EMC_CONTROL_E_MASK)
#define EMC_CONTROL_M_MASK                       (0x2U)
#define EMC_CONTROL_M_SHIFT                      (1U)
/*! M - Address mirror.
 */
#define EMC_CONTROL_M(x)                         (((uint32_t)(((uint32_t)(x)) << EMC_CONTROL_M_SHIFT)) & EMC_CONTROL_M_MASK)
#define EMC_CONTROL_L_MASK                       (0x4U)
#define EMC_CONTROL_L_SHIFT                      (2U)
/*! L - Low-power mode.
 */
#define EMC_CONTROL_L(x)                         (((uint32_t)(((uint32_t)(x)) << EMC_CONTROL_L_SHIFT)) & EMC_CONTROL_L_MASK)
/*! @} */

/*! @name STATUS - Provides EMC status information */
/*! @{ */
#define EMC_STATUS_B_MASK                        (0x1U)
#define EMC_STATUS_B_SHIFT                       (0U)
/*! B - Busy.
 */
#define EMC_STATUS_B(x)                          (((uint32_t)(((uint32_t)(x)) << EMC_STATUS_B_SHIFT)) & EMC_STATUS_B_MASK)
#define EMC_STATUS_S_MASK                        (0x2U)
#define EMC_STATUS_S_SHIFT                       (1U)
/*! S - Write buffer status.
 */
#define EMC_STATUS_S(x)                          (((uint32_t)(((uint32_t)(x)) << EMC_STATUS_S_SHIFT)) & EMC_STATUS_S_MASK)
#define EMC_STATUS_SA_MASK                       (0x4U)
#define EMC_STATUS_SA_SHIFT                      (2U)
/*! SA - Self-refresh acknowledge.
 */
#define EMC_STATUS_SA(x)                         (((uint32_t)(((uint32_t)(x)) << EMC_STATUS_SA_SHIFT)) & EMC_STATUS_SA_MASK)
/*! @} */

/*! @name CONFIG - Configures operation of the memory controller */
/*! @{ */
#define EMC_CONFIG_EM_MASK                       (0x1U)
#define EMC_CONFIG_EM_SHIFT                      (0U)
/*! EM - Endian mode.
 */
#define EMC_CONFIG_EM(x)                         (((uint32_t)(((uint32_t)(x)) << EMC_CONFIG_EM_SHIFT)) & EMC_CONFIG_EM_MASK)
#define EMC_CONFIG_CLKR_MASK                     (0x100U)
#define EMC_CONFIG_CLKR_SHIFT                    (8U)
/*! CLKR - This bit must contain 0 for proper operation of the EMC.
 */
#define EMC_CONFIG_CLKR(x)                       (((uint32_t)(((uint32_t)(x)) << EMC_CONFIG_CLKR_SHIFT)) & EMC_CONFIG_CLKR_MASK)
/*! @} */

/*! @name DYNAMICCONTROL - Controls dynamic memory operation */
/*! @{ */
#define EMC_DYNAMICCONTROL_CE_MASK               (0x1U)
#define EMC_DYNAMICCONTROL_CE_SHIFT              (0U)
/*! CE - Dynamic memory clock enable.
 */
#define EMC_DYNAMICCONTROL_CE(x)                 (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICCONTROL_CE_SHIFT)) & EMC_DYNAMICCONTROL_CE_MASK)
#define EMC_DYNAMICCONTROL_CS_MASK               (0x2U)
#define EMC_DYNAMICCONTROL_CS_SHIFT              (1U)
/*! CS - Dynamic memory clock control.
 */
#define EMC_DYNAMICCONTROL_CS(x)                 (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICCONTROL_CS_SHIFT)) & EMC_DYNAMICCONTROL_CS_MASK)
#define EMC_DYNAMICCONTROL_SR_MASK               (0x4U)
#define EMC_DYNAMICCONTROL_SR_SHIFT              (2U)
/*! SR - Self-refresh request, EMCSREFREQ.
 */
#define EMC_DYNAMICCONTROL_SR(x)                 (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICCONTROL_SR_SHIFT)) & EMC_DYNAMICCONTROL_SR_MASK)
#define EMC_DYNAMICCONTROL_MMC_MASK              (0x20U)
#define EMC_DYNAMICCONTROL_MMC_SHIFT             (5U)
/*! MMC - Memory clock control.
 */
#define EMC_DYNAMICCONTROL_MMC(x)                (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICCONTROL_MMC_SHIFT)) & EMC_DYNAMICCONTROL_MMC_MASK)
#define EMC_DYNAMICCONTROL_I_MASK                (0x180U)
#define EMC_DYNAMICCONTROL_I_SHIFT               (7U)
/*! I - SDRAM initialization.
 */
#define EMC_DYNAMICCONTROL_I(x)                  (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICCONTROL_I_SHIFT)) & EMC_DYNAMICCONTROL_I_MASK)
/*! @} */

/*! @name DYNAMICREFRESH - Configures dynamic memory refresh */
/*! @{ */
#define EMC_DYNAMICREFRESH_REFRESH_MASK          (0x7FFU)
#define EMC_DYNAMICREFRESH_REFRESH_SHIFT         (0U)
/*! REFRESH - Refresh timer.
 */
#define EMC_DYNAMICREFRESH_REFRESH(x)            (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICREFRESH_REFRESH_SHIFT)) & EMC_DYNAMICREFRESH_REFRESH_MASK)
/*! @} */

/*! @name DYNAMICREADCONFIG - Configures dynamic memory read strategy */
/*! @{ */
#define EMC_DYNAMICREADCONFIG_RD_MASK            (0x3U)
#define EMC_DYNAMICREADCONFIG_RD_SHIFT           (0U)
/*! RD - Read data strategy.
 */
#define EMC_DYNAMICREADCONFIG_RD(x)              (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICREADCONFIG_RD_SHIFT)) & EMC_DYNAMICREADCONFIG_RD_MASK)
/*! @} */

/*! @name DYNAMICRP - Precharge command period */
/*! @{ */
#define EMC_DYNAMICRP_TRP_MASK                   (0xFU)
#define EMC_DYNAMICRP_TRP_SHIFT                  (0U)
/*! TRP - Precharge command period.
 */
#define EMC_DYNAMICRP_TRP(x)                     (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICRP_TRP_SHIFT)) & EMC_DYNAMICRP_TRP_MASK)
/*! @} */

/*! @name DYNAMICRAS - Active to precharge command period */
/*! @{ */
#define EMC_DYNAMICRAS_TRAS_MASK                 (0xFU)
#define EMC_DYNAMICRAS_TRAS_SHIFT                (0U)
/*! TRAS - Active to precharge command period.
 */
#define EMC_DYNAMICRAS_TRAS(x)                   (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICRAS_TRAS_SHIFT)) & EMC_DYNAMICRAS_TRAS_MASK)
/*! @} */

/*! @name DYNAMICSREX - Self-refresh exit time */
/*! @{ */
#define EMC_DYNAMICSREX_TSREX_MASK               (0xFU)
#define EMC_DYNAMICSREX_TSREX_SHIFT              (0U)
/*! TSREX - Self-refresh exit time.
 */
#define EMC_DYNAMICSREX_TSREX(x)                 (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICSREX_TSREX_SHIFT)) & EMC_DYNAMICSREX_TSREX_MASK)
/*! @} */

/*! @name DYNAMICAPR - Last-data-out to active command time */
/*! @{ */
#define EMC_DYNAMICAPR_TAPR_MASK                 (0xFU)
#define EMC_DYNAMICAPR_TAPR_SHIFT                (0U)
/*! TAPR - Last-data-out to active command time.
 */
#define EMC_DYNAMICAPR_TAPR(x)                   (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICAPR_TAPR_SHIFT)) & EMC_DYNAMICAPR_TAPR_MASK)
/*! @} */

/*! @name DYNAMICDAL - Data-in to active command time */
/*! @{ */
#define EMC_DYNAMICDAL_TDAL_MASK                 (0xFU)
#define EMC_DYNAMICDAL_TDAL_SHIFT                (0U)
/*! TDAL - Data-in to active command.
 */
#define EMC_DYNAMICDAL_TDAL(x)                   (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICDAL_TDAL_SHIFT)) & EMC_DYNAMICDAL_TDAL_MASK)
/*! @} */

/*! @name DYNAMICWR - Write recovery time */
/*! @{ */
#define EMC_DYNAMICWR_TWR_MASK                   (0xFU)
#define EMC_DYNAMICWR_TWR_SHIFT                  (0U)
/*! TWR - Write recovery time.
 */
#define EMC_DYNAMICWR_TWR(x)                     (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICWR_TWR_SHIFT)) & EMC_DYNAMICWR_TWR_MASK)
/*! @} */

/*! @name DYNAMICRC - Selects the active to active command period */
/*! @{ */
#define EMC_DYNAMICRC_TRC_MASK                   (0x1FU)
#define EMC_DYNAMICRC_TRC_SHIFT                  (0U)
/*! TRC - Active to active command period.
 */
#define EMC_DYNAMICRC_TRC(x)                     (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICRC_TRC_SHIFT)) & EMC_DYNAMICRC_TRC_MASK)
/*! @} */

/*! @name DYNAMICRFC - Selects the auto-refresh period */
/*! @{ */
#define EMC_DYNAMICRFC_TRFC_MASK                 (0x1FU)
#define EMC_DYNAMICRFC_TRFC_SHIFT                (0U)
/*! TRFC - Auto-refresh period and auto-refresh to active command period.
 */
#define EMC_DYNAMICRFC_TRFC(x)                   (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICRFC_TRFC_SHIFT)) & EMC_DYNAMICRFC_TRFC_MASK)
/*! @} */

/*! @name DYNAMICXSR - Time for exit self-refresh to active command */
/*! @{ */
#define EMC_DYNAMICXSR_TXSR_MASK                 (0x1FU)
#define EMC_DYNAMICXSR_TXSR_SHIFT                (0U)
/*! TXSR - Exit self-refresh to active command time.
 */
#define EMC_DYNAMICXSR_TXSR(x)                   (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICXSR_TXSR_SHIFT)) & EMC_DYNAMICXSR_TXSR_MASK)
/*! @} */

/*! @name DYNAMICRRD - Latency for active bank A to active bank B */
/*! @{ */
#define EMC_DYNAMICRRD_TRRD_MASK                 (0xFU)
#define EMC_DYNAMICRRD_TRRD_SHIFT                (0U)
/*! TRRD - Active bank A to active bank B latency 0x0 - 0xE = n + 1 clock cycles.
 */
#define EMC_DYNAMICRRD_TRRD(x)                   (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICRRD_TRRD_SHIFT)) & EMC_DYNAMICRRD_TRRD_MASK)
/*! @} */

/*! @name DYNAMICMRD - Time for load mode register to active command */
/*! @{ */
#define EMC_DYNAMICMRD_TMRD_MASK                 (0xFU)
#define EMC_DYNAMICMRD_TMRD_SHIFT                (0U)
/*! TMRD - Load mode register to active command time.
 */
#define EMC_DYNAMICMRD_TMRD(x)                   (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMICMRD_TMRD_SHIFT)) & EMC_DYNAMICMRD_TMRD_MASK)
/*! @} */

/*! @name STATICEXTENDEDWAIT - Time for long static memory read and write transfers */
/*! @{ */
#define EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_MASK (0x3FFU)
#define EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_SHIFT (0U)
/*! EXTENDEDWAIT - Extended wait time out.
 */
#define EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT(x)   (((uint32_t)(((uint32_t)(x)) << EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_SHIFT)) & EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_MASK)
/*! @} */

/*! @name DYNAMIC_DYNAMICCONFIG - Configuration information for EMC_DYCSx */
/*! @{ */
#define EMC_DYNAMIC_DYNAMICCONFIG_MD_MASK        (0x18U)
#define EMC_DYNAMIC_DYNAMICCONFIG_MD_SHIFT       (3U)
/*! MD - Memory device.
 */
#define EMC_DYNAMIC_DYNAMICCONFIG_MD(x)          (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMIC_DYNAMICCONFIG_MD_SHIFT)) & EMC_DYNAMIC_DYNAMICCONFIG_MD_MASK)
#define EMC_DYNAMIC_DYNAMICCONFIG_AM0_MASK       (0x1F80U)
#define EMC_DYNAMIC_DYNAMICCONFIG_AM0_SHIFT      (7U)
/*! AM0 - See Table 933.
 */
#define EMC_DYNAMIC_DYNAMICCONFIG_AM0(x)         (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMIC_DYNAMICCONFIG_AM0_SHIFT)) & EMC_DYNAMIC_DYNAMICCONFIG_AM0_MASK)
#define EMC_DYNAMIC_DYNAMICCONFIG_AM1_MASK       (0x4000U)
#define EMC_DYNAMIC_DYNAMICCONFIG_AM1_SHIFT      (14U)
/*! AM1 - See Table 933.
 */
#define EMC_DYNAMIC_DYNAMICCONFIG_AM1(x)         (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMIC_DYNAMICCONFIG_AM1_SHIFT)) & EMC_DYNAMIC_DYNAMICCONFIG_AM1_MASK)
#define EMC_DYNAMIC_DYNAMICCONFIG_B_MASK         (0x80000U)
#define EMC_DYNAMIC_DYNAMICCONFIG_B_SHIFT        (19U)
/*! B - Buffer enable.
 */
#define EMC_DYNAMIC_DYNAMICCONFIG_B(x)           (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMIC_DYNAMICCONFIG_B_SHIFT)) & EMC_DYNAMIC_DYNAMICCONFIG_B_MASK)
#define EMC_DYNAMIC_DYNAMICCONFIG_P_MASK         (0x100000U)
#define EMC_DYNAMIC_DYNAMICCONFIG_P_SHIFT        (20U)
/*! P - Write protect.
 */
#define EMC_DYNAMIC_DYNAMICCONFIG_P(x)           (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMIC_DYNAMICCONFIG_P_SHIFT)) & EMC_DYNAMIC_DYNAMICCONFIG_P_MASK)
/*! @} */

/* The count of EMC_DYNAMIC_DYNAMICCONFIG */
#define EMC_DYNAMIC_DYNAMICCONFIG_COUNT          (4U)

/*! @name DYNAMIC_DYNAMICRASCAS - RAS and CAS latencies for EMC_DYCSx */
/*! @{ */
#define EMC_DYNAMIC_DYNAMICRASCAS_RAS_MASK       (0x3U)
#define EMC_DYNAMIC_DYNAMICRASCAS_RAS_SHIFT      (0U)
/*! RAS - RAS latency (active to read/write delay).
 */
#define EMC_DYNAMIC_DYNAMICRASCAS_RAS(x)         (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMIC_DYNAMICRASCAS_RAS_SHIFT)) & EMC_DYNAMIC_DYNAMICRASCAS_RAS_MASK)
#define EMC_DYNAMIC_DYNAMICRASCAS_CAS_MASK       (0x300U)
#define EMC_DYNAMIC_DYNAMICRASCAS_CAS_SHIFT      (8U)
/*! CAS - CAS latency.
 */
#define EMC_DYNAMIC_DYNAMICRASCAS_CAS(x)         (((uint32_t)(((uint32_t)(x)) << EMC_DYNAMIC_DYNAMICRASCAS_CAS_SHIFT)) & EMC_DYNAMIC_DYNAMICRASCAS_CAS_MASK)
/*! @} */

/* The count of EMC_DYNAMIC_DYNAMICRASCAS */
#define EMC_DYNAMIC_DYNAMICRASCAS_COUNT          (4U)

/*! @name STATIC_STATICCONFIG - Configuration for EMC_CSx */
/*! @{ */
#define EMC_STATIC_STATICCONFIG_MW_MASK          (0x3U)
#define EMC_STATIC_STATICCONFIG_MW_SHIFT         (0U)
/*! MW - Memory width.
 */
#define EMC_STATIC_STATICCONFIG_MW(x)            (((uint32_t)(((uint32_t)(x)) << EMC_STATIC_STATICCONFIG_MW_SHIFT)) & EMC_STATIC_STATICCONFIG_MW_MASK)
#define EMC_STATIC_STATICCONFIG_PM_MASK          (0x8U)
#define EMC_STATIC_STATICCONFIG_PM_SHIFT         (3U)
/*! PM - Page mode.
 */
#define EMC_STATIC_STATICCONFIG_PM(x)            (((uint32_t)(((uint32_t)(x)) << EMC_STATIC_STATICCONFIG_PM_SHIFT)) & EMC_STATIC_STATICCONFIG_PM_MASK)
#define EMC_STATIC_STATICCONFIG_PC_MASK          (0x40U)
#define EMC_STATIC_STATICCONFIG_PC_SHIFT         (6U)
/*! PC - Chip select polarity.
 */
#define EMC_STATIC_STATICCONFIG_PC(x)            (((uint32_t)(((uint32_t)(x)) << EMC_STATIC_STATICCONFIG_PC_SHIFT)) & EMC_STATIC_STATICCONFIG_PC_MASK)
#define EMC_STATIC_STATICCONFIG_PB_MASK          (0x80U)
#define EMC_STATIC_STATICCONFIG_PB_SHIFT         (7U)
/*! PB - Byte lane state.
 */
#define EMC_STATIC_STATICCONFIG_PB(x)            (((uint32_t)(((uint32_t)(x)) << EMC_STATIC_STATICCONFIG_PB_SHIFT)) & EMC_STATIC_STATICCONFIG_PB_MASK)
#define EMC_STATIC_STATICCONFIG_EW_MASK          (0x100U)
#define EMC_STATIC_STATICCONFIG_EW_SHIFT         (8U)
/*! EW - Extended wait (EW) uses the EMCStaticExtendedWait register to time both the read and write
 *    transfers rather than the EMCStaticWaitRd and EMCStaticWaitWr registers.
 */
#define EMC_STATIC_STATICCONFIG_EW(x)            (((uint32_t)(((uint32_t)(x)) << EMC_STATIC_STATICCONFIG_EW_SHIFT)) & EMC_STATIC_STATICCONFIG_EW_MASK)
#define EMC_STATIC_STATICCONFIG_B_MASK           (0x80000U)
#define EMC_STATIC_STATICCONFIG_B_SHIFT          (19U)
/*! B - Buffer enable [2].
 */
#define EMC_STATIC_STATICCONFIG_B(x)             (((uint32_t)(((uint32_t)(x)) << EMC_STATIC_STATICCONFIG_B_SHIFT)) & EMC_STATIC_STATICCONFIG_B_MASK)
#define EMC_STATIC_STATICCONFIG_P_MASK           (0x100000U)
#define EMC_STATIC_STATICCONFIG_P_SHIFT          (20U)
/*! P - Write protect.
 */
#define EMC_STATIC_STATICCONFIG_P(x)             (((uint32_t)(((uint32_t)(x)) << EMC_STATIC_STATICCONFIG_P_SHIFT)) & EMC_STATIC_STATICCONFIG_P_MASK)
/*! @} */

/* The count of EMC_STATIC_STATICCONFIG */
#define EMC_STATIC_STATICCONFIG_COUNT            (4U)

/*! @name STATIC_STATICWAITWEN - Delay from EMC_CSx to write enable */
/*! @{ */
#define EMC_STATIC_STATICWAITWEN_WAITWEN_MASK    (0xFU)
#define EMC_STATIC_STATICWAITWEN_WAITWEN_SHIFT   (0U)
/*! WAITWEN - Wait write enable.
 */
#define EMC_STATIC_STATICWAITWEN_WAITWEN(x)      (((uint32_t)(((uint32_t)(x)) << EMC_STATIC_STATICWAITWEN_WAITWEN_SHIFT)) & EMC_STATIC_STATICWAITWEN_WAITWEN_MASK)
/*! @} */

/* The count of EMC_STATIC_STATICWAITWEN */
#define EMC_STATIC_STATICWAITWEN_COUNT           (4U)

/*! @name STATIC_STATICWAITOEN - Delay from EMC_CSx or address change, whichever is later, to output enable */
/*! @{ */
#define EMC_STATIC_STATICWAITOEN_WAITOEN_MASK    (0xFU)
#define EMC_STATIC_STATICWAITOEN_WAITOEN_SHIFT   (0U)
/*! WAITOEN - Wait output enable.
 */
#define EMC_STATIC_STATICWAITOEN_WAITOEN(x)      (((uint32_t)(((uint32_t)(x)) << EMC_STATIC_STATICWAITOEN_WAITOEN_SHIFT)) & EMC_STATIC_STATICWAITOEN_WAITOEN_MASK)
/*! @} */

/* The count of EMC_STATIC_STATICWAITOEN */
#define EMC_STATIC_STATICWAITOEN_COUNT           (4U)

/*! @name STATIC_STATICWAITRD - Delay from EMC_CSx to a read access */
/*! @{ */
#define EMC_STATIC_STATICWAITRD_WAITRD_MASK      (0x1FU)
#define EMC_STATIC_STATICWAITRD_WAITRD_SHIFT     (0U)
/*! WAITRD - .
 */
#define EMC_STATIC_STATICWAITRD_WAITRD(x)        (((uint32_t)(((uint32_t)(x)) << EMC_STATIC_STATICWAITRD_WAITRD_SHIFT)) & EMC_STATIC_STATICWAITRD_WAITRD_MASK)
/*! @} */

/* The count of EMC_STATIC_STATICWAITRD */
#define EMC_STATIC_STATICWAITRD_COUNT            (4U)

/*! @name STATIC_STATICWAITPAGE - Delay for asynchronous page mode sequential accesses for EMC_CSx */
/*! @{ */
#define EMC_STATIC_STATICWAITPAGE_WAITPAGE_MASK  (0x1FU)
#define EMC_STATIC_STATICWAITPAGE_WAITPAGE_SHIFT (0U)
/*! WAITPAGE - Asynchronous page mode read after the first read wait states.
 */
#define EMC_STATIC_STATICWAITPAGE_WAITPAGE(x)    (((uint32_t)(((uint32_t)(x)) << EMC_STATIC_STATICWAITPAGE_WAITPAGE_SHIFT)) & EMC_STATIC_STATICWAITPAGE_WAITPAGE_MASK)
/*! @} */

/* The count of EMC_STATIC_STATICWAITPAGE */
#define EMC_STATIC_STATICWAITPAGE_COUNT          (4U)

/*! @name STATIC_STATICWAITWR - Delay from EMC_CSx to a write access */
/*! @{ */
#define EMC_STATIC_STATICWAITWR_WAITWR_MASK      (0x1FU)
#define EMC_STATIC_STATICWAITWR_WAITWR_SHIFT     (0U)
/*! WAITWR - Write wait states.
 */
#define EMC_STATIC_STATICWAITWR_WAITWR(x)        (((uint32_t)(((uint32_t)(x)) << EMC_STATIC_STATICWAITWR_WAITWR_SHIFT)) & EMC_STATIC_STATICWAITWR_WAITWR_MASK)
/*! @} */

/* The count of EMC_STATIC_STATICWAITWR */
#define EMC_STATIC_STATICWAITWR_COUNT            (4U)

/*! @name STATIC_STATICWAITTURN - Number of bus turnaround cycles EMC_CSx */
/*! @{ */
#define EMC_STATIC_STATICWAITTURN_WAITTURN_MASK  (0xFU)
#define EMC_STATIC_STATICWAITTURN_WAITTURN_SHIFT (0U)
/*! WAITTURN - Bus turn-around cycles.
 */
#define EMC_STATIC_STATICWAITTURN_WAITTURN(x)    (((uint32_t)(((uint32_t)(x)) << EMC_STATIC_STATICWAITTURN_WAITTURN_SHIFT)) & EMC_STATIC_STATICWAITTURN_WAITTURN_MASK)
/*! @} */

/* The count of EMC_STATIC_STATICWAITTURN */
#define EMC_STATIC_STATICWAITTURN_COUNT          (4U)


/*!
 * @}
 */ /* end of group EMC_Register_Masks */


/* EMC - Peripheral instance base addresses */
/** Peripheral EMC base address */
#define EMC_BASE                                 (0x40081000u)
/** Peripheral EMC base pointer */
#define EMC                                      ((EMC_Type *)EMC_BASE)
/** Array initializer of EMC peripheral base addresses */
#define EMC_BASE_ADDRS                           { EMC_BASE }
/** Array initializer of EMC peripheral base pointers */
#define EMC_BASE_PTRS                            { EMC }

/*!
 * @}
 */ /* end of group EMC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ENET Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENET_Peripheral_Access_Layer ENET Peripheral Access Layer
 * @{
 */

/** ENET - Register Layout Typedef */
typedef struct {
  __IO uint32_t MAC_CONFIG;                        /**< MAC configuration register, offset: 0x0 */
  __IO uint32_t MAC_EXT_CONFIG;                    /**< , offset: 0x4 */
  __IO uint32_t MAC_FRAME_FILTER;                  /**< MAC frame filter register, offset: 0x8 */
  __IO uint32_t MAC_WD_TIMEROUT;                   /**< MAC watchdog Timeout register, offset: 0xC */
       uint8_t RESERVED_0[64];
  __IO uint32_t MAC_VLAN_TAG;                      /**< MAC vlan tag register, offset: 0x50 */
       uint8_t RESERVED_1[28];
  __IO uint32_t MAC_TX_FLOW_CTRL_Q[2];             /**< Transmit flow control register, array offset: 0x70, array step: 0x4 */
       uint8_t RESERVED_2[24];
  __IO uint32_t MAC_RX_FLOW_CTRL;                  /**< Receive flow control register, offset: 0x90 */
       uint8_t RESERVED_3[4];
  __IO uint32_t MAC_TXQ_PRIO_MAP;                  /**< , offset: 0x98 */
       uint8_t RESERVED_4[4];
  __IO uint32_t MAC_RXQ_CTRL[3];                   /**< Receive Queue Control 0 register 0x0000, array offset: 0xA0, array step: 0x4 */
       uint8_t RESERVED_5[4];
  __I  uint32_t MAC_INTR_STAT;                     /**< Interrupt status register 0x0000, offset: 0xB0 */
  __IO uint32_t MAC_INTR_EN;                       /**< Interrupt enable register 0x0000, offset: 0xB4 */
  __I  uint32_t MAC_RXTX_STAT;                     /**< Receive Transmit Status register, offset: 0xB8 */
       uint8_t RESERVED_6[4];
  __IO uint32_t MAC_PMT_CRTL_STAT;                 /**< , offset: 0xC0 */
  __IO uint32_t MAC_RWAKE_FRFLT;                   /**< Remote wake-up frame filter, offset: 0xC4 */
       uint8_t RESERVED_7[8];
  __IO uint32_t MAC_LPI_CTRL_STAT;                 /**< LPI Control and Status Register, offset: 0xD0 */
  __IO uint32_t MAC_LPI_TIMER_CTRL;                /**< LPI Timers Control register, offset: 0xD4 */
  __IO uint32_t MAC_LPI_ENTR_TIMR;                 /**< LPI entry Timer register, offset: 0xD8 */
  __IO uint32_t MAC_1US_TIC_COUNTR;                /**< , offset: 0xDC */
       uint8_t RESERVED_8[48];
  __I  uint32_t MAC_VERSION;                       /**< MAC version register, offset: 0x110 */
  __I  uint32_t MAC_DBG;                           /**< MAC debug register, offset: 0x114 */
       uint8_t RESERVED_9[4];
  __I  uint32_t MAC_HW_FEAT[3];                    /**< MAC hardware feature register 0x0201, array offset: 0x11C, array step: 0x4 */
       uint8_t RESERVED_10[216];
  __IO uint32_t MAC_MDIO_ADDR;                     /**< MIDO address Register, offset: 0x200 */
  __IO uint32_t MAC_MDIO_DATA;                     /**< MDIO Data register, offset: 0x204 */
       uint8_t RESERVED_11[248];
  __IO uint32_t MAC_ADDR_HIGH;                     /**< MAC address0 high register, offset: 0x300 */
  __IO uint32_t MAC_ADDR_LOW;                      /**< MAC address0 low register, offset: 0x304 */
       uint8_t RESERVED_12[2040];
  __IO uint32_t MAC_TIMESTAMP_CTRL;                /**< Time stamp control register, offset: 0xB00 */
  __IO uint32_t MAC_SUB_SCND_INCR;                 /**< Sub-second increment register, offset: 0xB04 */
  __I  uint32_t MAC_SYS_TIME_SCND;                 /**< System time seconds register, offset: 0xB08 */
  __I  uint32_t MAC_SYS_TIME_NSCND;                /**< System time nanoseconds register, offset: 0xB0C */
  __IO uint32_t MAC_SYS_TIME_SCND_UPD;             /**< , offset: 0xB10 */
  __IO uint32_t MAC_SYS_TIME_NSCND_UPD;            /**< , offset: 0xB14 */
  __IO uint32_t MAC_SYS_TIMESTMP_ADDEND;           /**< Time stamp addend register, offset: 0xB18 */
  __IO uint32_t MAC_SYS_TIME_HWORD_SCND;           /**< , offset: 0xB1C */
  __I  uint32_t MAC_SYS_TIMESTMP_STAT;             /**< Time stamp status register, offset: 0xB20 */
       uint8_t RESERVED_13[12];
  __I  uint32_t MAC_TX_TIMESTAMP_STATUS_NANOSECONDS; /**< Tx timestamp status nanoseconds, offset: 0xB30 */
  __I  uint32_t MAC_TX_TIMESTAMP_STATUS_SECONDS;   /**< Tx timestamp status seconds, offset: 0xB34 */
       uint8_t RESERVED_14[32];
  __IO uint32_t MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND; /**< Timestamp ingress correction, offset: 0xB58 */
  __IO uint32_t MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND; /**< Timestamp egress correction, offset: 0xB5C */
       uint8_t RESERVED_15[160];
  __IO uint32_t MTL_OP_MODE;                       /**< MTL Operation Mode Register, offset: 0xC00 */
       uint8_t RESERVED_16[28];
  __I  uint32_t MTL_INTR_STAT;                     /**< MTL Interrupt Status register, offset: 0xC20 */
       uint8_t RESERVED_17[12];
  __IO uint32_t MTL_RXQ_DMA_MAP;                   /**< MTL Receive Queue and DMA Channel Mapping register, offset: 0xC30 */
       uint8_t RESERVED_18[204];
  struct {                                         /* offset: 0xD00, array step: 0x40 */
    __IO uint32_t MTL_TXQX_OP_MODE;                  /**< MTL TxQx Operation Mode register, array offset: 0xD00, array step: 0x40 */
    __I  uint32_t MTL_TXQX_UNDRFLW;                  /**< MTL TxQx Underflow register, array offset: 0xD04, array step: 0x40 */
    __I  uint32_t MTL_TXQX_DBG;                      /**< MTL TxQx Debug register, array offset: 0xD08, array step: 0x40 */
         uint8_t RESERVED_0[4];
    __IO uint32_t MTL_TXQX_ETS_CTRL;                 /**< MTL TxQx ETS control register, only TxQ1 support, array offset: 0xD10, array step: 0x40 */
    __I  uint32_t MTL_TXQX_ETS_STAT;                 /**< MTL TxQx ETS Status register, array offset: 0xD14, array step: 0x40 */
    __IO uint32_t MTL_TXQX_QNTM_WGHT;                /**< , array offset: 0xD18, array step: 0x40 */
    __IO uint32_t MTL_TXQX_SNDSLP_CRDT;              /**< MTL TxQx SendSlopCredit register, only TxQ1 support, array offset: 0xD1C, array step: 0x40 */
    __IO uint32_t MTL_TXQX_HI_CRDT;                  /**< MTL TxQx hiCredit register, only TxQ1 support, array offset: 0xD20, array step: 0x40 */
    __IO uint32_t MTL_TXQX_LO_CRDT;                  /**< MTL TxQx loCredit register, only TxQ1 support, array offset: 0xD24, array step: 0x40 */
         uint8_t RESERVED_1[4];
    __IO uint32_t MTL_TXQX_INTCTRL_STAT;             /**< , array offset: 0xD2C, array step: 0x40 */
    __IO uint32_t MTL_RXQX_OP_MODE;                  /**< MTL RxQx Operation Mode register, array offset: 0xD30, array step: 0x40 */
    __I  uint32_t MTL_RXQX_MISSPKT_OVRFLW_CNT;       /**< MTL RxQx Missed Packet Overflow Counter register, array offset: 0xD34, array step: 0x40 */
    __I  uint32_t MTL_RXQX_DBG;                      /**< MTL RxQx Debug register, array offset: 0xD38, array step: 0x40 */
    __IO uint32_t MTL_RXQX_CTRL;                     /**< MTL RxQx Control register, array offset: 0xD3C, array step: 0x40 */
  } MTL_QUEUE[2];
       uint8_t RESERVED_19[640];
  __IO uint32_t DMA_MODE;                          /**< DMA mode register, offset: 0x1000 */
  __IO uint32_t DMA_SYSBUS_MODE;                   /**< DMA System Bus mode, offset: 0x1004 */
  __IO uint32_t DMA_INTR_STAT;                     /**< DMA Interrupt status, offset: 0x1008 */
  __I  uint32_t DMA_DBG_STAT;                      /**< DMA Debug Status, offset: 0x100C */
       uint8_t RESERVED_20[240];
  struct {                                         /* offset: 0x1100, array step: 0x80 */
    __IO uint32_t DMA_CHX_CTRL;                      /**< DMA Channelx Control, array offset: 0x1100, array step: 0x80 */
    __IO uint32_t DMA_CHX_TX_CTRL;                   /**< DMA Channelx Transmit Control, array offset: 0x1104, array step: 0x80 */
    __IO uint32_t DMA_CHX_RX_CTRL;                   /**< DMA Channelx Receive Control, array offset: 0x1108, array step: 0x80 */
         uint8_t RESERVED_0[8];
    __IO uint32_t DMA_CHX_TXDESC_LIST_ADDR;          /**< , array offset: 0x1114, array step: 0x80 */
         uint8_t RESERVED_1[4];
    __IO uint32_t DMA_CHX_RXDESC_LIST_ADDR;          /**< , array offset: 0x111C, array step: 0x80 */
    __IO uint32_t DMA_CHX_TXDESC_TAIL_PTR;           /**< , array offset: 0x1120, array step: 0x80 */
         uint8_t RESERVED_2[4];
    __IO uint32_t DMA_CHX_RXDESC_TAIL_PTR;           /**< , array offset: 0x1128, array step: 0x80 */
    __IO uint32_t DMA_CHX_TXDESC_RING_LENGTH;        /**< , array offset: 0x112C, array step: 0x80 */
    __IO uint32_t DMA_CHX_RXDESC_RING_LENGTH;        /**< Channelx Rx descriptor Ring Length, array offset: 0x1130, array step: 0x80 */
    __IO uint32_t DMA_CHX_INT_EN;                    /**< Channelx Interrupt Enable, array offset: 0x1134, array step: 0x80 */
    __IO uint32_t DMA_CHX_RX_INT_WDTIMER;            /**< Receive Interrupt Watchdog Timer, array offset: 0x1138, array step: 0x80 */
    __IO uint32_t DMA_CHX_SLOT_FUNC_CTRL_STAT;       /**< Slot Function Control and Status, array offset: 0x113C, array step: 0x80 */
         uint8_t RESERVED_3[4];
    __I  uint32_t DMA_CHX_CUR_HST_TXDESC;            /**< Channelx Current Host Transmit descriptor, array offset: 0x1144, array step: 0x80 */
         uint8_t RESERVED_4[4];
    __I  uint32_t DMA_CHX_CUR_HST_RXDESC;            /**< , array offset: 0x114C, array step: 0x80 */
         uint8_t RESERVED_5[4];
    __I  uint32_t DMA_CHX_CUR_HST_TXBUF;             /**< , array offset: 0x1154, array step: 0x80 */
         uint8_t RESERVED_6[4];
    __I  uint32_t DMA_CHX_CUR_HST_RXBUF;             /**< Channelx Current Application Receive Buffer Address, array offset: 0x115C, array step: 0x80 */
    __IO uint32_t DMA_CHX_STAT;                      /**< Channelx DMA status register, array offset: 0x1160, array step: 0x80 */
         uint8_t RESERVED_7[8];
    __IO uint32_t DMA_CHX_MISS_FRAME_CNT;            /**< Channelx missed frame count., array offset: 0x116C, array step: 0x80 */
         uint8_t RESERVED_8[16];
  } DMA_CH[2];
} ENET_Type;

/* ----------------------------------------------------------------------------
   -- ENET Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENET_Register_Masks ENET Register Masks
 * @{
 */

/*! @name MAC_CONFIG - MAC configuration register */
/*! @{ */
#define ENET_MAC_CONFIG_RE_MASK                  (0x1U)
#define ENET_MAC_CONFIG_RE_SHIFT                 (0U)
/*! RE - Receiver Enable When this bit is set, the receiver state machine of the MAC is enabled for
 *    receiving frames from the MII.
 */
#define ENET_MAC_CONFIG_RE(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_RE_SHIFT)) & ENET_MAC_CONFIG_RE_MASK)
#define ENET_MAC_CONFIG_TE_MASK                  (0x2U)
#define ENET_MAC_CONFIG_TE_SHIFT                 (1U)
/*! TE - Transmitter Enable When this bit is set, the transmit state machine of the MAC is enabled for transmission on the MII.
 */
#define ENET_MAC_CONFIG_TE(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_TE_SHIFT)) & ENET_MAC_CONFIG_TE_MASK)
#define ENET_MAC_CONFIG_PRELEN_MASK              (0xCU)
#define ENET_MAC_CONFIG_PRELEN_SHIFT             (2U)
/*! PRELEN - Preamble Length for Transmit packets These bits control the number of preamble bytes
 *    that are added to the beginning of every Tx packet.
 */
#define ENET_MAC_CONFIG_PRELEN(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_PRELEN_SHIFT)) & ENET_MAC_CONFIG_PRELEN_MASK)
#define ENET_MAC_CONFIG_DC_MASK                  (0x10U)
#define ENET_MAC_CONFIG_DC_SHIFT                 (4U)
/*! DC - Deferral Check When this bit is set, the deferral check function is enabled in the MAC.
 */
#define ENET_MAC_CONFIG_DC(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_DC_SHIFT)) & ENET_MAC_CONFIG_DC_MASK)
#define ENET_MAC_CONFIG_BL_MASK                  (0x60U)
#define ENET_MAC_CONFIG_BL_SHIFT                 (5U)
/*! BL - Back-Off Limit The Back-Off limit determines the random integer number (r) of slot time
 *    delays (4,096 bit times for 1000 Mbps and 512 bit times for 10/100 Mbps) the MAC waits before
 *    rescheduling a transmission attempt during retries after a collision.
 */
#define ENET_MAC_CONFIG_BL(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_BL_SHIFT)) & ENET_MAC_CONFIG_BL_MASK)
#define ENET_MAC_CONFIG_DR_MASK                  (0x100U)
#define ENET_MAC_CONFIG_DR_SHIFT                 (8U)
/*! DR - Disable Retry When this bit is set, the MAC will attempt only one transmission.
 */
#define ENET_MAC_CONFIG_DR(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_DR_SHIFT)) & ENET_MAC_CONFIG_DR_MASK)
#define ENET_MAC_CONFIG_DCRS_MASK                (0x200U)
#define ENET_MAC_CONFIG_DCRS_SHIFT               (9U)
/*! DCRS - Disable Carrier Sense During Transmission When this bit is set, the MAC transmitter
 *    ignores the MII CRS signal during packet transmission in the half-duplex mode.
 */
#define ENET_MAC_CONFIG_DCRS(x)                  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_DCRS_SHIFT)) & ENET_MAC_CONFIG_DCRS_MASK)
#define ENET_MAC_CONFIG_DO_MASK                  (0x400U)
#define ENET_MAC_CONFIG_DO_SHIFT                 (10U)
/*! DO - Disable Receive Own When this bit is set, the MAC disables the reception of frames when the
 *    gmii_txen_o is asserted in Half-Duplex mode.
 */
#define ENET_MAC_CONFIG_DO(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_DO_SHIFT)) & ENET_MAC_CONFIG_DO_MASK)
#define ENET_MAC_CONFIG_ECRSFD_MASK              (0x800U)
#define ENET_MAC_CONFIG_ECRSFD_SHIFT             (11U)
/*! ECRSFD - Enable Carrier Sense Before Transmission in Full-Duplex Mode When this bit is set, the
 *    MAC transmitter checks the CRS signal before packet transmission in the full-duplex mode.
 */
#define ENET_MAC_CONFIG_ECRSFD(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_ECRSFD_SHIFT)) & ENET_MAC_CONFIG_ECRSFD_MASK)
#define ENET_MAC_CONFIG_LM_MASK                  (0x1000U)
#define ENET_MAC_CONFIG_LM_SHIFT                 (12U)
/*! LM - Loopback Mode When this bit is set, the MAC operates in loopback mode at MII.
 */
#define ENET_MAC_CONFIG_LM(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_LM_SHIFT)) & ENET_MAC_CONFIG_LM_MASK)
#define ENET_MAC_CONFIG_DM_MASK                  (0x2000U)
#define ENET_MAC_CONFIG_DM_SHIFT                 (13U)
/*! DM - Duplex Mode When this bit is set, the MAC operates in a Full-Duplex mode where it can
 *    transmit and receive simultaneously.
 */
#define ENET_MAC_CONFIG_DM(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_DM_SHIFT)) & ENET_MAC_CONFIG_DM_MASK)
#define ENET_MAC_CONFIG_FES_MASK                 (0x4000U)
#define ENET_MAC_CONFIG_FES_SHIFT                (14U)
/*! FES - Speed Indicates the speed in Fast Ethernet (MII) mode: This bit is reserved (RO) by
 *    default and is enabled only when RMII/SMII is enabled during configuration.
 */
#define ENET_MAC_CONFIG_FES(x)                   (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_FES_SHIFT)) & ENET_MAC_CONFIG_FES_MASK)
#define ENET_MAC_CONFIG_PS_MASK                  (0x8000U)
#define ENET_MAC_CONFIG_PS_SHIFT                 (15U)
/*! PS - Portselect.
 */
#define ENET_MAC_CONFIG_PS(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_PS_SHIFT)) & ENET_MAC_CONFIG_PS_MASK)
#define ENET_MAC_CONFIG_JE_MASK                  (0x10000U)
#define ENET_MAC_CONFIG_JE_SHIFT                 (16U)
/*! JE - Jumbo Frame Enable When this bit is set, MAC allows Jumbo frames of 9,018 bytes (9,022
 *    bytes for tagged frames) without reporting a giant frame error in the receive frame status.
 */
#define ENET_MAC_CONFIG_JE(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_JE_SHIFT)) & ENET_MAC_CONFIG_JE_MASK)
#define ENET_MAC_CONFIG_JD_MASK                  (0x20000U)
#define ENET_MAC_CONFIG_JD_SHIFT                 (17U)
/*! JD - Jabber Disable When this bit is set, the MAC disables the jabber timer on the transmitter,
 *    and can transfer frames of up to 16,384 bytes.
 */
#define ENET_MAC_CONFIG_JD(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_JD_SHIFT)) & ENET_MAC_CONFIG_JD_MASK)
#define ENET_MAC_CONFIG_BE_MASK                  (0x40000U)
#define ENET_MAC_CONFIG_BE_SHIFT                 (18U)
/*! BE - Packet Burst Enable When this bit is set, the MAC allows packet bursting during
 *    transmission in the MII half-duplex mode.
 */
#define ENET_MAC_CONFIG_BE(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_BE_SHIFT)) & ENET_MAC_CONFIG_BE_MASK)
#define ENET_MAC_CONFIG_WD_MASK                  (0x80000U)
#define ENET_MAC_CONFIG_WD_SHIFT                 (19U)
/*! WD - Watchdog Disable When this bit is set, the MAC disables the watchdog timer on the receiver,
 *    and can receive frames of up to 16,384 bytes.
 */
#define ENET_MAC_CONFIG_WD(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_WD_SHIFT)) & ENET_MAC_CONFIG_WD_MASK)
#define ENET_MAC_CONFIG_ACS_MASK                 (0x100000U)
#define ENET_MAC_CONFIG_ACS_SHIFT                (20U)
/*! ACS - Automatic Pad or CRC Stripping When this bit is set, the MAC strips the Pad or FCS field
 *    on the incoming packets only if the value of the length field is less than 1,536 bytes.
 */
#define ENET_MAC_CONFIG_ACS(x)                   (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_ACS_SHIFT)) & ENET_MAC_CONFIG_ACS_MASK)
#define ENET_MAC_CONFIG_CST_MASK                 (0x200000U)
#define ENET_MAC_CONFIG_CST_SHIFT                (21U)
/*! CST - CRC stripping for Type packets When this bit is set, the last four bytes (FCS) of all
 *    packets of Ether type (type field greater than 1,536) are stripped and dropped before forwarding
 *    the packet to the application.
 */
#define ENET_MAC_CONFIG_CST(x)                   (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_CST_SHIFT)) & ENET_MAC_CONFIG_CST_MASK)
#define ENET_MAC_CONFIG_S2KP_MASK                (0x400000U)
#define ENET_MAC_CONFIG_S2KP_SHIFT               (22U)
/*! S2KP - IEEE 802.
 */
#define ENET_MAC_CONFIG_S2KP(x)                  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_S2KP_SHIFT)) & ENET_MAC_CONFIG_S2KP_MASK)
#define ENET_MAC_CONFIG_GPSLCE_MASK              (0x800000U)
#define ENET_MAC_CONFIG_GPSLCE_SHIFT             (23U)
/*! GPSLCE - Giant Packet Size Limit Control Enable When this bit is set, the MAC considers the
 *    value in GPSL field in MAC Ext Configuration register to declare a received packet as Giant packet.
 */
#define ENET_MAC_CONFIG_GPSLCE(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_GPSLCE_SHIFT)) & ENET_MAC_CONFIG_GPSLCE_MASK)
#define ENET_MAC_CONFIG_IPG_MASK                 (0x7000000U)
#define ENET_MAC_CONFIG_IPG_SHIFT                (24U)
/*! IPG - Inter-Packet Gap These bits control the minimum IPG between packets during transmission.
 */
#define ENET_MAC_CONFIG_IPG(x)                   (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_IPG_SHIFT)) & ENET_MAC_CONFIG_IPG_MASK)
#define ENET_MAC_CONFIG_IPC_MASK                 (0x8000000U)
#define ENET_MAC_CONFIG_IPC_SHIFT                (27U)
/*! IPC - Checksum Offload When set, this bit enables the IPv4 header checksum checking and IPv4 or
 *    IPv6 TCP, UDP, or ICMP payload checksum checking.
 */
#define ENET_MAC_CONFIG_IPC(x)                   (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIG_IPC_SHIFT)) & ENET_MAC_CONFIG_IPC_MASK)
/*! @} */

/*! @name MAC_EXT_CONFIG -  */
/*! @{ */
#define ENET_MAC_EXT_CONFIG_GPSL_MASK            (0x3FFFU)
#define ENET_MAC_EXT_CONFIG_GPSL_SHIFT           (0U)
/*! GPSL - Giant Packet Size Limit If the received packet size is greater than the value programmed
 *    in this field in units of bytes, the MAC declares the received packet as Giant packet.
 */
#define ENET_MAC_EXT_CONFIG_GPSL(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_EXT_CONFIG_GPSL_SHIFT)) & ENET_MAC_EXT_CONFIG_GPSL_MASK)
#define ENET_MAC_EXT_CONFIG_DCRCC_MASK           (0x10000U)
#define ENET_MAC_EXT_CONFIG_DCRCC_SHIFT          (16U)
/*! DCRCC - Disable CRC Checking for Received Packets When this bit is set, the MAC receiver does
 *    not check the CRC field in the received packets.
 */
#define ENET_MAC_EXT_CONFIG_DCRCC(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_EXT_CONFIG_DCRCC_SHIFT)) & ENET_MAC_EXT_CONFIG_DCRCC_MASK)
#define ENET_MAC_EXT_CONFIG_SPEN_MASK            (0x20000U)
#define ENET_MAC_EXT_CONFIG_SPEN_SHIFT           (17U)
/*! SPEN - Slow Protocol Detection Enable When this bit is set, MAC processes the Slow Protocol
 *    packets (Ether Type 0x8809) and provides the Rx status.
 */
#define ENET_MAC_EXT_CONFIG_SPEN(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_EXT_CONFIG_SPEN_SHIFT)) & ENET_MAC_EXT_CONFIG_SPEN_MASK)
#define ENET_MAC_EXT_CONFIG_USP_MASK             (0x40000U)
#define ENET_MAC_EXT_CONFIG_USP_SHIFT            (18U)
/*! USP - Unicast Slow Protocol Packet Detect When this bit is set, the MAC detects the Slow
 *    Protocol packets with unicast address of the station specified in the MAC Address High Table 747 and
 *    MAC Address Low Table 748 registers.
 */
#define ENET_MAC_EXT_CONFIG_USP(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_EXT_CONFIG_USP_SHIFT)) & ENET_MAC_EXT_CONFIG_USP_MASK)
/*! @} */

/*! @name MAC_FRAME_FILTER - MAC frame filter register */
/*! @{ */
#define ENET_MAC_FRAME_FILTER_PR_MASK            (0x1U)
#define ENET_MAC_FRAME_FILTER_PR_SHIFT           (0U)
/*! PR - Promiscuous Mode When this bit is set, the Address Filter module passes all incoming frames
 *    regardless of its destination or source address.
 */
#define ENET_MAC_FRAME_FILTER_PR(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_FRAME_FILTER_PR_SHIFT)) & ENET_MAC_FRAME_FILTER_PR_MASK)
#define ENET_MAC_FRAME_FILTER_DAIF_MASK          (0x8U)
#define ENET_MAC_FRAME_FILTER_DAIF_SHIFT         (3U)
/*! DAIF - DA Inverse Filtering When this bit is set, the Address Check block operates in inverse
 *    filtering mode for the DA address comparison for both unicast and multicast frames.
 */
#define ENET_MAC_FRAME_FILTER_DAIF(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_FRAME_FILTER_DAIF_SHIFT)) & ENET_MAC_FRAME_FILTER_DAIF_MASK)
#define ENET_MAC_FRAME_FILTER_PM_MASK            (0x10U)
#define ENET_MAC_FRAME_FILTER_PM_SHIFT           (4U)
/*! PM - Pass All Multicast When set, this bit indicates that all received frames with a multicast
 *    destination address (first bit in the destination address field is '1') are passed.
 */
#define ENET_MAC_FRAME_FILTER_PM(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_FRAME_FILTER_PM_SHIFT)) & ENET_MAC_FRAME_FILTER_PM_MASK)
#define ENET_MAC_FRAME_FILTER_DBF_MASK           (0x20U)
#define ENET_MAC_FRAME_FILTER_DBF_SHIFT          (5U)
/*! DBF - Disable Broadcast Frames When this bit is set, the AFM module filters all incoming broadcast frames.
 */
#define ENET_MAC_FRAME_FILTER_DBF(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_FRAME_FILTER_DBF_SHIFT)) & ENET_MAC_FRAME_FILTER_DBF_MASK)
#define ENET_MAC_FRAME_FILTER_PCF_MASK           (0xC0U)
#define ENET_MAC_FRAME_FILTER_PCF_SHIFT          (6U)
/*! PCF - Pass Control Frames These bits control the forwarding of all control frames (including
 *    unicast and multicast PAUSE frames).
 */
#define ENET_MAC_FRAME_FILTER_PCF(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_FRAME_FILTER_PCF_SHIFT)) & ENET_MAC_FRAME_FILTER_PCF_MASK)
#define ENET_MAC_FRAME_FILTER_SAIF_MASK          (0x100U)
#define ENET_MAC_FRAME_FILTER_SAIF_SHIFT         (8U)
/*! SAIF - SA Inverse Filtering When this bit is set, the Address Check block operates in the
 *    inverse filtering mode for SA address comparison.
 */
#define ENET_MAC_FRAME_FILTER_SAIF(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_FRAME_FILTER_SAIF_SHIFT)) & ENET_MAC_FRAME_FILTER_SAIF_MASK)
#define ENET_MAC_FRAME_FILTER_SAF_MASK           (0x200U)
#define ENET_MAC_FRAME_FILTER_SAF_SHIFT          (9U)
/*! SAF - Source Address Filter Enable When this bit is set, the MAC compares the SA field of the
 *    received packets with the values programmed in the enabled SA registers.
 */
#define ENET_MAC_FRAME_FILTER_SAF(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_FRAME_FILTER_SAF_SHIFT)) & ENET_MAC_FRAME_FILTER_SAF_MASK)
#define ENET_MAC_FRAME_FILTER_RA_MASK            (0x80000000U)
#define ENET_MAC_FRAME_FILTER_RA_SHIFT           (31U)
/*! RA - Receive all When this bit is set, the MAC Receiver module passes to the Application all
 *    frames received irrespective of whether they pass the address filter.
 */
#define ENET_MAC_FRAME_FILTER_RA(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_FRAME_FILTER_RA_SHIFT)) & ENET_MAC_FRAME_FILTER_RA_MASK)
/*! @} */

/*! @name MAC_WD_TIMEROUT - MAC watchdog Timeout register */
/*! @{ */
#define ENET_MAC_WD_TIMEROUT_WTO_MASK            (0xFU)
#define ENET_MAC_WD_TIMEROUT_WTO_SHIFT           (0U)
/*! WTO - Watchdog Timeout When the PWE bit is set and the WD bit of the MAC Configuration register
 *    Table 722 is reset, this field is used as watchdog timeout for a received packet.
 */
#define ENET_MAC_WD_TIMEROUT_WTO(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_WD_TIMEROUT_WTO_SHIFT)) & ENET_MAC_WD_TIMEROUT_WTO_MASK)
#define ENET_MAC_WD_TIMEROUT_PWE_MASK            (0x100U)
#define ENET_MAC_WD_TIMEROUT_PWE_SHIFT           (8U)
/*! PWE - Programmable Watchdog Enable When this bit is set and the WD bit of the MAC Configuration
 *    register Table 722 is reset, the WTO field is used as watchdog timeout for a received packet.
 */
#define ENET_MAC_WD_TIMEROUT_PWE(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_WD_TIMEROUT_PWE_SHIFT)) & ENET_MAC_WD_TIMEROUT_PWE_MASK)
/*! @} */

/*! @name MAC_VLAN_TAG - MAC vlan tag register */
/*! @{ */
#define ENET_MAC_VLAN_TAG_VL_MASK                (0xFFFFU)
#define ENET_MAC_VLAN_TAG_VL_SHIFT               (0U)
/*! VL - VLAN Tag Identifier for Receive Packets.
 */
#define ENET_MAC_VLAN_TAG_VL(x)                  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_VL_SHIFT)) & ENET_MAC_VLAN_TAG_VL_MASK)
#define ENET_MAC_VLAN_TAG_ETV_MASK               (0x10000U)
#define ENET_MAC_VLAN_TAG_ETV_SHIFT              (16U)
/*! ETV - Enable 12-Bit VLAN Tag Comparison.
 */
#define ENET_MAC_VLAN_TAG_ETV(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_ETV_SHIFT)) & ENET_MAC_VLAN_TAG_ETV_MASK)
#define ENET_MAC_VLAN_TAG_VTIM_MASK              (0x20000U)
#define ENET_MAC_VLAN_TAG_VTIM_SHIFT             (17U)
/*! VTIM - VLAN Tag Inverse Match Enable.
 */
#define ENET_MAC_VLAN_TAG_VTIM(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_VTIM_SHIFT)) & ENET_MAC_VLAN_TAG_VTIM_MASK)
#define ENET_MAC_VLAN_TAG_ESVL_MASK              (0x40000U)
#define ENET_MAC_VLAN_TAG_ESVL_SHIFT             (18U)
/*! ESVL - Enable S-VLAN.
 */
#define ENET_MAC_VLAN_TAG_ESVL(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_ESVL_SHIFT)) & ENET_MAC_VLAN_TAG_ESVL_MASK)
#define ENET_MAC_VLAN_TAG_ERSVLM_MASK            (0x80000U)
#define ENET_MAC_VLAN_TAG_ERSVLM_SHIFT           (19U)
/*! ERSVLM - Enable Receive S-VLAN Match.
 */
#define ENET_MAC_VLAN_TAG_ERSVLM(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_ERSVLM_SHIFT)) & ENET_MAC_VLAN_TAG_ERSVLM_MASK)
#define ENET_MAC_VLAN_TAG_DOVLTC_MASK            (0x100000U)
#define ENET_MAC_VLAN_TAG_DOVLTC_SHIFT           (20U)
/*! DOVLTC - Disable VLAN Type Check.
 */
#define ENET_MAC_VLAN_TAG_DOVLTC(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_DOVLTC_SHIFT)) & ENET_MAC_VLAN_TAG_DOVLTC_MASK)
#define ENET_MAC_VLAN_TAG_EVLS_MASK              (0x600000U)
#define ENET_MAC_VLAN_TAG_EVLS_SHIFT             (21U)
/*! EVLS - Enable VLAN Tag Stripping on Receive.
 */
#define ENET_MAC_VLAN_TAG_EVLS(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_EVLS_SHIFT)) & ENET_MAC_VLAN_TAG_EVLS_MASK)
#define ENET_MAC_VLAN_TAG_EVLRXS_MASK            (0x1000000U)
#define ENET_MAC_VLAN_TAG_EVLRXS_SHIFT           (24U)
/*! EVLRXS - Enable VLAN Tag in Rx status.
 */
#define ENET_MAC_VLAN_TAG_EVLRXS(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_EVLRXS_SHIFT)) & ENET_MAC_VLAN_TAG_EVLRXS_MASK)
#define ENET_MAC_VLAN_TAG_VTHM_MASK              (0x2000000U)
#define ENET_MAC_VLAN_TAG_VTHM_SHIFT             (25U)
/*! VTHM - Disable VLAN Type Check.
 */
#define ENET_MAC_VLAN_TAG_VTHM(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_VTHM_SHIFT)) & ENET_MAC_VLAN_TAG_VTHM_MASK)
#define ENET_MAC_VLAN_TAG_EDVLP_MASK             (0x4000000U)
#define ENET_MAC_VLAN_TAG_EDVLP_SHIFT            (26U)
/*! EDVLP - Enable Double VLAN Processing.
 */
#define ENET_MAC_VLAN_TAG_EDVLP(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_EDVLP_SHIFT)) & ENET_MAC_VLAN_TAG_EDVLP_MASK)
#define ENET_MAC_VLAN_TAG_ERIVLT_MASK            (0x8000000U)
#define ENET_MAC_VLAN_TAG_ERIVLT_SHIFT           (27U)
/*! ERIVLT - Enable Inner VLAN Tag.
 */
#define ENET_MAC_VLAN_TAG_ERIVLT(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_ERIVLT_SHIFT)) & ENET_MAC_VLAN_TAG_ERIVLT_MASK)
#define ENET_MAC_VLAN_TAG_EIVLS_MASK             (0x30000000U)
#define ENET_MAC_VLAN_TAG_EIVLS_SHIFT            (28U)
/*! EIVLS - Enable Inner VLAN Tag Stripping on Receive.
 */
#define ENET_MAC_VLAN_TAG_EIVLS(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_EIVLS_SHIFT)) & ENET_MAC_VLAN_TAG_EIVLS_MASK)
#define ENET_MAC_VLAN_TAG_EIVLRXS_MASK           (0x80000000U)
#define ENET_MAC_VLAN_TAG_EIVLRXS_SHIFT          (31U)
/*! EIVLRXS - Enable Inner VLAN Tag in Rx Status.
 */
#define ENET_MAC_VLAN_TAG_EIVLRXS(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_EIVLRXS_SHIFT)) & ENET_MAC_VLAN_TAG_EIVLRXS_MASK)
/*! @} */

/*! @name MAC_TX_FLOW_CTRL_Q - Transmit flow control register */
/*! @{ */
#define ENET_MAC_TX_FLOW_CTRL_Q_FCB_MASK         (0x1U)
#define ENET_MAC_TX_FLOW_CTRL_Q_FCB_SHIFT        (0U)
/*! FCB - Flow Control Busy/Backpressure Activate This register field can be read by the application
 *    (Read), can be set to 1 by the application with a register write of 1 (Write Set), and is
 *    cleared to 0 by the core (Self Clear).
 */
#define ENET_MAC_TX_FLOW_CTRL_Q_FCB(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_FLOW_CTRL_Q_FCB_SHIFT)) & ENET_MAC_TX_FLOW_CTRL_Q_FCB_MASK)
#define ENET_MAC_TX_FLOW_CTRL_Q_TFE_MASK         (0x2U)
#define ENET_MAC_TX_FLOW_CTRL_Q_TFE_SHIFT        (1U)
/*! TFE - Transmit Flow Control Enable In Full-Duplex mode, when this bit is set, the MAC enables
 *    the flow control operation to transmit Pause frames.
 */
#define ENET_MAC_TX_FLOW_CTRL_Q_TFE(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_FLOW_CTRL_Q_TFE_SHIFT)) & ENET_MAC_TX_FLOW_CTRL_Q_TFE_MASK)
#define ENET_MAC_TX_FLOW_CTRL_Q_PLT_MASK         (0x70U)
#define ENET_MAC_TX_FLOW_CTRL_Q_PLT_SHIFT        (4U)
/*! PLT - Pause Low Threshold This field configures the threshold of the PAUSE timer at which the
 *    input flow control signal is checked for automatic retransmission of PAUSE Frame.
 */
#define ENET_MAC_TX_FLOW_CTRL_Q_PLT(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_FLOW_CTRL_Q_PLT_SHIFT)) & ENET_MAC_TX_FLOW_CTRL_Q_PLT_MASK)
#define ENET_MAC_TX_FLOW_CTRL_Q_DZPQ_MASK        (0x80U)
#define ENET_MAC_TX_FLOW_CTRL_Q_DZPQ_SHIFT       (7U)
/*! DZPQ - Disable Zero-Quanta Pause When set, this bit disables the automatic generation of
 *    Zero-Quanta Pause Control frames on the deassertion of the flow-control signal from the FIFO layer.
 */
#define ENET_MAC_TX_FLOW_CTRL_Q_DZPQ(x)          (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_FLOW_CTRL_Q_DZPQ_SHIFT)) & ENET_MAC_TX_FLOW_CTRL_Q_DZPQ_MASK)
#define ENET_MAC_TX_FLOW_CTRL_Q_PT_MASK          (0xFFFF0000U)
#define ENET_MAC_TX_FLOW_CTRL_Q_PT_SHIFT         (16U)
/*! PT - Pause time This field holds the value to be used in the Pause Time field in the transmit control frame.
 */
#define ENET_MAC_TX_FLOW_CTRL_Q_PT(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_FLOW_CTRL_Q_PT_SHIFT)) & ENET_MAC_TX_FLOW_CTRL_Q_PT_MASK)
/*! @} */

/* The count of ENET_MAC_TX_FLOW_CTRL_Q */
#define ENET_MAC_TX_FLOW_CTRL_Q_COUNT            (2U)

/*! @name MAC_RX_FLOW_CTRL - Receive flow control register */
/*! @{ */
#define ENET_MAC_RX_FLOW_CTRL_RFE_MASK           (0x1U)
#define ENET_MAC_RX_FLOW_CTRL_RFE_SHIFT          (0U)
/*! RFE - Receive Flow Control Enable When this bit is set and the MAC is operating in full-duplex
 *    mode, the MAC decodes the received Pause packet and disables its transmitter for a specified
 *    (Pause) time.
 */
#define ENET_MAC_RX_FLOW_CTRL_RFE(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RX_FLOW_CTRL_RFE_SHIFT)) & ENET_MAC_RX_FLOW_CTRL_RFE_MASK)
#define ENET_MAC_RX_FLOW_CTRL_UP_MASK            (0x2U)
#define ENET_MAC_RX_FLOW_CTRL_UP_SHIFT           (1U)
/*! UP - Unicast Pause Packet Detect A pause packet is processed when it has the unique multicast
 *    address specified in the IEEE 802.
 */
#define ENET_MAC_RX_FLOW_CTRL_UP(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RX_FLOW_CTRL_UP_SHIFT)) & ENET_MAC_RX_FLOW_CTRL_UP_MASK)
/*! @} */

/*! @name MAC_TXQ_PRIO_MAP -  */
/*! @{ */
#define ENET_MAC_TXQ_PRIO_MAP_PSTQ0_MASK         (0xFFU)
#define ENET_MAC_TXQ_PRIO_MAP_PSTQ0_SHIFT        (0U)
/*! PSTQ0 - Priorities Selected in Transmit Queue 0 This field holds the priorities assigned to Tx Queue 0 by the software.
 */
#define ENET_MAC_TXQ_PRIO_MAP_PSTQ0(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TXQ_PRIO_MAP_PSTQ0_SHIFT)) & ENET_MAC_TXQ_PRIO_MAP_PSTQ0_MASK)
#define ENET_MAC_TXQ_PRIO_MAP_PSTQ1_MASK         (0xFF00U)
#define ENET_MAC_TXQ_PRIO_MAP_PSTQ1_SHIFT        (8U)
/*! PSTQ1 - Priorities Selected in Transmit Queue 1 This bit is similar to the PSTQ0 bit.
 */
#define ENET_MAC_TXQ_PRIO_MAP_PSTQ1(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TXQ_PRIO_MAP_PSTQ1_SHIFT)) & ENET_MAC_TXQ_PRIO_MAP_PSTQ1_MASK)
/*! @} */

/*! @name MAC_RXQ_CTRL - Receive Queue Control 0 register 0x0000 */
/*! @{ */
#define ENET_MAC_RXQ_CTRL_AVCPQ_MASK             (0x7U)
#define ENET_MAC_RXQ_CTRL_AVCPQ_SHIFT            (0U)
/*! AVCPQ - AV Untagged Control Packets Queue.
 */
#define ENET_MAC_RXQ_CTRL_AVCPQ(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_AVCPQ_SHIFT)) & ENET_MAC_RXQ_CTRL_AVCPQ_MASK)
#define ENET_MAC_RXQ_CTRL_PSRQ0_MASK             (0xFFU)
#define ENET_MAC_RXQ_CTRL_PSRQ0_SHIFT            (0U)
/*! PSRQ0 - Priorities Selected in the Receive Queue 0.
 */
#define ENET_MAC_RXQ_CTRL_PSRQ0(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_PSRQ0_SHIFT)) & ENET_MAC_RXQ_CTRL_PSRQ0_MASK)
#define ENET_MAC_RXQ_CTRL_RXQ0EN_MASK            (0x3U)
#define ENET_MAC_RXQ_CTRL_RXQ0EN_SHIFT           (0U)
/*! RXQ0EN - Receive Queue 0 Enable.
 */
#define ENET_MAC_RXQ_CTRL_RXQ0EN(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_RXQ0EN_SHIFT)) & ENET_MAC_RXQ_CTRL_RXQ0EN_MASK)
#define ENET_MAC_RXQ_CTRL_RXQ1EN_MASK            (0xCU)
#define ENET_MAC_RXQ_CTRL_RXQ1EN_SHIFT           (2U)
/*! RXQ1EN - Receive Queue 1 Enable.
 */
#define ENET_MAC_RXQ_CTRL_RXQ1EN(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_RXQ1EN_SHIFT)) & ENET_MAC_RXQ_CTRL_RXQ1EN_MASK)
#define ENET_MAC_RXQ_CTRL_AVPTPQ_MASK            (0x70U)
#define ENET_MAC_RXQ_CTRL_AVPTPQ_SHIFT           (4U)
/*! AVPTPQ - AV PTP Packets Queue.
 */
#define ENET_MAC_RXQ_CTRL_AVPTPQ(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_AVPTPQ_SHIFT)) & ENET_MAC_RXQ_CTRL_AVPTPQ_MASK)
#define ENET_MAC_RXQ_CTRL_PSRQ1_MASK             (0xFF00U)
#define ENET_MAC_RXQ_CTRL_PSRQ1_SHIFT            (8U)
/*! PSRQ1 - Priorities Selected in the Receive Queue 1.
 */
#define ENET_MAC_RXQ_CTRL_PSRQ1(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_PSRQ1_SHIFT)) & ENET_MAC_RXQ_CTRL_PSRQ1_MASK)
#define ENET_MAC_RXQ_CTRL_UPQ_MASK               (0x7000U)
#define ENET_MAC_RXQ_CTRL_UPQ_SHIFT              (12U)
/*! UPQ - Untagged Packet Queue.
 */
#define ENET_MAC_RXQ_CTRL_UPQ(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_UPQ_SHIFT)) & ENET_MAC_RXQ_CTRL_UPQ_MASK)
#define ENET_MAC_RXQ_CTRL_MCBCQ_MASK             (0x70000U)
#define ENET_MAC_RXQ_CTRL_MCBCQ_SHIFT            (16U)
/*! MCBCQ - Multicast and Broadcast Queue.
 */
#define ENET_MAC_RXQ_CTRL_MCBCQ(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_MCBCQ_SHIFT)) & ENET_MAC_RXQ_CTRL_MCBCQ_MASK)
#define ENET_MAC_RXQ_CTRL_PSRQ2_MASK             (0xFF0000U)
#define ENET_MAC_RXQ_CTRL_PSRQ2_SHIFT            (16U)
/*! PSRQ2 - Priorities Selected in the Receive Queue 2.
 */
#define ENET_MAC_RXQ_CTRL_PSRQ2(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_PSRQ2_SHIFT)) & ENET_MAC_RXQ_CTRL_PSRQ2_MASK)
#define ENET_MAC_RXQ_CTRL_MCBCQEN_MASK           (0x100000U)
#define ENET_MAC_RXQ_CTRL_MCBCQEN_SHIFT          (20U)
/*! MCBCQEN - Multicast and Broadcast Queue Enable.
 */
#define ENET_MAC_RXQ_CTRL_MCBCQEN(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_MCBCQEN_SHIFT)) & ENET_MAC_RXQ_CTRL_MCBCQEN_MASK)
#define ENET_MAC_RXQ_CTRL_PSRQ3_MASK             (0xFF000000U)
#define ENET_MAC_RXQ_CTRL_PSRQ3_SHIFT            (24U)
/*! PSRQ3 - Priorities Selected in the Receive Queue 3.
 */
#define ENET_MAC_RXQ_CTRL_PSRQ3(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_PSRQ3_SHIFT)) & ENET_MAC_RXQ_CTRL_PSRQ3_MASK)
/*! @} */

/* The count of ENET_MAC_RXQ_CTRL */
#define ENET_MAC_RXQ_CTRL_COUNT                  (3U)

/*! @name MAC_INTR_STAT - Interrupt status register 0x0000 */
/*! @{ */
#define ENET_MAC_INTR_STAT_PHYIS_MASK            (0x8U)
#define ENET_MAC_INTR_STAT_PHYIS_SHIFT           (3U)
/*! PHYIS - PHY Interrupt.
 */
#define ENET_MAC_INTR_STAT_PHYIS(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTR_STAT_PHYIS_SHIFT)) & ENET_MAC_INTR_STAT_PHYIS_MASK)
#define ENET_MAC_INTR_STAT_PMTIS_MASK            (0x10U)
#define ENET_MAC_INTR_STAT_PMTIS_SHIFT           (4U)
/*! PMTIS - PMT Interrupt Status.
 */
#define ENET_MAC_INTR_STAT_PMTIS(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTR_STAT_PMTIS_SHIFT)) & ENET_MAC_INTR_STAT_PMTIS_MASK)
#define ENET_MAC_INTR_STAT_LPIIS_MASK            (0x20U)
#define ENET_MAC_INTR_STAT_LPIIS_SHIFT           (5U)
/*! LPIIS - LPI Interrupt Status.
 */
#define ENET_MAC_INTR_STAT_LPIIS(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTR_STAT_LPIIS_SHIFT)) & ENET_MAC_INTR_STAT_LPIIS_MASK)
#define ENET_MAC_INTR_STAT_TSIS_MASK             (0x1000U)
#define ENET_MAC_INTR_STAT_TSIS_SHIFT            (12U)
/*! TSIS - Timestamp interrupt status.
 */
#define ENET_MAC_INTR_STAT_TSIS(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTR_STAT_TSIS_SHIFT)) & ENET_MAC_INTR_STAT_TSIS_MASK)
#define ENET_MAC_INTR_STAT_TXSTSIS_MASK          (0x2000U)
#define ENET_MAC_INTR_STAT_TXSTSIS_SHIFT         (13U)
/*! TXSTSIS - Transmit Status Interrupt.
 */
#define ENET_MAC_INTR_STAT_TXSTSIS(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTR_STAT_TXSTSIS_SHIFT)) & ENET_MAC_INTR_STAT_TXSTSIS_MASK)
#define ENET_MAC_INTR_STAT_RXSTSIS_MASK          (0x4000U)
#define ENET_MAC_INTR_STAT_RXSTSIS_SHIFT         (14U)
/*! RXSTSIS - Receive Status Interrupt.
 */
#define ENET_MAC_INTR_STAT_RXSTSIS(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTR_STAT_RXSTSIS_SHIFT)) & ENET_MAC_INTR_STAT_RXSTSIS_MASK)
/*! @} */

/*! @name MAC_INTR_EN - Interrupt enable register 0x0000 */
/*! @{ */
#define ENET_MAC_INTR_EN_PHYIE_MASK              (0x8U)
#define ENET_MAC_INTR_EN_PHYIE_SHIFT             (3U)
/*! PHYIE - PHY Interrupt Enable.
 */
#define ENET_MAC_INTR_EN_PHYIE(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTR_EN_PHYIE_SHIFT)) & ENET_MAC_INTR_EN_PHYIE_MASK)
#define ENET_MAC_INTR_EN_PMTIE_MASK              (0x10U)
#define ENET_MAC_INTR_EN_PMTIE_SHIFT             (4U)
/*! PMTIE - PMT Interrupt Enable.
 */
#define ENET_MAC_INTR_EN_PMTIE(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTR_EN_PMTIE_SHIFT)) & ENET_MAC_INTR_EN_PMTIE_MASK)
#define ENET_MAC_INTR_EN_LPIIE_MASK              (0x20U)
#define ENET_MAC_INTR_EN_LPIIE_SHIFT             (5U)
/*! LPIIE - LPI Interrupt Enable.
 */
#define ENET_MAC_INTR_EN_LPIIE(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTR_EN_LPIIE_SHIFT)) & ENET_MAC_INTR_EN_LPIIE_MASK)
#define ENET_MAC_INTR_EN_TSIE_MASK               (0x1000U)
#define ENET_MAC_INTR_EN_TSIE_SHIFT              (12U)
/*! TSIE - Timestamp Interrupt Enable.
 */
#define ENET_MAC_INTR_EN_TSIE(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTR_EN_TSIE_SHIFT)) & ENET_MAC_INTR_EN_TSIE_MASK)
#define ENET_MAC_INTR_EN_TXSTSIE_MASK            (0x2000U)
#define ENET_MAC_INTR_EN_TXSTSIE_SHIFT           (13U)
/*! TXSTSIE - Transmit Status Interrupt Enable.
 */
#define ENET_MAC_INTR_EN_TXSTSIE(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTR_EN_TXSTSIE_SHIFT)) & ENET_MAC_INTR_EN_TXSTSIE_MASK)
#define ENET_MAC_INTR_EN_RXSTSIS_MASK            (0x4000U)
#define ENET_MAC_INTR_EN_RXSTSIS_SHIFT           (14U)
/*! RXSTSIS - Receive Status Interrupt Enable.
 */
#define ENET_MAC_INTR_EN_RXSTSIS(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTR_EN_RXSTSIS_SHIFT)) & ENET_MAC_INTR_EN_RXSTSIS_MASK)
/*! @} */

/*! @name MAC_RXTX_STAT - Receive Transmit Status register */
/*! @{ */
#define ENET_MAC_RXTX_STAT_TJT_MASK              (0x1U)
#define ENET_MAC_RXTX_STAT_TJT_SHIFT             (0U)
/*! TJT - PHY Interrupt Enable When this bit is set, it enables the assertion of the interrupt
 *    signal because of the setting of PHYIS bit in MAC Interrupt Status register Table 731.
 */
#define ENET_MAC_RXTX_STAT_TJT(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXTX_STAT_TJT_SHIFT)) & ENET_MAC_RXTX_STAT_TJT_MASK)
#define ENET_MAC_RXTX_STAT_NCARR_MASK            (0x2U)
#define ENET_MAC_RXTX_STAT_NCARR_SHIFT           (1U)
/*! NCARR - No Carrier When the DTXSTS bit is set in the MTL Operation Mode register Table 758, this
 *    bit indicates that the carrier signal from the PHY is not present at the end of preamble
 *    transmission.
 */
#define ENET_MAC_RXTX_STAT_NCARR(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXTX_STAT_NCARR_SHIFT)) & ENET_MAC_RXTX_STAT_NCARR_MASK)
#define ENET_MAC_RXTX_STAT_LCARR_MASK            (0x4U)
#define ENET_MAC_RXTX_STAT_LCARR_SHIFT           (2U)
/*! LCARR - Loss of Carrier When the DTXSTS bit is set in the MTL Operation Mode register Table 758,
 *    this bit indicates that the loss of carrier occurred during packet transmission, that is, the
 *    PHY Carrier signal was inactive for one or more transmission clock periods during packet
 *    transmission.
 */
#define ENET_MAC_RXTX_STAT_LCARR(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXTX_STAT_LCARR_SHIFT)) & ENET_MAC_RXTX_STAT_LCARR_MASK)
#define ENET_MAC_RXTX_STAT_EXDEF_MASK            (0x8U)
#define ENET_MAC_RXTX_STAT_EXDEF_SHIFT           (3U)
/*! EXDEF - Excessive Deferral When the DTXSTS bit is set in the MTL Operation Mode register Table
 *    758 and the DC bit is set in the MAC Configuration register Table 758, this bit indicates that
 *    the transmission ended because of excessive deferral of over 24,288 bit times (155,680 when
 *    Jumbo packet is enabled).
 */
#define ENET_MAC_RXTX_STAT_EXDEF(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXTX_STAT_EXDEF_SHIFT)) & ENET_MAC_RXTX_STAT_EXDEF_MASK)
#define ENET_MAC_RXTX_STAT_LCOL_MASK             (0x10U)
#define ENET_MAC_RXTX_STAT_LCOL_SHIFT            (4U)
/*! LCOL - Late Collision When the DTXSTS bit is set in the MTL Operation Mode register Table 758,
 *    this bit indicates that the packet transmission aborted because a collision occurred after the
 *    collision window (64 bytes including Preamble in MII mode).
 */
#define ENET_MAC_RXTX_STAT_LCOL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXTX_STAT_LCOL_SHIFT)) & ENET_MAC_RXTX_STAT_LCOL_MASK)
#define ENET_MAC_RXTX_STAT_EXCOL_MASK            (0x20U)
#define ENET_MAC_RXTX_STAT_EXCOL_SHIFT           (5U)
/*! EXCOL - Excessive Collisions When the DTXSTS bit is set in the MTL Operation Mode register Table
 *    758, this bit indicates that the transmission aborted after 16 successive collisions while
 *    attempting to transmit the current packet.
 */
#define ENET_MAC_RXTX_STAT_EXCOL(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXTX_STAT_EXCOL_SHIFT)) & ENET_MAC_RXTX_STAT_EXCOL_MASK)
#define ENET_MAC_RXTX_STAT_RWT_MASK              (0x100U)
#define ENET_MAC_RXTX_STAT_RWT_SHIFT             (8U)
/*! RWT - Receive Watchdog Timeout This bit is set when a packet with length greater than 2,048
 *    bytes is received (10,240 bytes when Jumbo Packet mode is enabled) and the WD bit is reset in the
 *    MAC Configuration register Table 722.
 */
#define ENET_MAC_RXTX_STAT_RWT(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXTX_STAT_RWT_SHIFT)) & ENET_MAC_RXTX_STAT_RWT_MASK)
/*! @} */

/*! @name MAC_PMT_CRTL_STAT -  */
/*! @{ */
#define ENET_MAC_PMT_CRTL_STAT_PWRDWN_MASK       (0x1U)
#define ENET_MAC_PMT_CRTL_STAT_PWRDWN_SHIFT      (0U)
/*! PWRDWN - Transmit LPI Entry When this bit is set, it indicates that the MAC Transmitter has
 *    entered the LPI state because of the setting of the LPIEN bit.
 */
#define ENET_MAC_PMT_CRTL_STAT_PWRDWN(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CRTL_STAT_PWRDWN_SHIFT)) & ENET_MAC_PMT_CRTL_STAT_PWRDWN_MASK)
#define ENET_MAC_PMT_CRTL_STAT_MGKPKTEN_MASK     (0x2U)
#define ENET_MAC_PMT_CRTL_STAT_MGKPKTEN_SHIFT    (1U)
/*! MGKPKTEN - Magic Packet Enable.
 */
#define ENET_MAC_PMT_CRTL_STAT_MGKPKTEN(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CRTL_STAT_MGKPKTEN_SHIFT)) & ENET_MAC_PMT_CRTL_STAT_MGKPKTEN_MASK)
#define ENET_MAC_PMT_CRTL_STAT_RWKPKTEN_MASK     (0x4U)
#define ENET_MAC_PMT_CRTL_STAT_RWKPKTEN_SHIFT    (2U)
/*! RWKPKTEN - Remote Wake-Up Packet Enable When this bit is set, a power management event is
 *    generated when the MAC receives a remote wake-up packet.
 */
#define ENET_MAC_PMT_CRTL_STAT_RWKPKTEN(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CRTL_STAT_RWKPKTEN_SHIFT)) & ENET_MAC_PMT_CRTL_STAT_RWKPKTEN_MASK)
#define ENET_MAC_PMT_CRTL_STAT_MGKPRCVD_MASK     (0x20U)
#define ENET_MAC_PMT_CRTL_STAT_MGKPRCVD_SHIFT    (5U)
/*! MGKPRCVD - Magic Packet Received.
 */
#define ENET_MAC_PMT_CRTL_STAT_MGKPRCVD(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CRTL_STAT_MGKPRCVD_SHIFT)) & ENET_MAC_PMT_CRTL_STAT_MGKPRCVD_MASK)
#define ENET_MAC_PMT_CRTL_STAT_RWKPRCVD_MASK     (0x40U)
#define ENET_MAC_PMT_CRTL_STAT_RWKPRCVD_SHIFT    (6U)
/*! RWKPRCVD - Remote Wake-Up Packet Received.
 */
#define ENET_MAC_PMT_CRTL_STAT_RWKPRCVD(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CRTL_STAT_RWKPRCVD_SHIFT)) & ENET_MAC_PMT_CRTL_STAT_RWKPRCVD_MASK)
#define ENET_MAC_PMT_CRTL_STAT_GLBLUCAST_MASK    (0x200U)
#define ENET_MAC_PMT_CRTL_STAT_GLBLUCAST_SHIFT   (9U)
/*! GLBLUCAST - Global Unicast When this bit set, any unicast packet filtered by the MAC (DAF)
 *    address recognition is detected as a remote wake-up packet.
 */
#define ENET_MAC_PMT_CRTL_STAT_GLBLUCAST(x)      (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CRTL_STAT_GLBLUCAST_SHIFT)) & ENET_MAC_PMT_CRTL_STAT_GLBLUCAST_MASK)
#define ENET_MAC_PMT_CRTL_STAT_RWKPFE_MASK       (0x400U)
#define ENET_MAC_PMT_CRTL_STAT_RWKPFE_SHIFT      (10U)
/*! RWKPFE - Remote Wake-up Packet Forwarding Enable When this bit is set along with RWKPKTEN, the
 *    MAC receiver drops all received frames until it receives the expected wake-up frame.
 */
#define ENET_MAC_PMT_CRTL_STAT_RWKPFE(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CRTL_STAT_RWKPFE_SHIFT)) & ENET_MAC_PMT_CRTL_STAT_RWKPFE_MASK)
#define ENET_MAC_PMT_CRTL_STAT_RWKPTR_MASK       (0x1F000000U)
#define ENET_MAC_PMT_CRTL_STAT_RWKPTR_SHIFT      (24U)
/*! RWKPTR - Remote Wake-up FIFO Pointer This field gives the current value (0 to 7) of the Remote
 *    Wake-up Packet Filter register pointer.
 */
#define ENET_MAC_PMT_CRTL_STAT_RWKPTR(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CRTL_STAT_RWKPTR_SHIFT)) & ENET_MAC_PMT_CRTL_STAT_RWKPTR_MASK)
#define ENET_MAC_PMT_CRTL_STAT_RWKFILTRST_MASK   (0x80000000U)
#define ENET_MAC_PMT_CRTL_STAT_RWKFILTRST_SHIFT  (31U)
/*! RWKFILTRST - Remote Wake-Up Packet Filter Register Pointer Reset When this bit is set, the
 *    remote wake-up packet filter register pointer is reset to 3'b000.
 */
#define ENET_MAC_PMT_CRTL_STAT_RWKFILTRST(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CRTL_STAT_RWKFILTRST_SHIFT)) & ENET_MAC_PMT_CRTL_STAT_RWKFILTRST_MASK)
/*! @} */

/*! @name MAC_RWAKE_FRFLT - Remote wake-up frame filter */
/*! @{ */
#define ENET_MAC_RWAKE_FRFLT_ADDR_MASK           (0xFFFFFFFFU)
#define ENET_MAC_RWAKE_FRFLT_ADDR_SHIFT          (0U)
/*! ADDR - WKUPFMFILTER address.
 */
#define ENET_MAC_RWAKE_FRFLT_ADDR(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RWAKE_FRFLT_ADDR_SHIFT)) & ENET_MAC_RWAKE_FRFLT_ADDR_MASK)
/*! @} */

/*! @name MAC_LPI_CTRL_STAT - LPI Control and Status Register */
/*! @{ */
#define ENET_MAC_LPI_CTRL_STAT_TLPIEN_MASK       (0x1U)
#define ENET_MAC_LPI_CTRL_STAT_TLPIEN_SHIFT      (0U)
/*! TLPIEN - Transmit LPI Entry When this bit is set, it indicates that the MAC Transmitter has
 *    entered the LPI state because of the setting of the LPIEN bit.
 */
#define ENET_MAC_LPI_CTRL_STAT_TLPIEN(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CTRL_STAT_TLPIEN_SHIFT)) & ENET_MAC_LPI_CTRL_STAT_TLPIEN_MASK)
#define ENET_MAC_LPI_CTRL_STAT_TLPIEX_MASK       (0x2U)
#define ENET_MAC_LPI_CTRL_STAT_TLPIEX_SHIFT      (1U)
/*! TLPIEX - Transmit LPI Exit When this bit is set, it indicates that the MAC transmitter exited
 *    the LPI state after the application cleared the LPIEN bit and the LPI TW Timer has expired.
 */
#define ENET_MAC_LPI_CTRL_STAT_TLPIEX(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CTRL_STAT_TLPIEX_SHIFT)) & ENET_MAC_LPI_CTRL_STAT_TLPIEX_MASK)
#define ENET_MAC_LPI_CTRL_STAT_RLPIEN_MASK       (0x4U)
#define ENET_MAC_LPI_CTRL_STAT_RLPIEN_SHIFT      (2U)
/*! RLPIEN - Receive LPI Entry When this bit is set, it indicates that the MAC Receiver has received
 *    an LPI pattern and entered the LPI state.
 */
#define ENET_MAC_LPI_CTRL_STAT_RLPIEN(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CTRL_STAT_RLPIEN_SHIFT)) & ENET_MAC_LPI_CTRL_STAT_RLPIEN_MASK)
#define ENET_MAC_LPI_CTRL_STAT_RLPIEX_MASK       (0x8U)
#define ENET_MAC_LPI_CTRL_STAT_RLPIEX_SHIFT      (3U)
/*! RLPIEX - Receive LPI Exit When this bit is set, it indicates that the MAC Receiver has stopped
 *    receiving the LPI pattern on the MII interface, exited the LPI state, and resumed the normal
 *    reception.
 */
#define ENET_MAC_LPI_CTRL_STAT_RLPIEX(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CTRL_STAT_RLPIEX_SHIFT)) & ENET_MAC_LPI_CTRL_STAT_RLPIEX_MASK)
#define ENET_MAC_LPI_CTRL_STAT_TLPIST_MASK       (0x100U)
#define ENET_MAC_LPI_CTRL_STAT_TLPIST_SHIFT      (8U)
/*! TLPIST - Transmit LPI State When this bit is set, it indicates that the MAC is transmitting the LPI pattern on the MII interface.
 */
#define ENET_MAC_LPI_CTRL_STAT_TLPIST(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CTRL_STAT_TLPIST_SHIFT)) & ENET_MAC_LPI_CTRL_STAT_TLPIST_MASK)
#define ENET_MAC_LPI_CTRL_STAT_RLPIST_MASK       (0x200U)
#define ENET_MAC_LPI_CTRL_STAT_RLPIST_SHIFT      (9U)
/*! RLPIST - Receive LPI State When this bit is set, it indicates that the MAC is receiving the LPI pattern on the MII interface.
 */
#define ENET_MAC_LPI_CTRL_STAT_RLPIST(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CTRL_STAT_RLPIST_SHIFT)) & ENET_MAC_LPI_CTRL_STAT_RLPIST_MASK)
#define ENET_MAC_LPI_CTRL_STAT_LPIEN_MASK        (0x10000U)
#define ENET_MAC_LPI_CTRL_STAT_LPIEN_SHIFT       (16U)
/*! LPIEN - LPI Enable When this bit is set, it instructs the MAC Transmitter to enter the LPI state.
 */
#define ENET_MAC_LPI_CTRL_STAT_LPIEN(x)          (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CTRL_STAT_LPIEN_SHIFT)) & ENET_MAC_LPI_CTRL_STAT_LPIEN_MASK)
#define ENET_MAC_LPI_CTRL_STAT_PLS_MASK          (0x20000U)
#define ENET_MAC_LPI_CTRL_STAT_PLS_SHIFT         (17U)
/*! PLS - PHY Link Status This bit indicates the link status of the PHY.
 */
#define ENET_MAC_LPI_CTRL_STAT_PLS(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CTRL_STAT_PLS_SHIFT)) & ENET_MAC_LPI_CTRL_STAT_PLS_MASK)
#define ENET_MAC_LPI_CTRL_STAT_LPITXA_MASK       (0x80000U)
#define ENET_MAC_LPI_CTRL_STAT_LPITXA_SHIFT      (19U)
/*! LPITXA - LPI Tx Automate This bit controls the behavior of the MAC when it is entering or coming
 *    out of the LPI mode on the Transmit side.
 */
#define ENET_MAC_LPI_CTRL_STAT_LPITXA(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CTRL_STAT_LPITXA_SHIFT)) & ENET_MAC_LPI_CTRL_STAT_LPITXA_MASK)
#define ENET_MAC_LPI_CTRL_STAT_LPIATE_MASK       (0x100000U)
#define ENET_MAC_LPI_CTRL_STAT_LPIATE_SHIFT      (20U)
/*! LPIATE - LPI Timer Enable This bit controls the automatic entry of the MAC Transmitter into and exit out of the LPI state.
 */
#define ENET_MAC_LPI_CTRL_STAT_LPIATE(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CTRL_STAT_LPIATE_SHIFT)) & ENET_MAC_LPI_CTRL_STAT_LPIATE_MASK)
#define ENET_MAC_LPI_CTRL_STAT_LPITCSE_MASK      (0x200000U)
#define ENET_MAC_LPI_CTRL_STAT_LPITCSE_SHIFT     (21U)
/*! LPITCSE - LPI Tx Clock Stop Enable When this bit is set, the MAC asserts LPI Tx Clock Gating
 *    Control signal high after it enters Tx LPI mode to indicate that the Tx clock to MAC can be
 *    stopped.
 */
#define ENET_MAC_LPI_CTRL_STAT_LPITCSE(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CTRL_STAT_LPITCSE_SHIFT)) & ENET_MAC_LPI_CTRL_STAT_LPITCSE_MASK)
/*! @} */

/*! @name MAC_LPI_TIMER_CTRL - LPI Timers Control register */
/*! @{ */
#define ENET_MAC_LPI_TIMER_CTRL_TWT_MASK         (0xFFFFU)
#define ENET_MAC_LPI_TIMER_CTRL_TWT_SHIFT        (0U)
/*! TWT - LPI TW Timer This field specifies the minimum time (in microseconds) for which the MAC
 *    waits after it stops transmitting the LPI pattern to the PHY and before it resumes the normal
 *    transmission.
 */
#define ENET_MAC_LPI_TIMER_CTRL_TWT(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_TIMER_CTRL_TWT_SHIFT)) & ENET_MAC_LPI_TIMER_CTRL_TWT_MASK)
#define ENET_MAC_LPI_TIMER_CTRL_LST_MASK         (0x3FF0000U)
#define ENET_MAC_LPI_TIMER_CTRL_LST_SHIFT        (16U)
/*! LST - LPI LS Timer This field specifies the minimum time (in milliseconds) for which the link
 *    status from the PHY should be up (OKAY) before the LPI pattern can be transmitted to the PHY.
 */
#define ENET_MAC_LPI_TIMER_CTRL_LST(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_TIMER_CTRL_LST_SHIFT)) & ENET_MAC_LPI_TIMER_CTRL_LST_MASK)
/*! @} */

/*! @name MAC_LPI_ENTR_TIMR - LPI entry Timer register */
/*! @{ */
#define ENET_MAC_LPI_ENTR_TIMR_LPIET_MASK        (0xFFFF8U)
#define ENET_MAC_LPI_ENTR_TIMR_LPIET_SHIFT       (3U)
/*! LPIET - LPI Entry Timer This field specifies the time in microseconds the MAC will wait to enter
 *    LPI mode, after it has transmitted all the frames.
 */
#define ENET_MAC_LPI_ENTR_TIMR_LPIET(x)          (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_ENTR_TIMR_LPIET_SHIFT)) & ENET_MAC_LPI_ENTR_TIMR_LPIET_MASK)
/*! @} */

/*! @name MAC_1US_TIC_COUNTR -  */
/*! @{ */
#define ENET_MAC_1US_TIC_COUNTR_TIC_1US_CNTR_MASK (0xFFFU)
#define ENET_MAC_1US_TIC_COUNTR_TIC_1US_CNTR_SHIFT (0U)
/*! TIC_1US_CNTR - 1US TIC Counter The application must program this counter so that the number of clock cycles of CSR clock is 1us.
 */
#define ENET_MAC_1US_TIC_COUNTR_TIC_1US_CNTR(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_1US_TIC_COUNTR_TIC_1US_CNTR_SHIFT)) & ENET_MAC_1US_TIC_COUNTR_TIC_1US_CNTR_MASK)
/*! @} */

/*! @name MAC_VERSION - MAC version register */
/*! @{ */
#define ENET_MAC_VERSION_SNPVER_MASK             (0xFFU)
#define ENET_MAC_VERSION_SNPVER_SHIFT            (0U)
/*! SNPVER - NXP defined version.
 */
#define ENET_MAC_VERSION_SNPVER(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VERSION_SNPVER_SHIFT)) & ENET_MAC_VERSION_SNPVER_MASK)
#define ENET_MAC_VERSION_USERVER_MASK            (0xFF00U)
#define ENET_MAC_VERSION_USERVER_SHIFT           (8U)
/*! USERVER - User defined version.
 */
#define ENET_MAC_VERSION_USERVER(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VERSION_USERVER_SHIFT)) & ENET_MAC_VERSION_USERVER_MASK)
/*! @} */

/*! @name MAC_DBG - MAC debug register */
/*! @{ */
#define ENET_MAC_DBG_REPESTS_MASK                (0x1U)
#define ENET_MAC_DBG_REPESTS_SHIFT               (0U)
/*! REPESTS - MAC MII Receive Protocol Engine Status When this bit is set, it indicates that the MAC
 *    MII receive protocol engine is actively receiving data, and it is not in the Idle state.
 */
#define ENET_MAC_DBG_REPESTS(x)                  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_DBG_REPESTS_SHIFT)) & ENET_MAC_DBG_REPESTS_MASK)
#define ENET_MAC_DBG_RFCFCSTS_MASK               (0x6U)
#define ENET_MAC_DBG_RFCFCSTS_SHIFT              (1U)
/*! RFCFCSTS - MAC Receive Packet Controller FIFO Status When this bit is set, this field indicates
 *    the active state of the small FIFO Read and Write controllers of the MAC Receive Packet
 *    Controller module.
 */
#define ENET_MAC_DBG_RFCFCSTS(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_DBG_RFCFCSTS_SHIFT)) & ENET_MAC_DBG_RFCFCSTS_MASK)
#define ENET_MAC_DBG_TPESTS_MASK                 (0x10000U)
#define ENET_MAC_DBG_TPESTS_SHIFT                (16U)
/*! TPESTS - MAC MII Transmit Protocol Engine Status When this bit is set, it indicates that the MAC
 *    or MII transmit protocol engine is actively transmitting data, and it is not in the Idle
 *    state.
 */
#define ENET_MAC_DBG_TPESTS(x)                   (((uint32_t)(((uint32_t)(x)) << ENET_MAC_DBG_TPESTS_SHIFT)) & ENET_MAC_DBG_TPESTS_MASK)
#define ENET_MAC_DBG_TFCSTS_MASK                 (0x60000U)
#define ENET_MAC_DBG_TFCSTS_SHIFT                (17U)
/*! TFCSTS - MAC Transmit Packet Controller Status This field indicates the state of the MAC Transmit Packet Controller module.
 */
#define ENET_MAC_DBG_TFCSTS(x)                   (((uint32_t)(((uint32_t)(x)) << ENET_MAC_DBG_TFCSTS_SHIFT)) & ENET_MAC_DBG_TFCSTS_MASK)
/*! @} */

/*! @name MAC_HW_FEAT - MAC hardware feature register 0x0201 */
/*! @{ */
#define ENET_MAC_HW_FEAT_MIISEL_MASK             (0x1U)
#define ENET_MAC_HW_FEAT_MIISEL_SHIFT            (0U)
/*! MIISEL - 10 or 100 Mbps Support.
 */
#define ENET_MAC_HW_FEAT_MIISEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_MIISEL_SHIFT)) & ENET_MAC_HW_FEAT_MIISEL_MASK)
#define ENET_MAC_HW_FEAT_RXFIFOSIZE_MASK         (0x1FU)
#define ENET_MAC_HW_FEAT_RXFIFOSIZE_SHIFT        (0U)
/*! RXFIFOSIZE - MTL Receive FIFO Size.
 */
#define ENET_MAC_HW_FEAT_RXFIFOSIZE(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_RXFIFOSIZE_SHIFT)) & ENET_MAC_HW_FEAT_RXFIFOSIZE_MASK)
#define ENET_MAC_HW_FEAT_RXQCNT_MASK             (0xFU)
#define ENET_MAC_HW_FEAT_RXQCNT_SHIFT            (0U)
/*! RXQCNT - Number of MTL Receive Queues.
 */
#define ENET_MAC_HW_FEAT_RXQCNT(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_RXQCNT_SHIFT)) & ENET_MAC_HW_FEAT_RXQCNT_MASK)
#define ENET_MAC_HW_FEAT_HDSEL_MASK              (0x4U)
#define ENET_MAC_HW_FEAT_HDSEL_SHIFT             (2U)
/*! HDSEL - Half-duplex Support.
 */
#define ENET_MAC_HW_FEAT_HDSEL(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_HDSEL_SHIFT)) & ENET_MAC_HW_FEAT_HDSEL_MASK)
#define ENET_MAC_HW_FEAT_VLHASH_MASK             (0x10U)
#define ENET_MAC_HW_FEAT_VLHASH_SHIFT            (4U)
/*! VLHASH - Hash Table Based Filtering option.
 */
#define ENET_MAC_HW_FEAT_VLHASH(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_VLHASH_SHIFT)) & ENET_MAC_HW_FEAT_VLHASH_MASK)
#define ENET_MAC_HW_FEAT_SMASEL_MASK             (0x20U)
#define ENET_MAC_HW_FEAT_SMASEL_SHIFT            (5U)
/*! SMASEL - SMA (MDIO) Interface.
 */
#define ENET_MAC_HW_FEAT_SMASEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_SMASEL_SHIFT)) & ENET_MAC_HW_FEAT_SMASEL_MASK)
#define ENET_MAC_HW_FEAT_RWKSEL_MASK             (0x40U)
#define ENET_MAC_HW_FEAT_RWKSEL_SHIFT            (6U)
/*! RWKSEL - PMT Remote Wake-up Packet Detection.
 */
#define ENET_MAC_HW_FEAT_RWKSEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_RWKSEL_SHIFT)) & ENET_MAC_HW_FEAT_RWKSEL_MASK)
#define ENET_MAC_HW_FEAT_TXFIFOSIZE_MASK         (0x7C0U)
#define ENET_MAC_HW_FEAT_TXFIFOSIZE_SHIFT        (6U)
/*! TXFIFOSIZE - MTL Transmit FIFO Size.
 */
#define ENET_MAC_HW_FEAT_TXFIFOSIZE(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TXFIFOSIZE_SHIFT)) & ENET_MAC_HW_FEAT_TXFIFOSIZE_MASK)
#define ENET_MAC_HW_FEAT_TXQCNT_MASK             (0x3C0U)
#define ENET_MAC_HW_FEAT_TXQCNT_SHIFT            (6U)
/*! TXQCNT - Number of MTL Transmit Queues.
 */
#define ENET_MAC_HW_FEAT_TXQCNT(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TXQCNT_SHIFT)) & ENET_MAC_HW_FEAT_TXQCNT_MASK)
#define ENET_MAC_HW_FEAT_MGKSEL_MASK             (0x80U)
#define ENET_MAC_HW_FEAT_MGKSEL_SHIFT            (7U)
/*! MGKSEL - PMT magic packet detection.
 */
#define ENET_MAC_HW_FEAT_MGKSEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_MGKSEL_SHIFT)) & ENET_MAC_HW_FEAT_MGKSEL_MASK)
#define ENET_MAC_HW_FEAT_MMCSEL_MASK             (0x100U)
#define ENET_MAC_HW_FEAT_MMCSEL_SHIFT            (8U)
/*! MMCSEL - RMON Module Enable.
 */
#define ENET_MAC_HW_FEAT_MMCSEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_MMCSEL_SHIFT)) & ENET_MAC_HW_FEAT_MMCSEL_MASK)
#define ENET_MAC_HW_FEAT_ARPOFFSEL_MASK          (0x200U)
#define ENET_MAC_HW_FEAT_ARPOFFSEL_SHIFT         (9U)
/*! ARPOFFSEL - ARP Offload Enabled.
 */
#define ENET_MAC_HW_FEAT_ARPOFFSEL(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_ARPOFFSEL_SHIFT)) & ENET_MAC_HW_FEAT_ARPOFFSEL_MASK)
#define ENET_MAC_HW_FEAT_OSTEN_MASK              (0x800U)
#define ENET_MAC_HW_FEAT_OSTEN_SHIFT             (11U)
/*! OSTEN - One-Step Timestamping Feature.
 */
#define ENET_MAC_HW_FEAT_OSTEN(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_OSTEN_SHIFT)) & ENET_MAC_HW_FEAT_OSTEN_MASK)
#define ENET_MAC_HW_FEAT_PTOEN_MASK              (0x1000U)
#define ENET_MAC_HW_FEAT_PTOEN_SHIFT             (12U)
/*! PTOEN - PTP OffLoad Feature.
 */
#define ENET_MAC_HW_FEAT_PTOEN(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_PTOEN_SHIFT)) & ENET_MAC_HW_FEAT_PTOEN_MASK)
#define ENET_MAC_HW_FEAT_RXCHCNT_MASK            (0xF000U)
#define ENET_MAC_HW_FEAT_RXCHCNT_SHIFT           (12U)
/*! RXCHCNT - Number of DMA Receive Channels.
 */
#define ENET_MAC_HW_FEAT_RXCHCNT(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_RXCHCNT_SHIFT)) & ENET_MAC_HW_FEAT_RXCHCNT_MASK)
#define ENET_MAC_HW_FEAT_TSSEL_MASK              (0x1000U)
#define ENET_MAC_HW_FEAT_TSSEL_SHIFT             (12U)
/*! TSSEL - IEEE 1588-2008 Timestamp support .
 */
#define ENET_MAC_HW_FEAT_TSSEL(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TSSEL_SHIFT)) & ENET_MAC_HW_FEAT_TSSEL_MASK)
#define ENET_MAC_HW_FEAT_ADVTHWORD_MASK          (0x2000U)
#define ENET_MAC_HW_FEAT_ADVTHWORD_SHIFT         (13U)
/*! ADVTHWORD - IEEE 1588 High Word Register Feature.
 */
#define ENET_MAC_HW_FEAT_ADVTHWORD(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_ADVTHWORD_SHIFT)) & ENET_MAC_HW_FEAT_ADVTHWORD_MASK)
#define ENET_MAC_HW_FEAT_EEESEL_MASK             (0x2000U)
#define ENET_MAC_HW_FEAT_EEESEL_SHIFT            (13U)
/*! EEESEL - Energy Efficient Ethernet Support .
 */
#define ENET_MAC_HW_FEAT_EEESEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_EEESEL_SHIFT)) & ENET_MAC_HW_FEAT_EEESEL_MASK)
#define ENET_MAC_HW_FEAT_ADDR64_MASK             (0xC000U)
#define ENET_MAC_HW_FEAT_ADDR64_SHIFT            (14U)
/*! ADDR64 - Address width.
 */
#define ENET_MAC_HW_FEAT_ADDR64(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_ADDR64_SHIFT)) & ENET_MAC_HW_FEAT_ADDR64_MASK)
#define ENET_MAC_HW_FEAT_TXCOESEL_MASK           (0x4000U)
#define ENET_MAC_HW_FEAT_TXCOESEL_SHIFT          (14U)
/*! TXCOESEL - Transmit Checksum Offload Support.
 */
#define ENET_MAC_HW_FEAT_TXCOESEL(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TXCOESEL_SHIFT)) & ENET_MAC_HW_FEAT_TXCOESEL_MASK)
#define ENET_MAC_HW_FEAT_DCBEN_MASK              (0x10000U)
#define ENET_MAC_HW_FEAT_DCBEN_SHIFT             (16U)
/*! DCBEN - Data Center Bridging feature.
 */
#define ENET_MAC_HW_FEAT_DCBEN(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_DCBEN_SHIFT)) & ENET_MAC_HW_FEAT_DCBEN_MASK)
#define ENET_MAC_HW_FEAT_RXCOESEL_MASK           (0x10000U)
#define ENET_MAC_HW_FEAT_RXCOESEL_SHIFT          (16U)
/*! RXCOESEL - Receive Checksum Offload Support.
 */
#define ENET_MAC_HW_FEAT_RXCOESEL(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_RXCOESEL_SHIFT)) & ENET_MAC_HW_FEAT_RXCOESEL_MASK)
#define ENET_MAC_HW_FEAT_SPEN_MASK               (0x20000U)
#define ENET_MAC_HW_FEAT_SPEN_SHIFT              (17U)
/*! SPEN - Split Header Structure feature.
 */
#define ENET_MAC_HW_FEAT_SPEN(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_SPEN_SHIFT)) & ENET_MAC_HW_FEAT_SPEN_MASK)
#define ENET_MAC_HW_FEAT_TSOEN_MASK              (0x40000U)
#define ENET_MAC_HW_FEAT_TSOEN_SHIFT             (18U)
/*! TSOEN - TCP Segment Offload Feature.
 */
#define ENET_MAC_HW_FEAT_TSOEN(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TSOEN_SHIFT)) & ENET_MAC_HW_FEAT_TSOEN_MASK)
#define ENET_MAC_HW_FEAT_TXCHCNT_MASK            (0x3C0000U)
#define ENET_MAC_HW_FEAT_TXCHCNT_SHIFT           (18U)
/*! TXCHCNT - Number of DMA Transmit Channels.
 */
#define ENET_MAC_HW_FEAT_TXCHCNT(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TXCHCNT_SHIFT)) & ENET_MAC_HW_FEAT_TXCHCNT_MASK)
#define ENET_MAC_HW_FEAT_DBGMEMA_MASK            (0x80000U)
#define ENET_MAC_HW_FEAT_DBGMEMA_SHIFT           (19U)
/*! DBGMEMA - DMA Debug Register Feature.
 */
#define ENET_MAC_HW_FEAT_DBGMEMA(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_DBGMEMA_SHIFT)) & ENET_MAC_HW_FEAT_DBGMEMA_MASK)
#define ENET_MAC_HW_FEAT_AVSEL_MASK              (0x100000U)
#define ENET_MAC_HW_FEAT_AVSEL_SHIFT             (20U)
/*! AVSEL - Audio Video Bridging Feature.
 */
#define ENET_MAC_HW_FEAT_AVSEL(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_AVSEL_SHIFT)) & ENET_MAC_HW_FEAT_AVSEL_MASK)
#define ENET_MAC_HW_FEAT_LPMODEEN_MASK           (0x800000U)
#define ENET_MAC_HW_FEAT_LPMODEEN_SHIFT          (23U)
/*! LPMODEEN - Low Power Mode Feature Support .
 */
#define ENET_MAC_HW_FEAT_LPMODEEN(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_LPMODEEN_SHIFT)) & ENET_MAC_HW_FEAT_LPMODEEN_MASK)
#define ENET_MAC_HW_FEAT_HASHTBLSZ_MASK          (0x3000000U)
#define ENET_MAC_HW_FEAT_HASHTBLSZ_SHIFT         (24U)
/*! HASHTBLSZ - Hash Table Size.
 */
#define ENET_MAC_HW_FEAT_HASHTBLSZ(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_HASHTBLSZ_SHIFT)) & ENET_MAC_HW_FEAT_HASHTBLSZ_MASK)
#define ENET_MAC_HW_FEAT_PPSOUTNUM_MASK          (0x7000000U)
#define ENET_MAC_HW_FEAT_PPSOUTNUM_SHIFT         (24U)
/*! PPSOUTNUM - Number of PPS Outputs.
 */
#define ENET_MAC_HW_FEAT_PPSOUTNUM(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_PPSOUTNUM_SHIFT)) & ENET_MAC_HW_FEAT_PPSOUTNUM_MASK)
#define ENET_MAC_HW_FEAT_TSSTSSEL_MASK           (0x6000000U)
#define ENET_MAC_HW_FEAT_TSSTSSEL_SHIFT          (25U)
/*! TSSTSSEL - Timestamp System Time Source.
 */
#define ENET_MAC_HW_FEAT_TSSTSSEL(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TSSTSSEL_SHIFT)) & ENET_MAC_HW_FEAT_TSSTSSEL_MASK)
#define ENET_MAC_HW_FEAT_L3_L4_FILTER_MASK       (0x78000000U)
#define ENET_MAC_HW_FEAT_L3_L4_FILTER_SHIFT      (27U)
/*! L3_L4_FILTER - Total Number of L3 and L4 Filters .
 */
#define ENET_MAC_HW_FEAT_L3_L4_FILTER(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_L3_L4_FILTER_SHIFT)) & ENET_MAC_HW_FEAT_L3_L4_FILTER_MASK)
#define ENET_MAC_HW_FEAT_ACTPHYSEL_MASK          (0x70000000U)
#define ENET_MAC_HW_FEAT_ACTPHYSEL_SHIFT         (28U)
/*! ACTPHYSEL - Active PHY Selected.
 */
#define ENET_MAC_HW_FEAT_ACTPHYSEL(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_ACTPHYSEL_SHIFT)) & ENET_MAC_HW_FEAT_ACTPHYSEL_MASK)
#define ENET_MAC_HW_FEAT_AUXSNAPNUM_MASK         (0x70000000U)
#define ENET_MAC_HW_FEAT_AUXSNAPNUM_SHIFT        (28U)
/*! AUXSNAPNUM - Number of Auxiliary Snapshot Inputs.
 */
#define ENET_MAC_HW_FEAT_AUXSNAPNUM(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_AUXSNAPNUM_SHIFT)) & ENET_MAC_HW_FEAT_AUXSNAPNUM_MASK)
/*! @} */

/* The count of ENET_MAC_HW_FEAT */
#define ENET_MAC_HW_FEAT_COUNT                   (3U)

/*! @name MAC_MDIO_ADDR - MIDO address Register */
/*! @{ */
#define ENET_MAC_MDIO_ADDR_MB_MASK               (0x1U)
#define ENET_MAC_MDIO_ADDR_MB_SHIFT              (0U)
/*! MB - MII busy.
 */
#define ENET_MAC_MDIO_ADDR_MB(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDR_MB_SHIFT)) & ENET_MAC_MDIO_ADDR_MB_MASK)
#define ENET_MAC_MDIO_ADDR_MOC_MASK              (0xCU)
#define ENET_MAC_MDIO_ADDR_MOC_SHIFT             (2U)
/*! MOC - MII Operation Command.
 */
#define ENET_MAC_MDIO_ADDR_MOC(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDR_MOC_SHIFT)) & ENET_MAC_MDIO_ADDR_MOC_MASK)
#define ENET_MAC_MDIO_ADDR_CR_MASK               (0xF00U)
#define ENET_MAC_MDIO_ADDR_CR_SHIFT              (8U)
/*! CR - CSR Clock Range.
 */
#define ENET_MAC_MDIO_ADDR_CR(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDR_CR_SHIFT)) & ENET_MAC_MDIO_ADDR_CR_MASK)
#define ENET_MAC_MDIO_ADDR_NTC_MASK              (0x7000U)
#define ENET_MAC_MDIO_ADDR_NTC_SHIFT             (12U)
/*! NTC - Number of Training Clocks This field controls the number of trailing clock cycles
 *    generated on MDC after the end of transmission of MDIO frame.
 */
#define ENET_MAC_MDIO_ADDR_NTC(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDR_NTC_SHIFT)) & ENET_MAC_MDIO_ADDR_NTC_MASK)
#define ENET_MAC_MDIO_ADDR_RDA_MASK              (0x1F0000U)
#define ENET_MAC_MDIO_ADDR_RDA_SHIFT             (16U)
/*! RDA - Register/Device Address These bits select the PHY register in selected PHY device.
 */
#define ENET_MAC_MDIO_ADDR_RDA(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDR_RDA_SHIFT)) & ENET_MAC_MDIO_ADDR_RDA_MASK)
#define ENET_MAC_MDIO_ADDR_PA_MASK               (0x3E00000U)
#define ENET_MAC_MDIO_ADDR_PA_SHIFT              (21U)
/*! PA - Physical Layer Address This field indicates which PHY devices (out of 32 devices) the MAC is accessing.
 */
#define ENET_MAC_MDIO_ADDR_PA(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDR_PA_SHIFT)) & ENET_MAC_MDIO_ADDR_PA_MASK)
#define ENET_MAC_MDIO_ADDR_BTB_MASK              (0x4000000U)
#define ENET_MAC_MDIO_ADDR_BTB_SHIFT             (26U)
/*! BTB - Back to Back transactions When this bit is set and the NTC has value greater than 0, then
 *    the MAC will inform the completion of a read or write command at the end of frame transfer
 *    (before the trailing clocks are transmitted).
 */
#define ENET_MAC_MDIO_ADDR_BTB(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDR_BTB_SHIFT)) & ENET_MAC_MDIO_ADDR_BTB_MASK)
#define ENET_MAC_MDIO_ADDR_PSE_MASK              (0x8000000U)
#define ENET_MAC_MDIO_ADDR_PSE_SHIFT             (27U)
/*! PSE - Preamble Suppression Enable When this bit is set, the SMA will suppress the 32-bit
 *    preamble and transmit MDIO frames with only 1 preamble bit.
 */
#define ENET_MAC_MDIO_ADDR_PSE(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDR_PSE_SHIFT)) & ENET_MAC_MDIO_ADDR_PSE_MASK)
/*! @} */

/*! @name MAC_MDIO_DATA - MDIO Data register */
/*! @{ */
#define ENET_MAC_MDIO_DATA_MD_MASK               (0xFFFFU)
#define ENET_MAC_MDIO_DATA_MD_SHIFT              (0U)
/*! MD - MII Data This field contains the 16-bit data value read from the PHY after a Management
 *    Read operation or the 16-bit data value to be written to the PHY before a Management Write
 *    operation.
 */
#define ENET_MAC_MDIO_DATA_MD(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_DATA_MD_SHIFT)) & ENET_MAC_MDIO_DATA_MD_MASK)
/*! @} */

/*! @name MAC_ADDR_HIGH - MAC address0 high register */
/*! @{ */
#define ENET_MAC_ADDR_HIGH_A47_32_MASK           (0xFFFFU)
#define ENET_MAC_ADDR_HIGH_A47_32_SHIFT          (0U)
/*! A47_32 - MAC Address0 [47:32] This field contains the upper 16 bits (47:32) of the 6-byte first MAC address.
 */
#define ENET_MAC_ADDR_HIGH_A47_32(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_ADDR_HIGH_A47_32_SHIFT)) & ENET_MAC_ADDR_HIGH_A47_32_MASK)
#define ENET_MAC_ADDR_HIGH_DCS_MASK              (0x10000U)
#define ENET_MAC_ADDR_HIGH_DCS_SHIFT             (16U)
/*! DCS - DMA Channel Select This field contains the DMA Channel number to which the Rx packet whose
 *    DA matches the MAC Address content is routed.
 */
#define ENET_MAC_ADDR_HIGH_DCS(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_ADDR_HIGH_DCS_SHIFT)) & ENET_MAC_ADDR_HIGH_DCS_MASK)
#define ENET_MAC_ADDR_HIGH_AE_MASK               (0x80000000U)
#define ENET_MAC_ADDR_HIGH_AE_SHIFT              (31U)
/*! AE - Address Enable.
 */
#define ENET_MAC_ADDR_HIGH_AE(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_ADDR_HIGH_AE_SHIFT)) & ENET_MAC_ADDR_HIGH_AE_MASK)
/*! @} */

/*! @name MAC_ADDR_LOW - MAC address0 low register */
/*! @{ */
#define ENET_MAC_ADDR_LOW_A31_0_MASK             (0xFFFFFFFFU)
#define ENET_MAC_ADDR_LOW_A31_0_SHIFT            (0U)
/*! A31_0 - MAC Address0 [31:0] This field contains the lower 32 bits of the 6-byte first MAC address.
 */
#define ENET_MAC_ADDR_LOW_A31_0(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_ADDR_LOW_A31_0_SHIFT)) & ENET_MAC_ADDR_LOW_A31_0_MASK)
/*! @} */

/*! @name MAC_TIMESTAMP_CTRL - Time stamp control register */
/*! @{ */
#define ENET_MAC_TIMESTAMP_CTRL_TSENA_MASK       (0x1U)
#define ENET_MAC_TIMESTAMP_CTRL_TSENA_SHIFT      (0U)
/*! TSENA - Enable Timestamp When this bit is set, the timestamp is added for Transmit and Receive packets.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TSENA(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TSENA_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TSENA_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TSCFUPDT_MASK    (0x2U)
#define ENET_MAC_TIMESTAMP_CTRL_TSCFUPDT_SHIFT   (1U)
/*! TSCFUPDT - Fine or Coarse Timestamp Update When this bit is set, the Fine method is used to update system timestamp.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TSCFUPDT(x)      (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TSCFUPDT_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TSCFUPDT_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TSINIT_MASK      (0x4U)
#define ENET_MAC_TIMESTAMP_CTRL_TSINIT_SHIFT     (2U)
/*! TSINIT - Initialize Timestamp When this bit is set, the system time is initialized (overwritten)
 *    with the value specified in the MAC Register 80 (System Time Seconds Update.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TSINIT(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TSINIT_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TSINIT_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TSUPDT_MASK      (0x8U)
#define ENET_MAC_TIMESTAMP_CTRL_TSUPDT_SHIFT     (3U)
/*! TSUPDT - Update Timestamp When this bit is set, the system time is updated (added or subtracted)
 *    with the value specified in MAC System Time Seconds Update Table 753 and MAC System Time
 *    Nanoseconds Update Table 754.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TSUPDT(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TSUPDT_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TSUPDT_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TSTRIG_MASK      (0x10U)
#define ENET_MAC_TIMESTAMP_CTRL_TSTRIG_SHIFT     (4U)
/*! TSTRIG - Enable Timestamp Interrupt Trigger When this bit is set, the timestamp interrupt is
 *    generated when the System Time becomes greater than the value written in the Target Time register.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TSTRIG(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TSTRIG_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TSTRIG_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TADDREG_MASK     (0x20U)
#define ENET_MAC_TIMESTAMP_CTRL_TADDREG_SHIFT    (5U)
/*! TADDREG - Update Addend Register When this bit is set, the content of the Timestamp Addend
 *    register is updated in the PTP block for fine correction.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TADDREG(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TADDREG_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TADDREG_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TSENALL_MASK     (0x100U)
#define ENET_MAC_TIMESTAMP_CTRL_TSENALL_SHIFT    (8U)
/*! TSENALL - Enable Timestamp for All Packets When this bit is set, the timestamp snapshot is
 *    enabled for all packets received by the MAC.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TSENALL(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TSENALL_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TSENALL_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TSCTRLSSR_MASK   (0x200U)
#define ENET_MAC_TIMESTAMP_CTRL_TSCTRLSSR_SHIFT  (9U)
/*! TSCTRLSSR - Timestamp Digital or Binary Rollover Control When this bit is set, the Timestamp Low
 *    register rolls over after 0x3B9AC9FF value (that is, 1 nanosecond accuracy) and increments
 *    the timestamp (High) seconds.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TSCTRLSSR(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TSCTRLSSR_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TSCTRLSSR_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TSVER2ENA_MASK   (0x400U)
#define ENET_MAC_TIMESTAMP_CTRL_TSVER2ENA_SHIFT  (10U)
/*! TSVER2ENA - Enable PTP Packet Processing for Version 2 Format When this bit is set, the IEEE
 *    1588 version 2 format is used to process the PTP packets.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TSVER2ENA(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TSVER2ENA_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TSVER2ENA_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TSIPENA_MASK     (0x800U)
#define ENET_MAC_TIMESTAMP_CTRL_TSIPENA_SHIFT    (11U)
/*! TSIPENA - Enable Processing of PTP over Ethernet Packets When this bit is set, the MAC receiver
 *    processes the PTP packets encapsulated directly in the Ethernet packets.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TSIPENA(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TSIPENA_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TSIPENA_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TSIPV6ENA_MASK   (0x1000U)
#define ENET_MAC_TIMESTAMP_CTRL_TSIPV6ENA_SHIFT  (12U)
/*! TSIPV6ENA - Enable Processing of PTP Packets Sent over 1Pv6-UDP When this bit is set, the MAC
 *    receiver processes the PTP packets encapsulated in IPv6-UDP packets.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TSIPV6ENA(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TSIPV6ENA_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TSIPV6ENA_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TSIPV4ENA_MASK   (0x2000U)
#define ENET_MAC_TIMESTAMP_CTRL_TSIPV4ENA_SHIFT  (13U)
/*! TSIPV4ENA - Enable Processing of PTP Packets Sent over IPv4-UDP When this bit is set, the MAC
 *    receiver processes the PTP packets encapsulated in IPv4-UDP packets.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TSIPV4ENA(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TSIPV4ENA_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TSIPV4ENA_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TSEVTENA_MASK    (0x4000U)
#define ENET_MAC_TIMESTAMP_CTRL_TSEVTENA_SHIFT   (14U)
/*! TSEVTENA - Enable Timestamp Snapshot for Event Messages When this bit is set, the timestamp
 *    snapshot is taken only for event messages (SYNC, Delay_Req, Pdelay_Req, or Pdelay_Resp).
 */
#define ENET_MAC_TIMESTAMP_CTRL_TSEVTENA(x)      (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TSEVTENA_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TSEVTENA_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TSMSTRENA_MASK   (0x8000U)
#define ENET_MAC_TIMESTAMP_CTRL_TSMSTRENA_SHIFT  (15U)
/*! TSMSTRENA - Enable Snapshot for Messages Relevant to Master When this bit is set, the snapshot
 *    is taken only for the messages that are relevant to the master node.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TSMSTRENA(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TSMSTRENA_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TSMSTRENA_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_SNAPTYPSEL_MASK  (0x30000U)
#define ENET_MAC_TIMESTAMP_CTRL_SNAPTYPSEL_SHIFT (16U)
/*! SNAPTYPSEL - Select PTP packets for Taking Snapshots These bits, along with Bits 15 and 14,
 *    decide the set of PTP packet types for which snapshot needs to be taken.
 */
#define ENET_MAC_TIMESTAMP_CTRL_SNAPTYPSEL(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_SNAPTYPSEL_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_SNAPTYPSEL_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TSENMACADDR_MASK (0x40000U)
#define ENET_MAC_TIMESTAMP_CTRL_TSENMACADDR_SHIFT (18U)
/*! TSENMACADDR - Enable MAC Address for PTP Packet Filtering When this bit is set, the DA MAC
 *    address (that matches any MAC Address register) is used to filter the PTP packets when PTP is
 *    directly sent over Ethernet.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TSENMACADDR(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TSENMACADDR_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TSENMACADDR_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_TXTTSSTSM_MASK   (0x1000000U)
#define ENET_MAC_TIMESTAMP_CTRL_TXTTSSTSM_SHIFT  (24U)
/*! TXTTSSTSM - Transmit Timestamp Status Mode When this bit is set, the MAC overwrites the earlier
 *    transmit timestamp status even if it is not read by the software.
 */
#define ENET_MAC_TIMESTAMP_CTRL_TXTTSSTSM(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_TXTTSSTSM_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_TXTTSSTSM_MASK)
#define ENET_MAC_TIMESTAMP_CTRL_AV8021ASMEN_MASK (0x10000000U)
#define ENET_MAC_TIMESTAMP_CTRL_AV8021ASMEN_SHIFT (28U)
/*! AV8021ASMEN - AV 802.
 */
#define ENET_MAC_TIMESTAMP_CTRL_AV8021ASMEN(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CTRL_AV8021ASMEN_SHIFT)) & ENET_MAC_TIMESTAMP_CTRL_AV8021ASMEN_MASK)
/*! @} */

/*! @name MAC_SUB_SCND_INCR - Sub-second increment register */
/*! @{ */
#define ENET_MAC_SUB_SCND_INCR_SSINC_MASK        (0xFF0000U)
#define ENET_MAC_SUB_SCND_INCR_SSINC_SHIFT       (16U)
/*! SSINC - Sub-second increment value.
 */
#define ENET_MAC_SUB_SCND_INCR_SSINC(x)          (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SUB_SCND_INCR_SSINC_SHIFT)) & ENET_MAC_SUB_SCND_INCR_SSINC_MASK)
/*! @} */

/*! @name MAC_SYS_TIME_SCND - System time seconds register */
/*! @{ */
#define ENET_MAC_SYS_TIME_SCND_TSS_MASK          (0xFFFFFFFFU)
#define ENET_MAC_SYS_TIME_SCND_TSS_SHIFT         (0U)
/*! TSS - Time stamp second The value in this field indicates the current value in seconds of the
 *    System Time maintained by the MAC.
 */
#define ENET_MAC_SYS_TIME_SCND_TSS(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SYS_TIME_SCND_TSS_SHIFT)) & ENET_MAC_SYS_TIME_SCND_TSS_MASK)
/*! @} */

/*! @name MAC_SYS_TIME_NSCND - System time nanoseconds register */
/*! @{ */
#define ENET_MAC_SYS_TIME_NSCND_TSSS_MASK        (0x7FFFFFFFU)
#define ENET_MAC_SYS_TIME_NSCND_TSSS_SHIFT       (0U)
/*! TSSS - Time stamp sub seconds The value in this field has the sub second representation of time, with an accuracy of 0.
 */
#define ENET_MAC_SYS_TIME_NSCND_TSSS(x)          (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SYS_TIME_NSCND_TSSS_SHIFT)) & ENET_MAC_SYS_TIME_NSCND_TSSS_MASK)
/*! @} */

/*! @name MAC_SYS_TIME_SCND_UPD -  */
/*! @{ */
#define ENET_MAC_SYS_TIME_SCND_UPD_TSS_MASK      (0xFFFFFFFFU)
#define ENET_MAC_SYS_TIME_SCND_UPD_TSS_SHIFT     (0U)
/*! TSS - Time stamp second The value in this field indicates the time, in seconds, to be initialized or added to the system time.
 */
#define ENET_MAC_SYS_TIME_SCND_UPD_TSS(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SYS_TIME_SCND_UPD_TSS_SHIFT)) & ENET_MAC_SYS_TIME_SCND_UPD_TSS_MASK)
/*! @} */

/*! @name MAC_SYS_TIME_NSCND_UPD -  */
/*! @{ */
#define ENET_MAC_SYS_TIME_NSCND_UPD_TSSS_MASK    (0x7FFFFFFFU)
#define ENET_MAC_SYS_TIME_NSCND_UPD_TSSS_SHIFT   (0U)
/*! TSSS - Time stamp sub seconds The value in this field has the sub second representation of time, with an accuracy of 0.
 */
#define ENET_MAC_SYS_TIME_NSCND_UPD_TSSS(x)      (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SYS_TIME_NSCND_UPD_TSSS_SHIFT)) & ENET_MAC_SYS_TIME_NSCND_UPD_TSSS_MASK)
#define ENET_MAC_SYS_TIME_NSCND_UPD_ADDSUB_MASK  (0x80000000U)
#define ENET_MAC_SYS_TIME_NSCND_UPD_ADDSUB_SHIFT (31U)
/*! ADDSUB - Add or subtract time When this bit is set, the time value is subtracted with the contents of the update register.
 */
#define ENET_MAC_SYS_TIME_NSCND_UPD_ADDSUB(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SYS_TIME_NSCND_UPD_ADDSUB_SHIFT)) & ENET_MAC_SYS_TIME_NSCND_UPD_ADDSUB_MASK)
/*! @} */

/*! @name MAC_SYS_TIMESTMP_ADDEND - Time stamp addend register */
/*! @{ */
#define ENET_MAC_SYS_TIMESTMP_ADDEND_TSAR_MASK   (0xFFFFFFFFU)
#define ENET_MAC_SYS_TIMESTMP_ADDEND_TSAR_SHIFT  (0U)
/*! TSAR - Time stamp addend This register indicates the 32-bit time value to be added to the
 *    Accumulator register to achieve time synchronization.
 */
#define ENET_MAC_SYS_TIMESTMP_ADDEND_TSAR(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SYS_TIMESTMP_ADDEND_TSAR_SHIFT)) & ENET_MAC_SYS_TIMESTMP_ADDEND_TSAR_MASK)
/*! @} */

/*! @name MAC_SYS_TIME_HWORD_SCND -  */
/*! @{ */
#define ENET_MAC_SYS_TIME_HWORD_SCND_TSHWR_MASK  (0xFFFFU)
#define ENET_MAC_SYS_TIME_HWORD_SCND_TSHWR_SHIFT (0U)
/*! TSHWR - Time stamp higher word Contains the most significant 16-bits of the Time stamp seconds value.
 */
#define ENET_MAC_SYS_TIME_HWORD_SCND_TSHWR(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SYS_TIME_HWORD_SCND_TSHWR_SHIFT)) & ENET_MAC_SYS_TIME_HWORD_SCND_TSHWR_MASK)
/*! @} */

/*! @name MAC_SYS_TIMESTMP_STAT - Time stamp status register */
/*! @{ */
#define ENET_MAC_SYS_TIMESTMP_STAT_TSSOVF_MASK   (0x1U)
#define ENET_MAC_SYS_TIMESTMP_STAT_TSSOVF_SHIFT  (0U)
/*! TSSOVF - Time stamp seconds overflow When set, indicates that the seconds value of the Time
 *    stamp has overflowed beyond 0xFFFF_FFFF.
 */
#define ENET_MAC_SYS_TIMESTMP_STAT_TSSOVF(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SYS_TIMESTMP_STAT_TSSOVF_SHIFT)) & ENET_MAC_SYS_TIMESTMP_STAT_TSSOVF_MASK)
/*! @} */

/*! @name MAC_TX_TIMESTAMP_STATUS_NANOSECONDS - Tx timestamp status nanoseconds */
/*! @{ */
#define ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSTSLO_MASK (0x7FFFFFFFU)
#define ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSTSLO_SHIFT (0U)
/*! TXTSSTSLO - Transmit timestamp status low.
 */
#define ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSTSLO(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSTSLO_SHIFT)) & ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSTSLO_MASK)
#define ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSTSMIS_MASK (0x80000000U)
#define ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSTSMIS_SHIFT (31U)
/*! TXTSSTSMIS - Transmit timestamp status missed.
 */
#define ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSTSMIS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSTSMIS_SHIFT)) & ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSTSMIS_MASK)
/*! @} */

/*! @name MAC_TX_TIMESTAMP_STATUS_SECONDS - Tx timestamp status seconds */
/*! @{ */
#define ENET_MAC_TX_TIMESTAMP_STATUS_SECONDS_TXTSSTSHI_MASK (0xFFFFFFFFU)
#define ENET_MAC_TX_TIMESTAMP_STATUS_SECONDS_TXTSSTSHI_SHIFT (0U)
/*! TXTSSTSHI - Transmit timestamp status high.
 */
#define ENET_MAC_TX_TIMESTAMP_STATUS_SECONDS_TXTSSTSHI(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_TIMESTAMP_STATUS_SECONDS_TXTSSTSHI_SHIFT)) & ENET_MAC_TX_TIMESTAMP_STATUS_SECONDS_TXTSSTSHI_MASK)
/*! @} */

/*! @name MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND - Timestamp ingress correction */
/*! @{ */
#define ENET_MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND_TSIC_MASK (0xFFFFFFFFU)
#define ENET_MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND_TSIC_SHIFT (0U)
/*! TSIC - Transmit ingress correction.
 */
#define ENET_MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND_TSIC(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND_TSIC_SHIFT)) & ENET_MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND_TSIC_MASK)
/*! @} */

/*! @name MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND - Timestamp egress correction */
/*! @{ */
#define ENET_MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND_TSEC_MASK (0xFFFFFFFFU)
#define ENET_MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND_TSEC_SHIFT (0U)
/*! TSEC - Transmit egress correction.
 */
#define ENET_MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND_TSEC(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND_TSEC_SHIFT)) & ENET_MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND_TSEC_MASK)
/*! @} */

/*! @name MTL_OP_MODE - MTL Operation Mode Register */
/*! @{ */
#define ENET_MTL_OP_MODE_DTXSTS_MASK             (0x2U)
#define ENET_MTL_OP_MODE_DTXSTS_SHIFT            (1U)
/*! DTXSTS - Drop Transmit Status When this bit is set, the Tx packet status received from the MAC is dropped in the MTL.
 */
#define ENET_MTL_OP_MODE_DTXSTS(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MTL_OP_MODE_DTXSTS_SHIFT)) & ENET_MTL_OP_MODE_DTXSTS_MASK)
#define ENET_MTL_OP_MODE_RAA_MASK                (0x4U)
#define ENET_MTL_OP_MODE_RAA_SHIFT               (2U)
/*! RAA - Receive Arbitration Algorithm This field is used to select the arbitration algorithm for the Rx side.
 */
#define ENET_MTL_OP_MODE_RAA(x)                  (((uint32_t)(((uint32_t)(x)) << ENET_MTL_OP_MODE_RAA_SHIFT)) & ENET_MTL_OP_MODE_RAA_MASK)
#define ENET_MTL_OP_MODE_SCHALG_MASK             (0x60U)
#define ENET_MTL_OP_MODE_SCHALG_SHIFT            (5U)
/*! SCHALG - Tx Scheduling Algorithm This field indicates the algorithm for Tx scheduling: 0x00: WRR
 *    algorithm 0x1: Reserved 0x2: Reserved 0x3: Strict priority algorithm.
 */
#define ENET_MTL_OP_MODE_SCHALG(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MTL_OP_MODE_SCHALG_SHIFT)) & ENET_MTL_OP_MODE_SCHALG_MASK)
#define ENET_MTL_OP_MODE_CNTPRST_MASK            (0x100U)
#define ENET_MTL_OP_MODE_CNTPRST_SHIFT           (8U)
/*! CNTPRST - Counters Preset When this bit is set, MTL TxQ0 Underflow register (Table 762) and
 *    MTL_TxQ1_Underflow (Table 762) registers are initialized/preset to 0x7F0.
 */
#define ENET_MTL_OP_MODE_CNTPRST(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MTL_OP_MODE_CNTPRST_SHIFT)) & ENET_MTL_OP_MODE_CNTPRST_MASK)
#define ENET_MTL_OP_MODE_CNTCLR_MASK             (0x200U)
#define ENET_MTL_OP_MODE_CNTCLR_SHIFT            (9U)
/*! CNTCLR - Counters Reset When this bit is set, all counters are reset.
 */
#define ENET_MTL_OP_MODE_CNTCLR(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MTL_OP_MODE_CNTCLR_SHIFT)) & ENET_MTL_OP_MODE_CNTCLR_MASK)
/*! @} */

/*! @name MTL_INTR_STAT - MTL Interrupt Status register */
/*! @{ */
#define ENET_MTL_INTR_STAT_Q0IS_MASK             (0x1U)
#define ENET_MTL_INTR_STAT_Q0IS_SHIFT            (0U)
/*! Q0IS - Queue 0 Interrupt status This bit indicates that there is an interrupt from Queue 0.
 */
#define ENET_MTL_INTR_STAT_Q0IS(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MTL_INTR_STAT_Q0IS_SHIFT)) & ENET_MTL_INTR_STAT_Q0IS_MASK)
#define ENET_MTL_INTR_STAT_Q1IS_MASK             (0x2U)
#define ENET_MTL_INTR_STAT_Q1IS_SHIFT            (1U)
/*! Q1IS - Queue 1 Interrupt status This bit indicates that there is an interrupt from Queue 1.
 */
#define ENET_MTL_INTR_STAT_Q1IS(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MTL_INTR_STAT_Q1IS_SHIFT)) & ENET_MTL_INTR_STAT_Q1IS_MASK)
/*! @} */

/*! @name MTL_RXQ_DMA_MAP - MTL Receive Queue and DMA Channel Mapping register */
/*! @{ */
#define ENET_MTL_RXQ_DMA_MAP_Q0MDMACH_MASK       (0x1U)
#define ENET_MTL_RXQ_DMA_MAP_Q0MDMACH_SHIFT      (0U)
/*! Q0MDMACH - Queue 0 Mapped to DMA Channel This field controls the routing of the packet received
 *    in Queue 0 to the DMA channel: 0: DMA Channel 0 1: DMA Channel 1 This field is valid when the
 *    Q0DDMACH field is reset.
 */
#define ENET_MTL_RXQ_DMA_MAP_Q0MDMACH(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MTL_RXQ_DMA_MAP_Q0MDMACH_SHIFT)) & ENET_MTL_RXQ_DMA_MAP_Q0MDMACH_MASK)
#define ENET_MTL_RXQ_DMA_MAP_Q0DDMACH_MASK       (0x10U)
#define ENET_MTL_RXQ_DMA_MAP_Q0DDMACH_SHIFT      (4U)
/*! Q0DDMACH - Queue 0 Enabled for DA-based DMA Channel Selection When set, this bit indicates that
 *    the packets received in Queue 0 are routed to a particular DMA channel as decided in the MAC
 *    Receiver based on the DMA channel number programmed in the L3-L4 filter registers, or the
 *    Ethernet DA address.
 */
#define ENET_MTL_RXQ_DMA_MAP_Q0DDMACH(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MTL_RXQ_DMA_MAP_Q0DDMACH_SHIFT)) & ENET_MTL_RXQ_DMA_MAP_Q0DDMACH_MASK)
#define ENET_MTL_RXQ_DMA_MAP_Q1MDMACH_MASK       (0x100U)
#define ENET_MTL_RXQ_DMA_MAP_Q1MDMACH_SHIFT      (8U)
/*! Q1MDMACH - Queue 1 Mapped to DMA Channel This field controls the routing of the received packet
 *    in Queue 1 to the DMA channel: 0: DMA Channel 0 1: DMA Channel 1 This field is valid when the
 *    Q1DDMACH field is reset.
 */
#define ENET_MTL_RXQ_DMA_MAP_Q1MDMACH(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MTL_RXQ_DMA_MAP_Q1MDMACH_SHIFT)) & ENET_MTL_RXQ_DMA_MAP_Q1MDMACH_MASK)
#define ENET_MTL_RXQ_DMA_MAP_Q1DDMACH_MASK       (0x1000U)
#define ENET_MTL_RXQ_DMA_MAP_Q1DDMACH_SHIFT      (12U)
/*! Q1DDMACH - Queue 1 Enabled for DA-based DMA Channel Selection When set, this bit indicates that
 *    the packets received in Queue 1 are routed to a particular DMA channel as decided in the MAC
 *    Receiver based on the DMA channel number programmed in the L3-L4 filter registers, or the
 *    Ethernet DA address.
 */
#define ENET_MTL_RXQ_DMA_MAP_Q1DDMACH(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MTL_RXQ_DMA_MAP_Q1DDMACH_SHIFT)) & ENET_MTL_RXQ_DMA_MAP_Q1DDMACH_MASK)
/*! @} */

/*! @name MTL_QUEUE_MTL_TXQX_OP_MODE - MTL TxQx Operation Mode register */
/*! @{ */
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_FTQ_MASK (0x1U)
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_FTQ_SHIFT (0U)
/*! FTQ - Flush Transmit Queue When this bit is set, the Tx queue controller logic is reset to its default values.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_FTQ(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_FTQ_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_FTQ_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TSF_MASK (0x2U)
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TSF_SHIFT (1U)
/*! TSF - Transmit Store and Forward When this bit is set, the transmission starts when a full packet resides in the MTL Tx queue.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TSF(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TSF_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TSF_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TXQEN_MASK (0xCU)
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TXQEN_SHIFT (2U)
/*! TXQEN - Transmit Queue Enable This field is used to enable/disable the transmit queue 0.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TXQEN(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TXQEN_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TXQEN_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TTC_MASK (0x70U)
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TTC_SHIFT (4U)
/*! TTC - Transmit Threshold Control These bits control the threshold level of the MTL Tx Queue.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TTC(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TTC_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TTC_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TQS_MASK (0x70000U)
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TQS_SHIFT (16U)
/*! TQS - Transmit Queue Size This field indicates the size of the allocated Transmit queues in blocks of 256 bytes.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TQS(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TQS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TQS_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_OP_MODE */
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_COUNT    (2U)

/*! @name MTL_QUEUE_MTL_TXQX_UNDRFLW - MTL TxQx Underflow register */
/*! @{ */
#define ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFFRMCNT_MASK (0x7FFU)
#define ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFFRMCNT_SHIFT (0U)
/*! UFFRMCNT - Underflow Packet Counter This field indicates the number of packets aborted by the
 *    controller because of Tx Queue Underflow.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFFRMCNT(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFFRMCNT_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFFRMCNT_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFCNTOVF_MASK (0x800U)
#define ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFCNTOVF_SHIFT (11U)
/*! UFCNTOVF - Overflow Bit for Underflow Packet Counter This bit is set every time the Tx queue
 *    Underflow Packet Counter field overflows, that is, it has crossed the maximum count.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFCNTOVF(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFCNTOVF_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFCNTOVF_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW */
#define ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_COUNT    (2U)

/*! @name MTL_QUEUE_MTL_TXQX_DBG - MTL TxQx Debug register */
/*! @{ */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQPAUSED_MASK (0x1U)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQPAUSED_SHIFT (0U)
/*! TXQPAUSED - Transmit Queue in Pause When this bit is high and the Rx flow control is enabled, it
 *    indicates that the Tx Queue is in the Pause condition (in the full-duplex only mode) because
 *    of the following: - Reception of the PFC packet for the priorities assigned to the Tx Queue
 *    when PFC is enabled - Reception of 802.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQPAUSED(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQPAUSED_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQPAUSED_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TRCSTS_MASK  (0x6U)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TRCSTS_SHIFT (1U)
/*! TRCSTS - MTL Tx Queue Read Controller Status This field indicates the state of the Tx Queue Read
 *    Controller: 00: Idle state 01: Read state (transferring data to the MAC transmitter) 10:
 *    Waiting for pending Tx Status from the MAC transmitter 11: Flushing the Tx queue because of the
 *    Packet Abort request from the MAC.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TRCSTS(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_DBG_TRCSTS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_DBG_TRCSTS_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TWCSTS_MASK  (0x8U)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TWCSTS_SHIFT (3U)
/*! TWCSTS - MTL Tx Queue Write Controller Status When high, this bit indicates that the MTL Tx
 *    Queue Write Controller is active, and it is transferring the data to the Tx Queue.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TWCSTS(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_DBG_TWCSTS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_DBG_TWCSTS_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQSTS_MASK  (0x10U)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQSTS_SHIFT (4U)
/*! TXQSTS - MTL Tx Queue Not Empty Status When this bit is high, it indicates that the MTL Tx Queue
 *    is not empty and some data is left for transmission.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQSTS(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQSTS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQSTS_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXSTSFSTS_MASK (0x20U)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXSTSFSTS_SHIFT (5U)
/*! TXSTSFSTS - MTL Tx Status FIFO Full Status When high, this bit indicates that the MTL Tx Status FIFO is full.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXSTSFSTS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_DBG_TXSTSFSTS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_DBG_TXSTSFSTS_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_PTXQ_MASK    (0x70000U)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_PTXQ_SHIFT   (16U)
/*! PTXQ - Number of Packets in the Transmit Queue This field indicates the current number of packets in the Tx Queue.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_PTXQ(x)      (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_DBG_PTXQ_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_DBG_PTXQ_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_STSXSTSF_MASK (0x700000U)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_STSXSTSF_SHIFT (20U)
/*! STSXSTSF - Number of Status Words in Tx Status FIFO of Queue This field indicates the current
 *    number of status in the Tx Status FIFO of this queue.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_STSXSTSF(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_DBG_STSXSTSF_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_DBG_STSXSTSF_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_DBG */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_COUNT        (2U)

/*! @name MTL_QUEUE_MTL_TXQX_ETS_CTRL - MTL TxQx ETS control register, only TxQ1 support */
/*! @{ */
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_AVALG_MASK (0x4U)
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_AVALG_SHIFT (2U)
/*! AVALG - AV Algorithm.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_AVALG(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_AVALG_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_AVALG_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_CC_MASK (0x8U)
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_CC_SHIFT (3U)
/*! CC - Credit Control.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_CC(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_CC_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_CC_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_SLC_MASK (0x70U)
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_SLC_SHIFT (4U)
/*! SLC - Credit Control.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_SLC(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_SLC_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_SLC_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL */
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_COUNT   (2U)

/*! @name MTL_QUEUE_MTL_TXQX_ETS_STAT - MTL TxQx ETS Status register */
/*! @{ */
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_STAT_ABS_MASK (0xFFFFFFU)
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_STAT_ABS_SHIFT (0U)
/*! ABS - Average Bits per Slot.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_STAT_ABS(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_ETS_STAT_ABS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_ETS_STAT_ABS_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_ETS_STAT */
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_STAT_COUNT   (2U)

/*! @name MTL_QUEUE_MTL_TXQX_QNTM_WGHT -  */
/*! @{ */
#define ENET_MTL_QUEUE_MTL_TXQX_QNTM_WGHT_ISCQW_MASK (0x1FFFFFU)
#define ENET_MTL_QUEUE_MTL_TXQX_QNTM_WGHT_ISCQW_SHIFT (0U)
/*! ISCQW - Average Bits per Slot.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_QNTM_WGHT_ISCQW(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_QNTM_WGHT_ISCQW_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_QNTM_WGHT_ISCQW_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_QNTM_WGHT */
#define ENET_MTL_QUEUE_MTL_TXQX_QNTM_WGHT_COUNT  (2U)

/*! @name MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT - MTL TxQx SendSlopCredit register, only TxQ1 support */
/*! @{ */
#define ENET_MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT_SSC_MASK (0x3FFFU)
#define ENET_MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT_SSC_SHIFT (0U)
/*! SSC - sendSlopeCredit.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT_SSC(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT_SSC_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT_SSC_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT */
#define ENET_MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT_COUNT (2U)

/*! @name MTL_QUEUE_MTL_TXQX_HI_CRDT - MTL TxQx hiCredit register, only TxQ1 support */
/*! @{ */
#define ENET_MTL_QUEUE_MTL_TXQX_HI_CRDT_HC_MASK  (0x1FFFFFFFU)
#define ENET_MTL_QUEUE_MTL_TXQX_HI_CRDT_HC_SHIFT (0U)
/*! HC - hiCredit.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_HI_CRDT_HC(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_HI_CRDT_HC_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_HI_CRDT_HC_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_HI_CRDT */
#define ENET_MTL_QUEUE_MTL_TXQX_HI_CRDT_COUNT    (2U)

/*! @name MTL_QUEUE_MTL_TXQX_LO_CRDT - MTL TxQx loCredit register, only TxQ1 support */
/*! @{ */
#define ENET_MTL_QUEUE_MTL_TXQX_LO_CRDT_LC_MASK  (0x1FFFFFFFU)
#define ENET_MTL_QUEUE_MTL_TXQX_LO_CRDT_LC_SHIFT (0U)
/*! LC - loCredit.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_LO_CRDT_LC(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_LO_CRDT_LC_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_LO_CRDT_LC_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_LO_CRDT */
#define ENET_MTL_QUEUE_MTL_TXQX_LO_CRDT_COUNT    (2U)

/*! @name MTL_QUEUE_MTL_TXQX_INTCTRL_STAT -  */
/*! @{ */
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_TXUNFIS_MASK (0x1U)
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_TXUNFIS_SHIFT (0U)
/*! TXUNFIS - Transmit Queue Underflow Interrupt Status This bit indicates that the Transmit Queue
 *    had an underflow while transmitting the packet.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_TXUNFIS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_TXUNFIS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_TXUNFIS_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_ABPSIS_MASK (0x2U)
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_ABPSIS_SHIFT (1U)
/*! ABPSIS - Average Bits Per Slot Interrupt Status When set, this bit indicates that the MAC has updated the ABS value.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_ABPSIS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_ABPSIS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_ABPSIS_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_TXUIE_MASK (0x100U)
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_TXUIE_SHIFT (8U)
/*! TXUIE - Transmit Queue Underflow Interrupt Enable When this bit is set, the Transmit Queue Underflow interrupt is enabled.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_TXUIE(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_TXUIE_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_TXUIE_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_ABPSIE_MASK (0x200U)
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_ABPSIE_SHIFT (9U)
/*! ABPSIE - Average Bits Per Slot Interrupt Enable When this bit is set, the MAC asserts the
 *    interrupt when the average bits per slot status is updated.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_ABPSIE(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_ABPSIE_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_ABPSIE_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_RXOVFIS_MASK (0x10000U)
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_RXOVFIS_SHIFT (16U)
/*! RXOVFIS - Receive Queue Overflow Interrupt Status This bit indicates that the Receive Queue had
 *    an overflow while receiving the packet.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_RXOVFIS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_RXOVFIS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_RXOVFIS_MASK)
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_RXOIE_MASK (0x1000000U)
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_RXOIE_SHIFT (24U)
/*! RXOIE - Receive Queue Overflow Interrupt Enable When this bit is set, the Receive Queue Overflow interrupt is enabled.
 */
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_RXOIE(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_RXOIE_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_RXOIE_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT */
#define ENET_MTL_QUEUE_MTL_TXQX_INTCTRL_STAT_COUNT (2U)

/*! @name MTL_QUEUE_MTL_RXQX_OP_MODE - MTL RxQx Operation Mode register */
/*! @{ */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RTC_MASK (0x3U)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RTC_SHIFT (0U)
/*! RTC - Receive Queue Threshold Control These bits control the threshold level of the MTL Rx queue
 *    (in bytes): 00: 64 01: 32 10: 96 11: 128 The packet received is transferred to the
 *    application or DMA when the packet size within the MTL Rx queue is larger than the threshold.
 */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RTC(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RTC_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RTC_MASK)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FUP_MASK (0x8U)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FUP_SHIFT (3U)
/*! FUP - Forward Undersized Good Packets When this bit is set, the Rx queue forwards the undersized
 *    good packets (packets with no error and length less than 64 bytes), including pad-bytes and
 *    CRC.
 */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FUP(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FUP_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FUP_MASK)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FEP_MASK (0x10U)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FEP_SHIFT (4U)
/*! FEP - Forward Error Packets When this bit is reset, the Rx queue drops packets with error status
 *    (CRC error, Mll_ER, watchdog timeout, or overflow).
 */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FEP(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FEP_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FEP_MASK)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RSF_MASK (0x20U)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RSF_SHIFT (5U)
/*! RSF - Receive Queue Store and Forward When this bit is set, the ethernet block on this chip
 *    reads a packet from the Rx queue only after the complete packet has been written to it, ignoring
 *    the RTC field of this register.
 */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RSF(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RSF_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RSF_MASK)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_DIS_TCP_EF_MASK (0x40U)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_DIS_TCP_EF_SHIFT (6U)
/*! DIS_TCP_EF - Disable Dropping of TCP/IP Checksum Error Packets When this bit is set, the MAC
 *    does not drop the packets which only have the errors detected by the Receive Checksum Offload
 *    engine.
 */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_DIS_TCP_EF(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_DIS_TCP_EF_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_DIS_TCP_EF_MASK)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RQS_MASK (0x700000U)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RQS_SHIFT (20U)
/*! RQS - This field indicates the size of the allocated Receive queues in blocks of 256 bytes.
 */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RQS(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RQS_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RQS_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_RXQX_OP_MODE */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_COUNT    (2U)

/*! @name MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT - MTL RxQx Missed Packet Overflow Counter register */
/*! @{ */
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFPKTCNT_MASK (0x7FFU)
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFPKTCNT_SHIFT (0U)
/*! OVFPKTCNT - Overflow Packet Counter This field indicates the number of packets discarded by the
 *    Ethernet block because of Receive queue overflow.
 */
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFPKTCNT(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFPKTCNT_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFPKTCNT_MASK)
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFCNTOVF_MASK (0x800U)
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFCNTOVF_SHIFT (11U)
/*! OVFCNTOVF - Overflow Counter Overflow Bit When set, this bit indicates that the Rx Queue
 *    Overflow Packet Counter field crossed the maximum limit.
 */
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFCNTOVF(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFCNTOVF_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFCNTOVF_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT */
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_COUNT (2U)

/*! @name MTL_QUEUE_MTL_RXQX_DBG - MTL RxQx Debug register */
/*! @{ */
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RWCSTS_MASK  (0x1U)
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RWCSTS_SHIFT (0U)
/*! RWCSTS - MTL Rx Queue Write Controller Active Status When high, this bit indicates that the MTL
 *    Rx queue Write controller is active, and it is transferring a received packet to the Rx Queue.
 */
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RWCSTS(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_DBG_RWCSTS_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_DBG_RWCSTS_MASK)
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RRCSTS_MASK  (0x6U)
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RRCSTS_SHIFT (1U)
/*! RRCSTS - MTL Rx Queue Read Controller State This field gives the state of the Rx queue Read
 *    controller: 00: Idle state 01: Reading packet data 10: Reading packet status (or timestamp) 11:
 *    Flushing the packet data and status.
 */
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RRCSTS(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_DBG_RRCSTS_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_DBG_RRCSTS_MASK)
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RXQSTS_MASK  (0x30U)
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RXQSTS_SHIFT (4U)
/*! RXQSTS - MTL Rx Queue Fill-Level Status This field gives the status of the fill-level of the Rx
 *    Queue: 0x0: Rx Queue empty 0x1: Rx Queue fill-level below flow-control deactivate threshold
 *    0x2: Rx Queue fill-level above flow-control activate threshold 0x3: Rx Queue full.
 */
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RXQSTS(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_DBG_RXQSTS_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_DBG_RXQSTS_MASK)
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_PRXQ_MASK    (0x3FFF0000U)
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_PRXQ_SHIFT   (16U)
/*! PRXQ - Number of Packets in Receive Queue This field indicates the current number of packets in the Rx Queue.
 */
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_PRXQ(x)      (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_DBG_PRXQ_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_DBG_PRXQ_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_RXQX_DBG */
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_COUNT        (2U)

/*! @name MTL_QUEUE_MTL_RXQX_CTRL - MTL RxQx Control register */
/*! @{ */
#define ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_WEGT_MASK (0x7U)
#define ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_WEGT_SHIFT (0U)
/*! RXQ_WEGT - Receive Queue Weight This field indicates the weight assigned to the Rx Queue 0.
 */
#define ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_WEGT(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_WEGT_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_WEGT_MASK)
#define ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_FRM_ARBIT_MASK (0x8U)
#define ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_FRM_ARBIT_SHIFT (3U)
/*! RXQ_FRM_ARBIT - Receive Queue Packet Arbitration When this bit is set, the The ethernet block
 *    drives the packet data to the ARI interface such that the entire packet data of
 *    currently-selected queue is transmitted before switching to other queue.
 */
#define ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_FRM_ARBIT(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_FRM_ARBIT_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_FRM_ARBIT_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_RXQX_CTRL */
#define ENET_MTL_QUEUE_MTL_RXQX_CTRL_COUNT       (2U)

/*! @name DMA_MODE - DMA mode register */
/*! @{ */
#define ENET_DMA_MODE_SWR_MASK                   (0x1U)
#define ENET_DMA_MODE_SWR_SHIFT                  (0U)
/*! SWR - Software Reset When this bit is set, the MAC and the OMA controller reset the logic and
 *    all internal registers of the OMA, MTL, and MAC.
 */
#define ENET_DMA_MODE_SWR(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_DMA_MODE_SWR_SHIFT)) & ENET_DMA_MODE_SWR_MASK)
#define ENET_DMA_MODE_DA_MASK                    (0x2U)
#define ENET_DMA_MODE_DA_SHIFT                   (1U)
/*! DA - DMA Tx or Rx Arbitration Scheme This bit specifies the arbitration scheme between the
 *    Transmit and Receive paths of all channels: The Tx path has priority over the Rx path when the TXPR
 *    bit is set.
 */
#define ENET_DMA_MODE_DA(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_DMA_MODE_DA_SHIFT)) & ENET_DMA_MODE_DA_MASK)
#define ENET_DMA_MODE_TAA_MASK                   (0x1CU)
#define ENET_DMA_MODE_TAA_SHIFT                  (2U)
/*! TAA - Transmit Arbitration Algorithm This field is used to select the arbitration algorithm for
 *    the Transmit side when multiple Tx DMAs are selected.
 */
#define ENET_DMA_MODE_TAA(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_DMA_MODE_TAA_SHIFT)) & ENET_DMA_MODE_TAA_MASK)
#define ENET_DMA_MODE_TXPR_MASK                  (0x800U)
#define ENET_DMA_MODE_TXPR_SHIFT                 (11U)
/*! TXPR - Transmit Priority When set, this bit indicates that the Tx DMA has higher priority than
 *    the Rx DMA during arbitration for the system-side bus.
 */
#define ENET_DMA_MODE_TXPR(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_DMA_MODE_TXPR_SHIFT)) & ENET_DMA_MODE_TXPR_MASK)
#define ENET_DMA_MODE_PR_MASK                    (0x7000U)
#define ENET_DMA_MODE_PR_SHIFT                   (12U)
/*! PR - Priority Ratio These bits control the priority ratio in weighted round-robin arbitration between the Rx DMA and Tx DMA.
 */
#define ENET_DMA_MODE_PR(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_DMA_MODE_PR_SHIFT)) & ENET_DMA_MODE_PR_MASK)
/*! @} */

/*! @name DMA_SYSBUS_MODE - DMA System Bus mode */
/*! @{ */
#define ENET_DMA_SYSBUS_MODE_FB_MASK             (0x1U)
#define ENET_DMA_SYSBUS_MODE_FB_SHIFT            (0U)
/*! FB - Fixed Burst Length When this bit is set to 1, the AHB master will initiate burst transfers
 *    of specified length (INCRx or SINGLE).
 */
#define ENET_DMA_SYSBUS_MODE_FB(x)               (((uint32_t)(((uint32_t)(x)) << ENET_DMA_SYSBUS_MODE_FB_SHIFT)) & ENET_DMA_SYSBUS_MODE_FB_MASK)
#define ENET_DMA_SYSBUS_MODE_AAL_MASK            (0x1000U)
#define ENET_DMA_SYSBUS_MODE_AAL_SHIFT           (12U)
/*! AAL - Address-Aligned Beats When this bit is set to 1, the AHB master performs address-aligned
 *    burst transfers on Read and Write channels.
 */
#define ENET_DMA_SYSBUS_MODE_AAL(x)              (((uint32_t)(((uint32_t)(x)) << ENET_DMA_SYSBUS_MODE_AAL_SHIFT)) & ENET_DMA_SYSBUS_MODE_AAL_MASK)
#define ENET_DMA_SYSBUS_MODE_MB_MASK             (0x4000U)
#define ENET_DMA_SYSBUS_MODE_MB_SHIFT            (14U)
/*! MB - Mixed Burst When this bit is set high and the FB bit is low, the AHB master performs
 *    undefined bursts transfers (INCR) for burst length of 16 or more.
 */
#define ENET_DMA_SYSBUS_MODE_MB(x)               (((uint32_t)(((uint32_t)(x)) << ENET_DMA_SYSBUS_MODE_MB_SHIFT)) & ENET_DMA_SYSBUS_MODE_MB_MASK)
#define ENET_DMA_SYSBUS_MODE_RB_MASK             (0x8000U)
#define ENET_DMA_SYSBUS_MODE_RB_SHIFT            (15U)
/*! RB - Rebuild INCRx Burst When this bit is set high and the AHB master gets SPLIT, RETRY, or
 *    EarlyBurst Termination (EBT) response, the AHB master interface rebuilds the pending beats of any
 *    initiated burst transfer with INCRx and SINGLEtransfers.
 */
#define ENET_DMA_SYSBUS_MODE_RB(x)               (((uint32_t)(((uint32_t)(x)) << ENET_DMA_SYSBUS_MODE_RB_SHIFT)) & ENET_DMA_SYSBUS_MODE_RB_MASK)
/*! @} */

/*! @name DMA_INTR_STAT - DMA Interrupt status */
/*! @{ */
#define ENET_DMA_INTR_STAT_DC0IS_MASK            (0x1U)
#define ENET_DMA_INTR_STAT_DC0IS_SHIFT           (0U)
/*! DC0IS - DMA Channel 0 Interrupt Status This bit indicates an interrupt event in DMA Channel 0.
 */
#define ENET_DMA_INTR_STAT_DC0IS(x)              (((uint32_t)(((uint32_t)(x)) << ENET_DMA_INTR_STAT_DC0IS_SHIFT)) & ENET_DMA_INTR_STAT_DC0IS_MASK)
#define ENET_DMA_INTR_STAT_DC1IS_MASK            (0x2U)
#define ENET_DMA_INTR_STAT_DC1IS_SHIFT           (1U)
/*! DC1IS - DMA Channel 1 Interrupt Status This bit indicates an interrupt event in DMA Channel 1.
 */
#define ENET_DMA_INTR_STAT_DC1IS(x)              (((uint32_t)(((uint32_t)(x)) << ENET_DMA_INTR_STAT_DC1IS_SHIFT)) & ENET_DMA_INTR_STAT_DC1IS_MASK)
#define ENET_DMA_INTR_STAT_MTLIS_MASK            (0x10000U)
#define ENET_DMA_INTR_STAT_MTLIS_SHIFT           (16U)
/*! MTLIS - MTL Interrupt Status This bit indicates an interrupt event in the MTL.
 */
#define ENET_DMA_INTR_STAT_MTLIS(x)              (((uint32_t)(((uint32_t)(x)) << ENET_DMA_INTR_STAT_MTLIS_SHIFT)) & ENET_DMA_INTR_STAT_MTLIS_MASK)
#define ENET_DMA_INTR_STAT_MACIS_MASK            (0x20000U)
#define ENET_DMA_INTR_STAT_MACIS_SHIFT           (17U)
/*! MACIS - MAC Interrupt Status This bit indicates an interrupt event in the MAC.
 */
#define ENET_DMA_INTR_STAT_MACIS(x)              (((uint32_t)(((uint32_t)(x)) << ENET_DMA_INTR_STAT_MACIS_SHIFT)) & ENET_DMA_INTR_STAT_MACIS_MASK)
/*! @} */

/*! @name DMA_DBG_STAT - DMA Debug Status */
/*! @{ */
#define ENET_DMA_DBG_STAT_AHSTS_MASK             (0x1U)
#define ENET_DMA_DBG_STAT_AHSTS_SHIFT            (0U)
/*! AHSTS - AHB Master Status When high, this bit indicates that the AHB master FSMs are in the non-idle state.
 */
#define ENET_DMA_DBG_STAT_AHSTS(x)               (((uint32_t)(((uint32_t)(x)) << ENET_DMA_DBG_STAT_AHSTS_SHIFT)) & ENET_DMA_DBG_STAT_AHSTS_MASK)
#define ENET_DMA_DBG_STAT_RPS0_MASK              (0xF00U)
#define ENET_DMA_DBG_STAT_RPS0_SHIFT             (8U)
/*! RPS0 - DMA Channel 0 Receive Process State This field indicates the Rx DMA FSM state for Channel
 *    0: 0x0: Stopped (Reset or Stop Receive Command issued) 0x1: Running (Fetching Rx Transfer )
 *    0x2: Reserved 0x3: Running (Waiting for Rx packet) 0x4: Suspended (Rx Unavailable) 0x5: Running
 *    (Closing the Rx) 0x6: Timestamp write state 0x7: Running (Transferring the received packet
 *    data from the Rx buffer to the system memory) This field does not generate an interrupt.
 */
#define ENET_DMA_DBG_STAT_RPS0(x)                (((uint32_t)(((uint32_t)(x)) << ENET_DMA_DBG_STAT_RPS0_SHIFT)) & ENET_DMA_DBG_STAT_RPS0_MASK)
#define ENET_DMA_DBG_STAT_TPS0_MASK              (0xF000U)
#define ENET_DMA_DBG_STAT_TPS0_SHIFT             (12U)
/*! TPS0 - DMA Channel 0 Transmit Process State This field indicates the Tx DMA FSM state for
 *    Channel 0: 000: Stopped (Reset or Stop Transmit Command issued) 0x1: Running (Fetching Tx Transfer)
 *    0x2: Running (Waiting for status) 0x3: Running (Reading Data from system memory buffer and
 *    queuing it to the Tx buffer (Tx FIFO)) 0x4: Timestamp write state 0x5: Reserved for future use
 *    0x6: Suspended (Tx Unavailable or Tx Buffer Underflow) 0x7: Running (Closing Tx ) This field
 *    does not generate an interrupt.
 */
#define ENET_DMA_DBG_STAT_TPS0(x)                (((uint32_t)(((uint32_t)(x)) << ENET_DMA_DBG_STAT_TPS0_SHIFT)) & ENET_DMA_DBG_STAT_TPS0_MASK)
#define ENET_DMA_DBG_STAT_RPS1_MASK              (0xF0000U)
#define ENET_DMA_DBG_STAT_RPS1_SHIFT             (16U)
/*! RPS1 - DMA Channel 1 Receive Process State This field indicates the Rx DMA FSM state for Channel 1.
 */
#define ENET_DMA_DBG_STAT_RPS1(x)                (((uint32_t)(((uint32_t)(x)) << ENET_DMA_DBG_STAT_RPS1_SHIFT)) & ENET_DMA_DBG_STAT_RPS1_MASK)
#define ENET_DMA_DBG_STAT_TPS1_MASK              (0xF00000U)
#define ENET_DMA_DBG_STAT_TPS1_SHIFT             (20U)
/*! TPS1 - DMA Channel 1 Transmit Process State This field indicates the Tx DMA FSM state for Channel 1.
 */
#define ENET_DMA_DBG_STAT_TPS1(x)                (((uint32_t)(((uint32_t)(x)) << ENET_DMA_DBG_STAT_TPS1_SHIFT)) & ENET_DMA_DBG_STAT_TPS1_MASK)
/*! @} */

/*! @name DMA_CH_DMA_CHX_CTRL - DMA Channelx Control */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_CTRL_PBLx8_MASK      (0x10000U)
#define ENET_DMA_CH_DMA_CHX_CTRL_PBLx8_SHIFT     (16U)
/*! PBLx8 - 8xPBL mode When this bit is set, the PBL value programmed in Bits[21:16] in DMA Channel
 *    Transmit Control Table 780 is multiplied eight times.
 */
#define ENET_DMA_CH_DMA_CHX_CTRL_PBLx8(x)        (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_CTRL_PBLx8_SHIFT)) & ENET_DMA_CH_DMA_CHX_CTRL_PBLx8_MASK)
#define ENET_DMA_CH_DMA_CHX_CTRL_DSL_MASK        (0x1C0000U)
#define ENET_DMA_CH_DMA_CHX_CTRL_DSL_SHIFT       (18U)
/*! DSL - Skip Length This bit specifies the Word, Dword, or Lword number (depending on the 32- bit,
 *    64-bit, or 128-bit bus) to skip between two unchained s.
 */
#define ENET_DMA_CH_DMA_CHX_CTRL_DSL(x)          (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_CTRL_DSL_SHIFT)) & ENET_DMA_CH_DMA_CHX_CTRL_DSL_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_CTRL */
#define ENET_DMA_CH_DMA_CHX_CTRL_COUNT           (2U)

/*! @name DMA_CH_DMA_CHX_TX_CTRL - DMA Channelx Transmit Control */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_ST_MASK      (0x1U)
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_ST_SHIFT     (0U)
/*! ST - Start or Stop Transmission Command When this bit is set, transmission is placed in the Running state.
 */
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_ST(x)        (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TX_CTRL_ST_SHIFT)) & ENET_DMA_CH_DMA_CHX_TX_CTRL_ST_MASK)
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_TCW_MASK     (0xEU)
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_TCW_SHIFT    (1U)
/*! TCW - Transmit Channel Weight This field indicates the weight assigned to the corresponding Transmit channel.
 */
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_TCW(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TX_CTRL_TCW_SHIFT)) & ENET_DMA_CH_DMA_CHX_TX_CTRL_TCW_MASK)
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_OSF_MASK     (0x10U)
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_OSF_SHIFT    (4U)
/*! OSF - Operate on Second Frame When this bit is set, it instructs the DMA to process the second
 *    packet of the Transmit data even before the status for the first packet is obtained.
 */
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_OSF(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TX_CTRL_OSF_SHIFT)) & ENET_DMA_CH_DMA_CHX_TX_CTRL_OSF_MASK)
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_TxPBL_MASK   (0x3F0000U)
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_TxPBL_SHIFT  (16U)
/*! TxPBL - Transmit Programmable Burst Length These bits indicate the maximum number of beats to be
 *    transferred in one DMA data transfer.
 */
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_TxPBL(x)     (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TX_CTRL_TxPBL_SHIFT)) & ENET_DMA_CH_DMA_CHX_TX_CTRL_TxPBL_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_TX_CTRL */
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_COUNT        (2U)

/*! @name DMA_CH_DMA_CHX_RX_CTRL - DMA Channelx Receive Control */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_SR_MASK      (0x1U)
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_SR_SHIFT     (0U)
/*! SR - Start or Stop Receive When this bit is set, the DMA tries to acquire the from the receive
 *    list and processes the incoming packets.
 */
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_SR(x)        (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RX_CTRL_SR_SHIFT)) & ENET_DMA_CH_DMA_CHX_RX_CTRL_SR_MASK)
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ_MASK    (0x7FF8U)
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ_SHIFT   (3U)
/*! RBSZ - Receive Buffer size This field indicates the size of the Rx buffers specified in bytes.
 */
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ(x)      (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ_SHIFT)) & ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ_MASK)
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RxPBL_MASK   (0x3F0000U)
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RxPBL_SHIFT  (16U)
/*! RxPBL - Receive Programmable Burst Length These bits indicate the maximum number of beats to be
 *    transferred in one DMA data transfer.
 */
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RxPBL(x)     (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RX_CTRL_RxPBL_SHIFT)) & ENET_DMA_CH_DMA_CHX_RX_CTRL_RxPBL_MASK)
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RPF_MASK     (0x80000000U)
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RPF_SHIFT    (31U)
/*! RPF - DMA Rx Channel 0 Packet Flush When this bit is set to 1, the DMA will automatically flush
 *    the packet from the Rx Queues destined to DMA Rx Channel 0 when the DMA Rx Channel 0 is
 *    stopped after a system bus error has occurred.
 */
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RPF(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RX_CTRL_RPF_SHIFT)) & ENET_DMA_CH_DMA_CHX_RX_CTRL_RPF_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_RX_CTRL */
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_COUNT        (2U)

/*! @name DMA_CH_DMA_CHX_TXDESC_LIST_ADDR -  */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_TXDESC_LIST_ADDR_STL_MASK (0xFFFFFFFCU)
#define ENET_DMA_CH_DMA_CHX_TXDESC_LIST_ADDR_STL_SHIFT (2U)
/*! STL - Start of transmit list This field contains the base address of the first in the Transmit list.
 */
#define ENET_DMA_CH_DMA_CHX_TXDESC_LIST_ADDR_STL(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TXDESC_LIST_ADDR_STL_SHIFT)) & ENET_DMA_CH_DMA_CHX_TXDESC_LIST_ADDR_STL_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_TXDESC_LIST_ADDR */
#define ENET_DMA_CH_DMA_CHX_TXDESC_LIST_ADDR_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_RXDESC_LIST_ADDR -  */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_RXDESC_LIST_ADDR_SRL_MASK (0xFFFFFFFCU)
#define ENET_DMA_CH_DMA_CHX_RXDESC_LIST_ADDR_SRL_SHIFT (2U)
/*! SRL - Start of receive list This field contains the base address of the First in the Receive list.
 */
#define ENET_DMA_CH_DMA_CHX_RXDESC_LIST_ADDR_SRL(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RXDESC_LIST_ADDR_SRL_SHIFT)) & ENET_DMA_CH_DMA_CHX_RXDESC_LIST_ADDR_SRL_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_RXDESC_LIST_ADDR */
#define ENET_DMA_CH_DMA_CHX_RXDESC_LIST_ADDR_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_TXDESC_TAIL_PTR -  */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_TXDESC_TAIL_PTR_TDTP_MASK (0xFFFFFFFCU)
#define ENET_DMA_CH_DMA_CHX_TXDESC_TAIL_PTR_TDTP_SHIFT (2U)
/*! TDTP - Transmit Tail Pointer This field contains the tail pointer for the Tx ring.
 */
#define ENET_DMA_CH_DMA_CHX_TXDESC_TAIL_PTR_TDTP(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TXDESC_TAIL_PTR_TDTP_SHIFT)) & ENET_DMA_CH_DMA_CHX_TXDESC_TAIL_PTR_TDTP_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_TXDESC_TAIL_PTR */
#define ENET_DMA_CH_DMA_CHX_TXDESC_TAIL_PTR_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_RXDESC_TAIL_PTR -  */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_RXDESC_TAIL_PTR_RDTP_MASK (0xFFFFFFFCU)
#define ENET_DMA_CH_DMA_CHX_RXDESC_TAIL_PTR_RDTP_SHIFT (2U)
/*! RDTP - Receive Tail Pointer This field contains the tail pointer for the Rx ring.
 */
#define ENET_DMA_CH_DMA_CHX_RXDESC_TAIL_PTR_RDTP(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RXDESC_TAIL_PTR_RDTP_SHIFT)) & ENET_DMA_CH_DMA_CHX_RXDESC_TAIL_PTR_RDTP_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_RXDESC_TAIL_PTR */
#define ENET_DMA_CH_DMA_CHX_RXDESC_TAIL_PTR_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_TXDESC_RING_LENGTH -  */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_TXDESC_RING_LENGTH_TDRL_MASK (0x3FFU)
#define ENET_DMA_CH_DMA_CHX_TXDESC_RING_LENGTH_TDRL_SHIFT (0U)
/*! TDRL - Transmit Ring Length This field sets the maximum number of Tx descriptors in the circular ring.
 */
#define ENET_DMA_CH_DMA_CHX_TXDESC_RING_LENGTH_TDRL(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TXDESC_RING_LENGTH_TDRL_SHIFT)) & ENET_DMA_CH_DMA_CHX_TXDESC_RING_LENGTH_TDRL_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_TXDESC_RING_LENGTH */
#define ENET_DMA_CH_DMA_CHX_TXDESC_RING_LENGTH_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_RXDESC_RING_LENGTH - Channelx Rx descriptor Ring Length */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_RXDESC_RING_LENGTH_RDRL_MASK (0x3FFU)
#define ENET_DMA_CH_DMA_CHX_RXDESC_RING_LENGTH_RDRL_SHIFT (0U)
/*! RDRL - Receive Ring Length This register sets the maximum number of Rx descriptors in the circular ring.
 */
#define ENET_DMA_CH_DMA_CHX_RXDESC_RING_LENGTH_RDRL(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RXDESC_RING_LENGTH_RDRL_SHIFT)) & ENET_DMA_CH_DMA_CHX_RXDESC_RING_LENGTH_RDRL_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_RXDESC_RING_LENGTH */
#define ENET_DMA_CH_DMA_CHX_RXDESC_RING_LENGTH_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_INT_EN - Channelx Interrupt Enable */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_INT_EN_TIE_MASK      (0x1U)
#define ENET_DMA_CH_DMA_CHX_INT_EN_TIE_SHIFT     (0U)
/*! TIE - Transmit interrupt enable When this bit is set with Normal Interrupt Summary Enable (bit
 *    16 in this register), Transmit Interrupt is enabled.
 */
#define ENET_DMA_CH_DMA_CHX_INT_EN_TIE(x)        (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_INT_EN_TIE_SHIFT)) & ENET_DMA_CH_DMA_CHX_INT_EN_TIE_MASK)
#define ENET_DMA_CH_DMA_CHX_INT_EN_TSE_MASK      (0x2U)
#define ENET_DMA_CH_DMA_CHX_INT_EN_TSE_SHIFT     (1U)
/*! TSE - Transmit stopped enable When this bit is set with Abnormal Interrupt Summary Enable (bit
 *    15 in this register), Transmission Stopped Interrupt is enabled.
 */
#define ENET_DMA_CH_DMA_CHX_INT_EN_TSE(x)        (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_INT_EN_TSE_SHIFT)) & ENET_DMA_CH_DMA_CHX_INT_EN_TSE_MASK)
#define ENET_DMA_CH_DMA_CHX_INT_EN_TBUE_MASK     (0x4U)
#define ENET_DMA_CH_DMA_CHX_INT_EN_TBUE_SHIFT    (2U)
/*! TBUE - Transmit buffer unavailable enable When this bit is set with Normal Interrupt Summary
 *    Enable (bit 16 in this register), Transmit Buffer Unavailable Interrupt is enabled.
 */
#define ENET_DMA_CH_DMA_CHX_INT_EN_TBUE(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_INT_EN_TBUE_SHIFT)) & ENET_DMA_CH_DMA_CHX_INT_EN_TBUE_MASK)
#define ENET_DMA_CH_DMA_CHX_INT_EN_RIE_MASK      (0x40U)
#define ENET_DMA_CH_DMA_CHX_INT_EN_RIE_SHIFT     (6U)
/*! RIE - Receive interrupt enable When this bit is set with Normal Interrupt Summary Enable (bit 16
 *    in this register), Receive Interrupt is enabled.
 */
#define ENET_DMA_CH_DMA_CHX_INT_EN_RIE(x)        (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_INT_EN_RIE_SHIFT)) & ENET_DMA_CH_DMA_CHX_INT_EN_RIE_MASK)
#define ENET_DMA_CH_DMA_CHX_INT_EN_RBUE_MASK     (0x80U)
#define ENET_DMA_CH_DMA_CHX_INT_EN_RBUE_SHIFT    (7U)
/*! RBUE - Receive buffer unavailable enable When this bit is set with Abnormal Interrupt Summary
 *    Enable (bit 15 in this register), Receive Buffer Unavailable Interrupt is enabled.
 */
#define ENET_DMA_CH_DMA_CHX_INT_EN_RBUE(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_INT_EN_RBUE_SHIFT)) & ENET_DMA_CH_DMA_CHX_INT_EN_RBUE_MASK)
#define ENET_DMA_CH_DMA_CHX_INT_EN_RSE_MASK      (0x100U)
#define ENET_DMA_CH_DMA_CHX_INT_EN_RSE_SHIFT     (8U)
/*! RSE - Received stopped enable When this bit is set with Abnormal Interrupt Summary Enable (bit
 *    15 in this register), Receive Stopped Interrupt is enabled.
 */
#define ENET_DMA_CH_DMA_CHX_INT_EN_RSE(x)        (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_INT_EN_RSE_SHIFT)) & ENET_DMA_CH_DMA_CHX_INT_EN_RSE_MASK)
#define ENET_DMA_CH_DMA_CHX_INT_EN_RWTE_MASK     (0x200U)
#define ENET_DMA_CH_DMA_CHX_INT_EN_RWTE_SHIFT    (9U)
/*! RWTE - Receive watchdog timeout enable When this bit is set with Abnormal Interrupt Summary
 *    Enable (bit 15 in this register), the Receive Watchdog Timeout Interrupt is enabled.
 */
#define ENET_DMA_CH_DMA_CHX_INT_EN_RWTE(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_INT_EN_RWTE_SHIFT)) & ENET_DMA_CH_DMA_CHX_INT_EN_RWTE_MASK)
#define ENET_DMA_CH_DMA_CHX_INT_EN_ETIE_MASK     (0x400U)
#define ENET_DMA_CH_DMA_CHX_INT_EN_ETIE_SHIFT    (10U)
/*! ETIE - Early transmit interrupt enable When this bit is set with an Abnormal Interrupt Summary
 *    Enable (bit 15 in this register), Early Transmit Interrupt is enabled.
 */
#define ENET_DMA_CH_DMA_CHX_INT_EN_ETIE(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_INT_EN_ETIE_SHIFT)) & ENET_DMA_CH_DMA_CHX_INT_EN_ETIE_MASK)
#define ENET_DMA_CH_DMA_CHX_INT_EN_ERIE_MASK     (0x800U)
#define ENET_DMA_CH_DMA_CHX_INT_EN_ERIE_SHIFT    (11U)
/*! ERIE - Early receive interrupt enable When this bit is set with Normal Interrupt Summary Enable
 *    (bit 16 in this register), Early Receive Interrupt is enabled.
 */
#define ENET_DMA_CH_DMA_CHX_INT_EN_ERIE(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_INT_EN_ERIE_SHIFT)) & ENET_DMA_CH_DMA_CHX_INT_EN_ERIE_MASK)
#define ENET_DMA_CH_DMA_CHX_INT_EN_FBEE_MASK     (0x1000U)
#define ENET_DMA_CH_DMA_CHX_INT_EN_FBEE_SHIFT    (12U)
/*! FBEE - Fatal bus error enable When this bit is set with Abnormal Interrupt Summary Enable (bit
 *    15 in this register), the Fatal Bus Error Interrupt is enabled.
 */
#define ENET_DMA_CH_DMA_CHX_INT_EN_FBEE(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_INT_EN_FBEE_SHIFT)) & ENET_DMA_CH_DMA_CHX_INT_EN_FBEE_MASK)
#define ENET_DMA_CH_DMA_CHX_INT_EN_AIE_MASK      (0x4000U)
#define ENET_DMA_CH_DMA_CHX_INT_EN_AIE_SHIFT     (14U)
/*! AIE - Abnormal interrupt summary enable When this bit is set, an Abnormal Interrupt summary is enabled.
 */
#define ENET_DMA_CH_DMA_CHX_INT_EN_AIE(x)        (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_INT_EN_AIE_SHIFT)) & ENET_DMA_CH_DMA_CHX_INT_EN_AIE_MASK)
#define ENET_DMA_CH_DMA_CHX_INT_EN_NIE_MASK      (0x8000U)
#define ENET_DMA_CH_DMA_CHX_INT_EN_NIE_SHIFT     (15U)
/*! NIE - Normal interrupt summary enable When this bit is set, a normal interrupt is enabled.
 */
#define ENET_DMA_CH_DMA_CHX_INT_EN_NIE(x)        (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_INT_EN_NIE_SHIFT)) & ENET_DMA_CH_DMA_CHX_INT_EN_NIE_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_INT_EN */
#define ENET_DMA_CH_DMA_CHX_INT_EN_COUNT         (2U)

/*! @name DMA_CH_DMA_CHX_RX_INT_WDTIMER - Receive Interrupt Watchdog Timer */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_RX_INT_WDTIMER_RIWT_MASK (0xFFU)
#define ENET_DMA_CH_DMA_CHX_RX_INT_WDTIMER_RIWT_SHIFT (0U)
/*! RIWT - Receive Interrupt Watchdog Timer Count Indicates the number of system clock cycles
 *    multiplied by 256 for which the watchdog timer is set.
 */
#define ENET_DMA_CH_DMA_CHX_RX_INT_WDTIMER_RIWT(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RX_INT_WDTIMER_RIWT_SHIFT)) & ENET_DMA_CH_DMA_CHX_RX_INT_WDTIMER_RIWT_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_RX_INT_WDTIMER */
#define ENET_DMA_CH_DMA_CHX_RX_INT_WDTIMER_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT - Slot Function Control and Status */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_ESC_MASK (0x1U)
#define ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_ESC_SHIFT (0U)
/*! ESC - Enable Slot Comparison When set, this bit enables the checking of the slot numbers
 *    programmed in the Tx descriptor with the current reference given in the RSN field.
 */
#define ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_ESC(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_ESC_SHIFT)) & ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_ESC_MASK)
#define ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_ASC_MASK (0x2U)
#define ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_ASC_SHIFT (1U)
/*! ASC - Advance Slot Check When set, this bit enables the D MA to fetch the data from the buffer
 *    when the slot number (SLOTNUM) programmed in the Tx descriptor is equal to the reference slot
 *    number given in the RSN field or, ahead of the reference slot number by up to two slots This
 *    bit is applicable only when the ESC bit is set.
 */
#define ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_ASC(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_ASC_SHIFT)) & ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_ASC_MASK)
#define ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_RSN_MASK (0xF0000U)
#define ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_RSN_SHIFT (16U)
/*! RSN - Reference Slot Number This field gives the current value of the reference slot number in the DMA.
 */
#define ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_RSN(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_RSN_SHIFT)) & ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_RSN_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT */
#define ENET_DMA_CH_DMA_CHX_SLOT_FUNC_CTRL_STAT_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_CUR_HST_TXDESC - Channelx Current Host Transmit descriptor */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_CUR_HST_TXDESC_HTD_MASK (0xFFFFFFFFU)
#define ENET_DMA_CH_DMA_CHX_CUR_HST_TXDESC_HTD_SHIFT (0U)
/*! HTD - Host Transmit descriptor Address Pointer Cleared on Reset.
 */
#define ENET_DMA_CH_DMA_CHX_CUR_HST_TXDESC_HTD(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_CUR_HST_TXDESC_HTD_SHIFT)) & ENET_DMA_CH_DMA_CHX_CUR_HST_TXDESC_HTD_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_CUR_HST_TXDESC */
#define ENET_DMA_CH_DMA_CHX_CUR_HST_TXDESC_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_CUR_HST_RXDESC -  */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_CUR_HST_RXDESC_HRD_MASK (0xFFFFFFFFU)
#define ENET_DMA_CH_DMA_CHX_CUR_HST_RXDESC_HRD_SHIFT (0U)
/*! HRD - Host Receive descriptor Address Pointer Cleared on Reset.
 */
#define ENET_DMA_CH_DMA_CHX_CUR_HST_RXDESC_HRD(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_CUR_HST_RXDESC_HRD_SHIFT)) & ENET_DMA_CH_DMA_CHX_CUR_HST_RXDESC_HRD_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_CUR_HST_RXDESC */
#define ENET_DMA_CH_DMA_CHX_CUR_HST_RXDESC_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_CUR_HST_TXBUF -  */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_CUR_HST_TXBUF_HTB_MASK (0xFFFFFFFFU)
#define ENET_DMA_CH_DMA_CHX_CUR_HST_TXBUF_HTB_SHIFT (0U)
/*! HTB - Host Transmit Buffer Address Pointer Cleared on Reset.
 */
#define ENET_DMA_CH_DMA_CHX_CUR_HST_TXBUF_HTB(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_CUR_HST_TXBUF_HTB_SHIFT)) & ENET_DMA_CH_DMA_CHX_CUR_HST_TXBUF_HTB_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_CUR_HST_TXBUF */
#define ENET_DMA_CH_DMA_CHX_CUR_HST_TXBUF_COUNT  (2U)

/*! @name DMA_CH_DMA_CHX_CUR_HST_RXBUF - Channelx Current Application Receive Buffer Address */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_CUR_HST_RXBUF_HRB_MASK (0xFFFFFFFFU)
#define ENET_DMA_CH_DMA_CHX_CUR_HST_RXBUF_HRB_SHIFT (0U)
/*! HRB - Host Receive Buffer Address Pointer Cleared on Reset.
 */
#define ENET_DMA_CH_DMA_CHX_CUR_HST_RXBUF_HRB(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_CUR_HST_RXBUF_HRB_SHIFT)) & ENET_DMA_CH_DMA_CHX_CUR_HST_RXBUF_HRB_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_CUR_HST_RXBUF */
#define ENET_DMA_CH_DMA_CHX_CUR_HST_RXBUF_COUNT  (2U)

/*! @name DMA_CH_DMA_CHX_STAT - Channelx DMA status register */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_STAT_TI_MASK         (0x1U)
#define ENET_DMA_CH_DMA_CHX_STAT_TI_SHIFT        (0U)
/*! TI - Transmit Interrupt This bit indicates that the packet transmission is complete.
 */
#define ENET_DMA_CH_DMA_CHX_STAT_TI(x)           (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_STAT_TI_SHIFT)) & ENET_DMA_CH_DMA_CHX_STAT_TI_MASK)
#define ENET_DMA_CH_DMA_CHX_STAT_TPS_MASK        (0x2U)
#define ENET_DMA_CH_DMA_CHX_STAT_TPS_SHIFT       (1U)
/*! TPS - Transmit Process Stopped This bit is set when the transmission is stopped.
 */
#define ENET_DMA_CH_DMA_CHX_STAT_TPS(x)          (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_STAT_TPS_SHIFT)) & ENET_DMA_CH_DMA_CHX_STAT_TPS_MASK)
#define ENET_DMA_CH_DMA_CHX_STAT_TBU_MASK        (0x4U)
#define ENET_DMA_CH_DMA_CHX_STAT_TBU_SHIFT       (2U)
/*! TBU - Transmit Buffer Unavailable This bit indicates that the application owns the next
 *    descriptor in the transmit list, and the DMA cannot acquire it.
 */
#define ENET_DMA_CH_DMA_CHX_STAT_TBU(x)          (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_STAT_TBU_SHIFT)) & ENET_DMA_CH_DMA_CHX_STAT_TBU_MASK)
#define ENET_DMA_CH_DMA_CHX_STAT_RI_MASK         (0x40U)
#define ENET_DMA_CH_DMA_CHX_STAT_RI_SHIFT        (6U)
/*! RI - Receive Interrupt This bit indicates that the packet reception is complete.
 */
#define ENET_DMA_CH_DMA_CHX_STAT_RI(x)           (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_STAT_RI_SHIFT)) & ENET_DMA_CH_DMA_CHX_STAT_RI_MASK)
#define ENET_DMA_CH_DMA_CHX_STAT_RBU_MASK        (0x80U)
#define ENET_DMA_CH_DMA_CHX_STAT_RBU_SHIFT       (7U)
/*! RBU - Receive Buffer Unavailable This bit indicates that the application owns the next in the
 *    receive list, and the DMA cannot acquire it.
 */
#define ENET_DMA_CH_DMA_CHX_STAT_RBU(x)          (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_STAT_RBU_SHIFT)) & ENET_DMA_CH_DMA_CHX_STAT_RBU_MASK)
#define ENET_DMA_CH_DMA_CHX_STAT_RPS_MASK        (0x100U)
#define ENET_DMA_CH_DMA_CHX_STAT_RPS_SHIFT       (8U)
/*! RPS - Receive Process Stopped This bit is asserted when the Rx process enters the Stopped state.
 */
#define ENET_DMA_CH_DMA_CHX_STAT_RPS(x)          (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_STAT_RPS_SHIFT)) & ENET_DMA_CH_DMA_CHX_STAT_RPS_MASK)
#define ENET_DMA_CH_DMA_CHX_STAT_RWT_MASK        (0x200U)
#define ENET_DMA_CH_DMA_CHX_STAT_RWT_SHIFT       (9U)
/*! RWT - Receive Watchdog time out This bit is asserted when a packet with length greater than
 *    2,048 bytes (10,240 bytes when Jumbo Packet mode is enabled) is received.
 */
#define ENET_DMA_CH_DMA_CHX_STAT_RWT(x)          (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_STAT_RWT_SHIFT)) & ENET_DMA_CH_DMA_CHX_STAT_RWT_MASK)
#define ENET_DMA_CH_DMA_CHX_STAT_ETI_MASK        (0x400U)
#define ENET_DMA_CH_DMA_CHX_STAT_ETI_SHIFT       (10U)
/*! ETI - Early Transmit Interrupt This bit indicates that the packet to be transmitted is fully transferred to the MTL Tx FIFO.
 */
#define ENET_DMA_CH_DMA_CHX_STAT_ETI(x)          (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_STAT_ETI_SHIFT)) & ENET_DMA_CH_DMA_CHX_STAT_ETI_MASK)
#define ENET_DMA_CH_DMA_CHX_STAT_ERI_MASK        (0x800U)
#define ENET_DMA_CH_DMA_CHX_STAT_ERI_SHIFT       (11U)
/*! ERI - Early Receive Interrupt This bit indicates that the DMA filled the first data buffer of the packet.
 */
#define ENET_DMA_CH_DMA_CHX_STAT_ERI(x)          (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_STAT_ERI_SHIFT)) & ENET_DMA_CH_DMA_CHX_STAT_ERI_MASK)
#define ENET_DMA_CH_DMA_CHX_STAT_FBE_MASK        (0x1000U)
#define ENET_DMA_CH_DMA_CHX_STAT_FBE_SHIFT       (12U)
/*! FBE - Fatal Bus Error This bit indicates that a bus error occurred (as described in the EB field).
 */
#define ENET_DMA_CH_DMA_CHX_STAT_FBE(x)          (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_STAT_FBE_SHIFT)) & ENET_DMA_CH_DMA_CHX_STAT_FBE_MASK)
#define ENET_DMA_CH_DMA_CHX_STAT_AIS_MASK        (0x4000U)
#define ENET_DMA_CH_DMA_CHX_STAT_AIS_SHIFT       (14U)
/*! AIS - Abnormal Interrupt Summary Abnormal Interrupt Summary bit value is the logical OR of the
 *    following when the corresponding interrupt bits are enabled in the DMA Channel Interrupt Enable
 *    register Table 778: Bit 1: Transmit Process Stopped Bit 7: Receive Buffer Unavailable Bit 8:
 *    Receive Process Stopped Bit 10: Ear1y Transmit Interrupt Bit 12: Fatal Bus Error Only unmasked
 *    bits affect the Abnormal Interrupt Summary bit.
 */
#define ENET_DMA_CH_DMA_CHX_STAT_AIS(x)          (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_STAT_AIS_SHIFT)) & ENET_DMA_CH_DMA_CHX_STAT_AIS_MASK)
#define ENET_DMA_CH_DMA_CHX_STAT_NIS_MASK        (0x8000U)
#define ENET_DMA_CH_DMA_CHX_STAT_NIS_SHIFT       (15U)
/*! NIS - Normal Interrupt Summary Normal Interrupt Summary bit value is the logical OR of the
 *    following bits when the corresponding interrupt bits are enabled in the DMA Channel Interrupt
 *    Enable register Table 778: Bit 0: Transmit Interrupt Bit 2: Transmit Buffer Unavailable Bit 6:
 *    Receive Interrupt Bit 11: Early Receive Interrupt Only unmasked bits (interrupts for which
 *    interrupt enable is set in DMA Channel Interrupt Enable register Table 778) affect the Normal
 *    Interrupt Summary bit.
 */
#define ENET_DMA_CH_DMA_CHX_STAT_NIS(x)          (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_STAT_NIS_SHIFT)) & ENET_DMA_CH_DMA_CHX_STAT_NIS_MASK)
#define ENET_DMA_CH_DMA_CHX_STAT_EB_MASK         (0x70000U)
#define ENET_DMA_CH_DMA_CHX_STAT_EB_SHIFT        (16U)
/*! EB - DMA Error Bits This field indicates the type of error that caused a Bus Error.
 */
#define ENET_DMA_CH_DMA_CHX_STAT_EB(x)           (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_STAT_EB_SHIFT)) & ENET_DMA_CH_DMA_CHX_STAT_EB_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_STAT */
#define ENET_DMA_CH_DMA_CHX_STAT_COUNT           (2U)

/*! @name DMA_CH_DMA_CHX_MISS_FRAME_CNT - Channelx missed frame count. */
/*! @{ */
#define ENET_DMA_CH_DMA_CHX_MISS_FRAME_CNT_MFC_MASK (0x7FFU)
#define ENET_DMA_CH_DMA_CHX_MISS_FRAME_CNT_MFC_SHIFT (0U)
/*! MFC - Dropped packet counters.
 */
#define ENET_DMA_CH_DMA_CHX_MISS_FRAME_CNT_MFC(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_MISS_FRAME_CNT_MFC_SHIFT)) & ENET_DMA_CH_DMA_CHX_MISS_FRAME_CNT_MFC_MASK)
#define ENET_DMA_CH_DMA_CHX_MISS_FRAME_CNT_MFCO_MASK (0x8000U)
#define ENET_DMA_CH_DMA_CHX_MISS_FRAME_CNT_MFCO_SHIFT (15U)
/*! MFCO - Overflow status of the MFC counter.
 */
#define ENET_DMA_CH_DMA_CHX_MISS_FRAME_CNT_MFCO(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_MISS_FRAME_CNT_MFCO_SHIFT)) & ENET_DMA_CH_DMA_CHX_MISS_FRAME_CNT_MFCO_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_MISS_FRAME_CNT */
#define ENET_DMA_CH_DMA_CHX_MISS_FRAME_CNT_COUNT (2U)


/*!
 * @}
 */ /* end of group ENET_Register_Masks */


/* ENET - Peripheral instance base addresses */
/** Peripheral ENET base address */
#define ENET_BASE                                (0x40092000u)
/** Peripheral ENET base pointer */
#define ENET                                     ((ENET_Type *)ENET_BASE)
/** Array initializer of ENET peripheral base addresses */
#define ENET_BASE_ADDRS                          { ENET_BASE }
/** Array initializer of ENET peripheral base pointers */
#define ENET_BASE_PTRS                           { ENET }
/** Interrupt vectors for the ENET peripheral type */
#define ENET_IRQS                                { ETHERNET_IRQn }
#define ENET_PMT_IRQS                            { ETHERNET_PMT_IRQn }
#define ENET_MACLP_IRQS                          { ETHERNET_MACLP_IRQn }

/*!
 * @}
 */ /* end of group ENET_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXCOMM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXCOMM_Peripheral_Access_Layer FLEXCOMM Peripheral Access Layer
 * @{
 */

/** FLEXCOMM - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[4088];
  __IO uint32_t PSELID;                            /**< Peripheral Select and Flexcomm ID register., offset: 0xFF8 */
  __I  uint32_t PID;                               /**< Peripheral identification register., offset: 0xFFC */
} FLEXCOMM_Type;

/* ----------------------------------------------------------------------------
   -- FLEXCOMM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXCOMM_Register_Masks FLEXCOMM Register Masks
 * @{
 */

/*! @name PSELID - Peripheral Select and Flexcomm ID register. */
/*! @{ */
#define FLEXCOMM_PSELID_PERSEL_MASK              (0x7U)
#define FLEXCOMM_PSELID_PERSEL_SHIFT             (0U)
/*! PERSEL - Peripheral Select. This field is writable by software.
 *  0b000..No peripheral selected.
 *  0b001..USART function selected.
 *  0b010..SPI function selected.
 *  0b011..I2C function selected.
 *  0b100..I2S transmit function selected.
 *  0b101..I2S receive function selected.
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define FLEXCOMM_PSELID_PERSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_PERSEL_SHIFT)) & FLEXCOMM_PSELID_PERSEL_MASK)
#define FLEXCOMM_PSELID_LOCK_MASK                (0x8U)
#define FLEXCOMM_PSELID_LOCK_SHIFT               (3U)
/*! LOCK - Lock the peripheral select. This field is writable by software.
 *  0b0..Peripheral select can be changed by software.
 *  0b1..Peripheral select is locked and cannot be changed until this Flexcomm or the entire device is reset.
 */
#define FLEXCOMM_PSELID_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_LOCK_SHIFT)) & FLEXCOMM_PSELID_LOCK_MASK)
#define FLEXCOMM_PSELID_USARTPRESENT_MASK        (0x10U)
#define FLEXCOMM_PSELID_USARTPRESENT_SHIFT       (4U)
/*! USARTPRESENT - USART present indicator. This field is Read-only.
 *  0b0..This Flexcomm does not include the USART function.
 *  0b1..This Flexcomm includes the USART function.
 */
#define FLEXCOMM_PSELID_USARTPRESENT(x)          (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_USARTPRESENT_SHIFT)) & FLEXCOMM_PSELID_USARTPRESENT_MASK)
#define FLEXCOMM_PSELID_SPIPRESENT_MASK          (0x20U)
#define FLEXCOMM_PSELID_SPIPRESENT_SHIFT         (5U)
/*! SPIPRESENT - SPI present indicator. This field is Read-only.
 *  0b0..This Flexcomm does not include the SPI function.
 *  0b1..This Flexcomm includes the SPI function.
 */
#define FLEXCOMM_PSELID_SPIPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_SPIPRESENT_SHIFT)) & FLEXCOMM_PSELID_SPIPRESENT_MASK)
#define FLEXCOMM_PSELID_I2CPRESENT_MASK          (0x40U)
#define FLEXCOMM_PSELID_I2CPRESENT_SHIFT         (6U)
/*! I2CPRESENT - I2C present indicator. This field is Read-only.
 *  0b0..This Flexcomm does not include the I2C function.
 *  0b1..This Flexcomm includes the I2C function.
 */
#define FLEXCOMM_PSELID_I2CPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_I2CPRESENT_SHIFT)) & FLEXCOMM_PSELID_I2CPRESENT_MASK)
#define FLEXCOMM_PSELID_I2SPRESENT_MASK          (0x80U)
#define FLEXCOMM_PSELID_I2SPRESENT_SHIFT         (7U)
/*! I2SPRESENT - I 2S present indicator. This field is Read-only.
 *  0b0..This Flexcomm does not include the I2S function.
 *  0b1..This Flexcomm includes the I2S function.
 */
#define FLEXCOMM_PSELID_I2SPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_I2SPRESENT_SHIFT)) & FLEXCOMM_PSELID_I2SPRESENT_MASK)
#define FLEXCOMM_PSELID_ID_MASK                  (0xFFFFF000U)
#define FLEXCOMM_PSELID_ID_SHIFT                 (12U)
/*! ID - Flexcomm ID.
 */
#define FLEXCOMM_PSELID_ID(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_ID_SHIFT)) & FLEXCOMM_PSELID_ID_MASK)
/*! @} */

/*! @name PID - Peripheral identification register. */
/*! @{ */
#define FLEXCOMM_PID_Minor_Rev_MASK              (0xF00U)
#define FLEXCOMM_PID_Minor_Rev_SHIFT             (8U)
/*! Minor_Rev - Minor revision of module implementation.
 */
#define FLEXCOMM_PID_Minor_Rev(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_Minor_Rev_SHIFT)) & FLEXCOMM_PID_Minor_Rev_MASK)
#define FLEXCOMM_PID_Major_Rev_MASK              (0xF000U)
#define FLEXCOMM_PID_Major_Rev_SHIFT             (12U)
/*! Major_Rev - Major revision of module implementation.
 */
#define FLEXCOMM_PID_Major_Rev(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_Major_Rev_SHIFT)) & FLEXCOMM_PID_Major_Rev_MASK)
#define FLEXCOMM_PID_ID_MASK                     (0xFFFF0000U)
#define FLEXCOMM_PID_ID_SHIFT                    (16U)
/*! ID - Module identifier for the selected function.
 */
#define FLEXCOMM_PID_ID(x)                       (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_ID_SHIFT)) & FLEXCOMM_PID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FLEXCOMM_Register_Masks */


/* FLEXCOMM - Peripheral instance base addresses */
/** Peripheral FLEXCOMM0 base address */
#define FLEXCOMM0_BASE                           (0x40086000u)
/** Peripheral FLEXCOMM0 base pointer */
#define FLEXCOMM0                                ((FLEXCOMM_Type *)FLEXCOMM0_BASE)
/** Peripheral FLEXCOMM1 base address */
#define FLEXCOMM1_BASE                           (0x40087000u)
/** Peripheral FLEXCOMM1 base pointer */
#define FLEXCOMM1                                ((FLEXCOMM_Type *)FLEXCOMM1_BASE)
/** Peripheral FLEXCOMM2 base address */
#define FLEXCOMM2_BASE                           (0x40088000u)
/** Peripheral FLEXCOMM2 base pointer */
#define FLEXCOMM2                                ((FLEXCOMM_Type *)FLEXCOMM2_BASE)
/** Peripheral FLEXCOMM3 base address */
#define FLEXCOMM3_BASE                           (0x40089000u)
/** Peripheral FLEXCOMM3 base pointer */
#define FLEXCOMM3                                ((FLEXCOMM_Type *)FLEXCOMM3_BASE)
/** Peripheral FLEXCOMM4 base address */
#define FLEXCOMM4_BASE                           (0x4008A000u)
/** Peripheral FLEXCOMM4 base pointer */
#define FLEXCOMM4                                ((FLEXCOMM_Type *)FLEXCOMM4_BASE)
/** Peripheral FLEXCOMM5 base address */
#define FLEXCOMM5_BASE                           (0x40096000u)
/** Peripheral FLEXCOMM5 base pointer */
#define FLEXCOMM5                                ((FLEXCOMM_Type *)FLEXCOMM5_BASE)
/** Peripheral FLEXCOMM6 base address */
#define FLEXCOMM6_BASE                           (0x40097000u)
/** Peripheral FLEXCOMM6 base pointer */
#define FLEXCOMM6                                ((FLEXCOMM_Type *)FLEXCOMM6_BASE)
/** Peripheral FLEXCOMM7 base address */
#define FLEXCOMM7_BASE                           (0x40098000u)
/** Peripheral FLEXCOMM7 base pointer */
#define FLEXCOMM7                                ((FLEXCOMM_Type *)FLEXCOMM7_BASE)
/** Peripheral FLEXCOMM8 base address */
#define FLEXCOMM8_BASE                           (0x40099000u)
/** Peripheral FLEXCOMM8 base pointer */
#define FLEXCOMM8                                ((FLEXCOMM_Type *)FLEXCOMM8_BASE)
/** Peripheral FLEXCOMM9 base address */
#define FLEXCOMM9_BASE                           (0x4009A000u)
/** Peripheral FLEXCOMM9 base pointer */
#define FLEXCOMM9                                ((FLEXCOMM_Type *)FLEXCOMM9_BASE)
/** Peripheral FLEXCOMM10 base address */
#define FLEXCOMM10_BASE                          (0x4009F000u)
/** Peripheral FLEXCOMM10 base pointer */
#define FLEXCOMM10                               ((FLEXCOMM_Type *)FLEXCOMM10_BASE)
/** Array initializer of FLEXCOMM peripheral base addresses */
#define FLEXCOMM_BASE_ADDRS                      { FLEXCOMM0_BASE, FLEXCOMM1_BASE, FLEXCOMM2_BASE, FLEXCOMM3_BASE, FLEXCOMM4_BASE, FLEXCOMM5_BASE, FLEXCOMM6_BASE, FLEXCOMM7_BASE, FLEXCOMM8_BASE, FLEXCOMM9_BASE, FLEXCOMM10_BASE }
/** Array initializer of FLEXCOMM peripheral base pointers */
#define FLEXCOMM_BASE_PTRS                       { FLEXCOMM0, FLEXCOMM1, FLEXCOMM2, FLEXCOMM3, FLEXCOMM4, FLEXCOMM5, FLEXCOMM6, FLEXCOMM7, FLEXCOMM8, FLEXCOMM9, FLEXCOMM10 }
/** Interrupt vectors for the FLEXCOMM peripheral type */
#define FLEXCOMM_IRQS                            { FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, FLEXCOMM6_IRQn, FLEXCOMM7_IRQn, FLEXCOMM8_IRQn, FLEXCOMM9_IRQn, FLEXCOMM10_IRQn }

/*!
 * @}
 */ /* end of group FLEXCOMM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GINT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GINT_Peripheral_Access_Layer GINT Peripheral Access Layer
 * @{
 */

/** GINT - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< GPIO grouped interrupt control register, offset: 0x0 */
       uint8_t RESERVED_0[28];
  __IO uint32_t PORT_POL[2];                       /**< GPIO grouped interrupt port 0 polarity register, array offset: 0x20, array step: 0x4 */
       uint8_t RESERVED_1[24];
  __IO uint32_t PORT_ENA[2];                       /**< GPIO grouped interrupt port 0 enable register, array offset: 0x40, array step: 0x4 */
} GINT_Type;

/* ----------------------------------------------------------------------------
   -- GINT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GINT_Register_Masks GINT Register Masks
 * @{
 */

/*! @name CTRL - GPIO grouped interrupt control register */
/*! @{ */
#define GINT_CTRL_INT_MASK                       (0x1U)
#define GINT_CTRL_INT_SHIFT                      (0U)
/*! INT - Group interrupt status. This bit is cleared by writing a one to it. Writing zero has no effect.
 *  0b0..No request. No interrupt request is pending.
 *  0b1..Request active. Interrupt request is active.
 */
#define GINT_CTRL_INT(x)                         (((uint32_t)(((uint32_t)(x)) << GINT_CTRL_INT_SHIFT)) & GINT_CTRL_INT_MASK)
#define GINT_CTRL_COMB_MASK                      (0x2U)
#define GINT_CTRL_COMB_SHIFT                     (1U)
/*! COMB - Combine enabled inputs for group interrupt
 *  0b0..Or. OR functionality: A grouped interrupt is generated when any one of the enabled inputs is active (based on its programmed polarity).
 *  0b1..And. AND functionality: An interrupt is generated when all enabled bits are active (based on their programmed polarity).
 */
#define GINT_CTRL_COMB(x)                        (((uint32_t)(((uint32_t)(x)) << GINT_CTRL_COMB_SHIFT)) & GINT_CTRL_COMB_MASK)
#define GINT_CTRL_TRIG_MASK                      (0x4U)
#define GINT_CTRL_TRIG_SHIFT                     (2U)
/*! TRIG - Group interrupt trigger
 *  0b0..Edge-triggered.
 *  0b1..Level-triggered.
 */
#define GINT_CTRL_TRIG(x)                        (((uint32_t)(((uint32_t)(x)) << GINT_CTRL_TRIG_SHIFT)) & GINT_CTRL_TRIG_MASK)
/*! @} */

/*! @name PORT_POL - GPIO grouped interrupt port 0 polarity register */
/*! @{ */
#define GINT_PORT_POL_POL_MASK                   (0xFFFFFFFFU)
#define GINT_PORT_POL_POL_SHIFT                  (0U)
/*! POL - Configure pin polarity of port m pins for group interrupt. Bit n corresponds to pin PIOm_n
 *    of port m. 0 = the pin is active LOW. If the level on this pin is LOW, the pin contributes to
 *    the group interrupt. 1 = the pin is active HIGH. If the level on this pin is HIGH, the pin
 *    contributes to the group interrupt.
 */
#define GINT_PORT_POL_POL(x)                     (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL_SHIFT)) & GINT_PORT_POL_POL_MASK)
/*! @} */

/* The count of GINT_PORT_POL */
#define GINT_PORT_POL_COUNT                      (2U)

/*! @name PORT_ENA - GPIO grouped interrupt port 0 enable register */
/*! @{ */
#define GINT_PORT_ENA_ENA_MASK                   (0xFFFFFFFFU)
#define GINT_PORT_ENA_ENA_SHIFT                  (0U)
/*! ENA - Enable port 0 pin for group interrupt. Bit n corresponds to pin Pm_n of port m. 0 = the
 *    port 0 pin is disabled and does not contribute to the grouped interrupt. 1 = the port 0 pin is
 *    enabled and contributes to the grouped interrupt.
 */
#define GINT_PORT_ENA_ENA(x)                     (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA_SHIFT)) & GINT_PORT_ENA_ENA_MASK)
/*! @} */

/* The count of GINT_PORT_ENA */
#define GINT_PORT_ENA_COUNT                      (2U)


/*!
 * @}
 */ /* end of group GINT_Register_Masks */


/* GINT - Peripheral instance base addresses */
/** Peripheral GINT0 base address */
#define GINT0_BASE                               (0x40002000u)
/** Peripheral GINT0 base pointer */
#define GINT0                                    ((GINT_Type *)GINT0_BASE)
/** Peripheral GINT1 base address */
#define GINT1_BASE                               (0x40003000u)
/** Peripheral GINT1 base pointer */
#define GINT1                                    ((GINT_Type *)GINT1_BASE)
/** Array initializer of GINT peripheral base addresses */
#define GINT_BASE_ADDRS                          { GINT0_BASE, GINT1_BASE }
/** Array initializer of GINT peripheral base pointers */
#define GINT_BASE_PTRS                           { GINT0, GINT1 }
/** Interrupt vectors for the GINT peripheral type */
#define GINT_IRQS                                { GINT0_IRQn, GINT1_IRQn }

/*!
 * @}
 */ /* end of group GINT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GPIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Peripheral_Access_Layer GPIO Peripheral Access Layer
 * @{
 */

/** GPIO - Register Layout Typedef */
typedef struct {
  __IO uint8_t B[6][32];                           /**< Byte pin registers for all port 0 and 1 GPIO pins, array offset: 0x0, array step: index*0x20, index2*0x1 */
       uint8_t RESERVED_0[3904];
  __IO uint32_t W[6][32];                          /**< Word pin registers for all port 0 and 1 GPIO pins, array offset: 0x1000, array step: index*0x80, index2*0x4 */
       uint8_t RESERVED_1[3328];
  __IO uint32_t DIR[6];                            /**< Direction registers, array offset: 0x2000, array step: 0x4 */
       uint8_t RESERVED_2[104];
  __IO uint32_t MASK[6];                           /**< Mask register, array offset: 0x2080, array step: 0x4 */
       uint8_t RESERVED_3[104];
  __IO uint32_t PIN[6];                            /**< Port pin register, array offset: 0x2100, array step: 0x4 */
       uint8_t RESERVED_4[104];
  __IO uint32_t MPIN[6];                           /**< Masked port register, array offset: 0x2180, array step: 0x4 */
       uint8_t RESERVED_5[104];
  __IO uint32_t SET[6];                            /**< Write: Set register for port Read: output bits for port, array offset: 0x2200, array step: 0x4 */
       uint8_t RESERVED_6[104];
  __O  uint32_t CLR[6];                            /**< Clear port, array offset: 0x2280, array step: 0x4 */
       uint8_t RESERVED_7[104];
  __O  uint32_t NOT[6];                            /**< Toggle port, array offset: 0x2300, array step: 0x4 */
       uint8_t RESERVED_8[104];
  __O  uint32_t DIRSET[6];                         /**< Set pin direction bits for port, array offset: 0x2380, array step: 0x4 */
       uint8_t RESERVED_9[104];
  __O  uint32_t DIRCLR[6];                         /**< Clear pin direction bits for port, array offset: 0x2400, array step: 0x4 */
       uint8_t RESERVED_10[104];
  __O  uint32_t DIRNOT[6];                         /**< Toggle pin direction bits for port, array offset: 0x2480, array step: 0x4 */
} GPIO_Type;

/* ----------------------------------------------------------------------------
   -- GPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Masks GPIO Register Masks
 * @{
 */

/*! @name B - Byte pin registers for all port 0 and 1 GPIO pins */
/*! @{ */
#define GPIO_B_PBYTE_MASK                        (0x1U)
#define GPIO_B_PBYTE_SHIFT                       (0U)
/*! PBYTE - Read: state of the pin PIOm_n, regardless of direction, masking, or alternate function,
 *    except that pins configured as analog I/O always read as 0. One register for each port pin.
 *    Supported pins depends on the specific device and package. Write: loads the pin's output bit.
 *    One register for each port pin. Supported pins depends on the specific device and package.
 */
#define GPIO_B_PBYTE(x)                          (((uint8_t)(((uint8_t)(x)) << GPIO_B_PBYTE_SHIFT)) & GPIO_B_PBYTE_MASK)
/*! @} */

/* The count of GPIO_B */
#define GPIO_B_COUNT                             (6U)

/* The count of GPIO_B */
#define GPIO_B_COUNT2                            (32U)

/*! @name W - Word pin registers for all port 0 and 1 GPIO pins */
/*! @{ */
#define GPIO_W_PWORD_MASK                        (0xFFFFFFFFU)
#define GPIO_W_PWORD_SHIFT                       (0U)
/*! PWORD - Read 0: pin PIOm_n is LOW. Write 0: clear output bit. Read 0xFFFF FFFF: pin PIOm_n is
 *    HIGH. Write any value 0x0000 0001 to 0xFFFF FFFF: set output bit. Only 0 or 0xFFFF FFFF can be
 *    read. Writing any value other than 0 will set the output bit. One register for each port pin.
 *    Supported pins depends on the specific device and package.
 */
#define GPIO_W_PWORD(x)                          (((uint32_t)(((uint32_t)(x)) << GPIO_W_PWORD_SHIFT)) & GPIO_W_PWORD_MASK)
/*! @} */

/* The count of GPIO_W */
#define GPIO_W_COUNT                             (6U)

/* The count of GPIO_W */
#define GPIO_W_COUNT2                            (32U)

/*! @name DIR - Direction registers */
/*! @{ */
#define GPIO_DIR_DIRP_MASK                       (0xFFFFFFFFU)
#define GPIO_DIR_DIRP_SHIFT                      (0U)
/*! DIRP - Selects pin direction for pin PIOm_n (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported
 *    pins depends on the specific device and package. 0 = input. 1 = output.
 */
#define GPIO_DIR_DIRP(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP_SHIFT)) & GPIO_DIR_DIRP_MASK)
/*! @} */

/* The count of GPIO_DIR */
#define GPIO_DIR_COUNT                           (6U)

/*! @name MASK - Mask register */
/*! @{ */
#define GPIO_MASK_MASKP_MASK                     (0xFFFFFFFFU)
#define GPIO_MASK_MASKP_SHIFT                    (0U)
/*! MASKP - Controls which bits corresponding to PIOm_n are active in the MPORT register (bit 0 =
 *    PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on the specific device and package. 0 =
 *    Read MPORT: pin state; write MPORT: load output bit. 1 = Read MPORT: 0; write MPORT: output bit
 *    not affected.
 */
#define GPIO_MASK_MASKP(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP_SHIFT)) & GPIO_MASK_MASKP_MASK)
/*! @} */

/* The count of GPIO_MASK */
#define GPIO_MASK_COUNT                          (6U)

/*! @name PIN - Port pin register */
/*! @{ */
#define GPIO_PIN_PORT_MASK                       (0xFFFFFFFFU)
#define GPIO_PIN_PORT_SHIFT                      (0U)
/*! PORT - Reads pin states or loads output bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported
 *    pins depends on the specific device and package. 0 = Read: pin is low; write: clear output bit.
 *    1 = Read: pin is high; write: set output bit.
 */
#define GPIO_PIN_PORT(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT_SHIFT)) & GPIO_PIN_PORT_MASK)
/*! @} */

/* The count of GPIO_PIN */
#define GPIO_PIN_COUNT                           (6U)

/*! @name MPIN - Masked port register */
/*! @{ */
#define GPIO_MPIN_MPORTP_MASK                    (0xFFFFFFFFU)
#define GPIO_MPIN_MPORTP_SHIFT                   (0U)
/*! MPORTP - Masked port register (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on
 *    the specific device and package. 0 = Read: pin is LOW and/or the corresponding bit in the MASK
 *    register is 1; write: clear output bit if the corresponding bit in the MASK register is 0. 1
 *    = Read: pin is HIGH and the corresponding bit in the MASK register is 0; write: set output bit
 *    if the corresponding bit in the MASK register is 0.
 */
#define GPIO_MPIN_MPORTP(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP_SHIFT)) & GPIO_MPIN_MPORTP_MASK)
/*! @} */

/* The count of GPIO_MPIN */
#define GPIO_MPIN_COUNT                          (6U)

/*! @name SET - Write: Set register for port Read: output bits for port */
/*! @{ */
#define GPIO_SET_SETP_MASK                       (0xFFFFFFFFU)
#define GPIO_SET_SETP_SHIFT                      (0U)
/*! SETP - Read or set output bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on
 *    the specific device and package. 0 = Read: output bit: write: no operation. 1 = Read: output
 *    bit; write: set output bit.
 */
#define GPIO_SET_SETP(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_SET_SETP_SHIFT)) & GPIO_SET_SETP_MASK)
/*! @} */

/* The count of GPIO_SET */
#define GPIO_SET_COUNT                           (6U)

/*! @name CLR - Clear port */
/*! @{ */
#define GPIO_CLR_CLRP_MASK                       (0xFFFFFFFFU)
#define GPIO_CLR_CLRP_SHIFT                      (0U)
/*! CLRP - Clear output bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on the
 *    specific device and package. 0 = No operation. 1 = Clear output bit.
 */
#define GPIO_CLR_CLRP(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP_SHIFT)) & GPIO_CLR_CLRP_MASK)
/*! @} */

/* The count of GPIO_CLR */
#define GPIO_CLR_COUNT                           (6U)

/*! @name NOT - Toggle port */
/*! @{ */
#define GPIO_NOT_NOTP_MASK                       (0xFFFFFFFFU)
#define GPIO_NOT_NOTP_SHIFT                      (0U)
/*! NOTP - Toggle output bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on the
 *    specific device and package. 0 = no operation. 1 = Toggle output bit.
 */
#define GPIO_NOT_NOTP(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP_SHIFT)) & GPIO_NOT_NOTP_MASK)
/*! @} */

/* The count of GPIO_NOT */
#define GPIO_NOT_COUNT                           (6U)

/*! @name DIRSET - Set pin direction bits for port */
/*! @{ */
#define GPIO_DIRSET_DIRSETP_MASK                 (0x1FFFFFFFU)
#define GPIO_DIRSET_DIRSETP_SHIFT                (0U)
/*! DIRSETP - Set direction bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on
 *    the specific device and package. 0 = No operation. 1 = Set direction bit.
 */
#define GPIO_DIRSET_DIRSETP(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP_SHIFT)) & GPIO_DIRSET_DIRSETP_MASK)
/*! @} */

/* The count of GPIO_DIRSET */
#define GPIO_DIRSET_COUNT                        (6U)

/*! @name DIRCLR - Clear pin direction bits for port */
/*! @{ */
#define GPIO_DIRCLR_DIRCLRP_MASK                 (0x1FFFFFFFU)
#define GPIO_DIRCLR_DIRCLRP_SHIFT                (0U)
/*! DIRCLRP - Clear direction bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on
 *    the specific device and package. 0 = No operation. 1 = Clear direction bit.
 */
#define GPIO_DIRCLR_DIRCLRP(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP_SHIFT)) & GPIO_DIRCLR_DIRCLRP_MASK)
/*! @} */

/* The count of GPIO_DIRCLR */
#define GPIO_DIRCLR_COUNT                        (6U)

/*! @name DIRNOT - Toggle pin direction bits for port */
/*! @{ */
#define GPIO_DIRNOT_DIRNOTP_MASK                 (0x1FFFFFFFU)
#define GPIO_DIRNOT_DIRNOTP_SHIFT                (0U)
/*! DIRNOTP - Toggle direction bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends
 *    on the specific device and package. 0 = no operation. 1 = Toggle direction bit.
 */
#define GPIO_DIRNOT_DIRNOTP(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_DIRNOT_DIRNOTP_SHIFT)) & GPIO_DIRNOT_DIRNOTP_MASK)
/*! @} */

/* The count of GPIO_DIRNOT */
#define GPIO_DIRNOT_COUNT                        (6U)


/*!
 * @}
 */ /* end of group GPIO_Register_Masks */


/* GPIO - Peripheral instance base addresses */
/** Peripheral GPIO base address */
#define GPIO_BASE                                (0x4008C000u)
/** Peripheral GPIO base pointer */
#define GPIO                                     ((GPIO_Type *)GPIO_BASE)
/** Array initializer of GPIO peripheral base addresses */
#define GPIO_BASE_ADDRS                          { GPIO_BASE }
/** Array initializer of GPIO peripheral base pointers */
#define GPIO_BASE_PTRS                           { GPIO }

/*!
 * @}
 */ /* end of group GPIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- I2C Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Peripheral_Access_Layer I2C Peripheral Access Layer
 * @{
 */

/** I2C - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[2048];
  __IO uint32_t CFG;                               /**< Configuration for shared functions., offset: 0x800 */
  __IO uint32_t STAT;                              /**< Status register for Master, Slave, and Monitor functions., offset: 0x804 */
  __IO uint32_t INTENSET;                          /**< Interrupt Enable Set and read register., offset: 0x808 */
  __O  uint32_t INTENCLR;                          /**< Interrupt Enable Clear register., offset: 0x80C */
  __IO uint32_t TIMEOUT;                           /**< Time-out value register., offset: 0x810 */
  __IO uint32_t CLKDIV;                            /**< Clock pre-divider for the entire I2C interface. This determines what time increments are used for the MSTTIME register, and controls some timing of the Slave function., offset: 0x814 */
  __I  uint32_t INTSTAT;                           /**< Interrupt Status register for Master, Slave, and Monitor functions., offset: 0x818 */
       uint8_t RESERVED_1[4];
  __IO uint32_t MSTCTL;                            /**< Master control register., offset: 0x820 */
  __IO uint32_t MSTTIME;                           /**< Master timing configuration., offset: 0x824 */
  __IO uint32_t MSTDAT;                            /**< Combined Master receiver and transmitter data register., offset: 0x828 */
       uint8_t RESERVED_2[20];
  __IO uint32_t SLVCTL;                            /**< Slave control register., offset: 0x840 */
  __IO uint32_t SLVDAT;                            /**< Combined Slave receiver and transmitter data register., offset: 0x844 */
  __IO uint32_t SLVADR[4];                         /**< Slave address register., array offset: 0x848, array step: 0x4 */
  __IO uint32_t SLVQUAL0;                          /**< Slave Qualification for address 0., offset: 0x858 */
       uint8_t RESERVED_3[36];
  __I  uint32_t MONRXDAT;                          /**< Monitor receiver data register., offset: 0x880 */
       uint8_t RESERVED_4[1912];
  __I  uint32_t ID;                                /**< Peripheral identification register., offset: 0xFFC */
} I2C_Type;

/* ----------------------------------------------------------------------------
   -- I2C Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Register_Masks I2C Register Masks
 * @{
 */

/*! @name CFG - Configuration for shared functions. */
/*! @{ */
#define I2C_CFG_MSTEN_MASK                       (0x1U)
#define I2C_CFG_MSTEN_SHIFT                      (0U)
/*! MSTEN - Master Enable. When disabled, configurations settings for the Master function are not
 *    changed, but the Master function is internally reset.
 *  0b0..Disabled. The I2C Master function is disabled.
 *  0b1..Enabled. The I2C Master function is enabled.
 */
#define I2C_CFG_MSTEN(x)                         (((uint32_t)(((uint32_t)(x)) << I2C_CFG_MSTEN_SHIFT)) & I2C_CFG_MSTEN_MASK)
#define I2C_CFG_SLVEN_MASK                       (0x2U)
#define I2C_CFG_SLVEN_SHIFT                      (1U)
/*! SLVEN - Slave Enable. When disabled, configurations settings for the Slave function are not
 *    changed, but the Slave function is internally reset.
 *  0b0..Disabled. The I2C slave function is disabled.
 *  0b1..Enabled. The I2C slave function is enabled.
 */
#define I2C_CFG_SLVEN(x)                         (((uint32_t)(((uint32_t)(x)) << I2C_CFG_SLVEN_SHIFT)) & I2C_CFG_SLVEN_MASK)
#define I2C_CFG_MONEN_MASK                       (0x4U)
#define I2C_CFG_MONEN_SHIFT                      (2U)
/*! MONEN - Monitor Enable. When disabled, configurations settings for the Monitor function are not
 *    changed, but the Monitor function is internally reset.
 *  0b0..Disabled. The I2C Monitor function is disabled.
 *  0b1..Enabled. The I2C Monitor function is enabled.
 */
#define I2C_CFG_MONEN(x)                         (((uint32_t)(((uint32_t)(x)) << I2C_CFG_MONEN_SHIFT)) & I2C_CFG_MONEN_MASK)
#define I2C_CFG_TIMEOUTEN_MASK                   (0x8U)
#define I2C_CFG_TIMEOUTEN_SHIFT                  (3U)
/*! TIMEOUTEN - I2C bus Time-out Enable. When disabled, the time-out function is internally reset.
 *  0b0..Disabled. Time-out function is disabled.
 *  0b1..Enabled. Time-out function is enabled. Both types of time-out flags will be generated and will cause
 *       interrupts if they are enabled. Typically, only one time-out will be used in a system.
 */
#define I2C_CFG_TIMEOUTEN(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_CFG_TIMEOUTEN_SHIFT)) & I2C_CFG_TIMEOUTEN_MASK)
#define I2C_CFG_MONCLKSTR_MASK                   (0x10U)
#define I2C_CFG_MONCLKSTR_SHIFT                  (4U)
/*! MONCLKSTR - Monitor function Clock Stretching.
 *  0b0..Disabled. The Monitor function will not perform clock stretching. Software or DMA may not always be able
 *       to read data provided by the Monitor function before it is overwritten. This mode may be used when
 *       non-invasive monitoring is critical.
 *  0b1..Enabled. The Monitor function will perform clock stretching in order to ensure that software or DMA can
 *       read all incoming data supplied by the Monitor function.
 */
#define I2C_CFG_MONCLKSTR(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_CFG_MONCLKSTR_SHIFT)) & I2C_CFG_MONCLKSTR_MASK)
#define I2C_CFG_HSCAPABLE_MASK                   (0x20U)
#define I2C_CFG_HSCAPABLE_SHIFT                  (5U)
/*! HSCAPABLE - High-speed mode Capable enable. Since High Speed mode alters the way I2C pins drive
 *    and filter, as well as the timing for certain I2C signalling, enabling High-speed mode applies
 *    to all functions: Master, Slave, and Monitor.
 *  0b0..Fast-mode plus. The I 2C interface will support Standard-mode, Fast-mode, and Fast-mode Plus, to the
 *       extent that the pin electronics support these modes. Any changes that need to be made to the pin controls,
 *       such as changing the drive strength or filtering, must be made by software via the IOCON register associated
 *       with each I2C pin,
 *  0b1..High-speed. In addition to Standard-mode, Fast-mode, and Fast-mode Plus, the I 2C interface will support
 *       High-speed mode to the extent that the pin electronics support these modes. See Section 25.7.2.2 for more
 *       information.
 */
#define I2C_CFG_HSCAPABLE(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_CFG_HSCAPABLE_SHIFT)) & I2C_CFG_HSCAPABLE_MASK)
/*! @} */

/*! @name STAT - Status register for Master, Slave, and Monitor functions. */
/*! @{ */
#define I2C_STAT_MSTPENDING_MASK                 (0x1U)
#define I2C_STAT_MSTPENDING_SHIFT                (0U)
/*! MSTPENDING - Master Pending. Indicates that the Master is waiting to continue communication on
 *    the I2C-bus (pending) or is idle. When the master is pending, the MSTSTATE bits indicate what
 *    type of software service if any the master expects. This flag will cause an interrupt when set
 *    if, enabled via the INTENSET register. The MSTPENDING flag is not set when the DMA is handling
 *    an event (if the MSTDMA bit in the MSTCTL register is set). If the master is in the idle
 *    state, and no communication is needed, mask this interrupt.
 *  0b0..In progress. Communication is in progress and the Master function is busy and cannot currently accept a command.
 *  0b1..Pending. The Master function needs software service or is in the idle state. If the master is not in the
 *       idle state, it is waiting to receive or transmit data or the NACK bit.
 */
#define I2C_STAT_MSTPENDING(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTPENDING_SHIFT)) & I2C_STAT_MSTPENDING_MASK)
#define I2C_STAT_MSTSTATE_MASK                   (0xEU)
#define I2C_STAT_MSTSTATE_SHIFT                  (1U)
/*! MSTSTATE - Master State code. The master state code reflects the master state when the
 *    MSTPENDING bit is set, that is the master is pending or in the idle state. Each value of this field
 *    indicates a specific required service for the Master function. All other values are reserved. See
 *    Table 400 for details of state values and appropriate responses.
 *  0b000..Idle. The Master function is available to be used for a new transaction.
 *  0b001..Receive ready. Received data available (Master Receiver mode). Address plus Read was previously sent and Acknowledged by slave.
 *  0b010..Transmit ready. Data can be transmitted (Master Transmitter mode). Address plus Write was previously sent and Acknowledged by slave.
 *  0b011..NACK Address. Slave NACKed address.
 *  0b100..NACK Data. Slave NACKed transmitted data.
 */
#define I2C_STAT_MSTSTATE(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTSTATE_SHIFT)) & I2C_STAT_MSTSTATE_MASK)
#define I2C_STAT_MSTARBLOSS_MASK                 (0x10U)
#define I2C_STAT_MSTARBLOSS_SHIFT                (4U)
/*! MSTARBLOSS - Master Arbitration Loss flag. This flag can be cleared by software writing a 1 to
 *    this bit. It is also cleared automatically a 1 is written to MSTCONTINUE.
 *  0b0..No Arbitration Loss has occurred.
 *  0b1..Arbitration loss. The Master function has experienced an Arbitration Loss. At this point, the Master
 *       function has already stopped driving the bus and gone to an idle state. Software can respond by doing nothing,
 *       or by sending a Start in order to attempt to gain control of the bus when it next becomes idle.
 */
#define I2C_STAT_MSTARBLOSS(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTARBLOSS_SHIFT)) & I2C_STAT_MSTARBLOSS_MASK)
#define I2C_STAT_MSTSTSTPERR_MASK                (0x40U)
#define I2C_STAT_MSTSTSTPERR_SHIFT               (6U)
/*! MSTSTSTPERR - Master Start/Stop Error flag. This flag can be cleared by software writing a 1 to
 *    this bit. It is also cleared automatically a 1 is written to MSTCONTINUE.
 *  0b0..No Start/Stop Error has occurred.
 *  0b1..The Master function has experienced a Start/Stop Error. A Start or Stop was detected at a time when it is
 *       not allowed by the I2C specification. The Master interface has stopped driving the bus and gone to an
 *       idle state, no action is required. A request for a Start could be made, or software could attempt to insure
 *       that the bus has not stalled.
 */
#define I2C_STAT_MSTSTSTPERR(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTSTSTPERR_SHIFT)) & I2C_STAT_MSTSTSTPERR_MASK)
#define I2C_STAT_SLVPENDING_MASK                 (0x100U)
#define I2C_STAT_SLVPENDING_SHIFT                (8U)
/*! SLVPENDING - Slave Pending. Indicates that the Slave function is waiting to continue
 *    communication on the I2C-bus and needs software service. This flag will cause an interrupt when set if
 *    enabled via INTENSET. The SLVPENDING flag is not set when the DMA is handling an event (if the
 *    SLVDMA bit in the SLVCTL register is set). The SLVPENDING flag is read-only and is
 *    automatically cleared when a 1 is written to the SLVCONTINUE bit in the SLVCTL register. The point in time
 *    when SlvPending is set depends on whether the I2C interface is in HSCAPABLE mode. See Section
 *    25.7.2.2.2. When the I2C interface is configured to be HSCAPABLE, HS master codes are
 *    detected automatically. Due to the requirements of the HS I2C specification, slave addresses must
 *    also be detected automatically, since the address must be acknowledged before the clock can be
 *    stretched.
 *  0b0..In progress. The Slave function does not currently need service.
 *  0b1..Pending. The Slave function needs service. Information on what is needed can be found in the adjacent SLVSTATE field.
 */
#define I2C_STAT_SLVPENDING(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVPENDING_SHIFT)) & I2C_STAT_SLVPENDING_MASK)
#define I2C_STAT_SLVSTATE_MASK                   (0x600U)
#define I2C_STAT_SLVSTATE_SHIFT                  (9U)
/*! SLVSTATE - Slave State code. Each value of this field indicates a specific required service for
 *    the Slave function. All other values are reserved. See Table 401 for state values and actions.
 *    note that the occurrence of some states and how they are handled are affected by DMA mode and
 *    Automatic Operation modes.
 *  0b00..Slave address. Address plus R/W received. At least one of the four slave addresses has been matched by hardware.
 *  0b01..Slave receive. Received data is available (Slave Receiver mode).
 *  0b10..Slave transmit. Data can be transmitted (Slave Transmitter mode).
 */
#define I2C_STAT_SLVSTATE(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVSTATE_SHIFT)) & I2C_STAT_SLVSTATE_MASK)
#define I2C_STAT_SLVNOTSTR_MASK                  (0x800U)
#define I2C_STAT_SLVNOTSTR_SHIFT                 (11U)
/*! SLVNOTSTR - Slave Not Stretching. Indicates when the slave function is stretching the I2C clock.
 *    This is needed in order to gracefully invoke Deep Sleep or Power-down modes during slave
 *    operation. This read-only flag reflects the slave function status in real time.
 *  0b0..Stretching. The slave function is currently stretching the I2C bus clock. Deep-Sleep or Power-down mode cannot be entered at this time.
 *  0b1..Not stretching. The slave function is not currently stretching the I 2C bus clock. Deep-sleep or
 *       Power-down mode could be entered at this time.
 */
#define I2C_STAT_SLVNOTSTR(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVNOTSTR_SHIFT)) & I2C_STAT_SLVNOTSTR_MASK)
#define I2C_STAT_SLVIDX_MASK                     (0x3000U)
#define I2C_STAT_SLVIDX_SHIFT                    (12U)
/*! SLVIDX - Slave address match Index. This field is valid when the I2C slave function has been
 *    selected by receiving an address that matches one of the slave addresses defined by any enabled
 *    slave address registers, and provides an identification of the address that was matched. It is
 *    possible that more than one address could be matched, but only one match can be reported here.
 *  0b00..Address 0. Slave address 0 was matched.
 *  0b01..Address 1. Slave address 1 was matched.
 *  0b10..Address 2. Slave address 2 was matched.
 *  0b11..Address 3. Slave address 3 was matched.
 */
#define I2C_STAT_SLVIDX(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVIDX_SHIFT)) & I2C_STAT_SLVIDX_MASK)
#define I2C_STAT_SLVSEL_MASK                     (0x4000U)
#define I2C_STAT_SLVSEL_SHIFT                    (14U)
/*! SLVSEL - Slave selected flag. SLVSEL is set after an address match when software tells the Slave
 *    function to acknowledge the address, or when the address has been automatically acknowledged.
 *    It is cleared when another address cycle presents an address that does not match an enabled
 *    address on the Slave function, when slave software decides to NACK a matched address, when
 *    there is a Stop detected on the bus, when the master NACKs slave data, and in some combinations of
 *    Automatic Operation. SLVSEL is not cleared if software NACKs data.
 *  0b0..Not selected. The Slave function is not currently selected.
 *  0b1..Selected. The Slave function is currently selected.
 */
#define I2C_STAT_SLVSEL(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVSEL_SHIFT)) & I2C_STAT_SLVSEL_MASK)
#define I2C_STAT_SLVDESEL_MASK                   (0x8000U)
#define I2C_STAT_SLVDESEL_SHIFT                  (15U)
/*! SLVDESEL - Slave Deselected flag. This flag will cause an interrupt when set if enabled via
 *    INTENSET. This flag can be cleared by writing a 1 to this bit.
 *  0b0..Not deselected. The Slave function has not become deselected. This does not mean that it is currently
 *       selected. That information can be found in the SLVSEL flag.
 *  0b1..Deselected. The Slave function has become deselected. This is specifically caused by the SLVSEL flag
 *       changing from 1 to 0. See the description of SLVSEL for details on when that event occurs.
 */
#define I2C_STAT_SLVDESEL(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVDESEL_SHIFT)) & I2C_STAT_SLVDESEL_MASK)
#define I2C_STAT_MONRDY_MASK                     (0x10000U)
#define I2C_STAT_MONRDY_SHIFT                    (16U)
/*! MONRDY - Monitor Ready. This flag is cleared when the MONRXDAT register is read.
 *  0b0..No data. The Monitor function does not currently have data available.
 *  0b1..Data waiting. The Monitor function has data waiting to be read.
 */
#define I2C_STAT_MONRDY(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONRDY_SHIFT)) & I2C_STAT_MONRDY_MASK)
#define I2C_STAT_MONOV_MASK                      (0x20000U)
#define I2C_STAT_MONOV_SHIFT                     (17U)
/*! MONOV - Monitor Overflow flag.
 *  0b0..No overrun. Monitor data has not overrun.
 *  0b1..Overrun. A Monitor data overrun has occurred. This can only happen when Monitor clock stretching not
 *       enabled via the MONCLKSTR bit in the CFG register. Writing 1 to this bit clears the flag.
 */
#define I2C_STAT_MONOV(x)                        (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONOV_SHIFT)) & I2C_STAT_MONOV_MASK)
#define I2C_STAT_MONACTIVE_MASK                  (0x40000U)
#define I2C_STAT_MONACTIVE_SHIFT                 (18U)
/*! MONACTIVE - Monitor Active flag. Indicates when the Monitor function considers the I 2C bus to
 *    be active. Active is defined here as when some Master is on the bus: a bus Start has occurred
 *    more recently than a bus Stop.
 *  0b0..Inactive. The Monitor function considers the I2C bus to be inactive.
 *  0b1..Active. The Monitor function considers the I2C bus to be active.
 */
#define I2C_STAT_MONACTIVE(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONACTIVE_SHIFT)) & I2C_STAT_MONACTIVE_MASK)
#define I2C_STAT_MONIDLE_MASK                    (0x80000U)
#define I2C_STAT_MONIDLE_SHIFT                   (19U)
/*! MONIDLE - Monitor Idle flag. This flag is set when the Monitor function sees the I2C bus change
 *    from active to inactive. This can be used by software to decide when to process data
 *    accumulated by the Monitor function. This flag will cause an interrupt when set if enabled via the
 *    INTENSET register. The flag can be cleared by writing a 1 to this bit.
 *  0b0..Not idle. The I2C bus is not idle, or this flag has been cleared by software.
 *  0b1..Idle. The I2C bus has gone idle at least once since the last time this flag was cleared by software.
 */
#define I2C_STAT_MONIDLE(x)                      (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONIDLE_SHIFT)) & I2C_STAT_MONIDLE_MASK)
#define I2C_STAT_EVENTTIMEOUT_MASK               (0x1000000U)
#define I2C_STAT_EVENTTIMEOUT_SHIFT              (24U)
/*! EVENTTIMEOUT - Event Time-out Interrupt flag. Indicates when the time between events has been
 *    longer than the time specified by the TIMEOUT register. Events include Start, Stop, and clock
 *    edges. The flag is cleared by writing a 1 to this bit. No time-out is created when the I2C-bus
 *    is idle.
 *  0b0..No time-out. I2C bus events have not caused a time-out.
 *  0b1..Event time-out. The time between I2C bus events has been longer than the time specified by the TIMEOUT register.
 */
#define I2C_STAT_EVENTTIMEOUT(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_STAT_EVENTTIMEOUT_SHIFT)) & I2C_STAT_EVENTTIMEOUT_MASK)
#define I2C_STAT_SCLTIMEOUT_MASK                 (0x2000000U)
#define I2C_STAT_SCLTIMEOUT_SHIFT                (25U)
/*! SCLTIMEOUT - SCL Time-out Interrupt flag. Indicates when SCL has remained low longer than the
 *    time specific by the TIMEOUT register. The flag is cleared by writing a 1 to this bit.
 *  0b0..No time-out. SCL low time has not caused a time-out.
 *  0b1..Time-out. SCL low time has caused a time-out.
 */
#define I2C_STAT_SCLTIMEOUT(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SCLTIMEOUT_SHIFT)) & I2C_STAT_SCLTIMEOUT_MASK)
/*! @} */

/*! @name INTENSET - Interrupt Enable Set and read register. */
/*! @{ */
#define I2C_INTENSET_MSTPENDINGEN_MASK           (0x1U)
#define I2C_INTENSET_MSTPENDINGEN_SHIFT          (0U)
/*! MSTPENDINGEN - Master Pending interrupt Enable.
 *  0b0..Disabled. The MstPending interrupt is disabled.
 *  0b1..Enabled. The MstPending interrupt is enabled.
 */
#define I2C_INTENSET_MSTPENDINGEN(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MSTPENDINGEN_SHIFT)) & I2C_INTENSET_MSTPENDINGEN_MASK)
#define I2C_INTENSET_MSTARBLOSSEN_MASK           (0x10U)
#define I2C_INTENSET_MSTARBLOSSEN_SHIFT          (4U)
/*! MSTARBLOSSEN - Master Arbitration Loss interrupt Enable.
 *  0b0..Disabled. The MstArbLoss interrupt is disabled.
 *  0b1..Enabled. The MstArbLoss interrupt is enabled.
 */
#define I2C_INTENSET_MSTARBLOSSEN(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MSTARBLOSSEN_SHIFT)) & I2C_INTENSET_MSTARBLOSSEN_MASK)
#define I2C_INTENSET_MSTSTSTPERREN_MASK          (0x40U)
#define I2C_INTENSET_MSTSTSTPERREN_SHIFT         (6U)
/*! MSTSTSTPERREN - Master Start/Stop Error interrupt Enable.
 *  0b0..Disabled. The MstStStpErr interrupt is disabled.
 *  0b1..Enabled. The MstStStpErr interrupt is enabled.
 */
#define I2C_INTENSET_MSTSTSTPERREN(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MSTSTSTPERREN_SHIFT)) & I2C_INTENSET_MSTSTSTPERREN_MASK)
#define I2C_INTENSET_SLVPENDINGEN_MASK           (0x100U)
#define I2C_INTENSET_SLVPENDINGEN_SHIFT          (8U)
/*! SLVPENDINGEN - Slave Pending interrupt Enable.
 *  0b0..Disabled. The SlvPending interrupt is disabled.
 *  0b1..Enabled. The SlvPending interrupt is enabled.
 */
#define I2C_INTENSET_SLVPENDINGEN(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SLVPENDINGEN_SHIFT)) & I2C_INTENSET_SLVPENDINGEN_MASK)
#define I2C_INTENSET_SLVNOTSTREN_MASK            (0x800U)
#define I2C_INTENSET_SLVNOTSTREN_SHIFT           (11U)
/*! SLVNOTSTREN - Slave Not Stretching interrupt Enable.
 *  0b0..Disabled. The SlvNotStr interrupt is disabled.
 *  0b1..Enabled. The SlvNotStr interrupt is enabled.
 */
#define I2C_INTENSET_SLVNOTSTREN(x)              (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SLVNOTSTREN_SHIFT)) & I2C_INTENSET_SLVNOTSTREN_MASK)
#define I2C_INTENSET_SLVDESELEN_MASK             (0x8000U)
#define I2C_INTENSET_SLVDESELEN_SHIFT            (15U)
/*! SLVDESELEN - Slave Deselect interrupt Enable.
 *  0b0..Disabled. The SlvDeSel interrupt is disabled.
 *  0b1..Enabled. The SlvDeSel interrupt is enabled.
 */
#define I2C_INTENSET_SLVDESELEN(x)               (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SLVDESELEN_SHIFT)) & I2C_INTENSET_SLVDESELEN_MASK)
#define I2C_INTENSET_MONRDYEN_MASK               (0x10000U)
#define I2C_INTENSET_MONRDYEN_SHIFT              (16U)
/*! MONRDYEN - Monitor data Ready interrupt Enable.
 *  0b0..Disabled. The MonRdy interrupt is disabled.
 *  0b1..Enabled. The MonRdy interrupt is enabled.
 */
#define I2C_INTENSET_MONRDYEN(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MONRDYEN_SHIFT)) & I2C_INTENSET_MONRDYEN_MASK)
#define I2C_INTENSET_MONOVEN_MASK                (0x20000U)
#define I2C_INTENSET_MONOVEN_SHIFT               (17U)
/*! MONOVEN - Monitor Overrun interrupt Enable.
 *  0b0..Disabled. The MonOv interrupt is disabled.
 *  0b1..Enabled. The MonOv interrupt is enabled.
 */
#define I2C_INTENSET_MONOVEN(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MONOVEN_SHIFT)) & I2C_INTENSET_MONOVEN_MASK)
#define I2C_INTENSET_MONIDLEEN_MASK              (0x80000U)
#define I2C_INTENSET_MONIDLEEN_SHIFT             (19U)
/*! MONIDLEEN - Monitor Idle interrupt Enable.
 *  0b0..Disabled. The MonIdle interrupt is disabled.
 *  0b1..Enabled. The MonIdle interrupt is enabled.
 */
#define I2C_INTENSET_MONIDLEEN(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MONIDLEEN_SHIFT)) & I2C_INTENSET_MONIDLEEN_MASK)
#define I2C_INTENSET_EVENTTIMEOUTEN_MASK         (0x1000000U)
#define I2C_INTENSET_EVENTTIMEOUTEN_SHIFT        (24U)
/*! EVENTTIMEOUTEN - Event time-out interrupt Enable.
 *  0b0..Disabled. The Event time-out interrupt is disabled.
 *  0b1..Enabled. The Event time-out interrupt is enabled.
 */
#define I2C_INTENSET_EVENTTIMEOUTEN(x)           (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_EVENTTIMEOUTEN_SHIFT)) & I2C_INTENSET_EVENTTIMEOUTEN_MASK)
#define I2C_INTENSET_SCLTIMEOUTEN_MASK           (0x2000000U)
#define I2C_INTENSET_SCLTIMEOUTEN_SHIFT          (25U)
/*! SCLTIMEOUTEN - SCL time-out interrupt Enable.
 *  0b0..Disabled. The SCL time-out interrupt is disabled.
 *  0b1..Enabled. The SCL time-out interrupt is enabled.
 */
#define I2C_INTENSET_SCLTIMEOUTEN(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SCLTIMEOUTEN_SHIFT)) & I2C_INTENSET_SCLTIMEOUTEN_MASK)
/*! @} */

/*! @name INTENCLR - Interrupt Enable Clear register. */
/*! @{ */
#define I2C_INTENCLR_MSTPENDINGCLR_MASK          (0x1U)
#define I2C_INTENCLR_MSTPENDINGCLR_SHIFT         (0U)
/*! MSTPENDINGCLR - Master Pending interrupt clear. Writing 1 to this bit clears the corresponding
 *    bit in the INTENSET register if implemented.
 */
#define I2C_INTENCLR_MSTPENDINGCLR(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MSTPENDINGCLR_SHIFT)) & I2C_INTENCLR_MSTPENDINGCLR_MASK)
#define I2C_INTENCLR_MSTARBLOSSCLR_MASK          (0x10U)
#define I2C_INTENCLR_MSTARBLOSSCLR_SHIFT         (4U)
/*! MSTARBLOSSCLR - Master Arbitration Loss interrupt clear.
 */
#define I2C_INTENCLR_MSTARBLOSSCLR(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MSTARBLOSSCLR_SHIFT)) & I2C_INTENCLR_MSTARBLOSSCLR_MASK)
#define I2C_INTENCLR_MSTSTSTPERRCLR_MASK         (0x40U)
#define I2C_INTENCLR_MSTSTSTPERRCLR_SHIFT        (6U)
/*! MSTSTSTPERRCLR - Master Start/Stop Error interrupt clear.
 */
#define I2C_INTENCLR_MSTSTSTPERRCLR(x)           (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MSTSTSTPERRCLR_SHIFT)) & I2C_INTENCLR_MSTSTSTPERRCLR_MASK)
#define I2C_INTENCLR_SLVPENDINGCLR_MASK          (0x100U)
#define I2C_INTENCLR_SLVPENDINGCLR_SHIFT         (8U)
/*! SLVPENDINGCLR - Slave Pending interrupt clear.
 */
#define I2C_INTENCLR_SLVPENDINGCLR(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SLVPENDINGCLR_SHIFT)) & I2C_INTENCLR_SLVPENDINGCLR_MASK)
#define I2C_INTENCLR_SLVNOTSTRCLR_MASK           (0x800U)
#define I2C_INTENCLR_SLVNOTSTRCLR_SHIFT          (11U)
/*! SLVNOTSTRCLR - Slave Not Stretching interrupt clear.
 */
#define I2C_INTENCLR_SLVNOTSTRCLR(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SLVNOTSTRCLR_SHIFT)) & I2C_INTENCLR_SLVNOTSTRCLR_MASK)
#define I2C_INTENCLR_SLVDESELCLR_MASK            (0x8000U)
#define I2C_INTENCLR_SLVDESELCLR_SHIFT           (15U)
/*! SLVDESELCLR - Slave Deselect interrupt clear.
 */
#define I2C_INTENCLR_SLVDESELCLR(x)              (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SLVDESELCLR_SHIFT)) & I2C_INTENCLR_SLVDESELCLR_MASK)
#define I2C_INTENCLR_MONRDYCLR_MASK              (0x10000U)
#define I2C_INTENCLR_MONRDYCLR_SHIFT             (16U)
/*! MONRDYCLR - Monitor data Ready interrupt clear.
 */
#define I2C_INTENCLR_MONRDYCLR(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MONRDYCLR_SHIFT)) & I2C_INTENCLR_MONRDYCLR_MASK)
#define I2C_INTENCLR_MONOVCLR_MASK               (0x20000U)
#define I2C_INTENCLR_MONOVCLR_SHIFT              (17U)
/*! MONOVCLR - Monitor Overrun interrupt clear.
 */
#define I2C_INTENCLR_MONOVCLR(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MONOVCLR_SHIFT)) & I2C_INTENCLR_MONOVCLR_MASK)
#define I2C_INTENCLR_MONIDLECLR_MASK             (0x80000U)
#define I2C_INTENCLR_MONIDLECLR_SHIFT            (19U)
/*! MONIDLECLR - Monitor Idle interrupt clear.
 */
#define I2C_INTENCLR_MONIDLECLR(x)               (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MONIDLECLR_SHIFT)) & I2C_INTENCLR_MONIDLECLR_MASK)
#define I2C_INTENCLR_EVENTTIMEOUTCLR_MASK        (0x1000000U)
#define I2C_INTENCLR_EVENTTIMEOUTCLR_SHIFT       (24U)
/*! EVENTTIMEOUTCLR - Event time-out interrupt clear.
 */
#define I2C_INTENCLR_EVENTTIMEOUTCLR(x)          (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_EVENTTIMEOUTCLR_SHIFT)) & I2C_INTENCLR_EVENTTIMEOUTCLR_MASK)
#define I2C_INTENCLR_SCLTIMEOUTCLR_MASK          (0x2000000U)
#define I2C_INTENCLR_SCLTIMEOUTCLR_SHIFT         (25U)
/*! SCLTIMEOUTCLR - SCL time-out interrupt clear.
 */
#define I2C_INTENCLR_SCLTIMEOUTCLR(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SCLTIMEOUTCLR_SHIFT)) & I2C_INTENCLR_SCLTIMEOUTCLR_MASK)
/*! @} */

/*! @name TIMEOUT - Time-out value register. */
/*! @{ */
#define I2C_TIMEOUT_TOMIN_MASK                   (0xFU)
#define I2C_TIMEOUT_TOMIN_SHIFT                  (0U)
/*! TOMIN - Time-out time value, bottom four bits. These are hard-wired to 0xF. This gives a minimum
 *    time-out of 16 I2C function clocks and also a time-out resolution of 16 I2C function clocks.
 */
#define I2C_TIMEOUT_TOMIN(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_TIMEOUT_TOMIN_SHIFT)) & I2C_TIMEOUT_TOMIN_MASK)
#define I2C_TIMEOUT_TO_MASK                      (0xFFF0U)
#define I2C_TIMEOUT_TO_SHIFT                     (4U)
/*! TO - Time-out time value. Specifies the time-out interval value in increments of 16 I 2C
 *    function clocks, as defined by the CLKDIV register. To change this value while I2C is in operation,
 *    disable all time-outs, write a new value to TIMEOUT, then re-enable time-outs. 0x000 = A
 *    time-out will occur after 16 counts of the I2C function clock. 0x001 = A time-out will occur after
 *    32 counts of the I2C function clock. 0xFFF = A time-out will occur after 65,536 counts of the
 *    I2C function clock.
 */
#define I2C_TIMEOUT_TO(x)                        (((uint32_t)(((uint32_t)(x)) << I2C_TIMEOUT_TO_SHIFT)) & I2C_TIMEOUT_TO_MASK)
/*! @} */

/*! @name CLKDIV - Clock pre-divider for the entire I2C interface. This determines what time increments are used for the MSTTIME register, and controls some timing of the Slave function. */
/*! @{ */
#define I2C_CLKDIV_DIVVAL_MASK                   (0xFFFFU)
#define I2C_CLKDIV_DIVVAL_SHIFT                  (0U)
/*! DIVVAL - This field controls how the Flexcomm clock (FCLK) is used by the I2C functions that
 *    need an internal clock in order to operate. 0x0000 = FCLK is used directly by the I2C. 0x0001 =
 *    FCLK is divided by 2 before use. 0x0002 = FCLK is divided by 3 before use. 0xFFFF = FCLK is
 *    divided by 65,536 before use.
 */
#define I2C_CLKDIV_DIVVAL(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_CLKDIV_DIVVAL_SHIFT)) & I2C_CLKDIV_DIVVAL_MASK)
/*! @} */

/*! @name INTSTAT - Interrupt Status register for Master, Slave, and Monitor functions. */
/*! @{ */
#define I2C_INTSTAT_MSTPENDING_MASK              (0x1U)
#define I2C_INTSTAT_MSTPENDING_SHIFT             (0U)
/*! MSTPENDING - Master Pending.
 */
#define I2C_INTSTAT_MSTPENDING(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MSTPENDING_SHIFT)) & I2C_INTSTAT_MSTPENDING_MASK)
#define I2C_INTSTAT_MSTARBLOSS_MASK              (0x10U)
#define I2C_INTSTAT_MSTARBLOSS_SHIFT             (4U)
/*! MSTARBLOSS - Master Arbitration Loss flag.
 */
#define I2C_INTSTAT_MSTARBLOSS(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MSTARBLOSS_SHIFT)) & I2C_INTSTAT_MSTARBLOSS_MASK)
#define I2C_INTSTAT_MSTSTSTPERR_MASK             (0x40U)
#define I2C_INTSTAT_MSTSTSTPERR_SHIFT            (6U)
/*! MSTSTSTPERR - Master Start/Stop Error flag.
 */
#define I2C_INTSTAT_MSTSTSTPERR(x)               (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MSTSTSTPERR_SHIFT)) & I2C_INTSTAT_MSTSTSTPERR_MASK)
#define I2C_INTSTAT_SLVPENDING_MASK              (0x100U)
#define I2C_INTSTAT_SLVPENDING_SHIFT             (8U)
/*! SLVPENDING - Slave Pending.
 */
#define I2C_INTSTAT_SLVPENDING(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SLVPENDING_SHIFT)) & I2C_INTSTAT_SLVPENDING_MASK)
#define I2C_INTSTAT_SLVNOTSTR_MASK               (0x800U)
#define I2C_INTSTAT_SLVNOTSTR_SHIFT              (11U)
/*! SLVNOTSTR - Slave Not Stretching status.
 */
#define I2C_INTSTAT_SLVNOTSTR(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SLVNOTSTR_SHIFT)) & I2C_INTSTAT_SLVNOTSTR_MASK)
#define I2C_INTSTAT_SLVDESEL_MASK                (0x8000U)
#define I2C_INTSTAT_SLVDESEL_SHIFT               (15U)
/*! SLVDESEL - Slave Deselected flag.
 */
#define I2C_INTSTAT_SLVDESEL(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SLVDESEL_SHIFT)) & I2C_INTSTAT_SLVDESEL_MASK)
#define I2C_INTSTAT_MONRDY_MASK                  (0x10000U)
#define I2C_INTSTAT_MONRDY_SHIFT                 (16U)
/*! MONRDY - Monitor Ready.
 */
#define I2C_INTSTAT_MONRDY(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MONRDY_SHIFT)) & I2C_INTSTAT_MONRDY_MASK)
#define I2C_INTSTAT_MONOV_MASK                   (0x20000U)
#define I2C_INTSTAT_MONOV_SHIFT                  (17U)
/*! MONOV - Monitor Overflow flag.
 */
#define I2C_INTSTAT_MONOV(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MONOV_SHIFT)) & I2C_INTSTAT_MONOV_MASK)
#define I2C_INTSTAT_MONIDLE_MASK                 (0x80000U)
#define I2C_INTSTAT_MONIDLE_SHIFT                (19U)
/*! MONIDLE - Monitor Idle flag.
 */
#define I2C_INTSTAT_MONIDLE(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MONIDLE_SHIFT)) & I2C_INTSTAT_MONIDLE_MASK)
#define I2C_INTSTAT_EVENTTIMEOUT_MASK            (0x1000000U)
#define I2C_INTSTAT_EVENTTIMEOUT_SHIFT           (24U)
/*! EVENTTIMEOUT - Event time-out Interrupt flag.
 */
#define I2C_INTSTAT_EVENTTIMEOUT(x)              (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_EVENTTIMEOUT_SHIFT)) & I2C_INTSTAT_EVENTTIMEOUT_MASK)
#define I2C_INTSTAT_SCLTIMEOUT_MASK              (0x2000000U)
#define I2C_INTSTAT_SCLTIMEOUT_SHIFT             (25U)
/*! SCLTIMEOUT - SCL time-out Interrupt flag.
 */
#define I2C_INTSTAT_SCLTIMEOUT(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SCLTIMEOUT_SHIFT)) & I2C_INTSTAT_SCLTIMEOUT_MASK)
/*! @} */

/*! @name MSTCTL - Master control register. */
/*! @{ */
#define I2C_MSTCTL_MSTCONTINUE_MASK              (0x1U)
#define I2C_MSTCTL_MSTCONTINUE_SHIFT             (0U)
/*! MSTCONTINUE - Master Continue. This bit is write-only.
 *  0b0..No effect.
 *  0b1..Continue. Informs the Master function to continue to the next operation. This must done after writing
 *       transmit data, reading received data, or any other housekeeping related to the next bus operation.
 */
#define I2C_MSTCTL_MSTCONTINUE(x)                (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTCONTINUE_SHIFT)) & I2C_MSTCTL_MSTCONTINUE_MASK)
#define I2C_MSTCTL_MSTSTART_MASK                 (0x2U)
#define I2C_MSTCTL_MSTSTART_SHIFT                (1U)
/*! MSTSTART - Master Start control. This bit is write-only.
 *  0b0..No effect.
 *  0b1..Start. A Start will be generated on the I2C bus at the next allowed time.
 */
#define I2C_MSTCTL_MSTSTART(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTSTART_SHIFT)) & I2C_MSTCTL_MSTSTART_MASK)
#define I2C_MSTCTL_MSTSTOP_MASK                  (0x4U)
#define I2C_MSTCTL_MSTSTOP_SHIFT                 (2U)
/*! MSTSTOP - Master Stop control. This bit is write-only.
 *  0b0..No effect.
 *  0b1..Stop. A Stop will be generated on the I2C bus at the next allowed time, preceded by a NACK to the slave
 *       if the master is receiving data from the slave (Master Receiver mode).
 */
#define I2C_MSTCTL_MSTSTOP(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTSTOP_SHIFT)) & I2C_MSTCTL_MSTSTOP_MASK)
#define I2C_MSTCTL_MSTDMA_MASK                   (0x8U)
#define I2C_MSTCTL_MSTDMA_SHIFT                  (3U)
/*! MSTDMA - Master DMA enable. Data operations of the I2C can be performed with DMA. Protocol type
 *    operations such as Start, address, Stop, and address match must always be done with software,
 *    typically via an interrupt. Address acknowledgement must also be done by software except when
 *    the I2C is configured to be HSCAPABLE (and address acknowledgement is handled entirely by
 *    hardware) or when Automatic Operation is enabled. When a DMA data transfer is complete, MSTDMA
 *    must be cleared prior to beginning the next operation, typically a Start or Stop.This bit is
 *    read/write.
 *  0b0..Disable. No DMA requests are generated for master operation.
 *  0b1..Enable. A DMA request is generated for I2C master data operations. When this I2C master is generating
 *       Acknowledge bits in Master Receiver mode, the acknowledge is generated automatically.
 */
#define I2C_MSTCTL_MSTDMA(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTDMA_SHIFT)) & I2C_MSTCTL_MSTDMA_MASK)
/*! @} */

/*! @name MSTTIME - Master timing configuration. */
/*! @{ */
#define I2C_MSTTIME_MSTSCLLOW_MASK               (0x7U)
#define I2C_MSTTIME_MSTSCLLOW_SHIFT              (0U)
/*! MSTSCLLOW - Master SCL Low time. Specifies the minimum low time that will be asserted by this
 *    master on SCL. Other devices on the bus (masters or slaves) could lengthen this time. This
 *    corresponds to the parameter t LOW in the I2C bus specification. I2C bus specification parameters
 *    tBUF and tSU;STA have the same values and are also controlled by MSTSCLLOW.
 *  0b000..2 clocks. Minimum SCL low time is 2 clocks of the I2C clock pre-divider.
 *  0b001..3 clocks. Minimum SCL low time is 3 clocks of the I2C clock pre-divider.
 *  0b010..4 clocks. Minimum SCL low time is 4 clocks of the I2C clock pre-divider.
 *  0b011..5 clocks. Minimum SCL low time is 5 clocks of the I2C clock pre-divider.
 *  0b100..6 clocks. Minimum SCL low time is 6 clocks of the I2C clock pre-divider.
 *  0b101..7 clocks. Minimum SCL low time is 7 clocks of the I2C clock pre-divider.
 *  0b110..8 clocks. Minimum SCL low time is 8 clocks of the I2C clock pre-divider.
 *  0b111..9 clocks. Minimum SCL low time is 9 clocks of the I2C clock pre-divider.
 */
#define I2C_MSTTIME_MSTSCLLOW(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_MSTTIME_MSTSCLLOW_SHIFT)) & I2C_MSTTIME_MSTSCLLOW_MASK)
#define I2C_MSTTIME_MSTSCLHIGH_MASK              (0x70U)
#define I2C_MSTTIME_MSTSCLHIGH_SHIFT             (4U)
/*! MSTSCLHIGH - Master SCL High time. Specifies the minimum high time that will be asserted by this
 *    master on SCL. Other masters in a multi-master system could shorten this time. This
 *    corresponds to the parameter tHIGH in the I2C bus specification. I2C bus specification parameters
 *    tSU;STO and tHD;STA have the same values and are also controlled by MSTSCLHIGH.
 *  0b000..2 clocks. Minimum SCL high time is 2 clock of the I2C clock pre-divider.
 *  0b001..3 clocks. Minimum SCL high time is 3 clocks of the I2C clock pre-divider .
 *  0b010..4 clocks. Minimum SCL high time is 4 clock of the I2C clock pre-divider.
 *  0b011..5 clocks. Minimum SCL high time is 5 clock of the I2C clock pre-divider.
 *  0b100..6 clocks. Minimum SCL high time is 6 clock of the I2C clock pre-divider.
 *  0b101..7 clocks. Minimum SCL high time is 7 clock of the I2C clock pre-divider.
 *  0b110..8 clocks. Minimum SCL high time is 8 clock of the I2C clock pre-divider.
 *  0b111..9 clocks. Minimum SCL high time is 9 clocks of the I2C clock pre-divider.
 */
#define I2C_MSTTIME_MSTSCLHIGH(x)                (((uint32_t)(((uint32_t)(x)) << I2C_MSTTIME_MSTSCLHIGH_SHIFT)) & I2C_MSTTIME_MSTSCLHIGH_MASK)
/*! @} */

/*! @name MSTDAT - Combined Master receiver and transmitter data register. */
/*! @{ */
#define I2C_MSTDAT_DATA_MASK                     (0xFFU)
#define I2C_MSTDAT_DATA_SHIFT                    (0U)
/*! DATA - Master function data register. Read: read the most recently received data for the Master
 *    function. Write: transmit data using the Master function.
 */
#define I2C_MSTDAT_DATA(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_MSTDAT_DATA_SHIFT)) & I2C_MSTDAT_DATA_MASK)
/*! @} */

/*! @name SLVCTL - Slave control register. */
/*! @{ */
#define I2C_SLVCTL_SLVCONTINUE_MASK              (0x1U)
#define I2C_SLVCTL_SLVCONTINUE_SHIFT             (0U)
/*! SLVCONTINUE - Slave Continue.
 *  0b0..No effect.
 *  0b1..Continue. Informs the Slave function to continue to the next operation, by clearing the SLVPENDING flag
 *       in the STAT register. This must be done after writing transmit data, reading received data, or any other
 *       housekeeping related to the next bus operation. Automatic Operation has different requirements. SLVCONTINUE
 *       should not be set unless SLVPENDING = 1.
 */
#define I2C_SLVCTL_SLVCONTINUE(x)                (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_SLVCONTINUE_SHIFT)) & I2C_SLVCTL_SLVCONTINUE_MASK)
#define I2C_SLVCTL_SLVNACK_MASK                  (0x2U)
#define I2C_SLVCTL_SLVNACK_SHIFT                 (1U)
/*! SLVNACK - Slave NACK.
 *  0b0..No effect.
 *  0b1..NACK. Causes the Slave function to NACK the master when the slave is receiving data from the master (Slave Receiver mode).
 */
#define I2C_SLVCTL_SLVNACK(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_SLVNACK_SHIFT)) & I2C_SLVCTL_SLVNACK_MASK)
#define I2C_SLVCTL_SLVDMA_MASK                   (0x8U)
#define I2C_SLVCTL_SLVDMA_SHIFT                  (3U)
/*! SLVDMA - Slave DMA enable.
 *  0b0..Disabled. No DMA requests are issued for Slave mode operation.
 *  0b1..Enabled. DMA requests are issued for I2C slave data transmission and reception.
 */
#define I2C_SLVCTL_SLVDMA(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_SLVDMA_SHIFT)) & I2C_SLVCTL_SLVDMA_MASK)
#define I2C_SLVCTL_AUTOACK_MASK                  (0x100U)
#define I2C_SLVCTL_AUTOACK_SHIFT                 (8U)
/*! AUTOACK - Automatic Acknowledge.When this bit is set, it will cause an I2C header which matches
 *    SLVADR0 and the direction set by AUTOMATCHREAD to be ACKed immediately; this is used with DMA
 *    to allow processing of the data without intervention. If this bit is clear and a header
 *    matches SLVADR0, the behavior is controlled by AUTONACK in the SLVADR0 register: allowing NACK or
 *    interrupt.
 *  0b0..Normal, non-automatic operation. If AUTONACK = 0, an SlvPending interrupt is generated when a matching
 *       address is received. If AUTONACK = 1, received addresses are NACKed (ignored).
 *  0b1..A header with matching SLVADR0 and matching direction as set by AUTOMATCHREAD will be ACKed immediately,
 *       allowing the master to move on to the data bytes. If the address matches SLVADR0, but the direction does
 *       not match AUTOMATCHREAD, the behavior will depend on the AUTONACK bit in the SLVADR0 register: if AUTONACK
 *       is set, then it will be Nacked; else if AUTONACK is clear, then a SlvPending interrupt is generated.
 */
#define I2C_SLVCTL_AUTOACK(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_AUTOACK_SHIFT)) & I2C_SLVCTL_AUTOACK_MASK)
#define I2C_SLVCTL_AUTOMATCHREAD_MASK            (0x200U)
#define I2C_SLVCTL_AUTOMATCHREAD_SHIFT           (9U)
/*! AUTOMATCHREAD - When AUTOACK is set, this bit controls whether it matches a read or write
 *    request on the next header with an address matching SLVADR0. Since DMA needs to be configured to
 *    match the transfer direction, the direction needs to be specified. This bit allows a direction to
 *    be chosen for the next operation.
 *  0b0..The expected next operation in Automatic Mode is an I2C write.
 *  0b1..The expected next operation in Automatic Mode is an I2C read.
 */
#define I2C_SLVCTL_AUTOMATCHREAD(x)              (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_AUTOMATCHREAD_SHIFT)) & I2C_SLVCTL_AUTOMATCHREAD_MASK)
/*! @} */

/*! @name SLVDAT - Combined Slave receiver and transmitter data register. */
/*! @{ */
#define I2C_SLVDAT_DATA_MASK                     (0xFFU)
#define I2C_SLVDAT_DATA_SHIFT                    (0U)
/*! DATA - Slave function data register. Read: read the most recently received data for the Slave
 *    function. Write: transmit data using the Slave function.
 */
#define I2C_SLVDAT_DATA(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_SLVDAT_DATA_SHIFT)) & I2C_SLVDAT_DATA_MASK)
/*! @} */

/*! @name SLVADR - Slave address register. */
/*! @{ */
#define I2C_SLVADR_SADISABLE_MASK                (0x1U)
#define I2C_SLVADR_SADISABLE_SHIFT               (0U)
/*! SADISABLE - Slave Address n Disable.
 *  0b0..Enabled. Slave Address n is enabled.
 *  0b1..Ignored Slave Address n is ignored.
 */
#define I2C_SLVADR_SADISABLE(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_SLVADR_SADISABLE_SHIFT)) & I2C_SLVADR_SADISABLE_MASK)
#define I2C_SLVADR_SLVADR_MASK                   (0xFEU)
#define I2C_SLVADR_SLVADR_SHIFT                  (1U)
/*! SLVADR - Slave Address. Seven bit slave address that is compared to received addresses if enabled.
 */
#define I2C_SLVADR_SLVADR(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_SLVADR_SLVADR_SHIFT)) & I2C_SLVADR_SLVADR_MASK)
#define I2C_SLVADR_AUTONACK_MASK                 (0x8000U)
#define I2C_SLVADR_AUTONACK_SHIFT                (15U)
/*! AUTONACK - Automatic NACK operation. Used in conjunction with AUTOACK and AUTOMATCHREAD, allows
 *    software to ignore I2C traffic while handling previous I2C data or other operations.
 *  0b0..Normal operation, matching I2C addresses are not ignored.
 *  0b1..Automatic-only mode. All incoming addresses are ignored (NACKed), unless AUTOACK is set, it matches
 *       SLVADRn, and AUTOMATCHREAD matches the direction.
 */
#define I2C_SLVADR_AUTONACK(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_SLVADR_AUTONACK_SHIFT)) & I2C_SLVADR_AUTONACK_MASK)
/*! @} */

/* The count of I2C_SLVADR */
#define I2C_SLVADR_COUNT                         (4U)

/*! @name SLVQUAL0 - Slave Qualification for address 0. */
/*! @{ */
#define I2C_SLVQUAL0_QUALMODE0_MASK              (0x1U)
#define I2C_SLVQUAL0_QUALMODE0_SHIFT             (0U)
/*! QUALMODE0 - Qualify mode for slave address 0.
 *  0b0..Mask. The SLVQUAL0 field is used as a logical mask for matching address 0.
 *  0b1..Extend. The SLVQUAL0 field is used to extend address 0 matching in a range of addresses.
 */
#define I2C_SLVQUAL0_QUALMODE0(x)                (((uint32_t)(((uint32_t)(x)) << I2C_SLVQUAL0_QUALMODE0_SHIFT)) & I2C_SLVQUAL0_QUALMODE0_MASK)
#define I2C_SLVQUAL0_SLVQUAL0_MASK               (0xFEU)
#define I2C_SLVQUAL0_SLVQUAL0_SHIFT              (1U)
/*! SLVQUAL0 - Slave address Qualifier for address 0. A value of 0 causes the address in SLVADR0 to
 *    be used as-is, assuming that it is enabled. If QUALMODE0 = 0, any bit in this field which is
 *    set to 1 will cause an automatic match of the corresponding bit of the received address when it
 *    is compared to the SLVADR0 register. If QUALMODE0 = 1, an address range is matched for
 *    address 0. This range extends from the value defined by SLVADR0 to the address defined by SLVQUAL0
 *    (address matches when SLVADR0[7:1] <= received address <= SLVQUAL0[7:1]).
 */
#define I2C_SLVQUAL0_SLVQUAL0(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_SLVQUAL0_SLVQUAL0_SHIFT)) & I2C_SLVQUAL0_SLVQUAL0_MASK)
/*! @} */

/*! @name MONRXDAT - Monitor receiver data register. */
/*! @{ */
#define I2C_MONRXDAT_MONRXDAT_MASK               (0xFFU)
#define I2C_MONRXDAT_MONRXDAT_SHIFT              (0U)
/*! MONRXDAT - Monitor function Receiver Data. This reflects every data byte that passes on the I2C pins.
 */
#define I2C_MONRXDAT_MONRXDAT(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONRXDAT_SHIFT)) & I2C_MONRXDAT_MONRXDAT_MASK)
#define I2C_MONRXDAT_MONSTART_MASK               (0x100U)
#define I2C_MONRXDAT_MONSTART_SHIFT              (8U)
/*! MONSTART - Monitor Received Start.
 *  0b0..No start detected. The Monitor function has not detected a Start event on the I2C bus.
 *  0b1..Start detected. The Monitor function has detected a Start event on the I2C bus.
 */
#define I2C_MONRXDAT_MONSTART(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONSTART_SHIFT)) & I2C_MONRXDAT_MONSTART_MASK)
#define I2C_MONRXDAT_MONRESTART_MASK             (0x200U)
#define I2C_MONRXDAT_MONRESTART_SHIFT            (9U)
/*! MONRESTART - Monitor Received Repeated Start.
 *  0b0..No repeated start detected. The Monitor function has not detected a Repeated Start event on the I2C bus.
 *  0b1..Repeated start detected. The Monitor function has detected a Repeated Start event on the I2C bus.
 */
#define I2C_MONRXDAT_MONRESTART(x)               (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONRESTART_SHIFT)) & I2C_MONRXDAT_MONRESTART_MASK)
#define I2C_MONRXDAT_MONNACK_MASK                (0x400U)
#define I2C_MONRXDAT_MONNACK_SHIFT               (10U)
/*! MONNACK - Monitor Received NACK.
 *  0b0..Acknowledged. The data currently being provided by the Monitor function was acknowledged by at least one master or slave receiver.
 *  0b1..Not acknowledged. The data currently being provided by the Monitor function was not acknowledged by any receiver.
 */
#define I2C_MONRXDAT_MONNACK(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONNACK_SHIFT)) & I2C_MONRXDAT_MONNACK_MASK)
/*! @} */

/*! @name ID - Peripheral identification register. */
/*! @{ */
#define I2C_ID_APERTURE_MASK                     (0xFFU)
#define I2C_ID_APERTURE_SHIFT                    (0U)
/*! APERTURE - Aperture: encoded as (aperture size/4K) -1, so 0x00 means a 4K aperture.
 */
#define I2C_ID_APERTURE(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_ID_APERTURE_SHIFT)) & I2C_ID_APERTURE_MASK)
#define I2C_ID_MINOR_REV_MASK                    (0xF00U)
#define I2C_ID_MINOR_REV_SHIFT                   (8U)
/*! MINOR_REV - Minor revision of module implementation.
 */
#define I2C_ID_MINOR_REV(x)                      (((uint32_t)(((uint32_t)(x)) << I2C_ID_MINOR_REV_SHIFT)) & I2C_ID_MINOR_REV_MASK)
#define I2C_ID_MAJOR_REV_MASK                    (0xF000U)
#define I2C_ID_MAJOR_REV_SHIFT                   (12U)
/*! MAJOR_REV - Major revision of module implementation.
 */
#define I2C_ID_MAJOR_REV(x)                      (((uint32_t)(((uint32_t)(x)) << I2C_ID_MAJOR_REV_SHIFT)) & I2C_ID_MAJOR_REV_MASK)
#define I2C_ID_ID_MASK                           (0xFFFF0000U)
#define I2C_ID_ID_SHIFT                          (16U)
/*! ID - Module identifier for the selected function.
 */
#define I2C_ID_ID(x)                             (((uint32_t)(((uint32_t)(x)) << I2C_ID_ID_SHIFT)) & I2C_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group I2C_Register_Masks */


/* I2C - Peripheral instance base addresses */
/** Peripheral I2C0 base address */
#define I2C0_BASE                                (0x40086000u)
/** Peripheral I2C0 base pointer */
#define I2C0                                     ((I2C_Type *)I2C0_BASE)
/** Peripheral I2C1 base address */
#define I2C1_BASE                                (0x40087000u)
/** Peripheral I2C1 base pointer */
#define I2C1                                     ((I2C_Type *)I2C1_BASE)
/** Peripheral I2C2 base address */
#define I2C2_BASE                                (0x40088000u)
/** Peripheral I2C2 base pointer */
#define I2C2                                     ((I2C_Type *)I2C2_BASE)
/** Peripheral I2C3 base address */
#define I2C3_BASE                                (0x40089000u)
/** Peripheral I2C3 base pointer */
#define I2C3                                     ((I2C_Type *)I2C3_BASE)
/** Peripheral I2C4 base address */
#define I2C4_BASE                                (0x4008A000u)
/** Peripheral I2C4 base pointer */
#define I2C4                                     ((I2C_Type *)I2C4_BASE)
/** Peripheral I2C5 base address */
#define I2C5_BASE                                (0x40096000u)
/** Peripheral I2C5 base pointer */
#define I2C5                                     ((I2C_Type *)I2C5_BASE)
/** Peripheral I2C6 base address */
#define I2C6_BASE                                (0x40097000u)
/** Peripheral I2C6 base pointer */
#define I2C6                                     ((I2C_Type *)I2C6_BASE)
/** Peripheral I2C7 base address */
#define I2C7_BASE                                (0x40098000u)
/** Peripheral I2C7 base pointer */
#define I2C7                                     ((I2C_Type *)I2C7_BASE)
/** Peripheral I2C8 base address */
#define I2C8_BASE                                (0x40099000u)
/** Peripheral I2C8 base pointer */
#define I2C8                                     ((I2C_Type *)I2C8_BASE)
/** Peripheral I2C9 base address */
#define I2C9_BASE                                (0x4009A000u)
/** Peripheral I2C9 base pointer */
#define I2C9                                     ((I2C_Type *)I2C9_BASE)
/** Array initializer of I2C peripheral base addresses */
#define I2C_BASE_ADDRS                           { I2C0_BASE, I2C1_BASE, I2C2_BASE, I2C3_BASE, I2C4_BASE, I2C5_BASE, I2C6_BASE, I2C7_BASE, I2C8_BASE, I2C9_BASE }
/** Array initializer of I2C peripheral base pointers */
#define I2C_BASE_PTRS                            { I2C0, I2C1, I2C2, I2C3, I2C4, I2C5, I2C6, I2C7, I2C8, I2C9 }
/** Interrupt vectors for the I2C peripheral type */
#define I2C_IRQS                                 { FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, FLEXCOMM6_IRQn, FLEXCOMM7_IRQn, FLEXCOMM8_IRQn, FLEXCOMM9_IRQn }

/*!
 * @}
 */ /* end of group I2C_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- I2S Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2S_Peripheral_Access_Layer I2S Peripheral Access Layer
 * @{
 */

/** I2S - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[3072];
  __IO uint32_t CFG1;                              /**< Configuration register 1 for the primary channel pair., offset: 0xC00 */
  __IO uint32_t CFG2;                              /**< Configuration register 2 for the primary channel pair., offset: 0xC04 */
  __IO uint32_t STAT;                              /**< Status register for the primary channel pair., offset: 0xC08 */
       uint8_t RESERVED_1[16];
  __IO uint32_t DIV;                               /**< Clock divider, used by all channel pairs., offset: 0xC1C */
  struct {                                         /* offset: 0xC20, array step: 0x20 */
    __IO uint32_t PCFG1;                             /**< Configuration register 1 for channel pair, array offset: 0xC20, array step: 0x20 */
    __IO uint32_t PCFG2;                             /**< Configuration register 2 for channel pair, array offset: 0xC24, array step: 0x20 */
    __IO uint32_t PSTAT;                             /**< Status register for channel pair, array offset: 0xC28, array step: 0x20 */
         uint8_t RESERVED_0[20];
  } SECCHANNEL[3];
       uint8_t RESERVED_2[384];
  __IO uint32_t FIFOCFG;                           /**< FIFO configuration and enable register., offset: 0xE00 */
  __IO uint32_t FIFOSTAT;                          /**< FIFO status register., offset: 0xE04 */
  __IO uint32_t FIFOTRIG;                          /**< FIFO trigger settings for interrupt and DMA request., offset: 0xE08 */
       uint8_t RESERVED_3[4];
  __IO uint32_t FIFOINTENSET;                      /**< FIFO interrupt enable set (enable) and read register., offset: 0xE10 */
  __IO uint32_t FIFOINTENCLR;                      /**< FIFO interrupt enable clear (disable) and read register., offset: 0xE14 */
  __I  uint32_t FIFOINTSTAT;                       /**< FIFO interrupt status register., offset: 0xE18 */
       uint8_t RESERVED_4[4];
  __O  uint32_t FIFOWR;                            /**< FIFO write data., offset: 0xE20 */
  __O  uint32_t FIFOWR48H;                         /**< FIFO write data for upper data bits. May only be used if the I2S is configured for 2x 24-bit data and not using DMA., offset: 0xE24 */
       uint8_t RESERVED_5[8];
  __I  uint32_t FIFORD;                            /**< FIFO read data., offset: 0xE30 */
  __I  uint32_t FIFORD48H;                         /**< FIFO read data for upper data bits. May only be used if the I2S is configured for 2x 24-bit data and not using DMA., offset: 0xE34 */
       uint8_t RESERVED_6[8];
  __I  uint32_t FIFORDNOPOP;                       /**< FIFO data read with no FIFO pop., offset: 0xE40 */
  __I  uint32_t FIFORD48HNOPOP;                    /**< FIFO data read for upper data bits with no FIFO pop. May only be used if the I2S is configured for 2x 24-bit data and not using DMA., offset: 0xE44 */
       uint8_t RESERVED_7[4020];
  __I  uint32_t ID;                                /**< I2S Module identification, offset: 0x1DFC */
} I2S_Type;

/* ----------------------------------------------------------------------------
   -- I2S Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2S_Register_Masks I2S Register Masks
 * @{
 */

/*! @name CFG1 - Configuration register 1 for the primary channel pair. */
/*! @{ */
#define I2S_CFG1_MAINENABLE_MASK                 (0x1U)
#define I2S_CFG1_MAINENABLE_SHIFT                (0U)
/*! MAINENABLE - Main enable for I 2S function in this Flexcomm
 *  0b0..All I 2S channel pairs in this Flexcomm are disabled and the internal state machines, counters, and flags
 *       are reset. No other channel pairs can be enabled.
 *  0b1..This I 2S channel pair is enabled. Other channel pairs in this Flexcomm may be enabled in their individual PAIRENABLE bits.
 */
#define I2S_CFG1_MAINENABLE(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_MAINENABLE_SHIFT)) & I2S_CFG1_MAINENABLE_MASK)
#define I2S_CFG1_DATAPAUSE_MASK                  (0x2U)
#define I2S_CFG1_DATAPAUSE_SHIFT                 (1U)
/*! DATAPAUSE - Data flow Pause. Allows pausing data flow between the I2S serializer/deserializer
 *    and the FIFO. This could be done in order to change streams, or while restarting after a data
 *    underflow or overflow. When paused, FIFO operations can be done without corrupting data that is
 *    in the process of being sent or received. Once a data pause has been requested, the interface
 *    may need to complete sending data that was in progress before interrupting the flow of data.
 *    Software must check that the pause is actually in effect before taking action. This is done by
 *    monitoring the DATAPAUSED flag in the STAT register. When DATAPAUSE is cleared, data transfer
 *    will resume at the beginning of the next frame.
 *  0b0..Normal operation, or resuming normal operation at the next frame if the I2S has already been paused.
 *  0b1..A pause in the data flow is being requested. It is in effect when DATAPAUSED in STAT = 1.
 */
#define I2S_CFG1_DATAPAUSE(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_DATAPAUSE_SHIFT)) & I2S_CFG1_DATAPAUSE_MASK)
#define I2S_CFG1_PAIRCOUNT_MASK                  (0xCU)
#define I2S_CFG1_PAIRCOUNT_SHIFT                 (2U)
/*! PAIRCOUNT - Provides the number of I2S channel pairs in this Flexcomm This is a read-only field
 *    whose value may be different in other Flexcomms. 00 = there is 1 I2S channel pair in this
 *    Flexcomm. 01 = there are 2 I2S channel pairs in this Flexcomm. 10 = there are 3 I2S channel pairs
 *    in this Flexcomm. 11 = there are 4 I2S channel pairs in this Flexcomm.
 *  0b00..1 I2S channel pairs in this flexcomm
 *  0b01..2 I2S channel pairs in this flexcomm
 *  0b10..3 I2S channel pairs in this flexcomm
 *  0b11..4 I2S channel pairs in this flexcomm
 */
#define I2S_CFG1_PAIRCOUNT(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_PAIRCOUNT_SHIFT)) & I2S_CFG1_PAIRCOUNT_MASK)
#define I2S_CFG1_MSTSLVCFG_MASK                  (0x30U)
#define I2S_CFG1_MSTSLVCFG_SHIFT                 (4U)
/*! MSTSLVCFG - Master / slave configuration selection, determining how SCK and WS are used by all channel pairs in this Flexcomm.
 *  0b00..Normal slave mode, the default mode. SCK and WS are received from a master and used to transmit or receive data.
 *  0b01..WS synchronized master. WS is received from another master and used to synchronize the generation of
 *        SCK, when divided from the Flexcomm function clock.
 *  0b10..Master using an existing SCK. SCK is received and used directly to generate WS, as well as transmitting or receiving data.
 *  0b11..Normal master mode. SCK and WS are generated so they can be sent to one or more slave devices.
 */
#define I2S_CFG1_MSTSLVCFG(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_MSTSLVCFG_SHIFT)) & I2S_CFG1_MSTSLVCFG_MASK)
#define I2S_CFG1_MODE_MASK                       (0xC0U)
#define I2S_CFG1_MODE_SHIFT                      (6U)
/*! MODE - Selects the basic I2S operating mode. Other configurations modify this to obtain all
 *    supported cases. See Formats and modes for examples.
 *  0b00..I2S mode a.k.a. 'classic' mode. WS has a 50% duty cycle, with (for each enabled channel pair) one piece
 *        of left channel data occurring during the first phase, and one pieces of right channel data occurring
 *        during the second phase. In this mode, the data region begins one clock after the leading WS edge for the
 *        frame. For a 50% WS duty cycle, FRAMELEN must define an even number of I2S clocks for the frame. If
 *        FRAMELEN defines an odd number of clocks per frame, the extra clock will occur on the right.
 *  0b01..DSP mode where WS has a 50% duty cycle. See remark for mode 0.
 *  0b10..DSP mode where WS has a one clock long pulse at the beginning of each data frame.
 *  0b11..DSP mode where WS has a one data slot long pulse at the beginning of each data frame.
 */
#define I2S_CFG1_MODE(x)                         (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_MODE_SHIFT)) & I2S_CFG1_MODE_MASK)
#define I2S_CFG1_RIGHTLOW_MASK                   (0x100U)
#define I2S_CFG1_RIGHTLOW_SHIFT                  (8U)
/*! RIGHTLOW - Right channel data is in the Low portion of FIFO data. Essentially, this swaps left
 *    and right channel data as it is transferred to or from the FIFO. This bit is not used if the
 *    data width is greater than 24 bits or if PDMDATA = 1. Note that if the ONECHANNEL field (bit 10
 *    of this register) = 1, the one channel to be used is the nominally the left channel. POSITION
 *    can still place that data in the frame where right channel data is normally located. if all
 *    enabled channel pairs have ONECHANNEL = 1, then RIGHTLOW = 1 is not allowed.
 *  0b0..The right channel is taken from the high part of the FIFO data. For example, when data is 16 bits, FIFO
 *       bits 31:16 are used for the right channel.
 *  0b1..The right channel is taken from the low part of the FIFO data. For example, when data is 16 bits, FIFO
 *       bits 15:0 are used for the right channel.
 */
#define I2S_CFG1_RIGHTLOW(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_RIGHTLOW_SHIFT)) & I2S_CFG1_RIGHTLOW_MASK)
#define I2S_CFG1_LEFTJUST_MASK                   (0x200U)
#define I2S_CFG1_LEFTJUST_SHIFT                  (9U)
/*! LEFTJUST - Left Justify data.
 *  0b0..Data is transferred between the FIFO and the I2S serializer/deserializer right justified, i.e. starting
 *       from bit 0 and continuing to the position defined by DATALEN. This would correspond to right justified data
 *       in the stream on the data bus.
 *  0b1..Data is transferred between the FIFO and the I2S serializer/deserializer left justified, i.e. starting
 *       from the MSB of the FIFO entry and continuing for the number of bits defined by DATALEN. This would
 *       correspond to left justified data in the stream on the data bus.
 */
#define I2S_CFG1_LEFTJUST(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_LEFTJUST_SHIFT)) & I2S_CFG1_LEFTJUST_MASK)
#define I2S_CFG1_ONECHANNEL_MASK                 (0x400U)
#define I2S_CFG1_ONECHANNEL_SHIFT                (10U)
/*! ONECHANNEL - Single channel mode. Applies to both transmit and receive. This configuration bit
 *    applies only to the first I2S channel pair. Other channel pairs may select this mode
 *    independently in their separate CFG1 registers.
 *  0b0..I2S data for this channel pair is treated as left and right channels.
 *  0b1..I2S data for this channel pair is treated as a single channel, functionally the left channel for this
 *       pair. In mode 0 only, the right side of the frame begins at POSITION = 0x100. This is because mode 0 makes a
 *       clear distinction between the left and right sides of the frame. When ONECHANNEL = 1, the single channel
 *       of data may be placed on the right by setting POSITION to 0x100 + the data position within the right side
 *       (e.g. 0x108 would place data starting at the 8th clock after the middle of the frame). In other modes, data
 *       for the single channel of data is placed at the clock defined by POSITION.
 */
#define I2S_CFG1_ONECHANNEL(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_ONECHANNEL_SHIFT)) & I2S_CFG1_ONECHANNEL_MASK)
#define I2S_CFG1_PDMDATA_MASK                    (0x800U)
#define I2S_CFG1_PDMDATA_SHIFT                   (11U)
/*! PDMDATA - PDM Data selection. This bit controls the data source for I2S transmit, and cannot be
 *    set in Rx mode. This bit only has an effect if the device the Flexcomm resides in includes a
 *    D-Mic subsystem. For the LPC5411x, this bit applies only to Flexcomm 7.
 *  0b0..Normal operation, data is transferred to or from the Flexcomm FIFO.
 *  0b1..The data source is the D-Mic subsystem. When PDMDATA = 1, only the primary channel pair can be used in
 *       this Flexcomm. If ONECHANNEL = 1, only the PDM left data is used. the WS rate must match the Fs (sample
 *       rate) of the D-Mic decimator. A rate mismatch will at some point cause the I2S to overrun or underrun.
 */
#define I2S_CFG1_PDMDATA(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_PDMDATA_SHIFT)) & I2S_CFG1_PDMDATA_MASK)
#define I2S_CFG1_SCK_POL_MASK                    (0x1000U)
#define I2S_CFG1_SCK_POL_SHIFT                   (12U)
/*! SCK_POL - SCK polarity.
 *  0b0..Data is launched on SCK falling edges and sampled on SCK rising edges (standard for I2S).
 *  0b1..Data is launched on SCK rising edges and sampled on SCK falling edges.
 */
#define I2S_CFG1_SCK_POL(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_SCK_POL_SHIFT)) & I2S_CFG1_SCK_POL_MASK)
#define I2S_CFG1_WS_POL_MASK                     (0x2000U)
#define I2S_CFG1_WS_POL_SHIFT                    (13U)
/*! WS_POL - WS polarity.
 *  0b0..Data frames begin at a falling edge of WS (standard for classic I2S).
 *  0b1..WS is inverted, resulting in a data frame beginning at a rising edge of WS (standard for most 'non-classic' variations of I2S).
 */
#define I2S_CFG1_WS_POL(x)                       (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_WS_POL_SHIFT)) & I2S_CFG1_WS_POL_MASK)
#define I2S_CFG1_DATALEN_MASK                    (0x1F0000U)
#define I2S_CFG1_DATALEN_SHIFT                   (16U)
/*! DATALEN - Data Length, minus 1 encoded, defines the number of data bits to be transmitted or
 *    received for all I2S channel pairs in this Flexcomm. Note that data is only driven to or received
 *    from SDA for the number of bits defined by DATALEN. DATALEN is also used in these ways by the
 *    I2S: Determines the size of data transfers between the FIFO and the I2S
 *    serializer/deserializer. See FIFO buffer configurations and usage In mode 1, 2, and 3, determines the location of
 *    right data following left data in the frame. In mode 3 (where WS has a one data slot long pulse
 *    at the beginning of each data frame) determines the duration of the WS pulse. Values: 0x00 to
 *    0x02 = not supported 0x03 = data is 4 bits in length 0x04 = data is 5 bits in length 0x1F =
 *    data is 32 bits in length
 */
#define I2S_CFG1_DATALEN(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_DATALEN_SHIFT)) & I2S_CFG1_DATALEN_MASK)
/*! @} */

/*! @name CFG2 - Configuration register 2 for the primary channel pair. */
/*! @{ */
#define I2S_CFG2_FRAMELEN_MASK                   (0x1FFU)
#define I2S_CFG2_FRAMELEN_SHIFT                  (0U)
/*! FRAMELEN - Frame Length, minus 1 encoded, defines the number of clocks and data bits in the
 *    frames that this channel pair participates in. See Frame format. 0x000 to 0x002 = not supported
 *    0x003 = frame is 4 bits in total length 0x004 = frame is 5 bits in total length 0x1FF = frame is
 *    512 bits in total length if FRAMELEN is an defines an odd length frame (e.g. 33 clocks) in
 *    mode 0 or 1, the extra clock appears in the right half. When MODE = 3, FRAMELEN must be larger
 *    than DATALEN in order for the WS pulse to be generated correctly.
 */
#define I2S_CFG2_FRAMELEN(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_CFG2_FRAMELEN_SHIFT)) & I2S_CFG2_FRAMELEN_MASK)
#define I2S_CFG2_POSITION_MASK                   (0x1FF0000U)
#define I2S_CFG2_POSITION_SHIFT                  (16U)
/*! POSITION - Data Position. Defines the location within the frame of the data for this channel
 *    pair. POSITION + DATALEN must be less than FRAMELEN. See Frame format. When MODE = 0, POSITION
 *    defines the location of data in both the left phase and right phase, starting one clock after
 *    the WS edge. In other modes, POSITION defines the location of data within the entire frame.
 *    ONECHANNEL = 1 while MODE = 0 is a special case, see the description of ONECHANNEL. The
 *    combination of DATALEN and the POSITION fields of all channel pairs must be made such that the channels
 *    do not overlap within the frame. 0x000 = data begins at bit position 0 (the first bit
 *    position) within the frame or WS phase. 0x001 = data begins at bit position 1 within the frame or WS
 *    phase. 0x002 = data begins at bit position 2 within the frame or WS phase.
 */
#define I2S_CFG2_POSITION(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_CFG2_POSITION_SHIFT)) & I2S_CFG2_POSITION_MASK)
/*! @} */

/*! @name STAT - Status register for the primary channel pair. */
/*! @{ */
#define I2S_STAT_BUSY_MASK                       (0x1U)
#define I2S_STAT_BUSY_SHIFT                      (0U)
/*! BUSY - Busy status for the primary channel pair. Other BUSY flags may be found in the STAT register for each channel pair.
 *  0b0..The transmitter/receiver for channel pair is currently idle.
 *  0b1..The transmitter/receiver for channel pair is currently processing data.
 */
#define I2S_STAT_BUSY(x)                         (((uint32_t)(((uint32_t)(x)) << I2S_STAT_BUSY_SHIFT)) & I2S_STAT_BUSY_MASK)
#define I2S_STAT_SLVFRMERR_MASK                  (0x2U)
#define I2S_STAT_SLVFRMERR_SHIFT                 (1U)
/*! SLVFRMERR - Slave Frame Error flag. This applies when at least one channel pair is operating as
 *    a slave. An error indicates that the incoming WS signal did not transition as expected due to
 *    a mismatch between FRAMELEN and the actual incoming I2S stream.
 *  0b0..No error has been recorded.
 *  0b1..An error has been recorded for some channel pair that is operating in slave mode. ERROR is cleared by writing a 1 to this bit position.
 */
#define I2S_STAT_SLVFRMERR(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_STAT_SLVFRMERR_SHIFT)) & I2S_STAT_SLVFRMERR_MASK)
#define I2S_STAT_LR_MASK                         (0x4U)
#define I2S_STAT_LR_SHIFT                        (2U)
/*! LR - Left/Right indication. This flag is considered to be a debugging aid and is not expected to
 *    be used by an I2S driver. Valid when one channel pair is busy. Indicates left or right data
 *    being processed for the currently busy channel pair.
 *  0b0..Left channel.
 *  0b1..Right channel.
 */
#define I2S_STAT_LR(x)                           (((uint32_t)(((uint32_t)(x)) << I2S_STAT_LR_SHIFT)) & I2S_STAT_LR_MASK)
#define I2S_STAT_DATAPAUSED_MASK                 (0x8U)
#define I2S_STAT_DATAPAUSED_SHIFT                (3U)
/*! DATAPAUSED - Data Paused status flag. Applies to all I2S channels
 *  0b0..Data is not currently paused. A data pause may have been requested but is not yet in force, waiting for
 *       an allowed pause point. Refer to the description of the DATAPAUSE control bit in the CFG1 register.
 *  0b1..A data pause has been requested and is now in force.
 */
#define I2S_STAT_DATAPAUSED(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_STAT_DATAPAUSED_SHIFT)) & I2S_STAT_DATAPAUSED_MASK)
/*! @} */

/*! @name DIV - Clock divider, used by all channel pairs. */
/*! @{ */
#define I2S_DIV_DIV_MASK                         (0xFFFU)
#define I2S_DIV_DIV_SHIFT                        (0U)
/*! DIV - This field controls how this I2S block uses the Flexcomm function clock. 0x000 = The
 *    Flexcomm function clock is used directly. 0x001 = The Flexcomm function clock is divided by 2.
 *    0x002 = The Flexcomm function clock is divided by 3. 0xFFF = The Flexcomm function clock is
 *    divided by 4,096.
 */
#define I2S_DIV_DIV(x)                           (((uint32_t)(((uint32_t)(x)) << I2S_DIV_DIV_SHIFT)) & I2S_DIV_DIV_MASK)
/*! @} */

/*! @name SECCHANNEL_PCFG1 - Configuration register 1 for channel pair */
/*! @{ */
#define I2S_SECCHANNEL_PCFG1_PAIRENABLE_MASK     (0x1U)
#define I2S_SECCHANNEL_PCFG1_PAIRENABLE_SHIFT    (0U)
/*! PAIRENABLE - Enable for this channel pair..
 */
#define I2S_SECCHANNEL_PCFG1_PAIRENABLE(x)       (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PCFG1_PAIRENABLE_SHIFT)) & I2S_SECCHANNEL_PCFG1_PAIRENABLE_MASK)
#define I2S_SECCHANNEL_PCFG1_ONECHANNEL_MASK     (0x400U)
#define I2S_SECCHANNEL_PCFG1_ONECHANNEL_SHIFT    (10U)
/*! ONECHANNEL - Single channel mode.
 */
#define I2S_SECCHANNEL_PCFG1_ONECHANNEL(x)       (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PCFG1_ONECHANNEL_SHIFT)) & I2S_SECCHANNEL_PCFG1_ONECHANNEL_MASK)
/*! @} */

/* The count of I2S_SECCHANNEL_PCFG1 */
#define I2S_SECCHANNEL_PCFG1_COUNT               (3U)

/*! @name SECCHANNEL_PCFG2 - Configuration register 2 for channel pair */
/*! @{ */
#define I2S_SECCHANNEL_PCFG2_POSITION_MASK       (0x1FF0000U)
#define I2S_SECCHANNEL_PCFG2_POSITION_SHIFT      (16U)
/*! POSITION - Data Position.
 */
#define I2S_SECCHANNEL_PCFG2_POSITION(x)         (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PCFG2_POSITION_SHIFT)) & I2S_SECCHANNEL_PCFG2_POSITION_MASK)
/*! @} */

/* The count of I2S_SECCHANNEL_PCFG2 */
#define I2S_SECCHANNEL_PCFG2_COUNT               (3U)

/*! @name SECCHANNEL_PSTAT - Status register for channel pair */
/*! @{ */
#define I2S_SECCHANNEL_PSTAT_BUSY_MASK           (0x1U)
#define I2S_SECCHANNEL_PSTAT_BUSY_SHIFT          (0U)
/*! BUSY - Busy status for this channel pair.
 */
#define I2S_SECCHANNEL_PSTAT_BUSY(x)             (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PSTAT_BUSY_SHIFT)) & I2S_SECCHANNEL_PSTAT_BUSY_MASK)
#define I2S_SECCHANNEL_PSTAT_SLVFRMERR_MASK      (0x2U)
#define I2S_SECCHANNEL_PSTAT_SLVFRMERR_SHIFT     (1U)
/*! SLVFRMERR - Save Frame Error flag.
 */
#define I2S_SECCHANNEL_PSTAT_SLVFRMERR(x)        (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PSTAT_SLVFRMERR_SHIFT)) & I2S_SECCHANNEL_PSTAT_SLVFRMERR_MASK)
#define I2S_SECCHANNEL_PSTAT_LR_MASK             (0x4U)
#define I2S_SECCHANNEL_PSTAT_LR_SHIFT            (2U)
/*! LR - Left/Right indication.
 */
#define I2S_SECCHANNEL_PSTAT_LR(x)               (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PSTAT_LR_SHIFT)) & I2S_SECCHANNEL_PSTAT_LR_MASK)
#define I2S_SECCHANNEL_PSTAT_DATAPAUSED_MASK     (0x8U)
#define I2S_SECCHANNEL_PSTAT_DATAPAUSED_SHIFT    (3U)
/*! DATAPAUSED - Data Paused status flag.
 */
#define I2S_SECCHANNEL_PSTAT_DATAPAUSED(x)       (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PSTAT_DATAPAUSED_SHIFT)) & I2S_SECCHANNEL_PSTAT_DATAPAUSED_MASK)
/*! @} */

/* The count of I2S_SECCHANNEL_PSTAT */
#define I2S_SECCHANNEL_PSTAT_COUNT               (3U)

/*! @name FIFOCFG - FIFO configuration and enable register. */
/*! @{ */
#define I2S_FIFOCFG_ENABLETX_MASK                (0x1U)
#define I2S_FIFOCFG_ENABLETX_SHIFT               (0U)
/*! ENABLETX - Enable the transmit FIFO.
 *  0b0..The transmit FIFO is not enabled.
 *  0b1..The transmit FIFO is enabled.
 */
#define I2S_FIFOCFG_ENABLETX(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_ENABLETX_SHIFT)) & I2S_FIFOCFG_ENABLETX_MASK)
#define I2S_FIFOCFG_ENABLERX_MASK                (0x2U)
#define I2S_FIFOCFG_ENABLERX_SHIFT               (1U)
/*! ENABLERX - Enable the receive FIFO.
 *  0b0..The receive FIFO is not enabled.
 *  0b1..The receive FIFO is enabled.
 */
#define I2S_FIFOCFG_ENABLERX(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_ENABLERX_SHIFT)) & I2S_FIFOCFG_ENABLERX_MASK)
#define I2S_FIFOCFG_TXI2SE0_MASK                 (0x4U)
#define I2S_FIFOCFG_TXI2SE0_SHIFT                (2U)
/*! TXI2SE0 - Transmit I2S empty 0. Determines the value sent by the I2S in transmit mode if the TX
 *    FIFO becomes empty. This value is sent repeatedly until the I2S is paused, the error is
 *    cleared, new data is provided, and the I2S is un-paused.
 *  0b0..If the TX FIFO becomes empty, the last value is sent. This setting may be used when the data length is 24
 *       bits or less, or when MONO = 1 for this channel pair.
 *  0b1..If the TX FIFO becomes empty, 0 is sent. Use if the data length is greater than 24 bits or if zero fill is preferred.
 */
#define I2S_FIFOCFG_TXI2SE0(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_TXI2SE0_SHIFT)) & I2S_FIFOCFG_TXI2SE0_MASK)
#define I2S_FIFOCFG_PACK48_MASK                  (0x8U)
#define I2S_FIFOCFG_PACK48_SHIFT                 (3U)
/*! PACK48 - Packing format for 48-bit data. This relates to how data is entered into or taken from the FIFO by software or DMA.
 *  0b0..48-bit I2S FIFO entries are handled as all 24-bit values.
 *  0b1..48-bit I2S FIFO entries are handled as alternating 32-bit and 16-bit values.
 */
#define I2S_FIFOCFG_PACK48(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_PACK48_SHIFT)) & I2S_FIFOCFG_PACK48_MASK)
#define I2S_FIFOCFG_SIZE_MASK                    (0x30U)
#define I2S_FIFOCFG_SIZE_SHIFT                   (4U)
/*! SIZE - FIFO size configuration. This is a read-only field. 0x0 = FIFO is configured as 16
 *    entries of 8 bits. 0x1, 0x2, 0x3 = not applicable to USART.
 */
#define I2S_FIFOCFG_SIZE(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_SIZE_SHIFT)) & I2S_FIFOCFG_SIZE_MASK)
#define I2S_FIFOCFG_DMATX_MASK                   (0x1000U)
#define I2S_FIFOCFG_DMATX_SHIFT                  (12U)
/*! DMATX - DMA configuration for transmit.
 *  0b0..DMA is not used for the transmit function.
 *  0b1..Trigger DMA for the transmit function if the FIFO is not full. Generally, data interrupts would be disabled if DMA is enabled.
 */
#define I2S_FIFOCFG_DMATX(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_DMATX_SHIFT)) & I2S_FIFOCFG_DMATX_MASK)
#define I2S_FIFOCFG_DMARX_MASK                   (0x2000U)
#define I2S_FIFOCFG_DMARX_SHIFT                  (13U)
/*! DMARX - DMA configuration for receive.
 *  0b0..DMA is not used for the receive function.
 *  0b1..Trigger DMA for the receive function if the FIFO is not empty. Generally, data interrupts would be disabled if DMA is enabled.
 */
#define I2S_FIFOCFG_DMARX(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_DMARX_SHIFT)) & I2S_FIFOCFG_DMARX_MASK)
#define I2S_FIFOCFG_WAKETX_MASK                  (0x4000U)
#define I2S_FIFOCFG_WAKETX_SHIFT                 (14U)
/*! WAKETX - Wake-up for transmit FIFO level. This allows the device to be woken from reduced power
 *    modes (up to power-down, as long as the peripheral function works in that power mode) without
 *    enabling the TXLVL interrupt. Only DMA wakes up, processes data, and goes back to sleep. The
 *    CPU will remain stopped until woken by another cause, such as DMA completion. See Hardware
 *    Wake-up control register.
 *  0b0..Only enabled interrupts will wake up the device form reduced power modes.
 *  0b1..A device wake-up for DMA will occur if the transmit FIFO level reaches the value specified by TXLVL in
 *       FIFOTRIG, even when the TXLVL interrupt is not enabled.
 */
#define I2S_FIFOCFG_WAKETX(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_WAKETX_SHIFT)) & I2S_FIFOCFG_WAKETX_MASK)
#define I2S_FIFOCFG_WAKERX_MASK                  (0x8000U)
#define I2S_FIFOCFG_WAKERX_SHIFT                 (15U)
/*! WAKERX - Wake-up for receive FIFO level. This allows the device to be woken from reduced power
 *    modes (up to power-down, as long as the peripheral function works in that power mode) without
 *    enabling the TXLVL interrupt. Only DMA wakes up, processes data, and goes back to sleep. The
 *    CPU will remain stopped until woken by another cause, such as DMA completion. See Hardware
 *    Wake-up control register.
 *  0b0..Only enabled interrupts will wake up the device form reduced power modes.
 *  0b1..A device wake-up for DMA will occur if the receive FIFO level reaches the value specified by RXLVL in
 *       FIFOTRIG, even when the RXLVL interrupt is not enabled.
 */
#define I2S_FIFOCFG_WAKERX(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_WAKERX_SHIFT)) & I2S_FIFOCFG_WAKERX_MASK)
#define I2S_FIFOCFG_EMPTYTX_MASK                 (0x10000U)
#define I2S_FIFOCFG_EMPTYTX_SHIFT                (16U)
/*! EMPTYTX - Empty command for the transmit FIFO. When a 1 is written to this bit, the TX FIFO is emptied.
 */
#define I2S_FIFOCFG_EMPTYTX(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_EMPTYTX_SHIFT)) & I2S_FIFOCFG_EMPTYTX_MASK)
#define I2S_FIFOCFG_EMPTYRX_MASK                 (0x20000U)
#define I2S_FIFOCFG_EMPTYRX_SHIFT                (17U)
/*! EMPTYRX - Empty command for the receive FIFO. When a 1 is written to this bit, the RX FIFO is emptied.
 */
#define I2S_FIFOCFG_EMPTYRX(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_EMPTYRX_SHIFT)) & I2S_FIFOCFG_EMPTYRX_MASK)
/*! @} */

/*! @name FIFOSTAT - FIFO status register. */
/*! @{ */
#define I2S_FIFOSTAT_TXERR_MASK                  (0x1U)
#define I2S_FIFOSTAT_TXERR_SHIFT                 (0U)
/*! TXERR - TX FIFO error. Will be set if a transmit FIFO error occurs. This could be an overflow
 *    caused by pushing data into a full FIFO, or by an underflow if the FIFO is empty when data is
 *    needed. Cleared by writing a 1 to this bit.
 */
#define I2S_FIFOSTAT_TXERR(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXERR_SHIFT)) & I2S_FIFOSTAT_TXERR_MASK)
#define I2S_FIFOSTAT_RXERR_MASK                  (0x2U)
#define I2S_FIFOSTAT_RXERR_SHIFT                 (1U)
/*! RXERR - RX FIFO error. Will be set if a receive FIFO overflow occurs, caused by software or DMA
 *    not emptying the FIFO fast enough. Cleared by writing a 1 to this bit.
 */
#define I2S_FIFOSTAT_RXERR(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXERR_SHIFT)) & I2S_FIFOSTAT_RXERR_MASK)
#define I2S_FIFOSTAT_PERINT_MASK                 (0x8U)
#define I2S_FIFOSTAT_PERINT_SHIFT                (3U)
/*! PERINT - Peripheral interrupt. When 1, this indicates that the peripheral function has asserted
 *    an interrupt. The details can be found by reading the peripheral's STAT register.
 */
#define I2S_FIFOSTAT_PERINT(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_PERINT_SHIFT)) & I2S_FIFOSTAT_PERINT_MASK)
#define I2S_FIFOSTAT_TXEMPTY_MASK                (0x10U)
#define I2S_FIFOSTAT_TXEMPTY_SHIFT               (4U)
/*! TXEMPTY - Transmit FIFO empty. When 1, the transmit FIFO is empty. The peripheral may still be processing the last piece of data.
 */
#define I2S_FIFOSTAT_TXEMPTY(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXEMPTY_SHIFT)) & I2S_FIFOSTAT_TXEMPTY_MASK)
#define I2S_FIFOSTAT_TXNOTFULL_MASK              (0x20U)
#define I2S_FIFOSTAT_TXNOTFULL_SHIFT             (5U)
/*! TXNOTFULL - Transmit FIFO not full. When 1, the transmit FIFO is not full, so more data can be
 *    written. When 0, the transmit FIFO is full and another write would cause it to overflow.
 */
#define I2S_FIFOSTAT_TXNOTFULL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXNOTFULL_SHIFT)) & I2S_FIFOSTAT_TXNOTFULL_MASK)
#define I2S_FIFOSTAT_RXNOTEMPTY_MASK             (0x40U)
#define I2S_FIFOSTAT_RXNOTEMPTY_SHIFT            (6U)
/*! RXNOTEMPTY - Receive FIFO not empty. When 1, the receive FIFO is not empty, so data can be read. When 0, the receive FIFO is empty.
 */
#define I2S_FIFOSTAT_RXNOTEMPTY(x)               (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXNOTEMPTY_SHIFT)) & I2S_FIFOSTAT_RXNOTEMPTY_MASK)
#define I2S_FIFOSTAT_RXFULL_MASK                 (0x80U)
#define I2S_FIFOSTAT_RXFULL_SHIFT                (7U)
/*! RXFULL - Receive FIFO full. When 1, the receive FIFO is full. Data needs to be read out to
 *    prevent the peripheral from causing an overflow.
 */
#define I2S_FIFOSTAT_RXFULL(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXFULL_SHIFT)) & I2S_FIFOSTAT_RXFULL_MASK)
#define I2S_FIFOSTAT_TXLVL_MASK                  (0x1F00U)
#define I2S_FIFOSTAT_TXLVL_SHIFT                 (8U)
/*! TXLVL - Transmit FIFO current level. A 0 means the TX FIFO is currently empty, and the TXEMPTY
 *    and TXNOTFULL flags will be 1. Other values tell how much data is actually in the TX FIFO at
 *    the point where the read occurs. If the TX FIFO is full, the TXEMPTY and TXNOTFULL flags will be
 *    0.
 */
#define I2S_FIFOSTAT_TXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXLVL_SHIFT)) & I2S_FIFOSTAT_TXLVL_MASK)
#define I2S_FIFOSTAT_RXLVL_MASK                  (0x1F0000U)
#define I2S_FIFOSTAT_RXLVL_SHIFT                 (16U)
/*! RXLVL - Receive FIFO current level. A 0 means the RX FIFO is currently empty, and the RXFULL and
 *    RXNOTEMPTY flags will be 0. Other values tell how much data is actually in the RX FIFO at the
 *    point where the read occurs. If the RX FIFO is full, the RXFULL and RXNOTEMPTY flags will be
 *    1.
 */
#define I2S_FIFOSTAT_RXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXLVL_SHIFT)) & I2S_FIFOSTAT_RXLVL_MASK)
/*! @} */

/*! @name FIFOTRIG - FIFO trigger settings for interrupt and DMA request. */
/*! @{ */
#define I2S_FIFOTRIG_TXLVLENA_MASK               (0x1U)
#define I2S_FIFOTRIG_TXLVLENA_SHIFT              (0U)
/*! TXLVLENA - Transmit FIFO level trigger enable. This trigger will become an interrupt if enabled
 *    in FIFOINTENSET, or a DMA trigger if DMATX in FIFOCFG is set.
 *  0b0..Transmit FIFO level does not generate a FIFO level trigger.
 *  0b1..An trigger will be generated if the transmit FIFO level reaches the value specified by the TXLVL field in this register.
 */
#define I2S_FIFOTRIG_TXLVLENA(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_TXLVLENA_SHIFT)) & I2S_FIFOTRIG_TXLVLENA_MASK)
#define I2S_FIFOTRIG_RXLVLENA_MASK               (0x2U)
#define I2S_FIFOTRIG_RXLVLENA_SHIFT              (1U)
/*! RXLVLENA - Receive FIFO level trigger enable. This trigger will become an interrupt if enabled
 *    in FIFOINTENSET, or a DMA trigger if DMARX in FIFOCFG is set.
 *  0b0..Receive FIFO level does not generate a FIFO level trigger.
 *  0b1..An trigger will be generated if the receive FIFO level reaches the value specified by the RXLVL field in this register.
 */
#define I2S_FIFOTRIG_RXLVLENA(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_RXLVLENA_SHIFT)) & I2S_FIFOTRIG_RXLVLENA_MASK)
#define I2S_FIFOTRIG_TXLVL_MASK                  (0xF00U)
#define I2S_FIFOTRIG_TXLVL_SHIFT                 (8U)
/*! TXLVL - Transmit FIFO level trigger point. This field is used only when TXLVLENA = 1. If enabled
 *    to do so, the FIFO level can wake up the device just enough to perform DMA, then return to
 *    the reduced power mode. See Hardware Wake-up control register. 0 = trigger when the TX FIFO
 *    becomes empty. 1 = trigger when the TX FIFO level decreases to one entry. 15 = trigger when the TX
 *    FIFO level decreases to 15 entries (is no longer full).
 */
#define I2S_FIFOTRIG_TXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_TXLVL_SHIFT)) & I2S_FIFOTRIG_TXLVL_MASK)
#define I2S_FIFOTRIG_RXLVL_MASK                  (0xF0000U)
#define I2S_FIFOTRIG_RXLVL_SHIFT                 (16U)
/*! RXLVL - Receive FIFO level trigger point. The RX FIFO level is checked when a new piece of data
 *    is received. This field is used only when RXLVLENA = 1. If enabled to do so, the FIFO level
 *    can wake up the device just enough to perform DMA, then return to the reduced power mode. See
 *    Hardware Wake-up control register. 0 = trigger when the RX FIFO has received one entry (is no
 *    longer empty). 1 = trigger when the RX FIFO has received two entries. 15 = trigger when the RX
 *    FIFO has received 16 entries (has become full).
 */
#define I2S_FIFOTRIG_RXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_RXLVL_SHIFT)) & I2S_FIFOTRIG_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTENSET - FIFO interrupt enable set (enable) and read register. */
/*! @{ */
#define I2S_FIFOINTENSET_TXERR_MASK              (0x1U)
#define I2S_FIFOINTENSET_TXERR_SHIFT             (0U)
/*! TXERR - Determines whether an interrupt occurs when a transmit error occurs, based on the TXERR flag in the FIFOSTAT register.
 *  0b0..No interrupt will be generated for a transmit error.
 *  0b1..An interrupt will be generated when a transmit error occurs.
 */
#define I2S_FIFOINTENSET_TXERR(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_TXERR_SHIFT)) & I2S_FIFOINTENSET_TXERR_MASK)
#define I2S_FIFOINTENSET_RXERR_MASK              (0x2U)
#define I2S_FIFOINTENSET_RXERR_SHIFT             (1U)
/*! RXERR - Determines whether an interrupt occurs when a receive error occurs, based on the RXERR flag in the FIFOSTAT register.
 *  0b0..No interrupt will be generated for a receive error.
 *  0b1..An interrupt will be generated when a receive error occurs.
 */
#define I2S_FIFOINTENSET_RXERR(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_RXERR_SHIFT)) & I2S_FIFOINTENSET_RXERR_MASK)
#define I2S_FIFOINTENSET_TXLVL_MASK              (0x4U)
#define I2S_FIFOINTENSET_TXLVL_SHIFT             (2U)
/*! TXLVL - Determines whether an interrupt occurs when a the transmit FIFO reaches the level
 *    specified by the TXLVL field in the FIFOTRIG register.
 *  0b0..No interrupt will be generated based on the TX FIFO level.
 *  0b1..If TXLVLENA in the FIFOTRIG register = 1, an interrupt will be generated when the TX FIFO level decreases
 *       to the level specified by TXLVL in the FIFOTRIG register.
 */
#define I2S_FIFOINTENSET_TXLVL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_TXLVL_SHIFT)) & I2S_FIFOINTENSET_TXLVL_MASK)
#define I2S_FIFOINTENSET_RXLVL_MASK              (0x8U)
#define I2S_FIFOINTENSET_RXLVL_SHIFT             (3U)
/*! RXLVL - Determines whether an interrupt occurs when a the receive FIFO reaches the level
 *    specified by the TXLVL field in the FIFOTRIG register.
 *  0b0..No interrupt will be generated based on the RX FIFO level.
 *  0b1..If RXLVLENA in the FIFOTRIG register = 1, an interrupt will be generated when the when the RX FIFO level
 *       increases to the level specified by RXLVL in the FIFOTRIG register.
 */
#define I2S_FIFOINTENSET_RXLVL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_RXLVL_SHIFT)) & I2S_FIFOINTENSET_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTENCLR - FIFO interrupt enable clear (disable) and read register. */
/*! @{ */
#define I2S_FIFOINTENCLR_TXERR_MASK              (0x1U)
#define I2S_FIFOINTENCLR_TXERR_SHIFT             (0U)
/*! TXERR - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define I2S_FIFOINTENCLR_TXERR(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_TXERR_SHIFT)) & I2S_FIFOINTENCLR_TXERR_MASK)
#define I2S_FIFOINTENCLR_RXERR_MASK              (0x2U)
#define I2S_FIFOINTENCLR_RXERR_SHIFT             (1U)
/*! RXERR - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define I2S_FIFOINTENCLR_RXERR(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_RXERR_SHIFT)) & I2S_FIFOINTENCLR_RXERR_MASK)
#define I2S_FIFOINTENCLR_TXLVL_MASK              (0x4U)
#define I2S_FIFOINTENCLR_TXLVL_SHIFT             (2U)
/*! TXLVL - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define I2S_FIFOINTENCLR_TXLVL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_TXLVL_SHIFT)) & I2S_FIFOINTENCLR_TXLVL_MASK)
#define I2S_FIFOINTENCLR_RXLVL_MASK              (0x8U)
#define I2S_FIFOINTENCLR_RXLVL_SHIFT             (3U)
/*! RXLVL - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define I2S_FIFOINTENCLR_RXLVL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_RXLVL_SHIFT)) & I2S_FIFOINTENCLR_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTSTAT - FIFO interrupt status register. */
/*! @{ */
#define I2S_FIFOINTSTAT_TXERR_MASK               (0x1U)
#define I2S_FIFOINTSTAT_TXERR_SHIFT              (0U)
/*! TXERR - TX FIFO error.
 */
#define I2S_FIFOINTSTAT_TXERR(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_TXERR_SHIFT)) & I2S_FIFOINTSTAT_TXERR_MASK)
#define I2S_FIFOINTSTAT_RXERR_MASK               (0x2U)
#define I2S_FIFOINTSTAT_RXERR_SHIFT              (1U)
/*! RXERR - RX FIFO error.
 */
#define I2S_FIFOINTSTAT_RXERR(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_RXERR_SHIFT)) & I2S_FIFOINTSTAT_RXERR_MASK)
#define I2S_FIFOINTSTAT_TXLVL_MASK               (0x4U)
#define I2S_FIFOINTSTAT_TXLVL_SHIFT              (2U)
/*! TXLVL - Transmit FIFO level interrupt.
 */
#define I2S_FIFOINTSTAT_TXLVL(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_TXLVL_SHIFT)) & I2S_FIFOINTSTAT_TXLVL_MASK)
#define I2S_FIFOINTSTAT_RXLVL_MASK               (0x8U)
#define I2S_FIFOINTSTAT_RXLVL_SHIFT              (3U)
/*! RXLVL - Receive FIFO level interrupt.
 */
#define I2S_FIFOINTSTAT_RXLVL(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_RXLVL_SHIFT)) & I2S_FIFOINTSTAT_RXLVL_MASK)
#define I2S_FIFOINTSTAT_PERINT_MASK              (0x10U)
#define I2S_FIFOINTSTAT_PERINT_SHIFT             (4U)
/*! PERINT - Peripheral interrupt.
 */
#define I2S_FIFOINTSTAT_PERINT(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_PERINT_SHIFT)) & I2S_FIFOINTSTAT_PERINT_MASK)
/*! @} */

/*! @name FIFOWR - FIFO write data. */
/*! @{ */
#define I2S_FIFOWR_TXDATA_MASK                   (0xFFFFFFFFU)
#define I2S_FIFOWR_TXDATA_SHIFT                  (0U)
/*! TXDATA - Transmit data to the FIFO. The number of bits used depends on configuration details.
 */
#define I2S_FIFOWR_TXDATA(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_FIFOWR_TXDATA_SHIFT)) & I2S_FIFOWR_TXDATA_MASK)
/*! @} */

/*! @name FIFOWR48H - FIFO write data for upper data bits. May only be used if the I2S is configured for 2x 24-bit data and not using DMA. */
/*! @{ */
#define I2S_FIFOWR48H_TXDATA_MASK                (0xFFFFFFU)
#define I2S_FIFOWR48H_TXDATA_SHIFT               (0U)
/*! TXDATA - Transmit data to the FIFO. Whether this register is used and the number of bits used depends on configuration details.
 */
#define I2S_FIFOWR48H_TXDATA(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFOWR48H_TXDATA_SHIFT)) & I2S_FIFOWR48H_TXDATA_MASK)
/*! @} */

/*! @name FIFORD - FIFO read data. */
/*! @{ */
#define I2S_FIFORD_RXDATA_MASK                   (0xFFFFFFFFU)
#define I2S_FIFORD_RXDATA_SHIFT                  (0U)
/*! RXDATA - Received data from the FIFO. The number of bits used depends on configuration details.
 */
#define I2S_FIFORD_RXDATA(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_FIFORD_RXDATA_SHIFT)) & I2S_FIFORD_RXDATA_MASK)
/*! @} */

/*! @name FIFORD48H - FIFO read data for upper data bits. May only be used if the I2S is configured for 2x 24-bit data and not using DMA. */
/*! @{ */
#define I2S_FIFORD48H_RXDATA_MASK                (0xFFFFFFU)
#define I2S_FIFORD48H_RXDATA_SHIFT               (0U)
/*! RXDATA - Received data from the FIFO. Whether this register is used and the number of bits used depends on configuration details.
 */
#define I2S_FIFORD48H_RXDATA(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFORD48H_RXDATA_SHIFT)) & I2S_FIFORD48H_RXDATA_MASK)
/*! @} */

/*! @name FIFORDNOPOP - FIFO data read with no FIFO pop. */
/*! @{ */
#define I2S_FIFORDNOPOP_RXDATA_MASK              (0xFFFFFFFFU)
#define I2S_FIFORDNOPOP_RXDATA_SHIFT             (0U)
/*! RXDATA - Received data from the FIFO.
 */
#define I2S_FIFORDNOPOP_RXDATA(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFORDNOPOP_RXDATA_SHIFT)) & I2S_FIFORDNOPOP_RXDATA_MASK)
/*! @} */

/*! @name FIFORD48HNOPOP - FIFO data read for upper data bits with no FIFO pop. May only be used if the I2S is configured for 2x 24-bit data and not using DMA. */
/*! @{ */
#define I2S_FIFORD48HNOPOP_RXDATA_MASK           (0xFFFFFFU)
#define I2S_FIFORD48HNOPOP_RXDATA_SHIFT          (0U)
/*! RXDATA - Received data from the FIFO. Whether this register is used and the number of bits used depends on configuration details.
 */
#define I2S_FIFORD48HNOPOP_RXDATA(x)             (((uint32_t)(((uint32_t)(x)) << I2S_FIFORD48HNOPOP_RXDATA_SHIFT)) & I2S_FIFORD48HNOPOP_RXDATA_MASK)
/*! @} */

/*! @name ID - I2S Module identification */
/*! @{ */
#define I2S_ID_Aperture_MASK                     (0xFFU)
#define I2S_ID_Aperture_SHIFT                    (0U)
/*! Aperture - Aperture: encoded as (aperture size/4K) -1, so 0x00 means a 4K aperture.
 */
#define I2S_ID_Aperture(x)                       (((uint32_t)(((uint32_t)(x)) << I2S_ID_Aperture_SHIFT)) & I2S_ID_Aperture_MASK)
#define I2S_ID_Minor_Rev_MASK                    (0xF00U)
#define I2S_ID_Minor_Rev_SHIFT                   (8U)
/*! Minor_Rev - Minor revision of module implementation, starting at 0.
 */
#define I2S_ID_Minor_Rev(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_ID_Minor_Rev_SHIFT)) & I2S_ID_Minor_Rev_MASK)
#define I2S_ID_Major_Rev_MASK                    (0xF000U)
#define I2S_ID_Major_Rev_SHIFT                   (12U)
/*! Major_Rev - Major revision of module implementation, starting at 0.
 */
#define I2S_ID_Major_Rev(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_ID_Major_Rev_SHIFT)) & I2S_ID_Major_Rev_MASK)
#define I2S_ID_ID_MASK                           (0xFFFF0000U)
#define I2S_ID_ID_SHIFT                          (16U)
/*! ID - Unique module identifier for this IP block.
 */
#define I2S_ID_ID(x)                             (((uint32_t)(((uint32_t)(x)) << I2S_ID_ID_SHIFT)) & I2S_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group I2S_Register_Masks */


/* I2S - Peripheral instance base addresses */
/** Peripheral I2S0 base address */
#define I2S0_BASE                                (0x40097000u)
/** Peripheral I2S0 base pointer */
#define I2S0                                     ((I2S_Type *)I2S0_BASE)
/** Peripheral I2S1 base address */
#define I2S1_BASE                                (0x40098000u)
/** Peripheral I2S1 base pointer */
#define I2S1                                     ((I2S_Type *)I2S1_BASE)
/** Array initializer of I2S peripheral base addresses */
#define I2S_BASE_ADDRS                           { I2S0_BASE, I2S1_BASE }
/** Array initializer of I2S peripheral base pointers */
#define I2S_BASE_PTRS                            { I2S0, I2S1 }
/** Interrupt vectors for the I2S peripheral type */
#define I2S_IRQS                                 { FLEXCOMM6_IRQn, FLEXCOMM7_IRQn }

/*!
 * @}
 */ /* end of group I2S_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- INPUTMUX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INPUTMUX_Peripheral_Access_Layer INPUTMUX Peripheral Access Layer
 * @{
 */

/** INPUTMUX - Register Layout Typedef */
typedef struct {
  __IO uint32_t SCT0_INMUX[7];                     /**< Trigger select register for DMA channel, array offset: 0x0, array step: 0x4 */
       uint8_t RESERVED_0[164];
  __IO uint32_t PINTSEL[8];                        /**< Pin interrupt select register, array offset: 0xC0, array step: 0x4 */
  __IO uint32_t DMA_ITRIG_INMUX[32];               /**< Trigger select register for DMA channel, array offset: 0xE0, array step: 0x4 */
  __IO uint32_t DMA_OTRIG_INMUX[4];                /**< DMA output trigger selection to become DMA trigger, array offset: 0x160, array step: 0x4 */
       uint8_t RESERVED_1[16];
  __IO uint32_t FREQMEAS_REF;                      /**< Selection for frequency measurement reference clock, offset: 0x180 */
  __IO uint32_t FREQMEAS_TARGET;                   /**< Selection for frequency measurement target clock, offset: 0x184 */
} INPUTMUX_Type;

/* ----------------------------------------------------------------------------
   -- INPUTMUX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INPUTMUX_Register_Masks INPUTMUX Register Masks
 * @{
 */

/*! @name SCT0_INMUX - Trigger select register for DMA channel */
/*! @{ */
#define INPUTMUX_SCT0_INMUX_INP_N_MASK           (0x1FU)
#define INPUTMUX_SCT0_INMUX_INP_N_SHIFT          (0U)
/*! INP_N - Input number to SCT0 inputs 0 to 6..
 */
#define INPUTMUX_SCT0_INMUX_INP_N(x)             (((uint32_t)(((uint32_t)(x)) << INPUTMUX_SCT0_INMUX_INP_N_SHIFT)) & INPUTMUX_SCT0_INMUX_INP_N_MASK)
/*! @} */

/* The count of INPUTMUX_SCT0_INMUX */
#define INPUTMUX_SCT0_INMUX_COUNT                (7U)

/*! @name PINTSEL - Pin interrupt select register */
/*! @{ */
#define INPUTMUX_PINTSEL_INTPIN_MASK             (0xFFU)
#define INPUTMUX_PINTSEL_INTPIN_SHIFT            (0U)
/*! INTPIN - Pin number select for pin interrupt or pattern match engine input. (PIO0_0 to PIO1_31 correspond to numbers 0 to 63).
 */
#define INPUTMUX_PINTSEL_INTPIN(x)               (((uint32_t)(((uint32_t)(x)) << INPUTMUX_PINTSEL_INTPIN_SHIFT)) & INPUTMUX_PINTSEL_INTPIN_MASK)
/*! @} */

/* The count of INPUTMUX_PINTSEL */
#define INPUTMUX_PINTSEL_COUNT                   (8U)

/*! @name DMA_ITRIG_INMUX - Trigger select register for DMA channel */
/*! @{ */
#define INPUTMUX_DMA_ITRIG_INMUX_INP_MASK        (0x1FU)
#define INPUTMUX_DMA_ITRIG_INMUX_INP_SHIFT       (0U)
/*! INP - Trigger input number (decimal value) for DMA channel n (n = 0 to 31). 0 = ADC0 Sequence A
 *    interrupt 1 = ADC0 Sequence B interrupt 2 = SCT0 DMA request 0 3 = SCT0 DMA request 1 4 =
 *    Timer CTIMER0 Match 0 5 = Timer CTIMER0 Match 1 6 = Timer CTIMER1 Match 0 7 = Timer CTIMER2 Match
 *    0 8 = Timer CTIMER2 Match 1 9 = Timer CTIMER3 Match 0 10 = Timer CTIMER4 Match 0 11 = Timer
 *    CTIMER4 Match 1 12 = Pin interrupt 0 13 = Pin interrupt 1 14 = Pin interrupt 2 15 = Pin
 *    interrupt 3 16 = DMA output trigger mux 0 17 = DMA output trigger mux 1 18 = DMA output trigger mux 2
 *    19 = DMA output trigger mux 3
 */
#define INPUTMUX_DMA_ITRIG_INMUX_INP(x)          (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA_ITRIG_INMUX_INP_SHIFT)) & INPUTMUX_DMA_ITRIG_INMUX_INP_MASK)
/*! @} */

/* The count of INPUTMUX_DMA_ITRIG_INMUX */
#define INPUTMUX_DMA_ITRIG_INMUX_COUNT           (32U)

/*! @name DMA_OTRIG_INMUX - DMA output trigger selection to become DMA trigger */
/*! @{ */
#define INPUTMUX_DMA_OTRIG_INMUX_INP_MASK        (0x1FU)
#define INPUTMUX_DMA_OTRIG_INMUX_INP_SHIFT       (0U)
/*! INP - DMA trigger output number (decimal value) for DMA channel n (n = 0 to 19).
 */
#define INPUTMUX_DMA_OTRIG_INMUX_INP(x)          (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMA_OTRIG_INMUX_INP_SHIFT)) & INPUTMUX_DMA_OTRIG_INMUX_INP_MASK)
/*! @} */

/* The count of INPUTMUX_DMA_OTRIG_INMUX */
#define INPUTMUX_DMA_OTRIG_INMUX_COUNT           (4U)

/*! @name FREQMEAS_REF - Selection for frequency measurement reference clock */
/*! @{ */
#define INPUTMUX_FREQMEAS_REF_CLKIN_MASK         (0x1FU)
#define INPUTMUX_FREQMEAS_REF_CLKIN_SHIFT        (0U)
/*! CLKIN - Clock source number (decimal value) for frequency measure function target clock: 0 =
 *    CLK_IN 1 = FRO 12 MHz oscillator 2 = Watchdog oscillator 3 = 32 kHz RTC oscillator 4 = Main clock
 *    (see Section 4.5.23) 5 = PIO0_4 6 = PIO0_20 7 = PIO0_24 8 = PIO1_4
 */
#define INPUTMUX_FREQMEAS_REF_CLKIN(x)           (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FREQMEAS_REF_CLKIN_SHIFT)) & INPUTMUX_FREQMEAS_REF_CLKIN_MASK)
/*! @} */

/*! @name FREQMEAS_TARGET - Selection for frequency measurement target clock */
/*! @{ */
#define INPUTMUX_FREQMEAS_TARGET_CLKIN_MASK      (0x1FU)
#define INPUTMUX_FREQMEAS_TARGET_CLKIN_SHIFT     (0U)
/*! CLKIN - Clock source number (decimal value) for frequency measure function target clock: 0 =
 *    CLK_IN 1 = FRO 12 MHz oscillator 2 = Watchdog oscillator 3 = 32 kHz RTC oscillator 4 = Main clock
 *    (see Section 4.5.23) 5 = PIO0_4 6 = PIO0_20 7 = PIO0_24 8 = PIO1_4
 */
#define INPUTMUX_FREQMEAS_TARGET_CLKIN(x)        (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FREQMEAS_TARGET_CLKIN_SHIFT)) & INPUTMUX_FREQMEAS_TARGET_CLKIN_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group INPUTMUX_Register_Masks */


/* INPUTMUX - Peripheral instance base addresses */
/** Peripheral INPUTMUX base address */
#define INPUTMUX_BASE                            (0x40005000u)
/** Peripheral INPUTMUX base pointer */
#define INPUTMUX                                 ((INPUTMUX_Type *)INPUTMUX_BASE)
/** Array initializer of INPUTMUX peripheral base addresses */
#define INPUTMUX_BASE_ADDRS                      { INPUTMUX_BASE }
/** Array initializer of INPUTMUX peripheral base pointers */
#define INPUTMUX_BASE_PTRS                       { INPUTMUX }

/*!
 * @}
 */ /* end of group INPUTMUX_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- IOCON Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup IOCON_Peripheral_Access_Layer IOCON Peripheral Access Layer
 * @{
 */

/** IOCON - Register Layout Typedef */
typedef struct {
  __IO uint32_t PIO[6][32];                        /**< Digital I/O control for port 0 pins PIO0_0..Digital I/O control for port 5 pins PIO5_31, array offset: 0x0, array step: index*0x80, index2*0x4 */
} IOCON_Type;

/* ----------------------------------------------------------------------------
   -- IOCON Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup IOCON_Register_Masks IOCON Register Masks
 * @{
 */

/*! @name PIO - Digital I/O control for port 0 pins PIO0_0..Digital I/O control for port 5 pins PIO5_31 */
/*! @{ */
#define IOCON_PIO_FUNC_MASK                      (0xFU)
#define IOCON_PIO_FUNC_SHIFT                     (0U)
/*! FUNC - Selects pin function.
 *  0b0000..Alternative connection 0.
 *  0b0001..Alternative connection 1.
 *  0b0010..Alternative connection 2.
 *  0b0011..Alternative connection 3.
 *  0b0100..Alternative connection 4.
 *  0b0101..Alternative connection 5.
 *  0b0110..Alternative connection 6.
 *  0b0111..Alternative connection 7.
 *  0b1000..Alternative connection 8.
 *  0b1001..Alternative connection 9.
 *  0b1010..Alternative connection 10.
 */
#define IOCON_PIO_FUNC(x)                        (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_FUNC_SHIFT)) & IOCON_PIO_FUNC_MASK)
#define IOCON_PIO_MODE_MASK                      (0x30U)
#define IOCON_PIO_MODE_SHIFT                     (4U)
/*! MODE - Selects function mode (on-chip pull-up/pull-down resistor control).
 *  0b00..Inactive. Inactive (no pull-down/pull-up resistor enabled).
 *  0b01..Pull-down. Pull-down resistor enabled.
 *  0b10..Pull-up. Pull-up resistor enabled.
 *  0b11..Repeater. Repeater mode.
 */
#define IOCON_PIO_MODE(x)                        (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_MODE_SHIFT)) & IOCON_PIO_MODE_MASK)
#define IOCON_PIO_ANAMODE_MASK                   (0x40U)
#define IOCON_PIO_ANAMODE_SHIFT                  (6U)
/*! ANAMODE - Enables or disables analog mode.
 *  0b0..Enable analog Mode.
 *  0b1..Disable analog Mode.
 */
#define IOCON_PIO_ANAMODE(x)                     (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_ANAMODE_SHIFT)) & IOCON_PIO_ANAMODE_MASK)
#define IOCON_PIO_I2CSLEW_MASK                   (0x40U)
#define IOCON_PIO_I2CSLEW_SHIFT                  (6U)
/*! I2CSLEW - Controls slew rate of I2C pad.
 *  0b0..I2C mode.
 *  0b1..GPIO mode.
 */
#define IOCON_PIO_I2CSLEW(x)                     (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_I2CSLEW_SHIFT)) & IOCON_PIO_I2CSLEW_MASK)
#define IOCON_PIO_INVERT_MASK                    (0x80U)
#define IOCON_PIO_INVERT_SHIFT                   (7U)
/*! INVERT - Input polarity.
 *  0b0..Disabled. Input function is not inverted.
 *  0b1..Enabled. Input is function inverted.
 */
#define IOCON_PIO_INVERT(x)                      (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_INVERT_SHIFT)) & IOCON_PIO_INVERT_MASK)
#define IOCON_PIO_DIGIMODE_MASK                  (0x100U)
#define IOCON_PIO_DIGIMODE_SHIFT                 (8U)
/*! DIGIMODE - Select Analog/Digital mode.
 *  0b0..Analog mode.
 *  0b1..Digital mode.
 */
#define IOCON_PIO_DIGIMODE(x)                    (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_DIGIMODE_SHIFT)) & IOCON_PIO_DIGIMODE_MASK)
#define IOCON_PIO_FILTEROFF_MASK                 (0x200U)
#define IOCON_PIO_FILTEROFF_SHIFT                (9U)
/*! FILTEROFF - Controls input glitch filter.
 *  0b0..Filter enabled. Noise pulses below approximately 10 ns are filtered out.
 *  0b1..Filter disabled. No input filtering is done.
 */
#define IOCON_PIO_FILTEROFF(x)                   (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_FILTEROFF_SHIFT)) & IOCON_PIO_FILTEROFF_MASK)
#define IOCON_PIO_I2CDRIVE_MASK                  (0x400U)
#define IOCON_PIO_I2CDRIVE_SHIFT                 (10U)
/*! I2CDRIVE - Controls the current sink capability of the pin.
 *  0b0..Low drive. Output drive sink is 4 mA. This is sufficient for standard and fast mode I2C.
 *  0b1..High drive. Output drive sink is 20 mA. This is needed for Fast Mode Plus I 2C. Refer to the appropriate
 *       specific device data sheet for details.
 */
#define IOCON_PIO_I2CDRIVE(x)                    (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_I2CDRIVE_SHIFT)) & IOCON_PIO_I2CDRIVE_MASK)
#define IOCON_PIO_SLEW_MASK                      (0x400U)
#define IOCON_PIO_SLEW_SHIFT                     (10U)
/*! SLEW - Driver slew rate.
 *  0b0..Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
 *  0b1..Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
 */
#define IOCON_PIO_SLEW(x)                        (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_SLEW_SHIFT)) & IOCON_PIO_SLEW_MASK)
#define IOCON_PIO_I2CFILTEROFF_MASK              (0x800U)
#define IOCON_PIO_I2CFILTEROFF_SHIFT             (11U)
/*! I2CFILTEROFF - Configures I2C features for standard mode, fast mode, and Fast Mode Plus operation.
 *  0b0..Enabled. I2C 50 ns glitch filter enabled.
 *  0b1..Disabled. I2C 50 ns glitch filter disabled.
 */
#define IOCON_PIO_I2CFILTEROFF(x)                (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_I2CFILTEROFF_SHIFT)) & IOCON_PIO_I2CFILTEROFF_MASK)
#define IOCON_PIO_OD_MASK                        (0x800U)
#define IOCON_PIO_OD_SHIFT                       (11U)
/*! OD - Controls open-drain mode.
 *  0b0..Normal. Normal push-pull output
 *  0b1..Open-drain. Simulated open-drain output (high drive disabled).
 */
#define IOCON_PIO_OD(x)                          (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_OD_SHIFT)) & IOCON_PIO_OD_MASK)
/*! @} */

/* The count of IOCON_PIO */
#define IOCON_PIO_COUNT                          (6U)

/* The count of IOCON_PIO */
#define IOCON_PIO_COUNT2                         (32U)


/*!
 * @}
 */ /* end of group IOCON_Register_Masks */


/* IOCON - Peripheral instance base addresses */
/** Peripheral IOCON base address */
#define IOCON_BASE                               (0x40001000u)
/** Peripheral IOCON base pointer */
#define IOCON                                    ((IOCON_Type *)IOCON_BASE)
/** Array initializer of IOCON peripheral base addresses */
#define IOCON_BASE_ADDRS                         { IOCON_BASE }
/** Array initializer of IOCON peripheral base pointers */
#define IOCON_BASE_PTRS                          { IOCON }

/*!
 * @}
 */ /* end of group IOCON_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- LCD Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LCD_Peripheral_Access_Layer LCD Peripheral Access Layer
 * @{
 */

/** LCD - Register Layout Typedef */
typedef struct {
  __IO uint32_t TIMH;                              /**< Horizontal Timing Control register, offset: 0x0 */
  __IO uint32_t TIMV;                              /**< Vertical Timing Control register, offset: 0x4 */
  __IO uint32_t POL;                               /**< Clock and Signal Polarity Control register, offset: 0x8 */
  __IO uint32_t LE;                                /**< Line End Control register, offset: 0xC */
  __IO uint32_t UPBASE;                            /**< Upper Panel Frame Base Address register, offset: 0x10 */
  __IO uint32_t LPBASE;                            /**< Lower Panel Frame Base Address register, offset: 0x14 */
  __IO uint32_t CTRL;                              /**< LCD Control register, offset: 0x18 */
  __IO uint32_t INTMSK;                            /**< Interrupt Mask register, offset: 0x1C */
  __I  uint32_t INTRAW;                            /**< Raw Interrupt Status register, offset: 0x20 */
  __I  uint32_t INTSTAT;                           /**< Masked Interrupt Status register, offset: 0x24 */
  __O  uint32_t INTCLR;                            /**< Interrupt Clear register, offset: 0x28 */
  __I  uint32_t UPCURR;                            /**< Upper Panel Current Address Value register, offset: 0x2C */
  __I  uint32_t LPCURR;                            /**< Lower Panel Current Address Value register, offset: 0x30 */
       uint8_t RESERVED_0[460];
  __IO uint32_t PAL[128];                          /**< 256x16-bit Color Palette registers, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_1[1024];
  __IO uint32_t CRSR_IMG[256];                     /**< Cursor Image registers, array offset: 0x800, array step: 0x4 */
  __IO uint32_t CRSR_CTRL;                         /**< Cursor Control register, offset: 0xC00 */
  __IO uint32_t CRSR_CFG;                          /**< Cursor Configuration register, offset: 0xC04 */
  __IO uint32_t CRSR_PAL0;                         /**< Cursor Palette register 0, offset: 0xC08 */
  __IO uint32_t CRSR_PAL1;                         /**< Cursor Palette register 1, offset: 0xC0C */
  __IO uint32_t CRSR_XY;                           /**< Cursor XY Position register, offset: 0xC10 */
  __IO uint32_t CRSR_CLIP;                         /**< Cursor Clip Position register, offset: 0xC14 */
       uint8_t RESERVED_2[8];
  __IO uint32_t CRSR_INTMSK;                       /**< Cursor Interrupt Mask register, offset: 0xC20 */
  __O  uint32_t CRSR_INTCLR;                       /**< Cursor Interrupt Clear register, offset: 0xC24 */
  __I  uint32_t CRSR_INTRAW;                       /**< Cursor Raw Interrupt Status register, offset: 0xC28 */
  __I  uint32_t CRSR_INTSTAT;                      /**< Cursor Masked Interrupt Status register, offset: 0xC2C */
} LCD_Type;

/* ----------------------------------------------------------------------------
   -- LCD Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LCD_Register_Masks LCD Register Masks
 * @{
 */

/*! @name TIMH - Horizontal Timing Control register */
/*! @{ */
#define LCD_TIMH_PPL_MASK                        (0xFCU)
#define LCD_TIMH_PPL_SHIFT                       (2U)
/*! PPL - Pixels-per-line.
 */
#define LCD_TIMH_PPL(x)                          (((uint32_t)(((uint32_t)(x)) << LCD_TIMH_PPL_SHIFT)) & LCD_TIMH_PPL_MASK)
#define LCD_TIMH_HSW_MASK                        (0xFF00U)
#define LCD_TIMH_HSW_SHIFT                       (8U)
/*! HSW - Horizontal synchronization pulse width.
 */
#define LCD_TIMH_HSW(x)                          (((uint32_t)(((uint32_t)(x)) << LCD_TIMH_HSW_SHIFT)) & LCD_TIMH_HSW_MASK)
#define LCD_TIMH_HFP_MASK                        (0xFF0000U)
#define LCD_TIMH_HFP_SHIFT                       (16U)
/*! HFP - Horizontal front porch.
 */
#define LCD_TIMH_HFP(x)                          (((uint32_t)(((uint32_t)(x)) << LCD_TIMH_HFP_SHIFT)) & LCD_TIMH_HFP_MASK)
#define LCD_TIMH_HBP_MASK                        (0xFF000000U)
#define LCD_TIMH_HBP_SHIFT                       (24U)
/*! HBP - Horizontal back porch.
 */
#define LCD_TIMH_HBP(x)                          (((uint32_t)(((uint32_t)(x)) << LCD_TIMH_HBP_SHIFT)) & LCD_TIMH_HBP_MASK)
/*! @} */

/*! @name TIMV - Vertical Timing Control register */
/*! @{ */
#define LCD_TIMV_LPP_MASK                        (0x3FFU)
#define LCD_TIMV_LPP_SHIFT                       (0U)
/*! LPP - Lines per panel.
 */
#define LCD_TIMV_LPP(x)                          (((uint32_t)(((uint32_t)(x)) << LCD_TIMV_LPP_SHIFT)) & LCD_TIMV_LPP_MASK)
#define LCD_TIMV_VSW_MASK                        (0xFC00U)
#define LCD_TIMV_VSW_SHIFT                       (10U)
/*! VSW - Vertical synchronization pulse width.
 */
#define LCD_TIMV_VSW(x)                          (((uint32_t)(((uint32_t)(x)) << LCD_TIMV_VSW_SHIFT)) & LCD_TIMV_VSW_MASK)
#define LCD_TIMV_VFP_MASK                        (0xFF0000U)
#define LCD_TIMV_VFP_SHIFT                       (16U)
/*! VFP - Vertical front porch.
 */
#define LCD_TIMV_VFP(x)                          (((uint32_t)(((uint32_t)(x)) << LCD_TIMV_VFP_SHIFT)) & LCD_TIMV_VFP_MASK)
#define LCD_TIMV_VBP_MASK                        (0xFF000000U)
#define LCD_TIMV_VBP_SHIFT                       (24U)
/*! VBP - Vertical back porch.
 */
#define LCD_TIMV_VBP(x)                          (((uint32_t)(((uint32_t)(x)) << LCD_TIMV_VBP_SHIFT)) & LCD_TIMV_VBP_MASK)
/*! @} */

/*! @name POL - Clock and Signal Polarity Control register */
/*! @{ */
#define LCD_POL_PCD_LO_MASK                      (0x1FU)
#define LCD_POL_PCD_LO_SHIFT                     (0U)
/*! PCD_LO - Lower five bits of panel clock divisor.
 */
#define LCD_POL_PCD_LO(x)                        (((uint32_t)(((uint32_t)(x)) << LCD_POL_PCD_LO_SHIFT)) & LCD_POL_PCD_LO_MASK)
#define LCD_POL_ACB_MASK                         (0x7C0U)
#define LCD_POL_ACB_SHIFT                        (6U)
/*! ACB - AC bias pin frequency.
 */
#define LCD_POL_ACB(x)                           (((uint32_t)(((uint32_t)(x)) << LCD_POL_ACB_SHIFT)) & LCD_POL_ACB_MASK)
#define LCD_POL_IVS_MASK                         (0x800U)
#define LCD_POL_IVS_SHIFT                        (11U)
/*! IVS - Invert vertical synchronization.
 */
#define LCD_POL_IVS(x)                           (((uint32_t)(((uint32_t)(x)) << LCD_POL_IVS_SHIFT)) & LCD_POL_IVS_MASK)
#define LCD_POL_IHS_MASK                         (0x1000U)
#define LCD_POL_IHS_SHIFT                        (12U)
/*! IHS - Invert horizontal synchronization.
 */
#define LCD_POL_IHS(x)                           (((uint32_t)(((uint32_t)(x)) << LCD_POL_IHS_SHIFT)) & LCD_POL_IHS_MASK)
#define LCD_POL_IPC_MASK                         (0x2000U)
#define LCD_POL_IPC_SHIFT                        (13U)
/*! IPC - Invert panel clock.
 */
#define LCD_POL_IPC(x)                           (((uint32_t)(((uint32_t)(x)) << LCD_POL_IPC_SHIFT)) & LCD_POL_IPC_MASK)
#define LCD_POL_IOE_MASK                         (0x4000U)
#define LCD_POL_IOE_SHIFT                        (14U)
/*! IOE - Invert output enable.
 */
#define LCD_POL_IOE(x)                           (((uint32_t)(((uint32_t)(x)) << LCD_POL_IOE_SHIFT)) & LCD_POL_IOE_MASK)
#define LCD_POL_CPL_MASK                         (0x3FF0000U)
#define LCD_POL_CPL_SHIFT                        (16U)
/*! CPL - Clocks per line.
 */
#define LCD_POL_CPL(x)                           (((uint32_t)(((uint32_t)(x)) << LCD_POL_CPL_SHIFT)) & LCD_POL_CPL_MASK)
#define LCD_POL_BCD_MASK                         (0x4000000U)
#define LCD_POL_BCD_SHIFT                        (26U)
/*! BCD - Bypass panel clock divider.
 */
#define LCD_POL_BCD(x)                           (((uint32_t)(((uint32_t)(x)) << LCD_POL_BCD_SHIFT)) & LCD_POL_BCD_MASK)
#define LCD_POL_PCD_HI_MASK                      (0xF8000000U)
#define LCD_POL_PCD_HI_SHIFT                     (27U)
/*! PCD_HI - Upper five bits of panel clock divisor.
 */
#define LCD_POL_PCD_HI(x)                        (((uint32_t)(((uint32_t)(x)) << LCD_POL_PCD_HI_SHIFT)) & LCD_POL_PCD_HI_MASK)
/*! @} */

/*! @name LE - Line End Control register */
/*! @{ */
#define LCD_LE_LED_MASK                          (0x7FU)
#define LCD_LE_LED_SHIFT                         (0U)
/*! LED - Line-end delay.
 */
#define LCD_LE_LED(x)                            (((uint32_t)(((uint32_t)(x)) << LCD_LE_LED_SHIFT)) & LCD_LE_LED_MASK)
#define LCD_LE_LEE_MASK                          (0x10000U)
#define LCD_LE_LEE_SHIFT                         (16U)
/*! LEE - LCD Line end enable.
 */
#define LCD_LE_LEE(x)                            (((uint32_t)(((uint32_t)(x)) << LCD_LE_LEE_SHIFT)) & LCD_LE_LEE_MASK)
/*! @} */

/*! @name UPBASE - Upper Panel Frame Base Address register */
/*! @{ */
#define LCD_UPBASE_LCDUPBASE_MASK                (0xFFFFFFF8U)
#define LCD_UPBASE_LCDUPBASE_SHIFT               (3U)
/*! LCDUPBASE - LCD upper panel base address.
 */
#define LCD_UPBASE_LCDUPBASE(x)                  (((uint32_t)(((uint32_t)(x)) << LCD_UPBASE_LCDUPBASE_SHIFT)) & LCD_UPBASE_LCDUPBASE_MASK)
/*! @} */

/*! @name LPBASE - Lower Panel Frame Base Address register */
/*! @{ */
#define LCD_LPBASE_LCDLPBASE_MASK                (0xFFFFFFF8U)
#define LCD_LPBASE_LCDLPBASE_SHIFT               (3U)
/*! LCDLPBASE - LCD lower panel base address.
 */
#define LCD_LPBASE_LCDLPBASE(x)                  (((uint32_t)(((uint32_t)(x)) << LCD_LPBASE_LCDLPBASE_SHIFT)) & LCD_LPBASE_LCDLPBASE_MASK)
/*! @} */

/*! @name CTRL - LCD Control register */
/*! @{ */
#define LCD_CTRL_LCDEN_MASK                      (0x1U)
#define LCD_CTRL_LCDEN_SHIFT                     (0U)
/*! LCDEN - LCD enable control bit.
 */
#define LCD_CTRL_LCDEN(x)                        (((uint32_t)(((uint32_t)(x)) << LCD_CTRL_LCDEN_SHIFT)) & LCD_CTRL_LCDEN_MASK)
#define LCD_CTRL_LCDBPP_MASK                     (0xEU)
#define LCD_CTRL_LCDBPP_SHIFT                    (1U)
/*! LCDBPP - LCD bits per pixel.
 */
#define LCD_CTRL_LCDBPP(x)                       (((uint32_t)(((uint32_t)(x)) << LCD_CTRL_LCDBPP_SHIFT)) & LCD_CTRL_LCDBPP_MASK)
#define LCD_CTRL_LCDBW_MASK                      (0x10U)
#define LCD_CTRL_LCDBW_SHIFT                     (4U)
/*! LCDBW - STN LCD monochrome/color selection.
 */
#define LCD_CTRL_LCDBW(x)                        (((uint32_t)(((uint32_t)(x)) << LCD_CTRL_LCDBW_SHIFT)) & LCD_CTRL_LCDBW_MASK)
#define LCD_CTRL_LCDTFT_MASK                     (0x20U)
#define LCD_CTRL_LCDTFT_SHIFT                    (5U)
/*! LCDTFT - LCD panel TFT type selection.
 */
#define LCD_CTRL_LCDTFT(x)                       (((uint32_t)(((uint32_t)(x)) << LCD_CTRL_LCDTFT_SHIFT)) & LCD_CTRL_LCDTFT_MASK)
#define LCD_CTRL_LCDMONO8_MASK                   (0x40U)
#define LCD_CTRL_LCDMONO8_SHIFT                  (6U)
/*! LCDMONO8 - Monochrome LCD interface width.
 */
#define LCD_CTRL_LCDMONO8(x)                     (((uint32_t)(((uint32_t)(x)) << LCD_CTRL_LCDMONO8_SHIFT)) & LCD_CTRL_LCDMONO8_MASK)
#define LCD_CTRL_LCDDUAL_MASK                    (0x80U)
#define LCD_CTRL_LCDDUAL_SHIFT                   (7U)
/*! LCDDUAL - Single or Dual LCD panel selection.
 */
#define LCD_CTRL_LCDDUAL(x)                      (((uint32_t)(((uint32_t)(x)) << LCD_CTRL_LCDDUAL_SHIFT)) & LCD_CTRL_LCDDUAL_MASK)
#define LCD_CTRL_BGR_MASK                        (0x100U)
#define LCD_CTRL_BGR_SHIFT                       (8U)
/*! BGR - Color format selection.
 */
#define LCD_CTRL_BGR(x)                          (((uint32_t)(((uint32_t)(x)) << LCD_CTRL_BGR_SHIFT)) & LCD_CTRL_BGR_MASK)
#define LCD_CTRL_BEBO_MASK                       (0x200U)
#define LCD_CTRL_BEBO_SHIFT                      (9U)
/*! BEBO - Big-endian Byte Order.
 */
#define LCD_CTRL_BEBO(x)                         (((uint32_t)(((uint32_t)(x)) << LCD_CTRL_BEBO_SHIFT)) & LCD_CTRL_BEBO_MASK)
#define LCD_CTRL_BEPO_MASK                       (0x400U)
#define LCD_CTRL_BEPO_SHIFT                      (10U)
/*! BEPO - Big-Endian Pixel Ordering.
 */
#define LCD_CTRL_BEPO(x)                         (((uint32_t)(((uint32_t)(x)) << LCD_CTRL_BEPO_SHIFT)) & LCD_CTRL_BEPO_MASK)
#define LCD_CTRL_LCDPWR_MASK                     (0x800U)
#define LCD_CTRL_LCDPWR_SHIFT                    (11U)
/*! LCDPWR - LCD power enable.
 */
#define LCD_CTRL_LCDPWR(x)                       (((uint32_t)(((uint32_t)(x)) << LCD_CTRL_LCDPWR_SHIFT)) & LCD_CTRL_LCDPWR_MASK)
#define LCD_CTRL_LCDVCOMP_MASK                   (0x3000U)
#define LCD_CTRL_LCDVCOMP_SHIFT                  (12U)
/*! LCDVCOMP - LCD Vertical Compare Interrupt.
 */
#define LCD_CTRL_LCDVCOMP(x)                     (((uint32_t)(((uint32_t)(x)) << LCD_CTRL_LCDVCOMP_SHIFT)) & LCD_CTRL_LCDVCOMP_MASK)
#define LCD_CTRL_WATERMARK_MASK                  (0x10000U)
#define LCD_CTRL_WATERMARK_SHIFT                 (16U)
/*! WATERMARK - LCD DMA FIFO watermark level.
 */
#define LCD_CTRL_WATERMARK(x)                    (((uint32_t)(((uint32_t)(x)) << LCD_CTRL_WATERMARK_SHIFT)) & LCD_CTRL_WATERMARK_MASK)
/*! @} */

/*! @name INTMSK - Interrupt Mask register */
/*! @{ */
#define LCD_INTMSK_FUFIM_MASK                    (0x2U)
#define LCD_INTMSK_FUFIM_SHIFT                   (1U)
/*! FUFIM - FIFO underflow interrupt enable.
 */
#define LCD_INTMSK_FUFIM(x)                      (((uint32_t)(((uint32_t)(x)) << LCD_INTMSK_FUFIM_SHIFT)) & LCD_INTMSK_FUFIM_MASK)
#define LCD_INTMSK_LNBUIM_MASK                   (0x4U)
#define LCD_INTMSK_LNBUIM_SHIFT                  (2U)
/*! LNBUIM - LCD next base address update interrupt enable.
 */
#define LCD_INTMSK_LNBUIM(x)                     (((uint32_t)(((uint32_t)(x)) << LCD_INTMSK_LNBUIM_SHIFT)) & LCD_INTMSK_LNBUIM_MASK)
#define LCD_INTMSK_VCOMPIM_MASK                  (0x8U)
#define LCD_INTMSK_VCOMPIM_SHIFT                 (3U)
/*! VCOMPIM - Vertical compare interrupt enable.
 */
#define LCD_INTMSK_VCOMPIM(x)                    (((uint32_t)(((uint32_t)(x)) << LCD_INTMSK_VCOMPIM_SHIFT)) & LCD_INTMSK_VCOMPIM_MASK)
#define LCD_INTMSK_BERIM_MASK                    (0x10U)
#define LCD_INTMSK_BERIM_SHIFT                   (4U)
/*! BERIM - AHB master error interrupt enable.
 */
#define LCD_INTMSK_BERIM(x)                      (((uint32_t)(((uint32_t)(x)) << LCD_INTMSK_BERIM_SHIFT)) & LCD_INTMSK_BERIM_MASK)
/*! @} */

/*! @name INTRAW - Raw Interrupt Status register */
/*! @{ */
#define LCD_INTRAW_FUFRIS_MASK                   (0x2U)
#define LCD_INTRAW_FUFRIS_SHIFT                  (1U)
/*! FUFRIS - FIFO underflow raw interrupt status.
 */
#define LCD_INTRAW_FUFRIS(x)                     (((uint32_t)(((uint32_t)(x)) << LCD_INTRAW_FUFRIS_SHIFT)) & LCD_INTRAW_FUFRIS_MASK)
#define LCD_INTRAW_LNBURIS_MASK                  (0x4U)
#define LCD_INTRAW_LNBURIS_SHIFT                 (2U)
/*! LNBURIS - LCD next address base update raw interrupt status.
 */
#define LCD_INTRAW_LNBURIS(x)                    (((uint32_t)(((uint32_t)(x)) << LCD_INTRAW_LNBURIS_SHIFT)) & LCD_INTRAW_LNBURIS_MASK)
#define LCD_INTRAW_VCOMPRIS_MASK                 (0x8U)
#define LCD_INTRAW_VCOMPRIS_SHIFT                (3U)
/*! VCOMPRIS - Vertical compare raw interrupt status.
 */
#define LCD_INTRAW_VCOMPRIS(x)                   (((uint32_t)(((uint32_t)(x)) << LCD_INTRAW_VCOMPRIS_SHIFT)) & LCD_INTRAW_VCOMPRIS_MASK)
#define LCD_INTRAW_BERRAW_MASK                   (0x10U)
#define LCD_INTRAW_BERRAW_SHIFT                  (4U)
/*! BERRAW - AHB master bus error raw interrupt status.
 */
#define LCD_INTRAW_BERRAW(x)                     (((uint32_t)(((uint32_t)(x)) << LCD_INTRAW_BERRAW_SHIFT)) & LCD_INTRAW_BERRAW_MASK)
/*! @} */

/*! @name INTSTAT - Masked Interrupt Status register */
/*! @{ */
#define LCD_INTSTAT_FUFMIS_MASK                  (0x2U)
#define LCD_INTSTAT_FUFMIS_SHIFT                 (1U)
/*! FUFMIS - FIFO underflow masked interrupt status.
 */
#define LCD_INTSTAT_FUFMIS(x)                    (((uint32_t)(((uint32_t)(x)) << LCD_INTSTAT_FUFMIS_SHIFT)) & LCD_INTSTAT_FUFMIS_MASK)
#define LCD_INTSTAT_LNBUMIS_MASK                 (0x4U)
#define LCD_INTSTAT_LNBUMIS_SHIFT                (2U)
/*! LNBUMIS - LCD next address base update masked interrupt status.
 */
#define LCD_INTSTAT_LNBUMIS(x)                   (((uint32_t)(((uint32_t)(x)) << LCD_INTSTAT_LNBUMIS_SHIFT)) & LCD_INTSTAT_LNBUMIS_MASK)
#define LCD_INTSTAT_VCOMPMIS_MASK                (0x8U)
#define LCD_INTSTAT_VCOMPMIS_SHIFT               (3U)
/*! VCOMPMIS - Vertical compare masked interrupt status.
 */
#define LCD_INTSTAT_VCOMPMIS(x)                  (((uint32_t)(((uint32_t)(x)) << LCD_INTSTAT_VCOMPMIS_SHIFT)) & LCD_INTSTAT_VCOMPMIS_MASK)
#define LCD_INTSTAT_BERMIS_MASK                  (0x10U)
#define LCD_INTSTAT_BERMIS_SHIFT                 (4U)
/*! BERMIS - AHB master bus error masked interrupt status.
 */
#define LCD_INTSTAT_BERMIS(x)                    (((uint32_t)(((uint32_t)(x)) << LCD_INTSTAT_BERMIS_SHIFT)) & LCD_INTSTAT_BERMIS_MASK)
/*! @} */

/*! @name INTCLR - Interrupt Clear register */
/*! @{ */
#define LCD_INTCLR_FUFIC_MASK                    (0x2U)
#define LCD_INTCLR_FUFIC_SHIFT                   (1U)
/*! FUFIC - FIFO underflow interrupt clear.
 */
#define LCD_INTCLR_FUFIC(x)                      (((uint32_t)(((uint32_t)(x)) << LCD_INTCLR_FUFIC_SHIFT)) & LCD_INTCLR_FUFIC_MASK)
#define LCD_INTCLR_LNBUIC_MASK                   (0x4U)
#define LCD_INTCLR_LNBUIC_SHIFT                  (2U)
/*! LNBUIC - LCD next address base update interrupt clear.
 */
#define LCD_INTCLR_LNBUIC(x)                     (((uint32_t)(((uint32_t)(x)) << LCD_INTCLR_LNBUIC_SHIFT)) & LCD_INTCLR_LNBUIC_MASK)
#define LCD_INTCLR_VCOMPIC_MASK                  (0x8U)
#define LCD_INTCLR_VCOMPIC_SHIFT                 (3U)
/*! VCOMPIC - Vertical compare interrupt clear.
 */
#define LCD_INTCLR_VCOMPIC(x)                    (((uint32_t)(((uint32_t)(x)) << LCD_INTCLR_VCOMPIC_SHIFT)) & LCD_INTCLR_VCOMPIC_MASK)
#define LCD_INTCLR_BERIC_MASK                    (0x10U)
#define LCD_INTCLR_BERIC_SHIFT                   (4U)
/*! BERIC - AHB master error interrupt clear.
 */
#define LCD_INTCLR_BERIC(x)                      (((uint32_t)(((uint32_t)(x)) << LCD_INTCLR_BERIC_SHIFT)) & LCD_INTCLR_BERIC_MASK)
/*! @} */

/*! @name UPCURR - Upper Panel Current Address Value register */
/*! @{ */
#define LCD_UPCURR_LCDUPCURR_MASK                (0xFFFFFFFFU)
#define LCD_UPCURR_LCDUPCURR_SHIFT               (0U)
/*! LCDUPCURR - LCD Upper Panel Current Address.
 */
#define LCD_UPCURR_LCDUPCURR(x)                  (((uint32_t)(((uint32_t)(x)) << LCD_UPCURR_LCDUPCURR_SHIFT)) & LCD_UPCURR_LCDUPCURR_MASK)
/*! @} */

/*! @name LPCURR - Lower Panel Current Address Value register */
/*! @{ */
#define LCD_LPCURR_LCDLPCURR_MASK                (0xFFFFFFFFU)
#define LCD_LPCURR_LCDLPCURR_SHIFT               (0U)
/*! LCDLPCURR - LCD Lower Panel Current Address.
 */
#define LCD_LPCURR_LCDLPCURR(x)                  (((uint32_t)(((uint32_t)(x)) << LCD_LPCURR_LCDLPCURR_SHIFT)) & LCD_LPCURR_LCDLPCURR_MASK)
/*! @} */

/*! @name PAL - 256x16-bit Color Palette registers */
/*! @{ */
#define LCD_PAL_R04_0_MASK                       (0x1FU)
#define LCD_PAL_R04_0_SHIFT                      (0U)
/*! R04_0 - Red palette data.
 */
#define LCD_PAL_R04_0(x)                         (((uint32_t)(((uint32_t)(x)) << LCD_PAL_R04_0_SHIFT)) & LCD_PAL_R04_0_MASK)
#define LCD_PAL_G04_0_MASK                       (0x3E0U)
#define LCD_PAL_G04_0_SHIFT                      (5U)
/*! G04_0 - Green palette data.
 */
#define LCD_PAL_G04_0(x)                         (((uint32_t)(((uint32_t)(x)) << LCD_PAL_G04_0_SHIFT)) & LCD_PAL_G04_0_MASK)
#define LCD_PAL_B04_0_MASK                       (0x7C00U)
#define LCD_PAL_B04_0_SHIFT                      (10U)
/*! B04_0 - Blue palette data.
 */
#define LCD_PAL_B04_0(x)                         (((uint32_t)(((uint32_t)(x)) << LCD_PAL_B04_0_SHIFT)) & LCD_PAL_B04_0_MASK)
#define LCD_PAL_I0_MASK                          (0x8000U)
#define LCD_PAL_I0_SHIFT                         (15U)
/*! I0 - Intensity / unused bit.
 */
#define LCD_PAL_I0(x)                            (((uint32_t)(((uint32_t)(x)) << LCD_PAL_I0_SHIFT)) & LCD_PAL_I0_MASK)
#define LCD_PAL_R14_0_MASK                       (0x1F0000U)
#define LCD_PAL_R14_0_SHIFT                      (16U)
/*! R14_0 - Red palette data.
 */
#define LCD_PAL_R14_0(x)                         (((uint32_t)(((uint32_t)(x)) << LCD_PAL_R14_0_SHIFT)) & LCD_PAL_R14_0_MASK)
#define LCD_PAL_G14_0_MASK                       (0x3E00000U)
#define LCD_PAL_G14_0_SHIFT                      (21U)
/*! G14_0 - Green palette data.
 */
#define LCD_PAL_G14_0(x)                         (((uint32_t)(((uint32_t)(x)) << LCD_PAL_G14_0_SHIFT)) & LCD_PAL_G14_0_MASK)
#define LCD_PAL_B14_0_MASK                       (0x7C000000U)
#define LCD_PAL_B14_0_SHIFT                      (26U)
/*! B14_0 - Blue palette data.
 */
#define LCD_PAL_B14_0(x)                         (((uint32_t)(((uint32_t)(x)) << LCD_PAL_B14_0_SHIFT)) & LCD_PAL_B14_0_MASK)
#define LCD_PAL_I1_MASK                          (0x80000000U)
#define LCD_PAL_I1_SHIFT                         (31U)
/*! I1 - Intensity / unused bit.
 */
#define LCD_PAL_I1(x)                            (((uint32_t)(((uint32_t)(x)) << LCD_PAL_I1_SHIFT)) & LCD_PAL_I1_MASK)
/*! @} */

/* The count of LCD_PAL */
#define LCD_PAL_COUNT                            (128U)

/*! @name CRSR_IMG - Cursor Image registers */
/*! @{ */
#define LCD_CRSR_IMG_CRSR_IMG_MASK               (0xFFFFFFFFU)
#define LCD_CRSR_IMG_CRSR_IMG_SHIFT              (0U)
/*! CRSR_IMG - Cursor Image data.
 */
#define LCD_CRSR_IMG_CRSR_IMG(x)                 (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_IMG_CRSR_IMG_SHIFT)) & LCD_CRSR_IMG_CRSR_IMG_MASK)
/*! @} */

/* The count of LCD_CRSR_IMG */
#define LCD_CRSR_IMG_COUNT                       (256U)

/*! @name CRSR_CTRL - Cursor Control register */
/*! @{ */
#define LCD_CRSR_CTRL_CRSRON_MASK                (0x1U)
#define LCD_CRSR_CTRL_CRSRON_SHIFT               (0U)
/*! CRSRON - Cursor enable.
 */
#define LCD_CRSR_CTRL_CRSRON(x)                  (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_CTRL_CRSRON_SHIFT)) & LCD_CRSR_CTRL_CRSRON_MASK)
#define LCD_CRSR_CTRL_CRSRNUM1_0_MASK            (0x30U)
#define LCD_CRSR_CTRL_CRSRNUM1_0_SHIFT           (4U)
/*! CRSRNUM1_0 - Cursor image number.
 */
#define LCD_CRSR_CTRL_CRSRNUM1_0(x)              (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_CTRL_CRSRNUM1_0_SHIFT)) & LCD_CRSR_CTRL_CRSRNUM1_0_MASK)
/*! @} */

/*! @name CRSR_CFG - Cursor Configuration register */
/*! @{ */
#define LCD_CRSR_CFG_CRSRSIZE_MASK               (0x1U)
#define LCD_CRSR_CFG_CRSRSIZE_SHIFT              (0U)
/*! CRSRSIZE - Cursor size selection.
 */
#define LCD_CRSR_CFG_CRSRSIZE(x)                 (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_CFG_CRSRSIZE_SHIFT)) & LCD_CRSR_CFG_CRSRSIZE_MASK)
#define LCD_CRSR_CFG_FRAMESYNC_MASK              (0x2U)
#define LCD_CRSR_CFG_FRAMESYNC_SHIFT             (1U)
/*! FRAMESYNC - Cursor frame synchronization type.
 */
#define LCD_CRSR_CFG_FRAMESYNC(x)                (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_CFG_FRAMESYNC_SHIFT)) & LCD_CRSR_CFG_FRAMESYNC_MASK)
/*! @} */

/*! @name CRSR_PAL0 - Cursor Palette register 0 */
/*! @{ */
#define LCD_CRSR_PAL0_RED_MASK                   (0xFFU)
#define LCD_CRSR_PAL0_RED_SHIFT                  (0U)
/*! RED - Red color component.
 */
#define LCD_CRSR_PAL0_RED(x)                     (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_PAL0_RED_SHIFT)) & LCD_CRSR_PAL0_RED_MASK)
#define LCD_CRSR_PAL0_GREEN_MASK                 (0xFF00U)
#define LCD_CRSR_PAL0_GREEN_SHIFT                (8U)
/*! GREEN - Green color component.
 */
#define LCD_CRSR_PAL0_GREEN(x)                   (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_PAL0_GREEN_SHIFT)) & LCD_CRSR_PAL0_GREEN_MASK)
#define LCD_CRSR_PAL0_BLUE_MASK                  (0xFF0000U)
#define LCD_CRSR_PAL0_BLUE_SHIFT                 (16U)
/*! BLUE - Blue color component.
 */
#define LCD_CRSR_PAL0_BLUE(x)                    (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_PAL0_BLUE_SHIFT)) & LCD_CRSR_PAL0_BLUE_MASK)
/*! @} */

/*! @name CRSR_PAL1 - Cursor Palette register 1 */
/*! @{ */
#define LCD_CRSR_PAL1_RED_MASK                   (0xFFU)
#define LCD_CRSR_PAL1_RED_SHIFT                  (0U)
/*! RED - Red color component.
 */
#define LCD_CRSR_PAL1_RED(x)                     (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_PAL1_RED_SHIFT)) & LCD_CRSR_PAL1_RED_MASK)
#define LCD_CRSR_PAL1_GREEN_MASK                 (0xFF00U)
#define LCD_CRSR_PAL1_GREEN_SHIFT                (8U)
/*! GREEN - Green color component.
 */
#define LCD_CRSR_PAL1_GREEN(x)                   (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_PAL1_GREEN_SHIFT)) & LCD_CRSR_PAL1_GREEN_MASK)
#define LCD_CRSR_PAL1_BLUE_MASK                  (0xFF0000U)
#define LCD_CRSR_PAL1_BLUE_SHIFT                 (16U)
/*! BLUE - Blue color component.
 */
#define LCD_CRSR_PAL1_BLUE(x)                    (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_PAL1_BLUE_SHIFT)) & LCD_CRSR_PAL1_BLUE_MASK)
/*! @} */

/*! @name CRSR_XY - Cursor XY Position register */
/*! @{ */
#define LCD_CRSR_XY_CRSRX_MASK                   (0x3FFU)
#define LCD_CRSR_XY_CRSRX_SHIFT                  (0U)
/*! CRSRX - X ordinate of the cursor origin measured in pixels.
 */
#define LCD_CRSR_XY_CRSRX(x)                     (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_XY_CRSRX_SHIFT)) & LCD_CRSR_XY_CRSRX_MASK)
#define LCD_CRSR_XY_CRSRY_MASK                   (0x3FF0000U)
#define LCD_CRSR_XY_CRSRY_SHIFT                  (16U)
/*! CRSRY - Y ordinate of the cursor origin measured in pixels.
 */
#define LCD_CRSR_XY_CRSRY(x)                     (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_XY_CRSRY_SHIFT)) & LCD_CRSR_XY_CRSRY_MASK)
/*! @} */

/*! @name CRSR_CLIP - Cursor Clip Position register */
/*! @{ */
#define LCD_CRSR_CLIP_CRSRCLIPX_MASK             (0x3FU)
#define LCD_CRSR_CLIP_CRSRCLIPX_SHIFT            (0U)
/*! CRSRCLIPX - Cursor clip position for X direction.
 */
#define LCD_CRSR_CLIP_CRSRCLIPX(x)               (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_CLIP_CRSRCLIPX_SHIFT)) & LCD_CRSR_CLIP_CRSRCLIPX_MASK)
#define LCD_CRSR_CLIP_CRSRCLIPY_MASK             (0x3F00U)
#define LCD_CRSR_CLIP_CRSRCLIPY_SHIFT            (8U)
/*! CRSRCLIPY - Cursor clip position for Y direction.
 */
#define LCD_CRSR_CLIP_CRSRCLIPY(x)               (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_CLIP_CRSRCLIPY_SHIFT)) & LCD_CRSR_CLIP_CRSRCLIPY_MASK)
/*! @} */

/*! @name CRSR_INTMSK - Cursor Interrupt Mask register */
/*! @{ */
#define LCD_CRSR_INTMSK_CRSRIM_MASK              (0x1U)
#define LCD_CRSR_INTMSK_CRSRIM_SHIFT             (0U)
/*! CRSRIM - Cursor interrupt mask.
 */
#define LCD_CRSR_INTMSK_CRSRIM(x)                (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_INTMSK_CRSRIM_SHIFT)) & LCD_CRSR_INTMSK_CRSRIM_MASK)
/*! @} */

/*! @name CRSR_INTCLR - Cursor Interrupt Clear register */
/*! @{ */
#define LCD_CRSR_INTCLR_CRSRIC_MASK              (0x1U)
#define LCD_CRSR_INTCLR_CRSRIC_SHIFT             (0U)
/*! CRSRIC - Cursor interrupt clear.
 */
#define LCD_CRSR_INTCLR_CRSRIC(x)                (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_INTCLR_CRSRIC_SHIFT)) & LCD_CRSR_INTCLR_CRSRIC_MASK)
/*! @} */

/*! @name CRSR_INTRAW - Cursor Raw Interrupt Status register */
/*! @{ */
#define LCD_CRSR_INTRAW_CRSRRIS_MASK             (0x1U)
#define LCD_CRSR_INTRAW_CRSRRIS_SHIFT            (0U)
/*! CRSRRIS - Cursor raw interrupt status.
 */
#define LCD_CRSR_INTRAW_CRSRRIS(x)               (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_INTRAW_CRSRRIS_SHIFT)) & LCD_CRSR_INTRAW_CRSRRIS_MASK)
/*! @} */

/*! @name CRSR_INTSTAT - Cursor Masked Interrupt Status register */
/*! @{ */
#define LCD_CRSR_INTSTAT_CRSRMIS_MASK            (0x1U)
#define LCD_CRSR_INTSTAT_CRSRMIS_SHIFT           (0U)
/*! CRSRMIS - Cursor masked interrupt status.
 */
#define LCD_CRSR_INTSTAT_CRSRMIS(x)              (((uint32_t)(((uint32_t)(x)) << LCD_CRSR_INTSTAT_CRSRMIS_SHIFT)) & LCD_CRSR_INTSTAT_CRSRMIS_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group LCD_Register_Masks */


/* LCD - Peripheral instance base addresses */
/** Peripheral LCD base address */
#define LCD_BASE                                 (0x40083000u)
/** Peripheral LCD base pointer */
#define LCD                                      ((LCD_Type *)LCD_BASE)
/** Array initializer of LCD peripheral base addresses */
#define LCD_BASE_ADDRS                           { LCD_BASE }
/** Array initializer of LCD peripheral base pointers */
#define LCD_BASE_PTRS                            { LCD }
/** Interrupt vectors for the LCD peripheral type */
#define LCD_IRQS                                 { LCD_IRQn }

/*!
 * @}
 */ /* end of group LCD_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MRT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MRT_Peripheral_Access_Layer MRT Peripheral Access Layer
 * @{
 */

/** MRT - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x10 */
    __IO uint32_t INTVAL;                            /**< MRT Time interval value register. This value is loaded into the TIMER register., array offset: 0x0, array step: 0x10 */
    __I  uint32_t TIMER;                             /**< MRT Timer register. This register reads the value of the down-counter., array offset: 0x4, array step: 0x10 */
    __IO uint32_t CTRL;                              /**< MRT Control register. This register controls the MRT modes., array offset: 0x8, array step: 0x10 */
    __IO uint32_t STAT;                              /**< MRT Status register., array offset: 0xC, array step: 0x10 */
  } CHANNEL[4];
       uint8_t RESERVED_0[176];
  __IO uint32_t MODCFG;                            /**< Module Configuration register. This register provides information about this particular MRT instance, and allows choosing an overall mode for the idle channel feature., offset: 0xF0 */
  __I  uint32_t IDLE_CH;                           /**< Idle channel register. This register returns the number of the first idle channel., offset: 0xF4 */
  __IO uint32_t IRQ_FLAG;                          /**< Global interrupt flag register, offset: 0xF8 */
} MRT_Type;

/* ----------------------------------------------------------------------------
   -- MRT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MRT_Register_Masks MRT Register Masks
 * @{
 */

/*! @name CHANNEL_INTVAL - MRT Time interval value register. This value is loaded into the TIMER register. */
/*! @{ */
#define MRT_CHANNEL_INTVAL_IVALUE_MASK           (0xFFFFFFU)
#define MRT_CHANNEL_INTVAL_IVALUE_SHIFT          (0U)
/*! IVALUE - Time interval load value. This value is loaded into the TIMERn register and the MRT
 *    channel n starts counting down from IVALUE -1. If the timer is idle, writing a non-zero value to
 *    this bit field starts the timer immediately. If the timer is running, writing a zero to this
 *    bit field does the following: If LOAD = 1, the timer stops immediately. If LOAD = 0, the timer
 *    stops at the end of the time interval.
 */
#define MRT_CHANNEL_INTVAL_IVALUE(x)             (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_INTVAL_IVALUE_SHIFT)) & MRT_CHANNEL_INTVAL_IVALUE_MASK)
#define MRT_CHANNEL_INTVAL_LOAD_MASK             (0x80000000U)
#define MRT_CHANNEL_INTVAL_LOAD_SHIFT            (31U)
/*! LOAD - Determines how the timer interval value IVALUE -1 is loaded into the TIMERn register.
 *    This bit is write-only. Reading this bit always returns 0.
 *  0b0..No force load. The load from the INTVALn register to the TIMERn register is processed at the end of the
 *       time interval if the repeat mode is selected.
 *  0b1..Force load. The INTVALn interval value IVALUE -1 is immediately loaded into the TIMERn register while TIMERn is running.
 */
#define MRT_CHANNEL_INTVAL_LOAD(x)               (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_INTVAL_LOAD_SHIFT)) & MRT_CHANNEL_INTVAL_LOAD_MASK)
/*! @} */

/* The count of MRT_CHANNEL_INTVAL */
#define MRT_CHANNEL_INTVAL_COUNT                 (4U)

/*! @name CHANNEL_TIMER - MRT Timer register. This register reads the value of the down-counter. */
/*! @{ */
#define MRT_CHANNEL_TIMER_VALUE_MASK             (0xFFFFFFU)
#define MRT_CHANNEL_TIMER_VALUE_SHIFT            (0U)
/*! VALUE - Holds the current timer value of the down-counter. The initial value of the TIMERn
 *    register is loaded as IVALUE - 1 from the INTVALn register either at the end of the time interval
 *    or immediately in the following cases: INTVALn register is updated in the idle state. INTVALn
 *    register is updated with LOAD = 1. When the timer is in idle state, reading this bit fields
 *    returns -1 (0x00FF FFFF).
 */
#define MRT_CHANNEL_TIMER_VALUE(x)               (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_TIMER_VALUE_SHIFT)) & MRT_CHANNEL_TIMER_VALUE_MASK)
/*! @} */

/* The count of MRT_CHANNEL_TIMER */
#define MRT_CHANNEL_TIMER_COUNT                  (4U)

/*! @name CHANNEL_CTRL - MRT Control register. This register controls the MRT modes. */
/*! @{ */
#define MRT_CHANNEL_CTRL_INTEN_MASK              (0x1U)
#define MRT_CHANNEL_CTRL_INTEN_SHIFT             (0U)
/*! INTEN - Enable the TIMERn interrupt.
 *  0b0..Disabled. TIMERn interrupt is disabled.
 *  0b1..Enabled. TIMERn interrupt is enabled.
 */
#define MRT_CHANNEL_CTRL_INTEN(x)                (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_CTRL_INTEN_SHIFT)) & MRT_CHANNEL_CTRL_INTEN_MASK)
#define MRT_CHANNEL_CTRL_MODE_MASK               (0x6U)
#define MRT_CHANNEL_CTRL_MODE_SHIFT              (1U)
/*! MODE - Selects timer mode.
 *  0b00..Repeat interrupt mode.
 *  0b01..One-shot interrupt mode.
 *  0b10..One-shot stall mode.
 *  0b11..Reserved.
 */
#define MRT_CHANNEL_CTRL_MODE(x)                 (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_CTRL_MODE_SHIFT)) & MRT_CHANNEL_CTRL_MODE_MASK)
/*! @} */

/* The count of MRT_CHANNEL_CTRL */
#define MRT_CHANNEL_CTRL_COUNT                   (4U)

/*! @name CHANNEL_STAT - MRT Status register. */
/*! @{ */
#define MRT_CHANNEL_STAT_INTFLAG_MASK            (0x1U)
#define MRT_CHANNEL_STAT_INTFLAG_SHIFT           (0U)
/*! INTFLAG - Monitors the interrupt flag.
 *  0b0..No pending interrupt. Writing a zero is equivalent to no operation.
 *  0b1..Pending interrupt. The interrupt is pending because TIMERn has reached the end of the time interval. If
 *       the INTEN bit in the CONTROLn is also set to 1, the interrupt for timer channel n and the global interrupt
 *       are raised. Writing a 1 to this bit clears the interrupt request.
 */
#define MRT_CHANNEL_STAT_INTFLAG(x)              (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_STAT_INTFLAG_SHIFT)) & MRT_CHANNEL_STAT_INTFLAG_MASK)
#define MRT_CHANNEL_STAT_RUN_MASK                (0x2U)
#define MRT_CHANNEL_STAT_RUN_SHIFT               (1U)
/*! RUN - Indicates the state of TIMERn. This bit is read-only.
 *  0b0..Idle state. TIMERn is stopped.
 *  0b1..Running. TIMERn is running.
 */
#define MRT_CHANNEL_STAT_RUN(x)                  (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_STAT_RUN_SHIFT)) & MRT_CHANNEL_STAT_RUN_MASK)
#define MRT_CHANNEL_STAT_INUSE_MASK              (0x4U)
#define MRT_CHANNEL_STAT_INUSE_SHIFT             (2U)
/*! INUSE - Channel In Use flag. Operating details depend on the MULTITASK bit in the MODCFG
 *    register, and affects the use of IDLE_CH. See Idle channel register for details of the two operating
 *    modes.
 *  0b0..This channel is not in use.
 *  0b1..This channel is in use.
 */
#define MRT_CHANNEL_STAT_INUSE(x)                (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_STAT_INUSE_SHIFT)) & MRT_CHANNEL_STAT_INUSE_MASK)
/*! @} */

/* The count of MRT_CHANNEL_STAT */
#define MRT_CHANNEL_STAT_COUNT                   (4U)

/*! @name MODCFG - Module Configuration register. This register provides information about this particular MRT instance, and allows choosing an overall mode for the idle channel feature. */
/*! @{ */
#define MRT_MODCFG_NOC_MASK                      (0xFU)
#define MRT_MODCFG_NOC_SHIFT                     (0U)
/*! NOC - Identifies the number of channels in this MRT.(4 channels on this device.)
 */
#define MRT_MODCFG_NOC(x)                        (((uint32_t)(((uint32_t)(x)) << MRT_MODCFG_NOC_SHIFT)) & MRT_MODCFG_NOC_MASK)
#define MRT_MODCFG_NOB_MASK                      (0x1F0U)
#define MRT_MODCFG_NOB_SHIFT                     (4U)
/*! NOB - Identifies the number of timer bits in this MRT. (24 bits wide on this device.)
 */
#define MRT_MODCFG_NOB(x)                        (((uint32_t)(((uint32_t)(x)) << MRT_MODCFG_NOB_SHIFT)) & MRT_MODCFG_NOB_MASK)
#define MRT_MODCFG_MULTITASK_MASK                (0x80000000U)
#define MRT_MODCFG_MULTITASK_SHIFT               (31U)
/*! MULTITASK - Selects the operating mode for the INUSE flags and the IDLE_CH register.
 *  0b0..Hardware status mode. In this mode, the INUSE(n) flags for all channels are reset.
 *  0b1..Multi-task mode.
 */
#define MRT_MODCFG_MULTITASK(x)                  (((uint32_t)(((uint32_t)(x)) << MRT_MODCFG_MULTITASK_SHIFT)) & MRT_MODCFG_MULTITASK_MASK)
/*! @} */

/*! @name IDLE_CH - Idle channel register. This register returns the number of the first idle channel. */
/*! @{ */
#define MRT_IDLE_CH_CHAN_MASK                    (0xF0U)
#define MRT_IDLE_CH_CHAN_SHIFT                   (4U)
/*! CHAN - Idle channel. Reading the CHAN bits, returns the lowest idle timer channel. The number is
 *    positioned such that it can be used as an offset from the MRT base address in order to access
 *    the registers for the allocated channel. If all timer channels are running, CHAN = 0xF. See
 *    text above for more details.
 */
#define MRT_IDLE_CH_CHAN(x)                      (((uint32_t)(((uint32_t)(x)) << MRT_IDLE_CH_CHAN_SHIFT)) & MRT_IDLE_CH_CHAN_MASK)
/*! @} */

/*! @name IRQ_FLAG - Global interrupt flag register */
/*! @{ */
#define MRT_IRQ_FLAG_GFLAG0_MASK                 (0x1U)
#define MRT_IRQ_FLAG_GFLAG0_SHIFT                (0U)
/*! GFLAG0 - Monitors the interrupt flag of TIMER0.
 *  0b0..No pending interrupt. Writing a zero is equivalent to no operation.
 *  0b1..Pending interrupt. The interrupt is pending because TIMER0 has reached the end of the time interval. If
 *       the INTEN bit in the CONTROL0 register is also set to 1, the interrupt for timer channel 0 and the global
 *       interrupt are raised. Writing a 1 to this bit clears the interrupt request.
 */
#define MRT_IRQ_FLAG_GFLAG0(x)                   (((uint32_t)(((uint32_t)(x)) << MRT_IRQ_FLAG_GFLAG0_SHIFT)) & MRT_IRQ_FLAG_GFLAG0_MASK)
#define MRT_IRQ_FLAG_GFLAG1_MASK                 (0x2U)
#define MRT_IRQ_FLAG_GFLAG1_SHIFT                (1U)
/*! GFLAG1 - Monitors the interrupt flag of TIMER1. See description of channel 0.
 */
#define MRT_IRQ_FLAG_GFLAG1(x)                   (((uint32_t)(((uint32_t)(x)) << MRT_IRQ_FLAG_GFLAG1_SHIFT)) & MRT_IRQ_FLAG_GFLAG1_MASK)
#define MRT_IRQ_FLAG_GFLAG2_MASK                 (0x4U)
#define MRT_IRQ_FLAG_GFLAG2_SHIFT                (2U)
/*! GFLAG2 - Monitors the interrupt flag of TIMER2. See description of channel 0.
 */
#define MRT_IRQ_FLAG_GFLAG2(x)                   (((uint32_t)(((uint32_t)(x)) << MRT_IRQ_FLAG_GFLAG2_SHIFT)) & MRT_IRQ_FLAG_GFLAG2_MASK)
#define MRT_IRQ_FLAG_GFLAG3_MASK                 (0x8U)
#define MRT_IRQ_FLAG_GFLAG3_SHIFT                (3U)
/*! GFLAG3 - Monitors the interrupt flag of TIMER3. See description of channel 0.
 */
#define MRT_IRQ_FLAG_GFLAG3(x)                   (((uint32_t)(((uint32_t)(x)) << MRT_IRQ_FLAG_GFLAG3_SHIFT)) & MRT_IRQ_FLAG_GFLAG3_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group MRT_Register_Masks */


/* MRT - Peripheral instance base addresses */
/** Peripheral MRT0 base address */
#define MRT0_BASE                                (0x4000D000u)
/** Peripheral MRT0 base pointer */
#define MRT0                                     ((MRT_Type *)MRT0_BASE)
/** Array initializer of MRT peripheral base addresses */
#define MRT_BASE_ADDRS                           { MRT0_BASE }
/** Array initializer of MRT peripheral base pointers */
#define MRT_BASE_PTRS                            { MRT0 }
/** Interrupt vectors for the MRT peripheral type */
#define MRT_IRQS                                 { MRT0_IRQn }

/*!
 * @}
 */ /* end of group MRT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- OTPC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OTPC_Peripheral_Access_Layer OTPC Peripheral Access Layer
 * @{
 */

/** OTPC - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __I  uint32_t AESKEY[8];                         /**< Register for reading the AES key., array offset: 0x10, array step: 0x4 */
  __I  uint32_t ECRP;                              /**< ECRP options., offset: 0x30 */
       uint8_t RESERVED_1[4];
  __I  uint32_t USER0;                             /**< User application specific options., offset: 0x38 */
  __I  uint32_t USER1;                             /**< User application specific options., offset: 0x3C */
} OTPC_Type;

/* ----------------------------------------------------------------------------
   -- OTPC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OTPC_Register_Masks OTPC Register Masks
 * @{
 */

/*! @name AESKEY - Register for reading the AES key. */
/*! @{ */
#define OTPC_AESKEY_KEY_MASK                     (0xFFFFFFFFU)
#define OTPC_AESKEY_KEY_SHIFT                    (0U)
/*! KEY - AES key.
 */
#define OTPC_AESKEY_KEY(x)                       (((uint32_t)(((uint32_t)(x)) << OTPC_AESKEY_KEY_SHIFT)) & OTPC_AESKEY_KEY_MASK)
/*! @} */

/* The count of OTPC_AESKEY */
#define OTPC_AESKEY_COUNT                        (8U)

/*! @name ECRP - ECRP options. */
/*! @{ */
#define OTPC_ECRP_CRP_MASS_ERASE_DISABLE_MASK    (0x10U)
#define OTPC_ECRP_CRP_MASS_ERASE_DISABLE_SHIFT   (4U)
/*! CRP_MASS_ERASE_DISABLE - Disable or enable CRP mass erase.
 */
#define OTPC_ECRP_CRP_MASS_ERASE_DISABLE(x)      (((uint32_t)(((uint32_t)(x)) << OTPC_ECRP_CRP_MASS_ERASE_DISABLE_SHIFT)) & OTPC_ECRP_CRP_MASS_ERASE_DISABLE_MASK)
#define OTPC_ECRP_IAP_PROTECTION_ENABLE_MASK     (0x20U)
#define OTPC_ECRP_IAP_PROTECTION_ENABLE_SHIFT    (5U)
/*! IAP_PROTECTION_ENABLE - This bit controls the ability to enable checking for ECRP in IAP functions.
 */
#define OTPC_ECRP_IAP_PROTECTION_ENABLE(x)       (((uint32_t)(((uint32_t)(x)) << OTPC_ECRP_IAP_PROTECTION_ENABLE_SHIFT)) & OTPC_ECRP_IAP_PROTECTION_ENABLE_MASK)
#define OTPC_ECRP_CRP_ISP_DISABLE_PIN_MASK       (0x40U)
#define OTPC_ECRP_CRP_ISP_DISABLE_PIN_SHIFT      (6U)
/*! CRP_ISP_DISABLE_PIN - This bit controls the ability to enter ISP mode using the ISP pin.
 */
#define OTPC_ECRP_CRP_ISP_DISABLE_PIN(x)         (((uint32_t)(((uint32_t)(x)) << OTPC_ECRP_CRP_ISP_DISABLE_PIN_SHIFT)) & OTPC_ECRP_CRP_ISP_DISABLE_PIN_MASK)
#define OTPC_ECRP_CRP_ISP_DISABLE_IAP_MASK       (0x80U)
#define OTPC_ECRP_CRP_ISP_DISABLE_IAP_SHIFT      (7U)
/*! CRP_ISP_DISABLE_IAP - This bit controls the ability to re-invoke ISP using IAP routines.
 */
#define OTPC_ECRP_CRP_ISP_DISABLE_IAP(x)         (((uint32_t)(((uint32_t)(x)) << OTPC_ECRP_CRP_ISP_DISABLE_IAP_SHIFT)) & OTPC_ECRP_CRP_ISP_DISABLE_IAP_MASK)
#define OTPC_ECRP_CRP_ALLOW_ZERO_MASK            (0x200U)
#define OTPC_ECRP_CRP_ALLOW_ZERO_SHIFT           (9U)
/*! CRP_ALLOW_ZERO - This bit controls how 0 is treated when read as a ECRP value..
 */
#define OTPC_ECRP_CRP_ALLOW_ZERO(x)              (((uint32_t)(((uint32_t)(x)) << OTPC_ECRP_CRP_ALLOW_ZERO_SHIFT)) & OTPC_ECRP_CRP_ALLOW_ZERO_MASK)
#define OTPC_ECRP_JTAG_DISABLE_MASK              (0x80000000U)
#define OTPC_ECRP_JTAG_DISABLE_SHIFT             (31U)
/*! JTAG_DISABLE - 0 => Enable SWD/JTAG; 1 => Disable SWD/JTAG..
 */
#define OTPC_ECRP_JTAG_DISABLE(x)                (((uint32_t)(((uint32_t)(x)) << OTPC_ECRP_JTAG_DISABLE_SHIFT)) & OTPC_ECRP_JTAG_DISABLE_MASK)
/*! @} */

/*! @name USER0 - User application specific options. */
/*! @{ */
#define OTPC_USER0_USER0_MASK                    (0xFFFFFFFFU)
#define OTPC_USER0_USER0_SHIFT                   (0U)
/*! USER0 - User application specific option.
 */
#define OTPC_USER0_USER0(x)                      (((uint32_t)(((uint32_t)(x)) << OTPC_USER0_USER0_SHIFT)) & OTPC_USER0_USER0_MASK)
/*! @} */

/*! @name USER1 - User application specific options. */
/*! @{ */
#define OTPC_USER1_USER1_MASK                    (0xFFFFFFFFU)
#define OTPC_USER1_USER1_SHIFT                   (0U)
/*! USER1 - User application specific option.
 */
#define OTPC_USER1_USER1(x)                      (((uint32_t)(((uint32_t)(x)) << OTPC_USER1_USER1_SHIFT)) & OTPC_USER1_USER1_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group OTPC_Register_Masks */


/* OTPC - Peripheral instance base addresses */
/** Peripheral OTPC base address */
#define OTPC_BASE                                (0x40015000u)
/** Peripheral OTPC base pointer */
#define OTPC                                     ((OTPC_Type *)OTPC_BASE)
/** Array initializer of OTPC peripheral base addresses */
#define OTPC_BASE_ADDRS                          { OTPC_BASE }
/** Array initializer of OTPC peripheral base pointers */
#define OTPC_BASE_PTRS                           { OTPC }

/*!
 * @}
 */ /* end of group OTPC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PINT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PINT_Peripheral_Access_Layer PINT Peripheral Access Layer
 * @{
 */

/** PINT - Register Layout Typedef */
typedef struct {
  __IO uint32_t ISEL;                              /**< Pin Interrupt Mode register, offset: 0x0 */
  __IO uint32_t IENR;                              /**< Pin interrupt level or rising edge interrupt enable register, offset: 0x4 */
  __O  uint32_t SIENR;                             /**< Pin interrupt level or rising edge interrupt set register, offset: 0x8 */
  __O  uint32_t CIENR;                             /**< Pin interrupt level (rising edge interrupt) clear register, offset: 0xC */
  __IO uint32_t IENF;                              /**< Pin interrupt active level or falling edge interrupt enable register, offset: 0x10 */
  __O  uint32_t SIENF;                             /**< Pin interrupt active level or falling edge interrupt set register, offset: 0x14 */
  __O  uint32_t CIENF;                             /**< Pin interrupt active level or falling edge interrupt clear register, offset: 0x18 */
  __IO uint32_t RISE;                              /**< Pin interrupt rising edge register, offset: 0x1C */
  __IO uint32_t FALL;                              /**< Pin interrupt falling edge register, offset: 0x20 */
  __IO uint32_t IST;                               /**< Pin interrupt status register, offset: 0x24 */
  __IO uint32_t PMCTRL;                            /**< Pattern match interrupt control register, offset: 0x28 */
  __IO uint32_t PMSRC;                             /**< Pattern match interrupt bit-slice source register, offset: 0x2C */
  __IO uint32_t PMCFG;                             /**< Pattern match interrupt bit slice configuration register, offset: 0x30 */
} PINT_Type;

/* ----------------------------------------------------------------------------
   -- PINT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PINT_Register_Masks PINT Register Masks
 * @{
 */

/*! @name ISEL - Pin Interrupt Mode register */
/*! @{ */
#define PINT_ISEL_PMODE_MASK                     (0xFFU)
#define PINT_ISEL_PMODE_SHIFT                    (0U)
/*! PMODE - Selects the interrupt mode for each pin interrupt. Bit n configures the pin interrupt
 *    selected in PINTSELn. 0 = Edge sensitive 1 = Level sensitive
 */
#define PINT_ISEL_PMODE(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_ISEL_PMODE_SHIFT)) & PINT_ISEL_PMODE_MASK)
/*! @} */

/*! @name IENR - Pin interrupt level or rising edge interrupt enable register */
/*! @{ */
#define PINT_IENR_ENRL_MASK                      (0xFFU)
#define PINT_IENR_ENRL_SHIFT                     (0U)
/*! ENRL - Enables the rising edge or level interrupt for each pin interrupt. Bit n configures the
 *    pin interrupt selected in PINTSELn. 0 = Disable rising edge or level interrupt. 1 = Enable
 *    rising edge or level interrupt.
 */
#define PINT_IENR_ENRL(x)                        (((uint32_t)(((uint32_t)(x)) << PINT_IENR_ENRL_SHIFT)) & PINT_IENR_ENRL_MASK)
/*! @} */

/*! @name SIENR - Pin interrupt level or rising edge interrupt set register */
/*! @{ */
#define PINT_SIENR_SETENRL_MASK                  (0xFFU)
#define PINT_SIENR_SETENRL_SHIFT                 (0U)
/*! SETENRL - Ones written to this address set bits in the IENR, thus enabling interrupts. Bit n
 *    sets bit n in the IENR register. 0 = No operation. 1 = Enable rising edge or level interrupt.
 */
#define PINT_SIENR_SETENRL(x)                    (((uint32_t)(((uint32_t)(x)) << PINT_SIENR_SETENRL_SHIFT)) & PINT_SIENR_SETENRL_MASK)
/*! @} */

/*! @name CIENR - Pin interrupt level (rising edge interrupt) clear register */
/*! @{ */
#define PINT_CIENR_CENRL_MASK                    (0xFFU)
#define PINT_CIENR_CENRL_SHIFT                   (0U)
/*! CENRL - Ones written to this address clear bits in the IENR, thus disabling the interrupts. Bit
 *    n clears bit n in the IENR register. 0 = No operation. 1 = Disable rising edge or level
 *    interrupt.
 */
#define PINT_CIENR_CENRL(x)                      (((uint32_t)(((uint32_t)(x)) << PINT_CIENR_CENRL_SHIFT)) & PINT_CIENR_CENRL_MASK)
/*! @} */

/*! @name IENF - Pin interrupt active level or falling edge interrupt enable register */
/*! @{ */
#define PINT_IENF_ENAF_MASK                      (0xFFU)
#define PINT_IENF_ENAF_SHIFT                     (0U)
/*! ENAF - Enables the falling edge or configures the active level interrupt for each pin interrupt.
 *    Bit n configures the pin interrupt selected in PINTSELn. 0 = Disable falling edge interrupt
 *    or set active interrupt level LOW. 1 = Enable falling edge interrupt enabled or set active
 *    interrupt level HIGH.
 */
#define PINT_IENF_ENAF(x)                        (((uint32_t)(((uint32_t)(x)) << PINT_IENF_ENAF_SHIFT)) & PINT_IENF_ENAF_MASK)
/*! @} */

/*! @name SIENF - Pin interrupt active level or falling edge interrupt set register */
/*! @{ */
#define PINT_SIENF_SETENAF_MASK                  (0xFFU)
#define PINT_SIENF_SETENAF_SHIFT                 (0U)
/*! SETENAF - Ones written to this address set bits in the IENF, thus enabling interrupts. Bit n
 *    sets bit n in the IENF register. 0 = No operation. 1 = Select HIGH-active interrupt or enable
 *    falling edge interrupt.
 */
#define PINT_SIENF_SETENAF(x)                    (((uint32_t)(((uint32_t)(x)) << PINT_SIENF_SETENAF_SHIFT)) & PINT_SIENF_SETENAF_MASK)
/*! @} */

/*! @name CIENF - Pin interrupt active level or falling edge interrupt clear register */
/*! @{ */
#define PINT_CIENF_CENAF_MASK                    (0xFFU)
#define PINT_CIENF_CENAF_SHIFT                   (0U)
/*! CENAF - Ones written to this address clears bits in the IENF, thus disabling interrupts. Bit n
 *    clears bit n in the IENF register. 0 = No operation. 1 = LOW-active interrupt selected or
 *    falling edge interrupt disabled.
 */
#define PINT_CIENF_CENAF(x)                      (((uint32_t)(((uint32_t)(x)) << PINT_CIENF_CENAF_SHIFT)) & PINT_CIENF_CENAF_MASK)
/*! @} */

/*! @name RISE - Pin interrupt rising edge register */
/*! @{ */
#define PINT_RISE_RDET_MASK                      (0xFFU)
#define PINT_RISE_RDET_SHIFT                     (0U)
/*! RDET - Rising edge detect. Bit n detects the rising edge of the pin selected in PINTSELn. Read
 *    0: No rising edge has been detected on this pin since Reset or the last time a one was written
 *    to this bit. Write 0: no operation. Read 1: a rising edge has been detected since Reset or the
 *    last time a one was written to this bit. Write 1: clear rising edge detection for this pin.
 */
#define PINT_RISE_RDET(x)                        (((uint32_t)(((uint32_t)(x)) << PINT_RISE_RDET_SHIFT)) & PINT_RISE_RDET_MASK)
/*! @} */

/*! @name FALL - Pin interrupt falling edge register */
/*! @{ */
#define PINT_FALL_FDET_MASK                      (0xFFU)
#define PINT_FALL_FDET_SHIFT                     (0U)
/*! FDET - Falling edge detect. Bit n detects the falling edge of the pin selected in PINTSELn. Read
 *    0: No falling edge has been detected on this pin since Reset or the last time a one was
 *    written to this bit. Write 0: no operation. Read 1: a falling edge has been detected since Reset or
 *    the last time a one was written to this bit. Write 1: clear falling edge detection for this
 *    pin.
 */
#define PINT_FALL_FDET(x)                        (((uint32_t)(((uint32_t)(x)) << PINT_FALL_FDET_SHIFT)) & PINT_FALL_FDET_MASK)
/*! @} */

/*! @name IST - Pin interrupt status register */
/*! @{ */
#define PINT_IST_PSTAT_MASK                      (0xFFU)
#define PINT_IST_PSTAT_SHIFT                     (0U)
/*! PSTAT - Pin interrupt status. Bit n returns the status, clears the edge interrupt, or inverts
 *    the active level of the pin selected in PINTSELn. Read 0: interrupt is not being requested for
 *    this interrupt pin. Write 0: no operation. Read 1: interrupt is being requested for this
 *    interrupt pin. Write 1 (edge-sensitive): clear rising- and falling-edge detection for this pin.
 *    Write 1 (level-sensitive): switch the active level for this pin (in the IENF register).
 */
#define PINT_IST_PSTAT(x)                        (((uint32_t)(((uint32_t)(x)) << PINT_IST_PSTAT_SHIFT)) & PINT_IST_PSTAT_MASK)
/*! @} */

/*! @name PMCTRL - Pattern match interrupt control register */
/*! @{ */
#define PINT_PMCTRL_SEL_PMATCH_MASK              (0x1U)
#define PINT_PMCTRL_SEL_PMATCH_SHIFT             (0U)
/*! SEL_PMATCH - Specifies whether the 8 pin interrupts are controlled by the pin interrupt function or by the pattern match function.
 *  0b0..Pin interrupt. Interrupts are driven in response to the standard pin interrupt function.
 *  0b1..Pattern match. Interrupts are driven in response to pattern matches.
 */
#define PINT_PMCTRL_SEL_PMATCH(x)                (((uint32_t)(((uint32_t)(x)) << PINT_PMCTRL_SEL_PMATCH_SHIFT)) & PINT_PMCTRL_SEL_PMATCH_MASK)
#define PINT_PMCTRL_ENA_RXEV_MASK                (0x2U)
#define PINT_PMCTRL_ENA_RXEV_SHIFT               (1U)
/*! ENA_RXEV - Enables the RXEV output to the CPU and/or to a GPIO output when the specified boolean expression evaluates to true.
 *  0b0..Disabled. RXEV output to the CPU is disabled.
 *  0b1..Enabled. RXEV output to the CPU is enabled.
 */
#define PINT_PMCTRL_ENA_RXEV(x)                  (((uint32_t)(((uint32_t)(x)) << PINT_PMCTRL_ENA_RXEV_SHIFT)) & PINT_PMCTRL_ENA_RXEV_MASK)
#define PINT_PMCTRL_PMAT_MASK                    (0xFF000000U)
#define PINT_PMCTRL_PMAT_SHIFT                   (24U)
/*! PMAT - This field displays the current state of pattern matches. A 1 in any bit of this field
 *    indicates that the corresponding product term is matched by the current state of the appropriate
 *    inputs.
 */
#define PINT_PMCTRL_PMAT(x)                      (((uint32_t)(((uint32_t)(x)) << PINT_PMCTRL_PMAT_SHIFT)) & PINT_PMCTRL_PMAT_MASK)
/*! @} */

/*! @name PMSRC - Pattern match interrupt bit-slice source register */
/*! @{ */
#define PINT_PMSRC_SRC0_MASK                     (0x700U)
#define PINT_PMSRC_SRC0_SHIFT                    (8U)
/*! SRC0 - Selects the input source for bit slice 0
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 0.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 0.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 0.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 0.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 0.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 0.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 0.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 0.
 */
#define PINT_PMSRC_SRC0(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC0_SHIFT)) & PINT_PMSRC_SRC0_MASK)
#define PINT_PMSRC_SRC1_MASK                     (0x3800U)
#define PINT_PMSRC_SRC1_SHIFT                    (11U)
/*! SRC1 - Selects the input source for bit slice 1
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 1.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 1.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 1.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 1.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 1.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 1.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 1.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 1.
 */
#define PINT_PMSRC_SRC1(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC1_SHIFT)) & PINT_PMSRC_SRC1_MASK)
#define PINT_PMSRC_SRC2_MASK                     (0x1C000U)
#define PINT_PMSRC_SRC2_SHIFT                    (14U)
/*! SRC2 - Selects the input source for bit slice 2
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 2.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 2.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 2.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 2.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 2.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 2.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 2.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 2.
 */
#define PINT_PMSRC_SRC2(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC2_SHIFT)) & PINT_PMSRC_SRC2_MASK)
#define PINT_PMSRC_SRC3_MASK                     (0xE0000U)
#define PINT_PMSRC_SRC3_SHIFT                    (17U)
/*! SRC3 - Selects the input source for bit slice 3
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 3.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 3.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 3.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 3.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 3.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 3.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 3.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 3.
 */
#define PINT_PMSRC_SRC3(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC3_SHIFT)) & PINT_PMSRC_SRC3_MASK)
#define PINT_PMSRC_SRC4_MASK                     (0x700000U)
#define PINT_PMSRC_SRC4_SHIFT                    (20U)
/*! SRC4 - Selects the input source for bit slice 4
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 4.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 4.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 4.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 4.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 4.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 4.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 4.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 4.
 */
#define PINT_PMSRC_SRC4(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC4_SHIFT)) & PINT_PMSRC_SRC4_MASK)
#define PINT_PMSRC_SRC5_MASK                     (0x3800000U)
#define PINT_PMSRC_SRC5_SHIFT                    (23U)
/*! SRC5 - Selects the input source for bit slice 5
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 5.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 5.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 5.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 5.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 5.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 5.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 5.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 5.
 */
#define PINT_PMSRC_SRC5(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC5_SHIFT)) & PINT_PMSRC_SRC5_MASK)
#define PINT_PMSRC_SRC6_MASK                     (0x1C000000U)
#define PINT_PMSRC_SRC6_SHIFT                    (26U)
/*! SRC6 - Selects the input source for bit slice 6
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 6.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 6.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 6.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 6.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 6.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 6.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 6.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 6.
 */
#define PINT_PMSRC_SRC6(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC6_SHIFT)) & PINT_PMSRC_SRC6_MASK)
#define PINT_PMSRC_SRC7_MASK                     (0xE0000000U)
#define PINT_PMSRC_SRC7_SHIFT                    (29U)
/*! SRC7 - Selects the input source for bit slice 7
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 7.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 7.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 7.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 7.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 7.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 7.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 7.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 7.
 */
#define PINT_PMSRC_SRC7(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC7_SHIFT)) & PINT_PMSRC_SRC7_MASK)
/*! @} */

/*! @name PMCFG - Pattern match interrupt bit slice configuration register */
/*! @{ */
#define PINT_PMCFG_PROD_ENDPTS0_MASK             (0x1U)
#define PINT_PMCFG_PROD_ENDPTS0_SHIFT            (0U)
/*! PROD_ENDPTS0 - Determines whether slice 0 is an endpoint.
 *  0b0..No effect. Slice 0 is not an endpoint.
 *  0b1..endpoint. Slice 0 is the endpoint of a product term (minterm). Pin interrupt 0 in the NVIC is raised if the minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS0(x)               (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS0_SHIFT)) & PINT_PMCFG_PROD_ENDPTS0_MASK)
#define PINT_PMCFG_PROD_ENDPTS1_MASK             (0x2U)
#define PINT_PMCFG_PROD_ENDPTS1_SHIFT            (1U)
/*! PROD_ENDPTS1 - Determines whether slice 1 is an endpoint.
 *  0b0..No effect. Slice 1 is not an endpoint.
 *  0b1..endpoint. Slice 1 is the endpoint of a product term (minterm). Pin interrupt 1 in the NVIC is raised if the minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS1(x)               (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS1_SHIFT)) & PINT_PMCFG_PROD_ENDPTS1_MASK)
#define PINT_PMCFG_PROD_ENDPTS2_MASK             (0x4U)
#define PINT_PMCFG_PROD_ENDPTS2_SHIFT            (2U)
/*! PROD_ENDPTS2 - Determines whether slice 2 is an endpoint.
 *  0b0..No effect. Slice 2 is not an endpoint.
 *  0b1..endpoint. Slice 2 is the endpoint of a product term (minterm). Pin interrupt 2 in the NVIC is raised if the minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS2(x)               (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS2_SHIFT)) & PINT_PMCFG_PROD_ENDPTS2_MASK)
#define PINT_PMCFG_PROD_ENDPTS3_MASK             (0x8U)
#define PINT_PMCFG_PROD_ENDPTS3_SHIFT            (3U)
/*! PROD_ENDPTS3 - Determines whether slice 3 is an endpoint.
 *  0b0..No effect. Slice 3 is not an endpoint.
 *  0b1..endpoint. Slice 3 is the endpoint of a product term (minterm). Pin interrupt 3 in the NVIC is raised if the minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS3(x)               (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS3_SHIFT)) & PINT_PMCFG_PROD_ENDPTS3_MASK)
#define PINT_PMCFG_PROD_ENDPTS4_MASK             (0x10U)
#define PINT_PMCFG_PROD_ENDPTS4_SHIFT            (4U)
/*! PROD_ENDPTS4 - Determines whether slice 4 is an endpoint.
 *  0b0..No effect. Slice 4 is not an endpoint.
 *  0b1..endpoint. Slice 4 is the endpoint of a product term (minterm). Pin interrupt 4 in the NVIC is raised if the minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS4(x)               (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS4_SHIFT)) & PINT_PMCFG_PROD_ENDPTS4_MASK)
#define PINT_PMCFG_PROD_ENDPTS5_MASK             (0x20U)
#define PINT_PMCFG_PROD_ENDPTS5_SHIFT            (5U)
/*! PROD_ENDPTS5 - Determines whether slice 5 is an endpoint.
 *  0b0..No effect. Slice 5 is not an endpoint.
 *  0b1..endpoint. Slice 5 is the endpoint of a product term (minterm). Pin interrupt 5 in the NVIC is raised if the minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS5(x)               (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS5_SHIFT)) & PINT_PMCFG_PROD_ENDPTS5_MASK)
#define PINT_PMCFG_PROD_ENDPTS6_MASK             (0x40U)
#define PINT_PMCFG_PROD_ENDPTS6_SHIFT            (6U)
/*! PROD_ENDPTS6 - Determines whether slice 6 is an endpoint.
 *  0b0..No effect. Slice 6 is not an endpoint.
 *  0b1..endpoint. Slice 6 is the endpoint of a product term (minterm). Pin interrupt 6 in the NVIC is raised if the minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS6(x)               (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS6_SHIFT)) & PINT_PMCFG_PROD_ENDPTS6_MASK)
#define PINT_PMCFG_CFG0_MASK                     (0x700U)
#define PINT_PMCFG_CFG0_SHIFT                    (8U)
/*! CFG0 - Specifies the match contribution condition for bit slice 0.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG0(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG0_SHIFT)) & PINT_PMCFG_CFG0_MASK)
#define PINT_PMCFG_CFG1_MASK                     (0x3800U)
#define PINT_PMCFG_CFG1_SHIFT                    (11U)
/*! CFG1 - Specifies the match contribution condition for bit slice 1.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG1(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG1_SHIFT)) & PINT_PMCFG_CFG1_MASK)
#define PINT_PMCFG_CFG2_MASK                     (0x1C000U)
#define PINT_PMCFG_CFG2_SHIFT                    (14U)
/*! CFG2 - Specifies the match contribution condition for bit slice 2.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG2(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG2_SHIFT)) & PINT_PMCFG_CFG2_MASK)
#define PINT_PMCFG_CFG3_MASK                     (0xE0000U)
#define PINT_PMCFG_CFG3_SHIFT                    (17U)
/*! CFG3 - Specifies the match contribution condition for bit slice 3.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG3(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG3_SHIFT)) & PINT_PMCFG_CFG3_MASK)
#define PINT_PMCFG_CFG4_MASK                     (0x700000U)
#define PINT_PMCFG_CFG4_SHIFT                    (20U)
/*! CFG4 - Specifies the match contribution condition for bit slice 4.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG4(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG4_SHIFT)) & PINT_PMCFG_CFG4_MASK)
#define PINT_PMCFG_CFG5_MASK                     (0x3800000U)
#define PINT_PMCFG_CFG5_SHIFT                    (23U)
/*! CFG5 - Specifies the match contribution condition for bit slice 5.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG5(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG5_SHIFT)) & PINT_PMCFG_CFG5_MASK)
#define PINT_PMCFG_CFG6_MASK                     (0x1C000000U)
#define PINT_PMCFG_CFG6_SHIFT                    (26U)
/*! CFG6 - Specifies the match contribution condition for bit slice 6.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG6(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG6_SHIFT)) & PINT_PMCFG_CFG6_MASK)
#define PINT_PMCFG_CFG7_MASK                     (0xE0000000U)
#define PINT_PMCFG_CFG7_SHIFT                    (29U)
/*! CFG7 - Specifies the match contribution condition for bit slice 7.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG7(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG7_SHIFT)) & PINT_PMCFG_CFG7_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group PINT_Register_Masks */


/* PINT - Peripheral instance base addresses */
/** Peripheral PINT base address */
#define PINT_BASE                                (0x40004000u)
/** Peripheral PINT base pointer */
#define PINT                                     ((PINT_Type *)PINT_BASE)
/** Array initializer of PINT peripheral base addresses */
#define PINT_BASE_ADDRS                          { PINT_BASE }
/** Array initializer of PINT peripheral base pointers */
#define PINT_BASE_PTRS                           { PINT }
/** Interrupt vectors for the PINT peripheral type */
#define PINT_IRQS                                { PIN_INT0_IRQn, PIN_INT1_IRQn, PIN_INT2_IRQn, PIN_INT3_IRQn, PIN_INT4_IRQn, PIN_INT5_IRQn, PIN_INT6_IRQn, PIN_INT7_IRQn }

/*!
 * @}
 */ /* end of group PINT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PUF Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PUF_Peripheral_Access_Layer PUF Peripheral Access Layer
 * @{
 */

/** PUF - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< PUF Control register, offset: 0x0 */
  __IO uint32_t KEYINDEX;                          /**< PUF Key Index register, offset: 0x4 */
  __IO uint32_t KEYSIZE;                           /**< PUF Key Size register, offset: 0x8 */
       uint8_t RESERVED_0[20];
  __I  uint32_t STAT;                              /**< PUF Status register, offset: 0x20 */
       uint8_t RESERVED_1[4];
  __I  uint32_t ALLOW;                             /**< PUF Allow register, offset: 0x28 */
       uint8_t RESERVED_2[20];
  __O  uint32_t KEYINPUT;                          /**< PUF Key Input register, offset: 0x40 */
  __O  uint32_t CODEINPUT;                         /**< PUF Code Input register, offset: 0x44 */
  __I  uint32_t CODEOUTPUT;                        /**< PUF Code Output register, offset: 0x48 */
       uint8_t RESERVED_3[20];
  __I  uint32_t KEYOUTINDEX;                       /**< PUF Key Output Index register, offset: 0x60 */
  __I  uint32_t KEYOUTPUT;                         /**< PUF Key Output register, offset: 0x64 */
       uint8_t RESERVED_4[116];
  __IO uint32_t IFSTAT;                            /**< PUF Interface Status and clear register, offset: 0xDC */
       uint8_t RESERVED_5[32];
  __IO uint32_t INTEN;                             /**< PUF Interrupt Enable, offset: 0x100 */
  __IO uint32_t INTSTAT;                           /**< PUF interrupt status, offset: 0x104 */
  __IO uint32_t PWRCTRL;                           /**< PUF RAM Power Control, offset: 0x108 */
  __IO uint32_t CFG;                               /**< PUF config register for block bits, offset: 0x10C */
} PUF_Type;

/* ----------------------------------------------------------------------------
   -- PUF Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PUF_Register_Masks PUF Register Masks
 * @{
 */

/*! @name CTRL - PUF Control register */
/*! @{ */
#define PUF_CTRL_ZEROIZE_MASK                    (0x1U)
#define PUF_CTRL_ZEROIZE_SHIFT                   (0U)
/*! zeroize - Begin Zeroize operation for Quiddikey and go to Error state
 */
#define PUF_CTRL_ZEROIZE(x)                      (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_ZEROIZE_SHIFT)) & PUF_CTRL_ZEROIZE_MASK)
#define PUF_CTRL_ENROLL_MASK                     (0x2U)
#define PUF_CTRL_ENROLL_SHIFT                    (1U)
/*! enroll - Begin Enroll operation
 */
#define PUF_CTRL_ENROLL(x)                       (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_ENROLL_SHIFT)) & PUF_CTRL_ENROLL_MASK)
#define PUF_CTRL_START_MASK                      (0x4U)
#define PUF_CTRL_START_SHIFT                     (2U)
/*! start - Begin Start operation
 */
#define PUF_CTRL_START(x)                        (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_START_SHIFT)) & PUF_CTRL_START_MASK)
#define PUF_CTRL_GENERATEKEY_MASK                (0x8U)
#define PUF_CTRL_GENERATEKEY_SHIFT               (3U)
/*! GENERATEKEY - Begin Set Intrinsic Key operation
 */
#define PUF_CTRL_GENERATEKEY(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_GENERATEKEY_SHIFT)) & PUF_CTRL_GENERATEKEY_MASK)
#define PUF_CTRL_SETKEY_MASK                     (0x10U)
#define PUF_CTRL_SETKEY_SHIFT                    (4U)
/*! SETKEY - Begin Set User Key operation
 */
#define PUF_CTRL_SETKEY(x)                       (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_SETKEY_SHIFT)) & PUF_CTRL_SETKEY_MASK)
#define PUF_CTRL_GETKEY_MASK                     (0x40U)
#define PUF_CTRL_GETKEY_SHIFT                    (6U)
/*! GETKEY - Begin Get Key operation
 */
#define PUF_CTRL_GETKEY(x)                       (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_GETKEY_SHIFT)) & PUF_CTRL_GETKEY_MASK)
/*! @} */

/*! @name KEYINDEX - PUF Key Index register */
/*! @{ */
#define PUF_KEYINDEX_KEYIDX_MASK                 (0xFU)
#define PUF_KEYINDEX_KEYIDX_SHIFT                (0U)
/*! KEYIDX - Key index for Set Key operations
 */
#define PUF_KEYINDEX_KEYIDX(x)                   (((uint32_t)(((uint32_t)(x)) << PUF_KEYINDEX_KEYIDX_SHIFT)) & PUF_KEYINDEX_KEYIDX_MASK)
/*! @} */

/*! @name KEYSIZE - PUF Key Size register */
/*! @{ */
#define PUF_KEYSIZE_KEYSIZE_MASK                 (0x3FU)
#define PUF_KEYSIZE_KEYSIZE_SHIFT                (0U)
/*! KEYSIZE - Key size for Set Key operations
 */
#define PUF_KEYSIZE_KEYSIZE(x)                   (((uint32_t)(((uint32_t)(x)) << PUF_KEYSIZE_KEYSIZE_SHIFT)) & PUF_KEYSIZE_KEYSIZE_MASK)
/*! @} */

/*! @name STAT - PUF Status register */
/*! @{ */
#define PUF_STAT_BUSY_MASK                       (0x1U)
#define PUF_STAT_BUSY_SHIFT                      (0U)
/*! busy - Indicates that operation is in progress
 */
#define PUF_STAT_BUSY(x)                         (((uint32_t)(((uint32_t)(x)) << PUF_STAT_BUSY_SHIFT)) & PUF_STAT_BUSY_MASK)
#define PUF_STAT_SUCCESS_MASK                    (0x2U)
#define PUF_STAT_SUCCESS_SHIFT                   (1U)
/*! SUCCESS - Last operation was successful
 */
#define PUF_STAT_SUCCESS(x)                      (((uint32_t)(((uint32_t)(x)) << PUF_STAT_SUCCESS_SHIFT)) & PUF_STAT_SUCCESS_MASK)
#define PUF_STAT_ERROR_MASK                      (0x4U)
#define PUF_STAT_ERROR_SHIFT                     (2U)
/*! error - Quiddikey is in the Error state and no operations can be performed
 */
#define PUF_STAT_ERROR(x)                        (((uint32_t)(((uint32_t)(x)) << PUF_STAT_ERROR_SHIFT)) & PUF_STAT_ERROR_MASK)
#define PUF_STAT_KEYINREQ_MASK                   (0x10U)
#define PUF_STAT_KEYINREQ_SHIFT                  (4U)
/*! KEYINREQ - Request for next part of key
 */
#define PUF_STAT_KEYINREQ(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_STAT_KEYINREQ_SHIFT)) & PUF_STAT_KEYINREQ_MASK)
#define PUF_STAT_KEYOUTAVAIL_MASK                (0x20U)
#define PUF_STAT_KEYOUTAVAIL_SHIFT               (5U)
/*! KEYOUTAVAIL - Next part of key is available
 */
#define PUF_STAT_KEYOUTAVAIL(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_STAT_KEYOUTAVAIL_SHIFT)) & PUF_STAT_KEYOUTAVAIL_MASK)
#define PUF_STAT_CODEINREQ_MASK                  (0x40U)
#define PUF_STAT_CODEINREQ_SHIFT                 (6U)
/*! CODEINREQ - Request for next part of AC/KC
 */
#define PUF_STAT_CODEINREQ(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_STAT_CODEINREQ_SHIFT)) & PUF_STAT_CODEINREQ_MASK)
#define PUF_STAT_CODEOUTAVAIL_MASK               (0x80U)
#define PUF_STAT_CODEOUTAVAIL_SHIFT              (7U)
/*! CODEOUTAVAIL - Next part of AC/KC is available
 */
#define PUF_STAT_CODEOUTAVAIL(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_STAT_CODEOUTAVAIL_SHIFT)) & PUF_STAT_CODEOUTAVAIL_MASK)
/*! @} */

/*! @name ALLOW - PUF Allow register */
/*! @{ */
#define PUF_ALLOW_ALLOWENROLL_MASK               (0x1U)
#define PUF_ALLOW_ALLOWENROLL_SHIFT              (0U)
/*! ALLOWENROLL - Enroll operation is allowed
 */
#define PUF_ALLOW_ALLOWENROLL(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_ALLOW_ALLOWENROLL_SHIFT)) & PUF_ALLOW_ALLOWENROLL_MASK)
#define PUF_ALLOW_ALLOWSTART_MASK                (0x2U)
#define PUF_ALLOW_ALLOWSTART_SHIFT               (1U)
/*! ALLOWSTART - Start operation is allowed
 */
#define PUF_ALLOW_ALLOWSTART(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_ALLOW_ALLOWSTART_SHIFT)) & PUF_ALLOW_ALLOWSTART_MASK)
#define PUF_ALLOW_ALLOWSETKEY_MASK               (0x4U)
#define PUF_ALLOW_ALLOWSETKEY_SHIFT              (2U)
/*! ALLOWSETKEY - Set Key operations are allowed
 */
#define PUF_ALLOW_ALLOWSETKEY(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_ALLOW_ALLOWSETKEY_SHIFT)) & PUF_ALLOW_ALLOWSETKEY_MASK)
#define PUF_ALLOW_ALLOWGETKEY_MASK               (0x8U)
#define PUF_ALLOW_ALLOWGETKEY_SHIFT              (3U)
/*! ALLOWGETKEY - Get Key operation is allowed
 */
#define PUF_ALLOW_ALLOWGETKEY(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_ALLOW_ALLOWGETKEY_SHIFT)) & PUF_ALLOW_ALLOWGETKEY_MASK)
/*! @} */

/*! @name KEYINPUT - PUF Key Input register */
/*! @{ */
#define PUF_KEYINPUT_KEYIN_MASK                  (0xFFFFFFFFU)
#define PUF_KEYINPUT_KEYIN_SHIFT                 (0U)
/*! KEYIN - Key input data
 */
#define PUF_KEYINPUT_KEYIN(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_KEYINPUT_KEYIN_SHIFT)) & PUF_KEYINPUT_KEYIN_MASK)
/*! @} */

/*! @name CODEINPUT - PUF Code Input register */
/*! @{ */
#define PUF_CODEINPUT_CODEIN_MASK                (0xFFFFFFFFU)
#define PUF_CODEINPUT_CODEIN_SHIFT               (0U)
/*! CODEIN - AC/KC input data
 */
#define PUF_CODEINPUT_CODEIN(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_CODEINPUT_CODEIN_SHIFT)) & PUF_CODEINPUT_CODEIN_MASK)
/*! @} */

/*! @name CODEOUTPUT - PUF Code Output register */
/*! @{ */
#define PUF_CODEOUTPUT_CODEOUT_MASK              (0xFFFFFFFFU)
#define PUF_CODEOUTPUT_CODEOUT_SHIFT             (0U)
/*! CODEOUT - AC/KC output data
 */
#define PUF_CODEOUTPUT_CODEOUT(x)                (((uint32_t)(((uint32_t)(x)) << PUF_CODEOUTPUT_CODEOUT_SHIFT)) & PUF_CODEOUTPUT_CODEOUT_MASK)
/*! @} */

/*! @name KEYOUTINDEX - PUF Key Output Index register */
/*! @{ */
#define PUF_KEYOUTINDEX_KEYOUTIDX_MASK           (0xFU)
#define PUF_KEYOUTINDEX_KEYOUTIDX_SHIFT          (0U)
/*! KEYOUTIDX - Key index for the key that is currently output via the Key Output register
 */
#define PUF_KEYOUTINDEX_KEYOUTIDX(x)             (((uint32_t)(((uint32_t)(x)) << PUF_KEYOUTINDEX_KEYOUTIDX_SHIFT)) & PUF_KEYOUTINDEX_KEYOUTIDX_MASK)
/*! @} */

/*! @name KEYOUTPUT - PUF Key Output register */
/*! @{ */
#define PUF_KEYOUTPUT_KEYOUT_MASK                (0xFFFFFFFFU)
#define PUF_KEYOUTPUT_KEYOUT_SHIFT               (0U)
/*! KEYOUT - Key output data
 */
#define PUF_KEYOUTPUT_KEYOUT(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_KEYOUTPUT_KEYOUT_SHIFT)) & PUF_KEYOUTPUT_KEYOUT_MASK)
/*! @} */

/*! @name IFSTAT - PUF Interface Status and clear register */
/*! @{ */
#define PUF_IFSTAT_ERROR_MASK                    (0x1U)
#define PUF_IFSTAT_ERROR_SHIFT                   (0U)
/*! ERROR - Indicates that an APB error has occurred,Writing logic1 clears the if_error bit
 */
#define PUF_IFSTAT_ERROR(x)                      (((uint32_t)(((uint32_t)(x)) << PUF_IFSTAT_ERROR_SHIFT)) & PUF_IFSTAT_ERROR_MASK)
/*! @} */

/*! @name INTEN - PUF Interrupt Enable */
/*! @{ */
#define PUF_INTEN_READYEN_MASK                   (0x1U)
#define PUF_INTEN_READYEN_SHIFT                  (0U)
/*! READYEN - Enable corresponding interrupt. Note that bit numbers match those assigned in QK_SR (Quiddikey Status Register)
 */
#define PUF_INTEN_READYEN(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_READYEN_SHIFT)) & PUF_INTEN_READYEN_MASK)
#define PUF_INTEN_SUCCESEN_MASK                  (0x2U)
#define PUF_INTEN_SUCCESEN_SHIFT                 (1U)
/*! SUCCESEN - Enable corresponding interrupt. Note that bit numbers match those assigned in QK_SR (Quiddikey Status Register)
 */
#define PUF_INTEN_SUCCESEN(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_SUCCESEN_SHIFT)) & PUF_INTEN_SUCCESEN_MASK)
#define PUF_INTEN_ERROREN_MASK                   (0x4U)
#define PUF_INTEN_ERROREN_SHIFT                  (2U)
/*! ERROREN - Enable corresponding interrupt. Note that bit numbers match those assigned in QK_SR (Quiddikey Status Register)
 */
#define PUF_INTEN_ERROREN(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_ERROREN_SHIFT)) & PUF_INTEN_ERROREN_MASK)
#define PUF_INTEN_KEYINREQEN_MASK                (0x10U)
#define PUF_INTEN_KEYINREQEN_SHIFT               (4U)
/*! KEYINREQEN - Enable corresponding interrupt. Note that bit numbers match those assigned in QK_SR (Quiddikey Status Register)
 */
#define PUF_INTEN_KEYINREQEN(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_KEYINREQEN_SHIFT)) & PUF_INTEN_KEYINREQEN_MASK)
#define PUF_INTEN_KEYOUTAVAILEN_MASK             (0x20U)
#define PUF_INTEN_KEYOUTAVAILEN_SHIFT            (5U)
/*! KEYOUTAVAILEN - Enable corresponding interrupt. Note that bit numbers match those assigned in QK_SR (Quiddikey Status Register)
 */
#define PUF_INTEN_KEYOUTAVAILEN(x)               (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_KEYOUTAVAILEN_SHIFT)) & PUF_INTEN_KEYOUTAVAILEN_MASK)
#define PUF_INTEN_CODEINREQEN_MASK               (0x40U)
#define PUF_INTEN_CODEINREQEN_SHIFT              (6U)
/*! CODEINREQEN - Enable corresponding interrupt. Note that bit numbers match those assigned in QK_SR (Quiddikey Status Register)
 */
#define PUF_INTEN_CODEINREQEN(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_CODEINREQEN_SHIFT)) & PUF_INTEN_CODEINREQEN_MASK)
#define PUF_INTEN_CODEOUTAVAILEN_MASK            (0x80U)
#define PUF_INTEN_CODEOUTAVAILEN_SHIFT           (7U)
/*! CODEOUTAVAILEN - Enable corresponding interrupt. Note that bit numbers match those assigned in QK_SR (Quiddikey Status Register)
 */
#define PUF_INTEN_CODEOUTAVAILEN(x)              (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_CODEOUTAVAILEN_SHIFT)) & PUF_INTEN_CODEOUTAVAILEN_MASK)
/*! @} */

/*! @name INTSTAT - PUF interrupt status */
/*! @{ */
#define PUF_INTSTAT_READY_MASK                   (0x1U)
#define PUF_INTSTAT_READY_SHIFT                  (0U)
/*! READY - Triggers on falling edge of busy, write 1 to clear
 */
#define PUF_INTSTAT_READY(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_READY_SHIFT)) & PUF_INTSTAT_READY_MASK)
#define PUF_INTSTAT_SUCCESS_MASK                 (0x2U)
#define PUF_INTSTAT_SUCCESS_SHIFT                (1U)
/*! SUCCESS - Level sensitive interrupt, cleared when interrupt source clears
 */
#define PUF_INTSTAT_SUCCESS(x)                   (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_SUCCESS_SHIFT)) & PUF_INTSTAT_SUCCESS_MASK)
#define PUF_INTSTAT_ERROR_MASK                   (0x4U)
#define PUF_INTSTAT_ERROR_SHIFT                  (2U)
/*! ERROR - Level sensitive interrupt, cleared when interrupt source clears
 */
#define PUF_INTSTAT_ERROR(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_ERROR_SHIFT)) & PUF_INTSTAT_ERROR_MASK)
#define PUF_INTSTAT_KEYINREQ_MASK                (0x10U)
#define PUF_INTSTAT_KEYINREQ_SHIFT               (4U)
/*! KEYINREQ - Level sensitive interrupt, cleared when interrupt source clears
 */
#define PUF_INTSTAT_KEYINREQ(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_KEYINREQ_SHIFT)) & PUF_INTSTAT_KEYINREQ_MASK)
#define PUF_INTSTAT_KEYOUTAVAIL_MASK             (0x20U)
#define PUF_INTSTAT_KEYOUTAVAIL_SHIFT            (5U)
/*! KEYOUTAVAIL - Level sensitive interrupt, cleared when interrupt source clears
 */
#define PUF_INTSTAT_KEYOUTAVAIL(x)               (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_KEYOUTAVAIL_SHIFT)) & PUF_INTSTAT_KEYOUTAVAIL_MASK)
#define PUF_INTSTAT_CODEINREQ_MASK               (0x40U)
#define PUF_INTSTAT_CODEINREQ_SHIFT              (6U)
/*! CODEINREQ - Level sensitive interrupt, cleared when interrupt source clears
 */
#define PUF_INTSTAT_CODEINREQ(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_CODEINREQ_SHIFT)) & PUF_INTSTAT_CODEINREQ_MASK)
#define PUF_INTSTAT_CODEOUTAVAIL_MASK            (0x80U)
#define PUF_INTSTAT_CODEOUTAVAIL_SHIFT           (7U)
/*! CODEOUTAVAIL - Level sensitive interrupt, cleared when interrupt source clears
 */
#define PUF_INTSTAT_CODEOUTAVAIL(x)              (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_CODEOUTAVAIL_SHIFT)) & PUF_INTSTAT_CODEOUTAVAIL_MASK)
/*! @} */

/*! @name PWRCTRL - PUF RAM Power Control */
/*! @{ */
#define PUF_PWRCTRL_RAMON_MASK                   (0x1U)
#define PUF_PWRCTRL_RAMON_SHIFT                  (0U)
/*! RAMON - Power on the PUF RAM.
 */
#define PUF_PWRCTRL_RAMON(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_PWRCTRL_RAMON_SHIFT)) & PUF_PWRCTRL_RAMON_MASK)
#define PUF_PWRCTRL_RAMSTAT_MASK                 (0x2U)
#define PUF_PWRCTRL_RAMSTAT_SHIFT                (1U)
/*! RAMSTAT - PUF RAM status.
 */
#define PUF_PWRCTRL_RAMSTAT(x)                   (((uint32_t)(((uint32_t)(x)) << PUF_PWRCTRL_RAMSTAT_SHIFT)) & PUF_PWRCTRL_RAMSTAT_MASK)
/*! @} */

/*! @name CFG - PUF config register for block bits */
/*! @{ */
#define PUF_CFG_BLOCKENROLL_SETKEY_MASK          (0x1U)
#define PUF_CFG_BLOCKENROLL_SETKEY_SHIFT         (0U)
/*! BLOCKENROLL_SETKEY - Block enroll operation. Write 1 to set, cleared on reset.
 */
#define PUF_CFG_BLOCKENROLL_SETKEY(x)            (((uint32_t)(((uint32_t)(x)) << PUF_CFG_BLOCKENROLL_SETKEY_SHIFT)) & PUF_CFG_BLOCKENROLL_SETKEY_MASK)
#define PUF_CFG_BLOCKKEYOUTPUT_MASK              (0x2U)
#define PUF_CFG_BLOCKKEYOUTPUT_SHIFT             (1U)
/*! BLOCKKEYOUTPUT - Block set key operation. Write 1 to set, cleared on reset.
 */
#define PUF_CFG_BLOCKKEYOUTPUT(x)                (((uint32_t)(((uint32_t)(x)) << PUF_CFG_BLOCKKEYOUTPUT_SHIFT)) & PUF_CFG_BLOCKKEYOUTPUT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group PUF_Register_Masks */


/* PUF - Peripheral instance base addresses */
/** Peripheral PUF base address */
#define PUF_BASE                                 (0x4003B000u)
/** Peripheral PUF base pointer */
#define PUF                                      ((PUF_Type *)PUF_BASE)
/** Array initializer of PUF peripheral base addresses */
#define PUF_BASE_ADDRS                           { PUF_BASE }
/** Array initializer of PUF peripheral base pointers */
#define PUF_BASE_PTRS                            { PUF }

/*!
 * @}
 */ /* end of group PUF_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RIT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RIT_Peripheral_Access_Layer RIT Peripheral Access Layer
 * @{
 */

/** RIT - Register Layout Typedef */
typedef struct {
  __IO uint32_t COMPVAL;                           /**< Compare value LSB register, offset: 0x0 */
  __IO uint32_t MASK;                              /**< Mask LSB register, offset: 0x4 */
  __IO uint32_t CTRL;                              /**< Control register, offset: 0x8 */
  __IO uint32_t COUNTER;                           /**< Counter LSB register, offset: 0xC */
  __IO uint32_t COMPVAL_H;                         /**< Compare value MSB register, offset: 0x10 */
  __IO uint32_t MASK_H;                            /**< Mask MSB register, offset: 0x14 */
       uint8_t RESERVED_0[4];
  __IO uint32_t COUNTER_H;                         /**< Counter MSB register, offset: 0x1C */
} RIT_Type;

/* ----------------------------------------------------------------------------
   -- RIT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RIT_Register_Masks RIT Register Masks
 * @{
 */

/*! @name COMPVAL - Compare value LSB register */
/*! @{ */
#define RIT_COMPVAL_RICOMP_MASK                  (0xFFFFFFFFU)
#define RIT_COMPVAL_RICOMP_SHIFT                 (0U)
/*! RICOMP - .
 */
#define RIT_COMPVAL_RICOMP(x)                    (((uint32_t)(((uint32_t)(x)) << RIT_COMPVAL_RICOMP_SHIFT)) & RIT_COMPVAL_RICOMP_MASK)
/*! @} */

/*! @name MASK - Mask LSB register */
/*! @{ */
#define RIT_MASK_RIMASK_MASK                     (0xFFFFFFFFU)
#define RIT_MASK_RIMASK_SHIFT                    (0U)
/*! RIMASK - Mask register.
 */
#define RIT_MASK_RIMASK(x)                       (((uint32_t)(((uint32_t)(x)) << RIT_MASK_RIMASK_SHIFT)) & RIT_MASK_RIMASK_MASK)
/*! @} */

/*! @name CTRL - Control register */
/*! @{ */
#define RIT_CTRL_RITINT_MASK                     (0x1U)
#define RIT_CTRL_RITINT_SHIFT                    (0U)
/*! RITINT - Interrupt flag.
 */
#define RIT_CTRL_RITINT(x)                       (((uint32_t)(((uint32_t)(x)) << RIT_CTRL_RITINT_SHIFT)) & RIT_CTRL_RITINT_MASK)
#define RIT_CTRL_RITENCLR_MASK                   (0x2U)
#define RIT_CTRL_RITENCLR_SHIFT                  (1U)
/*! RITENCLR - Timer enable clear.
 */
#define RIT_CTRL_RITENCLR(x)                     (((uint32_t)(((uint32_t)(x)) << RIT_CTRL_RITENCLR_SHIFT)) & RIT_CTRL_RITENCLR_MASK)
#define RIT_CTRL_RITENBR_MASK                    (0x4U)
#define RIT_CTRL_RITENBR_SHIFT                   (2U)
/*! RITENBR - Timer enable for debug.
 */
#define RIT_CTRL_RITENBR(x)                      (((uint32_t)(((uint32_t)(x)) << RIT_CTRL_RITENBR_SHIFT)) & RIT_CTRL_RITENBR_MASK)
#define RIT_CTRL_RITEN_MASK                      (0x8U)
#define RIT_CTRL_RITEN_SHIFT                     (3U)
/*! RITEN - Timer enable.
 */
#define RIT_CTRL_RITEN(x)                        (((uint32_t)(((uint32_t)(x)) << RIT_CTRL_RITEN_SHIFT)) & RIT_CTRL_RITEN_MASK)
/*! @} */

/*! @name COUNTER - Counter LSB register */
/*! @{ */
#define RIT_COUNTER_RICOUNTER_MASK               (0xFFFFFFFFU)
#define RIT_COUNTER_RICOUNTER_SHIFT              (0U)
/*! RICOUNTER - 32 LSBs of the up counter.
 */
#define RIT_COUNTER_RICOUNTER(x)                 (((uint32_t)(((uint32_t)(x)) << RIT_COUNTER_RICOUNTER_SHIFT)) & RIT_COUNTER_RICOUNTER_MASK)
/*! @} */

/*! @name COMPVAL_H - Compare value MSB register */
/*! @{ */
#define RIT_COMPVAL_H_RICOMP_MASK                (0xFFFFU)
#define RIT_COMPVAL_H_RICOMP_SHIFT               (0U)
/*! RICOMP - Compare value MSB register.
 */
#define RIT_COMPVAL_H_RICOMP(x)                  (((uint32_t)(((uint32_t)(x)) << RIT_COMPVAL_H_RICOMP_SHIFT)) & RIT_COMPVAL_H_RICOMP_MASK)
/*! @} */

/*! @name MASK_H - Mask MSB register */
/*! @{ */
#define RIT_MASK_H_RIMASK_MASK                   (0xFFFFU)
#define RIT_MASK_H_RIMASK_SHIFT                  (0U)
/*! RIMASK - Mask register.
 */
#define RIT_MASK_H_RIMASK(x)                     (((uint32_t)(((uint32_t)(x)) << RIT_MASK_H_RIMASK_SHIFT)) & RIT_MASK_H_RIMASK_MASK)
/*! @} */

/*! @name COUNTER_H - Counter MSB register */
/*! @{ */
#define RIT_COUNTER_H_RICOUNTER_MASK             (0xFFFFU)
#define RIT_COUNTER_H_RICOUNTER_SHIFT            (0U)
/*! RICOUNTER - 16 LSBs of the up counter.
 */
#define RIT_COUNTER_H_RICOUNTER(x)               (((uint32_t)(((uint32_t)(x)) << RIT_COUNTER_H_RICOUNTER_SHIFT)) & RIT_COUNTER_H_RICOUNTER_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group RIT_Register_Masks */


/* RIT - Peripheral instance base addresses */
/** Peripheral RIT base address */
#define RIT_BASE                                 (0x4002D000u)
/** Peripheral RIT base pointer */
#define RIT                                      ((RIT_Type *)RIT_BASE)
/** Array initializer of RIT peripheral base addresses */
#define RIT_BASE_ADDRS                           { RIT_BASE }
/** Array initializer of RIT peripheral base pointers */
#define RIT_BASE_PTRS                            { RIT }
/** Interrupt vectors for the RIT peripheral type */
#define RIT_IRQS                                 { RIT_IRQn }

/*!
 * @}
 */ /* end of group RIT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RTC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RTC_Peripheral_Access_Layer RTC Peripheral Access Layer
 * @{
 */

/** RTC - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< RTC control register, offset: 0x0 */
  __IO uint32_t MATCH;                             /**< RTC match register, offset: 0x4 */
  __IO uint32_t COUNT;                             /**< RTC counter register, offset: 0x8 */
  __IO uint32_t WAKE;                              /**< High-resolution/wake-up timer control register, offset: 0xC */
       uint8_t RESERVED_0[48];
  __IO uint32_t GPREG[8];                          /**< General Purpose register, array offset: 0x40, array step: 0x4 */
} RTC_Type;

/* ----------------------------------------------------------------------------
   -- RTC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RTC_Register_Masks RTC Register Masks
 * @{
 */

/*! @name CTRL - RTC control register */
/*! @{ */
#define RTC_CTRL_SWRESET_MASK                    (0x1U)
#define RTC_CTRL_SWRESET_SHIFT                   (0U)
/*! SWRESET - Software reset control
 *  0b0..Not in reset. The RTC is not held in reset. This bit must be cleared prior to configuring or initiating any operation of the RTC.
 *  0b1..In reset. The RTC is held in reset. All register bits within the RTC will be forced to their reset value
 *       except the OFD bit. This bit must be cleared before writing to any register in the RTC - including writes
 *       to set any of the other bits within this register. Do not attempt to write to any bits of this register at
 *       the same time that the reset bit is being cleared.
 */
#define RTC_CTRL_SWRESET(x)                      (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_SWRESET_SHIFT)) & RTC_CTRL_SWRESET_MASK)
#define RTC_CTRL_ALARM1HZ_MASK                   (0x4U)
#define RTC_CTRL_ALARM1HZ_SHIFT                  (2U)
/*! ALARM1HZ - RTC 1 Hz timer alarm flag status.
 *  0b0..No match. No match has occurred on the 1 Hz RTC timer. Writing a 0 has no effect.
 *  0b1..Match. A match condition has occurred on the 1 Hz RTC timer. This flag generates an RTC alarm interrupt
 *       request RTC_ALARM which can also wake up the part from any low power mode. Writing a 1 clears this bit.
 */
#define RTC_CTRL_ALARM1HZ(x)                     (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_ALARM1HZ_SHIFT)) & RTC_CTRL_ALARM1HZ_MASK)
#define RTC_CTRL_WAKE1KHZ_MASK                   (0x8U)
#define RTC_CTRL_WAKE1KHZ_SHIFT                  (3U)
/*! WAKE1KHZ - RTC 1 kHz timer wake-up flag status.
 *  0b0..Run. The RTC 1 kHz timer is running. Writing a 0 has no effect.
 *  0b1..Time-out. The 1 kHz high-resolution/wake-up timer has timed out. This flag generates an RTC wake-up
 *       interrupt request RTC-WAKE which can also wake up the part from any low power mode. Writing a 1 clears this bit.
 */
#define RTC_CTRL_WAKE1KHZ(x)                     (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_WAKE1KHZ_SHIFT)) & RTC_CTRL_WAKE1KHZ_MASK)
#define RTC_CTRL_ALARMDPD_EN_MASK                (0x10U)
#define RTC_CTRL_ALARMDPD_EN_SHIFT               (4U)
/*! ALARMDPD_EN - RTC 1 Hz timer alarm enable for Deep power-down.
 *  0b0..Disable. A match on the 1 Hz RTC timer will not bring the part out of Deep power-down mode.
 *  0b1..Enable. A match on the 1 Hz RTC timer bring the part out of Deep power-down mode.
 */
#define RTC_CTRL_ALARMDPD_EN(x)                  (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_ALARMDPD_EN_SHIFT)) & RTC_CTRL_ALARMDPD_EN_MASK)
#define RTC_CTRL_WAKEDPD_EN_MASK                 (0x20U)
#define RTC_CTRL_WAKEDPD_EN_SHIFT                (5U)
/*! WAKEDPD_EN - RTC 1 kHz timer wake-up enable for Deep power-down.
 *  0b0..Disable. A match on the 1 kHz RTC timer will not bring the part out of Deep power-down mode.
 *  0b1..Enable. A match on the 1 kHz RTC timer bring the part out of Deep power-down mode.
 */
#define RTC_CTRL_WAKEDPD_EN(x)                   (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_WAKEDPD_EN_SHIFT)) & RTC_CTRL_WAKEDPD_EN_MASK)
#define RTC_CTRL_RTC1KHZ_EN_MASK                 (0x40U)
#define RTC_CTRL_RTC1KHZ_EN_SHIFT                (6U)
/*! RTC1KHZ_EN - RTC 1 kHz clock enable. This bit can be set to 0 to conserve power if the 1 kHz
 *    timer is not used. This bit has no effect when the RTC is disabled (bit 7 of this register is 0).
 *  0b0..Disable. A match on the 1 kHz RTC timer will not bring the part out of Deep power-down mode.
 *  0b1..Enable. The 1 kHz RTC timer is enabled.
 */
#define RTC_CTRL_RTC1KHZ_EN(x)                   (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_RTC1KHZ_EN_SHIFT)) & RTC_CTRL_RTC1KHZ_EN_MASK)
#define RTC_CTRL_RTC_EN_MASK                     (0x80U)
#define RTC_CTRL_RTC_EN_SHIFT                    (7U)
/*! RTC_EN - RTC enable.
 *  0b0..Disable. The RTC 1 Hz and 1 kHz clocks are shut down and the RTC operation is disabled. This bit should
 *       be 0 when writing to load a value in the RTC counter register.
 *  0b1..Enable. The 1 Hz RTC clock is running and RTC operation is enabled. This bit must be set to initiate
 *       operation of the RTC. The first clock to the RTC counter occurs 1 s after this bit is set. To also enable the
 *       high-resolution, 1 kHz clock, set bit 6 in this register.
 */
#define RTC_CTRL_RTC_EN(x)                       (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_RTC_EN_SHIFT)) & RTC_CTRL_RTC_EN_MASK)
#define RTC_CTRL_RTC_OSC_PD_MASK                 (0x100U)
#define RTC_CTRL_RTC_OSC_PD_SHIFT                (8U)
/*! RTC_OSC_PD - RTC oscillator power-down control.
 *  0b0..See RTC_OSC_BYPASS
 *  0b1..RTC oscillator is powered-down.
 */
#define RTC_CTRL_RTC_OSC_PD(x)                   (((uint32_t)(((uint32_t)(x)) << RTC_CTRL_RTC_OSC_PD_SHIFT)) & RTC_CTRL_RTC_OSC_PD_MASK)
/*! @} */

/*! @name MATCH - RTC match register */
/*! @{ */
#define RTC_MATCH_MATVAL_MASK                    (0xFFFFFFFFU)
#define RTC_MATCH_MATVAL_SHIFT                   (0U)
/*! MATVAL - Contains the match value against which the 1 Hz RTC timer will be compared to set the
 *    alarm flag RTC_ALARM and generate an alarm interrupt/wake-up if enabled.
 */
#define RTC_MATCH_MATVAL(x)                      (((uint32_t)(((uint32_t)(x)) << RTC_MATCH_MATVAL_SHIFT)) & RTC_MATCH_MATVAL_MASK)
/*! @} */

/*! @name COUNT - RTC counter register */
/*! @{ */
#define RTC_COUNT_VAL_MASK                       (0xFFFFFFFFU)
#define RTC_COUNT_VAL_SHIFT                      (0U)
/*! VAL - A read reflects the current value of the main, 1 Hz RTC timer. A write loads a new initial
 *    value into the timer. The RTC counter will count up continuously at a 1 Hz rate once the RTC
 *    Software Reset is removed (by clearing bit 0 of the CTRL register). Only write to this
 *    register when the RTC_EN bit in the RTC CTRL Register is 0. The counter increments one second after
 *    the RTC_EN bit is set.
 */
#define RTC_COUNT_VAL(x)                         (((uint32_t)(((uint32_t)(x)) << RTC_COUNT_VAL_SHIFT)) & RTC_COUNT_VAL_MASK)
/*! @} */

/*! @name WAKE - High-resolution/wake-up timer control register */
/*! @{ */
#define RTC_WAKE_VAL_MASK                        (0xFFFFU)
#define RTC_WAKE_VAL_SHIFT                       (0U)
/*! VAL - A read reflects the current value of the high-resolution/wake-up timer. A write pre-loads
 *    a start count value into the wake-up timer and initializes a count-down sequence. Do not write
 *    to this register while counting is in progress.
 */
#define RTC_WAKE_VAL(x)                          (((uint32_t)(((uint32_t)(x)) << RTC_WAKE_VAL_SHIFT)) & RTC_WAKE_VAL_MASK)
/*! @} */

/*! @name GPREG - General Purpose register */
/*! @{ */
#define RTC_GPREG_GPDATA_MASK                    (0xFFFFFFFFU)
#define RTC_GPREG_GPDATA_SHIFT                   (0U)
/*! GPDATA - Data retained during Deep power-down mode or loss of main power as long as VBAT is supplied.
 */
#define RTC_GPREG_GPDATA(x)                      (((uint32_t)(((uint32_t)(x)) << RTC_GPREG_GPDATA_SHIFT)) & RTC_GPREG_GPDATA_MASK)
/*! @} */

/* The count of RTC_GPREG */
#define RTC_GPREG_COUNT                          (8U)


/*!
 * @}
 */ /* end of group RTC_Register_Masks */


/* RTC - Peripheral instance base addresses */
/** Peripheral RTC base address */
#define RTC_BASE                                 (0x4002C000u)
/** Peripheral RTC base pointer */
#define RTC                                      ((RTC_Type *)RTC_BASE)
/** Array initializer of RTC peripheral base addresses */
#define RTC_BASE_ADDRS                           { RTC_BASE }
/** Array initializer of RTC peripheral base pointers */
#define RTC_BASE_PTRS                            { RTC }
/** Interrupt vectors for the RTC peripheral type */
#define RTC_IRQS                                 { RTC_IRQn }

/*!
 * @}
 */ /* end of group RTC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- SCT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SCT_Peripheral_Access_Layer SCT Peripheral Access Layer
 * @{
 */

/** SCT - Register Layout Typedef */
typedef struct {
  __IO uint32_t CONFIG;                            /**< SCT configuration register, offset: 0x0 */
  union {                                          /* offset: 0x4 */
    struct {                                         /* offset: 0x4 */
      __IO uint16_t CTRLL;                             /**< SCT_CTRLL register, offset: 0x4 */
      __IO uint16_t CTRLH;                             /**< SCT_CTRLH register, offset: 0x6 */
    } CTRL_ACCESS16BIT;
    __IO uint32_t CTRL;                              /**< SCT control register, offset: 0x4 */
  };
  union {                                          /* offset: 0x8 */
    struct {                                         /* offset: 0x8 */
      __IO uint16_t LIMITL;                            /**< SCT_LIMITL register, offset: 0x8 */
      __IO uint16_t LIMITH;                            /**< SCT_LIMITH register, offset: 0xA */
    } LIMIT_ACCESS16BIT;
    __IO uint32_t LIMIT;                             /**< SCT limit event select register, offset: 0x8 */
  };
  union {                                          /* offset: 0xC */
    struct {                                         /* offset: 0xC */
      __IO uint16_t HALTL;                             /**< SCT_HALTL register, offset: 0xC */
      __IO uint16_t HALTH;                             /**< SCT_HALTH register, offset: 0xE */
    } HALT_ACCESS16BIT;
    __IO uint32_t HALT;                              /**< SCT halt event select register, offset: 0xC */
  };
  union {                                          /* offset: 0x10 */
    struct {                                         /* offset: 0x10 */
      __IO uint16_t STOPL;                             /**< SCT_STOPL register, offset: 0x10 */
      __IO uint16_t STOPH;                             /**< SCT_STOPH register, offset: 0x12 */
    } STOP_ACCESS16BIT;
    __IO uint32_t STOP;                              /**< SCT stop event select register, offset: 0x10 */
  };
  union {                                          /* offset: 0x14 */
    struct {                                         /* offset: 0x14 */
      __IO uint16_t STARTL;                            /**< SCT_STARTL register, offset: 0x14 */
      __IO uint16_t STARTH;                            /**< SCT_STARTH register, offset: 0x16 */
    } START_ACCESS16BIT;
    __IO uint32_t START;                             /**< SCT start event select register, offset: 0x14 */
  };
       uint8_t RESERVED_0[40];
  union {                                          /* offset: 0x40 */
    struct {                                         /* offset: 0x40 */
      __IO uint16_t COUNTL;                            /**< SCT_COUNTL register, offset: 0x40 */
      __IO uint16_t COUNTH;                            /**< SCT_COUNTH register, offset: 0x42 */
    } COUNT_ACCESS16BIT;
    __IO uint32_t COUNT;                             /**< SCT counter register, offset: 0x40 */
  };
  union {                                          /* offset: 0x44 */
    struct {                                         /* offset: 0x44 */
      __IO uint16_t STATEL;                            /**< SCT_STATEL register, offset: 0x44 */
      __IO uint16_t STATEH;                            /**< SCT_STATEH register, offset: 0x46 */
    } STATE_ACCESS16BIT;
    __IO uint32_t STATE;                             /**< SCT state register, offset: 0x44 */
  };
  __I  uint32_t INPUT;                             /**< SCT input register, offset: 0x48 */
  union {                                          /* offset: 0x4C */
    struct {                                         /* offset: 0x4C */
      __IO uint16_t REGMODEL;                          /**< SCT_REGMODEL register, offset: 0x4C */
      __IO uint16_t REGMODEH;                          /**< SCT_REGMODEH register, offset: 0x4E */
    } REGMODE_ACCESS16BIT;
    __IO uint32_t REGMODE;                           /**< SCT match/capture mode register, offset: 0x4C */
  };
  __IO uint32_t OUTPUT;                            /**< SCT output register, offset: 0x50 */
  __IO uint32_t OUTPUTDIRCTRL;                     /**< SCT output counter direction control register, offset: 0x54 */
  __IO uint32_t RES;                               /**< SCT conflict resolution register, offset: 0x58 */
  __IO uint32_t DMAREQ0;                           /**< SCT DMA request 0 register, offset: 0x5C */
  __IO uint32_t DMAREQ1;                           /**< SCT DMA request 1 register, offset: 0x60 */
       uint8_t RESERVED_1[140];
  __IO uint32_t EVEN;                              /**< SCT event interrupt enable register, offset: 0xF0 */
  __IO uint32_t EVFLAG;                            /**< SCT event flag register, offset: 0xF4 */
  __IO uint32_t CONEN;                             /**< SCT conflict interrupt enable register, offset: 0xF8 */
  __IO uint32_t CONFLAG;                           /**< SCT conflict flag register, offset: 0xFC */
  union {                                          /* offset: 0x100 */
    union {                                          /* offset: 0x100, array step: 0x4 */
      struct {                                         /* offset: 0x100, array step: 0x4 */
        __IO uint16_t CAPL;                              /**< SCT_CAPL register, array offset: 0x100, array step: 0x4 */
        __IO uint16_t CAPH;                              /**< SCT_CAPH register, array offset: 0x102, array step: 0x4 */
      } CAP_ACCESS16BIT[16];
      __IO uint32_t CAP[16];                           /**< SCT capture register of capture channel, array offset: 0x100, array step: 0x4 */
    };
    union {                                          /* offset: 0x100, array step: 0x4 */
      struct {                                         /* offset: 0x100, array step: 0x4 */
        __IO uint16_t MATCHL;                            /**< SCT_MATCHL register, array offset: 0x100, array step: 0x4 */
        __IO uint16_t MATCHH;                            /**< SCT_MATCHH register, array offset: 0x102, array step: 0x4 */
      } MATCH_ACCESS16BIT[16];
      __IO uint32_t MATCH[16];                         /**< SCT match value register of match channels, array offset: 0x100, array step: 0x4 */
    };
  };
       uint8_t RESERVED_2[192];
  union {                                          /* offset: 0x200 */
    union {                                          /* offset: 0x200, array step: 0x4 */
      struct {                                         /* offset: 0x200, array step: 0x4 */
        __IO uint16_t CAPCTRLL;                          /**< SCT_CAPCTRLL register, array offset: 0x200, array step: 0x4 */
        __IO uint16_t CAPCTRLH;                          /**< SCT_CAPCTRLH register, array offset: 0x202, array step: 0x4 */
      } CAPCTRL_ACCESS16BIT[16];
      __IO uint32_t CAPCTRL[16];                       /**< SCT capture control register, array offset: 0x200, array step: 0x4 */
    };
    union {                                          /* offset: 0x200, array step: 0x4 */
      struct {                                         /* offset: 0x200, array step: 0x4 */
        __IO uint16_t MATCHRELL;                         /**< SCT_MATCHRELL register, array offset: 0x200, array step: 0x4 */
        __IO uint16_t MATCHRELH;                         /**< SCT_MATCHRELH register, array offset: 0x202, array step: 0x4 */
      } MATCHREL_ACCESS16BIT[16];
      __IO uint32_t MATCHREL[16];                      /**< SCT match reload value register, array offset: 0x200, array step: 0x4 */
    };
  };
       uint8_t RESERVED_3[192];
  struct {                                         /* offset: 0x300, array step: 0x8 */
    __IO uint32_t STATE;                             /**< SCT event state register 0, array offset: 0x300, array step: 0x8 */
    __IO uint32_t CTRL;                              /**< SCT event control register 0, array offset: 0x304, array step: 0x8 */
  } EV[16];
       uint8_t RESERVED_4[384];
  struct {                                         /* offset: 0x500, array step: 0x8 */
    __IO uint32_t SET;                               /**< SCT output 0 set register, array offset: 0x500, array step: 0x8 */
    __IO uint32_t CLR;                               /**< SCT output 0 clear register, array offset: 0x504, array step: 0x8 */
  } OUT[10];
} SCT_Type;

/* ----------------------------------------------------------------------------
   -- SCT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SCT_Register_Masks SCT Register Masks
 * @{
 */

/*! @name CONFIG - SCT configuration register */
/*! @{ */
#define SCT_CONFIG_UNIFY_MASK                    (0x1U)
#define SCT_CONFIG_UNIFY_SHIFT                   (0U)
/*! UNIFY - SCT operation
 *  0b0..The SCT operates as two 16-bit counters named COUNTER_L and COUNTER_H.
 *  0b1..The SCT operates as a unified 32-bit counter.
 */
#define SCT_CONFIG_UNIFY(x)                      (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_UNIFY_SHIFT)) & SCT_CONFIG_UNIFY_MASK)
#define SCT_CONFIG_CLKMODE_MASK                  (0x6U)
#define SCT_CONFIG_CLKMODE_SHIFT                 (1U)
/*! CLKMODE - SCT clock mode
 *  0b00..System Clock Mode. The system clock clocks the entire SCT module including the counter(s) and counter prescalers.
 *  0b01..Sampled System Clock Mode. The system clock clocks the SCT module, but the counter and prescalers are
 *        only enabled to count when the designated edge is detected on the input selected by the CKSEL field. The
 *        minimum pulse width on the selected clock-gate input is 1 bus clock period. This mode is the
 *        high-performance, sampled-clock mode.
 *  0b10..SCT Input Clock Mode. The input/edge selected by the CKSEL field clocks the SCT module, including the
 *        counters and prescalers, after first being synchronized to the system clock. The minimum pulse width on the
 *        clock input is 1 bus clock period. This mode is the low-power, sampled-clock mode.
 *  0b11..Asynchronous Mode. The entire SCT module is clocked directly by the input/edge selected by the CKSEL
 *        field. In this mode, the SCT outputs are switched synchronously to the SCT input clock - not the system
 *        clock. The input clock rate must be at least half the system clock rate and can be the same or faster than
 *        the system clock.
 */
#define SCT_CONFIG_CLKMODE(x)                    (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_CLKMODE_SHIFT)) & SCT_CONFIG_CLKMODE_MASK)
#define SCT_CONFIG_CKSEL_MASK                    (0x78U)
#define SCT_CONFIG_CKSEL_SHIFT                   (3U)
/*! CKSEL - SCT clock select. The specific functionality of the designated input/edge is dependent
 *    on the CLKMODE bit selection in this register.
 *  0b0000..Rising edges on input 0.
 *  0b0001..Falling edges on input 0.
 *  0b0010..Rising edges on input 1.
 *  0b0011..Falling edges on input 1.
 *  0b0100..Rising edges on input 2.
 *  0b0101..Falling edges on input 2.
 *  0b0110..Rising edges on input 3.
 *  0b0111..Falling edges on input 3.
 *  0b1000..Rising edges on input 4.
 *  0b1001..Falling edges on input 4.
 *  0b1010..Rising edges on input 5.
 *  0b1011..Falling edges on input 5.
 *  0b1100..Rising edges on input 6.
 *  0b1101..Falling edges on input 6.
 *  0b1110..Rising edges on input 7.
 *  0b1111..Falling edges on input 7.
 */
#define SCT_CONFIG_CKSEL(x)                      (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_CKSEL_SHIFT)) & SCT_CONFIG_CKSEL_MASK)
#define SCT_CONFIG_NORELOAD_L_MASK               (0x80U)
#define SCT_CONFIG_NORELOAD_L_SHIFT              (7U)
/*! NORELOAD_L - A 1 in this bit prevents the lower match registers from being reloaded from their
 *    respective reload registers. Setting this bit eliminates the need to write to the reload
 *    registers MATCHREL if the match values are fixed. Software can write to set or clear this bit at any
 *    time. This bit applies to both the higher and lower registers when the UNIFY bit is set.
 */
#define SCT_CONFIG_NORELOAD_L(x)                 (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_NORELOAD_L_SHIFT)) & SCT_CONFIG_NORELOAD_L_MASK)
#define SCT_CONFIG_NORELOAD_H_MASK               (0x100U)
#define SCT_CONFIG_NORELOAD_H_SHIFT              (8U)
/*! NORELOAD_H - A 1 in this bit prevents the higher match registers from being reloaded from their
 *    respective reload registers. Setting this bit eliminates the need to write to the reload
 *    registers MATCHREL if the match values are fixed. Software can write to set or clear this bit at
 *    any time. This bit is not used when the UNIFY bit is set.
 */
#define SCT_CONFIG_NORELOAD_H(x)                 (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_NORELOAD_H_SHIFT)) & SCT_CONFIG_NORELOAD_H_MASK)
#define SCT_CONFIG_INSYNC_MASK                   (0x1FE00U)
#define SCT_CONFIG_INSYNC_SHIFT                  (9U)
/*! INSYNC - Synchronization for input N (bit 9 = input 0, bit 10 = input 1,, bit 12 = input 3); all
 *    other bits are reserved. A 1 in one of these bits subjects the corresponding input to
 *    synchronization to the SCT clock, before it is used to create an event. If an input is known to
 *    already be synchronous to the SCT clock, this bit may be set to 0 for faster input response. (Note:
 *    The SCT clock is the system clock for CKMODEs 0-2. It is the selected, asynchronous SCT input
 *    clock for CKMODE3). Note that the INSYNC field only affects inputs used for event generation.
 *    It does not apply to the clock input specified in the CKSEL field.
 */
#define SCT_CONFIG_INSYNC(x)                     (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_INSYNC_SHIFT)) & SCT_CONFIG_INSYNC_MASK)
#define SCT_CONFIG_AUTOLIMIT_L_MASK              (0x20000U)
#define SCT_CONFIG_AUTOLIMIT_L_SHIFT             (17U)
/*! AUTOLIMIT_L - A one in this bit causes a match on match register 0 to be treated as a de-facto
 *    LIMIT condition without the need to define an associated event. As with any LIMIT event, this
 *    automatic limit causes the counter to be cleared to zero in unidirectional mode or to change
 *    the direction of count in bi-directional mode. Software can write to set or clear this bit at
 *    any time. This bit applies to both the higher and lower registers when the UNIFY bit is set.
 */
#define SCT_CONFIG_AUTOLIMIT_L(x)                (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_AUTOLIMIT_L_SHIFT)) & SCT_CONFIG_AUTOLIMIT_L_MASK)
#define SCT_CONFIG_AUTOLIMIT_H_MASK              (0x40000U)
#define SCT_CONFIG_AUTOLIMIT_H_SHIFT             (18U)
/*! AUTOLIMIT_H - A one in this bit will cause a match on match register 0 to be treated as a
 *    de-facto LIMIT condition without the need to define an associated event. As with any LIMIT event,
 *    this automatic limit causes the counter to be cleared to zero in unidirectional mode or to
 *    change the direction of count in bi-directional mode. Software can write to set or clear this bit
 *    at any time. This bit is not used when the UNIFY bit is set.
 */
#define SCT_CONFIG_AUTOLIMIT_H(x)                (((uint32_t)(((uint32_t)(x)) << SCT_CONFIG_AUTOLIMIT_H_SHIFT)) & SCT_CONFIG_AUTOLIMIT_H_MASK)
/*! @} */

/*! @name CTRLL - SCT_CTRLL register */
/*! @{ */
#define SCT_CTRLL_DOWN_L_MASK                    (0x1U)
#define SCT_CTRLL_DOWN_L_SHIFT                   (0U)
/*! DOWN_L - This bit is 1 when the L or unified counter is counting down. Hardware sets this bit
 *    when the counter is counting up, counter limit occurs, and BIDIR = 1.Hardware clears this bit
 *    when the counter is counting down and a limit condition occurs or when the counter reaches 0.
 */
#define SCT_CTRLL_DOWN_L(x)                      (((uint16_t)(((uint16_t)(x)) << SCT_CTRLL_DOWN_L_SHIFT)) & SCT_CTRLL_DOWN_L_MASK)
#define SCT_CTRLL_STOP_L_MASK                    (0x2U)
#define SCT_CTRLL_STOP_L_SHIFT                   (1U)
/*! STOP_L - When this bit is 1 and HALT is 0, the L or unified counter does not run, but I/O events
 *    related to the counter can occur. If a designated start event occurs, this bit is cleared and
 *    counting resumes.
 */
#define SCT_CTRLL_STOP_L(x)                      (((uint16_t)(((uint16_t)(x)) << SCT_CTRLL_STOP_L_SHIFT)) & SCT_CTRLL_STOP_L_MASK)
#define SCT_CTRLL_HALT_L_MASK                    (0x4U)
#define SCT_CTRLL_HALT_L_SHIFT                   (2U)
/*! HALT_L - When this bit is 1, the L or unified counter does not run and no events can occur. A
 *    reset sets this bit. When the HALT_L bit is one, the STOP_L bit is cleared. It is possible to
 *    remove the halt condition while keeping the SCT in the stop condition (not running) with a
 *    single write to this register to simultaneously clear the HALT bit and set the STOP bit. Once set,
 *    only software can clear this bit to restore counter operation. This bit is set on reset.
 */
#define SCT_CTRLL_HALT_L(x)                      (((uint16_t)(((uint16_t)(x)) << SCT_CTRLL_HALT_L_SHIFT)) & SCT_CTRLL_HALT_L_MASK)
#define SCT_CTRLL_CLRCTR_L_MASK                  (0x8U)
#define SCT_CTRLL_CLRCTR_L_SHIFT                 (3U)
/*! CLRCTR_L - Writing a 1 to this bit clears the L or unified counter. This bit always reads as 0.
 */
#define SCT_CTRLL_CLRCTR_L(x)                    (((uint16_t)(((uint16_t)(x)) << SCT_CTRLL_CLRCTR_L_SHIFT)) & SCT_CTRLL_CLRCTR_L_MASK)
#define SCT_CTRLL_BIDIR_L_MASK                   (0x10U)
#define SCT_CTRLL_BIDIR_L_SHIFT                  (4U)
/*! BIDIR_L - L or unified counter direction select
 *  0b0..Up. The counter counts up to a limit condition, then is cleared to zero.
 *  0b1..Up-down. The counter counts up to a limit, then counts down to a limit condition or to 0.
 */
#define SCT_CTRLL_BIDIR_L(x)                     (((uint16_t)(((uint16_t)(x)) << SCT_CTRLL_BIDIR_L_SHIFT)) & SCT_CTRLL_BIDIR_L_MASK)
#define SCT_CTRLL_PRE_L_MASK                     (0x1FE0U)
#define SCT_CTRLL_PRE_L_SHIFT                    (5U)
/*! PRE_L - Specifies the factor by which the SCT clock is prescaled to produce the L or unified
 *    counter clock. The counter clock is clocked at the rate of the SCT clock divided by PRE_L+1.
 *    Clear the counter (by writing a 1 to the CLRCTR bit) whenever changing the PRE value.
 */
#define SCT_CTRLL_PRE_L(x)                       (((uint16_t)(((uint16_t)(x)) << SCT_CTRLL_PRE_L_SHIFT)) & SCT_CTRLL_PRE_L_MASK)
/*! @} */

/*! @name CTRLH - SCT_CTRLH register */
/*! @{ */
#define SCT_CTRLH_DOWN_H_MASK                    (0x1U)
#define SCT_CTRLH_DOWN_H_SHIFT                   (0U)
/*! DOWN_H - This bit is 1 when the H counter is counting down. Hardware sets this bit when the
 *    counter is counting, a counter limit condition occurs, and BIDIR is 1. Hardware clears this bit
 *    when the counter is counting down and a limit condition occurs or when the counter reaches 0.
 */
#define SCT_CTRLH_DOWN_H(x)                      (((uint16_t)(((uint16_t)(x)) << SCT_CTRLH_DOWN_H_SHIFT)) & SCT_CTRLH_DOWN_H_MASK)
#define SCT_CTRLH_STOP_H_MASK                    (0x2U)
#define SCT_CTRLH_STOP_H_SHIFT                   (1U)
/*! STOP_H - When this bit is 1 and HALT is 0, the H counter does not, run but I/O events related to
 *    the counter can occur. If such an event matches the mask in the Start register, this bit is
 *    cleared and counting resumes.
 */
#define SCT_CTRLH_STOP_H(x)                      (((uint16_t)(((uint16_t)(x)) << SCT_CTRLH_STOP_H_SHIFT)) & SCT_CTRLH_STOP_H_MASK)
#define SCT_CTRLH_HALT_H_MASK                    (0x4U)
#define SCT_CTRLH_HALT_H_SHIFT                   (2U)
/*! HALT_H - When this bit is 1, the H counter does not run and no events can occur. A reset sets
 *    this bit. When the HALT_H bit is one, the STOP_H bit is cleared. It is possible to remove the
 *    halt condition while keeping the SCT in the stop condition (not running) with a single write to
 *    this register to simultaneously clear the HALT bit and set the STOP bit. Once set, this bit
 *    can only be cleared by software to restore counter operation. This bit is set on reset.
 */
#define SCT_CTRLH_HALT_H(x)                      (((uint16_t)(((uint16_t)(x)) << SCT_CTRLH_HALT_H_SHIFT)) & SCT_CTRLH_HALT_H_MASK)
#define SCT_CTRLH_CLRCTR_H_MASK                  (0x8U)
#define SCT_CTRLH_CLRCTR_H_SHIFT                 (3U)
/*! CLRCTR_H - Writing a 1 to this bit clears the H counter. This bit always reads as 0.
 */
#define SCT_CTRLH_CLRCTR_H(x)                    (((uint16_t)(((uint16_t)(x)) << SCT_CTRLH_CLRCTR_H_SHIFT)) & SCT_CTRLH_CLRCTR_H_MASK)
#define SCT_CTRLH_BIDIR_H_MASK                   (0x10U)
#define SCT_CTRLH_BIDIR_H_SHIFT                  (4U)
/*! BIDIR_H - Direction select
 *  0b0..The H counter counts up to its limit condition, then is cleared to zero.
 *  0b1..The H counter counts up to its limit, then counts down to a limit condition or to 0.
 */
#define SCT_CTRLH_BIDIR_H(x)                     (((uint16_t)(((uint16_t)(x)) << SCT_CTRLH_BIDIR_H_SHIFT)) & SCT_CTRLH_BIDIR_H_MASK)
#define SCT_CTRLH_PRE_H_MASK                     (0x1FE0U)
#define SCT_CTRLH_PRE_H_SHIFT                    (5U)
/*! PRE_H - Specifies the factor by which the SCT clock is prescaled to produce the H counter clock.
 *    The counter clock is clocked at the rate of the SCT clock divided by PRELH+1. Clear the
 *    counter (by writing a 1 to the CLRCTR bit) whenever changing the PRE value.
 */
#define SCT_CTRLH_PRE_H(x)                       (((uint16_t)(((uint16_t)(x)) << SCT_CTRLH_PRE_H_SHIFT)) & SCT_CTRLH_PRE_H_MASK)
/*! @} */

/*! @name CTRL - SCT control register */
/*! @{ */
#define SCT_CTRL_DOWN_L_MASK                     (0x1U)
#define SCT_CTRL_DOWN_L_SHIFT                    (0U)
/*! DOWN_L - This bit is 1 when the L or unified counter is counting down. Hardware sets this bit
 *    when the counter is counting up, counter limit occurs, and BIDIR = 1.Hardware clears this bit
 *    when the counter is counting down and a limit condition occurs or when the counter reaches 0.
 */
#define SCT_CTRL_DOWN_L(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_DOWN_L_SHIFT)) & SCT_CTRL_DOWN_L_MASK)
#define SCT_CTRL_STOP_L_MASK                     (0x2U)
#define SCT_CTRL_STOP_L_SHIFT                    (1U)
/*! STOP_L - When this bit is 1 and HALT is 0, the L or unified counter does not run, but I/O events
 *    related to the counter can occur. If a designated start event occurs, this bit is cleared and
 *    counting resumes.
 */
#define SCT_CTRL_STOP_L(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_STOP_L_SHIFT)) & SCT_CTRL_STOP_L_MASK)
#define SCT_CTRL_HALT_L_MASK                     (0x4U)
#define SCT_CTRL_HALT_L_SHIFT                    (2U)
/*! HALT_L - When this bit is 1, the L or unified counter does not run and no events can occur. A
 *    reset sets this bit. When the HALT_L bit is one, the STOP_L bit is cleared. It is possible to
 *    remove the halt condition while keeping the SCT in the stop condition (not running) with a
 *    single write to this register to simultaneously clear the HALT bit and set the STOP bit. Once set,
 *    only software can clear this bit to restore counter operation. This bit is set on reset.
 */
#define SCT_CTRL_HALT_L(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_HALT_L_SHIFT)) & SCT_CTRL_HALT_L_MASK)
#define SCT_CTRL_CLRCTR_L_MASK                   (0x8U)
#define SCT_CTRL_CLRCTR_L_SHIFT                  (3U)
/*! CLRCTR_L - Writing a 1 to this bit clears the L or unified counter. This bit always reads as 0.
 */
#define SCT_CTRL_CLRCTR_L(x)                     (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_CLRCTR_L_SHIFT)) & SCT_CTRL_CLRCTR_L_MASK)
#define SCT_CTRL_BIDIR_L_MASK                    (0x10U)
#define SCT_CTRL_BIDIR_L_SHIFT                   (4U)
/*! BIDIR_L - L or unified counter direction select
 *  0b0..Up. The counter counts up to a limit condition, then is cleared to zero.
 *  0b1..Up-down. The counter counts up to a limit, then counts down to a limit condition or to 0.
 */
#define SCT_CTRL_BIDIR_L(x)                      (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_BIDIR_L_SHIFT)) & SCT_CTRL_BIDIR_L_MASK)
#define SCT_CTRL_PRE_L_MASK                      (0x1FE0U)
#define SCT_CTRL_PRE_L_SHIFT                     (5U)
/*! PRE_L - Specifies the factor by which the SCT clock is prescaled to produce the L or unified
 *    counter clock. The counter clock is clocked at the rate of the SCT clock divided by PRE_L+1.
 *    Clear the counter (by writing a 1 to the CLRCTR bit) whenever changing the PRE value.
 */
#define SCT_CTRL_PRE_L(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_PRE_L_SHIFT)) & SCT_CTRL_PRE_L_MASK)
#define SCT_CTRL_DOWN_H_MASK                     (0x10000U)
#define SCT_CTRL_DOWN_H_SHIFT                    (16U)
/*! DOWN_H - This bit is 1 when the H counter is counting down. Hardware sets this bit when the
 *    counter is counting, a counter limit condition occurs, and BIDIR is 1. Hardware clears this bit
 *    when the counter is counting down and a limit condition occurs or when the counter reaches 0.
 */
#define SCT_CTRL_DOWN_H(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_DOWN_H_SHIFT)) & SCT_CTRL_DOWN_H_MASK)
#define SCT_CTRL_STOP_H_MASK                     (0x20000U)
#define SCT_CTRL_STOP_H_SHIFT                    (17U)
/*! STOP_H - When this bit is 1 and HALT is 0, the H counter does not, run but I/O events related to
 *    the counter can occur. If such an event matches the mask in the Start register, this bit is
 *    cleared and counting resumes.
 */
#define SCT_CTRL_STOP_H(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_STOP_H_SHIFT)) & SCT_CTRL_STOP_H_MASK)
#define SCT_CTRL_HALT_H_MASK                     (0x40000U)
#define SCT_CTRL_HALT_H_SHIFT                    (18U)
/*! HALT_H - When this bit is 1, the H counter does not run and no events can occur. A reset sets
 *    this bit. When the HALT_H bit is one, the STOP_H bit is cleared. It is possible to remove the
 *    halt condition while keeping the SCT in the stop condition (not running) with a single write to
 *    this register to simultaneously clear the HALT bit and set the STOP bit. Once set, this bit
 *    can only be cleared by software to restore counter operation. This bit is set on reset.
 */
#define SCT_CTRL_HALT_H(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_HALT_H_SHIFT)) & SCT_CTRL_HALT_H_MASK)
#define SCT_CTRL_CLRCTR_H_MASK                   (0x80000U)
#define SCT_CTRL_CLRCTR_H_SHIFT                  (19U)
/*! CLRCTR_H - Writing a 1 to this bit clears the H counter. This bit always reads as 0.
 */
#define SCT_CTRL_CLRCTR_H(x)                     (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_CLRCTR_H_SHIFT)) & SCT_CTRL_CLRCTR_H_MASK)
#define SCT_CTRL_BIDIR_H_MASK                    (0x100000U)
#define SCT_CTRL_BIDIR_H_SHIFT                   (20U)
/*! BIDIR_H - Direction select
 *  0b0..The H counter counts up to its limit condition, then is cleared to zero.
 *  0b1..The H counter counts up to its limit, then counts down to a limit condition or to 0.
 */
#define SCT_CTRL_BIDIR_H(x)                      (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_BIDIR_H_SHIFT)) & SCT_CTRL_BIDIR_H_MASK)
#define SCT_CTRL_PRE_H_MASK                      (0x1FE00000U)
#define SCT_CTRL_PRE_H_SHIFT                     (21U)
/*! PRE_H - Specifies the factor by which the SCT clock is prescaled to produce the H counter clock.
 *    The counter clock is clocked at the rate of the SCT clock divided by PRELH+1. Clear the
 *    counter (by writing a 1 to the CLRCTR bit) whenever changing the PRE value.
 */
#define SCT_CTRL_PRE_H(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_CTRL_PRE_H_SHIFT)) & SCT_CTRL_PRE_H_MASK)
/*! @} */

/*! @name LIMITL - SCT_LIMITL register */
/*! @{ */
#define SCT_LIMITL_LIMITL_MASK                   (0xFFFFU)
#define SCT_LIMITL_LIMITL_SHIFT                  (0U)
#define SCT_LIMITL_LIMITL(x)                     (((uint16_t)(((uint16_t)(x)) << SCT_LIMITL_LIMITL_SHIFT)) & SCT_LIMITL_LIMITL_MASK)
/*! @} */

/*! @name LIMITH - SCT_LIMITH register */
/*! @{ */
#define SCT_LIMITH_LIMITH_MASK                   (0xFFFFU)
#define SCT_LIMITH_LIMITH_SHIFT                  (0U)
#define SCT_LIMITH_LIMITH(x)                     (((uint16_t)(((uint16_t)(x)) << SCT_LIMITH_LIMITH_SHIFT)) & SCT_LIMITH_LIMITH_MASK)
/*! @} */

/*! @name LIMIT - SCT limit event select register */
/*! @{ */
#define SCT_LIMIT_LIMMSK_L_MASK                  (0xFFFFU)
#define SCT_LIMIT_LIMMSK_L_SHIFT                 (0U)
/*! LIMMSK_L - If bit n is one, event n is used as a counter limit for the L or unified counter
 *    (event 0 = bit 0, event 1 = bit 1, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_LIMIT_LIMMSK_L(x)                    (((uint32_t)(((uint32_t)(x)) << SCT_LIMIT_LIMMSK_L_SHIFT)) & SCT_LIMIT_LIMMSK_L_MASK)
#define SCT_LIMIT_LIMMSK_H_MASK                  (0xFFFF0000U)
#define SCT_LIMIT_LIMMSK_H_SHIFT                 (16U)
/*! LIMMSK_H - If bit n is one, event n is used as a counter limit for the H counter (event 0 = bit
 *    16, event 1 = bit 17, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_LIMIT_LIMMSK_H(x)                    (((uint32_t)(((uint32_t)(x)) << SCT_LIMIT_LIMMSK_H_SHIFT)) & SCT_LIMIT_LIMMSK_H_MASK)
/*! @} */

/*! @name HALTL - SCT_HALTL register */
/*! @{ */
#define SCT_HALTL_HALTL_MASK                     (0xFFFFU)
#define SCT_HALTL_HALTL_SHIFT                    (0U)
#define SCT_HALTL_HALTL(x)                       (((uint16_t)(((uint16_t)(x)) << SCT_HALTL_HALTL_SHIFT)) & SCT_HALTL_HALTL_MASK)
/*! @} */

/*! @name HALTH - SCT_HALTH register */
/*! @{ */
#define SCT_HALTH_HALTH_MASK                     (0xFFFFU)
#define SCT_HALTH_HALTH_SHIFT                    (0U)
#define SCT_HALTH_HALTH(x)                       (((uint16_t)(((uint16_t)(x)) << SCT_HALTH_HALTH_SHIFT)) & SCT_HALTH_HALTH_MASK)
/*! @} */

/*! @name HALT - SCT halt event select register */
/*! @{ */
#define SCT_HALT_HALTMSK_L_MASK                  (0xFFFFU)
#define SCT_HALT_HALTMSK_L_SHIFT                 (0U)
/*! HALTMSK_L - If bit n is one, event n sets the HALT_L bit in the CTRL register (event 0 = bit 0,
 *    event 1 = bit 1, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_HALT_HALTMSK_L(x)                    (((uint32_t)(((uint32_t)(x)) << SCT_HALT_HALTMSK_L_SHIFT)) & SCT_HALT_HALTMSK_L_MASK)
#define SCT_HALT_HALTMSK_H_MASK                  (0xFFFF0000U)
#define SCT_HALT_HALTMSK_H_SHIFT                 (16U)
/*! HALTMSK_H - If bit n is one, event n sets the HALT_H bit in the CTRL register (event 0 = bit 16,
 *    event 1 = bit 17, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_HALT_HALTMSK_H(x)                    (((uint32_t)(((uint32_t)(x)) << SCT_HALT_HALTMSK_H_SHIFT)) & SCT_HALT_HALTMSK_H_MASK)
/*! @} */

/*! @name STOPL - SCT_STOPL register */
/*! @{ */
#define SCT_STOPL_STOPL_MASK                     (0xFFFFU)
#define SCT_STOPL_STOPL_SHIFT                    (0U)
#define SCT_STOPL_STOPL(x)                       (((uint16_t)(((uint16_t)(x)) << SCT_STOPL_STOPL_SHIFT)) & SCT_STOPL_STOPL_MASK)
/*! @} */

/*! @name STOPH - SCT_STOPH register */
/*! @{ */
#define SCT_STOPH_STOPH_MASK                     (0xFFFFU)
#define SCT_STOPH_STOPH_SHIFT                    (0U)
#define SCT_STOPH_STOPH(x)                       (((uint16_t)(((uint16_t)(x)) << SCT_STOPH_STOPH_SHIFT)) & SCT_STOPH_STOPH_MASK)
/*! @} */

/*! @name STOP - SCT stop event select register */
/*! @{ */
#define SCT_STOP_STOPMSK_L_MASK                  (0xFFFFU)
#define SCT_STOP_STOPMSK_L_SHIFT                 (0U)
/*! STOPMSK_L - If bit n is one, event n sets the STOP_L bit in the CTRL register (event 0 = bit 0,
 *    event 1 = bit 1, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_STOP_STOPMSK_L(x)                    (((uint32_t)(((uint32_t)(x)) << SCT_STOP_STOPMSK_L_SHIFT)) & SCT_STOP_STOPMSK_L_MASK)
#define SCT_STOP_STOPMSK_H_MASK                  (0xFFFF0000U)
#define SCT_STOP_STOPMSK_H_SHIFT                 (16U)
/*! STOPMSK_H - If bit n is one, event n sets the STOP_H bit in the CTRL register (event 0 = bit 16,
 *    event 1 = bit 17, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_STOP_STOPMSK_H(x)                    (((uint32_t)(((uint32_t)(x)) << SCT_STOP_STOPMSK_H_SHIFT)) & SCT_STOP_STOPMSK_H_MASK)
/*! @} */

/*! @name STARTL - SCT_STARTL register */
/*! @{ */
#define SCT_STARTL_STARTL_MASK                   (0xFFFFU)
#define SCT_STARTL_STARTL_SHIFT                  (0U)
#define SCT_STARTL_STARTL(x)                     (((uint16_t)(((uint16_t)(x)) << SCT_STARTL_STARTL_SHIFT)) & SCT_STARTL_STARTL_MASK)
/*! @} */

/*! @name STARTH - SCT_STARTH register */
/*! @{ */
#define SCT_STARTH_STARTH_MASK                   (0xFFFFU)
#define SCT_STARTH_STARTH_SHIFT                  (0U)
#define SCT_STARTH_STARTH(x)                     (((uint16_t)(((uint16_t)(x)) << SCT_STARTH_STARTH_SHIFT)) & SCT_STARTH_STARTH_MASK)
/*! @} */

/*! @name START - SCT start event select register */
/*! @{ */
#define SCT_START_STARTMSK_L_MASK                (0xFFFFU)
#define SCT_START_STARTMSK_L_SHIFT               (0U)
/*! STARTMSK_L - If bit n is one, event n clears the STOP_L bit in the CTRL register (event 0 = bit
 *    0, event 1 = bit 1, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_START_STARTMSK_L(x)                  (((uint32_t)(((uint32_t)(x)) << SCT_START_STARTMSK_L_SHIFT)) & SCT_START_STARTMSK_L_MASK)
#define SCT_START_STARTMSK_H_MASK                (0xFFFF0000U)
#define SCT_START_STARTMSK_H_SHIFT               (16U)
/*! STARTMSK_H - If bit n is one, event n clears the STOP_H bit in the CTRL register (event 0 = bit
 *    16, event 1 = bit 17, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_START_STARTMSK_H(x)                  (((uint32_t)(((uint32_t)(x)) << SCT_START_STARTMSK_H_SHIFT)) & SCT_START_STARTMSK_H_MASK)
/*! @} */

/*! @name COUNTL - SCT_COUNTL register */
/*! @{ */
#define SCT_COUNTL_COUNTL_MASK                   (0xFFFFU)
#define SCT_COUNTL_COUNTL_SHIFT                  (0U)
#define SCT_COUNTL_COUNTL(x)                     (((uint16_t)(((uint16_t)(x)) << SCT_COUNTL_COUNTL_SHIFT)) & SCT_COUNTL_COUNTL_MASK)
/*! @} */

/*! @name COUNTH - SCT_COUNTH register */
/*! @{ */
#define SCT_COUNTH_COUNTH_MASK                   (0xFFFFU)
#define SCT_COUNTH_COUNTH_SHIFT                  (0U)
#define SCT_COUNTH_COUNTH(x)                     (((uint16_t)(((uint16_t)(x)) << SCT_COUNTH_COUNTH_SHIFT)) & SCT_COUNTH_COUNTH_MASK)
/*! @} */

/*! @name COUNT - SCT counter register */
/*! @{ */
#define SCT_COUNT_CTR_L_MASK                     (0xFFFFU)
#define SCT_COUNT_CTR_L_SHIFT                    (0U)
/*! CTR_L - When UNIFY = 0, read or write the 16-bit L counter value. When UNIFY = 1, read or write
 *    the lower 16 bits of the 32-bit unified counter.
 */
#define SCT_COUNT_CTR_L(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_COUNT_CTR_L_SHIFT)) & SCT_COUNT_CTR_L_MASK)
#define SCT_COUNT_CTR_H_MASK                     (0xFFFF0000U)
#define SCT_COUNT_CTR_H_SHIFT                    (16U)
/*! CTR_H - When UNIFY = 0, read or write the 16-bit H counter value. When UNIFY = 1, read or write
 *    the upper 16 bits of the 32-bit unified counter.
 */
#define SCT_COUNT_CTR_H(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_COUNT_CTR_H_SHIFT)) & SCT_COUNT_CTR_H_MASK)
/*! @} */

/*! @name STATEL - SCT_STATEL register */
/*! @{ */
#define SCT_STATEL_STATEL_MASK                   (0xFFFFU)
#define SCT_STATEL_STATEL_SHIFT                  (0U)
#define SCT_STATEL_STATEL(x)                     (((uint16_t)(((uint16_t)(x)) << SCT_STATEL_STATEL_SHIFT)) & SCT_STATEL_STATEL_MASK)
/*! @} */

/*! @name STATEH - SCT_STATEH register */
/*! @{ */
#define SCT_STATEH_STATEH_MASK                   (0xFFFFU)
#define SCT_STATEH_STATEH_SHIFT                  (0U)
#define SCT_STATEH_STATEH(x)                     (((uint16_t)(((uint16_t)(x)) << SCT_STATEH_STATEH_SHIFT)) & SCT_STATEH_STATEH_MASK)
/*! @} */

/*! @name STATE - SCT state register */
/*! @{ */
#define SCT_STATE_STATE_L_MASK                   (0x1FU)
#define SCT_STATE_STATE_L_SHIFT                  (0U)
/*! STATE_L - State variable.
 */
#define SCT_STATE_STATE_L(x)                     (((uint32_t)(((uint32_t)(x)) << SCT_STATE_STATE_L_SHIFT)) & SCT_STATE_STATE_L_MASK)
#define SCT_STATE_STATE_H_MASK                   (0x1F0000U)
#define SCT_STATE_STATE_H_SHIFT                  (16U)
/*! STATE_H - State variable.
 */
#define SCT_STATE_STATE_H(x)                     (((uint32_t)(((uint32_t)(x)) << SCT_STATE_STATE_H_SHIFT)) & SCT_STATE_STATE_H_MASK)
/*! @} */

/*! @name INPUT - SCT input register */
/*! @{ */
#define SCT_INPUT_AIN0_MASK                      (0x1U)
#define SCT_INPUT_AIN0_SHIFT                     (0U)
/*! AIN0 - Input 0 state. Input 0 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN0(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN0_SHIFT)) & SCT_INPUT_AIN0_MASK)
#define SCT_INPUT_AIN1_MASK                      (0x2U)
#define SCT_INPUT_AIN1_SHIFT                     (1U)
/*! AIN1 - Input 1 state. Input 1 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN1(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN1_SHIFT)) & SCT_INPUT_AIN1_MASK)
#define SCT_INPUT_AIN2_MASK                      (0x4U)
#define SCT_INPUT_AIN2_SHIFT                     (2U)
/*! AIN2 - Input 2 state. Input 2 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN2(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN2_SHIFT)) & SCT_INPUT_AIN2_MASK)
#define SCT_INPUT_AIN3_MASK                      (0x8U)
#define SCT_INPUT_AIN3_SHIFT                     (3U)
/*! AIN3 - Input 3 state. Input 3 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN3(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN3_SHIFT)) & SCT_INPUT_AIN3_MASK)
#define SCT_INPUT_AIN4_MASK                      (0x10U)
#define SCT_INPUT_AIN4_SHIFT                     (4U)
/*! AIN4 - Input 4 state. Input 4 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN4(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN4_SHIFT)) & SCT_INPUT_AIN4_MASK)
#define SCT_INPUT_AIN5_MASK                      (0x20U)
#define SCT_INPUT_AIN5_SHIFT                     (5U)
/*! AIN5 - Input 5 state. Input 5 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN5(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN5_SHIFT)) & SCT_INPUT_AIN5_MASK)
#define SCT_INPUT_AIN6_MASK                      (0x40U)
#define SCT_INPUT_AIN6_SHIFT                     (6U)
/*! AIN6 - Input 6 state. Input 6 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN6(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN6_SHIFT)) & SCT_INPUT_AIN6_MASK)
#define SCT_INPUT_AIN7_MASK                      (0x80U)
#define SCT_INPUT_AIN7_SHIFT                     (7U)
/*! AIN7 - Input 7 state. Input 7 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN7(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN7_SHIFT)) & SCT_INPUT_AIN7_MASK)
#define SCT_INPUT_AIN8_MASK                      (0x100U)
#define SCT_INPUT_AIN8_SHIFT                     (8U)
/*! AIN8 - Input 8 state. Input 8 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN8(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN8_SHIFT)) & SCT_INPUT_AIN8_MASK)
#define SCT_INPUT_AIN9_MASK                      (0x200U)
#define SCT_INPUT_AIN9_SHIFT                     (9U)
/*! AIN9 - Input 9 state. Input 9 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN9(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN9_SHIFT)) & SCT_INPUT_AIN9_MASK)
#define SCT_INPUT_AIN10_MASK                     (0x400U)
#define SCT_INPUT_AIN10_SHIFT                    (10U)
/*! AIN10 - Input 10 state. Input 10 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN10(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN10_SHIFT)) & SCT_INPUT_AIN10_MASK)
#define SCT_INPUT_AIN11_MASK                     (0x800U)
#define SCT_INPUT_AIN11_SHIFT                    (11U)
/*! AIN11 - Input 11 state. Input 11 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN11(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN11_SHIFT)) & SCT_INPUT_AIN11_MASK)
#define SCT_INPUT_AIN12_MASK                     (0x1000U)
#define SCT_INPUT_AIN12_SHIFT                    (12U)
/*! AIN12 - Input 12 state. Input 12 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN12(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN12_SHIFT)) & SCT_INPUT_AIN12_MASK)
#define SCT_INPUT_AIN13_MASK                     (0x2000U)
#define SCT_INPUT_AIN13_SHIFT                    (13U)
/*! AIN13 - Input 13 state. Input 13 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN13(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN13_SHIFT)) & SCT_INPUT_AIN13_MASK)
#define SCT_INPUT_AIN14_MASK                     (0x4000U)
#define SCT_INPUT_AIN14_SHIFT                    (14U)
/*! AIN14 - Input 14 state. Input 14 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN14(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN14_SHIFT)) & SCT_INPUT_AIN14_MASK)
#define SCT_INPUT_AIN15_MASK                     (0x8000U)
#define SCT_INPUT_AIN15_SHIFT                    (15U)
/*! AIN15 - Input 15 state. Input 15 state on the last SCT clock edge.
 */
#define SCT_INPUT_AIN15(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_AIN15_SHIFT)) & SCT_INPUT_AIN15_MASK)
#define SCT_INPUT_SIN0_MASK                      (0x10000U)
#define SCT_INPUT_SIN0_SHIFT                     (16U)
/*! SIN0 - Input 0 state. Input 0 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN0(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN0_SHIFT)) & SCT_INPUT_SIN0_MASK)
#define SCT_INPUT_SIN1_MASK                      (0x20000U)
#define SCT_INPUT_SIN1_SHIFT                     (17U)
/*! SIN1 - Input 1 state. Input 1 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN1(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN1_SHIFT)) & SCT_INPUT_SIN1_MASK)
#define SCT_INPUT_SIN2_MASK                      (0x40000U)
#define SCT_INPUT_SIN2_SHIFT                     (18U)
/*! SIN2 - Input 2 state. Input 2 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN2(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN2_SHIFT)) & SCT_INPUT_SIN2_MASK)
#define SCT_INPUT_SIN3_MASK                      (0x80000U)
#define SCT_INPUT_SIN3_SHIFT                     (19U)
/*! SIN3 - Input 3 state. Input 3 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN3(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN3_SHIFT)) & SCT_INPUT_SIN3_MASK)
#define SCT_INPUT_SIN4_MASK                      (0x100000U)
#define SCT_INPUT_SIN4_SHIFT                     (20U)
/*! SIN4 - Input 4 state. Input 4 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN4(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN4_SHIFT)) & SCT_INPUT_SIN4_MASK)
#define SCT_INPUT_SIN5_MASK                      (0x200000U)
#define SCT_INPUT_SIN5_SHIFT                     (21U)
/*! SIN5 - Input 5 state. Input 5 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN5(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN5_SHIFT)) & SCT_INPUT_SIN5_MASK)
#define SCT_INPUT_SIN6_MASK                      (0x400000U)
#define SCT_INPUT_SIN6_SHIFT                     (22U)
/*! SIN6 - Input 6 state. Input 6 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN6(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN6_SHIFT)) & SCT_INPUT_SIN6_MASK)
#define SCT_INPUT_SIN7_MASK                      (0x800000U)
#define SCT_INPUT_SIN7_SHIFT                     (23U)
/*! SIN7 - Input 7 state. Input 7 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN7(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN7_SHIFT)) & SCT_INPUT_SIN7_MASK)
#define SCT_INPUT_SIN8_MASK                      (0x1000000U)
#define SCT_INPUT_SIN8_SHIFT                     (24U)
/*! SIN8 - Input 8 state. Input 8 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN8(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN8_SHIFT)) & SCT_INPUT_SIN8_MASK)
#define SCT_INPUT_SIN9_MASK                      (0x2000000U)
#define SCT_INPUT_SIN9_SHIFT                     (25U)
/*! SIN9 - Input 9 state. Input 9 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN9(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN9_SHIFT)) & SCT_INPUT_SIN9_MASK)
#define SCT_INPUT_SIN10_MASK                     (0x4000000U)
#define SCT_INPUT_SIN10_SHIFT                    (26U)
/*! SIN10 - Input 10 state. Input 10 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN10(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN10_SHIFT)) & SCT_INPUT_SIN10_MASK)
#define SCT_INPUT_SIN11_MASK                     (0x8000000U)
#define SCT_INPUT_SIN11_SHIFT                    (27U)
/*! SIN11 - Input 11 state. Input 11 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN11(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN11_SHIFT)) & SCT_INPUT_SIN11_MASK)
#define SCT_INPUT_SIN12_MASK                     (0x10000000U)
#define SCT_INPUT_SIN12_SHIFT                    (28U)
/*! SIN12 - Input 12 state. Input 12 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN12(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN12_SHIFT)) & SCT_INPUT_SIN12_MASK)
#define SCT_INPUT_SIN13_MASK                     (0x20000000U)
#define SCT_INPUT_SIN13_SHIFT                    (29U)
/*! SIN13 - Input 13 state. Input 13 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN13(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN13_SHIFT)) & SCT_INPUT_SIN13_MASK)
#define SCT_INPUT_SIN14_MASK                     (0x40000000U)
#define SCT_INPUT_SIN14_SHIFT                    (30U)
/*! SIN14 - Input 14 state. Input 14 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN14(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN14_SHIFT)) & SCT_INPUT_SIN14_MASK)
#define SCT_INPUT_SIN15_MASK                     (0x80000000U)
#define SCT_INPUT_SIN15_SHIFT                    (31U)
/*! SIN15 - Input 15 state. Input 15 state following the synchronization specified by INSYNC.
 */
#define SCT_INPUT_SIN15(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_INPUT_SIN15_SHIFT)) & SCT_INPUT_SIN15_MASK)
/*! @} */

/*! @name REGMODEL - SCT_REGMODEL register */
/*! @{ */
#define SCT_REGMODEL_REGMODEL_MASK               (0xFFFFU)
#define SCT_REGMODEL_REGMODEL_SHIFT              (0U)
#define SCT_REGMODEL_REGMODEL(x)                 (((uint16_t)(((uint16_t)(x)) << SCT_REGMODEL_REGMODEL_SHIFT)) & SCT_REGMODEL_REGMODEL_MASK)
/*! @} */

/*! @name REGMODEH - SCT_REGMODEH register */
/*! @{ */
#define SCT_REGMODEH_REGMODEH_MASK               (0xFFFFU)
#define SCT_REGMODEH_REGMODEH_SHIFT              (0U)
#define SCT_REGMODEH_REGMODEH(x)                 (((uint16_t)(((uint16_t)(x)) << SCT_REGMODEH_REGMODEH_SHIFT)) & SCT_REGMODEH_REGMODEH_MASK)
/*! @} */

/*! @name REGMODE - SCT match/capture mode register */
/*! @{ */
#define SCT_REGMODE_REGMOD_L_MASK                (0xFFFFU)
#define SCT_REGMODE_REGMOD_L_SHIFT               (0U)
/*! REGMOD_L - Each bit controls one match/capture register (register 0 = bit 0, register 1 = bit 1,
 *    etc.). The number of bits = number of match/captures in this SCT. 0 = register operates as
 *    match register. 1 = register operates as capture register.
 */
#define SCT_REGMODE_REGMOD_L(x)                  (((uint32_t)(((uint32_t)(x)) << SCT_REGMODE_REGMOD_L_SHIFT)) & SCT_REGMODE_REGMOD_L_MASK)
#define SCT_REGMODE_REGMOD_H_MASK                (0xFFFF0000U)
#define SCT_REGMODE_REGMOD_H_SHIFT               (16U)
/*! REGMOD_H - Each bit controls one match/capture register (register 0 = bit 16, register 1 = bit
 *    17, etc.). The number of bits = number of match/captures in this SCT. 0 = register operates as
 *    match registers. 1 = register operates as capture registers.
 */
#define SCT_REGMODE_REGMOD_H(x)                  (((uint32_t)(((uint32_t)(x)) << SCT_REGMODE_REGMOD_H_SHIFT)) & SCT_REGMODE_REGMOD_H_MASK)
/*! @} */

/*! @name OUTPUT - SCT output register */
/*! @{ */
#define SCT_OUTPUT_OUT_MASK                      (0xFFFFU)
#define SCT_OUTPUT_OUT_SHIFT                     (0U)
/*! OUT - Writing a 1 to bit n forces the corresponding output HIGH. Writing a 0 forces the
 *    corresponding output LOW (output 0 = bit 0, output 1 = bit 1, etc.). The number of bits = number of
 *    outputs in this SCT.
 */
#define SCT_OUTPUT_OUT(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUT_OUT_SHIFT)) & SCT_OUTPUT_OUT_MASK)
/*! @} */

/*! @name OUTPUTDIRCTRL - SCT output counter direction control register */
/*! @{ */
#define SCT_OUTPUTDIRCTRL_SETCLR0_MASK           (0x3U)
#define SCT_OUTPUTDIRCTRL_SETCLR0_SHIFT          (0U)
/*! SETCLR0 - Set/clear operation on output 0. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR0(x)             (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR0_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR0_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR1_MASK           (0xCU)
#define SCT_OUTPUTDIRCTRL_SETCLR1_SHIFT          (2U)
/*! SETCLR1 - Set/clear operation on output 1. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR1(x)             (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR1_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR1_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR2_MASK           (0x30U)
#define SCT_OUTPUTDIRCTRL_SETCLR2_SHIFT          (4U)
/*! SETCLR2 - Set/clear operation on output 2. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR2(x)             (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR2_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR2_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR3_MASK           (0xC0U)
#define SCT_OUTPUTDIRCTRL_SETCLR3_SHIFT          (6U)
/*! SETCLR3 - Set/clear operation on output 3. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR3(x)             (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR3_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR3_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR4_MASK           (0x300U)
#define SCT_OUTPUTDIRCTRL_SETCLR4_SHIFT          (8U)
/*! SETCLR4 - Set/clear operation on output 4. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR4(x)             (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR4_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR4_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR5_MASK           (0xC00U)
#define SCT_OUTPUTDIRCTRL_SETCLR5_SHIFT          (10U)
/*! SETCLR5 - Set/clear operation on output 5. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR5(x)             (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR5_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR5_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR6_MASK           (0x3000U)
#define SCT_OUTPUTDIRCTRL_SETCLR6_SHIFT          (12U)
/*! SETCLR6 - Set/clear operation on output 6. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR6(x)             (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR6_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR6_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR7_MASK           (0xC000U)
#define SCT_OUTPUTDIRCTRL_SETCLR7_SHIFT          (14U)
/*! SETCLR7 - Set/clear operation on output 7. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR7(x)             (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR7_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR7_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR8_MASK           (0x30000U)
#define SCT_OUTPUTDIRCTRL_SETCLR8_SHIFT          (16U)
/*! SETCLR8 - Set/clear operation on output 8. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR8(x)             (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR8_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR8_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR9_MASK           (0xC0000U)
#define SCT_OUTPUTDIRCTRL_SETCLR9_SHIFT          (18U)
/*! SETCLR9 - Set/clear operation on output 9. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR9(x)             (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR9_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR9_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR10_MASK          (0x300000U)
#define SCT_OUTPUTDIRCTRL_SETCLR10_SHIFT         (20U)
/*! SETCLR10 - Set/clear operation on output 10. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR10(x)            (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR10_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR10_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR11_MASK          (0xC00000U)
#define SCT_OUTPUTDIRCTRL_SETCLR11_SHIFT         (22U)
/*! SETCLR11 - Set/clear operation on output 11. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR11(x)            (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR11_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR11_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR12_MASK          (0x3000000U)
#define SCT_OUTPUTDIRCTRL_SETCLR12_SHIFT         (24U)
/*! SETCLR12 - Set/clear operation on output 12. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR12(x)            (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR12_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR12_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR13_MASK          (0xC000000U)
#define SCT_OUTPUTDIRCTRL_SETCLR13_SHIFT         (26U)
/*! SETCLR13 - Set/clear operation on output 13. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR13(x)            (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR13_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR13_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR14_MASK          (0x30000000U)
#define SCT_OUTPUTDIRCTRL_SETCLR14_SHIFT         (28U)
/*! SETCLR14 - Set/clear operation on output 14. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR14(x)            (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR14_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR14_MASK)
#define SCT_OUTPUTDIRCTRL_SETCLR15_MASK          (0xC0000000U)
#define SCT_OUTPUTDIRCTRL_SETCLR15_SHIFT         (30U)
/*! SETCLR15 - Set/clear operation on output 15. Value 0x3 is reserved. Do not program this value.
 *  0b00..Set and clear do not depend on the direction of any counter.
 *  0b01..Set and clear are reversed when counter L or the unified counter is counting down.
 *  0b10..Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
 */
#define SCT_OUTPUTDIRCTRL_SETCLR15(x)            (((uint32_t)(((uint32_t)(x)) << SCT_OUTPUTDIRCTRL_SETCLR15_SHIFT)) & SCT_OUTPUTDIRCTRL_SETCLR15_MASK)
/*! @} */

/*! @name RES - SCT conflict resolution register */
/*! @{ */
#define SCT_RES_O0RES_MASK                       (0x3U)
#define SCT_RES_O0RES_SHIFT                      (0U)
/*! O0RES - Effect of simultaneous set and clear on output 0.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR0 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR0 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O0RES(x)                         (((uint32_t)(((uint32_t)(x)) << SCT_RES_O0RES_SHIFT)) & SCT_RES_O0RES_MASK)
#define SCT_RES_O1RES_MASK                       (0xCU)
#define SCT_RES_O1RES_SHIFT                      (2U)
/*! O1RES - Effect of simultaneous set and clear on output 1.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR1 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR1 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O1RES(x)                         (((uint32_t)(((uint32_t)(x)) << SCT_RES_O1RES_SHIFT)) & SCT_RES_O1RES_MASK)
#define SCT_RES_O2RES_MASK                       (0x30U)
#define SCT_RES_O2RES_SHIFT                      (4U)
/*! O2RES - Effect of simultaneous set and clear on output 2.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR2 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output n (or set based on the SETCLR2 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O2RES(x)                         (((uint32_t)(((uint32_t)(x)) << SCT_RES_O2RES_SHIFT)) & SCT_RES_O2RES_MASK)
#define SCT_RES_O3RES_MASK                       (0xC0U)
#define SCT_RES_O3RES_SHIFT                      (6U)
/*! O3RES - Effect of simultaneous set and clear on output 3.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR3 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR3 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O3RES(x)                         (((uint32_t)(((uint32_t)(x)) << SCT_RES_O3RES_SHIFT)) & SCT_RES_O3RES_MASK)
#define SCT_RES_O4RES_MASK                       (0x300U)
#define SCT_RES_O4RES_SHIFT                      (8U)
/*! O4RES - Effect of simultaneous set and clear on output 4.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR4 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR4 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O4RES(x)                         (((uint32_t)(((uint32_t)(x)) << SCT_RES_O4RES_SHIFT)) & SCT_RES_O4RES_MASK)
#define SCT_RES_O5RES_MASK                       (0xC00U)
#define SCT_RES_O5RES_SHIFT                      (10U)
/*! O5RES - Effect of simultaneous set and clear on output 5.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR5 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR5 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O5RES(x)                         (((uint32_t)(((uint32_t)(x)) << SCT_RES_O5RES_SHIFT)) & SCT_RES_O5RES_MASK)
#define SCT_RES_O6RES_MASK                       (0x3000U)
#define SCT_RES_O6RES_SHIFT                      (12U)
/*! O6RES - Effect of simultaneous set and clear on output 6.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR6 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR6 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O6RES(x)                         (((uint32_t)(((uint32_t)(x)) << SCT_RES_O6RES_SHIFT)) & SCT_RES_O6RES_MASK)
#define SCT_RES_O7RES_MASK                       (0xC000U)
#define SCT_RES_O7RES_SHIFT                      (14U)
/*! O7RES - Effect of simultaneous set and clear on output 7.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR7 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output n (or set based on the SETCLR7 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O7RES(x)                         (((uint32_t)(((uint32_t)(x)) << SCT_RES_O7RES_SHIFT)) & SCT_RES_O7RES_MASK)
#define SCT_RES_O8RES_MASK                       (0x30000U)
#define SCT_RES_O8RES_SHIFT                      (16U)
/*! O8RES - Effect of simultaneous set and clear on output 8.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR8 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR8 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O8RES(x)                         (((uint32_t)(((uint32_t)(x)) << SCT_RES_O8RES_SHIFT)) & SCT_RES_O8RES_MASK)
#define SCT_RES_O9RES_MASK                       (0xC0000U)
#define SCT_RES_O9RES_SHIFT                      (18U)
/*! O9RES - Effect of simultaneous set and clear on output 9.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR9 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR9 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O9RES(x)                         (((uint32_t)(((uint32_t)(x)) << SCT_RES_O9RES_SHIFT)) & SCT_RES_O9RES_MASK)
#define SCT_RES_O10RES_MASK                      (0x300000U)
#define SCT_RES_O10RES_SHIFT                     (20U)
/*! O10RES - Effect of simultaneous set and clear on output 10.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR10 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR10 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O10RES(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_RES_O10RES_SHIFT)) & SCT_RES_O10RES_MASK)
#define SCT_RES_O11RES_MASK                      (0xC00000U)
#define SCT_RES_O11RES_SHIFT                     (22U)
/*! O11RES - Effect of simultaneous set and clear on output 11.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR11 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR11 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O11RES(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_RES_O11RES_SHIFT)) & SCT_RES_O11RES_MASK)
#define SCT_RES_O12RES_MASK                      (0x3000000U)
#define SCT_RES_O12RES_SHIFT                     (24U)
/*! O12RES - Effect of simultaneous set and clear on output 12.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR12 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR12 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O12RES(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_RES_O12RES_SHIFT)) & SCT_RES_O12RES_MASK)
#define SCT_RES_O13RES_MASK                      (0xC000000U)
#define SCT_RES_O13RES_SHIFT                     (26U)
/*! O13RES - Effect of simultaneous set and clear on output 13.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR13 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR13 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O13RES(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_RES_O13RES_SHIFT)) & SCT_RES_O13RES_MASK)
#define SCT_RES_O14RES_MASK                      (0x30000000U)
#define SCT_RES_O14RES_SHIFT                     (28U)
/*! O14RES - Effect of simultaneous set and clear on output 14.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR14 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR14 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O14RES(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_RES_O14RES_SHIFT)) & SCT_RES_O14RES_MASK)
#define SCT_RES_O15RES_MASK                      (0xC0000000U)
#define SCT_RES_O15RES_SHIFT                     (30U)
/*! O15RES - Effect of simultaneous set and clear on output 15.
 *  0b00..No change.
 *  0b01..Set output (or clear based on the SETCLR15 field in the OUTPUTDIRCTRL register).
 *  0b10..Clear output (or set based on the SETCLR15 field).
 *  0b11..Toggle output.
 */
#define SCT_RES_O15RES(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_RES_O15RES_SHIFT)) & SCT_RES_O15RES_MASK)
/*! @} */

/*! @name DMAREQ0 - SCT DMA request 0 register */
/*! @{ */
#define SCT_DMAREQ0_DEV_0_MASK                   (0xFFFFU)
#define SCT_DMAREQ0_DEV_0_SHIFT                  (0U)
/*! DEV_0 - If bit n is one, event n triggers DMA request 0 (event 0 = bit 0, event 1 = bit 1,
 *    etc.). The number of bits = number of events in this SCT.
 */
#define SCT_DMAREQ0_DEV_0(x)                     (((uint32_t)(((uint32_t)(x)) << SCT_DMAREQ0_DEV_0_SHIFT)) & SCT_DMAREQ0_DEV_0_MASK)
#define SCT_DMAREQ0_DRL0_MASK                    (0x40000000U)
#define SCT_DMAREQ0_DRL0_SHIFT                   (30U)
/*! DRL0 - A 1 in this bit triggers DMA request 0 when it loads the MATCH_L/Unified registers from the RELOAD_L/Unified registers.
 */
#define SCT_DMAREQ0_DRL0(x)                      (((uint32_t)(((uint32_t)(x)) << SCT_DMAREQ0_DRL0_SHIFT)) & SCT_DMAREQ0_DRL0_MASK)
#define SCT_DMAREQ0_DRQ0_MASK                    (0x80000000U)
#define SCT_DMAREQ0_DRQ0_SHIFT                   (31U)
/*! DRQ0 - This read-only bit indicates the state of DMA Request 0. Note that if the related DMA
 *    channel is enabled and properly set up, it is unlikely that software will see this flag, it will
 *    be cleared rapidly by the DMA service. The flag remaining set could point to an issue with DMA
 *    setup.
 */
#define SCT_DMAREQ0_DRQ0(x)                      (((uint32_t)(((uint32_t)(x)) << SCT_DMAREQ0_DRQ0_SHIFT)) & SCT_DMAREQ0_DRQ0_MASK)
/*! @} */

/*! @name DMAREQ1 - SCT DMA request 1 register */
/*! @{ */
#define SCT_DMAREQ1_DEV_1_MASK                   (0xFFFFU)
#define SCT_DMAREQ1_DEV_1_SHIFT                  (0U)
/*! DEV_1 - If bit n is one, event n triggers DMA request 1 (event 0 = bit 0, event 1 = bit 1,
 *    etc.). The number of bits = number of events in this SCT.
 */
#define SCT_DMAREQ1_DEV_1(x)                     (((uint32_t)(((uint32_t)(x)) << SCT_DMAREQ1_DEV_1_SHIFT)) & SCT_DMAREQ1_DEV_1_MASK)
#define SCT_DMAREQ1_DRL1_MASK                    (0x40000000U)
#define SCT_DMAREQ1_DRL1_SHIFT                   (30U)
/*! DRL1 - A 1 in this bit triggers DMA request 1 when it loads the Match L/Unified registers from the Reload L/Unified registers.
 */
#define SCT_DMAREQ1_DRL1(x)                      (((uint32_t)(((uint32_t)(x)) << SCT_DMAREQ1_DRL1_SHIFT)) & SCT_DMAREQ1_DRL1_MASK)
#define SCT_DMAREQ1_DRQ1_MASK                    (0x80000000U)
#define SCT_DMAREQ1_DRQ1_SHIFT                   (31U)
/*! DRQ1 - This read-only bit indicates the state of DMA Request 1. Note that if the related DMA
 *    channel is enabled and properly set up, it is unlikely that software will see this flag, it will
 *    be cleared rapidly by the DMA service. The flag remaining set could point to an issue with DMA
 *    setup.
 */
#define SCT_DMAREQ1_DRQ1(x)                      (((uint32_t)(((uint32_t)(x)) << SCT_DMAREQ1_DRQ1_SHIFT)) & SCT_DMAREQ1_DRQ1_MASK)
/*! @} */

/*! @name EVEN - SCT event interrupt enable register */
/*! @{ */
#define SCT_EVEN_IEN_MASK                        (0xFFFFU)
#define SCT_EVEN_IEN_SHIFT                       (0U)
/*! IEN - The SCT requests an interrupt when bit n of this register and the event flag register are
 *    both one (event 0 = bit 0, event 1 = bit 1, etc.). The number of bits = number of events in
 *    this SCT.
 */
#define SCT_EVEN_IEN(x)                          (((uint32_t)(((uint32_t)(x)) << SCT_EVEN_IEN_SHIFT)) & SCT_EVEN_IEN_MASK)
/*! @} */

/*! @name EVFLAG - SCT event flag register */
/*! @{ */
#define SCT_EVFLAG_FLAG_MASK                     (0xFFFFU)
#define SCT_EVFLAG_FLAG_SHIFT                    (0U)
/*! FLAG - Bit n is one if event n has occurred since reset or a 1 was last written to this bit
 *    (event 0 = bit 0, event 1 = bit 1, etc.). The number of bits = number of events in this SCT.
 */
#define SCT_EVFLAG_FLAG(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_EVFLAG_FLAG_SHIFT)) & SCT_EVFLAG_FLAG_MASK)
/*! @} */

/*! @name CONEN - SCT conflict interrupt enable register */
/*! @{ */
#define SCT_CONEN_NCEN_MASK                      (0xFFFFU)
#define SCT_CONEN_NCEN_SHIFT                     (0U)
/*! NCEN - The SCT requests an interrupt when bit n of this register and the SCT conflict flag
 *    register are both one (output 0 = bit 0, output 1 = bit 1, etc.). The number of bits = number of
 *    outputs in this SCT.
 */
#define SCT_CONEN_NCEN(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_CONEN_NCEN_SHIFT)) & SCT_CONEN_NCEN_MASK)
/*! @} */

/*! @name CONFLAG - SCT conflict flag register */
/*! @{ */
#define SCT_CONFLAG_NCFLAG_MASK                  (0xFFFFU)
#define SCT_CONFLAG_NCFLAG_SHIFT                 (0U)
/*! NCFLAG - Bit n is one if a no-change conflict event occurred on output n since reset or a 1 was
 *    last written to this bit (output 0 = bit 0, output 1 = bit 1, etc.). The number of bits =
 *    number of outputs in this SCT.
 */
#define SCT_CONFLAG_NCFLAG(x)                    (((uint32_t)(((uint32_t)(x)) << SCT_CONFLAG_NCFLAG_SHIFT)) & SCT_CONFLAG_NCFLAG_MASK)
#define SCT_CONFLAG_BUSERRL_MASK                 (0x40000000U)
#define SCT_CONFLAG_BUSERRL_SHIFT                (30U)
/*! BUSERRL - The most recent bus error from this SCT involved writing CTR L/Unified, STATE
 *    L/Unified, MATCH L/Unified, or the Output register when the L/U counter was not halted. A word write
 *    to certain L and H registers can be half successful and half unsuccessful.
 */
#define SCT_CONFLAG_BUSERRL(x)                   (((uint32_t)(((uint32_t)(x)) << SCT_CONFLAG_BUSERRL_SHIFT)) & SCT_CONFLAG_BUSERRL_MASK)
#define SCT_CONFLAG_BUSERRH_MASK                 (0x80000000U)
#define SCT_CONFLAG_BUSERRH_SHIFT                (31U)
/*! BUSERRH - The most recent bus error from this SCT involved writing CTR H, STATE H, MATCH H, or
 *    the Output register when the H counter was not halted.
 */
#define SCT_CONFLAG_BUSERRH(x)                   (((uint32_t)(((uint32_t)(x)) << SCT_CONFLAG_BUSERRH_SHIFT)) & SCT_CONFLAG_BUSERRH_MASK)
/*! @} */

/*! @name CAPL - SCT_CAPL register */
/*! @{ */
#define SCT_CAPL_CAPL_MASK                       (0xFFFFU)
#define SCT_CAPL_CAPL_SHIFT                      (0U)
#define SCT_CAPL_CAPL(x)                         (((uint16_t)(((uint16_t)(x)) << SCT_CAPL_CAPL_SHIFT)) & SCT_CAPL_CAPL_MASK)
/*! @} */

/* The count of SCT_CAPL */
#define SCT_CAPL_COUNT                           (16U)

/*! @name CAPH - SCT_CAPH register */
/*! @{ */
#define SCT_CAPH_CAPH_MASK                       (0xFFFFU)
#define SCT_CAPH_CAPH_SHIFT                      (0U)
#define SCT_CAPH_CAPH(x)                         (((uint16_t)(((uint16_t)(x)) << SCT_CAPH_CAPH_SHIFT)) & SCT_CAPH_CAPH_MASK)
/*! @} */

/* The count of SCT_CAPH */
#define SCT_CAPH_COUNT                           (16U)

/*! @name CAP - SCT capture register of capture channel */
/*! @{ */
#define SCT_CAP_CAPn_L_MASK                      (0xFFFFU)
#define SCT_CAP_CAPn_L_SHIFT                     (0U)
/*! CAPn_L - When UNIFY = 0, read the 16-bit counter value at which this register was last captured.
 *    When UNIFY = 1, read the lower 16 bits of the 32-bit value at which this register was last
 *    captured.
 */
#define SCT_CAP_CAPn_L(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_CAP_CAPn_L_SHIFT)) & SCT_CAP_CAPn_L_MASK)
#define SCT_CAP_CAPn_H_MASK                      (0xFFFF0000U)
#define SCT_CAP_CAPn_H_SHIFT                     (16U)
/*! CAPn_H - When UNIFY = 0, read the 16-bit counter value at which this register was last captured.
 *    When UNIFY = 1, read the upper 16 bits of the 32-bit value at which this register was last
 *    captured.
 */
#define SCT_CAP_CAPn_H(x)                        (((uint32_t)(((uint32_t)(x)) << SCT_CAP_CAPn_H_SHIFT)) & SCT_CAP_CAPn_H_MASK)
/*! @} */

/* The count of SCT_CAP */
#define SCT_CAP_COUNT                            (16U)

/*! @name MATCHL - SCT_MATCHL register */
/*! @{ */
#define SCT_MATCHL_MATCHL_MASK                   (0xFFFFU)
#define SCT_MATCHL_MATCHL_SHIFT                  (0U)
#define SCT_MATCHL_MATCHL(x)                     (((uint16_t)(((uint16_t)(x)) << SCT_MATCHL_MATCHL_SHIFT)) & SCT_MATCHL_MATCHL_MASK)
/*! @} */

/* The count of SCT_MATCHL */
#define SCT_MATCHL_COUNT                         (16U)

/*! @name MATCHH - SCT_MATCHH register */
/*! @{ */
#define SCT_MATCHH_MATCHH_MASK                   (0xFFFFU)
#define SCT_MATCHH_MATCHH_SHIFT                  (0U)
#define SCT_MATCHH_MATCHH(x)                     (((uint16_t)(((uint16_t)(x)) << SCT_MATCHH_MATCHH_SHIFT)) & SCT_MATCHH_MATCHH_MASK)
/*! @} */

/* The count of SCT_MATCHH */
#define SCT_MATCHH_COUNT                         (16U)

/*! @name MATCH - SCT match value register of match channels */
/*! @{ */
#define SCT_MATCH_MATCHn_L_MASK                  (0xFFFFU)
#define SCT_MATCH_MATCHn_L_SHIFT                 (0U)
/*! MATCHn_L - When UNIFY = 0, read or write the 16-bit value to be compared to the L counter. When
 *    UNIFY = 1, read or write the lower 16 bits of the 32-bit value to be compared to the unified
 *    counter.
 */
#define SCT_MATCH_MATCHn_L(x)                    (((uint32_t)(((uint32_t)(x)) << SCT_MATCH_MATCHn_L_SHIFT)) & SCT_MATCH_MATCHn_L_MASK)
#define SCT_MATCH_MATCHn_H_MASK                  (0xFFFF0000U)
#define SCT_MATCH_MATCHn_H_SHIFT                 (16U)
/*! MATCHn_H - When UNIFY = 0, read or write the 16-bit value to be compared to the H counter. When
 *    UNIFY = 1, read or write the upper 16 bits of the 32-bit value to be compared to the unified
 *    counter.
 */
#define SCT_MATCH_MATCHn_H(x)                    (((uint32_t)(((uint32_t)(x)) << SCT_MATCH_MATCHn_H_SHIFT)) & SCT_MATCH_MATCHn_H_MASK)
/*! @} */

/* The count of SCT_MATCH */
#define SCT_MATCH_COUNT                          (16U)

/*! @name CAPCTRLL - SCT_CAPCTRLL register */
/*! @{ */
#define SCT_CAPCTRLL_CAPCTRLL_MASK               (0xFFFFU)
#define SCT_CAPCTRLL_CAPCTRLL_SHIFT              (0U)
#define SCT_CAPCTRLL_CAPCTRLL(x)                 (((uint16_t)(((uint16_t)(x)) << SCT_CAPCTRLL_CAPCTRLL_SHIFT)) & SCT_CAPCTRLL_CAPCTRLL_MASK)
/*! @} */

/* The count of SCT_CAPCTRLL */
#define SCT_CAPCTRLL_COUNT                       (16U)

/*! @name CAPCTRLH - SCT_CAPCTRLH register */
/*! @{ */
#define SCT_CAPCTRLH_CAPCTRLH_MASK               (0xFFFFU)
#define SCT_CAPCTRLH_CAPCTRLH_SHIFT              (0U)
#define SCT_CAPCTRLH_CAPCTRLH(x)                 (((uint16_t)(((uint16_t)(x)) << SCT_CAPCTRLH_CAPCTRLH_SHIFT)) & SCT_CAPCTRLH_CAPCTRLH_MASK)
/*! @} */

/* The count of SCT_CAPCTRLH */
#define SCT_CAPCTRLH_COUNT                       (16U)

/*! @name CAPCTRL - SCT capture control register */
/*! @{ */
#define SCT_CAPCTRL_CAPCONn_L_MASK               (0xFFFFU)
#define SCT_CAPCTRL_CAPCONn_L_SHIFT              (0U)
/*! CAPCONn_L - If bit m is one, event m causes the CAPn_L (UNIFY = 0) or the CAPn (UNIFY = 1)
 *    register to be loaded (event 0 = bit 0, event 1 = bit 1, etc.). The number of bits = number of
 *    match/captures in this SCT.
 */
#define SCT_CAPCTRL_CAPCONn_L(x)                 (((uint32_t)(((uint32_t)(x)) << SCT_CAPCTRL_CAPCONn_L_SHIFT)) & SCT_CAPCTRL_CAPCONn_L_MASK)
#define SCT_CAPCTRL_CAPCONn_H_MASK               (0xFFFF0000U)
#define SCT_CAPCTRL_CAPCONn_H_SHIFT              (16U)
/*! CAPCONn_H - If bit m is one, event m causes the CAPn_H (UNIFY = 0) register to be loaded (event
 *    0 = bit 16, event 1 = bit 17, etc.). The number of bits = number of match/captures in this SCT.
 */
#define SCT_CAPCTRL_CAPCONn_H(x)                 (((uint32_t)(((uint32_t)(x)) << SCT_CAPCTRL_CAPCONn_H_SHIFT)) & SCT_CAPCTRL_CAPCONn_H_MASK)
/*! @} */

/* The count of SCT_CAPCTRL */
#define SCT_CAPCTRL_COUNT                        (16U)

/*! @name MATCHRELL - SCT_MATCHRELL register */
/*! @{ */
#define SCT_MATCHRELL_MATCHRELL_MASK             (0xFFFFU)
#define SCT_MATCHRELL_MATCHRELL_SHIFT            (0U)
#define SCT_MATCHRELL_MATCHRELL(x)               (((uint16_t)(((uint16_t)(x)) << SCT_MATCHRELL_MATCHRELL_SHIFT)) & SCT_MATCHRELL_MATCHRELL_MASK)
/*! @} */

/* The count of SCT_MATCHRELL */
#define SCT_MATCHRELL_COUNT                      (16U)

/*! @name MATCHRELH - SCT_MATCHRELH register */
/*! @{ */
#define SCT_MATCHRELH_MATCHRELH_MASK             (0xFFFFU)
#define SCT_MATCHRELH_MATCHRELH_SHIFT            (0U)
#define SCT_MATCHRELH_MATCHRELH(x)               (((uint16_t)(((uint16_t)(x)) << SCT_MATCHRELH_MATCHRELH_SHIFT)) & SCT_MATCHRELH_MATCHRELH_MASK)
/*! @} */

/* The count of SCT_MATCHRELH */
#define SCT_MATCHRELH_COUNT                      (16U)

/*! @name MATCHREL - SCT match reload value register */
/*! @{ */
#define SCT_MATCHREL_RELOADn_L_MASK              (0xFFFFU)
#define SCT_MATCHREL_RELOADn_L_SHIFT             (0U)
/*! RELOADn_L - When UNIFY = 0, specifies the 16-bit value to be loaded into the MATCHn_L register.
 *    When UNIFY = 1, specifies the lower 16 bits of the 32-bit value to be loaded into the MATCHn
 *    register.
 */
#define SCT_MATCHREL_RELOADn_L(x)                (((uint32_t)(((uint32_t)(x)) << SCT_MATCHREL_RELOADn_L_SHIFT)) & SCT_MATCHREL_RELOADn_L_MASK)
#define SCT_MATCHREL_RELOADn_H_MASK              (0xFFFF0000U)
#define SCT_MATCHREL_RELOADn_H_SHIFT             (16U)
/*! RELOADn_H - When UNIFY = 0, specifies the 16-bit to be loaded into the MATCHn_H register. When
 *    UNIFY = 1, specifies the upper 16 bits of the 32-bit value to be loaded into the MATCHn
 *    register.
 */
#define SCT_MATCHREL_RELOADn_H(x)                (((uint32_t)(((uint32_t)(x)) << SCT_MATCHREL_RELOADn_H_SHIFT)) & SCT_MATCHREL_RELOADn_H_MASK)
/*! @} */

/* The count of SCT_MATCHREL */
#define SCT_MATCHREL_COUNT                       (16U)

/*! @name EV_STATE - SCT event state register 0 */
/*! @{ */
#define SCT_EV_STATE_STATEMSKn_MASK              (0xFFFFU)
#define SCT_EV_STATE_STATEMSKn_SHIFT             (0U)
/*! STATEMSKn - If bit m is one, event n happens in state m of the counter selected by the HEVENT
 *    bit (n = event number, m = state number; state 0 = bit 0, state 1= bit 1, etc.). The number of
 *    bits = number of states in this SCT.
 */
#define SCT_EV_STATE_STATEMSKn(x)                (((uint32_t)(((uint32_t)(x)) << SCT_EV_STATE_STATEMSKn_SHIFT)) & SCT_EV_STATE_STATEMSKn_MASK)
/*! @} */

/* The count of SCT_EV_STATE */
#define SCT_EV_STATE_COUNT                       (16U)

/*! @name EV_CTRL - SCT event control register 0 */
/*! @{ */
#define SCT_EV_CTRL_MATCHSEL_MASK                (0xFU)
#define SCT_EV_CTRL_MATCHSEL_SHIFT               (0U)
/*! MATCHSEL - Selects the Match register associated with this event (if any). A match can occur
 *    only when the counter selected by the HEVENT bit is running.
 */
#define SCT_EV_CTRL_MATCHSEL(x)                  (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_MATCHSEL_SHIFT)) & SCT_EV_CTRL_MATCHSEL_MASK)
#define SCT_EV_CTRL_HEVENT_MASK                  (0x10U)
#define SCT_EV_CTRL_HEVENT_SHIFT                 (4U)
/*! HEVENT - Select L/H counter. Do not set this bit if UNIFY = 1.
 *  0b0..Selects the L state and the L match register selected by MATCHSEL.
 *  0b1..Selects the H state and the H match register selected by MATCHSEL.
 */
#define SCT_EV_CTRL_HEVENT(x)                    (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_HEVENT_SHIFT)) & SCT_EV_CTRL_HEVENT_MASK)
#define SCT_EV_CTRL_OUTSEL_MASK                  (0x20U)
#define SCT_EV_CTRL_OUTSEL_SHIFT                 (5U)
/*! OUTSEL - Input/output select
 *  0b0..Selects the inputs selected by IOSEL.
 *  0b1..Selects the outputs selected by IOSEL.
 */
#define SCT_EV_CTRL_OUTSEL(x)                    (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_OUTSEL_SHIFT)) & SCT_EV_CTRL_OUTSEL_MASK)
#define SCT_EV_CTRL_IOSEL_MASK                   (0x3C0U)
#define SCT_EV_CTRL_IOSEL_SHIFT                  (6U)
/*! IOSEL - Selects the input or output signal number associated with this event (if any). Do not
 *    select an input in this register if CKMODE is 1x. In this case the clock input is an implicit
 *    ingredient of every event.
 */
#define SCT_EV_CTRL_IOSEL(x)                     (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_IOSEL_SHIFT)) & SCT_EV_CTRL_IOSEL_MASK)
#define SCT_EV_CTRL_IOCOND_MASK                  (0xC00U)
#define SCT_EV_CTRL_IOCOND_SHIFT                 (10U)
/*! IOCOND - Selects the I/O condition for event n. (The detection of edges on outputs lag the
 *    conditions that switch the outputs by one SCT clock). In order to guarantee proper edge/state
 *    detection, an input must have a minimum pulse width of at least one SCT clock period .
 *  0b00..LOW
 *  0b01..Rise
 *  0b10..Fall
 *  0b11..HIGH
 */
#define SCT_EV_CTRL_IOCOND(x)                    (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_IOCOND_SHIFT)) & SCT_EV_CTRL_IOCOND_MASK)
#define SCT_EV_CTRL_COMBMODE_MASK                (0x3000U)
#define SCT_EV_CTRL_COMBMODE_SHIFT               (12U)
/*! COMBMODE - Selects how the specified match and I/O condition are used and combined.
 *  0b00..OR. The event occurs when either the specified match or I/O condition occurs.
 *  0b01..MATCH. Uses the specified match only.
 *  0b10..IO. Uses the specified I/O condition only.
 *  0b11..AND. The event occurs when the specified match and I/O condition occur simultaneously.
 */
#define SCT_EV_CTRL_COMBMODE(x)                  (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_COMBMODE_SHIFT)) & SCT_EV_CTRL_COMBMODE_MASK)
#define SCT_EV_CTRL_STATELD_MASK                 (0x4000U)
#define SCT_EV_CTRL_STATELD_SHIFT                (14U)
/*! STATELD - This bit controls how the STATEV value modifies the state selected by HEVENT when this
 *    event is the highest-numbered event occurring for that state.
 *  0b0..STATEV value is added into STATE (the carry-out is ignored).
 *  0b1..STATEV value is loaded into STATE.
 */
#define SCT_EV_CTRL_STATELD(x)                   (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_STATELD_SHIFT)) & SCT_EV_CTRL_STATELD_MASK)
#define SCT_EV_CTRL_STATEV_MASK                  (0xF8000U)
#define SCT_EV_CTRL_STATEV_SHIFT                 (15U)
/*! STATEV - This value is loaded into or added to the state selected by HEVENT, depending on
 *    STATELD, when this event is the highest-numbered event occurring for that state. If STATELD and
 *    STATEV are both zero, there is no change to the STATE value.
 */
#define SCT_EV_CTRL_STATEV(x)                    (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_STATEV_SHIFT)) & SCT_EV_CTRL_STATEV_MASK)
#define SCT_EV_CTRL_MATCHMEM_MASK                (0x100000U)
#define SCT_EV_CTRL_MATCHMEM_SHIFT               (20U)
/*! MATCHMEM - If this bit is one and the COMBMODE field specifies a match component to the
 *    triggering of this event, then a match is considered to be active whenever the counter value is
 *    GREATER THAN OR EQUAL TO the value specified in the match register when counting up, LESS THEN OR
 *    EQUAL TO the match value when counting down. If this bit is zero, a match is only be active
 *    during the cycle when the counter is equal to the match value.
 */
#define SCT_EV_CTRL_MATCHMEM(x)                  (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_MATCHMEM_SHIFT)) & SCT_EV_CTRL_MATCHMEM_MASK)
#define SCT_EV_CTRL_DIRECTION_MASK               (0x600000U)
#define SCT_EV_CTRL_DIRECTION_SHIFT              (21U)
/*! DIRECTION - Direction qualifier for event generation. This field only applies when the counters
 *    are operating in BIDIR mode. If BIDIR = 0, the SCT ignores this field. Value 0x3 is reserved.
 *  0b00..Direction independent. This event is triggered regardless of the count direction.
 *  0b01..Counting up. This event is triggered only during up-counting when BIDIR = 1.
 *  0b10..Counting down. This event is triggered only during down-counting when BIDIR = 1.
 */
#define SCT_EV_CTRL_DIRECTION(x)                 (((uint32_t)(((uint32_t)(x)) << SCT_EV_CTRL_DIRECTION_SHIFT)) & SCT_EV_CTRL_DIRECTION_MASK)
/*! @} */

/* The count of SCT_EV_CTRL */
#define SCT_EV_CTRL_COUNT                        (16U)

/*! @name OUT_SET - SCT output 0 set register */
/*! @{ */
#define SCT_OUT_SET_SET_MASK                     (0xFFFFU)
#define SCT_OUT_SET_SET_SHIFT                    (0U)
/*! SET - A 1 in bit m selects event m to set output n (or clear it if SETCLRn = 0x1 or 0x2) output
 *    0 = bit 0, output 1 = bit 1, etc. The number of bits = number of events in this SCT. When the
 *    counter is used in bi-directional mode, it is possible to reverse the action specified by the
 *    output set and clear registers when counting down, See the OUTPUTCTRL register.
 */
#define SCT_OUT_SET_SET(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_OUT_SET_SET_SHIFT)) & SCT_OUT_SET_SET_MASK)
/*! @} */

/* The count of SCT_OUT_SET */
#define SCT_OUT_SET_COUNT                        (10U)

/*! @name OUT_CLR - SCT output 0 clear register */
/*! @{ */
#define SCT_OUT_CLR_CLR_MASK                     (0xFFFFU)
#define SCT_OUT_CLR_CLR_SHIFT                    (0U)
/*! CLR - A 1 in bit m selects event m to clear output n (or set it if SETCLRn = 0x1 or 0x2) event 0
 *    = bit 0, event 1 = bit 1, etc. The number of bits = number of events in this SCT. When the
 *    counter is used in bi-directional mode, it is possible to reverse the action specified by the
 *    output set and clear registers when counting down, See the OUTPUTCTRL register.
 */
#define SCT_OUT_CLR_CLR(x)                       (((uint32_t)(((uint32_t)(x)) << SCT_OUT_CLR_CLR_SHIFT)) & SCT_OUT_CLR_CLR_MASK)
/*! @} */

/* The count of SCT_OUT_CLR */
#define SCT_OUT_CLR_COUNT                        (10U)


/*!
 * @}
 */ /* end of group SCT_Register_Masks */


/* SCT - Peripheral instance base addresses */
/** Peripheral SCT0 base address */
#define SCT0_BASE                                (0x40085000u)
/** Peripheral SCT0 base pointer */
#define SCT0                                     ((SCT_Type *)SCT0_BASE)
/** Array initializer of SCT peripheral base addresses */
#define SCT_BASE_ADDRS                           { SCT0_BASE }
/** Array initializer of SCT peripheral base pointers */
#define SCT_BASE_PTRS                            { SCT0 }
/** Interrupt vectors for the SCT peripheral type */
#define SCT_IRQS                                 { SCT0_IRQn }

/*!
 * @}
 */ /* end of group SCT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- SDIF Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SDIF_Peripheral_Access_Layer SDIF Peripheral Access Layer
 * @{
 */

/** SDIF - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< Control register, offset: 0x0 */
  __IO uint32_t PWREN;                             /**< Power Enable register, offset: 0x4 */
  __IO uint32_t CLKDIV;                            /**< Clock Divider register, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __IO uint32_t CLKENA;                            /**< Clock Enable register, offset: 0x10 */
  __IO uint32_t TMOUT;                             /**< Time-out register, offset: 0x14 */
  __IO uint32_t CTYPE;                             /**< Card Type register, offset: 0x18 */
  __IO uint32_t BLKSIZ;                            /**< Block Size register, offset: 0x1C */
  __IO uint32_t BYTCNT;                            /**< Byte Count register, offset: 0x20 */
  __IO uint32_t INTMASK;                           /**< Interrupt Mask register, offset: 0x24 */
  __IO uint32_t CMDARG;                            /**< Command Argument register, offset: 0x28 */
  __IO uint32_t CMD;                               /**< Command register, offset: 0x2C */
  __I  uint32_t RESP[4];                           /**< Response register, array offset: 0x30, array step: 0x4 */
  __I  uint32_t MINTSTS;                           /**< Masked Interrupt Status register, offset: 0x40 */
  __IO uint32_t RINTSTS;                           /**< Raw Interrupt Status register, offset: 0x44 */
  __I  uint32_t STATUS;                            /**< Status register, offset: 0x48 */
  __IO uint32_t FIFOTH;                            /**< FIFO Threshold Watermark register, offset: 0x4C */
  __I  uint32_t CDETECT;                           /**< Card Detect register, offset: 0x50 */
  __I  uint32_t WRTPRT;                            /**< Write Protect register, offset: 0x54 */
       uint8_t RESERVED_1[4];
  __I  uint32_t TCBCNT;                            /**< Transferred CIU Card Byte Count register, offset: 0x5C */
  __I  uint32_t TBBCNT;                            /**< Transferred Host to BIU-FIFO Byte Count register, offset: 0x60 */
  __IO uint32_t DEBNCE;                            /**< Debounce Count register, offset: 0x64 */
       uint8_t RESERVED_2[16];
  __IO uint32_t RST_N;                             /**< Hardware Reset, offset: 0x78 */
       uint8_t RESERVED_3[4];
  __IO uint32_t BMOD;                              /**< Bus Mode register, offset: 0x80 */
  __O  uint32_t PLDMND;                            /**< Poll Demand register, offset: 0x84 */
  __IO uint32_t DBADDR;                            /**< Descriptor List Base Address register, offset: 0x88 */
  __IO uint32_t IDSTS;                             /**< Internal DMAC Status register, offset: 0x8C */
  __IO uint32_t IDINTEN;                           /**< Internal DMAC Interrupt Enable register, offset: 0x90 */
  __I  uint32_t DSCADDR;                           /**< Current Host Descriptor Address register, offset: 0x94 */
  __I  uint32_t BUFADDR;                           /**< Current Buffer Descriptor Address register, offset: 0x98 */
       uint8_t RESERVED_4[100];
  __IO uint32_t CARDTHRCTL;                        /**< Card Threshold Control, offset: 0x100 */
  __IO uint32_t BACKENDPWR;                        /**< Power control, offset: 0x104 */
       uint8_t RESERVED_5[248];
  __IO uint32_t FIFO[64];                          /**< SDIF FIFO, array offset: 0x200, array step: 0x4 */
} SDIF_Type;

/* ----------------------------------------------------------------------------
   -- SDIF Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SDIF_Register_Masks SDIF Register Masks
 * @{
 */

/*! @name CTRL - Control register */
/*! @{ */
#define SDIF_CTRL_CONTROLLER_RESET_MASK          (0x1U)
#define SDIF_CTRL_CONTROLLER_RESET_SHIFT         (0U)
/*! CONTROLLER_RESET - Controller reset.
 */
#define SDIF_CTRL_CONTROLLER_RESET(x)            (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_CONTROLLER_RESET_SHIFT)) & SDIF_CTRL_CONTROLLER_RESET_MASK)
#define SDIF_CTRL_FIFO_RESET_MASK                (0x2U)
#define SDIF_CTRL_FIFO_RESET_SHIFT               (1U)
/*! FIFO_RESET - Fifo reset.
 */
#define SDIF_CTRL_FIFO_RESET(x)                  (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_FIFO_RESET_SHIFT)) & SDIF_CTRL_FIFO_RESET_MASK)
#define SDIF_CTRL_DMA_RESET_MASK                 (0x4U)
#define SDIF_CTRL_DMA_RESET_SHIFT                (2U)
/*! DMA_RESET - DMA reset.
 */
#define SDIF_CTRL_DMA_RESET(x)                   (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_DMA_RESET_SHIFT)) & SDIF_CTRL_DMA_RESET_MASK)
#define SDIF_CTRL_INT_ENABLE_MASK                (0x10U)
#define SDIF_CTRL_INT_ENABLE_SHIFT               (4U)
/*! INT_ENABLE - Global interrupt enable/disable bit.
 */
#define SDIF_CTRL_INT_ENABLE(x)                  (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_INT_ENABLE_SHIFT)) & SDIF_CTRL_INT_ENABLE_MASK)
#define SDIF_CTRL_READ_WAIT_MASK                 (0x40U)
#define SDIF_CTRL_READ_WAIT_SHIFT                (6U)
/*! READ_WAIT - Read/wait.
 */
#define SDIF_CTRL_READ_WAIT(x)                   (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_READ_WAIT_SHIFT)) & SDIF_CTRL_READ_WAIT_MASK)
#define SDIF_CTRL_SEND_IRQ_RESPONSE_MASK         (0x80U)
#define SDIF_CTRL_SEND_IRQ_RESPONSE_SHIFT        (7U)
/*! SEND_IRQ_RESPONSE - Send irq response.
 */
#define SDIF_CTRL_SEND_IRQ_RESPONSE(x)           (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_SEND_IRQ_RESPONSE_SHIFT)) & SDIF_CTRL_SEND_IRQ_RESPONSE_MASK)
#define SDIF_CTRL_ABORT_READ_DATA_MASK           (0x100U)
#define SDIF_CTRL_ABORT_READ_DATA_SHIFT          (8U)
/*! ABORT_READ_DATA - Abort read data.
 */
#define SDIF_CTRL_ABORT_READ_DATA(x)             (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_ABORT_READ_DATA_SHIFT)) & SDIF_CTRL_ABORT_READ_DATA_MASK)
#define SDIF_CTRL_SEND_CCSD_MASK                 (0x200U)
#define SDIF_CTRL_SEND_CCSD_SHIFT                (9U)
/*! SEND_CCSD - Send ccsd.
 */
#define SDIF_CTRL_SEND_CCSD(x)                   (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_SEND_CCSD_SHIFT)) & SDIF_CTRL_SEND_CCSD_MASK)
#define SDIF_CTRL_SEND_AUTO_STOP_CCSD_MASK       (0x400U)
#define SDIF_CTRL_SEND_AUTO_STOP_CCSD_SHIFT      (10U)
/*! SEND_AUTO_STOP_CCSD - Send auto stop ccsd.
 */
#define SDIF_CTRL_SEND_AUTO_STOP_CCSD(x)         (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_SEND_AUTO_STOP_CCSD_SHIFT)) & SDIF_CTRL_SEND_AUTO_STOP_CCSD_MASK)
#define SDIF_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_MASK (0x800U)
#define SDIF_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_SHIFT (11U)
/*! CEATA_DEVICE_INTERRUPT_STATUS - CEATA device interrupt status.
 */
#define SDIF_CTRL_CEATA_DEVICE_INTERRUPT_STATUS(x) (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_SHIFT)) & SDIF_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_MASK)
#define SDIF_CTRL_CARD_VOLTAGE_A0_MASK           (0x10000U)
#define SDIF_CTRL_CARD_VOLTAGE_A0_SHIFT          (16U)
/*! CARD_VOLTAGE_A0 - Controls the state of the SD_VOLT0 pin.
 */
#define SDIF_CTRL_CARD_VOLTAGE_A0(x)             (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_CARD_VOLTAGE_A0_SHIFT)) & SDIF_CTRL_CARD_VOLTAGE_A0_MASK)
#define SDIF_CTRL_CARD_VOLTAGE_A1_MASK           (0x20000U)
#define SDIF_CTRL_CARD_VOLTAGE_A1_SHIFT          (17U)
/*! CARD_VOLTAGE_A1 - Controls the state of the SD_VOLT1 pin.
 */
#define SDIF_CTRL_CARD_VOLTAGE_A1(x)             (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_CARD_VOLTAGE_A1_SHIFT)) & SDIF_CTRL_CARD_VOLTAGE_A1_MASK)
#define SDIF_CTRL_CARD_VOLTAGE_A2_MASK           (0x40000U)
#define SDIF_CTRL_CARD_VOLTAGE_A2_SHIFT          (18U)
/*! CARD_VOLTAGE_A2 - Controls the state of the SD_VOLT2 pin.
 */
#define SDIF_CTRL_CARD_VOLTAGE_A2(x)             (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_CARD_VOLTAGE_A2_SHIFT)) & SDIF_CTRL_CARD_VOLTAGE_A2_MASK)
#define SDIF_CTRL_USE_INTERNAL_DMAC_MASK         (0x2000000U)
#define SDIF_CTRL_USE_INTERNAL_DMAC_SHIFT        (25U)
/*! USE_INTERNAL_DMAC - SD/MMC DMA use.
 */
#define SDIF_CTRL_USE_INTERNAL_DMAC(x)           (((uint32_t)(((uint32_t)(x)) << SDIF_CTRL_USE_INTERNAL_DMAC_SHIFT)) & SDIF_CTRL_USE_INTERNAL_DMAC_MASK)
/*! @} */

/*! @name PWREN - Power Enable register */
/*! @{ */
#define SDIF_PWREN_POWER_ENABLE_MASK             (0x1U)
#define SDIF_PWREN_POWER_ENABLE_SHIFT            (0U)
/*! POWER_ENABLE - Power on/off switch for card; once power is turned on, software should wait for
 *    regulator/switch ramp-up time before trying to initialize card.
 */
#define SDIF_PWREN_POWER_ENABLE(x)               (((uint32_t)(((uint32_t)(x)) << SDIF_PWREN_POWER_ENABLE_SHIFT)) & SDIF_PWREN_POWER_ENABLE_MASK)
/*! @} */

/*! @name CLKDIV - Clock Divider register */
/*! @{ */
#define SDIF_CLKDIV_CLK_DIVIDER0_MASK            (0xFFU)
#define SDIF_CLKDIV_CLK_DIVIDER0_SHIFT           (0U)
/*! CLK_DIVIDER0 - Clock divider-0 value.
 */
#define SDIF_CLKDIV_CLK_DIVIDER0(x)              (((uint32_t)(((uint32_t)(x)) << SDIF_CLKDIV_CLK_DIVIDER0_SHIFT)) & SDIF_CLKDIV_CLK_DIVIDER0_MASK)
/*! @} */

/*! @name CLKENA - Clock Enable register */
/*! @{ */
#define SDIF_CLKENA_CCLK_ENABLE_MASK             (0x1U)
#define SDIF_CLKENA_CCLK_ENABLE_SHIFT            (0U)
/*! CCLK_ENABLE - Clock-enable control for SD card clock.
 */
#define SDIF_CLKENA_CCLK_ENABLE(x)               (((uint32_t)(((uint32_t)(x)) << SDIF_CLKENA_CCLK_ENABLE_SHIFT)) & SDIF_CLKENA_CCLK_ENABLE_MASK)
#define SDIF_CLKENA_CCLK_LOW_POWER_MASK          (0x10000U)
#define SDIF_CLKENA_CCLK_LOW_POWER_SHIFT         (16U)
/*! CCLK_LOW_POWER - Low-power control for SD card clock.
 */
#define SDIF_CLKENA_CCLK_LOW_POWER(x)            (((uint32_t)(((uint32_t)(x)) << SDIF_CLKENA_CCLK_LOW_POWER_SHIFT)) & SDIF_CLKENA_CCLK_LOW_POWER_MASK)
/*! @} */

/*! @name TMOUT - Time-out register */
/*! @{ */
#define SDIF_TMOUT_RESPONSE_TIMEOUT_MASK         (0xFFU)
#define SDIF_TMOUT_RESPONSE_TIMEOUT_SHIFT        (0U)
/*! RESPONSE_TIMEOUT - Response time-out value.
 */
#define SDIF_TMOUT_RESPONSE_TIMEOUT(x)           (((uint32_t)(((uint32_t)(x)) << SDIF_TMOUT_RESPONSE_TIMEOUT_SHIFT)) & SDIF_TMOUT_RESPONSE_TIMEOUT_MASK)
#define SDIF_TMOUT_DATA_TIMEOUT_MASK             (0xFFFFFF00U)
#define SDIF_TMOUT_DATA_TIMEOUT_SHIFT            (8U)
/*! DATA_TIMEOUT - Value for card Data Read time-out; same value also used for Data Starvation by Host time-out.
 */
#define SDIF_TMOUT_DATA_TIMEOUT(x)               (((uint32_t)(((uint32_t)(x)) << SDIF_TMOUT_DATA_TIMEOUT_SHIFT)) & SDIF_TMOUT_DATA_TIMEOUT_MASK)
/*! @} */

/*! @name CTYPE - Card Type register */
/*! @{ */
#define SDIF_CTYPE_CARD_WIDTH0_MASK              (0x1U)
#define SDIF_CTYPE_CARD_WIDTH0_SHIFT             (0U)
/*! CARD_WIDTH0 - Indicates if card is 1-bit or 4-bit: 0 - 1-bit mode 1 - 4-bit mode 1 and 4-bit
 *    modes only work when 8-bit mode in CARD_WIDTH1 is not enabled (bit 16 in this register is set to
 *    0).
 */
#define SDIF_CTYPE_CARD_WIDTH0(x)                (((uint32_t)(((uint32_t)(x)) << SDIF_CTYPE_CARD_WIDTH0_SHIFT)) & SDIF_CTYPE_CARD_WIDTH0_MASK)
#define SDIF_CTYPE_CARD_WIDTH1_MASK              (0x10000U)
#define SDIF_CTYPE_CARD_WIDTH1_SHIFT             (16U)
/*! CARD_WIDTH1 - Indicates if card is 8-bit: 0 - Non 8-bit mode 1 - 8-bit mode.
 */
#define SDIF_CTYPE_CARD_WIDTH1(x)                (((uint32_t)(((uint32_t)(x)) << SDIF_CTYPE_CARD_WIDTH1_SHIFT)) & SDIF_CTYPE_CARD_WIDTH1_MASK)
/*! @} */

/*! @name BLKSIZ - Block Size register */
/*! @{ */
#define SDIF_BLKSIZ_BLOCK_SIZE_MASK              (0xFFFFU)
#define SDIF_BLKSIZ_BLOCK_SIZE_SHIFT             (0U)
/*! BLOCK_SIZE - Block size.
 */
#define SDIF_BLKSIZ_BLOCK_SIZE(x)                (((uint32_t)(((uint32_t)(x)) << SDIF_BLKSIZ_BLOCK_SIZE_SHIFT)) & SDIF_BLKSIZ_BLOCK_SIZE_MASK)
/*! @} */

/*! @name BYTCNT - Byte Count register */
/*! @{ */
#define SDIF_BYTCNT_BYTE_COUNT_MASK              (0xFFFFFFFFU)
#define SDIF_BYTCNT_BYTE_COUNT_SHIFT             (0U)
/*! BYTE_COUNT - Number of bytes to be transferred; should be integer multiple of Block Size for block transfers.
 */
#define SDIF_BYTCNT_BYTE_COUNT(x)                (((uint32_t)(((uint32_t)(x)) << SDIF_BYTCNT_BYTE_COUNT_SHIFT)) & SDIF_BYTCNT_BYTE_COUNT_MASK)
/*! @} */

/*! @name INTMASK - Interrupt Mask register */
/*! @{ */
#define SDIF_INTMASK_CDET_MASK                   (0x1U)
#define SDIF_INTMASK_CDET_SHIFT                  (0U)
/*! CDET - Card detect.
 */
#define SDIF_INTMASK_CDET(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_CDET_SHIFT)) & SDIF_INTMASK_CDET_MASK)
#define SDIF_INTMASK_RE_MASK                     (0x2U)
#define SDIF_INTMASK_RE_SHIFT                    (1U)
/*! RE - Response error.
 */
#define SDIF_INTMASK_RE(x)                       (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_RE_SHIFT)) & SDIF_INTMASK_RE_MASK)
#define SDIF_INTMASK_CDONE_MASK                  (0x4U)
#define SDIF_INTMASK_CDONE_SHIFT                 (2U)
/*! CDONE - Command done.
 */
#define SDIF_INTMASK_CDONE(x)                    (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_CDONE_SHIFT)) & SDIF_INTMASK_CDONE_MASK)
#define SDIF_INTMASK_DTO_MASK                    (0x8U)
#define SDIF_INTMASK_DTO_SHIFT                   (3U)
/*! DTO - Data transfer over.
 */
#define SDIF_INTMASK_DTO(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_DTO_SHIFT)) & SDIF_INTMASK_DTO_MASK)
#define SDIF_INTMASK_TXDR_MASK                   (0x10U)
#define SDIF_INTMASK_TXDR_SHIFT                  (4U)
/*! TXDR - Transmit FIFO data request.
 */
#define SDIF_INTMASK_TXDR(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_TXDR_SHIFT)) & SDIF_INTMASK_TXDR_MASK)
#define SDIF_INTMASK_RXDR_MASK                   (0x20U)
#define SDIF_INTMASK_RXDR_SHIFT                  (5U)
/*! RXDR - Receive FIFO data request.
 */
#define SDIF_INTMASK_RXDR(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_RXDR_SHIFT)) & SDIF_INTMASK_RXDR_MASK)
#define SDIF_INTMASK_RCRC_MASK                   (0x40U)
#define SDIF_INTMASK_RCRC_SHIFT                  (6U)
/*! RCRC - Response CRC error.
 */
#define SDIF_INTMASK_RCRC(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_RCRC_SHIFT)) & SDIF_INTMASK_RCRC_MASK)
#define SDIF_INTMASK_DCRC_MASK                   (0x80U)
#define SDIF_INTMASK_DCRC_SHIFT                  (7U)
/*! DCRC - Data CRC error.
 */
#define SDIF_INTMASK_DCRC(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_DCRC_SHIFT)) & SDIF_INTMASK_DCRC_MASK)
#define SDIF_INTMASK_RTO_MASK                    (0x100U)
#define SDIF_INTMASK_RTO_SHIFT                   (8U)
/*! RTO - Response time-out.
 */
#define SDIF_INTMASK_RTO(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_RTO_SHIFT)) & SDIF_INTMASK_RTO_MASK)
#define SDIF_INTMASK_DRTO_MASK                   (0x200U)
#define SDIF_INTMASK_DRTO_SHIFT                  (9U)
/*! DRTO - Data read time-out.
 */
#define SDIF_INTMASK_DRTO(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_DRTO_SHIFT)) & SDIF_INTMASK_DRTO_MASK)
#define SDIF_INTMASK_HTO_MASK                    (0x400U)
#define SDIF_INTMASK_HTO_SHIFT                   (10U)
/*! HTO - Data starvation-by-host time-out (HTO).
 */
#define SDIF_INTMASK_HTO(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_HTO_SHIFT)) & SDIF_INTMASK_HTO_MASK)
#define SDIF_INTMASK_FRUN_MASK                   (0x800U)
#define SDIF_INTMASK_FRUN_SHIFT                  (11U)
/*! FRUN - FIFO underrun/overrun error.
 */
#define SDIF_INTMASK_FRUN(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_FRUN_SHIFT)) & SDIF_INTMASK_FRUN_MASK)
#define SDIF_INTMASK_HLE_MASK                    (0x1000U)
#define SDIF_INTMASK_HLE_SHIFT                   (12U)
/*! HLE - Hardware locked write error.
 */
#define SDIF_INTMASK_HLE(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_HLE_SHIFT)) & SDIF_INTMASK_HLE_MASK)
#define SDIF_INTMASK_SBE_MASK                    (0x2000U)
#define SDIF_INTMASK_SBE_SHIFT                   (13U)
/*! SBE - Start-bit error.
 */
#define SDIF_INTMASK_SBE(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_SBE_SHIFT)) & SDIF_INTMASK_SBE_MASK)
#define SDIF_INTMASK_ACD_MASK                    (0x4000U)
#define SDIF_INTMASK_ACD_SHIFT                   (14U)
/*! ACD - Auto command done.
 */
#define SDIF_INTMASK_ACD(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_ACD_SHIFT)) & SDIF_INTMASK_ACD_MASK)
#define SDIF_INTMASK_EBE_MASK                    (0x8000U)
#define SDIF_INTMASK_EBE_SHIFT                   (15U)
/*! EBE - End-bit error (read)/Write no CRC.
 */
#define SDIF_INTMASK_EBE(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_EBE_SHIFT)) & SDIF_INTMASK_EBE_MASK)
#define SDIF_INTMASK_SDIO_INT_MASK_MASK          (0x10000U)
#define SDIF_INTMASK_SDIO_INT_MASK_SHIFT         (16U)
/*! SDIO_INT_MASK - Mask SDIO interrupt.
 */
#define SDIF_INTMASK_SDIO_INT_MASK(x)            (((uint32_t)(((uint32_t)(x)) << SDIF_INTMASK_SDIO_INT_MASK_SHIFT)) & SDIF_INTMASK_SDIO_INT_MASK_MASK)
/*! @} */

/*! @name CMDARG - Command Argument register */
/*! @{ */
#define SDIF_CMDARG_CMD_ARG_MASK                 (0xFFFFFFFFU)
#define SDIF_CMDARG_CMD_ARG_SHIFT                (0U)
/*! CMD_ARG - Value indicates command argument to be passed to card.
 */
#define SDIF_CMDARG_CMD_ARG(x)                   (((uint32_t)(((uint32_t)(x)) << SDIF_CMDARG_CMD_ARG_SHIFT)) & SDIF_CMDARG_CMD_ARG_MASK)
/*! @} */

/*! @name CMD - Command register */
/*! @{ */
#define SDIF_CMD_CMD_INDEX_MASK                  (0x3FU)
#define SDIF_CMD_CMD_INDEX_SHIFT                 (0U)
/*! CMD_INDEX - Command index.
 */
#define SDIF_CMD_CMD_INDEX(x)                    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_CMD_INDEX_SHIFT)) & SDIF_CMD_CMD_INDEX_MASK)
#define SDIF_CMD_RESPONSE_EXPECT_MASK            (0x40U)
#define SDIF_CMD_RESPONSE_EXPECT_SHIFT           (6U)
/*! RESPONSE_EXPECT - Response expect.
 */
#define SDIF_CMD_RESPONSE_EXPECT(x)              (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_RESPONSE_EXPECT_SHIFT)) & SDIF_CMD_RESPONSE_EXPECT_MASK)
#define SDIF_CMD_RESPONSE_LENGTH_MASK            (0x80U)
#define SDIF_CMD_RESPONSE_LENGTH_SHIFT           (7U)
/*! RESPONSE_LENGTH - Response length.
 */
#define SDIF_CMD_RESPONSE_LENGTH(x)              (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_RESPONSE_LENGTH_SHIFT)) & SDIF_CMD_RESPONSE_LENGTH_MASK)
#define SDIF_CMD_CHECK_RESPONSE_CRC_MASK         (0x100U)
#define SDIF_CMD_CHECK_RESPONSE_CRC_SHIFT        (8U)
/*! CHECK_RESPONSE_CRC - Check response CRC.
 */
#define SDIF_CMD_CHECK_RESPONSE_CRC(x)           (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_CHECK_RESPONSE_CRC_SHIFT)) & SDIF_CMD_CHECK_RESPONSE_CRC_MASK)
#define SDIF_CMD_DATA_EXPECTED_MASK              (0x200U)
#define SDIF_CMD_DATA_EXPECTED_SHIFT             (9U)
/*! DATA_EXPECTED - Data expected.
 */
#define SDIF_CMD_DATA_EXPECTED(x)                (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_DATA_EXPECTED_SHIFT)) & SDIF_CMD_DATA_EXPECTED_MASK)
#define SDIF_CMD_READ_WRITE_MASK                 (0x400U)
#define SDIF_CMD_READ_WRITE_SHIFT                (10U)
/*! READ_WRITE - read/write.
 */
#define SDIF_CMD_READ_WRITE(x)                   (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_READ_WRITE_SHIFT)) & SDIF_CMD_READ_WRITE_MASK)
#define SDIF_CMD_TRANSFER_MODE_MASK              (0x800U)
#define SDIF_CMD_TRANSFER_MODE_SHIFT             (11U)
/*! TRANSFER_MODE - Transfer mode.
 */
#define SDIF_CMD_TRANSFER_MODE(x)                (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_TRANSFER_MODE_SHIFT)) & SDIF_CMD_TRANSFER_MODE_MASK)
#define SDIF_CMD_SEND_AUTO_STOP_MASK             (0x1000U)
#define SDIF_CMD_SEND_AUTO_STOP_SHIFT            (12U)
/*! SEND_AUTO_STOP - Send auto stop.
 */
#define SDIF_CMD_SEND_AUTO_STOP(x)               (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_SEND_AUTO_STOP_SHIFT)) & SDIF_CMD_SEND_AUTO_STOP_MASK)
#define SDIF_CMD_WAIT_PRVDATA_COMPLETE_MASK      (0x2000U)
#define SDIF_CMD_WAIT_PRVDATA_COMPLETE_SHIFT     (13U)
/*! WAIT_PRVDATA_COMPLETE - Wait prvdata complete.
 */
#define SDIF_CMD_WAIT_PRVDATA_COMPLETE(x)        (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_WAIT_PRVDATA_COMPLETE_SHIFT)) & SDIF_CMD_WAIT_PRVDATA_COMPLETE_MASK)
#define SDIF_CMD_STOP_ABORT_CMD_MASK             (0x4000U)
#define SDIF_CMD_STOP_ABORT_CMD_SHIFT            (14U)
/*! STOP_ABORT_CMD - Stop abort command.
 */
#define SDIF_CMD_STOP_ABORT_CMD(x)               (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_STOP_ABORT_CMD_SHIFT)) & SDIF_CMD_STOP_ABORT_CMD_MASK)
#define SDIF_CMD_SEND_INITIALIZATION_MASK        (0x8000U)
#define SDIF_CMD_SEND_INITIALIZATION_SHIFT       (15U)
/*! SEND_INITIALIZATION - Send initialization.
 */
#define SDIF_CMD_SEND_INITIALIZATION(x)          (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_SEND_INITIALIZATION_SHIFT)) & SDIF_CMD_SEND_INITIALIZATION_MASK)
#define SDIF_CMD_UPDATE_CLOCK_REGISTERS_ONLY_MASK (0x200000U)
#define SDIF_CMD_UPDATE_CLOCK_REGISTERS_ONLY_SHIFT (21U)
/*! UPDATE_CLOCK_REGISTERS_ONLY - Update clock registers only.
 */
#define SDIF_CMD_UPDATE_CLOCK_REGISTERS_ONLY(x)  (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_UPDATE_CLOCK_REGISTERS_ONLY_SHIFT)) & SDIF_CMD_UPDATE_CLOCK_REGISTERS_ONLY_MASK)
#define SDIF_CMD_READ_CEATA_DEVICE_MASK          (0x400000U)
#define SDIF_CMD_READ_CEATA_DEVICE_SHIFT         (22U)
/*! READ_CEATA_DEVICE - Read ceata device.
 */
#define SDIF_CMD_READ_CEATA_DEVICE(x)            (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_READ_CEATA_DEVICE_SHIFT)) & SDIF_CMD_READ_CEATA_DEVICE_MASK)
#define SDIF_CMD_CCS_EXPECTED_MASK               (0x800000U)
#define SDIF_CMD_CCS_EXPECTED_SHIFT              (23U)
/*! CCS_EXPECTED - CCS expected.
 */
#define SDIF_CMD_CCS_EXPECTED(x)                 (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_CCS_EXPECTED_SHIFT)) & SDIF_CMD_CCS_EXPECTED_MASK)
#define SDIF_CMD_ENABLE_BOOT_MASK                (0x1000000U)
#define SDIF_CMD_ENABLE_BOOT_SHIFT               (24U)
/*! ENABLE_BOOT - Enable Boot - this bit should be set only for mandatory boot mode.
 */
#define SDIF_CMD_ENABLE_BOOT(x)                  (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_ENABLE_BOOT_SHIFT)) & SDIF_CMD_ENABLE_BOOT_MASK)
#define SDIF_CMD_EXPECT_BOOT_ACK_MASK            (0x2000000U)
#define SDIF_CMD_EXPECT_BOOT_ACK_SHIFT           (25U)
/*! EXPECT_BOOT_ACK - Expect Boot Acknowledge.
 */
#define SDIF_CMD_EXPECT_BOOT_ACK(x)              (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_EXPECT_BOOT_ACK_SHIFT)) & SDIF_CMD_EXPECT_BOOT_ACK_MASK)
#define SDIF_CMD_DISABLE_BOOT_MASK               (0x4000000U)
#define SDIF_CMD_DISABLE_BOOT_SHIFT              (26U)
/*! DISABLE_BOOT - Disable Boot.
 */
#define SDIF_CMD_DISABLE_BOOT(x)                 (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_DISABLE_BOOT_SHIFT)) & SDIF_CMD_DISABLE_BOOT_MASK)
#define SDIF_CMD_BOOT_MODE_MASK                  (0x8000000U)
#define SDIF_CMD_BOOT_MODE_SHIFT                 (27U)
/*! BOOT_MODE - Boot Mode.
 */
#define SDIF_CMD_BOOT_MODE(x)                    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_BOOT_MODE_SHIFT)) & SDIF_CMD_BOOT_MODE_MASK)
#define SDIF_CMD_VOLT_SWITCH_MASK                (0x10000000U)
#define SDIF_CMD_VOLT_SWITCH_SHIFT               (28U)
/*! VOLT_SWITCH - Voltage switch bit.
 */
#define SDIF_CMD_VOLT_SWITCH(x)                  (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_VOLT_SWITCH_SHIFT)) & SDIF_CMD_VOLT_SWITCH_MASK)
#define SDIF_CMD_USE_HOLD_REG_MASK               (0x20000000U)
#define SDIF_CMD_USE_HOLD_REG_SHIFT              (29U)
/*! USE_HOLD_REG - Use Hold Register.
 */
#define SDIF_CMD_USE_HOLD_REG(x)                 (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_USE_HOLD_REG_SHIFT)) & SDIF_CMD_USE_HOLD_REG_MASK)
#define SDIF_CMD_START_CMD_MASK                  (0x80000000U)
#define SDIF_CMD_START_CMD_SHIFT                 (31U)
/*! START_CMD - Start command.
 */
#define SDIF_CMD_START_CMD(x)                    (((uint32_t)(((uint32_t)(x)) << SDIF_CMD_START_CMD_SHIFT)) & SDIF_CMD_START_CMD_MASK)
/*! @} */

/*! @name RESP - Response register */
/*! @{ */
#define SDIF_RESP_RESPONSE_MASK                  (0xFFFFFFFFU)
#define SDIF_RESP_RESPONSE_SHIFT                 (0U)
/*! RESPONSE - Bits of response.
 */
#define SDIF_RESP_RESPONSE(x)                    (((uint32_t)(((uint32_t)(x)) << SDIF_RESP_RESPONSE_SHIFT)) & SDIF_RESP_RESPONSE_MASK)
/*! @} */

/* The count of SDIF_RESP */
#define SDIF_RESP_COUNT                          (4U)

/*! @name MINTSTS - Masked Interrupt Status register */
/*! @{ */
#define SDIF_MINTSTS_CDET_MASK                   (0x1U)
#define SDIF_MINTSTS_CDET_SHIFT                  (0U)
/*! CDET - Card detect.
 */
#define SDIF_MINTSTS_CDET(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_CDET_SHIFT)) & SDIF_MINTSTS_CDET_MASK)
#define SDIF_MINTSTS_RE_MASK                     (0x2U)
#define SDIF_MINTSTS_RE_SHIFT                    (1U)
/*! RE - Response error.
 */
#define SDIF_MINTSTS_RE(x)                       (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_RE_SHIFT)) & SDIF_MINTSTS_RE_MASK)
#define SDIF_MINTSTS_CDONE_MASK                  (0x4U)
#define SDIF_MINTSTS_CDONE_SHIFT                 (2U)
/*! CDONE - Command done.
 */
#define SDIF_MINTSTS_CDONE(x)                    (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_CDONE_SHIFT)) & SDIF_MINTSTS_CDONE_MASK)
#define SDIF_MINTSTS_DTO_MASK                    (0x8U)
#define SDIF_MINTSTS_DTO_SHIFT                   (3U)
/*! DTO - Data transfer over.
 */
#define SDIF_MINTSTS_DTO(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_DTO_SHIFT)) & SDIF_MINTSTS_DTO_MASK)
#define SDIF_MINTSTS_TXDR_MASK                   (0x10U)
#define SDIF_MINTSTS_TXDR_SHIFT                  (4U)
/*! TXDR - Transmit FIFO data request.
 */
#define SDIF_MINTSTS_TXDR(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_TXDR_SHIFT)) & SDIF_MINTSTS_TXDR_MASK)
#define SDIF_MINTSTS_RXDR_MASK                   (0x20U)
#define SDIF_MINTSTS_RXDR_SHIFT                  (5U)
/*! RXDR - Receive FIFO data request.
 */
#define SDIF_MINTSTS_RXDR(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_RXDR_SHIFT)) & SDIF_MINTSTS_RXDR_MASK)
#define SDIF_MINTSTS_RCRC_MASK                   (0x40U)
#define SDIF_MINTSTS_RCRC_SHIFT                  (6U)
/*! RCRC - Response CRC error.
 */
#define SDIF_MINTSTS_RCRC(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_RCRC_SHIFT)) & SDIF_MINTSTS_RCRC_MASK)
#define SDIF_MINTSTS_DCRC_MASK                   (0x80U)
#define SDIF_MINTSTS_DCRC_SHIFT                  (7U)
/*! DCRC - Data CRC error.
 */
#define SDIF_MINTSTS_DCRC(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_DCRC_SHIFT)) & SDIF_MINTSTS_DCRC_MASK)
#define SDIF_MINTSTS_RTO_MASK                    (0x100U)
#define SDIF_MINTSTS_RTO_SHIFT                   (8U)
/*! RTO - Response time-out.
 */
#define SDIF_MINTSTS_RTO(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_RTO_SHIFT)) & SDIF_MINTSTS_RTO_MASK)
#define SDIF_MINTSTS_DRTO_MASK                   (0x200U)
#define SDIF_MINTSTS_DRTO_SHIFT                  (9U)
/*! DRTO - Data read time-out.
 */
#define SDIF_MINTSTS_DRTO(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_DRTO_SHIFT)) & SDIF_MINTSTS_DRTO_MASK)
#define SDIF_MINTSTS_HTO_MASK                    (0x400U)
#define SDIF_MINTSTS_HTO_SHIFT                   (10U)
/*! HTO - Data starvation-by-host time-out (HTO).
 */
#define SDIF_MINTSTS_HTO(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_HTO_SHIFT)) & SDIF_MINTSTS_HTO_MASK)
#define SDIF_MINTSTS_FRUN_MASK                   (0x800U)
#define SDIF_MINTSTS_FRUN_SHIFT                  (11U)
/*! FRUN - FIFO underrun/overrun error.
 */
#define SDIF_MINTSTS_FRUN(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_FRUN_SHIFT)) & SDIF_MINTSTS_FRUN_MASK)
#define SDIF_MINTSTS_HLE_MASK                    (0x1000U)
#define SDIF_MINTSTS_HLE_SHIFT                   (12U)
/*! HLE - Hardware locked write error.
 */
#define SDIF_MINTSTS_HLE(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_HLE_SHIFT)) & SDIF_MINTSTS_HLE_MASK)
#define SDIF_MINTSTS_SBE_MASK                    (0x2000U)
#define SDIF_MINTSTS_SBE_SHIFT                   (13U)
/*! SBE - Start-bit error.
 */
#define SDIF_MINTSTS_SBE(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_SBE_SHIFT)) & SDIF_MINTSTS_SBE_MASK)
#define SDIF_MINTSTS_ACD_MASK                    (0x4000U)
#define SDIF_MINTSTS_ACD_SHIFT                   (14U)
/*! ACD - Auto command done.
 */
#define SDIF_MINTSTS_ACD(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_ACD_SHIFT)) & SDIF_MINTSTS_ACD_MASK)
#define SDIF_MINTSTS_EBE_MASK                    (0x8000U)
#define SDIF_MINTSTS_EBE_SHIFT                   (15U)
/*! EBE - End-bit error (read)/write no CRC.
 */
#define SDIF_MINTSTS_EBE(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_EBE_SHIFT)) & SDIF_MINTSTS_EBE_MASK)
#define SDIF_MINTSTS_SDIO_INTERRUPT_MASK         (0x10000U)
#define SDIF_MINTSTS_SDIO_INTERRUPT_SHIFT        (16U)
/*! SDIO_INTERRUPT - Interrupt from SDIO card.
 */
#define SDIF_MINTSTS_SDIO_INTERRUPT(x)           (((uint32_t)(((uint32_t)(x)) << SDIF_MINTSTS_SDIO_INTERRUPT_SHIFT)) & SDIF_MINTSTS_SDIO_INTERRUPT_MASK)
/*! @} */

/*! @name RINTSTS - Raw Interrupt Status register */
/*! @{ */
#define SDIF_RINTSTS_CDET_MASK                   (0x1U)
#define SDIF_RINTSTS_CDET_SHIFT                  (0U)
/*! CDET - Card detect.
 */
#define SDIF_RINTSTS_CDET(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_CDET_SHIFT)) & SDIF_RINTSTS_CDET_MASK)
#define SDIF_RINTSTS_RE_MASK                     (0x2U)
#define SDIF_RINTSTS_RE_SHIFT                    (1U)
/*! RE - Response error.
 */
#define SDIF_RINTSTS_RE(x)                       (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_RE_SHIFT)) & SDIF_RINTSTS_RE_MASK)
#define SDIF_RINTSTS_CDONE_MASK                  (0x4U)
#define SDIF_RINTSTS_CDONE_SHIFT                 (2U)
/*! CDONE - Command done.
 */
#define SDIF_RINTSTS_CDONE(x)                    (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_CDONE_SHIFT)) & SDIF_RINTSTS_CDONE_MASK)
#define SDIF_RINTSTS_DTO_MASK                    (0x8U)
#define SDIF_RINTSTS_DTO_SHIFT                   (3U)
/*! DTO - Data transfer over.
 */
#define SDIF_RINTSTS_DTO(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_DTO_SHIFT)) & SDIF_RINTSTS_DTO_MASK)
#define SDIF_RINTSTS_TXDR_MASK                   (0x10U)
#define SDIF_RINTSTS_TXDR_SHIFT                  (4U)
/*! TXDR - Transmit FIFO data request.
 */
#define SDIF_RINTSTS_TXDR(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_TXDR_SHIFT)) & SDIF_RINTSTS_TXDR_MASK)
#define SDIF_RINTSTS_RXDR_MASK                   (0x20U)
#define SDIF_RINTSTS_RXDR_SHIFT                  (5U)
/*! RXDR - Receive FIFO data request.
 */
#define SDIF_RINTSTS_RXDR(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_RXDR_SHIFT)) & SDIF_RINTSTS_RXDR_MASK)
#define SDIF_RINTSTS_RCRC_MASK                   (0x40U)
#define SDIF_RINTSTS_RCRC_SHIFT                  (6U)
/*! RCRC - Response CRC error.
 */
#define SDIF_RINTSTS_RCRC(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_RCRC_SHIFT)) & SDIF_RINTSTS_RCRC_MASK)
#define SDIF_RINTSTS_DCRC_MASK                   (0x80U)
#define SDIF_RINTSTS_DCRC_SHIFT                  (7U)
/*! DCRC - Data CRC error.
 */
#define SDIF_RINTSTS_DCRC(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_DCRC_SHIFT)) & SDIF_RINTSTS_DCRC_MASK)
#define SDIF_RINTSTS_RTO_BAR_MASK                (0x100U)
#define SDIF_RINTSTS_RTO_BAR_SHIFT               (8U)
/*! RTO_BAR - Response time-out (RTO)/Boot Ack Received (BAR).
 */
#define SDIF_RINTSTS_RTO_BAR(x)                  (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_RTO_BAR_SHIFT)) & SDIF_RINTSTS_RTO_BAR_MASK)
#define SDIF_RINTSTS_DRTO_BDS_MASK               (0x200U)
#define SDIF_RINTSTS_DRTO_BDS_SHIFT              (9U)
/*! DRTO_BDS - Data read time-out (DRTO)/Boot Data Start (BDS).
 */
#define SDIF_RINTSTS_DRTO_BDS(x)                 (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_DRTO_BDS_SHIFT)) & SDIF_RINTSTS_DRTO_BDS_MASK)
#define SDIF_RINTSTS_HTO_MASK                    (0x400U)
#define SDIF_RINTSTS_HTO_SHIFT                   (10U)
/*! HTO - Data starvation-by-host time-out (HTO).
 */
#define SDIF_RINTSTS_HTO(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_HTO_SHIFT)) & SDIF_RINTSTS_HTO_MASK)
#define SDIF_RINTSTS_FRUN_MASK                   (0x800U)
#define SDIF_RINTSTS_FRUN_SHIFT                  (11U)
/*! FRUN - FIFO underrun/overrun error.
 */
#define SDIF_RINTSTS_FRUN(x)                     (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_FRUN_SHIFT)) & SDIF_RINTSTS_FRUN_MASK)
#define SDIF_RINTSTS_HLE_MASK                    (0x1000U)
#define SDIF_RINTSTS_HLE_SHIFT                   (12U)
/*! HLE - Hardware locked write error.
 */
#define SDIF_RINTSTS_HLE(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_HLE_SHIFT)) & SDIF_RINTSTS_HLE_MASK)
#define SDIF_RINTSTS_SBE_MASK                    (0x2000U)
#define SDIF_RINTSTS_SBE_SHIFT                   (13U)
/*! SBE - Start-bit error.
 */
#define SDIF_RINTSTS_SBE(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_SBE_SHIFT)) & SDIF_RINTSTS_SBE_MASK)
#define SDIF_RINTSTS_ACD_MASK                    (0x4000U)
#define SDIF_RINTSTS_ACD_SHIFT                   (14U)
/*! ACD - Auto command done.
 */
#define SDIF_RINTSTS_ACD(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_ACD_SHIFT)) & SDIF_RINTSTS_ACD_MASK)
#define SDIF_RINTSTS_EBE_MASK                    (0x8000U)
#define SDIF_RINTSTS_EBE_SHIFT                   (15U)
/*! EBE - End-bit error (read)/write no CRC.
 */
#define SDIF_RINTSTS_EBE(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_EBE_SHIFT)) & SDIF_RINTSTS_EBE_MASK)
#define SDIF_RINTSTS_SDIO_INTERRUPT_MASK         (0x10000U)
#define SDIF_RINTSTS_SDIO_INTERRUPT_SHIFT        (16U)
/*! SDIO_INTERRUPT - Interrupt from SDIO card.
 */
#define SDIF_RINTSTS_SDIO_INTERRUPT(x)           (((uint32_t)(((uint32_t)(x)) << SDIF_RINTSTS_SDIO_INTERRUPT_SHIFT)) & SDIF_RINTSTS_SDIO_INTERRUPT_MASK)
/*! @} */

/*! @name STATUS - Status register */
/*! @{ */
#define SDIF_STATUS_FIFO_RX_WATERMARK_MASK       (0x1U)
#define SDIF_STATUS_FIFO_RX_WATERMARK_SHIFT      (0U)
/*! FIFO_RX_WATERMARK - FIFO reached Receive watermark level; not qualified with data transfer.
 */
#define SDIF_STATUS_FIFO_RX_WATERMARK(x)         (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_FIFO_RX_WATERMARK_SHIFT)) & SDIF_STATUS_FIFO_RX_WATERMARK_MASK)
#define SDIF_STATUS_FIFO_TX_WATERMARK_MASK       (0x2U)
#define SDIF_STATUS_FIFO_TX_WATERMARK_SHIFT      (1U)
/*! FIFO_TX_WATERMARK - FIFO reached Transmit watermark level; not qualified with data transfer.
 */
#define SDIF_STATUS_FIFO_TX_WATERMARK(x)         (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_FIFO_TX_WATERMARK_SHIFT)) & SDIF_STATUS_FIFO_TX_WATERMARK_MASK)
#define SDIF_STATUS_FIFO_EMPTY_MASK              (0x4U)
#define SDIF_STATUS_FIFO_EMPTY_SHIFT             (2U)
/*! FIFO_EMPTY - FIFO is empty status.
 */
#define SDIF_STATUS_FIFO_EMPTY(x)                (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_FIFO_EMPTY_SHIFT)) & SDIF_STATUS_FIFO_EMPTY_MASK)
#define SDIF_STATUS_FIFO_FULL_MASK               (0x8U)
#define SDIF_STATUS_FIFO_FULL_SHIFT              (3U)
/*! FIFO_FULL - FIFO is full status.
 */
#define SDIF_STATUS_FIFO_FULL(x)                 (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_FIFO_FULL_SHIFT)) & SDIF_STATUS_FIFO_FULL_MASK)
#define SDIF_STATUS_CMDFSMSTATES_MASK            (0xF0U)
#define SDIF_STATUS_CMDFSMSTATES_SHIFT           (4U)
/*! CMDFSMSTATES - Command FSM states: 0 - Idle 1 - Send init sequence 2 - Tx cmd start bit 3 - Tx
 *    cmd tx bit 4 - Tx cmd index + arg 5 - Tx cmd crc7 6 - Tx cmd end bit 7 - Rx resp start bit 8 -
 *    Rx resp IRQ response 9 - Rx resp tx bit 10 - Rx resp cmd idx 11 - Rx resp data 12 - Rx resp
 *    crc7 13 - Rx resp end bit 14 - Cmd path wait NCC 15 - Wait; CMD-to-response turnaround NOTE: The
 *    command FSM state is represented using 19 bits.
 */
#define SDIF_STATUS_CMDFSMSTATES(x)              (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_CMDFSMSTATES_SHIFT)) & SDIF_STATUS_CMDFSMSTATES_MASK)
#define SDIF_STATUS_DATA_3_STATUS_MASK           (0x100U)
#define SDIF_STATUS_DATA_3_STATUS_SHIFT          (8U)
/*! DATA_3_STATUS - Raw selected card_data[3]; checks whether card is present 0 - card not present 1 - card present.
 */
#define SDIF_STATUS_DATA_3_STATUS(x)             (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_DATA_3_STATUS_SHIFT)) & SDIF_STATUS_DATA_3_STATUS_MASK)
#define SDIF_STATUS_DATA_BUSY_MASK               (0x200U)
#define SDIF_STATUS_DATA_BUSY_SHIFT              (9U)
/*! DATA_BUSY - Inverted version of raw selected card_data[0] 0 - card data not busy 1 - card data busy.
 */
#define SDIF_STATUS_DATA_BUSY(x)                 (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_DATA_BUSY_SHIFT)) & SDIF_STATUS_DATA_BUSY_MASK)
#define SDIF_STATUS_DATA_STATE_MC_BUSY_MASK      (0x400U)
#define SDIF_STATUS_DATA_STATE_MC_BUSY_SHIFT     (10U)
/*! DATA_STATE_MC_BUSY - Data transmit or receive state-machine is busy.
 */
#define SDIF_STATUS_DATA_STATE_MC_BUSY(x)        (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_DATA_STATE_MC_BUSY_SHIFT)) & SDIF_STATUS_DATA_STATE_MC_BUSY_MASK)
#define SDIF_STATUS_RESPONSE_INDEX_MASK          (0x1F800U)
#define SDIF_STATUS_RESPONSE_INDEX_SHIFT         (11U)
/*! RESPONSE_INDEX - Index of previous response, including any auto-stop sent by core.
 */
#define SDIF_STATUS_RESPONSE_INDEX(x)            (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_RESPONSE_INDEX_SHIFT)) & SDIF_STATUS_RESPONSE_INDEX_MASK)
#define SDIF_STATUS_FIFO_COUNT_MASK              (0x3FFE0000U)
#define SDIF_STATUS_FIFO_COUNT_SHIFT             (17U)
/*! FIFO_COUNT - FIFO count - Number of filled locations in FIFO.
 */
#define SDIF_STATUS_FIFO_COUNT(x)                (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_FIFO_COUNT_SHIFT)) & SDIF_STATUS_FIFO_COUNT_MASK)
#define SDIF_STATUS_DMA_ACK_MASK                 (0x40000000U)
#define SDIF_STATUS_DMA_ACK_SHIFT                (30U)
/*! DMA_ACK - DMA acknowledge signal state.
 */
#define SDIF_STATUS_DMA_ACK(x)                   (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_DMA_ACK_SHIFT)) & SDIF_STATUS_DMA_ACK_MASK)
#define SDIF_STATUS_DMA_REQ_MASK                 (0x80000000U)
#define SDIF_STATUS_DMA_REQ_SHIFT                (31U)
/*! DMA_REQ - DMA request signal state.
 */
#define SDIF_STATUS_DMA_REQ(x)                   (((uint32_t)(((uint32_t)(x)) << SDIF_STATUS_DMA_REQ_SHIFT)) & SDIF_STATUS_DMA_REQ_MASK)
/*! @} */

/*! @name FIFOTH - FIFO Threshold Watermark register */
/*! @{ */
#define SDIF_FIFOTH_TX_WMARK_MASK                (0xFFFU)
#define SDIF_FIFOTH_TX_WMARK_SHIFT               (0U)
/*! TX_WMARK - FIFO threshold watermark level when transmitting data to card.
 */
#define SDIF_FIFOTH_TX_WMARK(x)                  (((uint32_t)(((uint32_t)(x)) << SDIF_FIFOTH_TX_WMARK_SHIFT)) & SDIF_FIFOTH_TX_WMARK_MASK)
#define SDIF_FIFOTH_RX_WMARK_MASK                (0xFFF0000U)
#define SDIF_FIFOTH_RX_WMARK_SHIFT               (16U)
/*! RX_WMARK - FIFO threshold watermark level when receiving data to card.
 */
#define SDIF_FIFOTH_RX_WMARK(x)                  (((uint32_t)(((uint32_t)(x)) << SDIF_FIFOTH_RX_WMARK_SHIFT)) & SDIF_FIFOTH_RX_WMARK_MASK)
#define SDIF_FIFOTH_DMA_MTS_MASK                 (0x70000000U)
#define SDIF_FIFOTH_DMA_MTS_SHIFT                (28U)
/*! DMA_MTS - Burst size of multiple transaction; should be programmed same as DW-DMA controller
 *    multiple-transaction-size SRC/DEST_MSIZE.
 */
#define SDIF_FIFOTH_DMA_MTS(x)                   (((uint32_t)(((uint32_t)(x)) << SDIF_FIFOTH_DMA_MTS_SHIFT)) & SDIF_FIFOTH_DMA_MTS_MASK)
/*! @} */

/*! @name CDETECT - Card Detect register */
/*! @{ */
#define SDIF_CDETECT_CARD_DETECT_MASK            (0x1U)
#define SDIF_CDETECT_CARD_DETECT_SHIFT           (0U)
/*! CARD_DETECT - Card detect.
 */
#define SDIF_CDETECT_CARD_DETECT(x)              (((uint32_t)(((uint32_t)(x)) << SDIF_CDETECT_CARD_DETECT_SHIFT)) & SDIF_CDETECT_CARD_DETECT_MASK)
/*! @} */

/*! @name WRTPRT - Write Protect register */
/*! @{ */
#define SDIF_WRTPRT_WRITE_PROTECT_MASK           (0x1U)
#define SDIF_WRTPRT_WRITE_PROTECT_SHIFT          (0U)
/*! WRITE_PROTECT - Write protect.
 */
#define SDIF_WRTPRT_WRITE_PROTECT(x)             (((uint32_t)(((uint32_t)(x)) << SDIF_WRTPRT_WRITE_PROTECT_SHIFT)) & SDIF_WRTPRT_WRITE_PROTECT_MASK)
/*! @} */

/*! @name TCBCNT - Transferred CIU Card Byte Count register */
/*! @{ */
#define SDIF_TCBCNT_TRANS_CARD_BYTE_COUNT_MASK   (0xFFFFFFFFU)
#define SDIF_TCBCNT_TRANS_CARD_BYTE_COUNT_SHIFT  (0U)
/*! TRANS_CARD_BYTE_COUNT - Number of bytes transferred by CIU unit to card.
 */
#define SDIF_TCBCNT_TRANS_CARD_BYTE_COUNT(x)     (((uint32_t)(((uint32_t)(x)) << SDIF_TCBCNT_TRANS_CARD_BYTE_COUNT_SHIFT)) & SDIF_TCBCNT_TRANS_CARD_BYTE_COUNT_MASK)
/*! @} */

/*! @name TBBCNT - Transferred Host to BIU-FIFO Byte Count register */
/*! @{ */
#define SDIF_TBBCNT_TRANS_FIFO_BYTE_COUNT_MASK   (0xFFFFFFFFU)
#define SDIF_TBBCNT_TRANS_FIFO_BYTE_COUNT_SHIFT  (0U)
/*! TRANS_FIFO_BYTE_COUNT - Number of bytes transferred between Host/DMA memory and BIU FIFO.
 */
#define SDIF_TBBCNT_TRANS_FIFO_BYTE_COUNT(x)     (((uint32_t)(((uint32_t)(x)) << SDIF_TBBCNT_TRANS_FIFO_BYTE_COUNT_SHIFT)) & SDIF_TBBCNT_TRANS_FIFO_BYTE_COUNT_MASK)
/*! @} */

/*! @name DEBNCE - Debounce Count register */
/*! @{ */
#define SDIF_DEBNCE_DEBOUNCE_COUNT_MASK          (0xFFFFFFU)
#define SDIF_DEBNCE_DEBOUNCE_COUNT_SHIFT         (0U)
/*! DEBOUNCE_COUNT - Number of host clocks (SD_CLK) used by debounce filter logic for card detect; typical debounce time is 5-25 ms.
 */
#define SDIF_DEBNCE_DEBOUNCE_COUNT(x)            (((uint32_t)(((uint32_t)(x)) << SDIF_DEBNCE_DEBOUNCE_COUNT_SHIFT)) & SDIF_DEBNCE_DEBOUNCE_COUNT_MASK)
/*! @} */

/*! @name RST_N - Hardware Reset */
/*! @{ */
#define SDIF_RST_N_CARD_RESET_MASK               (0x1U)
#define SDIF_RST_N_CARD_RESET_SHIFT              (0U)
/*! CARD_RESET - Hardware reset.
 */
#define SDIF_RST_N_CARD_RESET(x)                 (((uint32_t)(((uint32_t)(x)) << SDIF_RST_N_CARD_RESET_SHIFT)) & SDIF_RST_N_CARD_RESET_MASK)
/*! @} */

/*! @name BMOD - Bus Mode register */
/*! @{ */
#define SDIF_BMOD_SWR_MASK                       (0x1U)
#define SDIF_BMOD_SWR_SHIFT                      (0U)
/*! SWR - Software Reset.
 */
#define SDIF_BMOD_SWR(x)                         (((uint32_t)(((uint32_t)(x)) << SDIF_BMOD_SWR_SHIFT)) & SDIF_BMOD_SWR_MASK)
#define SDIF_BMOD_FB_MASK                        (0x2U)
#define SDIF_BMOD_FB_SHIFT                       (1U)
/*! FB - Fixed Burst.
 */
#define SDIF_BMOD_FB(x)                          (((uint32_t)(((uint32_t)(x)) << SDIF_BMOD_FB_SHIFT)) & SDIF_BMOD_FB_MASK)
#define SDIF_BMOD_DSL_MASK                       (0x7CU)
#define SDIF_BMOD_DSL_SHIFT                      (2U)
/*! DSL - Descriptor Skip Length.
 */
#define SDIF_BMOD_DSL(x)                         (((uint32_t)(((uint32_t)(x)) << SDIF_BMOD_DSL_SHIFT)) & SDIF_BMOD_DSL_MASK)
#define SDIF_BMOD_DE_MASK                        (0x80U)
#define SDIF_BMOD_DE_SHIFT                       (7U)
/*! DE - SD/MMC DMA Enable.
 */
#define SDIF_BMOD_DE(x)                          (((uint32_t)(((uint32_t)(x)) << SDIF_BMOD_DE_SHIFT)) & SDIF_BMOD_DE_MASK)
#define SDIF_BMOD_PBL_MASK                       (0x700U)
#define SDIF_BMOD_PBL_SHIFT                      (8U)
/*! PBL - Programmable Burst Length.
 */
#define SDIF_BMOD_PBL(x)                         (((uint32_t)(((uint32_t)(x)) << SDIF_BMOD_PBL_SHIFT)) & SDIF_BMOD_PBL_MASK)
/*! @} */

/*! @name PLDMND - Poll Demand register */
/*! @{ */
#define SDIF_PLDMND_PD_MASK                      (0xFFFFFFFFU)
#define SDIF_PLDMND_PD_SHIFT                     (0U)
/*! PD - Poll Demand.
 */
#define SDIF_PLDMND_PD(x)                        (((uint32_t)(((uint32_t)(x)) << SDIF_PLDMND_PD_SHIFT)) & SDIF_PLDMND_PD_MASK)
/*! @} */

/*! @name DBADDR - Descriptor List Base Address register */
/*! @{ */
#define SDIF_DBADDR_SDL_MASK                     (0xFFFFFFFFU)
#define SDIF_DBADDR_SDL_SHIFT                    (0U)
/*! SDL - Start of Descriptor List.
 */
#define SDIF_DBADDR_SDL(x)                       (((uint32_t)(((uint32_t)(x)) << SDIF_DBADDR_SDL_SHIFT)) & SDIF_DBADDR_SDL_MASK)
/*! @} */

/*! @name IDSTS - Internal DMAC Status register */
/*! @{ */
#define SDIF_IDSTS_TI_MASK                       (0x1U)
#define SDIF_IDSTS_TI_SHIFT                      (0U)
/*! TI - Transmit Interrupt.
 */
#define SDIF_IDSTS_TI(x)                         (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_TI_SHIFT)) & SDIF_IDSTS_TI_MASK)
#define SDIF_IDSTS_RI_MASK                       (0x2U)
#define SDIF_IDSTS_RI_SHIFT                      (1U)
/*! RI - Receive Interrupt.
 */
#define SDIF_IDSTS_RI(x)                         (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_RI_SHIFT)) & SDIF_IDSTS_RI_MASK)
#define SDIF_IDSTS_FBE_MASK                      (0x4U)
#define SDIF_IDSTS_FBE_SHIFT                     (2U)
/*! FBE - Fatal Bus Error Interrupt.
 */
#define SDIF_IDSTS_FBE(x)                        (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_FBE_SHIFT)) & SDIF_IDSTS_FBE_MASK)
#define SDIF_IDSTS_DU_MASK                       (0x10U)
#define SDIF_IDSTS_DU_SHIFT                      (4U)
/*! DU - Descriptor Unavailable Interrupt.
 */
#define SDIF_IDSTS_DU(x)                         (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_DU_SHIFT)) & SDIF_IDSTS_DU_MASK)
#define SDIF_IDSTS_CES_MASK                      (0x20U)
#define SDIF_IDSTS_CES_SHIFT                     (5U)
/*! CES - Card Error Summary.
 */
#define SDIF_IDSTS_CES(x)                        (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_CES_SHIFT)) & SDIF_IDSTS_CES_MASK)
#define SDIF_IDSTS_NIS_MASK                      (0x100U)
#define SDIF_IDSTS_NIS_SHIFT                     (8U)
/*! NIS - Normal Interrupt Summary.
 */
#define SDIF_IDSTS_NIS(x)                        (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_NIS_SHIFT)) & SDIF_IDSTS_NIS_MASK)
#define SDIF_IDSTS_AIS_MASK                      (0x200U)
#define SDIF_IDSTS_AIS_SHIFT                     (9U)
/*! AIS - Abnormal Interrupt Summary.
 */
#define SDIF_IDSTS_AIS(x)                        (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_AIS_SHIFT)) & SDIF_IDSTS_AIS_MASK)
#define SDIF_IDSTS_EB_MASK                       (0x1C00U)
#define SDIF_IDSTS_EB_SHIFT                      (10U)
/*! EB - Error Bits.
 */
#define SDIF_IDSTS_EB(x)                         (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_EB_SHIFT)) & SDIF_IDSTS_EB_MASK)
#define SDIF_IDSTS_FSM_MASK                      (0x1E000U)
#define SDIF_IDSTS_FSM_SHIFT                     (13U)
/*! FSM - DMAC state machine present state.
 */
#define SDIF_IDSTS_FSM(x)                        (((uint32_t)(((uint32_t)(x)) << SDIF_IDSTS_FSM_SHIFT)) & SDIF_IDSTS_FSM_MASK)
/*! @} */

/*! @name IDINTEN - Internal DMAC Interrupt Enable register */
/*! @{ */
#define SDIF_IDINTEN_TI_MASK                     (0x1U)
#define SDIF_IDINTEN_TI_SHIFT                    (0U)
/*! TI - Transmit Interrupt Enable.
 */
#define SDIF_IDINTEN_TI(x)                       (((uint32_t)(((uint32_t)(x)) << SDIF_IDINTEN_TI_SHIFT)) & SDIF_IDINTEN_TI_MASK)
#define SDIF_IDINTEN_RI_MASK                     (0x2U)
#define SDIF_IDINTEN_RI_SHIFT                    (1U)
/*! RI - Receive Interrupt Enable.
 */
#define SDIF_IDINTEN_RI(x)                       (((uint32_t)(((uint32_t)(x)) << SDIF_IDINTEN_RI_SHIFT)) & SDIF_IDINTEN_RI_MASK)
#define SDIF_IDINTEN_FBE_MASK                    (0x4U)
#define SDIF_IDINTEN_FBE_SHIFT                   (2U)
/*! FBE - Fatal Bus Error Enable.
 */
#define SDIF_IDINTEN_FBE(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_IDINTEN_FBE_SHIFT)) & SDIF_IDINTEN_FBE_MASK)
#define SDIF_IDINTEN_DU_MASK                     (0x10U)
#define SDIF_IDINTEN_DU_SHIFT                    (4U)
/*! DU - Descriptor Unavailable Interrupt.
 */
#define SDIF_IDINTEN_DU(x)                       (((uint32_t)(((uint32_t)(x)) << SDIF_IDINTEN_DU_SHIFT)) & SDIF_IDINTEN_DU_MASK)
#define SDIF_IDINTEN_CES_MASK                    (0x20U)
#define SDIF_IDINTEN_CES_SHIFT                   (5U)
/*! CES - Card Error summary Interrupt Enable.
 */
#define SDIF_IDINTEN_CES(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_IDINTEN_CES_SHIFT)) & SDIF_IDINTEN_CES_MASK)
#define SDIF_IDINTEN_NIS_MASK                    (0x100U)
#define SDIF_IDINTEN_NIS_SHIFT                   (8U)
/*! NIS - Normal Interrupt Summary Enable.
 */
#define SDIF_IDINTEN_NIS(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_IDINTEN_NIS_SHIFT)) & SDIF_IDINTEN_NIS_MASK)
#define SDIF_IDINTEN_AIS_MASK                    (0x200U)
#define SDIF_IDINTEN_AIS_SHIFT                   (9U)
/*! AIS - Abnormal Interrupt Summary Enable.
 */
#define SDIF_IDINTEN_AIS(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_IDINTEN_AIS_SHIFT)) & SDIF_IDINTEN_AIS_MASK)
/*! @} */

/*! @name DSCADDR - Current Host Descriptor Address register */
/*! @{ */
#define SDIF_DSCADDR_HDA_MASK                    (0xFFFFFFFFU)
#define SDIF_DSCADDR_HDA_SHIFT                   (0U)
/*! HDA - Host Descriptor Address Pointer.
 */
#define SDIF_DSCADDR_HDA(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_DSCADDR_HDA_SHIFT)) & SDIF_DSCADDR_HDA_MASK)
/*! @} */

/*! @name BUFADDR - Current Buffer Descriptor Address register */
/*! @{ */
#define SDIF_BUFADDR_HBA_MASK                    (0xFFFFFFFFU)
#define SDIF_BUFADDR_HBA_SHIFT                   (0U)
/*! HBA - Host Buffer Address Pointer.
 */
#define SDIF_BUFADDR_HBA(x)                      (((uint32_t)(((uint32_t)(x)) << SDIF_BUFADDR_HBA_SHIFT)) & SDIF_BUFADDR_HBA_MASK)
/*! @} */

/*! @name CARDTHRCTL - Card Threshold Control */
/*! @{ */
#define SDIF_CARDTHRCTL_CARDRDTHREN_MASK         (0x1U)
#define SDIF_CARDTHRCTL_CARDRDTHREN_SHIFT        (0U)
/*! CARDRDTHREN - Card Read Threshold Enable.
 */
#define SDIF_CARDTHRCTL_CARDRDTHREN(x)           (((uint32_t)(((uint32_t)(x)) << SDIF_CARDTHRCTL_CARDRDTHREN_SHIFT)) & SDIF_CARDTHRCTL_CARDRDTHREN_MASK)
#define SDIF_CARDTHRCTL_BSYCLRINTEN_MASK         (0x2U)
#define SDIF_CARDTHRCTL_BSYCLRINTEN_SHIFT        (1U)
/*! BSYCLRINTEN - Busy Clear Interrupt Enable.
 */
#define SDIF_CARDTHRCTL_BSYCLRINTEN(x)           (((uint32_t)(((uint32_t)(x)) << SDIF_CARDTHRCTL_BSYCLRINTEN_SHIFT)) & SDIF_CARDTHRCTL_BSYCLRINTEN_MASK)
#define SDIF_CARDTHRCTL_CARDTHRESHOLD_MASK       (0xFF0000U)
#define SDIF_CARDTHRCTL_CARDTHRESHOLD_SHIFT      (16U)
/*! CARDTHRESHOLD - Card Threshold size.
 */
#define SDIF_CARDTHRCTL_CARDTHRESHOLD(x)         (((uint32_t)(((uint32_t)(x)) << SDIF_CARDTHRCTL_CARDTHRESHOLD_SHIFT)) & SDIF_CARDTHRCTL_CARDTHRESHOLD_MASK)
/*! @} */

/*! @name BACKENDPWR - Power control */
/*! @{ */
#define SDIF_BACKENDPWR_BACKENDPWR_MASK          (0x1U)
#define SDIF_BACKENDPWR_BACKENDPWR_SHIFT         (0U)
/*! BACKENDPWR - Back-end Power control for card application.
 */
#define SDIF_BACKENDPWR_BACKENDPWR(x)            (((uint32_t)(((uint32_t)(x)) << SDIF_BACKENDPWR_BACKENDPWR_SHIFT)) & SDIF_BACKENDPWR_BACKENDPWR_MASK)
/*! @} */

/*! @name FIFO - SDIF FIFO */
/*! @{ */
#define SDIF_FIFO_DATA_MASK                      (0xFFFFFFFFU)
#define SDIF_FIFO_DATA_SHIFT                     (0U)
/*! DATA - SDIF FIFO.
 */
#define SDIF_FIFO_DATA(x)                        (((uint32_t)(((uint32_t)(x)) << SDIF_FIFO_DATA_SHIFT)) & SDIF_FIFO_DATA_MASK)
/*! @} */

/* The count of SDIF_FIFO */
#define SDIF_FIFO_COUNT                          (64U)


/*!
 * @}
 */ /* end of group SDIF_Register_Masks */


/* SDIF - Peripheral instance base addresses */
/** Peripheral SDIF base address */
#define SDIF_BASE                                (0x4009B000u)
/** Peripheral SDIF base pointer */
#define SDIF                                     ((SDIF_Type *)SDIF_BASE)
/** Array initializer of SDIF peripheral base addresses */
#define SDIF_BASE_ADDRS                          { SDIF_BASE }
/** Array initializer of SDIF peripheral base pointers */
#define SDIF_BASE_PTRS                           { SDIF }
/** Interrupt vectors for the SDIF peripheral type */
#define SDIF_IRQS                                { SDIO_IRQn }

/*!
 * @}
 */ /* end of group SDIF_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- SHA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SHA_Peripheral_Access_Layer SHA Peripheral Access Layer
 * @{
 */

/** SHA - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< Control register, offset: 0x0 */
  __IO uint32_t STATUS;                            /**< Status register, offset: 0x4 */
  __IO uint32_t INTENSET;                          /**< Interrupt Enable register, offset: 0x8 */
  __O  uint32_t INTENCLR;                          /**< Interrupt Clear register, offset: 0xC */
  __IO uint32_t MEMCTRL;                           /**< Memory Control register, offset: 0x10 */
  __IO uint32_t MEMADDR;                           /**< Memory Address register, offset: 0x14 */
       uint8_t RESERVED_0[8];
  __O  uint32_t INDATA;                            /**< Input Data register, offset: 0x20 */
  __O  uint32_t ALIAS[7];                          /**< Alias register, array offset: 0x24, array step: 0x4 */
  __I  uint32_t DIGEST[8];                         /**< Digest register, array offset: 0x40, array step: 0x4 */
} SHA_Type;

/* ----------------------------------------------------------------------------
   -- SHA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SHA_Register_Masks SHA Register Masks
 * @{
 */

/*! @name CTRL - Control register */
/*! @{ */
#define SHA_CTRL_MODE_MASK                       (0x3U)
#define SHA_CTRL_MODE_SHIFT                      (0U)
/*! MODE - This field is used to select the operational mode of SHA block.
 */
#define SHA_CTRL_MODE(x)                         (((uint32_t)(((uint32_t)(x)) << SHA_CTRL_MODE_SHIFT)) & SHA_CTRL_MODE_MASK)
#define SHA_CTRL_NEW_MASK                        (0x10U)
#define SHA_CTRL_NEW_SHIFT                       (4U)
/*! NEW - When this bit is set, a new hash operation is started.
 */
#define SHA_CTRL_NEW(x)                          (((uint32_t)(((uint32_t)(x)) << SHA_CTRL_NEW_SHIFT)) & SHA_CTRL_NEW_MASK)
#define SHA_CTRL_DMA_MASK                        (0x100U)
#define SHA_CTRL_DMA_SHIFT                       (8U)
/*! DMA - When this bit is set, the DMA is used to fill INDATA.
 */
#define SHA_CTRL_DMA(x)                          (((uint32_t)(((uint32_t)(x)) << SHA_CTRL_DMA_SHIFT)) & SHA_CTRL_DMA_MASK)
/*! @} */

/*! @name STATUS - Status register */
/*! @{ */
#define SHA_STATUS_WAITING_MASK                  (0x1U)
#define SHA_STATUS_WAITING_SHIFT                 (0U)
/*! WAITING - This field indicates if the block is waiting for more data to process.
 */
#define SHA_STATUS_WAITING(x)                    (((uint32_t)(((uint32_t)(x)) << SHA_STATUS_WAITING_SHIFT)) & SHA_STATUS_WAITING_MASK)
#define SHA_STATUS_DIGEST_MASK                   (0x2U)
#define SHA_STATUS_DIGEST_SHIFT                  (1U)
/*! DIGEST - This field indicates if a DIGEST is ready and waiting and there is no active next block that has already started.
 */
#define SHA_STATUS_DIGEST(x)                     (((uint32_t)(((uint32_t)(x)) << SHA_STATUS_DIGEST_SHIFT)) & SHA_STATUS_DIGEST_MASK)
#define SHA_STATUS_ERROR_MASK                    (0x4U)
#define SHA_STATUS_ERROR_SHIFT                   (2U)
/*! ERROR - This field indicates if an error has occurred.
 */
#define SHA_STATUS_ERROR(x)                      (((uint32_t)(((uint32_t)(x)) << SHA_STATUS_ERROR_SHIFT)) & SHA_STATUS_ERROR_MASK)
/*! @} */

/*! @name INTENSET - Interrupt Enable register */
/*! @{ */
#define SHA_INTENSET_WAITING_MASK                (0x1U)
#define SHA_INTENSET_WAITING_SHIFT               (0U)
/*! WAITING - This field indicates if interrupt should be enabled when waiting for input data.
 */
#define SHA_INTENSET_WAITING(x)                  (((uint32_t)(((uint32_t)(x)) << SHA_INTENSET_WAITING_SHIFT)) & SHA_INTENSET_WAITING_MASK)
#define SHA_INTENSET_DIGEST_MASK                 (0x2U)
#define SHA_INTENSET_DIGEST_SHIFT                (1U)
/*! DIGEST - This field indicates if interrupt is generated when Digest is ready (completed a Hash or completed a full sequence).
 */
#define SHA_INTENSET_DIGEST(x)                   (((uint32_t)(((uint32_t)(x)) << SHA_INTENSET_DIGEST_SHIFT)) & SHA_INTENSET_DIGEST_MASK)
#define SHA_INTENSET_ERROR_MASK                  (0x4U)
#define SHA_INTENSET_ERROR_SHIFT                 (2U)
/*! ERROR - This field indicates if interrupt is generated on an ERROR (as defined in STAT register).
 */
#define SHA_INTENSET_ERROR(x)                    (((uint32_t)(((uint32_t)(x)) << SHA_INTENSET_ERROR_SHIFT)) & SHA_INTENSET_ERROR_MASK)
/*! @} */

/*! @name INTENCLR - Interrupt Clear register */
/*! @{ */
#define SHA_INTENCLR_WAITING_MASK                (0x1U)
#define SHA_INTENCLR_WAITING_SHIFT               (0U)
/*! WAITING - Writing a 1 clears the interrupt enabled by the INTENSET register.
 */
#define SHA_INTENCLR_WAITING(x)                  (((uint32_t)(((uint32_t)(x)) << SHA_INTENCLR_WAITING_SHIFT)) & SHA_INTENCLR_WAITING_MASK)
#define SHA_INTENCLR_DIGEST_MASK                 (0x2U)
#define SHA_INTENCLR_DIGEST_SHIFT                (1U)
/*! DIGEST - Writing a 1 clears the interrupt enabled by the INTENSET register.
 */
#define SHA_INTENCLR_DIGEST(x)                   (((uint32_t)(((uint32_t)(x)) << SHA_INTENCLR_DIGEST_SHIFT)) & SHA_INTENCLR_DIGEST_MASK)
#define SHA_INTENCLR_ERROR_MASK                  (0x4U)
#define SHA_INTENCLR_ERROR_SHIFT                 (2U)
/*! ERROR - Writing a 1 clears the interrupt enabled by the INTENSET register.
 */
#define SHA_INTENCLR_ERROR(x)                    (((uint32_t)(((uint32_t)(x)) << SHA_INTENCLR_ERROR_SHIFT)) & SHA_INTENCLR_ERROR_MASK)
/*! @} */

/*! @name MEMCTRL - Memory Control register */
/*! @{ */
#define SHA_MEMCTRL_MASTER_MASK                  (0x1U)
#define SHA_MEMCTRL_MASTER_SHIFT                 (0U)
/*! MASTER - This field is used to enable SHA block as AHB bus master.
 */
#define SHA_MEMCTRL_MASTER(x)                    (((uint32_t)(((uint32_t)(x)) << SHA_MEMCTRL_MASTER_SHIFT)) & SHA_MEMCTRL_MASTER_MASK)
#define SHA_MEMCTRL_COUNT_MASK                   (0x7FF0000U)
#define SHA_MEMCTRL_COUNT_SHIFT                  (16U)
/*! COUNT - This field indicates the number of 512-bit blocks to copy starting at MEMADDR.
 */
#define SHA_MEMCTRL_COUNT(x)                     (((uint32_t)(((uint32_t)(x)) << SHA_MEMCTRL_COUNT_SHIFT)) & SHA_MEMCTRL_COUNT_MASK)
/*! @} */

/*! @name MEMADDR - Memory Address register */
/*! @{ */
#define SHA_MEMADDR_BASEADDR_MASK                (0xFFFFFFFFU)
#define SHA_MEMADDR_BASEADDR_SHIFT               (0U)
/*! BASEADDR - This field indicates the base address in Internal Flash, SRAM0, SRAMX, or SPIFI to start copying from.
 */
#define SHA_MEMADDR_BASEADDR(x)                  (((uint32_t)(((uint32_t)(x)) << SHA_MEMADDR_BASEADDR_SHIFT)) & SHA_MEMADDR_BASEADDR_MASK)
/*! @} */

/*! @name INDATA - Input Data register */
/*! @{ */
#define SHA_INDATA_DATA_MASK                     (0xFFFFFFFFU)
#define SHA_INDATA_DATA_SHIFT                    (0U)
/*! DATA - In this field the next word is written in little-endian format.
 */
#define SHA_INDATA_DATA(x)                       (((uint32_t)(((uint32_t)(x)) << SHA_INDATA_DATA_SHIFT)) & SHA_INDATA_DATA_MASK)
/*! @} */

/*! @name ALIAS - Alias register */
/*! @{ */
#define SHA_ALIAS_DATA_MASK                      (0xFFFFFFFFU)
#define SHA_ALIAS_DATA_SHIFT                     (0U)
/*! DATA - In this field the next word is written in little-endian format.
 */
#define SHA_ALIAS_DATA(x)                        (((uint32_t)(((uint32_t)(x)) << SHA_ALIAS_DATA_SHIFT)) & SHA_ALIAS_DATA_MASK)
/*! @} */

/* The count of SHA_ALIAS */
#define SHA_ALIAS_COUNT                          (7U)

/*! @name DIGEST - Digest register */
/*! @{ */
#define SHA_DIGEST_DIGEST_MASK                   (0xFFFFFFFFU)
#define SHA_DIGEST_DIGEST_SHIFT                  (0U)
/*! DIGEST - This field contains one word of the Digest.
 */
#define SHA_DIGEST_DIGEST(x)                     (((uint32_t)(((uint32_t)(x)) << SHA_DIGEST_DIGEST_SHIFT)) & SHA_DIGEST_DIGEST_MASK)
/*! @} */

/* The count of SHA_DIGEST */
#define SHA_DIGEST_COUNT                         (8U)


/*!
 * @}
 */ /* end of group SHA_Register_Masks */


/* SHA - Peripheral instance base addresses */
/** Peripheral SHA0 base address */
#define SHA0_BASE                                (0x400A4000u)
/** Peripheral SHA0 base pointer */
#define SHA0                                     ((SHA_Type *)SHA0_BASE)
/** Array initializer of SHA peripheral base addresses */
#define SHA_BASE_ADDRS                           { SHA0_BASE }
/** Array initializer of SHA peripheral base pointers */
#define SHA_BASE_PTRS                            { SHA0 }

/*!
 * @}
 */ /* end of group SHA_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- SMARTCARD Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SMARTCARD_Peripheral_Access_Layer SMARTCARD Peripheral Access Layer
 * @{
 */

/** SMARTCARD - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    __IO uint32_t DLL;                               /**< Divisor Latch LSB, offset: 0x0 */
    __I  uint32_t RBR;                               /**< Receiver Buffer Register, offset: 0x0 */
    __O  uint32_t THR;                               /**< Transmit Holding Register, offset: 0x0 */
  };
  union {                                          /* offset: 0x4 */
    __IO uint32_t DLM;                               /**< Divisor Latch MSB, offset: 0x4 */
    __IO uint32_t IER;                               /**< Interrupt Enable Register, offset: 0x4 */
  };
  union {                                          /* offset: 0x8 */
    __O  uint32_t FCR;                               /**< FIFO Control Register, offset: 0x8 */
    __I  uint32_t IIR;                               /**< Interrupt ID Register, offset: 0x8 */
  };
  __IO uint32_t LCR;                               /**< Line Control Register, offset: 0xC */
       uint8_t RESERVED_0[4];
  __I  uint32_t LSR;                               /**< Line Status Register, offset: 0x14 */
       uint8_t RESERVED_1[4];
  __IO uint32_t SCR;                               /**< Scratch Pad Register, offset: 0x1C */
       uint8_t RESERVED_2[12];
  __IO uint32_t OSR;                               /**< Oversampling register, offset: 0x2C */
       uint8_t RESERVED_3[24];
  __IO uint32_t SCICTRL;                           /**< Smart Card Interface control register, offset: 0x48 */
} SMARTCARD_Type;

/* ----------------------------------------------------------------------------
   -- SMARTCARD Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SMARTCARD_Register_Masks SMARTCARD Register Masks
 * @{
 */

/*! @name DLL - Divisor Latch LSB */
/*! @{ */
#define SMARTCARD_DLL_DLLSB_MASK                 (0xFFU)
#define SMARTCARD_DLL_DLLSB_SHIFT                (0U)
/*! DLLSB - The SCIn Divisor Latch LSB Register, along with the SCInDLM register, determines the baud rate of the SCIn.
 */
#define SMARTCARD_DLL_DLLSB(x)                   (((uint32_t)(((uint32_t)(x)) << SMARTCARD_DLL_DLLSB_SHIFT)) & SMARTCARD_DLL_DLLSB_MASK)
/*! @} */

/*! @name RBR - Receiver Buffer Register */
/*! @{ */
#define SMARTCARD_RBR_RBR_MASK                   (0xFFU)
#define SMARTCARD_RBR_RBR_SHIFT                  (0U)
/*! RBR - The SCIn Receiver Buffer Register contains the oldest received byte in the SCIn Rx FIFO.
 */
#define SMARTCARD_RBR_RBR(x)                     (((uint32_t)(((uint32_t)(x)) << SMARTCARD_RBR_RBR_SHIFT)) & SMARTCARD_RBR_RBR_MASK)
/*! @} */

/*! @name THR - Transmit Holding Register */
/*! @{ */
#define SMARTCARD_THR_THR_MASK                   (0xFFU)
#define SMARTCARD_THR_THR_SHIFT                  (0U)
/*! THR - Writing to the SCIn Transmit Holding Register causes the data to be stored in the SCIn transmit FIFO.
 */
#define SMARTCARD_THR_THR(x)                     (((uint32_t)(((uint32_t)(x)) << SMARTCARD_THR_THR_SHIFT)) & SMARTCARD_THR_THR_MASK)
/*! @} */

/*! @name DLM - Divisor Latch MSB */
/*! @{ */
#define SMARTCARD_DLM_DLMSB_MASK                 (0xFFU)
#define SMARTCARD_DLM_DLMSB_SHIFT                (0U)
/*! DLMSB - The SCIn Divisor Latch MSB Register, along with the DLL register, determines the baud rate of the SCIn.
 */
#define SMARTCARD_DLM_DLMSB(x)                   (((uint32_t)(((uint32_t)(x)) << SMARTCARD_DLM_DLMSB_SHIFT)) & SMARTCARD_DLM_DLMSB_MASK)
/*! @} */

/*! @name IER - Interrupt Enable Register */
/*! @{ */
#define SMARTCARD_IER_RBRIE_MASK                 (0x1U)
#define SMARTCARD_IER_RBRIE_SHIFT                (0U)
/*! RBRIE - RBR Interrupt Enable.
 */
#define SMARTCARD_IER_RBRIE(x)                   (((uint32_t)(((uint32_t)(x)) << SMARTCARD_IER_RBRIE_SHIFT)) & SMARTCARD_IER_RBRIE_MASK)
#define SMARTCARD_IER_THREIE_MASK                (0x2U)
#define SMARTCARD_IER_THREIE_SHIFT               (1U)
/*! THREIE - THRE Interrupt Enable.
 */
#define SMARTCARD_IER_THREIE(x)                  (((uint32_t)(((uint32_t)(x)) << SMARTCARD_IER_THREIE_SHIFT)) & SMARTCARD_IER_THREIE_MASK)
#define SMARTCARD_IER_RXIE_MASK                  (0x4U)
#define SMARTCARD_IER_RXIE_SHIFT                 (2U)
/*! RXIE - RX Line Status Interrupt Enable.
 */
#define SMARTCARD_IER_RXIE(x)                    (((uint32_t)(((uint32_t)(x)) << SMARTCARD_IER_RXIE_SHIFT)) & SMARTCARD_IER_RXIE_MASK)
/*! @} */

/*! @name FCR - FIFO Control Register */
/*! @{ */
#define SMARTCARD_FCR_FIFOEN_MASK                (0x1U)
#define SMARTCARD_FCR_FIFOEN_SHIFT               (0U)
/*! FIFOEN - FIFO Enable.
 */
#define SMARTCARD_FCR_FIFOEN(x)                  (((uint32_t)(((uint32_t)(x)) << SMARTCARD_FCR_FIFOEN_SHIFT)) & SMARTCARD_FCR_FIFOEN_MASK)
#define SMARTCARD_FCR_RXFIFORES_MASK             (0x2U)
#define SMARTCARD_FCR_RXFIFORES_SHIFT            (1U)
/*! RXFIFORES - RX FIFO Reset.
 */
#define SMARTCARD_FCR_RXFIFORES(x)               (((uint32_t)(((uint32_t)(x)) << SMARTCARD_FCR_RXFIFORES_SHIFT)) & SMARTCARD_FCR_RXFIFORES_MASK)
#define SMARTCARD_FCR_TXFIFORES_MASK             (0x4U)
#define SMARTCARD_FCR_TXFIFORES_SHIFT            (2U)
/*! TXFIFORES - TX FIFO Reset.
 */
#define SMARTCARD_FCR_TXFIFORES(x)               (((uint32_t)(((uint32_t)(x)) << SMARTCARD_FCR_TXFIFORES_SHIFT)) & SMARTCARD_FCR_TXFIFORES_MASK)
#define SMARTCARD_FCR_DMAMODE_MASK               (0x8U)
#define SMARTCARD_FCR_DMAMODE_SHIFT              (3U)
/*! DMAMODE - DMA Mode Select.
 */
#define SMARTCARD_FCR_DMAMODE(x)                 (((uint32_t)(((uint32_t)(x)) << SMARTCARD_FCR_DMAMODE_SHIFT)) & SMARTCARD_FCR_DMAMODE_MASK)
#define SMARTCARD_FCR_RXTRIGLVL_MASK             (0xC0U)
#define SMARTCARD_FCR_RXTRIGLVL_SHIFT            (6U)
/*! RXTRIGLVL - RX Trigger Level.
 */
#define SMARTCARD_FCR_RXTRIGLVL(x)               (((uint32_t)(((uint32_t)(x)) << SMARTCARD_FCR_RXTRIGLVL_SHIFT)) & SMARTCARD_FCR_RXTRIGLVL_MASK)
/*! @} */

/*! @name IIR - Interrupt ID Register */
/*! @{ */
#define SMARTCARD_IIR_INTSTATUS_MASK             (0x1U)
#define SMARTCARD_IIR_INTSTATUS_SHIFT            (0U)
/*! INTSTATUS - Interrupt status.
 */
#define SMARTCARD_IIR_INTSTATUS(x)               (((uint32_t)(((uint32_t)(x)) << SMARTCARD_IIR_INTSTATUS_SHIFT)) & SMARTCARD_IIR_INTSTATUS_MASK)
#define SMARTCARD_IIR_INTID_MASK                 (0xEU)
#define SMARTCARD_IIR_INTID_SHIFT                (1U)
/*! INTID - Interrupt identification.
 */
#define SMARTCARD_IIR_INTID(x)                   (((uint32_t)(((uint32_t)(x)) << SMARTCARD_IIR_INTID_SHIFT)) & SMARTCARD_IIR_INTID_MASK)
#define SMARTCARD_IIR_FIFOENABLE_MASK            (0xC0U)
#define SMARTCARD_IIR_FIFOENABLE_SHIFT           (6U)
/*! FIFOENABLE - Copies of SCInFCR[0].
 */
#define SMARTCARD_IIR_FIFOENABLE(x)              (((uint32_t)(((uint32_t)(x)) << SMARTCARD_IIR_FIFOENABLE_SHIFT)) & SMARTCARD_IIR_FIFOENABLE_MASK)
/*! @} */

/*! @name LCR - Line Control Register */
/*! @{ */
#define SMARTCARD_LCR_WLS_MASK                   (0x3U)
#define SMARTCARD_LCR_WLS_SHIFT                  (0U)
/*! WLS - Word Length Select.
 */
#define SMARTCARD_LCR_WLS(x)                     (((uint32_t)(((uint32_t)(x)) << SMARTCARD_LCR_WLS_SHIFT)) & SMARTCARD_LCR_WLS_MASK)
#define SMARTCARD_LCR_SBS_MASK                   (0x4U)
#define SMARTCARD_LCR_SBS_SHIFT                  (2U)
/*! SBS - Stop Bit Select.
 */
#define SMARTCARD_LCR_SBS(x)                     (((uint32_t)(((uint32_t)(x)) << SMARTCARD_LCR_SBS_SHIFT)) & SMARTCARD_LCR_SBS_MASK)
#define SMARTCARD_LCR_PE_MASK                    (0x8U)
#define SMARTCARD_LCR_PE_SHIFT                   (3U)
/*! PE - Parity Enable.
 */
#define SMARTCARD_LCR_PE(x)                      (((uint32_t)(((uint32_t)(x)) << SMARTCARD_LCR_PE_SHIFT)) & SMARTCARD_LCR_PE_MASK)
#define SMARTCARD_LCR_PS_MASK                    (0x30U)
#define SMARTCARD_LCR_PS_SHIFT                   (4U)
/*! PS - Parity Select.
 */
#define SMARTCARD_LCR_PS(x)                      (((uint32_t)(((uint32_t)(x)) << SMARTCARD_LCR_PS_SHIFT)) & SMARTCARD_LCR_PS_MASK)
#define SMARTCARD_LCR_DLAB_MASK                  (0x80U)
#define SMARTCARD_LCR_DLAB_SHIFT                 (7U)
/*! DLAB - Divisor Latch Access Bit.
 */
#define SMARTCARD_LCR_DLAB(x)                    (((uint32_t)(((uint32_t)(x)) << SMARTCARD_LCR_DLAB_SHIFT)) & SMARTCARD_LCR_DLAB_MASK)
/*! @} */

/*! @name LSR - Line Status Register */
/*! @{ */
#define SMARTCARD_LSR_RDR_MASK                   (0x1U)
#define SMARTCARD_LSR_RDR_SHIFT                  (0U)
/*! RDR - Receiver Data Ready.
 */
#define SMARTCARD_LSR_RDR(x)                     (((uint32_t)(((uint32_t)(x)) << SMARTCARD_LSR_RDR_SHIFT)) & SMARTCARD_LSR_RDR_MASK)
#define SMARTCARD_LSR_OE_MASK                    (0x2U)
#define SMARTCARD_LSR_OE_SHIFT                   (1U)
/*! OE - Overrun Error.
 */
#define SMARTCARD_LSR_OE(x)                      (((uint32_t)(((uint32_t)(x)) << SMARTCARD_LSR_OE_SHIFT)) & SMARTCARD_LSR_OE_MASK)
#define SMARTCARD_LSR_PE_MASK                    (0x4U)
#define SMARTCARD_LSR_PE_SHIFT                   (2U)
/*! PE - Parity Error.
 */
#define SMARTCARD_LSR_PE(x)                      (((uint32_t)(((uint32_t)(x)) << SMARTCARD_LSR_PE_SHIFT)) & SMARTCARD_LSR_PE_MASK)
#define SMARTCARD_LSR_FE_MASK                    (0x8U)
#define SMARTCARD_LSR_FE_SHIFT                   (3U)
/*! FE - Framing Error.
 */
#define SMARTCARD_LSR_FE(x)                      (((uint32_t)(((uint32_t)(x)) << SMARTCARD_LSR_FE_SHIFT)) & SMARTCARD_LSR_FE_MASK)
#define SMARTCARD_LSR_THRE_MASK                  (0x20U)
#define SMARTCARD_LSR_THRE_SHIFT                 (5U)
/*! THRE - Transmitter Holding Register Empty.
 */
#define SMARTCARD_LSR_THRE(x)                    (((uint32_t)(((uint32_t)(x)) << SMARTCARD_LSR_THRE_SHIFT)) & SMARTCARD_LSR_THRE_MASK)
#define SMARTCARD_LSR_TEMT_MASK                  (0x40U)
#define SMARTCARD_LSR_TEMT_SHIFT                 (6U)
/*! TEMT - Transmitter Empty.
 */
#define SMARTCARD_LSR_TEMT(x)                    (((uint32_t)(((uint32_t)(x)) << SMARTCARD_LSR_TEMT_SHIFT)) & SMARTCARD_LSR_TEMT_MASK)
#define SMARTCARD_LSR_RXFE_MASK                  (0x80U)
#define SMARTCARD_LSR_RXFE_SHIFT                 (7U)
/*! RXFE - Error in RX FIFO.
 */
#define SMARTCARD_LSR_RXFE(x)                    (((uint32_t)(((uint32_t)(x)) << SMARTCARD_LSR_RXFE_SHIFT)) & SMARTCARD_LSR_RXFE_MASK)
/*! @} */

/*! @name SCR - Scratch Pad Register */
/*! @{ */
#define SMARTCARD_SCR_PAD_MASK                   (0xFFU)
#define SMARTCARD_SCR_PAD_SHIFT                  (0U)
/*! PAD - A readable, writable byte.
 */
#define SMARTCARD_SCR_PAD(x)                     (((uint32_t)(((uint32_t)(x)) << SMARTCARD_SCR_PAD_SHIFT)) & SMARTCARD_SCR_PAD_MASK)
/*! @} */

/*! @name OSR - Oversampling register */
/*! @{ */
#define SMARTCARD_OSR_OSFRAC_MASK                (0xEU)
#define SMARTCARD_OSR_OSFRAC_SHIFT               (1U)
/*! OSFRAC - Fractional part of the oversampling ratio, in units of 1/8th of an input clock period.
 */
#define SMARTCARD_OSR_OSFRAC(x)                  (((uint32_t)(((uint32_t)(x)) << SMARTCARD_OSR_OSFRAC_SHIFT)) & SMARTCARD_OSR_OSFRAC_MASK)
#define SMARTCARD_OSR_OSINT_MASK                 (0xF0U)
#define SMARTCARD_OSR_OSINT_SHIFT                (4U)
/*! OSINT - Integer part of the oversampling ratio, minus 1.
 */
#define SMARTCARD_OSR_OSINT(x)                   (((uint32_t)(((uint32_t)(x)) << SMARTCARD_OSR_OSINT_SHIFT)) & SMARTCARD_OSR_OSINT_MASK)
#define SMARTCARD_OSR_FDINT_MASK                 (0x7F00U)
#define SMARTCARD_OSR_FDINT_SHIFT                (8U)
/*! FDINT - These bits act as a more-significant extension of the OSint field, allowing an
 *    oversampling ratio up to 2048 as required by ISO7816-3.
 */
#define SMARTCARD_OSR_FDINT(x)                   (((uint32_t)(((uint32_t)(x)) << SMARTCARD_OSR_FDINT_SHIFT)) & SMARTCARD_OSR_FDINT_MASK)
/*! @} */

/*! @name SCICTRL - Smart Card Interface control register */
/*! @{ */
#define SMARTCARD_SCICTRL_SCIEN_MASK             (0x1U)
#define SMARTCARD_SCICTRL_SCIEN_SHIFT            (0U)
/*! SCIEN - Smart Card Interface Enable.
 */
#define SMARTCARD_SCICTRL_SCIEN(x)               (((uint32_t)(((uint32_t)(x)) << SMARTCARD_SCICTRL_SCIEN_SHIFT)) & SMARTCARD_SCICTRL_SCIEN_MASK)
#define SMARTCARD_SCICTRL_NACKDIS_MASK           (0x2U)
#define SMARTCARD_SCICTRL_NACKDIS_SHIFT          (1U)
/*! NACKDIS - NACK response disable.
 */
#define SMARTCARD_SCICTRL_NACKDIS(x)             (((uint32_t)(((uint32_t)(x)) << SMARTCARD_SCICTRL_NACKDIS_SHIFT)) & SMARTCARD_SCICTRL_NACKDIS_MASK)
#define SMARTCARD_SCICTRL_PROTSEL_MASK           (0x4U)
#define SMARTCARD_SCICTRL_PROTSEL_SHIFT          (2U)
/*! PROTSEL - Protocol selection as defined in the ISO7816-3 standard.
 */
#define SMARTCARD_SCICTRL_PROTSEL(x)             (((uint32_t)(((uint32_t)(x)) << SMARTCARD_SCICTRL_PROTSEL_SHIFT)) & SMARTCARD_SCICTRL_PROTSEL_MASK)
#define SMARTCARD_SCICTRL_TXRETRY_MASK           (0xE0U)
#define SMARTCARD_SCICTRL_TXRETRY_SHIFT          (5U)
/*! TXRETRY - Maximum number of retransmissions in case of a negative acknowledge (protocol T=0).
 */
#define SMARTCARD_SCICTRL_TXRETRY(x)             (((uint32_t)(((uint32_t)(x)) << SMARTCARD_SCICTRL_TXRETRY_SHIFT)) & SMARTCARD_SCICTRL_TXRETRY_MASK)
#define SMARTCARD_SCICTRL_GUARDTIME_MASK         (0xFF00U)
#define SMARTCARD_SCICTRL_GUARDTIME_SHIFT        (8U)
/*! GUARDTIME - Extra guard time.
 */
#define SMARTCARD_SCICTRL_GUARDTIME(x)           (((uint32_t)(((uint32_t)(x)) << SMARTCARD_SCICTRL_GUARDTIME_SHIFT)) & SMARTCARD_SCICTRL_GUARDTIME_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group SMARTCARD_Register_Masks */


/* SMARTCARD - Peripheral instance base addresses */
/** Peripheral SMARTCARD0 base address */
#define SMARTCARD0_BASE                          (0x40036000u)
/** Peripheral SMARTCARD0 base pointer */
#define SMARTCARD0                               ((SMARTCARD_Type *)SMARTCARD0_BASE)
/** Peripheral SMARTCARD1 base address */
#define SMARTCARD1_BASE                          (0x40037000u)
/** Peripheral SMARTCARD1 base pointer */
#define SMARTCARD1                               ((SMARTCARD_Type *)SMARTCARD1_BASE)
/** Array initializer of SMARTCARD peripheral base addresses */
#define SMARTCARD_BASE_ADDRS                     { SMARTCARD0_BASE, SMARTCARD1_BASE }
/** Array initializer of SMARTCARD peripheral base pointers */
#define SMARTCARD_BASE_PTRS                      { SMARTCARD0, SMARTCARD1 }
/** Interrupt vectors for the SMARTCARD peripheral type */
#define SMARTCARD_IRQS                           { SMARTCARD0_IRQn, SMARTCARD1_IRQn }

/*!
 * @}
 */ /* end of group SMARTCARD_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- SPI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPI_Peripheral_Access_Layer SPI Peripheral Access Layer
 * @{
 */

/** SPI - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[1024];
  __IO uint32_t CFG;                               /**< SPI Configuration register, offset: 0x400 */
  __IO uint32_t DLY;                               /**< SPI Delay register, offset: 0x404 */
  __IO uint32_t STAT;                              /**< SPI Status. Some status flags can be cleared by writing a 1 to that bit position., offset: 0x408 */
  __IO uint32_t INTENSET;                          /**< SPI Interrupt Enable read and Set. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set., offset: 0x40C */
  __O  uint32_t INTENCLR;                          /**< SPI Interrupt Enable Clear. Writing a 1 to any implemented bit position causes the corresponding bit in INTENSET to be cleared., offset: 0x410 */
       uint8_t RESERVED_1[16];
  __IO uint32_t DIV;                               /**< SPI clock Divider, offset: 0x424 */
  __I  uint32_t INTSTAT;                           /**< SPI Interrupt Status, offset: 0x428 */
       uint8_t RESERVED_2[2516];
  __IO uint32_t FIFOCFG;                           /**< FIFO configuration and enable register., offset: 0xE00 */
  __IO uint32_t FIFOSTAT;                          /**< FIFO status register., offset: 0xE04 */
  __IO uint32_t FIFOTRIG;                          /**< FIFO trigger settings for interrupt and DMA request., offset: 0xE08 */
       uint8_t RESERVED_3[4];
  __IO uint32_t FIFOINTENSET;                      /**< FIFO interrupt enable set (enable) and read register., offset: 0xE10 */
  __IO uint32_t FIFOINTENCLR;                      /**< FIFO interrupt enable clear (disable) and read register., offset: 0xE14 */
  __I  uint32_t FIFOINTSTAT;                       /**< FIFO interrupt status register., offset: 0xE18 */
       uint8_t RESERVED_4[4];
  __O  uint32_t FIFOWR;                            /**< FIFO write data., offset: 0xE20 */
       uint8_t RESERVED_5[12];
  __I  uint32_t FIFORD;                            /**< FIFO read data., offset: 0xE30 */
       uint8_t RESERVED_6[12];
  __I  uint32_t FIFORDNOPOP;                       /**< FIFO data read with no FIFO pop., offset: 0xE40 */
       uint8_t RESERVED_7[440];
  __I  uint32_t ID;                                /**< Peripheral identification register., offset: 0xFFC */
} SPI_Type;

/* ----------------------------------------------------------------------------
   -- SPI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPI_Register_Masks SPI Register Masks
 * @{
 */

/*! @name CFG - SPI Configuration register */
/*! @{ */
#define SPI_CFG_ENABLE_MASK                      (0x1U)
#define SPI_CFG_ENABLE_SHIFT                     (0U)
/*! ENABLE - SPI enable.
 *  0b0..Disabled. The SPI is disabled and the internal state machine and counters are reset.
 *  0b1..Enabled. The SPI is enabled for operation.
 */
#define SPI_CFG_ENABLE(x)                        (((uint32_t)(((uint32_t)(x)) << SPI_CFG_ENABLE_SHIFT)) & SPI_CFG_ENABLE_MASK)
#define SPI_CFG_MASTER_MASK                      (0x4U)
#define SPI_CFG_MASTER_SHIFT                     (2U)
/*! MASTER - Master mode select.
 *  0b0..Slave mode. The SPI will operate in slave mode. SCK, MOSI, and the SSEL signals are inputs, MISO is an output.
 *  0b1..Master mode. The SPI will operate in master mode. SCK, MOSI, and the SSEL signals are outputs, MISO is an input.
 */
#define SPI_CFG_MASTER(x)                        (((uint32_t)(((uint32_t)(x)) << SPI_CFG_MASTER_SHIFT)) & SPI_CFG_MASTER_MASK)
#define SPI_CFG_LSBF_MASK                        (0x8U)
#define SPI_CFG_LSBF_SHIFT                       (3U)
/*! LSBF - LSB First mode enable.
 *  0b0..Standard. Data is transmitted and received in standard MSB first order.
 *  0b1..Reverse. Data is transmitted and received in reverse order (LSB first).
 */
#define SPI_CFG_LSBF(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_CFG_LSBF_SHIFT)) & SPI_CFG_LSBF_MASK)
#define SPI_CFG_CPHA_MASK                        (0x10U)
#define SPI_CFG_CPHA_SHIFT                       (4U)
/*! CPHA - Clock Phase select.
 *  0b0..Change. The SPI captures serial data on the first clock transition of the transfer (when the clock
 *       changes away from the rest state). Data is changed on the following edge.
 *  0b1..Capture. The SPI changes serial data on the first clock transition of the transfer (when the clock
 *       changes away from the rest state). Data is captured on the following edge.
 */
#define SPI_CFG_CPHA(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_CFG_CPHA_SHIFT)) & SPI_CFG_CPHA_MASK)
#define SPI_CFG_CPOL_MASK                        (0x20U)
#define SPI_CFG_CPOL_SHIFT                       (5U)
/*! CPOL - Clock Polarity select.
 *  0b0..Low. The rest state of the clock (between transfers) is low.
 *  0b1..High. The rest state of the clock (between transfers) is high.
 */
#define SPI_CFG_CPOL(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_CFG_CPOL_SHIFT)) & SPI_CFG_CPOL_MASK)
#define SPI_CFG_LOOP_MASK                        (0x80U)
#define SPI_CFG_LOOP_SHIFT                       (7U)
/*! LOOP - Loopback mode enable. Loopback mode applies only to Master mode, and connects transmit
 *    and receive data connected together to allow simple software testing.
 *  0b0..Disabled.
 *  0b1..Enabled.
 */
#define SPI_CFG_LOOP(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_CFG_LOOP_SHIFT)) & SPI_CFG_LOOP_MASK)
#define SPI_CFG_SPOL0_MASK                       (0x100U)
#define SPI_CFG_SPOL0_SHIFT                      (8U)
/*! SPOL0 - SSEL0 Polarity select.
 *  0b0..Low. The SSEL0 pin is active low.
 *  0b1..High. The SSEL0 pin is active high.
 */
#define SPI_CFG_SPOL0(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_CFG_SPOL0_SHIFT)) & SPI_CFG_SPOL0_MASK)
#define SPI_CFG_SPOL1_MASK                       (0x200U)
#define SPI_CFG_SPOL1_SHIFT                      (9U)
/*! SPOL1 - SSEL1 Polarity select.
 *  0b0..Low. The SSEL1 pin is active low.
 *  0b1..High. The SSEL1 pin is active high.
 */
#define SPI_CFG_SPOL1(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_CFG_SPOL1_SHIFT)) & SPI_CFG_SPOL1_MASK)
#define SPI_CFG_SPOL2_MASK                       (0x400U)
#define SPI_CFG_SPOL2_SHIFT                      (10U)
/*! SPOL2 - SSEL2 Polarity select.
 *  0b0..Low. The SSEL2 pin is active low.
 *  0b1..High. The SSEL2 pin is active high.
 */
#define SPI_CFG_SPOL2(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_CFG_SPOL2_SHIFT)) & SPI_CFG_SPOL2_MASK)
#define SPI_CFG_SPOL3_MASK                       (0x800U)
#define SPI_CFG_SPOL3_SHIFT                      (11U)
/*! SPOL3 - SSEL3 Polarity select.
 *  0b0..Low. The SSEL3 pin is active low.
 *  0b1..High. The SSEL3 pin is active high.
 */
#define SPI_CFG_SPOL3(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_CFG_SPOL3_SHIFT)) & SPI_CFG_SPOL3_MASK)
/*! @} */

/*! @name DLY - SPI Delay register */
/*! @{ */
#define SPI_DLY_PRE_DELAY_MASK                   (0xFU)
#define SPI_DLY_PRE_DELAY_SHIFT                  (0U)
/*! PRE_DELAY - Controls the amount of time between SSEL assertion and the beginning of a data
 *    transfer. There is always one SPI clock time between SSEL assertion and the first clock edge. This
 *    is not considered part of the pre-delay. 0x0 = No additional time is inserted. 0x1 = 1 SPI
 *    clock time is inserted. 0x2 = 2 SPI clock times are inserted. 0xF = 15 SPI clock times are
 *    inserted.
 */
#define SPI_DLY_PRE_DELAY(x)                     (((uint32_t)(((uint32_t)(x)) << SPI_DLY_PRE_DELAY_SHIFT)) & SPI_DLY_PRE_DELAY_MASK)
#define SPI_DLY_POST_DELAY_MASK                  (0xF0U)
#define SPI_DLY_POST_DELAY_SHIFT                 (4U)
/*! POST_DELAY - Controls the amount of time between the end of a data transfer and SSEL
 *    deassertion. 0x0 = No additional time is inserted. 0x1 = 1 SPI clock time is inserted. 0x2 = 2 SPI clock
 *    times are inserted. 0xF = 15 SPI clock times are inserted.
 */
#define SPI_DLY_POST_DELAY(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_DLY_POST_DELAY_SHIFT)) & SPI_DLY_POST_DELAY_MASK)
#define SPI_DLY_FRAME_DELAY_MASK                 (0xF00U)
#define SPI_DLY_FRAME_DELAY_SHIFT                (8U)
/*! FRAME_DELAY - If the EOF flag is set, controls the minimum amount of time between the current
 *    frame and the next frame (or SSEL deassertion if EOT). 0x0 = No additional time is inserted. 0x1
 *    = 1 SPI clock time is inserted. 0x2 = 2 SPI clock times are inserted. 0xF = 15 SPI clock
 *    times are inserted.
 */
#define SPI_DLY_FRAME_DELAY(x)                   (((uint32_t)(((uint32_t)(x)) << SPI_DLY_FRAME_DELAY_SHIFT)) & SPI_DLY_FRAME_DELAY_MASK)
#define SPI_DLY_TRANSFER_DELAY_MASK              (0xF000U)
#define SPI_DLY_TRANSFER_DELAY_SHIFT             (12U)
/*! TRANSFER_DELAY - Controls the minimum amount of time that the SSEL is deasserted between
 *    transfers. 0x0 = The minimum time that SSEL is deasserted is 1 SPI clock time. (Zero added time.) 0x1
 *    = The minimum time that SSEL is deasserted is 2 SPI clock times. 0x2 = The minimum time that
 *    SSEL is deasserted is 3 SPI clock times. 0xF = The minimum time that SSEL is deasserted is 16
 *    SPI clock times.
 */
#define SPI_DLY_TRANSFER_DELAY(x)                (((uint32_t)(((uint32_t)(x)) << SPI_DLY_TRANSFER_DELAY_SHIFT)) & SPI_DLY_TRANSFER_DELAY_MASK)
/*! @} */

/*! @name STAT - SPI Status. Some status flags can be cleared by writing a 1 to that bit position. */
/*! @{ */
#define SPI_STAT_SSA_MASK                        (0x10U)
#define SPI_STAT_SSA_SHIFT                       (4U)
/*! SSA - Slave Select Assert. This flag is set whenever any slave select transitions from
 *    deasserted to asserted, in both master and slave modes. This allows determining when the SPI
 *    transmit/receive functions become busy, and allows waking up the device from reduced power modes when a
 *    slave mode access begins. This flag is cleared by software.
 */
#define SPI_STAT_SSA(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_STAT_SSA_SHIFT)) & SPI_STAT_SSA_MASK)
#define SPI_STAT_SSD_MASK                        (0x20U)
#define SPI_STAT_SSD_SHIFT                       (5U)
/*! SSD - Slave Select Deassert. This flag is set whenever any asserted slave selects transition to
 *    deasserted, in both master and slave modes. This allows determining when the SPI
 *    transmit/receive functions become idle. This flag is cleared by software.
 */
#define SPI_STAT_SSD(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_STAT_SSD_SHIFT)) & SPI_STAT_SSD_MASK)
#define SPI_STAT_STALLED_MASK                    (0x40U)
#define SPI_STAT_STALLED_SHIFT                   (6U)
/*! STALLED - Stalled status flag. This indicates whether the SPI is currently in a stall condition.
 */
#define SPI_STAT_STALLED(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_STAT_STALLED_SHIFT)) & SPI_STAT_STALLED_MASK)
#define SPI_STAT_ENDTRANSFER_MASK                (0x80U)
#define SPI_STAT_ENDTRANSFER_SHIFT               (7U)
/*! ENDTRANSFER - End Transfer control bit. Software can set this bit to force an end to the current
 *    transfer when the transmitter finishes any activity already in progress, as if the EOT flag
 *    had been set prior to the last transmission. This capability is included to support cases where
 *    it is not known when transmit data is written that it will be the end of a transfer. The bit
 *    is cleared when the transmitter becomes idle as the transfer comes to an end. Forcing an end
 *    of transfer in this manner causes any specified FRAME_DELAY and TRANSFER_DELAY to be inserted.
 */
#define SPI_STAT_ENDTRANSFER(x)                  (((uint32_t)(((uint32_t)(x)) << SPI_STAT_ENDTRANSFER_SHIFT)) & SPI_STAT_ENDTRANSFER_MASK)
#define SPI_STAT_MSTIDLE_MASK                    (0x100U)
#define SPI_STAT_MSTIDLE_SHIFT                   (8U)
/*! MSTIDLE - Master idle status flag. This bit is 1 whenever the SPI master function is fully idle.
 *    This means that the transmit holding register is empty and the transmitter is not in the
 *    process of sending data.
 */
#define SPI_STAT_MSTIDLE(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_STAT_MSTIDLE_SHIFT)) & SPI_STAT_MSTIDLE_MASK)
/*! @} */

/*! @name INTENSET - SPI Interrupt Enable read and Set. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set. */
/*! @{ */
#define SPI_INTENSET_SSAEN_MASK                  (0x10U)
#define SPI_INTENSET_SSAEN_SHIFT                 (4U)
/*! SSAEN - Slave select assert interrupt enable. Determines whether an interrupt occurs when the Slave Select is asserted.
 *  0b0..Disabled. No interrupt will be generated when any Slave Select transitions from deasserted to asserted.
 *  0b1..Enabled. An interrupt will be generated when any Slave Select transitions from deasserted to asserted.
 */
#define SPI_INTENSET_SSAEN(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_INTENSET_SSAEN_SHIFT)) & SPI_INTENSET_SSAEN_MASK)
#define SPI_INTENSET_SSDEN_MASK                  (0x20U)
#define SPI_INTENSET_SSDEN_SHIFT                 (5U)
/*! SSDEN - Slave select deassert interrupt enable. Determines whether an interrupt occurs when the Slave Select is deasserted.
 *  0b0..Disabled. No interrupt will be generated when all asserted Slave Selects transition to deasserted.
 *  0b1..Enabled. An interrupt will be generated when all asserted Slave Selects transition to deasserted.
 */
#define SPI_INTENSET_SSDEN(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_INTENSET_SSDEN_SHIFT)) & SPI_INTENSET_SSDEN_MASK)
#define SPI_INTENSET_MSTIDLEEN_MASK              (0x100U)
#define SPI_INTENSET_MSTIDLEEN_SHIFT             (8U)
/*! MSTIDLEEN - Master idle interrupt enable.
 *  0b0..No interrupt will be generated when the SPI master function is idle.
 *  0b1..An interrupt will be generated when the SPI master function is fully idle.
 */
#define SPI_INTENSET_MSTIDLEEN(x)                (((uint32_t)(((uint32_t)(x)) << SPI_INTENSET_MSTIDLEEN_SHIFT)) & SPI_INTENSET_MSTIDLEEN_MASK)
/*! @} */

/*! @name INTENCLR - SPI Interrupt Enable Clear. Writing a 1 to any implemented bit position causes the corresponding bit in INTENSET to be cleared. */
/*! @{ */
#define SPI_INTENCLR_SSAEN_MASK                  (0x10U)
#define SPI_INTENCLR_SSAEN_SHIFT                 (4U)
/*! SSAEN - Writing 1 clears the corresponding bit in the INTENSET register.
 */
#define SPI_INTENCLR_SSAEN(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_INTENCLR_SSAEN_SHIFT)) & SPI_INTENCLR_SSAEN_MASK)
#define SPI_INTENCLR_SSDEN_MASK                  (0x20U)
#define SPI_INTENCLR_SSDEN_SHIFT                 (5U)
/*! SSDEN - Writing 1 clears the corresponding bit in the INTENSET register.
 */
#define SPI_INTENCLR_SSDEN(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_INTENCLR_SSDEN_SHIFT)) & SPI_INTENCLR_SSDEN_MASK)
#define SPI_INTENCLR_MSTIDLE_MASK                (0x100U)
#define SPI_INTENCLR_MSTIDLE_SHIFT               (8U)
/*! MSTIDLE - Writing 1 clears the corresponding bit in the INTENSET register.
 */
#define SPI_INTENCLR_MSTIDLE(x)                  (((uint32_t)(((uint32_t)(x)) << SPI_INTENCLR_MSTIDLE_SHIFT)) & SPI_INTENCLR_MSTIDLE_MASK)
/*! @} */

/*! @name DIV - SPI clock Divider */
/*! @{ */
#define SPI_DIV_DIVVAL_MASK                      (0xFFFFU)
#define SPI_DIV_DIVVAL_SHIFT                     (0U)
/*! DIVVAL - Rate divider value. Specifies how the Flexcomm clock (FCLK) is divided to produce the
 *    SPI clock rate in master mode. DIVVAL is -1 encoded such that the value 0 results in FCLK/1,
 *    the value 1 results in FCLK/2, up to the maximum possible divide value of 0xFFFF, which results
 *    in FCLK/65536.
 */
#define SPI_DIV_DIVVAL(x)                        (((uint32_t)(((uint32_t)(x)) << SPI_DIV_DIVVAL_SHIFT)) & SPI_DIV_DIVVAL_MASK)
/*! @} */

/*! @name INTSTAT - SPI Interrupt Status */
/*! @{ */
#define SPI_INTSTAT_SSA_MASK                     (0x10U)
#define SPI_INTSTAT_SSA_SHIFT                    (4U)
/*! SSA - Slave Select Assert.
 */
#define SPI_INTSTAT_SSA(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_INTSTAT_SSA_SHIFT)) & SPI_INTSTAT_SSA_MASK)
#define SPI_INTSTAT_SSD_MASK                     (0x20U)
#define SPI_INTSTAT_SSD_SHIFT                    (5U)
/*! SSD - Slave Select Deassert.
 */
#define SPI_INTSTAT_SSD(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_INTSTAT_SSD_SHIFT)) & SPI_INTSTAT_SSD_MASK)
#define SPI_INTSTAT_MSTIDLE_MASK                 (0x100U)
#define SPI_INTSTAT_MSTIDLE_SHIFT                (8U)
/*! MSTIDLE - Master Idle status flag.
 */
#define SPI_INTSTAT_MSTIDLE(x)                   (((uint32_t)(((uint32_t)(x)) << SPI_INTSTAT_MSTIDLE_SHIFT)) & SPI_INTSTAT_MSTIDLE_MASK)
/*! @} */

/*! @name FIFOCFG - FIFO configuration and enable register. */
/*! @{ */
#define SPI_FIFOCFG_ENABLETX_MASK                (0x1U)
#define SPI_FIFOCFG_ENABLETX_SHIFT               (0U)
/*! ENABLETX - Enable the transmit FIFO.
 *  0b0..The transmit FIFO is not enabled.
 *  0b1..The transmit FIFO is enabled.
 */
#define SPI_FIFOCFG_ENABLETX(x)                  (((uint32_t)(((uint32_t)(x)) << SPI_FIFOCFG_ENABLETX_SHIFT)) & SPI_FIFOCFG_ENABLETX_MASK)
#define SPI_FIFOCFG_ENABLERX_MASK                (0x2U)
#define SPI_FIFOCFG_ENABLERX_SHIFT               (1U)
/*! ENABLERX - Enable the receive FIFO.
 *  0b0..The receive FIFO is not enabled.
 *  0b1..The receive FIFO is enabled.
 */
#define SPI_FIFOCFG_ENABLERX(x)                  (((uint32_t)(((uint32_t)(x)) << SPI_FIFOCFG_ENABLERX_SHIFT)) & SPI_FIFOCFG_ENABLERX_MASK)
#define SPI_FIFOCFG_SIZE_MASK                    (0x30U)
#define SPI_FIFOCFG_SIZE_SHIFT                   (4U)
/*! SIZE - FIFO size configuration. This is a read-only field. 0x0 = FIFO is configured as 16
 *    entries of 8 bits. 0x1, 0x2, 0x3 = not applicable to USART.
 */
#define SPI_FIFOCFG_SIZE(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_FIFOCFG_SIZE_SHIFT)) & SPI_FIFOCFG_SIZE_MASK)
#define SPI_FIFOCFG_DMATX_MASK                   (0x1000U)
#define SPI_FIFOCFG_DMATX_SHIFT                  (12U)
/*! DMATX - DMA configuration for transmit.
 *  0b0..DMA is not used for the transmit function.
 *  0b1..Trigger DMA for the transmit function if the FIFO is not full. Generally, data interrupts would be disabled if DMA is enabled.
 */
#define SPI_FIFOCFG_DMATX(x)                     (((uint32_t)(((uint32_t)(x)) << SPI_FIFOCFG_DMATX_SHIFT)) & SPI_FIFOCFG_DMATX_MASK)
#define SPI_FIFOCFG_DMARX_MASK                   (0x2000U)
#define SPI_FIFOCFG_DMARX_SHIFT                  (13U)
/*! DMARX - DMA configuration for receive.
 *  0b0..DMA is not used for the receive function.
 *  0b1..Trigger DMA for the receive function if the FIFO is not empty. Generally, data interrupts would be disabled if DMA is enabled.
 */
#define SPI_FIFOCFG_DMARX(x)                     (((uint32_t)(((uint32_t)(x)) << SPI_FIFOCFG_DMARX_SHIFT)) & SPI_FIFOCFG_DMARX_MASK)
#define SPI_FIFOCFG_WAKETX_MASK                  (0x4000U)
#define SPI_FIFOCFG_WAKETX_SHIFT                 (14U)
/*! WAKETX - Wake-up for transmit FIFO level. This allows the device to be woken from reduced power
 *    modes (up to power-down, as long as the peripheral function works in that power mode) without
 *    enabling the TXLVL interrupt. Only DMA wakes up, processes data, and goes back to sleep. The
 *    CPU will remain stopped until woken by another cause, such as DMA completion. See Hardware
 *    Wake-up control register.
 *  0b0..Only enabled interrupts will wake up the device form reduced power modes.
 *  0b1..A device wake-up for DMA will occur if the transmit FIFO level reaches the value specified by TXLVL in
 *       FIFOTRIG, even when the TXLVL interrupt is not enabled.
 */
#define SPI_FIFOCFG_WAKETX(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_FIFOCFG_WAKETX_SHIFT)) & SPI_FIFOCFG_WAKETX_MASK)
#define SPI_FIFOCFG_WAKERX_MASK                  (0x8000U)
#define SPI_FIFOCFG_WAKERX_SHIFT                 (15U)
/*! WAKERX - Wake-up for receive FIFO level. This allows the device to be woken from reduced power
 *    modes (up to power-down, as long as the peripheral function works in that power mode) without
 *    enabling the TXLVL interrupt. Only DMA wakes up, processes data, and goes back to sleep. The
 *    CPU will remain stopped until woken by another cause, such as DMA completion. See Hardware
 *    Wake-up control register.
 *  0b0..Only enabled interrupts will wake up the device form reduced power modes.
 *  0b1..A device wake-up for DMA will occur if the receive FIFO level reaches the value specified by RXLVL in
 *       FIFOTRIG, even when the RXLVL interrupt is not enabled.
 */
#define SPI_FIFOCFG_WAKERX(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_FIFOCFG_WAKERX_SHIFT)) & SPI_FIFOCFG_WAKERX_MASK)
#define SPI_FIFOCFG_EMPTYTX_MASK                 (0x10000U)
#define SPI_FIFOCFG_EMPTYTX_SHIFT                (16U)
/*! EMPTYTX - Empty command for the transmit FIFO. When a 1 is written to this bit, the TX FIFO is emptied.
 */
#define SPI_FIFOCFG_EMPTYTX(x)                   (((uint32_t)(((uint32_t)(x)) << SPI_FIFOCFG_EMPTYTX_SHIFT)) & SPI_FIFOCFG_EMPTYTX_MASK)
#define SPI_FIFOCFG_EMPTYRX_MASK                 (0x20000U)
#define SPI_FIFOCFG_EMPTYRX_SHIFT                (17U)
/*! EMPTYRX - Empty command for the receive FIFO. When a 1 is written to this bit, the RX FIFO is emptied.
 */
#define SPI_FIFOCFG_EMPTYRX(x)                   (((uint32_t)(((uint32_t)(x)) << SPI_FIFOCFG_EMPTYRX_SHIFT)) & SPI_FIFOCFG_EMPTYRX_MASK)
/*! @} */

/*! @name FIFOSTAT - FIFO status register. */
/*! @{ */
#define SPI_FIFOSTAT_TXERR_MASK                  (0x1U)
#define SPI_FIFOSTAT_TXERR_SHIFT                 (0U)
/*! TXERR - TX FIFO error. Will be set if a transmit FIFO error occurs. This could be an overflow
 *    caused by pushing data into a full FIFO, or by an underflow if the FIFO is empty when data is
 *    needed. Cleared by writing a 1 to this bit.
 */
#define SPI_FIFOSTAT_TXERR(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_FIFOSTAT_TXERR_SHIFT)) & SPI_FIFOSTAT_TXERR_MASK)
#define SPI_FIFOSTAT_RXERR_MASK                  (0x2U)
#define SPI_FIFOSTAT_RXERR_SHIFT                 (1U)
/*! RXERR - RX FIFO error. Will be set if a receive FIFO overflow occurs, caused by software or DMA
 *    not emptying the FIFO fast enough. Cleared by writing a 1 to this bit.
 */
#define SPI_FIFOSTAT_RXERR(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_FIFOSTAT_RXERR_SHIFT)) & SPI_FIFOSTAT_RXERR_MASK)
#define SPI_FIFOSTAT_PERINT_MASK                 (0x8U)
#define SPI_FIFOSTAT_PERINT_SHIFT                (3U)
/*! PERINT - Peripheral interrupt. When 1, this indicates that the peripheral function has asserted
 *    an interrupt. The details can be found by reading the peripheral's STAT register.
 */
#define SPI_FIFOSTAT_PERINT(x)                   (((uint32_t)(((uint32_t)(x)) << SPI_FIFOSTAT_PERINT_SHIFT)) & SPI_FIFOSTAT_PERINT_MASK)
#define SPI_FIFOSTAT_TXEMPTY_MASK                (0x10U)
#define SPI_FIFOSTAT_TXEMPTY_SHIFT               (4U)
/*! TXEMPTY - Transmit FIFO empty. When 1, the transmit FIFO is empty. The peripheral may still be processing the last piece of data.
 */
#define SPI_FIFOSTAT_TXEMPTY(x)                  (((uint32_t)(((uint32_t)(x)) << SPI_FIFOSTAT_TXEMPTY_SHIFT)) & SPI_FIFOSTAT_TXEMPTY_MASK)
#define SPI_FIFOSTAT_TXNOTFULL_MASK              (0x20U)
#define SPI_FIFOSTAT_TXNOTFULL_SHIFT             (5U)
/*! TXNOTFULL - Transmit FIFO not full. When 1, the transmit FIFO is not full, so more data can be
 *    written. When 0, the transmit FIFO is full and another write would cause it to overflow.
 */
#define SPI_FIFOSTAT_TXNOTFULL(x)                (((uint32_t)(((uint32_t)(x)) << SPI_FIFOSTAT_TXNOTFULL_SHIFT)) & SPI_FIFOSTAT_TXNOTFULL_MASK)
#define SPI_FIFOSTAT_RXNOTEMPTY_MASK             (0x40U)
#define SPI_FIFOSTAT_RXNOTEMPTY_SHIFT            (6U)
/*! RXNOTEMPTY - Receive FIFO not empty. When 1, the receive FIFO is not empty, so data can be read. When 0, the receive FIFO is empty.
 */
#define SPI_FIFOSTAT_RXNOTEMPTY(x)               (((uint32_t)(((uint32_t)(x)) << SPI_FIFOSTAT_RXNOTEMPTY_SHIFT)) & SPI_FIFOSTAT_RXNOTEMPTY_MASK)
#define SPI_FIFOSTAT_RXFULL_MASK                 (0x80U)
#define SPI_FIFOSTAT_RXFULL_SHIFT                (7U)
/*! RXFULL - Receive FIFO full. When 1, the receive FIFO is full. Data needs to be read out to
 *    prevent the peripheral from causing an overflow.
 */
#define SPI_FIFOSTAT_RXFULL(x)                   (((uint32_t)(((uint32_t)(x)) << SPI_FIFOSTAT_RXFULL_SHIFT)) & SPI_FIFOSTAT_RXFULL_MASK)
#define SPI_FIFOSTAT_TXLVL_MASK                  (0x1F00U)
#define SPI_FIFOSTAT_TXLVL_SHIFT                 (8U)
/*! TXLVL - Transmit FIFO current level. A 0 means the TX FIFO is currently empty, and the TXEMPTY
 *    and TXNOTFULL flags will be 1. Other values tell how much data is actually in the TX FIFO at
 *    the point where the read occurs. If the TX FIFO is full, the TXEMPTY and TXNOTFULL flags will be
 *    0.
 */
#define SPI_FIFOSTAT_TXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_FIFOSTAT_TXLVL_SHIFT)) & SPI_FIFOSTAT_TXLVL_MASK)
#define SPI_FIFOSTAT_RXLVL_MASK                  (0x1F0000U)
#define SPI_FIFOSTAT_RXLVL_SHIFT                 (16U)
/*! RXLVL - Receive FIFO current level. A 0 means the RX FIFO is currently empty, and the RXFULL and
 *    RXNOTEMPTY flags will be 0. Other values tell how much data is actually in the RX FIFO at the
 *    point where the read occurs. If the RX FIFO is full, the RXFULL and RXNOTEMPTY flags will be
 *    1.
 */
#define SPI_FIFOSTAT_RXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_FIFOSTAT_RXLVL_SHIFT)) & SPI_FIFOSTAT_RXLVL_MASK)
/*! @} */

/*! @name FIFOTRIG - FIFO trigger settings for interrupt and DMA request. */
/*! @{ */
#define SPI_FIFOTRIG_TXLVLENA_MASK               (0x1U)
#define SPI_FIFOTRIG_TXLVLENA_SHIFT              (0U)
/*! TXLVLENA - Transmit FIFO level trigger enable. This trigger will become an interrupt if enabled
 *    in FIFOINTENSET, or a DMA trigger if DMATX in FIFOCFG is set.
 *  0b0..Transmit FIFO level does not generate a FIFO level trigger.
 *  0b1..An trigger will be generated if the transmit FIFO level reaches the value specified by the TXLVL field in this register.
 */
#define SPI_FIFOTRIG_TXLVLENA(x)                 (((uint32_t)(((uint32_t)(x)) << SPI_FIFOTRIG_TXLVLENA_SHIFT)) & SPI_FIFOTRIG_TXLVLENA_MASK)
#define SPI_FIFOTRIG_RXLVLENA_MASK               (0x2U)
#define SPI_FIFOTRIG_RXLVLENA_SHIFT              (1U)
/*! RXLVLENA - Receive FIFO level trigger enable. This trigger will become an interrupt if enabled
 *    in FIFOINTENSET, or a DMA trigger if DMARX in FIFOCFG is set.
 *  0b0..Receive FIFO level does not generate a FIFO level trigger.
 *  0b1..An trigger will be generated if the receive FIFO level reaches the value specified by the RXLVL field in this register.
 */
#define SPI_FIFOTRIG_RXLVLENA(x)                 (((uint32_t)(((uint32_t)(x)) << SPI_FIFOTRIG_RXLVLENA_SHIFT)) & SPI_FIFOTRIG_RXLVLENA_MASK)
#define SPI_FIFOTRIG_TXLVL_MASK                  (0xF00U)
#define SPI_FIFOTRIG_TXLVL_SHIFT                 (8U)
/*! TXLVL - Transmit FIFO level trigger point. This field is used only when TXLVLENA = 1. If enabled
 *    to do so, the FIFO level can wake up the device just enough to perform DMA, then return to
 *    the reduced power mode. See Hardware Wake-up control register. 0 = trigger when the TX FIFO
 *    becomes empty. 1 = trigger when the TX FIFO level decreases to one entry. 15 = trigger when the TX
 *    FIFO level decreases to 15 entries (is no longer full).
 */
#define SPI_FIFOTRIG_TXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_FIFOTRIG_TXLVL_SHIFT)) & SPI_FIFOTRIG_TXLVL_MASK)
#define SPI_FIFOTRIG_RXLVL_MASK                  (0xF0000U)
#define SPI_FIFOTRIG_RXLVL_SHIFT                 (16U)
/*! RXLVL - Receive FIFO level trigger point. The RX FIFO level is checked when a new piece of data
 *    is received. This field is used only when RXLVLENA = 1. If enabled to do so, the FIFO level
 *    can wake up the device just enough to perform DMA, then return to the reduced power mode. See
 *    Hardware Wake-up control register. 0 = trigger when the RX FIFO has received one entry (is no
 *    longer empty). 1 = trigger when the RX FIFO has received two entries. 15 = trigger when the RX
 *    FIFO has received 16 entries (has become full).
 */
#define SPI_FIFOTRIG_RXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << SPI_FIFOTRIG_RXLVL_SHIFT)) & SPI_FIFOTRIG_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTENSET - FIFO interrupt enable set (enable) and read register. */
/*! @{ */
#define SPI_FIFOINTENSET_TXERR_MASK              (0x1U)
#define SPI_FIFOINTENSET_TXERR_SHIFT             (0U)
/*! TXERR - Determines whether an interrupt occurs when a transmit error occurs, based on the TXERR flag in the FIFOSTAT register.
 *  0b0..No interrupt will be generated for a transmit error.
 *  0b1..An interrupt will be generated when a transmit error occurs.
 */
#define SPI_FIFOINTENSET_TXERR(x)                (((uint32_t)(((uint32_t)(x)) << SPI_FIFOINTENSET_TXERR_SHIFT)) & SPI_FIFOINTENSET_TXERR_MASK)
#define SPI_FIFOINTENSET_RXERR_MASK              (0x2U)
#define SPI_FIFOINTENSET_RXERR_SHIFT             (1U)
/*! RXERR - Determines whether an interrupt occurs when a receive error occurs, based on the RXERR flag in the FIFOSTAT register.
 *  0b0..No interrupt will be generated for a receive error.
 *  0b1..An interrupt will be generated when a receive error occurs.
 */
#define SPI_FIFOINTENSET_RXERR(x)                (((uint32_t)(((uint32_t)(x)) << SPI_FIFOINTENSET_RXERR_SHIFT)) & SPI_FIFOINTENSET_RXERR_MASK)
#define SPI_FIFOINTENSET_TXLVL_MASK              (0x4U)
#define SPI_FIFOINTENSET_TXLVL_SHIFT             (2U)
/*! TXLVL - Determines whether an interrupt occurs when a the transmit FIFO reaches the level
 *    specified by the TXLVL field in the FIFOTRIG register.
 *  0b0..No interrupt will be generated based on the TX FIFO level.
 *  0b1..If TXLVLENA in the FIFOTRIG register = 1, an interrupt will be generated when the TX FIFO level decreases
 *       to the level specified by TXLVL in the FIFOTRIG register.
 */
#define SPI_FIFOINTENSET_TXLVL(x)                (((uint32_t)(((uint32_t)(x)) << SPI_FIFOINTENSET_TXLVL_SHIFT)) & SPI_FIFOINTENSET_TXLVL_MASK)
#define SPI_FIFOINTENSET_RXLVL_MASK              (0x8U)
#define SPI_FIFOINTENSET_RXLVL_SHIFT             (3U)
/*! RXLVL - Determines whether an interrupt occurs when a the receive FIFO reaches the level
 *    specified by the TXLVL field in the FIFOTRIG register.
 *  0b0..No interrupt will be generated based on the RX FIFO level.
 *  0b1..If RXLVLENA in the FIFOTRIG register = 1, an interrupt will be generated when the when the RX FIFO level
 *       increases to the level specified by RXLVL in the FIFOTRIG register.
 */
#define SPI_FIFOINTENSET_RXLVL(x)                (((uint32_t)(((uint32_t)(x)) << SPI_FIFOINTENSET_RXLVL_SHIFT)) & SPI_FIFOINTENSET_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTENCLR - FIFO interrupt enable clear (disable) and read register. */
/*! @{ */
#define SPI_FIFOINTENCLR_TXERR_MASK              (0x1U)
#define SPI_FIFOINTENCLR_TXERR_SHIFT             (0U)
/*! TXERR - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define SPI_FIFOINTENCLR_TXERR(x)                (((uint32_t)(((uint32_t)(x)) << SPI_FIFOINTENCLR_TXERR_SHIFT)) & SPI_FIFOINTENCLR_TXERR_MASK)
#define SPI_FIFOINTENCLR_RXERR_MASK              (0x2U)
#define SPI_FIFOINTENCLR_RXERR_SHIFT             (1U)
/*! RXERR - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define SPI_FIFOINTENCLR_RXERR(x)                (((uint32_t)(((uint32_t)(x)) << SPI_FIFOINTENCLR_RXERR_SHIFT)) & SPI_FIFOINTENCLR_RXERR_MASK)
#define SPI_FIFOINTENCLR_TXLVL_MASK              (0x4U)
#define SPI_FIFOINTENCLR_TXLVL_SHIFT             (2U)
/*! TXLVL - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define SPI_FIFOINTENCLR_TXLVL(x)                (((uint32_t)(((uint32_t)(x)) << SPI_FIFOINTENCLR_TXLVL_SHIFT)) & SPI_FIFOINTENCLR_TXLVL_MASK)
#define SPI_FIFOINTENCLR_RXLVL_MASK              (0x8U)
#define SPI_FIFOINTENCLR_RXLVL_SHIFT             (3U)
/*! RXLVL - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define SPI_FIFOINTENCLR_RXLVL(x)                (((uint32_t)(((uint32_t)(x)) << SPI_FIFOINTENCLR_RXLVL_SHIFT)) & SPI_FIFOINTENCLR_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTSTAT - FIFO interrupt status register. */
/*! @{ */
#define SPI_FIFOINTSTAT_TXERR_MASK               (0x1U)
#define SPI_FIFOINTSTAT_TXERR_SHIFT              (0U)
/*! TXERR - TX FIFO error.
 */
#define SPI_FIFOINTSTAT_TXERR(x)                 (((uint32_t)(((uint32_t)(x)) << SPI_FIFOINTSTAT_TXERR_SHIFT)) & SPI_FIFOINTSTAT_TXERR_MASK)
#define SPI_FIFOINTSTAT_RXERR_MASK               (0x2U)
#define SPI_FIFOINTSTAT_RXERR_SHIFT              (1U)
/*! RXERR - RX FIFO error.
 */
#define SPI_FIFOINTSTAT_RXERR(x)                 (((uint32_t)(((uint32_t)(x)) << SPI_FIFOINTSTAT_RXERR_SHIFT)) & SPI_FIFOINTSTAT_RXERR_MASK)
#define SPI_FIFOINTSTAT_TXLVL_MASK               (0x4U)
#define SPI_FIFOINTSTAT_TXLVL_SHIFT              (2U)
/*! TXLVL - Transmit FIFO level interrupt.
 */
#define SPI_FIFOINTSTAT_TXLVL(x)                 (((uint32_t)(((uint32_t)(x)) << SPI_FIFOINTSTAT_TXLVL_SHIFT)) & SPI_FIFOINTSTAT_TXLVL_MASK)
#define SPI_FIFOINTSTAT_RXLVL_MASK               (0x8U)
#define SPI_FIFOINTSTAT_RXLVL_SHIFT              (3U)
/*! RXLVL - Receive FIFO level interrupt.
 */
#define SPI_FIFOINTSTAT_RXLVL(x)                 (((uint32_t)(((uint32_t)(x)) << SPI_FIFOINTSTAT_RXLVL_SHIFT)) & SPI_FIFOINTSTAT_RXLVL_MASK)
#define SPI_FIFOINTSTAT_PERINT_MASK              (0x10U)
#define SPI_FIFOINTSTAT_PERINT_SHIFT             (4U)
/*! PERINT - Peripheral interrupt.
 */
#define SPI_FIFOINTSTAT_PERINT(x)                (((uint32_t)(((uint32_t)(x)) << SPI_FIFOINTSTAT_PERINT_SHIFT)) & SPI_FIFOINTSTAT_PERINT_MASK)
/*! @} */

/*! @name FIFOWR - FIFO write data. */
/*! @{ */
#define SPI_FIFOWR_TXDATA_MASK                   (0xFFFFU)
#define SPI_FIFOWR_TXDATA_SHIFT                  (0U)
/*! TXDATA - Transmit data to the FIFO.
 */
#define SPI_FIFOWR_TXDATA(x)                     (((uint32_t)(((uint32_t)(x)) << SPI_FIFOWR_TXDATA_SHIFT)) & SPI_FIFOWR_TXDATA_MASK)
#define SPI_FIFOWR_TXSSEL0_N_MASK                (0x10000U)
#define SPI_FIFOWR_TXSSEL0_N_SHIFT               (16U)
/*! TXSSEL0_N - Transmit slave select. This field asserts SSEL0 in master mode. The output on the pin is active LOW by default.
 *  0b0..SSEL0 asserted.
 *  0b1..SSEL0 not asserted.
 */
#define SPI_FIFOWR_TXSSEL0_N(x)                  (((uint32_t)(((uint32_t)(x)) << SPI_FIFOWR_TXSSEL0_N_SHIFT)) & SPI_FIFOWR_TXSSEL0_N_MASK)
#define SPI_FIFOWR_TXSSEL1_N_MASK                (0x20000U)
#define SPI_FIFOWR_TXSSEL1_N_SHIFT               (17U)
/*! TXSSEL1_N - Transmit slave select. This field asserts SSEL1 in master mode. The output on the pin is active LOW by default.
 *  0b0..SSEL1 asserted.
 *  0b1..SSEL1 not asserted.
 */
#define SPI_FIFOWR_TXSSEL1_N(x)                  (((uint32_t)(((uint32_t)(x)) << SPI_FIFOWR_TXSSEL1_N_SHIFT)) & SPI_FIFOWR_TXSSEL1_N_MASK)
#define SPI_FIFOWR_TXSSEL2_N_MASK                (0x40000U)
#define SPI_FIFOWR_TXSSEL2_N_SHIFT               (18U)
/*! TXSSEL2_N - Transmit slave select. This field asserts SSEL2 in master mode. The output on the pin is active LOW by default.
 *  0b0..SSEL2 asserted.
 *  0b1..SSEL2 not asserted.
 */
#define SPI_FIFOWR_TXSSEL2_N(x)                  (((uint32_t)(((uint32_t)(x)) << SPI_FIFOWR_TXSSEL2_N_SHIFT)) & SPI_FIFOWR_TXSSEL2_N_MASK)
#define SPI_FIFOWR_TXSSEL3_N_MASK                (0x80000U)
#define SPI_FIFOWR_TXSSEL3_N_SHIFT               (19U)
/*! TXSSEL3_N - Transmit slave select. This field asserts SSEL3 in master mode. The output on the pin is active LOW by default.
 *  0b0..SSEL3 asserted.
 *  0b1..SSEL3 not asserted.
 */
#define SPI_FIFOWR_TXSSEL3_N(x)                  (((uint32_t)(((uint32_t)(x)) << SPI_FIFOWR_TXSSEL3_N_SHIFT)) & SPI_FIFOWR_TXSSEL3_N_MASK)
#define SPI_FIFOWR_EOT_MASK                      (0x100000U)
#define SPI_FIFOWR_EOT_SHIFT                     (20U)
/*! EOT - End of transfer. The asserted SSEL will be deasserted at the end of a transfer and remain
 *    so far at least the time specified by the Transfer_delay value in the DLY register.
 *  0b0..SSEL not deasserted. This piece of data is not treated as the end of a transfer. SSEL will not be deasserted at the end of this data.
 *  0b1..SSEL deasserted. This piece of data is treated as the end of a transfer. SSEL will be deasserted at the end of this piece of data.
 */
#define SPI_FIFOWR_EOT(x)                        (((uint32_t)(((uint32_t)(x)) << SPI_FIFOWR_EOT_SHIFT)) & SPI_FIFOWR_EOT_MASK)
#define SPI_FIFOWR_EOF_MASK                      (0x200000U)
#define SPI_FIFOWR_EOF_SHIFT                     (21U)
/*! EOF - End of frame. Between frames, a delay may be inserted, as defined by the Frame_delay value
 *    in the DLY register. The end of a frame may not be particularly meaningful if the Frame_delay
 *    value = 0. This control can be used as part of the support for frame lengths greater than 16
 *    bits.
 *  0b0..Data not EOF. This piece of data transmitted is not treated as the end of a frame.
 *  0b1..Data EOF. This piece of data is treated as the end of a frame, causing the Frame_delay time to be
 *       inserted before subsequent data is transmitted.
 */
#define SPI_FIFOWR_EOF(x)                        (((uint32_t)(((uint32_t)(x)) << SPI_FIFOWR_EOF_SHIFT)) & SPI_FIFOWR_EOF_MASK)
#define SPI_FIFOWR_RXIGNORE_MASK                 (0x400000U)
#define SPI_FIFOWR_RXIGNORE_SHIFT                (22U)
/*! RXIGNORE - Receive Ignore. This allows data to be transmitted using the SPI without the need to
 *    read unneeded data from the receiver. Setting this bit simplifies the transmit process and can
 *    be used with the DMA.
 *  0b0..Read received data. Received data must be read in order to allow transmission to progress. SPI transmit
 *       will halt when the receive data FIFO is full. In slave mode, an overrun error will occur if received data
 *       is not read before new data is received.
 *  0b1..Ignore received data. Received data is ignored, allowing transmission without reading unneeded received
 *       data. No receiver flags are generated.
 */
#define SPI_FIFOWR_RXIGNORE(x)                   (((uint32_t)(((uint32_t)(x)) << SPI_FIFOWR_RXIGNORE_SHIFT)) & SPI_FIFOWR_RXIGNORE_MASK)
#define SPI_FIFOWR_LEN_MASK                      (0xF000000U)
#define SPI_FIFOWR_LEN_SHIFT                     (24U)
/*! LEN - Data Length. Specifies the data length from 4 to 16 bits. Note that transfer lengths
 *    greater than 16 bits are supported by implementing multiple sequential transmits. 0x0-2 = Reserved.
 *    0x3 = Data transfer is 4 bits in length. 0x4 = Data transfer is 5 bits in length. 0xF = Data
 *    transfer is 16 bits in length.
 */
#define SPI_FIFOWR_LEN(x)                        (((uint32_t)(((uint32_t)(x)) << SPI_FIFOWR_LEN_SHIFT)) & SPI_FIFOWR_LEN_MASK)
/*! @} */

/*! @name FIFORD - FIFO read data. */
/*! @{ */
#define SPI_FIFORD_RXDATA_MASK                   (0xFFFFU)
#define SPI_FIFORD_RXDATA_SHIFT                  (0U)
/*! RXDATA - Received data from the FIFO.
 */
#define SPI_FIFORD_RXDATA(x)                     (((uint32_t)(((uint32_t)(x)) << SPI_FIFORD_RXDATA_SHIFT)) & SPI_FIFORD_RXDATA_MASK)
#define SPI_FIFORD_RXSSEL0_N_MASK                (0x10000U)
#define SPI_FIFORD_RXSSEL0_N_SHIFT               (16U)
/*! RXSSEL0_N - Slave Select for receive. This field allows the state of the SSEL0 pin to be saved
 *    along with received data. The value will reflect the SSEL0 pin for both master and slave
 *    operation. A zero indicates that a slave select is active. The actual polarity of each slave select
 *    pin is configured by the related SPOL bit in CFG.
 */
#define SPI_FIFORD_RXSSEL0_N(x)                  (((uint32_t)(((uint32_t)(x)) << SPI_FIFORD_RXSSEL0_N_SHIFT)) & SPI_FIFORD_RXSSEL0_N_MASK)
#define SPI_FIFORD_RXSSEL1_N_MASK                (0x20000U)
#define SPI_FIFORD_RXSSEL1_N_SHIFT               (17U)
/*! RXSSEL1_N - Slave Select for receive. This field allows the state of the SSEL1 pin to be saved
 *    along with received data. The value will reflect the SSEL1 pin for both master and slave
 *    operation. A zero indicates that a slave select is active. The actual polarity of each slave select
 *    pin is configured by the related SPOL bit in CFG.
 */
#define SPI_FIFORD_RXSSEL1_N(x)                  (((uint32_t)(((uint32_t)(x)) << SPI_FIFORD_RXSSEL1_N_SHIFT)) & SPI_FIFORD_RXSSEL1_N_MASK)
#define SPI_FIFORD_RXSSEL2_N_MASK                (0x40000U)
#define SPI_FIFORD_RXSSEL2_N_SHIFT               (18U)
/*! RXSSEL2_N - Slave Select for receive. This field allows the state of the SSEL2 pin to be saved
 *    along with received data. The value will reflect the SSEL2 pin for both master and slave
 *    operation. A zero indicates that a slave select is active. The actual polarity of each slave select
 *    pin is configured by the related SPOL bit in CFG.
 */
#define SPI_FIFORD_RXSSEL2_N(x)                  (((uint32_t)(((uint32_t)(x)) << SPI_FIFORD_RXSSEL2_N_SHIFT)) & SPI_FIFORD_RXSSEL2_N_MASK)
#define SPI_FIFORD_RXSSEL3_N_MASK                (0x80000U)
#define SPI_FIFORD_RXSSEL3_N_SHIFT               (19U)
/*! RXSSEL3_N - Slave Select for receive. This field allows the state of the SSEL3 pin to be saved
 *    along with received data. The value will reflect the SSEL3 pin for both master and slave
 *    operation. A zero indicates that a slave select is active. The actual polarity of each slave select
 *    pin is configured by the related SPOL bit in CFG.
 */
#define SPI_FIFORD_RXSSEL3_N(x)                  (((uint32_t)(((uint32_t)(x)) << SPI_FIFORD_RXSSEL3_N_SHIFT)) & SPI_FIFORD_RXSSEL3_N_MASK)
#define SPI_FIFORD_SOT_MASK                      (0x100000U)
#define SPI_FIFORD_SOT_SHIFT                     (20U)
/*! SOT - Start of Transfer flag. This flag will be 1 if this is the first data after the SSELs went
 *    from deasserted to asserted (i.e., any previous transfer has ended). This information can be
 *    used to identify the first piece of data in cases where the transfer length is greater than 16
 *    bits.
 */
#define SPI_FIFORD_SOT(x)                        (((uint32_t)(((uint32_t)(x)) << SPI_FIFORD_SOT_SHIFT)) & SPI_FIFORD_SOT_MASK)
/*! @} */

/*! @name FIFORDNOPOP - FIFO data read with no FIFO pop. */
/*! @{ */
#define SPI_FIFORDNOPOP_RXDATA_MASK              (0xFFFFU)
#define SPI_FIFORDNOPOP_RXDATA_SHIFT             (0U)
/*! RXDATA - Received data from the FIFO.
 */
#define SPI_FIFORDNOPOP_RXDATA(x)                (((uint32_t)(((uint32_t)(x)) << SPI_FIFORDNOPOP_RXDATA_SHIFT)) & SPI_FIFORDNOPOP_RXDATA_MASK)
#define SPI_FIFORDNOPOP_RXSSEL0_N_MASK           (0x10000U)
#define SPI_FIFORDNOPOP_RXSSEL0_N_SHIFT          (16U)
/*! RXSSEL0_N - Slave Select for receive.
 */
#define SPI_FIFORDNOPOP_RXSSEL0_N(x)             (((uint32_t)(((uint32_t)(x)) << SPI_FIFORDNOPOP_RXSSEL0_N_SHIFT)) & SPI_FIFORDNOPOP_RXSSEL0_N_MASK)
#define SPI_FIFORDNOPOP_RXSSEL1_N_MASK           (0x20000U)
#define SPI_FIFORDNOPOP_RXSSEL1_N_SHIFT          (17U)
/*! RXSSEL1_N - Slave Select for receive.
 */
#define SPI_FIFORDNOPOP_RXSSEL1_N(x)             (((uint32_t)(((uint32_t)(x)) << SPI_FIFORDNOPOP_RXSSEL1_N_SHIFT)) & SPI_FIFORDNOPOP_RXSSEL1_N_MASK)
#define SPI_FIFORDNOPOP_RXSSEL2_N_MASK           (0x40000U)
#define SPI_FIFORDNOPOP_RXSSEL2_N_SHIFT          (18U)
/*! RXSSEL2_N - Slave Select for receive.
 */
#define SPI_FIFORDNOPOP_RXSSEL2_N(x)             (((uint32_t)(((uint32_t)(x)) << SPI_FIFORDNOPOP_RXSSEL2_N_SHIFT)) & SPI_FIFORDNOPOP_RXSSEL2_N_MASK)
#define SPI_FIFORDNOPOP_RXSSEL3_N_MASK           (0x80000U)
#define SPI_FIFORDNOPOP_RXSSEL3_N_SHIFT          (19U)
/*! RXSSEL3_N - Slave Select for receive.
 */
#define SPI_FIFORDNOPOP_RXSSEL3_N(x)             (((uint32_t)(((uint32_t)(x)) << SPI_FIFORDNOPOP_RXSSEL3_N_SHIFT)) & SPI_FIFORDNOPOP_RXSSEL3_N_MASK)
#define SPI_FIFORDNOPOP_SOT_MASK                 (0x100000U)
#define SPI_FIFORDNOPOP_SOT_SHIFT                (20U)
/*! SOT - Start of transfer flag.
 */
#define SPI_FIFORDNOPOP_SOT(x)                   (((uint32_t)(((uint32_t)(x)) << SPI_FIFORDNOPOP_SOT_SHIFT)) & SPI_FIFORDNOPOP_SOT_MASK)
/*! @} */

/*! @name ID - Peripheral identification register. */
/*! @{ */
#define SPI_ID_APERTURE_MASK                     (0xFFU)
#define SPI_ID_APERTURE_SHIFT                    (0U)
/*! APERTURE - Aperture: encoded as (aperture size/4K) -1, so 0x00 means a 4K aperture.
 */
#define SPI_ID_APERTURE(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_ID_APERTURE_SHIFT)) & SPI_ID_APERTURE_MASK)
#define SPI_ID_MINOR_REV_MASK                    (0xF00U)
#define SPI_ID_MINOR_REV_SHIFT                   (8U)
/*! MINOR_REV - Minor revision of module implementation.
 */
#define SPI_ID_MINOR_REV(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_ID_MINOR_REV_SHIFT)) & SPI_ID_MINOR_REV_MASK)
#define SPI_ID_MAJOR_REV_MASK                    (0xF000U)
#define SPI_ID_MAJOR_REV_SHIFT                   (12U)
/*! MAJOR_REV - Major revision of module implementation.
 */
#define SPI_ID_MAJOR_REV(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_ID_MAJOR_REV_SHIFT)) & SPI_ID_MAJOR_REV_MASK)
#define SPI_ID_ID_MASK                           (0xFFFF0000U)
#define SPI_ID_ID_SHIFT                          (16U)
/*! ID - Module identifier for the selected function.
 */
#define SPI_ID_ID(x)                             (((uint32_t)(((uint32_t)(x)) << SPI_ID_ID_SHIFT)) & SPI_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group SPI_Register_Masks */


/* SPI - Peripheral instance base addresses */
/** Peripheral SPI0 base address */
#define SPI0_BASE                                (0x40086000u)
/** Peripheral SPI0 base pointer */
#define SPI0                                     ((SPI_Type *)SPI0_BASE)
/** Peripheral SPI1 base address */
#define SPI1_BASE                                (0x40087000u)
/** Peripheral SPI1 base pointer */
#define SPI1                                     ((SPI_Type *)SPI1_BASE)
/** Peripheral SPI2 base address */
#define SPI2_BASE                                (0x40088000u)
/** Peripheral SPI2 base pointer */
#define SPI2                                     ((SPI_Type *)SPI2_BASE)
/** Peripheral SPI3 base address */
#define SPI3_BASE                                (0x40089000u)
/** Peripheral SPI3 base pointer */
#define SPI3                                     ((SPI_Type *)SPI3_BASE)
/** Peripheral SPI4 base address */
#define SPI4_BASE                                (0x4008A000u)
/** Peripheral SPI4 base pointer */
#define SPI4                                     ((SPI_Type *)SPI4_BASE)
/** Peripheral SPI5 base address */
#define SPI5_BASE                                (0x40096000u)
/** Peripheral SPI5 base pointer */
#define SPI5                                     ((SPI_Type *)SPI5_BASE)
/** Peripheral SPI6 base address */
#define SPI6_BASE                                (0x40097000u)
/** Peripheral SPI6 base pointer */
#define SPI6                                     ((SPI_Type *)SPI6_BASE)
/** Peripheral SPI7 base address */
#define SPI7_BASE                                (0x40098000u)
/** Peripheral SPI7 base pointer */
#define SPI7                                     ((SPI_Type *)SPI7_BASE)
/** Peripheral SPI8 base address */
#define SPI8_BASE                                (0x40099000u)
/** Peripheral SPI8 base pointer */
#define SPI8                                     ((SPI_Type *)SPI8_BASE)
/** Peripheral SPI9 base address */
#define SPI9_BASE                                (0x4009A000u)
/** Peripheral SPI9 base pointer */
#define SPI9                                     ((SPI_Type *)SPI9_BASE)
/** Peripheral SPI10 base address */
#define SPI10_BASE                               (0x4009F000u)
/** Peripheral SPI10 base pointer */
#define SPI10                                    ((SPI_Type *)SPI10_BASE)
/** Array initializer of SPI peripheral base addresses */
#define SPI_BASE_ADDRS                           { SPI0_BASE, SPI1_BASE, SPI2_BASE, SPI3_BASE, SPI4_BASE, SPI5_BASE, SPI6_BASE, SPI7_BASE, SPI8_BASE, SPI9_BASE, SPI10_BASE }
/** Array initializer of SPI peripheral base pointers */
#define SPI_BASE_PTRS                            { SPI0, SPI1, SPI2, SPI3, SPI4, SPI5, SPI6, SPI7, SPI8, SPI9, SPI10 }
/** Interrupt vectors for the SPI peripheral type */
#define SPI_IRQS                                 { FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, FLEXCOMM6_IRQn, FLEXCOMM7_IRQn, FLEXCOMM8_IRQn, FLEXCOMM9_IRQn, FLEXCOMM10_IRQn }

/*!
 * @}
 */ /* end of group SPI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- SPIFI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPIFI_Peripheral_Access_Layer SPIFI Peripheral Access Layer
 * @{
 */

/** SPIFI - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< SPIFI control register, offset: 0x0 */
  __IO uint32_t CMD;                               /**< SPIFI command register, offset: 0x4 */
  __IO uint32_t ADDR;                              /**< SPIFI address register, offset: 0x8 */
  __IO uint32_t IDATA;                             /**< SPIFI intermediate data register, offset: 0xC */
  __IO uint32_t CLIMIT;                            /**< SPIFI limit register, offset: 0x10 */
  __IO uint32_t DATA;                              /**< SPIFI data register, offset: 0x14 */
  __IO uint32_t MCMD;                              /**< SPIFI memory command register, offset: 0x18 */
  __IO uint32_t STAT;                              /**< SPIFI status register, offset: 0x1C */
} SPIFI_Type;

/* ----------------------------------------------------------------------------
   -- SPIFI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPIFI_Register_Masks SPIFI Register Masks
 * @{
 */

/*! @name CTRL - SPIFI control register */
/*! @{ */
#define SPIFI_CTRL_TIMEOUT_MASK                  (0xFFFFU)
#define SPIFI_CTRL_TIMEOUT_SHIFT                 (0U)
/*! TIMEOUT - This field contains the number of serial clock periods without the processor reading
 *    data in memory mode, which will cause the SPIFI hardware to terminate the command by driving
 *    the CS pin high and negating the CMD bit in the Status register. (This allows the flash memory
 *    to enter a lower-power state.) If the processor reads data from the flash region after a
 *    time-out, the command in the Memory Command Register is issued again.
 */
#define SPIFI_CTRL_TIMEOUT(x)                    (((uint32_t)(((uint32_t)(x)) << SPIFI_CTRL_TIMEOUT_SHIFT)) & SPIFI_CTRL_TIMEOUT_MASK)
#define SPIFI_CTRL_CSHIGH_MASK                   (0xF0000U)
#define SPIFI_CTRL_CSHIGH_SHIFT                  (16U)
/*! CSHIGH - This field controls the minimum CS high time, expressed as a number of serial clock periods minus one.
 */
#define SPIFI_CTRL_CSHIGH(x)                     (((uint32_t)(((uint32_t)(x)) << SPIFI_CTRL_CSHIGH_SHIFT)) & SPIFI_CTRL_CSHIGH_MASK)
#define SPIFI_CTRL_D_PRFTCH_DIS_MASK             (0x200000U)
#define SPIFI_CTRL_D_PRFTCH_DIS_SHIFT            (21U)
/*! D_PRFTCH_DIS - This bit allows conditioning of memory mode prefetches based on the AHB HPROT
 *    (instruction/data) access information. A 1 in this register means that the SPIFI will not attempt
 *    a speculative prefetch when it encounters data accesses.
 */
#define SPIFI_CTRL_D_PRFTCH_DIS(x)               (((uint32_t)(((uint32_t)(x)) << SPIFI_CTRL_D_PRFTCH_DIS_SHIFT)) & SPIFI_CTRL_D_PRFTCH_DIS_MASK)
#define SPIFI_CTRL_INTEN_MASK                    (0x400000U)
#define SPIFI_CTRL_INTEN_SHIFT                   (22U)
/*! INTEN - If this bit is 1 when a command ends, the SPIFI will assert its interrupt request
 *    output. See INTRQ in the status register for further details.
 */
#define SPIFI_CTRL_INTEN(x)                      (((uint32_t)(((uint32_t)(x)) << SPIFI_CTRL_INTEN_SHIFT)) & SPIFI_CTRL_INTEN_MASK)
#define SPIFI_CTRL_MODE3_MASK                    (0x800000U)
#define SPIFI_CTRL_MODE3_SHIFT                   (23U)
/*! MODE3 - SPI Mode 3 select.
 *  0b0..SCK LOW. The SPIFI drives SCK low after the rising edge at which the last bit of each command is
 *       captured, and keeps it low while CS is HIGH.
 *  0b1..SCK HIGH. the SPIFI keeps SCK high after the rising edge for the last bit of each command and while CS is
 *       HIGH, and drives it low after it drives CS LOW. (Known serial flash devices can handle either mode, but
 *       some devices may require a particular mode for proper operation.) MODE3, RFCLK, and FBCLK should not all be
 *       1, because in this case there is no final falling edge on SCK on which to sample the last data bit of the
 *       frame.
 */
#define SPIFI_CTRL_MODE3(x)                      (((uint32_t)(((uint32_t)(x)) << SPIFI_CTRL_MODE3_SHIFT)) & SPIFI_CTRL_MODE3_MASK)
#define SPIFI_CTRL_PRFTCH_DIS_MASK               (0x8000000U)
#define SPIFI_CTRL_PRFTCH_DIS_SHIFT              (27U)
/*! PRFTCH_DIS - Cache prefetching enable. The SPIFI includes an internal cache. A 1 in this bit disables prefetching of cache lines.
 *  0b0..Enable. Cache prefetching enabled.
 *  0b1..Disable. Disables prefetching of cache lines.
 */
#define SPIFI_CTRL_PRFTCH_DIS(x)                 (((uint32_t)(((uint32_t)(x)) << SPIFI_CTRL_PRFTCH_DIS_SHIFT)) & SPIFI_CTRL_PRFTCH_DIS_MASK)
#define SPIFI_CTRL_DUAL_MASK                     (0x10000000U)
#define SPIFI_CTRL_DUAL_SHIFT                    (28U)
/*! DUAL - Select dual protocol.
 *  0b0..Quad protocol. This protocol uses IO3:0.
 *  0b1..Dual protocol. This protocol uses IO1:0.
 */
#define SPIFI_CTRL_DUAL(x)                       (((uint32_t)(((uint32_t)(x)) << SPIFI_CTRL_DUAL_SHIFT)) & SPIFI_CTRL_DUAL_MASK)
#define SPIFI_CTRL_RFCLK_MASK                    (0x20000000U)
#define SPIFI_CTRL_RFCLK_SHIFT                   (29U)
/*! RFCLK - Select active clock edge for input data.
 *  0b0..Rising edge. Read data is sampled on rising edges on the clock, as in classic SPI operation.
 *  0b1..Falling edge. Read data is sampled on falling edges of the clock, allowing a full serial clock of of time
 *       in order to maximize the serial clock frequency. MODE3, RFCLK, and FBCLK should not all be 1, because in
 *       this case there is no final falling edge on SCK on which to sample the last data bit of the frame.
 */
#define SPIFI_CTRL_RFCLK(x)                      (((uint32_t)(((uint32_t)(x)) << SPIFI_CTRL_RFCLK_SHIFT)) & SPIFI_CTRL_RFCLK_MASK)
#define SPIFI_CTRL_FBCLK_MASK                    (0x40000000U)
#define SPIFI_CTRL_FBCLK_SHIFT                   (30U)
/*! FBCLK - Feedback clock select.
 *  0b0..Internal clock. The SPIFI samples read data using an internal clock.
 *  0b1..Feedback clock. Read data is sampled using a feedback clock from the SCK pin. This allows slightly more
 *       time for each received bit. MODE3, RFCLK, and FBCLK should not all be 1, because in this case there is no
 *       final falling edge on SCK on which to sample the last data bit of the frame.
 */
#define SPIFI_CTRL_FBCLK(x)                      (((uint32_t)(((uint32_t)(x)) << SPIFI_CTRL_FBCLK_SHIFT)) & SPIFI_CTRL_FBCLK_MASK)
#define SPIFI_CTRL_DMAEN_MASK                    (0x80000000U)
#define SPIFI_CTRL_DMAEN_SHIFT                   (31U)
/*! DMAEN - A 1 in this bit enables the DMA Request output from the SPIFI. Set this bit only when a
 *    DMA channel is used to transfer data in peripheral mode. Do not set this bit when a DMA
 *    channel is used for memory-to-memory transfers from the SPIFI memory area. DMAEN should only be used
 *    in Command mode.
 */
#define SPIFI_CTRL_DMAEN(x)                      (((uint32_t)(((uint32_t)(x)) << SPIFI_CTRL_DMAEN_SHIFT)) & SPIFI_CTRL_DMAEN_MASK)
/*! @} */

/*! @name CMD - SPIFI command register */
/*! @{ */
#define SPIFI_CMD_DATALEN_MASK                   (0x3FFFU)
#define SPIFI_CMD_DATALEN_SHIFT                  (0U)
/*! DATALEN - Except when the POLL bit in this register is 1, this field controls how many data
 *    bytes are in the command. 0 indicates that the command does not contain a data field.
 */
#define SPIFI_CMD_DATALEN(x)                     (((uint32_t)(((uint32_t)(x)) << SPIFI_CMD_DATALEN_SHIFT)) & SPIFI_CMD_DATALEN_MASK)
#define SPIFI_CMD_POLL_MASK                      (0x4000U)
#define SPIFI_CMD_POLL_SHIFT                     (14U)
/*! POLL - This bit should be written as 1 only with an opcode that a) contains an input data field,
 *    and b) causes the serial flash device to return byte status repetitively (e.g., a Read Status
 *    command). When this bit is 1, the SPIFI hardware continues to read bytes until the test
 *    specified by the DATALEN field is met. The hardware tests the bit in each status byte selected by
 *    DATALEN bits 2:0, until a bit is found that is equal to DATALEN bit 3. When the test succeeds,
 *    the SPIFI captures the byte that meets this test so that it can be read from the Data
 *    Register, and terminates the command by raising CS. The end-of-command interrupt can be enabled to
 *    inform software when this occurs
 */
#define SPIFI_CMD_POLL(x)                        (((uint32_t)(((uint32_t)(x)) << SPIFI_CMD_POLL_SHIFT)) & SPIFI_CMD_POLL_MASK)
#define SPIFI_CMD_DOUT_MASK                      (0x8000U)
#define SPIFI_CMD_DOUT_SHIFT                     (15U)
/*! DOUT - If the DATALEN field is not zero, this bit controls the direction of the data:
 *  0b0..Input from serial flash.
 *  0b1..Output to serial flash.
 */
#define SPIFI_CMD_DOUT(x)                        (((uint32_t)(((uint32_t)(x)) << SPIFI_CMD_DOUT_SHIFT)) & SPIFI_CMD_DOUT_MASK)
#define SPIFI_CMD_INTLEN_MASK                    (0x70000U)
#define SPIFI_CMD_INTLEN_SHIFT                   (16U)
/*! INTLEN - This field controls how many intermediate bytes precede the data. (Each such byte may
 *    require 8 or 2 SCK cycles, depending on whether the intermediate field is in serial, 2-bit, or
 *    4-bit format.) Intermediate bytes are output by the SPIFI, and include post-address control
 *    information, dummy and delay bytes. See the description of the Intermediate Data register for
 *    the contents of such bytes.
 */
#define SPIFI_CMD_INTLEN(x)                      (((uint32_t)(((uint32_t)(x)) << SPIFI_CMD_INTLEN_SHIFT)) & SPIFI_CMD_INTLEN_MASK)
#define SPIFI_CMD_FIELDFORM_MASK                 (0x180000U)
#define SPIFI_CMD_FIELDFORM_SHIFT                (19U)
/*! FIELDFORM - This field controls how the fields of the command are sent.
 *  0b00..All serial. All fields of the command are serial.
 *  0b01..Quad/dual data. Data field is quad/dual, other fields are serial.
 *  0b10..Serial opcode. Opcode field is serial. Other fields are quad/dual.
 *  0b11..All quad/dual. All fields of the command are in quad/dual format.
 */
#define SPIFI_CMD_FIELDFORM(x)                   (((uint32_t)(((uint32_t)(x)) << SPIFI_CMD_FIELDFORM_SHIFT)) & SPIFI_CMD_FIELDFORM_MASK)
#define SPIFI_CMD_FRAMEFORM_MASK                 (0xE00000U)
#define SPIFI_CMD_FRAMEFORM_SHIFT                (21U)
/*! FRAMEFORM - This field controls the opcode and address fields.
 *  0b000..Reserved.
 *  0b001..Opcode. Opcode only, no address.
 *  0b010..Opcode one byte. Opcode, least significant byte of address.
 *  0b011..Opcode two bytes. Opcode, two least significant bytes of address.
 *  0b100..Opcode three bytes. Opcode, three least significant bytes of address.
 *  0b101..Opcode four bytes. Opcode, 4 bytes of address.
 *  0b110..No opcode three bytes. No opcode, 3 least significant bytes of address.
 *  0b111..No opcode four bytes. No opcode, 4 bytes of address.
 */
#define SPIFI_CMD_FRAMEFORM(x)                   (((uint32_t)(((uint32_t)(x)) << SPIFI_CMD_FRAMEFORM_SHIFT)) & SPIFI_CMD_FRAMEFORM_MASK)
#define SPIFI_CMD_OPCODE_MASK                    (0xFF000000U)
#define SPIFI_CMD_OPCODE_SHIFT                   (24U)
/*! OPCODE - The opcode of the command (not used for some FRAMEFORM values).
 */
#define SPIFI_CMD_OPCODE(x)                      (((uint32_t)(((uint32_t)(x)) << SPIFI_CMD_OPCODE_SHIFT)) & SPIFI_CMD_OPCODE_MASK)
/*! @} */

/*! @name ADDR - SPIFI address register */
/*! @{ */
#define SPIFI_ADDR_ADDRESS_MASK                  (0xFFFFFFFFU)
#define SPIFI_ADDR_ADDRESS_SHIFT                 (0U)
/*! ADDRESS - Address.
 */
#define SPIFI_ADDR_ADDRESS(x)                    (((uint32_t)(((uint32_t)(x)) << SPIFI_ADDR_ADDRESS_SHIFT)) & SPIFI_ADDR_ADDRESS_MASK)
/*! @} */

/*! @name IDATA - SPIFI intermediate data register */
/*! @{ */
#define SPIFI_IDATA_IDATA_MASK                   (0xFFFFFFFFU)
#define SPIFI_IDATA_IDATA_SHIFT                  (0U)
/*! IDATA - Value of intermediate bytes.
 */
#define SPIFI_IDATA_IDATA(x)                     (((uint32_t)(((uint32_t)(x)) << SPIFI_IDATA_IDATA_SHIFT)) & SPIFI_IDATA_IDATA_MASK)
/*! @} */

/*! @name CLIMIT - SPIFI limit register */
/*! @{ */
#define SPIFI_CLIMIT_CLIMIT_MASK                 (0xFFFFFFFFU)
#define SPIFI_CLIMIT_CLIMIT_SHIFT                (0U)
/*! CLIMIT - Zero-based upper limit of cacheable memory
 */
#define SPIFI_CLIMIT_CLIMIT(x)                   (((uint32_t)(((uint32_t)(x)) << SPIFI_CLIMIT_CLIMIT_SHIFT)) & SPIFI_CLIMIT_CLIMIT_MASK)
/*! @} */

/*! @name DATA - SPIFI data register */
/*! @{ */
#define SPIFI_DATA_DATA_MASK                     (0xFFFFFFFFU)
#define SPIFI_DATA_DATA_SHIFT                    (0U)
/*! DATA - Input or output data
 */
#define SPIFI_DATA_DATA(x)                       (((uint32_t)(((uint32_t)(x)) << SPIFI_DATA_DATA_SHIFT)) & SPIFI_DATA_DATA_MASK)
/*! @} */

/*! @name MCMD - SPIFI memory command register */
/*! @{ */
#define SPIFI_MCMD_POLL_MASK                     (0x4000U)
#define SPIFI_MCMD_POLL_SHIFT                    (14U)
/*! POLL - This bit should be written as 0.
 */
#define SPIFI_MCMD_POLL(x)                       (((uint32_t)(((uint32_t)(x)) << SPIFI_MCMD_POLL_SHIFT)) & SPIFI_MCMD_POLL_MASK)
#define SPIFI_MCMD_DOUT_MASK                     (0x8000U)
#define SPIFI_MCMD_DOUT_SHIFT                    (15U)
/*! DOUT - This bit should be written as 0.
 */
#define SPIFI_MCMD_DOUT(x)                       (((uint32_t)(((uint32_t)(x)) << SPIFI_MCMD_DOUT_SHIFT)) & SPIFI_MCMD_DOUT_MASK)
#define SPIFI_MCMD_INTLEN_MASK                   (0x70000U)
#define SPIFI_MCMD_INTLEN_SHIFT                  (16U)
/*! INTLEN - This field controls how many intermediate bytes precede the data. (Each such byte may
 *    require 8 or 2 SCK cycles, depending on whether the intermediate field is in serial, 2-bit, or
 *    4-bit format.) Intermediate bytes are output by the SPIFI, and include post-address control
 *    information, dummy and delay bytes. See the description of the Intermediate Data register for
 *    the contents of such bytes.
 */
#define SPIFI_MCMD_INTLEN(x)                     (((uint32_t)(((uint32_t)(x)) << SPIFI_MCMD_INTLEN_SHIFT)) & SPIFI_MCMD_INTLEN_MASK)
#define SPIFI_MCMD_FIELDFORM_MASK                (0x180000U)
#define SPIFI_MCMD_FIELDFORM_SHIFT               (19U)
/*! FIELDFORM - This field controls how the fields of the command are sent.
 *  0b00..All serial. All fields of the command are serial.
 *  0b01..Quad/dual data. Data field is quad/dual, other fields are serial.
 *  0b10..Serial opcode. Opcode field is serial. Other fields are quad/dual.
 *  0b11..All quad/dual. All fields of the command are in quad/dual format.
 */
#define SPIFI_MCMD_FIELDFORM(x)                  (((uint32_t)(((uint32_t)(x)) << SPIFI_MCMD_FIELDFORM_SHIFT)) & SPIFI_MCMD_FIELDFORM_MASK)
#define SPIFI_MCMD_FRAMEFORM_MASK                (0xE00000U)
#define SPIFI_MCMD_FRAMEFORM_SHIFT               (21U)
/*! FRAMEFORM - This field controls the opcode and address fields.
 *  0b000..Reserved.
 *  0b001..Opcode. Opcode only, no address.
 *  0b010..Opcode one byte. Opcode, least-significant byte of address.
 *  0b011..Opcode two bytes. Opcode, 2 least-significant bytes of address.
 *  0b100..Opcode three bytes. Opcode, 3 least-significant bytes of address.
 *  0b101..Opcode four bytes. Opcode, 4 bytes of address.
 *  0b110..No opcode three bytes. No opcode, 3 least-significant bytes of address.
 *  0b111..No opcode, 4 bytes of address.
 */
#define SPIFI_MCMD_FRAMEFORM(x)                  (((uint32_t)(((uint32_t)(x)) << SPIFI_MCMD_FRAMEFORM_SHIFT)) & SPIFI_MCMD_FRAMEFORM_MASK)
#define SPIFI_MCMD_OPCODE_MASK                   (0xFF000000U)
#define SPIFI_MCMD_OPCODE_SHIFT                  (24U)
/*! OPCODE - The opcode of the command (not used for some FRAMEFORM values).
 */
#define SPIFI_MCMD_OPCODE(x)                     (((uint32_t)(((uint32_t)(x)) << SPIFI_MCMD_OPCODE_SHIFT)) & SPIFI_MCMD_OPCODE_MASK)
/*! @} */

/*! @name STAT - SPIFI status register */
/*! @{ */
#define SPIFI_STAT_MCINIT_MASK                   (0x1U)
#define SPIFI_STAT_MCINIT_SHIFT                  (0U)
/*! MCINIT - This bit is set when software successfully writes the Memory Command register, and is
 *    cleared by Reset or by writing a 1 to the RESET bit in this register.
 */
#define SPIFI_STAT_MCINIT(x)                     (((uint32_t)(((uint32_t)(x)) << SPIFI_STAT_MCINIT_SHIFT)) & SPIFI_STAT_MCINIT_MASK)
#define SPIFI_STAT_CMD_MASK                      (0x2U)
#define SPIFI_STAT_CMD_SHIFT                     (1U)
/*! CMD - This bit is 1 when the Command register is written. It is cleared by a hardware reset, a
 *    write to the RESET bit in this register, or the deassertion of CS which indicates that the
 *    command has completed communication with the SPI Flash.
 */
#define SPIFI_STAT_CMD(x)                        (((uint32_t)(((uint32_t)(x)) << SPIFI_STAT_CMD_SHIFT)) & SPIFI_STAT_CMD_MASK)
#define SPIFI_STAT_RESET_MASK                    (0x10U)
#define SPIFI_STAT_RESET_SHIFT                   (4U)
/*! RESET - Write a 1 to this bit to abort a current command or memory mode. This bit is cleared
 *    when the hardware is ready for a new command to be written to the Command register.
 */
#define SPIFI_STAT_RESET(x)                      (((uint32_t)(((uint32_t)(x)) << SPIFI_STAT_RESET_SHIFT)) & SPIFI_STAT_RESET_MASK)
#define SPIFI_STAT_INTRQ_MASK                    (0x20U)
#define SPIFI_STAT_INTRQ_SHIFT                   (5U)
/*! INTRQ - This bit reflects the SPIFI interrupt request. Write a 1 to this bit to clear it. This
 *    bit is set when a CMD was previously 1 and has been cleared due to the deassertion of CS.
 */
#define SPIFI_STAT_INTRQ(x)                      (((uint32_t)(((uint32_t)(x)) << SPIFI_STAT_INTRQ_SHIFT)) & SPIFI_STAT_INTRQ_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group SPIFI_Register_Masks */


/* SPIFI - Peripheral instance base addresses */
/** Peripheral SPIFI0 base address */
#define SPIFI0_BASE                              (0x40080000u)
/** Peripheral SPIFI0 base pointer */
#define SPIFI0                                   ((SPIFI_Type *)SPIFI0_BASE)
/** Array initializer of SPIFI peripheral base addresses */
#define SPIFI_BASE_ADDRS                         { SPIFI0_BASE }
/** Array initializer of SPIFI peripheral base pointers */
#define SPIFI_BASE_PTRS                          { SPIFI0 }
/** Interrupt vectors for the SPIFI peripheral type */
#define SPIFI_IRQS                               { SPIFI0_IRQn }

/*!
 * @}
 */ /* end of group SPIFI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- SYSCON Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SYSCON_Peripheral_Access_Layer SYSCON Peripheral Access Layer
 * @{
 */

/** SYSCON - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __IO uint32_t AHBMATPRIO;                        /**< AHB multilayer matrix priority control, offset: 0x10 */
       uint8_t RESERVED_1[44];
  __IO uint32_t SYSTCKCAL;                         /**< System tick counter calibration, offset: 0x40 */
       uint8_t RESERVED_2[4];
  __IO uint32_t NMISRC;                            /**< NMI Source Select, offset: 0x48 */
  __IO uint32_t ASYNCAPBCTRL;                      /**< Asynchronous APB Control, offset: 0x4C */
       uint8_t RESERVED_3[112];
  __I  uint32_t PIOPORCAP[2];                      /**< POR captured value of port n, array offset: 0xC0, array step: 0x4 */
       uint8_t RESERVED_4[8];
  __I  uint32_t PIORESCAP[2];                      /**< Reset captured value of port n, array offset: 0xD0, array step: 0x4 */
       uint8_t RESERVED_5[40];
  __IO uint32_t PRESETCTRL[3];                     /**< Peripheral reset control n, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_6[20];
  __O  uint32_t PRESETCTRLSET[3];                  /**< Set bits in PRESETCTRLn, array offset: 0x120, array step: 0x4 */
       uint8_t RESERVED_7[20];
  __O  uint32_t PRESETCTRLCLR[3];                  /**< Clear bits in PRESETCTRLn, array offset: 0x140, array step: 0x4 */
       uint8_t RESERVED_8[164];
  __IO uint32_t SYSRSTSTAT;                        /**< System reset status register, offset: 0x1F0 */
       uint8_t RESERVED_9[12];
  __IO uint32_t AHBCLKCTRL[3];                     /**< AHB Clock control n, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_10[20];
  __O  uint32_t AHBCLKCTRLSET[3];                  /**< Set bits in AHBCLKCTRLn, array offset: 0x220, array step: 0x4 */
       uint8_t RESERVED_11[20];
  __O  uint32_t AHBCLKCTRLCLR[3];                  /**< Clear bits in AHBCLKCTRLn, array offset: 0x240, array step: 0x4 */
       uint8_t RESERVED_12[48];
  __IO uint32_t STICKCLKSEL;                       /**< Systick timer clock source selection, offset: 0x27C */
  __IO uint32_t MAINCLKSELA;                       /**< Main clock source select A, offset: 0x280 */
  __IO uint32_t MAINCLKSELB;                       /**< Main clock source select B, offset: 0x284 */
  __IO uint32_t CLKOUTSELA;                        /**< CLKOUT clock source select A, offset: 0x288 */
       uint8_t RESERVED_13[4];
  __IO uint32_t SYSPLLCLKSEL;                      /**< PLL clock source select, offset: 0x290 */
       uint8_t RESERVED_14[4];
  __IO uint32_t AUDPLLCLKSEL;                      /**< Audio PLL clock source select, offset: 0x298 */
       uint8_t RESERVED_15[4];
  __IO uint32_t SPIFICLKSEL;                       /**< SPIFI clock source select, offset: 0x2A0 */
  __IO uint32_t ADCCLKSEL;                         /**< ADC clock source select, offset: 0x2A4 */
  __IO uint32_t USB0CLKSEL;                        /**< USB0 clock source select, offset: 0x2A8 */
  __IO uint32_t USB1CLKSEL;                        /**< USB1 clock source select, offset: 0x2AC */
  __IO uint32_t FCLKSEL[10];                       /**< Flexcomm clock source select, array offset: 0x2B0, array step: 0x4 */
  __IO uint32_t FCLKSEL10;                         /**< Flexcomm 10 clock source select, offset: 0x2D8 */
       uint8_t RESERVED_16[4];
  __IO uint32_t MCLKCLKSEL;                        /**< MCLK clock source select, offset: 0x2E0 */
       uint8_t RESERVED_17[4];
  __IO uint32_t FRGCLKSEL;                         /**< Fractional Rate Generator clock source select, offset: 0x2E8 */
  __IO uint32_t DMICCLKSEL;                        /**< Digital microphone (DMIC) subsystem clock select, offset: 0x2EC */
  __IO uint32_t SCTCLKSEL;                         /**< SCTimer/PWM clock source select, offset: 0x2F0 */
  __IO uint32_t LCDCLKSEL;                         /**< LCD clock source select, offset: 0x2F4 */
  __IO uint32_t SDIOCLKSEL;                        /**< SDIO clock source select, offset: 0x2F8 */
       uint8_t RESERVED_18[4];
  __IO uint32_t SYSTICKCLKDIV;                     /**< SYSTICK clock divider, offset: 0x300 */
  __IO uint32_t ARMTRACECLKDIV;                    /**< ARM Trace clock divider, offset: 0x304 */
  __IO uint32_t CAN0CLKDIV;                        /**< MCAN0 clock divider, offset: 0x308 */
  __IO uint32_t CAN1CLKDIV;                        /**< MCAN1 clock divider, offset: 0x30C */
  __IO uint32_t SC0CLKDIV;                         /**< Smartcard0 clock divider, offset: 0x310 */
  __IO uint32_t SC1CLKDIV;                         /**< Smartcard1 clock divider, offset: 0x314 */
       uint8_t RESERVED_19[104];
  __IO uint32_t AHBCLKDIV;                         /**< AHB clock divider, offset: 0x380 */
  __IO uint32_t CLKOUTDIV;                         /**< CLKOUT clock divider, offset: 0x384 */
  __IO uint32_t FROHFDIV;                          /**< FROHF clock divider, offset: 0x388 */
       uint8_t RESERVED_20[4];
  __IO uint32_t SPIFICLKDIV;                       /**< SPIFI clock divider, offset: 0x390 */
  __IO uint32_t ADCCLKDIV;                         /**< ADC clock divider, offset: 0x394 */
  __IO uint32_t USB0CLKDIV;                        /**< USB0 clock divider, offset: 0x398 */
  __IO uint32_t USB1CLKDIV;                        /**< USB1 clock divider, offset: 0x39C */
  __IO uint32_t FRGCTRL;                           /**< Fractional rate divider, offset: 0x3A0 */
       uint8_t RESERVED_21[4];
  __IO uint32_t DMICCLKDIV;                        /**< DMIC clock divider, offset: 0x3A8 */
  __IO uint32_t MCLKDIV;                           /**< I2S MCLK clock divider, offset: 0x3AC */
  __IO uint32_t LCDCLKDIV;                         /**< LCD clock divider, offset: 0x3B0 */
  __IO uint32_t SCTCLKDIV;                         /**< SCT/PWM clock divider, offset: 0x3B4 */
  __IO uint32_t EMCCLKDIV;                         /**< EMC clock divider, offset: 0x3B8 */
  __IO uint32_t SDIOCLKDIV;                        /**< SDIO clock divider, offset: 0x3BC */
       uint8_t RESERVED_22[76];
  __IO uint32_t USB0CLKCTRL;                       /**< USB0 clock control, offset: 0x40C */
  __IO uint32_t USB0CLKSTAT;                       /**< USB0 clock status, offset: 0x410 */
       uint8_t RESERVED_23[4];
  __IO uint32_t FREQMECTRL;                        /**< Frequency measure register, offset: 0x418 */
       uint8_t RESERVED_24[4];
  __IO uint32_t MCLKIO;                            /**< MCLK input/output control, offset: 0x420 */
  __IO uint32_t USB1CLKCTRL;                       /**< USB1 clock control, offset: 0x424 */
  __IO uint32_t USB1CLKSTAT;                       /**< USB1 clock status, offset: 0x428 */
       uint8_t RESERVED_25[24];
  __IO uint32_t EMCSYSCTRL;                        /**< EMC system control, offset: 0x444 */
  __IO uint32_t EMCDYCTRL;                         /**< EMC clock delay control, offset: 0x448 */
  __IO uint32_t EMCCAL;                            /**< EMC delay chain calibration control, offset: 0x44C */
  __IO uint32_t ETHPHYSEL;                         /**< Ethernet PHY Selection, offset: 0x450 */
  __IO uint32_t ETHSBDCTRL;                        /**< Ethernet SBD flow control, offset: 0x454 */
       uint8_t RESERVED_26[8];
  __IO uint32_t SDIOCLKCTRL;                       /**< SDIO CCLKIN phase and delay control, offset: 0x460 */
       uint8_t RESERVED_27[12];
  __IO uint32_t KEYMUXSEL;                         /**< AES key source selection, offset: 0x470 */
       uint8_t RESERVED_28[140];
  __IO uint32_t FROCTRL;                           /**< FRO oscillator control, offset: 0x500 */
  __IO uint32_t SYSOSCCTRL;                        /**< System oscillator control, offset: 0x504 */
  __IO uint32_t WDTOSCCTRL;                        /**< Watchdog oscillator control, offset: 0x508 */
  __IO uint32_t RTCOSCCTRL;                        /**< RTC oscillator 32 kHz output control, offset: 0x50C */
       uint8_t RESERVED_29[12];
  __IO uint32_t USBPLLCTRL;                        /**< USB PLL control, offset: 0x51C */
  __IO uint32_t USBPLLSTAT;                        /**< USB PLL status, offset: 0x520 */
       uint8_t RESERVED_30[92];
  __IO uint32_t SYSPLLCTRL;                        /**< System PLL control, offset: 0x580 */
  __IO uint32_t SYSPLLSTAT;                        /**< PLL status, offset: 0x584 */
  __IO uint32_t SYSPLLNDEC;                        /**< PLL N divider, offset: 0x588 */
  __IO uint32_t SYSPLLPDEC;                        /**< PLL P divider, offset: 0x58C */
  __IO uint32_t SYSPLLMDEC;                        /**< System PLL M divider, offset: 0x590 */
       uint8_t RESERVED_31[12];
  __IO uint32_t AUDPLLCTRL;                        /**< Audio PLL control, offset: 0x5A0 */
  __IO uint32_t AUDPLLSTAT;                        /**< Audio PLL status, offset: 0x5A4 */
  __IO uint32_t AUDPLLNDEC;                        /**< Audio PLL N divider, offset: 0x5A8 */
  __IO uint32_t AUDPLLPDEC;                        /**< Audio PLL P divider, offset: 0x5AC */
  __IO uint32_t AUDPLLMDEC;                        /**< Audio PLL M divider, offset: 0x5B0 */
  __IO uint32_t AUDPLLFRAC;                        /**< Audio PLL fractional divider control, offset: 0x5B4 */
       uint8_t RESERVED_32[72];
  __IO uint32_t PDSLEEPCFG[2];                     /**< Sleep configuration register, array offset: 0x600, array step: 0x4 */
       uint8_t RESERVED_33[8];
  __IO uint32_t PDRUNCFG[2];                       /**< Power configuration register, array offset: 0x610, array step: 0x4 */
       uint8_t RESERVED_34[8];
  __IO uint32_t PDRUNCFGSET[2];                    /**< Power configuration set register, array offset: 0x620, array step: 0x4 */
       uint8_t RESERVED_35[8];
  __IO uint32_t PDRUNCFGCLR[2];                    /**< Power configuration clear register, array offset: 0x630, array step: 0x4 */
       uint8_t RESERVED_36[72];
  __IO uint32_t STARTER[2];                        /**< Start logic 0 wake-up enable register, array offset: 0x680, array step: 0x4 */
       uint8_t RESERVED_37[24];
  __O  uint32_t STARTERSET[2];                     /**< Set bits in STARTER, array offset: 0x6A0, array step: 0x4 */
       uint8_t RESERVED_38[24];
  __O  uint32_t STARTERCLR[2];                     /**< Clear bits in STARTER0, array offset: 0x6C0, array step: 0x4 */
       uint8_t RESERVED_39[184];
  __IO uint32_t HWWAKE;                            /**< Configures special cases of hardware wake-up, offset: 0x780 */
       uint8_t RESERVED_40[1664];
  __IO uint32_t AUTOCGOR;                          /**< Auto Clock-Gate Override Register, offset: 0xE04 */
       uint8_t RESERVED_41[492];
  __I  uint32_t JTAGIDCODE;                        /**< JTAG ID code register, offset: 0xFF4 */
  __I  uint32_t DEVICE_ID0;                        /**< Part ID register, offset: 0xFF8 */
  __I  uint32_t DEVICE_ID1;                        /**< Boot ROM and die revision register, offset: 0xFFC */
       uint8_t RESERVED_42[127044];
  __IO uint32_t BODCTRL;                           /**< Brown-Out Detect control, offset: 0x20044 */
} SYSCON_Type;

/* ----------------------------------------------------------------------------
   -- SYSCON Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SYSCON_Register_Masks SYSCON Register Masks
 * @{
 */

/*! @name AHBMATPRIO - AHB multilayer matrix priority control */
/*! @{ */
#define SYSCON_AHBMATPRIO_PRI_ICODE_MASK         (0x3U)
#define SYSCON_AHBMATPRIO_PRI_ICODE_SHIFT        (0U)
/*! PRI_ICODE - I-Code bus priority.
 */
#define SYSCON_AHBMATPRIO_PRI_ICODE(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBMATPRIO_PRI_ICODE_SHIFT)) & SYSCON_AHBMATPRIO_PRI_ICODE_MASK)
#define SYSCON_AHBMATPRIO_PRI_DCODE_MASK         (0xCU)
#define SYSCON_AHBMATPRIO_PRI_DCODE_SHIFT        (2U)
/*! PRI_DCODE - D-Code bus priority.
 */
#define SYSCON_AHBMATPRIO_PRI_DCODE(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBMATPRIO_PRI_DCODE_SHIFT)) & SYSCON_AHBMATPRIO_PRI_DCODE_MASK)
#define SYSCON_AHBMATPRIO_PRI_SYS_MASK           (0x30U)
#define SYSCON_AHBMATPRIO_PRI_SYS_SHIFT          (4U)
/*! PRI_SYS - System bus priority.
 */
#define SYSCON_AHBMATPRIO_PRI_SYS(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBMATPRIO_PRI_SYS_SHIFT)) & SYSCON_AHBMATPRIO_PRI_SYS_MASK)
#define SYSCON_AHBMATPRIO_PRI_DMA_MASK           (0xC0U)
#define SYSCON_AHBMATPRIO_PRI_DMA_SHIFT          (6U)
/*! PRI_DMA - DMA controller priority.
 */
#define SYSCON_AHBMATPRIO_PRI_DMA(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBMATPRIO_PRI_DMA_SHIFT)) & SYSCON_AHBMATPRIO_PRI_DMA_MASK)
#define SYSCON_AHBMATPRIO_PRI_ETH_MASK           (0x300U)
#define SYSCON_AHBMATPRIO_PRI_ETH_SHIFT          (8U)
/*! PRI_ETH - Ethernet DMA priority.
 */
#define SYSCON_AHBMATPRIO_PRI_ETH(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBMATPRIO_PRI_ETH_SHIFT)) & SYSCON_AHBMATPRIO_PRI_ETH_MASK)
#define SYSCON_AHBMATPRIO_PRI_LCD_MASK           (0xC00U)
#define SYSCON_AHBMATPRIO_PRI_LCD_SHIFT          (10U)
/*! PRI_LCD - LCD DMA priority.
 */
#define SYSCON_AHBMATPRIO_PRI_LCD(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBMATPRIO_PRI_LCD_SHIFT)) & SYSCON_AHBMATPRIO_PRI_LCD_MASK)
#define SYSCON_AHBMATPRIO_PRI_USB0_MASK          (0x3000U)
#define SYSCON_AHBMATPRIO_PRI_USB0_SHIFT         (12U)
/*! PRI_USB0 - USB0 DMA priority.
 */
#define SYSCON_AHBMATPRIO_PRI_USB0(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBMATPRIO_PRI_USB0_SHIFT)) & SYSCON_AHBMATPRIO_PRI_USB0_MASK)
#define SYSCON_AHBMATPRIO_PRI_USB1_MASK          (0xC000U)
#define SYSCON_AHBMATPRIO_PRI_USB1_SHIFT         (14U)
/*! PRI_USB1 - USB1 DMA priority.
 */
#define SYSCON_AHBMATPRIO_PRI_USB1(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBMATPRIO_PRI_USB1_SHIFT)) & SYSCON_AHBMATPRIO_PRI_USB1_MASK)
#define SYSCON_AHBMATPRIO_PRI_SDIO_MASK          (0x30000U)
#define SYSCON_AHBMATPRIO_PRI_SDIO_SHIFT         (16U)
/*! PRI_SDIO - SDIO priority.
 */
#define SYSCON_AHBMATPRIO_PRI_SDIO(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBMATPRIO_PRI_SDIO_SHIFT)) & SYSCON_AHBMATPRIO_PRI_SDIO_MASK)
#define SYSCON_AHBMATPRIO_PRI_MCAN1_MASK         (0xC0000U)
#define SYSCON_AHBMATPRIO_PRI_MCAN1_SHIFT        (18U)
/*! PRI_MCAN1 - MCAN1 priority.
 */
#define SYSCON_AHBMATPRIO_PRI_MCAN1(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBMATPRIO_PRI_MCAN1_SHIFT)) & SYSCON_AHBMATPRIO_PRI_MCAN1_MASK)
#define SYSCON_AHBMATPRIO_PRI_MCAN2_MASK         (0x300000U)
#define SYSCON_AHBMATPRIO_PRI_MCAN2_SHIFT        (20U)
/*! PRI_MCAN2 - MCAN2 priority.
 */
#define SYSCON_AHBMATPRIO_PRI_MCAN2(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBMATPRIO_PRI_MCAN2_SHIFT)) & SYSCON_AHBMATPRIO_PRI_MCAN2_MASK)
/*! @} */

/*! @name SYSTCKCAL - System tick counter calibration */
/*! @{ */
#define SYSCON_SYSTCKCAL_CAL_MASK                (0xFFFFFFU)
#define SYSCON_SYSTCKCAL_CAL_SHIFT               (0U)
/*! CAL - System tick timer calibration value.
 */
#define SYSCON_SYSTCKCAL_CAL(x)                  (((uint32_t)(((uint32_t)(x)) << SYSCON_SYSTCKCAL_CAL_SHIFT)) & SYSCON_SYSTCKCAL_CAL_MASK)
#define SYSCON_SYSTCKCAL_SKEW_MASK               (0x1000000U)
#define SYSCON_SYSTCKCAL_SKEW_SHIFT              (24U)
/*! SKEW - Initial value for the Systick timer.
 */
#define SYSCON_SYSTCKCAL_SKEW(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_SYSTCKCAL_SKEW_SHIFT)) & SYSCON_SYSTCKCAL_SKEW_MASK)
#define SYSCON_SYSTCKCAL_NOREF_MASK              (0x2000000U)
#define SYSCON_SYSTCKCAL_NOREF_SHIFT             (25U)
/*! NOREF - Initial value for the Systick timer.
 */
#define SYSCON_SYSTCKCAL_NOREF(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_SYSTCKCAL_NOREF_SHIFT)) & SYSCON_SYSTCKCAL_NOREF_MASK)
/*! @} */

/*! @name NMISRC - NMI Source Select */
/*! @{ */
#define SYSCON_NMISRC_IRQM4_MASK                 (0x3FU)
#define SYSCON_NMISRC_IRQM4_SHIFT                (0U)
/*! IRQM4 - The IRQ number of the interrupt that acts as the Non-Maskable Interrupt (NMI) for the Cortex-M4, if enabled by NMIENM4.
 */
#define SYSCON_NMISRC_IRQM4(x)                   (((uint32_t)(((uint32_t)(x)) << SYSCON_NMISRC_IRQM4_SHIFT)) & SYSCON_NMISRC_IRQM4_MASK)
#define SYSCON_NMISRC_NMIENM4_MASK               (0x80000000U)
#define SYSCON_NMISRC_NMIENM4_SHIFT              (31U)
/*! NMIENM4 - Write a 1 to this bit to enable the Non-Maskable Interrupt (NMI) source selected by IRQM4.
 */
#define SYSCON_NMISRC_NMIENM4(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_NMISRC_NMIENM4_SHIFT)) & SYSCON_NMISRC_NMIENM4_MASK)
/*! @} */

/*! @name ASYNCAPBCTRL - Asynchronous APB Control */
/*! @{ */
#define SYSCON_ASYNCAPBCTRL_ENABLE_MASK          (0x1U)
#define SYSCON_ASYNCAPBCTRL_ENABLE_SHIFT         (0U)
/*! ENABLE - Enables the asynchronous APB bridge and subsystem.
 *  0b0..Disabled. Asynchronous APB bridge is disabled.
 *  0b1..Enabled. Asynchronous APB bridge is enabled.
 */
#define SYSCON_ASYNCAPBCTRL_ENABLE(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_ASYNCAPBCTRL_ENABLE_SHIFT)) & SYSCON_ASYNCAPBCTRL_ENABLE_MASK)
/*! @} */

/*! @name PIOPORCAP - POR captured value of port n */
/*! @{ */
#define SYSCON_PIOPORCAP_PIOPORCAP_MASK          (0xFFFFFFFFU)
#define SYSCON_PIOPORCAP_PIOPORCAP_SHIFT         (0U)
/*! PIOPORCAP - State of PIOn_31 through PIOn_0 at power-on reset
 */
#define SYSCON_PIOPORCAP_PIOPORCAP(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_PIOPORCAP_PIOPORCAP_SHIFT)) & SYSCON_PIOPORCAP_PIOPORCAP_MASK)
/*! @} */

/* The count of SYSCON_PIOPORCAP */
#define SYSCON_PIOPORCAP_COUNT                   (2U)

/*! @name PIORESCAP - Reset captured value of port n */
/*! @{ */
#define SYSCON_PIORESCAP_PIORESCAP_MASK          (0xFFFFFFFFU)
#define SYSCON_PIORESCAP_PIORESCAP_SHIFT         (0U)
/*! PIORESCAP - State of PIOn_31 through PIOn_0 for resets other than POR.
 */
#define SYSCON_PIORESCAP_PIORESCAP(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_PIORESCAP_PIORESCAP_SHIFT)) & SYSCON_PIORESCAP_PIORESCAP_MASK)
/*! @} */

/* The count of SYSCON_PIORESCAP */
#define SYSCON_PIORESCAP_COUNT                   (2U)

/*! @name PRESETCTRL - Peripheral reset control n */
/*! @{ */
#define SYSCON_PRESETCTRL_MRT_RST_MASK           (0x1U)
#define SYSCON_PRESETCTRL_MRT_RST_SHIFT          (0U)
/*! MRT_RST - Multi-rate timer (MRT) reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_MRT_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_MRT_RST_SHIFT)) & SYSCON_PRESETCTRL_MRT_RST_MASK)
#define SYSCON_PRESETCTRL_LCD_RST_MASK           (0x4U)
#define SYSCON_PRESETCTRL_LCD_RST_SHIFT          (2U)
/*! LCD_RST - LCD reset control.
 */
#define SYSCON_PRESETCTRL_LCD_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_LCD_RST_SHIFT)) & SYSCON_PRESETCTRL_LCD_RST_MASK)
#define SYSCON_PRESETCTRL_SCT0_RST_MASK          (0x4U)
#define SYSCON_PRESETCTRL_SCT0_RST_SHIFT         (2U)
/*! SCT0_RST - State configurable timer 0 (SCT0) reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_SCT0_RST(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_SCT0_RST_SHIFT)) & SYSCON_PRESETCTRL_SCT0_RST_MASK)
#define SYSCON_PRESETCTRL_SDIO_RST_MASK          (0x8U)
#define SYSCON_PRESETCTRL_SDIO_RST_SHIFT         (3U)
/*! SDIO_RST - SDIO reset control.
 */
#define SYSCON_PRESETCTRL_SDIO_RST(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_SDIO_RST_SHIFT)) & SYSCON_PRESETCTRL_SDIO_RST_MASK)
#define SYSCON_PRESETCTRL_USB1H_RST_MASK         (0x10U)
#define SYSCON_PRESETCTRL_USB1H_RST_SHIFT        (4U)
/*! USB1H_RST - USB1 Host reset control.
 */
#define SYSCON_PRESETCTRL_USB1H_RST(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_USB1H_RST_SHIFT)) & SYSCON_PRESETCTRL_USB1H_RST_MASK)
#define SYSCON_PRESETCTRL_USB1D_RST_MASK         (0x20U)
#define SYSCON_PRESETCTRL_USB1D_RST_SHIFT        (5U)
/*! USB1D_RST - USB1 Device reset control.
 */
#define SYSCON_PRESETCTRL_USB1D_RST(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_USB1D_RST_SHIFT)) & SYSCON_PRESETCTRL_USB1D_RST_MASK)
#define SYSCON_PRESETCTRL_USB1RAM_RST_MASK       (0x40U)
#define SYSCON_PRESETCTRL_USB1RAM_RST_SHIFT      (6U)
/*! USB1RAM_RST - USB1 RAM reset control.
 */
#define SYSCON_PRESETCTRL_USB1RAM_RST(x)         (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_USB1RAM_RST_SHIFT)) & SYSCON_PRESETCTRL_USB1RAM_RST_MASK)
#define SYSCON_PRESETCTRL_EMC_RESET_MASK         (0x80U)
#define SYSCON_PRESETCTRL_EMC_RESET_SHIFT        (7U)
/*! EMC_RESET - EMC reset control.
 */
#define SYSCON_PRESETCTRL_EMC_RESET(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_EMC_RESET_SHIFT)) & SYSCON_PRESETCTRL_EMC_RESET_MASK)
#define SYSCON_PRESETCTRL_MCAN0_RST_MASK         (0x80U)
#define SYSCON_PRESETCTRL_MCAN0_RST_SHIFT        (7U)
/*! MCAN0_RST - 0 = Clear reset to this function.
 */
#define SYSCON_PRESETCTRL_MCAN0_RST(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_MCAN0_RST_SHIFT)) & SYSCON_PRESETCTRL_MCAN0_RST_MASK)
#define SYSCON_PRESETCTRL_ETH_RST_MASK           (0x100U)
#define SYSCON_PRESETCTRL_ETH_RST_SHIFT          (8U)
/*! ETH_RST - Ethernet reset control.
 */
#define SYSCON_PRESETCTRL_ETH_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_ETH_RST_SHIFT)) & SYSCON_PRESETCTRL_ETH_RST_MASK)
#define SYSCON_PRESETCTRL_MCAN1_RST_MASK         (0x100U)
#define SYSCON_PRESETCTRL_MCAN1_RST_SHIFT        (8U)
/*! MCAN1_RST - 0 = Clear reset to this function.
 */
#define SYSCON_PRESETCTRL_MCAN1_RST(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_MCAN1_RST_SHIFT)) & SYSCON_PRESETCTRL_MCAN1_RST_MASK)
#define SYSCON_PRESETCTRL_GPIO4_RST_MASK         (0x200U)
#define SYSCON_PRESETCTRL_GPIO4_RST_SHIFT        (9U)
/*! GPIO4_RST - GPIO4 reset control.
 */
#define SYSCON_PRESETCTRL_GPIO4_RST(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_GPIO4_RST_SHIFT)) & SYSCON_PRESETCTRL_GPIO4_RST_MASK)
#define SYSCON_PRESETCTRL_GPIO5_RST_MASK         (0x400U)
#define SYSCON_PRESETCTRL_GPIO5_RST_SHIFT        (10U)
/*! GPIO5_RST - GPIO5 reset control.
 */
#define SYSCON_PRESETCTRL_GPIO5_RST(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_GPIO5_RST_SHIFT)) & SYSCON_PRESETCTRL_GPIO5_RST_MASK)
#define SYSCON_PRESETCTRL_SPIFI_RST_MASK         (0x400U)
#define SYSCON_PRESETCTRL_SPIFI_RST_SHIFT        (10U)
/*! SPIFI_RST - SPIFI reset control.
 */
#define SYSCON_PRESETCTRL_SPIFI_RST(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_SPIFI_RST_SHIFT)) & SYSCON_PRESETCTRL_SPIFI_RST_MASK)
#define SYSCON_PRESETCTRL_UTICK_RST_MASK         (0x400U)
#define SYSCON_PRESETCTRL_UTICK_RST_SHIFT        (10U)
/*! UTICK_RST - Micro-tick Timer reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_UTICK_RST(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_UTICK_RST_SHIFT)) & SYSCON_PRESETCTRL_UTICK_RST_MASK)
#define SYSCON_PRESETCTRL_FC0_RST_MASK           (0x800U)
#define SYSCON_PRESETCTRL_FC0_RST_SHIFT          (11U)
/*! FC0_RST - Flexcomm 0 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_FC0_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_FC0_RST_SHIFT)) & SYSCON_PRESETCTRL_FC0_RST_MASK)
#define SYSCON_PRESETCTRL_MUX_RST_MASK           (0x800U)
#define SYSCON_PRESETCTRL_MUX_RST_SHIFT          (11U)
/*! MUX_RST - Input mux reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_MUX_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_MUX_RST_SHIFT)) & SYSCON_PRESETCTRL_MUX_RST_MASK)
#define SYSCON_PRESETCTRL_FC1_RST_MASK           (0x1000U)
#define SYSCON_PRESETCTRL_FC1_RST_SHIFT          (12U)
/*! FC1_RST - Flexcomm 1 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_FC1_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_FC1_RST_SHIFT)) & SYSCON_PRESETCTRL_FC1_RST_MASK)
#define SYSCON_PRESETCTRL_OTP_RST_MASK           (0x1000U)
#define SYSCON_PRESETCTRL_OTP_RST_SHIFT          (12U)
/*! OTP_RST - OTP reset control.
 */
#define SYSCON_PRESETCTRL_OTP_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_OTP_RST_SHIFT)) & SYSCON_PRESETCTRL_OTP_RST_MASK)
#define SYSCON_PRESETCTRL_FC2_RST_MASK           (0x2000U)
#define SYSCON_PRESETCTRL_FC2_RST_SHIFT          (13U)
/*! FC2_RST - Flexcomm 2 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_FC2_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_FC2_RST_SHIFT)) & SYSCON_PRESETCTRL_FC2_RST_MASK)
#define SYSCON_PRESETCTRL_IOCON_RST_MASK         (0x2000U)
#define SYSCON_PRESETCTRL_IOCON_RST_SHIFT        (13U)
/*! IOCON_RST - IOCON reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_IOCON_RST(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_IOCON_RST_SHIFT)) & SYSCON_PRESETCTRL_IOCON_RST_MASK)
#define SYSCON_PRESETCTRL_RNG_RST_MASK           (0x2000U)
#define SYSCON_PRESETCTRL_RNG_RST_SHIFT          (13U)
/*! RNG_RST - RNG reset control.
 */
#define SYSCON_PRESETCTRL_RNG_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_RNG_RST_SHIFT)) & SYSCON_PRESETCTRL_RNG_RST_MASK)
#define SYSCON_PRESETCTRL_FC3_RST_MASK           (0x4000U)
#define SYSCON_PRESETCTRL_FC3_RST_SHIFT          (14U)
/*! FC3_RST - Flexcomm 3 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_FC3_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_FC3_RST_SHIFT)) & SYSCON_PRESETCTRL_FC3_RST_MASK)
#define SYSCON_PRESETCTRL_FC8_RST_MASK           (0x4000U)
#define SYSCON_PRESETCTRL_FC8_RST_SHIFT          (14U)
/*! FC8_RST - Flexcomm 8 reset control.
 */
#define SYSCON_PRESETCTRL_FC8_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_FC8_RST_SHIFT)) & SYSCON_PRESETCTRL_FC8_RST_MASK)
#define SYSCON_PRESETCTRL_GPIO0_RST_MASK         (0x4000U)
#define SYSCON_PRESETCTRL_GPIO0_RST_SHIFT        (14U)
/*! GPIO0_RST - GPIO0 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_GPIO0_RST(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_GPIO0_RST_SHIFT)) & SYSCON_PRESETCTRL_GPIO0_RST_MASK)
#define SYSCON_PRESETCTRL_FC4_RST_MASK           (0x8000U)
#define SYSCON_PRESETCTRL_FC4_RST_SHIFT          (15U)
/*! FC4_RST - Flexcomm 4 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_FC4_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_FC4_RST_SHIFT)) & SYSCON_PRESETCTRL_FC4_RST_MASK)
#define SYSCON_PRESETCTRL_FC9_RST_MASK           (0x8000U)
#define SYSCON_PRESETCTRL_FC9_RST_SHIFT          (15U)
/*! FC9_RST - Flexcomm 9 reset control.
 */
#define SYSCON_PRESETCTRL_FC9_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_FC9_RST_SHIFT)) & SYSCON_PRESETCTRL_FC9_RST_MASK)
#define SYSCON_PRESETCTRL_GPIO1_RST_MASK         (0x8000U)
#define SYSCON_PRESETCTRL_GPIO1_RST_SHIFT        (15U)
/*! GPIO1_RST - GPIO1 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_GPIO1_RST(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_GPIO1_RST_SHIFT)) & SYSCON_PRESETCTRL_GPIO1_RST_MASK)
#define SYSCON_PRESETCTRL_FC5_RST_MASK           (0x10000U)
#define SYSCON_PRESETCTRL_FC5_RST_SHIFT          (16U)
/*! FC5_RST - Flexcomm 5 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_FC5_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_FC5_RST_SHIFT)) & SYSCON_PRESETCTRL_FC5_RST_MASK)
#define SYSCON_PRESETCTRL_GPIO2_RST_MASK         (0x10000U)
#define SYSCON_PRESETCTRL_GPIO2_RST_SHIFT        (16U)
/*! GPIO2_RST - GPIO2 reset control.
 */
#define SYSCON_PRESETCTRL_GPIO2_RST(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_GPIO2_RST_SHIFT)) & SYSCON_PRESETCTRL_GPIO2_RST_MASK)
#define SYSCON_PRESETCTRL_USB0HMR_RST_MASK       (0x10000U)
#define SYSCON_PRESETCTRL_USB0HMR_RST_SHIFT      (16U)
/*! USB0HMR_RST - USB0 HOST master reset control.
 */
#define SYSCON_PRESETCTRL_USB0HMR_RST(x)         (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_USB0HMR_RST_SHIFT)) & SYSCON_PRESETCTRL_USB0HMR_RST_MASK)
#define SYSCON_PRESETCTRL_FC6_RST_MASK           (0x20000U)
#define SYSCON_PRESETCTRL_FC6_RST_SHIFT          (17U)
/*! FC6_RST - Flexcomm 6 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_FC6_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_FC6_RST_SHIFT)) & SYSCON_PRESETCTRL_FC6_RST_MASK)
#define SYSCON_PRESETCTRL_GPIO3_RST_MASK         (0x20000U)
#define SYSCON_PRESETCTRL_GPIO3_RST_SHIFT        (17U)
/*! GPIO3_RST - GPIO3 reset control.
 */
#define SYSCON_PRESETCTRL_GPIO3_RST(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_GPIO3_RST_SHIFT)) & SYSCON_PRESETCTRL_GPIO3_RST_MASK)
#define SYSCON_PRESETCTRL_USB0HSL_RST_MASK       (0x20000U)
#define SYSCON_PRESETCTRL_USB0HSL_RST_SHIFT      (17U)
/*! USB0HSL_RST - USB0 HOST slave reset control.
 */
#define SYSCON_PRESETCTRL_USB0HSL_RST(x)         (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_USB0HSL_RST_SHIFT)) & SYSCON_PRESETCTRL_USB0HSL_RST_MASK)
#define SYSCON_PRESETCTRL_FC7_RST_MASK           (0x40000U)
#define SYSCON_PRESETCTRL_FC7_RST_SHIFT          (18U)
/*! FC7_RST - Flexcomm 7 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_FC7_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_FC7_RST_SHIFT)) & SYSCON_PRESETCTRL_FC7_RST_MASK)
#define SYSCON_PRESETCTRL_PINT_RST_MASK          (0x40000U)
#define SYSCON_PRESETCTRL_PINT_RST_SHIFT         (18U)
/*! PINT_RST - Pin interrupt (PINT) reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_PINT_RST(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_PINT_RST_SHIFT)) & SYSCON_PRESETCTRL_PINT_RST_MASK)
#define SYSCON_PRESETCTRL_SHA_RST_MASK           (0x40000U)
#define SYSCON_PRESETCTRL_SHA_RST_SHIFT          (18U)
/*! SHA_RST - SHA reset control.
 */
#define SYSCON_PRESETCTRL_SHA_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_SHA_RST_SHIFT)) & SYSCON_PRESETCTRL_SHA_RST_MASK)
#define SYSCON_PRESETCTRL_DMIC_RST_MASK          (0x80000U)
#define SYSCON_PRESETCTRL_DMIC_RST_SHIFT         (19U)
/*! DMIC_RST - Digital microphone interface reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_DMIC_RST(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_DMIC_RST_SHIFT)) & SYSCON_PRESETCTRL_DMIC_RST_MASK)
#define SYSCON_PRESETCTRL_GINT_RST_MASK          (0x80000U)
#define SYSCON_PRESETCTRL_GINT_RST_SHIFT         (19U)
/*! GINT_RST - Grouped interrupt (GINT) reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_GINT_RST(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_GINT_RST_SHIFT)) & SYSCON_PRESETCTRL_GINT_RST_MASK)
#define SYSCON_PRESETCTRL_SC0_RST_MASK           (0x80000U)
#define SYSCON_PRESETCTRL_SC0_RST_SHIFT          (19U)
/*! SC0_RST - Smart card 0 reset control.
 */
#define SYSCON_PRESETCTRL_SC0_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_SC0_RST_SHIFT)) & SYSCON_PRESETCTRL_SC0_RST_MASK)
#define SYSCON_PRESETCTRL_DMA_RST_MASK           (0x100000U)
#define SYSCON_PRESETCTRL_DMA_RST_SHIFT          (20U)
/*! DMA_RST - DMA reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_DMA_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_DMA_RST_SHIFT)) & SYSCON_PRESETCTRL_DMA_RST_MASK)
#define SYSCON_PRESETCTRL_SC1_RST_MASK           (0x100000U)
#define SYSCON_PRESETCTRL_SC1_RST_SHIFT          (20U)
/*! SC1_RST - Smart card 1 reset control.
 */
#define SYSCON_PRESETCTRL_SC1_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_SC1_RST_SHIFT)) & SYSCON_PRESETCTRL_SC1_RST_MASK)
#define SYSCON_PRESETCTRL_CRC_RST_MASK           (0x200000U)
#define SYSCON_PRESETCTRL_CRC_RST_SHIFT          (21U)
/*! CRC_RST - CRC generator reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_CRC_RST(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_CRC_RST_SHIFT)) & SYSCON_PRESETCTRL_CRC_RST_MASK)
#define SYSCON_PRESETCTRL_FC10_RST_MASK          (0x200000U)
#define SYSCON_PRESETCTRL_FC10_RST_SHIFT         (21U)
/*! FC10_RST - Flexcomm 10 reset control.
 */
#define SYSCON_PRESETCTRL_FC10_RST(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_FC10_RST_SHIFT)) & SYSCON_PRESETCTRL_FC10_RST_MASK)
#define SYSCON_PRESETCTRL_CTIMER2_RST_MASK       (0x400000U)
#define SYSCON_PRESETCTRL_CTIMER2_RST_SHIFT      (22U)
/*! CTIMER2_RST - CTIMER2 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function
 */
#define SYSCON_PRESETCTRL_CTIMER2_RST(x)         (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_CTIMER2_RST_SHIFT)) & SYSCON_PRESETCTRL_CTIMER2_RST_MASK)
#define SYSCON_PRESETCTRL_WWDT_RST_MASK          (0x400000U)
#define SYSCON_PRESETCTRL_WWDT_RST_SHIFT         (22U)
/*! WWDT_RST - Watchdog timer reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_WWDT_RST(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_WWDT_RST_SHIFT)) & SYSCON_PRESETCTRL_WWDT_RST_MASK)
#define SYSCON_PRESETCTRL_USB0D_RST_MASK         (0x2000000U)
#define SYSCON_PRESETCTRL_USB0D_RST_SHIFT        (25U)
/*! USB0D_RST - USB0 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_USB0D_RST(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_USB0D_RST_SHIFT)) & SYSCON_PRESETCTRL_USB0D_RST_MASK)
#define SYSCON_PRESETCTRL_CTIMER0_RST_MASK       (0x4000000U)
#define SYSCON_PRESETCTRL_CTIMER0_RST_SHIFT      (26U)
/*! CTIMER0_RST - CTIMER0 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_CTIMER0_RST(x)         (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_CTIMER0_RST_SHIFT)) & SYSCON_PRESETCTRL_CTIMER0_RST_MASK)
#define SYSCON_PRESETCTRL_ADC0_RST_MASK          (0x8000000U)
#define SYSCON_PRESETCTRL_ADC0_RST_SHIFT         (27U)
/*! ADC0_RST - ADC0 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_ADC0_RST(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_ADC0_RST_SHIFT)) & SYSCON_PRESETCTRL_ADC0_RST_MASK)
#define SYSCON_PRESETCTRL_CTIMER1_RST_MASK       (0x8000000U)
#define SYSCON_PRESETCTRL_CTIMER1_RST_SHIFT      (27U)
/*! CTIMER1_RST - CTIMER1 reset control. 0 = Clear reset to this function. 1 = Assert reset to this function.
 */
#define SYSCON_PRESETCTRL_CTIMER1_RST(x)         (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRL_CTIMER1_RST_SHIFT)) & SYSCON_PRESETCTRL_CTIMER1_RST_MASK)
/*! @} */

/* The count of SYSCON_PRESETCTRL */
#define SYSCON_PRESETCTRL_COUNT                  (3U)

/*! @name PRESETCTRLSET - Set bits in PRESETCTRLn */
/*! @{ */
#define SYSCON_PRESETCTRLSET_RST_SET_MASK        (0xFFFFFFFFU)
#define SYSCON_PRESETCTRLSET_RST_SET_SHIFT       (0U)
/*! RST_SET - Writing ones to this register sets the corresponding bit or bits in the PRESETCTRLn
 *    register, if they are implemented. Bits that do not correspond to defined bits in PRESETCTRLn
 *    are reserved and only zeroes should be written to them.
 */
#define SYSCON_PRESETCTRLSET_RST_SET(x)          (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRLSET_RST_SET_SHIFT)) & SYSCON_PRESETCTRLSET_RST_SET_MASK)
/*! @} */

/* The count of SYSCON_PRESETCTRLSET */
#define SYSCON_PRESETCTRLSET_COUNT               (3U)

/*! @name PRESETCTRLCLR - Clear bits in PRESETCTRLn */
/*! @{ */
#define SYSCON_PRESETCTRLCLR_RST_CLR_MASK        (0xFFFFFFFFU)
#define SYSCON_PRESETCTRLCLR_RST_CLR_SHIFT       (0U)
/*! RST_CLR - Writing ones to this register clears the corresponding bit or bits in the PRESETCTRLn
 *    register, if they are implemented. Bits that do not correspond to defined bits in PRESETCTRLn
 *    are reserved and only zeroes should be written to them.
 */
#define SYSCON_PRESETCTRLCLR_RST_CLR(x)          (((uint32_t)(((uint32_t)(x)) << SYSCON_PRESETCTRLCLR_RST_CLR_SHIFT)) & SYSCON_PRESETCTRLCLR_RST_CLR_MASK)
/*! @} */

/* The count of SYSCON_PRESETCTRLCLR */
#define SYSCON_PRESETCTRLCLR_COUNT               (3U)

/*! @name SYSRSTSTAT - System reset status register */
/*! @{ */
#define SYSCON_SYSRSTSTAT_POR_MASK               (0x1U)
#define SYSCON_SYSRSTSTAT_POR_SHIFT              (0U)
/*! POR - POR reset status
 *  0b0..No POR detected
 *  0b1..POR detected. Writing a one clears this reset.
 */
#define SYSCON_SYSRSTSTAT_POR(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_SYSRSTSTAT_POR_SHIFT)) & SYSCON_SYSRSTSTAT_POR_MASK)
#define SYSCON_SYSRSTSTAT_EXTRST_MASK            (0x2U)
#define SYSCON_SYSRSTSTAT_EXTRST_SHIFT           (1U)
/*! EXTRST - Status of the external RESET pin. External reset status
 *  0b0..No reset event detected.
 *  0b1..Reset detected. Writing a one clears this reset.
 */
#define SYSCON_SYSRSTSTAT_EXTRST(x)              (((uint32_t)(((uint32_t)(x)) << SYSCON_SYSRSTSTAT_EXTRST_SHIFT)) & SYSCON_SYSRSTSTAT_EXTRST_MASK)
#define SYSCON_SYSRSTSTAT_WDT_MASK               (0x4U)
#define SYSCON_SYSRSTSTAT_WDT_SHIFT              (2U)
/*! WDT - Status of the Watchdog reset
 *  0b0..No WDT reset detected
 *  0b1..WDT reset detected. Writing a one clears this reset.
 */
#define SYSCON_SYSRSTSTAT_WDT(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_SYSRSTSTAT_WDT_SHIFT)) & SYSCON_SYSRSTSTAT_WDT_MASK)
#define SYSCON_SYSRSTSTAT_BOD_MASK               (0x8U)
#define SYSCON_SYSRSTSTAT_BOD_SHIFT              (3U)
/*! BOD - Status of the Brown-out detect reset
 *  0b0..No BOD reset detected
 *  0b1..BOD reset detected. Writing a one clears this reset.
 */
#define SYSCON_SYSRSTSTAT_BOD(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_SYSRSTSTAT_BOD_SHIFT)) & SYSCON_SYSRSTSTAT_BOD_MASK)
#define SYSCON_SYSRSTSTAT_SYSRST_MASK            (0x10U)
#define SYSCON_SYSRSTSTAT_SYSRST_SHIFT           (4U)
/*! SYSRST - Status of the software system reset
 *  0b0..No System reset detected
 *  0b1..System reset detected. Writing a one clears this reset.
 */
#define SYSCON_SYSRSTSTAT_SYSRST(x)              (((uint32_t)(((uint32_t)(x)) << SYSCON_SYSRSTSTAT_SYSRST_SHIFT)) & SYSCON_SYSRSTSTAT_SYSRST_MASK)
/*! @} */

/*! @name AHBCLKCTRL - AHB Clock control n */
/*! @{ */
#define SYSCON_AHBCLKCTRL_MRT_MASK               (0x1U)
#define SYSCON_AHBCLKCTRL_MRT_SHIFT              (0U)
/*! MRT - Enables the clock for the Multi-Rate Timer.
 */
#define SYSCON_AHBCLKCTRL_MRT(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_MRT_SHIFT)) & SYSCON_AHBCLKCTRL_MRT_MASK)
#define SYSCON_AHBCLKCTRL_RIT_MASK               (0x2U)
#define SYSCON_AHBCLKCTRL_RIT_SHIFT              (1U)
/*! RIT - Enables the clock for the Repetitive Interrupt Timer.
 */
#define SYSCON_AHBCLKCTRL_RIT(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_RIT_SHIFT)) & SYSCON_AHBCLKCTRL_RIT_MASK)
#define SYSCON_AHBCLKCTRL_ROM_MASK               (0x2U)
#define SYSCON_AHBCLKCTRL_ROM_SHIFT              (1U)
/*! ROM - Enables the clock for the Boot ROM. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_ROM(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_ROM_SHIFT)) & SYSCON_AHBCLKCTRL_ROM_MASK)
#define SYSCON_AHBCLKCTRL_LCD_MASK               (0x4U)
#define SYSCON_AHBCLKCTRL_LCD_SHIFT              (2U)
/*! LCD - Enables the clock for the LCD interface.
 */
#define SYSCON_AHBCLKCTRL_LCD(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_LCD_SHIFT)) & SYSCON_AHBCLKCTRL_LCD_MASK)
#define SYSCON_AHBCLKCTRL_SCT0_MASK              (0x4U)
#define SYSCON_AHBCLKCTRL_SCT0_SHIFT             (2U)
/*! SCT0 - Enables the clock for SCT0.
 */
#define SYSCON_AHBCLKCTRL_SCT0(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_SCT0_SHIFT)) & SYSCON_AHBCLKCTRL_SCT0_MASK)
#define SYSCON_AHBCLKCTRL_SDIO_MASK              (0x8U)
#define SYSCON_AHBCLKCTRL_SDIO_SHIFT             (3U)
/*! SDIO - Enables the clock for the SDIO interface.
 */
#define SYSCON_AHBCLKCTRL_SDIO(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_SDIO_SHIFT)) & SYSCON_AHBCLKCTRL_SDIO_MASK)
#define SYSCON_AHBCLKCTRL_SRAM1_MASK             (0x8U)
#define SYSCON_AHBCLKCTRL_SRAM1_SHIFT            (3U)
/*! SRAM1 - Enables the clock for SRAM1. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_SRAM1(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_SRAM1_SHIFT)) & SYSCON_AHBCLKCTRL_SRAM1_MASK)
#define SYSCON_AHBCLKCTRL_SRAM2_MASK             (0x10U)
#define SYSCON_AHBCLKCTRL_SRAM2_SHIFT            (4U)
/*! SRAM2 - Enables the clock for SRAM2. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_SRAM2(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_SRAM2_SHIFT)) & SYSCON_AHBCLKCTRL_SRAM2_MASK)
#define SYSCON_AHBCLKCTRL_USB1H_MASK             (0x10U)
#define SYSCON_AHBCLKCTRL_USB1H_SHIFT            (4U)
/*! USB1H - Enables the clock for the USB1 host interface.
 */
#define SYSCON_AHBCLKCTRL_USB1H(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_USB1H_SHIFT)) & SYSCON_AHBCLKCTRL_USB1H_MASK)
#define SYSCON_AHBCLKCTRL_SRAM3_MASK             (0x20U)
#define SYSCON_AHBCLKCTRL_SRAM3_SHIFT            (5U)
/*! SRAM3 - Enables the clock for SRAM3.
 */
#define SYSCON_AHBCLKCTRL_SRAM3(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_SRAM3_SHIFT)) & SYSCON_AHBCLKCTRL_SRAM3_MASK)
#define SYSCON_AHBCLKCTRL_USB1D_MASK             (0x20U)
#define SYSCON_AHBCLKCTRL_USB1D_SHIFT            (5U)
/*! USB1D - Enables the clock for the USB1 device interface.
 */
#define SYSCON_AHBCLKCTRL_USB1D(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_USB1D_SHIFT)) & SYSCON_AHBCLKCTRL_USB1D_MASK)
#define SYSCON_AHBCLKCTRL_USB1RAM_MASK           (0x40U)
#define SYSCON_AHBCLKCTRL_USB1RAM_SHIFT          (6U)
/*! USB1RAM - Enables the clock for the USB1 RAM interface.
 */
#define SYSCON_AHBCLKCTRL_USB1RAM(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_USB1RAM_SHIFT)) & SYSCON_AHBCLKCTRL_USB1RAM_MASK)
#define SYSCON_AHBCLKCTRL_EMC_MASK               (0x80U)
#define SYSCON_AHBCLKCTRL_EMC_SHIFT              (7U)
/*! EMC - Enables the clock for the EMC interface.
 */
#define SYSCON_AHBCLKCTRL_EMC(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_EMC_SHIFT)) & SYSCON_AHBCLKCTRL_EMC_MASK)
#define SYSCON_AHBCLKCTRL_MCAN0_MASK             (0x80U)
#define SYSCON_AHBCLKCTRL_MCAN0_SHIFT            (7U)
/*! MCAN0 - Enables the clock for MCAN0.
 */
#define SYSCON_AHBCLKCTRL_MCAN0(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_MCAN0_SHIFT)) & SYSCON_AHBCLKCTRL_MCAN0_MASK)
#define SYSCON_AHBCLKCTRL_ETH_MASK               (0x100U)
#define SYSCON_AHBCLKCTRL_ETH_SHIFT              (8U)
/*! ETH - Enables the clock for the ethernet interface.
 */
#define SYSCON_AHBCLKCTRL_ETH(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_ETH_SHIFT)) & SYSCON_AHBCLKCTRL_ETH_MASK)
#define SYSCON_AHBCLKCTRL_MCAN1_MASK             (0x100U)
#define SYSCON_AHBCLKCTRL_MCAN1_SHIFT            (8U)
/*! MCAN1 - Enables the clock for MCAN1.
 */
#define SYSCON_AHBCLKCTRL_MCAN1(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_MCAN1_SHIFT)) & SYSCON_AHBCLKCTRL_MCAN1_MASK)
#define SYSCON_AHBCLKCTRL_GPIO4_MASK             (0x200U)
#define SYSCON_AHBCLKCTRL_GPIO4_SHIFT            (9U)
/*! GPIO4 - Enables the clock for the GPIO4 interface.
 */
#define SYSCON_AHBCLKCTRL_GPIO4(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_GPIO4_SHIFT)) & SYSCON_AHBCLKCTRL_GPIO4_MASK)
#define SYSCON_AHBCLKCTRL_GPIO5_MASK             (0x400U)
#define SYSCON_AHBCLKCTRL_GPIO5_SHIFT            (10U)
/*! GPIO5 - Enables the clock for the GPIO5 interface.
 */
#define SYSCON_AHBCLKCTRL_GPIO5(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_GPIO5_SHIFT)) & SYSCON_AHBCLKCTRL_GPIO5_MASK)
#define SYSCON_AHBCLKCTRL_SPIFI_MASK             (0x400U)
#define SYSCON_AHBCLKCTRL_SPIFI_SHIFT            (10U)
/*! SPIFI - Enables the clock for the SPIFI. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_SPIFI(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_SPIFI_SHIFT)) & SYSCON_AHBCLKCTRL_SPIFI_MASK)
#define SYSCON_AHBCLKCTRL_UTICK_MASK             (0x400U)
#define SYSCON_AHBCLKCTRL_UTICK_SHIFT            (10U)
/*! UTICK - Enables the clock for the Micro-tick Timer. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_UTICK(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_UTICK_SHIFT)) & SYSCON_AHBCLKCTRL_UTICK_MASK)
#define SYSCON_AHBCLKCTRL_FLEXCOMM0_MASK         (0x800U)
#define SYSCON_AHBCLKCTRL_FLEXCOMM0_SHIFT        (11U)
/*! FLEXCOMM0 - Enables the clock for Flexcomm 0. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_FLEXCOMM0(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_FLEXCOMM0_SHIFT)) & SYSCON_AHBCLKCTRL_FLEXCOMM0_MASK)
#define SYSCON_AHBCLKCTRL_INPUTMUX_MASK          (0x800U)
#define SYSCON_AHBCLKCTRL_INPUTMUX_SHIFT         (11U)
/*! INPUTMUX - Enables the clock for the input muxes. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_INPUTMUX(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_INPUTMUX_SHIFT)) & SYSCON_AHBCLKCTRL_INPUTMUX_MASK)
#define SYSCON_AHBCLKCTRL_FLEXCOMM1_MASK         (0x1000U)
#define SYSCON_AHBCLKCTRL_FLEXCOMM1_SHIFT        (12U)
/*! FLEXCOMM1 - Enables the clock for Flexcomm 1. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_FLEXCOMM1(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_FLEXCOMM1_SHIFT)) & SYSCON_AHBCLKCTRL_FLEXCOMM1_MASK)
#define SYSCON_AHBCLKCTRL_OTP_MASK               (0x1000U)
#define SYSCON_AHBCLKCTRL_OTP_SHIFT              (12U)
/*! OTP - Enables the clock for the OTP interface.
 */
#define SYSCON_AHBCLKCTRL_OTP(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_OTP_SHIFT)) & SYSCON_AHBCLKCTRL_OTP_MASK)
#define SYSCON_AHBCLKCTRL_FLEXCOMM2_MASK         (0x2000U)
#define SYSCON_AHBCLKCTRL_FLEXCOMM2_SHIFT        (13U)
/*! FLEXCOMM2 - Enables the clock for Flexcomm 2. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_FLEXCOMM2(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_FLEXCOMM2_SHIFT)) & SYSCON_AHBCLKCTRL_FLEXCOMM2_MASK)
#define SYSCON_AHBCLKCTRL_IOCON_MASK             (0x2000U)
#define SYSCON_AHBCLKCTRL_IOCON_SHIFT            (13U)
/*! IOCON - Enables the clock for the IOCON block. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_IOCON(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_IOCON_SHIFT)) & SYSCON_AHBCLKCTRL_IOCON_MASK)
#define SYSCON_AHBCLKCTRL_RNG_MASK               (0x2000U)
#define SYSCON_AHBCLKCTRL_RNG_SHIFT              (13U)
/*! RNG - Enables the clock for the RNG interface.
 */
#define SYSCON_AHBCLKCTRL_RNG(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_RNG_SHIFT)) & SYSCON_AHBCLKCTRL_RNG_MASK)
#define SYSCON_AHBCLKCTRL_FLEXCOMM3_MASK         (0x4000U)
#define SYSCON_AHBCLKCTRL_FLEXCOMM3_SHIFT        (14U)
/*! FLEXCOMM3 - Enables the clock for Flexcomm 3. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_FLEXCOMM3(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_FLEXCOMM3_SHIFT)) & SYSCON_AHBCLKCTRL_FLEXCOMM3_MASK)
#define SYSCON_AHBCLKCTRL_FLEXCOMM8_MASK         (0x4000U)
#define SYSCON_AHBCLKCTRL_FLEXCOMM8_SHIFT        (14U)
/*! FLEXCOMM8 - Enables the clock for the Flexcomm8 interface.
 */
#define SYSCON_AHBCLKCTRL_FLEXCOMM8(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_FLEXCOMM8_SHIFT)) & SYSCON_AHBCLKCTRL_FLEXCOMM8_MASK)
#define SYSCON_AHBCLKCTRL_GPIO0_MASK             (0x4000U)
#define SYSCON_AHBCLKCTRL_GPIO0_SHIFT            (14U)
/*! GPIO0 - Enables the clock for the GPIO0 port registers. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_GPIO0(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_GPIO0_SHIFT)) & SYSCON_AHBCLKCTRL_GPIO0_MASK)
#define SYSCON_AHBCLKCTRL_FLEXCOMM4_MASK         (0x8000U)
#define SYSCON_AHBCLKCTRL_FLEXCOMM4_SHIFT        (15U)
/*! FLEXCOMM4 - Enables the clock for Flexcomm 4. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_FLEXCOMM4(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_FLEXCOMM4_SHIFT)) & SYSCON_AHBCLKCTRL_FLEXCOMM4_MASK)
#define SYSCON_AHBCLKCTRL_FLEXCOMM9_MASK         (0x8000U)
#define SYSCON_AHBCLKCTRL_FLEXCOMM9_SHIFT        (15U)
/*! FLEXCOMM9 - Enables the clock for the Flexcomm9 interface.
 */
#define SYSCON_AHBCLKCTRL_FLEXCOMM9(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_FLEXCOMM9_SHIFT)) & SYSCON_AHBCLKCTRL_FLEXCOMM9_MASK)
#define SYSCON_AHBCLKCTRL_GPIO1_MASK             (0x8000U)
#define SYSCON_AHBCLKCTRL_GPIO1_SHIFT            (15U)
/*! GPIO1 - Enables the clock for the GPIO1 port registers. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_GPIO1(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_GPIO1_SHIFT)) & SYSCON_AHBCLKCTRL_GPIO1_MASK)
#define SYSCON_AHBCLKCTRL_FLEXCOMM5_MASK         (0x10000U)
#define SYSCON_AHBCLKCTRL_FLEXCOMM5_SHIFT        (16U)
/*! FLEXCOMM5 - Enables the clock for Flexcomm 5. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_FLEXCOMM5(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_FLEXCOMM5_SHIFT)) & SYSCON_AHBCLKCTRL_FLEXCOMM5_MASK)
#define SYSCON_AHBCLKCTRL_GPIO2_MASK             (0x10000U)
#define SYSCON_AHBCLKCTRL_GPIO2_SHIFT            (16U)
/*! GPIO2 - Enables the clock for the GPIO2 port registers.
 */
#define SYSCON_AHBCLKCTRL_GPIO2(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_GPIO2_SHIFT)) & SYSCON_AHBCLKCTRL_GPIO2_MASK)
#define SYSCON_AHBCLKCTRL_USB0HMR_MASK           (0x10000U)
#define SYSCON_AHBCLKCTRL_USB0HMR_SHIFT          (16U)
/*! USB0HMR - Enables the clock for the USB host master interface.
 */
#define SYSCON_AHBCLKCTRL_USB0HMR(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_USB0HMR_SHIFT)) & SYSCON_AHBCLKCTRL_USB0HMR_MASK)
#define SYSCON_AHBCLKCTRL_FLEXCOMM6_MASK         (0x20000U)
#define SYSCON_AHBCLKCTRL_FLEXCOMM6_SHIFT        (17U)
/*! FLEXCOMM6 - Enables the clock for Flexcomm 6. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_FLEXCOMM6(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_FLEXCOMM6_SHIFT)) & SYSCON_AHBCLKCTRL_FLEXCOMM6_MASK)
#define SYSCON_AHBCLKCTRL_GPIO3_MASK             (0x20000U)
#define SYSCON_AHBCLKCTRL_GPIO3_SHIFT            (17U)
/*! GPIO3 - Enables the clock for the GPIO3 port registers.
 */
#define SYSCON_AHBCLKCTRL_GPIO3(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_GPIO3_SHIFT)) & SYSCON_AHBCLKCTRL_GPIO3_MASK)
#define SYSCON_AHBCLKCTRL_USB0HSL_MASK           (0x20000U)
#define SYSCON_AHBCLKCTRL_USB0HSL_SHIFT          (17U)
/*! USB0HSL - Enables the clock for the USB host slave interface.
 */
#define SYSCON_AHBCLKCTRL_USB0HSL(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_USB0HSL_SHIFT)) & SYSCON_AHBCLKCTRL_USB0HSL_MASK)
#define SYSCON_AHBCLKCTRL_FLEXCOMM7_MASK         (0x40000U)
#define SYSCON_AHBCLKCTRL_FLEXCOMM7_SHIFT        (18U)
/*! FLEXCOMM7 - Enables the clock for Flexcomm 7. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_FLEXCOMM7(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_FLEXCOMM7_SHIFT)) & SYSCON_AHBCLKCTRL_FLEXCOMM7_MASK)
#define SYSCON_AHBCLKCTRL_PINT_MASK              (0x40000U)
#define SYSCON_AHBCLKCTRL_PINT_SHIFT             (18U)
/*! PINT - Enables the clock for the pin interrupt block.0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_PINT(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_PINT_SHIFT)) & SYSCON_AHBCLKCTRL_PINT_MASK)
#define SYSCON_AHBCLKCTRL_SHA_MASK               (0x40000U)
#define SYSCON_AHBCLKCTRL_SHA_SHIFT              (18U)
/*! SHA - Enables the clock for the SHA interface.
 */
#define SYSCON_AHBCLKCTRL_SHA(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_SHA_SHIFT)) & SYSCON_AHBCLKCTRL_SHA_MASK)
#define SYSCON_AHBCLKCTRL_DMIC_MASK              (0x80000U)
#define SYSCON_AHBCLKCTRL_DMIC_SHIFT             (19U)
/*! DMIC - Enables the clock for the digital microphone interface. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_DMIC(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_DMIC_SHIFT)) & SYSCON_AHBCLKCTRL_DMIC_MASK)
#define SYSCON_AHBCLKCTRL_GINT_MASK              (0x80000U)
#define SYSCON_AHBCLKCTRL_GINT_SHIFT             (19U)
/*! GINT - Enables the clock for the grouped pin interrupt block. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_GINT(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_GINT_SHIFT)) & SYSCON_AHBCLKCTRL_GINT_MASK)
#define SYSCON_AHBCLKCTRL_SC0_MASK               (0x80000U)
#define SYSCON_AHBCLKCTRL_SC0_SHIFT              (19U)
/*! SC0 - Enables the clock for the Smart card0 interface.
 */
#define SYSCON_AHBCLKCTRL_SC0(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_SC0_SHIFT)) & SYSCON_AHBCLKCTRL_SC0_MASK)
#define SYSCON_AHBCLKCTRL_DMA_MASK               (0x100000U)
#define SYSCON_AHBCLKCTRL_DMA_SHIFT              (20U)
/*! DMA - Enables the clock for the DMA controller. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_DMA(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_DMA_SHIFT)) & SYSCON_AHBCLKCTRL_DMA_MASK)
#define SYSCON_AHBCLKCTRL_SC1_MASK               (0x100000U)
#define SYSCON_AHBCLKCTRL_SC1_SHIFT              (20U)
/*! SC1 - Enables the clock for the Smart card1 interface.
 */
#define SYSCON_AHBCLKCTRL_SC1(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_SC1_SHIFT)) & SYSCON_AHBCLKCTRL_SC1_MASK)
#define SYSCON_AHBCLKCTRL_CRC_MASK               (0x200000U)
#define SYSCON_AHBCLKCTRL_CRC_SHIFT              (21U)
/*! CRC - Enables the clock for the CRC engine. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_CRC(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_CRC_SHIFT)) & SYSCON_AHBCLKCTRL_CRC_MASK)
#define SYSCON_AHBCLKCTRL_FLEXCOMM10_MASK        (0x200000U)
#define SYSCON_AHBCLKCTRL_FLEXCOMM10_SHIFT       (21U)
/*! FLEXCOMM10 - Enables the clock for the Flexcomm10 interface.
 */
#define SYSCON_AHBCLKCTRL_FLEXCOMM10(x)          (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_FLEXCOMM10_SHIFT)) & SYSCON_AHBCLKCTRL_FLEXCOMM10_MASK)
#define SYSCON_AHBCLKCTRL_CTIMER2_MASK           (0x400000U)
#define SYSCON_AHBCLKCTRL_CTIMER2_SHIFT          (22U)
/*! CTIMER2 - Enables the clock for CTIMER 2. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_CTIMER2(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_CTIMER2_SHIFT)) & SYSCON_AHBCLKCTRL_CTIMER2_MASK)
#define SYSCON_AHBCLKCTRL_WWDT_MASK              (0x400000U)
#define SYSCON_AHBCLKCTRL_WWDT_SHIFT             (22U)
/*! WWDT - Enables the clock for the Watchdog Timer. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_WWDT(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_WWDT_SHIFT)) & SYSCON_AHBCLKCTRL_WWDT_MASK)
#define SYSCON_AHBCLKCTRL_RTC_MASK               (0x800000U)
#define SYSCON_AHBCLKCTRL_RTC_SHIFT              (23U)
/*! RTC - Enables the bus clock for the RTC. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_RTC(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_RTC_SHIFT)) & SYSCON_AHBCLKCTRL_RTC_MASK)
#define SYSCON_AHBCLKCTRL_USB0D_MASK             (0x2000000U)
#define SYSCON_AHBCLKCTRL_USB0D_SHIFT            (25U)
/*! USB0D - Enables the clock for the USB0 device interface. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_USB0D(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_USB0D_SHIFT)) & SYSCON_AHBCLKCTRL_USB0D_MASK)
#define SYSCON_AHBCLKCTRL_CTIMER0_MASK           (0x4000000U)
#define SYSCON_AHBCLKCTRL_CTIMER0_SHIFT          (26U)
/*! CTIMER0 - Enables the clock for timer CTIMER0. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_CTIMER0(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_CTIMER0_SHIFT)) & SYSCON_AHBCLKCTRL_CTIMER0_MASK)
#define SYSCON_AHBCLKCTRL_ADC0_MASK              (0x8000000U)
#define SYSCON_AHBCLKCTRL_ADC0_SHIFT             (27U)
/*! ADC0 - Enables the clock for the ADC0 register interface.
 */
#define SYSCON_AHBCLKCTRL_ADC0(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_ADC0_SHIFT)) & SYSCON_AHBCLKCTRL_ADC0_MASK)
#define SYSCON_AHBCLKCTRL_CTIMER1_MASK           (0x8000000U)
#define SYSCON_AHBCLKCTRL_CTIMER1_SHIFT          (27U)
/*! CTIMER1 - Enables the clock for timer CTIMER1. 0 = Disable; 1 = Enable.
 */
#define SYSCON_AHBCLKCTRL_CTIMER1(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRL_CTIMER1_SHIFT)) & SYSCON_AHBCLKCTRL_CTIMER1_MASK)
/*! @} */

/* The count of SYSCON_AHBCLKCTRL */
#define SYSCON_AHBCLKCTRL_COUNT                  (3U)

/*! @name AHBCLKCTRLSET - Set bits in AHBCLKCTRLn */
/*! @{ */
#define SYSCON_AHBCLKCTRLSET_CLK_SET_MASK        (0xFFFFFFFFU)
#define SYSCON_AHBCLKCTRLSET_CLK_SET_SHIFT       (0U)
/*! CLK_SET - Writing ones to this register sets the corresponding bit or bits in the AHBCLKCTRLn
 *    register, if they are implemented. Bits that do not correspond to defined bits in AHBCLKCTRLn
 *    are reserved and only zeroes should be written to them.
 */
#define SYSCON_AHBCLKCTRLSET_CLK_SET(x)          (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRLSET_CLK_SET_SHIFT)) & SYSCON_AHBCLKCTRLSET_CLK_SET_MASK)
/*! @} */

/* The count of SYSCON_AHBCLKCTRLSET */
#define SYSCON_AHBCLKCTRLSET_COUNT               (3U)

/*! @name AHBCLKCTRLCLR - Clear bits in AHBCLKCTRLn */
/*! @{ */
#define SYSCON_AHBCLKCTRLCLR_CLK_CLR_MASK        (0xFFFFFFFFU)
#define SYSCON_AHBCLKCTRLCLR_CLK_CLR_SHIFT       (0U)
/*! CLK_CLR - Writing ones to this register clears the corresponding bit or bits in the AHBCLKCTRLn
 *    register, if they are implemented. Bits that do not correspond to defined bits in AHBCLKCTRLn
 *    are reserved and only zeroes should be written to them.
 */
#define SYSCON_AHBCLKCTRLCLR_CLK_CLR(x)          (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKCTRLCLR_CLK_CLR_SHIFT)) & SYSCON_AHBCLKCTRLCLR_CLK_CLR_MASK)
/*! @} */

/* The count of SYSCON_AHBCLKCTRLCLR */
#define SYSCON_AHBCLKCTRLCLR_COUNT               (3U)

/*! @name STICKCLKSEL - Systick timer clock source selection */
/*! @{ */
#define SYSCON_STICKCLKSEL_SEL_MASK              (0x7U)
#define SYSCON_STICKCLKSEL_SEL_SHIFT             (0U)
/*! SEL - Systick timer clock source selection
 *  0b000..Main clock (main_clk)
 *  0b001..Watchdog oscillator (wdt_clk)
 *  0b010..RTC oscillator 32 kHz output (32k_clk)
 *  0b011..FRO 12 MHz (fro_12m)
 *  0b100..Reserved setting
 *  0b101..Reserved setting
 *  0b110..Reserved setting
 *  0b111..None, this may be selected to reduce power when no output is needed.
 */
#define SYSCON_STICKCLKSEL_SEL(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_STICKCLKSEL_SEL_SHIFT)) & SYSCON_STICKCLKSEL_SEL_MASK)
/*! @} */

/*! @name MAINCLKSELA - Main clock source select A */
/*! @{ */
#define SYSCON_MAINCLKSELA_SEL_MASK              (0x3U)
#define SYSCON_MAINCLKSELA_SEL_SHIFT             (0U)
/*! SEL - Clock source for main clock source selector A
 *  0b00..FRO 12 MHz (fro_12m)
 *  0b01..CLKIN (clk_in)
 *  0b10..Watchdog oscillator (wdt_clk)
 *  0b11..FRO 96 or 48 MHz (fro_hf)
 */
#define SYSCON_MAINCLKSELA_SEL(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_MAINCLKSELA_SEL_SHIFT)) & SYSCON_MAINCLKSELA_SEL_MASK)
/*! @} */

/*! @name MAINCLKSELB - Main clock source select B */
/*! @{ */
#define SYSCON_MAINCLKSELB_SEL_MASK              (0x3U)
#define SYSCON_MAINCLKSELB_SEL_SHIFT             (0U)
/*! SEL - Clock source for main clock source selector B. Selects the clock source for the main clock.
 *  0b00..MAINCLKSELA. Use the clock source selected in MAINCLKSELA register.
 *  0b01..Reserved setting
 *  0b10..System PLL output (pll_clk)
 *  0b11..RTC oscillator 32 kHz output (32k_clk)
 */
#define SYSCON_MAINCLKSELB_SEL(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_MAINCLKSELB_SEL_SHIFT)) & SYSCON_MAINCLKSELB_SEL_MASK)
/*! @} */

/*! @name CLKOUTSELA - CLKOUT clock source select A */
/*! @{ */
#define SYSCON_CLKOUTSELA_SEL_MASK               (0x7U)
#define SYSCON_CLKOUTSELA_SEL_SHIFT              (0U)
/*! SEL - CLKOUT clock source selection
 *  0b000..Main clock (main_clk)
 *  0b001..CLKIN (clk_in)
 *  0b010..Watchdog oscillator (wdt_clk)
 *  0b011..FRO 96 or 48 MHz (fro_hf)
 *  0b100..PLL output (pll_clk)
 *  0b101..USB PLL clock (usb_pll_clk)
 *  0b110..Audio PLL clock (audio_pll_clk)
 *  0b111..RTC oscillator 32 kHz output (32k_clk)
 */
#define SYSCON_CLKOUTSELA_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_CLKOUTSELA_SEL_SHIFT)) & SYSCON_CLKOUTSELA_SEL_MASK)
/*! @} */

/*! @name SYSPLLCLKSEL - PLL clock source select */
/*! @{ */
#define SYSCON_SYSPLLCLKSEL_SEL_MASK             (0x7U)
#define SYSCON_SYSPLLCLKSEL_SEL_SHIFT            (0U)
/*! SEL - System PLL clock source selection.
 *  0b000..FRO 12 MHz (fro_12m)
 *  0b001..CLKIN (clk_in)
 *  0b011..RTC oscillator 32 kHz output (32k_clk)
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define SYSCON_SYSPLLCLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_SYSPLLCLKSEL_SEL_SHIFT)) & SYSCON_SYSPLLCLKSEL_SEL_MASK)
/*! @} */

/*! @name AUDPLLCLKSEL - Audio PLL clock source select */
/*! @{ */
#define SYSCON_AUDPLLCLKSEL_SEL_MASK             (0x7U)
#define SYSCON_AUDPLLCLKSEL_SEL_SHIFT            (0U)
/*! SEL - Audio PLL clock source selection.
 *  0b000..FRO 12 MHz (fro_12m)
 *  0b001..CLKIN (clk_in)
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define SYSCON_AUDPLLCLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_AUDPLLCLKSEL_SEL_SHIFT)) & SYSCON_AUDPLLCLKSEL_SEL_MASK)
/*! @} */

/*! @name SPIFICLKSEL - SPIFI clock source select */
/*! @{ */
#define SYSCON_SPIFICLKSEL_SEL_MASK              (0x7U)
#define SYSCON_SPIFICLKSEL_SEL_SHIFT             (0U)
/*! SEL - System PLL clock source selection
 *  0b000..Main clock (main_clk)
 *  0b001..System PLL output (pll_clk)
 *  0b010..USB PLL clock (usb_pll_clk)
 *  0b011..FRO 96 or 48 MHz (fro_hf)
 *  0b100..Audio PLL clock (audio_pll_clk)
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define SYSCON_SPIFICLKSEL_SEL(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_SPIFICLKSEL_SEL_SHIFT)) & SYSCON_SPIFICLKSEL_SEL_MASK)
/*! @} */

/*! @name ADCCLKSEL - ADC clock source select */
/*! @{ */
#define SYSCON_ADCCLKSEL_SEL_MASK                (0x7U)
#define SYSCON_ADCCLKSEL_SEL_SHIFT               (0U)
/*! SEL - ADC clock source selection
 *  0b000..FRO 96 or 48 MHz (fro_hf)
 *  0b001..System PLL output (pll_clk)
 *  0b010..USB PLL clock (usb_pll_clk)
 *  0b011..Audio PLL clock (audio_pll_clk)
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define SYSCON_ADCCLKSEL_SEL(x)                  (((uint32_t)(((uint32_t)(x)) << SYSCON_ADCCLKSEL_SEL_SHIFT)) & SYSCON_ADCCLKSEL_SEL_MASK)
/*! @} */

/*! @name USB0CLKSEL - USB0 clock source select */
/*! @{ */
#define SYSCON_USB0CLKSEL_SEL_MASK               (0x7U)
#define SYSCON_USB0CLKSEL_SEL_SHIFT              (0U)
/*! SEL - USB0 device clock source selection.
 *  0b000..FRO 96 or 48 MHz (fro_hf)
 *  0b001..System PLL output (pll_clk)
 *  0b010..USB PLL clock (usb_pll_clk)
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define SYSCON_USB0CLKSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_USB0CLKSEL_SEL_SHIFT)) & SYSCON_USB0CLKSEL_SEL_MASK)
/*! @} */

/*! @name USB1CLKSEL - USB1 clock source select */
/*! @{ */
#define SYSCON_USB1CLKSEL_SEL_MASK               (0x7U)
#define SYSCON_USB1CLKSEL_SEL_SHIFT              (0U)
/*! SEL - USB1 PHY clock source selection.
 *  0b000..Main clock (main_clk)
 *  0b001..System PLL output (pll_clk)
 *  0b010..USB PLL clock (usb_pll_clk)
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define SYSCON_USB1CLKSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_USB1CLKSEL_SEL_SHIFT)) & SYSCON_USB1CLKSEL_SEL_MASK)
/*! @} */

/*! @name FCLKSEL - Flexcomm clock source select */
/*! @{ */
#define SYSCON_FCLKSEL_SEL_MASK                  (0x7U)
#define SYSCON_FCLKSEL_SEL_SHIFT                 (0U)
/*! SEL - Flexcomm clock source selection. One per Flexcomm.
 *  0b000..FRO 12 MHz (fro_12m)
 *  0b001..FRO HF DIV (fro_hf_div)
 *  0b010..Audio PLL clock (audio_pll_clk)
 *  0b011..MCLK pin input, when selected in IOCON (mclk_in)
 *  0b100..FRG clock, the output of the fractional rate generator (frg_clk)
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define SYSCON_FCLKSEL_SEL(x)                    (((uint32_t)(((uint32_t)(x)) << SYSCON_FCLKSEL_SEL_SHIFT)) & SYSCON_FCLKSEL_SEL_MASK)
/*! @} */

/* The count of SYSCON_FCLKSEL */
#define SYSCON_FCLKSEL_COUNT                     (10U)

/*! @name FCLKSEL10 - Flexcomm 10 clock source select */
/*! @{ */
#define SYSCON_FCLKSEL10_SEL_MASK                (0x7U)
#define SYSCON_FCLKSEL10_SEL_SHIFT               (0U)
/*! SEL - Flexcomm clock source selection. One per Flexcomm.
 *  0b000..Main clock (main_clk)
 *  0b001..System PLL output (pll_clk)
 *  0b010..USB PLL clock (usb_pll_clk)
 *  0b011..FRO 96 or 48 MHz (fro_hf)
 *  0b100..Audio PLL clock (audio_pll_clk)
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define SYSCON_FCLKSEL10_SEL(x)                  (((uint32_t)(((uint32_t)(x)) << SYSCON_FCLKSEL10_SEL_SHIFT)) & SYSCON_FCLKSEL10_SEL_MASK)
/*! @} */

/*! @name MCLKCLKSEL - MCLK clock source select */
/*! @{ */
#define SYSCON_MCLKCLKSEL_SEL_MASK               (0x7U)
#define SYSCON_MCLKCLKSEL_SEL_SHIFT              (0U)
/*! SEL - MCLK source select. This may be used by Flexcomms that support I2S, and/or by the digital microphone subsystem.
 *  0b000..FRO HF DIV (fro_hf_div)
 *  0b001..Audio PLL clock (audio_pll_clk)
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define SYSCON_MCLKCLKSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_MCLKCLKSEL_SEL_SHIFT)) & SYSCON_MCLKCLKSEL_SEL_MASK)
/*! @} */

/*! @name FRGCLKSEL - Fractional Rate Generator clock source select */
/*! @{ */
#define SYSCON_FRGCLKSEL_SEL_MASK                (0x7U)
#define SYSCON_FRGCLKSEL_SEL_SHIFT               (0U)
/*! SEL - Fractional Rate Generator clock source select.
 *  0b000..Main clock (main_clk)
 *  0b001..System PLL output (pll_clk)
 *  0b010..FRO 12 MHz (fro_12m)
 *  0b011..FRO 96 or 48 MHz (fro_hf)
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define SYSCON_FRGCLKSEL_SEL(x)                  (((uint32_t)(((uint32_t)(x)) << SYSCON_FRGCLKSEL_SEL_SHIFT)) & SYSCON_FRGCLKSEL_SEL_MASK)
/*! @} */

/*! @name DMICCLKSEL - Digital microphone (DMIC) subsystem clock select */
/*! @{ */
#define SYSCON_DMICCLKSEL_SEL_MASK               (0x7U)
#define SYSCON_DMICCLKSEL_SEL_SHIFT              (0U)
/*! SEL - DMIC (audio subsystem) clock source select.
 *  0b000..FRO 12 MHz (fro_12m)
 *  0b001..FRO HF DIV (fro_hf_div)
 *  0b010..Audio PLL clock (audio_pll_clk)
 *  0b011..MCLK pin input, when selected in IOCON (mclk_in)
 *  0b100..Main clock (main_clk)
 *  0b101..Watchdog oscillator (wdt_clk)
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define SYSCON_DMICCLKSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_DMICCLKSEL_SEL_SHIFT)) & SYSCON_DMICCLKSEL_SEL_MASK)
/*! @} */

/*! @name SCTCLKSEL - SCTimer/PWM clock source select */
/*! @{ */
#define SYSCON_SCTCLKSEL_SEL_MASK                (0x7U)
#define SYSCON_SCTCLKSEL_SEL_SHIFT               (0U)
/*! SEL - SCT clock source select.
 *  0b000..Main clock (main_clk)
 *  0b001..System PLL output (pll_clk)
 *  0b010..FRO 96 or 48 MHz (fro_hf)
 *  0b011..Audio PLL clock (audio_pll_clk)
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define SYSCON_SCTCLKSEL_SEL(x)                  (((uint32_t)(((uint32_t)(x)) << SYSCON_SCTCLKSEL_SEL_SHIFT)) & SYSCON_SCTCLKSEL_SEL_MASK)
/*! @} */

/*! @name LCDCLKSEL - LCD clock source select */
/*! @{ */
#define SYSCON_LCDCLKSEL_SEL_MASK                (0x3U)
#define SYSCON_LCDCLKSEL_SEL_SHIFT               (0U)
/*! SEL - LCD clock source select.
 *  0b00..Main clock (main_clk)
 *  0b01..LCDCLKIN (LCDCLK_EXT)
 *  0b10..FRO 96 or 48 MHz (fro_hf)
 *  0b11..None, this may be selected in order to reduce power when no output is needed.
 */
#define SYSCON_LCDCLKSEL_SEL(x)                  (((uint32_t)(((uint32_t)(x)) << SYSCON_LCDCLKSEL_SEL_SHIFT)) & SYSCON_LCDCLKSEL_SEL_MASK)
/*! @} */

/*! @name SDIOCLKSEL - SDIO clock source select */
/*! @{ */
#define SYSCON_SDIOCLKSEL_SEL_MASK               (0x7U)
#define SYSCON_SDIOCLKSEL_SEL_SHIFT              (0U)
/*! SEL - SDIO clock source select.
 *  0b000..Main clock (main_clk)
 *  0b001..System PLL output (pll_clk)
 *  0b010..USB PLL clock (usb_pll_clk)
 *  0b011..FRO 96 or 48 MHz (fro_hf)
 *  0b100..Audio PLL clock (audio_pll_clk)
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define SYSCON_SDIOCLKSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_SDIOCLKSEL_SEL_SHIFT)) & SYSCON_SDIOCLKSEL_SEL_MASK)
/*! @} */

/*! @name SYSTICKCLKDIV - SYSTICK clock divider */
/*! @{ */
#define SYSCON_SYSTICKCLKDIV_DIV_MASK            (0xFFU)
#define SYSCON_SYSTICKCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock divider value. 0: Divide by 1 up to 255: Divide by 256.
 */
#define SYSCON_SYSTICKCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << SYSCON_SYSTICKCLKDIV_DIV_SHIFT)) & SYSCON_SYSTICKCLKDIV_DIV_MASK)
#define SYSCON_SYSTICKCLKDIV_RESET_MASK          (0x20000000U)
#define SYSCON_SYSTICKCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define SYSCON_SYSTICKCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_SYSTICKCLKDIV_RESET_SHIFT)) & SYSCON_SYSTICKCLKDIV_RESET_MASK)
#define SYSCON_SYSTICKCLKDIV_HALT_MASK           (0x40000000U)
#define SYSCON_SYSTICKCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the divider counter.
 */
#define SYSCON_SYSTICKCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_SYSTICKCLKDIV_HALT_SHIFT)) & SYSCON_SYSTICKCLKDIV_HALT_MASK)
#define SYSCON_SYSTICKCLKDIV_REQFLAG_MASK        (0x80000000U)
#define SYSCON_SYSTICKCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag.
 */
#define SYSCON_SYSTICKCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << SYSCON_SYSTICKCLKDIV_REQFLAG_SHIFT)) & SYSCON_SYSTICKCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name ARMTRACECLKDIV - ARM Trace clock divider */
/*! @{ */
#define SYSCON_ARMTRACECLKDIV_DIV_MASK           (0xFFU)
#define SYSCON_ARMTRACECLKDIV_DIV_SHIFT          (0U)
/*! DIV - Clock divider value.
 */
#define SYSCON_ARMTRACECLKDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_ARMTRACECLKDIV_DIV_SHIFT)) & SYSCON_ARMTRACECLKDIV_DIV_MASK)
#define SYSCON_ARMTRACECLKDIV_RESET_MASK         (0x20000000U)
#define SYSCON_ARMTRACECLKDIV_RESET_SHIFT        (29U)
/*! RESET - Resets the divider counter.
 */
#define SYSCON_ARMTRACECLKDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << SYSCON_ARMTRACECLKDIV_RESET_SHIFT)) & SYSCON_ARMTRACECLKDIV_RESET_MASK)
#define SYSCON_ARMTRACECLKDIV_HALT_MASK          (0x40000000U)
#define SYSCON_ARMTRACECLKDIV_HALT_SHIFT         (30U)
/*! HALT - Halts the divider counter.
 */
#define SYSCON_ARMTRACECLKDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_ARMTRACECLKDIV_HALT_SHIFT)) & SYSCON_ARMTRACECLKDIV_HALT_MASK)
#define SYSCON_ARMTRACECLKDIV_REQFLAG_MASK       (0x80000000U)
#define SYSCON_ARMTRACECLKDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider status flag.
 */
#define SYSCON_ARMTRACECLKDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << SYSCON_ARMTRACECLKDIV_REQFLAG_SHIFT)) & SYSCON_ARMTRACECLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name CAN0CLKDIV - MCAN0 clock divider */
/*! @{ */
#define SYSCON_CAN0CLKDIV_DIV_MASK               (0xFFU)
#define SYSCON_CAN0CLKDIV_DIV_SHIFT              (0U)
/*! DIV - Clock divider value.
 */
#define SYSCON_CAN0CLKDIV_DIV(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_CAN0CLKDIV_DIV_SHIFT)) & SYSCON_CAN0CLKDIV_DIV_MASK)
#define SYSCON_CAN0CLKDIV_RESET_MASK             (0x20000000U)
#define SYSCON_CAN0CLKDIV_RESET_SHIFT            (29U)
/*! RESET - Resets the divider counter.
 */
#define SYSCON_CAN0CLKDIV_RESET(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_CAN0CLKDIV_RESET_SHIFT)) & SYSCON_CAN0CLKDIV_RESET_MASK)
#define SYSCON_CAN0CLKDIV_HALT_MASK              (0x40000000U)
#define SYSCON_CAN0CLKDIV_HALT_SHIFT             (30U)
/*! HALT - Halts the divider counter.
 */
#define SYSCON_CAN0CLKDIV_HALT(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_CAN0CLKDIV_HALT_SHIFT)) & SYSCON_CAN0CLKDIV_HALT_MASK)
#define SYSCON_CAN0CLKDIV_REQFLAG_MASK           (0x80000000U)
#define SYSCON_CAN0CLKDIV_REQFLAG_SHIFT          (31U)
/*! REQFLAG - Divider status flag.
 */
#define SYSCON_CAN0CLKDIV_REQFLAG(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_CAN0CLKDIV_REQFLAG_SHIFT)) & SYSCON_CAN0CLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name CAN1CLKDIV - MCAN1 clock divider */
/*! @{ */
#define SYSCON_CAN1CLKDIV_DIV_MASK               (0xFFU)
#define SYSCON_CAN1CLKDIV_DIV_SHIFT              (0U)
/*! DIV - Clock divider value. 0: Divide by 1 up to 255: Divide by 256.
 */
#define SYSCON_CAN1CLKDIV_DIV(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_CAN1CLKDIV_DIV_SHIFT)) & SYSCON_CAN1CLKDIV_DIV_MASK)
#define SYSCON_CAN1CLKDIV_RESET_MASK             (0x20000000U)
#define SYSCON_CAN1CLKDIV_RESET_SHIFT            (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define SYSCON_CAN1CLKDIV_RESET(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_CAN1CLKDIV_RESET_SHIFT)) & SYSCON_CAN1CLKDIV_RESET_MASK)
#define SYSCON_CAN1CLKDIV_HALT_MASK              (0x40000000U)
#define SYSCON_CAN1CLKDIV_HALT_SHIFT             (30U)
/*! HALT - Halts the divider counter.
 */
#define SYSCON_CAN1CLKDIV_HALT(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_CAN1CLKDIV_HALT_SHIFT)) & SYSCON_CAN1CLKDIV_HALT_MASK)
#define SYSCON_CAN1CLKDIV_REQFLAG_MASK           (0x80000000U)
#define SYSCON_CAN1CLKDIV_REQFLAG_SHIFT          (31U)
/*! REQFLAG - Divider status flag.
 */
#define SYSCON_CAN1CLKDIV_REQFLAG(x)             (((uint32_t)(((uint32_t)(x)) << SYSCON_CAN1CLKDIV_REQFLAG_SHIFT)) & SYSCON_CAN1CLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SC0CLKDIV - Smartcard0 clock divider */
/*! @{ */
#define SYSCON_SC0CLKDIV_DIV_MASK                (0xFFU)
#define SYSCON_SC0CLKDIV_DIV_SHIFT               (0U)
/*! DIV - Clock divider value.
 */
#define SYSCON_SC0CLKDIV_DIV(x)                  (((uint32_t)(((uint32_t)(x)) << SYSCON_SC0CLKDIV_DIV_SHIFT)) & SYSCON_SC0CLKDIV_DIV_MASK)
#define SYSCON_SC0CLKDIV_RESET_MASK              (0x20000000U)
#define SYSCON_SC0CLKDIV_RESET_SHIFT             (29U)
/*! RESET - Resets the divider counter.
 */
#define SYSCON_SC0CLKDIV_RESET(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_SC0CLKDIV_RESET_SHIFT)) & SYSCON_SC0CLKDIV_RESET_MASK)
#define SYSCON_SC0CLKDIV_HALT_MASK               (0x40000000U)
#define SYSCON_SC0CLKDIV_HALT_SHIFT              (30U)
/*! HALT - Halts the divider counter.
 */
#define SYSCON_SC0CLKDIV_HALT(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_SC0CLKDIV_HALT_SHIFT)) & SYSCON_SC0CLKDIV_HALT_MASK)
#define SYSCON_SC0CLKDIV_REQFLAG_MASK            (0x80000000U)
#define SYSCON_SC0CLKDIV_REQFLAG_SHIFT           (31U)
/*! REQFLAG - Divider status flag.
 */
#define SYSCON_SC0CLKDIV_REQFLAG(x)              (((uint32_t)(((uint32_t)(x)) << SYSCON_SC0CLKDIV_REQFLAG_SHIFT)) & SYSCON_SC0CLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SC1CLKDIV - Smartcard1 clock divider */
/*! @{ */
#define SYSCON_SC1CLKDIV_DIV_MASK                (0xFFU)
#define SYSCON_SC1CLKDIV_DIV_SHIFT               (0U)
/*! DIV - Clock divider value.
 */
#define SYSCON_SC1CLKDIV_DIV(x)                  (((uint32_t)(((uint32_t)(x)) << SYSCON_SC1CLKDIV_DIV_SHIFT)) & SYSCON_SC1CLKDIV_DIV_MASK)
#define SYSCON_SC1CLKDIV_RESET_MASK              (0x20000000U)
#define SYSCON_SC1CLKDIV_RESET_SHIFT             (29U)
/*! RESET - Resets the divider counter.
 */
#define SYSCON_SC1CLKDIV_RESET(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_SC1CLKDIV_RESET_SHIFT)) & SYSCON_SC1CLKDIV_RESET_MASK)
#define SYSCON_SC1CLKDIV_HALT_MASK               (0x40000000U)
#define SYSCON_SC1CLKDIV_HALT_SHIFT              (30U)
/*! HALT - Halts the divider counter.
 */
#define SYSCON_SC1CLKDIV_HALT(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_SC1CLKDIV_HALT_SHIFT)) & SYSCON_SC1CLKDIV_HALT_MASK)
#define SYSCON_SC1CLKDIV_REQFLAG_MASK            (0x80000000U)
#define SYSCON_SC1CLKDIV_REQFLAG_SHIFT           (31U)
/*! REQFLAG - Divider status flag.
 */
#define SYSCON_SC1CLKDIV_REQFLAG(x)              (((uint32_t)(((uint32_t)(x)) << SYSCON_SC1CLKDIV_REQFLAG_SHIFT)) & SYSCON_SC1CLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name AHBCLKDIV - AHB clock divider */
/*! @{ */
#define SYSCON_AHBCLKDIV_DIV_MASK                (0xFFU)
#define SYSCON_AHBCLKDIV_DIV_SHIFT               (0U)
/*! DIV - Clock divider value. 0: Divide by 1 up to 255: Divide by 256.
 */
#define SYSCON_AHBCLKDIV_DIV(x)                  (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKDIV_DIV_SHIFT)) & SYSCON_AHBCLKDIV_DIV_MASK)
#define SYSCON_AHBCLKDIV_REQFLAG_MASK            (0x80000000U)
#define SYSCON_AHBCLKDIV_REQFLAG_SHIFT           (31U)
/*! REQFLAG - Divider status flag.
 */
#define SYSCON_AHBCLKDIV_REQFLAG(x)              (((uint32_t)(((uint32_t)(x)) << SYSCON_AHBCLKDIV_REQFLAG_SHIFT)) & SYSCON_AHBCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name CLKOUTDIV - CLKOUT clock divider */
/*! @{ */
#define SYSCON_CLKOUTDIV_DIV_MASK                (0xFFU)
#define SYSCON_CLKOUTDIV_DIV_SHIFT               (0U)
/*! DIV - Clock divider value. 0: Divide by 1 up to 255: Divide by 256.
 */
#define SYSCON_CLKOUTDIV_DIV(x)                  (((uint32_t)(((uint32_t)(x)) << SYSCON_CLKOUTDIV_DIV_SHIFT)) & SYSCON_CLKOUTDIV_DIV_MASK)
#define SYSCON_CLKOUTDIV_RESET_MASK              (0x20000000U)
#define SYSCON_CLKOUTDIV_RESET_SHIFT             (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define SYSCON_CLKOUTDIV_RESET(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_CLKOUTDIV_RESET_SHIFT)) & SYSCON_CLKOUTDIV_RESET_MASK)
#define SYSCON_CLKOUTDIV_HALT_MASK               (0x40000000U)
#define SYSCON_CLKOUTDIV_HALT_SHIFT              (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider clock source to be changed
 *    without the risk of a glitch at the output.
 */
#define SYSCON_CLKOUTDIV_HALT(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_CLKOUTDIV_HALT_SHIFT)) & SYSCON_CLKOUTDIV_HALT_MASK)
#define SYSCON_CLKOUTDIV_REQFLAG_MASK            (0x80000000U)
#define SYSCON_CLKOUTDIV_REQFLAG_SHIFT           (31U)
/*! REQFLAG - Divider status flag.
 */
#define SYSCON_CLKOUTDIV_REQFLAG(x)              (((uint32_t)(((uint32_t)(x)) << SYSCON_CLKOUTDIV_REQFLAG_SHIFT)) & SYSCON_CLKOUTDIV_REQFLAG_MASK)
/*! @} */

/*! @name FROHFDIV - FROHF clock divider */
/*! @{ */
#define SYSCON_FROHFDIV_DIV_MASK                 (0xFFU)
#define SYSCON_FROHFDIV_DIV_SHIFT                (0U)
/*! DIV - Clock divider value.
 */
#define SYSCON_FROHFDIV_DIV(x)                   (((uint32_t)(((uint32_t)(x)) << SYSCON_FROHFDIV_DIV_SHIFT)) & SYSCON_FROHFDIV_DIV_MASK)
#define SYSCON_FROHFDIV_RESET_MASK               (0x20000000U)
#define SYSCON_FROHFDIV_RESET_SHIFT              (29U)
/*! RESET - Resets the divider counter.
 */
#define SYSCON_FROHFDIV_RESET(x)                 (((uint32_t)(((uint32_t)(x)) << SYSCON_FROHFDIV_RESET_SHIFT)) & SYSCON_FROHFDIV_RESET_MASK)
#define SYSCON_FROHFDIV_HALT_MASK                (0x40000000U)
#define SYSCON_FROHFDIV_HALT_SHIFT               (30U)
/*! HALT - Halts the divider counter.
 */
#define SYSCON_FROHFDIV_HALT(x)                  (((uint32_t)(((uint32_t)(x)) << SYSCON_FROHFDIV_HALT_SHIFT)) & SYSCON_FROHFDIV_HALT_MASK)
#define SYSCON_FROHFDIV_REQFLAG_MASK             (0x80000000U)
#define SYSCON_FROHFDIV_REQFLAG_SHIFT            (31U)
/*! REQFLAG - Divider status flag.
 */
#define SYSCON_FROHFDIV_REQFLAG(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_FROHFDIV_REQFLAG_SHIFT)) & SYSCON_FROHFDIV_REQFLAG_MASK)
/*! @} */

/*! @name SPIFICLKDIV - SPIFI clock divider */
/*! @{ */
#define SYSCON_SPIFICLKDIV_DIV_MASK              (0xFFU)
#define SYSCON_SPIFICLKDIV_DIV_SHIFT             (0U)
/*! DIV - Clock divider value.
 */
#define SYSCON_SPIFICLKDIV_DIV(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_SPIFICLKDIV_DIV_SHIFT)) & SYSCON_SPIFICLKDIV_DIV_MASK)
#define SYSCON_SPIFICLKDIV_RESET_MASK            (0x20000000U)
#define SYSCON_SPIFICLKDIV_RESET_SHIFT           (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define SYSCON_SPIFICLKDIV_RESET(x)              (((uint32_t)(((uint32_t)(x)) << SYSCON_SPIFICLKDIV_RESET_SHIFT)) & SYSCON_SPIFICLKDIV_RESET_MASK)
#define SYSCON_SPIFICLKDIV_HALT_MASK             (0x40000000U)
#define SYSCON_SPIFICLKDIV_HALT_SHIFT            (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider clock source to be changed
 *    without the risk of a glitch at the output.
 */
#define SYSCON_SPIFICLKDIV_HALT(x)               (((uint32_t)(((uint32_t)(x)) << SYSCON_SPIFICLKDIV_HALT_SHIFT)) & SYSCON_SPIFICLKDIV_HALT_MASK)
#define SYSCON_SPIFICLKDIV_REQFLAG_MASK          (0x80000000U)
#define SYSCON_SPIFICLKDIV_REQFLAG_SHIFT         (31U)
/*! REQFLAG - Divider status flag.
 */
#define SYSCON_SPIFICLKDIV_REQFLAG(x)            (((uint32_t)(((uint32_t)(x)) << SYSCON_SPIFICLKDIV_REQFLAG_SHIFT)) & SYSCON_SPIFICLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name ADCCLKDIV - ADC clock divider */
/*! @{ */
#define SYSCON_ADCCLKDIV_DIV_MASK                (0xFFU)
#define SYSCON_ADCCLKDIV_DIV_SHIFT               (0U)
/*! DIV - Clock divider value.
 */
#define SYSCON_ADCCLKDIV_DIV(x)                  (((uint32_t)(((uint32_t)(x)) << SYSCON_ADCCLKDIV_DIV_SHIFT)) & SYSCON_ADCCLKDIV_DIV_MASK)
#define SYSCON_ADCCLKDIV_RESET_MASK              (0x20000000U)
#define SYSCON_ADCCLKDIV_RESET_SHIFT             (29U)
/*! RESET - Resets the divider counter.
 */
#define SYSCON_ADCCLKDIV_RESET(x)                (((uint32_t)(((uint32_t)(x)) << SYSCON_ADCCLKDIV_RESET_SHIFT)) & SYSCON_