//###########################################################################
// FILE:   hw_nvic.h
// TITLE:  Macros used when accessing the NVIC hardware.
//###########################################################################
// $TI Release: F28M35x Support Library v206 $
// $Release Date: Thu Mar  5 10:10:30 CST 2015 $
// $Copyright: Copyright (C) 2011-2015 Texas Instruments Incorporated -
//             http://www.ti.com/ ALL RIGHTS RESERVED $
//###########################################################################

#ifndef __HW_NVIC_H__
#define __HW_NVIC_H__

//*****************************************************************************
// The following are defines for the NVIC register addresses.
//*****************************************************************************
#define NVIC_INT_TYPE                0xE000E004 // Interrupt Controller Type
                                                // Reg
#define NVIC_ACTRL                   0xE000E008 // Auxiliary Control Register                                                
#define NVIC_ST_CTRL                 0xE000E010 // SysTick Control and Status
                                                // Reg
#define NVIC_ST_RELOAD               0xE000E014 // SysTick Reload Value
                                                // Register
#define NVIC_ST_CURRENT              0xE000E018 // SysTick Current Value
                                                // Register
#define NVIC_ST_CAL                  0xE000E01C // SysTick Calibration Value
                                                // Reg
#define NVIC_EN0                     0xE000E100 // IRQ 0 to 31 Set Enable
                                                // Register
#define NVIC_EN1                     0xE000E104 // IRQ 32 to 63 Set Enable
                                                // Register
#define NVIC_EN2                     0xE000E108 // IRQ 64 to 95 Set Enable
                                                // Register
#define NVIC_DIS0                    0xE000E180 // IRQ 0 to 31 Clear Enable Reg
#define NVIC_DIS1                    0xE000E184 // IRQ 32 to 63 Clear Enable
                                                // Reg
#define NVIC_DIS2                    0xE000E188 // IRQ 64 to 95 Clear Enable
                                                // Reg
#define NVIC_PEND0                   0xE000E200 // IRQ 0 to 31 Set Pending
                                                // Register
#define NVIC_PEND1                   0xE000E204 // IRQ 32 to 63 Set Pending Reg
#define NVIC_PEND2                   0xE000E208 // IRQ 64 to 95 Set Pending Reg
#define NVIC_UNPEND0                 0xE000E280 // IRQ 0 to 31 Clear Pending
                                                // Reg
#define NVIC_UNPEND1                 0xE000E284 // IRQ 32 to 63 Clear Pending
                                                // Reg
#define NVIC_UNPEND2                 0xE000E288 // IRQ 64 to 95 Clear Pending
                                                // Reg
#define NVIC_ACTIVE0                 0xE000E300 // IRQ 0 to 31 Active Register
#define NVIC_ACTIVE1                 0xE000E304 // IRQ 32 to 63 Active Register
#define NVIC_ACTIVE2                 0xE000E308 // IRQ 64 to 95 Active Register
#define NVIC_PRI0                    0xE000E400 // IRQ 0 to 3 Priority Register
#define NVIC_PRI1                    0xE000E404 // IRQ 4 to 7 Priority Register
#define NVIC_PRI2                    0xE000E408 // IRQ 8 to 11 Priority
                                                // Register
#define NVIC_PRI3                    0xE000E40C // IRQ 12 to 15 Priority
                                                // Register
#define NVIC_PRI4                    0xE000E410 // IRQ 16 to 19 Priority
                                                // Register
#define NVIC_PRI5                    0xE000E414 // IRQ 20 to 23 Priority
                                                // Register
#define NVIC_PRI6                    0xE000E418 // IRQ 24 to 27 Priority
                                                // Register
#define NVIC_PRI7                    0xE000E41C // IRQ 28 to 31 Priority
                                                // Register
#define NVIC_PRI8                    0xE000E420 // IRQ 32 to 35 Priority
                                                // Register
#define NVIC_PRI9                    0xE000E424 // IRQ 36 to 39 Priority
                                                // Register
#define NVIC_PRI10                   0xE000E428 // IRQ 40 to 43 Priority
                                                // Register
#define NVIC_PRI11                   0xE000E42C // IRQ 44 to 47 Priority
                                                // Register
#define NVIC_PRI12                   0xE000E430 // IRQ 48 to 51 Priority
                                                // Register
#define NVIC_PRI13                   0xE000E434 // IRQ 52 to 55 Priority
                                                // Register
#define NVIC_PRI14                   0xE000E438 // IRQ 56 to 59 Priority
                                                // Register
#define NVIC_PRI15                   0xE000E43C // IRQ 60 to 63 Priority
                                                // Register
#define NVIC_PRI16                   0xE000E440 // IRQ 64 to 67 Priority
                                                // Register
#define NVIC_PRI17                   0xE000E444 // IRQ 68 to 71 Priority
                                                // Register
#define NVIC_PRI18                   0xE000E448 // IRQ 72 to 75 Priority
                                                // Register
#define NVIC_PRI19                   0xE000E44C // IRQ 76 to 79 Priority
                                                // Register
#define NVIC_PRI20                   0xE000E450 // IRQ 80 to 83 Priority
                                                // Register
#define NVIC_PRI21                   0xE000E454 // IRQ 84 to 87 Priority
                                                // Register
#define NVIC_PRI22                   0xE000E458 // IRQ 88 to 91 Priority
                                                // Register
#define NVIC_PRI23                   0xE000E45C // IRQ 92 to 95 Priority
                                                // Register
#define NVIC_CPUID                   0xE000ED00 // CPUID Base Register
#define NVIC_INT_CTRL                0xE000ED04 // Interrupt Control State
                                                // Register
#define NVIC_VTABLE                  0xE000ED08 // Vector Table Offset Register
#define NVIC_APINT                   0xE000ED0C // App. Int & Reset Control Reg
#define NVIC_SYS_CTRL                0xE000ED10 // System Control Register
#define NVIC_CFG_CTRL                0xE000ED14 // Configuration Control
                                                // Register
#define NVIC_SYS_PRI1                0xE000ED18 // Sys. Handlers 4 to 7
                                                // Priority
#define NVIC_SYS_PRI2                0xE000ED1C // Sys. Handlers 8 to 11
                                                // Priority
#define NVIC_SYS_PRI3                0xE000ED20 // Sys. Handlers 12 to 15
                                                // Priority
#define NVIC_SYS_HND_CTRL            0xE000ED24 // System Handler Control and
                                                // State
#define NVIC_FAULT_STAT              0xE000ED28 // Configurable Fault Status
                                                // Reg
#define NVIC_HFAULT_STAT             0xE000ED2C // Hard Fault Status Register
#define NVIC_DEBUG_STAT              0xE000ED30 // Debug Status Register
#define NVIC_MM_ADDR                 0xE000ED34 // Mem Manage Address Register
#define NVIC_FAULT_ADDR              0xE000ED38 // Bus Fault Address Register
#define NVIC_MPU_TYPE                0xE000ED90 // MPU Type Register
#define NVIC_MPU_CTRL                0xE000ED94 // MPU Control Register
#define NVIC_MPU_NUMBER              0xE000ED98 // MPU Region Number Register
#define NVIC_MPU_BASE                0xE000ED9C // MPU Region Base Address
                                                // Register
#define NVIC_MPU_ATTR                0xE000EDA0 // MPU Region Attribute & Size
                                                // Reg
#define NVIC_DBG_CTRL                0xE000EDF0 // Debug Control and Status Reg
#define NVIC_DBG_XFER                0xE000EDF4 // Debug Core Reg. Transfer
                                                // Select
#define NVIC_DBG_DATA                0xE000EDF8 // Debug Core Register Data
#define NVIC_DBG_INT                 0xE000EDFC // Debug Reset Interrupt
                                                // Control
#define NVIC_SW_TRIG                 0xE000EF00 // Software Trigger Interrupt
                                                // Reg

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_INT_TYPE register.
//*****************************************************************************
#define NVIC_INT_TYPE_LINES_M        0x0000001F // Number of interrupt lines
                                                // (x32)
#define NVIC_INT_TYPE_LINES_S        0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_ST_CTRL register.
//*****************************************************************************
#define NVIC_ST_CTRL_COUNT           0x00010000 // Count flag
#define NVIC_ST_CTRL_CLK_SRC         0x00000004 // Clock Source
#define NVIC_ST_CTRL_INTEN           0x00000002 // Interrupt enable
#define NVIC_ST_CTRL_ENABLE          0x00000001 // Counter mode

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_ST_RELOAD register.
//*****************************************************************************
#define NVIC_ST_RELOAD_M             0x00FFFFFF // Counter load value
#define NVIC_ST_RELOAD_S             0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_ST_CURRENT
// register.
//*****************************************************************************
#define NVIC_ST_CURRENT_M            0x00FFFFFF // Counter current value
#define NVIC_ST_CURRENT_S            0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_ST_CAL register.
//*****************************************************************************
#define NVIC_ST_CAL_NOREF            0x80000000 // No reference clock
#define NVIC_ST_CAL_SKEW             0x40000000 // Clock skew
#define NVIC_ST_CAL_ONEMS_M          0x00FFFFFF // 1ms reference value
#define NVIC_ST_CAL_ONEMS_S          0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_EN0 register.
//*****************************************************************************
#define NVIC_EN0_INT31               0x80000000 // Interrupt 31 enable
#define NVIC_EN0_INT30               0x40000000 // Interrupt 30 enable
#define NVIC_EN0_INT29               0x20000000 // Interrupt 29 enable
#define NVIC_EN0_INT28               0x10000000 // Interrupt 28 enable
#define NVIC_EN0_INT27               0x08000000 // Interrupt 27 enable
#define NVIC_EN0_INT26               0x04000000 // Interrupt 26 enable
#define NVIC_EN0_INT25               0x02000000 // Interrupt 25 enable
#define NVIC_EN0_INT24               0x01000000 // Interrupt 24 enable
#define NVIC_EN0_INT23               0x00800000 // Interrupt 23 enable
#define NVIC_EN0_INT22               0x00400000 // Interrupt 22 enable
#define NVIC_EN0_INT21               0x00200000 // Interrupt 21 enable
#define NVIC_EN0_INT20               0x00100000 // Interrupt 20 enable
#define NVIC_EN0_INT19               0x00080000 // Interrupt 19 enable
#define NVIC_EN0_INT18               0x00040000 // Interrupt 18 enable
#define NVIC_EN0_INT17               0x00020000 // Interrupt 17 enable
#define NVIC_EN0_INT16               0x00010000 // Interrupt 16 enable
#define NVIC_EN0_INT15               0x00008000 // Interrupt 15 enable
#define NVIC_EN0_INT14               0x00004000 // Interrupt 14 enable
#define NVIC_EN0_INT13               0x00002000 // Interrupt 13 enable
#define NVIC_EN0_INT12               0x00001000 // Interrupt 12 enable
#define NVIC_EN0_INT11               0x00000800 // Interrupt 11 enable
#define NVIC_EN0_INT10               0x00000400 // Interrupt 10 enable
#define NVIC_EN0_INT9                0x00000200 // Interrupt 9 enable
#define NVIC_EN0_INT8                0x00000100 // Interrupt 8 enable
#define NVIC_EN0_INT7                0x00000080 // Interrupt 7 enable
#define NVIC_EN0_INT6                0x00000040 // Interrupt 6 enable
#define NVIC_EN0_INT5                0x00000020 // Interrupt 5 enable
#define NVIC_EN0_INT4                0x00000010 // Interrupt 4 enable
#define NVIC_EN0_INT3                0x00000008 // Interrupt 3 enable
#define NVIC_EN0_INT2                0x00000004 // Interrupt 2 enable
#define NVIC_EN0_INT1                0x00000002 // Interrupt 1 enable
#define NVIC_EN0_INT0                0x00000001 // Interrupt 0 enable

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_EN1 register.
//*****************************************************************************
#define NVIC_EN1_INT63               0x80000000 // Interrupt 63 enable
#define NVIC_EN1_INT62               0x40000000 // Interrupt 62 enable
#define NVIC_EN1_INT61               0x20000000 // Interrupt 61 enable
#define NVIC_EN1_INT60               0x10000000 // Interrupt 60 enable
#define NVIC_EN1_INT59               0x08000000 // Interrupt 59 enable
#define NVIC_EN1_INT58               0x04000000 // Interrupt 58 enable
#define NVIC_EN1_INT57               0x02000000 // Interrupt 57 enable
#define NVIC_EN1_INT56               0x01000000 // Interrupt 56 enable
#define NVIC_EN1_INT55               0x00800000 // Interrupt 55 enable
#define NVIC_EN1_INT54               0x00400000 // Interrupt 54 enable
#define NVIC_EN1_INT53               0x00200000 // Interrupt 53 enable
#define NVIC_EN1_INT52               0x00100000 // Interrupt 52 enable
#define NVIC_EN1_INT51               0x00080000 // Interrupt 51 enable
#define NVIC_EN1_INT50               0x00040000 // Interrupt 50 enable
#define NVIC_EN1_INT49               0x00020000 // Interrupt 49 enable
#define NVIC_EN1_INT48               0x00010000 // Interrupt 48 enable
#define NVIC_EN1_INT47               0x00008000 // Interrupt 47 enable
#define NVIC_EN1_INT46               0x00004000 // Interrupt 46 enable
#define NVIC_EN1_INT45               0x00002000 // Interrupt 45 enable
#define NVIC_EN1_INT44               0x00001000 // Interrupt 44 enable
#define NVIC_EN1_INT43               0x00000800 // Interrupt 43 enable
#define NVIC_EN1_INT42               0x00000400 // Interrupt 42 enable
#define NVIC_EN1_INT41               0x00000200 // Interrupt 41 enable
#define NVIC_EN1_INT40               0x00000100 // Interrupt 40 enable
#define NVIC_EN1_INT39               0x00000080 // Interrupt 39 enable
#define NVIC_EN1_INT38               0x00000040 // Interrupt 38 enable
#define NVIC_EN1_INT37               0x00000020 // Interrupt 37 enable
#define NVIC_EN1_INT36               0x00000010 // Interrupt 36 enable
#define NVIC_EN1_INT35               0x00000008 // Interrupt 35 enable
#define NVIC_EN1_INT34               0x00000004 // Interrupt 34 enable
#define NVIC_EN1_INT33               0x00000002 // Interrupt 33 enable
#define NVIC_EN1_INT32               0x00000001 // Interrupt 32 enable

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_EN2 register.
//*****************************************************************************
#define NVIC_EN2_INT95               0x80000000 // Interrupt 95 enable
#define NVIC_EN2_INT94               0x40000000 // Interrupt 94 enable
#define NVIC_EN2_INT93               0x20000000 // Interrupt 93 enable
#define NVIC_EN2_INT92               0x10000000 // Interrupt 92 enable
#define NVIC_EN2_INT91               0x08000000 // Interrupt 91 enable
#define NVIC_EN2_INT90               0x04000000 // Interrupt 90 enable
#define NVIC_EN2_INT89               0x02000000 // Interrupt 89 enable
#define NVIC_EN2_INT88               0x01000000 // Interrupt 88 enable
#define NVIC_EN2_INT87               0x00800000 // Interrupt 87 enable
#define NVIC_EN2_INT86               0x00400000 // Interrupt 86 enable
#define NVIC_EN2_INT85               0x00200000 // Interrupt 85 enable
#define NVIC_EN2_INT84               0x00100000 // Interrupt 84 enable
#define NVIC_EN2_INT83               0x00080000 // Interrupt 83 enable
#define NVIC_EN2_INT82               0x00040000 // Interrupt 82 enable
#define NVIC_EN2_INT81               0x00020000 // Interrupt 81 enable
#define NVIC_EN2_INT80               0x00010000 // Interrupt 80 enable
#define NVIC_EN2_INT79               0x00008000 // Interrupt 79 enable
#define NVIC_EN2_INT78               0x00004000 // Interrupt 78 enable
#define NVIC_EN2_INT77               0x00002000 // Interrupt 77 enable
#define NVIC_EN2_INT76               0x00001000 // Interrupt 76 enable
#define NVIC_EN2_INT75               0x00000800 // Interrupt 75 enable
#define NVIC_EN2_INT74               0x00000400 // Interrupt 74 enable
#define NVIC_EN2_INT73               0x00000200 // Interrupt 73 enable
#define NVIC_EN2_INT72               0x00000100 // Interrupt 72 enable
#define NVIC_EN2_INT71               0x00000080 // Interrupt 71 enable
#define NVIC_EN2_INT70               0x00000040 // Interrupt 70 enable
#define NVIC_EN2_INT69               0x00000020 // Interrupt 69 enable
#define NVIC_EN2_INT68               0x00000010 // Interrupt 68 enable
#define NVIC_EN2_INT67               0x00000008 // Interrupt 67 enable
#define NVIC_EN2_INT66               0x00000004 // Interrupt 66 enable
#define NVIC_EN2_INT65               0x00000002 // Interrupt 65 enable
#define NVIC_EN2_INT64               0x00000001 // Interrupt 64 enable

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_DIS0 register.
//*****************************************************************************
#define NVIC_DIS0_INT31              0x80000000 // Interrupt 31 disable
#define NVIC_DIS0_INT30              0x40000000 // Interrupt 30 disable
#define NVIC_DIS0_INT29              0x20000000 // Interrupt 29 disable
#define NVIC_DIS0_INT28              0x10000000 // Interrupt 28 disable
#define NVIC_DIS0_INT27              0x08000000 // Interrupt 27 disable
#define NVIC_DIS0_INT26              0x04000000 // Interrupt 26 disable
#define NVIC_DIS0_INT25              0x02000000 // Interrupt 25 disable
#define NVIC_DIS0_INT24              0x01000000 // Interrupt 24 disable
#define NVIC_DIS0_INT23              0x00800000 // Interrupt 23 disable
#define NVIC_DIS0_INT22              0x00400000 // Interrupt 22 disable
#define NVIC_DIS0_INT21              0x00200000 // Interrupt 21 disable
#define NVIC_DIS0_INT20              0x00100000 // Interrupt 20 disable
#define NVIC_DIS0_INT19              0x00080000 // Interrupt 19 disable
#define NVIC_DIS0_INT18              0x00040000 // Interrupt 18 disable
#define NVIC_DIS0_INT17              0x00020000 // Interrupt 17 disable
#define NVIC_DIS0_INT16              0x00010000 // Interrupt 16 disable
#define NVIC_DIS0_INT15              0x00008000 // Interrupt 15 disable
#define NVIC_DIS0_INT14              0x00004000 // Interrupt 14 disable
#define NVIC_DIS0_INT13              0x00002000 // Interrupt 13 disable
#define NVIC_DIS0_INT12              0x00001000 // Interrupt 12 disable
#define NVIC_DIS0_INT11              0x00000800 // Interrupt 11 disable
#define NVIC_DIS0_INT10              0x00000400 // Interrupt 10 disable
#define NVIC_DIS0_INT9               0x00000200 // Interrupt 9 disable
#define NVIC_DIS0_INT8               0x00000100 // Interrupt 8 disable
#define NVIC_DIS0_INT7               0x00000080 // Interrupt 7 disable
#define NVIC_DIS0_INT6               0x00000040 // Interrupt 6 disable
#define NVIC_DIS0_INT5               0x00000020 // Interrupt 5 disable
#define NVIC_DIS0_INT4               0x00000010 // Interrupt 4 disable
#define NVIC_DIS0_INT3               0x00000008 // Interrupt 3 disable
#define NVIC_DIS0_INT2               0x00000004 // Interrupt 2 disable
#define NVIC_DIS0_INT1               0x00000002 // Interrupt 1 disable
#define NVIC_DIS0_INT0               0x00000001 // Interrupt 0 disable

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_DIS1 register.
//*****************************************************************************
#define NVIC_DIS1_INT63              0x80000000 // Interrupt 63 disable
#define NVIC_DIS1_INT62              0x40000000 // Interrupt 62 disable
#define NVIC_DIS1_INT61              0x20000000 // Interrupt 61 disable
#define NVIC_DIS1_INT60              0x10000000 // Interrupt 60 disable
#define NVIC_DIS1_INT59              0x08000000 // Interrupt 59 disable
#define NVIC_DIS1_INT58              0x04000000 // Interrupt 58 disable
#define NVIC_DIS1_INT57              0x02000000 // Interrupt 57 disable
#define NVIC_DIS1_INT56              0x01000000 // Interrupt 56 disable
#define NVIC_DIS1_INT55              0x00800000 // Interrupt 55 disable
#define NVIC_DIS1_INT54              0x00400000 // Interrupt 54 disable
#define NVIC_DIS1_INT53              0x00200000 // Interrupt 53 disable
#define NVIC_DIS1_INT52              0x00100000 // Interrupt 52 disable
#define NVIC_DIS1_INT51              0x00080000 // Interrupt 51 disable
#define NVIC_DIS1_INT50              0x00040000 // Interrupt 50 disable
#define NVIC_DIS1_INT49              0x00020000 // Interrupt 49 disable
#define NVIC_DIS1_INT48              0x00010000 // Interrupt 48 disable
#define NVIC_DIS1_INT47              0x00008000 // Interrupt 47 disable
#define NVIC_DIS1_INT46              0x00004000 // Interrupt 46 disable
#define NVIC_DIS1_INT45              0x00002000 // Interrupt 45 disable
#define NVIC_DIS1_INT44              0x00001000 // Interrupt 44 disable
#define NVIC_DIS1_INT43              0x00000800 // Interrupt 43 disable
#define NVIC_DIS1_INT42              0x00000400 // Interrupt 42 disable
#define NVIC_DIS1_INT41              0x00000200 // Interrupt 41 disable
#define NVIC_DIS1_INT40              0x00000100 // Interrupt 40 disable
#define NVIC_DIS1_INT39              0x00000080 // Interrupt 39 disable
#define NVIC_DIS1_INT38              0x00000040 // Interrupt 38 disable
#define NVIC_DIS1_INT37              0x00000020 // Interrupt 37 disable
#define NVIC_DIS1_INT36              0x00000010 // Interrupt 36 disable
#define NVIC_DIS1_INT35              0x00000008 // Interrupt 35 disable
#define NVIC_DIS1_INT34              0x00000004 // Interrupt 34 disable
#define NVIC_DIS1_INT33              0x00000002 // Interrupt 33 disable
#define NVIC_DIS1_INT32              0x00000001 // Interrupt 32 disable

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_DIS2 register.
//*****************************************************************************
#define NVIC_DIS2_INT95              0x80000000 // Interrupt 95 disable
#define NVIC_DIS2_INT94              0x40000000 // Interrupt 94 disable
#define NVIC_DIS2_INT93              0x20000000 // Interrupt 93 disable
#define NVIC_DIS2_INT92              0x10000000 // Interrupt 92 disable
#define NVIC_DIS2_INT91              0x08000000 // Interrupt 91 disable
#define NVIC_DIS2_INT90              0x04000000 // Interrupt 90 disable
#define NVIC_DIS2_INT89              0x02000000 // Interrupt 89 disable
#define NVIC_DIS2_INT88              0x01000000 // Interrupt 88 disable
#define NVIC_DIS2_INT87              0x00800000 // Interrupt 87 disable
#define NVIC_DIS2_INT86              0x00400000 // Interrupt 86 disable
#define NVIC_DIS2_INT85              0x00200000 // Interrupt 85 disable
#define NVIC_DIS2_INT84              0x00100000 // Interrupt 84 disable
#define NVIC_DIS2_INT83              0x00080000 // Interrupt 83 disable
#define NVIC_DIS2_INT82              0x00040000 // Interrupt 82 disable
#define NVIC_DIS2_INT81              0x00020000 // Interrupt 81 disable
#define NVIC_DIS2_INT80              0x00010000 // Interrupt 80 disable
#define NVIC_DIS2_INT79              0x00008000 // Interrupt 79 disable
#define NVIC_DIS2_INT78              0x00004000 // Interrupt 78 disable
#define NVIC_DIS2_INT77              0x00002000 // Interrupt 77 disable
#define NVIC_DIS2_INT76              0x00001000 // Interrupt 76 disable
#define NVIC_DIS2_INT75              0x00000800 // Interrupt 75 disable
#define NVIC_DIS2_INT74              0x00000400 // Interrupt 74 disable
#define NVIC_DIS2_INT73              0x00000200 // Interrupt 73 disable
#define NVIC_DIS2_INT72              0x00000100 // Interrupt 72 disable
#define NVIC_DIS2_INT71              0x00000800 // Interrupt 71 disable
#define NVIC_DIS2_INT70              0x00000400 // Interrupt 70 disable
#define NVIC_DIS2_INT69              0x00000200 // Interrupt 69 disable
#define NVIC_DIS2_INT68              0x00000100 // Interrupt 68 disable
#define NVIC_DIS2_INT67              0x00000080 // Interrupt 67 disable
#define NVIC_DIS2_INT66              0x00000040 // Interrupt 66 disable
#define NVIC_DIS2_INT65              0x00000020 // Interrupt 65 disable
#define NVIC_DIS2_INT64              0x00000010 // Interrupt 64 disable
#define NVIC_DIS2_INT63              0x00000008 // Interrupt 63 disable
#define NVIC_DIS2_INT62              0x00000004 // Interrupt 62 disable
#define NVIC_DIS2_INT61              0x00000002 // Interrupt 61 disable
#define NVIC_DIS2_INT60              0x00000001 // Interrupt 60 disable

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_PEND0 register.
//*****************************************************************************
#define NVIC_PEND0_INT31             0x80000000 // Interrupt 31 pend
#define NVIC_PEND0_INT30             0x40000000 // Interrupt 30 pend
#define NVIC_PEND0_INT29             0x20000000 // Interrupt 29 pend
#define NVIC_PEND0_INT28             0x10000000 // Interrupt 28 pend
#define NVIC_PEND0_INT27             0x08000000 // Interrupt 27 pend
#define NVIC_PEND0_INT26             0x04000000 // Interrupt 26 pend
#define NVIC_PEND0_INT25             0x02000000 // Interrupt 25 pend
#define NVIC_PEND0_INT24             0x01000000 // Interrupt 24 pend
#define NVIC_PEND0_INT23             0x00800000 // Interrupt 23 pend
#define NVIC_PEND0_INT22             0x00400000 // Interrupt 22 pend
#define NVIC_PEND0_INT21             0x00200000 // Interrupt 21 pend
#define NVIC_PEND0_INT20             0x00100000 // Interrupt 20 pend
#define NVIC_PEND0_INT19             0x00080000 // Interrupt 19 pend
#define NVIC_PEND0_INT18             0x00040000 // Interrupt 18 pend
#define NVIC_PEND0_INT17             0x00020000 // Interrupt 17 pend
#define NVIC_PEND0_INT16             0x00010000 // Interrupt 16 pend
#define NVIC_PEND0_INT15             0x00008000 // Interrupt 15 pend
#define NVIC_PEND0_INT14             0x00004000 // Interrupt 14 pend
#define NVIC_PEND0_INT13             0x00002000 // Interrupt 13 pend
#define NVIC_PEND0_INT12             0x00001000 // Interrupt 12 pend
#define NVIC_PEND0_INT11             0x00000800 // Interrupt 11 pend
#define NVIC_PEND0_INT10             0x00000400 // Interrupt 10 pend
#define NVIC_PEND0_INT9              0x00000200 // Interrupt 9 pend
#define NVIC_PEND0_INT8              0x00000100 // Interrupt 8 pend
#define NVIC_PEND0_INT7              0x00000080 // Interrupt 7 pend
#define NVIC_PEND0_INT6              0x00000040 // Interrupt 6 pend
#define NVIC_PEND0_INT5              0x00000020 // Interrupt 5 pend
#define NVIC_PEND0_INT4              0x00000010 // Interrupt 4 pend
#define NVIC_PEND0_INT3              0x00000008 // Interrupt 3 pend
#define NVIC_PEND0_INT2              0x00000004 // Interrupt 2 pend
#define NVIC_PEND0_INT1              0x00000002 // Interrupt 1 pend
#define NVIC_PEND0_INT0              0x00000001 // Interrupt 0 pend

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_PEND1 register.
//*****************************************************************************
#define NVIC_PEND1_INT63             0x80000000 // Interrupt 63 pend
#define NVIC_PEND1_INT62             0x40000000 // Interrupt 62 pend
#define NVIC_PEND1_INT61             0x20000000 // Interrupt 61 pend
#define NVIC_PEND1_INT60             0x10000000 // Interrupt 60 pend
#define NVIC_PEND1_INT59             0x08000000 // Interrupt 59 pend
#define NVIC_PEND1_INT58             0x04000000 // Interrupt 58 pend
#define NVIC_PEND1_INT57             0x02000000 // Interrupt 57 pend
#define NVIC_PEND1_INT56             0x01000000 // Interrupt 56 pend
#define NVIC_PEND1_INT55             0x00800000 // Interrupt 55 pend
#define NVIC_PEND1_INT54             0x00400000 // Interrupt 54 pend
#define NVIC_PEND1_INT53             0x00200000 // Interrupt 53 pend
#define NVIC_PEND1_INT52             0x00100000 // Interrupt 52 pend
#define NVIC_PEND1_INT51             0x00080000 // Interrupt 51 pend
#define NVIC_PEND1_INT50             0x00040000 // Interrupt 50 pend
#define NVIC_PEND1_INT49             0x00020000 // Interrupt 49 pend
#define NVIC_PEND1_INT48             0x00010000 // Interrupt 48 pend
#define NVIC_PEND1_INT47             0x00008000 // Interrupt 47 pend
#define NVIC_PEND1_INT46             0x00004000 // Interrupt 46 pend
#define NVIC_PEND1_INT45             0x00002000 // Interrupt 45 pend
#define NVIC_PEND1_INT44             0x00001000 // Interrupt 44 pend
#define NVIC_PEND1_INT43             0x00000800 // Interrupt 43 pend
#define NVIC_PEND1_INT42             0x00000400 // Interrupt 42 pend
#define NVIC_PEND1_INT41             0x00000200 // Interrupt 41 pend
#define NVIC_PEND1_INT40             0x00000100 // Interrupt 40 pend
#define NVIC_PEND1_INT39             0x00000080 // Interrupt 39 pend
#define NVIC_PEND1_INT38             0x00000040 // Interrupt 38 pend
#define NVIC_PEND1_INT37             0x00000020 // Interrupt 37 pend
#define NVIC_PEND1_INT36             0x00000010 // Interrupt 36 pend
#define NVIC_PEND1_INT35             0x00000008 // Interrupt 35 pend
#define NVIC_PEND1_INT34             0x00000004 // Interrupt 34 pend
#define NVIC_PEND1_INT33             0x00000002 // Interrupt 33 pend
#define NVIC_PEND1_INT32             0x00000001 // Interrupt 32 pend

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_PEND2 register.
//*****************************************************************************
#define NVIC_PEND2_INT95             0x80000000 // Interrupt 95 pend
#define NVIC_PEND2_INT94             0x40000000 // Interrupt 94 pend
#define NVIC_PEND2_INT93             0x20000000 // Interrupt 93 pend
#define NVIC_PEND2_INT92             0x10000000 // Interrupt 92 pend
#define NVIC_PEND2_INT91             0x08000000 // Interrupt 91 pend
#define NVIC_PEND2_INT90             0x04000000 // Interrupt 90 pend
#define NVIC_PEND2_INT89             0x02000000 // Interrupt 89 pend
#define NVIC_PEND2_INT88             0x01000000 // Interrupt 88 pend
#define NVIC_PEND2_INT87             0x00800000 // Interrupt 87 pend
#define NVIC_PEND2_INT86             0x00400000 // Interrupt 86 pend
#define NVIC_PEND2_INT85             0x00200000 // Interrupt 85 pend
#define NVIC_PEND2_INT84             0x00100000 // Interrupt 84 pend
#define NVIC_PEND2_INT83             0x00080000 // Interrupt 83 pend
#define NVIC_PEND2_INT82             0x00040000 // Interrupt 82 pend
#define NVIC_PEND2_INT81             0x00020000 // Interrupt 81 pend
#define NVIC_PEND2_INT80             0x00010000 // Interrupt 80 pend
#define NVIC_PEND2_INT79             0x00008000 // Interrupt 79 pend
#define NVIC_PEND2_INT78             0x00004000 // Interrupt 78 pend
#define NVIC_PEND2_INT77             0x00002000 // Interrupt 77 pend
#define NVIC_PEND2_INT76             0x00001000 // Interrupt 76 pend
#define NVIC_PEND2_INT75             0x00000800 // Interrupt 75 pend
#define NVIC_PEND2_INT74             0x00000400 // Interrupt 74 pend
#define NVIC_PEND2_INT73             0x00000200 // Interrupt 73 pend
#define NVIC_PEND2_INT72             0x00000100 // Interrupt 72 pend
#define NVIC_PEND2_INT71             0x00000800 // Interrupt 71 pend
#define NVIC_PEND2_INT70             0x00000400 // Interrupt 70 pend
#define NVIC_PEND2_INT69             0x00000200 // Interrupt 69 pend
#define NVIC_PEND2_INT68             0x00000100 // Interrupt 68 pend
#define NVIC_PEND2_INT67             0x00000080 // Interrupt 67 pend
#define NVIC_PEND2_INT66             0x00000040 // Interrupt 66 pend
#define NVIC_PEND2_INT65             0x00000020 // Interrupt 65 pend
#define NVIC_PEND2_INT64             0x00000010 // Interrupt 64 pend
#define NVIC_PEND2_INT63             0x00000008 // Interrupt 63 pend
#define NVIC_PEND2_INT62             0x00000004 // Interrupt 62 pend
#define NVIC_PEND2_INT61             0x00000002 // Interrupt 61 pend
#define NVIC_PEND2_INT60             0x00000001 // Interrupt 60 pend

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_UNPEND0 register.
//*****************************************************************************
#define NVIC_UNPEND0_INT31           0x80000000 // Interrupt 31 unpend
#define NVIC_UNPEND0_INT30           0x40000000 // Interrupt 30 unpend
#define NVIC_UNPEND0_INT29           0x20000000 // Interrupt 29 unpend
#define NVIC_UNPEND0_INT28           0x10000000 // Interrupt 28 unpend
#define NVIC_UNPEND0_INT27           0x08000000 // Interrupt 27 unpend
#define NVIC_UNPEND0_INT26           0x04000000 // Interrupt 26 unpend
#define NVIC_UNPEND0_INT25           0x02000000 // Interrupt 25 unpend
#define NVIC_UNPEND0_INT24           0x01000000 // Interrupt 24 unpend
#define NVIC_UNPEND0_INT23           0x00800000 // Interrupt 23 unpend
#define NVIC_UNPEND0_INT22           0x00400000 // Interrupt 22 unpend
#define NVIC_UNPEND0_INT21           0x00200000 // Interrupt 21 unpend
#define NVIC_UNPEND0_INT20           0x00100000 // Interrupt 20 unpend
#define NVIC_UNPEND0_INT19           0x00080000 // Interrupt 19 unpend
#define NVIC_UNPEND0_INT18           0x00040000 // Interrupt 18 unpend
#define NVIC_UNPEND0_INT17           0x00020000 // Interrupt 17 unpend
#define NVIC_UNPEND0_INT16           0x00010000 // Interrupt 16 unpend
#define NVIC_UNPEND0_INT15           0x00008000 // Interrupt 15 unpend
#define NVIC_UNPEND0_INT14           0x00004000 // Interrupt 14 unpend
#define NVIC_UNPEND0_INT13           0x00002000 // Interrupt 13 unpend
#define NVIC_UNPEND0_INT12           0x00001000 // Interrupt 12 unpend
#define NVIC_UNPEND0_INT11           0x00000800 // Interrupt 11 unpend
#define NVIC_UNPEND0_INT10           0x00000400 // Interrupt 10 unpend
#define NVIC_UNPEND0_INT9            0x00000200 // Interrupt 9 unpend
#define NVIC_UNPEND0_INT8            0x00000100 // Interrupt 8 unpend
#define NVIC_UNPEND0_INT7            0x00000080 // Interrupt 7 unpend
#define NVIC_UNPEND0_INT6            0x00000040 // Interrupt 6 unpend
#define NVIC_UNPEND0_INT5            0x00000020 // Interrupt 5 unpend
#define NVIC_UNPEND0_INT4            0x00000010 // Interrupt 4 unpend
#define NVIC_UNPEND0_INT3            0x00000008 // Interrupt 3 unpend
#define NVIC_UNPEND0_INT2            0x00000004 // Interrupt 2 unpend
#define NVIC_UNPEND0_INT1            0x00000002 // Interrupt 1 unpend
#define NVIC_UNPEND0_INT0            0x00000001 // Interrupt 0 unpend

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_UNPEND1 register.
//*****************************************************************************
#define NVIC_UNPEND1_INT63           0x80000000 // Interrupt 63 unpend
#define NVIC_UNPEND1_INT62           0x40000000 // Interrupt 62 unpend
#define NVIC_UNPEND1_INT61           0x20000000 // Interrupt 61 unpend
#define NVIC_UNPEND1_INT60           0x10000000 // Interrupt 60 unpend
#define NVIC_UNPEND1_INT59           0x08000000 // Interrupt 59 unpend
#define NVIC_UNPEND1_INT58           0x04000000 // Interrupt 58 unpend
#define NVIC_UNPEND1_INT57           0x02000000 // Interrupt 57 unpend
#define NVIC_UNPEND1_INT56           0x01000000 // Interrupt 56 unpend
#define NVIC_UNPEND1_INT55           0x00800000 // Interrupt 55 unpend
#define NVIC_UNPEND1_INT54           0x00400000 // Interrupt 54 unpend
#define NVIC_UNPEND1_INT53           0x00200000 // Interrupt 53 unpend
#define NVIC_UNPEND1_INT52           0x00100000 // Interrupt 52 unpend
#define NVIC_UNPEND1_INT51           0x00080000 // Interrupt 51 unpend
#define NVIC_UNPEND1_INT50           0x00040000 // Interrupt 50 unpend
#define NVIC_UNPEND1_INT49           0x00020000 // Interrupt 49 unpend
#define NVIC_UNPEND1_INT48           0x00010000 // Interrupt 48 unpend
#define NVIC_UNPEND1_INT47           0x00008000 // Interrupt 47 unpend
#define NVIC_UNPEND1_INT46           0x00004000 // Interrupt 46 unpend
#define NVIC_UNPEND1_INT45           0x00002000 // Interrupt 45 unpend
#define NVIC_UNPEND1_INT44           0x00001000 // Interrupt 44 unpend
#define NVIC_UNPEND1_INT43           0x00000800 // Interrupt 43 unpend
#define NVIC_UNPEND1_INT42           0x00000400 // Interrupt 42 unpend
#define NVIC_UNPEND1_INT41           0x00000200 // Interrupt 41 unpend
#define NVIC_UNPEND1_INT40           0x00000100 // Interrupt 40 unpend
#define NVIC_UNPEND1_INT39           0x00000080 // Interrupt 39 unpend
#define NVIC_UNPEND1_INT38           0x00000040 // Interrupt 38 unpend
#define NVIC_UNPEND1_INT37           0x00000020 // Interrupt 37 unpend
#define NVIC_UNPEND1_INT36           0x00000010 // Interrupt 36 unpend
#define NVIC_UNPEND1_INT35           0x00000008 // Interrupt 35 unpend
#define NVIC_UNPEND1_INT34           0x00000004 // Interrupt 34 unpend
#define NVIC_UNPEND1_INT33           0x00000002 // Interrupt 33 unpend
#define NVIC_UNPEND1_INT32           0x00000001 // Interrupt 32 unpend

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_UNPEND2 register.
//*****************************************************************************
#define NVIC_UNPEND2_INT95           0x80000000 // Interrupt 95 unpend
#define NVIC_UNPEND2_INT94           0x40000000 // Interrupt 94 unpend
#define NVIC_UNPEND2_INT93           0x20000000 // Interrupt 93 unpend
#define NVIC_UNPEND2_INT92           0x10000000 // Interrupt 92 unpend
#define NVIC_UNPEND2_INT91           0x08000000 // Interrupt 91 unpend
#define NVIC_UNPEND2_INT90           0x04000000 // Interrupt 90 unpend
#define NVIC_UNPEND2_INT89           0x02000000 // Interrupt 89 unpend
#define NVIC_UNPEND2_INT88           0x01000000 // Interrupt 88 unpend
#define NVIC_UNPEND2_INT87           0x00800000 // Interrupt 87 unpend
#define NVIC_UNPEND2_INT86           0x00400000 // Interrupt 86 unpend
#define NVIC_UNPEND2_INT85           0x00200000 // Interrupt 85 unpend
#define NVIC_UNPEND2_INT84           0x00100000 // Interrupt 84 unpend
#define NVIC_UNPEND2_INT83           0x00080000 // Interrupt 83 unpend
#define NVIC_UNPEND2_INT82           0x00040000 // Interrupt 82 unpend
#define NVIC_UNPEND2_INT81           0x00020000 // Interrupt 81 unpend
#define NVIC_UNPEND2_INT80           0x00010000 // Interrupt 80 unpend
#define NVIC_UNPEND2_INT79           0x00008000 // Interrupt 79 unpend
#define NVIC_UNPEND2_INT78           0x00004000 // Interrupt 78 unpend
#define NVIC_UNPEND2_INT77           0x00002000 // Interrupt 77 unpend
#define NVIC_UNPEND2_INT76           0x00001000 // Interrupt 76 unpend
#define NVIC_UNPEND2_INT75           0x00000800 // Interrupt 75 unpend
#define NVIC_UNPEND2_INT74           0x00000400 // Interrupt 74 unpend
#define NVIC_UNPEND2_INT73           0x00000200 // Interrupt 73 unpend
#define NVIC_UNPEND2_INT72           0x00000100 // Interrupt 72 unpend
#define NVIC_UNPEND2_INT71           0x00000800 // Interrupt 71 unpend
#define NVIC_UNPEND2_INT70           0x00000400 // Interrupt 70 unpend
#define NVIC_UNPEND2_INT69           0x00000200 // Interrupt 69 unpend
#define NVIC_UNPEND2_INT68           0x00000100 // Interrupt 68 unpend
#define NVIC_UNPEND2_INT67           0x00000080 // Interrupt 67 unpend
#define NVIC_UNPEND2_INT66           0x00000040 // Interrupt 66 unpend
#define NVIC_UNPEND2_INT65           0x00000020 // Interrupt 65 unpend
#define NVIC_UNPEND2_INT64           0x00000010 // Interrupt 64 unpend
#define NVIC_UNPEND2_INT63           0x00000008 // Interrupt 63 unpend
#define NVIC_UNPEND2_INT62           0x00000004 // Interrupt 62 unpend
#define NVIC_UNPEND2_INT61           0x00000002 // Interrupt 61 unpend
#define NVIC_UNPEND2_INT60           0x00000001 // Interrupt 60 unpend

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_ACTIVE0 register.
//*****************************************************************************
#define NVIC_ACTIVE0_INT31           0x80000000 // Interrupt 31 active
#define NVIC_ACTIVE0_INT30           0x40000000 // Interrupt 30 active
#define NVIC_ACTIVE0_INT29           0x20000000 // Interrupt 29 active
#define NVIC_ACTIVE0_INT28           0x10000000 // Interrupt 28 active
#define NVIC_ACTIVE0_INT27           0x08000000 // Interrupt 27 active
#define NVIC_ACTIVE0_INT26           0x04000000 // Interrupt 26 active
#define NVIC_ACTIVE0_INT25           0x02000000 // Interrupt 25 active
#define NVIC_ACTIVE0_INT24           0x01000000 // Interrupt 24 active
#define NVIC_ACTIVE0_INT23           0x00800000 // Interrupt 23 active
#define NVIC_ACTIVE0_INT22           0x00400000 // Interrupt 22 active
#define NVIC_ACTIVE0_INT21           0x00200000 // Interrupt 21 active
#define NVIC_ACTIVE0_INT20           0x00100000 // Interrupt 20 active
#define NVIC_ACTIVE0_INT19           0x00080000 // Interrupt 19 active
#define NVIC_ACTIVE0_INT18           0x00040000 // Interrupt 18 active
#define NVIC_ACTIVE0_INT17           0x00020000 // Interrupt 17 active
#define NVIC_ACTIVE0_INT16           0x00010000 // Interrupt 16 active
#define NVIC_ACTIVE0_INT15           0x00008000 // Interrupt 15 active
#define NVIC_ACTIVE0_INT14           0x00004000 // Interrupt 14 active
#define NVIC_ACTIVE0_INT13           0x00002000 // Interrupt 13 active
#define NVIC_ACTIVE0_INT12           0x00001000 // Interrupt 12 active
#define NVIC_ACTIVE0_INT11           0x00000800 // Interrupt 11 active
#define NVIC_ACTIVE0_INT10           0x00000400 // Interrupt 10 active
#define NVIC_ACTIVE0_INT9            0x00000200 // Interrupt 9 active
#define NVIC_ACTIVE0_INT8            0x00000100 // Interrupt 8 active
#define NVIC_ACTIVE0_INT7            0x00000080 // Interrupt 7 active
#define NVIC_ACTIVE0_INT6            0x00000040 // Interrupt 6 active
#define NVIC_ACTIVE0_INT5            0x00000020 // Interrupt 5 active
#define NVIC_ACTIVE0_INT4            0x00000010 // Interrupt 4 active
#define NVIC_ACTIVE0_INT3            0x00000008 // Interrupt 3 active
#define NVIC_ACTIVE0_INT2            0x00000004 // Interrupt 2 active
#define NVIC_ACTIVE0_INT1            0x00000002 // Interrupt 1 active
#define NVIC_ACTIVE0_INT0            0x00000001 // Interrupt 0 active

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_ACTIVE1 register.
//*****************************************************************************
#define NVIC_ACTIVE1_INT63           0x80000000 // Interrupt 63 active
#define NVIC_ACTIVE1_INT62           0x40000000 // Interrupt 62 active
#define NVIC_ACTIVE1_INT61           0x20000000 // Interrupt 61 active
#define NVIC_ACTIVE1_INT60           0x10000000 // Interrupt 60 active
#define NVIC_ACTIVE1_INT59           0x08000000 // Interrupt 59 active
#define NVIC_ACTIVE1_INT58           0x04000000 // Interrupt 58 active
#define NVIC_ACTIVE1_INT57           0x02000000 // Interrupt 57 active
#define NVIC_ACTIVE1_INT56           0x01000000 // Interrupt 56 active
#define NVIC_ACTIVE1_INT55           0x00800000 // Interrupt 55 active
#define NVIC_ACTIVE1_INT54           0x00400000 // Interrupt 54 active
#define NVIC_ACTIVE1_INT53           0x00200000 // Interrupt 53 active
#define NVIC_ACTIVE1_INT52           0x00100000 // Interrupt 52 active
#define NVIC_ACTIVE1_INT51           0x00080000 // Interrupt 51 active
#define NVIC_ACTIVE1_INT50           0x00040000 // Interrupt 50 active
#define NVIC_ACTIVE1_INT49           0x00020000 // Interrupt 49 active
#define NVIC_ACTIVE1_INT48           0x00010000 // Interrupt 48 active
#define NVIC_ACTIVE1_INT47           0x00008000 // Interrupt 47 active
#define NVIC_ACTIVE1_INT46           0x00004000 // Interrupt 46 active
#define NVIC_ACTIVE1_INT45           0x00002000 // Interrupt 45 active
#define NVIC_ACTIVE1_INT44           0x00001000 // Interrupt 44 active
#define NVIC_ACTIVE1_INT43           0x00000800 // Interrupt 43 active
#define NVIC_ACTIVE1_INT42           0x00000400 // Interrupt 42 active
#define NVIC_ACTIVE1_INT41           0x00000200 // Interrupt 41 active
#define NVIC_ACTIVE1_INT40           0x00000100 // Interrupt 40 active
#define NVIC_ACTIVE1_INT39           0x00000080 // Interrupt 39 active
#define NVIC_ACTIVE1_INT38           0x00000040 // Interrupt 38 active
#define NVIC_ACTIVE1_INT37           0x00000020 // Interrupt 37 active
#define NVIC_ACTIVE1_INT36           0x00000010 // Interrupt 36 active
#define NVIC_ACTIVE1_INT35           0x00000008 // Interrupt 35 active
#define NVIC_ACTIVE1_INT34           0x00000004 // Interrupt 34 active
#define NVIC_ACTIVE1_INT33           0x00000002 // Interrupt 33 active
#define NVIC_ACTIVE1_INT32           0x00000001 // Interrupt 32 active

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_ACTIVE2 register.
//*****************************************************************************
#define NVIC_ACTIVE2_INT95           0x80000000 // Interrupt 95 active
#define NVIC_ACTIVE2_INT94           0x40000000 // Interrupt 94 active
#define NVIC_ACTIVE2_INT93           0x20000000 // Interrupt 93 active
#define NVIC_ACTIVE2_INT92           0x10000000 // Interrupt 92 active
#define NVIC_ACTIVE2_INT91           0x08000000 // Interrupt 91 active
#define NVIC_ACTIVE2_INT90           0x04000000 // Interrupt 90 active
#define NVIC_ACTIVE2_INT89           0x02000000 // Interrupt 89 active
#define NVIC_ACTIVE2_INT88           0x01000000 // Interrupt 88 active
#define NVIC_ACTIVE2_INT87           0x00800000 // Interrupt 87 active
#define NVIC_ACTIVE2_INT86           0x00400000 // Interrupt 86 active
#define NVIC_ACTIVE2_INT85           0x00200000 // Interrupt 85 active
#define NVIC_ACTIVE2_INT84           0x00100000 // Interrupt 84 active
#define NVIC_ACTIVE2_INT83           0x00080000 // Interrupt 83 active
#define NVIC_ACTIVE2_INT82           0x00040000 // Interrupt 82 active
#define NVIC_ACTIVE2_INT81           0x00020000 // Interrupt 81 active
#define NVIC_ACTIVE2_INT80           0x00010000 // Interrupt 80 active
#define NVIC_ACTIVE2_INT79           0x00008000 // Interrupt 79 active
#define NVIC_ACTIVE2_INT78           0x00004000 // Interrupt 78 active
#define NVIC_ACTIVE2_INT77           0x00002000 // Interrupt 77 active
#define NVIC_ACTIVE2_INT76           0x00001000 // Interrupt 76 active
#define NVIC_ACTIVE2_INT75           0x00000800 // Interrupt 75 active
#define NVIC_ACTIVE2_INT74           0x00000400 // Interrupt 74 active
#define NVIC_ACTIVE2_INT73           0x00000200 // Interrupt 73 active
#define NVIC_ACTIVE2_INT72           0x00000100 // Interrupt 72 active
#define NVIC_ACTIVE2_INT71           0x00000800 // Interrupt 71 active
#define NVIC_ACTIVE2_INT70           0x00000400 // Interrupt 70 active
#define NVIC_ACTIVE2_INT69           0x00000200 // Interrupt 69 active
#define NVIC_ACTIVE2_INT68           0x00000100 // Interrupt 68 active
#define NVIC_ACTIVE2_INT67           0x00000080 // Interrupt 67 active
#define NVIC_ACTIVE2_INT66           0x00000040 // Interrupt 66 active
#define NVIC_ACTIVE2_INT65           0x00000020 // Interrupt 65 active
#define NVIC_ACTIVE2_INT64           0x00000010 // Interrupt 64 active
#define NVIC_ACTIVE2_INT63           0x00000008 // Interrupt 63 active
#define NVIC_ACTIVE2_INT62           0x00000004 // Interrupt 62 active
#define NVIC_ACTIVE2_INT61           0x00000002 // Interrupt 61 active
#define NVIC_ACTIVE2_INT60           0x00000001 // Interrupt 60 active

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_PRI0 register.
//*****************************************************************************
#define NVIC_PRI0_INT3_M             0xFF000000 // Interrupt 3 priority mask
#define NVIC_PRI0_INT2_M             0x00FF0000 // Interrupt 2 priority mask
#define NVIC_PRI0_INT1_M             0x0000FF00 // Interrupt 1 priority mask
#define NVIC_PRI0_INT0_M             0x000000FF // Interrupt 0 priority mask
#define NVIC_PRI0_INT3_S             24
#define NVIC_PRI0_INT2_S             16
#define NVIC_PRI0_INT1_S             8
#define NVIC_PRI0_INT0_S             0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_PRI1 register.
//*****************************************************************************
#define NVIC_PRI1_INT7_M             0xFF000000 // Interrupt 7 priority mask
#define NVIC_PRI1_INT6_M             0x00FF0000 // Interrupt 6 priority mask
#define NVIC_PRI1_INT5_M             0x0000FF00 // Interrupt 5 priority mask
#define NVIC_PRI1_INT4_M             0x000000FF // Interrupt 4 priority mask
#define NVIC_PRI1_INT7_S             24
#define NVIC_PRI1_INT6_S             16
#define NVIC_PRI1_INT5_S             8
#define NVIC_PRI1_INT4_S             0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_PRI2 register.
//*****************************************************************************
#define NVIC_PRI2_INT11_M            0xFF000000 // Interrupt 11 priority mask
#define NVIC_PRI2_INT10_M            0x00FF0000 // Interrupt 10 priority mask
#define NVIC_PRI2_INT9_M             0x0000FF00 // Interrupt 9 priority mask
#define NVIC_PRI2_INT8_M             0x000000FF // Interrupt 8 priority mask
#define NVIC_PRI2_INT11_S            24
#define NVIC_PRI2_INT10_S            16
#define NVIC_PRI2_INT9_S             8
#define NVIC_PRI2_INT8_S             0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_PRI3 register.
//*****************************************************************************
#define NVIC_PRI3_INT15_M            0xFF000000 // Interrupt 15 priority mask
#define NVIC_PRI3_INT14_M            0x00FF0000 // Interrupt 14 priority mask
#define NVIC_PRI3_INT13_M            0x0000FF00 // Interrupt 13 priority mask
#define NVIC_PRI3_INT12_M            0x000000FF // Interrupt 12 priority mask
#define NVIC_PRI3_INT15_S            24
#define NVIC_PRI3_INT14_S            16
#define NVIC_PRI3_INT13_S            8
#define NVIC_PRI3_INT12_S            0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_PRI4 register.
//*****************************************************************************
#define NVIC_PRI4_INT19_M            0xFF000000 // Interrupt 19 priority mask
#define NVIC_PRI4_INT18_M            0x00FF0000 // Interrupt 18 priority mask
#define NVIC_PRI4_INT17_M            0x0000FF00 // Interrupt 17 priority mask
#define NVIC_PRI4_INT16_M            0x000000FF // Interrupt 16 priority mask
#define NVIC_PRI4_INT19_S            24
#define NVIC_PRI4_INT18_S            16
#define NVIC_PRI4_INT17_S            8
#define NVIC_PRI4_INT16_S            0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_PRI5 register.
//*****************************************************************************
#define NVIC_PRI5_INT23_M            0xFF000000 // Interrupt 23 priority mask
#define NVIC_PRI5_INT22_M            0x00FF0000 // Interrupt 22 priority mask
#define NVIC_PRI5_INT21_M            0x0000FF00 // Interrupt 21 priority mask
#define NVIC_PRI5_INT20_M            0x000000FF // Interrupt 20 priority mask
#define NVIC_PRI5_INT23_S            24
#define NVIC_PRI5_INT22_S            16
#define NVIC_PRI5_INT21_S            8
#define NVIC_PRI5_INT20_S            0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_PRI6 register.
//*****************************************************************************
#define NVIC_PRI6_INT27_M            0xFF000000 // Interrupt 27 priority mask
#define NVIC_PRI6_INT26_M            0x00FF0000 // Interrupt 26 priority mask
#define NVIC_PRI6_INT25_M            0x0000FF00 // Interrupt 25 priority mask
#define NVIC_PRI6_INT24_M            0x000000FF // Interrupt 24 priority mask
#define NVIC_PRI6_INT27_S            24
#define NVIC_PRI6_INT26_S            16
#define NVIC_PRI6_INT25_S            8
#define NVIC_PRI6_INT24_S            0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_PRI7 register.
//*****************************************************************************
#define NVIC_PRI7_INT31_M            0xFF000000 // Interrupt 31 priority mask
#define NVIC_PRI7_INT30_M            0x00FF0000 // Interrupt 30 priority mask
#define NVIC_PRI7_INT29_M            0x0000FF00 // Interrupt 29 priority mask
#define NVIC_PRI7_INT28_M            0x000000FF // Interrupt 28 priority mask
#define NVIC_PRI7_INT31_S            24
#define NVIC_PRI7_INT30_S            16
#define NVIC_PRI7_INT29_S            8
#define NVIC_PRI7_INT28_S            0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_PRI8 register.
//*****************************************************************************
#define NVIC_PRI8_INT35_M            0xFF000000 // Interrupt 35 priority mask
#define NVIC_PRI8_INT34_M            0x00FF0000 // Interrupt 34 priority mask
#define NVIC_PRI8_INT33_M            0x0000FF00 // Interrupt 33 priority mask
#define NVIC_PRI8_INT32_M            0x000000FF // Interrupt 32 priority mask
#define NVIC_PRI8_INT35_S            24
#define NVIC_PRI8_INT34_S            16
#define NVIC_PRI8_INT33_S            8
#define NVIC_PRI8_INT32_S            0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_PRI9 register.
//*****************************************************************************
#define NVIC_PRI9_INT39_M            0xFF000000 // Interrupt 39 priority mask
#define NVIC_PRI9_INT38_M            0x00FF0000 // Interrupt 38 priority mask
#define NVIC_PRI9_INT37_M            0x0000FF00 // Interrupt 37 priority mask
#define NVIC_PRI9_INT36_M            0x000000FF // Interrupt 36 priority mask
#define NVIC_PRI9_INT39_S            24
#define NVIC_PRI9_INT38_S            16
#define NVIC_PRI9_INT37_S            8
#define NVIC_PRI9_INT36_S            0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_PRI10 register.
//*****************************************************************************
#define NVIC_PRI10_INT43_M           0xFF000000 // Interrupt 43 priority mask
#define NVIC_PRI10_INT42_M           0x00FF0000 // Interrupt 42 priority mask
#define NVIC_PRI10_INT41_M           0x0000FF00 // Interrupt 41 priority mask
#define NVIC_PRI10_INT40_M           0x000000FF // Interrupt 40 priority mask
#define NVIC_PRI10_INT43_S           24
#define NVIC_PRI10_INT42_S           16
#define NVIC_PRI10_INT41_S           8
#define NVIC_PRI10_INT40_S           0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_CPUID register.
//*****************************************************************************
#define NVIC_CPUID_IMP_M             0xFF000000 // Implementer
#define NVIC_CPUID_VAR_M             0x00F00000 // Variant
#define NVIC_CPUID_PARTNO_M          0x0000FFF0 // Processor part number
#define NVIC_CPUID_REV_M             0x0000000F // Revision

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_INT_CTRL register.
//*****************************************************************************
#define NVIC_INT_CTRL_NMI_SET        0x80000000 // Pend a NMI
#define NVIC_INT_CTRL_PEND_SV        0x10000000 // Pend a PendSV
#define NVIC_INT_CTRL_UNPEND_SV      0x08000000 // Unpend a PendSV
#define NVIC_INT_CTRL_PENDSTSET      0x04000000 // Set pending SysTick
                                                // interrupt
#define NVIC_INT_CTRL_PENDSTCLR      0x02000000 // Clear pending SysTick
                                                // interrupt
#define NVIC_INT_CTRL_ISR_PRE        0x00800000 // Debug interrupt handling
#define NVIC_INT_CTRL_ISR_PEND       0x00400000 // Debug interrupt pending
#define NVIC_INT_CTRL_VEC_PEN_M      0x003FF000 // Highest pending exception
#define NVIC_INT_CTRL_RET_BASE       0x00000800 // Return to base
#define NVIC_INT_CTRL_VEC_ACT_M      0x000003FF // Current active exception
#define NVIC_INT_CTRL_VEC_PEN_S      12
#define NVIC_INT_CTRL_VEC_ACT_S      0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_VTABLE register.
//*****************************************************************************
#define NVIC_VTABLE_BASE             0x20000000 // Vector table base
#define NVIC_VTABLE_OFFSET_M         0x1FFFFF00 // Vector table offset
#define NVIC_VTABLE_OFFSET_S         8

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_APINT register.
//*****************************************************************************
#define NVIC_APINT_VECTKEY_M         0xFFFF0000 // Vector key mask
#define NVIC_APINT_VECTKEY           0x05FA0000 // Vector key
#define NVIC_APINT_ENDIANESS         0x00008000 // Data endianess
#define NVIC_APINT_PRIGROUP_M        0x00000700 // Priority group
#define NVIC_APINT_PRIGROUP_0_8      0x00000700 // Priority group 0.8 split
#define NVIC_APINT_PRIGROUP_1_7      0x00000600 // Priority group 1.7 split
#define NVIC_APINT_PRIGROUP_2_6      0x00000500 // Priority group 2.6 split
#define NVIC_APINT_PRIGROUP_3_5      0x00000400 // Priority group 3.5 split
#define NVIC_APINT_PRIGROUP_4_4      0x00000300 // Priority group 4.4 split
#define NVIC_APINT_PRIGROUP_5_3      0x00000200 // Priority group 5.3 split
#define NVIC_APINT_PRIGROUP_6_2      0x00000100 // Priority group 6.2 split
#define NVIC_APINT_SYSRESETREQ       0x00000004 // System reset request
#define NVIC_APINT_VECT_CLR_ACT      0x00000002 // Clear active NMI/fault info
#define NVIC_APINT_VECT_RESET        0x00000001 // System reset
#define NVIC_APINT_PRIGROUP_7_1      0x00000000 // Priority group 7.1 split

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_SYS_CTRL register.
//*****************************************************************************
#define NVIC_SYS_CTRL_SEVONPEND      0x00000010 // Wakeup on pend
#define NVIC_SYS_CTRL_SLEEPDEEP      0x00000004 // Deep sleep enable
#define NVIC_SYS_CTRL_SLEEPEXIT      0x00000002 // Sleep on ISR exit

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_CFG_CTRL register.
//*****************************************************************************
#define NVIC_CFG_CTRL_BFHFNMIGN      0x00000100 // Ignore bus fault in
                                                // NMI/fault
#define NVIC_CFG_CTRL_DIV0           0x00000010 // Trap on divide by 0
#define NVIC_CFG_CTRL_UNALIGNED      0x00000008 // Trap on unaligned access
#define NVIC_CFG_CTRL_DEEP_PEND      0x00000004 // Allow deep interrupt trigger
#define NVIC_CFG_CTRL_MAIN_PEND      0x00000002 // Allow main interrupt trigger
#define NVIC_CFG_CTRL_BASE_THR       0x00000001 // Thread state control

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_SYS_PRI1 register.
//*****************************************************************************
#define NVIC_SYS_PRI1_RES_M          0xFF000000 // Priority of reserved handler
#define NVIC_SYS_PRI1_USAGE_M        0x00FF0000 // Priority of usage fault
                                                // handler
#define NVIC_SYS_PRI1_BUS_M          0x0000FF00 // Priority of bus fault
                                                // handler
#define NVIC_SYS_PRI1_MEM_M          0x000000FF // Priority of mem manage
                                                // handler
#define NVIC_SYS_PRI1_USAGE_S        16
#define NVIC_SYS_PRI1_BUS_S          8
#define NVIC_SYS_PRI1_MEM_S          0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_SYS_PRI2 register.
//*****************************************************************************
#define NVIC_SYS_PRI2_SVC_M          0xFF000000 // Priority of SVCall handler
#define NVIC_SYS_PRI2_RES_M          0x00FFFFFF // Priority of reserved
                                                // handlers
#define NVIC_SYS_PRI2_SVC_S          24

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_SYS_PRI3 register.
//*****************************************************************************
#define NVIC_SYS_PRI3_TICK_M         0xFF000000 // Priority of Sys Tick handler
#define NVIC_SYS_PRI3_PENDSV_M       0x00FF0000 // Priority of PendSV handler
#define NVIC_SYS_PRI3_RES_M          0x0000FF00 // Priority of reserved handler
#define NVIC_SYS_PRI3_DEBUG_M        0x000000FF // Priority of debug handler
#define NVIC_SYS_PRI3_TICK_S         24
#define NVIC_SYS_PRI3_PENDSV_S       16
#define NVIC_SYS_PRI3_DEBUG_S        0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_SYS_HND_CTRL
// register.
//*****************************************************************************
#define NVIC_SYS_HND_CTRL_USAGE      0x00040000 // Usage fault enable
#define NVIC_SYS_HND_CTRL_BUS        0x00020000 // Bus fault enable
#define NVIC_SYS_HND_CTRL_MEM        0x00010000 // Mem manage fault enable
#define NVIC_SYS_HND_CTRL_SVC        0x00008000 // SVCall is pended
#define NVIC_SYS_HND_CTRL_BUSP       0x00004000 // Bus fault is pended
#define NVIC_SYS_HND_CTRL_TICK       0x00000800 // Sys tick is active
#define NVIC_SYS_HND_CTRL_PNDSV      0x00000400 // PendSV is active
#define NVIC_SYS_HND_CTRL_MON        0x00000100 // Monitor is active
#define NVIC_SYS_HND_CTRL_SVCA       0x00000080 // SVCall is active
#define NVIC_SYS_HND_CTRL_USGA       0x00000008 // Usage fault is active
#define NVIC_SYS_HND_CTRL_BUSA       0x00000002 // Bus fault is active
#define NVIC_SYS_HND_CTRL_MEMA       0x00000001 // Mem manage is active

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_FAULT_STAT
// register.
//*****************************************************************************
#define NVIC_FAULT_STAT_DIV0         0x02000000 // Divide by zero fault
#define NVIC_FAULT_STAT_UNALIGN      0x01000000 // Unaligned access fault
#define NVIC_FAULT_STAT_NOCP         0x00080000 // No coprocessor fault
#define NVIC_FAULT_STAT_INVPC        0x00040000 // Invalid PC fault
#define NVIC_FAULT_STAT_INVSTAT      0x00020000 // Invalid state fault
#define NVIC_FAULT_STAT_UNDEF        0x00010000 // Undefined instruction fault
#define NVIC_FAULT_STAT_BFARV        0x00008000 // BFAR is valid
#define NVIC_FAULT_STAT_BSTKE        0x00001000 // Stack bus fault
#define NVIC_FAULT_STAT_BUSTKE       0x00000800 // Unstack bus fault
#define NVIC_FAULT_STAT_IMPRE        0x00000400 // Imprecise data bus error
#define NVIC_FAULT_STAT_PRECISE      0x00000200 // Precise data bus error
#define NVIC_FAULT_STAT_IBUS         0x00000100 // Instruction bus fault
#define NVIC_FAULT_STAT_MMARV        0x00000080 // MMAR is valid
#define NVIC_FAULT_STAT_MSTKE        0x00000010 // Stack access violation
#define NVIC_FAULT_STAT_MUSTKE       0x00000008 // Unstack access violation
#define NVIC_FAULT_STAT_DERR         0x00000002 // Data access violation
#define NVIC_FAULT_STAT_IERR         0x00000001 // Instruction access violation

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_HFAULT_STAT
// register.
//*****************************************************************************
#define NVIC_HFAULT_STAT_DBG         0x80000000 // Debug event
#define NVIC_HFAULT_STAT_FORCED      0x40000000 // Cannot execute fault handler
#define NVIC_HFAULT_STAT_VECT        0x00000002 // Vector table read fault

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_DEBUG_STAT
// register.
//*****************************************************************************
#define NVIC_DEBUG_STAT_EXTRNL       0x00000010 // EDBGRQ asserted
#define NVIC_DEBUG_STAT_VCATCH       0x00000008 // Vector catch
#define NVIC_DEBUG_STAT_DWTTRAP      0x00000004 // DWT match
#define NVIC_DEBUG_STAT_BKPT         0x00000002 // Breakpoint instruction
#define NVIC_DEBUG_STAT_HALTED       0x00000001 // Halt request

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_MM_ADDR register.
//*****************************************************************************
#define NVIC_MM_ADDR_M               0xFFFFFFFF // Data fault address
#define NVIC_MM_ADDR_S               0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_FAULT_ADDR
// register.
//*****************************************************************************
#define NVIC_FAULT_ADDR_M            0xFFFFFFFF // Data bus fault address
#define NVIC_FAULT_ADDR_S            0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_MPU_TYPE register.
//*****************************************************************************
#define NVIC_MPU_TYPE_IREGION_M      0x00FF0000 // Number of I regions
#define NVIC_MPU_TYPE_DREGION_M      0x0000FF00 // Number of D regions
#define NVIC_MPU_TYPE_SEPARATE       0x00000001 // Separate or unified MPU
#define NVIC_MPU_TYPE_IREGION_S      16
#define NVIC_MPU_TYPE_DREGION_S      8

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_MPU_CTRL register.
//*****************************************************************************
#define NVIC_MPU_CTRL_PRIVDEFEN      0x00000004 // MPU default region in priv
                                                // mode
#define NVIC_MPU_CTRL_HFNMIENA       0x00000002 // MPU enabled during faults
#define NVIC_MPU_CTRL_ENABLE         0x00000001 // MPU enable

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_MPU_NUMBER
// register.
//*****************************************************************************
#define NVIC_MPU_NUMBER_M            0x000000FF // MPU region to access
#define NVIC_MPU_NUMBER_S            0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_MPU_BASE register.
//*****************************************************************************
#define NVIC_MPU_BASE_ADDR_M         0xFFFFFFE0 // Base address mask
#define NVIC_MPU_BASE_VALID          0x00000010 // Region number valid
#define NVIC_MPU_BASE_REGION_M       0x0000000F // Region number
#define NVIC_MPU_BASE_ADDR_S         8
#define NVIC_MPU_BASE_REGION_S       0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_MPU_ATTR register.
//*****************************************************************************
#define NVIC_MPU_ATTR_M              0xFFFF0000 // Attributes
#define NVIC_MPU_ATTR_AP_NO_NO       0x00000000 // prv: no access, usr: no
                                                // access
#define NVIC_MPU_ATTR_BUFFRABLE      0x00010000 // Bufferable
#define NVIC_MPU_ATTR_CACHEABLE      0x00020000 // Cacheable
#define NVIC_MPU_ATTR_SHAREABLE      0x00040000 // Shareable
#define NVIC_MPU_ATTR_TEX_M          0x00380000 // Type extension mask
#define NVIC_MPU_ATTR_AP_RW_NO       0x01000000 // prv: rw, usr: none
#define NVIC_MPU_ATTR_AP_RW_RO       0x02000000 // prv: rw, usr: read-only
#define NVIC_MPU_ATTR_AP_RW_RW       0x03000000 // prv: rw, usr: rw
#define NVIC_MPU_ATTR_AP_RO_NO       0x05000000 // prv: ro, usr: none
#define NVIC_MPU_ATTR_AP_RO_RO       0x06000000 // prv: ro, usr: ro
#define NVIC_MPU_ATTR_AP_M           0x07000000 // Access permissions mask
#define NVIC_MPU_ATTR_XN             0x10000000 // Execute disable
#define NVIC_MPU_ATTR_SRD_M          0x0000FF00 // Sub-region disable mask
#define NVIC_MPU_ATTR_SRD_0          0x00000100 // Sub-region 0 disable
#define NVIC_MPU_ATTR_SRD_1          0x00000200 // Sub-region 1 disable
#define NVIC_MPU_ATTR_SRD_2          0x00000400 // Sub-region 2 disable
#define NVIC_MPU_ATTR_SRD_3          0x00000800 // Sub-region 3 disable
#define NVIC_MPU_ATTR_SRD_4          0x00001000 // Sub-region 4 disable
#define NVIC_MPU_ATTR_SRD_5          0x00002000 // Sub-region 5 disable
#define NVIC_MPU_ATTR_SRD_6          0x00004000 // Sub-region 6 disable
#define NVIC_MPU_ATTR_SRD_7          0x00008000 // Sub-region 7 disable
#define NVIC_MPU_ATTR_SIZE_M         0x0000003E // Region size mask
#define NVIC_MPU_ATTR_SIZE_32B       0x00000008 // Region size 32 bytes
#define NVIC_MPU_ATTR_SIZE_64B       0x0000000A // Region size 64 bytes
#define NVIC_MPU_ATTR_SIZE_128B      0x0000000C // Region size 128 bytes
#define NVIC_MPU_ATTR_SIZE_256B      0x0000000E // Region size 256 bytes
#define NVIC_MPU_ATTR_SIZE_512B      0x00000010 // Region size 512 bytes
#define NVIC_MPU_ATTR_SIZE_1K        0x00000012 // Region size 1 Kbytes
#define NVIC_MPU_ATTR_SIZE_2K        0x00000014 // Region size 2 Kbytes
#define NVIC_MPU_ATTR_SIZE_4K        0x00000016 // Region size 4 Kbytes
#define NVIC_MPU_ATTR_SIZE_8K        0x00000018 // Region size 8 Kbytes
#define NVIC_MPU_ATTR_SIZE_16K       0x0000001A // Region size 16 Kbytes
#define NVIC_MPU_ATTR_SIZE_32K       0x0000001C // Region size 32 Kbytes
#define NVIC_MPU_ATTR_SIZE_64K       0x0000001E // Region size 64 Kbytes
#define NVIC_MPU_ATTR_SIZE_128K      0x00000020 // Region size 128 Kbytes
#define NVIC_MPU_ATTR_SIZE_256K      0x00000022 // Region size 256 Kbytes
#define NVIC_MPU_ATTR_SIZE_512K      0x00000024 // Region size 512 Kbytes
#define NVIC_MPU_ATTR_SIZE_1M        0x00000026 // Region size 1 Mbytes
#define NVIC_MPU_ATTR_SIZE_2M        0x00000028 // Region size 2 Mbytes
#define NVIC_MPU_ATTR_SIZE_4M        0x0000002A // Region size 4 Mbytes
#define NVIC_MPU_ATTR_SIZE_8M        0x0000002C // Region size 8 Mbytes
#define NVIC_MPU_ATTR_SIZE_16M       0x0000002E // Region size 16 Mbytes
#define NVIC_MPU_ATTR_SIZE_32M       0x00000030 // Region size 32 Mbytes
#define NVIC_MPU_ATTR_SIZE_64M       0x00000032 // Region size 64 Mbytes
#define NVIC_MPU_ATTR_SIZE_128M      0x00000034 // Region size 128 Mbytes
#define NVIC_MPU_ATTR_SIZE_256M      0x00000036 // Region size 256 Mbytes
#define NVIC_MPU_ATTR_SIZE_512M      0x00000038 // Region size 512 Mbytes
#define NVIC_MPU_ATTR_SIZE_1G        0x0000003A // Region size 1 Gbytes
#define NVIC_MPU_ATTR_SIZE_2G        0x0000003C // Region size 2 Gbytes
#define NVIC_MPU_ATTR_SIZE_4G        0x0000003E // Region size 4 Gbytes
#define NVIC_MPU_ATTR_ENABLE         0x00000001 // Region enable

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_DBG_CTRL register.
//*****************************************************************************
#define NVIC_DBG_CTRL_DBGKEY_M       0xFFFF0000 // Debug key mask
#define NVIC_DBG_CTRL_DBGKEY         0xA05F0000 // Debug key
#define NVIC_DBG_CTRL_S_RESET_ST     0x02000000 // Core has reset since last
                                                // read
#define NVIC_DBG_CTRL_S_RETIRE_ST    0x01000000 // Core has executed insruction
                                                // since last read
#define NVIC_DBG_CTRL_S_LOCKUP       0x00080000 // Core is locked up
#define NVIC_DBG_CTRL_S_SLEEP        0x00040000 // Core is sleeping
#define NVIC_DBG_CTRL_S_HALT         0x00020000 // Core status on halt
#define NVIC_DBG_CTRL_S_REGRDY       0x00010000 // Register read/write
                                                // available
#define NVIC_DBG_CTRL_C_SNAPSTALL    0x00000020 // Breaks a stalled load/store
#define NVIC_DBG_CTRL_C_MASKINT      0x00000008 // Mask interrupts when
                                                // stepping
#define NVIC_DBG_CTRL_C_STEP         0x00000004 // Step the core
#define NVIC_DBG_CTRL_C_HALT         0x00000002 // Halt the core
#define NVIC_DBG_CTRL_C_DEBUGEN      0x00000001 // Enable debug

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_DBG_XFER register.
//*****************************************************************************
#define NVIC_DBG_XFER_REG_WNR        0x00010000 // Write or not read
#define NVIC_DBG_XFER_REG_SEL_M      0x0000001F // Register
#define NVIC_DBG_XFER_REG_CFBP       0x00000014 // Control/Fault
                                                // BasePri/PriMask
#define NVIC_DBG_XFER_REG_DSP        0x00000013 // Deep SP
#define NVIC_DBG_XFER_REG_PSP        0x00000012 // Process SP
#define NVIC_DBG_XFER_REG_MSP        0x00000011 // Main SP
#define NVIC_DBG_XFER_REG_FLAGS      0x00000010 // xPSR/Flags register
#define NVIC_DBG_XFER_REG_R15        0x0000000F // Register R15
#define NVIC_DBG_XFER_REG_R14        0x0000000E // Register R14
#define NVIC_DBG_XFER_REG_R13        0x0000000D // Register R13
#define NVIC_DBG_XFER_REG_R12        0x0000000C // Register R12
#define NVIC_DBG_XFER_REG_R11        0x0000000B // Register R11
#define NVIC_DBG_XFER_REG_R10        0x0000000A // Register R10
#define NVIC_DBG_XFER_REG_R9         0x00000009 // Register R9
#define NVIC_DBG_XFER_REG_R8         0x00000008 // Register R8
#define NVIC_DBG_XFER_REG_R7         0x00000007 // Register R7
#define NVIC_DBG_XFER_REG_R6         0x00000006 // Register R6
#define NVIC_DBG_XFER_REG_R5         0x00000005 // Register R5
#define NVIC_DBG_XFER_REG_R4         0x00000004 // Register R4
#define NVIC_DBG_XFER_REG_R3         0x00000003 // Register R3
#define NVIC_DBG_XFER_REG_R2         0x00000002 // Register R2
#define NVIC_DBG_XFER_REG_R1         0x00000001 // Register R1
#define NVIC_DBG_XFER_REG_R0         0x00000000 // Register R0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_DBG_DATA register.
//*****************************************************************************
#define NVIC_DBG_DATA_M              0xFFFFFFFF // Data temporary cache
#define NVIC_DBG_DATA_S              0

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_DBG_INT register.
//*****************************************************************************
#define NVIC_DBG_INT_HARDERR         0x00000400 // Debug trap on hard fault
#define NVIC_DBG_INT_INTERR          0x00000200 // Debug trap on interrupt
                                                // errors
#define NVIC_DBG_INT_BUSERR          0x00000100 // Debug trap on bus error
#define NVIC_DBG_INT_STATERR         0x00000080 // Debug trap on usage fault
                                                // state
#define NVIC_DBG_INT_CHKERR          0x00000040 // Debug trap on usage fault
                                                // check
#define NVIC_DBG_INT_NOCPERR         0x00000020 // Debug trap on coprocessor
                                                // error
#define NVIC_DBG_INT_MMERR           0x00000010 // Debug trap on mem manage
                                                // fault
#define NVIC_DBG_INT_RESET           0x00000008 // Core reset status
#define NVIC_DBG_INT_RSTPENDCLR      0x00000004 // Clear pending core reset
#define NVIC_DBG_INT_RSTPENDING      0x00000002 // Core reset is pending
#define NVIC_DBG_INT_RSTVCATCH       0x00000001 // Reset vector catch

//*****************************************************************************
// The following are defines for the bit fields in the NVIC_SW_TRIG register.
//*****************************************************************************
#define NVIC_SW_TRIG_INTID_M         0x000003FF // Interrupt to trigger
#define NVIC_SW_TRIG_INTID_S         0


#endif // __HW_NVIC_H__



